\defgroup Tutorials Tutorials
\brief A collection of C++ macros, Python scripts and notebooks helping to learn ROOT by example.

You can execute the scripts in `$ROOTSYS/tutorials` (or sub-directories)
by setting your current directory in the script directory or from any
user directory with write access.

Several tutorials create new files. If you have write access to
the tutorials directory, the new files will be created in the tutorials
directory, otherwise they will be created in the user directory.

You can start by executing the standard ROOT demos with a session like:

```
  root > .x demos.C
```
or

```
  root > .x $ROOTSYS/tutorials/demos.C
```

You can execute the standard ROOT graphics benchmark with

```
  root > .x benchmarks.C
```

or

```
  root > .x $ROOTSYS/tutorials/benchmarks.C
```

The `$ROOTSYS/tutorials` directory includes several sub-directories:

\defgroup tutorial_hist Histograms tutorials
\ingroup Tutorials
\brief Examples showing the "histograms' classes" usage.

\defgroup tutorial_tree Tree tutorials
\ingroup Tutorials
\brief Example code which illustrates how to use ROOT trees and ntuples.

\defgroup tutorial_dataframe Data Frame tutorials
\ingroup Tutorials
\brief These examples show various features of [RDataFrame](classROOT_1_1RDataFrame.html): ROOT's declarative analysis interface.

\defgroup tutorial_v7 ROOT 7 tutorials
\ingroup Tutorials
\brief Various examples showing the ROOT 7 interface.

\defgroup tutorial_FOAM FOAM tutorials
\ingroup Tutorials
\brief Examples showing how to use FOAM.

\defgroup tutorial_cont Containers tutorials
\ingroup Tutorials
\brief Examples showing the "containers' classes" usage.

\defgroup tutorial_eve Event display tutorials
\ingroup Tutorials
\brief Examples showing the "Event display classes" usage.

\defgroup tutorial_geom Geometry tutorials
\ingroup Tutorials
\brief Various ROOT geometry package examples.

\defgroup tutorial_fft Fast Fourier Transforms tutorials
\ingroup Tutorials
\brief Example showing the Fast Fourier Transforms interface in ROOT.

\defgroup tutorial_fit Fit Tutorials
\ingroup Tutorials
\brief These tutorials illustrate the main fitting features. Their names are related to the aspect which is treated in the code.

\defgroup tutorial_roofit RooFit Tutorials
\ingroup Tutorials
\brief These tutorials illustrate the main features of RooFit: the name of the examples and their short description help in figuring out their objective.

\defgroup tutorial_graphs Graphs tutorials
\ingroup Tutorials
\brief Examples showing the "graphs classes" usage.

\defgroup tutorial_graphics Graphics tutorials
\ingroup Tutorials
\brief Various examples showing the basic ROOT graphics.

\defgroup tutorial_gl OpenGL tutorials
\ingroup Tutorials
\brief Various examples showing the OpenGL graphics in ROOT.

\defgroup tutorial_cocoa Tutorials specific to Mac/Cocoa
\ingroup Tutorials
\brief Various examples showing graphics done with the Mac graphics system Cocoa.

\defgroup tutorial_gui GUI tutorials
\ingroup Tutorials
\brief Example code which illustrates how to use the ROOT GUI.

\defgroup tutorial_histfactory HistFactory Tutorials
\ingroup Tutorials
\brief These tutorials illustrate the usage of the histfactory.

\defgroup tutorial_http HTTP tutorials
\ingroup Tutorials
\brief Examples showing the HTTP interface.

\defgroup tutorial_image Image tutorials
\ingroup Tutorials
\brief Examples showing the TImage class usage.

\defgroup tutorial_io IO tutorials
\ingroup Tutorials
\brief These tutorials illustrate some of the capabilities of the ROOT IO subsystem.

\defgroup tutorial_math Math tutorials
\ingroup Tutorials
\brief Examples showing the Math classes.

\defgroup tutorial_matrix Matrix tutorials
\ingroup Tutorials
\brief Examples showing how to use TMatrix.

\defgroup tutorial_mc Monte Carlo tutorials
\ingroup Tutorials
\brief Monte Carlo examples.

\defgroup tutorial_multicore Multicore tutorials
\ingroup Tutorials
\brief These examples aim to illustrate the multicore features of ROOT, such as thread awareness and safety, multithreading and multiprocessing.

\defgroup tutorial_net Net tutorials
\ingroup Tutorials
\brief Examples showing the net classes.

\defgroup tutorial_physics Physics tutorials
\ingroup Tutorials
\brief Physics examples.

\defgroup tutorial_pyroot PyRoot tutorials
\ingroup Tutorials
\brief Selected examples illustrating how to use ROOT's Python interface: PyROOT.

\defgroup tutorial_pythia Pythia tutorials
\ingroup Tutorials
\brief Examples showing the pythia usage.

\defgroup tutorial_quadp Quadratic programming package.
\ingroup Tutorials
\brief Example showing the usage of the quadratic programming package quadp.

\defgroup tutorial_r R tutorials
\ingroup Tutorials
\brief Examples showing the R interface.

\defgroup tutorial_roostats RooStats Tutorials
\ingroup Tutorials
\brief These tutorials illustrate the main features of RooStats.

\defgroup tutorial_spectrum Spectrum tutorials
\ingroup Tutorials
\brief Examples showing the TSpectrum and TSpectrumPainter usage.

\defgroup tutorial_splot TSPlot tutorials
\ingroup Tutorials
\brief This tutorial illustrates the use of class TSPlot.

\defgroup tutorial_sql SQL tutorials
\ingroup Tutorials
\brief Examples showing the SQL classes.

\defgroup tutorial_tmva TMVA tutorials
\ingroup Tutorials
\brief Example code which illustrates how to use the TMVA toolkit

\defgroup tutorial_unfold TUnfold tutorials
\ingroup Tutorials
\brief Test programs for the classes TUnfold and related

\defgroup tutorial_unuran Unuran tutorials
\ingroup Tutorials
\brief Examples showing unuran capabilities.

\defgroup tutorial_vecops VecOps tutorials
\ingroup Tutorials
\brief These examples show the functionalities of the VecOps utilities.

\defgroup tutorial_FITS FITS files interface tutorials
\ingroup Tutorials
\brief Examples showing the FITS file interface.

\defgroup tutorial_xml XML tutorials
\ingroup Tutorials
\brief XML examples.

\defgroup tutorial_proof Proof tutorials
\ingroup Tutorials
\brief These examples aim to illustrate the usage of PROOF

\defgroup tutorial_legacy Legacy tutorials
\ingroup Tutorials
\brief Legacy Tutorials
