\defgroup tutorial_ProcFileElements ProcFileElements
\ingroup tutorial_proof
\brief Class to hold information about the processed elements of a file

Used for testing.

\defgroup tutorial_ProofAux ProofAux
\ingroup tutorial_proof
\brief Selector used for auxiliary actions in the PROOF tutorials

\defgroup tutorial_ProofEvent ProofEvent
\ingroup tutorial_proof
\brief Selector for generic processing with Event

Example of TSelector implementation to do generic
processing with the test 'Event' structure.
See tutorials/proof/runProof.C, option "event", for an
example of how to run this selector.

\defgroup tutorial_ProofEventProc ProofEventProc
\ingroup tutorial_proof
\brief Selector to process trees containing Event structures

Example of TSelector implementation to process trees
containing 'Event' structures, e.g. the files under
http://root.cern.ch/files/data .
See tutorials/proof/runProof.C, option "eventproc", for
an example of how to run this selector.

\defgroup tutorial_ProofFriends ProofFriends
\ingroup tutorial_proof
\brief Selector to process tree friends

Example of TSelector implementation to process tree friends in PROOF.
See tutorials/proof/runProof.C, option "eventproc", for
an example of how to run this selector.

\defgroup tutorial_ProofNtuple ProofNtuple
\ingroup tutorial_proof
\brief Selector to fill a simple ntuple

Example of TSelector implementation to do generic processing
(filling a simple ntuple, in this case).
See tutorials/proof/runProof.C, option "ntuple", for an
example of how to run this selector.

\defgroup tutorial_ProofPythia ProofPythia
\ingroup tutorial_proof
\brief Selector to generate Monte Carlo events with Pythia8

Example of TSelector implementation to do a Monte Carlo
generation using Pythia8.
See tutorials/proof/runProof.C, option "pythia8", for an
example of how to run this selector.

\defgroup tutorial_ProofSimple ProofSimple
\ingroup tutorial_proof
\brief Selector to fill a set of histograms

Example of TSelector implementation to do generic processing (filling a
set of histograms in this case).
See tutorials/proof/runProof.C, option "simple", for an
example of how to run this selector.

\defgroup tutorial_ProofSimpleFile ProofSimpleFile
\ingroup tutorial_proof
\brief Selector to fill a set of histograms and merging via file

Example of TSelector implementation to do generic processing
(filling a set of histograms in this case) and merging via
a file, with part of the objects saved in a sub-directory.
See tutorials/proof/runProof.C, option "simplefile", for an
example of how to run this selector.

\defgroup tutorial_ProofStdVec ProofStdVec
\ingroup tutorial_proof
\brief Selector for generic processing with stdlib collections

Example of TSelector implementation to do generic
processing with stdlib collections.
See tutorials/proof/runProof.C, option "stdlib", for an
example of how to run this selector.

\defgroup tutorial_ProofTests ProofTests
\ingroup tutorial_proof
\brief Auxilliary selector used to test PROOF functionality
