// -*- mode: c++ -*-
// 
// File MDF.C generated by TMultiDimFit::MakeRealCode
// on Fri Dec 13 03:59:00 2024
// ROOT version 6.34.01
//
// This file contains the function 
//
//    double  MDF(double *x); 
//
// For evaluating the parameterization obtained
// from TMultiDimFit and the point x
// 
// See TMultiDimFit class documentation for more information 
// 
//
// Static data variables
//
static int    gNVariables    = 4;
static int    gNCoefficients = 21;
static double gDMean         = 48.4044;
// Assignment to mean vector.
static double gXMean[] = {
  0.00657672, 0.0083759, -0.00385446, 0.000527764 };

// Assignment to minimum vector.
static double gXMin[] = {
  0.0454982, 0.0152285, 0.0410935, 0.00381892 };

// Assignment to maximum vector.
static double gXMax[] = {
  9.95437, 9.98965, 9.99761, 9.99454 };

// Assignment to coefficients vector.
static double gCoefficient[] = {
  -4.39851,
  43.1493,
  13.4121,
  13.4869,
  13.3954,
  13.228,
  13.3441,
  13.2943,
  4.52254,
  4.65912,
  4.94808,
  -4.02586,
  -4.04534,
  -3.93856,
  4.42141,
  -4.00581,
  4.62595,
  4.37782,
  3.51629,
  -4.11068,
  -3.82302
 };

// Assignment to error coefficients vector.
static double gCoefficientRMS[] = {
  0.044426,
  0.0856451,
  0.0378565,
  0.0380951,
  0.0374054,
  0.0657916,
  0.0675855,
  0.066641,
  0.0739945,
  0.0721745,
  0.0814935,
  0.065378,
  0.0655396,
  0.0651725,
  0.130526,
  0.117191,
  0.130233,
  0.128579,
  0.113771,
  0.117446,
  0.116486
 };

// Assignment to powers vector.
// The powers are stored row-wise, that is
//  p_ij = gPower[i * NVariables + j];
static int    gPower[] = {
  1,  1,  1,  1,
  2,  1,  1,  1,
  1,  1,  1,  2,
  1,  1,  2,  1,
  1,  2,  1,  1,
  2,  2,  1,  1,
  2,  1,  1,  2,
  2,  1,  2,  1,
  1,  1,  1,  3,
  1,  3,  1,  1,
  1,  1,  5,  1,
  1,  1,  2,  2,
  1,  2,  1,  2,
  1,  2,  2,  1,
  2,  1,  1,  3,
  2,  2,  1,  2,
  2,  1,  3,  1,
  2,  3,  1,  1,
  1,  2,  2,  2,
  2,  1,  2,  2,
  2,  2,  2,  1
};

// 
// The function   double MDF(double *x)
// 
double MDF(double *x) {
  double returnValue = gDMean;
  int    i = 0, j = 0, k = 0;
  for (i = 0; i < gNCoefficients ; i++) {
    // Evaluate the ith term in the expansion
    double term = gCoefficient[i];
    for (j = 0; j < gNVariables; j++) {
      // Evaluate the polynomial in the jth variable.
      int power = gPower[gNVariables * i + j]; 
      double p1 = 1, p2 = 0, p3 = 0, r = 0;
      double v =  1 + 2. / (gXMax[j] - gXMin[j]) * (x[j] - gXMax[j]);
      // what is the power to use!
      switch(power) {
      case 1: r = 1; break; 
      case 2: r = v; break; 
      default: 
        p2 = v; 
        for (k = 3; k <= power; k++) { 
          p3 = p2 * v;
          p1 = p2; p2 = p3; 
        }
        r = p3;
      }
      // multiply this term by the poly in the jth var
      term *= r; 
    }
    // Add this term to the final result
    returnValue += term;
  }
  return returnValue;
}

// EOF for MDF.C
