/*****************************************************************************
 * Project: RooFit                                                           *
 *                                                                           *
 * This code was autogenerated by RooClassFactory                            *
 *****************************************************************************/

// Your description goes here...

#include "MyPdfV2.h"

#include <RooAbsReal.h>
#include <RooAbsCategory.h>

#include <Riostream.h>
#include <TMath.h>

#include <cmath>

ClassImp(MyPdfV2);

MyPdfV2::MyPdfV2(const char *name, const char *title,
                        RooAbsReal& _x,
                        RooAbsReal& _A,
                        RooAbsReal& _B)
   : RooAbsPdf(name,title),
   x("x","x",this,_x),
   A("A","A",this,_A),
   B("B","B",this,_B)
{
}

MyPdfV2::MyPdfV2(MyPdfV2 const &other, const char *name)
   : RooAbsPdf(other,name),
   x("x",this,other.x),
   A("A",this,other.A),
   B("B",this,other.B)
{
}


double MyPdfV2::evaluate() const 
{
   return MyPdfV2_evaluate(x, A, B); 
}

void MyPdfV2::doEval(RooFit::EvalContext &ctx) const 
{ 
   std::span<const double> xSpan = ctx.at(x);
   std::span<const double> ASpan = ctx.at(A);
   std::span<const double> BSpan = ctx.at(B);

   std::size_t n = ctx.output().size();
   for (std::size_t i = 0; i < n; ++i) {
      ctx.output()[i] = MyPdfV2_evaluate(xSpan.size() > 1 ? xSpan[i] : xSpan[0],
                               ASpan.size() > 1 ? ASpan[i] : ASpan[0],
                               BSpan.size() > 1 ? BSpan[i] : BSpan[0]);
   }
} 
void MyPdfV2::translate(RooFit::Detail::CodeSquashContext &ctx) const
{
   ctx.addResult(this, ctx.buildCall("MyPdfV2_evaluate", x, A, B));
}
