// Class: ReadBDTB
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTB
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:08:59 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "2000" [Number of trees in the forest]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Bagging" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
MaxDepth: "3" [Max depth of the decision tree allowed]
MinNodeSize: "5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTBNode

#ifndef BDTBNode__def
#define BDTBNode__def

class BDTBNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTBNode ( BDTBNode* left,BDTBNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTBNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTBNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTBNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTBNode*   fLeft;     // pointer to the left daughter node
   BDTBNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTBNode::~BDTBNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTBNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTBNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTB : public IClassifierReader {

 public:

   // constructor
   ReadBDTB( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTB" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTB() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTBNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTB::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTBNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTBNode*)current->GetRight();
         else current=(BDTBNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDTB::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.518105, 1, 1, 0.787248,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305362,-99) , 
0, 0.138796, 1, 0, 0.53073,-99) , 
3, 0.538415, 0, 0, 0.693682,-99) , 
NN(
0, 
0, 
-1, -1.58829, 0, -1, 0.233861,-99) , 
3, -0.12622, 0, 0, 0.484574,-99)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46823, 0, 1, 0.889108,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346233,-99) , 
0, 0.682217, 1, 0, 0.608349,-99) , 
3, 1.14037, 0, 0, 0.718294,-99) , 
NN(
0, 
0, 
-1, -0.471727, 0, -1, 0.211442,-99) , 
3, -0.216753, 0, 0, 0.505019,-99)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17392, 0, 1, 0.805659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239951,-99) , 
0, 0.134912, 1, 0, 0.488536,-99) , 
3, 0.616639, 0, 0, 0.669006,-99) , 
NN(
0, 
0, 
-1, -2.81562, 1, -1, 0.191524,-99) , 
3, -0.302053, 0, 0, 0.503048,-99)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.01141, 0, 1, 0.828571,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180544,-99) , 
0, 0.311857, 1, 0, 0.45022,-99) , 
NN(
0, 
0, 
-1, -1.27505, 0, -1, 0.205938,-99) , 
3, -0.548039, 0, 0, 0.334891,-99) , 
3, 0.644232, 0, 0, 0.496518,-99)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.822633,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367727,-99) , 
0, 0.328161, 1, 0, 0.566935,-99) , 
3, 0.883535, 0, 0, 0.729499,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198206,-99) , 
0, -0.341503, 1, 0, 0.445975,-99) , 
NN(
0, 
0, 
-1, -1.72267, 0, -1, 0.190013,-99) , 
3, -0.554775, 0, 0, 0.307244,-99) , 
3, 0.268003, 0, 0, 0.506012,-99)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67371, 0, 1, 0.827328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408542,-99) , 
0, 0.488, 1, 0, 0.626186,-99) , 
3, 0.965707, 0, 0, 0.753399,-99) , 
NN(
0, 
0, 
-1, -1.30102, 0, -1, 0.309426,-99) , 
3, 0.34753, 0, 0, 0.502187,-99)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71107, 0, 1, 0.823557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.918298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347203,-99) , 
0, 0.076294, 1, 0, 0.575827,-99) , 
3, 0.784282, 0, 0, 0.7114,-99) , 
NN(
0, 
0, 
-1, -0.89076, 0, -1, 0.22216,-99) , 
3, -0.133228, 0, 0, 0.500803,-99)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55682, 1, 1, 0.876244,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334014,-99) , 
0, 0.40736, 1, 0, 0.547328,-99) , 
3, 1.08006, 0, 0, 0.661109,-99) , 
NN(
0, 
0, 
-1, -1.24602, 0, -1, 0.189838,-99) , 
3, -0.260982, 0, 0, 0.488466,-99)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.50639, 0, 1, 0.819733,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.162265,-99) , 
0, 0.431079, 1, 0, 0.476941,-99) , 
NN(
0, 
0, 
-1, -1.68618, 0, -1, 0.163333,-99) , 
3, -0.458101, 0, 0, 0.338026,-99) , 
3, 0.760049, 0, 0, 0.484843,-99)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.876432,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299703,-99) , 
0, 0.453613, 1, 0, 0.546334,-99) , 
3, 0.949517, 0, 0, 0.692201,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.20465,-99) , 
3, -0.218528, 0, 0, 0.494007,-99)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75578, 1, 1, 0.849549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298929,-99) , 
0, 1.05737, 1, 0, 0.642634,-99) , 
3, 1.08446, 0, 0, 0.741272,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246769,-99) , 
0, -0.555245, 1, 0, 0.431962,-99) , 
NN(
0, 
0, 
-1, -1.41975, 0, -1, 0.169511,-99) , 
3, -0.509187, 0, 0, 0.276106,-99) , 
3, 0.287809, 0, 0, 0.482183,-99)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.80869, 1, 1, 0.871004,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274262,-99) , 
0, 0.468912, 1, 0, 0.506906,-99) , 
NN(
0, 
0, 
-1, -1.71171, 0, -1, 0.154736,-99) , 
3, -1.05753, 0, 0, 0.40753,-99) , 
3, 0.760049, 0, 0, 0.552625,-99)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.962827, 1, 1, 0.803383,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347722,-99) , 
1, -0.128935, 1, 0, 0.515909,-99) , 
3, 0.576993, 0, 0, 0.721746,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207873,-99) , 
0, -0.710328, 1, 0, 0.372814,-99) , 
NN(
0, 
0, 
-1, -1.60682, 0, -1, 0.102348,-99) , 
3, -0.936525, 0, 0, 0.252953,-99) , 
3, 0.163853, 0, 0, 0.501777,-99)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.69274, 0, 1, 0.834327,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27393,-99) , 
0, 0.0578584, 1, 0, 0.445831,-99) , 
NN(
0, 
0, 
-1, -1.71131, 0, -1, 0.112654,-99) , 
3, -1.05753, 0, 0, 0.349699,-99) , 
3, 0.760049, 0, 0, 0.495718,-99)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.866874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309278,-99) , 
0, 0.375401, 1, 0, 0.571422,-99) , 
3, 0.835097, 0, 0, 0.722241,-99) , 
NN(
0, 
0, 
-1, -0.572927, 0, -1, 0.233594,-99) , 
3, -0.0725463, 0, 0, 0.490801,-99)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11116, 0, 1, 0.830829,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319033,-99) , 
0, -0.684438, 1, 0, 0.46757,-99) , 
NN(
0, 
0, 
-1, -1.62463, 0, -1, 0.166429,-99) , 
3, -0.727114, 0, 0, 0.344879,-99) , 
3, 0.742135, 0, 0, 0.495104,-99)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0703, 1, 1, 0.816543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301715,-99) , 
0, 0.252479, 1, 0, 0.528907,-99) , 
3, 0.630536, 0, 0, 0.687012,-99) , 
NN(
0, 
0, 
-1, -1.05776, 0, -1, 0.217798,-99) , 
3, -0.291428, 0, 0, 0.521765,-99)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76367, 1, 1, 0.884284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437739,-99) , 
0, -0.0346559, 1, 0, 0.550465,-99) , 
3, 1.23954, 0, 0, 0.6469,-99) , 
NN(
0, 
0, 
-1, -1.60155, 0, -1, 0.168407,-99) , 
3, -0.351682, 0, 0, 0.479962,-99)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.865615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328537,-99) , 
0, 0.843106, 1, 0, 0.610648,-99) , 
3, 1.16466, 0, 0, 0.701283,-99) , 
NN(
0, 
0, 
-1, -0.659741, 0, -1, 0.221971,-99) , 
3, -0.170545, 0, 0, 0.511121,-99)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.847677,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273363,-99) , 
0, 0.179441, 1, 0, 0.44364,-99) , 
NN(
0, 
0, 
-1, -0.385433, 1, -1, 0.185026,-99) , 
3, -0.441503, 0, 0, 0.330664,-99) , 
3, 0.742135, 0, 0, 0.481617,-99)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27422, 1, 1, 0.837885,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358322,-99) , 
0, 0.0112647, 1, 0, 0.522348,-99) , 
3, 0.727045, 0, 0, 0.686147,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.215032,-99) , 
3, -0.218528, 0, 0, 0.505671,-99)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63158, 1, 1, 0.852744,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400952,-99) , 
0, 0.788183, 1, 0, 0.628875,-99) , 
3, 1.11419, 0, 0, 0.737942,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259334,-99) , 
0, -0.428715, 1, 0, 0.419768,-99) , 
NN(
0, 
0, 
-1, -1.76751, 0, -1, 0.106063,-99) , 
3, -1.12817, 0, 0, 0.318516,-99) , 
3, 0.27076, 0, 0, 0.502916,-99)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.966615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443944,-99) , 
3, 1.17938, 0, 0, 0.738991,-99) , 
0, 0.983264, 1, 0, 0.805436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35212,-99) , 
0, -1.02442, 1, 0, 0.443622,-99) , 
NN(
0, 
0, 
-1, 0.199127, 1, -1, 0.0938268,-99) , 
3, -1.16641, 0, 0, 0.361262,-99) , 
3, 0.609067, 0, 0, 0.51062,-99)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.868072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330199,-99) , 
0, 0.242655, 1, 0, 0.550059,-99) , 
3, 0.949517, 0, 0, 0.695973,-99) , 
NN(
0, 
0, 
-1, -1.50598, 0, -1, 0.231209,-99) , 
3, -0.218528, 0, 0, 0.511382,-99)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72133, 1, 1, 0.843096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451189,-99) , 
0, 0.930889, 1, 0, 0.656224,-99) , 
3, 1.18752, 0, 0, 0.747025,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191979,-99) , 
0, -0.111037, 1, 0, 0.465912,-99) , 
NN(
0, 
0, 
-1, -1.6543, 0, -1, 0.187205,-99) , 
3, -0.477004, 0, 0, 0.324793,-99) , 
3, 0.34753, 0, 0, 0.497796,-99)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.37778, 0, 1, 0.76866,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362489,-99) , 
1, -0.365936, 1, 0, 0.475669,-99) , 
NN(
0, 
0, 
-1, -0.508647, 1, -1, 0.195144,-99) , 
3, -0.206811, 0, 0, 0.274336,-99) , 
3, 0.34753, 0, 0, 0.478952,-99)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.864597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449326,-99) , 
0, 0.17797, 1, 0, 0.60931,-99) , 
3, 1.15167, 0, 0, 0.700699,-99) , 
NN(
0, 
0, 
-1, -0.705832, 0, -1, 0.221579,-99) , 
3, -0.206128, 0, 0, 0.501544,-99)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.962827, 1, 1, 0.810693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.925145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327471,-99) , 
0, -0.290186, 1, 0, 0.500788,-99) , 
3, 0.521481, 0, 0, 0.692179,-99) , 
NN(
0, 
0, 
-1, -0.835658, 1, -1, 0.213638,-99) , 
3, -0.156071, 0, 0, 0.501999,-99)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3356, 1, 1, 0.869363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338318,-99) , 
0, 0.835519, 1, 0, 0.586255,-99) , 
3, 1.11463, 0, 0, 0.719425,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292334,-99) , 
0, -0.806337, 1, 0, 0.444347,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.160068,-99) , 
3, -0.574972, 0, 0, 0.286332,-99) , 
3, 0.27076, 0, 0, 0.485884,-99)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5827, 0, 1, 0.844273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313357,-99) , 
0, 0.37254, 1, 0, 0.536734,-99) , 
3, 0.942002, 0, 0, 0.658409,-99) , 
NN(
0, 
0, 
-1, -1.6533, 0, -1, 0.149024,-99) , 
3, -0.415423, 0, 0, 0.488231,-99)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16163, 1, 1, 0.868864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293552,-99) , 
0, 0.682217, 1, 0, 0.554124,-99) , 
3, 1.08266, 0, 0, 0.672217,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.215968,-99) , 
3, -0.302053, 0, 0, 0.503579,-99)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.799555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277537,-99) , 
0, 0.144487, 1, 0, 0.512257,-99) , 
3, 0.628149, 0, 0, 0.669541,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.162437,-99) , 
3, -0.291428, 0, 0, 0.483544,-99)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08069, 1, 1, 0.822481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228742,-99) , 
0, 0.158188, 1, 0, 0.504108,-99) , 
NN(
0, 
0, 
-1, -1.25834, 0, -1, 0.178716,-99) , 
3, -0.531196, 0, 0, 0.357949,-99) , 
3, 0.673895, 0, 0, 0.511301,-99)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.8334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283017,-99) , 
0, 0.500185, 1, 0, 0.575571,-99) , 
3, 0.868411, 0, 0, 0.704356,-99) , 
NN(
0, 
0, 
-1, -0.55538, 0, -1, 0.241788,-99) , 
3, -0.0426953, 0, 0, 0.482329,-99)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.09943, 0, 1, 0.880871,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29754,-99) , 
0, 0.453613, 1, 0, 0.537171,-99) , 
NN(
0, 
0, 
-1, -0.665071, 0, -1, 0.220891,-99) , 
3, -0.152711, 0, 0, 0.359987,-99) , 
3, 0.729578, 0, 0, 0.530512,-99)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13462, 1, 1, 0.849663,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329764,-99) , 
0, 0.0112647, 1, 0, 0.526357,-99) , 
NN(
0, 
0, 
-1, -1.51365, 1, -1, 0.178005,-99) , 
3, -0.368043, 0, 0, 0.349405,-99) , 
3, 0.828289, 0, 0, 0.50006,-99)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.862783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375041,-99) , 
0, 0.505756, 1, 0, 0.561767,-99) , 
3, 1.14037, 0, 0, 0.666504,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.129307,-99) , 
0, -1.36121, 1, 0, 0.289824,-99) , 
NN(
0, 
0, 
-1, -0.206791, 1, -1, 0.0648387,-99) , 
3, -1.21594, 0, 0, 0.204016,-99) , 
3, -0.216753, 0, 0, 0.481248,-99)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07419, 1, 1, 0.861616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345203,-99) , 
0, 0.214206, 1, 0, 0.532073,-99) , 
3, 1.01311, 0, 0, 0.67171,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.200647,-99) , 
3, -0.133228, 0, 0, 0.467141,-99)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14405, 0, 1, 0.830491,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312009,-99) , 
0, 0.619656, 1, 0, 0.564552,-99) , 
3, 0.972005, 0, 0, 0.67621,-99) , 
NN(
0, 
0, 
-1, -0.885947, 0, -1, 0.241543,-99) , 
3, -0.145446, 0, 0, 0.503322,-99)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55843, 1, 1, 0.861436,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316711,-99) , 
0, 0.683618, 1, 0, 0.587098,-99) , 
3, 0.969933, 0, 0, 0.754926,-99) , 
NN(
0, 
0, 
-1, -1.5758, 0, -1, 0.281715,-99) , 
3, 0.34753, 0, 0, 0.486789,-99)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38774, 1, 1, 0.825613,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199691,-99) , 
0, 0.295007, 1, 0, 0.489176,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.170818,-99) , 
3, -0.546876, 0, 0, 0.333696,-99) , 
3, 0.644232, 0, 0, 0.490501,-99)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832592, 0, 1, 0.80026,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233611,-99) , 
0, -0.150485, 1, 0, 0.481218,-99) , 
NN(
0, 
0, 
-1, -1.54166, 0, -1, 0.197812,-99) , 
3, -0.651582, 0, 0, 0.355801,-99) , 
3, 0.427177, 0, 0, 0.530194,-99)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57635, 0, 1, 0.831734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297586,-99) , 
0, 0.91729, 1, 0, 0.606018,-99) , 
3, 1.082, 0, 0, 0.716687,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297214,-99) , 
0, -0.568658, 1, 0, 0.450589,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.16802,-99) , 
3, -0.55608, 0, 0, 0.291429,-99) , 
3, 0.268003, 0, 0, 0.488748,-99)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.899189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356825,-99) , 
0, 0.40736, 1, 0, 0.570043,-99) , 
3, 1.08009, 0, 0, 0.684984,-99) , 
NN(
0, 
0, 
-1, -0.749949, 1, -1, 0.181067,-99) , 
3, -0.302053, 0, 0, 0.504898,-99)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.828951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196166,-99) , 
0, 0.969329, 1, 0, 0.537073,-99) , 
3, 1.08411, 0, 0, 0.640565,-99) , 
NN(
0, 
0, 
-1, -0.499093, 1, -1, 0.200197,-99) , 
3, -0.302053, 0, 0, 0.475579,-99)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47497, 1, 1, 0.891485,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428749,-99) , 
0, 0.895962, 1, 0, 0.636293,-99) , 
3, 1.15225, 0, 0, 0.731752,-99) , 
NN(
0, 
0, 
-1, -1.45042, 0, -1, 0.225899,-99) , 
3, -0.206128, 0, 0, 0.526764,-99)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07419, 1, 1, 0.869074,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398991,-99) , 
0, 0.488, 1, 0, 0.600737,-99) , 
3, 0.90654, 0, 0, 0.764388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669004,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240755,-99) , 
0, -0.381656, 1, 0, 0.464184,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.145626,-99) , 
3, -0.574972, 0, 0, 0.293015,-99) , 
3, 0.27076, 0, 0, 0.519326,-99)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.886651,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390333,-99) , 
0, 0.223554, 1, 0, 0.586712,-99) , 
3, 1.09053, 0, 0, 0.697577,-99) , 
NN(
0, 
0, 
-1, -0.669755, 1, -1, 0.18922,-99) , 
3, -0.291428, 0, 0, 0.508692,-99)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.79778,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25289,-99) , 
0, 0.544361, 1, 0, 0.556383,-99) , 
3, 0.687282, 0, 0, 0.689837,-99) , 
NN(
0, 
0, 
-1, -0.685991, 0, -1, 0.195133,-99) , 
3, -0.2003, 0, 0, 0.48943,-99)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44444, 0, 1, 0.856776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466798,-99) , 
1, -0.627107, 1, 0, 0.554861,-99) , 
3, 0.926722, 0, 0, 0.697783,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200859,-99) , 
1, -0.297941, 1, 0, 0.300127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0444631,-99) , 
3, -1.69862, 0, 0, 0.242889,-99) , 
3, -0.206128, 0, 0, 0.505806,-99)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41775, 1, 1, 0.844756,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379128,-99) , 
0, -1.39752, 1, 0, 0.437529,-99) , 
NN(
0, 
0, 
-1, -1.70167, 0, -1, 0.0944577,-99) , 
3, -1.12761, 0, 0, 0.345157,-99) , 
3, 0.673895, 0, 0, 0.505608,-99)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.843201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33483,-99) , 
0, 0.227133, 1, 0, 0.561146,-99) , 
3, 0.659375, 0, 0, 0.696932,-99) , 
NN(
0, 
0, 
-1, -0.395683, 1, -1, 0.178278,-99) , 
3, -0.552682, 0, 0, 0.540448,-99)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.815046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291036,-99) , 
0, -0.0153026, 1, 0, 0.547854,-99) , 
3, 0.582527, 0, 0, 0.680998,-99) , 
NN(
0, 
0, 
-1, -1.65101, 0, -1, 0.140969,-99) , 
3, -0.707817, 0, 0, 0.529008,-99)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.862471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26611,-99) , 
0, 0.381998, 1, 0, 0.511498,-99) , 
3, 0.951244, 0, 0, 0.660215,-99) , 
NN(
0, 
0, 
-1, -1.45697, 0, -1, 0.134792,-99) , 
3, -0.547237, 0, 0, 0.486304,-99)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66703, 0, 1, 0.844751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416309,-99) , 
0, 0.232439, 1, 0, 0.601198,-99) , 
3, 0.95337, 0, 0, 0.702215,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258216,-99) , 
3, -0.587968, 0, 0, 0.343124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0495166,-99) , 
3, -1.50393, 0, 0, 0.262054,-99) , 
3, -0.218528, 0, 0, 0.52946,-99)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.895692,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423875,-99) , 
0, 0.0710259, 1, 0, 0.546953,-99) , 
3, 1.14952, 0, 0, 0.64587,-99) , 
NN(
0, 
0, 
-1, -1.53778, 0, -1, 0.130591,-99) , 
3, -0.613987, 0, 0, 0.520979,-99)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00012, 0, 1, 0.916254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469858,-99) , 
3, 1.40209, 0, 0, 0.75547,-99) , 
0, 1.31919, 1, 0, 0.825484,-99) , 
NN(
NN(
0, 
0, 
-1, -1.43622, 0, 1, 0.66198,-99) , 
NN(
0, 
0, 
-1, -0.537744, 0, -1, 0.276723,-99) , 
1, -1.01826, 1, 0, 0.334479,-99) , 
3, 0.661338, 0, 0, 0.48575,-99)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.868514,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397778,-99) , 
0, 0.901669, 1, 0, 0.667622,-99) , 
3, 1.11586, 0, 0, 0.762857,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254159,-99) , 
0, -0.341503, 1, 0, 0.447181,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.141565,-99) , 
3, -0.569108, 0, 0, 0.276335,-99) , 
3, 0.27076, 0, 0, 0.481284,-99)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.864581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446315,-99) , 
0, 0.27102, 1, 0, 0.568353,-99) , 
3, 1.21449, 0, 0, 0.669082,-99) , 
NN(
0, 
0, 
-1, -0.60983, 0, -1, 0.229021,-99) , 
3, -0.117632, 0, 0, 0.482873,-99)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78902, 0, 1, 0.881802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302359,-99) , 
0, 0.985639, 1, 0, 0.625197,-99) , 
3, 1.11005, 0, 0, 0.749414,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331491,-99) , 
1, -0.728332, 1, 0, 0.397406,-99) , 
NN(
0, 
0, 
-1, 0.0553065, 1, -1, 0.0809015,-99) , 
3, -1.40771, 0, 0, 0.326989,-99) , 
3, 0.27076, 0, 0, 0.531072,-99)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66214, 0, 1, 0.845979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290966,-99) , 
0, 0.66015, 1, 0, 0.641125,-99) , 
3, 0.95337, 0, 0, 0.734317,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.186594,-99) , 
3, -0.218528, 0, 0, 0.509657,-99)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.929674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42165,-99) , 
3, 0.881994, 0, 0, 0.680071,-99) , 
0, 0.49699, 1, 0, 0.738727,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221704,-99) , 
0, -0.723301, 1, 0, 0.386081,-99) , 
NN(
0, 
0, 
-1, -1.70297, 0, -1, 0.13979,-99) , 
3, -0.826385, 0, 0, 0.281622,-99) , 
3, 0.256412, 0, 0, 0.484861,-99)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.85143,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265928,-99) , 
0, 0.803606, 1, 0, 0.601367,-99) , 
3, 1.07968, 0, 0, 0.731249,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304066,-99) , 
0, -0.817898, 1, 0, 0.426498,-99) , 
NN(
0, 
0, 
-1, -1.49149, 0, -1, 0.124499,-99) , 
3, -0.55608, 0, 0, 0.264936,-99) , 
3, 0.256412, 0, 0, 0.479202,-99)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.140183, 1, 1, 0.807573,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221173,-99) , 
0, 0.398957, 1, 0, 0.488605,-99) , 
NN(
0, 
0, 
-1, -1.69306, 0, -1, 0.182548,-99) , 
3, -0.578983, 0, 0, 0.366205,-99) , 
3, 0.899086, 0, 0, 0.482724,-99)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66214, 0, 1, 0.822621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332376,-99) , 
0, 0.284185, 1, 0, 0.552639,-99) , 
3, 0.949517, 0, 0, 0.665102,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.243054,-99) , 
3, -0.218528, 0, 0, 0.506923,-99)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42851, 0, 1, 0.777391,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284681,-99) , 
1, -0.102661, 1, 0, 0.439954,-99) , 
NN(
0, 
0, 
-1, -1.58162, 0, -1, 0.177017,-99) , 
3, -0.414993, 0, 0, 0.300653,-99) , 
3, 0.402144, 0, 0, 0.496201,-99)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17964, 1, 1, 0.884423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439448,-99) , 
0, 1.08778, 1, 0, 0.679121,-99) , 
3, 1.37778, 0, 0, 0.755399,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112877,-99) , 
0, -0.111882, 1, 0, 0.372572,-99) , 
NN(
0, 
0, 
-1, -1.6621, 0, -1, 0.115566,-99) , 
3, -1.03106, 0, 0, 0.282745,-99) , 
3, 0.34753, 0, 0, 0.487435,-99)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.470293, 0, 1, 0.92913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425293,-99) , 
3, 1.22763, 0, 0, 0.692633,-99) , 
0, 0.777339, 1, 0, 0.7725,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308441,-99) , 
0, -0.98863, 1, 0, 0.438089,-99) , 
NN(
0, 
0, 
-1, -1.3765, 0, -1, 0.153886,-99) , 
3, -0.639477, 0, 0, 0.284471,-99) , 
3, 0.191234, 0, 0, 0.525464,-99)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.863734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478113,-99) , 
0, 0.500484, 1, 0, 0.659632,-99) , 
3, 1.01765, 0, 0, 0.786977,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29631,-99) , 
0, -0.742611, 1, 0, 0.415542,-99) , 
NN(
0, 
0, 
-1, -1.72908, 1, -1, 0.125119,-99) , 
3, -0.686658, 0, 0, 0.283794,-99) , 
3, 0.402144, 0, 0, 0.484498,-99)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.867335,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346126,-99) , 
0, 0.232439, 1, 0, 0.528628,-99) , 
3, 0.941165, 0, 0, 0.676213,-99) , 
NN(
0, 
0, 
-1, -0.659741, 0, -1, 0.186616,-99) , 
3, -0.170545, 0, 0, 0.481879,-99)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.233974, 1, 1, 0.922062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437893,-99) , 
0, 1.52925, 1, 0, 0.705666,-99) , 
3, 1.69284, 0, 0, 0.779507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36641,-99) , 
0, -0.873433, 1, 0, 0.445588,-99) , 
NN(
0, 
0, 
-1, -1.6781, 0, -1, 0.182618,-99) , 
3, -0.451773, 0, 0, 0.32347,-99) , 
3, 0.760049, 0, 0, 0.460019,-99)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62158, 0, 1, 0.875833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469021,-99) , 
0, 0.91729, 1, 0, 0.652449,-99) , 
3, 1.1381, 0, 0, 0.759663,-99) , 
NN(
0, 
0, 
-1, -1.52155, 0, -1, 0.340226,-99) , 
3, 0.337892, 0, 0, 0.528784,-99)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.87661, 1, 1, 0.853507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313896,-99) , 
0, 0.87199, 1, 0, 0.617921,-99) , 
3, 1.18232, 0, 0, 0.694269,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173426,-99) , 
0, -1.1687, 1, 0, 0.325324,-99) , 
NN(
0, 
0, 
-1, -0.438842, 1, -1, 0.0875827,-99) , 
3, -0.987827, 0, 0, 0.210142,-99) , 
3, -0.218528, 0, 0, 0.497551,-99)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45677, 0, 1, 0.860189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489684,-99) , 
0, -0.20991, 1, 0, 0.609709,-99) , 
3, 0.933977, 0, 0, 0.729987,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202197,-99) , 
1, -0.00674708, 1, 0, 0.315874,-99) , 
NN(
0, 
0, 
-1, -0.301417, 1, -1, 0.065634,-99) , 
3, -1.20223, 0, 0, 0.214582,-99) , 
3, -0.206128, 0, 0, 0.529701,-99)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.25593, 0, 1, 0.856626,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265386,-99) , 
0, 0.155544, 1, 0, 0.48869,-99) , 
NN(
0, 
0, 
-1, -1.64353, 0, -1, 0.154891,-99) , 
3, -0.458396, 0, 0, 0.322222,-99) , 
3, 0.712472, 0, 0, 0.487308,-99)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.880816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400036,-99) , 
0, 0.733856, 1, 0, 0.571003,-99) , 
3, 1.18544, 0, 0, 0.673387,-99) , 
NN(
0, 
0, 
-1, -0.871039, 1, -1, 0.202129,-99) , 
3, -0.218528, 0, 0, 0.491164,-99)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.863793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383736,-99) , 
0, 0.879237, 1, 0, 0.61523,-99) , 
3, 1.12513, 0, 0, 0.735494,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269648,-99) , 
0, -0.795814, 1, 0, 0.398209,-99) , 
NN(
0, 
0, 
-1, -1.61765, 0, -1, 0.13743,-99) , 
3, -0.751014, 0, 0, 0.28201,-99) , 
3, 0.322617, 0, 0, 0.494661,-99)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38991, 0, 1, 0.828786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43777,-99) , 
3, 0.611347, 0, 0, 0.754131,-99) , 
NN(
0, 
0, 
-1, -1.22846, 0, -1, 0.285103,-99) , 
3, 0.402144, 0, 0, 0.480057,-99)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.840641,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306723,-99) , 
0, -0.0721965, 1, 0, 0.448737,-99) , 
NN(
0, 
0, 
-1, -1.6834, 0, -1, 0.151262,-99) , 
3, -0.755609, 0, 0, 0.356142,-99) , 
3, 0.760049, 0, 0, 0.494738,-99)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63415, 1, 1, 0.893358,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364061,-99) , 
0, 0.865651, 1, 0, 0.646402,-99) , 
3, 1.15062, 0, 0, 0.766466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62195,-99) , 
NN(
0, 
0, 
-1, -1.69173, 0, -1, 0.25339,-99) , 
3, 0.0817261, 0, 0, 0.305656,-99) , 
3, 0.34765, 0, 0, 0.506674,-99)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.843933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348604,-99) , 
0, 0.227988, 1, 0, 0.551319,-99) , 
3, 1.01311, 0, 0, 0.672354,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.235472,-99) , 
3, -0.133228, 0, 0, 0.499036,-99)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57448, 0, 1, 0.827471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307091,-99) , 
0, 0.381546, 1, 0, 0.509507,-99) , 
3, 0.844923, 0, 0, 0.64162,-99) , 
NN(
0, 
0, 
-1, -1.65141, 0, -1, 0.179763,-99) , 
3, -0.707817, 0, 0, 0.515139,-99)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46041, 0, 1, 0.784478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222979,-99) , 
0, -0.0153026, 1, 0, 0.487473,-99) , 
3, 0.498733, 0, 0, 0.637336,-99) , 
NN(
0, 
0, 
-1, -1.4638, 0, -1, 0.154337,-99) , 
3, -0.774089, 0, 0, 0.517979,-99)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66447, 0, 1, 0.786052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299008,-99) , 
0, 0.138796, 1, 0, 0.509264,-99) , 
3, 0.520354, 0, 0, 0.675384,-99) , 
NN(
0, 
0, 
-1, -1.14148, 0, -1, 0.22505,-99) , 
3, -0.156071, 0, 0, 0.495903,-99)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41077, 1, 1, 0.848997,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368994,-99) , 
0, 0.625707, 1, 0, 0.582786,-99) , 
3, 0.949517, 0, 0, 0.700853,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258001,-99) , 
0, -1.1687, 1, 0, 0.351058,-99) , 
NN(
0, 
0, 
-1, -1.65618, 0, -1, 0.112899,-99) , 
3, -0.987827, 0, 0, 0.229844,-99) , 
3, -0.218528, 0, 0, 0.50409,-99)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22704, 0, 1, 0.795849,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246631,-99) , 
0, 0.415118, 1, 0, 0.523032,-99) , 
NN(
0, 
0, 
-1, -1.50743, 0, -1, 0.222041,-99) , 
3, -0.226102, 0, 0, 0.356745,-99) , 
3, 0.673895, 0, 0, 0.500668,-99)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.484212, 1, 1, 0.832363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320266,-99) , 
0, -0.0386346, 1, 0, 0.528616,-99) , 
3, 0.609259, 0, 0, 0.710518,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206951,-99) , 
0, -1.30667, 1, 0, 0.317608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0711542,-99) , 
3, -1.31656, 0, 0, 0.257301,-99) , 
3, -0.0725463, 0, 0, 0.506599,-99)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63276, 0, 1, 0.835563,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.915549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377556,-99) , 
0, 0.0967635, 1, 0, 0.575952,-99) , 
3, 0.753913, 0, 0, 0.73579,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219204,-99) , 
0, -0.795814, 1, 0, 0.369175,-99) , 
NN(
0, 
0, 
-1, -1.63463, 0, -1, 0.147885,-99) , 
3, -0.695546, 0, 0, 0.247377,-99) , 
3, 0.131392, 0, 0, 0.497015,-99)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17429, 1, 1, 0.871735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.902025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493817,-99) , 
0, -0.667921, 1, 0, 0.547974,-99) , 
3, 1.13367, 0, 0, 0.662739,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166,-99) , 
0, -1.30853, 1, 0, 0.299497,-99) , 
NN(
0, 
0, 
-1, -1.54094, 0, -1, 0.109002,-99) , 
3, -1.17106, 0, 0, 0.227828,-99) , 
3, -0.2003, 0, 0, 0.500521,-99)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.121237, 1, 1, 0.847431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363164,-99) , 
0, 0.146168, 1, 0, 0.538092,-99) , 
3, 0.78913, 0, 0, 0.693221,-99) , 
NN(
0, 
0, 
-1, -0.639048, 0, -1, 0.1935,-99) , 
3, -0.133228, 0, 0, 0.474429,-99)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.896763,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383854,-99) , 
0, 0.446638, 1, 0, 0.619532,-99) , 
3, 1.12913, 0, 0, 0.721096,-99) , 
NN(
0, 
0, 
-1, -0.694319, 0, -1, 0.216824,-99) , 
3, -0.2003, 0, 0, 0.53005,-99)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47158, 0, 1, 0.796552,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424923,-99) , 
0, -0.684438, 1, 0, 0.530957,-99) , 
3, 0.749245, 0, 0, 0.654009,-99) , 
NN(
0, 
0, 
-1, -0.175545, 1, -1, 0.157446,-99) , 
3, -0.774089, 0, 0, 0.525645,-99)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98872, 1, 1, 0.870093,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.934126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469632,-99) , 
0, -0.20991, 1, 0, 0.564242,-99) , 
3, 1.20168, 0, 0, 0.666899,-99) , 
NN(
0, 
0, 
-1, -0.395683, 1, -1, 0.212611,-99) , 
3, -0.218528, 0, 0, 0.46895,-99)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.832502,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391689,-99) , 
0, -0.836892, 1, 0, 0.461474,-99) , 
NN(
0, 
0, 
-1, -1.80226, 0, -1, 0.162687,-99) , 
3, -0.45279, 0, 0, 0.319132,-99) , 
3, 0.760049, 0, 0, 0.476879,-99)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.809758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32214,-99) , 
0, 0.231365, 1, 0, 0.552276,-99) , 
3, 0.716715, 0, 0, 0.688132,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.21862,-99) , 
3, -0.218528, 0, 0, 0.514941,-99)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75578, 1, 1, 0.859657,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379469,-99) , 
0, 0.500185, 1, 0, 0.590236,-99) , 
3, 1.15905, 0, 0, 0.684452,-99) , 
NN(
0, 
0, 
-1, -1.70223, 0, -1, 0.239128,-99) , 
3, -0.206128, 0, 0, 0.515428,-99)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08782, 1, 1, 0.828511,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176743,-99) , 
0, 0.674788, 1, 0, 0.453649,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.155986,-99) , 
3, -0.451773, 0, 0, 0.311776,-99) , 
3, 0.760049, 0, 0, 0.467853,-99)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.949568, 1, 1, 0.856969,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285902,-99) , 
0, -0.0319407, 1, 0, 0.500816,-99) , 
NN(
0, 
0, 
-1, -1.15783, 0, -1, 0.167967,-99) , 
3, -0.44611, 0, 0, 0.338253,-99) , 
3, 0.742135, 0, 0, 0.498208,-99)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31942, 1, 1, 0.795361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253133,-99) , 
0, 0.123422, 1, 0, 0.496838,-99) , 
3, 0.567755, 0, 0, 0.641017,-99) , 
NN(
0, 
0, 
-1, -1.10706, 0, -1, 0.123838,-99) , 
3, -0.63769, 0, 0, 0.478866,-99)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11419, 0, 1, 0.778127,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280703,-99) , 
0, -0.333179, 1, 0, 0.457837,-99) , 
NN(
0, 
0, 
-1, -1.93962, 1, -1, 0.177115,-99) , 
3, -0.569108, 0, 0, 0.303768,-99) , 
3, 0.27076, 0, 0, 0.501121,-99)    );
  // itree = 100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.831562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318539,-99) , 
0, 0.284185, 1, 0, 0.584931,-99) , 
3, 0.749307, 0, 0, 0.711442,-99) , 
NN(
0, 
0, 
-1, -1.13085, 0, -1, 0.235129,-99) , 
3, -0.145446, 0, 0, 0.505806,-99)    );
  // itree = 101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.613608, 0, 1, 0.740226,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337352,-99) , 
0, -0.98863, 1, 0, 0.452614,-99) , 
NN(
0, 
0, 
-1, -1.61175, 0, -1, 0.135629,-99) , 
3, -0.639477, 0, 0, 0.293846,-99) , 
3, 0.191234, 0, 0, 0.502702,-99)    );
  // itree = 102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76367, 1, 1, 0.88237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384132,-99) , 
0, 1.28278, 1, 0, 0.591862,-99) , 
3, 1.30457, 0, 0, 0.67622,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.200493,-99) , 
3, -0.302053, 0, 0, 0.496703,-99)    );
  // itree = 103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.773475, 0, 1, 0.7552,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276424,-99) , 
0, -0.477384, 1, 0, 0.461859,-99) , 
NN(
0, 
0, 
-1, -1.57177, 0, -1, 0.166478,-99) , 
3, -0.435718, 0, 0, 0.291195,-99) , 
3, 0.361269, 0, 0, 0.478793,-99)    );
  // itree = 104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.902235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473564,-99) , 
0, 1.22295, 1, 0, 0.731289,-99) , 
3, 1.21898, 0, 0, 0.828315,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242205,-99) , 
0, 0.08705, 1, 0, 0.439151,-99) , 
NN(
0, 
0, 
-1, -1.52515, 0, -1, 0.18991,-99) , 
3, -0.237998, 0, 0, 0.292614,-99) , 
3, 0.661338, 0, 0, 0.481322,-99)    );
  // itree = 105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.45915, 1, 1, 0.911056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379196,-99) , 
0, 1.14736, 1, 0, 0.673155,-99) , 
3, 1.38154, 0, 0, 0.754513,-99) , 
NN(
0, 
0, 
-1, -1.02631, 0, -1, 0.274961,-99) , 
3, 0.34753, 0, 0, 0.480081,-99)    );
  // itree = 106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.90806,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419453,-99) , 
0, 0.91729, 1, 0, 0.712733,-99) , 
3, 1.17174, 0, 0, 0.808392,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252225,-99) , 
0, -0.644923, 1, 0, 0.382641,-99) , 
NN(
0, 
0, 
-1, 0.0554896, 1, -1, 0.0996185,-99) , 
3, -1.3011, 0, 0, 0.326322,-99) , 
3, 0.34753, 0, 0, 0.54194,-99)    );
  // itree = 107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.542186, 1, 1, 0.811372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489418,-99) , 
3, 0.493679, 0, 0, 0.761746,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284964,-99) , 
0, -0.333179, 1, 0, 0.453452,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.175477,-99) , 
3, -0.569108, 0, 0, 0.30263,-99) , 
3, 0.27076, 0, 0, 0.523123,-99)    );
  // itree = 108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36694, 1, 1, 0.824622,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265524,-99) , 
0, 0.112808, 1, 0, 0.501674,-99) , 
3, 0.641734, 0, 0, 0.656842,-99) , 
NN(
0, 
0, 
-1, -1.69392, 1, -1, 0.138297,-99) , 
3, -0.582913, 0, 0, 0.498534,-99)    );
  // itree = 109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0380293, 1, 1, 0.856836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336661,-99) , 
0, 0.87199, 1, 0, 0.640437,-99) , 
3, 1.02915, 0, 0, 0.726184,-99) , 
NN(
0, 
0, 
-1, -0.395683, 1, -1, 0.192336,-99) , 
3, -0.346282, 0, 0, 0.5226,-99)    );
  // itree = 110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98325, 1, 1, 0.88479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384084,-99) , 
0, 0.683618, 1, 0, 0.624011,-99) , 
3, 1.11296, 0, 0, 0.761956,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240822,-99) , 
0, -0.757112, 1, 0, 0.404989,-99) , 
NN(
0, 
0, 
-1, -1.64186, 0, -1, 0.147482,-99) , 
3, -0.761968, 0, 0, 0.286843,-99) , 
3, 0.311026, 0, 0, 0.495895,-99)    );
  // itree = 111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.821954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423688,-99) , 
0, -0.707247, 1, 0, 0.509579,-99) , 
3, 0.951244, 0, 0, 0.630232,-99) , 
NN(
0, 
0, 
-1, -1.68094, 0, -1, 0.175032,-99) , 
3, -0.547237, 0, 0, 0.488581,-99)    );
  // itree = 112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.842738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351994,-99) , 
0, 0.0878292, 1, 0, 0.610783,-99) , 
3, 0.642833, 0, 0, 0.757695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210039,-99) , 
0, -1.03299, 1, 0, 0.3385,-99) , 
NN(
0, 
0, 
-1, -2.33824, 1, -1, 0.106038,-99) , 
3, -1.01981, 0, 0, 0.244257,-99) , 
3, -0.0295996, 0, 0, 0.531908,-99)    );
  // itree = 113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65787, 1, 1, 0.878616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461441,-99) , 
0, 1.04393, 1, 0, 0.656546,-99) , 
3, 1.22345, 0, 0, 0.789592,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245049,-99) , 
0, 0.341578, 1, 0, 0.534263,-99) , 
NN(
0, 
0, 
-1, -1.52448, 0, -1, 0.233917,-99) , 
3, -0.244448, 0, 0, 0.36252,-99) , 
3, 0.661338, 0, 0, 0.500972,-99)    );
  // itree = 114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08268, 0, 1, 0.785736,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251961,-99) , 
0, 0.235372, 1, 0, 0.431507,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.0519238,-99) , 
3, -1.28109, 0, 0, 0.351936,-99) , 
3, 0.725852, 0, 0, 0.478287,-99)    );
  // itree = 115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.817428,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231744,-99) , 
0, -0.0153026, 1, 0, 0.426263,-99) , 
NN(
0, 
0, 
-1, -1.51613, 0, -1, 0.186531,-99) , 
3, -0.570582, 0, 0, 0.322608,-99) , 
3, 0.577397, 0, 0, 0.501204,-99)    );
  // itree = 116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.828859,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305666,-99) , 
0, 0.284185, 1, 0, 0.513085,-99) , 
NN(
0, 
0, 
-1, -1.19629, 0, -1, 0.193864,-99) , 
3, -0.148894, 0, 0, 0.327635,-99) , 
3, 0.760049, 0, 0, 0.47139,-99)    );
  // itree = 117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72376, 0, 1, 0.810089,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294466,-99) , 
0, 0.107175, 1, 0, 0.489219,-99) , 
3, 0.605528, 0, 0, 0.70456,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246903,-99) , 
0, -0.807552, 1, 0, 0.358925,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.14264,-99) , 
3, -0.648083, 0, 0, 0.2452,-99) , 
3, 0.179643, 0, 0, 0.456474,-99)    );
  // itree = 118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.873381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361206,-99) , 
0, 0.63113, 1, 0, 0.623271,-99) , 
3, 1.08754, 0, 0, 0.719618,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264921,-99) , 
0, -0.850436, 1, 0, 0.430012,-99) , 
NN(
0, 
0, 
-1, -1.64754, 0, -1, 0.14594,-99) , 
3, -0.800521, 0, 0, 0.278119,-99) , 
3, -0.0447319, 0, 0, 0.526365,-99)    );
  // itree = 119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.851641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343646,-99) , 
0, 0.0300823, 1, 0, 0.539648,-99) , 
3, 0.786077, 0, 0, 0.710381,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.193583,-99) , 
3, -0.100774, 0, 0, 0.477839,-99)    );
  // itree = 120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75291, 0, 1, 0.838949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.953194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472846,-99) , 
0, -0.0354634, 1, 0, 0.603099,-99) , 
3, 1.06094, 0, 0, 0.701267,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245929,-99) , 
0, -1.18749, 1, 0, 0.356804,-99) , 
NN(
0, 
0, 
-1, -1.89045, 0, -1, 0.0888174,-99) , 
3, -1.06796, 0, 0, 0.238041,-99) , 
3, -0.0725463, 0, 0, 0.500242,-99)    );
  // itree = 121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6302, 0, 1, 0.876438,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436666,-99) , 
0, 0.654863, 1, 0, 0.635819,-99) , 
3, 1.18964, 0, 0, 0.739654,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332663,-99) , 
0, -0.568658, 1, 0, 0.456732,-99) , 
NN(
0, 
0, 
-1, -1.66181, 0, -1, 0.170978,-99) , 
3, -0.545428, 0, 0, 0.299628,-99) , 
3, 0.225495, 0, 0, 0.493602,-99)    );
  // itree = 122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.878293,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249438,-99) , 
0, 0.913386, 1, 0, 0.58267,-99) , 
3, 1.07824, 0, 0, 0.68839,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.248258,-99) , 
3, -0.302053, 0, 0, 0.540496,-99)    );
  // itree = 123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2597, 1, 1, 0.866912,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311011,-99) , 
0, 0.40789, 1, 0, 0.535822,-99) , 
NN(
0, 
0, 
-1, -1.5759, 0, -1, 0.209028,-99) , 
3, -0.368043, 0, 0, 0.383493,-99) , 
3, 0.828289, 0, 0, 0.529734,-99)    );
  // itree = 124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.493679, 0, 1, 0.770993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574405,-99) , 
NN(
0, 
0, 
-1, -1.60872, 0, -1, 0.253647,-99) , 
3, -0.0100424, 0, 0, 0.306674,-99) , 
3, 0.27076, 0, 0, 0.5272,-99)    );
  // itree = 125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20165, 1, 1, 0.822346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243746,-99) , 
0, 0.134024, 1, 0, 0.521327,-99) , 
3, 0.598954, 0, 0, 0.676953,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.218963,-99) , 
3, -0.316527, 0, 0, 0.517982,-99)    );
  // itree = 126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11419, 0, 1, 0.802213,-99) , 
NN(
0, 
0, 
-1, -1.12817, 0, -1, 0.286334,-99) , 
3, 0.27076, 0, 0, 0.512354,-99)    );
  // itree = 127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.825505,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359219,-99) , 
0, 0.400931, 1, 0, 0.553412,-99) , 
3, 0.870114, 0, 0, 0.7228,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274453,-99) , 
0, -0.785825, 1, 0, 0.429696,-99) , 
NN(
0, 
0, 
-1, -1.36807, 1, -1, 0.178139,-99) , 
3, -0.554775, 0, 0, 0.28907,-99) , 
3, 0.256412, 0, 0, 0.474699,-99)    );
  // itree = 128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45756, 0, 1, 0.867404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359188,-99) , 
0, 0.924863, 1, 0, 0.626447,-99) , 
3, 1.12623, 0, 0, 0.750424,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204357,-99) , 
0, -0.128965, 1, 0, 0.41252,-99) , 
NN(
0, 
0, 
-1, -2.57351, 1, -1, 0.165664,-99) , 
3, -0.755429, 0, 0, 0.289533,-99) , 
3, 0.322617, 0, 0, 0.483705,-99)    );
  // itree = 129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.875134,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242495,-99) , 
0, 0.674788, 1, 0, 0.560583,-99) , 
3, 0.949517, 0, 0, 0.704234,-99) , 
NN(
0, 
0, 
-1, -1.75664, 0, -1, 0.188433,-99) , 
3, -0.218528, 0, 0, 0.491468,-99)    );
  // itree = 130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6338, 1, 1, 0.886393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424278,-99) , 
0, 1.022, 1, 0, 0.713438,-99) , 
3, 1.17269, 0, 0, 0.794318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274779,-99) , 
1, 0.141595, 1, 0, 0.411918,-99) , 
NN(
0, 
0, 
-1, -1.87096, 0, -1, 0.120521,-99) , 
3, -1.02631, 0, 0, 0.309917,-99) , 
3, 0.34753, 0, 0, 0.531287,-99)    );
  // itree = 131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.846637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.937564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483156,-99) , 
0, -0.147815, 1, 0, 0.589893,-99) , 
3, 1.06094, 0, 0, 0.693646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164503,-99) , 
0, -0.897721, 1, 0, 0.354883,-99) , 
NN(
0, 
0, 
-1, -1.70754, 0, -1, 0.0708878,-99) , 
3, -1.31821, 0, 0, 0.266058,-99) , 
3, -0.0725463, 0, 0, 0.506941,-99)    );
  // itree = 132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.41103, 1, 1, 0.911799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370127,-99) , 
0, 1.38055, 1, 0, 0.702451,-99) , 
3, 1.37778, 0, 0, 0.77668,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338155,-99) , 
0, -0.814411, 1, 0, 0.477196,-99) , 
NN(
0, 
0, 
-1, -1.42237, 0, -1, 0.163325,-99) , 
3, -0.480034, 0, 0, 0.308842,-99) , 
3, 0.34753, 0, 0, 0.513283,-99)    );
  // itree = 133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.718492, 1, 1, 0.957621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45545,-99) , 
3, 1.6009, 0, 0, 0.70395,-99) , 
0, 1.36618, 1, 0, 0.808452,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55936,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344629,-99) , 
3, -0.0203628, 0, 0, 0.433091,-99) , 
NN(
0, 
0, 
-1, -0.475247, 1, -1, 0.0942815,-99) , 
3, -1.13255, 0, 0, 0.359526,-99) , 
3, 0.661338, 0, 0, 0.501081,-99)    );
  // itree = 134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74073, 0, 1, 0.851861,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354612,-99) , 
0, 0.838292, 1, 0, 0.612156,-99) , 
3, 1.082, 0, 0, 0.735001,-99) , 
NN(
0, 
0, 
-1, -1.36141, 0, -1, 0.28175,-99) , 
3, 0.268003, 0, 0, 0.494965,-99)    );
  // itree = 135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.808207,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301375,-99) , 
0, 0.227133, 1, 0, 0.506119,-99) , 
3, 0.616752, 0, 0, 0.647759,-99) , 
NN(
0, 
0, 
-1, -1.73288, 0, -1, 0.176916,-99) , 
3, -0.613509, 0, 0, 0.50501,-99)    );
  // itree = 136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.655353, 0, 1, 0.858282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397087,-99) , 
3, 1.3712, 0, 0, 0.653807,-99) , 
0, 1.1852, 1, 0, 0.753719,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269096,-99) , 
1, 0.206016, 1, 0, 0.406301,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.164777,-99) , 
3, -0.58167, 0, 0, 0.271109,-99) , 
3, 0.27076, 0, 0, 0.473636,-99)    );
  // itree = 137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63415, 1, 1, 0.85118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321318,-99) , 
0, 0.715562, 1, 0, 0.581156,-99) , 
3, 1.01449, 0, 0, 0.729685,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285093,-99) , 
0, -1.30268, 1, 0, 0.362477,-99) , 
NN(
0, 
0, 
-1, -1.96805, 0, -1, 0.0981506,-99) , 
3, -1.13836, 0, 0, 0.277463,-99) , 
3, 0.208162, 0, 0, 0.496626,-99)    );
  // itree = 138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44843, 1, 1, 0.872708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232632,-99) , 
0, 0.91729, 1, 0, 0.559258,-99) , 
3, 1.05859, 0, 0, 0.674988,-99) , 
NN(
0, 
0, 
-1, -1.56687, 0, -1, 0.239858,-99) , 
3, -0.0725463, 0, 0, 0.488937,-99)    );
  // itree = 139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.10159, 0, 1, 0.8942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356045,-99) , 
0, 1.40292, 1, 0, 0.661094,-99) , 
3, 1.52631, 0, 0, 0.731362,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271039,-99) , 
0, -0.381656, 1, 0, 0.433253,-99) , 
NN(
0, 
0, 
-1, -0.837235, 1, -1, 0.165486,-99) , 
3, -0.751433, 0, 0, 0.305026,-99) , 
3, 0.322617, 0, 0, 0.493616,-99)    );
  // itree = 140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.859785,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358139,-99) , 
0, -0.02649, 1, 0, 0.528383,-99) , 
3, 0.952846, 0, 0, 0.663928,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.20121,-99) , 
3, -0.218528, 0, 0, 0.471321,-99)    );
  // itree = 141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28121, 1, 1, 0.828388,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272175,-99) , 
0, 0.138796, 1, 0, 0.518964,-99) , 
3, 0.628887, 0, 0, 0.676774,-99) , 
NN(
0, 
0, 
-1, -1.30677, 0, -1, 0.196612,-99) , 
3, -0.291428, 0, 0, 0.508629,-99)    );
  // itree = 142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13652, 0, 1, 0.830472,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289951,-99) , 
0, 0.446087, 1, 0, 0.546738,-99) , 
3, 0.781774, 0, 0, 0.721486,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287056,-99) , 
0, -0.993115, 1, 0, 0.430033,-99) , 
NN(
0, 
0, 
-1, -1.14278, 0, -1, 0.148587,-99) , 
3, -0.66376, 0, 0, 0.270263,-99) , 
3, 0.163853, 0, 0, 0.49771,-99)    );
  // itree = 143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.40209, 0, 1, 0.806431,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204346,-99) , 
0, 0.0208352, 1, 0, 0.439764,-99) , 
NN(
0, 
0, 
-1, -0.373426, 1, -1, 0.201641,-99) , 
3, -0.536792, 0, 0, 0.33588,-99) , 
3, 0.661338, 0, 0, 0.5026,-99)    );
  // itree = 144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66342, 0, 1, 0.829473,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39576,-99) , 
0, 0.193161, 1, 0, 0.578527,-99) , 
3, 1.01294, 0, 0, 0.679272,-99) , 
NN(
0, 
0, 
-1, -1.10165, 0, -1, 0.14604,-99) , 
3, -0.351682, 0, 0, 0.473813,-99)    );
  // itree = 145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41017, 0, 1, 0.822968,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339416,-99) , 
0, -0.120907, 1, 0, 0.498473,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.180008,-99) , 
3, -0.524691, 0, 0, 0.354445,-99) , 
3, 0.673895, 0, 0, 0.512026,-99)    );
  // itree = 146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19593, 0, 1, 0.829124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320637,-99) , 
0, 0.151248, 1, 0, 0.506383,-99) , 
3, 0.855457, 0, 0, 0.65142,-99) , 
NN(
0, 
0, 
-1, -1.00634, 0, -1, 0.214227,-99) , 
3, -0.266382, 0, 0, 0.50174,-99)    );
  // itree = 147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57208, 0, 1, 0.810398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417296,-99) , 
0, -0.909792, 1, 0, 0.495065,-99) , 
3, 0.838267, 0, 0, 0.625334,-99) , 
NN(
0, 
0, 
-1, -1.17855, 0, -1, 0.172918,-99) , 
3, -0.707817, 0, 0, 0.489579,-99)    );
  // itree = 148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57086, 1, 1, 0.815612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268338,-99) , 
0, 0.291557, 1, 0, 0.527223,-99) , 
3, 0.758758, 0, 0, 0.684325,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160855,-99) , 
3, -0.868008, 0, 0, 0.284102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0878161,-99) , 
0, -0.835383, 1, 0, 0.222059,-99) , 
3, -0.12622, 0, 0, 0.490729,-99)    );
  // itree = 149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.809031,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378259,-99) , 
0, -0.375998, 1, 0, 0.50776,-99) , 
3, 0.628149, 0, 0, 0.669418,-99) , 
NN(
0, 
0, 
-1, -1.30467, 0, -1, 0.187692,-99) , 
3, -0.291428, 0, 0, 0.517059,-99)    );
  // itree = 150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6841, 0, 1, 0.881004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254759,-99) , 
0, 1.09595, 1, 0, 0.58278,-99) , 
3, 1.18232, 0, 0, 0.672982,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.207249,-99) , 
3, -0.218528, 0, 0, 0.497693,-99)    );
  // itree = 151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.874508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480972,-99) , 
1, -0.589204, 1, 0, 0.555807,-99) , 
3, 1.19945, 0, 0, 0.650961,-99) , 
NN(
0, 
0, 
-1, -1.23125, 0, -1, 0.173095,-99) , 
3, -0.547237, 0, 0, 0.501617,-99)    );
  // itree = 152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.759671, 0, 1, 0.758458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612948,-99) , 
NN(
0, 
0, 
-1, -0.986477, 0, -1, 0.269532,-99) , 
3, 0.0725039, 0, 0, 0.32545,-99) , 
3, 0.34753, 0, 0, 0.508224,-99)    );
  // itree = 153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.837591, 1, 1, 0.951305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447292,-99) , 
3, 1.45973, 0, 0, 0.741382,-99) , 
0, 1.57086, 1, 0, 0.838579,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292492,-99) , 
0, 0.232439, 1, 0, 0.465882,-99) , 
NN(
0, 
0, 
-1, -1.58042, 0, -1, 0.180127,-99) , 
3, -0.363821, 0, 0, 0.336012,-99) , 
3, 0.828289, 0, 0, 0.487807,-99)    );
  // itree = 154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.834092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371024,-99) , 
0, 0.358008, 1, 0, 0.545145,-99) , 
3, 0.763515, 0, 0, 0.74639,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188366,-99) , 
0, -0.211204, 1, 0, 0.453557,-99) , 
NN(
0, 
0, 
-1, -1.56123, 0, -1, 0.173557,-99) , 
3, -0.698907, 0, 0, 0.324026,-99) , 
3, 0.361269, 0, 0, 0.511374,-99)    );
  // itree = 155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69738, 0, 1, 0.856305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413777,-99) , 
0, 0.204634, 1, 0, 0.632453,-99) , 
3, 0.763081, 0, 0, 0.788693,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370227,-99) , 
0, -0.766228, 1, 0, 0.476267,-99) , 
NN(
0, 
0, 
-1, -0.297941, 1, -1, 0.200518,-99) , 
3, -0.477004, 0, 0, 0.332137,-99) , 
3, 0.34753, 0, 0, 0.53227,-99)    );
  // itree = 156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.823687,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230522,-99) , 
0, 0.295007, 1, 0, 0.527321,-99) , 
3, 0.627829, 0, 0, 0.695054,-99) , 
NN(
0, 
0, 
-1, -1.64076, 0, -1, 0.2472,-99) , 
3, -0.241626, 0, 0, 0.535955,-99)    );
  // itree = 157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.901034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424288,-99) , 
0, 1.36347, 1, 0, 0.698642,-99) , 
3, 1.43545, 0, 0, 0.80371,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350013,-99) , 
0, -0.630722, 1, 0, 0.468964,-99) , 
NN(
0, 
0, 
-1, -1.17128, 0, -1, 0.182653,-99) , 
3, -0.458317, 0, 0, 0.326406,-99) , 
3, 0.712472, 0, 0, 0.48166,-99)    );
  // itree = 158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.747475, 0, 1, 0.733121,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.129337,-99) , 
0, -0.114347, 1, 0, 0.394077,-99) , 
NN(
0, 
0, 
-1, -0.687486, 1, -1, 0.1529,-99) , 
3, -0.453485, 0, 0, 0.257813,-99) , 
3, 0.34765, 0, 0, 0.455873,-99)    );
  // itree = 159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.800449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238061,-99) , 
0, 0.199273, 1, 0, 0.509606,-99) , 
3, 0.628149, 0, 0, 0.6579,-99) , 
NN(
0, 
0, 
-1, -1.05418, 0, -1, 0.205866,-99) , 
3, -0.291428, 0, 0, 0.490545,-99)    );
  // itree = 160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.207822, 1, 1, 0.74421,-99) , 
NN(
0, 
0, 
-1, -0.539811, 0, -1, 0.243306,-99) , 
3, -0.0426953, 0, 0, 0.504339,-99)    );
  // itree = 161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68664, 0, 1, 0.859032,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.923278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410143,-99) , 
0, 0.0681851, 1, 0, 0.587854,-99) , 
3, 0.975058, 0, 0, 0.7078,-99) , 
NN(
0, 
0, 
-1, -1.50435, 0, -1, 0.207684,-99) , 
3, -0.218528, 0, 0, 0.513741,-99)    );
  // itree = 162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.882671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248622,-99) , 
0, 0.913386, 1, 0, 0.585767,-99) , 
3, 1.01767, 0, 0, 0.712171,-99) , 
NN(
0, 
0, 
-1, -0.646707, 0, -1, 0.233775,-99) , 
3, -0.133228, 0, 0, 0.51347,-99)    );
  // itree = 163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12756, 0, 1, 0.862305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331302,-99) , 
0, 0.592338, 1, 0, 0.586101,-99) , 
3, 0.950076, 0, 0, 0.692049,-99) , 
NN(
0, 
0, 
-1, -1.23125, 0, -1, 0.16289,-99) , 
3, -0.547237, 0, 0, 0.526055,-99)    );
  // itree = 164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.31919, 1, 1, 0.847502,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382864,-99) , 
0, -0.509041, 1, 0, 0.527953,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.163099,-99) , 
3, -0.575176, 0, 0, 0.390381,-99) , 
3, 0.609067, 0, 0, 0.550574,-99)    );
  // itree = 165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.870741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323476,-99) , 
0, 0.835519, 1, 0, 0.654946,-99) , 
3, 1.082, 0, 0, 0.764773,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23101,-99) , 
0, -0.333179, 1, 0, 0.422058,-99) , 
NN(
0, 
0, 
-1, -1.72323, 0, -1, 0.183169,-99) , 
3, -0.556859, 0, 0, 0.28902,-99) , 
3, 0.268003, 0, 0, 0.50431,-99)    );
  // itree = 166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.891993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300077,-99) , 
0, 0.969329, 1, 0, 0.594129,-99) , 
3, 1.18232, 0, 0, 0.696832,-99) , 
NN(
0, 
0, 
-1, -0.477912, 0, -1, 0.225941,-99) , 
3, -0.218528, 0, 0, 0.497112,-99)    );
  // itree = 167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66477, 0, 1, 0.803283,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328176,-99) , 
0, -0.11235, 1, 0, 0.507881,-99) , 
3, 0.723661, 0, 0, 0.643318,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.15283,-99) , 
3, -0.516641, 0, 0, 0.503422,-99)    );
  // itree = 168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.01203, 0, 1, 0.833622,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268151,-99) , 
3, -0.550698, 0, 0, 0.447306,-99) , 
NN(
0, 
0, 
-1, -0.198685, 0, -1, 0.196104,-99) , 
1, 0.291673, 1, 0, 0.331922,-99) , 
3, 0.644232, 0, 0, 0.495554,-99)    );
  // itree = 169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61008, 0, 1, 0.813245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291891,-99) , 
0, -0.105086, 1, 0, 0.518666,-99) , 
3, 0.38342, 0, 0, 0.733021,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.234885,-99) , 
3, -0.0725463, 0, 0, 0.522111,-99)    );
  // itree = 170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.877454,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.931371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494886,-99) , 
0, -0.443506, 1, 0, 0.579799,-99) , 
3, 1.12038, 0, 0, 0.690982,-99) , 
NN(
0, 
0, 
-1, -1.71764, 0, -1, 0.205654,-99) , 
3, -0.231227, 0, 0, 0.498828,-99)    );
  // itree = 171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40626, 0, 1, 0.826618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362328,-99) , 
0, -0.176639, 1, 0, 0.565411,-99) , 
3, 0.380636, 0, 0, 0.754414,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276093,-99) , 
3, -0.418526, 0, 0, 0.367954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0398507,-99) , 
3, -1.31839, 0, 0, 0.284344,-99) , 
3, -0.0725463, 0, 0, 0.55451,-99)    );
  // itree = 172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21585, 1, 1, 0.874445,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388393,-99) , 
0, 0.830155, 1, 0, 0.626021,-99) , 
3, 1.11463, 0, 0, 0.752843,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390483,-99) , 
0, -0.878624, 1, 0, 0.474397,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.186942,-99) , 
3, -0.569108, 0, 0, 0.3019,-99) , 
3, 0.27076, 0, 0, 0.511973,-99)    );
  // itree = 173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3508, 0, 1, 0.777044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325489,-99) , 
0, 0.16021, 1, 0, 0.528585,-99) , 
3, 0.560587, 0, 0, 0.68263,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.268117,-99) , 
3, -0.133228, 0, 0, 0.508188,-99)    );
  // itree = 174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.542186, 1, 1, 0.801507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362303,-99) , 
0, -0.0558779, 1, 0, 0.522208,-99) , 
3, 0.551802, 0, 0, 0.700191,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274517,-99) , 
3, -1.09517, 0, 0, 0.438811,-99) , 
NN(
0, 
0, 
-1, -1.09677, 0, -1, 0.182476,-99) , 
1, -0.125285, 1, 0, 0.287409,-99) , 
3, -0.117632, 0, 0, 0.535478,-99)    );
  // itree = 175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.082, 0, 1, 0.791923,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347517,-99) , 
0, -0.862067, 1, 0, 0.460678,-99) , 
NN(
0, 
0, 
-1, -1.95385, 0, -1, 0.169081,-99) , 
3, -0.556859, 0, 0, 0.301949,-99) , 
3, 0.268003, 0, 0, 0.529135,-99)    );
  // itree = 176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.31919, 1, 1, 0.809789,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337751,-99) , 
0, -0.516824, 1, 0, 0.458209,-99) , 
NN(
0, 
0, 
-1, -1.15996, 0, -1, 0.160844,-99) , 
3, -0.474728, 0, 0, 0.317939,-99) , 
3, 0.645553, 0, 0, 0.47953,-99)    );
  // itree = 177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58217, 0, 1, 0.865521,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13149,-99) , 
0, 1.14108, 1, 0, 0.552465,-99) , 
3, 1.08991, 0, 0, 0.663345,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.234794,-99) , 
3, -0.291428, 0, 0, 0.521694,-99)    );
  // itree = 178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.847565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353318,-99) , 
0, 0.0304304, 1, 0, 0.52538,-99) , 
3, 0.926722, 0, 0, 0.670629,-99) , 
NN(
0, 
0, 
-1, -0.706455, 0, -1, 0.182621,-99) , 
3, -0.206128, 0, 0, 0.477536,-99)    );
  // itree = 179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.812738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394686,-99) , 
0, -0.000706236, 1, 0, 0.555531,-99) , 
3, 0.716715, 0, 0, 0.692721,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.220446,-99) , 
3, -0.218528, 0, 0, 0.484203,-99)    );
  // itree = 180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43988, 0, 1, 0.786449,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274737,-99) , 
0, -0.499885, 1, 0, 0.447165,-99) , 
NN(
0, 
0, 
-1, -1.54171, 0, -1, 0.156455,-99) , 
3, -0.657231, 0, 0, 0.323135,-99) , 
3, 0.42901, 0, 0, 0.519698,-99)    );
  // itree = 181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.842218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462063,-99) , 
3, 0.611347, 0, 0, 0.767048,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263248,-99) , 
0, -0.447798, 1, 0, 0.409634,-99) , 
NN(
0, 
0, 
-1, -1.57197, 0, -1, 0.159513,-99) , 
3, -0.686658, 0, 0, 0.306494,-99) , 
3, 0.402144, 0, 0, 0.489382,-99)    );
  // itree = 182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58176, 1, 1, 0.85837,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3467,-99) , 
0, 0.865651, 1, 0, 0.61115,-99) , 
3, 1.08446, 0, 0, 0.73258,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.1645,-99) , 
0, -0.211204, 1, 0, 0.466584,-99) , 
NN(
0, 
0, 
-1, -1.63258, 0, -1, 0.154281,-99) , 
3, -0.766855, 0, 0, 0.309271,-99) , 
3, 0.287809, 0, 0, 0.501433,-99)    );
  // itree = 183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57181, 0, 1, 0.800705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253387,-99) , 
0, 0.503018, 1, 0, 0.493466,-99) , 
3, 0.838267, 0, 0, 0.614752,-99) , 
NN(
0, 
0, 
-1, -1.41868, 0, -1, 0.136023,-99) , 
3, -0.707817, 0, 0, 0.472957,-99)    );
  // itree = 184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.872746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435956,-99) , 
0, -0.0346559, 1, 0, 0.540174,-99) , 
3, 1.18232, 0, 0, 0.650116,-99) , 
NN(
0, 
0, 
-1, -0.990191, 0, -1, 0.203611,-99) , 
3, -0.218528, 0, 0, 0.477579,-99)    );
  // itree = 185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.822514,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414592,-99) , 
0, -0.341503, 1, 0, 0.536182,-99) , 
3, 0.725679, 0, 0, 0.673379,-99) , 
NN(
0, 
0, 
-1, -1.6533, 0, -1, 0.181584,-99) , 
3, -0.415423, 0, 0, 0.49818,-99)    );
  // itree = 186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45338, 0, 1, 0.790309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488451,-99) , 
3, 0.479304, 0, 0, 0.738428,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339464,-99) , 
0, -0.795814, 1, 0, 0.481766,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.174908,-99) , 
3, -0.554775, 0, 0, 0.300058,-99) , 
3, 0.268003, 0, 0, 0.506365,-99)    );
  // itree = 187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22634, 0, 1, 0.823194,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223108,-99) , 
0, 0.327896, 1, 0, 0.447275,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.17576,-99) , 
3, -0.537744, 0, 0, 0.32929,-99) , 
3, 0.673895, 0, 0, 0.493678,-99)    );
  // itree = 188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.809231,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170176,-99) , 
0, 0.402597, 1, 0, 0.489872,-99) , 
3, 0.628149, 0, 0, 0.654155,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.194011,-99) , 
3, -0.291428, 0, 0, 0.489815,-99)    );
  // itree = 189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.856841,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366129,-99) , 
0, 0.284185, 1, 0, 0.581492,-99) , 
3, 0.86134, 0, 0, 0.703089,-99) , 
NN(
0, 
0, 
-1, -1.56253, 0, -1, 0.21626,-99) , 
3, -0.291428, 0, 0, 0.5316,-99)    );
  // itree = 190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.902542, 0, 1, 0.869881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383545,-99) , 
3, 1.51903, 0, 0, 0.660112,-99) , 
0, 1.33331, 1, 0, 0.763839,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307897,-99) , 
0, -0.305342, 1, 0, 0.432513,-99) , 
NN(
0, 
0, 
-1, -1.66415, 0, -1, 0.160978,-99) , 
3, -0.481272, 0, 0, 0.270232,-99) , 
3, 0.34753, 0, 0, 0.479092,-99)    );
  // itree = 191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.642081, 0, 1, 0.844612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391487,-99) , 
3, 1.58734, 0, 0, 0.673718,-99) , 
0, 1.45516, 1, 0, 0.768468,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217475,-99) , 
0, -0.150485, 1, 0, 0.395206,-99) , 
NN(
0, 
0, 
-1, -1.17507, 0, -1, 0.129602,-99) , 
3, -0.70057, 0, 0, 0.274064,-99) , 
3, 0.361269, 0, 0, 0.472651,-99)    );
  // itree = 192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.30225, 0, 1, 0.873555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443001,-99) , 
0, 0.758594, 1, 0, 0.64061,-99) , 
3, 1.11291, 0, 0, 0.748274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629365,-99) , 
NN(
0, 
0, 
-1, -1.08387, 0, -1, 0.230623,-99) , 
3, -0.0100424, 0, 0, 0.286652,-99) , 
3, 0.27076, 0, 0, 0.49871,-99)    );
  // itree = 193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60699, 1, 1, 0.848171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297531,-99) , 
0, 0.097998, 1, 0, 0.492899,-99) , 
3, 0.832586, 0, 0, 0.62899,-99) , 
NN(
0, 
0, 
-1, -1.17855, 0, -1, 0.158465,-99) , 
3, -0.707817, 0, 0, 0.501383,-99)    );
  // itree = 194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.646383, 0, 1, 0.769336,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31188,-99) , 
3, -0.0678223, 0, 0, 0.423198,-99) , 
NN(
0, 
0, 
-1, -1.72892, 0, -1, 0.14035,-99) , 
3, -0.569465, 0, 0, 0.262392,-99) , 
3, 0.240623, 0, 0, 0.494671,-99)    );
  // itree = 195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.40361, 0, 1, 0.805516,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254095,-99) , 
0, 0.08705, 1, 0, 0.492687,-99) , 
NN(
0, 
0, 
-1, -1.63106, 0, -1, 0.179711,-99) , 
3, -0.370675, 0, 0, 0.317018,-99) , 
3, 0.504887, 0, 0, 0.502329,-99)    );
  // itree = 196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.747895, 0, 1, 0.777944,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669615,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277125,-99) , 
0, -0.33857, 1, 0, 0.455947,-99) , 
NN(
0, 
0, 
-1, -1.58005, 0, -1, 0.171629,-99) , 
3, -0.444478, 0, 0, 0.301362,-99) , 
3, 0.349678, 0, 0, 0.511185,-99)    );
  // itree = 197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.810903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251728,-99) , 
0, 0.46105, 1, 0, 0.565439,-99) , 
3, 0.784282, 0, 0, 0.683032,-99) , 
NN(
0, 
0, 
-1, -0.639048, 0, -1, 0.198918,-99) , 
3, -0.133228, 0, 0, 0.481141,-99)    );
  // itree = 198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.87935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41474,-99) , 
0, 0.937344, 1, 0, 0.634647,-99) , 
3, 1.18232, 0, 0, 0.713668,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222885,-99) , 
1, -0.285688, 1, 0, 0.326033,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.0982729,-99) , 
3, -1.2441, 0, 0, 0.235758,-99) , 
3, -0.218528, 0, 0, 0.511547,-99)    );
  // itree = 199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.809555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.908251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342741,-99) , 
0, 0.0485455, 1, 0, 0.579547,-99) , 
3, 0.606621, 0, 0, 0.72644,-99) , 
NN(
0, 
0, 
-1, -0.572723, 0, -1, 0.24056,-99) , 
3, -0.0725463, 0, 0, 0.503175,-99)    );
  // itree = 200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.855124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248188,-99) , 
0, 0.439034, 1, 0, 0.571509,-99) , 
3, 0.831979, 0, 0, 0.750169,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335858,-99) , 
0, -0.477384, 1, 0, 0.461989,-99) , 
NN(
0, 
0, 
-1, -0.00674708, 1, -1, 0.19919,-99) , 
3, -0.363853, 0, 0, 0.286637,-99) , 
3, 0.191234, 0, 0, 0.504376,-99)    );
  // itree = 201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.880924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417533,-99) , 
0, 0.835519, 1, 0, 0.681993,-99) , 
3, 1.17269, 0, 0, 0.776728,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33159,-99) , 
0, -0.996671, 1, 0, 0.441869,-99) , 
NN(
0, 
0, 
-1, -1.41959, 0, -1, 0.155286,-99) , 
3, -0.751702, 0, 0, 0.309341,-99) , 
3, 0.34753, 0, 0, 0.496007,-99)    );
  // itree = 202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19955, 0, 1, 0.913583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469351,-99) , 
3, 1.56108, 0, 0, 0.75222,-99) , 
0, 1.39628, 1, 0, 0.819022,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22026,-99) , 
0, 0.347062, 1, 0, 0.432741,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.0705603,-99) , 
3, -1.25637, 0, 0, 0.366067,-99) , 
3, 0.828289, 0, 0, 0.507225,-99)    );
  // itree = 203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32178, 0, 1, 0.839381,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26221,-99) , 
0, 0.0477724, 1, 0, 0.464606,-99) , 
NN(
0, 
0, 
-1, -1.93534, 0, -1, 0.169071,-99) , 
3, -0.458101, 0, 0, 0.327801,-99) , 
3, 0.760049, 0, 0, 0.483245,-99)    );
  // itree = 204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7149, 0, 1, 0.810987,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.938419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347272,-99) , 
0, 0.0681851, 1, 0, 0.563242,-99) , 
3, 0.784282, 0, 0, 0.690539,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159154,-99) , 
0, -0.938985, 1, 0, 0.352085,-99) , 
NN(
0, 
0, 
-1, -0.170557, 1, -1, 0.101292,-99) , 
3, -1.14247, 0, 0, 0.26271,-99) , 
3, -0.133228, 0, 0, 0.520493,-99)    );
  // itree = 205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78031, 1, 1, 0.828719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352263,-99) , 
0, 0.574351, 1, 0, 0.621626,-99) , 
3, 0.959858, 0, 0, 0.713174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168758,-99) , 
0, -1.43863, 1, 0, 0.312784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0660828,-99) , 
3, -1.50247, 0, 0, 0.251846,-99) , 
3, -0.218528, 0, 0, 0.532483,-99)    );
  // itree = 206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80937, 1, 1, 0.908497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478829,-99) , 
0, 1.38486, 1, 0, 0.733169,-99) , 
3, 1.41017, 0, 0, 0.813423,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25754,-99) , 
0, -0.0153026, 1, 0, 0.432261,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.178762,-99) , 
3, -0.531196, 0, 0, 0.31224,-99) , 
3, 0.673895, 0, 0, 0.479426,-99)    );
  // itree = 207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.880296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466695,-99) , 
0, 0.272017, 1, 0, 0.595581,-99) , 
3, 1.17174, 0, 0, 0.729493,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234956,-99) , 
0, -0.345495, 1, 0, 0.444918,-99) , 
NN(
0, 
0, 
-1, -1.18474, 0, -1, 0.210818,-99) , 
3, -0.476904, 0, 0, 0.314261,-99) , 
3, 0.34753, 0, 0, 0.492951,-99)    );
  // itree = 208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.869105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471951,-99) , 
0, 0.91729, 1, 0, 0.644688,-99) , 
3, 1.25284, 0, 0, 0.739996,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341824,-99) , 
0, -1.02297, 1, 0, 0.456165,-99) , 
NN(
0, 
0, 
-1, 0.45974, 1, -1, 0.142121,-99) , 
3, -0.575192, 0, 0, 0.289547,-99) , 
3, 0.240623, 0, 0, 0.495408,-99)    );
  // itree = 209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.975568, 1, 1, 0.782269,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258045,-99) , 
0, 0.227133, 1, 0, 0.506748,-99) , 
NN(
0, 
0, 
-1, -1.74341, 0, -1, 0.199246,-99) , 
3, -0.535926, 0, 0, 0.37765,-99) , 
3, 0.661338, 0, 0, 0.506757,-99)    );
  // itree = 210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.965707, 0, 1, 0.775167,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247206,-99) , 
0, -0.289682, 1, 0, 0.445028,-99) , 
NN(
0, 
0, 
-1, -1.66614, 0, -1, 0.169196,-99) , 
3, -0.751702, 0, 0, 0.324062,-99) , 
3, 0.34753, 0, 0, 0.523044,-99)    );
  // itree = 211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.838981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327571,-99) , 
0, 0.927227, 1, 0, 0.563933,-99) , 
3, 1.12842, 0, 0, 0.647232,-99) , 
NN(
0, 
0, 
-1, -1.67157, 1, -1, 0.154004,-99) , 
3, -0.582913, 0, 0, 0.490019,-99)    );
  // itree = 212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.969447,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414689,-99) , 
3, 1.23955, 0, 0, 0.724712,-99) , 
0, 1.11079, 1, 0, 0.797904,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319697,-99) , 
0, 0.123422, 1, 0, 0.510783,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.19622,-99) , 
3, -0.535926, 0, 0, 0.37826,-99) , 
3, 0.673895, 0, 0, 0.522317,-99)    );
  // itree = 213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61354, 0, 1, 0.887881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37369,-99) , 
0, 0.35154, 1, 0, 0.548101,-99) , 
3, 1.132, 0, 0, 0.678434,-99) , 
NN(
0, 
0, 
-1, -0.70236, 0, -1, 0.220122,-99) , 
3, -0.2003, 0, 0, 0.496286,-99)    );
  // itree = 214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.901776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390492,-99) , 
0, 0.446638, 1, 0, 0.584848,-99) , 
3, 1.18232, 0, 0, 0.690653,-99) , 
NN(
0, 
0, 
-1, -1.75861, 0, -1, 0.206381,-99) , 
3, -0.218528, 0, 0, 0.498101,-99)    );
  // itree = 215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.820736,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41321,-99) , 
0, -0.170697, 1, 0, 0.579286,-99) , 
3, 0.609259, 0, 0, 0.729455,-99) , 
NN(
0, 
0, 
-1, -1.08231, 0, -1, 0.200054,-99) , 
3, -0.0725463, 0, 0, 0.48656,-99)    );
  // itree = 216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.862792,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346291,-99) , 
0, 0.733856, 1, 0, 0.570162,-99) , 
3, 1.12766, 0, 0, 0.677944,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214344,-99) , 
0, -1.27251, 1, 0, 0.334722,-99) , 
NN(
0, 
0, 
-1, -1.77532, 0, -1, 0.0739619,-99) , 
3, -1.17172, 0, 0, 0.226285,-99) , 
3, -0.2003, 0, 0, 0.501203,-99)    );
  // itree = 217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.711681, 1, 1, 0.916489,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.885234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497549,-99) , 
3, 1.53457, 0, 0, 0.763324,-99) , 
0, 1.58243, 1, 0, 0.831484,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249849,-99) , 
0, 0.141218, 1, 0, 0.424903,-99) , 
NN(
0, 
0, 
-1, -1.55278, 0, -1, 0.156641,-99) , 
3, -0.658515, 0, 0, 0.321526,-99) , 
3, 0.79068, 0, 0, 0.484142,-99)    );
  // itree = 218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.03588, 0, 1, 0.783926,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.129872,-99) , 
0, 0.497677, 1, 0, 0.447789,-99) , 
NN(
0, 
0, 
-1, -2.59033, 1, -1, 0.12398,-99) , 
3, -0.833854, 0, 0, 0.334215,-99) , 
3, 0.661338, 0, 0, 0.480761,-99)    );
  // itree = 219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.68729, 0, 1, 0.826091,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271773,-99) , 
0, 0.133718, 1, 0, 0.499685,-99) , 
NN(
0, 
0, 
-1, -1.56443, 0, -1, 0.165754,-99) , 
3, -0.658515, 0, 0, 0.365392,-99) , 
3, 0.79068, 0, 0, 0.510919,-99)    );
  // itree = 220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.896116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311722,-99) , 
0, 0.930221, 1, 0, 0.567706,-99) , 
3, 1.18232, 0, 0, 0.682638,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.198895,-99) , 
3, -0.218528, 0, 0, 0.4757,-99)    );
  // itree = 221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.932398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.875497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469151,-99) , 
0, 1.52925, 1, 0, 0.739442,-99) , 
3, 1.69284, 0, 0, 0.80245,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252304,-99) , 
0, 0.431079, 1, 0, 0.475583,-99) , 
NN(
0, 
0, 
-1, -1.45297, 0, -1, 0.171996,-99) , 
3, -0.755609, 0, 0, 0.367751,-99) , 
3, 0.760049, 0, 0, 0.505576,-99)    );
  // itree = 222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04132, 0, 1, 0.798035,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243537,-99) , 
0, 0.123422, 1, 0, 0.491866,-99) , 
NN(
0, 
0, 
-1, -1.30151, 0, -1, 0.145004,-99) , 
3, -0.543671, 0, 0, 0.351292,-99) , 
3, 0.661338, 0, 0, 0.501002,-99)    );
  // itree = 223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45767, 0, 1, 0.83495,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.935204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349487,-99) , 
0, 0.137793, 1, 0, 0.565279,-99) , 
3, 0.690724, 0, 0, 0.749086,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342731,-99) , 
0, -0.785825, 1, 0, 0.431468,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.167765,-99) , 
3, -0.569108, 0, 0, 0.287005,-99) , 
3, 0.27076, 0, 0, 0.510977,-99)    );
  // itree = 224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.84944,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229918,-99) , 
0, 0.227133, 1, 0, 0.494744,-99) , 
NN(
0, 
0, 
-1, -0.0944858, 1, -1, 0.160833,-99) , 
3, -0.535926, 0, 0, 0.335908,-99) , 
3, 0.661338, 0, 0, 0.506991,-99)    );
  // itree = 225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67794, 0, 1, 0.820637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269363,-99) , 
0, 0.242272, 1, 0, 0.567361,-99) , 
3, 0.778116, 0, 0, 0.693709,-99) , 
NN(
0, 
0, 
-1, -1.0928, 0, -1, 0.24706,-99) , 
3, -0.117632, 0, 0, 0.499225,-99)    );
  // itree = 226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.820225,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190525,-99) , 
0, 0.227133, 1, 0, 0.403796,-99) , 
NN(
0, 
0, 
-1, -2.07612, 1, -1, 0.147105,-99) , 
3, -0.689182, 0, 0, 0.303142,-99) , 
3, 0.749733, 0, 0, 0.454659,-99)    );
  // itree = 227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.33132, 0, 1, 0.816011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225229,-99) , 
0, 0.179441, 1, 0, 0.478594,-99) , 
NN(
0, 
0, 
-1, -1.51657, 0, -1, 0.162991,-99) , 
3, -0.640199, 0, 0, 0.361234,-99) , 
3, 0.800375, 0, 0, 0.505576,-99)    );
  // itree = 228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832592, 0, 1, 0.756001,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220851,-99) , 
0, 0.0584112, 1, 0, 0.452919,-99) , 
NN(
0, 
0, 
-1, -2.57351, 1, -1, 0.182553,-99) , 
3, -0.657516, 0, 0, 0.332766,-99) , 
3, 0.427177, 0, 0, 0.504113,-99)    );
  // itree = 229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26278, 1, 1, 0.800316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36832,-99) , 
0, 0.0381911, 1, 0, 0.523791,-99) , 
3, 0.926104, 0, 0, 0.655855,-99) , 
NN(
0, 
0, 
-1, -1.20278, 0, -1, 0.177027,-99) , 
3, -0.206128, 0, 0, 0.454146,-99)    );
  // itree = 230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15928, 0, 1, 0.816713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222923,-99) , 
0, 0.453613, 1, 0, 0.557786,-99) , 
3, 0.785617, 0, 0, 0.680436,-99) , 
NN(
0, 
0, 
-1, -1.1004, 0, -1, 0.167277,-99) , 
3, -0.436378, 0, 0, 0.514962,-99)    );
  // itree = 231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.85998,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271566,-99) , 
0, 0.91729, 1, 0, 0.560461,-99) , 
3, 1.15758, 0, 0, 0.654264,-99) , 
NN(
0, 
0, 
-1, -1.69911, 0, -1, 0.193747,-99) , 
3, -0.206128, 0, 0, 0.480987,-99)    );
  // itree = 232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6193, 0, 1, 0.873933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376737,-99) , 
0, 0.985639, 1, 0, 0.643067,-99) , 
3, 1.11005, 0, 0, 0.75465,-99) , 
NN(
0, 
0, 
-1, -1.12817, 0, -1, 0.290112,-99) , 
3, 0.27076, 0, 0, 0.507269,-99)    );
  // itree = 233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.09943, 0, 1, 0.826621,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305129,-99) , 
0, -0.0721965, 1, 0, 0.489313,-99) , 
NN(
0, 
0, 
-1, -1.64834, 0, -1, 0.213441,-99) , 
3, -0.451149, 0, 0, 0.376021,-99) , 
3, 0.729578, 0, 0, 0.525495,-99)    );
  // itree = 234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14205, 0, 1, 0.8434,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244127,-99) , 
0, 0.461096, 1, 0, 0.518825,-99) , 
3, 0.792571, 0, 0, 0.669898,-99) , 
NN(
0, 
0, 
-1, -1.60075, 0, -1, 0.212864,-99) , 
3, -0.346282, 0, 0, 0.504624,-99)    );
  // itree = 235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11005, 0, 1, 0.77739,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199697,-99) , 
0, -0.333179, 1, 0, 0.404687,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.159083,-99) , 
3, -0.569108, 0, 0, 0.283513,-99) , 
3, 0.27076, 0, 0, 0.51638,-99)    );
  // itree = 236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.871458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431375,-99) , 
0, 0.924863, 1, 0, 0.645373,-99) , 
3, 1.17269, 0, 0, 0.756481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.144116,-99) , 
0, 0.00977593, 1, 0, 0.401314,-99) , 
NN(
0, 
0, 
-1, -1.87446, 0, -1, 0.09246,-99) , 
3, -1.03683, 0, 0, 0.303751,-99) , 
3, 0.34753, 0, 0, 0.494743,-99)    );
  // itree = 237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32898, 1, 1, 0.808381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239746,-99) , 
0, 0.277937, 1, 0, 0.529199,-99) , 
3, 0.620014, 0, 0, 0.676799,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.229651,-99) , 
3, -0.302053, 0, 0, 0.517791,-99)    );
  // itree = 238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.920631,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.936489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484852,-99) , 
0, -0.0354634, 1, 0, 0.61483,-99) , 
3, 1.19191, 0, 0, 0.721436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185992,-99) , 
0, -1.01752, 1, 0, 0.338617,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.113262,-99) , 
3, -1.14757, 0, 0, 0.249511,-99) , 
3, -0.145446, 0, 0, 0.53672,-99)    );
  // itree = 239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.879412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.898005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407366,-99) , 
0, 0.262911, 1, 0, 0.618607,-99) , 
3, 1.05859, 0, 0, 0.73433,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.2202,-99) , 
3, -0.0725463, 0, 0, 0.50327,-99)    );
  // itree = 240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00273, 1, 1, 0.83149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214964,-99) , 
0, 0.674788, 1, 0, 0.56836,-99) , 
3, 0.952846, 0, 0, 0.681443,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.204399,-99) , 
3, -0.218528, 0, 0, 0.49703,-99)    );
  // itree = 241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09335, 0, 1, 0.82643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322721,-99) , 
0, 0.0804575, 1, 0, 0.537643,-99) , 
3, 0.487657, 0, 0, 0.722494,-99) , 
NN(
0, 
0, 
-1, -1.24961, 0, -1, 0.181807,-99) , 
3, -0.218528, 0, 0, 0.503364,-99)    );
  // itree = 242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.926206, 1, 1, 0.835886,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293848,-99) , 
0, -0.000706236, 1, 0, 0.504567,-99) , 
NN(
0, 
0, 
-1, -1.15957, 0, -1, 0.174456,-99) , 
3, -0.445426, 0, 0, 0.348753,-99) , 
3, 0.729578, 0, 0, 0.495641,-99)    );
  // itree = 243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8044, 1, 1, 0.861787,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348574,-99) , 
0, 0.71825, 1, 0, 0.584856,-99) , 
3, 1.11005, 0, 0, 0.714144,-99) , 
NN(
0, 
0, 
-1, -1.13818, 0, -1, 0.285549,-99) , 
3, 0.27076, 0, 0, 0.467726,-99)    );
  // itree = 244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.846078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44338,-99) , 
0, 0.295007, 1, 0, 0.593854,-99) , 
3, 0.95924, 0, 0, 0.705112,-99) , 
NN(
0, 
0, 
-1, -0.734051, 0, -1, 0.221746,-99) , 
3, -0.218528, 0, 0, 0.52073,-99)    );
  // itree = 245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.594254, 0, 1, 0.72035,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25448,-99) , 
0, -0.411792, 1, 0, 0.435532,-99) , 
NN(
0, 
0, 
-1, -1.91897, 1, -1, 0.156528,-99) , 
3, -0.647965, 0, 0, 0.27433,-99) , 
3, 0.179643, 0, 0, 0.484795,-99)    );
  // itree = 246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.873867,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.905731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463179,-99) , 
0, 0.233288, 1, 0, 0.579965,-99) , 
3, 1.082, 0, 0, 0.717943,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183746,-99) , 
0, -0.319023, 1, 0, 0.378105,-99) , 
NN(
0, 
0, 
-1, -1.49149, 0, -1, 0.163761,-99) , 
3, -0.557209, 0, 0, 0.259452,-99) , 
3, 0.268003, 0, 0, 0.468512,-99)    );
  // itree = 247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13381, 0, 1, 0.838616,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322548,-99) , 
1, 0.0944828, 1, 0, 0.497348,-99) , 
NN(
0, 
0, 
-1, -1.68618, 0, -1, 0.196441,-99) , 
3, -0.458101, 0, 0, 0.362456,-99) , 
3, 0.760049, 0, 0, 0.51273,-99)    );
  // itree = 248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.845908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254452,-99) , 
0, 0.259657, 1, 0, 0.492888,-99) , 
3, 0.633338, 0, 0, 0.675552,-99) , 
NN(
0, 
0, 
-1, -2.6042, 1, -1, 0.147704,-99) , 
3, -0.260982, 0, 0, 0.46435,-99)    );
  // itree = 249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.875417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391855,-99) , 
0, 0.779258, 1, 0, 0.637004,-99) , 
3, 1.1935, 0, 0, 0.72383,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202259,-99) , 
0, -0.369077, 1, 0, 0.4174,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.13891,-99) , 
3, -0.662162, 0, 0, 0.263049,-99) , 
3, 0.163853, 0, 0, 0.491826,-99)    );
  // itree = 250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33875, 0, 1, 0.875819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372209,-99) , 
0, 0.596159, 1, 0, 0.598816,-99) , 
3, 1.00299, 0, 0, 0.705598,-99) , 
NN(
0, 
0, 
-1, -1.7021, 0, -1, 0.132435,-99) , 
3, -0.783748, 0, 0, 0.557483,-99)    );
  // itree = 251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.870112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345499,-99) , 
0, 1.11484, 1, 0, 0.667115,-99) , 
3, 1.17269, 0, 0, 0.765106,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258216,-99) , 
0, -0.000706236, 1, 0, 0.468851,-99) , 
NN(
0, 
0, 
-1, -1.1834, 0, -1, 0.181623,-99) , 
3, -0.477004, 0, 0, 0.328185,-99) , 
3, 0.34753, 0, 0, 0.519328,-99)    );
  // itree = 252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.116, 1, 1, 0.861385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383617,-99) , 
0, 0.0921449, 1, 0, 0.54626,-99) , 
3, 0.95974, 0, 0, 0.679346,-99) , 
NN(
0, 
0, 
-1, -1.38737, 0, -1, 0.2406,-99) , 
3, -0.156071, 0, 0, 0.494597,-99)    );
  // itree = 253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08535, 0, 1, 0.797313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297946,-99) , 
0, -0.0639868, 1, 0, 0.503462,-99) , 
3, 0.483912, 0, 0, 0.687638,-99) , 
NN(
0, 
0, 
-1, -0.736279, 0, -1, 0.216942,-99) , 
3, -0.218528, 0, 0, 0.50282,-99)    );
  // itree = 254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67548, 0, 1, 0.831615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454588,-99) , 
0, -0.866964, 1, 0, 0.526763,-99) , 
3, 1.00164, 0, 0, 0.635967,-99) , 
NN(
0, 
0, 
-1, -1.47277, 0, -1, 0.140573,-99) , 
3, -0.774089, 0, 0, 0.512112,-99)    );
  // itree = 255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.834084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295313,-99) , 
0, 0.16021, 1, 0, 0.501961,-99) , 
3, 0.608276, 0, 0, 0.726553,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278538,-99) , 
1, 0.32813, 1, 0, 0.43069,-99) , 
NN(
0, 
0, 
-1, -1.52468, 0, -1, 0.179606,-99) , 
3, -0.602961, 0, 0, 0.28568,-99) , 
3, 0.202272, 0, 0, 0.49321,-99)    );
  // itree = 256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.848117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375024,-99) , 
0, 0.342611, 1, 0, 0.568767,-99) , 
3, 0.783514, 0, 0, 0.736825,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281162,-99) , 
0, -0.79504, 1, 0, 0.412826,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.136152,-99) , 
3, -0.662162, 0, 0, 0.264134,-99) , 
3, 0.163853, 0, 0, 0.514517,-99)    );
  // itree = 257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48095, 0, 1, 0.862542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235315,-99) , 
0, 0.410894, 1, 0, 0.528473,-99) , 
3, 0.759331, 0, 0, 0.701015,-99) , 
NN(
0, 
0, 
-1, -0.617192, 0, -1, 0.198336,-99) , 
3, -0.128257, 0, 0, 0.49853,-99)    );
  // itree = 258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22883, 0, 1, 0.834196,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309712,-99) , 
3, -0.0092744, 0, 0, 0.41902,-99) , 
NN(
0, 
0, 
-1, -1.7667, 0, -1, 0.0894617,-99) , 
3, -1.12187, 0, 0, 0.329603,-99) , 
3, 0.673895, 0, 0, 0.49275,-99)    );
  // itree = 259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.913267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468582,-99) , 
0, 0.474932, 1, 0, 0.629189,-99) , 
3, 1.24194, 0, 0, 0.720905,-99) , 
NN(
0, 
0, 
-1, -0.640241, 0, -1, 0.228069,-99) , 
3, -0.133228, 0, 0, 0.511944,-99)    );
  // itree = 260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33272, 1, 1, 0.827194,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271471,-99) , 
0, 0.877723, 1, 0, 0.546057,-99) , 
3, 0.983297, 0, 0, 0.647875,-99) , 
NN(
0, 
0, 
-1, -1.48781, 0, -1, 0.110394,-99) , 
3, -0.783748, 0, 0, 0.50443,-99)    );
  // itree = 261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.865851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425253,-99) , 
0, 0.865651, 1, 0, 0.649941,-99) , 
3, 1.11419, 0, 0, 0.754971,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270116,-99) , 
0, -0.950363, 1, 0, 0.370344,-99) , 
NN(
0, 
0, 
-1, -0.213943, 1, -1, 0.0632096,-99) , 
3, -1.12817, 0, 0, 0.290991,-99) , 
3, 0.27076, 0, 0, 0.489425,-99)    );
  // itree = 262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09423, 0, 1, 0.841641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254467,-99) , 
0, 0.16021, 1, 0, 0.566472,-99) , 
3, 0.716715, 0, 0, 0.709674,-99) , 
NN(
0, 
0, 
-1, -0.734051, 0, -1, 0.212798,-99) , 
3, -0.218528, 0, 0, 0.501175,-99)    );
  // itree = 263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58176, 0, 1, 0.830005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868728,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447504,-99) , 
0, 0.256748, 1, 0, 0.608144,-99) , 
3, 0.878876, 0, 0, 0.744563,-99) , 
NN(
0, 
0, 
-1, -0.825152, 0, -1, 0.271039,-99) , 
3, 0.268003, 0, 0, 0.478429,-99)    );
  // itree = 264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08069, 1, 1, 0.819187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281109,-99) , 
0, 0.000818502, 1, 0, 0.512988,-99) , 
3, 0.628149, 0, 0, 0.669105,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156525,-99) , 
0, -1.53543, 1, 0, 0.296425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0447149,-99) , 
3, -1.57306, 0, 0, 0.239141,-99) , 
3, -0.291428, 0, 0, 0.516703,-99)    );
  // itree = 265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8507, 1, 1, 0.856366,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.909697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485094,-99) , 
0, 0.951449, 1, 0, 0.6799,-99) , 
3, 1.15054, 0, 0, 0.795233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190958,-99) , 
0, 0.434019, 1, 0, 0.498258,-99) , 
NN(
0, 
0, 
-1, -1.55197, 0, -1, 0.232832,-99) , 
3, -0.284775, 0, 0, 0.349786,-99) , 
3, 0.602686, 0, 0, 0.504448,-99)    );
  // itree = 266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19418, 1, 1, 0.826219,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372789,-99) , 
0, 0.0878292, 1, 0, 0.579733,-99) , 
3, 0.616639, 0, 0, 0.723132,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.170142,-99) , 
3, -0.302053, 0, 0, 0.489169,-99)    );
  // itree = 267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.877091,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317813,-99) , 
0, 1.09595, 1, 0, 0.641719,-99) , 
3, 1.16242, 0, 0, 0.736274,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318592,-99) , 
0, -0.843998, 1, 0, 0.419145,-99) , 
NN(
0, 
0, 
-1, -0.584023, 1, -1, 0.151258,-99) , 
3, -0.696161, 0, 0, 0.267161,-99) , 
3, 0.131392, 0, 0, 0.498653,-99)    );
  // itree = 268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.852056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217435,-99) , 
0, 0.822381, 1, 0, 0.53671,-99) , 
3, 0.926722, 0, 0, 0.678681,-99) , 
NN(
0, 
0, 
-1, -0.706455, 0, -1, 0.217745,-99) , 
3, -0.206128, 0, 0, 0.480912,-99)    );
  // itree = 269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.810243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388873,-99) , 
0, 0.0112647, 1, 0, 0.561004,-99) , 
3, 0.727702, 0, 0, 0.688086,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184137,-99) , 
0, -1.16973, 1, 0, 0.324359,-99) , 
NN(
0, 
0, 
-1, -1.65618, 0, -1, 0.11693,-99) , 
3, -0.990191, 0, 0, 0.229938,-99) , 
3, -0.218528, 0, 0, 0.507776,-99)    );
  // itree = 270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.865389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358078,-99) , 
0, 1.03728, 1, 0, 0.639141,-99) , 
3, 1.17174, 0, 0, 0.746151,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2278,-99) , 
1, 0.265077, 1, 0, 0.404547,-99) , 
NN(
0, 
0, 
-1, -2.63994, 1, -1, 0.120178,-99) , 
3, -1.02631, 0, 0, 0.304481,-99) , 
3, 0.34753, 0, 0, 0.489335,-99)    );
  // itree = 271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42286, 1, 1, 0.884639,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418343,-99) , 
0, 1.32989, 1, 0, 0.691238,-99) , 
3, 1.41017, 0, 0, 0.779302,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208666,-99) , 
0, 0.46957, 1, 0, 0.479821,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.183513,-99) , 
3, -0.528692, 0, 0, 0.349568,-99) , 
3, 0.673895, 0, 0, 0.490183,-99)    );
  // itree = 272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0622427, 0, 1, 0.942686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492066,-99) , 
3, 1.24073, 0, 0, 0.771346,-99) , 
0, 1.11079, 1, 0, 0.830585,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265474,-99) , 
0, -0.0153026, 1, 0, 0.503026,-99) , 
NN(
0, 
0, 
-1, -1.52561, 0, -1, 0.155533,-99) , 
3, -0.542018, 0, 0, 0.344941,-99) , 
3, 0.661338, 0, 0, 0.502605,-99)    );
  // itree = 273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66487, 0, 1, 0.840441,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449892,-99) , 
0, -0.329724, 1, 0, 0.560521,-99) , 
3, 0.747201, 0, 0, 0.709871,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.203704,-99) , 
3, -0.145446, 0, 0, 0.494878,-99)    );
  // itree = 274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84645, 1, 1, 0.880967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345462,-99) , 
0, 0.894039, 1, 0, 0.609549,-99) , 
3, 1.17174, 0, 0, 0.737094,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223024,-99) , 
0, -0.118626, 1, 0, 0.455184,-99) , 
NN(
0, 
0, 
-1, -0.0295246, 1, -1, 0.195921,-99) , 
3, -0.477004, 0, 0, 0.310105,-99) , 
3, 0.34753, 0, 0, 0.496613,-99)    );
  // itree = 275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.866884,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327731,-99) , 
0, 0.488, 1, 0, 0.554092,-99) , 
3, 0.971729, 0, 0, 0.680896,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143945,-99) , 
0, -0.897305, 1, 0, 0.318735,-99) , 
NN(
0, 
0, 
-1, -1.65618, 0, -1, 0.0913141,-99) , 
3, -0.987827, 0, 0, 0.210698,-99) , 
3, -0.218528, 0, 0, 0.493173,-99)    );
  // itree = 276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.905424,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387024,-99) , 
0, 0.734806, 1, 0, 0.629574,-99) , 
3, 1.11291, 0, 0, 0.766311,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18294,-99) , 
0, -0.382961, 1, 0, 0.42335,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.146777,-99) , 
3, -0.569108, 0, 0, 0.277781,-99) , 
3, 0.27076, 0, 0, 0.500613,-99)    );
  // itree = 277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57086, 1, 1, 0.820931,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318665,-99) , 
0, 0.453613, 1, 0, 0.559743,-99) , 
3, 0.742979, 0, 0, 0.70107,-99) , 
NN(
0, 
0, 
-1, -1.1379, 0, -1, 0.201229,-99) , 
3, -0.156071, 0, 0, 0.482706,-99)    );
  // itree = 278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.773759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172359,-99) , 
0, 0.259657, 1, 0, 0.436063,-99) , 
NN(
0, 
0, 
-1, -0.965248, 0, -1, 0.150511,-99) , 
3, -0.486358, 0, 0, 0.306378,-99) , 
3, 0.677307, 0, 0, 0.462515,-99)    );
  // itree = 279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.849324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283766,-99) , 
0, 0.08705, 1, 0, 0.498043,-99) , 
3, 0.608728, 0, 0, 0.676147,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.213345,-99) , 
3, -0.257025, 0, 0, 0.502238,-99)    );
  // itree = 280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.869297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265738,-99) , 
0, 0.87884, 1, 0, 0.567436,-99) , 
3, 1.18232, 0, 0, 0.67609,-99) , 
NN(
0, 
0, 
-1, -1.2441, 0, -1, 0.216666,-99) , 
3, -0.218528, 0, 0, 0.48854,-99)    );
  // itree = 281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91777, 1, 1, 0.885235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379298,-99) , 
0, 1.13942, 1, 0, 0.703673,-99) , 
3, 1.12807, 0, 0, 0.796257,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219654,-99) , 
0, -0.0726113, 1, 0, 0.444909,-99) , 
NN(
0, 
0, 
-1, -1.84158, 0, -1, 0.171155,-99) , 
3, -0.751014, 0, 0, 0.334953,-99) , 
3, 0.322617, 0, 0, 0.533403,-99)    );
  // itree = 282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.787701,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669687,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235446,-99) , 
0, 0.227133, 1, 0, 0.500299,-99) , 
3, 0.703037, 0, 0, 0.639472,-99) , 
NN(
0, 
0, 
-1, -1.23125, 0, -1, 0.155669,-99) , 
3, -0.547237, 0, 0, 0.48424,-99)    );
  // itree = 283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27071, 1, 1, 0.867311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370133,-99) , 
0, 0.498384, 1, 0, 0.601774,-99) , 
3, 1.05859, 0, 0, 0.712483,-99) , 
NN(
0, 
0, 
-1, -1.31821, 0, -1, 0.253172,-99) , 
3, -0.0725463, 0, 0, 0.517394,-99)    );
  // itree = 284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.673815, 0, 1, 0.762064,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326701,-99) , 
0, -0.843998, 1, 0, 0.4469,-99) , 
NN(
0, 
0, 
-1, -1.50772, 0, -1, 0.181971,-99) , 
3, -0.55608, 0, 0, 0.304492,-99) , 
3, 0.256412, 0, 0, 0.514291,-99)    );
  // itree = 285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06106, 1, 1, 0.919726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491508,-99) , 
3, 1.56509, 0, 0, 0.735908,-99) , 
0, 1.42363, 1, 0, 0.821279,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333636,-99) , 
1, -0.130592, 1, 0, 0.475243,-99) , 
NN(
0, 
0, 
-1, -1.08793, 0, -1, 0.168434,-99) , 
3, -0.580104, 0, 0, 0.334975,-99) , 
3, 0.609067, 0, 0, 0.514054,-99)    );
  // itree = 286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37995, 0, 1, 0.795446,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231378,-99) , 
0, 0.124475, 1, 0, 0.48582,-99) , 
3, 0.630536, 0, 0, 0.657535,-99) , 
NN(
0, 
0, 
-1, -1.07034, 0, -1, 0.161711,-99) , 
3, -0.291428, 0, 0, 0.494941,-99)    );
  // itree = 287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58382, 0, 1, 0.742354,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263676,-99) , 
1, 0.265077, 1, 0, 0.430599,-99) , 
NN(
0, 
0, 
-1, -1.41991, 0, -1, 0.157695,-99) , 
3, -0.751702, 0, 0, 0.30643,-99) , 
3, 0.34753, 0, 0, 0.498454,-99)    );
  // itree = 288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65997, 0, 1, 0.829749,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252154,-99) , 
0, 0.431079, 1, 0, 0.51489,-99) , 
3, 0.950076, 0, 0, 0.63602,-99) , 
NN(
0, 
0, 
-1, -0.778771, 1, -1, 0.174414,-99) , 
3, -0.547237, 0, 0, 0.503997,-99)    );
  // itree = 289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.878851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337793,-99) , 
0, 1.03728, 1, 0, 0.647881,-99) , 
3, 1.14829, 0, 0, 0.761037,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250943,-99) , 
0, -1.30268, 1, 0, 0.345838,-99) , 
NN(
0, 
0, 
-1, -1.58286, 0, -1, 0.0789141,-99) , 
3, -1.2493, 0, 0, 0.276411,-99) , 
3, 0.349483, 0, 0, 0.480031,-99)    );
  // itree = 290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17464, 1, 1, 0.886524,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381086,-99) , 
0, 0.498384, 1, 0, 0.603172,-99) , 
3, 1.06166, 0, 0, 0.725405,-99) , 
NN(
0, 
0, 
-1, -0.579655, 0, -1, 0.237824,-99) , 
3, -0.0725463, 0, 0, 0.510997,-99)    );
  // itree = 291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66854, 1, 1, 0.85466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33079,-99) , 
0, 0.134912, 1, 0, 0.560583,-99) , 
3, 0.845948, 0, 0, 0.704588,-99) , 
NN(
0, 
0, 
-1, -1.07034, 0, -1, 0.219582,-99) , 
3, -0.302053, 0, 0, 0.529102,-99)    );
  // itree = 292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.23613, 0, 1, 0.930586,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493809,-99) , 
0, 1.52227, 1, 0, 0.742394,-99) , 
3, 1.70191, 0, 0, 0.803179,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.179407,-99) , 
0, 0.265915, 1, 0, 0.44429,-99) , 
NN(
0, 
0, 
-1, -0.238523, 1, -1, 0.141536,-99) , 
3, -0.575176, 0, 0, 0.300939,-99) , 
3, 0.609067, 0, 0, 0.471279,-99)    );
  // itree = 293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.25111, 1, 1, 0.822219,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160007,-99) , 
0, 0.35788, 1, 0, 0.491676,-99) , 
NN(
0, 
0, 
-1, 0.0176327, 1, -1, 0.188864,-99) , 
3, -0.528692, 0, 0, 0.354188,-99) , 
3, 0.673895, 0, 0, 0.504825,-99)    );
  // itree = 294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10764, 0, 1, 0.939167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482257,-99) , 
3, 1.31755, 0, 0, 0.763802,-99) , 
0, 1.20125, 1, 0, 0.822391,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401522,-99) , 
1, -1.04839, 1, 0, 0.470215,-99) , 
NN(
0, 
0, 
-1, -1.97846, 1, -1, 0.178425,-99) , 
3, -0.750273, 0, 0, 0.358176,-99) , 
3, 0.712472, 0, 0, 0.507667,-99)    );
  // itree = 295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.34583, 1, 1, 0.891111,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289919,-99) , 
0, 0.877527, 1, 0, 0.593299,-99) , 
3, 1.11005, 0, 0, 0.746206,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305715,-99) , 
0, -0.795814, 1, 0, 0.4265,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.151417,-99) , 
3, -0.580365, 0, 0, 0.27978,-99) , 
3, 0.27076, 0, 0, 0.486261,-99)    );
  // itree = 296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.830433,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324641,-99) , 
0, -0.0319407, 1, 0, 0.504429,-99) , 
NN(
0, 
0, 
-1, -1.92343, 1, -1, 0.225439,-99) , 
3, -0.392374, 0, 0, 0.374118,-99) , 
3, 0.761018, 0, 0, 0.527075,-99)    );
  // itree = 297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.893757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291388,-99) , 
0, 0.63113, 1, 0, 0.534458,-99) , 
3, 1.11881, 0, 0, 0.665006,-99) , 
NN(
0, 
0, 
-1, -1.17795, 0, -1, 0.233707,-99) , 
3, -0.2057, 0, 0, 0.486396,-99)    );
  // itree = 298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59399, 0, 1, 0.823232,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247467,-99) , 
0, 0.158188, 1, 0, 0.476873,-99) , 
NN(
0, 
0, 
-1, -1.74465, 0, -1, 0.147316,-99) , 
3, -0.528692, 0, 0, 0.337758,-99) , 
3, 0.673895, 0, 0, 0.497144,-99)    );
  // itree = 299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.974024, 0, 1, 0.929422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449144,-99) , 
3, 1.37391, 0, 0, 0.715465,-99) , 
0, 1.34735, 1, 0, 0.805296,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283787,-99) , 
0, -0.742158, 1, 0, 0.396601,-99) , 
NN(
0, 
0, 
-1, -1.06267, 0, -1, 0.117859,-99) , 
3, -0.576554, 0, 0, 0.269245,-99) , 
3, 0.609067, 0, 0, 0.443455,-99)    );
  // itree = 300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08354, 0, 1, 0.768732,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215973,-99) , 
0, -0.319023, 1, 0, 0.427391,-99) , 
NN(
0, 
0, 
-1, -1.02913, 0, -1, 0.145314,-99) , 
3, -0.549382, 0, 0, 0.273872,-99) , 
3, 0.268003, 0, 0, 0.493544,-99)    );
  // itree = 301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.8251,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256313,-99) , 
0, 0.0477724, 1, 0, 0.501518,-99) , 
3, 0.630536, 0, 0, 0.68712,-99) , 
NN(
0, 
0, 
-1, -0.569189, 1, -1, 0.199443,-99) , 
3, -0.291428, 0, 0, 0.507375,-99)    );
  // itree = 302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08166, 1, 1, 0.857424,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257719,-99) , 
0, 0.453613, 1, 0, 0.542418,-99) , 
3, 0.810508, 0, 0, 0.689951,-99) , 
NN(
0, 
0, 
-1, 0.141595, 1, -1, 0.210908,-99) , 
3, -0.28484, 0, 0, 0.513825,-99)    );
  // itree = 303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.23773, 0, 1, 0.783156,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159406,-99) , 
0, -0.111037, 1, 0, 0.425077,-99) , 
NN(
0, 
0, 
-1, -1.75896, 0, -1, 0.141481,-99) , 
3, -0.653984, 0, 0, 0.291235,-99) , 
3, 0.427177, 0, 0, 0.488802,-99)    );
  // itree = 304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47341, 0, 1, 0.855657,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471172,-99) , 
0, -0.173276, 1, 0, 0.567652,-99) , 
3, 1.14521, 0, 0, 0.650193,-99) , 
NN(
0, 
0, 
-1, -1.20974, 0, -1, 0.161217,-99) , 
3, -0.544283, 0, 0, 0.511055,-99)    );
  // itree = 305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66854, 1, 1, 0.866956,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398689,-99) , 
0, 0.589417, 1, 0, 0.614053,-99) , 
3, 0.938224, 0, 0, 0.763535,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198566,-99) , 
0, -0.233559, 1, 0, 0.420336,-99) , 
NN(
0, 
0, 
-1, -1.59827, 0, -1, 0.161482,-99) , 
3, -0.458184, 0, 0, 0.276153,-99) , 
3, 0.337892, 0, 0, 0.488637,-99)    );
  // itree = 306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.58342, 1, 1, 0.860383,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405946,-99) , 
0, 0.222455, 1, 0, 0.603445,-99) , 
3, 0.878876, 0, 0, 0.762244,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333336,-99) , 
0, -0.752686, 1, 0, 0.484537,-99) , 
NN(
0, 
0, 
-1, -1.67157, 1, -1, 0.179224,-99) , 
3, -0.55608, 0, 0, 0.309619,-99) , 
3, 0.268003, 0, 0, 0.520252,-99)    );
  // itree = 307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.553635, 0, 1, 0.810206,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621723,-99) , 
NN(
0, 
0, 
-1, -0.987779, 0, -1, 0.234637,-99) , 
3, 0.0725039, 0, 0, 0.297988,-99) , 
3, 0.34753, 0, 0, 0.518098,-99)    );
  // itree = 308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68706, 0, 1, 0.880654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476835,-99) , 
1, -1.12744, 1, 0, 0.540328,-99) , 
3, 1.18593, 0, 0, 0.65424,-99) , 
NN(
0, 
0, 
-1, -1.75664, 0, -1, 0.229834,-99) , 
3, -0.218528, 0, 0, 0.496029,-99)    );
  // itree = 309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59914, 0, 1, 0.791641,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250173,-99) , 
0, 0.271542, 1, 0, 0.495852,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.251195,-99) , 
3, -0.230339, 0, 0, 0.362206,-99) , 
3, 0.673895, 0, 0, 0.498268,-99)    );
  // itree = 310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.62546, 0, 1, 0.739529,-99) , 
NN(
0, 
0, 
-1, -1.74867, 0, -1, 0.338188,-99) , 
3, 0.179643, 0, 0, 0.533897,-99)    );
  // itree = 311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.844247,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.920256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48513,-99) , 
1, -0.912258, 1, 0, 0.557066,-99) , 
3, 0.952846, 0, 0, 0.677631,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.232268,-99) , 
3, -0.218528, 0, 0, 0.519677,-99)    );
  // itree = 312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.898636,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399792,-99) , 
0, 0.865651, 1, 0, 0.683056,-99) , 
3, 1.11005, 0, 0, 0.790202,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247536,-99) , 
0, -0.449573, 1, 0, 0.424253,-99) , 
NN(
0, 
0, 
-1, -1.93962, 1, -1, 0.138607,-99) , 
3, -0.569108, 0, 0, 0.267314,-99) , 
3, 0.27076, 0, 0, 0.509001,-99)    );
  // itree = 313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.889168,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454601,-99) , 
0, 0.951919, 1, 0, 0.629336,-99) , 
3, 1.1562, 0, 0, 0.780376,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.14644,-99) , 
0, 0.423428, 1, 0, 0.473741,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.155729,-99) , 
3, -0.575176, 0, 0, 0.349993,-99) , 
3, 0.609067, 0, 0, 0.491162,-99)    );
  // itree = 314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41514, 0, 1, 0.846455,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350256,-99) , 
0, -0.108913, 1, 0, 0.550698,-99) , 
3, 0.637508, 0, 0, 0.734652,-99) , 
NN(
0, 
0, 
-1, -0.547392, 0, -1, 0.248971,-99) , 
3, -0.0447319, 0, 0, 0.522508,-99)    );
  // itree = 315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91777, 1, 1, 0.866909,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319378,-99) , 
0, 0.913386, 1, 0, 0.561468,-99) , 
3, 1.09078, 0, 0, 0.684363,-99) , 
NN(
0, 
0, 
-1, -0.54797, 0, -1, 0.198478,-99) , 
3, -0.0426953, 0, 0, 0.468288,-99)    );
  // itree = 316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07419, 1, 1, 0.822035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193321,-99) , 
0, 0.475416, 1, 0, 0.49321,-99) , 
3, 0.742274, 0, 0, 0.664696,-99) , 
NN(
0, 
0, 
-1, -0.654848, 0, -1, 0.18544,-99) , 
3, -0.156071, 0, 0, 0.472386,-99)    );
  // itree = 317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.841731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354404,-99) , 
0, -0.368156, 1, 0, 0.506039,-99) , 
3, 0.638541, 0, 0, 0.686448,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.163835,-99) , 
0, -1.3016, 1, 0, 0.312925,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.0770134,-99) , 
3, -1.24451, 0, 0, 0.23062,-99) , 
3, -0.260982, 0, 0, 0.508329,-99)    );
  // itree = 318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.835995,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253081,-99) , 
0, 0.14121, 1, 0, 0.45396,-99) , 
NN(
0, 
0, 
-1, -1.58072, 0, -1, 0.175261,-99) , 
3, -0.661336, 0, 0, 0.34207,-99) , 
3, 0.828289, 0, 0, 0.479927,-99)    );
  // itree = 319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.844782,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252537,-99) , 
0, 0.643366, 1, 0, 0.571998,-99) , 
3, 0.857975, 0, 0, 0.69938,-99) , 
NN(
0, 
0, 
-1, -1.30467, 0, -1, 0.17664,-99) , 
3, -0.291428, 0, 0, 0.505305,-99)    );
  // itree = 320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.699401, 1, 1, 0.853116,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27639,-99) , 
0, 0.0146766, 1, 0, 0.461179,-99) , 
NN(
0, 
0, 
-1, -0.959629, 0, -1, 0.170017,-99) , 
3, -0.485703, 0, 0, 0.324032,-99) , 
3, 0.677307, 0, 0, 0.492684,-99)    );
  // itree = 321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46277, 0, 1, 0.887363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320238,-99) , 
0, 0.936812, 1, 0, 0.608157,-99) , 
3, 1.12623, 0, 0, 0.741074,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189107,-99) , 
0, -0.150485, 1, 0, 0.452636,-99) , 
NN(
0, 
0, 
-1, -0.647816, 1, -1, 0.154678,-99) , 
3, -0.751433, 0, 0, 0.307508,-99) , 
3, 0.322617, 0, 0, 0.506005,-99)    );
  // itree = 322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.81086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251857,-99) , 
0, 0.165446, 1, 0, 0.50398,-99) , 
3, 0.57108, 0, 0, 0.664756,-99) , 
NN(
0, 
0, 
-1, -1.60155, 0, -1, 0.192118,-99) , 
3, -0.346282, 0, 0, 0.496496,-99)    );
  // itree = 323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.857362,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383417,-99) , 
0, 0.0385392, 1, 0, 0.579063,-99) , 
3, 0.927574, 0, 0, 0.695823,-99) , 
NN(
0, 
0, 
-1, -1.70546, 0, -1, 0.222877,-99) , 
3, -0.216753, 0, 0, 0.498751,-99)    );
  // itree = 324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.877462,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.973745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479877,-99) , 
0, 0.027439, 1, 0, 0.628791,-99) , 
3, 1.08605, 0, 0, 0.730057,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.252777,-99) , 
3, -0.0447319, 0, 0, 0.512909,-99)    );
  // itree = 325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.850697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371697,-99) , 
0, -0.0721965, 1, 0, 0.523481,-99) , 
3, 0.916376, 0, 0, 0.652524,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.17688,-99) , 
3, -0.613987, 0, 0, 0.515633,-99)    );
  // itree = 326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.894314,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457063,-99) , 
0, 0.205991, 1, 0, 0.581031,-99) , 
3, 1.2506, 0, 0, 0.676875,-99) , 
NN(
0, 
0, 
-1, -1.60075, 0, -1, 0.173605,-99) , 
3, -0.346282, 0, 0, 0.496594,-99)    );
  // itree = 327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.892023,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341259,-99) , 
0, 1.03728, 1, 0, 0.593333,-99) , 
3, 1.22763, 0, 0, 0.705348,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295977,-99) , 
0, -0.77806, 1, 0, 0.389104,-99) , 
NN(
0, 
0, 
-1, -1.61204, 0, -1, 0.113531,-99) , 
3, -0.643253, 0, 0, 0.242727,-99) , 
3, 0.191234, 0, 0, 0.468765,-99)    );
  // itree = 328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.849823,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353454,-99) , 
0, 0.537312, 1, 0, 0.576513,-99) , 
3, 0.903417, 0, 0, 0.737794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271304,-99) , 
0, -0.243326, 1, 0, 0.44652,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.140728,-99) , 
3, -0.58167, 0, 0, 0.280562,-99) , 
3, 0.27076, 0, 0, 0.492506,-99)    );
  // itree = 329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32898, 1, 1, 0.845212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279518,-99) , 
0, 0.231365, 1, 0, 0.508596,-99) , 
3, 0.599493, 0, 0, 0.688987,-99) , 
NN(
0, 
0, 
-1, -1.58146, 0, -1, 0.204249,-99) , 
3, -0.316527, 0, 0, 0.524793,-99)    );
  // itree = 330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72955, 0, 1, 0.779082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401117,-99) , 
1, 0.00559345, 1, 0, 0.484647,-99) , 
3, 0.606045, 0, 0, 0.683641,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263881,-99) , 
0, -0.957925, 1, 0, 0.356636,-99) , 
NN(
0, 
0, 
-1, -2.58548, 1, -1, 0.0727608,-99) , 
3, -1.19247, 0, 0, 0.266711,-99) , 
3, 0.191234, 0, 0, 0.470231,-99)    );
  // itree = 331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.817317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366632,-99) , 
0, 0.454879, 1, 0, 0.608595,-99) , 
3, 0.949517, 0, 0, 0.701219,-99) , 
NN(
0, 
0, 
-1, -0.735788, 0, -1, 0.212972,-99) , 
3, -0.218528, 0, 0, 0.508074,-99)    );
  // itree = 332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.836571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317155,-99) , 
0, 0.500185, 1, 0, 0.569518,-99) , 
3, 0.949517, 0, 0, 0.68271,-99) , 
NN(
0, 
0, 
-1, -0.990191, 0, -1, 0.208231,-99) , 
3, -0.218528, 0, 0, 0.493923,-99)    );
  // itree = 333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11599, 0, 1, 0.830595,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376111,-99) , 
0, -0.82711, 1, 0, 0.449254,-99) , 
NN(
0, 
0, 
-1, -1.12564, 0, -1, 0.141829,-99) , 
3, -0.680713, 0, 0, 0.330324,-99) , 
3, 0.761018, 0, 0, 0.482082,-99)    );
  // itree = 334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.833434,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.963689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314755,-99) , 
0, -0.143765, 1, 0, 0.501523,-99) , 
3, 0.639192, 0, 0, 0.706005,-99) , 
NN(
0, 
0, 
-1, -1.53972, 0, -1, 0.240614,-99) , 
3, -0.0447319, 0, 0, 0.500005,-99)    );
  // itree = 335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.893189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324839,-99) , 
0, 0.877527, 1, 0, 0.62191,-99) , 
3, 1.11419, 0, 0, 0.758042,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196319,-99) , 
0, -0.150485, 1, 0, 0.44026,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.189766,-99) , 
3, -0.569108, 0, 0, 0.31287,-99) , 
3, 0.27076, 0, 0, 0.50418,-99)    );
  // itree = 336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.851264,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380946,-99) , 
0, -0.0310664, 1, 0, 0.548817,-99) , 
3, 0.886067, 0, 0, 0.669863,-99) , 
NN(
0, 
0, 
-1, -1.24937, 0, -1, 0.171918,-99) , 
3, -0.582913, 0, 0, 0.514276,-99)    );
  // itree = 337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75115, 0, 1, 0.817025,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458529,-99) , 
0, -0.323617, 1, 0, 0.573242,-99) , 
3, 0.631725, 0, 0, 0.704713,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.222126,-99) , 
3, -0.291428, 0, 0, 0.526552,-99)    );
  // itree = 338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47056, 1, 1, 0.847888,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313449,-99) , 
0, 0.277937, 1, 0, 0.547535,-99) , 
NN(
0, 
0, 
-1, -1.57782, 0, -1, 0.24601,-99) , 
3, -0.0895725, 0, 0, 0.361651,-99) , 
3, 0.778124, 0, 0, 0.503044,-99)    );
  // itree = 339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32004, 0, 1, 0.826099,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295023,-99) , 
0, -0.11235, 1, 0, 0.470886,-99) , 
NN(
0, 
0, 
-1, -1.22254, 0, -1, 0.167828,-99) , 
3, -0.760607, 0, 0, 0.367427,-99) , 
3, 0.760049, 0, 0, 0.513201,-99)    );
  // itree = 340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.49699, 1, 1, 0.775946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33194,-99) , 
0, -0.430251, 1, 0, 0.499692,-99) , 
3, 0.249401, 0, 0, 0.7071,-99) , 
NN(
0, 
0, 
-1, -0.483157, 1, -1, 0.19826,-99) , 
3, -0.206128, 0, 0, 0.50669,-99)    );
  // itree = 341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.518337, 1, 1, 0.821424,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379568,-99) , 
0, -0.55321, 1, 0, 0.497267,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.150601,-99) , 
3, -0.57899, 0, 0, 0.338454,-99) , 
3, 0.602686, 0, 0, 0.500628,-99)    );
  // itree = 342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31942, 1, 1, 0.821414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279328,-99) , 
0, 0.082034, 1, 0, 0.512845,-99) , 
3, 0.642833, 0, 0, 0.703172,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27383,-99) , 
0, -1.88052, 1, 0, 0.337808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.060567,-99) , 
3, -1.53519, 0, 0, 0.295301,-99) , 
3, -0.0447319, 0, 0, 0.518589,-99)    );
  // itree = 343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.882036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302978,-99) , 
0, 0.975226, 1, 0, 0.580877,-99) , 
3, 1.16338, 0, 0, 0.695425,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216108,-99) , 
0, -1.36121, 1, 0, 0.314963,-99) , 
NN(
0, 
0, 
-1, -1.80516, 0, -1, 0.028789,-99) , 
3, -1.20223, 0, 0, 0.200169,-99) , 
3, -0.206128, 0, 0, 0.490523,-99)    );
  // itree = 344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40617, 0, 1, 0.838227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.912165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464393,-99) , 
0, 0.00233867, 1, 0, 0.601412,-99) , 
3, 1.06094, 0, 0, 0.707896,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.247531,-99) , 
3, -0.0725463, 0, 0, 0.487144,-99)    );
  // itree = 345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.557224, 0, 1, 0.772586,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254341,-99) , 
0, -0.411792, 1, 0, 0.436273,-99) , 
NN(
0, 
0, 
-1, -1.18712, 0, -1, 0.196664,-99) , 
3, -0.480034, 0, 0, 0.317102,-99) , 
3, 0.34753, 0, 0, 0.514332,-99)    );
  // itree = 346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20286, 0, 1, 0.835582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308586,-99) , 
0, 0.44647, 1, 0, 0.584744,-99) , 
3, 0.832607, 0, 0, 0.721007,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.214578,-99) , 
3, -0.0725463, 0, 0, 0.507685,-99)    );
  // itree = 347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.865508,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304225,-99) , 
0, 0.0208352, 1, 0, 0.50261,-99) , 
NN(
0, 
0, 
-1, -1.54084, 0, -1, 0.214785,-99) , 
3, -0.650494, 0, 0, 0.394111,-99) , 
3, 0.784899, 0, 0, 0.527879,-99)    );
  // itree = 348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38522, 0, 1, 0.821386,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288946,-99) , 
0, 0.143304, 1, 0, 0.487484,-99) , 
3, 0.834507, 0, 0, 0.613498,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.113105,-99) , 
3, -0.707817, 0, 0, 0.480263,-99)    );
  // itree = 349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.819565, 0, 1, 0.781291,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292135,-99) , 
1, -0.0568059, 1, 0, 0.43347,-99) , 
NN(
0, 
0, 
-1, -1.57197, 0, -1, 0.166872,-99) , 
3, -0.688247, 0, 0, 0.305088,-99) , 
3, 0.402144, 0, 0, 0.496634,-99)    );
  // itree = 350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.859808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367121,-99) , 
0, 0.22871, 1, 0, 0.579556,-99) , 
3, 0.765689, 0, 0, 0.777985,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348373,-99) , 
0, -0.814411, 1, 0, 0.466678,-99) , 
NN(
0, 
0, 
-1, -1.6555, 0, -1, 0.181899,-99) , 
3, -0.476904, 0, 0, 0.309683,-99) , 
3, 0.34753, 0, 0, 0.518078,-99)    );
  // itree = 351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.860112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412392,-99) , 
0, 0.498384, 1, 0, 0.608676,-99) , 
3, 1.13676, 0, 0, 0.709617,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181994,-99) , 
0, -1.44195, 1, 0, 0.28079,-99) , 
NN(
0, 
0, 
-1, -1.73431, 0, -1, 0.0491293,-99) , 
3, -1.21594, 0, 0, 0.198503,-99) , 
3, -0.216753, 0, 0, 0.504423,-99)    );
  // itree = 352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17269, 0, 1, 0.793781,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201608,-99) , 
0, -0.111037, 1, 0, 0.446421,-99) , 
NN(
0, 
0, 
-1, -1.65762, 0, -1, 0.154367,-99) , 
3, -0.477004, 0, 0, 0.288539,-99) , 
3, 0.34753, 0, 0, 0.489614,-99)    );
  // itree = 353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.819458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.937206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352196,-99) , 
0, -0.0639868, 1, 0, 0.535278,-99) , 
3, 0.639192, 0, 0, 0.702593,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207123,-99) , 
0, -1.3512, 1, 0, 0.303694,-99) , 
NN(
0, 
0, 
-1, -0.236614, 0, -1, 0.0475022,-99) , 
3, -1.52857, 0, 0, 0.237897,-99) , 
3, -0.0447319, 0, 0, 0.504733,-99)    );
  // itree = 354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.828108,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275137,-99) , 
0, 0.190311, 1, 0, 0.489608,-99) , 
NN(
0, 
0, 
-1, -0.942615, 0, -1, 0.192728,-99) , 
3, -0.451773, 0, 0, 0.35417,-99) , 
3, 0.760049, 0, 0, 0.504616,-99)    );
  // itree = 355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42459, 1, 1, 0.887082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406816,-99) , 
0, 0.63376, 1, 0, 0.642904,-99) , 
3, 1.13254, 0, 0, 0.771303,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303381,-99) , 
0, -1.35317, 1, 0, 0.363672,-99) , 
NN(
0, 
0, 
-1, -0.0761344, 0, -1, 0.00819661,-99) , 
3, -1.52847, 0, 0, 0.296088,-99) , 
3, 0.336059, 0, 0, 0.501555,-99)    );
  // itree = 356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593214, 0, 1, 0.74697,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257922,-99) , 
0, -0.862404, 1, 0, 0.399805,-99) , 
NN(
0, 
0, 
-1, -0.0452663, 1, -1, 0.101259,-99) , 
3, -1.19699, 0, 0, 0.313476,-99) , 
3, 0.179643, 0, 0, 0.531297,-99)    );
  // itree = 357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.975568, 1, 1, 0.819411,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230871,-99) , 
0, 0.138796, 1, 0, 0.516266,-99) , 
3, 0.628149, 0, 0, 0.673343,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.232459,-99) , 
3, -0.291428, 0, 0, 0.500586,-99)    );
  // itree = 358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.855557,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314307,-99) , 
0, -0.0638725, 1, 0, 0.470021,-99) , 
NN(
0, 
0, 
-1, -1.47002, 0, -1, 0.139153,-99) , 
3, -0.570531, 0, 0, 0.337609,-99) , 
3, 0.900715, 0, 0, 0.479409,-99)    );
  // itree = 359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.9449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451965,-99) , 
3, 1.25114, 0, 0, 0.729789,-99) , 
0, 1.07419, 1, 0, 0.798159,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29696,-99) , 
0, -0.456006, 1, 0, 0.459861,-99) , 
NN(
0, 
0, 
-1, -1.51296, 0, -1, 0.156917,-99) , 
3, -0.829402, 0, 0, 0.357081,-99) , 
3, 0.673895, 0, 0, 0.500117,-99)    );
  // itree = 360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.956125, 0, 1, 0.893815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397503,-99) , 
3, 1.51774, 0, 0, 0.68889,-99) , 
0, 1.37978, 1, 0, 0.783769,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246326,-99) , 
3, -0.649911, 0, 0, 0.446281,-99) , 
NN(
0, 
0, 
-1, -0.12391, 0, -1, 0.178568,-99) , 
1, 0.0715079, 1, 0, 0.302417,-99) , 
3, 0.427177, 0, 0, 0.499893,-99)    );
  // itree = 361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.84435,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298707,-99) , 
0, -0.114347, 1, 0, 0.480171,-99) , 
NN(
0, 
0, 
-1, -1.54274, 0, -1, 0.149437,-99) , 
3, -0.827046, 0, 0, 0.376938,-99) , 
3, 0.673895, 0, 0, 0.528694,-99)    );
  // itree = 362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.877921,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435621,-99) , 
0, 1.09595, 1, 0, 0.677589,-99) , 
3, 1.28314, 0, 0, 0.761585,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328458,-99) , 
0, -0.752686, 1, 0, 0.442507,-99) , 
NN(
0, 
0, 
-1, -1.64422, 0, -1, 0.177121,-99) , 
3, -0.50398, 0, 0, 0.295114,-99) , 
3, 0.287809, 0, 0, 0.512801,-99)    );
  // itree = 363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3049, 0, 1, 0.832893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354045,-99) , 
0, -0.120907, 1, 0, 0.507667,-99) , 
3, 0.949517, 0, 0, 0.640683,-99) , 
NN(
0, 
0, 
-1, -0.24519, 1, -1, 0.209695,-99) , 
3, -0.218528, 0, 0, 0.471925,-99)    );
  // itree = 364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26691, 1, 1, 0.849851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291018,-99) , 
0, 0.186933, 1, 0, 0.494806,-99) , 
3, 0.886067, 0, 0, 0.629396,-99) , 
NN(
0, 
0, 
-1, -1.24937, 0, -1, 0.164598,-99) , 
3, -0.582913, 0, 0, 0.48274,-99)    );
  // itree = 365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59399, 0, 1, 0.829523,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226527,-99) , 
0, 0.158188, 1, 0, 0.493975,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.209926,-99) , 
3, -0.547498, 0, 0, 0.379475,-99) , 
3, 0.673895, 0, 0, 0.524404,-99)    );
  // itree = 366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.848631,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306063,-99) , 
0, 0.815611, 1, 0, 0.55799,-99) , 
3, 1.09053, 0, 0, 0.66551,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.17691,-99) , 
3, -0.291428, 0, 0, 0.472558,-99)    );
  // itree = 367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.840036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280864,-99) , 
0, 0.0283268, 1, 0, 0.443611,-99) , 
NN(
0, 
0, 
-1, -1.6834, 0, -1, 0.136747,-99) , 
3, -0.754651, 0, 0, 0.346435,-99) , 
3, 0.760049, 0, 0, 0.495106,-99)    );
  // itree = 368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.874092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.885013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418556,-99) , 
0, 1.17321, 1, 0, 0.654068,-99) , 
3, 1.22634, 0, 0, 0.788254,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265693,-99) , 
0, -0.0153026, 1, 0, 0.490714,-99) , 
NN(
0, 
0, 
-1, -0.778771, 1, -1, 0.180996,-99) , 
3, -0.524691, 0, 0, 0.339197,-99) , 
3, 0.673895, 0, 0, 0.496504,-99)    );
  // itree = 369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59399, 0, 1, 0.807285,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289686,-99) , 
0, 0.138796, 1, 0, 0.490361,-99) , 
NN(
0, 
0, 
-1, -1.5132, 0, -1, 0.216116,-99) , 
3, -0.230339, 0, 0, 0.322838,-99) , 
3, 0.673895, 0, 0, 0.473287,-99)    );
  // itree = 370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.799279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300422,-99) , 
0, 0.082034, 1, 0, 0.515029,-99) , 
3, 0.598954, 0, 0, 0.66546,-99) , 
NN(
0, 
0, 
-1, -0.749949, 1, -1, 0.196567,-99) , 
3, -0.316527, 0, 0, 0.503114,-99)    );
  // itree = 371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.842043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251044,-99) , 
0, 0.853328, 1, 0, 0.578145,-99) , 
3, 1.08605, 0, 0, 0.691009,-99) , 
NN(
0, 
0, 
-1, -0.546985, 0, -1, 0.234696,-99) , 
3, -0.0426953, 0, 0, 0.481899,-99)    );
  // itree = 372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.962827, 1, 1, 0.795831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328792,-99) , 
0, 0.268806, 1, 0, 0.561885,-99) , 
3, 0.586739, 0, 0, 0.714924,-99) , 
NN(
0, 
0, 
-1, -0.556365, 0, -1, 0.266306,-99) , 
3, -0.0734617, 0, 0, 0.518524,-99)    );
  // itree = 373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38522, 0, 1, 0.815816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281281,-99) , 
0, 0.291557, 1, 0, 0.540189,-99) , 
3, 0.832607, 0, 0, 0.683337,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.217997,-99) , 
3, -0.0725463, 0, 0, 0.483516,-99)    );
  // itree = 374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68193, 0, 1, 0.86919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378662,-99) , 
0, 0.499557, 1, 0, 0.60542,-99) , 
3, 0.965707, 0, 0, 0.760134,-99) , 
NN(
0, 
0, 
-1, -1.57572, 0, -1, 0.358833,-99) , 
3, 0.34753, 0, 0, 0.546024,-99)    );
  // itree = 375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.867637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281649,-99) , 
0, 0.829703, 1, 0, 0.592372,-99) , 
3, 1.12707, 0, 0, 0.714719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635754,-99) , 
NN(
0, 
0, 
-1, 0.284447, 1, -1, 0.290785,-99) , 
3, 0.0507141, 0, 0, 0.334975,-99) , 
3, 0.322617, 0, 0, 0.514486,-99)    );
  // itree = 376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38922, 0, 1, 0.847703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323315,-99) , 
0, 0.097998, 1, 0, 0.516358,-99) , 
3, 0.857984, 0, 0, 0.64446,-99) , 
NN(
0, 
0, 
-1, -1.50654, 0, -1, 0.126805,-99) , 
3, -0.613509, 0, 0, 0.487799,-99)    );
  // itree = 377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.767536, 0, 1, 0.755794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222414,-99) , 
0, -0.200686, 1, 0, 0.419044,-99) , 
NN(
0, 
0, 
-1, -1.55725, 0, -1, 0.176447,-99) , 
3, -0.431068, 0, 0, 0.280134,-99) , 
3, 0.360022, 0, 0, 0.487314,-99)    );
  // itree = 378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.853287,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414687,-99) , 
0, 0.408932, 1, 0, 0.583597,-99) , 
3, 1.08882, 0, 0, 0.70184,-99) , 
NN(
0, 
0, 
-1, -1.28766, 0, -1, 0.240026,-99) , 
3, -0.0447319, 0, 0, 0.490785,-99)    );
  // itree = 379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.866377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263041,-99) , 
0, 1.20996, 1, 0, 0.590883,-99) , 
3, 1.25088, 0, 0, 0.685523,-99) , 
NN(
0, 
0, 
-1, -0.89189, 0, -1, 0.216767,-99) , 
3, -0.133228, 0, 0, 0.477131,-99)    );
  // itree = 380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.604237, 0, 1, 0.787889,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507376,-99) , 
NN(
0, 
0, 
-1, -0.895556, 1, -1, 0.238352,-99) , 
3, -0.0669222, 0, 0, 0.282562,-99) , 
3, 0.202272, 0, 0, 0.522408,-99)    );
  // itree = 381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.790506,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35329,-99) , 
0, -0.147815, 1, 0, 0.494812,-99) , 
3, 0.894464, 0, 0, 0.625035,-99) , 
NN(
0, 
0, 
-1, -0.729923, 0, -1, 0.191743,-99) , 
3, -0.231227, 0, 0, 0.452926,-99)    );
  // itree = 382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.857524,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347752,-99) , 
0, 0.734806, 1, 0, 0.6254,-99) , 
3, 0.975522, 0, 0, 0.762516,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270472,-99) , 
0, -0.843998, 1, 0, 0.396868,-99) , 
NN(
0, 
0, 
-1, -1.20548, 0, -1, 0.143698,-99) , 
3, -0.759579, 0, 0, 0.29039,-99) , 
3, 0.34753, 0, 0, 0.502781,-99)    );
  // itree = 383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38456, 0, 1, 0.819654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353029,-99) , 
0, -0.117022, 1, 0, 0.537546,-99) , 
3, 0.609259, 0, 0, 0.71621,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219221,-99) , 
0, -1.26833, 1, 0, 0.307271,-99) , 
NN(
0, 
0, 
-1, -2.82701, 1, -1, 0.11355,-99) , 
3, -1.06971, 0, 0, 0.232954,-99) , 
3, -0.0725463, 0, 0, 0.50226,-99)    );
  // itree = 384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.11537, 1, 1, 0.872016,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442534,-99) , 
0, 0.95535, 1, 0, 0.673807,-99) , 
3, 1.19347, 0, 0, 0.797999,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290791,-99) , 
0, 0.123422, 1, 0, 0.496012,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.200398,-99) , 
3, -0.546876, 0, 0, 0.356759,-99) , 
3, 0.644232, 0, 0, 0.506095,-99)    );
  // itree = 385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38774, 1, 1, 0.799963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245324,-99) , 
0, 0.402597, 1, 0, 0.512431,-99) , 
3, 0.628149, 0, 0, 0.667189,-99) , 
NN(
0, 
0, 
-1, -1.32133, 0, -1, 0.210892,-99) , 
3, -0.291428, 0, 0, 0.508717,-99)    );
  // itree = 386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.883034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407134,-99) , 
0, 1.11407, 1, 0, 0.700287,-99) , 
3, 1.19494, 0, 0, 0.803539,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25537,-99) , 
0, -0.000706236, 1, 0, 0.494983,-99) , 
NN(
0, 
0, 
-1, -1.52978, 0, -1, 0.209007,-99) , 
3, -0.252157, 0, 0, 0.325545,-99) , 
3, 0.644232, 0, 0, 0.491582,-99)    );
  // itree = 387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15532, 0, 1, 0.680788,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.146529,-99) , 
3, -0.566268, 0, 0, 0.51025,-99)    );
  // itree = 388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14008, 1, 1, 0.845192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262168,-99) , 
0, 0.500185, 1, 0, 0.534189,-99) , 
3, 0.993113, 0, 0, 0.676718,-99) , 
NN(
0, 
0, 
-1, -0.605234, 0, -1, 0.224836,-99) , 
3, -0.117632, 0, 0, 0.48493,-99)    );
  // itree = 389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47692, 0, 1, 0.838246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385869,-99) , 
0, 0.0112647, 1, 0, 0.565197,-99) , 
3, 0.716715, 0, 0, 0.699867,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181981,-99) , 
0, -1.36121, 1, 0, 0.310826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0418292,-99) , 
3, -1.50037, 0, 0, 0.241972,-99) , 
3, -0.218528, 0, 0, 0.517989,-99)    );
  // itree = 390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73748, 0, 1, 0.816597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32211,-99) , 
0, 0.0804575, 1, 0, 0.515176,-99) , 
3, 0.857975, 0, 0, 0.646374,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.237937,-99) , 
3, -0.291428, 0, 0, 0.502784,-99)    );
  // itree = 391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.877902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399152,-99) , 
0, 0.487108, 1, 0, 0.615722,-99) , 
3, 1.082, 0, 0, 0.75194,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313489,-99) , 
0, -0.83644, 1, 0, 0.411914,-99) , 
NN(
0, 
0, 
-1, -1.14185, 0, -1, 0.142833,-99) , 
2, -0.659023, 0, 0, 0.256834,-99) , 
3, 0.268003, 0, 0, 0.503919,-99)    );
  // itree = 392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57774, 0, 1, 0.835189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304964,-99) , 
0, -0.0153026, 1, 0, 0.487885,-99) , 
3, 0.641734, 0, 0, 0.646538,-99) , 
NN(
0, 
0, 
-1, 0.433143, 1, -1, 0.154878,-99) , 
3, -0.580673, 0, 0, 0.502827,-99)    );
  // itree = 393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.88422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394361,-99) , 
0, 0.683618, 1, 0, 0.645136,-99) , 
3, 0.933581, 0, 0, 0.790171,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197382,-99) , 
0, 0.0148079, 1, 0, 0.452687,-99) , 
NN(
0, 
0, 
-1, -1.59928, 0, -1, 0.160156,-99) , 
3, -0.461593, 0, 0, 0.291094,-99) , 
3, 0.336059, 0, 0, 0.503708,-99)    );
  // itree = 394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15422, 0, 1, 0.800615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361957,-99) , 
0, 0.0804575, 1, 0, 0.533355,-99) , 
3, 0.560587, 0, 0, 0.699763,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.251906,-99) , 
3, -0.133228, 0, 0, 0.532184,-99)    );
  // itree = 395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15167, 0, 1, 0.691372,-99) , 
NN(
0, 
0, 
-1, -1.45095, 0, -1, 0.235439,-99) , 
3, -0.206128, 0, 0, 0.5155,-99)    );
  // itree = 396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72016, 1, 1, 0.86806,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427539,-99) , 
0, 0.865651, 1, 0, 0.692305,-99) , 
3, 1.17174, 0, 0, 0.777082,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256769,-99) , 
0, -0.0748989, 1, 0, 0.451863,-99) , 
NN(
0, 
0, 
-1, -1.18712, 0, -1, 0.197595,-99) , 
3, -0.480034, 0, 0, 0.317121,-99) , 
3, 0.34753, 0, 0, 0.520563,-99)    );
  // itree = 397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42719, 1, 1, 0.86431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235975,-99) , 
0, 0.500185, 1, 0, 0.536101,-99) , 
3, 0.840714, 0, 0, 0.690256,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.214782,-99) , 
3, -0.0725463, 0, 0, 0.488233,-99)    );
  // itree = 398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.853254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284776,-99) , 
0, 0.520255, 1, 0, 0.592671,-99) , 
3, 0.781774, 0, 0, 0.750679,-99) , 
NN(
0, 
0, 
-1, -0.389485, 0, -1, 0.271025,-99) , 
3, 0.163853, 0, 0, 0.503879,-99)    );
  // itree = 399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.814497, 0, 1, 0.748328,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210353,-99) , 
0, -0.0748989, 1, 0, 0.445436,-99) , 
NN(
0, 
0, 
-1, -0.57782, 1, -1, 0.160177,-99) , 
3, -0.414993, 0, 0, 0.294325,-99) , 
3, 0.402144, 0, 0, 0.475551,-99)    );
  // itree = 400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.844535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314148,-99) , 
0, 0.568049, 1, 0, 0.595217,-99) , 
3, 0.812842, 0, 0, 0.748565,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270154,-99) , 
0, -0.664808, 1, 0, 0.461469,-99) , 
NN(
0, 
0, 
-1, -1.12553, 0, -1, 0.179336,-99) , 
3, -0.367839, 0, 0, 0.281051,-99) , 
3, 0.191234, 0, 0, 0.505515,-99)    );
  // itree = 401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13594, 0, 1, 0.837607,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196977,-99) , 
0, 0.193161, 1, 0, 0.473389,-99) , 
NN(
0, 
0, 
-1, -0.687486, 1, -1, 0.184298,-99) , 
3, -0.451773, 0, 0, 0.340041,-99) , 
3, 0.760049, 0, 0, 0.485051,-99)    );
  // itree = 402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.875144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357358,-99) , 
0, 0.91729, 1, 0, 0.605593,-99) , 
3, 1.11291, 0, 0, 0.731053,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279183,-99) , 
0, -0.449573, 1, 0, 0.458124,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.138356,-99) , 
3, -0.569108, 0, 0, 0.277035,-99) , 
3, 0.27076, 0, 0, 0.476931,-99)    );
  // itree = 403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.37898, 0, 1, 0.853487,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289632,-99) , 
0, 0.254279, 1, 0, 0.536379,-99) , 
NN(
0, 
0, 
-1, -1.60328, 0, -1, 0.246696,-99) , 
3, -0.0728858, 0, 0, 0.36156,-99) , 
3, 0.828289, 0, 0, 0.513561,-99)    );
  // itree = 404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34056, 1, 1, 0.866509,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273863,-99) , 
0, 0.89651, 1, 0, 0.545867,-99) , 
3, 1.0878, 0, 0, 0.661819,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.193874,-99) , 
3, -0.291428, 0, 0, 0.494353,-99)    );
  // itree = 405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.792098,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327376,-99) , 
0, 0.202908, 1, 0, 0.518355,-99) , 
3, 0.593512, 0, 0, 0.71026,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248018,-99) , 
1, -0.532322, 1, 0, 0.313267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0283967,-99) , 
2, -1.59214, 0, 0, 0.263144,-99) , 
3, 0.179643, 0, 0, 0.490195,-99)    );
  // itree = 406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54631, 1, 1, 0.835236,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387262,-99) , 
0, 0.0584112, 1, 0, 0.550176,-99) , 
3, 0.657548, 0, 0, 0.717648,-99) , 
NN(
0, 
0, 
-1, -0.512356, 0, -1, 0.234962,-99) , 
3, -0.0172488, 0, 0, 0.500789,-99)    );
  // itree = 407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.857756,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47911,-99) , 
0, -0.0733854, 1, 0, 0.604249,-99) , 
3, 1.13676, 0, 0, 0.688159,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.113333,-99) , 
0, -0.897305, 1, 0, 0.299309,-99) , 
NN(
0, 
0, 
-1, -1.63297, 0, -1, 0.133952,-99) , 
3, -0.962237, 0, 0, 0.221533,-99) , 
3, -0.216753, 0, 0, 0.501753,-99)    );
  // itree = 408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8206, 1, 1, 0.885115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350273,-99) , 
0, 0.687285, 1, 0, 0.610276,-99) , 
3, 1.15159, 0, 0, 0.717573,-99) , 
NN(
0, 
0, 
-1, -0.662379, 0, -1, 0.219592,-99) , 
3, -0.172486, 0, 0, 0.513973,-99)    );
  // itree = 409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.731201, 0, 1, 0.762701,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284048,-99) , 
0, -0.340705, 1, 0, 0.459603,-99) , 
NN(
0, 
0, 
-1, -1.63381, 0, -1, 0.191591,-99) , 
3, -0.483771, 0, 0, 0.311034,-99) , 
3, 0.322617, 0, 0, 0.509493,-99)    );
  // itree = 410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.88346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.9028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378571,-99) , 
0, 1.17772, 1, 0, 0.672163,-99) , 
3, 1.22634, 0, 0, 0.789928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356325,-99) , 
1, -0.801294, 1, 0, 0.421076,-99) , 
NN(
0, 
0, 
-1, -1.7667, 0, -1, 0.0740263,-99) , 
3, -1.1254, 0, 0, 0.340681,-99) , 
3, 0.673895, 0, 0, 0.476684,-99)    );
  // itree = 411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73703, 0, 1, 0.878353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374784,-99) , 
0, 0.853328, 1, 0, 0.603972,-99) , 
3, 1.24194, 0, 0, 0.697483,-99) , 
NN(
0, 
0, 
-1, -0.647816, 1, -1, 0.247671,-99) , 
3, -0.133228, 0, 0, 0.510242,-99)    );
  // itree = 412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08292, 0, 1, 0.842736,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35953,-99) , 
0, -0.140048, 1, 0, 0.507498,-99) , 
3, 0.701791, 0, 0, 0.662379,-99) , 
NN(
0, 
0, 
-1, -1.69233, 0, -1, 0.152806,-99) , 
3, -0.547237, 0, 0, 0.508485,-99)    );
  // itree = 413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.822222,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365177,-99) , 
0, -0.0153026, 1, 0, 0.54884,-99) , 
3, 0.701791, 0, 0, 0.682168,-99) , 
NN(
0, 
0, 
-1, -1.24211, 0, -1, 0.196689,-99) , 
3, -0.547237, 0, 0, 0.553159,-99)    );
  // itree = 414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.845712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187264,-99) , 
0, 0.862638, 1, 0, 0.567339,-99) , 
3, 0.989228, 0, 0, 0.709856,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299316,-99) , 
0, -0.795814, 1, 0, 0.432082,-99) , 
NN(
0, 
0, 
-1, -1.14182, 0, -1, 0.141418,-99) , 
3, -0.66666, 0, 0, 0.263466,-99) , 
3, 0.163853, 0, 0, 0.468432,-99)    );
  // itree = 415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.690724, 0, 1, 0.747737,-99) , 
NN(
0, 
0, 
-1, -1.13818, 0, -1, 0.276801,-99) , 
3, 0.27076, 0, 0, 0.481594,-99)    );
  // itree = 416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00273, 1, 1, 0.843123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232938,-99) , 
0, 0.625254, 1, 0, 0.546511,-99) , 
3, 0.857975, 0, 0, 0.678736,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.204311,-99) , 
3, -0.291428, 0, 0, 0.505961,-99)    );
  // itree = 417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08069, 1, 1, 0.813947,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285479,-99) , 
1, 0.212582, 1, 0, 0.402878,-99) , 
NN(
0, 
0, 
-1, -1.7667, 0, -1, 0.0580555,-99) , 
3, -1.12187, 0, 0, 0.319931,-99) , 
3, 0.673895, 0, 0, 0.482688,-99)    );
  // itree = 418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78567, 1, 1, 0.862377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283389,-99) , 
0, 0.913386, 1, 0, 0.568416,-99) , 
3, 1.09229, 0, 0, 0.688519,-99) , 
NN(
0, 
0, 
-1, -0.539588, 0, -1, 0.244966,-99) , 
3, -0.0426953, 0, 0, 0.4863,-99)    );
  // itree = 419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31235, 0, 1, 0.796418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272554,-99) , 
0, 0.138796, 1, 0, 0.496791,-99) , 
3, 0.550354, 0, 0, 0.67349,-99) , 
NN(
0, 
0, 
-1, -1.58008, 0, -1, 0.227744,-99) , 
3, -0.117632, 0, 0, 0.482125,-99)    );
  // itree = 420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35104, 1, 1, 0.837154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269164,-99) , 
0, 0.454461, 1, 0, 0.553242,-99) , 
3, 0.857975, 0, 0, 0.67906,-99) , 
NN(
0, 
0, 
-1, -1.55738, 0, -1, 0.187534,-99) , 
3, -0.291428, 0, 0, 0.491857,-99)    );
  // itree = 421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.819842,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281376,-99) , 
0, 0.471542, 1, 0, 0.553631,-99) , 
3, 0.62211, 0, 0, 0.690963,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.199861,-99) , 
3, -0.302053, 0, 0, 0.527638,-99)    );
  // itree = 422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08166, 1, 1, 0.828903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332447,-99) , 
0, 0.44647, 1, 0, 0.576582,-99) , 
3, 0.870114, 0, 0, 0.72884,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31732,-99) , 
0, -0.862067, 1, 0, 0.44701,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.143042,-99) , 
3, -0.554775, 0, 0, 0.270128,-99) , 
3, 0.256412, 0, 0, 0.484736,-99)    );
  // itree = 423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.820328,-99) , 
NN(
0, 
0, 
-1, -1.43473, 0, -1, 0.334113,-99) , 
3, 0.661338, 0, 0, 0.487148,-99)    );
  // itree = 424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98981, 1, 1, 0.839177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257193,-99) , 
0, 0.453613, 1, 0, 0.526307,-99) , 
3, 0.746504, 0, 0, 0.692844,-99) , 
NN(
0, 
0, 
-1, -1.50393, 0, -1, 0.181798,-99) , 
3, -0.218528, 0, 0, 0.482442,-99)    );
  // itree = 425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.852465,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373505,-99) , 
0, 0.927932, 1, 0, 0.60554,-99) , 
3, 1.15167, 0, 0, 0.687159,-99) , 
NN(
0, 
0, 
-1, -1.45095, 0, -1, 0.233441,-99) , 
3, -0.206128, 0, 0, 0.514396,-99)    );
  // itree = 426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61954, 0, 1, 0.887821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38105,-99) , 
0, 0.134136, 1, 0, 0.52849,-99) , 
3, 1.1334, 0, 0, 0.630023,-99) , 
NN(
0, 
0, 
-1, -0.365486, 1, -1, 0.141329,-99) , 
3, -0.582913, 0, 0, 0.475594,-99)    );
  // itree = 427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.873783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812423,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409624,-99) , 
0, 0.360024, 1, 0, 0.607878,-99) , 
3, 1.0878, 0, 0, 0.705747,-99) , 
NN(
0, 
0, 
-1, -1.56253, 0, -1, 0.205967,-99) , 
3, -0.291428, 0, 0, 0.528101,-99)    );
  // itree = 428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62962, 0, 1, 0.848556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228327,-99) , 
0, 0.485887, 1, 0, 0.537598,-99) , 
3, 0.804344, 0, 0, 0.689971,-99) , 
NN(
0, 
0, 
-1, -1.47943, 0, -1, 0.190989,-99) , 
3, -0.28484, 0, 0, 0.508511,-99)    );
  // itree = 429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75578, 1, 1, 0.884037,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410881,-99) , 
0, 0.756047, 1, 0, 0.606356,-99) , 
3, 1.21496, 0, 0, 0.719999,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279929,-99) , 
0, -0.843998, 1, 0, 0.387683,-99) , 
NN(
0, 
0, 
-1, -1.52165, 0, -1, 0.168467,-99) , 
3, -0.59706, 0, 0, 0.275193,-99) , 
3, 0.208162, 0, 0, 0.472946,-99)    );
  // itree = 430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49252, 0, 1, 0.838897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22562,-99) , 
0, 0.453613, 1, 0, 0.509797,-99) , 
3, 0.95924, 0, 0, 0.653798,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.205798,-99) , 
3, -0.218528, 0, 0, 0.471431,-99)    );
  // itree = 431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.851713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397734,-99) , 
0, 0.0112647, 1, 0, 0.540441,-99) , 
3, 0.952846, 0, 0, 0.666122,-99) , 
NN(
0, 
0, 
-1, -0.990191, 0, -1, 0.220649,-99) , 
3, -0.218528, 0, 0, 0.494639,-99)    );
  // itree = 432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.64517, 1, 1, 0.829224,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433405,-99) , 
0, 0.232439, 1, 0, 0.579634,-99) , 
3, 0.949517, 0, 0, 0.685617,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.228477,-99) , 
3, -0.218528, 0, 0, 0.506328,-99)    );
  // itree = 433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.762399, 0, 1, 0.783224,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148465,-99) , 
0, -0.111037, 1, 0, 0.377536,-99) , 
NN(
0, 
0, 
-1, -1.57544, 0, -1, 0.134338,-99) , 
3, -0.698907, 0, 0, 0.269426,-99) , 
3, 0.361269, 0, 0, 0.475935,-99)    );
  // itree = 434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.804773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34576,-99) , 
0, 0.232439, 1, 0, 0.550507,-99) , 
3, 0.720251, 0, 0, 0.692609,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.194582,-99) , 
3, -0.218528, 0, 0, 0.486006,-99)    );
  // itree = 435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92281, 1, 1, 0.841675,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290534,-99) , 
0, 1.16858, 1, 0, 0.574726,-99) , 
3, 1.16577, 0, 0, 0.658788,-99) , 
NN(
0, 
0, 
-1, -1.16135, 0, -1, 0.159871,-99) , 
3, -0.415423, 0, 0, 0.488521,-99)    );
  // itree = 436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.865005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352928,-99) , 
0, 0.954172, 1, 0, 0.633267,-99) , 
3, 1.11291, 0, 0, 0.755002,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298051,-99) , 
0, -0.704209, 1, 0, 0.44398,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.149264,-99) , 
3, -0.574972, 0, 0, 0.282718,-99) , 
3, 0.27076, 0, 0, 0.506262,-99)    );
  // itree = 437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60658, 0, 1, 0.811925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.964162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355199,-99) , 
0, -0.107474, 1, 0, 0.52078,-99) , 
3, 0.644531, 0, 0, 0.6979,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.229741,-99) , 
3, -0.0447319, 0, 0, 0.508003,-99)    );
  // itree = 438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45552, 0, 1, 0.86465,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272428,-99) , 
0, 0.488, 1, 0, 0.554268,-99) , 
3, 0.941165, 0, 0, 0.686694,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.163722,-99) , 
0, -0.938985, 1, 0, 0.315035,-99) , 
NN(
0, 
0, 
-1, -0.211632, 1, -1, 0.0683839,-99) , 
3, -1.14757, 0, 0, 0.224303,-99) , 
3, -0.170545, 0, 0, 0.503002,-99)    );
  // itree = 439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44046, 1, 1, 0.851131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324101,-99) , 
0, 0.565059, 1, 0, 0.58437,-99) , 
3, 0.864843, 0, 0, 0.730486,-99) , 
NN(
0, 
0, 
-1, -1.82992, 0, -1, 0.256901,-99) , 
3, 0.0559666, 0, 0, 0.488876,-99)    );
  // itree = 440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09938, 1, 1, 0.887743,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.912882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437094,-99) , 
0, -0.275303, 1, 0, 0.541946,-99) , 
3, 1.13988, 0, 0, 0.666677,-99) , 
NN(
0, 
0, 
-1, -0.964601, 0, -1, 0.21615,-99) , 
3, -0.216753, 0, 0, 0.488253,-99)    );
  // itree = 441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52219, 1, 1, 0.798692,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412403,-99) , 
1, -0.156448, 1, 0, 0.557204,-99) , 
3, 0.575913, 0, 0, 0.731946,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286114,-99) , 
0, -0.845087, 1, 0, 0.431416,-99) , 
NN(
0, 
0, 
-1, -1.9253, 1, -1, 0.136949,-99) , 
3, -0.662162, 0, 0, 0.265679,-99) , 
3, 0.163853, 0, 0, 0.497681,-99)    );
  // itree = 442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67962, 1, 1, 0.858372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385951,-99) , 
0, 0.629236, 1, 0, 0.619073,-99) , 
3, 0.96671, 0, 0, 0.75885,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.163606,-99) , 
0, -0.111037, 1, 0, 0.411523,-99) , 
NN(
0, 
0, 
-1, -1.7195, 0, -1, 0.183198,-99) , 
3, -0.483971, 0, 0, 0.292437,-99) , 
3, 0.34753, 0, 0, 0.492,-99)    );
  // itree = 443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40174, 0, 1, 0.799184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28395,-99) , 
0, 0.155544, 1, 0, 0.538233,-99) , 
3, 0.494473, 0, 0, 0.688529,-99) , 
NN(
0, 
0, 
-1, -1.15987, 0, -1, 0.176996,-99) , 
3, -0.415423, 0, 0, 0.51705,-99)    );
  // itree = 444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58369, 1, 1, 0.826001,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18986,-99) , 
0, 0.65461, 1, 0, 0.511037,-99) , 
3, 0.798119, 0, 0, 0.631692,-99) , 
NN(
0, 
0, 
-1, -1.14621, 0, -1, 0.165489,-99) , 
3, -0.689919, 0, 0, 0.506156,-99)    );
  // itree = 445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.813287,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275991,-99) , 
0, 0.481313, 1, 0, 0.570604,-99) , 
3, 0.784282, 0, 0, 0.695044,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.207828,-99) , 
3, -0.133228, 0, 0, 0.502156,-99)    );
  // itree = 446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.553635, 0, 1, 0.737492,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331149,-99) , 
0, -1.04887, 1, 0, 0.422158,-99) , 
NN(
0, 
0, 
-1, -1.65207, 0, -1, 0.177874,-99) , 
3, -0.758282, 0, 0, 0.315755,-99) , 
3, 0.34753, 0, 0, 0.497214,-99)    );
  // itree = 447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.833688,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254342,-99) , 
0, 0.291557, 1, 0, 0.532821,-99) , 
3, 0.832607, 0, 0, 0.682374,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183397,-99) , 
0, -1.18749, 1, 0, 0.299124,-99) , 
NN(
0, 
0, 
-1, -0.591655, 1, -1, 0.101676,-99) , 
3, -1.06796, 0, 0, 0.222611,-99) , 
3, -0.0725463, 0, 0, 0.486342,-99)    );
  // itree = 448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27071, 1, 1, 0.86353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294273,-99) , 
0, 0.89651, 1, 0, 0.56408,-99) , 
3, 1.08991, 0, 0, 0.667613,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.199678,-99) , 
3, -0.291428, 0, 0, 0.499501,-99)    );
  // itree = 449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.867804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223406,-99) , 
0, 1.11769, 1, 0, 0.597603,-99) , 
3, 1.11296, 0, 0, 0.733096,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28368,-99) , 
0, -0.568658, 1, 0, 0.446642,-99) , 
NN(
0, 
0, 
-1, -1.63854, 0, -1, 0.186323,-99) , 
3, -0.492246, 0, 0, 0.296417,-99) , 
3, 0.311026, 0, 0, 0.491129,-99)    );
  // itree = 450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.70267, 1, 1, 0.926737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360485,-99) , 
0, 1.40292, 1, 0, 0.649713,-99) , 
3, 1.37778, 0, 0, 0.753988,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310173,-99) , 
0, -0.862067, 1, 0, 0.441789,-99) , 
NN(
0, 
0, 
-1, -1.65207, 0, -1, 0.167924,-99) , 
3, -0.760118, 0, 0, 0.326973,-99) , 
3, 0.34753, 0, 0, 0.524545,-99)    );
  // itree = 451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.881002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.898587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494086,-99) , 
0, -0.0112904, 1, 0, 0.627993,-99) , 
3, 1.05859, 0, 0, 0.73403,-99) , 
NN(
0, 
0, 
-1, -1.56687, 0, -1, 0.24996,-99) , 
3, -0.0725463, 0, 0, 0.525578,-99)    );
  // itree = 452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.8139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.964159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367829,-99) , 
0, 0.0967635, 1, 0, 0.570733,-99) , 
3, 0.706565, 0, 0, 0.720419,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247165,-99) , 
0, -0.850436, 1, 0, 0.396574,-99) , 
NN(
0, 
0, 
-1, -1.59648, 0, -1, 0.143483,-99) , 
3, -0.691742, 0, 0, 0.262754,-99) , 
3, 0.101538, 0, 0, 0.499437,-99)    );
  // itree = 453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.585377, 1, 1, 0.905861,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439253,-99) , 
3, 1.45708, 0, 0, 0.680547,-99) , 
0, 1.27903, 1, 0, 0.788035,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276558,-99) , 
0, -0.73217, 1, 0, 0.393853,-99) , 
NN(
0, 
0, 
-1, -1.50618, 0, -1, 0.150104,-99) , 
3, -0.634515, 0, 0, 0.281582,-99) , 
3, 0.440796, 0, 0, 0.460012,-99)    );
  // itree = 454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47056, 1, 1, 0.846994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324372,-99) , 
0, 0.509248, 1, 0, 0.60639,-99) , 
3, 0.864726, 0, 0, 0.726216,-99) , 
NN(
0, 
0, 
-1, -1.54018, 0, -1, 0.248504,-99) , 
3, -0.0426953, 0, 0, 0.498091,-99)    );
  // itree = 455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.842936,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.875975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344953,-99) , 
0, 0.44647, 1, 0, 0.581998,-99) , 
3, 0.854679, 0, 0, 0.740096,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301429,-99) , 
1, 0.167099, 1, 0, 0.403858,-99) , 
NN(
0, 
0, 
-1, -1.49701, 0, -1, 0.181394,-99) , 
3, -0.569465, 0, 0, 0.286667,-99) , 
3, 0.240623, 0, 0, 0.500024,-99)    );
  // itree = 456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.947543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452431,-99) , 
3, 0.965707, 0, 0, 0.711757,-99) , 
0, 0.542186, 1, 0, 0.763437,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300804,-99) , 
0, -0.200686, 1, 0, 0.479761,-99) , 
NN(
0, 
0, 
-1, -1.20632, 0, -1, 0.205044,-99) , 
3, -0.2022, 0, 0, 0.283917,-99) , 
3, 0.34753, 0, 0, 0.486402,-99)    );
  // itree = 457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63415, 1, 1, 0.870937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270683,-99) , 
0, 0.87884, 1, 0, 0.588307,-99) , 
3, 1.08605, 0, 0, 0.701129,-99) , 
NN(
0, 
0, 
-1, -0.547392, 0, -1, 0.272823,-99) , 
3, -0.0447319, 0, 0, 0.51124,-99)    );
  // itree = 458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66854, 1, 1, 0.835427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.950254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355275,-99) , 
0, 0.329981, 1, 0, 0.550233,-99) , 
3, 0.968938, 0, 0, 0.710982,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25416,-99) , 
0, -0.766228, 1, 0, 0.355522,-99) , 
NN(
0, 
0, 
-1, -0.157641, 1, -1, 0.130339,-99) , 
3, -0.751702, 0, 0, 0.244732,-99) , 
3, 0.34753, 0, 0, 0.437226,-99)    );
  // itree = 459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.949861, 0, 1, 0.830869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343578,-99) , 
0, -0.0639868, 1, 0, 0.564359,-99) , 
3, 0.555454, 0, 0, 0.726702,-99) , 
NN(
0, 
0, 
-1, -0.639048, 0, -1, 0.245483,-99) , 
3, -0.133228, 0, 0, 0.530383,-99)    );
  // itree = 460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.699401, 1, 1, 0.854257,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35243,-99) , 
0, -0.314501, 1, 0, 0.490655,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.199039,-99) , 
3, -0.23299, 0, 0, 0.321273,-99) , 
3, 0.673895, 0, 0, 0.501286,-99)    );
  // itree = 461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.818118,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31384,-99) , 
0, -0.0721965, 1, 0, 0.472695,-99) , 
NN(
0, 
0, 
-1, -1.43294, 0, -1, 0.197277,-99) , 
3, -0.451773, 0, 0, 0.355594,-99) , 
3, 0.760049, 0, 0, 0.495072,-99)    );
  // itree = 462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63867, 0, 1, 0.889411,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26184,-99) , 
0, 0.969329, 1, 0, 0.5868,-99) , 
3, 1.15167, 0, 0, 0.68231,-99) , 
NN(
0, 
0, 
-1, -0.710408, 0, -1, 0.202032,-99) , 
3, -0.206128, 0, 0, 0.496397,-99)    );
  // itree = 463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.219429, 1, 1, 0.84642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262037,-99) , 
1, -0.102661, 1, 0, 0.381032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.61895, 0, 0, 0.334705,-99) , 
3, 0.729578, 0, 0, 0.497898,-99)    );
  // itree = 464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57345, 0, 1, 0.827318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297589,-99) , 
0, -0.0153026, 1, 0, 0.504681,-99) , 
3, 0.647429, 0, 0, 0.66032,-99) , 
NN(
0, 
0, 
-1, -1.47083, 0, -1, 0.152161,-99) , 
3, -0.580673, 0, 0, 0.505751,-99)    );
  // itree = 465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.852415,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311445,-99) , 
0, 0.87199, 1, 0, 0.568355,-99) , 
3, 1.1628, 0, 0, 0.670158,-99) , 
NN(
0, 
0, 
-1, -1.6354, 0, -1, 0.223249,-99) , 
3, -0.170545, 0, 0, 0.491549,-99)    );
  // itree = 466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.918153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382556,-99) , 
0, 1.09243, 1, 0, 0.626872,-99) , 
3, 1.28513, 0, 0, 0.744405,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238413,-99) , 
0, -1.30765, 1, 0, 0.308705,-99) , 
NN(
0, 
0, 
-1, -0.206791, 1, -1, 0.0970916,-99) , 
3, -1.09669, 0, 0, 0.251992,-99) , 
3, 0.268003, 0, 0, 0.470045,-99)    );
  // itree = 467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19644, 0, 1, 0.765576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395885,-99) , 
3, 0.104177, 0, 0, 0.705896,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.238533,-99) , 
3, -0.133228, 0, 0, 0.508576,-99)    );
  // itree = 468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.808071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288389,-99) , 
0, 0.216833, 1, 0, 0.557611,-99) , 
3, 0.606621, 0, 0, 0.711995,-99) , 
NN(
0, 
0, 
-1, -0.572723, 0, -1, 0.213122,-99) , 
3, -0.0725463, 0, 0, 0.492436,-99)    );
  // itree = 469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.39035, 1, 1, 0.949756,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482528,-99) , 
0, 1.52925, 1, 0, 0.739002,-99) , 
3, 1.69538, 0, 0, 0.814722,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263788,-99) , 
0, 0.143304, 1, 0, 0.44778,-99) , 
NN(
0, 
0, 
-1, -1.68419, 0, -1, 0.172378,-99) , 
3, -0.755609, 0, 0, 0.347769,-99) , 
3, 0.760049, 0, 0, 0.490052,-99)    );
  // itree = 470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.56358, 0, 1, 0.846427,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220626,-99) , 
0, 0.418264, 1, 0, 0.473313,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.181191,-99) , 
3, -0.384478, 0, 0, 0.348897,-99) , 
3, 0.828289, 0, 0, 0.482879,-99)    );
  // itree = 471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.84863,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394482,-99) , 
0, 0.457728, 1, 0, 0.620573,-99) , 
3, 0.980247, 0, 0, 0.718531,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.115721,-99) , 
0, -0.86692, 1, 0, 0.301344,-99) , 
NN(
0, 
0, 
-1, -1.7112, 0, -1, 0.110518,-99) , 
3, -1.10528, 0, 0, 0.230809,-99) , 
3, -0.128257, 0, 0, 0.512013,-99)    );
  // itree = 472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46084, 0, 1, 0.866272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298654,-99) , 
0, 0.932184, 1, 0, 0.579423,-99) , 
3, 1.13676, 0, 0, 0.683824,-99) , 
NN(
0, 
0, 
-1, -0.716991, 0, -1, 0.230732,-99) , 
3, -0.216753, 0, 0, 0.506376,-99)    );
  // itree = 473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61457, 0, 1, 0.843867,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444853,-99) , 
0, -0.243889, 1, 0, 0.551105,-99) , 
3, 0.926722, 0, 0, 0.689149,-99) , 
NN(
0, 
0, 
-1, -0.710408, 0, -1, 0.225545,-99) , 
3, -0.206128, 0, 0, 0.505711,-99)    );
  // itree = 474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.38599, 1, 1, 0.894475,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352306,-99) , 
0, 0.865651, 1, 0, 0.630975,-99) , 
3, 1.17174, 0, 0, 0.759192,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204889,-99) , 
0, -0.150485, 1, 0, 0.437928,-99) , 
NN(
0, 
0, 
-1, -1.87118, 0, -1, 0.135151,-99) , 
3, -0.751608, 0, 0, 0.300702,-99) , 
3, 0.34753, 0, 0, 0.489568,-99)    );
  // itree = 475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.82047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405738,-99) , 
0, -0.879309, 1, 0, 0.473909,-99) , 
NN(
0, 
0, 
-1, -1.73886, 0, -1, 0.142556,-99) , 
3, -0.754651, 0, 0, 0.363087,-99) , 
3, 0.760049, 0, 0, 0.508873,-99)    );
  // itree = 476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.813708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203116,-99) , 
0, 0.481313, 1, 0, 0.56948,-99) , 
3, 0.64934, 0, 0, 0.717841,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166444,-99) , 
0, -0.843998, 1, 0, 0.375335,-99) , 
NN(
0, 
0, 
-1, -1.48781, 0, -1, 0.122495,-99) , 
3, -0.78541, 0, 0, 0.232032,-99) , 
3, 0.0228588, 0, 0, 0.492991,-99)    );
  // itree = 477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.876026,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170695,-99) , 
0, 0.913386, 1, 0, 0.588378,-99) , 
3, 1.09078, 0, 0, 0.703127,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659664,-99) , 
NN(
0, 
0, 
-1, -1.03367, 0, -1, 0.197278,-99) , 
1, -0.862599, 1, 0, 0.269147,-99) , 
3, -0.0426953, 0, 0, 0.515241,-99)    );
  // itree = 478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54529, 1, 1, 0.923589,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424191,-99) , 
0, 1.39039, 1, 0, 0.706909,-99) , 
3, 1.6518, 0, 0, 0.781567,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265342,-99) , 
0, 0.418264, 1, 0, 0.493654,-99) , 
NN(
0, 
0, 
-1, -1.63402, 0, -1, 0.184421,-99) , 
3, -0.4475, 0, 0, 0.343493,-99) , 
3, 0.742135, 0, 0, 0.485945,-99)    );
  // itree = 479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.844808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303638,-99) , 
0, 0.732038, 1, 0, 0.571211,-99) , 
3, 1.06028, 0, 0, 0.705018,-99) , 
NN(
0, 
0, 
-1, -1.64771, 0, -1, 0.28444,-99) , 
3, 0.240623, 0, 0, 0.492024,-99)    );
  // itree = 480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04569, 1, 1, 0.837264,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304387,-99) , 
0, 0.139985, 1, 0, 0.510942,-99) , 
NN(
0, 
0, 
-1, -1.59606, 0, -1, 0.20702,-99) , 
3, -0.384478, 0, 0, 0.359118,-99) , 
3, 0.828289, 0, 0, 0.500081,-99)    );
  // itree = 481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46506, 0, 1, 0.873061,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336753,-99) , 
0, 0.669133, 1, 0, 0.586188,-99) , 
3, 0.950051, 0, 0, 0.753723,-99) , 
NN(
0, 
0, 
-1, -1.51621, 0, -1, 0.292376,-99) , 
3, 0.34765, 0, 0, 0.492125,-99)    );
  // itree = 482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.94767, 1, 1, 0.869111,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456621,-99) , 
0, 0.0681851, 1, 0, 0.63664,-99) , 
3, 0.861778, 0, 0, 0.754884,-99) , 
NN(
0, 
0, 
-1, -0.787351, 0, -1, 0.21477,-99) , 
3, -0.0447319, 0, 0, 0.51033,-99)    );
  // itree = 483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66214, 0, 1, 0.850503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400572,-99) , 
0, 0.232439, 1, 0, 0.590315,-99) , 
3, 0.95337, 0, 0, 0.704367,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219867,-99) , 
1, -0.297941, 1, 0, 0.328198,-99) , 
NN(
0, 
0, 
-1, 0.210885, 1, -1, 0.0545956,-99) , 
3, -1.24633, 0, 0, 0.228249,-99) , 
3, -0.218528, 0, 0, 0.514212,-99)    );
  // itree = 484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.863663,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410152,-99) , 
0, 0.418264, 1, 0, 0.616185,-99) , 
3, 1.02218, 0, 0, 0.712956,-99) , 
NN(
0, 
0, 
-1, -1.60328, 0, -1, 0.195671,-99) , 
3, -0.351682, 0, 0, 0.540533,-99)    );
  // itree = 485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11116, 0, 1, 0.852477,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344794,-99) , 
0, -0.0721965, 1, 0, 0.475495,-99) , 
NN(
0, 
0, 
-1, -0.206791, 1, -1, 0.223535,-99) , 
3, -0.43371, 0, 0, 0.354,-99) , 
3, 0.742135, 0, 0, 0.505483,-99)    );
  // itree = 486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.858333,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339153,-99) , 
0, 0.969329, 1, 0, 0.610356,-99) , 
3, 1.13988, 0, 0, 0.6959,-99) , 
NN(
0, 
0, 
-1, -1.45982, 0, -1, 0.230946,-99) , 
3, -0.216753, 0, 0, 0.518938,-99)    );
  // itree = 487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38198, 0, 1, 0.806824,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359755,-99) , 
0, -0.0558779, 1, 0, 0.538071,-99) , 
3, 0.606621, 0, 0, 0.706347,-99) , 
NN(
0, 
0, 
-1, -0.821218, 0, -1, 0.239255,-99) , 
3, -0.0725463, 0, 0, 0.505816,-99)    );
  // itree = 488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2597, 1, 1, 0.836372,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366056,-99) , 
0, 0.141021, 1, 0, 0.562182,-99) , 
NN(
0, 
0, 
-1, -1.22411, 0, -1, 0.258518,-99) , 
3, 0.0942558, 0, 0, 0.339603,-99) , 
3, 0.677307, 0, 0, 0.508133,-99)    );
  // itree = 489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.815444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363191,-99) , 
0, -0.266769, 1, 0, 0.518379,-99) , 
3, 0.560587, 0, 0, 0.689322,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.222008,-99) , 
3, -0.133228, 0, 0, 0.497173,-99)    );
  // itree = 490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56795, 0, 1, 0.837532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291518,-99) , 
0, 0.546048, 1, 0, 0.60428,-99) , 
3, 0.832607, 0, 0, 0.724079,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.237027,-99) , 
3, -0.0725463, 0, 0, 0.507485,-99)    );
  // itree = 491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.26775, 1, 1, 0.818968,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324863,-99) , 
0, 0.076294, 1, 0, 0.531274,-99) , 
NN(
0, 
0, 
-1, -1.72947, 0, -1, 0.229247,-99) , 
3, -0.165897, 0, 0, 0.355343,-99) , 
3, 0.760049, 0, 0, 0.498109,-99)    );
  // itree = 492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24319, 1, 1, 0.817252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352364,-99) , 
0, 0.205108, 1, 0, 0.542609,-99) , 
3, 0.69392, 0, 0, 0.729122,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35547,-99) , 
0, -0.909982, 1, 0, 0.468345,-99) , 
NN(
0, 
0, 
-1, -1.30309, 0, -1, 0.160834,-99) , 
3, -0.574972, 0, 0, 0.305349,-99) , 
3, 0.27076, 0, 0, 0.500622,-99)    );
  // itree = 493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4671, 1, 1, 0.829175,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243645,-99) , 
0, 0.502964, 1, 0, 0.5333,-99) , 
3, 0.71404, 0, 0, 0.695077,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234859,-99) , 
0, -1.40777, 1, 0, 0.338921,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.0962022,-99) , 
3, -1.20223, 0, 0, 0.247934,-99) , 
3, -0.206128, 0, 0, 0.521494,-99)    );
  // itree = 494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.807629,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268806,-99) , 
1, 0.382446, 1, 0, 0.439754,-99) , 
NN(
0, 
0, 
-1, -1.69362, 0, -1, 0.173596,-99) , 
3, -0.761511, 0, 0, 0.342982,-99) , 
3, 0.760049, 0, 0, 0.497534,-99)    );
  // itree = 495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34359, 1, 1, 0.794112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326049,-99) , 
0, -0.200686, 1, 0, 0.497759,-99) , 
3, 0.482055, 0, 0, 0.678381,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174012,-99) , 
0, -1.14493, 1, 0, 0.328105,-99) , 
NN(
0, 
0, 
-1, -1.7112, 0, -1, 0.074104,-99) , 
3, -1.20632, 0, 0, 0.232897,-99) , 
3, -0.206128, 0, 0, 0.509498,-99)    );
  // itree = 496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.841549,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263351,-99) , 
0, 0.179441, 1, 0, 0.488993,-99) , 
NN(
0, 
0, 
-1, -1.18778, 0, -1, 0.177571,-99) , 
3, -0.451773, 0, 0, 0.338569,-99) , 
3, 0.760049, 0, 0, 0.48761,-99)    );
  // itree = 497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08069, 1, 1, 0.824527,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285873,-99) , 
0, 0.341578, 1, 0, 0.527315,-99) , 
3, 0.644531, 0, 0, 0.705198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207418,-99) , 
0, -0.897305, 1, 0, 0.38751,-99) , 
NN(
0, 
0, 
-1, -1.85619, 0, -1, 0.136257,-99) , 
3, -1.01686, 0, 0, 0.287803,-99) , 
3, -0.0295996, 0, 0, 0.508356,-99)    );
  // itree = 498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.735306, 1, 1, 0.77269,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224339,-99) , 
0, 0.0797988, 1, 0, 0.488994,-99) , 
3, 0.398699, 0, 0, 0.666725,-99) , 
NN(
0, 
0, 
-1, -1.0696, 0, -1, 0.211871,-99) , 
3, -0.302053, 0, 0, 0.498889,-99)    );
  // itree = 499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.870484,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37744,-99) , 
0, 0.71825, 1, 0, 0.643263,-99) , 
3, 1.0726, 0, 0, 0.757069,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325866,-99) , 
0, -0.817898, 1, 0, 0.449484,-99) , 
NN(
0, 
0, 
-1, -1.26031, 0, -1, 0.191647,-99) , 
3, -0.554775, 0, 0, 0.321265,-99) , 
3, 0.256412, 0, 0, 0.528854,-99)    );
  // itree = 500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.836639,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312531,-99) , 
0, 0.143304, 1, 0, 0.484694,-99) , 
NN(
0, 
0, 
-1, -1.12885, 0, -1, 0.163195,-99) , 
3, -0.661336, 0, 0, 0.363425,-99) , 
3, 0.828289, 0, 0, 0.497361,-99)    );
  // itree = 501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.88992,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421171,-99) , 
0, 0.700231, 1, 0, 0.597437,-99) , 
3, 1.19201, 0, 0, 0.702141,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.269651,-99) , 
3, -0.218528, 0, 0, 0.554216,-99)    );
  // itree = 502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.834431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287367,-99) , 
0, 0.488, 1, 0, 0.577089,-99) , 
3, 0.755146, 0, 0, 0.736774,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248047,-99) , 
0, -0.477384, 1, 0, 0.408948,-99) , 
NN(
0, 
0, 
-1, -1.6566, 0, -1, 0.163478,-99) , 
3, -0.423037, 0, 0, 0.247747,-99) , 
3, 0.125502, 0, 0, 0.488903,-99)    );
  // itree = 503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41017, 0, 1, 0.822531,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353705,-99) , 
0, 0.08705, 1, 0, 0.516425,-99) , 
NN(
0, 
0, 
-1, -1.51758, 0, -1, 0.217656,-99) , 
3, -0.239923, 0, 0, 0.326495,-99) , 
3, 0.673895, 0, 0, 0.494153,-99)    );
  // itree = 504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27873, 1, 1, 0.868876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340515,-99) , 
0, 0.985639, 1, 0, 0.607512,-99) , 
3, 1.11419, 0, 0, 0.739443,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304197,-99) , 
0, -1.30268, 1, 0, 0.367565,-99) , 
NN(
0, 
0, 
-1, -1.76751, 0, -1, 0.0985703,-99) , 
3, -1.12817, 0, 0, 0.288763,-99) , 
3, 0.27076, 0, 0, 0.488598,-99)    );
  // itree = 505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.69392, 0, 1, 0.78396,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225824,-99) , 
0, -0.160364, 1, 0, 0.462074,-99) , 
NN(
0, 
0, 
-1, -1.12746, 1, -1, 0.160616,-99) , 
3, -0.569108, 0, 0, 0.288144,-99) , 
3, 0.27076, 0, 0, 0.497288,-99)    );
  // itree = 506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.873194,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465426,-99) , 
0, 0.732038, 1, 0, 0.694361,-99) , 
3, 1.08812, 0, 0, 0.784088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685098,-99) , 
NN(
0, 
0, 
-1, -0.784728, 0, -1, 0.238747,-99) , 
3, -0.00802737, 0, 0, 0.300257,-99) , 
3, 0.268003, 0, 0, 0.518701,-99)    );
  // itree = 507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6012, 0, 1, 0.839273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390399,-99) , 
0, 0.451048, 1, 0, 0.590672,-99) , 
3, 1.11733, 0, 0, 0.682069,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160228,-99) , 
0, -1.10067, 1, 0, 0.337305,-99) , 
NN(
0, 
0, 
-1, -0.175545, 1, -1, 0.0812544,-99) , 
3, -1.22361, 0, 0, 0.248614,-99) , 
3, -0.231227, 0, 0, 0.514626,-99)    );
  // itree = 508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04252, 0, 1, 0.794326,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3296,-99) , 
0, -0.0939917, 1, 0, 0.511203,-99) , 
NN(
0, 
0, 
-1, -1.51758, 0, -1, 0.198992,-99) , 
3, -0.237998, 0, 0, 0.331143,-99) , 
3, 0.673895, 0, 0, 0.47555,-99)    );
  // itree = 509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.838071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299112,-99) , 
0, 0.170262, 1, 0, 0.540576,-99) , 
3, 0.632043, 0, 0, 0.70317,-99) , 
NN(
0, 
0, 
-1, -1.2009, 0, -1, 0.226692,-99) , 
3, -0.23959, 0, 0, 0.511409,-99)    );
  // itree = 510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.874102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339345,-99) , 
0, 0.91729, 1, 0, 0.632379,-99) , 
3, 1.15201, 0, 0, 0.727243,-99) , 
NN(
0, 
0, 
-1, -1.24435, 0, -1, 0.241982,-99) , 
3, 0.125502, 0, 0, 0.480455,-99)    );
  // itree = 511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38931, 0, 1, 0.874623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236902,-99) , 
0, 0.574351, 1, 0, 0.560722,-99) , 
3, 0.838401, 0, 0, 0.717874,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.248786,-99) , 
3, -0.0725463, 0, 0, 0.502335,-99)    );
  // itree = 512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.899078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362715,-99) , 
0, 0.939545, 1, 0, 0.624132,-99) , 
3, 1.16192, 0, 0, 0.724695,-99) , 
NN(
0, 
0, 
-1, -1.69862, 0, -1, 0.274645,-99) , 
3, -0.206128, 0, 0, 0.548861,-99)    );
  // itree = 513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60018, 0, 1, 0.826137,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207752,-99) , 
0, 0.158188, 1, 0, 0.460043,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.181774,-99) , 
3, -0.536792, 0, 0, 0.340714,-99) , 
3, 0.673895, 0, 0, 0.500357,-99)    );
  // itree = 514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.90164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233176,-99) , 
0, 1.18309, 1, 0, 0.632399,-99) , 
3, 1.1471, 0, 0, 0.75283,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335114,-99) , 
0, -0.795814, 1, 0, 0.482024,-99) , 
NN(
0, 
0, 
-1, -1.50654, 0, -1, 0.154925,-99) , 
3, -0.61383, 0, 0, 0.297103,-99) , 
3, 0.166609, 0, 0, 0.527443,-99)    );
  // itree = 515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.826436,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328928,-99) , 
0, -0.155205, 1, 0, 0.491162,-99) , 
3, 0.606621, 0, 0, 0.702844,-99) , 
NN(
0, 
0, 
-1, -0.572932, 0, -1, 0.239109,-99) , 
3, -0.0725463, 0, 0, 0.50391,-99)    );
  // itree = 516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.847695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325893,-99) , 
0, 0.284185, 1, 0, 0.551108,-99) , 
3, 0.89168, 0, 0, 0.695508,-99) , 
NN(
0, 
0, 
-1, -1.48475, 0, -1, 0.259656,-99) , 
3, -0.000832217, 0, 0, 0.508212,-99)    );
  // itree = 517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.785455,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234108,-99) , 
0, 0.308478, 1, 0, 0.46581,-99) , 
3, 0.652735, 0, 0, 0.605361,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.145407,-99) , 
3, -0.613987, 0, 0, 0.468026,-99)    );
  // itree = 518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72268, 0, 1, 0.863245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228842,-99) , 
0, 0.895088, 1, 0, 0.534893,-99) , 
3, 1.06041, 0, 0, 0.635281,-99) , 
NN(
0, 
0, 
-1, -1.17208, 1, -1, 0.136498,-99) , 
3, -0.680259, 0, 0, 0.503431,-99)    );
  // itree = 519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29079, 1, 1, 0.822148,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366452,-99) , 
0, 0.0287117, 1, 0, 0.541263,-99) , 
3, 0.686342, 0, 0, 0.686196,-99) , 
NN(
0, 
0, 
-1, -0.966246, 0, -1, 0.201486,-99) , 
3, -0.216753, 0, 0, 0.504313,-99)    );
  // itree = 520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.966756, 0, 1, 0.807847,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223334,-99) , 
0, 0.35788, 1, 0, 0.522082,-99) , 
NN(
0, 
0, 
-1, -1.30151, 0, -1, 0.169081,-99) , 
3, -0.57899, 0, 0, 0.365849,-99) , 
3, 0.602686, 0, 0, 0.522174,-99)    );
  // itree = 521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.785952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226595,-99) , 
0, 0.158188, 1, 0, 0.505679,-99) , 
3, 0.645973, 0, 0, 0.634453,-99) , 
NN(
0, 
0, 
-1, 0.434174, 1, -1, 0.157528,-99) , 
3, -0.613987, 0, 0, 0.496749,-99)    );
  // itree = 522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.827765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34305,-99) , 
0, 0.189027, 1, 0, 0.568712,-99) , 
3, 0.662988, 0, 0, 0.734003,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21706,-99) , 
0, -0.785825, 1, 0, 0.35891,-99) , 
NN(
0, 
0, 
-1, -1.21465, 0, -1, 0.15154,-99) , 
3, -0.752558, 0, 0, 0.238881,-99) , 
3, 0.0559666, 0, 0, 0.505792,-99)    );
  // itree = 523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.856497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354554,-99) , 
0, 0.0112647, 1, 0, 0.537248,-99) , 
3, 0.851097, 0, 0, 0.674679,-99) , 
NN(
0, 
0, 
-1, -1.0696, 0, -1, 0.20079,-99) , 
3, -0.302053, 0, 0, 0.506854,-99)    );
  // itree = 524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41082, 0, 1, 0.814954,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241018,-99) , 
0, 0.348213, 1, 0, 0.486778,-99) , 
NN(
0, 
0, 
-1, -1.25006, 0, -1, 0.208348,-99) , 
3, -0.226102, 0, 0, 0.328747,-99) , 
3, 0.673895, 0, 0, 0.485857,-99)    );
  // itree = 525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98325, 1, 1, 0.894132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479086,-99) , 
0, 0.076294, 1, 0, 0.59991,-99) , 
3, 1.14657, 0, 0, 0.705857,-99) , 
NN(
0, 
0, 
-1, -0.653771, 0, -1, 0.228365,-99) , 
3, -0.170449, 0, 0, 0.520831,-99)    );
  // itree = 526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50157, 1, 1, 0.872927,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264463,-99) , 
0, 1.49543, 1, 0, 0.629066,-99) , 
3, 1.53701, 0, 0, 0.687289,-99) , 
NN(
0, 
0, 
-1, -1.52735, 0, -1, 0.234672,-99) , 
3, -0.0426953, 0, 0, 0.477002,-99)    );
  // itree = 527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.810745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201075,-99) , 
0, 0.31133, 1, 0, 0.495293,-99) , 
3, 0.619599, 0, 0, 0.646504,-99) , 
NN(
0, 
0, 
-1, -1.72934, 0, -1, 0.127341,-99) , 
3, -0.613509, 0, 0, 0.506074,-99)    );
  // itree = 528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16005, 0, 1, 0.847836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284175,-99) , 
0, 0.506819, 1, 0, 0.530191,-99) , 
3, 0.789704, 0, 0, 0.684344,-99) , 
NN(
0, 
0, 
-1, -1.14068, 0, -1, 0.199794,-99) , 
3, -0.133228, 0, 0, 0.487111,-99)    );
  // itree = 529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.877133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414323,-99) , 
0, 0.758594, 1, 0, 0.616008,-99) , 
3, 1.17174, 0, 0, 0.730461,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271262,-99) , 
0, -1.07517, 1, 0, 0.383526,-99) , 
NN(
0, 
0, 
-1, -1.65007, 0, -1, 0.142398,-99) , 
3, -0.751608, 0, 0, 0.271739,-99) , 
3, 0.34753, 0, 0, 0.480966,-99)    );
  // itree = 530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.197352, 1, 1, 0.853534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.91256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430722,-99) , 
0, 0.0304304, 1, 0, 0.577127,-99) , 
3, 0.880704, 0, 0, 0.720668,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242037,-99) , 
0, -0.850436, 1, 0, 0.371925,-99) , 
NN(
0, 
0, 
-1, -1.80316, 0, -1, 0.0957319,-99) , 
3, -1.00336, 0, 0, 0.263375,-99) , 
3, -0.0172488, 0, 0, 0.514107,-99)    );
  // itree = 531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44957, 0, 1, 0.855957,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.9187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496463,-99) , 
0, 0.487108, 1, 0, 0.669409,-99) , 
3, 1.11005, 0, 0, 0.765184,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276861,-99) , 
0, -0.65582, 1, 0, 0.439102,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.178583,-99) , 
3, -0.574972, 0, 0, 0.285464,-99) , 
3, 0.27076, 0, 0, 0.48611,-99)    );
  // itree = 532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.619691, 1, 1, 0.836748,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325003,-99) , 
0, 0.292382, 1, 0, 0.538382,-99) , 
3, 0.712732, 0, 0, 0.745677,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290082,-99) , 
0, -0.65582, 1, 0, 0.435466,-99) , 
NN(
0, 
0, 
-1, -1.42202, 0, -1, 0.14561,-99) , 
3, -0.493211, 0, 0, 0.277053,-99) , 
3, 0.311026, 0, 0, 0.490157,-99)    );
  // itree = 533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68946, 0, 1, 0.878223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373342,-99) , 
0, 0.399302, 1, 0, 0.530319,-99) , 
3, 1.18593, 0, 0, 0.661306,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.162579,-99) , 
3, -0.218528, 0, 0, 0.462801,-99)    );
  // itree = 534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52649, 0, 1, 0.85029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252442,-99) , 
0, 0.210056, 1, 0, 0.51426,-99) , 
3, 0.814675, 0, 0, 0.66306,-99) , 
NN(
0, 
0, 
-1, -1.5887, 0, -1, 0.130443,-99) , 
3, -0.680259, 0, 0, 0.513535,-99)    );
  // itree = 535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.857591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265173,-99) , 
0, 0.91729, 1, 0, 0.619641,-99) , 
3, 1.11005, 0, 0, 0.723306,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171684,-99) , 
0, -0.243326, 1, 0, 0.421822,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.170554,-99) , 
3, -0.58167, 0, 0, 0.291379,-99) , 
3, 0.27076, 0, 0, 0.492906,-99)    );
  // itree = 536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.647521, 1, 1, 0.805422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421886,-99) , 
0, -0.399356, 1, 0, 0.542565,-99) , 
3, 0.627878, 0, 0, 0.662945,-99) , 
NN(
0, 
0, 
-1, -1.2689, 0, -1, 0.150051,-99) , 
3, -0.592572, 0, 0, 0.494279,-99)    );
  // itree = 537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54271, 1, 1, 0.88149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366166,-99) , 
0, 0.904113, 1, 0, 0.663086,-99) , 
3, 1.11737, 0, 0, 0.77102,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328503,-99) , 
0, -0.65582, 1, 0, 0.484628,-99) , 
NN(
0, 
0, 
-1, -1.63854, 0, -1, 0.148331,-99) , 
3, -0.492246, 0, 0, 0.292651,-99) , 
3, 0.311026, 0, 0, 0.50086,-99)    );
  // itree = 538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22238, 1, 1, 0.844671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447602,-99) , 
0, -0.816289, 1, 0, 0.519507,-99) , 
3, 0.951244, 0, 0, 0.650582,-99) , 
NN(
0, 
0, 
-1, -1.68269, 0, -1, 0.164317,-99) , 
3, -0.547237, 0, 0, 0.502793,-99)    );
  // itree = 539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01799, 0, 1, 0.891531,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479364,-99) , 
3, 1.47568, 0, 0, 0.725192,-99) , 
0, 1.47799, 1, 0, 0.807262,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338084,-99) , 
0, -0.0319407, 1, 0, 0.508005,-99) , 
NN(
0, 
0, 
-1, -0.00674708, 1, -1, 0.224721,-99) , 
3, -0.458396, 0, 0, 0.367796,-99) , 
3, 0.712472, 0, 0, 0.515396,-99)    );
  // itree = 540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.876873,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663214,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346875,-99) , 
0, 0.600296, 1, 0, 0.554679,-99) , 
3, 1.0878, 0, 0, 0.671278,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.199341,-99) , 
3, -0.291428, 0, 0, 0.49966,-99)    );
  // itree = 541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.861854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278021,-99) , 
1, 0.861366, 1, 0, 0.565414,-99) , 
3, 1.08882, 0, 0, 0.68857,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227836,-99) , 
0, -1.1022, 1, 0, 0.362561,-99) , 
NN(
0, 
0, 
-1, -0.0940381, 1, -1, 0.0702249,-99) , 
3, -1.28041, 0, 0, 0.273057,-99) , 
3, -0.0426953, 0, 0, 0.510013,-99)    );
  // itree = 542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.702985, 0, 1, 0.787744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240847,-99) , 
0, -0.363035, 1, 0, 0.414024,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.142217,-99) , 
3, -0.549382, 0, 0, 0.264204,-99) , 
3, 0.268003, 0, 0, 0.495657,-99)    );
  // itree = 543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.844228,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272805,-99) , 
0, 0.722082, 1, 0, 0.582211,-99) , 
3, 0.952846, 0, 0, 0.700809,-99) , 
NN(
0, 
0, 
-1, -0.901918, 1, -1, 0.218913,-99) , 
3, -0.218528, 0, 0, 0.509438,-99)    );
  // itree = 544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38858, 1, 1, 0.836143,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49338,-99) , 
2, 0.241504, 1, 0, 0.575076,-99) , 
3, 0.747475, 0, 0, 0.759944,-99) , 
NN(
0, 
0, 
-1, -1.51385, 0, -1, 0.300644,-99) , 
3, 0.34765, 0, 0, 0.498696,-99)    );
  // itree = 545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38557, 0, 1, 0.860862,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247021,-99) , 
0, 0.437739, 1, 0, 0.467226,-99) , 
NN(
0, 
0, 
-1, -1.57706, 0, -1, 0.172353,-99) , 
3, -0.665309, 0, 0, 0.35421,-99) , 
3, 0.828289, 0, 0, 0.501905,-99)    );
  // itree = 546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.877022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437661,-99) , 
0, 0.205991, 1, 0, 0.573932,-99) , 
3, 1.18232, 0, 0, 0.680838,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.202753,-99) , 
3, -0.218528, 0, 0, 0.473417,-99)    );
  // itree = 547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.24215, 1, 1, 0.811406,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265241,-99) , 
0, -0.035315, 1, 0, 0.462102,-99) , 
NN(
0, 
0, 
-1, -1.74319, 0, -1, 0.18842,-99) , 
3, -0.524691, 0, 0, 0.338683,-99) , 
3, 0.673895, 0, 0, 0.490578,-99)    );
  // itree = 548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.881322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421756,-99) , 
0, 1.08409, 1, 0, 0.659029,-99) , 
3, 1.21717, 0, 0, 0.790465,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276251,-99) , 
0, 0.0208352, 1, 0, 0.484526,-99) , 
NN(
0, 
0, 
-1, -1.55247, 1, -1, 0.16757,-99) , 
3, -0.497076, 0, 0, 0.331367,-99) , 
3, 0.677307, 0, 0, 0.483345,-99)    );
  // itree = 549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51148, 0, 1, 0.822377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365746,-99) , 
0, 0.446087, 1, 0, 0.557646,-99) , 
3, 0.799619, 0, 0, 0.715671,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252418,-99) , 
0, -0.944667, 1, 0, 0.366684,-99) , 
NN(
0, 
0, 
-1, -1.59167, 0, -1, 0.101907,-99) , 
3, -0.923117, 0, 0, 0.269051,-99) , 
3, 0.179643, 0, 0, 0.4724,-99)    );
  // itree = 550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20249, 0, 1, 0.845821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344186,-99) , 
0, 0.250026, 1, 0, 0.575117,-99) , 
3, 0.832607, 0, 0, 0.718099,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202228,-99) , 
0, -1.24308, 1, 0, 0.320119,-99) , 
NN(
0, 
0, 
-1, -1.67705, 0, -1, 0.117019,-99) , 
3, -1.0699, 0, 0, 0.237139,-99) , 
3, -0.0725463, 0, 0, 0.506749,-99)    );
  // itree = 551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17973, 1, 1, 0.849665,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377787,-99) , 
0, 0.505756, 1, 0, 0.608319,-99) , 
3, 1.0812, 0, 0, 0.704389,-99) , 
NN(
0, 
0, 
-1, -0.677103, 1, -1, 0.226486,-99) , 
3, -0.260982, 0, 0, 0.505015,-99)    );
  // itree = 552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37881, 1, 1, 0.848618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417083,-99) , 
0, 0.764278, 1, 0, 0.617152,-99) , 
3, 1.08935, 0, 0, 0.734695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344522,-99) , 
0, -0.612827, 1, 0, 0.48864,-99) , 
NN(
0, 
0, 
-1, -1.49813, 0, -1, 0.209073,-99) , 
3, -0.56087, 0, 0, 0.324097,-99) , 
3, 0.268003, 0, 0, 0.520051,-99)    );
  // itree = 553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.56108, 0, 1, 0.836821,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27998,-99) , 
0, 0.06353, 1, 0, 0.431533,-99) , 
NN(
0, 
0, 
-1, -1.60679, 0, -1, 0.131311,-99) , 
3, -0.958851, 0, 0, 0.345308,-99) , 
3, 0.828289, 0, 0, 0.489229,-99)    );
  // itree = 554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.880002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369918,-99) , 
0, 0.91729, 1, 0, 0.645685,-99) , 
3, 1.17479, 0, 0, 0.760283,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369759,-99) , 
0, -0.952508, 1, 0, 0.465881,-99) , 
NN(
0, 
0, 
-1, -1.44523, 0, -1, 0.179416,-99) , 
3, -0.759579, 0, 0, 0.322445,-99) , 
3, 0.34753, 0, 0, 0.523115,-99)    );
  // itree = 555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.698051, 1, 1, 0.867573,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792728,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444752,-99) , 
0, 0.417593, 1, 0, 0.600848,-99) , 
3, 0.763081, 0, 0, 0.788032,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310326,-99) , 
0, -0.579953, 1, 0, 0.429576,-99) , 
NN(
0, 
0, 
-1, -1.6543, 0, -1, 0.201213,-99) , 
3, -0.476904, 0, 0, 0.303135,-99) , 
3, 0.34753, 0, 0, 0.504221,-99)    );
  // itree = 556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58262, 1, 1, 0.824537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.925882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369496,-99) , 
0, 0.0804315, 1, 0, 0.581149,-99) , 
3, 0.608397, 0, 0, 0.753383,-99) , 
NN(
0, 
0, 
-1, -1.46884, 0, -1, 0.262462,-99) , 
3, 0.191234, 0, 0, 0.490021,-99)    );
  // itree = 557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38665, 0, 1, 0.842734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300523,-99) , 
0, 0.244975, 1, 0, 0.536987,-99) , 
3, 0.610069, 0, 0, 0.732955,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.23298,-99) , 
3, -0.0725463, 0, 0, 0.514335,-99)    );
  // itree = 558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.840895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408469,-99) , 
0, 0.0896191, 1, 0, 0.576598,-99) , 
3, 0.95924, 0, 0, 0.694466,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.238559,-99) , 
3, -0.218528, 0, 0, 0.519468,-99)    );
  // itree = 559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63246, 0, 1, 0.877487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380637,-99) , 
0, 0.803606, 1, 0, 0.644157,-99) , 
3, 1.14829, 0, 0, 0.758773,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294495,-99) , 
0, -0.772466, 1, 0, 0.41248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0694523,-99) , 
3, -1.51351, 0, 0, 0.352674,-99) , 
3, 0.34765, 0, 0, 0.539236,-99)    );
  // itree = 560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.975568, 1, 1, 0.797835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302764,-99) , 
0, -0.0153026, 1, 0, 0.527038,-99) , 
3, 0.626692, 0, 0, 0.665109,-99) , 
NN(
0, 
0, 
-1, -2.07152, 1, -1, 0.153562,-99) , 
3, -0.590332, 0, 0, 0.510704,-99)    );
  // itree = 561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48607, 1, 1, 0.836371,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35034,-99) , 
0, 0.415118, 1, 0, 0.571368,-99) , 
3, 0.686342, 0, 0, 0.71648,-99) , 
NN(
0, 
0, 
-1, -0.714496, 0, -1, 0.241214,-99) , 
3, -0.216753, 0, 0, 0.528852,-99)    );
  // itree = 562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98872, 1, 1, 0.881426,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289514,-99) , 
0, 0.91729, 1, 0, 0.561849,-99) , 
3, 1.15905, 0, 0, 0.678506,-99) , 
NN(
0, 
0, 
-1, -0.706455, 0, -1, 0.21838,-99) , 
3, -0.206128, 0, 0, 0.481923,-99)    );
  // itree = 563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21585, 1, 1, 0.870518,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362335,-99) , 
0, 0.830155, 1, 0, 0.604142,-99) , 
3, 1.12078, 0, 0, 0.726971,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296836,-99) , 
0, -1.43043, 1, 0, 0.356652,-99) , 
NN(
0, 
0, 
-1, -2.74608, 1, -1, 0.0995837,-99) , 
3, -1.13339, 0, 0, 0.284337,-99) , 
3, 0.27076, 0, 0, 0.475075,-99)    );
  // itree = 564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6053, 0, 1, 0.822053,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302548,-99) , 
0, -0.12465, 1, 0, 0.487855,-99) , 
3, 0.645973, 0, 0, 0.648985,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.150885,-99) , 
3, -0.613987, 0, 0, 0.499177,-99)    );
  // itree = 565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34979, 0, 1, 0.833243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254758,-99) , 
0, 0.0804575, 1, 0, 0.511441,-99) , 
3, 0.566184, 0, 0, 0.703574,-99) , 
NN(
0, 
0, 
-1, -1.6459, 0, -1, 0.199581,-99) , 
3, -0.133228, 0, 0, 0.506045,-99)    );
  // itree = 566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.649629, 1, 1, 0.964786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450164,-99) , 
3, 1.20222, 0, 0, 0.73343,-99) , 
0, 1.11079, 1, 0, 0.812889,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30968,-99) , 
0, 0.08705, 1, 0, 0.57741,-99) , 
NN(
0, 
0, 
-1, -1.27216, 0, -1, 0.237974,-99) , 
3, -0.249592, 0, 0, 0.370465,-99) , 
3, 0.644232, 0, 0, 0.534792,-99)    );
  // itree = 567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.869865,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260001,-99) , 
0, 0.835519, 1, 0, 0.56674,-99) , 
3, 1.11005, 0, 0, 0.722704,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249769,-99) , 
0, -0.703149, 1, 0, 0.381657,-99) , 
NN(
0, 
0, 
-1, -1.76751, 0, -1, 0.12771,-99) , 
3, -1.12817, 0, 0, 0.308604,-99) , 
3, 0.27076, 0, 0, 0.492796,-99)    );
  // itree = 568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.862157,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437859,-99) , 
0, 0.190909, 1, 0, 0.589636,-99) , 
3, 0.969023, 0, 0, 0.715115,-99) , 
NN(
0, 
0, 
-1, -1.63954, 0, -1, 0.243604,-99) , 
3, -0.145446, 0, 0, 0.527838,-99)    );
  // itree = 569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.84934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461539,-99) , 
0, 0.0304304, 1, 0, 0.590914,-99) , 
3, 0.95337, 0, 0, 0.704227,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29953,-99) , 
0, -1.03299, 1, 0, 0.406456,-99) , 
NN(
0, 
0, 
-1, -1.43731, 0, -1, 0.104427,-99) , 
3, -0.997797, 0, 0, 0.239481,-99) , 
3, -0.218528, 0, 0, 0.520333,-99)    );
  // itree = 570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44843, 1, 1, 0.840788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370822,-99) , 
0, 0.0937589, 1, 0, 0.561883,-99) , 
3, 0.957575, 0, 0, 0.680641,-99) , 
NN(
0, 
0, 
-1, -0.648926, 0, -1, 0.24503,-99) , 
3, -0.156071, 0, 0, 0.506796,-99)    );
  // itree = 571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.860049,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288382,-99) , 
0, 0.447614, 1, 0, 0.533196,-99) , 
3, 0.860221, 0, 0, 0.676052,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.169092,-99) , 
3, -0.291428, 0, 0, 0.473831,-99)    );
  // itree = 572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.818934,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195598,-99) , 
0, 0.190311, 1, 0, 0.444527,-99) , 
NN(
0, 
0, 
-1, -1.50365, 0, -1, 0.138467,-99) , 
3, -0.535926, 0, 0, 0.310084,-99) , 
3, 0.661338, 0, 0, 0.462272,-99)    );
  // itree = 573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.962827, 1, 1, 0.797876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341585,-99) , 
0, -0.0219203, 1, 0, 0.518172,-99) , 
3, 0.606621, 0, 0, 0.690337,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195542,-99) , 
1, 0.165108, 1, 0, 0.368666,-99) , 
NN(
0, 
0, 
-1, -1.53248, 0, -1, 0.0643557,-99) , 
3, -1.06796, 0, 0, 0.251631,-99) , 
3, -0.0725463, 0, 0, 0.502496,-99)    );
  // itree = 574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7537, 1, 1, 0.84082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282883,-99) , 
0, 0.834925, 1, 0, 0.619423,-99) , 
3, 1.00602, 0, 0, 0.727255,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278911,-99) , 
0, -1.43925, 1, 0, 0.349322,-99) , 
NN(
0, 
0, 
-1, 0.154445, 0, -1, 0.059269,-99) , 
3, -1.19916, 0, 0, 0.273172,-99) , 
3, 0.179643, 0, 0, 0.497858,-99)    );
  // itree = 575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58382, 0, 1, 0.771585,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214486,-99) , 
0, -0.341503, 1, 0, 0.438181,-99) , 
NN(
0, 
0, 
-1, -0.00674708, 1, -1, 0.157981,-99) , 
3, -0.481272, 0, 0, 0.280781,-99) , 
3, 0.34753, 0, 0, 0.492995,-99)    );
  // itree = 576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.83505,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448563,-99) , 
0, -0.275303, 1, 0, 0.555387,-99) , 
3, 1.08009, 0, 0, 0.650259,-99) , 
NN(
0, 
0, 
-1, -1.58598, 0, -1, 0.171959,-99) , 
3, -0.302053, 0, 0, 0.482716,-99)    );
  // itree = 577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59914, 0, 1, 0.83915,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221593,-99) , 
0, 0.227133, 1, 0, 0.501543,-99) , 
NN(
0, 
0, 
-1, -1.25834, 0, -1, 0.17161,-99) , 
3, -0.524691, 0, 0, 0.349559,-99) , 
3, 0.673895, 0, 0, 0.50666,-99)    );
  // itree = 578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0134887, 1, 1, 0.84056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447245,-99) , 
0, -0.575472, 1, 0, 0.53711,-99) , 
3, 0.948978, 0, 0, 0.664845,-99) , 
NN(
0, 
0, 
-1, -1.65461, 0, -1, 0.154768,-99) , 
3, -0.415423, 0, 0, 0.484893,-99)    );
  // itree = 579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.999863, 0, 1, 0.818234,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310753,-99) , 
0, 0.146168, 1, 0, 0.518841,-99) , 
3, 0.610069, 0, 0, 0.691218,-99) , 
NN(
0, 
0, 
-1, -1.31656, 0, -1, 0.230562,-99) , 
3, -0.0725463, 0, 0, 0.493651,-99)    );
  // itree = 580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11421, 1, 1, 0.821541,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299834,-99) , 
0, 0.162203, 1, 0, 0.456615,-99) , 
NN(
0, 
0, 
-1, -0.24519, 1, -1, 0.153537,-99) , 
3, -0.682618, 0, 0, 0.335146,-99) , 
3, 0.778124, 0, 0, 0.464547,-99)    );
  // itree = 581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4886, 0, 1, 0.841838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409938,-99) , 
1, 0.263134, 1, 0, 0.557308,-99) , 
3, 1.14952, 0, 0, 0.653479,-99) , 
NN(
0, 
0, 
-1, -1.07728, 0, -1, 0.140117,-99) , 
3, -0.613987, 0, 0, 0.492687,-99)    );
  // itree = 582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30021, 1, 1, 0.807155,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324173,-99) , 
0, 0.0584112, 1, 0, 0.54429,-99) , 
3, 0.649565, 0, 0, 0.703523,-99) , 
NN(
0, 
0, 
-1, -0.546985, 0, -1, 0.265329,-99) , 
3, -0.0426953, 0, 0, 0.509151,-99)    );
  // itree = 583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832592, 0, 1, 0.753346,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324115,-99) , 
0, -1.30268, 1, 0, 0.388552,-99) , 
NN(
0, 
0, 
-1, -0.512928, 1, -1, 0.0613285,-99) , 
3, -1.19301, 0, 0, 0.300341,-99) , 
3, 0.427177, 0, 0, 0.486939,-99)    );
  // itree = 584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.836518,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249852,-99) , 
0, 0.341578, 1, 0, 0.492111,-99) , 
NN(
0, 
0, 
-1, -1.6781, 0, -1, 0.20365,-99) , 
3, -0.451773, 0, 0, 0.360258,-99) , 
3, 0.760049, 0, 0, 0.504294,-99)    );
  // itree = 585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04252, 0, 1, 0.85111,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357137,-99) , 
0, -0.135656, 1, 0, 0.524119,-99) , 
NN(
0, 
0, 
-1, -1.51758, 0, -1, 0.214427,-99) , 
3, -0.226102, 0, 0, 0.347887,-99) , 
3, 0.673895, 0, 0, 0.520724,-99)    );
  // itree = 586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832592, 0, 1, 0.755259,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307581,-99) , 
0, -0.814411, 1, 0, 0.399783,-99) , 
NN(
0, 
0, 
-1, -1.54166, 0, -1, 0.147203,-99) , 
3, -0.653984, 0, 0, 0.282917,-99) , 
3, 0.427177, 0, 0, 0.472614,-99)    );
  // itree = 587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.88642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424416,-99) , 
0, 1.30507, 1, 0, 0.706093,-99) , 
3, 1.28845, 0, 0, 0.795943,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142553,-99) , 
0, 0.295007, 1, 0, 0.444971,-99) , 
NN(
0, 
0, 
-1, -1.49813, 0, -1, 0.149166,-99) , 
3, -0.566574, 0, 0, 0.312017,-99) , 
3, 0.577397, 0, 0, 0.482904,-99)    );
  // itree = 588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48153, 0, 1, 0.8051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870082,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419236,-99) , 
0, -0.328864, 1, 0, 0.539445,-99) , 
3, 0.727045, 0, 0, 0.675194,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.216827,-99) , 
3, -0.218528, 0, 0, 0.505792,-99)    );
  // itree = 589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.826129,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237707,-99) , 
0, 0.295007, 1, 0, 0.499369,-99) , 
3, 0.616639, 0, 0, 0.676537,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.118142,-99) , 
0, -1.12699, 1, 0, 0.270529,-99) , 
NN(
0, 
0, 
-1, -1.71131, 0, -1, 0.111125,-99) , 
3, -1.05968, 0, 0, 0.19218,-99) , 
3, -0.302053, 0, 0, 0.484483,-99)    );
  // itree = 590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35946, 0, 1, 0.793364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282398,-99) , 
0, 0.156982, 1, 0, 0.497328,-99) , 
3, 0.620113, 0, 0, 0.64032,-99) , 
NN(
0, 
0, 
-1, -1.48322, 0, -1, 0.18477,-99) , 
3, -0.589085, 0, 0, 0.50919,-99)    );
  // itree = 591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39809, 0, 1, 0.811407,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339469,-99) , 
0, -0.360328, 1, 0, 0.484606,-99) , 
NN(
0, 
0, 
-1, -1.51758, 0, -1, 0.193945,-99) , 
3, -0.239923, 0, 0, 0.316007,-99) , 
3, 0.661338, 0, 0, 0.480122,-99)    );
  // itree = 592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50255, 1, 1, 0.84045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333714,-99) , 
0, 0.190526, 1, 0, 0.531081,-99) , 
3, 0.827678, 0, 0, 0.669716,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148113,-99) , 
0, -1.81245, 1, 0, 0.243989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0427163,-99) , 
3, -1.58146, 0, 0, 0.198926,-99) , 
3, -0.316527, 0, 0, 0.465488,-99)    );
  // itree = 593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.858638,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351003,-99) , 
0, 0.461514, 1, 0, 0.578264,-99) , 
3, 0.970024, 0, 0, 0.700945,-99) , 
NN(
0, 
0, 
-1, -1.13315, 0, -1, 0.233194,-99) , 
3, -0.145446, 0, 0, 0.502103,-99)    );
  // itree = 594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08166, 1, 1, 0.838878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401965,-99) , 
0, 0.0681851, 1, 0, 0.59362,-99) , 
3, 0.794841, 0, 0, 0.71742,-99) , 
NN(
0, 
0, 
-1, -1.64684, 0, -1, 0.210434,-99) , 
3, -0.133228, 0, 0, 0.484944,-99)    );
  // itree = 595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.750877, 0, 1, 0.751405,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184898,-99) , 
0, -0.135656, 1, 0, 0.43901,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.186346,-99) , 
3, -0.452874, 0, 0, 0.296238,-99) , 
3, 0.349483, 0, 0, 0.486674,-99)    );
  // itree = 596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15882, 0, 1, 0.822992,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174575,-99) , 
0, 0.265915, 1, 0, 0.468763,-99) , 
NN(
0, 
0, 
-1, -1.7792, 0, -1, 0.142844,-99) , 
3, -0.582745, 0, 0, 0.316952,-99) , 
3, 0.602686, 0, 0, 0.481905,-99)    );
  // itree = 597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.887222,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295451,-99) , 
0, 1.01958, 1, 0, 0.550593,-99) , 
3, 1.18232, 0, 0, 0.666133,-99) , 
NN(
0, 
0, 
-1, -1.2441, 0, -1, 0.213498,-99) , 
3, -0.218528, 0, 0, 0.475759,-99)    );
  // itree = 598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.03517, 0, 1, 0.795933,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274998,-99) , 
0, -0.111037, 1, 0, 0.457803,-99) , 
NN(
0, 
0, 
-1, -1.19249, 0, -1, 0.156952,-99) , 
3, -0.485703, 0, 0, 0.310337,-99) , 
3, 0.677307, 0, 0, 0.465635,-99)    );
  // itree = 599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.851212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263722,-99) , 
0, 0.865651, 1, 0, 0.608485,-99) , 
3, 1.02586, 0, 0, 0.730533,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2989,-99) , 
0, -0.350309, 1, 0, 0.491314,-99) , 
NN(
0, 
0, 
-1, -0.357284, 1, -1, 0.163127,-99) , 
3, -0.639477, 0, 0, 0.304269,-99) , 
3, 0.191234, 0, 0, 0.515618,-99)    );
  // itree = 600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63458, 1, 1, 0.830532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.949027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349946,-99) , 
0, -0.120907, 1, 0, 0.537563,-99) , 
3, 0.95924, 0, 0, 0.673188,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185749,-99) , 
0, -1.37913, 1, 0, 0.336442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0099175,-99) , 
3, -1.50393, 0, 0, 0.251184,-99) , 
3, -0.218528, 0, 0, 0.525924,-99)    );
  // itree = 601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13142, 0, 1, 0.846917,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359499,-99) , 
1, 0.383631, 1, 0, 0.544059,-99) , 
3, 0.733653, 0, 0, 0.685524,-99) , 
NN(
0, 
0, 
-1, -1.40484, 0, -1, 0.171731,-99) , 
3, -0.499995, 0, 0, 0.518836,-99)    );
  // itree = 602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07419, 1, 1, 0.848735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409599,-99) , 
0, -0.15388, 1, 0, 0.543446,-99) , 
3, 0.897747, 0, 0, 0.657145,-99) , 
NN(
0, 
0, 
-1, 0.0519819, 1, -1, 0.139539,-99) , 
3, -0.613987, 0, 0, 0.482105,-99)    );
  // itree = 603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.869724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391519,-99) , 
0, 0.764278, 1, 0, 0.67034,-99) , 
3, 1.11005, 0, 0, 0.767223,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250758,-99) , 
0, -0.276765, 1, 0, 0.477888,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.157815,-99) , 
3, -0.569108, 0, 0, 0.286299,-99) , 
3, 0.27076, 0, 0, 0.50023,-99)    );
  // itree = 604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.476995, 1, 1, 0.781553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494337,-99) , 
3, 0.416534, 0, 0, 0.70398,-99) , 
NN(
0, 
0, 
-1, -1.0409, 0, -1, 0.192263,-99) , 
3, -0.0447319, 0, 0, 0.46853,-99)    );
  // itree = 605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.892649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356638,-99) , 
0, 0.488, 1, 0, 0.58139,-99) , 
3, 1.00602, 0, 0, 0.744455,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343083,-99) , 
0, -0.612827, 1, 0, 0.486027,-99) , 
NN(
0, 
0, 
-1, -1.14182, 0, -1, 0.171803,-99) , 
3, -0.648083, 0, 0, 0.299951,-99) , 
3, 0.179643, 0, 0, 0.52443,-99)    );
  // itree = 606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41775, 1, 1, 0.801981,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287887,-99) , 
0, -0.0428066, 1, 0, 0.4774,-99) , 
NN(
0, 
0, 
-1, -1.51515, 0, -1, 0.177735,-99) , 
3, -0.833854, 0, 0, 0.362854,-99) , 
3, 0.661338, 0, 0, 0.525986,-99)    );
  // itree = 607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.46772, 0, 1, 0.819668,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363582,-99) , 
0, -0.257043, 1, 0, 0.508497,-99) , 
NN(
0, 
0, 
-1, -1.15957, 0, -1, 0.207324,-99) , 
3, -0.44611, 0, 0, 0.354764,-99) , 
3, 0.729578, 0, 0, 0.49718,-99)    );
  // itree = 608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11733, 0, 1, 0.707528,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.175361,-99) , 
0, -1.72123, 1, 0, 0.275694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0326516,-99) , 
3, -1.47055, 0, 0, 0.215237,-99) , 
3, -0.231227, 0, 0, 0.512477,-99)    );
  // itree = 609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.829995,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248118,-99) , 
0, 0.227133, 1, 0, 0.515529,-99) , 
3, 0.646791, 0, 0, 0.66885,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.146724,-99) , 
3, -0.613987, 0, 0, 0.51089,-99)    );
  // itree = 610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.837991,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367416,-99) , 
0, 0.826055, 1, 0, 0.589976,-99) , 
3, 1.0209, 0, 0, 0.71942,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307007,-99) , 
1, -0.963846, 1, 0, 0.359485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0554403,-99) , 
3, -1.4705, 0, 0, 0.304185,-99) , 
3, 0.191234, 0, 0, 0.505538,-99)    );
  // itree = 611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.866356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493093,-99) , 
0, 0.186734, 1, 0, 0.614152,-99) , 
3, 1.15225, 0, 0, 0.70606,-99) , 
NN(
0, 
0, 
-1, -1.69911, 0, -1, 0.230625,-99) , 
3, -0.206128, 0, 0, 0.49805,-99)    );
  // itree = 612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.60806, 0, 1, 0.855969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416315,-99) , 
3, 1.17978, 0, 0, 0.68172,-99) , 
0, 1.00591, 1, 0, 0.758053,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338136,-99) , 
0, -0.814411, 1, 0, 0.449264,-99) , 
NN(
0, 
0, 
-1, -1.18474, 0, -1, 0.207141,-99) , 
3, -0.477004, 0, 0, 0.317044,-99) , 
3, 0.34753, 0, 0, 0.511132,-99)    );
  // itree = 613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.871737,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305684,-99) , 
1, 0.373613, 1, 0, 0.468874,-99) , 
NN(
0, 
0, 
-1, -1.67157, 1, -1, 0.131085,-99) , 
3, -0.675449, 0, 0, 0.333273,-99) , 
3, 0.778124, 0, 0, 0.48571,-99)    );
  // itree = 614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26691, 1, 1, 0.823152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248784,-99) , 
0, 0.259256, 1, 0, 0.543765,-99) , 
3, 0.701791, 0, 0, 0.684259,-99) , 
NN(
0, 
0, 
-1, -1.68094, 0, -1, 0.186127,-99) , 
3, -0.547237, 0, 0, 0.528753,-99)    );
  // itree = 615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63534, 0, 1, 0.866232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29179,-99) , 
0, 0.927932, 1, 0, 0.574728,-99) , 
3, 1.15167, 0, 0, 0.6722,-99) , 
NN(
0, 
0, 
-1, -0.705832, 0, -1, 0.201361,-99) , 
3, -0.206128, 0, 0, 0.480741,-99)    );
  // itree = 616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69109, 1, 1, 0.880569,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324069,-99) , 
0, 0.891504, 1, 0, 0.565735,-99) , 
3, 1.15167, 0, 0, 0.675184,-99) , 
NN(
0, 
0, 
-1, -1.45042, 0, -1, 0.211055,-99) , 
3, -0.206128, 0, 0, 0.487689,-99)    );
  // itree = 617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08382, 0, 1, 0.824145,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204391,-99) , 
0, -0.243326, 1, 0, 0.45048,-99) , 
NN(
0, 
0, 
-1, -1.68753, 1, -1, 0.159884,-99) , 
3, -0.554775, 0, 0, 0.286755,-99) , 
3, 0.256412, 0, 0, 0.516519,-99)    );
  // itree = 618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.863335,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355559,-99) , 
0, 0.0946665, 1, 0, 0.527991,-99) , 
3, 1.09308, 0, 0, 0.630941,-99) , 
NN(
0, 
0, 
-1, -1.49257, 0, -1, 0.146092,-99) , 
3, -0.605731, 0, 0, 0.496083,-99)    );
  // itree = 619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.698, 0, 1, 0.850901,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26471,-99) , 
0, 0.179441, 1, 0, 0.503558,-99) , 
NN(
0, 
0, 
-1, -0.684744, 1, -1, 0.182733,-99) , 
3, -0.451773, 0, 0, 0.341878,-99) , 
3, 0.760049, 0, 0, 0.495325,-99)    );
  // itree = 620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08605, 0, 1, 0.724057,-99) , 
NN(
0, 
0, 
-1, -0.540218, 0, -1, 0.256124,-99) , 
3, -0.0447319, 0, 0, 0.525859,-99)    );
  // itree = 621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.852825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346821,-99) , 
0, 0.446638, 1, 0, 0.60071,-99) , 
3, 1.0878, 0, 0, 0.692726,-99) , 
NN(
0, 
0, 
-1, -1.30467, 0, -1, 0.212896,-99) , 
3, -0.291428, 0, 0, 0.534607,-99)    );
  // itree = 622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.862285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392021,-99) , 
0, 0.525012, 1, 0, 0.591788,-99) , 
3, 0.878876, 0, 0, 0.759209,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183931,-99) , 
0, -0.211204, 1, 0, 0.444953,-99) , 
NN(
0, 
0, 
-1, -1.71303, 0, -1, 0.149752,-99) , 
3, -0.549382, 0, 0, 0.286303,-99) , 
3, 0.268003, 0, 0, 0.481368,-99)    );
  // itree = 623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.759671, 0, 1, 0.732762,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250367,-99) , 
0, -0.449573, 1, 0, 0.396063,-99) , 
NN(
0, 
0, 
-1, 0.407578, 1, -1, 0.183127,-99) , 
3, -0.476904, 0, 0, 0.280959,-99) , 
3, 0.34753, 0, 0, 0.47473,-99)    );
  // itree = 624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59461, 0, 1, 0.82847,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31433,-99) , 
0, -0.0153026, 1, 0, 0.493044,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.14509,-99) , 
3, -0.524691, 0, 0, 0.322243,-99) , 
3, 0.673895, 0, 0, 0.479582,-99)    );
  // itree = 625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63715, 0, 1, 0.854089,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358657,-99) , 
0, 0.758594, 1, 0, 0.612255,-99) , 
3, 1.14923, 0, 0, 0.739955,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251856,-99) , 
0, -0.251263, 1, 0, 0.45678,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.156495,-99) , 
3, -0.449844, 0, 0, 0.272745,-99) , 
3, 0.349483, 0, 0, 0.475632,-99)    );
  // itree = 626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.290576, 0, 1, 0.754388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212297,-99) , 
0, -1.39951, 1, 0, 0.33698,-99) , 
NN(
0, 
0, 
-1, -0.206791, 1, -1, 0.0686937,-99) , 
3, -1.40172, 0, 0, 0.248685,-99) , 
3, -0.156071, 0, 0, 0.559235,-99)    );
  // itree = 627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.855552,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30089,-99) , 
0, 0.506819, 1, 0, 0.540747,-99) , 
3, 0.926104, 0, 0, 0.666678,-99) , 
NN(
0, 
0, 
-1, -1.45095, 0, -1, 0.212293,-99) , 
3, -0.206128, 0, 0, 0.497476,-99)    );
  // itree = 628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67804, 0, 1, 0.846478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314469,-99) , 
0, 0.461514, 1, 0, 0.553795,-99) , 
3, 0.970169, 0, 0, 0.674772,-99) , 
NN(
0, 
0, 
-1, -1.75664, 0, -1, 0.220186,-99) , 
3, -0.218528, 0, 0, 0.498523,-99)    );
  // itree = 629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47786, 1, 1, 0.865045,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17309,-99) , 
0, 0.716184, 1, 0, 0.487409,-99) , 
NN(
0, 
0, 
-1, -1.48954, 0, -1, 0.184903,-99) , 
3, -0.299062, 0, 0, 0.346262,-99) , 
3, 0.876835, 0, 0, 0.486173,-99)    );
  // itree = 630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42859, 1, 1, 0.85196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384301,-99) , 
0, 0.889814, 1, 0, 0.657841,-99) , 
3, 1.11005, 0, 0, 0.756684,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206138,-99) , 
0, -0.243326, 1, 0, 0.443083,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.177978,-99) , 
3, -0.58167, 0, 0, 0.302615,-99) , 
3, 0.27076, 0, 0, 0.491234,-99)    );
  // itree = 631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.833239,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312545,-99) , 
0, -0.423729, 1, 0, 0.454004,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.152798,-99) , 
3, -0.57899, 0, 0, 0.320495,-99) , 
3, 0.602686, 0, 0, 0.493553,-99)    );
  // itree = 632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.848381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331523,-99) , 
0, 0.446087, 1, 0, 0.594882,-99) , 
3, 0.814182, 0, 0, 0.746494,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282785,-99) , 
0, -0.615667, 1, 0, 0.465757,-99) , 
NN(
0, 
0, 
-1, -1.61204, 0, -1, 0.159429,-99) , 
3, -0.642464, 0, 0, 0.307964,-99) , 
3, 0.191234, 0, 0, 0.520144,-99)    );
  // itree = 633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63458, 1, 1, 0.830324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373461,-99) , 
0, -0.154263, 1, 0, 0.535495,-99) , 
3, 0.897747, 0, 0, 0.664372,-99) , 
NN(
0, 
0, 
-1, -1.53081, 0, -1, 0.137971,-99) , 
3, -0.613987, 0, 0, 0.499726,-99)    );
  // itree = 634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.96889, 0, 1, 0.779759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260326,-99) , 
0, 0.0283268, 1, 0, 0.485237,-99) , 
NN(
0, 
0, 
-1, -1.5431, 0, -1, 0.16594,-99) , 
3, -0.588231, 0, 0, 0.341963,-99) , 
3, 0.602686, 0, 0, 0.495028,-99)    );
  // itree = 635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.819908, 0, 1, 0.768245,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192021,-99) , 
0, -0.0748989, 1, 0, 0.432911,-99) , 
NN(
0, 
0, 
-1, -1.58162, 0, -1, 0.192772,-99) , 
3, -0.414993, 0, 0, 0.295343,-99) , 
3, 0.402144, 0, 0, 0.480507,-99)    );
  // itree = 636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32004, 0, 1, 0.833797,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289214,-99) , 
0, -0.0428066, 1, 0, 0.485866,-99) , 
NN(
0, 
0, 
-1, -1.43352, 0, -1, 0.171391,-99) , 
3, -0.45279, 0, 0, 0.342136,-99) , 
3, 0.760049, 0, 0, 0.485525,-99)    );
  // itree = 637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.62524, 0, 1, 0.758256,-99) , 
NN(
0, 
0, 
-1, -1.47342, 0, -1, 0.286085,-99) , 
3, 0.179643, 0, 0, 0.513235,-99)    );
  // itree = 638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.612267, 0, 1, 0.738324,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618288,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332497,-99) , 
1, -0.85605, 1, 0, 0.388565,-99) , 
NN(
0, 
0, 
-1, 0.185319, 0, -1, 0.0634468,-99) , 
3, -1.46884, 0, 0, 0.321635,-99) , 
3, 0.191234, 0, 0, 0.524003,-99)    );
  // itree = 639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.818673,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.912739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371174,-99) , 
0, 0.0510396, 1, 0, 0.568873,-99) , 
NN(
0, 
0, 
-1, -0.751302, 0, -1, 0.251138,-99) , 
3, 0.0599303, 0, 0, 0.345186,-99) , 
3, 0.661338, 0, 0, 0.484926,-99)    );
  // itree = 640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.116, 1, 1, 0.875196,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331723,-99) , 
0, -0.113727, 1, 0, 0.486362,-99) , 
NN(
0, 
0, 
-1, -1.685, 0, -1, 0.213242,-99) , 
3, -0.592252, 0, 0, 0.373733,-99) , 
3, 0.83952, 0, 0, 0.523448,-99)    );
  // itree = 641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.777383, 1, 1, 0.8411,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213318,-99) , 
0, 0.481313, 1, 0, 0.515353,-99) , 
3, 0.639192, 0, 0, 0.70938,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.184913,-99) , 
3, -0.0447319, 0, 0, 0.479622,-99)    );
  // itree = 642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.833003,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231756,-99) , 
0, 0.190311, 1, 0, 0.473724,-99) , 
NN(
0, 
0, 
-1, -1.52561, 0, -1, 0.169797,-99) , 
3, -0.524691, 0, 0, 0.346109,-99) , 
3, 0.673895, 0, 0, 0.509647,-99)    );
  // itree = 643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42949, 0, 1, 0.845584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437306,-99) , 
0, 0.292382, 1, 0, 0.590038,-99) , 
3, 0.912846, 0, 0, 0.740304,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198721,-99) , 
0, -0.233559, 1, 0, 0.421502,-99) , 
NN(
0, 
0, 
-1, -1.62501, 0, -1, 0.149342,-99) , 
3, -0.761094, 0, 0, 0.290064,-99) , 
3, 0.311026, 0, 0, 0.497116,-99)    );
  // itree = 644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3066, 1, 1, 0.886371,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278079,-99) , 
0, 1.27585, 1, 0, 0.613749,-99) , 
3, 1.41883, 0, 0, 0.695917,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228792,-99) , 
0, -0.381656, 1, 0, 0.40535,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.162593,-99) , 
3, -0.648083, 0, 0, 0.27608,-99) , 
3, 0.179643, 0, 0, 0.485009,-99)    );
  // itree = 645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37881, 1, 1, 0.87213,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460453,-99) , 
0, -0.0346559, 1, 0, 0.556554,-99) , 
3, 1.05688, 0, 0, 0.668222,-99) , 
NN(
0, 
0, 
-1, -1.58146, 0, -1, 0.173166,-99) , 
3, -0.316527, 0, 0, 0.486141,-99)    );
  // itree = 646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.875411,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396811,-99) , 
0, 0.654863, 1, 0, 0.620912,-99) , 
3, 1.11005, 0, 0, 0.749476,-99) , 
NN(
0, 
0, 
-1, -1.13339, 0, -1, 0.272821,-99) , 
3, 0.27076, 0, 0, 0.49296,-99)    );
  // itree = 647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.695352, 0, 1, 0.75789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582693,-99) , 
NN(
0, 
0, 
-1, -1.62542, 0, -1, 0.256995,-99) , 
3, -0.0100424, 0, 0, 0.311201,-99) , 
3, 0.27076, 0, 0, 0.513647,-99)    );
  // itree = 648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.33027, 0, 1, 0.823964,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303773,-99) , 
0, -0.257739, 1, 0, 0.442697,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.191072,-99) , 
3, -0.582745, 0, 0, 0.323391,-99) , 
3, 0.602686, 0, 0, 0.481265,-99)    );
  // itree = 649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.661241, 0, 1, 0.781989,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33756,-99) , 
0, -0.836892, 1, 0, 0.438732,-99) , 
NN(
0, 
0, 
-1, -1.69881, 0, -1, 0.167778,-99) , 
3, -0.614512, 0, 0, 0.313329,-99) , 
3, 0.457088, 0, 0, 0.509431,-99)    );
  // itree = 650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.84725,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351653,-99) , 
0, -0.15388, 1, 0, 0.506836,-99) , 
NN(
0, 
0, 
-1, -1.0799, 0, -1, 0.174742,-99) , 
3, -0.59103, 0, 0, 0.386231,-99) , 
3, 0.974547, 0, 0, 0.497722,-99)    );
  // itree = 651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.917257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472368,-99) , 
0, 1.06964, 1, 0, 0.665507,-99) , 
3, 1.22704, 0, 0, 0.803111,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232364,-99) , 
0, 0.46957, 1, 0, 0.496587,-99) , 
NN(
0, 
0, 
-1, -1.50233, 0, -1, 0.20484,-99) , 
3, -0.524691, 0, 0, 0.37509,-99) , 
3, 0.673895, 0, 0, 0.525259,-99)    );
  // itree = 652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.665774, 0, 1, 0.73146,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.915579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283256,-99) , 
0, -0.808742, 1, 0, 0.464811,-99) , 
NN(
0, 
0, 
-1, -1.67166, 0, -1, 0.135325,-99) , 
3, -0.538654, 0, 0, 0.269045,-99) , 
3, 0.262776, 0, 0, 0.473519,-99)    );
  // itree = 653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63127, 0, 1, 0.822522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350428,-99) , 
0, -0.11411, 1, 0, 0.509175,-99) , 
3, 0.901417, 0, 0, 0.628449,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.128266,-99) , 
3, -0.613987, 0, 0, 0.481586,-99)    );
  // itree = 654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31942, 1, 1, 0.790693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174661,-99) , 
0, 0.497677, 1, 0, 0.489632,-99) , 
3, 0.642792, 0, 0, 0.617015,-99) , 
NN(
0, 
0, 
-1, -1.69387, 0, -1, 0.178353,-99) , 
3, -0.580673, 0, 0, 0.492597,-99)    );
  // itree = 655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.817581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336191,-99) , 
0, 0.280928, 1, 0, 0.530324,-99) , 
3, 0.639192, 0, 0, 0.706909,-99) , 
NN(
0, 
0, 
-1, -0.539588, 0, -1, 0.252504,-99) , 
3, -0.0426953, 0, 0, 0.513913,-99)    );
  // itree = 656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75756, 0, 1, 0.840581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252247,-99) , 
0, 0.672548, 1, 0, 0.557285,-99) , 
3, 0.835863, 0, 0, 0.706074,-99) , 
NN(
0, 
0, 
-1, -1.56671, 0, -1, 0.245483,-99) , 
3, -0.0725463, 0, 0, 0.498307,-99)    );
  // itree = 657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38353, 1, 1, 0.850416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295602,-99) , 
0, 0.453613, 1, 0, 0.554057,-99) , 
3, 0.85384, 0, 0, 0.684198,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.186092,-99) , 
3, -0.302053, 0, 0, 0.494475,-99)    );
  // itree = 658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15445, 0, 1, 0.852491,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28517,-99) , 
0, 0.143304, 1, 0, 0.46804,-99) , 
NN(
0, 
0, 
-1, -1.51657, 0, -1, 0.144664,-99) , 
3, -0.639124, 0, 0, 0.349853,-99) , 
3, 0.800375, 0, 0, 0.489658,-99)    );
  // itree = 659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61531, 0, 1, 0.865419,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248207,-99) , 
0, 0.895962, 1, 0, 0.623219,-99) , 
3, 0.926104, 0, 0, 0.727114,-99) , 
NN(
0, 
0, 
-1, -0.357284, 1, -1, 0.213975,-99) , 
3, -0.206128, 0, 0, 0.520914,-99)    );
  // itree = 660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.873254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301107,-99) , 
0, 0.408308, 1, 0, 0.542996,-99) , 
3, 0.915404, 0, 0, 0.685738,-99) , 
NN(
0, 
0, 
-1, -1.45982, 0, -1, 0.210113,-99) , 
3, -0.216753, 0, 0, 0.493605,-99)    );
  // itree = 661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66501, 0, 1, 0.781626,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353686,-99) , 
0, -0.0789444, 1, 0, 0.523123,-99) , 
3, 0.723661, 0, 0, 0.64981,-99) , 
NN(
0, 
0, 
-1, -1.64422, 0, -1, 0.171254,-99) , 
3, -0.516641, 0, 0, 0.494638,-99)    );
  // itree = 662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3421, 0, 1, 0.855668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211444,-99) , 
0, 0.865651, 1, 0, 0.592136,-99) , 
3, 1.00602, 0, 0, 0.727274,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30949,-99) , 
0, -0.856029, 1, 0, 0.419909,-99) , 
NN(
0, 
0, 
-1, -1.3765, 0, -1, 0.145682,-99) , 
3, -0.647965, 0, 0, 0.276327,-99) , 
3, 0.179643, 0, 0, 0.481274,-99)    );
  // itree = 663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.873745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475659,-99) , 
0, -0.0354634, 1, 0, 0.590515,-99) , 
3, 1.05859, 0, 0, 0.711342,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230578,-99) , 
0, -1.56118, 1, 0, 0.306508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0190461,-99) , 
3, -1.56687, 0, 0, 0.250497,-99) , 
3, -0.0725463, 0, 0, 0.511344,-99)    );
  // itree = 664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.667626, 0, 1, 0.789608,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341611,-99) , 
0, -0.612827, 1, 0, 0.47083,-99) , 
NN(
0, 
0, 
-1, -1.50772, 0, -1, 0.178919,-99) , 
3, -0.557209, 0, 0, 0.304973,-99) , 
3, 0.256412, 0, 0, 0.528163,-99)    );
  // itree = 665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.886185,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351067,-99) , 
0, 1.13238, 1, 0, 0.664376,-99) , 
3, 1.11005, 0, 0, 0.776912,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285748,-99) , 
0, -0.612827, 1, 0, 0.458764,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.201573,-99) , 
3, -0.569108, 0, 0, 0.31951,-99) , 
3, 0.27076, 0, 0, 0.538458,-99)    );
  // itree = 666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832823, 0, 1, 0.777654,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303025,-99) , 
0, -0.0399839, 1, 0, 0.480832,-99) , 
NN(
0, 
0, 
-1, -1.53777, 0, -1, 0.204444,-99) , 
3, -0.381926, 0, 0, 0.322135,-99) , 
3, 0.427177, 0, 0, 0.509202,-99)    );
  // itree = 667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.97896, 0, 1, 0.828272,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210557,-99) , 
0, 0.227133, 1, 0, 0.474457,-99) , 
NN(
0, 
0, 
-1, -1.06267, 0, -1, 0.186173,-99) , 
3, -0.575176, 0, 0, 0.344118,-99) , 
3, 0.609067, 0, 0, 0.516509,-99)    );
  // itree = 668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252667,-99) , 
0, 0.295007, 1, 0, 0.485296,-99) , 
3, 0.628149, 0, 0, 0.65418,-99) , 
NN(
0, 
0, 
-1, -1.55738, 0, -1, 0.193215,-99) , 
3, -0.291428, 0, 0, 0.493189,-99)    );
  // itree = 669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.920289, 1, 1, 0.792737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27035,-99) , 
0, 0.08705, 1, 0, 0.508841,-99) , 
3, 0.487657, 0, 0, 0.678451,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.246565,-99) , 
3, -0.218528, 0, 0, 0.532963,-99)    );
  // itree = 670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593512, 0, 1, 0.768879,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372206,-99) , 
0, -0.609363, 1, 0, 0.505434,-99) , 
NN(
0, 
0, 
-1, -1.36967, 0, -1, 0.198692,-99) , 
3, -0.373865, 0, 0, 0.303299,-99) , 
3, 0.179643, 0, 0, 0.528066,-99)    );
  // itree = 671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.197352, 1, 1, 0.871538,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428921,-99) , 
0, -0.873433, 1, 0, 0.499155,-99) , 
NN(
0, 
0, 
-1, -0.896099, 0, -1, 0.177855,-99) , 
3, -0.363821, 0, 0, 0.348311,-99) , 
3, 0.828289, 0, 0, 0.500973,-99)    );
  // itree = 672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62433, 0, 1, 0.851164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369268,-99) , 
0, 0.77821, 1, 0, 0.626268,-99) , 
3, 1.15583, 0, 0, 0.722913,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303722,-99) , 
0, -0.795814, 1, 0, 0.43143,-99) , 
NN(
0, 
0, 
-1, -0.922099, 0, -1, 0.139777,-99) , 
3, -0.42753, 0, 0, 0.237799,-99) , 
3, 0.131392, 0, 0, 0.459323,-99)    );
  // itree = 673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8507, 1, 1, 0.899674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400677,-99) , 
0, 1.03728, 1, 0, 0.661157,-99) , 
3, 1.17174, 0, 0, 0.772405,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27537,-99) , 
1, 0.265077, 1, 0, 0.421004,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.115352,-99) , 
3, -1.3011, 0, 0, 0.347795,-99) , 
3, 0.34753, 0, 0, 0.545983,-99)    );
  // itree = 674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.240826, 1, 1, 0.864542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280224,-99) , 
0, 1.10833, 1, 0, 0.640384,-99) , 
3, 1.13676, 0, 0, 0.733095,-99) , 
NN(
0, 
0, 
-1, -1.7088, 0, -1, 0.282935,-99) , 
3, -0.216753, 0, 0, 0.548876,-99)    );
  // itree = 675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.01048, 0, 1, 0.839084,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202269,-99) , 
0, 0.196016, 1, 0, 0.464431,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.163619,-99) , 
3, -0.546876, 0, 0, 0.332691,-99) , 
3, 0.644232, 0, 0, 0.511844,-99)    );
  // itree = 676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69764, 1, 1, 0.87649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303149,-99) , 
0, 0.879237, 1, 0, 0.646,-99) , 
3, 1.08354, 0, 0, 0.758997,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233274,-99) , 
0, -0.381656, 1, 0, 0.432241,-99) , 
NN(
0, 
0, 
-1, -1.72267, 0, -1, 0.155503,-99) , 
3, -0.557209, 0, 0, 0.265804,-99) , 
3, 0.268003, 0, 0, 0.487585,-99)    );
  // itree = 677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17174, 0, 1, 0.773067,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250861,-99) , 
0, -0.381656, 1, 0, 0.433908,-99) , 
NN(
0, 
0, 
-1, -1.19447, 0, -1, 0.159008,-99) , 
3, -0.485344, 0, 0, 0.287124,-99) , 
3, 0.34753, 0, 0, 0.512734,-99)    );
  // itree = 678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85529, 0, 1, 0.880925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245,-99) , 
0, 1.2048, 1, 0, 0.596546,-99) , 
3, 1.18544, 0, 0, 0.692624,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.230722,-99) , 
3, -0.218528, 0, 0, 0.519339,-99)    );
  // itree = 679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.825056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274694,-99) , 
0, 0.138796, 1, 0, 0.504526,-99) , 
3, 0.773102, 0, 0, 0.664141,-99) , 
NN(
0, 
0, 
-1, -0.608553, 0, -1, 0.228837,-99) , 
3, -0.115595, 0, 0, 0.474464,-99)    );
  // itree = 680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.743596, 1, 1, 0.840205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336518,-99) , 
0, 0.146168, 1, 0, 0.537497,-99) , 
3, 0.628149, 0, 0, 0.698954,-99) , 
NN(
0, 
0, 
-1, -1.05776, 0, -1, 0.176218,-99) , 
3, -0.291428, 0, 0, 0.507486,-99)    );
  // itree = 681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.802181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161968,-99) , 
0, 0.158188, 1, 0, 0.477054,-99) , 
3, 0.564008, 0, 0, 0.630601,-99) , 
NN(
0, 
0, 
-1, -2.10445, 1, -1, 0.133289,-99) , 
3, -0.680259, 0, 0, 0.481841,-99)    );
  // itree = 682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.856703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302507,-99) , 
0, 0.461096, 1, 0, 0.583553,-99) , 
3, 0.949517, 0, 0, 0.701999,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.208743,-99) , 
3, -0.218528, 0, 0, 0.516708,-99)    );
  // itree = 683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.228024, 1, 1, 0.72181,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22154,-99) , 
0, -1.1904, 1, 0, 0.37282,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.0485225,-99) , 
3, -1.22761, 0, 0, 0.266109,-99) , 
3, -0.000832217, 0, 0, 0.505428,-99)    );
  // itree = 684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48422, 1, 1, 0.799653,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31787,-99) , 
0, 0.138796, 1, 0, 0.515185,-99) , 
3, 0.606621, 0, 0, 0.68519,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169518,-99) , 
0, -0.902977, 1, 0, 0.33211,-99) , 
NN(
0, 
0, 
-1, -0.365486, 1, -1, 0.0745311,-99) , 
3, -1.06796, 0, 0, 0.227943,-99) , 
3, -0.0725463, 0, 0, 0.476446,-99)    );
  // itree = 685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98325, 1, 1, 0.877044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211289,-99) , 
0, 1.17715, 1, 0, 0.600175,-99) , 
3, 1.18232, 0, 0, 0.697373,-99) , 
NN(
0, 
0, 
-1, -0.642143, 0, -1, 0.247862,-99) , 
3, -0.218528, 0, 0, 0.521563,-99)    );
  // itree = 686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.854212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350164,-99) , 
0, -0.0639868, 1, 0, 0.535458,-99) , 
3, 0.637508, 0, 0, 0.721548,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.225976,-99) , 
3, -0.0447319, 0, 0, 0.473765,-99)    );
  // itree = 687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41775, 1, 1, 0.857434,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251171,-99) , 
0, 0.387194, 1, 0, 0.527414,-99) , 
3, 0.667245, 0, 0, 0.716252,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200849,-99) , 
0, -0.897305, 1, 0, 0.369419,-99) , 
NN(
0, 
0, 
-1, -1.59088, 0, -1, 0.113261,-99) , 
3, -0.982866, 0, 0, 0.265013,-99) , 
3, -0.000832217, 0, 0, 0.504313,-99)    );
  // itree = 688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16149, 1, 1, 0.809239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316032,-99) , 
0, 0.0244462, 1, 0, 0.515956,-99) , 
3, 0.563253, 0, 0, 0.696728,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.207204,-99) , 
3, -0.133228, 0, 0, 0.482296,-99)    );
  // itree = 689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.817037,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335845,-99) , 
0, -0.55321, 1, 0, 0.463975,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.164315,-99) , 
3, -0.536792, 0, 0, 0.328478,-99) , 
3, 0.661338, 0, 0, 0.490147,-99)    );
  // itree = 690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44046, 1, 1, 0.867293,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312721,-99) , 
0, 0.499557, 1, 0, 0.565365,-99) , 
3, 0.870114, 0, 0, 0.753838,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218853,-99) , 
0, -0.341503, 1, 0, 0.439113,-99) , 
NN(
0, 
0, 
-1, -1.72323, 0, -1, 0.15497,-99) , 
3, -0.55608, 0, 0, 0.279803,-99) , 
3, 0.256412, 0, 0, 0.49892,-99)    );
  // itree = 691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.891524,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322685,-99) , 
0, 0.883664, 1, 0, 0.615572,-99) , 
3, 1.15201, 0, 0, 0.737079,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222532,-99) , 
0, -0.813434, 1, 0, 0.352791,-99) , 
NN(
0, 
0, 
-1, -1.16327, 0, -1, 0.12383,-99) , 
3, -0.695546, 0, 0, 0.231357,-99) , 
3, 0.125502, 0, 0, 0.47107,-99)    );
  // itree = 692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.38599, 1, 1, 0.878463,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208643,-99) , 
0, 1.18157, 1, 0, 0.556031,-99) , 
3, 1.18232, 0, 0, 0.658117,-99) , 
NN(
0, 
0, 
-1, -0.990191, 0, -1, 0.217864,-99) , 
3, -0.218528, 0, 0, 0.494168,-99)    );
  // itree = 693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.651628, 1, 1, 0.835198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374783,-99) , 
0, 0.57632, 1, 0, 0.582272,-99) , 
3, 0.956202, 0, 0, 0.716583,-99) , 
NN(
0, 
0, 
-1, -1.51897, 0, -1, 0.262235,-99) , 
3, 0.125502, 0, 0, 0.484091,-99)    );
  // itree = 694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.837211,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305375,-99) , 
0, 0.506819, 1, 0, 0.548121,-99) , 
3, 0.861778, 0, 0, 0.690313,-99) , 
NN(
0, 
0, 
-1, -0.548377, 0, -1, 0.266232,-99) , 
3, -0.0447319, 0, 0, 0.497663,-99)    );
  // itree = 695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.83743,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224694,-99) , 
0, 0.231365, 1, 0, 0.504863,-99) , 
3, 0.689879, 0, 0, 0.683787,-99) , 
NN(
0, 
0, 
-1, -0.716991, 0, -1, 0.208656,-99) , 
3, -0.216753, 0, 0, 0.492575,-99)    );
  // itree = 696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07419, 1, 1, 0.845904,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41403,-99) , 
0, 0.292382, 1, 0, 0.584688,-99) , 
3, 0.900389, 0, 0, 0.734723,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656491,-99) , 
NN(
0, 
0, 
-1, -1.07934, 0, -1, 0.24505,-99) , 
3, -0.0100424, 0, 0, 0.306911,-99) , 
3, 0.27076, 0, 0, 0.494497,-99)    );
  // itree = 697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.10114, 0, 1, 0.731275,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156571,-99) , 
0, -0.814121, 1, 0, 0.308156,-99) , 
NN(
0, 
0, 
-1, -1.81319, 0, -1, 0.135623,-99) , 
3, -0.757787, 0, 0, 0.207358,-99) , 
3, -0.0172488, 0, 0, 0.476146,-99)    );
  // itree = 698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13994, 0, 1, 0.831746,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222943,-99) , 
0, 0.453613, 1, 0, 0.510473,-99) , 
NN(
0, 
0, 
-1, -1.46073, 0, -1, 0.239632,-99) , 
3, -0.148894, 0, 0, 0.355588,-99) , 
3, 0.760049, 0, 0, 0.498852,-99)    );
  // itree = 699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.879437,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318631,-99) , 
0, 0.819702, 1, 0, 0.586208,-99) , 
3, 1.18232, 0, 0, 0.682774,-99) , 
NN(
0, 
0, 
-1, -0.993666, 0, -1, 0.220634,-99) , 
3, -0.218528, 0, 0, 0.489173,-99)    );
  // itree = 700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.854277,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234528,-99) , 
0, 0.716184, 1, 0, 0.543702,-99) , 
3, 0.949517, 0, 0, 0.683894,-99) , 
NN(
0, 
0, 
-1, -0.642544, 1, -1, 0.18119,-99) , 
3, -0.218528, 0, 0, 0.493804,-99)    );
  // itree = 701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05669, 0, 1, 0.930952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452771,-99) , 
3, 1.60573, 0, 0, 0.718634,-99) , 
0, 1.36694, 1, 0, 0.810117,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289415,-99) , 
0, 0.0720496, 1, 0, 0.488688,-99) , 
NN(
0, 
0, 
-1, -1.51515, 0, -1, 0.15031,-99) , 
3, -0.833854, 0, 0, 0.362648,-99) , 
3, 0.673895, 0, 0, 0.508861,-99)    );
  // itree = 702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62858, 0, 1, 0.870469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437573,-99) , 
0, -0.0354634, 1, 0, 0.556992,-99) , 
3, 1.14037, 0, 0, 0.665962,-99) , 
NN(
0, 
0, 
-1, -1.71033, 0, -1, 0.190916,-99) , 
3, -0.216753, 0, 0, 0.490007,-99)    );
  // itree = 703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14008, 1, 1, 0.868386,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491225,-99) , 
0, 0.487108, 1, 0, 0.65497,-99) , 
3, 1.0726, 0, 0, 0.765081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286045,-99) , 
0, -0.795814, 1, 0, 0.433198,-99) , 
NN(
0, 
0, 
-1, -1.26031, 0, -1, 0.167225,-99) , 
3, -0.55608, 0, 0, 0.297387,-99) , 
3, 0.256412, 0, 0, 0.501662,-99)    );
  // itree = 704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.518081, 1, 1, 0.833998,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185767,-99) , 
0, 0.409221, 1, 0, 0.539999,-99) , 
3, 0.630536, 0, 0, 0.698005,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.217973,-99) , 
3, -0.291428, 0, 0, 0.5269,-99)    );
  // itree = 705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.19418, 1, 1, 0.852344,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354549,-99) , 
0, -0.500175, 1, 0, 0.477407,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.15754,-99) , 
3, -0.528692, 0, 0, 0.335147,-99) , 
3, 0.673895, 0, 0, 0.494149,-99)    );
  // itree = 706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.631779, 1, 1, 0.907572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3953,-99) , 
3, 1.59432, 0, 0, 0.716917,-99) , 
0, 1.31919, 1, 0, 0.803429,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259595,-99) , 
0, -0.18316, 1, 0, 0.449724,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.151258,-99) , 
3, -0.547498, 0, 0, 0.319226,-99) , 
3, 0.644232, 0, 0, 0.481355,-99)    );
  // itree = 707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60699, 1, 1, 0.85381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252488,-99) , 
0, 0.398957, 1, 0, 0.540849,-99) , 
3, 0.812207, 0, 0, 0.665262,-99) , 
NN(
0, 
0, 
-1, 0.0176327, 1, -1, 0.136097,-99) , 
3, -0.680259, 0, 0, 0.523543,-99)    );
  // itree = 708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.763081, 0, 1, 0.745741,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247619,-99) , 
0, -0.361033, 1, 0, 0.419555,-99) , 
NN(
0, 
0, 
-1, -1.16123, 1, -1, 0.176512,-99) , 
3, -0.202305, 0, 0, 0.252335,-99) , 
3, 0.34753, 0, 0, 0.445316,-99)    );
  // itree = 709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.41103, 1, 1, 0.913773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418972,-99) , 
0, 1.48909, 1, 0, 0.722852,-99) , 
3, 1.39809, 0, 0, 0.81013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372984,-99) , 
0, -0.257739, 1, 0, 0.510452,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.193688,-99) , 
3, -0.535926, 0, 0, 0.371695,-99) , 
3, 0.661338, 0, 0, 0.523937,-99)    );
  // itree = 710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74178, 0, 1, 0.861882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296101,-99) , 
0, 1.03728, 1, 0, 0.596125,-99) , 
3, 1.082, 0, 0, 0.729801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26474,-99) , 
0, -0.568658, 1, 0, 0.39764,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.147886,-99) , 
3, -0.554775, 0, 0, 0.244896,-99) , 
3, 0.268003, 0, 0, 0.465011,-99)    );
  // itree = 711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72494, 1, 1, 0.847601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234957,-99) , 
0, 0.91729, 1, 0, 0.535555,-99) , 
3, 1.09528, 0, 0, 0.678914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261703,-99) , 
0, -1.07517, 1, 0, 0.36336,-99) , 
NN(
0, 
0, 
-1, -2.66404, 1, -1, 0.0977452,-99) , 
3, -1.04827, 0, 0, 0.279741,-99) , 
3, 0.295236, 0, 0, 0.460326,-99)    );
  // itree = 712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8206, 1, 1, 0.885833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461914,-99) , 
0, 0.451203, 1, 0, 0.592872,-99) , 
3, 1.28458, 0, 0, 0.6959,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.217911,-99) , 
3, -0.0725463, 0, 0, 0.468115,-99)    );
  // itree = 713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28558, 1, 1, 0.833408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292498,-99) , 
0, 0.232439, 1, 0, 0.534803,-99) , 
3, 0.85867, 0, 0, 0.673948,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240787,-99) , 
0, -1.86787, 1, 0, 0.333579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0189921,-99) , 
3, -1.55738, 0, 0, 0.25415,-99) , 
3, -0.291428, 0, 0, 0.523837,-99)    );
  // itree = 714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.52219, 1, 1, 0.846607,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210781,-99) , 
0, 0.471542, 1, 0, 0.474923,-99) , 
NN(
0, 
0, 
-1, -1.50233, 0, -1, 0.197337,-99) , 
3, -0.535926, 0, 0, 0.35329,-99) , 
3, 0.661338, 0, 0, 0.517191,-99)    );
  // itree = 715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.88767,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255088,-99) , 
0, 0.895088, 1, 0, 0.60789,-99) , 
3, 1.13388, 0, 0, 0.700504,-99) , 
NN(
0, 
0, 
-1, -1.47002, 0, -1, 0.181244,-99) , 
3, -0.580673, 0, 0, 0.551193,-99)    );
  // itree = 716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.136, 0, 1, 0.822222,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36066,-99) , 
0, -0.0721965, 1, 0, 0.541037,-99) , 
NN(
0, 
0, 
-1, -1.68049, 0, -1, 0.195148,-99) , 
3, -0.451773, 0, 0, 0.374492,-99) , 
3, 0.760049, 0, 0, 0.525084,-99)    );
  // itree = 717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46195, 0, 1, 0.792651,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270972,-99) , 
0, 0.0208352, 1, 0, 0.485567,-99) , 
3, 0.750011, 0, 0, 0.623542,-99) , 
NN(
0, 
0, 
-1, -1.64222, 0, -1, 0.107678,-99) , 
3, -0.730127, 0, 0, 0.481615,-99)    );
  // itree = 718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47523, 0, 1, 0.683214,-99) , 
NN(
0, 
0, 
-1, -0.888858, 0, -1, 0.21253,-99) , 
3, -0.133228, 0, 0, 0.484363,-99)    );
  // itree = 719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.823333,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275381,-99) , 
0, -0.261239, 1, 0, 0.427694,-99) , 
NN(
0, 
0, 
-1, -1.22254, 0, -1, 0.148934,-99) , 
3, -0.754651, 0, 0, 0.329524,-99) , 
3, 0.760049, 0, 0, 0.470321,-99)    );
  // itree = 720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60699, 1, 1, 0.859039,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339549,-99) , 
0, -0.11235, 1, 0, 0.504937,-99) , 
NN(
0, 
0, 
-1, -1.57792, 0, -1, 0.180623,-99) , 
3, -0.667184, 0, 0, 0.374007,-99) , 
3, 0.828289, 0, 0, 0.515224,-99)    );
  // itree = 721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.802527,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317751,-99) , 
0, -0.0509273, 1, 0, 0.511096,-99) , 
3, 0.716715, 0, 0, 0.663881,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.187096,-99) , 
3, -0.218528, 0, 0, 0.46621,-99)    );
  // itree = 722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38922, 0, 1, 0.849627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235144,-99) , 
0, 0.552099, 1, 0, 0.556622,-99) , 
3, 0.858751, 0, 0, 0.682743,-99) , 
NN(
0, 
0, 
-1, -1.50654, 0, -1, 0.169793,-99) , 
3, -0.613509, 0, 0, 0.545955,-99)    );
  // itree = 723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.855044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221327,-99) , 
0, 0.89651, 1, 0, 0.559528,-99) , 
3, 1.08845, 0, 0, 0.66572,-99) , 
NN(
0, 
0, 
-1, -1.58187, 0, -1, 0.198434,-99) , 
3, -0.291428, 0, 0, 0.504105,-99)    );
  // itree = 724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.840212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378413,-99) , 
0, 0.439034, 1, 0, 0.588962,-99) , 
3, 0.903417, 0, 0, 0.735609,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188444,-99) , 
0, -0.381656, 1, 0, 0.411901,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.177456,-99) , 
3, -0.569108, 0, 0, 0.284541,-99) , 
3, 0.27076, 0, 0, 0.489216,-99)    );
  // itree = 725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50803, 0, 1, 0.845704,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.96842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412243,-99) , 
0, 0.224688, 1, 0, 0.647408,-99) , 
3, 0.759671, 0, 0, 0.777879,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22316,-99) , 
0, -0.19081, 1, 0, 0.425775,-99) , 
NN(
0, 
0, 
-1, -1.87096, 0, -1, 0.133656,-99) , 
3, -1.02631, 0, 0, 0.323814,-99) , 
3, 0.34753, 0, 0, 0.514646,-99)    );
  // itree = 726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.03141, 0, 1, 0.809587,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272279,-99) , 
0, 0.218694, 1, 0, 0.522422,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.208195,-99) , 
3, -0.238914, 0, 0, 0.332948,-99) , 
3, 0.661338, 0, 0, 0.476619,-99)    );
  // itree = 727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63534, 0, 1, 0.876964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344319,-99) , 
0, 0.91729, 1, 0, 0.685223,-99) , 
3, 1.14618, 0, 0, 0.77716,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225535,-99) , 
0, -0.314236, 1, 0, 0.394181,-99) , 
NN(
0, 
0, 
-1, -0.175545, 0, -1, 0.079785,-99) , 
3, -1.248, 0, 0, 0.315064,-99) , 
3, 0.34765, 0, 0, 0.523642,-99)    );
  // itree = 728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.887296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359968,-99) , 
0, 0.733856, 1, 0, 0.597996,-99) , 
3, 1.19327, 0, 0, 0.69407,-99) , 
NN(
0, 
0, 
-1, -1.58213, 0, -1, 0.24207,-99) , 
3, -0.127598, 0, 0, 0.53082,-99)    );
  // itree = 729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06533, 1, 1, 0.846055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239261,-99) , 
0, 0.471542, 1, 0, 0.524028,-99) , 
3, 0.734914, 0, 0, 0.664004,-99) , 
NN(
0, 
0, 
-1, -1.65393, 0, -1, 0.143319,-99) , 
3, -0.516641, 0, 0, 0.505768,-99)    );
  // itree = 730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48347, 0, 1, 0.839553,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215826,-99) , 
0, 0.722082, 1, 0, 0.53275,-99) , 
3, 0.949517, 0, 0, 0.667147,-99) , 
NN(
0, 
0, 
-1, -1.76151, 0, -1, 0.221602,-99) , 
3, -0.218528, 0, 0, 0.490324,-99)    );
  // itree = 731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62126, 0, 1, 0.875428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343889,-99) , 
0, 0.901669, 1, 0, 0.655413,-99) , 
3, 1.11005, 0, 0, 0.766181,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272222,-99) , 
0, -0.333179, 1, 0, 0.429092,-99) , 
NN(
0, 
0, 
-1, -1.06357, 0, -1, 0.162219,-99) , 
3, -0.569108, 0, 0, 0.283824,-99) , 
3, 0.27076, 0, 0, 0.505151,-99)    );
  // itree = 732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.798575,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350075,-99) , 
0, 0.097998, 1, 0, 0.569378,-99) , 
3, 0.832586, 0, 0, 0.665959,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.189437,-99) , 
3, -0.707817, 0, 0, 0.542987,-99)    );
  // itree = 733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.49616, 1, 1, 0.924464,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488865,-99) , 
0, 1.4533, 1, 0, 0.746513,-99) , 
3, 1.64861, 0, 0, 0.81335,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218739,-99) , 
0, 0.546846, 1, 0, 0.522646,-99) , 
NN(
0, 
0, 
-1, -0.996703, 1, -1, 0.219821,-99) , 
3, -0.0844691, 0, 0, 0.343591,-99) , 
3, 0.77009, 0, 0, 0.494922,-99)    );
  // itree = 734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.877344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374382,-99) , 
0, 0.865651, 1, 0, 0.661365,-99) , 
3, 1.14829, 0, 0, 0.771666,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257243,-99) , 
1, 0.211156, 1, 0, 0.408119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.00878664,-99) , 
3, -1.51209, 0, 0, 0.341981,-99) , 
3, 0.349483, 0, 0, 0.527526,-99)    );
  // itree = 735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.69392, 0, 1, 0.762537,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207146,-99) , 
0, -0.276765, 1, 0, 0.43198,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.147004,-99) , 
3, -0.582799, 0, 0, 0.285948,-99) , 
3, 0.27076, 0, 0, 0.497526,-99)    );
  // itree = 736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.853255,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296546,-99) , 
0, 0.222455, 1, 0, 0.534385,-99) , 
3, 0.812842, 0, 0, 0.721043,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284794,-99) , 
0, -0.79504, 1, 0, 0.429317,-99) , 
NN(
0, 
0, 
-1, -1.61175, 0, -1, 0.130274,-99) , 
3, -0.641438, 0, 0, 0.261628,-99) , 
3, 0.191234, 0, 0, 0.47985,-99)    );
  // itree = 737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02376, 1, 1, 0.829961,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366261,-99) , 
3, 0.41545, 0, 0, 0.409667,-99) , 
NN(
0, 
0, 
-1, -1.7667, 0, -1, 0.103018,-99) , 
3, -1.12187, 0, 0, 0.328245,-99) , 
3, 0.673895, 0, 0, 0.500822,-99)    );
  // itree = 738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.866682,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465401,-99) , 
0, 0.44647, 1, 0, 0.619576,-99) , 
3, 1.082, 0, 0, 0.745898,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35246,-99) , 
0, -0.877396, 1, 0, 0.439874,-99) , 
NN(
0, 
0, 
-1, -1.68753, 1, -1, 0.146591,-99) , 
3, -0.554775, 0, 0, 0.274496,-99) , 
3, 0.268003, 0, 0, 0.488904,-99)    );
  // itree = 739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54786, 0, 1, 0.807048,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225358,-99) , 
0, 0.263083, 1, 0, 0.539351,-99) , 
3, 0.555454, 0, 0, 0.707074,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.233457,-99) , 
3, -0.133228, 0, 0, 0.510736,-99)    );
  // itree = 740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.902305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465408,-99) , 
0, 1.41094, 1, 0, 0.725672,-99) , 
3, 1.47254, 0, 0, 0.80207,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222678,-99) , 
0, 0.186933, 1, 0, 0.406322,-99) , 
NN(
0, 
0, 
-1, -1.64062, 0, -1, 0.132622,-99) , 
3, -0.734449, 0, 0, 0.310834,-99) , 
3, 0.742135, 0, 0, 0.461121,-99)    );
  // itree = 741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.845041,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311887,-99) , 
0, 0.506819, 1, 0, 0.596103,-99) , 
3, 0.844196, 0, 0, 0.736736,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290149,-99) , 
0, -0.785825, 1, 0, 0.430232,-99) , 
NN(
0, 
0, 
-1, -1.48927, 0, -1, 0.182693,-99) , 
3, -0.512916, 0, 0, 0.274735,-99) , 
3, 0.0352258, 0, 0, 0.511659,-99)    );
  // itree = 742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15113, 0, 1, 0.809282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148946,-99) , 
0, 0.341578, 1, 0, 0.47474,-99) , 
3, 0.576404, 0, 0, 0.670394,-99) , 
NN(
0, 
0, 
-1, -0.57404, 0, -1, 0.251071,-99) , 
3, -0.0843967, 0, 0, 0.49272,-99)    );
  // itree = 743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593214, 0, 1, 0.699268,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292561,-99) , 
0, -0.733329, 1, 0, 0.477614,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.164049,-99) , 
3, -0.646522, 0, 0, 0.306904,-99) , 
3, 0.179643, 0, 0, 0.496827,-99)    );
  // itree = 744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.830698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334708,-99) , 
0, -0.164113, 1, 0, 0.496244,-99) , 
3, 0.616639, 0, 0, 0.682349,-99) , 
NN(
0, 
0, 
-1, -0.817876, 0, -1, 0.169871,-99) , 
3, -0.302053, 0, 0, 0.482502,-99)    );
  // itree = 745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.825067,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197433,-99) , 
0, 0.471542, 1, 0, 0.524093,-99) , 
NN(
0, 
0, 
-1, -1.14884, 0, -1, 0.198422,-99) , 
3, -0.43371, 0, 0, 0.368787,-99) , 
3, 0.742135, 0, 0, 0.505513,-99)    );
  // itree = 746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62149, 1, 1, 0.869812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423409,-99) , 
0, 0.0283268, 1, 0, 0.576355,-99) , 
3, 0.915264, 0, 0, 0.690231,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.187428,-99) , 
3, -0.613987, 0, 0, 0.530547,-99)    );
  // itree = 747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.553635, 0, 1, 0.779183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336799,-99) , 
0, -0.678004, 1, 0, 0.456168,-99) , 
NN(
0, 
0, 
-1, -1.6555, 0, -1, 0.178565,-99) , 
3, -0.476904, 0, 0, 0.307767,-99) , 
3, 0.34753, 0, 0, 0.521296,-99)    );
  // itree = 748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02861, 0, 1, 0.793249,-99) , 
NN(
0, 
0, 
-1, -1.13178, 0, -1, 0.309741,-99) , 
3, 0.661338, 0, 0, 0.475498,-99)    );
  // itree = 749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.8114, 0, 1, 0.841711,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143242,-99) , 
0, 0.571737, 1, 0, 0.468972,-99) , 
NN(
0, 
0, 
-1, -1.53066, 0, -1, 0.185704,-99) , 
3, -0.651518, 0, 0, 0.347087,-99) , 
3, 0.763709, 0, 0, 0.50494,-99)    );
  // itree = 750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.136, 0, 1, 0.847271,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257837,-99) , 
0, 0.138796, 1, 0, 0.46575,-99) , 
NN(
0, 
0, 
-1, -1.69099, 0, -1, 0.176457,-99) , 
3, -0.46783, 0, 0, 0.322881,-99) , 
3, 0.760049, 0, 0, 0.482885,-99)    );
  // itree = 751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50255, 1, 1, 0.818955,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354245,-99) , 
0, 0.0114807, 1, 0, 0.579183,-99) , 
3, 0.789704, 0, 0, 0.697947,-99) , 
NN(
0, 
0, 
-1, -1.39249, 0, -1, 0.212065,-99) , 
3, -0.133228, 0, 0, 0.493842,-99)    );
  // itree = 752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10028, 1, 1, 0.845055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454724,-99) , 
0, 0.076294, 1, 0, 0.578623,-99) , 
3, 0.969023, 0, 0, 0.695935,-99) , 
NN(
0, 
0, 
-1, -0.643618, 0, -1, 0.214037,-99) , 
3, -0.145446, 0, 0, 0.499365,-99)    );
  // itree = 753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38774, 1, 1, 0.826862,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.971123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377332,-99) , 
0, -0.0558779, 1, 0, 0.58994,-99) , 
3, 0.613189, 0, 0, 0.73325,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192529,-99) , 
0, -1.45065, 1, 0, 0.325701,-99) , 
NN(
0, 
0, 
-1, -1.88525, 0, -1, 0.0961585,-99) , 
3, -1.06971, 0, 0, 0.243338,-99) , 
3, -0.0725463, 0, 0, 0.508145,-99)    );
  // itree = 754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6274, 0, 1, 0.865498,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348595,-99) , 
0, 0.91729, 1, 0, 0.630493,-99) , 
3, 1.11586, 0, 0, 0.746203,-99) , 
NN(
0, 
0, 
-1, -1.40771, 0, -1, 0.294684,-99) , 
3, 0.27076, 0, 0, 0.497149,-99)    );
  // itree = 755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.93366, 0, 1, 0.801164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320676,-99) , 
0, -0.8631, 1, 0, 0.416097,-99) , 
NN(
0, 
0, 
-1, -2.55908, 1, -1, 0.0943356,-99) , 
3, -1.01865, 0, 0, 0.312722,-99) , 
3, 0.322617, 0, 0, 0.514978,-99)    );
  // itree = 756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.861092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216723,-99) , 
0, 0.910263, 1, 0, 0.534537,-99) , 
3, 1.12842, 0, 0, 0.633486,-99) , 
NN(
0, 
0, 
-1, -0.569189, 1, -1, 0.184607,-99) , 
3, -0.582913, 0, 0, 0.492023,-99)    );
  // itree = 757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.902083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248858,-99) , 
0, 1.17715, 1, 0, 0.591235,-99) , 
3, 1.19201, 0, 0, 0.698093,-99) , 
NN(
0, 
0, 
-1, -0.736279, 0, -1, 0.20771,-99) , 
3, -0.218528, 0, 0, 0.492456,-99)    );
  // itree = 758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42881, 0, 1, 0.873501,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465849,-99) , 
0, 0.027439, 1, 0, 0.595193,-99) , 
3, 1.08605, 0, 0, 0.716551,-99) , 
NN(
0, 
0, 
-1, -0.556706, 0, -1, 0.234042,-99) , 
3, -0.0447319, 0, 0, 0.503313,-99)    );
  // itree = 759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.5962, 0, 1, 0.824541,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235886,-99) , 
0, -0.0105659, 1, 0, 0.46716,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.158062,-99) , 
3, -0.524691, 0, 0, 0.325825,-99) , 
3, 0.673895, 0, 0, 0.489832,-99)    );
  // itree = 760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58382, 0, 1, 0.804894,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325313,-99) , 
0, -0.766228, 1, 0, 0.41317,-99) , 
NN(
0, 
0, 
-1, -1.64928, 0, -1, 0.134045,-99) , 
3, -0.756656, 0, 0, 0.296276,-99) , 
3, 0.34753, 0, 0, 0.514213,-99)    );
  // itree = 761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.843102,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292151,-99) , 
0, 0.0975803, 1, 0, 0.473525,-99) , 
NN(
0, 
0, 
-1, -1.55278, 0, -1, 0.137756,-99) , 
3, -0.658515, 0, 0, 0.331326,-99) , 
3, 0.79068, 0, 0, 0.479118,-99)    );
  // itree = 762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.19482, 0, 1, 0.825657,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318471,-99) , 
0, -0.368003, 1, 0, 0.470882,-99) , 
NN(
0, 
0, 
-1, -1.61003, 0, -1, 0.138326,-99) , 
3, -0.661336, 0, 0, 0.335535,-99) , 
3, 0.828289, 0, 0, 0.480174,-99)    );
  // itree = 763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.815234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358878,-99) , 
0, -0.305655, 1, 0, 0.50827,-99) , 
NN(
0, 
0, 
-1, -1.50923, 0, -1, 0.219559,-99) , 
3, -0.230339, 0, 0, 0.353025,-99) , 
3, 0.673895, 0, 0, 0.494601,-99)    );
  // itree = 764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.70191, 0, 1, 0.839992,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224042,-99) , 
0, 0.190311, 1, 0, 0.469479,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.176679,-99) , 
3, -0.575176, 0, 0, 0.334442,-99) , 
3, 0.609067, 0, 0, 0.507343,-99)    );
  // itree = 765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.07151, 1, 1, 0.893417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429468,-99) , 
0, 1.29535, 1, 0, 0.688685,-99) , 
3, 1.2744, 0, 0, 0.790119,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217971,-99) , 
0, 0.156982, 1, 0, 0.419285,-99) , 
NN(
0, 
0, 
-1, -1.25573, 0, -1, 0.140964,-99) , 
3, -0.606867, 0, 0, 0.281607,-99) , 
3, 0.466687, 0, 0, 0.473467,-99)    );
  // itree = 766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30776, 0, 1, 0.86185,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378501,-99) , 
0, 0.453613, 1, 0, 0.572305,-99) , 
3, 0.952846, 0, 0, 0.70473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181463,-99) , 
0, -1.45611, 1, 0, 0.305379,-99) , 
NN(
0, 
0, 
-1, -1.54094, 0, -1, 0.0690604,-99) , 
3, -1.24788, 0, 0, 0.21711,-99) , 
3, -0.218528, 0, 0, 0.504863,-99)    );
  // itree = 767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.808435,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180966,-99) , 
0, 0.257576, 1, 0, 0.432908,-99) , 
NN(
0, 
0, 
-1, -2.65242, 1, -1, 0.133035,-99) , 
3, -1.06726, 0, 0, 0.347287,-99) , 
3, 0.625942, 0, 0, 0.502725,-99)    );
  // itree = 768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.833257, 1, 1, 0.808201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330372,-99) , 
0, -0.266769, 1, 0, 0.495878,-99) , 
3, 0.483912, 0, 0, 0.687533,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.192403,-99) , 
3, -0.218528, 0, 0, 0.483802,-99)    );
  // itree = 769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.830129,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414497,-99) , 
0, -0.609452, 1, 0, 0.499285,-99) , 
3, 0.99488, 0, 0, 0.603386,-99) , 
NN(
0, 
0, 
-1, -1.48861, 0, -1, 0.152646,-99) , 
3, -0.783748, 0, 0, 0.482582,-99)    );
  // itree = 770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13505, 0, 1, 0.849392,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274481,-99) , 
0, 0.143304, 1, 0, 0.460496,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.148097,-99) , 
3, -0.679167, 0, 0, 0.34008,-99) , 
3, 0.778124, 0, 0, 0.494042,-99)    );
  // itree = 771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.891128,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330364,-99) , 
0, 1.07553, 1, 0, 0.619173,-99) , 
3, 1.21449, 0, 0, 0.71261,-99) , 
NN(
0, 
0, 
-1, -1.58999, 0, -1, 0.243234,-99) , 
3, -0.115595, 0, 0, 0.521451,-99)    );
  // itree = 772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65952, 0, 1, 0.815682,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318545,-99) , 
0, 0.0112647, 1, 0, 0.5309,-99) , 
3, 0.716715, 0, 0, 0.679081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267124,-99) , 
0, -1.27313, 1, 0, 0.365104,-99) , 
NN(
0, 
0, 
-1, 0.182851, 0, -1, 0.0914177,-99) , 
3, -1.24633, 0, 0, 0.258574,-99) , 
3, -0.218528, 0, 0, 0.521987,-99)    );
  // itree = 773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.51523, 1, 1, 0.892961,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369139,-99) , 
0, 1.3556, 1, 0, 0.628735,-99) , 
3, 1.44408, 0, 0, 0.693592,-99) , 
NN(
0, 
0, 
-1, -0.589261, 0, -1, 0.211831,-99) , 
3, -0.102499, 0, 0, 0.468249,-99)    );
  // itree = 774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.25324, 0, 1, 0.823081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327164,-99) , 
0, -1.02747, 1, 0, 0.439524,-99) , 
NN(
0, 
0, 
-1, -1.5356, 0, -1, 0.143548,-99) , 
3, -0.637608, 0, 0, 0.303109,-99) , 
3, 0.440796, 0, 0, 0.533921,-99)    );
  // itree = 775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47254, 0, 1, 0.825223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331166,-99) , 
0, -0.0639868, 1, 0, 0.505479,-99) , 
3, 0.746137, 0, 0, 0.681522,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.21765,-99) , 
3, -0.145446, 0, 0, 0.491863,-99)    );
  // itree = 776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.587707, 1, 1, 0.816976,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344213,-99) , 
0, -0.0926919, 1, 0, 0.57518,-99) , 
3, 0.487657, 0, 0, 0.732845,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.234451,-99) , 
3, -0.218528, 0, 0, 0.547997,-99)    );
  // itree = 777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40102, 0, 1, 0.882184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270796,-99) , 
0, 0.868468, 1, 0, 0.562303,-99) , 
3, 1.07466, 0, 0, 0.682992,-99) , 
NN(
0, 
0, 
-1, -0.759635, 0, -1, 0.277606,-99) , 
3, -0.266382, 0, 0, 0.531053,-99)    );
  // itree = 778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.866894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22612,-99) , 
0, 1.01958, 1, 0, 0.608198,-99) , 
3, 1.08605, 0, 0, 0.709381,-99) , 
NN(
0, 
0, 
-1, -0.539588, 0, -1, 0.266824,-99) , 
3, -0.0426953, 0, 0, 0.503165,-99)    );
  // itree = 779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.831977,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267743,-99) , 
0, -0.0428066, 1, 0, 0.489699,-99) , 
NN(
0, 
0, 
-1, -0.659652, 1, -1, 0.161831,-99) , 
3, -0.57899, 0, 0, 0.334525,-99) , 
3, 0.602686, 0, 0, 0.496612,-99)    );
  // itree = 780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.608397, 0, 1, 0.763186,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559235,-99) , 
NN(
0, 
0, 
-1, -0.615446, 0, -1, 0.181684,-99) , 
3, -0.0882295, 0, 0, 0.239614,-99) , 
3, 0.191234, 0, 0, 0.497914,-99)    );
  // itree = 781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.45499, 0, 1, 0.759019,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266913,-99) , 
1, 0.112696, 1, 0, 0.41367,-99) , 
NN(
0, 
0, 
-1, -1.50812, 0, -1, 0.133936,-99) , 
3, -0.844436, 0, 0, 0.288248,-99) , 
3, 0.240623, 0, 0, 0.501313,-99)    );
  // itree = 782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59541, 0, 1, 0.851231,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277029,-99) , 
0, 1.00098, 1, 0, 0.554383,-99) , 
3, 1.11244, 0, 0, 0.650105,-99) , 
NN(
0, 
0, 
-1, -1.7195, 0, -1, 0.15036,-99) , 
3, -0.575499, 0, 0, 0.499255,-99)    );
  // itree = 783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.61497, 0, 1, 0.84064,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321048,-99) , 
0, -0.140048, 1, 0, 0.486836,-99) , 
NN(
0, 
0, 
-1, -1.64928, 0, -1, 0.198866,-99) , 
3, -0.756906, 0, 0, 0.384974,-99) , 
3, 0.712472, 0, 0, 0.535738,-99)    );
  // itree = 784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.45063, 0, 1, 0.856528,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166448,-99) , 
0, 0.475416, 1, 0, 0.519185,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.226197,-99) , 
3, -0.406105, 0, 0, 0.38181,-99) , 
3, 0.741723, 0, 0, 0.53461,-99)    );
  // itree = 785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.667626, 0, 1, 0.759288,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353244,-99) , 
0, -0.654567, 1, 0, 0.451865,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.180605,-99) , 
3, -0.557209, 0, 0, 0.307012,-99) , 
3, 0.256412, 0, 0, 0.512123,-99)    );
  // itree = 786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31125, 0, 1, 0.849202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419042,-99) , 
0, -0.20991, 1, 0, 0.559021,-99) , 
3, 0.735411, 0, 0, 0.704538,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204561,-99) , 
0, -1.32386, 1, 0, 0.332844,-99) , 
NN(
0, 
0, 
-1, -1.65914, 0, -1, 0.0589339,-99) , 
3, -1.24832, 0, 0, 0.228655,-99) , 
3, -0.218528, 0, 0, 0.529668,-99)    );
  // itree = 787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11116, 0, 1, 0.822198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273061,-99) , 
0, 0.341578, 1, 0, 0.529276,-99) , 
3, 0.747201, 0, 0, 0.679636,-99) , 
NN(
0, 
0, 
-1, -1.11015, 1, -1, 0.221622,-99) , 
3, -0.145446, 0, 0, 0.483554,-99)    );
  // itree = 788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.805988,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34562,-99) , 
0, 0.126437, 1, 0, 0.53703,-99) , 
3, 0.716715, 0, 0, 0.680942,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.233368,-99) , 
3, -0.218528, 0, 0, 0.501588,-99)    );
  // itree = 789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.0555, 0, 1, 0.721487,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252882,-99) , 
0, -0.714765, 1, 0, 0.408024,-99) , 
NN(
0, 
0, 
-1, -1.74341, 0, -1, 0.180763,-99) , 
3, -0.512916, 0, 0, 0.273346,-99) , 
3, 0.0352258, 0, 0, 0.519952,-99)    );
  // itree = 790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.0589, 1, 1, 0.893478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348103,-99) , 
0, 1.40292, 1, 0, 0.652337,-99) , 
3, 1.48826, 0, 0, 0.731177,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276627,-99) , 
0, -0.560073, 1, 0, 0.435885,-99) , 
NN(
0, 
0, 
-1, -1.71128, 0, -1, 0.16316,-99) , 
3, -0.549382, 0, 0, 0.284696,-99) , 
3, 0.268003, 0, 0, 0.489533,-99)    );
  // itree = 791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.37795, 0, 1, 0.813345,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307018,-99) , 
0, -0.0319407, 1, 0, 0.507679,-99) , 
NN(
0, 
0, 
-1, -1.5759, 0, -1, 0.237996,-99) , 
3, -0.374099, 0, 0, 0.38625,-99) , 
3, 0.828289, 0, 0, 0.510696,-99)    );
  // itree = 792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11938, 0, 1, 0.808569,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208012,-99) , 
0, 0.123422, 1, 0, 0.469134,-99) , 
3, 0.566131, 0, 0, 0.636919,-99) , 
NN(
0, 
0, 
-1, -1.55336, 0, -1, 0.158498,-99) , 
3, -0.663377, 0, 0, 0.500677,-99)    );
  // itree = 793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.45174, 1, 1, 0.828789,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243585,-99) , 
0, 0.0208352, 1, 0, 0.437596,-99) , 
NN(
0, 
0, 
-1, -1.70026, 0, -1, 0.158505,-99) , 
3, -0.760607, 0, 0, 0.34351,-99) , 
3, 0.760049, 0, 0, 0.483459,-99)    );
  // itree = 794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.777844, 1, 1, 0.828795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319444,-99) , 
0, 0.252479, 1, 0, 0.517139,-99) , 
3, 0.612756, 0, 0, 0.709371,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136728,-99) , 
0, -0.86692, 1, 0, 0.341548,-99) , 
NN(
0, 
0, 
-1, -1.69007, 0, -1, 0.0811664,-99) , 
3, -1.06971, 0, 0, 0.237056,-99) , 
3, -0.0725463, 0, 0, 0.500398,-99)    );
  // itree = 795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.877105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290398,-99) , 
0, 0.927932, 1, 0, 0.57258,-99) , 
3, 1.12191, 0, 0, 0.680719,-99) , 
NN(
0, 
0, 
-1, -0.72973, 0, -1, 0.23113,-99) , 
3, -0.231227, 0, 0, 0.508318,-99)    );
  // itree = 796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.885508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293521,-99) , 
0, 0.788183, 1, 0, 0.598125,-99) , 
3, 1.11005, 0, 0, 0.739735,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244746,-99) , 
0, -0.341503, 1, 0, 0.432169,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.16244,-99) , 
3, -0.569108, 0, 0, 0.285078,-99) , 
3, 0.27076, 0, 0, 0.505971,-99)    );
  // itree = 797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40765, 0, 1, 0.838258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337471,-99) , 
0, 0.454461, 1, 0, 0.582218,-99) , 
3, 0.861778, 0, 0, 0.719196,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.228098,-99) , 
3, -0.0447319, 0, 0, 0.499489,-99)    );
  // itree = 798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.97267, 0, 1, 0.802475,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217761,-99) , 
0, 0.227133, 1, 0, 0.491474,-99) , 
3, 0.58231, 0, 0, 0.644891,-99) , 
NN(
0, 
0, 
-1, -0.301417, 1, -1, 0.151921,-99) , 
3, -0.707817, 0, 0, 0.505473,-99)    );
  // itree = 799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.769998, 1, 1, 0.817313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270602,-99) , 
0, 0.213204, 1, 0, 0.520814,-99) , 
3, 0.551802, 0, 0, 0.699321,-99) , 
NN(
0, 
0, 
-1, -0.605391, 0, -1, 0.213183,-99) , 
3, -0.117632, 0, 0, 0.494593,-99)    );
  // itree = 800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27903, 1, 1, 0.768157,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250849,-99) , 
0, 0.0477724, 1, 0, 0.469772,-99) , 
3, 0.601626, 0, 0, 0.610311,-99) , 
NN(
0, 
0, 
-1, -1.51587, 0, -1, 0.145191,-99) , 
3, -0.623168, 0, 0, 0.482831,-99)    );
  // itree = 801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.760729, 0, 1, 0.792139,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389621,-99) , 
3, 0.0923395, 0, 0, 0.525298,-99) , 
NN(
0, 
0, 
-1, -1.3069, 0, -1, 0.189926,-99) , 
2, -0.320036, 0, 0, 0.294636,-99) , 
3, 0.34753, 0, 0, 0.506557,-99)    );
  // itree = 802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.901978,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349689,-99) , 
0, 1.13238, 1, 0, 0.623155,-99) , 
3, 1.28444, 0, 0, 0.732862,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347507,-99) , 
0, -0.843998, 1, 0, 0.457809,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.193609,-99) , 
3, -0.55608, 0, 0, 0.300122,-99) , 
3, 0.256412, 0, 0, 0.505637,-99)    );
  // itree = 803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.606045, 0, 1, 0.765056,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288655,-99) , 
0, -0.477384, 1, 0, 0.470585,-99) , 
NN(
0, 
0, 
-1, -1.12941, 0, -1, 0.174414,-99) , 
3, -0.367006, 0, 0, 0.288768,-99) , 
3, 0.191234, 0, 0, 0.529017,-99)    );
  // itree = 804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36232, 0, 1, 0.785805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402108,-99) , 
0, -0.975276, 1, 0, 0.461943,-99) , 
3, 0.576468, 0, 0, 0.61561,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.0993445,-99) , 
3, -0.707817, 0, 0, 0.475045,-99)    );
  // itree = 805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14008, 1, 1, 0.893076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34983,-99) , 
0, 0.831261, 1, 0, 0.582304,-99) , 
3, 1.0878, 0, 0, 0.696145,-99) , 
NN(
0, 
0, 
-1, -1.05418, 0, -1, 0.210292,-99) , 
3, -0.291428, 0, 0, 0.526468,-99)    );
  // itree = 806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.37343, 1, 1, 0.892213,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371999,-99) , 
0, 0.83871, 1, 0, 0.639133,-99) , 
3, 1.11291, 0, 0, 0.774339,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224705,-99) , 
0, -0.150485, 1, 0, 0.454854,-99) , 
NN(
0, 
0, 
-1, -1.50162, 1, -1, 0.159823,-99) , 
3, -0.574972, 0, 0, 0.2918,-99) , 
3, 0.27076, 0, 0, 0.515421,-99)    );
  // itree = 807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.868649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393659,-99) , 
0, 0.924863, 1, 0, 0.63855,-99) , 
3, 1.12078, 0, 0, 0.747589,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331564,-99) , 
0, -0.843998, 1, 0, 0.433182,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.19852,-99) , 
3, -0.569108, 0, 0, 0.298864,-99) , 
3, 0.27076, 0, 0, 0.504149,-99)    );
  // itree = 808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.848522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403457,-99) , 
0, -0.44685, 1, 0, 0.522005,-99) , 
3, 0.844923, 0, 0, 0.650314,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.14073,-99) , 
3, -0.707817, 0, 0, 0.51735,-99)    );
  // itree = 809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.847121,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393671,-99) , 
0, 0.142002, 1, 0, 0.548783,-99) , 
3, 1.0887, 0, 0, 0.644942,-99) , 
NN(
0, 
0, 
-1, -1.65101, 0, -1, 0.160881,-99) , 
3, -0.707817, 0, 0, 0.515305,-99)    );
  // itree = 810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45508, 0, 1, 0.889971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350698,-99) , 
0, 0.985893, 1, 0, 0.665081,-99) , 
3, 1.11291, 0, 0, 0.769948,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559347,-99) , 
NN(
0, 
0, 
-1, -1.09035, 0, -1, 0.229874,-99) , 
3, -0.0239999, 0, 0, 0.278331,-99) , 
3, 0.27076, 0, 0, 0.4932,-99)    );
  // itree = 811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.608397, 0, 1, 0.741436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239578,-99) , 
0, -0.950363, 1, 0, 0.385704,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.114572,-99) , 
3, -0.917922, 0, 0, 0.275138,-99) , 
3, 0.191234, 0, 0, 0.512174,-99)    );
  // itree = 812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.866251,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417041,-99) , 
0, 0.835519, 1, 0, 0.670405,-99) , 
3, 1.11463, 0, 0, 0.770567,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291358,-99) , 
0, -0.246492, 1, 0, 0.469148,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.184092,-99) , 
3, -0.569108, 0, 0, 0.308363,-99) , 
3, 0.27076, 0, 0, 0.518131,-99)    );
  // itree = 813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.82932,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344132,-99) , 
0, -0.316077, 1, 0, 0.49558,-99) , 
NN(
0, 
0, 
-1, -1.50365, 0, -1, 0.181404,-99) , 
3, -0.535926, 0, 0, 0.359698,-99) , 
3, 0.661338, 0, 0, 0.509557,-99)    );
  // itree = 814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.806451,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352104,-99) , 
0, 0.138796, 1, 0, 0.573614,-99) , 
3, 0.644531, 0, 0, 0.70745,-99) , 
NN(
0, 
0, 
-1, -1.50946, 0, -1, 0.272603,-99) , 
3, -0.0295996, 0, 0, 0.519489,-99)    );
  // itree = 815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.331519, 1, 1, 0.739733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361337,-99) , 
3, -0.0613276, 0, 0, 0.674099,-99) , 
NN(
0, 
0, 
-1, -0.702474, 1, -1, 0.205835,-99) , 
3, -0.291428, 0, 0, 0.494439,-99)    );
  // itree = 816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2684, 1, 1, 0.837469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201907,-99) , 
0, 0.46105, 1, 0, 0.540579,-99) , 
3, 0.701193, 0, 0, 0.706712,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.238454,-99) , 
3, -0.206128, 0, 0, 0.507668,-99)    );
  // itree = 817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.866692,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471267,-99) , 
0, 0.262911, 1, 0, 0.634604,-99) , 
3, 1.08882, 0, 0, 0.733887,-99) , 
NN(
0, 
0, 
-1, -0.555787, 0, -1, 0.210674,-99) , 
3, -0.0447319, 0, 0, 0.493899,-99)    );
  // itree = 818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22634, 0, 1, 0.817333,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307653,-99) , 
0, -0.316077, 1, 0, 0.463852,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.183475,-99) , 
3, -0.531196, 0, 0, 0.341016,-99) , 
3, 0.673895, 0, 0, 0.498348,-99)    );
  // itree = 819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58127, 0, 1, 0.887995,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40777,-99) , 
0, 0.498384, 1, 0, 0.601018,-99) , 
3, 1.0878, 0, 0, 0.717959,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17474,-99) , 
0, -1.33908, 1, 0, 0.302661,-99) , 
NN(
0, 
0, 
-1, -0.319547, 0, -1, 0.0520103,-99) , 
3, -1.30677, 0, 0, 0.213961,-99) , 
3, -0.291428, 0, 0, 0.524279,-99)    );
  // itree = 820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11223, 0, 1, 0.873387,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320002,-99) , 
0, -0.0721965, 1, 0, 0.510067,-99) , 
NN(
0, 
0, 
-1, -1.15783, 0, -1, 0.184778,-99) , 
3, -0.446363, 0, 0, 0.366151,-99) , 
3, 0.742135, 0, 0, 0.523779,-99)    );
  // itree = 821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.835379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229576,-99) , 
0, 0.431079, 1, 0, 0.486106,-99) , 
NN(
0, 
0, 
-1, -1.18778, 0, -1, 0.181286,-99) , 
3, -0.451773, 0, 0, 0.340039,-99) , 
3, 0.760049, 0, 0, 0.501324,-99)    );
  // itree = 822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.074099, 1, 1, 0.8942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431494,-99) , 
3, 0.963805, 0, 0, 0.719354,-99) , 
0, 0.564027, 1, 0, 0.774795,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267239,-99) , 
0, -0.98863, 1, 0, 0.411086,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.133928,-99) , 
3, -0.700219, 0, 0, 0.25491,-99) , 
3, 0.131392, 0, 0, 0.527943,-99)    );
  // itree = 823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66653, 0, 1, 0.841057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331596,-99) , 
0, 0.143304, 1, 0, 0.512375,-99) , 
3, 0.784609, 0, 0, 0.64657,-99) , 
NN(
0, 
0, 
-1, -1.61729, 0, -1, 0.10892,-99) , 
3, -0.703077, 0, 0, 0.507419,-99)    );
  // itree = 824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41775, 1, 1, 0.821954,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244228,-99) , 
0, 0.227133, 1, 0, 0.504696,-99) , 
NN(
0, 
0, 
-1, -1.50233, 0, -1, 0.15059,-99) , 
3, -0.524691, 0, 0, 0.33748,-99) , 
3, 0.673895, 0, 0, 0.494496,-99)    );
  // itree = 825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62451, 0, 1, 0.89059,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415878,-99) , 
0, 0.702199, 1, 0, 0.650659,-99) , 
3, 1.11586, 0, 0, 0.779743,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318231,-99) , 
0, -0.752686, 1, 0, 0.436134,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.181824,-99) , 
3, -0.569108, 0, 0, 0.301346,-99) , 
3, 0.27076, 0, 0, 0.519693,-99)    );
  // itree = 826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.69468, 0, 1, 0.84805,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306456,-99) , 
0, -0.0721965, 1, 0, 0.435438,-99) , 
NN(
0, 
0, 
-1, -1.64606, 0, -1, 0.202486,-99) , 
3, -0.458101, 0, 0, 0.326249,-99) , 
3, 0.760049, 0, 0, 0.490712,-99)    );
  // itree = 827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.87368,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367564,-99) , 
0, 0.446638, 1, 0, 0.561057,-99) , 
3, 1.18544, 0, 0, 0.659902,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.203976,-99) , 
3, -0.218528, 0, 0, 0.468279,-99)    );
  // itree = 828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.837333,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260625,-99) , 
0, -0.0639868, 1, 0, 0.524665,-99) , 
NN(
0, 
0, 
-1, -1.52978, 0, -1, 0.23703,-99) , 
3, -0.253639, 0, 0, 0.364029,-99) , 
3, 0.661338, 0, 0, 0.502839,-99)    );
  // itree = 829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81577, 1, 1, 0.856023,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413971,-99) , 
0, 0.291557, 1, 0, 0.577221,-99) , 
3, 1.10602, 0, 0, 0.686008,-99) , 
NN(
0, 
0, 
-1, -1.49879, 0, -1, 0.238339,-99) , 
3, -0.0172488, 0, 0, 0.488176,-99)    );
  // itree = 830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.759671, 0, 1, 0.793563,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318411,-99) , 
0, -0.705822, 1, 0, 0.446231,-99) , 
NN(
0, 
0, 
-1, -1.19726, 0, -1, 0.167359,-99) , 
3, -0.751608, 0, 0, 0.31869,-99) , 
3, 0.34753, 0, 0, 0.512731,-99)    );
  // itree = 831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.859858,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232459,-99) , 
0, 1.07644, 1, 0, 0.580789,-99) , 
3, 1.09528, 0, 0, 0.708249,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315961,-99) , 
0, -0.708635, 1, 0, 0.453632,-99) , 
NN(
0, 
0, 
-1, -1.20363, 0, -1, 0.166597,-99) , 
3, -0.518836, 0, 0, 0.28758,-99) , 
3, 0.295236, 0, 0, 0.489858,-99)    );
  // itree = 832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.163597, 1, 1, 0.957686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429107,-99) , 
3, 1.17938, 0, 0, 0.739658,-99) , 
0, 1.00591, 1, 0, 0.807908,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224789,-99) , 
0, 0.0477724, 1, 0, 0.43426,-99) , 
NN(
0, 
0, 
-1, -0.390874, 1, -1, 0.149666,-99) , 
3, -0.578463, 0, 0, 0.30978,-99) , 
3, 0.609067, 0, 0, 0.466753,-99)    );
  // itree = 833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08804, 0, 1, 0.804645,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351816,-99) , 
0, -0.328864, 1, 0, 0.497962,-99) , 
3, 0.487657, 0, 0, 0.690343,-99) , 
NN(
0, 
0, 
-1, -1.24788, 0, -1, 0.179164,-99) , 
3, -0.218528, 0, 0, 0.485803,-99)    );
  // itree = 834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1009, 1, 1, 0.810917,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239602,-99) , 
0, -0.0748989, 1, 0, 0.478838,-99) , 
3, 0.601626, 0, 0, 0.646311,-99) , 
NN(
0, 
0, 
-1, -1.52124, 0, -1, 0.133635,-99) , 
3, -0.623168, 0, 0, 0.515692,-99)    );
  // itree = 835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.858945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339244,-99) , 
0, 0.232439, 1, 0, 0.53262,-99) , 
3, 0.949517, 0, 0, 0.670211,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.207671,-99) , 
3, -0.218528, 0, 0, 0.482741,-99)    );
  // itree = 836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36331, 0, 1, 0.849331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444074,-99) , 
0, 0.242272, 1, 0, 0.586772,-99) , 
3, 1.01311, 0, 0, 0.695309,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.217211,-99) , 
3, -0.133228, 0, 0, 0.494752,-99)    );
  // itree = 837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.63138, 0, 1, 0.848872,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24311,-99) , 
0, 0.190311, 1, 0, 0.505095,-99) , 
NN(
0, 
0, 
-1, -1.63313, 0, -1, 0.206784,-99) , 
3, -0.445426, 0, 0, 0.365206,-99) , 
3, 0.729578, 0, 0, 0.524493,-99)    );
  // itree = 838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75578, 1, 1, 0.898598,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451963,-99) , 
0, 1.3169, 1, 0, 0.710219,-99) , 
3, 1.32272, 0, 0, 0.811712,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3816,-99) , 
0, -0.836892, 1, 0, 0.460418,-99) , 
NN(
0, 
0, 
-1, -1.44402, 0, -1, 0.166697,-99) , 
3, -0.793406, 0, 0, 0.344104,-99) , 
3, 0.625942, 0, 0, 0.51634,-99)    );
  // itree = 839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.885017,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452885,-99) , 
0, 0.186734, 1, 0, 0.596525,-99) , 
3, 1.18232, 0, 0, 0.700286,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164404,-99) , 
0, -1.36121, 1, 0, 0.285843,-99) , 
NN(
0, 
0, 
-1, -2.82701, 1, -1, 0.0631562,-99) , 
3, -1.24832, 0, 0, 0.213752,-99) , 
3, -0.218528, 0, 0, 0.492635,-99)    );
  // itree = 840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.785944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239083,-99) , 
0, 0.112808, 1, 0, 0.483509,-99) , 
3, 0.645973, 0, 0, 0.627734,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.154366,-99) , 
3, -0.613987, 0, 0, 0.468593,-99)    );
  // itree = 841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.699401, 1, 1, 0.819069,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342832,-99) , 
0, 0.0148787, 1, 0, 0.493044,-99) , 
3, 0.616639, 0, 0, 0.669524,-99) , 
NN(
0, 
0, 
-1, -1.0696, 0, -1, 0.179863,-99) , 
3, -0.302053, 0, 0, 0.513226,-99)    );
  // itree = 842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.64129, 0, 1, 0.808288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270358,-99) , 
0, 0.277937, 1, 0, 0.508564,-99) , 
3, 0.74018, 0, 0, 0.663621,-99) , 
NN(
0, 
0, 
-1, -0.629408, 0, -1, 0.228821,-99) , 
3, -0.142731, 0, 0, 0.474868,-99)    );
  // itree = 843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.65211, 0, 1, 0.891791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419457,-99) , 
3, 1.19271, 0, 0, 0.685862,-99) , 
0, 0.777339, 1, 0, 0.754325,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196178,-99) , 
1, 0.353213, 1, 0, 0.382853,-99) , 
NN(
0, 
0, 
-1, -1.42822, 0, -1, 0.135128,-99) , 
3, -0.754564, 0, 0, 0.270652,-99) , 
3, 0.34753, 0, 0, 0.465449,-99)    );
  // itree = 844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13381, 0, 1, 0.8039,-99) , 
NN(
0, 
0, 
-1, -1.05843, 0, -1, 0.336299,-99) , 
3, 0.760049, 0, 0, 0.483179,-99)    );
  // itree = 845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.23162, 0, 1, 0.823775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437068,-99) , 
0, 0.36396, 1, 0, 0.571097,-99) , 
3, 0.880637, 0, 0, 0.727518,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29023,-99) , 
0, -0.806337, 1, 0, 0.411407,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.164967,-99) , 
3, -0.556859, 0, 0, 0.282429,-99) , 
3, 0.256412, 0, 0, 0.485724,-99)    );
  // itree = 846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.69274, 0, 1, 0.827786,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38595,-99) , 
0, -0.431084, 1, 0, 0.495979,-99) , 
NN(
0, 
0, 
-1, -1.18839, 0, -1, 0.205965,-99) , 
3, -0.45279, 0, 0, 0.357735,-99) , 
3, 0.760049, 0, 0, 0.500819,-99)    );
  // itree = 847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.320905, 0, 1, 0.916237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499784,-99) , 
3, 1.5537, 0, 0, 0.732924,-99) , 
0, 1.42386, 1, 0, 0.823043,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198665,-99) , 
0, 0.190311, 1, 0, 0.445734,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.19352,-99) , 
3, -0.575176, 0, 0, 0.331714,-99) , 
3, 0.609067, 0, 0, 0.498784,-99)    );
  // itree = 848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.856172,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228757,-99) , 
0, 1.16858, 1, 0, 0.572137,-99) , 
3, 1.13988, 0, 0, 0.673582,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146115,-99) , 
0, -1.36109, 1, 0, 0.283312,-99) , 
NN(
0, 
0, 
-1, -0.374992, 1, -1, 0.0757324,-99) , 
3, -1.21376, 0, 0, 0.201183,-99) , 
3, -0.216753, 0, 0, 0.486033,-99)    );
  // itree = 849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00457, 1, 1, 0.830773,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3144,-99) , 
0, 0.151248, 1, 0, 0.476923,-99) , 
NN(
0, 
0, 
-1, -1.23491, 1, -1, 0.20691,-99) , 
3, -0.303277, 0, 0, 0.342525,-99) , 
3, 0.876835, 0, 0, 0.472335,-99)    );
  // itree = 850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.828631,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230464,-99) , 
0, 0.395321, 1, 0, 0.489699,-99) , 
NN(
0, 
0, 
-1, -1.50233, 0, -1, 0.197382,-99) , 
3, -0.536792, 0, 0, 0.365523,-99) , 
3, 0.673895, 0, 0, 0.520139,-99)    );
  // itree = 851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.70535, 0, 1, 0.835905,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386305,-99) , 
0, -0.105786, 1, 0, 0.534673,-99) , 
3, 0.814928, 0, 0, 0.650457,-99) , 
NN(
0, 
0, 
-1, -1.5895, 0, -1, 0.127568,-99) , 
3, -0.680259, 0, 0, 0.499706,-99)    );
  // itree = 852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.81913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349013,-99) , 
0, 0.0208352, 1, 0, 0.552516,-99) , 
3, 0.665844, 0, 0, 0.67516,-99) , 
NN(
0, 
0, 
-1, -1.53458, 0, -1, 0.16611,-99) , 
3, -0.613987, 0, 0, 0.515259,-99)    );
  // itree = 853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.882778,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43884,-99) , 
0, 0.702199, 1, 0, 0.63521,-99) , 
3, 1.17174, 0, 0, 0.75557,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251749,-99) , 
1, 0.284447, 1, 0, 0.433911,-99) , 
NN(
0, 
0, 
-1, -1.42822, 0, -1, 0.160201,-99) , 
3, -0.751702, 0, 0, 0.310653,-99) , 
3, 0.34753, 0, 0, 0.510633,-99)    );
  // itree = 854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.258765, 1, 1, 0.915768,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447641,-99) , 
3, 1.17978, 0, 0, 0.703259,-99) , 
0, 0.967184, 1, 0, 0.790651,-99) , 
NN(
0, 
0, 
-1, -1.58122, 0, -1, 0.310617,-99) , 
3, 0.34753, 0, 0, 0.507338,-99)    );
  // itree = 855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.862214,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242593,-99) , 
0, 0.843106, 1, 0, 0.565705,-99) , 
3, 0.970169, 0, 0, 0.687,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506358,-99) , 
NN(
0, 
0, 
-1, -0.995775, 0, -1, 0.171759,-99) , 
1, -0.702474, 1, 0, 0.239914,-99) , 
3, -0.218528, 0, 0, 0.521637,-99)    );
  // itree = 856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2121, 0, 1, 0.82855,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261881,-99) , 
0, 0.158188, 1, 0, 0.49094,-99) , 
NN(
0, 
0, 
-1, -1.52561, 0, -1, 0.162375,-99) , 
3, -0.542018, 0, 0, 0.354103,-99) , 
3, 0.661338, 0, 0, 0.506861,-99)    );
  // itree = 857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11817, 0, 1, 0.796936,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3663,-99) , 
0, -0.920776, 1, 0, 0.441456,-99) , 
NN(
0, 
0, 
-1, -1.87096, 0, -1, 0.0972142,-99) , 
3, -1.03269, 0, 0, 0.350612,-99) , 
3, 0.742135, 0, 0, 0.489271,-99)    );
  // itree = 858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.854308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361502,-99) , 
0, 0.506819, 1, 0, 0.63967,-99) , 
3, 0.864726, 0, 0, 0.741009,-99) , 
NN(
0, 
0, 
-1, -0.547392, 0, -1, 0.294642,-99) , 
3, -0.0447319, 0, 0, 0.540694,-99)    );
  // itree = 859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71083, 0, 1, 0.887591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230452,-99) , 
0, 1.16858, 1, 0, 0.571248,-99) , 
3, 1.20314, 0, 0, 0.671259,-99) , 
NN(
0, 
0, 
-1, -0.734051, 0, -1, 0.201333,-99) , 
3, -0.218528, 0, 0, 0.483958,-99)    );
  // itree = 860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.04141, 1, 1, 0.903526,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370417,-99) , 
0, 1.00365, 1, 0, 0.63624,-99) , 
3, 1.17269, 0, 0, 0.762314,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225642,-99) , 
0, -0.111037, 1, 0, 0.473415,-99) , 
NN(
0, 
0, 
-1, -0.947941, 0, -1, 0.170998,-99) , 
3, -0.476904, 0, 0, 0.299423,-99) , 
3, 0.34753, 0, 0, 0.492031,-99)    );
  // itree = 861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.809659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224578,-99) , 
0, 0.36783, 1, 0, 0.488779,-99) , 
3, 0.616639, 0, 0, 0.662076,-99) , 
NN(
0, 
0, 
-1, -1.57306, 0, -1, 0.205679,-99) , 
3, -0.302053, 0, 0, 0.48744,-99)    );
  // itree = 862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.890019,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498009,-99) , 
0, 0.398125, 1, 0, 0.643251,-99) , 
3, 1.11005, 0, 0, 0.763113,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346478,-99) , 
0, -1.30268, 1, 0, 0.402696,-99) , 
NN(
0, 
0, 
-1, -0.428579, 1, -1, 0.0913095,-99) , 
3, -1.13339, 0, 0, 0.310774,-99) , 
3, 0.27076, 0, 0, 0.517753,-99)    );
  // itree = 863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.596385, 0, 1, 0.724194,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385643,-99) , 
2, -0.552894, 1, 0, 0.476792,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.206293,-99) , 
3, -0.646522, 0, 0, 0.332806,-99) , 
3, 0.179643, 0, 0, 0.521972,-99)    );
  // itree = 864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63798, 0, 1, 0.845801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310468,-99) , 
0, 1.07644, 1, 0, 0.604635,-99) , 
3, 1.13091, 0, 0, 0.712692,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301512,-99) , 
0, -0.752686, 1, 0, 0.440747,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.170463,-99) , 
3, -0.574972, 0, 0, 0.296483,-99) , 
3, 0.27076, 0, 0, 0.485505,-99)    );
  // itree = 865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.68196, 1, 1, 0.876671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49284,-99) , 
0, -0.394018, 1, 0, 0.59249,-99) , 
3, 0.926104, 0, 0, 0.725265,-99) , 
NN(
0, 
0, 
-1, -0.705832, 0, -1, 0.233293,-99) , 
3, -0.206128, 0, 0, 0.50986,-99)    );
  // itree = 866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19326, 0, 1, 0.845405,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308414,-99) , 
0, -0.0699225, 1, 0, 0.550428,-99) , 
3, 0.610069, 0, 0, 0.732872,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216303,-99) , 
0, -1.51633, 1, 0, 0.306979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0391677,-99) , 
3, -1.56671, 0, 0, 0.250763,-99) , 
3, -0.0725463, 0, 0, 0.538319,-99)    );
  // itree = 867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.84064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223073,-99) , 
0, 0.788609, 1, 0, 0.533098,-99) , 
3, 0.885075, 0, 0, 0.652936,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.145602,-99) , 
3, -0.580673, 0, 0, 0.507952,-99)    );
  // itree = 868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.981698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473319,-99) , 
3, 1.17978, 0, 0, 0.713937,-99) , 
0, 0.564027, 1, 0, 0.770584,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215135,-99) , 
0, 0.055134, 1, 0, 0.44008,-99) , 
NN(
0, 
0, 
-1, -1.18712, 0, -1, 0.171799,-99) , 
3, -0.481272, 0, 0, 0.300329,-99) , 
3, 0.34753, 0, 0, 0.506612,-99)    );
  // itree = 869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.815029,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228433,-99) , 
0, 0.190311, 1, 0, 0.458917,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.184197,-99) , 
3, -0.535926, 0, 0, 0.332929,-99) , 
3, 0.661338, 0, 0, 0.490316,-99)    );
  // itree = 870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19408, 0, 1, 0.837542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187819,-99) , 
0, 0.372958, 1, 0, 0.512177,-99) , 
3, 0.85305, 0, 0, 0.655947,-99) , 
NN(
0, 
0, 
-1, -1.005, 0, -1, 0.183254,-99) , 
3, -0.266382, 0, 0, 0.484133,-99)    );
  // itree = 871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42719, 1, 1, 0.844644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289807,-99) , 
0, 0.488, 1, 0, 0.569068,-99) , 
3, 0.783514, 0, 0, 0.739424,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23185,-99) , 
0, -0.944667, 1, 0, 0.381977,-99) , 
NN(
0, 
0, 
-1, -1.61545, 0, -1, 0.0919179,-99) , 
3, -0.945134, 0, 0, 0.25151,-99) , 
3, 0.163853, 0, 0, 0.498212,-99)    );
  // itree = 872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.833379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318182,-99) , 
1, 0.0944828, 1, 0, 0.43214,-99) , 
NN(
0, 
0, 
-1, -2.00217, 0, -1, 0.0828135,-99) , 
3, -1.13741, 0, 0, 0.34389,-99) , 
3, 0.661338, 0, 0, 0.51187,-99)    );
  // itree = 873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.876271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422536,-99) , 
0, 0.954172, 1, 0, 0.648625,-99) , 
3, 1.11005, 0, 0, 0.762958,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.913609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305929,-99) , 
0, -0.678004, 1, 0, 0.482837,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.244398,-99) , 
3, -0.289575, 0, 0, 0.328803,-99) , 
3, 0.27076, 0, 0, 0.522171,-99)    );
  // itree = 874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5832, 0, 1, 0.863887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430959,-99) , 
1, -0.154425, 1, 0, 0.552269,-99) , 
3, 1.09053, 0, 0, 0.664908,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.225392,-99) , 
3, -0.291428, 0, 0, 0.516927,-99)    );
  // itree = 875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.612047, 0, 1, 0.73432,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312137,-99) , 
0, -0.526005, 1, 0, 0.463074,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.200061,-99) , 
3, -0.329032, 0, 0, 0.286667,-99) , 
3, 0.208162, 0, 0, 0.494675,-99)    );
  // itree = 876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37341, 0, 1, 0.80894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387612,-99) , 
0, -0.587882, 1, 0, 0.492759,-99) , 
3, 0.628887, 0, 0, 0.653233,-99) , 
NN(
0, 
0, 
-1, 0.474388, 1, -1, 0.200762,-99) , 
3, -0.291428, 0, 0, 0.486045,-99)    );
  // itree = 877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63534, 0, 1, 0.88034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447661,-99) , 
0, 0.954172, 1, 0, 0.689911,-99) , 
3, 1.14975, 0, 0, 0.785058,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262363,-99) , 
1, 0.301724, 1, 0, 0.417604,-99) , 
NN(
0, 
0, 
-1, -2.00677, 0, -1, 0.156544,-99) , 
3, -0.979856, 0, 0, 0.325443,-99) , 
3, 0.349483, 0, 0, 0.533509,-99)    );
  // itree = 878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.873229,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393415,-99) , 
0, 0.883664, 1, 0, 0.623393,-99) , 
3, 1.14829, 0, 0, 0.748113,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246066,-99) , 
1, 0.0122296, 1, 0, 0.361826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0368624,-99) , 
3, -1.51131, 0, 0, 0.306655,-99) , 
3, 0.349483, 0, 0, 0.505807,-99)    );
  // itree = 879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11421, 1, 1, 0.838487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260754,-99) , 
0, 0.454461, 1, 0, 0.548776,-99) , 
3, 0.780056, 0, 0, 0.694819,-99) , 
NN(
0, 
0, 
-1, -0.605234, 0, -1, 0.197859,-99) , 
3, -0.117632, 0, 0, 0.465622,-99)    );
  // itree = 880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.894281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459763,-99) , 
0, -0.192531, 1, 0, 0.56006,-99) , 
3, 1.18232, 0, 0, 0.680467,-99) , 
NN(
0, 
0, 
-1, -1.5132, 0, -1, 0.225074,-99) , 
3, -0.218528, 0, 0, 0.507963,-99)    );
  // itree = 881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26839, 1, 1, 0.800896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459015,-99) , 
3, 0.553635, 0, 0, 0.740944,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234818,-99) , 
0, -0.150485, 1, 0, 0.481887,-99) , 
NN(
0, 
0, 
-1, -1.66415, 0, -1, 0.204446,-99) , 
3, -0.477004, 0, 0, 0.332666,-99) , 
3, 0.34753, 0, 0, 0.497109,-99)    );
  // itree = 882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.354725, 0, 1, 0.952977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.908098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4751,-99) , 
3, 1.60935, 0, 0, 0.742398,-99) , 
0, 1.48607, 1, 0, 0.844616,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267064,-99) , 
0, 0.272813, 1, 0, 0.458462,-99) , 
NN(
0, 
0, 
-1, -1.7667, 0, -1, 0.102738,-99) , 
3, -1.12761, 0, 0, 0.363762,-99) , 
3, 0.673895, 0, 0, 0.529552,-99)    );
  // itree = 883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.11537, 1, 1, 0.856969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416383,-99) , 
0, 0.498384, 1, 0, 0.638456,-99) , 
3, 1.06845, 0, 0, 0.736783,-99) , 
NN(
0, 
0, 
-1, -0.483217, 0, -1, 0.265105,-99) , 
3, 0.0559666, 0, 0, 0.504317,-99)    );
  // itree = 884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04325, 0, 1, 0.834864,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198942,-99) , 
0, 0.155544, 1, 0, 0.477539,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.175863,-99) , 
3, -0.524691, 0, 0, 0.330037,-99) , 
3, 0.673895, 0, 0, 0.491336,-99)    );
  // itree = 885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63158, 1, 1, 0.884915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166316,-99) , 
0, 0.927932, 1, 0, 0.535423,-99) , 
3, 1.11733, 0, 0, 0.652402,-99) , 
NN(
0, 
0, 
-1, -0.424961, 1, -1, 0.211833,-99) , 
3, -0.231227, 0, 0, 0.473497,-99)    );
  // itree = 886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.38071, 1, 1, 0.890036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2497,-99) , 
0, 0.927932, 1, 0, 0.535359,-99) , 
3, 1.15167, 0, 0, 0.652169,-99) , 
NN(
0, 
0, 
-1, -0.954029, 0, -1, 0.231138,-99) , 
3, -0.206128, 0, 0, 0.47223,-99)    );
  // itree = 887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6193, 0, 1, 0.872356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439001,-99) , 
0, 0.683618, 1, 0, 0.636283,-99) , 
3, 1.11005, 0, 0, 0.761762,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54025,-99) , 
NN(
0, 
0, 
-1, 0.0176327, 1, -1, 0.222653,-99) , 
3, -0.0100424, 0, 0, 0.28329,-99) , 
3, 0.27076, 0, 0, 0.487673,-99)    );
  // itree = 888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39621, 1, 1, 0.795075,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23902,-99) , 
0, 0.155544, 1, 0, 0.502819,-99) , 
3, 0.595143, 0, 0, 0.645793,-99) , 
NN(
0, 
0, 
-1, -0.206791, 1, -1, 0.12089,-99) , 
3, -0.680259, 0, 0, 0.510492,-99)    );
  // itree = 889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.85941,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2916,-99) , 
0, 1.07485, 1, 0, 0.642856,-99) , 
3, 1.12237, 0, 0, 0.745983,-99) , 
NN(
0, 
0, 
-1, -1.55933, 0, -1, 0.33966,-99) , 
3, 0.311026, 0, 0, 0.523939,-99)    );
  // itree = 890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.606045, 0, 1, 0.756925,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346068,-99) , 
0, -0.708013, 1, 0, 0.473699,-99) , 
NN(
0, 
0, 
-1, -1.12587, 0, -1, 0.186083,-99) , 
3, -0.363853, 0, 0, 0.291869,-99) , 
3, 0.191234, 0, 0, 0.517738,-99)    );
  // itree = 891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.843292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290048,-99) , 
0, 0.284185, 1, 0, 0.518204,-99) , 
3, 0.832607, 0, 0, 0.68716,-99) , 
NN(
0, 
0, 
-1, -1.56687, 0, -1, 0.217075,-99) , 
3, -0.0725463, 0, 0, 0.47305,-99)    );
  // itree = 892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11223, 0, 1, 0.852346,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240315,-99) , 
0, 0.418264, 1, 0, 0.520893,-99) , 
NN(
0, 
0, 
-1, -1.86845, 0, -1, 0.221095,-99) , 
3, -0.44611, 0, 0, 0.373544,-99) , 
3, 0.742135, 0, 0, 0.543085,-99)    );
  // itree = 893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46509, 0, 1, 0.853377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330772,-99) , 
0, 0.924863, 1, 0, 0.624132,-99) , 
3, 1.13438, 0, 0, 0.738882,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260707,-99) , 
0, -0.712533, 1, 0, 0.399424,-99) , 
NN(
0, 
0, 
-1, -1.81878, 0, -1, 0.140916,-99) , 
3, -0.727382, 0, 0, 0.276184,-99) , 
3, 0.336059, 0, 0, 0.478333,-99)    );
  // itree = 894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.862732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352496,-99) , 
0, 0.376975, 1, 0, 0.544778,-99) , 
3, 1.09079, 0, 0, 0.645289,-99) , 
NN(
0, 
0, 
-1, -1.55995, 0, -1, 0.135109,-99) , 
3, -0.623168, 0, 0, 0.505213,-99)    );
  // itree = 895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.859805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328631,-99) , 
0, 0.579407, 1, 0, 0.591184,-99) , 
3, 0.96671, 0, 0, 0.758075,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335832,-99) , 
0, -0.814411, 1, 0, 0.435412,-99) , 
NN(
0, 
0, 
-1, -1.19726, 0, -1, 0.151859,-99) , 
3, -0.751608, 0, 0, 0.308201,-99) , 
3, 0.34753, 0, 0, 0.511698,-99)    );
  // itree = 896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.854088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441068,-99) , 
0, 0.0304304, 1, 0, 0.57707,-99) , 
3, 0.861778, 0, 0, 0.71463,-99) , 
NN(
0, 
0, 
-1, -1.03428, 0, -1, 0.22587,-99) , 
3, -0.0447319, 0, 0, 0.484848,-99)    );
  // itree = 897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93919, 1, 1, 0.873799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353823,-99) , 
0, 1.09595, 1, 0, 0.662782,-99) , 
3, 1.17174, 0, 0, 0.761891,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28304,-99) , 
0, -0.568658, 1, 0, 0.441278,-99) , 
NN(
0, 
0, 
-1, -0.362058, 1, -1, 0.212127,-99) , 
3, -0.476904, 0, 0, 0.321225,-99) , 
3, 0.34753, 0, 0, 0.513669,-99)    );
  // itree = 898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.12055, 0, 1, 0.835769,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345425,-99) , 
0, -0.431084, 1, 0, 0.476308,-99) , 
NN(
0, 
0, 
-1, -1.15783, 0, -1, 0.164034,-99) , 
3, -0.445426, 0, 0, 0.320915,-99) , 
3, 0.742135, 0, 0, 0.469075,-99)    );
  // itree = 899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54599, 0, 1, 0.8092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227852,-99) , 
0, 0.0208352, 1, 0, 0.460021,-99) , 
3, 0.692182, 0, 0, 0.627589,-99) , 
NN(
0, 
0, 
-1, -0.642544, 1, -1, 0.163651,-99) , 
3, -0.430822, 0, 0, 0.47665,-99)    );
  // itree = 900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.869371,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32036,-99) , 
0, 0.57979, 1, 0, 0.586108,-99) , 
3, 0.887633, 0, 0, 0.755983,-99) , 
NN(
0, 
0, 
-1, -0.247978, 0, -1, 0.309478,-99) , 
3, 0.287809, 0, 0, 0.520783,-99)    );
  // itree = 901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13633, 0, 1, 0.836336,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482216,-99) , 
0, -0.394018, 1, 0, 0.575703,-99) , 
3, 0.95337, 0, 0, 0.692283,-99) , 
NN(
0, 
0, 
-1, -1.50556, 0, -1, 0.211779,-99) , 
3, -0.218528, 0, 0, 0.498341,-99)    );
  // itree = 902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.32202, 1, 1, 0.879482,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307533,-99) , 
0, 0.838689, 1, 0, 0.557283,-99) , 
3, 1.18232, 0, 0, 0.662239,-99) , 
NN(
0, 
0, 
-1, -1.2441, 0, -1, 0.16533,-99) , 
3, -0.218528, 0, 0, 0.461249,-99)    );
  // itree = 903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.835007,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.917544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404494,-99) , 
0, -0.0558779, 1, 0, 0.587066,-99) , 
3, 0.794416, 0, 0, 0.723743,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.249992,-99) , 
3, -0.133228, 0, 0, 0.528898,-99)    );
  // itree = 904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.857686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318787,-99) , 
0, 0.506819, 1, 0, 0.538363,-99) , 
3, 1.11901, 0, 0, 0.656701,-99) , 
NN(
0, 
0, 
-1, -1.71764, 0, -1, 0.227986,-99) , 
3, -0.231227, 0, 0, 0.490584,-99)    );
  // itree = 905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48719, 1, 1, 0.864565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333202,-99) , 
0, 0.877527, 1, 0, 0.647238,-99) , 
3, 1.0482, 0, 0, 0.773398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589723,-99) , 
NN(
0, 
0, 
-1, -1.16396, 0, -1, 0.243618,-99) , 
1, -0.829273, 1, 0, 0.306903,-99) , 
3, 0.440796, 0, 0, 0.494411,-99)    );
  // itree = 906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25435, 1, 1, 0.889035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394312,-99) , 
0, 1.02904, 1, 0, 0.638788,-99) , 
3, 1.47811, 0, 0, 0.714682,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219786,-99) , 
0, -0.413435, 1, 0, 0.381816,-99) , 
NN(
0, 
0, 
-1, -1.22456, 0, -1, 0.12944,-99) , 
3, -0.771773, 0, 0, 0.261632,-99) , 
3, 0.287809, 0, 0, 0.45457,-99)    );
  // itree = 907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.820105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29225,-99) , 
0, 0.0804575, 1, 0, 0.492544,-99) , 
3, 0.609259, 0, 0, 0.703192,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.235365,-99) , 
3, -0.0725463, 0, 0, 0.508778,-99)    );
  // itree = 908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.881436,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286194,-99) , 
0, 0.597337, 1, 0, 0.536999,-99) , 
3, 0.983297, 0, 0, 0.657437,-99) , 
NN(
0, 
0, 
-1, -1.7021, 0, -1, 0.154762,-99) , 
3, -0.783748, 0, 0, 0.545479,-99)    );
  // itree = 909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08069, 1, 1, 0.821048,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269552,-99) , 
0, 0.402597, 1, 0, 0.545682,-99) , 
3, 0.628887, 0, 0, 0.68361,-99) , 
NN(
0, 
0, 
-1, -1.05776, 0, -1, 0.193018,-99) , 
3, -0.291428, 0, 0, 0.501057,-99)    );
  // itree = 910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.817765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416459,-99) , 
0, -0.328864, 1, 0, 0.557174,-99) , 
3, 0.628149, 0, 0, 0.703324,-99) , 
NN(
0, 
0, 
-1, -1.05776, 0, -1, 0.202087,-99) , 
3, -0.291428, 0, 0, 0.525967,-99)    );
  // itree = 911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.68196, 1, 1, 0.916777,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494918,-99) , 
0, 1.22233, 1, 0, 0.73238,-99) , 
3, 1.29137, 0, 0, 0.832175,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311408,-99) , 
0, -0.111037, 1, 0, 0.462567,-99) , 
NN(
0, 
0, 
-1, -1.64062, 0, -1, 0.170898,-99) , 
3, -0.738784, 0, 0, 0.353338,-99) , 
3, 0.742135, 0, 0, 0.514625,-99)    );
  // itree = 912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5905, 0, 1, 0.81408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233107,-99) , 
0, 0.544361, 1, 0, 0.582941,-99) , 
3, 0.864726, 0, 0, 0.708574,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305932,-99) , 
0, -1.19597, 1, 0, 0.411559,-99) , 
NN(
0, 
0, 
-1, -0.444283, 1, -1, 0.0884306,-99) , 
3, -1.03448, 0, 0, 0.283673,-99) , 
3, -0.0447319, 0, 0, 0.518225,-99)    );
  // itree = 913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04252, 0, 1, 0.814355,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282242,-99) , 
0, -0.0153026, 1, 0, 0.491187,-99) , 
NN(
0, 
0, 
-1, -1.02164, 0, -1, 0.151486,-99) , 
3, -0.531196, 0, 0, 0.339102,-99) , 
3, 0.673895, 0, 0, 0.50074,-99)    );
  // itree = 914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09423, 0, 1, 0.839774,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264684,-99) , 
0, 0.19697, 1, 0, 0.495901,-99) , 
3, 0.714298, 0, 0, 0.660707,-99) , 
NN(
0, 
0, 
-1, -2.1763, 1, -1, 0.10812,-99) , 
3, -0.547237, 0, 0, 0.480449,-99)    );
  // itree = 915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.845907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297759,-99) , 
0, 0.408308, 1, 0, 0.550626,-99) , 
3, 0.849125, 0, 0, 0.688826,-99) , 
NN(
0, 
0, 
-1, -0.684744, 1, -1, 0.232258,-99) , 
3, -0.302053, 0, 0, 0.523043,-99)    );
  // itree = 916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.852757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.970802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360509,-99) , 
0, -0.147815, 1, 0, 0.530841,-99) , 
3, 0.835097, 0, 0, 0.692724,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.242905,-99) , 
3, -0.0725463, 0, 0, 0.504638,-99)    );
  // itree = 917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.852085,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.179441,-99) , 
0, 0.497677, 1, 0, 0.509103,-99) , 
3, 0.652735, 0, 0, 0.675707,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.156932,-99) , 
3, -0.613987, 0, 0, 0.512072,-99)    );
  // itree = 918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69109, 1, 1, 0.849107,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301515,-99) , 
0, 1.12935, 1, 0, 0.587687,-99) , 
3, 1.18232, 0, 0, 0.675507,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.219202,-99) , 
3, -0.218528, 0, 0, 0.497279,-99)    );
  // itree = 919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.807805,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269914,-99) , 
0, 0.0208352, 1, 0, 0.50073,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.162879,-99) , 
3, -0.535926, 0, 0, 0.346132,-99) , 
3, 0.661338, 0, 0, 0.498821,-99)    );
  // itree = 920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66074, 0, 1, 0.841995,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329558,-99) , 
0, 0.40789, 1, 0, 0.540416,-99) , 
3, 0.949517, 0, 0, 0.684486,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.215044,-99) , 
3, -0.218528, 0, 0, 0.499023,-99)    );
  // itree = 921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.817954,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171728,-99) , 
0, 0.423428, 1, 0, 0.443539,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.18426,-99) , 
3, -0.531196, 0, 0, 0.333771,-99) , 
3, 0.673895, 0, 0, 0.501496,-99)    );
  // itree = 922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.874522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315809,-99) , 
0, 0.907943, 1, 0, 0.606133,-99) , 
3, 1.082, 0, 0, 0.745588,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151442,-99) , 
0, -0.150485, 1, 0, 0.412887,-99) , 
NN(
0, 
0, 
-1, -1.48321, 0, -1, 0.141818,-99) , 
3, -0.825152, 0, 0, 0.290231,-99) , 
3, 0.268003, 0, 0, 0.490679,-99)    );
  // itree = 923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44801, 0, 1, 0.845503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39478,-99) , 
0, 0.0112647, 1, 0, 0.546317,-99) , 
3, 0.932403, 0, 0, 0.687593,-99) , 
NN(
0, 
0, 
-1, -0.964601, 0, -1, 0.212741,-99) , 
3, -0.206128, 0, 0, 0.504856,-99)    );
  // itree = 924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.857321,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351858,-99) , 
0, 0.481313, 1, 0, 0.586215,-99) , 
3, 0.91488, 0, 0, 0.715349,-99) , 
NN(
0, 
0, 
-1, -1.70743, 0, -1, 0.245281,-99) , 
3, -0.216753, 0, 0, 0.523938,-99)    );
  // itree = 925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43044, 0, 1, 0.84611,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426388,-99) , 
0, 0.076294, 1, 0, 0.555829,-99) , 
3, 0.911551, 0, 0, 0.697537,-99) , 
NN(
0, 
0, 
-1, -0.718728, 0, -1, 0.240887,-99) , 
3, -0.216753, 0, 0, 0.518102,-99)    );
  // itree = 926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.62686, 0, 1, 0.841005,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369937,-99) , 
0, -0.816289, 1, 0, 0.445467,-99) , 
NN(
0, 
0, 
-1, -1.12165, 0, -1, 0.159836,-99) , 
3, -0.682866, 0, 0, 0.318499,-99) , 
3, 0.748104, 0, 0, 0.493925,-99)    );
  // itree = 927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.8444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214304,-99) , 
0, 0.879237, 1, 0, 0.578587,-99) , 
3, 1.00602, 0, 0, 0.704098,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260026,-99) , 
0, -0.671136, 1, 0, 0.459151,-99) , 
NN(
0, 
0, 
-1, -1.61175, 0, -1, 0.171302,-99) , 
3, -0.647965, 0, 0, 0.294871,-99) , 
3, 0.179643, 0, 0, 0.491998,-99)    );
  // itree = 928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.850855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325766,-99) , 
0, 0.291557, 1, 0, 0.533575,-99) , 
3, 0.926722, 0, 0, 0.677078,-99) , 
NN(
0, 
0, 
-1, -0.706455, 0, -1, 0.203635,-99) , 
3, -0.206128, 0, 0, 0.487503,-99)    );
  // itree = 929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48555, 1, 1, 0.903683,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485516,-99) , 
0, 0.498384, 1, 0, 0.632689,-99) , 
3, 1.20116, 0, 0, 0.734778,-99) , 
NN(
0, 
0, 
-1, -1.10528, 0, -1, 0.23213,-99) , 
3, -0.128257, 0, 0, 0.522126,-99)    );
  // itree = 930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0681, 0, 1, 0.936899,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475593,-99) , 
3, 1.6009, 0, 0, 0.740771,-99) , 
0, 1.60699, 1, 0, 0.834477,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177248,-99) , 
0, 0.46957, 1, 0, 0.49229,-99) , 
NN(
0, 
0, 
-1, -1.55644, 0, -1, 0.171047,-99) , 
3, -0.675449, 0, 0, 0.364193,-99) , 
3, 0.778124, 0, 0, 0.513624,-99)    );
  // itree = 931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.613003, 0, 1, 0.774583,-99) , 
NN(
0, 
0, 
-1, -0.369108, 0, -1, 0.253731,-99) , 
3, 0.191234, 0, 0, 0.500281,-99)    );
  // itree = 932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.903375,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280825,-99) , 
0, 1.09595, 1, 0, 0.606187,-99) , 
3, 1.21333, 0, 0, 0.7271,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247655,-99) , 
0, -0.612827, 1, 0, 0.408274,-99) , 
NN(
0, 
0, 
-1, -1.3765, 0, -1, 0.146227,-99) , 
3, -0.646522, 0, 0, 0.278978,-99) , 
3, 0.179643, 0, 0, 0.50341,-99)    );
  // itree = 933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69109, 1, 1, 0.883788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311709,-99) , 
0, 0.969329, 1, 0, 0.606409,-99) , 
3, 1.19191, 0, 0, 0.69336,-99) , 
NN(
0, 
0, 
-1, -0.643618, 0, -1, 0.237882,-99) , 
3, -0.145446, 0, 0, 0.501126,-99)    );
  // itree = 934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.881281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293004,-99) , 
0, 0.803606, 1, 0, 0.616649,-99) , 
3, 1.00591, 0, 0, 0.749756,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352124,-99) , 
0, -0.511616, 1, 0, 0.425741,-99) , 
NN(
0, 
0, 
-1, -1.52797, 0, -1, 0.15019,-99) , 
3, -0.602387, 0, 0, 0.257442,-99) , 
3, 0.202272, 0, 0, 0.484282,-99)    );
  // itree = 935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5614, 0, 1, 0.819597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285898,-99) , 
0, 0.213204, 1, 0, 0.526519,-99) , 
3, 0.628149, 0, 0, 0.687164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12697,-99) , 
0, -1.36121, 1, 0, 0.277751,-99) , 
NN(
0, 
0, 
-1, -1.60598, 0, -1, 0.0927235,-99) , 
3, -1.31014, 0, 0, 0.209648,-99) , 
3, -0.291428, 0, 0, 0.513006,-99)    );
  // itree = 936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6841, 0, 1, 0.856295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424658,-99) , 
0, 0.0287117, 1, 0, 0.553355,-99) , 
3, 1.18232, 0, 0, 0.656296,-99) , 
NN(
0, 
0, 
-1, -1.50743, 0, -1, 0.212092,-99) , 
3, -0.218528, 0, 0, 0.50322,-99)    );
  // itree = 937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50562, 1, 1, 0.909115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494404,-99) , 
0, 1.32338, 1, 0, 0.702998,-99) , 
3, 1.58382, 0, 0, 0.759266,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210857,-99) , 
3, -0.760118, 0, 0, 0.41392,-99) , 
NN(
0, 
0, 
-1, -0.700229, 1, -1, 0.170477,-99) , 
1, 0.213236, 1, 0, 0.288015,-99) , 
3, 0.34753, 0, 0, 0.481843,-99)    );
  // itree = 938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6527, 0, 1, 0.833273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328539,-99) , 
0, 0.138796, 1, 0, 0.563292,-99) , 
3, 0.749307, 0, 0, 0.710629,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148759,-99) , 
0, -0.902977, 1, 0, 0.340839,-99) , 
NN(
0, 
0, 
-1, -0.0736723, 1, -1, 0.0552367,-99) , 
3, -1.13085, 0, 0, 0.229796,-99) , 
3, -0.145446, 0, 0, 0.515862,-99)    );
  // itree = 939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07777, 0, 1, 0.807511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214154,-99) , 
0, -0.0153026, 1, 0, 0.513715,-99) , 
3, 0.476743, 0, 0, 0.669404,-99) , 
NN(
0, 
0, 
-1, -1.43006, 0, -1, 0.168651,-99) , 
3, -0.516641, 0, 0, 0.508187,-99)    );
  // itree = 940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.86548,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220403,-99) , 
0, 0.89651, 1, 0, 0.527594,-99) , 
3, 1.08845, 0, 0, 0.643071,-99) , 
NN(
0, 
0, 
-1, 0.0176327, 1, -1, 0.177318,-99) , 
3, -0.291428, 0, 0, 0.493565,-99)    );
  // itree = 941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.869554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424585,-99) , 
0, 0.262911, 1, 0, 0.60626,-99) , 
3, 1.11887, 0, 0, 0.703645,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187804,-99) , 
0, -0.899852, 1, 0, 0.382554,-99) , 
NN(
0, 
0, 
-1, -0.538037, 1, -1, 0.138583,-99) , 
3, -0.987081, 0, 0, 0.266758,-99) , 
3, -0.000832217, 0, 0, 0.505961,-99)    );
  // itree = 942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.380636, 0, 1, 0.745685,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.254923,-99) , 
3, -0.0725463, 0, 0, 0.544506,-99)    );
  // itree = 943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.54631, 1, 1, 0.858979,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344912,-99) , 
0, -0.0721965, 1, 0, 0.543256,-99) , 
NN(
0, 
0, 
-1, -0.724411, 1, -1, 0.222174,-99) , 
3, -0.451773, 0, 0, 0.400453,-99) , 
3, 0.760049, 0, 0, 0.5456,-99)    );
  // itree = 944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.866966,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255639,-99) , 
0, 0.06353, 1, 0, 0.455457,-99) , 
NN(
0, 
0, 
-1, -0.365486, 1, -1, 0.107278,-99) , 
3, -1.0717, 0, 0, 0.366138,-99) , 
3, 0.760049, 0, 0, 0.50645,-99)    );
  // itree = 945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26691, 1, 1, 0.851917,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.932016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466612,-99) , 
0, 0.0225001, 1, 0, 0.583939,-99) , 
3, 1.00602, 0, 0, 0.716678,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269167,-99) , 
0, -0.671136, 1, 0, 0.419798,-99) , 
NN(
0, 
0, 
-1, -1.3765, 0, -1, 0.176107,-99) , 
3, -0.646522, 0, 0, 0.28778,-99) , 
3, 0.179643, 0, 0, 0.490577,-99)    );
  // itree = 946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.1959, 0, 1, 0.839293,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295114,-99) , 
0, 0.143304, 1, 0, 0.475482,-99) , 
NN(
0, 
0, 
-1, -1.12476, 0, -1, 0.169602,-99) , 
3, -0.665309, 0, 0, 0.354132,-99) , 
3, 0.828289, 0, 0, 0.492261,-99)    );
  // itree = 947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.835146,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447821,-99) , 
0, -0.02649, 1, 0, 0.599322,-99) , 
3, 0.95924, 0, 0, 0.70342,-99) , 
NN(
0, 
0, 
-1, -1.50393, 0, -1, 0.214993,-99) , 
3, -0.218528, 0, 0, 0.512268,-99)    );
  // itree = 948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.884822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414971,-99) , 
0, 0.027439, 1, 0, 0.565714,-99) , 
3, 1.08605, 0, 0, 0.700178,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.263543,-99) , 
3, -0.0447319, 0, 0, 0.515986,-99)    );
  // itree = 949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10102, 0, 1, 0.857123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306262,-99) , 
0, 0.408308, 1, 0, 0.553083,-99) , 
3, 0.926104, 0, 0, 0.698843,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158458,-99) , 
0, -1.39661, 1, 0, 0.250746,-99) , 
NN(
0, 
0, 
-1, -1.80674, 0, -1, 0.0731105,-99) , 
3, -1.20278, 0, 0, 0.186624,-99) , 
3, -0.206128, 0, 0, 0.476416,-99)    );
  // itree = 950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27832, 1, 1, 0.904747,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290102,-99) , 
0, 0.927932, 1, 0, 0.587824,-99) , 
3, 1.18232, 0, 0, 0.694138,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.224003,-99) , 
3, -0.218528, 0, 0, 0.505904,-99)    );
  // itree = 951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17973, 1, 1, 0.884105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35114,-99) , 
0, 0.895962, 1, 0, 0.587906,-99) , 
3, 1.18232, 0, 0, 0.690878,-99) , 
NN(
0, 
0, 
-1, -1.24788, 0, -1, 0.199292,-99) , 
3, -0.218528, 0, 0, 0.502068,-99)    );
  // itree = 952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.827345,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38643,-99) , 
0, -0.0519207, 1, 0, 0.537208,-99) , 
3, 0.828839, 0, 0, 0.662427,-99) , 
NN(
0, 
0, 
-1, -1.07952, 0, -1, 0.155071,-99) , 
3, -0.316527, 0, 0, 0.491477,-99)    );
  // itree = 953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65958, 0, 1, 0.829461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245091,-99) , 
0, 0.454879, 1, 0, 0.487601,-99) , 
3, 0.949517, 0, 0, 0.633371,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.166216,-99) , 
3, -0.218528, 0, 0, 0.461694,-99)    );
  // itree = 954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.75099, 0, 1, 0.838482,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338355,-99) , 
0, 0.076294, 1, 0, 0.501864,-99) , 
NN(
0, 
0, 
-1, -1.56853, 0, -1, 0.167352,-99) , 
3, -0.363821, 0, 0, 0.346418,-99) , 
3, 0.828289, 0, 0, 0.492344,-99)    );
  // itree = 955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.836002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268149,-99) , 
0, 0.500185, 1, 0, 0.535457,-99) , 
3, 0.768248, 0, 0, 0.685972,-99) , 
NN(
0, 
0, 
-1, -0.594943, 0, -1, 0.234854,-99) , 
3, -0.109496, 0, 0, 0.503472,-99)    );
  // itree = 956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68941, 0, 1, 0.835612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304239,-99) , 
0, 0.865651, 1, 0, 0.605278,-99) , 
3, 1.01964, 0, 0, 0.714443,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259431,-99) , 
0, -0.612827, 1, 0, 0.453287,-99) , 
NN(
0, 
0, 
-1, -1.3765, 0, -1, 0.160432,-99) , 
3, -0.642464, 0, 0, 0.295055,-99) , 
3, 0.191234, 0, 0, 0.510093,-99)    );
  // itree = 957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31287, 0, 1, 0.836092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438988,-99) , 
0, -0.0221912, 1, 0, 0.606526,-99) , 
3, 0.78241, 0, 0, 0.748791,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268499,-99) , 
0, -0.391134, 1, 0, 0.45596,-99) , 
NN(
0, 
0, 
-1, -1.13486, 0, -1, 0.18034,-99) , 
3, -0.387798, 0, 0, 0.272977,-99) , 
3, 0.163853, 0, 0, 0.50542,-99)    );
  // itree = 958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.880583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35216,-99) , 
0, 0.91729, 1, 0, 0.650945,-99) , 
3, 1.11419, 0, 0, 0.764015,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339243,-99) , 
0, -1.44213, 1, 0, 0.421615,-99) , 
NN(
0, 
0, 
-1, -0.175545, 1, -1, 0.0795067,-99) , 
3, -1.12817, 0, 0, 0.33612,-99) , 
3, 0.27076, 0, 0, 0.544251,-99)    );
  // itree = 959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.859388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296012,-99) , 
0, 0.0283268, 1, 0, 0.504125,-99) , 
NN(
0, 
0, 
-1, -1.74083, 0, -1, 0.164446,-99) , 
3, -0.524691, 0, 0, 0.349873,-99) , 
3, 0.673895, 0, 0, 0.536109,-99)    );
  // itree = 960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63458, 1, 1, 0.840313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.928069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388392,-99) , 
0, 0.0300823, 1, 0, 0.57582,-99) , 
3, 0.87966, 0, 0, 0.716838,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235543,-99) , 
0, -1.51115, 1, 0, 0.311839,-99) , 
NN(
0, 
0, 
-1, 0.0647876, 0, -1, 0.0716552,-99) , 
3, -1.29124, 0, 0, 0.250178,-99) , 
3, 0.0559666, 0, 0, 0.493349,-99)    );
  // itree = 961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43508, 1, 1, 0.906563,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467267,-99) , 
0, 1.31188, 1, 0, 0.717297,-99) , 
3, 1.59461, 0, 0, 0.785274,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285453,-99) , 
0, -0.165823, 1, 0, 0.472477,-99) , 
NN(
0, 
0, 
-1, -1.25834, 0, -1, 0.178965,-99) , 
3, -0.531196, 0, 0, 0.337442,-99) , 
3, 0.673895, 0, 0, 0.498896,-99)    );
  // itree = 962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.837539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297225,-99) , 
0, 0.44647, 1, 0, 0.522197,-99) , 
3, 0.949517, 0, 0, 0.655736,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200706,-99) , 
0, -1.91842, 1, 0, 0.289507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0099023,-99) , 
3, -1.75861, 0, 0, 0.231628,-99) , 
3, -0.218528, 0, 0, 0.485486,-99)    );
  // itree = 963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.35162, 0, 1, 0.846544,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235105,-99) , 
0, 0.497677, 1, 0, 0.444113,-99) , 
NN(
0, 
0, 
-1, -1.51142, 0, -1, 0.147907,-99) , 
3, -0.631286, 0, 0, 0.336274,-99) , 
3, 0.814561, 0, 0, 0.489309,-99)    );
  // itree = 964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.829519,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39796,-99) , 
0, 0.291557, 1, 0, 0.595623,-99) , 
3, 0.8479, 0, 0, 0.718689,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243745,-99) , 
0, -0.843998, 1, 0, 0.447419,-99) , 
NN(
0, 
0, 
-1, -1.48927, 0, -1, 0.188921,-99) , 
3, -0.512916, 0, 0, 0.278072,-99) , 
3, 0.0391675, 0, 0, 0.502934,-99)    );
  // itree = 965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.820687, 1, 1, 0.828604,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265676,-99) , 
0, 0.134195, 1, 0, 0.513349,-99) , 
3, 0.601626, 0, 0, 0.676785,-99) , 
NN(
0, 
0, 
-1, -1.52124, 0, -1, 0.188391,-99) , 
3, -0.623168, 0, 0, 0.53495,-99)    );
  // itree = 966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41252, 0, 1, 0.826589,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380805,-99) , 
0, -0.742611, 1, 0, 0.458236,-99) , 
NN(
0, 
0, 
-1, -1.261, 0, -1, 0.117214,-99) , 
3, -0.524691, 0, 0, 0.296495,-99) , 
3, 0.673895, 0, 0, 0.448904,-99)    );
  // itree = 967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73748, 0, 1, 0.851534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241865,-99) , 
0, 0.315588, 1, 0, 0.517485,-99) , 
3, 0.861654, 0, 0, 0.642139,-99) , 
NN(
0, 
0, 
-1, -1.50654, 0, -1, 0.175466,-99) , 
3, -0.613509, 0, 0, 0.522218,-99)    );
  // itree = 968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.667626, 0, 1, 0.749987,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191289,-99) , 
0, -0.381656, 1, 0, 0.407299,-99) , 
NN(
0, 
0, 
-1, -1.49149, 0, -1, 0.179013,-99) , 
3, -0.55608, 0, 0, 0.27789,-99) , 
3, 0.256412, 0, 0, 0.492383,-99)    );
  // itree = 969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69109, 1, 1, 0.877153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447408,-99) , 
0, -0.0395668, 1, 0, 0.556645,-99) , 
3, 1.18194, 0, 0, 0.660084,-99) , 
NN(
0, 
0, 
-1, -0.654848, 0, -1, 0.203591,-99) , 
3, -0.156071, 0, 0, 0.478287,-99)    );
  // itree = 970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.86235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305178,-99) , 
0, 0.840567, 1, 0, 0.59838,-99) , 
3, 1.08845, 0, 0, 0.695971,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229735,-99) , 
0, -1.1573, 1, 0, 0.414897,-99) , 
NN(
0, 
0, 
-1, 0.290288, 1, -1, 0.10172,-99) , 
3, -1.05968, 0, 0, 0.269756,-99) , 
3, -0.291428, 0, 0, 0.550528,-99)    );
  // itree = 971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11116, 0, 1, 0.814374,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308291,-99) , 
0, 0.0208352, 1, 0, 0.462018,-99) , 
NN(
0, 
0, 
-1, -1.63158, 0, -1, 0.160798,-99) , 
3, -0.445426, 0, 0, 0.304208,-99) , 
3, 0.742135, 0, 0, 0.472623,-99)    );
  // itree = 972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.87149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295632,-99) , 
0, 0.377147, 1, 0, 0.569698,-99) , 
3, 0.864959, 0, 0, 0.736531,-99) , 
NN(
0, 
0, 
-1, -1.56058, 0, -1, 0.256298,-99) , 
3, 0.0559666, 0, 0, 0.501843,-99)    );
  // itree = 973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.872718,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364009,-99) , 
0, 1.022, 1, 0, 0.694413,-99) , 
3, 1.15583, 0, 0, 0.770701,-99) , 
NN(
0, 
0, 
-1, -0.423686, 0, -1, 0.257615,-99) , 
3, 0.131392, 0, 0, 0.503665,-99)    );
  // itree = 974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.0589, 1, 1, 0.871338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495826,-99) , 
0, -0.0354634, 1, 0, 0.612218,-99) , 
3, 1.19191, 0, 0, 0.706755,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197491,-99) , 
0, -1.61234, 1, 0, 0.294716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0153686,-99) , 
3, -1.62065, 0, 0, 0.254188,-99) , 
3, -0.145446, 0, 0, 0.530736,-99)    );
  // itree = 975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.876826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301406,-99) , 
0, 1.34747, 1, 0, 0.631348,-99) , 
3, 1.32572, 0, 0, 0.73209,-99) , 
NN(
0, 
0, 
-1, -1.55274, 0, -1, 0.324597,-99) , 
3, 0.322617, 0, 0, 0.506988,-99)    );
  // itree = 976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.55899, 0, 1, 0.665859,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183406,-99) , 
0, -1.32386, 1, 0, 0.318343,-99) , 
NN(
0, 
0, 
-1, -1.65914, 0, -1, 0.0973566,-99) , 
3, -1.1857, 0, 0, 0.223085,-99) , 
3, -0.2057, 0, 0, 0.491253,-99)    );
  // itree = 977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.85575,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303306,-99) , 
0, 0.284185, 1, 0, 0.545811,-99) , 
3, 0.92144, 0, 0, 0.684382,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.201722,-99) , 
3, -0.2057, 0, 0, 0.49743,-99)    );
  // itree = 978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68207, 0, 1, 0.881427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369315,-99) , 
0, 0.523357, 1, 0, 0.563501,-99) , 
3, 1.18232, 0, 0, 0.665591,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.220049,-99) , 
3, -0.218528, 0, 0, 0.497654,-99)    );
  // itree = 979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31942, 1, 1, 0.796324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27462,-99) , 
0, 0.196016, 1, 0, 0.554895,-99) , 
3, 0.638487, 0, 0, 0.6859,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.203294,-99) , 
3, -0.291428, 0, 0, 0.521096,-99)    );
  // itree = 980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71465, 0, 1, 0.776109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254232,-99) , 
0, -0.0428066, 1, 0, 0.483983,-99) , 
3, 0.585481, 0, 0, 0.622766,-99) , 
NN(
0, 
0, 
-1, -1.5277, 0, -1, 0.13309,-99) , 
3, -0.636326, 0, 0, 0.483615,-99)    );
  // itree = 981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3593, 0, 1, 0.861067,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397691,-99) , 
0, 0.146168, 1, 0, 0.57947,-99) , 
3, 0.864959, 0, 0, 0.720201,-99) , 
NN(
0, 
0, 
-1, -0.483325, 0, -1, 0.254426,-99) , 
3, 0.0559666, 0, 0, 0.503614,-99)    );
  // itree = 982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.862712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423972,-99) , 
0, 0.91729, 1, 0, 0.66895,-99) , 
3, 1.17174, 0, 0, 0.761822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358579,-99) , 
0, -0.800624, 1, 0, 0.46392,-99) , 
NN(
0, 
0, 
-1, -1.6555, 0, -1, 0.150347,-99) , 
3, -0.476904, 0, 0, 0.295359,-99) , 
3, 0.34753, 0, 0, 0.501068,-99)    );
  // itree = 983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15185, 1, 1, 0.820635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248563,-99) , 
0, -0.0748989, 1, 0, 0.484529,-99) , 
NN(
0, 
0, 
-1, -1.5088, 0, -1, 0.163146,-99) , 
3, -0.82328, 0, 0, 0.372155,-99) , 
3, 0.673895, 0, 0, 0.530578,-99)    );
  // itree = 984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6338, 1, 1, 0.892507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393714,-99) , 
0, 1.12516, 1, 0, 0.665535,-99) , 
3, 1.2121, 0, 0, 0.794782,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3728,-99) , 
0, -0.836892, 1, 0, 0.455552,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.188215,-99) , 
3, -0.535926, 0, 0, 0.3379,-99) , 
3, 0.661338, 0, 0, 0.487398,-99)    );
  // itree = 985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.859801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205606,-99) , 
0, 0.515271, 1, 0, 0.478555,-99) , 
NN(
0, 
0, 
-1, -0.665547, 1, -1, 0.158876,-99) , 
3, -0.458643, 0, 0, 0.333345,-99) , 
3, 0.712472, 0, 0, 0.504957,-99)    );
  // itree = 986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07188, 1, 1, 0.78458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322715,-99) , 
0, -0.11235, 1, 0, 0.497587,-99) , 
3, 0.812207, 0, 0, 0.618009,-99) , 
NN(
0, 
0, 
-1, -1.35849, 0, -1, 0.170853,-99) , 
3, -0.680259, 0, 0, 0.487892,-99)    );
  // itree = 987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17725, 0, 1, 0.8942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474545,-99) , 
0, 0.539213, 1, 0, 0.632002,-99) , 
3, 1.17573, 0, 0, 0.758359,-99) , 
NN(
0, 
0, 
-1, -1.57572, 0, -1, 0.326902,-99) , 
3, 0.34753, 0, 0, 0.523772,-99)    );
  // itree = 988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.899964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290751,-99) , 
0, 0.927227, 1, 0, 0.595342,-99) , 
3, 1.15532, 0, 0, 0.685998,-99) , 
NN(
0, 
0, 
-1, -1.63434, 0, -1, 0.198097,-99) , 
3, -0.534624, 0, 0, 0.532465,-99)    );
  // itree = 989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.87909, 0, 1, 0.831532,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263432,-99) , 
0, 0.0933402, 1, 0, 0.48441,-99) , 
NN(
0, 
0, 
-1, -1.22566, 0, -1, 0.147222,-99) , 
3, -0.754651, 0, 0, 0.357069,-99) , 
3, 0.760049, 0, 0, 0.509966,-99)    );
  // itree = 990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.90435,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275439,-99) , 
0, 1.05998, 1, 0, 0.618916,-99) , 
3, 1.18232, 0, 0, 0.714485,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.147409,-99) , 
0, -1.43921, 1, 0, 0.288787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.029823,-99) , 
3, -1.50393, 0, 0, 0.227149,-99) , 
3, -0.218528, 0, 0, 0.53929,-99)    );
  // itree = 991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45784, 0, 1, 0.836659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321198,-99) , 
0, 0.0375475, 1, 0, 0.502206,-99) , 
3, 0.917687, 0, 0, 0.631061,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.135365,-99) , 
3, -0.613987, 0, 0, 0.499701,-99)    );
  // itree = 992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17464, 1, 1, 0.864591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293618,-99) , 
0, 0.891504, 1, 0, 0.620813,-99) , 
3, 1.15758, 0, 0, 0.705206,-99) , 
NN(
0, 
0, 
-1, -1.20278, 0, -1, 0.20836,-99) , 
3, -0.206128, 0, 0, 0.513049,-99)    );
  // itree = 993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.858562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303378,-99) , 
0, 0.865651, 1, 0, 0.634437,-99) , 
3, 1.12078, 0, 0, 0.739506,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267852,-99) , 
0, -0.957925, 1, 0, 0.375799,-99) , 
NN(
0, 
0, 
-1, -1.99365, 0, -1, 0.0651023,-99) , 
3, -1.13339, 0, 0, 0.290487,-99) , 
3, 0.27076, 0, 0, 0.486329,-99)    );
  // itree = 994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.690724, 0, 1, 0.778244,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236983,-99) , 
0, -0.150485, 1, 0, 0.467387,-99) , 
NN(
0, 
0, 
-1, -1.55014, 0, -1, 0.160789,-99) , 
3, -0.574972, 0, 0, 0.306469,-99) , 
3, 0.27076, 0, 0, 0.521965,-99)    );
  // itree = 995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.542186, 1, 1, 0.82163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423705,-99) , 
3, 0.544243, 0, 0, 0.752707,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2167,-99) , 
0, -0.000706236, 1, 0, 0.433414,-99) , 
NN(
0, 
0, 
-1, -1.12336, 0, -1, 0.160571,-99) , 
3, -0.44524, 0, 0, 0.283665,-99) , 
3, 0.345004, 0, 0, 0.481861,-99)    );
  // itree = 996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.39714, 1, 1, 0.933747,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.879212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47116,-99) , 
0, 1.54562, 1, 0, 0.764253,-99) , 
3, 1.58143, 0, 0, 0.835416,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21608,-99) , 
0, 0.356517, 1, 0, 0.54157,-99) , 
NN(
0, 
0, 
-1, -1.51758, 0, -1, 0.206632,-99) , 
3, -0.237998, 0, 0, 0.344989,-99) , 
3, 0.661338, 0, 0, 0.509457,-99)    );
  // itree = 997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.768591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218276,-99) , 
0, 0.0612479, 1, 0, 0.468398,-99) , 
3, 0.601626, 0, 0, 0.617133,-99) , 
NN(
0, 
0, 
-1, -1.51587, 0, -1, 0.12333,-99) , 
3, -0.623168, 0, 0, 0.484469,-99)    );
  // itree = 998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07785, 0, 1, 0.931998,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497024,-99) , 
3, 1.60573, 0, 0, 0.713949,-99) , 
0, 1.39628, 1, 0, 0.820134,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231817,-99) , 
0, 0.138796, 1, 0, 0.475732,-99) , 
NN(
0, 
0, 
-1, -1.51536, 0, -1, 0.201784,-99) , 
3, -0.524691, 0, 0, 0.344072,-99) , 
3, 0.673895, 0, 0, 0.50287,-99)    );
  // itree = 999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09762, 0, 1, 0.828911,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310784,-99) , 
0, 0.232439, 1, 0, 0.511856,-99) , 
3, 0.720251, 0, 0, 0.679623,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.229267,-99) , 
3, -0.218528, 0, 0, 0.486484,-99)    );
  // itree = 1000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42459, 1, 1, 0.881227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434557,-99) , 
0, 0.262911, 1, 0, 0.613253,-99) , 
3, 1.09078, 0, 0, 0.733656,-99) , 
NN(
0, 
0, 
-1, -0.539588, 0, -1, 0.228615,-99) , 
3, -0.0426953, 0, 0, 0.494735,-99)    );
  // itree = 1001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44277, 0, 1, 0.864091,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283887,-99) , 
0, 0.416931, 1, 0, 0.552167,-99) , 
3, 0.926722, 0, 0, 0.682825,-99) , 
NN(
0, 
0, 
-1, -0.710408, 0, -1, 0.217899,-99) , 
3, -0.206128, 0, 0, 0.518277,-99)    );
  // itree = 1002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.728602, 1, 1, 0.820712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37263,-99) , 
0, -0.243891, 1, 0, 0.524754,-99) , 
3, 0.628887, 0, 0, 0.689119,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142819,-99) , 
0, -1.08805, 1, 0, 0.294422,-99) , 
NN(
0, 
0, 
-1, -1.94869, 0, -1, 0.0936987,-99) , 
3, -1.05968, 0, 0, 0.207466,-99) , 
3, -0.291428, 0, 0, 0.508208,-99)    );
  // itree = 1003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26839, 1, 1, 0.816093,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316201,-99) , 
0, 0.138796, 1, 0, 0.510543,-99) , 
3, 0.616639, 0, 0, 0.675158,-99) , 
NN(
0, 
0, 
-1, -1.08151, 0, -1, 0.23254,-99) , 
3, -0.302053, 0, 0, 0.512765,-99)    );
  // itree = 1004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.830227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356195,-99) , 
0, -0.147815, 1, 0, 0.507451,-99) , 
3, 0.777375, 0, 0, 0.682954,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202339,-99) , 
0, -1.31724, 1, 0, 0.314245,-99) , 
NN(
0, 
0, 
-1, -1.69864, 0, -1, 0.098001,-99) , 
3, -1.10626, 0, 0, 0.228179,-99) , 
3, -0.115595, 0, 0, 0.488546,-99)    );
  // itree = 1005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.892548,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388228,-99) , 
0, 0.865651, 1, 0, 0.627846,-99) , 
3, 1.15201, 0, 0, 0.734557,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238766,-99) , 
0, -0.950363, 1, 0, 0.364347,-99) , 
NN(
0, 
0, 
-1, -2.41213, 1, -1, 0.104737,-99) , 
3, -0.972075, 0, 0, 0.245238,-99) , 
3, 0.125502, 0, 0, 0.489814,-99)    );
  // itree = 1006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27832, 1, 1, 0.879543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257653,-99) , 
0, 0.625707, 1, 0, 0.585135,-99) , 
3, 0.926104, 0, 0, 0.727562,-99) , 
NN(
0, 
0, 
-1, -0.710408, 0, -1, 0.258293,-99) , 
3, -0.206128, 0, 0, 0.555467,-99)    );
  // itree = 1007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60699, 1, 1, 0.857849,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273864,-99) , 
0, 0.454461, 1, 0, 0.560736,-99) , 
3, 0.784282, 0, 0, 0.720607,-99) , 
NN(
0, 
0, 
-1, -1.14068, 0, -1, 0.201547,-99) , 
3, -0.133228, 0, 0, 0.50243,-99)    );
  // itree = 1008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.03751, 1, 1, 0.877251,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445957,-99) , 
0, 0.803606, 1, 0, 0.693542,-99) , 
3, 1.1935, 0, 0, 0.776482,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243655,-99) , 
0, -0.565312, 1, 0, 0.400007,-99) , 
NN(
0, 
0, 
-1, -1.14346, 0, -1, 0.164325,-99) , 
3, -0.392547, 0, 0, 0.253373,-99) , 
3, 0.163853, 0, 0, 0.494175,-99)    );
  // itree = 1009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.25346, 0, 1, 0.817835,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221809,-99) , 
0, 0.0578584, 1, 0, 0.414462,-99) , 
NN(
0, 
0, 
-1, -0.351396, 1, -1, 0.0877699,-99) , 
3, -1.0423, 0, 0, 0.335609,-99) , 
3, 0.712472, 0, 0, 0.476249,-99)    );
  // itree = 1010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16149, 0, 1, 0.816793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278772,-99) , 
0, -0.257739, 1, 0, 0.48833,-99) , 
3, 0.601626, 0, 0, 0.658093,-99) , 
NN(
0, 
0, 
-1, -1.5135, 0, -1, 0.136118,-99) , 
3, -0.623168, 0, 0, 0.50913,-99)    );
  // itree = 1011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.64298, 0, 1, 0.782259,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181614,-99) , 
0, 0.123422, 1, 0, 0.42965,-99) , 
NN(
0, 
0, 
-1, -2.59323, 1, -1, 0.167575,-99) , 
3, -0.651582, 0, 0, 0.308883,-99) , 
3, 0.427177, 0, 0, 0.491914,-99)    );
  // itree = 1012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34997, 0, 1, 0.832078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407252,-99) , 
0, 0.076294, 1, 0, 0.592956,-99) , 
3, 0.790869, 0, 0, 0.711274,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244494,-99) , 
0, -1.39661, 1, 0, 0.353878,-99) , 
NN(
0, 
0, 
-1, 0.434174, 0, -1, 0.1196,-99) , 
3, -1.14247, 0, 0, 0.264221,-99) , 
3, -0.133228, 0, 0, 0.525763,-99)    );
  // itree = 1013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67413, 0, 1, 0.85869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466176,-99) , 
0, 0.44647, 1, 0, 0.642535,-99) , 
3, 0.965707, 0, 0, 0.7702,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338394,-99) , 
0, -0.814411, 1, 0, 0.452561,-99) , 
NN(
0, 
0, 
-1, -1.67014, 0, -1, 0.166378,-99) , 
3, -0.480034, 0, 0, 0.303195,-99) , 
3, 0.34753, 0, 0, 0.507507,-99)    );
  // itree = 1014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67962, 1, 1, 0.902859,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487508,-99) , 
0, 0.230242, 1, 0, 0.60843,-99) , 
3, 1.22763, 0, 0, 0.721258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635029,-99) , 
NN(
0, 
0, 
-1, -1.1407, 0, -1, 0.198212,-99) , 
3, -0.0882295, 0, 0, 0.269291,-99) , 
3, 0.191234, 0, 0, 0.477645,-99)    );
  // itree = 1015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.38674, 1, 1, 0.914966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.915294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495748,-99) , 
0, 1.31188, 1, 0, 0.754587,-99) , 
3, 1.47158, 0, 0, 0.827074,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24594,-99) , 
0, 0.156982, 1, 0, 0.457841,-99) , 
NN(
0, 
0, 
-1, -1.64062, 0, -1, 0.13723,-99) , 
3, -0.727114, 0, 0, 0.340273,-99) , 
3, 0.742135, 0, 0, 0.488428,-99)    );
  // itree = 1016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.34633, 1, 1, 0.933625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46895,-99) , 
0, 1.31188, 1, 0, 0.720256,-99) , 
3, 1.59914, 0, 0, 0.803032,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429878,-99) , 
0, -0.855501, 1, 0, 0.524273,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.207593,-99) , 
3, -0.528692, 0, 0, 0.388898,-99) , 
3, 0.673895, 0, 0, 0.535446,-99)    );
  // itree = 1017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.854929,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15533,-99) , 
0, 0.877723, 1, 0, 0.545089,-99) , 
3, 0.950076, 0, 0, 0.655908,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.166889,-99) , 
3, -0.547237, 0, 0, 0.514795,-99)    );
  // itree = 1018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.853148,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26372,-99) , 
0, 0.431079, 1, 0, 0.529241,-99) , 
NN(
0, 
0, 
-1, -1.63545, 0, -1, 0.214144,-99) , 
3, -0.445426, 0, 0, 0.383623,-99) , 
3, 0.742135, 0, 0, 0.521203,-99)    );
  // itree = 1019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15225, 0, 1, 0.700174,-99) , 
NN(
0, 
0, 
-1, -0.710408, 0, -1, 0.225384,-99) , 
3, -0.206128, 0, 0, 0.508919,-99)    );
  // itree = 1020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.811297,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259193,-99) , 
0, 0.227133, 1, 0, 0.482204,-99) , 
NN(
0, 
0, 
-1, -1.52561, 0, -1, 0.166805,-99) , 
3, -0.535926, 0, 0, 0.340509,-99) , 
3, 0.661338, 0, 0, 0.501274,-99)    );
  // itree = 1021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13381, 0, 1, 0.786487,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197337,-99) , 
0, 0.418264, 1, 0, 0.471351,-99) , 
NN(
0, 
0, 
-1, -1.4442, 0, -1, 0.182379,-99) , 
3, -0.458101, 0, 0, 0.334719,-99) , 
3, 0.760049, 0, 0, 0.46602,-99)    );
  // itree = 1022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.673442, 1, 1, 0.943379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.92505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494239,-99) , 
3, 1.65971, 0, 0, 0.726037,-99) , 
0, 1.39628, 1, 0, 0.82156,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184769,-99) , 
0, 0.418264, 1, 0, 0.502696,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.205252,-99) , 
3, -0.441503, 0, 0, 0.35281,-99) , 
3, 0.742135, 0, 0, 0.498066,-99)    );
  // itree = 1023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.814421,-99) , 
NN(
0, 
0, 
-1, -1.13178, 0, -1, 0.330689,-99) , 
3, 0.661338, 0, 0, 0.486346,-99)    );
  // itree = 1024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21585, 1, 1, 0.902655,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301631,-99) , 
0, 1.49177, 1, 0, 0.690232,-99) , 
3, 1.36049, 0, 0, 0.763017,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219863,-99) , 
1, 0.221082, 1, 0, 0.440763,-99) , 
NN(
0, 
0, 
-1, -1.65875, 0, -1, 0.144751,-99) , 
3, -0.688061, 0, 0, 0.291093,-99) , 
3, 0.131392, 0, 0, 0.52453,-99)    );
  // itree = 1025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.45893, 0, 1, 0.84142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274805,-99) , 
0, -0.0748989, 1, 0, 0.472866,-99) , 
NN(
0, 
0, 
-1, -1.5664, 0, -1, 0.202507,-99) , 
3, -0.412102, 0, 0, 0.343147,-99) , 
3, 0.748104, 0, 0, 0.499212,-99)    );
  // itree = 1026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.606045, 0, 1, 0.734618,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290574,-99) , 
0, -0.667983, 1, 0, 0.467806,-99) , 
NN(
0, 
0, 
-1, -1.58609, 0, -1, 0.130913,-99) , 
3, -0.639477, 0, 0, 0.282263,-99) , 
3, 0.191234, 0, 0, 0.496539,-99)    );
  // itree = 1027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.194543, 1, 1, 0.919447,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872687,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387986,-99) , 
3, 1.2208, 0, 0, 0.705584,-99) , 
0, 0.973472, 1, 0, 0.781722,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279024,-99) , 
0, -0.615667, 1, 0, 0.414198,-99) , 
NN(
0, 
0, 
-1, -1.58361, 0, -1, 0.153402,-99) , 
3, -0.415323, 0, 0, 0.272963,-99) , 
3, 0.402144, 0, 0, 0.466179,-99)    );
  // itree = 1028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04569, 1, 1, 0.820382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390908,-99) , 
0, 0.0208352, 1, 0, 0.570813,-99) , 
3, 0.703037, 0, 0, 0.686389,-99) , 
NN(
0, 
0, 
-1, -2.07347, 1, -1, 0.154775,-99) , 
3, -0.547237, 0, 0, 0.519343,-99)    );
  // itree = 1029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.850517,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403893,-99) , 
0, 0.0112647, 1, 0, 0.555874,-99) , 
3, 0.952846, 0, 0, 0.68829,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.212086,-99) , 
3, -0.218528, 0, 0, 0.495565,-99)    );
  // itree = 1030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07419, 1, 1, 0.843385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360624,-99) , 
0, -0.136896, 1, 0, 0.525274,-99) , 
3, 0.845948, 0, 0, 0.673666,-99) , 
NN(
0, 
0, 
-1, -1.57306, 0, -1, 0.21339,-99) , 
3, -0.302053, 0, 0, 0.504541,-99)    );
  // itree = 1031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68706, 0, 1, 0.869199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344866,-99) , 
0, 0.927932, 1, 0, 0.575456,-99) , 
3, 1.18544, 0, 0, 0.676701,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247753,-99) , 
1, 0.0963539, 1, 0, 0.381725,-99) , 
NN(
0, 
0, 
-1, -2.55908, 1, -1, 0.101825,-99) , 
3, -0.987827, 0, 0, 0.241594,-99) , 
3, -0.218528, 0, 0, 0.51476,-99)    );
  // itree = 1032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27903, 1, 1, 0.824605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301082,-99) , 
0, -0.0153026, 1, 0, 0.52253,-99) , 
3, 0.604254, 0, 0, 0.662466,-99) , 
NN(
0, 
0, 
-1, -1.11327, 0, -1, 0.18044,-99) , 
3, -0.623168, 0, 0, 0.528013,-99)    );
  // itree = 1033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.846471, 1, 1, 0.913094,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48665,-99) , 
3, 1.25458, 0, 0, 0.744967,-99) , 
0, 1.17505, 1, 0, 0.801211,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192887,-99) , 
0, 0.348213, 1, 0, 0.510193,-99) , 
NN(
0, 
0, 
-1, -1.5132, 0, -1, 0.235118,-99) , 
3, -0.23299, 0, 0, 0.362323,-99) , 
3, 0.673895, 0, 0, 0.504818,-99)    );
  // itree = 1034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.875395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455327,-99) , 
0, 0.415815, 1, 0, 0.601037,-99) , 
3, 1.18544, 0, 0, 0.684871,-99) , 
NN(
0, 
0, 
-1, -0.734051, 0, -1, 0.233151,-99) , 
3, -0.218528, 0, 0, 0.511862,-99)    );
  // itree = 1035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43731, 1, 1, 0.928245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458017,-99) , 
0, 1.65848, 1, 0, 0.718377,-99) , 
3, 1.64138, 0, 0, 0.775639,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25652,-99) , 
0, -0.684386, 1, 0, 0.366655,-99) , 
NN(
0, 
0, 
-1, 0.0645827, 1, -1, 0.0536258,-99) , 
3, -1.19089, 0, 0, 0.288838,-99) , 
3, 0.427177, 0, 0, 0.481503,-99)    );
  // itree = 1036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.855663,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326931,-99) , 
0, 0.454879, 1, 0, 0.533868,-99) , 
3, 1.00095, 0, 0, 0.667769,-99) , 
NN(
0, 
0, 
-1, -1.57935, 0, -1, 0.213082,-99) , 
3, -0.115595, 0, 0, 0.476708,-99)    );
  // itree = 1037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13381, 0, 1, 0.828124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351904,-99) , 
0, -0.742611, 1, 0, 0.456376,-99) , 
NN(
0, 
0, 
-1, -1.24344, 0, -1, 0.0966999,-99) , 
3, -0.769764, 0, 0, 0.320788,-99) , 
3, 0.760049, 0, 0, 0.477639,-99)    );
  // itree = 1038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.863401, 0, 1, 0.783179,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197294,-99) , 
0, -0.150485, 1, 0, 0.413646,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.152945,-99) , 
3, -0.661232, 0, 0, 0.305036,-99) , 
3, 0.504887, 0, 0, 0.486709,-99)    );
  // itree = 1039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.6577, 0, 1, 0.831583,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290412,-99) , 
0, 0.0477724, 1, 0, 0.510104,-99) , 
NN(
0, 
0, 
-1, -0.677103, 1, -1, 0.154873,-99) , 
3, -0.445426, 0, 0, 0.336686,-99) , 
3, 0.742135, 0, 0, 0.493335,-99)    );
  // itree = 1040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15882, 0, 1, 0.793819,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239787,-99) , 
0, 0.0208352, 1, 0, 0.473831,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.182022,-99) , 
3, -0.57899, 0, 0, 0.345043,-99) , 
3, 0.602686, 0, 0, 0.505051,-99)    );
  // itree = 1041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.837536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393527,-99) , 
0, 0.133718, 1, 0, 0.597422,-99) , 
3, 0.912867, 0, 0, 0.692803,-99) , 
NN(
0, 
0, 
-1, -1.46943, 1, -1, 0.209763,-99) , 
3, -0.430822, 0, 0, 0.53329,-99)    );
  // itree = 1042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.16822, 1, 1, 0.907539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302824,-99) , 
0, 1.49177, 1, 0, 0.681149,-99) , 
3, 1.56172, 0, 0, 0.744676,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276216,-99) , 
0, -0.843998, 1, 0, 0.421892,-99) , 
NN(
0, 
0, 
-1, -1.63463, 0, -1, 0.125214,-99) , 
3, -0.696161, 0, 0, 0.251903,-99) , 
3, 0.125502, 0, 0, 0.486378,-99)    );
  // itree = 1043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4601, 0, 1, 0.834949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258032,-99) , 
0, 0.227133, 1, 0, 0.507773,-99) , 
3, 0.701791, 0, 0, 0.661025,-99) , 
NN(
0, 
0, 
-1, -1.68094, 0, -1, 0.147228,-99) , 
3, -0.547237, 0, 0, 0.502019,-99)    );
  // itree = 1044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32252, 0, 1, 0.882559,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223065,-99) , 
0, 0.7733, 1, 0, 0.550546,-99) , 
3, 0.981344, 0, 0, 0.708729,-99) , 
NN(
0, 
0, 
-1, -0.373907, 0, -1, 0.214592,-99) , 
3, -0.12622, 0, 0, 0.489686,-99)    );
  // itree = 1045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37916, 0, 1, 0.825829,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358027,-99) , 
0, -0.291022, 1, 0, 0.516203,-99) , 
3, 0.849125, 0, 0, 0.653576,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.244302,-99) , 
3, -0.302053, 0, 0, 0.498823,-99)    );
  // itree = 1046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.69429, 0, 1, 0.842381,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19266,-99) , 
0, 0.391814, 1, 0, 0.436719,-99) , 
NN(
0, 
0, 
-1, -1.45381, 0, -1, 0.146119,-99) , 
3, -0.755609, 0, 0, 0.331964,-99) , 
3, 0.760049, 0, 0, 0.485553,-99)    );
  // itree = 1047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04863, 0, 1, 0.838205,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240694,-99) , 
0, -0.0153026, 1, 0, 0.399712,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.170621,-99) , 
3, -0.528692, 0, 0, 0.295289,-99) , 
3, 0.673895, 0, 0, 0.473835,-99)    );
  // itree = 1048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51583, 0, 1, 0.878241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452167,-99) , 
0, 0.089073, 1, 0, 0.56168,-99) , 
3, 1.18232, 0, 0, 0.673164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199369,-99) , 
0, -1.75115, 1, 0, 0.305946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.067616,-99) , 
3, -1.50247, 0, 0, 0.246937,-99) , 
3, -0.218528, 0, 0, 0.502352,-99)    );
  // itree = 1049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04252, 0, 1, 0.799312,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219142,-99) , 
0, 0.158188, 1, 0, 0.468817,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.170152,-99) , 
3, -0.524691, 0, 0, 0.337079,-99) , 
3, 0.673895, 0, 0, 0.492663,-99)    );
  // itree = 1050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.864534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291363,-99) , 
0, 0.884016, 1, 0, 0.594675,-99) , 
3, 1.09528, 0, 0, 0.724526,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131902,-99) , 
3, -1.04364, 0, 0, 0.398615,-99) , 
NN(
0, 
0, 
-1, -1.25811, 0, -1, 0.16543,-99) , 
1, 0.284447, 1, 0, 0.295131,-99) , 
3, 0.295236, 0, 0, 0.492058,-99)    );
  // itree = 1051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67471, 0, 1, 0.824016,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397411,-99) , 
1, -0.421892, 1, 0, 0.505862,-99) , 
3, 0.813112, 0, 0, 0.620255,-99) , 
NN(
0, 
0, 
-1, -1.11327, 0, -1, 0.135563,-99) , 
3, -0.663377, 0, 0, 0.481822,-99)    );
  // itree = 1052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.871645,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451257,-99) , 
0, -0.0253376, 1, 0, 0.557352,-99) , 
3, 1.14037, 0, 0, 0.674862,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.192532,-99) , 
3, -0.216753, 0, 0, 0.485899,-99)    );
  // itree = 1053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.587963, 1, 1, 0.792836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270342,-99) , 
0, 0.213204, 1, 0, 0.538619,-99) , 
3, 0.639192, 0, 0, 0.686506,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190084,-99) , 
0, -0.86692, 1, 0, 0.352548,-99) , 
NN(
0, 
0, 
-1, -1.65917, 0, -1, 0.0983419,-99) , 
3, -1.04178, 0, 0, 0.244827,-99) , 
3, -0.0447319, 0, 0, 0.480182,-99)    );
  // itree = 1054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.833035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211289,-99) , 
0, 0.688544, 1, 0, 0.526041,-99) , 
3, 0.897747, 0, 0, 0.652194,-99) , 
NN(
0, 
0, 
-1, -2.14357, 1, -1, 0.160967,-99) , 
3, -0.613987, 0, 0, 0.507637,-99)    );
  // itree = 1055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06862, 0, 1, 0.792163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232827,-99) , 
0, 0.138796, 1, 0, 0.494673,-99) , 
3, 0.497902, 0, 0, 0.673062,-99) , 
NN(
0, 
0, 
-1, -0.667942, 0, -1, 0.197281,-99) , 
3, -0.170545, 0, 0, 0.482308,-99)    );
  // itree = 1056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.845958,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240918,-99) , 
0, 0.65461, 1, 0, 0.527409,-99) , 
3, 0.897747, 0, 0, 0.645637,-99) , 
NN(
0, 
0, 
-1, -1.73626, 1, -1, 0.162481,-99) , 
3, -0.613987, 0, 0, 0.515814,-99)    );
  // itree = 1057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4671, 1, 1, 0.839615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43672,-99) , 
0, 0.365151, 1, 0, 0.581309,-99) , 
3, 0.965707, 0, 0, 0.739329,-99) , 
NN(
0, 
0, 
-1, -0.751702, 0, -1, 0.238272,-99) , 
3, 0.34753, 0, 0, 0.450258,-99)    );
  // itree = 1058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39559, 0, 1, 0.82711,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189474,-99) , 
0, 0.227133, 1, 0, 0.453307,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.165393,-99) , 
3, -0.542018, 0, 0, 0.333796,-99) , 
3, 0.661338, 0, 0, 0.492038,-99)    );
  // itree = 1059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.874953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371279,-99) , 
0, 0.734806, 1, 0, 0.622997,-99) , 
3, 0.987635, 0, 0, 0.757723,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278039,-99) , 
0, -0.776959, 1, 0, 0.401093,-99) , 
NN(
0, 
0, 
-1, -1.14182, 0, -1, 0.135931,-99) , 
3, -0.662162, 0, 0, 0.27006,-99) , 
3, 0.163853, 0, 0, 0.488103,-99)    );
  // itree = 1060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61861, 0, 1, 0.845944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285595,-99) , 
0, 0.547267, 1, 0, 0.573328,-99) , 
3, 0.727254, 0, 0, 0.729794,-99) , 
NN(
0, 
0, 
-1, -1.14113, 0, -1, 0.225428,-99) , 
3, -0.172486, 0, 0, 0.510508,-99)    );
  // itree = 1061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46147, 1, 1, 0.874217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251293,-99) , 
0, 0.900636, 1, 0, 0.566008,-99) , 
3, 1.11419, 0, 0, 0.717214,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574916,-99) , 
NN(
0, 
0, 
-1, -1.61526, 0, -1, 0.229078,-99) , 
3, -0.0165573, 0, 0, 0.289419,-99) , 
3, 0.27076, 0, 0, 0.493534,-99)    );
  // itree = 1062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.855714,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39469,-99) , 
0, 0.835519, 1, 0, 0.612919,-99) , 
3, 1.11296, 0, 0, 0.734786,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311101,-99) , 
0, -0.843998, 1, 0, 0.439946,-99) , 
NN(
0, 
0, 
-1, -2.39294, 1, -1, 0.148449,-99) , 
3, -0.759018, 0, 0, 0.316752,-99) , 
3, 0.311026, 0, 0, 0.510297,-99)    );
  // itree = 1063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.64157, 0, 1, 0.745172,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240929,-99) , 
0, -0.305342, 1, 0, 0.402412,-99) , 
NN(
0, 
0, 
-1, -1.54223, 0, -1, 0.154457,-99) , 
3, -0.651582, 0, 0, 0.28958,-99) , 
3, 0.427177, 0, 0, 0.468244,-99)    );
  // itree = 1064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.855951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294244,-99) , 
0, 0.91729, 1, 0, 0.583241,-99) , 
3, 1.11005, 0, 0, 0.718256,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299395,-99) , 
0, -1.47165, 1, 0, 0.375234,-99) , 
NN(
0, 
0, 
-1, -1.78147, 0, -1, 0.0933376,-99) , 
3, -1.13818, 0, 0, 0.289655,-99) , 
3, 0.27076, 0, 0, 0.489874,-99)    );
  // itree = 1065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48356, 1, 1, 0.856308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.944294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36501,-99) , 
0, 0.233182, 1, 0, 0.594895,-99) , 
3, 0.924565, 0, 0, 0.750066,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296762,-99) , 
0, -0.568658, 1, 0, 0.413116,-99) , 
NN(
0, 
0, 
-1, -1.61495, 0, -1, 0.18653,-99) , 
3, -0.475871, 0, 0, 0.286861,-99) , 
3, 0.320269, 0, 0, 0.481999,-99)    );
  // itree = 1066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.38599, 1, 1, 0.874921,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366989,-99) , 
0, 1.02904, 1, 0, 0.64022,-99) , 
3, 1.31972, 0, 0, 0.719594,-99) , 
NN(
0, 
0, 
-1, -1.12817, 0, -1, 0.264379,-99) , 
3, 0.27076, 0, 0, 0.469567,-99)    );
  // itree = 1067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.813021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255453,-99) , 
0, 0.429255, 1, 0, 0.525676,-99) , 
3, 0.749245, 0, 0, 0.653992,-99) , 
NN(
0, 
0, 
-1, -1.70026, 0, -1, 0.194152,-99) , 
3, -0.774089, 0, 0, 0.53095,-99)    );
  // itree = 1068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.902308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329991,-99) , 
0, 0.936812, 1, 0, 0.623859,-99) , 
3, 1.11005, 0, 0, 0.756656,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363366,-99) , 
0, -0.612827, 1, 0, 0.484462,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.198682,-99) , 
3, -0.569108, 0, 0, 0.319837,-99) , 
3, 0.27076, 0, 0, 0.523612,-99)    );
  // itree = 1069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98872, 1, 1, 0.866174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243195,-99) , 
0, 1.07553, 1, 0, 0.57721,-99) , 
3, 1.20066, 0, 0, 0.67392,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207166,-99) , 
1, -0.297941, 1, 0, 0.292612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.029519,-99) , 
3, -1.58952, 0, 0, 0.237799,-99) , 
3, -0.128257, 0, 0, 0.49005,-99)    );
  // itree = 1070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.850425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177894,-99) , 
0, 0.769199, 1, 0, 0.581851,-99) , 
3, 0.985082, 0, 0, 0.699305,-99) , 
NN(
0, 
0, 
-1, -0.619341, 0, -1, 0.223732,-99) , 
3, -0.128257, 0, 0, 0.489499,-99)    );
  // itree = 1071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98872, 1, 1, 0.85599,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454572,-99) , 
0, 0.459087, 1, 0, 0.603452,-99) , 
3, 1.19406, 0, 0, 0.705781,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298505,-99) , 
0, -1.07517, 1, 0, 0.43868,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.153678,-99) , 
3, -0.66376, 0, 0, 0.300744,-99) , 
3, 0.163853, 0, 0, 0.496675,-99)    );
  // itree = 1072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8206, 1, 1, 0.865555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373412,-99) , 
0, 0.886736, 1, 0, 0.601173,-99) , 
3, 1.2208, 0, 0, 0.737284,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24302,-99) , 
0, -0.449573, 1, 0, 0.425027,-99) , 
NN(
0, 
0, 
-1, -1.56523, 0, -1, 0.124029,-99) , 
3, -0.686056, 0, 0, 0.301033,-99) , 
3, 0.402144, 0, 0, 0.477881,-99)    );
  // itree = 1073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37881, 1, 1, 0.88389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318917,-99) , 
0, 0.71825, 1, 0, 0.662994,-99) , 
3, 1.082, 0, 0, 0.776795,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207223,-99) , 
0, -0.341503, 1, 0, 0.441681,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.174029,-99) , 
3, -0.567014, 0, 0, 0.299196,-99) , 
3, 0.268003, 0, 0, 0.518703,-99)    );
  // itree = 1074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.863401,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26869,-99) , 
0, 0.969329, 1, 0, 0.610682,-99) , 
3, 1.08754, 0, 0, 0.708053,-99) , 
NN(
0, 
0, 
-1, -1.52753, 0, -1, 0.220349,-99) , 
3, -0.0426953, 0, 0, 0.488734,-99)    );
  // itree = 1075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.962827, 1, 1, 0.810832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40774,-99) , 
3, 0.408862, 1, 0, 0.455502,-99) , 
3, 0.606045, 0, 0, 0.706846,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237622,-99) , 
0, -0.612827, 1, 0, 0.395814,-99) , 
NN(
0, 
0, 
-1, -1.15484, 0, -1, 0.123664,-99) , 
3, -0.639477, 0, 0, 0.250179,-99) , 
3, 0.191234, 0, 0, 0.469028,-99)    );
  // itree = 1076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11421, 1, 1, 0.857703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392014,-99) , 
1, 0.452007, 1, 0, 0.562604,-99) , 
3, 0.784282, 0, 0, 0.721394,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.242005,-99) , 
3, -0.133228, 0, 0, 0.518551,-99)    );
  // itree = 1077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17464, 1, 1, 0.823333,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275719,-99) , 
0, 0.733856, 1, 0, 0.526597,-99) , 
3, 1.11939, 0, 0, 0.624947,-99) , 
NN(
0, 
0, 
-1, -1.17851, 0, -1, 0.201063,-99) , 
3, -0.2057, 0, 0, 0.449935,-99)    );
  // itree = 1078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57086, 1, 1, 0.840132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372569,-99) , 
0, 0.0287117, 1, 0, 0.594758,-99) , 
3, 0.716715, 0, 0, 0.720647,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146875,-99) , 
0, -1.1687, 1, 0, 0.343743,-99) , 
NN(
0, 
0, 
-1, -1.65652, 0, -1, 0.0916177,-99) , 
3, -0.991836, 0, 0, 0.214046,-99) , 
3, -0.218528, 0, 0, 0.513382,-99)    );
  // itree = 1079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.814497, 0, 1, 0.791043,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220264,-99) , 
0, -0.216638, 1, 0, 0.457919,-99) , 
NN(
0, 
0, 
-1, -1.56443, 0, -1, 0.183674,-99) , 
3, -0.686369, 0, 0, 0.336928,-99) , 
3, 0.402144, 0, 0, 0.52904,-99)    );
  // itree = 1080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.847444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455919,-99) , 
0, 0.027439, 1, 0, 0.573254,-99) , 
3, 1.13676, 0, 0, 0.669054,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225869,-99) , 
0, -1.2662, 1, 0, 0.340538,-99) , 
NN(
0, 
0, 
-1, -0.0776003, 1, -1, 0.0633302,-99) , 
3, -1.20998, 0, 0, 0.22911,-99) , 
3, -0.216753, 0, 0, 0.492387,-99)    );
  // itree = 1081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.35104, 1, 1, 0.823412,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314827,-99) , 
0, -0.345495, 1, 0, 0.47909,-99) , 
NN(
0, 
0, 
-1, -1.64062, 0, -1, 0.191469,-99) , 
3, -0.727114, 0, 0, 0.36605,-99) , 
3, 0.742135, 0, 0, 0.525339,-99)    );
  // itree = 1082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44212, 0, 1, 0.847045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486109,-99) , 
0, 0.027439, 1, 0, 0.59442,-99) , 
3, 1.10114, 0, 0, 0.694538,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184803,-99) , 
0, -0.961002, 1, 0, 0.375729,-99) , 
NN(
0, 
0, 
-1, -0.4734, 1, -1, 0.110849,-99) , 
3, -1.00348, 0, 0, 0.26193,-99) , 
3, -0.0172488, 0, 0, 0.503616,-99)    );
  // itree = 1083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.699401, 1, 1, 0.820584,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214216,-99) , 
0, 0.497677, 1, 0, 0.486912,-99) , 
NN(
0, 
0, 
-1, -0.391179, 1, -1, 0.200076,-99) , 
3, -0.486358, 0, 0, 0.364902,-99) , 
3, 0.677307, 0, 0, 0.507932,-99)    );
  // itree = 1084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08804, 0, 1, 0.811012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465399,-99) , 
3, 0.485931, 0, 0, 0.747004,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245107,-99) , 
0, -0.612827, 1, 0, 0.459861,-99) , 
NN(
0, 
0, 
-1, -1.55025, 0, -1, 0.154167,-99) , 
3, -0.580365, 0, 0, 0.291851,-99) , 
3, 0.27076, 0, 0, 0.504102,-99)    );
  // itree = 1085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.832658,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31309,-99) , 
0, 0.097998, 1, 0, 0.482886,-99) , 
NN(
0, 
0, 
-1, -1.47277, 0, -1, 0.173263,-99) , 
3, -0.570531, 0, 0, 0.365736,-99) , 
3, 0.900715, 0, 0, 0.493932,-99)    );
  // itree = 1086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58151, 1, 1, 0.849985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34705,-99) , 
0, 0.446087, 1, 0, 0.577683,-99) , 
3, 0.959779, 0, 0, 0.72867,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255047,-99) , 
0, -1.44213, 1, 0, 0.323038,-99) , 
NN(
0, 
0, 
-1, 0.0509554, 0, -1, 0.0304033,-99) , 
3, -1.51307, 0, 0, 0.262517,-99) , 
3, 0.131392, 0, 0, 0.492912,-99)    );
  // itree = 1087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.810076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338294,-99) , 
0, -0.000706236, 1, 0, 0.528795,-99) , 
3, 0.700536, 0, 0, 0.668326,-99) , 
NN(
0, 
0, 
-1, -0.996703, 1, -1, 0.201383,-99) , 
3, -0.206128, 0, 0, 0.48299,-99)    );
  // itree = 1088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.812923,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211365,-99) , 
0, 0.437739, 1, 0, 0.457154,-99) , 
NN(
0, 
0, 
-1, -1.57763, 0, -1, 0.139738,-99) , 
3, -0.665309, 0, 0, 0.329835,-99) , 
3, 0.828289, 0, 0, 0.459947,-99)    );
  // itree = 1089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.831916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241431,-99) , 
0, 0.46105, 1, 0, 0.541351,-99) , 
3, 0.64063, 0, 0, 0.715784,-99) , 
NN(
0, 
0, 
-1, -1.52857, 0, -1, 0.243786,-99) , 
3, -0.0447319, 0, 0, 0.509237,-99)    );
  // itree = 1090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.883154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277213,-99) , 
0, 0.879237, 1, 0, 0.600867,-99) , 
3, 1.12807, 0, 0, 0.741444,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23255,-99) , 
0, -0.678004, 1, 0, 0.376776,-99) , 
NN(
0, 
0, 
-1, -1.43197, 0, -1, 0.162419,-99) , 
3, -0.498264, 0, 0, 0.269098,-99) , 
3, 0.322617, 0, 0, 0.469281,-99)    );
  // itree = 1091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.261311, 1, 1, 0.915566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422462,-99) , 
0, 0.975226, 1, 0, 0.653293,-99) , 
3, 1.24194, 0, 0, 0.744791,-99) , 
NN(
0, 
0, 
-1, -1.3957, 0, -1, 0.26409,-99) , 
3, -0.133228, 0, 0, 0.552469,-99)    );
  // itree = 1092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09759, 0, 1, 0.827005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187195,-99) , 
0, 0.500185, 1, 0, 0.515002,-99) , 
3, 0.720251, 0, 0, 0.682738,-99) , 
NN(
0, 
0, 
-1, -1.24788, 0, -1, 0.198688,-99) , 
3, -0.218528, 0, 0, 0.493069,-99)    );
  // itree = 1093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.918837,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334424,-99) , 
0, 0.687285, 1, 0, 0.619755,-99) , 
3, 1.11733, 0, 0, 0.731736,-99) , 
NN(
0, 
0, 
-1, -1.64606, 0, -1, 0.23623,-99) , 
3, -0.231227, 0, 0, 0.543505,-99)    );
  // itree = 1094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.68621, 0, 1, 0.851318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283067,-99) , 
0, 0.295007, 1, 0, 0.473986,-99) , 
NN(
0, 
0, 
-1, -1.55008, 0, -1, 0.185625,-99) , 
3, -0.376125, 0, 0, 0.333472,-99) , 
3, 0.79068, 0, 0, 0.472962,-99)    );
  // itree = 1095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57208, 0, 1, 0.866058,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301043,-99) , 
0, 0.284185, 1, 0, 0.576754,-99) , 
3, 0.835097, 0, 0, 0.73158,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131139,-99) , 
0, -0.800211, 1, 0, 0.355304,-99) , 
NN(
0, 
0, 
-1, 0.584379, 1, -1, 0.138708,-99) , 
3, -1.0699, 0, 0, 0.266833,-99) , 
3, -0.0725463, 0, 0, 0.520966,-99)    );
  // itree = 1096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.835655,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240394,-99) , 
0, 0.475416, 1, 0, 0.518313,-99) , 
3, 0.758758, 0, 0, 0.689659,-99) , 
NN(
0, 
0, 
-1, -1.58829, 0, -1, 0.215904,-99) , 
3, -0.12622, 0, 0, 0.501068,-99)    );
  // itree = 1097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.845133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371067,-99) , 
0, 0.932042, 1, 0, 0.62456,-99) , 
3, 1.17238, 0, 0, 0.728697,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275034,-99) , 
0, -0.305342, 1, 0, 0.461145,-99) , 
NN(
0, 
0, 
-1, -1.54978, 0, -1, 0.185063,-99) , 
3, -0.414415, 0, 0, 0.300352,-99) , 
3, 0.377562, 0, 0, 0.486306,-99)    );
  // itree = 1098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.915096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365115,-99) , 
0, 1.27385, 1, 0, 0.64564,-99) , 
3, 1.31292, 0, 0, 0.736905,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.230485,-99) , 
3, -0.0447319, 0, 0, 0.505132,-99)    );
  // itree = 1099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0994792, 0, 1, 0.727647,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183815,-99) , 
0, -1.18749, 1, 0, 0.306283,-99) , 
NN(
0, 
0, 
-1, -1.69007, 0, -1, 0.0895616,-99) , 
3, -1.0699, 0, 0, 0.220797,-99) , 
3, -0.0725463, 0, 0, 0.496922,-99)    );
  // itree = 1100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69764, 1, 1, 0.865667,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436344,-99) , 
0, 0.487108, 1, 0, 0.666277,-99) , 
3, 1.0469, 0, 0, 0.751057,-99) , 
NN(
0, 
0, 
-1, -1.58592, 0, -1, 0.290062,-99) , 
3, 0.0391675, 0, 0, 0.534131,-99)    );
  // itree = 1101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.838343,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358206,-99) , 
0, 0.453613, 1, 0, 0.576054,-99) , 
3, 0.965539, 0, 0, 0.69247,-99) , 
NN(
0, 
0, 
-1, -0.477912, 0, -1, 0.208518,-99) , 
3, -0.218528, 0, 0, 0.490452,-99)    );
  // itree = 1102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.82957,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23357,-99) , 
0, 0.179441, 1, 0, 0.461146,-99) , 
NN(
0, 
0, 
-1, -1.70026, 0, -1, 0.166271,-99) , 
3, -0.760607, 0, 0, 0.362414,-99) , 
3, 0.760049, 0, 0, 0.505931,-99)    );
  // itree = 1103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71107, 1, 1, 0.828091,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268604,-99) , 
0, 0.319583, 1, 0, 0.513121,-99) , 
3, 0.913879, 0, 0, 0.656857,-99) , 
NN(
0, 
0, 
-1, -0.929221, 0, -1, 0.207281,-99) , 
3, -0.2003, 0, 0, 0.478711,-99)    );
  // itree = 1104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.15547, 1, 1, 0.922999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429649,-99) , 
0, 1.32006, 1, 0, 0.67674,-99) , 
3, 1.58382, 0, 0, 0.753906,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200647,-99) , 
0, -0.381656, 1, 0, 0.381599,-99) , 
NN(
0, 
0, 
-1, -1.64222, 0, -1, 0.137659,-99) , 
3, -0.751702, 0, 0, 0.271796,-99) , 
3, 0.34753, 0, 0, 0.47529,-99)    );
  // itree = 1105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.18028, 0, 1, 0.649873,-99) , 
NN(
0, 
0, 
-1, -1.53081, 0, -1, 0.125081,-99) , 
3, -0.613987, 0, 0, 0.49743,-99)    );
  // itree = 1106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.862144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43508,-99) , 
0, 0.764278, 1, 0, 0.628437,-99) , 
3, 1.12513, 0, 0, 0.748407,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338359,-99) , 
0, -1.1904, 1, 0, 0.431643,-99) , 
NN(
0, 
0, 
-1, -1.7967, 0, -1, 0.135118,-99) , 
3, -1.01826, 0, 0, 0.328267,-99) , 
3, 0.322617, 0, 0, 0.517337,-99)    );
  // itree = 1107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.848616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385758,-99) , 
0, 0.124346, 1, 0, 0.526968,-99) , 
3, 0.926104, 0, 0, 0.664246,-99) , 
NN(
0, 
0, 
-1, -1.20223, 0, -1, 0.188558,-99) , 
3, -0.206128, 0, 0, 0.467378,-99)    );
  // itree = 1108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.09943, 0, 1, 0.835291,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255105,-99) , 
0, 0.193161, 1, 0, 0.459213,-99) , 
NN(
0, 
0, 
-1, -1.15783, 0, -1, 0.188,-99) , 
3, -0.44611, 0, 0, 0.333979,-99) , 
3, 0.729578, 0, 0, 0.498688,-99)    );
  // itree = 1109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.542186, 1, 1, 0.813043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329013,-99) , 
0, -0.0558779, 1, 0, 0.507143,-99) , 
3, 0.561195, 0, 0, 0.689552,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215491,-99) , 
0, -1.33116, 1, 0, 0.308784,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.0771539,-99) , 
3, -1.14663, 0, 0, 0.227684,-99) , 
3, -0.133228, 0, 0, 0.493608,-99)    );
  // itree = 1110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8206, 1, 1, 0.911738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31094,-99) , 
0, 1.49543, 1, 0, 0.583688,-99) , 
3, 1.37724, 0, 0, 0.668834,-99) , 
NN(
0, 
0, 
-1, -0.710408, 0, -1, 0.24902,-99) , 
3, -0.206128, 0, 0, 0.503653,-99)    );
  // itree = 1111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.39255, 1, 1, 0.909388,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367947,-99) , 
0, 1.37077, 1, 0, 0.71283,-99) , 
3, 1.41674, 0, 0, 0.808157,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202528,-99) , 
0, 0.259256, 1, 0, 0.475427,-99) , 
NN(
0, 
0, 
-1, -1.74083, 0, -1, 0.153248,-99) , 
3, -0.528692, 0, 0, 0.33062,-99) , 
3, 0.673895, 0, 0, 0.482399,-99)    );
  // itree = 1112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.920263,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381209,-99) , 
3, 1.18343, 0, 0, 0.715766,-99) , 
0, 0.97581, 1, 0, 0.778632,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307256,-99) , 
0, -0.456006, 1, 0, 0.436887,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.13124,-99) , 
3, -0.575176, 0, 0, 0.303005,-99) , 
3, 0.609067, 0, 0, 0.453181,-99)    );
  // itree = 1113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.863567,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384709,-99) , 
0, -0.138969, 1, 0, 0.54184,-99) , 
3, 0.949517, 0, 0, 0.676614,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.197775,-99) , 
3, -0.218528, 0, 0, 0.493998,-99)    );
  // itree = 1114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.846512,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294086,-99) , 
0, 0.138796, 1, 0, 0.501748,-99) , 
3, 0.853145, 0, 0, 0.66022,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.162371,-99) , 
3, -0.302053, 0, 0, 0.49892,-99)    );
  // itree = 1115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06967, 0, 1, 0.823821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271931,-99) , 
0, 0.0318178, 1, 0, 0.489349,-99) , 
3, 0.700536, 0, 0, 0.661022,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.183873,-99) , 
3, -0.206128, 0, 0, 0.460044,-99)    );
  // itree = 1116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60699, 1, 1, 0.839407,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263499,-99) , 
0, 0.454465, 1, 0, 0.554434,-99) , 
3, 0.796333, 0, 0, 0.684157,-99) , 
NN(
0, 
0, 
-1, -1.60075, 0, -1, 0.194598,-99) , 
3, -0.346282, 0, 0, 0.525384,-99)    );
  // itree = 1117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.18743, 0, 1, 0.832415,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306232,-99) , 
0, 0.259657, 1, 0, 0.548039,-99) , 
3, 0.628887, 0, 0, 0.700699,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.223124,-99) , 
3, -0.291428, 0, 0, 0.523009,-99)    );
  // itree = 1118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.820334,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252962,-99) , 
0, 0.179441, 1, 0, 0.494808,-99) , 
NN(
0, 
0, 
-1, -1.62359, 0, -1, 0.195018,-99) , 
3, -0.43371, 0, 0, 0.339372,-99) , 
3, 0.742135, 0, 0, 0.489405,-99)    );
  // itree = 1119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.646381, 1, 1, 0.911194,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.898948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437444,-99) , 
3, 1.56264, 0, 0, 0.715481,-99) , 
0, 1.54513, 1, 0, 0.810485,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226809,-99) , 
0, 0.0283268, 1, 0, 0.441302,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.162979,-99) , 
3, -0.582745, 0, 0, 0.316318,-99) , 
3, 0.602686, 0, 0, 0.477752,-99)    );
  // itree = 1120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.827397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386894,-99) , 
0, 0.0112647, 1, 0, 0.569221,-99) , 
3, 0.716715, 0, 0, 0.704589,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.175439,-99) , 
0, -0.897305, 1, 0, 0.333165,-99) , 
NN(
0, 
0, 
-1, -2.55908, 1, -1, 0.12188,-99) , 
3, -0.990191, 0, 0, 0.233717,-99) , 
3, -0.218528, 0, 0, 0.510038,-99)    );
  // itree = 1121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15116, 0, 1, 0.785062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196003,-99) , 
0, 0.271542, 1, 0, 0.482532,-99) , 
3, 0.562429, 0, 0, 0.674905,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198327,-99) , 
0, -1.5543, 1, 0, 0.300212,-99) , 
NN(
0, 
0, 
-1, -0.213943, 1, -1, 0.0923082,-99) , 
3, -1.14247, 0, 0, 0.235107,-99) , 
3, -0.133228, 0, 0, 0.490271,-99)    );
  // itree = 1122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.859066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458521,-99) , 
0, 0.256748, 1, 0, 0.600667,-99) , 
3, 0.904774, 0, 0, 0.759154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588803,-99) , 
NN(
0, 
0, 
-1, -1.62401, 0, -1, 0.267303,-99) , 
3, -0.0252538, 0, 0, 0.320061,-99) , 
3, 0.27076, 0, 0, 0.524476,-99)    );
  // itree = 1123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27856, 1, 1, 0.861752,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297009,-99) , 
0, 0.924863, 1, 0, 0.552141,-99) , 
3, 1.11586, 0, 0, 0.696672,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266387,-99) , 
0, -0.568658, 1, 0, 0.41643,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.158533,-99) , 
3, -0.569108, 0, 0, 0.268466,-99) , 
3, 0.27076, 0, 0, 0.459083,-99)    );
  // itree = 1124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.70747, 0, 1, 0.842208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250315,-99) , 
0, 0.349876, 1, 0, 0.518757,-99) , 
3, 0.839375, 0, 0, 0.659665,-99) , 
NN(
0, 
0, 
-1, -1.48643, 0, -1, 0.149989,-99) , 
3, -0.60255, 0, 0, 0.493001,-99)    );
  // itree = 1125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20127, 1, 1, 0.877925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228732,-99) , 
0, 1.13238, 1, 0, 0.535999,-99) , 
3, 1.18544, 0, 0, 0.639285,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.18364,-99) , 
3, -0.218528, 0, 0, 0.463543,-99)    );
  // itree = 1126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.863084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300249,-99) , 
0, 1.10833, 1, 0, 0.589969,-99) , 
3, 1.18544, 0, 0, 0.683983,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.225867,-99) , 
3, -0.218528, 0, 0, 0.513908,-99)    );
  // itree = 1127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.67812, 0, 1, 0.835753,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158103,-99) , 
0, 0.46957, 1, 0, 0.447073,-99) , 
NN(
0, 
0, 
-1, -1.84606, 0, -1, 0.18164,-99) , 
3, -0.757262, 0, 0, 0.350558,-99) , 
3, 0.643924, 0, 0, 0.51392,-99)    );
  // itree = 1128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.69584, 0, 1, 0.756089,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282983,-99) , 
1, -0.389497, 1, 0, 0.400438,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.152837,-99) , 
3, -0.574972, 0, 0, 0.266313,-99) , 
3, 0.27076, 0, 0, 0.480539,-99)    );
  // itree = 1129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.850738,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327581,-99) , 
0, -0.0789444, 1, 0, 0.531617,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.225287,-99) , 
3, -0.575176, 0, 0, 0.396388,-99) , 
3, 0.609067, 0, 0, 0.570779,-99)    );
  // itree = 1130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56795, 0, 1, 0.821751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315507,-99) , 
0, -0.11235, 1, 0, 0.481732,-99) , 
3, 0.832586, 0, 0, 0.610035,-99) , 
NN(
0, 
0, 
-1, -1.91897, 1, -1, 0.159253,-99) , 
3, -0.707817, 0, 0, 0.474671,-99)    );
  // itree = 1131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.68196, 1, 1, 0.896323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497776,-99) , 
0, 1.02904, 1, 0, 0.675565,-99) , 
3, 1.37778, 0, 0, 0.754127,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340643,-99) , 
0, -0.766228, 1, 0, 0.447238,-99) , 
NN(
0, 
0, 
-1, -1.6543, 0, -1, 0.151367,-99) , 
3, -0.477004, 0, 0, 0.280653,-99) , 
3, 0.34753, 0, 0, 0.482991,-99)    );
  // itree = 1132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.874795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386345,-99) , 
0, 0.214206, 1, 0, 0.556135,-99) , 
3, 1.14037, 0, 0, 0.664758,-99) , 
NN(
0, 
0, 
-1, -1.21221, 0, -1, 0.213869,-99) , 
3, -0.216753, 0, 0, 0.487777,-99)    );
  // itree = 1133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75291, 0, 1, 0.857031,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434337,-99) , 
0, 0.27102, 1, 0, 0.589279,-99) , 
3, 1.06405, 0, 0, 0.69866,-99) , 
NN(
0, 
0, 
-1, -1.56671, 0, -1, 0.201203,-99) , 
3, -0.0725463, 0, 0, 0.472859,-99)    );
  // itree = 1134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.844605,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267268,-99) , 
0, 0.134376, 1, 0, 0.494726,-99) , 
NN(
0, 
0, 
-1, -0.684045, 0, -1, 0.217987,-99) , 
3, -0.156612, 0, 0, 0.334541,-99) , 
3, 0.760049, 0, 0, 0.494711,-99)    );
  // itree = 1135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46147, 1, 1, 0.869466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184668,-99) , 
0, 1.20235, 1, 0, 0.565223,-99) , 
3, 1.14952, 0, 0, 0.648309,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.185624,-99) , 
3, -0.613987, 0, 0, 0.526482,-99)    );
  // itree = 1136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62976, 1, 1, 0.91273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486269,-99) , 
0, -0.24246, 1, 0, 0.574892,-99) , 
3, 1.14843, 0, 0, 0.696296,-99) , 
NN(
0, 
0, 
-1, -0.665663, 0, -1, 0.206945,-99) , 
3, -0.170449, 0, 0, 0.496205,-99)    );
  // itree = 1137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.11537, 1, 1, 0.859687,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411921,-99) , 
0, 0.214206, 1, 0, 0.584879,-99) , 
3, 1.09078, 0, 0, 0.693705,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257567,-99) , 
0, -1.02974, 1, 0, 0.3844,-99) , 
NN(
0, 
0, 
-1, -1.64073, 0, -1, 0.123093,-99) , 
3, -0.771995, 0, 0, 0.228567,-99) , 
3, -0.0295996, 0, 0, 0.479478,-99)    );
  // itree = 1138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28426, 1, 1, 0.828796,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168992,-99) , 
0, 0.667103, 1, 0, 0.556907,-99) , 
3, 0.83881, 0, 0, 0.691096,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.209041,-99) , 
3, -0.0725463, 0, 0, 0.481389,-99)    );
  // itree = 1139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04252, 0, 1, 0.809717,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295556,-99) , 
0, 0.0283268, 1, 0, 0.480661,-99) , 
NN(
0, 
0, 
-1, -1.50162, 1, -1, 0.16202,-99) , 
3, -0.528692, 0, 0, 0.340349,-99) , 
3, 0.673895, 0, 0, 0.501215,-99)    );
  // itree = 1140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26691, 1, 1, 0.844728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429143,-99) , 
0, 0.439034, 1, 0, 0.661646,-99) , 
3, 0.880637, 0, 0, 0.772645,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328572,-99) , 
0, -0.65582, 1, 0, 0.436479,-99) , 
NN(
0, 
0, 
-1, -1.49813, 0, -1, 0.195049,-99) , 
3, -0.55608, 0, 0, 0.310343,-99) , 
3, 0.256412, 0, 0, 0.525593,-99)    );
  // itree = 1141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.883132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323739,-99) , 
0, 1.13238, 1, 0, 0.646677,-99) , 
3, 1.2208, 0, 0, 0.760093,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178106,-99) , 
0, -0.00897209, 1, 0, 0.417528,-99) , 
NN(
0, 
0, 
-1, -2.31713, 1, -1, 0.159533,-99) , 
3, -0.688247, 0, 0, 0.300411,-99) , 
3, 0.402144, 0, 0, 0.486071,-99)    );
  // itree = 1142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66854, 1, 1, 0.855166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327398,-99) , 
0, 0.439034, 1, 0, 0.584866,-99) , 
3, 0.958758, 0, 0, 0.726327,-99) , 
NN(
0, 
0, 
-1, -1.51307, 0, -1, 0.281427,-99) , 
3, 0.125502, 0, 0, 0.510475,-99)    );
  // itree = 1143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68207, 0, 1, 0.88345,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374474,-99) , 
0, 0.87199, 1, 0, 0.601492,-99) , 
3, 1.18232, 0, 0, 0.698977,-99) , 
NN(
0, 
0, 
-1, -1.50393, 0, -1, 0.274156,-99) , 
3, -0.218528, 0, 0, 0.535259,-99)    );
  // itree = 1144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.880533,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218947,-99) , 
0, 0.895088, 1, 0, 0.541997,-99) , 
3, 1.03145, 0, 0, 0.644087,-99) , 
NN(
0, 
0, 
-1, -1.61729, 0, -1, 0.156624,-99) , 
3, -0.703077, 0, 0, 0.529231,-99)    );
  // itree = 1145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09423, 0, 1, 0.847795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25449,-99) , 
0, 0.446546, 1, 0, 0.546958,-99) , 
3, 0.716715, 0, 0, 0.704079,-99) , 
NN(
0, 
0, 
-1, -1.50393, 0, -1, 0.169878,-99) , 
3, -0.218528, 0, 0, 0.499365,-99)    );
  // itree = 1146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.842854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.915035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380027,-99) , 
0, 0.0114807, 1, 0, 0.564544,-99) , 
3, 0.832607, 0, 0, 0.717665,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.233006,-99) , 
3, -0.0725463, 0, 0, 0.485351,-99)    );
  // itree = 1147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.698051, 1, 1, 0.863758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305618,-99) , 
0, 0.454461, 1, 0, 0.54022,-99) , 
3, 0.791647, 0, 0, 0.69941,-99) , 
NN(
0, 
0, 
-1, -0.888858, 0, -1, 0.191823,-99) , 
3, -0.133228, 0, 0, 0.489654,-99)    );
  // itree = 1148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34359, 1, 1, 0.796366,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228249,-99) , 
0, 0.0222503, 1, 0, 0.519579,-99) , 
3, 0.488247, 0, 0, 0.69735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549801,-99) , 
NN(
0, 
0, 
-1, -1.24633, 0, -1, 0.209734,-99) , 
1, -0.964473, 1, 0, 0.259873,-99) , 
3, -0.218528, 0, 0, 0.538689,-99)    );
  // itree = 1149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.83018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216628,-99) , 
0, 0.969329, 1, 0, 0.547082,-99) , 
3, 1.07526, 0, 0, 0.648679,-99) , 
NN(
0, 
0, 
-1, -1.31196, 0, -1, 0.219017,-99) , 
3, -0.302053, 0, 0, 0.502958,-99)    );
  // itree = 1150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.825539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341908,-99) , 
0, -0.0939917, 1, 0, 0.505993,-99) , 
3, 0.674433, 0, 0, 0.683887,-99) , 
NN(
0, 
0, 
-1, -1.24179, 0, -1, 0.232685,-99) , 
3, -0.011497, 0, 0, 0.478451,-99)    );
  // itree = 1151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.863015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454796,-99) , 
0, 0.444075, 1, 0, 0.613697,-99) , 
3, 1.01964, 0, 0, 0.747381,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282135,-99) , 
0, -0.862067, 1, 0, 0.424001,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.178287,-99) , 
3, -0.641438, 0, 0, 0.288106,-99) , 
3, 0.191234, 0, 0, 0.503384,-99)    );
  // itree = 1152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16212, 1, 1, 0.864615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433549,-99) , 
0, 0.101849, 1, 0, 0.547375,-99) , 
3, 1.20171, 0, 0, 0.635676,-99) , 
NN(
0, 
0, 
-1, -1.68094, 0, -1, 0.180814,-99) , 
3, -0.547237, 0, 0, 0.494431,-99)    );
  // itree = 1153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42719, 1, 1, 0.878537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.969852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398013,-99) , 
0, -0.181794, 1, 0, 0.547403,-99) , 
3, 0.864726, 0, 0, 0.71389,-99) , 
NN(
0, 
0, 
-1, -1.52753, 0, -1, 0.264122,-99) , 
3, -0.0426953, 0, 0, 0.512252,-99)    );
  // itree = 1154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11223, 0, 1, 0.798727,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312211,-99) , 
0, -0.0428066, 1, 0, 0.496957,-99) , 
3, 0.751012, 0, 0, 0.62246,-99) , 
NN(
0, 
0, 
-1, -1.70372, 0, -1, 0.158048,-99) , 
3, -0.774089, 0, 0, 0.512448,-99)    );
  // itree = 1155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.877539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375525,-99) , 
0, 0.91729, 1, 0, 0.688948,-99) , 
3, 1.11463, 0, 0, 0.781699,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317101,-99) , 
0, -0.838601, 1, 0, 0.427632,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.186212,-99) , 
3, -0.580365, 0, 0, 0.291554,-99) , 
3, 0.27076, 0, 0, 0.515469,-99)    );
  // itree = 1156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.858694, 0, 1, 0.837845,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254416,-99) , 
0, 0.231365, 1, 0, 0.490128,-99) , 
NN(
0, 
0, 
-1, -1.0171, 0, -1, 0.185914,-99) , 
3, -0.524691, 0, 0, 0.369585,-99) , 
3, 0.673895, 0, 0, 0.527976,-99)    );
  // itree = 1157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.834938,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296598,-99) , 
0, 0.163923, 1, 0, 0.556657,-99) , 
3, 0.62211, 0, 0, 0.701549,-99) , 
NN(
0, 
0, 
-1, -1.32203, 0, -1, 0.17849,-99) , 
3, -0.302053, 0, 0, 0.498519,-99)    );
  // itree = 1158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63458, 1, 1, 0.850973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379429,-99) , 
0, 0.488, 1, 0, 0.601221,-99) , 
3, 0.926594, 0, 0, 0.754634,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505145,-99) , 
NN(
0, 
0, 
-1, -1.2855, 0, -1, 0.237127,-99) , 
1, -0.684744, 1, 0, 0.282706,-99) , 
3, 0.322617, 0, 0, 0.499345,-99)    );
  // itree = 1159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52219, 1, 1, 0.832088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337029,-99) , 
0, 0.0878292, 1, 0, 0.562738,-99) , 
3, 0.642833, 0, 0, 0.719397,-99) , 
NN(
0, 
0, 
-1, -1.52857, 0, -1, 0.266261,-99) , 
3, -0.0447319, 0, 0, 0.50442,-99)    );
  // itree = 1160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.22964, 1, 1, 0.877876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36741,-99) , 
0, 0.699891, 1, 0, 0.592545,-99) , 
3, 1.18232, 0, 0, 0.687919,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.218553,-99) , 
3, -0.218528, 0, 0, 0.504812,-99)    );
  // itree = 1161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.832904,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2593,-99) , 
0, 0.341578, 1, 0, 0.563448,-99) , 
3, 0.784282, 0, 0, 0.70257,-99) , 
NN(
0, 
0, 
-1, -0.640241, 0, -1, 0.212205,-99) , 
3, -0.133228, 0, 0, 0.498981,-99)    );
  // itree = 1162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59399, 0, 1, 0.788759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2524,-99) , 
0, -0.035315, 1, 0, 0.429687,-99) , 
NN(
0, 
0, 
-1, -1.74319, 0, -1, 0.151587,-99) , 
3, -0.528692, 0, 0, 0.304925,-99) , 
3, 0.673895, 0, 0, 0.450013,-99)    );
  // itree = 1163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.737153, 0, 1, 0.903418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380124,-99) , 
3, 1.09903, 0, 0, 0.697685,-99) , 
0, 0.905154, 1, 0, 0.772507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270601,-99) , 
0, -0.859104, 1, 0, 0.379593,-99) , 
NN(
0, 
0, 
-1, -1.65914, 0, -1, 0.0993799,-99) , 
3, -1.31624, 0, 0, 0.315241,-99) , 
3, 0.295236, 0, 0, 0.508095,-99)    );
  // itree = 1164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832823, 0, 1, 0.816266,-99) , 
NN(
0, 
0, 
-1, -1.19089, 0, -1, 0.310363,-99) , 
3, 0.427177, 0, 0, 0.508237,-99)    );
  // itree = 1165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.97581, 1, 1, 0.828125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386829,-99) , 
0, 0.00909672, 1, 0, 0.529841,-99) , 
3, 0.637508, 0, 0, 0.702656,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282944,-99) , 
0, -1.20904, 1, 0, 0.371181,-99) , 
NN(
0, 
0, 
-1, -1.83475, 0, -1, 0.110685,-99) , 
3, -1.03347, 0, 0, 0.265081,-99) , 
3, -0.0426953, 0, 0, 0.500555,-99)    );
  // itree = 1166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.863351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447459,-99) , 
0, 0.262153, 1, 0, 0.646029,-99) , 
3, 0.870114, 0, 0, 0.782789,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229921,-99) , 
0, -0.341503, 1, 0, 0.454695,-99) , 
NN(
0, 
0, 
-1, -1.72786, 0, -1, 0.165304,-99) , 
3, -0.554775, 0, 0, 0.298634,-99) , 
3, 0.256412, 0, 0, 0.518415,-99)    );
  // itree = 1167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.867169,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42101,-99) , 
0, 0.830155, 1, 0, 0.658676,-99) , 
3, 1.17269, 0, 0, 0.763583,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291183,-99) , 
0, -0.959568, 1, 0, 0.381031,-99) , 
NN(
0, 
0, 
-1, -2.82701, 1, -1, 0.107058,-99) , 
3, -1.02909, 0, 0, 0.290821,-99) , 
3, 0.34753, 0, 0, 0.500121,-99)    );
  // itree = 1168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.825364,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295851,-99) , 
0, -0.0153026, 1, 0, 0.491574,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.160084,-99) , 
3, -0.535926, 0, 0, 0.342633,-99) , 
3, 0.661338, 0, 0, 0.501641,-99)    );
  // itree = 1169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71961, 0, 1, 0.867558,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305432,-99) , 
0, 0.913386, 1, 0, 0.591474,-99) , 
3, 1.02305, 0, 0, 0.705036,-99) , 
NN(
0, 
0, 
-1, -1.14068, 0, -1, 0.225766,-99) , 
3, -0.133228, 0, 0, 0.5081,-99)    );
  // itree = 1170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.847387,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283093,-99) , 
0, 0.143304, 1, 0, 0.491447,-99) , 
NN(
0, 
0, 
-1, -1.69392, 1, -1, 0.182723,-99) , 
3, -0.59289, 0, 0, 0.366722,-99) , 
3, 0.876835, 0, 0, 0.49821,-99)    );
  // itree = 1171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66703, 0, 1, 0.851499,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448367,-99) , 
0, 0.0304304, 1, 0, 0.58605,-99) , 
3, 0.952846, 0, 0, 0.697505,-99) , 
NN(
0, 
0, 
-1, -1.2441, 0, -1, 0.214267,-99) , 
3, -0.218528, 0, 0, 0.513104,-99)    );
  // itree = 1172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.900274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33342,-99) , 
0, 1.32989, 1, 0, 0.691735,-99) , 
3, 1.41017, 0, 0, 0.782659,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357896,-99) , 
0, -0.790342, 1, 0, 0.455972,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.188994,-99) , 
3, -0.524691, 0, 0, 0.332802,-99) , 
3, 0.673895, 0, 0, 0.485349,-99)    );
  // itree = 1173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.894458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356091,-99) , 
0, 0.91729, 1, 0, 0.661441,-99) , 
3, 1.11419, 0, 0, 0.772913,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308145,-99) , 
0, -0.795814, 1, 0, 0.438313,-99) , 
NN(
0, 
0, 
-1, -1.0799, 0, -1, 0.159719,-99) , 
3, -0.580365, 0, 0, 0.279857,-99) , 
3, 0.27076, 0, 0, 0.492796,-99)    );
  // itree = 1174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.877204,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404816,-99) , 
0, 0.790737, 1, 0, 0.66101,-99) , 
3, 1.11419, 0, 0, 0.769041,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233279,-99) , 
0, -0.357805, 1, 0, 0.428403,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.170639,-99) , 
3, -0.569108, 0, 0, 0.287093,-99) , 
3, 0.27076, 0, 0, 0.504847,-99)    );
  // itree = 1175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.790294, 1, 1, 0.981667,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.898972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4578,-99) , 
3, 1.44758, 0, 0, 0.736421,-99) , 
0, 1.17505, 1, 0, 0.81894,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192925,-99) , 
0, 0.227133, 1, 0, 0.446838,-99) , 
NN(
0, 
0, 
-1, -1.51296, 0, -1, 0.137393,-99) , 
3, -0.82328, 0, 0, 0.341848,-99) , 
3, 0.673895, 0, 0, 0.487133,-99)    );
  // itree = 1176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.89507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354637,-99) , 
0, 0.803606, 1, 0, 0.636086,-99) , 
3, 1.12707, 0, 0, 0.756168,-99) , 
NN(
0, 
0, 
-1, -1.55274, 0, -1, 0.266765,-99) , 
3, 0.322617, 0, 0, 0.476665,-99)    );
  // itree = 1177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.806483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332656,-99) , 
0, -0.0319407, 1, 0, 0.531943,-99) , 
3, 0.740664, 0, 0, 0.674504,-99) , 
NN(
0, 
0, 
-1, -1.56755, 0, -1, 0.228272,-99) , 
3, -0.358721, 0, 0, 0.530549,-99)    );
  // itree = 1178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.84688,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429627,-99) , 
0, -0.0228119, 1, 0, 0.602091,-99) , 
3, 0.784282, 0, 0, 0.738997,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.195164,-99) , 
3, -0.133228, 0, 0, 0.504119,-99)    );
  // itree = 1179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.35232, 1, 1, 0.921089,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494629,-99) , 
0, 1.42338, 1, 0, 0.75124,-99) , 
3, 1.55945, 0, 0, 0.818037,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300187,-99) , 
0, 0.138796, 1, 0, 0.511795,-99) , 
NN(
0, 
0, 
-1, -1.00344, 1, -1, 0.209324,-99) , 
3, -0.249592, 0, 0, 0.334993,-99) , 
3, 0.644232, 0, 0, 0.494971,-99)    );
  // itree = 1180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8507, 1, 1, 0.902488,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498318,-99) , 
0, 1.23357, 1, 0, 0.709087,-99) , 
3, 1.32218, 0, 0, 0.82486,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.951363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375422,-99) , 
0, -0.744779, 1, 0, 0.468482,-99) , 
NN(
0, 
0, 
-1, -1.18998, 0, -1, 0.180733,-99) , 
3, -0.451773, 0, 0, 0.330755,-99) , 
3, 0.760049, 0, 0, 0.491618,-99)    );
  // itree = 1181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36694, 1, 1, 0.800835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244025,-99) , 
0, 0.134912, 1, 0, 0.515484,-99) , 
3, 0.633338, 0, 0, 0.688785,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21927,-99) , 
0, -1.45821, 1, 0, 0.356941,-99) , 
NN(
0, 
0, 
-1, -2.04121, 0, -1, 0.0833656,-99) , 
3, -1.24452, 0, 0, 0.245055,-99) , 
3, -0.260982, 0, 0, 0.512416,-99)    );
  // itree = 1182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10923, 0, 1, 0.797204,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443116,-99) , 
0, -0.855501, 1, 0, 0.523419,-99) , 
3, 0.731039, 0, 0, 0.648775,-99) , 
NN(
0, 
0, 
-1, -1.48781, 0, -1, 0.164587,-99) , 
3, -0.783748, 0, 0, 0.5231,-99)    );
  // itree = 1183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.88903, 1, 1, 0.89124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.931606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466834,-99) , 
0, 0.603249, 1, 0, 0.672599,-99) , 
3, 1.1266, 0, 0, 0.811569,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172318,-99) , 
0, 0.324034, 1, 0, 0.460457,-99) , 
NN(
0, 
0, 
-1, -1.48124, 0, -1, 0.18631,-99) , 
3, -0.552676, 0, 0, 0.339308,-99) , 
3, 0.595596, 0, 0, 0.504811,-99)    );
  // itree = 1184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.807389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38009,-99) , 
0, -0.0844621, 1, 0, 0.568854,-99) , 
3, 0.561195, 0, 0, 0.728774,-99) , 
NN(
0, 
0, 
-1, -1.64431, 0, -1, 0.245608,-99) , 
3, -0.133228, 0, 0, 0.539719,-99)    );
  // itree = 1185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.863549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326975,-99) , 
0, 0.076294, 1, 0, 0.525802,-99) , 
3, 0.790869, 0, 0, 0.693496,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.20198,-99) , 
3, -0.133228, 0, 0, 0.497633,-99)    );
  // itree = 1186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.899654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.913576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470621,-99) , 
0, 0.254627, 1, 0, 0.688045,-99) , 
3, 0.951162, 0, 0, 0.796629,-99) , 
NN(
0, 
0, 
-1, -1.23391, 0, -1, 0.291845,-99) , 
3, 0.131392, 0, 0, 0.547978,-99)    );
  // itree = 1187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13594, 0, 1, 0.814871,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217996,-99) , 
0, 0.572114, 1, 0, 0.464039,-99) , 
NN(
0, 
0, 
-1, -1.45297, 0, -1, 0.157909,-99) , 
3, -0.754651, 0, 0, 0.350095,-99) , 
3, 0.760049, 0, 0, 0.493296,-99)    );
  // itree = 1188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.57693, 1, 1, 0.829668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393069,-99) , 
0, 0.573823, 1, 0, 0.660399,-99) , 
3, 0.938224, 0, 0, 0.766055,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233598,-99) , 
0, -0.150485, 1, 0, 0.439038,-99) , 
NN(
0, 
0, 
-1, -1.1799, 0, -1, 0.177842,-99) , 
3, -0.726823, 0, 0, 0.321952,-99) , 
3, 0.336059, 0, 0, 0.517189,-99)    );
  // itree = 1189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.683046, 1, 1, 0.949332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46832,-99) , 
3, 1.23955, 0, 0, 0.756715,-99) , 
0, 1.11421, 1, 0, 0.820888,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218866,-99) , 
0, 0.231365, 1, 0, 0.49212,-99) , 
NN(
0, 
0, 
-1, -1.50598, 0, -1, 0.23535,-99) , 
3, -0.226102, 0, 0, 0.340928,-99) , 
3, 0.673895, 0, 0, 0.5026,-99)    );
  // itree = 1190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.831245,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239958,-99) , 
0, 0.158188, 1, 0, 0.44728,-99) , 
NN(
0, 
0, 
-1, -1.1077, 0, -1, 0.16263,-99) , 
3, -0.652226, 0, 0, 0.350514,-99) , 
3, 0.783269, 0, 0, 0.475457,-99)    );
  // itree = 1191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.1533, 0, 1, 0.81159,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34216,-99) , 
1, -0.733145, 1, 0, 0.43503,-99) , 
NN(
0, 
0, 
-1, -1.55336, 0, -1, 0.146976,-99) , 
3, -0.658515, 0, 0, 0.322479,-99) , 
3, 0.79068, 0, 0, 0.458812,-99)    );
  // itree = 1192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47342, 0, 1, 0.856937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426125,-99) , 
0, 0.886872, 1, 0, 0.668884,-99) , 
3, 1.15842, 0, 0, 0.780077,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184938,-99) , 
0, 0.0640693, 1, 0, 0.421746,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.191114,-99) , 
3, -0.582745, 0, 0, 0.313006,-99) , 
3, 0.609067, 0, 0, 0.469335,-99)    );
  // itree = 1193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.872284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426765,-99) , 
0, 0.488, 1, 0, 0.620814,-99) , 
3, 0.870114, 0, 0, 0.773294,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297286,-99) , 
0, -0.559502, 1, 0, 0.433808,-99) , 
NN(
0, 
0, 
-1, -1.50624, 0, -1, 0.184621,-99) , 
3, -0.55608, 0, 0, 0.294226,-99) , 
3, 0.256412, 0, 0, 0.51214,-99)    );
  // itree = 1194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.826299,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267282,-99) , 
0, -0.0153026, 1, 0, 0.528221,-99) , 
3, 0.641734, 0, 0, 0.664971,-99) , 
NN(
0, 
0, 
-1, -1.47232, 0, -1, 0.165162,-99) , 
3, -0.582913, 0, 0, 0.513547,-99)    );
  // itree = 1195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.834609, 0, 1, 0.752697,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327573,-99) , 
0, -0.790342, 1, 0, 0.428066,-99) , 
NN(
0, 
0, 
-1, -1.54252, 0, -1, 0.178781,-99) , 
3, -0.651582, 0, 0, 0.327486,-99) , 
3, 0.427177, 0, 0, 0.496146,-99)    );
  // itree = 1196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.873525,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400749,-99) , 
0, 0.865651, 1, 0, 0.674747,-99) , 
3, 1.17573, 0, 0, 0.775379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29077,-99) , 
0, -0.35931, 1, 0, 0.483789,-99) , 
NN(
0, 
0, 
-1, -0.677103, 1, -1, 0.221422,-99) , 
3, -0.2022, 0, 0, 0.29413,-99) , 
3, 0.34753, 0, 0, 0.490593,-99)    );
  // itree = 1197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.876577,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452498,-99) , 
0, -0.00244444, 1, 0, 0.577184,-99) , 
3, 1.08882, 0, 0, 0.689953,-99) , 
NN(
0, 
0, 
-1, -1.52735, 0, -1, 0.244599,-99) , 
3, -0.0426953, 0, 0, 0.486457,-99)    );
  // itree = 1198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35496, 0, 1, 0.858269,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341386,-99) , 
0, 0.654863, 1, 0, 0.599245,-99) , 
3, 1.00695, 0, 0, 0.72901,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313026,-99) , 
0, -0.678004, 1, 0, 0.464105,-99) , 
NN(
0, 
0, 
-1, -1.62466, 0, -1, 0.211037,-99) , 
3, -0.372938, 0, 0, 0.303183,-99) , 
3, 0.179643, 0, 0, 0.509093,-99)    );
  // itree = 1199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.837964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465527,-99) , 
0, 0.539213, 1, 0, 0.63524,-99) , 
3, 1.11291, 0, 0, 0.740326,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295392,-99) , 
0, -1.43925, 1, 0, 0.360813,-99) , 
NN(
0, 
0, 
-1, -1.77865, 0, -1, 0.0773293,-99) , 
3, -1.13339, 0, 0, 0.284709,-99) , 
3, 0.27076, 0, 0, 0.485102,-99)    );
  // itree = 1200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.612601, 1, 1, 0.939227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38959,-99) , 
3, 1.20222, 0, 0, 0.711909,-99) , 
0, 1.08069, 1, 0, 0.785764,-99) , 
NN(
0, 
0, 
-1, -1.14247, 0, -1, 0.311493,-99) , 
3, 0.644232, 0, 0, 0.470444,-99)    );
  // itree = 1201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.851573,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397468,-99) , 
0, -0.328864, 1, 0, 0.5437,-99) , 
3, 0.707229, 0, 0, 0.705551,-99) , 
NN(
0, 
0, 
-1, -1.70223, 0, -1, 0.235659,-99) , 
3, -0.206128, 0, 0, 0.517613,-99)    );
  // itree = 1202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66572, 1, 1, 0.860939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415693,-99) , 
0, 0.761283, 1, 0, 0.626851,-99) , 
3, 1.11463, 0, 0, 0.751764,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170624,-99) , 
0, -0.357805, 1, 0, 0.41551,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.189546,-99) , 
3, -0.582449, 0, 0, 0.290193,-99) , 
3, 0.27076, 0, 0, 0.492441,-99)    );
  // itree = 1203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40403, 0, 1, 0.839818,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443138,-99) , 
0, 0.462892, 1, 0, 0.60672,-99) , 
3, 1.05898, 0, 0, 0.739623,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199118,-99) , 
0, -0.0663113, 1, 0, 0.462669,-99) , 
NN(
0, 
0, 
-1, -1.49375, 0, -1, 0.172397,-99) , 
3, -0.620641, 0, 0, 0.33885,-99) , 
3, 0.451912, 0, 0, 0.500289,-99)    );
  // itree = 1204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45963, 0, 1, 0.855669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251097,-99) , 
0, 0.638313, 1, 0, 0.561845,-99) , 
3, 0.946828, 0, 0, 0.73915,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186526,-99) , 
0, -0.111037, 1, 0, 0.412976,-99) , 
NN(
0, 
0, 
-1, -1.15158, 0, -1, 0.135515,-99) , 
3, -0.720335, 0, 0, 0.266876,-99) , 
3, 0.34765, 0, 0, 0.477802,-99)    );
  // itree = 1205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26793, 1, 1, 0.843083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439622,-99) , 
0, -0.02649, 1, 0, 0.589262,-99) , 
3, 0.95337, 0, 0, 0.691446,-99) , 
NN(
0, 
0, 
-1, -1.50393, 0, -1, 0.221968,-99) , 
3, -0.218528, 0, 0, 0.513044,-99)    );
  // itree = 1206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15636, 0, 1, 0.827664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329327,-99) , 
0, -0.0272996, 1, 0, 0.501699,-99) , 
3, 0.598954, 0, 0, 0.688289,-99) , 
NN(
0, 
0, 
-1, -1.58187, 0, -1, 0.170608,-99) , 
3, -0.316527, 0, 0, 0.487711,-99)    );
  // itree = 1207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.82536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376737,-99) , 
0, 0.0477724, 1, 0, 0.561861,-99) , 
3, 0.628149, 0, 0, 0.704925,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.236012,-99) , 
3, -0.291428, 0, 0, 0.542947,-99)    );
  // itree = 1208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.842377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295943,-99) , 
0, 0.405701, 1, 0, 0.544155,-99) , 
3, 0.849125, 0, 0, 0.677191,-99) , 
NN(
0, 
0, 
-1, -0.297941, 1, -1, 0.181096,-99) , 
3, -0.302053, 0, 0, 0.479434,-99)    );
  // itree = 1209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.834443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338166,-99) , 
0, 0.62132, 1, 0, 0.590394,-99) , 
3, 0.96671, 0, 0, 0.7513,-99) , 
NN(
0, 
0, 
-1, -1.57815, 0, -1, 0.312487,-99) , 
3, 0.34753, 0, 0, 0.499685,-99)    );
  // itree = 1210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27856, 1, 1, 0.845479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300029,-99) , 
0, 0.0681851, 1, 0, 0.533752,-99) , 
3, 0.727702, 0, 0, 0.698343,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176834,-99) , 
0, -1.53016, 1, 0, 0.281431,-99) , 
NN(
0, 
0, 
-1, -1.63, 1, -1, 0.00676732,-99) , 
3, -1.50247, 0, 0, 0.193961,-99) , 
3, -0.218528, 0, 0, 0.493542,-99)    );
  // itree = 1211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5594, 0, 1, 0.8334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252958,-99) , 
0, 0.295007, 1, 0, 0.525104,-99) , 
3, 0.628149, 0, 0, 0.701213,-99) , 
NN(
0, 
0, 
-1, -1.05968, 0, -1, 0.203949,-99) , 
3, -0.291428, 0, 0, 0.532812,-99)    );
  // itree = 1212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.36973, 1, 1, 0.867877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398998,-99) , 
0, 0.404522, 1, 0, 0.586888,-99) , 
3, 1.12367, 0, 0, 0.680852,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190307,-99) , 
0, -1.39661, 1, 0, 0.35496,-99) , 
NN(
0, 
0, 
-1, 0.46382, 0, -1, 0.0635801,-99) , 
3, -1.22361, 0, 0, 0.244918,-99) , 
3, -0.231227, 0, 0, 0.522083,-99)    );
  // itree = 1213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68664, 0, 1, 0.852165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333349,-99) , 
0, 0.137842, 1, 0, 0.529398,-99) , 
3, 0.98113, 0, 0, 0.657405,-99) , 
NN(
0, 
0, 
-1, -0.569189, 1, -1, 0.133146,-99) , 
3, -0.516641, 0, 0, 0.509992,-99)    );
  // itree = 1214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.86722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255695,-99) , 
0, 0.91729, 1, 0, 0.618985,-99) , 
3, 1.06682, 0, 0, 0.734839,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233825,-99) , 
0, -0.861249, 1, 0, 0.384089,-99) , 
NN(
0, 
0, 
-1, -1.67993, 0, -1, 0.0958087,-99) , 
3, -1.022, 0, 0, 0.269765,-99) , 
3, 0.0559666, 0, 0, 0.518049,-99)    );
  // itree = 1215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.891022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279539,-99) , 
0, 1.03728, 1, 0, 0.598543,-99) , 
3, 1.15996, 0, 0, 0.721148,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287086,-99) , 
0, -0.907446, 1, 0, 0.407328,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.150794,-99) , 
3, -0.699803, 0, 0, 0.257175,-99) , 
3, 0.125502, 0, 0, 0.482127,-99)    );
  // itree = 1216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24838, 1, 1, 0.832881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313989,-99) , 
0, 0.408308, 1, 0, 0.546646,-99) , 
3, 0.850553, 0, 0, 0.66703,-99) , 
NN(
0, 
0, 
-1, -0.76089, 0, -1, 0.199904,-99) , 
3, -0.266382, 0, 0, 0.488669,-99)    );
  // itree = 1217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.860167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296382,-99) , 
0, 0.87199, 1, 0, 0.595854,-99) , 
3, 1.14037, 0, 0, 0.689819,-99) , 
NN(
0, 
0, 
-1, -0.968076, 0, -1, 0.244662,-99) , 
3, -0.216753, 0, 0, 0.515228,-99)    );
  // itree = 1218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98325, 1, 1, 0.889,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194035,-99) , 
0, 0.868468, 1, 0, 0.543896,-99) , 
3, 1.07526, 0, 0, 0.65461,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.185581,-99) , 
3, -0.302053, 0, 0, 0.480055,-99)    );
  // itree = 1219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.36679, 1, 1, 0.923211,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413848,-99) , 
0, 1.40292, 1, 0, 0.715028,-99) , 
3, 1.6311, 0, 0, 0.776856,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287373,-99) , 
1, -0.0589514, 1, 0, 0.473393,-99) , 
NN(
0, 
0, 
-1, -0.780667, 1, -1, 0.161948,-99) , 
3, -0.415323, 0, 0, 0.300198,-99) , 
3, 0.402144, 0, 0, 0.494055,-99)    );
  // itree = 1220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.5327, 0, 1, 0.824058,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328778,-99) , 
0, -0.0310664, 1, 0, 0.470228,-99) , 
NN(
0, 
0, 
-1, -1.50433, 0, -1, 0.167829,-99) , 
3, -0.61537, 0, 0, 0.343129,-99) , 
3, 0.825038, 0, 0, 0.48693,-99)    );
  // itree = 1221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42435, 1, 1, 0.861662,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204897,-99) , 
0, 0.985639, 1, 0, 0.539032,-99) , 
3, 1.05069, 0, 0, 0.697809,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243332,-99) , 
0, -0.607343, 1, 0, 0.435069,-99) , 
NN(
0, 
0, 
-1, -1.50704, 0, -1, 0.16549,-99) , 
3, -0.576579, 0, 0, 0.285489,-99) , 
3, 0.240623, 0, 0, 0.484513,-99)    );
  // itree = 1222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32004, 0, 1, 0.843611,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293628,-99) , 
0, -0.0319407, 1, 0, 0.48886,-99) , 
NN(
0, 
0, 
-1, -1.43294, 0, -1, 0.188308,-99) , 
3, -0.451773, 0, 0, 0.347655,-99) , 
3, 0.760049, 0, 0, 0.497462,-99)    );
  // itree = 1223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.617042, 0, 1, 0.759402,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211355,-99) , 
0, -0.0748989, 1, 0, 0.48649,-99) , 
NN(
0, 
0, 
-1, -1.58031, 0, -1, 0.217638,-99) , 
3, -0.414993, 0, 0, 0.347005,-99) , 
3, 0.402144, 0, 0, 0.508231,-99)    );
  // itree = 1224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62444, 0, 1, 0.856181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380847,-99) , 
0, 0.488, 1, 0, 0.600008,-99) , 
3, 0.900389, 0, 0, 0.749513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515446,-99) , 
NN(
0, 
0, 
-1, -1.41259, 0, -1, 0.217305,-99) , 
1, -0.948332, 1, 0, 0.26755,-99) , 
3, 0.27076, 0, 0, 0.50181,-99)    );
  // itree = 1225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66808, 0, 1, 0.866228,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472643,-99) , 
0, -0.294473, 1, 0, 0.58242,-99) , 
3, 0.949517, 0, 0, 0.713089,-99) , 
NN(
0, 
0, 
-1, -0.991836, 0, -1, 0.189724,-99) , 
3, -0.218528, 0, 0, 0.503394,-99)    );
  // itree = 1226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25435, 1, 1, 0.883449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380588,-99) , 
0, 0.376975, 1, 0, 0.563634,-99) , 
3, 1.19836, 0, 0, 0.651979,-99) , 
NN(
0, 
0, 
-1, -1.45512, 0, -1, 0.120122,-99) , 
3, -0.547237, 0, 0, 0.505961,-99)    );
  // itree = 1227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.841179,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228455,-99) , 
0, 0.919284, 1, 0, 0.57713,-99) , 
3, 1.16803, 0, 0, 0.667943,-99) , 
NN(
0, 
0, 
-1, -0.620008, 0, -1, 0.227252,-99) , 
3, -0.139251, 0, 0, 0.487602,-99)    );
  // itree = 1228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.777339, 1, 1, 0.770743,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271177,-99) , 
0, -0.193811, 1, 0, 0.480215,-99) , 
NN(
0, 
0, 
-1, -1.58876, 0, -1, 0.191384,-99) , 
3, -0.449744, 0, 0, 0.311398,-99) , 
3, 0.349483, 0, 0, 0.512485,-99)    );
  // itree = 1229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.846634,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307028,-99) , 
0, 0.242272, 1, 0, 0.507452,-99) , 
NN(
0, 
0, 
-1, -1.09043, 0, -1, 0.240806,-99) , 
3, -0.0707763, 0, 0, 0.350154,-99) , 
3, 0.828289, 0, 0, 0.498314,-99)    );
  // itree = 1230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.892513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295611,-99) , 
0, 0.54926, 1, 0, 0.53807,-99) , 
3, 1.10656, 0, 0, 0.637728,-99) , 
NN(
0, 
0, 
-1, -1.50654, 0, -1, 0.153197,-99) , 
3, -0.613509, 0, 0, 0.492432,-99)    );
  // itree = 1231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3356, 1, 1, 0.887086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193108,-99) , 
0, 0.87884, 1, 0, 0.534438,-99) , 
3, 1.11733, 0, 0, 0.66115,-99) , 
NN(
0, 
0, 
-1, -0.729923, 0, -1, 0.212091,-99) , 
3, -0.231227, 0, 0, 0.482147,-99)    );
  // itree = 1232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.818745,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368997,-99) , 
0, -1.21256, 1, 0, 0.422489,-99) , 
NN(
0, 
0, 
-1, -0.206791, 1, -1, 0.090409,-99) , 
3, -1.12187, 0, 0, 0.340539,-99) , 
3, 0.673895, 0, 0, 0.487059,-99)    );
  // itree = 1233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.881005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393174,-99) , 
0, 0.884423, 1, 0, 0.617247,-99) , 
3, 1.29673, 0, 0, 0.729637,-99) , 
NN(
0, 
0, 
-1, -0.994763, 0, -1, 0.263597,-99) , 
3, 0.312544, 0, 0, 0.464944,-99)    );
  // itree = 1234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8206, 1, 1, 0.894369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397686,-99) , 
0, 1.09595, 1, 0, 0.687921,-99) , 
3, 1.28513, 0, 0, 0.775776,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335024,-99) , 
0, -1.39798, 1, 0, 0.407448,-99) , 
NN(
0, 
0, 
-1, -1.78884, 0, -1, 0.0837447,-99) , 
3, -1.09074, 0, 0, 0.30641,-99) , 
3, 0.268003, 0, 0, 0.514645,-99)    );
  // itree = 1235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0289228, 1, 1, 0.832935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346056,-99) , 
0, -0.147815, 1, 0, 0.49885,-99) , 
3, 0.849125, 0, 0, 0.646433,-99) , 
NN(
0, 
0, 
-1, -1.32133, 0, -1, 0.187831,-99) , 
3, -0.302053, 0, 0, 0.469075,-99)    );
  // itree = 1236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.844298,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458223,-99) , 
3, 0.480859, 0, 0, 0.58359,-99) , 
3, 0.812842, 0, 0, 0.74832,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240426,-99) , 
0, -0.612827, 1, 0, 0.383999,-99) , 
NN(
0, 
0, 
-1, -1.66614, 0, -1, 0.147621,-99) , 
3, -0.639477, 0, 0, 0.263955,-99) , 
3, 0.191234, 0, 0, 0.487603,-99)    );
  // itree = 1237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5594, 0, 1, 0.832558,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318633,-99) , 
0, 0.138796, 1, 0, 0.549305,-99) , 
3, 0.628149, 0, 0, 0.707993,-99) , 
NN(
0, 
0, 
-1, -1.56253, 0, -1, 0.221735,-99) , 
3, -0.291428, 0, 0, 0.521885,-99)    );
  // itree = 1238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14008, 1, 1, 0.823118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462024,-99) , 
0, -0.363814, 1, 0, 0.548908,-99) , 
3, 0.95337, 0, 0, 0.663085,-99) , 
NN(
0, 
0, 
-1, -0.992301, 0, -1, 0.190143,-99) , 
3, -0.218528, 0, 0, 0.455861,-99)    );
  // itree = 1239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.816708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307251,-99) , 
0, 0.500185, 1, 0, 0.551942,-99) , 
3, 0.861778, 0, 0, 0.683755,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251323,-99) , 
0, -1.08306, 1, 0, 0.421621,-99) , 
NN(
0, 
0, 
-1, -1.43567, 0, -1, 0.162678,-99) , 
3, -0.787139, 0, 0, 0.271049,-99) , 
3, -0.0447319, 0, 0, 0.50377,-99)    );
  // itree = 1240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11624, 0, 1, 0.832308,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341057,-99) , 
0, 0.0208352, 1, 0, 0.480289,-99) , 
NN(
0, 
0, 
-1, -1.17822, 0, -1, 0.180399,-99) , 
3, -0.448915, 0, 0, 0.33965,-99) , 
3, 0.729578, 0, 0, 0.497023,-99)    );
  // itree = 1241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.844853, 0, 1, 0.925797,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419586,-99) , 
3, 1.4819, 0, 0, 0.718089,-99) , 
0, 1.37559, 1, 0, 0.804643,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366625,-99) , 
1, -1.04839, 1, 0, 0.432059,-99) , 
NN(
0, 
0, 
-1, -1.62463, 0, -1, 0.160073,-99) , 
3, -0.727114, 0, 0, 0.32676,-99) , 
3, 0.742135, 0, 0, 0.465453,-99)    );
  // itree = 1242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25435, 1, 1, 0.904764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483218,-99) , 
0, 1.3532, 1, 0, 0.731526,-99) , 
3, 1.39559, 0, 0, 0.825051,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133418,-99) , 
0, 0.46957, 1, 0, 0.458197,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.186006,-99) , 
3, -0.542305, 0, 0, 0.346222,-99) , 
3, 0.661338, 0, 0, 0.504905,-99)    );
  // itree = 1243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60811, 1, 1, 0.895522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.918935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477391,-99) , 
0, 1.12528, 1, 0, 0.708191,-99) , 
3, 1.19347, 0, 0, 0.820768,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160533,-99) , 
0, 0.395321, 1, 0, 0.466812,-99) , 
NN(
0, 
0, 
-1, 0.45974, 1, -1, 0.131475,-99) , 
3, -0.548039, 0, 0, 0.299508,-99) , 
3, 0.644232, 0, 0, 0.474103,-99)    );
  // itree = 1244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47056, 1, 1, 0.793323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36894,-99) , 
0, 0.128051, 1, 0, 0.57466,-99) , 
3, 0.716715, 0, 0, 0.687698,-99) , 
NN(
0, 
0, 
-1, -1.50435, 0, -1, 0.211994,-99) , 
3, -0.218528, 0, 0, 0.502365,-99)    );
  // itree = 1245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.885459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271404,-99) , 
0, 0.975226, 1, 0, 0.602994,-99) , 
3, 1.25029, 0, 0, 0.700268,-99) , 
NN(
0, 
0, 
-1, -0.556365, 0, -1, 0.22181,-99) , 
3, -0.0734617, 0, 0, 0.48742,-99)    );
  // itree = 1246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.853079,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365848,-99) , 
0, -0.0272996, 1, 0, 0.546804,-99) , 
3, 0.716715, 0, 0, 0.711068,-99) , 
NN(
0, 
0, 
-1, -0.990191, 0, -1, 0.208405,-99) , 
3, -0.218528, 0, 0, 0.505455,-99)    );
  // itree = 1247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.62696, 1, 1, 0.896666,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.906573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475093,-99) , 
3, 1.57834, 0, 0, 0.730031,-99) , 
0, 1.34735, 1, 0, 0.80649,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265765,-99) , 
0, 0.295007, 1, 0, 0.507823,-99) , 
NN(
0, 
0, 
-1, -1.55464, 0, -1, 0.202349,-99) , 
3, -0.287571, 0, 0, 0.348135,-99) , 
3, 0.602686, 0, 0, 0.515062,-99)    );
  // itree = 1248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.921852,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.934026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432369,-99) , 
0, 1.27829, 1, 0, 0.758107,-99) , 
3, 1.34228, 0, 0, 0.841651,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261868,-99) , 
0, -0.165823, 1, 0, 0.466551,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.207631,-99) , 
3, -0.576554, 0, 0, 0.357477,-99) , 
3, 0.609067, 0, 0, 0.521449,-99)    );
  // itree = 1249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.966476,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.876136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472955,-99) , 
3, 1.50741, 0, 0, 0.735587,-99) , 
0, 1.21129, 1, 0, 0.815063,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287493,-99) , 
0, 0.328047, 1, 0, 0.465743,-99) , 
NN(
0, 
0, 
-1, -1.73882, 0, -1, 0.130411,-99) , 
3, -0.922473, 0, 0, 0.366018,-99) , 
3, 0.795375, 0, 0, 0.502612,-99)    );
  // itree = 1250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20324, 0, 1, 0.8554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397572,-99) , 
0, 0.453613, 1, 0, 0.651631,-99) , 
3, 0.965539, 0, 0, 0.743701,-99) , 
NN(
0, 
0, 
-1, -0.990191, 0, -1, 0.206585,-99) , 
3, -0.218528, 0, 0, 0.535118,-99)    );
  // itree = 1251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.763081, 0, 1, 0.732059,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171935,-99) , 
0, 0.0190781, 1, 0, 0.405803,-99) , 
NN(
0, 
0, 
-1, -1.1834, 0, -1, 0.173958,-99) , 
3, -0.476904, 0, 0, 0.281426,-99) , 
3, 0.34753, 0, 0, 0.477587,-99)    );
  // itree = 1252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.841865,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309249,-99) , 
0, -0.0219476, 1, 0, 0.498052,-99) , 
NN(
0, 
0, 
-1, -1.15815, 0, -1, 0.172073,-99) , 
3, -0.446363, 0, 0, 0.352226,-99) , 
3, 0.729578, 0, 0, 0.494622,-99)    );
  // itree = 1253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.606045, 0, 1, 0.735436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264902,-99) , 
0, -0.341503, 1, 0, 0.432779,-99) , 
NN(
0, 
0, 
-1, -1.34993, 0, -1, 0.132604,-99) , 
3, -0.639477, 0, 0, 0.286618,-99) , 
3, 0.191234, 0, 0, 0.501511,-99)    );
  // itree = 1254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.871455,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316142,-99) , 
0, 1.08247, 1, 0, 0.624706,-99) , 
3, 1.22881, 0, 0, 0.718036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274712,-99) , 
0, -0.843998, 1, 0, 0.393947,-99) , 
NN(
0, 
0, 
-1, -1.9253, 1, -1, 0.119,-99) , 
3, -0.641438, 0, 0, 0.242776,-99) , 
3, 0.191234, 0, 0, 0.476342,-99)    );
  // itree = 1255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.844291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302245,-99) , 
0, 0.500185, 1, 0, 0.53981,-99) , 
3, 0.969023, 0, 0, 0.672389,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.208174,-99) , 
3, -0.145446, 0, 0, 0.482969,-99)    );
  // itree = 1256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02376, 1, 1, 0.819862,-99) , 
NN(
0, 
0, 
-1, -1.12187, 0, -1, 0.332601,-99) , 
3, 0.673895, 0, 0, 0.499343,-99)    );
  // itree = 1257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.823157,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389164,-99) , 
0, 0.563868, 1, 0, 0.575621,-99) , 
3, 0.96671, 0, 0, 0.734297,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337977,-99) , 
0, -0.766228, 1, 0, 0.460606,-99) , 
NN(
0, 
0, 
-1, -0.642544, 1, -1, 0.165555,-99) , 
3, -0.477004, 0, 0, 0.294974,-99) , 
3, 0.34753, 0, 0, 0.48036,-99)    );
  // itree = 1258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.873989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388162,-99) , 
0, 0.515789, 1, 0, 0.599799,-99) , 
3, 1.13676, 0, 0, 0.692748,-99) , 
NN(
0, 
0, 
-1, -1.20998, 0, -1, 0.177799,-99) , 
3, -0.216753, 0, 0, 0.479219,-99)    );
  // itree = 1259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08941, 1, 1, 0.819399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346435,-99) , 
0, -0.02649, 1, 0, 0.520177,-99) , 
3, 0.91488, 0, 0, 0.648389,-99) , 
NN(
0, 
0, 
-1, -0.718728, 0, -1, 0.220743,-99) , 
3, -0.216753, 0, 0, 0.467754,-99)    );
  // itree = 1260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.60746, 0, 1, 0.723456,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243586,-99) , 
0, -0.795814, 1, 0, 0.404929,-99) , 
NN(
0, 
0, 
-1, -1.11378, 0, -1, 0.134098,-99) , 
3, -0.641438, 0, 0, 0.245012,-99) , 
3, 0.191234, 0, 0, 0.465812,-99)    );
  // itree = 1261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44726, 0, 1, 0.87631,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358085,-99) , 
0, 0.45842, 1, 0, 0.571257,-99) , 
3, 1.09078, 0, 0, 0.704551,-99) , 
NN(
0, 
0, 
-1, -0.527553, 0, -1, 0.221604,-99) , 
3, -0.0295996, 0, 0, 0.485598,-99)    );
  // itree = 1262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14402, 1, 1, 0.846622,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345168,-99) , 
0, 0.143304, 1, 0, 0.519544,-99) , 
3, 0.951244, 0, 0, 0.647011,-99) , 
NN(
0, 
0, 
-1, -1.47386, 0, -1, 0.128467,-99) , 
3, -0.547237, 0, 0, 0.489279,-99)    );
  // itree = 1263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73748, 0, 1, 0.839043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406251,-99) , 
0, -0.257043, 1, 0, 0.530106,-99) , 
3, 0.857975, 0, 0, 0.66909,-99) , 
NN(
0, 
0, 
-1, -1.57422, 0, -1, 0.183831,-99) , 
3, -0.291428, 0, 0, 0.507054,-99)    );
  // itree = 1264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.882902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240028,-99) , 
0, 0.927227, 1, 0, 0.506464,-99) , 
3, 1.06041, 0, 0, 0.630183,-99) , 
NN(
0, 
0, 
-1, -1.58422, 0, -1, 0.136676,-99) , 
3, -0.680259, 0, 0, 0.489923,-99)    );
  // itree = 1265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.83235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357394,-99) , 
0, 0.0112647, 1, 0, 0.529588,-99) , 
3, 0.932403, 0, 0, 0.657427,-99) , 
NN(
0, 
0, 
-1, -0.478841, 1, -1, 0.185443,-99) , 
3, -0.206128, 0, 0, 0.470796,-99)    );
  // itree = 1266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.890293,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.894792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425221,-99) , 
0, 0.488, 1, 0, 0.635268,-99) , 
3, 1.11005, 0, 0, 0.763707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594948,-99) , 
NN(
0, 
0, 
-1, -1.08387, 0, -1, 0.248807,-99) , 
3, -0.0100424, 0, 0, 0.306467,-99) , 
3, 0.27076, 0, 0, 0.514736,-99)    );
  // itree = 1267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.876697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332359,-99) , 
0, 0.687285, 1, 0, 0.579289,-99) , 
3, 1.13988, 0, 0, 0.678166,-99) , 
NN(
0, 
0, 
-1, -1.46478, 0, -1, 0.223071,-99) , 
3, -0.216753, 0, 0, 0.494093,-99)    );
  // itree = 1268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04569, 1, 1, 0.856546,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27724,-99) , 
0, 0.0578584, 1, 0, 0.420393,-99) , 
NN(
0, 
0, 
-1, 0.154445, 0, -1, 0.0484507,-99) , 
3, -1.23854, 0, 0, 0.349545,-99) , 
3, 0.79068, 0, 0, 0.490887,-99)    );
  // itree = 1269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04252, 0, 1, 0.785573,-99) , 
NN(
0, 
0, 
-1, -1.13339, 0, -1, 0.352408,-99) , 
3, 0.673895, 0, 0, 0.487822,-99)    );
  // itree = 1270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.10779, 1, 1, 0.907726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393037,-99) , 
0, 1.02904, 1, 0, 0.658705,-99) , 
3, 1.32676, 0, 0, 0.761149,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194526,-99) , 
0, -0.150485, 1, 0, 0.410862,-99) , 
NN(
0, 
0, 
-1, -1.62501, 0, -1, 0.112815,-99) , 
3, -0.751433, 0, 0, 0.287925,-99) , 
3, 0.322617, 0, 0, 0.500257,-99)    );
  // itree = 1271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.26098, 1, 1, 0.934084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483249,-99) , 
0, 1.14736, 1, 0, 0.710226,-99) , 
3, 1.53342, 0, 0, 0.770191,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178774,-99) , 
0, -0.132257, 1, 0, 0.396087,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.152985,-99) , 
3, -0.574972, 0, 0, 0.263495,-99) , 
3, 0.27076, 0, 0, 0.480461,-99)    );
  // itree = 1272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31919, 1, 1, 0.856083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420301,-99) , 
0, -0.651705, 1, 0, 0.516279,-99) , 
3, 0.628149, 0, 0, 0.700885,-99) , 
NN(
0, 
0, 
-1, -1.57306, 0, -1, 0.194174,-99) , 
3, -0.291428, 0, 0, 0.522472,-99)    );
  // itree = 1273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36045, 1, 1, 0.854901,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234659,-99) , 
0, 0.0510396, 1, 0, 0.440479,-99) , 
NN(
0, 
0, 
-1, -1.6781, 0, -1, 0.18898,-99) , 
3, -0.451773, 0, 0, 0.319609,-99) , 
3, 0.760049, 0, 0, 0.480306,-99)    );
  // itree = 1274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11116, 0, 1, 0.845531,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288015,-99) , 
0, 0.08705, 1, 0, 0.488402,-99) , 
NN(
0, 
0, 
-1, -1.15783, 0, -1, 0.196865,-99) , 
3, -0.43371, 0, 0, 0.338278,-99) , 
3, 0.742135, 0, 0, 0.490498,-99)    );
  // itree = 1275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.834295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469419,-99) , 
0, 0.0681851, 1, 0, 0.59791,-99) , 
3, 1.00568, 0, 0, 0.695902,-99) , 
NN(
0, 
0, 
-1, -0.589261, 0, -1, 0.194171,-99) , 
3, -0.102499, 0, 0, 0.489396,-99)    );
  // itree = 1276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.840423,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237598,-99) , 
0, 0.441334, 1, 0, 0.564091,-99) , 
NN(
0, 
0, 
-1, -1.0219, 0, -1, 0.230154,-99) , 
3, 0.0589627, 0, 0, 0.336003,-99) , 
3, 0.661338, 0, 0, 0.503446,-99)    );
  // itree = 1277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.854867,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203198,-99) , 
0, 0.398957, 1, 0, 0.470256,-99) , 
NN(
0, 
0, 
-1, -1.56523, 0, -1, 0.144636,-99) , 
3, -0.676071, 0, 0, 0.334683,-99) , 
3, 0.778124, 0, 0, 0.483209,-99)    );
  // itree = 1278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.848216,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341391,-99) , 
0, 0.146168, 1, 0, 0.570483,-99) , 
3, 0.740764, 0, 0, 0.712511,-99) , 
NN(
0, 
0, 
-1, -1.59916, 0, -1, 0.225408,-99) , 
3, -0.142731, 0, 0, 0.514024,-99)    );
  // itree = 1279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.861219,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349722,-99) , 
0, 0.394197, 1, 0, 0.595559,-99) , 
3, 0.968938, 0, 0, 0.756266,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219898,-99) , 
0, -0.345495, 1, 0, 0.425987,-99) , 
NN(
0, 
0, 
-1, -1.64222, 0, -1, 0.13105,-99) , 
3, -0.751608, 0, 0, 0.282449,-99) , 
3, 0.34753, 0, 0, 0.494953,-99)    );
  // itree = 1280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.790921, 1, 1, 0.7699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275726,-99) , 
0, -0.0558779, 1, 0, 0.512648,-99) , 
3, 0.507145, 0, 0, 0.667561,-99) , 
NN(
0, 
0, 
-1, -0.735788, 0, -1, 0.195946,-99) , 
3, -0.218528, 0, 0, 0.483805,-99)    );
  // itree = 1281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11116, 0, 1, 0.838292,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252815,-99) , 
0, 0.179441, 1, 0, 0.487271,-99) , 
NN(
0, 
0, 
-1, -2.07347, 1, -1, 0.181159,-99) , 
3, -0.43371, 0, 0, 0.331619,-99) , 
3, 0.742135, 0, 0, 0.48965,-99)    );
  // itree = 1282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.69429, 0, 1, 0.81843,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260047,-99) , 
0, -0.0152916, 1, 0, 0.437295,-99) , 
NN(
0, 
0, 
-1, -1.6834, 0, -1, 0.138228,-99) , 
3, -0.760607, 0, 0, 0.332988,-99) , 
3, 0.760049, 0, 0, 0.47769,-99)    );
  // itree = 1283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.855284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874004,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473448,-99) , 
0, 0.27102, 1, 0, 0.660707,-99) , 
3, 1.06094, 0, 0, 0.746548,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250188,-99) , 
0, -0.993852, 1, 0, 0.391971,-99) , 
NN(
0, 
0, 
-1, -1.74672, 0, -1, 0.118093,-99) , 
3, -1.06971, 0, 0, 0.284846,-99) , 
3, -0.0725463, 0, 0, 0.535579,-99)    );
  // itree = 1284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.816137,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592615,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201502,-99) , 
0, 0.402597, 1, 0, 0.4653,-99) , 
NN(
0, 
0, 
-1, -1.22006, 0, -1, 0.157771,-99) , 
3, -0.479546, 0, 0, 0.325682,-99) , 
3, 0.760049, 0, 0, 0.477202,-99)    );
  // itree = 1285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.97581, 1, 1, 0.809977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272531,-99) , 
1, 0.234105, 1, 0, 0.469734,-99) , 
3, 0.582527, 0, 0, 0.621071,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.134277,-99) , 
3, -0.707817, 0, 0, 0.482612,-99)    );
  // itree = 1286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65997, 0, 1, 0.818661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404235,-99) , 
0, 0.076294, 1, 0, 0.557626,-99) , 
3, 0.949517, 0, 0, 0.675028,-99) , 
NN(
0, 
0, 
-1, -1.50435, 0, -1, 0.198721,-99) , 
3, -0.218528, 0, 0, 0.487056,-99)    );
  // itree = 1287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39312, 0, 1, 0.823024,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394335,-99) , 
0, -0.257043, 1, 0, 0.508046,-99) , 
3, 0.857975, 0, 0, 0.648055,-99) , 
NN(
0, 
0, 
-1, -0.799257, 0, -1, 0.201169,-99) , 
3, -0.291428, 0, 0, 0.494001,-99)    );
  // itree = 1288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58571, 0, 1, 0.829033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311223,-99) , 
0, 0.408308, 1, 0, 0.537608,-99) , 
3, 0.907469, 0, 0, 0.679475,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169939,-99) , 
0, -1.08805, 1, 0, 0.3268,-99) , 
NN(
0, 
0, 
-1, -1.77532, 0, -1, 0.0817765,-99) , 
3, -1.17172, 0, 0, 0.217281,-99) , 
3, -0.2003, 0, 0, 0.485578,-99)    );
  // itree = 1289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13381, 0, 1, 0.811651,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291775,-99) , 
0, 0.0208352, 1, 0, 0.487259,-99) , 
NN(
0, 
0, 
-1, -1.18778, 0, -1, 0.197748,-99) , 
3, -0.451773, 0, 0, 0.350265,-99) , 
3, 0.760049, 0, 0, 0.501828,-99)    );
  // itree = 1290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.833419, 0, 1, 0.775763,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285091,-99) , 
0, -0.742158, 1, 0, 0.401619,-99) , 
NN(
0, 
0, 
-1, -1.56971, 0, -1, 0.164858,-99) , 
3, -0.398079, 0, 0, 0.277448,-99) , 
3, 0.427177, 0, 0, 0.469196,-99)    );
  // itree = 1291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.64252, 0, 1, 0.875786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25731,-99) , 
0, 0.927932, 1, 0, 0.592886,-99) , 
3, 1.15758, 0, 0, 0.700589,-99) , 
NN(
0, 
0, 
-1, -1.20632, 0, -1, 0.184098,-99) , 
3, -0.206128, 0, 0, 0.498026,-99)    );
  // itree = 1292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.97227, 1, 1, 0.873456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328523,-99) , 
0, 1.07644, 1, 0, 0.664043,-99) , 
3, 1.082, 0, 0, 0.773188,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312659,-99) , 
0, -1.33849, 1, 0, 0.388902,-99) , 
NN(
0, 
0, 
-1, -1.71933, 0, -1, 0.108468,-99) , 
3, -1.09074, 0, 0, 0.304336,-99) , 
3, 0.268003, 0, 0, 0.510853,-99)    );
  // itree = 1293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44277, 0, 1, 0.840652,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257385,-99) , 
0, 0.408308, 1, 0, 0.493474,-99) , 
3, 0.926104, 0, 0, 0.627264,-99) , 
NN(
0, 
0, 
-1, -1.20223, 0, -1, 0.186995,-99) , 
3, -0.206128, 0, 0, 0.458566,-99)    );
  // itree = 1294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11834, 0, 1, 0.905349,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.90442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49113,-99) , 
3, 1.71429, 0, 0, 0.729118,-99) , 
0, 1.54631, 1, 0, 0.811392,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206618,-99) , 
0, 0.431079, 1, 0, 0.444925,-99) , 
NN(
0, 
0, 
-1, -0.00674708, 1, -1, 0.167637,-99) , 
3, -0.45279, 0, 0, 0.313755,-99) , 
3, 0.760049, 0, 0, 0.448821,-99)    );
  // itree = 1295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12957, 0, 1, 0.762965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417861,-99) , 
3, 0.018307, 0, 0, 0.709311,-99) , 
NN(
0, 
0, 
-1, -1.7619, 0, -1, 0.238527,-99) , 
3, -0.218528, 0, 0, 0.53477,-99)    );
  // itree = 1296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.09943, 0, 1, 0.786723,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184923,-99) , 
0, 0.565386, 1, 0, 0.495948,-99) , 
NN(
0, 
0, 
-1, -1.63187, 0, -1, 0.196642,-99) , 
3, -0.445426, 0, 0, 0.350823,-99) , 
3, 0.729578, 0, 0, 0.493756,-99)    );
  // itree = 1297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20116, 0, 1, 0.70597,-99) , 
NN(
0, 
0, 
-1, -0.617192, 0, -1, 0.231778,-99) , 
3, -0.128257, 0, 0, 0.518405,-99)    );
  // itree = 1298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.966756, 0, 1, 0.806011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255989,-99) , 
0, -0.0153026, 1, 0, 0.427848,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.151626,-99) , 
3, -0.57899, 0, 0, 0.321877,-99) , 
3, 0.602686, 0, 0, 0.480203,-99)    );
  // itree = 1299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13594, 0, 1, 0.815091,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245634,-99) , 
0, 0.151182, 1, 0, 0.428111,-99) , 
NN(
0, 
0, 
-1, -1.72852, 0, -1, 0.0904259,-99) , 
3, -1.06396, 0, 0, 0.344993,-99) , 
3, 0.760049, 0, 0, 0.479971,-99)    );
  // itree = 1300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42459, 1, 1, 0.869595,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326492,-99) , 
0, 1.07644, 1, 0, 0.629179,-99) , 
3, 1.10998, 0, 0, 0.729329,-99) , 
NN(
0, 
0, 
-1, -0.536968, 0, -1, 0.264266,-99) , 
3, -0.0295996, 0, 0, 0.523787,-99)    );
  // itree = 1301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.575913, 0, 1, 0.720145,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269565,-99) , 
0, -0.815876, 1, 0, 0.412598,-99) , 
NN(
0, 
0, 
-1, -1.84667, 0, -1, 0.132899,-99) , 
3, -0.662162, 0, 0, 0.256501,-99) , 
3, 0.163853, 0, 0, 0.476274,-99)    );
  // itree = 1302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.829217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268626,-99) , 
0, 0.231365, 1, 0, 0.517281,-99) , 
3, 0.627829, 0, 0, 0.691339,-99) , 
NN(
0, 
0, 
-1, -0.961181, 0, -1, 0.22057,-99) , 
3, -0.241626, 0, 0, 0.495631,-99)    );
  // itree = 1303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.776599, 0, 1, 0.89109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39234,-99) , 
3, 1.38598, 0, 0, 0.65612,-99) , 
0, 1.23915, 1, 0, 0.762614,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250033,-99) , 
0, -0.233559, 1, 0, 0.438415,-99) , 
NN(
0, 
0, 
-1, 0.130065, 1, -1, 0.204928,-99) , 
3, -0.184778, 0, 0, 0.276875,-99) , 
3, 0.349678, 0, 0, 0.463263,-99)    );
  // itree = 1304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.828421,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261609,-99) , 
0, 0.757883, 1, 0, 0.560182,-99) , 
3, 0.900389, 0, 0, 0.720182,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189609,-99) , 
0, -0.216638, 1, 0, 0.374609,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.155561,-99) , 
3, -0.569108, 0, 0, 0.264579,-99) , 
3, 0.27076, 0, 0, 0.464562,-99)    );
  // itree = 1305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34501, 0, 1, 0.823423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277855,-99) , 
0, 0.506819, 1, 0, 0.533962,-99) , 
3, 0.789704, 0, 0, 0.67631,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.238598,-99) , 
3, -0.133228, 0, 0, 0.491253,-99)    );
  // itree = 1306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8507, 1, 1, 0.899007,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.93933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499351,-99) , 
0, -0.0354634, 1, 0, 0.628775,-99) , 
3, 1.28678, 0, 0, 0.716317,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.229442,-99) , 
3, -0.0725463, 0, 0, 0.504624,-99)    );
  // itree = 1307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63458, 1, 1, 0.864977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405142,-99) , 
0, 0.683618, 1, 0, 0.600886,-99) , 
3, 1.00602, 0, 0, 0.734198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315263,-99) , 
0, -0.843998, 1, 0, 0.451925,-99) , 
NN(
0, 
0, 
-1, -1.14246, 0, -1, 0.155215,-99) , 
3, -0.646522, 0, 0, 0.291186,-99) , 
3, 0.179643, 0, 0, 0.508503,-99)    );
  // itree = 1308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3002, 1, 1, 0.828344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286104,-99) , 
0, 0.341578, 1, 0, 0.55869,-99) , 
3, 0.692201, 0, 0, 0.700086,-99) , 
NN(
0, 
0, 
-1, -1.17106, 0, -1, 0.220042,-99) , 
3, -0.2003, 0, 0, 0.51319,-99)    );
  // itree = 1309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50157, 1, 1, 0.923951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479647,-99) , 
0, 1.48909, 1, 0, 0.736153,-99) , 
3, 1.60275, 0, 0, 0.811089,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271556,-99) , 
0, -0.0153026, 1, 0, 0.451099,-99) , 
NN(
0, 
0, 
-1, -1.0199, 0, -1, 0.13211,-99) , 
3, -0.536792, 0, 0, 0.317693,-99) , 
3, 0.673895, 0, 0, 0.48453,-99)    );
  // itree = 1310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.828797,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258418,-99) , 
0, 0.324034, 1, 0, 0.529468,-99) , 
3, 0.646791, 0, 0, 0.681803,-99) , 
NN(
0, 
0, 
-1, -0.0720244, 1, -1, 0.179413,-99) , 
3, -0.613987, 0, 0, 0.541768,-99)    );
  // itree = 1311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.847123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360126,-99) , 
0, 0.453613, 1, 0, 0.541432,-99) , 
3, 1.09053, 0, 0, 0.651486,-99) , 
NN(
0, 
0, 
-1, -0.391179, 1, -1, 0.214632,-99) , 
3, -0.291428, 0, 0, 0.495336,-99)    );
  // itree = 1312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.861812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353543,-99) , 
0, 1.07644, 1, 0, 0.613504,-99) , 
3, 1.14618, 0, 0, 0.746214,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262902,-99) , 
0, -0.345495, 1, 0, 0.451955,-99) , 
NN(
0, 
0, 
-1, -1.58149, 0, -1, 0.170618,-99) , 
3, -0.720335, 0, 0, 0.317651,-99) , 
3, 0.34765, 0, 0, 0.490341,-99)    );
  // itree = 1313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.786383,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263118,-99) , 
1, 0.527824, 1, 0, 0.473312,-99) , 
3, 0.566131, 0, 0, 0.618967,-99) , 
NN(
0, 
0, 
-1, -1.77286, 0, -1, 0.168474,-99) , 
3, -0.663377, 0, 0, 0.497242,-99)    );
  // itree = 1314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34359, 1, 1, 0.842128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457348,-99) , 
3, 0.47683, 0, 0, 0.772797,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291689,-99) , 
0, -0.752686, 1, 0, 0.409329,-99) , 
NN(
0, 
0, 
-1, -1.70201, 0, -1, 0.126058,-99) , 
3, -0.825152, 0, 0, 0.282879,-99) , 
3, 0.256412, 0, 0, 0.505154,-99)    );
  // itree = 1315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25435, 1, 1, 0.841241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450256,-99) , 
0, 0.254627, 1, 0, 0.563094,-99) , 
3, 0.924535, 0, 0, 0.725015,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295992,-99) , 
0, -0.477384, 1, 0, 0.447549,-99) , 
NN(
0, 
0, 
-1, -2.08352, 1, -1, 0.161475,-99) , 
3, -0.483771, 0, 0, 0.289382,-99) , 
3, 0.322617, 0, 0, 0.48362,-99)    );
  // itree = 1316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.795785,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245371,-99) , 
0, 0.539155, 1, 0, 0.461923,-99) , 
NN(
0, 
0, 
-1, -1.72342, 0, -1, 0.089547,-99) , 
3, -1.06396, 0, 0, 0.368344,-99) , 
3, 0.760049, 0, 0, 0.508559,-99)    );
  // itree = 1317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50157, 1, 1, 0.934172,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425543,-99) , 
0, 1.37077, 1, 0, 0.702381,-99) , 
3, 1.59399, 0, 0, 0.799362,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309174,-99) , 
0, 0.144487, 1, 0, 0.511756,-99) , 
NN(
0, 
0, 
-1, -1.50598, 0, -1, 0.210689,-99) , 
3, -0.226102, 0, 0, 0.348666,-99) , 
3, 0.673895, 0, 0, 0.498371,-99)    );
  // itree = 1318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04325, 0, 1, 0.823685,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240805,-99) , 
0, -0.0165485, 1, 0, 0.449774,-99) , 
NN(
0, 
0, 
-1, -1.51536, 0, -1, 0.146083,-99) , 
3, -0.524691, 0, 0, 0.312665,-99) , 
3, 0.673895, 0, 0, 0.4785,-99)    );
  // itree = 1319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.701765, 1, 1, 0.948425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447309,-99) , 
3, 1.16053, 0, 0, 0.760607,-99) , 
0, 1.00567, 1, 0, 0.823831,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350577,-99) , 
0, -0.952624, 1, 0, 0.437791,-99) , 
NN(
0, 
0, 
-1, -0.211632, 1, -1, 0.0926185,-99) , 
3, -1.12549, 0, 0, 0.351435,-99) , 
3, 0.595596, 0, 0, 0.5242,-99)    );
  // itree = 1320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0183455, 1, 1, 0.848267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399652,-99) , 
0, 0.488, 1, 0, 0.596115,-99) , 
3, 0.900389, 0, 0, 0.749811,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255302,-99) , 
0, -0.65582, 1, 0, 0.392584,-99) , 
NN(
0, 
0, 
-1, -1.06267, 0, -1, 0.160488,-99) , 
3, -0.58167, 0, 0, 0.263571,-99) , 
3, 0.27076, 0, 0, 0.473651,-99)    );
  // itree = 1321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25435, 1, 1, 0.88702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40647,-99) , 
0, 1.31188, 1, 0, 0.724394,-99) , 
3, 1.41252, 0, 0, 0.799763,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243156,-99) , 
0, 0.0208352, 1, 0, 0.455965,-99) , 
NN(
0, 
0, 
-1, -1.50365, 0, -1, 0.188983,-99) , 
3, -0.535926, 0, 0, 0.336958,-99) , 
3, 0.673895, 0, 0, 0.493733,-99)    );
  // itree = 1322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.836174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282323,-99) , 
0, -0.0721965, 1, 0, 0.450636,-99) , 
NN(
0, 
0, 
-1, -1.22342, 0, -1, 0.141664,-99) , 
3, -0.760607, 0, 0, 0.339849,-99) , 
3, 0.760049, 0, 0, 0.486158,-99)    );
  // itree = 1323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71429, 0, 1, 0.837137,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23264,-99) , 
0, 0.481313, 1, 0, 0.520166,-99) , 
3, 0.784282, 0, 0, 0.682733,-99) , 
NN(
0, 
0, 
-1, -0.89189, 0, -1, 0.215864,-99) , 
3, -0.133228, 0, 0, 0.487721,-99)    );
  // itree = 1324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.01143, 1, 1, 0.837999,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236704,-99) , 
0, 0.158188, 1, 0, 0.498784,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.180017,-99) , 
3, -0.524691, 0, 0, 0.344201,-99) , 
3, 0.673895, 0, 0, 0.507166,-99)    );
  // itree = 1325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.829332,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195234,-99) , 
0, 0.497677, 1, 0, 0.477961,-99) , 
NN(
0, 
0, 
-1, -1.22254, 0, -1, 0.147571,-99) , 
3, -0.754651, 0, 0, 0.357014,-99) , 
3, 0.760049, 0, 0, 0.511727,-99)    );
  // itree = 1326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0760756, 1, 1, 0.846081,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407357,-99) , 
0, 0.446087, 1, 0, 0.573628,-99) , 
3, 0.862443, 0, 0, 0.74756,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258255,-99) , 
0, -0.65582, 1, 0, 0.43335,-99) , 
NN(
0, 
0, 
-1, -1.21885, 0, -1, 0.141664,-99) , 
3, -0.537876, 0, 0, 0.259477,-99) , 
3, 0.256886, 0, 0, 0.468272,-99)    );
  // itree = 1327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09272, 0, 1, 0.944827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455754,-99) , 
3, 1.42264, 0, 0, 0.695329,-99) , 
0, 1.11079, 1, 0, 0.77063,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340045,-99) , 
0, -0.742611, 1, 0, 0.438868,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.17048,-99) , 
3, -0.531196, 0, 0, 0.307872,-99) , 
3, 0.673895, 0, 0, 0.463026,-99)    );
  // itree = 1328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.824424,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241928,-99) , 
0, 0.06353, 1, 0, 0.429212,-99) , 
NN(
0, 
0, 
-1, -1.71131, 0, -1, 0.117226,-99) , 
3, -1.05753, 0, 0, 0.352964,-99) , 
3, 0.760049, 0, 0, 0.495262,-99)    );
  // itree = 1329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47786, 1, 1, 0.795402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259141,-99) , 
0, 0.454461, 1, 0, 0.536084,-99) , 
3, 0.802394, 0, 0, 0.646077,-99) , 
NN(
0, 
0, 
-1, -1.10075, 0, -1, 0.201536,-99) , 
3, -0.346282, 0, 0, 0.500291,-99)    );
  // itree = 1330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42914, 0, 1, 0.68678,-99) , 
NN(
0, 
0, 
-1, -1.2441, 0, -1, 0.196421,-99) , 
3, -0.218528, 0, 0, 0.502084,-99)    );
  // itree = 1331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48851, 0, 1, 0.829206,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339339,-99) , 
0, 0.349876, 1, 0, 0.516596,-99) , 
3, 0.851953, 0, 0, 0.641697,-99) , 
NN(
0, 
0, 
-1, -1.45649, 0, -1, 0.172976,-99) , 
3, -0.480402, 0, 0, 0.50126,-99)    );
  // itree = 1332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.83902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397368,-99) , 
0, -0.120907, 1, 0, 0.562179,-99) , 
3, 0.911551, 0, 0, 0.685845,-99) , 
NN(
0, 
0, 
-1, -0.966711, 0, -1, 0.233888,-99) , 
3, -0.216753, 0, 0, 0.51644,-99)    );
  // itree = 1333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42719, 1, 1, 0.840698,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234832,-99) , 
0, 0.151182, 1, 0, 0.436279,-99) , 
NN(
0, 
0, 
-1, -1.6692, 0, -1, 0.0854668,-99) , 
3, -1.0423, 0, 0, 0.342544,-99) , 
3, 0.712472, 0, 0, 0.506805,-99)    );
  // itree = 1334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56257, 1, 1, 0.874401,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283032,-99) , 
0, 0.880942, 1, 0, 0.583782,-99) , 
3, 1.0878, 0, 0, 0.676993,-99) , 
NN(
0, 
0, 
-1, -1.05418, 0, -1, 0.163021,-99) , 
3, -0.291428, 0, 0, 0.479483,-99)    );
  // itree = 1335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25114, 0, 1, 0.842635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304813,-99) , 
0, 0.199273, 1, 0, 0.55715,-99) , 
3, 0.700536, 0, 0, 0.718446,-99) , 
NN(
0, 
0, 
-1, -1.69911, 0, -1, 0.251313,-99) , 
3, -0.206128, 0, 0, 0.526973,-99)    );
  // itree = 1336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.835005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363761,-99) , 
0, 0.138796, 1, 0, 0.596194,-99) , 
3, 0.743337, 0, 0, 0.721753,-99) , 
NN(
0, 
0, 
-1, -0.648926, 0, -1, 0.23144,-99) , 
3, -0.156071, 0, 0, 0.519889,-99)    );
  // itree = 1337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593214, 0, 1, 0.757655,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243478,-99) , 
0, -0.612827, 1, 0, 0.426103,-99) , 
NN(
0, 
0, 
-1, -1.37741, 0, -1, 0.129711,-99) , 
3, -0.646522, 0, 0, 0.257162,-99) , 
3, 0.179643, 0, 0, 0.494163,-99)    );
  // itree = 1338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44776, 1, 1, 0.849267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372362,-99) , 
0, 0.408308, 1, 0, 0.601817,-99) , 
3, 0.895919, 0, 0, 0.712195,-99) , 
NN(
0, 
0, 
-1, -0.677103, 1, -1, 0.184554,-99) , 
3, -0.231227, 0, 0, 0.483739,-99)    );
  // itree = 1339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80323, 0, 1, 0.870393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377629,-99) , 
0, 1.17493, 1, 0, 0.693541,-99) , 
3, 1.36049, 0, 0, 0.750744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280168,-99) , 
0, -0.795814, 1, 0, 0.429195,-99) , 
NN(
0, 
0, 
-1, -1.6368, 0, -1, 0.133401,-99) , 
3, -0.699803, 0, 0, 0.276726,-99) , 
3, 0.131392, 0, 0, 0.511696,-99)    );
  // itree = 1340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.30021, 1, 1, 0.845821,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227356,-99) , 
0, 0.146168, 1, 0, 0.480314,-99) , 
NN(
0, 
0, 
-1, -1.51758, 0, -1, 0.196083,-99) , 
3, -0.238914, 0, 0, 0.308855,-99) , 
3, 0.673895, 0, 0, 0.467553,-99)    );
  // itree = 1341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.882185,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378434,-99) , 
0, 0.702199, 1, 0, 0.639481,-99) , 
3, 1.11005, 0, 0, 0.768856,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317509,-99) , 
0, -0.614065, 1, 0, 0.493321,-99) , 
NN(
0, 
0, 
-1, -0.371343, 1, -1, 0.147447,-99) , 
3, -0.58167, 0, 0, 0.2873,-99) , 
3, 0.27076, 0, 0, 0.506074,-99)    );
  // itree = 1342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.806959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332701,-99) , 
0, 0.0681851, 1, 0, 0.542663,-99) , 
3, 0.716715, 0, 0, 0.673737,-99) , 
NN(
0, 
0, 
-1, -0.738218, 0, -1, 0.193714,-99) , 
3, -0.218528, 0, 0, 0.488924,-99)    );
  // itree = 1343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.880956,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325047,-99) , 
0, 0.835519, 1, 0, 0.655155,-99) , 
3, 1.11005, 0, 0, 0.765628,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29349,-99) , 
0, -0.843998, 1, 0, 0.425396,-99) , 
NN(
0, 
0, 
-1, -1.7792, 0, -1, 0.153874,-99) , 
3, -0.574972, 0, 0, 0.265755,-99) , 
3, 0.27076, 0, 0, 0.484374,-99)    );
  // itree = 1344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11331, 0, 1, 0.913268,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438771,-99) , 
3, 1.56723, 0, 0, 0.732807,-99) , 
0, 1.38751, 1, 0, 0.818424,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353055,-99) , 
0, -0.745722, 1, 0, 0.441602,-99) , 
NN(
0, 
0, 
-1, 0.0509554, 1, -1, 0.0907782,-99) , 
3, -1.14309, 0, 0, 0.364255,-99) , 
3, 0.644232, 0, 0, 0.520917,-99)    );
  // itree = 1345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5832, 0, 1, 0.850696,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405079,-99) , 
0, -0.0817891, 1, 0, 0.543999,-99) , 
3, 1.09096, 0, 0, 0.649432,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.220151,-99) , 
3, -0.291428, 0, 0, 0.489735,-99)    );
  // itree = 1346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.900176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430356,-99) , 
0, 1.11407, 1, 0, 0.686822,-99) , 
3, 1.1562, 0, 0, 0.810723,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207024,-99) , 
0, 0.227133, 1, 0, 0.476351,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.16433,-99) , 
3, -0.57899, 0, 0, 0.336344,-99) , 
3, 0.609067, 0, 0, 0.511243,-99)    );
  // itree = 1347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38931, 0, 1, 0.829093,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.879581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395595,-99) , 
0, 0.0681851, 1, 0, 0.579583,-99) , 
3, 0.832607, 0, 0, 0.711059,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.272726,-99) , 
3, -0.0725463, 0, 0, 0.517618,-99)    );
  // itree = 1348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.80841,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292593,-99) , 
0, 0.0477724, 1, 0, 0.489552,-99) , 
NN(
0, 
0, 
-1, -1.46943, 1, -1, 0.191242,-99) , 
3, -0.451773, 0, 0, 0.352205,-99) , 
3, 0.760049, 0, 0, 0.491944,-99)    );
  // itree = 1349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.41103, 1, 1, 0.873851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319067,-99) , 
0, 1.13942, 1, 0, 0.641555,-99) , 
3, 1.1523, 0, 0, 0.755337,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354852,-99) , 
0, -0.341503, 1, 0, 0.502281,-99) , 
NN(
0, 
0, 
-1, -1.57976, 0, -1, 0.204948,-99) , 
3, -0.444478, 0, 0, 0.327688,-99) , 
3, 0.349678, 0, 0, 0.510776,-99)    );
  // itree = 1350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19325, 0, 1, 0.943418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44618,-99) , 
3, 1.38473, 0, 0, 0.733074,-99) , 
0, 1.38751, 1, 0, 0.82702,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278706,-99) , 
0, -0.035315, 1, 0, 0.51285,-99) , 
NN(
0, 
0, 
-1, -0.231579, 1, -1, 0.167585,-99) , 
3, -0.546876, 0, 0, 0.342884,-99) , 
3, 0.644232, 0, 0, 0.502648,-99)    );
  // itree = 1351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43668, 0, 1, 0.822807,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235845,-99) , 
0, 0.277937, 1, 0, 0.525897,-99) , 
3, 0.669169, 0, 0, 0.697842,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208517,-99) , 
0, -1.32874, 1, 0, 0.322451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0127137,-99) , 
3, -1.72057, 0, 0, 0.273767,-99) , 
3, -0.000832217, 0, 0, 0.513466,-99)    );
  // itree = 1352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.86349,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303995,-99) , 
0, 0.853328, 1, 0, 0.588506,-99) , 
3, 1.16315, 0, 0, 0.680546,-99) , 
NN(
0, 
0, 
-1, -0.664977, 0, -1, 0.186867,-99) , 
3, -0.170545, 0, 0, 0.463476,-99)    );
  // itree = 1353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00591, 1, 1, 0.823773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.932202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340562,-99) , 
0, -0.155205, 1, 0, 0.502207,-99) , 
3, 0.639192, 0, 0, 0.692292,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248653,-99) , 
0, -1.45815, 1, 0, 0.357687,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0642686,-99) , 
3, -1.52875, 0, 0, 0.297192,-99) , 
3, -0.0447319, 0, 0, 0.519804,-99)    );
  // itree = 1354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.898151,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47833,-99) , 
0, 0.563868, 1, 0, 0.650143,-99) , 
3, 1.14618, 0, 0, 0.779803,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.294095,-99) , 
3, 0.34765, 0, 0, 0.490305,-99)    );
  // itree = 1355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.197352, 1, 1, 0.846672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336144,-99) , 
0, 0.865651, 1, 0, 0.616997,-99) , 
3, 1.11005, 0, 0, 0.741029,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270494,-99) , 
0, -1.39798, 1, 0, 0.329929,-99) , 
NN(
0, 
0, 
-1, -0.0940381, 0, -1, 0.0396035,-99) , 
3, -1.42217, 0, 0, 0.271692,-99) , 
3, 0.27076, 0, 0, 0.481178,-99)    );
  // itree = 1356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832592, 0, 1, 0.781142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322465,-99) , 
0, -0.996671, 1, 0, 0.418495,-99) , 
NN(
0, 
0, 
-1, -1.54532, 0, -1, 0.136191,-99) , 
3, -0.651582, 0, 0, 0.294249,-99) , 
3, 0.427177, 0, 0, 0.49014,-99)    );
  // itree = 1357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15402, 0, 1, 0.828267,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357763,-99) , 
0, -0.0319407, 1, 0, 0.492471,-99) , 
NN(
0, 
0, 
-1, -1.78409, 0, -1, 0.216338,-99) , 
3, -0.36887, 0, 0, 0.365622,-99) , 
3, 0.79068, 0, 0, 0.497445,-99)    );
  // itree = 1358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6338, 1, 1, 0.901397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472159,-99) , 
0, 1.00365, 1, 0, 0.678509,-99) , 
3, 1.38065, 0, 0, 0.762749,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220549,-99) , 
0, -0.150485, 1, 0, 0.454532,-99) , 
NN(
0, 
0, 
-1, -1.1834, 0, -1, 0.175166,-99) , 
3, -0.477004, 0, 0, 0.306256,-99) , 
3, 0.34753, 0, 0, 0.497712,-99)    );
  // itree = 1359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73687, 0, 1, 0.838007,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222088,-99) , 
0, 1.0605, 1, 0, 0.574498,-99) , 
3, 1.07824, 0, 0, 0.66692,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209277,-99) , 
0, -1.7757, 1, 0, 0.316689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.02297,-99) , 
3, -1.56424, 0, 0, 0.249518,-99) , 
3, -0.302053, 0, 0, 0.527449,-99)    );
  // itree = 1360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.6596, 0, 1, 0.800889,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309312,-99) , 
0, -0.0638725, 1, 0, 0.458345,-99) , 
NN(
0, 
0, 
-1, -1.17793, 0, -1, 0.157436,-99) , 
3, -0.727114, 0, 0, 0.336896,-99) , 
3, 0.742135, 0, 0, 0.488125,-99)    );
  // itree = 1361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.85945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744643,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25556,-99) , 
0, 0.91729, 1, 0, 0.579053,-99) , 
3, 1.11005, 0, 0, 0.714696,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284308,-99) , 
0, -0.615667, 1, 0, 0.454292,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.17232,-99) , 
3, -0.569108, 0, 0, 0.305891,-99) , 
3, 0.27076, 0, 0, 0.498935,-99)    );
  // itree = 1362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57086, 1, 1, 0.860914,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294984,-99) , 
0, 0.506819, 1, 0, 0.589801,-99) , 
3, 0.835097, 0, 0, 0.73197,-99) , 
NN(
0, 
0, 
-1, -0.684058, 1, -1, 0.223953,-99) , 
3, -0.0725463, 0, 0, 0.511,-99)    );
  // itree = 1363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.49023, 0, 1, 0.820464,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215736,-99) , 
0, 0.40789, 1, 0, 0.487344,-99) , 
NN(
0, 
0, 
-1, -1.05863, 0, -1, 0.207964,-99) , 
3, -0.361441, 0, 0, 0.350795,-99) , 
3, 0.784899, 0, 0, 0.497948,-99)    );
  // itree = 1364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.855428,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299534,-99) , 
0, 0.119892, 1, 0, 0.467136,-99) , 
NN(
0, 
0, 
-1, -1.12476, 0, -1, 0.156685,-99) , 
3, -0.667184, 0, 0, 0.349946,-99) , 
3, 0.828289, 0, 0, 0.504238,-99)    );
  // itree = 1365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71083, 0, 1, 0.860819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469388,-99) , 
0, 0.150326, 1, 0, 0.59896,-99) , 
3, 1.19945, 0, 0, 0.673568,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.144785,-99) , 
3, -0.547237, 0, 0, 0.498298,-99)    );
  // itree = 1366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.881871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287733,-99) , 
0, 0.927932, 1, 0, 0.555743,-99) , 
3, 1.0878, 0, 0, 0.664267,-99) , 
NN(
0, 
0, 
-1, -0.818652, 0, -1, 0.181308,-99) , 
3, -0.291428, 0, 0, 0.500159,-99)    );
  // itree = 1367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07377, 0, 1, 0.807247,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240252,-99) , 
0, 0.232439, 1, 0, 0.532997,-99) , 
3, 0.708902, 0, 0, 0.678636,-99) , 
NN(
0, 
0, 
-1, -1.69911, 0, -1, 0.236069,-99) , 
3, -0.206128, 0, 0, 0.498541,-99)    );
  // itree = 1368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.743596, 1, 1, 0.847278,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18084,-99) , 
0, 0.486064, 1, 0, 0.469269,-99) , 
NN(
0, 
0, 
-1, -1.71171, 0, -1, 0.102361,-99) , 
3, -1.05753, 0, 0, 0.36704,-99) , 
3, 0.760049, 0, 0, 0.505567,-99)    );
  // itree = 1369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.5962, 0, 1, 0.823922,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270774,-99) , 
0, 0.0510396, 1, 0, 0.458201,-99) , 
NN(
0, 
0, 
-1, -0.751998, 0, -1, 0.221936,-99) , 
3, -0.238914, 0, 0, 0.324288,-99) , 
3, 0.673895, 0, 0, 0.482881,-99)    );
  // itree = 1370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54631, 1, 1, 0.845738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370275,-99) , 
0, 0.454879, 1, 0, 0.546799,-99) , 
3, 0.835863, 0, 0, 0.70819,-99) , 
NN(
0, 
0, 
-1, -1.56671, 0, -1, 0.217977,-99) , 
3, -0.0725463, 0, 0, 0.476292,-99)    );
  // itree = 1371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.845015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379063,-99) , 
0, 0.0287117, 1, 0, 0.572277,-99) , 
3, 0.708902, 0, 0, 0.719745,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233715,-99) , 
0, -1.36121, 1, 0, 0.3292,-99) , 
NN(
0, 
0, 
-1, -0.0407321, 1, -1, 0.068928,-99) , 
3, -1.20223, 0, 0, 0.228257,-99) , 
3, -0.206128, 0, 0, 0.522697,-99)    );
  // itree = 1372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65958, 0, 1, 0.830111,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241186,-99) , 
0, 0.488, 1, 0, 0.538318,-99) , 
3, 0.949517, 0, 0, 0.664793,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.20759,-99) , 
3, -0.218528, 0, 0, 0.475882,-99)    );
  // itree = 1373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11463, 0, 1, 0.770439,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270004,-99) , 
0, -0.817898, 1, 0, 0.391905,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.123224,-99) , 
3, -0.58167, 0, 0, 0.248486,-99) , 
3, 0.27076, 0, 0, 0.476853,-99)    );
  // itree = 1374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6, 0, 1, 0.803022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30903,-99) , 
0, 0.271542, 1, 0, 0.564197,-99) , 
3, 0.637508, 0, 0, 0.70778,-99) , 
NN(
0, 
0, 
-1, -1.29511, 0, -1, 0.19247,-99) , 
3, -0.0447319, 0, 0, 0.473122,-99)    );
  // itree = 1375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59182, 1, 1, 0.8729,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429845,-99) , 
0, 0.219879, 1, 0, 0.603499,-99) , 
3, 1.06166, 0, 0, 0.715218,-99) , 
NN(
0, 
0, 
-1, -0.577057, 0, -1, 0.241494,-99) , 
3, -0.0725463, 0, 0, 0.499781,-99)    );
  // itree = 1376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98981, 1, 1, 0.859123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38664,-99) , 
0, 0.284185, 1, 0, 0.591303,-99) , 
3, 0.771733, 0, 0, 0.735729,-99) , 
NN(
0, 
0, 
-1, -1.57898, 0, -1, 0.24421,-99) , 
3, -0.115595, 0, 0, 0.521086,-99)    );
  // itree = 1377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.10119, 0, 1, 0.848501,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229778,-99) , 
0, 0.431079, 1, 0, 0.49411,-99) , 
NN(
0, 
0, 
-1, -0.642544, 1, -1, 0.190889,-99) , 
3, -0.41015, 0, 0, 0.349042,-99) , 
3, 0.749733, 0, 0, 0.513182,-99)    );
  // itree = 1378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08069, 1, 1, 0.826939,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260525,-99) , 
0, -0.0789444, 1, 0, 0.456054,-99) , 
NN(
0, 
0, 
-1, -1.51536, 0, -1, 0.176309,-99) , 
3, -0.546876, 0, 0, 0.336614,-99) , 
3, 0.644232, 0, 0, 0.511919,-99)    );
  // itree = 1379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67413, 0, 1, 0.850101,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424828,-99) , 
0, 0.222768, 1, 0, 0.6084,-99) , 
3, 0.965707, 0, 0, 0.759241,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21817,-99) , 
0, -0.0236846, 1, 0, 0.427681,-99) , 
NN(
0, 
0, 
-1, -1.19759, 0, -1, 0.176756,-99) , 
3, -0.751702, 0, 0, 0.329863,-99) , 
3, 0.34753, 0, 0, 0.518293,-99)    );
  // itree = 1380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.353356, 1, 1, 0.890913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452869,-99) , 
3, 1.18892, 0, 0, 0.730664,-99) , 
0, 0.973472, 1, 0, 0.793553,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251412,-99) , 
0, -0.243891, 1, 0, 0.47021,-99) , 
NN(
0, 
0, 
-1, -1.19726, 0, -1, 0.144871,-99) , 
3, -0.751608, 0, 0, 0.314478,-99) , 
3, 0.34753, 0, 0, 0.530475,-99)    );
  // itree = 1381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.37343, 1, 1, 0.916209,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356188,-99) , 
0, 1.30507, 1, 0, 0.712041,-99) , 
3, 1.33699, 0, 0, 0.810508,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319878,-99) , 
0, -0.275924, 1, 0, 0.474052,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.189645,-99) , 
3, -0.575176, 0, 0, 0.348303,-99) , 
3, 0.609067, 0, 0, 0.508099,-99)    );
  // itree = 1382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11897, 1, 1, 0.856632,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38407,-99) , 
0, 0.514073, 1, 0, 0.590883,-99) , 
3, 0.965539, 0, 0, 0.706845,-99) , 
NN(
0, 
0, 
-1, -0.88033, 1, -1, 0.206644,-99) , 
3, -0.218528, 0, 0, 0.515632,-99)    );
  // itree = 1383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.873993,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261771,-99) , 
0, 0.461096, 1, 0, 0.507193,-99) , 
NN(
0, 
0, 
-1, -1.09106, 0, -1, 0.217587,-99) , 
3, -0.386781, 0, 0, 0.367293,-99) , 
3, 0.778124, 0, 0, 0.520586,-99)    );
  // itree = 1384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.836692,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285371,-99) , 
0, 0.131717, 1, 0, 0.460355,-99) , 
NN(
0, 
0, 
-1, -1.13155, 1, -1, 0.194278,-99) , 
3, -0.303277, 0, 0, 0.332273,-99) , 
3, 0.876835, 0, 0, 0.458941,-99)    );
  // itree = 1385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.847907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296687,-99) , 
0, 0.654863, 1, 0, 0.597762,-99) , 
3, 1.00886, 0, 0, 0.719395,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332354,-99) , 
0, -0.843998, 1, 0, 0.44199,-99) , 
NN(
0, 
0, 
-1, -1.51378, 1, -1, 0.130451,-99) , 
3, -0.648083, 0, 0, 0.269277,-99) , 
3, 0.179643, 0, 0, 0.483348,-99)    );
  // itree = 1386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.865772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426129,-99) , 
0, 0.830155, 1, 0, 0.624364,-99) , 
3, 1.11419, 0, 0, 0.755375,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196501,-99) , 
0, -0.710328, 1, 0, 0.35106,-99) , 
NN(
0, 
0, 
-1, -0.24519, 1, -1, 0.1084,-99) , 
3, -1.13934, 0, 0, 0.27931,-99) , 
3, 0.27076, 0, 0, 0.497289,-99)    );
  // itree = 1387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.827054,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339443,-99) , 
1, -0.134766, 1, 0, 0.458709,-99) , 
NN(
0, 
0, 
-1, -1.1254, 0, -1, 0.156171,-99) , 
3, -0.661336, 0, 0, 0.345133,-99) , 
3, 0.828289, 0, 0, 0.47746,-99)    );
  // itree = 1388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2597, 1, 1, 0.834973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236611,-99) , 
0, 0.533181, 1, 0, 0.542803,-99) , 
3, 0.866569, 0, 0, 0.69648,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194275,-99) , 
0, -0.85876, 1, 0, 0.354345,-99) , 
NN(
0, 
0, 
-1, -1.67634, 0, -1, 0.143233,-99) , 
3, -0.75266, 0, 0, 0.236021,-99) , 
3, 0.0559666, 0, 0, 0.47572,-99)    );
  // itree = 1389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6076, 0, 1, 0.847458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283387,-99) , 
0, 0.461514, 1, 0, 0.568618,-99) , 
3, 0.882995, 0, 0, 0.706523,-99) , 
NN(
0, 
0, 
-1, -1.74711, 0, -1, 0.228151,-99) , 
3, -0.0172488, 0, 0, 0.48008,-99)    );
  // itree = 1390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6193, 0, 1, 0.882608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473857,-99) , 
0, 0.291557, 1, 0, 0.623383,-99) , 
3, 1.10998, 0, 0, 0.731214,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216718,-99) , 
0, -0.845124, 1, 0, 0.383205,-99) , 
NN(
0, 
0, 
-1, -1.59433, 0, -1, 0.132373,-99) , 
3, -0.993638, 0, 0, 0.274633,-99) , 
3, -0.011497, 0, 0, 0.5315,-99)    );
  // itree = 1391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68539, 1, 1, 0.835429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270503,-99) , 
0, 0.381546, 1, 0, 0.496601,-99) , 
3, 0.951244, 0, 0, 0.623493,-99) , 
NN(
0, 
0, 
-1, -1.24211, 0, -1, 0.146626,-99) , 
3, -0.547237, 0, 0, 0.491239,-99)    );
  // itree = 1392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11421, 1, 1, 0.823309,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309658,-99) , 
0, 0.138796, 1, 0, 0.539417,-99) , 
3, 0.747201, 0, 0, 0.688275,-99) , 
NN(
0, 
0, 
-1, -0.885947, 0, -1, 0.240484,-99) , 
3, -0.145446, 0, 0, 0.515776,-99)    );
  // itree = 1393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.60746, 0, 1, 0.76046,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313919,-99) , 
3, -0.0689923, 0, 0, 0.376509,-99) , 
NN(
0, 
0, 
-1, 0.315854, 1, -1, 0.0928479,-99) , 
3, -1.19072, 0, 0, 0.293562,-99) , 
3, 0.191234, 0, 0, 0.522997,-99)    );
  // itree = 1394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.656733, 0, 1, 0.749759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346381,-99) , 
0, -0.817898, 1, 0, 0.446217,-99) , 
NN(
0, 
0, 
-1, -1.50704, 0, -1, 0.148623,-99) , 
3, -0.575192, 0, 0, 0.27694,-99) , 
3, 0.240623, 0, 0, 0.477218,-99)    );
  // itree = 1395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32898, 1, 1, 0.81843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25381,-99) , 
0, -0.0639868, 1, 0, 0.486475,-99) , 
3, 0.612756, 0, 0, 0.675955,-99) , 
NN(
0, 
0, 
-1, -0.81936, 0, -1, 0.220186,-99) , 
3, -0.0725463, 0, 0, 0.479551,-99)    );
  // itree = 1396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40394, 0, 1, 0.825598,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298813,-99) , 
0, 0.179441, 1, 0, 0.546259,-99) , 
3, 0.718237, 0, 0, 0.685941,-99) , 
NN(
0, 
0, 
-1, -0.669755, 1, -1, 0.167837,-99) , 
3, -0.415423, 0, 0, 0.504847,-99)    );
  // itree = 1397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47497, 1, 1, 0.905504,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469201,-99) , 
0, 1.51021, 1, 0, 0.696698,-99) , 
3, 1.50815, 0, 0, 0.781504,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310888,-99) , 
0, 0.0725999, 1, 0, 0.497834,-99) , 
NN(
0, 
0, 
-1, -1.54556, 0, -1, 0.217713,-99) , 
3, -0.368788, 0, 0, 0.366361,-99) , 
3, 0.79068, 0, 0, 0.491945,-99)    );
  // itree = 1398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38501, 1, 1, 0.817855,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402812,-99) , 
0, -0.707247, 1, 0, 0.485357,-99) , 
NN(
0, 
0, 
-1, -1.64606, 0, -1, 0.185314,-99) , 
3, -0.45279, 0, 0, 0.352522,-99) , 
3, 0.760049, 0, 0, 0.502023,-99)    );
  // itree = 1399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.97187, 1, 1, 0.876566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476091,-99) , 
0, 0.036285, 1, 0, 0.587567,-99) , 
3, 1.28745, 0, 0, 0.675558,-99) , 
NN(
0, 
0, 
-1, -1.56687, 0, -1, 0.258421,-99) , 
3, -0.0725463, 0, 0, 0.495642,-99)    );
  // itree = 1400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66649, 0, 1, 0.841754,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397151,-99) , 
0, 0.0967635, 1, 0, 0.558288,-99) , 
3, 0.952846, 0, 0, 0.695125,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184351,-99) , 
0, -1.36121, 1, 0, 0.306544,-99) , 
NN(
0, 
0, 
-1, -0.0940381, 1, -1, 0.103519,-99) , 
3, -1.2441, 0, 0, 0.236223,-99) , 
3, -0.218528, 0, 0, 0.508075,-99)    );
  // itree = 1401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67647, 0, 1, 0.843761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48415,-99) , 
0, -0.00163953, 1, 0, 0.603606,-99) , 
3, 1.00629, 0, 0, 0.728041,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301615,-99) , 
0, -0.785825, 1, 0, 0.382327,-99) , 
NN(
0, 
0, 
-1, -1.14182, 0, -1, 0.143123,-99) , 
3, -0.647965, 0, 0, 0.25395,-99) , 
3, 0.179643, 0, 0, 0.472736,-99)    );
  // itree = 1402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32015, 0, 1, 0.828414,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339149,-99) , 
0, -0.652258, 1, 0, 0.444076,-99) , 
NN(
0, 
0, 
-1, -1.6834, 0, -1, 0.140985,-99) , 
3, -0.754651, 0, 0, 0.333706,-99) , 
3, 0.760049, 0, 0, 0.491023,-99)    );
  // itree = 1403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62444, 0, 1, 0.847932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299705,-99) , 
0, 0.418264, 1, 0, 0.521081,-99) , 
3, 0.897747, 0, 0, 0.647076,-99) , 
NN(
0, 
0, 
-1, -1.53081, 0, -1, 0.141147,-99) , 
3, -0.613987, 0, 0, 0.496459,-99)    );
  // itree = 1404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.820183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.876832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280885,-99) , 
0, 0.57979, 1, 0, 0.591575,-99) , 
3, 0.968938, 0, 0, 0.723115,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247565,-99) , 
0, -0.612827, 1, 0, 0.38776,-99) , 
NN(
0, 
0, 
-1, -1.64928, 0, -1, 0.141473,-99) , 
3, -0.751702, 0, 0, 0.287618,-99) , 
3, 0.34753, 0, 0, 0.475071,-99)    );
  // itree = 1405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13381, 0, 1, 0.795061,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258881,-99) , 
0, 0.143304, 1, 0, 0.458535,-99) , 
NN(
0, 
0, 
-1, -0.397332, 1, -1, 0.139585,-99) , 
3, -0.754651, 0, 0, 0.32881,-99) , 
3, 0.760049, 0, 0, 0.475967,-99)    );
  // itree = 1406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24824, 1, 1, 0.847391,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378186,-99) , 
0, -0.0346559, 1, 0, 0.531872,-99) , 
3, 1.08845, 0, 0, 0.647465,-99) , 
NN(
0, 
0, 
-1, -1.31014, 0, -1, 0.165804,-99) , 
3, -0.291428, 0, 0, 0.460838,-99)    );
  // itree = 1407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.907803,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304447,-99) , 
0, 0.884016, 1, 0, 0.618744,-99) , 
3, 1.13374, 0, 0, 0.769823,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232082,-99) , 
1, 0.294764, 1, 0, 0.424387,-99) , 
NN(
0, 
0, 
-1, -1.86258, 0, -1, 0.175414,-99) , 
3, -0.483771, 0, 0, 0.292146,-99) , 
3, 0.322617, 0, 0, 0.508617,-99)    );
  // itree = 1408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.827747,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331344,-99) , 
0, -0.0789444, 1, 0, 0.517444,-99) , 
NN(
0, 
0, 
-1, -1.74319, 0, -1, 0.178735,-99) , 
3, -0.524691, 0, 0, 0.369879,-99) , 
3, 0.673895, 0, 0, 0.528477,-99)    );
  // itree = 1409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3598, 0, 1, 0.851139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327407,-99) , 
0, 0.865651, 1, 0, 0.613331,-99) , 
3, 1.02216, 0, 0, 0.718427,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276389,-99) , 
0, -1.30268, 1, 0, 0.35952,-99) , 
NN(
0, 
0, 
-1, -1.83212, 0, -1, 0.0778521,-99) , 
3, -1.19338, 0, 0, 0.267169,-99) , 
3, 0.191234, 0, 0, 0.487554,-99)    );
  // itree = 1410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59962, 0, 1, 0.847011,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447887,-99) , 
0, 0.0967635, 1, 0, 0.566676,-99) , 
3, 1.08605, 0, 0, 0.687099,-99) , 
NN(
0, 
0, 
-1, -1.53319, 0, -1, 0.265757,-99) , 
3, -0.0426953, 0, 0, 0.492294,-99)    );
  // itree = 1411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66214, 0, 1, 0.880951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354272,-99) , 
0, 0.434019, 1, 0, 0.556496,-99) , 
3, 0.952846, 0, 0, 0.706718,-99) , 
NN(
0, 
0, 
-1, -0.73772, 0, -1, 0.210443,-99) , 
3, -0.218528, 0, 0, 0.519133,-99)    );
  // itree = 1412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.85682,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450088,-99) , 
0, 0.027439, 1, 0, 0.588679,-99) , 
3, 1.14588, 0, 0, 0.687163,-99) , 
NN(
0, 
0, 
-1, -1.47055, 0, -1, 0.182059,-99) , 
3, -0.216753, 0, 0, 0.467713,-99)    );
  // itree = 1413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.888377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341476,-99) , 
0, 0.376975, 1, 0, 0.550455,-99) , 
3, 1.10905, 0, 0, 0.672163,-99) , 
NN(
0, 
0, 
-1, -1.72934, 0, -1, 0.134825,-99) , 
3, -0.613509, 0, 0, 0.509563,-99)    );
  // itree = 1414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.606045, 0, 1, 0.76376,-99) , 
NN(
0, 
0, 
-1, -1.46884, 0, -1, 0.273324,-99) , 
3, 0.191234, 0, 0, 0.509104,-99)    );
  // itree = 1415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49764, 0, 1, 0.865623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342696,-99) , 
0, 0.758301, 1, 0, 0.56512,-99) , 
3, 0.96671, 0, 0, 0.740318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196906,-99) , 
1, 0.575642, 1, 0, 0.429982,-99) , 
NN(
0, 
0, 
-1, -1.665, 0, -1, 0.108407,-99) , 
3, -1.03259, 0, 0, 0.317249,-99) , 
3, 0.34753, 0, 0, 0.510569,-99)    );
  // itree = 1416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37559, 1, 1, 0.801601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438203,-99) , 
0, -0.699139, 1, 0, 0.515681,-99) , 
3, 0.720251, 0, 0, 0.65928,-99) , 
NN(
0, 
0, 
-1, -1.24633, 0, -1, 0.201846,-99) , 
3, -0.218528, 0, 0, 0.470486,-99)    );
  // itree = 1417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11862, 0, 1, 0.815512,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283289,-99) , 
0, 0.0208352, 1, 0, 0.479608,-99) , 
NN(
0, 
0, 
-1, -1.63545, 0, -1, 0.21869,-99) , 
3, -0.446363, 0, 0, 0.361123,-99) , 
3, 0.729578, 0, 0, 0.513173,-99)    );
  // itree = 1418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20188, 1, 1, 0.818883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49529,-99) , 
3, 0.390007, 0, 0, 0.532423,-99) , 
3, 0.60746, 0, 0, 0.735768,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.919666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274708,-99) , 
0, -0.678004, 1, 0, 0.477183,-99) , 
NN(
0, 
0, 
-1, -1.12685, 0, -1, 0.16678,-99) , 
3, -0.365924, 0, 0, 0.273837,-99) , 
3, 0.191234, 0, 0, 0.488536,-99)    );
  // itree = 1419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.608276, 0, 1, 0.738388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297565,-99) , 
0, -0.612827, 1, 0, 0.448589,-99) , 
NN(
0, 
0, 
-1, -1.06989, 0, -1, 0.140822,-99) , 
3, -0.602387, 0, 0, 0.28534,-99) , 
3, 0.202272, 0, 0, 0.503238,-99)    );
  // itree = 1420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49537, 0, 1, 0.817886,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2586,-99) , 
0, 0.348213, 1, 0, 0.527341,-99) , 
3, 0.771733, 0, 0, 0.672828,-99) , 
NN(
0, 
0, 
-1, -0.604826, 0, -1, 0.197034,-99) , 
3, -0.115595, 0, 0, 0.464415,-99)    );
  // itree = 1421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.837937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326847,-99) , 
0, 0.0477724, 1, 0, 0.569231,-99) , 
3, 0.5692, 0, 0, 0.717319,-99) , 
NN(
0, 
0, 
-1, -1.60013, 0, -1, 0.195923,-99) , 
3, -0.346282, 0, 0, 0.530796,-99)    );
  // itree = 1422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.57907, 0, 1, 0.824316,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185316,-99) , 
0, 0.190311, 1, 0, 0.442707,-99) , 
NN(
0, 
0, 
-1, -1.52421, 0, -1, 0.15455,-99) , 
3, -0.834669, 0, 0, 0.344976,-99) , 
3, 0.661338, 0, 0, 0.500248,-99)    );
  // itree = 1423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.858854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273409,-99) , 
0, 0.788183, 1, 0, 0.588546,-99) , 
3, 1.02216, 0, 0, 0.714229,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265046,-99) , 
0, -0.614285, 1, 0, 0.390783,-99) , 
NN(
0, 
0, 
-1, -2.15815, 1, -1, 0.142087,-99) , 
3, -0.639477, 0, 0, 0.258365,-99) , 
3, 0.191234, 0, 0, 0.462568,-99)    );
  // itree = 1424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36045, 1, 1, 0.822013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317786,-99) , 
0, 0.0681851, 1, 0, 0.52246,-99) , 
3, 0.707229, 0, 0, 0.677617,-99) , 
NN(
0, 
0, 
-1, -0.24519, 1, -1, 0.227363,-99) , 
3, -0.206128, 0, 0, 0.49451,-99)    );
  // itree = 1425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08535, 0, 1, 0.815892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405695,-99) , 
3, 0.484423, 0, 0, 0.747352,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283624,-99) , 
0, -0.607343, 1, 0, 0.428271,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.153437,-99) , 
3, -0.569108, 0, 0, 0.276498,-99) , 
3, 0.27076, 0, 0, 0.496523,-99)    );
  // itree = 1426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6775, 0, 1, 0.843321,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213956,-99) , 
0, 0.716393, 1, 0, 0.536993,-99) , 
3, 0.97058, 0, 0, 0.665327,-99) , 
NN(
0, 
0, 
-1, -1.64422, 0, -1, 0.162992,-99) , 
3, -0.516641, 0, 0, 0.513777,-99)    );
  // itree = 1427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35104, 1, 1, 0.845745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341815,-99) , 
0, 0.581613, 1, 0, 0.664977,-99) , 
3, 0.784152, 0, 0, 0.76065,-99) , 
NN(
0, 
0, 
-1, -1.31113, 0, -1, 0.231988,-99) , 
3, -0.100774, 0, 0, 0.524341,-99)    );
  // itree = 1428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.99387, 1, 1, 0.888333,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391725,-99) , 
0, 0.924863, 1, 0, 0.652619,-99) , 
3, 1.23699, 0, 0, 0.760965,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252251,-99) , 
0, -0.114347, 1, 0, 0.460683,-99) , 
NN(
0, 
0, 
-1, -1.54223, 0, -1, 0.179749,-99) , 
3, -0.651582, 0, 0, 0.327472,-99) , 
3, 0.427177, 0, 0, 0.509677,-99)    );
  // itree = 1429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6274, 0, 1, 0.868803,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432191,-99) , 
0, 0.702199, 1, 0, 0.686123,-99) , 
3, 1.11419, 0, 0, 0.786631,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273103,-99) , 
0, -0.65582, 1, 0, 0.427248,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.173937,-99) , 
3, -0.574972, 0, 0, 0.28411,-99) , 
3, 0.27076, 0, 0, 0.509921,-99)    );
  // itree = 1430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50418, 1, 1, 0.841542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322802,-99) , 
0, 0.91729, 1, 0, 0.617396,-99) , 
3, 1.09842, 0, 0, 0.722759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202188,-99) , 
0, -0.19173, 1, 0, 0.448377,-99) , 
NN(
0, 
0, 
-1, -1.69229, 0, -1, 0.178431,-99) , 
3, -0.246668, 0, 0, 0.261133,-99) , 
3, 0.295236, 0, 0, 0.456811,-99)    );
  // itree = 1431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.35162, 0, 1, 0.844094,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327439,-99) , 
0, -0.154263, 1, 0, 0.47746,-99) , 
NN(
0, 
0, 
-1, -1.54084, 0, -1, 0.15965,-99) , 
3, -0.632412, 0, 0, 0.34966,-99) , 
3, 0.814561, 0, 0, 0.487287,-99)    );
  // itree = 1432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63415, 1, 1, 0.878662,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364209,-99) , 
0, 0.143304, 1, 0, 0.572332,-99) , 
3, 1.06041, 0, 0, 0.681851,-99) , 
NN(
0, 
0, 
-1, 1.01352, 0, -1, 0.154552,-99) , 
3, -0.680259, 0, 0, 0.522443,-99)    );
  // itree = 1433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09759, 0, 1, 0.8434,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452638,-99) , 
0, -0.179275, 1, 0, 0.587432,-99) , 
3, 0.720808, 0, 0, 0.716902,-99) , 
NN(
0, 
0, 
-1, -1.50923, 0, -1, 0.227382,-99) , 
3, -0.218528, 0, 0, 0.52239,-99)    );
  // itree = 1434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.86117, 0, 1, 0.765173,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252189,-99) , 
0, 0.0477724, 1, 0, 0.477202,-99) , 
NN(
0, 
0, 
-1, -0.411126, 1, -1, 0.186009,-99) , 
3, -0.352561, 0, 0, 0.317079,-99) , 
3, 0.451912, 0, 0, 0.493874,-99)    );
  // itree = 1435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.813872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285255,-99) , 
0, -0.0370793, 1, 0, 0.55163,-99) , 
3, 0.488699, 0, 0, 0.703973,-99) , 
NN(
0, 
0, 
-1, -1.64525, 0, -1, 0.149775,-99) , 
3, -0.516641, 0, 0, 0.531073,-99)    );
  // itree = 1436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.820898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.937933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369157,-99) , 
0, -0.0558779, 1, 0, 0.585331,-99) , 
3, 0.639192, 0, 0, 0.739155,-99) , 
NN(
0, 
0, 
-1, -1.52753, 0, -1, 0.226265,-99) , 
3, -0.0426953, 0, 0, 0.489058,-99)    );
  // itree = 1437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27903, 1, 1, 0.774646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322317,-99) , 
0, 0.138796, 1, 0, 0.540647,-99) , 
3, 0.561195, 0, 0, 0.683523,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.231167,-99) , 
3, -0.133228, 0, 0, 0.491728,-99)    );
  // itree = 1438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.858163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416031,-99) , 
0, -0.0112904, 1, 0, 0.555852,-99) , 
3, 1.08754, 0, 0, 0.67617,-99) , 
NN(
0, 
0, 
-1, -0.547392, 0, -1, 0.242386,-99) , 
3, -0.0447319, 0, 0, 0.482792,-99)    );
  // itree = 1439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.811377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38878,-99) , 
0, -0.63031, 1, 0, 0.514528,-99) , 
3, 0.565203, 0, 0, 0.675516,-99) , 
NN(
0, 
0, 
-1, -1.10006, 0, -1, 0.170636,-99) , 
3, -0.346282, 0, 0, 0.475783,-99)    );
  // itree = 1440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61273, 0, 1, 0.870439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42439,-99) , 
0, 0.758301, 1, 0, 0.646917,-99) , 
3, 1.12513, 0, 0, 0.760047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27501,-99) , 
0, -0.7017, 1, 0, 0.392022,-99) , 
NN(
0, 
0, 
-1, -1.40317, 0, -1, 0.186136,-99) , 
3, -0.484215, 0, 0, 0.28682,-99) , 
3, 0.322617, 0, 0, 0.489457,-99)    );
  // itree = 1441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35885, 0, 1, 0.782141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343936,-99) , 
0, -0.817898, 1, 0, 0.475058,-99) , 
3, 0.32035, 0, 0, 0.660995,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.135925,-99) , 
3, -0.707817, 0, 0, 0.509758,-99)    );
  // itree = 1442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.845956,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315615,-99) , 
0, 0.733856, 1, 0, 0.628551,-99) , 
3, 1.09286, 0, 0, 0.720771,-99) , 
NN(
0, 
0, 
-1, -0.537192, 0, -1, 0.266219,-99) , 
3, -0.0295996, 0, 0, 0.519315,-99)    );
  // itree = 1443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48771, 0, 1, 0.841796,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365368,-99) , 
0, 0.242655, 1, 0, 0.569704,-99) , 
3, 0.980247, 0, 0, 0.694461,-99) , 
NN(
0, 
0, 
-1, -0.617192, 0, -1, 0.237183,-99) , 
3, -0.128257, 0, 0, 0.510758,-99)    );
  // itree = 1444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.794011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25719,-99) , 
0, 0.146168, 1, 0, 0.501575,-99) , 
NN(
0, 
0, 
-1, -0.997797, 0, -1, 0.243806,-99) , 
3, -0.230339, 0, 0, 0.345674,-99) , 
3, 0.673895, 0, 0, 0.493758,-99)    );
  // itree = 1445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.59914, 0, 1, 0.81281,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33446,-99) , 
0, -0.55321, 1, 0, 0.45003,-99) , 
NN(
0, 
0, 
-1, -1.50233, 0, -1, 0.197733,-99) , 
3, -0.535926, 0, 0, 0.347755,-99) , 
3, 0.673895, 0, 0, 0.501337,-99)    );
  // itree = 1446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900592,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439068,-99) , 
3, 0.657548, 0, 0, 0.664098,-99) , 
0, -0.00235569, 1, 0, 0.707431,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22653,-99) , 
0, -0.781475, 1, 0, 0.372084,-99) , 
NN(
0, 
0, 
-1, -0.424961, 1, -1, 0.131297,-99) , 
3, -0.539995, 0, 0, 0.218186,-99) , 
3, -0.0447319, 0, 0, 0.474285,-99)    );
  // itree = 1447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.837601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.906828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489298,-99) , 
0, 0.327141, 1, 0, 0.638661,-99) , 
3, 0.965707, 0, 0, 0.760656,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275058,-99) , 
0, -0.592922, 1, 0, 0.40356,-99) , 
NN(
0, 
0, 
-1, -1.41885, 0, -1, 0.16463,-99) , 
3, -0.476904, 0, 0, 0.265691,-99) , 
3, 0.34753, 0, 0, 0.478965,-99)    );
  // itree = 1448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45895, 0, 1, 0.833168,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352148,-99) , 
0, 0.488, 1, 0, 0.55122,-99) , 
3, 0.735222, 0, 0, 0.735491,-99) , 
NN(
0, 
0, 
-1, -0.99886, 0, -1, 0.280673,-99) , 
3, 0.336059, 0, 0, 0.484375,-99)    );
  // itree = 1449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69047, 0, 1, 0.858033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813966,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461887,-99) , 
0, 0.0304304, 1, 0, 0.582046,-99) , 
3, 1.01627, 0, 0, 0.710165,-99) , 
NN(
0, 
0, 
-1, -0.576542, 0, -1, 0.247832,-99) , 
3, -0.0901485, 0, 0, 0.513,-99)    );
  // itree = 1450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.233361, 1, 1, 0.907077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442185,-99) , 
3, 1.16241, 0, 0, 0.703665,-99) , 
0, 0.747238, 1, 0, 0.770472,-99) , 
NN(
0, 
0, 
-1, -1.51385, 0, -1, 0.298716,-99) , 
3, 0.34765, 0, 0, 0.499626,-99)    );
  // itree = 1451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45225, 1, 1, 0.846689,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314868,-99) , 
0, 0.332449, 1, 0, 0.541523,-99) , 
3, 0.861778, 0, 0, 0.698806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238444,-99) , 
0, -1.63938, 1, 0, 0.331899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0360607,-99) , 
3, -1.52857, 0, 0, 0.268138,-99) , 
3, -0.0447319, 0, 0, 0.513009,-99)    );
  // itree = 1452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.968004, 0, 1, 0.930054,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499876,-99) , 
3, 1.56723, 0, 0, 0.699206,-99) , 
0, 1.17505, 1, 0, 0.775577,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169393,-99) , 
0, 0.196016, 1, 0, 0.427369,-99) , 
NN(
0, 
0, 
-1, -1.51378, 1, -1, 0.170082,-99) , 
3, -0.547498, 0, 0, 0.316207,-99) , 
3, 0.644232, 0, 0, 0.456094,-99)    );
  // itree = 1453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42765, 0, 1, 0.886144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369931,-99) , 
0, 0.594872, 1, 0, 0.590378,-99) , 
3, 1.09692, 0, 0, 0.70545,-99) , 
NN(
0, 
0, 
-1, -1.55738, 0, -1, 0.235183,-99) , 
3, -0.291428, 0, 0, 0.545983,-99)    );
  // itree = 1454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65208, 0, 1, 0.764822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263592,-99) , 
0, -0.035315, 1, 0, 0.474302,-99) , 
3, 0.498733, 0, 0, 0.619343,-99) , 
NN(
0, 
0, 
-1, -2.51925, 1, -1, 0.173269,-99) , 
3, -0.774089, 0, 0, 0.507534,-99)    );
  // itree = 1455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.906187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372272,-99) , 
0, 1.37002, 1, 0, 0.70067,-99) , 
3, 1.42395, 0, 0, 0.774515,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219816,-99) , 
0, -0.15133, 1, 0, 0.435016,-99) , 
NN(
0, 
0, 
-1, -1.61239, 0, -1, 0.121999,-99) , 
3, -0.95712, 0, 0, 0.313725,-99) , 
3, 0.402144, 0, 0, 0.51023,-99)    );
  // itree = 1456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34951, 0, 1, 0.814323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404843,-99) , 
0, -0.742611, 1, 0, 0.50792,-99) , 
3, 0.815436, 0, 0, 0.632188,-99) , 
NN(
0, 
0, 
-1, -1.7195, 0, -1, 0.141605,-99) , 
3, -0.680259, 0, 0, 0.481384,-99)    );
  // itree = 1457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25435, 1, 1, 0.894141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444179,-99) , 
0, 0.205991, 1, 0, 0.582819,-99) , 
3, 1.18544, 0, 0, 0.689887,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194296,-99) , 
0, -1.39661, 1, 0, 0.297804,-99) , 
NN(
0, 
0, 
-1, -1.68225, 0, -1, 0.0698824,-99) , 
3, -1.24633, 0, 0, 0.218589,-99) , 
3, -0.218528, 0, 0, 0.502405,-99)    );
  // itree = 1458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1009, 1, 1, 0.818046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220922,-99) , 
0, 0.391814, 1, 0, 0.524717,-99) , 
3, 0.647429, 0, 0, 0.666296,-99) , 
NN(
0, 
0, 
-1, -1.47002, 0, -1, 0.154989,-99) , 
3, -0.580673, 0, 0, 0.518646,-99)    );
  // itree = 1459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.825044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380472,-99) , 
0, 0.0300823, 1, 0, 0.527552,-99) , 
3, 0.949517, 0, 0, 0.659705,-99) , 
NN(
0, 
0, 
-1, -0.0940381, 1, -1, 0.207629,-99) , 
3, -0.218528, 0, 0, 0.47261,-99)    );
  // itree = 1460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.874207,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411182,-99) , 
0, 0.689005, 1, 0, 0.684766,-99) , 
3, 1.08643, 0, 0, 0.784587,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330995,-99) , 
0, -0.795814, 1, 0, 0.450578,-99) , 
NN(
0, 
0, 
-1, -1.64422, 0, -1, 0.166606,-99) , 
3, -0.509187, 0, 0, 0.297314,-99) , 
3, 0.287809, 0, 0, 0.509993,-99)    );
  // itree = 1461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15491, 0, 1, 0.840754,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268429,-99) , 
0, 0.446087, 1, 0, 0.554779,-99) , 
3, 0.784282, 0, 0, 0.699456,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.256063,-99) , 
3, -0.133228, 0, 0, 0.530274,-99)    );
  // itree = 1462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54494, 1, 1, 0.894972,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271717,-99) , 
0, 1.2048, 1, 0, 0.580559,-99) , 
3, 1.1852, 0, 0, 0.685817,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213355,-99) , 
0, -1.33116, 1, 0, 0.34536,-99) , 
NN(
0, 
0, 
-1, -1.901, 0, -1, 0.0963026,-99) , 
3, -1.11347, 0, 0, 0.253255,-99) , 
3, -0.140694, 0, 0, 0.508508,-99)    );
  // itree = 1463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4972, 0, 1, 0.838271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39724,-99) , 
0, 0.525012, 1, 0, 0.57597,-99) , 
3, 0.965707, 0, 0, 0.733419,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201478,-99) , 
3, -1.03432, 0, 0, 0.487083,-99) , 
NN(
0, 
0, 
-1, -0.702899, 1, -1, 0.186801,-99) , 
1, -0.0038903, 1, 0, 0.295197,-99) , 
3, 0.34753, 0, 0, 0.498922,-99)    );
  // itree = 1464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.885378,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414337,-99) , 
0, 0.219879, 1, 0, 0.585225,-99) , 
3, 1.01311, 0, 0, 0.702899,-99) , 
NN(
0, 
0, 
-1, -0.895786, 0, -1, 0.236735,-99) , 
3, -0.133228, 0, 0, 0.506661,-99)    );
  // itree = 1465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.693011, 0, 1, 0.748538,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265465,-99) , 
0, -0.612827, 1, 0, 0.418099,-99) , 
NN(
0, 
0, 
-1, -1.62329, 0, -1, 0.149133,-99) , 
3, -0.770958, 0, 0, 0.297045,-99) , 
3, 0.289642, 0, 0, 0.497889,-99)    );
  // itree = 1466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.658683, 1, 1, 0.941198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464898,-99) , 
3, 1.38601, 0, 0, 0.751787,-99) , 
0, 1.38347, 1, 0, 0.83758,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211167,-99) , 
0, 0.35788, 1, 0, 0.483358,-99) , 
NN(
0, 
0, 
-1, -1.30442, 0, -1, 0.118254,-99) , 
3, -0.575176, 0, 0, 0.30934,-99) , 
3, 0.609067, 0, 0, 0.490668,-99)    );
  // itree = 1467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61457, 0, 1, 0.833248,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22426,-99) , 
0, 0.502964, 1, 0, 0.529274,-99) , 
3, 0.926722, 0, 0, 0.662125,-99) , 
NN(
0, 
0, 
-1, -1.69911, 0, -1, 0.248479,-99) , 
3, -0.206128, 0, 0, 0.503538,-99)    );
  // itree = 1468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.855912,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295381,-99) , 
0, 0.159825, 1, 0, 0.548247,-99) , 
3, 0.716715, 0, 0, 0.712914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224865,-99) , 
0, -1.30853, 1, 0, 0.356214,-99) , 
NN(
0, 
0, 
-1, -2.78954, 1, -1, 0.0683727,-99) , 
3, -1.24633, 0, 0, 0.253314,-99) , 
3, -0.218528, 0, 0, 0.532834,-99)    );
  // itree = 1469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34988, 1, 1, 0.896933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392172,-99) , 
0, 1.14736, 1, 0, 0.634676,-99) , 
3, 1.38065, 0, 0, 0.736646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221971,-99) , 
0, -0.114347, 1, 0, 0.458919,-99) , 
NN(
0, 
0, 
-1, -1.18474, 0, -1, 0.194464,-99) , 
3, -0.476904, 0, 0, 0.317553,-99) , 
3, 0.34753, 0, 0, 0.499007,-99)    );
  // itree = 1470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.345106, 1, 1, 0.794769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474388,-99) , 
1, 1.41463, 1, 0, 0.754294,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197007,-99) , 
0, -0.0761448, 1, 0, 0.464845,-99) , 
NN(
0, 
0, 
-1, 0.437224, 1, -1, 0.169147,-99) , 
3, -0.482249, 0, 0, 0.309476,-99) , 
3, 0.34753, 0, 0, 0.502696,-99)    );
  // itree = 1471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.03141, 0, 1, 0.83402,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228959,-99) , 
0, 0.190311, 1, 0, 0.439647,-99) , 
NN(
0, 
0, 
-1, -1.5293, 0, -1, 0.165896,-99) , 
3, -0.835565, 0, 0, 0.348266,-99) , 
3, 0.661338, 0, 0, 0.493833,-99)    );
  // itree = 1472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.842379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209592,-99) , 
0, 0.91729, 1, 0, 0.556329,-99) , 
3, 1.08354, 0, 0, 0.704481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215537,-99) , 
0, -0.333179, 1, 0, 0.412919,-99) , 
NN(
0, 
0, 
-1, -1.49813, 0, -1, 0.15715,-99) , 
3, -0.556859, 0, 0, 0.268213,-99) , 
3, 0.268003, 0, 0, 0.460017,-99)    );
  // itree = 1473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73189, 0, 1, 0.836508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327035,-99) , 
0, -0.328864, 1, 0, 0.488176,-99) , 
3, 0.616639, 0, 0, 0.667891,-99) , 
NN(
0, 
0, 
-1, -0.807403, 0, -1, 0.183045,-99) , 
3, -0.302053, 0, 0, 0.491715,-99)    );
  // itree = 1474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61511, 1, 1, 0.864764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423711,-99) , 
0, -0.117022, 1, 0, 0.558014,-99) , 
3, 0.941165, 0, 0, 0.694475,-99) , 
NN(
0, 
0, 
-1, -0.671895, 0, -1, 0.195056,-99) , 
3, -0.170545, 0, 0, 0.48476,-99)    );
  // itree = 1475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58127, 0, 1, 0.864034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346873,-99) , 
0, 0.635646, 1, 0, 0.57348,-99) , 
3, 1.08845, 0, 0, 0.677591,-99) , 
NN(
0, 
0, 
-1, -1.56253, 0, -1, 0.199158,-99) , 
3, -0.291428, 0, 0, 0.499458,-99)    );
  // itree = 1476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.886201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30295,-99) , 
0, 0.143304, 1, 0, 0.533018,-99) , 
3, 0.832586, 0, 0, 0.676932,-99) , 
NN(
0, 
0, 
-1, -2.33682, 1, -1, 0.143829,-99) , 
3, -0.707817, 0, 0, 0.537504,-99)    );
  // itree = 1477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60463, 0, 1, 0.855742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383619,-99) , 
0, 0.101849, 1, 0, 0.529889,-99) , 
3, 1.11359, 0, 0, 0.636783,-99) , 
NN(
0, 
0, 
-1, -1.50654, 0, -1, 0.183451,-99) , 
3, -0.613509, 0, 0, 0.501812,-99)    );
  // itree = 1478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.878764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29821,-99) , 
0, 0.453613, 1, 0, 0.571854,-99) , 
3, 0.746843, 0, 0, 0.725596,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210008,-99) , 
0, -1.27313, 1, 0, 0.330598,-99) , 
NN(
0, 
0, 
-1, -1.73486, 0, -1, 0.0993655,-99) , 
3, -1.13315, 0, 0, 0.237086,-99) , 
3, -0.145446, 0, 0, 0.529605,-99)    );
  // itree = 1479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.874916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205956,-99) , 
0, 0.940884, 1, 0, 0.591667,-99) , 
3, 1.08882, 0, 0, 0.701249,-99) , 
NN(
0, 
0, 
-1, -0.539811, 0, -1, 0.275108,-99) , 
3, -0.0426953, 0, 0, 0.517803,-99)    );
  // itree = 1480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.858206,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324725,-99) , 
0, 0.865651, 1, 0, 0.596032,-99) , 
3, 1.0209, 0, 0, 0.725117,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326621,-99) , 
0, -0.526005, 1, 0, 0.463661,-99) , 
NN(
0, 
0, 
-1, -1.36967, 0, -1, 0.176996,-99) , 
3, -0.363853, 0, 0, 0.269434,-99) , 
3, 0.191234, 0, 0, 0.484732,-99)    );
  // itree = 1481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69608, 1, 1, 0.883941,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266465,-99) , 
0, 0.89651, 1, 0, 0.532664,-99) , 
3, 1.08845, 0, 0, 0.654623,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.19165,-99) , 
3, -0.291428, 0, 0, 0.489326,-99)    );
  // itree = 1482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42386, 1, 1, 0.798724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312921,-99) , 
0, -0.0165485, 1, 0, 0.505239,-99) , 
3, 0.630536, 0, 0, 0.657469,-99) , 
NN(
0, 
0, 
-1, -1.56253, 0, -1, 0.215695,-99) , 
3, -0.291428, 0, 0, 0.500934,-99)    );
  // itree = 1483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42867, 1, 1, 0.906989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41931,-99) , 
0, 1.14736, 1, 0, 0.662067,-99) , 
3, 1.40076, 0, 0, 0.73336,-99) , 
NN(
0, 
0, 
-1, -0.387798, 0, -1, 0.236602,-99) , 
3, 0.163853, 0, 0, 0.471382,-99)    );
  // itree = 1484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.189011, 1, 1, 0.857557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16199,-99) , 
0, 0.830155, 1, 0, 0.568869,-99) , 
3, 0.965539, 0, 0, 0.694912,-99) , 
NN(
0, 
0, 
-1, -0.736279, 0, -1, 0.208352,-99) , 
3, -0.218528, 0, 0, 0.497477,-99)    );
  // itree = 1485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66115, 0, 1, 0.824811,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393969,-99) , 
0, -0.879309, 1, 0, 0.473236,-99) , 
NN(
0, 
0, 
-1, -1.84798, 0, -1, 0.144108,-99) , 
3, -0.727114, 0, 0, 0.351397,-99) , 
3, 0.742135, 0, 0, 0.490855,-99)    );
  // itree = 1486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.838355,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347842,-99) , 
0, -0.147815, 1, 0, 0.460108,-99) , 
NN(
0, 
0, 
-1, -1.18683, 1, -1, 0.193842,-99) , 
3, -0.140307, 0, 0, 0.304059,-99) , 
3, 0.742135, 0, 0, 0.463093,-99)    );
  // itree = 1487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.9174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400707,-99) , 
0, 0.758594, 1, 0, 0.629757,-99) , 
3, 1.14704, 0, 0, 0.764708,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191138,-99) , 
1, 0.148634, 1, 0, 0.43347,-99) , 
NN(
0, 
0, 
-1, -1.55739, 0, -1, 0.157896,-99) , 
3, -0.427087, 0, 0, 0.280895,-99) , 
3, 0.359779, 0, 0, 0.477735,-99)    );
  // itree = 1488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1009, 1, 1, 0.792759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30413,-99) , 
0, -0.0789444, 1, 0, 0.526028,-99) , 
3, 0.657932, 0, 0, 0.645091,-99) , 
NN(
0, 
0, 
-1, -2.08473, 1, -1, 0.1349,-99) , 
3, -0.613987, 0, 0, 0.489535,-99)    );
  // itree = 1489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.70676, 1, 1, 0.894124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314744,-99) , 
0, 0.939545, 1, 0, 0.608315,-99) , 
3, 1.18544, 0, 0, 0.707939,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.208925,-99) , 
3, -0.218528, 0, 0, 0.504463,-99)    );
  // itree = 1490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.822907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247603,-99) , 
0, 0.0477724, 1, 0, 0.518261,-99) , 
3, 0.628149, 0, 0, 0.680693,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.225609,-99) , 
3, -0.291428, 0, 0, 0.512245,-99)    );
  // itree = 1491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26569, 0, 1, 0.938013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493738,-99) , 
3, 1.68115, 0, 0, 0.72704,-99) , 
0, 1.46354, 1, 0, 0.826844,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218995,-99) , 
0, 0.399252, 1, 0, 0.466904,-99) , 
NN(
0, 
0, 
-1, 0.0176327, 1, -1, 0.172681,-99) , 
3, -0.441503, 0, 0, 0.342237,-99) , 
3, 0.742135, 0, 0, 0.487526,-99)    );
  // itree = 1492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67572, 0, 1, 0.871834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42692,-99) , 
0, 0.91729, 1, 0, 0.660339,-99) , 
3, 1.17269, 0, 0, 0.764715,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292822,-99) , 
0, -0.65582, 1, 0, 0.45763,-99) , 
NN(
0, 
0, 
-1, -1.42012, 0, -1, 0.1668,-99) , 
3, -0.477004, 0, 0, 0.295758,-99) , 
3, 0.34753, 0, 0, 0.494208,-99)    );
  // itree = 1493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42286, 1, 1, 0.892076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392076,-99) , 
0, 1.31188, 1, 0, 0.709158,-99) , 
3, 1.47158, 0, 0, 0.804406,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.179654,-99) , 
0, 0.550258, 1, 0, 0.458526,-99) , 
NN(
0, 
0, 
-1, -1.14663, 0, -1, 0.217403,-99) , 
3, -0.140307, 0, 0, 0.323487,-99) , 
3, 0.742135, 0, 0, 0.466072,-99)    );
  // itree = 1494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.860472,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321151,-99) , 
0, -0.0593231, 1, 0, 0.485294,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.0766253,-99) , 
3, -1.12187, 0, 0, 0.377263,-99) , 
3, 0.673895, 0, 0, 0.535192,-99)    );
  // itree = 1495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.85948,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417481,-99) , 
0, -0.0639868, 1, 0, 0.561684,-99) , 
3, 0.78913, 0, 0, 0.715142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30068,-99) , 
3, -0.895167, 0, 0, 0.404495,-99) , 
NN(
0, 
0, 
-1, -1.31635, 0, -1, 0.158458,-99) , 
1, 0.0176327, 1, 0, 0.253255,-99) , 
3, -0.133228, 0, 0, 0.525713,-99)    );
  // itree = 1496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11116, 0, 1, 0.830185,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.924047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407768,-99) , 
0, -0.707247, 1, 0, 0.50554,-99) , 
NN(
0, 
0, 
-1, -1.63158, 0, -1, 0.211478,-99) , 
3, -0.43371, 0, 0, 0.36387,-99) , 
3, 0.742135, 0, 0, 0.506579,-99)    );
  // itree = 1497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13666, 0, 1, 0.802775,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370725,-99) , 
0, -0.82711, 1, 0, 0.449839,-99) , 
NN(
0, 
0, 
-1, -1.11359, 0, -1, 0.170241,-99) , 
3, -0.667858, 0, 0, 0.343159,-99) , 
3, 0.778124, 0, 0, 0.479758,-99)    );
  // itree = 1498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56795, 0, 1, 0.859815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23461,-99) , 
0, 0.716184, 1, 0, 0.534523,-99) , 
3, 0.835097, 0, 0, 0.703368,-99) , 
NN(
0, 
0, 
-1, -0.576363, 0, -1, 0.201351,-99) , 
3, -0.0725463, 0, 0, 0.495544,-99)    );
  // itree = 1499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.861007,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216626,-99) , 
0, 0.619656, 1, 0, 0.548931,-99) , 
3, 0.969023, 0, 0, 0.685011,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.256164,-99) , 
3, -0.145446, 0, 0, 0.51398,-99)    );
  // itree = 1500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.853175,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333591,-99) , 
0, 0.936812, 1, 0, 0.622257,-99) , 
3, 1.11737, 0, 0, 0.741772,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204745,-99) , 
0, -0.263638, 1, 0, 0.423799,-99) , 
NN(
0, 
0, 
-1, -1.19423, 0, -1, 0.151545,-99) , 
3, -0.759929, 0, 0, 0.294818,-99) , 
3, 0.311026, 0, 0, 0.503424,-99)    );
  // itree = 1501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11586, 0, 1, 0.748795,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255369,-99) , 
0, -0.244936, 1, 0, 0.451257,-99) , 
NN(
0, 
0, 
-1, -1.75965, 0, -1, 0.172744,-99) , 
3, -0.854179, 0, 0, 0.323479,-99) , 
3, 0.27076, 0, 0, 0.521412,-99)    );
  // itree = 1502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.828137,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398051,-99) , 
0, 0.16021, 1, 0, 0.611069,-99) , 
3, 0.760729, 0, 0, 0.762758,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320196,-99) , 
0, -0.447798, 1, 0, 0.446339,-99) , 
NN(
0, 
0, 
-1, -1.6592, 0, -1, 0.156009,-99) , 
3, -0.476904, 0, 0, 0.291914,-99) , 
3, 0.34753, 0, 0, 0.498381,-99)    );
  // itree = 1503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.854901,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353579,-99) , 
3, 0.037713, 0, 0, 0.552963,-99) , 
3, 1.08845, 0, 0, 0.665299,-99) , 
NN(
0, 
0, 
-1, -0.799257, 0, -1, 0.196468,-99) , 
3, -0.291428, 0, 0, 0.49193,-99)    );
  // itree = 1504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38501, 1, 1, 0.816812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.885005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335133,-99) , 
0, 0.0584112, 1, 0, 0.529729,-99) , 
3, 0.667245, 0, 0, 0.704765,-99) , 
NN(
0, 
0, 
-1, -0.512219, 0, -1, 0.232336,-99) , 
3, -0.0172488, 0, 0, 0.494006,-99)    );
  // itree = 1505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.865443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365686,-99) , 
0, 1.11769, 1, 0, 0.678614,-99) , 
3, 1.17269, 0, 0, 0.762197,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20306,-99) , 
0, -0.114347, 1, 0, 0.484622,-99) , 
NN(
0, 
0, 
-1, -1.65762, 0, -1, 0.165406,-99) , 
3, -0.481272, 0, 0, 0.309042,-99) , 
3, 0.34753, 0, 0, 0.497565,-99)    );
  // itree = 1506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60131, 0, 1, 0.848919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441634,-99) , 
0, 0.0112647, 1, 0, 0.594467,-99) , 
3, 0.91488, 0, 0, 0.712829,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182147,-99) , 
0, -1.08805, 1, 0, 0.336632,-99) , 
NN(
0, 
0, 
-1, -2.65422, 1, -1, 0.144316,-99) , 
3, -1.20998, 0, 0, 0.264954,-99) , 
3, -0.216753, 0, 0, 0.524027,-99)    );
  // itree = 1507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14589, 0, 1, 0.816262,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354949,-99) , 
0, 0.0510396, 1, 0, 0.589592,-99) , 
3, 0.555454, 0, 0, 0.741507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248383,-99) , 
0, -1.33116, 1, 0, 0.37127,-99) , 
NN(
0, 
0, 
-1, -1.75588, 0, -1, 0.0808674,-99) , 
3, -1.14354, 0, 0, 0.259265,-99) , 
3, -0.133228, 0, 0, 0.535717,-99)    );
  // itree = 1508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.76256, 0, 1, 0.819538,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331631,-99) , 
0, -1.35158, 1, 0, 0.391975,-99) , 
NN(
0, 
0, 
-1, -0.107393, 1, -1, 0.0894206,-99) , 
3, -1.13255, 0, 0, 0.32781,-99) , 
3, 0.661338, 0, 0, 0.507369,-99)    );
  // itree = 1509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11485, 0, 1, 0.822284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278645,-99) , 
0, 0.0477724, 1, 0, 0.531736,-99) , 
3, 0.56324, 0, 0, 0.691585,-99) , 
NN(
0, 
0, 
-1, -1.12553, 0, -1, 0.194059,-99) , 
3, -0.351682, 0, 0, 0.52819,-99)    );
  // itree = 1510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8507, 1, 1, 0.917787,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457405,-99) , 
0, 0.891798, 1, 0, 0.654282,-99) , 
3, 1.3702, 0, 0, 0.754071,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186722,-99) , 
0, -0.150485, 1, 0, 0.402775,-99) , 
NN(
0, 
0, 
-1, -1.54081, 0, -1, 0.163648,-99) , 
3, -0.678388, 0, 0, 0.292283,-99) , 
3, 0.377562, 0, 0, 0.484875,-99)    );
  // itree = 1511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36045, 1, 1, 0.817508,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277971,-99) , 
0, -0.0153026, 1, 0, 0.46638,-99) , 
NN(
0, 
0, 
-1, -1.74083, 0, -1, 0.215849,-99) , 
3, -0.528692, 0, 0, 0.352074,-99) , 
3, 0.673895, 0, 0, 0.499871,-99)    );
  // itree = 1512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.794247,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273048,-99) , 
0, 0.102433, 1, 0, 0.47974,-99) , 
NN(
0, 
0, 
-1, -0.101711, 1, -1, 0.185765,-99) , 
3, -0.485703, 0, 0, 0.345205,-99) , 
3, 0.677307, 0, 0, 0.498307,-99)    );
  // itree = 1513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.53239, 1, 1, 0.875369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3912,-99) , 
0, 0.985828, 1, 0, 0.636437,-99) , 
3, 1.17174, 0, 0, 0.743204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289511,-99) , 
0, -0.636798, 1, 0, 0.423451,-99) , 
NN(
0, 
0, 
-1, -1.42405, 0, -1, 0.177871,-99) , 
3, -0.480034, 0, 0, 0.282173,-99) , 
3, 0.34753, 0, 0, 0.480221,-99)    );
  // itree = 1514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6311, 0, 1, 0.805557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281695,-99) , 
0, 0.0806859, 1, 0, 0.54133,-99) , 
3, 0.398358, 0, 0, 0.69006,-99) , 
NN(
0, 
0, 
-1, -1.75968, 0, -1, 0.133237,-99) , 
3, -0.613987, 0, 0, 0.52275,-99)    );
  // itree = 1515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69405, 0, 1, 0.847297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218349,-99) , 
0, 0.865651, 1, 0, 0.554039,-99) , 
3, 1.01964, 0, 0, 0.704473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335897,-99) , 
0, -0.898913, 1, 0, 0.446545,-99) , 
NN(
0, 
0, 
-1, -1.94633, 1, -1, 0.155878,-99) , 
3, -0.643253, 0, 0, 0.295658,-99) , 
3, 0.191234, 0, 0, 0.49622,-99)    );
  // itree = 1516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.18831, 0, 1, 0.809021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255958,-99) , 
0, 0.245844, 1, 0, 0.506673,-99) , 
3, 0.606621, 0, 0, 0.682377,-99) , 
NN(
0, 
0, 
-1, -1.56687, 0, -1, 0.225387,-99) , 
3, -0.0725463, 0, 0, 0.478665,-99)    );
  // itree = 1517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56663, 1, 1, 0.883589,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379527,-99) , 
0, 0.866658, 1, 0, 0.631336,-99) , 
3, 1.16365, 0, 0, 0.729862,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264938,-99) , 
0, -0.952508, 1, 0, 0.422833,-99) , 
NN(
0, 
0, 
-1, -1.66614, 0, -1, 0.182414,-99) , 
3, -0.696161, 0, 0, 0.280486,-99) , 
3, 0.131392, 0, 0, 0.502469,-99)    );
  // itree = 1518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11005, 0, 1, 0.744052,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257221,-99) , 
0, -0.381656, 1, 0, 0.42911,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.127489,-99) , 
3, -0.569108, 0, 0, 0.25458,-99) , 
3, 0.27076, 0, 0, 0.469301,-99)    );
  // itree = 1519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.14123, 1, 1, 0.833673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324305,-99) , 
0, 0.461514, 1, 0, 0.543822,-99) , 
3, 0.932403, 0, 0, 0.671359,-99) , 
NN(
0, 
0, 
-1, -1.69911, 0, -1, 0.229039,-99) , 
3, -0.206128, 0, 0, 0.503701,-99)    );
  // itree = 1520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.84675, 0, 1, 0.782846,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355562,-99) , 
0, -0.678004, 1, 0, 0.473169,-99) , 
NN(
0, 
0, 
-1, -1.51365, 1, -1, 0.194156,-99) , 
3, -0.374073, 0, 0, 0.315143,-99) , 
3, 0.440796, 0, 0, 0.499846,-99)    );
  // itree = 1521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60115, 0, 1, 0.875483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442402,-99) , 
0, -0.671329, 1, 0, 0.517829,-99) , 
3, 1.0887, 0, 0, 0.631945,-99) , 
NN(
0, 
0, 
-1, -1.17855, 0, -1, 0.159357,-99) , 
3, -0.707817, 0, 0, 0.4981,-99)    );
  // itree = 1522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38353, 1, 1, 0.828807,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378874,-99) , 
0, -0.0219203, 1, 0, 0.551557,-99) , 
NN(
0, 
0, 
-1, -1.52448, 0, -1, 0.224357,-99) , 
3, -0.239923, 0, 0, 0.354344,-99) , 
3, 0.673895, 0, 0, 0.514409,-99)    );
  // itree = 1523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47056, 1, 1, 0.807095,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323938,-99) , 
0, 0.527794, 1, 0, 0.580722,-99) , 
3, 0.799619, 0, 0, 0.716819,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244241,-99) , 
1, 0.0618715, 1, 0, 0.393377,-99) , 
NN(
0, 
0, 
-1, -1.14246, 0, -1, 0.121835,-99) , 
3, -0.646522, 0, 0, 0.244871,-99) , 
3, 0.179643, 0, 0, 0.469247,-99)    );
  // itree = 1524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.832619,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299789,-99) , 
0, 0.213256, 1, 0, 0.49756,-99) , 
NN(
0, 
0, 
-1, -1.19687, 0, -1, 0.190773,-99) , 
3, -0.451773, 0, 0, 0.362529,-99) , 
3, 0.760049, 0, 0, 0.522747,-99)    );
  // itree = 1525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22228, 1, 1, 0.875429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319149,-99) , 
0, 0.865651, 1, 0, 0.621091,-99) , 
3, 1.11005, 0, 0, 0.74882,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251033,-99) , 
0, -0.607343, 1, 0, 0.390607,-99) , 
NN(
0, 
0, 
-1, -1.55014, 0, -1, 0.161026,-99) , 
3, -0.580365, 0, 0, 0.275564,-99) , 
3, 0.27076, 0, 0, 0.493266,-99)    );
  // itree = 1526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19832, 1, 1, 0.898497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483687,-99) , 
0, 0.822751, 1, 0, 0.656372,-99) , 
3, 1.62602, 0, 0, 0.714153,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621696,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22087,-99) , 
0, -0.333179, 1, 0, 0.42662,-99) , 
NN(
0, 
0, 
-1, -1.14182, 0, -1, 0.139553,-99) , 
3, -0.649945, 0, 0, 0.277354,-99) , 
3, 0.179643, 0, 0, 0.488129,-99)    );
  // itree = 1527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.855088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388521,-99) , 
0, 0.376975, 1, 0, 0.569689,-99) , 
3, 1.06271, 0, 0, 0.663515,-99) , 
NN(
0, 
0, 
-1, -1.5887, 0, -1, 0.157704,-99) , 
3, -0.680259, 0, 0, 0.519794,-99)    );
  // itree = 1528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.09581, 0, 1, 0.728969,-99) , 
NN(
0, 
0, 
-1, -0.449377, 0, -1, 0.251836,-99) , 
2, -0.237487, 0, 0, 0.510729,-99)    );
  // itree = 1529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.824886,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317797,-99) , 
0, 0.163923, 1, 0, 0.539523,-99) , 
3, 0.63535, 0, 0, 0.69757,-99) , 
NN(
0, 
0, 
-1, -0.75309, 0, -1, 0.198891,-99) , 
3, -0.260982, 0, 0, 0.515662,-99)    );
  // itree = 1530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.860303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30535,-99) , 
0, 0.625707, 1, 0, 0.541732,-99) , 
3, 0.926722, 0, 0, 0.682044,-99) , 
NN(
0, 
0, 
-1, -0.716991, 0, -1, 0.196098,-99) , 
3, -0.206128, 0, 0, 0.510349,-99)    );
  // itree = 1531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.01048, 0, 1, 0.780656,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237112,-99) , 
0, 0.259256, 1, 0, 0.485983,-99) , 
NN(
0, 
0, 
-1, -1.51536, 0, -1, 0.151729,-99) , 
3, -0.546876, 0, 0, 0.332005,-99) , 
3, 0.644232, 0, 0, 0.478096,-99)    );
  // itree = 1532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60699, 1, 1, 0.835053,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19823,-99) , 
0, 0.259657, 1, 0, 0.436476,-99) , 
NN(
0, 
0, 
-1, -1.74319, 0, -1, 0.202426,-99) , 
3, -0.531196, 0, 0, 0.326714,-99) , 
3, 0.673895, 0, 0, 0.496939,-99)    );
  // itree = 1533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.760729, 0, 1, 0.767182,-99) , 
NN(
0, 
0, 
-1, -1.02909, 0, -1, 0.276458,-99) , 
3, 0.34753, 0, 0, 0.476807,-99)    );
  // itree = 1534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.878225,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294733,-99) , 
0, 0.969329, 1, 0, 0.595705,-99) , 
3, 1.05859, 0, 0, 0.705841,-99) , 
NN(
0, 
0, 
-1, -1.56671, 0, -1, 0.228509,-99) , 
3, -0.0725463, 0, 0, 0.491963,-99)    );
  // itree = 1535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.875083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39737,-99) , 
0, 0.329667, 1, 0, 0.586392,-99) , 
3, 0.904774, 0, 0, 0.764546,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248939,-99) , 
0, -0.449573, 1, 0, 0.442312,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.172258,-99) , 
3, -0.569108, 0, 0, 0.285294,-99) , 
3, 0.27076, 0, 0, 0.49591,-99)    );
  // itree = 1536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3066, 1, 1, 0.891386,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404349,-99) , 
0, 1.16236, 1, 0, 0.668571,-99) , 
3, 1.31972, 0, 0, 0.761911,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250938,-99) , 
0, -0.785825, 1, 0, 0.455815,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.186046,-99) , 
3, -0.569108, 0, 0, 0.296715,-99) , 
3, 0.27076, 0, 0, 0.50623,-99)    );
  // itree = 1537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.871805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454472,-99) , 
0, -0.461566, 1, 0, 0.559265,-99) , 
3, 0.957575, 0, 0, 0.693523,-99) , 
NN(
0, 
0, 
-1, -0.749949, 1, -1, 0.213302,-99) , 
3, -0.156071, 0, 0, 0.498675,-99)    );
  // itree = 1538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.37491, 1, 1, 0.882009,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258267,-99) , 
0, 1.07553, 1, 0, 0.571775,-99) , 
3, 1.24775, 0, 0, 0.671472,-99) , 
NN(
0, 
0, 
-1, -1.64431, 0, -1, 0.205414,-99) , 
3, -0.133228, 0, 0, 0.473588,-99)    );
  // itree = 1539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.872629,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427267,-99) , 
0, 0.451048, 1, 0, 0.617996,-99) , 
3, 1.18544, 0, 0, 0.701705,-99) , 
NN(
0, 
0, 
-1, -1.24832, 0, -1, 0.215877,-99) , 
3, -0.218528, 0, 0, 0.505499,-99)    );
  // itree = 1540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41775, 1, 1, 0.829078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302928,-99) , 
0, 0.213031, 1, 0, 0.5452,-99) , 
3, 0.645176, 0, 0, 0.725477,-99) , 
NN(
0, 
0, 
-1, -0.525775, 0, -1, 0.239738,-99) , 
3, -0.0295996, 0, 0, 0.501523,-99)    );
  // itree = 1541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.853224,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.876295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348881,-99) , 
0, 0.702199, 1, 0, 0.637035,-99) , 
3, 1.0726, 0, 0, 0.749312,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17485,-99) , 
0, -0.243326, 1, 0, 0.444432,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.149345,-99) , 
3, -0.554775, 0, 0, 0.291336,-99) , 
3, 0.256412, 0, 0, 0.496961,-99)    );
  // itree = 1542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09439, 0, 1, 0.894172,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468994,-99) , 
3, 1.42264, 0, 0, 0.729998,-99) , 
0, 1.25111, 1, 0, 0.790471,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242697,-99) , 
0, 0.423428, 1, 0, 0.483782,-99) , 
NN(
0, 
0, 
-1, -1.49958, 0, -1, 0.189089,-99) , 
3, -0.531196, 0, 0, 0.355468,-99) , 
3, 0.673895, 0, 0, 0.49969,-99)    );
  // itree = 1543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28121, 1, 1, 0.808962,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239659,-99) , 
0, 0.231365, 1, 0, 0.519547,-99) , 
3, 0.598954, 0, 0, 0.68271,-99) , 
NN(
0, 
0, 
-1, -1.07906, 0, -1, 0.249255,-99) , 
3, -0.316527, 0, 0, 0.525517,-99)    );
  // itree = 1544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.837178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253724,-99) , 
0, 0.629373, 1, 0, 0.535938,-99) , 
3, 0.995374, 0, 0, 0.638185,-99) , 
NN(
0, 
0, 
-1, -1.1958, 0, -1, 0.145151,-99) , 
3, -0.730127, 0, 0, 0.503177,-99)    );
  // itree = 1545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.19347, 0, 1, 0.826663,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260081,-99) , 
0, 0.155544, 1, 0, 0.465859,-99) , 
NN(
0, 
0, 
-1, -1.51536, 0, -1, 0.162081,-99) , 
3, -0.546876, 0, 0, 0.321871,-99) , 
3, 0.644232, 0, 0, 0.498872,-99)    );
  // itree = 1546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24223, 1, 1, 0.856125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313323,-99) , 
0, 1.10579, 1, 0, 0.661902,-99) , 
3, 1.17269, 0, 0, 0.748395,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295758,-99) , 
0, -0.814411, 1, 0, 0.414622,-99) , 
NN(
0, 
0, 
-1, -1.65207, 0, -1, 0.161285,-99) , 
3, -0.754564, 0, 0, 0.293965,-99) , 
3, 0.34753, 0, 0, 0.486067,-99)    );
  // itree = 1547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.878585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303986,-99) , 
0, 0.91729, 1, 0, 0.619861,-99) , 
3, 1.11005, 0, 0, 0.751852,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289985,-99) , 
0, -0.65582, 1, 0, 0.410834,-99) , 
NN(
0, 
0, 
-1, 0.0176327, 1, -1, 0.168476,-99) , 
3, -0.569108, 0, 0, 0.278628,-99) , 
3, 0.27076, 0, 0, 0.48999,-99)    );
  // itree = 1548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90169, 1, 1, 0.874364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422974,-99) , 
0, 0.027439, 1, 0, 0.582958,-99) , 
3, 1.19191, 0, 0, 0.679509,-99) , 
NN(
0, 
0, 
-1, -0.659741, 0, -1, 0.184559,-99) , 
3, -0.145446, 0, 0, 0.45871,-99)    );
  // itree = 1549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66929, 0, 1, 0.860502,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214572,-99) , 
0, 0.625707, 1, 0, 0.553394,-99) , 
3, 0.95337, 0, 0, 0.676862,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176543,-99) , 
0, -1.5543, 1, 0, 0.290062,-99) , 
NN(
0, 
0, 
-1, 0.0225495, 1, -1, 0.0465136,-99) , 
3, -1.24788, 0, 0, 0.2191,-99) , 
3, -0.218528, 0, 0, 0.504243,-99)    );
  // itree = 1550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.860569, 1, 1, 0.930657,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465723,-99) , 
3, 1.5537, 0, 0, 0.724059,-99) , 
0, 1.31919, 1, 0, 0.81275,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300933,-99) , 
0, 0.0208352, 1, 0, 0.465388,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.209985,-99) , 
3, -0.576554, 0, 0, 0.362831,-99) , 
3, 0.609067, 0, 0, 0.524267,-99)    );
  // itree = 1551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.826691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338146,-99) , 
0, 0.190909, 1, 0, 0.537918,-99) , 
3, 0.91703, 0, 0, 0.668409,-99) , 
NN(
0, 
0, 
-1, -1.38449, 0, -1, 0.199955,-99) , 
3, -0.177886, 0, 0, 0.465232,-99)    );
  // itree = 1552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60008, 0, 1, 0.887404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286513,-99) , 
0, 0.879328, 1, 0, 0.602268,-99) , 
3, 1.08754, 0, 0, 0.724384,-99) , 
NN(
0, 
0, 
-1, -0.540218, 0, -1, 0.251038,-99) , 
3, -0.0447319, 0, 0, 0.507175,-99)    );
  // itree = 1553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.815857,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351199,-99) , 
0, -0.0721965, 1, 0, 0.517616,-99) , 
NN(
0, 
0, 
-1, -1.67865, 0, -1, 0.214926,-99) , 
3, -0.45279, 0, 0, 0.372197,-99) , 
3, 0.760049, 0, 0, 0.511188,-99)    );
  // itree = 1554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41302, 1, 1, 0.776096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47642,-99) , 
3, 0.400737, 0, 0, 0.722985,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301086,-99) , 
1, 0.00938889, 1, 0, 0.460774,-99) , 
NN(
0, 
0, 
-1, -1.3765, 0, -1, 0.174988,-99) , 
3, -0.639477, 0, 0, 0.311884,-99) , 
3, 0.191234, 0, 0, 0.507661,-99)    );
  // itree = 1555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.576584, 0, 1, 0.801575,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210165,-99) , 
0, -1.05401, 1, 0, 0.323886,-99) , 
NN(
0, 
0, 
-1, -1.59299, 0, -1, 0.0785372,-99) , 
3, -1.21089, 0, 0, 0.255239,-99) , 
3, 0.163853, 0, 0, 0.517563,-99)    );
  // itree = 1556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66854, 1, 1, 0.847152,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298678,-99) , 
0, 0.123422, 1, 0, 0.480437,-99) , 
NN(
0, 
0, 
-1, -1.72072, 0, -1, 0.17275,-99) , 
3, -0.598077, 0, 0, 0.36563,-99) , 
3, 0.876835, 0, 0, 0.498334,-99)    );
  // itree = 1557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.83254,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268226,-99) , 
0, 0.158188, 1, 0, 0.455247,-99) , 
NN(
0, 
0, 
-1, -1.12564, 0, -1, 0.154144,-99) , 
3, -0.68166, 0, 0, 0.348203,-99) , 
3, 0.761018, 0, 0, 0.500661,-99)    );
  // itree = 1558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55843, 1, 1, 0.842246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3776,-99) , 
0, 0.214206, 1, 0, 0.538297,-99) , 
3, 0.94315, 0, 0, 0.667442,-99) , 
NN(
0, 
0, 
-1, -0.763376, 1, -1, 0.200427,-99) , 
3, -0.170545, 0, 0, 0.468217,-99)    );
  // itree = 1559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16149, 1, 1, 0.822495,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239299,-99) , 
0, 0.36783, 1, 0, 0.517871,-99) , 
3, 0.57108, 0, 0, 0.68131,-99) , 
NN(
0, 
0, 
-1, -1.10006, 0, -1, 0.175712,-99) , 
3, -0.346282, 0, 0, 0.505394,-99)    );
  // itree = 1560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72873, 1, 1, 0.893136,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369973,-99) , 
0, 0.272017, 1, 0, 0.576647,-99) , 
3, 1.07106, 0, 0, 0.70017,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230306,-99) , 
0, -1.02974, 1, 0, 0.376004,-99) , 
NN(
0, 
0, 
-1, -1.46603, 0, -1, 0.163238,-99) , 
3, -0.821417, 0, 0, 0.257899,-99) , 
3, -0.0725463, 0, 0, 0.495392,-99)    );
  // itree = 1561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.86322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248273,-99) , 
0, 1.01958, 1, 0, 0.597083,-99) , 
3, 1.09229, 0, 0, 0.703078,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227295,-99) , 
0, -1.35357, 1, 0, 0.32248,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.0284352,-99) , 
3, -1.50946, 0, 0, 0.243721,-99) , 
3, -0.0295996, 0, 0, 0.497044,-99)    );
  // itree = 1562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.10119, 0, 1, 0.793242,-99) , 
NN(
0, 
0, 
-1, -1.5349, 0, -1, 0.347302,-99) , 
3, 0.749733, 0, 0, 0.488604,-99)    );
  // itree = 1563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74538, 0, 1, 0.877725,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291159,-99) , 
0, 0.651935, 1, 0, 0.550609,-99) , 
3, 1.0878, 0, 0, 0.667262,-99) , 
NN(
0, 
0, 
-1, -1.56253, 0, -1, 0.208203,-99) , 
3, -0.291428, 0, 0, 0.497187,-99)    );
  // itree = 1564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37169, 0, 1, 0.820801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344608,-99) , 
0, 0.142002, 1, 0, 0.518282,-99) , 
3, 1.04917, 0, 0, 0.610768,-99) , 
NN(
0, 
0, 
-1, -1.55336, 0, -1, 0.154328,-99) , 
3, -0.663377, 0, 0, 0.484248,-99)    );
  // itree = 1565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61457, 0, 1, 0.837258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347094,-99) , 
0, 0.232439, 1, 0, 0.510913,-99) , 
3, 0.926722, 0, 0, 0.661106,-99) , 
NN(
0, 
0, 
-1, 0.0763172, 1, -1, 0.188776,-99) , 
3, -0.206128, 0, 0, 0.479077,-99)    );
  // itree = 1566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57345, 0, 1, 0.849266,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333715,-99) , 
0, 0.895962, 1, 0, 0.598144,-99) , 
3, 1.07526, 0, 0, 0.693548,-99) , 
NN(
0, 
0, 
-1, -1.57371, 0, -1, 0.212727,-99) , 
3, -0.302053, 0, 0, 0.515162,-99)    );
  // itree = 1567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36082, 0, 1, 0.802609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32327,-99) , 
0, 0.08705, 1, 0, 0.513123,-99) , 
3, 0.616639, 0, 0, 0.669885,-99) , 
NN(
0, 
0, 
-1, -1.07034, 0, -1, 0.195251,-99) , 
3, -0.302053, 0, 0, 0.509464,-99)    );
  // itree = 1568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.876538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437686,-99) , 
0, 0.985893, 1, 0, 0.703204,-99) , 
3, 1.17174, 0, 0, 0.790041,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264675,-99) , 
1, -0.614963, 1, 0, 0.328049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0176433,-99) , 
3, -1.57572, 0, 0, 0.27979,-99) , 
3, 0.34753, 0, 0, 0.489825,-99)    );
  // itree = 1569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.69274, 0, 1, 0.817388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203803,-99) , 
0, 0.143304, 1, 0, 0.439561,-99) , 
NN(
0, 
0, 
-1, -1.6834, 0, -1, 0.167557,-99) , 
3, -0.754651, 0, 0, 0.348449,-99) , 
3, 0.760049, 0, 0, 0.494437,-99)    );
  // itree = 1570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.606045, 0, 1, 0.72883,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276471,-99) , 
0, -0.781475, 1, 0, 0.422477,-99) , 
NN(
0, 
0, 
-1, -1.14182, 0, -1, 0.139221,-99) , 
3, -0.644483, 0, 0, 0.263509,-99) , 
3, 0.191234, 0, 0, 0.481141,-99)    );
  // itree = 1571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.853792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330898,-99) , 
0, 0.0112647, 1, 0, 0.51853,-99) , 
NN(
0, 
0, 
-1, -1.18839, 0, -1, 0.157607,-99) , 
3, -0.451773, 0, 0, 0.32249,-99) , 
3, 0.760049, 0, 0, 0.487506,-99)    );
  // itree = 1572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25435, 1, 1, 0.877574,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471715,-99) , 
0, 0.150326, 1, 0, 0.598036,-99) , 
3, 1.19964, 0, 0, 0.688828,-99) , 
NN(
0, 
0, 
-1, -1.48277, 0, -1, 0.169851,-99) , 
3, -0.547237, 0, 0, 0.514034,-99)    );
  // itree = 1573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.30912, 1, 1, 0.876109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361136,-99) , 
0, 0.978225, 1, 0, 0.606405,-99) , 
3, 1.17269, 0, 0, 0.73553,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142722,-99) , 
0, -0.111037, 1, 0, 0.365294,-99) , 
NN(
0, 
0, 
-1, -1.36807, 1, -1, 0.17132,-99) , 
3, -0.476904, 0, 0, 0.2692,-99) , 
3, 0.34753, 0, 0, 0.455802,-99)    );
  // itree = 1574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13594, 0, 1, 0.838942,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370474,-99) , 
0, -0.816289, 1, 0, 0.458645,-99) , 
NN(
0, 
0, 
-1, -1.68619, 0, -1, 0.181876,-99) , 
3, -0.754651, 0, 0, 0.370632,-99) , 
3, 0.760049, 0, 0, 0.513494,-99)    );
  // itree = 1575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.867918,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291822,-99) , 
0, 0.143304, 1, 0, 0.535763,-99) , 
3, 0.829342, 0, 0, 0.672348,-99) , 
NN(
0, 
0, 
-1, -1.08458, 0, -1, 0.176867,-99) , 
3, -0.636326, 0, 0, 0.534861,-99)    );
  // itree = 1576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.850668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327864,-99) , 
0, 0.0381911, 1, 0, 0.531671,-99) , 
3, 0.790117, 0, 0, 0.683575,-99) , 
NN(
0, 
0, 
-1, -1.11497, 0, -1, 0.197031,-99) , 
3, -0.351682, 0, 0, 0.493257,-99)    );
  // itree = 1577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00567, 1, 1, 0.827306,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.927801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380772,-99) , 
0, 0.0510396, 1, 0, 0.567451,-99) , 
3, 0.639192, 0, 0, 0.733812,-99) , 
NN(
0, 
0, 
-1, -0.546985, 0, -1, 0.280999,-99) , 
3, -0.0426953, 0, 0, 0.53106,-99)    );
  // itree = 1578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.854273,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190816,-99) , 
0, 0.235372, 1, 0, 0.441519,-99) , 
NN(
0, 
0, 
-1, -1.82381, 0, -1, 0.0923773,-99) , 
3, -1.16641, 0, 0, 0.351864,-99) , 
3, 0.609067, 0, 0, 0.519637,-99)    );
  // itree = 1579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69083, 0, 1, 0.822276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315846,-99) , 
0, 0.295007, 1, 0, 0.537202,-99) , 
3, 0.740548, 0, 0, 0.680916,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174312,-99) , 
0, -1.36121, 1, 0, 0.273522,-99) , 
NN(
0, 
0, 
-1, -2.82701, 1, -1, 0.0870108,-99) , 
3, -1.24633, 0, 0, 0.206177,-99) , 
3, -0.218528, 0, 0, 0.481314,-99)    );
  // itree = 1580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.85021,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312973,-99) , 
0, 0.193161, 1, 0, 0.49275,-99) , 
NN(
0, 
0, 
-1, -1.08938, 0, -1, 0.193398,-99) , 
3, -0.363821, 0, 0, 0.355913,-99) , 
3, 0.828289, 0, 0, 0.501442,-99)    );
  // itree = 1581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.918879, 1, 1, 0.784342,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300696,-99) , 
0, -0.108913, 1, 0, 0.456863,-99) , 
3, 0.637508, 0, 0, 0.664262,-99) , 
NN(
0, 
0, 
-1, -0.540218, 0, -1, 0.24164,-99) , 
3, -0.0447319, 0, 0, 0.473867,-99)    );
  // itree = 1582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.890753,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290571,-99) , 
0, 0.143304, 1, 0, 0.479987,-99) , 
NN(
0, 
0, 
-1, -1.57706, 0, -1, 0.169832,-99) , 
3, -0.665309, 0, 0, 0.352478,-99) , 
3, 0.828289, 0, 0, 0.505438,-99)    );
  // itree = 1583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44843, 1, 1, 0.877967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257196,-99) , 
0, 0.866981, 1, 0, 0.557912,-99) , 
3, 1.09401, 0, 0, 0.668572,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.179304,-99) , 
3, -0.707817, 0, 0, 0.536401,-99)    );
  // itree = 1584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.839779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427276,-99) , 
0, 0.227988, 1, 0, 0.57213,-99) , 
3, 1.01767, 0, 0, 0.684501,-99) , 
NN(
0, 
0, 
-1, -1.64431, 0, -1, 0.22188,-99) , 
3, -0.133228, 0, 0, 0.494312,-99)    );
  // itree = 1585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58127, 0, 1, 0.883132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350901,-99) , 
0, 0.840567, 1, 0, 0.599903,-99) , 
3, 1.08845, 0, 0, 0.711728,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224488,-99) , 
3, -0.723499, 0, 0, 0.344917,-99) , 
NN(
0, 
0, 
-1, -2.67157, 1, -1, 0.140683,-99) , 
3, -1.05418, 0, 0, 0.248174,-99) , 
3, -0.291428, 0, 0, 0.54375,-99)    );
  // itree = 1586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.09072, 0, 1, 0.834036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279562,-99) , 
0, 0.431079, 1, 0, 0.525766,-99) , 
NN(
0, 
0, 
-1, -1.63187, 0, -1, 0.186942,-99) , 
3, -0.44611, 0, 0, 0.369236,-99) , 
3, 0.729578, 0, 0, 0.509502,-99)    );
  // itree = 1587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.827739,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421804,-99) , 
0, -0.33941, 1, 0, 0.545478,-99) , 
3, 0.716715, 0, 0, 0.687716,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.208787,-99) , 
3, -0.218528, 0, 0, 0.512808,-99)    );
  // itree = 1588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45868, 0, 1, 0.874659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410368,-99) , 
0, 0.803606, 1, 0, 0.631909,-99) , 
3, 1.11419, 0, 0, 0.748372,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205502,-99) , 
0, -0.137889, 1, 0, 0.39994,-99) , 
NN(
0, 
0, 
-1, -1.55025, 0, -1, 0.145295,-99) , 
3, -0.58167, 0, 0, 0.262764,-99) , 
3, 0.27076, 0, 0, 0.466496,-99)    );
  // itree = 1589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63158, 1, 1, 0.887183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418733,-99) , 
0, 0.835519, 1, 0, 0.646578,-99) , 
3, 1.1486, 0, 0, 0.76341,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292016,-99) , 
0, -0.727528, 1, 0, 0.420095,-99) , 
NN(
0, 
0, 
-1, -1.56847, 0, -1, 0.128776,-99) , 
3, -0.70984, 0, 0, 0.275227,-99) , 
3, 0.349678, 0, 0, 0.472824,-99)    );
  // itree = 1590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.787345,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239904,-99) , 
0, 0.291557, 1, 0, 0.506948,-99) , 
3, 0.743321, 0, 0, 0.649716,-99) , 
NN(
0, 
0, 
-1, -1.11101, 0, -1, 0.228401,-99) , 
3, -0.140694, 0, 0, 0.480412,-99)    );
  // itree = 1591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62213, 0, 1, 0.850492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265086,-99) , 
0, 0.924863, 1, 0, 0.602299,-99) , 
3, 1.11291, 0, 0, 0.719362,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235347,-99) , 
0, -0.381656, 1, 0, 0.407518,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.183247,-99) , 
3, -0.569108, 0, 0, 0.276713,-99) , 
3, 0.27076, 0, 0, 0.467736,-99)    );
  // itree = 1592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.07769, 1, 1, 0.898569,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442521,-99) , 
0, 1.32989, 1, 0, 0.725764,-99) , 
3, 1.47086, 0, 0, 0.802113,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390941,-99) , 
0, -0.652258, 1, 0, 0.475034,-99) , 
NN(
0, 
0, 
-1, -1.11755, 0, -1, 0.179165,-99) , 
3, -0.392374, 0, 0, 0.331818,-99) , 
3, 0.761018, 0, 0, 0.481178,-99)    );
  // itree = 1593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.691558, 1, 1, 0.929171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.879851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497325,-99) , 
3, 1.42263, 0, 0, 0.736615,-99) , 
0, 1.20125, 1, 0, 0.812801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30116,-99) , 
0, -0.120907, 1, 0, 0.517535,-99) , 
NN(
0, 
0, 
-1, -1.26239, 0, -1, 0.193891,-99) , 
3, -0.238914, 0, 0, 0.338013,-99) , 
3, 0.661338, 0, 0, 0.498778,-99)    );
  // itree = 1594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46772, 0, 1, 0.824599,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326347,-99) , 
0, 0.179441, 1, 0, 0.531005,-99) , 
3, 0.736891, 0, 0, 0.66031,-99) , 
NN(
0, 
0, 
-1, -1.24525, 0, -1, 0.163645,-99) , 
3, -0.783748, 0, 0, 0.537929,-99)    );
  // itree = 1595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72119, 1, 1, 0.892946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383456,-99) , 
0, 0.924863, 1, 0, 0.620919,-99) , 
3, 1.11005, 0, 0, 0.748635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2195,-99) , 
0, -0.381656, 1, 0, 0.432221,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.201883,-99) , 
3, -0.574972, 0, 0, 0.320014,-99) , 
3, 0.27076, 0, 0, 0.521395,-99)    );
  // itree = 1596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6194, 0, 1, 0.816663,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29612,-99) , 
0, 0.0584112, 1, 0, 0.520452,-99) , 
3, 0.659973, 0, 0, 0.6966,-99) , 
NN(
0, 
0, 
-1, -0.748208, 0, -1, 0.226398,-99) , 
3, -0.011497, 0, 0, 0.485061,-99)    );
  // itree = 1597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78567, 1, 1, 0.843399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262521,-99) , 
0, 0.884488, 1, 0, 0.569146,-99) , 
3, 0.999275, 0, 0, 0.693279,-99) , 
NN(
0, 
0, 
-1, -0.605234, 0, -1, 0.206059,-99) , 
3, -0.117632, 0, 0, 0.503358,-99)    );
  // itree = 1598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06533, 1, 1, 0.840816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.929527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433497,-99) , 
0, -0.579814, 1, 0, 0.537313,-99) , 
3, 0.849125, 0, 0, 0.672862,-99) , 
NN(
0, 
0, 
-1, -1.57371, 0, -1, 0.219722,-99) , 
3, -0.302053, 0, 0, 0.520318,-99)    );
  // itree = 1599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60686, 0, 1, 0.809158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286065,-99) , 
0, 0.0208352, 1, 0, 0.493265,-99) , 
3, 0.645973, 0, 0, 0.646782,-99) , 
NN(
0, 
0, 
-1, -1.53081, 0, -1, 0.141303,-99) , 
3, -0.613987, 0, 0, 0.498441,-99)    );
  // itree = 1600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44843, 1, 1, 0.871352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.921363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470208,-99) , 
0, 0.027439, 1, 0, 0.598502,-99) , 
3, 1.08754, 0, 0, 0.70875,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.233955,-99) , 
3, -0.0447319, 0, 0, 0.506925,-99)    );
  // itree = 1601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11421, 1, 1, 0.84352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.916231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475274,-99) , 
0, -0.0639868, 1, 0, 0.631292,-99) , 
3, 0.784282, 0, 0, 0.748342,-99) , 
NN(
0, 
0, 
-1, -0.89076, 0, -1, 0.203052,-99) , 
3, -0.133228, 0, 0, 0.507452,-99)    );
  // itree = 1602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.849907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420319,-99) , 
0, -0.191245, 1, 0, 0.546844,-99) , 
3, 0.949517, 0, 0, 0.683726,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.179317,-99) , 
3, -0.218528, 0, 0, 0.489325,-99)    );
  // itree = 1603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.908336,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418049,-99) , 
0, 1.26127, 1, 0, 0.696554,-99) , 
3, 1.41842, 0, 0, 0.795377,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229043,-99) , 
0, 0.190311, 1, 0, 0.459636,-99) , 
NN(
0, 
0, 
-1, -0.901918, 1, -1, 0.156527,-99) , 
3, -0.524691, 0, 0, 0.317674,-99) , 
3, 0.673895, 0, 0, 0.464731,-99)    );
  // itree = 1604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.828163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344748,-99) , 
0, 0.0477724, 1, 0, 0.53845,-99) , 
3, 0.628149, 0, 0, 0.689332,-99) , 
NN(
0, 
0, 
-1, -1.05196, 0, -1, 0.221173,-99) , 
3, -0.291428, 0, 0, 0.537417,-99)    );
  // itree = 1605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.853303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416221,-99) , 
0, 0.830155, 1, 0, 0.633072,-99) , 
3, 1.03479, 0, 0, 0.759746,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299538,-99) , 
0, -0.920776, 1, 0, 0.426066,-99) , 
NN(
0, 
0, 
-1, -1.53953, 0, -1, 0.126736,-99) , 
3, -0.921238, 0, 0, 0.333115,-99) , 
3, 0.427177, 0, 0, 0.497552,-99)    );
  // itree = 1606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32004, 0, 1, 0.823049,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208874,-99) , 
0, 0.475416, 1, 0, 0.52634,-99) , 
NN(
0, 
0, 
-1, -1.18924, 0, -1, 0.236686,-99) , 
3, -0.148894, 0, 0, 0.349573,-99) , 
3, 0.760049, 0, 0, 0.499432,-99)    );
  // itree = 1607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74827, 0, 1, 0.879907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298886,-99) , 
0, 0.975226, 1, 0, 0.611838,-99) , 
3, 1.05859, 0, 0, 0.726069,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.261876,-99) , 
3, -0.0725463, 0, 0, 0.523164,-99)    );
  // itree = 1608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11186, 0, 1, 0.897005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458684,-99) , 
3, 1.56723, 0, 0, 0.711936,-99) , 
0, 1.38751, 1, 0, 0.79863,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254444,-99) , 
0, -0.0153026, 1, 0, 0.465408,-99) , 
NN(
0, 
0, 
-1, -1.52561, 0, -1, 0.176365,-99) , 
3, -0.548039, 0, 0, 0.349489,-99) , 
3, 0.644232, 0, 0, 0.505339,-99)    );
  // itree = 1609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61809, 0, 1, 0.882732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330033,-99) , 
0, 0.91729, 1, 0, 0.657398,-99) , 
3, 1.12707, 0, 0, 0.773769,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190174,-99) , 
0, -0.341503, 1, 0, 0.407451,-99) , 
NN(
0, 
0, 
-1, -0.684744, 1, -1, 0.16618,-99) , 
3, -0.483771, 0, 0, 0.27644,-99) , 
3, 0.322617, 0, 0, 0.500517,-99)    );
  // itree = 1610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66935, 0, 1, 0.847635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377835,-99) , 
0, -0.345495, 1, 0, 0.508252,-99) , 
NN(
0, 
0, 
-1, -1.77368, 0, -1, 0.173895,-99) , 
3, -0.667858, 0, 0, 0.377852,-99) , 
3, 0.778124, 0, 0, 0.532055,-99)    );
  // itree = 1611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.877627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342714,-99) , 
0, 0.654863, 1, 0, 0.596715,-99) , 
3, 1.07968, 0, 0, 0.72972,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337686,-99) , 
0, -0.817898, 1, 0, 0.439815,-99) , 
NN(
0, 
0, 
-1, -0.813719, 1, -1, 0.171735,-99) , 
3, -0.556859, 0, 0, 0.290844,-99) , 
3, 0.256412, 0, 0, 0.49834,-99)    );
  // itree = 1612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96112, 1, 1, 0.878326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454976,-99) , 
0, 0.790737, 1, 0, 0.636222,-99) , 
3, 1.07072, 0, 0, 0.780438,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208013,-99) , 
0, 0.176778, 1, 0, 0.515495,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.19287,-99) , 
3, -0.3393, 0, 0, 0.32396,-99) , 
3, 0.46693, 0, 0, 0.502189,-99)    );
  // itree = 1613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62451, 0, 1, 0.871643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384089,-99) , 
0, 0.826055, 1, 0, 0.5962,-99) , 
3, 1.11419, 0, 0, 0.73404,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308766,-99) , 
0, -0.62907, 1, 0, 0.509646,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.186045,-99) , 
3, -0.569108, 0, 0, 0.325077,-99) , 
3, 0.27076, 0, 0, 0.516105,-99)    );
  // itree = 1614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.887455,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480075,-99) , 
0, 0.702199, 1, 0, 0.67284,-99) , 
3, 1.17174, 0, 0, 0.770997,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250211,-99) , 
0, -0.243891, 1, 0, 0.420312,-99) , 
NN(
0, 
0, 
-1, -1.6592, 0, -1, 0.194385,-99) , 
3, -0.476904, 0, 0, 0.291031,-99) , 
3, 0.34753, 0, 0, 0.502047,-99)    );
  // itree = 1615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.70166, 0, 1, 0.858772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330715,-99) , 
0, 1.20935, 1, 0, 0.611508,-99) , 
3, 1.22704, 0, 0, 0.745597,-99) , 
NN(
0, 
0, 
-1, -1.1254, 0, -1, 0.307597,-99) , 
3, 0.673895, 0, 0, 0.455313,-99)    );
  // itree = 1616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59182, 1, 1, 0.878423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337808,-99) , 
0, 0.927932, 1, 0, 0.575176,-99) , 
3, 1.18232, 0, 0, 0.682073,-99) , 
NN(
0, 
0, 
-1, -0.731556, 0, -1, 0.215001,-99) , 
3, -0.218528, 0, 0, 0.507496,-99)    );
  // itree = 1617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.795507, 1, 1, 0.79681,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247084,-99) , 
0, 0.186933, 1, 0, 0.457891,-99) , 
NN(
0, 
0, 
-1, -1.64062, 0, -1, 0.13173,-99) , 
3, -0.750273, 0, 0, 0.332719,-99) , 
3, 0.712472, 0, 0, 0.475444,-99)    );
  // itree = 1618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37018, 0, 1, 0.851365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345751,-99) , 
0, -0.0696954, 1, 0, 0.530433,-99) , 
3, 0.845948, 0, 0, 0.682795,-99) , 
NN(
0, 
0, 
-1, -1.57306, 0, -1, 0.195155,-99) , 
3, -0.302053, 0, 0, 0.512587,-99)    );
  // itree = 1619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.14214, 0, 1, 0.846636,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256745,-99) , 
0, 0.418264, 1, 0, 0.514116,-99) , 
NN(
0, 
0, 
-1, -1.88715, 1, -1, 0.157085,-99) , 
3, -0.361957, 0, 0, 0.331577,-99) , 
3, 0.784899, 0, 0, 0.484634,-99)    );
  // itree = 1620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.897411, 0, 1, 0.911736,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.879168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437567,-99) , 
3, 1.453, 0, 0, 0.699414,-99) , 
0, 1.34359, 1, 0, 0.804328,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271637,-99) , 
0, -0.0979889, 1, 0, 0.484385,-99) , 
NN(
0, 
0, 
-1, 0.0509554, 1, -1, 0.157832,-99) , 
3, -0.626067, 0, 0, 0.325336,-99) , 
3, 0.451912, 0, 0, 0.509498,-99)    );
  // itree = 1621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.575913, 0, 1, 0.744902,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273824,-99) , 
0, -1.57478, 1, 0, 0.359083,-99) , 
NN(
0, 
0, 
-1, -1.7112, 0, -1, 0.113216,-99) , 
3, -1.21231, 0, 0, 0.28828,-99) , 
3, 0.163853, 0, 0, 0.516827,-99)    );
  // itree = 1622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75871, 1, 1, 0.909144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46598,-99) , 
0, 1.2677, 1, 0, 0.721284,-99) , 
3, 1.41017, 0, 0, 0.813604,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251073,-99) , 
0, 0.138796, 1, 0, 0.505767,-99) , 
NN(
0, 
0, 
-1, -0.47837, 1, -1, 0.186687,-99) , 
3, -0.226102, 0, 0, 0.320863,-99) , 
3, 0.673895, 0, 0, 0.49003,-99)    );
  // itree = 1623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.832767,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477755,-99) , 
0, 0.401279, 1, 0, 0.65518,-99) , 
3, 0.951526, 0, 0, 0.771798,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230232,-99) , 
0, -0.200686, 1, 0, 0.450706,-99) , 
NN(
0, 
0, 
-1, -1.14412, 0, -1, 0.138933,-99) , 
3, -0.449409, 0, 0, 0.257234,-99) , 
3, 0.349483, 0, 0, 0.4664,-99)    );
  // itree = 1624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58143, 0, 1, 0.797597,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238932,-99) , 
0, 0.395321, 1, 0, 0.463961,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.149784,-99) , 
3, -0.535926, 0, 0, 0.310547,-99) , 
3, 0.661338, 0, 0, 0.466051,-99)    );
  // itree = 1625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.0878, 0, 1, 0.716853,-99) , 
NN(
0, 
0, 
-1, -0.799257, 0, -1, 0.223277,-99) , 
3, -0.291428, 0, 0, 0.55648,-99)    );
  // itree = 1626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08622, 0, 1, 0.850909,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275502,-99) , 
0, 0.638313, 1, 0, 0.559605,-99) , 
3, 0.903417, 0, 0, 0.732366,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24353,-99) , 
0, -0.950968, 1, 0, 0.368402,-99) , 
NN(
0, 
0, 
-1, -1.58453, 0, -1, 0.086185,-99) , 
3, -1.13339, 0, 0, 0.290156,-99) , 
3, 0.27076, 0, 0, 0.504055,-99)    );
  // itree = 1627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54631, 1, 1, 0.836823,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464482,-99) , 
2, 0.362396, 1, 0, 0.607906,-99) , 
3, 0.747475, 0, 0, 0.770221,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193221,-99) , 
0, -0.156375, 1, 0, 0.417277,-99) , 
NN(
0, 
0, 
-1, -1.80373, 0, -1, 0.128026,-99) , 
3, -0.715892, 0, 0, 0.277043,-99) , 
3, 0.34765, 0, 0, 0.495629,-99)    );
  // itree = 1628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.862579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382987,-99) , 
0, 0.150326, 1, 0, 0.561932,-99) , 
3, 1.06041, 0, 0, 0.671515,-99) , 
NN(
0, 
0, 
-1, -1.58422, 0, -1, 0.163986,-99) , 
3, -0.680259, 0, 0, 0.527046,-99)    );
  // itree = 1629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57381, 1, 1, 0.893065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.973361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486069,-99) , 
0, -0.147815, 1, 0, 0.613311,-99) , 
3, 1.06094, 0, 0, 0.740115,-99) , 
NN(
0, 
0, 
-1, -0.572723, 0, -1, 0.235248,-99) , 
3, -0.0725463, 0, 0, 0.515329,-99)    );
  // itree = 1630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74709, 0, 1, 0.872758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304029,-99) , 
0, 0.985639, 1, 0, 0.627878,-99) , 
3, 1.09528, 0, 0, 0.751993,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643698,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275715,-99) , 
0, -0.9665, 1, 0, 0.408256,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.130892,-99) , 
3, -1.04984, 0, 0, 0.313388,-99) , 
3, 0.295236, 0, 0, 0.521104,-99)    );
  // itree = 1631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.808399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279741,-99) , 
0, 0.116255, 1, 0, 0.49943,-99) , 
3, 0.608397, 0, 0, 0.717274,-99) , 
NN(
0, 
0, 
-1, -1.19338, 0, -1, 0.252932,-99) , 
3, 0.191234, 0, 0, 0.48076,-99)    );
  // itree = 1632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57085, 0, 1, 0.780311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218218,-99) , 
0, 0.0208352, 1, 0, 0.453905,-99) , 
3, 0.642792, 0, 0, 0.600994,-99) , 
NN(
0, 
0, 
-1, -1.79148, 0, -1, 0.122672,-99) , 
3, -0.582913, 0, 0, 0.459154,-99)    );
  // itree = 1633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.30912, 1, 1, 0.849016,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459473,-99) , 
0, -0.0346559, 1, 0, 0.558978,-99) , 
3, 1.19191, 0, 0, 0.659597,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.20731,-99) , 
3, -0.145446, 0, 0, 0.470209,-99)    );
  // itree = 1634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42893, 1, 1, 0.936926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477619,-99) , 
0, 1.32161, 1, 0, 0.730208,-99) , 
3, 1.46157, 0, 0, 0.831838,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37212,-99) , 
0, -0.0746424, 1, 0, 0.535242,-99) , 
NN(
0, 
0, 
-1, -1.56812, 0, -1, 0.238725,-99) , 
3, -0.109218, 0, 0, 0.347992,-99) , 
3, 0.76021, 0, 0, 0.501262,-99)    );
  // itree = 1635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593214, 0, 1, 0.737218,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17759,-99) , 
1, 0.128572, 1, 0, 0.375445,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.116381,-99) , 
3, -0.647965, 0, 0, 0.231877,-99) , 
3, 0.179643, 0, 0, 0.466176,-99)    );
  // itree = 1636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.847356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300629,-99) , 
0, 0.500185, 1, 0, 0.546652,-99) , 
3, 0.957575, 0, 0, 0.678496,-99) , 
NN(
0, 
0, 
-1, -0.391179, 1, -1, 0.194795,-99) , 
3, -0.156071, 0, 0, 0.476952,-99)    );
  // itree = 1637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31631, 0, 1, 0.856177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411128,-99) , 
0, 0.214206, 1, 0, 0.595616,-99) , 
3, 0.95337, 0, 0, 0.704287,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212744,-99) , 
0, -1.20513, 1, 0, 0.340503,-99) , 
NN(
0, 
0, 
-1, -1.65618, 0, -1, 0.13919,-99) , 
3, -0.990191, 0, 0, 0.247955,-99) , 
3, -0.218528, 0, 0, 0.515469,-99)    );
  // itree = 1638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.887437,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49682,-99) , 
0, -0.0354634, 1, 0, 0.604959,-99) , 
3, 1.08882, 0, 0, 0.73097,-99) , 
NN(
0, 
0, 
-1, -0.540218, 0, -1, 0.23896,-99) , 
3, -0.0447319, 0, 0, 0.496136,-99)    );
  // itree = 1639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35104, 1, 1, 0.815183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366008,-99) , 
0, -0.0667081, 1, 0, 0.538991,-99) , 
3, 0.746137, 0, 0, 0.686416,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.205721,-99) , 
3, -0.145446, 0, 0, 0.494916,-99)    );
  // itree = 1640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.909352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374839,-99) , 
0, 0.953018, 1, 0, 0.645314,-99) , 
3, 1.16527, 0, 0, 0.762016,-99) , 
NN(
0, 
0, 
-1, -1.53001, 0, -1, 0.262237,-99) , 
3, 0.125502, 0, 0, 0.496827,-99)    );
  // itree = 1641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.57086, 1, 1, 0.867334,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198902,-99) , 
0, 0.502964, 1, 0, 0.459607,-99) , 
NN(
0, 
0, 
-1, -1.483, 0, -1, 0.185554,-99) , 
3, -0.327707, 0, 0, 0.320618,-99) , 
3, 0.822362, 0, 0, 0.467066,-99)    );
  // itree = 1642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.476858, 1, 1, 0.867456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474025,-99) , 
0, 0.222768, 1, 0, 0.602368,-99) , 
3, 0.924535, 0, 0, 0.76563,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302146,-99) , 
0, -0.381656, 1, 0, 0.454513,-99) , 
NN(
0, 
0, 
-1, -1.63854, 0, -1, 0.166319,-99) , 
3, -0.483771, 0, 0, 0.293136,-99) , 
3, 0.322617, 0, 0, 0.504814,-99)    );
  // itree = 1643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.851705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410014,-99) , 
0, 0.571117, 1, 0, 0.606556,-99) , 
3, 1.07236, 0, 0, 0.730892,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234755,-99) , 
3, -1.02957, 0, 0, 0.459272,-99) , 
NN(
0, 
0, 
-1, -0.248466, 0, -1, 0.218841,-99) , 
1, -0.321617, 1, 0, 0.303977,-99) , 
3, 0.281919, 0, 0, 0.498098,-99)    );
  // itree = 1644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1357, 0, 1, 0.840653,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482688,-99) , 
0, -0.363252, 1, 0, 0.591005,-99) , 
3, 0.777375, 0, 0, 0.727118,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208439,-99) , 
0, -1.32386, 1, 0, 0.32608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.04494,-99) , 
3, -1.57885, 0, 0, 0.267556,-99) , 
3, -0.115595, 0, 0, 0.529255,-99)    );
  // itree = 1645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.866851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38616,-99) , 
0, 0.71486, 1, 0, 0.64021,-99) , 
3, 1.08643, 0, 0, 0.757931,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292735,-99) , 
0, -0.843998, 1, 0, 0.41912,-99) , 
NN(
0, 
0, 
-1, -1.19528, 0, -1, 0.166354,-99) , 
3, -0.510491, 0, 0, 0.287388,-99) , 
3, 0.287809, 0, 0, 0.504377,-99)    );
  // itree = 1646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.824776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325815,-99) , 
0, 0.256748, 1, 0, 0.577535,-99) , 
3, 0.735924, 0, 0, 0.72952,-99) , 
NN(
0, 
0, 
-1, -1.15174, 0, -1, 0.280479,-99) , 
3, 0.144431, 0, 0, 0.5053,-99)    );
  // itree = 1647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27372, 0, 1, 0.861019,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445024,-99) , 
1, -0.617188, 1, 0, 0.574562,-99) , 
3, 0.903417, 0, 0, 0.749499,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469854,-99) , 
1, -1.28938, 0, 0, 0.485538,-99) , 
NN(
0, 
0, 
-1, -0.569108, 0, -1, 0.223914,-99) , 
1, -0.677103, 1, 0, 0.285861,-99) , 
3, 0.27076, 0, 0, 0.50936,-99)    );
  // itree = 1648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5962, 0, 1, 0.788965,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330121,-99) , 
0, -0.0153026, 1, 0, 0.544341,-99) , 
3, 0.672481, 0, 0, 0.668655,-99) , 
NN(
0, 
0, 
-1, -1.85387, 0, -1, 0.16415,-99) , 
3, -0.534624, 0, 0, 0.494841,-99)    );
  // itree = 1649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.833065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172885,-99) , 
0, 0.880072, 1, 0, 0.529881,-99) , 
3, 1.05859, 0, 0, 0.65388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172737,-99) , 
0, -0.85876, 1, 0, 0.320155,-99) , 
NN(
0, 
0, 
-1, -2.55908, 1, -1, 0.12994,-99) , 
3, -0.81936, 0, 0, 0.221655,-99) , 
3, -0.0725463, 0, 0, 0.471122,-99)    );
  // itree = 1650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62444, 0, 1, 0.842045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336692,-99) , 
0, 0.439034, 1, 0, 0.549376,-99) , 
3, 0.905236, 0, 0, 0.740485,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227825,-99) , 
0, -0.341503, 1, 0, 0.413432,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.157051,-99) , 
3, -0.58167, 0, 0, 0.280282,-99) , 
3, 0.27076, 0, 0, 0.475848,-99)    );
  // itree = 1651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.868593,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.933099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476938,-99) , 
0, -0.0988547, 1, 0, 0.603161,-99) , 
3, 1.15758, 0, 0, 0.699017,-99) , 
NN(
0, 
0, 
-1, -1.20998, 0, -1, 0.203882,-99) , 
3, -0.206128, 0, 0, 0.48585,-99)    );
  // itree = 1652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.725881, 1, 1, 0.837012,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266288,-99) , 
0, 0.232439, 1, 0, 0.589566,-99) , 
3, 0.719159, 0, 0, 0.723251,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515615,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.107488,-99) , 
3, -1.14113, 0, 0, 0.246514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.11174,-99) , 
0, -1.11015, 1, 0, 0.188993,-99) , 
3, -0.172486, 0, 0, 0.488644,-99)    );
  // itree = 1653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04569, 1, 1, 0.829308,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370209,-99) , 
0, -0.0558779, 1, 0, 0.522665,-99) , 
NN(
0, 
0, 
-1, -1.1997, 0, -1, 0.20354,-99) , 
3, -0.459062, 0, 0, 0.373772,-99) , 
3, 0.760049, 0, 0, 0.515615,-99)    );
  // itree = 1654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.815505,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479873,-99) , 
0, -0.307491, 1, 0, 0.581415,-99) , 
3, 0.95337, 0, 0, 0.688739,-99) , 
NN(
0, 
0, 
-1, -1.24633, 0, -1, 0.193947,-99) , 
3, -0.218528, 0, 0, 0.492103,-99)    );
  // itree = 1655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.73905, 0, 1, 0.737721,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301962,-99) , 
0, -0.607343, 1, 0, 0.440733,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.187927,-99) , 
3, -0.569108, 0, 0, 0.306283,-99) , 
3, 0.27076, 0, 0, 0.496242,-99)    );
  // itree = 1656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.18146, 0, 1, 0.817953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322236,-99) , 
0, -0.0217429, 1, 0, 0.518716,-99) , 
3, 0.633338, 0, 0, 0.672879,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205061,-99) , 
0, -1.44306, 1, 0, 0.334287,-99) , 
NN(
0, 
0, 
-1, 0.0225495, 1, -1, 0.0705567,-99) , 
3, -1.24451, 0, 0, 0.236888,-99) , 
3, -0.260982, 0, 0, 0.513912,-99)    );
  // itree = 1657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.809969,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270186,-99) , 
0, 0.143304, 1, 0, 0.464949,-99) , 
NN(
0, 
0, 
-1, -1.68419, 0, -1, 0.166881,-99) , 
3, -0.754651, 0, 0, 0.356587,-99) , 
3, 0.760049, 0, 0, 0.507379,-99)    );
  // itree = 1658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43545, 0, 1, 0.831105,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246228,-99) , 
0, 0.0822368, 1, 0, 0.450085,-99) , 
NN(
0, 
0, 
-1, -1.6692, 0, -1, 0.11468,-99) , 
3, -1.04223, 0, 0, 0.35819,-99) , 
3, 0.712472, 0, 0, 0.508797,-99)    );
  // itree = 1659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39213, 0, 1, 0.811659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211799,-99) , 
0, 0.65461, 1, 0, 0.506382,-99) , 
3, 0.832586, 0, 0, 0.621725,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.131848,-99) , 
3, -0.707817, 0, 0, 0.484104,-99)    );
  // itree = 1660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.878985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331673,-99) , 
0, 0.788183, 1, 0, 0.602001,-99) , 
3, 1.11291, 0, 0, 0.734684,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254584,-99) , 
0, -0.407859, 1, 0, 0.428397,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.161958,-99) , 
3, -0.574972, 0, 0, 0.287647,-99) , 
3, 0.27076, 0, 0, 0.493214,-99)    );
  // itree = 1661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.874673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372893,-99) , 
0, 0.0545573, 1, 0, 0.519306,-99) , 
3, 1.03145, 0, 0, 0.635194,-99) , 
NN(
0, 
0, 
-1, -1.60268, 0, -1, 0.13108,-99) , 
3, -0.703077, 0, 0, 0.495321,-99)    );
  // itree = 1662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.786037,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231963,-99) , 
0, 0.259657, 1, 0, 0.475819,-99) , 
NN(
0, 
0, 
-1, -1.44152, 0, -1, 0.166729,-99) , 
3, -0.451773, 0, 0, 0.335359,-99) , 
3, 0.760049, 0, 0, 0.480296,-99)    );
  // itree = 1663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07419, 1, 1, 0.857087,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225974,-99) , 
0, 0.772848, 1, 0, 0.577944,-99) , 
3, 0.979707, 0, 0, 0.702588,-99) , 
NN(
0, 
0, 
-1, -0.376169, 0, -1, 0.230992,-99) , 
3, -0.12622, 0, 0, 0.5027,-99)    );
  // itree = 1664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0183455, 1, 1, 0.854467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437502,-99) , 
0, -0.579814, 1, 0, 0.526191,-99) , 
3, 0.856055, 0, 0, 0.677798,-99) , 
NN(
0, 
0, 
-1, -0.569189, 1, -1, 0.190907,-99) , 
3, -0.302053, 0, 0, 0.502394,-99)    );
  // itree = 1665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57208, 0, 1, 0.843325,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.948369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404201,-99) , 
0, -0.0224986, 1, 0, 0.57279,-99) , 
3, 0.83881, 0, 0, 0.71059,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.226122,-99) , 
3, -0.0725463, 0, 0, 0.490757,-99)    );
  // itree = 1666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98999, 1, 1, 0.873822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39156,-99) , 
0, 0.835519, 1, 0, 0.627624,-99) , 
3, 1.17174, 0, 0, 0.741234,-99) , 
NN(
0, 
0, 
-1, -1.57912, 0, -1, 0.339285,-99) , 
3, 0.34753, 0, 0, 0.514553,-99)    );
  // itree = 1667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.851881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391105,-99) , 
0, 0.0681851, 1, 0, 0.555771,-99) , 
3, 1.0878, 0, 0, 0.655447,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.170975,-99) , 
3, -0.291428, 0, 0, 0.46751,-99)    );
  // itree = 1668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.809503, 1, 1, 0.815915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38894,-99) , 
0, -0.375998, 1, 0, 0.508124,-99) , 
3, 0.951244, 0, 0, 0.617569,-99) , 
NN(
0, 
0, 
-1, -0.370927, 1, -1, 0.147162,-99) , 
3, -0.547237, 0, 0, 0.466199,-99)    );
  // itree = 1669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.880074,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333606,-99) , 
0, 0.91729, 1, 0, 0.594556,-99) , 
3, 1.11419, 0, 0, 0.738567,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335843,-99) , 
0, -0.795814, 1, 0, 0.439683,-99) , 
NN(
0, 
0, 
-1, -1.30309, 0, -1, 0.152019,-99) , 
3, -0.580365, 0, 0, 0.272514,-99) , 
3, 0.27076, 0, 0, 0.478593,-99)    );
  // itree = 1670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.811932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313481,-99) , 
0, 0.190909, 1, 0, 0.53419,-99) , 
3, 0.894464, 0, 0, 0.663285,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145984,-99) , 
0, -1.4746, 1, 0, 0.269508,-99) , 
NN(
0, 
0, 
-1, -0.125285, 0, -1, 0.0646879,-99) , 
3, -1.47493, 0, 0, 0.216312,-99) , 
3, -0.231227, 0, 0, 0.48226,-99)    );
  // itree = 1671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68352, 0, 1, 0.79372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428286,-99) , 
3, 0.486444, 0, 0, 0.725296,-99) , 
NN(
0, 
0, 
-1, -1.40771, 0, -1, 0.299488,-99) , 
3, 0.27076, 0, 0, 0.488772,-99)    );
  // itree = 1672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.16149, 1, 1, 0.815247,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183287,-99) , 
0, 0.265915, 1, 0, 0.440731,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.202705,-99) , 
3, -0.576554, 0, 0, 0.341905,-99) , 
3, 0.609067, 0, 0, 0.508917,-99)    );
  // itree = 1673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60018, 0, 1, 0.816024,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.959384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30675,-99) , 
0, 0.228261, 1, 0, 0.558614,-99) , 
3, 0.675747, 0, 0, 0.740579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647427,-99) , 
NN(
0, 
0, 
-1, -1.04975, 0, -1, 0.265586,-99) , 
3, -0.0167238, 0, 0, 0.323529,-99) , 
3, 0.268003, 0, 0, 0.519886,-99)    );
  // itree = 1674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.835852,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319733,-99) , 
0, 0.134912, 1, 0, 0.537579,-99) , 
3, 0.630536, 0, 0, 0.708092,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.158939,-99) , 
3, -0.291428, 0, 0, 0.512614,-99)    );
  // itree = 1675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0393857, 1, 1, 0.700169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347932,-99) , 
3, -0.0613276, 0, 0, 0.645153,-99) , 
NN(
0, 
0, 
-1, -1.31014, 0, -1, 0.217688,-99) , 
3, -0.291428, 0, 0, 0.491128,-99)    );
  // itree = 1676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21385, 1, 1, 0.837667,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244831,-99) , 
0, 1.13238, 1, 0, 0.591025,-99) , 
3, 1.0864, 0, 0, 0.715001,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218603,-99) , 
0, -0.845124, 1, 0, 0.361092,-99) , 
NN(
0, 
0, 
-1, -1.92366, 0, -1, 0.0986788,-99) , 
3, -1.09669, 0, 0, 0.290182,-99) , 
3, 0.268003, 0, 0, 0.47764,-99)    );
  // itree = 1677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.39714, 1, 1, 0.925611,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381957,-99) , 
0, 1.52291, 1, 0, 0.643395,-99) , 
3, 1.60522, 0, 0, 0.711188,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265945,-99) , 
0, -0.795814, 1, 0, 0.391961,-99) , 
NN(
0, 
0, 
-1, -1.14182, 0, -1, 0.171237,-99) , 
3, -0.662162, 0, 0, 0.276937,-99) , 
3, 0.163853, 0, 0, 0.491388,-99)    );
  // itree = 1678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.53676, 1, 1, 0.926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480828,-99) , 
3, 1.49365, 0, 0, 0.736361,-99) , 
0, 1.36045, 1, 0, 0.812889,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37288,-99) , 
1, -1.10237, 1, 0, 0.426922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0414391,-99) , 
3, -1.51163, 0, 0, 0.369116,-99) , 
3, 0.783269, 0, 0, 0.519423,-99)    );
  // itree = 1679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.19645, 0, 1, 0.856844,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176979,-99) , 
0, 0.573933, 1, 0, 0.526531,-99) , 
NN(
0, 
0, 
-1, -1.59778, 0, -1, 0.230623,-99) , 
3, -0.0663062, 0, 0, 0.337109,-99) , 
3, 0.828289, 0, 0, 0.487451,-99)    );
  // itree = 1680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.490787, 1, 1, 0.845084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300318,-99) , 
0, 0.134136, 1, 0, 0.486702,-99) , 
3, 0.857984, 0, 0, 0.621783,-99) , 
NN(
0, 
0, 
-1, -1.67157, 1, -1, 0.137688,-99) , 
3, -0.613509, 0, 0, 0.486407,-99)    );
  // itree = 1681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63415, 1, 1, 0.870339,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.875491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329743,-99) , 
0, 0.715562, 1, 0, 0.622883,-99) , 
3, 1.0864, 0, 0, 0.751406,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248668,-99) , 
0, -0.325682, 1, 0, 0.445578,-99) , 
NN(
0, 
0, 
-1, -1.71128, 0, -1, 0.186037,-99) , 
3, -0.549382, 0, 0, 0.296853,-99) , 
3, 0.268003, 0, 0, 0.50264,-99)    );
  // itree = 1682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.840385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367729,-99) , 
0, 0.500185, 1, 0, 0.618436,-99) , 
3, 0.840074, 0, 0, 0.734289,-99) , 
NN(
0, 
0, 
-1, -0.512916, 0, -1, 0.263089,-99) , 
3, 0.0228588, 0, 0, 0.514266,-99)    );
  // itree = 1683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05162, 0, 1, 0.800389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259091,-99) , 
0, 0.08705, 1, 0, 0.488374,-99) , 
3, 0.464877, 0, 0, 0.675851,-99) , 
NN(
0, 
0, 
-1, -0.718728, 0, -1, 0.206106,-99) , 
3, -0.216753, 0, 0, 0.479538,-99)    );
  // itree = 1684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08941, 1, 1, 0.853118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405606,-99) , 
0, 0.222768, 1, 0, 0.578991,-99) , 
3, 0.911747, 0, 0, 0.747015,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335894,-99) , 
0, -0.612827, 1, 0, 0.455188,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.188966,-99) , 
3, -0.569108, 0, 0, 0.312629,-99) , 
3, 0.27076, 0, 0, 0.509505,-99)    );
  // itree = 1685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.828624,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297836,-99) , 
0, -0.0748989, 1, 0, 0.522906,-99) , 
NN(
0, 
0, 
-1, -2.1763, 1, -1, 0.177127,-99) , 
3, -0.524691, 0, 0, 0.354454,-99) , 
3, 0.673895, 0, 0, 0.523246,-99)    );
  // itree = 1686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.803872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338675,-99) , 
0, 0.0942126, 1, 0, 0.506661,-99) , 
3, 0.985566, 0, 0, 0.615052,-99) , 
NN(
0, 
0, 
-1, -1.64423, 0, -1, 0.176465,-99) , 
3, -0.514401, 0, 0, 0.47804,-99)    );
  // itree = 1687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.898439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251849,-99) , 
0, 1.00829, 1, 0, 0.586087,-99) , 
3, 1.08354, 0, 0, 0.74998,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219837,-99) , 
0, -0.243326, 1, 0, 0.435396,-99) , 
NN(
0, 
0, 
-1, -0.569189, 1, -1, 0.143227,-99) , 
3, -0.56087, 0, 0, 0.273388,-99) , 
3, 0.268003, 0, 0, 0.502604,-99)    );
  // itree = 1688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.962827, 1, 1, 0.823537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286166,-99) , 
0, 0.277937, 1, 0, 0.523279,-99) , 
3, 0.606621, 0, 0, 0.707115,-99) , 
NN(
0, 
0, 
-1, -1.56958, 0, -1, 0.227258,-99) , 
3, -0.0725463, 0, 0, 0.499973,-99)    );
  // itree = 1689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39618, 1, 1, 0.848297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379202,-99) , 
0, 0.142307, 1, 0, 0.540411,-99) , 
3, 0.965539, 0, 0, 0.675984,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.205175,-99) , 
3, -0.218528, 0, 0, 0.494909,-99)    );
  // itree = 1690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.848306,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243498,-99) , 
0, 0.418264, 1, 0, 0.522429,-99) , 
3, 0.827678, 0, 0, 0.676196,-99) , 
NN(
0, 
0, 
-1, -1.07906, 0, -1, 0.188895,-99) , 
3, -0.316527, 0, 0, 0.503563,-99)    );
  // itree = 1691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44503, 0, 1, 0.845664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248561,-99) , 
0, 0.381546, 1, 0, 0.530617,-99) , 
3, 0.901417, 0, 0, 0.657583,-99) , 
NN(
0, 
0, 
-1, -1.30593, 0, -1, 0.146487,-99) , 
3, -0.613987, 0, 0, 0.520811,-99)    );
  // itree = 1692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61809, 0, 1, 0.843662,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298001,-99) , 
0, 1.11532, 1, 0, 0.617004,-99) , 
3, 1.12513, 0, 0, 0.73447,-99) , 
NN(
0, 
0, 
-1, -1.29256, 0, -1, 0.346256,-99) , 
3, 0.322617, 0, 0, 0.523463,-99)    );
  // itree = 1693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.878781,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385942,-99) , 
0, 0.683618, 1, 0, 0.633367,-99) , 
3, 1.03501, 0, 0, 0.786165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239866,-99) , 
0, -0.117022, 1, 0, 0.433188,-99) , 
NN(
0, 
0, 
-1, -1.54416, 0, -1, 0.183281,-99) , 
3, -0.385184, 0, 0, 0.295226,-99) , 
3, 0.427177, 0, 0, 0.504379,-99)    );
  // itree = 1694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58651, 0, 1, 0.736642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28207,-99) , 
0, -0.345495, 1, 0, 0.48735,-99) , 
NN(
0, 
0, 
-1, -1.65762, 0, -1, 0.187838,-99) , 
3, -0.477004, 0, 0, 0.3243,-99) , 
3, 0.34753, 0, 0, 0.49962,-99)    );
  // itree = 1695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.818325,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238625,-99) , 
0, 0.446546, 1, 0, 0.555161,-99) , 
3, 0.720251, 0, 0, 0.69495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514696,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224417,-99) , 
3, -0.499303, 0, 0, 0.345157,-99) , 
NN(
0, 
0, 
-1, -0.684744, 1, -1, 0.136327,-99) , 
3, -0.987827, 0, 0, 0.242794,-99) , 
3, -0.218528, 0, 0, 0.523332,-99)    );
  // itree = 1696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.21475, 0, 1, 0.844331,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216777,-99) , 
0, 0.395321, 1, 0, 0.502569,-99) , 
NN(
0, 
0, 
-1, -1.30311, 0, -1, 0.173688,-99) , 
3, -0.835565, 0, 0, 0.384809,-99) , 
3, 0.661338, 0, 0, 0.542055,-99)    );
  // itree = 1697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.870321,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311935,-99) , 
0, 1.07644, 1, 0, 0.608971,-99) , 
3, 1.11005, 0, 0, 0.73173,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184162,-99) , 
0, -0.341503, 1, 0, 0.417835,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.149718,-99) , 
3, -0.569108, 0, 0, 0.262675,-99) , 
3, 0.27076, 0, 0, 0.461654,-99)    );
  // itree = 1698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11737, 0, 1, 0.821812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285257,-99) , 
0, 0.146168, 1, 0, 0.499027,-99) , 
3, 0.759331, 0, 0, 0.659594,-99) , 
NN(
0, 
0, 
-1, -0.616785, 0, -1, 0.202133,-99) , 
3, -0.12622, 0, 0, 0.465239,-99)    );
  // itree = 1699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36, 0, 1, 0.826507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251257,-99) , 
0, 0.254855, 1, 0, 0.503394,-99) , 
3, 0.633338, 0, 0, 0.676725,-99) , 
NN(
0, 
0, 
-1, -1.49165, 0, -1, 0.211353,-99) , 
3, -0.260982, 0, 0, 0.49686,-99)    );
  // itree = 1700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.587707, 1, 1, 0.792901,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299613,-99) , 
0, -0.0368671, 1, 0, 0.511001,-99) , 
3, 0.628149, 0, 0, 0.662522,-99) , 
NN(
0, 
0, 
-1, -1.05776, 0, -1, 0.190381,-99) , 
3, -0.291428, 0, 0, 0.489848,-99)    );
  // itree = 1701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.754072, 0, 1, 0.742501,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318152,-99) , 
0, -0.751191, 1, 0, 0.428835,-99) , 
NN(
0, 
0, 
-1, -1.55198, 0, -1, 0.167595,-99) , 
3, -0.427087, 0, 0, 0.280657,-99) , 
3, 0.359779, 0, 0, 0.476097,-99)    );
  // itree = 1702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.19253, 0, 1, 0.703925,-99) , 
NN(
0, 
0, 
-1, -0.652935, 0, -1, 0.219439,-99) , 
3, -0.145446, 0, 0, 0.499787,-99)    );
  // itree = 1703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73397, 0, 1, 0.804076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374689,-99) , 
0, -0.316235, 1, 0, 0.496383,-99) , 
3, 0.555454, 0, 0, 0.675901,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.198152,-99) , 
3, -0.133228, 0, 0, 0.466152,-99)    );
  // itree = 1704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34056, 1, 1, 0.855104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319827,-99) , 
0, 0.919284, 1, 0, 0.625248,-99) , 
3, 1.05859, 0, 0, 0.727323,-99) , 
NN(
0, 
0, 
-1, -0.0038903, 1, -1, 0.23851,-99) , 
3, -0.0725463, 0, 0, 0.510668,-99)    );
  // itree = 1705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66395, 0, 1, 0.736828,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166003,-99) , 
0, 0.0806859, 1, 0, 0.426574,-99) , 
NN(
0, 
0, 
-1, -2.25375, 1, -1, 0.18416,-99) , 
3, -0.620198, 0, 0, 0.314907,-99) , 
3, 0.457088, 0, 0, 0.477384,-99)    );
  // itree = 1706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.913344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255347,-99) , 
0, 1.3556, 1, 0, 0.663455,-99) , 
3, 1.31475, 0, 0, 0.743021,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276715,-99) , 
0, -1.4746, 1, 0, 0.359216,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.00816325,-99) , 
3, -1.52857, 0, 0, 0.263269,-99) , 
3, -0.0447319, 0, 0, 0.548422,-99)    );
  // itree = 1707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.873731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458225,-99) , 
0, 0.151248, 1, 0, 0.611283,-99) , 
3, 1.08845, 0, 0, 0.713167,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.24134,-99) , 
3, -0.291428, 0, 0, 0.54881,-99)    );
  // itree = 1708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.867199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429464,-99) , 
0, 1.00039, 1, 0, 0.650906,-99) , 
3, 1.35755, 0, 0, 0.719629,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272718,-99) , 
0, -1.47606, 1, 0, 0.341636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0290356,-99) , 
3, -1.51358, 0, 0, 0.279749,-99) , 
3, 0.125502, 0, 0, 0.518052,-99)    );
  // itree = 1709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.05638, 0, 1, 0.717777,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177957,-99) , 
0, -1.48924, 1, 0, 0.312489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0611213,-99) , 
3, -1.52354, 0, 0, 0.242091,-99) , 
3, -0.419452, 0, 0, 0.553613,-99)    );
  // itree = 1710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63091, 1, 1, 0.825608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439995,-99) , 
0, 0.232439, 1, 0, 0.609854,-99) , 
3, 0.92556, 0, 0, 0.713006,-99) , 
NN(
0, 
0, 
-1, -1.62397, 0, -1, 0.220827,-99) , 
3, -0.175849, 0, 0, 0.518293,-99)    );
  // itree = 1711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.822135,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.912591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390054,-99) , 
0, -0.147815, 1, 0, 0.554851,-99) , 
3, 0.784282, 0, 0, 0.698099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528367,-99) , 
NN(
0, 
0, 
-1, -0.640241, 0, -1, 0.204279,-99) , 
1, -0.862599, 1, 0, 0.280268,-99) , 
3, -0.133228, 0, 0, 0.529277,-99)    );
  // itree = 1712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.838104,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206493,-99) , 
0, 0.629373, 1, 0, 0.494692,-99) , 
NN(
0, 
0, 
-1, -1.05656, 0, -1, 0.184637,-99) , 
3, -0.619195, 0, 0, 0.370018,-99) , 
3, 0.825038, 0, 0, 0.513703,-99)    );
  // itree = 1713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98999, 1, 1, 0.886374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30318,-99) , 
0, 1.011, 1, 0, 0.618178,-99) , 
3, 1.19406, 0, 0, 0.735367,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229391,-99) , 
0, -0.671136, 1, 0, 0.398887,-99) , 
NN(
0, 
0, 
-1, -1.61204, 0, -1, 0.151786,-99) , 
3, -0.66666, 0, 0, 0.255185,-99) , 
3, 0.163853, 0, 0, 0.487934,-99)    );
  // itree = 1714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.858156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690698,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334273,-99) , 
0, 1.10833, 1, 0, 0.614949,-99) , 
3, 1.18544, 0, 0, 0.698421,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178714,-99) , 
0, -1.4634, 1, 0, 0.283375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0727254,-99) , 
3, -1.50037, 0, 0, 0.230635,-99) , 
3, -0.218528, 0, 0, 0.502492,-99)    );
  // itree = 1715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.26043, 1, 1, 0.845215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470597,-99) , 
0, 0.222768, 1, 0, 0.619429,-99) , 
3, 0.918861, 0, 0, 0.757239,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310611,-99) , 
0, -0.449573, 1, 0, 0.437641,-99) , 
NN(
0, 
0, 
-1, -1.81878, 0, -1, 0.180382,-99) , 
3, -0.739888, 0, 0, 0.309446,-99) , 
3, 0.320269, 0, 0, 0.508436,-99)    );
  // itree = 1716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14008, 1, 1, 0.852073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185361,-99) , 
0, 0.884488, 1, 0, 0.581848,-99) , 
3, 0.952846, 0, 0, 0.696729,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.238254,-99) , 
3, -0.218528, 0, 0, 0.51185,-99)    );
  // itree = 1717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15167, 0, 1, 0.692964,-99) , 
NN(
0, 
0, 
-1, -0.706455, 0, -1, 0.238696,-99) , 
3, -0.206128, 0, 0, 0.505231,-99)    );
  // itree = 1718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.886469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285815,-99) , 
0, 0.978376, 1, 0, 0.598781,-99) , 
3, 1.11291, 0, 0, 0.740526,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319947,-99) , 
0, -0.817898, 1, 0, 0.461651,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.171905,-99) , 
3, -0.569108, 0, 0, 0.312442,-99) , 
3, 0.27076, 0, 0, 0.522752,-99)    );
  // itree = 1719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.849613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301081,-99) , 
0, 0.913386, 1, 0, 0.615069,-99) , 
3, 1.01311, 0, 0, 0.721818,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234156,-99) , 
0, -1.0487, 1, 0, 0.403992,-99) , 
NN(
0, 
0, 
-1, -1.53648, 0, -1, 0.134028,-99) , 
3, -0.888858, 0, 0, 0.253551,-99) , 
3, -0.133228, 0, 0, 0.517882,-99)    );
  // itree = 1720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46097, 0, 1, 0.864534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309684,-99) , 
0, 1.03728, 1, 0, 0.631278,-99) , 
3, 1.11005, 0, 0, 0.744824,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247127,-99) , 
0, -0.381656, 1, 0, 0.454086,-99) , 
NN(
0, 
0, 
-1, -1.53113, 0, -1, 0.183884,-99) , 
3, -0.569108, 0, 0, 0.304316,-99) , 
3, 0.27076, 0, 0, 0.509496,-99)    );
  // itree = 1721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37213, 0, 1, 0.816692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493165,-99) , 
3, 0.386809, 0, 0, 0.760821,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21929,-99) , 
0, -0.747757, 1, 0, 0.351286,-99) , 
NN(
0, 
0, 
-1, -1.83075, 0, -1, 0.105004,-99) , 
3, -1.19827, 0, 0, 0.278664,-99) , 
3, 0.179643, 0, 0, 0.489801,-99)    );
  // itree = 1722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02376, 1, 1, 0.852887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.961191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405425,-99) , 
0, -0.376596, 1, 0, 0.548279,-99) , 
3, 0.687282, 0, 0, 0.724523,-99) , 
NN(
0, 
0, 
-1, -0.979987, 1, -1, 0.2138,-99) , 
3, -0.2003, 0, 0, 0.510654,-99)    );
  // itree = 1723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72302, 0, 1, 0.844283,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319914,-99) , 
0, 0.475416, 1, 0, 0.560016,-99) , 
3, 0.794416, 0, 0, 0.698358,-99) , 
NN(
0, 
0, 
-1, -0.639048, 0, -1, 0.241155,-99) , 
3, -0.133228, 0, 0, 0.512303,-99)    );
  // itree = 1724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.900618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338773,-99) , 
0, 0.91729, 1, 0, 0.666902,-99) , 
3, 1.12782, 0, 0, 0.783702,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268759,-99) , 
1, 0.112696, 1, 0, 0.390857,-99) , 
NN(
0, 
0, 
-1, -1.61288, 0, -1, 0.119864,-99) , 
3, -1.00435, 0, 0, 0.29279,-99) , 
3, 0.320269, 0, 0, 0.508644,-99)    );
  // itree = 1725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.617042, 0, 1, 0.749556,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211659,-99) , 
0, -0.0748989, 1, 0, 0.43405,-99) , 
NN(
0, 
0, 
-1, -1.56443, 0, -1, 0.149572,-99) , 
3, -0.686056, 0, 0, 0.302531,-99) , 
3, 0.402144, 0, 0, 0.487131,-99)    );
  // itree = 1726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21585, 1, 1, 0.882773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294182,-99) , 
0, 1.3556, 1, 0, 0.672159,-99) , 
3, 1.40224, 0, 0, 0.724169,-99) , 
NN(
0, 
0, 
-1, -0.652935, 0, -1, 0.29073,-99) , 
3, -0.156071, 0, 0, 0.549048,-99)    );
  // itree = 1727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.850037,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339577,-99) , 
0, -0.345495, 1, 0, 0.495667,-99) , 
NN(
0, 
0, 
-1, -1.98428, 0, -1, 0.174308,-99) , 
3, -0.524691, 0, 0, 0.344846,-99) , 
3, 0.673895, 0, 0, 0.515651,-99)    );
  // itree = 1728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.612047, 0, 1, 0.763551,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284371,-99) , 
0, -0.838601, 1, 0, 0.406145,-99) , 
NN(
0, 
0, 
-1, -1.17916, 1, -1, 0.148985,-99) , 
3, -0.606884, 0, 0, 0.269385,-99) , 
3, 0.208162, 0, 0, 0.50111,-99)    );
  // itree = 1729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.336716, 1, 1, 0.876226,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457867,-99) , 
0, 0.439034, 1, 0, 0.604847,-99) , 
3, 1.11291, 0, 0, 0.741202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642784,-99) , 
NN(
0, 
0, 
-1, -1.1038, 0, -1, 0.225886,-99) , 
3, -0.0165573, 0, 0, 0.277918,-99) , 
3, 0.27076, 0, 0, 0.479633,-99)    );
  // itree = 1730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.851247,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26453,-99) , 
0, 0.0919929, 1, 0, 0.49656,-99) , 
NN(
0, 
0, 
-1, -1.51536, 0, -1, 0.143119,-99) , 
3, -0.542018, 0, 0, 0.322454,-99) , 
3, 0.661338, 0, 0, 0.488452,-99)    );
  // itree = 1731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04515, 0, 1, 0.808213,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267702,-99) , 
0, 0.0208352, 1, 0, 0.498927,-99) , 
NN(
0, 
0, 
-1, -1.261, 0, -1, 0.159102,-99) , 
3, -0.531196, 0, 0, 0.346974,-99) , 
3, 0.673895, 0, 0, 0.499839,-99)    );
  // itree = 1732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.810412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313899,-99) , 
0, 0.500185, 1, 0, 0.581063,-99) , 
3, 0.802355, 0, 0, 0.707636,-99) , 
NN(
0, 
0, 
-1, -1.0597, 0, -1, 0.193076,-99) , 
3, -0.0901485, 0, 0, 0.457764,-99)    );
  // itree = 1733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31919, 1, 1, 0.848441,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386095,-99) , 
0, -0.423729, 1, 0, 0.527623,-99) , 
3, 0.625024, 0, 0, 0.713851,-99) , 
NN(
0, 
0, 
-1, -0.807403, 0, -1, 0.217675,-99) , 
3, -0.302053, 0, 0, 0.533309,-99)    );
  // itree = 1734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.27856, 1, 1, 0.817781,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324046,-99) , 
0, -0.138969, 1, 0, 0.485523,-99) , 
NN(
0, 
0, 
-1, -1.14884, 0, -1, 0.210234,-99) , 
3, -0.43371, 0, 0, 0.349143,-99) , 
3, 0.742135, 0, 0, 0.488357,-99)    );
  // itree = 1735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.869165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349874,-99) , 
0, 1.14161, 1, 0, 0.61241,-99) , 
3, 1.27509, 0, 0, 0.710497,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221402,-99) , 
0, -0.407859, 1, 0, 0.424032,-99) , 
NN(
0, 
0, 
-1, -1.72323, 0, -1, 0.172304,-99) , 
3, -0.55608, 0, 0, 0.291494,-99) , 
3, 0.256412, 0, 0, 0.48192,-99)    );
  // itree = 1736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.822496,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235487,-99) , 
0, 0.213204, 1, 0, 0.499801,-99) , 
3, 0.610069, 0, 0, 0.687078,-99) , 
NN(
0, 
0, 
-1, -1.56516, 0, -1, 0.237236,-99) , 
3, -0.0725463, 0, 0, 0.500721,-99)    );
  // itree = 1737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75578, 1, 1, 0.88467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457377,-99) , 
0, 0.219929, 1, 0, 0.58067,-99) , 
3, 1.11291, 0, 0, 0.70507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308049,-99) , 
0, -0.843998, 1, 0, 0.422407,-99) , 
NN(
0, 
0, 
-1, -1.06267, 0, -1, 0.154449,-99) , 
3, -0.580365, 0, 0, 0.283823,-99) , 
3, 0.27076, 0, 0, 0.492949,-99)    );
  // itree = 1738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.857493,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416647,-99) , 
0, 0.446087, 1, 0, 0.600758,-99) , 
3, 0.880637, 0, 0, 0.755495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280527,-99) , 
0, -0.511616, 1, 0, 0.458814,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.153942,-99) , 
3, -0.554775, 0, 0, 0.291317,-99) , 
3, 0.256412, 0, 0, 0.502315,-99)    );
  // itree = 1739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52011, 1, 1, 0.843273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361441,-99) , 
0, 0.371931, 1, 0, 0.557541,-99) , 
3, 0.972555, 0, 0, 0.694534,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.220031,-99) , 
3, -0.145446, 0, 0, 0.506525,-99)    );
  // itree = 1740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32386, 1, 1, 0.839273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384228,-99) , 
0, 0.36396, 1, 0, 0.563836,-99) , 
3, 0.96671, 0, 0, 0.72771,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.175867,-99) , 
0, -0.0748989, 1, 0, 0.401289,-99) , 
NN(
0, 
0, 
-1, -1.20548, 0, -1, 0.136954,-99) , 
3, -0.754564, 0, 0, 0.280835,-99) , 
3, 0.34753, 0, 0, 0.474917,-99)    );
  // itree = 1741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.867937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349416,-99) , 
0, 0.91729, 1, 0, 0.653437,-99) , 
3, 1.11463, 0, 0, 0.757791,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300083,-99) , 
0, -1.18224, 1, 0, 0.398207,-99) , 
NN(
0, 
0, 
-1, -0.365486, 1, -1, 0.121834,-99) , 
3, -1.13339, 0, 0, 0.315371,-99) , 
3, 0.27076, 0, 0, 0.522528,-99)    );
  // itree = 1742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17475, 0, 1, 0.874933,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307292,-99) , 
0, -0.11235, 1, 0, 0.490315,-99) , 
NN(
0, 
0, 
-1, -1.72319, 0, -1, 0.185757,-99) , 
3, -0.625743, 0, 0, 0.373064,-99) , 
3, 0.814561, 0, 0, 0.518665,-99)    );
  // itree = 1743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.873607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324132,-99) , 
0, 0.969329, 1, 0, 0.580381,-99) , 
3, 1.18232, 0, 0, 0.671528,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.170851,-99) , 
3, -0.218528, 0, 0, 0.464561,-99)    );
  // itree = 1744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78983, 1, 1, 0.869719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402227,-99) , 
0, 0.36396, 1, 0, 0.595074,-99) , 
3, 0.883535, 0, 0, 0.76303,-99) , 
NN(
0, 
0, 
-1, -1.09937, 0, -1, 0.281818,-99) , 
3, 0.268003, 0, 0, 0.505947,-99)    );
  // itree = 1745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.83391,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342706,-99) , 
0, 0.453613, 1, 0, 0.588155,-99) , 
3, 0.969023, 0, 0, 0.700486,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214024,-99) , 
0, -1.36121, 1, 0, 0.320519,-99) , 
NN(
0, 
0, 
-1, -1.73486, 0, -1, 0.107952,-99) , 
3, -1.13085, 0, 0, 0.237707,-99) , 
3, -0.145446, 0, 0, 0.49673,-99)    );
  // itree = 1746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11213, 0, 1, 0.797519,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357204,-99) , 
0, -0.0706545, 1, 0, 0.5306,-99) , 
3, 0.586485, 0, 0, 0.689398,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186665,-99) , 
0, -1.78414, 1, 0, 0.285624,-99) , 
NN(
0, 
0, 
-1, -0.0736723, 1, -1, 0.0517612,-99) , 
3, -1.49125, 0, 0, 0.21647,-99) , 
3, -0.288453, 0, 0, 0.508723,-99)    );
  // itree = 1747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49354, 0, 1, 0.838428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392221,-99) , 
0, 0.0381911, 1, 0, 0.561316,-99) , 
3, 0.773102, 0, 0, 0.700988,-99) , 
NN(
0, 
0, 
-1, -1.58302, 0, -1, 0.252881,-99) , 
3, -0.117632, 0, 0, 0.515592,-99)    );
  // itree = 1748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.4641, 0, 1, 0.773933,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254275,-99) , 
0, -0.603613, 1, 0, 0.401871,-99) , 
NN(
0, 
0, 
-1, -1.04727, 0, -1, 0.1626,-99) , 
3, -0.569465, 0, 0, 0.274738,-99) , 
3, 0.240623, 0, 0, 0.516311,-99)    );
  // itree = 1749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55172, 0, 1, 0.827652,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21393,-99) , 
0, 0.388657, 1, 0, 0.515474,-99) , 
3, 0.847121, 0, 0, 0.645847,-99) , 
NN(
0, 
0, 
-1, -1.5135, 0, -1, 0.147723,-99) , 
3, -0.623168, 0, 0, 0.498266,-99)    );
  // itree = 1750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.675747, 0, 1, 0.76839,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318379,-99) , 
3, -0.015971, 0, 0, 0.417495,-99) , 
NN(
0, 
0, 
-1, -1.26764, 0, -1, 0.175275,-99) , 
3, -0.284397, 0, 0, 0.252525,-99) , 
3, 0.268003, 0, 0, 0.47935,-99)    );
  // itree = 1751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.41103, 1, 1, 0.906958,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38005,-99) , 
0, 1.14736, 1, 0, 0.663388,-99) , 
3, 1.40021, 0, 0, 0.738611,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280205,-99) , 
0, -0.843998, 1, 0, 0.404317,-99) , 
NN(
0, 
0, 
-1, -1.08997, 1, -1, 0.151093,-99) , 
3, -0.662162, 0, 0, 0.271569,-99) , 
3, 0.163853, 0, 0, 0.493581,-99)    );
  // itree = 1752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.820648,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257481,-99) , 
0, 0.259657, 1, 0, 0.550226,-99) , 
3, 0.599493, 0, 0, 0.696734,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374963,-99) , 
1, -0.785764, 1, 0, 0.468541,-99) , 
NN(
0, 
0, 
-1, -1.3307, 0, -1, 0.156052,-99) , 
1, -0.112602, 1, 0, 0.278686,-99) , 
3, -0.316527, 0, 0, 0.562724,-99)    );
  // itree = 1753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.843647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375017,-99) , 
0, 0.0304304, 1, 0, 0.540647,-99) , 
3, 0.949517, 0, 0, 0.677013,-99) , 
NN(
0, 
0, 
-1, -1.50393, 0, -1, 0.252447,-99) , 
3, -0.218528, 0, 0, 0.511104,-99)    );
  // itree = 1754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41775, 1, 1, 0.810243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284632,-99) , 
0, 0.0287117, 1, 0, 0.519399,-99) , 
3, 0.686342, 0, 0, 0.678614,-99) , 
NN(
0, 
0, 
-1, -1.70546, 0, -1, 0.232367,-99) , 
3, -0.216753, 0, 0, 0.501784,-99)    );
  // itree = 1755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.82922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276876,-99) , 
0, 0.500185, 1, 0, 0.536469,-99) , 
3, 0.84551, 0, 0, 0.689526,-99) , 
NN(
0, 
0, 
-1, -0.512916, 0, -1, 0.264933,-99) , 
3, 0.0391675, 0, 0, 0.500137,-99)    );
  // itree = 1756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.86836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411167,-99) , 
0, 0.835519, 1, 0, 0.667441,-99) , 
3, 1.11419, 0, 0, 0.773148,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305792,-99) , 
0, -0.357805, 1, 0, 0.489206,-99) , 
NN(
0, 
0, 
-1, -1.54184, 0, -1, 0.152901,-99) , 
3, -0.574972, 0, 0, 0.316734,-99) , 
3, 0.27076, 0, 0, 0.523914,-99)    );
  // itree = 1757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.822909,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892966,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326171,-99) , 
0, 0.400931, 1, 0, 0.601457,-99) , 
3, 0.799901, 0, 0, 0.728169,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30781,-99) , 
0, -0.881867, 1, 0, 0.395643,-99) , 
NN(
0, 
0, 
-1, -1.60074, 0, -1, 0.0877653,-99) , 
3, -0.923117, 0, 0, 0.264646,-99) , 
3, 0.179643, 0, 0, 0.487697,-99)    );
  // itree = 1758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63307, 0, 1, 0.849069,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360658,-99) , 
0, 0.638313, 1, 0, 0.633008,-99) , 
3, 0.950051, 0, 0, 0.764965,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178708,-99) , 
0, -0.111037, 1, 0, 0.435524,-99) , 
NN(
0, 
0, 
-1, -1.58923, 0, -1, 0.159604,-99) , 
3, -0.715892, 0, 0, 0.317528,-99) , 
3, 0.34765, 0, 0, 0.517338,-99)    );
  // itree = 1759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60699, 1, 1, 0.861373,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277386,-99) , 
0, 0.0975803, 1, 0, 0.461103,-99) , 
NN(
0, 
0, 
-1, 0.290288, 1, -1, 0.154548,-99) , 
3, -0.661336, 0, 0, 0.356444,-99) , 
3, 0.828289, 0, 0, 0.503198,-99)    );
  // itree = 1760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20219, 0, 1, 0.796168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418957,-99) , 
3, 0.618687, 0, 0, 0.728983,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271789,-99) , 
3, -0.675501, 0, 0, 0.521701,-99) , 
NN(
0, 
0, 
-1, -0.415323, 0, -1, 0.233542,-99) , 
1, -0.512321, 1, 0, 0.308561,-99) , 
3, 0.402144, 0, 0, 0.480092,-99)    );
  // itree = 1761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.920289, 1, 1, 0.815111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49133,-99) , 
3, 0.484423, 0, 0, 0.757468,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257591,-99) , 
1, 0.0954776, 1, 0, 0.400667,-99) , 
NN(
0, 
0, 
-1, -1.77038, 0, -1, 0.136621,-99) , 
3, -0.863347, 0, 0, 0.294094,-99) , 
3, 0.27076, 0, 0, 0.494145,-99)    );
  // itree = 1762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45813, 0, 1, 0.865076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258526,-99) , 
0, 0.879237, 1, 0, 0.572806,-99) , 
3, 1.11463, 0, 0, 0.703019,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236617,-99) , 
0, -0.381656, 1, 0, 0.474983,-99) , 
NN(
0, 
0, 
-1, -1.06433, 0, -1, 0.18818,-99) , 
3, -0.569108, 0, 0, 0.319584,-99) , 
3, 0.27076, 0, 0, 0.49608,-99)    );
  // itree = 1763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.872195,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460482,-99) , 
0, 0.262911, 1, 0, 0.606937,-99) , 
3, 1.09078, 0, 0, 0.712211,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248263,-99) , 
0, -1.07392, 1, 0, 0.385103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0369212,-99) , 
3, -1.50946, 0, 0, 0.311259,-99) , 
3, -0.0295996, 0, 0, 0.536209,-99)    );
  // itree = 1764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.790123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347568,-99) , 
0, 0.0208352, 1, 0, 0.508506,-99) , 
3, 0.890414, 0, 0, 0.615698,-99) , 
NN(
0, 
0, 
-1, -0.364029, 1, -1, 0.157648,-99) , 
3, -0.582913, 0, 0, 0.465438,-99)    );
  // itree = 1765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38347, 1, 1, 0.784237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336601,-99) , 
0, 0.0878292, 1, 0, 0.564012,-99) , 
3, 0.609259, 0, 0, 0.708368,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.225659,-99) , 
3, -0.0725463, 0, 0, 0.492819,-99)    );
  // itree = 1766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.853002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347291,-99) , 
0, 0.563868, 1, 0, 0.595244,-99) , 
3, 0.965707, 0, 0, 0.745164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250386,-99) , 
1, 0.0790899, 1, 0, 0.388118,-99) , 
NN(
0, 
0, 
-1, -1.64928, 0, -1, 0.142938,-99) , 
3, -0.754564, 0, 0, 0.286657,-99) , 
3, 0.34753, 0, 0, 0.488392,-99)    );
  // itree = 1767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6265, 0, 1, 0.855171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227216,-99) , 
0, 0.932184, 1, 0, 0.558817,-99) , 
3, 1.13676, 0, 0, 0.672253,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229151,-99) , 
0, -1.521, 1, 0, 0.333332,-99) , 
NN(
0, 
0, 
-1, -0.24519, 1, -1, 0.06493,-99) , 
3, -1.21221, 0, 0, 0.244881,-99) , 
3, -0.216753, 0, 0, 0.517278,-99)    );
  // itree = 1768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20188, 1, 1, 0.801743,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270778,-99) , 
0, -0.217586, 1, 0, 0.461394,-99) , 
NN(
0, 
0, 
-1, -1.51536, 0, -1, 0.178754,-99) , 
3, -0.547498, 0, 0, 0.331385,-99) , 
3, 0.644232, 0, 0, 0.486612,-99)    );
  // itree = 1769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.11141, 1, 1, 0.887364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24608,-99) , 
0, 1.3556, 1, 0, 0.620409,-99) , 
3, 1.45805, 0, 0, 0.691936,-99) , 
NN(
0, 
0, 
-1, -1.06019, 0, -1, 0.258733,-99) , 
3, -0.0901485, 0, 0, 0.50244,-99)    );
  // itree = 1770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50157, 1, 1, 0.923706,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317803,-99) , 
0, 1.52291, 1, 0, 0.6995,-99) , 
3, 1.66192, 0, 0, 0.754895,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284304,-99) , 
0, -0.843998, 1, 0, 0.400575,-99) , 
NN(
0, 
0, 
-1, -1.52165, 0, -1, 0.116904,-99) , 
3, -0.578201, 0, 0, 0.240838,-99) , 
3, 0.240623, 0, 0, 0.472929,-99)    );
  // itree = 1771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.19482, 0, 1, 0.835664,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731966,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235542,-99) , 
0, 0.475416, 1, 0, 0.514043,-99) , 
NN(
0, 
0, 
-1, -0.743958, 1, -1, 0.258427,-99) , 
3, -0.0663062, 0, 0, 0.357158,-99) , 
3, 0.828289, 0, 0, 0.490868,-99)    );
  // itree = 1772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.853543,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225064,-99) , 
0, 0.437739, 1, 0, 0.488775,-99) , 
NN(
0, 
0, 
-1, -1.1254, 0, -1, 0.133148,-99) , 
3, -0.661336, 0, 0, 0.354095,-99) , 
3, 0.828289, 0, 0, 0.490085,-99)    );
  // itree = 1773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41775, 1, 1, 0.831302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302132,-99) , 
0, 0.295007, 1, 0, 0.518883,-99) , 
3, 0.630536, 0, 0, 0.679747,-99) , 
NN(
0, 
0, 
-1, -1.05418, 0, -1, 0.21092,-99) , 
3, -0.291428, 0, 0, 0.509643,-99)    );
  // itree = 1774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.05831, 1, 1, 0.900803,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.939583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448769,-99) , 
0, 1.13209, 1, 0, 0.705995,-99) , 
3, 1.19435, 0, 0, 0.82039,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176571,-99) , 
0, 0.347062, 1, 0, 0.418711,-99) , 
NN(
0, 
0, 
-1, -1.78147, 0, -1, 0.0988598,-99) , 
3, -1.14144, 0, 0, 0.34399,-99) , 
3, 0.644232, 0, 0, 0.502014,-99)    );
  // itree = 1775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.852771, 0, 1, 0.795261,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244425,-99) , 
0, 0.123422, 1, 0, 0.51054,-99) , 
NN(
0, 
0, 
-1, 0.0298185, 1, -1, 0.152893,-99) , 
3, -0.535926, 0, 0, 0.343258,-99) , 
3, 0.661338, 0, 0, 0.499149,-99)    );
  // itree = 1776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56795, 0, 1, 0.855922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461743,-99) , 
0, 0.0114807, 1, 0, 0.602949,-99) , 
3, 0.835097, 0, 0, 0.737833,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225739,-99) , 
0, -1.37357, 1, 0, 0.322298,-99) , 
NN(
0, 
0, 
-1, -1.67705, 0, -1, 0.0865565,-99) , 
3, -1.06971, 0, 0, 0.23404,-99) , 
3, -0.0725463, 0, 0, 0.50155,-99)    );
  // itree = 1777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.612267, 0, 1, 0.730098,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291232,-99) , 
0, -0.862067, 1, 0, 0.435673,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.168706,-99) , 
3, -0.639477, 0, 0, 0.295899,-99) , 
3, 0.191234, 0, 0, 0.496781,-99)    );
  // itree = 1778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67537, 0, 1, 0.794033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262985,-99) , 
0, -0.0639868, 1, 0, 0.511055,-99) , 
3, 0.538415, 0, 0, 0.694965,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200552,-99) , 
0, -1.49705, 1, 0, 0.302689,-99) , 
NN(
0, 
0, 
-1, -1.91018, 0, -1, 0.0887767,-99) , 
3, -1.11428, 0, 0, 0.228148,-99) , 
3, -0.128257, 0, 0, 0.492668,-99)    );
  // itree = 1779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.29137, 0, 1, 0.825502,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322137,-99) , 
0, 0.0477724, 1, 0, 0.532817,-99) , 
NN(
0, 
0, 
-1, -1.62359, 0, -1, 0.237753,-99) , 
3, -0.43371, 0, 0, 0.388611,-99) , 
3, 0.742135, 0, 0, 0.534636,-99)    );
  // itree = 1780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.814413,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178214,-99) , 
0, 0.259256, 1, 0, 0.493135,-99) , 
3, 0.701791, 0, 0, 0.639132,-99) , 
NN(
0, 
0, 
-1, -1.23125, 0, -1, 0.185613,-99) , 
3, -0.547237, 0, 0, 0.501539,-99)    );
  // itree = 1781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38826, 0, 1, 0.796492,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252947,-99) , 
0, 0.0283268, 1, 0, 0.437462,-99) , 
NN(
0, 
0, 
-1, -0.684744, 1, -1, 0.171153,-99) , 
3, -0.490571, 0, 0, 0.31749,-99) , 
3, 0.670926, 0, 0, 0.457458,-99)    );
  // itree = 1782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.803089,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256516,-99) , 
0, 0.277937, 1, 0, 0.524855,-99) , 
NN(
0, 
0, 
-1, -1.71446, 0, -1, 0.238674,-99) , 
3, -0.148894, 0, 0, 0.355112,-99) , 
3, 0.760049, 0, 0, 0.487894,-99)    );
  // itree = 1783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65627, 0, 1, 0.86519,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374879,-99) , 
0, 0.667103, 1, 0, 0.650313,-99) , 
3, 0.980247, 0, 0, 0.744363,-99) , 
NN(
0, 
0, 
-1, -0.620941, 0, -1, 0.185832,-99) , 
3, -0.12622, 0, 0, 0.493279,-99)    );
  // itree = 1784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.799079,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307549,-99) , 
0, 0.232439, 1, 0, 0.517671,-99) , 
3, 0.733738, 0, 0, 0.656001,-99) , 
NN(
0, 
0, 
-1, -1.75664, 0, -1, 0.187795,-99) , 
3, -0.218528, 0, 0, 0.475732,-99)    );
  // itree = 1785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44253, 0, 1, 0.865305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299053,-99) , 
0, 0.913386, 1, 0, 0.628688,-99) , 
3, 1.09688, 0, 0, 0.724882,-99) , 
NN(
0, 
0, 
-1, -0.525775, 0, -1, 0.226198,-99) , 
3, -0.0295996, 0, 0, 0.495028,-99)    );
  // itree = 1786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71935, 0, 1, 0.827503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.964466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439326,-99) , 
0, -0.363814, 1, 0, 0.557132,-99) , 
3, 0.790869, 0, 0, 0.688462,-99) , 
NN(
0, 
0, 
-1, -0.63704, 0, -1, 0.196864,-99) , 
3, -0.133228, 0, 0, 0.479096,-99)    );
  // itree = 1787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.89801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316695,-99) , 
0, 0.913386, 1, 0, 0.595507,-99) , 
3, 1.18232, 0, 0, 0.699883,-99) , 
NN(
0, 
0, 
-1, -1.75664, 0, -1, 0.224029,-99) , 
3, -0.218528, 0, 0, 0.525912,-99)    );
  // itree = 1788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6338, 1, 1, 0.881708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368646,-99) , 
0, 0.865651, 1, 0, 0.599179,-99) , 
3, 1.11005, 0, 0, 0.733583,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24665,-99) , 
0, -1.27833, 1, 0, 0.327636,-99) , 
NN(
0, 
0, 
-1, -1.76751, 0, -1, 0.0809045,-99) , 
3, -1.12817, 0, 0, 0.258962,-99) , 
3, 0.27076, 0, 0, 0.468212,-99)    );
  // itree = 1789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.867535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372294,-99) , 
0, 1.00365, 1, 0, 0.654549,-99) , 
3, 1.21243, 0, 0, 0.742788,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273581,-99) , 
0, -0.843998, 1, 0, 0.424724,-99) , 
NN(
0, 
0, 
-1, -1.14278, 0, -1, 0.159763,-99) , 
3, -0.646522, 0, 0, 0.287892,-99) , 
3, 0.179643, 0, 0, 0.509796,-99)    );
  // itree = 1790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8206, 1, 1, 0.870407,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196211,-99) , 
0, 0.91729, 1, 0, 0.616251,-99) , 
3, 1.12078, 0, 0, 0.73493,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285308,-99) , 
0, -0.280286, 1, 0, 0.463552,-99) , 
NN(
0, 
0, 
-1, -0.569189, 1, -1, 0.213109,-99) , 
3, -0.289575, 0, 0, 0.297113,-99) , 
3, 0.27076, 0, 0, 0.495619,-99)    );
  // itree = 1791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3356, 1, 1, 0.890953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336937,-99) , 
0, 0.978225, 1, 0, 0.605223,-99) , 
3, 1.116, 0, 0, 0.760111,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285422,-99) , 
1, -0.0404006, 1, 0, 0.433115,-99) , 
NN(
0, 
0, 
-1, -1.39105, 0, -1, 0.151214,-99) , 
3, -0.747078, 0, 0, 0.290126,-99) , 
3, 0.322102, 0, 0, 0.501625,-99)    );
  // itree = 1792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04325, 0, 1, 0.805878,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332046,-99) , 
0, 0.0300227, 1, 0, 0.522765,-99) , 
NN(
0, 
0, 
-1, -1.51336, 0, -1, 0.202527,-99) , 
3, -0.230339, 0, 0, 0.33552,-99) , 
3, 0.673895, 0, 0, 0.490162,-99)    );
  // itree = 1793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3469, 0, 1, 0.822974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4736,-99) , 
3, 0.554749, 0, 0, 0.748369,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323619,-99) , 
0, -0.579953, 1, 0, 0.461968,-99) , 
NN(
0, 
0, 
-1, -1.41885, 0, -1, 0.205675,-99) , 
3, -0.477004, 0, 0, 0.320246,-99) , 
3, 0.34753, 0, 0, 0.51234,-99)    );
  // itree = 1794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16129, 0, 1, 0.803135,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297364,-99) , 
0, 0.16021, 1, 0, 0.508384,-99) , 
3, 0.560587, 0, 0, 0.687052,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154471,-99) , 
0, -1.24308, 1, 0, 0.284903,-99) , 
NN(
0, 
0, 
-1, -0.365486, 1, -1, 0.107503,-99) , 
3, -1.14247, 0, 0, 0.211818,-99) , 
3, -0.133228, 0, 0, 0.489381,-99)    );
  // itree = 1795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63458, 1, 1, 0.8679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335387,-99) , 
0, 0.634527, 1, 0, 0.591545,-99) , 
3, 0.95947, 0, 0, 0.745579,-99) , 
NN(
0, 
0, 
-1, -1.51662, 0, -1, 0.279927,-99) , 
3, 0.131392, 0, 0, 0.526339,-99)    );
  // itree = 1796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21664, 0, 1, 0.875662,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294489,-99) , 
0, 0.284185, 1, 0, 0.549565,-99) , 
3, 0.85867, 0, 0, 0.689059,-99) , 
NN(
0, 
0, 
-1, -1.05776, 0, -1, 0.24622,-99) , 
3, -0.291428, 0, 0, 0.526674,-99)    );
  // itree = 1797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.88437,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427127,-99) , 
0, 0.262911, 1, 0, 0.59129,-99) , 
3, 1.05859, 0, 0, 0.716818,-99) , 
NN(
0, 
0, 
-1, -0.572723, 0, -1, 0.241386,-99) , 
3, -0.0725463, 0, 0, 0.509202,-99)    );
  // itree = 1798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.85193,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349286,-99) , 
0, 0.146168, 1, 0, 0.577528,-99) , 
3, 0.637508, 0, 0, 0.737657,-99) , 
NN(
0, 
0, 
-1, -0.539588, 0, -1, 0.239958,-99) , 
3, -0.0426953, 0, 0, 0.501285,-99)    );
  // itree = 1799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74538, 0, 1, 0.869841,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388025,-99) , 
0, 0.205991, 1, 0, 0.551757,-99) , 
3, 1.0878, 0, 0, 0.660972,-99) , 
NN(
0, 
0, 
-1, -1.30467, 0, -1, 0.175115,-99) , 
3, -0.291428, 0, 0, 0.488128,-99)    );
  // itree = 1800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41118, 0, 1, 0.841817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280276,-99) , 
0, 0.716184, 1, 0, 0.580307,-99) , 
3, 0.863368, 0, 0, 0.717009,-99) , 
NN(
0, 
0, 
-1, -0.539588, 0, -1, 0.220586,-99) , 
3, -0.0426953, 0, 0, 0.486774,-99)    );
  // itree = 1801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.853802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399846,-99) , 
0, 0.488, 1, 0, 0.609962,-99) , 
3, 0.875978, 0, 0, 0.757583,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21981,-99) , 
3, -0.825152, 0, 0, 0.405194,-99) , 
NN(
0, 
0, 
-1, -1.31455, 0, -1, 0.166116,-99) , 
1, -0.00674708, 1, 0, 0.271397,-99) , 
3, 0.256412, 0, 0, 0.481345,-99)    );
  // itree = 1802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.84322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277488,-99) , 
0, 0.527284, 1, 0, 0.524307,-99) , 
3, 0.952846, 0, 0, 0.659167,-99) , 
NN(
0, 
0, 
-1, -1.24788, 0, -1, 0.195721,-99) , 
3, -0.218528, 0, 0, 0.458724,-99)    );
  // itree = 1803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2121, 0, 1, 0.796489,-99) , 
NN(
0, 
0, 
-1, -1.13178, 0, -1, 0.330142,-99) , 
3, 0.661338, 0, 0, 0.477408,-99)    );
  // itree = 1804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65898, 0, 1, 0.841071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380727,-99) , 
0, 0.528454, 1, 0, 0.625205,-99) , 
3, 0.987635, 0, 0, 0.73739,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324719,-99) , 
0, -0.570764, 1, 0, 0.466007,-99) , 
NN(
0, 
0, 
-1, -1.14346, 0, -1, 0.193143,-99) , 
3, -0.393448, 0, 0, 0.292587,-99) , 
3, 0.163853, 0, 0, 0.50886,-99)    );
  // itree = 1805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.852768, 1, 1, 0.861018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353177,-99) , 
0, 0.284185, 1, 0, 0.556742,-99) , 
3, 0.856699, 0, 0, 0.688019,-99) , 
NN(
0, 
0, 
-1, -1.73727, 0, -1, 0.196693,-99) , 
3, -0.260982, 0, 0, 0.514641,-99)    );
  // itree = 1806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.873941,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260627,-99) , 
0, 0.408308, 1, 0, 0.548353,-99) , 
3, 0.845948, 0, 0, 0.700406,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.207553,-99) , 
3, -0.302053, 0, 0, 0.522576,-99)    );
  // itree = 1807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.18544, 0, 1, 0.691862,-99) , 
NN(
0, 
0, 
-1, -1.2441, 0, -1, 0.186627,-99) , 
3, -0.218528, 0, 0, 0.480081,-99)    );
  // itree = 1808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.860452,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326265,-99) , 
0, 0.829703, 1, 0, 0.613649,-99) , 
3, 1.08254, 0, 0, 0.741072,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26375,-99) , 
0, -0.744457, 1, 0, 0.388732,-99) , 
NN(
0, 
0, 
-1, -0.211632, 1, -1, 0.100312,-99) , 
3, -1.09738, 0, 0, 0.308179,-99) , 
3, 0.256412, 0, 0, 0.492309,-99)    );
  // itree = 1809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.89149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492424,-99) , 
0, 0.930889, 1, 0, 0.698364,-99) , 
3, 1.16738, 0, 0, 0.82295,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220103,-99) , 
0, 0.259256, 1, 0, 0.482828,-99) , 
NN(
0, 
0, 
-1, -1.17626, 0, -1, 0.181626,-99) , 
3, -0.488483, 0, 0, 0.347219,-99) , 
3, 0.644141, 0, 0, 0.510548,-99)    );
  // itree = 1810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.909908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483585,-99) , 
0, 0.891798, 1, 0, 0.662544,-99) , 
3, 1.43509, 0, 0, 0.749768,-99) , 
NN(
0, 
0, 
-1, -0.365924, 0, -1, 0.248739,-99) , 
3, 0.191234, 0, 0, 0.491267,-99)    );
  // itree = 1811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.833328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451813,-99) , 
3, 0.674598, 0, 0, 0.581634,-99) , 
3, 1.02245, 0, 0, 0.738072,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212551,-99) , 
0, 0.124475, 1, 0, 0.460299,-99) , 
NN(
0, 
0, 
-1, 0.0225495, 1, -1, 0.180013,-99) , 
3, -0.41563, 0, 0, 0.302552,-99) , 
3, 0.402144, 0, 0, 0.47301,-99)    );
  // itree = 1812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.907023,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416346,-99) , 
0, 1.13238, 1, 0, 0.623167,-99) , 
3, 1.30918, 0, 0, 0.739144,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288285,-99) , 
0, -0.909982, 1, 0, 0.391218,-99) , 
NN(
0, 
0, 
-1, -1.72267, 0, -1, 0.148825,-99) , 
3, -0.549382, 0, 0, 0.253062,-99) , 
3, 0.268003, 0, 0, 0.452253,-99)    );
  // itree = 1813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.878874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339496,-99) , 
0, 0.899668, 1, 0, 0.638713,-99) , 
3, 1.17479, 0, 0, 0.759009,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277648,-99) , 
0, -0.579953, 1, 0, 0.412321,-99) , 
NN(
0, 
0, 
-1, -1.64192, 0, -1, 0.16449,-99) , 
3, -0.751608, 0, 0, 0.301062,-99) , 
3, 0.34753, 0, 0, 0.497085,-99)    );
  // itree = 1814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62031, 0, 1, 0.822657,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337728,-99) , 
0, 0.076294, 1, 0, 0.532545,-99) , 
3, 0.707229, 0, 0, 0.69138,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22326,-99) , 
0, -1.30853, 1, 0, 0.355167,-99) , 
NN(
0, 
0, 
-1, -1.61541, 0, -1, 0.0813831,-99) , 
3, -1.20223, 0, 0, 0.240619,-99) , 
3, -0.206128, 0, 0, 0.516838,-99)    );
  // itree = 1815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.829857,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.90311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356479,-99) , 
0, 0.0304304, 1, 0, 0.545385,-99) , 
3, 0.866807, 0, 0, 0.690471,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212033,-99) , 
0, -0.898913, 1, 0, 0.35299,-99) , 
NN(
0, 
0, 
-1, -1.19048, 1, -1, 0.135464,-99) , 
3, -0.770557, 0, 0, 0.23282,-99) , 
3, -0.0295996, 0, 0, 0.470087,-99)    );
  // itree = 1816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.873252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454957,-99) , 
0, 0.227988, 1, 0, 0.624646,-99) , 
3, 1.01767, 0, 0, 0.727379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202486,-99) , 
0, -1.13507, 1, 0, 0.316513,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.0839189,-99) , 
3, -1.14068, 0, 0, 0.217825,-99) , 
3, -0.133228, 0, 0, 0.521918,-99)    );
  // itree = 1817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41252, 0, 1, 0.818062,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25018,-99) , 
0, 0.259256, 1, 0, 0.485012,-99) , 
NN(
0, 
0, 
-1, -1.50365, 0, -1, 0.135676,-99) , 
3, -0.528692, 0, 0, 0.331328,-99) , 
3, 0.673895, 0, 0, 0.492996,-99)    );
  // itree = 1818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07882, 0, 1, 0.811772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429792,-99) , 
0, -0.744779, 1, 0, 0.515732,-99) , 
3, 0.733871, 0, 0, 0.65732,-99) , 
NN(
0, 
0, 
-1, -0.914718, 0, -1, 0.153655,-99) , 
3, -0.415423, 0, 0, 0.494023,-99)    );
  // itree = 1819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62126, 0, 1, 0.890895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311307,-99) , 
0, 1.03728, 1, 0, 0.631718,-99) , 
3, 1.11005, 0, 0, 0.762283,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242131,-99) , 
0, -0.324253, 1, 0, 0.464378,-99) , 
NN(
0, 
0, 
-1, -1.06357, 0, -1, 0.189622,-99) , 
3, -0.569108, 0, 0, 0.321429,-99) , 
3, 0.27076, 0, 0, 0.533733,-99)    );
  // itree = 1820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66395, 0, 1, 0.76166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290169,-99) , 
0, -0.499885, 1, 0, 0.457148,-99) , 
3, 0.453505, 0, 0, 0.625066,-99) , 
NN(
0, 
0, 
-1, -1.47386, 0, -1, 0.17487,-99) , 
3, -0.547237, 0, 0, 0.483399,-99)    );
  // itree = 1821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.912332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471206,-99) , 
0, 1.19543, 1, 0, 0.741512,-99) , 
3, 1.37785, 0, 0, 0.827539,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229735,-99) , 
0, -0.0119168, 1, 0, 0.445797,-99) , 
NN(
0, 
0, 
-1, -1.51351, 0, -1, 0.191046,-99) , 
3, -0.546876, 0, 0, 0.329874,-99) , 
3, 0.644232, 0, 0, 0.488792,-99)    );
  // itree = 1822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58243, 1, 1, 0.854508,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244286,-99) , 
0, 0.227133, 1, 0, 0.471799,-99) , 
NN(
0, 
0, 
-1, -1.51038, 0, -1, 0.109405,-99) , 
3, -0.631987, 0, 0, 0.319856,-99) , 
3, 0.812932, 0, 0, 0.485352,-99)    );
  // itree = 1823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63654, 0, 1, 0.841759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38,-99) , 
0, -0.0638725, 1, 0, 0.55293,-99) , 
3, 0.897747, 0, 0, 0.667211,-99) , 
NN(
0, 
0, 
-1, -1.53562, 0, -1, 0.164715,-99) , 
3, -0.613987, 0, 0, 0.515536,-99)    );
  // itree = 1824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09657, 1, 1, 0.873781,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211624,-99) , 
0, 0.969329, 1, 0, 0.558927,-99) , 
3, 1.08754, 0, 0, 0.679809,-99) , 
NN(
0, 
0, 
-1, -0.539995, 0, -1, 0.224675,-99) , 
3, -0.0447319, 0, 0, 0.486743,-99)    );
  // itree = 1825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42459, 1, 1, 0.869132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27759,-99) , 
0, 1.03728, 1, 0, 0.638684,-99) , 
3, 1.13254, 0, 0, 0.755792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251737,-99) , 
0, -1.39151, 1, 0, 0.320895,-99) , 
NN(
0, 
0, 
-1, 0.0519819, 1, -1, 0.031327,-99) , 
3, -1.52297, 0, 0, 0.266712,-99) , 
3, 0.336059, 0, 0, 0.479439,-99)    );
  // itree = 1826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17464, 1, 1, 0.881702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306742,-99) , 
0, 0.927932, 1, 0, 0.568525,-99) , 
3, 1.18593, 0, 0, 0.674699,-99) , 
NN(
0, 
0, 
-1, -0.475285, 0, -1, 0.225697,-99) , 
3, -0.218528, 0, 0, 0.484998,-99)    );
  // itree = 1827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.848482,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260105,-99) , 
0, 0.865651, 1, 0, 0.566077,-99) , 
3, 1.05069, 0, 0, 0.706146,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213468,-99) , 
0, -0.381656, 1, 0, 0.455472,-99) , 
NN(
0, 
0, 
-1, -1.50772, 0, -1, 0.192961,-99) , 
3, -0.578201, 0, 0, 0.314292,-99) , 
3, 0.240623, 0, 0, 0.492179,-99)    );
  // itree = 1828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6322, 1, 1, 0.887734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288727,-99) , 
0, 0.89651, 1, 0, 0.562558,-99) , 
3, 1.16577, 0, 0, 0.664016,-99) , 
NN(
0, 
0, 
-1, -1.15987, 0, -1, 0.221815,-99) , 
3, -0.415423, 0, 0, 0.521848,-99)    );
  // itree = 1829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2068, 0, 1, 0.856625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324385,-99) , 
0, 0.291557, 1, 0, 0.547301,-99) , 
3, 0.832607, 0, 0, 0.708877,-99) , 
NN(
0, 
0, 
-1, -0.572723, 0, -1, 0.257458,-99) , 
3, -0.0725463, 0, 0, 0.507748,-99)    );
  // itree = 1830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.877684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362226,-99) , 
0, 0.91729, 1, 0, 0.610373,-99) , 
3, 1.12513, 0, 0, 0.751531,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248571,-99) , 
0, -0.363035, 1, 0, 0.448333,-99) , 
NN(
0, 
0, 
-1, -1.63381, 0, -1, 0.17456,-99) , 
3, -0.484215, 0, 0, 0.290633,-99) , 
3, 0.322617, 0, 0, 0.48755,-99)    );
  // itree = 1831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56795, 0, 1, 0.833741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390678,-99) , 
0, 0.076294, 1, 0, 0.562387,-99) , 
3, 0.835097, 0, 0, 0.70054,-99) , 
NN(
0, 
0, 
-1, -0.570761, 0, -1, 0.254611,-99) , 
3, -0.0725463, 0, 0, 0.513447,-99)    );
  // itree = 1832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.897333,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395335,-99) , 
0, 0.865651, 1, 0, 0.631394,-99) , 
3, 1.08254, 0, 0, 0.766185,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198537,-99) , 
0, -0.381656, 1, 0, 0.428314,-99) , 
NN(
0, 
0, 
-1, -1.73655, 0, -1, 0.16965,-99) , 
3, -0.55608, 0, 0, 0.282996,-99) , 
3, 0.256412, 0, 0, 0.50333,-99)    );
  // itree = 1833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.675747, 0, 1, 0.770034,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318831,-99) , 
0, -0.381656, 1, 0, 0.494409,-99) , 
NN(
0, 
0, 
-1, -1.94318, 0, -1, 0.171367,-99) , 
3, -0.549382, 0, 0, 0.321931,-99) , 
3, 0.268003, 0, 0, 0.532257,-99)    );
  // itree = 1834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16798, 0, 1, 0.847825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325837,-99) , 
0, 0.284185, 1, 0, 0.573301,-99) , 
3, 0.799281, 0, 0, 0.71975,-99) , 
NN(
0, 
0, 
-1, -1.30242, 0, -1, 0.243174,-99) , 
3, -0.0901485, 0, 0, 0.506553,-99)    );
  // itree = 1835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.816724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455106,-99) , 
0, 0.0584572, 1, 0, 0.600579,-99) , 
3, 0.859497, 0, 0, 0.706039,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196445,-99) , 
0, -0.843998, 1, 0, 0.351484,-99) , 
NN(
0, 
0, 
-1, -1.90981, 1, -1, 0.144594,-99) , 
3, -0.725589, 0, 0, 0.233174,-99) , 
3, 0.0722451, 0, 0, 0.469623,-99)    );
  // itree = 1836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15928, 0, 1, 0.821296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34747,-99) , 
0, 0.141994, 1, 0, 0.537802,-99) , 
3, 0.78913, 0, 0, 0.690346,-99) , 
NN(
0, 
0, 
-1, -0.639048, 0, -1, 0.183999,-99) , 
3, -0.133228, 0, 0, 0.495536,-99)    );
  // itree = 1837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80658, 1, 1, 0.878854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321646,-99) , 
0, 0.949005, 1, 0, 0.647242,-99) , 
3, 1.14618, 0, 0, 0.762763,-99) , 
NN(
0, 
0, 
-1, -1.51621, 0, -1, 0.292973,-99) , 
3, 0.34765, 0, 0, 0.491115,-99)    );
  // itree = 1838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63244, 0, 1, 0.850241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358191,-99) , 
0, 0.733856, 1, 0, 0.624574,-99) , 
3, 1.13676, 0, 0, 0.702029,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17586,-99) , 
0, -1.33908, 1, 0, 0.306857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0665414,-99) , 
3, -1.45772, 0, 0, 0.242092,-99) , 
3, -0.216753, 0, 0, 0.527044,-99)    );
  // itree = 1839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.883242,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440681,-99) , 
0, 0.488, 1, 0, 0.635976,-99) , 
3, 0.90654, 0, 0, 0.792308,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297076,-99) , 
0, -0.523936, 1, 0, 0.506303,-99) , 
NN(
0, 
0, 
-1, -1.77051, 0, -1, 0.146148,-99) , 
3, -0.569108, 0, 0, 0.294575,-99) , 
3, 0.27076, 0, 0, 0.522712,-99)    );
  // itree = 1840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.804709,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264167,-99) , 
0, 0.473287, 1, 0, 0.533569,-99) , 
NN(
0, 
0, 
-1, -0.688061, 0, -1, 0.24431,-99) , 
3, 0.146911, 0, 0, 0.320172,-99) , 
3, 0.760049, 0, 0, 0.462511,-99)    );
  // itree = 1841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47603, 0, 1, 0.8564,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396549,-99) , 
0, 0.284185, 1, 0, 0.555642,-99) , 
3, 1.12315, 0, 0, 0.675151,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18282,-99) , 
0, -0.737845, 1, 0, 0.343051,-99) , 
NN(
0, 
0, 
-1, -0.0940381, 1, -1, 0.0911879,-99) , 
3, -0.986973, 0, 0, 0.237325,-99) , 
3, -0.000562009, 0, 0, 0.493183,-99)    );
  // itree = 1842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.89393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274091,-99) , 
0, 1.10833, 1, 0, 0.552419,-99) , 
3, 1.1223, 0, 0, 0.66998,-99) , 
NN(
0, 
0, 
-1, -1.48038, 0, -1, 0.222833,-99) , 
3, -0.231227, 0, 0, 0.490572,-99)    );
  // itree = 1843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.842205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418853,-99) , 
0, -0.0268381, 1, 0, 0.584224,-99) , 
3, 0.969687, 0, 0, 0.701516,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.219793,-99) , 
3, -0.145446, 0, 0, 0.492774,-99)    );
  // itree = 1844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40104, 0, 1, 0.818281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25002,-99) , 
0, 0.295007, 1, 0, 0.485189,-99) , 
3, 0.669914, 0, 0, 0.668202,-99) , 
NN(
0, 
0, 
-1, -1.71764, 0, -1, 0.192447,-99) , 
3, -0.231227, 0, 0, 0.482013,-99)    );
  // itree = 1845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.41907, 0, 1, 0.710312,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265996,-99) , 
0, -0.785825, 1, 0, 0.402966,-99) , 
NN(
0, 
0, 
-1, -1.84585, 0, -1, 0.118436,-99) , 
3, -0.647965, 0, 0, 0.251151,-99) , 
3, 0.179643, 0, 0, 0.467325,-99)    );
  // itree = 1846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5869, 0, 1, 0.858322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411672,-99) , 
0, 0.454461, 1, 0, 0.617331,-99) , 
3, 1.06094, 0, 0, 0.717667,-99) , 
NN(
0, 
0, 
-1, -1.31821, 0, -1, 0.201911,-99) , 
3, -0.0725463, 0, 0, 0.492961,-99)    );
  // itree = 1847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49545, 1, 1, 0.845897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395156,-99) , 
0, 0.488, 1, 0, 0.590766,-99) , 
3, 1.00602, 0, 0, 0.721812,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222809,-99) , 
0, -0.601449, 1, 0, 0.364426,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.183929,-99) , 
3, -0.646522, 0, 0, 0.271257,-99) , 
3, 0.179643, 0, 0, 0.4796,-99)    );
  // itree = 1848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.888553,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.885744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4329,-99) , 
0, 0.0300823, 1, 0, 0.568771,-99) , 
3, 1.09078, 0, 0, 0.697165,-99) , 
NN(
0, 
0, 
-1, -1.50946, 0, -1, 0.242138,-99) , 
3, -0.0295996, 0, 0, 0.482093,-99)    );
  // itree = 1849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.841456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348876,-99) , 
0, 0.097998, 1, 0, 0.54597,-99) , 
3, 0.98113, 0, 0, 0.660454,-99) , 
NN(
0, 
0, 
-1, -1.6432, 0, -1, 0.198237,-99) , 
3, -0.514401, 0, 0, 0.525433,-99)    );
  // itree = 1850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19246, 1, 1, 0.8341,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278994,-99) , 
0, 0.295007, 1, 0, 0.535197,-99) , 
3, 0.630536, 0, 0, 0.694547,-99) , 
NN(
0, 
0, 
-1, -0.801599, 0, -1, 0.205666,-99) , 
3, -0.291428, 0, 0, 0.504931,-99)    );
  // itree = 1851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52219, 1, 1, 0.820686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291868,-99) , 
0, 0.158188, 1, 0, 0.504354,-99) , 
3, 0.645973, 0, 0, 0.657112,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.111446,-99) , 
3, -0.613987, 0, 0, 0.49452,-99)    );
  // itree = 1852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14495, 1, 1, 0.848301,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319888,-99) , 
0, 0.183786, 1, 0, 0.526891,-99) , 
3, 0.746027, 0, 0, 0.687202,-99) , 
NN(
0, 
0, 
-1, -1.63003, 0, -1, 0.218349,-99) , 
3, -0.156071, 0, 0, 0.490654,-99)    );
  // itree = 1853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.24775, 0, 1, 0.706079,-99) , 
NN(
0, 
0, 
-1, -0.640241, 0, -1, 0.227812,-99) , 
3, -0.133228, 0, 0, 0.506085,-99)    );
  // itree = 1854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.563626, 1, 1, 0.86472,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244704,-99) , 
0, 0.547267, 1, 0, 0.504613,-99) , 
NN(
0, 
0, 
-1, -1.5259, 0, -1, 0.179041,-99) , 
3, -0.250824, 0, 0, 0.316529,-99) , 
3, 0.644232, 0, 0, 0.501718,-99)    );
  // itree = 1855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3916, 0, 1, 0.866422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387975,-99) , 
0, 0.488, 1, 0, 0.636377,-99) , 
3, 0.870114, 0, 0, 0.781094,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315248,-99) , 
0, -1.05858, 1, 0, 0.410661,-99) , 
NN(
0, 
0, 
-1, -1.59299, 0, -1, 0.116166,-99) , 
3, -1.09553, 0, 0, 0.322234,-99) , 
3, 0.256412, 0, 0, 0.522442,-99)    );
  // itree = 1856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.843954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433989,-99) , 
0, -0.328864, 1, 0, 0.545748,-99) , 
3, 0.713805, 0, 0, 0.699523,-99) , 
NN(
0, 
0, 
-1, -0.706455, 0, -1, 0.216701,-99) , 
3, -0.206128, 0, 0, 0.513208,-99)    );
  // itree = 1857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41812, 0, 1, 0.847832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331238,-99) , 
0, 0.506819, 1, 0, 0.526378,-99) , 
3, 1.08845, 0, 0, 0.633124,-99) , 
NN(
0, 
0, 
-1, -1.05418, 0, -1, 0.212474,-99) , 
3, -0.291428, 0, 0, 0.483963,-99)    );
  // itree = 1858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.874759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16271,-99) , 
0, 0.932184, 1, 0, 0.54703,-99) , 
3, 0.970024, 0, 0, 0.692324,-99) , 
NN(
0, 
0, 
-1, -1.13315, 0, -1, 0.217274,-99) , 
3, -0.145446, 0, 0, 0.497108,-99)    );
  // itree = 1859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17115, 1, 1, 0.847555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413809,-99) , 
0, 0.341578, 1, 0, 0.615629,-99) , 
3, 0.784282, 0, 0, 0.734037,-99) , 
NN(
0, 
0, 
-1, -0.639048, 0, -1, 0.246029,-99) , 
3, -0.133228, 0, 0, 0.534664,-99)    );
  // itree = 1860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.875271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273764,-99) , 
0, 0.667103, 1, 0, 0.579021,-99) , 
3, 0.952846, 0, 0, 0.7116,-99) , 
NN(
0, 
0, 
-1, -1.50247, 0, -1, 0.197986,-99) , 
3, -0.218528, 0, 0, 0.517651,-99)    );
  // itree = 1861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48555, 1, 1, 0.846014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311745,-99) , 
0, 0.826055, 1, 0, 0.598975,-99) , 
3, 1.07814, 0, 0, 0.715773,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22178,-99) , 
0, -0.150485, 1, 0, 0.457908,-99) , 
NN(
0, 
0, 
-1, -1.26031, 0, -1, 0.151253,-99) , 
3, -0.55608, 0, 0, 0.291228,-99) , 
3, 0.256412, 0, 0, 0.479162,-99)    );
  // itree = 1862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13542, 0, 1, 0.817037,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343246,-99) , 
0, -0.289605, 1, 0, 0.503835,-99) , 
3, 0.564008, 0, 0, 0.656731,-99) , 
NN(
0, 
0, 
-1, -1.58422, 0, -1, 0.191437,-99) , 
3, -0.680259, 0, 0, 0.526385,-99)    );
  // itree = 1863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.983577, 0, 1, 0.899152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.917174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435191,-99) , 
3, 1.60573, 0, 0, 0.747013,-99) , 
0, 1.58243, 1, 0, 0.825947,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281847,-99) , 
0, 0.0477724, 1, 0, 0.488995,-99) , 
NN(
0, 
0, 
-1, -1.50209, 0, -1, 0.178229,-99) , 
3, -0.524691, 0, 0, 0.339748,-99) , 
3, 0.673895, 0, 0, 0.505356,-99)    );
  // itree = 1864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45802, 0, 1, 0.837833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316221,-99) , 
0, 0.461514, 1, 0, 0.557226,-99) , 
3, 0.975383, 0, 0, 0.669047,-99) , 
NN(
0, 
0, 
-1, -1.07606, 0, -1, 0.203764,-99) , 
3, -0.349135, 0, 0, 0.510593,-99)    );
  // itree = 1865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27856, 1, 1, 0.876405,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357826,-99) , 
0, 0.454879, 1, 0, 0.596262,-99) , 
3, 1.06405, 0, 0, 0.7274,-99) , 
NN(
0, 
0, 
-1, -0.0038903, 1, -1, 0.199927,-99) , 
3, -0.0725463, 0, 0, 0.496493,-99)    );
  // itree = 1866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68207, 0, 1, 0.854137,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484452,-99) , 
0, 0.27102, 1, 0, 0.60541,-99) , 
3, 1.18232, 0, 0, 0.69769,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190291,-99) , 
0, -1.43921, 1, 0, 0.313874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0466494,-99) , 
3, -1.50037, 0, 0, 0.238629,-99) , 
3, -0.218528, 0, 0, 0.526319,-99)    );
  // itree = 1867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.197369, 1, 1, 0.870562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308115,-99) , 
3, 1.19271, 0, 0, 0.640527,-99) , 
0, 1.17345, 1, 0, 0.744954,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243146,-99) , 
0, -0.200686, 1, 0, 0.453543,-99) , 
NN(
0, 
0, 
-1, -1.6543, 0, -1, 0.161898,-99) , 
3, -0.477004, 0, 0, 0.278904,-99) , 
3, 0.34753, 0, 0, 0.479367,-99)    );
  // itree = 1868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.894152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285905,-99) , 
0, 0.924863, 1, 0, 0.647048,-99) , 
3, 1.12513, 0, 0, 0.765107,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260318,-99) , 
0, -0.948993, 1, 0, 0.351866,-99) , 
NN(
0, 
0, 
-1, -1.63613, 0, -1, 0.112143,-99) , 
3, -1.02579, 0, 0, 0.279745,-99) , 
3, 0.322617, 0, 0, 0.495897,-99)    );
  // itree = 1869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.29649, 1, 1, 0.912053,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424027,-99) , 
0, 1.14736, 1, 0, 0.656645,-99) , 
3, 1.41883, 0, 0, 0.739588,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278773,-99) , 
0, -0.652568, 1, 0, 0.421906,-99) , 
NN(
0, 
0, 
-1, -1.62307, 0, -1, 0.180531,-99) , 
3, -0.379082, 0, 0, 0.271399,-99) , 
3, 0.179643, 0, 0, 0.490534,-99)    );
  // itree = 1870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50255, 1, 1, 0.815937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30593,-99) , 
0, 0.162203, 1, 0, 0.540463,-99) , 
3, 0.703037, 0, 0, 0.675657,-99) , 
NN(
0, 
0, 
-1, -1.22929, 0, -1, 0.120164,-99) , 
3, -0.547237, 0, 0, 0.487998,-99)    );
  // itree = 1871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13369, 0, 1, 0.847783,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209214,-99) , 
0, 0.341578, 1, 0, 0.439958,-99) , 
NN(
0, 
0, 
-1, -1.67865, 0, -1, 0.158661,-99) , 
3, -0.451773, 0, 0, 0.311064,-99) , 
3, 0.760049, 0, 0, 0.468399,-99)    );
  // itree = 1872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.792533,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383889,-99) , 
0, 0.0287117, 1, 0, 0.54773,-99) , 
3, 0.701193, 0, 0, 0.679223,-99) , 
NN(
0, 
0, 
-1, -1.69862, 0, -1, 0.230557,-99) , 
3, -0.206128, 0, 0, 0.498221,-99)    );
  // itree = 1873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.840446,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271793,-99) , 
0, 0.895962, 1, 0, 0.568091,-99) , 
3, 1.11733, 0, 0, 0.663734,-99) , 
NN(
0, 
0, 
-1, -0.98936, 0, -1, 0.204194,-99) , 
3, -0.231227, 0, 0, 0.49466,-99)    );
  // itree = 1874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.865642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319581,-99) , 
0, 0.91729, 1, 0, 0.583566,-99) , 
3, 1.116, 0, 0, 0.723766,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296586,-99) , 
0, -0.477384, 1, 0, 0.428782,-99) , 
NN(
0, 
0, 
-1, -1.17466, 0, -1, 0.161007,-99) , 
3, -0.483902, 0, 0, 0.277451,-99) , 
3, 0.320269, 0, 0, 0.478296,-99)    );
  // itree = 1875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.10128, 0, 1, 0.819552,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328904,-99) , 
0, -0.423729, 1, 0, 0.462451,-99) , 
NN(
0, 
0, 
-1, 0.311043, 1, -1, 0.176755,-99) , 
3, -0.406105, 0, 0, 0.327718,-99) , 
3, 0.741723, 0, 0, 0.486445,-99)    );
  // itree = 1876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.844346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309525,-99) , 
0, 0.0510396, 1, 0, 0.544365,-99) , 
3, 0.932403, 0, 0, 0.688895,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180505,-99) , 
0, -1.30853, 1, 0, 0.293172,-99) , 
NN(
0, 
0, 
-1, -1.74672, 0, -1, 0.0749344,-99) , 
3, -1.20223, 0, 0, 0.216016,-99) , 
3, -0.206128, 0, 0, 0.489587,-99)    );
  // itree = 1877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54175, 1, 1, 0.912079,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445956,-99) , 
0, 1.42731, 1, 0, 0.710235,-99) , 
3, 1.61127, 0, 0, 0.781443,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241823,-99) , 
0, -0.0721965, 1, 0, 0.437888,-99) , 
NN(
0, 
0, 
-1, -1.61239, 0, -1, 0.123875,-99) , 
3, -0.995049, 0, 0, 0.3481,-99) , 
3, 0.725852, 0, 0, 0.488303,-99)    );
  // itree = 1878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4466, 0, 1, 0.869632,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155399,-99) , 
0, 1.07553, 1, 0, 0.52428,-99) , 
3, 1.12471, 0, 0, 0.646299,-99) , 
NN(
0, 
0, 
-1, -0.698271, 0, -1, 0.223256,-99) , 
3, -0.2057, 0, 0, 0.484887,-99)    );
  // itree = 1879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54631, 1, 1, 0.771602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216497,-99) , 
0, 0.199273, 1, 0, 0.481031,-99) , 
3, 0.616639, 0, 0, 0.629098,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200393,-99) , 
0, -1.45821, 1, 0, 0.316838,-99) , 
NN(
0, 
0, 
-1, -0.213943, 1, -1, 0.0851278,-99) , 
3, -1.05968, 0, 0, 0.209543,-99) , 
3, -0.302053, 0, 0, 0.473043,-99)    );
  // itree = 1880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74845, 1, 1, 0.901003,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463334,-99) , 
0, 1.13222, 1, 0, 0.694914,-99) , 
3, 1.18263, 0, 0, 0.796587,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330831,-99) , 
0, -0.744779, 1, 0, 0.462401,-99) , 
NN(
0, 
0, 
-1, -1.65101, 0, -1, 0.153976,-99) , 
3, -0.693946, 0, 0, 0.327111,-99) , 
3, 0.461823, 0, 0, 0.5035,-99)    );
  // itree = 1881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67413, 0, 1, 0.86211,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375862,-99) , 
0, 0.488, 1, 0, 0.594419,-99) , 
3, 0.96671, 0, 0, 0.754201,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338706,-99) , 
1, -0.22475, 1, 0, 0.462612,-99) , 
NN(
0, 
0, 
-1, -1.69911, 0, -1, 0.235005,-99) , 
3, -0.2022, 0, 0, 0.308106,-99) , 
3, 0.34753, 0, 0, 0.505861,-99)    );
  // itree = 1882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.16841, 1, 1, 0.857225,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376676,-99) , 
0, 0.702199, 1, 0, 0.599645,-99) , 
3, 1.10087, 0, 0, 0.737339,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238919,-99) , 
1, 0.141595, 1, 0, 0.369719,-99) , 
NN(
0, 
0, 
-1, 0.0647876, 0, -1, 0.0389043,-99) , 
3, -1.52274, 0, 0, 0.305432,-99) , 
3, 0.312544, 0, 0, 0.497632,-99)    );
  // itree = 1883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593214, 0, 1, 0.748272,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246661,-99) , 
0, -0.504546, 1, 0, 0.42286,-99) , 
NN(
0, 
0, 
-1, -1.61118, 0, -1, 0.153448,-99) , 
3, -0.646522, 0, 0, 0.270188,-99) , 
3, 0.179643, 0, 0, 0.504967,-99)    );
  // itree = 1884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08802, 1, 1, 0.856767,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292393,-99) , 
0, -0.0319407, 1, 0, 0.485374,-99) , 
NN(
0, 
0, 
-1, -1.58042, 0, -1, 0.178812,-99) , 
3, -0.379989, 0, 0, 0.350299,-99) , 
3, 0.828289, 0, 0, 0.498359,-99)    );
  // itree = 1885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32004, 0, 1, 0.842685,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330595,-99) , 
0, 0.0074827, 1, 0, 0.518891,-99) , 
NN(
0, 
0, 
-1, -1.19629, 0, -1, 0.218777,-99) , 
3, -0.156612, 0, 0, 0.344865,-99) , 
3, 0.760049, 0, 0, 0.498708,-99)    );
  // itree = 1886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.86192, 0, 1, 0.849337,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.903729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335759,-99) , 
0, 0.475931, 1, 0, 0.610028,-99) , 
3, 0.799901, 0, 0, 0.759098,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231054,-99) , 
0, -0.612827, 1, 0, 0.436711,-99) , 
NN(
0, 
0, 
-1, -1.14246, 0, -1, 0.156537,-99) , 
3, -0.648962, 0, 0, 0.288052,-99) , 
3, 0.179643, 0, 0, 0.523424,-99)    );
  // itree = 1887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.10923, 0, 1, 0.790457,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19951,-99) , 
0, 0.431079, 1, 0, 0.480701,-99) , 
NN(
0, 
0, 
-1, -1.3947, 0, -1, 0.183293,-99) , 
3, -0.446363, 0, 0, 0.336458,-99) , 
3, 0.729578, 0, 0, 0.47137,-99)    );
  // itree = 1888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.25346, 0, 1, 0.794959,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207901,-99) , 
0, 0.398957, 1, 0, 0.480326,-99) , 
NN(
0, 
0, 
-1, -1.41991, 0, -1, 0.192128,-99) , 
3, -0.752211, 0, 0, 0.370838,-99) , 
3, 0.712472, 0, 0, 0.505165,-99)    );
  // itree = 1889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.831359,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377644,-99) , 
0, -0.0558779, 1, 0, 0.534225,-99) , 
3, 0.727702, 0, 0, 0.687301,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.217888,-99) , 
3, -0.218528, 0, 0, 0.499974,-99)    );
  // itree = 1890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.55945, 0, 1, 0.846437,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326496,-99) , 
0, -0.0153026, 1, 0, 0.494034,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.148963,-99) , 
3, -0.547498, 0, 0, 0.335752,-99) , 
3, 0.644232, 0, 0, 0.506534,-99)    );
  // itree = 1891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832823, 0, 1, 0.765463,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.905768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331269,-99) , 
0, -0.836892, 1, 0, 0.445867,-99) , 
NN(
0, 
0, 
-1, -0.275778, 1, -1, 0.161846,-99) , 
3, -0.381926, 0, 0, 0.287497,-99) , 
3, 0.427177, 0, 0, 0.47462,-99)    );
  // itree = 1892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.77839, 0, 1, 0.816707,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216283,-99) , 
0, 0.155544, 1, 0, 0.442706,-99) , 
NN(
0, 
0, 
-1, -1.5088, 0, -1, 0.136672,-99) , 
3, -0.82328, 0, 0, 0.339559,-99) , 
3, 0.673895, 0, 0, 0.503564,-99)    );
  // itree = 1893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.892783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455695,-99) , 
0, 0.865651, 1, 0, 0.714263,-99) , 
3, 1.12237, 0, 0, 0.802291,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301686,-99) , 
0, -0.607343, 1, 0, 0.41501,-99) , 
NN(
0, 
0, 
-1, -1.41006, 0, -1, 0.155167,-99) , 
3, -0.493211, 0, 0, 0.274027,-99) , 
3, 0.311026, 0, 0, 0.50921,-99)    );
  // itree = 1894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69109, 1, 1, 0.864915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384136,-99) , 
0, 0.408308, 1, 0, 0.583776,-99) , 
3, 0.969687, 0, 0, 0.713436,-99) , 
NN(
0, 
0, 
-1, -1.13085, 0, -1, 0.210256,-99) , 
3, -0.145446, 0, 0, 0.51345,-99)    );
  // itree = 1895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.845,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319019,-99) , 
0, 0.838292, 1, 0, 0.607577,-99) , 
3, 1.00983, 0, 0, 0.725822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2773,-99) , 
0, -1.02297, 1, 0, 0.398591,-99) , 
NN(
0, 
0, 
-1, -1.62423, 0, -1, 0.19064,-99) , 
3, -0.646522, 0, 0, 0.29792,-99) , 
3, 0.179643, 0, 0, 0.506419,-99)    );
  // itree = 1896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.874786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280323,-99) , 
0, 0.865651, 1, 0, 0.595878,-99) , 
3, 1.11463, 0, 0, 0.736048,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291694,-99) , 
0, -0.808742, 1, 0, 0.445263,-99) , 
NN(
0, 
0, 
-1, -1.54116, 0, -1, 0.168706,-99) , 
3, -0.580365, 0, 0, 0.294213,-99) , 
3, 0.27076, 0, 0, 0.492293,-99)    );
  // itree = 1897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65668, 0, 1, 0.851659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379432,-99) , 
0, 0.752972, 1, 0, 0.645384,-99) , 
3, 0.987635, 0, 0, 0.752905,-99) , 
NN(
0, 
0, 
-1, -0.387798, 0, -1, 0.295784,-99) , 
3, 0.163853, 0, 0, 0.524737,-99)    );
  // itree = 1898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09341, 1, 1, 0.841749,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315545,-99) , 
0, 0.788183, 1, 0, 0.574298,-99) , 
3, 1.01964, 0, 0, 0.716781,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301243,-99) , 
0, -0.843998, 1, 0, 0.425101,-99) , 
NN(
0, 
0, 
-1, -1.62282, 0, -1, 0.155813,-99) , 
3, -0.639477, 0, 0, 0.285113,-99) , 
3, 0.191234, 0, 0, 0.489528,-99)    );
  // itree = 1899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11223, 0, 1, 0.825876,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.920726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386114,-99) , 
0, -0.760367, 1, 0, 0.4752,-99) , 
NN(
0, 
0, 
-1, -2.08352, 1, -1, 0.171055,-99) , 
3, -0.441503, 0, 0, 0.334611,-99) , 
3, 0.742135, 0, 0, 0.489226,-99)    );
  // itree = 1900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53617, 0, 1, 0.841408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374455,-99) , 
0, 0.418264, 1, 0, 0.596384,-99) , 
3, 0.837658, 0, 0, 0.709722,-99) , 
NN(
0, 
0, 
-1, -1.60013, 0, -1, 0.21626,-99) , 
3, -0.316527, 0, 0, 0.549169,-99)    );
  // itree = 1901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61511, 1, 1, 0.851751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371985,-99) , 
0, 0.62132, 1, 0, 0.62303,-99) , 
3, 0.965707, 0, 0, 0.761215,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328404,-99) , 
0, -0.579953, 1, 0, 0.468657,-99) , 
NN(
0, 
0, 
-1, -1.6543, 0, -1, 0.193075,-99) , 
3, -0.477004, 0, 0, 0.306282,-99) , 
3, 0.34753, 0, 0, 0.501412,-99)    );
  // itree = 1902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.833419, 0, 1, 0.784926,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157591,-99) , 
0, -0.150485, 1, 0, 0.414334,-99) , 
NN(
0, 
0, 
-1, -1.55329, 0, -1, 0.120043,-99) , 
3, -0.650767, 0, 0, 0.288016,-99) , 
3, 0.42901, 0, 0, 0.484329,-99)    );
  // itree = 1903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.840566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359877,-99) , 
0, 0.937344, 1, 0, 0.633044,-99) , 
3, 1.08605, 0, 0, 0.722666,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166266,-99) , 
0, -0.850436, 1, 0, 0.318946,-99) , 
NN(
0, 
0, 
-1, -1.64597, 0, -1, 0.131377,-99) , 
3, -0.786528, 0, 0, 0.220546,-99) , 
3, -0.0426953, 0, 0, 0.474734,-99)    );
  // itree = 1904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.845099,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227743,-99) , 
0, 0.388205, 1, 0, 0.488341,-99) , 
NN(
0, 
0, 
-1, -1.12572, 0, -1, 0.170479,-99) , 
3, -0.661336, 0, 0, 0.373589,-99) , 
3, 0.828289, 0, 0, 0.497824,-99)    );
  // itree = 1905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.44104, 0, 1, 0.840708,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180541,-99) , 
0, 0.239726, 1, 0, 0.44871,-99) , 
NN(
0, 
0, 
-1, -1.64192, 0, -1, 0.166427,-99) , 
3, -0.751564, 0, 0, 0.354963,-99) , 
3, 0.712472, 0, 0, 0.51617,-99)    );
  // itree = 1906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.742091, 0, 1, 0.884875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870433,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331608,-99) , 
3, 1.256, 0, 0, 0.70103,-99) , 
0, 1.26839, 1, 0, 0.785233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299628,-99) , 
0, -0.447798, 1, 0, 0.482216,-99) , 
NN(
0, 
0, 
-1, -1.58162, 0, -1, 0.196597,-99) , 
3, -0.41563, 0, 0, 0.317218,-99) , 
3, 0.402144, 0, 0, 0.50498,-99)    );
  // itree = 1907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.866114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474232,-99) , 
0, 0.205991, 1, 0, 0.620124,-99) , 
3, 1.17991, 0, 0, 0.705574,-99) , 
NN(
0, 
0, 
-1, 0.0176327, 1, -1, 0.243712,-99) , 
3, -0.156071, 0, 0, 0.493065,-99)    );
  // itree = 1908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14405, 0, 1, 0.8147,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287064,-99) , 
0, 0.367824, 1, 0, 0.578084,-99) , 
3, 0.792571, 0, 0, 0.689833,-99) , 
NN(
0, 
0, 
-1, -1.10075, 0, -1, 0.202653,-99) , 
3, -0.346282, 0, 0, 0.525595,-99)    );
  // itree = 1909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31634, 0, 1, 0.804182,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238274,-99) , 
0, 0.453613, 1, 0, 0.531475,-99) , 
3, 0.792571, 0, 0, 0.644564,-99) , 
NN(
0, 
0, 
-1, -1.10075, 0, -1, 0.192975,-99) , 
3, -0.346282, 0, 0, 0.478683,-99)    );
  // itree = 1910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44277, 0, 1, 0.838391,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342137,-99) , 
0, 0.232439, 1, 0, 0.52903,-99) , 
3, 0.926104, 0, 0, 0.666017,-99) , 
NN(
0, 
0, 
-1, -0.954029, 0, -1, 0.1929,-99) , 
3, -0.206128, 0, 0, 0.473721,-99)    );
  // itree = 1911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56997, 0, 1, 0.841621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447041,-99) , 
0, -0.733675, 1, 0, 0.511356,-99) , 
3, 0.860221, 0, 0, 0.657183,-99) , 
NN(
0, 
0, 
-1, -1.55935, 0, -1, 0.192335,-99) , 
3, -0.291428, 0, 0, 0.499732,-99)    );
  // itree = 1912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.883734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.938424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423367,-99) , 
0, 0.668751, 1, 0, 0.684644,-99) , 
3, 1.05898, 0, 0, 0.801953,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319783,-99) , 
0, -0.55321, 1, 0, 0.457255,-99) , 
NN(
0, 
0, 
-1, -1.49138, 0, -1, 0.166395,-99) , 
3, -0.622499, 0, 0, 0.332162,-99) , 
3, 0.451912, 0, 0, 0.51098,-99)    );
  // itree = 1913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.856794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307738,-99) , 
0, 0.877527, 1, 0, 0.609066,-99) , 
3, 1.11005, 0, 0, 0.722631,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215855,-99) , 
0, -0.333179, 1, 0, 0.479974,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.143295,-99) , 
3, -0.580365, 0, 0, 0.30682,-99) , 
3, 0.27076, 0, 0, 0.49018,-99)    );
  // itree = 1914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68539, 1, 1, 0.872887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274622,-99) , 
0, 0.500185, 1, 0, 0.56578,-99) , 
3, 0.963553, 0, 0, 0.705921,-99) , 
NN(
0, 
0, 
-1, -1.59884, 0, -1, 0.279404,-99) , 
3, -0.142731, 0, 0, 0.543685,-99)    );
  // itree = 1915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36618, 1, 1, 0.830382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354623,-99) , 
0, 0.348213, 1, 0, 0.590739,-99) , 
3, 0.789704, 0, 0, 0.714451,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270788,-99) , 
3, -0.898395, 0, 0, 0.436021,-99) , 
NN(
0, 
0, 
-1, -1.34992, 0, -1, 0.197875,-99) , 
1, -0.365486, 1, 0, 0.286515,-99) , 
3, -0.133228, 0, 0, 0.536307,-99)    );
  // itree = 1916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.86859,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.9189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455585,-99) , 
0, 0.0225001, 1, 0, 0.571708,-99) , 
3, 1.15996, 0, 0, 0.695415,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295496,-99) , 
0, -0.612827, 1, 0, 0.41049,-99) , 
NN(
0, 
0, 
-1, -2.35654, 1, -1, 0.126231,-99) , 
3, -0.696161, 0, 0, 0.252131,-99) , 
3, 0.125502, 0, 0, 0.482831,-99)    );
  // itree = 1917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.838191, 0, 1, 0.828303,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350861,-99) , 
0, -0.766228, 1, 0, 0.476633,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.146211,-99) , 
3, -0.653169, 0, 0, 0.327846,-99) , 
3, 0.42901, 0, 0, 0.531788,-99)    );
  // itree = 1918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04321, 0, 1, 0.810947,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214994,-99) , 
0, 0.475416, 1, 0, 0.508335,-99) , 
NN(
0, 
0, 
-1, -1.52303, 0, -1, 0.229965,-99) , 
3, -0.238914, 0, 0, 0.356103,-99) , 
3, 0.661338, 0, 0, 0.513767,-99)    );
  // itree = 1919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.98872, 1, 1, 0.866942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465998,-99) , 
0, -0.0346559, 1, 0, 0.588769,-99) , 
3, 1.18232, 0, 0, 0.674332,-99) , 
NN(
0, 
0, 
-1, -0.987827, 0, -1, 0.228258,-99) , 
3, -0.218528, 0, 0, 0.510393,-99)    );
  // itree = 1920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.41103, 1, 1, 0.902069,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420507,-99) , 
0, 1.14736, 1, 0, 0.692398,-99) , 
3, 1.43873, 0, 0, 0.757434,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306139,-99) , 
0, -0.795814, 1, 0, 0.430824,-99) , 
NN(
0, 
0, 
-1, -1.14982, 0, -1, 0.137197,-99) , 
3, -0.641438, 0, 0, 0.26541,-99) , 
3, 0.191234, 0, 0, 0.486832,-99)    );
  // itree = 1921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.877343,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354769,-99) , 
0, 0.985893, 1, 0, 0.631219,-99) , 
3, 1.11296, 0, 0, 0.755272,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275207,-99) , 
0, -0.795814, 1, 0, 0.421877,-99) , 
NN(
0, 
0, 
-1, -1.18301, 0, -1, 0.151734,-99) , 
3, -0.494969, 0, 0, 0.274636,-99) , 
3, 0.311026, 0, 0, 0.48788,-99)    );
  // itree = 1922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.853052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323797,-99) , 
0, 0.471198, 1, 0, 0.559265,-99) , 
3, 0.95924, 0, 0, 0.695176,-99) , 
NN(
0, 
0, 
-1, -0.734051, 0, -1, 0.199742,-99) , 
3, -0.218528, 0, 0, 0.501868,-99)    );
  // itree = 1923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.850015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271781,-99) , 
0, 0.913386, 1, 0, 0.552421,-99) , 
3, 1.0878, 0, 0, 0.658123,-99) , 
NN(
0, 
0, 
-1, -1.05776, 0, -1, 0.224145,-99) , 
3, -0.291428, 0, 0, 0.507476,-99)    );
  // itree = 1924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42459, 1, 1, 0.875201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454567,-99) , 
0, 0.689005, 1, 0, 0.637677,-99) , 
3, 1.12623, 0, 0, 0.762506,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321565,-99) , 
0, -0.412323, 1, 0, 0.474083,-99) , 
NN(
0, 
0, 
-1, -1.64222, 1, -1, 0.215765,-99) , 
3, -0.216529, 0, 0, 0.298131,-99) , 
3, 0.322617, 0, 0, 0.486862,-99)    );
  // itree = 1925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.13552, 0, 1, 0.832788,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350699,-99) , 
0, -0.368003, 1, 0, 0.469523,-99) , 
NN(
0, 
0, 
-1, -1.4638, 0, -1, 0.16385,-99) , 
3, -0.769764, 0, 0, 0.370722,-99) , 
3, 0.760049, 0, 0, 0.513054,-99)    );
  // itree = 1926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38774, 1, 1, 0.840974,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27049,-99) , 
0, 0.471542, 1, 0, 0.537308,-99) , 
3, 0.628149, 0, 0, 0.690536,-99) , 
NN(
0, 
0, 
-1, -1.56424, 0, -1, 0.164709,-99) , 
3, -0.291428, 0, 0, 0.493114,-99)    );
  // itree = 1927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593214, 0, 1, 0.758529,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35495,-99) , 
2, -0.121824, 1, 0, 0.48317,-99) , 
NN(
0, 
0, 
-1, -1.62307, 0, -1, 0.199832,-99) , 
3, -0.372938, 0, 0, 0.291857,-99) , 
3, 0.179643, 0, 0, 0.510775,-99)    );
  // itree = 1928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26691, 1, 1, 0.878291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.94491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401276,-99) , 
0, 0.306862, 1, 0, 0.609337,-99) , 
3, 0.970491, 0, 0, 0.767732,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183463,-99) , 
0, -0.0748989, 1, 0, 0.400755,-99) , 
NN(
0, 
0, 
-1, -0.282852, 1, -1, 0.125136,-99) , 
3, -0.751702, 0, 0, 0.280346,-99) , 
3, 0.34753, 0, 0, 0.479053,-99)    );
  // itree = 1929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42719, 1, 1, 0.788871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315137,-99) , 
0, 0.232439, 1, 0, 0.572415,-99) , 
3, 0.733738, 0, 0, 0.680762,-99) , 
NN(
0, 
0, 
-1, -0.991836, 0, -1, 0.228071,-99) , 
3, -0.218528, 0, 0, 0.502167,-99)    );
  // itree = 1930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.67383, 1, 1, 0.888057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711082,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328486,-99) , 
0, 0.87199, 1, 0, 0.603763,-99) , 
3, 1.12077, 0, 0, 0.717435,-99) , 
NN(
0, 
0, 
-1, -0.72973, 0, -1, 0.198671,-99) , 
3, -0.231227, 0, 0, 0.505897,-99)    );
  // itree = 1931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.31972, 0, 1, 0.75356,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326833,-99) , 
0, -0.560073, 1, 0, 0.479468,-99) , 
NN(
0, 
0, 
-1, -1.53225, 0, -1, 0.188297,-99) , 
3, -0.569108, 0, 0, 0.308127,-99) , 
3, 0.27076, 0, 0, 0.5096,-99)    );
  // itree = 1932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85288, 1, 1, 0.885243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35263,-99) , 
0, 0.883664, 1, 0, 0.657403,-99) , 
3, 1.15247, 0, 0, 0.778524,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303957,-99) , 
0, -1.06627, 1, 0, 0.384371,-99) , 
NN(
0, 
0, 
-1, 0.271937, 1, -1, 0.0250247,-99) , 
3, -1.51351, 0, 0, 0.315401,-99) , 
3, 0.34765, 0, 0, 0.524995,-99)    );
  // itree = 1933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13606, 0, 1, 0.838691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221193,-99) , 
0, 0.625254, 1, 0, 0.526604,-99) , 
3, 0.804344, 0, 0, 0.673844,-99) , 
NN(
0, 
0, 
-1, -0.763632, 0, -1, 0.1927,-99) , 
3, -0.28484, 0, 0, 0.495385,-99)    );
  // itree = 1934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11461, 0, 1, 0.788375,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274787,-99) , 
0, 0.186933, 1, 0, 0.501078,-99) , 
3, 0.733653, 0, 0, 0.633248,-99) , 
NN(
0, 
0, 
-1, -1.1919, 0, -1, 0.178988,-99) , 
3, -0.499995, 0, 0, 0.498101,-99)    );
  // itree = 1935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11897, 1, 1, 0.863033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392396,-99) , 
0, 0.349423, 1, 0, 0.585269,-99) , 
3, 0.98113, 0, 0, 0.70198,-99) , 
NN(
0, 
0, 
-1, -0.967789, 0, -1, 0.154527,-99) , 
3, -0.499995, 0, 0, 0.52954,-99)    );
  // itree = 1936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.584147, 1, 1, 0.87555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339,-99) , 
0, 0.91729, 1, 0, 0.616869,-99) , 
3, 1.11005, 0, 0, 0.736328,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290474,-99) , 
0, -0.568658, 1, 0, 0.509555,-99) , 
NN(
0, 
0, 
-1, -1.54036, 0, -1, 0.185179,-99) , 
3, -0.569108, 0, 0, 0.32349,-99) , 
3, 0.27076, 0, 0, 0.515291,-99)    );
  // itree = 1937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67367, 0, 1, 0.882518,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435153,-99) , 
0, 0.399302, 1, 0, 0.582895,-99) , 
3, 1.19191, 0, 0, 0.682395,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161854,-99) , 
0, -1.01685, 1, 0, 0.319157,-99) , 
NN(
0, 
0, 
-1, -1.73486, 0, -1, 0.0964826,-99) , 
3, -1.13085, 0, 0, 0.231605,-99) , 
3, -0.145446, 0, 0, 0.493763,-99)    );
  // itree = 1938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.690724, 0, 1, 0.737225,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25514,-99) , 
0, -0.712533, 1, 0, 0.428107,-99) , 
NN(
0, 
0, 
-1, -1.30151, 0, -1, 0.113522,-99) , 
3, -0.569108, 0, 0, 0.258993,-99) , 
3, 0.27076, 0, 0, 0.469368,-99)    );
  // itree = 1939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.846843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.891043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430634,-99) , 
0, -0.147815, 1, 0, 0.571983,-99) , 
3, 0.949517, 0, 0, 0.702718,-99) , 
NN(
0, 
0, 
-1, -1.50037, 0, -1, 0.250971,-99) , 
3, -0.218528, 0, 0, 0.519671,-99)    );
  // itree = 1940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76873, 0, 1, 0.876779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255369,-99) , 
0, 1.15261, 1, 0, 0.561642,-99) , 
3, 1.14011, 0, 0, 0.672289,-99) , 
NN(
0, 
0, 
-1, -1.38449, 0, -1, 0.227468,-99) , 
3, -0.177886, 0, 0, 0.49716,-99)    );
  // itree = 1941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.785811,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462756,-99) , 
3, 0.553635, 0, 0, 0.726867,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285729,-99) , 
0, -0.305342, 1, 0, 0.449595,-99) , 
NN(
0, 
0, 
-1, -1.20121, 0, -1, 0.176729,-99) , 
3, -0.481272, 0, 0, 0.297856,-99) , 
3, 0.34753, 0, 0, 0.491628,-99)    );
  // itree = 1942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11421, 1, 1, 0.827034,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275951,-99) , 
0, -0.0219476, 1, 0, 0.472109,-99) , 
NN(
0, 
0, 
-1, -1.92326, 0, -1, 0.205554,-99) , 
3, -0.451773, 0, 0, 0.34787,-99) , 
3, 0.760049, 0, 0, 0.490723,-99)    );
  // itree = 1943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75197, 0, 1, 0.812474,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245247,-99) , 
0, 0.130775, 1, 0, 0.50718,-99) , 
3, 0.578517, 0, 0, 0.659464,-99) , 
NN(
0, 
0, 
-1, -1.65101, 0, -1, 0.151886,-99) , 
3, -0.707817, 0, 0, 0.517888,-99)    );
  // itree = 1944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46284, 0, 1, 0.857755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.913047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458225,-99) , 
0, -0.601062, 1, 0, 0.550943,-99) , 
3, 1.16658, 0, 0, 0.653386,-99) , 
NN(
0, 
0, 
-1, -0.395683, 1, -1, 0.180623,-99) , 
3, -0.434435, 0, 0, 0.501439,-99)    );
  // itree = 1945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.839054,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290069,-99) , 
0, 0.0878292, 1, 0, 0.531249,-99) , 
3, 0.616639, 0, 0, 0.697495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180361,-99) , 
0, -1.56653, 1, 0, 0.305631,-99) , 
NN(
0, 
0, 
-1, 0.182851, 1, -1, 0.0762222,-99) , 
3, -1.32203, 0, 0, 0.209292,-99) , 
3, -0.302053, 0, 0, 0.527656,-99)    );
  // itree = 1946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.859286,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438295,-99) , 
0, 0.907943, 1, 0, 0.67273,-99) , 
3, 1.1096, 0, 0, 0.790063,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207849,-99) , 
0, 0.0887677, 1, 0, 0.462807,-99) , 
NN(
0, 
0, 
-1, -1.45239, 0, -1, 0.158463,-99) , 
3, -0.566574, 0, 0, 0.308902,-99) , 
3, 0.577397, 0, 0, 0.476258,-99)    );
  // itree = 1947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42719, 1, 1, 0.804513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385942,-99) , 
0, -0.431084, 1, 0, 0.502458,-99) , 
3, 0.746843, 0, 0, 0.66997,-99) , 
NN(
0, 
0, 
-1, -0.862599, 1, -1, 0.190704,-99) , 
3, -0.145446, 0, 0, 0.453599,-99)    );
  // itree = 1948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38774, 1, 1, 0.815355,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280044,-99) , 
0, 0.158188, 1, 0, 0.482561,-99) , 
3, 0.58231, 0, 0, 0.648067,-99) , 
NN(
0, 
0, 
-1, -1.64404, 0, -1, 0.140296,-99) , 
3, -0.707817, 0, 0, 0.510962,-99)    );
  // itree = 1949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.873274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344348,-99) , 
0, 1.11769, 1, 0, 0.643239,-99) , 
3, 1.11005, 0, 0, 0.760778,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271496,-99) , 
0, -0.357805, 1, 0, 0.473498,-99) , 
NN(
0, 
0, 
-1, -0.00674708, 1, -1, 0.18898,-99) , 
3, -0.569108, 0, 0, 0.307682,-99) , 
3, 0.27076, 0, 0, 0.536758,-99)    );
  // itree = 1950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.858032,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377923,-99) , 
0, 0.732038, 1, 0, 0.639038,-99) , 
3, 1.08354, 0, 0, 0.743,-99) , 
NN(
0, 
0, 
-1, -0.278705, 0, -1, 0.272136,-99) , 
3, 0.268003, 0, 0, 0.481014,-99)    );
  // itree = 1951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.677469, 0, 1, 0.762475,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523522,-99) , 
NN(
0, 
0, 
-1, -0.752826, 1, -1, 0.221458,-99) , 
3, -0.00802737, 0, 0, 0.261856,-99) , 
3, 0.268003, 0, 0, 0.466985,-99)    );
  // itree = 1952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.45116, 0, 1, 0.83696,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300353,-99) , 
0, -0.0153026, 1, 0, 0.457831,-99) , 
NN(
0, 
0, 
-1, -1.64062, 0, -1, 0.117637,-99) , 
3, -0.739023, 0, 0, 0.333667,-99) , 
3, 0.729578, 0, 0, 0.484146,-99)    );
  // itree = 1953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42459, 1, 1, 0.872154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384482,-99) , 
0, 0.451048, 1, 0, 0.588002,-99) , 
3, 1.09078, 0, 0, 0.701283,-99) , 
NN(
0, 
0, 
-1, -1.51065, 0, -1, 0.214513,-99) , 
3, -0.0295996, 0, 0, 0.482367,-99)    );
  // itree = 1954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43852, 1, 1, 0.894897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275722,-99) , 
0, 1.07644, 1, 0, 0.637859,-99) , 
3, 1.14829, 0, 0, 0.766347,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362069,-99) , 
0, -1.01014, 1, 0, 0.456748,-99) , 
NN(
0, 
0, 
-1, -1.6043, 0, -1, 0.10819,-99) , 
3, -0.981765, 0, 0, 0.329857,-99) , 
3, 0.34765, 0, 0, 0.536024,-99)    );
  // itree = 1955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36045, 1, 1, 0.850853,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153154,-99) , 
0, 0.592564, 1, 0, 0.491516,-99) , 
NN(
0, 
0, 
-1, -0.461601, 1, -1, 0.125961,-99) , 
3, -0.94828, 0, 0, 0.389193,-99) , 
3, 0.79068, 0, 0, 0.54768,-99)    );
  // itree = 1956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22923, 0, 1, 0.803737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404429,-99) , 
2, 0.232701, 1, 0, 0.50538,-99) , 
3, 0.667626, 0, 0, 0.711969,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287727,-99) , 
0, -1.26149, 1, 0, 0.377109,-99) , 
NN(
0, 
0, 
-1, -1.72836, 0, -1, 0.0905409,-99) , 
3, -1.09553, 0, 0, 0.291333,-99) , 
3, 0.256412, 0, 0, 0.488538,-99)    );
  // itree = 1957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11296, 0, 1, 0.761236,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211839,-99) , 
0, -0.214268, 1, 0, 0.430524,-99) , 
NN(
0, 
0, 
-1, -1.84158, 0, -1, 0.164999,-99) , 
3, -0.759929, 0, 0, 0.304812,-99) , 
3, 0.311026, 0, 0, 0.511414,-99)    );
  // itree = 1958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81676, 1, 1, 0.879592,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300636,-99) , 
0, 0.687285, 1, 0, 0.549518,-99) , 
3, 1.18232, 0, 0, 0.661436,-99) , 
NN(
0, 
0, 
-1, -1.50393, 0, -1, 0.211726,-99) , 
3, -0.218528, 0, 0, 0.474146,-99)    );
  // itree = 1959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12039, 1, 1, 0.875716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475616,-99) , 
0, 0.57803, 1, 0, 0.654613,-99) , 
3, 1.17269, 0, 0, 0.763508,-99) , 
NN(
0, 
0, 
-1, -1.3011, 0, -1, 0.296237,-99) , 
3, 0.34753, 0, 0, 0.501876,-99)    );
  // itree = 1960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75578, 1, 1, 0.851561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435647,-99) , 
0, 0.142002, 1, 0, 0.565053,-99) , 
3, 1.14952, 0, 0, 0.644758,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.171179,-99) , 
3, -0.613987, 0, 0, 0.501164,-99)    );
  // itree = 1961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 1, 1, 0.850399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423556,-99) , 
0, -0.0319407, 1, 0, 0.547636,-99) , 
3, 0.904086, 0, 0, 0.672232,-99) , 
NN(
0, 
0, 
-1, -1.53282, 0, -1, 0.167572,-99) , 
3, -0.613987, 0, 0, 0.520924,-99)    );
  // itree = 1962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43344, 1, 1, 0.807208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320204,-99) , 
0, 0.284185, 1, 0, 0.51367,-99) , 
3, 0.861778, 0, 0, 0.649171,-99) , 
NN(
0, 
0, 
-1, -1.04883, 0, -1, 0.22,-99) , 
3, -0.0447319, 0, 0, 0.454056,-99)    );
  // itree = 1963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42363, 1, 1, 0.845583,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193769,-99) , 
0, 0.227133, 1, 0, 0.434994,-99) , 
NN(
0, 
0, 
-1, -1.30151, 0, -1, 0.144625,-99) , 
3, -0.57899, 0, 0, 0.297514,-99) , 
3, 0.602686, 0, 0, 0.480505,-99)    );
  // itree = 1964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.821246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287336,-99) , 
0, 0.227133, 1, 0, 0.547549,-99) , 
3, 0.646791, 0, 0, 0.677388,-99) , 
NN(
0, 
0, 
-1, -1.30194, 0, -1, 0.169643,-99) , 
3, -0.613987, 0, 0, 0.521148,-99)    );
  // itree = 1965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47799, 1, 1, 0.814591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271548,-99) , 
0, 0.454461, 1, 0, 0.556271,-99) , 
3, 0.790869, 0, 0, 0.688162,-99) , 
NN(
0, 
0, 
-1, -1.64431, 0, -1, 0.257376,-99) , 
3, -0.133228, 0, 0, 0.52211,-99)    );
  // itree = 1966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36667, 0, 1, 0.755232,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427597,-99) , 
3, -0.111331, 0, 0, 0.473239,-99) , 
NN(
0, 
0, 
-1, -1.1649, 0, -1, 0.165362,-99) , 
3, -0.423686, 0, 0, 0.261455,-99) , 
3, 0.131392, 0, 0, 0.500664,-99)    );
  // itree = 1967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.857944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427313,-99) , 
0, 0.233182, 1, 0, 0.622955,-99) , 
3, 0.96671, 0, 0, 0.763247,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301007,-99) , 
0, -0.200686, 1, 0, 0.478247,-99) , 
NN(
0, 
0, 
-1, -1.20998, 0, -1, 0.203811,-99) , 
3, -0.2022, 0, 0, 0.292455,-99) , 
3, 0.34753, 0, 0, 0.492801,-99)    );
  // itree = 1968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.83264, 0, 1, 0.805883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240089,-99) , 
0, 0.506819, 1, 0, 0.503873,-99) , 
3, 0.758758, 0, 0, 0.657284,-99) , 
NN(
0, 
0, 
-1, -0.617192, 0, -1, 0.217081,-99) , 
3, -0.128257, 0, 0, 0.478496,-99)    );
  // itree = 1969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3421, 0, 1, 0.852323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344871,-99) , 
0, 0.500484, 1, 0, 0.546788,-99) , 
3, 1.00695, 0, 0, 0.703183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284016,-99) , 
0, -0.79504, 1, 0, 0.447352,-99) , 
NN(
0, 
0, 
-1, -1.3765, 0, -1, 0.155723,-99) , 
3, -0.647965, 0, 0, 0.280494,-99) , 
3, 0.179643, 0, 0, 0.488007,-99)    );
  // itree = 1970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.975568, 1, 1, 0.788768,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219876,-99) , 
0, 0.196016, 1, 0, 0.482133,-99) , 
3, 0.628149, 0, 0, 0.638876,-99) , 
NN(
0, 
0, 
-1, -1.05418, 0, -1, 0.168108,-99) , 
3, -0.291428, 0, 0, 0.483044,-99)    );
  // itree = 1971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33417, 1, 1, 0.881296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397109,-99) , 
0, 0.0112647, 1, 0, 0.550343,-99) , 
3, 0.969687, 0, 0, 0.699951,-99) , 
NN(
0, 
0, 
-1, -0.641047, 0, -1, 0.247164,-99) , 
3, -0.145446, 0, 0, 0.51713,-99)    );
  // itree = 1972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.18743, 0, 1, 0.826704,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45677,-99) , 
0, -0.799767, 1, 0, 0.525727,-99) , 
3, 0.628149, 0, 0, 0.684909,-99) , 
NN(
0, 
0, 
-1, -1.55738, 0, -1, 0.191583,-99) , 
3, -0.291428, 0, 0, 0.509027,-99)    );
  // itree = 1973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.15947, 0, 1, 0.842229,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329171,-99) , 
0, -0.0638725, 1, 0, 0.491929,-99) , 
NN(
0, 
0, 
-1, -1.54084, 0, -1, 0.146541,-99) , 
3, -0.637503, 0, 0, 0.345998,-99) , 
3, 0.802004, 0, 0, 0.498913,-99)    );
  // itree = 1974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.1103, 0, 1, 0.824594,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177998,-99) , 
0, 0.66154, 1, 0, 0.435041,-99) , 
NN(
0, 
0, 
-1, -1.86425, 0, -1, 0.131247,-99) , 
3, -0.73814, 0, 0, 0.326079,-99) , 
3, 0.729578, 0, 0, 0.487845,-99)    );
  // itree = 1975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34735, 1, 1, 0.805277,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362107,-99) , 
0, -0.33857, 1, 0, 0.514886,-99) , 
3, 0.609259, 0, 0, 0.693523,-99) , 
NN(
0, 
0, 
-1, -1.07359, 0, -1, 0.24002,-99) , 
3, -0.0725463, 0, 0, 0.487565,-99)    );
  // itree = 1976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66649, 0, 1, 0.863206,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285016,-99) , 
0, 0.431079, 1, 0, 0.579062,-99) , 
3, 0.951449, 0, 0, 0.690337,-99) , 
NN(
0, 
0, 
-1, -1.69233, 0, -1, 0.142518,-99) , 
3, -0.547237, 0, 0, 0.536411,-99)    );
  // itree = 1977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.81561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.909359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352464,-99) , 
0, -0.108913, 1, 0, 0.524897,-99) , 
3, 0.610069, 0, 0, 0.695231,-99) , 
NN(
0, 
0, 
-1, -1.06796, 0, -1, 0.239749,-99) , 
3, -0.0725463, 0, 0, 0.504494,-99)    );
  // itree = 1978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65958, 0, 1, 0.811934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440578,-99) , 
0, 0.0304304, 1, 0, 0.579699,-99) , 
3, 0.949517, 0, 0, 0.687822,-99) , 
NN(
0, 
0, 
-1, -0.990191, 0, -1, 0.211753,-99) , 
3, -0.218528, 0, 0, 0.501284,-99)    );
  // itree = 1979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.876935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38642,-99) , 
0, 0.418073, 1, 0, 0.545745,-99) , 
3, 1.15905, 0, 0, 0.658553,-99) , 
NN(
0, 
0, 
-1, -0.958364, 0, -1, 0.196011,-99) , 
3, -0.206128, 0, 0, 0.456386,-99)    );
  // itree = 1980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.835046, 0, 1, 0.781066,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219473,-99) , 
0, -0.0748989, 1, 0, 0.458109,-99) , 
NN(
0, 
0, 
-1, -1.10802, 0, -1, 0.143886,-99) , 
3, -0.651582, 0, 0, 0.319258,-99) , 
3, 0.427177, 0, 0, 0.507698,-99)    );
  // itree = 1981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6881, 0, 1, 0.856791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428027,-99) , 
0, 0.262911, 1, 0, 0.56692,-99) , 
3, 1.18232, 0, 0, 0.668324,-99) , 
NN(
0, 
0, 
-1, -1.2441, 0, -1, 0.215299,-99) , 
3, -0.218528, 0, 0, 0.496651,-99)    );
  // itree = 1982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91102, 1, 1, 0.839025,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.905156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438347,-99) , 
0, 0.380951, 1, 0, 0.600132,-99) , 
3, 1.11291, 0, 0, 0.713439,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286913,-99) , 
0, -0.754887, 1, 0, 0.462314,-99) , 
NN(
0, 
0, 
-1, -1.7806, 0, -1, 0.156005,-99) , 
3, -0.584679, 0, 0, 0.292626,-99) , 
3, 0.27076, 0, 0, 0.485458,-99)    );
  // itree = 1983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8206, 1, 1, 0.891551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439435,-99) , 
0, 0.134764, 1, 0, 0.575761,-99) , 
3, 1.19351, 0, 0, 0.673983,-99) , 
NN(
0, 
0, 
-1, -1.56755, 0, -1, 0.196438,-99) , 
3, -0.345522, 0, 0, 0.512117,-99)    );
  // itree = 1984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.8911,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436438,-99) , 
0, 0.865651, 1, 0, 0.66495,-99) , 
3, 1.12707, 0, 0, 0.778758,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143427,-99) , 
0, -0.0031453, 1, 0, 0.380691,-99) , 
NN(
0, 
0, 
-1, -1.61795, 0, -1, 0.142511,-99) , 
3, -0.751014, 0, 0, 0.281956,-99) , 
3, 0.322617, 0, 0, 0.481391,-99)    );
  // itree = 1985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17505, 1, 1, 0.83774,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220481,-99) , 
0, 0.232439, 1, 0, 0.490148,-99) , 
NN(
0, 
0, 
-1, -1.18778, 0, -1, 0.174101,-99) , 
3, -0.451773, 0, 0, 0.344803,-99) , 
3, 0.760049, 0, 0, 0.506955,-99)    );
  // itree = 1986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54271, 1, 1, 0.888757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395844,-99) , 
0, 0.953018, 1, 0, 0.642436,-99) , 
3, 1.15583, 0, 0, 0.74468,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214919,-99) , 
0, -0.795814, 1, 0, 0.414098,-99) , 
NN(
0, 
0, 
-1, -1.6306, 0, -1, 0.191225,-99) , 
3, -0.695546, 0, 0, 0.300995,-99) , 
3, 0.131392, 0, 0, 0.518146,-99)    );
  // itree = 1987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.6518, 0, 1, 0.812227,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183864,-99) , 
0, 0.423428, 1, 0, 0.462102,-99) , 
NN(
0, 
0, 
-1, -1.61003, 0, -1, 0.173013,-99) , 
3, -0.43371, 0, 0, 0.34355,-99) , 
3, 0.742135, 0, 0, 0.495484,-99)    );
  // itree = 1988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.875449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341828,-99) , 
0, 0.985639, 1, 0, 0.630619,-99) , 
3, 1.07814, 0, 0, 0.750202,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217258,-99) , 
0, -0.615667, 1, 0, 0.373777,-99) , 
NN(
0, 
0, 
-1, -1.73714, 0, -1, 0.159947,-99) , 
3, -0.554775, 0, 0, 0.250431,-99) , 
3, 0.256412, 0, 0, 0.467397,-99)    );
  // itree = 1989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.835578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422625,-99) , 
0, 0.358951, 1, 0, 0.609533,-99) , 
3, 0.900389, 0, 0, 0.748013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187826,-99) , 
0, -0.150485, 1, 0, 0.383329,-99) , 
NN(
0, 
0, 
-1, -1.30237, 0, -1, 0.146012,-99) , 
3, -0.58167, 0, 0, 0.266463,-99) , 
3, 0.27076, 0, 0, 0.477812,-99)    );
  // itree = 1990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39628, 1, 1, 0.853979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371538,-99) , 
0, 0.683618, 1, 0, 0.581937,-99) , 
3, 0.924535, 0, 0, 0.742004,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313737,-99) , 
0, -0.843998, 1, 0, 0.422422,-99) , 
NN(
0, 
0, 
-1, -1.6258, 0, -1, 0.167158,-99) , 
3, -0.751014, 0, 0, 0.31317,-99) , 
3, 0.322617, 0, 0, 0.496889,-99)    );
  // itree = 1991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52555, 1, 1, 0.839156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316593,-99) , 
0, 1.13238, 1, 0, 0.621064,-99) , 
3, 1.16365, 0, 0, 0.717519,-99) , 
NN(
0, 
0, 
-1, -0.415137, 0, -1, 0.21941,-99) , 
3, 0.131392, 0, 0, 0.448661,-99)    );
  // itree = 1992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.0402, 1, 1, 0.833206,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193288,-99) , 
0, 0.295007, 1, 0, 0.522658,-99) , 
NN(
0, 
0, 
-1, -1.69229, 0, -1, 0.236279,-99) , 
3, -0.237221, 0, 0, 0.350739,-99) , 
3, 0.610343, 0, 0, 0.526112,-99)    );
  // itree = 1993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.814497, 0, 1, 0.785022,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201019,-99) , 
0, -0.0860574, 1, 0, 0.425628,-99) , 
NN(
0, 
0, 
-1, -1.58361, 0, -1, 0.174285,-99) , 
3, -0.417328, 0, 0, 0.287885,-99) , 
3, 0.402144, 0, 0, 0.487647,-99)    );
  // itree = 1994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.42867, 1, 1, 0.903055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350256,-99) , 
0, 1.16897, 1, 0, 0.654079,-99) , 
3, 1.49366, 0, 0, 0.738825,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259743,-99) , 
0, -0.325682, 1, 0, 0.492751,-99) , 
NN(
0, 
0, 
-1, -1.47939, 0, -1, 0.192617,-99) , 
3, -0.549382, 0, 0, 0.326453,-99) , 
3, 0.268003, 0, 0, 0.515631,-99)    );
  // itree = 1995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40732, 0, 1, 0.824574,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361313,-99) , 
0, 0.0975803, 1, 0, 0.546645,-99) , 
3, 0.885075, 0, 0, 0.663266,-99) , 
NN(
0, 
0, 
-1, -1.47084, 0, -1, 0.147175,-99) , 
3, -0.582913, 0, 0, 0.520634,-99)    );
  // itree = 1996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30924, 1, 1, 0.814775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345609,-99) , 
0, -0.0319407, 1, 0, 0.497331,-99) , 
3, 0.828185, 0, 0, 0.632745,-99) , 
NN(
0, 
0, 
-1, -1.07952, 0, -1, 0.195262,-99) , 
3, -0.316527, 0, 0, 0.477931,-99)    );
  // itree = 1997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.843253, 1, 1, 0.868879,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312097,-99) , 
0, -0.0700435, 1, 0, 0.476732,-99) , 
NN(
0, 
0, 
-1, -1.57763, 0, -1, 0.134333,-99) , 
3, -0.661336, 0, 0, 0.33838,-99) , 
3, 0.828289, 0, 0, 0.492118,-99)    );
  // itree = 1998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38751, 1, 1, 0.790984,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322432,-99) , 
0, -0.117022, 1, 0, 0.503619,-99) , 
3, 0.639192, 0, 0, 0.688051,-99) , 
NN(
0, 
0, 
-1, -1.52753, 0, -1, 0.241785,-99) , 
3, -0.0426953, 0, 0, 0.469778,-99)    );
  // itree = 1999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46354, 1, 1, 0.874877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323296,-99) , 
0, 0.40736, 1, 0, 0.537882,-99) , 
3, 1.08266, 0, 0, 0.670811,-99) , 
NN(
0, 
0, 
-1, -1.07034, 0, -1, 0.19692,-99) , 
3, -0.302053, 0, 0, 0.502391,-99)    );
   return;
};

// Clean up
inline void ReadBDTB::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTB::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
