// Class: ReadBDTG
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:08:59 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "2000" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTGNode

#ifndef BDTGNode__def
#define BDTGNode__def

class BDTGNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTGNode ( BDTGNode* left,BDTGNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTGNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTGNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTGNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTGNode*   fLeft;     // pointer to the left daughter node
   BDTGNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTGNode::~BDTGNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTGNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTGNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG : public IClassifierReader {

 public:

   // constructor
   ReadBDTG( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTGNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTG::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTGNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTGNode*)current->GetRight();
         else current=(BDTGNode*)current->GetLeft();
      }
      myMVA += current->GetResponse();
   }
   return 2.0/(1.0+exp(-2.0*myMVA))-1.0;
}

void ReadBDTG::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0222092,-0.0955582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306936,-0.0386129) , 
3, -1.49104, 1, 0, 0.250577,-0.249423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575884,0.0151768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884664,0.0769328) , 
3, 1.11248, 1, 0, 0.698358,0.198358) , 
3, -0.011497, 1, 0, 0.50232,0.0023201)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16726,-0.0608792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462764,-0.00533671) , 
3, -0.55608, 1, 0, 0.31005,-0.169519) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696771,0.0363761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.920489,0.0768728) , 
3, 1.48826, 1, 0, 0.768888,0.246221) , 
3, 0.268003, 1, 0, 0.523203,0.0236132)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135882,-0.0610992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306248,-0.0311107) , 
3, -1.05196, 1, 0, 0.218126,-0.229895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510566,0.000827837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.80864,0.0514874) , 
3, 0.628149, 1, 0, 0.67427,0.141279) , 
3, -0.291428, 1, 0, 0.491468,-0.00747121)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729331,-0.0687243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30007,-0.0305924) , 
3, -1.13085, 1, 0, 0.214053,-0.219176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601241,0.0164846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.860813,0.0565104) , 
3, 0.969023, 1, 0, 0.724798,0.173271) , 
3, -0.145446, 1, 0, 0.499192,-8.06984e-05)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252345,-0.0320772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13048,-0.0647522) , 
0, -0.67448, 1, 0, 0.214857,-0.204933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550535,0.0060188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793637,0.0405506) , 
3, 0.610069, 1, 0, 0.702411,0.132503) , 
3, -0.0725463, 1, 0, 0.486407,-0.0169935)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0395187,-0.0677203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206529,-0.0385471) , 
3, -1.53081, 1, 0, 0.151897,-0.223433) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.918451,0.091166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60784,0.00928285) , 
0, -0.857953, 1, 0, 0.642958,0.0905395) , 
3, -0.613987, 1, 0, 0.492878,-0.00541834)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366804,-0.0146378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106426,-0.0874565) , 
0, 0.879351, 1, 0, 0.335861,-0.113133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.938395,0.0684411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.771132,0.0292137) , 
0, 1.20125, 1, 0, 0.830837,0.202181) , 
3, 0.760049, 1, 0, 0.484196,-0.0186387)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285139,-0.0189858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0886656,-0.0611716) , 
1, 0.444551, 1, 0, 0.206316,-0.166087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.845124,0.0658454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643452,0.00769439) , 
0, 0.118462, 1, 0, 0.691994,0.105489) , 
3, -0.206128, 1, 0, 0.48135,-0.0122966)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264243,-0.0194123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0929166,-0.0636703) , 
0, -0.680245, 1, 0, 0.227032,-0.13404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.829937,0.0547072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695742,0.0175301) , 
0, 0.150891, 1, 0, 0.736283,0.137554) , 
3, -0.133228, 1, 0, 0.526601,0.0257265)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337205,-0.00827974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117709,-0.0681296) , 
0, -0.216251, 1, 0, 0.296159,-0.0917349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914178,0.05939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709884,0.0168804) , 
1, -0.711882, 1, 0, 0.756665,0.121743) , 
3, 0.262776, 1, 0, 0.516527,0.0104216)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246795,-0.0116383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0867995,-0.0532748) , 
0, -2.51925, 1, 0, 0.145927,-0.162711) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.769578,0.060142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59944,0.0010897) , 
0, -0.589361, 1, 0, 0.632148,0.0593419) , 
3, -0.783748, 1, 0, 0.521404,0.00876608)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664628,0.0412051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358268,-0.0205507) , 
1, -0.856528, 1, 0, 0.420164,-0.0366666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.801309,0.0280373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924383,0.0549721) , 
3, 1.61652, 1, 0, 0.867757,0.183347) , 
3, 1.14645, 1, 0, 0.528962,0.0168131)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578113,0.0239325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273807,-0.0291488) , 
1, -0.862599, 1, 0, 0.339292,-0.0797941) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.900504,0.0511768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776588,0.0192654) , 
0, 1.60157, 1, 0, 0.837949,0.151094) , 
3, 0.729578, 1, 0, 0.499277,-0.00571767)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200392,-0.0195315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0897073,-0.0499234) , 
0, -1.86312, 1, 0, 0.140324,-0.148126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65494,0.0293882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636668,0.00279362) , 
0, 0.109069, 1, 0, 0.642909,0.0562631) , 
3, -0.623168, 1, 0, 0.482753,-0.0088684)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302513,0.00333977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0825005,-0.0540113) , 
0, -1.46002, 1, 0, 0.206405,-0.0911007) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818481,0.0519872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663433,0.00959918) , 
0, -0.332287, 1, 0, 0.692387,0.0808267) , 
3, -0.430822, 1, 0, 0.537789,0.0261341)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4067,-0.00304408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129483,-0.0833056) , 
0, 0.936811, 1, 0, 0.384931,-0.0443677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.942245,0.0559787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786764,0.0184825) , 
0, 1.47799, 1, 0, 0.855943,0.143014) , 
3, 0.828289, 1, 0, 0.523255,0.0106613)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45741,0.0067823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258619,-0.0308604) , 
1, 0.382446, 1, 0, 0.36744,-0.0445386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.984323,0.0651865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.798086,0.0193111) , 
0, 1.17505, 1, 0, 0.867203,0.143302) , 
3, 0.712472, 1, 0, 0.526398,0.0152072)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368793,-0.00571238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227197,-0.0532401) , 
0, 0.35774, 1, 0, 0.340082,-0.0720606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.922982,0.0473252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760058,0.0101622) , 
0, 1.33417, 1, 0, 0.825098,0.0960219) , 
3, 0.760049, 1, 0, 0.485982,-0.021499)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.968201,0.0899442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726005,0.0337427) , 
1, -1.85974, 1, 0, 0.818096,0.241877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412452,-0.0156452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.889516,0.0379068) , 
3, 1.67591, 1, 0, 0.461219,-0.0455181) , 
1, -1.42554, 1, 0, 0.48776,-0.024144)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442884,-0.000724482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38253,-0.0484784) , 
0, 1.06108, 1, 0, 0.434965,-0.0311564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.955844,0.0542209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.844633,0.0235311) , 
2, 1.34988, 1, 0, 0.907855,0.150165) , 
3, 1.35152, 1, 0, 0.507212,-0.00345475)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423362,-0.00660089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218197,-0.0720945) , 
0, 1.37237, 1, 0, 0.406634,-0.0535326) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.900956,0.0377068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767853,0.00157345) , 
0, 3.15998, 1, 0, 0.875798,0.109371) , 
3, 1.21627, 1, 0, 0.501639,-0.0205451)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327731,-0.00757055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189075,-0.0495915) , 
0, -0.128307, 1, 0, 0.295657,-0.0787039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.756697,0.0190921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434661,-0.0570736) , 
1, 1.74144, 1, 0, 0.725962,0.0468477) , 
3, 0.34753, 1, 0, 0.492538,-0.0212594)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0354589,-0.0569971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19027,-0.0192833) , 
3, -1.30593, 1, 0, 0.120847,-0.134609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.896745,0.0754514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607794,0.00149103) , 
0, -0.857953, 1, 0, 0.634877,0.0392437) , 
3, -0.613987, 1, 0, 0.470064,-0.0164986)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266003,-0.0045161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203072,-0.034797) , 
0, -1.2894, 1, 0, 0.233685,-0.085367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.84575,0.0465049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682466,-0.00111394) , 
0, 0.634952, 1, 0, 0.73341,0.0600915) , 
3, 0.131392, 1, 0, 0.482969,-0.0128061)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273892,0.00495437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172965,-0.030395) , 
0, -2.02887, 1, 0, 0.201166,-0.0821075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.909547,0.0625519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662745,0.00462151) , 
0, -0.340073, 1, 0, 0.6885,0.0463804) , 
3, -0.218528, 1, 0, 0.489699,-0.00603433)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406878,-0.00272724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235635,-0.0292721) , 
1, 0.165974, 1, 0, 0.332589,-0.059034) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.922547,0.0434077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789109,0.00930141) , 
0, 1.38353, 1, 0, 0.844595,0.0822584) , 
3, 0.760049, 1, 0, 0.490665,-0.0154116)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359335,-0.00592633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0911835,-0.0679425) , 
0, 0.761008, 1, 0, 0.327497,-0.0589092) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.877926,0.0347319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794953,0.00455507) , 
2, 0.87215, 1, 0, 0.830636,0.0635233) , 
3, 0.783269, 1, 0, 0.474354,-0.0231734)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0247308,-0.059076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619129,0.0214315) , 
3, -1.77931, 1, 0, 0.580076,0.0667863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280679,-0.0277061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.894885,0.0288778) , 
3, 1.371, 1, 0, 0.375549,-0.0773204) , 
1, 0.400437, 1, 0, 0.501564,0.011468)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239566,-0.00988196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150401,-0.0437577) , 
0, -1.09789, 1, 0, 0.196246,-0.107305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.885271,0.052576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645352,-0.00271617) , 
0, -0.0264366, 1, 0, 0.685798,0.029022) , 
3, -0.0725463, 1, 0, 0.460724,-0.0336548)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363802,0.011593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24196,-0.0325574) , 
0, -0.752826, 1, 0, 0.313379,-0.0316373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.825046,0.0344141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672557,-0.00926617) , 
0, 1.45516, 1, 0, 0.756622,0.0590787) , 
3, 0.27076, 1, 0, 0.518348,0.0103125)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0380269,-0.0517887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160216,-0.0172327) , 
3, -1.56175, 1, 0, 0.0919982,-0.119598) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.786694,0.0904664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567696,-0.00089142) , 
0, -1.57862, 1, 0, 0.582436,0.0236741) , 
3, -1.15439, 1, 0, 0.516298,0.00435317)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197777,-0.0129277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0565931,-0.0452479) , 
1, -0.0733054, 1, 0, 0.107982,-0.10815) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.747197,0.074323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612133,-0.000376494) , 
2, -0.684032, 1, 0, 0.620666,0.0193325) , 
3, -0.707817, 1, 0, 0.477948,-0.0161556)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0622442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0698623,-0.0329188) , 
1, 0.0554896, 1, 0, 0.0314836,-0.145392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540727,0.0647958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53694,0.00030603) , 
0, -2.29957, 1, 0, 0.537097,0.0117426) , 
3, -1.5755, 1, 0, 0.48829,-0.0034257)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210234,-0.00346468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963036,0.0783165) , 
3, -0.585787, 1, 0, 0.413993,0.0863507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16856,-0.0375428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7087,0.00882273) , 
3, 0.070119, 1, 0, 0.552599,-0.0191127) , 
0, -0.701588, 1, 0, 0.506618,0.0158733)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.866342,0.0684492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558209,0.0108084) , 
1, -1.90479, 1, 0, 0.57917,0.0566588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355375,-0.0215345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885383,0.0246308) , 
3, 1.46854, 1, 0, 0.434481,-0.0573703) , 
1, 0.219717, 1, 0, 0.506288,-0.000779166)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0159721,-0.0544635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148271,-0.0185051) , 
3, -1.87942, 1, 0, 0.0955225,-0.0957114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538248,0.0198037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647922,-0.0120669) , 
0, 0.709069, 1, 0, 0.580684,0.0310472) , 
3, -1.25675, 1, 0, 0.510816,0.0127926)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44882,0.040173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605733,0.00873707) , 
0, -1.52253, 1, 0, 0.572246,0.0592484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199467,-0.0293143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761853,0.0106359) , 
3, 0.342372, 1, 0, 0.443333,-0.0437269) , 
1, -0.214065, 1, 0, 0.496279,-0.0014341)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560893,-0.00204124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681698,0.0266934) , 
1, -1.50773, 1, 0, 0.637877,0.0657624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319209,-0.0180279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819177,0.00884969) , 
3, 0.960119, 1, 0, 0.465564,-0.0423213) , 
1, -0.936379, 1, 0, 0.498008,-0.0219709)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.949928,0.0812377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464173,0.00915449) , 
1, -1.69867, 1, 0, 0.4837,0.0464738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171105,-0.051728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782818,-0.00123868) , 
3, 0.834257, 1, 0, 0.57279,-0.0828483) , 
0, 0.703678, 1, 0, 0.515002,0.00103562)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3543,0.000464614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536333,-0.0263212) , 
2, 0.343884, 1, 0, 0.403561,-0.0275314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.871328,0.0174333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.949745,0.046058) , 
3, 2.06896, 1, 0, 0.903475,0.0889047) , 
3, 1.24934, 1, 0, 0.499144,-0.00526883)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797599,-0.033161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0111193,-0.0571704) , 
0, -2.41213, 1, 0, 0.0423833,-0.128443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59343,0.0103515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291613,-0.0497916) , 
1, 1.61612, 1, 0, 0.569611,0.0210766) , 
3, -1.19711, 1, 0, 0.485412,-0.00280194)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174298,-0.00200013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645336,0.0576552) , 
3, -1.20355, 1, 0, 0.328386,0.0771161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30798,-0.0192675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764651,0.0105649) , 
3, 0.353784, 1, 0, 0.544349,-0.0182954) , 
0, -1.40205, 1, 0, 0.498954,0.00175971)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223282,-0.0173652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915623,0.0520831) , 
3, -0.747551, 1, 0, 0.717785,0.11411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337638,-0.0084967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.847028,0.0172973) , 
3, 0.760049, 1, 0, 0.496274,-0.00561123) , 
1, -1.12744, 1, 0, 0.523503,0.00910503)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338463,-0.0100712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160925,-0.0561121) , 
0, 0.476343, 1, 0, 0.307611,-0.0738417) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.936608,0.0396856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.783966,-0.00563445) , 
0, 1.52555, 1, 0, 0.85811,0.0459308) , 
3, 0.828289, 1, 0, 0.45334,-0.0421354)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247877,-0.00555778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75861,0.0237069) , 
3, -0.139853, 1, 0, 0.41096,0.0178211) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336314,-0.0378715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874469,0.0165894) , 
3, 1.15515, 1, 0, 0.60124,-0.0579411) , 
0, 0.394028, 1, 0, 0.488956,-0.013234)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204406,-0.048596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.840713,0.0250145) , 
3, -0.00126982, 1, 0, 0.472778,-0.0834804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403723,0.0160353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583235,-0.0111558) , 
0, 0.18515, 1, 0, 0.488283,0.0105463) , 
1, -0.936379, 1, 0, 0.485145,-0.0084845)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3229,0.023946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0898551,-0.0299864) , 
1, -0.684744, 1, 0, 0.135488,-0.0505146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.900267,0.0876967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633509,0.00834917) , 
0, -1.56728, 1, 0, 0.644484,0.0450381) , 
3, -0.886812, 1, 0, 0.535209,0.0245242)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117729,-0.0141617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0314565,-0.0510274) , 
0, -2.39294, 1, 0, 0.0760267,-0.0875664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532423,0.0207257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65876,-0.00779019) , 
0, 0.397815, 1, 0, 0.59253,0.0296349) , 
3, -1.27729, 1, 0, 0.522997,0.0138572)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413646,-0.0106159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3841,-0.0680559) , 
0, 1.54481, 1, 0, 0.410582,-0.0593152) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.992909,0.0571831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.904568,0.0268424) , 
0, 2.23883, 1, 0, 0.932996,0.100767) , 
3, 1.85198, 1, 0, 0.452213,-0.0465582)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432249,-0.00111197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424174,-0.0430931) , 
0, 1.64635, 1, 0, 0.431599,-0.0171909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.982899,0.0535073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841139,0.00247518) , 
0, 2.72583, 1, 0, 0.92829,0.0900893) , 
3, 1.67591, 1, 0, 0.487071,-0.00520959)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316941,-0.00133426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87104,0.0394516) , 
3, -0.40554, 1, 0, 0.69377,0.0870262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30138,0.00981382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530283,-0.0145194) , 
2, -0.486121, 1, 0, 0.448555,-0.0238239) , 
1, -0.796883, 1, 0, 0.493848,-0.00334913)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365318,0.00228863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44954,-0.0267483) , 
2, 0.412398, 1, 0, 0.384395,-0.0182297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.933484,0.038911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.80625,-0.00851321) , 
0, 2.87239, 1, 0, 0.910023,0.0856067) , 
3, 1.13099, 1, 0, 0.500187,0.00464473)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0570465,-0.0353611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534446,0.050104) , 
3, -1.45668, 1, 0, 0.32676,0.0672671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318934,-0.0164994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764231,0.00855652) , 
3, 0.353784, 1, 0, 0.565795,-0.0139371) , 
0, -1.2181, 1, 0, 0.506858,0.00608484)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015778,-0.0500314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548324,0.013824) , 
3, -1.66573, 1, 0, 0.506238,0.0380756) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553113,-0.0485674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.958646,0.0422024) , 
3, 2.31504, 1, 0, 0.667893,-0.0830512) , 
0, 1.80911, 1, 0, 0.530807,0.0196663)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351047,0.00252276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128623,-0.0416964) , 
0, -0.160365, 1, 0, 0.288346,-0.0376032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.837763,0.0329927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758885,-0.00153937) , 
2, 0.414676, 1, 0, 0.778967,0.0272988) , 
3, 0.34765, 1, 0, 0.49777,-0.00989938)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.695066,0.0479494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721666,0.00144669) , 
2, 0.183117, 1, 0, 0.7118,0.0702673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3805,-0.0133885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.928628,0.031532) , 
3, 1.73863, 1, 0, 0.440055,-0.0337295) , 
1, -0.89377, 1, 0, 0.488489,-0.0151937)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255681,0.0264344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285315,-0.0212901) , 
2, -1.08181, 1, 0, 0.277866,-0.0425961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.899161,0.0432508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700173,0.000506032) , 
0, 0.118462, 1, 0, 0.731964,0.0251309) , 
3, 0.179643, 1, 0, 0.483682,-0.0118994)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283255,-0.0050424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769311,0.0281857) , 
3, -0.0223503, 1, 0, 0.456189,0.0258423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177084,-0.0561997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.839493,0.00690053) , 
3, 1.10386, 1, 0, 0.617246,-0.0620441) , 
0, 0.967715, 1, 0, 0.500867,0.00146191)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212628,0.0186809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172813,-0.0254219) , 
0, -2.76961, 1, 0, 0.179229,-0.0665529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.884827,0.0574054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667114,0.000627623) , 
0, 0.0922856, 1, 0, 0.723759,0.0611963) , 
3, -0.291428, 1, 0, 0.519933,0.0133779)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399026,-0.000697661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245329,-0.0308364) , 
0, 0.19995, 1, 0, 0.361421,-0.0324976) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.970927,0.0505617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758985,-0.00505871) , 
0, 1.17505, 1, 0, 0.837103,0.0388401) , 
3, 0.761018, 1, 0, 0.499834,-0.0117399)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178157,-0.0072291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.936995,0.0711166) , 
3, -0.685839, 1, 0, 0.318664,0.034238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234314,-0.0324551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742022,-0.000223845) , 
3, 0.329683, 1, 0, 0.514836,-0.0552476) , 
0, -1.06144, 1, 0, 0.460854,-0.0306232)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.707704,0.0502678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397639,0.00836385) , 
1, -1.02153, 1, 0, 0.432961,0.0470035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518136,-0.0248695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886411,0.0161494) , 
3, 1.28767, 1, 0, 0.689195,-0.0289275) , 
2, 0.456587, 1, 0, 0.518419,0.0216795)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146681,-0.0314168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341065,-0.00794562) , 
2, -0.391925, 1, 0, 0.201919,-0.0775282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.900958,0.0420322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661962,-0.00234161) , 
0, -0.215492, 1, 0, 0.696142,0.0136266) , 
3, -0.0447319, 1, 0, 0.463928,-0.029203)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0942132,-0.0227016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625362,0.0094906) , 
3, -0.988495, 1, 0, 0.511814,0.0143582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30651,-0.116978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950913,0.037975) , 
3, 2.16337, 1, 0, 0.675885,-0.125043) , 
0, 2.29217, 1, 0, 0.527897,0.000693255)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120394,-0.0169391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5874,0.0202762) , 
3, -0.858415, 1, 0, 0.397718,0.0267968) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434885,-0.0374421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.873133,0.0122667) , 
3, 1.24398, 1, 0, 0.651564,-0.0548292) , 
2, 0.45817, 1, 0, 0.49369,-0.00406378)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.04807,-0.0333393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522633,0.0812428) , 
3, -1.87936, 1, 0, 0.310934,0.120845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390602,0.0464932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529898,-0.00653254) , 
2, -1.22721, 1, 0, 0.521639,-0.0122328) , 
0, -2.33718, 1, 0, 0.501988,0.000178676)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0565267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517129,0.0110505) , 
3, -1.71813, 1, 0, 0.484431,0.0312692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515515,-0.0519464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.883027,0.00801551) , 
3, 1.5683, 1, 0, 0.714852,-0.0716701) , 
2, 1.0535, 1, 0, 0.516978,0.0167291)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.953656,0.0658508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688315,0.0374961) , 
1, -1.7196, 1, 0, 0.827203,0.176939) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18433,-0.0238476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69577,0.00513706) , 
3, -0.0447319, 1, 0, 0.460736,-0.0248088) , 
1, -1.43208, 1, 0, 0.485487,-0.0111827)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0212193,-0.0407003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468849,0.0622171) , 
3, -1.93084, 1, 0, 0.249524,0.0736006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262514,-0.0206932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69877,0.00092894) , 
3, 0.122404, 1, 0, 0.496319,-0.0324474) , 
0, -2.33718, 1, 0, 0.472164,-0.0220679)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390508,0.00696898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192491,-0.0258241) , 
1, 0.498496, 1, 0, 0.314697,-0.0169446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82319,0.0297625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695643,0.0017793) , 
0, 0.660347, 1, 0, 0.740171,0.0389347) , 
3, 0.226002, 1, 0, 0.523464,0.0104736)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565435,0.00634264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438437,-0.0127035) , 
1, 0.00659387, 1, 0, 0.502713,-0.00880602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238201,-0.0775006) , 
1, 2.0818, 1, 0, 0.490057,-0.0201083)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526661,0.0109034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679746,-0.02725) , 
2, 1.15837, 1, 0, 0.55299,0.0188093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272856,0.0662665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445848,-0.0171034) , 
2, -1.32053, 1, 0, 0.431248,-0.0394137) , 
1, 0.213586, 1, 0, 0.495784,-0.00854946)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274626,-0.00386618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123936,-0.0428112) , 
0, -0.768985, 1, 0, 0.238111,-0.0461565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.755733,0.022878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656399,-0.0134708) , 
0, 1.12768, 1, 0, 0.713829,0.0276262) , 
3, -0.0725463, 1, 0, 0.496907,-0.00601796)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404919,-0.00777137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901554,0.0196048) , 
3, 1.371, 1, 0, 0.500072,-0.0129367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561222,0.0548917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45449,0.0241233) , 
1, 2.01704, 1, 0, 0.512031,0.110957) , 
1, 1.47355, 1, 0, 0.501075,-0.00253769)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384071,0.0164212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653622,-0.00449081) , 
2, 0.0734536, 1, 0, 0.534204,0.0158358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327752,-0.0211128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.909947,0.0204522) , 
3, 1.41801, 1, 0, 0.413177,-0.0536736) , 
1, 0.0705562, 1, 0, 0.470903,-0.0205199)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280851,0.0141135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43774,-0.0117729) , 
0, -1.38894, 1, 0, 0.396605,-0.0206084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.947318,0.0375389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.798427,-0.0117875) , 
0, 2.581, 1, 0, 0.901717,0.0502766) , 
3, 1.24934, 1, 0, 0.498783,-0.00626924)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566274,0.00391481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421073,-0.0146856) , 
1, -0.0609573, 1, 0, 0.484097,-0.0209878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281767,-0.0581904) , 
1, 2.30555, 1, 0, 0.477419,-0.0271016)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.894516,0.0551032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465165,0.00203466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.665174,-0.0224022) , 
0, 1.93176, 1, 0, 0.493468,-0.00382241) , 
1, -1.90873, 1, 0, 0.506262,0.00190674)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526201,-0.0311149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632482,0.0236553) , 
1, -1.50478, 1, 0, 0.611388,0.0394609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298579,0.0760406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399796,-0.0128346) , 
0, -2.72589, 1, 0, 0.392549,-0.0261789) , 
1, 0.0567207, 1, 0, 0.495794,0.0047889)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536962,0.0105349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293945,-0.0539528) , 
1, 1.91964, 1, 0, 0.526636,0.0254765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640436,-0.0656962) , 
0, 2.82704, 1, 0, 0.530908,0.0175987)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.083777,-0.0240064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0872395,-0.039448) , 
2, -1.24769, 1, 0, 0.0851858,-0.0755935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423031,-0.00461488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.892664,0.0239753) , 
3, 1.04136, 1, 0, 0.551793,0.0047593) , 
3, -1.19711, 1, 0, 0.488576,-0.00612709)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274396,0.011987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302335,-0.0295653) , 
0, -1.24356, 1, 0, 0.291988,-0.0573152) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.892088,0.0357759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763298,-0.0123904) , 
2, 1.0467, 1, 0, 0.839879,0.0447129) , 
3, 0.668022, 1, 0, 0.471101,-0.0239608)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0271442,-0.0417273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0580271) , 
3, -2.14828, 1, 0, 0.0124974,-0.0962651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539347,0.049267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539936,-0.0017477) , 
0, -1.96608, 1, 0, 0.53988,0.0128716) , 
3, -1.5755, 1, 0, 0.497152,0.0040294)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18483,-0.00306849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190118,-0.0364315) , 
2, -0.650284, 1, 0, 0.187013,-0.0604947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.762354,0.0253608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579289,-0.0191447) , 
0, 0.999022, 1, 0, 0.674989,0.0182819) , 
3, -0.0725463, 1, 0, 0.461536,-0.0161769)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144947,0.00891768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0556372,-0.0482614) , 
2, -1.18619, 1, 0, 0.1122,-0.0357323) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610995,0.0207055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655762,-0.0113211) , 
0, 1.57056, 1, 0, 0.621162,0.0475099) , 
3, -1.09475, 1, 0, 0.523509,0.0315385)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194403,-0.00221274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725837,0.0275163) , 
3, -0.469961, 1, 0, 0.446713,0.0421414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106404,-0.0453879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786822,0.006856) , 
3, 0.608081, 1, 0, 0.602032,-0.0259449) , 
0, 0.411997, 1, 0, 0.513639,0.0128032)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29811,0.0412213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466904,0.000667038) , 
2, -0.986742, 1, 0, 0.431752,0.0242845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418083,-0.0322901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924667,0.0272704) , 
3, 1.68647, 1, 0, 0.609368,-0.0470597) , 
0, 0.978749, 1, 0, 0.485018,0.00288873)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0383447,-0.044388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0268088,-0.0448309) , 
1, 0.336366, 1, 0, 0.0315555,-0.090475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456126,0.0648501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600639,0.0123302) , 
0, -2.38379, 1, 0, 0.591547,0.0484287) , 
2, -1.74543, 1, 0, 0.554937,0.0393477)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261619,-0.0101285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789784,0.0246402) , 
3, -0.548645, 1, 0, 0.646705,0.0456406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413292,-0.0143494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501729,0.0222533) , 
1, 1.20003, 1, 0, 0.428807,-0.025004) , 
1, -0.743609, 1, 0, 0.476989,-0.00938314)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213964,-0.00205363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70944,0.0192233) , 
3, -0.382298, 1, 0, 0.490611,0.0334363) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383777,-0.0333068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.910568,0.0194177) , 
3, 1.63433, 1, 0, 0.647932,-0.0404284) , 
0, 1.12677, 1, 0, 0.5267,0.016492)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298402,-0.0417212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72749,-0.0162902) , 
3, 0.240362, 1, 0, 0.472632,-0.113144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.849322,0.0526924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47507,-0.00146833) , 
1, -1.23551, 1, 0, 0.49155,0.00189186) , 
1, -1.52075, 1, 0, 0.489981,-0.00764882)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0559082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47393,0.00451622) , 
3, -1.70041, 1, 0, 0.433152,0.00570737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474153,-0.0398086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.856534,-0.000107533) , 
3, 1.24614, 1, 0, 0.716356,-0.0561049) , 
2, 0.955853, 1, 0, 0.485576,-0.00573493)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290803,0.00161761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278418,-0.021539) , 
0, -0.744297, 1, 0, 0.285734,-0.028135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.91472,0.0437137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705481,-0.00414632) , 
0, 0.937083, 1, 0, 0.789194,0.0437887) , 
3, 0.34753, 1, 0, 0.49008,0.00105757)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322339,-0.00257054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170137,-0.0291693) , 
1, 0.431359, 1, 0, 0.25912,-0.041745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.747864,0.0151942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688789,-0.0298025) , 
0, 2.22397, 1, 0, 0.736433,0.0196923) , 
3, 0.179643, 1, 0, 0.471573,-0.014399)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312928,-0.00175436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78129,0.0137155) , 
3, 0.34753, 1, 0, 0.518407,0.0144909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364716,-0.0729422) , 
1, 2.11264, 1, 0, 0.514473,0.00808252)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208931,0.0294145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0905317,-0.0383141) , 
2, -1.32073, 1, 0, 0.130509,-0.0496215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654078,0.0680237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636131,0.00587616) , 
2, -0.667433, 1, 0, 0.637403,0.0334185) , 
3, -0.796906, 1, 0, 0.501842,0.0112108)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437102,0.0156043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630225,-0.00873686) , 
0, 0.0835435, 1, 0, 0.532954,0.010821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395563,-0.0765845) , 
1, 2.16737, 1, 0, 0.52927,0.00312296)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277468,0.0203523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190228,-0.0208595) , 
0, -1.99189, 1, 0, 0.217594,-0.0267128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735704,0.0158846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604782,-0.0222129) , 
1, 1.06105, 1, 0, 0.715111,0.0289974) , 
3, -0.115595, 1, 0, 0.501278,0.00505311)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175246,-0.0142263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0412001,-0.0428204) , 
0, -1.9253, 1, 0, 0.1125,-0.0685013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577689,0.0311086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629438,-0.00523761) , 
2, -0.433909, 1, 0, 0.622624,-2.16179e-05) , 
3, -0.707817, 1, 0, 0.467184,-0.020888)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435815,-0.00760067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931983,0.0246416) , 
3, 1.78981, 1, 0, 0.488135,-0.0155071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123524,-0.06798) , 
1, 1.91156, 1, 0, 0.475815,-0.0233073)    );
  // itree = 100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0275734,-0.0456308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0667679) , 
1, 1.02491, 1, 0, 0.0167386,-0.119483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520585,0.00354731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658904,-0.0502033) , 
0, 3.07515, 1, 0, 0.524869,0.0059128) , 
2, -1.69625, 1, 0, 0.492638,-0.00204096)    );
  // itree = 101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147833,-0.00204525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673449,0.0511827) , 
3, -1.20657, 1, 0, 0.33625,0.0635869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368459,-0.0143444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.829498,0.0120747) , 
3, 0.641823, 1, 0, 0.568123,-0.0138343) , 
0, -1.24835, 1, 0, 0.513437,0.00442519)    );
  // itree = 102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35841,0.0423914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50803,-0.00448595) , 
0, -2.58982, 1, 0, 0.498208,-0.00573689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685769,0.0798882) , 
1, 2.04984, 1, 0, 0.503905,0.0017651)    );
  // itree = 103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696416,0.0326607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537296,0.00582553) , 
1, -1.27362, 1, 0, 0.572047,0.0346978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488124,-0.00340487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235629,-0.0656066) , 
1, 2.21733, 1, 0, 0.473315,-0.0227437) , 
1, -0.0789854, 1, 0, 0.51598,0.00207859)    );
  // itree = 104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233881,-0.00676279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116741,-0.0487305) , 
2, 0.0660878, 1, 0, 0.215028,-0.0425472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673082,0.0281599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752549,0.000891089) , 
2, 0.402379, 1, 0, 0.722727,0.035159) , 
3, -0.0447319, 1, 0, 0.48463,-0.00128308)    );
  // itree = 105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0152992,-0.0523681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135496,-0.000203887) , 
2, -1.54094, 1, 0, 0.0790422,-0.0464015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719789,0.0543713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590507,0.00586681) , 
0, -1.72275, 1, 0, 0.597012,0.0277515) , 
3, -1.17493, 1, 0, 0.524573,0.017381)    );
  // itree = 106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.846168,0.0901166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.845457,0.0336658) , 
2, -0.0586166, 1, 0, 0.845666,0.161798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375978,-0.00297577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901098,0.021738) , 
3, 1.14303, 1, 0, 0.493855,0.00429786) , 
1, -1.36363, 1, 0, 0.525617,0.0185169)    );
  // itree = 107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366073,0.0384168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497523,0.00765496) , 
2, -0.484242, 1, 0, 0.418959,0.0719703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576929,-0.0129695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.934854,0.0239943) , 
3, 1.70178, 1, 0, 0.657714,-0.023191) , 
2, 0.0207206, 1, 0, 0.550382,0.0195888)    );
  // itree = 108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0846158,-0.022726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513983,0.00432287) , 
3, -1.20915, 1, 0, 0.429076,0.00231325) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584429,-0.0405524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.889603,0.00783452) , 
3, 1.5974, 1, 0, 0.712449,-0.0652561) , 
2, 0.903798, 1, 0, 0.478522,-0.0094771)    );
  // itree = 109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126505,-0.0104563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455334,0.0427361) , 
3, -1.03535, 1, 0, 0.257007,0.0426718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239286,-0.0270121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682265,-0.00450518) , 
3, -0.0632207, 1, 0, 0.526358,-0.0407085) , 
2, -0.86672, 1, 0, 0.462868,-0.0210546)    );
  // itree = 110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223041,-0.00249155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101862,-0.0371374) , 
0, -1.51612, 1, 0, 0.164564,-0.0524995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.80661,0.0238488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648178,-0.00600622) , 
0, -0.228024, 1, 0, 0.680575,0.000711737) , 
3, -0.260982, 1, 0, 0.459549,-0.0220805)    );
  // itree = 111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362721,0.0196287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557808,-0.0012879) , 
0, -1.06144, 1, 0, 0.505562,0.0108487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118877,-0.0436115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668069,-0.000864297) , 
2, -0.219042, 1, 0, 0.332275,-0.0799605) , 
1, 1.41463, 1, 0, 0.488911,0.00212269)    );
  // itree = 112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276797,-0.0524123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755202,-0.000138582) , 
3, 0.240362, 1, 0, 0.473741,-0.0926133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.499668,0.0161692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706909,-0.0124129) , 
0, 1.37578, 1, 0, 0.542656,0.0303733) , 
1, -1.67887, 1, 0, 0.53801,0.0220811)    );
  // itree = 113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287967,-0.0097366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759323,0.00987008) , 
3, 0.163853, 1, 0, 0.514409,-0.00215996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292356,-0.0261829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233266,-0.0581903) , 
1, 2.19573, 1, 0, 0.268363,-0.130286) , 
1, 1.61612, 1, 0, 0.498488,-0.0104508)    );
  // itree = 114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538614,0.0285455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72356,-0.00999415) , 
2, 0.602281, 1, 0, 0.615051,0.0398427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489619,0.0287272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4037,-0.0186168) , 
1, 0.364348, 1, 0, 0.414669,-0.0373017) , 
1, 0.212582, 1, 0, 0.513976,0.000930137)    );
  // itree = 115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496995,0.0241288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529648,-0.0194655) , 
0, -1.4626, 1, 0, 0.523881,-0.0390463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553691,0.0167151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443911,-0.00357939) , 
1, 0.478309, 1, 0, 0.492381,0.0159027) , 
1, -0.287368, 1, 0, 0.504291,-0.00487317)    );
  // itree = 116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493888,-0.00976579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458317,0.0221991) , 
1, 1.09108, 1, 0, 0.488367,-0.0152889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343999,-0.0409765) , 
1, 2.11264, 1, 0, 0.482799,-0.0203135)    );
  // itree = 117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53797,0.000220815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427715,-0.0156128) , 
1, 0.455302, 1, 0, 0.507929,-0.0122009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551118,0.0854377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770943,0.0336802) , 
0, -0.247245, 1, 0, 0.670211,0.168251) , 
1, 1.25083, 1, 0, 0.52443,0.00614724)    );
  // itree = 118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57882,0.0230034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745983,-0.0104379) , 
0, 1.17659, 1, 0, 0.616958,0.0490132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46218,-0.00141853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400775,-0.0343388) , 
1, 2.25749, 1, 0, 0.459441,-0.00987919) , 
1, -0.148457, 1, 0, 0.522763,0.0137957)    );
  // itree = 119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.046294,-0.0553501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316768,0.0232379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514544,-0.00984421) , 
0, -2.06629, 1, 0, 0.49464,-0.0202616) , 
0, -3.10874, 1, 0, 0.475569,-0.0257148)    );
  // itree = 120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279191,0.0184491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527568,-0.00470643) , 
2, -1.24589, 1, 0, 0.495918,-0.00641923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249976,-0.0509729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396672,-0.00228032) , 
1, 1.83524, 1, 0, 0.301425,-0.108694) , 
1, 1.47355, 1, 0, 0.47937,-0.0151208)    );
  // itree = 121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412045,-0.0290286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370856,-0.0044871) , 
1, -0.936379, 1, 0, 0.378039,-0.0292446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.918741,0.0519294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637436,0.00183701) , 
1, -1.09102, 1, 0, 0.679616,0.0254503) , 
0, 0.664402, 1, 0, 0.479934,-0.0107647)    );
  // itree = 122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237113,-0.00269192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108259,-0.0310374) , 
0, -1.94633, 1, 0, 0.157701,-0.0518632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.750219,0.0300422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613519,-0.00474577) , 
0, -0.176655, 1, 0, 0.643246,0.0112199) , 
3, -0.454765, 1, 0, 0.478759,-0.0101505)    );
  // itree = 123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218679,-0.0253251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225996,0.0322458) , 
1, 0.993633, 1, 0, 0.220164,-0.0488514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.895414,0.0413869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649509,-0.00603114) , 
0, 0.237923, 1, 0, 0.704428,0.0133949) , 
3, -0.0725463, 1, 0, 0.491374,-0.0139906)    );
  // itree = 124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41225,0.0028385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336139,-0.0245492) , 
0, 0.761008, 1, 0, 0.398932,-0.00839833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.954385,0.0422293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81103,0.00132683) , 
0, 2.25165, 1, 0, 0.900096,0.0592602) , 
3, 1.14303, 1, 0, 0.514507,0.00720459)    );
  // itree = 125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.760595,0.0461023) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488399,-0.00199789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634707,-0.0567649) , 
0, 2.63718, 1, 0, 0.493808,-0.0117794) , 
1, -1.87835, 1, 0, 0.503192,-0.00623469)    );
  // itree = 126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0510754,-0.0480472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137708,0.0208542) , 
1, 0.225939, 1, 0, 0.090002,-0.0529313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.754862,0.0497053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601998,0.00883739) , 
0, -1.25109, 1, 0, 0.614441,0.0391809) , 
3, -1.08157, 1, 0, 0.520412,0.0226658)    );
  // itree = 127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316082,0.0397578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298928,-0.0148768) , 
0, -2.69999, 1, 0, 0.300902,-0.0315095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.923132,0.0625915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746772,0.0038377) , 
2, 0.368394, 1, 0, 0.78919,0.0490018) , 
3, 0.34753, 1, 0, 0.499413,0.00122189)    );
  // itree = 128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32399,-0.00591601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208199,-0.0245547) , 
0, 0.0974904, 1, 0, 0.300824,-0.0317745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616979,-0.0214586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81262,0.0179376) , 
2, 0.151609, 1, 0, 0.789926,0.0350524) , 
3, 0.402144, 1, 0, 0.480756,-0.00719014)    );
  // itree = 129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864415,0.0685371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660928,-0.00131575) , 
1, -2.26102, 1, 0, 0.718067,0.0584234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469505,-0.0266853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474529,0.00218741) , 
1, -0.490713, 1, 0, 0.47335,-0.0149333) , 
1, -1.39642, 1, 0, 0.497834,-0.00759403)    );
  // itree = 130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164385,-0.0261282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322259,0.00469715) , 
2, -0.337189, 1, 0, 0.204694,-0.0489202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.927304,0.044934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703164,0.00383422) , 
1, -0.767613, 1, 0, 0.756538,0.0372567) , 
3, 0.0391675, 1, 0, 0.486704,-0.00488093)    );
  // itree = 131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344488,-0.00752546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207311,-0.036289) , 
0, 0.379498, 1, 0, 0.323483,-0.0375869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.824142,-0.035386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851288,0.02167) , 
1, -0.787804, 1, 0, 0.846477,0.0373522) , 
3, 0.760049, 1, 0, 0.487122,-0.0141393)    );
  // itree = 132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625578,-0.0136432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540049,-0.0415242) , 
3, -1.83075, 1, 0, 0.0565836,-0.0736669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584102,0.00908413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625991,-0.027443) , 
0, 1.85297, 1, 0, 0.590976,0.0110793) , 
3, -1.19711, 1, 0, 0.504814,-0.00258457)    );
  // itree = 133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4955,0.0101035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723726,-0.0179909) , 
2, 1.03977, 1, 0, 0.538508,0.0142785) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278089,-0.0414569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418872,-0.00660322) , 
1, 1.11281, 1, 0, 0.369737,-0.0560817) , 
1, 0.888644, 1, 0, 0.499141,-0.00213368)    );
  // itree = 134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.60499,0.0218676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74459,-0.0368144) , 
2, 1.34498, 1, 0, 0.619393,0.0502224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33246,0.0145445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570712,-0.00840634) , 
0, -0.82394, 1, 0, 0.48733,-0.00413849) , 
1, -0.237385, 1, 0, 0.541818,0.0182903)    );
  // itree = 135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360921,0.0814924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508541,-0.0139597) , 
2, -1.26409, 1, 0, 0.496384,-0.0225356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552738,0.0210649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309408,-0.0176621) , 
1, 1.5652, 1, 0, 0.519933,0.0426846) , 
1, -0.417903, 1, 0, 0.512071,0.0209094)    );
  // itree = 136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281382,0.00178203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719914,0.026562) , 
2, -0.349659, 1, 0, 0.498559,0.0410459) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467921,-0.0234334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.810907,0.0111416) , 
2, 0.772527, 1, 0, 0.676242,-0.00900539) , 
0, 1.12719, 1, 0, 0.546619,0.0275079)    );
  // itree = 137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312522,-0.00830631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168844,-0.0432834) , 
1, 1.55309, 1, 0, 0.294615,-0.036655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.800266,0.0369297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686681,-0.000410062) , 
0, 0.109069, 1, 0, 0.709011,0.0194971) , 
2, 0.0164094, 1, 0, 0.492277,-0.00987104)    );
  // itree = 138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376882,-0.0576161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568398,-0.0384728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572099,0.00852095) , 
2, -1.70712, 1, 0, 0.534806,0.0172748) , 
1, -2.06979, 1, 0, 0.528995,0.0101675)    );
  // itree = 139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115616,-0.0145698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501436,0.0902213) , 
2, -1.58845, 1, 0, 0.254687,0.076238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293334,-0.0250829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707718,0.00185704) , 
2, -0.218546, 1, 0, 0.564709,-0.0227131) , 
2, -1.21466, 1, 0, 0.524634,-0.00992205)    );
  // itree = 140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636819,0.0466436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2816,-0.00812254) , 
1, -0.826718, 1, 0, 0.329498,-0.00133529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567682,-0.02422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902089,0.0157035) , 
3, 1.52602, 1, 0, 0.655443,-0.0459317) , 
2, -0.00680894, 1, 0, 0.494136,-0.0238614)    );
  // itree = 141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335805,0.0140243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163907,-0.0346668) , 
1, 0.403857, 1, 0, 0.242461,-0.0314068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588178,0.0247571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641946,-0.00108266) , 
0, -0.550486, 1, 0, 0.629208,0.0147057) , 
2, -0.55359, 1, 0, 0.505901,3.60026e-06)    );
  // itree = 142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15794,-0.0443467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.837083,0.0107144) , 
3, -0.104648, 1, 0, 0.4559,-0.0889761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506881,0.00700686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429794,-0.036807) , 
1, 2.1862, 1, 0, 0.504495,0.0144647) , 
1, -1.52075, 1, 0, 0.500583,0.00613716)    );
  // itree = 143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0974136,-0.021294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463748,0.0144992) , 
3, -1.22778, 1, 0, 0.364262,0.0210326) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445072,-0.0243653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.856545,0.00776854) , 
3, 0.846061, 1, 0, 0.645986,-0.030199) , 
2, 0.0721134, 1, 0, 0.503907,-0.0043618)    );
  // itree = 144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0520402,-0.0226312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733198,0.0747018) , 
3, -1.39364, 1, 0, 0.292079,0.0852728) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324645,-0.022506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793533,0.00256293) , 
3, 0.551716, 1, 0, 0.500944,-0.0423204) , 
2, -1.21466, 1, 0, 0.482302,-0.0309317)    );
  // itree = 145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259072,-0.0178391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299207,0.0281873) , 
1, 1.14512, 1, 0, 0.264956,-0.0336191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.843062,0.0193566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704301,-0.00723478) , 
1, 0.107382, 1, 0, 0.77153,0.0144456) , 
3, 0.268003, 1, 0, 0.485856,-0.0126598)    );
  // itree = 146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422894,0.00441557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617291,-0.0159662) , 
2, -0.0382782, 1, 0, 0.538732,-0.0223367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.742354,0.0683867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495527,0.00963625) , 
1, 0.590943, 1, 0, 0.533963,0.0518665) , 
1, 0.419001, 1, 0, 0.53696,0.00523707)    );
  // itree = 147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136191,-0.0290638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33103,0.142907) , 
1, 0.199127, 1, 0, 0.243824,0.0744537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330458,-0.0172067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748676,0.00406203) , 
3, 0.345115, 1, 0, 0.528697,-0.0232342) , 
0, -2.54417, 1, 0, 0.510585,-0.0170235)    );
  // itree = 148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51513,0.00537002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317373,-0.0208026) , 
1, 1.44003, 1, 0, 0.496266,0.00781981) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688833,-0.055889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.912597,0.0249236) , 
3, 2.13146, 1, 0, 0.768806,-0.0671408) , 
2, 1.32759, 1, 0, 0.519414,0.0014531)    );
  // itree = 149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0305089,-0.0428661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673308,-0.00247526) , 
1, 0.474388, 1, 0, 0.0419909,-0.0541469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443919,0.0213174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539918,-0.00280812) , 
0, -1.46818, 1, 0, 0.5287,0.00116951) , 
3, -1.49662, 1, 0, 0.482395,-0.00409326)    );
  // itree = 150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.549961,0.0443398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.771706,0.00760213) , 
2, -0.448113, 1, 0, 0.720218,0.0490624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306058,0.00683188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542263,-0.014195) , 
0, -0.590631, 1, 0, 0.447973,-0.0172131) , 
1, -0.826718, 1, 0, 0.502274,-0.00399396)    );
  // itree = 151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344704,-0.00201086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755494,0.0245658) , 
2, 0.125181, 1, 0, 0.473886,0.0155384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617314,-0.0181069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504648,-0.0745124) , 
0, 3.0126, 1, 0, 0.601353,-0.0795738) , 
0, 1.1401, 1, 0, 0.503583,-0.00662065)    );
  // itree = 152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.978766,0.0794938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657056,0.0112996) , 
1, -1.79226, 1, 0, 0.700312,0.055532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406385,-0.00793678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9527,0.0445798) , 
3, 2.19487, 1, 0, 0.437058,-0.0136452) , 
1, -0.723044, 1, 0, 0.494256,0.00138497)    );
  // itree = 153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334624,-0.0353986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269459,-0.00630811) , 
1, -0.90831, 1, 0, 0.281527,-0.0364745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.796205,0.0394921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755379,-0.000524689) , 
2, 0.220133, 1, 0, 0.763973,0.0247124) , 
3, 0.295236, 1, 0, 0.497941,-0.00902746)    );
  // itree = 154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125078,0.00924413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673218,0.0706022) , 
3, -1.22342, 1, 0, 0.265691,0.0746693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.549268,-0.00817462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35482,-0.0374056) , 
1, 1.00351, 1, 0, 0.51202,-0.0427074) , 
2, -1.026, 1, 0, 0.476132,-0.0256062)    );
  // itree = 155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327493,0.0171006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530762,-0.0106668) , 
0, -0.987092, 1, 0, 0.477365,-0.0119262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.953396,0.0359243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.969156,0.0471846) , 
3, 2.71201, 1, 0, 0.961212,0.0962271) , 
3, 2.22791, 1, 0, 0.505235,-0.00569629)    );
  // itree = 156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109795,-0.0250269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0758499) , 
1, 1.36124, 1, 0, 0.0825712,-0.0898754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597261,0.0136995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456963,-0.0110868) , 
1, 0.750482, 1, 0, 0.559458,0.018585) , 
2, -1.49842, 1, 0, 0.509958,0.00732701)    );
  // itree = 157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556334,0.00464808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699078,0.0544243) , 
1, 0.329362, 1, 0, 0.567602,0.0247425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382973,-0.080928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384272,-0.00561762) , 
1, 0.652429, 1, 0, 0.384133,-0.041311) , 
1, 0.512128, 1, 0, 0.503448,0.00164531)    );
  // itree = 158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216598,0.00549812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0812233,-0.0386343) , 
2, -1.19231, 1, 0, 0.126788,-0.0532037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.841416,0.0408435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65186,0.0030126) , 
0, -0.759425, 1, 0, 0.674059,0.0226992) , 
3, -0.486409, 1, 0, 0.504075,-0.000876528)    );
  // itree = 159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376591,0.00307339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238974,-0.0308082) , 
0, 0.0113987, 1, 0, 0.335872,-0.0226396) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.906703,0.0473589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.852361,0.0094929) , 
3, 1.01168, 1, 0, 0.861061,0.039978) , 
3, 0.828289, 1, 0, 0.497991,-0.00331034)    );
  // itree = 160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.819278,0.0610972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292317,-0.00850967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800987,0.019269) , 
3, 0.34753, 1, 0, 0.527359,0.011732) , 
1, -1.71428, 1, 0, 0.538715,0.0192056)    );
  // itree = 161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146617,-0.0299309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166324,0.0205376) , 
1, 0.962604, 1, 0, 0.151336,-0.0492907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.765988,0.040478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610843,-0.0075279) , 
0, 0.0729472, 1, 0, 0.655177,0.0190112) , 
3, -0.480083, 1, 0, 0.474137,-0.00553099)    );
  // itree = 162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148831,-0.0268808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76636,0.0273523) , 
2, -1.02858, 1, 0, 0.672697,0.0446811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451343,-0.00900018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451848,0.0199709) , 
1, 1.58685, 1, 0, 0.451378,-0.0192975) , 
1, -0.723044, 1, 0, 0.501104,-0.00492267)    );
  // itree = 163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0234709,-0.038016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540896,0.048705) , 
3, -1.89734, 1, 0, 0.360349,0.0905245) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0701173,-0.0303227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598508,0.0010676) , 
3, -0.866879, 1, 0, 0.52261,-0.00580831) , 
0, -2.09317, 1, 0, 0.503103,0.00577252)    );
  // itree = 164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265635,0.00553286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766651,0.0345369) , 
3, 0.0284943, 1, 0, 0.324887,0.0257691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633176,-0.0613866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626251,-0.00676275) , 
1, -1.02741, 1, 0, 0.627891,-0.0495919) , 
2, -0.242286, 1, 0, 0.503911,-0.0187565)    );
  // itree = 165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0528114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0579173) , 
2, -1.85546, 1, 0, 0,-0.0702741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416206,0.0286377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594378,-0.000186111) , 
2, -0.858428, 1, 0, 0.567859,0.0127154) , 
3, -1.5755, 1, 0, 0.519403,0.00563381)    );
  // itree = 166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.718314,0.0286907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493786,-0.00233173) , 
1, -1.27054, 1, 0, 0.522172,0.00434068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506447,0.0528043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544614,-0.0118548) , 
2, 0.385083, 1, 0, 0.520856,0.0694677) , 
1, 1.26913, 1, 0, 0.521977,0.0140099)    );
  // itree = 167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222965,0.000388234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235315,-0.0343434) , 
2, -0.754627, 1, 0, 0.23054,-0.059428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635704,0.0589861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759252,0.00129087) , 
3, 0.347305, 1, 0, 0.746532,0.0197944) , 
3, 0.131392, 1, 0, 0.48595,-0.0202138)    );
  // itree = 168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457456,-0.00371268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415898,-0.0422517) , 
0, 1.8498, 1, 0, 0.454274,-0.0205932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.994748,0.0543626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.905121,0.0177353) , 
2, 1.35197, 1, 0, 0.93825,0.0587738) , 
3, 1.91912, 1, 0, 0.491659,-0.0144625)    );
  // itree = 169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277318,-0.00796784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377082,-0.0458275) , 
2, 0.317182, 1, 0, 0.291237,-0.0413233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.792742,0.010245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701687,-0.0369835) , 
0, 3.3725, 1, 0, 0.786823,0.0170421) , 
3, 0.34765, 1, 0, 0.515101,-0.0149588)    );
  // itree = 170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.667072,0.0213481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688008,0.0548684) , 
1, -0.512881, 1, 0, 0.673111,0.0893027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298337,0.0589421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519639,0.00268702) , 
0, -2.56266, 1, 0, 0.502218,0.0162097) , 
1, -0.259324, 1, 0, 0.571003,0.0456299)    );
  // itree = 171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470376,-0.00337694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491906,-0.0352097) , 
0, 1.98951, 1, 0, 0.472004,-0.016906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.951796,0.0354431) , 
3, 2.27056, 1, 0, 0.494342,-0.0126653)    );
  // itree = 172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402905,-0.00362158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484515,-0.0280583) , 
0, 0.623103, 1, 0, 0.424039,-0.0291759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97945,0.0424783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846711,0.00175319) , 
0, 2.50157, 1, 0, 0.920132,0.0374224) , 
3, 1.63922, 1, 0, 0.483083,-0.0212495)    );
  // itree = 173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273754,-0.0651528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77663,0.00562121) , 
0, -0.605919, 1, 0, 0.53517,-0.0844771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500699,0.00272201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278835,-0.0618926) , 
1, 2.28755, 1, 0, 0.493495,0.00214977) , 
1, -1.19986, 1, 0, 0.497978,-0.00716987)    );
  // itree = 174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30308,0.0264598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535102,-0.00576856) , 
2, -1.3039, 1, 0, 0.506386,-0.00638674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460965,0.0363703) , 
1, 1.6884, 1, 0, 0.504328,-0.00123894)    );
  // itree = 175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349031,-0.0123227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71022,0.0352597) , 
2, 0.933283, 1, 0, 0.369121,-0.0261183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.883325,0.0137178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.952452,0.053174) , 
1, 1.26741, 1, 0, 0.893371,0.0496381) , 
3, 1.15656, 1, 0, 0.488338,-0.00889096)    );
  // itree = 176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438431,-0.000804699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228222,-0.044398) , 
0, 1.1524, 1, 0, 0.420217,-0.0162295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.913008,0.028578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805213,-0.0309088) , 
2, 1.66605, 1, 0, 0.892037,0.0392622) , 
3, 1.15656, 1, 0, 0.524585,-0.00395456)    );
  // itree = 177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262906,0.00594807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110715,-0.0390233) , 
1, 0.154445, 1, 0, 0.161806,-0.0567013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612163,0.00762487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672906,0.0862666) , 
1, 1.71925, 1, 0, 0.614202,0.0283401) , 
2, -0.861796, 1, 0, 0.513054,0.00932632)    );
  // itree = 178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335758,-0.0151118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833375,0.000406044) , 
3, 0.899086, 1, 0, 0.476069,-0.0317209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533214,0.0406762) , 
1, 1.94792, 1, 0, 0.47827,-0.0266587)    );
  // itree = 179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199603,0.00156396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504383,0.0403652) , 
2, -0.921346, 1, 0, 0.274618,0.0333228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377584,-0.016179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.863879,0.00462834) , 
3, 0.951429, 1, 0, 0.542955,-0.0288111) , 
2, -0.721635, 1, 0, 0.473589,-0.0127493)    );
  // itree = 180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0771984,-0.0255644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582561,0.0211668) , 
3, -1.05217, 1, 0, 0.45144,0.031962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27766,-0.0358637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901885,0.0157062) , 
3, 1.1665, 1, 0, 0.648795,-0.0244844) , 
0, 0.763913, 1, 0, 0.518963,0.0126495)    );
  // itree = 181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207046,-0.0195424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684017,0.0438986) , 
2, -0.548288, 1, 0, 0.387796,0.0213973) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0806936,-0.0503059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723731,-0.00275321) , 
3, 0.247243, 1, 0, 0.609618,-0.0289765) , 
0, -0.0225028, 1, 0, 0.49858,-0.00376079)    );
  // itree = 182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498824,-0.00362252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512758,0.0203005) , 
1, 1.25597, 1, 0, 0.500065,-0.00330499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312162,-0.0358127) , 
1, 1.76787, 1, 0, 0.490016,-0.00813575)    );
  // itree = 183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.757323,0.0362493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484915,-3.3364e-05) , 
1, -1.36456, 1, 0, 0.51738,0.0113855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15843,-0.0752868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420009,-0.0230318) , 
1, 1.26374, 1, 0, 0.372677,-0.0919295) , 
1, 1.15831, 1, 0, 0.49558,-0.004179)    );
  // itree = 184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553543,-0.0247621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498177,0.00383168) , 
1, -1.40587, 1, 0, 0.503424,0.00303968) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300765,-0.0595103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367304,-0.0104701) , 
1, 1.83066, 1, 0, 0.339956,-0.0843622) , 
1, 1.59954, 1, 0, 0.493406,-0.0023169)    );
  // itree = 185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.626305,0.00597302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364505,-0.0454075) , 
1, -1.22686, 1, 0, 0.519665,-0.0486071) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.643832,0.0484041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480084,0.00372844) , 
1, -0.68509, 1, 0, 0.495185,0.0202864) , 
1, -0.936379, 1, 0, 0.499664,0.0076811)    );
  // itree = 186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319874,-0.0150195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691074,0.0168815) , 
2, 0.804067, 1, 0, 0.349792,-0.033569) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.904583,0.0225746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778523,-0.0308878) , 
0, 3.19416, 1, 0, 0.886729,0.0308753) , 
3, 1.15656, 1, 0, 0.454574,-0.0209929)    );
  // itree = 187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0651238,-0.00787121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608985,0.0729451) , 
3, -1.54427, 1, 0, 0.264216,0.0799427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.727044,0.0214652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458313,-0.00864846) , 
1, -0.796883, 1, 0, 0.51124,-0.00641928) , 
0, -2.03899, 1, 0, 0.481765,0.00388552)    );
  // itree = 188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206162,0.0316318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128833,-0.0304785) , 
0, -2.81562, 1, 0, 0.137965,-0.0593646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.747938,0.0145139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497282,-0.0172659) , 
1, 1.00351, 1, 0, 0.699932,0.0221356) , 
3, -0.291428, 1, 0, 0.498472,-0.00708151)    );
  // itree = 189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279284,0.0662691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487789,-0.00115065) , 
0, -2.96519, 1, 0, 0.476952,0.00366568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463071,-0.109732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.887445,0.00860154) , 
3, 1.81776, 1, 0, 0.741776,-0.0966435) , 
2, 1.38813, 1, 0, 0.496176,-0.00361618)    );
  // itree = 190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0376667,-0.0389994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410757,0.0151462) , 
2, -1.74569, 1, 0, 0.352832,0.0262555) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491786,-0.0250636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.852966,0.0104818) , 
3, 1.01892, 1, 0, 0.694723,-0.0183672) , 
2, 0.0207206, 1, 0, 0.521002,0.00430639)    );
  // itree = 191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182202,-0.022969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329666,0.00486527) , 
0, -1.16588, 1, 0, 0.241801,-0.0282141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733388,0.0537903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699824,0.00588657) , 
0, -0.721787, 1, 0, 0.703822,0.0335877) , 
2, -0.346453, 1, 0, 0.518785,0.00883643)    );
  // itree = 192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301349,-0.00567091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208293,-0.0436799) , 
0, -0.0470742, 1, 0, 0.281039,-0.0386049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719865,0.0264773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696156,-0.00847635) , 
0, 0.670883, 1, 0, 0.705751,0.012995) , 
2, 0.0207206, 1, 0, 0.494161,-0.0127118)    );
  // itree = 193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204671,-0.00232125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611593,0.0362038) , 
3, -0.340469, 1, 0, 0.353726,0.0338295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375325,-0.0580605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684703,-0.00357414) , 
0, -0.483565, 1, 0, 0.649809,-0.0240806) , 
2, 0.0824135, 1, 0, 0.496273,0.0059491)    );
  // itree = 194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0542378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318196,0.049205) , 
3, -2.13213, 1, 0, 0.237407,0.0664373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213131,-0.0188114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686138,0.00371997) , 
3, -0.186968, 1, 0, 0.522046,-0.011385) , 
2, -1.40175, 1, 0, 0.490941,-0.00288056)    );
  // itree = 195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309532,-0.00299755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292354,-0.0223578) , 
0, -0.375346, 1, 0, 0.303006,-0.0280887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.819168,0.0329064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854798,-0.00475728) , 
3, 1.22634, 1, 0, 0.839689,0.0351617) , 
3, 0.673895, 1, 0, 0.467346,-0.00872059)    );
  // itree = 196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0584525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0703923) , 
1, 0.693428, 1, 0, 0,-0.093118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203759,-0.0275341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565954,0.00270904) , 
2, -1.23374, 1, 0, 0.538758,0.000793488) , 
2, -1.86672, 1, 0, 0.508841,-0.00442142)    );
  // itree = 197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578244,0.0390128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349523,0.00472991) , 
1, -0.936379, 1, 0, 0.381071,0.0239302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.816939,0.0173142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576258,-0.0282331) , 
1, -1.37148, 1, 0, 0.606717,-0.0646825) , 
2, 0.45817, 1, 0, 0.460467,-0.00724926)    );
  // itree = 198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310255,0.16002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53971,0.00465091) , 
2, -1.99845, 1, 0, 0.533509,0.0175968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23406,-0.0408833) , 
1, 1.76787, 1, 0, 0.519451,0.0115855)    );
  // itree = 199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565917,-0.00489864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673031,-0.0628796) , 
2, 0.826321, 1, 0, 0.605155,-0.0655307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.750565,0.0450821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468447,-0.000173743) , 
1, -0.885921, 1, 0, 0.486831,0.00652854) , 
1, -1.09693, 1, 0, 0.502466,-0.00299277)    );
  // itree = 200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464143,0.00483372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677033,-0.0180512) , 
0, 1.23957, 1, 0, 0.511093,-0.0014835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480699,0.0978165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788398,0.03366) , 
3, 0.225201, 1, 0, 0.661389,0.160261) , 
1, 1.45393, 1, 0, 0.520854,0.00902175)    );
  // itree = 201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.783466,0.0478477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46768,-0.00850919) , 
1, -1.91234, 1, 0, 0.478541,-0.0163295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440912,0.09404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729453,0.00959106) , 
3, 0.347956, 1, 0, 0.601519,0.106676) , 
1, 1.45393, 1, 0, 0.486765,-0.00810311)    );
  // itree = 202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257654,0.097647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378568,-0.0055447) , 
2, -2.04171, 1, 0, 0.373075,-0.00621994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.810467,0.0359601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768021,-0.00181852) , 
0, 1.15985, 1, 0, 0.783848,0.032135) , 
2, 0.556239, 1, 0, 0.50341,0.00594977)    );
  // itree = 203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363989,0.0136625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231564,-0.0132186) , 
1, 0.718787, 1, 0, 0.321793,0.0126267) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329107,-0.0272109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819435,0.0104403) , 
3, 0.56897, 1, 0, 0.607064,-0.0211989) , 
2, -0.138287, 1, 0, 0.478692,-0.00597735)    );
  // itree = 204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302992,0.00693409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194447,-0.0275678) , 
1, 0.370917, 1, 0, 0.243722,-0.0330249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58228,0.0217499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674084,-0.0102268) , 
2, 0.313304, 1, 0, 0.648334,-0.000530571) , 
2, -0.29699, 1, 0, 0.48404,-0.013725)    );
  // itree = 205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514378,-0.00129269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55605,0.0290044) , 
1, 0.924023, 1, 0, 0.520231,0.00807148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422872,-0.0240193) , 
1, 1.61612, 1, 0, 0.514735,0.00398182)    );
  // itree = 206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0565101,-0.0407458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191023,-0.00187808) , 
2, -1.89925, 1, 0, 0.115829,-0.0442943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354652,0.0322328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609485,0.00142406) , 
2, -0.767622, 1, 0, 0.570026,0.0155161) , 
2, -1.56754, 1, 0, 0.527126,0.00986689)    );
  // itree = 207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584004,-0.0367199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.748836,0.0431148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46848,-0.00159863) , 
1, -1.19094, 1, 0, 0.488861,0.00398397) , 
1, -1.69673, 1, 0, 0.493098,-0.000200696)    );
  // itree = 208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211877,-0.0230039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60864,0.0042134) , 
3, -0.0747281, 1, 0, 0.396919,-0.0279466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0697406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.910314,0.0182705) , 
3, 1.34294, 1, 0, 0.921162,0.0499383) , 
3, 1.18432, 1, 0, 0.504611,-0.0119471)    );
  // itree = 209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272724,0.00110405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492391,0.0743879) , 
1, 1.17425, 1, 0, 0.30955,0.0337095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.660184,-0.00352933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502034,-0.0278342) , 
1, 1.00646, 1, 0, 0.634309,-0.0219789) , 
2, -0.425618, 1, 0, 0.523775,-0.00302498)    );
  // itree = 210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393389,-0.0356583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756022,0.00287885) , 
0, -0.160114, 1, 0, 0.587129,-0.0422449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497139,0.0160164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43024,-0.00785396) , 
1, 0.393874, 1, 0, 0.463679,0.0109911) , 
1, -0.789758, 1, 0, 0.49272,-0.00153233)    );
  // itree = 211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420476,-0.00775524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399422,0.0188257) , 
1, 1.01352, 1, 0, 0.417041,-0.00828653) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.816618,0.0342773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790066,0.0131198) , 
2, 0.990038, 1, 0, 0.799373,0.0540786) , 
2, 0.604811, 1, 0, 0.529142,0.00999909)    );
  // itree = 212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386234,0.0176398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408506,-0.0148806) , 
0, 0.589701, 1, 0, 0.390167,0.0281032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320586,-0.0229878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81012,0.00229823) , 
3, 0.452359, 1, 0, 0.697748,-0.0102364) , 
2, 0.45817, 1, 0, 0.498044,0.0146564)    );
  // itree = 213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558404,-0.0129985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605863,0.0144059) , 
1, -0.619235, 1, 0, 0.582937,0.00304291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143841,-0.0349483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540575,-0.00613045) , 
2, -0.83084, 1, 0, 0.435183,-0.0340492) , 
1, 0.212582, 1, 0, 0.514929,-0.0140297)    );
  // itree = 214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174795,-0.00584952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681915,0.0227381) , 
3, -0.413533, 1, 0, 0.473527,0.0303484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384192,-0.0503673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831108,0.00106992) , 
3, 0.98747, 1, 0, 0.740442,-0.0308835) , 
2, 0.949745, 1, 0, 0.530777,0.0172149)    );
  // itree = 215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403182,-0.00725392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.893246,0.0124188) , 
3, 1.18432, 1, 0, 0.510542,-0.0090887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.605564,0.0565342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424512,0.00974009) , 
1, 1.85432, 1, 0, 0.541422,0.0874562) , 
1, 1.2589, 1, 0, 0.514957,0.00471391)    );
  // itree = 216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42311,-0.101591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793412,0.00491046) , 
0, -0.395474, 1, 0, 0.610287,-0.116966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722943,-0.0259369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550555,0.00227909) , 
2, -1.49842, 1, 0, 0.494728,9.10738e-05) , 
1, -1.65317, 1, 0, 0.50132,-0.00658647)    );
  // itree = 217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.751787,0.0357066) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503779,-0.0163075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496084,-0.00138284) , 
1, 0.241681, 1, 0, 0.500097,-0.0247649) , 
1, -1.67418, 1, 0, 0.51059,-0.0195845)    );
  // itree = 218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165102,-0.010709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701674,0.00691871) , 
3, -0.206128, 1, 0, 0.486312,0.000614142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188034,-0.0509034) , 
1, 2.07465, 1, 0, 0.476474,-0.00327675)    );
  // itree = 219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0725781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127592,-0.0104107) , 
2, -1.8786, 1, 0, 0.0561897,-0.0882456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235979,-0.0302167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57221,0.000780054) , 
0, -2.47082, 1, 0, 0.554475,-0.00364444) , 
2, -1.5546, 1, 0, 0.508891,-0.0113839)    );
  // itree = 220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102222,-0.005929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402893,0.0331158) , 
3, -1.10006, 1, 0, 0.245984,0.041545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446297,-0.023883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769497,0.00500812) , 
3, 0.344057, 1, 0, 0.65995,-0.0167303) , 
3, -0.346282, 1, 0, 0.521887,0.00270528)    );
  // itree = 221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.738058,0.0611635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718581,0.0138812) , 
2, 0.369762, 1, 0, 0.726406,0.0730197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257736,0.0191486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521346,-0.00857435) , 
2, -0.780555, 1, 0, 0.458988,-0.00716064) , 
1, -1.09702, 1, 0, 0.494914,0.00361117)    );
  // itree = 222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.843822,0.0550679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225423,0.0573151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489061,-0.00270453) , 
0, -3.05698, 1, 0, 0.477187,-0.0018698) , 
1, -2.02435, 1, 0, 0.487893,0.00235579)    );
  // itree = 223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279472,0.00759563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.898412,0.087036) , 
2, -0.283141, 1, 0, 0.341359,0.0409747) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453633,-0.0145114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676698,0.00791883) , 
0, 0.608417, 1, 0, 0.563549,-0.0110446) , 
0, -1.06144, 1, 0, 0.501963,0.00337383)    );
  // itree = 224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313081,-0.0307015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919436,0.0140159) , 
3, 0.260483, 1, 0, 0.554382,-0.0552582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527981,0.0077155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326571,-0.0182827) , 
1, 1.38839, 1, 0, 0.502871,0.0105592) , 
1, -1.52075, 1, 0, 0.507522,0.00461698)    );
  // itree = 225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447627,0.00632487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445703,0.0493767) , 
1, 1.38085, 1, 0, 0.447467,0.0255409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404105,-0.0598063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724768,-0.00514508) , 
0, 1.02211, 1, 0, 0.64111,-0.0473665) , 
0, 0.676813, 1, 0, 0.517368,-0.000777095)    );
  // itree = 226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0696543,-0.0078489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489692,0.0894561) , 
2, -1.6582, 1, 0, 0.271441,0.116402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585799,0.0259838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501079,-0.00167195) , 
1, -1.52075, 1, 0, 0.507204,0.0010614) , 
0, -2.98925, 1, 0, 0.494473,0.00729)    );
  // itree = 227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204369,0.0129015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117738,-0.0563252) , 
2, -1.06992, 1, 0, 0.152829,-0.0660058) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.722736,0.0648163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59968,-0.0023771) , 
0, -1.09465, 1, 0, 0.608175,0.00483823) , 
2, -0.660692, 1, 0, 0.4727,-0.0162395)    );
  // itree = 228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279575,0.00982775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637991,0.0754447) , 
0, -0.410415, 1, 0, 0.344475,0.0561362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408627,-0.0271027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833375,-0.00168671) , 
3, 0.904781, 1, 0, 0.613483,-0.0401545) , 
2, -0.0811742, 1, 0, 0.490732,0.00378391)    );
  // itree = 229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35237,0.000427071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170093,-0.0372025) , 
1, 0.433143, 1, 0, 0.288634,-0.0338692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.805692,0.0268642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692589,-0.0102752) , 
0, 1.63035, 1, 0, 0.761439,0.0290303) , 
3, 0.268003, 1, 0, 0.495982,-0.00628467)    );
  // itree = 230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546533,0.00471677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384689,-0.0388061) , 
1, 0.256226, 1, 0, 0.504934,-0.0189464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509346,0.0424464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637454,-0.00966549) , 
0, 0.703678, 1, 0, 0.55347,0.065843) , 
1, 0.843066, 1, 0, 0.515793,2.40224e-05)    );
  // itree = 231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.829423,0.0734096) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0376427,-0.0350567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559709,0.00177053) , 
3, -1.46046, 1, 0, 0.504309,-0.00117272) , 
1, -1.86762, 1, 0, 0.513069,0.00305359)    );
  // itree = 232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203067,0.00526542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270364,-0.0459941) , 
2, -0.806701, 1, 0, 0.22498,-0.0506291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487546,0.0382246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600613,-0.0021624) , 
0, -0.638919, 1, 0, 0.580477,0.0120031) , 
0, -1.56562, 1, 0, 0.508561,-0.000667312)    );
  // itree = 233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655994,0.0356335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.895773,-0.0222289) , 
3, 1.12384, 1, 0, 0.696595,0.0717925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439885,-0.0275519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492329,0.00700312) , 
1, -0.204197, 1, 0, 0.477606,-0.00778888) , 
1, -0.919085, 1, 0, 0.517729,0.00679211)    );
  // itree = 234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143583,-0.01288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678194,0.0501353) , 
3, -1.02649, 1, 0, 0.339887,0.0390411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286331,-0.0419545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604461,-0.00964981) , 
0, -0.641817, 1, 0, 0.557406,-0.0375097) , 
0, -1.06144, 1, 0, 0.494597,-0.0154057)    );
  // itree = 235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311293,0.0286763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586197,-0.0267281) , 
0, -1.60485, 1, 0, 0.550618,-0.0554006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447139,0.00129219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.959008,0.0397106) , 
3, 2.19487, 1, 0, 0.478045,0.00787509) , 
1, -0.827015, 1, 0, 0.494828,-0.00675739)    );
  // itree = 236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16101,-0.0204392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61998,0.00417493) , 
3, -0.636326, 1, 0, 0.486156,-0.00631391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527752,0.0831143) , 
1, 1.96083, 1, 0, 0.487814,0.0014262)    );
  // itree = 237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595589,-0.0277628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50225,0.00711178) , 
1, -1.29442, 1, 0, 0.514643,0.0050484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162498,-0.0517578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509313,-0.0261662) , 
2, -0.584468, 1, 0, 0.334697,-0.123603) , 
1, 1.2714, 1, 0, 0.48866,-0.0135283)    );
  // itree = 238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0268684,-0.0317935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232759,-0.0528789) , 
3, -1.59928, 1, 0, 0.111118,-0.103997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.738151,0.0336767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510698,-0.000602961) , 
1, -1.17391, 1, 0, 0.545184,0.0121071) , 
0, -2.19565, 1, 0, 0.492007,-0.00211665)    );
  // itree = 239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249244,-0.00650829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.807753,0.0279747) , 
3, -0.704989, 1, 0, 0.659886,0.0411637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431851,-0.0203695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479928,0.0113475) , 
1, 0.30994, 1, 0, 0.458175,-0.00822554) , 
1, -0.636263, 1, 0, 0.512391,0.00504947)    );
  // itree = 240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261919,0.0094461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598401,-0.013274) , 
2, -0.433831, 1, 0, 0.479649,-0.0154874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287779,-0.0448068) , 
1, 2.17198, 1, 0, 0.473037,-0.0207462)    );
  // itree = 241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182442,-0.0185983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540035,0.0315895) , 
0, -2.09138, 1, 0, 0.395505,0.0358593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323153,-0.0184176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766919,0.00515204) , 
3, 0.503414, 1, 0, 0.599134,-0.0121894) , 
0, -0.789793, 1, 0, 0.536993,0.00247351)    );
  // itree = 242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50991,-0.00518408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61857,0.0322866) , 
1, 0.478126, 1, 0, 0.539823,0.0112824) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0445683,-0.0698679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452073,0.0111479) , 
0, -0.908794, 1, 0, 0.256576,-0.0974328) , 
1, 1.54893, 1, 0, 0.512132,0.000653894)    );
  // itree = 243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310252,-0.080866) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196107,-0.00104042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552769,-0.0198274) , 
2, -0.792904, 1, 0, 0.462801,-0.0395522) , 
1, -1.92948, 1, 0, 0.458086,-0.0469017)    );
  // itree = 244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410384,0.0262473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269806,-0.0243503) , 
1, -0.826718, 1, 0, 0.293938,-0.0475298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.660194,-0.007175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753724,0.0265229) , 
1, 0.913195, 1, 0, 0.67906,0.000115387) , 
2, -0.00680894, 1, 0, 0.503878,-0.0215571)    );
  // itree = 245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396586,0.0296888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137456,-0.0343437) , 
1, -0.227901, 1, 0, 0.197468,-0.0430614) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444006,0.0374554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604641,-0.000326097) , 
2, -0.624109, 1, 0, 0.590984,0.00804826) , 
2, -0.862357, 1, 0, 0.504073,-0.00323961)    );
  // itree = 246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595424,-0.00726265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54818,0.020863) , 
1, -0.944356, 1, 0, 0.564299,0.027612) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276064,-0.0288656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638083,0.0111671) , 
0, -0.0687615, 1, 0, 0.444703,-0.0244084) , 
1, 0.213586, 1, 0, 0.507962,0.00310741)    );
  // itree = 247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116573,-0.00793094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0371587,-0.0533911) , 
1, -0.125285, 1, 0, 0.0628472,-0.0736928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33819,0.0254362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600684,-0.00268398) , 
2, -0.497702, 1, 0, 0.5301,0.0105001) , 
2, -1.57103, 1, 0, 0.492217,0.00367406)    );
  // itree = 248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39272,-0.0306837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515161,0.0119377) , 
1, -1.78633, 1, 0, 0.508474,0.0229108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244931,-0.0340876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.958762,0.0433372) , 
3, 1.34044, 1, 0, 0.364535,-0.0579467) , 
1, 1.15831, 1, 0, 0.484065,0.00919898)    );
  // itree = 249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124769,-0.0120448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72306,0.0156604) , 
3, -0.707817, 1, 0, 0.546367,0.0209402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323768,-0.03046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552611,0.0592379) , 
1, 1.93053, 1, 0, 0.357978,-0.0476382) , 
1, 1.07947, 1, 0, 0.511051,0.00808423)    );
  // itree = 250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.793657,0.0451635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228253,0.0227406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500235,-0.0143833) , 
2, -1.08144, 1, 0, 0.465272,-0.0278779) , 
1, -1.70534, 1, 0, 0.479381,-0.0211767)    );
  // itree = 251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15647,0.0151498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480584,-0.0139351) , 
2, -1.25462, 1, 0, 0.441338,-0.0303477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574252,0.0493395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346984,-0.0183183) , 
1, 1.54517, 1, 0, 0.458952,0.0382389) , 
1, 1.12702, 1, 0, 0.443991,-0.0200202)    );
  // itree = 252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257683,-0.00301887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659565,0.0242938) , 
2, -0.604936, 1, 0, 0.503618,0.0357239) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411011,-0.0395317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.900177,0.00841712) , 
3, 1.64917, 1, 0, 0.718051,-0.0418584) , 
0, 1.49809, 1, 0, 0.54042,0.0224088)    );
  // itree = 253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547346,-0.0222605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560015,0.022032) , 
1, -1.14449, 1, 0, 0.555863,0.0159311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352021,-0.0179417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.942846,0.0336314) , 
3, 2.38672, 1, 0, 0.377165,-0.0376978) , 
1, -0.107454, 1, 0, 0.452253,-0.0151632)    );
  // itree = 254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215837,0.0219472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138356,-0.0390841) , 
0, -1.70094, 1, 0, 0.180563,-0.0154832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493424,0.0397406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758684,0.00662584) , 
3, 0.289924, 1, 0, 0.649639,0.0540082) , 
2, -0.86672, 1, 0, 0.534213,0.0369083)    );
  // itree = 255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.667152,-0.0047862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499512,-0.0436552) , 
1, -1.40998, 1, 0, 0.592575,-0.0624292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572603,0.0150591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409479,-0.00445246) , 
1, 0.107178, 1, 0, 0.473128,0.00877613) , 
1, -1.10105, 1, 0, 0.491128,-0.00195389)    );
  // itree = 256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478038,0.0335524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598728,-0.0302227) , 
0, -1.77117, 1, 0, 0.578104,-0.0489358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556723,0.0141861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405589,-0.00690999) , 
1, 0.0278256, 1, 0, 0.457409,0.00221129) , 
1, -0.919085, 1, 0, 0.47677,-0.00599318)    );
  // itree = 257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457816,0.00671863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686085,-0.0169012) , 
0, 1.10203, 1, 0, 0.520113,0.00138281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208769,-0.0493669) , 
1, 2.29479, 1, 0, 0.50962,-0.00356511)    );
  // itree = 258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158857,0.00600485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40999,-0.0210609) , 
3, -0.727114, 1, 0, 0.304972,-0.0316109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.872043,0.023722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.798648,-0.00219235) , 
2, 0.694809, 1, 0, 0.82694,0.0184597) , 
3, 0.742135, 1, 0, 0.466746,-0.0160926)    );
  // itree = 259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252104,-0.0562392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886083,0.0372017) , 
0, -0.139719, 1, 0, 0.492228,-0.101709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23851,0.0027689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546411,-0.00990176) , 
2, -0.55359, 1, 0, 0.446415,-0.0152045) , 
1, -1.40709, 1, 0, 0.45024,-0.0224276)    );
  // itree = 260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366654,0.00740734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768209,0.0372839) , 
2, 0.183843, 1, 0, 0.494071,0.0417718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.831657,0.0240471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684727,-0.0311725) , 
1, -0.131841, 1, 0, 0.757331,-0.016851) , 
2, 1.03213, 1, 0, 0.542114,0.0310736)    );
  // itree = 261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245119,0.0472965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425557,-0.0118144) , 
0, -2.63664, 1, 0, 0.411736,-0.0235333) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.937035,0.0342699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790183,-0.0200517) , 
2, 1.37573, 1, 0, 0.889905,0.0315569) , 
3, 1.18432, 1, 0, 0.51948,-0.01112)    );
  // itree = 262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350683,0.0480776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531213,-0.0176064) , 
0, -2.89293, 1, 0, 0.519692,-0.0342392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383087,0.0443903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597911,0.0123929) , 
0, -1.03298, 1, 0, 0.54206,0.0478432) , 
1, -0.23149, 1, 0, 0.533194,0.0153091)    );
  // itree = 263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349728,-0.0013557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259498,-0.0452004) , 
2, 0.438655, 1, 0, 0.335025,-0.0241162) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.885471,0.0280017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715119,-0.00226521) , 
0, 0.787614, 1, 0, 0.767449,0.0145914) , 
3, 0.427177, 1, 0, 0.508458,-0.00859163)    );
  // itree = 264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566424,0.00424068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686754,0.0436129) , 
1, -0.0476316, 1, 0, 0.592117,0.0327272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184232,-0.0263639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781356,0.0181631) , 
3, 0.34765, 1, 0, 0.40511,-0.0246645) , 
1, 0.291673, 1, 0, 0.509964,0.00751472)    );
  // itree = 265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547924,-0.0321472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595829,0.0175254) , 
1, -1.93711, 1, 0, 0.591104,0.0284304) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376913,-0.016629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.905895,0.0197673) , 
2, 1.4644, 1, 0, 0.41755,-0.0352565) , 
1, -0.480148, 1, 0, 0.469672,-0.0161299)    );
  // itree = 266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341339,-0.0210273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372322,0.0389084) , 
1, -0.275778, 1, 0, 0.360361,0.0304562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.769704,0.0331001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540378,-0.0172576) , 
1, -1.52075, 1, 0, 0.560008,-0.0344235) , 
0, -0.701588, 1, 0, 0.484176,-0.00978012)    );
  // itree = 267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215784,-0.00146674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454461,-0.0230669) , 
3, -0.245138, 1, 0, 0.259753,-0.01623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565063,0.0274981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778464,0.00320742) , 
3, 0.442738, 1, 0, 0.716786,0.0294422) , 
3, 0.0391675, 1, 0, 0.507426,0.00852041)    );
  // itree = 268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332379,-0.0167393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.936431,0.052855) , 
2, -0.216839, 1, 0, 0.793761,0.0919177) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264628,0.0018601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680837,-0.0142267) , 
3, 0.34753, 1, 0, 0.451004,-0.0142834) , 
1, -1.1416, 1, 0, 0.487871,-0.00286037)    );
  // itree = 269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570937,-0.0255202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584581,0.0153901) , 
1, -1.51763, 1, 0, 0.582998,0.0281327) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416802,-0.00352153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233018,-0.0345848) , 
1, 1.51791, 1, 0, 0.353649,-0.0305447) , 
1, 0.730317, 1, 0, 0.513869,0.0104464)    );
  // itree = 270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321603,-0.00653926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672861,0.0124023) , 
2, -0.037951, 1, 0, 0.463194,0.00232008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369516,-0.0372029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885219,0.00368977) , 
3, 1.55742, 1, 0, 0.648007,-0.056266) , 
0, 1.52038, 1, 0, 0.498139,-0.00875747)    );
  // itree = 271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278274,0.0180731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500068,-0.00366537) , 
0, -1.31469, 1, 0, 0.444338,0.00244561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.841295,0.0352835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780565,-0.0324498) , 
0, 3.18183, 1, 0, 0.830019,0.0562132) , 
0, 1.80911, 1, 0, 0.500715,0.010305)    );
  // itree = 272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.790096,0.0497257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500348,-0.00538508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181762,-0.0645219) , 
1, 2.3465, 1, 0, 0.489282,-0.0190879) , 
1, -2.0036, 1, 0, 0.49935,-0.0137751)    );
  // itree = 273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568593,-0.0212281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337516,0.0235991) , 
3, -1.50037, 1, 0, 0.271761,0.0426847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471423,-0.0177096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777427,0.00456243) , 
3, 0.487657, 1, 0, 0.657409,-0.0142969) , 
3, -0.218528, 1, 0, 0.513829,0.00691782)    );
  // itree = 274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611374,-0.000209792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.891495,0.0864073) , 
1, -1.37477, 1, 0, 0.67437,0.0425738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227947,0.0312224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478469,-0.00714023) , 
0, -2.54417, 1, 0, 0.458574,-0.0123575) , 
1, -1.17388, 1, 0, 0.483809,-0.00593396)    );
  // itree = 275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341543,-0.0239712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.896742,0.0150014) , 
3, 0.998459, 1, 0, 0.463831,-0.0424498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48432,0.0129453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657441,-0.0565586) , 
0, 2.35263, 1, 0, 0.494042,0.0204808) , 
1, -0.107454, 1, 0, 0.480688,-0.00733653)    );
  // itree = 276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199793,0.00650044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170369,-0.030674) , 
2, -0.716311, 1, 0, 0.188243,-0.0235183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.703998,0.0393776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680814,0.00669211) , 
2, -0.088399, 1, 0, 0.685795,0.0375627) , 
3, -0.316527, 1, 0, 0.481969,0.0125405)    );
  // itree = 277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.745819,0.0624345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0704098,-0.0231548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589828,0.00845695) , 
3, -1.19711, 1, 0, 0.507751,0.0128593) , 
1, -1.83103, 1, 0, 0.517356,0.0174518)    );
  // itree = 278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568516,-0.0599311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6089,0.0108235) , 
0, -3.17712, 1, 0, 0.573219,0.0123314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139527,0.0615603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407173,-0.0262346) , 
3, -1.43388, 1, 0, 0.385668,-0.0536282) , 
1, 0.212582, 1, 0, 0.488753,-0.0173742)    );
  // itree = 279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.669907,0.0534096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252439,-0.0236907) , 
1, -1.26609, 1, 0, 0.282958,-0.0420384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467335,0.0212485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677782,-0.00637049) , 
2, 0.242821, 1, 0, 0.591049,0.0109222) , 
0, -0.794061, 1, 0, 0.482966,-0.00765717)    );
  // itree = 280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654753,0.00853178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471018,-0.0179399) , 
1, -1.06415, 1, 0, 0.51256,-0.0310155) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261981,0.0183148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728953,-0.00766118) , 
3, 0.281919, 1, 0, 0.46433,0.0151596) , 
1, 0.547194, 1, 0, 0.496399,-0.0155431)    );
  // itree = 281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168811,-0.0305293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697235,0.000438845) , 
3, -0.434435, 1, 0, 0.525632,-0.0232834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502831,0.0267152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598473,-0.0216304) , 
0, 1.22448, 1, 0, 0.526428,0.0337005) , 
1, 0.37474, 1, 0, 0.525898,-0.00423045)    );
  // itree = 282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.849208,0.0278949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479352,-0.0192087) , 
1, -1.77066, 1, 0, 0.537091,-0.0309211) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566305,0.0223823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450628,-0.00238206) , 
1, 0.311475, 1, 0, 0.499137,0.0194162) , 
1, -0.565578, 1, 0, 0.510332,0.00456941)    );
  // itree = 283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.761038,0.102498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.930552,0.0357813) , 
3, 0.20592, 1, 0, 0.854,0.166782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174903,-0.0161403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634754,0.00680286) , 
3, -0.430822, 1, 0, 0.466186,-0.00210807) , 
1, -1.24897, 1, 0, 0.502828,0.0138492)    );
  // itree = 284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474522,-0.0594976) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364006,-0.00742841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.888126,0.0150927) , 
3, 1.14303, 1, 0, 0.46885,-0.00877264) , 
1, -2.21448, 1, 0, 0.46902,-0.013451)    );
  // itree = 285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632683,0.00278242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397988,-0.0459815) , 
1, -1.79237, 1, 0, 0.467331,-0.0912231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579528,0.0152937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426405,-0.0059918) , 
1, 0.20308, 1, 0, 0.490271,0.00824342) , 
1, -1.05754, 1, 0, 0.486925,-0.00626576)    );
  // itree = 286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12799,-0.0266377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629126,0.0137753) , 
2, -0.936767, 1, 0, 0.53101,0.0168868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.592411,0.0462953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684247,0.0100609) , 
0, 0.855067, 1, 0, 0.618117,0.101651) , 
1, 1.26091, 1, 0, 0.54151,0.0271047)    );
  // itree = 287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342291,0.0292248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67236,-0.00716197) , 
3, -0.256843, 1, 0, 0.576566,0.00738335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0550198,-0.0290839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651596,0.0264965) , 
3, -0.98855, 1, 0, 0.525077,0.0449203) , 
1, 0.237261, 1, 0, 0.553141,0.0244605)    );
  // itree = 288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40319,0.0117632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545007,-0.0378077) , 
0, -0.910985, 1, 0, 0.500956,-0.0553719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641767,0.0323313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46913,0.000331563) , 
1, -0.124994, 1, 0, 0.514329,0.0216793) , 
1, -0.827015, 1, 0, 0.511349,0.00450823)    );
  // itree = 289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29547,0.0228271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212322,-0.0270978) , 
0, -2.43349, 1, 0, 0.229303,-0.0468966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0671295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658246,-0.00081169) , 
0, -0.712032, 1, 0, 0.681316,0.00489896) , 
3, -0.231227, 1, 0, 0.503186,-0.0155128)    );
  // itree = 290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0381906,-0.0302151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421609,0.0515744) , 
3, -1.43825, 1, 0, 0.210388,0.0472476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505051,-0.0151951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.936655,0.0256733) , 
3, 2.36238, 1, 0, 0.521481,-0.0353512) , 
2, -1.3346, 1, 0, 0.491685,-0.0274399)    );
  // itree = 291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130214,0.0197863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691503,0.0932621) , 
3, -1.40163, 1, 0, 0.293666,0.0967072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.581358,-0.0408043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535334,0.00145491) , 
1, -1.57885, 1, 0, 0.538809,-0.00369719) , 
2, -1.2253, 1, 0, 0.510455,0.00791567)    );
  // itree = 292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363446,-0.00482002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.867887,0.0403527) , 
3, 0.677634, 1, 0, 0.414419,-0.00178257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531198,-0.0264617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.923635,0.010383) , 
3, 1.73518, 1, 0, 0.623599,-0.0483082) , 
2, 0.391241, 1, 0, 0.497304,-0.0202179)    );
  // itree = 293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111885,-0.0722163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643865,-0.0173227) , 
3, -1.03107, 1, 0, 0.524998,-0.0832942) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598795,0.0485601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456442,-0.00280433) , 
1, -0.672831, 1, 0, 0.471684,0.00635269) , 
1, -1.17388, 1, 0, 0.478123,-0.00447571)    );
  // itree = 294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419357,0.0156454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417567,-0.021376) , 
0, 0.0198386, 1, 0, 0.41915,0.0247092) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246917,-0.0351457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854267,0.00812874) , 
3, 0.882574, 1, 0, 0.668818,-0.0217693) , 
0, 0.411997, 1, 0, 0.522499,0.00546966)    );
  // itree = 295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312683,-0.0475998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.958169,0.028661) , 
3, 0.748482, 1, 0, 0.491469,-0.0988667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61166,0.0172416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450018,-0.0107934) , 
1, -0.446543, 1, 0, 0.491137,-0.00699316) , 
1, -1.52075, 1, 0, 0.491169,-0.0159248)    );
  // itree = 296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0572756,-0.0433315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212395,-0.00593142) , 
0, -3.1312, 1, 0, 0.195822,-0.0209536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.678061,0.0243413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647305,-0.00663681) , 
0, 1.04238, 1, 0, 0.665333,0.02837) , 
3, -0.291428, 1, 0, 0.513958,0.0124676)    );
  // itree = 297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493489,-0.042024) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203043,-0.00915708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697763,0.00457328) , 
3, -0.128257, 1, 0, 0.493698,-0.00145288) , 
1, -1.7331, 1, 0, 0.493686,-0.00822103)    );
  // itree = 298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493856,-0.0529618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704857,0.0293963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458148,-0.00659674) , 
1, -0.952787, 1, 0, 0.494533,-0.00292648) , 
1, -1.99411, 1, 0, 0.494509,-0.0081826)    );
  // itree = 299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182789,-0.0239913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533798,0.00528328) , 
0, -1.9486, 1, 0, 0.47369,0.000757827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457986,-0.0616121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886207,-0.00536122) , 
3, 2.05733, 1, 0, 0.699373,-0.0921525) , 
0, 2.34259, 1, 0, 0.489064,-0.00557138)    );
  // itree = 300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.716367,0.0327224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465922,-0.00579639) , 
1, -1.10566, 1, 0, 0.504688,0.000372412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215577,-0.0663791) , 
1, 1.78879, 1, 0, 0.492698,-0.00674923)    );
  // itree = 301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670506,0.0146629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802238,0.0587638) , 
1, -0.915731, 1, 0, 0.689508,0.0504263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199843,0.016552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627408,-0.00605137) , 
3, -0.316527, 1, 0, 0.47282,0.00122335) , 
1, -0.796883, 1, 0, 0.517928,0.0114659)    );
  // itree = 302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160678,0.0290448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285974,-0.0395312) , 
3, -1.05753, 1, 0, 0.22545,-0.0395617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.591003,0.0218592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583905,-0.0059164) , 
0, -0.0608015, 1, 0, 0.586045,0.00645528) , 
2, -0.660692, 1, 0, 0.483311,-0.00665496)    );
  // itree = 303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134446,0.00959361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374779,0.0319161) , 
3, -0.990191, 1, 0, 0.248992,0.0456281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333251,-0.0437148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73297,0.0077175) , 
2, -0.325808, 1, 0, 0.670909,-0.00328648) , 
3, -0.218528, 1, 0, 0.506689,0.0157522)    );
  // itree = 304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.85711,0.0654395) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177077,-0.0332671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53554,-0.00287233) , 
0, -1.79098, 1, 0, 0.4733,-0.0186482) , 
1, -1.83103, 1, 0, 0.483849,-0.0134032)    );
  // itree = 305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.796606,0.0464743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465198,-0.0136718) , 
1, -1.42178, 1, 0, 0.501742,-0.0186051) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536545,0.0286723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369877,-0.0146111) , 
1, 1.48794, 1, 0, 0.489299,0.0351383) , 
1, 0.547194, 1, 0, 0.498025,-0.00255005)    );
  // itree = 306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188591,-0.02668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668919,-0.00236032) , 
3, -0.2057, 1, 0, 0.487153,-0.0281284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365157,0.124596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446849,-0.0100535) , 
2, -0.625117, 1, 0, 0.411236,0.0788461) , 
1, 1.49685, 1, 0, 0.481662,-0.0203911)    );
  // itree = 307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378848,0.0372682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580467,-0.0135725) , 
0, -1.49781, 1, 0, 0.543361,-0.0105897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514012,0.0209696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417051,-0.0180004) , 
1, 1.36474, 1, 0, 0.498989,0.03228) , 
1, -0.101333, 1, 0, 0.517955,0.0139555)    );
  // itree = 308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190554,-0.00806591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129764,-0.0580017) , 
1, 1.2922, 1, 0, 0.17743,-0.0542139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644308,0.0168049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717397,-0.039912) , 
0, 2.67127, 1, 0, 0.648595,0.032526) , 
2, -0.86672, 1, 0, 0.53689,0.0119614)    );
  // itree = 309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174066,-0.0321666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154408,-0.0035363) , 
0, -1.69392, 1, 0, 0.166329,-0.0479665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606484,0.0187342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674101,-0.00815227) , 
2, -0.114787, 1, 0, 0.656214,0.00011682) , 
3, -0.582913, 1, 0, 0.503743,-0.0148486)    );
  // itree = 310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390378,-0.0429564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818535,-0.0069331) , 
3, 0.297794, 1, 0, 0.585158,-0.0720206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429222,-0.0230345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523043,0.0116158) , 
1, -0.606641, 1, 0, 0.50943,0.0159155) , 
1, -1.02741, 1, 0, 0.52261,0.000610109)    );
  // itree = 311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162694,0.00226296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500974,0.0429171) , 
3, -0.641047, 1, 0, 0.282671,0.0415436) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.646158,-0.0760843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657075,-0.00622543) , 
0, -0.698763, 1, 0, 0.656007,-0.0322229) , 
3, -0.145446, 1, 0, 0.517891,-0.00493294)    );
  // itree = 312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59691,0.0314891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35044,-0.0102419) , 
1, -0.764163, 1, 0, 0.394479,-0.00495828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411314,-0.043467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805574,-0.0125637) , 
3, 0.946935, 1, 0, 0.675983,-0.0640863) , 
2, 0.494555, 1, 0, 0.489299,-0.0248746)    );
  // itree = 313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213716,0.00363825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368057,-0.0258239) , 
3, -0.303657, 1, 0, 0.271827,-0.02608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.746448,0.0163241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698737,-0.0271539) , 
2, 1.16988, 1, 0, 0.733678,0.0102434) , 
3, 0.27076, 1, 0, 0.48597,-0.00923819)    );
  // itree = 314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483202,0.0239791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674711,-0.0214855) , 
2, 0.61766, 1, 0, 0.547008,0.0214707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128605,-0.048311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528348,-0.00252356) , 
0, -1.49958, 1, 0, 0.43882,-0.0258465) , 
1, -0.274313, 1, 0, 0.482546,-0.00672243)    );
  // itree = 315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155263,0.00492758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495894,-0.0418162) , 
3, -0.99753, 1, 0, 0.2651,-0.0394788) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610476,-0.0211308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599043,0.0116303) , 
1, -1.17388, 1, 0, 0.600802,0.0156695) , 
0, -1.28819, 1, 0, 0.520486,0.00247533)    );
  // itree = 316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400784,0.00332768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402942,-0.0211154) , 
0, 0.147692, 1, 0, 0.401561,-0.0173863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.807485,-0.0188345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.911969,0.0210936) , 
3, 1.41761, 1, 0, 0.893605,0.0260843) , 
3, 1.24934, 1, 0, 0.49544,-0.0090923)    );
  // itree = 317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0156608,-0.0435441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583409,0.0104502) , 
3, -1.61748, 1, 0, 0.540002,0.0199165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249674,0.0154378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416763,-0.0339238) , 
3, -0.0316715, 1, 0, 0.347081,-0.0457156) , 
1, 1.38085, 1, 0, 0.516608,0.0119581)    );
  // itree = 318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0924047,0.0212042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234409,-0.0231442) , 
3, -1.47232, 1, 0, 0.18516,-0.0338278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.927406,0.0568503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637755,0.00325473) , 
0, -0.45239, 1, 0, 0.691647,0.0355058) , 
3, -0.582913, 1, 0, 0.54595,0.0155612)    );
  // itree = 319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23368,0.00848906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293937,-0.0214178) , 
2, -1.04462, 1, 0, 0.275192,-0.033094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57205,-0.0259555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.795038,0.0131347) , 
2, -0.119249, 1, 0, 0.77118,0.0194997) , 
3, 0.27076, 1, 0, 0.502839,-0.00895469)    );
  // itree = 320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299629,0.011844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246597,-0.0863632) , 
0, -1.42987, 1, 0, 0.285523,-0.0458663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541791,0.0206305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679519,-0.00516352) , 
0, 0.545935, 1, 0, 0.608791,0.0217497) , 
0, -1.11562, 1, 0, 0.52375,0.00396217)    );
  // itree = 321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44116,0.00943556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820996,0.0638078) , 
2, 0.784059, 1, 0, 0.485446,0.0321533) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617443,-0.0128803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.969944,0.0444743) , 
3, 2.75488, 1, 0, 0.656196,-0.0199618) , 
0, 1.20503, 1, 0, 0.528142,0.0191218)    );
  // itree = 322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0309422,-0.0415128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288077,0.044744) , 
3, -1.4638, 1, 0, 0.183887,0.0332598) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511674,-0.0463436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625441,-0.00351745) , 
0, -0.665473, 1, 0, 0.605419,-0.0307597) , 
3, -0.774089, 1, 0, 0.500472,-0.0148211)    );
  // itree = 323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31796,0.0116669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0822251,-0.0398208) , 
0, -1.13155, 1, 0, 0.235342,-0.0139933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.591496,0.0360887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715179,-0.00136655) , 
3, 0.218679, 1, 0, 0.682505,0.0244855) , 
3, -0.231227, 1, 0, 0.491169,0.00802092)    );
  // itree = 324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0551842,-0.0898446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728245,-0.0146124) , 
3, -0.633491, 1, 0, 0.527276,-0.115638) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641719,0.0337763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450116,-0.0117887) , 
1, -0.677834, 1, 0, 0.483588,-0.012192) , 
1, -1.37148, 1, 0, 0.48873,-0.0243677)    );
  // itree = 325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132711,-0.0691747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805398,-0.0192105) , 
3, 0.0460053, 1, 0, 0.447359,-0.131099) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275462,0.0559875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540597,0.00220642) , 
0, -2.37196, 1, 0, 0.517665,0.0135346) , 
1, -1.52075, 1, 0, 0.511742,0.0013504)    );
  // itree = 326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108822,-0.0354588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103243,0.00501855) , 
1, 0.336366, 1, 0, 0.106359,-0.0445852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.625361,0.00289989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721123,-0.041804) , 
2, 1.52895, 1, 0, 0.631962,-0.000204891) , 
3, -0.761997, 1, 0, 0.488931,-0.012282)    );
  // itree = 327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233318,-0.0480046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275804,-0.0128354) , 
1, -1.46272, 1, 0, 0.272304,-0.0397331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.865011,0.0561775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.740287,0.00119121) , 
2, -0.0222741, 1, 0, 0.749594,0.013705) , 
3, 0.34765, 1, 0, 0.479828,-0.0164984)    );
  // itree = 328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161203,-0.00628114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636511,0.0231099) , 
3, -0.682836, 1, 0, 0.416633,0.0272909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565734,-0.0253802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915575,0.0222022) , 
3, 1.86901, 1, 0, 0.651277,-0.0407311) , 
2, 0.391241, 1, 0, 0.50063,0.00294066)    );
  // itree = 329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.917293,0.0756432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269639,0.0246689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593685,-0.00328979) , 
2, -0.433831, 1, 0, 0.478641,0.0118295) , 
1, -1.73018, 1, 0, 0.495434,0.0180682)    );
  // itree = 330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402215,-0.00203095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626536,-0.017915) , 
0, 0.749055, 1, 0, 0.469698,-0.0164549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488416,0.0424382) , 
1, 2.0818, 1, 0, 0.470333,-0.0125081)    );
  // itree = 331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504773,-0.0363948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517244,-0.00271453) , 
1, -1.35518, 1, 0, 0.515988,-0.0136931) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4701,0.0633145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600757,-0.0207415) , 
2, 0.268855, 1, 0, 0.532162,0.0529197) , 
1, 1.07947, 1, 0, 0.518277,-0.00426918)    );
  // itree = 332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453619,0.00168781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613244,-0.0412659) , 
2, 0.506373, 1, 0, 0.511872,-0.0322487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210768,-0.00970568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720612,0.0135928) , 
3, -0.0292777, 1, 0, 0.478666,0.00779648) , 
1, -0.107454, 1, 0, 0.492899,-0.0093683)    );
  // itree = 333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.842643,0.0684065) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.630334,0.0132919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42791,-0.0109325) , 
1, -0.713625, 1, 0, 0.468725,-0.0152771) , 
1, -1.83103, 1, 0, 0.481787,-0.00873491)    );
  // itree = 334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.01342,-0.0425048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478133,0.0164189) , 
3, -1.68159, 1, 0, 0.406652,0.0280008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41954,-0.0139153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884542,0.0118909) , 
3, 1.15024, 1, 0, 0.614112,-0.0142764) , 
0, -0.0225028, 1, 0, 0.510295,0.00688005)    );
  // itree = 335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528416,-0.0389898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484422,0.000984791) , 
1, -2.00576, 1, 0, 0.486082,-0.00245718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.945907,0.0178036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931612,0.0534694) , 
1, 0.530773, 1, 0, 0.93942,0.0822695) , 
3, 2.12188, 1, 0, 0.516024,0.00313886)    );
  // itree = 336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284281,-0.0575882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.865142,0.00486519) , 
3, 0.59925, 1, 0, 0.439035,-0.136695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278508,-0.0244811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736515,0.0150368) , 
2, 0.16305, 1, 0, 0.481536,-0.0176783) , 
1, -1.06689, 1, 0, 0.473597,-0.0399098)    );
  // itree = 337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0895873,-0.048707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0605124,-0.0157571) , 
1, -0.707127, 1, 0, 0.0670396,-0.0414797) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619511,0.014539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465395,-0.00429969) , 
1, 0.527824, 1, 0, 0.562879,0.0198083) , 
3, -1.17493, 1, 0, 0.491219,0.0109508)    );
  // itree = 338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.790633,0.0670897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393315,-0.0164788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796014,0.015393) , 
2, 0.887236, 1, 0, 0.479043,-0.0239988) , 
1, -1.83103, 1, 0, 0.488184,-0.0180027)    );
  // itree = 339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369405,0.018415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52809,-0.0554531) , 
3, -0.311076, 1, 0, 0.48321,-0.0775231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516573,0.0115104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439524,-0.00969725) , 
1, 0.0802196, 1, 0, 0.471457,-0.0028887) , 
1, -1.17388, 1, 0, 0.473202,-0.0139718)    );
  // itree = 340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0260588,-0.0216027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251242,0.031032) , 
3, -1.69362, 1, 0, 0.172698,0.0352041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335791,-0.0223949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723287,0.00517925) , 
3, -0.00582307, 1, 0, 0.61209,-0.0115471) , 
3, -0.774089, 1, 0, 0.511048,-0.000796235)    );
  // itree = 341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320743,-0.0533579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333831,0.000780887) , 
1, -0.940219, 1, 0, 0.331449,-0.0258863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.777477,0.0186026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816219,-0.0102351) , 
2, 1.28141, 1, 0, 0.786359,0.0285943) , 
3, 0.34753, 1, 0, 0.551358,0.00045031)    );
  // itree = 342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303567,0.0236717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31251,-0.0423398) , 
2, -0.736531, 1, 0, 0.308629,-0.0434238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54858,0.065967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748724,-0.00482738) , 
3, 0.254554, 1, 0, 0.710151,0.020244) , 
2, 0.0207206, 1, 0, 0.503543,-0.0125171)    );
  // itree = 343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294115,0.00751515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417657,0.113772) , 
1, 0.897865, 1, 0, 0.323757,0.0675578) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312702,-0.0172155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774025,0.0118208) , 
3, 0.418498, 1, 0, 0.539459,-0.0115669) , 
0, -1.79098, 1, 0, 0.51176,-0.0014063)    );
  // itree = 344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46544,-0.0459418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504185,-0.0116452) , 
1, -1.66016, 1, 0, 0.496847,-0.0430143) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0420997,-0.0521171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549608,0.015227) , 
2, -1.49842, 1, 0, 0.498003,0.024575) , 
1, -0.565578, 1, 0, 0.497699,0.0068256)    );
  // itree = 345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476805,0.0452939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2505,-0.0141029) , 
1, -1.42554, 1, 0, 0.264584,-0.0195914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72953,0.0567544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646671,0.00176292) , 
0, -0.18957, 1, 0, 0.662648,0.0272488) , 
2, -0.223112, 1, 0, 0.492238,0.00719658)    );
  // itree = 346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466869,0.00955048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496875,0.0517604) , 
1, 1.39008, 1, 0, 0.469429,0.0308182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340575,-0.0370573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.840005,-0.000404193) , 
3, 1.07352, 1, 0, 0.655917,-0.0394948) , 
0, 0.724078, 1, 0, 0.533176,0.00678299)    );
  // itree = 347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332302,0.0125677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808156,0.0518414) , 
2, -0.231952, 1, 0, 0.397837,0.0437404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505852,-0.0417799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703917,0.00715159) , 
0, 0.369653, 1, 0, 0.639642,-0.0186839) , 
2, 0.0207206, 1, 0, 0.532414,0.00899822)    );
  // itree = 348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433205,-0.00858445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595043,0.0226724) , 
0, 0.966713, 1, 0, 0.452476,-0.0107234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385609,-0.0435119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.863586,-0.00690491) , 
3, 1.55017, 1, 0, 0.692027,-0.0578509) , 
0, 1.44235, 1, 0, 0.499228,-0.0199212)    );
  // itree = 349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526986,0.0224155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410831,-0.00933789) , 
1, 0.581975, 1, 0, 0.488857,0.026479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372686,-0.0249381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.893791,0.00557813) , 
3, 1.55017, 1, 0, 0.624299,-0.0334539) , 
0, 1.17659, 1, 0, 0.520868,0.0123145)    );
  // itree = 350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0537033,-0.0395853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0726706) , 
1, 1.27336, 1, 0, 0.0388926,-0.0767196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614723,0.0145856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415328,-0.0425013) , 
1, 1.96083, 1, 0, 0.60711,0.029793) , 
2, -1.51657, 1, 0, 0.547823,0.0186797)    );
  // itree = 351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20832,0.0118507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0444735,-0.0489244) , 
0, -2.65422, 1, 0, 0.108442,-0.0332876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711187,0.0287792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540988,0.000589241) , 
1, -1.46132, 1, 0, 0.55833,0.00819217) , 
3, -1.15439, 1, 0, 0.491236,0.0020061)    );
  // itree = 352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303338,-0.0169293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814234,0.00478923) , 
3, 0.661338, 1, 0, 0.453004,-0.0286701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520236,0.0645841) , 
1, 1.94792, 1, 0, 0.455738,-0.0206743)    );
  // itree = 353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210326,-0.0311531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668314,0.0241497) , 
0, -2.44728, 1, 0, 0.624006,0.0452033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435423,-0.0286347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48001,-0.000584188) , 
1, -0.173238, 1, 0, 0.470573,-0.0188849) , 
1, -0.545188, 1, 0, 0.515323,-0.000193248)    );
  // itree = 354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271012,0.0292426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468586,-0.0143389) , 
2, -1.25004, 1, 0, 0.438669,-0.0202764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.739578,0.018787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732724,-0.0256189) , 
0, 3.321, 1, 0, 0.738847,0.0302923) , 
0, 1.12719, 1, 0, 0.512398,-0.00785581)    );
  // itree = 355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13738,-0.0244782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196581,-0.0560771) , 
0, -1.99505, 1, 0, 0.160496,-0.0972214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557162,0.00744337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577143,-0.0532304) , 
0, 3.17191, 1, 0, 0.557785,0.012531) , 
2, -1.08782, 1, 0, 0.499508,-0.00356803)    );
  // itree = 356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485683,-0.061357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548392,0.00708682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397692,-0.0180802) , 
1, 0.667306, 1, 0, 0.503878,-0.00215491) , 
1, -1.87835, 1, 0, 0.503245,-0.00826603)    );
  // itree = 357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0715926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251467,-0.0158344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.785217,0.00804467) , 
3, 0.0897681, 1, 0, 0.516021,-0.0107936) , 
0, -3.15852, 1, 0, 0.498916,-0.0153133)    );
  // itree = 358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414249,0.0175364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285696,-0.0193051) , 
1, 0.536509, 1, 0, 0.37258,0.0114923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352301,-0.0448143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611356,-0.010891) , 
0, 0.15097, 1, 0, 0.566164,-0.046226) , 
0, -0.213974, 1, 0, 0.476392,-0.0194599)    );
  // itree = 359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354875,0.0509555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641417,0.00698072) , 
2, -0.614672, 1, 0, 0.576699,0.0367474) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169485,-0.020199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.817141,0.0177922) , 
3, 0.408103, 1, 0, 0.454349,-0.00862768) , 
1, 0.237261, 1, 0, 0.519958,0.0157043)    );
  // itree = 360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430809,0.0134902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.859215,0.0611216) , 
0, -0.376131, 1, 0, 0.695695,0.0769564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465844,-0.020664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462896,0.00696717) , 
1, 0.593889, 1, 0, 0.464889,-0.0265452) , 
1, -1.52075, 1, 0, 0.48326,-0.0183071)    );
  // itree = 361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556211,-0.0105747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49946,0.0215433) , 
1, -0.556492, 1, 0, 0.522322,0.0184127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357323,-0.0502887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459587,-0.00450313) , 
1, 0.933175, 1, 0, 0.421371,-0.0490299) , 
1, 0.527824, 1, 0, 0.488217,-0.00437196)    );
  // itree = 362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333166,0.0306281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538868,-0.010943) , 
0, -1.72297, 1, 0, 0.504729,-0.0123445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343975,0.0344854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696597,0.00701995) , 
2, 0.114479, 1, 0, 0.502191,0.0461946) , 
1, 0.560452, 1, 0, 0.503999,0.00449161)    );
  // itree = 363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0723192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129231,0.00708219) , 
2, -1.28449, 1, 0, 0.0535977,-0.0425334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614879,0.0746167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533862,-0.00146429) , 
2, -1.28111, 1, 0, 0.537583,0.00610078) , 
3, -1.25675, 1, 0, 0.472231,-0.000466245)    );
  // itree = 364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53826,-0.00791697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460032,0.0198833) , 
1, 0.971719, 1, 0, 0.523456,-0.00687713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579476,0.0502069) , 
1, 1.96083, 1, 0, 0.52521,-0.00193657)    );
  // itree = 365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.03857,-0.0439482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755228,0.0189189) , 
3, -1.27924, 1, 0, 0.63168,0.0265972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444355,-0.0221049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510366,-0.00129512) , 
1, 0.403731, 1, 0, 0.475732,-0.0310632) , 
1, -0.527309, 1, 0, 0.525868,-0.012526)    );
  // itree = 366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136481,-0.0167125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471073,-0.0393052) , 
3, -0.696754, 1, 0, 0.236146,-0.0631576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567464,0.00816772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671376,-0.0209376) , 
0, 2.19811, 1, 0, 0.581368,0.00948448) , 
0, -1.11562, 1, 0, 0.487218,-0.0103267)    );
  // itree = 367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.707339,0.053149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886068,0.00519267) , 
2, 1.21777, 1, 0, 0.746181,0.097622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236339,0.00780085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50999,-0.0190977) , 
2, -1.026, 1, 0, 0.465218,-0.038936) , 
1, -1.21471, 1, 0, 0.501994,-0.0210618)    );
  // itree = 368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103185,-0.0603883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159225,0.0240543) , 
1, -0.397332, 1, 0, 0.127029,-0.0791887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547946,0.00947722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487066,-0.0122039) , 
1, 0.806267, 1, 0, 0.533705,0.00945068) , 
0, -2.09317, 1, 0, 0.483256,-0.00154526)    );
  // itree = 369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322807,-0.00774485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395362,-0.0396152) , 
0, -0.815122, 1, 0, 0.347962,-0.0479221) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51049,0.0421358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65288,-0.00142881) , 
2, -0.0857811, 1, 0, 0.633814,0.0127858) , 
0, 0.0835435, 1, 0, 0.47917,-0.0200568)    );
  // itree = 370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235985,0.0383188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309105,-0.0185989) , 
0, -2.84673, 1, 0, 0.301044,-0.0307845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64872,-0.0123313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780749,0.0218514) , 
1, -0.438016, 1, 0, 0.731895,0.0211028) , 
2, 0.185719, 1, 0, 0.491147,-0.0078904)    );
  // itree = 371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349367,-0.0484883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69515,0.00590001) , 
2, 0.570039, 1, 0, 0.497995,-0.0865536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372686,0.00126178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660546,0.0184181) , 
0, 0.0835435, 1, 0, 0.504392,0.0209862) , 
1, -1.69005, 1, 0, 0.503959,0.0137172)    );
  // itree = 372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299152,-0.0173592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611609,0.00550946) , 
0, -0.701588, 1, 0, 0.484297,-0.00710564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3405,0.060092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529454,0.00761469) , 
0, -1.01235, 1, 0, 0.47407,0.0522106) , 
1, 1.14, 1, 0, 0.482778,0.00170595)    );
  // itree = 373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578387,0.0291043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.932053,-0.0110627) , 
3, 1.12384, 1, 0, 0.667824,0.0438692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502306,-0.0120501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453401,0.00198261) , 
1, 0.0687235, 1, 0, 0.4727,-0.00836628) , 
1, -1.17388, 1, 0, 0.49218,-0.00315154)    );
  // itree = 374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361005,0.00616846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651307,-0.010446) , 
2, 0.113077, 1, 0, 0.50683,-0.00553224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0765535,-0.0584748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49251,-0.0146088) , 
0, -1.62521, 1, 0, 0.382985,-0.0685981) , 
1, 1.39008, 1, 0, 0.494553,-0.011784)    );
  // itree = 375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277215,-0.016294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32859,0.0292119) , 
1, -0.275778, 1, 0, 0.308416,0.0231964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427871,-0.0229193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728464,0.00723148) , 
2, 0.569382, 1, 0, 0.555625,-0.0263821) , 
0, -0.995569, 1, 0, 0.478073,-0.0108289)    );
  // itree = 376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256876,0.0129025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468064,-0.0143422) , 
0, -1.799, 1, 0, 0.425798,-0.0226011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.903726,-0.00432396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.952694,0.0299647) , 
3, 2.15886, 1, 0, 0.931418,0.0253616) , 
3, 1.73863, 1, 0, 0.480932,-0.0173712)    );
  // itree = 377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320128,-0.000733485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841719,0.0132312) , 
3, 0.6063, 1, 0, 0.495489,0.00799863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718181,-0.0371382) , 
0, 2.97343, 1, 0, 0.501433,0.00538702)    );
  // itree = 378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373324,0.0310226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646242,-0.00125659) , 
2, -0.448113, 1, 0, 0.557145,0.0213054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401559,-0.0150826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778299,0.0144227) , 
0, 1.77235, 1, 0, 0.448889,-0.0226696) , 
1, 0.187385, 1, 0, 0.509588,0.00198718)    );
  // itree = 379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545932,-0.0112195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482874,-0.0751264) , 
1, -1.76877, 1, 0, 0.52227,-0.0798946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.668157,0.0339642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443151,-0.00910521) , 
1, -0.709817, 1, 0, 0.481355,-0.00441633) , 
1, -1.52075, 1, 0, 0.485057,-0.0112452)    );
  // itree = 380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.774529,0.0436473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556614,0.00708529) , 
1, -1.77138, 1, 0, 0.578632,0.0249106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370645,-0.0418162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515943,0.00536381) , 
1, 0.267002, 1, 0, 0.478433,-0.0188702) , 
1, -0.133281, 1, 0, 0.519963,-0.000723913)    );
  // itree = 381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55871,-0.000566971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512772,-0.0415576) , 
2, 0.522398, 1, 0, 0.532547,-0.0562067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227236,-0.00250693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615709,0.0141511) , 
2, -0.55359, 1, 0, 0.497058,0.0219252) , 
1, -1.67887, 1, 0, 0.499049,0.0175435)    );
  // itree = 382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0552023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437416,0.0247083) , 
3, -2.21269, 1, 0, 0.400702,0.0470236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287194,-0.00814667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834896,0.0141647) , 
3, 0.49423, 1, 0, 0.613534,0.0102307) , 
0, -0.608449, 1, 0, 0.530039,0.0246648)    );
  // itree = 383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222795,-0.00749795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539301,0.0197626) , 
0, -1.26504, 1, 0, 0.439551,0.0281991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562069,-0.0384042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.922323,0.0151933) , 
3, 1.42545, 1, 0, 0.770029,-0.0285022) , 
2, 0.771258, 1, 0, 0.519506,0.014481)    );
  // itree = 384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363707,0.0150033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.945614,0.0676711) , 
2, 0.715424, 1, 0, 0.398912,0.0405093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.776751,0.0282049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623487,-0.0101038) , 
1, -1.17388, 1, 0, 0.647169,-0.010521) , 
0, 0.397648, 1, 0, 0.497346,0.0202756)    );
  // itree = 385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281657,-0.000969077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668478,0.0236306) , 
2, -0.253871, 1, 0, 0.421244,0.0199762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384396,-0.0155748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.864986,-0.00257702) , 
3, 1.12564, 1, 0, 0.636089,-0.0221765) , 
0, 0.394028, 1, 0, 0.514499,0.00167963)    );
  // itree = 386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24937,0.038177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.077129,-0.0282373) , 
1, 0.95965, 1, 0, 0.20882,0.0352151) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263854,0.0328956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506903,-0.0143483) , 
2, -1.05178, 1, 0, 0.493678,-0.0324682) , 
2, -1.31454, 1, 0, 0.462784,-0.0251279)    );
  // itree = 387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.472631,0.00930277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655427,-0.0271802) , 
2, 0.973129, 1, 0, 0.50424,0.00630735) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0336112,-0.0335101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324669,-0.0528459) , 
2, -0.925344, 1, 0, 0.232969,-0.120559) , 
1, 1.44003, 1, 0, 0.477531,-0.00618398)    );
  // itree = 388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878404,0.0671618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479429,-0.00201978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.890037,0.0285693) , 
2, 1.43186, 1, 0, 0.511537,0.000430263) , 
1, -1.65097, 1, 0, 0.524167,0.00505654)    );
  // itree = 389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.820199,0.0645153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47794,0.000895011) , 
1, -1.57907, 1, 0, 0.491947,0.00753007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236593,-0.048179) , 
1, 1.78879, 1, 0, 0.478032,0.00040807)    );
  // itree = 390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524523,-0.0163517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486958,0.00976549) , 
1, -0.531176, 1, 0, 0.499058,0.00145786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.088169,-0.0579416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788059,0.0103104) , 
3, 0.40204, 1, 0, 0.319051,-0.0736336) , 
1, 1.48646, 1, 0, 0.483582,-0.00499805)    );
  // itree = 391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300012,-0.00604299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347801,0.0342433) , 
0, -0.338339, 1, 0, 0.309205,0.004838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618019,-0.0318456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851606,0.0216578) , 
2, 0.919375, 1, 0, 0.708613,-0.0283184) , 
3, 0.268003, 1, 0, 0.498765,-0.0108981)    );
  // itree = 392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366109,-0.0487153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0731259) , 
1, 0.698346, 1, 0, 0.0166188,-0.08123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308498,0.0136829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607158,-0.00407796) , 
2, -0.460223, 1, 0, 0.514886,0.00357508) , 
2, -1.85475, 1, 0, 0.485648,-0.00140132)    );
  // itree = 393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164957,-0.0735885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644806,-0.00476246) , 
0, -0.968751, 1, 0, 0.493649,-0.0755382) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402873,0.0142474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684681,-0.00558127) , 
2, 0.391241, 1, 0, 0.510043,0.0138582) , 
1, -1.37148, 1, 0, 0.508238,0.00401546)    );
  // itree = 394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410247,-0.0530036) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492922,0.00554136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252535,-0.032515) , 
1, 1.73687, 1, 0, 0.479819,0.00705361) , 
1, -1.99406, 1, 0, 0.47756,0.00102262)    );
  // itree = 395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0142045,-0.0363768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512086,0.0265896) , 
3, -1.62552, 1, 0, 0.394811,0.0472616) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337495,-0.0192929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722707,0.00492441) , 
2, 0.177961, 1, 0, 0.569629,-0.0116829) , 
0, -0.953354, 1, 0, 0.516975,0.00607076)    );
  // itree = 396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615884,0.0276824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460197,0.00272561) , 
1, -0.909516, 1, 0, 0.490044,0.0173984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617102,-0.0388729) , 
0, 2.73674, 1, 0, 0.495795,0.0119876)    );
  // itree = 397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.653525,0.0417612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394969,0.00549082) , 
1, -1.29885, 1, 0, 0.410693,0.0183966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452205,-0.0494952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725547,-0.00711255) , 
2, 0.660249, 1, 0, 0.666443,-0.0392334) , 
2, 0.45817, 1, 0, 0.510838,-0.00416973)    );
  // itree = 398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553148,-0.0373383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.825137,0.0597692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492202,0.000222147) , 
1, -1.30396, 1, 0, 0.512036,0.00643947) , 
1, -1.86762, 1, 0, 0.513575,0.00252907)    );
  // itree = 399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450079,-0.0279662) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233054,-0.0042583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660752,0.0131833) , 
2, -0.55359, 1, 0, 0.521448,0.0172632) , 
1, -1.71361, 1, 0, 0.51765,0.0123756)    );
  // itree = 400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504976,-0.00514879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231591,-0.0765459) , 
1, 1.11181, 1, 0, 0.494294,-0.0186108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502164,0.0771944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545979,-0.00106755) , 
2, -0.486121, 1, 0, 0.532807,0.0567774) , 
1, 1.31207, 1, 0, 0.498646,-0.0100931)    );
  // itree = 401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439858,-0.0461499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285211,-0.0074017) , 
1, -0.871062, 1, 0, 0.319864,-0.0391379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371076,0.0477257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660802,-0.000936888) , 
2, -0.394281, 1, 0, 0.633098,0.00718682) , 
0, -0.0887253, 1, 0, 0.47615,-0.0160244)    );
  // itree = 402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45377,-0.0424656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278133,0.0493572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531633,0.00457118) , 
0, -2.52052, 1, 0, 0.512689,0.0165144) , 
1, -2.27061, 1, 0, 0.510822,0.0116789)    );
  // itree = 403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.662804,0.0132682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451759,-0.00599697) , 
1, -0.721511, 1, 0, 0.501995,-0.00399672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545056,0.0571605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400172,-0.00213222) , 
1, 2.2977, 1, 0, 0.492088,0.0838256) , 
1, 1.60105, 1, 0, 0.501236,0.00273058)    );
  // itree = 404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390884,-0.0259902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338643,0.00525642) , 
1, 0.36327, 1, 0, 0.37127,-0.0365338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.825642,0.0270328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57203,-0.00552415) , 
1, -0.157496, 1, 0, 0.679894,0.0171127) , 
0, 0.397648, 1, 0, 0.496268,-0.0148061)    );
  // itree = 405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451139,-0.0734954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502197,-0.0227266) , 
1, -1.72708, 1, 0, 0.475301,-0.0995779) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520179,0.00915665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413748,-0.0202781) , 
1, 0.666281, 1, 0, 0.486415,-0.000155208) , 
1, -1.36363, 1, 0, 0.485343,-0.00974469)    );
  // itree = 406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268328,-0.00994783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564832,0.0396455) , 
0, -1.29194, 1, 0, 0.418448,0.0346463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275629,-0.0312043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704005,-0.00493843) , 
2, 0.187528, 1, 0, 0.591001,-0.0274143) , 
0, -0.0887253, 1, 0, 0.509909,0.00175127)    );
  // itree = 407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300213,-0.034242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81075,-0.0194045) , 
0, -0.15754, 1, 0, 0.536858,-0.0716235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557815,0.0107074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488761,0.0309369) , 
1, 0.94987, 1, 0, 0.543542,0.0350624) , 
1, -1.65561, 1, 0, 0.543156,0.0288945)    );
  // itree = 408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210721,0.0213452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651173,0.075225) , 
3, -0.555124, 1, 0, 0.28082,0.070389) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617629,-0.0488393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644978,0.00154635) , 
1, -1.05754, 1, 0, 0.640024,-0.0176788) , 
3, -0.302053, 1, 0, 0.529187,0.00949559)    );
  // itree = 409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152293,-0.0200089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683721,0.0103999) , 
3, -0.707817, 1, 0, 0.530274,0.00574136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140826,-0.0341604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8106,-0.00404223) , 
3, 0.650363, 1, 0, 0.35401,-0.0607192) , 
1, 1.14, 1, 0, 0.499017,-0.00604402)    );
  // itree = 410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0797182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394405,0.0110902) , 
0, -3.32812, 1, 0, 0.372509,0.0170965) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543628,-0.0622762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674895,0.00154734) , 
0, 0.0729472, 1, 0, 0.648465,-0.0291493) , 
2, 0.102157, 1, 0, 0.507632,-0.00554786)    );
  // itree = 411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394193,0.011657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577372,-0.00852193) , 
0, -0.308067, 1, 0, 0.488479,0.002421) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.837994,0.0373134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880654,0.012801) , 
2, 1.51321, 1, 0, 0.859104,0.0651531) , 
0, 2.29217, 1, 0, 0.519534,0.00767727)    );
  // itree = 412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17034,-0.00289007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0981556,-0.0497866) , 
1, -0.206791, 1, 0, 0.124545,-0.0575048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248223,-0.0181787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622458,0.0118342) , 
2, -0.816329, 1, 0, 0.561943,0.0152009) , 
2, -1.40175, 1, 0, 0.52055,0.0083205)    );
  // itree = 413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308325,-0.00988687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631694,0.0189337) , 
0, -0.964434, 1, 0, 0.518699,0.0196393) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489025,-0.04537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915441,0.0121879) , 
3, 2.16337, 1, 0, 0.695775,-0.0599851) , 
0, 2.35263, 1, 0, 0.533705,0.0128918)    );
  // itree = 414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34291,-0.0390029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.935154,0.0153169) , 
3, 0.311558, 1, 0, 0.597683,-0.0672131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214707,0.0239087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50741,-0.00788282) , 
2, -1.01914, 1, 0, 0.454283,-0.00836388) , 
1, -1.37704, 1, 0, 0.466948,-0.0135613)    );
  // itree = 415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238084,-0.000522084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663776,-0.0404084) , 
3, -0.38389, 1, 0, 0.360038,-0.03001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616201,0.0229064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74559,-0.0086598) , 
2, 0.638054, 1, 0, 0.682222,0.0167435) , 
0, -0.416978, 1, 0, 0.547205,-0.00284934)    );
  // itree = 416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462962,0.0279796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645372,-0.0099272) , 
0, 0.0835143, 1, 0, 0.551027,0.0194722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451932,-0.0201258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489025,0.0166121) , 
1, 1.83211, 1, 0, 0.457292,-0.0373558) , 
1, 0.730317, 1, 0, 0.526881,0.00483332)    );
  // itree = 417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.022559,-0.0493469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0773907) , 
1, 1.06622, 1, 0, 0.0138626,-0.105541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329974,0.0181694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586722,-0.00878539) , 
2, -0.541885, 1, 0, 0.52329,-0.00585322) , 
2, -1.77926, 1, 0, 0.485786,-0.0131922)    );
  // itree = 418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527163,-0.00236672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682712,0.0381622) , 
1, 0.961198, 1, 0, 0.540192,0.00296952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0337699,-0.0690755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499026,-0.00988905) , 
0, -1.66581, 1, 0, 0.377935,-0.0665267) , 
1, 1.38085, 1, 0, 0.520462,-0.00548079)    );
  // itree = 419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214619,-0.0213034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718567,0.00362003) , 
3, -0.0426953, 1, 0, 0.473642,-0.0200585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59431,0.0413122) , 
1, 1.61612, 1, 0, 0.478615,-0.0151102)    );
  // itree = 420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190342,0.112708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57985,0.00469059) , 
2, -1.69888, 1, 0, 0.556964,0.016678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166613,-0.0664936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464227,-0.0108971) , 
2, -0.7501, 1, 0, 0.357728,-0.0721889) , 
1, 1.56855, 1, 0, 0.539879,0.00905772)    );
  // itree = 421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17057,0.317704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.882954,0.0492851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50751,-0.00125857) , 
1, -1.94836, 1, 0, 0.517956,0.000448986) , 
2, -2.18697, 1, 0, 0.507836,0.00470301)    );
  // itree = 422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140538,0.00158136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630304,0.0513524) , 
3, -1.00706, 1, 0, 0.245425,0.0307404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230576,-0.0305906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757761,0.00232545) , 
3, 0.343447, 1, 0, 0.515176,-0.0357836) , 
0, -1.56562, 1, 0, 0.471699,-0.0250618)    );
  // itree = 423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274097,0.00771436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456155,-0.0270165) , 
2, -0.509982, 1, 0, 0.367754,-0.0307621) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.66331,0.00864507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670816,-0.0337294) , 
0, 2.83144, 1, 0, 0.663952,0.00906337) , 
0, 0.394028, 1, 0, 0.493059,-0.0139141)    );
  // itree = 424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285821,-0.0553846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420032,0.00650056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646412,-0.0160424) , 
2, 0.456587, 1, 0, 0.510923,-0.00621528) , 
1, -2.21448, 1, 0, 0.503933,-0.0118424)    );
  // itree = 425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632316,0.0688901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805534,0.0185712) , 
2, 0.328678, 1, 0, 0.728751,0.109121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522617,-0.00702802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486788,0.0246817) , 
1, 0.624554, 1, 0, 0.511997,0.00464971) , 
1, -1.41363, 1, 0, 0.528614,0.012659)    );
  // itree = 426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43062,0.0068598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591457,-0.0144684) , 
0, 0.676813, 1, 0, 0.490534,-0.00232356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680763,0.0589031) , 
1, 1.94792, 1, 0, 0.49617,0.00222825)    );
  // itree = 427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191832,-0.00102763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210361,-0.0266339) , 
2, -0.823291, 1, 0, 0.199461,-0.0300472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719504,0.0280081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707436,-0.0107673) , 
0, 1.63576, 1, 0, 0.716509,0.0435627) , 
3, -0.351682, 1, 0, 0.523143,0.016034)    );
  // itree = 428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240819,-0.0061549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394868,-0.0251904) , 
2, -0.746618, 1, 0, 0.316325,-0.0404631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.716404,0.039094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672409,-0.00215259) , 
2, 0.402245, 1, 0, 0.684163,0.0228568) , 
2, 0.0207206, 1, 0, 0.502249,-0.00845801)    );
  // itree = 429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.078169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391433,0.09724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542422,-0.00445579) , 
2, -1.54843, 1, 0, 0.536579,-0.00380385) , 
2, -1.86672, 1, 0, 0.509637,-0.011495)    );
  // itree = 430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185172,-0.0309451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214295,-0.0078537) , 
0, -2.24639, 1, 0, 0.206388,-0.0344319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.755718,0.0609847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660664,0.0016229) , 
2, -0.598841, 1, 0, 0.666082,0.0136847) , 
3, -0.302053, 1, 0, 0.497082,-0.00400465)    );
  // itree = 431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482992,-0.0402498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518339,0.0029828) , 
1, -1.72712, 1, 0, 0.516211,0.000693628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377437,-0.0561445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524604,-0.0097162) , 
1, 1.47883, 1, 0, 0.472414,-0.0651035) , 
1, 1.26914, 1, 0, 0.51037,-0.00808211)    );
  // itree = 432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226781,0.0131804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754322,0.0674597) , 
2, -0.581651, 1, 0, 0.330173,0.0555716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21271,-0.0395507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655973,-0.000447334) , 
2, -0.580878, 1, 0, 0.56178,-0.0228111) , 
0, -1.48672, 1, 0, 0.513687,-0.00653512)    );
  // itree = 433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627441,0.0196465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499883,-0.0171392) , 
1, -1.57725, 1, 0, 0.514153,-0.0311426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45833,0.0311238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790307,-0.0211395) , 
3, 0.952822, 1, 0, 0.563388,0.0352313) , 
1, 0.219717, 1, 0, 0.533845,-0.00459592)    );
  // itree = 434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.013613,-0.0381487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0840316,-0.0444679) , 
3, -1.59196, 1, 0, 0.0510331,-0.0744124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463861,-0.00821002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.772987,0.0149522) , 
2, 0.33989, 1, 0, 0.598153,0.00251332) , 
3, -1.17493, 1, 0, 0.513604,-0.00937444)    );
  // itree = 435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321596,-0.00168745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412561,-0.034967) , 
0, -0.846802, 1, 0, 0.345002,-0.0257247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684611,0.0147061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500574,-0.0233108) , 
1, 1.08782, 1, 0, 0.654215,0.0171487) , 
0, -0.416978, 1, 0, 0.522205,-0.00115485)    );
  // itree = 436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307461,0.00762036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652589,-0.023998) , 
3, 0.160271, 1, 0, 0.454703,-0.0138965) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.795707,0.0146889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816622,0.0611402) , 
1, 0.913195, 1, 0, 0.80055,0.0750907) , 
0, 1.77847, 1, 0, 0.510622,0.000491606)    );
  // itree = 437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133637,-0.043875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281125,-0.00129435) , 
0, -2.34953, 1, 0, 0.190853,-0.0646032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538349,0.00546747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297931,-0.0629549) , 
1, 1.78879, 1, 0, 0.530052,0.00627272) , 
0, -1.78936, 1, 0, 0.4713,-0.00600352)    );
  // itree = 438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25742,0.0194994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484222,-0.0141198) , 
0, -1.78946, 1, 0, 0.449126,-0.0224826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.958477,0.0558272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791659,0.0010502) , 
0, 3.11495, 1, 0, 0.881384,0.0756349) , 
0, 2.59632, 1, 0, 0.473548,-0.016939)    );
  // itree = 439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6871,0.0289426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759423,-0.0714566) , 
0, 1.04809, 1, 0, 0.701897,0.032169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244884,-0.0192134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675106,-0.000653709) , 
2, -0.283978, 1, 0, 0.479989,-0.0207802) , 
1, -0.827015, 1, 0, 0.522687,-0.0105922)    );
  // itree = 440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519825,0.00595259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440285,-0.0126827) , 
1, 0.448091, 1, 0, 0.492969,-0.00111648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23368,-0.0410039) , 
1, 1.94792, 1, 0, 0.482747,-0.00550269)    );
  // itree = 441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64806,0.013758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361354,-0.041398) , 
1, -0.527841, 1, 0, 0.574136,-0.00782688) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481665,0.0155635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628582,-0.0247654) , 
0, 1.92994, 1, 0, 0.498245,0.02466) , 
1, -0.274313, 1, 0, 0.528712,0.011618)    );
  // itree = 442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486499,0.00619041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724739,-0.0245819) , 
2, 1.34534, 1, 0, 0.504079,0.00903737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287703,-0.0640583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309712,-5.76812e-05) , 
1, 1.84825, 1, 0, 0.300676,-0.0809959) , 
1, 1.60105, 1, 0, 0.484591,0.000411224)    );
  // itree = 443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215034,0.0165629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251322,-0.023274) , 
0, -2.42468, 1, 0, 0.24476,-0.04002) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.732407,0.0217381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698584,-0.00688561) , 
0, 0.513971, 1, 0, 0.711895,0.0119704) , 
2, -0.346453, 1, 0, 0.510319,-0.0104642)    );
  // itree = 444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217371,0.0312433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418457,-0.017088) , 
0, -2.63241, 1, 0, 0.402792,-0.0359314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.91813,0.0590475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706853,-0.00780554) , 
0, 0.832857, 1, 0, 0.740954,0.0142182) , 
2, 0.955853, 1, 0, 0.469309,-0.0260668)    );
  // itree = 445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310394,-0.0423651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238124,-0.00484732) , 
1, -0.955784, 1, 0, 0.253316,-0.0355649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.831074,0.0390471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73001,1.88184e-05) , 
2, 0.357191, 1, 0, 0.758832,0.0236645) , 
3, 0.20592, 1, 0, 0.495963,-0.00713483)    );
  // itree = 446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399741,-0.0139623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237983,-0.0358853) , 
1, 0.407578, 1, 0, 0.334622,-0.0536113) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.628377,-0.0193102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672496,0.0208049) , 
1, -0.480148, 1, 0, 0.657719,0.0176611) , 
0, 0.438571, 1, 0, 0.453297,-0.0274326)    );
  // itree = 447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463753,-0.0535003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557548,-0.0171058) , 
1, -1.75587, 1, 0, 0.530977,-0.070147) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230814,0.0181616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500862,-0.00880955) , 
2, -0.962896, 1, 0, 0.456048,-0.0129858) , 
1, -1.02741, 1, 0, 0.469492,-0.0232423)    );
  // itree = 448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0586071,-0.0338019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437614,0.0151394) , 
2, -1.61905, 1, 0, 0.386957,0.0266626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655933,-0.032896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906813,0.00895824) , 
3, 1.47158, 1, 0, 0.768237,-0.0369765) , 
3, 0.742135, 1, 0, 0.508331,0.0064043)    );
  // itree = 449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5407,0.076075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776426,0.0065117) , 
2, -0.0901534, 1, 0, 0.692786,0.0897825) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275734,-0.00963867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715921,0.0122917) , 
2, -0.262393, 1, 0, 0.517286,0.00595061) , 
1, -1.33134, 1, 0, 0.534406,0.0141283)    );
  // itree = 450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565105,0.00144458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418747,-0.0218684) , 
1, -0.232897, 1, 0, 0.481642,-0.0293348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163765,0.0166858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802314,0.0578542) , 
0, -0.971246, 1, 0, 0.450779,0.0799726) , 
1, 1.61612, 1, 0, 0.479695,-0.0224384)    );
  // itree = 451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439639,0.0667569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177185,-0.00039412) , 
1, 0.0225495, 1, 0, 0.285124,0.0597672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184831,-0.0310981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704087,0.00219616) , 
3, -0.0114632, 1, 0, 0.531061,-0.0252529) , 
0, -1.83914, 1, 0, 0.495849,-0.01308)    );
  // itree = 452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672446,0.035947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429557,-0.0715278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475606,0.00294079) , 
1, -1.56741, 1, 0, 0.474329,0.00232674) , 
1, -1.86762, 1, 0, 0.481108,0.00557172)    );
  // itree = 453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326866,0.0154566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60204,-0.00342694) , 
0, -0.686077, 1, 0, 0.508082,0.0043677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182996,-0.0527297) , 
1, 2.41928, 1, 0, 0.498908,-0.0005876)    );
  // itree = 454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498511,-0.00117835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574257,-0.0412107) , 
0, 1.20825, 1, 0, 0.515432,-0.0238135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127415,-0.0312279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498713,0.0211761) , 
0, -2.09951, 1, 0, 0.451871,0.0363671) , 
1, -0.107454, 1, 0, 0.479717,0.0100023)    );
  // itree = 455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288312,0.0116734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625487,-0.0178466) , 
2, -0.458884, 1, 0, 0.539011,-0.0254933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152716,0.000825087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739318,0.0281021) , 
3, -0.218528, 1, 0, 0.478172,0.0361351) , 
1, 0.0932693, 1, 0, 0.510905,0.00297752)    );
  // itree = 456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232744,0.0530497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415973,-0.0180105) , 
2, -1.56098, 1, 0, 0.396534,-0.032651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71083,0.0634108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799657,-0.00253554) , 
3, 0.484018, 1, 0, 0.788616,0.0217724) , 
2, 0.556353, 1, 0, 0.517069,-0.01592)    );
  // itree = 457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.890307,0.0604297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600663,0.0187907) , 
1, -1.90058, 1, 0, 0.727207,0.085841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474782,0.00888053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274708,-0.0260091) , 
1, 1.63101, 1, 0, 0.460432,0.0134427) , 
1, -1.57885, 1, 0, 0.475845,0.0176256)    );
  // itree = 458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126187,-0.0395532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70135,0.0248266) , 
2, -0.521693, 1, 0, 0.250878,-0.0444812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491142,0.0109292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61343,-0.00302857) , 
0, 0.404836, 1, 0, 0.552183,0.00906657) , 
0, -1.28819, 1, 0, 0.47623,-0.00443184)    );
  // itree = 459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0966346,-0.00912244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476487,0.0421403) , 
3, -1.35623, 1, 0, 0.276369,0.0427938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692673,0.0161721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498422,-0.0133367) , 
1, -1.39642, 1, 0, 0.514759,-0.0271558) , 
2, -1.13969, 1, 0, 0.484455,-0.0182638)    );
  // itree = 460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579562,0.057628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728726,0.0186941) , 
2, -0.181663, 1, 0, 0.68653,0.0775913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469407,-0.0104676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475445,0.00560526) , 
1, 0.236537, 1, 0, 0.472287,-0.00666598) , 
1, -1.33134, 1, 0, 0.492033,0.0010997)    );
  // itree = 461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13632,-0.0716483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159268,0.0226004) , 
1, 0.392715, 1, 0, 0.146903,-0.0644622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103199,-0.0116523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658458,0.0128597) , 
3, -0.857055, 1, 0, 0.573575,0.0239526) , 
2, -1.40175, 1, 0, 0.52181,0.0132259)    );
  // itree = 462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480347,-0.0488083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414806,-0.00258588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794093,0.0183982) , 
2, 0.903798, 1, 0, 0.486396,0.00350843) , 
1, -2.0375, 1, 0, 0.486218,-0.000615717)    );
  // itree = 463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425557,0.0274761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599603,-0.00165394) , 
0, -1.20705, 1, 0, 0.554857,0.0137607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402588,-0.0252431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414869,0.0178509) , 
1, 1.53108, 1, 0, 0.404546,-0.0396528) , 
1, 0.0824709, 1, 0, 0.478464,-0.0133859)    );
  // itree = 464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0673184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496461,0.0391953) , 
2, -1.80699, 1, 0, 0.400659,0.0559721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434173,-0.0141882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673,0.00321202) , 
0, 0.596655, 1, 0, 0.538857,-0.0163199) , 
0, -1.05284, 1, 0, 0.504528,0.00163785)    );
  // itree = 465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0316955,-0.045947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560286,0.00475131) , 
2, -1.63862, 1, 0, 0.525637,0.00680808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392878,-0.0408157) , 
1, 2.11264, 1, 0, 0.521554,0.00305611)    );
  // itree = 466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410277,-0.0419864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.970889,0.0439527) , 
3, 0.573822, 1, 0, 0.619243,-0.0575331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.472046,0.00921508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72752,-0.017893) , 
2, 1.33607, 1, 0, 0.494266,0.0164926) , 
1, -1.18093, 1, 0, 0.510421,0.00692374)    );
  // itree = 467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159825,-0.00262164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0422358,-0.0442793) , 
0, -2.75305, 1, 0, 0.0801399,-0.0534966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58859,0.0132931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613305,-0.00503696) , 
0, -0.0333402, 1, 0, 0.60343,0.00623835) , 
3, -1.09475, 1, 0, 0.507061,-0.00476243)    );
  // itree = 468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0777754,-0.0851092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158957,0.0557354) , 
1, 1.02491, 1, 0, 0.0955137,-0.095108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352955,0.0203475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721923,-0.00669804) , 
3, 0.249227, 1, 0, 0.556443,0.013368) , 
2, -1.32053, 1, 0, 0.500509,0.000204254)    );
  // itree = 469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0383288,-0.0546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543852,0.00865943) , 
0, -3.16773, 1, 0, 0.527883,0.0169427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269954,-0.0305238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.921833,0.0349715) , 
3, 1.55329, 1, 0, 0.388058,-0.0380684) , 
1, 1.04982, 1, 0, 0.500234,0.00606474)    );
  // itree = 470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.875548,0.0654265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473937,-0.0109767) , 
1, -1.73036, 1, 0, 0.489139,-0.0198913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15653,0.00329429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695897,0.0307112) , 
3, -0.130169, 1, 0, 0.450046,0.0492418) , 
1, 1.07947, 1, 0, 0.482402,-0.00797665)    );
  // itree = 471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297144,0.0417267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515798,0.00343244) , 
2, -0.747578, 1, 0, 0.454932,0.0283518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305015,-0.0501097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824984,-0.000121749) , 
3, 0.695432, 1, 0, 0.727577,-0.033411) , 
2, 0.758399, 1, 0, 0.5292,0.0115277)    );
  // itree = 472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25454,-0.0408392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713655,-0.0167319) , 
3, 0.101538, 1, 0, 0.481423,-0.0723719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655537,0.0527894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463769,0.000295082) , 
1, -0.229179, 1, 0, 0.483719,0.0118482) , 
1, -0.417903, 1, 0, 0.482888,-0.018613)    );
  // itree = 473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196549,-0.00494921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457874,0.07817) , 
3, -0.415825, 1, 0, 0.245152,0.0205403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439856,-0.0272695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721439,-0.00551688) , 
3, 0.276715, 1, 0, 0.645572,-0.0318504) , 
3, -0.170545, 1, 0, 0.494748,-0.0121167)    );
  // itree = 474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0581907,-0.0146302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480752,0.0724716) , 
2, -1.66152, 1, 0, 0.266072,0.0800661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443258,-0.0240417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489861,-0.00233201) , 
1, -1.48631, 1, 0, 0.485423,-0.0105718) , 
0, -2.64237, 1, 0, 0.471459,-0.00480163)    );
  // itree = 475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495762,0.0578621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2595,0.0187466) , 
1, -0.973267, 1, 0, 0.283438,0.047301) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.789192,0.0551701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603666,-0.00781095) , 
1, -1.69005, 1, 0, 0.614518,-0.0104624) , 
2, -0.55359, 1, 0, 0.519576,0.00610212)    );
  // itree = 476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0554648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503923,0.0821556) , 
3, -1.73839, 1, 0, 0.22625,0.0473646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52908,-0.0053015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432116,-0.0261203) , 
1, 0.560452, 1, 0, 0.498548,-0.0287732) , 
2, -1.35487, 1, 0, 0.475159,-0.0222333)    );
  // itree = 477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363898,-0.0141449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278466,0.0199123) , 
1, 1.38831, 1, 0, 0.357001,-0.0269105) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864936,0.0313576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.881987,0.00843161) , 
3, 1.3348, 1, 0, 0.874457,0.0403978) , 
3, 0.802004, 1, 0, 0.509754,-0.00704116)    );
  // itree = 478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465809,0.0190997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232683,-0.0353156) , 
1, -0.569189, 1, 0, 0.298691,-0.0474064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38606,0.0185906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691283,-0.0028979) , 
3, 0.284124, 1, 0, 0.577687,0.0139577) , 
0, -1.0984, 1, 0, 0.500591,-0.00299931)    );
  // itree = 479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158136,-0.000576834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232092,-0.018467) , 
2, -0.884623, 1, 0, 0.192152,-0.022579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.857023,0.0364513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639801,-0.00429448) , 
0, -0.345165, 1, 0, 0.671505,0.0021322) , 
3, -0.218528, 1, 0, 0.475158,-0.00798971)    );
  // itree = 480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334827,0.000232776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465088,0.0580699) , 
1, 1.11729, 1, 0, 0.355841,0.0201427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553864,-0.0518901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629785,-0.00720818) , 
1, -1.71361, 1, 0, 0.624419,-0.0240154) , 
2, -0.0811742, 1, 0, 0.499502,-0.00347722)    );
  // itree = 481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547578,0.0160535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407287,-0.0102068) , 
1, -0.555995, 1, 0, 0.44262,-0.00769178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50041,0.0502476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846446,0.0122034) , 
3, 0.941922, 1, 0, 0.773639,0.0451781) , 
2, 0.903798, 1, 0, 0.516419,0.00409536)    );
  // itree = 482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0998274,-0.0218602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305461,-0.0651068) , 
3, -0.908486, 1, 0, 0.160667,-0.0789659) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429698,-0.00780647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747278,0.0150169) , 
2, 0.326841, 1, 0, 0.55894,0.00146695) , 
2, -1.026, 1, 0, 0.482009,-0.0140696)    );
  // itree = 483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.052949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331798,0.0476584) , 
3, -2.01909, 1, 0, 0.234368,0.063642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160213,-0.0175977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651021,0.00538612) , 
3, -0.417264, 1, 0, 0.530281,0.00130897) , 
2, -1.32053, 1, 0, 0.495661,0.00860152)    );
  // itree = 484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295191,-0.0240454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.888014,0.0219172) , 
3, 0.0504629, 1, 0, 0.55889,-0.0166585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432336,-0.017676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523399,0.0167332) , 
1, -0.591728, 1, 0, 0.514816,0.033309) , 
1, -0.827015, 1, 0, 0.525583,0.0211027)    );
  // itree = 485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.640313,0.0642655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494591,-0.00434321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225492,-0.0534685) , 
1, 1.92564, 1, 0, 0.48381,-0.0150864) , 
1, -1.67887, 1, 0, 0.491286,-0.00824553)    );
  // itree = 486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254312,-0.0122703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176515,-0.0474492) , 
1, 1.56855, 1, 0, 0.244407,-0.0399353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608144,0.00532826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633573,-0.0427726) , 
0, 3.03279, 1, 0, 0.609293,0.00649804) , 
2, -0.450591, 1, 0, 0.47737,-0.0102897)    );
  // itree = 487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692988,0.035158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504958,-0.0220351) , 
1, -1.7251, 1, 0, 0.550284,-0.023639) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486893,0.00928127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268474,-0.025532) , 
1, 1.77449, 1, 0, 0.471468,0.0159281) , 
1, -0.826718, 1, 0, 0.487596,0.00783187)    );
  // itree = 488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228332,-0.0195105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608752,-0.00150507) , 
2, -0.660692, 1, 0, 0.503825,-0.0143513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612373,0.0439701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221952,-0.0198314) , 
1, 1.91877, 1, 0, 0.479262,0.0527176) , 
1, 1.25419, 1, 0, 0.500973,-0.00656165)    );
  // itree = 489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333551,0.0551235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263546,0.148169) , 
1, 0.187385, 1, 0, 0.298824,0.121216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332672,-0.00946231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854013,0.0141032) , 
3, 0.754934, 1, 0, 0.495849,-0.00629622) , 
0, -2.84999, 1, 0, 0.485896,0.00014535)    );
  // itree = 490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138891,-0.00168111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177686,-0.0413359) , 
3, -0.883082, 1, 0, 0.154024,-0.0350573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627948,0.023828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590643,-0.00251079) , 
0, -0.721787, 1, 0, 0.597315,0.00669539) , 
2, -0.780555, 1, 0, 0.486961,-0.00369868)    );
  // itree = 491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.591127,-0.0103783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356877,-0.0889746) , 
1, -0.942973, 1, 0, 0.558076,-0.0491632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476568,-0.000854932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661844,0.0438776) , 
1, 1.8703, 1, 0, 0.483909,0.00337083) , 
1, -0.83558, 1, 0, 0.500316,-0.00825045)    );
  // itree = 492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431928,0.00136982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645119,-0.0267239) , 
2, 0.809762, 1, 0, 0.474269,-0.00997957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.948399,0.0354268) , 
3, 2.19332, 1, 0, 0.498763,-0.0058041)    );
  // itree = 493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172307,-0.00647655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288937,-0.0406823) , 
3, -0.293086, 1, 0, 0.200133,-0.0396742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.77629,0.0256761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69364,-0.0114567) , 
1, 0.751199, 1, 0, 0.754166,0.0356613) , 
3, -0.0447319, 1, 0, 0.497875,0.000811631)    );
  // itree = 494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506198,0.0149392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362236,-0.0172432) , 
1, -0.227901, 1, 0, 0.416774,-0.0109374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.78521,0.0359705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902123,0.0126739) , 
3, 1.60148, 1, 0, 0.843989,0.0601345) , 
2, 0.702607, 1, 0, 0.521358,0.00646133)    );
  // itree = 495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201955,-0.0261734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412802,0.0151003) , 
2, -1.15797, 1, 0, 0.35947,0.012741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593479,-0.0236258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72242,0.00820439) , 
0, 1.07211, 1, 0, 0.649999,-0.0245891) , 
2, 0.0876493, 1, 0, 0.497741,-0.00502541)    );
  // itree = 496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364895,-0.0941671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3053,0.0025694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706588,-0.0198979) , 
3, 0.337892, 1, 0, 0.497602,-0.0182085) , 
1, -2.21448, 1, 0, 0.494126,-0.0228086)    );
  // itree = 497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570941,0.0103068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617477,0.0295559) , 
1, -0.572648, 1, 0, 0.585373,0.0359431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143196,0.124071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502898,-0.0043914) , 
2, -1.71417, 1, 0, 0.485045,-0.0054887) , 
1, -0.125008, 1, 0, 0.530141,0.0131341)    );
  // itree = 498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0535075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436467,0.0483508) , 
3, -1.7112, 1, 0, 0.272149,0.0593792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263343,-0.0507794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587719,-0.00496609) , 
0, -1.82781, 1, 0, 0.565518,-0.0207682) , 
2, -1.02978, 1, 0, 0.52474,-0.00962794)    );
  // itree = 499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290985,-0.0192045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799463,0.0110996) , 
3, 0.144431, 1, 0, 0.533626,-0.0122552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240854,-0.007577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612131,0.0260888) , 
0, -1.40205, 1, 0, 0.518678,0.0420595) , 
1, -0.187451, 1, 0, 0.524933,0.0193319)    );
  // itree = 500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309659,0.00629254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74412,0.0506536) , 
2, 0.0469658, 1, 0, 0.407667,0.03511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577326,-0.00147968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738349,-0.0327634) , 
2, 1.19409, 1, 0, 0.612588,-0.0170692) , 
0, 0.394028, 1, 0, 0.499374,0.0117587)    );
  // itree = 501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288987,-0.0409532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830848,-0.00499334) , 
3, 0.299361, 1, 0, 0.520712,-0.0653429) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.656492,0.0381868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428718,-0.00382531) , 
1, -0.370326, 1, 0, 0.471537,0.00909627) , 
1, -0.994907, 1, 0, 0.479391,-0.00279195)    );
  // itree = 502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426514,-0.00808696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792671,0.0370234) , 
2, -0.388603, 1, 0, 0.717271,0.0526248) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482154,-0.0114777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595134,0.0483111) , 
1, 1.81614, 1, 0, 0.487737,-0.0195825) , 
1, -1.1416, 1, 0, 0.520657,-0.00922644)    );
  // itree = 503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464953,0.00701809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595276,-0.0199247) , 
0, 0.676813, 1, 0, 0.514058,-0.00698752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0516268,-0.0773592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45121,-0.020119) , 
2, -0.836399, 1, 0, 0.282824,-0.119705) , 
1, 1.47355, 1, 0, 0.493293,-0.0171094)    );
  // itree = 504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33011,-0.0523982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555545,-0.00672797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476439,0.00892199) , 
1, 0.201418, 1, 0, 0.517974,0.000632983) , 
1, -2.21448, 1, 0, 0.510926,-0.00542552)    );
  // itree = 505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596987,0.0285776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754347,-0.0182363) , 
0, 1.17428, 1, 0, 0.634308,0.0381087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457205,-0.00487261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220958,-0.041546) , 
1, 2.19528, 1, 0, 0.447214,-0.0169768) , 
1, -0.733145, 1, 0, 0.493457,-0.00336139)    );
  // itree = 506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17063,0.00535652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3636,-0.0352926) , 
2, -0.9393, 1, 0, 0.240968,-0.0296083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501438,0.073848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558137,0.00947987) , 
0, -1.35266, 1, 0, 0.554466,0.0292313) , 
0, -1.83914, 1, 0, 0.500637,0.0191283)    );
  // itree = 507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290271,0.000616475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571383,0.0670907) , 
0, -1.23013, 1, 0, 0.355276,0.0320939) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580775,-0.0387469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584318,0.000702686) , 
1, -0.706284, 1, 0, 0.583528,-0.0184816) , 
0, -0.82394, 1, 0, 0.503061,-0.00065191)    );
  // itree = 508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450836,-0.00774975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329763,-0.0257571) , 
1, 0.670325, 1, 0, 0.414836,-0.0295075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.912452,0.00841567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.946297,0.0291225) , 
3, 2.21821, 1, 0, 0.924674,0.0261667) , 
3, 1.67591, 1, 0, 0.464201,-0.0241169)    );
  // itree = 509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306717,-0.0625662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.798042,0.0073065) , 
0, -0.0692552, 1, 0, 0.528613,-0.0866074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433108,-0.00395269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.803048,0.0226494) , 
0, 1.92994, 1, 0, 0.479389,-0.000707964) , 
1, -1.52075, 1, 0, 0.483491,-0.00786521)    );
  // itree = 510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.599617,-0.00382857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477059,-0.127416) , 
1, -2.05493, 1, 0, 0.53517,-0.174011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329254,0.0458951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506821,-0.0037635) , 
0, -2.09317, 1, 0, 0.490517,0.00124153) , 
1, -1.67887, 1, 0, 0.492978,-0.00841442)    );
  // itree = 511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514192,0.00789177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680253,0.0444424) , 
1, 0.344909, 1, 0, 0.528267,0.0234108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11068,-0.047918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503563,0.00253328) , 
0, -1.12126, 1, 0, 0.384223,-0.0224882) , 
1, 0.527824, 1, 0, 0.47158,0.00534761)    );
  // itree = 512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651934,0.0184743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447069,-0.00784105) , 
1, -0.687729, 1, 0, 0.50263,-0.00179638) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0288692,-0.0654971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414802,-0.0176676) , 
2, -0.833077, 1, 0, 0.253456,-0.106209) , 
1, 1.61612, 1, 0, 0.481609,-0.0106049)    );
  // itree = 513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417391,-0.0353097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54335,-0.000781199) , 
1, -2.0932, 1, 0, 0.536666,-0.00862535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0961055,-0.00789325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67836,0.0274378) , 
3, -0.582913, 1, 0, 0.468641,0.0388073) , 
1, 0.37474, 1, 0, 0.510124,0.00988198)    );
  // itree = 514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505465,0.00769795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782129,0.0514838) , 
0, -0.81104, 1, 0, 0.692894,0.0858108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421137,-0.0237988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471573,-0.000422567) , 
1, -0.42536, 1, 0, 0.460514,-0.0130534) , 
1, -1.17388, 1, 0, 0.489983,-0.000516399)    );
  // itree = 515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292058,0.0109224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415995,0.0637558) , 
1, 0.978958, 1, 0, 0.318145,0.0444204) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57128,-0.0199111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667819,0.00965867) , 
1, 0.213586, 1, 0, 0.608139,-0.0205646) , 
2, -0.420818, 1, 0, 0.506136,0.00229322)    );
  // itree = 516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120081,0.0254417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308029,-0.0213719) , 
3, -1.3133, 1, 0, 0.266039,-0.037736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.725624,0.0375805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.665479,-0.00480928) , 
0, 0.369653, 1, 0, 0.685973,0.0195637) , 
2, -0.231367, 1, 0, 0.495319,-0.00645095)    );
  // itree = 517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487341,-0.0499161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264541,0.0152986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571579,-0.00748958) , 
2, -0.648681, 1, 0, 0.48242,-0.00422747) , 
1, -1.86762, 1, 0, 0.4826,-0.00865343)    );
  // itree = 518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441638,0.00330338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428429,0.03085) , 
1, 1.04982, 1, 0, 0.439051,0.0196004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461857,-0.0327709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87948,0.00017217) , 
3, 1.24532, 1, 0, 0.681279,-0.0394855) , 
2, 0.45817, 1, 0, 0.520424,-0.000248784)    );
  // itree = 519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.731441,0.0591867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702681,0.010025) , 
1, -1.83187, 1, 0, 0.70673,0.0399303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415696,-0.0215624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41276,0.0133808) , 
1, 1.27528, 1, 0, 0.415243,-0.0386732) , 
1, -0.796883, 1, 0, 0.475705,-0.0223687)    );
  // itree = 520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398424,0.0324521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62532,0.010951) , 
0, -1.69646, 1, 0, 0.584844,0.0324194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0632781,-0.0607321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447914,0.00091256) , 
2, -1.42384, 1, 0, 0.38412,-0.0136117) , 
1, 0.212582, 1, 0, 0.486142,0.00978456)    );
  // itree = 521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.08327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0347179,-0.0448033) , 
1, 0.401148, 1, 0, 0.0187941,-0.0909989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432688,0.0454878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568005,-0.00140046) , 
0, -1.50199, 1, 0, 0.550675,0.0100394) , 
2, -1.86672, 1, 0, 0.519894,0.00419213)    );
  // itree = 522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11724,0.0133117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277875,-0.0561957) , 
3, -1.32989, 1, 0, 0.183561,-0.0706506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.86389,0.0539778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5292,-0.00478666) , 
1, -1.64443, 1, 0, 0.546533,-0.00458129) , 
2, -1.3039, 1, 0, 0.496984,-0.0136004)    );
  // itree = 523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272543,0.0151572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455011,0.0637242) , 
2, -0.854152, 1, 0, 0.315182,0.0548119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0614654,-0.0425751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629053,-0.00202211) , 
3, -0.887072, 1, 0, 0.580841,-0.0115229) , 
2, -0.653044, 1, 0, 0.512885,0.00544565)    );
  // itree = 524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688076,0.0409559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824661,-0.0202066) , 
0, 1.17758, 1, 0, 0.721076,0.0465451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357381,-0.0150044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884324,0.0151575) , 
3, 1.30905, 1, 0, 0.44704,-0.0243052) , 
1, -1.33134, 1, 0, 0.475287,-0.0170023)    );
  // itree = 525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331658,-0.017848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586908,0.0150427) , 
0, 0.348053, 1, 0, 0.368889,-0.0299294) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.714266,-0.0317611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722088,0.0211743) , 
1, -1.68096, 1, 0, 0.721382,0.0384145) , 
2, 0.385083, 1, 0, 0.504847,-0.00356898)    );
  // itree = 526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123037,-0.0140324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698945,0.00842095) , 
3, -0.582913, 1, 0, 0.523243,0.00647089) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608553,0.0888647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367114,-0.00605252) , 
1, 1.75994, 1, 0, 0.465154,0.071046) , 
1, 1.48646, 1, 0, 0.519027,0.0111573)    );
  // itree = 527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.066129,-0.0702021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174879,-0.0238946) , 
1, -0.469065, 1, 0, 0.14161,-0.0779428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575348,0.00297048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459237,-0.0107037) , 
1, 0.0841905, 1, 0, 0.517061,-0.00866192) , 
0, -2.4087, 1, 0, 0.480302,-0.0154449)    );
  // itree = 528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267614,0.00634215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.96604,0.0617009) , 
3, -0.103154, 1, 0, 0.396232,0.0309426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31445,-0.01875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717151,0.00335782) , 
2, 0.0994792, 1, 0, 0.620991,-0.00588611) , 
0, -0.0887253, 1, 0, 0.508395,0.0125636)    );
  // itree = 529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394965,-0.057578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671127,-0.0251142) , 
0, 0.395115, 1, 0, 0.538289,-0.102641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561174,0.010611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398336,-0.0232268) , 
1, 0.439229, 1, 0, 0.496763,-0.00373664) , 
1, -1.37148, 1, 0, 0.500663,-0.0130269)    );
  // itree = 530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371417,0.0274419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173922,-0.0108804) , 
1, 0.699971, 1, 0, 0.291167,0.027908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586972,-0.0188788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.944684,0.0404576) , 
2, 1.79184, 1, 0, 0.615266,-0.0347154) , 
2, -0.351925, 1, 0, 0.498604,-0.0121734)    );
  // itree = 531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544086,-0.0373747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431999,-0.00873614) , 
1, -0.914498, 1, 0, 0.464165,-0.0409454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573143,0.0394464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316573,-0.014056) , 
1, 1.07841, 1, 0, 0.445769,0.0194847) , 
1, 0.527824, 1, 0, 0.45806,-0.0208895)    );
  // itree = 532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.949629,0.0790402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661096,0.0278555) , 
1, -1.92483, 1, 0, 0.704185,0.0717445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163291,-0.0221139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578476,0.0064701) , 
2, -0.936767, 1, 0, 0.478446,0.000727308) , 
1, -0.826718, 1, 0, 0.524958,0.0153601)    );
  // itree = 533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110988,-0.078861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71728,-0.00247041) , 
3, -0.370293, 1, 0, 0.4929,-0.127038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303457,-0.00478607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766966,0.0102553) , 
3, 0.34753, 1, 0, 0.50751,0.00372354) , 
1, -1.48631, 1, 0, 0.506477,-0.00552516)    );
  // itree = 534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155434,-0.0444395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0639857,-0.0172877) , 
1, -1.1269, 1, 0, 0.0826993,-0.0381415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.778896,0.0335319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547048,0.00416002) , 
1, -0.70203, 1, 0, 0.590933,0.0204895) , 
3, -1.19711, 1, 0, 0.510353,0.0111937)    );
  // itree = 535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171187,0.328111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283533,-0.00732557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678332,0.0128547) , 
2, -0.346882, 1, 0, 0.537898,0.0129898) , 
2, -2.03695, 1, 0, 0.52698,0.0169997)    );
  // itree = 536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484122,-0.0440167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.879417,0.0152909) , 
2, 0.993155, 1, 0, 0.613219,-0.0606761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212939,-0.0195083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497092,0.00119213) , 
0, -1.72205, 1, 0, 0.441535,-0.00520626) , 
1, -1.17388, 1, 0, 0.46277,-0.0120672)    );
  // itree = 537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250542,0.0313658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407716,0.0605295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497956,-0.00921134) , 
0, -2.47529, 1, 0, 0.495079,-0.017521) , 
0, -2.98925, 1, 0, 0.482065,-0.0135076)    );
  // itree = 538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.855245,0.0854557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505503,-0.0184184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466534,0.00332119) , 
1, -0.435481, 1, 0, 0.478357,-0.00738308) , 
1, -1.83103, 1, 0, 0.490065,-0.00309048)    );
  // itree = 539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368493,-0.0434402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371415,0.00576499) , 
1, -1.46717, 1, 0, 0.3712,0.00377451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567841,-0.0162205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846504,0.0509663) , 
1, 1.45393, 1, 0, 0.583225,-0.027049) , 
0, -0.0225028, 1, 0, 0.478998,-0.0118967)    );
  // itree = 540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0268563,-0.0513537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0829933,-0.0496992) , 
2, -1.65146, 1, 0, 0.0545088,-0.083587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338874,0.0118906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623433,-0.0113107) , 
2, -0.293376, 1, 0, 0.527127,-0.00758878) , 
0, -2.48942, 1, 0, 0.491744,-0.0132785)    );
  // itree = 541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426721,-0.0195689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.970171,0.0391893) , 
3, 1.49539, 1, 0, 0.501928,-0.0360189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470709,0.0152216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405286,-0.0149239) , 
1, 1.22068, 1, 0, 0.447928,0.00670215) , 
1, 0.0908079, 1, 0, 0.474795,-0.0145533)    );
  // itree = 542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27677,0.0620616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34898,-0.00711963) , 
0, -2.92872, 1, 0, 0.344506,-0.0103603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.887494,0.0807501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861166,0.0189039) , 
3, 0.799241, 1, 0, 0.863495,0.0528598) , 
3, 0.621672, 1, 0, 0.534163,0.0127426)    );
  // itree = 543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467902,-0.0381008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337637,0.0223783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533155,-0.00141751) , 
0, -0.998658, 1, 0, 0.481638,0.00892585) , 
1, -1.86762, 1, 0, 0.481118,0.00510743)    );
  // itree = 544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249145,0.0171482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545384,-0.0110689) , 
2, -0.850838, 1, 0, 0.4971,-0.0170443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298954,0.0436714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663406,0.0106337) , 
3, -0.117632, 1, 0, 0.536366,0.047651) , 
1, 0.531499, 1, 0, 0.509414,0.00324394)    );
  // itree = 545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552448,0.0128282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791825,-0.0371387) , 
2, 1.46189, 1, 0, 0.572821,0.0224083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439872,-0.0260909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443007,0.00629042) , 
1, 0.846691, 1, 0, 0.440947,-0.0346974) , 
1, -0.403847, 1, 0, 0.483515,-0.0162641)    );
  // itree = 546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359099,0.00515521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737452,0.0413425) , 
2, 0.125181, 1, 0, 0.477628,0.0357488) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.745246,0.00319267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478986,-0.0373161) , 
1, 0.692626, 1, 0, 0.669441,-0.0200022) , 
0, 1.19982, 1, 0, 0.523474,0.0224236)    );
  // itree = 547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865973,-0.0104433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583489,0.0187631) , 
3, -1.06369, 1, 0, 0.392431,0.023854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241246,-0.0301788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799863,0.0027671) , 
3, 0.64368, 1, 0, 0.565469,-0.0305974) , 
0, -0.416978, 1, 0, 0.492233,-0.0075516)    );
  // itree = 548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546978,0.00383517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543792,0.0188622) , 
1, -0.149172, 1, 0, 0.545518,0.0238603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205644,0.0310042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553338,-0.0129373) , 
3, -0.621749, 1, 0, 0.475315,-0.0145846) , 
1, 0.826062, 1, 0, 0.528894,0.0147566)    );
  // itree = 549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513381,0.0278595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364221,-0.0160148) , 
1, -1.54245, 1, 0, 0.373106,-0.0317655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.913022,0.0447451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776185,-0.0115996) , 
0, 0.998196, 1, 0, 0.81244,0.0106827) , 
2, 0.820685, 1, 0, 0.465967,-0.0227934)    );
  // itree = 550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295391,-0.0597965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344406,-0.0109495) , 
1, -1.72494, 1, 0, 0.342052,-0.0317938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.786853,0.0241921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644438,-0.00411937) , 
1, 0.219717, 1, 0, 0.734436,0.0289645) , 
2, 0.391241, 1, 0, 0.481544,-0.0101944)    );
  // itree = 551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297368,0.0593438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231818,-0.00534905) , 
2, -1.00064, 1, 0, 0.281451,0.0662006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361543,-0.021166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.827164,0.000441273) , 
3, 0.608371, 1, 0, 0.569758,-0.0308721) , 
2, -0.806007, 1, 0, 0.507277,-0.00983481)    );
  // itree = 552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30132,-0.00336755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354233,-0.048286) , 
2, -0.106216, 1, 0, 0.311362,-0.0290746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692504,0.0274566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731654,-0.00713162) , 
2, 0.707591, 1, 0, 0.715557,0.0151534) , 
2, 0.143877, 1, 0, 0.479807,-0.010643)    );
  // itree = 553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.886426,0.0652762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155229,-0.0225553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685219,0.0131424) , 
3, -0.218528, 1, 0, 0.480576,0.00145357) , 
1, -2.00484, 1, 0, 0.491078,0.00683119)    );
  // itree = 554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338904,-0.0309217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303169,-0.0701768) , 
3, -1.34715, 1, 0, 0.152102,-0.0993498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614803,0.0118836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490335,-0.0121985) , 
1, 0.452007, 1, 0, 0.570038,0.00754221) , 
2, -1.09454, 1, 0, 0.501558,-0.00997223)    );
  // itree = 555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.053985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409819,0.0194811) , 
3, -2.22658, 1, 0, 0.391473,0.0379016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26026,-0.0484099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.822096,0.00472406) , 
3, 0.593848, 1, 0, 0.663055,-0.0313974) , 
2, 0.391241, 1, 0, 0.49696,0.0109847)    );
  // itree = 556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301776,-0.00340492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687686,0.0221172) , 
2, 0.00234669, 1, 0, 0.448904,0.0139043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137383,-0.0472869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.84949,0.00327166) , 
3, 1.07072, 1, 0, 0.701506,-0.0250528) , 
0, 1.20503, 1, 0, 0.509205,0.00460445)    );
  // itree = 557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54441,-0.0021761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410235,-0.0229915) , 
1, 0.285263, 1, 0, 0.490592,-0.0230987) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356118,0.0819294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445243,-0.00193115) , 
0, -0.309275, 1, 0, 0.402113,0.0741159) , 
1, 1.56855, 1, 0, 0.484748,-0.0166772)    );
  // itree = 558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278785,0.00495279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406332,-0.0309898) , 
0, -1.33488, 1, 0, 0.308232,-0.0150051) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502774,0.0354712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616401,0.00878362) , 
0, -0.169484, 1, 0, 0.590782,0.0306608) , 
0, -0.968126, 1, 0, 0.510335,0.017659)    );
  // itree = 559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27464,-0.0109075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0953507,-0.0488885) , 
1, 1.27721, 1, 0, 0.247528,-0.0368646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.686425,0.0330999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677489,-0.00112968) , 
0, -0.231979, 1, 0, 0.679449,0.0128056) , 
2, -0.359466, 1, 0, 0.506658,-0.00706515)    );
  // itree = 560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651819,0.048978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247913,-0.0141975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712303,0.00183108) , 
3, 0.191234, 1, 0, 0.481251,-0.0142828) , 
1, -1.86762, 1, 0, 0.485633,-0.0117533)    );
  // itree = 561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232711,0.00692047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609072,0.0163045) , 
2, -0.421271, 1, 0, 0.46154,0.0271316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601044,-0.055685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.92686,0.0209001) , 
3, 2.04952, 1, 0, 0.780418,-0.0528416) , 
2, 1.4097, 1, 0, 0.483057,0.0217353)    );
  // itree = 562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0403206,0.0024433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510088,0.0402382) , 
3, -1.70587, 1, 0, 0.247716,0.0522207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143923,-0.0324157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624665,-0.00342052) , 
2, -0.90594, 1, 0, 0.556886,-0.0159668) , 
0, -2.03899, 1, 0, 0.516519,-0.00706371)    );
  // itree = 563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183073,0.0226206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575383,0.0567033) , 
3, -0.895693, 1, 0, 0.335637,0.0690742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864938,0.0606796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604544,-0.00902498) , 
0, -1.22373, 1, 0, 0.61852,-0.0135093) , 
2, -0.471788, 1, 0, 0.539072,0.00968441)    );
  // itree = 564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52123,-0.0004621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409219,-0.0231143) , 
1, 1.17354, 1, 0, 0.505756,-0.00941955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557914,0.0585583) , 
1, 1.84641, 1, 0, 0.507313,-0.00549075)    );
  // itree = 565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266455,-0.0017126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446599,-0.0193401) , 
2, -0.494633, 1, 0, 0.357358,-0.0269623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544153,0.03128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813016,0.00180097) , 
3, 0.533324, 1, 0, 0.749465,0.0225897) , 
2, 0.278554, 1, 0, 0.511939,-0.00742741)    );
  // itree = 566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227166,-0.074115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676404,-0.0428355) , 
1, -2.20891, 1, 0, 0.446209,-0.158087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534677,-0.00418229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352345,-0.0300242) , 
1, 0.970497, 1, 0, 0.497718,-0.0211784) , 
1, -1.67887, 1, 0, 0.494916,-0.0286253)    );
  // itree = 567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187327,-0.0137038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614939,0.0112619) , 
3, -0.210351, 1, 0, 0.380309,-0.00259697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38546,-0.0468384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812772,-0.00797828) , 
3, 0.510527, 1, 0, 0.721707,-0.0391396) , 
2, 0.514398, 1, 0, 0.494186,-0.0147861)    );
  // itree = 568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160392,-0.00563129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71955,0.0229601) , 
3, -0.663377, 1, 0, 0.576095,0.0330672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30832,0.00411659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623005,-0.0263505) , 
2, -0.0811742, 1, 0, 0.437472,-0.0189088) , 
1, 0.213586, 1, 0, 0.505759,0.00669536)    );
  // itree = 569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0643938,-0.0363839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505209,0.0155111) , 
2, -1.57951, 1, 0, 0.456847,0.0249845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563635,-0.0891497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851377,0.0031519) , 
1, -0.73929, 1, 0, 0.770295,-0.0504767) , 
2, 1.20333, 1, 0, 0.497321,0.0152406)    );
  // itree = 570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36444,-0.00409196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47513,0.0407071) , 
1, 1.29041, 1, 0, 0.376648,0.00225568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642588,-0.0163489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901687,0.0181512) , 
2, 1.46508, 1, 0, 0.698527,-0.0225126) , 
2, 0.456587, 1, 0, 0.493772,-0.00675695)    );
  // itree = 571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462498,0.0119941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65454,-0.0177418) , 
0, 1.17428, 1, 0, 0.506237,0.0114522) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407522,-0.0187462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830642,0.0155173) , 
2, 1.24893, 1, 0, 0.451981,-0.0306333) , 
1, 0.501006, 1, 0, 0.488196,-0.00254218)    );
  // itree = 572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0943843,-0.0123426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342351,0.0622191) , 
0, -2.70527, 1, 0, 0.238096,0.0550631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218778,-0.0238408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711286,0.010466) , 
3, -0.0778227, 1, 0, 0.517226,-0.00905598) , 
2, -1.40175, 1, 0, 0.488586,-0.00247719)    );
  // itree = 573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239129,0.00525582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773657,0.0657623) , 
2, -0.764278, 1, 0, 0.376697,0.048958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388171,-0.0209658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736698,0.00866519) , 
2, 0.185484, 1, 0, 0.577229,-0.0138471) , 
0, -1.2943, 1, 0, 0.537118,-0.00128473)    );
  // itree = 574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681361,0.0385389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492575,-0.0102246) , 
1, -1.32331, 1, 0, 0.532004,-0.00153638) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166911,-0.0112907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643746,0.034392) , 
2, -0.83084, 1, 0, 0.499036,0.0417033) , 
1, -0.133281, 1, 0, 0.51425,0.0217493)    );
  // itree = 575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522354,0.0271787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308593,-0.0041011) , 
1, 0.400437, 1, 0, 0.430397,0.0329982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62153,-0.0316879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790626,0.00779089) , 
2, 1.06243, 1, 0, 0.709487,-0.026758) , 
2, 0.571732, 1, 0, 0.516362,0.0145922)    );
  // itree = 576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644551,0.0131744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320508,-0.0293428) , 
1, -1.08352, 1, 0, 0.356111,-0.0520525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372466,-0.0359833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633823,0.0151902) , 
0, 0.278611, 1, 0, 0.587853,0.0095223) , 
0, -0.0887253, 1, 0, 0.4797,-0.0192144)    );
  // itree = 577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160703,-0.00322642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643565,0.0299167) , 
3, -0.633764, 1, 0, 0.353081,0.031006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58248,-0.0253307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716527,0.00513563) , 
1, 0.336716, 1, 0, 0.622133,-0.034182) , 
2, 0.0207206, 1, 0, 0.492211,-0.00270359)    );
  // itree = 578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0889115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378959,0.0185762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563694,-0.00383895) , 
0, -0.853006, 1, 0, 0.507121,0.00479358) , 
2, -2.23799, 1, 0, 0.49357,0.00142381)    );
  // itree = 579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.652746,0.0170272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629148,-0.0423724) , 
2, -0.0981541, 1, 0, 0.636262,-0.0546085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544826,0.0166044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417491,-0.00690379) , 
1, -0.0100914, 1, 0, 0.46263,0.00375362) , 
1, -1.05754, 1, 0, 0.488009,-0.00477693)    );
  // itree = 580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491085,-0.0138704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.871594,0.0161833) , 
0, 2.48389, 1, 0, 0.524346,-0.0258088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505343,0.0127714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658931,0.0569803) , 
1, 2.15312, 1, 0, 0.517625,0.0370307) , 
1, 0.550543, 1, 0, 0.52216,-0.00537226)    );
  // itree = 581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635378,0.0162959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331892,-0.0719093) , 
1, -1.8514, 1, 0, 0.458752,-0.0930466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275269,-0.0188406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574835,0.00960359) , 
0, -1.2943, 1, 0, 0.495441,0.00545248) , 
1, -1.52075, 1, 0, 0.492405,-0.0026967)    );
  // itree = 582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198414,-0.0112178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.893931,0.0622747) , 
0, -0.991062, 1, 0, 0.710739,0.0783001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334623,-0.00825692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607432,0.00312639) , 
0, 0.0835435, 1, 0, 0.467425,-0.0056114) , 
1, -1.43208, 1, 0, 0.491302,0.00262302)    );
  // itree = 583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287743,-0.0192404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789372,-0.214505) , 
3, -0.135894, 1, 0, 0.495117,-0.0960082) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444226,-0.0039834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74715,0.0184551) , 
0, 1.69501, 1, 0, 0.487577,-0.000811695) , 
1, -1.48631, 1, 0, 0.488232,-0.0090725)    );
  // itree = 584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544519,-0.0213009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675709,0.0310992) , 
1, -1.5212, 1, 0, 0.62582,0.0273028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20287,0.0208383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507801,-0.0058718) , 
2, -1.0839, 1, 0, 0.459806,-0.00608133) , 
1, -0.827015, 1, 0, 0.495874,0.0011717)    );
  // itree = 585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14941,0.0061566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341108,-0.0278891) , 
2, -1.43889, 1, 0, 0.316147,-0.0573387) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.796503,0.0430997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694248,-0.00630429) , 
1, -1.10448, 1, 0, 0.713247,0.00650522) , 
2, 0.23429, 1, 0, 0.475218,-0.031764)    );
  // itree = 586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0706788,-0.0114236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535476,0.0567135) , 
0, -3.17213, 1, 0, 0.335126,0.067712) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390731,-0.00578764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712256,0.0110218) , 
0, 0.670883, 1, 0, 0.49786,-0.00102703) , 
0, -2.84999, 1, 0, 0.487742,0.00324664)    );
  // itree = 587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104088,-0.0486064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106136,-0.0135224) , 
1, -1.47848, 1, 0, 0.105935,-0.0309971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651892,0.0187834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777097,-0.0100861) , 
2, 0.882736, 1, 0, 0.689214,0.0263123) , 
3, -0.707817, 1, 0, 0.517147,0.00940613)    );
  // itree = 588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0532174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297148,0.055285) , 
3, -2.05135, 1, 0, 0.20921,0.0527266) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224354,-0.0526345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487858,-0.0146156) , 
0, -2.05721, 1, 0, 0.47066,-0.0405771) , 
2, -1.40175, 1, 0, 0.445819,-0.0317122)    );
  // itree = 589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142029,0.223473) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261018,-0.0252817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561121,-0.00572077) , 
0, -1.00181, 1, 0, 0.464944,-0.0260753) , 
2, -2.23799, 1, 0, 0.456334,-0.0223168)    );
  // itree = 590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119236,-0.0416097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527164,0.0156733) , 
2, -1.42697, 1, 0, 0.462899,0.0213995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82222,0.0181543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631571,-0.0355094) , 
1, -1.00275, 1, 0, 0.678075,-0.0549792) , 
2, 0.853718, 1, 0, 0.510098,0.00464591)    );
  // itree = 591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.750433,0.0492197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424813,-0.0324889) , 
1, -1.23937, 1, 0, 0.522362,-0.0198723) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562447,0.0359055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516231,0.0153373) , 
1, -0.241795, 1, 0, 0.521462,0.0356852) , 
1, -0.429674, 1, 0, 0.521745,0.0182196)    );
  // itree = 592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322013,0.00242734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.857307,0.0348032) , 
3, 0.101538, 1, 0, 0.593995,0.038407) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430315,-0.000319542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700861,-0.0444159) , 
0, 2.56595, 1, 0, 0.447188,-0.00683606) , 
1, -0.274313, 1, 0, 0.504304,0.010766)    );
  // itree = 593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49356,0.0490782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216919,0.0140956) , 
1, 0.290288, 1, 0, 0.347881,0.0637124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598682,-0.0224611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678852,0.0145086) , 
1, -0.452168, 1, 0, 0.649705,0.00144755) , 
2, -0.23958, 1, 0, 0.533006,0.0255219)    );
  // itree = 594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218937,0.00513141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591658,0.0955386) , 
2, -0.85228, 1, 0, 0.301657,0.0462146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.861959,0.0289513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579708,-0.0144316) , 
1, -1.44486, 1, 0, 0.605049,-0.0229179) , 
2, -0.648681, 1, 0, 0.518911,-0.00329005)    );
  // itree = 595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221873,0.0162957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232379,-0.0232677) , 
2, -1.18779, 1, 0, 0.228085,-0.0214842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634935,0.025992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751198,0.00283909) , 
2, 0.547636, 1, 0, 0.694926,0.0302337) , 
2, -0.501068, 1, 0, 0.526967,0.0116266)    );
  // itree = 596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245376,0.0117495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31277,-0.0202077) , 
2, -1.03785, 1, 0, 0.296629,-0.0348433) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.837411,0.0394348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.810494,0.00377845) , 
3, 0.796938, 1, 0, 0.81555,0.020746) , 
3, 0.609067, 1, 0, 0.465018,-0.0168047)    );
  // itree = 597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237075,-0.0127398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0641316) , 
3, -0.0690345, 1, 0, 0.318671,-0.0170667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.678675,0.0239079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557662,-0.00140405) , 
1, 0.413135, 1, 0, 0.631541,0.029425) , 
0, -0.331895, 1, 0, 0.489056,0.00825212)    );
  // itree = 598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308893,-0.0516458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2406,-0.00637354) , 
1, -1.09045, 1, 0, 0.254467,-0.0360486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.790126,0.0238656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869396,-0.0276411) , 
2, 1.65941, 1, 0, 0.797202,0.0441461) , 
3, 0.268003, 1, 0, 0.489186,-0.00136647)    );
  // itree = 599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181264,-0.0118605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327696,0.028952) , 
2, -0.248255, 1, 0, 0.212551,-0.00674019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.67961,0.0399003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747443,0.00603641) , 
2, -0.0500774, 1, 0, 0.734192,0.0320089) , 
3, -0.145446, 1, 0, 0.53069,0.0168921)    );
  // itree = 600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258337,0.000284415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597237,0.0559873) , 
2, 0.0660878, 1, 0, 0.303047,0.0181779) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585266,-0.0353494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.785914,0.00141442) , 
2, 0.570036, 1, 0, 0.704191,-0.0322067) , 
3, 0.256412, 1, 0, 0.495676,-0.00601673)    );
  // itree = 601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321731,0.0110126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608769,-0.0128843) , 
2, -0.232395, 1, 0, 0.415772,0.00611102) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.821065,0.0258472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674204,-0.0160398) , 
1, 1.1331, 1, 0, 0.798642,0.0372142) , 
2, 0.566059, 1, 0, 0.531318,0.0154976)    );
  // itree = 602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46931,-0.00203958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761928,-0.0404628) , 
2, 0.764297, 1, 0, 0.548793,-0.0237701) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431312,0.000443339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.892035,0.0308218) , 
2, 1.4209, 1, 0, 0.465278,0.00607326) , 
1, -0.125008, 1, 0, 0.499868,-0.00628734)    );
  // itree = 603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711902,0.100237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825424,0.00295253) , 
0, 0.143348, 1, 0, 0.77507,0.0966039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.643056,-0.0351594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494186,0.000712809) , 
1, -1.18361, 1, 0, 0.502018,-0.00285662) , 
1, -1.40344, 1, 0, 0.521312,0.00417149)    );
  // itree = 604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0919,0.00218238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569362,0.0675516) , 
3, -1.11915, 1, 0, 0.229174,0.0488896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654824,0.0170502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559585,-0.0102287) , 
1, -0.421892, 1, 0, 0.592828,-0.00314287) , 
2, -1.026, 1, 0, 0.536885,0.00486158)    );
  // itree = 605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174292,0.0110032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369526,-0.0281902) , 
3, -0.731009, 1, 0, 0.287187,-0.0337946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.861317,0.0454659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746182,-0.00928844) , 
2, 0.253135, 1, 0, 0.772712,0.0088254) , 
3, 0.31772, 1, 0, 0.477737,-0.017068)    );
  // itree = 606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134599,-0.0144385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637864,0.0368188) , 
3, -0.597488, 1, 0, 0.323719,0.0168588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520864,-0.028232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.92336,0.0166026) , 
3, 1.48472, 1, 0, 0.636096,-0.0416653) , 
2, -0.0811742, 1, 0, 0.493883,-0.0150215)    );
  // itree = 607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414362,-0.0189541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343094,0.0048265) , 
1, 0.550543, 1, 0, 0.394333,-0.02607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.951805,0.0306264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838408,-0.00843552) , 
0, 2.12039, 1, 0, 0.897375,0.0124061) , 
3, 1.18432, 1, 0, 0.500416,-0.017956)    );
  // itree = 608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489536,0.0518982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266981,0.00965443) , 
1, -0.669755, 1, 0, 0.317083,0.0390007) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.746473,0.00120627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58605,-0.0269192) , 
1, 0.107382, 1, 0, 0.6586,-0.0339575) , 
3, 0.191234, 1, 0, 0.481972,0.0037754)    );
  // itree = 609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277058,-0.0004863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721829,0.0390823) , 
2, -0.335215, 1, 0, 0.454707,0.0338515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442358,-0.0299184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.922828,0.0158769) , 
3, 1.47703, 1, 0, 0.642458,-0.0313242) , 
0, 0.683233, 1, 0, 0.523206,0.0100726)    );
  // itree = 610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563931,-0.0673316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239873,-0.0223169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678103,0.0106498) , 
2, -0.425618, 1, 0, 0.522837,-0.00128097) , 
1, -1.64443, 1, 0, 0.524991,-0.00957803)    );
  // itree = 611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152675,-0.0256837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557264,0.0081678) , 
2, -1.02838, 1, 0, 0.479276,0.00532281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421727,-0.0603747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.873748,-0.00160328) , 
3, 1.88344, 1, 0, 0.723993,-0.0583846) , 
0, 2.29217, 1, 0, 0.497979,0.000453988)    );
  // itree = 612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183752,-0.0150163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470347,0.0357635) , 
2, -0.812305, 1, 0, 0.293434,0.0172074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293844,-0.0367955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738462,-0.00758688) , 
3, 0.281624, 1, 0, 0.578064,-0.049234) , 
2, -0.351252, 1, 0, 0.463696,-0.022537)    );
  // itree = 613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369712,-0.000215377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254624,-0.0264275) , 
1, 0.540166, 1, 0, 0.327974,-0.0207722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733221,0.0193154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71688,-0.0271752) , 
0, 2.611, 1, 0, 0.730668,0.0212989) , 
2, 0.185719, 1, 0, 0.478518,-0.00504432)    );
  // itree = 614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519318,0.013811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400134,-0.00884973) , 
1, -0.211126, 1, 0, 0.449931,0.00168023) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44637,-0.051799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793235,-0.00180465) , 
2, 0.91848, 1, 0, 0.630038,-0.0584151) , 
0, 1.05495, 1, 0, 0.495858,-0.0136439)    );
  // itree = 615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366933,0.0220613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726701,-0.00113624) , 
3, 0.311026, 1, 0, 0.527825,0.0224547) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513339,-0.0320678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193925,-0.0578743) , 
1, 2.09124, 1, 0, 0.35422,-0.0962263) , 
1, 1.57547, 1, 0, 0.516528,0.0147319)    );
  // itree = 616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.602059,0.0423605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.905105,0.0137587) , 
3, 0.589369, 1, 0, 0.730989,0.0650796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215196,0.0115974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613862,-0.0179126) , 
3, -0.206128, 1, 0, 0.469606,-0.0198421) , 
1, -1.04839, 1, 0, 0.510142,-0.00667207)    );
  // itree = 617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187013,-0.0173993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358236,-0.0446694) , 
2, -0.709795, 1, 0, 0.247205,-0.0573626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20157,-0.0291479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623528,0.0053524) , 
2, -0.769693, 1, 0, 0.572789,0.000880497) , 
0, -1.28819, 1, 0, 0.502864,-0.0116282)    );
  // itree = 618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633793,-0.00747087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449299,-0.126173) , 
1, -1.3177, 1, 0, 0.5742,-0.0929039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18874,-0.0342353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575527,0.00759218) , 
0, -1.72228, 1, 0, 0.514838,0.0025915) , 
1, -1.13954, 1, 0, 0.523915,-0.0120108)    );
  // itree = 619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0671858,0.00675494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278654,-0.0649889) , 
3, -1.46051, 1, 0, 0.162448,-0.0656505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169727,0.0461877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597798,-0.000521735) , 
3, -0.787633, 1, 0, 0.533326,0.00866175) , 
2, -1.18993, 1, 0, 0.4829,-0.00144198)    );
  // itree = 620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23173,0.00279023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294494,0.0643538) , 
0, -1.44282, 1, 0, 0.255977,0.0431373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4111,-0.0175345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.870562,0.00870818) , 
3, 1.01585, 1, 0, 0.556214,-0.0239239) , 
2, -0.806007, 1, 0, 0.477594,-0.0063631)    );
  // itree = 621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0382033,-0.0953551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394281,-0.00300837) , 
2, -2.27904, 1, 0, 0.38171,-0.0125924) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65621,0.0504945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.881319,0.0016258) , 
3, 1.19411, 1, 0, 0.790883,0.0506978) , 
2, 0.603252, 1, 0, 0.496268,0.0051272)    );
  // itree = 622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137954,0.00219528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43479,0.045902) , 
3, -0.976669, 1, 0, 0.281046,0.0522804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32404,-0.0376295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69702,-0.00438503) , 
3, 0.000640177, 1, 0, 0.647908,-0.0202199) , 
3, -0.231227, 1, 0, 0.501584,0.00869718)    );
  // itree = 623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179574,0.0824857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467426,-0.00276227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744561,-0.0271547) , 
2, 0.979538, 1, 0, 0.517991,-0.0152191) , 
0, -3.22854, 1, 0, 0.505947,-0.0112938)    );
  // itree = 624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269076,0.0131928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578119,-0.0100374) , 
2, -0.458884, 1, 0, 0.487904,-0.00792507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361815,0.0435946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616347,0.00618745) , 
0, -0.417194, 1, 0, 0.522741,0.0366597) , 
1, 0.560452, 1, 0, 0.499152,0.00646944)    );
  // itree = 625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135152,-0.0484456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155652,0.0227068) , 
1, -1.47848, 1, 0, 0.153327,0.00960998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312582,-0.0434532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660261,-0.00442434) , 
3, -0.191445, 1, 0, 0.601854,-0.0316742) , 
3, -0.689919, 1, 0, 0.48526,-0.0209424)    );
  // itree = 626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136209,0.00529355) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268481,-0.0543683) , 
2, -0.857196, 1, 0, 0.18539,-0.0553893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185635,0.0187945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615117,-0.00735172) , 
3, -0.486021, 1, 0, 0.531991,-0.00694215) , 
0, -2.03899, 1, 0, 0.483529,-0.013716)    );
  // itree = 627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578664,0.0164474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570454,-0.0525075) , 
0, -0.995569, 1, 0, 0.572468,-0.0738049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468878,0.00552945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653778,-0.0343838) , 
0, 2.20789, 1, 0, 0.489397,0.00176782) , 
1, -0.827015, 1, 0, 0.507974,-0.015132)    );
  // itree = 628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193079,0.00511987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154498,-0.044842) , 
0, -2.42401, 1, 0, 0.172307,-0.0400713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214495,0.0358304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640962,-0.00218755) , 
3, -0.534685, 1, 0, 0.57171,0.00582823) , 
2, -1.07472, 1, 0, 0.504549,-0.00188996)    );
  // itree = 629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359429,0.00499177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48064,-0.0166151) , 
0, -0.134464, 1, 0, 0.408638,-0.0106895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.734138,-0.003329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885151,0.0427922) , 
1, 0.667116, 1, 0, 0.772255,0.0209156) , 
2, 0.863656, 1, 0, 0.490626,-0.00356318)    );
  // itree = 630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.912875,0.0640619) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400584,-0.0088946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666488,0.00878746) , 
0, 0.676813, 1, 0, 0.489633,-0.00675613) , 
1, -1.90873, 1, 0, 0.504476,-0.00181067)    );
  // itree = 631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250145,-0.00103112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481113,-0.0471439) , 
3, 0.0755653, 1, 0, 0.290301,-0.0217876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.658841,0.027196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661047,-0.00922304) , 
0, 1.36167, 1, 0, 0.659558,0.0286988) , 
2, -0.237487, 1, 0, 0.509813,0.00822504)    );
  // itree = 632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253713,0.00789439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304295,-0.0202359) , 
2, -0.567903, 1, 0, 0.276882,-0.0140986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.806634,0.0620663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734105,0.00515134) , 
2, -0.247487, 1, 0, 0.739268,0.0209792) , 
3, 0.337892, 1, 0, 0.48056,0.00135293)    );
  // itree = 633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145937,-0.00608298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566814,-0.026593) , 
3, -0.662336, 1, 0, 0.330235,-0.0381913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28339,0.0217943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73163,-0.00165369) , 
3, 0.375197, 1, 0, 0.606803,0.0114045) , 
0, -0.251429, 1, 0, 0.481054,-0.0111456)    );
  // itree = 634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368279,-0.0540844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838855,0.0212699) , 
0, 0.143752, 1, 0, 0.536666,-0.0895453) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388404,-0.0114949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790915,0.0163968) , 
2, 0.897689, 1, 0, 0.46351,-0.0137093) , 
1, -1.36363, 1, 0, 0.471359,-0.0218456)    );
  // itree = 635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156271,-0.059161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605277,-0.000621987) , 
0, -2.59984, 1, 0, 0.567832,-0.00864137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317317,0.0426844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627685,0.00197745) , 
2, -0.486121, 1, 0, 0.501693,0.0339392) , 
1, 0.157686, 1, 0, 0.537957,0.0105923)    );
  // itree = 636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.720668,0.0398316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636162,-0.0317597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469284,0.00812234) , 
1, -1.20479, 1, 0, 0.481176,0.0108093) , 
1, -1.70534, 1, 0, 0.49134,0.0142518)    );
  // itree = 637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.809447,0.0535067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501178,-0.00636934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504598,0.0238686) , 
1, 0.920952, 1, 0, 0.501865,-0.000808501) , 
1, -1.90873, 1, 0, 0.509533,0.0032052)    );
  // itree = 638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.645332,0.01315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.985097,0.0857912) , 
1, -1.53032, 1, 0, 0.749391,0.0730805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462177,-0.0149064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488357,0.00729504) , 
1, -0.463309, 1, 0, 0.483016,0.00411063) , 
1, -1.21471, 1, 0, 0.511166,0.0113993)    );
  // itree = 639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.60387,-0.00620521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392323,-0.0547411) , 
1, -0.706093, 1, 0, 0.568196,-0.0349313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.701275,0.0871712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478495,0.00826229) , 
1, -0.368735, 1, 0, 0.496354,0.0316088) , 
1, -0.589204, 1, 0, 0.515071,0.0142731)    );
  // itree = 640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556317,-0.00600353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604962,0.0263147) , 
1, -0.271148, 1, 0, 0.568325,0.00585615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175321,-0.0301766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756997,-0.00547474) , 
3, 0.385939, 1, 0, 0.397041,-0.0485746) , 
1, 0.219717, 1, 0, 0.48726,-0.0199049)    );
  // itree = 641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190332,-0.0283618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645583,-0.0125948) , 
3, -0.260982, 1, 0, 0.48073,-0.0433457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461468,-0.000472595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443172,-0.0181432) , 
1, 1.26503, 1, 0, 0.455544,-0.013108) , 
1, 0.212582, 1, 0, 0.469883,-0.030323)    );
  // itree = 642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964325,0.00789386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195113,-0.0210287) , 
3, -1.26016, 1, 0, 0.14459,-0.0212104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593952,0.0201566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729507,-0.00996891) , 
2, 0.887322, 1, 0, 0.63763,0.0252831) , 
3, -0.796906, 1, 0, 0.501073,0.0124059)    );
  // itree = 643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0548926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326669,0.0426222) , 
3, -2.27411, 1, 0, 0.277344,0.05644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268376,-0.0308537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683867,-0.00362006) , 
2, -0.272278, 1, 0, 0.560448,-0.029113) , 
0, -1.40205, 1, 0, 0.507357,-0.0130689)    );
  // itree = 644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230065,-0.043749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259278,0.0104182) , 
1, 0.670325, 1, 0, 0.239043,-0.0662907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.702719,-0.0182473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638481,0.0123863) , 
1, -1.03659, 1, 0, 0.650123,0.0154536) , 
2, -0.55359, 1, 0, 0.512766,-0.0118602)    );
  // itree = 645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189865,-0.014875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601884,0.00840974) , 
3, -0.436575, 1, 0, 0.413427,-0.00375949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516051,-0.0601889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.866889,-0.00404509) , 
3, 1.03733, 1, 0, 0.764371,-0.05025) , 
2, 0.863656, 1, 0, 0.48026,-0.0126129)    );
  // itree = 646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237657,0.00225868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469991,-0.026128) , 
2, -0.73659, 1, 0, 0.372969,-0.0360624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818671,0.03048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65041,-0.00392957) , 
1, -0.519269, 1, 0, 0.696304,0.0102298) , 
0, 0.449965, 1, 0, 0.502305,-0.0175454)    );
  // itree = 647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394928,0.00632145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818234,0.0455402) , 
2, 0.379789, 1, 0, 0.44247,0.0236757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.755737,0.0170655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499535,-0.028756) , 
1, -0.480148, 1, 0, 0.568559,-0.0404379) , 
0, 0.220525, 1, 0, 0.501703,-0.00644314)    );
  // itree = 648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560572,-0.0473044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505771,0.0061639) , 
1, -1.48025, 1, 0, 0.510511,0.00580403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129076,-0.0556804) , 
1, 2.14513, 1, 0, 0.499164,0.000806486)    );
  // itree = 649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.815621,0.0167758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49738,-0.022715) , 
1, -1.90641, 1, 0, 0.53606,-0.036496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275769,-0.00735905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660531,0.0188984) , 
2, -0.403065, 1, 0, 0.508603,0.0185652) , 
1, -0.715629, 1, 0, 0.515896,0.0039404)    );
  // itree = 650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169681,0.137104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510771,-0.0398879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477745,-0.00606139) , 
1, -1.52075, 1, 0, 0.48008,-0.016952) , 
2, -1.97084, 1, 0, 0.469727,-0.0124184)    );
  // itree = 651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860709,-0.0188511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354464,0.033622) , 
2, -1.87782, 1, 0, 0.245224,0.0306192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.075767,-0.0328092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603216,-0.000627739) , 
3, -0.896819, 1, 0, 0.516861,-0.0102234) , 
2, -1.3039, 1, 0, 0.488184,-0.00591163)    );
  // itree = 652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502911,0.0162842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2853,-0.0181288) , 
1, -0.826718, 1, 0, 0.331631,-0.0240494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878542,0.0322625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773453,-0.00957823) , 
0, 2.14123, 1, 0, 0.844272,0.0323399) , 
3, 0.834918, 1, 0, 0.484399,-0.00724526)    );
  // itree = 653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.073473,-0.0354468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628687,0.016187) , 
3, -1.19319, 1, 0, 0.52879,0.0160409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441153,-0.0243693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415721,0.00360053) , 
1, 0.878864, 1, 0, 0.43228,-0.0345731) , 
1, -0.515522, 1, 0, 0.461114,-0.0194514)    );
  // itree = 654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453985,-0.00127679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779836,0.0208412) , 
0, 1.77847, 1, 0, 0.502318,0.00574808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148147,-0.0776144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479894,0.0259472) , 
1, 1.84825, 1, 0, 0.312139,-0.0955727) , 
1, 1.61612, 1, 0, 0.487293,-0.00225677)    );
  // itree = 655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0141584,-0.0323331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374805,0.0468132) , 
3, -1.62697, 1, 0, 0.277852,0.0616226) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37882,0.0443984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632508,0.00276628) , 
2, -0.434898, 1, 0, 0.604177,0.0142472) , 
2, -0.708336, 1, 0, 0.520051,0.0264604)    );
  // itree = 656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392847,0.0813163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646571,0.00541391) , 
2, -0.780555, 1, 0, 0.603754,0.0336681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504258,0.0155683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421309,-0.0100509) , 
1, 0.485763, 1, 0, 0.451583,-0.000342017) , 
1, -0.107454, 1, 0, 0.515269,0.0138917)    );
  // itree = 657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0305206,-0.0737903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543203,-0.00374727) , 
0, -3.10874, 1, 0, 0.512251,-0.0172325) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419455,0.0401012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592046,-0.00419412) , 
0, 0.461627, 1, 0, 0.494149,0.0374496) , 
1, 0.213586, 1, 0, 0.504175,0.00716217)    );
  // itree = 658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520296,0.0204416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590616,-0.0306708) , 
0, 1.14189, 1, 0, 0.536339,0.020905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488872,-0.0434042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451584,-0.00453304) , 
1, -0.0331137, 1, 0, 0.455068,-0.0184723) , 
1, -0.237385, 1, 0, 0.486792,-0.00310127)    );
  // itree = 659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392819,0.00149366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127849,-0.0808041) , 
3, -1.67681, 1, 0, 0.0906772,-0.116341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475931,0.0016382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809406,0.0275129) , 
2, 0.907663, 1, 0, 0.547008,0.0152781) , 
2, -1.40175, 1, 0, 0.495366,0.000382927)    );
  // itree = 660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316584,0.000617677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647123,0.0915806) , 
0, -0.850984, 1, 0, 0.366411,0.0276622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638684,-0.010377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447888,-0.0550608) , 
1, 1.47355, 1, 0, 0.627737,-0.0302519) , 
0, -0.416978, 1, 0, 0.513933,-0.00503096)    );
  // itree = 661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213278,0.000648098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779851,0.0354233) , 
3, -0.404209, 1, 0, 0.463879,0.0359278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.979188,0.0684665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60458,-0.00795847) , 
1, -1.19986, 1, 0, 0.63912,-0.00231248) , 
0, 0.321785, 1, 0, 0.543588,0.0185341)    );
  // itree = 662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261361,0.0669268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207242,-0.0150273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679108,0.0124144) , 
3, -0.232062, 1, 0, 0.503192,0.00488095) , 
0, -3.22854, 1, 0, 0.494361,0.00859784)    );
  // itree = 663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177328,-0.0119384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425631,-0.0290458) , 
3, -0.216997, 1, 0, 0.248986,-0.0389758) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.751523,-0.00347137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.740793,0.0225097) , 
1, 1.01067, 1, 0, 0.749628,0.00445168) , 
3, 0.322617, 1, 0, 0.471396,-0.0196832)    );
  // itree = 664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0267283,0.00391362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686888,-0.0408964) , 
3, -2.04397, 1, 0, 0.0522754,-0.0428017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588778,0.0158773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463265,-0.00748677) , 
1, 0.843281, 1, 0, 0.56286,0.0215467) , 
2, -1.49842, 1, 0, 0.51376,0.0153587)    );
  // itree = 665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454195,-0.0589899) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666171,0.0293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49152,-0.00319179) , 
1, -0.79126, 1, 0, 0.52607,0.00545791) , 
1, -2.04143, 1, 0, 0.523632,0.00100113)    );
  // itree = 666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207462,-0.00461788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472385,0.0424053) , 
2, -0.84504, 1, 0, 0.302796,0.0313233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.472921,-0.0336351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608275,-0.00785936) , 
0, -0.67655, 1, 0, 0.584569,-0.0281673) , 
2, -0.403065, 1, 0, 0.478939,-0.00586562)    );
  // itree = 667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122583,0.0531888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511599,0.0637747) , 
2, -1.53287, 1, 0, 0.300019,0.0901306) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181889,-0.0189829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652458,0.00724939) , 
3, -0.386395, 1, 0, 0.514209,2.30278e-05) , 
0, -2.84999, 1, 0, 0.501991,0.00516285)    );
  // itree = 668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447353,-0.00674942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320207,-0.0258434) , 
1, 0.843066, 1, 0, 0.418317,-0.0256603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.913162,0.0105947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.944406,0.0381118) , 
3, 2.57811, 1, 0, 0.920859,0.0347536) , 
3, 1.73863, 1, 0, 0.468501,-0.0196273)    );
  // itree = 669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.60191,-0.0208346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527875,0.00757487) , 
1, -1.22372, 1, 0, 0.538239,0.00685431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675527,0.0702884) , 
1, 2.14975, 1, 0, 0.54219,0.0112585)    );
  // itree = 670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0532117,-0.0472131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333144,0.0237517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511671,-0.00812319) , 
0, -1.88774, 1, 0, 0.489275,-0.0105862) , 
0, -3.36771, 1, 0, 0.473185,-0.0130275)    );
  // itree = 671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31548,-0.0156851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63161,0.00603871) , 
0, -0.429465, 1, 0, 0.482344,-0.00971257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543206,0.0253372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242805,-0.0520035) , 
1, 2.27196, 1, 0, 0.518681,0.035914) , 
1, 0.531499, 1, 0, 0.49326,0.00399424)    );
  // itree = 672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460269,-0.0455263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523675,-0.00282108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243993,-0.0367034) , 
1, 2.09085, 1, 0, 0.513878,-0.00820039) , 
1, -2.02435, 1, 0, 0.512075,-0.0114069)    );
  // itree = 673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576514,-0.00207212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505277,0.0187273) , 
1, -0.3157, 1, 0, 0.535787,0.0203131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214154,-0.0173543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566751,-0.0474261) , 
2, -0.0346501, 1, 0, 0.355837,-0.0682844) , 
1, 1.15831, 1, 0, 0.509848,0.00754209)    );
  // itree = 674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.816082,0.0331094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543905,-0.0334811) , 
1, -1.59938, 1, 0, 0.596312,-0.045819) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219685,-0.0199871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553609,0.00888377) , 
0, -1.6198, 1, 0, 0.493515,0.00772887) , 
1, -0.605346, 1, 0, 0.519504,-0.00580895)    );
  // itree = 675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333674,0.0238475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106799,-0.0281518) , 
1, 1.27336, 1, 0, 0.29661,0.0307025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261381,-0.0431429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570869,-0.00474838) , 
0, -0.964342, 1, 0, 0.538892,-0.0211245) , 
0, -1.40205, 1, 0, 0.485683,-0.00974235)    );
  // itree = 676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560191,0.0114136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445423,-0.0197134) , 
1, 0.447741, 1, 0, 0.521855,0.00218067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670667,0.0968876) , 
1, 2.1565, 1, 0, 0.525929,0.00836825)    );
  // itree = 677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429054,-0.00536166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694779,-0.0477095) , 
2, 1.17453, 1, 0, 0.450915,-0.018243) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.905225,0.0576723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.804216,-0.00373858) , 
0, 2.79346, 1, 0, 0.842843,0.0473692) , 
0, 2.56595, 1, 0, 0.476667,-0.0139318)    );
  // itree = 678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52856,0.00501112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227846,-0.0434556) , 
1, 1.50474, 1, 0, 0.51282,0.00421761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496464,0.0939681) , 
1, 1.95373, 1, 0, 0.512301,0.00975787)    );
  // itree = 679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659373,0.0359508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767282,-0.0267695) , 
0, 1.25027, 1, 0, 0.694382,0.0495744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33772,-0.017044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616315,-0.000748428) , 
0, 0.18515, 1, 0, 0.457779,-0.0199756) , 
1, -1.4346, 1, 0, 0.475792,-0.0146805)    );
  // itree = 680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543632,-0.00245092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407357,-0.0507052) , 
1, 0.422154, 1, 0, 0.534122,-0.013818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0550315,-0.033256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624182,0.0330619) , 
3, -0.94217, 1, 0, 0.476602,0.0415344) , 
1, 0.604454, 1, 0, 0.514339,0.00521969)    );
  // itree = 681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20711,-0.0384122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63868,0.00592275) , 
2, -0.954021, 1, 0, 0.57654,-0.000497134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494159,0.0309568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634443,-0.03687) , 
0, 2.3985, 1, 0, 0.503728,0.047796) , 
1, -0.211126, 1, 0, 0.533622,0.0279681)    );
  // itree = 682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395187,-0.00208957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647344,-0.0471354) , 
3, 0.987609, 1, 0, 0.419943,-0.0134913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914605,0.019094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977518,0.0494061) , 
3, 2.75145, 1, 0, 0.923778,0.0418038) , 
3, 1.30905, 1, 0, 0.516165,-0.00293101)    );
  // itree = 683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133044,-0.00659677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309539,-0.0401109) , 
3, -0.501806, 1, 0, 0.167226,-0.0290451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500069,0.0236232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779039,0.000293516) , 
3, 0.445591, 1, 0, 0.651969,0.0252506) , 
2, -0.665484, 1, 0, 0.505666,0.00886333)    );
  // itree = 684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0535928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408868,0.0574341) , 
3, -2.12745, 1, 0, 0.239771,0.0593796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124738,-0.0519067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556153,-0.000745184) , 
0, -2.17517, 1, 0, 0.530806,-0.0096901) , 
0, -2.63315, 1, 0, 0.511801,-0.00517975)    );
  // itree = 685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511885,-0.0361894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526105,0.00387593) , 
1, -2.04714, 1, 0, 0.525386,0.00294709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173965,-0.0434879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792669,0.00243784) , 
3, 0.637956, 1, 0, 0.388544,-0.0671481) , 
1, 0.860284, 1, 0, 0.489681,-0.0153422)    );
  // itree = 686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238709,-0.00128371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429875,0.0296721) , 
2, -0.533201, 1, 0, 0.324247,0.0271122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437691,-0.0366454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7922,-0.00473048) , 
3, 0.540815, 1, 0, 0.733026,-0.0250591) , 
3, 0.336059, 1, 0, 0.499735,0.00471512)    );
  // itree = 687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0304187,-0.0157048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272123,0.0416386) , 
3, -1.53282, 1, 0, 0.193816,0.0546905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50676,-0.017048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.891521,0.0162641) , 
3, 1.15024, 1, 0, 0.623432,-0.021277) , 
3, -0.613987, 1, 0, 0.49639,0.00118732)    );
  // itree = 688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561283,-0.0718296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315683,0.00857578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550578,-0.0172512) , 
0, -0.608449, 1, 0, 0.461996,-0.0170803) , 
1, -1.67665, 1, 0, 0.466249,-0.023078)    );
  // itree = 689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514084,-0.00203353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591378,0.0263164) , 
1, 0.187372, 1, 0, 0.528897,0.00720006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277346,-0.0229726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770088,0.0129902) , 
2, 0.514398, 1, 0, 0.42221,-0.0262762) , 
1, 0.547194, 1, 0, 0.491629,-0.00449405)    );
  // itree = 690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226096,0.00700916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494948,-0.00988403) , 
0, -1.93896, 1, 0, 0.447756,-0.0155299) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.866702,0.0382937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.872271,0.00735606) , 
2, 1.85939, 1, 0, 0.869478,0.0563242) , 
2, 1.49763, 1, 0, 0.47107,-0.0115575)    );
  // itree = 691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.705891,0.0736001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705304,-0.00229644) , 
0, -0.271515, 1, 0, 0.705496,0.0517849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492467,0.00248785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272821,-0.0440516) , 
1, 2.18078, 1, 0, 0.485625,0.00142509) , 
1, -0.827015, 1, 0, 0.523776,0.0101633)    );
  // itree = 692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417512,-0.0101032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709102,-0.0380463) , 
2, 0.602281, 1, 0, 0.507355,-0.039729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513101,0.0201642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192125,-0.0294691) , 
1, 1.76408, 1, 0, 0.460239,0.0226846) , 
1, 0.528386, 1, 0, 0.491446,-0.0186552)    );
  // itree = 693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406443,-0.00695598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417529,0.0283122) , 
1, 0.837952, 1, 0, 0.409208,0.00437191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.771521,0.0319465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759664,-0.0116555) , 
1, 0.607118, 1, 0, 0.768701,0.0489224) , 
2, 0.566067, 1, 0, 0.508501,0.0166769)    );
  // itree = 694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286842,0.00685675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179839,-0.0350594) , 
1, 0.479066, 1, 0, 0.242812,-0.0223302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49472,-0.0489911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696354,0.0127054) , 
1, -1.76773, 1, 0, 0.683625,0.0180958) , 
2, -0.30279, 1, 0, 0.494661,0.000766284)    );
  // itree = 695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61302,0.015012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472639,-0.0212957) , 
1, -0.0844279, 1, 0, 0.554433,-0.000496219) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410145,0.104638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561788,0.0174763) , 
0, -1.52831, 1, 0, 0.535506,0.0686201) , 
1, 0.907319, 1, 0, 0.550279,0.014675)    );
  // itree = 696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470794,0.0439553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636419,0.00954417) , 
2, -0.09856, 1, 0, 0.5738,0.0486829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170678,-0.0375143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631539,-0.0101788) , 
2, -0.349281, 1, 0, 0.395333,-0.0548755) , 
1, -0.259324, 1, 0, 0.469937,-0.0115853)    );
  // itree = 697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425063,-0.0331397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869187,0.00859) , 
2, 0.907234, 1, 0, 0.523881,-0.0567476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169735,-0.0172339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635997,0.0243151) , 
2, -0.7797, 1, 0, 0.471177,0.0234985) , 
1, -0.193814, 1, 0, 0.493255,-0.0101164)    );
  // itree = 698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.7415,0.0515498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35881,-0.0127568) , 
1, -1.24897, 1, 0, 0.389294,-0.0159061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.724711,0.0312341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714759,-0.0333784) , 
0, 2.97026, 1, 0, 0.72328,0.0441515) , 
0, 1.12677, 1, 0, 0.471529,-0.00111854)    );
  // itree = 699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213304,0.0307302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283174,-0.0216279) , 
0, -2.68657, 1, 0, 0.27425,-0.0395591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574637,0.0342798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814996,-0.00324858) , 
3, 0.689458, 1, 0, 0.746542,0.0156072) , 
3, 0.268003, 1, 0, 0.485627,-0.0148691)    );
  // itree = 700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219941,-0.0050588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36365,0.0459281) , 
2, -1.13944, 1, 0, 0.300239,0.050196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.813888,0.0400384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577726,-0.0123046) , 
1, -1.68541, 1, 0, 0.589033,-0.0196804) , 
2, -0.471788, 1, 0, 0.493514,0.00343132)    );
  // itree = 701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588037,0.0291296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474043,-0.0108141) , 
1, -1.5798, 1, 0, 0.481157,-0.0180163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420695,0.0371078) , 
1, 1.6884, 1, 0, 0.478496,-0.0137704)    );
  // itree = 702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436523,0.000444927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82148,0.018208) , 
2, 0.61766, 1, 0, 0.542712,0.0111829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0663255,-0.0687456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581929,-0.0146182) , 
0, -0.179423, 1, 0, 0.303948,-0.10161) , 
1, 1.71189, 1, 0, 0.528483,0.00446122)    );
  // itree = 703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440399,-0.00523189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682106,-0.0282896) , 
2, 0.61766, 1, 0, 0.51795,-0.0278398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57775,0.046092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474609,0.00371501) , 
1, 0.499809, 1, 0, 0.490736,0.0248421) , 
1, 0.356529, 1, 0, 0.506313,-0.00531365)    );
  // itree = 704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164286,-0.0151571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44597,-0.0296924) , 
3, -0.301457, 1, 0, 0.257843,-0.0487393) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.868002,0.0427142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713662,-0.00300643) , 
1, -1.1349, 1, 0, 0.742669,0.00807211) , 
3, 0.27076, 1, 0, 0.480878,-0.0226043)    );
  // itree = 705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426529,0.0117984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202318,-0.0195527) , 
1, 1.00548, 1, 0, 0.378121,0.0126966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.720527,0.00124853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638543,-0.0411904) , 
1, -0.239764, 1, 0, 0.676861,-0.038974) , 
2, 0.566067, 1, 0, 0.464898,-0.00231258)    );
  // itree = 706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139242,0.00631736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271404,-0.0436915) , 
2, -0.82275, 1, 0, 0.189973,-0.0425207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526013,0.0106047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640312,-0.0192064) , 
0, 1.37634, 1, 0, 0.552181,0.00646488) , 
0, -1.79098, 1, 0, 0.491977,-0.00167722)    );
  // itree = 707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20576,0.010018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533433,-0.0699052) , 
1, -0.0890506, 1, 0, 0.115644,-0.0671995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582348,-0.00582127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515699,0.0123681) , 
1, -0.133281, 1, 0, 0.544669,0.00934157) , 
2, -1.49291, 1, 0, 0.50303,0.00191289)    );
  // itree = 708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179437,-0.0124799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564462,0.0294739) , 
2, -0.693952, 1, 0, 0.385641,0.0234663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323357,-0.0230043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796443,0.00206295) , 
3, 0.452359, 1, 0, 0.697552,-0.00973732) , 
2, 0.391241, 1, 0, 0.503141,0.0109582)    );
  // itree = 709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318192,-0.0557442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608438,-0.0155259) , 
0, -0.494479, 1, 0, 0.478064,-0.081108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48289,0.00753844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47442,-0.0117364) , 
1, 0.362674, 1, 0, 0.478847,-0.0033516) , 
1, -0.82622, 1, 0, 0.478684,-0.0195232)    );
  // itree = 710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160443,-0.0299627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698089,-0.00631004) , 
3, -0.2003, 1, 0, 0.468862,-0.0310318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515984,0.0346343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31066,-0.0226772) , 
1, 1.53771, 1, 0, 0.468103,0.035849) , 
1, 0.413135, 1, 0, 0.468605,-0.00839996)    );
  // itree = 711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368976,-0.0186336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787404,0.0189544) , 
2, 0.566067, 1, 0, 0.499022,-0.0158944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484899,0.0903887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575762,0.00147941) , 
0, -0.248723, 1, 0, 0.538896,0.0728956) , 
1, 1.27072, 1, 0, 0.503433,-0.00607174)    );
  // itree = 712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358816,0.0453664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592636,0.00677492) , 
0, -1.56562, 1, 0, 0.547217,0.0273709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0732399,-0.0330616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632936,0.00347588) , 
3, -0.810052, 1, 0, 0.46573,-0.0102492) , 
1, 0.483982, 1, 0, 0.520996,0.0152656)    );
  // itree = 713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614889,0.0142758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456865,-0.0112309) , 
1, -0.573643, 1, 0, 0.504294,-0.00701087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159767,-0.0110174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530698,0.0537085) , 
0, -1.40984, 1, 0, 0.419913,0.0666778) , 
1, 1.44003, 1, 0, 0.495766,0.000436577)    );
  // itree = 714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100101,0.00425121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547615,-0.0492245) , 
2, -1.42688, 1, 0, 0.0759239,-0.0420713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436777,0.0424507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624945,0.00757401) , 
2, -0.723953, 1, 0, 0.605691,0.0241874) , 
3, -1.09475, 1, 0, 0.516891,0.013081)    );
  // itree = 715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355618,-0.0077385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527805,-0.0607624) , 
2, 0.505591, 1, 0, 0.378971,-0.0355203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.822774,0.0325076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601501,-0.00696581) , 
1, -0.189011, 1, 0, 0.692918,0.0204962) , 
0, 0.749055, 1, 0, 0.473288,-0.0186917)    );
  // itree = 716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263233,0.0114319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284123,-0.0414603) , 
2, -0.682686, 1, 0, 0.271773,-0.0385112) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.703898,0.034877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694582,-0.0106211) , 
0, 0.996849, 1, 0, 0.699665,0.0293679) , 
2, -0.237487, 1, 0, 0.506523,-0.00127147)    );
  // itree = 717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468583,0.0238837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793723,-0.00189467) , 
2, 0.903798, 1, 0, 0.53683,0.03556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439379,-0.0234363) , 
1, 2.10403, 1, 0, 0.534015,0.0323202)    );
  // itree = 718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324705,-0.0140368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834002,0.0161115) , 
3, 0.809754, 1, 0, 0.369305,-0.0252834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.83609,0.0667328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754945,-0.00321403) , 
2, 0.899532, 1, 0, 0.779541,0.0452117) , 
2, 0.571732, 1, 0, 0.492573,-0.00410098)    );
  // itree = 719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.605828,-0.0361698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437113,0.00461938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635999,-0.0154709) , 
0, 1.12719, 1, 0, 0.484265,-0.000374123) , 
1, -1.64443, 1, 0, 0.490349,-0.0039595)    );
  // itree = 720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0680811,-0.0297266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328583,0.0188888) , 
2, -1.65811, 1, 0, 0.262386,0.0215471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474669,-0.0215514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.889139,0.00826753) , 
3, 1.18525, 1, 0, 0.598615,-0.0336037) , 
2, -0.524956, 1, 0, 0.487569,-0.0153892)    );
  // itree = 721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0444553,-0.0258276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358478,0.0459982) , 
2, -1.73727, 1, 0, 0.25025,0.0520023) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400544,-0.0351369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621468,-0.00325821) , 
0, -0.262069, 1, 0, 0.541027,-0.0350108) , 
2, -0.936767, 1, 0, 0.486598,-0.0187231)    );
  // itree = 722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181137,-0.0318651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656564,0.0247094) , 
0, -2.41873, 1, 0, 0.60493,0.0363775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402388,-0.0138612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537706,0.0611049) , 
1, 2.05049, 1, 0, 0.409754,-0.0193189) , 
1, -0.133281, 1, 0, 0.487441,0.00285028)    );
  // itree = 723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64327,0.0470709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405567,0.00357294) , 
1, -1.57885, 1, 0, 0.422082,0.0120082) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.790857,-0.0511218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901277,-0.0113971) , 
3, 1.47841, 1, 0, 0.865877,-0.0389236) , 
3, 1.15656, 1, 0, 0.513519,0.00151444)    );
  // itree = 724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174894,-0.00680857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578669,0.01941) , 
3, -0.818784, 1, 0, 0.365122,0.0143319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174792,-0.0361208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764434,0.00121767) , 
3, 0.393477, 1, 0, 0.563141,-0.027268) , 
0, -0.331895, 1, 0, 0.477247,-0.00922322)    );
  // itree = 725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121046,-0.00972551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556726,0.0130216) , 
3, -0.695794, 1, 0, 0.324416,0.00649791) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566419,-0.0420901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760053,0.00175601) , 
0, 1.17247, 1, 0, 0.656198,-0.0466233) , 
2, 0.143877, 1, 0, 0.475749,-0.0177318)    );
  // itree = 726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392638,0.0336787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145591,-0.0217007) , 
1, 1.17425, 1, 0, 0.356422,0.0508785) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43024,-0.0315412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854334,0.00915353) , 
3, 0.69392, 1, 0, 0.737878,-0.0104959) , 
3, 0.27076, 1, 0, 0.549942,0.0197422)    );
  // itree = 727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666474,0.00609015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442076,-0.0147537) , 
1, -0.557725, 1, 0, 0.538874,-0.0105832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570617,0.0341055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501141,0.00697352) , 
1, 0.667312, 1, 0, 0.515774,0.0259094) , 
1, 0.382446, 1, 0, 0.530422,0.00276909)    );
  // itree = 728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22783,-0.00667641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719955,0.0127099) , 
3, -0.170545, 1, 0, 0.520313,0.0110094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153566,-0.0495073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458895,0.0471402) , 
0, 0.510216, 1, 0, 0.235221,-0.0700022) , 
1, 1.48646, 1, 0, 0.491698,0.00287808)    );
  // itree = 729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162377,0.0115927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570802,0.0493318) , 
3, -0.549015, 1, 0, 0.225767,0.032969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.656645,-0.0399369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623157,-0.00393994) , 
0, -0.331519, 1, 0, 0.630375,-0.0252401) , 
3, -0.291428, 1, 0, 0.48251,-0.00396744)    );
  // itree = 730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206969,0.0951748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13176,-0.0682819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516441,-0.0019735) , 
2, -1.42023, 1, 0, 0.491324,-0.0111735) , 
2, -2.00368, 1, 0, 0.482419,-0.00767711)    );
  // itree = 731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0131,-0.0296794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616086,0.0724325) , 
3, -1.46051, 1, 0, 0.266114,0.0619234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65095,0.0126569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452791,-0.0157421) , 
1, -0.234178, 1, 0, 0.536261,-0.00914497) , 
2, -1.08782, 1, 0, 0.499085,0.000634914)    );
  // itree = 732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23701,0.0702965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356041,-0.00764754) , 
2, -1.00752, 1, 0, 0.277615,0.0500458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20033,-0.0351957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619684,0.00245638) , 
2, -0.566513, 1, 0, 0.519112,-0.0116538) , 
0, -2.03899, 1, 0, 0.490374,-0.00431164)    );
  // itree = 733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224384,-0.00227536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220084,0.0471881) , 
0, -1.71711, 1, 0, 0.222696,0.026076) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240785,-0.0419404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661416,-0.00284891) , 
3, -0.361123, 1, 0, 0.617083,-0.0172708) , 
3, -0.613987, 1, 0, 0.504029,-0.00484514)    );
  // itree = 734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297189,-0.00592565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401402,-0.0341486) , 
2, 0.302213, 1, 0, 0.317161,-0.0271813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902647,0.0459625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.844585,-0.000653278) , 
2, 0.589937, 1, 0, 0.858035,0.0174995) , 
3, 0.828289, 1, 0, 0.464488,-0.0150109)    );
  // itree = 735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0457882,-0.0273017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800885,0.102194) , 
3, -1.42005, 1, 0, 0.33732,0.0775384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619489,-0.0253591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536388,0.00341948) , 
1, -0.943011, 1, 0, 0.553575,-0.00507395) , 
0, -1.7412, 1, 0, 0.521839,0.00704959)    );
  // itree = 736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136815,0.0839475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32288,-0.0184856) , 
2, -1.97425, 1, 0, 0.310283,-0.0337055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57818,0.0451967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692731,-0.0069578) , 
2, 0.160986, 1, 0, 0.664111,0.0149841) , 
0, -0.416978, 1, 0, 0.505749,-0.00680793)    );
  // itree = 737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569861,-0.0783879) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503653,0.00158814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30501,-0.0446252) , 
1, 2.27289, 1, 0, 0.4977,-0.000170786) , 
1, -1.75273, 1, 0, 0.50066,-0.0065622)    );
  // itree = 738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306007,-0.00828439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174356,-0.0508255) , 
2, 0.484889, 1, 0, 0.291341,-0.0311902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.8156,0.0220831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.845822,-0.0144947) , 
2, 1.28141, 1, 0, 0.823175,0.0225935) , 
3, 0.427177, 1, 0, 0.499153,-0.0101744)    );
  // itree = 739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144012,0.000492157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303711,-0.0581364) , 
3, -0.851905, 1, 0, 0.204265,-0.0564832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619598,-0.000852831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6277,0.0196383) , 
1, 0.531499, 1, 0, 0.62211,0.0115131) , 
2, -0.862357, 1, 0, 0.5344,-0.00276005)    );
  // itree = 740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.60076,0.00863438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.806921,0.0874574) , 
1, -0.613272, 1, 0, 0.621883,0.0369256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141786,-0.0308565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647173,0.00166727) , 
3, -0.445771, 1, 0, 0.498634,-0.0139399) , 
1, -0.480148, 1, 0, 0.533832,0.00058666)    );
  // itree = 741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0668711,0.0128329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63962,0.0512204) , 
3, -1.49309, 1, 0, 0.281073,0.0599921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190925,-0.0482844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589809,0.00558576) , 
2, -1.0682, 1, 0, 0.564185,0.00333382) , 
0, -1.7412, 1, 0, 0.516003,0.0129762)    );
  // itree = 742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403314,-0.0340319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424127,0.0143241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63904,-0.00600747) , 
0, 0.394028, 1, 0, 0.518433,0.00937977) , 
1, -1.71361, 1, 0, 0.512933,0.00478719)    );
  // itree = 743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450547,0.00269502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515983,0.0724817) , 
1, 1.15288, 1, 0, 0.458342,0.0254009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564169,-0.00675966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688272,-0.0243886) , 
2, 1.25277, 1, 0, 0.594613,-0.0243752) , 
0, 0.394028, 1, 0, 0.515278,0.00460377)    );
  // itree = 744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185362,-0.000674466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651832,-0.0265298) , 
3, -0.385346, 1, 0, 0.30598,-0.0179292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.734517,0.0597811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608262,-0.000229628) , 
0, -0.0993363, 1, 0, 0.624936,0.0167803) , 
0, -0.4832, 1, 0, 0.491483,0.00225758)    );
  // itree = 745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330664,0.0103738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458897,0.0393518) , 
2, 0.380431, 1, 0, 0.348315,0.0310917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553101,-0.0585036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743281,-0.00240833) , 
2, -0.0222404, 1, 0, 0.727151,-0.0164912) , 
3, 0.34753, 1, 0, 0.513047,0.010401)    );
  // itree = 746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586785,0.0701948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767054,0.015339) , 
0, -0.0122419, 1, 0, 0.675374,0.0979992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621312,0.0228707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413711,-0.00390053) , 
1, -0.521149, 1, 0, 0.459123,0.00316154) , 
1, -1.59845, 1, 0, 0.473782,0.00959024)    );
  // itree = 747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.722331,0.0682906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143427,-0.0264877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65278,0.00442146) , 
3, -0.707817, 1, 0, 0.518734,-0.00530024) , 
1, -2.26051, 1, 0, 0.52435,-2.65293e-05)    );
  // itree = 748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554277,0.00652605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370009,-0.0170645) , 
1, 1.19981, 1, 0, 0.532884,0.00748579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607733,0.06274) , 
1, 1.94792, 1, 0, 0.535203,0.0100925)    );
  // itree = 749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387376,0.016007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496937,-0.0318979) , 
0, -1.71962, 1, 0, 0.480803,-0.0542172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488665,0.00119172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268252,-0.0515787) , 
1, 1.92535, 1, 0, 0.476357,-0.00455849) , 
1, -0.417903, 1, 0, 0.477937,-0.0222094)    );
  // itree = 750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199136,-0.0527243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10312,-0.0233466) , 
1, -1.33451, 1, 0, 0.113788,-0.0500821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280947,-0.022326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664557,0.00845065) , 
3, -0.448004, 1, 0, 0.626022,0.00968605) , 
3, -0.707817, 1, 0, 0.478145,-0.00756847)    );
  // itree = 751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396304,0.00909877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266577,-0.0198546) , 
1, 0.527824, 1, 0, 0.354005,-0.0013202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.690186,-0.0337593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88569,-0.00658567) , 
3, 1.41252, 1, 0, 0.777011,-0.0463486) , 
3, 0.673895, 1, 0, 0.493148,-0.0161317)    );
  // itree = 752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684514,0.0113609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598661,-0.0513487) , 
1, -1.79059, 1, 0, 0.627061,-0.076552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53045,-0.00066504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37213,-0.0180537) , 
1, 0.671795, 1, 0, 0.475653,-0.0139308) , 
1, -1.33919, 1, 0, 0.49304,-0.0211217)    );
  // itree = 753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237358,-0.00285463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746862,0.055221) , 
3, -0.0234518, 1, 0, 0.339928,0.0185054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390153,-0.0446362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759499,0.00685019) , 
2, 0.330136, 1, 0, 0.664132,-0.022587) , 
2, -0.0505193, 1, 0, 0.514594,-0.00363334)    );
  // itree = 754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.768971,0.0155109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326498,-0.0856445) , 
1, -1.76231, 1, 0, 0.540912,-0.0933265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681342,0.0518547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475007,-0.0072061) , 
1, -1.20206, 1, 0, 0.486607,-0.00943216) , 
1, -1.48631, 1, 0, 0.490914,-0.0160852)    );
  // itree = 755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519077,0.0278296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820199,0.00118303) , 
3, 0.656029, 1, 0, 0.621236,0.0410894) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255619,-0.0257313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601236,0.00691839) , 
0, 0.206177, 1, 0, 0.396152,-0.0281854) , 
1, 0.0841905, 1, 0, 0.498055,0.00317766)    );
  // itree = 756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580507,-0.00327383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396189,-0.03499) , 
1, -0.22877, 1, 0, 0.545877,-0.018376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345827,0.0225086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812027,-0.00224435) , 
3, 0.866668, 1, 0, 0.486691,0.0303959) , 
1, 0.0567207, 1, 0, 0.515873,0.00634831)    );
  // itree = 757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203259,0.00310511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70131,0.0915316) , 
2, -0.188964, 1, 0, 0.246007,0.0259346) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459457,-0.0405528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713025,-0.00448563) , 
2, -0.135269, 1, 0, 0.652132,-0.032036) , 
3, -0.218528, 1, 0, 0.495279,-0.00964661)    );
  // itree = 758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134575,-0.0226259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760525,0.0222289) , 
3, -0.823957, 1, 0, 0.581755,0.0226139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410697,-0.0157551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854783,0.0313829) , 
2, 0.863656, 1, 0, 0.506665,-0.0126547) , 
1, 0.434194, 1, 0, 0.551845,0.00856552)    );
  // itree = 759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141274,-0.0642076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193468,0.0258644) , 
1, -0.370927, 1, 0, 0.166548,-0.0845242) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444835,0.00547484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599896,-0.0131299) , 
0, 0.554675, 1, 0, 0.509101,-0.00515918) , 
0, -2.33718, 1, 0, 0.477,-0.0125966)    );
  // itree = 760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338287,-0.00205968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501474,0.133335) , 
1, 1.4229, 1, 0, 0.349261,0.0113005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.854294,0.0458908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566606,-0.0151771) , 
1, -1.40531, 1, 0, 0.593288,-0.0230974) , 
0, -0.289772, 1, 0, 0.484657,-0.00778488)    );
  // itree = 761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149837,-0.018626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573411,0.00564227) , 
2, -0.947301, 1, 0, 0.489278,0.00255704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338053,-0.0143378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348594,-0.0338714) , 
1, 1.34613, 1, 0, 0.345123,-0.0695005) , 
1, 1.0602, 1, 0, 0.463881,-0.0101382)    );
  // itree = 762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39474,-0.00215717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223956,-0.0288045) , 
1, 0.382446, 1, 0, 0.317975,-0.0293681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.860535,0.0519017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707753,0.00420056) , 
1, -0.827771, 1, 0, 0.742579,0.0304599) , 
2, 0.23429, 1, 0, 0.490479,-0.00506183)    );
  // itree = 763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487411,-0.0104789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902385,0.0350852) , 
2, 1.38996, 1, 0, 0.524006,-0.0129881) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495217,0.0224739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300067,-0.0373624) , 
1, 1.78601, 1, 0, 0.466333,0.0254158) , 
1, 0.550543, 1, 0, 0.503761,0.000492888)    );
  // itree = 764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145609,-0.0643231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.887817,0.0316883) , 
3, 0.0250253, 1, 0, 0.522782,-0.0540276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50866,0.00579569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434115,-0.0147371) , 
1, 0.586705, 1, 0, 0.481542,-0.00308409) , 
1, -1.1416, 1, 0, 0.487086,-0.0099318)    );
  // itree = 765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100567,-0.0091642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516348,0.021244) , 
3, -0.924632, 1, 0, 0.345124,0.0253402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584166,-0.0443415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670787,0.00379191) , 
1, -0.751023, 1, 0, 0.647561,-0.0203537) , 
2, 0.0876493, 1, 0, 0.483514,0.00443146)    );
  // itree = 766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270646,0.000302403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128481,-0.049181) , 
1, 1.35428, 1, 0, 0.239794,-0.0196443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361996,0.0608444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6008,0.00530581) , 
0, -1.31667, 1, 0, 0.579891,0.0164866) , 
0, -1.79098, 1, 0, 0.52075,0.0102036)    );
  // itree = 767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13953,-0.0156522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366486,0.026286) , 
2, -1.41156, 1, 0, 0.303248,0.0330231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633898,0.0386902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609208,-0.00765452) , 
2, -0.0801491, 1, 0, 0.611632,-0.00606605) , 
2, -0.283978, 1, 0, 0.486157,0.00983847)    );
  // itree = 768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181904,0.00894156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691676,0.0410146) , 
3, -0.898214, 1, 0, 0.31425,0.0321668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372813,-0.0335143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708309,0.00354716) , 
2, 0.329243, 1, 0, 0.558783,-0.0329041) , 
0, -1.11562, 1, 0, 0.502124,-0.017827)    );
  // itree = 769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232146,-0.00632802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56697,-0.0509628) , 
3, -0.460117, 1, 0, 0.334767,-0.0464556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622287,0.0308534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669136,-0.00429287) , 
0, 0.56588, 1, 0, 0.652256,0.0188783) , 
0, -0.548509, 1, 0, 0.525487,-0.00720861)    );
  // itree = 770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303721,0.0764865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492035,0.00647778) , 
2, -1.0444, 1, 0, 0.367317,0.0907822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506379,-0.0118181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579362,0.0286158) , 
1, 1.15768, 1, 0, 0.516995,-0.0132052) , 
0, -2.03899, 1, 0, 0.499751,-0.00122514)    );
  // itree = 771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206606,0.0214395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560344,-0.00651583) , 
2, -0.907519, 1, 0, 0.485899,-0.0048181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.919097,0.0744188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901312,0.0106097) , 
3, 1.90316, 1, 0, 0.90803,0.087798) , 
2, 1.50218, 1, 0, 0.517676,0.00215371)    );
  // itree = 772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0746575,-0.0617945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200772,0.011704) , 
1, -0.924705, 1, 0, 0.172948,-0.0213772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576636,0.0251383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81937,0.000824864) , 
3, 0.834507, 1, 0, 0.6769,0.0360173) , 
3, -0.707817, 1, 0, 0.544647,0.0209551)    );
  // itree = 773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.787072,0.0305251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519185,-0.00996442) , 
1, -1.58179, 1, 0, 0.551337,-0.0119466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560713,0.0709066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436642,-0.00612935) , 
1, 0.506918, 1, 0, 0.468318,0.0226293) , 
1, 0.209522, 1, 0, 0.513441,0.00383662)    );
  // itree = 774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52151,0.0348957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585404,-0.0363652) , 
0, -0.998658, 1, 0, 0.572129,-0.0521287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298207,-0.0123377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578686,0.0102216) , 
0, -0.781918, 1, 0, 0.472665,0.00469758) , 
1, -0.743609, 1, 0, 0.495354,-0.00826549)    );
  // itree = 775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148753,-0.0525449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245586,0.0207868) , 
1, -1.46272, 1, 0, 0.238116,0.0199159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578117,-0.0447968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625327,-0.00555014) , 
0, -0.215492, 1, 0, 0.614307,-0.0357097) , 
3, -0.302053, 1, 0, 0.490594,-0.0174168)    );
  // itree = 776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150389,-0.0350456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495718,0.0025524) , 
2, -1.40568, 1, 0, 0.438539,-0.003816) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535946,-0.0210333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.903196,0.00210725) , 
3, 1.89456, 1, 0, 0.653708,-0.0363047) , 
0, 1.06786, 1, 0, 0.492456,-0.011957)    );
  // itree = 777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439839,9.56078e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.927157,0.0355769) , 
3, 1.08674, 1, 0, 0.563821,0.0154271) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219769,-0.0232169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809426,-0.000243869) , 
3, 0.48763, 1, 0, 0.455415,-0.0295747) , 
1, 0.213586, 1, 0, 0.512436,-0.00590398)    );
  // itree = 778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423477,-0.0296067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346851,0.018168) , 
1, -1.42554, 1, 0, 0.352795,0.0285236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733824,-0.0532717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836625,0.0108876) , 
1, 0.735503, 1, 0, 0.767067,-0.0538322) , 
3, 0.729578, 1, 0, 0.481117,0.00301368)    );
  // itree = 779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.866684,0.0471399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518939,-0.00505881) , 
1, -1.78475, 1, 0, 0.543299,-0.00442137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194875,-0.0110443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617733,-0.0460678) , 
2, 0.0556663, 1, 0, 0.376253,-0.05393) , 
1, 0.531499, 1, 0, 0.481478,-0.0227438)    );
  // itree = 780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0648857,0.00453888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353669,0.0544409) , 
2, -1.78507, 1, 0, 0.229734,0.0579921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427599,-0.0120803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835827,0.0134031) , 
2, 0.765345, 1, 0, 0.53886,-0.0113434) , 
2, -1.2253, 1, 0, 0.494827,-0.00146701)    );
  // itree = 781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309584,0.0678448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220116,0.0177305) , 
1, -0.444283, 1, 0, 0.235061,0.039347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361281,-0.0235966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684165,0.0108789) , 
2, -0.286148, 1, 0, 0.608762,0.00307565) , 
2, -0.806007, 1, 0, 0.527908,0.0109234)    );
  // itree = 782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112994,-0.0258679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251293,-0.0478502) , 
3, -0.771644, 1, 0, 0.154823,-0.0716248) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483855,-0.00706959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.894993,0.0367736) , 
3, 0.904781, 1, 0, 0.651331,0.0177711) , 
2, -0.55359, 1, 0, 0.483221,-0.0124969)    );
  // itree = 783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237278,-0.0235254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656706,-0.00466888) , 
2, -0.223112, 1, 0, 0.478441,-0.0279293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360809,0.0676364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699975,0.0202565) , 
2, -0.416905, 1, 0, 0.557142,0.0818863) , 
1, 1.12702, 1, 0, 0.489417,-0.0126139)    );
  // itree = 784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621273,-0.0033426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811917,0.0464246) , 
1, -1.76159, 1, 0, 0.703915,0.043272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225919,0.00120901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617007,-0.0124198) , 
3, -0.0426953, 1, 0, 0.427134,-0.0130699) , 
1, -1.40531, 1, 0, 0.451352,-0.00814009)    );
  // itree = 785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128525,0.0117397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525683,0.0363906) , 
3, -0.996768, 1, 0, 0.321602,0.0477293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531841,-0.011848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767697,0.0050635) , 
2, 0.684432, 1, 0, 0.630316,-0.0115024) , 
2, -0.351252, 1, 0, 0.511742,0.0112479)    );
  // itree = 786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442003,-0.0476571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555413,0.00735252) , 
1, -1.83105, 1, 0, 0.550037,0.00976604) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309823,-0.0276051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55771,0.0223314) , 
1, 2.1089, 1, 0, 0.339245,-0.0449722) , 
1, 0.92669, 1, 0, 0.499354,-0.00339519)    );
  // itree = 787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226164,-0.0148605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424615,0.0217965) , 
0, -1.96092, 1, 0, 0.368698,0.0243224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6269,0.0221431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698763,-0.0138636) , 
2, 0.319871, 1, 0, 0.687085,-0.0160478) , 
2, 0.102157, 1, 0, 0.531777,0.00364467)    );
  // itree = 788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0340283,-0.0758725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344731,0.0166126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640419,-0.00993695) , 
2, -0.00654428, 1, 0, 0.50642,0.00329691) , 
0, -3.29707, 1, 0, 0.492299,-0.00107686)    );
  // itree = 789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271424,-0.007064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73903,0.0140773) , 
3, 0.141939, 1, 0, 0.452625,0.00181999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.600695,-0.0592936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.817819,0.00588326) , 
0, 1.71398, 1, 0, 0.71296,-0.0599897) , 
2, 0.903798, 1, 0, 0.504156,-0.0104147)    );
  // itree = 790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621634,-0.00325175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585805,0.0273299) , 
1, -0.926597, 1, 0, 0.597844,0.0315159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20649,0.0238675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463642,-0.0319689) , 
3, -0.509026, 1, 0, 0.3968,-0.0487078) , 
1, 0.219717, 1, 0, 0.500463,-0.00734248)    );
  // itree = 791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340325,0.00777242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557914,-0.0153706) , 
2, -0.069217, 1, 0, 0.433962,-0.00676363) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.710717,0.0299484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.898944,0.00993427) , 
3, 1.38432, 1, 0, 0.83189,0.0369716) , 
2, 0.801662, 1, 0, 0.521972,0.00290935)    );
  // itree = 792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512837,-0.00296287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534828,0.0403875) , 
1, 0.5032, 1, 0, 0.518875,0.0158131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144388,-0.0505622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397778,-0.00854871) , 
0, 0.0273923, 1, 0, 0.283119,-0.0577908) , 
1, 1.57547, 1, 0, 0.497463,0.00912818)    );
  // itree = 793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35329,-0.00562343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570262,-0.040244) , 
2, 0.311368, 1, 0, 0.395151,-0.031855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684331,0.0395379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678345,0.00121586) , 
0, 0.746211, 1, 0, 0.679513,0.0176439) , 
0, 0.394028, 1, 0, 0.508348,-0.0121507)    );
  // itree = 794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510785,0.0246417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251203,-0.023483) , 
1, -0.781748, 1, 0, 0.30815,-0.0272323) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.761322,0.0245853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.891109,0.00244294) , 
3, 1.34864, 1, 0, 0.829018,0.0267028) , 
3, 0.609067, 1, 0, 0.497798,-0.00759452)    );
  // itree = 795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386535,-0.0112038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597163,-0.0587315) , 
2, 0.715424, 1, 0, 0.408986,-0.0368662) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711003,0.0307104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770416,-0.000885448) , 
2, 0.825506, 1, 0, 0.748994,0.0273791) , 
0, 1.1401, 1, 0, 0.481146,-0.0232314)    );
  // itree = 796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0776934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52919,0.00270081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194551,-0.0504544) , 
1, 1.71996, 1, 0, 0.511016,0.000344729) , 
2, -2.33975, 1, 0, 0.494939,-0.004407)    );
  // itree = 797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389219,-0.0498961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146509,-0.0251485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646027,0.00584324) , 
3, -0.547237, 1, 0, 0.506187,-0.0034027) , 
1, -1.73801, 1, 0, 0.499391,-0.0107895)    );
  // itree = 798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162651,-0.0263079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627141,0.00616819) , 
3, -0.823957, 1, 0, 0.53389,0.0023787) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487356,0.0264382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424108,-0.0124947) , 
1, 1.8631, 1, 0, 0.481666,0.0483051) , 
1, 0.237261, 1, 0, 0.512665,0.0210445)    );
  // itree = 799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358975,-0.00424671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136292,-0.0333004) , 
1, 0.855081, 1, 0, 0.28262,-0.0260144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664607,0.0235891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686919,-0.00619366) , 
0, 0.522964, 1, 0, 0.678845,0.0116475) , 
2, -0.0811742, 1, 0, 0.494327,-0.00589125)    );
  // itree = 800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.871037,0.0454344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514746,-0.00120566) , 
1, -1.85386, 1, 0, 0.532808,0.0025239) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432493,0.0405885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812004,-0.0159609) , 
3, 1.24855, 1, 0, 0.518412,0.0543804) , 
1, 0.669073, 1, 0, 0.528692,0.0173485)    );
  // itree = 801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207501,-0.00127343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54137,0.0527171) , 
3, -0.344405, 1, 0, 0.258669,0.0179313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791209,0.0322757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613781,-0.0170047) , 
1, -1.05754, 1, 0, 0.637677,-0.026593) , 
3, -0.100774, 1, 0, 0.482518,-0.00836557)    );
  // itree = 802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465423,-0.0345852) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375183,0.0181887) , 
1, -0.940219, 1, 0, 0.389923,0.0177746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.747686,0.0126348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53458,-0.019192) , 
1, -0.528003, 1, 0, 0.594072,-0.0216545) , 
0, -0.4832, 1, 0, 0.508101,-0.00505023)    );
  // itree = 803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.821199,0.0562374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496989,-0.00521664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473725,0.0143662) , 
1, 1.22224, 1, 0, 0.494,-0.00497964) , 
1, -1.86762, 1, 0, 0.504182,-0.00221015)    );
  // itree = 804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0248296,0.000909943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328851,-0.034279) , 
3, -1.60724, 1, 0, 0.247084,-0.0563265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619413,-0.0110351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524731,0.00885027) , 
1, -0.134696, 1, 0, 0.565505,-3.46451e-05) , 
0, -1.06144, 1, 0, 0.474618,-0.0161021)    );
  // itree = 805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47698,0.0152878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842908,-0.0173732) , 
3, 1.25874, 1, 0, 0.536014,0.0219934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236921,0.0482026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399266,-0.0215605) , 
2, -1.09743, 1, 0, 0.376581,-0.030694) , 
1, 0.843066, 1, 0, 0.497452,0.00925005)    );
  // itree = 806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379482,0.0222092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505678,-0.017211) , 
0, -1.02286, 1, 0, 0.460143,-0.0135988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719057,0.0268329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625889,-0.0132687) , 
1, 0.723933, 1, 0, 0.692273,0.0351432) , 
0, 0.749055, 1, 0, 0.539765,0.00312005)    );
  // itree = 807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153865,-0.00812802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722746,0.0625434) , 
3, -0.893097, 1, 0, 0.337291,0.0329813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405092,-0.0267644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62516,-0.0031135) , 
0, 0.26242, 1, 0, 0.543538,-0.0262254) , 
0, -0.841201, 1, 0, 0.476611,-0.00701276)    );
  // itree = 808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0531628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478365,0.0378592) , 
3, -1.93241, 1, 0, 0.322818,0.0528438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193511,-0.0319589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660412,-0.00288502) , 
3, -0.163497, 1, 0, 0.51246,-0.0273124) , 
0, -1.82049, 1, 0, 0.485906,-0.016089)    );
  // itree = 809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363588,-0.000783164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428994,-0.045558) , 
0, -0.540626, 1, 0, 0.385745,-0.0409935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670569,0.00474682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679502,0.0275521) , 
1, 0.992713, 1, 0, 0.672597,0.0209367) , 
0, 0.305096, 1, 0, 0.511346,-0.0138768)    );
  // itree = 810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542627,0.0285988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364058,-0.0165469) , 
1, -0.796883, 1, 0, 0.402688,-0.0168768) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.727068,0.0266876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.79858,-0.0126549) , 
2, 1.35621, 1, 0, 0.74537,0.0393954) , 
2, 0.521751, 1, 0, 0.51606,0.00174007)    );
  // itree = 811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454624,-0.0375521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420906,0.0075491) , 
1, -1.70534, 1, 0, 0.422937,0.007627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601427,-0.0242391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.892961,0.0286807) , 
2, 1.47265, 1, 0, 0.650747,-0.0340665) , 
2, 0.462259, 1, 0, 0.501234,-0.00670282)    );
  // itree = 812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182779,0.00296739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420246,-0.0473403) , 
3, -0.813827, 1, 0, 0.267946,-0.0512342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612793,0.0518999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662174,0.00605297) , 
2, -0.605684, 1, 0, 0.657737,0.0228271) , 
0, -1.12225, 1, 0, 0.555522,0.00340596)    );
  // itree = 813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200257,0.0243173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.099772,-0.0433894) , 
2, -1.41842, 1, 0, 0.135456,-0.0424873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.91087,0.058716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622661,-0.00378107) , 
0, -0.902133, 1, 0, 0.65287,0.00442803) , 
3, -0.689919, 1, 0, 0.501221,-0.00932236)    );
  // itree = 814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429854,-0.00454833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377257,0.0311276) , 
1, 0.730317, 1, 0, 0.417875,0.00567249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553744,-0.0972333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868816,-0.0105558) , 
3, 1.36068, 1, 0, 0.814732,-0.0542941) , 
3, 1.20274, 1, 0, 0.506519,-0.00772196)    );
  // itree = 815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502592,-0.0100051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50247,0.0115992) , 
1, -0.288125, 1, 0, 0.502519,0.00474376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250351,-0.0367592) , 
1, 2.41928, 1, 0, 0.494171,0.00155643)    );
  // itree = 816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18418,-0.0126895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379934,-0.0512831) , 
3, -0.509034, 1, 0, 0.223696,-0.0531467) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379821,0.0338481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660413,0.000349781) , 
2, -0.30134, 1, 0, 0.621855,0.00840848) , 
2, -0.55359, 1, 0, 0.495171,-0.0111768)    );
  // itree = 817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513366,-0.0498512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688014,0.03901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478689,0.000667507) , 
1, -1.02381, 1, 0, 0.509842,0.0127067) , 
1, -2.00484, 1, 0, 0.509956,0.00875087)    );
  // itree = 818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560414,-0.0125228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509789,0.00609954) , 
1, -0.437344, 1, 0, 0.527726,-0.0012717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262801,-0.0288636) , 
1, 2.11264, 1, 0, 0.516452,-0.00451249)    );
  // itree = 819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369405,-0.0161603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735111,0.0227611) , 
2, 0.660975, 1, 0, 0.395585,-0.0247801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573336,0.0431207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699828,0.00124373) , 
2, 0.448802, 1, 0, 0.65848,0.0314353) , 
0, 0.321785, 1, 0, 0.505322,-0.00131481)    );
  // itree = 820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344016,-0.00735618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201035,-0.0388655) , 
0, 0.046205, 1, 0, 0.307278,-0.036207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.860043,0.0459188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.873189,0.000740865) , 
3, 1.07381, 1, 0, 0.870509,0.0217874) , 
3, 0.712472, 1, 0, 0.476802,-0.0187516)    );
  // itree = 821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349847,-0.00217545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778598,0.0339527) , 
2, 0.391535, 1, 0, 0.428501,0.00916147) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0724292,-0.0680448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791001,0.00120678) , 
3, 0.958375, 1, 0, 0.603803,-0.0349515) , 
0, 1.03966, 1, 0, 0.472779,-0.00198066)    );
  // itree = 822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483981,0.0218671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.771101,-0.0102008) , 
2, 0.674038, 1, 0, 0.56868,0.0243799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189143,-0.0229917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811673,0.0116226) , 
3, 0.399788, 1, 0, 0.444382,-0.0182645) , 
1, 0.237261, 1, 0, 0.509102,0.0039396)    );
  // itree = 823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478543,-0.0567448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480809,-0.000861426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422008,-0.0160665) , 
1, 0.73969, 1, 0, 0.464254,-0.00988908) , 
1, -1.65317, 1, 0, 0.464963,-0.0155246)    );
  // itree = 824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402193,0.0264493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487151,-0.000160392) , 
0, -1.00469, 1, 0, 0.446188,0.023297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471143,-0.0444402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599839,-0.00898869) , 
0, 0.760051, 1, 0, 0.571963,-0.0393789) , 
0, 0.394028, 1, 0, 0.498969,-0.00300482)    );
  // itree = 825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.706177,0.0372628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58436,0.00618435) , 
1, -1.61683, 1, 0, 0.601187,0.0229593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153336,-0.0485585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536628,-0.00877082) , 
0, -1.48672, 1, 0, 0.454746,-0.0305718) , 
1, -0.125008, 1, 0, 0.522003,-0.00598641)    );
  // itree = 826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.770264,0.0699065) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486649,-0.00737635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516456,0.0162497) , 
1, 0.724653, 1, 0, 0.495533,-0.00113451) , 
1, -1.65097, 1, 0, 0.508093,0.00406303)    );
  // itree = 827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536213,-0.0420692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522285,0.000397082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428654,0.0386301) , 
1, 1.52532, 1, 0, 0.515264,0.00618527) , 
1, -1.69867, 1, 0, 0.516201,0.0022628)    );
  // itree = 828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0525443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500362,0.0751146) , 
3, -2.3073, 1, 0, 0.308208,0.0856052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370719,-0.00271386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.693301,0.0162359) , 
2, 0.128086, 1, 0, 0.53871,0.0144023) , 
0, -2.38608, 1, 0, 0.519823,0.0202366)    );
  // itree = 829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361965,-0.0578246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336029,-0.00412328) , 
1, -0.958523, 1, 0, 0.340847,-0.0269612) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325336,0.0550753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68273,0.00269173) , 
3, 0.0148923, 1, 0, 0.647862,0.0155732) , 
0, -0.392097, 1, 0, 0.510918,-0.0033992)    );
  // itree = 830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614107,0.0354485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469758,-0.0186121) , 
1, -1.62264, 1, 0, 0.482276,-0.0319252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351167,0.0064123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.894192,0.0558202) , 
2, 0.514398, 1, 0, 0.500548,0.0429049) , 
1, 0.560452, 1, 0, 0.488505,-0.00641581)    );
  // itree = 831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0177779,-0.022826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274863,-0.0417331) , 
3, -1.77386, 1, 0, 0.139946,-0.0730534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41591,0.0207785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614294,-0.00999556) , 
2, -0.118928, 1, 0, 0.536635,0.00340947) , 
0, -2.4087, 1, 0, 0.495782,-0.00446502)    );
  // itree = 832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65158,0.0404103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87195,-0.00787782) , 
3, 0.448731, 1, 0, 0.749324,0.0537658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279892,0.0208207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535752,-0.00644611) , 
0, -1.79848, 1, 0, 0.498919,-0.00731004) , 
1, -1.12613, 1, 0, 0.531027,0.000521298)    );
  // itree = 833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399274,-0.0639668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64744,0.0163855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46445,-0.00550892) , 
1, -0.677929, 1, 0, 0.50073,-0.00283497) , 
1, -2.17574, 1, 0, 0.497343,-0.00753158)    );
  // itree = 834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493696,0.0117345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632416,-0.0565926) , 
2, 0.963185, 1, 0, 0.551897,-0.0488915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57824,0.0157562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423866,-0.00932144) , 
1, 0.437906, 1, 0, 0.519623,0.012331) , 
1, -1.36363, 1, 0, 0.522777,0.00634767)    );
  // itree = 835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165595,0.149194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532258,-0.0145756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512687,0.0124181) , 
1, -0.480148, 1, 0, 0.518647,0.00894811) , 
0, -3.25007, 1, 0, 0.507841,0.0121782)    );
  // itree = 836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833119,0.00129002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306024,-0.0263804) , 
3, -1.13934, 1, 0, 0.249953,-0.0479078) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.911753,0.0372872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705941,0.000914283) , 
1, -0.873052, 1, 0, 0.745692,0.0124515) , 
3, 0.27076, 1, 0, 0.470892,-0.021007)    );
  // itree = 837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327372,0.0331585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374929,-0.022771) , 
0, -2.08347, 1, 0, 0.36454,-0.0252807) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63922,0.0327175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706882,-0.024116) , 
2, 0.961388, 1, 0, 0.664927,0.0231522) , 
0, 0.18515, 1, 0, 0.498537,-0.00367581)    );
  // itree = 838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.771885,0.0591792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522507,-0.0166754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459151,0.00494408) , 
1, -0.492908, 1, 0, 0.478176,-0.00427651) , 
1, -1.70534, 1, 0, 0.490249,0.00045617)    );
  // itree = 839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576545,0.0481527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407977,-0.0142491) , 
1, -1.86762, 1, 0, 0.413389,-0.0266697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.793266,0.0362848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758465,-0.00667239) , 
2, 1.22412, 1, 0, 0.774961,0.035231) , 
2, 0.863656, 1, 0, 0.490057,-0.0135441)    );
  // itree = 840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218632,-0.000968536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591983,-0.0490944) , 
3, -0.696754, 1, 0, 0.30591,-0.0341528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.591034,0.0353432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607683,-0.00649557) , 
0, 0.415342, 1, 0, 0.600285,0.0236279) , 
0, -1.28819, 1, 0, 0.523122,0.00848214)    );
  // itree = 841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59193,0.00327955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618752,0.0580637) , 
1, -0.28394, 1, 0, 0.598738,0.0319083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0200909,-0.0768036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474438,-0.0119617) , 
0, -2.09951, 1, 0, 0.426671,-0.0363965) , 
1, 0.213586, 1, 0, 0.515853,-0.00099415)    );
  // itree = 842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.047905,0.0251617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627079,0.0566276) , 
3, -1.82534, 1, 0, 0.298738,0.0679123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0520727,-0.0730804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521746,-0.00632224) , 
0, -2.14128, 1, 0, 0.4934,-0.0210704) , 
0, -2.62228, 1, 0, 0.479458,-0.0146974)    );
  // itree = 843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.589295,0.0565206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.843942,-0.00132613) , 
0, -0.251912, 1, 0, 0.733669,0.052323) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503418,-0.0327855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452098,-0.00431871) , 
1, -0.759506, 1, 0, 0.458795,-0.0184283) , 
1, -1.26741, 1, 0, 0.484459,-0.0118225)    );
  // itree = 844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317424,0.0392409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117282,0.00384125) , 
1, -0.262367, 1, 0, 0.175533,0.0207359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438098,-0.0207719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744786,-0.000673757) , 
2, 0.53056, 1, 0, 0.56337,-0.0268599) , 
2, -0.862357, 1, 0, 0.480671,-0.016711)    );
  // itree = 845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226281,-0.00969379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474108,0.0384316) , 
0, -1.68666, 1, 0, 0.386769,0.0507566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.687716,-0.0312871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684513,3.64454e-05) , 
1, -0.480427, 1, 0, 0.6856,-0.0199434) , 
2, 0.114479, 1, 0, 0.534228,0.0158696)    );
  // itree = 846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4973,-0.0111856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868483,0.026837) , 
0, 1.9149, 1, 0, 0.538226,-0.0124703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357341,0.0295342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527097,-0.0105699) , 
0, 0.286873, 1, 0, 0.43036,0.0213788) , 
1, 0.294498, 1, 0, 0.49074,0.00243111)    );
  // itree = 847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0298938,-0.0858786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71897,0.0476997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489382,-0.00312582) , 
1, -1.36363, 1, 0, 0.510695,0.000815461) , 
0, -3.19263, 1, 0, 0.494963,-0.00354066)    );
  // itree = 848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353919,-0.00809268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755633,0.0354932) , 
2, -0.23958, 1, 0, 0.606795,0.0395951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397849,-0.018689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.941551,0.0288479) , 
3, 1.8429, 1, 0, 0.453952,-0.0291538) , 
1, -0.102661, 1, 0, 0.514247,-0.00203319)    );
  // itree = 849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271251,0.0083738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457155,-0.0250502) , 
2, -0.496253, 1, 0, 0.332169,-0.0111151) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.738222,0.0430158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6944,-0.00504471) , 
0, 1.17247, 1, 0, 0.717983,0.0399469) , 
2, -0.00680894, 1, 0, 0.529713,0.0150296)    );
  // itree = 850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0703606,-0.072848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50916,-0.00188702) , 
0, -3.16773, 1, 0, 0.493536,-0.00826116) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491819,0.0629029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452508,0.0114903) , 
1, 1.16635, 1, 0, 0.461618,0.0502548) , 
1, 1.06105, 1, 0, 0.487785,0.00228299)    );
  // itree = 851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140843,-0.038314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494581,-0.00579856) , 
0, -2.26952, 1, 0, 0.458588,-0.0171625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.969773,0.0410036) , 
3, 2.67406, 1, 0, 0.47231,-0.0146819)    );
  // itree = 852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436902,-0.0124556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714298,-0.0470744) , 
0, 2.50199, 1, 0, 0.45523,-0.0300225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283962,0.0391688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696145,0.0149417) , 
3, 0.292804, 1, 0, 0.49207,0.0677194) , 
1, 1.60105, 1, 0, 0.457638,-0.0236337)    );
  // itree = 853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214093,-0.00438317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734927,0.0245165) , 
3, -0.0603134, 1, 0, 0.420955,0.0132387) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672838,-0.0285899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.938066,0.0164933) , 
3, 2.25471, 1, 0, 0.735627,-0.0381985) , 
2, 0.897689, 1, 0, 0.486027,0.00260187)    );
  // itree = 854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184439,0.0236187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512845,0.0526603) , 
3, -0.998779, 1, 0, 0.268225,0.0515218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882015,-0.0448264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636151,0.000507637) , 
3, -0.896819, 1, 0, 0.575664,-0.00988767) , 
2, -1.07472, 1, 0, 0.527441,-0.000255335)    );
  // itree = 855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250532,0.00468975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546964,-0.0492938) , 
3, 0.254922, 1, 0, 0.278784,-0.00269955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613278,0.0484348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824674,-0.00617182) , 
3, 0.809194, 1, 0, 0.718837,0.0491798) , 
2, -0.283978, 1, 0, 0.523685,0.0261726)    );
  // itree = 856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220377,-0.0265442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627585,0.00322693) , 
2, -0.332516, 1, 0, 0.359131,-0.0309533) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.706879,0.0176346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687785,-0.0121758) , 
0, 1.63576, 1, 0, 0.699522,0.0125017) , 
2, 0.352787, 1, 0, 0.49736,-0.0133067)    );
  // itree = 857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610302,-1.15022e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582737,-0.0441568) , 
2, 0.556368, 1, 0, 0.597263,-0.0459593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308383,-0.010743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566594,0.00642988) , 
0, -1.05061, 1, 0, 0.484789,0.00225313) , 
1, -1.04839, 1, 0, 0.502622,-0.00539103)    );
  // itree = 858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996162,-0.0200881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277625,-0.0433578) , 
3, -0.809255, 1, 0, 0.160536,-0.0532436) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506935,0.0483508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620185,0.00670874) , 
0, -1.74763, 1, 0, 0.613219,0.0176593) , 
2, -0.806007, 1, 0, 0.48468,-0.00247354)    );
  // itree = 859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393476,-0.0185199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710593,-5.31052e-06) , 
2, 0.500792, 1, 0, 0.505694,-0.0259003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563123,0.0439929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256957,-0.026519) , 
1, 1.56725, 1, 0, 0.469823,0.0437132) , 
1, 0.581975, 1, 0, 0.495298,-0.00572585)    );
  // itree = 860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244512,-0.00375527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311354,0.0881344) , 
1, 0.83625, 1, 0, 0.260489,0.0226535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484683,-0.0153768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.849839,0.0200927) , 
2, 1.165, 1, 0, 0.535449,-0.0255175) , 
0, -1.48672, 1, 0, 0.48287,-0.0163061)    );
  // itree = 861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541555,-0.0101425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709539,-0.0524172) , 
0, 1.17758, 1, 0, 0.570582,-0.0311933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570674,0.0451253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491422,-0.00217351) , 
1, -0.631071, 1, 0, 0.496913,0.00191193) , 
1, -0.819918, 1, 0, 0.513007,-0.00532007)    );
  // itree = 862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286739,0.0160067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671009,-0.0108791) , 
3, 0.0352258, 1, 0, 0.500246,-0.000316119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142824,-0.0124108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640088,0.0499387) , 
2, -1.35733, 1, 0, 0.53128,0.0751493) , 
1, 1.2714, 1, 0, 0.504318,0.00958474)    );
  // itree = 863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482082,0.0239908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658301,-0.00669291) , 
0, 0.676813, 1, 0, 0.545017,0.0264466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290085,-0.0442944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639176,0.0295264) , 
0, 1.00666, 1, 0, 0.395895,-0.0566269) , 
1, 1.2714, 1, 0, 0.526593,0.0161829)    );
  // itree = 864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.95735,0.0808764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526208,0.0104674) , 
1, -1.8533, 1, 0, 0.544576,0.0256305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0554726,-0.0590398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408671,-0.0142025) , 
0, 0.215124, 1, 0, 0.209032,-0.125293) , 
1, 1.56855, 1, 0, 0.512562,0.0112307)    );
  // itree = 865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425289,-0.0768015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490184,-0.0049483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522918,0.0583423) , 
1, 1.81309, 1, 0, 0.49171,-0.00472003) , 
1, -1.99935, 1, 0, 0.489471,-0.012122)    );
  // itree = 866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271903,0.00717924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673242,-0.0278244) , 
3, 0.192103, 1, 0, 0.413964,-0.00868845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.788753,0.00356805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768303,0.0271985) , 
1, -0.0904344, 1, 0, 0.778626,0.0345453) , 
2, 0.903798, 1, 0, 0.493212,0.000707132)    );
  // itree = 867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414138,0.0702705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627988,0.0163301) , 
0, -2.00232, 1, 0, 0.601002,0.0451198) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240584,0.0041763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566668,-0.015521) , 
2, -0.349281, 1, 0, 0.44409,-0.0173719) , 
1, -0.392075, 1, 0, 0.493889,0.00246073)    );
  // itree = 868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444821,-0.0779983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153203,-0.029325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545734,0.0118414) , 
0, -2.56266, 1, 0, 0.508579,0.0163324) , 
1, -1.83103, 1, 0, 0.506015,0.0102019)    );
  // itree = 869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530297,0.00163817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578885,0.0306975) , 
1, 0.330947, 1, 0, 0.538808,0.0125566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36021,-0.0291635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811074,0.0148746) , 
2, 0.820685, 1, 0, 0.447874,-0.0478204) , 
1, 0.704076, 1, 0, 0.509322,-0.0070213)    );
  // itree = 870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254818,0.145695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240113,-0.00393367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564889,-0.0193091) , 
2, -0.457259, 1, 0, 0.459812,-0.0282295) , 
0, -3.15088, 1, 0, 0.453272,-0.0222345)    );
  // itree = 871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.630445,0.0304448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588652,-0.0391411) , 
0, -0.826132, 1, 0, 0.598479,-0.0495814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238546,-0.0241608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543148,0.0107658) , 
0, -1.82049, 1, 0, 0.497848,0.0129448) , 
1, -1.0339, 1, 0, 0.515681,0.00186468)    );
  // itree = 872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334713,0.0158935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168088,-0.0274524) , 
1, 0.130065, 1, 0, 0.238015,-0.017997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452251,0.0320619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.772649,-0.00183577) , 
3, 0.340898, 1, 0, 0.638115,0.0290845) , 
2, -0.660692, 1, 0, 0.532671,0.0166764)    );
  // itree = 873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0262295,-0.0772861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306656,-0.014292) , 
2, -1.5907, 1, 0, 0.15551,-0.0714658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481659,0.00122238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.942009,0.0374182) , 
2, 1.46376, 1, 0, 0.51614,0.00746813) , 
0, -2.84999, 1, 0, 0.493062,0.00241683)    );
  // itree = 874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221197,-0.0662495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632694,-0.019122) , 
0, -1.45524, 1, 0, 0.558483,-0.0602948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51359,0.0127782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40855,-0.0132812) , 
1, 0.618148, 1, 0, 0.476117,0.00761292) , 
1, -1.05754, 1, 0, 0.48884,-0.00287641)    );
  // itree = 875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281001,-0.0311307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816536,0.00609751) , 
3, 0.165815, 1, 0, 0.514122,-0.0328876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597601,0.0389857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534579,0.00861909) , 
1, -0.88671, 1, 0, 0.538176,0.0220556) , 
1, -1.1416, 1, 0, 0.534183,0.0129352)    );
  // itree = 876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29729,-0.00107096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656411,-0.0216884) , 
2, -0.221327, 1, 0, 0.441407,-0.018743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527491,0.0402797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752234,0.00101519) , 
2, 0.454775, 1, 0, 0.717709,0.0169047) , 
0, 1.20503, 1, 0, 0.50639,-0.0103591)    );
  // itree = 877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429543,-0.0273624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654413,-0.00754724) , 
0, -0.19032, 1, 0, 0.546897,-0.040525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508145,0.0200372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44382,-0.00405129) , 
1, 0.0881991, 1, 0, 0.450901,-0.00117772) , 
1, -0.0789854, 1, 0, 0.491555,-0.017841)    );
  // itree = 878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267043,-0.0418025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23502,0.00296821) , 
1, 1.00515, 1, 0, 0.260505,-0.0785139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.901857,0.0699482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585222,0.00517428) , 
1, -1.66211, 1, 0, 0.60024,0.0175832) , 
0, -1.01549, 1, 0, 0.502729,-0.00999854)    );
  // itree = 879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524189,-0.0139219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458745,0.00708626) , 
1, -0.537751, 1, 0, 0.488326,-0.00541213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485474,-0.0452165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398166,-0.00569626) , 
1, 0.935556, 1, 0, 0.434421,-0.0464553) , 
1, 0.531499, 1, 0, 0.470147,-0.0192533)    );
  // itree = 880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16917,0.0306881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50531,-0.0127667) , 
3, -1.13308, 1, 0, 0.436911,-0.015534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.756773,0.0274945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628705,0.00139154) , 
1, 0.0956, 1, 0, 0.702203,0.0359397) , 
0, 1.19907, 1, 0, 0.502161,-0.00287373)    );
  // itree = 881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0971051,0.000944215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522575,0.0517061) , 
3, -1.10328, 1, 0, 0.249393,0.047937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635437,0.0056822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495826,-0.024008) , 
1, 0.297136, 1, 0, 0.581834,-0.0134565) , 
2, -0.780555, 1, 0, 0.496738,0.00225856)    );
  // itree = 882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318289,-0.0588998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666106,-0.0125263) , 
2, 0.35725, 1, 0, 0.50876,-0.0949687) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3355,0.0156702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717814,-0.0106922) , 
3, 0.34753, 1, 0, 0.516576,0.00581858) , 
1, -1.33134, 1, 0, 0.515707,-0.00539191)    );
  // itree = 883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672584,0.017635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471866,-0.0141485) , 
1, -0.734094, 1, 0, 0.522294,-0.012896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423011,0.0574759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638026,0.000431174) , 
3, 0.392451, 1, 0, 0.537569,0.0630528) , 
1, 1.25598, 1, 0, 0.52428,-0.00301981)    );
  // itree = 884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307352,0.00122703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230194,-0.0599343) , 
0, -1.3069, 1, 0, 0.290715,-0.0391704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.581361,0.00857645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624314,-0.0195802) , 
0, 1.49052, 1, 0, 0.592676,0.00191859) , 
0, -0.995569, 1, 0, 0.503674,-0.0101923)    );
  // itree = 885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240394,-0.022556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566825,0.00583454) , 
2, -1.21466, 1, 0, 0.531135,0.0066491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.657625,0.0500404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423617,0.000395664) , 
1, 1.68384, 1, 0, 0.563122,0.0615496) , 
1, 1.15506, 1, 0, 0.535395,0.0139604)    );
  // itree = 886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.669969,0.0356127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728339,-0.0636146) , 
2, 1.50417, 1, 0, 0.674211,0.0559176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326574,-0.0222156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584594,0.00770005) , 
0, -0.213974, 1, 0, 0.476781,-0.011483) , 
1, -0.227901, 1, 0, 0.55005,0.0135305)    );
  // itree = 887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483146,-0.00495724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478702,0.0135169) , 
1, 0.0932693, 1, 0, 0.480923,0.00839043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701983,-0.0421956) , 
0, 2.82704, 1, 0, 0.49062,0.00393696)    );
  // itree = 888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22027,-0.0134552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554461,0.00990922) , 
2, -0.560582, 1, 0, 0.401146,-0.000486886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383472,-0.0353294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777021,-0.00691053) , 
3, 0.946935, 1, 0, 0.626901,-0.0467889) , 
2, 0.516079, 1, 0, 0.47768,-0.0161838)    );
  // itree = 889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346042,-0.0098909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394783,0.0355398) , 
1, 0.10947, 1, 0, 0.367124,0.0165001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0668182,-0.0460504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68388,-0.00485187) , 
3, -0.0792213, 1, 0, 0.56954,-0.0295667) , 
0, -0.70186, 1, 0, 0.498238,-0.0133394)    );
  // itree = 890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251554,0.00834109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500448,-0.015893) , 
2, -0.642173, 1, 0, 0.407282,-0.0159224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.591314,0.0436596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90959,0.0114465) , 
3, 1.4405, 1, 0, 0.782586,0.0622029) , 
0, 1.20503, 1, 0, 0.49131,0.00156937)    );
  // itree = 891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438693,-0.0579687) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194315,0.177636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545865,0.00147497) , 
2, -2.08592, 1, 0, 0.53422,0.00723125) , 
1, -1.92948, 1, 0, 0.531277,0.0028027)    );
  // itree = 892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281527,0.0370865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510584,-0.00905659) , 
0, -1.99797, 1, 0, 0.484367,-0.011481) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470265,0.0637108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464748,0.0425753) , 
1, 2.16859, 1, 0, 0.46749,0.0896983) , 
1, 1.71996, 1, 0, 0.483513,-0.00635542)    );
  // itree = 893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495832,-0.0431447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449655,-0.00523157) , 
1, -1.67887, 1, 0, 0.452332,-0.015042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608473,0.0354071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.867152,0.000801414) , 
3, 1.7771, 1, 0, 0.755768,0.0429693) , 
0, 2.01604, 1, 0, 0.482341,-0.00930484)    );
  // itree = 894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.826256,0.066909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672261,0.0372382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481455,-0.00268187) , 
1, -1.29375, 1, 0, 0.493597,-0.00118251) , 
1, -1.86762, 1, 0, 0.506746,0.00318489)    );
  // itree = 895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22682,-0.0175246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.860406,0.048511) , 
3, -0.383647, 1, 0, 0.651065,0.0460349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353223,0.00865459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608539,-0.0183061) , 
2, 0.0154847, 1, 0, 0.485591,-0.0116656) , 
1, -0.743609, 1, 0, 0.523074,0.00140476)    );
  // itree = 896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302276,-0.0454109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238354,-0.0142732) , 
1, -1.4817, 1, 0, 0.245115,-0.0389453) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.771023,-0.0108888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701973,0.0158698) , 
1, -0.185249, 1, 0, 0.729123,0.0115999) , 
3, 0.191234, 1, 0, 0.477783,-0.0146477)    );
  // itree = 897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370288,-0.00272767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814676,-0.112208) , 
3, 0.762572, 1, 0, 0.423959,-0.0202657) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.792959,0.0305979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635184,-0.00552027) , 
1, 0.398747, 1, 0, 0.732324,0.031854) , 
0, 0.918314, 1, 0, 0.510673,-0.00560936)    );
  // itree = 898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735682,0.0470034) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490021,-0.00869027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490837,0.0122294) , 
1, 0.28184, 1, 0, 0.490389,0.000824927) , 
1, -1.59845, 1, 0, 0.50343,0.00544511)    );
  // itree = 899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277369,0.0168564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662718,-0.00908309) , 
3, -0.516641, 1, 0, 0.558536,-0.00695302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36192,-0.0524018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26771,-0.00231053) , 
1, 1.45626, 1, 0, 0.311216,-0.0649577) , 
1, 1.14209, 1, 0, 0.51322,-0.0175813)    );
  // itree = 900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316216,0.00758711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408578,-0.0277254) , 
0, -0.938607, 1, 0, 0.350063,-0.0204758) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.653386,0.0165838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462635,-0.0164228) , 
1, 1.39543, 1, 0, 0.63055,0.024625) , 
0, -0.0499311, 1, 0, 0.489597,0.00196059)    );
  // itree = 901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182595,0.000240277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733349,0.0235385) , 
3, -0.550721, 1, 0, 0.405411,0.0240131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155609,-0.0374699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777649,-0.00133042) , 
3, 0.547046, 1, 0, 0.608787,-0.0230576) , 
0, 0.394028, 1, 0, 0.492012,0.00396957)    );
  // itree = 902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425241,0.0107491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630498,-0.0188736) , 
2, 0.407243, 1, 0, 0.473857,0.00771572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.724245,0.0354396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813851,-0.0082201) , 
0, 2.21037, 1, 0, 0.757474,0.0431719) , 
2, 0.983024, 1, 0, 0.529238,0.0146391)    );
  // itree = 903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14555,0.116322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123589,-0.029387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605808,-0.00134722) , 
3, -0.818526, 1, 0, 0.509761,-0.0123743) , 
0, -3.25007, 1, 0, 0.497365,-0.00864395)    );
  // itree = 904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127794,-0.00926417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260318,-0.0623828) , 
2, -1.22979, 1, 0, 0.176922,-0.0714315) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180941,-0.0177457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657223,0.0187763) , 
2, -0.858428, 1, 0, 0.589333,0.0266355) , 
0, -2.03899, 1, 0, 0.53234,0.0130831)    );
  // itree = 905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659107,0.0215795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885726,0.0701437) , 
1, -1.5402, 1, 0, 0.759572,0.0894898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483828,-0.00794933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504431,0.0127102) , 
1, -0.150955, 1, 0, 0.496484,0.00875678) , 
1, -1.1416, 1, 0, 0.537057,0.0212073)    );
  // itree = 906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397421,0.00348344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585219,-0.0127076) , 
0, -0.0225028, 1, 0, 0.491007,-0.00933551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616257,0.0785096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314846,0.00516513) , 
1, 2.19081, 1, 0, 0.467176,0.0975) , 
1, 1.60105, 1, 0, 0.489631,-0.00316571)    );
  // itree = 907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175507,-0.0376272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738308,0.0014199) , 
3, -0.524541, 1, 0, 0.568513,-0.0261091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338301,0.0320916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570871,-0.00274679) , 
0, -1.20088, 1, 0, 0.516197,0.00762698) , 
1, -0.417903, 1, 0, 0.534507,-0.0041805)    );
  // itree = 908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481978,0.0482417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164061,-0.0107236) , 
1, -0.208286, 1, 0, 0.290241,0.0354837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395009,-0.0122541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.855182,0.00356288) , 
3, 1.00855, 1, 0, 0.51643,-0.0184869) , 
0, -1.83914, 1, 0, 0.482525,-0.0103969)    );
  // itree = 909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501096,0.0498215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199684,-0.0359698) , 
1, -0.848276, 1, 0, 0.233601,-0.0485661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.662946,-0.0025957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542324,0.0146841) , 
1, 0.0705562, 1, 0, 0.604004,0.0105228) , 
0, -1.28819, 1, 0, 0.511264,-0.00427161)    );
  // itree = 910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272822,-0.00524317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380328,-0.0437267) , 
2, -0.106216, 1, 0, 0.288949,-0.023232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.626328,-0.0265095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747021,0.0129571) , 
1, -1.18082, 1, 0, 0.725262,0.0126243) , 
2, 0.143877, 1, 0, 0.489106,-0.00678303)    );
  // itree = 911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281455,-0.0479367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.806348,-0.0223736) , 
3, 0.240362, 1, 0, 0.500935,-0.0886361) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498451,-0.00559871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258111,-0.0386226) , 
1, 1.5603, 1, 0, 0.477288,-0.0183504) , 
1, -1.33919, 1, 0, 0.479783,-0.0257668)    );
  // itree = 912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151442,0.0144035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134781,-0.0453435) , 
0, -2.07597, 1, 0, 0.141596,-0.0536046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513722,0.0109741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689544,-0.00907529) , 
0, 0.622933, 1, 0, 0.583597,0.00785687) , 
2, -0.874186, 1, 0, 0.485106,-0.00583848)    );
  // itree = 913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219185,-0.0207791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580804,0.00456455) , 
0, -1.56562, 1, 0, 0.51177,0.000735882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.804842,0.0801292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232277,-0.0181451) , 
1, 1.8987, 1, 0, 0.522889,0.0762071) , 
1, 1.45294, 1, 0, 0.512455,0.00538595)    );
  // itree = 914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417346,0.0594816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505599,-0.014935) , 
0, -2.66768, 1, 0, 0.500697,-0.024454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445737,-0.0238151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464584,0.0248767) , 
1, 0.509669, 1, 0, 0.462744,0.0346395) , 
1, 0.368059, 1, 0, 0.485408,-0.000648818)    );
  // itree = 915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374254,0.0106792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499801,-0.0223286) , 
0, -1.30715, 1, 0, 0.476744,-0.0378563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514573,-0.0370368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496956,0.00800264) , 
1, 0.601527, 1, 0, 0.499152,0.0028784) , 
1, 0.423988, 1, 0, 0.484453,-0.0238429)    );
  // itree = 916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470156,0.00947884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677929,-0.0044706) , 
0, 0.863792, 1, 0, 0.534299,0.0119958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230089,0.00102811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510941,-0.0241734) , 
0, -0.358895, 1, 0, 0.389934,-0.0333958) , 
1, 1.25419, 1, 0, 0.51163,0.00486813)    );
  // itree = 917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504979,0.0280576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742528,0.00316378) , 
0, 0.449965, 1, 0, 0.597027,0.0378681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620169,-0.0574728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496114,-0.00654203) , 
2, -1.36955, 1, 0, 0.443498,-0.0258312) , 
1, -0.133281, 1, 0, 0.510957,0.00215751)    );
  // itree = 918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323281,0.00269025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766712,0.0310582) , 
2, -0.27556, 1, 0, 0.48688,0.025329) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543075,-0.0362888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671213,-0.00133412) , 
0, 0.864854, 1, 0, 0.640966,-0.0202564) , 
0, 0.540177, 1, 0, 0.546351,0.0077351)    );
  // itree = 919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0743187,-0.0778936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520612,0.00940753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745664,-0.0619804) , 
2, 1.7828, 1, 0, 0.52938,0.0154456) , 
0, -3.22854, 1, 0, 0.516574,0.0108928)    );
  // itree = 920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0756707,0.00421823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537626,0.0273921) , 
3, -1.18405, 1, 0, 0.380623,0.0398744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575956,-0.00801911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646782,0.0203198) , 
1, 0.67719, 1, 0, 0.595894,0.00201499) , 
0, -0.4832, 1, 0, 0.511597,0.0168403)    );
  // itree = 921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510327,0.0292633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868751,-0.00345979) , 
3, 0.448731, 1, 0, 0.641913,0.0354618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309684,-0.0143555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.826911,0.0112164) , 
3, 0.760049, 1, 0, 0.462863,-0.0158264) , 
1, -0.705165, 1, 0, 0.506021,-0.00346397)    );
  // itree = 922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14774,-0.0782972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190594,0.00604161) , 
1, -0.00978698, 1, 0, 0.166453,-0.133209) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551348,0.00486788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416756,-0.0181768) , 
1, 0.702061, 1, 0, 0.508716,-0.00490567) , 
0, -2.84999, 1, 0, 0.487984,-0.0126772)    );
  // itree = 923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490685,-0.0220511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483096,0.00752542) , 
1, -0.555129, 1, 0, 0.485474,-0.0046463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15244,-0.0694295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677557,0.0352695) , 
1, 1.82726, 1, 0, 0.377481,-0.091655) , 
1, 1.54875, 1, 0, 0.477879,-0.0107657)    );
  // itree = 924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325666,0.0101949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611304,-0.0214044) , 
2, -0.0990119, 1, 0, 0.410814,0.00167428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.732684,0.0567348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719369,0.00872371) , 
0, 0.237923, 1, 0, 0.721606,0.0319046) , 
2, 0.44688, 1, 0, 0.522154,0.0125042)    );
  // itree = 925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293022,-0.068514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.879419,0.0199028) , 
3, 0.101651, 1, 0, 0.590537,-0.0908055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201506,0.112592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531027,0.00217001) , 
2, -1.86672, 1, 0, 0.51719,0.00879183) , 
1, -1.48631, 1, 0, 0.522661,0.00136349)    );
  // itree = 926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0390538,-0.0545364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370149,0.0347549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585959,-0.000556424) , 
2, -1.00971, 1, 0, 0.557937,0.00830237) , 
2, -1.97084, 1, 0, 0.531583,0.00412886)    );
  // itree = 927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.594545,0.0516304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731484,0.00777538) , 
0, -0.174401, 1, 0, 0.681271,0.060072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555384,-0.0496614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492376,-0.00316862) , 
1, -1.18279, 1, 0, 0.496307,-0.0133947) , 
1, -1.42554, 1, 0, 0.510331,-0.00782461)    );
  // itree = 928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18427,-0.0765927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.903296,-0.0217784) , 
3, 0.0689898, 1, 0, 0.591433,-0.0900455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.630642,-0.0173418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485789,0.00534938) , 
1, -0.943798, 1, 0, 0.505967,0.00407898) , 
1, -1.65561, 1, 0, 0.511526,-0.00204314)    );
  // itree = 929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105175,-0.0429244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554985,0.00222378) , 
0, -2.38534, 1, 0, 0.515278,-0.00213445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139857,-0.0609044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603593,0.000103328) , 
2, 0.0726371, 1, 0, 0.3135,-0.0979133) , 
1, 1.25419, 1, 0, 0.48757,-0.0152869)    );
  // itree = 930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557755,-0.0093484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612493,0.0167653) , 
1, -1.37885, 1, 0, 0.592737,0.0155232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450216,-0.0493301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482845,-0.00416491) , 
1, -0.381658, 1, 0, 0.479568,-0.0202088) , 
1, -0.605346, 1, 0, 0.509984,-0.0106053)    );
  // itree = 931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441953,0.0485698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497092,0.00969463) , 
0, -1.05814, 1, 0, 0.47251,0.0488401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253584,-0.0493906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773903,3.94978e-05) , 
3, 0.265595, 1, 0, 0.694712,-0.0217258) , 
2, 0.391241, 1, 0, 0.560998,0.0207385)    );
  // itree = 932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203272,-0.0115824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470487,0.0184459) , 
2, -1.25586, 1, 0, 0.378887,0.0158545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488448,-0.0316155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611999,-0.00555032) , 
0, -0.0206442, 1, 0, 0.596127,-0.0206825) , 
0, -0.416978, 1, 0, 0.496469,-0.0039212)    );
  // itree = 933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404351,-0.00427021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919352,0.0287438) , 
3, 1.21627, 1, 0, 0.491722,0.00134897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147751,-0.0244893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431085,-0.0443954) , 
2, -1.07257, 1, 0, 0.369012,-0.0841468) , 
1, 1.15506, 1, 0, 0.47266,-0.011932)    );
  // itree = 934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193895,0.0087815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442995,-0.0281215) , 
3, -0.847968, 1, 0, 0.366292,-0.0461683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.814553,0.0271432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560936,-0.0208787) , 
1, 0.107382, 1, 0, 0.67506,0.00121603) , 
0, 0.540177, 1, 0, 0.483508,-0.0281801)    );
  // itree = 935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110337,-0.0791024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203272,-0.0252975) , 
1, 0.0225495, 1, 0, 0.158712,-0.0934328) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399767,0.0376117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538076,-0.00704464) , 
0, -1.30178, 1, 0, 0.512786,-5.53892e-05) , 
0, -2.84999, 1, 0, 0.491863,-0.00557333)    );
  // itree = 936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17977,-0.00703202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298667,-0.0328143) , 
2, -1.30598, 1, 0, 0.242925,-0.0410538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437153,0.0220281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54213,-0.00721701) , 
0, -0.679174, 1, 0, 0.522664,-0.00505719) , 
0, -1.56562, 1, 0, 0.467788,-0.0121186)    );
  // itree = 937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586381,0.0510442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.939134,0.0346899) , 
3, 0.563942, 1, 0, 0.712714,0.078292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466672,-0.013649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541202,0.0222231) , 
1, 1.0795, 1, 0, 0.478595,-0.0166162) , 
1, -1.1416, 1, 0, 0.509161,-0.00422527)    );
  // itree = 938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285576,-0.0351637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251839,-0.00992515) , 
1, -0.438842, 1, 0, 0.263676,-0.0414529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476293,0.0252316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655853,-0.00303273) , 
2, -0.0857811, 1, 0, 0.618831,0.00730092) , 
0, -0.70186, 1, 0, 0.48688,-0.0108126)    );
  // itree = 939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221191,-0.0248074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685315,0.0197758) , 
0, -1.72297, 1, 0, 0.610887,0.0262425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52959,-0.0207959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481358,0.00359078) , 
1, -0.166284, 1, 0, 0.489229,-0.00241695) , 
1, -0.537773, 1, 0, 0.523463,0.00564766)    );
  // itree = 940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566586,-0.0416887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.822651,0.0451063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492469,0.00219774) , 
1, -0.99465, 1, 0, 0.526159,0.0127167) , 
1, -1.72494, 1, 0, 0.528172,0.00762891)    );
  // itree = 941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.02034,-0.020554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560449,0.0625294) , 
3, -2.01689, 1, 0, 0.346483,0.0761094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.590464,0.0134931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470189,-0.00488838) , 
1, -0.102661, 1, 0, 0.522304,0.00579509) , 
0, -1.99797, 1, 0, 0.501836,0.0139804)    );
  // itree = 942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0459993,0.0092705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256512,-0.0404301) , 
3, -1.58395, 1, 0, 0.1521,-0.0429606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559712,-0.0227307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578032,0.00718714) , 
1, -1.3203, 1, 0, 0.576195,0.00938911) , 
2, -1.35733, 1, 0, 0.516445,0.00201362)    );
  // itree = 943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123018,0.00212613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704134,0.0622914) , 
3, -1.17452, 1, 0, 0.349293,0.054927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617247,-0.0011954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617203,0.0509542) , 
1, 1.45393, 1, 0, 0.617244,0.00412968) , 
0, -1.15223, 1, 0, 0.543525,0.0181052)    );
  // itree = 944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22959,0.0235216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391473,-0.0339765) , 
2, -1.08591, 1, 0, 0.345761,-0.0529061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611449,0.00949259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275246,-0.0845046) , 
1, 1.59954, 1, 0, 0.59568,0.0085544) , 
0, -0.271513, 1, 0, 0.487113,-0.0181446)    );
  // itree = 945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362742,-0.00575651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599265,0.0277983) , 
0, 0.0523062, 1, 0, 0.42706,0.00797454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.718658,0.0265938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661446,-0.0226785) , 
0, 0.175735, 1, 0, 0.669513,-0.0329139) , 
2, 0.608924, 1, 0, 0.494857,-0.00345909)    );
  // itree = 946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214305,-0.00625442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374562,0.0287901) , 
0, -1.63133, 1, 0, 0.310139,0.0309214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150308,-0.0592672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710364,-0.00215373) , 
3, -0.255089, 1, 0, 0.625405,-0.0240281) , 
2, -0.351925, 1, 0, 0.511311,-0.00414195)    );
  // itree = 947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0569777,-0.0474239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674655,0.0290464) , 
2, -1.64876, 1, 0, 0.624334,0.0488912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237592,-0.0117754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781604,0.00969032) , 
3, 0.408103, 1, 0, 0.462845,-0.00704613) , 
1, 0.103994, 1, 0, 0.533558,0.0174478)    );
  // itree = 948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.707497,0.0180743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48479,-0.00374935) , 
1, -1.12789, 1, 0, 0.523924,-0.00102602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242828,-0.0302855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.871123,0.00756967) , 
3, 1.2092, 1, 0, 0.361265,-0.0457409) , 
1, 0.814014, 1, 0, 0.481964,-0.0125607)    );
  // itree = 949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304079,-0.00652384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475223,-0.0420177) , 
0, -0.685387, 1, 0, 0.326213,-0.0240572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.600527,0.0231828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679908,-0.00441506) , 
0, 1.55259, 1, 0, 0.62747,0.0280272) , 
0, -0.331717, 1, 0, 0.492947,0.00476947)    );
  // itree = 950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367282,-0.0260226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71212,0.00149685) , 
2, 0.398679, 1, 0, 0.51008,-0.0282405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534095,0.023938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383362,-0.0118383) , 
1, 1.38657, 1, 0, 0.479147,0.018166) , 
1, 0.560452, 1, 0, 0.500061,-0.0132098)    );
  // itree = 951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194738,-0.0233016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517703,0.020519) , 
2, -1.33131, 1, 0, 0.458114,0.0269764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271072,-0.0379633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751858,0.00121475) , 
2, 0.186242, 1, 0, 0.615417,-0.0221866) , 
0, 0.394028, 1, 0, 0.525391,0.00594974)    );
  // itree = 952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0509452,-0.0593394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488469,0.0134596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774297,-0.0164984) , 
2, 0.769163, 1, 0, 0.566302,0.0122036) , 
0, -3.25007, 1, 0, 0.544895,0.0080008)    );
  // itree = 953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485783,-0.0369579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475775,0.0105648) , 
1, -1.1325, 1, 0, 0.47716,0.00903339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119242,-0.0472728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756741,-0.00989198) , 
3, 1.02216, 1, 0, 0.61649,-0.0441057) , 
0, 1.20503, 1, 0, 0.509434,-0.00327574)    );
  // itree = 954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566064,-0.00741766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522257,0.0214872) , 
1, -0.380549, 1, 0, 0.545468,0.0121992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156849,-0.0377055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76159,-0.00227941) , 
3, 0.336059, 1, 0, 0.43125,-0.0411978) , 
1, 0.527824, 1, 0, 0.505219,-0.00661738)    );
  // itree = 955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.752336,0.0469311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494421,-0.0244304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488054,-0.0031913) , 
1, -0.453299, 1, 0, 0.489978,-0.0204506) , 
1, -1.86762, 1, 0, 0.498707,-0.0161306)    );
  // itree = 956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265278,-0.014608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293719,-0.0489393) , 
2, 0.0063529, 1, 0, 0.270937,-0.0472421) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.924305,0.0381895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697735,-0.0138712) , 
1, -0.767613, 1, 0, 0.753789,-0.00962086) , 
3, 0.281919, 1, 0, 0.490845,-0.0301081)    );
  // itree = 957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38467,0.0274504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154209,-0.0384711) , 
1, -0.296517, 1, 0, 0.233339,-0.0272276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404395,0.0484727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602586,-0.00248395) , 
2, -0.635367, 1, 0, 0.57381,0.00878903) , 
0, -1.40205, 1, 0, 0.494616,0.000411579)    );
  // itree = 958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190835,-0.00976219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880873,0.0427404) , 
3, -0.315828, 1, 0, 0.364164,0.00659749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544399,0.00511618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671292,-0.0258003) , 
2, 0.454358, 1, 0, 0.617382,-0.0267156) , 
0, -0.416978, 1, 0, 0.504121,-0.0118151)    );
  // itree = 959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186829,-0.0059291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473979,-0.0260896) , 
3, -0.301016, 1, 0, 0.296456,-0.0324062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.653403,-0.0127109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699919,0.0206008) , 
1, -0.751023, 1, 0, 0.686025,0.0239785) , 
2, 0.0721134, 1, 0, 0.488926,-0.00454884)    );
  // itree = 960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947108,-0.052269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215743,0.00589302) , 
1, -0.557568, 1, 0, 0.174041,-0.0431495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194312,0.0200284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663787,0.0029245) , 
3, -0.518554, 1, 0, 0.550233,0.01224) , 
0, -2.39443, 1, 0, 0.514368,0.00695938)    );
  // itree = 961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416611,0.00143653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617379,-0.0273764) , 
0, -0.331717, 1, 0, 0.523712,-0.0294996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57665,0.0444512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46776,0.00616092) , 
1, 0.395972, 1, 0, 0.486307,0.0239342) , 
1, 0.213586, 1, 0, 0.507666,-0.00657758)    );
  // itree = 962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.630146,0.0186782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383424,-0.0548761) , 
1, -0.238148, 1, 0, 0.602266,0.0209004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368616,-0.00368724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598122,-0.0225909) , 
0, 1.37578, 1, 0, 0.41358,-0.0158524) , 
1, -0.0789854, 1, 0, 0.497174,0.000430243)    );
  // itree = 963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273742,0.00517994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22081,-0.023545) , 
2, -0.670492, 1, 0, 0.247441,-0.0231962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696978,0.0396244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732694,0.00549799) , 
3, 0.157581, 1, 0, 0.729202,0.0205427) , 
3, -0.0725463, 1, 0, 0.525939,0.00208851)    );
  // itree = 964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441314,-0.00468538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592045,-0.0255295) , 
0, 1.39097, 1, 0, 0.45784,-0.014876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63601,0.0558848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820373,0.0102081) , 
3, 0.975058, 1, 0, 0.775682,0.048723) , 
2, 0.973129, 1, 0, 0.519477,-0.00254253)    );
  // itree = 965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567972,-0.0313322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542496,-0.000117674) , 
1, -1.14623, 1, 0, 0.554295,-0.0320199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532537,0.018098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314414,-0.0228528) , 
1, 1.45679, 1, 0, 0.499768,0.0213772) , 
1, -0.480148, 1, 0, 0.517615,0.00390027)    );
  // itree = 966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0527355) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516827,0.0517195) , 
3, -1.93084, 1, 0, 0.289217,0.0668975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277318,-0.0241888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673232,0.00473649) , 
2, -0.438405, 1, 0, 0.545947,-0.00806375) , 
0, -2.38608, 1, 0, 0.522024,-0.00107876)    );
  // itree = 967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279224,-0.00441728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541439,-0.0297942) , 
3, 0.171552, 1, 0, 0.378748,-0.0326218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.91152,0.0218936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818936,-0.0124036) , 
2, 1.09341, 1, 0, 0.867368,0.00774262) , 
3, 1.14303, 1, 0, 0.480526,-0.024214)    );
  // itree = 968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0778525,0.0425077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352309,-0.0375684) , 
3, -1.60724, 1, 0, 0.280066,-0.0608233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.885307,0.0651613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566062,0.010227) , 
1, -1.99411, 1, 0, 0.579683,0.0224705) , 
0, -1.06144, 1, 0, 0.490268,-0.00238688)    );
  // itree = 969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369906,-0.00374869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584398,-0.0714861) , 
2, 0.311368, 1, 0, 0.397196,-0.0311496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320599,-0.020407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730393,0.0167591) , 
2, 0.0994792, 1, 0, 0.632275,0.0154908) , 
0, 0.0705566, 1, 0, 0.512861,-0.00820131)    );
  // itree = 970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565264,0.0298232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600843,-0.00666535) , 
0, 0.0281408, 1, 0, 0.585252,0.0174546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402379,-0.0136083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505028,0.0168104) , 
1, 1.2246, 1, 0, 0.4257,-0.0141623) , 
1, -0.102661, 1, 0, 0.490549,-0.00131184)    );
  // itree = 971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356554,0.0131421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735384,-0.0191135) , 
3, 0.458809, 1, 0, 0.490615,0.0020705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.824772,0.051082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.89767,0.0175679) , 
2, 1.54775, 1, 0, 0.861824,0.0806157) , 
0, 2.56595, 1, 0, 0.519429,0.00816731)    );
  // itree = 972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141349,-0.0394827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179811,0.0169017) , 
1, 1.01669, 1, 0, 0.149335,-0.0504237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563448,0.0343971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622495,0.00129572) , 
0, -0.18957, 1, 0, 0.602892,0.0231803) , 
2, -1.026, 1, 0, 0.526316,0.0107534)    );
  // itree = 973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521318,0.0228509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696844,-0.0216021) , 
2, 0.896858, 1, 0, 0.565583,0.0245289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256555,-0.0650662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440417,-0.00386141) , 
1, 0.303972, 1, 0, 0.425114,-0.0174012) , 
1, 0.157686, 1, 0, 0.493952,0.00314689)    );
  // itree = 974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.74282,0.0491446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395117,-0.015822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721277,0.00766708) , 
2, 0.983024, 1, 0, 0.456472,-0.0253604) , 
1, -1.83103, 1, 0, 0.466216,-0.021451)    );
  // itree = 975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219027,0.0138481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68617,0.0251315) , 
3, -0.349602, 1, 0, 0.492724,0.0395214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.687427,-0.0278176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.921324,0.0194046) , 
3, 2.50718, 1, 0, 0.734013,-0.0389891) , 
0, 1.77235, 1, 0, 0.52725,0.0282874)    );
  // itree = 976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529647,-0.0106698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529557,0.00753317) , 
1, 0.235038, 1, 0, 0.52961,-0.00601745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664985,0.082813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778472,0.0178793) , 
2, 0.376111, 1, 0, 0.721869,0.108334) , 
1, 1.61612, 1, 0, 0.539625,-6.1053e-05)    );
  // itree = 977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62434,0.0188329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486155,-0.00467972) , 
1, -0.658399, 1, 0, 0.5277,0.00353218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313863,0.0358269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395864,-0.0293327) , 
2, -1.01113, 1, 0, 0.380237,-0.0454144) , 
1, 0.996086, 1, 0, 0.495774,-0.00706468)    );
  // itree = 978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263845,-0.0143722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270486,0.022172) , 
1, 0.836115, 1, 0, 0.265344,-0.0153556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.640662,0.0302437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.806418,0.000975053) , 
3, 0.606621, 1, 0, 0.744313,0.0253009) , 
3, -0.0725463, 1, 0, 0.532561,0.00732666)    );
  // itree = 979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481597,-0.0590696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250388,-0.0233561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573697,0.00128512) , 
0, -1.22798, 1, 0, 0.489753,-0.0106705) , 
1, -1.66895, 1, 0, 0.489318,-0.0163933)    );
  // itree = 980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322015,0.0347951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59906,-0.00479432) , 
0, -1.11562, 1, 0, 0.522483,0.00656117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145665,-0.0544933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422291,-0.0206915) , 
0, -1.86525, 1, 0, 0.367547,-0.0621455) , 
1, 1.25419, 1, 0, 0.501067,-0.00293579)    );
  // itree = 981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131203,0.138033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12529,-0.0258157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594981,0.00141713) , 
3, -0.905917, 1, 0, 0.493291,-0.00594076) , 
2, -1.9954, 1, 0, 0.48253,-0.00300495)    );
  // itree = 982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110293,0.0235226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375956,-0.0307005) , 
3, -1.29416, 1, 0, 0.229765,-0.0279708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207104,0.0507807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636934,0.00602708) , 
3, -0.584606, 1, 0, 0.593253,0.0199908) , 
0, -1.56562, 1, 0, 0.508636,0.00882575)    );
  // itree = 983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.042139,-0.0203655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0294532,-0.0511155) , 
1, 0.877329, 1, 0, 0.0380427,-0.0367694) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543869,0.0401491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575078,-0.000908945) , 
0, -1.19672, 1, 0, 0.570545,0.0107388) , 
3, -1.46046, 1, 0, 0.515467,0.00582488)    );
  // itree = 984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.600571,0.0133343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430181,-0.013646) , 
1, -0.0847251, 1, 0, 0.5133,0.000541346) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213117,-0.0577051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412762,-0.0151675) , 
2, -0.646334, 1, 0, 0.308667,-0.0935716) , 
1, 1.48646, 1, 0, 0.495027,-0.00786259)    );
  // itree = 985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27678,0.10491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551696,-0.00424489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4397,0.0453352) , 
1, 1.60105, 1, 0, 0.544345,-0.00249562) , 
0, -2.84999, 1, 0, 0.531523,0.00278421)    );
  // itree = 986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391327,0.00329616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56466,-0.0312645) , 
2, 0.301829, 1, 0, 0.435516,-0.0136485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.861556,0.045669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745426,-0.000593038) , 
1, -0.336602, 1, 0, 0.795342,0.034291) , 
2, 0.903798, 1, 0, 0.516385,-0.00287439)    );
  // itree = 987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573817,-0.0116454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519062,0.0251606) , 
1, -0.0819864, 1, 0, 0.546456,0.012663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11764,-0.0433525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781893,0.0107113) , 
3, 0.460526, 1, 0, 0.344814,-0.0640962) , 
1, 1.17337, 1, 0, 0.515853,0.00101313)    );
  // itree = 988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.849645,0.108345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516717,-0.0207817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483893,0.00608186) , 
1, -0.471286, 1, 0, 0.494271,-0.00423763) , 
1, -1.99935, 1, 0, 0.503128,0.000848628)    );
  // itree = 989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0422951,-0.0163906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573838,0.0542039) , 
3, -1.41454, 1, 0, 0.249485,0.0490108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512923,-0.0334804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458202,-0.0105089) , 
1, -0.121025, 1, 0, 0.482251,-0.0439414) , 
2, -1.07257, 1, 0, 0.455407,-0.0332213)    );
  // itree = 990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512455,-0.0135455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328267,-0.0599199) , 
1, 0.345816, 1, 0, 0.488164,-0.0428349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135341,-0.0358569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652351,0.0208429) , 
2, -0.720059, 1, 0, 0.49647,0.00629289) , 
1, 0.527824, 1, 0, 0.490698,-0.027847)    );
  // itree = 991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237782,-0.0228265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280248,-0.0515037) , 
0, -1.37886, 1, 0, 0.248874,-0.0744602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305871,0.0281705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684522,-0.0010592) , 
3, -0.0527124, 1, 0, 0.591461,0.0137314) , 
0, -1.06144, 1, 0, 0.479661,-0.0150491)    );
  // itree = 992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498358,0.00764288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769735,0.0713766) , 
1, 0.641518, 1, 0, 0.514907,0.021798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224024,0.0458311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483301,-0.0304572) , 
3, -0.63769, 1, 0, 0.418691,-0.0363414) , 
1, 0.843066, 1, 0, 0.492377,0.00818424)    );
  // itree = 993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156294,-0.00884421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22213,-0.0289802) , 
3, -1.02711, 1, 0, 0.19137,-0.0486059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.778566,0.0271857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686767,-0.000469539) , 
0, 0.462896, 1, 0, 0.722398,0.0211961) , 
3, -0.298039, 1, 0, 0.50189,-0.00778894)    );
  // itree = 994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.756693,0.0630092) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0354336,-0.0669775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531938,0.000608726) , 
2, -2.08286, 1, 0, 0.517178,-0.00162224) , 
1, -1.99935, 1, 0, 0.524922,0.00233069)    );
  // itree = 995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367773,0.0199866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403573,-0.014124) , 
0, -1.0331, 1, 0, 0.390316,-0.00840507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.918359,0.0267245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776397,-0.00410944) , 
0, 2.46767, 1, 0, 0.879117,0.0258155) , 
3, 1.07673, 1, 0, 0.514388,0.000281138)    );
  // itree = 996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510339,-0.0113233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536476,-0.0876109) , 
2, 1.34498, 1, 0, 0.513444,-0.0460714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556881,0.0240163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456886,-0.00818096) , 
1, 0.280952, 1, 0, 0.497007,0.00861492) , 
1, -0.605346, 1, 0, 0.501741,-0.00713463)    );
  // itree = 997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244468,0.02451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615229,-0.000216434) , 
3, -0.613987, 1, 0, 0.525378,0.00935075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398752,-0.0376199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191437,-0.0311263) , 
1, 2.11596, 1, 0, 0.283587,-0.0865887) , 
1, 1.5856, 1, 0, 0.511033,0.00365902)    );
  // itree = 998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137995,-0.0219288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399802,-0.0505196) , 
3, -1.00341, 1, 0, 0.210876,-0.0664038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650324,-0.0699747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557038,0.00477424) , 
1, -2.0036, 1, 0, 0.560487,0.004377) , 
0, -1.61364, 1, 0, 0.498387,-0.00819549)    );
  // itree = 999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138546,-0.0470301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5644,-0.0110067) , 
2, -1.21045, 1, 0, 0.505829,-0.0335186) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354914,0.0305808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583196,0.00284061) , 
0, -0.505959, 1, 0, 0.493176,0.0248022) , 
1, 0.212582, 1, 0, 0.500285,-0.00796638)    );
  // itree = 1000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497353,-0.0752492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479289,-0.00493578) , 
1, -2.09933, 1, 0, 0.47982,-0.0139914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38019,0.0571073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452288,0.0151407) , 
0, 0.456086, 1, 0, 0.418695,0.0733301) , 
1, 1.60105, 1, 0, 0.47633,-0.00900515)    );
  // itree = 1001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114814,0.00982017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0712342) , 
1, 0.993633, 1, 0, 0.0720881,-0.0330991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458486,0.079907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580414,0.0102991) , 
0, -2.33283, 1, 0, 0.574921,0.0264555) , 
2, -1.64876, 1, 0, 0.53785,0.0220649)    );
  // itree = 1002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103191,-0.00263902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275323,-0.0636381) , 
3, -1.31625, 1, 0, 0.171372,-0.0736435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565908,-0.0281459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576442,0.00579669) , 
1, -1.70534, 1, 0, 0.57591,0.00758455) , 
2, -1.21466, 1, 0, 0.522304,-0.00317913)    );
  // itree = 1003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231776,-0.0118583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135329,-0.0344541) , 
1, 0.713904, 1, 0, 0.19292,-0.042647) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566501,0.00179337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.84092,0.0216) , 
2, 0.811591, 1, 0, 0.64429,0.0150173) , 
2, -0.780555, 1, 0, 0.533631,0.000880155)    );
  // itree = 1004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500277,-0.0202269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.856814,0.0294341) , 
0, 1.9149, 1, 0, 0.547628,-0.026252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190435,0.0224771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655734,-0.00434777) , 
3, -0.442754, 1, 0, 0.495294,0.00444352) , 
1, -0.112602, 1, 0, 0.518414,-0.00911686)    );
  // itree = 1005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158058,-0.00627156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203398,-0.0502378) , 
2, -1.09255, 1, 0, 0.175879,-0.0681721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252552,0.019108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652846,-0.0029086) , 
3, -0.135247, 1, 0, 0.527578,0.00667407) , 
0, -2.03899, 1, 0, 0.487561,-0.00184206)    );
  // itree = 1006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189002,-0.0305385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512459,-0.00702952) , 
0, -2.48909, 1, 0, 0.48445,-0.0175814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.941432,0.0554162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.898857,0.00557959) , 
2, 1.92444, 1, 0, 0.918471,0.0547552) , 
2, 1.4644, 1, 0, 0.518648,-0.0118818)    );
  // itree = 1007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.950066,0.0813129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539982,0.00444178) , 
1, -1.82651, 1, 0, 0.562778,0.0147619) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293932,-0.0318018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733179,0.00413587) , 
2, 0.698526, 1, 0, 0.385071,-0.0520392) , 
1, 0.370917, 1, 0, 0.489955,-0.0126125)    );
  // itree = 1008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413511,-0.015452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388011,0.0115975) , 
1, 1.04982, 1, 0, 0.407682,-0.0210527) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726989,0.0133897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743122,-0.0203659) , 
0, 2.12146, 1, 0, 0.730659,0.00996755) , 
2, 0.514398, 1, 0, 0.511511,-0.0110805)    );
  // itree = 1009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548268,0.000936197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40749,-0.0487164) , 
1, 0.937276, 1, 0, 0.539848,-0.00380673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425382,0.079164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533855,0.0292164) , 
0, -2.01022, 1, 0, 0.512091,0.0589238) , 
1, 1.1228, 1, 0, 0.535502,0.00601415)    );
  // itree = 1010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0544629,-0.0132575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427506,0.0830042) , 
0, -2.46195, 1, 0, 0.193552,0.0383916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256557,-0.0176258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61092,-0.000794558) , 
2, -0.671135, 1, 0, 0.531201,-0.00967784) , 
2, -1.411, 1, 0, 0.502225,-0.00555255)    );
  // itree = 1011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.686846,0.0608192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36827,-0.00104057) , 
1, -1.29311, 1, 0, 0.395598,0.0108673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290285,-0.0229054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862847,0.00302279) , 
3, 1.0887, 1, 0, 0.549857,-0.0270452) , 
0, 0.0289789, 1, 0, 0.477787,-0.00933255)    );
  // itree = 1012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0272533,-0.0075257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246341,0.041588) , 
3, -1.65896, 1, 0, 0.144989,0.0328087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311425,-0.0311112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635561,0.000835055) , 
2, -0.525062, 1, 0, 0.567374,-0.0174201) , 
3, -1.05444, 1, 0, 0.498127,-0.00918551)    );
  // itree = 1013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192342,-0.00265693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317051,-0.0406483) , 
2, -0.887094, 1, 0, 0.242696,-0.0467627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454575,0.026604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683817,-0.00825167) , 
3, 0.134102, 1, 0, 0.631552,2.48655e-05) , 
2, -0.420818, 1, 0, 0.484644,-0.0176513)    );
  // itree = 1014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291707,-0.0733156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628049,-0.0223859) , 
0, -0.137352, 1, 0, 0.443423,-0.111044) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.685496,0.0351777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448861,-0.0108535) , 
1, -0.68541, 1, 0, 0.486925,-0.00837775) , 
1, -1.48631, 1, 0, 0.483384,-0.0167368)    );
  // itree = 1015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24351,0.0472162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237648,-0.0182468) , 
0, -2.42965, 1, 0, 0.241637,0.037069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333515,-0.018281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.665765,0.00164191) , 
2, 0.0216522, 1, 0, 0.519776,-0.0172816) , 
0, -2.03899, 1, 0, 0.480213,-0.00955061)    );
  // itree = 1016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0899985,-0.00943823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251492,-0.0249903) , 
3, -1.34078, 1, 0, 0.194806,-0.0411528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.701793,-0.0370046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640211,0.0143573) , 
1, -1.52075, 1, 0, 0.645247,0.02193) , 
2, -0.420818, 1, 0, 0.478245,-0.00145812)    );
  // itree = 1017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123797,-0.0264799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469754,0.00803673) , 
2, -1.50189, 1, 0, 0.41439,0.00645695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536483,-0.0386597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.837306,0.00482497) , 
2, 0.998771, 1, 0, 0.675076,-0.0422264) , 
2, 0.391241, 1, 0, 0.517135,-0.0127307)    );
  // itree = 1018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550971,0.00973235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458629,-0.0567646) , 
1, -1.45327, 1, 0, 0.509354,-0.0512345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317612,-0.00115448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723782,0.0125585) , 
2, -0.00680894, 1, 0, 0.519405,0.0119273) , 
1, -1.10883, 1, 0, 0.518122,0.00386694)    );
  // itree = 1019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0950847,-0.00221013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4164,-0.0341763) , 
3, -1.27384, 1, 0, 0.223335,-0.043324) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267726,-0.0140755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647068,0.00280106) , 
2, -0.38852, 1, 0, 0.549519,-0.00394636) , 
0, -1.6198, 1, 0, 0.486173,-0.0115936)    );
  // itree = 1020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488335,0.0316273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232102,-0.00589701) , 
1, -0.32552, 1, 0, 0.301001,0.00809208) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559556,-0.0289741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.941194,0.0205523) , 
3, 2.09844, 1, 0, 0.607182,-0.046667) , 
2, -0.0811742, 1, 0, 0.455213,-0.019488)    );
  // itree = 1021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250807,-0.00170626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518622,-0.0245157) , 
2, -0.316463, 1, 0, 0.304831,-0.0150292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629096,0.0576473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715262,0.0114357) , 
0, -0.112911, 1, 0, 0.696087,0.0372883) , 
2, -0.0668243, 1, 0, 0.493118,0.010148)    );
  // itree = 1022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0565277,-0.00900307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173678,-0.0478595) , 
3, -1.37327, 1, 0, 0.102719,-0.0502222) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476601,0.0121755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.860914,-0.0157987) , 
3, 1.21614, 1, 0, 0.563754,0.0155723) , 
2, -1.08782, 1, 0, 0.497205,0.00607501)    );
  // itree = 1023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650085,0.0194224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521454,-0.0172799) , 
1, -1.45171, 1, 0, 0.543018,-0.0247473) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50138,0.00307706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557846,0.0568845) , 
1, 1.67919, 1, 0, 0.507108,0.0165229) , 
1, 0.187999, 1, 0, 0.52638,-0.00562582)    );
  // itree = 1024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116633,0.00496739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381525,0.0424314) , 
3, -1.03429, 1, 0, 0.174436,0.0262923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256533,-0.0262386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676153,0.00294513) , 
3, -0.0316344, 1, 0, 0.559026,-0.0124847) , 
3, -0.796906, 1, 0, 0.466483,-0.00315393)    );
  // itree = 1025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623493,0.0108289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42003,-0.0180863) , 
1, -0.662928, 1, 0, 0.527104,-0.00974168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507804,0.0353786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421145,0.00170396) , 
1, 0.815889, 1, 0, 0.467356,0.0324898) , 
1, 0.0567207, 1, 0, 0.496425,0.0119429)    );
  // itree = 1026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24111,-0.0136898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50726,-0.0612267) , 
2, 0.00441488, 1, 0, 0.277864,-0.0451922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543514,0.0248215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.840659,-0.0134083) , 
3, 1.18131, 1, 0, 0.639707,0.0310434) , 
0, -0.4832, 1, 0, 0.48383,-0.00179793)    );
  // itree = 1027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510206,-0.0055884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452163,-0.0447696) , 
1, 0.599265, 1, 0, 0.501587,-0.0238971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306963,-0.0082703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647483,0.0287574) , 
0, 0.0178291, 1, 0, 0.476593,0.019906) , 
1, 0.967034, 1, 0, 0.49622,-0.0144907)    );
  // itree = 1028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142698,-0.00124822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175227,-0.0388879) , 
1, 0.198479, 1, 0, 0.159336,-0.0425208) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344809,-0.00920317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629837,0.016009) , 
0, -1.05432, 1, 0, 0.572159,0.0213039) , 
2, -1.3039, 1, 0, 0.528992,0.01463)    );
  // itree = 1029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465127,-0.0121196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.895325,0.0257713) , 
2, 1.10799, 1, 0, 0.514396,-0.017191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428848,0.0458198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62727,-0.00211728) , 
0, 0.18515, 1, 0, 0.518271,0.0417722) , 
1, 0.213586, 1, 0, 0.516071,0.00830275)    );
  // itree = 1030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461685,0.0142762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272436,-0.0169015) , 
1, 1.27721, 1, 0, 0.435386,0.0182097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603124,-0.0462638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626382,-0.0157383) , 
0, 1.00759, 1, 0, 0.623228,-0.0416078) , 
0, 0.711487, 1, 0, 0.502769,-0.00324812)    );
  // itree = 1031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0319352,-0.071974) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58227,0.0129191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411651,-0.010533) , 
1, 0.219717, 1, 0, 0.508216,0.00622851) , 
0, -3.25007, 1, 0, 0.493858,0.0017521)    );
  // itree = 1032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341786,-0.00334415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.914913,0.0384944) , 
3, 0.894398, 1, 0, 0.42078,0.00344548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.643106,-0.0584893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788474,-0.0012306) , 
0, 0.998196, 1, 0, 0.74431,-0.0425909) , 
2, 0.903798, 1, 0, 0.492602,-0.00677439)    );
  // itree = 1033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105793,0.0153656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392849,-0.0388596) , 
3, -1.2885, 1, 0, 0.23407,-0.0430234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455499,0.0190634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688079,-0.0134242) , 
2, 0.245875, 1, 0, 0.572207,0.007572) , 
0, -1.79848, 1, 0, 0.504538,-0.00255335)    );
  // itree = 1034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0692748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51485,0.0157473) , 
0, -3.26098, 1, 0, 0.496417,0.029027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47577,-0.0347791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87941,-0.00435795) , 
3, 1.34643, 1, 0, 0.749761,-0.0337286) , 
2, 1.01032, 1, 0, 0.547958,0.0162597)    );
  // itree = 1035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330238,-0.0204805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633737,0.0137735) , 
0, -1.71962, 1, 0, 0.570994,0.0137572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460438,-0.0342781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415149,-0.00329462) , 
1, 0.85847, 1, 0, 0.437061,-0.0345458) , 
1, 0.110339, 1, 0, 0.504872,-0.0100898)    );
  // itree = 1036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168352,0.000768727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289068,-0.0339397) , 
3, -0.579133, 1, 0, 0.195126,-0.0233851) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.675235,0.0105379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732259,-0.0750421) , 
2, 1.85246, 1, 0, 0.677572,0.0158054) , 
3, -0.330123, 1, 0, 0.503082,0.0016311)    );
  // itree = 1037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16027,-0.0166922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376945,0.0301315) , 
0, -1.67414, 1, 0, 0.268563,0.0167306) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427894,-0.0234335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597119,-0.000787257) , 
0, 0.330071, 1, 0, 0.524516,-0.0246475) , 
2, -0.660692, 1, 0, 0.461424,-0.0144479)    );
  // itree = 1038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538432,0.0406219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221582,-0.0166347) , 
1, -1.81802, 1, 0, 0.237591,-0.0268043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830769,0.023235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725953,-0.0051418) , 
1, 0.104868, 1, 0, 0.78347,0.0186319) , 
3, 0.256412, 1, 0, 0.4788,-0.0067273)    );
  // itree = 1039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133094,-0.0752214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152504,-0.0229476) , 
1, -0.737845, 1, 0, 0.148999,-0.0657977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465455,0.0159849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823498,-0.00500668) , 
3, 0.700822, 1, 0, 0.604013,0.0189466) , 
2, -0.990153, 1, 0, 0.510986,0.00162078)    );
  // itree = 1040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.714837,0.0707427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510798,0.00301093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305729,-0.0271417) , 
1, 1.67016, 1, 0, 0.49764,0.00182503) , 
1, -1.72494, 1, 0, 0.505209,0.00509964)    );
  // itree = 1041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423713,0.003976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614116,-0.039915) , 
2, 0.780862, 1, 0, 0.443228,-0.00367921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.663125,0.0510889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.847771,-0.0108299) , 
3, 1.42134, 1, 0, 0.77336,0.0490574) , 
0, 1.12719, 1, 0, 0.52399,0.00922203)    );
  // itree = 1042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103378,-0.0388518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678119,0.00392751) , 
3, -0.636326, 1, 0, 0.516851,-0.0118323) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61753,0.0421282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253506,-0.0228985) , 
1, 1.77649, 1, 0, 0.527937,0.0518906) , 
1, 0.978958, 1, 0, 0.51924,0.00190088)    );
  // itree = 1043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166853,-0.0727682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.959855,0.0401879) , 
3, -0.00220701, 1, 0, 0.619906,-0.0598263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944097,0.0696689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466,0.00193541) , 
1, -1.25235, 1, 0, 0.483989,0.00783702) , 
1, -1.52075, 1, 0, 0.495567,0.00207317)    );
  // itree = 1044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385979,0.00755472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813861,-0.0124166) , 
3, 0.760049, 1, 0, 0.505642,0.00490952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194085,-0.0293454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.785374,-0.0033641) , 
3, 0.58422, 1, 0, 0.398489,-0.0483882) , 
1, 0.837952, 1, 0, 0.480208,-0.00774137)    );
  // itree = 1045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184837,0.0208714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390322,-0.0223423) , 
2, -1.25586, 1, 0, 0.348778,-0.0345725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604015,-0.000681466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.896308,0.0482811) , 
1, 1.60142, 1, 0, 0.624137,0.0067493) , 
0, 0.305096, 1, 0, 0.466775,-0.0168653)    );
  // itree = 1046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0525682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479002,0.0456502) , 
3, -1.7921, 1, 0, 0.271759,0.0538619) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288384,-0.0210698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81019,0.00464052) , 
3, 0.427327, 1, 0, 0.523881,-0.0203655) , 
2, -1.30782, 1, 0, 0.498864,-0.0130002)    );
  // itree = 1047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462388,-0.0448327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.883499,-0.00574795) , 
2, 1.21878, 1, 0, 0.551081,-0.073048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48216,0.0264091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680575,0.000160954) , 
0, 1.05495, 1, 0, 0.540712,0.0345503) , 
1, -1.21471, 1, 0, 0.542189,0.0192281)    );
  // itree = 1048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520355,0.0499602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201324,0.0138644) , 
1, -1.21306, 1, 0, 0.238288,0.0380344) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431615,-0.024275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72703,-0.00811362) , 
3, 0.104345, 1, 0, 0.660363,-0.0287833) , 
3, -0.351682, 1, 0, 0.506265,-0.00438843)    );
  // itree = 1049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241608,0.0151528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4412,-0.0206603) , 
2, -0.694935, 1, 0, 0.360075,-0.016351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59268,0.0337772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776902,0.00290963) , 
2, 0.798793, 1, 0, 0.702126,0.029599) , 
2, 0.391241, 1, 0, 0.490447,0.00116271)    );
  // itree = 1050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404262,-0.010531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831625,0.0128501) , 
2, 0.923149, 1, 0, 0.479706,-0.0132369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530416,0.0583936) , 
1, 2.14513, 1, 0, 0.480928,-0.00940943)    );
  // itree = 1051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281148,0.00586822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643753,-0.0169143) , 
3, -0.133228, 1, 0, 0.497065,-0.0179081) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211564,-0.0437802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56572,0.026557) , 
0, -1.9946, 1, 0, 0.497818,0.0219093) , 
1, 0.843066, 1, 0, 0.497273,-0.00692762)    );
  // itree = 1052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528166,-0.00021207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47231,0.0427694) , 
1, 0.0672387, 1, 0, 0.521729,0.0104094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325543,-0.0248585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.925691,0.0352692) , 
2, 1.33607, 1, 0, 0.3775,-0.0459375) , 
1, 0.237261, 1, 0, 0.453816,-0.0161226)    );
  // itree = 1053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107689,-0.0603121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580912,-0.0149197) , 
2, -0.823319, 1, 0, 0.465199,-0.068128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369291,0.0199743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613231,-0.00161163) , 
0, -0.376314, 1, 0, 0.508382,0.0127512) , 
1, -1.37148, 1, 0, 0.503379,0.00338065)    );
  // itree = 1054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185486,0.00090343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508382,0.0641836) , 
2, -0.318592, 1, 0, 0.232875,0.0230395) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371042,-0.0369991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715026,-0.00812747) , 
3, 0.0977981, 1, 0, 0.653444,-0.0315748) , 
3, -0.133228, 1, 0, 0.482729,-0.00940614)    );
  // itree = 1055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0840613,-0.0272013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.069117) , 
1, -0.0386274, 1, 0, 0.0418879,-0.0701329) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282235,0.0468563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581255,0.00103234) , 
2, -0.921967, 1, 0, 0.533202,0.0128774) , 
2, -1.86672, 1, 0, 0.508553,0.00871291)    );
  // itree = 1056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237203,0.040921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296477,-0.0213123) , 
0, -2.54975, 1, 0, 0.287025,-0.030873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249332,0.0378646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709966,0.00189192) , 
3, 0.108085, 1, 0, 0.636287,0.0142893) , 
0, -0.416978, 1, 0, 0.479484,-0.00598657)    );
  // itree = 1057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224217,0.0126498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721002,0.0573837) , 
3, 0.0588767, 1, 0, 0.282905,0.0291265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632582,-0.00421452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43885,-0.0346055) , 
1, 1.44003, 1, 0, 0.616203,-0.015002) , 
2, -0.401136, 1, 0, 0.500708,0.000289573)    );
  // itree = 1058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0646446,-0.00367751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489477,0.0221645) , 
3, -1.39966, 1, 0, 0.366686,0.0323558) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.723093,0.00734832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467181,-0.0225708) , 
1, -0.133281, 1, 0, 0.58108,-0.0222637) , 
0, -0.289772, 1, 0, 0.48812,0.0014191)    );
  // itree = 1059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536045,0.0206446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800493,-0.0326789) , 
3, 0.561797, 1, 0, 0.63285,0.00721793) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188292,-0.0263991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576468,-0.00492823) , 
2, -0.55359, 1, 0, 0.449327,-0.0262168) , 
1, -0.092065, 1, 0, 0.525875,-0.012271)    );
  // itree = 1060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270273,0.152236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377985,-0.0124248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750012,0.00517767) , 
2, 0.580058, 1, 0, 0.504445,-0.0135172) , 
0, -3.17159, 1, 0, 0.49713,-0.0088331)    );
  // itree = 1061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151341,-0.0210905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669016,0.00727986) , 
3, -0.823957, 1, 0, 0.53429,0.0018513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222489,-0.0335807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875766,0.0181438) , 
3, 0.952822, 1, 0, 0.395848,-0.0445611) , 
1, 0.397665, 1, 0, 0.478721,-0.0167782)    );
  // itree = 1062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104674,0.00822933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516199,0.0626794) , 
2, -1.59971, 1, 0, 0.2286,0.0541762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11831,-0.0497963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566081,-0.0032026) , 
2, -0.97314, 1, 0, 0.524629,-0.0181906) , 
2, -1.2253, 1, 0, 0.492964,-0.0104497)    );
  // itree = 1063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532724,-0.0529114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535352,-0.00601985) , 
1, -2.2619, 1, 0, 0.53508,-0.0223898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53894,0.0252633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393491,-0.00107804) , 
1, 0.442455, 1, 0, 0.464938,0.0260467) , 
1, -0.715629, 1, 0, 0.48253,0.0138986)    );
  // itree = 1064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323295,-0.0351963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737251,-0.00178649) , 
2, 0.415933, 1, 0, 0.501236,-0.0486161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285519,0.00994457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615121,-0.00571069) , 
2, -0.425618, 1, 0, 0.49846,-0.00176848) , 
1, -0.480148, 1, 0, 0.499284,-0.0156783)    );
  // itree = 1065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177275,-0.0189559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609427,0.0266061) , 
2, -0.57727, 1, 0, 0.44197,0.0191889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719797,-0.030221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797793,0.0045393) , 
0, 2.44009, 1, 0, 0.741787,-0.0374013) , 
2, 0.897689, 1, 0, 0.505864,0.00712893)    );
  // itree = 1066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428171,-0.00414818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799342,0.0385996) , 
0, -0.0692552, 1, 0, 0.607759,0.0271757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398681,-0.0280815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500129,0.00457301) , 
1, -0.129643, 1, 0, 0.468945,-0.0126648) , 
1, -0.827015, 1, 0, 0.500503,-0.00360734)    );
  // itree = 1067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137754,0.0176284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502259,0.052852) , 
3, -0.64159, 1, 0, 0.20278,0.0356914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114751,-0.0300684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585637,-0.00366724) , 
3, -0.791503, 1, 0, 0.537135,-0.0134204) , 
2, -0.862357, 1, 0, 0.464304,-0.00272261)    );
  // itree = 1068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464922,0.0643415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304617,-0.019174) , 
1, -1.22691, 1, 0, 0.316861,-0.0280215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.839723,0.0716079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66404,0.0112989) , 
2, -0.0554667, 1, 0, 0.677456,0.0330733) , 
2, -0.29256, 1, 0, 0.541956,0.0101158)    );
  // itree = 1069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293559,-0.0242909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641223,0.0295469) , 
2, 0.245459, 1, 0, 0.332836,-0.038317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635185,-0.0328157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601713,0.00260003) , 
1, -1.17388, 1, 0, 0.606324,-0.00282601) , 
0, -0.212431, 1, 0, 0.46695,-0.0209128)    );
  // itree = 1070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256001,-0.0373054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367382,0.0427957) , 
1, -1.17152, 1, 0, 0.354226,0.0469543) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204129,-0.0200996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691283,0.00340413) , 
3, -0.083085, 1, 0, 0.539743,-0.0110072) , 
0, -1.40205, 1, 0, 0.497594,0.00216146)    );
  // itree = 1071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320354,-0.000942806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298104,-0.0541017) , 
2, 0.46258, 1, 0, 0.317525,-0.0214283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830492,-0.0469728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7838,0.0110259) , 
1, -1.36453, 1, 0, 0.788385,0.0151759) , 
3, 0.451912, 1, 0, 0.490577,-0.00797536)    );
  // itree = 1072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400394,-0.0283041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675873,-0.00799572) , 
0, -0.187746, 1, 0, 0.541161,-0.0418951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324668,0.019462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614656,-0.00518084) , 
2, -0.0811742, 1, 0, 0.479733,0.0119099) , 
1, -0.274313, 1, 0, 0.503017,-0.00848458)    );
  // itree = 1073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385175,0.00686811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615728,0.0376684) , 
2, 0.63393, 1, 0, 0.407108,0.0206882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692024,-0.0273099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901376,-0.00131715) , 
3, 1.47163, 1, 0, 0.789757,-0.0368108) , 
3, 0.776842, 1, 0, 0.531255,0.00203318)    );
  // itree = 1074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524329,0.0305904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786399,-0.0152844) , 
2, 0.720792, 1, 0, 0.6268,0.0246451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445122,-0.0230838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44806,-0.00277262) , 
1, -0.171669, 1, 0, 0.447087,-0.0210814) , 
1, -1.01826, 1, 0, 0.478208,-0.0131629)    );
  // itree = 1075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161017,0.000254779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358379,0.06875) , 
2, -0.837496, 1, 0, 0.220779,0.0376308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464757,0.0383257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631712,-0.00789875) , 
3, -0.31404, 1, 0, 0.618552,-0.00925689) , 
3, -0.557144, 1, 0, 0.509745,0.00356871)    );
  // itree = 1076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238349,0.00614187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.85192,0.0749308) , 
2, -0.432274, 1, 0, 0.359434,0.033701) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566883,-0.0100155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712925,0.0424243) , 
1, 1.57426, 1, 0, 0.576236,-0.0156704) , 
0, -0.794061, 1, 0, 0.499927,0.00170712)    );
  // itree = 1077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289166,-0.00538916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0702058,-0.037916) , 
0, 0.0423523, 1, 0, 0.25663,-0.0211548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.682531,0.0317131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.858394,-0.00436197) , 
3, 1.21268, 1, 0, 0.75215,0.0396143) , 
3, 0.179643, 1, 0, 0.505247,0.00933485)    );
  // itree = 1078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381051,0.00630817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465102,-0.0442125) , 
2, 0.290261, 1, 0, 0.394332,-0.00457059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0776653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72649,0.0123546) , 
0, 0.279441, 1, 0, 0.759056,0.0407863) , 
2, 0.556239, 1, 0, 0.511755,0.010032)    );
  // itree = 1079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10615,-0.068894) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532082,0.00121796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33877,-0.0206992) , 
1, 1.60105, 1, 0, 0.516425,-0.00207525) , 
0, -3.23058, 1, 0, 0.505368,-0.00452489)    );
  // itree = 1080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0696231,-0.0647128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18269,-0.0151301) , 
1, -1.20159, 1, 0, 0.169952,-0.0424884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.703385,0.0360496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650876,-0.00348538) , 
2, -0.088399, 1, 0, 0.662294,0.011921) , 
3, -0.316527, 1, 0, 0.480579,-0.00816053)    );
  // itree = 1081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229497,0.0185322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562185,-0.00969383) , 
2, -0.648681, 1, 0, 0.470675,-0.00788543) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169521,-0.0207958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616715,-0.0405423) , 
3, -0.0550713, 1, 0, 0.40584,-0.0678485) , 
1, 1.1228, 1, 0, 0.46078,-0.0170368)    );
  // itree = 1082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115354,0.180517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25766,-0.00650377) , 
2, -2.13431, 1, 0, 0.251024,-0.00778242) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.850218,0.00686664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738938,0.0274942) , 
1, -0.177239, 1, 0, 0.785307,0.0390711) , 
3, 0.179643, 1, 0, 0.505724,0.0145534)    );
  // itree = 1083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26706,-0.0512452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760311,-0.00770449) , 
0, -0.378706, 1, 0, 0.551632,-0.0547392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584263,0.0130752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455907,-0.00864548) , 
1, -0.428817, 1, 0, 0.481018,-0.00809125) , 
1, -1.0628, 1, 0, 0.491746,-0.0151784)    );
  // itree = 1084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568617,0.00884543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586707,0.0432671) , 
1, 0.435989, 1, 0, 0.571417,0.0266769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412447,-0.00055557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601499,-0.0341687) , 
0, 1.38601, 1, 0, 0.442331,-0.0125041) , 
1, 0.826062, 1, 0, 0.538811,0.01678)    );
  // itree = 1085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0762868,-0.0606366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397256,0.00101497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.807049,0.0214554) , 
2, 0.507099, 1, 0, 0.544946,0.0175281) , 
0, -3.15088, 1, 0, 0.525269,0.0122859)    );
  // itree = 1086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302794,-0.00668891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.765947,0.0169921) , 
3, 0.191234, 1, 0, 0.514291,0.00649422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318387,0.00412647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509166,-0.0771239) , 
2, 0.557259, 1, 0, 0.365199,-0.0432486) , 
1, 0.969734, 1, 0, 0.484128,-0.00356919)    );
  // itree = 1087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423937,-0.002814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546583,-0.0483085) , 
0, 1.39348, 1, 0, 0.436205,-0.0156595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569777,0.0372442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.900987,0.0174582) , 
3, 1.48896, 1, 0, 0.822073,0.0505396) , 
0, 1.93176, 1, 0, 0.487766,-0.00681373)    );
  // itree = 1088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.887663,0.0885527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520516,0.00240544) , 
1, -1.95135, 1, 0, 0.530746,0.00980794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546066,0.110077) , 
1, 2.14975, 1, 0, 0.531195,0.0156589)    );
  // itree = 1089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.9336,0.0874914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479771,-0.0019745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52851,0.0182586) , 
1, 1.20351, 1, 0, 0.485939,0.00209634) , 
1, -1.92948, 1, 0, 0.498125,0.00648858)    );
  // itree = 1090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248025,-0.0297959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818042,-0.059584) , 
3, 0.130664, 1, 0, 0.50064,-0.0630993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505816,0.00108119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.960232,0.0374069) , 
3, 2.58812, 1, 0, 0.519564,0.00411462) , 
1, -1.66895, 1, 0, 0.518413,2.87877e-05)    );
  // itree = 1091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325034,0.000146176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563896,-0.0657359) , 
2, 0.0505275, 1, 0, 0.357123,-0.0153717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559967,0.0351473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724553,0.002026) , 
2, 0.448802, 1, 0, 0.651138,0.033661) , 
0, -0.590631, 1, 0, 0.536761,0.0145865)    );
  // itree = 1092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216675,-0.0181822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358422,0.018659) , 
2, -1.23696, 1, 0, 0.327205,0.0228303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.872328,-0.0762844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684222,-0.00105924) , 
0, 0.241611, 1, 0, 0.713251,-0.0126385) , 
3, 0.268003, 1, 0, 0.489012,0.00796397)    );
  // itree = 1093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484625,-0.0073015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474258,0.0125366) , 
1, 0.689299, 1, 0, 0.481505,-0.00245773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326191,-0.0501408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790538,-0.0150353) , 
3, 1.0018, 1, 0, 0.686724,-0.0574959) , 
2, 1.03977, 1, 0, 0.516306,-0.0117909)    );
  // itree = 1094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171133,-0.0407717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548275,0.00463687) , 
0, -2.44368, 1, 0, 0.518951,0.00319394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191625,0.0107957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434498,-0.0302897) , 
0, -0.967242, 1, 0, 0.359515,-0.0473392) , 
1, 0.92669, 1, 0, 0.48547,-0.00741777)    );
  // itree = 1095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383466,0.0238172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719982,-0.00939613) , 
3, 0.320269, 1, 0, 0.534549,0.019283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25232,-0.0185525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545165,-0.0529489) , 
2, 0.16305, 1, 0, 0.355415,-0.0756644) , 
1, 1.15831, 1, 0, 0.507618,0.00500854)    );
  // itree = 1096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115051,-0.033651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374559,0.0242483) , 
0, -3.18401, 1, 0, 0.34066,0.0308199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530042,-0.008928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331117,-0.0442096) , 
1, 1.78879, 1, 0, 0.522973,-0.022699) , 
0, -1.39441, 1, 0, 0.485241,-0.0116224)    );
  // itree = 1097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321771,0.00251674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391891,-0.0191414) , 
0, -1.3811, 1, 0, 0.372065,-0.0304704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.854129,0.00796631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.935175,0.0439327) , 
1, 1.43118, 1, 0, 0.862286,0.0238975) , 
3, 0.805256, 1, 0, 0.523556,-0.0136693)    );
  // itree = 1098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0737664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487423,0.00158115) , 
2, -2.1763, 1, 0, 0.470366,-0.00030038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659045,-0.0656905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.941846,0.0205263) , 
3, 2.34769, 1, 0, 0.758001,-0.0818408) , 
2, 1.23591, 1, 0, 0.498625,-0.00831133)    );
  // itree = 1099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217363,0.0146592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483572,-0.0115417) , 
2, -0.875945, 1, 0, 0.407184,-0.0114173) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.737988,-0.0142298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.827998,0.022263) , 
0, 0.569234, 1, 0, 0.811865,0.0325643) , 
2, 0.903798, 1, 0, 0.490183,-0.00239674)    );
  // itree = 1100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55465,-0.00301835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542008,0.0294872) , 
1, 0.067187, 1, 0, 0.553518,4.05067e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187826,0.0160249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518313,-0.0237354) , 
3, -0.582913, 1, 0, 0.422989,-0.0297526) , 
1, 0.234105, 1, 0, 0.493072,-0.0137561)    );
  // itree = 1101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328319,0.0378526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531476,-0.00954706) , 
0, -1.83914, 1, 0, 0.502045,-0.00781332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200206,-0.0198304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581445,0.0299516) , 
2, -0.784786, 1, 0, 0.454424,0.0259835) , 
1, 0.860284, 1, 0, 0.490586,0.000319607)    );
  // itree = 1102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137758,-0.0307084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794217,0.0422167) , 
2, -1.08303, 1, 0, 0.693467,0.0547518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148556,-0.0355398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521354,0.000275701) , 
0, -1.72228, 1, 0, 0.451015,-0.0110589) , 
1, -0.751023, 1, 0, 0.507153,0.00417893)    );
  // itree = 1103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310428,0.0225493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381132,-0.0117341) , 
0, -1.39213, 1, 0, 0.361446,-0.00893001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.919716,0.0457655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88693,0.00671671) , 
3, 1.47841, 1, 0, 0.897483,0.0434609) , 
3, 1.15656, 1, 0, 0.478279,0.00248899)    );
  // itree = 1104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358776,-0.00162122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629092,0.0165839) , 
0, -0.558386, 1, 0, 0.50992,0.0188685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518186,-0.0361869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.907995,0.00220472) , 
3, 2.21639, 1, 0, 0.696559,-0.0489893) , 
0, 2.25085, 1, 0, 0.52636,0.0128914)    );
  // itree = 1105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335187,-0.00521526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600237,0.0413771) , 
2, 0.221555, 1, 0, 0.400396,0.013108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.930515,0.0253917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797235,-0.0230853) , 
2, 0.254587, 1, 0, 0.811446,-0.0313268) , 
3, 0.814561, 1, 0, 0.523927,-0.000245836)    );
  // itree = 1106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217228,0.167814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248872,-0.0208861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613557,-0.00400359) , 
2, -0.562907, 1, 0, 0.506166,-0.0208213) , 
2, -1.9954, 1, 0, 0.497346,-0.0161034)    );
  // itree = 1107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219773,-0.00331675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439106,-0.0419377) , 
3, -0.0154699, 1, 0, 0.251391,-0.0227992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.795188,0.0177784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682498,-0.00516499) , 
1, 0.708322, 1, 0, 0.762351,0.0207151) , 
3, 0.256412, 1, 0, 0.472675,-0.00395427)    );
  // itree = 1108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460594,-0.0233594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.765956,0.00499444) , 
2, 1.05734, 1, 0, 0.513205,-0.0383678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128165,-0.0358165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505444,0.0174215) , 
0, -2.27961, 1, 0, 0.469758,0.0246312) , 
1, 0.527824, 1, 0, 0.499038,-0.0178262)    );
  // itree = 1109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711605,0.076794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81832,-0.0251241) , 
3, 0.311558, 1, 0, 0.774097,0.0705744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508023,-0.00106617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344864,-0.0256142) , 
1, 1.4043, 1, 0, 0.4863,-0.00887639) , 
1, -1.48631, 1, 0, 0.508829,-0.00265683)    );
  // itree = 1110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330682,0.108616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583322,0.0113615) , 
2, -1.08144, 1, 0, 0.561119,0.0298412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410727,-0.01655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49582,0.034882) , 
1, 1.36482, 1, 0, 0.424313,-0.020691) , 
1, -0.11574, 1, 0, 0.481032,0.000259495)    );
  // itree = 1111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.79226,0.0961754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505465,-0.00780992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462369,0.0145179) , 
1, 0.984572, 1, 0, 0.497285,-0.0059185) , 
1, -2.0219, 1, 0, 0.505748,-0.00111626)    );
  // itree = 1112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0571619,-0.0158066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235328,-0.050127) , 
3, -1.40933, 1, 0, 0.135763,-0.0715842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334598,0.0332448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589594,-0.00608758) , 
2, -0.52016, 1, 0, 0.528272,0.00476205) , 
2, -1.30782, 1, 0, 0.478259,-0.0049659)    );
  // itree = 1113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180858,0.0101277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542935,-0.0259056) , 
3, -0.70181, 1, 0, 0.366315,-0.0241393) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.662949,0.0456186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634755,-0.000531021) , 
0, 0.296103, 1, 0, 0.637843,0.00982612) , 
0, -0.0887253, 1, 0, 0.500514,-0.00735229)    );
  // itree = 1114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0746727,-0.0222088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362085,-0.0365524) , 
3, -1.29778, 1, 0, 0.204592,-0.0605775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403861,0.04205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581219,-0.0102526) , 
2, -0.630154, 1, 0, 0.558906,-0.00820153) , 
0, -1.59795, 1, 0, 0.488419,-0.0186212)    );
  // itree = 1115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53334,-0.0737517) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365318,-0.00983559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62312,0.0092598) , 
0, 0.438571, 1, 0, 0.466763,-0.00406913) , 
1, -2.0375, 1, 0, 0.468905,-0.00865208)    );
  // itree = 1116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28446,-0.046641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192077,-0.00719971) , 
1, -0.90831, 1, 0, 0.211082,-0.0378941) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.759748,0.0564763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757852,0.00391374) , 
2, -0.433909, 1, 0, 0.757986,0.0149271) , 
3, -0.0725463, 1, 0, 0.506166,-0.00939418)    );
  // itree = 1117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325427,0.00650958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302056,-0.0279404) , 
0, -0.696155, 1, 0, 0.313206,-0.0286642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.811316,0.0135574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.771392,-0.0385055) , 
2, 1.6032, 1, 0, 0.806176,0.0127226) , 
3, 0.760049, 1, 0, 0.468118,-0.0156588)    );
  // itree = 1118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132681,-0.0056528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154371,-0.0649342) , 
2, -1.54685, 1, 0, 0.14035,-0.0684158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235993,-0.0253091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568544,0.00634247) , 
0, -1.75398, 1, 0, 0.538435,0.00639673) , 
2, -1.18993, 1, 0, 0.490465,-0.00261841)    );
  // itree = 1119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.743681,0.0364804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504202,0.00963011) , 
1, -0.878098, 1, 0, 0.562615,0.0307368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25359,-0.0213971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886253,0.033505) , 
3, 1.14782, 1, 0, 0.373823,-0.0264629) , 
1, 0.907319, 1, 0, 0.514191,0.0160654)    );
  // itree = 1120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389646,-0.0143735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773769,0.0110952) , 
2, 0.360513, 1, 0, 0.544269,-0.0103466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285155,0.035155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692559,-0.00404328) , 
3, 0.281919, 1, 0, 0.468145,0.038634) , 
1, 0.560452, 1, 0, 0.518184,0.00643716)    );
  // itree = 1121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48946,-0.021275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518651,0.0145226) , 
1, -0.719137, 1, 0, 0.50955,0.0054572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319993,-0.026121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819595,0.0236187) , 
2, 1.02541, 1, 0, 0.37904,-0.0487544) , 
1, 0.843066, 1, 0, 0.47765,-0.00779359)    );
  // itree = 1122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0358016,-0.0163737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447372,0.0518009) , 
3, -1.67406, 1, 0, 0.33179,0.0712617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372501,-0.0157363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830073,0.00670834) , 
3, 0.608371, 1, 0, 0.576645,-0.0139772) , 
2, -0.861796, 1, 0, 0.526908,0.00333707)    );
  // itree = 1123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.063125,-0.0524502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382762,0.02006) , 
2, -2.0204, 1, 0, 0.348497,0.0255135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.787536,0.0547839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535545,-0.0111319) , 
1, -1.69005, 1, 0, 0.546908,-0.0189579) , 
0, -0.968126, 1, 0, 0.488238,-0.00580774)    );
  // itree = 1124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290837,0.0113133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.076296,-0.0436208) , 
0, -1.97761, 1, 0, 0.190433,-0.0277976) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534103,0.0181327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737532,-0.00662147) , 
2, 0.594199, 1, 0, 0.606719,0.0205416) , 
3, -0.796906, 1, 0, 0.501827,0.00836159)    );
  // itree = 1125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215118,0.0655791) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214834,-0.0168199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602053,0.00124334) , 
2, -0.766683, 1, 0, 0.511793,-0.00577884) , 
0, -2.89816, 1, 0, 0.498595,-0.00206328)    );
  // itree = 1126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398831,0.00680863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716623,-0.0313523) , 
3, 0.438226, 1, 0, 0.520653,-0.0138753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0347714,-0.040653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5977,0.0167534) , 
3, -1.09749, 1, 0, 0.499151,0.0215361) , 
1, 0.560452, 1, 0, 0.513753,-0.00251149)    );
  // itree = 1127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596241,-0.0335173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566586,0.0134239) , 
1, -1.73908, 1, 0, 0.569443,0.0174942) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300438,-0.018067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752139,0.0067711) , 
2, 0.514398, 1, 0, 0.423936,-0.0204106) , 
1, -0.237385, 1, 0, 0.480359,-0.00571245)    );
  // itree = 1128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0671205,-0.0269774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37474,0.0353744) , 
2, -1.67978, 1, 0, 0.307078,0.0444369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204007,-0.0192872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691681,0.00918338) , 
3, -0.205987, 1, 0, 0.584682,0.00515561) , 
2, -0.55359, 1, 0, 0.495447,0.0177825)    );
  // itree = 1129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0525811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0827733,-0.0672548) , 
3, -1.8735, 1, 0, 0.0502544,-0.0959145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57031,0.00772698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255064,-0.0318133) , 
1, 2.10403, 1, 0, 0.559272,0.0128252) , 
2, -1.30782, 1, 0, 0.499409,3.68633e-05)    );
  // itree = 1130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0337422,-0.0683677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24034,0.0181406) , 
0, -3.19325, 1, 0, 0.214578,0.0137843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533008,-0.0113876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.920007,0.0151999) , 
3, 1.4013, 1, 0, 0.61877,-0.0164144) , 
3, -0.613987, 1, 0, 0.51647,-0.00877115)    );
  // itree = 1131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355381,-0.0266646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295696,-0.00274643) , 
1, -0.321617, 1, 0, 0.320598,-0.026967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.887244,0.0325028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791972,-0.012279) , 
0, 2.3703, 1, 0, 0.867575,0.0342583) , 
3, 0.760049, 1, 0, 0.476969,-0.00946377)    );
  // itree = 1132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297249,0.0682285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0400396,-0.0411202) , 
1, 1.01352, 1, 0, 0.224985,0.0530821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434064,0.00188624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721793,-0.0197525) , 
2, 0.605152, 1, 0, 0.525448,-0.00970888) , 
0, -2.44368, 1, 0, 0.497914,-0.00395475)    );
  // itree = 1133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450681,-0.015804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412574,0.0115566) , 
1, 1.00646, 1, 0, 0.443795,-0.0211352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.789596,0.0250901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678541,-0.029764) , 
1, 0.655458, 1, 0, 0.761886,0.027486) , 
0, 2.01604, 1, 0, 0.478846,-0.0157776)    );
  // itree = 1134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598214,-0.0594343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376489,0.0189877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802325,-0.00347772) , 
3, 0.729578, 1, 0, 0.507598,0.0247536) , 
1, -1.83103, 1, 0, 0.511089,0.0198301)    );
  // itree = 1135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178487,-0.00499255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604493,0.0274597) , 
3, -0.630978, 1, 0, 0.366152,0.0226085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390594,-0.0321336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.840503,0.0122499) , 
3, 0.763611, 1, 0, 0.65996,-0.0156819) , 
2, 0.000104427, 1, 0, 0.509244,0.00396022)    );
  // itree = 1136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352883,-0.00135917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878501,0.0347531) , 
3, 0.712761, 1, 0, 0.463907,0.0114416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.701738,-0.0952855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733262,-0.01532) , 
1, -1.29293, 1, 0, 0.726109,-0.0581461) , 
2, 0.993478, 1, 0, 0.504296,0.000722532)    );
  // itree = 1137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353633,0.0189193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258801,-0.023342) , 
0, -0.894246, 1, 0, 0.308633,-0.00925403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629399,0.0433566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824992,0.00280174) , 
3, 0.695352, 1, 0, 0.766621,0.0315886) , 
3, 0.27076, 1, 0, 0.503384,0.00811359)    );
  // itree = 1138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212467,0.11239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242136,-0.0251047) , 
0, -2.77596, 1, 0, 0.236514,-0.0231213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426898,0.0298171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739121,0.0032875) , 
3, 0.383981, 1, 0, 0.600935,0.0310473) , 
2, -0.780555, 1, 0, 0.525568,0.0198445)    );
  // itree = 1139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355559,-0.00845947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628557,-0.0247091) , 
2, 0.415442, 1, 0, 0.438333,-0.0271727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.9148,-0.00849346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.959998,0.0360033) , 
3, 2.47693, 1, 0, 0.937867,0.0288654) , 
3, 2.12188, 1, 0, 0.471734,-0.0234257)    );
  // itree = 1140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13028,-0.0443187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121809,-0.0161552) , 
1, -0.749949, 1, 0, 0.123822,-0.0439442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647147,-0.0578716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631333,0.00504377) , 
0, -1.33546, 1, 0, 0.632129,0.00376535) , 
3, -0.796906, 1, 0, 0.512808,-0.00743406)    );
  // itree = 1141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256822,0.00553012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153224,-0.0262658) , 
0, -1.23491, 1, 0, 0.205148,-0.0248736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.660553,0.0400146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835371,-0.00675429) , 
3, 0.896651, 1, 0, 0.751099,0.0345079) , 
3, -0.000562009, 1, 0, 0.487835,0.00587342)    );
  // itree = 1142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311887,-0.0447252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290019,-0.00875635) , 
1, -0.614082, 1, 0, 0.296649,-0.0406155) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.68773,0.0131597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543983,-0.0286084) , 
1, 1.41646, 1, 0, 0.677042,0.0185872) , 
0, -0.376314, 1, 0, 0.491873,-0.0102316)    );
  // itree = 1143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0728142,-0.0470607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314875,0.0225251) , 
0, -2.77772, 1, 0, 0.282492,0.0276282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535467,-0.0209311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735797,0.00276438) , 
2, 0.439911, 1, 0, 0.658892,-0.0148761) , 
2, -0.262393, 1, 0, 0.49713,0.00339063)    );
  // itree = 1144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566921,0.00630509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398758,-0.0284485) , 
1, 0.205983, 1, 0, 0.531305,-0.00216234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410208,0.0342591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639448,-0.00233824) , 
0, 0.703678, 1, 0, 0.475998,0.0471249) , 
1, 0.540166, 1, 0, 0.512016,0.0150267)    );
  // itree = 1145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453494,-0.0512711) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421028,-0.002103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835703,0.0252849) , 
2, 0.923149, 1, 0, 0.501223,0.00589719) , 
1, -1.99411, 1, 0, 0.499361,0.00104214)    );
  // itree = 1146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.646197,0.0411002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571015,0.00708237) , 
1, -1.38879, 1, 0, 0.596119,0.0334322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174393,0.00109042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589662,-0.0199004) , 
3, -0.302053, 1, 0, 0.439989,-0.0268165) , 
1, -0.614082, 1, 0, 0.482457,-0.0104288)    );
  // itree = 1147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407783,-0.0155239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308441,0.0173012) , 
1, -0.979987, 1, 0, 0.324954,0.0242033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.599246,-0.0267519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789615,0.00434001) , 
2, 0.501953, 1, 0, 0.715455,-0.0176633) , 
3, 0.240623, 1, 0, 0.512314,0.00411597)    );
  // itree = 1148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421085,0.0182323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560467,-0.00664135) , 
0, -1.11562, 1, 0, 0.524647,-0.00180784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466526,0.0120622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.929342,0.0790741) , 
2, 1.25629, 1, 0, 0.509075,0.0395746) , 
1, 0.761006, 1, 0, 0.52032,0.00969103)    );
  // itree = 1149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584272,0.10485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143765,-0.0102845) , 
1, -1.06987, 1, 0, 0.190632,0.0150762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387302,-0.0297945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833108,-0.00238551) , 
3, 0.781054, 1, 0, 0.573063,-0.045101) , 
3, -0.703077, 1, 0, 0.477654,-0.030088)    );
  // itree = 1150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378734,-0.00605239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265427,-0.0370583) , 
1, 1.39008, 1, 0, 0.367528,-0.0207966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.773646,0.0398363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725667,-0.0104799) , 
0, 1.12431, 1, 0, 0.74831,0.0161235) , 
2, 0.391241, 1, 0, 0.496433,-0.00829809)    );
  // itree = 1151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5603,0.00640167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415157,-0.0136986) , 
1, 0.701189, 1, 0, 0.523056,0.00221645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276052,-0.0442214) , 
1, 1.94792, 1, 0, 0.513878,-0.00306987)    );
  // itree = 1152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208932,-0.0408293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181206,-0.00157268) , 
1, -0.469223, 1, 0, 0.187854,-0.0266388) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57223,0.0170463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678611,-0.00595716) , 
0, 0.829923, 1, 0, 0.614284,0.0161925) , 
2, -0.862357, 1, 0, 0.513263,0.0060458)    );
  // itree = 1153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141728,-0.0504631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20871,0.0276243) , 
1, -1.47848, 1, 0, 0.200296,0.0199591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.499893,-0.019451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.876952,-0.00345743) , 
3, 1.24798, 1, 0, 0.598322,-0.0354024) , 
3, -0.735036, 1, 0, 0.508312,-0.0228829)    );
  // itree = 1154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121954,-0.0506035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875766,0.051326) , 
3, -0.704989, 1, 0, 0.693387,0.0406338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502965,-0.0157553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519939,0.00658169) , 
1, -0.150955, 1, 0, 0.514193,-0.00230159) , 
1, -1.1416, 1, 0, 0.538228,0.00345726)    );
  // itree = 1155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0445356,-0.0291484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464648,0.0602887) , 
2, -1.87782, 1, 0, 0.226864,0.0435317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269891,-0.0263836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835751,0.00597581) , 
3, 0.551716, 1, 0, 0.471649,-0.0345868) , 
2, -1.3039, 1, 0, 0.445924,-0.0263772)    );
  // itree = 1156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0678315,0.0527338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179322,-0.0198548) , 
3, -1.99187, 1, 0, 0.162295,-0.0277874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.620536,0.0121806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738433,-0.00852151) , 
2, 0.680141, 1, 0, 0.667339,0.00973472) , 
3, -0.613987, 1, 0, 0.525319,-0.0008166)    );
  // itree = 1157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281288,-0.00272062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718901,0.0442093) , 
2, -0.291482, 1, 0, 0.41304,0.0233498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.631227,-0.0232612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624881,0.00553982) , 
1, 0.198194, 1, 0, 0.628599,-0.0267729) , 
0, 0.167929, 1, 0, 0.510759,0.000627875)    );
  // itree = 1158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584381,-0.0408031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517849,0.00800827) , 
1, -2.23867, 1, 0, 0.520528,0.0106967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16116,-0.0273751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744102,0.00632592) , 
3, 0.212383, 1, 0, 0.417874,-0.0273219) , 
1, 0.670325, 1, 0, 0.488161,-0.00129058)    );
  // itree = 1159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610292,0.122167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386184,0.0191217) , 
1, -1.1418, 1, 0, 0.414076,0.0507254) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353183,-0.0459466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664378,0.00656959) , 
0, 0.169301, 1, 0, 0.609541,-0.00923757) , 
0, -0.213974, 1, 0, 0.525957,0.0164035)    );
  // itree = 1160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543049,0.086665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545811,0.00128517) , 
0, -1.69646, 1, 0, 0.545401,0.0193408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268505,-0.0163769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72313,0.0099482) , 
2, 0.0556663, 1, 0, 0.455918,-0.0127247) , 
1, -0.274313, 1, 0, 0.489952,-0.000528801)    );
  // itree = 1161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505802,-0.0738493) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704142,0.0425882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468194,-0.0084561) , 
1, -1.23911, 1, 0, 0.494567,-0.00617904) , 
1, -1.98531, 1, 0, 0.494911,-0.0112184)    );
  // itree = 1162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0763486,-0.0534667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587467,0.00261568) , 
3, -0.919145, 1, 0, 0.237072,-0.0658874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532334,0.0261378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590823,-0.00152169) , 
0, -0.627351, 1, 0, 0.584532,0.00367135) , 
0, -1.05284, 1, 0, 0.479632,-0.0173288)    );
  // itree = 1163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0664516,-0.0612252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150641,-0.0221881) , 
1, -1.42554, 1, 0, 0.140735,-0.0505659) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132434,-0.023219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673359,0.0179931) , 
3, -0.680242, 1, 0, 0.60629,0.0245866) , 
2, -0.862357, 1, 0, 0.492601,0.00623434)    );
  // itree = 1164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176339,-0.00239721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538321,-0.0366029) , 
3, -0.721027, 1, 0, 0.254722,-0.0250804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598483,0.0338073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619761,-0.000380911) , 
0, 0.0828034, 1, 0, 0.613341,0.0182521) , 
0, -1.22798, 1, 0, 0.526558,0.00776595)    );
  // itree = 1165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357482,-0.0108594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331536,0.0389939) , 
1, 0.403002, 1, 0, 0.348683,0.00657159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516231,-0.055901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835459,-0.00864248) , 
3, 0.97531, 1, 0, 0.785586,-0.0345001) , 
3, 0.79068, 1, 0, 0.489674,-0.00668243)    );
  // itree = 1166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171322,-0.00270365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47659,0.0320789) , 
3, -0.451567, 1, 0, 0.215083,0.00700665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644334,-0.0537715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632906,-0.0119178) , 
0, 0.125029, 1, 0, 0.636146,-0.0521241) , 
3, -0.2003, 1, 0, 0.474633,-0.0294425)    );
  // itree = 1167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298414,0.038175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570895,0.00507748) , 
0, -2.44728, 1, 0, 0.545969,0.0141917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276618,-0.0327916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687709,-0.00688863) , 
2, 0.0824135, 1, 0, 0.446317,-0.0474483) , 
1, -0.392075, 1, 0, 0.481093,-0.0259372)    );
  // itree = 1168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380569,-0.0248856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345324,0.00223099) , 
1, -0.311684, 1, 0, 0.356324,-0.014466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.869183,0.0439716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685882,-0.00125704) , 
1, -1.10105, 1, 0, 0.7214,0.0133314) , 
2, 0.456587, 1, 0, 0.489135,-0.00435361)    );
  // itree = 1169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238449,0.00328685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399705,-0.0327797) , 
2, -0.745779, 1, 0, 0.346143,-0.0440585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30832,-0.0213139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797892,0.00649238) , 
3, 0.510527, 1, 0, 0.725563,0.00342863) , 
2, 0.556239, 1, 0, 0.464036,-0.0293033)    );
  // itree = 1170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407182,0.0370583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557877,-0.0268237) , 
2, -0.66051, 1, 0, 0.533815,-0.0353952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228861,-0.00841028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712534,0.0238362) , 
2, -0.13684, 1, 0, 0.453647,0.0128217) , 
1, -0.546241, 1, 0, 0.476281,-0.000791147)    );
  // itree = 1171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.571932,-0.00147129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509168,0.0192646) , 
1, 0.196524, 1, 0, 0.547177,0.0135792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0768544,-0.0463231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600914,0.0125717) , 
3, -0.502594, 1, 0, 0.36202,-0.0255645) , 
1, 1.2714, 1, 0, 0.517195,0.00724072)    );
  // itree = 1172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270793,-0.00267603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495863,-0.041533) , 
2, -0.265298, 1, 0, 0.347628,-0.0332375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.686452,-0.0290606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664175,0.0160826) , 
1, -0.805159, 1, 0, 0.668411,0.0167733) , 
0, 0.394028, 1, 0, 0.476507,-0.0131449)    );
  // itree = 1173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522534,0.00355456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381627,-0.0187218) , 
1, 0.827322, 1, 0, 0.488842,-0.00385025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5728,0.0435278) , 
1, 2.10403, 1, 0, 0.49191,-0.000196263)    );
  // itree = 1174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0950181,-0.00707266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389035,0.0389224) , 
3, -1.17793, 1, 0, 0.21935,0.0300837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269254,-0.0323963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606818,-0.00599337) , 
0, -1.19965, 1, 0, 0.560115,-0.0222707) , 
2, -0.862357, 1, 0, 0.478408,-0.00971746)    );
  // itree = 1175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654588,0.0357474) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503761,-0.0251841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466848,-0.00253809) , 
1, -0.442892, 1, 0, 0.477873,-0.0177173) , 
1, -1.99411, 1, 0, 0.484216,-0.0145188)    );
  // itree = 1176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342503,-0.0678107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395902,0.0217274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792726,-0.00734344) , 
3, 0.760049, 1, 0, 0.520802,0.0248755) , 
1, -1.67887, 1, 0, 0.510597,0.0165179)    );
  // itree = 1177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.727075,0.0741397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539177,0.00904876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421936,-0.00845521) , 
1, 0.0994846, 1, 0, 0.475555,3.84001e-05) , 
1, -1.86762, 1, 0, 0.487503,0.00609962)    );
  // itree = 1178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0956858,-0.059779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462947,0.000347445) , 
0, -3.05698, 1, 0, 0.447574,-0.00313166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512377,0.0486042) , 
1, 1.76949, 1, 0, 0.449658,-3.65795e-05)    );
  // itree = 1179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142026,-0.0258305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41517,0.0191839) , 
2, -1.56668, 1, 0, 0.359683,0.0250815) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.660928,-0.00837215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430682,-0.0534831) , 
1, 1.16098, 1, 0, 0.634975,-0.0280295) , 
2, -0.0811742, 1, 0, 0.496675,-0.00134769)    );
  // itree = 1180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243184,-0.0037838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458207,0.0245859) , 
2, -0.248255, 1, 0, 0.300799,0.00969338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437592,-0.0410349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816693,0.0047979) , 
3, 0.612047, 1, 0, 0.707557,-0.0227686) , 
3, 0.208162, 1, 0, 0.501562,-0.00632883)    );
  // itree = 1181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555952,-0.0271228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523418,0.0099302) , 
1, -1.18924, 1, 0, 0.530611,0.00464399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244871,-0.0418715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446045,-0.00466597) , 
1, 0.565513, 1, 0, 0.403786,-0.0313286) , 
1, 0.387754, 1, 0, 0.483913,-0.00860144)    );
  // itree = 1182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277722,-0.0182814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517317,0.00618093) , 
0, -0.936257, 1, 0, 0.424596,-0.0048059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539451,-0.0322248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704772,-0.0125513) , 
0, 0.818153, 1, 0, 0.666318,-0.0387359) , 
2, 0.863656, 1, 0, 0.481326,-0.012769)    );
  // itree = 1183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56094,-0.0122313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587097,0.0216044) , 
1, -1.11837, 1, 0, 0.579948,0.0273247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418883,-0.00941191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712309,-0.0466964) , 
0, 2.02022, 1, 0, 0.450407,-0.0268889) , 
1, 0.198194, 1, 0, 0.520629,0.00249935)    );
  // itree = 1184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421115,0.00912787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221359,-0.00918024) , 
0, 0.879351, 1, 0, 0.401654,0.015015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.836174,0.0307869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906734,0.00913384) , 
3, 1.43155, 1, 0, 0.879312,0.0356358) , 
3, 0.962347, 1, 0, 0.526158,0.0203899)    );
  // itree = 1185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428861,0.0642044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319053,-0.00711976) , 
1, -1.54245, 1, 0, 0.325381,-0.00765311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534961,0.0459213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81811,0.00796564) , 
3, 0.535697, 1, 0, 0.721062,0.0459841) , 
2, 0.0154847, 1, 0, 0.523183,0.0191603)    );
  // itree = 1186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48636,-0.0367322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560178,0.00652993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445877,-0.00850884) , 
1, -0.202615, 1, 0, 0.496651,-0.00327727) , 
1, -1.99411, 1, 0, 0.496215,-0.00707776)    );
  // itree = 1187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402382,0.0179067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.881675,-0.0440568) , 
3, 0.722853, 1, 0, 0.457985,0.0252431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253497,-0.0409754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797707,0.0058463) , 
2, 0.274297, 1, 0, 0.695668,-0.00914795) , 
0, 0.931227, 1, 0, 0.520037,0.0162646)    );
  // itree = 1188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0461642,0.0456783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270303,-0.0351166) , 
3, -1.85181, 1, 0, 0.18753,-0.0443127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341712,0.0148185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638451,-0.00553639) , 
2, -0.194596, 1, 0, 0.528598,0.00393182) , 
2, -1.40175, 1, 0, 0.488693,-0.00171288)    );
  // itree = 1189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365991,0.00425578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683199,-0.0147038) , 
2, 0.307548, 1, 0, 0.487274,-0.00599666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2651,-0.0463667) , 
1, 1.71189, 1, 0, 0.475324,-0.0119259)    );
  // itree = 1190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48796,-0.00698036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177529,-0.0605083) , 
1, 0.639024, 1, 0, 0.465768,-0.0211343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2951,0.0624157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53311,0.0090391) , 
2, -1.35733, 1, 0, 0.491051,0.0334799) , 
1, 0.843066, 1, 0, 0.471483,-0.00878954)    );
  // itree = 1191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197956,0.0895895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534911,-0.00119299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315945,-0.0322327) , 
1, 1.78879, 1, 0, 0.521787,-0.00641113) , 
0, -3.15852, 1, 0, 0.508581,-0.0021936)    );
  // itree = 1192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324559,0.00687851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123259,-0.0330448) , 
0, -1.01565, 1, 0, 0.251596,-0.0178725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.813699,0.0504796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77868,0.00913964) , 
2, -0.506321, 1, 0, 0.780977,0.0250196) , 
3, -0.0725463, 1, 0, 0.552967,0.00654554)    );
  // itree = 1193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199428,-0.0535285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87855,0.00953484) , 
3, 0.00395958, 1, 0, 0.514492,-0.0757114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502165,-0.00555962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461036,0.0156293) , 
1, 0.281836, 1, 0, 0.48254,0.00726112) , 
1, -1.1486, 1, 0, 0.487345,-0.00521677)    );
  // itree = 1194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319346,-0.00980239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272519,-0.0494208) , 
2, 0.503632, 1, 0, 0.313843,-0.0339872) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.823935,0.00848829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842843,0.0387815) , 
1, 1.02398, 1, 0, 0.827636,0.0290603) , 
3, 0.609067, 1, 0, 0.504907,-0.0105418)    );
  // itree = 1195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100073,-0.0178937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1863,-0.0454187) , 
3, -1.06112, 1, 0, 0.143814,-0.0695331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.581824,-0.00785579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623123,0.0220623) , 
1, 0.213586, 1, 0, 0.598318,0.00855638) , 
2, -0.792904, 1, 0, 0.489755,-0.0100961)    );
  // itree = 1196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122355,-0.0102291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564227,0.0710492) , 
2, -1.68894, 1, 0, 0.292047,0.0600212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419278,-0.00727801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723943,0.0102922) , 
0, 0.591168, 1, 0, 0.534727,-0.00232928) , 
2, -1.3039, 1, 0, 0.509942,0.00403858)    );
  // itree = 1197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174792,-0.0332847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132222,0.0139333) , 
1, -0.125285, 1, 0, 0.151794,-0.0239078) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293451,-0.0271274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681292,0.0107137) , 
2, -0.809284, 1, 0, 0.65294,0.0154867) , 
3, -0.823957, 1, 0, 0.537199,0.00638844)    );
  // itree = 1198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251707,0.055209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184784,-0.0210692) , 
1, -1.52393, 1, 0, 0.19027,-0.0285497) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53525,0.0318037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752395,0.000971837) , 
3, 0.25111, 1, 0, 0.701615,0.0182776) , 
3, -0.218528, 1, 0, 0.487831,-0.00129999)    );
  // itree = 1199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0538263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441066,0.0362024) , 
3, -1.95158, 1, 0, 0.393331,0.0610854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670312,-0.00167042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624029,-0.0476043) , 
1, 0.769971, 1, 0, 0.659964,-0.0231371) , 
2, 0.0207206, 1, 0, 0.522152,0.0203941)    );
  // itree = 1200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481604,0.0148871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710261,-0.0187291) , 
0, 1.25027, 1, 0, 0.53025,0.012948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440057,-0.0176076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45395,0.0122657) , 
1, 1.12612, 1, 0, 0.443093,-0.0228316) , 
1, -0.239672, 1, 0, 0.476539,-0.00910155)    );
  // itree = 1201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409473,0.0044275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0755117) , 
2, 0.845787, 1, 0, 0.441302,0.0150355) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636879,-0.00723813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478503,-0.0413817) , 
1, 1.16323, 1, 0, 0.61261,-0.0262779) , 
0, 0.394028, 1, 0, 0.512554,-0.00214787)    );
  // itree = 1202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0280537,-0.0621484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212655,0.031511) , 
0, -3.19325, 1, 0, 0.185526,0.0235645) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200209,-0.0388175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6759,-9.08612e-05) , 
3, -0.43783, 1, 0, 0.629274,-0.010381) , 
3, -0.679404, 1, 0, 0.522382,-0.00220408)    );
  // itree = 1203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421388,-0.00625586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954965,0.0356758) , 
3, 1.4339, 1, 0, 0.494139,-0.00493177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617274,-0.0418056) , 
0, 2.97343, 1, 0, 0.497454,-0.00789693)    );
  // itree = 1204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128291,-0.0487642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151602,-0.0246619) , 
1, -0.438842, 1, 0, 0.143575,-0.0596743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418949,0.0310809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613397,-0.002374) , 
0, -0.601272, 1, 0, 0.548731,0.0148647) , 
0, -2.54258, 1, 0, 0.512892,0.00827121)    );
  // itree = 1205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603118,0.0072443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447664,-0.0305359) , 
1, -0.684315, 1, 0, 0.538121,-0.0195741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518837,0.0163971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289643,-0.0342821) , 
1, 2.01892, 1, 0, 0.503794,0.0229559) , 
1, -0.177239, 1, 0, 0.519183,0.00388997)    );
  // itree = 1206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24252,0.0243041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325058,-0.0216814) , 
2, -1.06742, 1, 0, 0.298012,-0.021113) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579496,-0.0521996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659942,0.0105794) , 
1, -1.69005, 1, 0, 0.654463,0.013489) , 
2, -0.188318, 1, 0, 0.512465,-0.00029527)    );
  // itree = 1207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516825,0.000355528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474729,0.0219052) , 
1, -0.102661, 1, 0, 0.493795,0.022933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489769,-0.0406069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.898046,0.00388843) , 
3, 1.83824, 1, 0, 0.727091,-0.0390438) , 
0, 1.97895, 1, 0, 0.518712,0.0163135)    );
  // itree = 1208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460062,0.000529242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681396,0.0209377) , 
0, -0.0225028, 1, 0, 0.575,0.02205) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309385,-0.0287533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830723,0.00263019) , 
2, 1.25629, 1, 0, 0.354257,-0.0522945) , 
1, 0.65463, 1, 0, 0.507657,-0.000630713)    );
  // itree = 1209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126022,-0.0496998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545368,-0.00640523) , 
2, -1.07079, 1, 0, 0.493212,-0.0212263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585082,0.0423961) , 
1, 1.76787, 1, 0, 0.497587,-0.0156796)    );
  // itree = 1210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206756,-0.00151137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0889218,-0.0382888) , 
0, -1.73626, 1, 0, 0.16071,-0.0353476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.695892,-0.0182366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595417,0.00715087) , 
1, -1.36363, 1, 0, 0.608154,0.00831557) , 
3, -0.692989, 1, 0, 0.502864,-0.00195893)    );
  // itree = 1211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39457,0.00953664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367839,0.0460605) , 
1, 1.17337, 1, 0, 0.390438,0.0327413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.793761,0.00359801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62738,-0.0398475) , 
1, 1.29909, 1, 0, 0.774843,-0.00413651) , 
3, 0.402144, 1, 0, 0.557728,0.0166923)    );
  // itree = 1212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106215,-0.023001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485921,0.0099881) , 
3, -0.703405, 1, 0, 0.206413,-0.0212229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47827,0.0147152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760658,-0.00289201) , 
3, 0.444726, 1, 0, 0.62665,0.0119705) , 
2, -0.55359, 1, 0, 0.494954,0.00156814)    );
  // itree = 1213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316086,0.0054003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333224,-0.0176199) , 
0, -1.05814, 1, 0, 0.32534,-0.0144351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518954,0.0357855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.827388,-0.000595873) , 
3, 0.561661, 1, 0, 0.729796,0.0228182) , 
2, 0.0154847, 1, 0, 0.504717,0.0020868)    );
  // itree = 1214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.787177,0.0692231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506855,0.000117061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501417,0.0221602) , 
1, 0.547934, 1, 0, 0.504832,0.0145753) , 
1, -1.59845, 1, 0, 0.517676,0.0206669)    );
  // itree = 1215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318112,-0.0348706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261641,0.0244096) , 
1, -1.20159, 1, 0, 0.270368,0.0196093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.693701,0.0248106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574362,-0.0151258) , 
1, -1.52075, 1, 0, 0.583301,-0.0243428) , 
2, -0.716195, 1, 0, 0.507955,-0.0137603)    );
  // itree = 1216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334188,0.0229317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368748,-0.00976621) , 
0, -1.40487, 1, 0, 0.356951,-0.0036845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559182,0.0656634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833917,0.0206854) , 
3, 0.472161, 1, 0, 0.767867,0.0583481) , 
2, 0.129681, 1, 0, 0.54053,0.0240288)    );
  // itree = 1217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126128,-0.0376401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599096,0.00801041) , 
0, -2.07051, 1, 0, 0.536753,0.00565826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145417,-0.0323061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527832,-0.0063176) , 
2, -0.806007, 1, 0, 0.411177,-0.0292061) , 
1, -0.133281, 1, 0, 0.463674,-0.014631)    );
  // itree = 1218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155981,-0.00844166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566514,0.0240693) , 
3, -0.940886, 1, 0, 0.383547,0.0264213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.889946,0.0248207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62196,-0.0211924) , 
0, -0.328272, 1, 0, 0.650166,-0.0334181) , 
2, -0.0908777, 1, 0, 0.534506,-0.0074597)    );
  // itree = 1219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319435,0.0526864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417191,-0.0165264) , 
0, -2.86474, 1, 0, 0.410921,-0.0274891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.821852,0.028401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819182,-0.0132279) , 
2, 1.63379, 1, 0, 0.82123,0.036036) , 
2, 0.923149, 1, 0, 0.48842,-0.0154906)    );
  // itree = 1220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241535,-0.0370256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787143,-0.00329393) , 
3, 0.111996, 1, 0, 0.48986,-0.0450657) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651306,0.0417447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432878,-0.00674311) , 
1, 0.214068, 1, 0, 0.472325,0.00450645) , 
1, -0.11574, 1, 0, 0.479863,-0.0168051)    );
  // itree = 1221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0911025,0.0150327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334869,-0.0192763) , 
3, -1.46055, 1, 0, 0.292555,-0.033465) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.857465,0.0251913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68757,-0.00689823) , 
0, 1.19618, 1, 0, 0.759785,0.00944804) , 
3, 0.427177, 1, 0, 0.461053,-0.0179892)    );
  // itree = 1222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29459,0.00928856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.113273) , 
2, 0.0063529, 1, 0, 0.355608,0.0280784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.661565,0.0130675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510154,-0.0123508) , 
1, -0.102661, 1, 0, 0.578575,-0.00290529) , 
0, -0.794061, 1, 0, 0.507881,0.00691844)    );
  // itree = 1223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0554919,-0.00491108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261992,-0.0409674) , 
3, -1.58127, 1, 0, 0.18156,-0.0720684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532406,0.00381521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716676,-0.0231647) , 
2, 0.862872, 1, 0, 0.585587,-0.00823381) , 
0, -1.56562, 1, 0, 0.489814,-0.0233656)    );
  // itree = 1224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.656693,0.0169527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449567,-0.0123572) , 
1, -0.66283, 1, 0, 0.506413,-0.0107972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45771,0.0502592) , 
1, 1.8322, 1, 0, 0.50482,-0.0072812)    );
  // itree = 1225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164288,-0.0020149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618315,-0.0216212) , 
3, -0.478039, 1, 0, 0.416234,-0.0282998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.742766,-0.0255405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670874,0.0258871) , 
1, -0.420956, 1, 0, 0.69538,0.0151058) , 
0, 0.978749, 1, 0, 0.495179,-0.0160243)    );
  // itree = 1226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20866,-0.00242456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623174,-0.0298974) , 
3, -0.462446, 1, 0, 0.344702,-0.0246841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399192,0.0167175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793757,-0.00803313) , 
3, 0.759355, 1, 0, 0.618527,0.00951888) , 
0, -0.271515, 1, 0, 0.492142,-0.00626757)    );
  // itree = 1227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147113,0.162475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156966,0.0121931) , 
3, -2.08616, 1, 0, 0.154502,0.0389281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684181,0.0238804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509991,-0.0107135) , 
1, -1.52075, 1, 0, 0.525142,-0.0161514) , 
3, -1.25675, 1, 0, 0.479083,-0.00930668)    );
  // itree = 1228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465605,-0.0418856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716873,-0.0399435) , 
0, 0.143348, 1, 0, 0.602178,-0.0945331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514494,-0.000889528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482993,0.0184364) , 
1, 1.17914, 1, 0, 0.509764,0.00495775) , 
1, -1.69005, 1, 0, 0.514871,-0.000540827)    );
  // itree = 1229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131804,-0.000824792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460633,-0.0155752) , 
3, -0.661336, 1, 0, 0.326184,-0.0229583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.865245,-0.00336518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.866816,0.0203387) , 
1, -0.528003, 1, 0, 0.866289,0.0249303) , 
3, 0.828289, 1, 0, 0.479442,-0.00936957)    );
  // itree = 1230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166945,0.0116645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49317,-0.0252873) , 
3, -0.553361, 1, 0, 0.356988,-0.026589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.860802,0.0302558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719571,0.00120166) , 
1, -0.48289, 1, 0, 0.776108,0.0236666) , 
2, 0.556239, 1, 0, 0.488673,-0.010799)    );
  // itree = 1231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202407,0.00216116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747526,0.0566719) , 
3, -0.455053, 1, 0, 0.387689,0.0433911) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360986,-0.02471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78752,0.0039036) , 
3, 0.554632, 1, 0, 0.648902,-0.0156424) , 
2, 0.0876493, 1, 0, 0.529893,0.0112533)    );
  // itree = 1232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193507,-0.00215689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653723,0.0161114) , 
3, -0.349602, 1, 0, 0.404151,0.0139683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566544,-0.0377555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756639,0.00345751) , 
0, 0.805606, 1, 0, 0.687628,-0.0305328) , 
2, 0.566067, 1, 0, 0.493724,-9.32032e-05)    );
  // itree = 1233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0640545,-0.0417332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0184058,-0.000186401) , 
1, 0.434174, 1, 0, 0.048896,-0.0367174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548433,0.0353925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657847,-0.00626574) , 
2, 0.282347, 1, 0, 0.605478,0.0284865) , 
3, -1.19711, 1, 0, 0.511717,0.0175024)    );
  // itree = 1234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443676,0.017751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658866,-0.0143212) , 
2, 0.41536, 1, 0, 0.53068,0.00849665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210453,-0.024675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836019,0.0161806) , 
3, 0.673895, 1, 0, 0.407536,-0.0236912) , 
1, 0.0584283, 1, 0, 0.464059,-0.00891693)    );
  // itree = 1235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278054,-0.0198815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59974,0.00196919) , 
0, -0.968126, 1, 0, 0.499562,-0.00940257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461766,0.0493707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721899,-0.0155586) , 
0, 0.550895, 1, 0, 0.54949,0.059424) , 
1, 1.1208, 1, 0, 0.506434,7.04942e-05)    );
  // itree = 1236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.080766,-0.0159806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631492,0.0376527) , 
3, -1.40097, 1, 0, 0.295578,0.0299045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464237,-0.0160945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.940051,0.0218562) , 
3, 1.8273, 1, 0, 0.517894,-0.0271127) , 
0, -2.03899, 1, 0, 0.491539,-0.0203534)    );
  // itree = 1237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495376,-0.0610123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346546,-0.010848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646313,0.0148157) , 
0, -0.392097, 1, 0, 0.515025,0.0072886) , 
1, -2.04143, 1, 0, 0.514328,0.00224542)    );
  // itree = 1238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644367,0.00536674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869138,0.0632646) , 
1, -1.48962, 1, 0, 0.752479,0.0488351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216268,0.0282909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516321,-0.00942166) , 
2, -1.13969, 1, 0, 0.466419,-0.0104677) , 
1, -1.0628, 1, 0, 0.510138,-0.00140436)    );
  // itree = 1239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498959,-0.0594016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610057,0.0135745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436844,-0.0148892) , 
1, 0.0296593, 1, 0, 0.521589,-0.00269112) , 
1, -2.02435, 1, 0, 0.520984,-0.00679238)    );
  // itree = 1240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553362,-0.0253594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510203,0.00453285) , 
1, -1.2581, 1, 0, 0.516839,-0.000899943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289183,0.0917862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466881,-0.032855) , 
2, -1.49842, 1, 0, 0.449379,-0.0552484) , 
1, 0.560452, 1, 0, 0.494415,-0.0189657)    );
  // itree = 1241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.070372,0.0604198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568494,-0.0483142) , 
3, -1.99508, 1, 0, 0.0607399,-0.0416316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622317,0.0450684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592061,0.00536869) , 
0, -0.398034, 1, 0, 0.600698,0.0323265) , 
3, -1.16308, 1, 0, 0.520997,0.0214099)    );
  // itree = 1242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163684,0.019541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494871,0.0594367) , 
3, -0.907038, 1, 0, 0.233424,0.0556692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435415,-0.0174089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685981,0.0120413) , 
2, 0.0316108, 1, 0, 0.594448,-0.000220183) , 
3, -0.680259, 1, 0, 0.506228,0.013437)    );
  // itree = 1243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.683847,0.0736528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389379,-0.0194355) , 
1, -1.72494, 1, 0, 0.402257,-0.0326341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.816079,0.0327891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686129,0.00307314) , 
1, -0.220943, 1, 0, 0.738982,0.0275618) , 
0, 0.749055, 1, 0, 0.51109,-0.0131783)    );
  // itree = 1244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494432,-0.00636411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392578,-0.0312771) , 
1, 1.03224, 1, 0, 0.47991,-0.0215686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666741,0.0669322) , 
1, 1.71189, 1, 0, 0.4869,-0.0158004)    );
  // itree = 1245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228904,0.00382773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464254,-0.0267314) , 
2, -0.424318, 1, 0, 0.337809,-0.0229055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576464,0.0392351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813388,-0.00946582) , 
3, 0.980109, 1, 0, 0.722914,0.0237899) , 
2, 0.391241, 1, 0, 0.478062,-0.00589935)    );
  // itree = 1246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27445,-0.0422945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.879824,-0.00251805) , 
3, 0.0594671, 1, 0, 0.61953,-0.0631338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247172,0.000317828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644948,0.0180425) , 
2, -0.349281, 1, 0, 0.484984,0.0205751) , 
1, -1.33134, 1, 0, 0.498434,0.0122066)    );
  // itree = 1247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520922,0.00534501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582389,0.0405862) , 
1, 1.2157, 1, 0, 0.526965,0.0172332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223782,-0.044773) , 
1, 1.96083, 1, 0, 0.514565,0.0114914)    );
  // itree = 1248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236412,-0.0146187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710779,0.0124506) , 
3, 0.0113225, 1, 0, 0.436587,-0.00585119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586775,-0.0210289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628365,-0.0692569) , 
2, 1.48902, 1, 0, 0.596934,-0.0684631) , 
0, 1.65381, 1, 0, 0.455758,-0.0133373)    );
  // itree = 1249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22545,0.156383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326833,0.0158743) , 
0, -3.21164, 1, 0, 0.315668,0.0460108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518083,0.0072424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725024,-0.0144614) , 
2, 0.488605, 1, 0, 0.619401,-0.00647127) , 
2, -0.60569, 1, 0, 0.53182,0.00866195)    );
  // itree = 1250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201938,-0.0633292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251794,-0.00177531) , 
1, -0.900095, 1, 0, 0.243619,-0.0252977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436998,0.0325517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713084,-0.00109747) , 
3, -0.0506506, 1, 0, 0.662448,0.0104578) , 
2, -0.351252, 1, 0, 0.49122,-0.00415997)    );
  // itree = 1251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290325,0.0117447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58499,-0.0152416) , 
2, -0.575523, 1, 0, 0.515476,-0.0201147) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21133,-0.0049123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830387,0.0201699) , 
3, 0.446592, 1, 0, 0.468713,0.00955551) , 
1, 0.237261, 1, 0, 0.494863,-0.00703582)    );
  // itree = 1252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12297,-0.0453951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108726,-0.0269301) , 
1, -1.15601, 1, 0, 0.111304,-0.0552941) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621132,0.0206925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62021,-0.00637609) , 
0, -0.0902484, 1, 0, 0.62052,0.00665435) , 
3, -0.680259, 1, 0, 0.486664,-0.0096299)    );
  // itree = 1253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522052,0.0339593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609197,-0.00219028) , 
0, -0.854263, 1, 0, 0.582939,0.016876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227924,-0.0156643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791694,0.0112572) , 
3, 0.427177, 1, 0, 0.468574,-0.00984658) , 
1, 0.527824, 1, 0, 0.542691,0.00747149)    );
  // itree = 1254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230054,0.00318668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58229,-0.0320787) , 
3, -0.278788, 1, 0, 0.356454,-0.0261229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492368,0.0295659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69947,-0.00295453) , 
2, 0.458265, 1, 0, 0.615001,0.0208464) , 
0, -0.00931381, 1, 0, 0.484377,-0.00288356)    );
  // itree = 1255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63034,0.0350398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746238,-0.0216376) , 
2, 0.664271, 1, 0, 0.678539,0.0238103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389967,-0.0148226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691521,0.0127152) , 
0, 0.918314, 1, 0, 0.479697,-0.013066) , 
1, -0.827015, 1, 0, 0.518762,-0.00582119)    );
  // itree = 1256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121527,-0.0409937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377494,-0.000719609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695777,0.0156512) , 
2, 0.221425, 1, 0, 0.525343,0.0134) , 
0, -2.84999, 1, 0, 0.504351,0.00917349)    );
  // itree = 1257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0601218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656727,0.0197669) , 
3, -1.532, 1, 0, 0.579824,0.0303049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368217,0.00146009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659143,-0.0306315) , 
0, 1.44235, 1, 0, 0.421471,-0.0100072) , 
1, -0.133281, 1, 0, 0.489025,0.00719017)    );
  // itree = 1258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0680721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.724386,0.0406509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529304,-0.00163698) , 
1, -1.99411, 1, 0, 0.535175,-0.000163025) , 
2, -2.3317, 1, 0, 0.52098,-0.00340614)    );
  // itree = 1259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603979,0.0438929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461103,0.0129496) , 
1, -1.39642, 1, 0, 0.472427,0.0294666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.889342,0.0200861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647969,-0.0206128) , 
1, -0.900047, 1, 0, 0.692734,-0.029667) , 
0, 1.39929, 1, 0, 0.513498,0.0184426)    );
  // itree = 1260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0723958,0.0048116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491361,-0.0164437) , 
3, -1.35117, 1, 0, 0.435001,-0.0276767) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.841357,0.0400117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.89159,0.00507933) , 
3, 1.84024, 1, 0, 0.869601,0.0375116) , 
2, 1.28052, 1, 0, 0.476572,-0.0214412)    );
  // itree = 1261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291735,0.00752682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499014,-0.0293981) , 
2, -0.29243, 1, 0, 0.392483,-0.0253185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.951866,-0.0254934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.893566,0.0287193) , 
0, 1.59182, 1, 0, 0.910018,0.036884) , 
3, 1.24934, 1, 0, 0.479137,-0.0149036)    );
  // itree = 1262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461752,0.00416938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127464,-0.0465869) , 
1, 1.40585, 1, 0, 0.424136,-0.00486701) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72413,-0.0365731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639787,0.0157129) , 
1, -1.52667, 1, 0, 0.647654,0.0233326) , 
0, -0.0225028, 1, 0, 0.53762,0.00945047)    );
  // itree = 1263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559946,-0.00458158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464028,-0.024214) , 
1, -0.0878667, 1, 0, 0.515564,-0.0276665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12424,-0.0205779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459362,0.0139071) , 
2, -1.3117, 1, 0, 0.404286,0.0140565) , 
1, 0.907319, 1, 0, 0.488918,-0.0176759)    );
  // itree = 1264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458894,0.0440214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816188,0.00743374) , 
0, -0.592842, 1, 0, 0.709299,0.0377532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477754,-0.0165992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446522,-0.00189171) , 
1, 0.0712706, 1, 0, 0.460839,-0.0166315) , 
1, -1.17388, 1, 0, 0.490601,-0.0101169)    );
  // itree = 1265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450968,-0.0143026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31258,0.0131345) , 
1, -0.733145, 1, 0, 0.34764,0.0136127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.599002,-0.0214143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.911004,0.0128717) , 
3, 1.6311, 1, 0, 0.686196,-0.0315944) , 
3, 0.402144, 1, 0, 0.483845,-0.00457467)    );
  // itree = 1266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1745,-0.0160989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392291,0.0295282) , 
0, -2.29977, 1, 0, 0.319418,0.0283726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52468,-0.0383628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60348,-0.00736191) , 
0, -0.3511, 1, 0, 0.583685,-0.0339711) , 
2, -0.471788, 1, 0, 0.5053,-0.0154791)    );
  // itree = 1267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145425,-0.0586216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23322,-0.0189321) , 
1, -1.37283, 1, 0, 0.226991,-0.0458674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629894,0.050524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706002,-0.00103425) , 
2, 0.0711342, 1, 0, 0.689707,0.0200795) , 
2, -0.346453, 1, 0, 0.505425,-0.00618454)    );
  // itree = 1268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163996,-0.023955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.762403,0.0254452) , 
3, -0.358721, 1, 0, 0.538934,0.0143819) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257612,0.0102772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517829,-0.0205726) , 
0, -0.392097, 1, 0, 0.407113,-0.0168219) , 
1, -0.11574, 1, 0, 0.467766,-0.0024645)    );
  // itree = 1269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.807379,0.0703843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481185,-0.0189852) , 
1, -1.88957, 1, 0, 0.495444,-0.0320068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492853,0.0247836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638936,-0.0194298) , 
0, 1.74318, 1, 0, 0.515135,0.0325633) , 
1, 0.843066, 1, 0, 0.499772,-0.017816)    );
  // itree = 1270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0491947,-0.032279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589055,0.0128986) , 
3, -1.16224, 1, 0, 0.499085,0.0156566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268768,-0.0448928) , 
1, 1.88216, 1, 0, 0.487413,0.00910627)    );
  // itree = 1271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0520095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497389,0.0525679) , 
2, -1.81049, 1, 0, 0.315442,0.064872) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486557,-0.00686868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510485,0.0308677) , 
1, 1.47355, 1, 0, 0.488501,-0.00600074) , 
0, -2.33718, 1, 0, 0.472339,0.000617748)    );
  // itree = 1272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193655,-0.00642493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540928,0.0196218) , 
3, -0.361461, 1, 0, 0.272728,0.0017919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58145,-0.0174993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.921101,0.00426913) , 
3, 1.70178, 1, 0, 0.644586,-0.0296446) , 
2, -0.226567, 1, 0, 0.483627,-0.0160373)    );
  // itree = 1273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317604,0.0334693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189831,-0.0225156) , 
1, 1.27336, 1, 0, 0.292049,0.0354103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370669,-0.024401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791325,0.016305) , 
3, 0.379306, 1, 0, 0.625373,-0.00632712) , 
2, -0.420818, 1, 0, 0.509529,0.00817844)    );
  // itree = 1274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189427,0.0302437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588506,-0.0244242) , 
3, -1.17595, 1, 0, 0.527148,-0.0337407) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127164,-0.0175121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677241,0.011815) , 
3, -0.635449, 1, 0, 0.4993,0.00857692) , 
1, -0.480148, 1, 0, 0.508421,-0.00528309)    );
  // itree = 1275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403081,0.00087367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334019,-0.0187856) , 
1, 0.513496, 1, 0, 0.377991,-0.0132813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.788456,0.070964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779414,0.0094288) , 
0, -0.159962, 1, 0, 0.780324,0.0315221) , 
2, 0.566059, 1, 0, 0.497358,1.12981e-05)    );
  // itree = 1276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454172,0.0191854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572802,-0.024588) , 
0, -0.250337, 1, 0, 0.522401,-0.0133252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266469,-0.0088975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683727,0.0324319) , 
0, -0.22163, 1, 0, 0.482821,0.0248868) , 
1, -0.107454, 1, 0, 0.499355,0.00892454)    );
  // itree = 1277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151108,-0.0171268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309616,0.0291625) , 
2, -1.0626, 1, 0, 0.235749,0.0179115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387691,-0.0240146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747738,-0.00377841) , 
3, 0.390903, 1, 0, 0.615947,-0.0275446) , 
3, -0.302053, 1, 0, 0.490388,-0.0125328)    );
  // itree = 1278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376512,0.0620263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59701,-0.0243233) , 
3, -0.999213, 1, 0, 0.561592,-0.0231673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524979,0.0226464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396731,-0.00321196) , 
1, 0.853779, 1, 0, 0.485161,0.0284568) , 
1, -0.705165, 1, 0, 0.502387,0.0168219)    );
  // itree = 1279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122329,0.0717064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248813,-0.0331644) , 
2, -1.67852, 1, 0, 0.208104,-0.0229338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558491,0.0516606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601344,0.00149465) , 
0, -0.744041, 1, 0, 0.594126,0.0208229) , 
0, -1.6198, 1, 0, 0.524498,0.0129304)    );
  // itree = 1280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384848,0.0133848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.801624,-0.00316832) , 
3, 0.644232, 1, 0, 0.529102,0.0147652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2342,-0.0379413) , 
1, 1.96629, 1, 0, 0.517398,0.0109218)    );
  // itree = 1281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0400854,0.00344955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564742,0.0640943) , 
3, -1.88912, 1, 0, 0.25789,0.0638736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213576,-0.0230967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701643,0.000377787) , 
3, -0.181638, 1, 0, 0.525052,-0.0160007) , 
0, -2.44728, 1, 0, 0.502924,-0.00938514)    );
  // itree = 1282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533054,-0.00781137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380989,-0.0437569) , 
1, -0.404743, 1, 0, 0.486185,-0.0390902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475212,0.0110974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43353,-0.0204731) , 
1, 1.21986, 1, 0, 0.462918,0.00208677) , 
1, -0.102661, 1, 0, 0.473155,-0.0160307)    );
  // itree = 1283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104108,-0.0301778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0618852) , 
1, 0.998459, 1, 0, 0.0537563,-0.0698171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127164,-0.0193962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625216,0.00392038) , 
3, -0.834645, 1, 0, 0.519952,-0.000167365) , 
2, -1.97084, 1, 0, 0.494525,-0.00396619)    );
  // itree = 1284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654501,0.00486403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629789,0.0424429) , 
1, -1.14163, 1, 0, 0.641606,0.0485429) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459759,-0.00644515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509508,0.0344596) , 
1, 1.45292, 1, 0, 0.465062,-0.00404732) , 
1, -0.480148, 1, 0, 0.519421,0.0121454)    );
  // itree = 1285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230563,-0.0497854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270972,0.0213214) , 
1, 0.296648, 1, 0, 0.247808,-0.0572035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530789,0.0154384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678869,-0.0134538) , 
0, 0.643217, 1, 0, 0.593339,0.00703024) , 
0, -1.56562, 1, 0, 0.526469,-0.00540075)    );
  // itree = 1286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214588,-0.00110209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31792,-0.0380139) , 
2, -0.33607, 1, 0, 0.250735,-0.031128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763201,0.0159059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725808,-0.00531708) , 
1, -0.177239, 1, 0, 0.741834,0.00646508) , 
3, 0.202272, 1, 0, 0.48945,-0.0128546)    );
  // itree = 1287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354691,0.00110942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589858,-0.0218787) , 
2, 0.397413, 1, 0, 0.433047,-0.0132614) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.781405,0.0364699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.872113,-0.0046079) , 
3, 1.74065, 1, 0, 0.837487,0.0325831) , 
2, 1.34534, 1, 0, 0.468737,-0.00921585)    );
  // itree = 1288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208654,0.00220067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695423,-0.0520104) , 
3, -0.486668, 1, 0, 0.320997,-0.0227685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516944,0.0292456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622073,0.00438377) , 
0, -0.0648655, 1, 0, 0.596712,0.0206319) , 
0, -0.82394, 1, 0, 0.503414,0.00594585)    );
  // itree = 1289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231839,0.00630185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610323,0.0468486) , 
3, -0.301457, 1, 0, 0.355269,0.0447903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.620854,-0.0481506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723626,-0.0112475) , 
2, -0.165929, 1, 0, 0.716417,-0.0279356) , 
3, 0.27076, 1, 0, 0.534279,0.00874221)    );
  // itree = 1290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146287,0.00633456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286645,-0.0223008) , 
0, -1.74608, 1, 0, 0.239507,-0.0290437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.705668,0.00795076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724811,0.0422409) , 
1, 0.769971, 1, 0, 0.709561,0.0273652) , 
2, -0.242286, 1, 0, 0.495353,0.00165911)    );
  // itree = 1291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508453,-0.00716278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556947,0.01786) , 
1, 0.778024, 1, 0, 0.519267,-0.00401598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415847,-0.03673) , 
1, 2.06604, 1, 0, 0.516199,-0.00666076)    );
  // itree = 1292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563196,-0.000849462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50223,0.037902) , 
1, 0.208701, 1, 0, 0.549188,0.0128207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164741,-0.0252145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626354,-0.00418624) , 
2, -0.55359, 1, 0, 0.430823,-0.0221782) , 
1, 0.581975, 1, 0, 0.511991,0.0018222)    );
  // itree = 1293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407371,0.000499584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811548,0.0206519) , 
2, 0.61766, 1, 0, 0.514101,0.0103957) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63217,0.00640045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290496,-0.0305605) , 
1, 1.38702, 1, 0, 0.3596,-0.051837) , 
1, 1.25419, 1, 0, 0.494813,0.00262663)    );
  // itree = 1294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637427,-0.00781721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508843,0.013305) , 
1, -0.716515, 1, 0, 0.556803,0.0113814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393724,-0.0353349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577111,0.0432087) , 
1, 1.95004, 1, 0, 0.406216,-0.06284) , 
1, 0.387754, 1, 0, 0.501207,-0.0160211)    );
  // itree = 1295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139488,0.00743383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432967,0.0287442) , 
3, -0.716991, 1, 0, 0.243574,0.0292413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635905,-0.0158954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681591,0.0314548) , 
1, 1.74144, 1, 0, 0.638479,-0.0281028) , 
3, -0.216753, 1, 0, 0.489712,-0.00650026)    );
  // itree = 1296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546633,0.00150484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425052,-0.0154514) , 
1, 0.201405, 1, 0, 0.505479,-0.00824982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596351,0.0734578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458104,0.0138656) , 
1, 1.11629, 1, 0, 0.48328,0.0533553) , 
1, 1.00778, 1, 0, 0.501263,0.00345156)    );
  // itree = 1297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405556,0.0123646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232834,-0.0189461) , 
1, -0.614963, 1, 0, 0.283709,-0.0183139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.784888,0.0150468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547159,-0.0305946) , 
1, 1.74144, 1, 0, 0.769596,0.023361) , 
3, 0.34753, 1, 0, 0.484971,-0.00105152)    );
  // itree = 1298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125837,-0.0340532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130863,-0.00577864) , 
1, 0.303058, 1, 0, 0.127469,-0.0436256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.783916,0.0505294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601892,-0.00721598) , 
0, -0.34907, 1, 0, 0.634323,0.00689086) , 
3, -0.547237, 1, 0, 0.470084,-0.00947823)    );
  // itree = 1299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588719,-0.0536797) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.751621,0.0448877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483732,0.00790657) , 
1, -0.774412, 1, 0, 0.53022,0.0270659) , 
1, -1.92948, 1, 0, 0.531759,0.0234071)    );
  // itree = 1300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495941,0.0057535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793615,-0.031483) , 
2, 1.33607, 1, 0, 0.523957,0.00463867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222197,-0.0444309) , 
1, 1.84867, 1, 0, 0.513719,0.00140163)    );
  // itree = 1301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487183,-0.0137777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545762,-0.0445506) , 
1, 0.853008, 1, 0, 0.490592,-0.0289801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400899,0.0272431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793982,-0.0215386) , 
3, 1.18677, 1, 0, 0.487009,0.0344527) , 
1, 1.06105, 1, 0, 0.489906,-0.0168375)    );
  // itree = 1302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437583,0.00548226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.914998,0.0539393) , 
0, -0.927738, 1, 0, 0.754859,0.0583945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437962,-0.0789869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44535,-0.00402477) , 
1, -1.10423, 1, 0, 0.444957,-0.0154365) , 
1, -1.33134, 1, 0, 0.47222,-0.00894149)    );
  // itree = 1303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184966,-0.00347754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522967,-0.0305706) , 
3, -0.300886, 1, 0, 0.361786,-0.0392426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.85317,0.0236252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707268,-0.00529647) , 
1, -0.429674, 1, 0, 0.758541,0.00658944) , 
2, 0.514398, 1, 0, 0.493796,-0.0239932)    );
  // itree = 1304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208232,-0.00784825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737088,0.0256013) , 
2, -0.665831, 1, 0, 0.627037,0.0387354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273597,0.021135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516642,-0.01034) , 
0, -1.48672, 1, 0, 0.461305,-0.00959776) , 
1, -0.107454, 1, 0, 0.527229,0.009628)    );
  // itree = 1305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223108,0.0332833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354319,-0.0198217) , 
0, -2.62536, 1, 0, 0.335355,-0.0310189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.722381,0.0459872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685236,0.00076501) , 
2, 0.430261, 1, 0, 0.691604,0.0156121) , 
2, 0.21926, 1, 0, 0.480811,-0.0119795)    );
  // itree = 1306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238315,0.000908302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59647,0.0168475) , 
2, -0.359438, 1, 0, 0.379175,0.0149651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35827,-0.0291867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811193,0.0106031) , 
3, 0.658961, 1, 0, 0.670962,-0.00562181) , 
2, 0.462259, 1, 0, 0.482143,0.00770017)    );
  // itree = 1307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28658,-0.0139587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.961871,0.0707093) , 
3, 0.736027, 1, 0, 0.323531,-0.0189425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574548,0.0664545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802971,-0.00774413) , 
3, 0.414393, 1, 0, 0.759958,0.0145472) , 
2, 0.289013, 1, 0, 0.484895,-0.00656009)    );
  // itree = 1308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180434,-0.0360603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13843,0.0113602) , 
1, -0.45931, 1, 0, 0.153519,-0.0240938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541349,0.0379168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670565,0.011648) , 
2, -0.357804, 1, 0, 0.648099,0.0314979) , 
3, -0.703077, 1, 0, 0.508277,0.0157816)    );
  // itree = 1309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308958,-0.00918973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574867,-0.048175) , 
2, 0.0720478, 1, 0, 0.348299,-0.0286082) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684654,0.0232873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626146,-0.0116499) , 
1, 0.743307, 1, 0, 0.66837,0.0265096) , 
0, -0.213974, 1, 0, 0.507344,-0.00121984)    );
  // itree = 1310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132879,0.199311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.675691,0.0217803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473978,-0.00433379) , 
1, -1.01826, 1, 0, 0.506393,-0.00114534) , 
2, -1.97084, 1, 0, 0.493016,0.00265533)    );
  // itree = 1311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130802,0.00202906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156808,0.0561488) , 
2, -1.05693, 1, 0, 0.139945,0.0223343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207844,-0.0261519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.642566,0.00302769) , 
3, -0.415466, 1, 0, 0.559652,-0.00591871) , 
3, -0.98855, 1, 0, 0.469143,0.000173978)    );
  // itree = 1312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386121,-0.0425694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.844498,-0.0161394) , 
3, 0.154844, 1, 0, 0.663371,-0.0563987) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467831,-8.30583e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539521,0.0433442) , 
1, 2.08218, 1, 0, 0.470133,0.00258644) , 
1, -1.05754, 1, 0, 0.498791,-0.00616133)    );
  // itree = 1313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.648193,0.0208853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492575,-0.0147635) , 
1, -0.877092, 1, 0, 0.532572,-0.0107207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0323638,-0.041509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531867,0.0224804) , 
2, -1.8038, 1, 0, 0.464268,0.036066) , 
1, 0.907319, 1, 0, 0.516338,0.000399441)    );
  // itree = 1314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339414,-0.0292988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.89599,0.00374889) , 
3, 0.213117, 1, 0, 0.597695,-0.0315703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403999,0.0212146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645642,0.000437412) , 
0, 0.978749, 1, 0, 0.46769,0.0261746) , 
1, -1.05754, 1, 0, 0.487352,0.0174412)    );
  // itree = 1315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359133,-0.00644973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585694,-0.0320961) , 
2, 0.484273, 1, 0, 0.405298,-0.0254545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570143,0.047418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.856218,-0.00284495) , 
3, 1.20626, 1, 0, 0.783316,0.0197598) , 
2, 1.0535, 1, 0, 0.464865,-0.0183297)    );
  // itree = 1316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450762,0.0543176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223644,0.000149165) , 
1, -1.21306, 1, 0, 0.243588,0.0105409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57041,-0.0425907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643386,-0.00539857) , 
0, 0.00525313, 1, 0, 0.622614,-0.0365121) , 
3, -0.316527, 1, 0, 0.502543,-0.0216062)    );
  // itree = 1317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207857,0.0131304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434164,0.0804124) , 
2, -1.39388, 1, 0, 0.323945,0.0725651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563629,0.00537799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708339,-0.0266937) , 
2, 1.01099, 1, 0, 0.597179,-0.00287671) , 
2, -0.806007, 1, 0, 0.54327,0.0120079)    );
  // itree = 1318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118918,0.0367597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666247,0.0878629) , 
2, -1.71095, 1, 0, 0.370045,0.0876894) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528442,-0.0214772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491888,0.00071974) , 
1, 0.213586, 1, 0, 0.510893,-0.0207785) , 
0, -2.62228, 1, 0, 0.501609,-0.013629)    );
  // itree = 1319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633637,0.00760826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550848,-0.044643) , 
1, -1.4134, 1, 0, 0.594451,-0.0352818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440295,0.0198246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461555,-0.00307372) , 
1, -0.454414, 1, 0, 0.457508,0.00170753) , 
1, -0.936379, 1, 0, 0.482501,-0.00504326)    );
  // itree = 1320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280674,-0.0425452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612919,-0.00582071) , 
0, -0.81104, 1, 0, 0.51087,-0.0334838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131421,-0.0256087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537393,0.00814886) , 
2, -1.14361, 1, 0, 0.467574,0.00763484) , 
1, -0.480148, 1, 0, 0.480854,-0.00497703)    );
  // itree = 1321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345855,0.00414053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760275,0.0478911) , 
2, 0.186844, 1, 0, 0.404237,0.0168762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448964,-0.0342958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767522,-0.00709512) , 
2, 0.632008, 1, 0, 0.712948,-0.0255485) , 
2, 0.462259, 1, 0, 0.518049,0.00123555)    );
  // itree = 1322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.581781,-0.0221746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554378,0.031438) , 
1, -0.655009, 1, 0, 0.568483,0.0118852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364682,-0.0252483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.908579,0.0387328) , 
2, 1.4209, 1, 0, 0.411365,-0.0432835) , 
1, 0.0567207, 1, 0, 0.482783,-0.0182063)    );
  // itree = 1323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172901,-0.0140367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3302,0.0429934) , 
2, -0.786466, 1, 0, 0.237364,0.0200111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345261,-0.0452962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639725,-0.0129999) , 
2, -0.357804, 1, 0, 0.606863,-0.0392182) , 
3, -0.206128, 1, 0, 0.451726,-0.0143503)    );
  // itree = 1324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219991,-0.000335117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669482,0.0510102) , 
3, -0.38318, 1, 0, 0.278827,0.0161399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413772,-0.0324985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713921,-0.00606819) , 
3, 0.302856, 1, 0, 0.638471,-0.030036) , 
3, -0.140694, 1, 0, 0.503241,-0.0126733)    );
  // itree = 1325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176567,0.0119577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390982,-0.0204579) , 
3, -0.771644, 1, 0, 0.298348,-0.0210692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681575,0.0285307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732992,-0.0199677) , 
2, 0.879022, 1, 0, 0.706576,0.00907777) , 
2, 0.143877, 1, 0, 0.481447,-0.00754767)    );
  // itree = 1326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0666998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53971,-0.00099993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540296,0.0185016) , 
1, -0.259324, 1, 0, 0.54005,0.0205271) , 
2, -1.86445, 1, 0, 0.517958,0.0167701)    );
  // itree = 1327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323515,-0.000913353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46393,0.0210154) , 
0, -0.140723, 1, 0, 0.366727,0.0117124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359659,-0.0317107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884426,0.0081895) , 
3, 1.05076, 1, 0, 0.672087,-0.0244671) , 
2, 0.456587, 1, 0, 0.472374,-0.000804807)    );
  // itree = 1328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383119,-0.00233764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342221,-0.0274529) , 
0, 0.135767, 1, 0, 0.369673,-0.0229297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92262,0.0219812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814706,-0.0221467) , 
2, 1.32531, 1, 0, 0.887359,0.00775545) , 
3, 1.14303, 1, 0, 0.471821,-0.016875)    );
  // itree = 1329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352435,0.0279075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141566,-0.0119388) , 
1, 0.433143, 1, 0, 0.283366,0.0340586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651893,-0.0173309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619848,0.00745735) , 
1, 0.512128, 1, 0, 0.640704,-0.0173792) , 
3, -0.302053, 1, 0, 0.497752,0.00319831)    );
  // itree = 1330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410363,-0.0192109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739133,0.005983) , 
2, 0.357053, 1, 0, 0.547889,-0.0241053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0978228,-0.0100135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633116,0.0194541) , 
3, -1.0482, 1, 0, 0.543582,0.0323903) , 
1, -0.133281, 1, 0, 0.545496,0.00728662)    );
  // itree = 1331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.10647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135597,-0.0221557) , 
0, -3.11982, 1, 0, 0.104211,-0.0630923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58839,0.018767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61526,-0.0194025) , 
0, 1.39216, 1, 0, 0.595642,0.0170668) , 
2, -1.40175, 1, 0, 0.535835,0.00731143)    );
  // itree = 1332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256551,-0.0164442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548066,0.00386083) , 
0, -1.28819, 1, 0, 0.474031,-0.00120755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576266,0.0498068) , 
1, 1.94792, 1, 0, 0.47696,0.0016493)    );
  // itree = 1333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19369,-0.0230045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813677,0.0623693) , 
2, -0.168637, 1, 0, 0.258519,-0.0300595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.571015,0.00439961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69159,0.0541616) , 
1, 1.47355, 1, 0, 0.580902,0.0187834) , 
0, -0.968126, 1, 0, 0.485125,0.00427264)    );
  // itree = 1334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222087,-0.0042526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404115,-0.033103) , 
3, -0.0977921, 1, 0, 0.256984,-0.0230606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.761,0.0145818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675648,-0.0327732) , 
0, 2.93851, 1, 0, 0.754489,0.0178536) , 
3, 0.179643, 1, 0, 0.494916,-0.00349337)    );
  // itree = 1335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12018,-0.0519703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152541,0.00301365) , 
1, -0.125285, 1, 0, 0.134441,-0.0476673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.639553,0.0201463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480021,0.000395868) , 
1, -0.133281, 1, 0, 0.548589,0.0168397) , 
0, -2.84999, 1, 0, 0.52153,0.0126252)    );
  // itree = 1336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384037,0.0614288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152374,-0.0196813) , 
1, 1.1511, 1, 0, 0.339194,0.067039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262177,-0.0128007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713932,0.0128151) , 
3, -0.00867277, 1, 0, 0.556817,0.00692687) , 
0, -1.77233, 1, 0, 0.526015,0.0154351)    );
  // itree = 1337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335827,-0.00193335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780235,-0.0237244) , 
3, 0.63977, 1, 0, 0.486713,-0.0155244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963779,0.0383436) , 
3, 2.60454, 1, 0, 0.50036,-0.0131413)    );
  // itree = 1338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.092944,0.0952624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207754,0.119567) , 
1, 0.593773, 1, 0, 0.151581,0.089086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304824,-0.0208934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575772,0.00757629) , 
0, -1.29407, 1, 0, 0.522348,0.00539345) , 
2, -1.74543, 1, 0, 0.497416,0.0110213)    );
  // itree = 1339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190308,-0.0154314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28369,-0.0553295) , 
2, -0.857196, 1, 0, 0.217709,-0.0529347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387126,0.0205911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588772,-0.00566032) , 
0, -0.160499, 1, 0, 0.511268,0.0068741) , 
0, -2.03899, 1, 0, 0.467607,-0.00202134)    );
  // itree = 1340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461267,-0.00650138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8235,0.0146604) , 
2, 0.949745, 1, 0, 0.520674,-0.00669369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214896,0.00446485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699187,0.0309767) , 
2, -0.486121, 1, 0, 0.506383,0.0361676) , 
1, 0.212582, 1, 0, 0.514464,0.0119321)    );
  // itree = 1341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350403,-0.0328859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590083,-0.0206459) , 
1, -2.1734, 1, 0, 0.459206,-0.0659479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375478,0.00754507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561504,-0.0110691) , 
0, -0.0499311, 1, 0, 0.468549,-0.00457681) , 
1, -1.65097, 1, 0, 0.467868,-0.00905202)    );
  // itree = 1342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350205,-0.000912526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557097,-0.0296925) , 
2, 0.345491, 1, 0, 0.405206,-0.0176279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712291,-0.0621347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.822877,0.0351977) , 
1, -1.20829, 1, 0, 0.803456,0.0364504) , 
2, 0.923149, 1, 0, 0.483901,-0.00694188)    );
  // itree = 1343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38589,0.00519132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205529,-0.0203714) , 
1, 0.236984, 1, 0, 0.285629,-0.0168027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58352,-0.0115603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711392,0.0159182) , 
2, 0.396944, 1, 0, 0.677241,0.0168568) , 
2, 0.0154847, 1, 0, 0.477214,-0.000335796)    );
  // itree = 1344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403164,0.0328772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632389,-0.000749756) , 
2, -0.351252, 1, 0, 0.572386,0.0144026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269674,-0.0248766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.857721,0.0142972) , 
3, 1.03191, 1, 0, 0.412531,-0.0372582) , 
1, 0.209522, 1, 0, 0.498947,-0.0093311)    );
  // itree = 1345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618374,0.0152982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47195,-0.0106563) , 
1, -0.467698, 1, 0, 0.519121,-0.00410212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433314,-0.00770448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329131,-0.0484943) , 
1, 1.63718, 1, 0, 0.374104,-0.0732773) , 
1, 1.38085, 1, 0, 0.502261,-0.0121447)    );
  // itree = 1346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145075,-0.0211246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0678277,-0.0602403) , 
0, -1.72796, 1, 0, 0.111846,-0.0668084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511717,-0.0135689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551694,0.0176577) , 
1, 0.527824, 1, 0, 0.524412,-0.00759102) , 
2, -1.026, 1, 0, 0.445364,-0.0189371)    );
  // itree = 1347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264386,-0.0369949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727627,-0.0184289) , 
3, 0.258021, 1, 0, 0.465954,-0.0637503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612566,0.0225551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415398,-0.00128514) , 
1, 0.0604713, 1, 0, 0.46996,0.010606) , 
1, -0.605346, 1, 0, 0.468696,-0.0128705)    );
  // itree = 1348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388641,0.0105743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712069,-0.0160482) , 
2, 0.500142, 1, 0, 0.425597,0.0126892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.816248,0.0377133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611409,-0.0198806) , 
1, -1.06403, 1, 0, 0.636734,-0.0271006) , 
0, 0.478344, 1, 0, 0.508866,-0.00300313)    );
  // itree = 1349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691303,-0.0352219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.881645,0.0573891) , 
3, -0.704989, 1, 0, 0.733089,0.0549203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307771,-0.0102421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815595,0.00677879) , 
3, 0.742135, 1, 0, 0.472581,-0.0101473) , 
1, -1.04839, 1, 0, 0.514404,0.000298999)    );
  // itree = 1350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584394,0.0172642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.911601,0.102182) , 
1, -1.40051, 1, 0, 0.682364,0.0561966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433344,-0.00748299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.933987,0.0296171) , 
2, 1.45534, 1, 0, 0.466958,-0.0099179) , 
1, -1.19893, 1, 0, 0.490564,-0.00267233)    );
  // itree = 1351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296044,0.00291906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704259,-0.0124948) , 
3, 0.27076, 1, 0, 0.489021,-0.00822202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599723,0.0726254) , 
1, 1.84641, 1, 0, 0.492154,-0.00468323)    );
  // itree = 1352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0529094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245041,-0.0465301) , 
3, -2.00555, 1, 0, 0.123239,-0.0726376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306005,0.0190591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613487,-0.0063122) , 
2, -0.435351, 1, 0, 0.522473,0.00212982) , 
0, -2.47643, 1, 0, 0.483703,-0.00513094)    );
  // itree = 1353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493415,0.0189489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728184,-0.00556848) , 
2, 0.981562, 1, 0, 0.539714,0.0270818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188489,0.0151892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40992,-0.0188401) , 
2, -1.19312, 1, 0, 0.363246,-0.0281236) , 
1, 1.15506, 1, 0, 0.508985,0.0174688)    );
  // itree = 1354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.624702,-0.0166715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584115,0.0164282) , 
1, -1.71565, 1, 0, 0.586315,0.0276821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251467,-0.00536714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235632,-0.0581683) , 
1, 2.31661, 1, 0, 0.244884,-0.0609604) , 
1, 1.8903, 1, 0, 0.563519,0.0217639)    );
  // itree = 1355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219263,0.0126213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562738,-0.0329651) , 
3, -0.584491, 1, 0, 0.462825,-0.049409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112754,-0.0252027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615849,0.0225891) , 
3, -0.516641, 1, 0, 0.449704,0.0158038) , 
1, 0.436904, 1, 0, 0.458056,-0.0257077)    );
  // itree = 1356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365621,0.00235955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428437,0.0859586) , 
1, 1.00515, 1, 0, 0.374526,0.0202218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440317,-0.0210453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631482,0.00155662) , 
0, 0.0246936, 1, 0, 0.581801,-0.0107387) , 
0, -0.794061, 1, 0, 0.521675,-0.00175775)    );
  // itree = 1357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345109,-0.0379175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65243,-0.00348706) , 
0, -0.160114, 1, 0, 0.495836,-0.0447669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45744,0.00709274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426383,-0.0175918) , 
1, 1.05042, 1, 0, 0.449581,0.000128205) , 
1, -0.515522, 1, 0, 0.465402,-0.0152277)    );
  // itree = 1358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174106,0.0296927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339893,-0.0253597) , 
3, -0.996768, 1, 0, 0.274538,-0.0220977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614577,-0.00128642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662932,0.0254507) , 
1, 0.147628, 1, 0, 0.634559,0.0197385) , 
2, -0.288777, 1, 0, 0.489284,0.00285684)    );
  // itree = 1359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.881755,0.0649695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222685,-0.0191007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588957,0.00952571) , 
0, -1.79098, 1, 0, 0.523195,0.0105272) , 
1, -1.96276, 1, 0, 0.534007,0.0140977)    );
  // itree = 1360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473779,-0.00956572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53944,0.0207253) , 
1, -0.495399, 1, 0, 0.512428,0.014912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246639,0.0293491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510849,-0.014681) , 
0, -1.40205, 1, 0, 0.46488,-0.0189071) , 
1, 0.718787, 1, 0, 0.499818,0.00594254)    );
  // itree = 1361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659271,0.0546278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279113,0.0345585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498195,-0.0077437) , 
2, -1.26809, 1, 0, 0.477755,-0.00857153) , 
1, -1.86762, 1, 0, 0.485667,-0.00483521)    );
  // itree = 1362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35051,-0.0156877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150192,-0.056233) , 
1, 1.24012, 1, 0, 0.322461,-0.0435094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56618,0.0077343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659894,-0.0169079) , 
0, 1.32509, 1, 0, 0.598477,-0.00262689) , 
0, -0.501866, 1, 0, 0.481844,-0.0199022)    );
  // itree = 1363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132745,-0.013057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361183,-0.0467452) , 
3, -0.928727, 1, 0, 0.191742,-0.0447149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489632,0.0263663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597754,-0.0102854) , 
0, -0.661136, 1, 0, 0.577587,-0.00959907) , 
0, -1.48672, 1, 0, 0.503371,-0.0163534)    );
  // itree = 1364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541708,-0.0239432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607185,0.0288621) , 
1, -1.66839, 1, 0, 0.596761,0.0355769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407071,-0.019057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497492,0.00314942) , 
1, 0.0295374, 1, 0, 0.471556,-0.00569882) , 
1, -0.527309, 1, 0, 0.509448,0.00679285)    );
  // itree = 1365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419888,-0.0387312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720947,0.00691414) , 
0, 0.329444, 1, 0, 0.547143,-0.0530435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439961,0.0198536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598619,-0.0151416) , 
0, 0.676813, 1, 0, 0.49909,0.0110746) , 
1, -1.09702, 1, 0, 0.505933,0.00194435)    );
  // itree = 1366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650645,0.0264067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681106,-0.0489953) , 
0, 1.19263, 1, 0, 0.657919,0.0191135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123144,-0.037177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647905,-0.000253868) , 
3, -0.2057, 1, 0, 0.428242,-0.0276163) , 
1, -0.527309, 1, 0, 0.48874,-0.0153075)    );
  // itree = 1367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151854,-0.0142972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268591,-0.0439618) , 
0, -1.62989, 1, 0, 0.185435,-0.0362164) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613921,0.0123945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48601,-0.0370189) , 
1, 1.77312, 1, 0, 0.607833,0.019894) , 
0, -1.22798, 1, 0, 0.502399,0.00588837)    );
  // itree = 1368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561303,-0.00669445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493329,0.0183944) , 
1, -0.457177, 1, 0, 0.522349,0.014243) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.775579,0.0216801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34147,-0.0217939) , 
1, 1.07658, 1, 0, 0.406035,-0.0266927) , 
1, 0.92669, 1, 0, 0.496077,0.00499681)    );
  // itree = 1369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412166,-0.00061897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436481,0.0428918) , 
0, 0.530985, 1, 0, 0.417053,0.0154777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.752969,-0.0681244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.904144,5.48586e-05) , 
3, 1.29878, 1, 0, 0.876781,-0.0215876) , 
3, 1.12461, 1, 0, 0.517587,0.00737223)    );
  // itree = 1370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32136,0.00813726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550128,-0.0202616) , 
2, -0.351252, 1, 0, 0.481565,-0.0236271) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450857,0.0158587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601652,-0.0278416) , 
0, 1.26301, 1, 0, 0.489281,0.00623531) , 
1, 0.547194, 1, 0, 0.483877,-0.0146779)    );
  // itree = 1371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521525,-0.00685443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397929,-0.0317265) , 
1, -0.585994, 1, 0, 0.473866,-0.0369873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215362,-0.012193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633519,0.0290033) , 
0, -1.2181, 1, 0, 0.5154,0.0363555) , 
1, -0.133281, 1, 0, 0.497615,0.00494989)    );
  // itree = 1372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458355,0.0183641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723423,-0.0179537) , 
3, 0.559729, 1, 0, 0.554142,0.0106222) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226664,-0.0287322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809343,0.0130704) , 
3, 0.541348, 1, 0, 0.445897,-0.0284843) , 
1, 0.219717, 1, 0, 0.504522,-0.00730438)    );
  // itree = 1373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417613,-0.00166305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667434,-0.04316) , 
2, 0.761095, 1, 0, 0.450213,-0.0138449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.74111,0.0317864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725461,-0.000551272) , 
2, 1.00818, 1, 0, 0.732623,0.0309616) , 
0, 1.20503, 1, 0, 0.514762,-0.00360366)    );
  // itree = 1374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495218,-0.00437721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812932,0.023213) , 
2, 1.07544, 1, 0, 0.548052,-9.37947e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531974,0.081672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431401,0.00829706) , 
1, 1.05668, 1, 0, 0.449089,0.0388792) , 
1, 0.907319, 1, 0, 0.52761,0.0079567)    );
  // itree = 1375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.812377,0.0442389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.444245,-0.0113193) , 
1, -2.00091, 1, 0, 0.456889,-0.018503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.742492,0.0578809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886088,-0.0107446) , 
3, 1.71429, 1, 0, 0.842024,0.0501606) , 
0, 2.01604, 1, 0, 0.49734,-0.0112911)    );
  // itree = 1376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291044,0.0390773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167358,-0.0241006) , 
1, 1.01352, 1, 0, 0.24793,0.0237284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474047,-0.0161024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.912374,0.0219768) , 
2, 1.44781, 1, 0, 0.510118,-0.0262815) , 
0, -1.79098, 1, 0, 0.475639,-0.0197049)    );
  // itree = 1377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240077,0.0392587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293292,-0.0113009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582755,0.00439052) , 
0, -1.09496, 1, 0, 0.502007,0.00028538) , 
0, -3.15088, 1, 0, 0.493478,0.00250873)    );
  // itree = 1378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.594515,-0.0382434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62192,0.0202063) , 
1, -2.0142, 1, 0, 0.619415,0.0245299) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285132,-0.0181965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.848118,0.0184435) , 
3, 0.876835, 1, 0, 0.44374,-0.0198544) , 
1, -0.537773, 1, 0, 0.496421,-0.00654439)    );
  // itree = 1379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137156,-3.08675e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149241,-0.0217958) , 
3, -1.01765, 1, 0, 0.142151,-0.0198542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830384,0.0389287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632307,0.00511354) , 
1, -0.567898, 1, 0, 0.689616,0.0306112) , 
3, -0.547237, 1, 0, 0.494685,0.0126424)    );
  // itree = 1380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26943,0.0352544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485203,0.000897402) , 
0, -1.86741, 1, 0, 0.441934,0.0134221) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511311,-0.0344457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.871925,0.00771506) , 
2, 1.27434, 1, 0, 0.627683,-0.0419254) , 
0, 1.12677, 1, 0, 0.486967,3.50875e-06)    );
  // itree = 1381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203661,0.00435258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716335,0.0245714) , 
3, -0.267395, 1, 0, 0.446302,0.0273341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47742,-0.0358936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750541,-0.00345972) , 
2, 0.843253, 1, 0, 0.659733,-0.0283469) , 
0, 1.18426, 1, 0, 0.491277,0.0156008)    );
  // itree = 1382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304685,0.0449474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297543,-0.00758649) , 
0, -1.43799, 1, 0, 0.302598,0.0458407) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729416,-0.0481992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664711,-0.00224243) , 
3, -0.249607, 1, 0, 0.552625,-0.0203983) , 
0, -1.03892, 1, 0, 0.481545,-0.00156718)    );
  // itree = 1383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271589,-0.00401623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624428,-0.0486973) , 
3, -0.364684, 1, 0, 0.355029,-0.0321734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290517,-0.0104205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680204,0.00862568) , 
2, -0.394281, 1, 0, 0.613482,0.0105842) , 
0, -0.794061, 1, 0, 0.529688,-0.00327839)    );
  // itree = 1384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433653,-0.00479809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408404,0.0260006) , 
1, 1.2714, 1, 0, 0.430229,-0.00203457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.832042,0.0341843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763175,0.000279517) , 
1, -0.251573, 1, 0, 0.793214,0.0280333) , 
2, 0.661632, 1, 0, 0.530085,0.00623696)    );
  // itree = 1385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210358,0.0143191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32444,0.0437821) , 
1, 0.748644, 1, 0, 0.261936,0.0507674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46362,-0.0037013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576015,-0.0225047) , 
0, 0.135429, 1, 0, 0.522843,-0.0262421) , 
2, -1.32176, 1, 0, 0.497897,-0.0188788)    );
  // itree = 1386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.758949,0.0314262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491906,-0.0045377) , 
1, -1.36845, 1, 0, 0.520371,-0.00194502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55979,0.0550611) , 
1, 1.71996, 1, 0, 0.522276,0.00317941)    );
  // itree = 1387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320132,0.0145598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589565,-0.00628492) , 
0, -1.22798, 1, 0, 0.52742,-0.0040748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.669438,0.0643029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395832,-0.0279444) , 
1, 1.89311, 1, 0, 0.583485,0.0640468) , 
1, 1.28903, 1, 0, 0.533539,0.00336104)    );
  // itree = 1388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216245,-0.0659878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0811349,-0.0249813) , 
1, -0.641921, 1, 0, 0.129791,-0.0667389) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427061,0.0303696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516897,-0.00541746) , 
0, -1.35877, 1, 0, 0.504566,-0.00233092) , 
0, -2.73687, 1, 0, 0.476595,-0.00713798)    );
  // itree = 1389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1112,-0.0204593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467403,0.0145093) , 
3, -1.08317, 1, 0, 0.341621,0.0134704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488814,-0.0254243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.900691,0.0114125) , 
3, 1.28424, 1, 0, 0.625913,-0.0331984) , 
2, 0.0876493, 1, 0, 0.491802,-0.0111829)    );
  // itree = 1390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.661411,0.06957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86878,0.000390692) , 
0, 0.540824, 1, 0, 0.758567,0.0717031) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562673,-0.0395846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469574,-0.00292806) , 
1, -1.27884, 1, 0, 0.474944,-0.0111104) , 
1, -1.55016, 1, 0, 0.490613,-0.00653547)    );
  // itree = 1391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121305,-0.033761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921289,0.000913745) , 
1, -0.365486, 1, 0, 0.104195,-0.0281901) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.680122,0.0182686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602603,-0.00344399) , 
0, 0.00462961, 1, 0, 0.624889,0.00627907) , 
3, -0.689919, 1, 0, 0.488663,-0.00273895)    );
  // itree = 1392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162411,-0.0187332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555531,0.0102978) , 
2, -1.26009, 1, 0, 0.506292,0.0117356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224859,-0.0269161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861643,0.0178373) , 
3, 1.18677, 1, 0, 0.361149,-0.0423478) , 
1, 1.2714, 1, 0, 0.487682,0.00480121)    );
  // itree = 1393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105306,-0.0403303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227718,0.00327235) , 
1, 0.993633, 1, 0, 0.136114,-0.0479214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606367,-0.0212897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.532156,0.00558489) , 
1, -1.34471, 1, 0, 0.540946,0.00508867) , 
2, -1.3039, 1, 0, 0.484599,-0.00228959)    );
  // itree = 1394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41744,-0.0630326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538243,-0.0240121) , 
1, -2.10283, 1, 0, 0.476904,-0.110964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194749,-0.0162731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579001,0.00601199) , 
0, -1.6198, 1, 0, 0.485325,0.0024377) , 
1, -1.72004, 1, 0, 0.484851,-0.00395419)    );
  // itree = 1395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.668093,0.0534873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.845897,-0.000287486) , 
0, -0.251912, 1, 0, 0.770212,0.0548392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478412,-0.0457149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498435,-0.000746891) , 
1, -1.11182, 1, 0, 0.497219,-0.0059947) , 
1, -1.33919, 1, 0, 0.520743,-0.000752643)    );
  // itree = 1396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420679,-0.0499507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461173,-0.00889398) , 
1, -1.66253, 1, 0, 0.457877,-0.0276772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202324,-0.0160392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611584,0.0319089) , 
0, -1.36258, 1, 0, 0.529625,0.0410226) , 
1, 0.387754, 1, 0, 0.481565,-0.00499622)    );
  // itree = 1397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56778,-0.0153676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501476,0.00960784) , 
1, -1.14397, 1, 0, 0.51806,0.00617998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308536,0.00202682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62018,-0.0316866) , 
2, -0.0521597, 1, 0, 0.466072,-0.0309366) , 
1, 0.120658, 1, 0, 0.492637,-0.011971)    );
  // itree = 1398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236865,-0.00139891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2073,-0.0280096) , 
0, -1.05814, 1, 0, 0.224548,-0.027332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584045,0.0331776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759282,-0.000582847) , 
3, 0.28742, 1, 0, 0.709462,0.0192441) , 
2, -0.359466, 1, 0, 0.499338,-0.000938329)    );
  // itree = 1399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196596,0.0622879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182288,-0.00391621) , 
2, -0.808791, 1, 0, 0.192418,0.0479647) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204316,-0.0460951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66564,0.0036365) , 
2, -0.812271, 1, 0, 0.631423,-0.00209301) , 
3, -0.774089, 1, 0, 0.52793,0.0097078)    );
  // itree = 1400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623033,0.0181224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436768,-0.00881293) , 
1, -1.17388, 1, 0, 0.457986,-0.0118995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603106,0.0442779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73902,0.00257662) , 
2, 0.842287, 1, 0, 0.692763,0.0383975) , 
0, 1.92994, 1, 0, 0.484933,-0.00612653)    );
  // itree = 1401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365977,-0.00781369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59953,0.0223131) , 
2, 0.349061, 1, 0, 0.404286,-0.00538585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.691249,-0.00872544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750262,-0.0378154) , 
2, 1.25495, 1, 0, 0.710832,-0.0362678) , 
2, 0.611988, 1, 0, 0.48846,-0.0138656)    );
  // itree = 1402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156315,-0.0071197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551505,0.0274657) , 
3, -0.771644, 1, 0, 0.349119,0.0240972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642815,-0.0216412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728823,0.00516179) , 
0, 0.614669, 1, 0, 0.694177,-0.0139246) , 
2, -0.0811742, 1, 0, 0.538103,0.00327311)    );
  // itree = 1403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289227,-0.0101615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0667442) , 
3, -0.0800229, 1, 0, 0.392409,-0.00945212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424834,0.0352455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8271,-0.000782339) , 
3, 0.632478, 1, 0, 0.668087,0.0284614) , 
0, -0.316111, 1, 0, 0.545161,0.0115555)    );
  // itree = 1404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201492,0.168412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531123,-0.00259849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412028,-0.0232733) , 
1, 1.2714, 1, 0, 0.516867,-0.00998346) , 
2, -1.99845, 1, 0, 0.507503,-0.00589802)    );
  // itree = 1405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168349,0.0698382) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159039,-0.031943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524175,0.00193296) , 
0, -2.10724, 1, 0, 0.484606,-0.00179754) , 
2, -1.97084, 1, 0, 0.473577,0.000839831)    );
  // itree = 1406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317768,-0.00695816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652255,-0.0242851) , 
3, 0.385404, 1, 0, 0.379866,-0.019432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632573,0.0226339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.740309,0.00220925) , 
2, 0.800136, 1, 0, 0.704576,0.0173552) , 
2, 0.462259, 1, 0, 0.492309,-0.00669309)    );
  // itree = 1407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408323,-0.0200235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698283,0.000168769) , 
0, 0.331426, 1, 0, 0.52621,-0.0234842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388643,0.0182808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809545,-0.0224451) , 
3, 0.866668, 1, 0, 0.522058,0.0110945) , 
1, 0.692626, 1, 0, 0.525193,-0.0150208)    );
  // itree = 1408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202948,-0.00342067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0978319,-0.0333041) , 
1, 0.699971, 1, 0, 0.159976,-0.0251794) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608657,0.0387546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599268,-0.000627413) , 
0, -0.753882, 1, 0, 0.600922,0.0124218) , 
2, -0.792904, 1, 0, 0.477666,0.00191123)    );
  // itree = 1409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697674,0.00851501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590705,0.0470901) , 
1, -1.24985, 1, 0, 0.673751,0.032511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352585,-0.028193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924006,0.0138372) , 
3, 1.78981, 1, 0, 0.411537,-0.0479797) , 
1, -1.07672, 1, 0, 0.45078,-0.0359336)    );
  // itree = 1410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251312,0.0056239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378608,0.0735437) , 
1, -0.125285, 1, 0, 0.319416,0.0689457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593778,-0.0137322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508366,0.0080869) , 
1, -0.743609, 1, 0, 0.529851,0.0056976) , 
0, -2.03899, 1, 0, 0.504018,0.013462)    );
  // itree = 1411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361632,0.00136712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384043,-0.0406212) , 
0, -0.662982, 1, 0, 0.365978,-0.0141137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.687645,0.0228811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507643,-0.0145448) , 
1, 0.986505, 1, 0, 0.649172,0.0285557) , 
0, -0.316111, 1, 0, 0.517882,0.00877401)    );
  // itree = 1412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0641874,-0.0508697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200771,-0.00345411) , 
0, -2.12426, 1, 0, 0.120586,-0.0495884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.472837,0.044193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620293,0.00632858) , 
0, -0.938069, 1, 0, 0.59389,0.0259224) , 
2, -1.14361, 1, 0, 0.526786,0.0152165)    );
  // itree = 1413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484806,0.0264633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267841,-0.0099648) , 
1, 0.101928, 1, 0, 0.374313,0.0129772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.834049,0.0672977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78939,-0.0183497) , 
2, 0.133732, 1, 0, 0.793124,-0.0159274) , 
3, 0.661338, 1, 0, 0.522214,0.00276972)    );
  // itree = 1414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0532289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250964,0.0670209) , 
3, -2.18179, 1, 0, 0.176859,0.0593465) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171038,-0.0269357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582567,-0.0021772) , 
3, -0.861018, 1, 0, 0.518871,-0.0126368) , 
3, -1.46046, 1, 0, 0.488971,-0.00634383)    );
  // itree = 1415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0737372,-0.0192424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369466,0.037332) , 
2, -1.71749, 1, 0, 0.262173,0.0472647) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363768,-0.0253659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669665,-0.00288795) , 
2, -0.163551, 1, 0, 0.581378,-0.0227868) , 
2, -0.86672, 1, 0, 0.518505,-0.00898893)    );
  // itree = 1416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214883,0.00833804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62622,0.0448218) , 
3, -0.144461, 1, 0, 0.292756,0.0299505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4807,-0.0226995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886115,0.0188782) , 
3, 1.08712, 1, 0, 0.647092,-0.0169149) , 
2, -0.288777, 1, 0, 0.504036,0.00200606)    );
  // itree = 1417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204801,-0.0215072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551893,0.00505777) , 
0, -1.70406, 1, 0, 0.479816,0.000798279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47205,-0.0763977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809078,-0.00617735) , 
2, 1.47535, 1, 0, 0.702662,-0.0668115) , 
2, 1.34534, 1, 0, 0.500521,-0.00548345)    );
  // itree = 1418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.643072,2.91228e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738174,0.0424345) , 
1, -1.83536, 1, 0, 0.690383,0.0352491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478718,-0.0165804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453551,0.000462863) , 
1, 0.596165, 1, 0, 0.470519,-0.0233065) , 
1, -1.52249, 1, 0, 0.484167,-0.0196717)    );
  // itree = 1419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0514767,-0.00970248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451131,0.0393382) , 
2, -1.87597, 1, 0, 0.287696,0.0490985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548594,-0.00761968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646417,0.063511) , 
1, 2.09041, 1, 0, 0.551409,-0.0118377) , 
2, -1.13969, 1, 0, 0.515838,-0.00361821)    );
  // itree = 1420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137809,0.00526738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326187,0.0304062) , 
3, -1.05762, 1, 0, 0.200913,0.0253484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569637,-0.0404936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631957,-0.000131071) , 
0, -0.426633, 1, 0, 0.618063,-0.0232179) , 
3, -0.605731, 1, 0, 0.498806,-0.00933347)    );
  // itree = 1421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115469,-0.0651892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273584,0.0238844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535872,-0.00429161) , 
2, -1.00944, 1, 0, 0.49727,-0.00167294) , 
0, -3.19263, 1, 0, 0.484405,-0.00558103)    );
  // itree = 1422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0640853,-0.074747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584404,-0.0157098) , 
2, -1.02858, 1, 0, 0.510403,-0.0597351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39456,0.000171301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.803676,0.0279668) , 
2, 0.916473, 1, 0, 0.471142,0.0110196) , 
1, -0.936379, 1, 0, 0.479142,-0.00339737)    );
  // itree = 1423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493418,-0.0252185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451357,0.0180191) , 
1, -1.17388, 1, 0, 0.456829,0.0229943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392484,-0.0615058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752763,-0.0069181) , 
3, 0.845068, 1, 0, 0.59579,-0.0447254) , 
0, 1.29433, 1, 0, 0.487732,0.00793454)    );
  // itree = 1424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659414,0.049587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29717,-0.0139539) , 
1, -1.40709, 1, 0, 0.315638,-0.0194621) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.667983,0.00302708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754091,0.0203079) , 
0, 0.876496, 1, 0, 0.715672,0.0233001) , 
2, 0.0207206, 1, 0, 0.510793,0.00139922)    );
  // itree = 1425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295043,0.0261106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108856,-0.032367) , 
1, -1.00864, 1, 0, 0.134732,-0.0394366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.705546,0.0116034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574039,-0.0113979) , 
1, 0.843066, 1, 0, 0.673606,0.0103207) , 
3, -0.613987, 1, 0, 0.493731,-0.00628821)    );
  // itree = 1426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343444,0.000213025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618316,-0.0235175) , 
2, 0.114952, 1, 0, 0.385419,-0.00820692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546018,-0.0278441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.882814,-0.00976937) , 
3, 1.50786, 1, 0, 0.666135,-0.0455043) , 
2, 0.391241, 1, 0, 0.490121,-0.0221182)    );
  // itree = 1427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276835,-0.00434124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205904,-0.0291144) , 
2, 0.172305, 1, 0, 0.266052,-0.0160186) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.74754,0.0307519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726832,-0.0122137) , 
2, 1.15915, 1, 0, 0.742311,0.0343951) , 
3, 0.163853, 1, 0, 0.499232,0.00866435)    );
  // itree = 1428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152284,-0.00348656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485688,0.035284) , 
2, -0.883385, 1, 0, 0.269766,0.0238531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359546,-0.0273087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744777,0.00541511) , 
3, 0.311482, 1, 0, 0.610015,-0.0132317) , 
2, -0.420818, 1, 0, 0.490419,-0.000196587)    );
  // itree = 1429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0897226,0.00140945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236094,-0.0456216) , 
2, -1.61485, 1, 0, 0.164522,-0.0551909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512519,0.00336488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727112,-0.0223527) , 
0, 2.27963, 1, 0, 0.530496,0.00215356) , 
0, -2.54258, 1, 0, 0.496931,-0.00310575)    );
  // itree = 1430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.754454,0.0576486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259347,0.00603137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562279,-0.00984133) , 
2, -0.471788, 1, 0, 0.467467,-0.0110882) , 
1, -2.00512, 1, 0, 0.476475,-0.00640112)    );
  // itree = 1431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551791,-0.00477266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66652,0.0408535) , 
1, -0.321628, 1, 0, 0.582251,0.0112893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292276,-0.0249537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706792,0.0033057) , 
2, 0.229054, 1, 0, 0.445025,-0.0353004) , 
1, 0.102755, 1, 0, 0.516207,-0.0111334)    );
  // itree = 1432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4191,-0.00295326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459274,0.0317854) , 
1, 0.866836, 1, 0, 0.426846,0.00702506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159961,-0.0480091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769937,0.000643011) , 
3, 0.608826, 1, 0, 0.613389,-0.0252878) , 
0, 0.321785, 1, 0, 0.505773,-0.00664669)    );
  // itree = 1433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105991,-0.00193925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0709507,-0.0460071) , 
2, -0.821199, 1, 0, 0.0972577,-0.0231321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519253,0.0144634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874965,-0.00693507) , 
3, 1.17962, 1, 0, 0.608161,0.0205145) , 
3, -0.98855, 1, 0, 0.497052,0.0110225)    );
  // itree = 1434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177784,-0.00479934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660709,0.01297) , 
3, -0.63769, 1, 0, 0.535433,0.0174014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294865,-0.0285738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269038,-0.0530268) , 
1, 2.50026, 1, 0, 0.285337,-0.0966031) , 
1, 1.73495, 1, 0, 0.514642,0.00792383)    );
  // itree = 1435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0221288,-0.0618585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291863,0.00885002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557657,-0.00797647) , 
2, -0.698978, 1, 0, 0.499798,-0.00909972) , 
2, -1.97084, 1, 0, 0.477985,-0.0119784)    );
  // itree = 1436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577129,-0.0121362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562919,0.0337457) , 
1, -0.618404, 1, 0, 0.573076,0.00341978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2175,0.0300178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411221,-0.0258082) , 
0, -2.09317, 1, 0, 0.387913,-0.0417878) , 
1, -0.227901, 1, 0, 0.459002,-0.0244316)    );
  // itree = 1437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0445606,-0.0509703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38551,0.0203318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562299,8.18643e-05) , 
0, -0.811048, 1, 0, 0.511865,0.0100313) , 
2, -1.86224, 1, 0, 0.491257,0.00645375)    );
  // itree = 1438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0599955,0.0334514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169689,-0.0217898) , 
3, -1.81492, 1, 0, 0.146411,-0.0265753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650726,0.071824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631209,0.00337568) , 
2, -0.662701, 1, 0, 0.632803,0.0149078) , 
3, -0.680259, 1, 0, 0.492005,0.0028995)    );
  // itree = 1439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0689668,0.00631675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543298,0.0874778) , 
3, -1.58862, 1, 0, 0.253135,0.0577044) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529489,0.00675626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724946,-0.0362461) , 
0, 2.96767, 1, 0, 0.535311,0.00968747) , 
0, -2.09317, 1, 0, 0.501815,0.0153874)    );
  // itree = 1440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.590216,0.0137862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769414,0.0639671) , 
1, -0.489379, 1, 0, 0.62589,0.0450288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296931,0.0135309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561855,-0.0124748) , 
2, -0.413584, 1, 0, 0.461407,-0.00594677) , 
1, -0.227901, 1, 0, 0.529071,0.0150232)    );
  // itree = 1441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276895,-0.00780461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724405,0.0160558) , 
3, 0.0766564, 1, 0, 0.439116,-0.00141466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.640513,-0.0218408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.918978,0.0175466) , 
3, 2.22505, 1, 0, 0.675087,-0.0363235) , 
2, 0.566067, 1, 0, 0.513495,-0.0124181)    );
  // itree = 1442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.571852,-0.0362317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551421,0.00562551) , 
1, -1.66201, 1, 0, 0.553033,0.00266174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326986,-0.0876463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449447,-0.00763141) , 
1, 0.90505, 1, 0, 0.432597,-0.0388508) , 
1, 0.747193, 1, 0, 0.51738,-0.00962746)    );
  // itree = 1443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575351,-0.00359546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505451,-0.0178747) , 
1, -0.632693, 1, 0, 0.538016,-0.0246222) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0706784,-0.0314167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602985,0.0236567) , 
3, -0.962706, 1, 0, 0.48893,0.0306785) , 
1, 0.187999, 1, 0, 0.514883,0.00143988)    );
  // itree = 1444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353703,-0.0554112) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654575,0.0571871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467308,-0.00699505) , 
1, -1.55864, 1, 0, 0.474872,-0.00948775) , 
1, -2.05689, 1, 0, 0.471816,-0.0129426)    );
  // itree = 1445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451798,0.0193014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632615,-0.00360752) , 
0, 0.484031, 1, 0, 0.52733,0.0186661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280066,0.0186665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33658,-0.0406975) , 
0, -2.04973, 1, 0, 0.327616,-0.0714488) , 
1, 1.12536, 1, 0, 0.492075,0.00275829)    );
  // itree = 1446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473418,-0.047635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497691,-0.0045035) , 
1, -2.13034, 1, 0, 0.496798,-0.0118799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306159,0.0487256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745829,0.00308789) , 
3, 0.488375, 1, 0, 0.483513,0.0547871) , 
1, 1.47392, 1, 0, 0.495503,-0.0053801)    );
  // itree = 1447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275087,-0.00448227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620129,0.0237701) , 
2, -0.307339, 1, 0, 0.441022,0.0157589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537586,-0.0359717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8924,0.00399586) , 
3, 1.47485, 1, 0, 0.752345,-0.0340995) , 
2, 0.863656, 1, 0, 0.505659,0.00540716)    );
  // itree = 1448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0542372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55828,0.0857788) , 
3, -2.30337, 1, 0, 0.323231,0.0774169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146188,-0.0241118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68088,0.00628622) , 
3, -0.518554, 1, 0, 0.519674,-0.00436833) , 
0, -2.84999, 1, 0, 0.507958,0.000509302)    );
  // itree = 1449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255654,0.00366359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477761,-0.0175509) , 
2, -0.652029, 1, 0, 0.394202,-0.0219098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.806884,0.0387751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7754,0.000718955) , 
2, 1.01472, 1, 0, 0.787867,0.0306939) , 
2, 0.629493, 1, 0, 0.50117,-0.00761607)    );
  // itree = 1450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316009,-0.00401182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310553,0.0408324) , 
1, 0.417955, 1, 0, 0.314053,0.0230883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544028,-0.0259955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652071,0.000510964) , 
0, -0.463454, 1, 0, 0.632516,-0.00735585) , 
2, -0.288777, 1, 0, 0.515033,0.0038752)    );
  // itree = 1451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969339,0.0040302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258655,-0.0344653) , 
3, -1.14311, 1, 0, 0.200305,-0.0531282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.602583,0.00492387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.955739,0.0412929) , 
3, 2.03518, 1, 0, 0.64031,0.0161274) , 
2, -0.55359, 1, 0, 0.501937,-0.0056521)    );
  // itree = 1452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0530841,-0.0569517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194659,-0.0214142) , 
1, -0.438842, 1, 0, 0.162875,-0.0491084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448577,-0.0284301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622006,0.00215248) , 
0, -0.840915, 1, 0, 0.595712,-0.0056347) , 
2, -0.862357, 1, 0, 0.49152,-0.0160996)    );
  // itree = 1453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332096,-0.0217327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919568,0.0376773) , 
3, 0.333202, 1, 0, 0.557192,-0.0205623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540511,0.0186222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450251,-0.0304243) , 
1, 1.76918, 1, 0, 0.535181,0.0300477) , 
1, -1.37148, 1, 0, 0.537902,0.0237909)    );
  // itree = 1454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235202,-0.0112087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494776,-0.0468836) , 
2, -0.322226, 1, 0, 0.310713,-0.0491985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.665965,0.0150494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613289,-0.0176603) , 
1, 0.560452, 1, 0, 0.647331,0.0096324) , 
0, -0.316111, 1, 0, 0.500674,-0.0159989)    );
  // itree = 1455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195418,-0.0100164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408463,-0.0336953) , 
3, -0.160402, 1, 0, 0.273783,-0.042996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719158,0.0320053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87633,-0.00398078) , 
3, 1.17381, 1, 0, 0.799453,0.024755) , 
3, 0.377562, 1, 0, 0.486305,-0.0156051)    );
  // itree = 1456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.607782,0.0050115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799696,0.0531614) , 
1, -1.5121, 1, 0, 0.716167,0.0595207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156944,-0.0294808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529118,0.00269061) , 
0, -2.20263, 1, 0, 0.4851,-0.00252881) , 
1, -0.936379, 1, 0, 0.522286,0.0074571)    );
  // itree = 1457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530147,-0.0437362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336398,-0.0110562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713871,0.0144079) , 
2, 0.190311, 1, 0, 0.50678,0.000642096) , 
1, -1.72494, 1, 0, 0.50775,-0.00344287)    );
  // itree = 1458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666194,0.0754428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172748,-0.0244332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519636,0.00598258) , 
0, -2.19352, 1, 0, 0.476087,0.00389381) , 
1, -1.68541, 1, 0, 0.482906,0.00893102)    );
  // itree = 1459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149719,0.00717722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500691,0.053203) , 
0, -1.26163, 1, 0, 0.237772,0.037915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483498,-0.0167639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.785406,0.00823317) , 
2, 0.992428, 1, 0, 0.558742,-0.0225358) , 
2, -0.862357, 1, 0, 0.489286,-0.00945454)    );
  // itree = 1460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253557,0.117192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0775149,-0.0147809) , 
1, 0.765759, 1, 0, 0.179456,0.0497875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355134,0.00085057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61861,-0.0146446) , 
2, -0.104588, 1, 0, 0.512039,-0.0161275) , 
2, -1.74543, 1, 0, 0.493244,-0.0124025)    );
  // itree = 1461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494376,0.0215171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761149,-0.0450418) , 
3, 0.458612, 1, 0, 0.600125,-0.000124488) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459898,-0.0501695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453508,-0.0113927) , 
1, -0.256889, 1, 0, 0.454369,-0.0330697) , 
1, -0.480148, 1, 0, 0.499251,-0.022925)    );
  // itree = 1462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201796,-0.0115539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557236,0.010838) , 
2, -0.775731, 1, 0, 0.45247,0.00819129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542,-0.0871254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779873,-0.0282786) , 
1, -0.773125, 1, 0, 0.711947,-0.0810775) , 
2, 1.28337, 1, 0, 0.476687,-0.000140321)    );
  // itree = 1463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183411,-0.0243142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789677,0.0264613) , 
3, -0.81898, 1, 0, 0.608791,0.0197487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146264,0.0107693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511325,-0.0265944) , 
3, -0.516641, 1, 0, 0.419868,-0.0390658) , 
1, -0.480148, 1, 0, 0.478175,-0.0209137)    );
  // itree = 1464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650538,0.00655401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621739,0.0480181) , 
1, -0.698733, 1, 0, 0.638435,0.0426356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544973,-0.0293153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468404,0.00977898) , 
1, 0.0917775, 1, 0, 0.476942,0.00671669) , 
1, -0.107454, 1, 0, 0.545998,0.0220759)    );
  // itree = 1465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0751828,-0.0539449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379296,0.0172879) , 
2, -1.58167, 1, 0, 0.308631,0.0167109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514717,-0.0201873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.894926,0.00735959) , 
3, 1.37029, 1, 0, 0.614364,-0.0316634) , 
2, -0.425618, 1, 0, 0.509809,-0.0151202)    );
  // itree = 1466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0570479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537691,0.0638282) , 
3, -1.58403, 1, 0, 0.215616,0.0355759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24774,-0.0166871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716433,0.000850226) , 
3, -0.0152713, 1, 0, 0.522886,-0.014157) , 
2, -1.3891, 1, 0, 0.493578,-0.00941342)    );
  // itree = 1467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638273,-0.0106209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533567,0.0162387) , 
1, -1.08593, 1, 0, 0.553882,0.0195486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344469,-0.0424172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365729,0.00479527) , 
1, 0.993155, 1, 0, 0.360989,-0.0120904) , 
1, 0.860284, 1, 0, 0.503412,0.0112703)    );
  // itree = 1468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450981,-0.00850859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799996,0.0222128) , 
0, 1.12683, 1, 0, 0.549257,0.00245947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250635,0.0422797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384832,-0.0336172) , 
0, -1.40205, 1, 0, 0.361439,-0.0554163) , 
1, 0.826062, 1, 0, 0.500554,-0.0125484)    );
  // itree = 1469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337148,0.00258659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731133,-0.0304619) , 
3, 0.447122, 1, 0, 0.465247,-0.0137063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655413,-0.0111768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835394,0.0283925) , 
2, 1.09657, 1, 0, 0.766611,0.0330321) , 
0, 2.01604, 1, 0, 0.504359,-0.00764048)    );
  // itree = 1470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340754,-0.0187813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791191,0.00362481) , 
3, 0.644232, 1, 0, 0.499637,-0.022771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366412,0.0337486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780801,-0.0305907) , 
3, 1.27821, 1, 0, 0.449557,0.0413325) , 
1, 0.558033, 1, 0, 0.484321,-0.00316672)    );
  // itree = 1471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205296,-0.0351666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214511,0.0146055) , 
1, 0.593773, 1, 0, 0.208474,-0.0339677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558644,0.0335307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652933,0.00456611) , 
2, -0.0580754, 1, 0, 0.630528,0.0219088) , 
2, -0.55359, 1, 0, 0.499825,0.00460483)    );
  // itree = 1472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279224,0.00157608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701912,0.0651442) , 
2, -0.402134, 1, 0, 0.346946,0.0276228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414989,-0.0222333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816221,0.00901895) , 
3, 0.765373, 1, 0, 0.626184,-0.0126722) , 
2, -0.152114, 1, 0, 0.50864,0.0042898)    );
  // itree = 1473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243581,0.000916126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52691,0.0465384) , 
2, -0.211073, 1, 0, 0.315194,0.0255376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379715,-0.0568715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744801,-2.42179e-05) , 
2, -0.220706, 1, 0, 0.707223,-0.0163271) , 
3, 0.115937, 1, 0, 0.528432,0.00276599)    );
  // itree = 1474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465753,0.0212207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307878,-0.00408488) , 
1, 0.718787, 1, 0, 0.424644,0.0270834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.828162,-0.0225323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.947153,0.0168557) , 
3, 2.16769, 1, 0, 0.862004,-0.0187201) , 
3, 1.21627, 1, 0, 0.50715,0.0184428)    );
  // itree = 1475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.767067,0.0754787) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263123,-0.0101094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587913,0.0105364) , 
0, -1.06967, 1, 0, 0.492726,0.00914963) , 
1, -2.03106, 1, 0, 0.500047,0.012832)    );
  // itree = 1476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24074,0.00554445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696912,-0.0203042) , 
3, -0.0725463, 1, 0, 0.497878,-0.0180097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296652,0.0152058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824907,0.0497951) , 
2, 0.346506, 1, 0, 0.55525,0.0858468) , 
1, 1.71189, 1, 0, 0.501249,-0.0119072)    );
  // itree = 1477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245216,0.0157667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314216,-0.0236049) , 
0, -1.7287, 1, 0, 0.291869,-0.0272774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72243,0.048729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696364,-0.00435468) , 
2, 0.302344, 1, 0, 0.701756,0.0126437) , 
2, -0.0741794, 1, 0, 0.50178,-0.00683302)    );
  // itree = 1478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365146,-0.00208482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443202,-0.0426378) , 
0, -0.32581, 1, 0, 0.386879,-0.0276428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223015,0.0756554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690656,-0.0105001) , 
3, 0.424585, 1, 0, 0.621776,-0.00346487) , 
0, 0.449965, 1, 0, 0.484467,-0.0175981)    );
  // itree = 1479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317453,-0.0105531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688826,0.00595875) , 
2, 0.0164094, 1, 0, 0.517317,-0.00394695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605203,0.0409688) , 
1, 1.8322, 1, 0, 0.52054,-0.00051697)    );
  // itree = 1480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155406,-0.024883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593592,0.010664) , 
0, -2.08949, 1, 0, 0.533683,0.013521) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439726,-0.0245036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482039,0.0338986) , 
1, 1.81349, 1, 0, 0.448677,-0.0338744) , 
1, 0.92669, 1, 0, 0.516947,0.00419011)    );
  // itree = 1481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.093424,-0.0142361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257907,-0.0357837) , 
3, -1.09753, 1, 0, 0.171591,-0.0431926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561172,-0.00994183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581806,0.0136443) , 
1, -0.438016, 1, 0, 0.574218,0.0108773) , 
2, -0.861796, 1, 0, 0.478068,-0.00203496)    );
  // itree = 1482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.714898,0.0631732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.626709,-0.0470803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499518,0.00477729) , 
1, -1.20926, 1, 0, 0.507797,0.00392313) , 
1, -1.69005, 1, 0, 0.517293,0.00738044)    );
  // itree = 1483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246964,-0.0562622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779593,0.00700783) , 
0, -0.488275, 1, 0, 0.493842,-0.0613886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516079,0.0108961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338473,-0.0406871) , 
1, 1.91513, 1, 0, 0.507771,0.0165528) , 
1, -1.52075, 1, 0, 0.506576,0.00986305)    );
  // itree = 1484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0141212,-0.0398757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349453,0.014262) , 
3, -1.51949, 1, 0, 0.288322,0.0211597) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.926636,0.0333266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666209,-0.0194013) , 
1, -1.44973, 1, 0, 0.69545,-0.0293932) , 
3, -0.0295996, 1, 0, 0.52654,-0.00841969)    );
  // itree = 1485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471024,-0.0200658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.974785,0.0455786) , 
3, 2.04209, 1, 0, 0.50005,-0.0342791) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178776,-0.00984125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700742,0.0242839) , 
3, -0.419452, 1, 0, 0.522142,0.024599) , 
1, 0.136163, 1, 0, 0.510065,-0.00758712)    );
  // itree = 1486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16918,-0.00339892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686682,-0.0432346) , 
1, 0.63067, 1, 0, 0.135244,-0.0282057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.624977,0.0108484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674963,-0.0147166) , 
0, 1.10719, 1, 0, 0.641751,0.00548632) , 
3, -0.774089, 1, 0, 0.510738,-0.00322841)    );
  // itree = 1487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.713751,0.0337564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541948,-0.0178225) , 
1, -1.87872, 1, 0, 0.552472,-0.0292221) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512274,0.0365263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474977,0.00675868) , 
1, 0.468133, 1, 0, 0.48514,0.0273766) , 
1, 0.0908079, 1, 0, 0.521177,-0.0029155)    );
  // itree = 1488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165396,-0.00336193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475696,0.0328005) , 
3, -0.844553, 1, 0, 0.293652,0.0254036) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550025,-0.0218867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.879951,0.0140473) , 
3, 1.22486, 1, 0, 0.669207,-0.0254616) , 
3, -0.102499, 1, 0, 0.520548,-0.00532718)    );
  // itree = 1489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0222286,-0.0263187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540715,0.0462402) , 
3, -1.58127, 1, 0, 0.312749,0.0469511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547218,-0.00853588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769348,0.0171639) , 
0, 1.64565, 1, 0, 0.586587,-0.00841283) , 
0, -1.59795, 1, 0, 0.529524,0.00312418)    );
  // itree = 1490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278805,0.00476681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436035,-0.0168973) , 
2, -0.619979, 1, 0, 0.347244,-0.0116277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72711,0.0227946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906814,-0.00626508) , 
3, 1.53063, 1, 0, 0.781391,0.0314693) , 
2, 0.098174, 1, 0, 0.566014,0.0100893)    );
  // itree = 1491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00874048,-0.0312312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366582,0.0411295) , 
3, -1.5385, 1, 0, 0.275036,0.0540875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.723295,-0.00232748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679665,0.0377747) , 
1, 1.41463, 1, 0, 0.719619,0.00205622) , 
3, -0.0426953, 1, 0, 0.514879,0.0260178)    );
  // itree = 1492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0522914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478604,0.0640377) , 
3, -2.23867, 1, 0, 0.26892,0.0744201) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525671,-0.003915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239481,-0.0475062) , 
1, 1.98593, 1, 0, 0.517172,-0.0109322) , 
0, -2.84999, 1, 0, 0.502189,-0.00578085)    );
  // itree = 1493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488871,-0.00659625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862419,0.0250278) , 
0, 2.50878, 1, 0, 0.515995,-0.00758622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183693,-0.0377782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42329,-0.0123683) , 
0, -1.14721, 1, 0, 0.349718,-0.0394475) , 
1, 0.969734, 1, 0, 0.485784,-0.0133752)    );
  // itree = 1494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252317,-0.00588752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47828,-0.029958) , 
3, -0.0969343, 1, 0, 0.325405,-0.0349696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.750767,-0.00881515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76724,0.0194964) , 
1, 0.761006, 1, 0, 0.756246,0.000780399) , 
3, 0.440796, 1, 0, 0.511377,-0.0195382)    );
  // itree = 1495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523796,-0.00099197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516942,-0.0450316) , 
1, -0.0869905, 1, 0, 0.52326,-0.00941228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299381,0.0302943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6825,0.00181087) , 
3, 0.195584, 1, 0, 0.505927,0.025427) , 
1, 0.0567207, 1, 0, 0.514761,0.00767008)    );
  // itree = 1496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134372,-0.0278252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300478,0.0304334) , 
2, -0.200873, 1, 0, 0.157605,-0.0379901) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579828,0.0435145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658585,-0.00851414) , 
3, -0.0613276, 1, 0, 0.64941,-0.00348429) , 
3, -0.291428, 1, 0, 0.467997,-0.0162126)    );
  // itree = 1497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350041,-0.00303534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619064,-0.0342893) , 
2, 0.032252, 1, 0, 0.413922,-0.0247384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674036,0.0224963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842383,-0.0238111) , 
2, 1.66782, 1, 0, 0.690327,0.0338708) , 
0, 0.394028, 1, 0, 0.533217,0.000557092)    );
  // itree = 1498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236587,0.00680351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446459,0.05843) , 
2, -0.56191, 1, 0, 0.268093,0.0247268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.682031,0.0233026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606155,-0.0122317) , 
2, -0.101056, 1, 0, 0.6155,-0.0151002) , 
2, -0.339913, 1, 0, 0.478868,0.000563429)    );
  // itree = 1499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290751,0.0277408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147015,-0.00279707) , 
1, 0.154445, 1, 0, 0.225272,0.0241975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335345,-0.0316269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671735,-0.00393765) , 
3, -0.0686352, 1, 0, 0.620588,-0.0203631) , 
3, -0.316527, 1, 0, 0.492641,-0.00594073)    );
  // itree = 1500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266525,-0.00709361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684227,0.0170099) , 
2, -0.306493, 1, 0, 0.500781,0.0129609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457491,-0.0328559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931327,0.00883923) , 
3, 2.16337, 1, 0, 0.752461,-0.0357183) , 
0, 2.37921, 1, 0, 0.519965,0.00925037)    );
  // itree = 1501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444291,-0.041856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558463,0.00836648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397369,-0.0147252) , 
1, 0.54272, 1, 0, 0.49877,0.000244355) , 
1, -2.02828, 1, 0, 0.497046,-0.00324478)    );
  // itree = 1502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0845944,0.0211736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35556,-0.025886) , 
3, -1.29416, 1, 0, 0.235715,-0.0288265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546607,-2.68188e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637918,0.0292468) , 
1, 1.57509, 1, 0, 0.55199,0.00354681) , 
0, -1.22798, 1, 0, 0.474549,-0.00437989)    );
  // itree = 1503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467758,0.0216387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565358,-0.0434649) , 
0, -0.910985, 1, 0, 0.540027,-0.0615144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191026,-0.0449862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510632,0.00447425) , 
0, -2.08085, 1, 0, 0.468556,-8.59245e-05) , 
1, -0.705165, 1, 0, 0.485725,-0.0148426)    );
  // itree = 1504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542321,-0.0119335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455022,0.0261772) , 
1, -1.22196, 1, 0, 0.465307,0.044294) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.898264,0.00688205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.762597,-0.038874) , 
0, 2.86426, 1, 0, 0.872133,-0.00538754) , 
3, 1.15656, 1, 0, 0.559814,0.0327528)    );
  // itree = 1505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.648988,-0.0749651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274076,-0.00847819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.771228,0.00892618) , 
3, 0.349483, 1, 0, 0.474739,-0.00270764) , 
1, -1.87835, 1, 0, 0.479365,-0.00561529)    );
  // itree = 1506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295073,0.0456851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491714,-0.0250786) , 
2, -0.360841, 1, 0, 0.328566,0.0506963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372674,-0.0320935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651516,-0.000170369) , 
0, 0.244193, 1, 0, 0.529966,-0.0302068) , 
0, -0.998658, 1, 0, 0.471062,-0.00654488)    );
  // itree = 1507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0761395,0.0574033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300689,-0.0326437) , 
3, -1.54427, 1, 0, 0.217155,-0.0414543) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461746,0.0151649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.795257,-0.0111102) , 
3, 0.733952, 1, 0, 0.5951,0.0111373) , 
0, -1.59795, 1, 0, 0.514629,-6.03954e-05)    );
  // itree = 1508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434564,0.0146596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58894,-0.00785775) , 
0, 0.113038, 1, 0, 0.512133,0.00433841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188199,-0.0409236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788975,0.0203287) , 
3, 0.86983, 1, 0, 0.3591,-0.0559445) , 
1, 1.38085, 1, 0, 0.498562,-0.00100736)    );
  // itree = 1509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.721791,0.0133315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433231,-0.0277659) , 
1, -1.32908, 1, 0, 0.472342,-0.0471951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525245,0.0155237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376729,-0.0195945) , 
1, 1.4412, 1, 0, 0.489657,0.0122902) , 
1, 0.400437, 1, 0, 0.47855,-0.0258707)    );
  // itree = 1510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654455,-0.00980989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573305,0.0679694) , 
2, -1.59184, 1, 0, 0.254619,0.0574703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341246,-0.0202655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670366,-0.00232875) , 
2, 0.0292847, 1, 0, 0.530931,-0.0200288) , 
2, -1.21466, 1, 0, 0.494527,-0.00981847)    );
  // itree = 1511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.95747,0.0883051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480531,-0.00600622) , 
1, -2.02988, 1, 0, 0.496268,-0.00610566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54856,0.0681621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701287,0.0126848) , 
2, 0.339797, 1, 0, 0.609967,0.0836843) , 
1, 0.92669, 1, 0, 0.517435,0.0106105)    );
  // itree = 1512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164537,0.00394655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453163,-0.0255531) , 
3, -0.633764, 1, 0, 0.301212,-0.0247775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.677865,0.00238151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8566,0.0250442) , 
2, 1.15591, 1, 0, 0.73098,0.0198729) , 
2, 0.0154847, 1, 0, 0.497789,-0.00435432)    );
  // itree = 1513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523793,-0.0130022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45872,0.00642694) , 
1, -0.111247, 1, 0, 0.489387,-0.00614479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356129,-0.0469215) , 
1, 1.79955, 1, 0, 0.484342,-0.0100422)    );
  // itree = 1514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0414731,0.0220374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0968217,-0.0246008) , 
3, -1.90403, 1, 0, 0.0821956,-0.0247999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586956,0.020536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672308,0.000327558) , 
0, 1.00504, 1, 0, 0.616072,0.0300895) , 
3, -1.08157, 1, 0, 0.525187,0.0207454)    );
  // itree = 1515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466092,-0.00437878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703959,0.0118944) , 
0, 1.29433, 1, 0, 0.517785,-0.000914978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433501,0.0322549) , 
1, 1.60105, 1, 0, 0.513258,0.00215579)    );
  // itree = 1516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0210957,-0.0655238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388899,0.0263107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578199,-0.000161954) , 
0, -1.18915, 1, 0, 0.53544,0.0106846) , 
2, -1.93336, 1, 0, 0.511146,0.00603291)    );
  // itree = 1517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202592,0.00885231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498355,-0.0182853) , 
3, -0.528461, 1, 0, 0.373423,-0.0184806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560704,0.0628834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838038,0.0108625) , 
3, 0.67647, 1, 0, 0.773367,0.0441805) , 
2, 0.426911, 1, 0, 0.516878,0.0039952)    );
  // itree = 1518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121073,0.0286414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188461,-0.026772) , 
3, -1.41975, 1, 0, 0.165074,-0.0246368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.715631,-0.0202061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647491,0.00971061) , 
1, -1.12744, 1, 0, 0.660477,0.00896643) , 
3, -0.516641, 1, 0, 0.493029,-0.00239159)    );
  // itree = 1519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650632,-0.0168479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570273,0.0230383) , 
1, -1.40582, 1, 0, 0.595544,0.0225216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324061,0.0286413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553129,-0.0112002) , 
0, -1.6198, 1, 0, 0.517281,-0.013971) , 
1, -0.480427, 1, 0, 0.539505,-0.00360836)    );
  // itree = 1520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127576,-0.048216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538615,-0.000535105) , 
0, -2.84999, 1, 0, 0.51027,-0.00576179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505888,0.0573683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654739,0.00808473) , 
2, -0.501068, 1, 0, 0.601436,0.0484571) , 
1, 1.14209, 1, 0, 0.523745,0.00225221)    );
  // itree = 1521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547534,0.027304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314362,-0.0284025) , 
3, -1.58127, 1, 0, 0.237891,-0.0388594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527299,0.0260318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583148,-0.00409951) , 
0, -0.431531, 1, 0, 0.570998,0.00385842) , 
0, -1.28819, 1, 0, 0.490308,-0.00648936)    );
  // itree = 1522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192416,-0.0229976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994488,-0.048715) , 
1, 1.30017, 1, 0, 0.178509,-0.0548631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354373,-0.0199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763885,0.0176607) , 
3, 0.0796162, 1, 0, 0.701935,0.0170965) , 
3, -0.142731, 1, 0, 0.490872,-0.0119201)    );
  // itree = 1523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194088,0.0900321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356303,-0.0181564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59769,0.00479431) , 
0, -0.332383, 1, 0, 0.4933,-0.0111051) , 
2, -1.99845, 1, 0, 0.483386,-0.00705598)    );
  // itree = 1524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323789,-0.0371666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.882932,0.0120317) , 
3, 0.287663, 1, 0, 0.553023,-0.0532137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564887,0.0152047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393056,-0.0119002) , 
1, 0.651295, 1, 0, 0.506605,0.0111806) , 
1, -1.37148, 1, 0, 0.511404,0.00452383)    );
  // itree = 1525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.018496,-0.0397577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533257,0.0371769) , 
3, -1.68663, 1, 0, 0.304338,0.0403979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47944,-0.0067593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667592,-0.0278101) , 
0, 2.0535, 1, 0, 0.504392,-0.0190675) , 
0, -1.91158, 1, 0, 0.479575,-0.0116907)    );
  // itree = 1526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378924,-0.0578581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52234,-0.0071055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469888,0.0129337) , 
1, 0.54272, 1, 0, 0.503904,-0.00137092) , 
1, -2.02828, 1, 0, 0.499228,-0.00603641)    );
  // itree = 1527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478461,0.0345443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241522,-0.0209692) , 
1, 0.695891, 1, 0, 0.391443,0.0208585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495659,-0.0630055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67758,0.00185267) , 
0, 0.108555, 1, 0, 0.637414,-0.0279284) , 
2, 0.0556663, 1, 0, 0.514696,-0.00358802)    );
  // itree = 1528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0513307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0420169,-0.0735507) , 
3, -2.11959, 1, 0, 0.0250814,-0.0918468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389459,-0.0379495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581614,0.00603505) , 
1, -1.7331, 1, 0, 0.567409,0.00533415) , 
2, -1.60022, 1, 0, 0.520061,-0.00315023)    );
  // itree = 1529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520127,-0.0015669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571589,0.0418083) , 
1, -0.420785, 1, 0, 0.531688,0.0135743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447893,-0.0216214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461923,0.00106431) , 
1, 0.706621, 1, 0, 0.455232,-0.0211337) , 
1, -0.11574, 1, 0, 0.486501,-0.00693871)    );
  // itree = 1530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167659,0.00794842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631735,0.0332752) , 
3, -0.633764, 1, 0, 0.345136,0.0369163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392357,-0.0290442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778191,0.0063633) , 
3, 0.230169, 1, 0, 0.690207,-0.00746953) , 
2, -0.196531, 1, 0, 0.543377,0.011417)    );
  // itree = 1531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31887,0.00345964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377065,0.034967) , 
1, 1.34351, 1, 0, 0.324211,0.0124308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.782827,-0.00294828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431806,-0.0423099) , 
1, 1.94279, 1, 0, 0.759161,-0.0129826) , 
3, 0.34753, 1, 0, 0.519301,0.00103204)    );
  // itree = 1532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0170414,0.00298969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227007,0.106186) , 
3, -1.92398, 1, 0, 0.116548,0.0435999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21164,-0.0399221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622299,0.00126834) , 
2, -0.57378, 1, 0, 0.530507,-0.0166268) , 
3, -1.26544, 1, 0, 0.484304,-0.00990473)    );
  // itree = 1533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202602,0.0204921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455595,-0.00697131) , 
0, -2.43823, 1, 0, 0.425958,-0.0095261) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647285,0.0455384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886002,-0.00588284) , 
3, 1.24807, 1, 0, 0.804912,0.0346335) , 
2, 0.863656, 1, 0, 0.517421,0.00113206)    );
  // itree = 1534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0531962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397769,0.0612272) , 
3, -2.1755, 1, 0, 0.238098,0.0510593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511553,-0.00216551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424787,-0.0249603) , 
1, 0.961954, 1, 0, 0.494881,-0.0133582) , 
0, -2.33718, 1, 0, 0.474376,-0.0082142)    );
  // itree = 1535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574213,0.0130352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31491,-0.0155604) , 
1, 0.228762, 1, 0, 0.540101,0.0171335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282854,0.0037748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626186,-0.0308065) , 
2, -0.0811742, 1, 0, 0.466027,-0.0258337) , 
1, 0.384935, 1, 0, 0.513923,0.00194892)    );
  // itree = 1536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446985,0.0286465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325765,-0.0142116) , 
1, -1.59845, 1, 0, 0.331465,-0.0220551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529988,0.0468786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741444,-0.00369941) , 
3, 0.356484, 1, 0, 0.70802,0.0151862) , 
2, 0.391241, 1, 0, 0.472427,-0.00811394)    );
  // itree = 1537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527519,-0.00716371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551617,0.0109136) , 
1, 0.364786, 1, 0, 0.535179,-0.00353707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0523091,-0.0794609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536085,-0.00883933) , 
2, -0.7501, 1, 0, 0.335752,-0.092309) , 
1, 1.48646, 1, 0, 0.516096,-0.0120312)    );
  // itree = 1538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12525,-0.0226022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630669,0.0185181) , 
3, -0.910263, 1, 0, 0.484144,0.0155352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0600182,-0.0636259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796213,-0.00138562) , 
3, 0.812613, 1, 0, 0.659171,-0.0252998) , 
0, 1.05495, 1, 0, 0.534708,0.00373832)    );
  // itree = 1539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391047,-0.0557505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464507,-0.00245614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834954,0.0263052) , 
2, 1.01906, 1, 0, 0.527421,0.00452812) , 
1, -1.83103, 1, 0, 0.520338,-0.00104242)    );
  // itree = 1540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512499,0.00452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365432,-0.0152462) , 
1, 0.714858, 1, 0, 0.470631,-0.00249462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622425,0.0597591) , 
1, 1.8528, 1, 0, 0.47463,0.00131979)    );
  // itree = 1541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165952,-0.0303059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714435,0.0266268) , 
2, -0.234302, 1, 0, 0.230224,-0.0445273) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597796,0.00331875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659394,0.065333) , 
1, 1.41463, 1, 0, 0.60252,0.0157621) , 
0, -0.854263, 1, 0, 0.481223,-0.0038806)    );
  // itree = 1542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492446,0.047271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601765,0.00260923) , 
0, -0.854263, 1, 0, 0.570784,0.024766) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488371,-0.0632886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422153,-0.0136666) , 
1, 0.663815, 1, 0, 0.431981,-0.0391627) , 
1, 0.520377, 1, 0, 0.522062,0.00232603)    );
  // itree = 1543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.744811,0.0348719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861371,-0.0239207) , 
3, 1.12068, 1, 0, 0.773647,0.0402385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362014,-0.0409428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493081,0.00756087) , 
1, -0.309669, 1, 0, 0.47137,-0.001738) , 
1, -0.705165, 1, 0, 0.541312,0.00797461)    );
  // itree = 1544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230871,-0.00472094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25995,-0.0392857) , 
2, -0.46257, 1, 0, 0.238455,-0.0289602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521096,0.0508046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716778,0.000477002) , 
3, 0.00174209, 1, 0, 0.685437,0.0188421) , 
2, -0.237487, 1, 0, 0.492482,-0.00179334)    );
  // itree = 1545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102263,-0.000634158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42845,0.0652371) , 
2, -1.68894, 1, 0, 0.198367,0.0446258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343575,-0.0309718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59813,0.00100532) , 
0, -0.999595, 1, 0, 0.548698,-0.0102264) , 
2, -1.3039, 1, 0, 0.509061,-0.00402037)    );
  // itree = 1546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243567,-0.00290221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395846,-0.0407388) , 
2, -0.770795, 1, 0, 0.303077,-0.046579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207042,-0.0376537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639302,0.00502364) , 
2, -0.807539, 1, 0, 0.59157,0.000639638) , 
0, -1.0528, 1, 0, 0.50168,-0.0140729)    );
  // itree = 1547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530971,-0.013408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505221,0.00497967) , 
1, -0.135781, 1, 0, 0.51722,-0.00609923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241423,-0.0625164) , 
1, 1.78879, 1, 0, 0.503336,-0.0123773)    );
  // itree = 1548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304901,0.0159018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153959,-0.0174561) , 
1, -0.88033, 1, 0, 0.180114,-0.0178019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.648298,0.0501334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757813,0.00687232) , 
3, 0.218679, 1, 0, 0.736822,0.0302707) , 
3, -0.231227, 1, 0, 0.502138,0.0100054)    );
  // itree = 1549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610998,0.0396639) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163663,-0.0103826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60401,0.00906879) , 
2, -0.780555, 1, 0, 0.494343,0.0102102) , 
1, -2.04218, 1, 0, 0.498202,0.0130996)    );
  // itree = 1550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0340499,-0.0748815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0262468,-0.0407836) , 
2, -2.0883, 1, 0, 0.0296434,-0.0694365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415563,0.0298781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613767,-0.00661722) , 
2, -0.651143, 1, 0, 0.576876,-0.00146006) , 
2, -1.74543, 1, 0, 0.539894,-0.00605394)    );
  // itree = 1551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211703,-0.0145762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664766,-0.0328897) , 
3, -0.351226, 1, 0, 0.312631,-0.0372298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488814,0.0349638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621584,-0.0124577) , 
2, -0.345397, 1, 0, 0.602766,-0.0115385) , 
0, -0.608449, 1, 0, 0.479676,-0.022438)    );
  // itree = 1552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.827748,0.069357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710766,0.0487022) , 
1, -1.97218, 1, 0, 0.751773,0.10472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612814,0.0101359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442635,-0.00845169) , 
1, -0.607631, 1, 0, 0.478035,-0.00917978) , 
1, -1.48562, 1, 0, 0.497254,-0.00118303)    );
  // itree = 1553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61389,0.0185309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635302,-0.0536399) , 
2, 0.248566, 1, 0, 0.625912,-0.0444553) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233478,-0.0204699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510873,0.00997482) , 
0, -2.38534, 1, 0, 0.484698,0.0145882) , 
1, -1.12224, 1, 0, 0.50456,0.0062834)    );
  // itree = 1554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584784,-0.00607448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59269,0.0473989) , 
3, -1.48475, 1, 0, 0.265247,0.0383552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565099,-0.0186646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488576,0.00698856) , 
1, 0.986505, 1, 0, 0.547452,-0.0268419) , 
0, -1.77233, 1, 0, 0.506274,-0.0173288)    );
  // itree = 1555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309429,-0.00915878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689056,0.00920522) , 
2, -0.142426, 1, 0, 0.511172,0.00126734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742443,-0.0467062) , 
0, 2.97468, 1, 0, 0.51913,-0.00167518)    );
  // itree = 1556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262141,-0.011541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680409,0.00742796) , 
2, -0.471788, 1, 0, 0.543404,0.00305891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195263,-0.0459404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60847,-0.00476658) , 
2, -0.263768, 1, 0, 0.382852,-0.0640476) , 
1, 0.92669, 1, 0, 0.510975,-0.0104958)    );
  // itree = 1557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241447,-0.0294723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717291,0.00430551) , 
3, 0.163853, 1, 0, 0.450309,-0.0262599) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254995,0.00241605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653616,0.0213616) , 
2, -0.443269, 1, 0, 0.511825,0.0292129) , 
1, 0.560452, 1, 0, 0.46748,-0.0107757)    );
  // itree = 1558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439913,-0.0088366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758731,0.0130219) , 
0, 1.20503, 1, 0, 0.518418,-0.0067011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312009,0.0447184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641115,-0.00166823) , 
2, -0.261251, 1, 0, 0.468014,0.0340754) , 
1, 1.07539, 1, 0, 0.509893,0.000195574)    );
  // itree = 1559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23199,-0.00674733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809346,0.0802913) , 
2, -0.335215, 1, 0, 0.380574,0.0271356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604727,-0.0101425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679068,0.0185197) , 
1, 0.843066, 1, 0, 0.621844,-0.00702186) , 
0, -0.331895, 1, 0, 0.522588,0.0070302)    );
  // itree = 1560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582815,0.0239525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458671,-0.0136628) , 
1, -1.27695, 1, 0, 0.473066,-0.0190962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657402,0.062947) , 
1, 1.94792, 1, 0, 0.479,-0.0154978)    );
  // itree = 1561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451466,0.0371798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607209,-0.0120664) , 
0, -0.195817, 1, 0, 0.537875,0.0104017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104049,-0.0460652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610144,-0.00432632) , 
2, -0.581795, 1, 0, 0.398374,-0.0516021) , 
1, 0.213586, 1, 0, 0.472604,-0.018609)    );
  // itree = 1562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355912,-0.00062342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245314,-0.0252132) , 
0, -0.0247421, 1, 0, 0.321907,-0.0176979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.778744,0.0744739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.821739,-0.00128911) , 
3, 0.953137, 1, 0, 0.816338,0.0174537) , 
3, 0.760049, 1, 0, 0.473109,-0.00694818)    );
  // itree = 1563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420852,-0.017948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43516,0.00373109) , 
1, 0.237261, 1, 0, 0.42722,-0.0159749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577818,0.0125888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884755,0.037229) , 
0, 2.44295, 1, 0, 0.669627,0.0391233) , 
0, 1.20503, 1, 0, 0.480854,-0.00378402)    );
  // itree = 1564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324955,0.0304672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376797,-0.0158323) , 
0, -1.44212, 1, 0, 0.361536,-0.0129746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.915352,0.0347234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815394,0.0081993) , 
1, -0.140183, 1, 0, 0.852412,0.0308884) , 
3, 0.77009, 1, 0, 0.508525,0.000159818)    );
  // itree = 1565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449079,-0.0139392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.928696,0.0298506) , 
3, 1.48703, 1, 0, 0.505141,-0.0199846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483806,0.0250085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32558,-0.0254164) , 
1, 1.71689, 1, 0, 0.456605,0.0228248) , 
1, 0.560452, 1, 0, 0.48915,-0.00588059)    );
  // itree = 1566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464175,0.027989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194656,-0.0339429) , 
1, 1.63954, 1, 0, 0.441081,0.0369098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28385,-0.0533441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718502,-0.00903606) , 
2, -0.116031, 1, 0, 0.670029,-0.0237008) , 
0, 0.481734, 1, 0, 0.535556,0.011899)    );
  // itree = 1567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434016,-0.0114841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461739,0.0163757) , 
1, 0.419001, 1, 0, 0.443953,-0.00324174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588993,-0.0474449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786782,-0.00755634) , 
2, 1.2237, 1, 0, 0.690621,-0.054034) , 
2, 0.863656, 1, 0, 0.490717,-0.012871)    );
  // itree = 1568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299138,0.00242338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502417,0.0342921) , 
2, 0.0195374, 1, 0, 0.338801,0.018808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493785,-0.0338302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796476,-0.00279871) , 
3, 0.553635, 1, 0, 0.738614,-0.0185563) , 
3, 0.34753, 1, 0, 0.507347,0.00305663)    );
  // itree = 1569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23797,-0.0109476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289162,-0.0556383) , 
0, -1.67898, 1, 0, 0.253921,-0.0458177) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386671,0.0509924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600537,-0.00480041) , 
2, -0.684032, 1, 0, 0.575393,0.00277627) , 
0, -1.28819, 1, 0, 0.497989,-0.00892422)    );
  // itree = 1570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638582,0.0338829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781298,-0.00908669) , 
0, 1.07096, 1, 0, 0.673744,0.0340134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197743,0.00580348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576908,-0.0160951) , 
3, -0.269441, 1, 0, 0.450541,-0.0195101) , 
1, -0.827015, 1, 0, 0.495037,-0.00884008)    );
  // itree = 1571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448374,0.0187139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280758,-0.010493) , 
1, 0.907319, 1, 0, 0.41179,0.0233418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.797641,-0.0307978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.94275,0.00971871) , 
3, 1.83473, 1, 0, 0.862138,-0.024598) , 
3, 1.20274, 1, 0, 0.503139,0.0136176)    );
  // itree = 1572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106811,0.0931856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324892,-0.0121321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562853,0.000350132) , 
0, -0.846405, 1, 0, 0.491312,-0.00612937) , 
2, -1.98138, 1, 0, 0.481045,-0.00437535)    );
  // itree = 1573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114493,-0.0253052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137536,-0.0490976) , 
2, -1.1176, 1, 0, 0.124961,-0.0671629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201395,-0.0325719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571676,0.00481196) , 
2, -1.14578, 1, 0, 0.542921,0.00330064) , 
0, -2.09317, 1, 0, 0.490618,-0.00551697)    );
  // itree = 1574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545587,0.00607515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602441,0.0685259) , 
1, 0.605147, 1, 0, 0.553607,0.0236444) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430806,-0.0341499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385507,-0.0101834) , 
1, 1.0957, 1, 0, 0.392554,-0.0330194) , 
1, 0.978958, 1, 0, 0.520268,0.0119147)    );
  // itree = 1575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295089,0.0122777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552214,-0.0116703) , 
0, -1.22798, 1, 0, 0.493102,-0.0136326) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245264,0.0140882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528641,0.0555287) , 
1, 1.83599, 1, 0, 0.421987,0.0719887) , 
1, 1.60105, 1, 0, 0.488031,-0.00752723)    );
  // itree = 1576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254017,0.0567355) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195053,-0.0305026) , 
0, -2.90885, 1, 0, 0.207823,-0.0280104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195297,0.0394683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66191,-0.00116372) , 
3, -0.486021, 1, 0, 0.56947,0.00948776) , 
0, -1.79098, 1, 0, 0.509748,0.00329536)    );
  // itree = 1577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432915,0.0390942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18181,-0.0117642) , 
1, 0.604454, 1, 0, 0.32514,0.024379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565289,-0.0147901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579938,0.0149315) , 
1, 1.14, 1, 0, 0.567472,-0.0216346) , 
0, -1.17214, 1, 0, 0.513146,-0.0113193)    );
  // itree = 1578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424217,-0.0148431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780597,0.00606693) , 
2, 0.923149, 1, 0, 0.497463,-0.0194419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0658461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580719,0.0407328) , 
2, -1.48444, 1, 0, 0.464954,0.0446888) , 
1, 1.2589, 1, 0, 0.492887,-0.0104139)    );
  // itree = 1579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432943,0.0155764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763612,-0.0139755) , 
3, 0.661338, 1, 0, 0.546989,0.0111606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20311,0.0267539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412362,-0.0235703) , 
0, -2.19565, 1, 0, 0.391327,-0.0361513) , 
1, 0.718787, 1, 0, 0.502761,-0.00228204)    );
  // itree = 1580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0880098,0.00946352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296496,0.045326) , 
3, -1.46302, 1, 0, 0.196665,0.0460475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203793,-0.0377499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646324,-0.00227974) , 
2, -0.831286, 1, 0, 0.609923,-0.0123748) , 
3, -0.792982, 1, 0, 0.520691,0.000239846)    );
  // itree = 1581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.937341,0.120197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523805,0.0101169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339893,-0.0341823) , 
1, 1.22243, 1, 0, 0.496304,0.00756276) , 
1, -1.64443, 1, 0, 0.512127,0.0142195)    );
  // itree = 1582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579412,-0.00125806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446844,-0.060422) , 
1, -1.90684, 1, 0, 0.493479,-0.0889654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.600216,0.0132846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460057,-0.0138844) , 
1, -0.223072, 1, 0, 0.51047,-0.00819181) , 
1, -1.36363, 1, 0, 0.50901,-0.0151348)    );
  // itree = 1583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437688,0.0335479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626556,-0.0323732) , 
0, -0.974184, 1, 0, 0.575328,-0.0361669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174812,-0.0221283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524298,0.0176197) , 
0, -1.73531, 1, 0, 0.47151,0.0233278) , 
1, -0.80159, 1, 0, 0.493926,0.0104821)    );
  // itree = 1584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4168,0.0326951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174622,-0.0452537) , 
1, -0.619088, 1, 0, 0.238611,-0.0469561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460815,0.0290326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616616,-0.00149413) , 
0, -0.380941, 1, 0, 0.562462,0.0133228) , 
0, -2.19565, 1, 0, 0.523869,0.00613933)    );
  // itree = 1585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35936,-0.0721904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281156,-0.0154093) , 
1, -0.964473, 1, 0, 0.290858,-0.0429656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670889,0.0223377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713843,-0.0139212) , 
0, 1.93896, 1, 0, 0.68037,0.0279692) , 
2, -0.0811742, 1, 0, 0.502166,-0.00448384)    );
  // itree = 1586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0811518,-0.00859354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434953,0.0269593) , 
3, -1.32565, 1, 0, 0.338005,0.0357797) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540002,-0.0170527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885629,0.0124327) , 
3, 1.19097, 1, 0, 0.687638,-0.0104303) , 
2, -0.0506433, 1, 0, 0.523384,0.0112787)    );
  // itree = 1587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0523794,-0.0573618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309883,0.0414443) , 
0, -3.15922, 1, 0, 0.248741,0.0171743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216235,-0.0280928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672971,-0.0021316) , 
3, -0.163497, 1, 0, 0.553686,-0.0181352) , 
0, -1.77233, 1, 0, 0.503409,-0.0123136)    );
  // itree = 1588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325535,-0.0453975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.882335,0.00912298) , 
3, 0.654581, 1, 0, 0.492544,-0.0777444) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41747,0.016181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824767,-0.0161871) , 
3, 1.14645, 1, 0, 0.506616,0.0181523) , 
1, -1.22196, 1, 0, 0.504692,0.00503763)    );
  // itree = 1589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197914,-0.00923935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396652,-0.0303292) , 
3, -0.37469, 1, 0, 0.262177,-0.0354284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.626032,0.0365649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778221,0.00301202) , 
3, 0.536723, 1, 0, 0.737536,0.0248206) , 
3, 0.144431, 1, 0, 0.496145,-0.00577428)    );
  // itree = 1590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.571903,-0.0234488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631587,0.021278) , 
1, -2.06885, 1, 0, 0.625717,0.0281221) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217515,0.0176706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600016,-0.0131122) , 
2, -0.471788, 1, 0, 0.481604,-0.0111471) , 
1, -0.480148, 1, 0, 0.523973,0.000397921)    );
  // itree = 1591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342446,-0.0136414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530067,0.0156485) , 
0, -0.170902, 1, 0, 0.361788,-0.0202843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360706,0.0315226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768562,0.00551028) , 
3, 0.556173, 1, 0, 0.679862,0.0237795) , 
0, 0.206177, 1, 0, 0.495002,-0.00182976)    );
  // itree = 1592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423688,-0.0381388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430483,-0.00956478) , 
1, -1.64443, 1, 0, 0.430101,-0.0228426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416293,0.0324639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869997,0.00599763) , 
3, 1.32702, 1, 0, 0.686171,0.0348971) , 
0, 1.12677, 1, 0, 0.498639,-0.00738847)    );
  // itree = 1593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.758979,0.101404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692357,0.00686498) , 
0, -0.729019, 1, 0, 0.707504,0.0683999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374488,-0.00466076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544665,-0.0254313) , 
0, 0.676813, 1, 0, 0.432265,-0.021256) , 
1, -1.17388, 1, 0, 0.465325,-0.0104871)    );
  // itree = 1594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536822,-0.0262411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496992,-0.000750939) , 
1, -1.5044, 1, 0, 0.502367,-0.00980205) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510095,0.0162318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572624,0.057904) , 
1, 2.12329, 1, 0, 0.515726,0.0376764) , 
1, 0.387754, 1, 0, 0.507272,0.00763021)    );
  // itree = 1595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205369,-0.0109517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365968,-0.0761985) , 
2, -0.249256, 1, 0, 0.233985,-0.0537035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204204,-0.0327387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617123,0.0119371) , 
2, -0.8932, 1, 0, 0.574125,0.0118556) , 
0, -1.0984, 1, 0, 0.486601,-0.00501388)    );
  // itree = 1596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220386,-0.0150367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0629051) , 
3, -0.0336359, 1, 0, 0.311128,-0.0156542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696621,0.0201572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577296,-0.023775) , 
1, 1.32591, 1, 0, 0.6807,0.0274336) , 
0, -0.416978, 1, 0, 0.516412,0.00827962)    );
  // itree = 1597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275332,0.0207883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139932,-0.0457054) , 
1, 1.56855, 1, 0, 0.260504,0.0174002) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368381,-0.0392175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671588,-0.00931449) , 
2, 0.143804, 1, 0, 0.568523,-0.0410236) , 
2, -0.486121, 1, 0, 0.470093,-0.0223539)    );
  // itree = 1598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.768296,0.0378793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473993,-0.00492353) , 
1, -1.84978, 1, 0, 0.484345,-0.00677576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381895,0.0289604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410084,0.0589777) , 
1, 2.12787, 1, 0, 0.394408,0.0722588) , 
1, 1.67764, 1, 0, 0.478578,-0.00170782)    );
  // itree = 1599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140132,-0.0131905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229771,-0.0401317) , 
2, -0.717201, 1, 0, 0.179673,-0.0488126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0656807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669086,-0.00444994) , 
0, -0.787114, 1, 0, 0.690758,-0.00474665) , 
3, -0.206128, 1, 0, 0.484449,-0.0225347)    );
  // itree = 1600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443903,-0.00745963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37321,0.0262963) , 
1, 0.0705562, 1, 0, 0.408489,0.0120485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603267,-0.0262325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846348,-0.000513165) , 
2, 1.34229, 1, 0, 0.667827,-0.0434804) , 
2, 0.516079, 1, 0, 0.492868,-0.00601854)    );
  // itree = 1601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672316,0.0275379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420387,-0.0440027) , 
1, -0.284715, 1, 0, 0.63943,0.0268844) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452064,0.00582108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413012,-0.0186007) , 
1, 0.465008, 1, 0, 0.428168,-0.0167154) , 
1, -0.133281, 1, 0, 0.513277,0.000849168)    );
  // itree = 1602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157517,-0.00261848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307338,0.0480048) , 
0, -1.01636, 1, 0, 0.188858,0.0150479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278726,-0.0280416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698873,-0.00797118) , 
3, 0.09724, 1, 0, 0.572961,-0.0282484) , 
2, -0.780555, 1, 0, 0.47879,-0.0176334)    );
  // itree = 1603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697386,0.0182307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471835,-0.00854594) , 
1, -0.825429, 1, 0, 0.5193,-0.0070376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.661786,0.0668039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473704,-0.007389) , 
1, 1.78801, 1, 0, 0.568546,0.0745902) , 
1, 1.40721, 1, 0, 0.523421,-0.000205863)    );
  // itree = 1604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309873,0.0257624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15259,-0.0291303) , 
1, 1.56855, 1, 0, 0.289019,0.030373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498085,-0.0219755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688268,-0.000262904) , 
2, 0.0910407, 1, 0, 0.647088,-0.012105) , 
2, -0.403065, 1, 0, 0.522582,0.00266529)    );
  // itree = 1605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498138,0.0463139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.936476,0.0340427) , 
3, 0.00395958, 1, 0, 0.715319,0.0690448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42533,-0.00843428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729383,0.0113257) , 
2, 0.955853, 1, 0, 0.480507,-0.00876631) , 
1, -1.67887, 1, 0, 0.493281,-0.00453314)    );
  // itree = 1606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366468,-0.00256582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489795,-0.0267327) , 
0, -0.373288, 1, 0, 0.424957,-0.0294038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.742007,0.0289035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700201,-0.00840867) , 
0, 2.36107, 1, 0, 0.727605,0.0288122) , 
0, 1.12677, 1, 0, 0.502679,-0.0144535)    );
  // itree = 1607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284656,0.024335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368015,-0.0208864) , 
0, -1.73046, 1, 0, 0.338541,-0.0148587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320523,0.0561887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713538,0.00468893) , 
3, 0.00129063, 1, 0, 0.670635,0.0206568) , 
0, -0.331895, 1, 0, 0.518071,0.00434092)    );
  // itree = 1608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183458,0.0100715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244487,-0.0251031) , 
2, -1.36185, 1, 0, 0.223806,-0.0285022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688938,0.0281323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647206,0.00241136) , 
0, 0.071095, 1, 0, 0.659925,0.0194138) , 
2, -0.471788, 1, 0, 0.513029,0.00327445)    );
  // itree = 1609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275955,0.00515546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606981,0.0289519) , 
2, -0.359492, 1, 0, 0.400886,0.0271802) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45743,-0.0298018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878618,0.00578653) , 
3, 1.24442, 1, 0, 0.650628,-0.0301096) , 
2, 0.417021, 1, 0, 0.494922,0.00560885)    );
  // itree = 1610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23033,-0.00721002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689818,0.00885457) , 
3, -0.206128, 1, 0, 0.511849,0.00553827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373407,-0.0396585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322259,-0.00686795) , 
1, 1.65123, 1, 0, 0.345455,-0.0497432) , 
1, 1.25419, 1, 0, 0.488328,-0.0022762)    );
  // itree = 1611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137135,0.0508544) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0692594,-0.0446338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592698,0.00515487) , 
3, -1.45032, 1, 0, 0.544214,0.00520011) , 
2, -2.01361, 1, 0, 0.528941,0.00731639)    );
  // itree = 1612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364738,-0.0111206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9312,0.0550563) , 
2, 1.01001, 1, 0, 0.389232,-0.0154987) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500957,0.0335923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874208,0.000467041) , 
3, 1.34999, 1, 0, 0.686503,0.0346272) , 
0, 0.749055, 1, 0, 0.484767,0.000610522)    );
  // itree = 1613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190109,-0.0351586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220504,0.0436122) , 
1, 1.17425, 1, 0, 0.19602,-0.0462236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460923,0.0268342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62681,0.00226255) , 
2, -0.289154, 1, 0, 0.588082,0.0153871) , 
2, -1.02978, 1, 0, 0.521582,0.00493692)    );
  // itree = 1614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324899,0.00732911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721686,0.0644675) , 
3, 0.359624, 1, 0, 0.362965,0.0231569) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616468,0.00457955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732414,-0.0147448) , 
2, 1.04601, 1, 0, 0.649938,-0.00198634) , 
2, -0.0811742, 1, 0, 0.51142,0.01015)    );
  // itree = 1615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413037,-0.00184598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257258,-0.0353082) , 
1, 0.403002, 1, 0, 0.339002,-0.031446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618607,-0.0155881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609045,0.0151777) , 
1, -0.919085, 1, 0, 0.611235,0.0140499) , 
0, -0.794061, 1, 0, 0.514175,-0.00217092)    );
  // itree = 1616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147384,-0.0265174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388887,0.0322361) , 
2, -0.959066, 1, 0, 0.240433,0.000889682) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438644,-0.0386357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612673,-0.00489102) , 
0, -0.195858, 1, 0, 0.567177,-0.0277342) , 
2, -0.486121, 1, 0, 0.466596,-0.018923)    );
  // itree = 1617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210168,-0.0162233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731364,0.00398693) , 
3, 0.0218938, 1, 0, 0.434707,-0.0139829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.602046,0.0369871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878473,-0.000889299) , 
3, 1.7377, 1, 0, 0.782646,0.0365929) , 
0, 1.93176, 1, 0, 0.478315,-0.00764407)    );
  // itree = 1618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428792,-0.0192289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282137,0.00201319) , 
1, -0.107454, 1, 0, 0.349503,-0.0146119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.873043,0.018297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744562,-0.0157799) , 
0, 3.24103, 1, 0, 0.861133,0.0232088) , 
3, 0.828289, 1, 0, 0.508425,-0.00286403)    );
  // itree = 1619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0698263,-0.00712527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302264,0.0393452) , 
3, -1.17592, 1, 0, 0.15611,0.022656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209062,-0.0503803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599401,-0.00247775) , 
2, -0.60639, 1, 0, 0.554894,-0.0181097) , 
2, -0.86672, 1, 0, 0.469751,-0.00940597)    );
  // itree = 1620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.609881,-0.0460571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27715,0.0208383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545017,-0.00796987) , 
0, -1.48672, 1, 0, 0.493771,-0.00836715) , 
1, -1.73018, 1, 0, 0.499565,-0.0126352)    );
  // itree = 1621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.694126,0.0194675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4674,-0.00927292) , 
1, -0.993811, 1, 0, 0.508234,-0.0089261) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407224,0.0443297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505213,-0.00452201) , 
0, 0.450762, 1, 0, 0.448948,0.0363505) , 
1, 1.02152, 1, 0, 0.496383,0.000124372)    );
  // itree = 1622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122088,0.0054851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0139449,-0.0622917) , 
0, -2.19571, 1, 0, 0.0716058,-0.0184913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564931,0.0326403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624901,0.0070291) , 
0, -0.153448, 1, 0, 0.600177,0.0338141) , 
3, -1.19711, 1, 0, 0.522601,0.0261375)    );
  // itree = 1623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427177,0.00876007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25167,-0.0125267) , 
1, -0.0940381, 1, 0, 0.316736,-0.00777063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.703055,0.0284836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874991,-0.000865216) , 
3, 1.2894, 1, 0, 0.767314,0.0383402) , 
2, 0.0734536, 1, 0, 0.533392,0.0144013)    );
  // itree = 1624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130547,-0.00371371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353566,0.0956735) , 
2, -0.59491, 1, 0, 0.179294,0.0242657) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372481,-0.0287986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721981,-0.00359419) , 
3, 0.172001, 1, 0, 0.606635,-0.0285788) , 
3, -0.562341, 1, 0, 0.477665,-0.0126305)    );
  // itree = 1625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284356,0.00375413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1084,-0.0305594) , 
0, -0.172179, 1, 0, 0.257001,-0.00550219) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.884471,0.0158703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616858,-0.0317385) , 
1, -1.19986, 1, 0, 0.652047,-0.0523746) , 
3, 0.0391675, 1, 0, 0.464367,-0.0301063)    );
  // itree = 1626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.084529,0.00201193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456764,0.0454509) , 
3, -1.42966, 1, 0, 0.312095,0.0582594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328578,-0.0261009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610221,0.00697519) , 
0, -0.851156, 1, 0, 0.544202,-0.00303487) , 
2, -0.990153, 1, 0, 0.500707,0.00845119)    );
  // itree = 1627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23973,-0.00218936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.900158,0.0296962) , 
3, -0.426037, 1, 0, 0.440297,0.0113045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262806,-0.0236816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.821525,-0.00165616) , 
3, 0.543332, 1, 0, 0.601714,-0.0210921) , 
0, -0.331895, 1, 0, 0.535213,-0.0077453)    );
  // itree = 1628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608617,0.0878637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779774,0.017325) , 
0, 0.0503301, 1, 0, 0.704164,0.08588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485474,-0.0113827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450026,-0.0355637) , 
1, 2.21434, 1, 0, 0.484465,-0.0237274) , 
1, -1.38663, 1, 0, 0.502783,-0.0145886)    );
  // itree = 1629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618712,0.0477857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209447,-0.00412782) , 
1, -0.927804, 1, 0, 0.277473,0.00985194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44196,-0.0348021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834271,-0.00395755) , 
3, 0.60746, 1, 0, 0.713763,-0.031145) , 
3, 0.191234, 1, 0, 0.489256,-0.0100487)    );
  // itree = 1630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465269,-0.0113256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854115,0.0243665) , 
0, 2.82704, 1, 0, 0.488474,-0.0178804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287256,-0.0599865) , 
1, 2.17198, 1, 0, 0.483398,-0.0220017)    );
  // itree = 1631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46454,-0.0170766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494016,0.0196351) , 
1, -1.48631, 1, 0, 0.491547,0.0304119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435172,-0.0200403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.936024,0.0121366) , 
3, 1.88754, 1, 0, 0.632345,-0.0240181) , 
0, 1.38726, 1, 0, 0.522783,0.0183368)    );
  // itree = 1632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202518,-0.0248323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594903,0.00213639) , 
2, -0.711832, 1, 0, 0.504701,-0.00688344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608619,0.0477238) , 
1, 2.0818, 1, 0, 0.507684,-0.00327087)    );
  // itree = 1633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307265,0.0146014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277111,-0.0197404) , 
0, -1.15161, 1, 0, 0.292849,-0.0118417) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.785014,0.0156199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599193,-0.0199627) , 
1, 1.67921, 1, 0, 0.771422,0.0220658) , 
3, 0.27076, 1, 0, 0.504867,0.00318003)    );
  // itree = 1634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.648331,-0.0390967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199955,-0.0222879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54429,0.00902947) , 
2, -1.26809, 1, 0, 0.503689,0.0109214) , 
1, -1.95752, 1, 0, 0.508765,0.00767536)    );
  // itree = 1635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105725,-0.0160503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494127,0.014215) , 
3, -1.07601, 1, 0, 0.370911,0.0159828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453281,-0.075359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673253,0.00117843) , 
0, -0.857953, 1, 0, 0.653961,-0.0150054) , 
2, -0.00680894, 1, 0, 0.511908,0.000546548)    );
  // itree = 1636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729272,-0.0750761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495129,-0.0165035) , 
0, -3.10874, 1, 0, 0.478096,-0.0345516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313154,0.0342388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676797,0.000171056) , 
2, -0.146397, 1, 0, 0.497988,0.0274643) , 
1, 0.560452, 1, 0, 0.48426,-0.0153345)    );
  // itree = 1637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576656,-0.0389144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447908,-0.00295777) , 
1, -0.966217, 1, 0, 0.470937,-0.0183749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307945,-0.0574476) , 
1, 2.10403, 1, 0, 0.465603,-0.0244408)    );
  // itree = 1638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285459,-0.0272683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466465,0.0311178) , 
3, -1.65548, 1, 0, 0.321433,0.0322418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418412,-0.0163132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.890481,0.0122258) , 
3, 1.19862, 1, 0, 0.545155,-0.0202123) , 
0, -1.2943, 1, 0, 0.496503,-0.00880528)    );
  // itree = 1639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303789,-0.0468118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.849885,0.00430038) , 
2, 0.328678, 1, 0, 0.503975,-0.0636122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419003,0.0330398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623108,-0.00720937) , 
0, 0.305096, 1, 0, 0.507263,0.023791) , 
1, -1.13397, 1, 0, 0.50689,0.0138832)    );
  // itree = 1640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963657,0.0119413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330314,-0.028989) , 
2, -1.51776, 1, 0, 0.242138,-0.0332171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468137,0.0111284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76096,-0.00565054) , 
2, 0.814368, 1, 0, 0.550832,0.0118903) , 
0, -1.27708, 1, 0, 0.478497,0.00132056)    );
  // itree = 1641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608718,0.0384666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884156,0.0060887) , 
3, 0.539728, 1, 0, 0.725001,0.0552003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394384,0.00643125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660756,-0.0164037) , 
2, 0.45817, 1, 0, 0.473734,-0.00274962) , 
1, -1.13954, 1, 0, 0.507439,0.00502374)    );
  // itree = 1642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233717,-0.027103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716454,0.0293153) , 
2, -0.943374, 1, 0, 0.636745,0.0389141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196598,-0.0193668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599929,0.00440774) , 
2, -0.55359, 1, 0, 0.439599,-0.006839) , 
1, -0.239672, 1, 0, 0.512805,0.0101505)    );
  // itree = 1643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327345,-0.0131832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597799,-0.0356843) , 
2, 0.290261, 1, 0, 0.369091,-0.0311732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.727882,0.0285651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756796,-0.0311032) , 
2, 1.33803, 1, 0, 0.735789,0.0224686) , 
2, 0.556239, 1, 0, 0.478569,-0.0151583)    );
  // itree = 1644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0466367,-0.0157901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432447,-0.0199044) , 
3, -1.40862, 1, 0, 0.305162,-0.0291913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557712,0.0619016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652729,0.00361406) , 
0, -0.440677, 1, 0, 0.639057,0.019472) , 
0, -0.854263, 1, 0, 0.517975,0.00182494)    );
  // itree = 1645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291094,0.0192298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6648,-0.002481) , 
3, -0.0434464, 1, 0, 0.468267,0.0149369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468621,-0.0355661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.895017,0.00662252) , 
3, 1.37511, 1, 0, 0.713695,-0.0325085) , 
2, 0.887236, 1, 0, 0.521592,0.00462818)    );
  // itree = 1646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426583,0.014949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606571,-0.00569641) , 
2, 0.177506, 1, 0, 0.51983,0.00728506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317964,-0.0246585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846531,0.0179149) , 
2, 0.813013, 1, 0, 0.401536,-0.034567) , 
1, 0.527824, 1, 0, 0.477926,-0.00754056)    );
  // itree = 1647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187622,-0.0258801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73295,0.00943189) , 
3, -0.294659, 1, 0, 0.522974,-0.00731552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458984,0.0324998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700652,-0.0208683) , 
2, 0.641893, 1, 0, 0.515611,0.0289687) , 
1, 0.384935, 1, 0, 0.520178,0.00646299)    );
  // itree = 1648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17205,-0.0166773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678412,0.01515) , 
3, -0.349135, 1, 0, 0.484118,0.00644387) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22062,-0.0635202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464681,-0.00885942) , 
1, 0.565513, 1, 0, 0.434454,-0.0367499) , 
1, 0.387754, 1, 0, 0.466769,-0.00864537)    );
  // itree = 1649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462663,-0.0435854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151142,-0.00851659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674346,0.011433) , 
3, -0.613509, 1, 0, 0.531891,0.0130064) , 
1, -1.99935, 1, 0, 0.528944,0.00877998)    );
  // itree = 1650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157414,-0.00477373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352133,-0.0248384) , 
3, -0.720155, 1, 0, 0.209449,-0.0214014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637725,0.0343951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65869,-0.0157294) , 
2, 0.450462, 1, 0, 0.649473,0.0106551) , 
2, -0.55359, 1, 0, 0.498585,-0.000337269)    );
  // itree = 1651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629815,0.0655958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511494,0.00092017) , 
1, -1.99477, 1, 0, 0.517522,0.00662645) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16902,0.0133385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548115,-0.0371577) , 
3, -0.117632, 1, 0, 0.423848,-0.0517499) , 
1, 0.527824, 1, 0, 0.48615,-0.012924)    );
  // itree = 1652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0310444,-0.0636495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557623,-0.00700222) , 
2, -1.84383, 1, 0, 0.526196,-0.0202842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234481,0.0339106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629587,-0.00327163) , 
3, 0.0436219, 1, 0, 0.439889,0.0200418) , 
1, 0.136163, 1, 0, 0.485585,-0.00130909)    );
  // itree = 1653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229379,-0.0312414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16307,-0.00560595) , 
1, -0.297941, 1, 0, 0.189136,-0.0316017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.699914,0.0352169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728405,4.24959e-05) , 
2, 0.122001, 1, 0, 0.722085,0.0177464) , 
3, -0.0725463, 1, 0, 0.481832,-0.00449969)    );
  // itree = 1654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.831321,0.0754623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185164,0.0128798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604598,-0.0100538) , 
3, -0.605731, 1, 0, 0.485917,-0.0100047) , 
1, -1.67887, 1, 0, 0.50373,-0.00398428)    );
  // itree = 1655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400138,-0.00152331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635514,-0.0383624) , 
2, 0.633231, 1, 0, 0.424474,-0.0112005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.732166,0.0727192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.844672,0.0129032) , 
3, 0.970491, 1, 0, 0.826032,0.0481887) , 
2, 0.923149, 1, 0, 0.498898,-0.000193379)    );
  // itree = 1656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34512,0.00584881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570895,-0.0166443) , 
0, -0.346296, 1, 0, 0.44934,-0.0110049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704865,0.0523986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775425,-0.0376016) , 
2, 1.54775, 1, 0, 0.721974,0.0699707) , 
0, 1.77235, 1, 0, 0.487245,0.00025323)    );
  // itree = 1657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484255,0.00332738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708743,-0.0255238) , 
0, 2.97343, 1, 0, 0.492482,0.00367015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594462,0.0553592) , 
1, 2.14513, 1, 0, 0.495257,0.00606487)    );
  // itree = 1658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365855,0.0288049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182084,-0.00849684) , 
1, 0.713904, 1, 0, 0.310407,0.0289887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373146,-0.0277532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712698,-0.00072538) , 
3, 0.0977981, 1, 0, 0.665489,-0.0124941) , 
3, -0.133228, 1, 0, 0.525446,0.00386654)    );
  // itree = 1659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916986,-0.0182399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338339,0.0345144) , 
2, -1.65831, 1, 0, 0.231566,0.0276419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517363,-0.014831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.890811,0.021729) , 
2, 1.40764, 1, 0, 0.553156,-0.0227809) , 
2, -1.026, 1, 0, 0.503696,-0.0150259)    );
  // itree = 1660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492596,-0.0110346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295297,-0.0527028) , 
1, 0.0441489, 1, 0, 0.466428,-0.0298409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281263,0.0286778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694046,0.00201409) , 
3, 0.0282342, 1, 0, 0.507752,0.0252138) , 
1, 0.213586, 1, 0, 0.484964,-0.00514564)    );
  // itree = 1661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414429,0.0557248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172697,0.0179255) , 
1, -0.619088, 1, 0, 0.230257,0.0408918) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174107,-0.0381927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606662,0.00160855) , 
2, -0.913813, 1, 0, 0.536235,-0.00948378) , 
0, -2.19565, 1, 0, 0.497807,-0.00315706)    );
  // itree = 1662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310613,-0.0102548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117624,-0.0404705) , 
1, 1.40807, 1, 0, 0.280589,-0.0291914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603971,-0.00952048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652232,0.0303825) , 
1, -0.142364, 1, 0, 0.632938,0.0300748) , 
0, -0.213974, 1, 0, 0.466066,0.00200642)    );
  // itree = 1663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307077,-0.0130997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660334,0.0139955) , 
0, -0.794061, 1, 0, 0.528717,0.00807101) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252801,0.0260026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491733,-0.0181412) , 
0, -1.61364, 1, 0, 0.45123,-0.0251199) , 
1, 0.37474, 1, 0, 0.497144,-0.00545315)    );
  // itree = 1664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343958,0.0211793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515353,-0.019116) , 
0, -1.69646, 1, 0, 0.492738,-0.0311279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163555,-0.0303437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563724,0.0170565) , 
0, -1.39441, 1, 0, 0.482553,0.0181252) , 
1, -0.417903, 1, 0, 0.485787,0.00248782)    );
  // itree = 1665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522386,0.00965942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861699,-0.0278149) , 
3, 1.49539, 1, 0, 0.56718,0.0116521) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155432,-0.0347439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745168,-0.00175888) , 
3, 0.492847, 1, 0, 0.382423,-0.045464) , 
1, 0.370917, 1, 0, 0.490858,-0.0119423)    );
  // itree = 1666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15993,0.00788281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501208,-0.0226529) , 
3, -0.841379, 1, 0, 0.314345,-0.0155021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.60381,-0.00423675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661428,0.022211) , 
1, -0.102661, 1, 0, 0.635394,0.0224722) , 
0, -0.416978, 1, 0, 0.492766,0.00560183)    );
  // itree = 1667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543849,-0.0334398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477844,0.00496494) , 
1, -1.20581, 1, 0, 0.487276,4.17001e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254887,-0.0449526) , 
1, 2.09041, 1, 0, 0.478967,-0.00429345)    );
  // itree = 1668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.811452,0.0688545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745597,0.0179588) , 
2, 0.155769, 1, 0, 0.76827,0.065868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712319,-0.0160441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487575,0.0137086) , 
1, -0.880772, 1, 0, 0.509063,0.0181587) , 
1, -1.33134, 1, 0, 0.535942,0.023106)    );
  // itree = 1669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.761115,0.0588706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507496,-0.0126858) , 
1, -1.98408, 1, 0, 0.514875,-0.0198759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377664,-0.0517472) , 
1, 2.10403, 1, 0, 0.510212,-0.0246146)    );
  // itree = 1670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328299,-0.0176436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664655,0.00486605) , 
0, -0.429465, 1, 0, 0.504674,-0.0109632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719168,0.0682124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393908,-0.00634559) , 
1, 1.56466, 1, 0, 0.553094,0.0484162) , 
1, 1.14, 1, 0, 0.511847,-0.00216646)    );
  // itree = 1671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247213,0.0142553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301468,-0.0309937) , 
2, -0.453086, 1, 0, 0.271489,-0.0222986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696774,0.0205832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809731,-0.00817232) , 
3, 0.905236, 1, 0, 0.768326,0.00789031) , 
3, 0.27076, 1, 0, 0.493668,-0.00879853)    );
  // itree = 1672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0643769,-0.0491359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278276,0.0632742) , 
0, -3.0882, 1, 0, 0.205219,0.0317371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283958,-0.0185991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644894,-0.000234677) , 
2, 0.0129057, 1, 0, 0.498795,-0.0136421) , 
0, -2.03717, 1, 0, 0.460959,-0.00779371)    );
  // itree = 1673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368881,-0.0347722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289841,-0.00483322) , 
1, -1.10883, 1, 0, 0.30155,-0.0181608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.675736,0.0285826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.785218,0.00197104) , 
2, 0.64703, 1, 0, 0.740933,0.0255057) , 
2, 0.0876493, 1, 0, 0.509181,0.00247383)    );
  // itree = 1674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0602607,0.0166292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289536,-0.0313866) , 
3, -1.51673, 1, 0, 0.196217,-0.0360846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555255,0.0395213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623925,-0.000529367) , 
0, -1.31734, 1, 0, 0.616448,0.00704064) , 
2, -1.026, 1, 0, 0.542269,-0.00057177)    );
  // itree = 1675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245696,0.0258923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496217,-0.0137255) , 
3, -0.259985, 1, 0, 0.30349,0.019591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390659,-0.037364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714257,0.00258726) , 
2, 0.238205, 1, 0, 0.591996,-0.0263965) , 
2, -0.364227, 1, 0, 0.48351,-0.00910394)    );
  // itree = 1676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307078,0.0194959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543982,-0.00868513) , 
2, -0.284802, 1, 0, 0.41552,0.00951978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603575,-0.0239688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.914388,0.0160935) , 
3, 2.04103, 1, 0, 0.658355,-0.0359727) , 
2, 0.521751, 1, 0, 0.490363,-0.00450127)    );
  // itree = 1677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418761,-0.0508573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43058,0.0145676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559338,-0.000428734) , 
0, -0.0887253, 1, 0, 0.499156,0.0109535) , 
1, -2.23861, 1, 0, 0.496924,0.00672399)    );
  // itree = 1678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245974,-0.0167554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0531911,-0.0738733) , 
1, 1.29041, 1, 0, 0.202749,-0.0582637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637906,0.021037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460896,-0.00521258) , 
1, -0.102661, 1, 0, 0.533629,0.00937363) , 
0, -1.97932, 1, 0, 0.479148,-0.0017631)    );
  // itree = 1679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237371,-0.0216426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658902,0.0201175) , 
2, -0.38727, 1, 0, 0.341156,-0.0206754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401643,0.0286758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.80682,-0.00773868) , 
3, 0.751706, 1, 0, 0.623065,0.0205066) , 
0, -0.297202, 1, 0, 0.505672,0.00335748)    );
  // itree = 1680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392076,0.00310966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613078,-0.0211202) , 
2, 0.451478, 1, 0, 0.439152,-0.00327782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.858209,0.0148787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560318,-0.0301111) , 
1, -0.290342, 1, 0, 0.665107,-0.0331227) , 
0, 1.20503, 1, 0, 0.487389,-0.00964913)    );
  // itree = 1681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141573,-0.0313677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49489,0.0159747) , 
2, -1.46544, 1, 0, 0.440985,0.0203247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238689,-0.0329001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730195,-0.00402082) , 
3, 0.261668, 1, 0, 0.653646,-0.0180178) , 
2, 0.44688, 1, 0, 0.519138,0.00623382)    );
  // itree = 1682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334861,-0.056566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834449,0.010414) , 
0, -0.174401, 1, 0, 0.522586,-0.0830566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155689,0.037023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510656,-0.00961658) , 
3, -1.25675, 1, 0, 0.470812,-0.0124988) , 
1, -1.52075, 1, 0, 0.475022,-0.0182366)    );
  // itree = 1683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228767,0.00978492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148625,-0.0567875) , 
0, -2.87733, 1, 0, 0.184096,-0.0661555) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408436,-0.00827232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728381,0.00930549) , 
2, 0.475385, 1, 0, 0.520189,-0.00317044) , 
0, -2.19565, 1, 0, 0.483274,-0.0100886)    );
  // itree = 1684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301955,0.0119624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523684,-0.0389692) , 
3, 0.209208, 1, 0, 0.372407,-0.0129182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.738914,-0.00176236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.817307,0.0334049) , 
1, -0.480427, 1, 0, 0.782018,0.0377758) , 
2, 0.629493, 1, 0, 0.483729,0.000859169)    );
  // itree = 1685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363059,0.00317039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776375,-0.0225352) , 
3, 0.799532, 1, 0, 0.465274,-0.00525689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.89968,0.059627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820426,0.00163902) , 
2, 1.58492, 1, 0, 0.854889,0.0667905) , 
0, 2.56595, 1, 0, 0.490801,-0.000536526)    );
  // itree = 1686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0422712,-0.00442656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18936,-0.0291262) , 
3, -1.53562, 1, 0, 0.142227,-0.0489668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.868313,0.0490787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595848,0.00380864) , 
1, -1.19986, 1, 0, 0.631249,0.0154319) , 
3, -0.613987, 1, 0, 0.492375,-0.00285626)    );
  // itree = 1687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318568,-0.0328337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542755,-0.0865394) , 
2, 0.248566, 1, 0, 0.446149,-0.110252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0739672,-0.0427042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524468,0.00794309) , 
2, -1.49291, 1, 0, 0.478894,0.00869886) , 
1, -1.73313, 1, 0, 0.476974,0.00172335)    );
  // itree = 1688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453123,0.00679633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22609,-0.0198406) , 
1, 0.560452, 1, 0, 0.375248,-0.00397963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.954591,0.0591196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.914104,0.0061839) , 
3, 1.45147, 1, 0, 0.928019,0.0433518) , 
3, 1.12461, 1, 0, 0.491692,0.00599099)    );
  // itree = 1689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153572,0.149749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565759,0.00188882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545275,0.020848) , 
1, 0.212582, 1, 0, 0.557187,0.0173912) , 
0, -3.3787, 1, 0, 0.545868,0.0197904)    );
  // itree = 1690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550233,0.0186291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726845,-0.0186178) , 
2, 0.955853, 1, 0, 0.594266,0.0158545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224679,-0.0281405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805901,-0.0016691) , 
3, 0.427177, 1, 0, 0.452224,-0.036874) , 
1, 0.423179, 1, 0, 0.539853,-0.00434458)    );
  // itree = 1691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339051,-0.00112458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405912,-0.0220316) , 
0, -0.934475, 1, 0, 0.381928,-0.0310702) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.89997,-0.00279637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842175,0.022412) , 
0, 2.05831, 1, 0, 0.875219,0.0192951) , 
3, 1.15656, 1, 0, 0.471494,-0.0219255)    );
  // itree = 1692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226134,0.0260968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247861,-0.0262681) , 
2, -1.06207, 1, 0, 0.241201,-0.024786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382458,0.0414448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725711,0.00569946) , 
3, -0.0527124, 1, 0, 0.662324,0.0234838) , 
2, -0.403065, 1, 0, 0.510099,0.00603553)    );
  // itree = 1693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32109,0.0170179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440942,-0.0151946) , 
0, -1.13417, 1, 0, 0.392528,-0.0105678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.631868,0.0305225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760926,-0.00360881) , 
2, 1.00818, 1, 0, 0.683382,0.0294285) , 
0, 0.397648, 1, 0, 0.518517,0.00675729)    );
  // itree = 1694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390513,-0.0330009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353955,0.00561639) , 
1, -0.577154, 1, 0, 0.36406,-0.0107964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.602437,0.0435591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65418,0.00459722) , 
0, 0.329871, 1, 0, 0.647122,0.0201932) , 
0, -0.00931381, 1, 0, 0.497395,0.00380112)    );
  // itree = 1695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601557,-0.0410272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285822,0.0166593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614903,-0.00684098) , 
2, -0.29699, 1, 0, 0.485474,0.00179486) , 
1, -1.65097, 1, 0, 0.490436,-0.00238094)    );
  // itree = 1696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536623,0.00188623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832972,0.0376858) , 
0, 0.88052, 1, 0, 0.607131,0.0191741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220117,0.0207775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513534,-0.0199789) , 
0, -1.40853, 1, 0, 0.447102,-0.0256487) , 
1, -0.452168, 1, 0, 0.496967,-0.011682)    );
  // itree = 1697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236783,0.0101319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263435,-0.0513037) , 
2, -0.9393, 1, 0, 0.24862,-0.0622518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444228,0.0694998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546879,0.00156155) , 
2, -1.12164, 1, 0, 0.541194,0.0094617) , 
0, -1.99797, 1, 0, 0.502389,-4.99234e-05)    );
  // itree = 1698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48097,-0.0416591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519027,0.0112155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385849,-0.0308029) , 
1, 2.10323, 1, 0, 0.513745,0.015862) , 
1, -1.78352, 1, 0, 0.512389,0.0111465)    );
  // itree = 1699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197693,-0.0055715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585042,-0.0400635) , 
3, -0.672685, 1, 0, 0.318006,-0.0361386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617298,0.00819944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735468,-0.0238144) , 
0, 2.03601, 1, 0, 0.639309,0.00474916) , 
0, -0.794061, 1, 0, 0.521374,-0.0102589)    );
  // itree = 1700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187776,-0.0132622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672322,0.0030666) , 
3, -0.41788, 1, 0, 0.479572,-0.00501356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396639,-0.0572937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.911983,0.00401209) , 
3, 2.02732, 1, 0, 0.688383,-0.0764889) , 
0, 2.34259, 1, 0, 0.496473,-0.0107986)    );
  // itree = 1701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125682,-0.000587302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152345,-0.0287336) , 
3, -1.0275, 1, 0, 0.137735,-0.0244613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647137,0.0138173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705767,-0.0166508) , 
0, 1.62587, 1, 0, 0.659045,0.0156666) , 
3, -0.580673, 1, 0, 0.496648,0.00316604)    );
  // itree = 1702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16799,-0.00367118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19762,-0.0636917) , 
2, -1.50027, 1, 0, 0.180276,-0.0660376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351195,-0.0124616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614851,0.00969962) , 
0, -1.28182, 1, 0, 0.575335,0.0114599) , 
2, -1.08782, 1, 0, 0.523989,0.00138762)    );
  // itree = 1703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494434,-0.00361529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422251,-0.022455) , 
1, 0.584952, 1, 0, 0.477498,-0.0158237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.705952,0.0856658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411282,-0.0112602) , 
1, 1.87745, 1, 0, 0.554147,0.0579803) , 
1, 1.49685, 1, 0, 0.48189,-0.0115947)    );
  // itree = 1704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138702,-0.0227188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382856,-0.0508813) , 
3, -1.00341, 1, 0, 0.201087,-0.0694302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54819,-0.0036675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756802,-0.0551456) , 
0, 3.45819, 1, 0, 0.554518,-0.00947579) , 
0, -1.72228, 1, 0, 0.490242,-0.0203793)    );
  // itree = 1705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221189,0.00229568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487619,0.041293) , 
2, -0.697421, 1, 0, 0.263202,0.016768) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45184,-0.019637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90485,0.0105722) , 
3, 1.42079, 1, 0, 0.558656,-0.0297173) , 
2, -0.471788, 1, 0, 0.463559,-0.0147552)    );
  // itree = 1706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46638,0.00183647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790785,-0.0278963) , 
2, 1.33879, 1, 0, 0.495088,-0.00167218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159822,-0.0528117) , 
1, 1.78879, 1, 0, 0.476464,-0.00524191)    );
  // itree = 1707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272294,0.0261719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65583,-0.0144197) , 
3, -0.288453, 1, 0, 0.525015,-0.00555574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282461,0.0143963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717123,0.0308865) , 
0, 0.418027, 1, 0, 0.448496,0.034433) , 
1, 0.400437, 1, 0, 0.493356,0.0109895)    );
  // itree = 1708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311873,0.0132325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165562,-0.0278364) , 
1, -0.214065, 1, 0, 0.211665,-0.0278167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.710676,0.0206182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631053,-0.00599248) , 
1, 0.581975, 1, 0, 0.687685,0.0245276) , 
2, -0.471788, 1, 0, 0.503913,0.00431958)    );
  // itree = 1709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.865498,0.0839644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247473,-0.0118223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680628,0.00486662) , 
2, -0.351925, 1, 0, 0.502007,-0.00335445) , 
1, -1.86762, 1, 0, 0.515352,-0.000231495)    );
  // itree = 1710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313313,-0.0367994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349935,-0.00487777) , 
1, -0.894689, 1, 0, 0.340136,-0.0234637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688037,0.0122877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451072,-0.00963045) , 
1, 1.00351, 1, 0, 0.632501,0.014115) , 
0, -0.4832, 1, 0, 0.507389,-0.00196602)    );
  // itree = 1711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249394,-0.03569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270739,0.0119261) , 
1, -0.490382, 1, 0, 0.264128,-0.0077859) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.682786,0.0185271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75855,-0.0139581) , 
2, 1.04682, 1, 0, 0.701375,0.0214265) , 
2, -0.403065, 1, 0, 0.534488,0.0102769)    );
  // itree = 1712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340329,0.00742844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621855,-0.0111593) , 
0, -0.809684, 1, 0, 0.520538,-0.00970487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.849216,0.0430225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.916054,-0.0100543) , 
3, 2.1011, 1, 0, 0.880716,0.0510857) , 
2, 1.50218, 1, 0, 0.541988,-0.00608453)    );
  // itree = 1713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442555,-0.0333883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.970864,0.0266118) , 
0, 0.452539, 1, 0, 0.613857,-0.0413751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461656,0.0107051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634174,-0.022171) , 
0, 1.49809, 1, 0, 0.494332,0.00801323) , 
1, -1.37303, 1, 0, 0.509628,0.00169268)    );
  // itree = 1714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561626,-0.00450986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39661,-0.0295171) , 
1, -0.0991884, 1, 0, 0.509343,-0.0240027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320326,0.0732753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50695,0.00572668) , 
2, -1.24698, 1, 0, 0.482121,0.0186027) , 
1, 0.368059, 1, 0, 0.498832,-0.00755146)    );
  // itree = 1715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452697,-0.0025656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633723,-0.0612106) , 
2, 0.794497, 1, 0, 0.509667,-0.0414199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378481,0.0112344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633686,-0.00787059) , 
0, 0.331426, 1, 0, 0.487502,0.00431666) , 
1, -0.899851, 1, 0, 0.491372,-0.00366902)    );
  // itree = 1716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501732,-0.00242877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271942,-0.0468138) , 
1, 1.0623, 1, 0, 0.485657,-0.0125912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.686554,0.0515573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466613,0.0150144) , 
1, 1.47412, 1, 0, 0.538237,0.0511191) , 
1, 1.26914, 1, 0, 0.491917,-0.00500644)    );
  // itree = 1717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412517,0.00869528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572752,-0.00547101) , 
0, 0.504103, 1, 0, 0.471741,0.00708154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644065,-0.0343299) , 
0, 2.82704, 1, 0, 0.477305,0.0042605)    );
  // itree = 1718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177756,-0.045245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258757,0.0298675) , 
1, 0.736628, 1, 0, 0.196474,-0.0351304) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46689,0.0223965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623055,-0.00207985) , 
0, 0.211203, 1, 0, 0.54849,0.0168941) , 
0, -2.09317, 1, 0, 0.508216,0.010942)    );
  // itree = 1719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432977,-0.00477132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698452,-0.0260139) , 
2, 1.104, 1, 0, 0.467763,-0.0139202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243538,-0.0454567) , 
1, 1.77863, 1, 0, 0.455379,-0.0172793)    );
  // itree = 1720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513205,-0.0435279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412952,-0.008604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705608,0.0135442) , 
0, 1.01926, 1, 0, 0.489192,-0.00409415) , 
1, -1.96276, 1, 0, 0.490082,-0.0078427)    );
  // itree = 1721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118836,-0.00816631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463864,-0.0205507) , 
3, -0.731382, 1, 0, 0.339161,-0.0325475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542163,-0.0107918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814641,0.0236258) , 
2, 0.68151, 1, 0, 0.752609,0.0238142) , 
2, 0.516079, 1, 0, 0.475494,-0.0139624)    );
  // itree = 1722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149856,0.00451153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55552,-0.0193166) , 
3, -1.02193, 1, 0, 0.4811,-0.0324038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157204,-0.0189635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602538,0.0143017) , 
0, -1.45044, 1, 0, 0.484039,0.0166477) , 
1, 1.04098, 1, 0, 0.481572,-0.0245137)    );
  // itree = 1723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196605,-0.010481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514958,0.0413379) , 
0, -1.70121, 1, 0, 0.365042,0.0295038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577624,-0.0601787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615401,0.00564699) , 
0, 0.013589, 1, 0, 0.610599,-0.00918697) , 
0, -0.416978, 1, 0, 0.511476,0.00643128)    );
  // itree = 1724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512786,-0.0139859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486893,0.012341) , 
1, 0.975366, 1, 0, 0.508272,-0.018551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69634,0.0675332) , 
1, 1.96083, 1, 0, 0.515174,-0.0113653)    );
  // itree = 1725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410363,-0.0090866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756435,0.036719) , 
0, 1.79828, 1, 0, 0.439223,-0.00997994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443098,-0.0530914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.916648,0.00516859) , 
3, 1.61943, 1, 0, 0.714514,-0.0548271) , 
2, 1.07544, 1, 0, 0.478568,-0.0163897)    );
  // itree = 1726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365579,-0.0109695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707692,0.0045811) , 
2, 0.415442, 1, 0, 0.475986,-0.0114351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.642357,-0.0420534) , 
0, 2.56595, 1, 0, 0.484385,-0.0153736)    );
  // itree = 1727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381008,-0.00236907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645112,-0.0395889) , 
2, 0.633231, 1, 0, 0.403793,-0.00948295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0900368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802939,0.0111229) , 
0, 1.01143, 1, 0, 0.838733,0.0433451) , 
2, 0.923149, 1, 0, 0.482708,0.000102117)    );
  // itree = 1728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726145,0.0393868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716273,-0.00334282) , 
1, -1.2758, 1, 0, 0.723907,0.0455991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233107,-0.00923917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632185,0.00529724) , 
2, -0.346453, 1, 0, 0.478915,0.000113602) , 
1, -1.17388, 1, 0, 0.512604,0.00636827)    );
  // itree = 1729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520323,0.013795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405368,-0.00248514) , 
1, 0.213586, 1, 0, 0.465752,0.0119793) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.677681,-0.0392634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709519,0.0106105) , 
1, 0.444009, 1, 0, 0.687271,-0.039004) , 
0, 1.05495, 1, 0, 0.521059,-0.00074991)    );
  // itree = 1730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267067,0.00697708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243962,-0.0390138) , 
0, -0.19084, 1, 0, 0.262299,-0.0119013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72497,0.0186927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690253,-0.0104589) , 
0, 2.27059, 1, 0, 0.72013,0.028312) , 
2, -0.351252, 1, 0, 0.547491,0.0131483)    );
  // itree = 1731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404949,-0.00734668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581544,-0.0579372) , 
2, 1.1923, 1, 0, 0.414081,-0.0189566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.831132,0.0339887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615415,-0.0127753) , 
1, 0.681504, 1, 0, 0.767603,0.038916) , 
0, 1.52061, 1, 0, 0.477113,-0.00863807)    );
  // itree = 1732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511047,-0.013648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594665,0.0214787) , 
1, -0.142964, 1, 0, 0.54699,0.000946832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305765,-0.013708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366673,-0.066208) , 
0, 0.698866, 1, 0, 0.324514,-0.0591127) , 
1, 0.969734, 1, 0, 0.498105,-0.0122501)    );
  // itree = 1733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407762,0.0129134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588347,-0.0118898) , 
0, -0.160114, 1, 0, 0.501413,-0.0034303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552604,0.0299233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375617,-0.00521786) , 
1, 1.05483, 1, 0, 0.49371,0.0348231) , 
1, -0.102661, 1, 0, 0.497516,0.0159255)    );
  // itree = 1734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430764,-0.00957997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415897,0.0268549) , 
1, 1.74144, 1, 0, 0.430135,-0.0150091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.785604,-0.0127559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.828759,0.0350749) , 
0, 1.48555, 1, 0, 0.813857,0.0420086) , 
2, 1.33607, 1, 0, 0.458635,-0.0107742)    );
  // itree = 1735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347565,-0.0108392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172896,-0.0413) , 
1, 0.403002, 1, 0, 0.276979,-0.0421614) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0917372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603445,-0.000854728) , 
0, -0.203798, 1, 0, 0.631183,0.0131588) , 
0, -0.574848, 1, 0, 0.489407,-0.00898406)    );
  // itree = 1736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394425,-0.0692402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566383,0.00922652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423821,-0.0115878) , 
1, 0.0264277, 1, 0, 0.486089,-0.00444668) , 
1, -1.64898, 1, 0, 0.480635,-0.010887)    );
  // itree = 1737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491029,0.00184103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.905975,0.0331986) , 
2, 1.4644, 1, 0, 0.515452,0.00679146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374807,0.079577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595197,0.00170286) , 
2, -0.0668243, 1, 0, 0.476747,0.0514502) , 
1, 1.14209, 1, 0, 0.509297,0.0138926)    );
  // itree = 1738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406355,-0.0625186) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34088,-0.0159034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636583,0.00780729) , 
0, -0.331895, 1, 0, 0.517233,-0.00305428) , 
1, -2.17574, 1, 0, 0.513681,-0.00745444)    );
  // itree = 1739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248316,0.0205824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537662,-0.00992398) , 
2, -0.742092, 1, 0, 0.456107,-0.0051321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.786129,0.0316368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692369,0.00302773) , 
1, 0.104868, 1, 0, 0.751834,0.0524904) , 
0, 1.89859, 1, 0, 0.494097,0.00227024)    );
  // itree = 1740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11299,0.0842207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210399,-0.0335056) , 
2, -1.66001, 1, 0, 0.182617,-0.032869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385741,-0.00496065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724147,0.0104816) , 
2, 0.112408, 1, 0, 0.574812,0.00669682) , 
0, -1.7826, 1, 0, 0.501564,-0.000692684)    );
  // itree = 1741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498924,-0.0026544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380592,-0.0265472) , 
1, 0.780558, 1, 0, 0.475036,-0.0137581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596417,0.0762212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430738,-0.0131899) , 
1, 1.72158, 1, 0, 0.513288,0.0598108) , 
1, 1.45294, 1, 0, 0.477874,-0.00830161)    );
  // itree = 1742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258582,-0.00768858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635097,0.024339) , 
2, -0.174801, 1, 0, 0.381133,0.00451784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360125,-0.01976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.867991,0.00395078) , 
3, 1.07009, 1, 0, 0.649433,-0.0144667) , 
0, 0.438571, 1, 0, 0.487465,-0.00300606)    );
  // itree = 1743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161737,-0.0428059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.882796,-0.0115877) , 
3, 0.0450945, 1, 0, 0.515256,-0.0585325) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.716871,0.0439838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471539,0.00421162) , 
1, -0.952061, 1, 0, 0.497131,0.0153081) , 
1, -1.48631, 1, 0, 0.498812,0.008461)    );
  // itree = 1744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194801,-0.00482627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141286,0.0348669) , 
0, -1.65459, 1, 0, 0.172617,0.01419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.682652,-0.0285153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62032,-0.00530871) , 
1, -0.285384, 1, 0, 0.642876,-0.0286601) , 
3, -0.514401, 1, 0, 0.489764,-0.0147086)    );
  // itree = 1745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300269,0.00850949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678801,-0.0170047) , 
3, 0.217284, 1, 0, 0.453369,-0.00355327) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818752,0.0798592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901545,0.014787) , 
3, 1.70522, 1, 0, 0.877039,0.076267) , 
2, 1.43186, 1, 0, 0.488761,0.00311475)    );
  // itree = 1746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818011,0.0549381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537055,0.00287104) , 
1, -1.83046, 1, 0, 0.554849,0.0100718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307822,-0.0172592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658919,0.016728) , 
0, 0.990197, 1, 0, 0.407087,-0.0142658) , 
1, 0.306027, 1, 0, 0.492664,-0.000170527)    );
  // itree = 1747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188376,-0.0396213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0971499,0.00773694) , 
1, -1.2505, 1, 0, 0.107968,-0.0063473) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726826,0.0196776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636115,0.00753994) , 
0, -0.0902484, 1, 0, 0.664195,0.0232495) , 
3, -0.703077, 1, 0, 0.516397,0.0153852)    );
  // itree = 1748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373144,-0.0121206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284844,-0.0288374) , 
1, 1.11729, 1, 0, 0.357252,-0.0296992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443168,0.0333988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.806201,-0.00881788) , 
3, 0.497958, 1, 0, 0.738697,0.0034232) , 
2, 0.385083, 1, 0, 0.491703,-0.0180243)    );
  // itree = 1749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420121,-0.00745199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326828,0.0294223) , 
1, -0.237385, 1, 0, 0.364307,0.023427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606752,-0.0178504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676934,0.00896573) , 
0, 0.932691, 1, 0, 0.644996,-0.00605465) , 
2, 0.0556663, 1, 0, 0.501357,0.00903219)    );
  // itree = 1750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.916657,0.0635504) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389371,0.00453608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719262,-0.0154373) , 
2, 0.494555, 1, 0, 0.498323,-0.00520971) , 
1, -1.73018, 1, 0, 0.513193,-0.00159899)    );
  // itree = 1751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313325,0.0706815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577781,0.0079455) , 
0, -2.86437, 1, 0, 0.558992,0.0191907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41719,-0.00448346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673246,-0.0500241) , 
0, 1.96301, 1, 0, 0.444593,-0.0168857) , 
1, -0.102661, 1, 0, 0.49211,-0.00190088)    );
  // itree = 1752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580434,0.00163039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535222,0.0300701) , 
1, -0.482947, 1, 0, 0.558273,0.0281662) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362266,-0.0207175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.879203,0.0498646) , 
0, 2.24856, 1, 0, 0.414622,-0.0219773) , 
1, 0.383631, 1, 0, 0.505838,0.00986285)    );
  // itree = 1753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0324449,-0.000359598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539065,0.08655) , 
3, -1.59916, 1, 0, 0.239671,0.0491961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221368,-0.0252189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61586,0.0065811) , 
2, -0.596664, 1, 0, 0.51497,-0.00211716) , 
0, -2.19565, 1, 0, 0.486894,0.00311594)    );
  // itree = 1754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308917,0.0206379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559032,-0.00126212) , 
0, -1.69129, 1, 0, 0.517494,0.00255676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819831,0.0321105) , 
0, 2.76087, 1, 0, 0.533097,0.00641145)    );
  // itree = 1755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200984,0.0294264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633895,-0.00590239) , 
3, -0.783748, 1, 0, 0.540805,-0.00173016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57264,0.0629239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374424,-0.00707815) , 
1, 1.21714, 1, 0, 0.422563,0.0269386) , 
1, 1.07539, 1, 0, 0.519612,0.00340821)    );
  // itree = 1756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.740381,0.0442385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.932102,0.0139757) , 
3, 1.16212, 1, 0, 0.799215,0.0485477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301685,-0.018665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548382,-0.00071195) , 
0, -0.0887253, 1, 0, 0.424871,-0.0177496) , 
1, -1.17388, 1, 0, 0.467692,-0.0101659)    );
  // itree = 1757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664921,0.00571975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417352,-0.0271101) , 
1, -0.676777, 1, 0, 0.563436,-0.0169546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477241,0.0133328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266164,-0.0266014) , 
1, 1.72547, 1, 0, 0.461455,0.0185597) , 
1, -0.0789854, 1, 0, 0.506568,0.0028492)    );
  // itree = 1758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194055,-0.0102985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162403,-0.0376304) , 
0, -1.35411, 1, 0, 0.183819,-0.0364938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623741,-0.00714663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589457,0.0125365) , 
1, -0.172132, 1, 0, 0.604498,0.00838719) , 
2, -0.862357, 1, 0, 0.511401,-0.00154507)    );
  // itree = 1759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.657038,0.0179263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465385,-0.0227464) , 
1, 0.0238705, 1, 0, 0.633669,0.0251507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392035,-0.0273467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426716,0.00581943) , 
1, 0.636714, 1, 0, 0.412805,-0.0148207) , 
1, 0.187999, 1, 0, 0.531165,0.00659983)    );
  // itree = 1760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395187,-0.00336493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556314,-0.0208885) , 
0, -0.0225028, 1, 0, 0.478703,-0.0234762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48765,0.0408595) , 
1, 2.06604, 1, 0, 0.47902,-0.0195395)    );
  // itree = 1761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187115,-0.00718044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312283,0.0296783) , 
2, -1.33666, 1, 0, 0.251361,0.0192152) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193752,-0.039697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618106,-0.00118929) , 
3, -0.487083, 1, 0, 0.583482,-0.00921874) , 
2, -0.723662, 1, 0, 0.489526,-0.0011748)    );
  // itree = 1762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469091,-0.0213609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408912,0.0120493) , 
1, -0.527309, 1, 0, 0.42734,0.00330877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267498,-0.0590862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672458,-0.0164957) , 
2, 0.119854, 1, 0, 0.599403,-0.0486173) , 
0, 0.394028, 1, 0, 0.498601,-0.0181969)    );
  // itree = 1763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401361,-0.014286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651491,0.00655954) , 
0, 0.045577, 1, 0, 0.513077,-0.0101971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37195,0.00815337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.837121,0.025482) , 
2, 0.737186, 1, 0, 0.453828,0.0216087) , 
1, 0.560452, 1, 0, 0.493943,7.46681e-05)    );
  // itree = 1764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.743773,0.0520041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339143,-0.0180336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622975,-0.00014545) , 
0, 0.0835435, 1, 0, 0.476261,-0.0177539) , 
1, -2.00305, 1, 0, 0.485072,-0.0133186)    );
  // itree = 1765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0968723,-0.0579215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427677,-0.00571599) , 
2, -1.52643, 1, 0, 0.268323,-0.0363187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421055,0.047269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617444,0.00689873) , 
0, -1.46656, 1, 0, 0.593423,0.0206735) , 
0, -2.44728, 1, 0, 0.56378,0.0154769)    );
  // itree = 1766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435963,0.0111402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7298,-0.0114813) , 
2, 0.398679, 1, 0, 0.549787,0.00272686) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283628,-0.000582716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469731,-0.0241886) , 
0, -0.2167, 1, 0, 0.381066,-0.0249929) , 
1, 0.520377, 1, 0, 0.487992,-0.00742568)    );
  // itree = 1767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294361,-0.00450318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421841,-0.0376775) , 
0, -0.500002, 1, 0, 0.327747,-0.0290606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239853,-0.00563901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.848595,0.0137492) , 
3, 0.771927, 1, 0, 0.662907,0.0137722) , 
0, 0.24447, 1, 0, 0.479809,-0.0096274)    );
  // itree = 1768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416454,-0.0123481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452854,0.00835734) , 
1, -0.515522, 1, 0, 0.442503,0.00414532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.766226,0.00238668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701232,-0.0376457) , 
1, -0.189011, 1, 0, 0.733168,-0.0332796) , 
2, 0.887236, 1, 0, 0.502978,-0.00364129)    );
  // itree = 1769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455437,0.0189901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83267,-0.0191903) , 
3, 1.12461, 1, 0, 0.537347,0.0189085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120286,-0.0573519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507559,-0.0149116) , 
0, -0.67543, 1, 0, 0.313472,-0.067729) , 
1, 1.25419, 1, 0, 0.498533,0.00388793)    );
  // itree = 1770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528774,-0.0061062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549684,0.0256681) , 
1, 0.797551, 1, 0, 0.53235,-0.00213212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191112,-0.0163344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.444962,-0.0382788) , 
2, -0.157806, 1, 0, 0.283549,-0.0452633) , 
1, 1.40721, 1, 0, 0.50558,-0.00677292)    );
  // itree = 1771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153942,-0.0167279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404274,0.0318874) , 
0, -1.99827, 1, 0, 0.305933,0.0253762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523153,-0.0110617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774175,0.0153945) , 
2, 1.01654, 1, 0, 0.589562,-0.00800683) , 
2, -0.411756, 1, 0, 0.506911,0.00172112)    );
  // itree = 1772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403335,-0.040733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465381,-0.00598282) , 
1, -1.52075, 1, 0, 0.460077,-0.0165822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.962915,0.00797525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950576,0.0451204) , 
2, 1.94099, 1, 0, 0.956477,0.0586664) , 
3, 2.30091, 1, 0, 0.488542,-0.0122672)    );
  // itree = 1773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35836,0.00248583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625447,0.0220469) , 
0, -0.199018, 1, 0, 0.482577,0.0221448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.734396,0.0187365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756634,-0.0314502) , 
2, 1.33994, 1, 0, 0.749747,-0.0288215) , 
2, 1.1598, 1, 0, 0.513793,0.0161899)    );
  // itree = 1774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102001,-0.0682181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576729,0.00519414) , 
0, -2.98925, 1, 0, 0.555152,0.00331606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300317,-0.0467548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41203,0.0210476) , 
1, 1.65123, 1, 0, 0.345159,-0.0479665) , 
1, 1.25419, 1, 0, 0.526004,-0.00380216)    );
  // itree = 1775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211405,0.0524933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426901,-0.00595474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.765473,0.0128042) , 
2, 0.70386, 1, 0, 0.520079,-0.00209527) , 
0, -3.10874, 1, 0, 0.509258,0.000653189)    );
  // itree = 1776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.69291,0.0489446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343524,-0.0183083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63737,-0.00168303) , 
0, 0.321785, 1, 0, 0.464178,-0.0215141) , 
1, -1.86762, 1, 0, 0.472403,-0.018119)    );
  // itree = 1777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216717,0.0315553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169891,-0.0319505) , 
0, -1.99505, 1, 0, 0.195671,-0.011199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503306,0.0327062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611659,0.00621267) , 
0, -0.651125, 1, 0, 0.587528,0.0216713) , 
2, -0.936767, 1, 0, 0.507141,0.0149282)    );
  // itree = 1778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485227,0.0413406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711113,0.00148762) , 
2, 0.177506, 1, 0, 0.615011,0.0308541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105461,0.110948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42632,-0.00895928) , 
2, -1.86672, 1, 0, 0.410794,-0.0140509) , 
1, -0.605346, 1, 0, 0.457513,-0.00377784)    );
  // itree = 1779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394505,0.0797004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605377,-0.000551535) , 
2, -1.156, 1, 0, 0.588741,0.00488524) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331103,-0.053695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416189,-0.0137927) , 
1, -0.0413123, 1, 0, 0.407913,-0.0365743) , 
1, -0.214065, 1, 0, 0.475104,-0.0211691)    );
  // itree = 1780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315908,-0.0112023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592201,0.00773617) , 
0, -0.90202, 1, 0, 0.488004,0.00232396) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497883,-0.0448717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.894489,-0.00385785) , 
3, 1.65176, 1, 0, 0.763495,-0.0508658) , 
2, 1.32759, 1, 0, 0.512484,-0.00240248)    );
  // itree = 1781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34442,0.0109798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668819,-0.00517154) , 
2, 0.102157, 1, 0, 0.495898,0.00537102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549675,0.0558067) , 
1, 2.04984, 1, 0, 0.497324,0.00820069)    );
  // itree = 1782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372349,-0.0453909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781448,-0.0140836) , 
2, 0.0767237, 1, 0, 0.595497,-0.0581948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478849,-0.00109592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413303,-0.0275291) , 
1, 1.27831, 1, 0, 0.470278,-0.00893358) , 
1, -1.01826, 1, 0, 0.489687,-0.0165691)    );
  // itree = 1783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.03754,-0.0794055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60152,-0.0200085) , 
2, -1.04852, 1, 0, 0.46037,-0.0931212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350209,0.00343441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790947,-0.0100519) , 
3, 0.79068, 1, 0, 0.474819,-0.000603064) , 
1, -1.52075, 1, 0, 0.473403,-0.00967256)    );
  // itree = 1784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59693,-0.00281028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509065,-0.0257252) , 
1, -0.985905, 1, 0, 0.575106,-0.0141649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558897,0.0307451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448914,0.00515344) , 
1, 0.445128, 1, 0, 0.508127,0.0372962) , 
1, -0.733145, 1, 0, 0.525418,0.0240114)    );
  // itree = 1785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387466,0.022064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583048,-0.0129014) , 
0, -1.4307, 1, 0, 0.547108,-0.0162078) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253472,0.000456887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776811,0.0244888) , 
3, 0.342372, 1, 0, 0.465191,0.0178136) , 
1, 0.213586, 1, 0, 0.508164,-3.38303e-05)    );
  // itree = 1786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163524,0.0080102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40377,-0.0182421) , 
3, -0.648926, 1, 0, 0.24592,-0.00918184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.676665,0.0517001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782572,0.016845) , 
3, 0.298435, 1, 0, 0.759047,0.0486825) , 
3, -0.156071, 1, 0, 0.533077,0.0232003)    );
  // itree = 1787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733978,0.0297444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717499,-0.0311351) , 
0, 1.84824, 1, 0, 0.731463,0.0362022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324037,0.00773166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601685,-0.0120977) , 
2, -0.0811742, 1, 0, 0.468594,-0.00629203) , 
1, -0.751023, 1, 0, 0.52322,0.00253852)    );
  // itree = 1788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228119,-0.0124579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434728,0.0201543) , 
0, -0.42378, 1, 0, 0.269688,-0.00883372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.648857,0.0228655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746684,-0.00181807) , 
2, 0.940171, 1, 0, 0.676722,0.0303452) , 
2, -0.288777, 1, 0, 0.505861,0.0138991)    );
  // itree = 1789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573301,0.00633626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650807,0.0332956) , 
1, -0.654055, 1, 0, 0.600683,0.0325668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179982,-0.0319034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554783,0.00172159) , 
0, -1.28819, 1, 0, 0.447967,-0.00977962) , 
1, -0.274313, 1, 0, 0.50493,0.00601569)    );
  // itree = 1790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514513,0.0311691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799146,-0.0103752) , 
3, 0.391798, 1, 0, 0.646902,0.0204866) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196735,-0.0170053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691253,0.00327792) , 
3, -0.0447319, 1, 0, 0.467561,-0.0112107) , 
1, -0.429674, 1, 0, 0.518363,-0.00223175)    );
  // itree = 1791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396152,-0.00375557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351013,0.0499786) , 
1, 0.154445, 1, 0, 0.374103,0.0343313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217199,-0.0326785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657015,0.00212503) , 
2, -0.684032, 1, 0, 0.605894,-0.0044906) , 
0, -0.968126, 1, 0, 0.541936,0.0062215)    );
  // itree = 1792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0347813,0.00726133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479546,0.0538213) , 
3, -1.47618, 1, 0, 0.304944,0.0671338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551756,0.00740774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676119,-0.00982007) , 
2, 0.456283, 1, 0, 0.614284,-0.00251179) , 
2, -0.653044, 1, 0, 0.537953,0.0146735)    );
  // itree = 1793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377788,-0.00879311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512919,-0.0214549) , 
0, 0.0616139, 1, 0, 0.432115,-0.0286945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.723003,0.00616749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820181,0.0397112) , 
1, 0.862332, 1, 0, 0.738033,0.0244367) , 
2, 1.01906, 1, 0, 0.483297,-0.0198054)    );
  // itree = 1794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470838,-0.0757893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507366,-0.00867786) , 
1, -2.06694, 1, 0, 0.505189,-0.0256635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144719,-0.00755289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650111,0.0203058) , 
2, -0.845098, 1, 0, 0.512828,0.028851) , 
1, -0.133281, 1, 0, 0.50952,0.00524055)    );
  // itree = 1795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475498,-0.0519752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359949,0.00111114) , 
1, -0.894689, 1, 0, 0.380102,-0.0194108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401097,-0.00672561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775876,0.0187241) , 
2, 0.0994792, 1, 0, 0.662166,0.0198923) , 
0, -0.416978, 1, 0, 0.538844,0.00270845)    );
  // itree = 1796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252442,-0.00280624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342395,0.0320286) , 
1, 0.336366, 1, 0, 0.296338,0.0220646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610544,-0.0266422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595314,-0.000390482) , 
1, -0.827015, 1, 0, 0.598693,-0.0135832) , 
2, -0.471788, 1, 0, 0.493895,-0.00122746)    );
  // itree = 1797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493145,-0.0259858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656519,0.0233647) , 
1, -1.69417, 1, 0, 0.616015,0.0223761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444257,-0.00867946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210016,-0.0528736) , 
1, 2.19528, 1, 0, 0.43606,-0.0208969) , 
1, -0.733145, 1, 0, 0.473248,-0.0119545)    );
  // itree = 1798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212547,-0.00467337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222251,-0.0211092) , 
2, -0.824885, 1, 0, 0.217481,-0.0263855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393954,-0.0267904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74794,0.0120019) , 
3, 0.196773, 1, 0, 0.699367,0.0106862) , 
3, -0.0426953, 1, 0, 0.486347,-0.00570154)    );
  // itree = 1799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151256,0.0102817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151874,-0.020451) , 
2, -0.898367, 1, 0, 0.151515,-0.00769647) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601024,0.0615712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708693,0.00789582) , 
3, -0.291351, 1, 0, 0.700958,0.0239848) , 
3, -0.547237, 1, 0, 0.524023,0.0137826)    );
  // itree = 1800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307498,-0.0158676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0660865,-0.0523049) , 
1, 0.283422, 1, 0, 0.197635,-0.0502979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486374,0.033231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589421,-0.00336446) , 
0, -0.439971, 1, 0, 0.564584,0.00833943) , 
0, -1.28819, 1, 0, 0.476976,-0.00566003)    );
  // itree = 1801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514194,-0.00954714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442021,-0.0341345) , 
1, 0.41077, 1, 0, 0.500304,-0.0268082) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411638,0.0423297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553018,-0.00520311) , 
0, -0.0122268, 1, 0, 0.48368,0.0291764) , 
1, 0.814014, 1, 0, 0.49606,-0.0125159)    );
  // itree = 1802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0208637,0.0113413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322929,-0.0384239) , 
3, -1.75499, 1, 0, 0.232106,-0.0492549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339317,0.0198694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695533,-0.00840951) , 
3, 0.0337302, 1, 0, 0.568389,0.0040618) , 
0, -1.86222, 1, 0, 0.514423,-0.00449433)    );
  // itree = 1803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0135171,-0.0291355) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240455,-0.0350283) , 
3, -1.66406, 1, 0, 0.184221,-0.0579055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638132,-0.00888745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615489,0.0114708) , 
1, -0.608449, 1, 0, 0.622638,0.0106968) , 
2, -0.708047, 1, 0, 0.493459,-0.00951682)    );
  // itree = 1804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444165,0.000256368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343369,-0.0231791) , 
1, 0.581975, 1, 0, 0.414554,-0.0127192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902429,0.0164958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.941458,0.0586124) , 
1, 1.22922, 1, 0, 0.907806,0.0384052) , 
3, 1.24934, 1, 0, 0.520965,-0.00168997)    );
  // itree = 1805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478393,-0.0102831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717997,-0.0681359) , 
2, 0.878723, 1, 0, 0.532212,-0.0416356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763268,0.0441663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465515,0.000927132) , 
1, -0.917716, 1, 0, 0.48099,0.00531513) , 
1, -1.17388, 1, 0, 0.487815,-0.000940934)    );
  // itree = 1806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.099933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697402,0.0431873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.532316,0.00509081) , 
1, -1.1349, 1, 0, 0.55224,0.0160665) , 
0, -3.23058, 1, 0, 0.535906,0.012624)    );
  // itree = 1807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254162,-0.0413842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709212,-0.0057652) , 
2, -0.23958, 1, 0, 0.545621,-0.0357565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223757,0.0119784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615644,-0.00849787) , 
3, -0.218528, 1, 0, 0.466214,-0.00234555) , 
1, -0.311684, 1, 0, 0.495478,-0.0146585)    );
  // itree = 1808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200499,0.00729999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782706,0.0634607) , 
2, -0.581651, 1, 0, 0.307355,0.0254688) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.589798,-0.00304341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535566,-0.0193706) , 
1, -0.102661, 1, 0, 0.559668,-0.0258679) , 
0, -1.04422, 1, 0, 0.484527,-0.0105794)    );
  // itree = 1809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227612,0.151502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330615,0.0544176) , 
0, -3.49355, 1, 0, 0.282649,0.11053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441848,0.0114601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831601,-0.0070141) , 
3, 0.895382, 1, 0, 0.559189,0.0116956) , 
0, -2.84999, 1, 0, 0.542938,0.0175036)    );
  // itree = 1810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261678,-0.0158461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656265,0.0704945) , 
0, -1.22159, 1, 0, 0.323583,0.000726013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256292,-0.0334908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766149,-0.00529293) , 
3, 0.572937, 1, 0, 0.500588,-0.0454935) , 
0, -0.854263, 1, 0, 0.443774,-0.0306582)    );
  // itree = 1811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239214,0.00138029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451394,-0.0148945) , 
0, -1.36161, 1, 0, 0.395057,-0.0225355) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.770234,0.0419067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.905311,0.000796812) , 
3, 1.5683, 1, 0, 0.839763,0.0483692) , 
2, 0.863656, 1, 0, 0.487295,-0.00782896)    );
  // itree = 1812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372685,-0.000752448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558603,-0.0176313) , 
2, 0.52544, 1, 0, 0.416591,-0.0119674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.929658,-0.0204893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.933464,0.044288) , 
2, 1.33541, 1, 0, 0.931754,0.0345244) , 
3, 1.63922, 1, 0, 0.481464,-0.0061129)    );
  // itree = 1813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574682,0.000201901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191708,-0.0407174) , 
1, 0.0724491, 1, 0, 0.525824,-0.00867138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1689,-0.0121479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654549,0.0237577) , 
0, -1.40853, 1, 0, 0.519879,0.0321663) , 
1, 0.237261, 1, 0, 0.523284,0.00877671)    );
  // itree = 1814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279821,0.0259388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592029,0.00235764) , 
2, -0.677098, 1, 0, 0.498437,0.0148719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256945,-0.0692294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818423,-0.00744596) , 
3, 1.53209, 1, 0, 0.660547,-0.0606879) , 
0, 1.85673, 1, 0, 0.515519,0.00690972)    );
  // itree = 1815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164555,0.0136195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596729,-0.0135353) , 
3, -0.707817, 1, 0, 0.51183,-0.0195728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450969,0.0508099) , 
1, 1.76787, 1, 0, 0.508791,-0.0142056)    );
  // itree = 1816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200202,-0.018183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639645,0.00570266) , 
2, -0.862357, 1, 0, 0.525933,0.000297614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31003,-0.0428323) , 
1, 1.79955, 1, 0, 0.514074,-0.00508824)    );
  // itree = 1817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190618,-0.0295782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399184,0.0135726) , 
0, -2.29977, 1, 0, 0.364226,0.0114811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482372,-0.0320129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73469,0.00874952) , 
2, 0.517826, 1, 0, 0.626986,-0.0179877) , 
2, -0.0505193, 1, 0, 0.504672,-0.00427006)    );
  // itree = 1818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168082,0.0665808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221396,-0.0202543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656979,0.00257277) , 
3, -0.13916, 1, 0, 0.484293,-0.0131242) , 
0, -3.14597, 1, 0, 0.473052,-0.0100021)    );
  // itree = 1819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18087,0.00207218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278707,0.031786) , 
2, -0.754384, 1, 0, 0.21681,0.0215962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306784,-0.0355259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700886,0.000646288) , 
3, -0.0613276, 1, 0, 0.640579,-0.0148642) , 
3, -0.291428, 1, 0, 0.498777,-0.00266374)    );
  // itree = 1820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200578,-0.0379618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.803347,0.0251091) , 
3, -0.767111, 1, 0, 0.703608,0.0274106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429057,0.000653313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668452,-0.0164395) , 
0, 1.93176, 1, 0, 0.453326,-0.00240416) , 
1, -1.04839, 1, 0, 0.490786,0.00205827)    );
  // itree = 1821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.813985,0.0949416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819123,0.0281681) , 
2, 0.223091, 1, 0, 0.817403,0.0793294) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232656,0.0151756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557467,-0.0110685) , 
2, -0.862357, 1, 0, 0.481193,-0.0113934) , 
1, -1.41363, 1, 0, 0.506379,-0.00459732)    );
  // itree = 1822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100232,-0.0634754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551799,-0.0101115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542603,0.0200939) , 
1, -1.40531, 1, 0, 0.543539,0.0332437) , 
0, -3.10874, 1, 0, 0.519553,0.0263165)    );
  // itree = 1823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0527879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570847,0.0680166) , 
3, -2.07331, 1, 0, 0.312901,0.0546371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383952,-0.0108208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639065,0.00581704) , 
0, -0.145133, 1, 0, 0.528347,-0.0021838) , 
0, -2.56266, 1, 0, 0.514594,0.00144354)    );
  // itree = 1824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387909,0.00441427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521632,-0.0232621) , 
2, 0.345491, 1, 0, 0.4211,-0.00576386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.772721,0.0325206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885969,-0.0259671) , 
3, 2.13109, 1, 0, 0.79876,0.0424293) , 
2, 0.923149, 1, 0, 0.492834,0.00339015)    );
  // itree = 1825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0471185,-0.0579432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580359,-0.0173162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487636,0.00383785) , 
1, -0.392075, 1, 0, 0.515315,-0.00403855) , 
2, -1.91502, 1, 0, 0.494367,-0.00783881)    );
  // itree = 1826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186851,-0.0463965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498845,-0.00202582) , 
0, -2.89816, 1, 0, 0.481223,-0.0083238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195573,-0.0529585) , 
1, 2.17198, 1, 0, 0.473719,-0.0118242)    );
  // itree = 1827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338167,-0.0075747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479524,-0.0347553) , 
3, 0.523757, 1, 0, 0.360056,-0.0220507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.892925,0.0361476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853426,0.00202907) , 
3, 1.01282, 1, 0, 0.858372,0.0123635) , 
3, 0.828289, 1, 0, 0.50892,-0.01177)    );
  // itree = 1828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564777,-9.69419e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502936,-0.0559001) , 
1, -1.58463, 1, 0, 0.538301,-0.0444367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322683,0.0106189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624322,-0.00403094) , 
2, -0.237487, 1, 0, 0.49425,0.00408971) , 
1, -1.26741, 1, 0, 0.49982,-0.00204652)    );
  // itree = 1829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351241,-0.0108977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.913581,0.025103) , 
3, 1.04695, 1, 0, 0.384266,-0.01592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.734518,0.0612688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726175,-0.000225947) , 
2, 0.687504, 1, 0, 0.727565,0.0219954) , 
2, 0.521751, 1, 0, 0.488909,-0.00436277)    );
  // itree = 1830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62512,0.0197985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854122,0.0473264) , 
0, 1.17428, 1, 0, 0.687781,0.0462029) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134167,-0.0181048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632846,0.00350661) , 
3, -0.707817, 1, 0, 0.501986,-0.00263836) , 
1, -1.05754, 1, 0, 0.528993,0.00446114)    );
  // itree = 1831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384751,0.0342727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165059,-0.0113834) , 
1, 0.434174, 1, 0, 0.284946,0.0258014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477745,-0.0431712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601603,0.00250111) , 
0, -0.751888, 1, 0, 0.581374,-0.0125776) , 
2, -0.425618, 1, 0, 0.481246,0.000386121)    );
  // itree = 1832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242414,-0.0219199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636404,0.00620087) , 
3, 0.0377765, 1, 0, 0.351093,-0.0305225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514085,0.0380023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815478,-0.00187748) , 
3, 0.716234, 1, 0, 0.73129,0.0216397) , 
2, 0.391241, 1, 0, 0.485298,-0.0121098)    );
  // itree = 1833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251697,-0.00677339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135162,-0.0284061) , 
1, 0.251743, 1, 0, 0.183412,-0.0400385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553956,0.0423435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602536,-0.00213656) , 
0, -1.38531, 1, 0, 0.598371,0.00179286) , 
2, -0.792904, 1, 0, 0.496469,-0.0084797)    );
  // itree = 1834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103681,-0.023042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595396,0.0319006) , 
3, -1.27403, 1, 0, 0.346081,0.0177144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547491,-0.0155203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862171,0.0173563) , 
0, 2.18142, 1, 0, 0.580945,-0.0252134) , 
0, -1.22798, 1, 0, 0.527486,-0.0154423)    );
  // itree = 1835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507887,-0.00539568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596818,0.0240318) , 
1, 0.526796, 1, 0, 0.521625,-0.00379775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316212,-0.0150509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463659,-0.0360428) , 
2, 0.282638, 1, 0, 0.359713,-0.0432048) , 
1, 0.92669, 1, 0, 0.490347,-0.0114105)    );
  // itree = 1836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641723,0.0113995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435148,-0.0229292) , 
1, -0.625286, 1, 0, 0.527193,-0.0184106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26492,-0.00443973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717026,0.02176) , 
2, -0.0762318, 1, 0, 0.465145,0.0130116) , 
1, 0.198194, 1, 0, 0.499632,-0.00445358)    );
  // itree = 1837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203042,-0.0203075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103945,-0.0514911) , 
1, 0.643691, 1, 0, 0.173046,-0.0547381) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45443,0.0134749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671678,-0.0159121) , 
2, 0.605152, 1, 0, 0.521711,0.00776269) , 
0, -2.03899, 1, 0, 0.478512,1.88375e-05)    );
  // itree = 1838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280971,0.0140048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476978,-0.021265) , 
0, -1.37864, 1, 0, 0.418417,-0.0226944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622666,0.030802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8799,-0.0204231) , 
3, 1.71258, 1, 0, 0.726405,0.0333995) , 
0, 1.12719, 1, 0, 0.492049,-0.00928382)    );
  // itree = 1839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0506772,0.00274991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634156,0.0471379) , 
3, -1.55801, 1, 0, 0.347978,0.0494828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159723,0.0185732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616064,-0.00417868) , 
3, -0.518554, 1, 0, 0.517323,-0.00168838) , 
0, -2.03899, 1, 0, 0.497794,0.00421274)    );
  // itree = 1840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376443,0.00350553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256827,-0.0236904) , 
0, -0.375346, 1, 0, 0.330725,-0.0176049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.720562,0.0494326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824558,0.00247126) , 
3, 0.79108, 1, 0, 0.811272,0.0140076) , 
3, 0.609067, 1, 0, 0.496146,-0.00672278)    );
  // itree = 1841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0912644,0.116651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313425,-0.00920828) , 
2, -1.85846, 1, 0, 0.293312,-0.0114144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.820093,0.0157487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689547,0.00130115) , 
1, 0.107382, 1, 0, 0.75121,0.0159815) , 
3, 0.132736, 1, 0, 0.537351,0.00318637)    );
  // itree = 1842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216184,-0.013759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477404,0.0159696) , 
2, -0.659075, 1, 0, 0.322727,-0.00277921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543058,-0.0262306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.918855,0.00439458) , 
3, 1.67824, 1, 0, 0.627536,-0.0401839) , 
2, 0.0876493, 1, 0, 0.468492,-0.0206668)    );
  // itree = 1843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322766,0.00681138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489152,0.0408969) , 
0, -0.185961, 1, 0, 0.375886,0.031862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.549737,-0.0314565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689849,-0.00369945) , 
0, -0.285118, 1, 0, 0.67254,-0.0155407) , 
2, 0.21926, 1, 0, 0.510337,0.0103779)    );
  // itree = 1844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210675,-0.0150663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684424,0.00302949) , 
3, -0.133228, 1, 0, 0.487446,-0.0071653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516804,0.0448383) , 
1, 2.04292, 1, 0, 0.488518,-0.00322707)    );
  // itree = 1845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529067,-0.0309974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604611,0.0253321) , 
1, -1.88071, 1, 0, 0.59741,0.0330377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149159,-0.0237769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633739,0.00163715) , 
3, -0.351682, 1, 0, 0.435157,-0.0142329) , 
1, -0.522785, 1, 0, 0.479422,-0.00133676)    );
  // itree = 1846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146376,-0.00926316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23217,-0.0404209) , 
3, -0.685991, 1, 0, 0.171765,-0.0381255) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637567,0.00983013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735451,-0.0212667) , 
2, 0.781403, 1, 0, 0.674695,-0.00308303) , 
3, -0.2003, 1, 0, 0.474559,-0.0170278)    );
  // itree = 1847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180765,-0.00719474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51132,0.0136237) , 
3, -0.373865, 1, 0, 0.292503,0.00442495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636607,-0.0218829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.970712,0.0426729) , 
3, 2.65777, 1, 0, 0.656375,-0.036502) , 
3, 0.179643, 1, 0, 0.467448,-0.0152522)    );
  // itree = 1848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373792,-0.00585111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381247,-0.0313222) , 
2, 0.79636, 1, 0, 0.374386,-0.0176486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.745255,-0.013102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.844892,0.013829) , 
2, 0.365293, 1, 0, 0.824049,0.0155373) , 
3, 0.729578, 1, 0, 0.510522,-0.00760152)    );
  // itree = 1849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371368,0.0505559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746268,0.018614) , 
2, -0.418805, 1, 0, 0.68193,0.0465166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345817,-0.00944386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700976,0.0134466) , 
2, 0.52282, 1, 0, 0.447138,-0.00357932) , 
1, -1.05754, 1, 0, 0.482324,0.00392815)    );
  // itree = 1850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550449,-0.00853625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507936,0.012737) , 
1, -0.537586, 1, 0, 0.52739,0.00630213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271469,-0.0158584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623341,-0.0366321) , 
2, 0.305671, 1, 0, 0.383494,-0.0403978) , 
1, 0.560452, 1, 0, 0.474164,-0.0109719)    );
  // itree = 1851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199556,-0.0169279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875195,0.0464549) , 
3, -0.704989, 1, 0, 0.698967,0.0412734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461246,-0.00760786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487115,0.0117728) , 
1, 0.157745, 1, 0, 0.475487,0.00461923) , 
1, -1.12613, 1, 0, 0.507461,0.00986343)    );
  // itree = 1852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.967852,0.128093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274536,-0.0182279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580471,0.00900734) , 
0, -1.06144, 1, 0, 0.491337,0.00480448) , 
1, -1.97715, 1, 0, 0.504757,0.011571)    );
  // itree = 1853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.734707,0.034078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44088,-0.0286441) , 
1, -1.24118, 1, 0, 0.528209,-0.0301709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579732,0.0183401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464149,-0.00322934) , 
1, 0.29055, 1, 0, 0.506895,0.0099627) , 
1, -0.429674, 1, 0, 0.513819,-0.00307498)    );
  // itree = 1854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496689,-0.0663563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350616,-0.0115128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777697,0.00885525) , 
2, 0.516079, 1, 0, 0.477212,-0.00893658) , 
1, -1.99935, 1, 0, 0.477826,-0.0125051)    );
  // itree = 1855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0241093,0.0103484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344606,-0.0466947) , 
3, -1.87936, 1, 0, 0.188223,-0.050708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545412,0.00381895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443246,0.0200002) , 
1, 0.814014, 1, 0, 0.5195,0.0140148) , 
0, -2.54417, 1, 0, 0.489221,0.00809923)    );
  // itree = 1856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.095414,5.31223e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419212,0.0887776) , 
2, -1.6293, 1, 0, 0.205075,0.0533717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282717,-0.00903703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.740002,0.00548492) , 
3, 0.140283, 1, 0, 0.535143,-0.00247411) , 
2, -1.0839, 1, 0, 0.493429,0.0045837)    );
  // itree = 1857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254095,-0.00338527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733656,0.0309845) , 
3, 0.113874, 1, 0, 0.381947,0.0093232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330168,-0.0389052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.826711,0.000290276) , 
3, 0.464071, 1, 0, 0.739315,-0.0196338) , 
2, 0.521751, 1, 0, 0.497367,-2.90798e-05)    );
  // itree = 1858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0510146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369762,0.0602) , 
3, -2.27949, 1, 0, 0.227253,0.0524899) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519494,0.0038195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684139,-0.0090001) , 
0, 1.30083, 1, 0, 0.560342,0.00168858) , 
0, -2.56266, 1, 0, 0.533914,0.0057193)    );
  // itree = 1859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34963,0.00536048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647227,0.0253239) , 
0, -0.282052, 1, 0, 0.509865,0.0288899) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.675198,-0.0390077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.945468,0.0186312) , 
3, 2.40137, 1, 0, 0.785717,-0.0336703) , 
0, 2.29217, 1, 0, 0.533513,0.0235268)    );
  // itree = 1860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428062,0.000413147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472577,0.0501746) , 
1, 1.83743, 1, 0, 0.429614,0.00394206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388888,-0.0616216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692953,-0.0208646) , 
2, 0.257573, 1, 0, 0.643277,-0.0486218) , 
0, 1.06786, 1, 0, 0.481307,-0.00877506)    );
  // itree = 1861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152936,-0.00445713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579111,0.0644129) , 
2, -0.888874, 1, 0, 0.277423,0.0339933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55853,-0.0131916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448251,0.0222323) , 
1, 1.14, 1, 0, 0.5404,-0.0162095) , 
0, -1.6198, 1, 0, 0.50164,-0.00881014)    );
  // itree = 1862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129922,0.00253814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183427,-0.0295836) , 
2, -1.37902, 1, 0, 0.164767,-0.0355192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.685723,0.0150931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484717,-0.00396624) , 
1, -0.225837, 1, 0, 0.564476,0.00693089) , 
2, -0.771199, 1, 0, 0.474687,-0.00260494)    );
  // itree = 1863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313505,-0.0127661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701784,0.00607491) , 
2, -0.226567, 1, 0, 0.544447,-0.00378022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517594,0.0679413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571384,0.00610364) , 
2, -0.640601, 1, 0, 0.556174,0.0507062) , 
1, 1.2714, 1, 0, 0.54574,0.00223056)    );
  // itree = 1864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222725,0.00746749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654677,0.0738703) , 
2, -0.80146, 1, 0, 0.380264,0.059151) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576045,-0.00876655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616001,0.0104917) , 
1, 0.198194, 1, 0, 0.592615,-0.00201008) , 
0, -1.04422, 1, 0, 0.539221,0.0133684)    );
  // itree = 1865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187317,0.0699585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413666,-0.0136415) , 
0, -3.24462, 1, 0, 0.40375,-0.024109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42028,0.0236373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853753,-0.00863397) , 
3, 1.08787, 1, 0, 0.647104,0.0143535) , 
0, 0.505788, 1, 0, 0.495593,-0.00959307)    );
  // itree = 1866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215316,0.00635307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408574,-0.0294706) , 
3, -0.157937, 1, 0, 0.262642,-0.00997704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71205,0.0374822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692615,-0.00318862) , 
0, 0.572528, 1, 0, 0.70026,0.0224818) , 
2, -0.242286, 1, 0, 0.497745,0.0074609)    );
  // itree = 1867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26871,-0.0277189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183957,-0.0105669) , 
1, 0.265077, 1, 0, 0.231291,-0.0384162) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.96036,0.0333838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68068,-0.00223313) , 
0, 0.0736904, 1, 0, 0.718677,0.00175459) , 
3, 0.179643, 1, 0, 0.451683,-0.0202513)    );
  // itree = 1868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190834,-0.00500443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207623,0.0211109) , 
0, -2.31713, 1, 0, 0.201802,0.0182377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353097,-0.0313013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757654,0.00313755) , 
3, -0.0415859, 1, 0, 0.663095,-0.0153809) , 
3, -0.547237, 1, 0, 0.524357,-0.00526975)    );
  // itree = 1869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141742,-0.0495953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144625,-0.00270742) , 
1, -1.17718, 1, 0, 0.144239,-0.0168865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830235,0.0360119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567023,0.00739722) , 
1, -0.491819, 1, 0, 0.636053,0.0271977) , 
3, -0.783748, 1, 0, 0.50918,0.0158253)    );
  // itree = 1870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236952,0.0165219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684281,-0.00556261) , 
3, -0.291428, 1, 0, 0.541748,0.00173194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191045,0.0116718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443884,-0.0305455) , 
2, -0.921723, 1, 0, 0.370081,-0.0442615) , 
1, 1.04982, 1, 0, 0.506187,-0.00779571)    );
  // itree = 1871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830244,0.0305103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453933,-0.0169067) , 
1, -1.91323, 1, 0, 0.473682,-0.0294205) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623843,0.0353369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386262,-0.00972279) , 
1, 1.04874, 1, 0, 0.477112,0.0103604) , 
1, 0.550543, 1, 0, 0.474733,-0.0172288)    );
  // itree = 1872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201972,0.00596471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476621,-0.00917841) , 
2, -0.777373, 1, 0, 0.394161,-0.0116134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.980502,0.0652654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919264,0.0139199) , 
3, 1.51715, 1, 0, 0.929884,0.0310541) , 
3, 1.35152, 1, 0, 0.487626,-0.00416942)    );
  // itree = 1873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0855068,-0.0197972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540131,0.0596472) , 
2, -1.60148, 1, 0, 0.333353,0.0530546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467392,-0.0150581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.859237,0.0219639) , 
2, 0.944203, 1, 0, 0.55389,-0.0144612) , 
0, -1.48672, 1, 0, 0.515699,-0.00276932)    );
  // itree = 1874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386494,-0.00656504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691547,0.0139817) , 
0, 0.452683, 1, 0, 0.484333,-0.000208751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542918,-0.0580562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.876544,-0.0199487) , 
3, 1.92022, 1, 0, 0.750149,-0.0719874) , 
2, 1.38813, 1, 0, 0.507068,-0.00634792)    );
  // itree = 1875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506452,0.0132843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809986,-0.0176789) , 
2, 1.24795, 1, 0, 0.536924,0.0176465) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264534,-0.0572209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385762,-0.00387739) , 
1, 0.981475, 1, 0, 0.369175,-0.0250285) , 
1, 0.860284, 1, 0, 0.495265,0.00704839)    );
  // itree = 1876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200856,0.0273515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212646,-0.0228538) , 
0, -2.26656, 1, 0, 0.209526,-0.0258208) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436978,0.0316126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745428,0.000502277) , 
3, 0.235964, 1, 0, 0.655545,0.0160554) , 
2, -0.501068, 1, 0, 0.506339,0.00204658)    );
  // itree = 1877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417093,0.0720489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646208,0.00662435) , 
0, -2.44728, 1, 0, 0.622939,0.0241203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366338,-0.0349612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466479,-0.000505013) , 
1, 0.0647796, 1, 0, 0.455124,-0.0107312) , 
1, -0.102661, 1, 0, 0.525644,0.00391429)    );
  // itree = 1878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104053,-0.0676191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853161,0.00942434) , 
3, -0.634057, 1, 0, 0.576478,-0.0696487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421709,0.0103251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.810756,-0.0274697) , 
3, 1.15656, 1, 0, 0.506399,0.00542818) , 
1, -1.37148, 1, 0, 0.513911,-0.00261933)    );
  // itree = 1879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226126,0.0120029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396657,-0.0261518) , 
2, -0.857196, 1, 0, 0.312787,-0.0237631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613748,-0.0121677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606799,0.012115) , 
1, -0.429674, 1, 0, 0.608916,0.00920944) , 
0, -1.04975, 1, 0, 0.526718,5.71134e-05)    );
  // itree = 1880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438238,-0.0215428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815025,0.0104039) , 
2, 1.05734, 1, 0, 0.502869,-0.0331071) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497179,0.00896855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471139,0.0436283) , 
1, 1.36435, 1, 0, 0.491994,0.0267401) , 
1, -0.11574, 1, 0, 0.497197,-0.0018955)    );
  // itree = 1881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962531,-0.0484722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0919181,0.00786604) , 
1, 0.336366, 1, 0, 0.0945382,-0.0397392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.700191,-0.0334902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652175,0.0144052) , 
1, -1.34475, 1, 0, 0.656429,0.0194953) , 
3, -0.703077, 1, 0, 0.496816,0.00266889)    );
  // itree = 1882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292695,-0.0097944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0590268) , 
3, 0.164651, 1, 0, 0.366826,-0.0120777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.571383,0.054519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728565,0.000325635) , 
2, -0.203421, 1, 0, 0.706572,0.0155511) , 
0, -0.0887253, 1, 0, 0.524515,0.000745884)    );
  // itree = 1883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216724,-0.00573517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265321,0.0362405) , 
1, 0.992459, 1, 0, 0.230633,0.00969016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407827,-0.0243533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830475,0.00364573) , 
3, 0.770082, 1, 0, 0.581155,-0.0278014) , 
2, -0.55359, 1, 0, 0.461959,-0.0150522)    );
  // itree = 1884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0382036,-0.0536403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311492,0.0173211) , 
0, -3.00507, 1, 0, 0.27181,0.0143964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613955,-0.0154417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.911213,0.0310767) , 
2, 1.79184, 1, 0, 0.629842,-0.0250656) , 
2, -0.351925, 1, 0, 0.497658,-0.0104965)    );
  // itree = 1885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733256,0.0367861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440325,-0.01247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543133,0.0360243) , 
1, 2.15464, 1, 0, 0.443515,-0.0189192) , 
1, -1.59845, 1, 0, 0.45814,-0.0154125)    );
  // itree = 1886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468936,-0.0562551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517062,0.00777621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30607,-0.0367684) , 
1, 2.09085, 1, 0, 0.51133,0.010296) , 
1, -1.99411, 1, 0, 0.509531,0.0061824)    );
  // itree = 1887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508064,0.0364898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61558,0.00800125) , 
0, -0.0225028, 1, 0, 0.565984,0.0357022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102689,0.124671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4835,-0.00548175) , 
2, -1.85205, 1, 0, 0.456213,-0.0043092) , 
1, 0.423988, 1, 0, 0.52274,0.0199399)    );
  // itree = 1888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.794342,0.0557651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457773,0.003162) , 
1, -1.65069, 1, 0, 0.650796,0.0558717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0730003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508179,-0.00458905) , 
2, -1.91502, 1, 0, 0.487897,-0.0124743) , 
1, -1.48631, 1, 0, 0.500347,-0.00725105)    );
  // itree = 1889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618544,-0.00514944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576592,0.0250309) , 
1, -0.974789, 1, 0, 0.59431,0.023282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355259,0.0014594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72066,-0.0230876) , 
2, 0.760384, 1, 0, 0.414822,-0.00550376) , 
1, -0.0789854, 1, 0, 0.496928,0.00766425)    );
  // itree = 1890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154368,-0.0208277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375488,-0.0369352) , 
2, -0.829302, 1, 0, 0.256294,-0.0549864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557805,-0.00476649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.897444,0.031574) , 
2, 1.33661, 1, 0, 0.605695,-0.000724936) , 
0, -1.01549, 1, 0, 0.501116,-0.016966)    );
  // itree = 1891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617468,-0.0350655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535836,0.0130811) , 
1, -1.73469, 1, 0, 0.540083,0.0211136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337606,-0.0394508) , 
1, 1.96083, 1, 0, 0.532547,0.0165766)    );
  // itree = 1892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604828,-0.0016547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622995,0.0305656) , 
1, -1.49936, 1, 0, 0.617811,0.034636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454015,-0.0286631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505259,0.00276711) , 
1, -0.0546303, 1, 0, 0.494641,-0.00887503) , 
1, -0.417903, 1, 0, 0.532253,0.00441187)    );
  // itree = 1893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.813296,0.0383294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535187,-0.00167804) , 
1, -1.4046, 1, 0, 0.575401,0.0055679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237969,0.0982976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437902,-0.0257255) , 
0, -2.87695, 1, 0, 0.427342,-0.0429734) , 
1, 0.237261, 1, 0, 0.50128,-0.0187328)    );
  // itree = 1894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539655,-0.00606163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451579,-0.0315952) , 
1, -0.398784, 1, 0, 0.51948,-0.0265377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0690668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554665,0.0197494) , 
2, -1.98019, 1, 0, 0.528266,0.0300347) , 
1, -0.101333, 1, 0, 0.524344,0.00478018)    );
  // itree = 1895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483706,0.0110982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322003,-0.0216074) , 
1, 1.38085, 1, 0, 0.463624,0.0128847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673095,-0.0338423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835465,0.0227589) , 
1, 0.680106, 1, 0, 0.722425,-0.0270054) , 
2, 0.949745, 1, 0, 0.516376,0.0047539)    );
  // itree = 1896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363742,-0.00044961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670327,0.0266892) , 
3, 0.448287, 1, 0, 0.404805,0.00611117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944923,0.0310822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78031,-0.0207671) , 
1, -1.10448, 1, 0, 0.799793,-0.027176) , 
3, 0.760049, 1, 0, 0.530136,-0.00445097)    );
  // itree = 1897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0721116,-0.0555783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376574,0.00485738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725628,-0.0135718) , 
3, 0.491701, 1, 0, 0.517736,-0.0046924) , 
0, -3.25007, 1, 0, 0.505149,-0.00731949)    );
  // itree = 1898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460074,0.00388933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640703,-0.0236501) , 
0, 1.5882, 1, 0, 0.483098,0.000131348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.780534,0.0669722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.889689,-0.0225422) , 
3, 1.7554, 1, 0, 0.848551,0.051822) , 
2, 1.33879, 1, 0, 0.516823,0.0049015)    );
  // itree = 1899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13554,-0.0127339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41329,0.0418085) , 
3, -1.05418, 1, 0, 0.251287,0.0244103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493548,-0.0191245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731892,0.00892649) , 
2, 0.186242, 1, 0, 0.646172,-0.00601923) , 
3, -0.291428, 1, 0, 0.505811,0.00479693)    );
  // itree = 1900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441926,-0.0496885) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196017,-0.0210715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586981,0.00793951) , 
0, -1.72297, 1, 0, 0.511013,0.00548356) , 
1, -1.99411, 1, 0, 0.508007,0.00130456)    );
  // itree = 1901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492011,-0.0087236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467125,0.0136596) , 
1, -0.168895, 1, 0, 0.477926,0.00716397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601593,-0.00398301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620166,-0.0564309) , 
2, 0.88402, 1, 0, 0.612558,-0.0662497) , 
0, 1.65381, 1, 0, 0.496543,-0.00298766)    );
  // itree = 1902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446813,-0.0182696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471685,0.00470268) , 
1, 0.560452, 1, 0, 0.45383,-0.0218385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6125,0.0505581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.872057,0.00565149) , 
3, 1.64917, 1, 0, 0.803255,0.0494589) , 
0, 1.93176, 1, 0, 0.494877,-0.0134632)    );
  // itree = 1903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38788,-0.0284785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308359,0.0119641) , 
1, -0.955784, 1, 0, 0.322184,0.00737497) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4671,-0.0441086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.85511,0.00220276) , 
3, 0.965707, 1, 0, 0.69658,-0.0378657) , 
3, 0.34753, 1, 0, 0.486859,-0.0125238)    );
  // itree = 1904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58114,-0.00386556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592484,-0.0300482) , 
1, -1.25948, 1, 0, 0.587542,-0.0363718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461168,0.0111297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471997,-0.00769364) , 
1, 0.172561, 1, 0, 0.467379,0.00166602) , 
1, -0.788722, 1, 0, 0.491729,-0.00604201)    );
  // itree = 1905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5777,-0.0130212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497363,0.0116987) , 
1, -0.529806, 1, 0, 0.531375,0.00275311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497443,-0.0424194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342423,-0.00561713) , 
1, 0.907609, 1, 0, 0.388807,-0.0323612) , 
1, 0.560452, 1, 0, 0.485184,-0.00862368)    );
  // itree = 1906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525285,0.00139088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627191,0.0397293) , 
1, -0.109227, 1, 0, 0.546564,0.0203888) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18527,0.0172302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45325,-0.0244662) , 
2, -1.45259, 1, 0, 0.423513,-0.040406) , 
1, 0.219717, 1, 0, 0.49005,-0.00753276)    );
  // itree = 1907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0884037,0.0299384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226845,0.0539537) , 
1, 0.140697, 1, 0, 0.153082,0.0381636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354889,-0.0100771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.845879,0.0110586) , 
3, 0.903224, 1, 0, 0.488157,-0.00836878) , 
2, -1.44641, 1, 0, 0.460178,-0.00448323)    );
  // itree = 1908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310758,-0.014626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846366,0.0122189) , 
3, 0.658912, 1, 0, 0.461975,-0.0141272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.827992,0.0668715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.903871,0.00836338) , 
3, 1.83754, 1, 0, 0.874239,0.0725676) , 
2, 1.33607, 1, 0, 0.495556,-0.00706541)    );
  // itree = 1909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352218,-0.0043459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0790064,-0.0425299) , 
1, 1.39008, 1, 0, 0.305425,-0.0199707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427227,0.0491934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781425,0.0106247) , 
3, -0.0529184, 1, 0, 0.743038,0.0298729) , 
2, 0.129681, 1, 0, 0.509859,0.00331414)    );
  // itree = 1910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.917686,0.085745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489898,-0.0255836) , 
1, -2.02174, 1, 0, 0.536029,-0.029752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137789,-0.00562021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606489,0.0125379) , 
3, -0.796906, 1, 0, 0.462615,0.0156978) , 
1, -0.705165, 1, 0, 0.480436,0.00466509)    );
  // itree = 1911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468127,0.044782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271777,0.0100837) , 
1, -0.357284, 1, 0, 0.330176,0.0384245) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552318,-0.017041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819517,0.00950899) , 
3, 0.800632, 1, 0, 0.720515,-0.00434366) , 
3, 0.179643, 1, 0, 0.518587,0.0177809)    );
  // itree = 1912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378573,-0.00492027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442725,0.0949889) , 
1, 1.6073, 1, 0, 0.382557,0.00229525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358307,-0.033027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874228,-0.00423673) , 
3, 1.24844, 1, 0, 0.520391,-0.0505295) , 
0, -0.0887253, 1, 0, 0.459611,-0.0272358)    );
  // itree = 1913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209284,-0.012993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0493323,-0.0520943) , 
1, 1.15802, 1, 0, 0.184676,-0.0354317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.703682,0.0199828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640387,-0.00600846) , 
0, 0.626252, 1, 0, 0.668148,0.00919249) , 
3, -0.291428, 1, 0, 0.477882,-0.00836897)    );
  // itree = 1914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252645,-0.0075209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651368,-0.0314608) , 
3, 0.0989116, 1, 0, 0.415832,-0.0326399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615875,-0.00789174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81245,0.0185262) , 
0, 2.42214, 1, 0, 0.729795,0.0172434) , 
0, 1.85673, 1, 0, 0.455634,-0.0263159)    );
  // itree = 1915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489014,-0.0641675) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1988,-0.0248493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54171,0.00181192) , 
0, -1.54553, 1, 0, 0.467865,-0.00549853) , 
1, -1.67665, 1, 0, 0.468792,-0.0107447)    );
  // itree = 1916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261598,0.00521193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313123,0.0461976) , 
1, 0.736628, 1, 0, 0.277479,0.0253298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520031,-0.0223104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699752,0.00427183) , 
2, 0.353656, 1, 0, 0.635351,-0.00998822) , 
2, -0.250499, 1, 0, 0.483683,0.00497974)    );
  // itree = 1917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0679023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325878,0.0213428) , 
2, -1.90382, 1, 0, 0.290325,0.0278352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407578,-0.0269682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780047,0.00510981) , 
3, 0.300367, 1, 0, 0.684299,-0.0109045) , 
3, -0.145446, 1, 0, 0.534328,0.00384222)    );
  // itree = 1918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40977,0.0132103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739644,-0.00621257) , 
3, 0.194199, 1, 0, 0.559755,0.00839817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393978,-0.0189021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702471,0.0244277) , 
1, 2.04906, 1, 0, 0.410739,-0.0289332) , 
1, -0.133281, 1, 0, 0.477943,-0.0120972)    );
  // itree = 1919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604304,-0.0453983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543015,0.0153291) , 
1, -1.89783, 1, 0, 0.544853,0.0238194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240039,-0.0508874) , 
1, 2.30555, 1, 0, 0.534393,0.0195403)    );
  // itree = 1920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.0421298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214416,0.0207978) , 
1, 1.21085, 1, 0, 0.164328,-0.0574998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131575,-0.0274226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680161,-0.00250473) , 
3, -0.408126, 1, 0, 0.551314,-0.0135533) , 
2, -1.026, 1, 0, 0.478136,-0.0218634)    );
  // itree = 1921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651723,0.0673836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811271,0.00212072) , 
0, 0.41031, 1, 0, 0.729569,0.0748712) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239879,-0.0151262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753889,0.0169282) , 
2, 0.0154847, 1, 0, 0.481696,0.000772271) , 
1, -1.09137, 1, 0, 0.516262,0.0111052)    );
  // itree = 1922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390569,0.0016905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627004,-0.0234837) , 
2, 0.320025, 1, 0, 0.490021,-0.0191934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523548,0.0288428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371419,-0.0170217) , 
1, 1.17722, 1, 0, 0.466073,0.0181271) , 
1, 0.403002, 1, 0, 0.48083,-0.00487062)    );
  // itree = 1923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368765,-0.00245748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442553,0.0419213) , 
2, 0.933896, 1, 0, 0.373642,0.000127114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.781694,-0.117577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.79051,-0.0147428) , 
1, -1.2883, 1, 0, 0.789473,-0.04153) , 
3, 0.876835, 1, 0, 0.480755,-0.0106032)    );
  // itree = 1924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270779,-0.0244451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278916,0.0212158) , 
1, 1.24704, 1, 0, 0.272158,-0.0337587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673491,0.00709589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714319,0.0476833) , 
1, 1.73844, 1, 0, 0.675564,0.0172267) , 
2, -0.00680894, 1, 0, 0.472884,-0.00838938)    );
  // itree = 1925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373559,0.0259677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0965658,-0.0342142) , 
0, 0.0375288, 1, 0, 0.332364,0.0284741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601524,-0.00597829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846066,0.0177572) , 
3, 1.0209, 1, 0, 0.711056,0.00704998) , 
3, 0.191234, 1, 0, 0.522368,0.0177248)    );
  // itree = 1926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237902,-0.0367213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266754,0.0224159) , 
1, 0.740256, 1, 0, 0.244765,-0.041262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562676,-0.00229184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608971,0.0165158) , 
1, 0.993484, 1, 0, 0.570897,0.00299023) , 
0, -1.34868, 1, 0, 0.500069,-0.00662026)    );
  // itree = 1927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480861,0.00245752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260588,-0.0223836) , 
1, 1.17337, 1, 0, 0.44266,-0.00370373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255503,-0.0639859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862863,-0.0169874) , 
3, 1.50378, 1, 0, 0.635571,-0.0605238) , 
0, 1.47726, 1, 0, 0.475615,-0.0134103)    );
  // itree = 1928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5395,0.00616822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407774,-0.014784) , 
1, -0.227901, 1, 0, 0.464943,-0.0114674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.899149,0.0704398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.849641,-0.0132884) , 
2, 1.74539, 1, 0, 0.86738,0.0470847) , 
2, 1.43186, 1, 0, 0.498166,-0.00663374)    );
  // itree = 1929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17545,0.00550796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443063,-0.0219061) , 
3, -0.703405, 1, 0, 0.268394,-0.0133926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635412,0.0176621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757444,-0.0112056) , 
2, 0.990142, 1, 0, 0.66787,0.0183562) , 
2, -0.471788, 1, 0, 0.5567,0.00952084)    );
  // itree = 1930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.917658,0.0807022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802501,0.0558651) , 
1, -2.02533, 1, 0, 0.859899,0.0972235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434142,-0.00622557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815839,0.0219262) , 
2, 0.863656, 1, 0, 0.528456,0.00219215) , 
1, -1.65097, 1, 0, 0.54788,0.00776121)    );
  // itree = 1931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175184,-0.0467902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479638,-0.00764763) , 
0, -2.50044, 1, 0, 0.453967,-0.0183375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654559,0.0526473) , 
1, 1.92825, 1, 0, 0.461797,-0.0141942)    );
  // itree = 1932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290597,0.0205696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547356,-0.00430918) , 
0, -1.28819, 1, 0, 0.491366,0.000377827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582728,0.0738376) , 
1, 1.94792, 1, 0, 0.494206,0.00465352)    );
  // itree = 1933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164827,0.0154929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47277,-0.0115209) , 
3, -0.902977, 1, 0, 0.38237,-0.0118088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.808778,0.0418085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915709,0.0038154) , 
3, 1.63276, 1, 0, 0.862534,0.0518701) , 
2, 0.897689, 1, 0, 0.47641,0.000662633)    );
  // itree = 1934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415211,0.00574592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709701,0.0200304) , 
0, -0.251912, 1, 0, 0.577448,0.0259693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250937,-0.0229029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794829,0.0140136) , 
2, 0.356102, 1, 0, 0.411619,-0.0196111) , 
1, 0.550543, 1, 0, 0.518997,0.00990331)    );
  // itree = 1935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127325,-0.0067429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597552,0.0153399) , 
3, -0.785201, 1, 0, 0.416124,0.0142862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.724979,-0.00350423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65254,-0.0362688) , 
1, 1.14, 1, 0, 0.716911,-0.0147294) , 
2, 0.646427, 1, 0, 0.507645,0.0054575)    );
  // itree = 1936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411189,-0.0346357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299616,0.00772827) , 
1, -1.46272, 1, 0, 0.306921,0.00647757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.724754,-0.00509886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.772743,-0.037555) , 
2, 1.24026, 1, 0, 0.736001,-0.0218855) , 
3, 0.345004, 1, 0, 0.494001,-0.0058888)    );
  // itree = 1937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512452,-0.0499238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313579,0.00792869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621735,-0.00911628) , 
2, -0.349434, 1, 0, 0.51544,-0.006668) , 
0, -3.05698, 1, 0, 0.49627,-0.00984472)    );
  // itree = 1938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0265185,-0.060693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353544,0.00484091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692787,-0.00911489) , 
2, 0.193568, 1, 0, 0.506262,-0.00311172) , 
0, -3.15088, 1, 0, 0.487688,-0.00534844)    );
  // itree = 1939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641563,0.0133549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447898,-0.0339634) , 
1, -1.10964, 1, 0, 0.522932,-0.0361315) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659391,0.0498613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44148,0.00247095) , 
1, 0.0457921, 1, 0, 0.472724,0.0167203) , 
1, -0.268177, 1, 0, 0.493106,-0.00473478)    );
  // itree = 1940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347035,-0.0588934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819833,-0.00699488) , 
2, 0.323735, 1, 0, 0.5567,-0.0764272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358137,0.0140456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523203,-0.00521874) , 
0, -0.82394, 1, 0, 0.471253,0.000189415) , 
1, -1.48631, 1, 0, 0.478629,-0.00642478)    );
  // itree = 1941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400453,-0.0390187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.922309,0.0100272) , 
3, 0.351077, 1, 0, 0.651392,-0.0432064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544751,0.0127951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44848,-0.00695878) , 
1, 1.57731, 1, 0, 0.535834,0.0178247) , 
1, -1.33134, 1, 0, 0.543889,0.0135705)    );
  // itree = 1942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415896,0.0198899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.898498,0.0796007) , 
2, 0.592878, 1, 0, 0.463037,0.0527922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.68506,-0.0205027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.913722,0.00863936) , 
3, 1.5065, 1, 0, 0.78438,-0.0210604) , 
3, 0.760049, 1, 0, 0.567873,0.0286982)    );
  // itree = 1943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376691,0.0681559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808007,0.0208175) , 
3, -0.40554, 1, 0, 0.686645,0.0445367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273603,-0.020982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.80445,0.00488591) , 
3, 0.609067, 1, 0, 0.44915,-0.0262992) , 
1, -0.796883, 1, 0, 0.499419,-0.0113057)    );
  // itree = 1944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376048,0.0775321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579438,-0.0188502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496554,0.00249308) , 
1, -0.565578, 1, 0, 0.521199,-0.00682352) , 
0, -2.89816, 1, 0, 0.514421,-0.00282831)    );
  // itree = 1945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166999,-0.012077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64465,0.0250472) , 
3, -0.897343, 1, 0, 0.520824,0.0326624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.800172,0.00710299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631864,-0.0292506) , 
1, -0.197352, 1, 0, 0.716332,-0.0267219) , 
2, 1.01032, 1, 0, 0.558886,0.0211013)    );
  // itree = 1946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427704,0.00201216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658445,-0.0380232) , 
2, 0.276916, 1, 0, 0.558697,-0.0363777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438043,0.0229527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469973,-0.00254677) , 
1, -0.311994, 1, 0, 0.464316,0.00438763) , 
1, -0.705165, 1, 0, 0.487587,-0.00566352)    );
  // itree = 1947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527802,-0.00277092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464828,-0.046259) , 
1, -1.4051, 1, 0, 0.489878,-0.0621053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362092,-0.00924042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652582,0.00785793) , 
0, 0.978749, 1, 0, 0.438693,-0.00934168) , 
1, -0.819918, 1, 0, 0.450334,-0.0213417)    );
  // itree = 1948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269755,0.0576432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471227,0.00936495) , 
0, -2.46964, 1, 0, 0.441793,0.0231978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.807294,0.0208589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566155,-0.0046463) , 
1, -1.12364, 1, 0, 0.606483,-0.00254324) , 
0, 0.113038, 1, 0, 0.522793,0.0105376)    );
  // itree = 1949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59225,-0.0229572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531828,0.00157241) , 
1, -1.04658, 1, 0, 0.544548,-0.00544176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578968,0.0395625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409449,-0.00974663) , 
1, 1.6676, 1, 0, 0.526563,0.0471899) , 
1, 0.92669, 1, 0, 0.540936,0.00512799)    );
  // itree = 1950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360342,0.00754294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480663,0.0299965) , 
2, 0.141822, 1, 0, 0.386273,0.0237382) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570912,-0.0510946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841598,0.00465665) , 
3, 0.845118, 1, 0, 0.802993,-0.00832538) , 
3, 0.661338, 1, 0, 0.546606,0.0114018)    );
  // itree = 1951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447769,0.0864075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833736,0.00440546) , 
2, -0.388603, 1, 0, 0.744224,0.0291383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223759,0.0225366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498606,-0.013543) , 
2, -1.25963, 1, 0, 0.465161,-0.0220076) , 
1, -1.21471, 1, 0, 0.497506,-0.0160794)    );
  // itree = 1952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160387,-0.00433029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166114,-0.0379168) , 
2, -0.770795, 1, 0, 0.162677,-0.0347406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711056,0.0218057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600109,-0.0136153) , 
1, 0.476954, 1, 0, 0.672894,0.0169451) , 
3, -0.369465, 1, 0, 0.505202,-4.22829e-05)    );
  // itree = 1953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192899,-0.0131918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709837,0.0128565) , 
3, -0.207793, 1, 0, 0.452452,0.00109001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366886,-0.0544737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.896372,0.000579926) , 
3, 1.43747, 1, 0, 0.674396,-0.0583414) , 
2, 0.973129, 1, 0, 0.488763,-0.00863328)    );
  // itree = 1954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382919,0.019569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124885,-0.0441652) , 
1, 1.04982, 1, 0, 0.318767,0.00364315) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623905,-0.019498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640202,0.00970093) , 
1, 0.826062, 1, 0, 0.627107,-0.0272076) , 
2, -0.0811742, 1, 0, 0.480449,-0.0125338)    );
  // itree = 1955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554479,0.00116381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426078,-0.0265357) , 
1, 0.368996, 1, 0, 0.511195,-0.0176699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117608,-0.0154644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636217,0.0623388) , 
3, -0.47199, 1, 0, 0.42167,0.0567772) , 
1, 1.39008, 1, 0, 0.500237,-0.00855767)    );
  // itree = 1956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205907,0.0149415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599711,-0.00864174) , 
3, -0.514929, 1, 0, 0.480752,-0.0059394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.876434,0.0438925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836937,0.00143111) , 
2, 1.71462, 1, 0, 0.855071,0.0515563) , 
2, 1.38813, 1, 0, 0.515723,-0.000567927)    );
  // itree = 1957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232774,-0.0118741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739629,0.0233742) , 
2, -0.329653, 1, 0, 0.297348,-0.0120422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.803889,0.0675709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664596,0.00085112) , 
0, -0.153448, 1, 0, 0.687637,0.0179949) , 
2, -0.0811742, 1, 0, 0.509972,0.0043216)    );
  // itree = 1958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155112,-0.013166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308528,-0.0354644) , 
3, -0.475285, 1, 0, 0.182055,-0.0289322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830032,-0.0235096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711925,0.0122212) , 
0, -0.315992, 1, 0, 0.729258,0.013544) , 
3, -0.218528, 1, 0, 0.496627,-0.00451377)    );
  // itree = 1959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538932,-0.0072975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322259,-0.0571137) , 
1, 0.500254, 1, 0, 0.520408,-0.0215015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512211,0.0256995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834409,-0.0331396) , 
3, 1.24855, 1, 0, 0.581273,0.0277309) , 
1, 0.673154, 1, 0, 0.537057,-0.00803419)    );
  // itree = 1960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282998,-0.00501229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506911,0.0296373) , 
2, -1.09361, 1, 0, 0.453316,0.0419199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.803217,-0.0121668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812088,0.0301996) , 
0, 2.41847, 1, 0, 0.805416,0.000972318) , 
3, 0.812481, 1, 0, 0.574709,0.0278025)    );
  // itree = 1961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502676,-0.0183026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.79738,0.0130425) , 
2, 1.18988, 1, 0, 0.544768,-0.0239885) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525046,0.0235016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183574,-0.0509275) , 
1, 2.01442, 1, 0, 0.493009,0.029391) , 
1, 0.212582, 1, 0, 0.520516,0.00102299)    );
  // itree = 1962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470703,0.0565615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239922,0.00933295) , 
1, -0.405014, 1, 0, 0.306499,0.0310537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213314,-0.0174326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676886,-0.00276801) , 
3, 0.108085, 1, 0, 0.521545,-0.0160351) , 
0, -1.22798, 1, 0, 0.466839,-0.00405605)    );
  // itree = 1963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251027,0.00352276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619008,-0.0533059) , 
3, -0.497076, 1, 0, 0.342126,-0.0286251) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541603,0.0406481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616774,-0.00231984) , 
0, -0.635347, 1, 0, 0.606952,0.0053815) , 
0, -1.06144, 1, 0, 0.533771,-0.00401581)    );
  // itree = 1964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280227,0.0467321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0912279,-0.0165885) , 
1, 0.45974, 1, 0, 0.205663,0.0356714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185237,-0.0252053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660332,0.00669896) , 
3, -0.314514, 1, 0, 0.553867,-0.00134953) , 
2, -0.936767, 1, 0, 0.488601,0.00558948)    );
  // itree = 1965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16421,0.111069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413503,-0.00499395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691404,0.0175819) , 
0, 0.432715, 1, 0, 0.527046,0.00732461) , 
0, -3.15088, 1, 0, 0.514278,0.0102546)    );
  // itree = 1966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375947,-0.0464549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814292,-0.0142502) , 
3, 0.478544, 1, 0, 0.559645,-0.0704511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562731,0.023777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454201,-0.00877463) , 
1, -0.396645, 1, 0, 0.475081,-0.00475401) , 
1, -1.02741, 1, 0, 0.48838,-0.0150862)    );
  // itree = 1967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18034,0.000251902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0831879,-0.0645171) , 
1, 0.0307935, 1, 0, 0.122919,-0.0657869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572462,-0.00632852) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547499,0.0233543) , 
1, 0.219717, 1, 0, 0.561793,0.0116137) , 
2, -1.40478, 1, 0, 0.508593,0.00223125)    );
  // itree = 1968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525277,-0.0617751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559136,0.0103418) , 
1, -2.06609, 1, 0, 0.557801,0.0142193) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287056,-0.00376161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666911,-0.0504458) , 
2, 0.296293, 1, 0, 0.397758,-0.0308905) , 
1, 0.907319, 1, 0, 0.520352,0.00366409)    );
  // itree = 1969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0849208,0.0594651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22015,-0.0316648) , 
2, -1.93231, 1, 0, 0.194976,-0.0369462) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139086,0.112779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636234,0.0030252) , 
3, -0.913838, 1, 0, 0.594563,0.0120131) , 
0, -1.56562, 1, 0, 0.51572,0.0023528)    );
  // itree = 1970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.729803,0.0173293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457816,-0.0206709) , 
1, -1.24984, 1, 0, 0.564185,-0.0170885) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536967,0.0231601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468401,-0.00364703) , 
1, 1.17051, 1, 0, 0.521654,0.0287172) , 
1, -0.589204, 1, 0, 0.534122,0.0152891)    );
  // itree = 1971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.81635,0.0387845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509104,-0.0304751) , 
1, -1.6043, 1, 0, 0.595844,-0.0354737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415935,0.00707436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716302,-0.0156889) , 
2, 0.629493, 1, 0, 0.494078,0.00297545) , 
1, -0.936379, 1, 0, 0.512299,-0.00390895)    );
  // itree = 1972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568192,0.00465582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503534,-0.010176) , 
1, -0.31176, 1, 0, 0.533198,-0.0063962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433258,0.0764967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505938,-0.00280977) , 
2, -0.603937, 1, 0, 0.481362,0.0371823) , 
1, 1.14209, 1, 0, 0.525672,-6.92217e-05)    );
  // itree = 1973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.609475,0.0111315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463661,-0.00466753) , 
1, 0.122645, 1, 0, 0.53632,0.0060045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279989,-0.0536242) , 
1, 1.9117, 1, 0, 0.52501,0.00226016)    );
  // itree = 1974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326871,0.0131459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179662,-0.0342356) , 
1, -0.193814, 1, 0, 0.226328,-0.0365915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531808,0.0116215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687547,-0.00437099) , 
2, 0.436772, 1, 0, 0.612805,0.00565732) , 
2, -0.55359, 1, 0, 0.483892,-0.00843526)    );
  // itree = 1975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308255,0.00711919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644573,-0.0179327) , 
2, -0.226567, 1, 0, 0.511394,-0.0145183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192806,-0.0450041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492358,0.0308624) , 
1, 1.13374, 1, 0, 0.43278,0.0303106) , 
1, 1.0176, 1, 0, 0.496458,-0.00600137)    );
  // itree = 1976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245913,0.0355883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545581,-0.0181488) , 
2, -0.854765, 1, 0, 0.492663,-0.0242383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559855,0.0380577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39933,-0.00870718) , 
1, 1.20431, 1, 0, 0.477922,0.0249073) , 
1, 0.695891, 1, 0, 0.488258,-0.00955371)    );
  // itree = 1977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.906156,0.0697552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154718,0.0932966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461735,-0.0042723) , 
2, -1.97084, 1, 0, 0.451882,-0.00508221) , 
1, -1.72494, 1, 0, 0.469585,-0.000731335)    );
  // itree = 1978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218057,0.00530572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150696,-0.0608593) , 
2, -1.3408, 1, 0, 0.188838,-0.0668773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479273,-0.00938824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724345,0.016675) , 
0, 1.60509, 1, 0, 0.533155,-0.00582314) , 
0, -2.09317, 1, 0, 0.485947,-0.014194)    );
  // itree = 1979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343624,-0.0156543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259127,0.04349) , 
1, 1.70018, 1, 0, 0.339018,-0.0232751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696233,0.02708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.762729,-0.0154458) , 
2, 1.16108, 1, 0, 0.713054,0.0271801) , 
2, 0.0154847, 1, 0, 0.522434,0.0014666)    );
  // itree = 1980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568431,0.00152054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443355,-0.0195883) , 
1, -0.572957, 1, 0, 0.482479,-0.0255438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.096566,-0.0116087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.765184,0.0576508) , 
3, -0.54833, 1, 0, 0.485216,0.0537999) , 
1, 1.54195, 1, 0, 0.482661,-0.0202625)    );
  // itree = 1981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118572,-0.0302679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643901,0.000972439) , 
3, -0.680259, 1, 0, 0.468658,-0.0127325) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534752,0.0369445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596517,-0.0284002) , 
0, 1.97101, 1, 0, 0.54326,0.0468343) , 
1, 0.907319, 1, 0, 0.484172,-0.000345345)    );
  // itree = 1982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384541,-0.00978094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482744,-0.06493) , 
0, 1.36563, 1, 0, 0.392138,-0.0257266) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.749641,0.0308705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880958,-0.00268705) , 
3, 1.46439, 1, 0, 0.823578,0.0294996) , 
2, 0.863656, 1, 0, 0.478262,-0.0147024)    );
  // itree = 1983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181672,-0.0582422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.978327,0.0272994) , 
3, 0.240362, 1, 0, 0.477554,-0.0789774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0389489,-0.0766454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516323,0.00289583) , 
2, -2.08286, 1, 0, 0.502721,0.00214764) , 
1, -1.36363, 1, 0, 0.500291,-0.00568686)    );
  // itree = 1984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308335,-0.00442567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172374,-0.0256447) , 
1, 0.604454, 1, 0, 0.262742,-0.0227541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.802003,0.0289144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720921,-0.0184326) , 
2, 1.16988, 1, 0, 0.775903,0.024769) , 
3, 0.34753, 1, 0, 0.482205,-0.00242996)    );
  // itree = 1985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166395,-0.0307022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248579,0.0119135) , 
1, -1.51657, 1, 0, 0.240429,0.0115357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444987,-0.0300005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812433,0.00375051) , 
3, 0.576404, 1, 0, 0.662144,-0.0274812) , 
3, -0.0843967, 1, 0, 0.483442,-0.0109477)    );
  // itree = 1986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0580537,-0.0294322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750484,0.055695) , 
3, -1.14185, 1, 0, 0.256683,0.0225952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125437,-0.0257435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645326,-0.00544301) , 
3, -0.541447, 1, 0, 0.550294,-0.017103) , 
2, -1.08479, 1, 0, 0.514585,-0.0122749)    );
  // itree = 1987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528004,-0.00305552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483598,0.0153999) , 
1, 0.251858, 1, 0, 0.516397,0.00226637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345513,-0.04336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419106,-0.00621413) , 
1, 1.08494, 1, 0, 0.400989,-0.0290471) , 
1, 0.843066, 1, 0, 0.487631,-0.00553871)    );
  // itree = 1988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132772,0.0142684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328373,0.0344644) , 
3, -0.970815, 1, 0, 0.211046,0.0335639) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427235,-0.0233233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677989,-0.000314899) , 
2, -0.234361, 1, 0, 0.62354,-0.0124536) , 
3, -0.516641, 1, 0, 0.509538,0.000264387)    );
  // itree = 1989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27321,-0.0060884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.795632,0.0586246) , 
3, 0.437218, 1, 0, 0.328997,-0.000582613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.701354,0.00898337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672288,-0.0155829) , 
1, -0.788722, 1, 0, 0.679284,-0.0198133) , 
2, 0.113077, 1, 0, 0.49278,-0.0095743)    );
  // itree = 1990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524341,-0.0237477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485448,0.00630755) , 
1, -1.2212, 1, 0, 0.490991,0.00369131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294818,-0.0315555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470005,-0.0553303) , 
2, 0.385083, 1, 0, 0.364735,-0.0961582) , 
1, 1.4166, 1, 0, 0.479554,-0.00535373)    );
  // itree = 1991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422342,-0.0373054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511051,0.000312044) , 
1, -2.05515, 1, 0, 0.507807,-0.00309902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35688,-0.0349644) , 
1, 1.78879, 1, 0, 0.500429,-0.00691312)    );
  // itree = 1992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412839,0.00251798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.642228,0.0385587) , 
0, 0.68656, 1, 0, 0.442977,0.0120624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622383,-0.0164462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972439,0.0434847) , 
3, 2.80295, 1, 0, 0.663139,-0.0202183) , 
0, 1.20503, 1, 0, 0.49711,0.00412527)    );
  // itree = 1993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650152,0.0209459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349706,-0.0146319) , 
1, -1.01826, 1, 0, 0.39422,-0.0193214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612854,0.0120921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727678,-0.0130566) , 
2, 1.33477, 1, 0, 0.636044,0.0116849) , 
0, 0.394028, 1, 0, 0.497096,-0.00613077)    );
  // itree = 1994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355262,0.00137519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57686,-0.0228866) , 
0, -0.370645, 1, 0, 0.446454,-0.0176384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526611,0.0330014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.891053,0.00344852) , 
3, 1.39427, 1, 0, 0.751358,0.0313103) , 
0, 1.12677, 1, 0, 0.5273,-0.00465952)    );
  // itree = 1995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155652,-0.0124431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452312,0.0196227) , 
0, -2.25031, 1, 0, 0.38519,0.0283304) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471766,-0.0473469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673716,0.000548829) , 
0, -0.18957, 1, 0, 0.641656,-0.0170758) , 
2, 0.0207206, 1, 0, 0.518793,0.00467656)    );
  // itree = 1996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474096,0.00464023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781459,-0.0153209) , 
2, 1.33839, 1, 0, 0.500661,0.0052677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484827,0.0392628) , 
1, 1.83797, 1, 0, 0.499959,0.0084206)    );
  // itree = 1997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558211,-0.00462191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319949,-0.0486964) , 
1, -0.613272, 1, 0, 0.521447,-0.0267319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174062,-0.0178892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620802,0.00874282) , 
2, -0.665055, 1, 0, 0.478391,0.00242286) , 
1, -0.480148, 1, 0, 0.492473,-0.00711275)    );
  // itree = 1998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62589,0.0363304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713456,-0.0133414) , 
0, 0.386669, 1, 0, 0.664167,0.0260899) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484357,-0.00187259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329052,-0.0243214) , 
1, 1.37686, 1, 0, 0.462202,-0.0097191) , 
1, -0.810577, 1, 0, 0.497034,-0.00354323)    );
  // itree = 1999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596688,-0.0512824) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464044,-0.0348077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488824,0.00629241) , 
1, -1.17074, 1, 0, 0.485772,0.00309062) , 
1, -1.95228, 1, 0, 0.489388,-0.00119183)    );
   return;
};

// Clean up
inline void ReadBDTG::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTG::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
