// Class: ReadSVM
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : SVM::SVM
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:08:57 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
VarTransform: "Norm" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
Gamma: "2.500000e-01" [RBF kernel parameter: Gamma (size of the Kernel)]
Tol: "1.000000e-03" [Tolerance parameter]
# Default:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VerbosityLevel: "Default" [Verbosity level]
H: "False" [Print method-specific help message]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
Kernel: "RBF" [Pick which kernel ( RBF or MultiGauss )]
Order: "3" [Polynomial Kernel parameter: polynomial order]
Theta: "1.000000e+00" [Polynomial Kernel parameter: polynomial theta]
GammaList: "" [MultiGauss parameters]
Tune: "All" [Tune Parameters]
KernelList: "None" [Sum or product of kernels]
Loss: "hinge" [Loss function]
C: "1.000000e+00" [Cost parameter]
MaxIter: "1000" [Maximum number of training loops]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadSVM : public IClassifierReader {

 public:

   // constructor
   ReadSVM( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadSVM" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -1;
      fVmax[0] = 1;
      fVmin[1] = -1;
      fVmax[1] = 1;
      fVmin[2] = -1;
      fVmax[2] = 1;
      fVmin[3] = -1;
      fVmax[3] = 0.99999988079071;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadSVM() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   double fOff_1[3][4];
   double fScal_1[3][4];
   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   // not implemented for class: "ReadSVM"
   float        fBparameter;
   int          fNOfSuppVec;
   static float fAllSuppVectors[][1146];
   static float fAlphaTypeCoef[1146];

   // Kernel parameter(s) 
   float fGamma;
};

inline void ReadSVM::Initialize() 
{
   fBparameter = -0.162949949502945;
   fNOfSuppVec = 1146;
   fGamma = 0.25;
}

inline double ReadSVM::GetMvaValue__(const std::vector<double>& inputValues ) const
{
   double mvaval = 0; 
   double temp = 0; 

   for (int ievt = 0; ievt < fNOfSuppVec; ievt++ ){
      temp = 0;
      for ( unsigned int ivar = 0; ivar < GetNvar(); ivar++ ) {
         temp += (fAllSuppVectors[ivar][ievt] - inputValues[ivar])  
               * (fAllSuppVectors[ivar][ievt] - inputValues[ivar]); 
      }
      mvaval += fAlphaTypeCoef[ievt] * exp( -fGamma * temp ); 
   }
   mvaval -= fBparameter;
   return 1./(1. + exp(mvaval));
}
// Clean up
inline void ReadSVM::Clear() 
{
   // nothing to clear 
}

float ReadSVM::fAlphaTypeCoef[] =
{ -1, 0.58891236782074, -1, -1, -1, -1, 3.32657241821289, 2.18013024330139, 0.0248334426432848, -1, 0.011335433460772, 0.940118849277496, -1, -1, -1, -1, 2.13269019126892, -1, -1, 0.011907871812582, -1, -1, -1, -1, 0.705736100673676, -1, 0.371660768985748, -1, -1, 0.892130255699158, 2.15806913375854, -1, 0.179787963628769, -1, 0.038511399179697, -1, 0.000279079307802022, 0.0536592714488506, -1, 3.33324718475342, 0.106782831251621, 0.0318171270191669, -1, 0.013180473819375, -1, 0.244615092873573, 0.123856388032436, 0.00573757011443377, -1, 1.78156065940857, -1, 2.63460755348206, -1, 0.170236229896545, -1, 0.000873383076395839, 3.33350300788879, 0.0196853503584862, 3.33293008804321, -1, -1, -1, 0.102613791823387, -1, -1, -1, 0.0251902304589748, 0.0394790358841419, -1, -1, -1, 0.000260632776189595, 0.0088065518066287, 0.100062042474747, -1, 0.411309629678726, 1.59163653850555, -1, 0.141127705574036, -1, 1.03443956375122, -1, 0.000887303496710956, -1, -1, -1, -1, -1, -1, 0.0232357829809189, 0.176907330751419, -1, 0.959796607494354, 1.69779586791992, 0.00180632551200688, -1, -1, 3.32893323898315, -1, 0.00164453196339309, 2.41584801673889, 0.104538589715958, 1.22553443908691, 0.0549403093755245, -1, 0.0103032719343901, -1, 1.2156468629837, -1, -0.763225376605988, -1, -1, 0.000925499945878983, 0.00613319966942072, -1, 0.0218079648911953, 2.06319046020508, -1, 0.193859741091728, -1, 1.81326687335968, 3.31452393531799, 0.572782695293427, 0.00819816999137402, 3.08839273452759, 0.00238263187929988, -1, -1, -1, 1.07677841186523, -1, 1.39346587657928, -1, -1, 0.668304026126862, 0.119917564094067, -1, -1, -1, 0.00331885786727071, -1, -1, -1, 3.32345724105835, 3.27754735946655, -1, -1, 2.35811877250671, -1, -1, -1, -1, 0.0044937189668417, 0.0678876712918282, -1, 1.36154985427856, -1, 0.866687178611755, -1, -1, 0.0188229158520699, -1, -1, -1, -1, 0.525494337081909, -1, -1, -1, 0.00521809607744217, -1, 0.517330765724182, 3.24922561645508, -1, 0.114096380770206, 0.00764343282207847, -1, -1, -1, 0.00350870727561414, 2.61799550056458, -1, -1, 0.00180203444324434, -1, -1, 0.000257179694017395, -1, -1, -1, -1, -1, -1, 0.0175298303365707, -1, -1, -1, -1, -1, 0.473331868648529, 2.88288164138794, 3.06986665725708, 2.32404518127441, -1, 0.00123786099720746, 2.50716781616211, 0.00200491398572922, 0.000975666451267898, -1, 2.88700985908508, 0.286558985710144, -1, -1, 0.0006420454592444, -1, -1, -1, 2.59156680107117, -1, -1, 0.0662869289517403, -1, 0.000120312608487438, -1, -1, 0.05619066208601, -1, 3.2140851020813, -1, 0.172119170427322, -1, 2.06551313400269, -1, -1, -1, -1, -1, -1, -1, 2.58888936042786, -1, -1, -1, 3.18898725509644, 0.0152139430865645, -1, -1, -1, 1.24839723110199, 0.000872697797603905, 3.15537357330322, 0.0330317243933678, 2.44227242469788, -1, 0.00164876005146652, -1, 1.24096882343292, -1, -1, 3.27379083633423, 1.53812313079834, -1, -1, -1, 0.00133388733956963, -1, 0.0119423801079392, -1, -1, -1, -1, -1, 3.2625424861908, -1, 0.00186347926501185, 2.71364402770996, -1, -1, 0.00138038175646216, -1, 0.00102852715644985, -1, 2.33093500137329, -1, -1, 0.238808616995811, 0.00871487334370613, 2.12801003456116, -1, 1.16985273361206, 0.0012263935059309, 0.00221355096437037, -1, -1, -1, -1, -1, 0.0202668756246567, -1, -1, -1, 2.00904655456543, -1, -1, 0.141529455780983, -1, -1, 0.633431375026703, 0.196825549006462, 0.0424672290682793, 3.27430009841919, 0.039423231035471, 0.801505208015442, 0.129246354103088, -1, -1, 2.1714940071106, 2.5095431804657, 0.00850124936550856, 1.96805799007416, 0.00166650698520243, -1, -1, -1, -1, -1, -1, 2.72202181816101, 3.28751802444458, 0.148511216044426, -1, -1, 1.42142057418823, 2.84671211242676, -1, 0.00042987844790332, -1, -1, 3.2558057308197, -1, -1, 2.97782254219055, 0.0136259840801358, -1, 0.00781414937227964, -1, 3.31164288520813, 0.135327786207199, -1, 0.0206986106932163, -1, 0.00312026171013713, -1, -1, -1, 0.0558868795633316, 2.89176845550537, -1, 1.73587596416473, 0.00411779386922717, -1, 0.011701893992722, -1, -1, -0.775051712989807, 1.70859158039093, -1, 0.395536512136459, 0.00169445364736021, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3.11019062995911, 0.846134424209595, -1, -1, -1, -1, 0.107140891253948, 1.76474344730377, 3.09549736976624, 0.0195072293281555, -1, -1, 2.45742273330688, 0.12436218559742, -1, 0.355421751737595, -1, 3.26245403289795, -1, -1, -1, -1, -1, 2.91990113258362, -1, -1, 3.11656403541565, 3.16100788116455, -1, 0.0444237254559994, 1.65774214267731, 3.12096405029297, -1, 2.05940413475037, -1, -1, -1, 0.0727169066667557, -1, -1, 2.41313767433167, 0.368921786546707, -1, -1, -1, 0.0554066523909569, 0.367006659507751, -1, 2.38100147247314, -1, 2.97605776786804, 0.935603141784668, 0.233536615967751, 0.0607637204229832, 2.11739349365234, -1, 0.00807831715792418, 3.23119497299194, -1, -1, -1, 3.0046694278717, -1, -1, 0.743999242782593, 3.32633399963379, 0.0197765938937664, -1, -1, 0.898676753044128, 3.20027947425842, 0.00314782047644258, -1, -1, 1.19482016563416, -1, 3.33536601066589, 2.31790661811829, 0.0480214506387711, 0.00911896210163832, 0.00845946557819843, 0.00474510015919805, 0.0010413455311209, 0.17436982691288, 0.0942438766360283, -1, 0.157401561737061, 2.5187771320343, -1, -1, 0.000350450718542561, -1, 0.0012071382952854, 1.15148425102234, -1, 0.219284579157829, -1, 0.0248790923506021, -1, -1, 3.09352016448975, 3.1127290725708, 0.0502238757908344, -1, -1, -1, -1, 0.371297478675842, 0.0763784945011139, 0.474335193634033, -1, -1, 2.65305733680725, -1, -1, -1, 3.28309512138367, -1, 0.000232501071877778, -1, 0.00225554034113884, -1, 0.324744492769241, -1, 0.66821700334549, -1, -1, 1.21443831920624, 0.00514900684356689, 0.0940436646342278, -1, -1, 2.6464855670929, 0.0350827090442181, -1, 3.0995934009552, -1, -1, -1, -1, 0.000959293742198497, 0.0287671331316233, 1.97489595413208, 0.79548305273056, -1, 3.29519152641296, -1, -1, -1, -1, 3.14500045776367, 0.52416867017746, -1, 2.82544636726379, -1, 0.0197668001055717, 0.134819909930229, 0.468393325805664, 0.000239023633184843, -1, 1.74717080593109, 0.00450422801077366, 1.38796389102936, -1, 0.731848061084747, 2.69511318206787, 2.88543653488159, -1, -1, -1, 4.26458536821883e-05, -1, -1, 3.3055694103241, 0.00113022862933576, -1, -1, 1.43628978729248, -1, 0.492798715829849, 0.000206546523259021, -1, -1, 0.000366243388270959, 1.25303113460541, -1, -1, -1, -1, -1, -1, 0.200330913066864, 2.46699833869934, 0.0660854950547218, -1, -1, 0.0680616497993469, -1, 0.580382287502289, 1.11148846149445, -1, -1, -1, -1, -1, 0.00108980829827487, 2.42859292030334, -1, -1, 2.93318629264832, 0.842997610569, 0.0215275697410107, -1, 0.0249214582145214, -1, 0.0282905641943216, -1, 2.74050307273865, 0.00100586679764092, 1.60529375076294, 0.236730575561523, -1, 2.62530493736267, 0.115753918886185, 0.279506742954254, -1, 0.753545999526978, -1, 3.30871081352234, 0.0523581765592098, 0.158689975738525, -1, -1, 0.759929835796356, -1, 0.0880488529801369, 1.15502941608429, 0.0396858602762222, -1, 0.00109107221942395, -1, 0.60170966386795, 0.00545228784903884, -1, -0.729424178600311, 2.42486882209778, -1, 2.34732866287231, -1, -1, 0.252728044986725, -1, 2.26633930206299, -1, -1, 1.70515751838684, -1, -1, -1, -1, -1, -1, -1, 1.70430946350098, 9.49166205828078e-05, -1, -1, 3.08233237266541, -1, -1, 0.0319100134074688, -1, -1, 1.73741459846497, -1, -1, -1, -1, -1, 3.33284211158752, 0.0738438814878464, 0.0181681625545025, 3.09327006340027, -1, 1.32209157943726, -1, -1, 1.01924240589142, -1, 2.11638164520264, 2.30627703666687, -1, 0.00767019018530846, -1, 0.0036052125506103, -1, 2.55372190475464, 0.00429597776383162, 0.5716712474823, 0.0149917909875512, -1, 1.37168371677399, 2.72399091720581, -1, 0.0273621417582035, -1, -1, 1.8381450176239, 3.03929233551025, -1, 0.000538485357537866, 2.29932522773743, 0.00373035878874362, -1, 0.0177622642368078, -1, -1, -1, 0.559627056121826, 0.472822993993759, -1, 0.667658686637878, -1, -1, 0.000998827163130045, -1, 3.13368105888367, -1, 0.922881603240967, -1, 2.51787996292114, -1, 3.17386436462402, -1, -1, -1, 0.00698914751410484, -1, -1, -1, -1, 0.00642646430060267, 0.000768194033298641, 1.87615382671356, 1.80589067935944, 0.636343061923981, 0.00847079697996378, -1, -1, -1, -1, 0.00474030710756779, 2.30755114555359, 2.73269701004028, -1, 3.33621120452881, -1, -1, 0.173811122775078, 3.27356052398682, -1, 0.00640331860631704, 3.02968001365662, -1, -1, 1.20074224472046, -1, -1, -1, -1, 3.09769654273987, 0.0477617457509041, -1, 3.26353454589844, 1.64328265190125, 1.16197657585144, 0.179782792925835, 0.328260123729706, 1.30510032176971, -1, -1, -1, -1, 3.04448890686035, 3.22076845169067, -1, -1, 0.0204530712217093, -1, -1, -1, 3.31884813308716, 0.0030758602079004, -1, -1, 0.0567190870642662, -1, -1, 0.869561612606049, 0.00149276875890791, -1, -1, -1, -1, -1, 0.00615094229578972, -1, 0.0244246497750282, 0.01495302002877, -1, -1, 2.24801349639893, -1, 0.00103501731064171, -1, -1, -1, -1, 0.0021847418975085, -1, 2.77637910842896, 3.1284396648407, -1, 0.00594452442601323, 0.000888257054612041, -1, -1, 1.2349956035614, -1, 0.00625909399241209, -1, -1, -1, -1, 0.000493169471155852, -1, -1, -1, -1, -1, -1, -1, 0.0137222297489643, -1, 0.000961561861913651, 1.57251000404358, 2.48978519439697, 0.00798098836094141, 0.0277299452573061, 2.47774744033813, -1, -1, 1.29019403457642, 0.00705758202821016, 3.25788879394531, -1, -1, 3.04683399200439, -1, 3.2600109577179, 0.0829407125711441, 0.235125452280045, 0.158991813659668, 0.560238659381866, -1, 3.24803924560547, -1, -1, 0.0242635961622, 0.00180212361738086, -1, 3.11708045005798, 0.267817109823227, -1, -1, 0.00960151664912701, 3.3363139629364, 0.00119763321708888, -1, -1, -1, -1, 1.93560004234314, -1, 0.000315245881211013, -1, 2.80088925361633, -1, 0.79332172870636, -1, -1, 0.513907015323639, -1, -1, 0.000744473771192133, -1, -1, -1, -1, -1, 3.30523157119751, -1, -1, 0.0811935067176819, 0.87176102399826, 1.50363147258759, 0.0870008245110512, -1, -1, -1, -1, 0.173362106084824, 0.0347182638943195, -1, -1, -1, 0.00795665383338928, -1, -1, -1, 2.89753270149231, -1, -1, 0.0527991279959679, 0.0128796407952905, -1, 0.00774239748716354, 2.87012004852295, 0.420677959918976, 2.98152565956116, -1, -1, -1, 0.698916673660278, 3.25179982185364, -1, -1, 0.0312516875565052, -1, -1, -1, 0.0419028699398041, 0.000659404147882015, 0.000776398635935038, -1, 2.90295076370239, 0.590073943138123, 1.12070822715759, 2.63835692405701, 2.69870257377625, -1, -1, -1, -1, -1, -1, -1, 2.12956118583679, 0.01667988486588, 0.00124611356295645, 0.0450356043875217, 0.000793636194430292, 0.00194547616411, 0.000966752995736897, 2.23626923561096, 0.00483634974807501, -1, 0.00383651000447571, 1.9916900396347, 2.67510104179382, -1, -1, 8.44944952405058e-05, 0.00231173424981534, -1, 3.18411803245544, -1, 2.02915072441101, 2.16198968887329, -1, -1, 2.15274500846863, 0.00129549799021333, 0.561599433422089, -1, 2.12406444549561, -1, -1, -1, -1, 0.000338682468282059, -1, 0.266916960477829, 0.000877180835232139, -1, 0.0746130049228668, -1, -1, 0.0716999173164368, -1, -1, 0.0914014428853989, 0.0183145776391029, -1, -1, -1, 2.48626279830933, -1, -1, 1.6142452955246, 1.05233466625214, 2.54576945304871, -1, 2.26160335540771, 3.33278608322144, -1, 0.0425966866314411, 0.0286971740424633, -1, -1, -1, 0.0039004567079246, 0.21227453649044, 0.0281932707875967, 1.77572131156921, 0.0455590225756168, -1, -1, 2.75059819221497, -1, 0.240694627165794, 0.685723125934601, -1, 0.430656880140305, -1, -1, -1, -1, 2.69769072532654, -1, 0.0141070848330855, 1.30602121353149, -1, -1, -1, 0.902549386024475, 0.000125565304188058, -1, 2.71601486206055, 1.19855272769928, 0.123133935034275, 0.201501682400703, -1, 2.59155607223511, 1.32094705104828, -1, 1.97620606422424, 0.783001363277435, -1, 1.13639914989471, 0.000834484817460179, -1, -1, -1, -1, -1, -1, 0.00129838171415031, 0.174732446670532, -1, -1, -1, 0.212973654270172, -1, -1, 0.0242918375879526, -1, -1, 0.359970211982727, -1, -1, 0.0144110526889563, 2.94743227958679, 2.98636412620544, -1, 1.99484980106354, 3.14429616928101, -1, -1, -1, -1, -1, -1, 2.67247915267944, -1, 3.12329339981079, -1, -1, -1, 0.171522229909897, -1, -1, 1.01408851146698, 0.791299343109131, 0.249892592430115, 0.0726642683148384, -1, 0.0020388844422996, 3.2871253490448, -1, -1, -1, -1, -1, 0.163356095552444, -1, 0.0305980332195759, -1, -1, -1, -0.0393145605921745, 1.34778046607971, -1, 0.539095759391785, -1, -1, -1, -1, -1, -1, 0.0773452892899513, -1, -1, -1, 0.0260449517518282, -1, -1, -1, 3.0626859664917, 0.263946622610092, -1, 2.82235717773438, 3.21002650260925, 0.0164807420223951, 0.00753710186108947, -1, 3.25052833557129, 1.12459325790405, 0.00217341515235603, 0.788460195064545, -1, -1, -1, -1, -1, -1, 3.1528103351593, -1, 0.00905134715139866, 2.01833915710449, 2.66220283508301, -1, 0.0720017626881599, 0.0276637244969606, 1.79281234741211, -1, 3.33359813690186, 3.11961507797241 };

float ReadSVM::fAllSuppVectors[][1146] =
{
   { -0.0432618856430054, 0.331353664398193, 0.0245450735092163, -0.192955553531647, 0.00267410278320312, 0.145846009254456, 0.0170166492462158, 0.140092492103577, 0.788266539573669, 0.0765235424041748, 0.636026263237, 0.282410979270935, 0.0747554302215576, 0.155218124389648, 0.110681533813477, 0.173268675804138, 0.276351809501648, 0.0210148096084595, -0.375869989395142, 0.605816125869751, 0.331453084945679, 0.0236133337020874, -0.0442760586738586, 0.0510231256484985, 0.338021874427795, 0.241048574447632, 0.516566634178162, -0.0582412481307983, -0.149460971355438, 0.274270534515381, -0.280130743980408, -0.087454617023468, 0.513113379478455, -0.0205279588699341, 0.605478167533875, -0.160024285316467, 0.826820015907288, 0.524408221244812, 0.210765361785889, -0.0559138059616089, 0.656734108924866, 0.597712397575378, 0.255637168884277, 0.583791017532349, 0.210993051528931, 0.359284043312073, 0.440669059753418, 0.684544086456299, 0.132448673248291, 0.282546520233154, 0.358363509178162, 0.164147734642029, 0.0800415277481079, 0.488705277442932, 0.394057631492615, 0.696816802024841, 0.030875563621521, 0.749214887619019, -0.0183078050613403, 0.23452889919281, 0.133352518081665, 0.328164458274841, 0.55164635181427, 0.197337031364441, 0.301570415496826, 0.107788801193237, 0.560984015464783, 0.51242983341217, -0.26870733499527, 0.014197826385498, -0.0898649096488953, 0.908763647079468, 0.652807593345642, 0.493786573410034, -0.0119401812553406, 0.549319267272949, 0.260572075843811, -0.0127127766609192, 0.546858429908752, -0.0101821422576904, 0.240439891815186, 0.316973924636841, 0.795234084129333, 0.171233057975769, -0.248315036296844, -0.0426389575004578, 0.321637511253357, -0.0503448843955994, -0.171507358551025, 0.604544639587402, 0.498754739761353, 0.0303517580032349, 0.198526501655579, 0.374214768409729, 0.645588397979736, 0.277402997016907, 0.114694833755493, -0.0359055399894714, 0.121343374252319, 0.642880201339722, 0.186127901077271, 0.487464189529419, 0.431632161140442, 0.580701947212219, 0.0666605234146118, 0.676586627960205, 0.405419111251831, 0.246723890304565, 0.0776194334030151, 0.151293396949768, 0.36092746257782, -0.0349825024604797, 0.61806333065033, 0.646853446960449, -0.0306114554405212, 0.657048940658569, 0.173992276191711, 0.108770251274109, 0.52801501750946, 0.268322825431824, 0.38361132144928, 0.105206370353699, 0.415309190750122, 0.75418758392334, 0.0599257946014404, 0.75868833065033, -0.025936484336853, -0.200137197971344, -0.0242910981178284, 0.292886257171631, 0.0348833799362183, 0.242690920829773, 0.153679132461548, 0.368938684463501, 0.332332968711853, 0.565750241279602, -0.141196489334106, 0.173904657363892, -0.0741468071937561, 0.728018164634705, -0.130697846412659, 0.0368360280990601, 0.352794528007507, -0.129711508750916, 0.146747946739197, 0.111603379249573, -0.00786542892456055, 0.337937831878662, 0.178590178489685, 0.0685815811157227, -0.120206952095032, -0.0170670747756958, 0.78405749797821, 0.519180297851562, -0.0509276986122131, 0.226336598396301, 0.0494600534439087, 0.318907499313354, -0.0814380049705505, 0.195618391036987, 0.571434020996094, 0.251868724822998, 0.039908766746521, 0.0349313020706177, 0.160307645797729, 0.33992063999176, -0.0910393595695496, 0.0865110158920288, -0.287763297557831, 0.713874340057373, 0.0120716094970703, 0.309322953224182, 0.0226095914840698, -0.000265002250671387, 0.471500039100647, 0.688490390777588, 0.100819706916809, -0.0291897058486938, 0.0379118919372559, 0.588964700698853, -0.215469896793365, 0.303878307342529, -0.052842915058136, 0.810271143913269, -0.0182157754898071, 0.490698933601379, 0.863227248191833, -0.178211450576782, 0.00737428665161133, -0.0579943060874939, 0.116798758506775, 0.308990955352783, 0.184539198875427, 0.571335554122925, 0.0553792715072632, 0.0901906490325928, 0.183265566825867, 0.0424261093139648, 0.0645749568939209, 0.497021317481995, -0.192128419876099, 0.136717081069946, 0.166146159172058, -0.139350473880768, 0.774905562400818, 0.105755925178528, 0.764650583267212, 0.767158269882202, -0.26714700460434, 0.115668058395386, 0.514064192771912, 0.131604075431824, 0.194653630256653, 0.79082190990448, 0.107913017272949, 0.148106932640076, 0.00950837135314941, 0.114324927330017, 0.343551397323608, 0.0988303422927856, 0.582552909851074, 0.228569984436035, 0.767482042312622, 0.176856875419617, 0.0997868776321411, 0.65916383266449, 0.139701247215271, 0.119991302490234, 0.409454584121704, 0.480917811393738, 0.0950707197189331, 0.214254140853882, 0.337626934051514, 0.220088243484497, 0.255135536193848, 0.305685520172119, 0.0184195041656494, 0.0425299406051636, -0.20338499546051, 0.156859517097473, 0.163338541984558, -0.10650908946991, 0.209543108940125, -0.00240951776504517, 0.63684618473053, 0.264199137687683, 0.317139267921448, 0.163414239883423, 0.183313131332397, 0.806874632835388, 0.0885146856307983, 0.634228110313416, 0.0908291339874268, 0.200749516487122, 0.838272333145142, 0.422430634498596, 0.311365485191345, -0.412592709064484, 0.081310510635376, 0.0774070024490356, 0.278024911880493, 0.0846412181854248, 0.440149784088135, 0.0427646636962891, 0.733067393302917, 0.512084364891052, 0.692110657691956, -0.116324126720428, -0.00407516956329346, 0.162556886672974, 0.15324604511261, 0.106218218803406, -0.000232160091400146, -0.0241309404373169, 0.835090041160583, 0.0835535526275635, 0.329542875289917, -0.411056220531464, 0.817198276519775, -0.0718438029289246, 0.768932223320007, 0.159542560577393, 0.236070394515991, 0.207475781440735, 0.0656574964523315, 0.454539179801941, 0.746960043907166, 0.104337811470032, -0.0763329267501831, 0.319962739944458, 0.721848130226135, 0.793502330780029, -0.00217986106872559, 0.342933177947998, -0.0619816184043884, 0.225546002388, 0.120665073394775, 0.637944221496582, 0.334384799003601, 0.0438463687896729, 0.091802716255188, 0.320083737373352, 0.313680410385132, 0.115108132362366, 0.580755233764648, 0.301512956619263, -0.0729721784591675, 0.390877962112427, 0.448531866073608, 0.57248330116272, 0.0223630666732788, 0.560721397399902, 0.354962587356567, 0.515780448913574, -0.167586088180542, 0.139510989189148, 0.207340240478516, 0.153256416320801, 0.691954374313354, -0.301926970481873, 0.770248889923096, -0.0305288434028625, -0.224290132522583, 0.410016894340515, 0.00798249244689941, 0.0422533750534058, 0.392362952232361, 0.240054965019226, -0.126539528369904, 0.510918855667114, 0.147223114967346, -0.247080206871033, 0.307776570320129, 0.168548703193665, 0.0115766525268555, 0.843000411987305, 0.246391177177429, 0.250873208045959, 0.00316989421844482, 0.400219559669495, 0.253227710723877, 0.131387233734131, 0.625343441963196, 0.113141775131226, 0.791109085083008, 0.0666778087615967, 0.0159411430358887, 0.581130623817444, -0.0377810597419739, 0.692975878715515, 0.211475491523743, 0.750911116600037, 0.0124707221984863, -0.160322248935699, -0.0197308659553528, 0.576398015022278, -0.161442279815674, 0.137781023979187, -0.273184418678284, 0.634757399559021, -0.0540531873703003, 0.733654379844666, 0.180410146713257, -0.221682786941528, 0.250391006469727, 0.314041495323181, 0.2325519323349, 0.311562776565552, 0.702155232429504, 0.208619594573975, 0.151718497276306, -0.142869234085083, 0.27888548374176, 0.0696513652801514, 0.103331804275513, -0.0654804706573486, 0.40422260761261, 0.108349680900574, 0.124978065490723, 0.271490454673767, 0.0811729431152344, -0.082455575466156, 0.0619184970855713, 0.324044227600098, 0.564679384231567, 0.159334182739258, -0.115078151226044, 0.584251761436462, -0.136921525001526, 0.0156712532043457, 0.130357980728149, 0.614893794059753, 0.0977290868759155, 0.430216670036316, 0.151301980018616, -0.0448178648948669, 0.229910016059875, -0.0603788495063782, 0.179646134376526, -0.123193860054016, 0.099835991859436, -0.0358007550239563, -0.0251975655555725, 0.0314303636550903, 0.044968843460083, 0.115554332733154, -0.0389615893363953, 0.660603404045105, 0.347777128219604, 0.031980037689209, 0.103351831436157, 0.28698992729187, -0.0270109176635742, -0.0358865261077881, 0.0481120347976685, 0.589171886444092, -0.0537624359130859, -0.0744521021842957, 0.0743508338928223, 0.397661209106445, 0.251947641372681, -0.0298638343811035, 0.399973630905151, 0.323015332221985, 0.408492088317871, 0.0391383171081543, 0.246091246604919, 0.0542042255401611, -0.0277235507965088, 0.260319471359253, 0.374794125556946, 0.58806586265564, 0.212592601776123, 0.109409689903259, 0.543133735656738, 0.162752032279968, 0.242497324943542, 0.060105562210083, -0.0406535863876343, -0.0320721864700317, 0.023256778717041, 0.170283555984497, 0.379098057746887, 0.0112415552139282, 0.70940375328064, 0.0470011234283447, 0.127864837646484, -0.383384943008423, 0.0384434461593628, 0.636865973472595, 0.373545169830322, 0.23449969291687, 0.227772355079651, 0.305040597915649, -0.0569241046905518, 0.235841035842896, 0.493128180503845, 0.727356553077698, 0.662160515785217, 0.770848035812378, 0.857948064804077, 0.516226768493652, 0.61025595664978, -0.0315659642219543, 0.581960916519165, 0.198022484779358, 0.133147239685059, -0.205241680145264, 0.86735463142395, -0.222913444042206, 0.62336266040802, 0.352923035621643, 0.0888358354568481, 0.397956132888794, 0.244814038276672, 0.651877403259277, 0.22595739364624, 0.558880925178528, 0.0748395919799805, -0.0103294849395752, 0.743149042129517, 0.139218807220459, 0.175373911857605, -0.103518009185791, 0.351733088493347, 0.417373061180115, 0.443509221076965, 0.505850315093994, 0.42782723903656, 0.153162240982056, -0.210466265678406, -0.0382601618766785, 0.214806437492371, 0.510815978050232, -0.1594517827034, 0.107180237770081, 0.806601881980896, 0.157028555870056, 0.856455445289612, 0.000774860382080078, 0.452467918395996, -0.0928977131843567, 0.322286128997803, 0.272920608520508, -0.0825254917144775, 0.291504383087158, 0.625125885009766, 0.514098882675171, -0.290007770061493, 0.049397349357605, 0.0594452619552612, 0.569763898849487, -0.0025714635848999, -0.0335736870765686, 0.190598726272583, -0.100762367248535, 0.299410581588745, 0.00426948070526123, 0.756933808326721, 0.730009078979492, -0.222527980804443, 0.384513139724731, 0.311541438102722, 0.0223063230514526, 0.0791217088699341, 0.0675829648971558, 0.269006729125977, 0.17932403087616, -0.0634956955909729, 0.379109501838684, -0.173804879188538, -0.0533041954040527, -0.112681329250336, 0.52276873588562, 0.464267611503601, 0.498081922531128, 0.854645967483521, 0.0566214323043823, 0.248769879341125, 0.699203968048096, 0.231132507324219, 0.0773435831069946, 0.350473880767822, -0.239588558673859, 0.165995597839355, 0.253920316696167, 0.117278814315796, 0.114850282669067, 0.860568523406982, 0.0381985902786255, 0.0805975198745728, 0.0483983755111694, 0.800811767578125, 0.181497573852539, -0.0137300491333008, 0.325674891471863, 0.0843789577484131, 0.394200563430786, 0.821806907653809, -0.199639320373535, 0.0860350131988525, 1, 0.286327242851257, 0.0334678888320923, -0.000329256057739258, 0.172594785690308, 0.252131938934326, 0.258443117141724, 0.23402988910675, 0.52915358543396, 0.161154985427856, 0.653658032417297, -0.00485295057296753, 0.0746289491653442, 0.401027321815491, -0.122370541095734, 0.435342788696289, 0.308363556861877, -0.244292557239532, -0.148169457912445, 0.272047638893127, -0.102688193321228, 0.0750761032104492, 0.797159314155579, 0.236249446868896, -0.266449868679047, 0.0944811105728149, 0.145956158638, 0.402756094932556, 0.624424457550049, 0.365373253822327, 0.694997549057007, 0.0177798271179199, 0.682041049003601, -0.0505008101463318, 0.261771440505981, 0.812452912330627, 0.192702174186707, 0.578153729438782, 0.202824354171753, 0.116459131240845, 0.524868845939636, 0.516411781311035, 0.186815142631531, 0.377567768096924, 0.0563106536865234, -0.105710983276367, 0.505470275878906, 0.643211126327515, 0.523168325424194, 0.210678458213806, 0.257167935371399, 0.21873939037323, 0.45590341091156, 0.31783926486969, 0.563112258911133, -0.0306687951087952, 0.81077766418457, 0.0138846635818481, 0.385944843292236, 0.762295365333557, 0.284975051879883, 0.253873348236084, -0.0900214314460754, -0.24202024936676, 0.143425703048706, 0.110432267189026, -0.0899644494056702, 0.618503093719482, 0.0676604509353638, -0.307493388652802, 0.176915645599365, 0.0214747190475464, 0.0947974920272827, 0.118144273757935, 0.173251867294312, 0.196137547492981, 0.0742717981338501, 0.194491624832153, 0.140465021133423, 0.0986398458480835, 0.264925479888916, 0.798968434333801, 0.026679515838623, 0.00224792957305908, -0.186545729637146, -0.0455506443977356, 0.0613663196563721, 0.51380467414856, 0.12029755115509, 0.0895522832870483, -0.274378597736359, 0.185850024223328, -0.00207120180130005, 0.0982156991958618, 0.197938680648804, 0.208288311958313, 0.142811298370361, 0.617074489593506, 0.637799620628357, 0.179428100585938, 0.316847443580627, 0.197152614593506, -0.183883011341095, 0.136962175369263, 0.293696761131287, -0.0748563408851624, 0.125444650650024, 0.110144972801208, -0.0216866135597229, 0.690446615219116, 0.218215465545654, 0.791860342025757, 0.112384915351868, 0.155064582824707, 0.694831728935242, 0.514404058456421, 0.711423873901367, -0.120110511779785, 0.373522758483887, -0.203316926956177, 0.304370880126953, 0.562754154205322, -0.223187208175659, -0.0529576539993286, 0.2923743724823, -0.0218745470046997, 0.327287316322327, 0.936193585395813, 0.164436340332031, 0.647200345993042, 0.159523487091064, 0.600774884223938, 0.13444459438324, 0.0361686944961548, -0.00928819179534912, 0.412953853607178, 0.378775954246521, -0.223831593990326, 0.36790668964386, 0.0896159410476685, 0.175968289375305, 0.694130063056946, 0.587511897087097, 0.06624436378479, 0.185678601264954, 0.288740754127502, 0.210114717483521, 0.0633955001831055, -0.0176341533660889, -0.145743846893311, 0.309644341468811, -0.0996341109275818, 0.190051078796387, 0.6993807554245, 0.225946307182312, -0.0600904226303101, 0.112042665481567, -0.158027648925781, 0.586424946784973, 0.679332494735718, 0.286312580108643, 0.252501130104065, 0.312639355659485, 0.648020029067993, 0.431296586990356, 0.00555908679962158, 0.365899920463562, 0.21126115322113, 0.627911686897278, 0.228207945823669, -0.18622750043869, 0.133610129356384, 0.11855673789978, -0.232595682144165, 0.155948042869568, 0.483362317085266, -0.00355756282806396, -0.049500048160553, 0.738257646560669, 0.113863110542297, -0.116300225257874, 0.149581551551819, -0.330703973770142, -0.0967699289321899, 0.072176456451416, 0.00864958763122559, -0.126343905925751, 0.20727276802063, 0.530884265899658, -0.070147693157196, 0.0341789722442627, 0.26641058921814, 0.352752327919006, 0.476187944412231, 0.358146548271179, 0.267588019371033, 0.0420503616333008, 0.0387831926345825, 0.0458881855010986, 0.314430594444275, 0.0993461608886719, 0.000824928283691406, -0.00115948915481567, -0.168526291847229, 0.56202220916748, -0.271327972412109, 0.31586754322052, 0.196521639823914, -0.0121424198150635, 0.68519115447998, 0.229866743087769, -0.14377748966217, 0.53752601146698, 0.158878922462463, -0.0191782116889954, 0.504907131195068, 0.817654013633728, 0.505977630615234, -0.148539125919342, -0.188219308853149, 0.0609982013702393, 0.182160019874573, 0.65111768245697, -0.0675702691078186, 0.657720804214478, 0.658008456230164, 0.0774480104446411, 0.324579477310181, -0.172906637191772, -0.00883024930953979, 0.788326144218445, -0.0522383451461792, 0.198736190795898, -0.0884037613868713, -0.236946642398834, 0.681463718414307, 0.138348340988159, 0.108003258705139, -0.105644226074219, -0.0661798715591431, 0.712836861610413, 0.724679350852966, 0.230674743652344, 0.0487179756164551, 0.186498165130615, 0.276666402816772, 0.526408195495605, 0.0067744255065918, 0.178187847137451, 0.245537996292114, 0.241362333297729, 0.746014714241028, 0.166743278503418, -0.109469294548035, 0.230506300926208, 0.345379829406738, 0.0601127147674561, 0.218415141105652, 0.104847311973572, 0.711275577545166, 0.121083974838257, 0.837559580802917, 0.182050347328186, 0.124858379364014, 0.638710021972656, 0.500858187675476, 0.25922429561615, -0.0753985047340393, 0.216220021247864, 0.421019911766052, 0.700237154960632, 0.079139232635498, -0.0249018669128418, -0.285047054290771, 0.0121978521347046, -0.06577068567276, 0.0488694906234741, 0.551399946212769, 0.405789017677307, 0.46086859703064, 0.460620045661926, -0.240851104259491, -0.0229800939559937, 0.097339391708374, 0.140697836875916, 0.769742131233215, 0.715900421142578, -0.159935116767883, -0.0920331478118896, 0.371882319450378, 0.171864867210388, 0.0452345609664917, 0.677475452423096, -0.0495560169219971, 0.646578192710876, 0.000183939933776855, -0.103159487247467, 0.255964398384094, 0.165320634841919, 0.220985531806946, 0.346390843391418, 0.957074284553528, 0.0125699043273926, -0.0542445778846741, 0.0319287776947021, 0.352737069129944, -0.0332940220832825, 0.0442581176757812, 0.312014222145081, 0.0858281850814819, 0.171818494796753, 0.832926988601685, 0.0743312835693359, -0.132963716983795, -0.0607810020446777, 0.442670822143555, 0.273683071136475, -0.0915756821632385, -0.270261406898499, 0.233821511268616, 0.584897398948669, 0.185207486152649, 0.145130753517151, 0.640485167503357, 0.0664347410202026, 0.0102168321609497, 0.1721111536026, 0.165744662284851, 0.561625957489014, 0.651799440383911, 0.0457594394683838, -0.108757495880127, 0.0744367837905884, 0.747391939163208, -0.0776051878929138, 0.424721956253052, 0.0701577663421631, 0.216886758804321, -0.0865925550460815, 0.243701577186584, 0.476951837539673, 0.6898273229599, 0.130917429924011, 0.626660823822021, 0.170864224433899, 0.328627467155457, 0.138921737670898, 0.233540534973145, 0.372425675392151, -0.23489385843277, 0.452691078186035, 0.151240348815918, 0.390671730041504, 0.196157217025757, 0.568396925926208, -0.216473281383514, -0.0634469985961914, 0.0734062194824219, 0.533506512641907, 0.790933609008789, 0.985153794288635, 0.155909895896912, 0.180490970611572, 0.440484404563904, 0.270473599433899, -0.266309678554535, 0.173896074295044, 0.0119870901107788, -0.11737447977066, -0.274258613586426, 0.128734707832336, 0.116494655609131, 0.0313553810119629, -0.286088943481445, 0.265750288963318, 0.589177012443542, 0.726915121078491, 0.460675835609436, 0.83293092250824, 0.774091362953186, 0.602487564086914, 0.226833820343018, 0.559927225112915, 0.0437932014465332, 0.795314431190491, 0.201789140701294, 0.0966510772705078, 0.193586468696594, 0.0802397727966309, 0.834031224250793, 0.783188104629517, 0.137767314910889, 0.0398483276367188, -0.0653456449508667, 0.219638466835022, 0.238810300827026, 0.0751349925994873, -0.09744793176651, 0.206801295280457, 0.817872166633606, 0.398005366325378, -0.026579737663269, 0.136651515960693, 0.168074369430542, 0.316352248191833, 0.199859499931335, 0.167728543281555, 0.730138182640076, 0.204642772674561, 0.414893269538879, 0.823649048805237, 0.04236900806427, 0.682488918304443, -0.150326371192932, 0.348489880561829, 0.550599098205566, -0.126773059368134, -0.151887178421021, 0.543533086776733, 0.59367561340332, 0.188146710395813, -0.0991675853729248, -0.077955424785614, -0.161142826080322, 0.189796924591064, -0.251650631427765, 0.278605222702026, 0.263231039047241, 0.250561475753784, -0.186058163642883, 0.207127213478088, 0.0180554389953613, -0.0373767018318176, 0.575541973114014, 0.509768962860107, 0.200076937675476, -0.112800538539886, 0.16823136806488, 0.669364929199219, 0.371098518371582, 0.521982073783875, 0.256150841712952, 0.520607113838196, 0.256701350212097, 0.280689358711243, 0.0695055723190308, -0.257163226604462, 0.389183044433594, 0.314693450927734, 0.141703367233276, 0.410154104232788, 0.0711683034896851, 0.0798895359039307, 0.0815243721008301, 0.388118147850037, 0.239062905311584, 0.0343207120895386, 0.611745715141296, 0.199259638786316, 0.259379744529724, -0.142256915569305, 0.0401405096054077, 0.183276653289795, 0.904894113540649, 0.164245843887329, 0.11514139175415, 0.292813420295715, 0.32754111289978, 0.425105571746826, 0.106330990791321, -0.296980142593384, 0.276187300682068, 0.0140225887298584, 0.277499556541443, 0.331037044525146, -0.0923735499382019, 0.108880758285522, 0.680407762527466, 0.342164874076843, 0.0809694528579712, 0.263173580169678, 0.243624329566956, 0.14331579208374, -0.0987980365753174, 0.763283133506775, 0.286405801773071, 0.005240797996521, 0.158971190452576, 0.226946234703064, 0.519793391227722, 0.16516387462616, -0.1933434009552, 0.60930073261261, -0.141693651676178, 0.0400426387786865, 0.469356775283813, -0.00968128442764282, 0.188770890235901, 0.638275504112244, 0.0283070802688599, 0.167768597602844, 0.119465589523315, 0.154256224632263, 0.00932192802429199, 0.349346280097961, 0.212756872177124, 0.0813720226287842, 0.124711394309998, -0.0207334160804749, -0.0126938819885254, 0.224883675575256, 0.303165435791016, 0.0804332494735718, -0.109732031822205, 0.200595259666443, 0.153347849845886, 0.497417092323303, 0.00614631175994873, 0.0576554536819458, 0.388373136520386, 0.531431794166565, 0.494832992553711, 0.525301933288574, 0.0348278284072876, 0.671851754188538, 0.0136685371398926, -0.0192726254463196, 0.431859731674194, 0.00944423675537109, -0.0428617000579834, -0.0206471085548401, 0.486328482627869, 0.242252469062805, 0.692816853523254, -0.14953202009201, 0.0861357450485229, 0.256917834281921, -0.0923681259155273, 0.308702707290649, -0.057526707649231, 0.455195546150208, 0.111146330833435, 0.0629715919494629, -0.0217489004135132, 0.177229404449463, 0.125843405723572, 0.140147686004639, 0.427732706069946, 0.0811784267425537, -0.069219172000885, -0.241424024105072, 0.605619072914124, 0.145131945610046, -0.0344277024269104, 0.352004647254944, -0.179789483547211, 0.431415200233459, 0.12152624130249, 0.162764549255371, -0.0498475432395935, 0.665115356445312, 0.654819488525391, 0.0803654193878174, 0.0538918972015381, 0.30045473575592, 0.814221620559692, 0.336666464805603, 0.251378774642944, 0.176346182823181, 0.0880405902862549, 0.0561827421188354, 0.224220037460327, 0.32917845249176, -0.0269256830215454, 0.276096105575562, 0.571518301963806, 0.165351748466492, 0.204812526702881, 0.0919960737228394, 0.454237222671509, 0.563814997673035, -0.263742089271545, -0.0728962421417236, -0.0420186519622803, -0.106210827827454 }, 

   { -0.212230503559113, 0.196073293685913, 0.0951623916625977, 0.0313032865524292, -0.786212503910065, 0.0467623472213745, -0.0429826974868774, -0.157655775547028, -0.524956583976746, -0.486702263355255, 0.0309889316558838, 0.267836451530457, -0.162570953369141, 0.0615693330764771, 0.273849606513977, 0.239494919776917, 0.244511961936951, -0.393868267536163, -0.0482600331306458, 0.277207970619202, -0.42087709903717, -0.33961820602417, -0.548857808113098, -0.155453264713287, 0.39313542842865, 0.0924496650695801, -0.583795309066772, 0.0812094211578369, 0.0982794761657715, 0.0968664884567261, -0.525306165218353, -0.381880223751068, 0.338173151016235, -0.0476025342941284, -0.44932234287262, -0.200147569179535, -0.200604200363159, -0.0240663290023804, 0.0360107421875, 0.221151232719421, 0.230573415756226, 0.193664312362671, -0.0855011940002441, 0.804769992828369, 0.0927748680114746, 0.132890105247498, -0.0305417776107788, 0.584562063217163, -0.318986177444458, -0.292309820652008, 0.268425107002258, -0.0141664147377014, -0.185789942741394, 0.269850015640259, 0.580278635025024, 0.305788636207581, -0.231858789920807, -0.681122541427612, -0.270887017250061, -0.0134481191635132, -0.465048611164093, -0.0407201051712036, -0.267880201339722, 0.262887239456177, -0.447631478309631, -0.523892164230347, -0.0145539045333862, 0.212823033332825, 0.0356507301330566, -0.217171370983124, -0.347058296203613, -0.0682268738746643, 0.288409829139709, -0.0260645747184753, -0.0500971674919128, -0.0302274227142334, 0.070855975151062, -0.249494671821594, 0.0284509658813477, -0.369689345359802, -0.148878872394562, -0.241602718830109, -0.160707294940948, -0.653972387313843, -0.280937373638153, -0.114595890045166, -0.244802534580231, 0.245747327804565, 0.196566820144653, 0.0481621026992798, -0.232756435871124, -0.240872979164124, -0.127031028270721, -0.131594240665436, -0.1158726811409, -0.0798475742340088, 0.056682825088501, 0.00570321083068848, -0.0260083675384521, -0.0163543820381165, -0.0955588817596436, 0.21289598941803, 0.23956036567688, 0.189395546913147, -0.488302946090698, 0.533840775489807, -0.415193498134613, 0.558329105377197, 0.196231961250305, -0.560425996780396, 0.143056869506836, 0.100085377693176, 0.693655371665955, 0.176027059555054, -0.170380115509033, -0.120328307151794, -0.164368510246277, 0.203601121902466, 0.536087274551392, -0.200513362884521, -0.211506247520447, -0.185071885585785, 0.52544367313385, 0.0918219089508057, 0.19331681728363, 0.218168377876282, -0.178862631320953, 0.185796976089478, -0.138928592205048, 0.0381215810775757, -0.325467467308044, -0.0881768465042114, 0.503806114196777, -0.00100827217102051, -0.110208630561829, 0.044466495513916, -0.476121187210083, 0.44105339050293, -0.0737662315368652, -0.0462308526039124, -0.328447639942169, 0.265699028968811, 0.0667239427566528, 0.691407680511475, -0.527768492698669, -0.0261424779891968, -0.579279541969299, -0.610986351966858, 0.0908641815185547, -0.262538909912109, -0.242209076881409, 0.347554326057434, 0.221951127052307, -0.0506104826927185, -0.276489436626434, -0.39758038520813, -0.542930245399475, 0.209729433059692, -0.487478911876678, 0.297029376029968, 0.12572705745697, -0.115450024604797, 0.229050397872925, -0.0753916501998901, 1, -0.303021907806396, -0.0469603538513184, -0.0631935596466064, -0.448545336723328, 0.69750452041626, -0.349450647830963, -0.542930901050568, -0.0162917375564575, 0.108366250991821, 0.486655235290527, 0.239158511161804, -0.558462500572205, 0.263672947883606, 0.116315960884094, 0.590970396995544, 0.0274049043655396, 0.0488312244415283, -0.201715707778931, 0.154793739318848, -0.186756253242493, -0.126554489135742, -0.736345887184143, -0.00796908140182495, -0.490222930908203, -0.0895923972129822, -0.406206071376801, 0.262887477874756, 0.191679358482361, 0.141366124153137, -0.729352176189423, 0.10736095905304, -0.00260680913925171, -0.0853474140167236, -0.0188658237457275, 0.197544693946838, 0.3703373670578, 0.149177312850952, -0.205109000205994, -0.320283710956573, -0.20715719461441, 0.193301439285278, 0.505071997642517, 0.708569526672363, -0.0449476838111877, -0.0765020251274109, -0.0361716151237488, 0.133893370628357, -0.385341346263885, 0.219252943992615, 0.0823456048965454, 0.00853061676025391, 0.221345782279968, -0.273758590221405, 0.015137791633606, -0.21878856420517, -0.215126812458038, 0.315677642822266, -0.0779542326927185, -0.374979555606842, -0.00872313976287842, -0.135881066322327, 0.225931763648987, -0.315578639507294, -0.518013715744019, -0.478200554847717, -0.140856623649597, -0.0402522087097168, -0.508904218673706, -0.00822848081588745, 0.0937331914901733, -0.0771428346633911, 0.107987403869629, -0.139879882335663, -0.619240820407867, 0.238295316696167, -0.0630725026130676, -0.203050255775452, 0.0678797960281372, -0.366079151630402, -0.650493860244751, -0.235983848571777, 0.151978373527527, -0.18712991476059, 0.161148428916931, -0.615324378013611, 0.285858869552612, -0.116773307323456, -0.0689144134521484, 0.590857148170471, -0.401607632637024, 0.49597179889679, 0.275098085403442, -0.302736341953278, -0.35307788848877, -0.00608789920806885, 0.0536739826202393, -0.237842500209808, -0.290842056274414, -0.4923175573349, -0.167719900608063, -0.250848293304443, 0.113767147064209, 0.0909290313720703, -0.304725587368011, 0.256519675254822, 0.659276723861694, -0.319004476070404, -0.421675205230713, 0.323761224746704, -0.226451575756073, 0.134601354598999, -0.110515654087067, -0.503934860229492, 0.598440170288086, -0.451622426509857, -0.00155377388000488, -0.0316519141197205, -0.326196908950806, 0.336615800857544, 0.0590311288833618, 0.0189270973205566, 0.027118444442749, 0.50368332862854, -0.0174662470817566, -0.278077244758606, -0.298197448253632, -0.396018743515015, 0.0516506433486938, -0.474012494087219, 0.243832945823669, -0.619796872138977, -0.0789920091629028, 0.172192692756653, -0.311554431915283, -0.00514638423919678, -0.510980188846588, -0.130852878093719, 0.183775186538696, -0.00054323673248291, 0.0716596841812134, -0.12547093629837, -0.175831615924835, -0.0818136930465698, 0.210585117340088, 0.379477977752686, -0.202359020709991, 0.217043995857239, 0.0795503854751587, -0.394042313098907, -0.410525798797607, 0.0477068424224854, -0.297395944595337, 0.248145222663879, -0.391248226165771, -0.149479568004608, 0.209045052528381, -0.135011672973633, -0.668985486030579, -0.45700991153717, -0.260644733905792, -0.466767489910126, 0.172771096229553, -0.0316187739372253, 0.0704852342605591, 0.163582444190979, 0.0598050355911255, -0.121744871139526, 0.177038669586182, 0.0404943227767944, -0.189037442207336, -0.463275909423828, -0.445343017578125, 0.00145912170410156, -0.00356596708297729, 0.0211353302001953, -0.184439599514008, -0.393449425697327, 0.00219380855560303, -0.201717913150787, -0.155279636383057, 0.298571348190308, -0.148615717887878, -0.70836079120636, 0.0977144241333008, 0.120822787284851, -0.223223924636841, 0.228809475898743, 0.274176955223083, -0.35712194442749, -0.421280443668365, -0.354105710983276, -0.254221975803375, -0.0679866671562195, -0.256578922271729, -0.21978747844696, 0.0492856502532959, 0.545697689056396, -0.661672711372375, -0.133782744407654, -0.0159133076667786, -0.139939308166504, -0.05165696144104, 0.0885633230209351, 0.777598977088928, -0.225174844264984, -0.493451714515686, -0.118049621582031, -0.00602596998214722, -0.208484470844269, -0.386048495769501, -0.342049300670624, -0.182003498077393, 0.0749151706695557, -0.235969960689545, 0.202595949172974, -0.266506254673004, -0.100010573863983, -0.111545860767365, 0.278805017471313, 0.0269155502319336, -0.344800651073456, -0.195780694484711, 0.132080316543579, 0.0714066028594971, -0.195845663547516, 0.0211460590362549, -0.278218388557434, -0.365520298480988, -0.250092029571533, 0.197250843048096, 0.156909108161926, -0.176087319850922, -0.529199779033661, -0.110962569713593, 0.0304152965545654, -0.668060421943665, -0.524150013923645, 0.303509950637817, 0.00719368457794189, -0.431670844554901, -0.087322473526001, 0.0485436916351318, 0.0294035673141479, 0.194004774093628, -0.401298761367798, 0.00879049301147461, -0.181977868080139, 0.0308334827423096, 0.137505888938904, -0.411556422710419, 0.388928413391113, -0.0574790239334106, 0.0950366258621216, 0.817655682563782, -0.217681884765625, 0.178920984268188, -0.165610373020172, -0.139759242534637, 0.21475350856781, -0.289384007453918, -0.417209804058075, -0.0664189457893372, 0.305752038955688, 0.425453901290894, -0.0712090134620667, -0.214597463607788, -0.116453170776367, -0.338813722133636, 0.60943877696991, 0.197527050971985, -0.310009658336639, 0.0996100902557373, 0.169013261795044, 0.208807826042175, -0.367608666419983, -0.207904398441315, 0.0135509967803955, 0.120808362960815, -0.330787003040314, 0.394243478775024, -0.304306924343109, 0.370213747024536, -0.426109313964844, 0.158064126968384, -0.133788347244263, -0.677583813667297, -0.360539376735687, -0.185809791088104, -0.627686440944672, -0.204011082649231, -0.11829149723053, 0.0773659944534302, -0.394139289855957, 0.660401582717896, -0.17770379781723, -0.112340033054352, -0.258922338485718, -0.271935522556305, -0.119294106960297, -0.0172877907752991, -0.102370262145996, -0.58032500743866, 0.215218544006348, 0.182755470275879, -0.223118364810944, 0.369758248329163, -0.242545127868652, 0.0662187337875366, -0.41726678609848, -0.106364369392395, 0.0527197122573853, 0.0335723161697388, -0.274267077445984, -0.52666187286377, 0.187145352363586, -0.513443648815155, -0.101834058761597, -0.0871598720550537, -0.113346755504608, -0.265802502632141, -0.0618593096733093, 0.446296811103821, 0.196878552436829, 0.215933442115784, -0.288584530353546, -0.490944683551788, -0.152519762516022, -0.0407568216323853, 0.21644139289856, -0.0258957743644714, -0.446726679801941, 0.371121048927307, 0.468328356742859, -0.306431412696838, 0.0649677515029907, 0.161047339439392, 0.400035977363586, 0.0221103429794312, 0.110109329223633, -0.222601056098938, 0.259174346923828, 0.12779426574707, 0.175464391708374, -0.0345384478569031, -0.386287748813629, 0.0597927570343018, -0.0225815773010254, -0.0613955855369568, 0.0848162174224854, -0.0885257720947266, 0.180418491363525, 0.256751656532288, -0.208160936832428, 0.11841356754303, 0.0722626447677612, -0.277014374732971, -0.495347380638123, 0.0216245651245117, -0.214468717575073, -0.0930365920066833, -0.511631846427917, 0.0559195280075073, 0.194249153137207, 0.044641375541687, 0.316802740097046, -0.731827735900879, -0.470803737640381, 0.014411449432373, -0.356049537658691, 0.238439083099365, -0.351308465003967, -0.173142313957214, -0.456566035747528, 0.111047267913818, 0.117767333984375, -0.0956728458404541, 0.0646898746490479, 0.275398254394531, 0.386879324913025, 0.295570611953735, -0.0533345341682434, -0.440961241722107, -0.576614260673523, 0.0576512813568115, 0.138402581214905, 0.108669996261597, 0.0173389911651611, 0.326500773429871, 0.609172582626343, -0.0782783031463623, -0.375605285167694, -0.0187633633613586, 0.163426280021667, 0.436356425285339, -0.352614104747772, -0.230811476707458, -0.547918260097504, -0.054720401763916, 0.0058135986328125, -0.793804705142975, -0.436944782733917, 0.540987253189087, 0.00186562538146973, -0.328690111637115, -0.0864746570587158, 0.143058657646179, -0.0464237928390503, 0.34403133392334, 0.259091973304749, -0.0219807624816895, -0.202132999897003, -0.532612800598145, 0.749455213546753, -0.376225769519806, 0.220090627670288, 0.243912577629089, 0.358131885528564, -0.386013507843018, 0.220170021057129, -0.0784302949905396, 0.496786952018738, -0.440127849578857, 0.222514390945435, -0.267216205596924, 0.27979052066803, -0.208492577075958, -0.159502625465393, 0.337530493736267, 0.267209887504578, -0.0132683515548706, -0.0864439010620117, 0.100562930107117, -0.378935158252716, -0.180270493030548, -0.122103869915009, -0.445903539657593, -0.16529780626297, -0.480602860450745, -0.379768788814545, -0.00369781255722046, -0.101277232170105, -0.0354831218719482, 0.555198907852173, -0.0228174924850464, -0.0139338374137878, -0.388774514198303, 0.265386343002319, 0.219881415367126, 0.218288421630859, -0.284563958644867, 0.23697292804718, -0.00377410650253296, -0.0075918436050415, -0.246537625789642, 0.0101205110549927, -0.383671998977661, -0.23189502954483, -0.146100163459778, -0.730454206466675, -0.0456008315086365, 0.18767774105072, 0.172300934791565, -0.267235934734344, -0.435343742370605, -0.140756011009216, -0.125330865383148, 0.187087297439575, -0.0848791599273682, -0.27727347612381, -0.130336582660675, -0.197500169277191, 0.139096140861511, -0.375333428382874, -0.461638271808624, -0.191365838050842, -0.706841468811035, -0.220095634460449, 0.0429931879043579, -0.741325616836548, -0.759499251842499, -0.283392786979675, -0.10139125585556, -0.21558803319931, -0.0578082203865051, -0.219467759132385, 0.0848153829574585, -0.556882500648499, 0.392823219299316, -0.0326955318450928, -0.0329822897911072, -0.108033180236816, -0.257869064807892, -0.417759120464325, 0.283710598945618, 0.0519717931747437, -0.349320769309998, -0.199739873409271, -0.041754424571991, -0.210865378379822, -0.447986721992493, -0.856893658638, 0.0224943161010742, -0.24284952878952, 0.600028991699219, -0.0764667391777039, 0.380530834197998, -0.428580760955811, -0.209781229496002, -0.351357161998749, 0.145645976066589, -0.0789649486541748, -0.309275925159454, 0.101964592933655, -0.230112791061401, -0.400686979293823, -0.0224252939224243, 0.25186824798584, -0.284356713294983, -0.216879606246948, -0.199860811233521, -0.427203714847565, -0.726640343666077, -0.288150608539581, -0.129806399345398, 0.323130249977112, -0.171122133731842, -0.472882509231567, 0.339303255081177, 0.283837199211121, 0.0982452630996704, 0.0750595331192017, -0.105406880378723, -0.0852792859077454, 0.279598355293274, -0.0951152443885803, 0.341126203536987, -0.210036396980286, 0.372758746147156, 0.0421112775802612, -0.443331241607666, 0.261852502822876, -0.451784610748291, -0.141274034976959, 0.0378599166870117, 0.0646888017654419, 0.290754079818726, -0.33690071105957, -0.0309525728225708, -0.330678641796112, -0.0716592073440552, 0.291812896728516, -0.0372844338417053, -0.411030352115631, 0.270772337913513, 0.343398213386536, -0.00139665603637695, -0.0816388726234436, -0.121974229812622, -0.26600593328476, -0.0621154308319092, -0.106040060520172, -0.32315057516098, 0.285111784934998, -0.0383090376853943, 0.627504944801331, -0.291963398456573, -0.0889185070991516, 0.267274141311646, -0.788995921611786, -0.253185093402863, -0.0809541344642639, 0.430048823356628, -0.081591010093689, 0.274120092391968, 0.136754870414734, 0.193999886512756, -0.987590074539185, -0.13798600435257, -0.297491788864136, 0.131953954696655, -0.292741894721985, 0.208379983901978, -0.481744587421417, -1, -0.430513799190521, -0.378186941146851, -0.022177517414093, -0.187199711799622, -0.313484728336334, -0.324527084827423, -0.0507038831710815, -0.0570344924926758, 0.755115389823914, -0.0266395211219788, -0.229343354701996, -0.53659451007843, 0.0340689420700073, 0.148324847221375, -0.182041883468628, 0.304498076438904, 0.166576743125916, 0.362067699432373, 0.146356463432312, 0.137787818908691, 0.144392609596252, -0.201372504234314, -0.223074436187744, 0.0119166374206543, -0.747320652008057, 0.465700626373291, 0.275674343109131, -0.0950070023536682, -0.185063242912292, 0.244830012321472, -0.267235279083252, -0.354979157447815, 0.136516451835632, 0.298804879188538, 0.188135147094727, -0.360511720180511, 0.246156930923462, -0.137170732021332, 0.142121553421021, -0.0366834998130798, -0.304562985897064, -0.218304812908173, -0.366020560264587, -0.183250665664673, -0.206008732318878, -0.339043915271759, 0.0556038618087769, -0.278782665729523, 0.190220713615417, -0.155225217342377, 0.0425102710723877, 0.430687308311462, -0.223334312438965, -0.0549725890159607, -0.530489921569824, -0.669931411743164, 0.139089941978455, 0.0614019632339478, -0.28822922706604, -0.145016610622406, 0.200108647346497, -0.0736180543899536, -0.500156760215759, 0.456823110580444, -0.352954983711243, -0.56299364566803, 0.305370092391968, -0.14654278755188, -0.549312353134155, -0.373685777187347, 0.275163769721985, -0.0727925896644592, 0.154868721961975, -0.139641046524048, -0.226935863494873, 0.00277829170227051, 0.286300301551819, -0.0308912992477417, 0.111384034156799, 0.0167107582092285, 0.130496025085449, -0.0541440844535828, 0.0430545806884766, 0.0309350490570068, -0.429489731788635, 0.488187789916992, -0.588996887207031, -0.14451003074646, -0.610155820846558, 0.0930145978927612, -0.0433468222618103, 0.103047966957092, -0.569133102893829, 0.169419407844543, -0.565284252166748, -0.60912561416626, 0.00700926780700684, 0.201571106910706, -0.351820647716522, 0.43747079372406, -0.0865939855575562, -0.371398508548737, 0.64551854133606, -0.226800382137299, 0.0998797416687012, 0.343898415565491, 0.293271064758301, -0.514423489570618, -0.132484793663025, 0.317923665046692, -0.29300981760025, -0.30073618888855, -0.884362995624542, 0.1297926902771, 0.0331196784973145, -0.554993391036987, 0.0123034715652466, 0.120124101638794, 0.290197014808655, -0.695281744003296, -0.105551064014435, -0.127681970596313, -0.346064984798431, -0.0343587398529053, -0.441146552562714, -0.366528511047363, -0.13695752620697, 0.644681572914124, 0.0572490692138672, 0.0386731624603271, -0.399902999401093, -0.151364624500275, -0.486454010009766, 0.0579671859741211, 0.548854112625122, 0.16596508026123, -0.194507300853729, -0.00587117671966553, -0.13132107257843, -0.268373966217041, -0.0733996033668518, 0.121840000152588, 0.149627327919006, -0.277896821498871, -0.184089183807373, -0.218529462814331, -0.522621810436249, -0.654853224754333, 0.166171193122864, 0.0653396844863892, -0.283983647823334, 0.145415544509888, 0.810114145278931, -0.0736055374145508, -0.423491239547729, -0.23078989982605, -0.221789717674255, 0.167972445487976, -0.237630546092987, 0.146374821662903, -0.0906252264976501, -0.0193641185760498, -0.192461848258972, -0.167837858200073, -0.266716182231903, -0.264306902885437, -0.166219830513, -0.11495703458786, -0.235635578632355, -0.826495885848999, 0.0983512401580811, -0.0118357539176941, -0.12071293592453, 0.366034507751465, -0.280488848686218, 0.0407146215438843, 0.134685039520264, 0.0869508981704712, -0.00110894441604614, -0.472615003585815, 0.00378513336181641, 0.175198674201965, -0.584986209869385, -0.605803608894348, -0.407350838184357, -0.291254580020905, -0.192996382713318, 0.317358136177063, 0.0434161424636841, 0.0517920255661011, 0.334455251693726, -0.0374854207038879, 0.227734923362732, -0.0650527477264404, 0.0358924865722656, -0.0806476473808289, -0.2400723695755, 0.0863357782363892, -0.485487639904022, 0.566981196403503, -0.054693877696991, 0.0535234212875366, -0.0194751024246216, 0.180892705917358, -0.212187767028809, -0.255136072635651, 0.190111875534058, -0.858265399932861, -0.0963553190231323, -0.116553843021393, 0.331158518791199, -0.0123817920684814, -0.75699120759964, 0.134712815284729, 0.603408932685852, -0.326835334300995, -0.128434062004089, 0.0879542827606201, 0.177350640296936, -0.1133913397789, 0.0445878505706787, 0.295072555541992, -0.0542901158332825, 0.486077070236206, -0.0579395294189453, -0.000137746334075928, -0.21995621919632, -0.500923871994019, -0.390006601810455, -0.0783300399780273, 0.0172308683395386, 0.296436190605164, 0.239973545074463, -0.346125483512878, -0.196802258491516, -0.375114321708679, -0.1240553855896, -0.187443137168884, -0.20858907699585, -0.0517362952232361, -0.234987378120422, 0.402685761451721, -0.319766223430634, 0.0428144931793213, -0.230278670787811, -0.121500074863434, 0.261553168296814, 0.183631300926208, 0.00556254386901855, -0.201948285102844, 0.349739670753479, -0.0126681923866272, 0.038020133972168, -0.126655697822571, 0.429926037788391, -0.185635209083557, 0.0643030405044556, 0.229498028755188, -0.247252345085144, 0.44136106967926, -0.7334845662117, -0.0114465355873108, -0.0141459107398987, -0.207992315292358, 0.211175918579102, 0.160660743713379, 0.193230271339417, -0.0174206495285034, -0.315407574176788, -0.0947321057319641, 0.290360689163208, 0.106443285942078, 0.205603241920471, -0.0701196789741516, 0.388210535049438, 0.299507141113281, -0.0673724412918091, 0.325896620750427, 0.416042923927307, 0.0348412990570068, 0.00682556629180908, -0.0255555510520935, -0.253118216991425, -0.0416362881660461, -0.738164663314819, 0.144428968429565, 0.122086524963379, -0.403780817985535, -0.517767012119293, -0.18999171257019, -0.0834265351295471, 0.338966488838196, -0.183015286922455, -0.132626593112946, -0.3199183344841, 0.748372316360474, -0.567502975463867, 0.324368119239807, -0.447314202785492, -0.326375365257263, -0.550855338573456, 0.108646631240845, -0.347743213176727, -0.288906991481781, -0.118125557899475, -0.379712879657745, -0.4312903881073, -0.282625138759613, -0.190098941326141, -0.344567835330963, 0.0660444498062134, -0.37306159734726, -0.0523031949996948, 0.374001741409302, -0.120498418807983, -0.117943584918976, 0.2783442735672, -0.171806812286377, -0.347964823246002, -0.269441246986389, 0.316662907600403, -0.00755888223648071, -0.00233012437820435, -0.147759556770325, -0.0679426193237305, -0.201981127262115, -0.52363133430481, -0.43826162815094, 0.077130913734436, -0.18100106716156, -0.388756036758423, -0.0206025242805481, -0.302516996860504, -0.184954404830933, 0.118664503097534, -0.902057707309723, -0.403655290603638, -0.542817950248718, -0.426285803318024, -0.286933302879333, -0.0466380715370178, -0.809836030006409, 0.355111002922058, 0.512625455856323, 0.321019411087036, -0.381800651550293, -0.465763092041016, 0.0606867074966431, 0.196945548057556, -0.232487380504608, 0.541813373565674, -0.167151689529419, -0.388356268405914, -0.091543972492218, -0.218482851982117, -0.454268217086792, 0.148796081542969, 0.282108783721924, 0.0135324001312256, -0.404074430465698, 0.521559715270996, -0.362078189849854, 0.154359102249146, 0.0970290899276733, 0.23608672618866, -0.0428115129470825, 0.299851536750793, 0.10517680644989, 0.211870312690735, -0.861949563026428, -0.0367650985717773, 0.0869408845901489, -0.083112895488739, -0.092252790927887, -0.129159986972809, 0.2828528881073, -0.122145771980286, -0.533272385597229, 0.316859126091003, -0.164342939853668, -0.375015079975128, 0.080241322517395, 0.0228097438812256, 0.102634787559509, -0.162905156612396, -0.610611021518707, 0.186607003211975, 0.29336941242218, 0.101261138916016, -0.167653679847717, 0.273078203201294, 0.508057832717896, 0.427027225494385, -0.247577667236328, -0.0084306001663208, -0.197218060493469, -0.250787198543549 }, 

   { -0.115878462791443, 0.280300736427307, 0.154586791992188, -0.153547883033752, 0.132402300834656, -0.0457896590232849, 0.0114469528198242, 0.268699645996094, 0.717928886413574, 0.171200752258301, 0.562851309776306, 0.302055716514587, 0.0474022626876831, 0.31301736831665, 0.274569869041443, 0.409625649452209, 0.155890226364136, 0.0639210939407349, -0.228369534015656, 0.566906332969666, 0.0620932579040527, 0.13141930103302, 0.00319886207580566, 0.199033856391907, 0.264891862869263, 0.191586494445801, 0.560912013053894, -0.0100189447402954, -0.444101512432098, 0.144414901733398, -0.151492536067963, -0.22080934047699, 0.20652437210083, 0.109808921813965, 0.594673633575439, -0.0979918837547302, 0.601537942886353, 0.56968891620636, 0.252714276313782, -0.0216795206069946, 0.417073965072632, 0.591840863227844, 0.193651914596558, 0.280232310295105, 0.281756162643433, 0.278963804244995, 0.652669787406921, 0.561638236045837, 0.182055354118347, 0.0678564310073853, 0.14668881893158, -0.00217044353485107, 0.114601969718933, 0.443645834922791, 0.340126872062683, 0.692011713981628, 0.00642728805541992, 0.649514436721802, -0.0422884225845337, -0.0910162329673767, -0.0972500443458557, 0.265036106109619, 0.544868230819702, 0.070304274559021, 0.142109751701355, -0.0474847555160522, 0.514346241950989, 0.562735795974731, -0.202496588230133, -0.154829084873199, 0.0895347595214844, 0.759837627410889, 0.644394516944885, 0.63334596157074, 0.315914750099182, 0.27656078338623, 0.199548482894897, 0.0401877164840698, 0.171527028083801, -0.0516952276229858, 0.324169158935547, 0.215350270271301, 0.498452425003052, 0.230128645896912, -0.29808247089386, -0.105984628200531, 0.191555261611938, -0.160943627357483, -0.0208531022071838, 0.346599459648132, 0.417563676834106, 0.0602154731750488, 0.303143739700317, 0.260072588920593, 0.654660940170288, -0.0139544606208801, 0.0454227924346924, 0.0658496618270874, 0.0248724222183228, 0.567980647087097, 0.179648399353027, 0.41152024269104, 0.126931071281433, 0.473634719848633, 0.0176763534545898, 0.527270436286926, 0.323467969894409, 0.296867251396179, -0.139434456825256, 0.22232460975647, 0.215896129608154, -0.0673380494117737, 0.569465398788452, 0.676493883132935, -0.132466912269592, 0.409209489822388, 0.0257201194763184, 0.297242045402527, 0.389079332351685, 0.288617372512817, 0.0204466581344604, 0.0589140653610229, 0.372763752937317, 0.427029013633728, 0.00233840942382812, 0.613619446754456, -0.22545450925827, -0.216438055038452, -0.0574675798416138, -0.0609193444252014, 0.305567026138306, 0.167321443557739, 0.229899168014526, 0.126787900924683, 0.39701771736145, 0.363836526870728, -0.264783620834351, 0.197744727134705, 0.10999858379364, 0.579095840454102, 0.0188916921615601, -0.108335793018341, 0.203884840011597, -0.119284152984619, 0.0908217430114746, 0.0383909940719604, -0.102577328681946, 0.300818204879761, 0.268427729606628, 0.206054210662842, -0.00832915306091309, -0.0220274925231934, 0.446430325508118, 0.524388194084167, -0.0254784822463989, 0.351108908653259, 0.256818532943726, 0.282392859458923, -0.0652217864990234, -0.0578109622001648, 0.590982913970947, 0.238933324813843, -0.0573211908340454, -0.06773442029953, 0.0346953868865967, 0.203598856925964, -0.088500440120697, -0.0284724235534668, -0.181268751621246, 0.429321050643921, -0.0994591116905212, 0.606830239295959, -0.102088987827301, 0.0161769390106201, 0.324107646942139, 0.455193519592285, 0.330962061882019, -0.14789617061615, 0.0300338268280029, 0.554926753044128, -0.117117285728455, 0.134088277816772, -0.0633237957954407, 0.552262425422668, 0.0753527879714966, 0.279751896858215, 0.745898485183716, -0.195733249187469, 0.0119520425796509, -0.0234248638153076, 0.3333580493927, 0.168269276618958, 0.260625243186951, 0.579625368118286, 0.0601145029067993, 0.113261103630066, 0.0729342699050903, -0.0798092484474182, 0.242488861083984, 0.285244703292847, -0.324216604232788, -0.0877945423126221, 0.057019829750061, 0.0352567434310913, 0.778448462486267, 0.158759832382202, 0.769762277603149, 0.66649317741394, -0.102654337882996, 0.0573635101318359, 0.355618596076965, 0.272973418235779, 0.116365075111389, 0.705607891082764, 0.338882565498352, 0.0948023796081543, -0.212033271789551, 0.246442675590515, -0.0028986930847168, 0.0405657291412354, 0.546990394592285, 0.219510674476624, 0.86743426322937, 0.108698010444641, -0.0269661545753479, 0.441660165786743, 0.0554215908050537, 0.0482507944107056, 0.553274512290955, 0.392353892326355, 0.016650915145874, 0.281700730323792, 0.237253069877625, 0.138792037963867, 0.131543397903442, 0.367644667625427, -0.0300737619400024, 0.265957832336426, -0.253305435180664, -0.0118252038955688, 0.228387355804443, -0.2217897772789, 0.0973516702651978, -0.13545149564743, 0.723862767219543, 0.264879941940308, 0.0719174146652222, -0.057137668132782, 0.218224287033081, 0.721419095993042, 0.0679433345794678, 0.503412008285522, 0.172708868980408, 0.0175696611404419, 0.803587317466736, 0.317524671554565, 0.0513718128204346, -0.195651888847351, 0.139264702796936, -0.01813805103302, 0.303928852081299, 0.00544166564941406, 0.147107005119324, 0.211352348327637, 0.710258483886719, 0.140611529350281, 0.459182262420654, 0.0219296216964722, -0.347934603691101, -0.0687300562858582, 0.193991184234619, 0.278418064117432, 0.0447509288787842, -0.260465562343597, 0.607832074165344, 0.0138951539993286, 0.39738142490387, -0.365342795848846, 0.5391845703125, -0.231814920902252, 0.610956072807312, 0.0126454830169678, 0.293513536453247, 0.0792372226715088, -0.211078822612762, 0.569177269935608, 0.348547577857971, 0.208802103996277, 0.0529597997665405, 0.3419508934021, 0.616118431091309, 0.564579606056213, 0.0323870182037354, 0.229509234428406, -0.115331053733826, 0.169082164764404, 0.149414777755737, 0.400763034820557, 0.316455364227295, 0.179766774177551, 0.246212720870972, 0.132486939430237, 0.278111100196838, 0.09549880027771, 0.2122722864151, 0.133918166160583, 0.0563565492630005, 0.267809748649597, 0.510785341262817, 0.546579122543335, 0.166697859764099, 0.442697048187256, 0.301804184913635, 0.375145196914673, -0.141416370868683, 0.0966013669967651, 0.194018244743347, -0.0211282968521118, 0.712546348571777, -0.0786173343658447, 0.690184712409973, 0.081480860710144, -0.0597743391990662, 0.309798240661621, -0.236749470233917, 0.0239714384078979, 0.120400905609131, -0.282346189022064, -0.136441290378571, 0.432691931724548, 0.188271522521973, -0.0926834940910339, 0.285010457038879, -0.00493454933166504, 0.066720724105835, 0.76605224609375, 0.276791334152222, 0.272754192352295, -0.134831368923187, 0.247107982635498, 0.128978967666626, 0.190743923187256, 0.345424056053162, -0.010637104511261, 0.479829668998718, 0.184143304824829, -0.0331171154975891, 0.654561638832092, 0.019334077835083, 0.547432422637939, 0.104527473449707, 0.38807225227356, 0.070706844329834, -0.246322989463806, 0.0072866678237915, 0.547682523727417, -0.0917327404022217, 0.150558114051819, -0.0663632154464722, 0.737741708755493, 0.0544111728668213, 0.295391440391541, 0.280403137207031, -0.224660992622375, 0.218675494194031, 0.146569490432739, 0.206436514854431, 0.237137794494629, 0.6950763463974, 0.0304856300354004, 0.295303583145142, -0.0272820591926575, 0.183384776115417, 0.190768957138062, 0.126745939254761, -0.135368585586548, 0.254867792129517, 0.183241367340088, 0.101516366004944, 0.159776926040649, 0.0469905138015747, -0.0285830497741699, 0.0501945018768311, 0.118392586708069, 0.282615423202515, 0.337561368942261, -0.0801005959510803, 0.536633968353271, 0.0171695947647095, -0.0449156761169434, 0.277302742004395, 0.439799785614014, 0.161622047424316, 0.235809206962585, 0.0716431140899658, -0.158237278461456, 0.176999926567078, 0.054175853729248, -0.0268540978431702, -0.0512533187866211, 0.146928906440735, -0.207050800323486, -0.211178600788116, -0.0428988933563232, -0.0546311140060425, 0.135607481002808, -0.201401054859161, 0.61770224571228, -0.0146677494049072, 0.187464356422424, -0.0377164483070374, 0.238118290901184, -0.002494215965271, 0.0891027450561523, 0.111804485321045, 0.420479536056519, -0.10214638710022, 0.104823708534241, -0.115462243556976, 0.232643008232117, 0.361659169197083, 0.0802439451217651, 0.294734477996826, 0.599556446075439, 0.532606840133667, 0.00312340259552002, 0.082560658454895, -0.082721471786499, -0.0090034008026123, 0.407042503356934, 0.38552725315094, 0.609406232833862, 0.0875955820083618, 0.00795495510101318, 0.65815544128418, 0.0961911678314209, 0.0372375249862671, 0.144089818000793, -0.0244680643081665, -0.00587314367294312, 0.155695557594299, 0.140235185623169, 0.30081570148468, -0.0264748334884644, 0.431660294532776, 0.0470864772796631, -0.0631860494613647, -0.285863220691681, -0.206977725028992, 0.599286913871765, 0.328088283538818, 0.27026903629303, 0.222348093986511, 0.285971403121948, 0.182689666748047, 0.32667863368988, 0.460599184036255, 0.612032890319824, 0.519997000694275, 0.659412622451782, 0.545556783676147, 0.33253014087677, 0.578468680381775, -0.125873267650604, 0.515970945358276, 0.144984126091003, 0.121362686157227, 0.0300778150558472, 0.715691924095154, 0.0586851835250854, 0.64694607257843, 0.166089057922363, 0.0154942274093628, 0.297165751457214, -0.185952365398407, 0.561950445175171, 0.302866458892822, 0.457792401313782, 0.16265594959259, -0.0176976323127747, 0.402230024337769, 0.144341707229614, 0.186959385871887, 0.0198112726211548, 0.259391903877258, 0.319456815719604, 0.249539017677307, 0.240363955497742, 0.354362368583679, 0.181152582168579, 0.0141023397445679, 0.00918221473693848, 0.197700619697571, -0.0724254250526428, -0.0762336254119873, 0.11788022518158, 0.708474159240723, 0.159964919090271, 0.745365142822266, -0.0181548595428467, 0.459034323692322, -0.0639739036560059, 0.226180672645569, 0.234939932823181, 0.0438488721847534, 0.271430850028992, 0.681842923164368, 0.395662426948547, 0.0688431262969971, 0.213043332099915, 0.0789759159088135, 0.715343475341797, -0.0289157032966614, 0.0889259576797485, 0.17716121673584, 0.00456380844116211, 0.396485209465027, -0.264313220977783, 0.818898677825928, 0.374232172966003, -0.26479035615921, 0.32867419719696, 0.249385595321655, -0.326602220535278, 0.124676465988159, -0.0133677124977112, 0.157818198204041, 0.106160640716553, -0.0748944282531738, 0.327112674713135, -0.0633540749549866, -0.0631768107414246, -0.0819579362869263, 0.547239303588867, 0.48647928237915, 0.418484210968018, 0.751384615898132, 0.350112080574036, 0.12561297416687, 0.588702917098999, 0.24734354019165, 0.25373375415802, 0.20913827419281, -0.34585839509964, 0.0307706594467163, 0.251986742019653, 0.268429636955261, 0.313115477561951, 1, -0.07716965675354, 0.113635301589966, 0.178654074668884, 0.580838322639465, 0.294922590255737, -0.12723183631897, 0.204221248626709, 0.00550782680511475, 0.353450059890747, 0.838395833969116, 0.0587615966796875, 0.0202744007110596, 0.682228207588196, 0.279794812202454, -0.0325539112091064, 0.19687032699585, 0.0810538530349731, 0.119730472564697, 0.0761773586273193, 0.361210823059082, 0.339463710784912, 0.0557477474212646, 0.171620845794678, 0.0401794910430908, -0.0192875266075134, 0.624597787857056, 0.0945194959640503, 0.460471868515015, 0.1951504945755, -0.261511385440826, -0.303930819034576, -0.0022052526473999, -0.0223528146743774, 0.23466420173645, 0.732115387916565, 0.0907111167907715, -0.282120585441589, 0.212044835090637, -0.145046889781952, 0.249452948570251, 0.403727412223816, 0.0715435743331909, 0.470406651496887, -0.142040014266968, 0.477900862693787, -0.17251068353653, -0.0241126418113708, 0.762102246284485, 0.375962734222412, 0.510040998458862, 0.0314611196517944, 0.227488398551941, 0.411515593528748, 0.610739588737488, 0.084321141242981, 0.321742534637451, -0.095029890537262, -0.23734986782074, 0.438820362091064, 0.459010004997253, 0.364169716835022, 0.252278327941895, 0.356237888336182, 0.119417190551758, 0.541604399681091, 0.292717695236206, 0.498167157173157, 0.102952003479004, 0.654638290405273, 0.109888195991516, 0.354396820068359, 0.552249312400818, 0.154239773750305, 0.0912675857543945, -0.204716324806213, -0.204253792762756, 0.210253357887268, 0.111246824264526, 0.00276505947113037, 0.361297845840454, -0.0206489562988281, -0.259295761585236, 0.316638946533203, -0.160398840904236, 0.14149010181427, 0.0849922895431519, 0.0435339212417603, 0.0101155042648315, -0.0699264407157898, -0.090116560459137, 0.0396486520767212, 0.106715083122253, 0.13013768196106, 0.668690919876099, -0.032020092010498, -0.130091726779938, -0.0712360143661499, 0.0532011985778809, 0.0934073925018311, 0.562861323356628, 0.283758878707886, 0.0935008525848389, -0.282024502754211, 0.37302553653717, 0.108259677886963, 0.0153861045837402, 0.222162365913391, 0.15392017364502, -0.00905358791351318, 0.304726600646973, 0.449894785881042, 0.0873328447341919, 0.219926714897156, 0.352118134498596, -0.238376975059509, 0.0580973625183105, 0.273130059242249, 0.126875519752502, 0.147789478302002, -0.0181517601013184, -0.104096829891205, 0.607852101325989, 0.0824728012084961, 0.618230938911438, -0.178901970386505, 0.125113010406494, 0.585737705230713, 0.287918448448181, 0.361163854598999, -0.179923355579376, 0.174148201942444, -0.150632679462433, 0.144239902496338, 0.439269304275513, -0.250775873661041, -0.113700270652771, 0.200694441795349, -0.153567016124725, 0.203892111778259, 0.747757792472839, 0.240903377532959, 0.611455678939819, 0.181632280349731, 0.66974139213562, -0.0456468462944031, -0.00979608297348022, 0.122066020965576, 0.260308861732483, 0.421059846878052, -0.234092533588409, 0.17416250705719, -0.13104522228241, 0.30767285823822, 0.680141806602478, 0.360643863677979, 0.198838472366333, 0.176972270011902, 0.196252584457397, 0.0575820207595825, -0.00312060117721558, 0.0350217819213867, -0.0623233914375305, 0.279041409492493, -0.147040784358978, 0.076704740524292, 0.476106524467468, 0.25549328327179, -0.0507966876029968, 0.380757808685303, -0.170418918132782, 0.602536916732788, 0.658233880996704, 0.213793277740479, 0.103398203849792, 0.468263864517212, 0.768657207489014, 0.203638553619385, -0.00599563121795654, 0.18763256072998, 0.150299549102783, 0.5413818359375, 0.0584977865219116, -0.0952433347702026, 0.0269298553466797, 0.102667570114136, -0.0502216219902039, 0.0857377052307129, 0.276604413986206, -0.0268710255622864, -0.00204950571060181, 0.535929441452026, -0.0513293147087097, 0.158772706985474, 0.0959417819976807, -0.289330840110779, 0.0889637470245361, -0.0940683484077454, -0.0479864478111267, -0.129384279251099, 0.214994192123413, 0.392446041107178, 0.0883173942565918, 0.0287759304046631, 0.105477094650269, 0.355143308639526, 0.390973329544067, 0.344306111335754, 0.286238670349121, -0.000572919845581055, 0.0492290258407593, 0.0116598606109619, 0.0364911556243896, -0.0322214961051941, -0.00941938161849976, 0.068083643913269, -0.188974618911743, 0.475320816040039, -0.117717087268829, 0.174764633178711, -0.013136088848114, -0.166476428508759, 0.58583927154541, 0.317433834075928, -0.183778822422028, 0.624665498733521, 0.103785514831543, -0.0124351382255554, 0.0869895219802856, 0.477816939353943, 0.218068599700928, -0.0319275259971619, -0.13375598192215, 0.00429046154022217, 0.231130480766296, 0.481248378753662, -0.0530806183815002, 0.320114254951477, 0.509813189506531, -0.0875111222267151, 0.037855863571167, -0.0985105633735657, 0.0448983907699585, 0.829201817512512, 0.126155138015747, 0.312863826751709, -0.370032548904419, 0.161556363105774, 0.869281530380249, 0.110498070716858, 0.052775502204895, -0.130073428153992, -0.168648600578308, 0.751356959342957, 0.516467213630676, 0.0523759126663208, 0.00988674163818359, 0.159001469612122, 0.109742879867554, 0.56206226348877, 0.0113016366958618, 0.0596060752868652, 0.281021118164062, 0.0847151279449463, 0.806297659873962, 0.138467311859131, -0.100688457489014, 0.300949573516846, 0.138120651245117, 0.21673047542572, 0.380621314048767, 0.082755446434021, 0.37189507484436, 0.144076347351074, 0.508315920829773, 0.247317552566528, -0.061356246471405, 0.557539343833923, 0.631457209587097, 0.033079981803894, -0.0933989882469177, 0.311180830001831, 0.301491618156433, 0.461916565895081, 0.111600637435913, 0.0192135572433472, -0.0975217819213867, 0.12688684463501, -0.21569436788559, 0.17806339263916, 0.47266161441803, 0.445927262306213, 0.391605019569397, 0.395066738128662, -0.287654280662537, 0.0442514419555664, -0.0222635865211487, 0.119709849357605, 0.407416582107544, 0.737800359725952, -0.255663096904755, -0.00420868396759033, 0.337708115577698, 0.259183168411255, 0.334829568862915, 0.413209557533264, -0.104548454284668, 0.718792796134949, 0.00074303150177002, -0.222796082496643, 0.136943459510803, 0.00675284862518311, 0.217737317085266, 0.320277690887451, 0.761694669723511, -0.0569964647293091, 0.116816401481628, -0.0423359274864197, 0.098071813583374, -0.113379001617432, 0.27659285068512, 0.342471480369568, 0.117221713066101, 0.058803915977478, 0.721855878829956, 0.152829170227051, 0.0493866205215454, 0.144167304039001, 0.443832278251648, 0.063336968421936, -0.0543323159217834, 0.0179914236068726, 0.0887354612350464, 0.521645903587341, 0.308441519737244, 0.195475935935974, 0.403798937797546, 0.0381375551223755, -0.165739357471466, 0.302478671073914, 0.102832436561584, 0.550081133842468, 0.594035267829895, 0.187834620475769, -0.125318884849548, 0.209373712539673, 0.485885977745056, -0.0874979496002197, 0.264023303985596, -0.0440754890441895, -0.115093767642975, -0.0142588019371033, 0.213653087615967, 0.490357160568237, 0.482530355453491, 0.207451581954956, 0.625387191772461, 0.0741004943847656, 0.435348510742188, 0.129885077476501, 0.118228197097778, 0.0535658597946167, 0.129889965057373, 0.34714150428772, -0.054787814617157, 0.204433798789978, 0.00745463371276855, 0.454673647880554, -0.265787661075592, -0.0459359884262085, 0.125651836395264, 0.426965951919556, 0.714118242263794, 0.618825793266296, 0.160861134529114, 0.0492792129516602, 0.362230539321899, 0.187665224075317, -0.0728927254676819, 0.277756333351135, 0.178811550140381, -0.254343628883362, -0.220983147621155, 0.136743187904358, 0.157143354415894, 0.225251317024231, -0.0933265089988708, 0.284012794494629, 0.472898960113525, 0.617370367050171, 0.576140403747559, 0.52548623085022, 0.509060740470886, 0.790082335472107, 0.0852259397506714, 0.480070352554321, -0.100357115268707, 0.567782759666443, 0.160108804702759, 0.276831746101379, 0.17100715637207, 0.174411058425903, 0.812862277030945, 0.540981650352478, 0.0413424968719482, 0.00709736347198486, 0.184414029121399, 0.0918025970458984, 0.24196982383728, 0.00567734241485596, -0.168239653110504, 0.0529608726501465, 0.631431460380554, 0.427515149116516, -0.0847355723381042, 0.0911736488342285, 0.00256407260894775, 0.36137843132019, 0.138739585876465, -0.11849981546402, 0.644467949867249, 0.171827912330627, 0.25741720199585, 0.752047538757324, -0.0807851552963257, 0.524048805236816, -0.132659256458282, 0.252552032470703, 0.355148196220398, 0.0426101684570312, -0.136838555335999, 0.443373799324036, 0.480134725570679, 0.146206974983215, -0.0140296220779419, -0.117524802684784, 0.078514575958252, 0.0941833257675171, -0.282146394252777, -0.00325006246566772, 0.22468101978302, 0.166641592979431, -0.29870331287384, 0.0819474458694458, 0.160533905029297, 0.125232458114624, 0.510823011398315, 0.441477298736572, 0.104894399642944, -0.0793616771697998, 0.238213419914246, 0.468861103057861, 0.437041878700256, 0.383963465690613, 0.113253116607666, 0.392974853515625, 0.115813136100769, 0.197482228279114, 0.131551265716553, 0.0385024547576904, 0.528844952583313, 0.318942427635193, -0.0674192309379578, 0.313213348388672, 0.0285230875015259, -0.0746758580207825, 0.0350631475448608, 0.367399573326111, -0.00905972719192505, 0.073813796043396, 0.803400635719299, 0.167451858520508, 0.253890752792358, -0.290532767772675, -0.0885724425315857, 0.248135685920715, 0.784693837165833, 0.0874860286712646, 0.0647779703140259, 0.216392040252686, 0.358147621154785, 0.375556349754333, 0.166730403900146, 0.012426495552063, 0.0847841501235962, 0.0137811899185181, 0.117563009262085, 0.160413146018982, -0.0012698769569397, -0.0422534346580505, 0.695759654045105, 0.435803055763245, 0.0809159278869629, 0.178285479545593, 0.172786474227905, 0.243082284927368, 0.131900668144226, 0.61960756778717, 0.302267670631409, 0.0358378887176514, 0.302892327308655, 0.30210816860199, 0.348248839378357, 0.289580821990967, -0.107401490211487, 0.513559460639954, -0.0116410255432129, 0.124885320663452, 0.285502910614014, 0.0393246412277222, 0.284644961357117, 0.651508569717407, 0.174743890762329, 0.162224173545837, 0.277694582939148, 0.336019992828369, -0.0268623828887939, 0.327516317367554, 0.180602669715881, 0.127892732620239, -0.0705872774124146, -0.192265510559082, -0.116567730903625, -0.0129227042198181, 0.272789359092712, -0.0565584897994995, -0.171528160572052, 0.0572001934051514, 0.252003192901611, 0.428924202919006, 0.200964093208313, 0.206310987472534, 0.0931156873703003, 0.178494095802307, 0.38079571723938, 0.418706059455872, -0.0437333583831787, 0.731949925422668, -0.019340991973877, 0.200985431671143, 0.25156581401825, -0.0604583621025085, -0.131929814815521, 0.0301254987716675, 0.347505688667297, 0.111463665962219, 0.413177609443665, -0.176816165447235, 0.114991903305054, 0.213094592094421, 0.143441915512085, -0.000812888145446777, 0.0343124866485596, 0.23710834980011, 0.0104629993438721, -0.0186997056007385, -0.127749979496002, 0.0726743936538696, -0.200345098972321, 0.18242609500885, 0.558821439743042, -0.0748757123947144, -0.0113994479179382, -0.461453437805176, 0.521931052207947, 0.101527810096741, -0.0696528553962708, 0.169248342514038, -0.186318337917328, 0.337965369224548, 0.152622699737549, 0.186459422111511, -0.279254078865051, 0.479532122612, 0.496986150741577, 0.189879298210144, -0.122816741466522, 0.291383147239685, 0.864273309707642, 0.209242463111877, 0.24528956413269, 0.065815806388855, 0.0850210189819336, 0.237794995307922, 0.0437119007110596, 0.136204123497009, 0.156775236129761, 0.220171809196472, 0.519583225250244, 0.159198880195618, 0.181398510932922, -0.0437926650047302, 0.454914450645447, 0.374492526054382, -0.334682285785675, -0.244488537311554, 0.00565099716186523, -0.129486203193665 }, 

   { -0.0667248964309692, 0.387988209724426, 0.129582524299622, -0.165064811706543, 0.0540783405303955, 0.122113943099976, -0.0237094759941101, 0.1885746717453, 0.657047510147095, 0.131960272789001, 0.708224892616272, 0.330530166625977, 0.149409770965576, 0.25687575340271, 0.212677478790283, 0.278609156608582, 0.193570256233215, 0.111825585365295, -0.229743242263794, 0.705118179321289, 0.281617760658264, 0.140053749084473, -0.00269776582717896, 0.111484885215759, 0.366806149482727, 0.279420733451843, 0.437340259552002, 0.121053099632263, -0.144749045372009, 0.337443351745605, -0.205236613750458, -0.113671839237213, 0.50563371181488, 0.077761173248291, 0.626615643501282, -0.0409452319145203, 0.912215113639832, 0.602602124214172, 0.322169303894043, 0.00248348712921143, 0.549489974975586, 0.640035510063171, 0.251778841018677, 0.69867217540741, 0.304371356964111, 0.477853178977966, 0.537363648414612, 0.74985659122467, 0.153446078300476, 0.230510830879211, 0.413074493408203, 0.138669610023499, 0.126630187034607, 0.510403633117676, 0.517249822616577, 0.854548335075378, 0.00211822986602783, 0.672609329223633, -0.0172541737556458, 0.237790465354919, 0.176547050476074, 0.36692750453949, 0.552701115608215, 0.279698729515076, 0.217592716217041, 0.15910792350769, 0.65608012676239, 0.624850749969482, -0.0775020718574524, -0.0987946391105652, -0.0435380935668945, 0.915556907653809, 0.723936080932617, 0.55472207069397, 0.128120541572571, 0.426954030990601, 0.250978589057922, -0.0621569752693176, 0.526463270187378, 0.0442471504211426, 0.317535996437073, 0.356732964515686, 0.853721857070923, 0.161606788635254, -0.173283100128174, -0.0116881728172302, 0.348606705665588, -0.0732405781745911, 0.0400104522705078, 0.6615389585495, 0.507049560546875, 0.0536798238754272, 0.327757596969604, 0.239462971687317, 0.815713882446289, 0.22544002532959, 0.165278315544128, 0.00731408596038818, 0.216266989707947, 0.820831060409546, 0.163338541984558, 0.551204919815063, 0.293117761611938, 0.600857973098755, 0.028954029083252, 0.714207053184509, 0.401995658874512, 0.294329524040222, 0.108212351799011, 0.216336131095886, 0.341155171394348, 0.0839924812316895, 0.851515293121338, 0.745881319046021, 0.0367835760116577, 0.665794372558594, 0.20086681842804, 0.283062219619751, 0.49897575378418, 0.260245442390442, 0.227146148681641, 0.0173320770263672, 0.391139030456543, 0.728330254554749, 0.0762696266174316, 0.800423979759216, 0.0524972677230835, -0.146063029766083, 0.0431267023086548, 0.311926603317261, 0.134107828140259, 0.273207664489746, 0.289544105529785, 0.410004496574402, 0.373309373855591, 0.540028691291809, -0.144202649593353, 0.259700059890747, 0.0871384143829346, 0.781735420227051, 0.0262511968612671, 0.108780145645142, 0.392403244972229, -0.0260881185531616, 0.0329595804214478, 0.107679843902588, 0.0159534215927124, 0.169608473777771, 0.167587399482727, 0.125499844551086, -0.014565110206604, 0.117943286895752, 0.764249324798584, 0.584985017776489, 0.0725038051605225, 0.27690315246582, 0.124675750732422, 0.341202259063721, -0.146984398365021, 0.28213632106781, 0.675569415092468, 0.247091174125671, 0.0672228336334229, 0.0979340076446533, 0.2439284324646, 0.400760769844055, -0.0695151686668396, 0.105624318122864, -0.203823328018188, 0.755478739738464, -0.000589668750762939, 0.402484893798828, 0.0417354106903076, 0.0758358240127563, 0.544106960296631, 0.732605934143066, 0.160042285919189, -0.0582936406135559, 0.139580488204956, 0.778555035591125, -0.15494579076767, 0.378799915313721, 0.0141360759735107, 0.815843820571899, 0.104311466217041, 0.492742776870728, 0.916207432746887, -0.109730243682861, 0.0641878843307495, 0.093275785446167, 0.171849608421326, 0.321917772293091, 0.284681797027588, 0.680245757102966, 0.0510457754135132, 0.223096013069153, 0.236282467842102, 0.0621082782745361, 0.164684653282166, 0.412138104438782, -0.121890664100647, 0.0794546604156494, 0.173276543617249, -0.126398861408234, 0.836133003234863, 0.153244495391846, 0.809988141059875, 0.848743677139282, -0.127336502075195, 0.106991052627563, 0.462936282157898, 0.24200177192688, 0.214231848716736, 0.870475292205811, 0.219540119171143, 0.188163280487061, -0.0148833990097046, 0.143667936325073, 0.279550433158875, 0.0566931962966919, 0.586796283721924, 0.327258706092834, 0.952526807785034, 0.149620175361633, 0.171418428421021, 0.599189758300781, 0.242843508720398, 0.0508879423141479, 0.381956696510315, 0.509445905685425, 0.178993344306946, 0.200623273849487, 0.280484199523926, 0.31646466255188, 0.261191010475159, 0.351920008659363, 0.130451202392578, 0.174899220466614, -0.179601669311523, 0.143976211547852, 0.221515297889709, -0.0948536396026611, 0.271041989326477, -0.0710141658782959, 0.689462423324585, 0.315291166305542, 0.32611870765686, 0.12234628200531, 0.290334105491638, 0.854589343070984, 0.0637558698654175, 0.63742470741272, 0.160441994667053, 0.337837696075439, 0.820691466331482, 0.466976284980774, 0.2912358045578, -0.332145392894745, 0.0388569831848145, 0.0342260599136353, 0.256874918937683, 0.106966614723206, 0.39716649055481, 0.119408845901489, 0.832135438919067, 0.440478801727295, 0.704935312271118, 0.0860216617584229, -0.0828779935836792, 0.14437735080719, 0.336707234382629, 0.158899664878845, 0.0378133058547974, -0.104251086711884, 0.814007878303528, 0.129241585731506, 0.323623538017273, -0.322448074817657, 0.830295920372009, -0.118934750556946, 0.845964312553406, 0.204812049865723, 0.172536611557007, 0.28638231754303, 0.0457193851470947, 0.480077624320984, 0.724580049514771, 0.194062232971191, 0.0359684228897095, 0.30000901222229, 0.836629748344421, 0.804516315460205, 0.132025837898254, 0.27715528011322, 0.0904734134674072, 0.159746408462524, 0.155820608139038, 0.670678734779358, 0.335755467414856, 0.0893986225128174, 0.125269651412964, 0.206543564796448, 0.333857178688049, 0.173679232597351, 0.526223421096802, 0.332327723503113, 0.0484038591384888, 0.379597783088684, 0.497623562812805, 0.619632482528687, 0.0340566635131836, 0.624951481819153, 0.351162433624268, 0.533830881118774, -0.146542191505432, 0.238774061203003, 0.189485311508179, 0.152978658676147, 0.726105213165283, -0.225178718566895, 0.820109128952026, -0.0629900693893433, -0.186446487903595, 0.367597103118896, -0.0764378309249878, 0.124476194381714, 0.419645309448242, 0.128220558166504, -0.0437306761741638, 0.522144198417664, 0.208715677261353, -0.0869179368019104, 0.270000457763672, 0.112405300140381, 0.145559549331665, 0.890814661979675, 0.298748016357422, 0.317728996276855, 0.0398362874984741, 0.331697463989258, 0.282169342041016, 0.0940449237823486, 0.6965491771698, 0.148752570152283, 0.731260657310486, 0.132410287857056, -0.0332176089286804, 0.529991507530212, 0.0334827899932861, 0.669277429580688, 0.194037437438965, 0.785248279571533, 0.139073967933655, -0.203361928462982, 0.00271260738372803, 0.599591970443726, -0.120676636695862, 0.125333905220032, -0.249717473983765, 0.769330501556396, 0.0336602926254272, 0.706220030784607, 0.12549352645874, -0.194798231124878, 0.344713807106018, 0.238303303718567, 0.245074272155762, 0.430989861488342, 0.819203615188599, 0.231357216835022, 0.207446455955505, -0.0563342571258545, 0.29450523853302, 0.132177948951721, 0.0770525932312012, -0.0176997780799866, 0.346305370330811, 0.230858445167542, 0.0723848342895508, 0.344289660453796, 0.154539823532104, 0.0670868158340454, 0.148610353469849, 0.349840760231018, 0.549219131469727, 0.232300281524658, -0.0893573760986328, 0.673210978507996, -0.0217609405517578, 0.0671889781951904, 0.158772945404053, 0.537026643753052, 0.069581151008606, 0.441841602325439, 0.129111409187317, -0.0521772503852844, 0.215167880058289, 0.0461983680725098, 0.171722292900085, 0.0162527561187744, 0.133546948432922, -0.116769909858704, -0.0504129528999329, 0.11293089389801, 0.0712180137634277, 0.0626144409179688, 0.0186513662338257, 0.616389513015747, 0.243782520294189, 0.0704035758972168, 0.0267019271850586, 0.201263904571533, 0.0700079202651978, 0.126184701919556, 0.0778604745864868, 0.579737901687622, 0.0343426465988159, 0.11594569683075, 0.163634657859802, 0.438088655471802, 0.340802669525146, 0.0664211511611938, 0.426406621932983, 0.600232005119324, 0.43861448764801, 0.120457172393799, 0.167132139205933, 0.0744813680648804, -0.0067436695098877, 0.33117139339447, 0.482135653495789, 0.593353390693665, 0.195177912712097, 0.163031220436096, 0.729231119155884, 0.0466139316558838, 0.325002312660217, 0.0646501779556274, -0.0463764667510986, -0.104308187961578, 0.14260995388031, 0.278951644897461, 0.360396146774292, -0.023903489112854, 0.672303080558777, 0.10895037651062, 0.187671542167664, -0.350823760032654, 0.0541346073150635, 0.784748673439026, 0.319526076316833, 0.296657085418701, 0.296898722648621, 0.304632306098938, -0.00117295980453491, 0.173935174942017, 0.610742330551147, 0.721786737442017, 0.726407527923584, 0.761066675186157, 0.84531044960022, 0.508312821388245, 0.559500813484192, 0.078218936920166, 0.517176508903503, 0.151942849159241, 0.0933730602264404, -0.081132709980011, 0.900996923446655, -0.0454075932502747, 0.837473392486572, 0.302319526672363, 0.157737255096436, 0.487894535064697, 0.192394375801086, 0.656923174858093, 0.318566203117371, 0.545715570449829, 0.0753697156906128, 0.0719219446182251, 0.607467174530029, 0.127614617347717, 0.269570827484131, 0.0312069654464722, 0.361148118972778, 0.437439203262329, 0.575957894325256, 0.411910772323608, 0.409743785858154, 0.164970993995667, -0.150836288928986, 0.0601617097854614, 0.277446866035461, 0.518392205238342, -0.045352041721344, 0.101264119148254, 0.921112298965454, 0.325629949569702, 0.803473591804504, 0.0812580585479736, 0.450801491737366, -0.066501259803772, 0.373324751853943, 0.324528932571411, -0.086387038230896, 0.294478058815002, 0.756265044212341, 0.559669733047485, -0.125870406627655, 0.134400844573975, 0.137274503707886, 0.633203983306885, 0.00811982154846191, 0.0742931365966797, 0.286736726760864, -0.081897497177124, 0.405001282691956, 0.0945614576339722, 0.84963321685791, 0.647006630897522, -0.224461376667023, 0.352108597755432, 0.380987763404846, -0.0407378077507019, 0.167135834693909, 0.0121824741363525, 0.34499990940094, 0.209487080574036, 0.0658159255981445, 0.401039361953735, -0.134749472141266, -0.129532277584076, 0.0231437683105469, 0.672335863113403, 0.530306577682495, 0.413262486457825, 0.919769644737244, 0.165961503982544, 0.234174132347107, 0.764113068580627, 0.273842096328735, 0.136717796325684, 0.362407207489014, -0.145821034908295, 0.107205748558044, 0.253158330917358, 0.202227830886841, 0.167517781257629, 0.99999988079071, 0.16633403301239, 0.230518221855164, 0.0218801498413086, 0.840974569320679, 0.362920880317688, 0.0695415735244751, 0.26830518245697, 0.179805755615234, 0.407788753509521, 0.92683470249176, -0.0936630368232727, 0.185592770576477, 0.898809671401978, 0.289772987365723, 0.167662382125854, 0.00761044025421143, 0.16434121131897, 0.396248698234558, 0.280677080154419, 0.302736639976501, 0.496047019958496, 0.157714605331421, 0.587026834487915, 0.125030279159546, 0.198079228401184, 0.584790468215942, 0.0411921739578247, 0.389646649360657, 0.307419180870056, -0.112247824668884, -0.113236308097839, 0.262773513793945, 0.00653183460235596, 0.161251783370972, 0.842905282974243, 0.161943793296814, -0.202800035476685, 0.171108484268188, 0.100552678108215, 0.344764947891235, 0.666659355163574, 0.28900933265686, 0.656807661056519, 0.0287868976593018, 0.648155093193054, -0.0829225182533264, 0.125951766967773, 0.847139000892639, 0.249484539031982, 0.480884313583374, 0.221672654151917, 0.13975727558136, 0.542927980422974, 0.4653160572052, 0.181661486625671, 0.358831405639648, 0.142980337142944, -0.0347055792808533, 0.604411482810974, 0.516476273536682, 0.479546546936035, 0.22208046913147, 0.357792377471924, 0.328941345214844, 0.564876437187195, 0.30187201499939, 0.624478578567505, 0.120263338088989, 0.842843890190125, 0.0268070697784424, 0.385531663894653, 0.752883076667786, 0.329453587532043, 0.319499373435974, -0.176688551902771, -0.132062137126923, 0.170772433280945, 0.18738853931427, -0.0331528186798096, 0.474815607070923, 0.112836480140686, -0.193780243396759, 0.256478786468506, 0.0662339925765991, 0.238672018051147, 0.184982776641846, 0.144081115722656, 0.249963641166687, 0.100927591323853, 0.111957669258118, 0.153685927391052, 0.106907725334167, 0.238763093948364, 0.963583946228027, 0.0324555635452271, -0.124400556087494, -0.0916593074798584, 0.0392215251922607, 0.0776627063751221, 0.639832615852356, 0.223753571510315, 0.0683357715606689, -0.249553024768829, 0.354516267776489, 0.113897681236267, 0.159552335739136, 0.229228019714355, 0.150119185447693, 0.00303447246551514, 0.578557252883911, 0.677899599075317, 0.0754138231277466, 0.323096513748169, 0.281525731086731, -0.178679049015045, 0.122496962547302, 0.319581389427185, 0.015373706817627, 0.195284247398376, 0.175181031227112, -0.0312929153442383, 0.732393145561218, 0.155690908432007, 0.776999115943909, 0.105778932571411, 0.147995948791504, 0.766870975494385, 0.391358494758606, 0.690412044525146, -0.0274158716201782, 0.275725722312927, -0.14231663942337, 0.401105761528015, 0.650443196296692, -0.239673554897308, -0.014509379863739, 0.224513530731201, -0.0988454222679138, 0.343174934387207, 0.879451036453247, 0.175924777984619, 0.77503764629364, 0.196492433547974, 0.679382801055908, 0.112291097640991, 0.0936658382415771, 0.10997211933136, 0.39375638961792, 0.412253499031067, -0.198180735111237, 0.37342369556427, 0.205224394798279, 0.196681261062622, 0.847508907318115, 0.577141880989075, 0.0680067539215088, 0.314803123474121, 0.332987904548645, 0.270845055580139, 0.152043700218201, 0.0701596736907959, -0.0742819905281067, 0.339046716690063, 0.00161802768707275, 0.165141820907593, 0.738031148910522, 0.359357118606567, -0.0281432271003723, 0.190895795822144, 0.00455617904663086, 0.743084073066711, 0.861226201057434, 0.220502257347107, 0.227927923202515, 0.379063606262207, 0.726325273513794, 0.398629903793335, 0.122258186340332, 0.454163789749146, 0.281121015548706, 0.761125922203064, 0.175044655799866, -0.141249656677246, 0.193810343742371, -0.0035441517829895, -0.181319773197174, 0.195005416870117, 0.508592963218689, -0.0486392974853516, 0.0634993314743042, 0.743300557136536, 0.0860509872436523, -0.0424598455429077, 0.229981184005737, -0.310502588748932, 0.0241048336029053, 0.0316441059112549, 0.177585601806641, -0.182132720947266, 0.0746307373046875, 0.611137390136719, 0.0627549886703491, 0.0375080108642578, 0.245349049568176, 0.300997376441956, 0.50563633441925, 0.449741959571838, 0.283535480499268, 0.268520712852478, 0.173501133918762, 0.150982260704041, 0.285660266876221, 0.0836659669876099, 0.049254298210144, -0.0877615213394165, -0.0707829594612122, 0.670071244239807, -0.201553881168365, 0.395629525184631, 0.254072070121765, -0.029143214225769, 0.786062002182007, 0.284940958023071, -0.125192999839783, 0.598494529724121, 0.228257536888123, 0.0590198040008545, 0.340774178504944, 0.826078176498413, 0.545475363731384, -0.0843652486801147, -0.194653511047363, 0.197996139526367, 0.312998414039612, 0.745708465576172, 0.0245568752288818, 0.658171534538269, 0.690579175949097, 0.0944018363952637, 0.231192708015442, -0.195728480815887, 0.10123610496521, 0.845632433891296, -0.00230062007904053, 0.288913726806641, -0.119519352912903, 0.0140833854675293, 0.805242538452148, 0.182495594024658, 0.121478796005249, -0.0833393335342407, 0.0693634748458862, 0.747746706008911, 0.853665709495544, 0.18958306312561, 0.0386049747467041, 0.291962742805481, 0.356486082077026, 0.744665622711182, 0.0708327293395996, 0.283201456069946, 0.334391474723816, 0.243948101997375, 0.8839031457901, 0.228238701820374, -0.113865911960602, 0.298879027366638, 0.301767587661743, 0.0407775640487671, 0.294237017631531, 0.214719414710999, 0.696098804473877, 0.139500975608826, 0.849509239196777, 0.25307834148407, 0.155185103416443, 0.729971647262573, 0.649528622627258, 0.15652334690094, 0.0581574440002441, 0.31636369228363, 0.285308837890625, 0.737442255020142, 0.0392197370529175, 0.0475244522094727, -0.15658563375473, 0.083283543586731, -0.105527281761169, 0.038583517074585, 0.569560170173645, 0.481511354446411, 0.516312956809998, 0.393633723258972, -0.121927082538605, -0.05640709400177, 0.0493881702423096, 0.149900197982788, 0.658619046211243, 0.815841197967529, -0.093040943145752, -0.0854595303535461, 0.469368815422058, 0.37135899066925, 0.171737909317017, 0.718595385551453, -0.00394856929779053, 0.837894678115845, -0.00232309103012085, -0.111762225627899, 0.293421745300293, 0.172223091125488, 0.214249014854431, 0.316511392593384, 0.906229496002197, 0.134311556816101, -0.132702469825745, 0.0844929218292236, 0.352449297904968, 0.0469876527786255, 0.0931260585784912, 0.403213858604431, 0.124253153800964, 0.226562976837158, 0.862850427627563, 0.117629766464233, 0.0192152261734009, 0.0848785638809204, 0.51740550994873, 0.319047212600708, 0.0220381021499634, -0.112064957618713, 0.302552342414856, 0.571219563484192, 0.340447187423706, 0.260713338851929, 0.565817952156067, 0.0850248336791992, -0.0240669250488281, 0.211516261100769, 0.166069984436035, 0.508818626403809, 0.63393759727478, 0.215018272399902, 0.0375432968139648, 0.170698642730713, 0.73015820980072, -0.112445712089539, 0.313515901565552, 0.131852984428406, 0.105547308921814, -0.00521230697631836, 0.349839448928833, 0.603793859481812, 0.700143098831177, 0.156745195388794, 0.731822729110718, 0.109281659126282, 0.424612522125244, 0.0934907197952271, 0.313044905662537, 0.347834587097168, -0.0047639012336731, 0.36797308921814, 0.0410008430480957, 0.391419529914856, 0.177626132965088, 0.641281485557556, -0.214416563510895, 0.0812098979949951, 0.113757967948914, 0.620592594146729, 0.869105935096741, 0.86067533493042, 0.275390267372131, 0.104798793792725, 0.387763619422913, 0.306234955787659, -0.15256667137146, 0.131051540374756, 0.0739223957061768, -0.0336636304855347, -0.240544080734253, 0.122509002685547, 0.172698974609375, 0.135102391242981, -0.193203568458557, 0.193899273872375, 0.683492541313171, 0.83577823638916, 0.615401268005371, 0.859535574913025, 0.811644077301025, 0.849226117134094, 0.182638049125671, 0.759949803352356, 0.0915114879608154, 0.773421287536621, 0.20836329460144, 0.133883118629456, 0.352919220924377, 0.19369113445282, 0.968962430953979, 0.802105903625488, 0.177409291267395, 0.0577458143234253, 0.0194666385650635, 0.20443594455719, 0.190486788749695, 0.0256533622741699, -0.0139058828353882, 0.191460371017456, 0.833700180053711, 0.393361210823059, -0.0416178703308105, 0.194476962089539, 0.118985652923584, 0.379358172416687, 0.297552466392517, 0.191716909408569, 0.902688384056091, 0.302114725112915, 0.46968686580658, 0.854321718215942, -0.0114266276359558, 0.577760338783264, -0.0866219997406006, 0.385205984115601, 0.580817103385925, -0.00300359725952148, -0.0260608792304993, 0.561928272247314, 0.677371978759766, 0.322935938835144, -0.0243697762489319, 0.0349371433258057, -0.1699138879776, 0.192626476287842, -0.177036046981812, 0.248507380485535, 0.315149545669556, 0.148898124694824, -0.0861313939094543, 0.179947376251221, 0.00310802459716797, 0.0212326049804688, 0.61941397190094, 0.64717423915863, 0.242184042930603, -0.0754364728927612, 0.243937492370605, 0.772467494010925, 0.490839838981628, 0.648391842842102, 0.231131792068481, 0.614565253257751, 0.241837739944458, 0.344706177711487, 0.124702572822571, -0.198646485805511, 0.479350328445435, 0.370252966880798, 0.072212815284729, 0.42216157913208, 0.141278386116028, 0.0753687620162964, 0.157026410102844, 0.381320714950562, 0.131173610687256, 0.0900365114212036, 0.694326043128967, 0.283426284790039, 0.282982587814331, -0.00929617881774902, 0.119089841842651, 0.335923314094543, 0.950520515441895, 0.222829937934875, 0.128953099250793, 0.296436548233032, 0.53784704208374, 0.495525479316711, 0.196398258209229, -0.158006012439728, 0.281660676002502, -0.0296177864074707, 0.209987163543701, 0.354084730148315, 0.0051497220993042, -0.0469000339508057, 0.856924891471863, 0.368624091148376, 0.179649353027344, 0.322960019111633, 0.30883777141571, 0.209913015365601, 0.173551082611084, 0.833581209182739, 0.508131384849548, 0.100950956344604, 0.255265593528748, 0.256952881813049, 0.490542650222778, 0.166741132736206, -0.0767476558685303, 0.658540368080139, -0.0665922164916992, 0.0768685340881348, 0.44056499004364, 0.0442054271697998, 0.258172512054443, 0.692956805229187, 0.0985087156295776, 0.0927630662918091, 0.205285787582397, 0.208032011985779, 0.0659538507461548, 0.370649695396423, 0.12791895866394, 0.0796664953231812, 0.104869961738586, 0.0465083122253418, 0.0216760635375977, 0.134195804595947, 0.363978743553162, 0.0699692964553833, -0.0917823910713196, 0.123953223228455, 0.207178473472595, 0.509748578071594, 0.0576503276824951, 0.0528992414474487, 0.320278882980347, 0.352768778800964, 0.475868105888367, 0.579793572425842, -0.00642120838165283, 0.809062004089355, -0.0438774228096008, 0.0460911989212036, 0.426944971084595, 0.0944640636444092, -0.100894093513489, -0.00152182579040527, 0.513979196548462, 0.162853717803955, 0.642747044563293, -0.0956882238388062, 0.214888215065002, 0.314631223678589, 0.0883852243423462, 0.278509378433228, 0.055566668510437, 0.397931218147278, 0.100044250488281, 0.0916687250137329, -0.00205338001251221, 0.27449095249176, 0.0618524551391602, 0.227751016616821, 0.574986100196838, 0.217800855636597, -0.0214906930923462, -0.281588613986969, 0.653811573982239, 0.270663022994995, 0.0452604293823242, 0.348214507102966, -0.0949999094009399, 0.470741987228394, 0.105244398117065, 0.115597367286682, -0.0661961436271667, 0.684275031089783, 0.733457922935486, 0.210579752922058, 0.0413650274276733, 0.305737495422363, 0.805530548095703, 0.353217959403992, 0.306536078453064, 0.157813429832458, 0.215938448905945, 0.174028992652893, 0.324307322502136, 0.304721355438232, -0.0786066651344299, 0.31080436706543, 0.722245931625366, 0.205569386482239, 0.135417342185974, 0.183261871337891, 0.580495595932007, 0.649692535400391, -0.24365222454071, -0.0307736992835999, 0.00197887420654297, -0.0849906802177429 }
};

inline double ReadSVM::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         // normalise variables
         std::vector<double> iV;
         iV.reserve(inputValues.size());
         int ivar = 0;
         for (std::vector<double>::const_iterator varIt = inputValues.begin();
              varIt != inputValues.end(); varIt++, ivar++) {
            iV.push_back(NormVariable( *varIt, fVmin[ivar], fVmax[ivar] ));
         }
         Transform( iV, -1 );
         retval = GetMvaValue__( iV );
   }

   return retval;
}

//_______________________________________________________________________
inline void ReadSVM::InitTransform_1()
{
   double fMin_1[3][4];
   double fMax_1[3][4];
   // Normalization transformation, initialisation
   fMin_1[0][0] = -4.33593845367;
   fMax_1[0][0] = 6.3994679451;
   fScal_1[0][0] = 2.0/(fMax_1[0][0]-fMin_1[0][0]);
   fOff_1[0][0] = fMin_1[0][0]*fScal_1[0][0]+1.;
   fMin_1[1][0] = -9.33803939819;
   fMax_1[1][0] = 7.69307804108;
   fScal_1[1][0] = 2.0/(fMax_1[1][0]-fMin_1[1][0]);
   fOff_1[1][0] = fMin_1[1][0]*fScal_1[1][0]+1.;
   fMin_1[2][0] = -9.33803939819;
   fMax_1[2][0] = 7.69307804108;
   fScal_1[2][0] = 2.0/(fMax_1[2][0]-fMin_1[2][0]);
   fOff_1[2][0] = fMin_1[2][0]*fScal_1[2][0]+1.;
   fMin_1[0][1] = -3.20988440514;
   fMax_1[0][1] = 4.02912044525;
   fScal_1[0][1] = 2.0/(fMax_1[0][1]-fMin_1[0][1]);
   fOff_1[0][1] = fMin_1[0][1]*fScal_1[0][1]+1.;
   fMin_1[1][1] = -3.25508260727;
   fMax_1[1][1] = 3.36500358582;
   fScal_1[1][1] = 2.0/(fMax_1[1][1]-fMin_1[1][1]);
   fOff_1[1][1] = fMin_1[1][1]*fScal_1[1][1]+1.;
   fMin_1[2][1] = -3.25508260727;
   fMax_1[2][1] = 4.02912044525;
   fScal_1[2][1] = 2.0/(fMax_1[2][1]-fMin_1[2][1]);
   fOff_1[2][1] = fMin_1[2][1]*fScal_1[2][1]+1.;
   fMin_1[0][2] = -2.60635733604;
   fMax_1[0][2] = 3.86989831924;
   fScal_1[0][2] = 2.0/(fMax_1[0][2]-fMin_1[0][2]);
   fOff_1[0][2] = fMin_1[0][2]*fScal_1[0][2]+1.;
   fMin_1[1][2] = -5.2777428627;
   fMax_1[1][2] = 4.64297914505;
   fScal_1[1][2] = 2.0/(fMax_1[1][2]-fMin_1[1][2]);
   fOff_1[1][2] = fMin_1[1][2]*fScal_1[1][2]+1.;
   fMin_1[2][2] = -5.2777428627;
   fMax_1[2][2] = 4.64297914505;
   fScal_1[2][2] = 2.0/(fMax_1[2][2]-fMin_1[2][2]);
   fOff_1[2][2] = fMin_1[2][2]*fScal_1[2][2]+1.;
   fMin_1[0][3] = -2.1695792675;
   fMax_1[0][3] = 4.5351858139;
   fScal_1[0][3] = 2.0/(fMax_1[0][3]-fMin_1[0][3]);
   fOff_1[0][3] = fMin_1[0][3]*fScal_1[0][3]+1.;
   fMin_1[1][3] = -5.6007027626;
   fMax_1[1][3] = 4.67435789108;
   fScal_1[1][3] = 2.0/(fMax_1[1][3]-fMin_1[1][3]);
   fOff_1[1][3] = fMin_1[1][3]*fScal_1[1][3]+1.;
   fMin_1[2][3] = -5.6007027626;
   fMax_1[2][3] = 4.67435789108;
   fScal_1[2][3] = 2.0/(fMax_1[2][3]-fMin_1[2][3]);
   fOff_1[2][3] = fMin_1[2][3]*fScal_1[2][3]+1.;
}

//_______________________________________________________________________
inline void ReadSVM::Transform_1( std::vector<double>& iv, int cls) const
{
   // Normalization transformation
   if (cls < 0 || cls > 2) {
   if (2 > 1 ) cls = 2;
      else cls = 2;
   }
   const int nVar = 4;

   // get indices of used variables

   // define the indices of the variables which are transformed by this transformation
   static std::vector<int> indicesGet;
   static std::vector<int> indicesPut;

   if ( indicesGet.empty() ) {
      indicesGet.reserve(fNvars);
      indicesGet.push_back( 0);
      indicesGet.push_back( 1);
      indicesGet.push_back( 2);
      indicesGet.push_back( 3);
   }
   if ( indicesPut.empty() ) {
      indicesPut.reserve(fNvars);
      indicesPut.push_back( 0);
      indicesPut.push_back( 1);
      indicesPut.push_back( 2);
      indicesPut.push_back( 3);
   }

   static std::vector<double> dv;
   dv.resize(nVar);
   for (int ivar=0; ivar<nVar; ivar++) dv[ivar] = iv[indicesGet.at(ivar)];
   for (int ivar=0;ivar<4;ivar++) {
      double offset = fOff_1[cls][ivar];
      double scale  = fScal_1[cls][ivar];
      iv[indicesPut.at(ivar)] = scale*dv[ivar]-offset;
   }
}

//_______________________________________________________________________
inline void ReadSVM::InitTransform()
{
   InitTransform_1();
}

//_______________________________________________________________________
inline void ReadSVM::Transform( std::vector<double>& iv, int sigOrBgd ) const
{
   Transform_1( iv, sigOrBgd );
}
