// Class: ReadLikelihood
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::Likelihood
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:54:59 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 10000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
TransformOutput: "True" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-4.16552305222,4.20716428757]
var2                          var2                          var2                          var2                                                            'F'    [-4.220682621,4.51537322998]
var3                          var3                          var3                          var3                                                            'F'    [-4.52968788147,4.82019376755]
var4                          var4                          var4                          var4                                                            'F'    [-4.64965724945,5.14146757126]
NSpec 5
eta                           eta                           eta                           eta                                                             'F'    [-2.49952101707,2.49992322922]
abs(eta)<=1.3                 FisherCat_cat1                FisherCat_cat1                FisherCat:Category_Fisher_1   pass                              'C'    [0,1]
abs(eta)>1.3                  FisherCat_cat2                FisherCat_cat2                FisherCat:Category_Fisher_2   pass                              'C'    [0,1]
abs(eta)<=1.3                 LikelihoodCat_cat1            LikelihoodCat_cat1            LikelihoodCat:Category_Likelihood_1pass                              'C'    [0,1]
abs(eta)>1.3                  LikelihoodCat_cat2            LikelihoodCat_cat2            LikelihoodCat:Category_Likelihood_2pass                              'C'    [0,1]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <math.h>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihood : public IClassifierReader {

 public:

   // constructor
   ReadLikelihood( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihood" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadLikelihood() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[4]; 
   int    fNbin[4]; // number of bins (discrete variables may have less bins)
   double    fHistMin[4]; 
   double    fHistMax[4]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihood::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = -4.16552305221558;
   fHistMax[0] = 4.20716428756714;
   fNbin[1] = 10000;
   fHistMin[1] = -4.2206826210022;
   fHistMax[1] = 4.51537322998047;
   fNbin[2] = 10000;
   fHistMin[2] = -4.52968788146973;
   fHistMax[2] = 4.82019376754761;
   fNbin[3] = 10000;
   fHistMin[3] = -4.64965724945068;
   fHistMax[3] = 5.14146757125854;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
}

inline double ReadLikelihood::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihood: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihood::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (true) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihood::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihood::fRefS[][10000] = 
{ 
   { 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 2.40853903255055e-15, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 5.35696335646207e-06, 4.32571169994844e-07, 9.37038350912189e-07, 1.44126670420519e-06, 1.98466796064167e-06, 2.52018662649789e-06, 3.0717087611265e-06, 3.63851768270251e-06, 4.20532705902588e-06, 4.78766196465585e-06, 6.28291081739007e-06, 6.98610756444396e-06, 7.72752173361368e-06, 8.49950902193086e-06, 9.28678400669014e-06, 1.01275627457653e-05, 1.09683414848405e-05, 1.18473371912842e-05, 1.27798384710331e-05, 1.37429115056875e-05, 1.46830552694155e-05, 1.56996338773752e-05, 1.67467860592296e-05, 1.78092232090421e-05, 1.88869489647914e-05, 2.00028898689197e-05, 2.11723381653428e-05, 2.23417846427765e-05, 2.3549449906568e-05, 2.4787686925265e-05, 2.60794295172673e-05, 2.73635268968064e-05, 2.86934864561772e-05, 3.00616629829165e-05, 3.14374847221188e-05, 3.28668065776583e-05, 3.43037718266714e-05, 3.58095312549267e-05, 3.72923605027609e-05, 3.88363368983846e-05, 4.03879566874821e-05, 4.19930802308954e-05, 4.36134869232774e-05, 4.52721142210066e-05, 4.69613150926307e-05, 4.86734461446758e-05, 5.04085073771421e-05, 5.21894326084293e-05, 5.40009277756326e-05, 5.5827713367762e-05, 5.76850652578287e-05, 5.95806413912214e-05, 6.15220778854564e-05, 6.34558673482388e-05, 6.54278774163686e-05, 6.7438100813888e-05, 6.94789050612599e-05, 7.15579153620638e-05, 7.36445799702778e-05, 7.57770976633765e-05, 7.79401962063275e-05, 8.01262140157633e-05, 8.2342819951009e-05, 8.45899921841919e-05, 8.68677307153121e-05, 8.91684103407897e-05, 9.1507303295657e-05, 9.38767771003768e-05, 9.62768172030337e-05, 9.86997838481329e-05, 0.000101153331343085, 0.000103637445135973, 0.000106152139778715, 0.000108689760963898, 0.000111265602754429, 0.000113872025394812, 0.000116493720270228, 0.000119161282782443, 0.000121851779113058, 0.000124565194710158, 0.000127316830912605, 0.000130091415485367, 0.000132896559080109, 0.000135747555759735, 0.000138621486257762, 0.000141472497489303, 0.000144438148709014, 0.00014740381448064, 0.000150392399518751, 0.000153380970004946, 0.000156445996253751, 0.000159511007950641, 0.000162614262080751, 0.000165732795721851, 0.000168904807651415, 0.000172115047462285, 0.000175302368006669, 0.000178573784069158, 0.000181852810783312, 0.000185185330337845, 0.000188502614037134, 0.000191888655535877, 0.000195282336790115, 0.000198691312107258, 0.000202169074327685, 0.000205662145162933, 0.000209178106160834, 0.000212732338695787, 0.000216301807085983, 0.0002199095179094, 0.000221996175241657, 0.000225879033678211, 0.000229853641940281, 0.00023384350060951, 0.000237863961956464, 0.000241945555899292, 0.000246073032030836, 0.000250246346695349, 0.000254450220381841, 0.000258684711297974, 0.000262980320258066, 0.000267306488240138, 0.00027167855296284, 0.000276127044344321, 0.000280575535725802, 0.000285069865640253, 0.000289610063191503, 0.000294211407890543, 0.000298812781693414, 0.000303490582155064, 0.000308214250253513, 0.000312968448270112, 0.000317753234412521, 0.00032258388819173, 0.000327460409607738, 0.000332382798660547, 0.000337335717631504, 0.000342334533343092, 0.000347394525306299, 0.000352500297594815, 0.000357636745320633, 0.000362818973371759, 0.000368031789548695, 0.000373275193851441, 0.000378564465790987, 0.000383914884878322, 0.000389295833883807, 0.000394722708733752, 0.000400180142605677, 0.000405698694521561, 0.000411232555052266, 0.000416827562730759, 0.000422483717557043, 0.000428155122790486, 0.000433887704275548, 0.000439666124293581, 0.000445475161541253, 0.000451299449196085, 0.000457184913102537, 0.000463116244645789, 0.000469108694233, 0.000475085864309222, 0.000481139519251883, 0.000487254234030843, 0.000493384257424623, 0.000499575515277684, 0.000505797273945063, 0.000512080150656402, 0.000518378335982561, 0.00052472238894552, 0.000531142868567258, 0.000537593965418637, 0.000544045062270015, 0.000550572527572513, 0.000557130551896989, 0.000563719251658767, 0.000570369011256844, 0.000577064696699381, 0.000583806191571057, 0.000590547744650394, 0.000597380974795669, 0.000604229455348104, 0.00061113917035982, 0.000618048827163875, 0.000625050277449191, 0.000632051611319184, 0.000639144738670439, 0.000646253174636513, 0.000653407420031726, 0.00066060753306374, 0.000667838205117732, 0.000675099494401366, 0.000682437210343778, 0.00068980548530817, 0.000697189068887383, 0.000704633770510554, 0.000712124339770526, 0.000719645468052477, 0.000727212522178888, 0.000734825385734439, 0.000742468808311969, 0.000750203966163099, 0.000757939124014229, 0.000765720149502158, 0.000773547042626888, 0.000781404436565936, 0.000789323123171926, 0.000797272310592234, 0.000805236748419702, 0.00081327767111361, 0.000823351729195565, 0.00083183596143499, 0.000840304885059595, 0.00084885029355064, 0.000857426144648343, 0.000866063288412988, 0.000874730932991952, 0.000883459753822535, 0.000892188574653119, 0.000901009130757302, 0.000909829628653824, 0.000918711361009628, 0.000927623594179749, 0.000936627562623471, 0.000945616280660033, 0.000954681367147714, 0.000963746511843055, 0.000972918700426817, 0.000982106081210077, 0.000991324079222977, 0.001000618445687, 0.00100991292856634, 0.00101928366348147, 0.00102868513204157, 0.00103814783506095, 0.00104764092247933, 0.00105713400989771, 0.00106671894900501, 0.00107638025656343, 0.00108602619729936, 0.00109571812208742, 0.0011054405476898, 0.00111527019180357, 0.00112509960308671, 0.00113494438119233, 0.00114486552774906, 0.00115484790876508, 0.00116484554018825, 0.00117490428965539, 0.00118503952398896, 0.00119517475832254, 0.00120534049347043, 0.00121555209625512, 0.00122582481708378, 0.00123614363837987, 0.00124649272765964, 0.00125687255058438, 0.00126732874196023, 0.00127780030015856, 0.00128831772599369, 0.00129889615345746, 0.00130952068138868, 0.00132017547730356, 0.00133084575645626, 0.00134162302128971, 0.00135241553653032, 0.00136325403582305, 0.0013741230359301, 0.00138500717002898, 0.00139599852263927, 0.00140697450842708, 0.00141802686266601, 0.0014291099505499, 0.00144026929046959, 0.00145142886321992, 0.00146264932118356, 0.00147390039637685, 0.00148522818926722, 0.00149655563291162, 0.00150797504466027, 0.00151942472439259, 0.00153089000377804, 0.0015424161683768, 0.00155395781621337, 0.00156559108290821, 0.00157725508324802, 0.00158891908358783, 0.00160065945237875, 0.00161246093921363, 0.00162427767645568, 0.00163612491451204, 0.00164803338702768, 0.00166001834440976, 0.00167198793496937, 0.00168406462762505, 0.00169612606987357, 0.00170827901456505, 0.00172044744249433, 0.00173263112083077, 0.00174490641802549, 0.00175721233244985, 0.00176956423092633, 0.00178191601298749, 0.00179437478072941, 0.00180683354847133, 0.00181935355067253, 0.00183188880328089, 0.00184451579116285, 0.00185714277904481, 0.00186986138578504, 0.00188300048466772, 0.00189617020078003, 0.00190931686665863, 0.00192253233399242, 0.00193577853497118, 0.00194904755335301, 0.00196236232295632, 0.00197567720897496, 0.00198903796263039, 0.0020024215336889, 0.00201584352180362, 0.00202929601073265, 0.00204275618307292, 0.00205629272386432, 0.00206981389783323, 0.00208339630626142, 0.00209699408151209, 0.00211064517498016, 0.00212428881786764, 0.00213797832839191, 0.00215169042348862, 0.00216547166928649, 0.00217922986485064, 0.00219303392805159, 0.00220689130946994, 0.00222077197395265, 0.00223465240560472, 0.00224858638830483, 0.00226257392205298, 0.00227654608897865, 0.00229056435637176, 0.00230459752492607, 0.00231870729476213, 0.00233282474800944, 0.00234695756807923, 0.00236112088896334, 0.00237534521147609, 0.00238957745023072, 0.00240382482297719, 0.00241809501312673, 0.00243244925513864, 0.00244678859598935, 0.0024611814878881, 0.0024755890481174, 0.00249004270881414, 0.00250451941974461, 0.00251901149749756, 0.0025335643440485, 0.00254811742343009, 0.00256269401870668, 0.00257733068428934, 0.00259198341518641, 0.00260668946430087, 0.00262139504775405, 0.00263612437993288, 0.00265091448090971, 0.00266570458188653, 0.00268054031766951, 0.00269539165310562, 0.0027103116735816, 0.00272522401064634, 0.00274018198251724, 0.00275516323745251, 0.00277018244378269, 0.00278522470034659, 0.00280030537396669, 0.00281540118157864, 0.00283055077306926, 0.00284569966606796, 0.00286090280860662, 0.00287614366970956, 0.00289140758104622, 0.00290668685920537, 0.00292198895476758, 0.00293733715079725, 0.00295273866504431, 0.00296812504529953, 0.00298355706036091, 0.00299903494305909, 0.00301453587599099, 0.00303004449233413, 0.00304560665972531, 0.00306121446192265, 0.00307681458070874, 0.00309245311655104, 0.00310812215320766, 0.00312385242432356, 0.0031395903788507, 0.00315535883419216, 0.00317114987410605, 0.00318699493072927, 0.00320285488851368, 0.00321872299537063, 0.00323463627137244, 0.00325061124749482, 0.00326657085679471, 0.00328257610090077, 0.00329861207865179, 0.0033147013746202, 0.00333080627024174, 0.0033432194031775, 0.00335954967886209, 0.0033758832141757, 0.00339222908951342, 0.00340858567506075, 0.00342492782510817, 0.00344128836877644, 0.00345767242833972, 0.00347404810599983, 0.00349040888249874, 0.00350679270923138, 0.00352318398654461, 0.00353957549668849, 0.00355596281588078, 0.00357236596755683, 0.00358877261169255, 0.00360520230606198, 0.00362161640077829, 0.00363803841173649, 0.00365447183139622, 0.00367090501822531, 0.00368732330389321, 0.00370377954095602, 0.00372023205272853, 0.00373668828979135, 0.00375315244309604, 0.00376961636357009, 0.00378609541803598, 0.00380256352946162, 0.0038190505001694, 0.00383552955463529, 0.003852020483464, 0.00386851839721203, 0.00388502096757293, 0.00390153448097408, 0.00391804426908493, 0.00393457338213921, 0.0039510945789516, 0.00396761251613498, 0.00398415233939886, 0.00400068517774343, 0.00401723710820079, 0.00403376994654536, 0.00405035214498639, 0.00406690826639533, 0.00408347509801388, 0.00410004239529371, 0.00411661341786385, 0.00413319608196616, 0.00414978200569749, 0.00416638003662229, 0.0041829664260149, 0.00419958727434278, 0.00421619601547718, 0.00423280894756317, 0.00424941862002015, 0.00426604272797704, 0.00428267102688551, 0.00429930351674557, 0.00431594299152493, 0.00433258293196559, 0.00434923404827714, 0.00436590844765306, 0.00438255537301302, 0.00439922977238894, 0.00441589625552297, 0.00443258183076978, 0.00444925250485539, 0.00446593435481191, 0.00448263110592961, 0.00449932832270861, 0.00451604044064879, 0.00453274929895997, 0.00454945815727115, 0.00456618145108223, 0.00458290195092559, 0.00459962571039796, 0.00461635692045093, 0.00463310768827796, 0.00464985053986311, 0.00466660503298044, 0.00468336325138807, 0.00470012566074729, 0.00471688760444522, 0.00473365327343345, 0.00475043803453445, 0.00476721581071615, 0.00478400057181716, 0.00480080861598253, 0.00481760129332542, 0.00483440514653921, 0.00485121319070458, 0.00486801750957966, 0.00488483672961593, 0.00490165967494249, 0.00491849472746253, 0.0049353176727891, 0.00495216017588973, 0.00496902549639344, 0.00498586799949408, 0.00500417361035943, 0.00502079073339701, 0.00503738457337022, 0.00505397096276283, 0.00507052661851048, 0.00508705945685506, 0.00510360021144152, 0.00512009812518954, 0.00513657368719578, 0.00515303388237953, 0.00516949407756329, 0.00518590491265059, 0.00520233390852809, 0.00521870981901884, 0.0052350708283484, 0.00525142392143607, 0.00526775000616908, 0.0052840537391603, 0.00530035328119993, 0.00531663745641708, 0.00533288065344095, 0.00534911081194878, 0.00536534236744046, 0.00538153480738401, 0.0053977039642632, 0.00541387358680367, 0.00542999757453799, 0.00544611783698201, 0.00546224182471633, 0.00547830807045102, 0.00549436314031482, 0.00551042193546891, 0.00552643509581685, 0.00554244453087449, 0.00555843394249678, 0.00557439355179667, 0.00559033779427409, 0.00560627086088061, 0.00562217319384217, 0.00563806761056185, 0.00565395457670093, 0.00566979218274355, 0.005685621406883, 0.00570144690573215, 0.00571723468601704, 0.00573300663381815, 0.00574877532199025, 0.00576449790969491, 0.00578021258115768, 0.00579593516886234, 0.00581158930435777, 0.00582725089043379, 0.00584291154518723, 0.0058585163205862, 0.0058741238899529, 0.0058897128328681, 0.00590526731684804, 0.00592080969363451, 0.00593634182587266, 0.00595184275880456, 0.00596733577549458, 0.0059828138910234, 0.00599825754761696, 0.00601368583738804, 0.00602911040186882, 0.00604448840022087, 0.0060598598793149, 0.00607520807534456, 0.00609055161476135, 0.00610586162656546, 0.00612118281424046, 0.00613643601536751, 0.00615169573575258, 0.00616693263873458, 0.00618215464055538, 0.00619735335931182, 0.00621253298595548, 0.00622770236805081, 0.00624284381046891, 0.00625795824453235, 0.00627306615933776, 0.0062881582416594, 0.00630322704091668, 0.00631827721372247, 0.00633329572156072, 0.00634830771014094, 0.00636329641565681, 0.00637827022001147, 0.00639321655035019, 0.00640815263614058, 0.00642306869849563, 0.0064379614777863, 0.00645283190533519, 0.00646768696606159, 0.00648253038525581, 0.00649734726175666, 0.00651214132085443, 0.00652692001312971, 0.00654168706387281, 0.00655642710626125, 0.00657266564667225, 0.00658693630248308, 0.00660117575898767, 0.00661537749692798, 0.00662955548614264, 0.00664368085563183, 0.00665781414136291, 0.00667188502848148, 0.00668593402951956, 0.00669996719807386, 0.0067139551974833, 0.00672789663076401, 0.00674183014780283, 0.00675573386251926, 0.00676959147676826, 0.00678342627361417, 0.00679723033681512, 0.00681100413203239, 0.00682473881170154, 0.00683845859020948, 0.00685215601697564, 0.00686579942703247, 0.00687940465286374, 0.0068930103443563, 0.00690657738596201, 0.00692009832710028, 0.00693359691649675, 0.00694706477224827, 0.00696049397811294, 0.00697390083223581, 0.00698727648705244, 0.00700061488896608, 0.00701394490897655, 0.00702723674476147, 0.00704046711325645, 0.0070537137798965, 0.00706689851358533, 0.0070800450630486, 0.00709318416193128, 0.00710628554224968, 0.00711934035643935, 0.00713238772004843, 0.00714538898319006, 0.00715835206210613, 0.00717131607234478, 0.00718423305079341, 0.00719712022691965, 0.00720997620373964, 0.00722280191257596, 0.00723558152094483, 0.00724834622815251, 0.00726108020171523, 0.00727376854047179, 0.00728644896298647, 0.0072990832850337, 0.00731167988851666, 0.00732426811009645, 0.00733681162819266, 0.00734931603074074, 0.0073618208989501, 0.00737427966669202, 0.00738669279962778, 0.00739909755066037, 0.00741145759820938, 0.00742377107962966, 0.00743608456104994, 0.00744836730882525, 0.00746058952063322, 0.0074728038161993, 0.00748497992753983, 0.00749711692333221, 0.00750923994928598, 0.00752133969217539, 0.00753338541835546, 0.00754542462527752, 0.00755740888416767, 0.00756935542449355, 0.00758130988106132, 0.00759319541975856, 0.00760507304221392, 0.00761689804494381, 0.00762873003259301, 0.00764047773554921, 0.0076522333547473, 0.0076639661565423, 0.00767563749104738, 0.00768729392439127, 0.00769894244149327, 0.00771052995696664, 0.00772207090631127, 0.00773362815380096, 0.00774511648342013, 0.00775658199563622, 0.00776803167536855, 0.00777943525463343, 0.0077908169478178, 0.00780216744169593, 0.00781347136944532, 0.00782476179301739, 0.00783605128526688, 0.00784736499190331, 0.00785814225673676, 0.00786890368908644, 0.00787962693721056, 0.00789032038301229, 0.00790099892765284, 0.00791163835674524, 0.00792226288467646, 0.00793285667896271, 0.00794343464076519, 0.00795398280024529, 0.00796450767666101, 0.00797502510249615, 0.00798548944294453, 0.00799593795090914, 0.00800636410713196, 0.00801675859838724, 0.00802712328732014, 0.00803747307509184, 0.008047791197896, 0.00805808696895838, 0.00806834455579519, 0.00807859376072884, 0.00808881316334009, 0.00809901021420956, 0.00810919050127268, 0.00811933446675539, 0.00812946166843176, 0.00813955068588257, 0.00814962480217218, 0.00815966911613941, 0.00816968083381653, 0.00817966368049383, 0.00818963814526796, 0.00819956697523594, 0.00820948835462332, 0.00821937900036573, 0.00822924729436636, 0.00823909882456064, 0.00824891403317451, 0.00825870502740145, 0.00826847273856401, 0.0082782031968236, 0.00828792620450258, 0.00829761754721403, 0.00830727908760309, 0.00831691734492779, 0.00832651741802692, 0.00833611004054546, 0.00834566447883844, 0.00835520308464766, 0.00836473423987627, 0.00837420485913754, 0.0083836754783988, 0.00839311443269253, 0.00840253196656704, 0.00841190293431282, 0.00842125806957483, 0.00843059923499823, 0.00843990873545408, 0.0084491865709424, 0.00845844391733408, 0.00846767704933882, 0.00847687944769859, 0.00848606694489717, 0.00849523954093456, 0.00850438047200441, 0.00851347669959068, 0.00852255616337061, 0.00853162165731192, 0.00854065641760826, 0.00854964554309845, 0.00855863373726606, 0.00856759212911129, 0.00857652071863413, 0.00858541671186686, 0.00859429873526096, 0.00860314909368753, 0.00861200131475925, 0.00862079858779907, 0.0086295809596777, 0.00863833259791136, 0.00864706933498383, 0.00865576323121786, 0.0086644422262907, 0.00867309514433146, 0.00868172477930784, 0.00869032368063927, 0.00869889184832573, 0.00870744790881872, 0.0087159713730216, 0.00872449297457933, 0.00873295869678259, 0.00874140858650208, 0.00874984264373779, 0.00875824317336082, 0.0087666092440486, 0.0087749594822526, 0.00878328271210194, 0.00879158359020948, 0.00879920832812786, 0.00880700815469027, 0.00881479308009148, 0.00882259290665388, 0.00883038155734539, 0.0088381739333272, 0.00884596351534128, 0.00885375216603279, 0.00886153616011143, 0.00886932108551264, 0.00887710228562355, 0.00888488348573446, 0.00889266096055508, 0.00890043005347252, 0.00890820752829313, 0.00891597010195255, 0.00892374292016029, 0.00893151201307774, 0.00893927831202745, 0.00894704461097717, 0.00895480532199144, 0.00896257162094116, 0.00897033419460058, 0.00897809211164713, 0.00898583885282278, 0.00899359304457903, 0.00900134351104498, 0.00900909770280123, 0.00901684444397688, 0.00902459118515253, 0.00903233047574759, 0.00904007256031036, 0.00904781557619572, 0.00905554369091988, 0.00906328205019236, 0.00907101761549711, 0.009078748524189, 0.00908648036420345, 0.00909421499818563, 0.00910194311290979, 0.00910966657102108, 0.00911739002913237, 0.00912510696798563, 0.00913281925022602, 0.00914053432643414, 0.0091482549905777, 0.00915596634149551, 0.00916367955505848, 0.00917139183729887, 0.00917910039424896, 0.00918680429458618, 0.00919450912624598, 0.00920221395790577, 0.00920991413295269, 0.00921761151403189, 0.00922531262040138, 0.00923299789428711, 0.00924069527536631, 0.00924838054925203, 0.00925607327371836, 0.00926376320421696, 0.00927144847810268, 0.00927913375198841, 0.00928681530058384, 0.00929449778050184, 0.00930217932909727, 0.0093098571524024, 0.00931752659380436, 0.00932520441710949, 0.0093328757211566, 0.00934053771197796, 0.00934820435941219, 0.00935586635023355, 0.00936353392899036, 0.0093712005764246, 0.00937885511666536, 0.00938651338219643, 0.00939417164772749, 0.00940182711929083, 0.00940947793424129, 0.00941712874919176, 0.0094247804954648, 0.00943242758512497, 0.00944006349891424, 0.00944769941270351, 0.00945534277707338, 0.00946298241615295, 0.00947061832994223, 0.0094782579690218, 0.00948589481413364, 0.00949352234601974, 0.00950115732848644, 0.00950878206640482, 0.0095164068043232, 0.00952403526753187, 0.00953165907412767, 0.00953928008675575, 0.00954689644277096, 0.00955450907349586, 0.00956212636083364, 0.00957274157553911, 0.00957999471575022, 0.00958730280399323, 0.00959464441984892, 0.0096020083874464, 0.00960941147059202, 0.00961687136441469, 0.00962438061833382, 0.00963192526251078, 0.00963948108255863, 0.00964708905667067, 0.0096547519788146, 0.00966243725270033, 0.00967017281800508, 0.00967791955918074, 0.00968573149293661, 0.00969358067959547, 0.0097014531493187, 0.00970934983342886, 0.00971732940524817, 0.00972533226013184, 0.00973338726907969, 0.00974143575876951, 0.00974956527352333, 0.00975772179663181, 0.00976590346544981, 0.00977411679923534, 0.00978240557014942, 0.00979072879999876, 0.00979908090084791, 0.0098074758425355, 0.00981586426496506, 0.00982433743774891, 0.00983285997062922, 0.00984140858054161, 0.00984996277838945, 0.00985858775675297, 0.00986724719405174, 0.00987594574689865, 0.00988466758280993, 0.00989345833659172, 0.00990228541195393, 0.00991115160286427, 0.00992002710700035, 0.00992894917726517, 0.00993791595101357, 0.00994693487882614, 0.00995600782334805, 0.00996506959199905, 0.00997419841587543, 0.00998335238546133, 0.00999257434159517, 0.0100017869845033, 0.0100110862404108, 0.010020419023931, 0.0100297778844833, 0.0100391609594226, 0.0100486082956195, 0.0100580789148808, 0.0100675905123353, 0.0100771533325315, 0.0100867217406631, 0.0100963795557618, 0.0101060559973121, 0.0101157557219267, 0.0101254740729928, 0.0101352818310261, 0.0101451063528657, 0.0101549904793501, 0.0101648615673184, 0.0101748201996088, 0.0101847909390926, 0.0101948082447052, 0.0102048479020596, 0.0102149564772844, 0.0102250995114446, 0.0102352853864431, 0.0102455066516995, 0.0102557232603431, 0.0102660376578569, 0.0102763716131449, 0.0102867437526584, 0.0102971438318491, 0.0103075727820396, 0.0103180631995201, 0.0103285992518067, 0.0103391483426094, 0.0103497644886374, 0.010360418818891, 0.0103710927069187, 0.0103817945346236, 0.0103925438597798, 0.0104033490642905, 0.0104141905903816, 0.0104250758886337, 0.0104359788820148, 0.0104469358921051, 0.0104579161852598, 0.0104689644649625, 0.0104800006374717, 0.0104872183874249, 0.0104984687641263, 0.0105097647756338, 0.0105211697518826, 0.0105327107012272, 0.0105442674830556, 0.0105559481307864, 0.0105677172541618, 0.0105795189738274, 0.0105914426967502, 0.0106034744530916, 0.0106155509129167, 0.0106277344748378, 0.0106399934738874, 0.0106523614376783, 0.0106648057699203, 0.0106772789731622, 0.01068992074579, 0.0107026407495141, 0.0107154054567218, 0.0107282614335418, 0.010741239413619, 0.0107543086633086, 0.0107675027102232, 0.0107807563617826, 0.0107940249145031, 0.0108074173331261, 0.0108209140598774, 0.0108344741165638, 0.0108481394127011, 0.0108618373051286, 0.0108756870031357, 0.0108896140009165, 0.0109035857021809, 0.0109176803380251, 0.0109318662434816, 0.0109461443498731, 0.0109604382887483, 0.0109748998656869, 0.0109894527122378, 0.0110040372237563, 0.0110187875106931, 0.0110335862264037, 0.0110484752804041, 0.0110633801668882, 0.0110784377902746, 0.0110935559496284, 0.0111087821424007, 0.0111240837723017, 0.0111394934356213, 0.0111549338325858, 0.0111704794690013, 0.0111861489713192, 0.0112019097432494, 0.0112176705151796, 0.0112336147576571, 0.011249634437263, 0.0112657025456429, 0.0112818451598287, 0.011298093944788, 0.0113145122304559, 0.0113309472799301, 0.0113474559038877, 0.0113640269264579, 0.0113807516172528, 0.0113975359126925, 0.0114143826067448, 0.0114313196390867, 0.0114483498036861, 0.0114655010402203, 0.0114826997742057, 0.0114999739453197, 0.0115173384547234, 0.0115348417311907, 0.0115524223074317, 0.0115700177848339, 0.0115877501666546, 0.0116055607795715, 0.0116234607994556, 0.0116415452212095, 0.0116595989093184, 0.0116777596995234, 0.0116960275918245, 0.0117143411189318, 0.0117327617481351, 0.0117512429133058, 0.0117698786780238, 0.0117885591462255, 0.0118073169142008, 0.0118261650204659, 0.0118451518937945, 0.0118641378358006, 0.0118832476437092, 0.0119024617597461, 0.0119217531755567, 0.0119411377236247, 0.0119606433436275, 0.0119801815599203, 0.0119998389855027, 0.0120195597410202, 0.0120388828217983, 0.0120592443272471, 0.0120797296985984, 0.0121003352105618, 0.01212103292346, 0.0121419467031956, 0.0121629508212209, 0.0121840164065361, 0.012205233797431, 0.0122265741229057, 0.0122480988502502, 0.0122697129845619, 0.0122914221137762, 0.0123132821172476, 0.0123352641239762, 0.0123574296012521, 0.0123796872794628, 0.0124019766226411, 0.0124245397746563, 0.012447165325284, 0.0124698495492339, 0.0124927200376987, 0.0125157106667757, 0.0125388549640775, 0.0125620914623141, 0.0125853884965181, 0.0126089295372367, 0.0126325637102127, 0.0126562584191561, 0.0126801365986466, 0.0127041377127171, 0.0127282282337546, 0.0127525050193071, 0.0127768712118268, 0.0128014236688614, 0.0128260655328631, 0.0128507381305099, 0.0128756258636713, 0.0129006337374449, 0.0129257654771209, 0.0129509903490543, 0.0129763344302773, 0.0130018331110477, 0.013027454726398, 0.0130532281473279, 0.0130790630355477, 0.0131050506606698, 0.0131312208250165, 0.0131574543192983, 0.0131837781518698, 0.0132102845236659, 0.0132369454950094, 0.0132637284696102, 0.0132906334474683, 0.0133175691589713, 0.0133447488769889, 0.0133720207959414, 0.0133993532508612, 0.0134268701076508, 0.0134545089676976, 0.0134822390973568, 0.0135101536288857, 0.0135381277650595, 0.013566286303103, 0.0135945370420814, 0.0136228790506721, 0.013651373796165, 0.0136800203472376, 0.0137087907642126, 0.0137376533821225, 0.0137666678056121, 0.0137958656996489, 0.013825124129653, 0.013854474760592, 0.0138839790597558, 0.0139136351644993, 0.0139433536678553, 0.0139732854440808, 0.0140032470226288, 0.0140333622694016, 0.0140636302530766, 0.0140940509736538, 0.014124533161521, 0.0141551373526454, 0.014185955747962, 0.0142168663442135, 0.014247776940465, 0.0142789306119084, 0.0143102686852217, 0.0143416682258248, 0.0143731581047177, 0.0144047727808356, 0.0144366305321455, 0.0144685190171003, 0.0145004689693451, 0.0145326023921371, 0.0145649183541536, 0.0145972957834601, 0.0146297961473465, 0.0146623877808452, 0.0146983116865158, 0.0147316977381706, 0.0147651759907603, 0.0147989597171545, 0.0148328058421612, 0.0148668652400374, 0.0149010149762034, 0.0149351973086596, 0.0149697763845325, 0.0150043247267604, 0.0150390565395355, 0.0150739094242454, 0.0151089476421475, 0.015144138596952, 0.015179481357336, 0.0152148846536875, 0.0152505040168762, 0.0152862751856446, 0.0153221692889929, 0.0153582151979208, 0.0153943235054612, 0.0154307670891285, 0.0154672414064407, 0.0155038079246879, 0.0155405886471272, 0.0155775211751461, 0.0156145766377449, 0.0156518146395683, 0.0156890545040369, 0.0157266911119223, 0.0157642979174852, 0.0158020555973053, 0.0158400572836399, 0.0158780608326197, 0.015916308388114, 0.0159546788781881, 0.0159931406378746, 0.0160318780690432, 0.0160706453025341, 0.0161095969378948, 0.0161486696451902, 0.016187896952033, 0.0162273366004229, 0.016266867518425, 0.0163064915686846, 0.0163464210927486, 0.0163862891495228, 0.0164264030754566, 0.0164666678756475, 0.0165070872753859, 0.0165476873517036, 0.0165883507579565, 0.0166291370987892, 0.0166701655834913, 0.016711350530386, 0.0167525634169579, 0.0167939607053995, 0.0168356020003557, 0.0168773047626019, 0.0169191900640726, 0.0169611070305109, 0.0170032996684313, 0.0170456133782864, 0.0170880183577538, 0.0171306375414133, 0.0171733498573303, 0.0172162465751171, 0.0172592308372259, 0.0173023696988821, 0.0173456333577633, 0.0173892006278038, 0.0174327380955219, 0.0174765195697546, 0.0175203941762447, 0.017564419656992, 0.0176086593419313, 0.0176528990268707, 0.0176974162459373, 0.0177420526742935, 0.0177868138998747, 0.0178317558020353, 0.0178767014294863, 0.0179220102727413, 0.0179673209786415, 0.0180127527564764, 0.0180584602057934, 0.0181042291224003, 0.0181501507759094, 0.0181962568312883, 0.0182423628866673, 0.0182888340204954, 0.0183353070169687, 0.0183819010853767, 0.0184287708252668, 0.0184757318347692, 0.0185227524489164, 0.0185700505971909, 0.0186173487454653, 0.0186649542301893, 0.018712617456913, 0.0187600068747997, 0.0188085567206144, 0.0188571698963642, 0.0189059339463711, 0.0189548525959253, 0.019003864377737, 0.019053116440773, 0.019102493301034, 0.0191519930958748, 0.0192015841603279, 0.0192513894289732, 0.0193012841045856, 0.0193513929843903, 0.0194015372544527, 0.0194519516080618, 0.0195025205612183, 0.0195531528443098, 0.0196039639413357, 0.0196548700332642, 0.0197059903293848, 0.0197571702301502, 0.0198085643351078, 0.0198600813746452, 0.0199117194861174, 0.0199635736644268, 0.020015487447381, 0.0200676135718822, 0.0201198980212212, 0.0201722700148821, 0.0202247649431229, 0.0202773809432983, 0.0203303061425686, 0.0203831978142262, 0.0204363353550434, 0.0204895958304405, 0.0205429773777723, 0.0205965731292963, 0.0206501986831427, 0.0207040403038263, 0.0207581240683794, 0.0208121482282877, 0.0208664201200008, 0.020920779556036, 0.0209753513336182, 0.0210300777107477, 0.0210849270224571, 0.0211399309337139, 0.0211950875818729, 0.0212503336369991, 0.0213056690990925, 0.0213612858206034, 0.0214169602841139, 0.0214728768914938, 0.0215288903564215, 0.0215849615633488, 0.0216413401067257, 0.0216977167874575, 0.0217543095350266, 0.0218109935522079, 0.0218678917735815, 0.0219249743968248, 0.0219820234924555, 0.0220393482595682, 0.0220967959612608, 0.0221543665975332, 0.0222121812403202, 0.0222699679434299, 0.0223280563950539, 0.0223862081766129, 0.0224445126950741, 0.0225029699504375, 0.0225615203380585, 0.0226203128695488, 0.022679228335619, 0.0227382369339466, 0.0227974243462086, 0.0228567682206631, 0.022916205227375, 0.0229758843779564, 0.0230355970561504, 0.0230954606086016, 0.0231555365025997, 0.0232156738638878, 0.0232760887593031, 0.0233365632593632, 0.0233971290290356, 0.02345797047019, 0.0235188156366348, 0.0235799625515938, 0.0236411094665527, 0.0237024091184139, 0.0237639546394348, 0.0238255616277456, 0.0238873511552811, 0.0239492636173964, 0.0240113269537687, 0.0240735430270433, 0.024135947227478, 0.0241984706372023, 0.0242610853165388, 0.0243207029998302, 0.0243841744959354, 0.0244477987289429, 0.0245114546269178, 0.0245753228664398, 0.0246393717825413, 0.0247033331543207, 0.024767629802227, 0.0248319264501333, 0.024896377697587, 0.0249610114842653, 0.025025611743331, 0.0250904280692339, 0.0251553393900394, 0.0252204574644566, 0.0252856407314539, 0.0253508854657412, 0.0254164058715105, 0.0254818648099899, 0.0255475994199514, 0.0256133321672678, 0.0256792474538088, 0.0257453508675098, 0.025811480358243, 0.025877732783556, 0.0259441081434488, 0.026010699570179, 0.0260772593319416, 0.0261440929025412, 0.0262110494077206, 0.0262779742479324, 0.0263451766222715, 0.0264123789966106, 0.0264797303825617, 0.0265472382307053, 0.0266148969531059, 0.0266826190054417, 0.0267504621297121, 0.0268185175955296, 0.0268865767866373, 0.0269548483192921, 0.0270231813192368, 0.0270916633307934, 0.0271603018045425, 0.027228944003582, 0.0272978246212006, 0.0273667983710766, 0.0274358633905649, 0.0275051146745682, 0.0275744572281837, 0.0276438910514116, 0.0277134440839291, 0.0277831833809614, 0.0278529226779938, 0.0279229059815407, 0.0279930420219898, 0.028063178062439, 0.0281335283070803, 0.0282039400190115, 0.0282744728028774, 0.0283451899886131, 0.0284160003066063, 0.0284868981689215, 0.0285579226911068, 0.0286291278898716, 0.0287003647536039, 0.0287718176841736, 0.0288433916866779, 0.0289149638265371, 0.0289868116378784, 0.0290586594492197, 0.0291306599974632, 0.0292028151452541, 0.0292751509696245, 0.0293475184589624, 0.029419980943203, 0.0294926557689905, 0.0295653585344553, 0.0296382773667574, 0.0297112576663494, 0.0297843907028437, 0.029857674613595, 0.0299310218542814, 0.0300044603645802, 0.0300780814141035, 0.0301517955958843, 0.0302256606519222, 0.03029964864254, 0.0303737595677376, 0.0304479617625475, 0.0305223483592272, 0.0305967032909393, 0.030671363696456, 0.0307461190968752, 0.0308208707720041, 0.0308958366513252, 0.0309709273278713, 0.0310461092740297, 0.0311214718967676, 0.0311968680471182, 0.0312711596488953, 0.0313472896814346, 0.0314235277473927, 0.031499732285738, 0.0315761044621468, 0.0316526181995869, 0.0317290797829628, 0.0318056829273701, 0.0318823605775833, 0.0319591015577316, 0.0320359505712986, 0.03211285546422, 0.0321898423135281, 0.0322669483721256, 0.0323440842330456, 0.0324212871491909, 0.0324986055493355, 0.0325760170817375, 0.0326534621417522, 0.0327310599386692, 0.0328086540102959, 0.0328863598406315, 0.0329641401767731, 0.033042024821043, 0.0331198982894421, 0.0331979356706142, 0.0332760997116566, 0.0333542414009571, 0.0334324836730957, 0.0335108712315559, 0.0335892327129841, 0.0336677469313145, 0.0337463244795799, 0.0338249728083611, 0.0339037477970123, 0.0339825227856636, 0.0340614169836044, 0.0341403856873512, 0.0342193879187107, 0.0342985466122627, 0.0343777909874916, 0.034457053989172, 0.0345364697277546, 0.0346159003674984, 0.0346953943371773, 0.0347750075161457, 0.0348547287285328, 0.0349344499409199, 0.0350143387913704, 0.0350942611694336, 0.0351742096245289, 0.0352543145418167, 0.035334475338459, 0.0354146733880043, 0.0354950353503227, 0.0355754606425762, 0.0356559120118618, 0.035736445337534, 0.0358171314001083, 0.0358977988362312, 0.0359786041080952, 0.0360594727098942, 0.0361404307186604, 0.0362214855849743, 0.0363025814294815, 0.036383755505085, 0.0364650338888168, 0.0365463756024837, 0.0366277806460857, 0.0367093496024609, 0.0367909334599972, 0.0368725806474686, 0.0369543097913265, 0.0370361059904099, 0.0371179990470409, 0.0372000262141228, 0.0372820571064949, 0.0373642109334469, 0.037446454167366, 0.0375286974012852, 0.0376110933721066, 0.0376935489475727, 0.0377760380506516, 0.037858709692955, 0.0379414260387421, 0.0380241721868515, 0.0381070300936699, 0.0381899923086166, 0.0382729507982731, 0.0383560508489609, 0.0384392440319061, 0.0385224670171738, 0.0386058390140533, 0.0386892445385456, 0.0387726798653603, 0.038856253027916, 0.0389399342238903, 0.0390236303210258, 0.0391074791550636, 0.0391913615167141, 0.0392834767699242, 0.0393676310777664, 0.0394517630338669, 0.0395359247922897, 0.0396201647818089, 0.0397043861448765, 0.0397886075079441, 0.0398728884756565, 0.0399571731686592, 0.040041483938694, 0.0401258394122124, 0.0402101837098598, 0.0402946099638939, 0.0403790064156055, 0.0404634550213814, 0.0405478924512863, 0.0406323783099651, 0.0407168939709663, 0.0408014580607414, 0.040886003524065, 0.0409705825150013, 0.0410551801323891, 0.0411398075520992, 0.0412244573235512, 0.0413091145455837, 0.0413938537240028, 0.0414785817265511, 0.0415633320808411, 0.0416480712592602, 0.0417328737676144, 0.0418176874518394, 0.0419025421142578, 0.041987381875515, 0.0420723035931587, 0.0421572215855122, 0.0422421619296074, 0.0423270910978317, 0.0424120873212814, 0.0424970872700214, 0.0425821579992771, 0.0426671914756298, 0.0427522733807564, 0.0428373664617538, 0.0429225042462349, 0.0430076345801353, 0.0430928096175194, 0.0431780330836773, 0.0432632751762867, 0.0433485209941864, 0.0434337854385376, 0.0435190722346306, 0.0436043739318848, 0.043689738959074, 0.0437750779092312, 0.0438604950904846, 0.0439458973705769, 0.0440313518047333, 0.0441167950630188, 0.0442022755742073, 0.0442877858877182, 0.0443733260035515, 0.0444588921964169, 0.0445444770157337, 0.0446300730109215, 0.0447157025337219, 0.044801339507103, 0.0448870249092579, 0.0449727065861225, 0.0450584813952446, 0.0451442040503025, 0.045229971408844, 0.0453157685697079, 0.0454015918076038, 0.0454874373972416, 0.0455732755362988, 0.0456591919064522, 0.0457451157271862, 0.0458310507237911, 0.0459169931709766, 0.046002984046936, 0.0460890009999275, 0.0461750254034996, 0.0462610684335232, 0.0463471673429012, 0.0464332774281502, 0.0465194173157215, 0.0466055311262608, 0.0466917268931866, 0.0467779226601124, 0.0468641594052315, 0.0469503998756409, 0.0470366664230824, 0.0471229702234268, 0.0472092814743519, 0.0472956039011478, 0.0473819822072983, 0.0474683716893196, 0.0475548133254051, 0.0476412586867809, 0.0477276891469955, 0.0478107668459415, 0.0478969290852547, 0.0479830540716648, 0.0480691492557526, 0.0481552295386791, 0.0482412725687027, 0.0483273044228554, 0.0484132841229439, 0.0484992377460003, 0.0485851727426052, 0.0486710965633392, 0.0487569496035576, 0.0488427951931953, 0.0489286221563816, 0.0490144155919552, 0.0491001605987549, 0.0491858907043934, 0.049271609634161, 0.0493572801351547, 0.0494429133832455, 0.0495285354554653, 0.0496141389012337, 0.0496997125446796, 0.0497852154076099, 0.0498707368969917, 0.0499562099575996, 0.0500416606664658, 0.0501270852982998, 0.0502124540507793, 0.0502978153526783, 0.0503831617534161, 0.0504684783518314, 0.0505537241697311, 0.050638984888792, 0.0507242120802402, 0.0508094057440758, 0.0508945472538471, 0.0509796887636185, 0.0510647967457771, 0.0511498786509037, 0.0512349121272564, 0.0513199344277382, 0.0514049418270588, 0.0514898858964443, 0.0515748038887978, 0.0516597181558609, 0.051744606345892, 0.05182945728302, 0.0519142597913742, 0.0519990622997284, 0.052083820104599, 0.0521685667335987, 0.0522532686591148, 0.0523379407823086, 0.0524225793778896, 0.0525072067975998, 0.0525918118655682, 0.0526763461530209, 0.0527608878910542, 0.052845411002636, 0.0529298856854439, 0.0530143119394779, 0.0530987419188023, 0.0531831309199333, 0.0532675087451935, 0.0533518195152283, 0.0534361265599728, 0.0535204149782658, 0.0536046661436558, 0.0536888688802719, 0.0537730641663074, 0.0538572408258915, 0.0539413690567017, 0.0540254525840282, 0.0541095398366451, 0.0541935935616493, 0.054277628660202, 0.0543616227805614, 0.0544455610215664, 0.0545295029878616, 0.0546134300529957, 0.0546972900629044, 0.0547811351716518, 0.0548649542033672, 0.0549487546086311, 0.0550325177609921, 0.0551162324845791, 0.0551999546587467, 0.0552836284041405, 0.0553672835230827, 0.0554508827626705, 0.0555344820022583, 0.0556180514395237, 0.0557015836238861, 0.0557850897312164, 0.055868573486805, 0.0559520162642002, 0.0560354441404343, 0.056118831038475, 0.0562021806836128, 0.0562851130962372, 0.0563677921891212, 0.0564503632485867, 0.0565329156816006, 0.0566153861582279, 0.0566978305578232, 0.0567801669239998, 0.0568624585866928, 0.0569446720182896, 0.0570268481969833, 0.0571089498698711, 0.0571909584105015, 0.0572729520499706, 0.0573548637330532, 0.0574367344379425, 0.0575184933841228, 0.0576002188026905, 0.0576818808913231, 0.0577635020017624, 0.0578450076282024, 0.0579264834523201, 0.0580079108476639, 0.0580892600119114, 0.0581705197691917, 0.0582517348229885, 0.058332908898592, 0.0584140010178089, 0.0584950298070908, 0.0585759952664375, 0.058656919747591, 0.0587377697229385, 0.0588185451924801, 0.0588992387056351, 0.0589798986911774, 0.0590605027973652, 0.0591410435736179, 0.0592214688658714, 0.0593018867075443, 0.0593822337687016, 0.0594625286757946, 0.0595427192747593, 0.0596228837966919, 0.0597029589116573, 0.0597830079495907, 0.0598629526793957, 0.0599428303539753, 0.0600226931273937, 0.0601024739444256, 0.0601821839809418, 0.0602618232369423, 0.0603414177894592, 0.0604209378361702, 0.0605003908276558, 0.0605797953903675, 0.0606591254472733, 0.0607384033501148, 0.0608176440000534, 0.0608967579901218, 0.060975831001997, 0.0610548742115498, 0.0611338317394257, 0.0612127147614956, 0.0612915530800819, 0.0613703206181526, 0.0614490322768688, 0.0615276694297791, 0.0616062544286251, 0.0616847649216652, 0.0617632456123829, 0.0618415921926498, 0.0619199424982071, 0.0619982033967972, 0.0620764195919037, 0.0621545389294624, 0.06223264336586, 0.0623106509447098, 0.0623885989189148, 0.0624664649367332, 0.0625443086028099, 0.0626220628619194, 0.0626997724175453, 0.0627774372696877, 0.0628549829125404, 0.0629324987530708, 0.0630099549889565, 0.0630873441696167, 0.0631646513938904, 0.0632419213652611, 0.0633191168308258, 0.0633962601423264, 0.0634733289480209, 0.0635503381490707, 0.0636272802948952, 0.063704177737236, 0.0637809708714485, 0.0638577416539192, 0.0639344304800034, 0.0640110746026039, 0.0640876218676567, 0.0641641542315483, 0.0642420202493668, 0.0643176436424255, 0.0643931850790977, 0.0644686818122864, 0.0645440965890884, 0.0646194443106651, 0.0646947026252747, 0.0647699236869812, 0.0648450627923012, 0.0649201199412346, 0.0649951174855232, 0.0650700330734253, 0.0651448965072632, 0.0652196928858757, 0.0652944073081017, 0.0653690472245216, 0.0654436349868774, 0.0655181258916855, 0.0655925646424294, 0.0656669065356255, 0.0657412111759186, 0.0658154487609863, 0.0658895894885063, 0.0659636631608009, 0.066037692129612, 0.0661116540431976, 0.0661855041980743, 0.0662593021988869, 0.0663330405950546, 0.066406711935997, 0.0664803087711334, 0.0665538161993027, 0.0666272789239883, 0.066700667142868, 0.0667739659547806, 0.0668472200632095, 0.0669203773140907, 0.0669935047626495, 0.0670665353536606, 0.0671394988894463, 0.0672123730182648, 0.0672852098941803, 0.0673579648137093, 0.0674306452274323, 0.0675032362341881, 0.0675757750868797, 0.0676482617855072, 0.0677206590771675, 0.0677929818630219, 0.0678652450442314, 0.0679374560713768, 0.0680095553398132, 0.0680816024541855, 0.068153589963913, 0.0682255029678345, 0.0682973638176918, 0.0683691054582596, 0.068440817296505, 0.0685124471783638, 0.0685840174555779, 0.0686554983258247, 0.0687268972396851, 0.0687982738018036, 0.068869560956955, 0.0689407587051392, 0.069011889398098, 0.069082960486412, 0.0691539645195007, 0.0692248940467834, 0.069295734167099, 0.0693665370345116, 0.0694372653961182, 0.0695079118013382, 0.0695784687995911, 0.0696489810943604, 0.0697194263339043, 0.0697898119688034, 0.0698600858449936, 0.0699303224682808, 0.070000484585762, 0.0700705796480179, 0.070140577852726, 0.0702105164527893, 0.070280410349369, 0.0703502297401428, 0.0704199522733688, 0.0704896152019501, 0.0705592185258865, 0.070628747344017, 0.0706982240080833, 0.0707675740122795, 0.0708369016647339, 0.0709061473608017, 0.0709753409028053, 0.0710444077849388, 0.0711134597659111, 0.0711824372410774, 0.0712513327598572, 0.071320153772831, 0.0713888928294182, 0.0714520812034607, 0.0715195536613464, 0.0715869590640068, 0.0716543719172478, 0.0717217326164246, 0.0717890411615372, 0.0718563050031662, 0.0719235464930534, 0.0719907432794571, 0.0720579102635384, 0.0721250101923943, 0.0721921026706696, 0.0722591578960419, 0.0723261535167694, 0.0723931267857552, 0.0724600329995155, 0.0725269168615341, 0.0725937858223915, 0.0726605951786041, 0.0727273523807526, 0.0727940946817398, 0.0728607773780823, 0.0729274302721024, 0.0729940384626389, 0.073060616850853, 0.0731271728873253, 0.0731936693191528, 0.0732601135969162, 0.0733265355229378, 0.0733929201960564, 0.0734592601656914, 0.0735255554318428, 0.0735918208956718, 0.0736580640077591, 0.073724240064621, 0.0737903788685799, 0.073856495320797, 0.0739225745201111, 0.073988601565361, 0.0740545988082886, 0.0741205364465714, 0.0741864517331123, 0.0742523372173309, 0.0743181854486465, 0.0743839666247368, 0.0744497328996658, 0.0745154544711113, 0.0745811313390732, 0.0746467635035515, 0.0747123658657074, 0.0747779458761215, 0.0748434811830521, 0.0749089494347572, 0.0749743953347206, 0.0750398114323616, 0.075105182826519, 0.0751705020666122, 0.0752358064055443, 0.0753010585904121, 0.0753662884235382, 0.0754314437508583, 0.0754965841770172, 0.0755616873502731, 0.0756267532706261, 0.075691781938076, 0.0757567435503006, 0.075821690261364, 0.0758865997195244, 0.0759514570236206, 0.0760162845253944, 0.0760810747742653, 0.0761458203196526, 0.0762105360627174, 0.0762751996517181, 0.0763398334383965, 0.0764044225215912, 0.0764689967036247, 0.0765334889292717, 0.0765979737043381, 0.0766624137759209, 0.0767268165946007, 0.0767911672592163, 0.0768554881215096, 0.0769197791814804, 0.0769840180873871, 0.0770482122898102, 0.0771123915910721, 0.0771765038371086, 0.0772406011819839, 0.0773046538233757, 0.0773686468601227, 0.0774326249957085, 0.0774965733289719, 0.0775604620575905, 0.0776242986321449, 0.0776881203055382, 0.0777518898248672, 0.0778156444430351, 0.077879324555397, 0.0779429972171783, 0.0780060961842537, 0.0780681669712067, 0.0781302973628044, 0.0781925171613693, 0.078254722058773, 0.0783169940114021, 0.0783793181180954, 0.078441709280014, 0.0785041302442551, 0.0785665884613991, 0.0786290988326073, 0.0786916837096214, 0.0787542834877968, 0.0788169577717781, 0.078879676759243, 0.0789424106478691, 0.07900520414114, 0.0790680795907974, 0.0791309624910355, 0.0791938826441765, 0.0792568922042847, 0.0793199241161346, 0.07938302308321, 0.0794461444020271, 0.0795093551278114, 0.0795725658535957, 0.0796358361840248, 0.0796991586685181, 0.0797625407576561, 0.0798259451985359, 0.0798894539475441, 0.0799529254436493, 0.0800165012478828, 0.0800800994038582, 0.0801437720656395, 0.0802074819803238, 0.0802712067961693, 0.0803350210189819, 0.080398865044117, 0.0804627388715744, 0.0805266872048378, 0.0805907100439072, 0.0806547254323959, 0.0807188227772713, 0.0807829350233078, 0.0808471217751503, 0.0809113457798958, 0.0809756219387054, 0.0810399353504181, 0.0811043158173561, 0.0811687186360359, 0.0812331810593605, 0.0812976956367493, 0.0813622549176216, 0.0814268589019775, 0.0814914926886559, 0.0815562009811401, 0.0816209614276886, 0.0816857367753983, 0.0817505791783333, 0.0818155035376549, 0.0818804129958153, 0.0819454193115234, 0.0820104256272316, 0.0820755362510681, 0.082140639424324, 0.0822058394551277, 0.0822710543870926, 0.0823363363742828, 0.0824016407132149, 0.0824670344591141, 0.0825324282050133, 0.0825978741049767, 0.0826633870601654, 0.0827289521694183, 0.0827945396304131, 0.0828602015972137, 0.0829258933663368, 0.0829916298389435, 0.0830574408173561, 0.0831232666969299, 0.0831891745328903, 0.0832550823688507, 0.0833210870623589, 0.0833870992064476, 0.0834532007575035, 0.0835192948579788, 0.0835854783654213, 0.083651676774025, 0.0837179720401764, 0.0837842971086502, 0.0838506296277046, 0.0839170590043068, 0.0839835107326508, 0.0840499848127365, 0.08411655575037, 0.0841831564903259, 0.0842498019337654, 0.0843165293335915, 0.0843832418322563, 0.0844538137316704, 0.0845202431082726, 0.0845867618918419, 0.0846535935997963, 0.0847205370664597, 0.0847876593470573, 0.0848549529910088, 0.0849224478006363, 0.0849901437759399, 0.0850579515099525, 0.0851259753108025, 0.0851941853761673, 0.0852625370025635, 0.085331067442894, 0.085399754345417, 0.085468627512455, 0.0855377316474915, 0.0856069475412369, 0.085676409304142, 0.0857460275292397, 0.0858157798647881, 0.0858857780694962, 0.0859558582305908, 0.0860261097550392, 0.0860965698957443, 0.0861672535538673, 0.0862380638718605, 0.0863090977072716, 0.0863803029060364, 0.0864516571164131, 0.0865231975913048, 0.086594894528389, 0.0866668149828911, 0.0867388099431992, 0.0868111401796341, 0.0868834853172302, 0.0869560316205025, 0.0870288237929344, 0.0871017649769783, 0.0871748924255371, 0.0872481912374496, 0.0873216912150383, 0.0873953402042389, 0.0874691531062126, 0.0875431671738625, 0.0876172780990601, 0.0876917019486427, 0.0877661928534508, 0.0878409519791603, 0.0879158228635788, 0.0879908502101898, 0.0880661234259605, 0.0881414860486984, 0.0882170870900154, 0.0882928073406219, 0.0883687734603882, 0.088444858789444, 0.0885211825370789, 0.0885976254940033, 0.0886742919683456, 0.0887511000037193, 0.0888281092047691, 0.0889052897691727, 0.0889826118946075, 0.0890601426362991, 0.089137852191925, 0.0892156884074211, 0.0892937332391739, 0.0893719717860222, 0.089450366795063, 0.0895289927721024, 0.0896077454090118, 0.0896866768598557, 0.0897658243775368, 0.0898450911045074, 0.0899244919419289, 0.0900041162967682, 0.0900839194655418, 0.0901639387011528, 0.0902440845966339, 0.0903244316577911, 0.0904049426317215, 0.0904856771230698, 0.090566523373127, 0.0906476005911827, 0.0907287895679474, 0.0908101499080658, 0.0908917561173439, 0.0909735113382339, 0.0910554528236389, 0.0911374911665916, 0.0912198722362518, 0.091302253305912, 0.0913849472999573, 0.0914676859974861, 0.0915507525205612, 0.0916338935494423, 0.0917171761393547, 0.0918007120490074, 0.0918843895196915, 0.0919676497578621, 0.0920531749725342, 0.0921388640999794, 0.092224970459938, 0.092311330139637, 0.0923979207873344, 0.0924848094582558, 0.0925720408558846, 0.0926595032215118, 0.0927473530173302, 0.0928354263305664, 0.0929237976670265, 0.0930124595761299, 0.0931013971567154, 0.0931906625628471, 0.0932801887392998, 0.0933699160814285, 0.0934600532054901, 0.0935504585504532, 0.0936410501599312, 0.0937321037054062, 0.0938233584165573, 0.0939148664474487, 0.0940067693591118, 0.0940988287329674, 0.094191312789917, 0.0942840427160263, 0.0943769663572311, 0.094470240175724, 0.094563826918602, 0.0946576595306396, 0.0947518572211266, 0.0948462933301926, 0.0949410125613213, 0.095036007463932, 0.0951313376426697, 0.095226913690567, 0.0953227579593658, 0.0954189449548721, 0.0955154001712799, 0.0956121981143951, 0.0957091823220253, 0.0958065539598465, 0.0959041863679886, 0.0960020571947098, 0.0961003080010414, 0.0961987301707268, 0.0962975695729256, 0.0963965952396393, 0.0964959040284157, 0.0965956449508667, 0.0966955497860909, 0.0967957377433777, 0.096896231174469, 0.096997082233429, 0.0970981791615486, 0.0971995964646339, 0.0973012149333954, 0.0974030941724777, 0.0975053906440735, 0.0976079031825066, 0.0977107211947441, 0.0978138819336891, 0.0979172214865685, 0.0980209559202194, 0.0981249064207077, 0.0982291847467422, 0.0983337834477425, 0.0984385311603546, 0.0985437333583832, 0.0986491590738297, 0.0987548157572746, 0.0988609045743942, 0.098967157304287, 0.0990737602114677, 0.0991806238889694, 0.0992877781391144, 0.099395252764225, 0.0995030179619789, 0.0996109768748283, 0.099719300866127, 0.0998279601335526, 0.099936805665493, 0.100046008825302, 0.100155457854271, 0.100265227258205, 0.100375324487686, 0.100485630333424, 0.100596271455288, 0.100707203149796, 0.10081834346056, 0.100929863750935, 0.101041682064533, 0.10115372389555, 0.101266123354435, 0.101378716528416, 0.101491719484329, 0.101604968309402, 0.101718455553055, 0.101832218468189, 0.101947031915188, 0.102063730359077, 0.102180786430836, 0.102298192679882, 0.102415904402733, 0.102533981204033, 0.102652303874493, 0.102770991623402, 0.102890074253082, 0.103009350597858, 0.103129133582115, 0.103249095380306, 0.103369399905205, 0.103490114212036, 0.103611059486866, 0.103732444345951, 0.103854097425938, 0.103976115584373, 0.104098476469517, 0.104221098124981, 0.104344107210636, 0.104467369616032, 0.104591071605682, 0.104715019464493, 0.104839369654655, 0.104963950812817, 0.105088971555233, 0.105214267969131, 0.105339832603931, 0.105465821921825, 0.105592183768749, 0.10571875423193, 0.105845704674721, 0.105972982943058, 0.106100536882877, 0.106228478252888, 0.1063566878438, 0.106485366821289, 0.106614291667938, 0.106743529438972, 0.106873095035553, 0.107003048062325, 0.107133261859417, 0.107263892889023, 0.107394807040691, 0.1075259745121, 0.107657589018345, 0.10778945684433, 0.107921659946442, 0.108054228127003, 0.108187109231949, 0.108320377767086, 0.108453884720802, 0.108587741851807, 0.108721986413002, 0.108856461942196, 0.108991347253323, 0.109126545488834, 0.109262049198151, 0.109397917985916, 0.109534114599228, 0.109670579433441, 0.109807454049587, 0.109944693744183, 0.110082156956196, 0.110219985246658, 0.110358119010925, 0.110496580600739, 0.110635444521904, 0.110774584114552, 0.110914096236229, 0.111053943634033, 0.111194029450417, 0.111334510147572, 0.111475348472595, 0.111616417765617, 0.111758001148701, 0.111899711191654, 0.112041845917702, 0.112184263765812, 0.112327039241791, 0.112470187246799, 0.11261361092329, 0.11275739222765, 0.112901479005814, 0.113045915961266, 0.113190650939941, 0.113335758447647, 0.113481134176254, 0.113626934587955, 0.113773062825203, 0.113919407129288, 0.114066168665886, 0.11421325057745, 0.114360623061657, 0.114508382976055, 0.114656418561935, 0.114804819226265, 0.114953570067883, 0.115102551877499, 0.115256860852242, 0.115409635007381, 0.115562684834003, 0.115715958178043, 0.11586955934763, 0.116023309528828, 0.116177409887314, 0.116331748664379, 0.116486363112926, 0.116641275584698, 0.116796404123306, 0.116951815783978, 0.117107428610325, 0.117263354361057, 0.11741953343153, 0.117575980722904, 0.117732726037502, 0.117889665067196, 0.118046909570694, 0.118204355239868, 0.118362113833427, 0.11852016299963, 0.118678495287895, 0.118837021291256, 0.118995800614357, 0.119154840707779, 0.119314156472683, 0.11947375535965, 0.119633562862873, 0.119793772697449, 0.119954101741314, 0.120114766061306, 0.120275646448135, 0.120436862111092, 0.12059823423624, 0.120759941637516, 0.120921887457371, 0.121084168553352, 0.121246598660946, 0.121409356594086, 0.121572270989418, 0.121735595166683, 0.121899113059044, 0.122062921524048, 0.122226923704147, 0.122391298413277, 0.122555814683437, 0.122720703482628, 0.12288573384285, 0.123051166534424, 0.123216725885868, 0.123382620513439, 0.123548731207848, 0.123715192079544, 0.123881794512272, 0.124048851430416, 0.124215967953205, 0.124383442103863, 0.124551147222519, 0.124719120562077, 0.124887362122536, 0.125055864453316, 0.125224679708481, 0.125393733382225, 0.125562995672226, 0.125732555985451, 0.125902354717255, 0.126072436571121, 0.12624280154705, 0.126413390040398, 0.126584276556969, 0.126755341887474, 0.126926764845848, 0.127098381519318, 0.12727028131485, 0.127442553639412, 0.127614974975586, 0.127787634730339, 0.127960622310638, 0.128133818507195, 0.128307268023491, 0.12848111987114, 0.128655076026917, 0.128829345107079, 0.129003882408142, 0.129178658127785, 0.129353731870651, 0.129529029130936, 0.129704669117928, 0.129880502820015, 0.130056604743004, 0.130232959985733, 0.130409583449364, 0.130586475133896, 0.130763620138168, 0.130941078066826, 0.13111874461174, 0.131296709179878, 0.131474897265434, 0.131653353571892, 0.131835654377937, 0.13201779127121, 0.132199987769127, 0.132382228970528, 0.132564574480057, 0.132746979594231, 0.132929429411888, 0.133111968636513, 0.133294522762299, 0.133477210998535, 0.133659943938255, 0.13384273648262, 0.13402558863163, 0.134208515286446, 0.134391471743584, 0.134574487805367, 0.134757608175278, 0.134940788149834, 0.135123983025551, 0.13530732691288, 0.13549068570137, 0.135674133896828, 0.135857626795769, 0.136041179299355, 0.136224791407585, 0.136408507823944, 0.136592268943787, 0.136776089668274, 0.136959955096245, 0.137143924832344, 0.137327939271927, 0.137512058019638, 0.137696176767349, 0.137880384922028, 0.138064667582512, 0.138249024748802, 0.138433411717415, 0.138617902994156, 0.138802424073219, 0.138987049460411, 0.139171719551086, 0.139356434345245, 0.139541238546371, 0.139726102352142, 0.13991105556488, 0.140096038579941, 0.140281081199646, 0.140466243028641, 0.140651434659958, 0.140836670994759, 0.141021996736526, 0.141207382082939, 0.141392827033997, 0.14157834649086, 0.141763970255852, 0.141949594020844, 0.142135292291641, 0.142321065068245, 0.142506927251816, 0.142692819237709, 0.142878785729408, 0.143064811825752, 0.143251016736031, 0.143437087535858, 0.143623396754265, 0.143809661269188, 0.143996059894562, 0.144182428717613, 0.144368976354599, 0.144555494189262, 0.144742146134377, 0.144928798079491, 0.145115599036217, 0.145302385091782, 0.145489320158958, 0.145676210522652, 0.145863249897957, 0.146050333976746, 0.146237462759018, 0.14642471075058, 0.146611958742142, 0.146799325942993, 0.146986693143845, 0.147174179553986, 0.14736171066761, 0.147549331188202, 0.147736981511116, 0.147924706339836, 0.148112535476685, 0.148300394415855, 0.148488327860832, 0.148676291108131, 0.148864358663559, 0.149052500724792, 0.149240672588348, 0.149428933858871, 0.149617224931717, 0.149805665016174, 0.149994060397148, 0.150182619690895, 0.150372073054314, 0.150560930371284, 0.15074947476387, 0.150937855243683, 0.151126071810722, 0.151314005255699, 0.151501730084419, 0.151689320802689, 0.151876643300056, 0.152063742280006, 0.152250677347183, 0.152437433600426, 0.152623921632767, 0.152810260653496, 0.152996346354485, 0.153182238340378, 0.153367936611176, 0.153553411364555, 0.153738707304001, 0.153923720121384, 0.154108583927155, 0.15429325401783, 0.154477700591087, 0.154661908745766, 0.154845997691154, 0.155029758810997, 0.15521340072155, 0.155396789312363, 0.155580028891563, 0.15576297044754, 0.155945807695389, 0.156128361821175, 0.156310752034187, 0.156492918729782, 0.156674847006798, 0.156856626272202, 0.157038167119026, 0.157219499349594, 0.157400652766228, 0.15758153796196, 0.157762289047241, 0.157942816615105, 0.158123105764389, 0.1583032310009, 0.15848308801651, 0.158662810921669, 0.158842265605927, 0.15902154147625, 0.159200593829155, 0.159379422664642, 0.159558102488518, 0.159736573696136, 0.159914746880531, 0.160092800855637, 0.160270601511002, 0.160448223352432, 0.160625606775284, 0.160802856087685, 0.1609797924757, 0.161156609654427, 0.161333203315735, 0.161509573459625, 0.16168574988842, 0.161861717700958, 0.162037432193756, 0.162212997674942, 0.162388369441032, 0.16256345808506, 0.162738367915154, 0.16291306912899, 0.163087636232376, 0.163261935114861, 0.163436010479927, 0.163609907031059, 0.163783594965935, 0.163957059383392, 0.164130344986916, 0.164303407073021, 0.164476245641708, 0.164648860692978, 0.164821341633797, 0.164993569254875, 0.165165603160858, 0.165337413549423, 0.165509045124054, 0.165680408477783, 0.165851637721062, 0.166022598743439, 0.166193410754204, 0.16636398434639, 0.16653436422348, 0.16670449078083, 0.166874468326569, 0.167044222354889, 0.167213767766953, 0.167383104562759, 0.167552247643471, 0.167721167206764, 0.16788986325264, 0.168058395385742, 0.168218791484833, 0.168383210897446, 0.168547242879868, 0.168710857629776, 0.16887404024601, 0.16903680562973, 0.169199168682098, 0.16936106979847, 0.16952258348465, 0.169683709740639, 0.169844374060631, 0.170004591345787, 0.170164480805397, 0.170323878526688, 0.17048291862011, 0.17064143717289, 0.170799657702446, 0.17095735669136, 0.171114727854729, 0.171271696686745, 0.171428143978119, 0.171584233641624, 0.171739876270294, 0.171895131468773, 0.172049909830093, 0.172204345464706, 0.172358259558678, 0.172511830925941, 0.172664970159531, 0.172817751765251, 0.17297001183033, 0.173121944069862, 0.173273399472237, 0.17342446744442, 0.173575073480606, 0.173725321888924, 0.173875048756599, 0.174024447798729, 0.174173429608345, 0.174321949481964, 0.174470111727715, 0.174617722630501, 0.174765095114708, 0.17491190135479, 0.175058379769325, 0.175204426050186, 0.175350025296211, 0.175495162606239, 0.175640001893044, 0.175784289836884, 0.175928235054016, 0.176071718335152, 0.17621485888958, 0.17635752260685, 0.176499798893929, 0.176641643047333, 0.176783084869385, 0.176924094557762, 0.177064672112465, 0.177204862236977, 0.177344590425491, 0.177483886480331, 0.177622810006142, 0.177761316299438, 0.177899345755577, 0.178037032485008, 0.17817422747612, 0.178311094641685, 0.178447440266609, 0.178583487868309, 0.178718984127045, 0.178854197263718, 0.178988859057426, 0.179123193025589, 0.179257035255432, 0.179390519857407, 0.179523631930351, 0.179656192660332, 0.179788485169411, 0.179920211434364, 0.180051624774933, 0.180182546377182, 0.180313125252724, 0.180443182587624, 0.180572956800461, 0.180702179670334, 0.180831059813499, 0.180959492921829, 0.18108756840229, 0.181215107440948, 0.181342303752899, 0.181469023227692, 0.181595414876938, 0.181721344590187, 0.181846901774406, 0.181971922516823, 0.182096675038338, 0.182220950722694, 0.182344779372215, 0.182468205690384, 0.182586520910263, 0.182704165577888, 0.182821333408356, 0.182938054203987, 0.183054268360138, 0.183170109987259, 0.183285370469093, 0.183400273323059, 0.183514609932899, 0.183628618717194, 0.183742046356201, 0.183855056762695, 0.183967605233192, 0.184079706668854, 0.184191316366196, 0.184302434325218, 0.184413090348244, 0.184523358941078, 0.184633105993271, 0.184742406010628, 0.184851199388504, 0.184959605336189, 0.185067519545555, 0.18517492711544, 0.185281947255135, 0.185388416051865, 0.185494512319565, 0.185600087046623, 0.185705199837685, 0.185809805989265, 0.185914039611816, 0.186017781496048, 0.186121061444283, 0.186223819851875, 0.186326235532761, 0.186428040266037, 0.186529487371445, 0.186630427837372, 0.186730951070786, 0.186830952763557, 0.186930507421494, 0.187029659748077, 0.187128245830536, 0.187226504087448, 0.18732413649559, 0.187421396374702, 0.187518164515495, 0.187614470720291, 0.18771031498909, 0.187805742025375, 0.187900587916374, 0.187995120882988, 0.188089087605476, 0.188182637095451, 0.188275650143623, 0.188368335366249, 0.188460469245911, 0.188552126288414, 0.188643336296082, 0.188734114170074, 0.188824445009232, 0.188914209604263, 0.189003616571426, 0.189092516899109, 0.189180970191956, 0.18926890194416, 0.189356431365013, 0.189443454146385, 0.189530059695244, 0.189616128802299, 0.189701855182648, 0.189786970615387, 0.189871788024902, 0.189955949783325, 0.190039813518524, 0.19012314081192, 0.19020602107048, 0.190288409590721, 0.190370380878448, 0.190451890230179, 0.190532878041267, 0.190613478422165, 0.190693512558937, 0.190773159265518, 0.19085231423378, 0.190931037068367, 0.19100920855999, 0.191087052226067, 0.19116435945034, 0.191241219639778, 0.191317558288574, 0.19139352440834, 0.191468968987465, 0.191543981432915, 0.191618472337723, 0.191692560911179, 0.191766127943993, 0.191839292645454, 0.19191201031208, 0.191984206438065, 0.192057549953461, 0.192124575376511, 0.192191287875175, 0.192257687449455, 0.19232377409935, 0.192389518022537, 0.192454934120178, 0.192520037293434, 0.192584842443466, 0.192649319767952, 0.192713439464569, 0.192777261137962, 0.192840740084648, 0.192903935909271, 0.192966774106026, 0.193029284477234, 0.193091496825218, 0.193153381347656, 0.193214923143387, 0.193276152014732, 0.193337067961693, 0.193397670984268, 0.193457916378975, 0.193517863750458, 0.193577468395233, 0.193636789917946, 0.19369575381279, 0.193754404783249, 0.193812757730484, 0.19387075304985, 0.193928405642509, 0.193985775113106, 0.194042831659317, 0.19409953057766, 0.194155901670456, 0.194212004542351, 0.194267734885216, 0.194323137402534, 0.194378241896629, 0.1944330483675, 0.19448746740818, 0.194541588425636, 0.194595411419868, 0.194648906588554, 0.194702059030533, 0.194754913449287, 0.194807425141335, 0.194859638810158, 0.194911479949951, 0.194963037967682, 0.195014283061028, 0.195065170526505, 0.195115745067596, 0.195166006684303, 0.195215955376625, 0.195265576243401, 0.195314839482307, 0.195363834500313, 0.195412427186966, 0.19546078145504, 0.195508763194084, 0.195556417107582, 0.195603758096695, 0.195650815963745, 0.195697531104088, 0.195743888616562, 0.195789963006973, 0.195835709571838, 0.195881128311157, 0.195926204323769, 0.195970982313156, 0.196015447378159, 0.196059554815292, 0.19610333442688, 0.196146830916405, 0.196189984679222, 0.196232840418816, 0.196275323629379, 0.196317508816719, 0.196359366178513, 0.19640089571476, 0.196442127227783, 0.196483060717583, 0.196523606777191, 0.196563839912415, 0.196603804826736, 0.196643397212029, 0.196682631969452, 0.196721613407135, 0.196760252118111, 0.196798548102379, 0.196836531162262, 0.196874216198921, 0.196911573410034, 0.196948572993279, 0.196985274553299, 0.197021663188934, 0.197057723999023, 0.197093442082405, 0.197128847241402, 0.197161361575127, 0.197194173932076, 0.197226956486702, 0.197259709239006, 0.197292372584343, 0.19732503592968, 0.19735760986805, 0.197390139102936, 0.197422623634338, 0.197455078363419, 0.197487458586693, 0.197519764304161, 0.197552040219307, 0.19758428633213, 0.197616443037987, 0.197648584842682, 0.197680667042732, 0.197712704539299, 0.197744682431221, 0.197776600718498, 0.197808474302292, 0.197840303182602, 0.197872072458267, 0.19790381193161, 0.197935491800308, 0.1979670971632, 0.197998657822609, 0.198030173778534, 0.198061659932137, 0.198093071579933, 0.198124423623085, 0.198155775666237, 0.198187053203583, 0.198218256235123, 0.198249414563179, 0.198280543088913, 0.198311597108841, 0.198342621326447, 0.198373585939407, 0.198404505848885, 0.198435351252556, 0.198466181755066, 0.19849693775177, 0.198527634143829, 0.198558315634727, 0.19858892261982, 0.198619484901428, 0.198649987578392, 0.198680460453033, 0.19871087372303, 0.198741227388382, 0.198771506547928, 0.198801785707474, 0.198832005262375, 0.198862135410309, 0.19889223575592, 0.198922321200371, 0.198952332139015, 0.198982283473015, 0.199012190103531, 0.199042037129402, 0.199071824550629, 0.19910155236721, 0.199131265282631, 0.199160933494568, 0.199190527200699, 0.199220061302185, 0.199249565601349, 0.199279025197029, 0.199308410286903, 0.199337750673294, 0.199367061257362, 0.199396297335625, 0.199425503611565, 0.19945465028286, 0.19948373734951, 0.199512779712677, 0.19954177737236, 0.199570700526237, 0.199599593877792, 0.199628442525864, 0.19965723156929, 0.199685961008072, 0.199714660644531, 0.199743300676346, 0.199771881103516, 0.199800416827202, 0.199828922748566, 0.199857369065285, 0.199885740876198, 0.199914067983627, 0.199942365288734, 0.199970602989197, 0.199998766183853, 0.200026899576187, 0.200054973363876, 0.200083017349243, 0.200110986828804, 0.200138911604881, 0.200166806578636, 0.200194284319878, 0.200223669409752, 0.200253322720528, 0.200283244252205, 0.200313374400139, 0.200343698263168, 0.20037430524826, 0.200405150651932, 0.200436249375343, 0.200467571616173, 0.20049911737442, 0.200530901551247, 0.200562953948975, 0.20059522986412, 0.200627714395523, 0.20066049695015, 0.200693503022194, 0.200726717710495, 0.200760170817375, 0.200793862342834, 0.200827836990356, 0.200862020254135, 0.200896471738815, 0.200931087136269, 0.200966015458107, 0.201001137495041, 0.201036527752876, 0.20107214152813, 0.201107978820801, 0.201144099235535, 0.201180458068848, 0.20121705532074, 0.201253831386566, 0.201290875673294, 0.201328188180923, 0.20136570930481, 0.201403453946114, 0.201441466808319, 0.201479718089104, 0.20151823759079, 0.20155693590641, 0.201595887541771, 0.20163506269455, 0.201674535870552, 0.201714217662811, 0.201754108071327, 0.201794281601906, 0.201834663748741, 0.201875314116478, 0.20191615819931, 0.201957285404205, 0.201998651027679, 0.202040210366249, 0.20208203792572, 0.202124118804932, 0.202166423201561, 0.202208980917931, 0.202251717448235, 0.202294752001762, 0.202338010072708, 0.202381536364555, 0.202425271272659, 0.202469244599342, 0.202513456344604, 0.202557936310768, 0.202602624893188, 0.202647536993027, 0.202692702412605, 0.202738121151924, 0.202783793210983, 0.202829673886299, 0.202875763177872, 0.202922135591507, 0.202968761324883, 0.203015595674515, 0.203062668442726, 0.203109994530678, 0.20315757393837, 0.203205347061157, 0.203253418207169, 0.203301668167114, 0.203350186347961, 0.203398942947388, 0.203447937965393, 0.203497156500816, 0.203546613454819, 0.203596353530884, 0.203646287322044, 0.203696489334106, 0.203746870160103, 0.203797549009323, 0.203848451375961, 0.20389960706234, 0.203950971364975, 0.20400258898735, 0.204054445028305, 0.204106554389, 0.204158902168274, 0.204211473464966, 0.204264298081398, 0.20432011783123, 0.204377710819244, 0.204435750842094, 0.204494208097458, 0.204553097486496, 0.204612359404564, 0.20467209815979, 0.204732194542885, 0.204792752861977, 0.204853683710098, 0.204915091395378, 0.204976871609688, 0.205039113759995, 0.205101758241653, 0.205164775252342, 0.205228254199028, 0.205292150378227, 0.205356508493423, 0.20542123913765, 0.205486342310905, 0.205551877617836, 0.205617904663086, 0.205684319138527, 0.205751106142998, 0.205818355083466, 0.205885991454124, 0.20595408976078, 0.206022620201111, 0.20609150826931, 0.206160813570023, 0.206230565905571, 0.206300765275955, 0.206371366977692, 0.206442311406136, 0.206513747572899, 0.206585600972176, 0.206657886505127, 0.206730544567108, 0.206803634762764, 0.206877216696739, 0.206951096653938, 0.207025453448296, 0.207100257277489, 0.207175448536873, 0.207251042127609, 0.207327052950859, 0.207403525710106, 0.207480415701866, 0.207557648420334, 0.20763535797596, 0.207713514566422, 0.207792043685913, 0.207871004939079, 0.207950368523598, 0.208030134439468, 0.20811040699482, 0.208191007375717, 0.208272069692612, 0.208353519439697, 0.20843543112278, 0.208517715334892, 0.208600446581841, 0.208683595061302, 0.208767145872116, 0.208851143717766, 0.208935514092445, 0.209020346403122, 0.209105581045151, 0.209191247820854, 0.209277302026749, 0.20936381816864, 0.209450721740723, 0.209538042545319, 0.209625780582428, 0.209713980555534, 0.209802567958832, 0.209891572594643, 0.209980979561806, 0.210070818662643, 0.210161060094833, 0.21025176346302, 0.210342824459076, 0.21043436229229, 0.210526287555695, 0.210618630051613, 0.210711404681206, 0.210804611444473, 0.210898220539093, 0.210992231965065, 0.211086690425873, 0.211181566119194, 0.211276829242706, 0.211372524499893, 0.211468636989594, 0.211565181612968, 0.211662128567696, 0.211759507656097, 0.211857303977013, 0.211955517530441, 0.212054163217545, 0.212155520915985, 0.212260231375694, 0.212365329265594, 0.212470844388008, 0.212576761841774, 0.212683126330376, 0.212789863348007, 0.212897032499313, 0.213004544377327, 0.213112562894821, 0.213220983743668, 0.213329777121544, 0.213438972830772, 0.213548615574837, 0.213658645749092, 0.2137690782547, 0.213879927992821, 0.213991180062294, 0.214102864265442, 0.214214935898781, 0.214327454566956, 0.214440360665321, 0.214553698897362, 0.214667409658432, 0.214781552553177, 0.214896112680435, 0.215011104941368, 0.215126469731331, 0.215242266654968, 0.215358436107635, 0.215475022792816, 0.215592071413994, 0.215709492564201, 0.215827316045761, 0.215945526957512, 0.216064214706421, 0.216183304786682, 0.216302767395973, 0.216422647237778, 0.216542974114418, 0.216663703322411, 0.216784760355949, 0.216906294226646, 0.217028275132179, 0.217150628566742, 0.217273369431496, 0.217396587133408, 0.217520177364349, 0.217644155025482, 0.21776856482029, 0.217893362045288, 0.218018621206284, 0.218144237995148, 0.218270286917686, 0.218396782875061, 0.218523651361465, 0.218650922179222, 0.218778640031815, 0.218906715512276, 0.219035238027573, 0.219164162874222, 0.219293519854546, 0.219423234462738, 0.219553396105766, 0.219683989882469, 0.219814956188202, 0.219946324825287, 0.220078110694885, 0.220210343599319, 0.220342934131622, 0.220476001501083, 0.220609441399574, 0.220743328332901, 0.220877587795258, 0.221012234687805, 0.221147313714027, 0.221282839775085, 0.221418723464012, 0.221555054187775, 0.221691802144051, 0.22182896733284, 0.221966490149498, 0.222104445099831, 0.222242787480354, 0.222381591796875, 0.222520813345909, 0.222660392522812, 0.222800374031067, 0.222940847277641, 0.223081678152084, 0.223222941160202, 0.223364546895027, 0.22350662946701, 0.223649114370346, 0.223791986703873, 0.223935291171074, 0.224079012870789, 0.224223136901855, 0.224367663264275, 0.224512606859207, 0.224658191204071, 0.224808529019356, 0.224959075450897, 0.225109830498695, 0.22526079416275, 0.225411966443062, 0.225563302636147, 0.22571487724781, 0.225866660475731, 0.226018622517586, 0.226170808076859, 0.226323142647743, 0.226475730538368, 0.226628512144089, 0.226781502366066, 0.226934671401978, 0.227088049054146, 0.227241650223732, 0.227395445108414, 0.227549433708191, 0.227703630924225, 0.227857992053032, 0.228012606501579, 0.228167414665222, 0.228322416543961, 0.228477627038956, 0.228633031249046, 0.228788644075394, 0.228944435715675, 0.229100450873375, 0.229256674647331, 0.229413092136383, 0.22956970334053, 0.229726538062096, 0.229883581399918, 0.230040803551674, 0.230198249220848, 0.230355873703957, 0.230513721704483, 0.230671748518944, 0.230829983949661, 0.230988427996635, 0.231147050857544, 0.231305912137032, 0.231464952230453, 0.231624200940132, 0.231783658266068, 0.231943294405937, 0.232103183865547, 0.23226323723793, 0.232423514127731, 0.232583969831467, 0.232744634151459, 0.232905507087708, 0.233066588640213, 0.233227849006653, 0.233389332890511, 0.233551010489464, 0.233712881803513, 0.233874946832657, 0.234037265181541, 0.234199732542038, 0.234362438321114, 0.234525337815285, 0.234688445925713, 0.234851747751236, 0.235015213489532, 0.23517894744873, 0.23534283041954, 0.235506936907768, 0.235671252012253, 0.235835745930672, 0.23600047826767, 0.236165389418602, 0.236330479383469, 0.236495822668076, 0.236661344766617, 0.236827060580254, 0.236992985010147, 0.23715914785862, 0.237325459718704, 0.237491980195045, 0.237658709287643, 0.237825661897659, 0.237992793321609, 0.238160148262978, 0.238327696919441, 0.238495439291, 0.238663390278816, 0.238831534981728, 0.238999918103218, 0.23916845023632, 0.239337220788002, 0.23950619995594, 0.239675343036652, 0.239844709634781, 0.240014284849167, 0.240184038877487, 0.240354016423225, 0.240524217486382, 0.240695983171463, 0.24086706340313, 0.241037994623184, 0.24120882153511, 0.241379529237747, 0.241550132632256, 0.241720601916313, 0.241890951991081, 0.242061197757721, 0.24223130941391, 0.242401331663132, 0.242571204900742, 0.242740944027901, 0.242910623550415, 0.243080139160156, 0.24324956536293, 0.243418857455254, 0.243588030338287, 0.243757084012032, 0.243926033377647, 0.244094833731651, 0.244263559579849, 0.244432136416435, 0.244600608944893, 0.244768962264061, 0.244937166571617, 0.245105296373367, 0.245273306965828, 0.245441183447838, 0.245608910918236, 0.245776578783989, 0.245944082736969, 0.246111482381821, 0.246278777718544, 0.246445968747139, 0.246612995862961, 0.246779948472977, 0.246946752071381, 0.247113436460495, 0.247280031442642, 0.2474465072155, 0.247612819075584, 0.247779041528702, 0.247945159673691, 0.248111173510551, 0.248277023434639, 0.248442783951759, 0.248608410358429, 0.248773947358131, 0.248939320445061, 0.249104589223862, 0.249269753694534, 0.249434813857079, 0.249599739909172, 0.249764546751976, 0.249929219484329, 0.250093787908554, 0.250258266925812, 0.250422596931458, 0.250586807727814, 0.250750929117203, 0.25091490149498, 0.25107878446579, 0.251242488622665, 0.251406133174896, 0.251569658517838, 0.251733064651489, 0.251896321773529, 0.252059489488602, 0.252222537994385, 0.252385437488556, 0.25254824757576, 0.252710938453674, 0.252873480319977, 0.253035932779312, 0.253198266029358, 0.253360480070114, 0.253522545099258, 0.253684520721436, 0.253846406936646, 0.254008144140244, 0.254169762134552, 0.254331260919571, 0.2544926404953, 0.25465390086174, 0.254815071821213, 0.254976093769073, 0.255136996507645, 0.255297780036926, 0.255458474159241, 0.255619049072266, 0.255779504776001, 0.255939811468124, 0.256099998950958, 0.256260097026825, 0.256420075893402, 0.25657993555069, 0.256739646196365, 0.256899267435074, 0.25705873966217, 0.257217019796371, 0.257371991872787, 0.257526606321335, 0.257680863142014, 0.257834732532501, 0.25798824429512, 0.258141398429871, 0.258294105529785, 0.258446484804153, 0.258598506450653, 0.258750110864639, 0.258901387453079, 0.259052246809006, 0.259202778339386, 0.259352892637253, 0.259502619504929, 0.259652018547058, 0.259801059961319, 0.259949684143066, 0.260097920894623, 0.260245829820633, 0.26039332151413, 0.260540455579758, 0.260687232017517, 0.260833621025085, 0.260979622602463, 0.261125266551971, 0.261270523071289, 0.261415421962738, 0.261559933423996, 0.261704087257385, 0.261847823858261, 0.261991262435913, 0.262134253978729, 0.262276917695999, 0.262419193983078, 0.262561082839966, 0.262702584266663, 0.262843728065491, 0.26298451423645, 0.263124912977219, 0.263264894485474, 0.263404548168182, 0.263543844223022, 0.263682752847672, 0.26382127404213, 0.263959437608719, 0.264097213745117, 0.264234632253647, 0.264371633529663, 0.264508306980133, 0.264644593000412, 0.2647804915905, 0.264916002750397, 0.265051156282425, 0.265185952186584, 0.265320360660553, 0.265454411506653, 0.265588074922562, 0.265721321105957, 0.265854269266129, 0.265986800193787, 0.266118943691254, 0.266250759363174, 0.266382157802582, 0.266513228416443, 0.266643851995468, 0.266774147748947, 0.266904056072235, 0.267033606767654, 0.267162799835205, 0.267291575670242, 0.267419993877411, 0.267548054456711, 0.26767572760582, 0.26780304312706, 0.267929941415787, 0.268056511878967, 0.268182694911957, 0.268308460712433, 0.26843386888504, 0.268558949232101, 0.268683612346649, 0.268807917833328, 0.268931865692139, 0.269055426120758, 0.269178569316864, 0.269301384687424, 0.269423812627792, 0.26954585313797, 0.269667536020279, 0.269788861274719, 0.269909799098969, 0.270030349493027, 0.270150542259216, 0.270270347595215, 0.270389795303345, 0.270508855581284, 0.270627528429031, 0.270745843648911, 0.270862847566605, 0.270976781845093, 0.2710902094841, 0.271203130483627, 0.271315604448318, 0.271427571773529, 0.271539092063904, 0.271650075912476, 0.271760612726212, 0.271870672702789, 0.271980285644531, 0.27208936214447, 0.272197991609573, 0.272306203842163, 0.272413820028305, 0.272520989179611, 0.272627741098404, 0.272733956575394, 0.272839695215225, 0.272944957017899, 0.273049771785736, 0.273154079914093, 0.273257941007614, 0.27336123585701, 0.273464143276215, 0.273566544055939, 0.273668438196182, 0.27376988530159, 0.273870855569839, 0.273971319198608, 0.274071335792542, 0.274170845746994, 0.274269878864288, 0.274368464946747, 0.274466514587402, 0.274564117193222, 0.274661242961884, 0.274757891893387, 0.274854063987732, 0.274949729442596, 0.275044947862625, 0.275139689445496, 0.275233924388885, 0.275327682495117, 0.275420993566513, 0.275513768196106, 0.275606125593185, 0.275697976350784, 0.275789350271225, 0.275880217552185, 0.275970637798309, 0.276060611009598, 0.276150017976761, 0.276239037513733, 0.276327520608902, 0.27641549706459, 0.276503056287766, 0.27659010887146, 0.276676714420319, 0.276762783527374, 0.276848435401917, 0.276933550834656, 0.277018189430237, 0.277102380990982, 0.277186095714569, 0.277269303798676, 0.277352064847946, 0.277434319257736, 0.27751612663269, 0.277597427368164, 0.277678221464157, 0.277758598327637, 0.277838468551636, 0.277917861938477, 0.277996778488159, 0.278075188398361, 0.278153151273727, 0.278230637311935, 0.278307616710663, 0.278384119272232, 0.278460174798965, 0.278535723686218, 0.27861076593399, 0.278685390949249, 0.278759509325027, 0.278833121061325, 0.278906285762787, 0.27897897362709, 0.279051184654236, 0.279122889041901, 0.27919414639473, 0.279264897108078, 0.279335200786591, 0.279404997825623, 0.279474288225174, 0.279543161392212, 0.279611527919769, 0.279679387807846, 0.279746800661087, 0.27981373667717, 0.27988076210022, 0.279946208000183, 0.280011117458344, 0.280075550079346, 0.280139476060867, 0.280202895402908, 0.280265837907791, 0.280328243970871, 0.28039014339447, 0.280451536178589, 0.280512481927872, 0.280572891235352, 0.280632793903351, 0.280692160129547, 0.280751079320908, 0.280809491872787, 0.280867338180542, 0.280924737453461, 0.280981600284576, 0.281038016080856, 0.281093895435333, 0.281149297952652, 0.281204134225845, 0.281258523464203, 0.28131240606308, 0.281365782022476, 0.28141862154007, 0.281470984220505, 0.281522840261459, 0.281574189662933, 0.281625062227249, 0.281675398349762, 0.281725227832794, 0.281774610280991, 0.281823426485062, 0.281871736049652, 0.281919598579407, 0.281966924667358, 0.282013744115829, 0.282060086727142, 0.282105922698975, 0.282151252031326, 0.282196074724197, 0.282240360975266, 0.282284140586853, 0.282327473163605, 0.282370269298553, 0.282412588596344, 0.282454401254654, 0.282495647668839, 0.28253647685051, 0.282576739788055, 0.282616585493088, 0.282655864953995, 0.282694637775421, 0.282732903957367, 0.282770663499832, 0.282807946205139, 0.282844722270966, 0.282880991697311, 0.282916754484177, 0.282952010631561, 0.282986760139465, 0.283021032810211, 0.283054798841476, 0.283088028430939, 0.283120810985565, 0.283153027296066, 0.283184796571732, 0.283215999603271, 0.283246755599976, 0.283277004957199, 0.28330671787262, 0.28333592414856, 0.283364653587341, 0.283392876386642, 0.283420622348785, 0.283447802066803, 0.283474564552307, 0.283500760793686, 0.283526450395584, 0.283551663160324, 0.283576369285583, 0.28360053896904, 0.283624261617661, 0.283647447824478, 0.283670127391815, 0.283692330121994, 0.283714026212692, 0.283735185861588, 0.283755868673325, 0.283776044845581, 0.283795714378357, 0.283814907073975, 0.283833563327789, 0.283851712942123, 0.283869385719299, 0.283886551856995, 0.283903211355209, 0.283919364213943, 0.283930718898773, 0.28393942117691, 0.283947736024857, 0.283955663442612, 0.283963203430176, 0.283970385789871, 0.283977150917053, 0.283983528614044, 0.283989548683167, 0.283995181322098, 0.284000396728516, 0.284005254507065, 0.284009724855423, 0.284013777971268, 0.284017503261566, 0.284020811319351, 0.284023731946945, 0.284026265144348, 0.284028440713882, 0.284030169248581, 0.284031569957733, 0.284032553434372, 0.284033209085464, 0.284033417701721, 0.284033268690109, 0.284032732248306, 0.284031808376312, 0.284030497074127, 0.284028828144073, 0.284026741981506, 0.284024268388748, 0.284021437168121, 0.284018188714981, 0.28401455283165, 0.284010589122772, 0.284006178379059, 0.284001410007477, 0.283996224403381, 0.28399071097374, 0.283984780311584, 0.283978462219238, 0.283971786499023, 0.283964693546295, 0.283957213163376, 0.283949345350266, 0.283941119909286, 0.283932507038116, 0.283923476934433, 0.283914119005203, 0.28390434384346, 0.283894151449203, 0.283883601427078, 0.283872693777084, 0.283861368894577, 0.283849656581879, 0.283837586641312, 0.283825099468231, 0.283812254667282, 0.283799022436142, 0.283785372972488, 0.283771365880966, 0.283756971359253, 0.283742189407349, 0.283727020025253, 0.283711463212967, 0.283695548772812, 0.283679217100143, 0.283662497997284, 0.283645421266556, 0.283627927303314, 0.283610075712204, 0.283591836690903, 0.28357321023941, 0.283554196357727, 0.283534795045853, 0.283515006303787, 0.283494859933853, 0.283474266529083, 0.283453345298767, 0.283432006835938, 0.283410280942917, 0.283388197422028, 0.28336575627327, 0.283342868089676, 0.283319622278214, 0.283295959234238, 0.283271968364716, 0.28324756026268, 0.283222734928131, 0.283197581768036, 0.28317204117775, 0.28314608335495, 0.283119738101959, 0.283093005418777, 0.283065944910049, 0.283038467168808, 0.283010572195053, 0.28298231959343, 0.282953679561615, 0.282924652099609, 0.282892942428589, 0.28285875916481, 0.282824546098709, 0.282790303230286, 0.282756000757217, 0.282721638679504, 0.282687276601791, 0.282652854919434, 0.282618373632431, 0.282583892345428, 0.282549321651459, 0.282514721155167, 0.282480120658875, 0.282445430755615, 0.282410740852356, 0.282375991344452, 0.282341182231903, 0.282306343317032, 0.282271474599838, 0.282236576080322, 0.282201588153839, 0.282166600227356, 0.282131552696228, 0.282096475362778, 0.282061368227005, 0.282026201486588, 0.281990975141525, 0.281955718994141, 0.281920462846756, 0.281885147094727, 0.28184974193573, 0.281814336776733, 0.281778872013092, 0.281743407249451, 0.281707853078842, 0.281672269105911, 0.281636655330658, 0.281601011753082, 0.281565308570862, 0.281529575586319, 0.281493782997131, 0.281457960605621, 0.281422078609467, 0.281386196613312, 0.281350255012512, 0.281314253807068, 0.281278222799301, 0.281242161989212, 0.281206041574478, 0.281169891357422, 0.281133681535721, 0.281097441911697, 0.281061202287674, 0.281024873256683, 0.28098851442337, 0.280952095985413, 0.280915677547455, 0.280879199504852, 0.280842661857605, 0.280806094408035, 0.280769497156143, 0.280732870101929, 0.280696153640747, 0.280659437179565, 0.280622661113739, 0.280585885047913, 0.280548989772797, 0.280512124300003, 0.280475169420242, 0.280438214540482, 0.280401170253754, 0.280364125967026, 0.280327022075653, 0.280289888381958, 0.280252695083618, 0.280215501785278, 0.280178219079971, 0.280140906572342, 0.280103534460068, 0.280066192150116, 0.280028760433197, 0.279991269111633, 0.27995377779007, 0.279916226863861, 0.279878616333008, 0.279840975999832, 0.279803305864334, 0.279765605926514, 0.279727846384048, 0.279690027236938, 0.279652208089828, 0.279614299535751, 0.279576390981674, 0.279538422822952, 0.279500424861908, 0.279462397098541, 0.279424279928207, 0.279386162757874, 0.279347985982895, 0.279309779405594, 0.279276043176651, 0.279247045516968, 0.279218286275864, 0.279189705848694, 0.279161363840103, 0.279133200645447, 0.27910527586937, 0.279077559709549, 0.279050081968307, 0.279022812843323, 0.278995752334595, 0.278968870639801, 0.278942286968231, 0.278915882110596, 0.278889685869217, 0.278863698244095, 0.278837949037552, 0.278812408447266, 0.278787076473236, 0.278761953115463, 0.27873706817627, 0.278712391853333, 0.278687953948975, 0.278663694858551, 0.278639674186707, 0.278615862131119, 0.27859228849411, 0.278568893671036, 0.278545737266541, 0.278522789478302, 0.278500080108643, 0.278477549552917, 0.278455257415771, 0.278433173894882, 0.278411328792572, 0.278389692306519, 0.278368264436722, 0.278347045183182, 0.278326034545898, 0.278305262327194, 0.278284698724747, 0.278264373540878, 0.278244227170944, 0.278224319219589, 0.278204590082169, 0.278185129165649, 0.278165876865387, 0.278146833181381, 0.278128027915955, 0.278109401464462, 0.278091013431549, 0.27807280421257, 0.27805483341217, 0.278037130832672, 0.278019547462463, 0.278002262115479, 0.27798518538475, 0.277968287467957, 0.277951598167419, 0.277935177087784, 0.277918934822083, 0.27790293097496, 0.277887135744095, 0.277871549129486, 0.277856200933456, 0.277841031551361, 0.277826100587845, 0.277811408042908, 0.277796894311905, 0.277782589197159, 0.277768552303314, 0.277754694223404, 0.27774104475975, 0.277727633714676, 0.277714431285858, 0.27770146727562, 0.277688682079315, 0.277676165103912, 0.277663797140121, 0.27765166759491, 0.277639776468277, 0.277628123760223, 0.277616649866104, 0.277605414390564, 0.277594387531281, 0.277583569288254, 0.277572959661484, 0.27756255865097, 0.277552396059036, 0.277542442083359, 0.27753272652626, 0.277523189783096, 0.277513891458511, 0.277504831552505, 0.277495920658112, 0.277487277984619, 0.277478843927383, 0.277470618486404, 0.277462631464005, 0.277454853057861, 0.277448683977127, 0.277444064617157, 0.277439743280411, 0.277435600757599, 0.277431726455688, 0.277428090572357, 0.277424663305283, 0.277421534061432, 0.277418583631516, 0.277415871620178, 0.277413457632065, 0.277411252260208, 0.277409255504608, 0.27740752696991, 0.27740603685379, 0.277404814958572, 0.277403801679611, 0.277402997016907, 0.277402490377426, 0.27740216255188, 0.277402132749557, 0.277402311563492, 0.277402728796005, 0.277403384447098, 0.277404278516769, 0.27740541100502, 0.277406811714172, 0.277408421039581, 0.277410268783569, 0.277412384748459, 0.277414739131927, 0.27741727232933, 0.277420073747635, 0.277423173189163, 0.277426421642303, 0.277429968118668, 0.277433753013611, 0.277437746524811, 0.27744197845459, 0.277446448802948, 0.277451187372208, 0.277456164360046, 0.277461349964142, 0.277466803789139, 0.277472466230392, 0.277478396892548, 0.277484565973282, 0.277490943670273, 0.277497589588165, 0.277504444122314, 0.277511596679688, 0.277518928050995, 0.277526527643204, 0.277534365653992, 0.277542412281036, 0.277550727128983, 0.277559280395508, 0.277568072080612, 0.277577102184296, 0.277586370706558, 0.2775958776474, 0.277605623006821, 0.277615576982498, 0.277625799179077, 0.277636289596558, 0.277646988630295, 0.277657926082611, 0.277669101953506, 0.277680486440659, 0.277692168951035, 0.277704060077667, 0.277716189622879, 0.27772855758667, 0.27774116396904, 0.277754038572311, 0.27776712179184, 0.277780443429947, 0.277794003486633, 0.277807831764221, 0.277821868658066, 0.277836173772812, 0.277850657701492, 0.277865439653397, 0.27788046002388, 0.277895659208298, 0.277911156415939, 0.27792689204216, 0.277942836284637, 0.277959018945694, 0.277975469827652, 0.277992129325867, 0.278009057044983, 0.278026223182678, 0.27804359793663, 0.278061240911484, 0.278079122304916, 0.278097212314606, 0.278115540742874, 0.278134137392044, 0.278152972459793, 0.278171807527542, 0.278190821409225, 0.278210014104843, 0.278229415416718, 0.278248995542526, 0.278268843889236, 0.278288900852203, 0.278309166431427, 0.278329640626907, 0.278350293636322, 0.278371185064316, 0.278392314910889, 0.278413593769073, 0.278435170650482, 0.278456896543503, 0.278478860855103, 0.278501033782959, 0.278523415327072, 0.278546005487442, 0.278568804264069, 0.278591841459274, 0.278615087270737, 0.278638511896133, 0.278662174940109, 0.278686076402664, 0.278710126876831, 0.278734445571899, 0.278758972883224, 0.278783708810806, 0.278808623552322, 0.278833776712418, 0.27885913848877, 0.278884738683701, 0.278910517692566, 0.278936505317688, 0.278962701559067, 0.278989136219025, 0.279015779495239, 0.279042631387711, 0.279069691896439, 0.279096990823746, 0.27912449836731, 0.279152154922485, 0.279180109500885, 0.279208242893219, 0.27923658490181, 0.279265135526657, 0.279293924570084, 0.279322862625122, 0.279352098703384, 0.279381483793259, 0.279411107301712, 0.279440969228745, 0.279470980167389, 0.279501229524612, 0.279531717300415, 0.279562413692474, 0.279593288898468, 0.279624432325363, 0.279655754566193, 0.279687285423279, 0.279719024896622, 0.279751002788544, 0.2797831594944, 0.279815554618835, 0.279848158359528, 0.279880970716476, 0.279913991689682, 0.279947251081467, 0.279980689287186, 0.280014365911484, 0.280048251152039, 0.280082315206528, 0.280116617679596, 0.280151128768921, 0.280185878276825, 0.280220806598663, 0.280255973339081, 0.280291318893433, 0.280326932668686, 0.280362695455551, 0.280398726463318, 0.280434936285019, 0.280471384525299, 0.280508011579514, 0.280544877052307, 0.280581951141357, 0.280619233846664, 0.280656725168228, 0.280694425106049, 0.280732363462448, 0.280770480632782, 0.280808836221695, 0.280847400426865, 0.280886173248291, 0.280925154685974, 0.280964344739914, 0.281003773212433, 0.281043380498886, 0.281083226203918, 0.281126469373703, 0.281172931194305, 0.281219512224197, 0.281266152858734, 0.281312853097916, 0.281359612941742, 0.281406462192535, 0.281453341245651, 0.281500279903412, 0.28154730796814, 0.281594395637512, 0.28164154291153, 0.281688749790192, 0.281736046075821, 0.281783401966095, 0.281830787658691, 0.281878262758255, 0.281925827264786, 0.281973421573639, 0.282021105289459, 0.282068818807602, 0.282116651535034, 0.282164484262466, 0.282212436199188, 0.282260417938232, 0.282308489084244, 0.2823566198349, 0.282404810190201, 0.282453060150146, 0.282501369714737, 0.282549768686295, 0.282598227262497, 0.282646715641022, 0.282695323228836, 0.282743960618973, 0.282792657613754, 0.282841444015503, 0.282890260219574, 0.282939165830612, 0.282988160848618, 0.283037185668945, 0.28308629989624, 0.28313547372818, 0.283184707164764, 0.283233970403671, 0.283283352851868, 0.283332794904709, 0.283382266759872, 0.283431828022003, 0.283481448888779, 0.283531099557877, 0.283580869436264, 0.283630669116974, 0.283680558204651, 0.283730506896973, 0.283780515193939, 0.283830612897873, 0.283880710601807, 0.283930957317352, 0.283981174230576, 0.284031540155411, 0.284081965684891, 0.284132391214371, 0.284182906150818, 0.284233510494232, 0.284284174442291, 0.284334868192673, 0.284385681152344, 0.284436523914337, 0.28448748588562, 0.284538447856903, 0.284589499235153, 0.284640610218048, 0.28469181060791, 0.284743040800095, 0.284794360399246, 0.284845739603043, 0.284897148609161, 0.28494867682457, 0.2850002348423, 0.285051852464676, 0.285103589296341, 0.285155326128006, 0.285207182168961, 0.285259038209915, 0.285311013460159, 0.285363048315048, 0.28541511297226, 0.285467267036438, 0.285519510507584, 0.285571753978729, 0.285624146461487, 0.285676538944244, 0.285729020833969, 0.285781562328339, 0.285834163427353, 0.285886824131012, 0.285939574241638, 0.285992413759232, 0.286045253276825, 0.286097526550293, 0.286148965358734, 0.286200225353241, 0.286251306533813, 0.286302208900452, 0.286352932453156, 0.286403447389603, 0.286453783512115, 0.286503940820694, 0.286553919315338, 0.286603689193726, 0.286653280258179, 0.286702692508698, 0.286751955747604, 0.286800980567932, 0.286849826574326, 0.286898523569107, 0.286947011947632, 0.286995321512222, 0.287043452262878, 0.287091374397278, 0.287139117717743, 0.287186712026596, 0.287234097719193, 0.287281274795532, 0.28732830286026, 0.287375152111053, 0.28742179274559, 0.28746822476387, 0.287514507770538, 0.287560611963272, 0.287606477737427, 0.287652254104614, 0.287697792053223, 0.287743121385574, 0.287788301706314, 0.287833273410797, 0.287878096103668, 0.287922710180283, 0.287967145442963, 0.288011372089386, 0.288055449724197, 0.288099318742752, 0.288143008947372, 0.288186490535736, 0.288229823112488, 0.288272976875305, 0.288315922021866, 0.288358688354492, 0.288401275873184, 0.288443684577942, 0.288485884666443, 0.288527935743332, 0.288569778203964, 0.28861141204834, 0.288652926683426, 0.288694232702255, 0.288735300302505, 0.288776248693466, 0.288816958665848, 0.28885754942894, 0.288897901773453, 0.288938075304031, 0.288978099822998, 0.289017885923386, 0.289057552814484, 0.289096981287003, 0.289136230945587, 0.28917533159256, 0.289214193820953, 0.289252907037735, 0.289291441440582, 0.289329767227173, 0.289367944002151, 0.289405882358551, 0.289443701505661, 0.289481282234192, 0.289518713951111, 0.289555937051773, 0.289592981338501, 0.289629846811295, 0.289666503667831, 0.289703041315079, 0.289739310741425, 0.289775460958481, 0.28981140255928, 0.289847135543823, 0.289882719516754, 0.289918094873428, 0.289953291416168, 0.289988309144974, 0.290023148059845, 0.290057778358459, 0.290092259645462, 0.290126532316208, 0.290160626173019, 0.290194511413574, 0.290228247642517, 0.290261775255203, 0.290295124053955, 0.290325939655304, 0.29035410284996, 0.290381908416748, 0.290409445762634, 0.290436655282974, 0.290463507175446, 0.290490090847015, 0.290516346693039, 0.290542304515839, 0.29056790471077, 0.290593236684799, 0.290618240833282, 0.290642917156219, 0.290667295455933, 0.290691375732422, 0.290715098381042, 0.290738552808762, 0.290761679410934, 0.290784448385239, 0.290806949138641, 0.29082915186882, 0.290850967168808, 0.290872544050217, 0.290893793106079, 0.290914714336395, 0.290935307741165, 0.290955603122711, 0.290975570678711, 0.290995270013809, 0.291014581918716, 0.291033655405045, 0.291052371263504, 0.29107078909874, 0.291088879108429, 0.291106671094894, 0.291124165058136, 0.291141301393509, 0.291158139705658, 0.291174679994583, 0.291190892457962, 0.291206777095795, 0.291222393512726, 0.291237652301788, 0.291252583265305, 0.291267246007919, 0.291281580924988, 0.29129558801651, 0.291309297084808, 0.29132267832756, 0.291335791349411, 0.291348546743393, 0.291361004114151, 0.291373133659363, 0.291384935379028, 0.291396468877792, 0.291407644748688, 0.291418522596359, 0.291429102420807, 0.291439354419708, 0.291449278593063, 0.291458904743195, 0.291468232870102, 0.291477233171463, 0.291485905647278, 0.291494280099869, 0.291502326726913, 0.291510075330734, 0.291517496109009, 0.291524618864059, 0.291531443595886, 0.291537910699844, 0.291544079780579, 0.291549950838089, 0.291555494070053, 0.291560739278793, 0.291565656661987, 0.291570246219635, 0.291574537754059, 0.291578501462936, 0.291582196950912, 0.29158553481102, 0.291588574647903, 0.291591286659241, 0.291593700647354, 0.291595816612244, 0.291597574949265, 0.291599065065384, 0.291600197553635, 0.291601032018661, 0.291601568460464, 0.291601777076721, 0.291601657867432, 0.291601270437241, 0.291600525379181, 0.291599482297897, 0.29159814119339, 0.291596472263336, 0.291594475507736, 0.291592180728912, 0.291589558124542, 0.291586399078369, 0.291582524776459, 0.29157829284668, 0.291573703289032, 0.29156881570816, 0.291563540697098, 0.291557967662811, 0.291552037000656, 0.291545808315277, 0.291539222002029, 0.291532307863235, 0.291525036096573, 0.291517436504364, 0.291509538888931, 0.291501253843307, 0.29149267077446, 0.291483730077744, 0.291474461555481, 0.29146483540535, 0.291454881429672, 0.291444599628448, 0.291433990001678, 0.291423052549362, 0.291411757469177, 0.291400134563446, 0.291388183832169, 0.291375875473022, 0.291363269090652, 0.291350275278091, 0.291336983442307, 0.291323333978653, 0.291309326887131, 0.291295051574707, 0.291280418634415, 0.291265398263931, 0.291250109672546, 0.29123443365097, 0.291218429803848, 0.291202127933502, 0.291185438632965, 0.291168421506882, 0.291151136159897, 0.291133433580399, 0.291115432977676, 0.291097104549408, 0.291078418493271, 0.291059404611588, 0.291040033102036, 0.291020393371582, 0.291000366210938, 0.290979981422424, 0.290959268808365, 0.290938258171082, 0.290916860103607, 0.290895193815231, 0.290873140096664, 0.290850788354874, 0.290828078985214, 0.290805011987686, 0.290781617164612, 0.290757924318314, 0.290733873844147, 0.290709465742111, 0.290684759616852, 0.290659695863724, 0.290634304285049, 0.290608555078506, 0.290582478046417, 0.290556073188782, 0.2905293405056, 0.29050225019455, 0.290474832057953, 0.29044708609581, 0.290418982505798, 0.290390580892563, 0.290361821651459, 0.290332734584808, 0.290303319692612, 0.290273547172546, 0.290243446826935, 0.290212959051132, 0.290182203054428, 0.290151089429855, 0.290119677782059, 0.290087878704071, 0.290055751800537, 0.290023326873779, 0.289990544319153, 0.289957404136658, 0.289923936128616, 0.289890140295029, 0.289856016635895, 0.289821535348892, 0.289786726236343, 0.289751589298248, 0.289716124534607, 0.289680302143097, 0.289644122123718, 0.289607673883438, 0.289570838212967, 0.289532423019409, 0.289492696523666, 0.2894526720047, 0.289412319660187, 0.28937166929245, 0.289330750703812, 0.289289474487305, 0.289247959852219, 0.289206117391586, 0.289164006710052, 0.289121568202972, 0.289078831672668, 0.289035797119141, 0.288992464542389, 0.288948833942413, 0.288904875516891, 0.288860619068146, 0.288816124200821, 0.28877130150795, 0.288726150989532, 0.288680702447891, 0.288634985685349, 0.28858894109726, 0.288542628288269, 0.288495987653732, 0.288449048995972, 0.28840184211731, 0.288354277610779, 0.288306444883347, 0.28825831413269, 0.288209915161133, 0.288161188364029, 0.288112163543701, 0.288062810897827, 0.288013190031052, 0.28796324133873, 0.287913024425507, 0.287862509489059, 0.287811666727066, 0.287760525941849, 0.287709087133408, 0.287657380104065, 0.287605345249176, 0.287553012371063, 0.287500381469727, 0.287447482347488, 0.287394255399704, 0.287340700626373, 0.287286907434464, 0.287232756614685, 0.287178337574005, 0.287123620510101, 0.287068575620651, 0.2870132625103, 0.286957651376724, 0.286901712417603, 0.286845475435257, 0.28678897023201, 0.286732137203217, 0.286674976348877, 0.286617577075958, 0.286559849977493, 0.286501854658127, 0.286443501710892, 0.286384910345078, 0.286325961351395, 0.28626674413681, 0.286207228899002, 0.28614741563797, 0.286087274551392, 0.286026865243912, 0.285966157913208, 0.285905122756958, 0.285843789577484, 0.285782188177109, 0.285720258951187, 0.285658031702042, 0.285595506429672, 0.285532712936401, 0.285469561815262, 0.285406142473221, 0.285342425107956, 0.285278409719467, 0.285214096307755, 0.285149484872818, 0.285084575414658, 0.285019338130951, 0.28495380282402, 0.284887999296188, 0.284821897745132, 0.28475546836853, 0.284688770771027, 0.284621745347977, 0.284554421901703, 0.284486800432205, 0.284418910741806, 0.284350663423538, 0.284282147884369, 0.284213334321976, 0.284144222736359, 0.284073531627655, 0.284000068902969, 0.283926457166672, 0.283852696418762, 0.283778816461563, 0.283704787492752, 0.283630609512329, 0.283556312322617, 0.28348183631897, 0.283407270908356, 0.283332526683807, 0.283257663249969, 0.28318265080452, 0.283107489347458, 0.283032208681107, 0.282956779003143, 0.282881230115891, 0.282805502414703, 0.282729655504227, 0.282653659582138, 0.282577574253082, 0.28250128030777, 0.282424867153168, 0.282348334789276, 0.282271653413773, 0.282194823026657, 0.28211784362793, 0.282040745019913, 0.281963527202606, 0.281886130571365, 0.281808614730835, 0.281730979681015, 0.281653165817261, 0.281575232744217, 0.281497150659561, 0.281418919563293, 0.281340569257736, 0.281262069940567, 0.281183421611786, 0.281104654073715, 0.28102570772171, 0.280946671962738, 0.280867487192154, 0.280788123607635, 0.28070867061615, 0.280629068613052, 0.280549287796021, 0.280469417572021, 0.280389368534088, 0.280309200286865, 0.28022888302803, 0.280148416757584, 0.280067831277847, 0.279987096786499, 0.279906243085861, 0.279825240373611, 0.279744058847427, 0.279662787914276, 0.279581338167191, 0.279499799013138, 0.279418051242828, 0.279336214065552, 0.279254227876663, 0.279172122478485, 0.279089838266373, 0.279007405042648, 0.278924882411957, 0.278842210769653, 0.278759390115738, 0.278676420450211, 0.278593331575394, 0.278510063886642, 0.278426706790924, 0.278343170881271, 0.278259515762329, 0.278175711631775, 0.278091788291931, 0.278007686138153, 0.277923464775085, 0.277839064598083, 0.277754575014114, 0.277669936418533, 0.27758514881134, 0.277500241994858, 0.277415186166763, 0.277329981327057, 0.277244657278061, 0.277159184217453, 0.277073562145233, 0.276987791061401, 0.27690190076828, 0.276815891265869, 0.276729673147202, 0.276643395423889, 0.276556938886642, 0.276470333337784, 0.276383578777313, 0.276296734809875, 0.276209712028503, 0.276122570037842, 0.276035755872726, 0.275949388742447, 0.275863140821457, 0.275776952505112, 0.275690853595734, 0.275604814291, 0.275518894195557, 0.275433003902435, 0.275347232818604, 0.275261521339417, 0.275175929069519, 0.275090366601944, 0.275004923343658, 0.274919539690018, 0.274834245443344, 0.274749040603638, 0.274663925170898, 0.274578869342804, 0.274493932723999, 0.274409055709839, 0.274324238300323, 0.274239540100098, 0.274154901504517, 0.27407032251358, 0.273985862731934, 0.273901462554932, 0.273817181587219, 0.273732960224152, 0.273648798465729, 0.273564726114273, 0.273480772972107, 0.273396849632263, 0.273313045501709, 0.2732293009758, 0.27314567565918, 0.273062080144882, 0.272978603839874, 0.272895216941833, 0.27281191945076, 0.272728651762009, 0.272645473480225, 0.27256241440773, 0.272479385137558, 0.272396475076675, 0.272313684225082, 0.272230923175812, 0.272148221731186, 0.27206563949585, 0.27198314666748, 0.271900713443756, 0.271818399429321, 0.271736145019531, 0.271653950214386, 0.271571844816208, 0.271489828824997, 0.271407902240753, 0.271326065063477, 0.271244287490845, 0.27116259932518, 0.271081000566483, 0.27099946141243, 0.270918041467667, 0.270836681127548, 0.270755380392075, 0.270674198865891, 0.270593076944351, 0.270512074232101, 0.270431101322174, 0.270350247621536, 0.270269453525543, 0.270188748836517, 0.270108133554459, 0.270027607679367, 0.26994714140892, 0.269866764545441, 0.269786447286606, 0.269706249237061, 0.269626140594482, 0.269546061754227, 0.269466072320938, 0.269386231899261, 0.269306391477585, 0.26922670006752, 0.269147038459778, 0.269067496061325, 0.268988013267517, 0.268908619880676, 0.268829315900803, 0.268750101327896, 0.268670916557312, 0.26859188079834, 0.268512904644012, 0.26843398809433, 0.268355160951614, 0.268276423215866, 0.268197774887085, 0.268119186162949, 0.268040686845779, 0.267962276935577, 0.267883956432343, 0.267807096242905, 0.267733067274094, 0.267659276723862, 0.267585694789886, 0.26751235127449, 0.267439126968384, 0.267366170883179, 0.26729342341423, 0.267220854759216, 0.267148524522781, 0.267076402902603, 0.267004430294037, 0.26693269610405, 0.266861170530319, 0.266789853572845, 0.266718715429306, 0.266647785902023, 0.26657709479332, 0.266506612300873, 0.26643630862236, 0.266366183757782, 0.266296297311783, 0.26622661948204, 0.266157120466232, 0.266087859869003, 0.266018807888031, 0.265949934720993, 0.265881270170212, 0.265812814235687, 0.265744566917419, 0.265676528215408, 0.265608698129654, 0.265541046857834, 0.265473634004593, 0.265406399965286, 0.265339404344559, 0.265272587537766, 0.265205979347229, 0.265139549970627, 0.265073418617249, 0.26500740647316, 0.264941602945328, 0.264876037836075, 0.264810681343079, 0.264745503664017, 0.264680534601212, 0.264615774154663, 0.264551192522049, 0.264486849308014, 0.264422714710236, 0.264358788728714, 0.264295041561127, 0.264231532812119, 0.264168173074722, 0.264105051755905, 0.264042168855667, 0.263979434967041, 0.263916969299316, 0.263854652643204, 0.26379257440567, 0.263730704784393, 0.263669013977051, 0.263607531785965, 0.263546228408813, 0.263485163450241, 0.263424336910248, 0.263363689184189, 0.263303190469742, 0.263242959976196, 0.263182938098907, 0.263123095035553, 0.263063460588455, 0.263004034757614, 0.262944847345352, 0.262885808944702, 0.262827008962631, 0.262768387794495, 0.262710005044937, 0.262651830911636, 0.26259383559227, 0.26253604888916, 0.262478470802307, 0.262421101331711, 0.262363940477371, 0.262306958436966, 0.26225021481514, 0.262193650007248, 0.262137293815613, 0.262081146240234, 0.262025237083435, 0.26196950674057, 0.261913985013962, 0.261858642101288, 0.261803537607193, 0.261748641729355, 0.261693924665451, 0.261639416217804, 0.261585116386414, 0.261531054973602, 0.261477172374725, 0.261425912380219, 0.261375844478607, 0.261325925588608, 0.261276215314865, 0.261226624250412, 0.261177271604538, 0.261128097772598, 0.261079072952271, 0.261030226945877, 0.260981619358063, 0.260933101177216, 0.260884821414948, 0.260836690664291, 0.260788768529892, 0.260741025209427, 0.260693460702896, 0.260646045207977, 0.260598808526993, 0.260551810264587, 0.260504931211472, 0.260458260774612, 0.260411769151688, 0.260365456342697, 0.260319292545319, 0.260273337364197, 0.260227560997009, 0.260181933641434, 0.260136544704437, 0.26009127497673, 0.26004621386528, 0.260001301765442, 0.259956628084183, 0.259912103414536, 0.2598677277565, 0.259823560714722, 0.259779572486877, 0.259735763072968, 0.259692132472992, 0.259648680686951, 0.259605407714844, 0.259562313556671, 0.259519398212433, 0.259476631879807, 0.259434133768082, 0.259391725063324, 0.259349524974823, 0.259307503700256, 0.259265661239624, 0.259223967790604, 0.259182512760162, 0.259141206741333, 0.25910010933876, 0.2590591609478, 0.259018391370773, 0.258977830410004, 0.258937388658524, 0.2588971555233, 0.258857131004333, 0.258817255496979, 0.258777558803558, 0.258738040924072, 0.258698701858521, 0.258659571409225, 0.258620589971542, 0.258581787347794, 0.258543193340302, 0.258504748344421, 0.258466511964798, 0.258428424596786, 0.258390545845032, 0.258352816104889, 0.25831526517868, 0.258277922868729, 0.258240729570389, 0.258203715085983, 0.258166909217834, 0.258130252361298, 0.258093804121017, 0.258057534694672, 0.258021414279938, 0.257985472679138, 0.257949739694595, 0.257914155721664, 0.25787878036499, 0.257843554019928, 0.257808566093445, 0.257773697376251, 0.257739007472992, 0.257704526185989, 0.257670193910599, 0.257636070251465, 0.257602155208588, 0.257568359375, 0.257534772157669, 0.25750133395195, 0.257468104362488, 0.257435023784637, 0.257402151823044, 0.257369488477707, 0.25733694434166, 0.257305711507797, 0.25727516412735, 0.257244646549225, 0.257214218378067, 0.257183849811554, 0.257153481245041, 0.257123202085495, 0.257092952728271, 0.25706273317337, 0.257032603025436, 0.257002502679825, 0.25697249174118, 0.256942480802536, 0.256912529468536, 0.256882637739182, 0.256852775812149, 0.256823003292084, 0.256793260574341, 0.25676354765892, 0.256733894348145, 0.256704300642014, 0.25667479634285, 0.256645292043686, 0.256615847349167, 0.25658643245697, 0.256557106971741, 0.256527811288834, 0.256498575210571, 0.256469398736954, 0.256440222263336, 0.256411135196686, 0.25638210773468, 0.256353110074997, 0.256324172019958, 0.256295263767242, 0.256266444921494, 0.256237626075745, 0.256208896636963, 0.256180197000504, 0.256151556968689, 0.256122946739197, 0.256094425916672, 0.256065934896469, 0.256037473678589, 0.256009072065353, 0.255980730056763, 0.255952447652817, 0.255924224853516, 0.255896002054214, 0.25586786866188, 0.255839765071869, 0.255811750888824, 0.255783766508102, 0.255755811929703, 0.255727916955948, 0.255700081586838, 0.25567227602005, 0.255644530057907, 0.255616843700409, 0.255589187145233, 0.255561590194702, 0.255534052848816, 0.255506575107574, 0.255479127168655, 0.255451738834381, 0.255424410104752, 0.255397081375122, 0.255369871854782, 0.255342662334442, 0.255315542221069, 0.255288451910019, 0.255261391401291, 0.255234390497208, 0.255207449197769, 0.255180567502975, 0.255153715610504, 0.255126923322678, 0.255100190639496, 0.255073487758636, 0.255046844482422, 0.255020290613174, 0.254993736743927, 0.254967242479324, 0.254940778017044, 0.254914402961731, 0.25488805770874, 0.254861772060394, 0.254835546016693, 0.254809349775314, 0.25478321313858, 0.254757106304169, 0.254731059074402, 0.25470507144928, 0.254679143428802, 0.254653245210648, 0.254627406597137, 0.25460159778595, 0.254575878381729, 0.254550188779831, 0.254524528980255, 0.254495173692703, 0.254468142986298, 0.254440993070602, 0.254413783550262, 0.254386514425278, 0.254359126091003, 0.254331648349762, 0.254304081201553, 0.254276424646378, 0.254248708486557, 0.254220873117447, 0.254192978143692, 0.254164963960648, 0.254136890172958, 0.254108726978302, 0.254080474376678, 0.254052132368088, 0.25402370095253, 0.253995209932327, 0.253966569900513, 0.253937900066376, 0.253909140825272, 0.253880262374878, 0.253851324319839, 0.253822267055511, 0.253793150186539, 0.253763943910599, 0.253734648227692, 0.253705233335495, 0.253675788640976, 0.25364625453949, 0.253616571426392, 0.253586858510971, 0.253557026386261, 0.253527104854584, 0.253497123718262, 0.253467053174973, 0.253436893224716, 0.253406643867493, 0.25337627530098, 0.253345876932144, 0.253315359354019, 0.253284722566605, 0.253254055976868, 0.253223299980164, 0.25319242477417, 0.253161460161209, 0.253130435943604, 0.253099322319031, 0.253068119287491, 0.253036797046661, 0.253005415201187, 0.252973973751068, 0.252942383289337, 0.252910763025284, 0.252879023551941, 0.252847224473953, 0.252815306186676, 0.252783298492432, 0.25275120139122, 0.252719044685364, 0.25268679857254, 0.25265446305275, 0.252622038125992, 0.252589523792267, 0.252556920051575, 0.252524226903915, 0.252491444349289, 0.252458602190018, 0.252425640821457, 0.252392590045929, 0.252359479665756, 0.252326279878616, 0.252292990684509, 0.252259582281113, 0.252226144075394, 0.252192556858063, 0.252158939838409, 0.252125203609467, 0.252091377973557, 0.252057492733002, 0.252023458480835, 0.251989394426346, 0.25195524096489, 0.251920968294144, 0.251886636018753, 0.251852214336395, 0.25181770324707, 0.251783102750778, 0.251748412847519, 0.251713663339615, 0.251678764820099, 0.25164383649826, 0.251608788967133, 0.251573652029037, 0.251538455486298, 0.251503169536591, 0.251467794179916, 0.251432329416275, 0.251396745443344, 0.251359134912491, 0.25132018327713, 0.25128111243248, 0.25124192237854, 0.251202553510666, 0.251163065433502, 0.251123458147049, 0.251083701848984, 0.251043856143951, 0.251003831624985, 0.250963687896729, 0.250923424959183, 0.250882983207703, 0.250842452049255, 0.250801771879196, 0.250760972499847, 0.250720024108887, 0.250678926706314, 0.250637710094452, 0.2505963742733, 0.250554889440536, 0.250513285398483, 0.250471532344818, 0.250429660081863, 0.250387668609619, 0.250345498323441, 0.250303208827972, 0.250260829925537, 0.250218242406845, 0.250175595283508, 0.250132769346237, 0.250089824199677, 0.250046759843826, 0.250003546476364, 0.24996018409729, 0.249916702508926, 0.249873101711273, 0.249829337000847, 0.249785453081131, 0.249741464853287, 0.249697297811508, 0.249653041362762, 0.249608621001244, 0.249564066529274, 0.249519377946854, 0.249474570155144, 0.249429628252983, 0.249384537339211, 0.249339327216148, 0.249293982982635, 0.249248519539833, 0.249202892184258, 0.249157145619392, 0.249111264944077, 0.249065235257149, 0.249019116163254, 0.248972803354263, 0.248926401138306, 0.248879864811897, 0.248833179473877, 0.248786360025406, 0.248739421367645, 0.248692348599434, 0.248645126819611, 0.248597770929337, 0.248550310730934, 0.248502686619759, 0.248454943299294, 0.248407050967216, 0.248359054327011, 0.248310878872871, 0.248262599110603, 0.248214185237885, 0.248165637254715, 0.248116970062256, 0.248068138957024, 0.248019218444824, 0.24797011911869, 0.247920900583267, 0.247871547937393, 0.24782207608223, 0.247772470116615, 0.247722700238228, 0.247672840952873, 0.247622817754745, 0.247572690248489, 0.247522369027138, 0.24747197329998, 0.247421413660049, 0.247370734810829, 0.247319936752319, 0.247268974781036, 0.247217893600464, 0.247166693210602, 0.247115328907967, 0.247063845396042, 0.247012227773666, 0.24696047604084, 0.246908590197563, 0.246856585144997, 0.246804773807526, 0.246750593185425, 0.246696352958679, 0.246642038226128, 0.246587634086609, 0.246533140540123, 0.246478602290154, 0.246423974633217, 0.246369257569313, 0.246314465999603, 0.246259599924088, 0.246204674243927, 0.246149644255638, 0.246094539761543, 0.246039360761642, 0.245984107255936, 0.245928794145584, 0.245873376727104, 0.245817884802818, 0.245762333273888, 0.24570669233799, 0.245650976896286, 0.245595186948776, 0.245539292693138, 0.245483338832855, 0.245427325367928, 0.245371222496033, 0.24531501531601, 0.245258748531342, 0.245202422142029, 0.245146036148071, 0.245089530944824, 0.245032951235771, 0.244976297020912, 0.244919568300247, 0.244862750172615, 0.244805857539177, 0.244748935103416, 0.244691863656044, 0.244634762406349, 0.244577556848526, 0.244520306587219, 0.244462937116623, 0.244405508041382, 0.244348004460335, 0.244290426373482, 0.244232773780823, 0.244175046682358, 0.244117215275764, 0.244059324264526, 0.244001358747482, 0.243943303823471, 0.243885204195976, 0.243826985359192, 0.243768692016602, 0.243710339069366, 0.243651896715164, 0.243593394756317, 0.243534818291664, 0.243476122617722, 0.243417397141457, 0.243358552455902, 0.243299663066864, 0.243240669369698, 0.243181630969048, 0.24312250316143, 0.243063285946846, 0.243003979325294, 0.242944628000259, 0.242885157465935, 0.242825657129288, 0.242766052484512, 0.24270635843277, 0.242646604776382, 0.242586776614189, 0.242526844143867, 0.242466896772385, 0.24240680038929, 0.242346674203873, 0.242286443710327, 0.242226153612137, 0.242165789008141, 0.242105305194855, 0.242044776678085, 0.241984203457832, 0.241923481225967, 0.24186272919178, 0.241801872849464, 0.241740956902504, 0.241679966449738, 0.241618886590004, 0.241557732224464, 0.241496488451958, 0.241435185074806, 0.241373792290688, 0.241312339901924, 0.241250783205032, 0.241189196705818, 0.241127490997314, 0.241065710783005, 0.241001129150391, 0.240939944982529, 0.240878745913506, 0.240817561745644, 0.240756377577782, 0.240695178508759, 0.240634009242058, 0.240572839975357, 0.240511655807495, 0.240450486540794, 0.240389332175255, 0.240328177809715, 0.240267023444176, 0.240205869078636, 0.240144714713097, 0.240083560347557, 0.240022450685501, 0.239961311221123, 0.239900171756744, 0.239839032292366, 0.239777907729149, 0.239716783165932, 0.239655673503876, 0.239594548940659, 0.239533469080925, 0.239472344517708, 0.239411249756813, 0.239350154995918, 0.239289030432701, 0.239227950572968, 0.239166870713234, 0.2391057908535, 0.239044710993767, 0.238983631134033, 0.238922566175461, 0.238861501216888, 0.238800421357155, 0.238739356398582, 0.238678336143494, 0.23861725628376, 0.238556206226349, 0.238495171070099, 0.238434121012688, 0.238373085856438, 0.238312035799026, 0.238251030445099, 0.238189980387688, 0.23812897503376, 0.238067954778671, 0.238006919622421, 0.237945914268494, 0.237884923815727, 0.237823903560638, 0.237762928009033, 0.237701922655106, 0.237640932202339, 0.237579926848412, 0.237518936395645, 0.237457975745201, 0.237397000193596, 0.237336024641991, 0.237275063991547, 0.237214088439941, 0.237153112888336, 0.237092167139053, 0.237031206488609, 0.236970260739326, 0.236909314990044, 0.236848369240761, 0.236787423491478, 0.236726507544518, 0.236665576696396, 0.236604645848274, 0.236543700098991, 0.236482813954353, 0.23642186820507, 0.23636095225811, 0.236300051212311, 0.236239165067673, 0.236178249120712, 0.236117348074913, 0.236056461930275, 0.235995560884476, 0.235934674739838, 0.235873803496361, 0.235812917351723, 0.235752046108246, 0.23569118976593, 0.235630318522453, 0.235569447278976, 0.235508605837822, 0.235447719693184, 0.235386878252029, 0.235326036810875, 0.23526519536972, 0.235204339027405, 0.23514349758625, 0.235082671046257, 0.235021874308586, 0.234961032867432, 0.234903112053871, 0.234843969345093, 0.234784871339798, 0.234725832939148, 0.234666809439659, 0.234607845544815, 0.234548911452293, 0.234490007162094, 0.23443116247654, 0.234372317790985, 0.234313562512398, 0.23425480723381, 0.234196111559868, 0.234137445688248, 0.234078824520111, 0.234020248055458, 0.233961701393127, 0.233903184533119, 0.233844727277756, 0.233786284923553, 0.233727917075157, 0.233669564127922, 0.233611255884171, 0.233552992343903, 0.233494758605957, 0.233436554670334, 0.233378425240517, 0.233320310711861, 0.233262225985527, 0.233204185962677, 0.233146190643311, 0.233088225126266, 0.233030334115028, 0.23297244310379, 0.232914611697197, 0.232856810092926, 0.232799038290977, 0.232741326093674, 0.232683628797531, 0.232626006007195, 0.232568398118019, 0.232510834932327, 0.232453316450119, 0.232395827770233, 0.23233836889267, 0.232280969619751, 0.232223600149155, 0.232166260480881, 0.23210896551609, 0.232051730155945, 0.23199450969696, 0.231937348842621, 0.231880217790604, 0.231823116540909, 0.231766059994698, 0.23170904815197, 0.231652066111565, 0.231595128774643, 0.231538221240044, 0.231481343507767, 0.231424525380135, 0.231367751955986, 0.23131100833416, 0.231254324316978, 0.231197625398636, 0.231141030788422, 0.231084436178207, 0.231027886271477, 0.23097138106823, 0.230914905667305, 0.230858489871025, 0.230802088975906, 0.230745732784271, 0.230689436197281, 0.230633169412613, 0.230576932430267, 0.230520740151405, 0.230464577674866, 0.23040845990181, 0.230352386832237, 0.230296343564987, 0.230240359902382, 0.230184391140938, 0.230128452181816, 0.2300725877285, 0.230016738176346, 0.229960948228836, 0.229905188083649, 0.229849472641945, 0.229793787002563, 0.229738131165504, 0.229682520031929, 0.229626968502998, 0.22957144677639, 0.229515954852104, 0.229460492730141, 0.229405075311661, 0.229349687695503, 0.229294389486313, 0.229239076375961, 0.229187443852425, 0.229134485125542, 0.229081526398659, 0.229028537869453, 0.228975564241409, 0.228922605514526, 0.228869616985321, 0.228816658258438, 0.22876363992691, 0.228710666298866, 0.228657647967339, 0.228604659438133, 0.228551641106606, 0.228498637676239, 0.22844560444355, 0.228392601013184, 0.228339567780495, 0.228286549448967, 0.228233516216278, 0.228180468082428, 0.228127419948578, 0.228074386715889, 0.228021338582039, 0.227968290448189, 0.227915212512016, 0.227862149477005, 0.227809071540833, 0.227756008505821, 0.227702915668488, 0.227649837732315, 0.227596759796143, 0.227543652057648, 0.227490574121475, 0.227437481284142, 0.227384373545647, 0.227331250905991, 0.227278128266335, 0.22722502052784, 0.227171912789345, 0.227118775248528, 0.227065652608871, 0.227012529969215, 0.226959377527237, 0.22690623998642, 0.226853087544441, 0.226799920201302, 0.226746782660484, 0.226693600416183, 0.226640433073044, 0.226587280631065, 0.226534098386765, 0.226480916142464, 0.226427718997002, 0.22637452185154, 0.226321339607239, 0.226268142461777, 0.226214945316315, 0.226161733269691, 0.226108521223068, 0.226055294275284, 0.226002082228661, 0.225948855280876, 0.225895628333092, 0.225842401385307, 0.225789159536362, 0.225735917687416, 0.22568267583847, 0.225629404187202, 0.225576147437096, 0.225522920489311, 0.225469633936882, 0.225416362285614, 0.225363090634346, 0.225309804081917, 0.225256532430649, 0.225203216075897, 0.225149944424629, 0.225096642971039, 0.22504335641861, 0.224990040063858, 0.224936738610268, 0.224883407354355, 0.224830120801926, 0.224776774644852, 0.224723443388939, 0.224670127034187, 0.224616780877113, 0.224563449621201, 0.224510088562965, 0.224456757307053, 0.224403396248817, 0.224350035190582, 0.224296674132347, 0.224243313074112, 0.224189952015877, 0.224136561155319, 0.224083185195923, 0.224029809236526, 0.223976403474808, 0.223923027515411, 0.223866790533066, 0.223814934492111, 0.223762914538383, 0.223710775375366, 0.223658517003059, 0.223606154322624, 0.223553657531738, 0.22350101172924, 0.223448231816292, 0.223395347595215, 0.223342314362526, 0.223289176821709, 0.223235920071602, 0.223182514309883, 0.223128974437714, 0.223075345158577, 0.223021551966667, 0.222967624664307, 0.222913607954979, 0.222859442234039, 0.22280515730381, 0.222750723361969, 0.222696185112, 0.222641497850418, 0.222586706280708, 0.222531765699387, 0.222476750612259, 0.222421541810036, 0.222366228699684, 0.222310796380043, 0.222255244851112, 0.222199559211731, 0.22214375436306, 0.222087800502777, 0.222031727433205, 0.221975535154343, 0.22191920876503, 0.221862733364105, 0.221806183457375, 0.221749469637871, 0.221692651510239, 0.221635669469833, 0.221578612923622, 0.221521347761154, 0.221464022994041, 0.221406579017639, 0.221348986029625, 0.22129125893116, 0.221233412623405, 0.221175417304039, 0.221117302775383, 0.221059083938599, 0.221000730991364, 0.220942258834839, 0.220883622765541, 0.220824882388115, 0.220766022801399, 0.220707014203072, 0.220647901296616, 0.220588684082031, 0.220529288053513, 0.220469787716866, 0.220410138368607, 0.22035039961338, 0.220290511846542, 0.220230504870415, 0.220170378684998, 0.220110103487968, 0.220049723982811, 0.219989195466042, 0.219928532838821, 0.219867765903473, 0.219806879758835, 0.219745859503746, 0.219684705138206, 0.219623416662216, 0.219561994075775, 0.219500467181206, 0.219438806176186, 0.219377025961876, 0.219315096735954, 0.219253018498421, 0.219190880656242, 0.219128578901291, 0.21906615793705, 0.219003602862358, 0.218940928578377, 0.218878105282784, 0.218815162777901, 0.218752101063728, 0.218688920140266, 0.218625605106354, 0.218562170863152, 0.218498587608337, 0.218434900045395, 0.21837106347084, 0.218307107686996, 0.218243032693863, 0.218178808689117, 0.218114495277405, 0.218052789568901, 0.217986643314362, 0.217920228838921, 0.217853516340256, 0.217786565423012, 0.21771939098835, 0.217651963233948, 0.217584267258644, 0.217516303062439, 0.217448085546494, 0.21737964451313, 0.217310950160027, 0.217241987586021, 0.217172786593437, 0.21710330247879, 0.217033565044403, 0.216963589191437, 0.21689336001873, 0.216822847723961, 0.216752126812935, 0.216681152582169, 0.216609910130501, 0.21653838455677, 0.216466635465622, 0.216394647955894, 0.216322392225266, 0.216249883174896, 0.216177091002464, 0.216104075312614, 0.216030806303024, 0.215957283973694, 0.21588346362114, 0.21580944955349, 0.2157351821661, 0.215660661458969, 0.215585857629776, 0.21551077067852, 0.215435475111008, 0.215359941124916, 0.215284124016762, 0.215208068490028, 0.215131759643555, 0.21505518257618, 0.214978352189064, 0.214901283383369, 0.214823946356773, 0.214746370911598, 0.214668542146683, 0.214590460062027, 0.214512094855309, 0.21443347632885, 0.214354649186134, 0.214275553822517, 0.214196220040321, 0.214116588234901, 0.21403668820858, 0.213956594467163, 0.213876217603683, 0.213795587420464, 0.213714733719826, 0.213633581995964, 0.213552206754684, 0.213470563292503, 0.213388681411743, 0.213306501507759, 0.213224098086357, 0.213141486048698, 0.213058561086655, 0.212975412607193, 0.212891966104507, 0.212808296084404, 0.212724387645721, 0.212640196084976, 0.212555810809135, 0.212471097707748, 0.212386175990105, 0.212300986051559, 0.212215527892113, 0.212129816412926, 0.212043881416321, 0.211957693099976, 0.21187125146389, 0.211784526705742, 0.211697563529015, 0.211610317230225, 0.211522847414017, 0.211435124278069, 0.211347177624702, 0.211258932948112, 0.21117040514946, 0.211081698536873, 0.210992708802223, 0.210903450846672, 0.210813969373703, 0.210724204778671, 0.21063420176506, 0.21054396033287, 0.210453420877457, 0.210362643003464, 0.210271641612053, 0.210175022482872, 0.210080906748772, 0.209986448287964, 0.209891751408577, 0.209796741604805, 0.209701433777809, 0.209605783224106, 0.209509864449501, 0.209413632750511, 0.20931713283062, 0.209220290184021, 0.209123194217682, 0.209025755524635, 0.208928048610687, 0.208830028772354, 0.208731755614281, 0.208633080124855, 0.208534151315689, 0.208434969186783, 0.20833545923233, 0.208235651254654, 0.20813550055027, 0.208035096526146, 0.207934409379959, 0.207833349704742, 0.207732066512108, 0.207630425691605, 0.2075285166502, 0.207426339387894, 0.207323789596558, 0.207220986485481, 0.207117900252342, 0.207014441490173, 0.206910759210587, 0.206806764006615, 0.206702381372452, 0.206597790122032, 0.206492871046066, 0.206387683749199, 0.206282138824463, 0.206176295876503, 0.206070229411125, 0.205963805317879, 0.20585709810257, 0.205750077962875, 0.205642774701118, 0.205535158514977, 0.205427244305611, 0.205319061875343, 0.205210521817207, 0.20510171353817, 0.204992637038231, 0.204883202910423, 0.204773485660553, 0.204663470387459, 0.204553157091141, 0.204442575573921, 0.204331621527672, 0.204220458865166, 0.204108908772469, 0.203997120261192, 0.203885063529015, 0.203772619366646, 0.203659906983376, 0.20354688167572, 0.203433573246002, 0.203320011496544, 0.203206047415733, 0.203091859817505, 0.202977374196053, 0.202862530946732, 0.202747464179993, 0.202632024884224, 0.202516332268715, 0.202400341629982, 0.202284023165703, 0.2021674066782, 0.202050507068634, 0.201933264732361, 0.201815813779831, 0.201697990298271, 0.201579868793488, 0.201461493968964, 0.201342776417732, 0.201223805546761, 0.201104491949081, 0.200984865427017, 0.200864925980568, 0.20074474811554, 0.200624257326126, 0.200503453612328, 0.200382366776466, 0.200260907411575, 0.200139224529266, 0.200017273426056, 0.199894949793816, 0.199772372841835, 0.199649408459663, 0.199526250362396, 0.199402749538422, 0.199270814657211, 0.199144944548607, 0.199018776416779, 0.19889235496521, 0.198765695095062, 0.198638767004013, 0.198511615395546, 0.198384135961533, 0.198256403207779, 0.19812847673893, 0.198000282049179, 0.19787172973156, 0.197743028402328, 0.197614029049873, 0.197484791278839, 0.197355255484581, 0.197225481271744, 0.197095468640327, 0.196965157985687, 0.19683463871479, 0.19670382142067, 0.196572750806808, 0.196441441774368, 0.196309834718704, 0.196178004145622, 0.1960459202528, 0.195913553237915, 0.19578093290329, 0.195648014545441, 0.195514962077141, 0.19538152217865, 0.195247903466225, 0.195113971829414, 0.194979801774025, 0.194845378398895, 0.194710701704025, 0.194575756788254, 0.194440573453903, 0.194305077195168, 0.194169357419014, 0.194033369421959, 0.193897143006325, 0.193760648369789, 0.193623885512352, 0.193486884236336, 0.193349614739418, 0.193212047219276, 0.193074271082878, 0.192936256527901, 0.192797899246216, 0.192659422755241, 0.192520543932915, 0.192381471395493, 0.192242130637169, 0.192102566361427, 0.191962689161301, 0.191822588443756, 0.191682204604149, 0.191541567444801, 0.191400662064552, 0.191259518265724, 0.191118091344833, 0.190976500511169, 0.190834492444992, 0.190692320466042, 0.190549910068512, 0.190407156944275, 0.190264239907265, 0.190121024847031, 0.189977526664734, 0.189833804965019, 0.189689800143242, 0.189545556902885, 0.189401045441628, 0.189256250858307, 0.189111292362213, 0.188965976238251, 0.188820451498032, 0.188674598932266, 0.188528522849083, 0.188382223248482, 0.188235700130463, 0.188088804483414, 0.187941685318947, 0.187794342637062, 0.187646791338921, 0.187498867511749, 0.18735072016716, 0.187202349305153, 0.187053680419922, 0.186904743313789, 0.186755627393723, 0.186606168746948, 0.186456486582756, 0.186306580901146, 0.186156377196312, 0.186005890369415, 0.18585516512394, 0.185704246163368, 0.185552984476089, 0.185405179858208, 0.185251832008362, 0.185098335146904, 0.184944719076157, 0.184790953993797, 0.184637010097504, 0.184482932090759, 0.184328749775887, 0.184174403548241, 0.184019863605499, 0.183865249156952, 0.183710426092148, 0.183555483818054, 0.18340040743351, 0.183245182037354, 0.183089762926102, 0.182934194803238, 0.182778522372246, 0.182622730731964, 0.182466730475426, 0.182310596108437, 0.182154327630997, 0.181997895240784, 0.181841358542442, 0.181684643030167, 0.18152779340744, 0.181370794773102, 0.181213647127151, 0.181056335568428, 0.180898904800415, 0.180741295218468, 0.18058355152607, 0.180425688624382, 0.180267661809921, 0.180109471082687, 0.179951161146164, 0.179792672395706, 0.179634064435959, 0.1794753074646, 0.179316386580467, 0.179157316684723, 0.178998127579689, 0.178838774561882, 0.178679227828979, 0.178519576787949, 0.178359821438789, 0.178199857473373, 0.178039759397507, 0.177879557013512, 0.177719175815582, 0.177558600902557, 0.177397966384888, 0.177237138152122, 0.177076146006584, 0.176915049552917, 0.176753789186478, 0.176592364907265, 0.176430836319923, 0.176269128918648, 0.176107257604599, 0.175945296883583, 0.17578312754631, 0.175620853900909, 0.175458371639252, 0.175295829772949, 0.175133094191551, 0.174970239400864, 0.174807190895081, 0.174644008278847, 0.174480676651001, 0.174317240715027, 0.174153596162796, 0.173989862203598, 0.173825949430466, 0.173661857843399, 0.173497676849365, 0.173333331942558, 0.173168838024139, 0.173004195094109, 0.172839432954788, 0.172674492001534, 0.172509402036667, 0.172344133257866, 0.172178789973259, 0.172013267874718, 0.171847626566887, 0.171681791543961, 0.171515807509422, 0.171349704265594, 0.171183452010155, 0.171017050743103, 0.170850515365601, 0.170683816075325, 0.170516967773438, 0.170349970459938, 0.170182824134827, 0.170015543699265, 0.169848084449768, 0.169680535793304, 0.169512808322906, 0.169353306293488, 0.169184863567352, 0.169016420841217, 0.168847993016243, 0.16867958009243, 0.168511182069778, 0.168342813849449, 0.168174430727959, 0.168006077408791, 0.167837724089622, 0.167669355869293, 0.167501002550125, 0.167332679033279, 0.167164400219917, 0.166996076703072, 0.166827753186226, 0.166659489274025, 0.166491225361824, 0.166322976350784, 0.166154682636261, 0.165986433625221, 0.165818184614182, 0.165649965405464, 0.165481775999069, 0.165313556790352, 0.165145367383957, 0.164977177977562, 0.164809033274651, 0.164640858769417, 0.164472728967667, 0.164304554462433, 0.164136409759521, 0.163968309760094, 0.163800209760666, 0.163632065057755, 0.163464039564133, 0.163295939564705, 0.163127884268761, 0.162959814071655, 0.162791758775711, 0.162623718380928, 0.162455692887306, 0.162287667393684, 0.162119671702385, 0.161951690912247, 0.161783695220947, 0.16161572933197, 0.161447733640671, 0.161279812455177, 0.161111801862717, 0.160943895578384, 0.160775974392891, 0.160608053207397, 0.160440176725388, 0.160272300243378, 0.160104393959045, 0.159936517477036, 0.159768655896187, 0.159600794315338, 0.159432962536812, 0.159265130758286, 0.159097284078598, 0.158929511904716, 0.158761709928513, 0.158593937754631, 0.158426120877266, 0.158258393406868, 0.158090591430664, 0.157922849059105, 0.157755121588707, 0.157587394118309, 0.15741965174675, 0.157251954078674, 0.157084301114082, 0.156916588544846, 0.156748905777931, 0.156581223011017, 0.156413584947586, 0.15624588727951, 0.156078279018402, 0.155910685658455, 0.155743092298508, 0.155575469136238, 0.155407875776291, 0.155240297317505, 0.15507273375988, 0.154905125498772, 0.15473760664463, 0.154570028185844, 0.154402509331703, 0.154235005378723, 0.154067501425743, 0.153899982571602, 0.153732508420944, 0.153565004467964, 0.153397560119629, 0.15323007106781, 0.153062626719475, 0.152895227074623, 0.152727767825127, 0.152562826871872, 0.152397349476814, 0.152231991291046, 0.152066797018051, 0.151901811361313, 0.151736840605736, 0.15157213807106, 0.151407569646835, 0.151243045926094, 0.151078745722771, 0.150914564728737, 0.15075047314167, 0.15058659017086, 0.150422811508179, 0.150259286165237, 0.150095731019974, 0.149932444095612, 0.149769306182861, 0.149606257677078, 0.149443358182907, 0.149280577898026, 0.149117976427078, 0.148955509066582, 0.148793160915375, 0.148630976676941, 0.148468941450119, 0.148307055234909, 0.148145332932472, 0.14798367023468, 0.147822260856628, 0.147660925984383, 0.147499769926071, 0.14733874797821, 0.147177800536156, 0.147017076611519, 0.146856471896172, 0.146696016192436, 0.146535724401474, 0.146375522017479, 0.146215468645096, 0.146055623888969, 0.145895853638649, 0.145736262202263, 0.145576775074005, 0.145417496562004, 0.145258292555809, 0.145099252462387, 0.144940420985222, 0.144781619310379, 0.144623026251793, 0.144464507699013, 0.144306182861328, 0.1441480666399, 0.143989995121956, 0.143832191824913, 0.143674418330193, 0.143516808748245, 0.14335934817791, 0.143201991915703, 0.143044844269753, 0.142887786030769, 0.142730936408043, 0.14257425069809, 0.142417594790459, 0.142261132597923, 0.142104849219322, 0.141948655247688, 0.141792625188828, 0.141636714339256, 0.141480997204781, 0.141325399279594, 0.141169935464859, 0.141014710068703, 0.140859454870224, 0.140704452991486, 0.140549585223198, 0.140394866466522, 0.140240252017975, 0.140085831284523, 0.139931455254555, 0.139777302742004, 0.139623299241066, 0.139469429850578, 0.139315664768219, 0.139162063598633, 0.139008641242981, 0.138855293393135, 0.138702169060707, 0.138549163937569, 0.138396292924881, 0.138243541121483, 0.138090908527374, 0.137938484549522, 0.13778617978096, 0.13763402402401, 0.13748200237751, 0.137330055236816, 0.137178391218185, 0.13702680170536, 0.136875361204147, 0.136728972196579, 0.136580750346184, 0.136432766914368, 0.136284917593002, 0.136137276887894, 0.135989829897881, 0.135842546820641, 0.135695427656174, 0.135548517107964, 0.135401830077171, 0.135255292057991, 0.135108843445778, 0.134962737560272, 0.134816735982895, 0.134670868515968, 0.13452522456646, 0.134379684925079, 0.134234458208084, 0.134089350700378, 0.133944407105446, 0.133799701929092, 0.133655115962029, 0.133510783314705, 0.133366569876671, 0.133222535252571, 0.133078709244728, 0.132935017347336, 0.132791504263878, 0.132648199796677, 0.132505148649216, 0.132362186908722, 0.132219403982162, 0.132076904177666, 0.131934583187103, 0.131792291998863, 0.131650239229202, 0.131508439779282, 0.131366729736328, 0.131225273013115, 0.131083890795708, 0.130942851305008, 0.130801886320114, 0.130661085247993, 0.130520537495613, 0.130380153656006, 0.130239933729172, 0.130099847912788, 0.129960030317307, 0.129820376634598, 0.129680901765823, 0.129541531205177, 0.129402354359627, 0.1292634755373, 0.129124760627747, 0.128986105322838, 0.128847733139992, 0.128709465265274, 0.128571406006813, 0.128433540463448, 0.128295838832855, 0.128158420324326, 0.128021106123924, 0.127883955836296, 0.127746969461441, 0.127610191702843, 0.127473592758179, 0.127337172627449, 0.127200961112976, 0.127064928412437, 0.126929014921188, 0.12679335474968, 0.126657843589783, 0.126522466540337, 0.126387372612953, 0.126252382993698, 0.126117572188377, 0.125982969999313, 0.125848591327667, 0.125714376568794, 0.125580221414566, 0.125446364283562, 0.125312730669975, 0.125179141759872, 0.125045791268349, 0.124912701547146, 0.124779708683491, 0.124646924436092, 0.124514229595661, 0.124381884932518, 0.124249584972858, 0.124117471277714, 0.123985648155212, 0.123853929340839, 0.123722434043884, 0.123590990900993, 0.123459860682487, 0.123328946530819, 0.123198091983795, 0.123067453503609, 0.122936993837357, 0.122807450592518, 0.122678712010384, 0.122550085186958, 0.122421614825726, 0.122293293476105, 0.122165091335773, 0.122036993503571, 0.121909104287624, 0.121781297028065, 0.121653594076633, 0.121526040136814, 0.121398694813251, 0.121271431446075, 0.121144205331802, 0.12101723998785, 0.120890408754349, 0.120763622224331, 0.120636992156506, 0.120510533452034, 0.120384231209755, 0.120257973670959, 0.120131850242615, 0.120005913078785, 0.119880169630051, 0.119754411280155, 0.11962890625, 0.119503431022167, 0.119378201663494, 0.119253039360046, 0.119128026068211, 0.119003094732761, 0.118878364562988, 0.118753679096699, 0.118629179894924, 0.118504866957664, 0.118380583822727, 0.118256509304047, 0.118132561445236, 0.118008673191071, 0.117884956300259, 0.117761373519897, 0.117637999355793, 0.11751464754343, 0.117391526699066, 0.117268465459347, 0.117145553231239, 0.117022708058357, 0.116900108754635, 0.116777569055557, 0.116655215620995, 0.116532921791077, 0.116410873830318, 0.11628881841898, 0.116167008876801, 0.116045236587524, 0.115923643112183, 0.115802206099033, 0.115680888295174, 0.115559667348862, 0.115438655018806, 0.115317665040493, 0.1151969358325, 0.115076199173927, 0.114955686032772, 0.114835284650326, 0.114715032279491, 0.114594906568527, 0.11447487026453, 0.114354990422726, 0.114235267043114, 0.114115625619888, 0.113996215164661, 0.113876819610596, 0.11375767737627, 0.113638535141945, 0.113519594073296, 0.113400749862194, 0.113282099366188, 0.113163590431213, 0.113045156002045, 0.112926803529263, 0.112808719277382, 0.112690716981888, 0.112572759389877, 0.112454950809479, 0.112337402999401, 0.112219907343388, 0.112102538347244, 0.111985340714455, 0.111868217587471, 0.111751273274422, 0.111634410917759, 0.11151771992445, 0.111401103436947, 0.111284755170345, 0.11116835474968, 0.111052259802818, 0.110936172306538, 0.110820330679417, 0.110704481601715, 0.110579043626785, 0.110462568700314, 0.110346235334873, 0.110229924321175, 0.110113680362701, 0.109997555613518, 0.109881497919559, 0.109765470027924, 0.109649568796158, 0.109533675014973, 0.109417945146561, 0.109302163124084, 0.109186492860317, 0.109070956707001, 0.108955465257168, 0.108840085566044, 0.108724743127823, 0.108609415590763, 0.108494184911251, 0.108379073441029, 0.108263991773129, 0.108148992061615, 0.108034111559391, 0.107919245958328, 0.107804484665394, 0.107689768075943, 0.107575140893459, 0.107460603117943, 0.107346124947071, 0.107231736183167, 0.107117421925068, 0.107003130018711, 0.10688891261816, 0.106774806976318, 0.106660768389702, 0.106546819210052, 0.106432907283306, 0.106319054961205, 0.106205277144909, 0.10609158873558, 0.105977982282639, 0.105864472687244, 0.105751022696495, 0.105637587606907, 0.105524323880672, 0.105411075055599, 0.105297848582268, 0.105184718966484, 0.105071760714054, 0.104958787560463, 0.10484591126442, 0.10473307967186, 0.104620367288589, 0.10450766980648, 0.104395039379597, 0.104282543063164, 0.104170143604279, 0.104057744145393, 0.103945426642895, 0.103833183646202, 0.103721059858799, 0.103608958423138, 0.103496931493282, 0.103384964168072, 0.103273086249828, 0.103161334991455, 0.103049576282501, 0.102937921881676, 0.102826356887817, 0.102714888751507, 0.102603450417519, 0.102492064237595, 0.102380752563477, 0.10226958245039, 0.102158382534981, 0.102047376334667, 0.101936355233192, 0.101825438439846, 0.101714581251144, 0.10160381346941, 0.101493030786514, 0.101382449269295, 0.101271882653236, 0.101161368191242, 0.101050995290279, 0.10094065964222, 0.100830376148224, 0.100720159709454, 0.100609995424747, 0.100499957799911, 0.100390017032623, 0.100280083715916, 0.100170269608498, 0.100060470402241, 0.0999508053064346, 0.0998411774635315, 0.0997316241264343, 0.0996221378445625, 0.0995127409696579, 0.0994034335017204, 0.0992962270975113, 0.0991857871413231, 0.0990754291415215, 0.0989651009440422, 0.0988548770546913, 0.098744697868824, 0.0986345559358597, 0.0985244661569595, 0.0984144136309624, 0.09830442070961, 0.0981945395469666, 0.0980846658349037, 0.0979748517274857, 0.0978650897741318, 0.0977553874254227, 0.0976457074284554, 0.0975361317396164, 0.0974265933036804, 0.0973170921206474, 0.0972076654434204, 0.0970982909202576, 0.0969889238476753, 0.0968796983361244, 0.0967704877257347, 0.0966613218188286, 0.096552200615406, 0.0964431613683701, 0.09633419662714, 0.0962252616882324, 0.0961163341999054, 0.0960074961185455, 0.0958987474441528, 0.0957900136709213, 0.0956813767552376, 0.0955727323889732, 0.0954641997814178, 0.0953556671738625, 0.0952472016215324, 0.095138818025589, 0.0950305163860321, 0.0949222221970558, 0.0948139801621437, 0.0947057604789734, 0.0945976302027702, 0.0944896265864372, 0.0943816155195236, 0.0942736342549324, 0.0941657274961472, 0.0940578877925873, 0.093950055539608, 0.0938423424959183, 0.0937346294522285, 0.0936270132660866, 0.09351946413517, 0.0934119075536728, 0.0933044627308846, 0.0931970402598381, 0.0930896922945976, 0.0929823666810989, 0.0928751453757286, 0.0927679836750031, 0.0926608219742775, 0.0925537273287773, 0.0924466699361801, 0.0923397392034531, 0.0922327786684036, 0.0921259224414825, 0.0920191258192062, 0.0919123813509941, 0.0918056666851044, 0.0916989967226982, 0.0915923938155174, 0.0914858430624008, 0.0913794189691544, 0.0912729948759079, 0.0911665931344032, 0.0910602584481239, 0.0909540131688118, 0.0908477976918221, 0.0907416418194771, 0.0906355455517769, 0.0905294939875603, 0.0904234945774078, 0.0903175845742226, 0.0902116671204567, 0.0901058465242386, 0.0900000780820847, 0.0898943394422531, 0.0897886604070663, 0.0896831005811691, 0.0895775333046913, 0.0894720107316971, 0.0893665328621864, 0.0892611667513847, 0.089155837893486, 0.0890505686402321, 0.0889453440904617, 0.088840126991272, 0.0887350216507912, 0.0886299461126328, 0.0885173752903938, 0.0884119942784309, 0.0883066654205322, 0.0882013887166977, 0.0880961865186691, 0.0879910066723824, 0.0878860056400299, 0.0877810046076775, 0.0876760929822922, 0.0875712111592293, 0.0874664857983589, 0.0873618051409721, 0.0872571244835854, 0.0871525555849075, 0.0870480537414551, 0.086943656206131, 0.0868392884731293, 0.0867350175976753, 0.0866307988762856, 0.0865266546607018, 0.0864225476980209, 0.0863185375928879, 0.0862145870923996, 0.0861107856035233, 0.0860070064663887, 0.0859032198786736, 0.0857995897531509, 0.0856959894299507, 0.0855925157666206, 0.0854891017079353, 0.0853856727480888, 0.0852824300527573, 0.0851791203022003, 0.0850759595632553, 0.0849728733301163, 0.0848698765039444, 0.0847669169306755, 0.0846640393137932, 0.0845612213015556, 0.084458515048027, 0.0843558236956596, 0.0842532068490982, 0.0841506794095039, 0.0840482264757156, 0.0839458703994751, 0.0838435366749763, 0.0837412551045418, 0.0836390852928162, 0.0835369750857353, 0.0834349244832993, 0.0833329483866692, 0.0832310765981674, 0.0831292346119881, 0.0830274522304535, 0.0829257592558861, 0.082824133336544, 0.0827226340770721, 0.0826211273670197, 0.0825197324156761, 0.082418367266655, 0.0823170766234398, 0.0822159349918365, 0.0821147710084915, 0.0820137411355972, 0.0819127261638641, 0.0818117931485176, 0.0817109793424606, 0.0816102102398872, 0.0815094858407974, 0.081408865749836, 0.0813082978129387, 0.0812077820301056, 0.0811073407530785, 0.0810070112347603, 0.0809067487716675, 0.0808064863085747, 0.0807063579559326, 0.0806062892079353, 0.0805063024163246, 0.0804063603281975, 0.0803064629435539, 0.0802066549658775, 0.0801069512963295, 0.0800072774291039, 0.0799076855182648, 0.0798082053661346, 0.0797087699174881, 0.0796093717217445, 0.0795100703835487, 0.0794108510017395, 0.0793116688728333, 0.0792126059532166, 0.079113557934761, 0.0790145844221115, 0.0789157301187515, 0.0788168907165527, 0.0787181705236435, 0.0786194801330566, 0.078520879149437, 0.078422337770462, 0.0783400312066078, 0.078241653740406, 0.0781435072422028, 0.0780453309416771, 0.0779472887516022, 0.0778493583202362, 0.0777515545487404, 0.0776537209749222, 0.0775561556220055, 0.077458530664444, 0.0773611217737198, 0.077263779938221, 0.0771664306521416, 0.0770692378282547, 0.0769721642136574, 0.0768751502037048, 0.0767782628536224, 0.0766814053058624, 0.0765847340226173, 0.0764880925416946, 0.0763916075229645, 0.0762952044606209, 0.0761988610029221, 0.0761025846004486, 0.0760064050555229, 0.0759103745222092, 0.0758143961429596, 0.0757185518741608, 0.0756227299571037, 0.0755270346999168, 0.0754314288496971, 0.0753359794616699, 0.0752405300736427, 0.0751453265547752, 0.0750500857830048, 0.0749549716711044, 0.0748599171638489, 0.0747649818658829, 0.0746701434254646, 0.0745754539966583, 0.0744807720184326, 0.0743862390518188, 0.0742917060852051, 0.0741973519325256, 0.0741031244397163, 0.0740089565515518, 0.0739148482680321, 0.0738209262490273, 0.0737270042300224, 0.0736331716179848, 0.0735394656658173, 0.0734458118677139, 0.0733523219823837, 0.0732588917016983, 0.07316555082798, 0.0730723291635513, 0.0729792043566704, 0.0728860720992088, 0.07279322296381, 0.0727003067731857, 0.0726075768470764, 0.0725148767232895, 0.0724222958087921, 0.0723297819495201, 0.072237454354763, 0.0721451193094254, 0.0720529034733772, 0.0719607919454575, 0.0718687921762466, 0.0717768892645836, 0.0716850757598877, 0.071593351662159, 0.0715017542243004, 0.0714101567864418, 0.0713187083601952, 0.0712273567914963, 0.0711360946297646, 0.0710448920726776, 0.0709538161754608, 0.0708628296852112, 0.0707719326019287, 0.0706811845302582, 0.0705904439091682, 0.0704998821020126, 0.070409320294857, 0.0703189447522163, 0.070228636264801, 0.0701383799314499, 0.0700482428073883, 0.0699582397937775, 0.0698682889342308, 0.0697784051299095, 0.0696886405348778, 0.0695989951491356, 0.0695094093680382, 0.0694198906421661, 0.069330558180809, 0.0692413449287415, 0.0691520944237709, 0.0690630078315735, 0.0689717084169388, 0.0688832923769951, 0.0687949061393738, 0.068706639111042, 0.0686184912919998, 0.068530447781086, 0.0684425085783005, 0.0683547034859657, 0.0682670176029205, 0.0681793615221977, 0.0680919513106346, 0.0680045112967491, 0.0679172202944756, 0.0678300261497498, 0.0677429810166359, 0.0676560252904892, 0.0675692036747932, 0.0674824044108391, 0.0673957839608192, 0.0673092976212502, 0.0672228038311005, 0.0671366155147552, 0.06705042719841, 0.0669643580913544, 0.0668782964348793, 0.0667924731969833, 0.0667067170143127, 0.0666210427880287, 0.066535472869873, 0.0664500147104263, 0.066364660859108, 0.066279448568821, 0.0661943927407265, 0.0661093965172768, 0.0660244897007942, 0.0659397095441818, 0.0658550560474396, 0.0657704547047615, 0.0656859800219536, 0.0656016618013382, 0.0655173659324646, 0.0654332563281059, 0.065349206328392, 0.0652653425931931, 0.0651814863085747, 0.0650977715849876, 0.0650142133235931, 0.0649307444691658, 0.0648473650217056, 0.0647640600800514, 0.0646809265017509, 0.0645978003740311, 0.0645149424672127, 0.0644320622086525, 0.064349353313446, 0.0642666816711426, 0.0641842558979988, 0.0641017705202103, 0.0640194937586784, 0.0639373436570168, 0.0638552829623222, 0.0637732818722725, 0.0636914074420929, 0.0636097118258476, 0.063528023660183, 0.0634465143084526, 0.0633650347590446, 0.063283734023571, 0.0632025301456451, 0.063121385872364, 0.0630404651165009, 0.0629595592617989, 0.0628788471221924, 0.0627980977296829, 0.0627176016569138, 0.0626370683312416, 0.0625568181276321, 0.0624765269458294, 0.0623963959515095, 0.0623163841664791, 0.0622364357113838, 0.0621566660702229, 0.062076959758997, 0.0619973763823509, 0.0619179457426071, 0.0618386045098305, 0.0617592968046665, 0.0616801716387272, 0.0616011396050453, 0.0615221969783306, 0.0614433474838734, 0.0613645911216736, 0.0612860471010208, 0.0612075328826904, 0.0611291415989399, 0.0610508099198341, 0.0609727278351784, 0.0608946420252323, 0.0608166195452213, 0.0607388056814671, 0.0606458634138107, 0.0605687536299229, 0.0604916214942932, 0.06041469424963, 0.0603378042578697, 0.060261033475399, 0.0601843856275082, 0.0601078867912292, 0.060031421482563, 0.0599549859762192, 0.0598788559436798, 0.0598026961088181, 0.0597266331315041, 0.0596507154405117, 0.0595749877393246, 0.0594992227852345, 0.0594236180186272, 0.0593481287360191, 0.0592726692557335, 0.0591974295675755, 0.0591222196817398, 0.0590471886098385, 0.0589721612632275, 0.0588973499834538, 0.05882253870368, 0.058747872710228, 0.0586733371019363, 0.0585989207029343, 0.0585245303809643, 0.0584502667188644, 0.0583761893212795, 0.0583021119236946, 0.0582282394170761, 0.0581543445587158, 0.0580807216465473, 0.0580070689320564, 0.0579335726797581, 0.0578601658344269, 0.0577867813408375, 0.0577136836946011, 0.0576405860483646, 0.0575676076114178, 0.0574947148561478, 0.057422012090683, 0.0573492497205734, 0.0572767555713654, 0.0572042912244797, 0.0571320205926895, 0.057059682905674, 0.0569875277578831, 0.0569155253469944, 0.0568435601890087, 0.0567717663943768, 0.0567000135779381, 0.056628406047821, 0.0565569587051868, 0.0564855672419071, 0.0564142391085625, 0.0563429407775402, 0.0562719441950321, 0.0562009550631046, 0.0561300851404667, 0.0560592748224735, 0.055988647043705, 0.055918026715517, 0.0558476410806179, 0.055777296423912, 0.0557070337235928, 0.0556368716061115, 0.0555667951703072, 0.0554969310760498, 0.055427011102438, 0.0553573593497276, 0.0552877150475979, 0.0552182197570801, 0.055148757994175, 0.0550795756280422, 0.055010262876749, 0.0549411587417126, 0.0548722185194492, 0.0548032782971859, 0.0547345764935017, 0.054665844887495, 0.054597333073616, 0.0545288138091564, 0.0544605441391468, 0.0543922744691372, 0.0543240606784821, 0.0542560368776321, 0.0541880987584591, 0.0541202574968338, 0.0540525056421757, 0.0539849326014519, 0.0539174042642117, 0.0538499839603901, 0.0537826903164387, 0.0537155568599701, 0.0536483824253082, 0.0535813942551613, 0.0535145625472069, 0.0534604452550411, 0.0533941015601158, 0.0533277280628681, 0.0532614700496197, 0.0531953126192093, 0.0531292706727982, 0.0530632920563221, 0.0529973730444908, 0.052931547164917, 0.052865844219923, 0.0528001710772514, 0.0527346506714821, 0.0526691973209381, 0.0526037700474262, 0.0525384917855263, 0.0524733401834965, 0.0524082183837891, 0.0523431561887264, 0.0522782169282436, 0.052213404327631, 0.0521485880017281, 0.0520839244127274, 0.0520193837583065, 0.0519547797739506, 0.0518903881311417, 0.0518260672688484, 0.0517618246376514, 0.0516976825892925, 0.0516336001455784, 0.0515696406364441, 0.0515057407319546, 0.0514419302344322, 0.0513782165944576, 0.0513145066797733, 0.0512510314583778, 0.0511875934898853, 0.0511241517961025, 0.0510608926415443, 0.0509976670145988, 0.0509345605969429, 0.0508715808391571, 0.0508086308836937, 0.0507457666099072, 0.0506829954683781, 0.0506203547120094, 0.0505577698349953, 0.0504952482879162, 0.0504328496754169, 0.0503705367445946, 0.0503082238137722, 0.0502461045980453, 0.0501840673387051, 0.0501221530139446, 0.0500601530075073, 0.0499983914196491, 0.0499366968870163, 0.0498750545084476, 0.0498135127127171, 0.0497520603239536, 0.0496906340122223, 0.0496293976902962, 0.0495681874454021, 0.049507137387991, 0.0494460761547089, 0.0493851490318775, 0.0493243038654327, 0.0492635183036327, 0.0492028631269932, 0.0491423234343529, 0.0490817278623581, 0.0490213483572006, 0.0489610247313976, 0.0489007942378521, 0.0488406866788864, 0.0487805791199207, 0.0487206242978573, 0.0486607290804386, 0.0486009828746319, 0.0485412776470184, 0.0484815314412117, 0.0484220683574677, 0.0483626313507557, 0.048303198069334, 0.0482439436018467, 0.0481847897171974, 0.0481256879866123, 0.0480666495859623, 0.0480077676475048, 0.0479489415884018, 0.0478901192545891, 0.0478314757347107, 0.0477729290723801, 0.0477143786847591, 0.0476560145616531, 0.0475976802408695, 0.0475394390523434, 0.0474812872707844, 0.0474232584238052, 0.0473652556538582, 0.0473073534667492, 0.0472429618239403, 0.0471852235496044, 0.0471275188028812, 0.0470698848366737, 0.0470122955739498, 0.0469548217952251, 0.0468973740935326, 0.0468400306999683, 0.0467827059328556, 0.0467254556715488, 0.0466682650148869, 0.0466111414134502, 0.0465540885925293, 0.0464970953762531, 0.0464402176439762, 0.046383336186409, 0.0463265404105186, 0.0462697967886925, 0.0462131649255753, 0.0461565405130386, 0.0460999608039856, 0.0460435226559639, 0.0459871292114258, 0.0459307841956615, 0.0458745285868645, 0.0458182990550995, 0.0457621812820435, 0.0457060486078262, 0.0456500686705112, 0.0455940403044224, 0.0455381982028484, 0.0454823710024357, 0.045426607131958, 0.0453708879649639, 0.0453152991831303, 0.0452597178518772, 0.0452042296528816, 0.0451487526297569, 0.0450934134423733, 0.0450380556285381, 0.0449828095734119, 0.0449276082217693, 0.0448725000023842, 0.0448174551129341, 0.0447624810039997, 0.0447075255215168, 0.0446527227759361, 0.0445978865027428, 0.0445431433618069, 0.0444884486496449, 0.0444338731467724, 0.0443793348968029, 0.0443248972296715, 0.0442704595625401, 0.0442161113023758, 0.044161856174469, 0.0441076382994652, 0.044053491204977, 0.0439993739128113, 0.0439453832805157, 0.0438913851976395, 0.0438374727964401, 0.04378367587924, 0.0437299124896526, 0.0436762124300003, 0.0436225868761539, 0.0435689873993397, 0.0435154549777508, 0.0434620380401611, 0.0434086732566357, 0.0433553382754326, 0.0433020628988743, 0.0432489439845085, 0.0431958474218845, 0.0431427583098412, 0.043089747428894, 0.0430368222296238, 0.042983990162611, 0.0429311282932758, 0.0428784340620041, 0.0428257696330547, 0.0427731685340405, 0.0427206233143806, 0.0426681600511074, 0.0426157265901566, 0.0425634197890759, 0.0425111055374146, 0.0424588732421398, 0.0424066931009293, 0.0423546247184277, 0.042302593588829, 0.0422506481409073, 0.0421987436711788, 0.0421469584107399, 0.0420951507985592, 0.0420434921979904, 0.0419917926192284, 0.0419402308762074, 0.0418887138366699, 0.0418372787535191, 0.0417910143733025, 0.0417394265532494, 0.0416878722608089, 0.0416363552212715, 0.0415849052369595, 0.0415335074067116, 0.0414821282029152, 0.0414308123290539, 0.0413795374333858, 0.0413283258676529, 0.0412771627306938, 0.0412259995937347, 0.0411749444901943, 0.041123915463686, 0.0410729311406612, 0.0410219803452492, 0.0409710928797722, 0.0409202761948109, 0.0408694744110107, 0.0408187247812748, 0.0407680496573448, 0.0407174006104469, 0.0406668186187744, 0.0406162813305855, 0.0405657552182674, 0.0405152663588524, 0.0404648669064045, 0.0404144935309887, 0.0403641723096371, 0.0403139032423496, 0.040263719856739, 0.0402135625481606, 0.0401634350419044, 0.0401133559644222, 0.040063351392746, 0.04001335054636, 0.03996342420578, 0.0399135425686836, 0.0398637242615223, 0.0398139469325542, 0.039764191955328, 0.0397144630551338, 0.039664838463068, 0.0396152660250664, 0.0395656749606133, 0.0395161733031273, 0.0394667387008667, 0.0394173637032509, 0.0393679961562157, 0.0393186844885349, 0.0392694175243378, 0.0392202213406563, 0.0391710549592972, 0.0391219556331635, 0.0390728376805782, 0.0390238165855408, 0.0389748476445675, 0.0389259047806263, 0.0388770177960396, 0.0388282015919685, 0.038779441267252, 0.0387307032942772, 0.0386819988489151, 0.0386333726346493, 0.0385847724974155, 0.038536224514246, 0.0384877361357212, 0.0384392887353897, 0.0383909046649933, 0.0383425541222095, 0.038294218480587, 0.0382459387183189, 0.0381977558135986, 0.0381495729088783, 0.0381014496088028, 0.038053385913372, 0.0380054041743279, 0.0379574187099934, 0.0379095077514648, 0.0378616116940975, 0.037813812494278, 0.0377660244703293, 0.0377182848751545, 0.037670586258173, 0.0376229397952557, 0.037575364112854, 0.0375278107821941, 0.0374803245067596, 0.0374328792095184, 0.0373855046927929, 0.0373381450772285, 0.0372908487915993, 0.0372435823082924, 0.0371963754296303, 0.0371492132544518, 0.0371021144092083, 0.0370550602674484, 0.0370080582797527, 0.0369610786437988, 0.03691416233778, 0.0368745401501656, 0.0368275009095669, 0.0367805249989033, 0.0367335192859173, 0.0366866029798985, 0.0366397500038147, 0.036592923104763, 0.0365461148321629, 0.0364993549883366, 0.0364526361227036, 0.0364059656858444, 0.0363593399524689, 0.036312747746706, 0.0362661816179752, 0.0362196788191795, 0.0361731760203838, 0.0361267663538456, 0.0360803864896297, 0.0360340364277363, 0.035987701267004, 0.035941444337368, 0.0358952172100544, 0.0358490347862244, 0.0358028821647167, 0.0357568077743053, 0.0357107184827328, 0.0356647334992886, 0.0356187373399734, 0.0355728007853031, 0.035526879131794, 0.0354810319840908, 0.0354352034628391, 0.0353894345462322, 0.0353436507284641, 0.0352980047464371, 0.0352523252367973, 0.0352067239582539, 0.0351611375808716, 0.0351156145334244, 0.0350701063871384, 0.0350246913731098, 0.0349792577326298, 0.0349339134991169, 0.0348885729908943, 0.0348432809114456, 0.0347980000078678, 0.0347528383135796, 0.0347076542675495, 0.0346625298261642, 0.0346174016594887, 0.034572396427393, 0.0345273911952972, 0.0344824455678463, 0.0344374887645245, 0.034392636269331, 0.0343477837741375, 0.0343030095100403, 0.0342582203447819, 0.0342135205864906, 0.0341688208281994, 0.0341241508722305, 0.0340795777738094, 0.0340350456535816, 0.0339905470609665, 0.0339460298418999, 0.033901609480381, 0.0338572449982166, 0.0338128805160522, 0.0337685793638229, 0.0337243117392063, 0.0336800403892994, 0.0336359068751335, 0.0335917398333549, 0.0335475914180279, 0.0335035361349583, 0.0334595404565334, 0.0334155596792698, 0.0333716087043285, 0.033327691257, 0.0332838334143162, 0.0332400053739548, 0.0331962406635284, 0.0331525206565857, 0.0331088118255138, 0.0330651551485062, 0.033021554350853, 0.0329779721796513, 0.0329344496130943, 0.0328909121453762, 0.0328474827110767, 0.0328040532767773, 0.0327606983482838, 0.0327173620462418, 0.0326740704476833, 0.0326308235526085, 0.0325876213610172, 0.0325444377958775, 0.0325013287365437, 0.032458234578371, 0.0324152000248432, 0.0323612540960312, 0.0323183424770832, 0.0322754457592964, 0.0322326123714447, 0.0321898125112057, 0.0321470685303211, 0.0321043282747269, 0.0320616476237774, 0.0320189967751503, 0.0319763906300068, 0.0319337695837021, 0.0318912900984287, 0.0318487323820591, 0.031806293874979, 0.0317638255655766, 0.0317214503884315, 0.0316790789365768, 0.0316367782652378, 0.0315944813191891, 0.0315522253513336, 0.0315100364387035, 0.0314678736031055, 0.0314256958663464, 0.0313836112618446, 0.0313415452837944, 0.0312995500862598, 0.0312575101852417, 0.0312155950814486, 0.0311736315488815, 0.0311318077147007, 0.0310899503529072, 0.0310481246560812, 0.0310063473880291, 0.0309646315872669, 0.0309229269623756, 0.0308812856674194, 0.0308396443724632, 0.030798077583313, 0.0307565126568079, 0.0307150576263666, 0.0306735374033451, 0.0306320767849684, 0.0305907428264618, 0.0305493306368589, 0.0305079948157072, 0.030466765165329, 0.0304254926741123, 0.0303842313587666, 0.0303430967032909, 0.0303019434213638, 0.0302608367055655, 0.0302197597920895, 0.0301787294447422, 0.0301377158612013, 0.03009676001966, 0.0300558377057314, 0.0300149768590927, 0.029974116012454, 0.0299332998692989, 0.0298925284296274, 0.0298518035560846, 0.0298110973089933, 0.0297704488039017, 0.0297297835350037, 0.0296892430633307, 0.0296486578881741, 0.0296081621199846, 0.0295676831156015, 0.029527248814702, 0.0294868294149637, 0.0294464584439993, 0.0294061154127121, 0.029365848749876, 0.0293255839496851, 0.0292853489518166, 0.0292451605200768, 0.0292050484567881, 0.0291649047285318, 0.0291248671710491, 0.029084799811244, 0.0290448255836964, 0.0290048196911812, 0.0289649367332458, 0.0289249923080206, 0.0288851838558912, 0.0288453754037619, 0.028805585578084, 0.0287658553570509, 0.0287261698395014, 0.0286864712834358, 0.0286468472331762, 0.0286072380840778, 0.0285677220672369, 0.0285281743854284, 0.0284887179732323, 0.0284492317587137, 0.0284098535776138, 0.0283704902976751, 0.0283311270177364, 0.0282917935401201, 0.0282536372542381, 0.0282145924866199, 0.0281755682080984, 0.0281366165727377, 0.028097664937377, 0.0280587300658226, 0.0280198715627193, 0.0279809944331646, 0.0279421359300613, 0.0279033686965704, 0.0278645865619183, 0.0278258193284273, 0.0277871116995811, 0.0277484059333801, 0.0277097448706627, 0.027671130374074, 0.0276324842125177, 0.0275939181447029, 0.0275553781539202, 0.0275168251246214, 0.0274783167988062, 0.0274398699402809, 0.0274013932794333, 0.0273629482835531, 0.0273245759308338, 0.0272862371057272, 0.0272478815168142, 0.0272095743566751, 0.0271712951362133, 0.0271330326795578, 0.0270948465913534, 0.0270565990358591, 0.0270184278488159, 0.02698028460145, 0.0269422046840191, 0.0269040800631046, 0.0268660616129637, 0.0268279947340488, 0.0267899949103594, 0.0267520342022181, 0.0267140474170446, 0.0266761220991611, 0.0266382414847612, 0.0266003888100386, 0.0265625566244125, 0.0265247374773026, 0.0264869797974825, 0.0264492034912109, 0.0264114923775196, 0.0263737626373768, 0.0263361111283302, 0.0262984447181225, 0.0262608230113983, 0.0262232329696417, 0.0261856727302074, 0.0261481590569019, 0.0261106286197901, 0.0260731764137745, 0.0260357093065977, 0.0259982999414206, 0.0259608495980501, 0.0259235184639692, 0.025886157527566, 0.0258488561958075, 0.0258115716278553, 0.0257743038237095, 0.0257370620965958, 0.0256998855620623, 0.0256627071648836, 0.0256255306303501, 0.0255884453654289, 0.0255513284355402, 0.0255142711102962, 0.0254772491753101, 0.0254402216523886, 0.025403244420886, 0.0253662969917059, 0.0253293626010418, 0.0252924300730228, 0.0252555869519711, 0.0252187456935644, 0.025181919336319, 0.0251451544463634, 0.0251083746552467, 0.0250716414302588, 0.025034936144948, 0.0249982625246048, 0.0249615907669067, 0.0249250084161758, 0.0248883981257677, 0.0248518157750368, 0.0248152799904346, 0.0247787889093161, 0.0247422847896814, 0.0247058551758528, 0.0246693976223469, 0.0246330145746469, 0.0245966631919146, 0.0245602782815695, 0.0245239268988371, 0.0244941767305136, 0.0244579631835222, 0.0244217626750469, 0.0243855584412813, 0.0243493653833866, 0.0243132039904594, 0.0242770425975323, 0.0242408961057663, 0.0242047738283873, 0.02416867390275, 0.0241325423121452, 0.0240964666008949, 0.0240603815764189, 0.0240243338048458, 0.0239882804453373, 0.0239522401243448, 0.0239162016659975, 0.0238801948726177, 0.0238441862165928, 0.023808216676116, 0.0237722303718328, 0.0237362831830978, 0.0237003285437822, 0.0236643962562084, 0.0236284881830215, 0.0235925782471895, 0.0235566850751638, 0.0235208068042994, 0.0234849285334349, 0.0234490856528282, 0.0234132464975119, 0.0233774166554213, 0.0233416073024273, 0.0233058109879494, 0.0232700314372778, 0.0232342518866062, 0.023198464885354, 0.02316271699965, 0.0231270063668489, 0.0230912752449512, 0.0230555646121502, 0.0230198688805103, 0.0229841899126768, 0.0229485183954239, 0.022912846878171, 0.0228772256523371, 0.0228416081517935, 0.0228059832006693, 0.0227703712880611, 0.0227347742766142, 0.0226992107927799, 0.0226636547595263, 0.0226280968636274, 0.0225925538688898, 0.0225570499897003, 0.0225214995443821, 0.0224860180169344, 0.0224505309015512, 0.0224150661379099, 0.022379606962204, 0.0223441645503044, 0.022308737039566, 0.0222733020782471, 0.0222379118204117, 0.0222025252878666, 0.0221671480685472, 0.0221317671239376, 0.0220964234322309, 0.0220610871911049, 0.0220257602632046, 0.0219904333353043, 0.0219551660120487, 0.0219198688864708, 0.0218845941126347, 0.0218493193387985, 0.0218140669167042, 0.021778829395771, 0.0217436235398054, 0.0217084195464849, 0.0216732285916805, 0.0216380376368761, 0.0216028615832329, 0.021567702293396, 0.0215325895696878, 0.0214974582195282, 0.0214623380452394, 0.0214272309094667, 0.0213921349495649, 0.0213570799678564, 0.0213220026344061, 0.0212869588285685, 0.0212519206106663, 0.0212169121950865, 0.021181870251894, 0.0211469009518623, 0.0211118925362825, 0.021076925098896, 0.0210419856011868, 0.0210070256143808, 0.0209721028804779, 0.0209301132708788, 0.0208949707448483, 0.0208598263561726, 0.0208246875554323, 0.0207895506173372, 0.020754424855113, 0.0207192897796631, 0.0206841509789228, 0.0206490345299244, 0.0206139013171196, 0.020578783005476, 0.0205436497926712, 0.0205085389316082, 0.0204734243452549, 0.0204383078962564, 0.0204031895846128, 0.0203680749982595, 0.0203329790383577, 0.0202978700399399, 0.0202627554535866, 0.0202276576310396, 0.0201925616711378, 0.0201574712991714, 0.0201223604381084, 0.0200872700661421, 0.0200521852821112, 0.0200170893222094, 0.0199820101261139, 0.0199469216167927, 0.0199118573218584, 0.0198767632246017, 0.0198416840285063, 0.0198066085577011, 0.0197715442627668, 0.0197364687919617, 0.0197014007717371, 0.0196663271635771, 0.0196312703192234, 0.0195962116122246, 0.0195611454546452, 0.0195260886102915, 0.0194910261780024, 0.0194559786468744, 0.0194209292531013, 0.019385876134038, 0.0193508192896843, 0.0193157866597176, 0.0192807447165251, 0.0192457027733326, 0.0192106571048498, 0.0191756282001734, 0.0191405899822712, 0.0191055610775948, 0.0190705265849829, 0.0190355032682419, 0.019000481814146, 0.0189654566347599, 0.0189304333180189, 0.0188954174518585, 0.0188604071736336, 0.0188253857195377, 0.0187903698533773, 0.0187553707510233, 0.0187203623354435, 0.0186853483319283, 0.0186503492295742, 0.0186153464019299, 0.0185803584754467, 0.0185453463345766, 0.0185103584080935, 0.0184753630310297, 0.0184403713792562, 0.0184053834527731, 0.0183704029768705, 0.0183354187756777, 0.0183004420250654, 0.0182654578238726, 0.01823047734797, 0.0181955005973577, 0.0181605294346809, 0.0181255675852299, 0.0180905982851982, 0.0180556252598763, 0.0180206652730703, 0.0179857034236193, 0.0179507452994585, 0.0179157815873623, 0.0178808346390724, 0.017845880240202, 0.0178109314292669, 0.0177759770303965, 0.0177410300821066, 0.0177060961723328, 0.0176711492240429, 0.0176362060010433, 0.017601266503334, 0.0175663474947214, 0.017531406134367, 0.017496470361948, 0.0174615364521742, 0.0174269732087851, 0.0173916723579168, 0.0173563715070486, 0.0173210743814707, 0.0172857847064734, 0.0172505024820566, 0.0172152128070593, 0.0171799287199974, 0.0171446539461613, 0.0171093791723251, 0.0170741062611341, 0.0170388370752335, 0.0170035790652037, 0.0169683191925287, 0.0169330537319183, 0.0168978087604046, 0.0168625582009554, 0.016827305778861, 0.0167920552194118, 0.0167568176984787, 0.0167215745896101, 0.0166863463819027, 0.0166511088609695, 0.0166158732026815, 0.0165806505829096, 0.0165454391390085, 0.0165102165192366, 0.0164749957621098, 0.0164397824555635, 0.0164045840501785, 0.0163693707436323, 0.0163341648876667, 0.0162989757955074, 0.016263784840703, 0.016228586435318, 0.016193388029933, 0.0161582063883543, 0.0161230228841305, 0.0160878468304873, 0.0160526726394892, 0.0160174891352654, 0.0159823298454285, 0.0159471612423658, 0.0159119945019484, 0.0158768258988857, 0.0158416759222746, 0.0158065371215343, 0.0157713759690523, 0.015736224129796, 0.0157010871917009, 0.0156659446656704, 0.0156308133155107, 0.0155956773087382, 0.0155605478212237, 0.0155254257842898, 0.0154902972280979, 0.0154551742598414, 0.0154200689867139, 0.0153849544003606, 0.0153498407453299, 0.0153147336095572, 0.0152796264737844, 0.0152445361018181, 0.0152094382792711, 0.015174332074821, 0.0151392398402095, 0.0151041578501463, 0.015069073997438, 0.0150339901447296, 0.0149989062920213, 0.0149638382717967, 0.0149287702515721, 0.0148936938494444, 0.014858640730381, 0.0148235578089952, 0.0147885205224156, 0.0147534599527717, 0.0147184068337083, 0.0146833611652255, 0.0146483164280653, 0.0146132782101631, 0.0145782399922609, 0.0145431952551007, 0.0145081812515855, 0.0144731365144253, 0.0144381215795875, 0.014403099194169, 0.0143680842593312, 0.0143330693244934, 0.0142980618402362, 0.0142630394548178, 0.0142280478030443, 0.0141930412501097, 0.0141580337658525, 0.014123042114079, 0.0140880355611444, 0.0140530662611127, 0.0140180662274361, 0.0139830838888884, 0.0139481145888567, 0.0139166312292218, 0.0138813108205795, 0.0138459904119372, 0.0138106700032949, 0.0137753877788782, 0.0137401139363647, 0.0137048782780766, 0.013669672422111, 0.0136344358325005, 0.013599275611341, 0.0135641088709235, 0.0135289626196027, 0.0134938266128302, 0.0134587129577994, 0.0134236291050911, 0.0133885452523828, 0.0133535237982869, 0.0133184865117073, 0.0132835023105145, 0.0132484808564186, 0.0132135273888707, 0.0131785664707422, 0.0131436204537749, 0.013108734972775, 0.013073842972517, 0.0130389807745814, 0.0130041120573878, 0.0129692871123552, 0.0129344640299678, 0.0128997089341283, 0.0128649091348052, 0.0128301763907075, 0.0127954073250294, 0.0127607146278024, 0.0127260209992528, 0.0126913348212838, 0.0126566868275404, 0.0126220611855388, 0.0125874523073435, 0.012552841566503, 0.0125182708725333, 0.012483723461628, 0.0124491592869163, 0.0124146724119782, 0.0123801631852984, 0.0123456902801991, 0.0123112332075834, 0.0122767928987741, 0.0122423507273197, 0.012207985855639, 0.0121735967695713, 0.0121392635628581, 0.0121048986911774, 0.012070587836206, 0.0120362918823957, 0.0120019717141986, 0.0119677521288395, 0.0119334859773517, 0.0118992822244763, 0.0118650700896978, 0.0118309110403061, 0.0117967231199145, 0.011762578971684, 0.0117284748703241, 0.0116943614557385, 0.0116602880880237, 0.0116262277588248, 0.0115921990945935, 0.0115581396967173, 0.0115241492167115, 0.0114901755005121, 0.0114562073722482, 0.0114222401753068, 0.011388348415494, 0.0113544035702944, 0.0113205201923847, 0.0112866759300232, 0.0112528000026941, 0.0112190004438162, 0.0111852008849382, 0.0111514171585441, 0.0111176259815693, 0.0110838795080781, 0.011050172150135, 0.0110164182260633, 0.0109827490523458, 0.0109490640461445, 0.0109154488891363, 0.0108817871659994, 0.0108482018113136, 0.0108145941048861, 0.0107810469344258, 0.0107474680989981, 0.0107139674946666, 0.0106804436072707, 0.0106469271704555, 0.0106134871020913, 0.0105799939483404, 0.0105465762317181, 0.0105131603777409, 0.0104786111041903, 0.0104451170191169, 0.0104116844013333, 0.0103782368823886, 0.0103448666632175, 0.0103116165846586, 0.0102783069014549, 0.0102451639249921, 0.0102120079100132, 0.0101788807660341, 0.0101458001881838, 0.010112795047462, 0.010079805739224, 0.0100468788295984, 0.0100139956921339, 0.00998116098344326, 0.00994838494807482, 0.00991563964635134, 0.00988297257572412, 0.00985028874129057, 0.00981766637414694, 0.00978510547429323, 0.00975262094289064, 0.00972013641148806, 0.00968772824853659, 0.00965538062155247, 0.00962306465953588, 0.00959077849984169, 0.00955853890627623, 0.00952637474983931, 0.00949421152472496, 0.00946213956922293, 0.0094300527125597, 0.0093981334939599, 0.00936615373939276, 0.00933426525443792, 0.00930240750312805, 0.00927054975181818, 0.00923881400376558, 0.00920707732439041, 0.00917541887611151, 0.00914382003247738, 0.00911226868629456, 0.00908071640878916, 0.00904925633221865, 0.00901781115680933, 0.00898636598140001, 0.00895504280924797, 0.0089237354695797, 0.0088925352320075, 0.00886131916195154, 0.0088301794603467, 0.00879905559122562, 0.0087679922580719, 0.00873700622469187, 0.00870601925998926, 0.00867514032870531, 0.00864418409764767, 0.00861338153481483, 0.0085825938731432, 0.0085518816486001, 0.00852115545421839, 0.00849056616425514, 0.0084599619731307, 0.00842943415045738, 0.00839892122894526, 0.00836840830743313, 0.00833804812282324, 0.00830762833356857, 0.00827732961624861, 0.00824710726737976, 0.00821690075099468, 0.00818667840212584, 0.00815660879015923, 0.00812647864222527, 0.00809642393141985, 0.00806646235287189, 0.00803649984300137, 0.00800659880042076, 0.00797677412629128, 0.00794699508696795, 0.00791721604764462, 0.0078875133767724, 0.00785779673606157, 0.00782823096960783, 0.00779863586649299, 0.00776913249865174, 0.00773969013243914, 0.00771023193374276, 0.00768083473667502, 0.00765153020620346, 0.00762222521007061, 0.0075929663144052, 0.0075637842528522, 0.00753461616113782, 0.00750557100400329, 0.00747651094570756, 0.00744749559089541, 0.00741852773353457, 0.00738963531330228, 0.00736335664987564, 0.00733486237004399, 0.00730648962780833, 0.00727817881852388, 0.00724989781156182, 0.00722173927351832, 0.00719355046749115, 0.00716551439836621, 0.00713753933086991, 0.0071096564643085, 0.00708180340006948, 0.00705392053350806, 0.00702631240710616, 0.00699861207976937, 0.00697103468701243, 0.00694357883185148, 0.00691618490964174, 0.006888790987432, 0.0068615498021245, 0.006834308616817, 0.00680712796747684, 0.00678000971674919, 0.0067530432716012, 0.0067260772921145, 0.00669926404953003, 0.00667248107492924, 0.00664572976529598, 0.00661906879395247, 0.00659250048920512, 0.00656596245244145, 0.00653948541730642, 0.00651316158473492, 0.00648680748417974, 0.00646060472354293, 0.00643440335988998, 0.00640835473313928, 0.00638230610638857, 0.00635628728196025, 0.0063304528594017, 0.00630461750552058, 0.00627884408459067, 0.00625325366854668, 0.00622769398614764, 0.00620210357010365, 0.00617669709026814, 0.00615119840949774, 0.00612588366493583, 0.00610066018998623, 0.00607546744868159, 0.00605036644265056, 0.00602526497095823, 0.00600037863478065, 0.00597546063363552, 0.005950634367764, 0.00592590076848865, 0.00590110523626208, 0.00587649317458272, 0.00585194211453199, 0.00582751398906112, 0.00580308586359024, 0.00577877927571535, 0.00575450388714671, 0.00573028950020671, 0.00570613611489534, 0.00568210519850254, 0.0056581050157547, 0.00563413510099053, 0.0056103179231286, 0.00558650074526668, 0.0055628065019846, 0.0055392337962985, 0.00551563128829002, 0.00549208931624889, 0.00546870054677129, 0.00544534204527736, 0.00542198354378343, 0.00539874751120806, 0.005375602748245, 0.00535258138552308, 0.00532952789217234, 0.00530662853270769, 0.00528375990688801, 0.00526092108339071, 0.00523823546245694, 0.00521554937586188, 0.00519289448857307, 0.00517042260617018, 0.00514804292470217, 0.00512560131028295, 0.0051033440977335, 0.00508108641952276, 0.00505885854363441, 0.0050367540679872, 0.0050147408619523, 0.00499278865754604, 0.00497086765244603, 0.00494912918657064, 0.00492736091837287, 0.00490562245249748, 0.00488403812050819, 0.00486107775941491, 0.00484019471332431, 0.00481934426352382, 0.00479861488565803, 0.00477788597345352, 0.00475730979815125, 0.00473676435649395, 0.00471634091809392, 0.00469591794535518, 0.00467570824548602, 0.00465543800964952, 0.00463525950908661, 0.00461523327976465, 0.00459523824974895, 0.00457527348771691, 0.00455549219623208, 0.00453571137040854, 0.0045160218141973, 0.00449636252596974, 0.00447688717395067, 0.00445738062262535, 0.0044379667378962, 0.00441870512440801, 0.00439950497820973, 0.00438030436635017, 0.00436122668907046, 0.00434224028140306, 0.0043232231400907, 0.0043044202029705, 0.00428564799949527, 0.00426696753129363, 0.00424825632944703, 0.00422985106706619, 0.00421129306778312, 0.00419291760772467, 0.00417454307898879, 0.00415635155513883, 0.00413812976330519, 0.00412012217566371, 0.00410205265507102, 0.00408410606905818, 0.00406625075265765, 0.00404851837083697, 0.00403072405606508, 0.00401314394548535, 0.00399556383490562, 0.00397810665890574, 0.00396064901724458, 0.00394337484613061, 0.00392606994137168, 0.00390885723754764, 0.00389179703779519, 0.00387479783967137, 0.00385779864154756, 0.00384095264598727, 0.00382416765205562, 0.00380735215730965, 0.0037907506339252, 0.00377417937852442, 0.00375770032405853, 0.00374122080393136, 0.00372492498718202, 0.00370862917043269, 0.00369248632341623, 0.00367637421004474, 0.0036603226326406, 0.00364433275535703, 0.00362849538214505, 0.00361265824176371, 0.00359691283665597, 0.00358122820034623, 0.00356569676660001, 0.00355013483203948, 0.00353472563438118, 0.00351937767118216, 0.00350409047678113, 0.00348883448168635, 0.00347382295876741, 0.00345871923491359, 0.003443707479164, 0.0034288486931473, 0.00341402040794492, 0.00339925312437117, 0.00338451680727303, 0.00336999422870576, 0.00335544091649354, 0.00334110227413476, 0.0033266709651798, 0.00331239332444966, 0.00329808471724391, 0.00328402104787529, 0.00326995668001473, 0.0032559847459197, 0.00324204284697771, 0.00322822364978492, 0.00321446545422077, 0.00320085999555886, 0.00318716326728463, 0.00317364954389632, 0.00316019682213664, 0.00314399297349155, 0.00313090719282627, 0.00311797461472452, 0.00310504203662276, 0.00309220072813332, 0.00307939038611948, 0.00306670251302421, 0.00305407564155757, 0.00304147903807461, 0.00302897440269589, 0.00301656150259078, 0.00300411786884069, 0.00299176620319486, 0.00297953654080629, 0.00296733761206269, 0.00295523041859269, 0.00294318422675133, 0.00293123000301421, 0.00291927554644644, 0.00290744355879724, 0.00289558107033372, 0.00288390158675611, 0.00287219206802547, 0.00286063505336642, 0.00284910900518298, 0.00283770496025681, 0.00282623968087137, 0.0028149273712188, 0.00280358432792127, 0.00279242522083223, 0.00278123491443694, 0.00277022854425013, 0.00275919167324901, 0.00274827633984387, 0.00273736170493066, 0.00272656907327473, 0.00271574617363513, 0.00270507577806711, 0.00269446661695838, 0.00268394942395389, 0.00267343199811876, 0.00266303680837154, 0.00265267235226929, 0.00264233816415071, 0.00263212667778134, 0.00262194569222629, 0.00261185644194484, 0.00260179745964706, 0.00259189167991281, 0.00258198543451726, 0.00257217139005661, 0.00256238784641027, 0.00255266530439258, 0.00254300446249545, 0.00253349542617798, 0.0025239260867238, 0.00251450948417187, 0.00250512338243425, 0.00249585928395391, 0.00248653441667557, 0.00247739278711379, 0.00246825139038265, 0.00245923199690878, 0.00245024333707988, 0.00244131567887962, 0.00243241898715496, 0.00242364429868758, 0.00241493061184883, 0.00240630889311433, 0.00239768717437983, 0.00238912645727396, 0.00238068820908666, 0.00237224972806871, 0.00236393348313868, 0.00235564820468426, 0.00234751566313207, 0.00233932165428996, 0.00233131158165634, 0.00232324004173279, 0.00231532123871148, 0.00230743340216577, 0.00229963706806302, 0.00229190173558891, 0.00228425837121904, 0.00227661500684917, 0.00226909364573658, 0.00226157251745462, 0.00225417385809124, 0.00224680546671152, 0.00223952881060541, 0.0022322831209749, 0.00222515920177102, 0.00221803574822843, 0.00221103429794312, 0.00220406334847212, 0.00219712313264608, 0.00219030515290797, 0.00218357890844345, 0.00217682216316462, 0.0021701876539737, 0.00216393521986902, 0.0021572089754045, 0.00215058983303607, 0.00214398582465947, 0.00213747378438711, 0.00213103787973523, 0.00212461734190583, 0.0021182734053582, 0.00211195996962488, 0.00210572290234268, 0.00209950096905231, 0.0020933251362294, 0.00208724103868008, 0.00208117207512259, 0.00207521021366119, 0.00206927885301411, 0.00206337799318135, 0.00205753860063851, 0.00205174484290183, 0.00204604282043874, 0.00204029493033886, 0.00203470000997186, 0.00202908948995173, 0.00202357117086649, 0.00201814435422421, 0.00201270217075944, 0.00200735172256827, 0.00200203177519143, 0.00199672719463706, 0.00199152971617877, 0.00198636273853481, 0.00198125699535012, 0.00197624275460839, 0.00197121337987483, 0.00196629110723734, 0.00196138396859169, 0.00195647682994604, 0.00195164629258215, 0.00194695312529802, 0.0019422295736149, 0.001937658758834, 0.00193308806046844, 0.00192850187886506, 0.00192408403381705, 0.00191963568795472, 0.00191521772649139, 0.00191090675070882, 0.00190662639215589, 0.00190243788529187, 0.00189829512964934, 0.00189415225759149, 0.00189011648762971, 0.0018860655836761, 0.00188209093175828, 0.00187817751429975, 0.00187430996447802, 0.00187048816587776, 0.00186681933701038, 0.00186308927368373, 0.00185946642886847, 0.00185585860162973, 0.00185234274249524, 0.00184881140012294, 0.00184537179302424, 0.00184196291957051, 0.00183867616578937, 0.00183538952842355, 0.00183219462633133, 0.00182898435741663, 0.00182588107418269, 0.00182277790736407, 0.00181973574217409, 0.00181677006185055, 0.00181389611680061, 0.00181102217175066, 0.0018082553287968, 0.00180547323543578, 0.00180275202728808, 0.0018001685384661, 0.00179749319795519, 0.00179492507595569, 0.00179241807200015, 0.00179001805372536, 0.00178761803545058, 0.00178527913521975, 0.00178298610262573, 0.00178076955489814, 0.00177853752393275, 0.00177641271147877, 0.00177433365024626, 0.00177236157469451, 0.00177034374792129, 0.00176846352405846, 0.00176653743255883, 0.0017647793283686, 0.00176300609018654, 0.00176123285200447, 0.00175962771754712, 0.00175797671545297, 0.00175640219822526, 0.0017561576096341, 0.00175490416586399, 0.00175368099007756, 0.0017525345319882, 0.00175135745666921, 0.0017502874834463, 0.00174921727739275, 0.00174819317180663, 0.00174722995143384, 0.00174628221429884, 0.00174536509439349, 0.00174449372570962, 0.0017436834750697, 0.00174288859125227, 0.00174210895784199, 0.00174142094329, 0.00174071779474616, 0.00174007576424628, 0.00173946423456073, 0.00173891393933445, 0.00173837889451534, 0.0017379050841555, 0.0017374464077875, 0.00173703371547163, 0.00173668202478439, 0.00173631508368999, 0.00173597887624055, 0.00173574953805655, 0.00173550483305007, 0.00173535209614784, 0.0017351838760078, 0.00173506152350456, 0.00173496990464628, 0.00173498515505344, 0.00173496990464628, 0.0017350158886984, 0.00173509225714952, 0.00173519924283028, 0.00173535209614784, 0.00173553556669503, 0.00173578015528619, 0.00173603999428451, 0.00173629983328283, 0.00173669727519155, 0.00173704896587878, 0.00173747690860182, 0.00173795083537698, 0.00173840951174498, 0.00173897517379373, 0.00173952535260469, 0.00174012163188308, 0.00174079416319728, 0.00174148217774928, 0.00174218532629311, 0.00174293434247375, 0.00174375984352082, 0.00174461607821286, 0.00174545671325177, 0.00174637394957244, 0.00174732168670744, 0.00174830004107207, 0.00174930901266634, 0.00175039435271174, 0.00175149517599493, 0.00175258051604033, 0.0017538033425808, 0.00175496516749263, 0.00175627984572202, 0.00175756402313709, 0.00175889395177364, 0.00176026986446232, 0.00176164542790502, 0.0017630672082305, 0.00176456547342241, 0.00176607887260616, 0.00176765327341855, 0.0017692125402391, 0.00177084817551076, 0.00177251454442739, 0.00177424191497266, 0.00177598465234041, 0.0017777425237, 0.00177959247957915, 0.00178144208621234, 0.00178332242649049, 0.00178524840157479, 0.00178725109435618, 0.00178923842031509, 0.00179125624708831, 0.0017933810595423, 0.00179546012077481, 0.00179767666850239, 0.00179987808223814, 0.00180207937955856, 0.00180438777897507, 0.00180669606197625, 0.00180900434497744, 0.0018114197300747, 0.00181383499875665, 0.00181628100108355, 0.00181934784632176, 0.00182216637767851, 0.00182502123061568, 0.00182786455843598, 0.00183071161154658, 0.00183360662776977, 0.00183649593964219, 0.00183939840644598, 0.00184231833554804, 0.00184523419011384, 0.00184817891567945, 0.00185113504994661, 0.00185411225538701, 0.00185711611993611, 0.00186007027514279, 0.00186310079880059, 0.00186609895899892, 0.00186914089135826, 0.00187219644431025, 0.00187523849308491, 0.00187833793461323, 0.00188139150850475, 0.00188450247514993, 0.00188759807497263, 0.00189073954243213, 0.00189387716818601, 0.00189700338523835, 0.00190018292050809, 0.00190333207137883, 0.00190654420293868, 0.00190975272562355, 0.00191294366959482, 0.00191617698874325, 0.00191941403318197, 0.00192266248632222, 0.00192593946121633, 0.00192920316476375, 0.00193250714801252, 0.00193579762708396, 0.00193911488167942, 0.00194243213627487, 0.00194577791262418, 0.00194915069732815, 0.00195249484386295, 0.00195589987561107, 0.00195927056483924, 0.00196266802959144, 0.00196611718274653, 0.00196954351849854, 0.00197298475541174, 0.00197642832063138, 0.00197991169989109, 0.00198339531198144, 0.00198689009994268, 0.0019904060754925, 0.00199389923363924, 0.00199745339341462, 0.00200099218636751, 0.00200456008315086, 0.00200813892297447, 0.00201170472428203, 0.00201531429775059, 0.00201892014592886, 0.00202254299074411, 0.00202619284391403, 0.00202984246425331, 0.00203351909294724, 0.00203716475516558, 0.00204086047597229, 0.00204456388019025, 0.00204828032292426, 0.00205203145742416, 0.00205573090352118, 0.00205949158407748, 0.00206324830651283, 0.00206705462187529, 0.00207082671113312, 0.00207462534308434, 0.00207844329997897, 0.00208226894028485, 0.00208614207804203, 0.0020899698138237, 0.00209387158975005, 0.00209772400557995, 0.00210163532756269, 0.00210554711520672, 0.00210946053266525, 0.00211339863017201, 0.00211732182651758, 0.00212129252031446, 0.00212524039670825, 0.00212925113737583, 0.00213324674405158, 0.00213725585490465, 0.0021412915084511, 0.00214531016536057, 0.00214936304837465, 0.00215342547744513, 0.00215750141069293, 0.00216159643605351, 0.00216573150828481, 0.0021692703012377, 0.00217282259836793, 0.0021763329859823, 0.00217986991629004, 0.00218338775448501, 0.00218689627945423, 0.00219039293006063, 0.00219387467950583, 0.00219736387953162, 0.00220084725879133, 0.00220433296635747, 0.00220778584480286, 0.00221124803647399, 0.00221469160169363, 0.00221813120879233, 0.0022215573117137, 0.00222498551011086, 0.00222842302173376, 0.0022318281698972, 0.0022352256346494, 0.00223863078281283, 0.00224201683886349, 0.00224538752809167, 0.00224876613356173, 0.00225214823149145, 0.00225549796596169, 0.00225884770043194, 0.00226219743490219, 0.0022655357606709, 0.00226885871961713, 0.00227217795327306, 0.00227550673298538, 0.00227881618775427, 0.00228210678324103, 0.00228539714589715, 0.00228868774138391, 0.00229195528663695, 0.00229522679001093, 0.00229849806055427, 0.00230175233446062, 0.00230500265024602, 0.00230823969468474, 0.00231147464364767, 0.00231469259597361, 0.002317916136235, 0.00232113222591579, 0.00232433481141925, 0.00232752598822117, 0.00233071320690215, 0.00233389507047832, 0.00233706505969167, 0.00234023714438081, 0.00234339758753777, 0.00234654871746898, 0.00234969006851315, 0.0023528162855655, 0.00235594809055328, 0.00235907058231533, 0.00236218888312578, 0.00236529996618629, 0.00236839544959366, 0.0023714832495898, 0.00237455987371504, 0.00237763626500964, 0.00238070706836879, 0.00238378928042948, 0.00238682958297431, 0.00238987733609974, 0.00239291577599943, 0.00239594257436693, 0.00239896355196834, 0.0024019826669246, 0.00240500760264695, 0.00240800180472434, 0.00241099414415658, 0.00241398112848401, 0.00241696205921471, 0.00241992739029229, 0.002422891324386, 0.00242586084641516, 0.00242880755104125, 0.00243174424394965, 0.00243468303233385, 0.00243760878220201, 0.00244051706977189, 0.00244344840757549, 0.00244634714908898, 0.00244924775324762, 0.00245213136076927, 0.00245501869358122, 0.00245789065957069, 0.00246076635085046, 0.00246362714096904, 0.00246648164466023, 0.00246932334266603, 0.00247215921990573, 0.0024749911390245, 0.00247781304642558, 0.00248064124025404, 0.00248335488140583, 0.00248590763658285, 0.00248846062459052, 0.00249098311178386, 0.00249350513331592, 0.00249602738767862, 0.00249854987487197, 0.00250102649442852, 0.00250350288115442, 0.00250596413388848, 0.00250841001980007, 0.00251084053888917, 0.00251330179162323, 0.00251571694388986, 0.0025181018281728, 0.00252050184644759, 0.00252288673073053, 0.00252524088136852, 0.00252757966518402, 0.00252996454946697, 0.00253228819929063, 0.0025346118491143, 0.002536904765293, 0.00253919768147171, 0.00254147546365857, 0.00254372274503112, 0.00254601566120982, 0.00254826294258237, 0.00255049485713243, 0.00255271140486002, 0.00255491258576512, 0.00255711399950087, 0.00255928467959166, 0.0025614860933274, 0.00256364140659571, 0.00256579695269465, 0.0025679066311568, 0.00257003121078014, 0.00257215625606477, 0.00257425056770444, 0.00257636024616659, 0.00257842382416129, 0.00258048763498664, 0.00258253631182015, 0.00258456938900054, 0.00258658733218908, 0.00258860504254699, 0.00259062298573554, 0.00259262532927096, 0.00259459763765335, 0.00259656948037446, 0.00259849545545876, 0.00260045216418803, 0.00260240887291729, 0.00260430458001792, 0.00260621565394104, 0.00260811112821102, 0.00260999123565853, 0.00261184107512236, 0.00261370604857802, 0.00261557125486434, 0.0026173903606832, 0.00261920923367143, 0.00262102833949029, 0.00262281694449484, 0.00262459041550756, 0.00262636365368962, 0.00262815225869417, 0.00262989499606192, 0.00263162236660719, 0.00263334973715246, 0.00263506174087524, 0.00263675861060619, 0.00263842497952282, 0.00264013721607625, 0.00264178798533976, 0.00264342385344207, 0.00264507485553622, 0.00264669535681605, 0.0026483153924346, 0.00264989002607763, 0.00265151052735746, 0.00265310029499233, 0.00265464442782104, 0.00265620346181095, 0.00265774759463966, 0.00265927636064589, 0.00266080489382148, 0.00266230315901339, 0.0026638014242053, 0.00266528408974409, 0.00266673625446856, 0.00266818841919303, 0.0026696715503931, 0.00267107784748077, 0.00267249927856028, 0.00267390604130924, 0.00267531233839691, 0.00267667253501713, 0.00267804856412113, 0.00267943972721696, 0.00268078502267599, 0.00268209958449006, 0.00268342951312661, 0.00268474407494068, 0.00268602836877108, 0.00268731242977083, 0.00268861185759306, 0.00268988078460097, 0.00269110361114144, 0.00269234203733504, 0.00269357999786735, 0.0026947723235935, 0.00269598001614213, 0.00269718770869076, 0.00269836490042508, 0.00269952649250627, 0.0027006734162569, 0.00270181987434626, 0.00270293559879065, 0.00270406669005752, 0.00270518288016319, 0.00270626810379326, 0.00270735332742333, 0.00270840828306973, 0.00270946323871613, 0.0027105025947094, 0.00271155755035579, 0.00271256640553474, 0.0027135752607137, 0.00271456898190081, 0.00271554733626544, 0.0027165103238076, 0.00271747354418039, 0.00271843653172255, 0.00271936925128102, 0.00272028613835573, 0.00272120349109173, 0.00272209011018276, 0.0027229767292738, 0.00272384821437299, 0.00272473483346403, 0.00272557558491826, 0.00272640096955001, 0.00272722635418177, 0.00272802147082984, 0.00272883172146976, 0.00272962660528719, 0.00273042148910463, 0.00273117073811591   }, 
   { 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 1.76951107278001e-06, 4.69305132355657e-06, 7.69352664065082e-06, 1.07196474345983e-05, 1.38227032948635e-05, 1.69514041772345e-05, 2.02083319891244e-05, 2.34652561630355e-05, 2.6747829906526e-05, 3.01586260320619e-05, 3.36463563144207e-05, 3.71084424841683e-05, 4.06987564929295e-05, 4.42377786384895e-05, 4.79563204862643e-05, 5.17005028086714e-05, 5.54703292436898e-05, 5.93170916545205e-05, 6.31895018159412e-05, 6.71644884278066e-05, 7.12164182914421e-05, 7.52426931285299e-05, 7.93971921666525e-05, 8.35516984807327e-05, 8.78344289958477e-05, 9.21171667869203e-05, 9.65281142271124e-05, 0.00010088778071804, 0.000105401319160592, 0.000109889202576596, 0.000114505324745551, 0.000119147087389138, 0.000123840145533904, 0.000128610117826611, 0.00013340575969778, 0.000138303963467479, 0.000143227822263725, 0.000148202976561151, 0.000153280692757107, 0.000158435359480791, 0.000163538730703294, 0.00016871903790161, 0.000174027591128834, 0.000179361755726859, 0.000184798511327244, 0.000190235281479545, 0.000195748973055743, 0.00020131396013312, 0.000206930228159763, 0.00021259777713567, 0.000218316650716588, 0.00022413807164412, 0.000230010802624747, 0.000235883533605374, 0.000241807530983351, 0.000247834133915603, 0.0002539633132983, 0.000260143773630261, 0.000266298622591421, 0.00027255600434728, 0.000278916006209329, 0.000285275978967547, 0.000291661621304229, 0.000298124185064808, 0.000304663670249283, 0.000311280076857656, 0.000317947851726785, 0.000324641179759055, 0.000331385876052082, 0.000338310026563704, 0.000345131586072966, 0.00035205579479225, 0.000359031255356967, 0.00036605802597478, 0.000373289949493483, 0.000380419282009825, 0.000387599895475432, 0.000394908740418032, 0.000402320147259161, 0.000409680302254856, 0.000417142990045249, 0.000424631405621767, 0.000432247965363786, 0.000439864554209635, 0.000447532453108579, 0.000455251603852957, 0.000463047734228894, 0.000470997678348795, 0.000478845118777826, 0.000486846343846992, 0.000494924548547715, 0.000502900162246078, 0.000511157908476889, 0.00051931303460151, 0.000527519499883056, 0.000535931030754, 0.000544291397091001, 0.000552702927961946, 0.000561191467568278, 0.000569680007174611, 0.000578603299800307, 0.000590041046962142, 0.000601530016865581, 0.000613018986769021, 0.000624508014880121, 0.000635945587418973, 0.000647434673737735, 0.000658872304484248, 0.000670412555336952, 0.000681850244291127, 0.000693339214194566, 0.000704776961356401, 0.000716317212209105, 0.00072775490116328, 0.00073924392927438, 0.000750681501813233, 0.000762170588131994, 0.000773659499827772, 0.000785148469731212, 0.000796586158685386, 0.000808075128588825, 0.000819512817543, 0.000831053068395704, 0.000842490815557539, 0.000853979785460979, 0.000865468755364418, 0.000876957783475518, 0.000888395356014371, 0.000899884384125471, 0.000911322014871985, 0.00092286232393235, 0.000934300012886524, 0.000945788982789963, 0.000957226729951799, 0.000968715583439916, 0.000980204669758677, 0.000991642358712852, 0.00100313127040863, 0.00101462029851973, 0.00102610921021551, 0.00103759823832661, 0.00104903581086546, 0.00106047361623496, 0.00107201386708766, 0.00108350277878344, 0.00109494058415294, 0.00110642949584872, 0.00111791852395982, 0.00112935621291399, 0.00114084512460977, 0.00115233415272087, 0.00116377172525972, 0.00117526075337082, 0.00118674978148192, 0.0011981874704361, 0.0012096764985472, 0.00122116541024297, 0.00123265432193875, 0.00124409201089293, 0.00125558103900403, 0.00126707006711513, 0.00127855897881091, 0.00128999666776508, 0.00130148557946086, 0.00131292338483036, 0.00132446363568306, 0.00133590144105256, 0.00134739035274833, 0.00135882804170251, 0.00137036805972457, 0.00138180586509407, 0.00139329489320517, 0.00140473246574402, 0.00141627283301204, 0.00142771052196622, 0.001439199433662, 0.00145063723903149, 0.00146212615072727, 0.00147361529525369, 0.00148505275137722, 0.00149654189590365, 0.00150803080759943, 0.00151951983571053, 0.0015310087474063, 0.00154244631994516, 0.00155388412531465, 0.00156537315342575, 0.00157691328786314, 0.00158835109323263, 0.00159978878218681, 0.00161132903303951, 0.00162276672199368, 0.00163425575010478, 0.00164574466180056, 0.00165718235075474, 0.00166867126245052, 0.00168016017414629, 0.00169159797951579, 0.00170308700762689, 0.00171452458016574, 0.0017248373478651, 0.00173335149884224, 0.0017418913776055, 0.0017502773553133, 0.00175871455576271, 0.00176697224378586, 0.00177528127096593, 0.00178346200846136, 0.00179164297878742, 0.00179969554301351, 0.00180777360219508, 0.00181567238178104, 0.00182367360685021, 0.00183149543590844, 0.00183934275992215, 0.0018470361828804, 0.00185475556645542, 0.00186232069972903, 0.00186996289994568, 0.00187745131552219, 0.00188496534246951, 0.00189229985699058, 0.00189968559425324, 0.00190691754687577, 0.00191420083865523, 0.00192135572433472, 0.00192838243674487, 0.00193551182746887, 0.00194256426766515, 0.00194943719543517, 0.00195638695731759, 0.00196318281814456, 0.00196987623348832, 0.00197667209431529, 0.00198336550965905, 0.00198990502394736, 0.00199649576097727, 0.00200295844115317, 0.00200929259881377, 0.00201575527898967, 0.00202208966948092, 0.00202827015891671, 0.00203445041552186, 0.0020406567491591, 0.00204665749333799, 0.00205276114866138, 0.00205876212567091, 0.00206460920162499, 0.00207043066620827, 0.00207627774216235, 0.00208197091706097, 0.0020877153147012, 0.00209322921000421, 0.00209884531795979, 0.00210433336906135, 0.00210984703153372, 0.00211518141441047, 0.00212059239856899, 0.00212577264755964, 0.00213105557486415, 0.0021361846011132, 0.00214133923873305, 0.00214633997529745, 0.0021514177788049, 0.00215623900294304, 0.00216121436096728, 0.00216598436236382, 0.00217077974230051, 0.00217542168684304, 0.00218003778718412, 0.0021846538875252, 0.00218926998786628, 0.00219368096441031, 0.00219816877506673, 0.0022024514619261, 0.00220675999298692, 0.00221101706847548, 0.00221527391113341, 0.00221937731839716, 0.00222337804734707, 0.00222742976620793, 0.00223137903958559, 0.00223527732305229, 0.00223917537368834, 0.00224294513463974, 0.00224663806147873, 0.00225035659968853, 0.00225394684821367, 0.00225748587399721, 0.00226097367703915, 0.00226443563587964, 0.00226782099343836, 0.00227118050679564, 0.00227441173046827, 0.0022776429541409, 0.00228077149949968, 0.00228392612189054, 0.00228690076619387, 0.00228995271027088, 0.002292824909091, 0.00229600956663489, 0.00229739444330335, 0.0022988049313426, 0.00230013835243881, 0.00230149761773646, 0.00230272836051881, 0.0023040110245347, 0.00230524176731706, 0.00230644713155925, 0.0023076266516, 0.00230880663730204, 0.00230988347902894, 0.00231098639778793, 0.00231203786097467, 0.00231308909133077, 0.0023140893317759, 0.00231508957222104, 0.00231598713435233, 0.00231693615205586, 0.0023177822586149, 0.00231867982074618, 0.00231950054876506, 0.0023202954325825, 0.00232109054923058, 0.00232185982167721, 0.00232252688147128, 0.00232324469834566, 0.00232388591393828, 0.00232452689670026, 0.00232514250092208, 0.00232573226094246, 0.00232624518685043, 0.0023267325013876, 0.00232727103866637, 0.00232768151909113, 0.00232814298942685, 0.00232857861556113, 0.00232891226187348, 0.0023292456753552, 0.00232957885600626, 0.00232983543537557, 0.00233011762611568, 0.00233032274991274, 0.00233055325224996, 0.00233070738613605, 0.00233088689856231, 0.00233096373267472, 0.00233106664381921, 0.00233109202235937, 0.00233114324510098, 0.00233114324510098, 0.00233114324510098, 0.00233104079961777, 0.00233098934404552, 0.00233083567582071, 0.00233073276467621, 0.0023305278737098, 0.00233037397265434, 0.00233011762611568, 0.00232986127957702, 0.00232955324463546, 0.00232927151955664, 0.00232891226187348, 0.00232855300419033, 0.00232814298942685, 0.00232773250900209, 0.00232721958309412, 0.00232678349129856, 0.00232624518685043, 0.00232565542683005, 0.00232511665672064, 0.00232455250807106, 0.00232388591393828, 0.00232324469834566, 0.00232255226001143, 0.0023217829875648, 0.00232109054923058, 0.00232032127678394, 0.00231950054876506, 0.00231865420937538, 0.00231780763715506, 0.00231688469648361, 0.00231601274572313, 0.0023150637280196, 0.00231406348757446, 0.00231306347995996, 0.00231206323951483, 0.00231096078641713, 0.00230990909039974, 0.00230878102593124, 0.0023076266516, 0.00230642128735781, 0.00230524176731706, 0.00230398518033326, 0.00230275420472026, 0.00230142078362405, 0.00230013835243881, 0.00229877908714116, 0.00229742005467415, 0.00229598372243345, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229492783546448, 0.00229353830218315, 0.00229066610336304, 0.00228794757276773, 0.00228528049774468, 0.00228261365555227, 0.00227999757044017, 0.00227753585204482, 0.00227502244524658, 0.00227261218242347, 0.00227025267668068, 0.00226797023788095, 0.00226571341045201, 0.00226358487270772, 0.00226143072359264, 0.0022593792527914, 0.00225735316053033, 0.0022554041352123, 0.00225348072126508, 0.00225171120837331, 0.00224989047273993, 0.00224819779396057, 0.00224650534801185, 0.00224491534754634, 0.00224332534708083, 0.00224191485904157, 0.00224042753688991, 0.00223901704885066, 0.00223773485049605, 0.00223650364205241, 0.00223524705506861, 0.00223411875776947, 0.00223304168321192, 0.00223196460865438, 0.00223104120232165, 0.00223006680607796, 0.00222922069951892, 0.00222842558287084, 0.00222770753316581, 0.00222698948346078, 0.00222639949060977, 0.00222578411921859, 0.00222527119331062, 0.0022248353343457, 0.00222445069812238, 0.00222406582906842, 0.00222380948252976, 0.0022235531359911, 0.002223399002105, 0.00222327094525099, 0.00222324533388019, 0.00222319387830794, 0.00222329655662179, 0.0022233733907342, 0.0022235787473619, 0.00222380948252976, 0.00222406582906842, 0.00222442485392094, 0.0022248609457165, 0.00222527119331062, 0.00222580973058939, 0.00222639949060977, 0.00222698948346078, 0.00222768192179501, 0.00222842558287084, 0.00222924631088972, 0.00223011802881956, 0.00223104120232165, 0.00223199022002518, 0.00223304168321192, 0.00223409314639866, 0.00223527289927006, 0.00223647803068161, 0.00223776046186686, 0.00223904266022146, 0.00224045314826071, 0.00224186340346932, 0.00224335095845163, 0.00224491534754634, 0.00224653095938265, 0.00224817241542041, 0.00224991608411074, 0.0022516599856317, 0.00225353217683733, 0.00225542997941375, 0.00225737877190113, 0.00225935340858996, 0.00226145633496344, 0.00226355926133692, 0.00226573925465345, 0.00226799584925175, 0.00227025267668068, 0.00227261218242347, 0.00227507390081882, 0.00227751000784338, 0.00227999757044017, 0.00228263926692307, 0.00228522927500308, 0.00228794757276773, 0.00229069171473384, 0.00229351269081235, 0.00229726149700582, 0.00230321101844311, 0.00230910954996943, 0.00231523858383298, 0.00232141907326877, 0.00232772785238922, 0.00233411369845271, 0.00234070420265198, 0.00234732055105269, 0.0023541422560811, 0.00236096372827888, 0.00236799055710435, 0.00237509422004223, 0.00238240300677717, 0.0023896605707705, 0.00239714910276234, 0.00240468862466514, 0.00241240812465549, 0.00242017838172615, 0.00242812838405371, 0.00243612937629223, 0.00244425912387669, 0.00245254253968596, 0.00246090302243829, 0.00246941694058478, 0.00247805938124657, 0.00248675304464996, 0.00249554915353656, 0.00250452500768006, 0.00251357792876661, 0.00252278428524733, 0.00253209355287254, 0.00254147942177951, 0.00255099381320179, 0.00256066233851016, 0.00257038185372949, 0.00258025503717363, 0.00259028212167323, 0.00260036089457572, 0.00261054164730012, 0.00262090237811208, 0.00263131433166564, 0.00264190579764545, 0.00265259970910847, 0.00266334507614374, 0.00267424411140382, 0.0026852716691792, 0.00269637606106699, 0.00270760850980878, 0.00271904608234763, 0.00273043266497552, 0.00274207559414208, 0.00275374390184879, 0.00276559218764305, 0.00277746585197747, 0.00278962147422135, 0.00280170049518347, 0.0028140100184828, 0.00282639660872519, 0.00283891125582159, 0.00285147735849023, 0.00286430004052818, 0.00287709687836468, 0.00289009907282889, 0.00290315225720406, 0.00291635957546532, 0.00292961811646819, 0.00294315861538053, 0.00295662228018045, 0.00297031691297889, 0.00298406253568828, 0.00299796205945313, 0.00301191327162087, 0.00302612059749663, 0.00304027646780014, 0.00305458647198975, 0.00306910159997642, 0.00308366818353534, 0.00309828598983586, 0.00311315967701375, 0.00312808551825583, 0.00314306211657822, 0.00315824430435896, 0.00317347724922001, 0.00318888993933797, 0.00320440530776978, 0.00321999751031399, 0.00323569215834141, 0.00325154070742428, 0.00326749216765165, 0.00328354584053159, 0.00329975364729762, 0.00331601267680526, 0.00333242537453771, 0.0033489924389869, 0.00336561002768576, 0.00338235660456121, 0.00339925661683083, 0.00341623369604349, 0.00343328760936856, 0.00345191289670765, 0.00347378849983215, 0.00349568924866617, 0.00351771828718483, 0.00353961926884949, 0.003561622928828, 0.00358357490040362, 0.00360563001595438, 0.00362763344310224, 0.0036497910041362, 0.00367182004265487, 0.00369395175948739, 0.00371603225357831, 0.00373818958178163, 0.00376034714281559, 0.00378255569376051, 0.00380481570027769, 0.00382704986259341, 0.00384930986911058, 0.00387159548699856, 0.00389385549351573, 0.0039162184111774, 0.00393858086317778, 0.00396089162677526, 0.00398330623283982, 0.00400574551895261, 0.00402813358232379, 0.00405059847980738, 0.00407311506569386, 0.00409558042883873, 0.00411812216043472, 0.0041406387463212, 0.00416318094357848, 0.00418577436357737, 0.00420844461768866, 0.00423101242631674, 0.00425368268042803, 0.00427637854591012, 0.00429902318865061, 0.0043217190541327, 0.00434454344213009, 0.00436723930761218, 0.00439003761857748, 0.00441283639520407, 0.00443563470616937, 0.00445840787142515, 0.00448138592764735, 0.00450420984998345, 0.00452711107209325, 0.00455008912831545, 0.00457299035042524, 0.00459591671824455, 0.00461899768561125, 0.00464197527617216, 0.00466500455513597, 0.00468811159953475, 0.00471114087849855, 0.00473419576883316, 0.00475740432739258, 0.00478048482909799, 0.0048036677762866, 0.00482685165479779, 0.00485008582472801, 0.00487329531461, 0.00489658024162054, 0.00491981534287333, 0.00494310073554516, 0.00496641220524907, 0.00498977536335588, 0.0050131119787693, 0.00503652635961771, 0.00505988951772451, 0.00508332904428244, 0.00510676857084036, 0.0051302844658494, 0.00515372445806861, 0.00517724081873894, 0.00520075764507055, 0.00522430008277297, 0.0052478676661849, 0.00527151254937053, 0.00529508059844375, 0.00531875109300017, 0.00534239551052451, 0.00536606647074223, 0.00538978772237897, 0.0054135350510478, 0.00543723162263632, 0.00546100502833724, 0.00548480357974768, 0.00550862727686763, 0.00553245190531015, 0.00555632682517171, 0.00558017706498504, 0.00560407852753997, 0.00562800606712699, 0.00565190659835935, 0.00567588536068797, 0.00569986319169402, 0.00572386756539345, 0.00574565352872014, 0.00576499057933688, 0.00578417303040624, 0.00580335548147559, 0.00582238426432014, 0.00584141304716468, 0.00586033891886473, 0.00587921310216188, 0.00589798577129841, 0.00591670675203204, 0.00593532482162118, 0.00595394289121032, 0.00597245944663882, 0.00599087215960026, 0.00600923411548138, 0.006027493160218, 0.0060457275249064, 0.00606390926986933, 0.00608196342363954, 0.00609996682032943, 0.00611789291724563, 0.00613574171438813, 0.00615351321175694, 0.00617126002907753, 0.00618885224685073, 0.00620644493028522, 0.00622393516823649, 0.00624137325212359, 0.00625873543322086, 0.00627601984888315, 0.00629320228472352, 0.00631038472056389, 0.00632743863388896, 0.00634444085881114, 0.00636136718094349, 0.00637821620330215, 0.00639498746022582, 0.00641168234869838, 0.00642835162580013, 0.00644491845741868, 0.00646140845492482, 0.00647784722968936, 0.00649418262764812, 0.00651046819984913, 0.00652667554095387, 0.0065428065136075, 0.00655885925516486, 0.00657486217096448, 0.0065907877869904, 0.00660663656890392, 0.00662240851670504, 0.00663812877610326, 0.00665374659001827, 0.00666931318119168, 0.00668480293825269, 0.0067002410069108, 0.0067156027071178, 0.0067308614961803, 0.0067460685968399, 0.00676117418333888, 0.00677622715011239, 0.00679122982546687, 0.00680615566670895, 0.00682100420817733, 0.00683574983850121, 0.00685044471174479, 0.00686508743092418, 0.00687967985868454, 0.00689416937530041, 0.00690855644643307, 0.00692286621779203, 0.0069371503777802, 0.00695138378068805, 0.00696553941816092, 0.00697956699877977, 0.0069935442879796, 0.00700746942311525, 0.0070212921127677, 0.00703508919104934, 0.00704878382384777, 0.00706240115687251, 0.00707594212144613, 0.00708943139761686, 0.0071028177626431, 0.00711620459333062, 0.00712946290150285, 0.00714267045259476, 0.00715574901551008, 0.00716880243271589, 0.0071818046271801, 0.0071947299875319, 0.00720755243673921, 0.00722032366320491, 0.00723301758989692, 0.00724560953676701, 0.00725817540660501, 0.0072706644423306, 0.00728305196389556, 0.00729541294276714, 0.00730767101049423, 0.00731991278007627, 0.00733064534142613, 0.00734129454940557, 0.00735190836712718, 0.00736249005421996, 0.00737303681671619, 0.00738353561609983, 0.00739401765167713, 0.00740441353991628, 0.00741480896249413, 0.0074250865727663, 0.00743538932874799, 0.00744563853368163, 0.00745584489777684, 0.00746599724516273, 0.00747611420229077, 0.0074861734174192, 0.00749619118869305, 0.00750619871541858, 0.00751612335443497, 0.00752601632848382, 0.00753587065264583, 0.0075456821359694, 0.00755543122068048, 0.00756517937406898, 0.0075748604722321, 0.00758450012654066, 0.00759408483281732, 0.00760363414883614, 0.00761313876137137, 0.00762262474745512, 0.00763204274699092, 0.00764142256230116, 0.00765075674280524, 0.00766004715114832, 0.00766930496320128, 0.00767851155251265, 0.0076876669190824, 0.00769679341465235, 0.00770587800070643, 0.00771490810438991, 0.00772392610087991, 0.00773286307230592, 0.00774175859987736, 0.00775061873719096, 0.00775944767519832, 0.00776821188628674, 0.00777697237208486, 0.00778566300868988, 0.0077943024225533, 0.00780290924012661, 0.00781146204099059, 0.00782000552862883, 0.00782846845686436, 0.0078369090333581, 0.00784528814256191, 0.00785362534224987, 0.00786194764077663, 0.00787023082375526, 0.00787842180579901, 0.00788659602403641, 0.0078947190195322, 0.00790281035006046, 0.00791086908429861, 0.00791889242827892, 0.00792684219777584, 0.00793476030230522, 0.0079426234588027, 0.00795045867562294, 0.00795823894441128, 0.00796599593013525, 0.00797369889914989, 0.00798134785145521, 0.00798895489424467, 0.00799656193703413, 0.0080040730535984, 0.00801156461238861, 0.00801900774240494, 0.00802639964967966, 0.00803375337272882, 0.0080410847440362, 0.00804836209863424, 0.00805559102445841, 0.0080627677962184, 0.00806989055126905, 0.00807698536664248, 0.00808406248688698, 0.00809109024703503, 0.0080980584025383, 0.00810497999191284, 0.00811185594648123, 0.00811872258782387, 0.00812549237161875, 0.00813225377351046, 0.00813896581530571, 0.0081456396728754, 0.00815225020051003, 0.00815885700285435, 0.008165393024683, 0.00817189458757639, 0.00817623548209667, 0.00818127114325762, 0.00818635523319244, 0.00819156132638454, 0.00819672830402851, 0.00820194743573666, 0.00820720195770264, 0.00821256451308727, 0.00821791496127844, 0.00822330359369516, 0.00822879187762737, 0.00823426991701126, 0.00823979638516903, 0.00824540015310049, 0.00825100671499968, 0.00825666449964046, 0.00826241914182901, 0.00826813839375973, 0.00827392656356096, 0.00827976502478123, 0.00828566588461399, 0.00829156488180161, 0.00829752720892429, 0.00830359198153019, 0.00830961484462023, 0.00831568986177444, 0.00832186453044415, 0.00832804758101702, 0.00833425391465425, 0.00834050495177507, 0.00834684539586306, 0.00835318397730589, 0.00835957191884518, 0.00836604461073875, 0.00837251637130976, 0.00837902724742889, 0.00838558562099934, 0.00839221477508545, 0.00839886348694563, 0.00840555690228939, 0.00841234065592289, 0.008419094607234, 0.00842591654509306, 0.00843280460685492, 0.00843971688300371, 0.00844665337353945, 0.00845365133136511, 0.00846071913838387, 0.00846777856349945, 0.00847491063177586, 0.00848211441189051, 0.00848931074142456, 0.00849655270576477, 0.00850390642881393, 0.00851120892912149, 0.00851857848465443, 0.00852604117244482, 0.00853350106626749, 0.00854100845754147, 0.00854855682700872, 0.00855620019137859, 0.00856383237987757, 0.00857148785144091, 0.00857926160097122, 0.00858703535050154, 0.00859484635293484, 0.00860267225652933, 0.00861059967428446, 0.00861854292452335, 0.00862652808427811, 0.00863459706306458, 0.00864264369010925, 0.00865076668560505, 0.00865895673632622, 0.00866713374853134, 0.00867536291480064, 0.00868366565555334, 0.00869200751185417, 0.00870036706328392, 0.0087087694555521, 0.00871726777404547, 0.00872578751295805, 0.00873430259525776, 0.00874293502420187, 0.00875155441462994, 0.00876019708812237, 0.00876896176487207, 0.00877771619707346, 0.00878652464598417, 0.00879534054547548, 0.00880428124219179, 0.00881319027394056, 0.00882216542959213, 0.00883121229708195, 0.00884027685970068, 0.00884936843067408, 0.00885854661464691, 0.00886771734803915, 0.00887693371623755, 0.00888622086495161, 0.0088966665789485, 0.00890510343015194, 0.00891364365816116, 0.00892254244536161, 0.00893146637827158, 0.00894057098776102, 0.00894985441118479, 0.00895947124809027, 0.00896906293928623, 0.00897893588989973, 0.00898896344006062, 0.00899916980415583, 0.00900955591350794, 0.00902017299085855, 0.00903091765940189, 0.00904181692749262, 0.00905299838632345, 0.00906428322196007, 0.00907569471746683, 0.0090873371809721, 0.00909923668950796, 0.00911118742078543, 0.0091233691200614, 0.0091357808560133, 0.00914834719151258, 0.00916111841797829, 0.00917404424399137, 0.00918709672987461, 0.00920035596936941, 0.00921384431421757, 0.00922748818993568, 0.00924120750278234, 0.00925515871495008, 0.00926946848630905, 0.00928377918899059, 0.00929821841418743, 0.00931288581341505, 0.0093278381973505, 0.0093429172411561, 0.00935807358473539, 0.00937353633344173, 0.00938907731324434, 0.00940489955246449, 0.00942087732255459, 0.00943698175251484, 0.00945326685905457, 0.00946985837072134, 0.00948650296777487, 0.00950327515602112, 0.00952027831226587, 0.00953756179660559, 0.00955492444336414, 0.00957249198108912, 0.00959026254713535, 0.00960829202085733, 0.00962637178599834, 0.00964470766484737, 0.0096631208434701, 0.00968168862164021, 0.00970058888196945, 0.00971959251910448, 0.00973872281610966, 0.00975808501243591, 0.00977767631411552, 0.00979739800095558, 0.00981724821031094, 0.00983730237931013, 0.00985763967037201, 0.00987805332988501, 0.00989861972630024, 0.00991944316774607, 0.00994037091732025, 0.00996157806366682, 0.00998289044946432, 0.010004379786551, 0.0100260758772492, 0.0100480290129781, 0.0100700324401259, 0.0100923432037234, 0.0101147051900625, 0.0101373242214322, 0.0101601229980588, 0.0101830242201686, 0.0102062076330185, 0.0102294413372874, 0.0102529572322965, 0.010276653803885, 0.0103004779666662, 0.0103244818747044, 0.0103486655279994, 0.0103731052950025, 0.0103976223617792, 0.0104222930967808, 0.010447271168232, 0.0104724299162626, 0.0104976370930672, 0.0105230510234833, 0.0105487229302526, 0.0105745987966657, 0.010600526817143, 0.0106332786381245, 0.0106677962467074, 0.0107026230543852, 0.0107376035302877, 0.0107726594433188, 0.0108079221099615, 0.0108433635905385, 0.0108790611848235, 0.0109148621559143, 0.0109508158639073, 0.0109870005398989, 0.0110233398154378, 0.0110598066821694, 0.0110965045168996, 0.011133280582726, 0.0111703118309379, 0.011207471601665, 0.0112448362633586, 0.011282354593277, 0.0113200014457107, 0.0113578541204333, 0.0113958856090903, 0.0114340959116817, 0.0114724356681108, 0.0115110827609897, 0.0115498062223196, 0.0115886330604553, 0.01162766572088, 0.0116670047864318, 0.0117063689976931, 0.0117459399625659, 0.0117857409641147, 0.0118257468566298, 0.0118658570572734, 0.0119061190634966, 0.0119465366005898, 0.0119871571660042, 0.0120279835537076, 0.0120688620954752, 0.012110048905015, 0.0121513362973928, 0.0121928052976727, 0.0122344773262739, 0.0122762797400355, 0.012318286113441, 0.0123604973778129, 0.0124028120189905, 0.0124452812597156, 0.0124879023060203, 0.0125308316200972, 0.0125738643109798, 0.0126170506700873, 0.0126603906974196, 0.0127039356157184, 0.0127476863563061, 0.012791539542377, 0.0128355966880918, 0.0128798102959991, 0.0129242781549692, 0.012968797236681, 0.0130135733634233, 0.0130585301667452, 0.0131036909297109, 0.0131489289924502, 0.0131943710148335, 0.0132399443536997, 0.0132857197895646, 0.0133317783474922, 0.0133778369054198, 0.0134241003543139, 0.0134705184027553, 0.0135172940790653, 0.0135640194639564, 0.0136110009625554, 0.0136581361293793, 0.0137055292725563, 0.0137529717758298, 0.0138006722554564, 0.0138485264033079, 0.0138965584337711, 0.0139447469264269, 0.0139931114390492, 0.0140416324138641, 0.0140903061255813, 0.0141392117366195, 0.0141883734613657, 0.0142375361174345, 0.0142869539558887, 0.0143366008996964, 0.0143862748518586, 0.014436156488955, 0.014486214146018, 0.0145365558564663, 0.0145869487896562, 0.0146375205367804, 0.0146883493289351, 0.0147392544895411, 0.0147903906181455, 0.0148416291922331, 0.0148930987343192, 0.0149420276284218, 0.0149915348738432, 0.0150411259382963, 0.0150907561182976, 0.0151403928175569, 0.0151900602504611, 0.0152398571372032, 0.0152896270155907, 0.0153394173830748, 0.015389297157526, 0.0154392728582025, 0.0154891917482018, 0.0155391683802009, 0.0155892455950379, 0.0156393181532621, 0.015689454972744, 0.0157395843416452, 0.0157898683100939, 0.0158400926738977, 0.0158903766423464, 0.0159407630562782, 0.0159911494702101, 0.0160415358841419, 0.016092024743557, 0.0161425583064556, 0.0161930993199348, 0.016243688762188, 0.0162943378090858, 0.0163450259715319, 0.0163957700133324, 0.016446515917778, 0.0164973568171263, 0.0165482051670551, 0.0165991112589836, 0.0166500546038151, 0.0167010575532913, 0.0167520847171545, 0.0168031640350819, 0.0168542861938477, 0.0169054549187422, 0.0169566348195076, 0.0170078873634338, 0.0170591957867146, 0.0171105060726404, 0.0171618610620499, 0.0172133035957813, 0.0172647945582867, 0.0173163078725338, 0.0173678174614906, 0.017419433221221, 0.0174710508435965, 0.017522718757391, 0.0175744388252497, 0.0176262352615595, 0.0176780261099339, 0.0177298467606306, 0.0177817735821009, 0.0178337302058935, 0.0178856737911701, 0.0179377011954784, 0.0179897788912058, 0.0180418789386749, 0.0180940348654985, 0.0181461963802576, 0.0181984789669514, 0.0182507317513227, 0.0183030404150486, 0.0183554533869028, 0.0184078346937895, 0.0184602756053209, 0.0185127668082714, 0.0185653530061245, 0.0186178926378489, 0.0186705105006695, 0.0187232289463282, 0.0187759287655354, 0.0188286751508713, 0.0188814476132393, 0.0189343169331551, 0.018987163901329, 0.0190400872379541, 0.0190931223332882, 0.019146116450429, 0.0191991440951824, 0.0192522238940001, 0.0193053986877203, 0.019358579069376, 0.0194117929786444, 0.0194650962948799, 0.0195184051990509, 0.0195717178285122, 0.0196251031011343, 0.0196785870939493, 0.0197320561856031, 0.0197855699807405, 0.0198391806334257, 0.0198928005993366, 0.0199464168399572, 0.020000109449029, 0.0200539100915194, 0.0201020017266273, 0.0201501324772835, 0.0201983284205198, 0.0202465876936913, 0.0202949494123459, 0.0203433912247419, 0.0203917995095253, 0.020440362393856, 0.0204890053719282, 0.020537693053484, 0.0205864105373621, 0.020635299384594, 0.0206842217594385, 0.0207331944257021, 0.0207822434604168, 0.020831324160099, 0.0208805240690708, 0.0209298394620419, 0.0209791753441095, 0.0210286062210798, 0.0210780948400497, 0.0211276095360518, 0.0211772229522467, 0.0212269704788923, 0.0212767403572798, 0.0213265884667635, 0.0213764552026987, 0.0214264318346977, 0.0214765109121799, 0.0215266458690166, 0.0215768739581108, 0.0216271542012691, 0.0216774381697178, 0.0217278730124235, 0.0217783600091934, 0.0218289326876402, 0.0218796022236347, 0.0219302363693714, 0.0219810325652361, 0.0220318827778101, 0.0220828000456095, 0.0221337825059891, 0.0221848860383034, 0.022235993295908, 0.0222871918231249, 0.0223384741693735, 0.0223898366093636, 0.0224412549287081, 0.0224927179515362, 0.0225443094968796, 0.0225959271192551, 0.0226476415991783, 0.0226993877440691, 0.0227512922137976, 0.0228031855076551, 0.0228551868349314, 0.0229072663933039, 0.0229593962430954, 0.0230115689337254, 0.0230638366192579, 0.023116247728467, 0.0231686532497406, 0.023221168667078, 0.0232736840844154, 0.0233263242989779, 0.023379048332572, 0.0234318692237139, 0.0234847161918879, 0.0235376618802547, 0.0235906131565571, 0.0236436910927296, 0.0236968286335468, 0.0237500797957182, 0.0238033626228571, 0.0238566752523184, 0.0239101033657789, 0.0239636190235615, 0.024017196148634, 0.0240708626806736, 0.024124575778842, 0.024178322404623, 0.0242322031408548, 0.0242861267179251, 0.0243401303887367, 0.0243942346423864, 0.0244483388960361, 0.0245025679469109, 0.0245568510144949, 0.0246112197637558, 0.0246656518429518, 0.0247201900929213, 0.024774732068181, 0.024829376488924, 0.0248840879648924, 0.0249388944357634, 0.0249937660992146, 0.0250486861914396, 0.0251036882400513, 0.025158766657114, 0.0252139233052731, 0.0252735577523708, 0.0253366585820913, 0.0253999084234238, 0.0254632066935301, 0.0255265552550554, 0.0255899634212255, 0.0256534144282341, 0.025716869160533, 0.0257804393768311, 0.0258441176265478, 0.0259077921509743, 0.025971494615078, 0.0260352976620197, 0.0260991603136063, 0.026163075119257, 0.0262270774692297, 0.0262911021709442, 0.0263551566749811, 0.0264193080365658, 0.0264834854751825, 0.0265477579087019, 0.026612114161253, 0.0266764257103205, 0.0267408657819033, 0.026805367320776, 0.0268699247390032, 0.0269345100969076, 0.0269992277026176, 0.0270638894289732, 0.0271286461502314, 0.0271934922784567, 0.027258375659585, 0.0273233503103256, 0.0273883193731308, 0.0274533946067095, 0.0275184996426105, 0.0275836773216724, 0.0276489350944757, 0.0277141742408276, 0.0277795549482107, 0.0278449468314648, 0.0279104299843311, 0.0279759597033262, 0.0280415341258049, 0.0281071215867996, 0.0281728338450193, 0.0282385963946581, 0.0283044036477804, 0.0283702872693539, 0.0284361578524113, 0.0285021234303713, 0.0285682082176208, 0.0286342985928059, 0.0287004560232162, 0.0287666544318199, 0.0288328845053911, 0.0288992077112198, 0.0289656352251768, 0.029032077640295, 0.0290985275059938, 0.0291650835424662, 0.0292316824197769, 0.0292983502149582, 0.0293651074171066, 0.0294319018721581, 0.0294987019151449, 0.029565604403615, 0.0296325609087944, 0.0296995714306831, 0.0297666825354099, 0.029833747074008, 0.0299009494483471, 0.0299681704491377, 0.0300354827195406, 0.0301028471440077, 0.0301702246069908, 0.0302377101033926, 0.0303052458912134, 0.0303728431463242, 0.0304404702037573, 0.030508192256093, 0.0305758882313967, 0.0306437611579895, 0.0307116117328405, 0.0307795610278845, 0.030847541987896, 0.030915554612875, 0.0309836566448212, 0.0310518555343151, 0.0311200544238091, 0.0311883240938187, 0.0312566868960857, 0.0313250236213207, 0.0313934721052647, 0.0314619950950146, 0.0315305665135384, 0.0315991938114166, 0.0316678173840046, 0.0317365676164627, 0.0318053402006626, 0.0318759344518185, 0.0319418534636497, 0.0320077389478683, 0.032073549926281, 0.0321392565965652, 0.0322049595415592, 0.0322705954313278, 0.0323361828923225, 0.0324016995728016, 0.0324671640992165, 0.0325325652956963, 0.0325979068875313, 0.0326632112264633, 0.0327284149825573, 0.0327936112880707, 0.0328587181866169, 0.032923799008131, 0.032988790422678, 0.0330537185072899, 0.0331186056137085, 0.0331834480166435, 0.0332482270896435, 0.0333129316568375, 0.0333775989711285, 0.0334421917796135, 0.0335067398846149, 0.0335712358355522, 0.0336356535553932, 0.0337000153958797, 0.033764336258173, 0.0338285937905312, 0.0338927693665028, 0.0339569263160229, 0.0340210124850273, 0.0340850464999676, 0.0341490209102631, 0.0342129208147526, 0.0342767797410488, 0.0343405976891518, 0.0344043374061584, 0.0344680175185204, 0.0345316268503666, 0.0345951914787292, 0.0346587002277374, 0.0347221717238426, 0.0347855761647224, 0.0348488837480545, 0.0349121615290642, 0.0349753871560097, 0.0350385680794716, 0.0351016856729984, 0.035164725035429, 0.0352277271449566, 0.0352906659245491, 0.0353535525500774, 0.0354163497686386, 0.0354791209101677, 0.0355418361723423, 0.0356044806540012, 0.0356670804321766, 0.0357295945286751, 0.0357920788228512, 0.0358545072376728, 0.0359168834984303, 0.0359791629016399, 0.0360414274036884, 0.036103617399931, 0.0361657477915287, 0.0362278409302235, 0.0362898409366608, 0.0363518074154854, 0.0364137142896652, 0.0364755615592003, 0.0365373529493809, 0.0365990772843361, 0.0366607569158077, 0.036722369492054, 0.0367839299142361, 0.0368454195559025, 0.0369068533182144, 0.0369682721793652, 0.0370296128094196, 0.0370908789336681, 0.0371520854532719, 0.0372132435441017, 0.0372743383049965, 0.0373353995382786, 0.037396389991045, 0.0374572984874249, 0.037518173456192, 0.0375789888203144, 0.0376397371292114, 0.0377004593610764, 0.0377610772848129, 0.0378216877579689, 0.0378822088241577, 0.0379426702857018, 0.038003072142601, 0.0380634367465973, 0.0381237454712391, 0.0381815358996391, 0.0382360331714153, 0.0382905192673206, 0.0383449979126453, 0.0383995100855827, 0.0384540297091007, 0.0385084822773933, 0.0385630317032337, 0.0386175438761711, 0.038672037422657, 0.0387265607714653, 0.0387810431420803, 0.0388355515897274, 0.0388900712132454, 0.0389445684850216, 0.0389990769326687, 0.0390535444021225, 0.039108045399189, 0.0391625501215458, 0.0392170697450638, 0.0392715409398079, 0.0393260531127453, 0.0393805839121342, 0.0394350849092007, 0.0394895933568478, 0.0395440496504307, 0.039598610252142, 0.0396531149744987, 0.0397076010704041, 0.03976209461689, 0.039816576987505, 0.0398710854351521, 0.0399255827069283, 0.0399801172316074, 0.0400346256792545, 0.0400890931487083, 0.0401436276733875, 0.040198128670454, 0.0402526222169399, 0.0403071269392967, 0.040361613035202, 0.0404161363840103, 0.0404706299304962, 0.040525134652853, 0.0405796095728874, 0.0406341440975666, 0.0406886264681816, 0.0407431349158287, 0.040797658264637, 0.0408521182835102, 0.0409066118299961, 0.0409611612558365, 0.0410156920552254, 0.0410701483488083, 0.0411246456205845, 0.0411791279911995, 0.0412336625158787, 0.0412881672382355, 0.0413426533341408, 0.0413971617817879, 0.0414516851305962, 0.0415061935782433, 0.0415606498718262, 0.0416151694953442, 0.0416696779429913, 0.0417241863906384, 0.0417787209153175, 0.0418331772089005, 0.0418876856565475, 0.0419422090053558, 0.0419967025518417, 0.0420512109994888, 0.0421056859195232, 0.0421602167189121, 0.0422147288918495, 0.0422692261636257, 0.0423237197101116, 0.0423781983554363, 0.0424327254295349, 0.0424872189760208, 0.0425417274236679, 0.0425962619483471, 0.0426507331430912, 0.0427052676677704, 0.0427597239613533, 0.0428142473101616, 0.0428687259554863, 0.0429232493042946, 0.0429777428507805, 0.0430322550237179, 0.0430867597460747, 0.0431412346661091, 0.0431957691907883, 0.0432502776384354, 0.0433047711849213, 0.0433592684566975, 0.0434137769043446, 0.0434683002531528, 0.0435227677226067, 0.043577317148447, 0.0436308495700359, 0.0436834692955017, 0.0437363013625145, 0.043789204210043, 0.0438424944877625, 0.0438959673047066, 0.0439495109021664, 0.0440034195780754, 0.0440575331449509, 0.0441117472946644, 0.0441662929952145, 0.0442209914326668, 0.0442758724093437, 0.0443310625851154, 0.0443863496184349, 0.0444419495761395, 0.0444978103041649, 0.0445537678897381, 0.0446099787950516, 0.044666476547718, 0.0447230748832226, 0.0447799526154995, 0.0448369905352592, 0.0448943562805653, 0.0449518784880638, 0.0450096353888512, 0.0450675375759602, 0.0451257564127445, 0.0451840460300446, 0.0452426411211491, 0.0453015230596066, 0.045360404998064, 0.0454196967184544, 0.0454791933298111, 0.0455387942492962, 0.0455986745655537, 0.0456588640809059, 0.0457191057503223, 0.0457796566188335, 0.0458403564989567, 0.0459013134241104, 0.0459625534713268, 0.0460239760577679, 0.0460854694247246, 0.0461473539471626, 0.0462093651294708, 0.0462716296315193, 0.0463341251015663, 0.046396728605032, 0.0464596897363663, 0.0465228259563446, 0.0465860925614834, 0.0466496124863625, 0.0467133969068527, 0.0467773005366325, 0.0468415133655071, 0.0469058603048325, 0.0469704829156399, 0.0470353700220585, 0.0471003279089928, 0.047165647149086, 0.0472311675548553, 0.0472967699170113, 0.0473627783358097, 0.0474289171397686, 0.0474951826035976, 0.0475617349147797, 0.0476285144686699, 0.0476954989135265, 0.0477627404034138, 0.0478300824761391, 0.0478977374732494, 0.0479655675590038, 0.0480335503816605, 0.0481018237769604, 0.0481703691184521, 0.0482389703392982, 0.0483079589903355, 0.0483771450817585, 0.0484463945031166, 0.0485160425305367, 0.0485858507454395, 0.0486557558178902, 0.0487260483205318, 0.0487964935600758, 0.0488670729100704, 0.0489379540085793, 0.0490089431405067, 0.0490802861750126, 0.049151785671711, 0.0492234900593758, 0.0492954216897488, 0.0493676140904427, 0.0494398809969425, 0.0495124794542789, 0.0495853163301945, 0.0496582202613354, 0.0497315227985382, 0.0498048663139343, 0.049878541380167, 0.0499556846916676, 0.0500399023294449, 0.0501243248581886, 0.0502090603113174, 0.0502940453588963, 0.0503792650997639, 0.0504648685455322, 0.0505506508052349, 0.0506367683410645, 0.0507231876254082, 0.0508097410202026, 0.0508966557681561, 0.0509837679564953, 0.0510712713003159, 0.0511590018868446, 0.051246915012598, 0.0513352081179619, 0.0514237619936466, 0.0515124946832657, 0.0516016893088818, 0.0516910888254642, 0.0517806671559811, 0.0518705509603024, 0.0519607216119766, 0.0520511418581009, 0.0521419011056423, 0.0522329434752464, 0.052324190735817, 0.0524157397449017, 0.052507396787405, 0.0525995641946793, 0.0526920184493065, 0.0527845695614815, 0.0528774783015251, 0.0529706999659538, 0.0530639961361885, 0.0531577803194523, 0.0532518215477467, 0.0533460155129433, 0.0534405447542667, 0.053535457700491, 0.0536304228007793, 0.0537257939577103, 0.0538214519619942, 0.0539173372089863, 0.0540135577321053, 0.0541098788380623, 0.0542066134512424, 0.0543037056922913, 0.0544008538126945, 0.054498452693224, 0.0545963197946548, 0.0546942800283432, 0.0547926798462868, 0.0548913367092609, 0.0549901723861694, 0.0550893172621727, 0.0551888011395931, 0.055288452655077, 0.0553884916007519, 0.0554887913167477, 0.055589247494936, 0.0556901060044765, 0.0557910986244678, 0.0558924712240696, 0.0559941045939922, 0.0560959912836552, 0.0561981573700905, 0.056300662457943, 0.0564032979309559, 0.0565062612295151, 0.0566094554960728, 0.0567130595445633, 0.0568169020116329, 0.0569210164248943, 0.0570253431797028, 0.0571298711001873, 0.0572347082197666, 0.057339932769537, 0.0574454329907894, 0.0575510449707508, 0.0576571114361286, 0.0577633567154408, 0.0578698106110096, 0.0579766482114792, 0.0580837689340115, 0.0581910908222198, 0.0582986697554588, 0.0584064610302448, 0.0585147067904472, 0.0586232133209705, 0.0587319433689117, 0.0588408596813679, 0.0589501112699509, 0.0590595379471779, 0.0591694042086601, 0.0592795200645924, 0.059389766305685, 0.0595004037022591, 0.0596112906932831, 0.0597207359969616, 0.059832725673914, 0.05994488671422, 0.0600571073591709, 0.0601694509387016, 0.0602818503975868, 0.0603944100439548, 0.0605071038007736, 0.0606199465692043, 0.0607328452169895, 0.0608458742499352, 0.0609589479863644, 0.0610721930861473, 0.0611855871975422, 0.061299130320549, 0.0614126995205879, 0.0615264326334, 0.061640202999115, 0.0617541596293449, 0.0618681646883488, 0.061982411891222, 0.0620967149734497, 0.0622110813856125, 0.0623255595564842, 0.0624402053654194, 0.0625549405813217, 0.0626698732376099, 0.0627848356962204, 0.0628999248147011, 0.0630150437355042, 0.0631303787231445, 0.0632458180189133, 0.0633613839745522, 0.0634770691394806, 0.0635928064584732, 0.063708707690239, 0.0638246908783913, 0.0639408230781555, 0.0640571266412735, 0.0641734451055527, 0.064289890229702, 0.0644064545631409, 0.0645231604576111, 0.0646399483084679, 0.0647569373250008, 0.0648739710450172, 0.0649910643696785, 0.0651083514094353, 0.0652257576584816, 0.0653432384133339, 0.0654608830809593, 0.0655786320567131, 0.0656964331865311, 0.0658143609762192, 0.0659324377775192, 0.0660506337881088, 0.0661689788103104, 0.0662874132394791, 0.0664058774709702, 0.0665245428681374, 0.0666432604193687, 0.0667621493339539, 0.0668812096118927, 0.0670002922415733, 0.0671194940805435, 0.0672388225793839, 0.0673582702875137, 0.067477822303772, 0.0675975680351257, 0.0677173584699631, 0.067837193608284, 0.0679572224617004, 0.0680773556232452, 0.068197637796402, 0.0683180391788483, 0.0684385150671005, 0.0685590505599976, 0.0686797499656677, 0.0688005983829498, 0.0689215585589409, 0.0690426379442215, 0.0691637620329857, 0.0692850649356842, 0.0694064572453499, 0.0695279613137245, 0.0696495845913887, 0.0697714015841484, 0.0698931962251663, 0.070015162229538, 0.0701372623443604, 0.0702594742178917, 0.0703817754983902, 0.0705042481422424, 0.0706267580389977, 0.0707494094967842, 0.0708722099661827, 0.0709950998425484, 0.0711181238293648, 0.0712412446737289, 0.0713644549250603, 0.0714900493621826, 0.0716077238321304, 0.0717254430055618, 0.0718432292342186, 0.0719610303640366, 0.0720789507031441, 0.0721969306468964, 0.0723149180412292, 0.0724329873919487, 0.0725511237978935, 0.0726693123579025, 0.0727875456213951, 0.0729058608412743, 0.0730241984128952, 0.0731426030397415, 0.0732611194252968, 0.0733795985579491, 0.0734982490539551, 0.0736168697476387, 0.0737355798482895, 0.0738543346524239, 0.0739731341600418, 0.0740920007228851, 0.0742109417915344, 0.0743299350142479, 0.0744489505887032, 0.0745680704712868, 0.0746872425079346, 0.0748064294457436, 0.0749257132411003, 0.0750450640916824, 0.0751644521951675, 0.0752838999032974, 0.0754034146666527, 0.0755229666829109, 0.0756425783038139, 0.0757622718811035, 0.0758819729089737, 0.0760018154978752, 0.0761216506361961, 0.0762415304780006, 0.0763615146279335, 0.0764815211296082, 0.0766015946865082, 0.076721765100956, 0.0768419504165649, 0.0769621655344963, 0.0770824998617172, 0.0772028639912605, 0.0773232504725456, 0.0774437710642815, 0.0775642842054367, 0.0776849016547203, 0.0778055489063263, 0.0779262706637383, 0.0780470296740532, 0.0781678557395935, 0.078288733959198, 0.0784096494317055, 0.0785306692123413, 0.0786517336964607, 0.0787728279829025, 0.0788939893245697, 0.0790152028203011, 0.0791364833712578, 0.0792578309774399, 0.0793792754411697, 0.079500675201416, 0.0796221941709518, 0.0797437652945518, 0.0798653811216354, 0.0799871161580086, 0.0801088362932205, 0.080230638384819, 0.0803525000810623, 0.0804744139313698, 0.0805963724851608, 0.0807184055447578, 0.0808404982089996, 0.0809626206755638, 0.0810848325490952, 0.0812070965766907, 0.0813294127583504, 0.0814517810940742, 0.0815742090344429, 0.0816967040300369, 0.0818192511796951, 0.0819418579339981, 0.0820644870400429, 0.0821872130036354, 0.0823100134730339, 0.0824327990412712, 0.0825557485222816, 0.0826786756515503, 0.0828016623854637, 0.0829247236251831, 0.0830478519201279, 0.083171010017395, 0.0832942724227905, 0.083417572081089, 0.0835436508059502, 0.0836784094572067, 0.0838129743933678, 0.083947479724884, 0.0840818360447884, 0.0842160657048225, 0.0843502134084702, 0.0844842046499252, 0.0846181809902191, 0.0847519114613533, 0.0848855748772621, 0.085019163787365, 0.0851525738835335, 0.0852859541773796, 0.0854191705584526, 0.0855522453784943, 0.0856852680444717, 0.0858181118965149, 0.0859509035944939, 0.0860835462808609, 0.0862160474061966, 0.0863484516739845, 0.0864807516336441, 0.0866129547357559, 0.086745023727417, 0.0868769660592079, 0.0870088115334511, 0.0871405154466629, 0.0872721299529076, 0.0874036699533463, 0.08753502368927, 0.0876663029193878, 0.0877974256873131, 0.0879284739494324, 0.0880594402551651, 0.0881902128458023, 0.0883209481835365, 0.0884515270590782, 0.0885820090770721, 0.0887123420834541, 0.0888425409793854, 0.0889726653695107, 0.0891026332974434, 0.0892325788736343, 0.0893623605370522, 0.0894919708371162, 0.0896215364336967, 0.0897510200738907, 0.0898802950978279, 0.0900095254182816, 0.0901385620236397, 0.0902675539255142, 0.0903964266180992, 0.0905251652002335, 0.0906538069248199, 0.0907823517918587, 0.0909106880426407, 0.0910389944911003, 0.0911671370267868, 0.0912952125072479, 0.0914231017231941, 0.0915509462356567, 0.091678686439991, 0.0918062329292297, 0.0919338017702103, 0.0920611619949341, 0.092188373208046, 0.0923155248165131, 0.0924424976110458, 0.0925694704055786, 0.0926962792873383, 0.0928229168057442, 0.0929494723677635, 0.0930758789181709, 0.093202255666256, 0.093328483402729, 0.0934545770287514, 0.0935805663466454, 0.093706488609314, 0.0938322022557259, 0.0939578860998154, 0.0940833613276482, 0.0942087918519974, 0.0943340733647346, 0.0944592729210854, 0.0945843681693077, 0.0947092622518539, 0.0948341265320778, 0.0949588939547539, 0.0950834527611732, 0.0952080115675926, 0.0953323394060135, 0.0954566672444344, 0.0955808386206627, 0.0957048311829567, 0.0958287715911865, 0.0959525927901268, 0.0960762724280357, 0.0961998328566551, 0.0963233113288879, 0.0964385122060776, 0.0965409353375435, 0.096643291413784, 0.0967455953359604, 0.0968477055430412, 0.0969497412443161, 0.097051739692688, 0.0971535220742226, 0.0972553342580795, 0.0973569378256798, 0.0974585264921188, 0.097559966146946, 0.0976613014936447, 0.0977625921368599, 0.0978637039661407, 0.097964733839035, 0.0980656966567039, 0.0981665328145027, 0.0982672646641731, 0.0983678922057152, 0.0984684675931931, 0.0985689237713814, 0.0986692756414413, 0.0987695306539536, 0.0988696962594986, 0.0989696532487869, 0.0990696251392365, 0.0991694629192352, 0.0992692112922668, 0.0993689000606537, 0.0994683727622032, 0.0995678529143333, 0.0996671244502068, 0.0997664257884026, 0.0998655632138252, 0.0999645814299583, 0.100063554942608, 0.100162334740162, 0.100261136889458, 0.100359782576561, 0.100458271801472, 0.10055673122406, 0.100655049085617, 0.100753262639046, 0.100851438939571, 0.100949428975582, 0.101047374308109, 0.101145260035992, 0.101242944598198, 0.101340629160404, 0.101438097655773, 0.101535551249981, 0.101632870733738, 0.101730093359947, 0.101827256381512, 0.101924255490303, 0.102021239697933, 0.10211805999279, 0.10221479088068, 0.102311372756958, 0.102407895028591, 0.102504350244999, 0.102600701153278, 0.102696888148785, 0.102793008089066, 0.102889075875282, 0.102984957396984, 0.103080801665783, 0.10317650437355, 0.103272154927254, 0.103367634117603, 0.10346308350563, 0.103558458387852, 0.103653632104397, 0.103748768568039, 0.103843793272972, 0.103938706219196, 0.104033514857292, 0.104128241539001, 0.104222901165485, 0.104317434132099, 0.10441180318594, 0.104506157338619, 0.104600392282009, 0.104694463312626, 0.10478849709034, 0.104882441461086, 0.10497622936964, 0.105069950222969, 0.105163529515266, 0.105257086455822, 0.105350464582443, 0.105443812906742, 0.10553702712059, 0.105630114674568, 0.105723157525063, 0.105816043913364, 0.105908900499344, 0.106001630425453, 0.106094211339951, 0.106195770204067, 0.106299161911011, 0.106402680277824, 0.106506243348122, 0.106610007584095, 0.106713823974133, 0.106817796826363, 0.10692185908556, 0.107026048004627, 0.107130356132984, 0.107234753668308, 0.107339300215244, 0.107443906366825, 0.107548721134663, 0.107653558254242, 0.107758544385433, 0.107863649725914, 0.107968874275684, 0.108074210584164, 0.108179651200771, 0.108285240828991, 0.108390890061855, 0.108496680855751, 0.108602583408356, 0.108708597719669, 0.108814716339111, 0.108920991420746, 0.109027363359928, 0.109133839607239, 0.109240435063839, 0.109347134828568, 0.109453968703747, 0.109560884535313, 0.10966794192791, 0.109775111079216, 0.109882421791553, 0.109989799559116, 0.110097318887711, 0.110204949975014, 0.110312685370445, 0.110420547425747, 0.110528483986855, 0.110636599361897, 0.110744781792164, 0.110853105783463, 0.11096154153347, 0.111070096492767, 0.111178755760193, 0.111287504434586, 0.111396446824074, 0.111505411565304, 0.111614532768726, 0.111723780632019, 0.111833103001118, 0.111942581832409, 0.112052150070667, 0.112161859869957, 0.112271651625633, 0.11238157749176, 0.112491600215435, 0.11260174959898, 0.112712070345879, 0.112822405993938, 0.112932920455933, 0.113043531775475, 0.113154262304306, 0.113265059888363, 0.113376058638096, 0.113487139344215, 0.113598264753819, 0.113709606230259, 0.113820992410183, 0.113932535052299, 0.114044152200222, 0.114155948162079, 0.114267826080322, 0.114379793405533, 0.114491909742355, 0.114604093134403, 0.114716455340385, 0.114828884601593, 0.114941470324993, 0.115054123103619, 0.115166917443275, 0.115279830992222, 0.115392848849297, 0.115505993366241, 0.115619219839573, 0.115732587873936, 0.115846075117588, 0.115959666669369, 0.116073369979858, 0.116187185049057, 0.116301149129868, 0.116415217518806, 0.116529352962971, 0.116643629968166, 0.116758048534393, 0.116872556507587, 0.116987146437168, 0.117110371589661, 0.117244966328144, 0.117379173636436, 0.117513082921505, 0.117646738886833, 0.117780223488808, 0.117913357913494, 0.118046179413795, 0.118178643286228, 0.118310920894146, 0.118442848324776, 0.11857445538044, 0.118705876171589, 0.118836954236031, 0.118967719376087, 0.119098275899887, 0.119228482246399, 0.119358517229557, 0.119488157331944, 0.119617566466331, 0.11974660307169, 0.119875393807888, 0.120003893971443, 0.120132088661194, 0.120260007679462, 0.120387643575668, 0.120515152812004, 0.120642192661762, 0.120768964290619, 0.120895445346832, 0.121021680533886, 0.121147617697716, 0.121273227035999, 0.121398568153381, 0.121523641049862, 0.121648401021957, 0.121772885322571, 0.121897056698799, 0.122021086513996, 0.122144736349583, 0.122268065810204, 0.122391149401665, 0.122513920068741, 0.12263635545969, 0.122758530080318, 0.122880443930626, 0.123002111911774, 0.123123407363892, 0.123244427144527, 0.123365178704262, 0.123485714197159, 0.12360592931509, 0.12372587621212, 0.123845465481281, 0.123964786529541, 0.124083824455738, 0.12420254945755, 0.124320976436138, 0.124439172446728, 0.124557174742222, 0.124674826860428, 0.124792098999023, 0.124909110367298, 0.12502583861351, 0.125142335891724, 0.125258505344391, 0.125374391674995, 0.125489965081215, 0.125605240464211, 0.125720277428627, 0.12583501636982, 0.125949576497078, 0.126063719391823, 0.126177594065666, 0.126291185617447, 0.126404464244843, 0.126517459750175, 0.126630201935768, 0.126742675900459, 0.126854836940765, 0.126966744661331, 0.127078369259834, 0.127189636230469, 0.127300590276718, 0.127411350607872, 0.127521827816963, 0.127631932497025, 0.127741783857346, 0.127851337194443, 0.127960592508316, 0.12806960940361, 0.128178328275681, 0.128286868333817, 0.1283950060606, 0.128502830862999, 0.128610402345657, 0.128717660903931, 0.128824636340141, 0.128931373357773, 0.129037782549858, 0.129130557179451, 0.129208862781525, 0.129286661744118, 0.129363879561424, 0.129440739750862, 0.129516899585724, 0.129592448472977, 0.129667565226555, 0.129742041230202, 0.129816025495529, 0.129889383912086, 0.129962354898453, 0.130034655332565, 0.130106538534164, 0.130177810788155, 0.130248501896858, 0.130318626761436, 0.130388230085373, 0.13045734167099, 0.130525857210159, 0.130593791604042, 0.130661189556122, 0.130728095769882, 0.130794391036034, 0.130860298871994, 0.130925565958023, 0.130990296602249, 0.13105446100235, 0.131118029356003, 0.131181091070175, 0.131243675947189, 0.131305649876595, 0.131367102265358, 0.131427958607674, 0.13148832321167, 0.131548076868057, 0.131607457995415, 0.131666168570518, 0.131724387407303, 0.131781980395317, 0.131839007139206, 0.131895542144775, 0.131951570510864, 0.132006943225861, 0.132061928510666, 0.132116213440895, 0.132170155644417, 0.13222336769104, 0.132276117801666, 0.1323282122612, 0.132379919290543, 0.132431015372276, 0.132481530308723, 0.132531479001045, 0.132580891251564, 0.132629781961441, 0.132678121328354, 0.13272599875927, 0.132773324847221, 0.132820069789886, 0.132866233587265, 0.132911846041679, 0.132956936955452, 0.133001506328583, 0.133045464754105, 0.133088991045952, 0.133131816983223, 0.133174300193787, 0.133216068148613, 0.133257403969765, 0.133298069238663, 0.133338332176208, 0.133377909660339, 0.133416995406151, 0.13345555961132, 0.133493557572365, 0.133531004190445, 0.133567929267883, 0.133604273200035, 0.133640170097351, 0.133675426244736, 0.133710131049156, 0.133744314312935, 0.133778020739555, 0.133811071515083, 0.133843630552292, 0.133875638246536, 0.133907094597816, 0.13393796980381, 0.133968353271484, 0.133998200297356, 0.134027570486069, 0.13405629992485, 0.13408450782299, 0.134112119674683, 0.134139180183411, 0.134165793657303, 0.134191781282425, 0.134217292070389, 0.13424214720726, 0.134260013699532, 0.134277075529099, 0.134294077754021, 0.134310945868492, 0.134327694773674, 0.134344309568405, 0.134360864758492, 0.134377241134644, 0.134393587708473, 0.134409740567207, 0.134425804018974, 0.134441748261452, 0.134457603096962, 0.134473279118538, 0.134488880634308, 0.134504392743111, 0.13451974093914, 0.134535029530525, 0.134550184011459, 0.134565189480782, 0.134580105543137, 0.134594902396202, 0.134609565138817, 0.134624183177948, 0.134638607501984, 0.134652972221375, 0.134667202830315, 0.134681358933449, 0.134695276618004, 0.134709224104881, 0.134722962975502, 0.134736657142639, 0.13475014269352, 0.134763613343239, 0.134776890277863, 0.13479009270668, 0.134803175926208, 0.134816154837608, 0.134828984737396, 0.134841725230217, 0.134854361414909, 0.134866878390312, 0.134879246354103, 0.134891554713249, 0.134903654456139, 0.134915754199028, 0.134927660226822, 0.134939536452293, 0.134951174259186, 0.134962767362595, 0.134974271059036, 0.134985566139221, 0.134996861219406, 0.135008007287979, 0.135019019246101, 0.135029882192612, 0.135040685534477, 0.135051339864731, 0.135061919689178, 0.135072350502014, 0.135082706809044, 0.135092914104462, 0.135102987289429, 0.13511298596859, 0.135122865438461, 0.13513258099556, 0.135142251849174, 0.135151758790016, 0.135161161422729, 0.135170459747314, 0.135179683566093, 0.135188683867455, 0.135197684168816, 0.13520647585392, 0.135215222835541, 0.135223805904388, 0.135232344269753, 0.13524067401886, 0.135248973965645, 0.135257080197334, 0.135265156626701, 0.135273039340973, 0.135280817747116, 0.135288536548615, 0.135296076536179, 0.13530358672142, 0.135310873389244, 0.135318145155907, 0.135325208306313, 0.135332271456718, 0.135339140892029, 0.13534589111805, 0.135352551937103, 0.135359108448029, 0.135365530848503, 0.135371819138527, 0.135378018021584, 0.135384127497673, 0.135390058159828, 0.135395959019661, 0.135390758514404, 0.135379016399384, 0.135368123650551, 0.135358095169067, 0.135348781943321, 0.135340377688408, 0.135333001613617, 0.135325968265533, 0.13532018661499, 0.135315105319023, 0.135310754179955, 0.135307252407074, 0.135304689407349, 0.135302811861038, 0.135301753878593, 0.135301575064659, 0.135302245616913, 0.135303691029549, 0.135306030511856, 0.135309100151062, 0.135313078761101, 0.13531781733036, 0.135323420166969, 0.13532979786396, 0.135337084531784, 0.135345071554184, 0.135353967547417, 0.135363951325417, 0.135374248027802, 0.135385751724243, 0.135397970676422, 0.135410979390144, 0.135424807667732, 0.135439544916153, 0.135454952716827, 0.135471299290657, 0.135488450527191, 0.135506376624107, 0.135525122284889, 0.135544791817665, 0.135565146803856, 0.135586380958557, 0.135608568787575, 0.135631442070007, 0.13565519452095, 0.135679677128792, 0.135705098509789, 0.135731264948845, 0.135758355259895, 0.135786175727844, 0.135814875364304, 0.135844573378563, 0.135874688625336, 0.135906130075455, 0.13593801856041, 0.135970860719681, 0.136004492640495, 0.136038944125175, 0.136074155569077, 0.136110305786133, 0.136147156357765, 0.136185020208359, 0.136223584413528, 0.136262953281403, 0.136303201317787, 0.136344268918037, 0.136386051774025, 0.136428728699684, 0.136472314596176, 0.136516615748405, 0.136561810970306, 0.13660791516304, 0.136654734611511, 0.136702343821526, 0.13675083220005, 0.136800274252892, 0.136850193142891, 0.136901319026947, 0.136953055858612, 0.13700570166111, 0.137059047818184, 0.137113258242607, 0.13716833293438, 0.137224316596985, 0.137280941009521, 0.137338638305664, 0.13739700615406, 0.137456178665161, 0.137516245245934, 0.137577027082443, 0.137638732790947, 0.137701198458672, 0.137764528393745, 0.13782873749733, 0.137893617153168, 0.137959524989128, 0.138026043772697, 0.138093575835228, 0.138161793351173, 0.138230830430984, 0.138323396444321, 0.138437166810036, 0.138552322983742, 0.138668790459633, 0.138786405324936, 0.138905391097069, 0.139025762677193, 0.139147281646729, 0.139270007610321, 0.139394178986549, 0.139519542455673, 0.139645978808403, 0.139774054288864, 0.13990318775177, 0.140033721923828, 0.140165433287621, 0.14029848575592, 0.140432760119438, 0.140568271279335, 0.140705168247223, 0.140843197703362, 0.140982702374458, 0.141123324632645, 0.1412653028965, 0.141408458352089, 0.141553044319153, 0.141698867082596, 0.14184595644474, 0.141994297504425, 0.142143860459328, 0.142294749617577, 0.142446935176849, 0.142600327730179, 0.142755076289177, 0.142911061644554, 0.143068209290504, 0.143226742744446, 0.143386662006378, 0.143547728657722, 0.143710106611252, 0.143873929977417, 0.144038766622543, 0.144205003976822, 0.144372463226318, 0.144541054964066, 0.144711181521416, 0.144882649183273, 0.145055189728737, 0.145229116082191, 0.145404174923897, 0.145580604672432, 0.145758226513863, 0.145937383174896, 0.146117463707924, 0.146299123764038, 0.146481826901436, 0.14666585624218, 0.14685133099556, 0.147037968039513, 0.147225826978683, 0.147415101528168, 0.14760534465313, 0.147797122597694, 0.147990122437477, 0.148184597492218, 0.148379921913147, 0.148576930165291, 0.148775056004524, 0.148974433541298, 0.149175137281418, 0.149377107620239, 0.149580359458923, 0.149784758687019, 0.149990439414978, 0.150197595357895, 0.150405943393707, 0.150615587830544, 0.150826513767242, 0.151038646697998, 0.151252061128616, 0.151466727256775, 0.151682913303375, 0.151899963617325, 0.152118563652039, 0.152338400483131, 0.152559399604797, 0.15278185904026, 0.153005510568619, 0.153230428695679, 0.15345673263073, 0.153684139251709, 0.15391281247139, 0.154142990708351, 0.15437425673008, 0.154606759548187, 0.154840737581253, 0.155075684189796, 0.15531225502491, 0.155549824237823, 0.155788987874985, 0.156054869294167, 0.156350150704384, 0.156645089387894, 0.156939998269081, 0.157234564423561, 0.157528847455978, 0.157822817564011, 0.15811675786972, 0.15841044485569, 0.158703818917274, 0.158997043967247, 0.15928989648819, 0.159582674503326, 0.159875065088272, 0.160167396068573, 0.160459354519844, 0.160751268267632, 0.1610426902771, 0.161334127187729, 0.161625146865845, 0.161916121840477, 0.162206679582596, 0.16249717772007, 0.162787288427353, 0.163077279925346, 0.163366973400116, 0.163656488060951, 0.163945719599724, 0.164234802126884, 0.164523601531982, 0.16481226682663, 0.165100529789925, 0.165388718247414, 0.165676459670067, 0.165964245796204, 0.166251584887505, 0.166538894176483, 0.166825875639915, 0.16711263358593, 0.16739909350872, 0.167685464024544, 0.167971581220627, 0.168257221579552, 0.168542951345444, 0.168828248977661, 0.169113457202911, 0.169398218393326, 0.169683039188385, 0.169967457652092, 0.170251682400703, 0.170535683631897, 0.170819416642189, 0.171102955937386, 0.171386241912842, 0.17166930437088, 0.171952158212662, 0.172234773635864, 0.172517195343971, 0.172799289226532, 0.173081323504448, 0.173362910747528, 0.173644497990608, 0.17392560839653, 0.174206674098969, 0.174487397074699, 0.174768000841141, 0.175048246979713, 0.175328433513641, 0.175608292222023, 0.175887867808342, 0.176167443394661, 0.176446422934532, 0.176725342869759, 0.177004113793373, 0.177282676100731, 0.177560850977898, 0.177838951349258, 0.178116738796234, 0.178394317626953, 0.178671583533287, 0.17894871532917, 0.179225519299507, 0.179502233862877, 0.179778635501862, 0.18005482852459, 0.180330842733383, 0.180606454610825, 0.18088199198246, 0.181157365441322, 0.181432291865349, 0.181707203388214, 0.181981757283211, 0.182256117463112, 0.182530164718628, 0.182804211974144, 0.183077678084373, 0.183351203799248, 0.183624431490898, 0.183897435665131, 0.184170112013817, 0.184395492076874, 0.184571653604507, 0.184746846556664, 0.184921309351921, 0.185094609856606, 0.185267210006714, 0.185438752174377, 0.185609340667725, 0.185779020190239, 0.185947731137276, 0.186115592718124, 0.186282381415367, 0.186448439955711, 0.186613351106644, 0.18677744269371, 0.186940580606461, 0.1871028393507, 0.187264159321785, 0.18742448091507, 0.187583953142166, 0.187742367386818, 0.18790003657341, 0.18805655837059, 0.188212245702744, 0.188367053866386, 0.188520848751068, 0.188673824071884, 0.188825726509094, 0.188976809382439, 0.189126819372177, 0.189276114106178, 0.18942429125309, 0.189571589231491, 0.189717933535576, 0.18986339867115, 0.190007954835892, 0.190151497721672, 0.190294176340103, 0.190435782074928, 0.19057659804821, 0.190716445446014, 0.190855368971825, 0.190993338823318, 0.191130384802818, 0.191266551613808, 0.191401720046997, 0.191535964608192, 0.19166924059391, 0.191801682114601, 0.191933110356331, 0.192063599824905, 0.192193239927292, 0.192321851849556, 0.192449599504471, 0.192576438188553, 0.192702248692513, 0.192827209830284, 0.192951217293739, 0.193074241280556, 0.193196371197701, 0.193317607045174, 0.19343788921833, 0.19355720281601, 0.193675622344017, 0.193793088197708, 0.19390957057476, 0.194025233387947, 0.194139778614044, 0.194253653287888, 0.19436639547348, 0.194478318095207, 0.194589287042618, 0.19469927251339, 0.194808349013329, 0.194916412234306, 0.195023730397224, 0.195129930973053, 0.195235356688499, 0.19533970952034, 0.195443242788315, 0.195545837283134, 0.195647433400154, 0.195748135447502, 0.195847824215889, 0.195946753025055, 0.196044564247131, 0.196141555905342, 0.196237549185753, 0.196332708001137, 0.196426779031754, 0.196520030498505, 0.196612402796745, 0.19670370221138, 0.19679419696331, 0.196883618831635, 0.19697231054306, 0.197059825062752, 0.1971465498209, 0.197232306003571, 0.197317138314247, 0.197397798299789, 0.197470039129257, 0.197542816400528, 0.197616100311279, 0.197689905762672, 0.197764188051224, 0.197838976979256, 0.197914317250252, 0.197990074753761, 0.198066487908363, 0.198143348097801, 0.198220804333687, 0.198298707604408, 0.198377162218094, 0.198456019163132, 0.198535546660423, 0.198615521192551, 0.198695912957191, 0.198776945471764, 0.198858469724655, 0.198940545320511, 0.199023142457008, 0.19910617172718, 0.1991897970438, 0.199273869395256, 0.199358507990837, 0.199443608522415, 0.199529260396957, 0.199615433812141, 0.199702084064484, 0.199789330363274, 0.199877083301544, 0.199965327978134, 0.200054094195366, 0.200143426656723, 0.200233206152916, 0.200323402881622, 0.200414285063744, 0.200505569577217, 0.200597420334816, 0.200689792633057, 0.200782716274261, 0.200876131653786, 0.200969964265823, 0.201064497232437, 0.201159372925758, 0.201254844665527, 0.201350778341293, 0.201447337865829, 0.201544269919395, 0.201641902327538, 0.201739922165871, 0.201838448643684, 0.201937586069107, 0.202037200331688, 0.202137291431427, 0.202237859368324, 0.202339068055153, 0.202440783381462, 0.202542930841446, 0.202645540237427, 0.202748820185661, 0.202852517366409, 0.202956795692444, 0.203061535954475, 0.203166797757149, 0.203272625803947, 0.203378960490227, 0.203485742211342, 0.203593030571938, 0.203700974583626, 0.203809350728989, 0.20391820371151, 0.204027578234673, 0.204137519001961, 0.204248026013374, 0.204358950257301, 0.204470381140709, 0.204582333564758, 0.204694837331772, 0.204807996749878, 0.204921394586563, 0.205035522580147, 0.205150097608566, 0.205265194177628, 0.205380752682686, 0.20549687743187, 0.205613449215889, 0.205730617046356, 0.205848351120949, 0.2059665620327, 0.20608526468277, 0.206204459071159, 0.206324189901352, 0.206444472074509, 0.206565231084824, 0.206686407327652, 0.206808269023895, 0.20693065226078, 0.207053408026695, 0.20721660554409, 0.207422599196434, 0.207629278302193, 0.207836404442787, 0.208044141530991, 0.208252474665642, 0.208461284637451, 0.208670720458031, 0.20888064801693, 0.209091290831566, 0.209302335977554, 0.209514141082764, 0.209726378321648, 0.209939181804657, 0.210152626037598, 0.210366532206535, 0.210581123828888, 0.210796192288399, 0.211011856794357, 0.211228102445602, 0.211444884538651, 0.211662232875824, 0.211880102753639, 0.212098687887192, 0.212317645549774, 0.212537348270416, 0.212757512927055, 0.212978273630142, 0.21319967508316, 0.213421523571014, 0.213643997907639, 0.213866949081421, 0.214090585708618, 0.214314728975296, 0.214539542794228, 0.214764788746834, 0.214990630745888, 0.215217024087906, 0.215444043278694, 0.215671584010124, 0.215899765491486, 0.21612836420536, 0.216357678174973, 0.216587513685226, 0.216817930340767, 0.217048838734627, 0.217280372977257, 0.217512473464012, 0.217745140194893, 0.217978373169899, 0.218212112784386, 0.218446433544159, 0.218681395053864, 0.218916937708855, 0.219152987003326, 0.219389587640762, 0.219626769423485, 0.219864532351494, 0.220102891325951, 0.220341756939888, 0.220581203699112, 0.220821276307106, 0.221061840653419, 0.221303001046181, 0.221544653177261, 0.221786946058273, 0.222029820084572, 0.222273290157318, 0.222517251968384, 0.222761750221252, 0.223006933927536, 0.2232526242733, 0.223498910665512, 0.223745658993721, 0.223993092775345, 0.22424104809761, 0.224489599466324, 0.22473868727684, 0.224988296627998, 0.225238487124443, 0.225489303469658, 0.225740671157837, 0.225992634892464, 0.226245045661926, 0.226498112082481, 0.226751714944839, 0.227005943655968, 0.22726072371006, 0.227515950798988, 0.227771893143654, 0.228028327226639, 0.22828534245491, 0.228542879223824, 0.228801086544991, 0.229059800505638, 0.229319110512733, 0.229578971862793, 0.229839339852333, 0.230100348591805, 0.230361893773079, 0.230612352490425, 0.230849549174309, 0.231086224317551, 0.231322348117828, 0.231557905673981, 0.231792956590652, 0.232027471065521, 0.232261434197426, 0.232494860887527, 0.232727736234665, 0.232960119843483, 0.233191907405853, 0.233423203229904, 0.233653962612152, 0.233884170651436, 0.234113812446594, 0.23434291779995, 0.234571546316147, 0.234799578785896, 0.235027104616165, 0.235254108905792, 0.235480532050133, 0.235706433653831, 0.235931798815727, 0.236156642436981, 0.236380904912949, 0.236604645848274, 0.236827865242958, 0.237050533294678, 0.237272664904594, 0.237494260072708, 0.237715348601341, 0.237935855984688, 0.238155826926231, 0.238375261425972, 0.238594219088554, 0.238812565803528, 0.239030390977859, 0.239247724413872, 0.239464461803436, 0.23968069255352, 0.239896357059479, 0.240111470222473, 0.240326106548309, 0.240540161728859, 0.240753695368767, 0.240966707468033, 0.241179138422012, 0.241391062736511, 0.241602435708046, 0.2418133020401, 0.242023602128029, 0.242233335971832, 0.242442578077316, 0.242651253938675, 0.242859408259392, 0.243067026138306, 0.243274122476578, 0.243480637669563, 0.243686646223068, 0.243892088532448, 0.244097054004669, 0.244301423430443, 0.244505256414413, 0.244708582758904, 0.244911372661591, 0.245113596320152, 0.245315298438072, 0.245516464114189, 0.245717078447342, 0.245917156338692, 0.2461167126894, 0.246315717697144, 0.246514171361923, 0.2467120885849, 0.246909514069557, 0.247106343507767, 0.247302666306496, 0.247498482465744, 0.247693687677383, 0.247888401150703, 0.248082563281059, 0.248276218771935, 0.248469308018684, 0.24866184592247, 0.248853877186775, 0.249045357108116, 0.249236300587654, 0.249426692724228, 0.249616548418999, 0.249805882573128, 0.249994665384293, 0.250182926654816, 0.250370651483536, 0.25055781006813, 0.250744462013245, 0.250930577516556, 0.251116096973419, 0.251301109790802, 0.251485615968704, 0.251659214496613, 0.251821607351303, 0.251983284950256, 0.25214421749115, 0.252304434776306, 0.25246387720108, 0.252622574567795, 0.252780556678772, 0.252937793731689, 0.25309431552887, 0.253250062465668, 0.253405123949051, 0.25355938076973, 0.253712922334671, 0.253865748643875, 0.25401782989502, 0.254169136285782, 0.254319727420807, 0.254469573497772, 0.254618734121323, 0.254767090082169, 0.254914700984955, 0.255061656236649, 0.255207777023315, 0.255353182554245, 0.255497872829437, 0.255641847848892, 0.255785048007965, 0.255927503108978, 0.256069242954254, 0.25621023774147, 0.256350487470627, 0.256489962339401, 0.256628811359406, 0.256766796112061, 0.256904095411301, 0.257040649652481, 0.257176458835602, 0.257311552762985, 0.257445901632309, 0.257579505443573, 0.257712364196777, 0.257844477891922, 0.257975876331329, 0.258106529712677, 0.258236438035965, 0.258365601301193, 0.258494079113007, 0.258621752262115, 0.258748710155487, 0.258874893188477, 0.259000360965729, 0.259125113487244, 0.259249120950699, 0.259372383356094, 0.25949490070343, 0.259616702795029, 0.259737759828568, 0.259858042001724, 0.259977638721466, 0.260096460580826, 0.260214537382126, 0.260331898927689, 0.260448545217514, 0.260564386844635, 0.260679513216019, 0.260793954133987, 0.260907590389252, 0.261020511388779, 0.261132687330246, 0.261244118213654, 0.261354833841324, 0.261464804410934, 0.261574059724808, 0.261682510375977, 0.261790245771408, 0.261897295713425, 0.262003540992737, 0.262109071016312, 0.262213885784149, 0.262317955493927, 0.262421250343323, 0.262523829936981, 0.26262566447258, 0.262726783752441, 0.262827157974243, 0.262926757335663, 0.26302570104599, 0.26312381029129, 0.263221204280853, 0.263317883014679, 0.263413816690445, 0.263509005308151, 0.26360347867012, 0.263697177171707, 0.263790160417557, 0.263882428407669, 0.263973891735077, 0.264064639806747, 0.264154702425003, 0.264244437217712, 0.264336705207825, 0.264428406953812, 0.264519482851028, 0.264609962701797, 0.264699846506119, 0.264789164066315, 0.264877885580063, 0.264965981245041, 0.265053510665894, 0.265140414237976, 0.265226751565933, 0.26531246304512, 0.265397608280182, 0.265482127666473, 0.26556608080864, 0.26564946770668, 0.265732169151306, 0.265814304351807, 0.265895903110504, 0.265976876020432, 0.266057223081589, 0.266137003898621, 0.266216218471527, 0.266294777393341, 0.26637277007103, 0.266450166702271, 0.266526937484741, 0.266603171825409, 0.266678780317307, 0.266753792762756, 0.266828238964081, 0.266902029514313, 0.266975224018097, 0.267047882080078, 0.267119914293289, 0.267191350460052, 0.26726222038269, 0.267332464456558, 0.267402172088623, 0.267471194267273, 0.267539650201797, 0.267607510089874, 0.267674803733826, 0.267741501331329, 0.267807573080063, 0.267873078584671, 0.267937958240509, 0.268002241849899, 0.268065989017487, 0.268129080533981, 0.268191605806351, 0.26825350522995, 0.268314808607101, 0.26837557554245, 0.268435686826706, 0.268495231866837, 0.268554180860519, 0.268612504005432, 0.268670290708542, 0.268727391958237, 0.268783986568451, 0.268839925527573, 0.268895328044891, 0.26895010471344, 0.269004255533218, 0.269057869911194, 0.269110858440399, 0.269163250923157, 0.269215047359467, 0.269266217947006, 0.269316852092743, 0.269366860389709, 0.269416302442551, 0.269465118646622, 0.269513338804245, 0.269560992717743, 0.269607990980148, 0.269654452800751, 0.269700348377228, 0.26974555850029, 0.269790232181549, 0.269834280014038, 0.269877761602402, 0.269920617341995, 0.269962906837463, 0.270004600286484, 0.270045638084412, 0.270086169242859, 0.270126044750214, 0.270165354013443, 0.270204037427902, 0.270242154598236, 0.270279675722122, 0.270316600799561, 0.270352900028229, 0.270388633012772, 0.270423769950867, 0.270458310842514, 0.270492255687714, 0.270520776510239, 0.270544469356537, 0.270567804574966, 0.27059081196785, 0.270613521337509, 0.270635843276978, 0.2706578373909, 0.270679503679276, 0.270700842142105, 0.270721822977066, 0.270742475986481, 0.270762801170349, 0.270782798528671, 0.270802438259125, 0.27082172036171, 0.270840674638748, 0.270859330892563, 0.270877629518509, 0.270895570516586, 0.270913183689117, 0.270930498838425, 0.270947426557541, 0.270964056253433, 0.270980328321457, 0.270996242761612, 0.271011829376221, 0.271027088165283, 0.271042019128799, 0.271056622266769, 0.271070867776871, 0.271084785461426, 0.271098375320435, 0.271111607551575, 0.271124482154846, 0.271137058734894, 0.271149277687073, 0.271161168813705, 0.271172732114792, 0.27118393778801, 0.271194815635681, 0.271205365657806, 0.271215587854385, 0.271225452423096, 0.27123498916626, 0.271244168281555, 0.271253019571304, 0.271261543035507, 0.271269708871841, 0.271277576684952, 0.271285086870193, 0.271292239427567, 0.271299093961716, 0.271305590867996, 0.27131175994873, 0.271317571401596, 0.271323055028915, 0.271328210830688, 0.271333009004593, 0.271337509155273, 0.271341621875763, 0.271345406770706, 0.271348893642426, 0.271352022886276, 0.271354794502258, 0.271357238292694, 0.271359384059906, 0.271361172199249, 0.271362602710724, 0.27136367559433, 0.271364480257034, 0.271364897489548, 0.271364986896515, 0.271364748477936, 0.271364152431488, 0.271363258361816, 0.271362006664276, 0.271360397338867, 0.271358460187912, 0.271356195211411, 0.271353602409363, 0.271350651979446, 0.271347373723984, 0.271343767642975, 0.27133983373642, 0.271335542201996, 0.271330922842026, 0.271325945854187, 0.27132061123848, 0.271315008401871, 0.271309018135071, 0.271302729845047, 0.271296083927155, 0.271289080381393, 0.271281749010086, 0.271274089813232, 0.271266102790833, 0.271257758140564, 0.271249085664749, 0.271240085363388, 0.271230757236481, 0.271220147609711, 0.271207749843597, 0.271195530891418, 0.271183460950851, 0.271171569824219, 0.27115985751152, 0.271148294210434, 0.271136909723282, 0.271125674247742, 0.271114587783813, 0.271103709936142, 0.271092981100082, 0.271082401275635, 0.271072000265121, 0.27106174826622, 0.271051675081253, 0.271041750907898, 0.271032005548477, 0.271022439002991, 0.271013021469116, 0.271003752946854, 0.270994663238525, 0.270985752344131, 0.270976990461349, 0.270968407392502, 0.270959973335266, 0.270951747894287, 0.270943611860275, 0.27093568444252, 0.270927935838699, 0.270920306444168, 0.270912885665894, 0.270905613899231, 0.270898520946503, 0.270891547203064, 0.270884782075882, 0.270878165960312, 0.270871728658676, 0.270865440368652, 0.270859330892563, 0.270853370428085, 0.270847588777542, 0.270841956138611, 0.270836502313614, 0.270831227302551, 0.270826101303101, 0.270821124315262, 0.270816326141357, 0.270811676979065, 0.270807236433029, 0.270802915096283, 0.270798802375793, 0.270794808864594, 0.27079102396965, 0.270787358283997, 0.2707839012146, 0.270780563354492, 0.270777434110641, 0.27077442407608, 0.270771622657776, 0.270768970251083, 0.270766466856003, 0.270764172077179, 0.270761996507645, 0.270759999752045, 0.270758181810379, 0.270756512880325, 0.270755022764206, 0.270753681659698, 0.270752519369125, 0.270751506090164, 0.270750671625137, 0.270749986171722, 0.270749479532242, 0.270749151706696, 0.270748972892761, 0.270748913288116, 0.270749092102051, 0.270749419927597, 0.270749866962433, 0.270750552415848, 0.270751357078552, 0.270752310752869, 0.270753473043442, 0.270754784345627, 0.270756244659424, 0.270757883787155, 0.270759671926498, 0.270761638879776, 0.270763784646988, 0.270766079425812, 0.270768523216248, 0.27077117562294, 0.270773947238922, 0.270776867866516, 0.270780026912689, 0.270783275365829, 0.270786732435226, 0.270790338516235, 0.270794123411179, 0.270805537700653, 0.27082496881485, 0.270844846963882, 0.270865082740784, 0.270885795354843, 0.270906925201416, 0.270928472280502, 0.27095040678978, 0.270972818136215, 0.270995646715164, 0.271018862724304, 0.271042495965958, 0.271066606044769, 0.271091103553772, 0.27111604809761, 0.271141350269318, 0.271167159080505, 0.271193355321884, 0.271219968795776, 0.271246999502182, 0.271274507045746, 0.271302402019501, 0.271330684423447, 0.271359443664551, 0.271388590335846, 0.271418184041977, 0.271448194980621, 0.271478623151779, 0.27150946855545, 0.271540760993958, 0.271572411060333, 0.27160456776619, 0.271637111902237, 0.271670073270798, 0.271703451871872, 0.271737277507782, 0.271771520376205, 0.271806210279465, 0.271841257810593, 0.271876782178879, 0.271912693977356, 0.271949082612991, 0.271985828876495, 0.272023022174835, 0.272060662508011, 0.272098690271378, 0.272137194871902, 0.272176057100296, 0.272215366363525, 0.272255122661591, 0.272295296192169, 0.272335857152939, 0.272376865148544, 0.272418290376663, 0.272460132837296, 0.272502422332764, 0.272545129060745, 0.272588223218918, 0.272631794214249, 0.272675782442093, 0.272720158100128, 0.272764980792999, 0.272810220718384, 0.272855877876282, 0.272901952266693, 0.272948443889618, 0.272995382547379, 0.273042738437653, 0.273090541362762, 0.273138701915741, 0.273187339305878, 0.273236393928528, 0.273285835981369, 0.273335754871368, 0.273386090993881, 0.273436814546585, 0.273487985134125, 0.273539572954178, 0.273591578006744, 0.273644000291824, 0.273696839809418, 0.273750126361847, 0.27380383014679, 0.273857951164246, 0.273912489414215, 0.273967504501343, 0.274022877216339, 0.274078667163849, 0.274134933948517, 0.274191558361053, 0.274248689413071, 0.274306207895279, 0.274364113807678, 0.274422466754913, 0.274481266736984, 0.274540454149246, 0.274600088596344, 0.274660110473633, 0.274720579385757, 0.274781495332718, 0.274852126836777, 0.274932473897934, 0.275012791156769, 0.275093108415604, 0.275173455476761, 0.275253742933273, 0.275334089994431, 0.275414407253265, 0.2754947245121, 0.275575041770935, 0.27565535902977, 0.275735676288605, 0.275816023349762, 0.275896340608597, 0.275976657867432, 0.276056975126266, 0.276137292385101, 0.276217609643936, 0.276297926902771, 0.276378244161606, 0.276458561420441, 0.276538908481598, 0.276619225740433, 0.276699513196945, 0.276779860258102, 0.276860177516937, 0.276940524578094, 0.277020812034607, 0.277101159095764, 0.277181476354599, 0.277261793613434, 0.277342110872269, 0.277422457933426, 0.277502775192261, 0.277583092451096, 0.27766340970993, 0.277743726968765, 0.2778240442276, 0.277904361486435, 0.277984708547592, 0.278065025806427, 0.278145343065262, 0.278225690126419, 0.278305977582932, 0.278386294841766, 0.278466641902924, 0.278546929359436, 0.278627276420593, 0.278707593679428, 0.278787881135941, 0.278868228197098, 0.278948545455933, 0.27902889251709, 0.279109179973602, 0.27918952703476, 0.279269844293594, 0.279350161552429, 0.279430478811264, 0.279510796070099, 0.279591113328934, 0.279671430587769, 0.279751747846603, 0.279832094907761, 0.279912412166595, 0.27999272942543, 0.280073046684265, 0.2801533639431, 0.280233711004257, 0.280314028263092, 0.280394345521927, 0.280474662780762, 0.280554980039597, 0.280635297298431, 0.280715614557266, 0.280795961618423, 0.280876249074936, 0.280956596136093, 0.281036913394928, 0.281117230653763, 0.281197547912598, 0.281277865171432, 0.28135821223259, 0.281438499689102, 0.281518846750259, 0.281599164009094, 0.281679481267929, 0.281759798526764, 0.281840115785599, 0.281920433044434, 0.282000780105591, 0.282081067562103, 0.28216141462326, 0.282241731882095, 0.28232204914093, 0.282402366399765, 0.2824826836586, 0.282563030719757, 0.28264331817627, 0.282723665237427, 0.282803982496262, 0.282874137163162, 0.282933980226517, 0.282993406057358, 0.283052444458008, 0.283111095428467, 0.28316929936409, 0.283227175474167, 0.283284574747086, 0.283341616392136, 0.283398240804672, 0.283454447984695, 0.28351029753685, 0.283565700054169, 0.283620715141296, 0.283675342798233, 0.283729583024979, 0.283783376216888, 0.28383681178093, 0.283889800310135, 0.283942401409149, 0.283994615077972, 0.284046411514282, 0.284097850322723, 0.284148842096329, 0.284199446439743, 0.284249663352966, 0.284299433231354, 0.284348845481873, 0.284397840499878, 0.28444641828537, 0.284494608640671, 0.284542411565781, 0.284589797258377, 0.284636795520782, 0.284683406352997, 0.284729570150375, 0.284775346517563, 0.284820735454559, 0.284865736961365, 0.284910291433334, 0.284954458475113, 0.2849982380867, 0.285041630268097, 0.285084575414658, 0.28512716293335, 0.285169333219528, 0.285211086273193, 0.285252451896667, 0.285293430089951, 0.285334020853043, 0.285374164581299, 0.285413920879364, 0.285453289747238, 0.285492241382599, 0.285530775785446, 0.285568952560425, 0.285606682300568, 0.285644024610519, 0.28568097949028, 0.28571754693985, 0.285753697156906, 0.285789400339127, 0.285824745893478, 0.285859704017639, 0.285894244909286, 0.285928398370743, 0.285962104797363, 0.285995453596115, 0.286028355360031, 0.286060929298401, 0.286093056201935, 0.286124765872955, 0.286156088113785, 0.286187022924423, 0.286217540502548, 0.286247670650482, 0.286277383565903, 0.286306709051132, 0.286335617303848, 0.286364108324051, 0.286392241716385, 0.286419957876205, 0.286447256803513, 0.286474168300629, 0.286500662565231, 0.286526769399643, 0.286552488803864, 0.286577790975571, 0.286602705717087, 0.286627203226089, 0.286651283502579, 0.286675006151199, 0.286698281764984, 0.286721140146255, 0.286743640899658, 0.28676575422287, 0.286787420511246, 0.286808699369431, 0.286829620599747, 0.286850064992905, 0.286865204572678, 0.286875039339066, 0.286884695291519, 0.286894142627716, 0.286903381347656, 0.28691241145134, 0.286921232938766, 0.286929875612259, 0.286938309669495, 0.286946535110474, 0.286954581737518, 0.286962389945984, 0.286970019340515, 0.286977469921112, 0.28698468208313, 0.286991715431213, 0.28699854016304, 0.28700515627861, 0.287011593580246, 0.287017822265625, 0.287023842334747, 0.287029653787613, 0.287035286426544, 0.287040710449219, 0.287045925855637, 0.28705096244812, 0.287055760622025, 0.287060379981995, 0.287064790725708, 0.287069022655487, 0.287073045969009, 0.287076860666275, 0.287080466747284, 0.287083894014359, 0.287087112665176, 0.287090092897415, 0.287092924118042, 0.28709551692009, 0.287097930908203, 0.287100166082382, 0.287102162837982, 0.287103980779648, 0.287105560302734, 0.287106990814209, 0.287108182907104, 0.287109196186066, 0.28711000084877, 0.287110596895218, 0.287110984325409, 0.287111192941666, 0.287111192941666, 0.287110984325409, 0.287110596895218, 0.28711000084877, 0.287109196186066, 0.287108182907104, 0.287106990814209, 0.287105590105057, 0.287103980779648, 0.287102162837982, 0.287100166082382, 0.287097960710526, 0.287095546722412, 0.287092924118042, 0.287090122699738, 0.287087112665176, 0.287083894014359, 0.287080466747284, 0.287076860666275, 0.287073045969009, 0.287069052457809, 0.28706482052803, 0.287060379981995, 0.287055760622025, 0.28705096244812, 0.287045955657959, 0.287040740251541, 0.287035286426544, 0.287029683589935, 0.287023842334747, 0.287017822265625, 0.287011563777924, 0.28700515627861, 0.28699854016304, 0.286991715431213, 0.28698468208313, 0.28697744011879, 0.286970019340515, 0.286962419748306, 0.286954581737518, 0.286946505308151, 0.286938279867172, 0.286929875612259, 0.286921232938766, 0.286912381649017, 0.286903381347656, 0.286894142627716, 0.286884665489197, 0.286875039339066, 0.286865204572678, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.286860197782516, 0.28685450553894, 0.286843240261078, 0.286832213401794, 0.286821454763412, 0.286810904741287, 0.286800563335419, 0.286790490150452, 0.286780595779419, 0.286770969629288, 0.286761552095413, 0.286752372980118, 0.286743402481079, 0.286734700202942, 0.286726236343384, 0.28671795129776, 0.286709934473038, 0.286702126264572, 0.286694526672363, 0.286687195301056, 0.286680102348328, 0.286673218011856, 0.286666542291641, 0.286660134792328, 0.286653906106949, 0.286647945642471, 0.286642223596573, 0.286636710166931, 0.286631435155869, 0.286626398563385, 0.286621570587158, 0.28661698102951, 0.286612629890442, 0.28660848736763, 0.286604583263397, 0.286600917577744, 0.286597460508347, 0.286594271659851, 0.28659126162529, 0.286588549613953, 0.286585986614227, 0.286583691835403, 0.286581635475159, 0.286579787731171, 0.286578178405762, 0.286576807498932, 0.286575675010681, 0.286574751138687, 0.286574065685272, 0.286573588848114, 0.286573380231857, 0.286573380231857, 0.286573588848114, 0.286574065685272, 0.286574751138687, 0.286575675010681, 0.286576807498932, 0.286578178405762, 0.286579787731171, 0.286581635475159, 0.286583691835403, 0.286585986614227, 0.286588549613953, 0.28659126162529, 0.286594271659851, 0.286597460508347, 0.286600917577744, 0.286604583263397, 0.28660848736763, 0.286612629890442, 0.28661698102951, 0.286621570587158, 0.286626398563385, 0.286631435155869, 0.286636710166931, 0.286642223596573, 0.286647945642471, 0.286653906106949, 0.286660104990005, 0.286666542291641, 0.286673218011856, 0.286680102348328, 0.286687195301056, 0.286694526672363, 0.286702126264572, 0.286709934473038, 0.28671795129776, 0.286726236343384, 0.286734700202942, 0.286743402481079, 0.286752372980118, 0.286761552095413, 0.286770969629288, 0.286780595779419, 0.286790490150452, 0.286800563335419, 0.286810904741287, 0.286821454763412, 0.286832213401794, 0.286843240261078, 0.286854475736618, 0.286867648363113, 0.286882966756821, 0.28689894080162, 0.286915510892868, 0.286932706832886, 0.286950528621674, 0.286968946456909, 0.28698804974556, 0.287007749080658, 0.287028044462204, 0.28704896569252, 0.287070572376251, 0.287092745304108, 0.287115573883057, 0.287138998508453, 0.28716304898262, 0.28718775510788, 0.287213057279587, 0.287238985300064, 0.287265509366989, 0.287292718887329, 0.287320524454117, 0.287348926067352, 0.287378013134003, 0.287407696247101, 0.287437975406647, 0.287468910217285, 0.287500441074371, 0.28753262758255, 0.287565439939499, 0.287598848342896, 0.287632882595062, 0.287667542695999, 0.287702828645706, 0.287738770246506, 0.287775307893753, 0.287812441587448, 0.287850230932236, 0.287888646125793, 0.287927687168121, 0.287967354059219, 0.288007616996765, 0.288048535585403, 0.288090080022812, 0.288132220506668, 0.288174986839294, 0.288218408823013, 0.28826242685318, 0.288307070732117, 0.288352340459824, 0.288398265838623, 0.28844478726387, 0.288491934537888, 0.288539677858353, 0.28858807682991, 0.288637101650238, 0.288686752319336, 0.288736999034882, 0.28878790140152, 0.288839399814606, 0.288891553878784, 0.28894430398941, 0.288997709751129, 0.289051711559296, 0.289106339216232, 0.289161592721939, 0.289217472076416, 0.289273977279663, 0.28933110833168, 0.289388865232468, 0.289447218179703, 0.28950622677803, 0.289565861225128, 0.289626091718674, 0.289686948060989, 0.289748460054398, 0.289810597896576, 0.289873361587524, 0.289936691522598, 0.290000677108765, 0.290065318346024, 0.29013055562973, 0.290196418762207, 0.290262907743454, 0.290330022573471, 0.290397733449936, 0.290466129779816, 0.290535062551498, 0.290604680776596, 0.290674924850464, 0.290745794773102, 0.290817260742188, 0.290889352560043, 0.290962100028992, 0.291035443544388, 0.291109412908554, 0.29118400812149, 0.291259229183197, 0.291335076093674, 0.291411548852921, 0.291503727436066, 0.291611522436142, 0.291719675064087, 0.291828155517578, 0.291936993598938, 0.292046189308167, 0.292155712842941, 0.292265594005585, 0.292375802993774, 0.292486369609833, 0.292597323656082, 0.292708575725555, 0.292820185422897, 0.292932152748108, 0.293044477701187, 0.29315710067749, 0.293270111083984, 0.293383449316025, 0.293497145175934, 0.293611168861389, 0.293725579977036, 0.293840259313583, 0.293955415487289, 0.294070810079575, 0.294186592102051, 0.294302701950073, 0.294419169425964, 0.294535994529724, 0.29465314745903, 0.294770628213882, 0.294888466596603, 0.295006692409515, 0.295125246047974, 0.295244097709656, 0.295363366603851, 0.295482963323593, 0.295602887868881, 0.295723140239716, 0.295843809843063, 0.295964747667313, 0.296086043119431, 0.296207696199417, 0.296329766511917, 0.296452134847641, 0.296574831008911, 0.29669788479805, 0.296821266412735, 0.296945035457611, 0.297069042921066, 0.29719352722168, 0.297318309545517, 0.297443449497223, 0.297568917274475, 0.297694742679596, 0.297820895910263, 0.297947436571121, 0.298074305057526, 0.298201501369476, 0.298329025506973, 0.298456996679306, 0.29858523607254, 0.298713803291321, 0.29884272813797, 0.298972070217133, 0.299101680517197, 0.299231678247452, 0.299361974000931, 0.299492657184601, 0.29962369799614, 0.299755066633224, 0.299886763095856, 0.300018817186356, 0.300151258707047, 0.300284057855606, 0.300417125225067, 0.300550609827042, 0.300684362649918, 0.300818502902985, 0.30095300078392, 0.301087826490402, 0.301223039627075, 0.301358550786972, 0.30149444937706, 0.301630675792694, 0.301767230033875, 0.301904141902924, 0.302041411399841, 0.302179038524628, 0.302316933870316, 0.302455276250839, 0.302593916654587, 0.302732884883881, 0.302872240543365, 0.303011953830719, 0.303151994943619, 0.303292363882065, 0.303433060646057, 0.303574174642563, 0.303715586662292, 0.303857326507568, 0.303999722003937, 0.304142236709595, 0.304284185171127, 0.304425597190857, 0.304566442966461, 0.304706752300262, 0.304846465587616, 0.304985612630844, 0.305124253034592, 0.305262297391891, 0.305399805307388, 0.30553674697876, 0.305673122406006, 0.305808991193771, 0.305944204330444, 0.306078970432281, 0.306213110685349, 0.30634668469429, 0.306479752063751, 0.306612223386765, 0.306744158267975, 0.30687552690506, 0.307006359100342, 0.307136625051498, 0.30726632475853, 0.307395458221436, 0.307524055242538, 0.307652056217194, 0.307779520750046, 0.307906478643417, 0.308032840490341, 0.30815863609314, 0.308283895254135, 0.308408588171005, 0.308532744646072, 0.308656275272369, 0.308779269456863, 0.308901757001877, 0.309023678302765, 0.30914506316185, 0.309265792369843, 0.309386044740677, 0.309505730867386, 0.309624850749969, 0.309743404388428, 0.309861391782761, 0.309978842735291, 0.310095757246017, 0.310212105512619, 0.310327857732773, 0.310443073511124, 0.310557752847672, 0.310671865940094, 0.310785412788391, 0.310898423194885, 0.311010837554932, 0.311122685670853, 0.311234027147293, 0.311344772577286, 0.311454981565475, 0.311564683914185, 0.311673790216446, 0.311782270669937, 0.311890244483948, 0.311997681856155, 0.312104552984238, 0.312210828065872, 0.312316626310349, 0.312421828508377, 0.31252646446228, 0.312630534172058, 0.312734067440033, 0.312837064266205, 0.312939435243607, 0.313041269779205, 0.313142597675323, 0.313243329524994, 0.313343495130539, 0.313443124294281, 0.31354221701622, 0.313640743494034, 0.3137386739254, 0.313836097717285, 0.313932955265045, 0.314029186964035, 0.314124912023544, 0.314220100641251, 0.314314693212509, 0.314408749341965, 0.314502269029617, 0.314595192670822, 0.314687579870224, 0.314779430627823, 0.314870715141296, 0.314961403608322, 0.315051555633545, 0.315141141414642, 0.315230190753937, 0.315318673849106, 0.315406620502472, 0.315484941005707, 0.315552353858948, 0.315618634223938, 0.315683811903, 0.315747886896133, 0.315810889005661, 0.315872758626938, 0.315933525562286, 0.315993189811707, 0.316051751375198, 0.316109240055084, 0.316165596246719, 0.316220849752426, 0.316275030374527, 0.316328078508377, 0.316380053758621, 0.316430926322937, 0.316480666399002, 0.316529333591461, 0.316576838493347, 0.31662330031395, 0.316668629646301, 0.316712886095047, 0.316756039857864, 0.316798090934753, 0.316839009523392, 0.316878855228424, 0.316917598247528, 0.316955208778381, 0.316991776227951, 0.317027151584625, 0.317061483860016, 0.317094713449478, 0.31712681055069, 0.31715789437294, 0.317187756299973, 0.317216575145721, 0.317244321107864, 0.317270904779434, 0.31729644536972, 0.317320823669434, 0.317344129085541, 0.317366302013397, 0.31738743185997, 0.317407429218292, 0.317426323890686, 0.317444115877151, 0.317460864782333, 0.317476391792297, 0.3174909055233, 0.317504316568375, 0.317516595125198, 0.317527741193771, 0.317537814378738, 0.317546844482422, 0.317554712295532, 0.317561477422714, 0.31756716966629, 0.317571729421616, 0.317575216293335, 0.317577570676804, 0.317578852176666, 0.317579001188278, 0.317578047513962, 0.317575991153717, 0.317572832107544, 0.317568629980087, 0.317563265562057, 0.317556798458099, 0.31754931807518, 0.317540615797043, 0.317530900239944, 0.317519992589951, 0.317508041858673, 0.317494988441467, 0.317480802536011, 0.317465543746948, 0.317449152469635, 0.317431718111038, 0.317413151264191, 0.317393481731415, 0.317372679710388, 0.317350834608078, 0.317327827215195, 0.317303776741028, 0.317278563976288, 0.317252278327942, 0.31722491979599, 0.317196398973465, 0.317166805267334, 0.317136108875275, 0.317104339599609, 0.317071437835693, 0.317037463188171, 0.317002326250076, 0.316966116428375, 0.316928803920746, 0.31689041852951, 0.316850930452347, 0.316810309886932, 0.316755652427673, 0.316687613725662, 0.316618770360947, 0.316549211740494, 0.316478908061981, 0.316407829523087, 0.316336005926132, 0.316263377666473, 0.316190004348755, 0.316115915775299, 0.316041052341461, 0.315965414047241, 0.315889000892639, 0.315811902284622, 0.315733969211578, 0.315655320882797, 0.315575927495956, 0.315495729446411, 0.315414816141129, 0.315333098173141, 0.315250635147095, 0.315167427062988, 0.315083473920822, 0.314998775720596, 0.314913272857666, 0.314827024936676, 0.314740061759949, 0.314652293920517, 0.314563781023026, 0.314474523067474, 0.314384490251541, 0.314293682575226, 0.314202159643173, 0.314109861850739, 0.314016789197922, 0.313923001289368, 0.313828408718109, 0.313733071088791, 0.313637018203735, 0.313540130853653, 0.313442528247833, 0.313344180583954, 0.313245058059692, 0.313145190477371, 0.31304457783699, 0.312943160533905, 0.31284099817276, 0.312738090753555, 0.312634438276291, 0.312530010938644, 0.312424838542938, 0.312318861484528, 0.312212198972702, 0.312104761600494, 0.31199648976326, 0.31188753247261, 0.311777830123901, 0.31166735291481, 0.311556130647659, 0.311444073915482, 0.311331301927567, 0.311217784881592, 0.31110355257988, 0.310988485813141, 0.310872733592987, 0.310756206512451, 0.310638874769211, 0.310520797967911, 0.310401976108551, 0.310282379388809, 0.310162037611008, 0.310040920972824, 0.309919118881226, 0.3097964823246, 0.309673100709915, 0.309549003839493, 0.309424102306366, 0.309298515319824, 0.309172093868256, 0.309044897556305, 0.308917015790939, 0.308788299560547, 0.308658868074417, 0.308528691530228, 0.308397769927979, 0.308266043663025, 0.308133631944656, 0.308000355958939, 0.307866394519806, 0.307731688022614, 0.307596176862717, 0.307459890842438, 0.307322919368744, 0.307185143232346, 0.307046622037888, 0.306907325983047, 0.306767284870148, 0.306626498699188, 0.306484937667847, 0.306342631578445, 0.306194305419922, 0.306044071912766, 0.305894076824188, 0.30574432015419, 0.305594861507416, 0.305445581674576, 0.30529659986496, 0.305147856473923, 0.304999321699142, 0.304851055145264, 0.304702997207642, 0.304555237293243, 0.304407745599747, 0.304260462522507, 0.304113388061523, 0.303966611623764, 0.303820073604584, 0.303673774003983, 0.303527683019638, 0.303381890058517, 0.303236335515976, 0.303091019392014, 0.302945971488953, 0.302801132202148, 0.302656561136246, 0.302512258291245, 0.3023681640625, 0.302224338054657, 0.302080690860748, 0.301937401294708, 0.301794320344925, 0.301651477813721, 0.301508873701096, 0.30136650800705, 0.301224380731583, 0.301082491874695, 0.300940901041031, 0.300799489021301, 0.300658375024796, 0.300517529249191, 0.300376921892166, 0.300236493349075, 0.300096333026886, 0.299956411123276, 0.299816787242889, 0.29967737197876, 0.299538254737854, 0.299399316310883, 0.299260646104813, 0.299122244119644, 0.298984080553055, 0.2988460958004, 0.298708438873291, 0.298571020364761, 0.298433810472488, 0.298296898603439, 0.298160195350647, 0.298023760318756, 0.297887533903122, 0.297751605510712, 0.297615885734558, 0.297480374574661, 0.297345191240311, 0.297210216522217, 0.297075510025024, 0.296941041946411, 0.296806782484055, 0.296672791242599, 0.296539038419724, 0.296405553817749, 0.296272307634354, 0.296139270067215, 0.296006560325623, 0.295874029397964, 0.295741766691208, 0.29560974240303, 0.295478016138077, 0.29534649848938, 0.29521518945694, 0.295084148645401, 0.294953346252441, 0.294822812080383, 0.294692546129227, 0.294562488794327, 0.294432699680328, 0.294303119182587, 0.294173836708069, 0.294044762849808, 0.293915927410126, 0.293787389993668, 0.293659031391144, 0.293530970811844, 0.293403178453445, 0.293275564908981, 0.293148219585419, 0.293021142482758, 0.292894273996353, 0.292767643928528, 0.292641311883926, 0.292515218257904, 0.292409151792526, 0.292320787906647, 0.292233049869537, 0.292145967483521, 0.292059570550919, 0.291973859071732, 0.291888773441315, 0.291804373264313, 0.291720598936081, 0.291637539863586, 0.291555106639862, 0.29147332906723, 0.291392236948013, 0.291311830282211, 0.291232019662857, 0.29115292429924, 0.291074454784393, 0.290996670722961, 0.290919572114944, 0.290843099355698, 0.290767282247543, 0.290692150592804, 0.290617644786835, 0.290543854236603, 0.290470659732819, 0.290398180484772, 0.290326356887817, 0.290255188941956, 0.290184676647186, 0.290114849805832, 0.29004567861557, 0.289977133274078, 0.289909273386002, 0.289842069149017, 0.289775550365448, 0.289709687232971, 0.289644479751587, 0.289579957723618, 0.289516031742096, 0.289452821016312, 0.28939026594162, 0.289328336715698, 0.289267122745514, 0.289206564426422, 0.2891466319561, 0.289087384939194, 0.289028853178024, 0.288970857858658, 0.288913607597351, 0.288857042789459, 0.288801103830338, 0.288745790719986, 0.288691163063049, 0.28863725066185, 0.288583964109421, 0.288531333208084, 0.28847935795784, 0.288428068161011, 0.288377434015274, 0.28832745552063, 0.288278102874756, 0.288229465484619, 0.288181483745575, 0.288134157657623, 0.288087487220764, 0.288041472434998, 0.287996113300323, 0.287951439619064, 0.287907421588898, 0.287864059209824, 0.287821352481842, 0.287779331207275, 0.287737965583801, 0.287697285413742, 0.287657231092453, 0.287617832422256, 0.287579089403152, 0.287541061639786, 0.287503629922867, 0.287466913461685, 0.287430822849274, 0.287395447492599, 0.287360668182373, 0.287326604127884, 0.287293136119843, 0.287260413169861, 0.287228286266327, 0.287196844816208, 0.287166118621826, 0.287135988473892, 0.287106543779373, 0.287077724933624, 0.28704959154129, 0.287022143602371, 0.286995351314545, 0.286969214677811, 0.286943703889847, 0.28691890835762, 0.286894768476486, 0.286871284246445, 0.286858171224594, 0.286852777004242, 0.28684738278389, 0.286841988563538, 0.286836564540863, 0.286831140518188, 0.286825746297836, 0.286820322275162, 0.286814898252487, 0.286809414625168, 0.286803990602493, 0.286798536777496, 0.286793082952499, 0.286787629127502, 0.286782115697861, 0.286776661872864, 0.286771148443222, 0.286765694618225, 0.286760151386261, 0.286754608154297, 0.286749124526978, 0.286743581295013, 0.286738067865372, 0.286732494831085, 0.286726981401443, 0.286721438169479, 0.286715865135193, 0.286710292100906, 0.286704689264297, 0.286699086427689, 0.286693543195724, 0.286687910556793, 0.286682307720184, 0.286676704883575, 0.286671072244644, 0.286665469408035, 0.286659836769104, 0.286654144525528, 0.286648541688919, 0.286642879247665, 0.286637216806412, 0.286631524562836, 0.286625862121582, 0.286620199680328, 0.28661447763443, 0.286608785390854, 0.286603093147278, 0.286597371101379, 0.286591649055481, 0.28658589720726, 0.286580204963684, 0.286574453115463, 0.28656867146492, 0.286562949419022, 0.286557167768478, 0.286551386117935, 0.286545604467392, 0.286539852619171, 0.286534041166306, 0.28652822971344, 0.286522448062897, 0.286516606807709, 0.286510795354843, 0.286504983901978, 0.28649914264679, 0.286493301391602, 0.286487489938736, 0.286481589078903, 0.286475718021393, 0.286469876766205, 0.286463975906372, 0.286458104848862, 0.286452203989029, 0.286446303129196, 0.286440372467041, 0.286434501409531, 0.286428540945053, 0.286422610282898, 0.286416679620743, 0.286410748958588, 0.286404818296432, 0.286398828029633, 0.286392867565155, 0.286386936903, 0.286380916833878, 0.2863749563694, 0.286368936300278, 0.286362946033478, 0.286356925964355, 0.286350935697556, 0.286344915628433, 0.286338865756989, 0.286332845687866, 0.286326825618744, 0.286320745944977, 0.286314696073532, 0.286308616399765, 0.28630256652832, 0.286296486854553, 0.286290377378464, 0.286281168460846, 0.28627011179924, 0.286258220672607, 0.286245346069336, 0.286231487989426, 0.286216765642166, 0.286201000213623, 0.286184340715408, 0.2861667573452, 0.28614816069603, 0.28612869977951, 0.286108255386353, 0.286086797714233, 0.286064505577087, 0.286041170358658, 0.286016911268234, 0.285991787910461, 0.285965621471405, 0.285938560962677, 0.285910546779633, 0.285881549119949, 0.28585159778595, 0.285820811986923, 0.285788953304291, 0.285756200551987, 0.285722494125366, 0.285687834024429, 0.285652250051498, 0.285615682601929, 0.285578191280365, 0.285539776086807, 0.285500377416611, 0.285460025072098, 0.285418778657913, 0.28537654876709, 0.285333335399628, 0.285289257764816, 0.285244196653366, 0.285198152065277, 0.285151243209839, 0.285103321075439, 0.285054445266724, 0.285004675388336, 0.28495392203331, 0.28490224480629, 0.284849613904953, 0.284795999526978, 0.28474149107933, 0.284686028957367, 0.284629553556442, 0.284572243690491, 0.284513920545578, 0.284454613924026, 0.284394443035126, 0.284333229064941, 0.284271150827408, 0.284208118915558, 0.284144103527069, 0.284079194068909, 0.284013271331787, 0.283946394920349, 0.283878654241562, 0.283809900283813, 0.283740252256393, 0.283669650554657, 0.283598035573959, 0.283525496721268, 0.283452063798904, 0.28337761759758, 0.283302277326584, 0.283226013183594, 0.283148735761642, 0.283070504665375, 0.28299143910408, 0.282911270856857, 0.282830238342285, 0.282748311758041, 0.282665312290192, 0.28258141875267, 0.282496631145477, 0.282410860061646, 0.282324194908142, 0.282236516475677, 0.282147884368896, 0.282058358192444, 0.28196781873703, 0.281876355409622, 0.281783998012543, 0.281690657138824, 0.281596332788467, 0.281501114368439, 0.281404912471771, 0.28130778670311, 0.281209707260132, 0.28111070394516, 0.281010717153549, 0.280909806489944, 0.280807912349701, 0.280705183744431, 0.280601382255554, 0.280476301908493, 0.280327647924423, 0.280178010463715, 0.28002741932869, 0.279875934123993, 0.279723435640335, 0.279570043087006, 0.27941569685936, 0.279260396957397, 0.279104113578796, 0.278946936130524, 0.278788805007935, 0.278629660606384, 0.278469681739807, 0.278308659791946, 0.278146743774414, 0.277983844280243, 0.277819991111755, 0.277655273675919, 0.277489542961121, 0.277322858572006, 0.27715528011322, 0.276986688375473, 0.276817172765732, 0.276646763086319, 0.276475340127945, 0.276302963495255, 0.276129722595215, 0.275955438613892, 0.275780320167542, 0.275604158639908, 0.275427043437958, 0.275249093770981, 0.27507010102272, 0.274890154600143, 0.274709314107895, 0.274527490139008, 0.274344712495804, 0.274161040782928, 0.273976385593414, 0.273790746927261, 0.273604243993759, 0.273416727781296, 0.273228317499161, 0.273038953542709, 0.272848576307297, 0.272657334804535, 0.272465109825134, 0.272271931171417, 0.272077798843384, 0.271882742643356, 0.271686732769012, 0.271489799022675, 0.271291881799698, 0.271093010902405, 0.27089324593544, 0.270692437887192, 0.270490735769272, 0.27028813958168, 0.27008455991745, 0.269879996776581, 0.26967453956604, 0.269468128681183, 0.269260793924332, 0.269052445888519, 0.268843144178391, 0.268632978200912, 0.268421798944473, 0.26820969581604, 0.26799663901329, 0.267782628536224, 0.267567694187164, 0.26735183596611, 0.267134964466095, 0.266917139291763, 0.266698449850082, 0.266478806734085, 0.266258150339127, 0.266036570072174, 0.265814065933228, 0.265590578317642, 0.265366196632385, 0.265140861272812, 0.2649145424366, 0.264687240123749, 0.264459073543549, 0.26422992348671, 0.263999879360199, 0.263768821954727, 0.263536870479584, 0.263303875923157, 0.263070046901703, 0.262835204601288, 0.262599468231201, 0.262362778186798, 0.262125045061111, 0.261886417865753, 0.261646896600723, 0.261406362056732, 0.261164903640747, 0.260913878679276, 0.260648965835571, 0.260384291410446, 0.260120034217834, 0.259856224060059, 0.259592831134796, 0.259329676628113, 0.259066939353943, 0.258804619312286, 0.258542627096176, 0.258280903100967, 0.258019745349884, 0.257758855819702, 0.257498413324356, 0.257238239049911, 0.25697848200798, 0.256719172000885, 0.256460100412369, 0.256201505661011, 0.255943268537521, 0.255685359239578, 0.255427837371826, 0.255170673131943, 0.254913985729218, 0.254657506942749, 0.254401564598083, 0.254145860671997, 0.253890603780746, 0.253635674715042, 0.253381133079529, 0.253127008676529, 0.252873152494431, 0.25261989235878, 0.252366870641708, 0.252114176750183, 0.251861870288849, 0.251609981060028, 0.251358389854431, 0.25110724568367, 0.25085636973381, 0.250605940818787, 0.250355869531631, 0.250106275081635, 0.249856904149055, 0.249608010053635, 0.249359503388405, 0.249111294746399, 0.248863473534584, 0.248615995049477, 0.248368933796883, 0.248122230172157, 0.247875943779945, 0.247629925608635, 0.247384369373322, 0.247139140963554, 0.246894314885139, 0.246649831533432, 0.24640579521656, 0.246162042021751, 0.245918810367584, 0.245675846934319, 0.24543322622776, 0.245190963149071, 0.244949117302895, 0.244707673788071, 0.244466528296471, 0.244225800037384, 0.243985429406166, 0.243745476007462, 0.243505820631981, 0.243266552686691, 0.243027731776237, 0.242789298295975, 0.242551177740097, 0.24231344461441, 0.242076054215431, 0.241839036345482, 0.241602391004562, 0.241366162896156, 0.241130277514458, 0.240894719958305, 0.240659564733505, 0.240424796938896, 0.240190401673317, 0.23995640873909, 0.239722713828087, 0.239489570260048, 0.239256635308266, 0.239024117588997, 0.238791987299919, 0.23856021463871, 0.23832879960537, 0.238097742199898, 0.237867042422295, 0.237636744976044, 0.237406849861145, 0.237177282571793, 0.23694808781147, 0.236719325184822, 0.236490949988365, 0.236295059323311, 0.236129552125931, 0.235965058207512, 0.235801383852959, 0.235638692975044, 0.23547688126564, 0.235316053032875, 0.235156059265137, 0.23499707877636, 0.234838873147964, 0.234681725502014, 0.234525367617607, 0.234370023012161, 0.234215676784515, 0.234062179923058, 0.233909547328949, 0.233757898211479, 0.233607068657875, 0.233457237482071, 0.2333083152771, 0.233160257339478, 0.233013153076172, 0.232866987586021, 0.232721701264381, 0.232577323913574, 0.2324338555336, 0.232291474938393, 0.232149839401245, 0.23200923204422, 0.231869414448738, 0.231730610132217, 0.231592684984207, 0.23145566880703, 0.23131962120533, 0.231184437870979, 0.231050178408623, 0.230916872620583, 0.230784386396408, 0.230652913451195, 0.230522289872169, 0.230392754077911, 0.230263948440552, 0.230136141180992, 0.230009272694588, 0.229883268475533, 0.22975817322731, 0.229634001851082, 0.229510843753815, 0.229388490319252, 0.229267075657845, 0.229146599769592, 0.229027032852173, 0.228908374905586, 0.228790819644928, 0.228673905134201, 0.228557989001274, 0.228443011641502, 0.228328973054886, 0.228215843439102, 0.228103637695312, 0.227992326021194, 0.227881923317909, 0.227772459387779, 0.227663919329643, 0.22755628824234, 0.227449595928192, 0.227343767881393, 0.227239057421684, 0.227135017514229, 0.227031975984573, 0.22692982852459, 0.226828634738922, 0.226728305220604, 0.226629003882408, 0.226530477404594, 0.226433008909225, 0.226336404681206, 0.226240634918213, 0.226145878434181, 0.226052060723305, 0.225959166884422, 0.225867137312889, 0.225776016712189, 0.225685849785805, 0.225596517324448, 0.225508213043213, 0.225420743227005, 0.225334256887436, 0.225248634815216, 0.225163921713829, 0.225080236792564, 0.224997356534004, 0.224915400147438, 0.224834442138672, 0.224754378199577, 0.224675253033638, 0.224597007036209, 0.224519640207291, 0.224443152546883, 0.224367663264275, 0.224287047982216, 0.22421407699585, 0.224141359329224, 0.224068820476532, 0.223996445536613, 0.223924294114113, 0.223852351307869, 0.223780646920204, 0.223709106445312, 0.223637729883194, 0.223566606640816, 0.223495677113533, 0.223424896597862, 0.223354384303093, 0.223284035921097, 0.223213896155357, 0.223143994808197, 0.223074242472649, 0.223004668951035, 0.222935363650322, 0.222866237163544, 0.222797363996506, 0.222728550434113, 0.222660019993782, 0.222591727972031, 0.222523599863052, 0.222455590963364, 0.222387924790382, 0.222320377826691, 0.222253069281578, 0.2221859395504, 0.222119003534317, 0.222052246332169, 0.221985772252083, 0.221919447183609, 0.22185330092907, 0.221787437796593, 0.221721664071083, 0.221656113862991, 0.221590831875801, 0.221525713801384, 0.22146075963974, 0.221396073698997, 0.221331536769867, 0.221267268061638, 0.22120313346386, 0.221139192581177, 0.221075534820557, 0.221011996269226, 0.220948666334152, 0.220885589718819, 0.220822647213936, 0.220759943127632, 0.220697477459908, 0.220635160803795, 0.220573022961617, 0.220511123538017, 0.220449432730675, 0.220387890934944, 0.220326617360115, 0.22026552259922, 0.220204591751099, 0.22014394402504, 0.220083400607109, 0.22002312541008, 0.219963043928146, 0.219903126358986, 0.219843432307243, 0.219783931970596, 0.219724625349045, 0.219665572047234, 0.219606667757034, 0.219547927379608, 0.219489499926567, 0.219431161880493, 0.21937307715416, 0.219315201044083, 0.21925750374794, 0.219200044870377, 0.219142735004425, 0.219085618853569, 0.219028785824776, 0.218972086906433, 0.218915566802025, 0.218859300017357, 0.218803226947784, 0.218747347593307, 0.218691676855087, 0.21863617002964, 0.218580916523933, 0.218525826931, 0.218470945954323, 0.218416228890419, 0.218361794948578, 0.218307539820671, 0.218253418803215, 0.218199580907822, 0.21814589202404, 0.218092456459999, 0.21803916990757, 0.217968717217445, 0.217881336808205, 0.217794150114059, 0.217707067728043, 0.217620149254799, 0.217533364892006, 0.217446714639664, 0.217360228300095, 0.217273876070976, 0.217187717556953, 0.217101648449898, 0.217015758156776, 0.216929957270622, 0.216844350099564, 0.216758862137794, 0.216673493385315, 0.21658830344677, 0.216503232717514, 0.216418355703354, 0.216333582997322, 0.216248989105225, 0.216164484620094, 0.216080129146576, 0.215995952486992, 0.215911880135536, 0.215827971696854, 0.215744242072105, 0.215660631656647, 0.215577125549316, 0.215493768453598, 0.215410619974136, 0.215327560901642, 0.215244635939598, 0.215161874890327, 0.215079247951508, 0.214996829628944, 0.214914485812187, 0.214832335710526, 0.214750245213509, 0.214668348431587, 0.214586615562439, 0.214504972100258, 0.21442349255085, 0.214342162013054, 0.214261010289192, 0.214179992675781, 0.214099079370499, 0.21401834487915, 0.21393771469593, 0.213857233524323, 0.213776916265488, 0.213696733117104, 0.21361668407917, 0.213536873459816, 0.213457107543945, 0.213377475738525, 0.21329802274704, 0.213218688964844, 0.21313950419426, 0.213060483336449, 0.212981566786766, 0.212902829051018, 0.212824299931526, 0.212745800614357, 0.212667509913445, 0.212589308619499, 0.212511286139488, 0.212433412671089, 0.212355673313141, 0.212278038263321, 0.212200626730919, 0.212123334407806, 0.212046161293983, 0.211969137191772, 0.211892262101173, 0.211815506219864, 0.211738899350166, 0.211662456393242, 0.211586132645607, 0.211510047316551, 0.211433991789818, 0.211358115077019, 0.21128237247467, 0.211206793785095, 0.211131349205971, 0.211056053638458, 0.210980892181396, 0.210905864834785, 0.21083103120327, 0.210756316781044, 0.210681676864624, 0.210607260465622, 0.210532963275909, 0.210458785295486, 0.210384786128998, 0.21031092107296, 0.210237175226212, 0.21016363799572, 0.210090205073357, 0.210016921162605, 0.209961026906967, 0.209913969039917, 0.209867149591446, 0.209820583462715, 0.209774285554886, 0.209728240966797, 0.209682509303093, 0.209636986255646, 0.209591701626778, 0.209546715021133, 0.209501951932907, 0.20945742726326, 0.209413215517998, 0.209369242191315, 0.209325507283211, 0.209282115101814, 0.209238886833191, 0.20919594168663, 0.20915324985981, 0.209110826253891, 0.209068655967712, 0.209026753902435, 0.208985105156898, 0.208943754434586, 0.208902597427368, 0.208861723542213, 0.208821102976799, 0.208780750632286, 0.20874060690403, 0.208700761198997, 0.208661198616028, 0.208621874451637, 0.208582833409309, 0.208544030785561, 0.208505436778069, 0.208467170596123, 0.208429142832756, 0.208391338586807, 0.208353817462921, 0.208316579461098, 0.208279550075531, 0.208242848515511, 0.208206355571747, 0.208170115947723, 0.20813412964344, 0.208098441362381, 0.208062961697578, 0.208027765154839, 0.207992807030678, 0.207958117127419, 0.207923755049706, 0.207889556884766, 0.20785565674305, 0.207822024822235, 0.20778863132, 0.207755506038666, 0.207722648978233, 0.207690000534058, 0.207657635211945, 0.207625582814217, 0.207593739032745, 0.207562163472176, 0.207530811429024, 0.207499742507935, 0.207468971610069, 0.207438394427299, 0.20740807056427, 0.207378074526787, 0.207348331809044, 0.207318812608719, 0.207289576530457, 0.207260549068451, 0.207231789827347, 0.207203328609467, 0.207175076007843, 0.207147106528282, 0.207119420170784, 0.207091987133026, 0.207064792513847, 0.207037836313248, 0.207011148333549, 0.206984743475914, 0.206958562135696, 0.206932678818703, 0.206907048821449, 0.206881672143936, 0.206856548786163, 0.206831648945808, 0.206807076931, 0.206782698631287, 0.206758603453636, 0.206734761595726, 0.206711158156395, 0.206687837839127, 0.206664830446243, 0.206642031669617, 0.20661948621273, 0.206597179174423, 0.20657517015934, 0.206553369760513, 0.206532061100006, 0.206513211131096, 0.20649416744709, 0.206474900245667, 0.206455424427986, 0.206435844302177, 0.206415966153145, 0.206395909190178, 0.206375643610954, 0.206355214118958, 0.20633453130722, 0.206313714385033, 0.206292673945427, 0.206271409988403, 0.206249937415123, 0.206228271126747, 0.206206396222115, 0.206184327602386, 0.206162124872208, 0.206139653921127, 0.206116989254951, 0.206094101071358, 0.206071063876152, 0.206047773361206, 0.206024333834648, 0.206000685691833, 0.205976814031601, 0.205952718853951, 0.205928459763527, 0.205903977155685, 0.205879330635071, 0.205854490399361, 0.205829411745071, 0.205804109573364, 0.205778613686562, 0.205752983689308, 0.205727070569992, 0.205701023340225, 0.205674797296524, 0.20564828813076, 0.205621600151062, 0.205594718456268, 0.205567643046379, 0.205540329217911, 0.205512911081314, 0.205485224723816, 0.205457299947739, 0.205429226160049, 0.205400958657265, 0.20537243783474, 0.205343812704086, 0.205314919352531, 0.205285832285881, 0.205256521701813, 0.20522703230381, 0.205197334289551, 0.205167427659035, 0.205137386918068, 0.205107063055038, 0.205076575279236, 0.205045893788338, 0.20501497387886, 0.204983875155449, 0.204952642321587, 0.204921126365662, 0.204889431595802, 0.204857513308525, 0.204825401306152, 0.204793095588684, 0.204760581254959, 0.204727917909622, 0.204695016145706, 0.204661920666695, 0.204628586769104, 0.20459508895874, 0.204561397433281, 0.204527512192726, 0.204493388533592, 0.204459071159363, 0.204424545168877, 0.204389855265617, 0.204354926943779, 0.204319775104523, 0.204284533858299, 0.204249009490013, 0.204213291406631, 0.204177394509315, 0.20414125919342, 0.204104945063591, 0.204068452119827, 0.204031720757484, 0.203994780778885, 0.203957661986351, 0.203920349478722, 0.203882813453674, 0.203845083713531, 0.203807219862938, 0.20376905798912, 0.203730747103691, 0.203692227602005, 0.203641206026077, 0.203576132655144, 0.203510880470276, 0.203445360064507, 0.203379705548286, 0.20331384241581, 0.203247725963593, 0.203181490302086, 0.203115046024323, 0.203048408031464, 0.202981561422348, 0.202914521098137, 0.20284728705883, 0.202779859304428, 0.20271223783493, 0.202644482254982, 0.202576473355293, 0.202508300542831, 0.202439874410629, 0.202371284365654, 0.202302500605583, 0.202233523130417, 0.202164396643639, 0.202095061540604, 0.202025517821312, 0.201955750584602, 0.201885804533958, 0.201815694570541, 0.201745390892029, 0.201674863696098, 0.201604157686234, 0.201533228158951, 0.201462134718895, 0.201390832662582, 0.201319366693497, 0.201247692108154, 0.201175823807716, 0.201103731989861, 0.20103146135807, 0.200959026813507, 0.200886338949203, 0.200813561677933, 0.20074051618576, 0.20066724717617, 0.200593844056129, 0.200520247220993, 0.200446382164955, 0.20037242770195, 0.200298264622688, 0.200223803520203, 0.20014925301075, 0.200074478983879, 0.199999496340752, 0.199924319982529, 0.199849009513855, 0.199773445725441, 0.199697688221931, 0.199621751904488, 0.199545606970787, 0.19946925342083, 0.199392810463905, 0.199316084384918, 0.199239134788513, 0.199162051081657, 0.199084758758545, 0.199007228016853, 0.19892954826355, 0.198851749300957, 0.198773622512817, 0.198695406317711, 0.198616907000542, 0.198538243770599, 0.198459416627884, 0.198380410671234, 0.198301136493683, 0.198221758008003, 0.198142126202583, 0.198062285780907, 0.197982311248779, 0.197902083396912, 0.197821691632271, 0.197741135954857, 0.197660341858864, 0.197579368948936, 0.197498187422752, 0.197416812181473, 0.197335287928581, 0.197253569960594, 0.197171628475189, 0.197089433670044, 0.197007149457932, 0.196924582123756, 0.196841865777969, 0.196759015321732, 0.196675896644592, 0.196592584252357, 0.196509078145027, 0.196425378322601, 0.19634148478508, 0.19625748693943, 0.196182325482368, 0.196122661232948, 0.196062788367271, 0.196002781391144, 0.195942655205727, 0.195882365107536, 0.195821911096573, 0.195761278271675, 0.195700481534004, 0.195639535784721, 0.195578411221504, 0.195517167448997, 0.195455729961395, 0.195394158363342, 0.195332422852516, 0.195270508527756, 0.195208460092545, 0.195146307349205, 0.195083931088448, 0.195021435618401, 0.194958716630936, 0.194895878434181, 0.194832906126976, 0.194769725203514, 0.194706425070763, 0.194642931222916, 0.194579318165779, 0.194515511393547, 0.194451600313187, 0.194387540221214, 0.194323241710663, 0.194258809089661, 0.194194287061691, 0.194129511713982, 0.19406458735466, 0.19399955868721, 0.193934366106987, 0.193868979811668, 0.193803504109383, 0.193737789988518, 0.193672001361847, 0.193606004118919, 0.193539842963219, 0.193473532795906, 0.19340705871582, 0.193340435624123, 0.193273663520813, 0.193206682801247, 0.193139612674713, 0.193072348833084, 0.193004935979843, 0.192937359213829, 0.192869678139687, 0.192801773548126, 0.192733734846115, 0.192665502429008, 0.192597165703773, 0.192528635263443, 0.192459970712662, 0.192391127347946, 0.192322134971619, 0.192252963781357, 0.192183643579483, 0.192114189267159, 0.192044615745544, 0.191974833607674, 0.191904872655869, 0.191834792494774, 0.191764548420906, 0.191694110631943, 0.191623538732529, 0.191552817821503, 0.191481932997704, 0.19141086935997, 0.191339731216431, 0.191268369555473, 0.191196858882904, 0.191125154495239, 0.191053330898285, 0.190981313586235, 0.190909191966057, 0.190836891531944, 0.190764397382736, 0.190691813826561, 0.190619006752968, 0.190546065568924, 0.190473020076752, 0.190399765968323, 0.190326333045959, 0.190252780914307, 0.190179049968719, 0.19010517001152, 0.190031111240387, 0.189956918358803, 0.189882546663284, 0.189808055758476, 0.189733371138573, 0.189658537507057, 0.189583599567413, 0.189508482813835, 0.189430385828018, 0.189350932836533, 0.189270928502083, 0.189190492033958, 0.189109370112419, 0.189027741551399, 0.188945546746254, 0.188862949609756, 0.188779681921005, 0.18869586288929, 0.18861149251461, 0.188526719808578, 0.188441246747971, 0.188355296850204, 0.188268765807152, 0.18818174302578, 0.188094034790993, 0.188005894422531, 0.187917187809944, 0.18782801926136, 0.187738239765167, 0.187647849321365, 0.187556952238083, 0.187465593218803, 0.187373623251915, 0.187281042337418, 0.187187969684601, 0.187094435095787, 0.187000259757042, 0.186905533075333, 0.186810299754143, 0.186714604496956, 0.186618193984032, 0.186521336436272, 0.18642395734787, 0.186326056718826, 0.186227545142174, 0.186128467321396, 0.18602879345417, 0.185928717255592, 0.185828000307083, 0.185726791620255, 0.185624942183495, 0.18552266061306, 0.185419738292694, 0.185316383838654, 0.185212433338165, 0.185107976198196, 0.185002863407135, 0.184897288680077, 0.18479111790657, 0.184684500098228, 0.184577256441116, 0.18446946144104, 0.184361070394516, 0.184252232313156, 0.184142798185349, 0.184032902121544, 0.183922424912453, 0.183811381459236, 0.183699831366539, 0.183587625622749, 0.183474957942963, 0.183361798524857, 0.183247983455658, 0.183133617043495, 0.183018758893013, 0.182903438806534, 0.182787477970123, 0.182670995593071, 0.182553872466087, 0.182436391711235, 0.182318225502968, 0.182199522852898, 0.182080298662186, 0.181960627436638, 0.18184021115303, 0.181719362735748, 0.181597903370857, 0.181476071476936, 0.181353613734245, 0.181230470538139, 0.181106865406036, 0.180982828140259, 0.180858165025711, 0.180732905864716, 0.180607110261917, 0.180480882525444, 0.180354028940201, 0.180226609110832, 0.180098682641983, 0.179970264434814, 0.179841190576553, 0.17971159517765, 0.179581463336945, 0.179450884461403, 0.179319649934769, 0.179187804460526, 0.179055497050285, 0.178922727704048, 0.178783923387527, 0.178622245788574, 0.178460285067558, 0.178298085927963, 0.178135484457016, 0.177972614765167, 0.177809402346611, 0.177646040916443, 0.177482232451439, 0.17731811106205, 0.177153736352921, 0.176989153027534, 0.176824197173119, 0.176658898591995, 0.176493227481842, 0.176327437162399, 0.176161289215088, 0.175994768738747, 0.175827950239182, 0.17566092312336, 0.175493538379669, 0.175325840711594, 0.175157859921455, 0.174989685416222, 0.174821078777313, 0.174652114510536, 0.174482882022858, 0.174313515424728, 0.174143731594086, 0.173973590135574, 0.173803105950356, 0.173632517457008, 0.173461481928825, 0.173290193080902, 0.173118561506271, 0.172946766018867, 0.172774538397789, 0.172601997852325, 0.172429233789444, 0.172256171703339, 0.17208269238472, 0.171908974647522, 0.1717349588871, 0.171560764312744, 0.171386137604713, 0.171211197972298, 0.171035900712013, 0.170860454440117, 0.170684635639191, 0.170508503913879, 0.170332118868828, 0.170155480504036, 0.169978380203247, 0.169801041483879, 0.169623389840126, 0.169445559382439, 0.16926734149456, 0.169088736176491, 0.168909907341003, 0.168730825185776, 0.168551430106163, 0.168371647596359, 0.168191626667976, 0.168011322617531, 0.1678307056427, 0.167649745941162, 0.167468458414078, 0.167287021875381, 0.167105078697205, 0.166923001408577, 0.166740521788597, 0.166557878255844, 0.166374802589417, 0.166191413998604, 0.166007772088051, 0.165823847055435, 0.165639623999596, 0.165455043315887, 0.165270194411278, 0.165085047483444, 0.164899572730064, 0.164713829755783, 0.164527758955956, 0.16434146463871, 0.164154782891273, 0.16396775841713, 0.16378054022789, 0.163593024015427, 0.163405209779739, 0.1632169932127, 0.163028448820114, 0.162839785218239, 0.162650659680367, 0.162461295723915, 0.162271603941917, 0.162081733345985, 0.161891385912895, 0.161700800061226, 0.161509931087494, 0.16131879389286, 0.161135047674179, 0.160972148180008, 0.160809218883514, 0.160646200180054, 0.160483151674271, 0.160319954156876, 0.160156741738319, 0.159993469715118, 0.15983010828495, 0.159666657447815, 0.159503161907196, 0.15933957695961, 0.159175917506218, 0.159012168645859, 0.158848360180855, 0.158684521913528, 0.158520579338074, 0.158356577157974, 0.158192455768585, 0.158028334379196, 0.15786412358284, 0.157699808478355, 0.157535403966904, 0.157370954751968, 0.157206475734711, 0.157041862607002, 0.156877219676971, 0.156712487339973, 0.156547710299492, 0.156382843852043, 0.156217873096466, 0.156052842736244, 0.155887752771378, 0.155722603201866, 0.155557364225388, 0.155392080545425, 0.155226677656174, 0.155061259865761, 0.15489573776722, 0.154730141162872, 0.154564470052719, 0.154398739337921, 0.154232934117317, 0.154067054390907, 0.153901129961014, 0.153735101222992, 0.153568968176842, 0.15340282022953, 0.153236553072929, 0.15307030081749, 0.15290392935276, 0.152737453579903, 0.152570948004723, 0.152404338121414, 0.1522376537323, 0.152070909738541, 0.151904121041298, 0.151737242937088, 0.15157026052475, 0.15140326321125, 0.1512361317873, 0.151069030165672, 0.150901734828949, 0.150734484195709, 0.150567054748535, 0.150399625301361, 0.150232091546059, 0.150064498186111, 0.149896800518036, 0.149729087948799, 0.149561271071434, 0.149393349885941, 0.149225413799286, 0.149057388305664, 0.148889288306236, 0.148721098899841, 0.148552879691124, 0.148384571075439, 0.148216158151627, 0.148047715425491, 0.147879183292389, 0.147710576653481, 0.147541895508766, 0.147373154759407, 0.147204324603081, 0.147035449743271, 0.146866470575333, 0.146697476506233, 0.146528348326683, 0.146359160542488, 0.146189898252487, 0.146020576357841, 0.145851194858551, 0.145681723952293, 0.145512223243713, 0.145342573523521, 0.145172894001007, 0.145003154873848, 0.14483331143856, 0.144663482904434, 0.144472420215607, 0.144282698631287, 0.144092977046967, 0.143903225660324, 0.143713474273682, 0.143523633480072, 0.14333376288414, 0.143143996596336, 0.142954126000404, 0.14276422560215, 0.142574295401573, 0.142384424805641, 0.142194464802742, 0.142004460096359, 0.14181450009346, 0.141624480485916, 0.141434401273727, 0.141244366765022, 0.141054317355156, 0.140864178538322, 0.140674069523811, 0.140483945608139, 0.140293806791306, 0.140103578567505, 0.139913365244865, 0.139723151922226, 0.139532864093781, 0.13934263586998, 0.13915228843689, 0.138962060213089, 0.138771668076515, 0.138581305742264, 0.138390943408012, 0.138200581073761, 0.138010114431381, 0.137819722294807, 0.137629210948944, 0.137438669800758, 0.137248247861862, 0.137057662010193, 0.136867135763168, 0.136676579713821, 0.136485919356346, 0.13629537820816, 0.136104732751846, 0.135914012789726, 0.135723367333412, 0.135532692074776, 0.135341957211494, 0.13515117764473, 0.13496045768261, 0.134769663214684, 0.134578809142113, 0.13438805937767, 0.134197175502777, 0.134006217122078, 0.133815407752991, 0.133624449372292, 0.133433520793915, 0.133242562413216, 0.133051589131355, 0.132860615849495, 0.132669538259506, 0.13247849047184, 0.132287442684174, 0.132096439599991, 0.131905227899551, 0.131714090704918, 0.131522983312607, 0.131331831216812, 0.131140545010567, 0.130949378013611, 0.13075815141201, 0.130566835403442, 0.130375578999519, 0.130184292793274, 0.129992976784706, 0.129801616072655, 0.129610300064087, 0.129418835043907, 0.129227429628372, 0.129035979509354, 0.128844529390335, 0.128653079271317, 0.128461539745331, 0.128270074725151, 0.128078475594521, 0.127886950969696, 0.127695366740227, 0.127503767609596, 0.127312168478966, 0.127120479941368, 0.126928776502609, 0.126737102866173, 0.126545414328575, 0.126353681087494, 0.126161888241768, 0.125970155000687, 0.125778391957283, 0.12558650970459, 0.125400274991989, 0.125201269984245, 0.125002667307854, 0.124804705381393, 0.124607235193253, 0.124410375952721, 0.124214246869087, 0.124018624424934, 0.123823314905167, 0.123628914356232, 0.123435042798519, 0.123241521418095, 0.123048886656761, 0.122856698930264, 0.122665174305439, 0.122474066913128, 0.122283682227135, 0.122093804180622, 0.12190455198288, 0.121716000139713, 0.121527768671513, 0.121340252459049, 0.121153347194195, 0.120967008173466, 0.120781183242798, 0.120595872402191, 0.120411284267902, 0.120227351784706, 0.120043739676476, 0.119860880076885, 0.119678653776646, 0.119496934115887, 0.119315929710865, 0.119135186076164, 0.118955254554749, 0.118775948882103, 0.118597097694874, 0.118418857455254, 0.118241302669048, 0.118064142763615, 0.117887653410435, 0.117711879312992, 0.117536269128323, 0.117361567914486, 0.117187492549419, 0.117013826966286, 0.116840824484825, 0.116668432950974, 0.116496719419956, 0.116325408220291, 0.116154715418816, 0.115984529256821, 0.115815073251724, 0.115646116435528, 0.115477882325649, 0.115309864282608, 0.1151427552104, 0.114976219832897, 0.114810042083263, 0.114644676446915, 0.114479787647724, 0.114315554499626, 0.114151827991009, 0.113988623023033, 0.113826029002666, 0.113664165139198, 0.113502807915211, 0.113342009484768, 0.113181829452515, 0.113022111356258, 0.112863220274448, 0.112704627215862, 0.112546645104885, 0.112389296293259, 0.112232655286789, 0.112076319754124, 0.111920759081841, 0.111765965819359, 0.111611478030682, 0.11145756393671, 0.111304499208927, 0.111151657998562, 0.110999539494514, 0.110848173499107, 0.110697232186794, 0.110546946525574, 0.110396929085255, 0.110247932374477, 0.110099397599697, 0.109951063990593, 0.109803810715675, 0.109656967222691, 0.109510682523251, 0.109364815056324, 0.109219767153263, 0.109075225889683, 0.108931310474873, 0.108787909150124, 0.108645267784595, 0.108502939343452, 0.108384929597378, 0.108284048736095, 0.108183406293392, 0.108083628118038, 0.107984274625778, 0.107885412871838, 0.107787244021893, 0.107689507305622, 0.107592388987541, 0.107495814561844, 0.107399687170982, 0.10730404406786, 0.107209153473377, 0.107114665210247, 0.107020758092403, 0.106927365064621, 0.106834396719933, 0.106742210686207, 0.106650397181511, 0.106559053063393, 0.106468215584755, 0.106378063559532, 0.106288515031338, 0.106199271976948, 0.106110744178295, 0.10602280497551, 0.105935275554657, 0.105848468840122, 0.105761989951134, 0.105675980448723, 0.105590790510178, 0.105505913496017, 0.105421766638756, 0.105337880551815, 0.105254679918289, 0.105172164738178, 0.105089940130711, 0.105008281767368, 0.104927353560925, 0.104846820235252, 0.10476691275835, 0.104687467217445, 0.104608558118343, 0.104530267417431, 0.104452528059483, 0.104375317692757, 0.104298532009125, 0.104222260415554, 0.104146711528301, 0.104071520268917, 0.103996746242046, 0.103922821581364, 0.103849232196808, 0.103776186704636, 0.103703871369362, 0.103631936013699, 0.103560745716095, 0.10348991304636, 0.103419624269009, 0.103349812328815, 0.103280693292618, 0.103211991488934, 0.103143937885761, 0.103076234459877, 0.103009141981602, 0.102942749857903, 0.102876514196396, 0.102811187505722, 0.102746337652206, 0.102681994438171, 0.102618157863617, 0.10255479067564, 0.102492161095142, 0.102429948747158, 0.102368377149105, 0.102307185530663, 0.102246694266796, 0.102186396718025, 0.102127008140087, 0.102068021893501, 0.102009445428848, 0.101951479911804, 0.10189414024353, 0.101837307214737, 0.101780973374844, 0.101725347340107, 0.101670138537884, 0.101615481078625, 0.101561270654202, 0.101507678627968, 0.101454749703407, 0.101402118802071, 0.101350106298923, 0.10129876434803, 0.101247578859329, 0.101197391748428, 0.101147644221783, 0.10109806060791, 0.10104938596487, 0.101001136004925, 0.100949019193649, 0.100891061127186, 0.100833207368851, 0.100775152444839, 0.100716955959797, 0.100658692419529, 0.100600346922874, 0.10054188221693, 0.100483231246471, 0.100424498319626, 0.100365698337555, 0.100306838750839, 0.100247755646706, 0.100188694894314, 0.100129403173923, 0.100070118904114, 0.100010611116886, 0.0999511107802391, 0.0998913645744324, 0.0998316705226898, 0.099771685898304, 0.0997117683291435, 0.0996516346931458, 0.0995914712548256, 0.0995310992002487, 0.0994707345962524, 0.0994102656841278, 0.0993495881557465, 0.0992888584733009, 0.0992279797792435, 0.0991670936346054, 0.0991059541702271, 0.0990448147058487, 0.0989835262298584, 0.0989221334457397, 0.0988606363534927, 0.0987990945577621, 0.0987372621893883, 0.0986755639314651, 0.0986135303974152, 0.0985515639185905, 0.0984894037246704, 0.0984271317720413, 0.0983648747205734, 0.098302349448204, 0.0982398241758347, 0.0981770902872086, 0.0981143116950989, 0.0980513244867325, 0.0979884043335915, 0.097925215959549, 0.09786207228899, 0.0977987349033356, 0.0977352783083916, 0.0976717323064804, 0.0976081341505051, 0.0975442826747894, 0.0974804982542992, 0.0974164307117462, 0.0973524525761604, 0.0972883403301239, 0.0972239151597023, 0.0971596017479897, 0.0970950275659561, 0.0970304980874062, 0.0969657823443413, 0.0969008952379227, 0.0968359559774399, 0.0967709794640541, 0.0967057347297668, 0.0966405421495438, 0.0965751260519028, 0.096509650349617, 0.0964440479874611, 0.0963784009218216, 0.0963125452399254, 0.096246711909771, 0.0961806252598763, 0.0961145684123039, 0.0960483998060226, 0.0959820076823235, 0.0959156081080437, 0.0958490073680878, 0.0957824140787125, 0.0957155823707581, 0.0956487506628036, 0.0955817103385925, 0.0955147221684456, 0.0954473316669464, 0.0953801348805428, 0.0953126922249794, 0.0952451974153519, 0.0951774939894676, 0.0951097831130028, 0.0950419306755066, 0.0949740260839462, 0.0949059873819351, 0.0948378220200539, 0.094769574701786, 0.0947011113166809, 0.0946206301450729, 0.094534695148468, 0.0944485887885094, 0.0943622514605522, 0.0942757800221443, 0.0941889733076096, 0.09410210698843, 0.0940148755908012, 0.0939275249838829, 0.0938399061560631, 0.0937521904706955, 0.093664176762104, 0.0935760289430618, 0.093487560749054, 0.0933989956974983, 0.0933102369308472, 0.0932211354374886, 0.0931319817900658, 0.0930424779653549, 0.0929528847336769, 0.0928629264235497, 0.0927729532122612, 0.0926826074719429, 0.0925921946763992, 0.0925014540553093, 0.0924106314778328, 0.092319443821907, 0.0922281891107559, 0.0921365916728973, 0.092044897377491, 0.0919528603553772, 0.091860756278038, 0.0917684361338615, 0.0916758477687836, 0.091583140194416, 0.0914900973439217, 0.0913970097899437, 0.0913035646080971, 0.0912099480628967, 0.0911161154508591, 0.0910221263766289, 0.090927854180336, 0.0908334627747536, 0.0907387882471085, 0.0906439647078514, 0.0905488803982735, 0.0904536843299866, 0.0903581082820892, 0.0902625024318695, 0.0901665762066841, 0.0900705084204674, 0.0899742692708969, 0.0898776650428772, 0.0897810235619545, 0.0896840244531631, 0.0895869210362434, 0.089489534497261, 0.0893920511007309, 0.0892942100763321, 0.0891963243484497, 0.0890980958938599, 0.0889997705817223, 0.0889010950922966, 0.0888023152947426, 0.0887033119797707, 0.0886041447520256, 0.0885046273469925, 0.0884050726890564, 0.0883052572607994, 0.0882050916552544, 0.0881048962473869, 0.0880043357610703, 0.087903767824173, 0.0878028348088264, 0.0877017751336098, 0.0876004323363304, 0.0874989554286003, 0.0873972326517105, 0.0872953683137894, 0.0871931463479996, 0.087090827524662, 0.0869882628321648, 0.086885541677475, 0.0867825374007225, 0.0866794288158417, 0.0865761190652847, 0.0864724442362785, 0.0863687098026276, 0.0862646624445915, 0.0861605182290077, 0.0860560685396194, 0.0859514772891998, 0.0858465656638145, 0.0857415944337845, 0.0856363028287888, 0.0855308845639229, 0.0854252055287361, 0.085319384932518, 0.0852132067084312, 0.0851069763302803, 0.0849973633885384, 0.0848944261670113, 0.0847914293408394, 0.0846884176135063, 0.0845853537321091, 0.0844822749495506, 0.0843791365623474, 0.0842759981751442, 0.084172785282135, 0.0840695723891258, 0.0839662700891495, 0.0838629528880119, 0.0837596356868744, 0.0836562514305115, 0.0835528373718262, 0.0834493935108185, 0.0833459049463272, 0.083242379128933, 0.0831388235092163, 0.0830352529883385, 0.0829316303133965, 0.0828279480338097, 0.0827242210507393, 0.0826205015182495, 0.0825167372822762, 0.0824129283428192, 0.0823090970516205, 0.082205206155777, 0.0821012780070305, 0.0819973349571228, 0.0818933621048927, 0.0817893147468567, 0.0816852599382401, 0.0815811678767204, 0.0814770236611366, 0.0813728496432304, 0.0812686756253242, 0.0811644345521927, 0.0810601785778999, 0.0809558629989624, 0.0808515027165413, 0.0807471126317978, 0.0806427076458931, 0.0805382505059242, 0.0804337710142136, 0.0803292542695999, 0.0802246555685997, 0.0801200792193413, 0.0800154656171799, 0.0799107998609543, 0.0798060819506645, 0.079701341688633, 0.0795965418219566, 0.0794917494058609, 0.0793868973851204, 0.0792820155620575, 0.0791771113872528, 0.0790721699595451, 0.0789671391248703, 0.0788621231913567, 0.07875707000494, 0.0786519721150398, 0.0785468071699142, 0.0784416720271111, 0.0783364400267601, 0.0782312154769897, 0.0781259313225746, 0.0780206248164177, 0.0779152661561966, 0.0778098627924919, 0.0777044370770454, 0.0775990039110184, 0.0774935111403465, 0.0773879811167717, 0.0772824212908745, 0.0771768018603325, 0.0770711749792099, 0.0769655182957649, 0.0768598094582558, 0.076754055917263, 0.0766482725739479, 0.076542466878891, 0.0764365941286087, 0.0763306990265846, 0.0762247890233994, 0.0761188268661499, 0.0760128423571587, 0.0759067982435226, 0.0758007317781448, 0.0756946504116058, 0.0755885094404221, 0.0754823386669159, 0.0753761157393456, 0.0752698555588722, 0.0751635581254959, 0.0750572681427002, 0.0749509111046791, 0.0748445317149162, 0.0747381150722504, 0.0746316164731979, 0.0745259895920753, 0.0744167566299438, 0.0743076354265213, 0.0741986334323883, 0.0740897953510284, 0.0739810019731522, 0.073872372508049, 0.0737638548016548, 0.0736555159091949, 0.0735472068190575, 0.0734389871358871, 0.07333093136549, 0.0732230320572853, 0.0731152668595314, 0.0730076283216476, 0.0729000940918922, 0.072792686522007, 0.0726853907108307, 0.0725781917572021, 0.0724711939692497, 0.0723642632365227, 0.0722574889659882, 0.072150781750679, 0.07204420119524, 0.0719377771019936, 0.0718314871191978, 0.0717252641916275, 0.0716191977262497, 0.071513257920742, 0.0714073777198792, 0.071301706135273, 0.0711960420012474, 0.0710906237363815, 0.0709852650761604, 0.0708800926804543, 0.0707749202847481, 0.0706699714064598, 0.0705650970339775, 0.0704603940248489, 0.0703558027744293, 0.0702513232827187, 0.0701469331979752, 0.0700426772236824, 0.0699385702610016, 0.0698345750570297, 0.0697307512164116, 0.0696269795298576, 0.069523312151432, 0.0694198086857796, 0.0693164020776749, 0.0692131295800209, 0.0691100135445595, 0.0690068975090981, 0.0689039826393127, 0.0688012465834618, 0.068698562681675, 0.0685960277915001, 0.0684936344623566, 0.0683913826942444, 0.0682891234755516, 0.0681870952248573, 0.0680851638317108, 0.0679833963513374, 0.0678817108273506, 0.0677801743149757, 0.0676787346601486, 0.0675774067640305, 0.0674761831760406, 0.0673751458525658, 0.0672741532325745, 0.0671733692288399, 0.0670726373791695, 0.066971980035305, 0.0668715238571167, 0.0667711719870567, 0.0666709542274475, 0.066570833325386, 0.0664708763360977, 0.0663710087537766, 0.0662712752819061, 0.066171683371067, 0.0660722255706787, 0.0659728199243546, 0.0658736005425453, 0.0657744556665421, 0.0656754747033119, 0.0655765980482101, 0.0654778555035591, 0.06537926197052, 0.0652807056903839, 0.0651823207736015, 0.0650840476155281, 0.0649859011173248, 0.0648877993226051, 0.0647899061441422, 0.0646921098232269, 0.0645944401621819, 0.0644969269633293, 0.0643994882702827, 0.0643022507429123, 0.0642145350575447, 0.064122162759304, 0.064030148088932, 0.0639384388923645, 0.0638469383120537, 0.063755638897419, 0.0636646524071693, 0.0635737627744675, 0.0634832829236984, 0.0633929669857025, 0.0633029565215111, 0.0632130950689316, 0.0631234347820282, 0.0630340948700905, 0.0629449486732483, 0.0628560110926628, 0.062767431139946, 0.0626790598034859, 0.0625910013914108, 0.0625031366944313, 0.0624155253171921, 0.0623281337320805, 0.0622408874332905, 0.0621540546417236, 0.0620673224329948, 0.0619809478521347, 0.061894778162241, 0.0618089213967323, 0.0617232173681259, 0.0616377666592598, 0.0615525729954243, 0.0614676885306835, 0.0613828562200069, 0.0612984299659729, 0.0612141117453575, 0.0611301958560944, 0.061046440154314, 0.0609629414975643, 0.0608797445893288, 0.0607967600226402, 0.060714028775692, 0.0606315545737743, 0.0605492368340492, 0.0604671761393547, 0.0603853650391102, 0.0603038631379604, 0.0602225176990032, 0.0601414814591408, 0.0600607469677925, 0.059980221092701, 0.0598998479545116, 0.0598198398947716, 0.059740025550127, 0.0596604757010937, 0.0595810301601887, 0.0595017895102501, 0.059422954916954, 0.0593443773686886, 0.0592660047113895, 0.0591879934072495, 0.0591100342571735, 0.0590324327349663, 0.0589550845324993, 0.0588779449462891, 0.0588009543716908, 0.0587242804467678, 0.0586478561162949, 0.0585717409849167, 0.058495782315731, 0.0584201253950596, 0.0583447329699993, 0.0582695379853249, 0.0581946074962616, 0.0581198781728745, 0.0580453015863895, 0.0579711385071278, 0.0578970722854137, 0.0578232631087303, 0.0577498190104961, 0.057676624506712, 0.0576036423444748, 0.0575308576226234, 0.0574583373963833, 0.0573861189186573, 0.057314109057188, 0.0572421513497829, 0.057170644402504, 0.0570994019508362, 0.0570283718407154, 0.0569576397538185, 0.0568870641291142, 0.0568166933953762, 0.0567466840147972, 0.0566768273711205, 0.0566072762012482, 0.0565378814935684, 0.0564685873687267, 0.0563998110592365, 0.056331180036068, 0.0562628097832203, 0.0561966896057129, 0.0561380013823509, 0.0560794249176979, 0.056020800024271, 0.0559623800218105, 0.0559039898216724, 0.0558456443250179, 0.0557874701917171, 0.0557293072342873, 0.0556713007390499, 0.0556134097278118, 0.0555555783212185, 0.0554977804422379, 0.0554400719702244, 0.0553825125098228, 0.055325023829937, 0.0552675947546959, 0.0552101098001003, 0.0551529116928577, 0.0550957582890987, 0.0550387166440487, 0.0549816824495792, 0.0549247600138187, 0.0548679456114769, 0.0548112280666828, 0.0547545924782753, 0.054698009043932, 0.0546414293348789, 0.054585050791502, 0.054528746753931, 0.0544725060462952, 0.0544163845479488, 0.0543603524565697, 0.0543044432997704, 0.0542485006153584, 0.0541927590966225, 0.0541370734572411, 0.0540814474225044, 0.0540257841348648, 0.0539703443646431, 0.0539149977266788, 0.0538597740232944, 0.0538046061992645, 0.0537495091557503, 0.0536945052444935, 0.0536395721137524, 0.0535847432911396, 0.0535300299525261, 0.0534752532839775, 0.05342061445117, 0.0533661656081676, 0.0533117428421974, 0.0532573610544205, 0.0532031431794167, 0.0531490072607994, 0.0530949719250202, 0.053040936589241, 0.0529870800673962, 0.0529332794249058, 0.0528794787824154, 0.0528258271515369, 0.052772268652916, 0.0527187883853912, 0.0526654422283173, 0.0526122041046619, 0.0525589659810066, 0.0525058060884476, 0.0524527803063393, 0.0523998774588108, 0.0523469336330891, 0.0522941015660763, 0.0522414445877075, 0.0521888695657253, 0.0521363653242588, 0.0520838648080826, 0.0520315393805504, 0.0519792959094048, 0.051927138119936, 0.0518750883638859, 0.0518230572342873, 0.0517710596323013, 0.05171924456954, 0.0516674965620041, 0.0516157932579517, 0.051564235240221, 0.0515127629041672, 0.0514613837003708, 0.0514100305736065, 0.0513588264584541, 0.0513076931238174, 0.05125667527318, 0.051205612719059, 0.0511546954512596, 0.0511039458215237, 0.0510532706975937, 0.0510026440024376, 0.0509521141648293, 0.0509016066789627, 0.0508512482047081, 0.0508010238409042, 0.0507394634187222, 0.0506819896399975, 0.0506244450807571, 0.0505667328834534, 0.0505088604986668, 0.0504509173333645, 0.0503928475081921, 0.0503346659243107, 0.0502763874828815, 0.0502179823815823, 0.0501594468951225, 0.0501008220016956, 0.0500420778989792, 0.0499832034111023, 0.0499242208898067, 0.0498651713132858, 0.0498059317469597, 0.0497466139495373, 0.0496871545910835, 0.0496276095509529, 0.0495679043233395, 0.0495081916451454, 0.049448300153017, 0.0493882894515991, 0.049328126013279, 0.0492678694427013, 0.0492075048387051, 0.049147043377161, 0.049086470156908, 0.0490257702767849, 0.0489649511873722, 0.0489040054380894, 0.0488429442048073, 0.0487818233668804, 0.0487205497920513, 0.0486591570079327, 0.048597663640976, 0.0485360249876976, 0.0484742932021618, 0.0484124384820461, 0.0483505092561245, 0.0482884235680103, 0.0482262335717678, 0.0481639392673969, 0.0481014922261238, 0.0480389706790447, 0.0479762963950634, 0.0479135438799858, 0.0478506311774254, 0.0477876514196396, 0.047724511474371, 0.0476612932980061, 0.0475979298353195, 0.04753452911973, 0.0474709831178188, 0.0474072769284248, 0.0473434776067734, 0.0472795441746712, 0.0472155064344406, 0.0471513718366623, 0.047087125480175, 0.0470227599143982, 0.0469582602381706, 0.0468936637043953, 0.0468289628624916, 0.0467641018331051, 0.0466992221772671, 0.0466341339051723, 0.0465689413249493, 0.0465036518871784, 0.0464382320642471, 0.0463726781308651, 0.0463070310652256, 0.0462413243949413, 0.0461754724383354, 0.0461094602942467, 0.0460433959960938, 0.0459771566092968, 0.0459108389914036, 0.0458444468677044, 0.0457778945565224, 0.0457111895084381, 0.0456443838775158, 0.0455774813890457, 0.045510470867157, 0.0454433560371399, 0.0453761890530586, 0.0453088209033012, 0.0452413186430931, 0.0451737456023693, 0.0451060198247433, 0.0450382120907307, 0.0449703298509121, 0.0449022687971592, 0.0448340810835361, 0.0447658151388168, 0.0446974150836468, 0.0446288920938969, 0.0445602647960186, 0.0444916114211082, 0.0444330535829067, 0.0443626567721367, 0.0442920811474323, 0.0442213490605354, 0.0441504679620266, 0.0440795086324215, 0.0440083928406239, 0.0439370982348919, 0.0438656806945801, 0.0437940806150436, 0.0437223725020885, 0.0436505191028118, 0.0435785576701164, 0.0435063876211643, 0.0434340946376324, 0.0433616489171982, 0.0432890467345715, 0.0432163141667843, 0.0431435406208038, 0.0430704988539219, 0.0429973602294922, 0.0429240651428699, 0.0428505949676037, 0.0427770167589188, 0.0427033677697182, 0.0426295064389706, 0.0425554476678371, 0.0424812808632851, 0.0424070619046688, 0.0423325635492802, 0.042257983237505, 0.0421832837164402, 0.0421083718538284, 0.0420334115624428, 0.0419582463800907, 0.0418828725814819, 0.0418074019253254, 0.0417318530380726, 0.041656170040369, 0.0415803641080856, 0.0415043272078037, 0.0414281077682972, 0.0413518138229847, 0.0412753410637379, 0.0411988124251366, 0.0411220639944077, 0.0410451740026474, 0.0409681126475334, 0.0408909693360329, 0.0408136770129204, 0.0407362803816795, 0.0406586565077305, 0.0405808947980404, 0.0405030138790607, 0.0404249727725983, 0.040346834808588, 0.0402685143053532, 0.0401900932192802, 0.0401114597916603, 0.0400327071547508, 0.039953850209713, 0.0398747809231281, 0.0397956147789955, 0.0397163443267345, 0.0396368466317654, 0.0395572446286678, 0.0394774898886681, 0.0393976271152496, 0.0393175669014454, 0.0392373986542225, 0.0391571559011936, 0.0390766784548759, 0.0389960519969463, 0.0389152728021145, 0.038834385573864, 0.0387533232569695, 0.0386721789836884, 0.0385908335447311, 0.0385093577206135, 0.0384277068078518, 0.0383459739387035, 0.0382641144096851, 0.0381821021437645, 0.0380999334156513, 0.0380175597965717, 0.0379350855946541, 0.0378524586558342, 0.037769727408886, 0.0376868136227131, 0.0376037545502186, 0.037520557641983, 0.0374372377991676, 0.0373537614941597, 0.0372701585292816, 0.0371863767504692, 0.0371025204658508, 0.0370184518396854, 0.0369342863559723, 0.0368499420583248, 0.0367654338479042, 0.036681093275547, 0.0365885682404041, 0.0364961661398411, 0.03640366345644, 0.0363111905753613, 0.0362188145518303, 0.0361263155937195, 0.0360339395701885, 0.0359415672719479, 0.0358491912484169, 0.0357568711042404, 0.0356644205749035, 0.0355721488595009, 0.0354798026382923, 0.0353874303400517, 0.0352951548993587, 0.0352029092609882, 0.0351106151938438, 0.0350183695554733, 0.0349262021481991, 0.0348339304327965, 0.0347417332231998, 0.0346495695412159, 0.0345573462545872, 0.0344651788473129, 0.0343730896711349, 0.0342808440327644, 0.0341888032853603, 0.0340967103838921, 0.0340045168995857, 0.0339125022292137, 0.0338204354047775, 0.0337283201515675, 0.0336363576352596, 0.0335443690419197, 0.0334522500634193, 0.0333603620529175, 0.0332683734595776, 0.0331763587892056, 0.033084474503994, 0.032992459833622, 0.0329005494713783, 0.0328087098896503, 0.0327167734503746, 0.0326248370110989, 0.0325330272316933, 0.0324411392211914, 0.0323493294417858, 0.0322575718164444, 0.0321656614542007, 0.0320738516747952, 0.03198217228055, 0.0318903625011444, 0.0317986570298672, 0.0317069701850414, 0.0316150858998299, 0.0315234065055847, 0.0314318537712097, 0.0313400961458683, 0.031248465180397, 0.0311568602919579, 0.0310650505125523, 0.0309734996408224, 0.0308819450438023, 0.030790263786912, 0.030698711052537, 0.030607158318162, 0.0305155795067549, 0.030424103140831, 0.0303326267749071, 0.0302411001175642, 0.0301496256142855, 0.0300580728799105, 0.0299666468054056, 0.0298752225935459, 0.0297837201505899, 0.0296922940760851, 0.0296009201556444, 0.0295094735920429, 0.0294181481003761, 0.0293268281966448, 0.0292354021221399, 0.0291441828012466, 0.0290528610348701, 0.0289615374058485, 0.028870215639472, 0.0287789721041918, 0.0286876205354929, 0.0285964272916317, 0.0285052079707384, 0.0284139644354582, 0.0283227432519197, 0.0282315500080585, 0.028140302747488, 0.0280492398887873, 0.0279582012444735, 0.0278669819235802, 0.027775889262557, 0.0276847966015339, 0.0275936294347048, 0.0274931732565165, 0.0274035688489676, 0.0273140706121922, 0.0272250808775425, 0.0271363500505686, 0.0270476154983044, 0.0269596036523581, 0.026871845126152, 0.0267841387540102, 0.0266970992088318, 0.0266100093722343, 0.0265233796089888, 0.0264372639358044, 0.0263512004166842, 0.0262653902173042, 0.0261801984161139, 0.0260950569063425, 0.0260102730244398, 0.0259259045124054, 0.0258416831493378, 0.0257577728480101, 0.0256743226200342, 0.0255911312997341, 0.0255081951618195, 0.0254256185144186, 0.0253432970494032, 0.0252613369375467, 0.0251795798540115, 0.0250982847064734, 0.0250171441584826, 0.0249363631010056, 0.0248560942709446, 0.0247758757323027, 0.0246960166841745, 0.0246166717261076, 0.0245371740311384, 0.0244584418833256, 0.0243799164891243, 0.0243015456944704, 0.0242235343903303, 0.0241459831595421, 0.0240684822201729, 0.0239914450794458, 0.0239148177206516, 0.0238383952528238, 0.0237622316926718, 0.023686371743679, 0.0236108209937811, 0.0235356315970421, 0.0234607476741076, 0.0233861207962036, 0.0233119539916515, 0.0232379417866468, 0.0231643933802843, 0.023090997710824, 0.0230179596692324, 0.0229451805353165, 0.022872656583786, 0.0228006970137358, 0.0227289423346519, 0.022657236084342, 0.0225861482322216, 0.0225154738873243, 0.022444536909461, 0.0223744232207537, 0.0223045144230127, 0.022234657779336, 0.0221655685454607, 0.0220963787287474, 0.022027650848031, 0.0219593830406666, 0.0218911170959473, 0.021823363378644, 0.0217559691518545, 0.0216887760907412, 0.0216217413544655, 0.0215553212910891, 0.0214890036731958, 0.0214229915291071, 0.0213575437664986, 0.0212921015918255, 0.0212270133197308, 0.021162336692214, 0.0210979674011469, 0.0210338551551104, 0.0209701023995876, 0.0209066551178694, 0.0208433642983437, 0.0207805316895247, 0.0207180101424456, 0.0206556916236877, 0.0205936841666698, 0.0205321870744228, 0.0204707402735949, 0.0204096548259258, 0.0203492362052202, 0.0202885586768389, 0.0202286019921303, 0.0201687440276146, 0.020109249278903, 0.0200581513345242, 0.0200143754482269, 0.0199705753475428, 0.0199272874742746, 0.0198843311518431, 0.0198414791375399, 0.0197991374880075, 0.0197568479925394, 0.0197147913277149, 0.0196733474731445, 0.0196320079267025, 0.0195907969027758, 0.0195500962436199, 0.0195096042007208, 0.0194692630320787, 0.0194294359534979, 0.0193897671997547, 0.0193502716720104, 0.0193110872060061, 0.0192723870277405, 0.0192339979112148, 0.0191955044865608, 0.0191576778888702, 0.0191201083362103, 0.0190824344754219, 0.0190453510731459, 0.0190086010843515, 0.0189718026667833, 0.0189357195049524, 0.0188996624201536, 0.0188638083636761, 0.01882847212255, 0.018793236464262, 0.0187582280486822, 0.0187237095087767, 0.0186894740909338, 0.0186552386730909, 0.0186216440051794, 0.0185880493372679, 0.0185548383742571, 0.0185218323022127, 0.0184893403202295, 0.0184568483382463, 0.0184247903525829, 0.0183930695056915, 0.0183614734560251, 0.0183302126824856, 0.0182993616908789, 0.0182686131447554, 0.0182382240891457, 0.0182081684470177, 0.0181781891733408, 0.0181486718356609, 0.0181195382028818, 0.0180902257561684, 0.0180616322904825, 0.0180333964526653, 0.0180049818009138, 0.0179772842675447, 0.0179497934877872, 0.0179221983999014, 0.017895296216011, 0.0178686007857323, 0.0178419053554535, 0.0178159531205893, 0.0177899990230799, 0.0177643019706011, 0.0177390165627003, 0.0177139602601528, 0.0176890082657337, 0.0176645945757627, 0.0176405142992735, 0.0176164582371712, 0.01759291626513, 0.017569474875927, 0.0175462681800127, 0.0175234694033861, 0.0175010804086924, 0.0174787696450949, 0.0174566637724638, 0.0174350719898939, 0.0174138359725475, 0.0173925254493952, 0.0173717271536589, 0.0173510331660509, 0.0173307470977306, 0.0173108465969563, 0.0172912534326315, 0.0172716863453388, 0.017252529039979, 0.0172336548566818, 0.0172149334102869, 0.0171966981142759, 0.0171786453574896, 0.0171607956290245, 0.0171433836221695, 0.017126252874732, 0.0171092506498098, 0.0170927084982395, 0.0170762706547976, 0.0170615967363119, 0.0170397665351629, 0.0170180331915617, 0.016996381804347, 0.0169747695326805, 0.0169532466679811, 0.0169317815452814, 0.0169104114174843, 0.0168891195207834, 0.0168678294867277, 0.0168466847389936, 0.0168255530297756, 0.0168045163154602, 0.0167835913598537, 0.0167626328766346, 0.0167418271303177, 0.0167210157960653, 0.0167003590613604, 0.0166797153651714, 0.0166591666638851, 0.016638720408082, 0.016618249937892, 0.0165979266166687, 0.016577685251832, 0.0165574587881565, 0.0165373459458351, 0.0165172331035137, 0.0164972487837076, 0.0164773166179657, 0.0164574291557074, 0.0164376702159643, 0.0164179299026728, 0.0163982845842838, 0.0163786858320236, 0.0163591839373112, 0.0163397323340178, 0.0163203552365303, 0.0163010582327843, 0.0162818040698767, 0.0162626281380653, 0.0162435546517372, 0.0162245146930218, 0.0162055734544992, 0.016186660155654, 0.0161678437143564, 0.0161491055041552, 0.0161303840577602, 0.0161118023097515, 0.0160932429134846, 0.0160747915506363, 0.0160564109683037, 0.0160380341112614, 0.0160197764635086, 0.0160015486180782, 0.0159834623336792, 0.0159653704613447, 0.0159473791718483, 0.0159294866025448, 0.0159115921705961, 0.0158938448876143, 0.0158760976046324, 0.0158584862947464, 0.0158409271389246, 0.0158233903348446, 0.0158059857785702, 0.0157886240631342, 0.0157712679356337, 0.0157541111111641, 0.015736922621727, 0.0157198570668697, 0.0157027766108513, 0.0156858637928963, 0.0156689640134573, 0.0156521592289209, 0.0156354382634163, 0.0156187443062663, 0.0156021574512124, 0.0155855659395456, 0.0155691336840391, 0.0155527461320162, 0.0155364358797669, 0.0155201703310013, 0.0155040072277188, 0.0154878441244364, 0.0154718039557338, 0.0154558075591922, 0.0154399517923594, 0.0154241276904941, 0.0154083240777254, 0.0153926173225045, 0.0153769422322512, 0.0153613947331905, 0.015345923602581, 0.0153305111452937, 0.0153151750564575, 0.0152998268604279, 0.0152846397832036, 0.0152694443240762, 0.015254377387464, 0.0152394007891417, 0.0152213852852583, 0.0152071984484792, 0.0151929780840874, 0.0151786813512444, 0.0151643380522728, 0.0151499640196562, 0.0151355713605881, 0.0151211274787784, 0.0151065727695823, 0.0150920515879989, 0.0150774717330933, 0.0150628155097365, 0.015048204921186, 0.015033446252346, 0.0150187257677317, 0.0150039475411177, 0.0149890864267945, 0.0149742448702455, 0.014959261752665, 0.0149443354457617, 0.0149293653666973, 0.0149142928421497, 0.0148992259055376, 0.0148841077461839, 0.0148689392954111, 0.0148537317290902, 0.0148384273052216, 0.0148231498897076, 0.0148078724741936, 0.0147924451157451, 0.0147770401090384, 0.014761608093977, 0.0147460736334324, 0.0147305391728878, 0.0147149218246341, 0.0146993286907673, 0.0146836983039975, 0.014667940326035, 0.0146522000432014, 0.0146364280954003, 0.0146205853670835, 0.0146046858280897, 0.0145887592807412, 0.0145728159695864, 0.0145568195730448, 0.01454072073102, 0.0145246675238013, 0.0145085165277123, 0.014492335729301, 0.0144761465489864, 0.0144598679617047, 0.0144436154514551, 0.0144272604957223, 0.0144108477979898, 0.0143944853916764, 0.0143779646605253, 0.0143614420667291, 0.0143449269235134, 0.0143283223733306, 0.0143117029219866, 0.0142950601875782, 0.0142783131450415, 0.0142615670338273, 0.0142447054386139, 0.0142279015854001, 0.0142110660672188, 0.0141941206529737, 0.0141771631315351, 0.0141601609066129, 0.014143068343401, 0.0141260325908661, 0.0141088189557195, 0.0140917003154755, 0.0140744922682643, 0.0140572022646666, 0.0140399103984237, 0.0140225943177938, 0.0140051990747452, 0.0139877488836646, 0.0139702390879393, 0.0139527805149555, 0.0139352595433593, 0.0139176025986671, 0.0139000033959746, 0.0138823473826051, 0.0138645879924297, 0.0138468286022544, 0.0138290245085955, 0.0138111962005496, 0.0137933073565364, 0.0137753495946527, 0.0137574104592204, 0.0137393623590469, 0.0137213217094541, 0.0137032484635711, 0.0136850979179144, 0.0136669036000967, 0.013648733496666, 0.0136304283514619, 0.0136121306568384, 0.013589434325695, 0.0135704074054956, 0.0135514298453927, 0.0135321179404855, 0.0135127305984497, 0.0134932920336723, 0.0134734688326716, 0.0134535683318973, 0.013433488085866, 0.0134133053943515, 0.0133929690346122, 0.0133724007755518, 0.0133516537025571, 0.0133309839293361, 0.0133098773658276, 0.0132886953651905, 0.0132673839107156, 0.0132458684965968, 0.0132242497056723, 0.0132023487240076, 0.0131804477423429, 0.0131583409383893, 0.0131360040977597, 0.0131134623661637, 0.0130909727886319, 0.0130681991577148, 0.0130451964214444, 0.0130222169682384, 0.0129988808184862, 0.012975568883121, 0.0129518732428551, 0.0129282018169761, 0.0129043534398079, 0.0128801697865129, 0.0128561910241842, 0.01283167488873, 0.0128071056678891, 0.0127824367955327, 0.0127576114609838, 0.0127326073125005, 0.0127073731273413, 0.0126820355653763, 0.0126566467806697, 0.0126309506595135, 0.0126050747931004, 0.0125791979953647, 0.0125529887154698, 0.0125267542898655, 0.012500237673521, 0.0124736428260803, 0.0124469725415111, 0.0124198915436864, 0.0123929642140865, 0.0123656000941992, 0.0123381353914738, 0.0123106185346842, 0.0122829219326377, 0.0122550446540117, 0.0122269382700324, 0.0121986512094736, 0.0121704414486885, 0.0121417446061969, 0.0121130468323827, 0.0120843257755041, 0.0120552182197571, 0.0120260072872043, 0.0119967209175229, 0.0119672557339072, 0.0119375064969063, 0.0119076566770673, 0.0118777537718415, 0.0118476981297135, 0.0118172578513622, 0.0117867905646563, 0.0117562729865313, 0.0117254229262471, 0.0116945207118988, 0.0116633865982294, 0.011632202193141, 0.0116007616743445, 0.0115691153332591, 0.0115374950692058, 0.0115055153146386, 0.0114734079688787, 0.0114412484690547, 0.0114089101552963, 0.0113762905821204, 0.0113436440005898, 0.0113107413053513, 0.0112778125330806, 0.0112445503473282, 0.0112111354246736, 0.0111778480932117, 0.0111440476030111, 0.0111102731898427, 0.0110762426629663, 0.011042108759284, 0.011007871478796, 0.010973303578794, 0.0109387850388885, 0.0109026217833161, 0.0108556393533945, 0.0108086569234729, 0.0107618281617761, 0.0107146929949522, 0.0106676612049341, 0.0106206275522709, 0.0105734914541245, 0.0105264065787196, 0.0104791177436709, 0.0104320328682661, 0.0103847431018949, 0.0103375045582652, 0.0102901635691524, 0.0102430284023285, 0.0101956371217966, 0.010148192755878, 0.0101009551435709, 0.0100535107776523, 0.0100060161203146, 0.00995847024023533, 0.00991118047386408, 0.00986358243972063, 0.00981603655964136, 0.00976849067956209, 0.00972079019993544, 0.00967329647392035, 0.00962554477155209, 0.00957794766873121, 0.00953014474362135, 0.00948239304125309, 0.00943469256162643, 0.00938694272190332, 0.00933908857405186, 0.00929113104939461, 0.0092433812096715, 0.00919542368501425, 0.00914751924574375, 0.00909945927560329, 0.00905160699039698, 0.00900354795157909, 0.00895548891276121, 0.00890753231942654, 0.00885931868106127, 0.00881131179630756, 0.00876299571245909, 0.00871498789638281, 0.00866667274385691, 0.00861840881407261, 0.00857029855251312, 0.00852193124592304, 0.00847361609339714, 0.00842524971812963, 0.00837693363428116, 0.00832836236804724, 0.00828009750694036, 0.00823147408664227, 0.00818310771137476, 0.00813463889062405, 0.00808596424758434, 0.00803749449551105, 0.00798892322927713, 0.00794029980897903, 0.00789162516593933, 0.00784300174564123, 0.00779437925666571, 0.00774555094540119, 0.00769677339121699, 0.00764804799109697, 0.00759927043691278, 0.00755033968016505, 0.00750151136890054, 0.00745252892374992, 0.0074037010781467, 0.00735477032139897, 0.00730578787624836, 0.00725680543109775, 0.00720766978338361, 0.00715868733823299, 0.00710955075919628, 0.00706046633422375, 0.00701132975518703, 0.0069621941074729, 0.00691300677135587, 0.00686376774683595, 0.00681447796523571, 0.00676523940637708, 0.00671605207026005, 0.00666650524362922, 0.00661726668477058, 0.00656797690317035, 0.00651848129928112, 0.00646908907219768, 0.00641959439963102, 0.00637004757300019, 0.00632044998928905, 0.0062709036283195, 0.00622130604460835, 0.00617175921797752, 0.00612211041152477, 0.00607716850936413, 0.00603475095704198, 0.00599212851375341, 0.00594986602663994, 0.00590785965323448, 0.00586590357124805, 0.00582441035658121, 0.0057829674333334, 0.00574167910963297, 0.00570085179060698, 0.00565992249175906, 0.00561924930661917, 0.00557898636907339, 0.0055388268083334, 0.00549892242997885, 0.00545922387391329, 0.00541957700625062, 0.00538049358874559, 0.00534125696867704, 0.00530248135328293, 0.0052637574262917, 0.0052252896130085, 0.0051871296018362, 0.0051491754129529, 0.00511142564937472, 0.00507372710853815, 0.00503628561273217, 0.00499920267611742, 0.00496227387338877, 0.00492549873888493, 0.00488898018375039, 0.00485276896506548, 0.00481655867770314, 0.00478065526112914, 0.00474505918100476, 0.00470956694334745, 0.00467433081939816, 0.00463935080915689, 0.00460431957617402, 0.00456985272467136, 0.00453538540750742, 0.00450112344697118, 0.00446727219969034, 0.00443336926400661, 0.0044000307098031, 0.00436658971011639, 0.00433345604687929, 0.00430063018575311, 0.00426775356754661, 0.00423544039949775, 0.00420307647436857, 0.00417107110843062, 0.00413921987637877, 0.00410762568935752, 0.0040761330164969, 0.00404494861140847, 0.00401396956294775, 0.00398324662819505, 0.00395257538184524, 0.00392226269468665, 0.00389210390858352, 0.00386230438016355, 0.00383255630731583, 0.00380280800163746, 0.00377377751283348, 0.00374464481137693, 0.0037158711347729, 0.00368719967082143, 0.00365852867253125, 0.00363047304563224, 0.00360236573033035, 0.0035745152272284, 0.00354702374897897, 0.00351948081515729, 0.00349260470829904, 0.00346547248773277, 0.00343875004909933, 0.00341228442266583, 0.00338581879623234, 0.00335986563004553, 0.0033339646179229, 0.0033082680311054, 0.0032828280236572, 0.00325749069452286, 0.00323251215741038, 0.0032076365314424, 0.00318296579644084, 0.00315860309638083, 0.00313444552011788, 0.00311059574596584, 0.00308679672889411, 0.00306335720233619, 0.00303981499746442, 0.00301663181744516, 0.00299391057342291, 0.00297118886373937, 0.00294877518899739, 0.00292641227133572, 0.0029042037203908, 0.0028826619964093, 0.00285990908741951, 0.00284631713293493, 0.0028328278567642, 0.00281938980333507, 0.00280636223033071, 0.0027933856472373, 0.00278043490834534, 0.00276779197156429, 0.00275520049035549, 0.00274296756833792, 0.00273076049052179, 0.00271868170239031, 0.00270688510499895, 0.00269508804194629, 0.00268367631360888, 0.00267223874107003, 0.00266087776981294, 0.00264987605623901, 0.00263895140960813, 0.00262838555499911, 0.00261766579933465, 0.00260733091272414, 0.00259699579328299, 0.00258689187467098, 0.00257709552533925, 0.00256727356463671, 0.00255765626206994, 0.00254819355905056, 0.00253883306868374, 0.00252983160316944, 0.00252085598185658, 0.00251211086288095, 0.00250334036536515, 0.00249477499164641, 0.00248667108826339, 0.00247843912802637, 0.0024703093804419, 0.00246256473474205, 0.00245484546758235, 0.0024474854581058, 0.00244009960442781, 0.00243276543915272, 0.00242589227855206, 0.00241891690529883, 0.00241224910132587, 0.0024056585971266, 0.00239922129549086, 0.00239309226162732, 0.00238693738356233, 0.0023811929859221, 0.00237534590996802, 0.0023699605371803, 0.00236444687470794, 0.00235911249183118, 0.00235421443358064, 0.00234903418458998, 0.0023444436956197, 0.00233975076116621, 0.00233528832904994, 0.00233113393187523, 0.00232687685638666, 0.00232297880575061, 0.0023191578220576, 0.00231543905101717, 0.00231213099323213, 0.002308668801561, 0.00230546342208982, 0.00230256537906826, 0.0022996673360467, 0.0022971541620791, 0.00229446170851588, 0.00229210220277309, 0.00229005049914122, 0.00228792196139693, 0.00228607561439276, 0.00228435755707324, 0.00228271610103548, 0.00228153634816408, 0.00228022853843868, 0.00227920291945338, 0.0022781768348068, 0.00227766414172947, 0.0022770743817091, 0.00227653561159968, 0.00227640732191503, 0.00227617681957781, 0.00227640755474567, 0.00227658683434129, 0.002276920247823, 0.00227753585204482, 0.0022782024461776, 0.00227915146388113, 0.00228012609295547, 0.00228128000162542, 0.00228276755660772, 0.00228412658907473, 0.00228576781228185, 0.00228774268180132, 0.00228974292986095, 0.00229199952445924, 0.00229349150322378, 0.00229087588377297, 0.00228838832117617, 0.00228592613711953, 0.00228346441872418, 0.00228113075718284, 0.0022788739297539, 0.00227651465684175, 0.00227436050772667, 0.00227218074724078, 0.0022700778208673, 0.00226807733997703, 0.00226600002497435, 0.00226410245522857, 0.00226223026402295, 0.00226038368418813, 0.00225853733718395, 0.00225684489123523, 0.00225515221245587, 0.00225348537787795, 0.00225189537741244, 0.00225040782243013, 0.00224892050027847, 0.00224756123498082, 0.00224609952419996, 0.00224484293721616, 0.00224356073886156, 0.00224232976324856, 0.00224117562174797, 0.00224012415856123, 0.00223904708400369, 0.00223802123218775, 0.00223707244731486, 0.00223617488518357, 0.00223537976853549, 0.00223461049608886, 0.00223381561227143, 0.00223317439667881, 0.00223253341391683, 0.00223194342106581, 0.00223143049515784, 0.00223094341345131, 0.00223053293302655, 0.00223014829680324, 0.00222984049469233, 0.00222955853678286, 0.00222940440289676, 0.00222922512330115, 0.0022290968336165, 0.00222904561087489, 0.0022290968336165, 0.0022290968336165, 0.00222922512330115, 0.0022293790243566, 0.00222958414815366, 0.00222981488332152, 0.00223014829680324, 0.00223050732165575, 0.00223096902482212, 0.00223143049515784, 0.00223194342106581, 0.00223250756971538, 0.00223320000804961, 0.00223384122364223, 0.00223458488471806, 0.00223535415716469, 0.00223622610792518, 0.00223707244731486, 0.00223804684355855, 0.00223904708400369, 0.00224007293581963, 0.00224122684448957, 0.00224235537461936, 0.00224356073886156, 0.00224486854858696, 0.00224617635831237, 0.00224748416803777, 0.00224894611164927, 0.00225038221105933, 0.00225189537741244, 0.00225351098924875, 0.00225515221245587, 0.00225681904703379, 0.00225861417129636, 0.00226033246144652, 0.00226220465265214, 0.00226412783376873, 0.0022660770919174, 0.00226800050586462, 0.00227010319940746, 0.00227215490303934, 0.00227433466352522, 0.00227654026821256, 0.0022788227070123, 0.00228113075718284, 0.00228354125283659, 0.00228587514720857, 0.00228838832117617, 0.00229090149514377, 0.00229346589185297, 0.00229441956616938, 0.00229639420285821, 0.00229839445091784, 0.00230049714446068, 0.00230262591503561, 0.00230480590835214, 0.00230708811432123, 0.00230934494175017, 0.00231178128160536, 0.00231421738862991, 0.00231667957268655, 0.00231921812519431, 0.00232183421030641, 0.00232445006258786, 0.00232721958309412, 0.00233001494780183, 0.00233281031250954, 0.00233573373407125, 0.00233865715563297, 0.00234163226559758, 0.00234470958821476, 0.00234778691083193, 0.00235096691176295, 0.00235424959100783, 0.00235753203742206, 0.00236086617223918, 0.00236427667550743, 0.00236773886717856, 0.00237127766013145, 0.00237479130737484, 0.00237845839001238, 0.00238210009410977, 0.00238592154346406, 0.00238969130441546, 0.00239358912222087, 0.00239743595011532, 0.00240151328034699, 0.00240551400929689, 0.00240961764939129, 0.00241372059099376, 0.00241795228794217, 0.00242220913060009, 0.00242649205029011, 0.00243090279400349, 0.00243533938191831, 0.00243982719257474, 0.00244441814720631, 0.00244903401471674, 0.00245362427085638, 0.00245836889371276, 0.00246311305090785, 0.00246801134198904, 0.00247293524444103, 0.00247785914689302, 0.00248286011628807, 0.00248798890970647, 0.00249304110184312, 0.00249822135083377, 0.00250347889959812, 0.00250878720544279, 0.0025141213554889, 0.00251958379521966, 0.00252499501220882, 0.00253053451888263, 0.00253615039400756, 0.00254181819036603, 0.00254746014252305, 0.00255323015153408, 0.00255900039337575, 0.00256492430344224, 0.00257084844633937, 0.0025767982006073, 0.00258285040035844, 0.00258895405568182, 0.00259508308954537, 0.00260136625729501, 0.00260762358084321, 0.00261388090439141, 0.00262029212899506, 0.00262672919780016, 0.00263329432345927, 0.00263985968194902, 0.00264645041897893, 0.00265311799012125, 0.00265986262820661, 0.00266660749912262, 0.00267345458269119, 0.00268040457740426, 0.00268740579485893, 0.00269438116811216, 0.00270145898684859, 0.00270853727124631, 0.00271571753546596, 0.00272297533228993, 0.00273033557459712, 0.00273766997270286, 0.0027451072819531, 0.00275254412554204, 0.00276016094721854, 0.00276770046912134, 0.00277664512395859, 0.00278759561479092, 0.00279862270690501, 0.00280967587605119, 0.00282075465656817, 0.0028317307587713, 0.00284275808371603, 0.00285391369834542, 0.00286494102329016, 0.00287604541517794, 0.00288709858432412, 0.00289822835475206, 0.00290935835801065, 0.00292046274989843, 0.00293159275315702, 0.00294272252358496, 0.00295385252684355, 0.00296505982987583, 0.00297621521167457, 0.00298737059347332, 0.00299855205230415, 0.00300973327830434, 0.00302096572704613, 0.00303219840861857, 0.00304340501315892, 0.00305458647198975, 0.0030659215990454, 0.00307712843641639, 0.00308843818493187, 0.00309967040084302, 0.00311095453798771, 0.00312226382084191, 0.00313352211378515, 0.00314485724084079, 0.00315611530095339, 0.00316752749495208, 0.00317886285483837, 0.00319024873897433, 0.00320155825465918, 0.00321291899308562, 0.00322430557571352, 0.00323569215834141, 0.00324712973088026, 0.00325851631350815, 0.00326995365321636, 0.0032813660800457, 0.00329280341975391, 0.00330424145795405, 0.0033157046418637, 0.00332716782577336, 0.00333863170817494, 0.00335014634765685, 0.0033616095315665, 0.00337307271547616, 0.00338466442190111, 0.00339617906138301, 0.00340769370086491, 0.00341920810751617, 0.00343077420257032, 0.00344231468625367, 0.00345388054847717, 0.00346549763344228, 0.00347706349566579, 0.00348868104629219, 0.00350029789842665, 0.00351191544905305, 0.00352353253401816, 0.00353512424044311, 0.00354679254814982, 0.00355846108868718, 0.00357018085196614, 0.0035817981697619, 0.00359344109892845, 0.00360521208494902, 0.00361685524694622, 0.00362862623296678, 0.00364029477350414, 0.0036520657595247, 0.00366381090134382, 0.00367555650882423, 0.00368732772767544, 0.00369907333515584, 0.00371081870980561, 0.00372258992865682, 0.00373443774878979, 0.0037462601903826, 0.00375805678777397, 0.00376987946219742, 0.00378172728233039, 0.00379360117949545, 0.00380544923245907, 0.00381727144122124, 0.00382922193966806, 0.00384107022546232, 0.00385299511253834, 0.00386484316550195, 0.00387676805257797, 0.00388874462805688, 0.00390061805956066, 0.00391259463503957, 0.00392646854743361, 0.00393777759745717, 0.0039491388015449, 0.00396024296060205, 0.00397139880806208, 0.00398237444460392, 0.00399337615817785, 0.00400407053530216, 0.00401471322402358, 0.0040254327468574, 0.00403584493324161, 0.00404635956510901, 0.00405664276331663, 0.00406697764992714, 0.00407708203420043, 0.00408713473007083, 0.00409700814634562, 0.0041069071739912, 0.00411662645637989, 0.00412629498168826, 0.00413583498448133, 0.004145298153162, 0.00415470963343978, 0.00416391622275114, 0.00417314888909459, 0.00418220134451985, 0.00419125379994512, 0.00420010136440396, 0.00420897454023361, 0.00421761721372604, 0.00422628503292799, 0.00423472234979272, 0.00424308283254504, 0.00425146892666817, 0.00425962405279279, 0.00426788162440062, 0.00427583139389753, 0.00428383285179734, 0.00429160334169865, 0.00429937383159995, 0.00430701579898596, 0.00431455532088876, 0.00432201800867915, 0.00432945508509874, 0.00433666165918112, 0.0043438165448606, 0.00435086898505688, 0.00435784459114075, 0.00436476897448301, 0.00437151361256838, 0.00437830947339535, 0.00438479753211141, 0.00439141411334276, 0.00439772289246321, 0.00440408289432526, 0.0044102631509304, 0.00441634096205235, 0.00442246999591589, 0.00442831730470061, 0.00443424144759774, 0.00443993415683508, 0.00444560218602419, 0.00445109000429511, 0.00445655267685652, 0.00446191243827343, 0.00446722097694874, 0.00447237538173795, 0.00447742734104395, 0.00448237732052803, 0.00448730075731874, 0.00449204538017511, 0.00449663586914539, 0.00450132833793759, 0.00450573954731226, 0.00451022759079933, 0.0045144590549171, 0.00451876735314727, 0.00452281907200813, 0.00452689686790109, 0.00453071808442473, 0.00453459052368999, 0.00453830882906914, 0.00454192468896508, 0.00454548932611942, 0.00454892590641975, 0.00455228565260768, 0.00455549126490951, 0.00455864565446973, 0.00456172274425626, 0.00456472299993038, 0.00456757005304098, 0.00457039102911949, 0.00457300618290901, 0.00457562226802111, 0.00457813544198871, 0.00458046933636069, 0.00458285445347428, 0.00458495691418648, 0.00458711152896285, 0.00458906078711152, 0.00459298398345709, 0.00459134299308062, 0.00458964984863997, 0.00458785472437739, 0.00458606006577611, 0.00458395713940263, 0.00458164885640144, 0.00457944348454475, 0.00457687908783555, 0.00457451958209276, 0.00457180105149746, 0.00456903129816055, 0.00456600543111563, 0.00456303078681231, 0.00455974787473679, 0.00455651665106416, 0.00455302931368351, 0.00454964395612478, 0.00454589957371354, 0.00454205274581909, 0.00453815469518304, 0.00453405128791928, 0.00453005079180002, 0.00452564004808664, 0.00452122930437326, 0.00451666442677379, 0.00451215077191591, 0.00450722686946392, 0.00450235465541482, 0.00449737906455994, 0.00449209613725543, 0.00448686443269253, 0.00448137661442161, 0.00447588879615068, 0.00447029806673527, 0.00446455366909504, 0.00445855222642422, 0.00445260293781757, 0.00444634538143873, 0.00444008782505989, 0.00443362537771463, 0.00442721415311098, 0.00442054634913802, 0.00441372487694025, 0.00440680049359798, 0.00439972244203091, 0.00439259316772223, 0.00438536144793034, 0.00437802681699395, 0.00437043607234955, 0.00436284532770514, 0.00435499753803015, 0.00434709899127483, 0.00433904631063342, 0.0043308911845088, 0.00432273605838418, 0.00431427313014865, 0.00430575897917151, 0.00429703993722796, 0.00428832042962313, 0.00427944725379348, 0.00427052238956094, 0.00426129065454006, 0.00425200676545501, 0.00424262089654803, 0.00423318333923817, 0.00422354089096189, 0.0042136930860579, 0.00420389696955681, 0.00419374136254191, 0.00418373988941312, 0.00417343061417341, 0.00416312133893371, 0.0041526067070663, 0.00414198962971568, 0.00413111597299576, 0.00412029353901744, 0.0041092149913311, 0.00409818766638637, 0.00408695498481393, 0.00407551787793636, 0.00406402861699462, 0.00405233399942517, 0.00404063984751701, 0.00402868958190084, 0.00401679007336497, 0.0040046856738627, 0.00399242760613561, 0.00398001493886113, 0.00396755151450634, 0.00395488273352385, 0.00394211150705814, 0.00392928905785084, 0.00391626125201583, 0.00390318245626986, 0.00388989830389619, 0.00387656292878091, 0.00386307341977954, 0.0038495329208672, 0.00383573584258556, 0.00382248242385685, 0.00380618474446237, 0.00378981046378613, 0.00377352582290769, 0.00375712616369128, 0.00374063639901578, 0.0037241077516228, 0.00370759260840714, 0.00369100016541779, 0.00367439491674304, 0.00365786673501134, 0.00364121049642563, 0.00362443854101002, 0.00360770500265062, 0.00359083083458245, 0.00357411033473909, 0.00355726131238043, 0.00354029703885317, 0.00352337164804339, 0.00350635591894388, 0.00348935322836041, 0.00347226089797914, 0.00345514295622706, 0.00343812722712755, 0.00342093221843243, 0.00340369902551174, 0.00338638853281736, 0.00336911645717919, 0.00335184461437166, 0.00333447009325027, 0.00331704434938729, 0.0032996314112097, 0.00328214140608907, 0.00326459994539618, 0.00324704637750983, 0.00322953052818775, 0.00321183539927006, 0.00319421757012606, 0.00317645794712007, 0.00315869902260602, 0.00314088840968907, 0.00312316813506186, 0.00310524203814566, 0.00308739300817251, 0.00306946714408696, 0.00305142579600215, 0.00303342309780419, 0.00301535613834858, 0.00299732782877982, 0.00297920941375196, 0.0029610141646117, 0.00294272927567363, 0.00292449560947716, 0.00290633901022375, 0.00288796424865723, 0.00286962813697755, 0.00285120215266943, 0.00283272517845035, 0.00281427334994078, 0.00279577053152025, 0.00277713919058442, 0.00275867478922009, 0.00274000526405871, 0.00272130989469588, 0.00270264036953449, 0.0026838812045753, 0.00266517302952707, 0.00264633703045547, 0.00262750079855323, 0.00260853627696633, 0.0025896483566612, 0.0025706454180181, 0.002551578450948, 0.00253267819061875, 0.00251356000080705, 0.002494364278391, 0.00247519486583769, 0.00245605083182454, 0.00243684253655374, 0.00241755740717053, 0.00239823386073112, 0.00237883348017931, 0.0023594971280545, 0.00234005809761584, 0.00232059368863702, 0.00230103940702975, 0.00228153634816408, 0.00226189219392836, 0.00224228645674884, 0.00222264230251312, 0.00220288289710879, 0.00218326458707452, 0.00216349214315414, 0.00214370689354837, 0.00212381919845939, 0.0021039315033704, 0.00208397977985442, 0.00206397660076618, 0.00204403745010495, 0.00202395743690431, 0.00200098776258528, 0.0019823822658509, 0.00196393043734133, 0.00194545311387628, 0.00192709115799516, 0.00190879346337169, 0.00189057260286063, 0.00187230028677732, 0.00185431027784944, 0.00183621747419238, 0.00181825319305062, 0.00180034001823515, 0.00178245257120579, 0.00176478317007422, 0.001746985479258, 0.00172929011750966, 0.00171176181174815, 0.00169420754536986, 0.00167682010214776, 0.00165939435828477, 0.00164218642748892, 0.00162487605120987, 0.00160770653747022, 0.00159062689635903, 0.00157353444956243, 0.00155664712656289, 0.00153968273662031, 0.0015228979755193, 0.00150610052514821, 0.00148943113163114, 0.00147273612674326, 0.00145624624565244, 0.00143966672476381, 0.00142320257145911, 0.00140691793058068, 0.00139053061138839, 0.00137432280462235, 0.00135817925911397, 0.00134209974203259, 0.00132599461358041, 0.00131013302598149, 0.00129415607079864, 0.00127834582235664, 0.00126258702948689, 0.00124691775999963, 0.00123123580124229, 0.00121568201575428, 0.00120019225869328, 0.00118471554014832, 0.00116930285003036, 0.00115406955592334, 0.00113874662201852, 0.00112368003465235, 0.00110853661317378, 0.00109352136496454, 0.00107854465022683, 0.00106370903085917, 0.00104886037297547, 0.00103405024856329, 0.00101939414162189, 0.00100471230689436, 0.000990248401649296, 0.000975643517449498, 0.000961256620939821, 0.000946882530115545, 0.0009326366125606, 0.000918352336157113, 0.000904260319657624, 0.000890104216523468, 0.000876101898029447, 0.000862163840793073, 0.000848212803248316, 0.000834467122331262, 0.000820631510578096, 0.000807026808615774, 0.000793383514974266, 0.00077984289964661, 0.000766276672948152, 0.000752928375732154, 0.000739541545044631, 0.000726167636457831, 0.000713050132617354, 0.000699855794664472, 0.000686789571773261, 0.000673736212775111, 0.000660734134726226, 0.000647860346361995, 0.000635050470009446, 0.000622356194071472, 0.000609572103712708, 0.00059707002947107, 0.000584414228796959, 0.000571989163290709, 0.000559551233891398, 0.00054713903227821, 0.000534919090569019, 0.000522647926118225, 0.000510530604515225, 0.000498400477226824, 0.000486488308524713, 0.000473332329420373, 0.000464766897493973, 0.000456303969258443, 0.000447969301603734, 0.000439608964370564, 0.000431428197771311, 0.000423324265284464, 0.000415143498685211, 0.000407244777306914, 0.000399269163608551, 0.000391473033232614, 0.000383676902856678, 0.000376009003957734, 0.000368392386008054, 0.000360852689482272, 0.000353389943484217, 0.000345952837960795, 0.000338746584020555, 0.000331437709974125, 0.000324334017932415, 0.00031728160683997, 0.000310177885694429, 0.000303330627502874, 0.000296432088362053, 0.000289738673018292, 0.000282917084405199, 0.000276428851066157, 0.000269812415353954, 0.000263375462964177, 0.000257015461102128, 0.000250681128818542, 0.000244474998908117, 0.000238294509472325, 0.000232267891988158, 0.000226241289055906, 0.000220317277126014, 0.000214418876566924, 0.000208725658012554, 0.000202929863007739, 0.000197364861378446, 0.000191774219274521, 0.000186311808647588, 0.000180926319444552, 0.000175617795321159, 0.00017041181854438, 0.000165154560818337, 0.000160153766046278, 0.000155101661221124, 0.000150229097926058, 0.000145356505527161, 0.000140509568154812, 0.000135867798235267, 0.000131123466417193, 0.000126635568449274, 0.000122147655929439, 0.000117736701213289, 0.000113505244371481, 0.000109196866105776, 0.000105068000266328, 0.000100939134426881, 9.69641332630999e-05, 9.29891393752769e-05, 8.91423696884885e-05, 8.52955927257426e-05, 8.17052787169814e-05, 7.80123882577755e-05, 7.43707787478343e-05, 7.1036905865185e-05, 6.74978800816461e-05, 6.42409504507668e-05, 6.10096649324987e-05, 5.7855315390043e-05, 5.4675321734976e-05, 5.17774242325686e-05, 4.87256584165152e-05, 4.58790455013514e-05, 4.31093758379575e-05, 4.03653502871748e-05, 3.77751894120593e-05, 3.51850358129013e-05, 3.27487505273893e-05, 3.02868211292662e-05, 2.79787636827677e-05, 2.56963503488805e-05, 2.34652252402157e-05, 2.14136198337656e-05, 1.93363684957149e-05, 1.74386314029107e-05, 1.55408943101065e-05, 1.36688040583977e-05, 1.2078810868843e-05, 1.03862357718754e-05, 8.796241672826e-06, 7.3088285716949e-06, 5.92399646848207e-06, 4.53916391052189e-06, 3.30820284943911e-06, 2.10288658308855e-06, 1.07708683572127e-06, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 2.29488182234736e-15, 7.6935106108067e-07, 3.23127437695803e-06, 5.74448768020375e-06, 8.20641162135871e-06, 1.08222047856543e-05, 1.34892889036564e-05, 1.62076630658703e-05, 1.88234553206712e-05, 2.16444095713086e-05, 2.44140737777343e-05, 2.73376081167953e-05, 3.02611424558563e-05, 3.32359668391291e-05, 3.62107894034125e-05, 3.92881920561194e-05, 4.24168865720276e-05, 4.55455847259145e-05, 4.86742792418227e-05, 5.19568420713767e-05, 5.5290696764132e-05, 5.86245514568873e-05, 6.20096980128437e-05, 6.54974210192449e-05, 6.89338558004238e-05, 7.24728670320474e-05, 7.61144692660309e-05, 7.96534804976545e-05, 8.33976519061252e-05, 8.71418378665112e-05, 9.09372902242467e-05, 9.46814761846326e-05, 9.86308077699505e-05, 0.000102580146631226, 0.000106478189991321, 0.000110530105303042, 0.000114633308839984, 0.000118582640425302, 0.000122788434964605, 0.000127045510453172, 0.000131302585941739, 0.000135559661430307, 0.000139919313369319, 0.000144381541758776, 0.000148843784700148, 0.00015330602764152, 0.000157870832481422, 0.000162384356372058, 0.000167051766766235, 0.000171770458109677, 0.000176540430402383   }, 
   { 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 9.16412602691707e-07, 4.34808544014231e-06, 7.81875496613793e-06, 1.13479190986254e-05, 1.49550751302741e-05, 1.860122938524e-05, 2.24033647100441e-05, 2.6205503672827e-05, 3.00466363114538e-05, 3.39852631441317e-05, 3.8060374208726e-05, 4.2115989344893e-05, 4.62495954707265e-05, 5.04416930198204e-05, 5.47312847629655e-05, 5.90988674957771e-05, 6.34859534329735e-05, 6.79510267218575e-05, 7.25135832908563e-05, 7.71541454014368e-05, 8.18141998024657e-05, 8.65327529027127e-05, 9.13682961254381e-05, 9.62428239290603e-05, 0.00010121485684067, 0.000106206382042728, 0.000111275898234453, 0.000116423412691802, 0.000121629404020496, 0.000126913408166729, 0.000132294895593077, 0.000137695868033916, 0.000143155353725888, 0.000148731836816296, 0.000154347304487601, 0.000160001756739803, 0.00016577320639044, 0.00017158365517389, 0.000177511086803861, 0.000183438503881916, 0.00018942444876302, 0.000195488362805918, 0.000201688788365573, 0.000207908684387803, 0.000214167594094761, 0.000220504487515427, 0.000226997362915426, 0.000233451253734529, 0.000239944129134528, 0.000246554001932964, 0.000253261358011514, 0.000260027212789282, 0.000266851566266268, 0.000273714889772236, 0.000280675769317895, 0.000287675560684875, 0.000294792407657951, 0.000301928695989773, 0.000309162511257455, 0.000316435325657949, 0.000323825108353049, 0.000331214949255809, 0.000338721729349345, 0.000346247979905456, 0.000353891256963834, 0.000361554062692448, 0.000369333807611838, 0.000377133052097633, 0.000385010323952883, 0.000392985064536333, 0.000401037774281576, 0.00040909051313065, 0.000417221250245348, 0.00042546892655082, 0.000433775159763172, 0.000442120363004506, 0.000450543564511463, 0.000459005765151232, 0.00046762396232225, 0.000476222601719201, 0.00048487979802303, 0.000493614934384823, 0.000502506096381694, 0.000511377758812159, 0.000520327419508249, 0.000529335578903556, 0.000538441236130893, 0.000547624833416194, 0.0005568279302679, 0.000566109083592892, 0.000575468176975846, 0.000584944267757237, 0.000594420358538628, 0.000603915948886424, 0.000613586977124214, 0.00062323862221092, 0.000633026647847146, 0.000642853730823845, 0.000652758812066168, 0.000662702834233642, 0.000673543836455792, 0.000686919549480081, 0.000700334261637181, 0.000713670975528657, 0.000727046688552946, 0.000740383460652083, 0.000753798172809184, 0.000767173944041133, 0.000780510657932609, 0.000793886312749237, 0.000807262083981186, 0.000820637797005475, 0.000833974510896951, 0.000847350223921239, 0.000860764994286001, 0.000874101708177477, 0.000887477421201766, 0.000900814135093242, 0.000914228847250342, 0.000927604560274631, 0.000940941332373768, 0.000954317045398057, 0.000967692758422345, 0.000981068471446633, 0.000994444242678583, 0.00100778101477772, 0.00102119566872716, 0.00103453232441097, 0.00104790809564292, 0.00106128386687487, 0.0010746595216915, 0.00108803529292345, 0.00110137206502259, 0.00111474783625454, 0.00112812349107116, 0.00114149926230311, 0.00115487503353506, 0.00116821168921888, 0.00118162634316832, 0.00119496311526746, 0.00120833877008408, 0.00122171454131603, 0.00123509031254798, 0.00124846608377993, 0.00126180285587907, 0.00127517862711102, 0.00128855416551232, 0.00130192993674427, 0.0013153055915609, 0.00132864236366004, 0.0013420571340248, 0.00135539390612394, 0.00136876956094056, 0.00138214533217251, 0.00139552110340446, 0.00140889664180577, 0.00142227241303772, 0.00143560918513685, 0.00144902395550162, 0.00146236072760075, 0.00147573626600206, 0.00148907315451652, 0.00150248780846596, 0.00151586357969791, 0.00152920023538172, 0.00154257600661367, 0.00155595177784562, 0.00156932743266225, 0.00158270308747888, 0.00159603985957801, 0.00160945462994277, 0.00162279140204191, 0.00163616717327386, 0.00164950382895768, 0.00166291848290712, 0.00167629413772374, 0.0016896310262382, 0.00170300668105483, 0.00171638245228678, 0.00172975822351873, 0.00174313399475068, 0.00175647053401917, 0.00176988530438393, 0.00178322207648307, 0.0017965977312997, 0.00180997350253165, 0.0018233492737636, 0.00183672504499555, 0.00185006181709468, 0.00186343747191131, 0.00187685212586075, 0.00189018878154457, 0.00190356455277652, 0.00191690132487565, 0.00193031609524041, 0.00194365286733955, 0.00195702840574086, 0.00197040406055748, 0.00198377994820476, 0.00199715560302138, 0.00200923951342702, 0.00201790174469352, 0.00202653929591179, 0.00203506974503398, 0.00204361486248672, 0.00205209665000439, 0.00206054421141744, 0.00206895265728235, 0.00207733199931681, 0.00208568689413369, 0.00209395913407207, 0.00210222159512341, 0.00211043492890894, 0.00211859005503356, 0.00212671607732773, 0.00213479297235608, 0.00214285054244101, 0.00215087900869548, 0.00215882458724082, 0.0021667554974556, 0.00217462750151753, 0.00218249531462789, 0.00219027511775494, 0.00219806446693838, 0.00220581493340433, 0.00221347296610475, 0.00222113565541804, 0.00222872523590922, 0.00223630527034402, 0.00224380730651319, 0.00225129956379533, 0.00225876225158572, 0.00226614740677178, 0.00227354164235294, 0.00228082435205579, 0.00228813616558909, 0.00229539419524372, 0.00230258447118104, 0.00230975006707013, 0.00231688632629812, 0.00232398346997797, 0.00233103218488395, 0.00233801268041134, 0.00234499294310808, 0.00235190475359559, 0.00235881214030087, 0.00236566574312747, 0.00237244134768844, 0.00237923162057996, 0.00238590966910124, 0.00239262660034001, 0.00239928043447435, 0.00240586581639946, 0.0024124369956553, 0.00241893925704062, 0.0024254615418613, 0.00243188627064228, 0.00243830122053623, 0.00244468660093844, 0.00245097489096224, 0.00245727272704244, 0.00246350234374404, 0.0024697077460587, 0.00247584958560765, 0.00248198676854372, 0.00248809461481869, 0.00249411468394101, 0.00250011519528925, 0.00250610592775047, 0.00251200888305902, 0.0025178927462548, 0.00252374680712819, 0.00252954754978418, 0.00253533362410963, 0.00254103192128241, 0.00254672043956816, 0.00255233142524958, 0.00255796615965664, 0.00256349868141115, 0.00256902631372213, 0.00257452484220266, 0.00257994513958693, 0.00258535123430192, 0.00259070354513824, 0.00259603653103113, 0.00260132504627109, 0.00260654068551958, 0.00261177611537278, 0.00261690886691213, 0.00262204185128212, 0.00262710149399936, 0.00263215648010373, 0.00263717235065997, 0.00264212023466825, 0.0026470385491848, 0.00265191309154034, 0.00265675829723477, 0.00266156462021172, 0.00266631715930998, 0.00267105037346482, 0.00267614424228668, 0.00267951260320842, 0.00268294429406524, 0.00268643442541361, 0.00268993945792317, 0.00269346847198904, 0.00269705126993358, 0.00270065828226507, 0.00270431907847524, 0.00270806299522519, 0.00271180644631386, 0.00271557946689427, 0.0027193957939744, 0.00272326171398163, 0.00272716605104506, 0.00273112417198718, 0.002735102083534, 0.00273912842385471, 0.00274317874573171, 0.00274725421331823, 0.00275139720179141, 0.00275564799085259, 0.00275983521714807, 0.00276409089565277, 0.00276838499121368, 0.00277272355742753, 0.00277710077352822, 0.00278152688406408, 0.00278602121397853, 0.00279052066616714, 0.00279507809318602, 0.0027996504213661, 0.0028042618650943, 0.00280894129537046, 0.00281366962008178, 0.00281841261312366, 0.0028231895994395, 0.00282801524735987, 0.0028328753542155, 0.00283776922151446, 0.00284275109879673, 0.00284774764440954, 0.00285275862552226, 0.00285779871046543, 0.00286288768984377, 0.00286805490031838, 0.00287321186624467, 0.00287847663275898, 0.00288376538082957, 0.00288905436173081, 0.00289437733590603, 0.00289977830834687, 0.00290518417023122, 0.00291068246588111, 0.00291620055213571, 0.00292174774222076, 0.0029273193795234, 0.00293295411393046, 0.00293861352838576, 0.0029443462844938, 0.00295009324327111, 0.00295587442815304, 0.00296169938519597, 0.00296756369061768, 0.00297346175648272, 0.00297940871678293, 0.00298542412929237, 0.00299143884330988, 0.00299752247519791, 0.00300363008864224, 0.00300974282436073, 0.00301592401228845, 0.00302221183665097, 0.00302845658734441, 0.0030347544234246, 0.00304112024605274, 0.00304750096984208, 0.00305391103029251, 0.00306043331511319, 0.00306693115271628, 0.0030734627507627, 0.00308005814440548, 0.00308667286299169, 0.00309336092323065, 0.00310009228996933, 0.00310684368014336, 0.00311362440697849, 0.00312045821920037, 0.003127321600914, 0.00313422386534512, 0.00314120925031602, 0.00314820907078683, 0.00315522332675755, 0.00316228647716343, 0.00316936918534338, 0.00317653967067599, 0.00318375881761312, 0.00319097586907446, 0.00319824134930968, 0.00320555781945586, 0.00321442680433393, 0.00322715705260634, 0.00323993782512844, 0.00325279217213392, 0.00326564372517169, 0.00327855651266873, 0.00329149095341563, 0.00330447684973478, 0.00331746996380389, 0.00333057995885611, 0.00334367551840842, 0.00335680996067822, 0.00336997350677848, 0.00338320550508797, 0.00339645915664732, 0.00340975727885962, 0.00342312781140208, 0.00343651324510574, 0.00344991334713995, 0.00346337701193988, 0.00347688212059438, 0.00349038909189403, 0.00350403552874923, 0.00351763051003218, 0.00353128160350025, 0.00354498671367764, 0.00355871813371778, 0.00357250310480595, 0.00358636165037751, 0.00360021251253784, 0.00361410970799625, 0.00362806557677686, 0.00364202866330743, 0.00365605019032955, 0.0036701571661979, 0.00368423969484866, 0.00369838089682162, 0.00371256330981851, 0.00372678227722645, 0.00374105223454535, 0.00375539320521057, 0.00376972928643227, 0.00378411891870201, 0.00379853299818933, 0.00381298852153122, 0.00382745615206659, 0.00384202599525452, 0.00385661562904716, 0.00387123646214604, 0.00388588942587376, 0.00390061060898006, 0.00391534669324756, 0.00393011840060353, 0.00394499581307173, 0.0039598485454917, 0.00397475203499198, 0.00398969277739525, 0.00400465726852417, 0.00401970045641065, 0.00403479160740972, 0.00404989579692483, 0.00406503351405263, 0.00408022291958332, 0.00409544073045254, 0.0041107009164989, 0.00412604585289955, 0.00414140056818724, 0.00415677484124899, 0.00417217100039124, 0.00418766960501671, 0.00420315144583583, 0.00421867426484823, 0.00423430185765028, 0.00424994388595223, 0.0042655817233026, 0.00428128987550735, 0.00429704645648599, 0.00431281607598066, 0.00432868208736181, 0.00434455135837197, 0.00436044484376907, 0.00437638442963362, 0.00439237337559462, 0.00440840283408761, 0.00442447466775775, 0.00444060144945979, 0.00445674359798431, 0.00447295187041163, 0.00448915734887123, 0.00450543826445937, 0.00452174106612802, 0.00453812442719936, 0.00455451477319002, 0.00457093957811594, 0.00458740117028356, 0.00460386974737048, 0.00462045054882765, 0.00463706301525235, 0.00465366523712873, 0.00467032473534346, 0.00468641286715865, 0.00470240786671638, 0.00471836747601628, 0.00473424140363932, 0.00475004222244024, 0.00476582627743483, 0.00478157307952642, 0.00479726400226355, 0.00481288507580757, 0.00482840510085225, 0.00484393537044525, 0.00485938275232911, 0.00487480591982603, 0.00489012198522687, 0.00490541383624077, 0.00492067309096456, 0.00493585504591465, 0.00495096296072006, 0.00496605737134814, 0.00498107774183154, 0.00499607436358929, 0.0050110099837184, 0.00502583337947726, 0.00504065491259098, 0.00505544664338231, 0.00507016014307737, 0.00508474232628942, 0.00509938318282366, 0.00511393137276173, 0.00512844230979681, 0.0051428833976388, 0.00515724159777164, 0.00517157558351755, 0.005185860209167, 0.00520010059699416, 0.00521423434838653, 0.0052283639088273, 0.00524242874234915, 0.00525644794106483, 0.00527037680149078, 0.00528428936377168, 0.00529815489426255, 0.00531194685027003, 0.0053257392719388, 0.00533938547596335, 0.00535300513729453, 0.00536661688238382, 0.00538016622886062, 0.00539358844980597, 0.00540703209117055, 0.00542042497545481, 0.00543372984975576, 0.00544697651639581, 0.00546018639579415, 0.00547334039583802, 0.00548646505922079, 0.00549950450658798, 0.00551247829571366, 0.00552542693912983, 0.00553830806165934, 0.00555115006864071, 0.00556390453130007, 0.00557666877284646, 0.00558933475986123, 0.00560198165476322, 0.00561455776914954, 0.00562703935429454, 0.00563950138166547, 0.00565191451460123, 0.0056642834097147, 0.00567655032500625, 0.00568880746141076, 0.00570099800825119, 0.00571314292028546, 0.00572521053254604, 0.00573723809793591, 0.00574923399835825, 0.00576115492731333, 0.00577303674072027, 0.00578483333811164, 0.00579661969095469, 0.00580832362174988, 0.00581998098641634, 0.00583158992230892, 0.00584313739091158, 0.00585465785115957, 0.00586609169840813, 0.00587746594101191, 0.00588880712166429, 0.00590008636936545, 0.00591134466230869, 0.00592250702902675, 0.00593361351639032, 0.0059446906670928, 0.00595570029690862, 0.00596668431535363, 0.00597755052149296, 0.00598842045292258, 0.00599923403933644, 0.00601001922041178, 0.00601986609399319, 0.00602711923420429, 0.00603436306118965, 0.00604153843596578, 0.00604861648753285, 0.00605560652911663, 0.00606255745515227, 0.00606945995241404, 0.0060762744396925, 0.00608301069587469, 0.00608968921005726, 0.00609631789848208, 0.00610287953168154, 0.0061093526892364, 0.00611576763913035, 0.00612210435792804, 0.00612840242683887, 0.00613464135676622, 0.00614073500037193, 0.00614682817831635, 0.00615289201959968, 0.00615883897989988, 0.00616469839587808, 0.00617051823064685, 0.00617627007886767, 0.00618196371942759, 0.00618757959455252, 0.00619310699403286, 0.00619858596473932, 0.00620401604101062, 0.00620936835184693, 0.00621461356058717, 0.00621983921155334, 0.00622498616576195, 0.006230094935745, 0.00623510591685772, 0.00624000979587436, 0.00624492345377803, 0.00624973932281137, 0.00625448720529675, 0.00625914754346013, 0.00626375898718834, 0.00626831129193306, 0.00627279561012983, 0.0062771737575531, 0.00628155050799251, 0.00628583086654544, 0.00629003252834082, 0.00629420531913638, 0.00629824120551348, 0.00630226731300354, 0.00630621565505862, 0.00631010578945279, 0.00631389813497663, 0.00631762202829123, 0.00632133660838008, 0.0063249533995986, 0.00632846308872104, 0.00633193366229534, 0.00633535534143448, 0.00633870949968696, 0.00634199474006891, 0.0063451724126935, 0.0063483314588666, 0.00635139318183064, 0.00635441578924656, 0.00635732058435678, 0.00636020628735423, 0.00636303331702948, 0.00636576302349567, 0.00636846339330077, 0.00637103710323572, 0.00637357169762254, 0.00637605832889676, 0.00637847604230046, 0.00638080621138215, 0.0063830679282546, 0.00638529052957892, 0.00638743536546826, 0.00638946332037449, 0.00639150058850646, 0.00639344099909067, 0.00639532180503011, 0.00639714580029249, 0.00639883149415255, 0.00640053814277053, 0.00640214653685689, 0.00640367716550827, 0.00640513002872467, 0.00640653353184462, 0.00640788907185197, 0.00640915613621473, 0.00641033612191677, 0.00641149561852217, 0.00641256850212812, 0.00641354359686375, 0.00641450844705105, 0.00641533685848117, 0.00641616573557258, 0.00641690660268068, 0.00641503510996699, 0.00641111563891172, 0.00640727439895272, 0.00640347274020314, 0.00639978749677539, 0.00639624800533056, 0.00639268988743424, 0.00638924865052104, 0.00638584652915597, 0.00638253148645163, 0.0063793626613915, 0.00637624319642782, 0.00637321127578616, 0.00637025758624077, 0.00636731320992112, 0.00636449549347162, 0.00636175647377968, 0.00635918276384473, 0.00635662814602256, 0.00635408423841, 0.00635167583823204, 0.00634934520348907, 0.00634709326550364, 0.00634499778971076, 0.00634285295382142, 0.00634085386991501, 0.00633892416954041, 0.00633704243227839, 0.00633531669154763, 0.00633362028747797, 0.00633207010105252, 0.00633054925128818, 0.00632906751707196, 0.00632770219817758, 0.00632641604170203, 0.00632514851167798, 0.00632411520928144, 0.00632308190688491, 0.00632208725437522, 0.00632121041417122, 0.00632035173475742, 0.00631964951753616, 0.00631909491494298, 0.00631848024204373, 0.00631799269467592, 0.00631757359951735, 0.00631724204868078, 0.0063170175999403, 0.00631690071895719, 0.00631681317463517, 0.00631680339574814, 0.00631688162684441, 0.00631702737882733, 0.00631728116422892, 0.00631763227283955, 0.00631802156567574, 0.00631846021860838, 0.00631901621818542, 0.00631968909874558, 0.00632036151364446, 0.00632123928517103, 0.00632211659103632, 0.00632305210456252, 0.00632410496473312, 0.00632519740611315, 0.0063263769261539, 0.00632778089493513, 0.006329077295959, 0.00633052969351411, 0.00633204076439142, 0.00633362028747797, 0.00633530737832189, 0.00633704243227839, 0.00633896281942725, 0.00634090276435018, 0.00634286226704717, 0.00634495820850134, 0.00634706392884254, 0.00634929677471519, 0.00635173404589295, 0.00635408423841, 0.00635659880936146, 0.00635914318263531, 0.00636175647377968, 0.00636451551690698, 0.00636735185980797, 0.00637022824957967, 0.00637318240478635, 0.00637619476765394, 0.0063793626613915, 0.00638253148645163, 0.00638587540015578, 0.00638925796374679, 0.00639267032966018, 0.00639620935544372, 0.00639982614666224, 0.00640345318242908, 0.0064073228277266, 0.00641114497557282, 0.00641505466774106, 0.0064226882532239, 0.00643290532752872, 0.00644335569813848, 0.00645404122769833, 0.00646480405703187, 0.00647584022954106, 0.00648711016401649, 0.00649841828271747, 0.00651011755689979, 0.00652197236195207, 0.00653398316353559, 0.00654622819274664, 0.00655862875282764, 0.00657134177163243, 0.0065841325558722, 0.00659719621762633, 0.00661041587591171, 0.00662383064627647, 0.00663744052872062, 0.00665136193856597, 0.00666532292962074, 0.00667955679818988, 0.00669410219416022, 0.00670864759013057, 0.00672358321025968, 0.00673851883038878, 0.00675376644358039, 0.00676920870319009, 0.00678488565608859, 0.00680071813985705, 0.00681670615449548, 0.00683300662785769, 0.00684946309775114, 0.00686599779874086, 0.0068829613737762, 0.00690000271424651, 0.00691723870113492, 0.00693470891565084, 0.00695221871137619, 0.00697011733427644, 0.00698821200057864, 0.00700650131329894, 0.00702494662255049, 0.00704354792833328, 0.00706238299608231, 0.00708137359470129, 0.00710075534880161, 0.00712017528712749, 0.00713979080319405, 0.00715967873111367, 0.00717968354001641, 0.00719988392665982, 0.00722047360613942, 0.00724110286682844, 0.00726192677393556, 0.00728298490867019, 0.00730415992438793, 0.00732568558305502, 0.00734744593501091, 0.00736924493685365, 0.00739127723500133, 0.00741354469209909, 0.0074360454455018, 0.00745866354554892, 0.00748155359178782, 0.00750460056588054, 0.00752784265205264, 0.00755127985030413, 0.00757502764463425, 0.00759881595149636, 0.00762295490130782, 0.00764717115089297, 0.00767158251255751, 0.00769622856751084, 0.0077211856842041, 0.0077462219633162, 0.00777149153873324, 0.00779699487611651, 0.00782261602580547, 0.00784850865602493, 0.00787459779530764, 0.00790080334991217, 0.00792728178203106, 0.00795395486056805, 0.0079808235168457, 0.00800796411931515, 0.00803522393107414, 0.00806267652660608, 0.00809028651565313, 0.00811820663511753, 0.00814636237919331, 0.00817459542304277, 0.00820306316018105, 0.00823168735951185, 0.00826054438948631, 0.0082897124812007, 0.00831896066665649, 0.00834844075143337, 0.00837811734527349, 0.00840794946998358, 0.00843887031078339, 0.00847379118204117, 0.00850878097116947, 0.00854383874684572, 0.00857899431139231, 0.00861430447548628, 0.00864966586232185, 0.00868526939302683, 0.00872087199240923, 0.00875656399875879, 0.00879237335175276, 0.00882827863097191, 0.00886441860347986, 0.0089005483314395, 0.0089367963373661, 0.00897310115396976, 0.00900958199054003, 0.00904614198952913, 0.00908291526138783, 0.0091196782886982, 0.00915657915174961, 0.00919355731457472, 0.00923065282404423, 0.00926793273538351, 0.00930523313581944, 0.009342678822577, 0.00938019342720509, 0.00941783469170332, 0.00945564173161983, 0.0094934981316328, 0.0095314709469676, 0.00956953037530184, 0.00960766989737749, 0.00964594446122646, 0.0096844146028161, 0.00972292292863131, 0.0097615011036396, 0.00980021338909864, 0.00983899645507336, 0.0098780021071434, 0.00991704687476158, 0.00995616056025028, 0.00999538041651249, 0.0100347381085157, 0.0100742019712925, 0.0101138418540359, 0.0101534817367792, 0.010193258523941, 0.0102331312373281, 0.0102731510996819, 0.0103132892400026, 0.0103535046800971, 0.0103938169777393, 0.0104342065751553, 0.010474762879312, 0.0105153685435653, 0.0105562070384622, 0.0105970464646816, 0.0106379818171263, 0.0106790363788605, 0.0107202166691422, 0.0107614751905203, 0.0108029479160905, 0.0108444197103381, 0.0108860088512301, 0.0109276957809925, 0.0109695000573993, 0.0110114999115467, 0.0110535174608231, 0.0110956439748406, 0.0111378766596317, 0.0111802173778415, 0.0112226847559214, 0.0112652778625488, 0.0113079603761435, 0.0113507099449635, 0.0113936057314277, 0.0114365592598915, 0.011479739099741, 0.0115229170769453, 0.0115662133321166, 0.0116096446290612, 0.0116531550884247, 0.0116968704387546, 0.0117406146600842, 0.0117844175547361, 0.0118283946067095, 0.0118724023923278, 0.0119165759533644, 0.0119609432294965, 0.0120053021237254, 0.0120497578755021, 0.0120943505316973, 0.0121390596032143, 0.0121839446946979, 0.0122288288548589, 0.012273870408535, 0.0123189697042108, 0.0123642142862082, 0.0124095575883985, 0.012452638708055, 0.0124921035021544, 0.0125316549092531, 0.0125712174922228, 0.0126108080148697, 0.0126504190266132, 0.0126901166513562, 0.0127298450097442, 0.0127696106210351, 0.0128093780949712, 0.012849222868681, 0.0128891253843904, 0.0129290288314223, 0.0129689611494541, 0.0130089810118079, 0.0130490297451615, 0.0130891185253859, 0.0131292352452874, 0.0131693817675114, 0.0132096167653799, 0.0132498228922486, 0.0132901249453425, 0.0133304381743073, 0.0133707793429494, 0.0134111987426877, 0.0134516377002001, 0.0134921558201313, 0.0135326525196433, 0.0135731901973486, 0.0136138135567307, 0.0136544769629836, 0.0136951114982367, 0.0137358428910375, 0.0137766236439347, 0.0138174332678318, 0.0138582633808255, 0.0138991214334965, 0.0139400865882635, 0.0139810424298048, 0.0140220476314425, 0.0140630817040801, 0.0141041446477175, 0.0141452960669994, 0.0141864847391844, 0.0142276752740145, 0.0142688741907477, 0.0143101923167706, 0.0143515169620514, 0.0143928928300738, 0.0144342966377735, 0.0144757200032473, 0.0145172039046884, 0.0145587148144841, 0.014600315131247, 0.0146419033408165, 0.0146835427731276, 0.0147252194583416, 0.0147669548168778, 0.0148086920380592, 0.0148505242541432, 0.0148923574015498, 0.0149342697113752, 0.0149761820212007, 0.015018112026155, 0.0150601509958506, 0.0151021778583527, 0.0151443146169186, 0.0151863917708397, 0.0152285657823086, 0.0152707891538739, 0.0153130115941167, 0.0153553038835526, 0.0153976436704397, 0.015439985319972, 0.0154824117198586, 0.0155248595401645, 0.0155673278495669, 0.0156098529696465, 0.0156524367630482, 0.0156950391829014, 0.0157376918941736, 0.0157803744077682, 0.0158231239765882, 0.0158659014850855, 0.0159087013453245, 0.0159515384584665, 0.0159944053739309, 0.0160373412072659, 0.0160803236067295, 0.0161233264952898, 0.0161663889884949, 0.0162094607949257, 0.0162525903433561, 0.0162957794964314, 0.0163389779627323, 0.0163822248578072, 0.0164255294948816, 0.0164688248187304, 0.016512218862772, 0.0165556315332651, 0.0166040323674679, 0.0166538115590811, 0.0167035311460495, 0.0167532321065664, 0.0168029125779867, 0.0168525166809559, 0.0169021394103765, 0.0169517043977976, 0.0170012097805738, 0.0170507151633501, 0.0171001646667719, 0.0171495899558067, 0.0171990189701319, 0.0172483492642641, 0.017297700047493, 0.0173469707369804, 0.0173962414264679, 0.0174454934895039, 0.0174946878105402, 0.0175438448786736, 0.0175929795950651, 0.0176421143114567, 0.017691170796752, 0.0177402067929506, 0.0177892073988914, 0.017838167026639, 0.0178870894014835, 0.0179359707981348, 0.0179848726838827, 0.0180336758494377, 0.0180824603885412, 0.0181312430649996, 0.0181799493730068, 0.0182286761701107, 0.0182773247361183, 0.0183259528130293, 0.0183745622634888, 0.0184230916202068, 0.01847162283957, 0.0185201335698366, 0.0185685884207487, 0.0186170395463705, 0.0186654143035412, 0.0187137704342604, 0.0187621042132378, 0.0188104026019573, 0.0188586600124836, 0.0189068987965584, 0.018955061212182, 0.0190032199025154, 0.0190513618290424, 0.0190994814038277, 0.0191475264728069, 0.019195569679141, 0.019243536517024, 0.01929154060781, 0.0193394459784031, 0.0193873327225447, 0.0194351822137833, 0.0194830317050219, 0.0195308402180672, 0.0195785705000162, 0.0196263026446104, 0.0196739956736565, 0.0197216495871544, 0.019769262522459, 0.0198168586939573, 0.019864434376359, 0.0199119504541159, 0.0199594888836145, 0.0200069453567266, 0.0200543645769358, 0.0201017465442419, 0.0201491266489029, 0.0201964303851128, 0.0202437322586775, 0.0202909763902426, 0.0203381795436144, 0.0203854236751795, 0.0204325504601002, 0.0204796567559242, 0.0205267667770386, 0.0205737948417664, 0.0206208638846874, 0.0206678565591574, 0.0207148063927889, 0.0207617189735174, 0.0208086129277945, 0.0208554677665234, 0.0209023207426071, 0.0209490954875946, 0.0209958534687757, 0.0210425704717636, 0.0210892669856548, 0.0211359262466431, 0.0211825277656317, 0.0212291292846203, 0.0212756711989641, 0.0213221944868565, 0.0213686767965555, 0.0214127227663994, 0.0214552860707045, 0.0214977525174618, 0.0215400848537683, 0.0215822402387857, 0.0216241609305143, 0.0216660238802433, 0.0217076521366835, 0.0217491630464792, 0.021790498867631, 0.0218316987156868, 0.0218727421015501, 0.0219135526567698, 0.0219542253762484, 0.0219947602599859, 0.0220351796597242, 0.0220753476023674, 0.0221154354512691, 0.0221553090959787, 0.0221950840204954, 0.0222346670925617, 0.0222740359604359, 0.0223133210092783, 0.022352397441864, 0.0223913174122572, 0.022430095821619, 0.0224687419831753, 0.0225071534514427, 0.0225454270839691, 0.0225835461169481, 0.0226215291768312, 0.0226593185216188, 0.0226969681680202, 0.0227344818413258, 0.0227718409150839, 0.0228089448064566, 0.0228459723293781, 0.0228828247636557, 0.0229194797575474, 0.0229560025036335, 0.0229924228042364, 0.0230285711586475, 0.0230646263808012, 0.0231004822999239, 0.0231362413614988, 0.0231718048453331, 0.0232071951031685, 0.0232424084097147, 0.0232775453478098, 0.0233124271035194, 0.0233471933752298, 0.0233818013221025, 0.0234162360429764, 0.0234504919499159, 0.0234846156090498, 0.0235185623168945, 0.0235523898154497, 0.023586006835103, 0.0236194636672735, 0.0236528050154448, 0.0236859321594238, 0.0237189251929522, 0.0237517990171909, 0.023784477263689, 0.0238169617950916, 0.0238493662327528, 0.0238815564662218, 0.0239136125892401, 0.023945452645421, 0.0239771567285061, 0.0240087248384953, 0.0240400973707438, 0.0240713339298964, 0.0241023935377598, 0.0241333562880754, 0.0241640657186508, 0.0241946391761303, 0.0242250561714172, 0.0242553185671568, 0.0242854412645102, 0.0243153907358646, 0.0243451837450266, 0.0243748221546412, 0.0244042631238699, 0.0244335699826479, 0.0244627390056849, 0.0244916919618845, 0.02452053129673, 0.0245491731911898, 0.0245776809751987, 0.0246060322970152, 0.024634188041091, 0.0246622040867805, 0.024690106511116, 0.0247177928686142, 0.0247453264892101, 0.0247727409005165, 0.0247999224811792, 0.0248269643634558, 0.0248538702726364, 0.024876294657588, 0.0248949360102415, 0.0249135755002499, 0.0249321069568396, 0.0249506216496229, 0.0249690748751163, 0.0249874424189329, 0.0250058323144913, 0.0250240806490183, 0.0250423308461905, 0.0250605139881372, 0.0250786375254393, 0.0250967405736446, 0.0251147374510765, 0.025132704526186, 0.0251506138592958, 0.0251684729009867, 0.0251862853765488, 0.0252040382474661, 0.0252217743545771, 0.0252393782138824, 0.0252569746226072, 0.0252745561301708, 0.0252920333296061, 0.0253094471991062, 0.0253268089145422, 0.0253441520035267, 0.025361429899931, 0.0253786258399487, 0.0253958124667406, 0.0254129413515329, 0.0254299528896809, 0.0254469849169254, 0.0254639498889446, 0.025480855256319, 0.0254976712167263, 0.0255144592374563, 0.0255312267690897, 0.0255478974431753, 0.0255645103752613, 0.0255811046808958, 0.0255976486951113, 0.0256141144782305, 0.0256305038928986, 0.0256469007581472, 0.0256632100790739, 0.0256794430315495, 0.0256956461817026, 0.0257117804139853, 0.0257279239594936, 0.0257439520210028, 0.0257599391043186, 0.0257759001106024, 0.0257917512208223, 0.0258075855672359, 0.0258233584463596, 0.0258390735834837, 0.0258547328412533, 0.0258703585714102, 0.0258858986198902, 0.0259014293551445, 0.0259168818593025, 0.0259322840720415, 0.0259476397186518, 0.0259629357606173, 0.0259781647473574, 0.0259933639317751, 0.0260085221379995, 0.026023555546999, 0.0260385982692242, 0.0260535627603531, 0.0260684993118048, 0.0260833576321602, 0.0260981470346451, 0.0261129252612591, 0.0261276252567768, 0.0261422693729401, 0.0261568836867809, 0.0261714588850737, 0.0261859074234962, 0.0262003652751446, 0.0262147244066, 0.0262290462851524, 0.026243356987834, 0.0262575633823872, 0.0262717492878437, 0.0262858662754297, 0.0262999329715967, 0.0263139419257641, 0.02632793225348, 0.026341812685132, 0.0263556558638811, 0.0263694822788239, 0.0263831596821547, 0.0263968855142593, 0.0264105442911386, 0.0264241062104702, 0.0264376569539309, 0.0264511108398438, 0.0264645256102085, 0.0264804027974606, 0.0265018492937088, 0.0265233516693115, 0.0265448875725269, 0.0265664905309677, 0.026588162407279, 0.0266098845750093, 0.0266316495835781, 0.0266534667462111, 0.0266753397881985, 0.0266972705721855, 0.0267192348837852, 0.0267412718385458, 0.0267633516341448, 0.0267854984849691, 0.0268076937645674, 0.0268299449235201, 0.0268522314727306, 0.0268745999783278, 0.0268969852477312, 0.0269194710999727, 0.0269419774413109, 0.0269645433872938, 0.0269871633499861, 0.0270098391920328, 0.0270325746387243, 0.0270553342998028, 0.0270781703293324, 0.0271010529249907, 0.0271240007132292, 0.0271470099687576, 0.0271700657904148, 0.0271931700408459, 0.027216324582696, 0.0272395182400942, 0.0272627901285887, 0.0272860992699862, 0.0273094773292542, 0.0273328963667154, 0.0273563712835312, 0.027379896491766, 0.0274034831672907, 0.0274271089583635, 0.0274508018046618, 0.0274745505303144, 0.0274983607232571, 0.0275221914052963, 0.0275461208075285, 0.0275700688362122, 0.027594082057476, 0.0276181437075138, 0.0276422519236803, 0.0276664290577173, 0.0276906471699476, 0.027714941650629, 0.0277392659336329, 0.0277636684477329, 0.0277880914509296, 0.0278125889599323, 0.0278371162712574, 0.0278617385774851, 0.0278863906860352, 0.02791110239923, 0.0279358550906181, 0.0279606617987156, 0.0279855355620384, 0.0280104465782642, 0.0280354283750057, 0.0280604436993599, 0.0280855223536491, 0.0281106624752283, 0.0281358491629362, 0.0281611066311598, 0.0281863957643509, 0.0282117426395416, 0.0282371509820223, 0.0282625947147608, 0.0282881036400795, 0.0283136684447527, 0.0283392872661352, 0.0283649526536465, 0.0283906683325768, 0.028416445478797, 0.0284422673285007, 0.0284681487828493, 0.0284941159188747, 0.0285200793296099, 0.0285461470484734, 0.0285722408443689, 0.0285983830690384, 0.0286245886236429, 0.0286508426070213, 0.0286771561950445, 0.0287035088986158, 0.0287299379706383, 0.0287564042955637, 0.0287829283624887, 0.0288095008581877, 0.0288361478596926, 0.0288628172129393, 0.0288894660770893, 0.0289155449718237, 0.0289416406303644, 0.0289677586406469, 0.0289938803762197, 0.029020007699728, 0.0290461592376232, 0.0290723200887442, 0.0290985032916069, 0.0291246939450502, 0.0291508994996548, 0.0291771199554205, 0.0292033515870571, 0.0292295813560486, 0.0292558465152979, 0.0292821116745472, 0.0293083973228931, 0.0293346997350454, 0.0293610114604235, 0.0293873399496078, 0.0294136740267277, 0.0294400155544281, 0.0294663794338703, 0.0294927600771189, 0.0295191500335932, 0.029545558616519, 0.0295719746500254, 0.0295984093099833, 0.0296248495578766, 0.029651302844286, 0.029677776619792, 0.0297042559832335, 0.0297307539731264, 0.029757272452116, 0.0297837983816862, 0.0298103354871273, 0.029836893081665, 0.0298634450882673, 0.029890026897192, 0.0299166161566973, 0.0299432203173637, 0.029969846829772, 0.0299964770674706, 0.0300231240689754, 0.0300497841089964, 0.0300764422863722, 0.0301031284034252, 0.0301298275589943, 0.0301565453410149, 0.030183270573616, 0.0302100013941526, 0.0302367582917213, 0.0302635282278061, 0.030290300026536, 0.0303170904517174, 0.0303438939154148, 0.0303707178682089, 0.0303975529968739, 0.0304243937134743, 0.0304512567818165, 0.0304781347513199, 0.0305050052702427, 0.0305319055914879, 0.0305588189512491, 0.0305857472121716, 0.0306126866489649, 0.0306396391242743, 0.03066660836339, 0.0306935887783766, 0.030720567330718, 0.030747577548027, 0.0307745933532715, 0.030801635235548, 0.0308286808431149, 0.0308557357639074, 0.0308828130364418, 0.0309098996222019, 0.0309369917958975, 0.0309641100466251, 0.0309912338852882, 0.0310183744877577, 0.0310455299913883, 0.0310726929455996, 0.0310998801141977, 0.0311270747333765, 0.031154265627265, 0.031181488186121, 0.0312087181955576, 0.0312359724193811, 0.0312632322311401, 0.0312905050814152, 0.0313177928328514, 0.0313450954854488, 0.031372394412756, 0.0313997268676758, 0.0314270704984665, 0.0314544215798378, 0.0314817912876606, 0.0315091721713543, 0.0315365716814995, 0.0315604470670223, 0.031579002737999, 0.0315976776182652, 0.0316166207194328, 0.0316356047987938, 0.0316548235714436, 0.0316742733120918, 0.0316937677562237, 0.031713530421257, 0.0317334122955799, 0.0317534133791924, 0.0317736454308033, 0.0317940711975098, 0.0318145789206028, 0.0318352766335011, 0.0318562500178814, 0.0318772606551647, 0.0318985097110271, 0.0319198742508888, 0.0319414287805557, 0.0319631807506084, 0.0319850519299507, 0.0320071168243885, 0.0320293828845024, 0.0320517159998417, 0.0320742838084698, 0.0320970565080643, 0.0321198999881744, 0.0321429371833801, 0.0321662537753582, 0.0321896076202393, 0.0322131924331188, 0.0322369337081909, 0.0322607904672623, 0.0322848856449127, 0.0323091335594654, 0.0323334969580173, 0.0323581025004387, 0.0323827750980854, 0.0324076898396015, 0.0324327945709229, 0.0324579812586308, 0.0324834026396275, 0.0325090140104294, 0.0325347036123276, 0.0325606316328049, 0.0325867123901844, 0.0326129123568535, 0.0326393470168114, 0.0326658934354782, 0.0326926000416279, 0.0327195376157761, 0.0327466353774071, 0.0327738076448441, 0.0328012555837631, 0.0328288227319717, 0.0328566171228886, 0.032884493470192, 0.0329125262796879, 0.0329407900571823, 0.0329692102968693, 0.0329977497458458, 0.0330264829099178, 0.0330554470419884, 0.0330844968557358, 0.0331137739121914, 0.0331431701779366, 0.0331727266311646, 0.0332025103271008, 0.0332323759794235, 0.0332624725997448, 0.0332927703857422, 0.0333231389522552, 0.0333537049591541, 0.0333845056593418, 0.0334153845906258, 0.0334464535117149, 0.0334777645766735, 0.0335091091692448, 0.0335407294332981, 0.033572506159544, 0.0336043946444988, 0.0336365215480328, 0.0336687676608562, 0.0337011255323887, 0.0337337590754032, 0.033766508102417, 0.0337994173169136, 0.0338325202465057, 0.0338657349348068, 0.033899188041687, 0.0339327938854694, 0.0339665189385414, 0.0340004824101925, 0.0340345539152622, 0.0340687856078148, 0.0341032557189465, 0.0341378338634968, 0.0341725759208202, 0.0342074669897556, 0.0342441089451313, 0.0342801436781883, 0.0343169942498207, 0.0343542397022247, 0.0343919843435287, 0.0344301238656044, 0.0344687700271606, 0.03450807929039, 0.0345476977527142, 0.0345877073705196, 0.0346285365521908, 0.034669604152441, 0.034711129963398, 0.0347533226013184, 0.0347959510982037, 0.0348389632999897, 0.0348826386034489, 0.0349266231060028, 0.0349711179733276, 0.0350162014365196, 0.0350617878139019, 0.0351076498627663, 0.0351542085409164, 0.0352012030780315, 0.0352487750351429, 0.0352966226637363, 0.0353451333940029, 0.0353940352797508, 0.0354434438049793, 0.0354933589696884, 0.0355437435209751, 0.0355946347117424, 0.0356459133327007, 0.0356978997588158, 0.0357503406703472, 0.0358029901981354, 0.0358563736081123, 0.0359103083610535, 0.0359645560383797, 0.0360193401575089, 0.036074560135603, 0.0361304432153702, 0.0361866727471352, 0.0362433753907681, 0.0363007001578808, 0.0363583005964756, 0.03641651943326, 0.0364752076566219, 0.0365344472229481, 0.0365940295159817, 0.036654282361269, 0.0367149189114571, 0.0367759503424168, 0.0368376411497593, 0.0368997603654861, 0.0369623526930809, 0.037025447934866, 0.037088930606842, 0.0371531210839748, 0.0372176617383957, 0.0372828207910061, 0.0373482182621956, 0.0374142006039619, 0.0374808497726917, 0.0375477261841297, 0.0376151874661446, 0.037683118134737, 0.0377516746520996, 0.037820503115654, 0.0378899574279785, 0.0379599928855896, 0.0380302667617798, 0.0381011590361595, 0.0381726808845997, 0.0382444299757481, 0.0383169315755367, 0.038389690220356, 0.03846300765872, 0.0385368317365646, 0.0386111959815025, 0.0386859104037285, 0.0387612134218216, 0.0388371348381042, 0.0389132611453533, 0.0389900021255016, 0.0390673354268074, 0.0391450151801109, 0.0392232798039913, 0.039301972836256, 0.0393810942769051, 0.0394607670605183, 0.0395409800112247, 0.0396215915679932, 0.0397027395665646, 0.0397843979299068, 0.0398664847016335, 0.0399491190910339, 0.040032297372818, 0.0401157923042774, 0.0401999838650227, 0.0402883887290955, 0.040382131934166, 0.0404767394065857, 0.0405718125402927, 0.0406675860285759, 0.0407638289034367, 0.0408607721328735, 0.0409584231674671, 0.0410566963255405, 0.0411555841565132, 0.0412551052868366, 0.0413551703095436, 0.0414559356868267, 0.0415571704506874, 0.0416591018438339, 0.0417616628110409, 0.0418647713959217, 0.0419687367975712, 0.0420730113983154, 0.0421780683100224, 0.0422837473452091, 0.0423902869224548, 0.0424971356987953, 0.0426047630608082, 0.0427128635346889, 0.0428216606378555, 0.0429310090839863, 0.0430410541594028, 0.0431517250835896, 0.0432627908885479, 0.0433748662471771, 0.0434874035418034, 0.0436004176735878, 0.0437143668532372, 0.0438287034630775, 0.0439436621963978, 0.0440593287348747, 0.0441756136715412, 0.0442925281822681, 0.0444099046289921, 0.0445280633866787, 0.0446468442678452, 0.0447660200297832, 0.0448861233890057, 0.04500662535429, 0.0451279804110527, 0.0452497266232967, 0.0453721731901169, 0.0454954840242863, 0.0456190966069698, 0.0457433387637138, 0.0458684414625168, 0.0459938570857048, 0.0461201258003712, 0.0462468639016151, 0.0463743805885315, 0.0465023666620255, 0.0466310530900955, 0.046760443598032, 0.0468903034925461, 0.0470210164785385, 0.0471521206200123, 0.0472838543355465, 0.0474163591861725, 0.0475493408739567, 0.0476828590035439, 0.0478173196315765, 0.0479522496461868, 0.0480876453220844, 0.0482237413525581, 0.0483607724308968, 0.0484980419278145, 0.0486360862851143, 0.048774603754282, 0.0489139780402184, 0.0490538105368614, 0.0491943582892418, 0.0493352897465229, 0.0494769252836704, 0.0496194921433926, 0.0497625358402729, 0.0499060414731503, 0.0500503256917, 0.0501950792968273, 0.0503407679498196, 0.0504867695271969, 0.0506334006786346, 0.0507808066904545, 0.0509286783635616, 0.0510773286223412, 0.0512262992560863, 0.0513763539493084, 0.0515265688300133, 0.0516777969896793, 0.051829494535923, 0.0519818142056465, 0.0521347559988499, 0.0522884018719196, 0.0524423569440842, 0.0525974072515965, 0.0527634546160698, 0.0529398955404758, 0.0531165078282356, 0.0532932989299297, 0.0534701831638813, 0.0536472052335739, 0.0538245439529419, 0.0540020130574703, 0.0541795268654823, 0.0543571524322033, 0.0545351319015026, 0.0547131337225437, 0.0548914596438408, 0.0550697110593319, 0.0552482791244984, 0.0554270148277283, 0.0556060299277306, 0.0557850040495396, 0.0559641122817993, 0.0561435706913471, 0.0563231930136681, 0.0565028488636017, 0.0566826164722443, 0.0568627044558525, 0.057042945176363, 0.057223379611969, 0.0574038326740265, 0.0575845241546631, 0.0577653720974922, 0.0579465068876743, 0.0581276677548885, 0.0583090521395206, 0.0584904886782169, 0.0586722902953625, 0.0588540658354759, 0.0590360872447491, 0.0592183135449886, 0.0594005435705185, 0.0595831386744976, 0.0597659200429916, 0.0599486343562603, 0.0601316429674625, 0.0603149048984051, 0.060498271137476, 0.060681726783514, 0.0608653202652931, 0.0610493086278439, 0.0612331330776215, 0.0614174529910088, 0.0616017282009125, 0.061786126345396, 0.061970766633749, 0.0621556676924229, 0.0623406507074833, 0.0625258013606071, 0.0627111122012138, 0.0628966987133026, 0.0630822405219078, 0.0632680207490921, 0.0634540542960167, 0.0636401623487473, 0.0638265386223793, 0.0640129074454308, 0.0641996189951897, 0.0643863752484322, 0.0645733624696732, 0.0647605657577515, 0.064947821199894, 0.0651352405548096, 0.0653228908777237, 0.0655106753110886, 0.065698653459549, 0.0658867359161377, 0.0660750269889832, 0.06626345962286, 0.0664520710706711, 0.0666408464312553, 0.0668298825621605, 0.0670188963413239, 0.0672081857919693, 0.0673977062106133, 0.067587286233902, 0.0677770674228668, 0.067966990172863, 0.0681570246815681, 0.068347342312336, 0.0685377418994904, 0.0687283799052238, 0.0689191073179245, 0.0691100507974625, 0.0693010911345482, 0.0694922730326653, 0.0696837976574898, 0.0698753595352173, 0.0700670406222343, 0.0702590048313141, 0.0704511776566505, 0.0706432312726974, 0.0708357393741608, 0.0710283443331718, 0.0712161213159561, 0.0713993683457375, 0.0715821981430054, 0.0717644244432449, 0.0719461143016815, 0.0721272975206375, 0.0723079219460487, 0.07248804718256, 0.0726676508784294, 0.0728466957807541, 0.0730252340435982, 0.0732031837105751, 0.073380671441555, 0.0735575631260872, 0.0737339779734612, 0.0739098116755486, 0.0740852952003479, 0.0742600560188293, 0.0744342356920242, 0.0746080353856087, 0.0747812390327454, 0.0749539136886597, 0.0751260668039322, 0.0752977654337883, 0.0754687860608101, 0.0756393745541573, 0.0758094266057014, 0.0759789198637009, 0.0761479437351227, 0.0763164088129997, 0.0764842480421066, 0.0766516029834747, 0.0768185034394264, 0.0769848003983498, 0.0771506205201149, 0.07731594145298, 0.0774806588888168, 0.0776448324322701, 0.0778084993362427, 0.0779716223478317, 0.0781342461705208, 0.0782963335514069, 0.0784578695893288, 0.0786189064383507, 0.0787793323397636, 0.0789393782615662, 0.0790988355875015, 0.0792576670646667, 0.0794160887598991, 0.079573966562748, 0.0797311440110207, 0.0798879638314247, 0.0800442025065422, 0.0801999717950821, 0.0803551226854324, 0.0805098339915276, 0.0806639716029167, 0.0808175578713417, 0.0809706225991249, 0.0811231508851051, 0.0812751650810242, 0.0814266577363014, 0.0815775319933891, 0.0817278847098351, 0.0818778052926064, 0.0820271894335747, 0.0821760222315788, 0.082324355840683, 0.0824721604585648, 0.0826193019747734, 0.0827659666538239, 0.0829121842980385, 0.0830578058958054, 0.0832029581069946, 0.0833475142717361, 0.0834916532039642, 0.0836350545287132, 0.0837781131267548, 0.0839205682277679, 0.0840624943375587, 0.0842038914561272, 0.0843447893857956, 0.0844850391149521, 0.0846248418092728, 0.084764152765274, 0.0849029049277306, 0.0850412026047707, 0.0851788446307182, 0.0853160545229912, 0.0854525938630104, 0.0855887159705162, 0.085724264383316, 0.0858593434095383, 0.0859938263893127, 0.086127795279026, 0.0862611830234528, 0.0863941237330437, 0.0865264907479286, 0.0866584181785583, 0.0867897644639015, 0.0869023203849792, 0.0869991779327393, 0.0870956107974052, 0.0871917456388474, 0.0872874930500984, 0.0873828828334808, 0.087477907538414, 0.0875725820660591, 0.0876666978001595, 0.0877606347203255, 0.0878541246056557, 0.0879472345113754, 0.0880400091409683, 0.0881323963403702, 0.0882243141531944, 0.0883158966898918, 0.0884071514010429, 0.0884980410337448, 0.0885885804891586, 0.0886786803603172, 0.0887684226036072, 0.0888576954603195, 0.088946670293808, 0.0890352874994278, 0.0891235247254372, 0.0892113894224167, 0.0892988368868828, 0.0893859267234802, 0.0894725993275642, 0.089559018611908, 0.0896449536085129, 0.0897305384278297, 0.0898158028721809, 0.0899006128311157, 0.0899850130081177, 0.0900690704584122, 0.090152807533741, 0.090236134827137, 0.0903191566467285, 0.0904017016291618, 0.0904838740825653, 0.0905657112598419, 0.0906471237540245, 0.0907281711697578, 0.0908089429140091, 0.0908892378211021, 0.0909691676497459, 0.0910486578941345, 0.0911278501152992, 0.0912066772580147, 0.0912851467728615, 0.0913632214069366, 0.0914409384131432, 0.0915181338787079, 0.0915950611233711, 0.0916716009378433, 0.0917478278279305, 0.0918236300349236, 0.0918990448117256, 0.0919740572571754, 0.0920486822724342, 0.0921230316162109, 0.0921969711780548, 0.0922704935073853, 0.0923436656594276, 0.0924164429306984, 0.0924887806177139, 0.0925608277320862, 0.092632494866848, 0.0927037820219994, 0.0927747488021851, 0.0928452610969543, 0.0929153710603714, 0.092985138297081, 0.0930545479059219, 0.0931235253810883, 0.0931922197341919, 0.0932604670524597, 0.0933283716440201, 0.093395859003067, 0.0934629589319229, 0.0935297906398773, 0.0935961678624153, 0.0936621725559235, 0.0937278121709824, 0.093793012201786, 0.0938578546047211, 0.0939223766326904, 0.0939865261316299, 0.094050258398056, 0.0941137075424194, 0.094176709651947, 0.0942392498254776, 0.0943014994263649, 0.0943633690476418, 0.094424843788147, 0.0944859683513641, 0.0945466831326485, 0.0946070030331612, 0.0946669802069664, 0.0947397276759148, 0.0948179364204407, 0.0948962494730949, 0.094974622130394, 0.0950530990958214, 0.095131628215313, 0.0952102467417717, 0.0952889323234558, 0.0953677073121071, 0.0954465344548225, 0.0955254584550858, 0.0956044420599937, 0.0956835448741913, 0.0957626849412918, 0.0958419069647789, 0.0959212258458138, 0.0960005894303322, 0.096080057322979, 0.0961595922708511, 0.0962392017245293, 0.0963189080357552, 0.0963986665010452, 0.0964785069227219, 0.0965584143996239, 0.096638411283493, 0.0967184901237488, 0.0967986285686493, 0.0968788638710976, 0.0969591662287712, 0.0970395654439926, 0.0971199870109558, 0.097200520336628, 0.0972811505198479, 0.0973618403077126, 0.0974425971508026, 0.0975234434008598, 0.0976043716073036, 0.0976853519678116, 0.0977664291858673, 0.0978475660085678, 0.0979288071393967, 0.0980101004242897, 0.0980915054678917, 0.0981729477643967, 0.0982544645667076, 0.0983360856771469, 0.0984177812933922, 0.0984995290637016, 0.0985814034938812, 0.0986633077263832, 0.0987453013658524, 0.0988273695111275, 0.0989094972610474, 0.0989917442202568, 0.0990740358829498, 0.09915641695261, 0.099238894879818, 0.0993214324116707, 0.0994040295481682, 0.0994867011904716, 0.0995694771409035, 0.0996523126959801, 0.099735215306282, 0.0998182371258736, 0.0999013036489487, 0.0999844446778297, 0.100067667663097, 0.100150965154171, 0.100234344601631, 0.100317813456059, 0.100401327013969, 0.100484944880009, 0.100568629801273, 0.100652381777763, 0.100736238062382, 0.100820153951645, 0.100904166698456, 0.10098821669817, 0.101072371006012, 0.101156577467918, 0.101240888237953, 0.101325251162052, 0.101409718394279, 0.101494252681732, 0.101578876376152, 0.101663552224636, 0.101748317480087, 0.101833142340183, 0.101918056607246, 0.102003052830696, 0.102088123559952, 0.102173283696175, 0.102258503437042, 0.102343820035458, 0.102429188787937, 0.102514624595642, 0.102600157260895, 0.102685779333115, 0.102771446108818, 0.10285721719265, 0.102951221168041, 0.103054508566856, 0.103157617151737, 0.103260517120361, 0.103363260626793, 0.103465802967548, 0.103568121790886, 0.10367027670145, 0.103772215545177, 0.103873953223228, 0.103975497186184, 0.104076884686947, 0.104178041219711, 0.104279041290283, 0.104379832744598, 0.104480437934399, 0.104580819606781, 0.104680992662907, 0.104781024158001, 0.104880794882774, 0.104980453848839, 0.105079911649227, 0.105179101228714, 0.105278149247169, 0.105376988649368, 0.10547561198473, 0.105574086308479, 0.105672366917133, 0.105770416557789, 0.105868317186832, 0.1059660166502, 0.106063514947891, 0.106160715222359, 0.106257878243923, 0.106354773044586, 0.106451466679573, 0.106547996401787, 0.106644369661808, 0.106740459799767, 0.106836378574371, 0.106932118535042, 0.107027657330036, 0.107123039662838, 0.107218213379383, 0.107313193380833, 0.107407964766026, 0.10750250518322, 0.107596911489964, 0.107691079378128, 0.107785105705261, 0.107878938317299, 0.107972517609596, 0.10806593298912, 0.108159177005291, 0.108252167701721, 0.108345009386539, 0.108437657356262, 0.108530104160309, 0.108622379601002, 0.108714446425438, 0.108806319534779, 0.10889795422554, 0.108989425003529, 0.109080731868744, 0.109171792864799, 0.109262749552727, 0.109353438019753, 0.109443925321102, 0.109534241259098, 0.10962437838316, 0.109714262187481, 0.109804004430771, 0.109893575310707, 0.109982922673225, 0.110072053968906, 0.110161021351814, 0.110249809920788, 0.11033833026886, 0.110426731407642, 0.110514938831329, 0.110602900385857, 0.110690720379353, 0.110778301954269, 0.110865704715252, 0.110952891409397, 0.111039943993092, 0.111126765608788, 0.111213400959969, 0.111299835145473, 0.111386068165302, 0.111472122371197, 0.111558012664318, 0.111643649637699, 0.111729122698307, 0.111814394593239, 0.111899502575397, 0.111984349787235, 0.112069077789783, 0.112153574824333, 0.112237848341465, 0.112298376858234, 0.112341485917568, 0.112384490668774, 0.112427614629269, 0.112470664083958, 0.112513735890388, 0.112556837499142, 0.112599916756153, 0.112643010914326, 0.112686090171337, 0.112729176878929, 0.112772323191166, 0.112815342843533, 0.112858526408672, 0.112901590764523, 0.112944647669792, 0.112987838685513, 0.113030940294266, 0.1130740493536, 0.113117188215256, 0.113160312175751, 0.113203443586826, 0.113246537744999, 0.113289676606655, 0.113332875072956, 0.113375961780548, 0.113419152796268, 0.113462276756763, 0.113505430519581, 0.11354860663414, 0.113591745495796, 0.113634891808033, 0.113678082823753, 0.113721251487732, 0.113764464855194, 0.11380759626627, 0.113850794732571, 0.113893993198872, 0.113937117159367, 0.113980367779732, 0.114023514091969, 0.114066734910011, 0.114109955728054, 0.114153161644936, 0.114196345210075, 0.114239580929279, 0.114282764494419, 0.114326022565365, 0.114369191229343, 0.11441246420145, 0.114455707371235, 0.114498898386955, 0.114542126655579, 0.114585377275944, 0.114628583192825, 0.114671848714352, 0.114715121686459, 0.114758342504501, 0.114801585674286, 0.114844836294651, 0.114888124167919, 0.114931367337704, 0.114974647760391, 0.115017920732498, 0.115061193704605, 0.115104489028454, 0.115147776901722, 0.115191005170345, 0.115234315395355, 0.115277610719204, 0.115320920944214, 0.11536418646574, 0.115407511591911, 0.115450814366341, 0.115494087338448, 0.11553743481636, 0.115580715239048, 0.115624062716961, 0.115667402744293, 0.115710735321045, 0.115754030644894, 0.115797378122807, 0.115840688347816, 0.115884035825729, 0.11592735350132, 0.115970738232136, 0.116014085710049, 0.116057425737381, 0.116100788116455, 0.116144090890884, 0.116187483072281, 0.116230875253677, 0.116274245083332, 0.116317614912987, 0.116360954940319, 0.116404354572296, 0.116447739303112, 0.116491086781025, 0.116534516215324, 0.116577848792076, 0.116616412997246, 0.116647727787495, 0.116680480539799, 0.116714507341385, 0.116749964654446, 0.116786442697048, 0.116824463009834, 0.116863541305065, 0.116904176771641, 0.116945967078209, 0.116988949477673, 0.117033377289772, 0.117078796029091, 0.117125786840916, 0.117173872888088, 0.117223434150219, 0.1172741279006, 0.117326267063618, 0.117379538714886, 0.117434225976467, 0.11749005317688, 0.11754734814167, 0.117605835199356, 0.117665469646454, 0.117726638913155, 0.117788843810558, 0.117852546274662, 0.117917351424694, 0.117983683943748, 0.118051074445248, 0.118119895458221, 0.118190035223961, 0.118261203169823, 0.118333876132965, 0.118407689034939, 0.118482954800129, 0.118559390306473, 0.118637226521969, 0.118716150522232, 0.118796624243259, 0.118878163397312, 0.118961162865162, 0.119045302271843, 0.119130715727806, 0.119217544794083, 0.119305543601513, 0.119394958019257, 0.11948549002409, 0.119577437639236, 0.11967059224844, 0.119765132665634, 0.119860798120499, 0.119957834482193, 0.120056204497814, 0.120155796408653, 0.120256833732128, 0.120358906686306, 0.120462484657764, 0.120567113161087, 0.120673321187496, 0.120780512690544, 0.120889224112034, 0.120998956263065, 0.121110200881958, 0.121222637593746, 0.121336452662945, 0.121451541781425, 0.121567837893963, 0.121685549616814, 0.121804371476173, 0.121924661099911, 0.122046053409576, 0.122168824076653, 0.122292771935463, 0.122418127954006, 0.122544713318348, 0.122672691941261, 0.122801944613457, 0.122932352125645, 0.123064205050468, 0.123197160661221, 0.12333157658577, 0.123467028141022, 0.123603984713554, 0.123742133378983, 0.123881638050079, 0.124022357165813, 0.124164439737797, 0.124307796359062, 0.124452404677868, 0.124598369002342, 0.12474550306797, 0.124893926084042, 0.125043600797653, 0.125194758176804, 0.125347062945366, 0.125500708818436, 0.125655502080917, 0.125811830163002, 0.125969186425209, 0.126163586974144, 0.126400798559189, 0.126639112830162, 0.126879051327705, 0.12712000310421, 0.127362489700317, 0.127605974674225, 0.127851024270058, 0.128097176551819, 0.128344804048538, 0.128593683242798, 0.128843724727631, 0.12909509241581, 0.129347667098045, 0.129601657390594, 0.129856839776039, 0.13011346757412, 0.13037121295929, 0.130630418658257, 0.130890712141991, 0.131152495741844, 0.131415575742722, 0.131679609417915, 0.131945326924324, 0.132212072610855, 0.13248036801815, 0.132749676704407, 0.133020460605621, 0.133292332291603, 0.133565738797188, 0.133840277791023, 0.134116217494011, 0.134393200278282, 0.134671717882156, 0.134951561689377, 0.135232508182526, 0.13551490008831, 0.13579834997654, 0.136083379387856, 0.136369451880455, 0.136657059192657, 0.13694566488266, 0.137235730886459, 0.137526944279671, 0.137819722294807, 0.138113602995872, 0.138408809900284, 0.138705372810364, 0.139003083109856, 0.139302283525467, 0.139602571725845, 0.139904320240021, 0.140207082033157, 0.140511333942413, 0.140816777944565, 0.141123726963997, 0.141431763768196, 0.141741201281548, 0.142051920294762, 0.142363801598549, 0.142677187919617, 0.142991572618484, 0.143307402729988, 0.143624514341354, 0.143942967057228, 0.144262626767159, 0.144583627581596, 0.144905805587769, 0.145229533314705, 0.145554259419441, 0.145880490541458, 0.146207988262177, 0.146536573767662, 0.146866634488106, 0.147197872400284, 0.147530540823936, 0.147864356637001, 0.148199558258057, 0.148535996675491, 0.148873776197433, 0.149212718009949, 0.1495531052351, 0.149894699454308, 0.150237575173378, 0.150581851601601, 0.150927156209946, 0.1512740701437, 0.151622042059898, 0.151971444487572, 0.152322053909302, 0.152674049139023, 0.153027296066284, 0.153381660580635, 0.153737545013428, 0.154094502329826, 0.154453054070473, 0.154812514781952, 0.155173555016518, 0.155535697937012, 0.155899330973625, 0.156275510787964, 0.156663000583649, 0.157049894332886, 0.157436028122902, 0.157821357250214, 0.158206060528755, 0.15858992934227, 0.158973187208176, 0.159355670213699, 0.159737512469292, 0.160118594765663, 0.16049887239933, 0.160878509283066, 0.161257445812225, 0.16163569688797, 0.162013113498688, 0.162389799952507, 0.162765815854073, 0.163141265511513, 0.163515701889992, 0.163889646530151, 0.164262756705284, 0.164635181427002, 0.165006920695305, 0.165377929806709, 0.165748164057732, 0.166117712855339, 0.16648656129837, 0.16685463488102, 0.167222067713737, 0.167588725686073, 0.167954653501511, 0.168319895863533, 0.168684408068657, 0.169048264622688, 0.169411242008209, 0.169773608446121, 0.170135259628296, 0.170496210455894, 0.170856416225433, 0.171215906739235, 0.171574652194977, 0.17193266749382, 0.172289907932281, 0.172646626830101, 0.173002421855927, 0.173357591032982, 0.173712000250816, 0.174065783619881, 0.174418717622757, 0.174771025776863, 0.175122618675232, 0.175473392009735, 0.175823479890823, 0.17617292702198, 0.176521599292755, 0.17686952650547, 0.177216827869415, 0.177563354372978, 0.177909165620804, 0.178254202008247, 0.178598508238792, 0.178942263126373, 0.179285138845444, 0.179627299308777, 0.179968804121017, 0.180309623479843, 0.180649593472481, 0.180988952517509, 0.181327551603317, 0.181665435433388, 0.182002574205399, 0.182339027523994, 0.182674735784531, 0.183009773492813, 0.183344006538391, 0.183677613735199, 0.184010416269302, 0.184342607855797, 0.184674054384232, 0.185004621744156, 0.185334578156471, 0.185663849115372, 0.185992434620857, 0.186320200562477, 0.186647340655327, 0.186973676085472, 0.187299311161041, 0.187624245882034, 0.187948450446129, 0.188271969556808, 0.188594743609428, 0.188916698098183, 0.189238056540489, 0.189558729529381, 0.189878538250923, 0.190197750926018, 0.190516203641891, 0.190833956003189, 0.191150933504105, 0.191433280706406, 0.191669419407845, 0.191903948783875, 0.192136943340302, 0.192368194460869, 0.192597761750221, 0.192825883626938, 0.193052336573601, 0.193276986479759, 0.193500235676765, 0.19372171163559, 0.193941652774811, 0.194159880280495, 0.194376543164253, 0.194591596722603, 0.194804921746254, 0.195016667246819, 0.195226863026619, 0.195435360074043, 0.195642203092575, 0.195847436785698, 0.196051001548767, 0.196253076195717, 0.196453422307968, 0.19665215909481, 0.196849212050438, 0.19704481959343, 0.197238519787788, 0.197430804371834, 0.197621464729309, 0.197810336947441, 0.197997748851776, 0.198183432221413, 0.198367550969124, 0.198549970984459, 0.198730826377869, 0.198910012841225, 0.199087575078011, 0.199263468384743, 0.199437856674194, 0.199610456824303, 0.199781626462936, 0.199951022863388, 0.200118809938431, 0.200285017490387, 0.200449585914612, 0.200612515211105, 0.200773760676384, 0.200933501124382, 0.201091468334198, 0.201247960329056, 0.201402753591537, 0.201555877923965, 0.201707407832146, 0.201857358217239, 0.202005535364151, 0.202152252197266, 0.202297315001488, 0.202440664172173, 0.202582463622093, 0.202722609043121, 0.202861130237579, 0.2029979377985, 0.203133285045624, 0.203266799449921, 0.203398838639259, 0.203529208898544, 0.203657999634743, 0.203785061836243, 0.203910544514656, 0.204034402966499, 0.204156637191772, 0.204277351498604, 0.204396307468414, 0.204513639211655, 0.204629331827164, 0.204743444919586, 0.204855859279633, 0.204966738820076, 0.205075889825821, 0.205183550715446, 0.205289408564568, 0.205393821001053, 0.205496549606323, 0.205597564578056, 0.20569708943367, 0.205794870853424, 0.20589105784893, 0.205985575914383, 0.206078603863716, 0.206169858574867, 0.206259533762932, 0.206347584724426, 0.206433981657028, 0.206518813967705, 0.206601977348328, 0.206683471798897, 0.206763401627541, 0.206841737031937, 0.206918373703957, 0.206986948847771, 0.207048088312149, 0.207108482718468, 0.207168206572533, 0.20722721517086, 0.207285538315773, 0.207343176007271, 0.207400098443031, 0.207456275820732, 0.207511827349663, 0.207566633820534, 0.207620739936829, 0.207674145698547, 0.20772685110569, 0.207778856158257, 0.207830131053925, 0.207880780100822, 0.207930654287338, 0.2079798579216, 0.208028346300125, 0.208076104521751, 0.208123221993446, 0.208169609308243, 0.208215326070786, 0.208260282874107, 0.208304598927498, 0.208348140120506, 0.2083909958601, 0.208433240652084, 0.208474665880203, 0.208515450358391, 0.208555519580841, 0.208594873547554, 0.208633556962013, 0.208671540021896, 0.208708807826042, 0.208745345473289, 0.208781182765961, 0.208816394209862, 0.208850830793381, 0.208884611725807, 0.208917632699013, 0.208949998021126, 0.208981648087502, 0.20901258289814, 0.209042847156525, 0.20907236635685, 0.209101229906082, 0.209129333496094, 0.20915675163269, 0.209183543920517, 0.2092095464468, 0.209234893321991, 0.209259524941444, 0.209283471107483, 0.209306702017784, 0.209329187870026, 0.209351018071175, 0.209372147917747, 0.209392592310905, 0.209412291646004, 0.209431290626526, 0.209449633955956, 0.209467217326164, 0.209484159946442, 0.209500342607498, 0.20951583981514, 0.209530651569366, 0.209544733166695, 0.209558188915253, 0.209570840001106, 0.20958286523819, 0.209594160318375, 0.209604725241661, 0.209614649415016, 0.20962381362915, 0.209632337093353, 0.209640100598335, 0.209647163748741, 0.209653556346893, 0.209659233689308, 0.209664225578308, 0.20966848731041, 0.209672063589096, 0.209674939513206, 0.209677085280418, 0.209678560495377, 0.20967935025692, 0.209679439663887, 0.209678784012794, 0.209677413105965, 0.209675386548042, 0.20967261493206, 0.209669202566147, 0.209665045142174, 0.209660187363625, 0.209654673933983, 0.20964840054512, 0.209641441702843, 0.20963379740715, 0.209638342261314, 0.209661260247231, 0.209684044122696, 0.209706693887711, 0.209729179739952, 0.209751546382904, 0.209773764014244, 0.209795862436295, 0.209817796945572, 0.209839597344398, 0.209861248731613, 0.209882766008377, 0.209904164075851, 0.209925383329391, 0.209946483373642, 0.209967449307442, 0.209988236427307, 0.210008934140205, 0.210029467940331, 0.210049867630005, 0.210070133209229, 0.210090234875679, 0.21011021733284, 0.210130020976067, 0.210149735212326, 0.210169270634651, 0.210188716650009, 0.210207968950272, 0.210227102041245, 0.210246086120605, 0.210264965891838, 0.210283666849136, 0.210302233695984, 0.210320651531219, 0.210338950157166, 0.2103570997715, 0.210375115275383, 0.210392966866493, 0.210410714149475, 0.210428282618523, 0.210445746779442, 0.210463047027588, 0.210480213165283, 0.210497230291367, 0.21051412820816, 0.210530877113342, 0.210547491908073, 0.21056392788887, 0.2105802744627, 0.210596442222595, 0.210612505674362, 0.210628405213356, 0.210644155740738, 0.21065978705883, 0.210675269365311, 0.210690602660179, 0.210705816745758, 0.210720866918564, 0.21073579788208, 0.210750564932823, 0.210765227675438, 0.210779711604118, 0.21079409122467, 0.210808292031288, 0.210822373628616, 0.210836306214333, 0.210850104689598, 0.210863754153252, 0.210877284407616, 0.210890650749207, 0.210903897881508, 0.210916996002197, 0.210929960012436, 0.210942760109901, 0.210955440998077, 0.210967972874641, 0.210980385541916, 0.210992619395256, 0.211004734039307, 0.211016714572906, 0.211028531193733, 0.211040243506432, 0.211051777005196, 0.21106319129467, 0.211074441671371, 0.211085587739944, 0.211096569895744, 0.211107447743416, 0.211118146777153, 0.211128696799278, 0.211139142513275, 0.211149424314499, 0.211159572005272, 0.211169585585594, 0.211179450154305, 0.211189180612564, 0.211198776960373, 0.211208209395409, 0.211217507719994, 0.211226671934128, 0.211232453584671, 0.211234390735626, 0.211236268281937, 0.211238071322441, 0.21123979985714, 0.211241483688354, 0.211243078112602, 0.211244627833366, 0.211246088147163, 0.211247503757477, 0.211248844861984, 0.211250111460686, 0.211251303553581, 0.211252436041832, 0.211253508925438, 0.211254522204399, 0.211255460977554, 0.211256325244904, 0.211257129907608, 0.211257845163345, 0.21125853061676, 0.211259126663208, 0.211259663105011, 0.211260139942169, 0.211260557174683, 0.211260885000229, 0.211261138319969, 0.211261346936226, 0.211261466145515, 0.211261540651321, 0.211261540651321, 0.211261466145515, 0.211261346936226, 0.211261138319969, 0.211260885000229, 0.211260557174683, 0.211260139942169, 0.211259678006172, 0.21125915646553, 0.21125853061676, 0.211257874965668, 0.211257144808769, 0.211256340146065, 0.211255460977554, 0.21125453710556, 0.21125353872776, 0.211252465844154, 0.211251318454742, 0.211250111460686, 0.211248844861984, 0.211247518658638, 0.211246103048325, 0.211244627833366, 0.211243107914925, 0.211241498589516, 0.211239829659462, 0.211238101124763, 0.211236268281937, 0.211234405636787, 0.211232483386993, 0.211230456829071, 0.211228400468826, 0.211226269602776, 0.211224064230919, 0.211221784353256, 0.21121945977211, 0.211217045783997, 0.211214572191238, 0.211212024092674, 0.211209416389465, 0.211206763982773, 0.211204007267952, 0.211201220750809, 0.211198315024376, 0.211195379495621, 0.21119236946106, 0.211189299821854, 0.211186170578003, 0.211182951927185, 0.211179673671722, 0.211176350712776, 0.211172923445702, 0.211169466376305, 0.21116591989994, 0.211162313818932, 0.211158618330956, 0.211154907941818, 0.211151078343391, 0.211147204041481, 0.211143255233765, 0.211139231920242, 0.211135193705559, 0.211131006479263, 0.211126804351807, 0.211122527718544, 0.211118191480637, 0.211113780736923, 0.211109310388565, 0.211104735732079, 0.21110013127327, 0.211091354489326, 0.211076661944389, 0.211062341928482, 0.211048364639282, 0.21103473007679, 0.211021468043327, 0.211008548736572, 0.210995987057686, 0.210983768105507, 0.210971921682358, 0.210960417985916, 0.210949286818504, 0.2109384983778, 0.210928052663803, 0.210917979478836, 0.210908249020576, 0.210898876190186, 0.210889860987663, 0.210881188511848, 0.210872903466225, 0.210864931344986, 0.210857331752777, 0.210850089788437, 0.210843175649643, 0.210836634039879, 0.210830464959145, 0.210824623703957, 0.210819154977798, 0.210814043879509, 0.210809275507927, 0.210804864764214, 0.210800796747208, 0.210797116160393, 0.210793748497963, 0.210790753364563, 0.21078810095787, 0.210785835981369, 0.210783898830414, 0.210782304406166, 0.210781082510948, 0.210780203342438, 0.210779711604118, 0.210779547691345, 0.210779741406441, 0.210780277848244, 0.210781186819077, 0.210782453417778, 0.210784047842026, 0.210786014795303, 0.210788324475288, 0.210791006684303, 0.210794046521187, 0.210797414183617, 0.210801154375076, 0.210805237293243, 0.210809677839279, 0.210814476013184, 0.210819646716118, 0.210825145244598, 0.210831016302109, 0.210837215185165, 0.210843786597252, 0.210850700736046, 0.21085798740387, 0.210865616798401, 0.210873618721962, 0.210881963372231, 0.210890650749207, 0.210899695754051, 0.210909098386765, 0.210918873548508, 0.210928976535797, 0.210939452052116, 0.210950270295143, 0.210961446166039, 0.210972964763641, 0.210984855890274, 0.210997089743614, 0.211009696125984, 0.211022615432739, 0.211035937070847, 0.211049571633339, 0.211063578724861, 0.211077973246574, 0.211092695593834, 0.21110774576664, 0.211123183369637, 0.21113894879818, 0.211155101656914, 0.211171582341194, 0.211188420653343, 0.211205661296844, 0.211223185062408, 0.211241111159325, 0.211259350180626, 0.211277991533279, 0.211296945810318, 0.211316272616386, 0.211335957050323, 0.211355984210968, 0.211378455162048, 0.211405396461487, 0.211433202028275, 0.211461886763573, 0.21149143576622, 0.211521849036217, 0.21155309677124, 0.211585253477097, 0.211618289351463, 0.211652174592018, 0.211686953902245, 0.211722567677498, 0.211759060621262, 0.211796432733536, 0.21183468401432, 0.211873784661293, 0.211913749575615, 0.211954593658447, 0.21199631690979, 0.212038904428482, 0.212082356214523, 0.212126642465591, 0.212171837687492, 0.21221786737442, 0.212264806032181, 0.212312608957291, 0.212361291050911, 0.212410807609558, 0.212461218237877, 0.212512508034706, 0.212564632296562, 0.212617635726929, 0.212671503424644, 0.212726265192032, 0.212781876325607, 0.212838381528854, 0.212895706295967, 0.212953954935074, 0.213013008236885, 0.21307298541069, 0.213133797049522, 0.213195532560349, 0.21325808763504, 0.213321521878242, 0.213385835289955, 0.213451012969017, 0.213517040014267, 0.21358397603035, 0.213651746511459, 0.213720411062241, 0.213789910078049, 0.213860288262367, 0.213931560516357, 0.214003667235374, 0.214076668024063, 0.214150533080101, 0.214225292205811, 0.214300885796547, 0.214377358555794, 0.21445469558239, 0.214532911777496, 0.214611977338791, 0.214691922068596, 0.214772745966911, 0.214854434132576, 0.21493698656559, 0.215020403265953, 0.215104684233665, 0.215189874172211, 0.215275883674622, 0.215362802147865, 0.215450540184975, 0.215539202094078, 0.215628683567047, 0.215719074010849, 0.215810313820839, 0.215902432799339, 0.215995416045189, 0.216089263558388, 0.216183990240097, 0.216279581189156, 0.216376021504402, 0.21647335588932, 0.216571539640427, 0.216670632362366, 0.216770559549332, 0.216871365904808, 0.216973036527634, 0.217075556516647, 0.217178985476494, 0.217283234000206, 0.217388406395912, 0.217494413256645, 0.21760131418705, 0.217709049582481, 0.217817693948746, 0.217927172780037, 0.218037530779839, 0.218148767948151, 0.218260854482651, 0.21839052438736, 0.218539148569107, 0.21868833899498, 0.2188381254673, 0.218988478183746, 0.219139367341995, 0.21929082274437, 0.219442874193192, 0.219595476984978, 0.21974866092205, 0.219902411103249, 0.220056727528572, 0.220211610198021, 0.220367074012756, 0.220523074269295, 0.22067965567112, 0.220836818218231, 0.220994532108307, 0.22115284204483, 0.221311688423157, 0.221471130847931, 0.221631094813347, 0.221791684627533, 0.221952825784683, 0.222114518284798, 0.222276777029037, 0.222439616918564, 0.222603023052216, 0.222766995429993, 0.222931548953056, 0.223096653819084, 0.223262324929237, 0.223428577184677, 0.223595395684242, 0.223762765526772, 0.223930701613426, 0.224099218845367, 0.224268317222595, 0.224437981843948, 0.224608197808266, 0.22477899491787, 0.224950358271599, 0.225122302770615, 0.225294768810272, 0.225467830896378, 0.225641459226608, 0.225815683603287, 0.225990444421768, 0.226165771484375, 0.22634169459343, 0.226518154144287, 0.226695209741592, 0.226872816681862, 0.227050989866257, 0.227229729294777, 0.227409049868584, 0.227588936686516, 0.227769389748573, 0.227950394153595, 0.228131994605064, 0.228314131498337, 0.228496879339218, 0.228680148720741, 0.228864014148712, 0.22904846072197, 0.229233458638191, 0.229419007897377, 0.229605138301849, 0.229791849851608, 0.22997909784317, 0.23016694188118, 0.230355367064476, 0.230544313788414, 0.2307338565588, 0.230923980474472, 0.231114655733109, 0.23130589723587, 0.231497719883919, 0.231690108776093, 0.23188304901123, 0.232076540589333, 0.232270643115044, 0.23246531188488, 0.232660517096519, 0.232856333255768, 0.233052685856819, 0.233249604701996, 0.233447104692459, 0.233645170927048, 0.233843803405762, 0.234043017029762, 0.234242781996727, 0.234443128108978, 0.234644010663033, 0.234845504164696, 0.235047534108162, 0.235250130295753, 0.235453307628632, 0.235657081007957, 0.235861361026764, 0.236069142818451, 0.236279144883156, 0.236488625407219, 0.236697554588318, 0.236905917525291, 0.237113744020462, 0.237321019172668, 0.237527742981911, 0.237733915448189, 0.237939551472664, 0.238144621253014, 0.238349169492722, 0.238553151488304, 0.238756582140923, 0.238959476351738, 0.239161819219589, 0.239363595843315, 0.239564850926399, 0.239765554666519, 0.239965707063675, 0.240165323019028, 0.240364357829094, 0.240562871098518, 0.240760833024979, 0.240958228707314, 0.241155102849007, 0.241351410746574, 0.241547182202339, 0.241742387413979, 0.241937056183815, 0.242131158709526, 0.242324739694595, 0.2425177693367, 0.242710247635841, 0.242902159690857, 0.243093550205231, 0.243284374475479, 0.243474662303925, 0.243664398789406, 0.243853583931923, 0.244042232632637, 0.244230315089226, 0.24441784620285, 0.244604870676994, 0.244791299104691, 0.244977191090584, 0.245162546634674, 0.245347365736961, 0.245531588792801, 0.245715320110321, 0.245898455381393, 0.246081054210663, 0.246263146400452, 0.246444642543793, 0.246625602245331, 0.246806025505066, 0.246985882520676, 0.247165203094482, 0.247343987226486, 0.247522205114365, 0.24769988656044, 0.247877031564713, 0.24805361032486, 0.248229622840881, 0.2484050989151, 0.248580038547516, 0.248754441738129, 0.248928278684616, 0.249101549386978, 0.24927431344986, 0.249446496367455, 0.249618157744408, 0.249789237976074, 0.24995981156826, 0.250129789113998, 0.250299245119095, 0.250468164682388, 0.250636518001556, 0.250804305076599, 0.250971585512161, 0.251138299703598, 0.251304447650909, 0.251470059156418, 0.251635134220123, 0.251799643039703, 0.251963645219803, 0.252127051353455, 0.252289921045303, 0.252452254295349, 0.252614051103592, 0.252775281667709, 0.252935975790024, 0.253096103668213, 0.253255695104599, 0.25341472029686, 0.253573209047318, 0.253731161355972, 0.253888547420502, 0.254045397043228, 0.254201680421829, 0.25433412194252, 0.254441916942596, 0.254548877477646, 0.254654973745346, 0.254760265350342, 0.254864722490311, 0.25496831536293, 0.255071103572845, 0.255173027515411, 0.255274146795273, 0.255374401807785, 0.255473852157593, 0.255572438240051, 0.255670189857483, 0.25576713681221, 0.255863219499588, 0.255958497524261, 0.256052881479263, 0.256146460771561, 0.256239235401154, 0.256331145763397, 0.256422191858292, 0.256512463092804, 0.256601840257645, 0.256690412759781, 0.25677815079689, 0.256865054368973, 0.256951123476028, 0.257036358118057, 0.257120758295059, 0.257204324007034, 0.25728702545166, 0.257368922233582, 0.257449954748154, 0.257530182600021, 0.257609575986862, 0.257688105106354, 0.257765799760818, 0.257842659950256, 0.25791871547699, 0.257993906736374, 0.258068263530731, 0.258141815662384, 0.258214503526688, 0.258286356925964, 0.258357405662537, 0.258427560329437, 0.258496940135956, 0.258565425872803, 0.258633136749268, 0.258699983358383, 0.25876596570015, 0.258831143379211, 0.258895486593246, 0.258958995342255, 0.259021669626236, 0.259083479642868, 0.259144484996796, 0.259204655885696, 0.259263962507248, 0.259322464466095, 0.259380102157593, 0.259436935186386, 0.25949290394783, 0.25954806804657, 0.259602397680283, 0.259655863046646, 0.259708493947983, 0.259760320186615, 0.259811282157898, 0.259861409664154, 0.259910702705383, 0.259959161281586, 0.260006785392761, 0.260053604841232, 0.260099560022354, 0.260144680738449, 0.260188966989517, 0.260232388973236, 0.260275036096573, 0.260316789150238, 0.260357737541199, 0.260397851467133, 0.260437101125717, 0.260475546121597, 0.260513156652451, 0.260549902915955, 0.260585844516754, 0.260620921850204, 0.26065519452095, 0.260688632726669, 0.260721206665039, 0.260752946138382, 0.26078388094902, 0.26081395149231, 0.260843217372894, 0.26087161898613, 0.260899186134338, 0.26092591881752, 0.260951846837997, 0.260968744754791, 0.26097759604454, 0.260986566543579, 0.26099568605423, 0.261004954576492, 0.261014401912689, 0.261023968458176, 0.261033684015274, 0.261043548583984, 0.261053562164307, 0.261063754558563, 0.261074036359787, 0.261084496974945, 0.261095106601715, 0.261105865240097, 0.261116743087769, 0.261127799749374, 0.26113897562027, 0.261150300502777, 0.261161804199219, 0.26117342710495, 0.261185199022293, 0.261197119951248, 0.261209219694138, 0.261221438646317, 0.261233806610107, 0.261246293783188, 0.261258959770203, 0.261271774768829, 0.261284738779068, 0.261297851800919, 0.261311084032059, 0.261324465274811, 0.261338025331497, 0.261351704597473, 0.261365562677383, 0.261379539966583, 0.261393666267395, 0.261407971382141, 0.261422365903854, 0.261436939239502, 0.261451661586761, 0.261466532945633, 0.261481553316116, 0.261496722698212, 0.261512011289597, 0.261527478694916, 0.261543095111847, 0.261558830738068, 0.2615747153759, 0.261590778827667, 0.261606961488724, 0.261623293161392, 0.261639773845673, 0.261656403541565, 0.261673182249069, 0.261690139770508, 0.261707216501236, 0.261724442243576, 0.261741787195206, 0.26175931096077, 0.261776953935623, 0.261794775724411, 0.261812716722488, 0.2618308365345, 0.261849075555801, 0.261867463588715, 0.26188600063324, 0.261904716491699, 0.261923551559448, 0.261942535638809, 0.261961668729782, 0.261980921030045, 0.262000381946564, 0.26201993227005, 0.262039661407471, 0.262059509754181, 0.262079566717148, 0.26209968328476, 0.262120008468628, 0.262140452861786, 0.262161046266556, 0.26218181848526, 0.262202709913254, 0.262223750352859, 0.262244939804077, 0.262266278266907, 0.262287765741348, 0.262309402227402, 0.262331157922745, 0.262353092432022, 0.262375175952911, 0.262397408485413, 0.262419790029526, 0.262442260980606, 0.262464940547943, 0.26248773932457, 0.262510716915131, 0.262533813714981, 0.262557059526443, 0.262600928544998, 0.262665748596191, 0.262731194496155, 0.262797296047211, 0.262864053249359, 0.262931406497955, 0.262999445199966, 0.263068109750748, 0.263137400150299, 0.263207346200943, 0.263277947902679, 0.263349145650864, 0.263421058654785, 0.263493567705154, 0.263566732406616, 0.263640522956848, 0.26371493935585, 0.263790011405945, 0.263865768909454, 0.263942122459412, 0.264019161462784, 0.264096766710281, 0.264175057411194, 0.264254003763199, 0.264333575963974, 0.264413803815842, 0.264494627714157, 0.264576137065887, 0.264658272266388, 0.264741063117981, 0.264824479818344, 0.2649085521698, 0.264993280172348, 0.265078634023666, 0.265164583921432, 0.265251219272614, 0.265338510274887, 0.265426427125931, 0.265514969825745, 0.265604168176651, 0.26569402217865, 0.265784502029419, 0.265875637531281, 0.265967398881912, 0.266059815883636, 0.266152858734131, 0.266246527433395, 0.266340881586075, 0.266435861587524, 0.266531467437744, 0.266627728939056, 0.266724616289139, 0.266822159290314, 0.266920328140259, 0.267019182443619, 0.267118632793427, 0.267218738794327, 0.26731950044632, 0.267420887947083, 0.267522931098938, 0.267625600099564, 0.267728894948959, 0.26783287525177, 0.267937481403351, 0.268042713403702, 0.268148601055145, 0.268255114555359, 0.268362283706665, 0.268470078706741, 0.26857852935791, 0.268687635660172, 0.268797367811203, 0.268907755613327, 0.269018769264221, 0.269130438566208, 0.269242733716965, 0.269355654716492, 0.269469261169434, 0.269583463668823, 0.269698351621628, 0.26981383562088, 0.269930005073547, 0.270046800374985, 0.270164221525192, 0.270282328128815, 0.270401030778885, 0.270520389080048, 0.27064037322998, 0.270761042833328, 0.270882338285446, 0.271004259586334, 0.271126806735992, 0.271250009536743, 0.271373867988586, 0.2714983522892, 0.271623492240906, 0.271749287843704, 0.27187567949295, 0.272002756595612, 0.272130459547043, 0.272270739078522, 0.272422969341278, 0.272575080394745, 0.272726982831955, 0.272878736257553, 0.273030340671539, 0.273181796073914, 0.273333072662354, 0.273484200239182, 0.27363520860672, 0.273785978555679, 0.273936629295349, 0.274087131023407, 0.274237424135208, 0.274387568235397, 0.274537563323975, 0.27468740940094, 0.274837136268616, 0.274986624717712, 0.27513599395752, 0.275285214185715, 0.275434255599976, 0.275583118200302, 0.275731801986694, 0.275880366563797, 0.27602881193161, 0.276176989078522, 0.276325106620789, 0.276472985744476, 0.276620745658875, 0.276768356561661, 0.276915818452835, 0.277063071727753, 0.277210175991058, 0.277357131242752, 0.277503907680511, 0.277650535106659, 0.277797013521194, 0.277943342924118, 0.278089493513107, 0.278235495090485, 0.278381317853928, 0.278526991605759, 0.278672486543655, 0.27881783246994, 0.278963029384613, 0.279108077287674, 0.279252916574478, 0.279397636651993, 0.279542177915573, 0.279686570167542, 0.279830783605576, 0.279974848031998, 0.280118763446808, 0.280262500047684, 0.280406057834625, 0.280549496412277, 0.280692785978317, 0.280835866928101, 0.280978828668594, 0.281121581792831, 0.281264215707779, 0.281406670808792, 0.281548976898193, 0.28169110417366, 0.281833082437515, 0.281974911689758, 0.282116562128067, 0.282258093357086, 0.282399415969849, 0.282540619373322, 0.282681614160538, 0.282822489738464, 0.282963156700134, 0.283103674650192, 0.283244073390961, 0.283384263515472, 0.283524334430695, 0.283664226531982, 0.283803969621658, 0.2839435338974, 0.28408294916153, 0.284222185611725, 0.284361302852631, 0.28450021147728, 0.284639000892639, 0.284777581691742, 0.284916073083878, 0.285054355859756, 0.285192489624023, 0.285330444574356, 0.285468250513077, 0.285605907440186, 0.28574338555336, 0.285880744457245, 0.286017894744873, 0.286154896020889, 0.286291718482971, 0.286428421735764, 0.286564946174622, 0.286683142185211, 0.286782681941986, 0.286881506443024, 0.286979645490646, 0.287077009677887, 0.287173628807068, 0.287269592285156, 0.287364810705185, 0.287459313869476, 0.287553071975708, 0.287646144628525, 0.287738442420959, 0.287830024957657, 0.287920951843262, 0.288011103868484, 0.28810054063797, 0.288189262151718, 0.288277238607407, 0.28836452960968, 0.288451075553894, 0.288536876440048, 0.288621991872787, 0.288706392049789, 0.288790076971054, 0.288872987031937, 0.288955241441727, 0.289036691188812, 0.289117515087128, 0.289197534322739, 0.289276868104935, 0.289355516433716, 0.289433360099792, 0.289510548114777, 0.289586991071701, 0.289662718772888, 0.289737701416016, 0.289811968803406, 0.289885520935059, 0.289958357810974, 0.290030509233475, 0.290101855993271, 0.290172547101974, 0.290242463350296, 0.290311723947525, 0.290380209684372, 0.290447980165482, 0.290515065193176, 0.290581375360489, 0.290647029876709, 0.290711909532547, 0.290776073932648, 0.290839523077011, 0.290902256965637, 0.290964245796204, 0.291025549173355, 0.291086137294769, 0.291145920753479, 0.291205048561096, 0.291263490915298, 0.291321128606796, 0.291378080844879, 0.291434317827225, 0.291489809751511, 0.291544616222382, 0.291598677635193, 0.291652023792267, 0.291704624891281, 0.29175654053688, 0.29180771112442, 0.291858166456223, 0.291907906532288, 0.291956931352615, 0.292005211114883, 0.292052775621414, 0.29209965467453, 0.292145729064941, 0.292191118001938, 0.292235821485519, 0.292279750108719, 0.292323023080826, 0.292365521192551, 0.292407304048538, 0.292448401451111, 0.292488723993301, 0.292528361082077, 0.292567253112793, 0.292605429887772, 0.292642891407013, 0.292679637670517, 0.292715668678284, 0.292750954627991, 0.29278552532196, 0.292819380760193, 0.292852491140366, 0.292884886264801, 0.292916595935822, 0.292947560548782, 0.292977809906006, 0.293007344007492, 0.293036133050919, 0.29305824637413, 0.293073982000351, 0.293089389801025, 0.293104469776154, 0.293119221925735, 0.293133646249771, 0.29314774274826, 0.293161600828171, 0.293175041675568, 0.293188214302063, 0.29320102930069, 0.293213546276093, 0.293225735425949, 0.293237626552582, 0.293249160051346, 0.293260395526886, 0.293271332979202, 0.29328191280365, 0.293292164802551, 0.293302118778229, 0.29331174492836, 0.293321043252945, 0.293330013751984, 0.293338686227798, 0.293347030878067, 0.293355047702789, 0.293362706899643, 0.293370127677917, 0.293377190828323, 0.293383926153183, 0.293390333652496, 0.293396443128586, 0.293402224779129, 0.293407648801804, 0.293412774801254, 0.293417632579803, 0.293422132730484, 0.293426305055618, 0.293430149555206, 0.293433666229248, 0.293436884880066, 0.293439745903015, 0.293442279100418, 0.293444573879242, 0.293446481227875, 0.293448090553284, 0.293449372053146, 0.293450325727463, 0.293450981378555, 0.293451309204102, 0.293451309204102, 0.293450981378555, 0.293450325727463, 0.293449372053146, 0.293448090553284, 0.293446481227875, 0.293444573879242, 0.293442279100418, 0.293439745903015, 0.293436884880066, 0.293433636426926, 0.293430119752884, 0.293426305055618, 0.293422132730484, 0.293417632579803, 0.293412774801254, 0.293407648801804, 0.293402224779129, 0.293396413326263, 0.293390333652496, 0.293383926153183, 0.293377190828323, 0.293370127677917, 0.293362706899643, 0.293355047702789, 0.293347030878067, 0.293338686227798, 0.293330013751984, 0.293321013450623, 0.29331174492836, 0.293302088975906, 0.293292164802551, 0.29328191280365, 0.293271273374557, 0.293260395526886, 0.293249130249023, 0.293237566947937, 0.293225735425949, 0.293213546276093, 0.29320102930069, 0.293188154697418, 0.293175041675568, 0.293161571025848, 0.29314774274826, 0.293133646249771, 0.293119192123413, 0.293104439973831, 0.293089359998703, 0.293073952198029, 0.29305824637413, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050616979599, 0.293050646781921, 0.293050646781921, 0.293050646781921, 0.293050646781921, 0.293050646781921, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293050676584244, 0.293048739433289, 0.293044775724411, 0.293040931224823, 0.293037176132202, 0.293033450841904, 0.293029874563217, 0.293026328086853, 0.293022871017456, 0.293019503355026, 0.293016225099564, 0.293013006448746, 0.293009877204895, 0.293006807565689, 0.293003886938095, 0.293000996112823, 0.292998194694519, 0.292995452880859, 0.292992830276489, 0.292990237474442, 0.292987763881683, 0.292985379695892, 0.292983055114746, 0.292980760335922, 0.29297861456871, 0.292976528406143, 0.292974531650543, 0.29297262430191, 0.292970776557922, 0.292969018220901, 0.292967319488525, 0.292965739965439, 0.292964190244675, 0.2929627597332, 0.29296138882637, 0.292960107326508, 0.292958915233612, 0.292957782745361, 0.292956739664078, 0.292955785989761, 0.292954921722412, 0.292954117059708, 0.292953342199326, 0.2929527759552, 0.292952179908752, 0.292951732873917, 0.292951285839081, 0.292950987815857, 0.292950749397278, 0.292950600385666, 0.292950510978699, 0.292950510978699, 0.292950600385666, 0.292950749397278, 0.292951017618179, 0.292951345443726, 0.292951732873917, 0.292952209711075, 0.2929527759552, 0.292953431606293, 0.29295414686203, 0.292954921722412, 0.292955845594406, 0.2929567694664, 0.292957842350006, 0.292958945035934, 0.29296013712883, 0.292961448431015, 0.292962819337845, 0.292964249849319, 0.292965769767761, 0.29296737909317, 0.292969077825546, 0.292970836162567, 0.292972683906555, 0.292974650859833, 0.29297661781311, 0.292978674173355, 0.292980909347534, 0.292983114719391, 0.292985469102859, 0.292987853288651, 0.292990356683731, 0.292992919683456, 0.292995572090149, 0.292998254299164, 0.293001085519791, 0.293003976345062, 0.293006956577301, 0.293010026216507, 0.293013155460358, 0.293016344308853, 0.293019652366638, 0.293023020029068, 0.293026477098465, 0.293029993772507, 0.293033570051193, 0.293037295341492, 0.293041050434113, 0.293044894933701, 0.293048858642578, 0.293053895235062, 0.293061107397079, 0.293068468570709, 0.293076008558273, 0.293083786964417, 0.293091684579849, 0.293099790811539, 0.293108075857162, 0.293116539716721, 0.293125182390213, 0.29313400387764, 0.293143033981323, 0.293152183294296, 0.293161571025848, 0.293171137571335, 0.293180853128433, 0.293190747499466, 0.293200820684433, 0.293211102485657, 0.293221533298492, 0.293232172727585, 0.293242961168289, 0.29325395822525, 0.293265163898468, 0.293276488780975, 0.293288052082062, 0.293299734592438, 0.29331162571907, 0.29332372546196, 0.293335944414139, 0.293348401784897, 0.293361008167267, 0.293373823165894, 0.293386787176132, 0.293399930000305, 0.293413281440735, 0.293426752090454, 0.293440461158752, 0.293454378843307, 0.293468415737152, 0.293482661247253, 0.293497055768967, 0.293511688709259, 0.293526440858841, 0.293541461229324, 0.293556541204453, 0.29357185959816, 0.293587386608124, 0.2936030626297, 0.293618947267532, 0.293635010719299, 0.293651193380356, 0.293667614459991, 0.293684184551239, 0.293700933456421, 0.293717890977859, 0.29373499751091, 0.29375234246254, 0.293769806623459, 0.293787479400635, 0.293805330991745, 0.29382336139679, 0.293841570615768, 0.293859958648682, 0.293878555297852, 0.293897300958633, 0.29391622543335, 0.293935298919678, 0.293954610824585, 0.293974101543427, 0.29399374127388, 0.29401358962059, 0.294033586978912, 0.294053763151169, 0.294074147939682, 0.29409471154213, 0.294115453958511, 0.29413640499115, 0.294157475233078, 0.294178754091263, 0.294200211763382, 0.294221848249435, 0.294243663549423, 0.294265657663345, 0.294287860393524, 0.294310212135315, 0.294332772493362, 0.294355452060699, 0.294378399848938, 0.294401437044144, 0.294424712657928, 0.294448137283325, 0.294471770524979, 0.294495552778244, 0.294519573450089, 0.294543713331223, 0.294568091630936, 0.294592589139938, 0.29461732506752, 0.294642180204391, 0.29466724395752, 0.294692546129227, 0.294718027114868, 0.294743746519089, 0.294769734144211, 0.294795870780945, 0.29482227563858, 0.294848889112473, 0.294875741004944, 0.294902771711349, 0.294930070638657, 0.294957548379898, 0.294985264539719, 0.295013189315796, 0.295041352510452, 0.295069724321365, 0.295098304748535, 0.295127123594284, 0.295156180858612, 0.295185416936874, 0.295214891433716, 0.295244634151459, 0.295274525880814, 0.29530468583107, 0.295335054397583, 0.29536560177803, 0.295396417379379, 0.295427441596985, 0.295458674430847, 0.295490145683289, 0.295521855354309, 0.295553743839264, 0.295585840940475, 0.295618236064911, 0.295650780200958, 0.295683562755585, 0.295716613531113, 0.295749843120575, 0.295783251523972, 0.29581692814827, 0.295850813388824, 0.295884966850281, 0.295919239521027, 0.295953840017319, 0.2959885597229, 0.296023607254028, 0.296058803796768, 0.296094238758087, 0.296129882335663, 0.29616579413414, 0.296201884746552, 0.29623818397522, 0.296274751424789, 0.296311497688293, 0.296348422765732, 0.296385645866394, 0.296423047780991, 0.296460717916489, 0.296498566865921, 0.296536654233932, 0.296574950218201, 0.29661351442337, 0.296652257442474, 0.296691209077835, 0.296730369329453, 0.296769797801971, 0.296809405088425, 0.296849250793457, 0.296889334917068, 0.296929627656937, 0.296970129013062, 0.297010838985443, 0.297051817178726, 0.297092974185944, 0.29713436961174, 0.297175973653793, 0.297217816114426, 0.297259867191315, 0.297302156686783, 0.297344624996185, 0.297387361526489, 0.297430276870728, 0.297473460435867, 0.297516793012619, 0.297560393810272, 0.297604203224182, 0.297648280858994, 0.297692537307739, 0.297736972570419, 0.297781705856323, 0.297826617956161, 0.297871738672256, 0.297917127609253, 0.297962725162506, 0.298008471727371, 0.298054575920105, 0.298100769519806, 0.298147261142731, 0.29819393157959, 0.298240840435028, 0.298288255929947, 0.298335254192352, 0.298382520675659, 0.298430055379868, 0.2984778881073, 0.298525929450989, 0.298574298620224, 0.298622906208038, 0.298671782016754, 0.298720955848694, 0.29877033829689, 0.298820078372955, 0.298870027065277, 0.2989202439785, 0.298970758914948, 0.299021542072296, 0.299072504043579, 0.299123823642731, 0.299175441265106, 0.299227267503738, 0.299279391765594, 0.29933175444603, 0.299384355545044, 0.299437284469604, 0.299490451812744, 0.299543887376785, 0.29959762096405, 0.299651652574539, 0.299705862998962, 0.299760431051254, 0.299815207719803, 0.299870252609253, 0.299925565719604, 0.299981206655502, 0.300037056207657, 0.300093173980713, 0.300149589776993, 0.300206273794174, 0.300263196229935, 0.300320386886597, 0.300377905368805, 0.30043563246727, 0.300493627786636, 0.300551921129227, 0.300610482692719, 0.300669312477112, 0.300728380680084, 0.300787717103958, 0.300847381353378, 0.300907254219055, 0.300967425107956, 0.301027864217758, 0.30108854174614, 0.301149517297745, 0.301210761070251, 0.30127227306366, 0.301334023475647, 0.301396042108536, 0.301458388566971, 0.301520973443985, 0.301583796739578, 0.301646918058395, 0.301710307598114, 0.301773935556412, 0.301837861537933, 0.301902055740356, 0.301966518163681, 0.302031248807907, 0.302096217870712, 0.302161514759064, 0.302227050065994, 0.302292853593826, 0.302358895540237, 0.302425235509872, 0.302491843700409, 0.302558720111847, 0.302625834941864, 0.302693277597427, 0.30276095867157, 0.302828907966614, 0.302897125482559, 0.302965611219406, 0.303034335374832, 0.303103387355804, 0.303172677755356, 0.303242236375809, 0.303312033414841, 0.303382158279419, 0.303452521562576, 0.303523153066635, 0.303594052791595, 0.303665220737457, 0.303736686706543, 0.303808361291885, 0.303880363702774, 0.303952604532242, 0.304025083780289, 0.304097861051559, 0.304170936346054, 0.304244250059128, 0.304333120584488, 0.304434835910797, 0.304536283016205, 0.304637491703033, 0.304738491773605, 0.304839253425598, 0.304939717054367, 0.305039912462234, 0.305139929056168, 0.305239707231522, 0.305339187383652, 0.305438458919525, 0.305537492036819, 0.305636256933212, 0.305734813213348, 0.305833101272583, 0.305931150913239, 0.306028991937637, 0.306126534938812, 0.30622386932373, 0.306320935487747, 0.306417793035507, 0.306514382362366, 0.306610703468323, 0.306706875562668, 0.306802690029144, 0.306898325681686, 0.306993722915649, 0.307088851928711, 0.307183772325516, 0.307278424501419, 0.307372838258743, 0.307467013597488, 0.307560950517654, 0.307654649019241, 0.307748049497604, 0.307841241359711, 0.307934165000916, 0.308026939630508, 0.308119356632233, 0.308211594820023, 0.308303594589233, 0.30839529633522, 0.308486819267273, 0.308578073978424, 0.308669090270996, 0.308759838342667, 0.308850347995758, 0.308940678834915, 0.309030711650848, 0.309120506048203, 0.309210032224655, 0.309299379587173, 0.309388428926468, 0.309477239847183, 0.309565842151642, 0.309654206037521, 0.309742271900177, 0.309830129146576, 0.309917747974396, 0.310005068778992, 0.310092210769653, 0.310179114341736, 0.310265719890594, 0.310352146625519, 0.310438305139542, 0.310524225234985, 0.310609877109528, 0.310695260763168, 0.310780465602875, 0.310865432024002, 0.31095016002655, 0.311034590005875, 0.31111878156662, 0.311202734708786, 0.311286419630051, 0.311369985342026, 0.311453223228455, 0.311536252498627, 0.311618953943253, 0.311701476573944, 0.311783730983734, 0.311865776777267, 0.311947524547577, 0.31202906370163, 0.312110364437103, 0.312191426753998, 0.312272191047668, 0.31235283613205, 0.312433123588562, 0.312513202428818, 0.312593042850494, 0.31267261505127, 0.31275200843811, 0.31283113360405, 0.312909990549088, 0.312988638877869, 0.313066959381104, 0.313145101070404, 0.313223034143448, 0.313300728797913, 0.313377112150192, 0.313452184200287, 0.313525855541229, 0.313598275184631, 0.313669353723526, 0.31373918056488, 0.313807636499405, 0.313874751329422, 0.313940584659576, 0.314005017280579, 0.314068198204041, 0.31413009762764, 0.314190536737442, 0.314249753952026, 0.314307659864426, 0.314364194869995, 0.31441941857338, 0.314473330974579, 0.314525961875916, 0.3145771920681, 0.314627110958099, 0.314675718545914, 0.314723014831543, 0.31476902961731, 0.314813703298569, 0.314857006072998, 0.31489896774292, 0.314939618110657, 0.314978986978531, 0.31501704454422, 0.315053731203079, 0.315089166164398, 0.315123230218887, 0.315155953168869, 0.315187364816666, 0.315217584371567, 0.315246224403381, 0.315273761749268, 0.315299808979034, 0.315324634313583, 0.31534817814827, 0.315370261669159, 0.315391212701797, 0.315410643815994, 0.315428882837296, 0.315445721149445, 0.315461367368698, 0.315475523471832, 0.315488427877426, 0.315500050783157, 0.315510332584381, 0.315519243478775, 0.315526932477951, 0.315533190965652, 0.315538167953491, 0.315541744232178, 0.315544158220291, 0.315545082092285, 0.315544873476028, 0.315543174743652, 0.315540254116058, 0.315535932779312, 0.315530329942703, 0.315523415803909, 0.31551519036293, 0.315505623817444, 0.315494745969772, 0.315482467412949, 0.315468966960907, 0.315454095602036, 0.315437972545624, 0.315420389175415, 0.315401613712311, 0.315381437540054, 0.315359950065613, 0.315337151288986, 0.315313100814819, 0.3152876496315, 0.315260857343674, 0.31523272395134, 0.315203368663788, 0.315172612667084, 0.315140604972839, 0.315107226371765, 0.315072536468506, 0.315036505460739, 0.314999163150787, 0.314960479736328, 0.314920574426651, 0.314879179000854, 0.31483656167984, 0.314792603254318, 0.314747244119644, 0.314700722694397, 0.314652800559998, 0.314603537321091, 0.314552962779999, 0.314501136541367, 0.314447849988937, 0.314361959695816, 0.314244359731674, 0.314125657081604, 0.314005672931671, 0.313884645700455, 0.313762366771698, 0.313638985157013, 0.31351438164711, 0.313388675451279, 0.313261687755585, 0.31313368678093, 0.313004404306412, 0.31287407875061, 0.312742441892624, 0.312609761953354, 0.312475800514221, 0.312340795993805, 0.312204509973526, 0.312067151069641, 0.311928570270538, 0.311788767576218, 0.311647951602936, 0.311505824327469, 0.311362683773041, 0.311218202114105, 0.311072707176208, 0.310925960540771, 0.310778111219406, 0.3106290102005, 0.310478866100311, 0.310327410697937, 0.310174942016602, 0.310021191835403, 0.309866368770599, 0.309710264205933, 0.30955308675766, 0.309394717216492, 0.309235215187073, 0.309074431657791, 0.308912634849548, 0.308749556541443, 0.308585405349731, 0.308420032262802, 0.308253526687622, 0.308085739612579, 0.307916909456253, 0.307746887207031, 0.307575762271881, 0.307403326034546, 0.307229816913605, 0.307055115699768, 0.306879341602325, 0.306702226400375, 0.306524157524109, 0.306344717741013, 0.306164264678955, 0.305982530117035, 0.305799752473831, 0.305615693330765, 0.30543053150177, 0.30524417757988, 0.305056691169739, 0.304867953062057, 0.304678201675415, 0.304487198591232, 0.304294943809509, 0.304101645946503, 0.303907185792923, 0.303711473941803, 0.30351459980011, 0.303316712379456, 0.303117513656616, 0.302917182445526, 0.302715688943863, 0.302513062953949, 0.302309215068817, 0.302104264497757, 0.301898121833801, 0.30169078707695, 0.301482230424881, 0.301272660493851, 0.301061809062958, 0.300849854946136, 0.30063670873642, 0.300422489643097, 0.300206929445267, 0.299990266561508, 0.299772500991821, 0.299553543329239, 0.299333363771439, 0.299112141132355, 0.298889607191086, 0.298666030168533, 0.298441141843796, 0.298215270042419, 0.297988086938858, 0.297759830951691, 0.297530382871628, 0.297299712896347, 0.297067940235138, 0.296835362911224, 0.296604990959167, 0.296374768018723, 0.296144753694534, 0.295914977788925, 0.295685231685638, 0.295455813407898, 0.295226484537125, 0.294997453689575, 0.294768452644348, 0.294539749622345, 0.294311165809631, 0.294082820415497, 0.293854594230652, 0.293626636266708, 0.29339873790741, 0.293171107769012, 0.292943596839905, 0.292716324329376, 0.292489171028137, 0.292262315750122, 0.292035460472107, 0.291809022426605, 0.291582614183426, 0.291356444358826, 0.291130304336548, 0.290904551744461, 0.290678858757019, 0.290453433990479, 0.290228098630905, 0.290002882480621, 0.289778053760529, 0.289553284645081, 0.289328694343567, 0.28910431265831, 0.288880169391632, 0.288656115531921, 0.288432270288467, 0.288208574056625, 0.287985175848007, 0.287761807441711, 0.28753873705864, 0.287315756082535, 0.287093043327332, 0.28687047958374, 0.286648094654083, 0.286425888538361, 0.286203891038895, 0.285981982946396, 0.285760372877121, 0.285538882017136, 0.285317569971085, 0.285096436738968, 0.284875512123108, 0.28465473651886, 0.284434199333191, 0.284213781356812, 0.283993601799011, 0.2837735414505, 0.283553689718246, 0.283334076404572, 0.283114522695541, 0.28289520740509, 0.282676070928574, 0.282457262277603, 0.282238364219666, 0.282019853591919, 0.28180143237114, 0.281583309173584, 0.281365185976028, 0.281147360801697, 0.280929654836655, 0.280712217092514, 0.280494838953018, 0.280277788639069, 0.280060887336731, 0.279844135046005, 0.279627501964569, 0.279411166906357, 0.279194891452789, 0.278978884220123, 0.278762996196747, 0.278547376394272, 0.278331845998764, 0.278116554021835, 0.277901411056519, 0.277686446905136, 0.277471721172333, 0.277257084846497, 0.277042776346207, 0.276828467845917, 0.276614487171173, 0.276400625705719, 0.276186972856522, 0.275973379611969, 0.275760143995285, 0.275546997785568, 0.275334119796753, 0.27512127161026, 0.274908751249313, 0.274720460176468, 0.274559259414673, 0.274398535490036, 0.274238348007202, 0.274078547954559, 0.273919194936752, 0.273760288953781, 0.273601979017258, 0.273443996906281, 0.273286581039429, 0.273129522800446, 0.272972971200943, 0.272816956043243, 0.27266126871109, 0.272506207227707, 0.272351533174515, 0.272197335958481, 0.27204355597496, 0.271890342235565, 0.271737486124039, 0.271585196256638, 0.271433264017105, 0.27128192782402, 0.271130919456482, 0.270980477333069, 0.270830422639847, 0.27068093419075, 0.270531803369522, 0.270383238792419, 0.270235061645508, 0.270087361335754, 0.269940137863159, 0.269793421030045, 0.269647091627121, 0.269501298666, 0.269355982542038, 0.269211113452911, 0.269066631793976, 0.268922597169876, 0.268779188394547, 0.268636077642441, 0.268493622541428, 0.268351465463638, 0.268209874629974, 0.268068641424179, 0.267928004264832, 0.267787754535675, 0.267648071050644, 0.267508685588837, 0.267369896173477, 0.267231494188309, 0.267093628644943, 0.266956150531769, 0.266819208860397, 0.266682654619217, 0.266546666622162, 0.266411066055298, 0.266275942325592, 0.266141325235367, 0.266007155179977, 0.265873432159424, 0.265740215778351, 0.265607386827469, 0.26547509431839, 0.265343219041824, 0.265211820602417, 0.265080899000168, 0.264950424432755, 0.264820486307144, 0.264690905809402, 0.264561891555786, 0.264433264732361, 0.264305174350739, 0.264177471399307, 0.264050304889679, 0.263923555612564, 0.263797372579575, 0.263671547174454, 0.263546228408813, 0.263421326875687, 0.26329693198204, 0.263173013925552, 0.2630495429039, 0.262926548719406, 0.26280403137207, 0.262681901454926, 0.262560307979584, 0.262439221143723, 0.262318581342697, 0.26219829916954, 0.262078583240509, 0.261959284543991, 0.261840403079987, 0.26172211766243, 0.261604219675064, 0.261486828327179, 0.261369824409485, 0.261253416538239, 0.261137366294861, 0.261021822690964, 0.260893672704697, 0.260754972696304, 0.260616481304169, 0.260478258132935, 0.260340243577957, 0.260202467441559, 0.26006481051445, 0.259927421808243, 0.259790241718292, 0.259653270244598, 0.259516507387161, 0.259379953145981, 0.259243607521057, 0.25910747051239, 0.25897154211998, 0.258835792541504, 0.258700340986252, 0.258565038442612, 0.258429974317551, 0.258295118808746, 0.258160412311554, 0.258025974035263, 0.257891774177551, 0.257757723331451, 0.257623910903931, 0.257490277290344, 0.257356882095337, 0.257223725318909, 0.257090747356415, 0.256957948207855, 0.256825387477875, 0.256693094968796, 0.256560921669006, 0.256429016590118, 0.256297260522842, 0.25616580247879, 0.256034523248672, 0.255903422832489, 0.255772560834885, 0.255641877651215, 0.255511432886124, 0.255381226539612, 0.255251169204712, 0.255121350288391, 0.254991739988327, 0.254862368106842, 0.254733175039291, 0.254604190587997, 0.254475444555283, 0.254346877336502, 0.254218518733978, 0.254090428352356, 0.253962516784668, 0.253834754228592, 0.253707259893417, 0.2535799741745, 0.253452897071838, 0.253326058387756, 0.253199338912964, 0.253072887659073, 0.252946674823761, 0.252820640802383, 0.252694845199585, 0.252569198608398, 0.252443820238113, 0.252318680286407, 0.252193689346313, 0.252068936824799, 0.25194439291954, 0.251820027828217, 0.251695901155472, 0.251571983098984, 0.251448214054108, 0.251324743032455, 0.251201450824738, 0.251078397035599, 0.250955551862717, 0.250832855701447, 0.250710397958755, 0.250588178634644, 0.250466167926788, 0.25034436583519, 0.250222712755203, 0.250101327896118, 0.249980136752129, 0.249859184026718, 0.249738410115242, 0.249617844820023, 0.249497532844543, 0.24937741458416, 0.249257475137711, 0.249137759208679, 0.249018266797066, 0.248898968100548, 0.248779892921448, 0.248661026358604, 0.248542323708534, 0.248423933982849, 0.248305678367615, 0.248187631368637, 0.248077735304832, 0.247981444001198, 0.247885197401047, 0.247788935899734, 0.247692674398422, 0.247596397995949, 0.247500136494637, 0.247403889894485, 0.247307628393173, 0.247211411595345, 0.247115075588226, 0.247018858790398, 0.246922582387924, 0.246826335787773, 0.246730074286461, 0.246633797883987, 0.246537551283836, 0.246441319584846, 0.246345058083534, 0.246248781681061, 0.246152490377426, 0.246056273579597, 0.245959982275963, 0.245863765478134, 0.245767444372177, 0.245671212673187, 0.245574936270714, 0.245478704571724, 0.245382457971573, 0.245286166667938, 0.245189890265465, 0.245093658566475, 0.244997411966324, 0.244901165366173, 0.244804859161377, 0.244708597660065, 0.244612365961075, 0.244516119360924, 0.244419857859612, 0.244323581457138, 0.244227305054665, 0.244131073355675, 0.244034796953201, 0.243938565254211, 0.243842273950577, 0.243746027350426, 0.243649765849113, 0.243553519248962, 0.243457227945328, 0.243360996246338, 0.243264719843864, 0.243168473243713, 0.243072211742401, 0.242975935339928, 0.242879673838615, 0.242783427238464, 0.242687165737152, 0.242590934038162, 0.242494627833366, 0.242398381233215, 0.242302134633064, 0.242205873131752, 0.24210961163044, 0.242013335227966, 0.241917073726654, 0.241820856928825, 0.241724580526352, 0.241628289222717, 0.241532027721405, 0.241435796022415, 0.241339519619942, 0.241243302822113, 0.241146981716156, 0.241050750017166, 0.240954473614693, 0.240858241915703, 0.240762010216713, 0.240665718913078, 0.240569427609444, 0.240473181009293, 0.240376964211464, 0.240280672907829, 0.240184396505356, 0.240088135004044, 0.239991903305054, 0.239895656704903, 0.239799335598946, 0.239703118801117, 0.239606842398643, 0.239510610699654, 0.23941433429718, 0.239318072795868, 0.239221811294556, 0.239125564694405, 0.239029288291931, 0.238933056592941, 0.238836765289307, 0.238740518689156, 0.238644257187843, 0.238548010587692, 0.238455414772034, 0.238360494375229, 0.238264858722687, 0.238168478012085, 0.238071590662003, 0.237973913550377, 0.237875580787659, 0.237776458263397, 0.237676829099655, 0.237576469779015, 0.237475380301476, 0.237373620271683, 0.237271189689636, 0.237168043851852, 0.237064272165298, 0.236959785223007, 0.236854612827301, 0.236748769879341, 0.236642226576805, 0.236535042524338, 0.236427202820778, 0.236318573355675, 0.23620930314064, 0.236099377274513, 0.235988780856133, 0.235877484083176, 0.235765501856804, 0.235652819275856, 0.235539510846138, 0.235425472259521, 0.235310718417168, 0.235195353627205, 0.235079258680344, 0.234962612390518, 0.234845176339149, 0.234726965427399, 0.234608173370361, 0.234488755464554, 0.234368577599525, 0.234247654676437, 0.234126195311546, 0.234003990888596, 0.233881115913391, 0.233757466077805, 0.233633205294609, 0.233508318662643, 0.233382731676102, 0.233256489038467, 0.233129382133484, 0.233001738786697, 0.23287345468998, 0.232744440436363, 0.232614666223526, 0.232484295964241, 0.232353210449219, 0.232221469283104, 0.232089072465897, 0.231955900788307, 0.231822118163109, 0.231687635183334, 0.23155252635479, 0.231416642665863, 0.231280103325844, 0.231142893433571, 0.231005042791367, 0.230866402387619, 0.230727165937424, 0.230587258934975, 0.230446666479111, 0.230305358767509, 0.23016332089901, 0.230020701885223, 0.229877337813377, 0.229733392596245, 0.229588568210602, 0.229443237185478, 0.229297161102295, 0.229150414466858, 0.22900302708149, 0.228854820132256, 0.228706032037735, 0.228556573390961, 0.228406473994255, 0.228255644440651, 0.228104069828987, 0.227951839566231, 0.227798983454704, 0.227645337581635, 0.227491125464439, 0.227336168289185, 0.227180570363998, 0.227024257183075, 0.226867318153381, 0.226709604263306, 0.226551279425621, 0.226392298936844, 0.226232573390007, 0.226072117686272, 0.225911110639572, 0.225749298930168, 0.225556463003159, 0.225327625870705, 0.225098863244057, 0.224870130419731, 0.22464120388031, 0.224412232637405, 0.224183082580566, 0.223953932523727, 0.223724573850632, 0.223495423793793, 0.223265960812569, 0.223036289215088, 0.222806826233864, 0.222577303647995, 0.222347527742386, 0.222117513418198, 0.221887767314911, 0.221657693386078, 0.221427753567696, 0.221197605133057, 0.220967367291451, 0.2207370698452, 0.220506832003593, 0.220276281237602, 0.220045566558838, 0.219815105199814, 0.219584494829178, 0.21935361623764, 0.219122752547264, 0.21889191865921, 0.218660816550255, 0.218429729342461, 0.218198552727699, 0.21796715259552, 0.217736080288887, 0.217504575848579, 0.217273086309433, 0.217041462659836, 0.216809898614883, 0.216578096151352, 0.21634615957737, 0.216114357113838, 0.215882480144501, 0.215650230646133, 0.215418130159378, 0.215186029672623, 0.214953526854515, 0.214721262454987, 0.214488849043846, 0.214256182312965, 0.214023694396019, 0.213790953159332, 0.213558241724968, 0.213325262069702, 0.213092476129532, 0.21285942196846, 0.212626218795776, 0.212393179535866, 0.212159901857376, 0.211926460266113, 0.211693048477173, 0.211459621787071, 0.211225867271423, 0.210992276668549, 0.210758611559868, 0.210524633526802, 0.210290804505348, 0.210056826472282, 0.209822863340378, 0.209588631987572, 0.209354430437088, 0.209120139479637, 0.208885788917542, 0.208651334047318, 0.20841671526432, 0.208181902766228, 0.207947373390198, 0.207712695002556, 0.207477688789368, 0.207242712378502, 0.207007795572281, 0.206772580742836, 0.206537410616875, 0.206302121281624, 0.206066876649857, 0.205831423401833, 0.205595970153809, 0.2053602039814, 0.205124497413635, 0.204888895153999, 0.204653203487396, 0.204417109489441, 0.204181045293808, 0.203945174813271, 0.203708946704865, 0.203472703695297, 0.203236296772957, 0.202999904751778, 0.202763602137566, 0.202527046203613, 0.202307030558586, 0.202110096812248, 0.201914340257645, 0.201719745993614, 0.201526090502739, 0.201333686709404, 0.201142191886902, 0.200951740145683, 0.200762465596199, 0.200574353337288, 0.200387015938759, 0.200200915336609, 0.200016006827354, 0.199831858277321, 0.19964911043644, 0.199467316269875, 0.199286669492722, 0.199106827378273, 0.198928236961365, 0.198750719428062, 0.198574140667915, 0.198398888111115, 0.198224499821663, 0.198051124811172, 0.197879076004028, 0.197707965970039, 0.19753785431385, 0.197368770837784, 0.197201028466225, 0.197034031152725, 0.196868449449539, 0.196703568100929, 0.196540176868439, 0.196377396583557, 0.196215972304344, 0.196055546402931, 0.195896029472351, 0.195737957954407, 0.195580646395683, 0.195424422621727, 0.195269286632538, 0.19511541724205, 0.194962382316589, 0.194810450077057, 0.194659844040871, 0.194509938359261, 0.194361358880997, 0.194213673472404, 0.194067344069481, 0.193921729922295, 0.193777278065681, 0.193634182214737, 0.19349168241024, 0.193350747227669, 0.193210601806641, 0.19307154417038, 0.192933484911919, 0.192796528339386, 0.192660823464394, 0.19252598285675, 0.192392453551292, 0.192259550094604, 0.192128211259842, 0.191997736692429, 0.19186843931675, 0.191739961504936, 0.191612601280212, 0.191486567258835, 0.191361233592033, 0.191237226128578, 0.191114321351051, 0.190992414951324, 0.19087153673172, 0.190751731395721, 0.190632939338684, 0.190515235066414, 0.190398812294006, 0.190283223986626, 0.190168797969818, 0.190055415034294, 0.189943104982376, 0.189831972122192, 0.189721673727036, 0.189612731337547, 0.18950454890728, 0.189397782087326, 0.189291954040527, 0.189187109470367, 0.189083233475685, 0.188980519771576, 0.18887896835804, 0.18877837061882, 0.188678979873657, 0.188580498099327, 0.188483223319054, 0.188386991620064, 0.188291847705841, 0.188197612762451, 0.188104659318924, 0.188012719154358, 0.18793885409832, 0.187886133790016, 0.187833964824677, 0.187782675027847, 0.187731891870499, 0.18768185377121, 0.187632590532303, 0.187583938241005, 0.187536120414734, 0.187488794326782, 0.187442421913147, 0.187396451830864, 0.187351331114769, 0.187306925654411, 0.187263086438179, 0.187220185995102, 0.187177732586861, 0.18713615834713, 0.18709509074688, 0.187054961919785, 0.187015309929848, 0.186976313591003, 0.186938256025314, 0.186900720000267, 0.18686406314373, 0.186827808618546, 0.18679253757, 0.186757758259773, 0.186723619699478, 0.186690464615822, 0.186657786369324, 0.186625972390175, 0.186594635248184, 0.186564177274704, 0.186534255743027, 0.186505019664764, 0.186476707458496, 0.186448857188225, 0.186421915888786, 0.186395451426506, 0.18636991083622, 0.186344817280769, 0.186320662498474, 0.186297029256821, 0.186274021863937, 0.186251983046532, 0.186230346560478, 0.186209633946419, 0.186189472675323, 0.186170130968094, 0.186151415109634, 0.186133235692978, 0.18611603975296, 0.186099335551262, 0.18608346581459, 0.186068207025528, 0.186053693294525, 0.186039835214615, 0.18602654337883, 0.186014205217361, 0.186002388596535, 0.185991361737251, 0.185981005430222, 0.185971349477768, 0.185962304472923, 0.185954093933105, 0.185946449637413, 0.185939460992813, 0.185933321714401, 0.18592780828476, 0.1859230697155, 0.185918942093849, 0.185915499925613, 0.185912758111954, 0.185910686850548, 0.185909420251846, 0.18590871989727, 0.185908809304237, 0.185909494757652, 0.185911059379578, 0.185913071036339, 0.185915991663933, 0.18591944873333, 0.18592369556427, 0.185928642749786, 0.185934156179428, 0.185940638184547, 0.185947552323341, 0.185955330729485, 0.185963615775108, 0.185972690582275, 0.185982510447502, 0.185992896556854, 0.186004191637039, 0.186016038060188, 0.186028704047203, 0.186041846871376, 0.186055913567543, 0.186070501804352, 0.186085715889931, 0.186099395155907, 0.186101332306862, 0.186102971434593, 0.186104610562325, 0.186106041073799, 0.186107248067856, 0.186108380556107, 0.186109378933907, 0.186110228300095, 0.186110854148865, 0.186111435294151, 0.186111763119698, 0.186112061142921, 0.186112120747566, 0.186112090945244, 0.186111867427826, 0.186111569404602, 0.186111092567444, 0.186110392212868, 0.186109617352486, 0.186108663678169, 0.186107605695724, 0.186106383800507, 0.186105012893677, 0.186103492975235, 0.186101838946342, 0.186099961400032, 0.186098054051399, 0.186095967888832, 0.186093643307686, 0.186091303825378, 0.186088725924492, 0.186086013913155, 0.186083137989044, 0.186080202460289, 0.186076983809471, 0.186073705554008, 0.186070382595062, 0.186066716909409, 0.186062976717949, 0.1860591173172, 0.186055108904839, 0.186050921678543, 0.18604664504528, 0.186042204499245, 0.186037510633469, 0.186032727360725, 0.186027884483337, 0.186022862792015, 0.186017632484436, 0.186012297868729, 0.186006799340248, 0.186001151800156, 0.185995310544968, 0.185989499092102, 0.185983330011368, 0.18597711622715, 0.185970768332481, 0.185964211821556, 0.185957506299019, 0.185950711369514, 0.185943841934204, 0.185936644673347, 0.185929462313652, 0.185922011733055, 0.18591445684433, 0.185906693339348, 0.185898929834366, 0.185890957713127, 0.185882762074471, 0.185874536633492, 0.185866042971611, 0.185857474803925, 0.185848727822304, 0.185839891433716, 0.185830861330032, 0.185821652412415, 0.185812398791313, 0.185802862048149, 0.18579326570034, 0.185783505439758, 0.185773655772209, 0.185763537883759, 0.185753419995308, 0.185743063688278, 0.185732558369637, 0.185721874237061, 0.185711145401001, 0.185700163245201, 0.185689091682434, 0.185677871108055, 0.185666486620903, 0.185654982924461, 0.185643255710602, 0.185631513595581, 0.185619503259659, 0.185607388615608, 0.185595214366913, 0.185582771897316, 0.185570180416107, 0.185548305511475, 0.185523673892021, 0.185498401522636, 0.185472786426544, 0.185446605086327, 0.185419976711273, 0.185392886400223, 0.185365349054337, 0.185337260365486, 0.185308769345284, 0.185279756784439, 0.185250267386436, 0.185220241546631, 0.185189828276634, 0.185158893465996, 0.18512749671936, 0.185095608234406, 0.185063317418098, 0.185030460357666, 0.184997096657753, 0.184963420033455, 0.184929013252258, 0.184894323348999, 0.184859067201614, 0.184823423624039, 0.184787139296532, 0.184750497341156, 0.184713363647461, 0.184675857424736, 0.184637680649757, 0.184599190950394, 0.18456007540226, 0.184520557522774, 0.184480592608452, 0.184440076351166, 0.18439906835556, 0.184357643127441, 0.184315800666809, 0.184273317456245, 0.18423043191433, 0.184187158942223, 0.18414331972599, 0.184098973870277, 0.184054240584373, 0.184008970856667, 0.183963194489479, 0.183916941285133, 0.183870300650597, 0.183823123574257, 0.183775469660759, 0.183727338910103, 0.183678790926933, 0.183629617094994, 0.183580175042152, 0.183530062437057, 0.183479562401772, 0.183428481221199, 0.18337707221508, 0.183325111865997, 0.183272689580917, 0.183219850063324, 0.18316638469696, 0.183112531900406, 0.183058172464371, 0.183003425598145, 0.182947993278503, 0.182892248034477, 0.182835966348648, 0.182779356837273, 0.182722017168999, 0.182664453983307, 0.1826062053442, 0.182547584176064, 0.18248850107193, 0.182428881525993, 0.18236880004406, 0.182308197021484, 0.18224723637104, 0.182185679674149, 0.18212366104126, 0.182061269879341, 0.181998297572136, 0.181934922933578, 0.181870967149734, 0.181806579232216, 0.1817417293787, 0.181676402688026, 0.181610614061356, 0.181544244289398, 0.181477501988411, 0.181410223245621, 0.181342571973801, 0.181274324655533, 0.181205675005913, 0.181136518716812, 0.181066855788231, 0.180996656417847, 0.180926248431206, 0.180855065584183, 0.180783525109291, 0.18070213496685, 0.180620178580284, 0.18053787946701, 0.180455133318901, 0.180372074246407, 0.18028849363327, 0.180204689502716, 0.180120319128036, 0.180035755038261, 0.179950654506683, 0.179865270853043, 0.17977936565876, 0.179693266749382, 0.179606646299362, 0.179519698023796, 0.179432287812233, 0.179344519972801, 0.17925637960434, 0.179167911410332, 0.179078936576843, 0.17898964881897, 0.178899928927422, 0.178809881210327, 0.178719371557236, 0.178628474473953, 0.178537279367447, 0.178445622324944, 0.178353622555733, 0.178261175751686, 0.178168386220932, 0.178075209259987, 0.177981659770012, 0.177887663245201, 0.177793368697166, 0.177698582410812, 0.177603498101234, 0.177507936954498, 0.177412107586861, 0.177315786480904, 0.1772191375494, 0.177121996879578, 0.177024662494659, 0.176926791667938, 0.176828503608704, 0.176729932427406, 0.176630884408951, 0.176531568169594, 0.176431775093079, 0.176331594586372, 0.17623108625412, 0.176130145788193, 0.176028743386269, 0.175927072763443, 0.175824955105782, 0.17572246491909, 0.175619557499886, 0.175516307353973, 0.17541266977787, 0.175308659672737, 0.175204172730446, 0.175099417567253, 0.174994200468063, 0.174888551235199, 0.174782603979111, 0.174676224589348, 0.174569487571716, 0.174462378025055, 0.174354806542397, 0.174246951937675, 0.174138605594635, 0.174029886722565, 0.173920840024948, 0.173811346292496, 0.173701509833336, 0.17359122633934, 0.173480659723282, 0.173369571566582, 0.173258244991302, 0.173146367073059, 0.173034280538559, 0.172921612858772, 0.172808781266212, 0.172695323824883, 0.172581553459167, 0.17246749997139, 0.172352999448776, 0.172238111495972, 0.172122821211815, 0.172007188200951, 0.171891137957573, 0.171774625778198, 0.171657755970955, 0.171540603041649, 0.171422958374023, 0.171304985880852, 0.171186566352844, 0.171067804098129, 0.170948654413223, 0.170829132199287, 0.170709148049355, 0.170598343014717, 0.170495077967644, 0.170391470193863, 0.170287221670151, 0.170182749629021, 0.170077681541443, 0.169972151517868, 0.169866144657135, 0.169759660959244, 0.16965277493, 0.169545441865921, 0.1694375872612, 0.169329285621643, 0.169220596551895, 0.169111415743828, 0.169001892209053, 0.168891713023186, 0.168781206011772, 0.168670207262039, 0.168558672070503, 0.168446704745293, 0.168334290385246, 0.168221473693848, 0.168108150362968, 0.16799433529377, 0.167880073189735, 0.167765468358994, 0.167650401592255, 0.167534783482552, 0.167418718338013, 0.167302250862122, 0.167185217142105, 0.167067751288414, 0.166949853301048, 0.166831597685814, 0.166712716221809, 0.166593462228775, 0.166473731398582, 0.166353762149811, 0.166233062744141, 0.166111975908279, 0.165990352630615, 0.165868371725082, 0.165745884180069, 0.165622934699059, 0.165499582886696, 0.165375679731369, 0.165251433849335, 0.165126606822014, 0.165001481771469, 0.164875939488411, 0.164749726653099, 0.164623066782951, 0.164496138691902, 0.164368525147438, 0.164240568876266, 0.164112120866776, 0.163983255624771, 0.163853943347931, 0.163724139332771, 0.163593992590904, 0.163463339209557, 0.163332104682922, 0.163200423121452, 0.163068309426308, 0.162935763597488, 0.162802785634995, 0.162669256329536, 0.162535414099693, 0.162401109933853, 0.162266194820404, 0.162131071090698, 0.161995247006416, 0.161859109997749, 0.161722421646118, 0.161585196852684, 0.161447644233704, 0.161309629678726, 0.161171138286591, 0.161032155156136, 0.160892710089684, 0.16075287759304, 0.160612553358078, 0.160471826791763, 0.160330519080162, 0.16018895804882, 0.160046741366386, 0.159904047846794, 0.159761056303978, 0.159617513418198, 0.159473538398743, 0.159329012036324, 0.159184083342552, 0.159038811922073, 0.158892914652824, 0.158746734261513, 0.158600032329559, 0.158452853560448, 0.158305212855339, 0.158157035708427, 0.158005490899086, 0.157839953899384, 0.157673671841621, 0.157506853342056, 0.157339543104172, 0.157171711325645, 0.157003328204155, 0.15683451294899, 0.156664922833443, 0.156494945287704, 0.156324326992035, 0.156153082847595, 0.155981466174126, 0.155809178948402, 0.155636429786682, 0.155463084578514, 0.155289098620415, 0.155114755034447, 0.154939904808998, 0.154764294624329, 0.154588252305984, 0.154411658644676, 0.15423446893692, 0.154056683182716, 0.153878405690193, 0.153699725866318, 0.153520256280899, 0.153340250253677, 0.153159812092781, 0.152979031205177, 0.15279746055603, 0.152615278959274, 0.152432605624199, 0.152249440550804, 0.152065649628639, 0.151881366968155, 0.151696562767029, 0.151511088013649, 0.151325151324272, 0.151138678193092, 0.150951728224754, 0.150764182209969, 0.150575995445251, 0.150387302041054, 0.150198116898537, 0.150008320808411, 0.149817958474159, 0.149627029895782, 0.149435639381409, 0.14924368262291, 0.149051085114479, 0.148858204483986, 0.148664593696594, 0.148470520973206, 0.148275688290596, 0.148080483078957, 0.147884547710419, 0.147688254714012, 0.147491350769997, 0.147293865680695, 0.147095948457718, 0.146897405385971, 0.146698296070099, 0.146498709917068, 0.146298423409462, 0.146097838878632, 0.145896449685097, 0.145694613456726, 0.145492240786552, 0.145289272069931, 0.145085826516151, 0.144881725311279, 0.144677191972733, 0.144472032785416, 0.144266352057457, 0.144060224294662, 0.143853545188904, 0.143646121025085, 0.143438309431076, 0.143229842185974, 0.143020942807198, 0.142811372876167, 0.142601206898689, 0.142390593886375, 0.142179504036903, 0.1419677734375, 0.141755551099777, 0.141542807221413, 0.141329541802406, 0.141115635633469, 0.140901133418083, 0.140686109662056, 0.140470609068871, 0.140254467725754, 0.140037849545479, 0.139820635318756, 0.139602929353714, 0.139384657144547, 0.139165878295898, 0.138946488499641, 0.138707667589188, 0.138461530208588, 0.138215363025665, 0.137969687581062, 0.137724101543427, 0.137478709220886, 0.137233510613441, 0.136988446116447, 0.136744022369385, 0.136499360203743, 0.136255279183388, 0.136011049151421, 0.13576728105545, 0.135523676872253, 0.135280415415764, 0.135037183761597, 0.134794235229492, 0.134551838040352, 0.134309157729149, 0.134067162871361, 0.133824914693832, 0.13358336687088, 0.13334147632122, 0.133100286126137, 0.13285905122757, 0.132618218660355, 0.132377490401268, 0.132137149572372, 0.131896585226059, 0.131656795740128, 0.13141693174839, 0.131177455186844, 0.130938246846199, 0.130698978900909, 0.130460307002068, 0.130221545696259, 0.129983156919479, 0.129744932055473, 0.129506930708885, 0.129269018769264, 0.12903168797493, 0.128794118762016, 0.128557175397873, 0.12832011282444, 0.128083646297455, 0.127847447991371, 0.127610966563225, 0.12737512588501, 0.12713934481144, 0.126903846859932, 0.126668438315392, 0.126433402299881, 0.12619848549366, 0.125964000821114, 0.125729441642761, 0.125495463609695, 0.125261247158051, 0.125027626752853, 0.124794073402882, 0.124560795724392, 0.124327920377254, 0.124094985425472, 0.123862445354462, 0.123629912734032, 0.123397849500179, 0.123165793716908, 0.12293429672718, 0.122702538967133, 0.122471496462822, 0.122240170836449, 0.122009545564651, 0.121778920292854, 0.121548525989056, 0.121318534016609, 0.121088534593582, 0.120858922600746, 0.12062930315733, 0.120400093495846, 0.120171099901199, 0.119942344725132, 0.119713671505451, 0.119485311210155, 0.119257114827633, 0.11902929097414, 0.118801400065422, 0.118574135005474, 0.118347093462944, 0.118119828402996, 0.117893248796463, 0.117666535079479, 0.117440350353718, 0.11721409112215, 0.116988226771355, 0.116762518882751, 0.116537041962147, 0.116311639547348, 0.116086788475513, 0.115861937403679, 0.115637473762035, 0.115413405001163, 0.115198291838169, 0.115010336041451, 0.114822223782539, 0.114635661244392, 0.114449724555016, 0.114264883100986, 0.11408082395792, 0.113897070288658, 0.113714568316936, 0.11353300511837, 0.113352060317993, 0.113171897828579, 0.11299267411232, 0.112814381718636, 0.112637020647526, 0.112460292875767, 0.112284190952778, 0.112109176814556, 0.111934930086136, 0.111761629581451, 0.111588954925537, 0.1114167496562, 0.111246101558208, 0.111075766384602, 0.110906675457954, 0.110737897455692, 0.110570684075356, 0.110403940081596, 0.110237658023834, 0.110072784125805, 0.109908223152161, 0.109744898974895, 0.109582059085369, 0.109420448541641, 0.109259471297264, 0.10909927636385, 0.108939707279205, 0.108781225979328, 0.108623683452606, 0.108466759324074, 0.108310766518116, 0.108155727386475, 0.108001455664635, 0.107847958803177, 0.10769510269165, 0.107542864978313, 0.107392184436321, 0.107241958379745, 0.107092685997486, 0.106943719089031, 0.106796152889729, 0.106649219989777, 0.106503374874592, 0.106357529759407, 0.106213562190533, 0.106069900095463, 0.105927005410194, 0.105785526335239, 0.105643898248672, 0.105503983795643, 0.10536453127861, 0.105226010084152, 0.10508780926466, 0.104950860142708, 0.104814685881138, 0.104679755866528, 0.104545131325722, 0.104411460459232, 0.104278869926929, 0.104146756231785, 0.104015879333019, 0.103885322809219, 0.103755541145802, 0.103626854717731, 0.103499256074429, 0.103372290730476, 0.103245943784714, 0.103120371699333, 0.102996200323105, 0.102872349321842, 0.102749593555927, 0.102627299726009, 0.102506250143051, 0.102386154234409, 0.102266497910023, 0.102147959172726, 0.102029718458652, 0.1019127368927, 0.101796358823776, 0.101681247353554, 0.101566135883331, 0.101452730596066, 0.101339638233185, 0.101227641105652, 0.101116426289082, 0.101005837321281, 0.100896328687668, 0.10078776627779, 0.100679978728294, 0.100572504103184, 0.100491181015968, 0.100403763353825, 0.100316777825356, 0.100230231881142, 0.100143678486347, 0.100057877600193, 0.0999723374843597, 0.0998874232172966, 0.0998026132583618, 0.0997177883982658, 0.0996338874101639, 0.0995502471923828, 0.0994669049978256, 0.099383682012558, 0.0993010774254799, 0.0992188975214958, 0.0991369932889938, 0.0990555360913277, 0.0989742279052734, 0.0988933369517326, 0.0988130569458008, 0.0987329110503197, 0.0986533388495445, 0.0985737591981888, 0.0984947830438614, 0.098416231572628, 0.0983381196856499, 0.0982600003480911, 0.0981824472546577, 0.0981053709983826, 0.0980285555124283, 0.0979521945118904, 0.0978759527206421, 0.0978001579642296, 0.0977249592542648, 0.0976500436663628, 0.0975754261016846, 0.0975010693073273, 0.0974271595478058, 0.097353883087635, 0.0972807034850121, 0.0972076430916786, 0.0971352159976959, 0.0970631986856461, 0.0969914719462395, 0.0969203487038612, 0.0968490317463875, 0.0967786461114883, 0.0967083647847176, 0.0966385453939438, 0.096568837761879, 0.0964997336268425, 0.0964309126138687, 0.0963625460863113, 0.0962946116924286, 0.0962266474962234, 0.0961594507098198, 0.096092514693737, 0.0960260480642319, 0.0959598571062088, 0.0958936139941216, 0.095828153192997, 0.095763124525547, 0.0956983789801598, 0.0956337675452232, 0.0955697447061539, 0.0955061763525009, 0.09544288367033, 0.0953800231218338, 0.0953171625733376, 0.0952550396323204, 0.0951932072639465, 0.0951318144798279, 0.0950706824660301, 0.0950097143650055, 0.094949334859848, 0.094889372587204, 0.094829723238945, 0.0947704985737801, 0.0947112664580345, 0.0946527794003487, 0.0945945680141449, 0.0945368111133575, 0.0944790169596672, 0.0944219902157784, 0.094365231692791, 0.0943089127540588, 0.0942527428269386, 0.094197154045105, 0.0941418409347534, 0.0940868407487869, 0.094032421708107, 0.0939782857894897, 0.0939241200685501, 0.093870721757412, 0.0938177704811096, 0.093764916062355, 0.0937123671174049, 0.0936604365706444, 0.0936087518930435, 0.0935438424348831, 0.0934735834598541, 0.0934031829237938, 0.0933327004313469, 0.0932621657848358, 0.0931914746761322, 0.0931207686662674, 0.0930498987436295, 0.0929789319634438, 0.0929079279303551, 0.092836782336235, 0.0927656218409538, 0.0926942676305771, 0.0926228612661362, 0.0925513952970505, 0.0924797728657722, 0.0924080535769463, 0.0923363119363785, 0.0922644212841988, 0.0921924933791161, 0.092120386660099, 0.0920482203364372, 0.0919760018587112, 0.0919036492705345, 0.0918312221765518, 0.0917586833238602, 0.0916860550642014, 0.0916133746504784, 0.091540552675724, 0.0914676710963249, 0.0913946703076363, 0.0913215503096581, 0.0912483781576157, 0.0911750867962837, 0.0911017209291458, 0.0910282507538795, 0.0909546762704849, 0.0908810570836067, 0.090807281434536, 0.0907334685325623, 0.0906595215201378, 0.0905854925513268, 0.0905113890767097, 0.0904371812939644, 0.0903628766536713, 0.0902884751558304, 0.0902139618992805, 0.0901393815875053, 0.0900646895170212, 0.0899899527430534, 0.089915044605732, 0.0898400768637657, 0.0897650346159935, 0.0896898657083511, 0.0896146669983864, 0.0895393118262291, 0.0894638523459435, 0.0893883779644966, 0.0893127247691154, 0.0892370641231537, 0.0891612321138382, 0.0890853032469749, 0.0890093594789505, 0.0889332368969917, 0.0888570845127106, 0.0887807980179787, 0.0887043997645378, 0.0886279940605164, 0.0885514244437218, 0.0884747505187988, 0.0883980467915535, 0.0883211940526962, 0.088244266808033, 0.0881672576069832, 0.0880901142954826, 0.0880129560828209, 0.0879356041550636, 0.0878582373261452, 0.087780736386776, 0.087703138589859, 0.0876254737377167, 0.0875477194786072, 0.0874698534607887, 0.0873918905854225, 0.0873138383030891, 0.0872356966137886, 0.0871574580669403, 0.0870791524648666, 0.0870006904006004, 0.0869221761822701, 0.0868435949087143, 0.0867648720741272, 0.0866860970854759, 0.0866071581840515, 0.0865281820297241, 0.0864491239190102, 0.0863699242472649, 0.0862906873226166, 0.086211308836937, 0.0861318334937096, 0.0860531404614449, 0.0859753787517548, 0.085897371172905, 0.0858191847801208, 0.0857407972216606, 0.0856622382998466, 0.0855833292007446, 0.0855043679475784, 0.0854251235723495, 0.0853455513715744, 0.0852659195661545, 0.0851859971880913, 0.0851059108972549, 0.0850255861878395, 0.0849450305104256, 0.0848643332719803, 0.0847833231091499, 0.0847021862864494, 0.0846208035945892, 0.0845391601324081, 0.0844573676586151, 0.0843753218650818, 0.08429304510355, 0.0842105820775032, 0.0841279551386833, 0.0840450823307037, 0.0839618891477585, 0.0838785693049431, 0.0837951153516769, 0.0837113484740257, 0.0836273357272148, 0.0835431814193726, 0.0834588333964348, 0.0833742469549179, 0.0832893922924995, 0.0832043588161469, 0.0831192135810852, 0.0830336436629295, 0.0829479768872261, 0.0828621089458466, 0.0827761068940163, 0.0826896876096725, 0.0826031789183617, 0.0825164839625359, 0.0824294835329056, 0.0823423564434052, 0.0822549760341644, 0.082167275249958, 0.0820795744657516, 0.0819915160536766, 0.0819033682346344, 0.0818147733807564, 0.0817262083292007, 0.0816373378038406, 0.0815482437610626, 0.0814588889479637, 0.0813693925738335, 0.0812796652317047, 0.0811896771192551, 0.0810995101928711, 0.0810092389583588, 0.0809185579419136, 0.0808277055621147, 0.0807367786765099, 0.0806455612182617, 0.0805540606379509, 0.0804624184966087, 0.0803704783320427, 0.0802784562110901, 0.0801861360669136, 0.0800936073064804, 0.0800009369850159, 0.0799079462885857, 0.0798148140311241, 0.0797214657068253, 0.0796278342604637, 0.0795340910553932, 0.0794400125741959, 0.0793458297848701, 0.0792513489723206, 0.0791566893458366, 0.0790618434548378, 0.0789667069911957, 0.0788714289665222, 0.0787760019302368, 0.078680232167244, 0.0785842388868332, 0.0784881189465523, 0.0783918350934982, 0.0782951936125755, 0.0781983658671379, 0.0781013891100883, 0.0780042111873627, 0.0779067277908325, 0.0778090581297874, 0.0777112022042274, 0.0776131376624107, 0.0775148198008537, 0.0774163603782654, 0.0773176252841949, 0.0772265568375587, 0.0771168097853661, 0.0770068168640137, 0.0768966898322105, 0.0767864510416985, 0.0766760110855103, 0.0765654966235161, 0.0764546394348145, 0.0763438120484352, 0.0762327387928963, 0.076121523976326, 0.0760100707411766, 0.0758985579013824, 0.0757868364453316, 0.075674943625927, 0.0755629166960716, 0.0754508301615715, 0.0753383859992027, 0.0752258524298668, 0.0751132071018219, 0.0750004202127457, 0.0748873427510262, 0.0747742354869843, 0.0746609047055244, 0.0745474398136139, 0.0744338110089302, 0.0743200108408928, 0.0742060914635658, 0.0740919411182404, 0.0739776194095612, 0.0738632380962372, 0.0737485587596893, 0.0736339017748833, 0.0735189914703369, 0.0734038800001144, 0.0732886046171188, 0.0731732547283173, 0.0730576664209366, 0.0729419216513634, 0.0728260278701782, 0.0727100744843483, 0.0725938826799393, 0.0724774375557899, 0.0723609179258347, 0.0722443088889122, 0.0721274390816689, 0.0720103830099106, 0.0718932151794434, 0.0717759355902672, 0.0716584399342537, 0.0715407505631447, 0.0714230090379715, 0.0713049918413162, 0.0711868554353714, 0.07106863707304, 0.0709501579403877, 0.0708315521478653, 0.0707127675414085, 0.0705938637256622, 0.0704747140407562, 0.0703554973006248, 0.0702360868453979, 0.0701165497303009, 0.0699967443943024, 0.0698769465088844, 0.0697568953037262, 0.0696365833282471, 0.0695162415504456, 0.0693957582116127, 0.0692750662565231, 0.0691541731357574, 0.0690331310033798, 0.0689120665192604, 0.0687906518578529, 0.0686691030859947, 0.0685475319623947, 0.0684257224202156, 0.0683036670088768, 0.0681815519928932, 0.0680592283606529, 0.0679368525743484, 0.0678141862154007, 0.067691370844841, 0.0675683915615082, 0.0674453899264336, 0.0673220530152321, 0.0671987384557724, 0.0670750737190247, 0.0669514015316963, 0.0668274834752083, 0.0667033791542053, 0.066579133272171, 0.0664548426866531, 0.0663302391767502, 0.0662054792046547, 0.0660806149244308, 0.065955676138401, 0.0658305436372757, 0.0657050907611847, 0.0655796453356743, 0.0654448121786118, 0.0653165951371193, 0.0651886835694313, 0.0650606602430344, 0.0649330392479897, 0.0648055449128151, 0.0646781846880913, 0.0645509138703346, 0.0644238516688347, 0.064297080039978, 0.0641701593995094, 0.0640436783432961, 0.063917264342308, 0.0637909173965454, 0.0636648535728455, 0.0635389685630798, 0.063413105905056, 0.0632875561714172, 0.063162162899971, 0.0630369037389755, 0.0629116371273994, 0.0627867430448532, 0.0626619756221771, 0.0625372156500816, 0.06241275370121, 0.062288410961628, 0.062164168804884, 0.062040202319622, 0.0619164668023586, 0.0617926195263863, 0.0616690963506699, 0.061545867472887, 0.0614226050674915, 0.0612994953989983, 0.0611766166985035, 0.0610539466142654, 0.060931283980608, 0.0608088932931423, 0.060686718672514, 0.0605645626783371, 0.0604426823556423, 0.0603209510445595, 0.0601992085576057, 0.0600778311491013, 0.0599566102027893, 0.0598353669047356, 0.0597144216299057, 0.0595937147736549, 0.0594730563461781, 0.0593524612486362, 0.0592322535812855, 0.0591120980679989, 0.0589920282363892, 0.0588722303509712, 0.0587524995207787, 0.0586329437792301, 0.0585136488080025, 0.0583944320678711, 0.0582752898335457, 0.0581565052270889, 0.0580378100275993, 0.0579193085432053, 0.0578007996082306, 0.057682603597641, 0.0575646162033081, 0.0574466176331043, 0.0573289282619953, 0.0572113692760468, 0.057093795388937, 0.0569766089320183, 0.0568594746291637, 0.0567424967885017, 0.0566257238388062, 0.0565091073513031, 0.0563927106559277, 0.0562762916088104, 0.0561601854860783, 0.0560441985726357, 0.0559282973408699, 0.0558126904070377, 0.0556972213089466, 0.055581733584404, 0.0554666370153427, 0.0553515888750553, 0.0552366934716702, 0.0551220141351223, 0.0550074763596058, 0.0548931732773781, 0.054778840392828, 0.0546648055315018, 0.0545509234070778, 0.054437093436718, 0.0543235875666142, 0.0542102083563805, 0.0540968142449856, 0.0539837256073952, 0.0538708530366421, 0.053757943212986, 0.0536453761160374, 0.0535329915583134, 0.0534249804913998, 0.0533309541642666, 0.0532370880246162, 0.053143460303545, 0.0530497506260872, 0.0529564246535301, 0.0528632700443268, 0.052770096808672, 0.0526773259043694, 0.052584633231163, 0.052492082118988, 0.0523997098207474, 0.05230762809515, 0.052215714007616, 0.0521237216889858, 0.0520321875810623, 0.0519407540559769, 0.0518493726849556, 0.0517582409083843, 0.0516674183309078, 0.0515765175223351, 0.0514859259128571, 0.0513955652713776, 0.0513052083551884, 0.0512151643633842, 0.0511252768337727, 0.0510354600846767, 0.0509459711611271, 0.0508565492928028, 0.0507674515247345, 0.0506782568991184, 0.0505894497036934, 0.0505008213222027, 0.0504121705889702, 0.050323847681284, 0.0502357520163059, 0.0501476638019085, 0.0500598810613155, 0.0499722436070442, 0.0498846955597401, 0.0497974678874016, 0.0497103855013847, 0.0496234521269798, 0.0495365411043167, 0.0494499951601028, 0.0493636280298233, 0.0492772422730923, 0.049191165715456, 0.0491053462028503, 0.0490195080637932, 0.0489339828491211, 0.0488486252725124, 0.0487633310258389, 0.0486783646047115, 0.0485935397446156, 0.0485088787972927, 0.0484242141246796, 0.0483399480581284, 0.0482557415962219, 0.0481717176735401, 0.0480878986418247, 0.0480043329298496, 0.0479206889867783, 0.0478374995291233, 0.0477544069290161, 0.0476713702082634, 0.0475886575877666, 0.0475061051547527, 0.0474236942827702, 0.0473413057625294, 0.0472592860460281, 0.0471774302423, 0.0470955818891525, 0.0470140390098095, 0.0469326451420784, 0.0468513406813145, 0.046770341694355, 0.0466895811259747, 0.0466087386012077, 0.0465282835066319, 0.0464479997754097, 0.0463676936924458, 0.0462877005338669, 0.0462079644203186, 0.0461282841861248, 0.0460487827658653, 0.0459694899618626, 0.0458903722465038, 0.0458113253116608, 0.0457325950264931, 0.0456540025770664, 0.0455755032598972, 0.0454972386360168, 0.045419204980135, 0.0453411750495434, 0.0452634431421757, 0.0451859645545483, 0.0451086275279522, 0.0450312867760658, 0.0449542850255966, 0.0448820479214191, 0.0447952151298523, 0.0447083227336407, 0.0446215160191059, 0.0445347279310226, 0.0444479733705521, 0.04436120018363, 0.0442744940519333, 0.0441878288984299, 0.0441011749207973, 0.0440145619213581, 0.0439279265701771, 0.0438413843512535, 0.043754804879427, 0.0436682961881161, 0.0435817949473858, 0.04349534958601, 0.0434089042246342, 0.0433224961161613, 0.0432360544800758, 0.0431497432291508, 0.0430633760988712, 0.0429770797491074, 0.0428907983005047, 0.042804516851902, 0.0427183173596859, 0.0426320992410183, 0.042545922100544, 0.0424597784876823, 0.042373675853014, 0.0422875247895718, 0.0422015078365803, 0.0421154350042343, 0.0420294776558876, 0.0419434569776058, 0.0418575033545494, 0.0417715609073639, 0.041685663163662, 0.0415997728705406, 0.0415139086544514, 0.041428092867136, 0.0413422808051109, 0.04125652089715, 0.041170746088028, 0.0410850495100021, 0.0409993380308151, 0.0409136936068535, 0.0408280491828918, 0.0407424196600914, 0.040656853467226, 0.0405713059008121, 0.0404857359826565, 0.0404002666473389, 0.0403147786855698, 0.040229320526123, 0.040143895894289, 0.0400584787130356, 0.0399731285870075, 0.0398877561092377, 0.0398024320602417, 0.0397171527147293, 0.039631899446249, 0.0395466275513172, 0.0394614450633526, 0.0393762327730656, 0.0392911322414875, 0.0392059534788132, 0.0391208529472351, 0.0390357971191406, 0.0389507338404655, 0.0388657003641129, 0.0387806855142117, 0.0386957265436649, 0.0386107638478279, 0.0385258607566357, 0.0384409613907337, 0.0383561253547668, 0.038271252065897, 0.038186464458704, 0.0381016731262207, 0.038016926497221, 0.0379321873188019, 0.0378475040197372, 0.0377627946436405, 0.0376781858503819, 0.0375935100018978, 0.037508949637413, 0.0374243669211864, 0.0373397879302502, 0.0372553169727325, 0.0371707826852798, 0.0370863564312458, 0.0370018891990185, 0.0369175001978874, 0.0368330851197243, 0.036748755723238, 0.0366644077003002, 0.0365801341831684, 0.0364958420395851, 0.0364116244018078, 0.036319226026535, 0.0362297706305981, 0.0361405462026596, 0.036051519215107, 0.035962700843811, 0.035873968154192, 0.0357856824994087, 0.0356974340975285, 0.0356093011796474, 0.0355214215815067, 0.0354336239397526, 0.0353462286293507, 0.0352587811648846, 0.0351717434823513, 0.0350849144160748, 0.034997995942831, 0.0349115431308746, 0.0348250456154346, 0.03473886474967, 0.0346527621150017, 0.0345669873058796, 0.0344812944531441, 0.0343958921730518, 0.0343106836080551, 0.0342255160212517, 0.0341407619416714, 0.0340558439493179, 0.0339714772999287, 0.0338870100677013, 0.0338030122220516, 0.0337190553545952, 0.033635251224041, 0.0335516817867756, 0.0334682464599609, 0.0333850271999836, 0.0333019308745861, 0.0332191810011864, 0.0331366062164307, 0.0330540686845779, 0.0329718627035618, 0.0328896977007389, 0.0328078456223011, 0.0327260307967663, 0.0326445698738098, 0.0325633771717548, 0.0324821099638939, 0.032401192933321, 0.0323203541338444, 0.0322398282587528, 0.032159261405468, 0.0320791602134705, 0.0319990627467632, 0.0319192185997963, 0.0318397618830204, 0.0317600928246975, 0.0316809304058552, 0.0316017307341099, 0.0315229222178459, 0.0314441099762917, 0.0313656479120255, 0.0312873423099518, 0.0312091745436192, 0.0311312396079302, 0.031053364276886, 0.030975878238678, 0.030898354947567, 0.030821219086647, 0.0307442024350166, 0.0306672994047403, 0.0305907316505909, 0.0305141229182482, 0.0304378867149353, 0.0303617659956217, 0.0302858967334032, 0.0302101857960224, 0.0301346313208342, 0.0300593674182892, 0.0299840848892927, 0.0299091730266809, 0.0298342611640692, 0.0297597795724869, 0.0296852588653564, 0.0296110864728689, 0.0295371506363153, 0.0294632129371166, 0.0293896086513996, 0.0293160416185856, 0.0292428061366081, 0.0291696097701788, 0.0290967840701342, 0.0290241166949272, 0.0289515219628811, 0.0288792066276073, 0.0288069825619459, 0.0287350546568632, 0.0286631658673286, 0.0285916086286306, 0.0285203233361244, 0.0284489579498768, 0.0283779464662075, 0.028306232765317, 0.0282440725713968, 0.0281821470707655, 0.0281205326318741, 0.0280589181929827, 0.0279979296028614, 0.0279372502118349, 0.0278767291456461, 0.0278165172785521, 0.0277565401047468, 0.0276969540864229, 0.0276376027613878, 0.0275786388665438, 0.0275199115276337, 0.027461338788271, 0.027403311803937, 0.0273452866822481, 0.0272876489907503, 0.0272301696240902, 0.0271732341498137, 0.0271165333688259, 0.0270599890500307, 0.0270039141178131, 0.0269479136914015, 0.0268923826515675, 0.0268370881676674, 0.0267821028828621, 0.0267274267971516, 0.0266727562993765, 0.0266186278313398, 0.026564659550786, 0.0265111550688744, 0.0264577325433493, 0.0264049302786589, 0.0263519734144211, 0.0262997169047594, 0.0262476187199354, 0.0261956751346588, 0.0261442009359598, 0.0260928031057119, 0.0260418746620417, 0.0259910225868225, 0.0259405616670847, 0.0258904900401831, 0.0258406531065702, 0.0257910490036011, 0.0257417596876621, 0.0256928578019142, 0.0256441123783588, 0.0255956780165434, 0.0255476366728544, 0.0254996698349714, 0.0254523288458586, 0.0254048313945532, 0.0253578796982765, 0.0253111608326435, 0.0252647548913956, 0.0252185855060816, 0.0251728799194098, 0.0251273326575756, 0.0250820964574814, 0.025037094950676, 0.0249924045056105, 0.0249481834471226, 0.0249038077890873, 0.0248601287603378, 0.0248167682439089, 0.0247733257710934, 0.0247303508222103, 0.0246876124292612, 0.0246453396975994, 0.0246031451970339, 0.0245613399893045, 0.024520006030798, 0.0244787465780973, 0.0244377236813307, 0.0243970882147551, 0.0243567675352097, 0.0243165213614702, 0.0242768246680498, 0.0242375172674656, 0.0241980515420437, 0.0241591334342957, 0.0241204500198364, 0.0240821540355682, 0.0240440964698792, 0.0240063443779945, 0.0239687524735928, 0.0239316299557686, 0.0238948166370392, 0.0238580834120512, 0.0238218158483505, 0.023785550147295, 0.0237497501075268, 0.0237142629921436, 0.0236791670322418, 0.0236443821340799, 0.0236096754670143, 0.0235752817243338, 0.0235412772744894, 0.0235189516097307, 0.0234902873635292, 0.0234618540853262, 0.0234334878623486, 0.0234051998704672, 0.023376977071166, 0.0233489032834768, 0.023321058601141, 0.0232932884246111, 0.0232655871659517, 0.0232381150126457, 0.0232107099145651, 0.0231833793222904, 0.0231562778353691, 0.0231292471289635, 0.0231022760272026, 0.0230754669755697, 0.0230488013476133, 0.0230221338570118, 0.0229956097900867, 0.0229692384600639, 0.0229430980980396, 0.0229170229285955, 0.0228910222649574, 0.0228651743382215, 0.0228394716978073, 0.022813918069005, 0.0227883495390415, 0.022763017565012, 0.0227378364652395, 0.0227127280086279, 0.0226876083761454, 0.0226626377552748, 0.0226378943771124, 0.0226132236421108, 0.0225887037813663, 0.0225643310695887, 0.0225401110947132, 0.0225158799439669, 0.022491792216897, 0.0224679410457611, 0.0224441587924957, 0.0224202945828438, 0.0223968923091888, 0.0223734751343727, 0.0223499778658152, 0.0223267842084169, 0.0223036725074053, 0.0222807787358761, 0.0222578793764114, 0.022235207259655, 0.0222126040607691, 0.0221901517361403, 0.0221677739173174, 0.0221455413848162, 0.022123459726572, 0.0221012961119413, 0.0220794305205345, 0.0220577213913202, 0.0220360830426216, 0.0220145136117935, 0.0219931732863188, 0.0219719000160694, 0.0219506975263357, 0.0219296533614397, 0.0219087451696396, 0.0218879953026772, 0.0218673162162304, 0.0218467079102993, 0.0218261703848839, 0.021805863827467, 0.0217856205999851, 0.0217656120657921, 0.0217456724494696, 0.021725881844759, 0.021706085652113, 0.0216865111142397, 0.0216670967638493, 0.0216477382928133, 0.0216284655034542, 0.021609416231513, 0.0215904340147972, 0.0215714480727911, 0.0215526074171066, 0.0215340033173561, 0.0215155407786369, 0.0214971490204334, 0.0214788261801004, 0.0214607417583466, 0.0214427169412374, 0.0214247778058052, 0.0214070547372103, 0.021389402449131, 0.021371902897954, 0.0213543921709061, 0.0213371179997921, 0.0213198326528072, 0.0213026963174343, 0.0212857853621244, 0.0212689489126205, 0.0212510824203491, 0.0212350226938725, 0.0212186221033335, 0.0212021488696337, 0.0211854334920645, 0.021168552339077, 0.0211515109986067, 0.0211343914270401, 0.0211170222610235, 0.0210995730012655, 0.0210818778723478, 0.021064106374979, 0.0210460890084505, 0.0210279803723097, 0.021009648218751, 0.0209912117570639, 0.0209727808833122, 0.0209539532661438, 0.0209350343793631, 0.0209159534424543, 0.0208966415375471, 0.0208772365003824, 0.0208576712757349, 0.0208379421383142, 0.0208180546760559, 0.0207980014383793, 0.0207776986062527, 0.0207573231309652, 0.0207367800176144, 0.0207160729914904, 0.0206953678280115, 0.0206743329763412, 0.0206531397998333, 0.0206317938864231, 0.0206102728843689, 0.0205885916948318, 0.0205667484551668, 0.0205448158085346, 0.0205226521939039, 0.0205003190785646, 0.0204778984189034, 0.0204552467912436, 0.02043242380023, 0.0204095244407654, 0.0203865375369787, 0.0203633047640324, 0.0203398391604424, 0.0203162785619497, 0.0202924869954586, 0.0202686078846455, 0.0202445648610592, 0.0202202741056681, 0.0201959107071161, 0.0201713014394045, 0.020146606490016, 0.0201216768473387, 0.0200966577976942, 0.0200714729726315, 0.0200461335480213, 0.020020630210638, 0.0199950356036425, 0.0199692025780678, 0.0199432112276554, 0.0199170522391796, 0.0198907274752855, 0.0198642425239086, 0.0198376048356295, 0.0198108721524477, 0.0197839010506868, 0.0197567660361528, 0.0197294726967812, 0.0197020154446363, 0.0196744725108147, 0.0196468438953161, 0.0196188986301422, 0.0195907820016146, 0.0195625983178616, 0.0195341557264328, 0.0195055603981018, 0.0194768793880939, 0.0194480307400227, 0.0194189436733723, 0.0193897020071745, 0.0193602908402681, 0.0193307921290398, 0.0193010587245226, 0.0192712359130383, 0.0192414149641991, 0.019211258739233, 0.0191808845847845, 0.0191504023969173, 0.0191197711974382, 0.0190889723598957, 0.0190579351037741, 0.019026817753911, 0.0189955327659845, 0.0189640838652849, 0.0189324766397476, 0.018900703638792, 0.018868762999773, 0.0188251230865717, 0.0187801215797663, 0.0187350641936064, 0.0186897478997707, 0.018644142895937, 0.0185982845723629, 0.018552266061306, 0.0185060575604439, 0.0184597093611956, 0.0184130109846592, 0.0183662958443165, 0.0183192659169436, 0.0182720012962818, 0.0182246789336205, 0.018177043646574, 0.0181292556226254, 0.0180813875049353, 0.0180332269519567, 0.0179847329854965, 0.0179361663758755, 0.0178874004632235, 0.0178383234888315, 0.0177891496568918, 0.0177397783845663, 0.017690097913146, 0.0176403000950813, 0.0175903458148241, 0.0175401195883751, 0.0174897164106369, 0.0174390394240618, 0.0173882488161325, 0.0173373576253653, 0.0172861739993095, 0.0172347575426102, 0.0171831268817186, 0.0171313397586346, 0.0170793198049068, 0.0170270632952452, 0.0169746540486813, 0.0169220473617315, 0.01686916872859, 0.016816133633256, 0.0167629811912775, 0.0167095176875591, 0.0166558977216482, 0.0166023168712854, 0.0165482684969902, 0.0164939854294062, 0.0164396241307259, 0.0163849908858538, 0.016330162063241, 0.0162751376628876, 0.0162199568003416, 0.0161644276231527, 0.0161088574677706, 0.0160530544817448, 0.015996977686882, 0.0159407835453749, 0.0158845521509647, 0.015827851369977, 0.0157710332423449, 0.0157140605151653, 0.0156568512320518, 0.0155993709340692, 0.0155417732894421, 0.0154839418828487, 0.0154258375987411, 0.0153676168993115, 0.0153091615065932, 0.0152505105361342, 0.0151917049661279, 0.0151327028870583, 0.0150734288617969, 0.0150139601901174, 0.0149544896557927, 0.0148945916444063, 0.0148346535861492, 0.0147744053974748, 0.0147139225155115, 0.0146533213555813, 0.0145924873650074, 0.0145314196124673, 0.0144702345132828, 0.0144087364897132, 0.0143471620976925, 0.0142852747812867, 0.0142232710495591, 0.0141611490398645, 0.0140986768528819, 0.0140360109508038, 0.0139732258394361, 0.0139101687818766, 0.0138468779623508, 0.0137834697961807, 0.0137197505682707, 0.0136559521779418, 0.0135919209569693, 0.0135276159271598, 0.0134631153196096, 0.0133984992280602, 0.0133316209539771, 0.0132606467232108, 0.0131897907704115, 0.013118895702064, 0.0130482343956828, 0.0129778459668159, 0.0129073020070791, 0.0128371082246304, 0.0127670709043741, 0.0126972692087293, 0.0126275820657611, 0.0125577012076974, 0.012488248758018, 0.0124189117923379, 0.0123496558517218, 0.0122806699946523, 0.0122116468846798, 0.0121430521830916, 0.0120744202286005, 0.0120057463645935, 0.0119374254718423, 0.0118691045790911, 0.0118009001016617, 0.0117329284548759, 0.0116650750860572, 0.0115976892411709, 0.0115300314500928, 0.0114625673741102, 0.0113953379914165, 0.0113281859084964, 0.0112609965726733, 0.011194234713912, 0.0111275902017951, 0.0110613349825144, 0.0109944175928831, 0.0109284361824393, 0.0108623364940286, 0.0107963941991329, 0.0107304519042373, 0.0106646651402116, 0.0105992285534739, 0.0105338711291552, 0.0104682799428701, 0.010403310880065, 0.0103382654488087, 0.010273571126163, 0.0102085256949067, 0.0101439850404859, 0.0100795645266771, 0.010015063919127, 0.00995087623596191, 0.00988723430782557, 0.00982335861772299, 0.00975948385894299, 0.00969587918370962, 0.00963235553354025, 0.00956910289824009, 0.00950577389448881, 0.00944271683692932, 0.00937997177243233, 0.0093171875923872, 0.00925459712743759, 0.0091918520629406, 0.00912969280034304, 0.00906749442219734, 0.00900521595031023, 0.00894336868077517, 0.00888175424188375, 0.00881994515657425, 0.00875860452651978, 0.00869722384959459, 0.00863603875041008, 0.00857485458254814, 0.00851378589868546, 0.00845310743898153, 0.00839258544147015, 0.00833214074373245, 0.00827130675315857, 0.00821121316403151, 0.00815131515264511, 0.00809129979461432, 0.00803120713680983, 0.00797158107161522, 0.00791222881525755, 0.00785279832780361, 0.00779332919046283, 0.00773432804271579, 0.00767536554485559, 0.00761655950918794, 0.00755786988884211, 0.00749937538057566, 0.00744103733450174, 0.00738250371068716, 0.00732435937970877, 0.00726652890443802, 0.00720877479761839, 0.0071509825065732, 0.00709330709651113, 0.00703590409830213, 0.00697877490893006, 0.00692971749231219, 0.00688596395775676, 0.00684267794713378, 0.00679962569847703, 0.00675696413964033, 0.00671430258080363, 0.00667249830439687, 0.00663077225908637, 0.00658943597227335, 0.00654841167852283, 0.00650785584002733, 0.00646761152893305, 0.00642783520743251, 0.00638798112049699, 0.00634890655055642, 0.00630967691540718, 0.00627122586593032, 0.00623300997540355, 0.00619510561227798, 0.00615774700418115, 0.00612031063064933, 0.00608365423977375, 0.00604738760739565, 0.00601104367524385, 0.00597524456679821, 0.0059399139136076, 0.00590481702238321, 0.00587011082097888, 0.00583571614697576, 0.00580155476927757, 0.00576817383989692, 0.00573448138311505, 0.00570149067789316, 0.0056690457277, 0.00563675677403808, 0.00560462428256869, 0.00557311484590173, 0.0055417618714273, 0.00551103288307786, 0.00548022519797087, 0.00545012066140771, 0.00542048318311572, 0.00539108039811254, 0.00536144245415926, 0.00533274142071605, 0.0053044306114316, 0.0052763526327908, 0.00524835381656885, 0.0052209785208106, 0.00519399298354983, 0.00516731943935156, 0.00514080189168453, 0.00511467456817627, 0.00508901523426175, 0.00506382388994098, 0.00503855384886265, 0.00501390779390931, 0.00498980889096856, 0.00496563082560897, 0.00494215497747064, 0.00491883559152484, 0.00489606149494648, 0.00487352116033435, 0.00485105998814106, 0.00482953386381269, 0.00480792997404933, 0.00478655938059092, 0.0047659701667726, 0.0047454577870667, 0.00472525740042329, 0.00470552546903491, 0.00468579353764653, 0.00466684112325311, 0.00464827846735716, 0.00462948251515627, 0.00461170030757785, 0.00459407409653068, 0.00457652611657977, 0.00455967942252755, 0.00454291049391031, 0.0045268451794982, 0.00451077800244093, 0.00449502374976873, 0.00447989301756024, 0.00446507474407554, 0.00445056799799204, 0.00443590525537729, 0.00442217849195004, 0.00440876372158527, 0.00439558317884803, 0.00438247993588448, 0.00437015760689974, 0.00435806903988123, 0.00434636976569891, 0.0043345931917429, 0.00432351790368557, 0.00431298883631825, 0.00430261576548219, 0.00429255468770862, 0.00428280560299754, 0.0042748311534524, 0.00427061971276999, 0.00426660291850567, 0.00426246924325824, 0.00425893999636173, 0.00425543077290058, 0.00425209617242217, 0.00424919091165066, 0.0042461883276701, 0.00424361415207386, 0.00424111913889647, 0.00423875963315368, 0.00423659523949027, 0.00423470372334123, 0.00423289043828845, 0.00423152558505535, 0.00423014163970947, 0.00422916654497385, 0.00422821100801229, 0.00422737281769514, 0.00422682659700513, 0.00422645639628172, 0.00422626128420234, 0.00422643637284636, 0.00422667060047388, 0.00422719726338983, 0.00422780169174075, 0.00422856211662292, 0.00422973185777664, 0.00423078471794724, 0.00423230603337288, 0.00423390464857221, 0.00423569837585092, 0.00423776544630527, 0.00423996848985553, 0.0042420937679708, 0.00424488168209791, 0.00424770917743444, 0.00425090687349439, 0.0042541241273284, 0.00425751646980643, 0.00426096795126796, 0.00426477007567883, 0.00426845531910658, 0.00427276454865932, 0.00427713198587298, 0.00428187008947134, 0.00428662728518248, 0.00429152138531208, 0.00429666927084327, 0.00430201180279255, 0.00430739298462868, 0.0043132035061717, 0.00431913090869784, 0.00432537030428648, 0.00433184346184134, 0.00433796597644687, 0.00434496626257896, 0.00435182917863131, 0.00435888767242432, 0.00436610169708729, 0.00437370594590902, 0.00438148621469736, 0.00438948022201657, 0.00439729867503047, 0.00440566381439567, 0.00441422313451767, 0.00442313449457288, 0.00443171337246895, 0.00444070156663656, 0.00445017823949456, 0.00445969309657812, 0.00446905195713043, 0.00447909347712994, 0.00448919413611293, 0.00449962541460991, 0.00450974516570568, 0.00452041020616889, 0.00453142682090402, 0.00454246299341321, 0.00455336179584265, 0.00456494418904185, 0.00457658432424068, 0.00458865379914641, 0.00460068369284272, 0.00461255852133036, 0.0046251155436039, 0.00463769119232893, 0.00465026777237654, 0.00466338964179158, 0.00467655155807734, 0.00469016097486019, 0.00470371264964342, 0.00471728295087814, 0.00473151681944728, 0.00474563334137201, 0.004759905859828, 0.00477439304813743, 0.0047892308793962, 0.00480440072715282, 0.00481841014698148, 0.00483051873743534, 0.00484253000468016, 0.00485457945615053, 0.00486662937328219, 0.00487875752151012, 0.0048908069729805, 0.00490291509777308, 0.00491500413045287, 0.00492715137079358, 0.00493927905336022, 0.00495134852826595, 0.00496353534981608, 0.00497568212449551, 0.00498780980706215, 0.00499995751306415, 0.00501216342672706, 0.00502436887472868, 0.00503655523061752, 0.00504874158650637, 0.00506096659228206, 0.00507317297160625, 0.00508543709293008, 0.00509760389104486, 0.00510988757014275, 0.0051221321336925, 0.00513443583622575, 0.00514664128422737, 0.00515896454453468, 0.00517122866585851, 0.0051835710182786, 0.00519585516303778, 0.00520815793424845, 0.00522048072889447, 0.00523286173120141, 0.00524512631818652, 0.00525752687826753, 0.00526990881189704, 0.00528229027986526, 0.00529463170096278, 0.00530705228447914, 0.00531945331022143, 0.00533183477818966, 0.0053442744538188, 0.0053566750138998, 0.00536913424730301, 0.0053815352730453, 0.00539401359856129, 0.00540643371641636, 0.00541893299669027, 0.00543139176443219, 0.00544389011338353, 0.00545640802010894, 0.00546890636906028, 0.00548140471801162, 0.00549392215907574, 0.00550644006580114, 0.00551901618018746, 0.00553159276023507, 0.00554409064352512, 0.0055566867813468, 0.00556926243007183, 0.00558187812566757, 0.00559441512450576, 0.00560703035444021, 0.00561964605003595, 0.00563230039551854, 0.00564487650990486, 0.00565753038972616, 0.00567018520087004, 0.0056828586384654, 0.00569545431062579, 0.00570818688720465, 0.00572084123268723, 0.0057335733436048, 0.00574620813131332, 0.00575895980000496, 0.00577165326103568, 0.00578440492972732, 0.00579713750630617, 0.00580988917499781, 0.00582262128591537, 0.00583539251238108, 0.00584818329662085, 0.00586095452308655, 0.00587376486510038, 0.00588657520711422, 0.00589934643357992, 0.00591215630993247, 0.00592502532526851, 0.00593783520162106, 0.00595066556707025, 0.00596351455897093, 0.00597640266641974, 0.00598927214741707, 0.00600212067365646, 0.00601497059687972, 0.00602793646976352, 0.00604080548509955, 0.0060537327080965, 0.0060695456340909, 0.00608399324119091, 0.00609857821837068, 0.00611277250573039, 0.00612679170444608, 0.00614075222983956, 0.00615461589768529, 0.00616822531446815, 0.00618173694238067, 0.00619495706632733, 0.00620833318680525, 0.00622127950191498, 0.0062341489829123, 0.00624686060473323, 0.00625959364697337, 0.00627197464928031, 0.00628423877060413, 0.00629623094573617, 0.00630826037377119, 0.00632023252546787, 0.00633189268410206, 0.00634333770722151, 0.00635476363822818, 0.00636595580726862, 0.00637701107189059, 0.00638798903673887, 0.00639865407720208, 0.00640931911766529, 0.00641984818503261, 0.00643008481711149, 0.00644016545265913, 0.00645032431930304, 0.00646013161167502, 0.00646986113861203, 0.00647929776459932, 0.00648881355300546, 0.00649803597480059, 0.00650712195783854, 0.00651605194434524, 0.00652492372319102, 0.00653352262452245, 0.00654198508709669, 0.00655029062181711, 0.00655865529552102, 0.00656657153740525, 0.0065744100138545, 0.00658217025920749, 0.00658985273912549, 0.00659730052575469, 0.00660453410819173, 0.00661157304421067, 0.0066187484189868, 0.00662545580416918, 0.00663214409723878, 0.00663865637034178, 0.00664510997012258, 0.00665132980793715, 0.00665727676823735, 0.00666328240185976, 0.00666907336562872, 0.0066746692173183, 0.00668010953813791, 0.00668539293110371, 0.00669052172452211, 0.00669562956318259, 0.00670040724799037, 0.00670510623604059, 0.00670978520065546, 0.00671411352232099, 0.00671832589432597, 0.00672238133847713, 0.00672635855153203, 0.00673023844137788, 0.00673382636159658, 0.00673729693517089, 0.00674059242010117, 0.00674380920827389, 0.00674690958112478, 0.00674971705302596, 0.00675252499058843, 0.00675517693161964, 0.00675765285268426, 0.00675981724634767, 0.00676184520125389, 0.0067640095949173, 0.00676582241430879, 0.00676746061071754, 0.00676886411383748, 0.00677034631371498, 0.00677161384373903, 0.00677260803058743, 0.00677352445200086, 0.00677442131564021, 0.00677494797855616, 0.00677541550248861, 0.00677563063800335, 0.00677582575008273, 0.00677592307329178, 0.00677570840343833, 0.00677537685260177, 0.00677468115463853, 0.00676680449396372, 0.00675884913653135, 0.00675050355494022, 0.00674231396988034, 0.00673365732654929, 0.00672492198646069, 0.00671579642221332, 0.00670659355819225, 0.00669723469763994, 0.00668764114379883, 0.00667781475931406, 0.00666767498478293, 0.0066574583761394, 0.00664700707420707, 0.00663640024140477, 0.006625403650105, 0.00661456258967519, 0.00660317577421665, 0.00659171026200056, 0.00657993322238326, 0.00656815664842725, 0.00655614584684372, 0.00654374482110143, 0.0065314220264554, 0.00651863124221563, 0.00650568446144462, 0.00649265991523862, 0.00647932291030884, 0.00646582990884781, 0.00645202584564686, 0.00643814262002707, 0.00642402609810233, 0.0064095975831151, 0.00639501307159662, 0.00638034986332059, 0.00636537512764335, 0.00635047862306237, 0.00633488036692142, 0.00631920387968421, 0.00630352739244699, 0.00628761667758226, 0.00627139443531632, 0.00625501573085785, 0.00623832549899817, 0.00622155703604221, 0.00620447658002377, 0.00618731835857034, 0.00616992590948939, 0.00615222146734595, 0.00613459525629878, 0.00611634459346533, 0.00609817216172814, 0.00607992243021727, 0.00606128200888634, 0.00604225182905793, 0.00602322118356824, 0.00600403500720859, 0.00598461460322142, 0.00596480490639806, 0.00594499474391341, 0.00592479482293129, 0.00590467266738415, 0.00588408252224326, 0.00586333591490984, 0.00584251200780272, 0.00582145480439067, 0.00580000644549727, 0.00577855855226517, 0.00575679820030928, 0.00573511654511094, 0.00571288866922259, 0.00569034833461046, 0.0056678862310946, 0.00564534682780504, 0.00562233943492174, 0.00559909688308835, 0.00557577703148127, 0.00555222388356924, 0.00552851380780339, 0.0055043357424438, 0.00548023683950305, 0.00545574631541967, 0.00543141271919012, 0.00540653290227056, 0.00538141932338476, 0.00535638350993395, 0.00533088017255068, 0.00530529906973243, 0.00527932727709413, 0.0052534332498908, 0.00522722816094756, 0.00520078791305423, 0.00517395883798599, 0.0051473630592227, 0.00512022152543068, 0.00509308092296124, 0.00506554916501045, 0.00503770587965846, 0.00501001812517643, 0.00497649097815156, 0.00494225230067968, 0.00490793492645025, 0.00487354025244713, 0.00483937980607152, 0.00480514019727707, 0.00477074552327394, 0.00473666284233332, 0.00470242416486144, 0.00466818502172828, 0.00463371211662889, 0.00459962990134954, 0.00456538982689381, 0.00453138537704945, 0.00449699116870761, 0.00446282979100943, 0.00442874664440751, 0.0043945861980319, 0.00436050351709127, 0.00432618614286184, 0.00429210346192122, 0.0042580203153193, 0.00422393810003996, 0.00418962072581053, 0.00415577227249742, 0.00412161089479923, 0.0040875282138586, 0.00405336730182171, 0.00401928462088108, 0.00398527923971415, 0.00395127478986979, 0.00391719164326787, 0.00388310896232724, 0.00384918181225657, 0.00381517712958157, 0.00378125021234155, 0.00374716729857028, 0.0037132406141609, 0.00367915746755898, 0.00364530878141522, 0.00361114763654768, 0.00357722071930766, 0.00354345003142953, 0.00350952288135886, 0.00347567396238446, 0.00344159128144383, 0.00340774212963879, 0.00337373767979443, 0.00334004452452064, 0.00330588361248374, 0.00327226868830621, 0.00323826377280056, 0.00320449285209179, 0.00317064393311739, 0.00313687324523926, 0.00310302409343421, 0.00306933117099106, 0.00303524849005044, 0.00300147756934166, 0.00296786264516413, 0.00293401349335909, 0.00290039880201221, 0.00286639388650656, 0.00283262296579778, 0.0027991640381515, 0.00276539288461208, 0.0027316224295646, 0.00269777327775955, 0.00266415835358202, 0.00263046543113887, 0.00259677227586508, 0.00256300158798695, 0.00252946489490569, 0.00249577197246253, 0.00246192282065749, 0.00242846389301121, 0.00239484896883368, 0.00236115604639053, 0.00232754112221301, 0.00229384819976985, 0.00226031127385795, 0.00222685234621167, 0.00219315942376852, 0.00215954473242164, 0.00212600757367909, 0.00209247041493654, 0.00205885572358966, 0.00202531879767776, 0.0019916258752346, 0.00195832294411957, 0.00192486390005797, 0.00189124909229577, 0.00185786804649979, 0.00182425323873758, 0.00179087230935693, 0.0017573352670297, 0.0017238762229681, 0.00169041741173714, 0.00165703636594117, 0.00162349944002926, 0.00159074261318892, 0.00156640878412873, 0.00154215295333415, 0.0015182871138677, 0.00149434339255095, 0.00147071154788136, 0.00144707958679646, 0.00142391584813595, 0.00140075187664479, 0.00137774390168488, 0.00135481404140592, 0.00133227417245507, 0.00130981230176985, 0.00128750631120056, 0.00126543419901282, 0.00124328432139009, 0.00122160231694579, 0.00119984231423587, 0.00117847218643874, 0.00115725817158818, 0.00113596604205668, 0.00111514201853424, 0.00109431799501181, 0.00107364973518997, 0.00105321570299566, 0.00103301554918289, 0.00101281539537013, 0.000992927234619856, 0.000973116955719888, 0.000953618786297739, 0.000934276555199176, 0.00091485632583499, 0.000895670149475336, 0.00087687378982082, 0.000857999548316002, 0.00083967117825523, 0.000821186869870871, 0.000802936614491045, 0.000784764240961522, 0.000766747805755585, 0.00074912142008543, 0.000731729087419808, 0.000714180758222938, 0.000697022245731205, 0.000679863849654794, 0.000662939390167594, 0.000646326865535229, 0.000629792455583811, 0.000613413925748318, 0.000597191392444074, 0.00058096885913983, 0.000565370311960578, 0.000549615768250078, 0.000534017221070826, 0.000518652552273124, 0.000503287999890745, 0.000488391320686787, 0.000473572668852285, 0.000458832044387236, 0.00044432538561523, 0.00042997466516681, 0.000415624002926052, 0.000401741272071376, 0.000388014508644119, 0.000374287745216861, 0.000360795005690306, 0.000347380235325545, 0.000334277428919449, 0.000321408588206396, 0.000308461807435378, 0.000295826961519197, 0.000283270084764808, 0.000270947231911123, 0.000258780317381024, 0.000246925425017253, 0.00023507050354965, 0.000223449562327005, 0.000211828635656275, 0.000200597642106004, 0.000189600657904521, 0.000178447677171789, 0.000167762656928971, 0.000157155634951778, 0.000146626596688293, 0.000136331538669765, 0.00012619246263057, 0.000116365357825998, 0.000106616251287051, 9.71011177171022e-05, 8.75079931574874e-05, 7.83048453740776e-05, 6.90236847731285e-05, 6.02104919380508e-05, 5.13972991029732e-05, 4.28180865128525e-05, 3.43948522640858e-05, 2.60496180999326e-05, 1.81723389687249e-05, 1.02170661193668e-05, 2.49577169597615e-06, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15, 2.13905317104099e-15   }, 
   { 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 2.05354180688388e-15, 1.1899231822099e-06, 3.8957755350566e-06, 6.79723234497942e-06, 9.84539201454027e-06, 1.30402540889918e-05, 1.63003187481081e-05, 1.98537854885217e-05, 2.34887575061293e-05, 2.73193327302579e-05, 3.12803094857372e-05, 3.53553878085222e-05, 3.96423747588415e-05, 4.40434560005087e-05, 4.86075441585854e-05, 5.32368358108215e-05, 5.81758322368842e-05, 6.31637303740717e-05, 6.83798352838494e-05, 7.37426307750866e-05, 7.92195423855446e-05, 8.48594499984756e-05, 9.06297645997256e-05, 9.66282750596292e-05, 0.000102740901638754, 0.000108967622509226, 0.000115373652079143, 0.000122007870231755, 0.000128707310068421, 0.000135618654894643, 0.000142611490446143, 0.000149816216435283, 0.000157151356688701, 0.000164633194799535, 0.000172343265148811, 0.000180085917236283, 0.000188056757906452, 0.000196174310985953, 0.000204471172764897, 0.000212914746953174, 0.000221423513721675, 0.000230160483624786, 0.000239060464082286, 0.000248123425990343, 0.000257300504017621, 0.00026659169816412, 0.000276078499155119, 0.000285728252492845, 0.000295573670882732, 0.000305582070723176, 0.000315606739604846, 0.000325875967973843, 0.000336324446834624, 0.000346919638104737, 0.000357661570888013, 0.000368468696251512, 0.000379536591935903, 0.000390734930988401, 0.000402112520532683, 0.000413636851590127, 0.000425226346123964, 0.000437076698290184, 0.000449008541181684, 0.000461152289062738, 0.000473442720249295, 0.000485830969410017, 0.000498382200021297, 0.000511129095684737, 0.000524071510881186, 0.000537079176865518, 0.000550249824300408, 0.000563599751330912, 0.00057712901616469, 0.00059080496430397, 0.000604643952101469, 0.000618515536189079, 0.000632680545095354, 0.000646959582809359, 0.000661401660181582, 0.000676006777212024, 0.000690677028615028, 0.000705575512256473, 0.000720620737411082, 0.000735845242161304, 0.000751151237636805, 0.000766620272770524, 0.000782317423727363, 0.00079814501805231, 0.000814119353890419, 0.000830175122246146, 0.000846475537400693, 0.000862873625010252, 0.000879483646713197, 0.000896240351721644, 0.00091307854745537, 0.000930112379137427, 0.000947358144912869, 0.000964701699558645, 0.000982240890152752, 0.000999877811409533, 0.00101767771411687, 0.00104078149888664, 0.00106655212584883, 0.00109244522172958, 0.00111837894655764, 0.0011444715783, 0.00117066211532801, 0.00119695439934731, 0.00122337299399078, 0.00124982441775501, 0.00127641018480062, 0.00130312226247042, 0.00132993212901056, 0.00135684397537261, 0.0013838168233633, 0.00141092424746603, 0.00143812515307218, 0.00146542419679463, 0.00149289018008858, 0.00152031937614083, 0.00154797709546983, 0.00157570373266935, 0.0016035569133237, 0.00163147505372763, 0.00165946269407868, 0.00168760924134403, 0.00171585369389504, 0.001744199777022, 0.00177267228718847, 0.00180117751006037, 0.00182981695979834, 0.00185858295299113, 0.00188744661863893, 0.00191641226410866, 0.00194543914403766, 0.00197459617629647, 0.00200388790108263, 0.00203324039466679, 0.00206272769719362, 0.00209227600134909, 0.00212195469066501, 0.00215173559263349, 0.0021816382650286, 0.0022116145119071, 0.00224165595136583, 0.00227185222320259, 0.00230215443298221, 0.00233258726075292, 0.00236308085732162, 0.00239357468672097, 0.00242430064827204, 0.00245515303686261, 0.00248603825457394, 0.00251705734990537, 0.00254810554906726, 0.00257934909313917, 0.00261069438420236, 0.00264210090972483, 0.00267357286065817, 0.00270520779304206, 0.00273694423958659, 0.00276881130412221, 0.00280076800845563, 0.00283273309469223, 0.00286489352583885, 0.00289714359678328, 0.00292949960567057, 0.0029619534034282, 0.00299446447752416, 0.00302711385302246, 0.00305989384651184, 0.00309276720508933, 0.0031257385853678, 0.00315874698571861, 0.0031919137109071, 0.00322521105408669, 0.00325857382267714, 0.00329207093454897, 0.00332559691742063, 0.00335928541608155, 0.00339307589456439, 0.00342695997096598, 0.00346094206906855, 0.00349502568133175, 0.00352924014441669, 0.00356347905471921, 0.00359788886271417, 0.00363242928870022, 0.0036669613327831, 0.00370169733650982, 0.00373649853281677, 0.0037714543286711, 0.00380645110271871, 0.00384150887839496, 0.00387676642276347, 0.00391208520159125, 0.00394753413274884, 0.00398305291309953, 0.00401866436004639, 0.00405440712347627, 0.00409025140106678, 0.00412498321384192, 0.00415987800806761, 0.00419471180066466, 0.00422937842085958, 0.00426404550671577, 0.00429861806333065, 0.00433309329673648, 0.00436742976307869, 0.00440174201503396, 0.00443598441779613, 0.00447016209363937, 0.00450421357527375, 0.0045381304807961, 0.00457204692065716, 0.00460587022826076, 0.00463962461799383, 0.00467325141653419, 0.00470677716657519, 0.00474023772403598, 0.00477366987615824, 0.00480693439021707, 0.00484016677364707, 0.00487330462783575, 0.0049064070917666, 0.00493937870487571, 0.00497222319245338, 0.00500503135845065, 0.00503777526319027, 0.00507042463868856, 0.00510300463065505, 0.00513542210683227, 0.00516781071200967, 0.00520013039931655, 0.0052322861738503, 0.00526444707065821, 0.00529650552198291, 0.0053285313770175, 0.00536039844155312, 0.00539216352626681, 0.0054238960146904, 0.00545556750148535, 0.00548710487782955, 0.00551861338317394, 0.00554995471611619, 0.00558126345276833, 0.00561247859150171, 0.00564358755946159, 0.00567463925108314, 0.00570565834641457, 0.00573653960600495, 0.005767363589257, 0.00579802459105849, 0.00582868093624711, 0.00585923995822668, 0.0058897384442389, 0.0059200688265264, 0.00595036661252379, 0.00598060386255383, 0.00601073913276196, 0.00604077661409974, 0.00607075309380889, 0.00610065972432494, 0.00613046903163195, 0.00616021268069744, 0.00618976494297385, 0.00621935073286295, 0.00624882942065597, 0.00627825129777193, 0.00630747806280851, 0.00633672857657075, 0.00636585708707571, 0.00639495346695185, 0.00642384588718414, 0.00645277835428715, 0.00648158090189099, 0.00651031453162432, 0.00653895037248731, 0.00656745908781886, 0.00659593194723129, 0.00662433914840221, 0.0066526485607028, 0.00668079871684313, 0.00670897867530584, 0.00673702685162425, 0.00676501449197531, 0.00679283449426293, 0.00682065589353442, 0.00684838183224201, 0.00687604350969195, 0.00690359948202968, 0.00693103298544884, 0.00695840129628778, 0.00698572816327214, 0.00701296608895063, 0.00704003684222698, 0.00706710759550333, 0.00709408475086093, 0.00712095946073532, 0.00714780623093247, 0.00717445323243737, 0.00719686737284064, 0.00721659045666456, 0.00723621621727943, 0.0072556952945888, 0.00727510033175349, 0.00729438336566091, 0.00731353694573045, 0.00733251869678497, 0.00735147576779127, 0.00737030291929841, 0.00738899130374193, 0.00740761402994394, 0.00742600904777646, 0.00744437891989946, 0.00746261095628142, 0.00748078618198633, 0.00749873276799917, 0.00751665513962507, 0.00753443874418736, 0.00755211617797613, 0.00756962271407247, 0.00758707243949175, 0.0076044243760407, 0.00762163707986474, 0.00763871986418962, 0.00765566434711218, 0.00767255946993828, 0.00768934050574899, 0.00770596694201231, 0.00772240571677685, 0.0077388770878315, 0.00775515334680676, 0.00777138816192746, 0.00778737897053361, 0.00780333718284965, 0.00781918875873089, 0.00783492717891932, 0.00785052590072155, 0.00786598678678274, 0.00788136571645737, 0.00789666455239058, 0.00791183114051819, 0.00792681984603405, 0.00794173497706652, 0.00795656815171242, 0.00797127932310104, 0.00798581074923277, 0.0080002611503005, 0.00801460538059473, 0.00802887603640556, 0.00804301630705595, 0.00805698614567518, 0.00807085819542408, 0.00808466412127018, 0.00809833128005266, 0.00811184477061033, 0.00812526047229767, 0.00813860166817904, 0.00815182086080313, 0.00816486962139606, 0.0081778522580862, 0.00819075480103493, 0.00820347759872675, 0.0082161258906126, 0.00822858698666096, 0.00824102479964495, 0.00825331546366215, 0.00826551578938961, 0.00827752985060215, 0.00828948616981506, 0.00830129534006119, 0.00831305515021086, 0.00832460448145866, 0.00833611283451319, 0.00834750663489103, 0.00835874490439892, 0.00836992729455233, 0.0083808982744813, 0.00839181896299124, 0.00840265117585659, 0.00841333623975515, 0.00842387415468693, 0.00843433011323214, 0.00844467245042324, 0.0084549505263567, 0.0084649994969368, 0.00847500842064619, 0.00848490186035633, 0.00849469844251871, 0.00850435718894005, 0.00851386692374945, 0.00852328911423683, 0.00853264611214399, 0.00854183081537485, 0.00855086930096149, 0.00855986773967743, 0.008568718098104, 0.00857747998088598, 0.00858606211841106, 0.00859456323087215, 0.00860448554158211, 0.00861312448978424, 0.00862176343798637, 0.00863039400428534, 0.00863899011164904, 0.00864757131785154, 0.00865614973008633, 0.00866470672190189, 0.00867324415594339, 0.00868178065866232, 0.00869029015302658, 0.00869878940284252, 0.00870727188885212, 0.00871573109179735, 0.00872420240193605, 0.00873262993991375, 0.00874104537069798, 0.0087494682520628, 0.00875786691904068, 0.00876622460782528, 0.00877460371702909, 0.00878294836729765, 0.00879129953682423, 0.00879960414022207, 0.00880790036171675, 0.00881619844585657, 0.00882448256015778, 0.00883272662758827, 0.00884097814559937, 0.00884920172393322, 0.0088574169203639, 0.00886561349034309, 0.00887379515916109, 0.00888196937739849, 0.00889011565595865, 0.00889824982732534, 0.00890638306736946, 0.00891450047492981, 0.00892257690429688, 0.00893065892159939, 0.00893872696906328, 0.00894679594784975, 0.00895481556653976, 0.00896282680332661, 0.00897083431482315, 0.0089788343757391, 0.00898679718375206, 0.0089947646483779, 0.00900269765406847, 0.00901062320917845, 0.00901854503899813, 0.00902644731104374, 0.00903434120118618, 0.00904220156371593, 0.00905003864318132, 0.00905790738761425, 0.0090657277032733, 0.00907353963702917, 0.00908132176846266, 0.00908909272402525, 0.00909688603132963, 0.00910462345927954, 0.00911235064268112, 0.00912007223814726, 0.0091277863830328, 0.00913546793162823, 0.00914314482361078, 0.00915079843252897, 0.00915845204144716, 0.00916607584804296, 0.00917369220405817, 0.00918130483478308, 0.009188880212605, 0.00919643137603998, 0.0092040142044425, 0.00921154115349054, 0.00921908020973206, 0.00922657828778028, 0.00923407264053822, 0.00924157071858644, 0.0092490166425705, 0.0092564607039094, 0.00926390662789345, 0.00927132740616798, 0.00927872769534588, 0.00928612798452377, 0.00929349102079868, 0.00930086337029934, 0.00930820964276791, 0.00931553449481726, 0.00932285282760859, 0.00933014694601297, 0.009337417781353, 0.00934471935033798, 0.00935196503996849, 0.00935919396579266, 0.00936642754822969, 0.00937363225966692, 0.00938085280358791, 0.00938801653683186, 0.00939340051263571, 0.00939853955060244, 0.00940372236073017, 0.00940907746553421, 0.00941455364227295, 0.00942011270672083, 0.00942584592849016, 0.00943169742822647, 0.00943762715905905, 0.00944370776414871, 0.00944992993026972, 0.00945620518177748, 0.00946268904954195, 0.00946928653866053, 0.00947593338787556, 0.00948278605937958, 0.0094897635281086, 0.00949678476899862, 0.00950398202985525, 0.00951129198074341, 0.00951869692653418, 0.00952626764774323, 0.00953392498195171, 0.00954175367951393, 0.00954970717430115, 0.0095576960593462, 0.0095658740028739, 0.00957419537007809, 0.00958256516605616, 0.00959114730358124, 0.00959984865039587, 0.00960859283804893, 0.0096175167709589, 0.00962655153125525, 0.00963567569851875, 0.00964497495442629, 0.00965438410639763, 0.00966387428343296, 0.00967354513704777, 0.00968333706259727, 0.00969320349395275, 0.00970324873924255, 0.00971340853720903, 0.00972362421452999, 0.00973404478281736, 0.00974454544484615, 0.00975515320897102, 0.00976591557264328, 0.00977682415395975, 0.00978778582066298, 0.00979891885071993, 0.00981010496616364, 0.00982149969786406, 0.00983301550149918, 0.00984460487961769, 0.00985637865960598, 0.0098682614043355, 0.00988019723445177, 0.00989234074950218, 0.00990459881722927, 0.00991690531373024, 0.00992938689887524, 0.00994199607521296, 0.00995467323809862, 0.0099675664678216, 0.00998053792864084, 0.0099935894832015, 0.0100068338215351, 0.010020213201642, 0.0100336065515876, 0.0100472141057253, 0.0100609380751848, 0.0100747449323535, 0.0100886952131987, 0.0101028233766556, 0.0101169673725963, 0.0101313274353743, 0.0101457005366683, 0.0101602850481868, 0.0101750157773495, 0.0101897642016411, 0.0102047566324472, 0.0102198300883174, 0.0102349491789937, 0.0102502796798944, 0.0102657563984394, 0.0102812573313713, 0.0102969342842698, 0.0103127509355545, 0.0103286514058709, 0.0103447074070573, 0.0103608975186944, 0.0103771416470408, 0.0103935962542892, 0.010410132817924, 0.0104267494753003, 0.0104435803368688, 0.0104604922235012, 0.0104774534702301, 0.010494657792151, 0.010512238368392, 0.0105326138436794, 0.0105533795431256, 0.010574309155345, 0.0105954669415951, 0.010616984218359, 0.0106385974213481, 0.010660570114851, 0.0106827393174171, 0.0107051683589816, 0.0107278265058994, 0.0107507770881057, 0.0107739558443427, 0.0107972975820303, 0.0108210304751992, 0.0108449272811413, 0.010869019664824, 0.0108935013413429, 0.0109180836006999, 0.0109429899603128, 0.0109681244939566, 0.0109934881329536, 0.0110191768035293, 0.0110449977219105, 0.0110711101442575, 0.0110975494608283, 0.0111240865662694, 0.0111509496346116, 0.011178039945662, 0.0112054254859686, 0.0112329721450806, 0.0112608782947063, 0.0112889157608151, 0.0113172121345997, 0.0113458689302206, 0.0113746542483568, 0.0114037031307817, 0.01143310777843, 0.0114625785499811, 0.0114924088120461, 0.0115224663168192, 0.011552719399333, 0.0115833319723606, 0.0116141401231289, 0.0116451745852828, 0.0116764716804028, 0.0117079969495535, 0.0117397820577025, 0.0117717636749148, 0.0118041038513184, 0.0118365408852696, 0.0118693048134446, 0.011902361176908, 0.0119355814531446, 0.0119690950959921, 0.0120029021054506, 0.0120368059724569, 0.0120710702612996, 0.0121055617928505, 0.0121402805671096, 0.0121752619743347, 0.0122104054316878, 0.0122459400445223, 0.0122816050425172, 0.0123175960034132, 0.0123538468033075, 0.012390261515975, 0.0124269379302859, 0.0124638425186276, 0.0125010721385479, 0.0125385299324989, 0.0125761833041906, 0.0126141626387835, 0.0126522406935692, 0.0126907425001264, 0.0127294724807143, 0.0127682657912374, 0.0128074856474996, 0.0128468666225672, 0.0128864767029881, 0.0129264453426003, 0.0129665769636631, 0.013006903231144, 0.0130475573241711, 0.0130885038524866, 0.0131295789033175, 0.0131709175184369, 0.013212613761425, 0.0132543751969934, 0.013296527788043, 0.0133388759568334, 0.0133814522996545, 0.0134243555366993, 0.0134673537686467, 0.0135107785463333, 0.0135543663054705, 0.013598115183413, 0.0136422896757722, 0.0136866271495819, 0.0137311266735196, 0.0137813482433558, 0.013837892562151, 0.0138946184888482, 0.0139513434842229, 0.0140081671997905, 0.0140651194378734, 0.0141220577061176, 0.0141791244968772, 0.0142362890765071, 0.0142934713512659, 0.0143507672473788, 0.0144080948084593, 0.0144655695185065, 0.0145230451598763, 0.0145806493237615, 0.0146383363753557, 0.0146960886195302, 0.0147538902238011, 0.0148118045181036, 0.0148697532713413, 0.0149278305470943, 0.0149858929216862, 0.0150441331788898, 0.0151023250073195, 0.0151607459411025, 0.0152191817760468, 0.0152776194736362, 0.0153362350538373, 0.0153949484229088, 0.0154536133632064, 0.0155124580487609, 0.0155713194981217, 0.0156302768737078, 0.0156892500817776, 0.015748405829072, 0.0158076081424952, 0.0158668272197247, 0.0159262083470821, 0.015985606238246, 0.0160451028496027, 0.0161046646535397, 0.0161642748862505, 0.0162240155041218, 0.0162837728857994, 0.016343692317605, 0.0164036452770233, 0.0164636299014091, 0.0165237449109554, 0.0165838450193405, 0.0166441239416599, 0.0167044997215271, 0.0167648438364267, 0.0168253518640995, 0.0168858747929335, 0.0169465113431215, 0.0170072447508574, 0.0170679986476898, 0.0171288624405861, 0.0171897765249014, 0.0172508042305708, 0.0173118840903044, 0.0173730086535215, 0.0174342971295118, 0.0174955222755671, 0.0175569429993629, 0.0176184587180614, 0.0176799613982439, 0.0177415926009417, 0.0178032238036394, 0.0178650673478842, 0.0179268922656775, 0.0179887693375349, 0.0180508252233267, 0.018112912774086, 0.0181750170886517, 0.0182372517883778, 0.0182995013892651, 0.0183619167655706, 0.0184243470430374, 0.0184868741780519, 0.0185495167970657, 0.0186121426522732, 0.0186748970299959, 0.0187377706170082, 0.0188006702810526, 0.0188636239618063, 0.0189266745001078, 0.0189898535609245, 0.0190530326217413, 0.0191163122653961, 0.0191797036677599, 0.0192431099712849, 0.0193066503852606, 0.0193702541291714, 0.0194338746368885, 0.0194976571947336, 0.0195614397525787, 0.0196253526955843, 0.019689267501235, 0.01975336112082, 0.0198154803365469, 0.0198737196624279, 0.0199317969381809, 0.0199896804988384, 0.0200473330914974, 0.0201047603040934, 0.0201619882136583, 0.0202189590781927, 0.0202756691724062, 0.0203322805464268, 0.0203886292874813, 0.0204447526484728, 0.0205006953328848, 0.0205563269555569, 0.0206118300557137, 0.0206670705229044, 0.0207221489399672, 0.0207770001143217, 0.0208316240459681, 0.0208860021084547, 0.020940151065588, 0.0209941379725933, 0.0210479106754065, 0.0211014728993177, 0.0211547445505857, 0.021207882091403, 0.0212606955319643, 0.02131337672472, 0.0213658660650253, 0.0214181244373322, 0.0214701555669308, 0.0215219557285309, 0.0215735491365194, 0.021624943241477, 0.0216760281473398, 0.0217269994318485, 0.0217777583748102, 0.0218282900750637, 0.0218785740435123, 0.0219286009669304, 0.021978497505188, 0.0220281314104795, 0.0220775678753853, 0.0221267957240343, 0.0221758112311363, 0.0222245324403048, 0.0222731083631516, 0.0223214700818062, 0.0223696045577526, 0.0224175602197647, 0.0224652234464884, 0.0225126892328262, 0.0225599613040686, 0.0226070210337639, 0.022653866559267, 0.022700535133481, 0.022746941074729, 0.022793136537075, 0.0228390693664551, 0.0228848569095135, 0.0229303352534771, 0.0229756832122803, 0.0230208188295364, 0.0230657439678907, 0.0231103394180536, 0.0231548231095076, 0.0231991112232208, 0.0232430882751942, 0.0232869386672974, 0.0233305580914021, 0.0233738832175732, 0.0234170462936163, 0.0234600137919188, 0.0235027372837067, 0.0235453154891729, 0.023587629199028, 0.0236296523362398, 0.0236714947968721, 0.0237131901085377, 0.0237546265125275, 0.0237958505749702, 0.0238368771970272, 0.0238776300102472, 0.0239182002842426, 0.023958558216691, 0.0239987056702375, 0.0240386109799147, 0.0240783505141735, 0.0241178441792727, 0.0241570957005024, 0.0241961535066366, 0.0242350269109011, 0.0242736767977476, 0.0243120789527893, 0.0243502389639616, 0.0243881866335869, 0.024425970390439, 0.0244635250419378, 0.0245008543133736, 0.0245380010455847, 0.024570332840085, 0.0245971065014601, 0.0246238149702549, 0.0246502533555031, 0.0246765371412039, 0.0247026178985834, 0.0247284863144159, 0.0247541666030884, 0.0247795972973108, 0.024804862216115, 0.0248299408704042, 0.0248548369854689, 0.0248794760555029, 0.0249039754271507, 0.0249282140284777, 0.0249522980302572, 0.0249761790037155, 0.0249998867511749, 0.0250233747065067, 0.0250466596335173, 0.02506965957582, 0.0250925533473492, 0.0251152515411377, 0.0251377299427986, 0.0251600351184607, 0.0251821577548981, 0.0252040326595306, 0.0252256859093904, 0.0252471957355738, 0.0252684410661459, 0.0252895690500736, 0.0253104660660028, 0.0253311581909657, 0.0253516156226397, 0.0253719314932823, 0.0253920312970877, 0.0254119653254747, 0.0254316739737988, 0.0254511442035437, 0.0254703797399998, 0.0254894997924566, 0.0255084224045277, 0.0255271587520838, 0.0255456548184156, 0.0255639981478453, 0.0255821011960506, 0.0255999490618706, 0.025617677718401, 0.0256351996213198, 0.025652501732111, 0.0256696250289679, 0.0256865210831165, 0.0257032290101051, 0.02571976557374, 0.0257361065596342, 0.0257521867752075, 0.0257681105285883, 0.0257838480174541, 0.0257993750274181, 0.0258146580308676, 0.0258297994732857, 0.0258446894586086, 0.0258594509214163, 0.025874013081193, 0.0258883256465197, 0.0259024426341057, 0.0259163379669189, 0.0259300712496042, 0.0259436089545488, 0.0259569920599461, 0.0259700734168291, 0.0259830392897129, 0.0259957443922758, 0.0260082986205816, 0.026020634919405, 0.0260327719151974, 0.0260447598993778, 0.0260564312338829, 0.0260680057108402, 0.0260793417692184, 0.0260904915630817, 0.0261014122515917, 0.0261122025549412, 0.0261227078735828, 0.0261331144720316, 0.0261432640254498, 0.02615319006145, 0.0261629223823547, 0.02617247402668, 0.0261818375438452, 0.0261909905821085, 0.0261999797075987, 0.026208683848381, 0.026217257604003, 0.0262255948036909, 0.0262338351458311, 0.0262417402118444, 0.026249535381794, 0.0262570306658745, 0.0262644309550524, 0.0262662880122662, 0.0262641441076994, 0.0262621976435184, 0.0262604709714651, 0.0262589361518621, 0.0262575913220644, 0.0262564681470394, 0.0262555554509163, 0.0262548942118883, 0.0262543894350529, 0.0262540802359581, 0.0262540075927973, 0.0262540951371193, 0.026254415512085, 0.026254927739501, 0.0262556858360767, 0.026256525889039, 0.026257673278451, 0.0262590199708939, 0.0262605994939804, 0.0262623447924852, 0.0262643173336983, 0.026266485452652, 0.0262688565999269, 0.0262714400887489, 0.0262741949409246, 0.0262772105634212, 0.0262803882360458, 0.0262838024646044, 0.0262873824685812, 0.0262912213802338, 0.0262952204793692, 0.0262994691729546, 0.0263038147240877, 0.0263084415346384, 0.0263132750988007, 0.0263183452188969, 0.0263235680758953, 0.0263290386646986, 0.0263346768915653, 0.0263405535370111, 0.0263466481119394, 0.0263528991490602, 0.0263594053685665, 0.0263660717755556, 0.0263729747384787, 0.0263800490647554, 0.0263873748481274, 0.0263948738574982, 0.0264025684446096, 0.0264104232192039, 0.0264185834676027, 0.0264269188046455, 0.0264354217797518, 0.0264441501349211, 0.0264530926942825, 0.0264622438699007, 0.0264716241508722, 0.0264811906963587, 0.0264909248799086, 0.0265009086579084, 0.0265110731124878, 0.0265214946120977, 0.026532081887126, 0.0265428740531206, 0.0265538524836302, 0.0265650730580091, 0.0265764016658068, 0.0265880338847637, 0.0265998169779778, 0.0266118478029966, 0.0266240648925304, 0.0266365259885788, 0.0266491826623678, 0.0266620106995106, 0.0266750939190388, 0.0266883447766304, 0.0267017744481564, 0.026715436950326, 0.0267293229699135, 0.0267433989793062, 0.0267577022314072, 0.0267721768468618, 0.0267868787050247, 0.0268017873167992, 0.0268168225884438, 0.0268321298062801, 0.0268476642668247, 0.0268633682280779, 0.0268792863935232, 0.0268954243510962, 0.0269117653369904, 0.0269283205270767, 0.0269450433552265, 0.0269620195031166, 0.0269791837781668, 0.0269965510815382, 0.027014123275876, 0.0270318817347288, 0.027049845084548, 0.0270745661109686, 0.0271036755293608, 0.0271334089338779, 0.0271636620163918, 0.0271945334970951, 0.0272259302437305, 0.0272580087184906, 0.0272907391190529, 0.0273239593952894, 0.0273577328771353, 0.0273922234773636, 0.0274272374808788, 0.0274629350751638, 0.0274991225451231, 0.0275358967483044, 0.0275733228772879, 0.0276113338768482, 0.0276499968022108, 0.0276891849935055, 0.0277289263904095, 0.0277692507952452, 0.0278102960437536, 0.0278517957776785, 0.0278939176350832, 0.0279366225004196, 0.0279800798743963, 0.0280239917337894, 0.0280684940516949, 0.0281136427074671, 0.0281593501567841, 0.0282057076692581, 0.0282525885850191, 0.028300054371357, 0.0283482056111097, 0.0283969435840845, 0.0284462049603462, 0.0284960512071848, 0.02854641713202, 0.0285975690931082, 0.0286492723971605, 0.0287014022469521, 0.0287542473524809, 0.0288076139986515, 0.0288617331534624, 0.0289164036512375, 0.028971528634429, 0.0290274079889059, 0.0290838703513145, 0.0291408263146877, 0.0291984304785728, 0.0292565245181322, 0.0293154027312994, 0.0293748006224632, 0.0294347200542688, 0.0294951945543289, 0.0295563228428364, 0.0296180658042431, 0.0296805277466774, 0.0297433827072382, 0.0298068895936012, 0.029871080070734, 0.0299357250332832, 0.030001025646925, 0.0300669111311436, 0.0301334802061319, 0.0302005745470524, 0.0302682537585497, 0.030336519703269, 0.0304053705185652, 0.0304748751223087, 0.030544999986887, 0.0306155476719141, 0.030686778947711, 0.03075853548944, 0.0308310389518738, 0.0309040956199169, 0.030977675691247, 0.0310518089681864, 0.0311267245560884, 0.0312020666897297, 0.0312780886888504, 0.0313546061515808, 0.0314318686723709, 0.0315096527338028, 0.0315879918634892, 0.0316669531166553, 0.031746432185173, 0.0318266935646534, 0.0319074429571629, 0.0319887511432171, 0.0320706106722355, 0.0321532189846039, 0.0322362557053566, 0.032320037484169, 0.0324042476713657, 0.0324891395866871, 0.0325747132301331, 0.0326607152819633, 0.0327473990619183, 0.0328346416354179, 0.0329350270330906, 0.0330467969179153, 0.0331587195396423, 0.0332710109651089, 0.0333837047219276, 0.0334967002272606, 0.0336098521947861, 0.033723346889019, 0.0338371358811855, 0.0339513495564461, 0.0340657122433186, 0.0341804996132851, 0.0342955775558949, 0.0344108752906322, 0.0345265977084637, 0.0346425287425518, 0.0347587652504444, 0.0348754115402699, 0.0349923484027386, 0.0351094454526901, 0.0352269485592842, 0.0353446938097477, 0.0354628525674343, 0.0355813018977642, 0.0356999672949314, 0.0358189195394516, 0.0359382331371307, 0.0360578931868076, 0.0361778475344181, 0.0362980291247368, 0.0364186801016331, 0.0365395061671734, 0.0366606153547764, 0.0367820039391518, 0.036903765052557, 0.0370258577167988, 0.0371482595801353, 0.0372708700597286, 0.0373938344419003, 0.0375170968472958, 0.0376407727599144, 0.0377647429704666, 0.0378888621926308, 0.0380132719874382, 0.0381380468606949, 0.0382632203400135, 0.0383886396884918, 0.0385143272578716, 0.0386405065655708, 0.0387668535113335, 0.0388934090733528, 0.0390202552080154, 0.0391474701464176, 0.0392750911414623, 0.0394030138850212, 0.0395311377942562, 0.0396595597267151, 0.0397882834076881, 0.0399174764752388, 0.0400468334555626, 0.0401764735579491, 0.040306530892849, 0.0404368303716183, 0.0405674017965794, 0.0406982600688934, 0.0408294126391411, 0.0409609787166119, 0.0410928428173065, 0.0412249267101288, 0.0413573607802391, 0.0414900220930576, 0.0416231639683247, 0.0417564697563648, 0.041890125721693, 0.042024128139019, 0.0421583727002144, 0.0422928221523762, 0.0424277633428574, 0.0425629355013371, 0.0426984392106533, 0.0428341887891293, 0.0429702177643776, 0.0431066043674946, 0.043243270367384, 0.0433802977204323, 0.0435176827013493, 0.0436552166938782, 0.043793112039566, 0.0439314171671867, 0.0440698824822903, 0.044208712875843, 0.0443478226661682, 0.044487290084362, 0.0446271076798439, 0.0447670146822929, 0.0449074171483517, 0.0450480319559574, 0.0451890677213669, 0.0453303307294846, 0.0454718880355358, 0.0456086397171021, 0.0457392558455467, 0.0458696074783802, 0.0459998250007629, 0.0461297072470188, 0.0462594032287598, 0.0463888831436634, 0.0465180762112141, 0.0466470643877983, 0.0467758178710938, 0.046904344111681, 0.0470325984060764, 0.0471606515347958, 0.0472884774208069, 0.0474160611629486, 0.04754339158535, 0.0476705133914948, 0.0477974005043507, 0.047924030572176, 0.0480504557490349, 0.048176608979702, 0.0483025424182415, 0.0484282597899437, 0.0485537573695183, 0.0486789867281914, 0.0488039404153824, 0.0489287748932838, 0.0490532629191875, 0.0491775944828987, 0.0493016541004181, 0.049425482749939, 0.0495490841567516, 0.0496724583208561, 0.0497955866158009, 0.0499184653162956, 0.0500411130487919, 0.0501635633409023, 0.0502857379615307, 0.0504076816141605, 0.0505294427275658, 0.050650916993618, 0.0507721677422523, 0.0508931949734688, 0.0510139800608158, 0.0511345341801643, 0.0512548685073853, 0.0513749495148659, 0.0514947809278965, 0.0516143813729286, 0.0517337992787361, 0.0518529340624809, 0.0519718416035175, 0.0520905368030071, 0.0522089600563049, 0.0523271821439266, 0.0524451658129692, 0.0525629110634327, 0.0526804067194462, 0.0527976863086224, 0.0529147349298, 0.0530315190553665, 0.0531480722129345, 0.0532644465565681, 0.0533805377781391, 0.0534963943064213, 0.0536120496690273, 0.0537274368107319, 0.0538425929844379, 0.0539575479924679, 0.0540722496807575, 0.054186686873436, 0.0543008930981159, 0.0544149205088615, 0.0545286759734154, 0.0546421930193901, 0.0547554939985275, 0.0548685342073441, 0.0549813695251942, 0.0550939776003361, 0.0552063286304474, 0.0553184375166893, 0.0554303228855133, 0.0555419921875, 0.0556533858180046, 0.0557645633816719, 0.0558755435049534, 0.0559862367808819, 0.056096725165844, 0.0562069825828075, 0.0563169755041599, 0.0564267486333847, 0.0565363094210625, 0.0566456280648708, 0.0567546747624874, 0.0568635351955891, 0.0569721423089504, 0.0570805035531521, 0.0571886375546455, 0.0572965554893017, 0.0574042201042175, 0.0575074069201946, 0.0576096698641777, 0.0577114783227444, 0.0578127726912498, 0.0579137355089188, 0.058014128357172, 0.0581141486763954, 0.0582135953009129, 0.0583127178251743, 0.0584112890064716, 0.0585094466805458, 0.0586071200668812, 0.058704387396574, 0.0588011406362057, 0.0588974617421627, 0.0589933358132839, 0.0590886808931828, 0.0591835975646973, 0.0592781044542789, 0.0593721270561218, 0.0594656281173229, 0.059558779001236, 0.0596513636410236, 0.0597435794770718, 0.0598352961242199, 0.059926550835371, 0.0600173287093639, 0.0601077266037464, 0.0601975545287132, 0.0602870136499405, 0.0603759475052357, 0.060464471578598, 0.0605525001883507, 0.0606400929391384, 0.0607272349298, 0.0608139224350452, 0.0609000846743584, 0.0609858855605125, 0.0610712021589279, 0.061156015843153, 0.0612403713166714, 0.0613243170082569, 0.0614077225327492, 0.0614907592535019, 0.0615732856094837, 0.0616553910076618, 0.0617370381951332, 0.0618182048201561, 0.0618988685309887, 0.0619791150093079, 0.0620589070022106, 0.0621382370591164, 0.0622171349823475, 0.0622955523431301, 0.0623735189437866, 0.0624509789049625, 0.0625280290842056, 0.0626045763492584, 0.0626807361841202, 0.0627563297748566, 0.0628315731883049, 0.0629062652587891, 0.062980592250824, 0.0630543977022171, 0.0631277859210968, 0.0632006302475929, 0.0632731318473816, 0.0633451119065285, 0.0634166598320007, 0.0634876936674118, 0.063558354973793, 0.0636284649372101, 0.0636981651186943, 0.0637673810124397, 0.0638361945748329, 0.0639044791460037, 0.0639723837375641, 0.0640397965908051, 0.0641067028045654, 0.0641731917858124, 0.0642392188310623, 0.0643047466874123, 0.0643698647618294, 0.0644345134496689, 0.0644987225532532, 0.0645624920725822, 0.0646257326006889, 0.0646885558962822, 0.0647508874535561, 0.0648127645254135, 0.0648742169141769, 0.0649351924657822, 0.0649956688284874, 0.0650558173656464, 0.065115362405777, 0.0651745349168777, 0.0652332007884979, 0.0652914196252823, 0.0653491392731667, 0.0654065385460854, 0.0654533728957176, 0.0654915794730186, 0.0655295178294182, 0.0655672550201416, 0.0656047463417053, 0.0656420886516571, 0.0656791478395462, 0.0657160207629204, 0.0657526254653931, 0.065789058804512, 0.0658252388238907, 0.065861240029335, 0.0658969655632973, 0.0659325271844864, 0.065967820584774, 0.0660029053688049, 0.0660377591848373, 0.0660724490880966, 0.066106878221035, 0.0661410912871361, 0.0661750733852386, 0.0662088319659233, 0.0662423893809319, 0.0662757158279419, 0.066308818757534, 0.06634172052145, 0.0663743913173676, 0.0664068385958672, 0.06643907725811, 0.0664710626006126, 0.0665028616786003, 0.0665344446897507, 0.0665657669305801, 0.0665969029068947, 0.0666278228163719, 0.0666584819555283, 0.0666889697313309, 0.0667192414402962, 0.06674924492836, 0.0667790472507477, 0.0668086111545563, 0.0668380036950111, 0.0668671429157257, 0.0668960437178612, 0.0669247508049011, 0.0669532492756844, 0.0669814795255661, 0.0670095458626747, 0.0670373439788818, 0.0670649707317352, 0.0670923590660095, 0.0671194940805435, 0.067146435379982, 0.0671731233596802, 0.067199632525444, 0.0672259107232094, 0.0672519579529762, 0.0672778114676476, 0.0673034265637398, 0.0673288181424141, 0.0673540011048317, 0.0673789829015732, 0.0674036890268326, 0.0674282163381577, 0.0674525424838066, 0.0674765855073929, 0.0675004571676254, 0.0675241053104401, 0.0675474926829338, 0.0675707086920738, 0.0675936788320541, 0.0676164180040359, 0.0676389709115028, 0.06766127794981, 0.0676833763718605, 0.0677052438259125, 0.0677268952131271, 0.0677483305335045, 0.0677695423364639, 0.0677905231714249, 0.0678112953901291, 0.067831851541996, 0.0678521618247032, 0.0678722858428955, 0.0678921714425087, 0.0679118484258652, 0.0679312944412231, 0.0679505169391632, 0.0679695308208466, 0.0679883360862732, 0.0680068880319595, 0.0680252388119698, 0.0680433511734009, 0.0680612623691559, 0.0680789723992348, 0.0680964216589928, 0.068113662302494, 0.0681307092308998, 0.0681474879384041, 0.0681640803813934, 0.0681727603077888, 0.0681711062788963, 0.0681700706481934, 0.0681697949767113, 0.068170353770256, 0.0681717395782471, 0.0681737437844276, 0.0681765824556351, 0.0681802928447723, 0.068184569478035, 0.0681896954774857, 0.0681955516338348, 0.0682023167610168, 0.0682097002863884, 0.0682178437709808, 0.0682268738746643, 0.0682365372776985, 0.0682470202445984, 0.0682582706212997, 0.0682703331112862, 0.0682831034064293, 0.0682965591549873, 0.0683109685778618, 0.0683260783553123, 0.0683418735861778, 0.0683584287762642, 0.0683758705854416, 0.0683939456939697, 0.0684128627181053, 0.0684325695037842, 0.0684529989957809, 0.068474106490612, 0.0684960335493088, 0.0685188621282578, 0.0685423165559769, 0.0685665234923363, 0.0685916319489479, 0.0686173513531685, 0.0686439052224159, 0.0686711668968201, 0.0686992853879929, 0.0687281340360641, 0.0687577128410339, 0.068788193166256, 0.0688192397356033, 0.0688511058688164, 0.0688837245106697, 0.0689172372221947, 0.0689514502882957, 0.0689863488078117, 0.0690221413969994, 0.0690585672855377, 0.0690958127379417, 0.0691338032484055, 0.0691727101802826, 0.0692121535539627, 0.0692524388432503, 0.0692936033010483, 0.069335475564003, 0.069378025829792, 0.0694213435053825, 0.0694656223058701, 0.0695103853940964, 0.0695560351014137, 0.0696025863289833, 0.069649763405323, 0.069697692990303, 0.0697463154792786, 0.0697959065437317, 0.0698461160063744, 0.0698970854282379, 0.0699490234255791, 0.0700015053153038, 0.0700547471642494, 0.0701088160276413, 0.0701637119054794, 0.0702193677425385, 0.0702756494283676, 0.0703328847885132, 0.0703907459974289, 0.0704493746161461, 0.0705087631940842, 0.0705690309405327, 0.0706299990415573, 0.0706916525959969, 0.0707542076706886, 0.0708174407482147, 0.0708814486861229, 0.0709462016820908, 0.0710117965936661, 0.0710780695080757, 0.0711451098322868, 0.071213111281395, 0.0712816566228867, 0.0713509768247604, 0.0714210420846939, 0.0714920163154602, 0.0715636685490608, 0.0716360881924629, 0.0717093199491501, 0.0718096718192101, 0.0719382762908936, 0.0720680356025696, 0.0721989497542381, 0.0723307579755783, 0.072463683784008, 0.0725976973772049, 0.0727327316999435, 0.0728687047958374, 0.0730059891939163, 0.0731441229581833, 0.0732832849025726, 0.0734236016869545, 0.0735650584101677, 0.0737073570489883, 0.0738508030772209, 0.0739953443408012, 0.0741409435868263, 0.074287585914135, 0.0744351372122765, 0.0745839178562164, 0.0747336894273758, 0.0748844668269157, 0.0750364810228348, 0.0751893520355225, 0.0753433182835579, 0.0754983425140381, 0.075654461979866, 0.0758116617798805, 0.0759697481989861, 0.0761291310191154, 0.0762894004583359, 0.0764506682753563, 0.0766131430864334, 0.0767766758799553, 0.0769411399960518, 0.0771066918969154, 0.0772733837366104, 0.0774411037564278, 0.0776098221540451, 0.0777794942259789, 0.0779504254460335, 0.0781223252415657, 0.0782952457666397, 0.0784693956375122, 0.0786443278193474, 0.0788204073905945, 0.0789975672960281, 0.0791759192943573, 0.0793551579117775, 0.0795353725552559, 0.079716868698597, 0.0798992663621902, 0.0800826698541641, 0.0802672579884529, 0.08045294880867, 0.0806394889950752, 0.0808271765708923, 0.0810160264372826, 0.0812057554721832, 0.081396609544754, 0.0815884917974472, 0.0817815512418747, 0.0819755643606186, 0.0821705833077431, 0.082366868853569, 0.0825639069080353, 0.0827621743083, 0.0829614326357841, 0.0831618681550026, 0.0833632051944733, 0.0835655927658081, 0.0837691873311996, 0.083973690867424, 0.0841792672872543, 0.0843858867883682, 0.0845937505364418, 0.084802433848381, 0.0850123092532158, 0.0852232724428177, 0.0854351073503494, 0.0856481567025185, 0.0858621075749397, 0.0860772803425789, 0.0862933546304703, 0.0865105763077736, 0.0867289900779724, 0.0869481712579727, 0.0871684849262238, 0.0873899012804031, 0.0876124352216721, 0.0878359451889992, 0.0880604460835457, 0.0882861614227295, 0.0885128378868103, 0.0887405499815941, 0.0889694169163704, 0.0891993120312691, 0.0894300565123558, 0.0896620377898216, 0.089906245470047, 0.0901622921228409, 0.0904181450605392, 0.0906737297773361, 0.0909291878342628, 0.0911843925714493, 0.091439425945282, 0.0916942954063416, 0.0919488370418549, 0.0922033861279488, 0.0924576073884964, 0.0927116945385933, 0.0929655879735947, 0.0932191833853722, 0.0934726893901825, 0.0937260314822197, 0.0939790084958076, 0.0942319557070732, 0.0944846123456955, 0.0947370752692223, 0.0949894040822983, 0.0952414348721504, 0.0954934731125832, 0.0957451835274696, 0.0959966257214546, 0.0962479785084724, 0.0964990332722664, 0.0967500284314156, 0.0970007255673409, 0.0972512662410736, 0.0975016057491302, 0.0977517813444138, 0.098001666367054, 0.0982514470815659, 0.0985009372234344, 0.0987504348158836, 0.0989995375275612, 0.0992485135793686, 0.0994972884654999, 0.0997458919882774, 0.0999942421913147, 0.100242428481579, 0.100490398705006, 0.100738219916821, 0.100985795259476, 0.101233266294003, 0.101480476558208, 0.101727463304996, 0.101974308490753, 0.10222090035677, 0.10246729105711, 0.102713562548161, 0.10295956581831, 0.103205412626266, 0.103451058268547, 0.103696435689926, 0.103941723704338, 0.104186818003654, 0.104431644082069, 0.104676380753517, 0.104920789599419, 0.105165094137192, 0.105409145355225, 0.105653032660484, 0.105896659195423, 0.106140211224556, 0.106383517384529, 0.106626614928246, 0.106869451701641, 0.10711220651865, 0.107354685664177, 0.107597000896931, 0.107839167118073, 0.108081094920635, 0.108322791755199, 0.108564354479313, 0.108805641531944, 0.109046787023544, 0.109287805855274, 0.1095285192132, 0.109769053757191, 0.110009379684925, 0.110249564051628, 0.110489562153816, 0.110729306936264, 0.110968925058842, 0.11120830476284, 0.111447431147099, 0.111686423420906, 0.11192525178194, 0.112163826823235, 0.112402305006981, 0.112640418112278, 0.112878434360027, 0.113116286695004, 0.113353885710239, 0.113591313362122, 0.113828517496586, 0.114065557718277, 0.114302434027195, 0.114513926208019, 0.114698395133018, 0.114881940186024, 0.115064568817616, 0.11524636298418, 0.115427270531654, 0.115607209503651, 0.115786381065845, 0.115964606404305, 0.116141960024834, 0.116318441927433, 0.11649402230978, 0.11666876077652, 0.116842605173588, 0.117015510797501, 0.117187581956387, 0.117358699440956, 0.117529064416885, 0.117698490619659, 0.117867022752762, 0.118034645915031, 0.118201442062855, 0.118367269635201, 0.118532344698906, 0.118696421384811, 0.118859700858593, 0.119022034108639, 0.119183540344238, 0.119344092905521, 0.119503803551197, 0.119662664830685, 0.119820609688759, 0.11997763812542, 0.120133809745312, 0.120289109647274, 0.120443589985371, 0.120597086846828, 0.120749741792679, 0.120901510119438, 0.121052384376526, 0.121202386915684, 0.121351487934589, 0.121499761939049, 0.121647119522095, 0.121793605387211, 0.121939204633236, 0.122083887457848, 0.122227698564529, 0.122370667755604, 0.122512765228748, 0.122653923928738, 0.122794218361378, 0.122933588922024, 0.123072192072868, 0.123209819197655, 0.123346611857414, 0.123482465744019, 0.123617462813854, 0.123751565814018, 0.123884841799736, 0.124017186462879, 0.124148644506931, 0.124279208481312, 0.124408960342407, 0.124537743628025, 0.1246657371521, 0.124792814254761, 0.12491898983717, 0.125044286251068, 0.125168681144714, 0.12529219686985, 0.125414878129959, 0.125536635518074, 0.12565752863884, 0.125777542591095, 0.125896647572517, 0.126014918088913, 0.126132264733315, 0.126248747110367, 0.126364335417747, 0.126479029655457, 0.126592814922333, 0.126705780625343, 0.126817867159843, 0.126929014921188, 0.127039328217506, 0.127148732542992, 0.127257272601128, 0.127364933490753, 0.127471715211868, 0.127577558159828, 0.1276825517416, 0.127786681056023, 0.127889931201935, 0.127992302179337, 0.128093764185905, 0.128194347023964, 0.128294050693512, 0.128392890095711, 0.128490850329399, 0.128577947616577, 0.128654822707176, 0.128731533885002, 0.128808125853539, 0.128884568810463, 0.128960847854614, 0.129037022590637, 0.129113033413887, 0.129188939929008, 0.129264652729034, 0.129340261220932, 0.129415720701218, 0.129491046071053, 0.129566192626953, 0.129641219973564, 0.129716128110886, 0.129790857434273, 0.129865482449532, 0.129939943552017, 0.130014285445213, 0.130088448524475, 0.13016252219677, 0.130236402153969, 0.130310148000717, 0.130383789539337, 0.130457252264023, 0.130530580878258, 0.130603790283203, 0.130676820874214, 0.130749747157097, 0.130822524428368, 0.130895152688026, 0.130967631936073, 0.131040006875992, 0.131112188100815, 0.131184265017509, 0.131256192922592, 0.131327956914902, 0.131399616599083, 0.131471112370491, 0.131542459130287, 0.131613686680794, 0.13168478012085, 0.131755709648132, 0.131826519966125, 0.131897151470184, 0.131967648863792, 0.132038041949272, 0.132108271121979, 0.132178366184235, 0.132248312234879, 0.132318153977394, 0.132387802004814, 0.132457330822945, 0.132526680827141, 0.132595926523209, 0.132665053009987, 0.13273398578167, 0.132802814245224, 0.132871463894844, 0.132940009236336, 0.133008420467377, 0.133076697587967, 0.133144780993462, 0.133212760090828, 0.133280619978905, 0.133348271250725, 0.133415848016739, 0.133483231067657, 0.133550494909286, 0.133617624640465, 0.13368459045887, 0.133751466870308, 0.13381814956665, 0.133884713053703, 0.133951112627983, 0.134017437696457, 0.134083569049835, 0.134149521589279, 0.134215399622917, 0.134281113743782, 0.134346678853035, 0.134412109851837, 0.13447742164135, 0.134542554616928, 0.134607568383217, 0.134672418236732, 0.134737148880959, 0.134801760315895, 0.134866178035736, 0.134930476546288, 0.134994640946388, 0.135058656334877, 0.135122567415237, 0.135186299681664, 0.135249868035316, 0.135313332080841, 0.135376617312431, 0.135439798235893, 0.135502830147743, 0.135579138994217, 0.135670259594917, 0.13576178252697, 0.135853752493858, 0.135946184396744, 0.136039063334465, 0.136132389307022, 0.136226162314415, 0.136320352554321, 0.136415049433708, 0.136510148644447, 0.136605694890022, 0.136701658368111, 0.136798113584518, 0.136895000934601, 0.136992320418358, 0.137090116739273, 0.137188360095024, 0.13728703558445, 0.13738614320755, 0.137485697865486, 0.137585744261742, 0.137686163187027, 0.137787088751793, 0.137888431549072, 0.137990221381187, 0.138092443346977, 0.138195127248764, 0.138298287987709, 0.138401851058006, 0.138505905866623, 0.138610363006592, 0.138715282082558, 0.138820633292198, 0.138926446437836, 0.139032706618309, 0.139139413833618, 0.139246568083763, 0.139354154467583, 0.139462172985077, 0.139570668339729, 0.139679580926895, 0.13978898525238, 0.139898791909218, 0.140009060502052, 0.140119791030884, 0.140230938792229, 0.140342548489571, 0.140454605221748, 0.140567123889923, 0.140680059790611, 0.140793442726135, 0.140907302498817, 0.141021534800529, 0.141136288642883, 0.141251474618912, 0.141367062926292, 0.141483157873154, 0.141599670052528, 0.1417166441679, 0.141834035515785, 0.141951903700829, 0.142070189118385, 0.142188906669617, 0.142308130860329, 0.142427742481232, 0.142547845840454, 0.142668351531029, 0.1427893191576, 0.142910733819008, 0.143032595515251, 0.143154919147491, 0.143277674913406, 0.143400907516479, 0.143524527549744, 0.143648624420166, 0.143773183226585, 0.143898159265518, 0.144023612141609, 0.144149482250214, 0.144275799393654, 0.144402578473091, 0.144529774785042, 0.144657447934151, 0.144785553216934, 0.144914120435715, 0.14504311978817, 0.1451725512743, 0.145302459597588, 0.145432785153389, 0.145563587546349, 0.145694807171822, 0.145826503634453, 0.145958617329597, 0.146091192960739, 0.146224185824394, 0.146357655525208, 0.146491557359695, 0.14662592113018, 0.14676071703434, 0.146897211670876, 0.147034034132957, 0.147171303629875, 0.147309079766273, 0.147447258234024, 0.147585898637772, 0.147724986076355, 0.147864550352097, 0.148004576563835, 0.14814504981041, 0.148285955190659, 0.148427307605743, 0.148569166660309, 0.148711487650871, 0.148854210972786, 0.148997411131859, 0.149141058325768, 0.149285182356834, 0.149429753422737, 0.149574786424637, 0.14972023665905, 0.149866193532944, 0.150012582540512, 0.150159418582916, 0.15030674636364, 0.150454476475716, 0.150602713227272, 0.150751367211342, 0.150900512933731, 0.151050075888634, 0.151200100779533, 0.151350617408752, 0.151501536369324, 0.151652976870537, 0.151804819703102, 0.151957109570503, 0.152109906077385, 0.152263134717941, 0.152416825294495, 0.152570948004723, 0.15272556245327, 0.152880609035492, 0.15303610265255, 0.153192058205605, 0.153348460793495, 0.153505340218544, 0.153662666678429, 0.153820425271988, 0.153978690505028, 0.154137372970581, 0.154296532273293, 0.15445613861084, 0.154616191983223, 0.154776707291603, 0.154937669634819, 0.155099123716354, 0.155260995030403, 0.15542334318161, 0.155586123466492, 0.15574936568737, 0.155913099646568, 0.156077235937119, 0.156241849064827, 0.156406939029694, 0.156572461128235, 0.156738445162773, 0.156904876232147, 0.157071799039841, 0.157239124178886, 0.157406955957413, 0.157575190067291, 0.157743915915489, 0.157913073897362, 0.158082708716393, 0.158252790570259, 0.158423349261284, 0.158594340085983, 0.158765777945518, 0.158937692642212, 0.15911003947258, 0.159282878041267, 0.159456133842468, 0.159629881381989, 0.159804046154022, 0.159978702664375, 0.160153806209564, 0.160329356789589, 0.160505354404449, 0.160681813955307, 0.160858735442162, 0.161036089062691, 0.161213934421539, 0.161392197012901, 0.161570966243744, 0.161750167608261, 0.161929845809937, 0.162109941244125, 0.16229048371315, 0.162471503019333, 0.162652969360352, 0.162835389375687, 0.163017451763153, 0.163199931383133, 0.163382917642593, 0.163566321134567, 0.163750156760216, 0.163934469223022, 0.164119228720665, 0.164304405450821, 0.164490059018135, 0.164676159620285, 0.164862722158432, 0.165049731731415, 0.165237173438072, 0.165425091981888, 0.165613412857056, 0.165802210569382, 0.165991455316544, 0.166181147098541, 0.166371300816536, 0.166561901569366, 0.16675291955471, 0.166944399476051, 0.167136371135712, 0.167328760027885, 0.167521595954895, 0.167714864015579, 0.167908623814583, 0.168102785944939, 0.168297439813614, 0.168492525815964, 0.168688043951988, 0.168884053826332, 0.169080480933189, 0.169277355074883, 0.169474676251411, 0.169672459363937, 0.169870674610138, 0.170069381594658, 0.170268505811691, 0.17046807706356, 0.170668110251427, 0.170868590474129, 0.171069502830505, 0.171270862221718, 0.171472683548927, 0.171674981713295, 0.171877682209015, 0.172080874443054, 0.172284454107285, 0.172488555312157, 0.172693073749542, 0.172898039221764, 0.17310343682766, 0.173309326171875, 0.173515617847443, 0.173722416162491, 0.17392960190773, 0.174137264490128, 0.174345403909683, 0.174553960561752, 0.174762979149818, 0.174972414970398, 0.175182327628136, 0.175392687320709, 0.175603494048119, 0.175814747810364, 0.176026463508606, 0.176238611340523, 0.176451221108437, 0.176664277911186, 0.17687776684761, 0.177091717720032, 0.177306115627289, 0.177520960569382, 0.177736282348633, 0.177952021360397, 0.178168222308159, 0.178384840488434, 0.178601965308189, 0.178819507360458, 0.179037496447563, 0.179255962371826, 0.179474830627441, 0.179694205522537, 0.179913967847824, 0.18013422191143, 0.180354908108711, 0.18057607114315, 0.18079762160778, 0.181019678711891, 0.181242153048515, 0.181465089321136, 0.181688487529755, 0.181912302970886, 0.182136595249176, 0.18236131966114, 0.182586506009102, 0.182812139391899, 0.183038219809532, 0.183281525969505, 0.183541849255562, 0.183801934123039, 0.184061765670776, 0.184321388602257, 0.184580773115158, 0.184839934110641, 0.185098841786385, 0.185357540845871, 0.185616016387939, 0.185874223709106, 0.186132252216339, 0.186389982700348, 0.186647534370422, 0.186904847621918, 0.187161922454834, 0.187418788671494, 0.187675386667252, 0.187931761145592, 0.188187927007675, 0.188443839550018, 0.188699528574944, 0.188954994082451, 0.189210206270218, 0.189465209841728, 0.189719974994659, 0.189974501729012, 0.190228804945946, 0.190482884645462, 0.19073674082756, 0.190990328788757, 0.191243708133698, 0.191496878862381, 0.191749781370163, 0.192002460360527, 0.192254930734634, 0.192507147789001, 0.192759141325951, 0.193010911345482, 0.193262442946434, 0.193513736128807, 0.193764805793762, 0.194015651941299, 0.194266259670258, 0.194516614079475, 0.194766774773598, 0.195016667246819, 0.195266366004944, 0.19551582634449, 0.195765048265457, 0.196014031767845, 0.196262806653976, 0.196511328220367, 0.196759611368179, 0.197007670998573, 0.197255522012711, 0.197503119707108, 0.197750493884087, 0.197997614741325, 0.198244541883469, 0.198491230607033, 0.198737680912018, 0.198983907699585, 0.199229881167412, 0.199475631117821, 0.199721172451973, 0.199966460466385, 0.200211524963379, 0.200456351041794, 0.20070093870163, 0.200945317745209, 0.20118947327137, 0.20143336057663, 0.201677039265633, 0.201920494437218, 0.202163696289062, 0.202406689524651, 0.202649429440498, 0.202891975641251, 0.203134253621101, 0.203376322984695, 0.203618139028549, 0.203859731554985, 0.204101115465164, 0.204342246055603, 0.204583138227463, 0.204823821783066, 0.20506426692009, 0.205304458737373, 0.205544456839561, 0.205784186720848, 0.206023707985878, 0.206263020634651, 0.206502065062523, 0.206740885972977, 0.206979498267174, 0.207217842340469, 0.207455977797508, 0.207693874835968, 0.20793154835701, 0.208155333995819, 0.20836541056633, 0.208574399352074, 0.208782345056534, 0.208989217877388, 0.209194988012314, 0.209399744868279, 0.209603413939476, 0.209806025028229, 0.210007563233376, 0.210208043456078, 0.210407450795174, 0.210605800151825, 0.21080307662487, 0.210999295115471, 0.211194455623627, 0.211388498544693, 0.211581528186798, 0.21177351474762, 0.211964398622513, 0.212154224514961, 0.212342947721481, 0.212530642747879, 0.212717279791832, 0.212902843952179, 0.213087350130081, 0.213270768523216, 0.213453143835068, 0.213634461164474, 0.213814675807953, 0.213993847370148, 0.214171946048737, 0.214348986744881, 0.21452496945858, 0.214699879288673, 0.214873716235161, 0.215046495199203, 0.215218216180801, 0.215388864278793, 0.215558439493179, 0.215726956725121, 0.215894415974617, 0.216060802340508, 0.216226115822792, 0.216390371322632, 0.216553568840027, 0.216715693473816, 0.21687676012516, 0.217036738991737, 0.217195674777031, 0.217353567481041, 0.217510357499123, 0.21766608953476, 0.21782074868679, 0.217974364757538, 0.218126893043518, 0.218278378248215, 0.218428790569305, 0.21857813000679, 0.218726396560669, 0.218873605132103, 0.219019755721092, 0.219164833426476, 0.219308868050575, 0.219451814889908, 0.219593703746796, 0.219734519720078, 0.219874277710915, 0.220012962818146, 0.220150589942932, 0.220287144184113, 0.220422640442848, 0.220557078719139, 0.220690429210663, 0.220822751522064, 0.220953956246376, 0.221084132790565, 0.221213236451149, 0.221341267228127, 0.221468240022659, 0.221594139933586, 0.221718981862068, 0.221842780709267, 0.221965491771698, 0.222087129950523, 0.222207695245743, 0.222327217459679, 0.222445666790009, 0.222563043236732, 0.222679376602173, 0.222794622182846, 0.222908809781075, 0.223021924495697, 0.223134011030197, 0.223244965076447, 0.223354920744896, 0.223463773727417, 0.223571568727493, 0.223678320646286, 0.22378396987915, 0.223873376846313, 0.223946735262871, 0.224019318819046, 0.224091157317162, 0.224162220954895, 0.224232539534569, 0.224302068352699, 0.224370837211609, 0.224438846111298, 0.224506095051765, 0.224572584033012, 0.224638298153877, 0.224703252315521, 0.224767431616783, 0.224830880761147, 0.224893540143967, 0.224955424666405, 0.225016579031944, 0.225076943635941, 0.225136548280716, 0.225195407867432, 0.225253477692604, 0.225310802459717, 0.225367352366447, 0.225423142313957, 0.225478187203407, 0.225532427430153, 0.2255859375, 0.225638672709465, 0.225690647959709, 0.225741863250732, 0.225792303681374, 0.225841984152794, 0.225890919566154, 0.225939050316811, 0.225986465811729, 0.226033076643944, 0.226078927516937, 0.226124048233032, 0.226168379187584, 0.226211950182915, 0.226254761219025, 0.226296797394753, 0.226338088512421, 0.226378604769707, 0.226418361067772, 0.226457357406616, 0.226495578885078, 0.226533025503159, 0.226569756865501, 0.226605668663979, 0.226640850305557, 0.226675257086754, 0.22670890390873, 0.226741775870323, 0.226773902773857, 0.22680526971817, 0.22683584690094, 0.22686567902565, 0.226894736289978, 0.226923048496246, 0.226950585842133, 0.226977348327637, 0.227003365755081, 0.227028608322144, 0.227053090929985, 0.227076798677444, 0.227099746465683, 0.227121949195862, 0.227143362164497, 0.227164030075073, 0.227183938026428, 0.227203071117401, 0.227221444249153, 0.227239057421684, 0.227255880832672, 0.2272719591856, 0.227287277579308, 0.227301836013794, 0.227315634489059, 0.227328643202782, 0.227340921759605, 0.227352425456047, 0.227363139390945, 0.227373138070107, 0.227382346987724, 0.22739078104496, 0.227398455142975, 0.22740538418293, 0.227411523461342, 0.227416917681694, 0.227421551942825, 0.227425411343575, 0.227428510785103, 0.227430865168571, 0.227432429790497, 0.22743321955204, 0.227433279156685, 0.227432548999786, 0.227431058883667, 0.227428913116455, 0.227426841855049, 0.227424889802933, 0.227423071861267, 0.227421432733536, 0.227419897913933, 0.227418541908264, 0.227417320013046, 0.227416276931763, 0.227415353059769, 0.227414563298225, 0.227413952350616, 0.227413490414619, 0.227413147687912, 0.227412968873978, 0.227412939071655, 0.227413058280945, 0.227413311600685, 0.227413713932037, 0.227414280176163, 0.227414965629578, 0.227415829896927, 0.227416843175888, 0.227417975664139, 0.227419301867485, 0.227420717477798, 0.227422311902046, 0.227424055337906, 0.227425932884216, 0.227427959442139, 0.227430135011673, 0.227432489395142, 0.2274349629879, 0.227437600493431, 0.227440357208252, 0.227443262934685, 0.227446332573891, 0.22744956612587, 0.227452918887138, 0.227456420660019, 0.227460071444511, 0.227463886141777, 0.227467834949493, 0.227471932768822, 0.227476179599762, 0.227480590343475, 0.227485120296478, 0.227489799261093, 0.227494657039642, 0.227499634027481, 0.227504774928093, 0.227510035037994, 0.22751547396183, 0.227521061897278, 0.227526769042015, 0.227532655000687, 0.227538660168648, 0.227544829249382, 0.227551147341728, 0.227557614445686, 0.227564215660095, 0.227570950984955, 0.22757788002491, 0.227584928274155, 0.227592140436172, 0.22759947180748, 0.227606981992722, 0.227614611387253, 0.227622404694557, 0.227630347013474, 0.227638423442841, 0.227646663784981, 0.227655038237572, 0.227663561701775, 0.227672234177589, 0.227681070566177, 0.227690026164055, 0.227699145674706, 0.227708414196968, 0.227717831730843, 0.227727383375168, 0.227737113833427, 0.227746963500977, 0.227756962180138, 0.227767109870911, 0.227777421474457, 0.227787852287292, 0.227798447012901, 0.227809190750122, 0.227820083498955, 0.227831125259399, 0.227842316031456, 0.227853626012802, 0.227865114808083, 0.227876752614975, 0.227888509631157, 0.227900445461273, 0.227912500500679, 0.227924719452858, 0.22793710231781, 0.22796006500721, 0.227994188666344, 0.228028938174248, 0.228064343333244, 0.228100389242172, 0.228137046098709, 0.228174358606339, 0.228212311863899, 0.228250920772552, 0.228290140628815, 0.228330001235008, 0.228370517492294, 0.228411689400673, 0.228453457355499, 0.228495910763741, 0.228538975119591, 0.228582680225372, 0.228627026081085, 0.228672042489052, 0.228717654943466, 0.228763923048973, 0.228810831904411, 0.22885836660862, 0.228906556963921, 0.228955388069153, 0.229004859924316, 0.22905495762825, 0.229105725884438, 0.229157090187073, 0.229209125041962, 0.229261785745621, 0.229315087199211, 0.229369029402733, 0.229423612356186, 0.22947883605957, 0.229534685611725, 0.229591190814972, 0.22964833676815, 0.22970612347126, 0.229764550924301, 0.229823604226112, 0.229883298277855, 0.229943633079529, 0.230004623532295, 0.230066239833832, 0.2301284968853, 0.23019140958786, 0.230254948139191, 0.230319112539291, 0.230383917689323, 0.230449378490448, 0.230515480041504, 0.23058220744133, 0.230649590492249, 0.230717599391937, 0.230786263942719, 0.23085555434227, 0.230925470590591, 0.230996057391167, 0.231067270040512, 0.231139123439789, 0.231211617588997, 0.231284752488136, 0.231358528137207, 0.231432944536209, 0.23150797188282, 0.231583654880524, 0.23165999352932, 0.231736958026886, 0.231814578175545, 0.231892824172974, 0.231971710920334, 0.232051238417625, 0.232131406664848, 0.232212200760841, 0.232293650507927, 0.232375741004944, 0.232458472251892, 0.232541844248772, 0.232625842094421, 0.232710480690002, 0.232795774936676, 0.23288169503212, 0.232968240976334, 0.23305544257164, 0.233143299818039, 0.233231782913208, 0.233320906758308, 0.23341067135334, 0.233501046895981, 0.233592078089714, 0.23368376493454, 0.233776107430458, 0.233869045972824, 0.233962640166283, 0.234056890010834, 0.234151780605316, 0.234247282147408, 0.234343454241753, 0.234440237283707, 0.234548404812813, 0.234667733311653, 0.234787330031395, 0.234907224774361, 0.235027357935905, 0.235147818922997, 0.235268548130989, 0.235389545559883, 0.23551082611084, 0.23563240468502, 0.23575422167778, 0.235876336693764, 0.235998764634132, 0.23612143099308, 0.236244410276413, 0.236367642879486, 0.236491188406944, 0.236614972352982, 0.236739069223404, 0.236863434314728, 0.236988067626953, 0.237112984061241, 0.237238198518753, 0.237363696098328, 0.237489476799965, 0.237615510821342, 0.237741842865944, 0.237868428230286, 0.237995326519012, 0.238122493028641, 0.238249927759171, 0.238377660512924, 0.238505691289902, 0.238633960485458, 0.238762527704239, 0.238891378045082, 0.239020511507988, 0.239149928092957, 0.239279612898827, 0.239409580826759, 0.239539816975594, 0.239670351147652, 0.239801168441772, 0.239932253956795, 0.240063637495041, 0.240195274353027, 0.240327224135399, 0.240459427237511, 0.240591913461685, 0.240724682807922, 0.240857750177383, 0.240991055965424, 0.24112468957901, 0.241258576512337, 0.241392761468887, 0.241527214646339, 0.241661936044693, 0.24179695546627, 0.241932243108749, 0.242067828774452, 0.242203682661057, 0.242339819669724, 0.242476209998131, 0.242612928152084, 0.242749884724617, 0.242887169122696, 0.243024691939354, 0.243162497878075, 0.243300586938858, 0.243438988924026, 0.243577644228935, 0.243716567754745, 0.243855774402618, 0.243995279073715, 0.244135066866875, 0.244275122880936, 0.244415447115898, 0.244556069374084, 0.244696974754333, 0.244838148355484, 0.244979619979858, 0.245121344923973, 0.24526335299015, 0.245405673980713, 0.245548248291016, 0.245691105723381, 0.245834246277809, 0.245977655053139, 0.246121361851692, 0.246265336871147, 0.246409609913826, 0.246554151177406, 0.246698960661888, 0.246844083070755, 0.246989458799362, 0.247135132551193, 0.247281059622765, 0.24742728471756, 0.247573778033257, 0.247720584273338, 0.247859641909599, 0.247990682721138, 0.248121544718742, 0.248252168297768, 0.248382657766342, 0.248512908816338, 0.248642981052399, 0.248772844672203, 0.248902529478073, 0.249031990766525, 0.249161288142204, 0.249290376901627, 0.249419271945953, 0.249547988176346, 0.24967648088932, 0.249804794788361, 0.249932929873466, 0.250060856342316, 0.250188589096069, 0.250316113233566, 0.250443458557129, 0.250570595264435, 0.250697553157806, 0.250824302434921, 0.250950872898102, 0.251077234745026, 0.251203417778015, 0.251329392194748, 0.251455187797546, 0.251580774784088, 0.251706153154373, 0.251831352710724, 0.251956343650818, 0.2520811855793, 0.252205789089203, 0.252330213785172, 0.252454429864883, 0.252578467130661, 0.252702295780182, 0.252825945615768, 0.252949416637421, 0.253072649240494, 0.253195703029633, 0.253318578004837, 0.253441244363785, 0.253563731908798, 0.253685981035233, 0.253808081150055, 0.253929972648621, 0.25405165553093, 0.254173189401627, 0.254294484853745, 0.254415601491928, 0.254536509513855, 0.254657238721848, 0.254777759313583, 0.254898101091385, 0.25501823425293, 0.255138158798218, 0.255257934331894, 0.255377471446991, 0.255496859550476, 0.25561597943306, 0.255734980106354, 0.255853742361069, 0.255972325801849, 0.256090730428696, 0.256208926439285, 0.256326913833618, 0.256444692611694, 0.256562322378159, 0.256679743528366, 0.256796956062317, 0.256913989782333, 0.257030814886093, 0.257147431373596, 0.257263869047165, 0.257380127906799, 0.257496178150177, 0.257612019777298, 0.257727712392807, 0.257843136787415, 0.257958441972733, 0.258073508739471, 0.258188396692276, 0.258303076028824, 0.258417576551437, 0.258531898260117, 0.258645981550217, 0.258759886026382, 0.258873581886292, 0.258987098932266, 0.259100437164307, 0.25921356678009, 0.25932651758194, 0.25943922996521, 0.259551793336868, 0.25966414809227, 0.259776294231415, 0.259888261556625, 0.260002732276917, 0.260119616985321, 0.260236024856567, 0.260351955890656, 0.260467410087585, 0.26058241724968, 0.260696977376938, 0.260811060667038, 0.260924696922302, 0.261037826538086, 0.261150509119034, 0.261262744665146, 0.2613745033741, 0.261485785245895, 0.261596620082855, 0.261706978082657, 0.261816889047623, 0.261926352977753, 0.262035310268402, 0.262143820524216, 0.262251853942871, 0.262359440326691, 0.262466579675674, 0.262573212385178, 0.262679398059845, 0.262785136699677, 0.26289039850235, 0.262995183467865, 0.263099521398544, 0.263203352689743, 0.263306766748428, 0.263409733772278, 0.263512194156647, 0.263614237308502, 0.263715744018555, 0.263816833496094, 0.263917475938797, 0.264017641544342, 0.264117300510406, 0.264216542243958, 0.26431530714035, 0.264413595199585, 0.264511436223984, 0.264608770608902, 0.264705687761307, 0.264802157878876, 0.264898121356964, 0.264993637800217, 0.265088707208633, 0.26518326997757, 0.265277415513992, 0.265371054410934, 0.265464246273041, 0.265556961297989, 0.265649229288101, 0.265741020441055, 0.265832394361496, 0.265923231840134, 0.266013652086258, 0.266103565692902, 0.266193062067032, 0.266282081604004, 0.266370624303818, 0.266458719968796, 0.266546338796616, 0.2666335105896, 0.266720175743103, 0.266806393861771, 0.266892194747925, 0.266977488994598, 0.267062306404114, 0.267146706581116, 0.267230600118637, 0.267314046621323, 0.26739701628685, 0.267479538917542, 0.267561554908752, 0.26764315366745, 0.267724305391312, 0.267804980278015, 0.267885118722916, 0.267964899539948, 0.268044143915176, 0.268122941255569, 0.268201291561127, 0.268279165029526, 0.268356591463089, 0.268433511257172, 0.268510013818741, 0.268586009740829, 0.268661558628082, 0.268736660480499, 0.268811255693436, 0.268885463476181, 0.268959164619446, 0.26903235912323, 0.269105136394501, 0.269177436828613, 0.26924929022789, 0.269320666790009, 0.269383788108826, 0.269438326358795, 0.269492328166962, 0.26954585313797, 0.269598811864853, 0.269651263952255, 0.269703149795532, 0.269754558801651, 0.269805431365967, 0.26985576748848, 0.269905537366867, 0.269954800605774, 0.2700035572052, 0.270051777362823, 0.270099431276321, 0.270146608352661, 0.270193219184875, 0.270239323377609, 0.270284920930862, 0.27032995223999, 0.270374476909637, 0.270418465137482, 0.270461887121201, 0.270504862070084, 0.270547240972519, 0.270589113235474, 0.270630478858948, 0.270671278238297, 0.270711570978165, 0.27075132727623, 0.270790547132492, 0.270829260349274, 0.270867437124252, 0.270905077457428, 0.270942181348801, 0.270978778600693, 0.271014809608459, 0.271050363779068, 0.271085381507874, 0.271119862794876, 0.271153837442398, 0.271187216043472, 0.271220117807388, 0.271252453327179, 0.271284312009811, 0.271315604448318, 0.271346360445023, 0.271376639604568, 0.271406382322311, 0.271435558795929, 0.271464228630066, 0.2714923620224, 0.271519929170609, 0.271547049283981, 0.271573573350906, 0.271599590778351, 0.271625101566315, 0.271650075912476, 0.271674513816833, 0.271698415279388, 0.27172178030014, 0.271744668483734, 0.271766990423203, 0.271788775920868, 0.27181002497673, 0.271830767393112, 0.271850973367691, 0.271870702505112, 0.271889805793762, 0.271908432245255, 0.271926522254944, 0.271944135427475, 0.271961152553558, 0.271977663040161, 0.271993637084961, 0.27200910449028, 0.272024035453796, 0.27203842997551, 0.272052317857742, 0.27206563949585, 0.272078454494476, 0.2720907330513, 0.272102504968643, 0.272113740444183, 0.272124439477921, 0.272134602069855, 0.272144258022308, 0.272153377532959, 0.272161930799484, 0.272170007228851, 0.272177517414093, 0.272184550762177, 0.272190988063812, 0.27219694852829, 0.272202342748642, 0.272207230329514, 0.272211611270905, 0.27221542596817, 0.272218763828278, 0.272221505641937, 0.272220581769943, 0.272215992212296, 0.272211372852325, 0.272206544876099, 0.272201597690582, 0.272196471691132, 0.272191226482391, 0.272185862064362, 0.272180318832397, 0.272174626588821, 0.272168815135956, 0.272162854671478, 0.272156774997711, 0.27215051651001, 0.272144109010696, 0.272137612104416, 0.272130906581879, 0.272124052047729, 0.272117108106613, 0.272110015153885, 0.272102773189545, 0.27209535241127, 0.272087842226028, 0.27208012342453, 0.272072315216064, 0.272064328193665, 0.272056251764297, 0.272047996520996, 0.272039592266083, 0.27203106880188, 0.272022366523743, 0.272013515233994, 0.272004544734955, 0.271995425224304, 0.271986186504364, 0.271976798772812, 0.271967232227325, 0.271957546472549, 0.271947711706161, 0.271937757730484, 0.271927624940872, 0.271917372941971, 0.271906971931458, 0.27189639210701, 0.271885722875595, 0.271874904632568, 0.27186393737793, 0.271852761507034, 0.271841526031494, 0.27183011174202, 0.271818578243256, 0.271806865930557, 0.271795034408569, 0.271783053874969, 0.271770924329758, 0.271758675575256, 0.271746248006821, 0.271733701229095, 0.271721005439758, 0.271708160638809, 0.271695196628571, 0.271682053804398, 0.271668761968613, 0.271655350923538, 0.271641820669174, 0.271628111600876, 0.271614253520966, 0.271600276231766, 0.271586149930954, 0.271571844816208, 0.271557480096817, 0.271542906761169, 0.271528214216232, 0.271513342857361, 0.2714983522892, 0.271483212709427, 0.271467924118042, 0.271452516317368, 0.271436959505081, 0.27142122387886, 0.27140536904335, 0.27138939499855, 0.271373271942139, 0.271356999874115, 0.271340548992157, 0.271324008703232, 0.271307289600372, 0.271290451288223, 0.27127343416214, 0.271256297826767, 0.27123898267746, 0.271221578121185, 0.271204024553299, 0.271186292171478, 0.271168410778046, 0.271150439977646, 0.271132260560989, 0.271114021539688, 0.27109557390213, 0.27107697725296, 0.271058678627014, 0.271042019128799, 0.271025687456131, 0.271009713411331, 0.270994067192078, 0.270978778600693, 0.270963788032532, 0.270949155092239, 0.270934849977493, 0.270920932292938, 0.270907342433929, 0.270894050598145, 0.270881146192551, 0.270868539810181, 0.270856320858002, 0.270844429731369, 0.27083283662796, 0.27082160115242, 0.270810723304749, 0.270800173282623, 0.270789951086044, 0.270780116319656, 0.270770609378815, 0.270761400461197, 0.270752549171448, 0.270744055509567, 0.270735889673233, 0.270728081464767, 0.270720601081848, 0.270713448524475, 0.270706653594971, 0.27070015668869, 0.270694047212601, 0.270688265562057, 0.270682841539383, 0.270677715539932, 0.270672976970673, 0.270668506622314, 0.27066445350647, 0.270660698413849, 0.270657300949097, 0.270654261112213, 0.270651519298553, 0.270649135112762, 0.27064710855484, 0.270645380020142, 0.270644038915634, 0.270642995834351, 0.270642310380936, 0.270642012357712, 0.270642012357712, 0.270642310380936, 0.270642995834351, 0.270644038915634, 0.270645380020142, 0.270647078752518, 0.270649135112762, 0.270651489496231, 0.270654231309891, 0.270657300949097, 0.270660668611526, 0.27066445350647, 0.270668506622314, 0.270672917366028, 0.27067768573761, 0.270682811737061, 0.270688235759735, 0.270694017410278, 0.270700126886368, 0.270706623792648, 0.27071338891983, 0.270720541477203, 0.270728051662445, 0.270735830068588, 0.270744025707245, 0.270752489566803, 0.27076131105423, 0.27077054977417, 0.270780056715012, 0.2707898914814, 0.270800113677979, 0.270810633897781, 0.270821541547775, 0.270832777023315, 0.270844340324402, 0.270856231451035, 0.270868480205536, 0.270881086587906, 0.270893961191177, 0.27090722322464, 0.270920842885971, 0.270934790372849, 0.270949095487595, 0.270963698625565, 0.270978659391403, 0.270993947982788, 0.271009624004364, 0.271025598049164, 0.271041929721832, 0.271058589220047, 0.271081447601318, 0.271110266447067, 0.271139591932297, 0.271169543266296, 0.271200001239777, 0.271231085062027, 0.271262735128403, 0.271294891834259, 0.271327674388885, 0.271360963582993, 0.271394848823547, 0.27142933011055, 0.271464318037033, 0.271499872207642, 0.27153605222702, 0.271572768688202, 0.271610021591187, 0.271647840738297, 0.271686255931854, 0.271725237369537, 0.271764755249023, 0.271804839372635, 0.271845489740372, 0.271886736154556, 0.271928548812866, 0.271970897912979, 0.272013813257217, 0.272057265043259, 0.27210134267807, 0.272145926952362, 0.272191107273102, 0.272236883640289, 0.27228319644928, 0.272330015897751, 0.272377461194992, 0.272425472736359, 0.272474050521851, 0.272523164749146, 0.272572845220566, 0.272623121738434, 0.272673934698105, 0.272725343704224, 0.272777289152145, 0.272829800844193, 0.27288293838501, 0.272936582565308, 0.272990792989731, 0.273045539855957, 0.273100882768631, 0.27315679192543, 0.273213267326355, 0.273270279169083, 0.27332791686058, 0.273386061191559, 0.273444831371307, 0.273504108190536, 0.273563951253891, 0.273624360561371, 0.273685395717621, 0.273746937513351, 0.273809045553207, 0.273871719837189, 0.273934960365295, 0.273998767137527, 0.274063169956207, 0.274128139019012, 0.274193614721298, 0.274259716272354, 0.274326324462891, 0.274393498897552, 0.274461299180984, 0.274529606103897, 0.274598568677902, 0.274668008089066, 0.274738013744354, 0.274808615446091, 0.27487975358963, 0.274951487779617, 0.275023758411407, 0.275096654891968, 0.275170028209686, 0.275244057178497, 0.275318562984467, 0.275393635034561, 0.275469332933426, 0.275545537471771, 0.275622367858887, 0.275699704885483, 0.275777667760849, 0.275856167078018, 0.275935232639313, 0.27601483464241, 0.276095032691956, 0.276175767183304, 0.276257127523422, 0.276338994503021, 0.27642148733139, 0.276504456996918, 0.276588052511215, 0.276672214269638, 0.276771694421768, 0.276884645223618, 0.276997625827789, 0.277110517024994, 0.277223497629166, 0.277336418628693, 0.277449369430542, 0.277562290430069, 0.277675300836563, 0.27778822183609, 0.277901142835617, 0.278014093637466, 0.278127044439316, 0.278239995241165, 0.278352946043015, 0.278465926647186, 0.278578817844391, 0.278691798448563, 0.27880471944809, 0.278917640447617, 0.279030621051788, 0.279143571853638, 0.279256492853165, 0.279369473457336, 0.279482394456863, 0.279595345258713, 0.279708296060562, 0.279821276664734, 0.279934167861938, 0.28004714846611, 0.280160069465637, 0.280272990465164, 0.280385941267014, 0.280498921871185, 0.280611872673035, 0.280724793672562, 0.280837744474411, 0.28095069527626, 0.281063616275787, 0.281176596879959, 0.281289517879486, 0.281402468681335, 0.281515419483185, 0.281628340482712, 0.281741321086884, 0.281854271888733, 0.281967222690582, 0.282080143690109, 0.282193124294281, 0.282306045293808, 0.282418966293335, 0.282531917095184, 0.282644897699356, 0.282757818698883, 0.282870769500732, 0.282983720302582, 0.283096671104431, 0.283209621906281, 0.283322542905807, 0.283435493707657, 0.283548444509506, 0.283661395311356, 0.283774346113205, 0.283887267112732, 0.284000247716904, 0.284113168716431, 0.284226089715958, 0.284339070320129, 0.284452021121979, 0.284564942121506, 0.284677892923355, 0.284790843725204, 0.284903794527054, 0.285016745328903, 0.285129696130753, 0.285242646932602, 0.285355597734451, 0.285468518733978, 0.28558149933815, 0.285694450139999, 0.285807371139526, 0.285920292139053, 0.286033272743225, 0.286146223545074, 0.286259144544601, 0.286372125148773, 0.286485075950623, 0.28659799695015, 0.286710917949677, 0.286823928356171, 0.286936849355698, 0.287049740552902, 0.287162721157074, 0.287275671958923, 0.287388622760773, 0.287501573562622, 0.287614494562149, 0.287727445363998, 0.28784042596817, 0.287953346967697, 0.288052499294281, 0.288136661052704, 0.288220226764679, 0.288303226232529, 0.288385689258575, 0.288467586040497, 0.28854888677597, 0.288629680871964, 0.288709819316864, 0.288789480924606, 0.288868516683578, 0.288947016000748, 0.289024949073792, 0.28910231590271, 0.289179116487503, 0.289255380630493, 0.289331078529358, 0.289406180381775, 0.289480715990067, 0.28955465555191, 0.289628118276596, 0.289700925350189, 0.289773255586624, 0.289844959974289, 0.289916098117828, 0.289986699819565, 0.290056735277176, 0.290126204490662, 0.290195107460022, 0.290263414382935, 0.290331214666367, 0.290398418903351, 0.290465027093887, 0.290531128644943, 0.290596634149551, 0.290661603212357, 0.290725946426392, 0.290789753198624, 0.290853053331375, 0.290915727615356, 0.290977835655212, 0.291039347648621, 0.291100412607193, 0.291160821914673, 0.291220664978027, 0.291279941797256, 0.291338711977005, 0.291396856307983, 0.291454464197159, 0.291511476039886, 0.291567981243134, 0.291623890399933, 0.291679203510284, 0.291733980178833, 0.291788190603256, 0.291841894388199, 0.291894972324371, 0.291947484016418, 0.291999459266663, 0.292050808668137, 0.292101681232452, 0.292151927947998, 0.292201638221741, 0.292250722646713, 0.292299300432205, 0.292347341775894, 0.292394757270813, 0.292441636323929, 0.292487889528275, 0.292533695697784, 0.292578846216202, 0.292623460292816, 0.292667537927628, 0.292710989713669, 0.292753934860229, 0.292796283960342, 0.292838096618652, 0.292879283428192, 0.292919933795929, 0.292960047721863, 0.292999595403671, 0.293038576841354, 0.293076932430267, 0.2931147813797, 0.293152064085007, 0.293188780546188, 0.293224960565567, 0.293260484933853, 0.293295502662659, 0.293329983949661, 0.293363809585571, 0.293397158384323, 0.29342994093895, 0.293462127447128, 0.293493747711182, 0.29352480173111, 0.293555319309235, 0.293585240840912, 0.293614625930786, 0.29364338517189, 0.293664067983627, 0.293677926063538, 0.293691486120224, 0.293704748153687, 0.293717741966248, 0.293730467557907, 0.293742895126343, 0.293755024671555, 0.293766885995865, 0.293778449296951, 0.293789774179459, 0.293800741434097, 0.293811500072479, 0.293821930885315, 0.293832123279572, 0.293841987848282, 0.293851613998413, 0.293860912322998, 0.293869972229004, 0.293878704309464, 0.293887168169022, 0.293895393610001, 0.293903291225433, 0.293910920619965, 0.293918251991272, 0.293925285339355, 0.293932110071182, 0.293938606977463, 0.293944776058197, 0.293950706720352, 0.293956369161606, 0.293961763381958, 0.293966829776764, 0.293971627950668, 0.293976157903671, 0.293980360031128, 0.293984323740005, 0.293988019227982, 0.293991386890411, 0.29399448633194, 0.293997347354889, 0.293999850749969, 0.294002115726471, 0.294004112482071, 0.294005811214447, 0.294007211923599, 0.29400834441185, 0.294009178876877, 0.294009745121002, 0.294010043144226, 0.294010043144226, 0.294009745121002, 0.294009178876877, 0.294008374214172, 0.294007211923599, 0.294005811214447, 0.294004112482071, 0.294002115726471, 0.293999880552292, 0.293997347354889, 0.293994516134262, 0.293991386890411, 0.293988019227982, 0.29398438334465, 0.293980419635773, 0.293976157903671, 0.293971657752991, 0.293966859579086, 0.293961763381958, 0.293956398963928, 0.293950796127319, 0.293944835662842, 0.293938636779785, 0.293932139873505, 0.293925344944, 0.293918311595917, 0.293910920619965, 0.293903321027756, 0.293895453214645, 0.293887227773666, 0.293878763914108, 0.293870031833649, 0.293860971927643, 0.293851673603058, 0.293842047452927, 0.293832182884216, 0.29382199048996, 0.293811589479446, 0.293800801038742, 0.293789833784103, 0.293778538703918, 0.293766975402832, 0.293755084276199, 0.29374298453331, 0.293730556964874, 0.293717831373215, 0.293704837560654, 0.293691575527191, 0.293678015470505, 0.293664187192917, 0.293659001588821, 0.293666213750839, 0.293673276901245, 0.293680250644684, 0.293687015771866, 0.293693661689758, 0.293700158596039, 0.293706506490707, 0.293712705373764, 0.293718725442886, 0.293724685907364, 0.293730407953262, 0.293736010789871, 0.293741464614868, 0.293746769428253, 0.293751925230026, 0.293756991624832, 0.293761849403381, 0.293766528367996, 0.293771117925644, 0.29377555847168, 0.293779820203781, 0.293783962726593, 0.293787926435471, 0.293791800737381, 0.293795496225357, 0.293798983097076, 0.293802380561829, 0.293805629014969, 0.293808728456497, 0.293811678886414, 0.293814480304718, 0.293817162513733, 0.293819665908813, 0.293822020292282, 0.293824225664139, 0.293826311826706, 0.293828189373016, 0.293830007314682, 0.293831586837769, 0.293833076953888, 0.293834418058395, 0.293835610151291, 0.29383659362793, 0.293837517499924, 0.293838232755661, 0.293838858604431, 0.293839305639267, 0.293839544057846, 0.29383972287178, 0.29383972287178, 0.293839544057846, 0.293839275836945, 0.293838828802109, 0.293838232755661, 0.293837487697601, 0.29383659362793, 0.293835610151291, 0.293834388256073, 0.293833047151566, 0.293831586837769, 0.293829947710037, 0.293828159570694, 0.293826252222061, 0.293824195861816, 0.29382199048996, 0.293819606304169, 0.293817102909088, 0.293814450502396, 0.293811649084091, 0.293808668851852, 0.293805569410324, 0.293802320957184, 0.293798923492432, 0.29379540681839, 0.293791741132736, 0.293787837028503, 0.293783903121948, 0.293779760599136, 0.293775469064713, 0.293771058320999, 0.293766468763351, 0.293761700391769, 0.29375684261322, 0.293751806020737, 0.293746680021286, 0.293741345405579, 0.293735891580582, 0.293730288743973, 0.29372450709343, 0.293718636035919, 0.293712586164474, 0.293706387281418, 0.293699979782104, 0.293693512678146, 0.293686896562576, 0.29368007183075, 0.293673157691956, 0.293666034936905, 0.293658792972565, 0.293650895357132, 0.293635845184326, 0.293620467185974, 0.293604850769043, 0.293588906526566, 0.293572664260864, 0.293556183576584, 0.293539315462112, 0.29352217912674, 0.293504804372787, 0.293487101793289, 0.293469041585922, 0.293450772762299, 0.293432176113129, 0.293413281440735, 0.293394088745117, 0.293374598026276, 0.293354839086533, 0.293334752321243, 0.293314397335052, 0.293293744325638, 0.293272763490677, 0.293251514434814, 0.293229967355728, 0.29320815205574, 0.293185979127884, 0.293163567781448, 0.293140828609467, 0.293117791414261, 0.293094456195831, 0.293070882558823, 0.293046981096268, 0.293022722005844, 0.292998284101486, 0.292973458766937, 0.292948395013809, 0.292923003435135, 0.292897313833237, 0.292871296405792, 0.292845040559769, 0.292818486690521, 0.292791604995728, 0.292764455080032, 0.292737007141113, 0.292709231376648, 0.292681217193604, 0.292652904987335, 0.292624264955521, 0.29259529709816, 0.292566120624542, 0.292536556720734, 0.292506754398346, 0.292476624250412, 0.292446225881577, 0.29241555929184, 0.292384564876556, 0.292353272438049, 0.292321711778641, 0.292289793491364, 0.292257577180862, 0.292225182056427, 0.292192399501801, 0.29215931892395, 0.292125970125198, 0.292092323303223, 0.292058348655701, 0.2920241355896, 0.291989624500275, 0.291954755783081, 0.291919618844986, 0.291884213685989, 0.291848480701447, 0.29181244969368, 0.291776150465012, 0.29173955321312, 0.291702657938004, 0.291665494441986, 0.291627943515778, 0.291590183973312, 0.291552126407623, 0.291513741016388, 0.291475087404251, 0.291436105966568, 0.291396826505661, 0.291357278823853, 0.291317462921143, 0.291277319192886, 0.291236877441406, 0.29119610786438, 0.291155070066452, 0.291113764047623, 0.291072160005569, 0.291030257940292, 0.290987968444824, 0.290945470333099, 0.290902674198151, 0.290859550237656, 0.290816187858582, 0.290772527456284, 0.290728509426117, 0.29067525267601, 0.29061621427536, 0.29055717587471, 0.290498107671738, 0.29043909907341, 0.290380090475082, 0.29032102227211, 0.290261954069138, 0.290202915668488, 0.29014390707016, 0.290084838867188, 0.290025800466537, 0.28996679186821, 0.28990775346756, 0.28984871506691, 0.28978967666626, 0.28973063826561, 0.28967159986496, 0.28961256146431, 0.289553552865982, 0.289494514465332, 0.289435416460037, 0.289376437664032, 0.289317399263382, 0.28925833106041, 0.289199262857437, 0.289140254259109, 0.289081215858459, 0.289022177457809, 0.288963198661804, 0.288904130458832, 0.288845062255859, 0.288786023855209, 0.288726985454559, 0.288667976856232, 0.288608938455582, 0.288549900054932, 0.288490861654282, 0.288431823253632, 0.288372784852982, 0.288313746452332, 0.288254678249359, 0.288195669651031, 0.288136631250381, 0.288077563047409, 0.288018524646759, 0.287959486246109, 0.287900447845459, 0.287841439247131, 0.287782430648804, 0.287723362445831, 0.287664324045181, 0.287605255842209, 0.287546247243881, 0.287487208843231, 0.287428170442581, 0.287369132041931, 0.287310123443604, 0.287251055240631, 0.287192016839981, 0.287133008241653, 0.287073940038681, 0.287014901638031, 0.286955833435059, 0.286896795034409, 0.286837786436081, 0.286778748035431, 0.286719709634781, 0.286660671234131, 0.286601632833481, 0.286542594432831, 0.286483556032181, 0.286424547433853, 0.286365509033203, 0.286306470632553, 0.286247432231903, 0.286188364028931, 0.286129325628281, 0.286070317029953, 0.286011278629303, 0.285952270030975, 0.285893172025681, 0.285834133625031, 0.28577509522438, 0.28571605682373, 0.285657048225403, 0.28559798002243, 0.28553894162178, 0.285479933023453, 0.285420894622803, 0.285361856222153, 0.285302817821503, 0.285243779420853, 0.285184741020203, 0.28512567281723, 0.285066664218903, 0.285007655620575, 0.284948587417603, 0.284889578819275, 0.284830510616302, 0.284778088331223, 0.284739136695862, 0.284700393676758, 0.284661799669266, 0.28462341427803, 0.284585267305374, 0.28454726934433, 0.284509420394897, 0.284471839666367, 0.28443443775177, 0.28439724445343, 0.284360200166702, 0.284323304891586, 0.284286767244339, 0.284250259399414, 0.284214019775391, 0.284177958965302, 0.284142106771469, 0.284106403589249, 0.284070938825607, 0.284035593271255, 0.284000486135483, 0.283965587615967, 0.283930867910385, 0.283896327018738, 0.28386202454567, 0.283827871084213, 0.283793926239014, 0.283760160207748, 0.28372660279274, 0.283693253993988, 0.283660084009171, 0.283627063035965, 0.283594280481339, 0.283561706542969, 0.283529281616211, 0.28349706530571, 0.283465057611465, 0.283433198928833, 0.283401548862457, 0.283370167016983, 0.283338904380798, 0.283307820558548, 0.283276975154877, 0.28324630856514, 0.283215820789337, 0.283185511827469, 0.283155411481857, 0.283125519752502, 0.283095806837082, 0.283066272735596, 0.283036947250366, 0.283007800579071, 0.282978862524033, 0.282950162887573, 0.282921582460403, 0.282893240451813, 0.282865047454834, 0.28283703327179, 0.282809287309647, 0.282781690359116, 0.282754242420197, 0.282727062702179, 0.282700031995773, 0.282673209905624, 0.282646596431732, 0.282620161771774, 0.282593935728073, 0.282567799091339, 0.282541990280151, 0.282516360282898, 0.282490849494934, 0.282465547323227, 0.282440483570099, 0.282415598630905, 0.282390862703323, 0.282366365194321, 0.28234201669693, 0.282317906618118, 0.282293945550919, 0.282270222902298, 0.282246708869934, 0.28222331404686, 0.282200127840042, 0.282177150249481, 0.282154381275177, 0.28213182091713, 0.282109439373016, 0.282087206840515, 0.282065212726593, 0.282043397426605, 0.282021790742874, 0.282000333070755, 0.281979113817215, 0.281958043575287, 0.281937181949615, 0.281916499137878, 0.28189605474472, 0.281875759363174, 0.281855702400208, 0.281845510005951, 0.281839162111282, 0.281832426786423, 0.281825542449951, 0.281818240880966, 0.28181067109108, 0.281802892684937, 0.281794756650925, 0.281786322593689, 0.281777679920197, 0.281768709421158, 0.28175938129425, 0.281749874353409, 0.281740009784698, 0.28172978758812, 0.281719446182251, 0.281708747148514, 0.28169772028923, 0.281686425209045, 0.281674832105637, 0.281662940979004, 0.281650841236115, 0.281638354063034, 0.281625628471375, 0.281612604856491, 0.281599313020706, 0.281585663557053, 0.281571805477142, 0.281557589769363, 0.281543105840683, 0.281528413295746, 0.281513333320618, 0.281497985124588, 0.281482398509979, 0.281466424465179, 0.281450241804123, 0.281433820724487, 0.281416952610016, 0.28139990568161, 0.281382620334625, 0.281364947557449, 0.281346946954727, 0.281328767538071, 0.281310230493546, 0.281291425228119, 0.281272381544113, 0.281252980232239, 0.281233280897141, 0.281213402748108, 0.281193107366562, 0.281172543764114, 0.28115177154541, 0.281130611896515, 0.281109243631363, 0.281087577342987, 0.281065583229065, 0.281043261289597, 0.281020760536194, 0.280997902154922, 0.28097477555275, 0.280951350927353, 0.280927628278732, 0.28090363740921, 0.280879348516464, 0.280854761600494, 0.280829876661301, 0.280804812908173, 0.280779302120209, 0.280753552913666, 0.280727595090866, 0.280701220035553, 0.280674636363983, 0.280647754669189, 0.280620545148849, 0.28059309720993, 0.28056538105011, 0.280537337064743, 0.280508995056152, 0.280480444431305, 0.280451476573944, 0.280422240495682, 0.280392795801163, 0.280362993478775, 0.280332893133163, 0.28030264377594, 0.280271917581558, 0.280241012573242, 0.280209809541702, 0.280178308486938, 0.280146479606628, 0.280114442110062, 0.280082046985626, 0.280049324035645, 0.280016422271729, 0.279983222484589, 0.279949635267258, 0.279915899038315, 0.279881715774536, 0.279847323894501, 0.279812693595886, 0.27975931763649, 0.279697507619858, 0.27963525056839, 0.279572397470474, 0.279508978128433, 0.279445141553879, 0.279380679130554, 0.279315710067749, 0.27925032377243, 0.279184371232986, 0.279117822647095, 0.279050886631012, 0.278983324766159, 0.278915256261826, 0.278846740722656, 0.278777658939362, 0.278707981109619, 0.278637915849686, 0.278567224740982, 0.278496086597443, 0.278424441814423, 0.278352230787277, 0.278279423713684, 0.2782062292099, 0.27813246846199, 0.278058171272278, 0.277983367443085, 0.277908086776733, 0.277832210063934, 0.277755886316299, 0.277678966522217, 0.277601540088654, 0.277523636817932, 0.277445167303085, 0.27736622095108, 0.277286767959595, 0.277206748723984, 0.277126252651215, 0.277045220136642, 0.276963621377945, 0.276881515979767, 0.276798993349075, 0.276715815067291, 0.276632159948349, 0.276548057794571, 0.276463329792023, 0.276378095149994, 0.276292443275452, 0.276206195354462, 0.276119410991669, 0.27603217959404, 0.275944381952286, 0.275856018066406, 0.275767236948013, 0.27567782998085, 0.275587975978851, 0.275497615337372, 0.275406628847122, 0.275315165519714, 0.275223255157471, 0.275130808353424, 0.275037795305252, 0.274944305419922, 0.274850249290466, 0.274755656719208, 0.274660587310791, 0.274565011262894, 0.274468898773193, 0.27437224984169, 0.274275094270706, 0.274177342653275, 0.274079203605652, 0.273980528116226, 0.273881256580353, 0.273781538009644, 0.273681223392487, 0.273580431938171, 0.273479163646698, 0.273377329111099, 0.273274928331375, 0.273172080516815, 0.273068696260452, 0.272964775562286, 0.272860378026962, 0.272755354642868, 0.27264991402626, 0.27254393696785, 0.272437423467636, 0.27233037352562, 0.272222876548767, 0.272114753723145, 0.272006124258041, 0.271897077560425, 0.271787405014038, 0.271677225828171, 0.27156662940979, 0.271455407142639, 0.27134370803833, 0.271231532096863, 0.271118730306625, 0.271007239818573, 0.270883321762085, 0.270759433507919, 0.270635545253754, 0.270511627197266, 0.270387709140778, 0.270263820886612, 0.270139902830124, 0.270015895366669, 0.269891947507858, 0.269767969846725, 0.269643992185593, 0.269519984722137, 0.26939594745636, 0.26927188038826, 0.269147843122482, 0.269023835659027, 0.268899708986282, 0.26877561211586, 0.268651515245438, 0.26852735877037, 0.268403261899948, 0.268279165029526, 0.268154978752136, 0.268030852079391, 0.267906695604324, 0.267782509326935, 0.267658263444901, 0.267534047365189, 0.267409771680832, 0.267285585403442, 0.26716136932373, 0.267037093639374, 0.266912817955017, 0.266788512468338, 0.266664206981659, 0.26653990149498, 0.266415536403656, 0.266291230916977, 0.266166865825653, 0.266042500734329, 0.265918135643005, 0.265793710947037, 0.265669345855713, 0.265544861555099, 0.265420496463776, 0.265296012163162, 0.265171557664871, 0.26504710316658, 0.264922589063644, 0.264798104763031, 0.264673590660095, 0.264549046754837, 0.264424532651901, 0.264300018548965, 0.264175415039062, 0.26405081152916, 0.263926267623901, 0.263801693916321, 0.263677090406418, 0.263552457094193, 0.263427793979645, 0.263303130865097, 0.263178497552872, 0.263053774833679, 0.262929052114487, 0.262804388999939, 0.262679725885391, 0.262555003166199, 0.262430250644684, 0.262305498123169, 0.262180775403976, 0.262055993080139, 0.261931121349335, 0.261806339025497, 0.261681526899338, 0.261556714773178, 0.261431843042374, 0.261306971311569, 0.261182129383087, 0.261057257652283, 0.260932326316833, 0.260807394981384, 0.260682553052902, 0.260557591915131, 0.260432660579681, 0.260307729244232, 0.260182768106461, 0.260057717561722, 0.259932696819305, 0.259807705879211, 0.259682685136795, 0.259557664394379, 0.25943261384964, 0.259307593107224, 0.259182512760162, 0.259057402610779, 0.258932322263718, 0.258807182312012, 0.258682042360306, 0.258570998907089, 0.258463531732559, 0.25835645198822, 0.258249759674072, 0.258143395185471, 0.258037358522415, 0.257931709289551, 0.25782635807991, 0.257721543312073, 0.257616937160492, 0.257512718439102, 0.257408857345581, 0.257305324077606, 0.257202237844467, 0.257099509239197, 0.256997019052505, 0.256894946098328, 0.256793260574341, 0.256691932678223, 0.256590962409973, 0.256490349769592, 0.256390124559402, 0.256290167570114, 0.256190657615662, 0.256091475486755, 0.255992621183395, 0.255894213914871, 0.255796104669571, 0.255698293447495, 0.255600988864899, 0.255503922700882, 0.255407273769379, 0.255310982465744, 0.255214989185333, 0.255119413137436, 0.255024164915085, 0.254929304122925, 0.254834830760956, 0.254740655422211, 0.254646897315979, 0.254553437232971, 0.254460424184799, 0.254367649555206, 0.254275232553482, 0.254183292388916, 0.254091650247574, 0.254000395536423, 0.253909468650818, 0.253818929195404, 0.253728777170181, 0.253638833761215, 0.253549426794052, 0.253460288047791, 0.25337153673172, 0.253283232450485, 0.253194987773895, 0.25310742855072, 0.253020077943802, 0.25293305516243, 0.252846568822861, 0.252760291099548, 0.252674371004105, 0.252588897943497, 0.25250369310379, 0.252418905496597, 0.252334475517273, 0.252250343561172, 0.252166569232941, 0.252083241939545, 0.252000212669373, 0.251917630434036, 0.251835316419601, 0.251753389835358, 0.251671761274338, 0.251590579748154, 0.251509755849838, 0.251429259777069, 0.251349091529846, 0.251269280910492, 0.251189917325974, 0.251110851764679, 0.251032143831253, 0.250953823328018, 0.250875741243362, 0.250798225402832, 0.250720888376236, 0.250644028186798, 0.250567585229874, 0.250491350889206, 0.250415503978729, 0.250339955091476, 0.250264883041382, 0.250190228223801, 0.250115752220154, 0.25004181265831, 0.249968111515045, 0.249894797801971, 0.249821841716766, 0.24974924325943, 0.249676987528801, 0.249598279595375, 0.249528735876083, 0.249459490180016, 0.249390602111816, 0.249322041869164, 0.249253749847412, 0.249185919761658, 0.249118387699127, 0.249051183462143, 0.248984396457672, 0.248917892575264, 0.248851746320724, 0.248786017298698, 0.248720556497574, 0.248655423521996, 0.248590707778931, 0.24852629005909, 0.248462244868279, 0.248398542404175, 0.248335152864456, 0.248272195458412, 0.248209476470947, 0.248147174715996, 0.248085126280785, 0.248023554682732, 0.247962296009064, 0.247901305556297, 0.247840732336044, 0.247780531644821, 0.247720584273338, 0.247661083936691, 0.247601866722107, 0.247543022036552, 0.247484475374222, 0.24742628633976, 0.247368514537811, 0.247311010956764, 0.247253879904747, 0.247197076678276, 0.24714070558548, 0.247084587812424, 0.247028812766075, 0.246973484754562, 0.246918350458145, 0.246863692998886, 0.246809408068657, 0.246755316853523, 0.246701702475548, 0.246648371219635, 0.246595427393913, 0.24654284119606, 0.24649053812027, 0.246438562870026, 0.246387079358101, 0.246335834264755, 0.246284872293472, 0.246234312653542, 0.246184200048447, 0.24613431096077, 0.246084794402122, 0.246035665273666, 0.245986849069595, 0.245938360691071, 0.245890274643898, 0.245842486619949, 0.245795100927353, 0.245747983455658, 0.245701253414154, 0.245654925704002, 0.245608821511269, 0.245563164353371, 0.245517775416374, 0.245472863316536, 0.245428159832954, 0.245383843779564, 0.245339870452881, 0.245296254754066, 0.245253011584282, 0.245210126042366, 0.245167553424835, 0.245125293731689, 0.245083406567574, 0.245041936635971, 0.24500073492527, 0.24495992064476, 0.244919404387474, 0.244879230856895, 0.244839489459991, 0.244800016283989, 0.244760885834694, 0.244722113013268, 0.244683787226677, 0.244645670056343, 0.2446079403162, 0.244570523500443, 0.244533583521843, 0.2444968521595, 0.244460508227348, 0.244424521923065, 0.244388848543167, 0.244363903999329, 0.244340494275093, 0.244317248463631, 0.244293957948685, 0.244270801544189, 0.244247674942017, 0.24422462284565, 0.244201555848122, 0.244178682565689, 0.244155719876289, 0.244132906198502, 0.24411016702652, 0.244087368249893, 0.24406473338604, 0.244042128324509, 0.2440195530653, 0.243997097015381, 0.243974670767784, 0.243952244520187, 0.243929967284203, 0.243907704949379, 0.243885457515717, 0.243863329291344, 0.243841245770454, 0.243819206953049, 0.243797242641449, 0.243775278329849, 0.243753433227539, 0.243731692433357, 0.243709847331047, 0.243688195943832, 0.243666529655457, 0.243644952774048, 0.243623480200768, 0.243601977825165, 0.243580609560013, 0.243559241294861, 0.243537947535515, 0.243516772985458, 0.243495583534241, 0.243474468588829, 0.243453428149223, 0.243432447314262, 0.243411481380463, 0.243390589952469, 0.243369773030281, 0.243349030613899, 0.243328288197517, 0.243307679891586, 0.243287146091461, 0.243266567587852, 0.243246093392372, 0.243225708603859, 0.243205294013023, 0.243185058236122, 0.243164792656898, 0.243144556879997, 0.24312449991703, 0.243104368448257, 0.243084371089935, 0.243064448237419, 0.243044510483742, 0.243024706840515, 0.24300491809845, 0.242985174059868, 0.242965534329414, 0.242945954203606, 0.242926329374313, 0.242906853556633, 0.242887482047081, 0.242868050932884, 0.242848724126816, 0.242829471826553, 0.242810264229774, 0.242791131138802, 0.242772042751312, 0.242752999067307, 0.242734000086784, 0.242715105414391, 0.242696240544319, 0.242677479982376, 0.242658704519272, 0.242640033364296, 0.242621392011642, 0.242602840065956, 0.24258428812027, 0.242565855383873, 0.24254746735096, 0.242529109120369, 0.242510870099068, 0.242492601275444, 0.242474481463432, 0.242456376552582, 0.242438301444054, 0.242420315742493, 0.242402449250221, 0.242384493350983, 0.242366686463356, 0.242349028587341, 0.242331221699715, 0.242313608527184, 0.242294162511826, 0.242274314165115, 0.242254078388214, 0.242233335971832, 0.242212265729904, 0.242190688848495, 0.242168620228767, 0.242146164178848, 0.242123261094093, 0.242099791765213, 0.24207603931427, 0.242051914334297, 0.242027163505554, 0.242002040147781, 0.241976484656334, 0.241950407624245, 0.241923943161964, 0.241897106170654, 0.241869777441025, 0.241842016577721, 0.241813793778419, 0.241785034537315, 0.241755932569504, 0.241726413369179, 0.241696447134018, 0.241666063666344, 0.241635158658028, 0.24160373210907, 0.241571992635727, 0.241539746522903, 0.241507157683372, 0.241474136710167, 0.241440534591675, 0.241406589746475, 0.24137207865715, 0.241337284445763, 0.24130192399025, 0.241266250610352, 0.241230025887489, 0.241193354129791, 0.241156339645386, 0.241118669509888, 0.241080909967422, 0.24104231595993, 0.241003513336182, 0.240964263677597, 0.240924507379532, 0.24088428914547, 0.240843653678894, 0.240802705287933, 0.240761145949364, 0.240719214081764, 0.240676805377007, 0.240633964538574, 0.240590617060661, 0.240547031164169, 0.240502834320068, 0.240458205342293, 0.240413144230843, 0.24036768078804, 0.24032162129879, 0.240275278687477, 0.240228563547134, 0.240181297063828, 0.24013352394104, 0.240085422992706, 0.240036815404892, 0.239987686276436, 0.239938333630562, 0.239888444542885, 0.239837974309921, 0.239787206053734, 0.239735975861549, 0.239684209227562, 0.239632040262222, 0.239579617977142, 0.239526495337486, 0.239473059773445, 0.239419177174568, 0.239364758133888, 0.239309966564178, 0.23925469815731, 0.239199087023735, 0.239142924547195, 0.239086374640465, 0.239029303193092, 0.238971903920174, 0.238913968205452, 0.238855719566345, 0.238796934485435, 0.238737687468529, 0.238677963614464, 0.238617897033691, 0.238557353615761, 0.238496363162994, 0.238435000181198, 0.238373100757599, 0.238310813903809, 0.238247960805893, 0.238170221447945, 0.238089472055435, 0.238008126616478, 0.237926170229912, 0.23784364759922, 0.237760543823242, 0.23767676949501, 0.237592682242393, 0.237507745623589, 0.23742239177227, 0.237336307764053, 0.237249791622162, 0.237162530422211, 0.23707489669323, 0.236986711621284, 0.236897721886635, 0.236808314919472, 0.236718207597733, 0.236627653241158, 0.236536368727684, 0.236444741487503, 0.236352428793907, 0.236259430646896, 0.236166000366211, 0.236071869730949, 0.235977113246918, 0.235881879925728, 0.235786214470863, 0.235689729452133, 0.235592842102051, 0.235495284199715, 0.235397174954414, 0.235298424959183, 0.235199198126793, 0.235099405050278, 0.23499895632267, 0.234897881746292, 0.234796315431595, 0.23469403386116, 0.234591335058212, 0.234488159418106, 0.234384164214134, 0.234279617667198, 0.234174653887749, 0.234068989753723, 0.233962774276733, 0.23385614156723, 0.233748689293861, 0.233640775084496, 0.233532249927521, 0.233423098921776, 0.233313456177711, 0.233203276991844, 0.233092442154884, 0.232981026172638, 0.232869043946266, 0.232756450772285, 0.232643306255341, 0.232529625296593, 0.232415303587914, 0.232300475239754, 0.232185065746307, 0.232068940997124, 0.231952339410782, 0.231835126876831, 0.231717452406883, 0.231599092483521, 0.231480225920677, 0.231360718607903, 0.23124061524868, 0.231119945645332, 0.23099872469902, 0.230876982212067, 0.230754613876343, 0.230631694197655, 0.230508089065552, 0.230383962392807, 0.230259269475937, 0.230134025216103, 0.230008259415627, 0.229881793260574, 0.229754880070686, 0.22962711751461, 0.229499071836472, 0.229370281100273, 0.229241028428078, 0.229111179709435, 0.228980749845505, 0.228849589824677, 0.228718027472496, 0.228585824370384, 0.228452995419502, 0.228319719433784, 0.22818586230278, 0.228051334619522, 0.227916166186333, 0.227780520915985, 0.227644309401512, 0.227507546544075, 0.227370128035545, 0.227239027619362, 0.22710993885994, 0.226980522274971, 0.22685045003891, 0.226719945669174, 0.226588815450668, 0.226457059383392, 0.226324781775475, 0.226191848516464, 0.226058483123779, 0.225924447178841, 0.225789919495583, 0.22565484046936, 0.225519105792046, 0.225382834672928, 0.225245982408524, 0.225108653306961, 0.224970653653145, 0.22483217716217, 0.224693164229393, 0.224553465843201, 0.224413335323334, 0.224272519350052, 0.224131107330322, 0.22398915886879, 0.22384674847126, 0.22370371222496, 0.223560199141502, 0.223416030406952, 0.223271325230598, 0.223126083612442, 0.222980126738548, 0.22283373773098, 0.222686663269997, 0.222539186477661, 0.222391098737717, 0.222242444753647, 0.22209320962429, 0.221943333745003, 0.221792951226234, 0.221641942858696, 0.221490606665611, 0.221338599920273, 0.221185892820358, 0.221032649278641, 0.220878928899765, 0.22072459757328, 0.220569685101509, 0.220414236187935, 0.220258340239525, 0.220101729035378, 0.219944596290588, 0.219786748290062, 0.219628572463989, 0.219469666481018, 0.219310253858566, 0.219150394201279, 0.218989804387093, 0.218828737735748, 0.218667045235634, 0.218504756689072, 0.218342021107674, 0.218178629875183, 0.218014776706696, 0.217850267887115, 0.217685252428055, 0.217519581317902, 0.217353388667107, 0.217186644673347, 0.217019349336624, 0.216851383447647, 0.21668304502964, 0.21651403605938, 0.216344445943832, 0.216174274682999, 0.216003641486168, 0.215832367539406, 0.215660557150841, 0.215488165616989, 0.215315252542496, 0.215141758322716, 0.214967668056488, 0.214792788028717, 0.214617654681206, 0.214441940188408, 0.214265584945679, 0.214088633656502, 0.213911220431328, 0.213733211159706, 0.213554427027702, 0.213375329971313, 0.213195636868477, 0.213015347719193, 0.212834402918816, 0.212653025984764, 0.21247111260891, 0.212288498878479, 0.212105259299278, 0.211921602487564, 0.211737409234047, 0.211539909243584, 0.211331069469452, 0.211121946573257, 0.210912585258484, 0.210702925920486, 0.210493043065071, 0.210282772779465, 0.210072487592697, 0.209861755371094, 0.209650784730911, 0.209439590573311, 0.209227904677391, 0.209016099572182, 0.208804056048393, 0.208591774106026, 0.208379164338112, 0.208166271448135, 0.20795314013958, 0.207739725708961, 0.207525923848152, 0.207312062382698, 0.207097813487053, 0.206883311271667, 0.206668645143509, 0.206453591585159, 0.206238344311714, 0.206022650003433, 0.205806836485863, 0.205590724945068, 0.205374285578728, 0.20515775680542, 0.204940766096115, 0.204723611474037, 0.204506143927574, 0.204288378357887, 0.204070404171944, 0.203852236270905, 0.203633636236191, 0.203414857387543, 0.203195869922638, 0.202976524829865, 0.202756732702255, 0.202536895871162, 0.20231682062149, 0.202096357941628, 0.201875701546669, 0.20165479183197, 0.201433539390564, 0.20121194422245, 0.200990155339241, 0.200768187642097, 0.200545847415924, 0.200323268771172, 0.200100511312485, 0.19987741112709, 0.199653998017311, 0.199430257081985, 0.199206307530403, 0.198982104659081, 0.198757737874985, 0.198532998561859, 0.198307946324348, 0.198082655668259, 0.197857111692429, 0.197631269693375, 0.19740517437458, 0.197178974747658, 0.196952298283577, 0.196725428104401, 0.196498319506645, 0.196270763874054, 0.196043089032173, 0.195815220475197, 0.195586919784546, 0.195358425378799, 0.195129632949829, 0.194900706410408, 0.194671332836151, 0.194441631436348, 0.194211855530739, 0.193981692194939, 0.193751350045204, 0.193520665168762, 0.19328972697258, 0.193058535456657, 0.192826971411705, 0.192595258355141, 0.192363202571869, 0.192130953073502, 0.191898450255394, 0.191665649414062, 0.191432520747185, 0.191199108958244, 0.190965488553047, 0.190731540322304, 0.190497472882271, 0.190263092517853, 0.190028324723244, 0.1897933781147, 0.189558118581772, 0.189325377345085, 0.189099192619324, 0.188873276114464, 0.188647672533989, 0.188422456383705, 0.188197612762451, 0.187973037362099, 0.187748610973358, 0.187524721026421, 0.187301069498062, 0.187077805399895, 0.186854675412178, 0.186632037162781, 0.186409711837769, 0.186187639832497, 0.185965955257416, 0.185744538903236, 0.185523524880409, 0.185302823781967, 0.185082361102104, 0.184862166643143, 0.184642434120178, 0.184422835707664, 0.184203699231148, 0.183984845876694, 0.183766454458237, 0.183548152446747, 0.183330282568932, 0.183112815022469, 0.182895570993423, 0.18267859518528, 0.182462096214294, 0.182245880365372, 0.182029768824577, 0.181814193725586, 0.181598976254463, 0.18138399720192, 0.181169331073761, 0.180954903364182, 0.180740982294083, 0.180527314543724, 0.180313989520073, 0.180100843310356, 0.179888114333153, 0.179675668478012, 0.179463624954224, 0.179251775145531, 0.179040402173996, 0.178829327225685, 0.178618416190147, 0.17840801179409, 0.178197801113129, 0.177988052368164, 0.177778422832489, 0.177569329738617, 0.177360355854034, 0.177151724696159, 0.176943525671959, 0.176735669374466, 0.176528140902519, 0.176320746541023, 0.176113769412041, 0.175907149910927, 0.175700843334198, 0.175494894385338, 0.175289109349251, 0.175083860754967, 0.174878686666489, 0.174674019217491, 0.174469590187073, 0.174265652894974, 0.174061924219131, 0.173858478665352, 0.173655301332474, 0.173452526330948, 0.173250138759613, 0.173047944903374, 0.172846078872681, 0.172644674777985, 0.172443345189095, 0.172242552042007, 0.172042101621628, 0.171841859817505, 0.171641811728477, 0.171442329883575, 0.171243101358414, 0.171044185757637, 0.170845657587051, 0.170647248625755, 0.170449361205101, 0.170251592993736, 0.170054242014885, 0.169857263565063, 0.169660612940788, 0.169464305043221, 0.169268175959587, 0.169072464108467, 0.16887703537941, 0.168682038784027, 0.168487131595612, 0.168293371796608, 0.168122380971909, 0.167951464653015, 0.167781010270119, 0.167610704898834, 0.16744077205658, 0.167270973324776, 0.167101547122002, 0.166932344436646, 0.166763424873352, 0.166594862937927, 0.166426420211792, 0.166258335113525, 0.166090443730354, 0.165922805666924, 0.16575562953949, 0.16558863222599, 0.165421798825264, 0.165255218744278, 0.165089085698128, 0.164923191070557, 0.16475747525692, 0.16459196805954, 0.164426863193512, 0.164262026548386, 0.164097368717194, 0.163932994008064, 0.163768962025642, 0.163605242967606, 0.163441613316536, 0.163278311491013, 0.16311539709568, 0.162952765822411, 0.162790313363075, 0.162628099322319, 0.162466108798981, 0.162304535508156, 0.162143111228943, 0.161982074379921, 0.161821156740189, 0.161660671234131, 0.161500304937363, 0.161340340971947, 0.161180570721626, 0.161021158099174, 0.16086183488369, 0.160702958703041, 0.160544291138649, 0.160385742783546, 0.160227656364441, 0.160069823265076, 0.159912258386612, 0.159754827618599, 0.159597814083099, 0.159441038966179, 0.159284606575966, 0.159128397703171, 0.158972218632698, 0.15881659090519, 0.158661171793938, 0.158505976200104, 0.158350989222527, 0.158196419477463, 0.158042103052139, 0.157887935638428, 0.157734096050262, 0.15758053958416, 0.157427310943604, 0.157274231314659, 0.157121554017067, 0.156969085335732, 0.15681679546833, 0.156664878129959, 0.156513288617134, 0.156361877918243, 0.156210631132126, 0.156059846282005, 0.155909284949303, 0.155759006738663, 0.155608937144279, 0.155459091067314, 0.15530963242054, 0.155160412192345, 0.155011266469955, 0.154862642288208, 0.154714241623878, 0.154566153883934, 0.154418081045151, 0.154270514845848, 0.154123201966286, 0.153976187109947, 0.153829291462898, 0.153682708740234, 0.153536483645439, 0.153390422463417, 0.153244659304619, 0.153099209070206, 0.152954056859016, 0.152809053659439, 0.152664467692375, 0.152511700987816, 0.152335152029991, 0.152158632874489, 0.151982754468918, 0.151807397603989, 0.151632338762283, 0.151457756757736, 0.151283338665962, 0.151109576225281, 0.150936231017113, 0.150763273239136, 0.150590434670448, 0.150418281555176, 0.150246500968933, 0.150075256824493, 0.149904295802116, 0.14973358809948, 0.149563506245613, 0.149393856525421, 0.149224489927292, 0.149055749177933, 0.148886889219284, 0.148718968033791, 0.148551434278488, 0.148384168744087, 0.1482173204422, 0.148050710558891, 0.147884756326675, 0.147719219326973, 0.147553950548172, 0.147389069199562, 0.147224694490433, 0.147060766816139, 0.146897181868553, 0.146734178066254, 0.146571144461632, 0.146408930420876, 0.146247059106827, 0.146085649728775, 0.145924597978592, 0.14576356112957, 0.145603433251381, 0.145443603396416, 0.14528414607048, 0.145124956965446, 0.144966453313828, 0.144808173179626, 0.144650310277939, 0.144492983818054, 0.144335925579071, 0.144179373979568, 0.144023239612579, 0.143867507576942, 0.143712148070335, 0.143557071685791, 0.14340253174305, 0.143248498439789, 0.143094882369041, 0.142941698431969, 0.142788574099541, 0.142636150121689, 0.142484113574028, 0.142332479357719, 0.142181381583214, 0.142030268907547, 0.141879960894585, 0.141730055212975, 0.141580387949944, 0.141431018710136, 0.141282275319099, 0.141133964061737, 0.140986040234566, 0.140838518738747, 0.140691250562668, 0.140544533729553, 0.140398323535919, 0.140252351760864, 0.140106961131096, 0.139961704611778, 0.139817073941231, 0.139672860503197, 0.139529049396515, 0.139385759830475, 0.139242455363274, 0.139099851250648, 0.138957753777504, 0.13881604373455, 0.138674363493919, 0.13853345811367, 0.138392940163612, 0.138252809643745, 0.138113096356392, 0.137973681092262, 0.137834757566452, 0.137696385383606, 0.137558236718178, 0.137420639395714, 0.137283205986023, 0.13714624941349, 0.137009993195534, 0.136911645531654, 0.136827856302261, 0.136744007468224, 0.136660426855087, 0.136577099561691, 0.136493965983391, 0.13641069829464, 0.136327847838402, 0.136245146393776, 0.136162623763084, 0.136080339550972, 0.135997921228409, 0.135915890336037, 0.135834068059921, 0.135752350091934, 0.135670870542526, 0.135589227080345, 0.135508134961128, 0.135427072644234, 0.135346293449402, 0.13526563346386, 0.135184794664383, 0.135104462504387, 0.135024383664131, 0.134944260120392, 0.134864136576653, 0.134784519672394, 0.134705021977425, 0.134625628590584, 0.134546473622322, 0.134467393159866, 0.134388357400894, 0.134309783577919, 0.13423128426075, 0.134152978658676, 0.134074479341507, 0.133996427059174, 0.133918598294258, 0.133841067552567, 0.13376347720623, 0.133685871958733, 0.133608818054199, 0.133531674742699, 0.133454740047455, 0.133377924561501, 0.13330152630806, 0.133225157856941, 0.133148953318596, 0.13307312130928, 0.132996827363968, 0.132921203970909, 0.132845565676689, 0.132770404219627, 0.132695272564888, 0.132619842886925, 0.132544979453087, 0.132470458745956, 0.132395997643471, 0.13232147693634, 0.132247149944305, 0.132173269987106, 0.132099345326424, 0.132025793194771, 0.131952181458473, 0.131878554821014, 0.131805419921875, 0.131732314825058, 0.131659746170044, 0.131586596369743, 0.131514087319374, 0.131441846489906, 0.131369739770889, 0.131297543644905, 0.131225511431694, 0.131153851747513, 0.131082385778427, 0.131011053919792, 0.130939871072769, 0.130868673324585, 0.130797788500786, 0.130727171897888, 0.130656763911247, 0.130586087703705, 0.130515858530998, 0.130446031689644, 0.130376189947128, 0.130306497216225, 0.13023667037487, 0.130167424678802, 0.130098238587379, 0.130029186606407, 0.129960283637047, 0.12989142537117, 0.12982302904129, 0.129754692316055, 0.129686638712883, 0.129618749022484, 0.129550352692604, 0.129482746124268, 0.129415452480316, 0.129330441355705, 0.129253759980202, 0.129176497459412, 0.129098191857338, 0.12901896238327, 0.128939419984818, 0.128858312964439, 0.128776088356972, 0.128692895174026, 0.128608658909798, 0.128523766994476, 0.128438025712967, 0.128350988030434, 0.128263279795647, 0.128174215555191, 0.128084301948547, 0.127993747591972, 0.127902016043663, 0.12780936062336, 0.127715662121773, 0.127621054649353, 0.127526178956032, 0.127429753541946, 0.127332285046577, 0.127233892679214, 0.127134650945663, 0.127034366130829, 0.12693278491497, 0.12683080136776, 0.126727595925331, 0.126623675227165, 0.126518428325653, 0.12641254067421, 0.126305416226387, 0.126197457313538, 0.126088619232178, 0.125979289412498, 0.125868514180183, 0.125756695866585, 0.125643879175186, 0.125530108809471, 0.125415608286858, 0.125300213694572, 0.125183314085007, 0.125065952539444, 0.124947413802147, 0.124828092753887, 0.124707661569118, 0.124586388468742, 0.124463871121407, 0.124340772628784, 0.124216638505459, 0.124091900885105, 0.123966000974178, 0.123838797211647, 0.123710729181767, 0.123581632971764, 0.123451754450798, 0.123320959508419, 0.123189061880112, 0.123056374490261, 0.122922450304031, 0.122787743806839, 0.122652128338814, 0.12251553684473, 0.122377820312977, 0.122239142656326, 0.122100010514259, 0.121959753334522, 0.121818535029888, 0.121675997972488, 0.121532820165157, 0.121388524770737, 0.121243126690388, 0.121097013354301, 0.120949789881706, 0.120801657438278, 0.120652668178082, 0.120502576231956, 0.120351761579514, 0.120199710130692, 0.120046809315681, 0.119893200695515, 0.119738154113293, 0.11958297342062, 0.119426108896732, 0.119268640875816, 0.119110137224197, 0.118950523436069, 0.118790000677109, 0.118628360331059, 0.118466012179852, 0.118302553892136, 0.118138238787651, 0.117972828447819, 0.117806561291218, 0.117639519274235, 0.117471173405647, 0.117301903665066, 0.117131933569908, 0.116916052997112, 0.116658635437489, 0.116402000188828, 0.116144061088562, 0.11588691174984, 0.115629233419895, 0.115370772778988, 0.115113101899624, 0.114854127168655, 0.114596180617809, 0.114337466657162, 0.114078231155872, 0.113818988204002, 0.113559745252132, 0.113300248980522, 0.113040752708912, 0.112780459225178, 0.112520441412926, 0.112260155379772, 0.111999347805977, 0.111738547682762, 0.111477218568325, 0.111216150224209, 0.110955089330673, 0.110693238675594, 0.110431648790836, 0.110169544816017, 0.109907165169716, 0.109644539654255, 0.109381645917892, 0.109119541943073, 0.108856648206711, 0.108592711389065, 0.108329564332962, 0.108065627515316, 0.107802212238312, 0.107537761330605, 0.107273302972317, 0.107008844614029, 0.106744647026062, 0.106479153037071, 0.106214433908463, 0.10594867169857, 0.105683177709579, 0.105417408049107, 0.105151392519474, 0.10488536208868, 0.104619354009628, 0.104352802038193, 0.104086264967918, 0.103819198906422, 0.103552132844925, 0.103284545242786, 0.103016965091228, 0.102749384939671, 0.102481007575989, 0.102212905883789, 0.101944014430046, 0.101675905287266, 0.101407006382942, 0.101137861609459, 0.100868716835976, 0.10059929639101, 0.100329883396626, 0.100060477852821, 0.099790021777153, 0.0995198264718056, 0.0992493778467178, 0.0989783927798271, 0.0987079441547394, 0.0984364449977875, 0.0981652066111565, 0.0978939682245255, 0.0976216867566109, 0.097350187599659, 0.0970781743526459, 0.0968058928847313, 0.0965333506464958, 0.0962600260972977, 0.0959882587194443, 0.0957152023911476, 0.0954416170716286, 0.0951677709817886, 0.0948941856622696, 0.0946203395724297, 0.0943459719419479, 0.0940713435411453, 0.0937967225909233, 0.0935223549604416, 0.0932469442486763, 0.0929720625281334, 0.0926963835954666, 0.0924207121133804, 0.0921453014016151, 0.0918688476085663, 0.091593436896801, 0.0913167223334312, 0.0910400152206421, 0.0907635539770126, 0.0904860645532608, 0.0902382880449295, 0.0900134816765785, 0.0897902399301529, 0.0895677655935287, 0.0893468633294106, 0.0891272649168968, 0.0889084488153458, 0.0886909440159798, 0.0884752497076988, 0.0882603526115417, 0.0880472660064697, 0.0878344625234604, 0.0876229405403137, 0.0874135121703148, 0.08720513433218, 0.0869972705841064, 0.0867917537689209, 0.0865862369537354, 0.0863822922110558, 0.0861796513199806, 0.0859790965914726, 0.0857790559530258, 0.0855797976255417, 0.0853823646903038, 0.0851865038275719, 0.0849911645054817, 0.0847973823547363, 0.0846043825149536, 0.0844132080674171, 0.0842233449220657, 0.0840340033173561, 0.0838464871048927, 0.0836597457528114, 0.083474837243557, 0.0832904502749443, 0.0831081420183182, 0.0829268842935562, 0.0827464088797569, 0.0825667157769203, 0.0823893770575523, 0.0822125375270844, 0.0820375457406044, 0.081863060593605, 0.0816901475191116, 0.0815185382962227, 0.0813482403755188, 0.081178717315197, 0.0810110121965408, 0.0808438360691071, 0.0806790068745613, 0.0805144384503365, 0.0803511738777161, 0.0801897346973419, 0.080029085278511, 0.0798692107200623, 0.0797114223241806, 0.0795546770095825, 0.079398974776268, 0.0792440548539162, 0.0790909752249718, 0.0789394378662109, 0.0787886902689934, 0.0786389857530594, 0.0784911140799522, 0.078343503177166, 0.0781984850764275, 0.0780529603362083, 0.0779097825288773, 0.07776790112257, 0.077627070248127, 0.0774872675538063, 0.0773493051528931, 0.0772121250629425, 0.077075719833374, 0.0769406259059906, 0.0768078714609146, 0.0766753926873207, 0.0765439420938492, 0.0764148458838463, 0.0762857496738434, 0.076158732175827, 0.0760322436690331, 0.0759075805544853, 0.0757842212915421, 0.0756616368889809, 0.0755406245589256, 0.0754209160804749, 0.0753019899129868, 0.0751848816871643, 0.0750677883625031, 0.0749530345201492, 0.0748398452997208, 0.0747266486287117, 0.0746152848005295, 0.0745057538151741, 0.0743967369198799, 0.074289545416832, 0.074182353913784, 0.0740775093436241, 0.0739737078547478, 0.0738991424441338, 0.073844239115715, 0.0737906023859978, 0.0737377107143402, 0.073685348033905, 0.0736331939697266, 0.0735823288559914, 0.0735322237014771, 0.0734826102852821, 0.0734332203865051, 0.0733848586678505, 0.0733377933502197, 0.0732906758785248, 0.0732443183660507, 0.0731987282633781, 0.0731541514396667, 0.0731103345751762, 0.0730664953589439, 0.0730239227414131, 0.0729821026325226, 0.0729410499334335, 0.0728996992111206, 0.0728601589798927, 0.0728211104869843, 0.072782576084137, 0.0727442502975464, 0.0727074816823006, 0.0726709440350533, 0.0726349055767059, 0.0725998729467392, 0.0725653469562531, 0.0725320875644684, 0.0724982917308807, 0.0724662840366364, 0.0724347904324532, 0.0724040418863297, 0.0723732635378838, 0.0723437741398811, 0.0723152905702591, 0.0722872987389565, 0.0722595676779747, 0.0722328424453735, 0.0722068622708321, 0.0721816420555115, 0.0721564143896103, 0.0721327140927315, 0.0721094980835915, 0.0720870718359947, 0.0720648542046547, 0.0720436424016953, 0.0720232278108597, 0.0720035433769226, 0.0719838216900826, 0.0719653815031052, 0.0719477161765099, 0.0719307959079742, 0.0719141066074371, 0.071898452937603, 0.07188381254673, 0.0718696564435959, 0.0718554928898811, 0.0718428492546082, 0.0718309655785561, 0.0718196034431458, 0.0718081966042519, 0.0717983096837997, 0.0717889219522476, 0.0717803314328194, 0.0717719420790672, 0.0717648267745972, 0.0717582330107689, 0.0717523694038391, 0.0717462375760078, 0.0717421621084213, 0.0717380493879318, 0.0717349648475647, 0.0717323645949364, 0.0717305466532707, 0.0717294663190842, 0.0717288851737976, 0.0717290714383125, 0.071730263531208, 0.0717319473624229, 0.0717344060540199, 0.0717370808124542, 0.0717410445213318, 0.0717457607388496, 0.0717504620552063, 0.0717564299702644, 0.0717626363039017, 0.0717703849077225, 0.0717778280377388, 0.0717862918972969, 0.0717957988381386, 0.0718057900667191, 0.0718160048127174, 0.0718275308609009, 0.0718395113945007, 0.0718525275588036, 0.0718657746911049, 0.071869358420372, 0.0718566030263901, 0.0718435719609261, 0.0718303918838501, 0.0718167647719383, 0.0718030035495758, 0.0717888250946999, 0.0717744752764702, 0.0717598423361778, 0.0717450678348541, 0.0717298835515976, 0.0717142522335052, 0.0716986060142517, 0.0716829672455788, 0.0716664865612984, 0.0716501027345657, 0.0716333314776421, 0.0716163814067841, 0.071599155664444, 0.07158163189888, 0.0715639740228653, 0.0715458765625954, 0.0715276226401329, 0.0715091079473495, 0.0714902877807617, 0.0714711770415306, 0.071451798081398, 0.0714322328567505, 0.0714120045304298, 0.071392148733139, 0.0713717490434647, 0.0713507905602455, 0.0713302120566368, 0.0713088139891624, 0.0712872594594955, 0.0712656825780869, 0.0712437033653259, 0.0712215453386307, 0.071198970079422, 0.0711761340498924, 0.0711532458662987, 0.0711299404501915, 0.0711062252521515, 0.0710824877023697, 0.0710584670305252, 0.0710340142250061, 0.0710095539689064, 0.0709846764802933, 0.0709592327475548, 0.0709340572357178, 0.0709081739187241, 0.0708824023604393, 0.0708560794591904, 0.0708296149969101, 0.0708029791712761, 0.0707759261131287, 0.0707487389445305, 0.0707212463021278, 0.0706934630870819, 0.0706654042005539, 0.0706371739506721, 0.0706086754798889, 0.0705797448754311, 0.0705508142709732, 0.0705214440822601, 0.0704916566610336, 0.0704619884490967, 0.0704315081238747, 0.0704012587666512, 0.0703704729676247, 0.0703395083546638, 0.0703085213899612, 0.0702770128846169, 0.0702451914548874, 0.0702133625745773, 0.0701809749007225, 0.0701485723257065, 0.0701158791780472, 0.0700827389955521, 0.0700494796037674, 0.0700159221887589, 0.0699822008609772, 0.0699479579925537, 0.0699137970805168, 0.0698788315057755, 0.0698442384600639, 0.0698088407516479, 0.0697735324501991, 0.0697376877069473, 0.0697019472718239, 0.069665789604187, 0.0696293264627457, 0.069592610001564, 0.0695555806159973, 0.0695184022188187, 0.0694808065891266, 0.0694430693984032, 0.0694051533937454, 0.0693668350577354, 0.0693282335996628, 0.069275826215744, 0.0692207962274551, 0.06916543841362, 0.0691096931695938, 0.0690535604953766, 0.0689970925450325, 0.0689405649900436, 0.0688833147287369, 0.0688258782029152, 0.0687679722905159, 0.0687095522880554, 0.0686510056257248, 0.0685920640826225, 0.0685326680541039, 0.0684729442000389, 0.0684128254652023, 0.0683521181344986, 0.0682914853096008, 0.0682301968336105, 0.068168580532074, 0.0681063830852509, 0.0680443048477173, 0.0679813921451569, 0.0679182112216949, 0.0678547024726868, 0.0677910000085831, 0.0677266493439674, 0.0676620975136757, 0.0675972178578377, 0.0675318241119385, 0.067466102540493, 0.0674000605940819, 0.0673334822058678, 0.0672667846083641, 0.067199632525444, 0.0671318843960762, 0.0670640170574188, 0.0669955536723137, 0.0669270232319832, 0.0668577775359154, 0.0667884051799774, 0.0667185038328171, 0.0666484162211418, 0.0665780007839203, 0.0665068626403809, 0.0664357244968414, 0.0663641467690468, 0.0662919655442238, 0.0662195980548859, 0.0661468207836151, 0.0660736709833145, 0.0660001188516617, 0.0659261867403984, 0.0658521205186844, 0.0657773315906525, 0.0657022893428802, 0.0656269118189812, 0.0655512139201164, 0.0654748007655144, 0.0653985142707825, 0.0653215125203133, 0.0652442425489426, 0.0651666596531868, 0.0650886073708534, 0.0650103017687798, 0.0649316683411598, 0.0648524537682533, 0.06477290391922, 0.0646932944655418, 0.0646128356456757, 0.0645322501659393, 0.0644514635205269, 0.0643700286746025, 0.0642881989479065, 0.0642063096165657, 0.0641236379742622, 0.0640407651662827, 0.0639575645327568, 0.0638739764690399, 0.0637900605797768, 0.0637056976556778, 0.0636210665106773, 0.0635359808802605, 0.063450500369072, 0.0633648186922073, 0.0632785633206367, 0.0631920397281647, 0.0631051287055016, 0.0630178824067116, 0.0629301890730858, 0.0628420412540436, 0.0627536922693253, 0.0626646876335144, 0.0625757575035095, 0.062486108392477, 0.0623960644006729, 0.0623060204088688, 0.0622152611613274, 0.0621241107583046, 0.0620328933000565, 0.0619397237896919, 0.0618420504033566, 0.0617444440722466, 0.0616468340158463, 0.0615489669144154, 0.0614511705935001, 0.0613533705472946, 0.0612553730607033, 0.0611574351787567, 0.061059508472681, 0.0609614439308643, 0.0608633123338223, 0.0607651881873608, 0.060667060315609, 0.0605686716735363, 0.0604704134166241, 0.0603720881044865, 0.0602736361324787, 0.0601751171052456, 0.0600765347480774, 0.0599780827760696, 0.0598793663084507, 0.0597806498408318, 0.0596820637583733, 0.0595832876861095, 0.0594844445586205, 0.0593855939805508, 0.0592866837978363, 0.0591876432299614, 0.0590886063873768, 0.0589895620942116, 0.0588905215263367, 0.0587910935282707, 0.0586920529603958, 0.0585927478969097, 0.0584932528436184, 0.0583938844501972, 0.0582945831120014, 0.0581950284540653, 0.0580953285098076, 0.057995967566967, 0.0578962042927742, 0.0577965155243874, 0.0576966889202595, 0.0575969368219376, 0.0574971139431, 0.0573971532285213, 0.0572972036898136, 0.0571973137557507, 0.0570971667766571, 0.0569970831274986, 0.0568969324231148, 0.0567966550588608, 0.0566963739693165, 0.056595966219902, 0.0564958155155182, 0.056395273655653, 0.0562947355210781, 0.0561942607164383, 0.0560937859117985, 0.0559930503368378, 0.0558923780918121, 0.0557917766273022, 0.0556907765567303, 0.0555900447070599, 0.0554892420768738, 0.0553884394466877, 0.0552873127162457, 0.0551862493157387, 0.0550853237509727, 0.0549839958548546, 0.0548828691244125, 0.0547816790640354, 0.0546803548932076, 0.05457903444767, 0.0544776432216167, 0.0543761253356934, 0.0542746111750603, 0.0541730895638466, 0.0540714450180531, 0.0539699196815491, 0.0538682080805302, 0.0537664294242859, 0.0536645874381065, 0.0535627454519272, 0.0534607693552971, 0.0533588565886021, 0.0532569512724876, 0.053154781460762, 0.0530527383089066, 0.0529505684971809, 0.0528482086956501, 0.0527460984885693, 0.0526437945663929, 0.0525413677096367, 0.0524389371275902, 0.0523365698754787, 0.0522338785231113, 0.0521314479410648, 0.0520287528634071, 0.0519322268664837, 0.0518384650349617, 0.0517449006438255, 0.0516514703631401, 0.0515582300722599, 0.0514654479920864, 0.0513725988566875, 0.0512800142168999, 0.0511878207325935, 0.0510956905782223, 0.0510037615895271, 0.0509120225906372, 0.0508205406367779, 0.050729263573885, 0.0506383664906025, 0.050547543913126, 0.0504569187760353, 0.0503665469586849, 0.0502762421965599, 0.0501862652599812, 0.0500964187085629, 0.0500068329274654, 0.0499174371361732, 0.0498283766210079, 0.0497394427657127, 0.0496506355702877, 0.0495622232556343, 0.049473874270916, 0.0493857227265835, 0.0492977648973465, 0.0492103360593319, 0.0491227656602859, 0.0490354634821415, 0.0489484891295433, 0.0488618314266205, 0.048775177448988, 0.0486887246370316, 0.0486025214195251, 0.0485166572034359, 0.0484308488667011, 0.0483452416956425, 0.0482599586248398, 0.0481748059391975, 0.0480898506939411, 0.0480052828788757, 0.047920785844326, 0.0478364117443562, 0.0477523021399975, 0.0476685166358948, 0.0475848615169525, 0.0475016012787819, 0.0474182739853859, 0.0473353378474712, 0.0472525358200073, 0.0471699871122837, 0.0470876395702362, 0.0470054224133492, 0.0469235293567181, 0.0468417629599571, 0.0467601977288723, 0.0466788932681084, 0.046597845852375, 0.0465169325470924, 0.0464362166821957, 0.0463557578623295, 0.0462754927575588, 0.046195425093174, 0.0461156852543354, 0.0460360087454319, 0.0459567271173, 0.0458775050938129, 0.0457986108958721, 0.0457197837531567, 0.0456412136554718, 0.0455629080533981, 0.0454848632216454, 0.0454068146646023, 0.0453291609883308, 0.0452516339719296, 0.0451743714511395, 0.0450973063707352, 0.0450204350054264, 0.0449436902999878, 0.0448672771453857, 0.0447911210358143, 0.0447150319814682, 0.0446391403675079, 0.0445636324584484, 0.0444884561002254, 0.0444132164120674, 0.0443381704390049, 0.0442635118961334, 0.0441889874637127, 0.0441145896911621, 0.0440405234694481, 0.0439666509628296, 0.0438929051160812, 0.0438194274902344, 0.0437462702393532, 0.043673112988472, 0.0436024367809296, 0.0435449965298176, 0.0434875525534153, 0.0434300452470779, 0.043372668325901, 0.0433150976896286, 0.0432578474283218, 0.0432002767920494, 0.0431428998708725, 0.0430852584540844, 0.043027751147747, 0.0429702438414097, 0.0429127998650074, 0.0428553596138954, 0.0427975915372372, 0.0427400842308998, 0.0426825769245625, 0.0426250696182251, 0.0425674952566624, 0.0425098612904549, 0.0424522832036018, 0.0423947758972645, 0.0423372723162174, 0.0422796979546547, 0.0422220602631569, 0.0421645529568195, 0.0421069152653217, 0.042049340903759, 0.0419915728271008, 0.0419340021908283, 0.0418763644993305, 0.0418187901377678, 0.0417610220611095, 0.0417034514248371, 0.0416457466781139, 0.0415881089866161, 0.041530467569828, 0.0414727032184601, 0.0414150021970272, 0.0413573607802391, 0.0412996597588062, 0.0412420183420181, 0.0411843173205853, 0.0411266125738621, 0.0410688444972038, 0.0410112701356411, 0.0409535691142082, 0.0408956706523895, 0.0408379659056664, 0.0407802015542984, 0.0407224968075752, 0.0406645983457565, 0.040606826543808, 0.04054906219244, 0.0404913611710072, 0.0404335223138332, 0.0403756909072399, 0.0403177924454212, 0.040260087698698, 0.0402022562921047, 0.0401445515453815, 0.0400866530835629, 0.0400288850069046, 0.0399711169302464, 0.0399132184684277, 0.0398551896214485, 0.0397974215447903, 0.0397395193576813, 0.0396816916763783, 0.0396238528192043, 0.0395658947527409, 0.0395079925656319, 0.0394500941038132, 0.0393921993672848, 0.0393343605101109, 0.0392763316631317, 0.039218433201313, 0.0391605347394943, 0.0391026362776756, 0.0390447378158569, 0.0389867089688778, 0.0389287434518337, 0.038870844990015, 0.0388128831982613, 0.038754791021347, 0.0386967584490776, 0.0386388599872589, 0.0385808944702148, 0.0385227352380753, 0.0384647734463215, 0.0384068042039871, 0.0383487790822983, 0.0382908172905445, 0.0382326543331146, 0.0381745621562004, 0.0381166003644466, 0.0380585677921772, 0.0380006693303585, 0.0379423797130585, 0.0378844812512398, 0.0378276407718658, 0.037750493735075, 0.0376732125878334, 0.0375956483185291, 0.0375180579721928, 0.0374402590095997, 0.0373624227941036, 0.0372842624783516, 0.0372059941291809, 0.0371275991201401, 0.037049125880003, 0.0369704179465771, 0.0368914417922497, 0.0368124917149544, 0.0367334112524986, 0.0366540513932705, 0.0365745946764946, 0.0364949330687523, 0.0364151298999786, 0.036335214972496, 0.0362551659345627, 0.0361748337745667, 0.0360944382846355, 0.0360139273107052, 0.035933293402195, 0.0358524359762669, 0.0357713475823402, 0.0356901884078979, 0.0356088913977146, 0.0355274230241776, 0.0354458726942539, 0.0353639870882034, 0.0352820828557014, 0.0352000072598457, 0.0351178050041199, 0.035035390406847, 0.0349527448415756, 0.0348700806498528, 0.0347872152924538, 0.0347042642533779, 0.0346210077404976, 0.0345376990735531, 0.0344542302191257, 0.0343706682324409, 0.0342867784202099, 0.034202866256237, 0.0341187864542007, 0.0340345501899719, 0.0339501947164536, 0.0338655486702919, 0.0337808765470982, 0.0336960665881634, 0.0336110331118107, 0.0335259139537811, 0.0334405191242695, 0.0333549566566944, 0.0332694053649902, 0.0331836827099323, 0.0330977514386177, 0.0330115482211113, 0.0329253040254116, 0.0328389927744865, 0.0327524021267891, 0.032665591686964, 0.0325787737965584, 0.0324917919933796, 0.0324046649038792, 0.0323173776268959, 0.0322297550737858, 0.0321421213448048, 0.0320543870329857, 0.0319665223360062, 0.0318783596158028, 0.0317900627851486, 0.031701672822237, 0.0316131226718426, 0.0315244384109974, 0.0314356684684753, 0.0313465446233749, 0.0312573350965977, 0.0311680492013693, 0.0310786180198193, 0.0309888180345297, 0.0308990944176912, 0.0308092124760151, 0.0307191628962755, 0.0306288581341505, 0.0305384006351233, 0.0304479077458382, 0.0303571242839098, 0.030266348272562, 0.0301753524690866, 0.0300840046256781, 0.0299927741289139, 0.029901335015893, 0.0298097264021635, 0.0297177694737911, 0.029625877737999, 0.0295338351279497, 0.0294415671378374, 0.029346814379096, 0.0292488504201174, 0.0291509740054607, 0.0290534719824791, 0.0289559755474329, 0.0288588479161263, 0.0287616811692715, 0.0286649093031883, 0.0285683684051037, 0.0284717902541161, 0.0283756088465452, 0.0282795336097479, 0.0281836874783039, 0.0280880890786648, 0.0279924757778645, 0.027897372841835, 0.0278022214770317, 0.0277074668556452, 0.0276126973330975, 0.0275181550532579, 0.0274237338453531, 0.0273296739906073, 0.0272356066852808, 0.0271419119089842, 0.0270483084022999, 0.0269549619406462, 0.0268617179244757, 0.0267688538879156, 0.0266760885715485, 0.0265833232551813, 0.0264910645782948, 0.026398753747344, 0.0263067092746496, 0.0262149125337601, 0.0261232051998377, 0.0260317604988813, 0.0259405374526978, 0.0258495733141899, 0.0257585607469082, 0.0256678238511086, 0.0255774483084679, 0.0254871770739555, 0.0253970269113779, 0.0253071244806051, 0.0252173002809286, 0.0251278597861528, 0.0250385515391827, 0.0249493476003408, 0.0248603709042072, 0.0247716568410397, 0.024683179333806, 0.0245947912335396, 0.0245065335184336, 0.0244185198098421, 0.0243308637291193, 0.0242431946098804, 0.0241557750850916, 0.0240684617310762, 0.0239817686378956, 0.0238949451595545, 0.0238083563745022, 0.0237218681722879, 0.0236356239765882, 0.0235496386885643, 0.0234636291861534, 0.0233779735863209, 0.0232925750315189, 0.0232072938233614, 0.0231221150606871, 0.0230373106896877, 0.0229525975883007, 0.0228680167347193, 0.0227836705744267, 0.0226995702832937, 0.0226155910640955, 0.0225318223237991, 0.0224483236670494, 0.0223649498075247, 0.0222817845642567, 0.022198872640729, 0.0221160594373941, 0.0220334958285093, 0.0219509024173021, 0.0218688417226076, 0.0217867530882359, 0.0217050202190876, 0.0216232761740685, 0.0215418878942728, 0.0214605163782835, 0.0213796272873878, 0.0212987121194601, 0.0212180577218533, 0.0211376417428255, 0.021057303994894, 0.0209772363305092, 0.0208972673863173, 0.0208175517618656, 0.0207380708307028, 0.0206587053835392, 0.0205795913934708, 0.0205043312162161, 0.0204465966671705, 0.0203888602554798, 0.0203318428248167, 0.0202745627611876, 0.0202175453305244, 0.0201610159128904, 0.0201047137379646, 0.020048413425684, 0.0199924688786268, 0.0199367869645357, 0.019881235435605, 0.0198261421173811, 0.0197710450738668, 0.0197163764387369, 0.0196618996560574, 0.0196075215935707, 0.0195534359663725, 0.0194996781647205, 0.0194460172206163, 0.0193928144872189, 0.0193396098911762, 0.0192868616431952, 0.0192342437803745, 0.0191817581653595, 0.0191297270357609, 0.0190776959061623, 0.0190261229872704, 0.0189746767282486, 0.018923494964838, 0.0188723765313625, 0.0188218131661415, 0.0187713801860809, 0.0187209788709879, 0.018671004101634, 0.0186212882399559, 0.0185717679560184, 0.0185223761945963, 0.0184734109789133, 0.0184244439005852, 0.0183759350329638, 0.0183275546878576, 0.0182794351130724, 0.018231512978673, 0.0181841794401407, 0.0181366465985775, 0.0180893409997225, 0.0180428214371204, 0.0179958119988441, 0.0179495848715305, 0.0179033875465393, 0.0178575199097395, 0.017811618745327, 0.0177661720663309, 0.017720889300108, 0.017675869166851, 0.0176311396062374, 0.0175865758210421, 0.0175422709435225, 0.0174981635063887, 0.0174543149769306, 0.017410758882761, 0.0173674002289772, 0.0173241402953863, 0.0172813031822443, 0.0172387603670359, 0.0171962473541498, 0.0171541273593903, 0.0171122048050165, 0.0170705411583185, 0.0170289427042007, 0.0169878639280796, 0.0169467888772488, 0.0169060379266739, 0.0168656781315804, 0.0168252196162939, 0.0167853180319071, 0.01674541272223, 0.0167059358209372, 0.0166665203869343, 0.0166274979710579, 0.0165886394679546, 0.016550038009882, 0.0165116339921951, 0.0164734926074743, 0.0164356082677841, 0.0163979232311249, 0.016360791400075, 0.0163232684135437, 0.0162864290177822, 0.0162498522549868, 0.0162132084369659, 0.0161771513521671, 0.0161411613225937, 0.0161054953932762, 0.0160698629915714, 0.0160344913601875, 0.0159996096044779, 0.0159647911787033, 0.0159301701933146, 0.0158950909972191, 0.0158521234989166, 0.0158092211931944, 0.0157663505524397, 0.0157234817743301, 0.0156807098537683, 0.0156378708779812, 0.0155952144414186, 0.0155524909496307, 0.0155098494142294, 0.0154672414064407, 0.0154246808961034, 0.0153821213170886, 0.0153396418318152, 0.0152971474453807, 0.0152547834441066, 0.0152124175801873, 0.0151700526475906, 0.0151277706027031, 0.015085487626493, 0.0150432530790567, 0.0150011163204908, 0.0149588985368609, 0.014916779473424, 0.0148747246712446, 0.0148327015340328, 0.0147907128557563, 0.0147487223148346, 0.0147068304941058, 0.0146649712696671, 0.0146231120452285, 0.01458131801337, 0.0145395575091243, 0.0144978128373623, 0.0144561808556318, 0.0144145004451275, 0.0143728703260422, 0.0143313044682145, 0.0142897386103868, 0.0142482547089458, 0.0142068350687623, 0.0141653995960951, 0.0141240293160081, 0.0140826925635338, 0.0140414191409945, 0.0140001475811005, 0.0139589067548513, 0.0139177339151502, 0.013876574113965, 0.0138354813680053, 0.0137944044545293, 0.0137533275410533, 0.0137123493477702, 0.0136714670807123, 0.0136304888874292, 0.013589589856565, 0.0135488081723452, 0.0135079594329, 0.0134671917185187, 0.0134264901280403, 0.0133858034387231, 0.0133451847359538, 0.013304547406733, 0.0132639929652214, 0.0132234366610646, 0.0131829790771008, 0.0131425056606531, 0.0131020806729794, 0.0130617041140795, 0.0130213452503085, 0.0129810674116015, 0.0129407895728946, 0.0129006085917354, 0.0128603959456086, 0.0128202326595783, 0.0127801494672894, 0.0127400672063231, 0.0127000333741307, 0.0126600656658411, 0.0126201128587127, 0.0125801945105195, 0.0125403068959713, 0.0125004528090358, 0.0124606471508741, 0.0124209066852927, 0.0123811671510339, 0.0123415244743228, 0.0123018492013216, 0.012262255884707, 0.0122226951643825, 0.0121831344440579, 0.0121436389163136, 0.0121041750535369, 0.0120647624135017, 0.012025379575789, 0.0119860302656889, 0.0119467964395881, 0.0119075123220682, 0.0118682766333222, 0.0118290754035115, 0.0117902969941497, 0.0117454864084721, 0.0117007913067937, 0.0116562591865659, 0.0116119217127562, 0.0115675684064627, 0.0115234442055225, 0.0114794662222266, 0.011435586027801, 0.0113918352872133, 0.0113482149317861, 0.0113046457991004, 0.0112613029778004, 0.0112180570140481, 0.0111749758943915, 0.0111318938434124, 0.011089138686657, 0.0110463006421924, 0.0110037252306938, 0.0109611321240664, 0.0109189627692103, 0.01087661460042, 0.0108345923945308, 0.0107925711199641, 0.010750743560493, 0.0107090156525373, 0.0106674814596772, 0.0106259481981397, 0.0105847092345357, 0.0105434199795127, 0.010502458550036, 0.0104613807052374, 0.0104206632822752, 0.0103799114003778, 0.0103393895551562, 0.0102989478036761, 0.0102587351575494, 0.0102184405550361, 0.010178504511714, 0.0101385032758117, 0.0100987628102303, 0.0100590232759714, 0.0100196413695812, 0.00998013094067574, 0.00994094368070364, 0.00990174151957035, 0.00986273586750031, 0.00982377678155899, 0.00978512968868017, 0.00974641554057598, 0.0097079798579216, 0.00966952741146088, 0.00963133573532104, 0.00959312822669744, 0.00955522991716862, 0.00951733067631721, 0.00947962980717421, 0.00944195874035358, 0.0094045652076602, 0.00936715584248304, 0.00932999234646559, 0.00929281115531921, 0.0092559065669775, 0.00921903550624847, 0.00918242521584034, 0.00914574973285198, 0.00910935085266829, 0.00907298550009727, 0.00903683062642813, 0.00900064315646887, 0.00896484777331352, 0.00892898719757795, 0.00889337155967951, 0.00885773915797472, 0.00882235169410706, 0.00878698006272316, 0.00875191763043404, 0.00871695391833782, 0.00868197251111269, 0.00864725187420845, 0.00861253403127193, 0.00857797637581825, 0.00854359939694405, 0.0085093853995204, 0.00847526825964451, 0.0084412656724453, 0.00840734504163265, 0.00837363582104445, 0.00833996012806892, 0.00830646231770515, 0.00827306229621172, 0.0082398597151041, 0.0082067372277379, 0.00817382708191872, 0.00814086757600307, 0.00810823403298855, 0.00807556882500648, 0.00804308149963617, 0.00801072549074888, 0.00797861441969872, 0.00794652011245489, 0.0079223308712244, 0.00789814162999392, 0.00787440780550241, 0.00785060878843069, 0.0078272670507431, 0.0078039257787168, 0.00778097473084927, 0.00775782857090235, 0.00773507263511419, 0.00771251320838928, 0.00769001897424459, 0.00766785023733974, 0.00764581235125661, 0.00762397004291415, 0.00760225811973214, 0.0075807417742908, 0.00755942100659013, 0.00753816543146968, 0.00751736620441079, 0.00749643659219146, 0.00747589813545346, 0.00745542487129569, 0.0074352128431201, 0.00741506554186344, 0.00739530986174941, 0.00737548852339387, 0.00735599361360073, 0.00733662815764546, 0.00731745967641473, 0.00729848584160209, 0.00727957813069224, 0.00726099545136094, 0.00724260881543159, 0.00722409132868052, 0.00720622669905424, 0.00718816509470344, 0.00717056123539805, 0.00715289171785116, 0.00713561335578561, 0.00711827026680112, 0.00710151344537735, 0.00708449585363269, 0.00706786988303065, 0.00705137383192778, 0.00703507335856557, 0.00701903412118554, 0.00700299441814423, 0.00698734587058425, 0.00697169825434685, 0.00695631047710776, 0.00694105308502913, 0.00692605692893267, 0.00691119115799665, 0.00689645623788238, 0.00688204634934664, 0.00686776731163263, 0.00685361865907907, 0.00683960039168596, 0.0068257125094533, 0.00681221624836326, 0.00679865432903171, 0.00678561395034194, 0.0067723779939115, 0.00675966404378414, 0.00674681877717376, 0.00673443078994751, 0.00672191241756082, 0.00670978473499417, 0.00669778836891055, 0.00668605137616396, 0.00667438004165888, 0.00666290475055575, 0.00665162550285459, 0.0066405413672328, 0.00662952242419124, 0.00661902502179146, 0.00660833204165101, 0.00659809540957212, 0.00658772839233279, 0.00657788291573524, 0.00656790751963854, 0.00655832281336188, 0.00654880329966545, 0.00653954455628991, 0.00653048232197762, 0.00652154954150319, 0.00651274668052793, 0.0065041403286159, 0.00649579474702477, 0.00648751435801387, 0.00647955946624279, 0.00647180015221238, 0.00646397657692432, 0.00645654369145632, 0.00644911080598831, 0.00644206861034036, 0.00643496215343475, 0.00642844196408987, 0.00642172619700432, 0.00641244696453214, 0.00640622014179826, 0.00639989553019404, 0.0063937664963305, 0.00638758856803179, 0.00638163136318326, 0.00637559965252876, 0.00636978866532445, 0.00636392924934626, 0.0063581420108676, 0.00635262439027429, 0.00634699268266559, 0.00634157285094261, 0.00633608782663941, 0.006330830976367, 0.00632545212283731, 0.00632020318880677, 0.00631517451256514, 0.00631008902564645, 0.00630527222529054, 0.00630034925416112, 0.00629556551575661, 0.00629079714417458, 0.00628622528165579, 0.00628161244094372, 0.0062770158983767, 0.00627267174422741, 0.006268294993788, 0.00626413058489561, 0.00625989260151982, 0.00625587441027164, 0.00625175051391125, 0.00624774070456624, 0.00624390179291368, 0.00624007079750299, 0.00623642792925239, 0.00623275199905038, 0.00622929632663727, 0.00622570188716054, 0.00622238498181105, 0.00621896237134933, 0.00621566129848361, 0.00621251575648785, 0.00620931247249246, 0.00620640255510807, 0.00620341161265969, 0.00620064092800021, 0.00619776360690594, 0.00619508186355233, 0.00619241688400507, 0.00618976820260286, 0.00618731463328004, 0.00618488620966673, 0.00618260446935892, 0.00618032226338983, 0.0061781951226294, 0.00617607589811087, 0.00617396552115679, 0.00617206562310457, 0.00617011822760105, 0.0061683664098382, 0.00616658106446266, 0.00616506533697248, 0.00616348395124078, 0.00616205763071775, 0.00616058241575956, 0.00615918077528477, 0.00615797424688935, 0.00615672720596194, 0.00615569250658154, 0.00615459214895964, 0.00615371204912663, 0.00615284778177738, 0.00615197652950883, 0.0061513320542872, 0.00615063961595297, 0.00615013390779495, 0.00614960398525, 0.0061491965316236, 0.00614880584180355, 0.00614862656220794, 0.00614845519885421, 0.00614830013364553, 0.00614835694432259, 0.00614829221740365, 0.00614849617704749, 0.00614865869283676, 0.00614902563393116, 0.00614926172420382, 0.00614978326484561, 0.00615032948553562, 0.00615079421550035, 0.00615156022831798, 0.00615226104855537, 0.00615310063585639, 0.00615396397188306, 0.00615497445687652, 0.00615597749128938, 0.00615706900134683, 0.00615838170051575, 0.00615993607789278, 0.00616181921213865, 0.00616365298628807, 0.0061654862947762, 0.00616724696010351, 0.00616895873099566, 0.00617069471627474, 0.00617233291268349, 0.0061739468947053, 0.00617553619667888, 0.006177076138556, 0.00617856811732054, 0.00618001027032733, 0.00618147756904364, 0.00618284661322832, 0.00618416676297784, 0.00618551205843687, 0.00618673395365477, 0.00618798146024346, 0.00618917914107442, 0.00619032885879278, 0.00619145296514034, 0.00619252910837531, 0.00619355635717511, 0.0061945584602654, 0.00619548792019486, 0.00619644112884998, 0.00619732122868299, 0.00619815289974213, 0.00619898410513997, 0.00619974173605442, 0.00620047515258193, 0.0062011843547225, 0.00620184512808919, 0.0062024318613112, 0.00620304280892015, 0.00620358111336827, 0.00620404537767172, 0.00620455853641033, 0.00620495015755296, 0.00620531663298607, 0.00620565935969353, 0.0062060016207397, 0.00620624562725425, 0.00620646635070443, 0.00620668660849333, 0.00620683282613754, 0.00620693014934659, 0.00620705261826515, 0.00620707729831338, 0.00620705261826515, 0.00620705261826515, 0.00620693014934659, 0.00620683282613754, 0.00620671035721898, 0.00620646635070443, 0.00620624562725425, 0.00620597694069147, 0.00620568357408047, 0.00620531663298607, 0.00620495015755296, 0.00620453432202339, 0.00620404537767172, 0.00620358111336827, 0.00620301812887192, 0.0062024318613112, 0.00620184512808919, 0.00620116014033556, 0.00620045093819499, 0.00619976641610265, 0.00619898410513997, 0.00619815289974213, 0.00619734590873122, 0.00619644112884998, 0.00619551166892052, 0.0061945584602654, 0.00619355635717511, 0.00619250442832708, 0.00619145296514034, 0.00619032885879278, 0.00618915492668748, 0.00618795724585652, 0.00618675863370299, 0.0061854631640017, 0.0061841425485909, 0.00618282239884138, 0.00618142867460847, 0.00617998652160168, 0.00617854297161102, 0.00617702724412084, 0.00617548683658242, 0.00617392221465707, 0.00617228401824832, 0.00617062114179134, 0.00616895873099566, 0.00616719806566834, 0.00616543786600232, 0.00616362877190113, 0.00616177031770349, 0.00615988718345761, 0.00616109557449818, 0.00615581497550011, 0.00615050084888935, 0.00614508846774697, 0.00613951403647661, 0.00613387441262603, 0.00612816866487265, 0.00612226827070117, 0.00611633528023958, 0.00611030356958508, 0.0061041098088026, 0.0060978508554399, 0.00609152624383569, 0.00608507124707103, 0.00607845326885581, 0.00607173750177026, 0.00606505433097482, 0.0060581429861486, 0.00605116598308086, 0.00604412471875548, 0.00603688741102815, 0.00602958491072059, 0.00602224934846163, 0.00601468607783318, 0.00600712280720472, 0.00599942868575454, 0.00599160511046648, 0.00598374800756574, 0.00597563060000539, 0.00596754578873515, 0.0059593953192234, 0.00595098454505205, 0.00594267109408975, 0.00593409733846784, 0.0059254253283143, 0.00591678684577346, 0.00590795138850808, 0.00589892128482461, 0.00588998897001147, 0.00588082848116755, 0.00587153667584062, 0.00586227839812636, 0.00585275841876864, 0.00584317417815328, 0.00583358993753791, 0.00582380965352058, 0.00581396464258432, 0.00580402137711644, 0.00579394772648811, 0.00578377628698945, 0.00577353965491056, 0.00576314004138112, 0.00575267523527145, 0.00574208004400134, 0.005731419660151, 0.00572066102176905, 0.00570973986759782, 0.00569875305518508, 0.00568770198151469, 0.00567645486444235, 0.00566527247428894, 0.00565383024513721, 0.00564228929579258, 0.00563078187406063, 0.00561901275068521, 0.00560717843472958, 0.00559534411877394, 0.00558321690186858, 0.00557115487754345, 0.00555902766063809, 0.00554657401517034, 0.0055341855622828, 0.00552166672423482, 0.0055090831592679, 0.00549633568152785, 0.00548349181190133, 0.0054705161601305, 0.00545750930905342, 0.00544437067583203, 0.00543113518506289, 0.00541773624718189, 0.00540430471301079, 0.00539074279367924, 0.00537711568176746, 0.00536335818469524, 0.00534947030246258, 0.00533551722764969, 0.00532149896025658, 0.00530735030770302, 0.00529300607740879, 0.00527866138145328, 0.00526425242424011, 0.00524958223104477, 0.00523494416847825, 0.00522017665207386, 0.00520521216094494, 0.00519024906679988, 0.0051751546561718, 0.00515996338799596, 0.0051446408033371, 0.00512672401964664, 0.00510618556290865, 0.0050855171866715, 0.0050649787299335, 0.00504447286948562, 0.00502400007098913, 0.00500342901796103, 0.00498302094638348, 0.00496245035901666, 0.00494181411340833, 0.00492130825296044, 0.00490077026188374, 0.00488023180514574, 0.00485979067161679, 0.00483922008424997, 0.00481855170801282, 0.00479807844385505, 0.00477753998711705, 0.00475700153037906, 0.00473652873188257, 0.00471599074080586, 0.00469554960727692, 0.00467484816908836, 0.00465431064367294, 0.00463380431756377, 0.00461333058774471, 0.00459279306232929, 0.00457228720188141, 0.00455165049061179, 0.00453108036890626, 0.00451060710474849, 0.00449003605172038, 0.00446956278756261, 0.0044490247964859, 0.00442851847037673, 0.00440791575238109, 0.00438740942627192, 0.00436683837324381, 0.00434639817103744, 0.0043257949873805, 0.00430525606498122, 0.00428468501195312, 0.00426414748653769, 0.0042436090297997, 0.00422313576564193, 0.00420259730890393, 0.00418209191411734, 0.00416161864995956, 0.00414091721177101, 0.00412044394761324, 0.00409990549087524, 0.00407940009608865, 0.00405892683193088, 0.00403835624456406, 0.00401781778782606, 0.00399724673479795, 0.00397667568176985, 0.00395617028698325, 0.00393563183024526, 0.00391509337350726, 0.00389458797872066, 0.00387395173311234, 0.00385347846895456, 0.00383297284133732, 0.00381246721372008, 0.0037919613532722, 0.00377145549282432, 0.0037507216911763, 0.00373021606355906, 0.00370974279940128, 0.00368923717178404, 0.00366866611875594, 0.00364819308742881, 0.00362765463069081, 0.00360701861791313, 0.00358651275746524, 0.003566007129848, 0.00354553409852087, 0.0035249306820333, 0.00350449001416564, 0.00348391919396818, 0.00346331554464996, 0.00344284251332283, 0.00342223886400461, 0.00340173323638737, 0.00338122737593949, 0.00336075411178172, 0.00334008573554456, 0.00331954727880657, 0.0032990740146488, 0.00327847059816122, 0.0032580301631242, 0.00323752453550696, 0.00321701867505908, 0.00319635006599128, 0.00317584397271276, 0.00315530598163605, 0.00313476729206741, 0.00311426189728081, 0.00309375603683293, 0.00307096820324659, 0.00305571127682924, 0.00304058450274169, 0.00302545819431543, 0.00301046180538833, 0.00299572641961277, 0.00298086064867675, 0.0029659946449101, 0.00295138964429498, 0.00293704541400075, 0.00292270141653717, 0.00290848733857274, 0.0028942737262696, 0.00288019026629627, 0.00286610680632293, 0.00285228411667049, 0.00283859181217849, 0.00282489997334778, 0.00281146820634604, 0.00279803690500557, 0.00278460560366511, 0.0027713046874851, 0.00275813369080424, 0.00274509377777576, 0.00273218378424644, 0.00271940417587757, 0.00270675541833043, 0.00269384542480111, 0.00268145767040551, 0.00266906921751797, 0.00265668099746108, 0.00264455378055573, 0.00263242633081973, 0.00262029888108373, 0.00260843243449926, 0.00259656575508416, 0.00258495984598994, 0.00257335416972637, 0.0025618786457926, 0.00255040335468948, 0.00253918883390725, 0.00252797408029437, 0.00251688994467258, 0.00250593619421124, 0.00249511282891035, 0.00248428946360946, 0.00247359648346901, 0.00246290350332856, 0.00245247152633965, 0.00244216970168054, 0.00243186810985208, 0.00242169643752277, 0.00241178600117564, 0.00240161456167698, 0.00239170389249921, 0.00238205445930362, 0.00237240456044674, 0.00236288527958095, 0.00235349638387561, 0.00234397710300982, 0.00233484897762537, 0.00232559023424983, 0.00231659249402583, 0.00230772513896227, 0.00229898816905916, 0.00229025143198669, 0.00228151446208358, 0.00227303802967072, 0.00226456206291914, 0.00225621624849737, 0.00224813143722713, 0.00224004662595689, 0.00223196134902537, 0.00222400692291558, 0.00221618288196623, 0.00220848922617733, 0.00220092595554888, 0.00219349283725023, 0.00218606018461287, 0.00217875745147467, 0.0021715855691582, 0.00216441345401108, 0.00215750210918486, 0.002150590531528, 0.00214380980469286, 0.00213715923018754, 0.00213050888851285, 0.00212411908432841, 0.00211772928014398, 0.00211147009395063, 0.00210534129291773, 0.00209934264421463, 0.00209334399551153, 0.00208747619763017, 0.00208160793408751, 0.0020760006736964, 0.00207052379846573, 0.0020651773083955, 0.00205983081832528, 0.00205448432825506, 0.00205279677174985, 0.00205018860287964, 0.00204771105200052, 0.00204529846087098, 0.00204295129515231, 0.00204066932201385, 0.00203845254145563, 0.0020362357608974, 0.00203401874750853, 0.00203193235211074, 0.00202984595671296, 0.00202788994647563, 0.00202593370340765, 0.00202410807833076, 0.00202215230092406, 0.00202039163559675, 0.00201863120310009, 0.00201693596318364, 0.00201530614867806, 0.00201374129392207, 0.00201224163174629, 0.00201074196957052, 0.00200924230739474, 0.00200787326321006, 0.00200650398619473, 0.00200526509433985, 0.00200402620248497, 0.00200291792862117, 0.00200167903676629, 0.00200057053007185, 0.00199959264136851, 0.00199861451983452, 0.0019977018237114, 0.0019968543201685, 0.00199607177637517, 0.00199515908025205, 0.00199450692161918, 0.00199385499581695, 0.00199320283718407, 0.00199274648912251, 0.00199222494848073, 0.00199176836758852, 0.00199124682694674, 0.00199092086404562, 0.0019905949011445, 0.00199039932340384, 0.00199020374566317, 0.00199007312767208, 0.00198981259018183, 0.00198981259018183, 0.00198981259018183, 0.00198987754993141, 0.0019900081679225, 0.00199020374566317, 0.00199039932340384, 0.00199052970856428, 0.0019908556714654, 0.0019913122523576, 0.00199170340783894, 0.0019921597559005, 0.00199274648912251, 0.00199326802976429, 0.00199385499581695, 0.00199450692161918, 0.00199522404000163, 0.00199600658379495, 0.0019968543201685, 0.00199776701629162, 0.00199854956008494, 0.00199959264136851, 0.00200063595548272, 0.00200167903676629, 0.00200285250321031, 0.00200402620248497, 0.00200533028692007, 0.00200650398619473, 0.00200780783779919, 0.00200924230739474, 0.00201067677699029, 0.00201217643916607, 0.00201374129392207, 0.00201537134125829, 0.00201687100343406, 0.00201863120310009, 0.00202039163559675, 0.00202221726067364, 0.00202410807833076, 0.00202599912881851, 0.0020279549062252, 0.00202984595671296, 0.00203193235211074, 0.00203408394008875, 0.0020362357608974, 0.00203845254145563, 0.00204073451459408, 0.00204295129515231, 0.00204529846087098, 0.00204771105200052, 0.00205025379545987, 0.00205273134633899, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205371715128422, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344869755208, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205344124697149, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129, 0.00205357139930129   }, 
}; 

// background map
float ReadLikelihood::fRefB[][10000] = 
{ 
   { 0.0025719733, 0.0025708778, 0.0025697821, 0.0025686806, 0.0025675828, 0.0025664775, 0.0025653741, 0.0025642649, 0.002563156, 0.002562043, 0.0025609301, 0.0025598134, 0.0025586945, 0.0025575759, 0.0025564516, 0.0025553291, 0.0025542006, 0.0025530746, 0.0025519426, 0.0025508122, 0.0025496744, 0.0025485368, 0.0025474008, 0.0025462571, 0.0025451155, 0.0025439681, 0.0025428229, 0.0025416717, 0.0025405206, 0.0025393674, 0.0025382105, 0.0025370535, 0.0025358929, 0.002534732, 0.0025335657, 0.0025324009, 0.0025312307, 0.0025300644, 0.00252889, 0.0025277121, 0.0025265398, 0.0025253582, 0.0025241801, 0.0025229945, 0.002521809, 0.0025206215, 0.0025194359, 0.0025182427, 0.0025170513, 0.0025158525, 0.002514659, 0.0025134564, 0.0025122536, 0.0025110506, 0.002509844, 0.0025086373, 0.0025074249, 0.0025062144, 0.0025049984, 0.0025037839, 0.0025025639, 0.0025013438, 0.0025001222, 0.0024988945, 0.0024976707, 0.0024964372, 0.0024952095, 0.0024939741, 0.0024927405, 0.0024915016, 0.0024902644, 0.0024890231, 0.0024877763, 0.0024865335, 0.002485283, 0.0024840343, 0.0024827798, 0.0024815272, 0.0024802689, 0.0024790105, 0.0024777523, 0.0024764882, 0.0024752244, 0.0024739567, 0.0024726887, 0.0024714151, 0.0024701455, 0.00246887, 0.0024675946, 0.0024663133, 0.0024650302, 0.0024637489, 0.00246246, 0.002461175, 0.0024598823, 0.0024585915, 0.0024572969, 0.0024560043, 0.0024547037, 0.0024534056, 0.0024521013, 0.0024507989, 0.0024494911, 0.0024481809, 0.002446871, 0.0024455574, 0.0024442438, 0.0024429264, 0.0024416086, 0.0024402854, 0.0024389641, 0.0024376367, 0.0024363096, 0.0024349808, 0.002433646, 0.0024323151, 0.0024309766, 0.0024296418, 0.0024282995, 0.0024269586, 0.0024256126, 0.0024242664, 0.00242292, 0.0024215661, 0.0024202163, 0.0024188603, 0.0024175048, 0.0024161451, 0.0024147835, 0.0024134221, 0.0024120547, 0.0024106891, 0.0024093182, 0.0024079471, 0.0024065741, 0.0024051992, 0.0024038185, 0.0024024416, 0.0024010593, 0.0023996765, 0.0023982883, 0.0023968981, 0.0023955097, 0.0023941158, 0.0023927235, 0.0023913239, 0.0023899297, 0.002388526, 0.0023871264, 0.0023857169, 0.002384583, 0.0023831329, 0.0023816836, 0.0023802288, 0.0023787764, 0.0023773222, 0.002375867, 0.0023744109, 0.0023729512, 0.0023714916, 0.0023700306, 0.0023685696, 0.002367106, 0.0023656401, 0.0023641754, 0.0023627067, 0.0023612396, 0.0023597674, 0.0023582981, 0.0023568247, 0.0023553527, 0.0023538768, 0.0023524, 0.0023509238, 0.0023494433, 0.0023479646, 0.0023464821, 0.0023450002, 0.0023435159, 0.0023420316, 0.002340544, 0.0023390565, 0.002337568, 0.0023360776, 0.0023345861, 0.0023330913, 0.0023315991, 0.0023301046, 0.0023286082, 0.0023271095, 0.0023256107, 0.0023241106, 0.0023226065, 0.0023211045, 0.0023195986, 0.0023180945, 0.0023165885, 0.0023150819, 0.0023135701, 0.0023120609, 0.0023105477, 0.0023090362, 0.0023075207, 0.0023060038, 0.0023044879, 0.0023029677, 0.0023014504, 0.0022999281, 0.0022984063, 0.0022968829, 0.0022953583, 0.0022938328, 0.0022923041, 0.002290776, 0.0022892472, 0.0022877164, 0.0022861825, 0.00228465, 0.0022831154, 0.0022815794, 0.0022800416, 0.002278504, 0.0022769608, 0.0022754206, 0.0022738792, 0.0022723342, 0.0022707891, 0.0022692429, 0.0022676964, 0.002266146, 0.002264597, 0.0022630445, 0.0022614915, 0.0022599385, 0.0022583823, 0.0022568272, 0.0022552672, 0.0022537089, 0.0022521482, 0.0022505869, 0.0022490236, 0.0022474604, 0.0022458932, 0.0022443263, 0.00224276, 0.0022411887, 0.0022396191, 0.0022380464, 0.0022364738, 0.0022348987, 0.0022331385, 0.0022314766, 0.0022298207, 0.0022281671, 0.0022265087, 0.002224857, 0.0022232081, 0.0022215617, 0.0022199184, 0.0022182753, 0.0022166357, 0.0022149973, 0.0022133579, 0.0022117253, 0.0022100927, 0.0022084625, 0.0022068333, 0.0022052049, 0.0022035844, 0.00220196, 0.0022003395, 0.0021987206, 0.0021971057, 0.0021954917, 0.0021938807, 0.0021922716, 0.0021906646, 0.0021890593, 0.0021874555, 0.0021858558, 0.0021842525, 0.0021826585, 0.0021810613, 0.0021794671, 0.0021778774, 0.0021762869, 0.0021747025, 0.0021731183, 0.0021715367, 0.0021699553, 0.0021683779, 0.0021668007, 0.0021652281, 0.0021636544, 0.0021620844, 0.0021605135, 0.0021589473, 0.0021573831, 0.0021558229, 0.0021542644, 0.0021527039, 0.0021511505, 0.0021495975, 0.0021480466, 0.0021464967, 0.0021449497, 0.0021434044, 0.002141861, 0.0021403171, 0.0021387783, 0.0021372426, 0.0021357078, 0.0021341741, 0.0021326442, 0.0021311163, 0.0021295885, 0.0021280663, 0.0021265449, 0.0021250218, 0.0021235065, 0.0021219898, 0.0021204718, 0.002118964, 0.0021174503, 0.0021159435, 0.0021144401, 0.0021129344, 0.0021114333, 0.002109935, 0.0021084379, 0.0021069406, 0.00210545, 0.0021039594, 0.0021024712, 0.0021009792, 0.0020994975, 0.0020980127, 0.0020965312, 0.0020950525, 0.0020935773, 0.0020921028, 0.002090629, 0.0020891598, 0.0020876916, 0.0020862259, 0.0020847602, 0.0020832997, 0.0020818412, 0.0020803821, 0.0020789215, 0.002077793, 0.0020764486, 0.0020751099, 0.0020737771, 0.00207245, 0.0020711266, 0.0020698071, 0.0020684917, 0.0020671836, 0.0020658814, 0.0020645829, 0.0020632865, 0.0020619959, 0.0020607144, 0.0020594331, 0.0020581596, 0.002056892, 0.0020556317, 0.0020543714, 0.0020531151, 0.0020518703, 0.0020506273, 0.0020493863, 0.0020481567, 0.0020469308, 0.0020457034, 0.002044487, 0.0020432728, 0.0020420661, 0.0020408651, 0.0020396661, 0.0020384728, 0.0020372875, 0.0020361056, 0.0020349275, 0.0020337554, 0.0020325868, 0.0020314243, 0.0020302692, 0.0020291181, 0.002027967, 0.0020268233, 0.0020256876, 0.0020245553, 0.0020234329, 0.0020223106, 0.0020211956, 0.0020200827, 0.0020189774, 0.002017874, 0.0020167802, 0.0020156885, 0.0020146039, 0.0020135159, 0.0020124433, 0.0020113725, 0.0020103073, 0.0020092439, 0.0020081922, 0.0020071405, 0.0020060944, 0.0020050523, 0.0020040178, 0.0020029889, 0.002001964, 0.0020009447, 0.0019999295, 0.0019989158, 0.00199791, 0.0019969118, 0.0019959174, 0.0019949288, 0.00199394, 0.0019929612, 0.0019919877, 0.0019910203, 0.0019900524, 0.0019890945, 0.0019881423, 0.0019871918, 0.0019862433, 0.0019853082, 0.0019843711, 0.0019834398, 0.0019825182, 0.0019815983, 0.0019806882, 0.001979776, 0.0019788754, 0.0019779764, 0.0019770835, 0.0019761925, 0.0019753128, 0.0019744311, 0.001973561, 0.0019726853, 0.0019718229, 0.0019709661, 0.0019701154, 0.0019692644, 0.0019683158, 0.0019671302, 0.001965937, 0.0019647838, 0.0019636347, 0.001962489, 0.0019613723, 0.0019602517, 0.0019591523, 0.0019580717, 0.0019569914, 0.0019559376, 0.0019548896, 0.001953857, 0.0019528399, 0.0019518302, 0.0019508378, 0.0019498548, 0.0019488872, 0.0019479482, 0.0019469979, 0.0019460724, 0.0019451469, 0.00194425, 0.001943378, 0.0019424831, 0.0019416283, 0.0019407792, 0.0019399512, 0.0019391365, 0.0019383124, 0.0019375284, 0.0019367327, 0.0019359678, 0.001935224, 0.0019344668, 0.0019337516, 0.0019330193, 0.0019323174, 0.0019316404, 0.0019309521, 0.0019302999, 0.0019296383, 0.0019290035, 0.0019283857, 0.0019277605, 0.0019271793, 0.0019265959, 0.0019260205, 0.0019254676, 0.001924913, 0.001924391, 0.001923869, 0.0019233603, 0.0019228708, 0.0019223832, 0.0019219263, 0.0019214597, 0.0019210351, 0.0019206124, 0.001920188, 0.001919794, 0.0019193944, 0.0019190368, 0.0019186772, 0.0019183254, 0.0019179907, 0.0019176676, 0.0019173655, 0.001917069, 0.0019167842, 0.0019165222, 0.0019162716, 0.0019160268, 0.0019157975, 0.0019155757, 0.0019153767, 0.0019152027, 0.0019150154, 0.0019148508, 0.0019146998, 0.0019145679, 0.0019144607, 0.0019143306, 0.0019142522, 0.0019141528, 0.0019140879, 0.0019140361, 0.0019139864, 0.0019139673, 0.0019139367, 0.0019139347, 0.0019139559, 0.0019139635, 0.0019140113, 0.0019140439, 0.0019141126, 0.0019142006, 0.0019142715, 0.0019143882, 0.0019123553, 0.0019113992, 0.0019105731, 0.0019097395, 0.0019089974, 0.0019082477, 0.0019076205, 0.0019069704, 0.001906435, 0.0019058995, 0.0019054407, 0.0019050199, 0.0019046987, 0.0019043391, 0.0019040944, 0.0019038495, 0.001903666, 0.0019035741, 0.0019034825, 0.0019034747, 0.0019034977, 0.0019036353, 0.0019037195, 0.0019039565, 0.0019041556, 0.0019044768, 0.0019047598, 0.0019052034, 0.0019056165, 0.0019061365, 0.0019066492, 0.001907238, 0.0019078882, 0.0019085079, 0.0019092958, 0.0019100453, 0.0019109327, 0.0019118198, 0.0019127685, 0.0019137322, 0.0019148031, 0.0019158662, 0.0019170212, 0.0019181992, 0.0019194613, 0.0019207387, 0.0019221002, 0.0019234618, 0.0019249381, 0.0019264066, 0.0019279211, 0.0019295121, 0.001931172, 0.0019328471, 0.0019345911, 0.001936427, 0.0019382244, 0.0019401826, 0.0019420641, 0.0019440989, 0.0019461106, 0.0019482446, 0.0019503712, 0.0019525816, 0.0019548228, 0.0019571329, 0.0019594657, 0.0019618063, 0.0019642771, 0.0019668166, 0.0019693638, 0.0019719414, 0.0019745957, 0.0019772423, 0.0019800188, 0.0019828337, 0.0019856715, 0.001988563, 0.0019915153, 0.0019945214, 0.0019975964, 0.0020006483, 0.0020038381, 0.0020069971, 0.0020102938, 0.0020135446, 0.002016956, 0.0020203446, 0.0020237409, 0.0020272823, 0.0020307933, 0.002034442, 0.0020380369, 0.0020418079, 0.0020455024, 0.0020493576, 0.0020531667, 0.0020570909, 0.0020610299, 0.0020650611, 0.0020730465, 0.0020767488, 0.0020805732, 0.0020845814, 0.0020886201, 0.0020928425, 0.0020972176, 0.0021016542, 0.0021060905, 0.0021107104, 0.0021155449, 0.0021204401, 0.0021255193, 0.0021305676, 0.0021358912, 0.0021412149, 0.0021468143, 0.0021522297, 0.0021581347, 0.0021637951, 0.0021698531, 0.0021759416, 0.0021820916, 0.0021884555, 0.0021948195, 0.0022014284, 0.0022081288, 0.0022149212, 0.0022217135, 0.0022287813, 0.0022359104, 0.0022432229, 0.0022505964, 0.0022581231, 0.0022657108, 0.0022734825, 0.0022813457, 0.0022892088, 0.0022972252, 0.0023055167, 0.0023138083, 0.0023222223, 0.0023308198, 0.0023395091, 0.0023483208, 0.0023571937, 0.0023661584, 0.0023753373, 0.0023845772, 0.002393909, 0.0024034858, 0.0024130319, 0.0024228839, 0.0024327356, 0.0024427713, 0.0024528375, 0.002463026, 0.0024732451, 0.0024837092, 0.0024942646, 0.0025049734, 0.002515774, 0.0025266968, 0.0025377113, 0.0025488788, 0.0025601997, 0.0025714284, 0.0025829938, 0.0025945592, 0.0026063386, 0.0026182099, 0.0026302342, 0.0026422893, 0.0026545278, 0.002666858, 0.00267928, 0.0026919162, 0.0027045831, 0.002717311, 0.0027302534, 0.002743318, 0.0027564133, 0.0027697836, 0.0027831544, 0.0027966776, 0.0028103236, 0.0028239391, 0.0028378603, 0.0028518429, 0.0028659168, 0.0028801444, 0.0028944633, 0.0029089965, 0.0029234991, 0.0029382771, 0.0029529633, 0.0029678333, 0.002982917, 0.0029981229, 0.0030134826, 0.0030262107, 0.0030426714, 0.003059132, 0.0030758374, 0.0030928492, 0.0031097995, 0.0031269332, 0.0031442509, 0.0031619354, 0.0031796813, 0.0031976718, 0.0032159074, 0.0032342037, 0.0032526837, 0.0032714088, 0.0032901336, 0.0033091032, 0.003328379, 0.0033477768, 0.0033672974, 0.0033871236, 0.0034071335, 0.0034272047, 0.003447643, 0.0034679587, 0.0034885195, 0.003509386, 0.003530375, 0.0035515479, 0.0035730873, 0.0035945047, 0.0036162892, 0.0036382575, 0.0036602255, 0.0036824995, 0.003704957, 0.0037274761, 0.0037503007, 0.0037733703, 0.0037965009, 0.0038198766, 0.0038434968, 0.0038671172, 0.0038908597, 0.0039149085, 0.0039392016, 0.0039636176, 0.0039882781, 0.0040130611, 0.0040380275, 0.0040632389, 0.0040885112, 0.0041139061, 0.0041397293, 0.0041654301, 0.0041914368, 0.0042176885, 0.0042441236, 0.0042706812, 0.0042974832, 0.0043244078, 0.0043513938, 0.0043788082, 0.0044062221, 0.004433759, 0.0044616624, 0.0044896277, 0.004517776, 0.0045463531, 0.0045748684, 0.004603507, 0.0046325116, 0.0046615782, 0.0046907058, 0.0047202008, 0.0047498788, 0.0047795572, 0.0048096641, 0.004839771, 0.0048700608, 0.0049006571, 0.0049313758, 0.0049622166, 0.0049932413, 0.005024449, 0.0050558411, 0.0050875391, 0.0051192367, 0.0051511792, 0.0051832437, 0.0052157366, 0.0052482304, 0.0052808458, 0.0053137061, 0.0053466889, 0.0053799166, 0.0054133274, 0.005446861, 0.0054806387, 0.0055146012, 0.0055428101, 0.0055783023, 0.0056141, 0.0056500807, 0.0056861229, 0.005722533, 0.0057591256, 0.0057958416, 0.005832863, 0.005869946, 0.0059072725, 0.0059448448, 0.0059825392, 0.0060204784, 0.0060586627, 0.0060970914, 0.0061355815, 0.0061743776, 0.0062133567, 0.0062523982, 0.0062919282, 0.0063313977, 0.0063711111, 0.0064111315, 0.0064512738, 0.0064916606, 0.0065322919, 0.0065730466, 0.0066139228, 0.0066551664, 0.0066965325, 0.006738021, 0.0067798155, 0.006821855, 0.0068638939, 0.0069064228, 0.0069489516, 0.0069917249, 0.0070346822, 0.0070779449, 0.0071212077, 0.0071647777, 0.0072086519, 0.0072525884, 0.0072968914, 0.0073411954, 0.0073857433, 0.0074305972, 0.0074755121, 0.0075207334, 0.0075661386, 0.0076118489, 0.0076574986, 0.0077036382, 0.0077497764, 0.0077960994, 0.0078427894, 0.0078895399, 0.0079364749, 0.0079837767, 0.0080311401, 0.0080788089, 0.0081266603, 0.0081746355, 0.0082227336, 0.0082712583, 0.0083198454, 0.0083685545, 0.008417692, 0.008466891, 0.0085162735, 0.0085659614, 0.0086157108, 0.0086657051, 0.0087160049, 0.0087663671, 0.0088169733, 0.00886764, 0.0089189196, 0.0089700762, 0.0090214787, 0.0090731848, 0.0091248937, 0.0091769071, 0.009229226, 0.0092816073, 0.0093341097, 0.0093871644, 0.0094401566, 0.0094933324, 0.009546876, 0.009600481, 0.0096542072, 0.0097083626, 0.009762519, 0.0098169185, 0.0098717455, 0.0099265752, 0.0099815866, 0.010036844, 0.010101219, 0.010158127, 0.010215465, 0.010272803, 0.010330324, 0.01038815, 0.010446099, 0.01050417, 0.010562303, 0.010620804, 0.010679242, 0.010738049, 0.010796915, 0.010856027, 0.010915384, 0.010974801, 0.011034342, 0.011094187, 0.011154035, 0.011214186, 0.011274399, 0.011334858, 0.011395438, 0.011456385, 0.011517334, 0.011578343, 0.011639656, 0.011701033, 0.011762715, 0.011824459, 0.011886447, 0.011948556, 0.012010973, 0.012073388, 0.01213605, 0.012198834, 0.012261923, 0.012324952, 0.012388408, 0.012451742, 0.012515505, 0.012579327, 0.012643397, 0.012707526, 0.012771901, 0.012836397, 0.012901017, 0.01296588, 0.013030806, 0.013096099, 0.013161575, 0.013226989, 0.013292649, 0.013358675, 0.013424641, 0.013490851, 0.013557122, 0.0136237, 0.0136904, 0.013757406, 0.013824411, 0.013891661, 0.013958973, 0.014026529, 0.014094269, 0.014162193, 0.01423024, 0.01429853, 0.014366942, 0.014435539, 0.01450432, 0.0145731, 0.014642309, 0.014711517, 0.01478097, 0.014850425, 0.014920245, 0.014990311, 0.015060437, 0.015130625, 0.015201119, 0.015271673, 0.015342473, 0.015413455, 0.015484624, 0.01555579, 0.015627323, 0.015699042, 0.015770698, 0.015842782, 0.015914807, 0.015987197, 0.016059587, 0.016132221, 0.016205041, 0.016278166, 0.016351353, 0.01642466, 0.016498091, 0.016571829, 0.016653551, 0.016728986, 0.01680433, 0.01687984, 0.016955459, 0.01703123, 0.017106926, 0.017182713, 0.017258683, 0.017334653, 0.017410807, 0.0174869, 0.017563254, 0.017639453, 0.017715944, 0.017792342, 0.017869031, 0.017945599, 0.018022396, 0.018099114, 0.018175928, 0.018252907, 0.018330086, 0.018407203, 0.018484335, 0.018561654, 0.018639, 0.018716501, 0.018794, 0.018871654, 0.018949201, 0.019027084, 0.01910492, 0.019182941, 0.019260839, 0.019339012, 0.01941717, 0.01949542, 0.019573746, 0.01965218, 0.019730642, 0.019809201, 0.019887846, 0.019966708, 0.02004548, 0.020124279, 0.020203294, 0.020282323, 0.020361474, 0.02044072, 0.020520026, 0.020599376, 0.020678896, 0.02075837, 0.020838073, 0.020917654, 0.020997602, 0.021077337, 0.021157285, 0.021237293, 0.021317471, 0.02139765, 0.021477886, 0.021558248, 0.021638593, 0.021719243, 0.021799743, 0.021880457, 0.021961125, 0.022042049, 0.022122901, 0.02220395, 0.02228497, 0.022366172, 0.022447389, 0.022528667, 0.022610066, 0.022691563, 0.022773085, 0.022854762, 0.022936407, 0.02301833, 0.023100097, 0.023182034, 0.023264078, 0.023346199, 0.02342841, 0.023510683, 0.023593001, 0.023675431, 0.023758115, 0.023840543, 0.023923336, 0.024006005, 0.024088938, 0.024171807, 0.024254845, 0.024337823, 0.024421075, 0.024504341, 0.024582675, 0.02466617, 0.024749732, 0.024833167, 0.024916587, 0.025000008, 0.025083352, 0.025166666, 0.025249889, 0.025333142, 0.025416283, 0.025499463, 0.025582515, 0.025665568, 0.025748543, 0.025831539, 0.02591444, 0.025997324, 0.026080133, 0.026162973, 0.026245674, 0.026328346, 0.026411032, 0.026493702, 0.026576204, 0.026658693, 0.026741242, 0.026823699, 0.026906079, 0.026988398, 0.027070763, 0.027152976, 0.027235249, 0.027317418, 0.027399583, 0.027481655, 0.02756373, 0.027645728, 0.027727652, 0.027809618, 0.027891541, 0.027973354, 0.028055109, 0.02813689, 0.028218584, 0.028300276, 0.028381862, 0.028463477, 0.028545015, 0.028626492, 0.02870794, 0.028789388, 0.028870713, 0.028952036, 0.029033303, 0.029114505, 0.029195722, 0.029276922, 0.029357988, 0.02943904, 0.029520087, 0.029600985, 0.029682005, 0.029762855, 0.029843705, 0.02992451, 0.030005313, 0.030085983, 0.030166678, 0.030247301, 0.030327892, 0.030408436, 0.030488903, 0.030569388, 0.030649826, 0.030730171, 0.030810501, 0.030890817, 0.030971026, 0.031051248, 0.03113135, 0.03121151, 0.031291582, 0.031371608, 0.031451572, 0.03153158, 0.031611405, 0.031691309, 0.03177109, 0.031850819, 0.031930588, 0.032010287, 0.032089904, 0.032169469, 0.032249078, 0.032328553, 0.03240804, 0.032487441, 0.032566834, 0.032646172, 0.032708965, 0.032786619, 0.032864392, 0.032941863, 0.033019181, 0.033096433, 0.033173382, 0.033250425, 0.033327103, 0.033403836, 0.033480234, 0.033556636, 0.033632789, 0.033708885, 0.033784825, 0.033860549, 0.033936184, 0.034011632, 0.034086991, 0.034162197, 0.034237187, 0.034312058, 0.034386836, 0.034461461, 0.034535933, 0.034610189, 0.034684416, 0.034758337, 0.034832258, 0.034905933, 0.034979641, 0.035053041, 0.035126321, 0.035199568, 0.035272449, 0.035345331, 0.035418056, 0.035490599, 0.035562962, 0.035635322, 0.035707466, 0.035779431, 0.03585127, 0.035922926, 0.035994492, 0.036065992, 0.03613719, 0.036208421, 0.036279254, 0.036350172, 0.036420729, 0.036491375, 0.036561806, 0.036631968, 0.036702126, 0.036771975, 0.036841854, 0.036911588, 0.036981039, 0.037050463, 0.037119612, 0.037188698, 0.03725766, 0.03732641, 0.037395161, 0.037463576, 0.037531987, 0.037600156, 0.037668325, 0.037736095, 0.037803993, 0.037871517, 0.037939042, 0.038006473, 0.038073603, 0.038140733, 0.038207494, 0.038274344, 0.03834099, 0.038407411, 0.038473804, 0.038539924, 0.038605947, 0.038671855, 0.038737606, 0.038803264, 0.038868621, 0.038933944, 0.038999114, 0.039064188, 0.039129082, 0.039193794, 0.039258417, 0.03932273, 0.039387103, 0.039451297, 0.039515276, 0.03957919, 0.0396428, 0.039706375, 0.039776448, 0.039837766, 0.039898716, 0.039959539, 0.040020183, 0.0400807, 0.040141035, 0.040201064, 0.040261094, 0.040320758, 0.040380362, 0.040439777, 0.040499073, 0.040558126, 0.040616933, 0.040675614, 0.040734116, 0.040792491, 0.040850744, 0.040908579, 0.040966403, 0.041023988, 0.041081443, 0.041138783, 0.041195687, 0.041252602, 0.041309386, 0.041365925, 0.041422226, 0.04147834, 0.041534271, 0.041590136, 0.041645885, 0.041701324, 0.041756641, 0.041811652, 0.041866608, 0.04192131, 0.041975897, 0.042030353, 0.042084452, 0.042138603, 0.042192336, 0.042246059, 0.042299606, 0.042352781, 0.042406078, 0.042459007, 0.042511821, 0.042564444, 0.042616826, 0.042669084, 0.042721096, 0.04277299, 0.042824637, 0.042876221, 0.0429275, 0.042978656, 0.043029752, 0.043080423, 0.04313115, 0.043181453, 0.043231811, 0.043281868, 0.043331858, 0.043381676, 0.043431059, 0.043480497, 0.043529633, 0.043578651, 0.043627549, 0.04367613, 0.043724656, 0.04377294, 0.043821033, 0.043869011, 0.043916799, 0.043964408, 0.044011772, 0.044059012, 0.044106007, 0.044152945, 0.044199694, 0.044246078, 0.044292524, 0.044338536, 0.044384558, 0.044430327, 0.044476043, 0.04452138, 0.044566665, 0.044611644, 0.044656679, 0.044701412, 0.0447459, 0.044790268, 0.044834383, 0.044878446, 0.044922255, 0.044965826, 0.045010552, 0.045051981, 0.045093283, 0.04513444, 0.045175496, 0.045216344, 0.045257159, 0.04529779, 0.04533821, 0.045378685, 0.045418922, 0.045458972, 0.04549893, 0.045538735, 0.04557842, 0.045617945, 0.045657393, 0.045696761, 0.045735866, 0.045774847, 0.045813765, 0.045852564, 0.04589114, 0.045929633, 0.04596797, 0.046006184, 0.046044335, 0.046082217, 0.046120122, 0.046157755, 0.046195269, 0.046232715, 0.046269987, 0.046307158, 0.046344116, 0.046381053, 0.046417765, 0.046454359, 0.046490863, 0.046527207, 0.046563461, 0.046599474, 0.046635423, 0.046671223, 0.046706926, 0.04674248, 0.046777882, 0.04681316, 0.046848223, 0.046883255, 0.046918161, 0.046952892, 0.0469875, 0.047021914, 0.047056247, 0.047090452, 0.047124568, 0.047158502, 0.047192246, 0.047225934, 0.047259439, 0.047292814, 0.047326162, 0.047359303, 0.047392223, 0.047425143, 0.047457822, 0.047490347, 0.047522869, 0.047555208, 0.047587365, 0.047619462, 0.047651377, 0.047683161, 0.0477148, 0.047746375, 0.047777705, 0.047808971, 0.047840059, 0.047871117, 0.047901984, 0.047932643, 0.047963239, 0.047993682, 0.048023943, 0.048054114, 0.048084281, 0.04811414, 0.048143938, 0.048173591, 0.048203051, 0.048232488, 0.048261706, 0.048290774, 0.048319776, 0.048348602, 0.048377298, 0.048405904, 0.048434362, 0.0484626, 0.04848526, 0.048512414, 0.048539519, 0.048566613, 0.048593663, 0.048620693, 0.048647679, 0.04867465, 0.048701558, 0.048728466, 0.048755381, 0.048782177, 0.048808984, 0.048835751, 0.048862506, 0.048889235, 0.048915919, 0.048942551, 0.048969183, 0.048995785, 0.049022298, 0.049048852, 0.04907538, 0.049101785, 0.049128253, 0.049154673, 0.049180999, 0.04920736, 0.049233675, 0.049259942, 0.049286205, 0.049312443, 0.049338602, 0.049364761, 0.049390893, 0.049416959, 0.049443025, 0.049469031, 0.049495038, 0.049521033, 0.049546935, 0.049572844, 0.049598731, 0.0496246, 0.049650379, 0.049676172, 0.049701944, 0.049727648, 0.049753334, 0.049778976, 0.049804632, 0.049830236, 0.049855739, 0.049881306, 0.049906801, 0.049932286, 0.049957715, 0.04998311, 0.050008506, 0.050033841, 0.050059173, 0.050084446, 0.050109707, 0.05013492, 0.050160091, 0.050185278, 0.050210379, 0.050235499, 0.050260525, 0.050285585, 0.050310601, 0.050335549, 0.050360497, 0.050385389, 0.050410263, 0.050435141, 0.050459951, 0.050484721, 0.05050952, 0.050534226, 0.050558899, 0.050583597, 0.050608225, 0.050632779, 0.050657358, 0.050681867, 0.050706409, 0.050730884, 0.050755296, 0.050779726, 0.050804127, 0.050828483, 0.050852776, 0.050877105, 0.05090132, 0.050925534, 0.050949752, 0.050973892, 0.050998051, 0.051022142, 0.051055141, 0.051079802, 0.051104523, 0.051129341, 0.051154241, 0.051179174, 0.051204268, 0.051229414, 0.051254645, 0.051279902, 0.051305279, 0.051330812, 0.051356301, 0.051381972, 0.051407654, 0.051433407, 0.051459335, 0.051485233, 0.051511329, 0.051537417, 0.051563621, 0.051589888, 0.051616244, 0.051642712, 0.05166924, 0.051695794, 0.051722553, 0.051749278, 0.051776111, 0.051803067, 0.051830087, 0.051857196, 0.051884383, 0.0519116, 0.051938988, 0.051966358, 0.051993944, 0.05202147, 0.052049126, 0.052076899, 0.05210473, 0.052132688, 0.05216065, 0.05218878, 0.052216925, 0.052245118, 0.052273478, 0.052301843, 0.052330393, 0.052358896, 0.052387539, 0.052416291, 0.052445125, 0.052473947, 0.052502949, 0.052531995, 0.052561186, 0.052590374, 0.052619655, 0.052649073, 0.052678537, 0.052708093, 0.052737676, 0.0527674, 0.052797198, 0.052827056, 0.052857041, 0.052887067, 0.052917156, 0.052947402, 0.052977666, 0.053008053, 0.053038478, 0.053068995, 0.053099617, 0.053130291, 0.053161081, 0.053191938, 0.053222831, 0.053253915, 0.053284965, 0.053316183, 0.053347416, 0.053378779, 0.053410191, 0.053441685, 0.053473309, 0.053504981, 0.053536668, 0.053568557, 0.053600453, 0.05363249, 0.053664524, 0.053696692, 0.053728957, 0.053761229, 0.053793695, 0.053826153, 0.053858727, 0.053891368, 0.053921085, 0.053955536, 0.053990021, 0.054024782, 0.054059628, 0.054094598, 0.05412985, 0.054165125, 0.054200616, 0.054236259, 0.054271996, 0.054308008, 0.054344017, 0.054380279, 0.05441672, 0.05445325, 0.054490056, 0.054526836, 0.054563791, 0.054601062, 0.054638356, 0.054675929, 0.054713532, 0.054751229, 0.054789256, 0.054827318, 0.054865628, 0.054903992, 0.054942511, 0.05498131, 0.055020135, 0.055059172, 0.05509831, 0.055137623, 0.055177186, 0.055216778, 0.055256613, 0.05529654, 0.055336595, 0.055376884, 0.055417303, 0.055457905, 0.055498663, 0.055539444, 0.055580508, 0.055621717, 0.055663083, 0.055704601, 0.055746183, 0.055787947, 0.055829927, 0.055872086, 0.055914309, 0.055956684, 0.055999275, 0.056042019, 0.056084979, 0.056127962, 0.056171075, 0.056214493, 0.056257963, 0.056301691, 0.05634544, 0.05638941, 0.056433499, 0.056477737, 0.056522258, 0.056566775, 0.056611534, 0.05665645, 0.056701429, 0.05674668, 0.056791995, 0.056837518, 0.056883171, 0.05692894, 0.056974985, 0.05702107, 0.057067264, 0.05711377, 0.057160314, 0.057207122, 0.057254024, 0.057301022, 0.057348233, 0.057395533, 0.057443112, 0.057490747, 0.057538569, 0.057586573, 0.057634674, 0.057682898, 0.057731416, 0.057779972, 0.057828747, 0.057877578, 0.057926621, 0.057975881, 0.058025204, 0.058074743, 0.058122013, 0.058173474, 0.058225121, 0.058277011, 0.05832899, 0.058381069, 0.058433358, 0.058485925, 0.058538578, 0.058591321, 0.058644347, 0.058697466, 0.05875073, 0.058804188, 0.058857817, 0.058911633, 0.058965515, 0.059019644, 0.059073951, 0.059128415, 0.059182968, 0.05923773, 0.059292685, 0.059347816, 0.059402984, 0.05945833, 0.059513986, 0.059569672, 0.059625659, 0.059681747, 0.059737951, 0.059794344, 0.059850879, 0.059907667, 0.059964485, 0.060021546, 0.060078759, 0.060136162, 0.06019365, 0.060251415, 0.060309276, 0.060367249, 0.060425445, 0.060483828, 0.060542416, 0.060601067, 0.060659904, 0.060718894, 0.0607781, 0.060837422, 0.060896903, 0.060956594, 0.061016414, 0.061076354, 0.061136566, 0.061196901, 0.061257325, 0.061317995, 0.061378792, 0.061439808, 0.061500903, 0.061562158, 0.061623689, 0.061685305, 0.061747052, 0.061809037, 0.061871149, 0.061933409, 0.06199583, 0.06205846, 0.062121302, 0.062184211, 0.062247332, 0.062310543, 0.062373903, 0.062437549, 0.062501274, 0.062565222, 0.06262923, 0.062693477, 0.062757947, 0.062822506, 0.062887125, 0.062952079, 0.06301716, 0.063082419, 0.063147746, 0.063213281, 0.063279033, 0.063344844, 0.063410908, 0.063477144, 0.063543536, 0.063609958, 0.063676693, 0.063743547, 0.063810579, 0.063877769, 0.063945174, 0.064012609, 0.064085275, 0.064153872, 0.064222559, 0.064291276, 0.064360239, 0.064429238, 0.064498439, 0.064567626, 0.06463711, 0.064706653, 0.064776324, 0.064846016, 0.064915963, 0.064985998, 0.065056182, 0.065126367, 0.065196835, 0.065267332, 0.065337949, 0.065408714, 0.065479636, 0.065550648, 0.065621786, 0.065693043, 0.065764427, 0.06583602, 0.06590759, 0.065979399, 0.06605126, 0.066123255, 0.066195406, 0.066267729, 0.066340126, 0.066412605, 0.066485211, 0.066558033, 0.066630818, 0.066703878, 0.066777036, 0.066850349, 0.066923685, 0.066997208, 0.067070819, 0.067144617, 0.067218453, 0.067292489, 0.06736666, 0.067440912, 0.067515291, 0.0675897, 0.067664392, 0.067739077, 0.067813978, 0.067888997, 0.067964144, 0.06803932, 0.068114765, 0.068190217, 0.068265848, 0.068341576, 0.068417512, 0.068493545, 0.068569608, 0.068645887, 0.068722285, 0.068798713, 0.068875358, 0.068952121, 0.069028981, 0.069106057, 0.069183096, 0.069260374, 0.069337726, 0.069415167, 0.069492787, 0.069570594, 0.069648437, 0.069726422, 0.069804437, 0.069882743, 0.069961034, 0.07003957, 0.070118204, 0.070196927, 0.070275776, 0.070354745, 0.0704339, 0.070513114, 0.070592478, 0.070671938, 0.070751578, 0.070831247, 0.070911162, 0.070991114, 0.071071282, 0.071151435, 0.07123182, 0.071312316, 0.071392931, 0.071473554, 0.07156115, 0.071641341, 0.071721628, 0.071802013, 0.071882442, 0.071962968, 0.072043568, 0.07212428, 0.072205052, 0.07228598, 0.072366901, 0.072447985, 0.072529092, 0.072610296, 0.07269159, 0.07277298, 0.072854422, 0.072936028, 0.073017657, 0.073099352, 0.07318119, 0.073263101, 0.073345065, 0.073427185, 0.073509306, 0.073591553, 0.073673911, 0.073756337, 0.07383883, 0.073921375, 0.074004054, 0.074086778, 0.074169688, 0.074252553, 0.07433562, 0.074418694, 0.07450185, 0.074585132, 0.074668504, 0.074751936, 0.074835502, 0.07491903, 0.075002797, 0.075086541, 0.075170405, 0.075254425, 0.075338438, 0.075422607, 0.075506844, 0.075591102, 0.075675458, 0.075759962, 0.075844467, 0.075929157, 0.076013848, 0.076098725, 0.076183572, 0.076268569, 0.076353587, 0.076438807, 0.076524042, 0.076609351, 0.076694772, 0.076780282, 0.076865859, 0.076951504, 0.077037357, 0.07712312, 0.077209122, 0.077295072, 0.077381223, 0.077467389, 0.077553697, 0.077640012, 0.077726446, 0.077812962, 0.07789959, 0.077986263, 0.078073032, 0.078159936, 0.078246884, 0.078333929, 0.078421079, 0.078508295, 0.078595594, 0.078682974, 0.078770481, 0.07885801, 0.078945674, 0.079033419, 0.07912121, 0.079209112, 0.079297133, 0.079385184, 0.079473309, 0.079561599, 0.07964991, 0.079738334, 0.079826847, 0.079915419, 0.080006041, 0.080093585, 0.080181234, 0.080268987, 0.080356769, 0.080444731, 0.08053267, 0.080620721, 0.080708891, 0.080797173, 0.080885507, 0.080973864, 0.081062406, 0.081150986, 0.081239715, 0.081328444, 0.0814173, 0.081506237, 0.081595309, 0.081684366, 0.081773557, 0.081862874, 0.081952207, 0.082041651, 0.08213117, 0.082220815, 0.08231049, 0.082400322, 0.082490221, 0.082580157, 0.082670242, 0.082760371, 0.082850546, 0.082940899, 0.083031282, 0.083121777, 0.083212286, 0.083302967, 0.083393753, 0.08348456, 0.083575465, 0.083666451, 0.083757542, 0.083848685, 0.083939947, 0.084031314, 0.08412277, 0.084214248, 0.084305853, 0.084397547, 0.084489308, 0.084581196, 0.084673136, 0.084765159, 0.084857292, 0.084949479, 0.085041754, 0.085134096, 0.085226558, 0.085319139, 0.085411787, 0.085504428, 0.085597262, 0.085690156, 0.085783161, 0.085876197, 0.085969307, 0.086062573, 0.086155884, 0.086249262, 0.086342767, 0.086436391, 0.086530015, 0.086623795, 0.086717598, 0.086811565, 0.086905494, 0.086999632, 0.087093785, 0.087188087, 0.087282404, 0.087376855, 0.087471344, 0.087565944, 0.08766067, 0.087755479, 0.087850295, 0.087945238, 0.088040315, 0.088135406, 0.08823064, 0.088325955, 0.088421293, 0.088516787, 0.088612333, 0.088707954, 0.088803686, 0.088899508, 0.088995397, 0.089091383, 0.089182369, 0.089278162, 0.089373931, 0.089469917, 0.089566082, 0.089662328, 0.08975862, 0.089855082, 0.089951649, 0.090048298, 0.090145178, 0.090242103, 0.090339087, 0.090436295, 0.090533629, 0.090630941, 0.090728514, 0.090826184, 0.090923876, 0.091021791, 0.091119818, 0.091217905, 0.091316149, 0.091414489, 0.091512978, 0.091611587, 0.091710322, 0.091809087, 0.091908038, 0.092007175, 0.092106365, 0.092205681, 0.092305116, 0.092404619, 0.092504285, 0.092604101, 0.092704028, 0.092804015, 0.092904188, 0.09300448, 0.093104839, 0.093205318, 0.093305983, 0.0934067, 0.093507543, 0.093608573, 0.093709625, 0.093810849, 0.093912207, 0.094013594, 0.094115183, 0.09421692, 0.09431868, 0.094420657, 0.09452273, 0.094624855, 0.094727173, 0.094829582, 0.094932102, 0.095034748, 0.095137529, 0.095240355, 0.095343374, 0.095446549, 0.095549852, 0.095653139, 0.095756643, 0.095860235, 0.095963933, 0.096067712, 0.096171714, 0.096275799, 0.09638001, 0.096484311, 0.096588708, 0.096693285, 0.09679801, 0.096902743, 0.097007632, 0.097112693, 0.097217806, 0.097323105, 0.097428478, 0.097533949, 0.097639635, 0.097745366, 0.097851224, 0.097957179, 0.09806332, 0.09816955, 0.09827584, 0.098382354, 0.098488942, 0.098595612, 0.098702416, 0.098809376, 0.098916374, 0.099023581, 0.099130854, 0.099238276, 0.099344566, 0.099452935, 0.099561431, 0.099670082, 0.09977892, 0.09988784, 0.099996977, 0.10010622, 0.10021555, 0.10032515, 0.10043486, 0.10054465, 0.10065467, 0.10076482, 0.10087515, 0.10098547, 0.10109608, 0.1012068, 0.10131769, 0.10142872, 0.10153987, 0.10165118, 0.10176268, 0.10187429, 0.10198601, 0.10209795, 0.10221, 0.10232216, 0.10243451, 0.10254704, 0.10265964, 0.10277244, 0.10288544, 0.1029985, 0.1031117, 0.10322512, 0.10333863, 0.10345232, 0.10356617, 0.10368008, 0.10379421, 0.10390852, 0.10402291, 0.10413747, 0.1042522, 0.10436709, 0.10448205, 0.10459723, 0.10471249, 0.10482787, 0.10494349, 0.10505933, 0.10517511, 0.10529119, 0.10540733, 0.10552366, 0.10564017, 0.10575683, 0.10587353, 0.10599049, 0.10610759, 0.10622473, 0.10634217, 0.10645969, 0.10657733, 0.10669513, 0.1068131, 0.10693114, 0.10704946, 0.10716784, 0.10728636, 0.10740508, 0.10752395, 0.10764287, 0.10776205, 0.10788137, 0.10800081, 0.10812033, 0.10824008, 0.10836002, 0.10847995, 0.10860018, 0.1087205, 0.10884093, 0.10896157, 0.10908236, 0.10920322, 0.10932427, 0.10944554, 0.10956683, 0.10968836, 0.10981001, 0.10993175, 0.11005376, 0.11017584, 0.11029801, 0.11042047, 0.110543, 0.11066559, 0.11078846, 0.11091065, 0.11103508, 0.1111596, 0.11128432, 0.11140927, 0.11153422, 0.11165927, 0.1117845, 0.11190995, 0.11203551, 0.11216114, 0.11228698, 0.11241291, 0.11253901, 0.11266521, 0.11279155, 0.112918, 0.11304469, 0.11317139, 0.11329828, 0.11342535, 0.11355247, 0.11367985, 0.11380722, 0.1139348, 0.11406248, 0.11419034, 0.11431827, 0.11444641, 0.11457469, 0.11470304, 0.11483158, 0.1149602, 0.11508901, 0.11521792, 0.115347, 0.11547618, 0.1156055, 0.11573493, 0.11586463, 0.11599436, 0.11612421, 0.11625424, 0.11638433, 0.11651465, 0.11664505, 0.11677564, 0.11690625, 0.11703711, 0.11716808, 0.11729916, 0.11743042, 0.11756174, 0.11769331, 0.11782487, 0.11795674, 0.11808848, 0.1182206, 0.1183528, 0.11848509, 0.11861753, 0.11875007, 0.11888285, 0.11901564, 0.11914876, 0.11928173, 0.11941507, 0.11954845, 0.11968203, 0.11981565, 0.11994946, 0.12008344, 0.12021749, 0.12035169, 0.12048606, 0.1206205, 0.12075519, 0.1208899, 0.12102481, 0.12115982, 0.12129503, 0.12143026, 0.12156571, 0.12170129, 0.12183698, 0.12197282, 0.12210883, 0.12224495, 0.1223812, 0.12251753, 0.12265405, 0.12279069, 0.12292752, 0.12306441, 0.12320148, 0.12333867, 0.12347605, 0.12361349, 0.12375107, 0.12388883, 0.12401792, 0.12415748, 0.12429702, 0.12443671, 0.12457646, 0.12471628, 0.1248561, 0.1249961, 0.12513608, 0.12527616, 0.12541625, 0.12555644, 0.12569672, 0.12583701, 0.1259774, 0.12611787, 0.12625839, 0.126399, 0.12653966, 0.1266803, 0.12682112, 0.12696196, 0.12710287, 0.12724379, 0.12738487, 0.12752596, 0.12766713, 0.12780829, 0.12794964, 0.12809098, 0.12823243, 0.12837386, 0.12851542, 0.12865707, 0.12879874, 0.12894046, 0.12908229, 0.12922415, 0.12936611, 0.12950812, 0.12965021, 0.12979232, 0.12993455, 0.13007677, 0.1302191, 0.13036151, 0.13050394, 0.13064645, 0.13078907, 0.13093174, 0.13107444, 0.13121721, 0.13136005, 0.13150299, 0.13164596, 0.13178898, 0.13193209, 0.13207524, 0.13221848, 0.13236181, 0.13250518, 0.13264859, 0.13279209, 0.13293564, 0.13307925, 0.13322294, 0.1333667, 0.13351052, 0.13365437, 0.13379832, 0.13394237, 0.13408644, 0.13423058, 0.13437477, 0.134519, 0.13466336, 0.13480778, 0.13495225, 0.13509673, 0.13524134, 0.13538602, 0.13553074, 0.13567552, 0.13582036, 0.1359653, 0.13611026, 0.13625528, 0.13640043, 0.13654557, 0.13669081, 0.13683613, 0.1369815, 0.13712692, 0.13727245, 0.13741802, 0.13756363, 0.13770933, 0.13785508, 0.13800091, 0.13814677, 0.13828976, 0.13843656, 0.13858327, 0.13872997, 0.1388766, 0.13902317, 0.13916971, 0.13931616, 0.13946258, 0.1396089, 0.1397552, 0.13990141, 0.14004761, 0.1401937, 0.14033979, 0.14048578, 0.14063177, 0.14077765, 0.1409235, 0.14106931, 0.14121501, 0.1413607, 0.14150631, 0.14165187, 0.14179738, 0.1419428, 0.1420882, 0.14223351, 0.14237882, 0.14252402, 0.14266919, 0.14281432, 0.14295933, 0.14310436, 0.14324927, 0.14339419, 0.14353898, 0.14368378, 0.14382848, 0.14397317, 0.14411774, 0.14426231, 0.14440677, 0.14455123, 0.14469558, 0.14483993, 0.14498417, 0.1451284, 0.14527252, 0.14541665, 0.14556067, 0.14570464, 0.1458486, 0.14599244, 0.14613628, 0.14628001, 0.14642373, 0.14656734, 0.14671096, 0.14685448, 0.14699796, 0.14714138, 0.14728476, 0.14742804, 0.14757131, 0.14771448, 0.14785767, 0.1480007, 0.14814374, 0.14828669, 0.14842963, 0.14857249, 0.14871527, 0.14885804, 0.14900072, 0.14914335, 0.14928593, 0.14942844, 0.14957088, 0.14971331, 0.14985564, 0.14999795, 0.15014018, 0.15028237, 0.1504245, 0.15056656, 0.15070856, 0.15085055, 0.15099242, 0.1511343, 0.15127604, 0.15141781, 0.15155946, 0.15170111, 0.15184264, 0.15198414, 0.15212558, 0.15226699, 0.15240835, 0.15254959, 0.15269323, 0.15283313, 0.15297289, 0.15311238, 0.15325175, 0.15339099, 0.15353, 0.15366887, 0.15380758, 0.15394607, 0.15408444, 0.15422256, 0.15436061, 0.15449843, 0.15463609, 0.15477358, 0.15491092, 0.15504801, 0.155185, 0.15532178, 0.15545841, 0.15559486, 0.15573116, 0.15586726, 0.15600321, 0.15613896, 0.15627451, 0.15640993, 0.15654521, 0.1566803, 0.15681516, 0.15694992, 0.15708442, 0.15721884, 0.15735307, 0.15748709, 0.15762097, 0.15775466, 0.15788817, 0.15802154, 0.15815473, 0.15828775, 0.15842055, 0.15855323, 0.15868567, 0.15881802, 0.15895015, 0.1590821, 0.15921392, 0.15934558, 0.15947703, 0.15960833, 0.15973946, 0.15987037, 0.16000116, 0.16013178, 0.16026215, 0.16039243, 0.16052249, 0.1606524, 0.16078211, 0.16091169, 0.16104108, 0.1611703, 0.16129936, 0.16142823, 0.16155691, 0.16168547, 0.1618138, 0.16194199, 0.16207002, 0.16219784, 0.16232552, 0.162453, 0.16258036, 0.16270749, 0.1628345, 0.16296126, 0.16308789, 0.16321442, 0.16334066, 0.1634668, 0.16359276, 0.16371852, 0.16384409, 0.16396955, 0.16409478, 0.1642199, 0.16434479, 0.16446951, 0.16459411, 0.16471849, 0.16484269, 0.16496679, 0.16509062, 0.16521434, 0.16533786, 0.16546127, 0.16558444, 0.16570747, 0.16583423, 0.16595444, 0.16607448, 0.16619416, 0.16631377, 0.1664331, 0.16655222, 0.1666711, 0.16678979, 0.16690825, 0.16702646, 0.16714449, 0.16726235, 0.16737992, 0.16749732, 0.16761443, 0.16773142, 0.16784815, 0.16796465, 0.16808096, 0.16819707, 0.16831289, 0.16842857, 0.16854399, 0.16865921, 0.16877422, 0.16888906, 0.16900356, 0.16911794, 0.16923209, 0.16934599, 0.16945967, 0.16957319, 0.16968645, 0.16979949, 0.16991234, 0.17002496, 0.17013741, 0.1702496, 0.17036155, 0.17047332, 0.17058486, 0.17069615, 0.17080727, 0.17091817, 0.17102885, 0.1711393, 0.17124955, 0.17135955, 0.17146939, 0.17157897, 0.17168833, 0.17179751, 0.17190643, 0.17201522, 0.17212367, 0.17223203, 0.17234008, 0.17244792, 0.1725556, 0.17266299, 0.17277025, 0.17287722, 0.17298399, 0.17309053, 0.17319688, 0.17330304, 0.17340894, 0.17351466, 0.17362012, 0.1737254, 0.17383043, 0.17393526, 0.1740399, 0.1741443, 0.17424847, 0.17435245, 0.17445616, 0.17455973, 0.17466304, 0.17476617, 0.174869, 0.17497168, 0.17507415, 0.17517635, 0.17527841, 0.17538022, 0.1754818, 0.1755832, 0.17568433, 0.17578526, 0.17588599, 0.17598647, 0.17608677, 0.17618684, 0.1762867, 0.17638633, 0.17648578, 0.17658493, 0.17668396, 0.17678258, 0.1768786, 0.17697442, 0.17707011, 0.17716564, 0.17726101, 0.17735624, 0.17745128, 0.17754617, 0.17764089, 0.17773543, 0.17782985, 0.1779241, 0.17801817, 0.17811212, 0.17820586, 0.1782995, 0.17839292, 0.17848618, 0.17857932, 0.17867233, 0.17876512, 0.17885776, 0.17895025, 0.17904261, 0.17913476, 0.17922679, 0.17931862, 0.17941032, 0.17950185, 0.17959324, 0.17968443, 0.17977548, 0.17986637, 0.17995711, 0.18004769, 0.18013808, 0.18022837, 0.18031844, 0.1804084, 0.18049817, 0.18058778, 0.18067724, 0.18076652, 0.18085565, 0.18094464, 0.18103346, 0.18112211, 0.18121061, 0.18129894, 0.18138711, 0.18147513, 0.18156298, 0.18165071, 0.18173823, 0.18182562, 0.18191287, 0.18199992, 0.18208683, 0.18217355, 0.18226016, 0.18234655, 0.18243282, 0.18251893, 0.18260485, 0.18269065, 0.18277627, 0.18286175, 0.18294704, 0.18303217, 0.18311721, 0.18320198, 0.18328667, 0.18337119, 0.18345553, 0.18353972, 0.18362372, 0.18370761, 0.18379132, 0.18387488, 0.18395826, 0.18404149, 0.18412454, 0.18420747, 0.18429019, 0.1843728, 0.18445523, 0.18453752, 0.18461961, 0.18470158, 0.18478335, 0.18486503, 0.18494645, 0.18502778, 0.18510894, 0.18518993, 0.18527077, 0.18535146, 0.18543194, 0.1855123, 0.18559304, 0.18567206, 0.18575108, 0.18583006, 0.18590902, 0.1859879, 0.18606682, 0.18614571, 0.18622452, 0.18630332, 0.18638213, 0.18646088, 0.18653962, 0.18661828, 0.18669699, 0.18677561, 0.18685424, 0.18693282, 0.18701139, 0.18708991, 0.18716842, 0.1872469, 0.18732533, 0.18740372, 0.18748216, 0.18756051, 0.18763883, 0.18771715, 0.18779543, 0.18787366, 0.18795189, 0.18803009, 0.18810827, 0.18818641, 0.18826452, 0.18834259, 0.18842065, 0.18849866, 0.18857667, 0.18865463, 0.18873256, 0.18881048, 0.18888836, 0.18896624, 0.18904406, 0.18912184, 0.18919961, 0.18927738, 0.18935508, 0.18943277, 0.18951043, 0.18958808, 0.18966568, 0.18974324, 0.1898208, 0.18989831, 0.18997578, 0.19005328, 0.1901307, 0.19020812, 0.19028547, 0.19036284, 0.19044015, 0.19051746, 0.19059472, 0.19067197, 0.19074917, 0.19082634, 0.19090351, 0.19098064, 0.19105773, 0.1911348, 0.19121185, 0.19128884, 0.19136582, 0.1914428, 0.19151974, 0.19159663, 0.19167352, 0.19175035, 0.19182718, 0.19190393, 0.19198072, 0.19205745, 0.19213416, 0.19221081, 0.19228749, 0.1923641, 0.19244067, 0.19251727, 0.19259378, 0.19267032, 0.19274677, 0.19282325, 0.19289966, 0.19297606, 0.19305241, 0.19312876, 0.19320507, 0.19328135, 0.19335553, 0.19343343, 0.19351143, 0.19358946, 0.19366764, 0.19374591, 0.19382429, 0.19390275, 0.1939813, 0.19405998, 0.19413871, 0.19421756, 0.19429646, 0.19437554, 0.19445466, 0.19453387, 0.1946132, 0.19469264, 0.19477211, 0.19485171, 0.19493143, 0.19501123, 0.19509113, 0.1951711, 0.1952512, 0.19533136, 0.19541167, 0.19549198, 0.19557247, 0.19565304, 0.1957337, 0.19581446, 0.1958953, 0.19597626, 0.19605729, 0.19613841, 0.19621961, 0.19630092, 0.19638236, 0.19646385, 0.19654548, 0.19662718, 0.19670899, 0.19679089, 0.19687288, 0.196955, 0.19703716, 0.19711943, 0.1972018, 0.1972843, 0.19736683, 0.19744948, 0.19753224, 0.19761509, 0.19769801, 0.19778107, 0.19786419, 0.19794743, 0.19803074, 0.19811417, 0.19819771, 0.1982813, 0.198365, 0.19844882, 0.19853272, 0.19861671, 0.19870079, 0.19878496, 0.19886924, 0.19895363, 0.19903812, 0.19912265, 0.19920734, 0.19929208, 0.19937694, 0.19946188, 0.19954692, 0.19963206, 0.19971731, 0.19980262, 0.19988805, 0.19997354, 0.20005921, 0.20014492, 0.2002307, 0.20031658, 0.2004026, 0.20048869, 0.20057487, 0.20066115, 0.20074755, 0.20083399, 0.20092058, 0.20100726, 0.201094, 0.20118086, 0.20126782, 0.20135486, 0.20144199, 0.20152923, 0.20161574, 0.20170559, 0.20179562, 0.20188573, 0.20197605, 0.20206645, 0.20215704, 0.20224774, 0.20233856, 0.20242956, 0.20252067, 0.20261197, 0.20270334, 0.20279494, 0.20288661, 0.20297845, 0.20307043, 0.20316252, 0.2032548, 0.20334715, 0.2034397, 0.20353237, 0.20362519, 0.20371813, 0.20381121, 0.20390445, 0.20399787, 0.20409134, 0.20418504, 0.20427883, 0.20437275, 0.20446679, 0.20456102, 0.20465535, 0.20474988, 0.20484449, 0.20493929, 0.20503417, 0.20512925, 0.20522442, 0.20531979, 0.20541523, 0.20551085, 0.20560662, 0.20570253, 0.2057986, 0.20589474, 0.20599107, 0.2060875, 0.20618412, 0.20628084, 0.20637773, 0.20647475, 0.20657191, 0.2066692, 0.20676664, 0.20686422, 0.20696194, 0.20705982, 0.20715784, 0.20725596, 0.20735425, 0.20745264, 0.20755121, 0.20764993, 0.20774874, 0.20784771, 0.20794687, 0.20804609, 0.20814551, 0.20824511, 0.20834474, 0.2084446, 0.20854454, 0.20864464, 0.20874488, 0.20884529, 0.20894581, 0.20904647, 0.20914729, 0.20924817, 0.20934929, 0.20945051, 0.2095519, 0.20965339, 0.20975503, 0.20985681, 0.20995876, 0.21006082, 0.21016303, 0.21026538, 0.21036789, 0.2104705, 0.21057329, 0.21067616, 0.21077923, 0.21088238, 0.21098574, 0.21108918, 0.2111928, 0.21130271, 0.21140863, 0.21151464, 0.21162073, 0.21172692, 0.21183322, 0.21193957, 0.21204609, 0.21215264, 0.21225932, 0.21236609, 0.21247296, 0.21257991, 0.21268699, 0.21279411, 0.2129014, 0.21300872, 0.21311614, 0.21322368, 0.2133313, 0.21343902, 0.21354686, 0.2136548, 0.21376282, 0.21387094, 0.21397915, 0.21408746, 0.21419585, 0.21430434, 0.21441291, 0.21452163, 0.21463038, 0.21473926, 0.21484827, 0.21495734, 0.21506648, 0.21517578, 0.21528511, 0.21539457, 0.21550412, 0.21561377, 0.21572351, 0.21583337, 0.21594329, 0.21605334, 0.21616344, 0.21627368, 0.21638398, 0.21649441, 0.21660495, 0.2167155, 0.21682623, 0.21693704, 0.21704794, 0.21715891, 0.21727, 0.21738118, 0.21749249, 0.21760385, 0.21771532, 0.21782689, 0.21793854, 0.21805032, 0.21816218, 0.21827412, 0.21838616, 0.21849829, 0.21861054, 0.21872288, 0.21883529, 0.21894783, 0.21906045, 0.21917318, 0.21928601, 0.21939892, 0.21951191, 0.21962501, 0.21973822, 0.21985151, 0.21996491, 0.22007839, 0.22019199, 0.22030565, 0.22041942, 0.22053328, 0.22064725, 0.22076134, 0.22087546, 0.22098976, 0.2211041, 0.22121856, 0.2213331, 0.22144772, 0.22156246, 0.22167729, 0.22179221, 0.22190724, 0.22202235, 0.22213757, 0.22225289, 0.22237402, 0.22249055, 0.22260703, 0.22272351, 0.22283998, 0.22295645, 0.2230729, 0.22318934, 0.22330576, 0.22342218, 0.22353856, 0.22365497, 0.22377135, 0.22388773, 0.22400407, 0.22412039, 0.22423674, 0.22435308, 0.22446936, 0.22458567, 0.22470194, 0.22481823, 0.22493449, 0.22505073, 0.22516696, 0.22528321, 0.22539942, 0.22551562, 0.2256318, 0.22574799, 0.22586417, 0.2259803, 0.22609647, 0.22621258, 0.22632872, 0.22644481, 0.22656092, 0.22667699, 0.22679307, 0.22690913, 0.22702521, 0.2271412, 0.22725724, 0.22737326, 0.22748926, 0.22760524, 0.22772124, 0.2278372, 0.22795317, 0.2280691, 0.22818503, 0.22830094, 0.22841686, 0.22853278, 0.22864865, 0.22876453, 0.22888039, 0.22899623, 0.22911207, 0.2292279, 0.2293437, 0.22945954, 0.22957529, 0.22969109, 0.22980686, 0.22992261, 0.23003834, 0.2301541, 0.23026979, 0.2303855, 0.23050119, 0.23061687, 0.23073255, 0.23084822, 0.23096389, 0.2310795, 0.23119512, 0.23131074, 0.23142633, 0.23154196, 0.23165752, 0.23177309, 0.23188867, 0.2320042, 0.23211975, 0.23223524, 0.23235075, 0.23246624, 0.23258172, 0.2326972, 0.23281266, 0.2329281, 0.23304355, 0.23315896, 0.23327439, 0.23338978, 0.23350519, 0.23362057, 0.23373593, 0.23385127, 0.23396532, 0.23407963, 0.23419386, 0.23430794, 0.23442192, 0.23453577, 0.23464949, 0.23476309, 0.23487654, 0.2349899, 0.23510312, 0.23521623, 0.2353292, 0.23544204, 0.23555475, 0.23566735, 0.23577982, 0.23589218, 0.23600441, 0.23611653, 0.23622848, 0.23634036, 0.23645207, 0.23656368, 0.23667517, 0.23678654, 0.23689774, 0.23700888, 0.23711984, 0.2372307, 0.23734145, 0.23745206, 0.23756254, 0.23767291, 0.23778313, 0.23789327, 0.23800325, 0.23811314, 0.23822288, 0.23833247, 0.23844199, 0.23855135, 0.2386606, 0.23876972, 0.23887873, 0.23898759, 0.23909634, 0.23920496, 0.23931345, 0.23942183, 0.23953009, 0.23963822, 0.23974623, 0.2398541, 0.23996185, 0.24006948, 0.24017698, 0.2402844, 0.24039163, 0.24049878, 0.24060577, 0.24071266, 0.24081941, 0.24092607, 0.24103259, 0.24113898, 0.24124524, 0.24135138, 0.24145739, 0.24156328, 0.24166903, 0.24177469, 0.24188019, 0.2419856, 0.24209087, 0.24219602, 0.24230103, 0.24240592, 0.24251071, 0.24261537, 0.24271986, 0.24282427, 0.24292855, 0.24303269, 0.24313675, 0.24324064, 0.24334443, 0.24344808, 0.24355161, 0.24365501, 0.24375831, 0.24386145, 0.24396448, 0.24406739, 0.24417017, 0.24427283, 0.24437536, 0.24447779, 0.24458008, 0.24468225, 0.24478069, 0.24488017, 0.24497949, 0.24507861, 0.2451776, 0.24527641, 0.24537501, 0.24547346, 0.24557176, 0.24566989, 0.24576783, 0.24586558, 0.2459632, 0.24606062, 0.24615787, 0.24625497, 0.24635187, 0.24644864, 0.24654518, 0.24664162, 0.24673782, 0.24683389, 0.24692976, 0.24702549, 0.24712102, 0.2472164, 0.24731159, 0.24740662, 0.24750145, 0.24759616, 0.24769068, 0.24778502, 0.24787921, 0.2479732, 0.24806704, 0.24816068, 0.24825418, 0.24834749, 0.24844062, 0.24853361, 0.2486264, 0.24871902, 0.2488115, 0.24890378, 0.24899589, 0.24908781, 0.2491796, 0.2492712, 0.24936262, 0.24945387, 0.24954498, 0.24963588, 0.24972662, 0.24981719, 0.24990761, 0.24999782, 0.25008789, 0.25017777, 0.25026748, 0.25035703, 0.25044641, 0.25053561, 0.25062463, 0.2507135, 0.25080216, 0.2508907, 0.25097904, 0.25106719, 0.2511552, 0.25124303, 0.25133064, 0.25141817, 0.25150546, 0.25159261, 0.2516796, 0.25176638, 0.25185299, 0.25193948, 0.25202575, 0.25211185, 0.2521978, 0.25228357, 0.2523692, 0.25245461, 0.25253984, 0.25262493, 0.25270987, 0.25279459, 0.2528792, 0.25296357, 0.25304779, 0.25313187, 0.25321573, 0.25329944, 0.25338301, 0.25346637, 0.25354958, 0.25363261, 0.25371546, 0.25379813, 0.25388268, 0.25396279, 0.25404277, 0.25412264, 0.2542024, 0.254282, 0.25436151, 0.25444084, 0.25452009, 0.25459921, 0.25467819, 0.25475705, 0.25483575, 0.2549144, 0.25499287, 0.25507122, 0.25514945, 0.25522757, 0.25530553, 0.2553834, 0.25546113, 0.25553873, 0.25561619, 0.25569355, 0.25577077, 0.2558479, 0.25592488, 0.25600171, 0.25607842, 0.25615504, 0.25623149, 0.25630784, 0.25638407, 0.25646016, 0.25653616, 0.25661197, 0.25668773, 0.25676331, 0.25683877, 0.25691411, 0.25698933, 0.25706443, 0.25713941, 0.25721422, 0.25728896, 0.25736353, 0.257438, 0.25751233, 0.25758657, 0.25766063, 0.2577346, 0.25780845, 0.25788215, 0.25795573, 0.25802919, 0.25810254, 0.25817576, 0.25824881, 0.25832176, 0.25839463, 0.25846729, 0.25853989, 0.25861233, 0.25868466, 0.25875688, 0.25882894, 0.25890091, 0.2589727, 0.25904441, 0.25911599, 0.25918746, 0.25925878, 0.25932997, 0.25940105, 0.25947201, 0.25954279, 0.25961348, 0.25968406, 0.25975454, 0.25982481, 0.25989503, 0.25996512, 0.26003504, 0.26010484, 0.26017454, 0.2602441, 0.26031354, 0.26038286, 0.26045206, 0.26052111, 0.26059008, 0.26065886, 0.26072755, 0.26079613, 0.26086456, 0.26093286, 0.26100105, 0.26106912, 0.26113704, 0.26120484, 0.26127112, 0.26133826, 0.26140538, 0.26147243, 0.26153949, 0.26160651, 0.26167351, 0.26174051, 0.26180747, 0.26187441, 0.26194131, 0.26200819, 0.26207507, 0.26214188, 0.26220873, 0.26227549, 0.26234227, 0.26240903, 0.26247573, 0.26254246, 0.26260909, 0.26267576, 0.2627424, 0.26280901, 0.26287559, 0.26294217, 0.26300868, 0.26307517, 0.26314166, 0.26320812, 0.26327455, 0.26334098, 0.26340735, 0.26347372, 0.26354009, 0.26360637, 0.26367268, 0.26373896, 0.26380521, 0.26387143, 0.26393762, 0.26400381, 0.26406997, 0.26413608, 0.26420221, 0.26426828, 0.26433432, 0.26440039, 0.2644664, 0.26453239, 0.26459834, 0.26466426, 0.26473022, 0.26479608, 0.26486194, 0.26492777, 0.26499361, 0.26505941, 0.26512522, 0.26519093, 0.26525667, 0.26532236, 0.26538807, 0.26545373, 0.26551935, 0.26558495, 0.26565054, 0.26571608, 0.26578164, 0.26584712, 0.26591262, 0.2659781, 0.26604357, 0.26610896, 0.26617438, 0.26623973, 0.26630509, 0.26637042, 0.26643571, 0.26650098, 0.26656622, 0.26663145, 0.26669666, 0.26676187, 0.26682702, 0.26689216, 0.26695725, 0.26702237, 0.2670874, 0.26715246, 0.26721749, 0.26728246, 0.26734743, 0.26741239, 0.2674773, 0.26754218, 0.26760709, 0.26767191, 0.26773673, 0.26780155, 0.26786491, 0.26793146, 0.2679981, 0.2680648, 0.26813152, 0.26819834, 0.26826516, 0.26833206, 0.268399, 0.26846606, 0.26853308, 0.26860023, 0.2686674, 0.2687346, 0.26880187, 0.26886922, 0.2689366, 0.26900405, 0.26907152, 0.26913908, 0.26920667, 0.26927435, 0.26934204, 0.26940981, 0.26947764, 0.2695455, 0.26961344, 0.26968142, 0.26974943, 0.26981753, 0.26988569, 0.26995388, 0.27002212, 0.27009046, 0.2701588, 0.27022722, 0.27029568, 0.27036422, 0.2704328, 0.27050143, 0.2705701, 0.27063882, 0.27070764, 0.27077648, 0.27084541, 0.27091435, 0.27098337, 0.27105242, 0.2711215, 0.2711907, 0.2712599, 0.27132919, 0.27139857, 0.27146792, 0.27153736, 0.27160689, 0.27167639, 0.27174604, 0.27181569, 0.2718854, 0.27195522, 0.27202502, 0.27209491, 0.27216482, 0.2722348, 0.27230483, 0.27237493, 0.27244508, 0.27251527, 0.27258551, 0.27265581, 0.27272618, 0.27279663, 0.27286708, 0.2729376, 0.2730082, 0.27307883, 0.27314952, 0.27322027, 0.27329108, 0.27336189, 0.27343282, 0.27350375, 0.27357477, 0.27364585, 0.27371696, 0.27378815, 0.27385938, 0.27393064, 0.27400199, 0.27407339, 0.27414483, 0.27421632, 0.27428788, 0.27435949, 0.27443114, 0.27450284, 0.27457467, 0.27464646, 0.27471831, 0.27479127, 0.2748661, 0.274941, 0.27501592, 0.2750909, 0.27516586, 0.27524096, 0.275316, 0.27539113, 0.27546632, 0.27554151, 0.27561677, 0.27569205, 0.27576736, 0.27584273, 0.27591813, 0.27599356, 0.27606902, 0.27614453, 0.27622011, 0.27629572, 0.27637133, 0.27644703, 0.27652276, 0.27659848, 0.2766743, 0.27675012, 0.27682599, 0.27690193, 0.27697787, 0.27705386, 0.27712992, 0.27720597, 0.27728212, 0.27735826, 0.27743447, 0.2775107, 0.27758697, 0.27766329, 0.27773964, 0.27781603, 0.27789244, 0.27796894, 0.27804545, 0.27812201, 0.2781986, 0.27827525, 0.27835187, 0.27842861, 0.27850536, 0.27858216, 0.27865896, 0.27873585, 0.27881277, 0.27888972, 0.2789667, 0.27904373, 0.27912077, 0.2791979, 0.27927503, 0.27935225, 0.2794295, 0.27950671, 0.27958402, 0.27966139, 0.27973875, 0.27981621, 0.27989367, 0.27997118, 0.28004873, 0.2801263, 0.28020394, 0.2802816, 0.2803593, 0.28043702, 0.28051481, 0.28059265, 0.28067052, 0.28074843, 0.28082636, 0.28090435, 0.28098238, 0.2810604, 0.28113851, 0.28121668, 0.28129485, 0.28137308, 0.28145131, 0.28152964, 0.28160799, 0.28168634, 0.28176478, 0.28184322, 0.28192171, 0.28200027, 0.28207886, 0.28215745, 0.28223613, 0.28231481, 0.28239357, 0.28247234, 0.28255332, 0.2826342, 0.28271505, 0.28279582, 0.28287646, 0.28295708, 0.2830376, 0.28311804, 0.28319839, 0.28327867, 0.28335884, 0.28343898, 0.28351903, 0.28359902, 0.28367889, 0.2837587, 0.28383845, 0.28391814, 0.28399768, 0.28407723, 0.28415665, 0.28423598, 0.28431529, 0.28439447, 0.28447357, 0.2845526, 0.28463158, 0.28471047, 0.28478926, 0.284868, 0.28494665, 0.28502524, 0.28510371, 0.28518215, 0.28526047, 0.28533876, 0.28541693, 0.28549501, 0.28557307, 0.285651, 0.28572887, 0.28580669, 0.28588438, 0.28596202, 0.28603959, 0.28611708, 0.28619447, 0.28627181, 0.28634906, 0.28642625, 0.28650334, 0.28658035, 0.28665727, 0.28673416, 0.28681093, 0.28688765, 0.28696427, 0.2870408, 0.2871173, 0.28719369, 0.28727001, 0.28734624, 0.28742242, 0.2874985, 0.2875745, 0.28765044, 0.28772628, 0.28780204, 0.28787777, 0.28795338, 0.28802893, 0.28810436, 0.28817976, 0.2882551, 0.28833029, 0.28840548, 0.28848055, 0.28855553, 0.28863046, 0.28870529, 0.28878003, 0.28885475, 0.28892934, 0.28900388, 0.28907833, 0.28915271, 0.28922698, 0.28930122, 0.28937536, 0.28944942, 0.28952339, 0.2895973, 0.28967115, 0.28974491, 0.28981858, 0.28989217, 0.28996569, 0.29003912, 0.2901125, 0.29018605, 0.29025877, 0.29033121, 0.29040343, 0.29047543, 0.29054716, 0.29061869, 0.29068998, 0.29076099, 0.2908318, 0.29090241, 0.29097274, 0.29104289, 0.29111275, 0.2911824, 0.29125184, 0.29132101, 0.29138994, 0.29145867, 0.29152715, 0.2915954, 0.29166341, 0.29173118, 0.29179874, 0.29186606, 0.29193315, 0.29199997, 0.2920666, 0.292133, 0.29219913, 0.29226506, 0.29233071, 0.29239619, 0.2924614, 0.29252636, 0.29259109, 0.29265562, 0.2927199, 0.29278395, 0.29284775, 0.29291135, 0.29297468, 0.29303777, 0.29310068, 0.2931633, 0.29322571, 0.2932879, 0.29334983, 0.29341155, 0.29347304, 0.29353428, 0.29359525, 0.29365605, 0.29371661, 0.29377693, 0.29383698, 0.29389682, 0.29395643, 0.29401582, 0.29407492, 0.29413384, 0.29419255, 0.29425099, 0.2943092, 0.29436716, 0.29442489, 0.29448241, 0.29453969, 0.2945967, 0.29465351, 0.2947101, 0.29476643, 0.29482254, 0.29487842, 0.29493403, 0.29498947, 0.29504463, 0.29509959, 0.29515427, 0.29520872, 0.29526299, 0.29531699, 0.29537076, 0.29542428, 0.2954776, 0.29553068, 0.29558352, 0.29563609, 0.29568848, 0.29574063, 0.29579252, 0.29584417, 0.29589564, 0.29594681, 0.29599777, 0.29604852, 0.29609904, 0.29614928, 0.29619932, 0.29624915, 0.29629767, 0.29634446, 0.29639095, 0.29643705, 0.29648289, 0.29652831, 0.29657346, 0.29661825, 0.29666272, 0.29670686, 0.29675063, 0.29679412, 0.29683724, 0.29688001, 0.2969225, 0.29696465, 0.29700643, 0.29704791, 0.29708904, 0.29712981, 0.29717031, 0.29721043, 0.29725024, 0.2972897, 0.29732883, 0.29736763, 0.29740611, 0.29744425, 0.29748204, 0.29751951, 0.29755664, 0.29759344, 0.29762992, 0.29766604, 0.29770184, 0.29773733, 0.29777247, 0.29780725, 0.29784173, 0.29787585, 0.29790968, 0.29794315, 0.29797626, 0.29800907, 0.29804155, 0.29807368, 0.29810548, 0.29813695, 0.29816809, 0.29819888, 0.29822937, 0.2982595, 0.29828933, 0.29831877, 0.29834792, 0.29837674, 0.2984052, 0.29843336, 0.29846117, 0.29848862, 0.29851577, 0.29854256, 0.29856902, 0.29859519, 0.298621, 0.29864645, 0.2986716, 0.2986964, 0.2987209, 0.29874501, 0.29876882, 0.2987923, 0.29881543, 0.29883826, 0.29886073, 0.29888284, 0.29890466, 0.29892614, 0.2989473, 0.29896811, 0.29898858, 0.2990087, 0.29902855, 0.29904801, 0.29906714, 0.29908597, 0.29910442, 0.29912257, 0.29914039, 0.29915786, 0.29917502, 0.29919183, 0.29920828, 0.29922441, 0.29924026, 0.29925573, 0.29927087, 0.29928568, 0.29930013, 0.29931432, 0.29932714, 0.29933801, 0.29934853, 0.29935876, 0.29936865, 0.29937822, 0.29938743, 0.29939631, 0.29940489, 0.29941311, 0.29942101, 0.29942858, 0.29943579, 0.29944271, 0.29944927, 0.29945549, 0.29946139, 0.29946697, 0.29947221, 0.29947713, 0.29948169, 0.29948592, 0.29948983, 0.2994934, 0.29949665, 0.29949957, 0.29950213, 0.2995044, 0.29950631, 0.29950792, 0.29950914, 0.29951006, 0.29951063, 0.29951093, 0.29951084, 0.29951042, 0.29950967, 0.2995086, 0.2995072, 0.29950544, 0.29950339, 0.299501, 0.29949826, 0.29949519, 0.29949176, 0.29948804, 0.29948395, 0.29947957, 0.29947487, 0.2994698, 0.2994644, 0.29945868, 0.29945263, 0.29944623, 0.29943949, 0.29943246, 0.29942507, 0.29941732, 0.29940927, 0.29940093, 0.29939219, 0.29938316, 0.29937378, 0.29936406, 0.29935402, 0.29934365, 0.29933295, 0.29932189, 0.29931051, 0.29929882, 0.29928675, 0.29927438, 0.29926172, 0.29924867, 0.29923531, 0.29922158, 0.29920757, 0.29919323, 0.29917851, 0.29916346, 0.29914811, 0.29913244, 0.2991164, 0.29910004, 0.29908332, 0.29906633, 0.29904899, 0.29903129, 0.29901329, 0.29899493, 0.29897627, 0.29895726, 0.29893792, 0.29891822, 0.29889822, 0.29887787, 0.29885718, 0.29883617, 0.29881486, 0.29879317, 0.29877001, 0.29874524, 0.29872024, 0.298695, 0.29866955, 0.29864386, 0.29861793, 0.29859176, 0.29856542, 0.2985388, 0.29851198, 0.29848492, 0.29845762, 0.29843009, 0.29840234, 0.29837438, 0.29834616, 0.29831773, 0.29828906, 0.29826018, 0.29823107, 0.29820171, 0.29817215, 0.29814237, 0.2981123, 0.29808205, 0.29805157, 0.29802084, 0.2979899, 0.29795873, 0.29792732, 0.2978957, 0.29786384, 0.29783174, 0.29779944, 0.29776686, 0.29773411, 0.29770109, 0.29766789, 0.29763442, 0.29760072, 0.2975668, 0.29753268, 0.29749829, 0.29746369, 0.29742885, 0.2973938, 0.29735851, 0.29732302, 0.29728726, 0.29725128, 0.2972151, 0.29717866, 0.297142, 0.29710513, 0.297068, 0.29703066, 0.29699308, 0.29695529, 0.29691726, 0.29687899, 0.29684052, 0.29680181, 0.29676285, 0.29672369, 0.29668429, 0.29664466, 0.29660481, 0.29656473, 0.29652441, 0.29648387, 0.2964431, 0.29640213, 0.29636088, 0.2963194, 0.29627773, 0.29623583, 0.29619369, 0.29615131, 0.29610869, 0.2960659, 0.29602283, 0.29597953, 0.29593602, 0.2958923, 0.29584834, 0.29580414, 0.29575971, 0.29571503, 0.29567018, 0.29562506, 0.29557973, 0.29553416, 0.29548836, 0.29544234, 0.29539609, 0.2953496, 0.2953029, 0.29525596, 0.29520878, 0.29516095, 0.29511309, 0.2950651, 0.29501703, 0.29496896, 0.2949208, 0.29487258, 0.2948243, 0.29477593, 0.29472753, 0.29467905, 0.2946305, 0.29458186, 0.29453319, 0.29448441, 0.29443562, 0.29438674, 0.29433781, 0.29428878, 0.29423973, 0.29419059, 0.29414141, 0.29409215, 0.2940428, 0.29399341, 0.29394397, 0.29389441, 0.29384485, 0.29379517, 0.29374546, 0.29369566, 0.29364583, 0.29359588, 0.2935459, 0.29349589, 0.29344577, 0.29339561, 0.29334536, 0.29329506, 0.29324469, 0.29319423, 0.29314375, 0.29309317, 0.29304251, 0.29299182, 0.29294106, 0.29289025, 0.29283935, 0.29278842, 0.29273736, 0.29268628, 0.29263517, 0.29258391, 0.29253262, 0.2924813, 0.29242986, 0.29237843, 0.29232687, 0.29227525, 0.29222357, 0.29217184, 0.29212004, 0.29206818, 0.29201627, 0.29196426, 0.2919122, 0.29186007, 0.29180789, 0.29175562, 0.29170328, 0.29165089, 0.29159844, 0.29154593, 0.29149336, 0.29144067, 0.29138798, 0.2913352, 0.29128236, 0.29122946, 0.29117647, 0.29112342, 0.29107034, 0.29101714, 0.29096395, 0.29091063, 0.29085726, 0.29080385, 0.29075035, 0.2906968, 0.29064319, 0.29058948, 0.29053572, 0.2904819, 0.29042801, 0.29037407, 0.29032007, 0.29026601, 0.29021186, 0.29015762, 0.29010335, 0.29005009, 0.28999773, 0.28994539, 0.28989312, 0.28984094, 0.28978881, 0.28973678, 0.28968477, 0.28963289, 0.28958103, 0.28952926, 0.28947759, 0.28942594, 0.28937441, 0.28932291, 0.28927144, 0.28922012, 0.28916883, 0.28911763, 0.28906649, 0.28901541, 0.28896442, 0.28891349, 0.28886259, 0.2888118, 0.28876108, 0.28871045, 0.28865987, 0.28860933, 0.2885589, 0.28850853, 0.2884582, 0.28840798, 0.28835779, 0.28830773, 0.28825769, 0.28820771, 0.28815785, 0.28810802, 0.28805828, 0.2880086, 0.28795898, 0.28790945, 0.28785998, 0.28781059, 0.28776124, 0.28771198, 0.28766277, 0.28761366, 0.28756461, 0.28751564, 0.28746673, 0.28741789, 0.28736913, 0.28732041, 0.28727177, 0.28722322, 0.28717473, 0.2871263, 0.28707793, 0.28702965, 0.28698146, 0.2869333, 0.2868852, 0.28683722, 0.2867893, 0.28674141, 0.28669363, 0.28664589, 0.28659824, 0.28655064, 0.28650314, 0.28645566, 0.28640831, 0.28636098, 0.28631377, 0.2862666, 0.28621948, 0.28617248, 0.28612548, 0.2860786, 0.28603178, 0.28598502, 0.28593835, 0.28589174, 0.28584519, 0.28579873, 0.28575233, 0.28570598, 0.2856597, 0.28561354, 0.2855674, 0.28552136, 0.28547534, 0.28542945, 0.28538361, 0.28533784, 0.28529215, 0.28524649, 0.28520092, 0.28515631, 0.28511271, 0.28506926, 0.28502592, 0.28498274, 0.28493968, 0.28489673, 0.28485394, 0.28481126, 0.28476873, 0.28472632, 0.28468406, 0.28464189, 0.28459987, 0.28455797, 0.28451625, 0.28447464, 0.28443313, 0.28439176, 0.28435054, 0.28430948, 0.2842685, 0.28422767, 0.28418696, 0.2841464, 0.28410596, 0.28406566, 0.28402549, 0.28398544, 0.28394553, 0.28390574, 0.28386611, 0.28382659, 0.28378719, 0.28374794, 0.28370884, 0.28366986, 0.28363097, 0.28359225, 0.28355366, 0.28351519, 0.28347686, 0.28343865, 0.2834006, 0.28336269, 0.28332487, 0.28328717, 0.28324962, 0.28321221, 0.28317493, 0.28313783, 0.28310075, 0.28306389, 0.28302714, 0.28299052, 0.28295404, 0.28291765, 0.28288144, 0.28284535, 0.28280938, 0.28277352, 0.28273782, 0.28270227, 0.2826668, 0.28263152, 0.28259632, 0.2825613, 0.2825264, 0.28249162, 0.28245693, 0.28242245, 0.28238806, 0.28235382, 0.28231966, 0.28228569, 0.28225183, 0.2822181, 0.28218448, 0.28215101, 0.28211766, 0.28208449, 0.28205141, 0.28201845, 0.28198567, 0.28195298, 0.28192043, 0.28188804, 0.28185573, 0.28182358, 0.28179157, 0.28175971, 0.28172791, 0.28169629, 0.28166482, 0.28163344, 0.2816022, 0.28157109, 0.28154016, 0.28150931, 0.28147858, 0.28144863, 0.28141943, 0.28139037, 0.28136143, 0.28133261, 0.28130394, 0.28127539, 0.28124702, 0.28121877, 0.2811906, 0.28116259, 0.28113472, 0.28110698, 0.28107938, 0.28105193, 0.28102458, 0.28099737, 0.28097028, 0.28094336, 0.28091654, 0.2808899, 0.28086334, 0.28083694, 0.28081065, 0.28078449, 0.2807585, 0.28073263, 0.28070688, 0.28068128, 0.2806558, 0.28063044, 0.28060526, 0.28058016, 0.28055525, 0.28053042, 0.28050575, 0.28048116, 0.28045678, 0.28043246, 0.28040835, 0.28038436, 0.28036046, 0.28033671, 0.2803131, 0.28028962, 0.28026628, 0.28024307, 0.28021997, 0.28019702, 0.28017423, 0.28015155, 0.28012899, 0.28010657, 0.28008428, 0.28006214, 0.28004014, 0.28001824, 0.27999651, 0.27997488, 0.27995339, 0.27993205, 0.27991083, 0.27988976, 0.27986881, 0.27984798, 0.27982733, 0.27980676, 0.27978632, 0.27976605, 0.27974591, 0.27972588, 0.279706, 0.27968624, 0.27966663, 0.27964714, 0.27962777, 0.27960858, 0.27958947, 0.27957049, 0.27955166, 0.279533, 0.27951446, 0.27949601, 0.27947775, 0.27945957, 0.27944157, 0.27942368, 0.27940592, 0.27938831, 0.27937078, 0.27935344, 0.27933621, 0.27931911, 0.27930215, 0.27928534, 0.27926865, 0.27925211, 0.27923566, 0.27921936, 0.27920324, 0.27918768, 0.27917269, 0.27915782, 0.27914298, 0.27912831, 0.27911368, 0.27909917, 0.27908474, 0.27907038, 0.27905613, 0.27904195, 0.27902791, 0.27901393, 0.27900004, 0.27898625, 0.27897251, 0.27895889, 0.27894539, 0.27893195, 0.27891859, 0.27890536, 0.27889219, 0.27887911, 0.27886611, 0.27885324, 0.27884045, 0.27882773, 0.27881512, 0.2788026, 0.27879015, 0.27877781, 0.27876556, 0.2787534, 0.2787413, 0.27872935, 0.27871743, 0.27870563, 0.27869391, 0.27868229, 0.27867079, 0.27865934, 0.27864799, 0.27863672, 0.27862555, 0.27861449, 0.27860352, 0.27859265, 0.27858183, 0.2785711, 0.27856049, 0.27854994, 0.27853951, 0.27852917, 0.27851894, 0.27850875, 0.27849868, 0.2784887, 0.2784788, 0.278469, 0.27845928, 0.27844965, 0.27844012, 0.27843067, 0.27842131, 0.27841207, 0.27840292, 0.27839383, 0.27838483, 0.27837592, 0.27836716, 0.27835843, 0.27834979, 0.27834126, 0.27833283, 0.27832448, 0.27831623, 0.27830803, 0.27829996, 0.27829197, 0.27828407, 0.27827626, 0.27826855, 0.27826095, 0.27825341, 0.27824596, 0.27823859, 0.27823132, 0.27822417, 0.27821708, 0.2782101, 0.27820319, 0.27819639, 0.27818969, 0.27818304, 0.27817652, 0.27817005, 0.27816373, 0.27815744, 0.2781513, 0.27814519, 0.27813959, 0.27813444, 0.27812928, 0.27812412, 0.27811897, 0.27811384, 0.27810875, 0.27810368, 0.27809858, 0.27809352, 0.27808845, 0.27808341, 0.27807838, 0.27807337, 0.27806839, 0.27806339, 0.27805838, 0.27805343, 0.27804849, 0.27804357, 0.27803865, 0.27803373, 0.27802885, 0.27802396, 0.27801907, 0.27801421, 0.27800938, 0.27800456, 0.27799976, 0.27799496, 0.27799016, 0.27798539, 0.27798063, 0.27797586, 0.27797115, 0.27796641, 0.2779617, 0.27795699, 0.27795231, 0.27794766, 0.27794299, 0.27793834, 0.27793372, 0.2779291, 0.27792451, 0.27791992, 0.27791533, 0.27791077, 0.27790624, 0.27790168, 0.27789715, 0.27789265, 0.27788815, 0.27788371, 0.27787921, 0.27787477, 0.2778703, 0.27786589, 0.27786145, 0.27785704, 0.27785268, 0.2778483, 0.27784395, 0.27783957, 0.27783525, 0.2778309, 0.27782661, 0.27782229, 0.27781802, 0.27781373, 0.2778095, 0.27780524, 0.27780101, 0.2777968, 0.2777926, 0.2777884, 0.27778423, 0.27778006, 0.27777591, 0.27777177, 0.27776766, 0.27776355, 0.27775943, 0.27775535, 0.27775127, 0.27774721, 0.27774319, 0.27773917, 0.27773511, 0.27773115, 0.27772713, 0.27772313, 0.2777192, 0.27771521, 0.27771127, 0.27770737, 0.27770346, 0.27769956, 0.27769566, 0.27769181, 0.27768809, 0.27768472, 0.27768129, 0.2776778, 0.27767417, 0.27767044, 0.27766666, 0.27766278, 0.27765879, 0.27765471, 0.27765056, 0.2776463, 0.27764192, 0.27763748, 0.27763295, 0.27762833, 0.27762359, 0.2776188, 0.27761388, 0.27760884, 0.27760378, 0.27759859, 0.27759331, 0.27758792, 0.27758247, 0.27757689, 0.27757126, 0.27756554, 0.27755967, 0.27755374, 0.27754772, 0.27754161, 0.27753541, 0.27752912, 0.27752271, 0.27751622, 0.27750966, 0.27750295, 0.27749625, 0.27748939, 0.27748242, 0.27747539, 0.27746823, 0.27746105, 0.27745372, 0.2774463, 0.27743879, 0.27743122, 0.2774235, 0.27741572, 0.27740782, 0.27739987, 0.27739182, 0.27738369, 0.27737543, 0.27736709, 0.27735865, 0.27735013, 0.27734151, 0.27733284, 0.27732405, 0.27731514, 0.27730614, 0.27729708, 0.2772879, 0.27727863, 0.27726927, 0.27725983, 0.27725029, 0.27724063, 0.27723095, 0.27722111, 0.27721119, 0.27720121, 0.27719107, 0.27718091, 0.27717063, 0.27716026, 0.2771498, 0.27713922, 0.27712858, 0.27711782, 0.277107, 0.27709606, 0.27708507, 0.27707392, 0.27706268, 0.27705145, 0.27704003, 0.27702853, 0.27701697, 0.27700529, 0.27699351, 0.27698168, 0.27696973, 0.27695769, 0.27694553, 0.27693331, 0.27692097, 0.27690858, 0.27689582, 0.27688277, 0.27686951, 0.27685603, 0.27684239, 0.27682853, 0.27681443, 0.27680016, 0.27678567, 0.27677101, 0.27675611, 0.276741, 0.27672571, 0.27671021, 0.27669448, 0.27667859, 0.2766625, 0.27664617, 0.27662963, 0.27661291, 0.27659598, 0.27657884, 0.2765615, 0.27654397, 0.27652621, 0.27650827, 0.27649012, 0.27647176, 0.2764532, 0.27643445, 0.27641547, 0.2763963, 0.27637693, 0.27635735, 0.27633756, 0.27631757, 0.27629736, 0.27627695, 0.27625635, 0.27623558, 0.27621457, 0.27619335, 0.27617195, 0.27615032, 0.27612847, 0.27610645, 0.27608421, 0.27606177, 0.27603915, 0.27601632, 0.27599326, 0.27597001, 0.27594656, 0.27592289, 0.27589902, 0.27587494, 0.27585065, 0.27582622, 0.27580154, 0.27577662, 0.27575153, 0.27572629, 0.27570075, 0.27567506, 0.27564916, 0.27562305, 0.27559674, 0.27557021, 0.27554348, 0.27551657, 0.27548945, 0.27546212, 0.27543458, 0.27540684, 0.27537888, 0.27535075, 0.27532241, 0.27529383, 0.27526507, 0.2752361, 0.27520692, 0.27517757, 0.275148, 0.27511823, 0.27508822, 0.27505806, 0.27502766, 0.27499706, 0.27496624, 0.27493528, 0.27490404, 0.27487266, 0.27484101, 0.27480921, 0.27477717, 0.27474496, 0.27471253, 0.27467987, 0.27464706, 0.27461398, 0.27458048, 0.27454531, 0.27450991, 0.27447414, 0.27443817, 0.2744019, 0.27436537, 0.27432853, 0.27429146, 0.27425408, 0.27421641, 0.2741785, 0.2741403, 0.27410182, 0.27406308, 0.27402407, 0.27398476, 0.27394518, 0.27390534, 0.27386519, 0.27382481, 0.27378413, 0.27374318, 0.27370194, 0.27366045, 0.27361864, 0.27357659, 0.27353427, 0.27349165, 0.27344877, 0.27340561, 0.27336219, 0.27331847, 0.27327448, 0.27323022, 0.2731857, 0.27314088, 0.27309582, 0.27305043, 0.2730048, 0.27295887, 0.27291268, 0.27286622, 0.27281949, 0.27277249, 0.27272519, 0.27267763, 0.2726298, 0.27258167, 0.2725333, 0.2724846, 0.27243567, 0.27238646, 0.27233696, 0.27228719, 0.27223712, 0.27218679, 0.27213624, 0.27208534, 0.2720342, 0.27198279, 0.27193108, 0.27187911, 0.27182686, 0.27177435, 0.27172151, 0.27166846, 0.27161512, 0.27156147, 0.27150759, 0.27145341, 0.27139893, 0.27134421, 0.27128923, 0.27123392, 0.27117836, 0.27112255, 0.27106643, 0.27101007, 0.27095339, 0.27089646, 0.27083927, 0.27078179, 0.27072403, 0.27066597, 0.27060768, 0.27054909, 0.27049023, 0.27043107, 0.27037168, 0.27031198, 0.27025199, 0.27019179, 0.27013126, 0.27007046, 0.2700094, 0.26994807, 0.26988646, 0.26982456, 0.2697624, 0.26969922, 0.26963425, 0.26956904, 0.26950353, 0.26943779, 0.26937175, 0.26930544, 0.26923886, 0.26917207, 0.26910493, 0.26903757, 0.26896989, 0.268902, 0.26883382, 0.26876539, 0.26869664, 0.26862764, 0.26855838, 0.26848888, 0.26841909, 0.26834899, 0.26827866, 0.26820806, 0.26813716, 0.26806602, 0.26799461, 0.26792291, 0.267851, 0.26777875, 0.26770625, 0.2676335, 0.26756045, 0.26748717, 0.26741359, 0.26733974, 0.26726565, 0.26719126, 0.26711661, 0.26704168, 0.26696652, 0.26689109, 0.26681533, 0.26673934, 0.2666631, 0.26658657, 0.26650977, 0.26643267, 0.26635534, 0.26627773, 0.26619986, 0.26612169, 0.26604328, 0.2659646, 0.26588565, 0.26580641, 0.26572692, 0.26564717, 0.26556712, 0.26548681, 0.26540622, 0.2653254, 0.26524431, 0.26516291, 0.26508129, 0.26499936, 0.26491717, 0.2648347, 0.26475197, 0.26466897, 0.2645857, 0.26450217, 0.26441836, 0.26433429, 0.26424995, 0.26416537, 0.26408044, 0.26399529, 0.26390988, 0.26382419, 0.26373824, 0.26365203, 0.26356551, 0.26347876, 0.2633917, 0.26330441, 0.26321682, 0.263129, 0.26304087, 0.26295248, 0.26286384, 0.26277491, 0.26268575, 0.26259625, 0.26250654, 0.26241654, 0.26232627, 0.2622357, 0.26214492, 0.26205388, 0.26196247, 0.2618697, 0.26177594, 0.26168206, 0.26158798, 0.26149374, 0.2613993, 0.26130468, 0.26120988, 0.2611149, 0.26101974, 0.26092443, 0.26082888, 0.26073316, 0.26063731, 0.26054126, 0.260445, 0.26034859, 0.26025203, 0.26015523, 0.26005828, 0.25996116, 0.25986385, 0.25976634, 0.25966865, 0.25957081, 0.25947276, 0.25937456, 0.25927615, 0.2591776, 0.2590788, 0.25897989, 0.25888076, 0.25878149, 0.25868201, 0.25858232, 0.25848252, 0.25838247, 0.2582823, 0.25818193, 0.25808138, 0.25798064, 0.25787973, 0.25777861, 0.25767738, 0.2575759, 0.25747427, 0.25737247, 0.25727046, 0.25716829, 0.25706592, 0.2569634, 0.25686067, 0.2567578, 0.25665468, 0.25655144, 0.256448, 0.25634438, 0.25624061, 0.25613663, 0.2560325, 0.25592816, 0.25582361, 0.25571895, 0.25561407, 0.25550902, 0.25540376, 0.25529835, 0.25519276, 0.25508699, 0.25498104, 0.25487491, 0.25476861, 0.2546621, 0.25455543, 0.25444859, 0.25434154, 0.25423434, 0.25412694, 0.25401938, 0.25391161, 0.2538037, 0.25369558, 0.25358728, 0.2534788, 0.25337014, 0.25326133, 0.25315231, 0.25304312, 0.25293374, 0.25282422, 0.25271446, 0.25260457, 0.25249445, 0.25238419, 0.25227374, 0.25216311, 0.25205231, 0.25194129, 0.25183013, 0.25171879, 0.25160703, 0.25149509, 0.2513831, 0.25127104, 0.25115898, 0.25104687, 0.25093469, 0.25082248, 0.25071022, 0.25059789, 0.25048557, 0.25037318, 0.25026074, 0.25014824, 0.25003573, 0.24992317, 0.24981055, 0.24969789, 0.24958518, 0.24947244, 0.24935965, 0.24924681, 0.24913393, 0.24902099, 0.24890803, 0.248795, 0.24868193, 0.24856883, 0.24845567, 0.2483425, 0.24822927, 0.24811594, 0.24800263, 0.24788925, 0.24777582, 0.24766237, 0.24754886, 0.24743529, 0.2473217, 0.24720804, 0.24709435, 0.24698064, 0.24686687, 0.24675302, 0.24663919, 0.24652524, 0.24641131, 0.2462973, 0.24618325, 0.24606916, 0.24595502, 0.24584083, 0.2457266, 0.24561234, 0.24549803, 0.24538366, 0.24526927, 0.24515481, 0.24504033, 0.24492577, 0.24481119, 0.24469656, 0.24458188, 0.24446717, 0.2443524, 0.2442376, 0.24412274, 0.24400784, 0.24389291, 0.24377792, 0.24366289, 0.24354781, 0.2434327, 0.24331753, 0.24320233, 0.24308705, 0.24297178, 0.24285643, 0.24274105, 0.24262559, 0.24251011, 0.2423946, 0.24227904, 0.2421634, 0.24204776, 0.24193205, 0.24181631, 0.24170052, 0.24158467, 0.24146879, 0.24135287, 0.24123688, 0.24112089, 0.24100484, 0.2408887, 0.24077258, 0.24065638, 0.24054013, 0.24042386, 0.24030754, 0.24019006, 0.24007539, 0.23996079, 0.23984624, 0.23973177, 0.23961735, 0.23950303, 0.23938873, 0.23927452, 0.23916036, 0.23904626, 0.23893224, 0.2388183, 0.2387044, 0.23859057, 0.23847681, 0.23836312, 0.2382495, 0.23813592, 0.23802242, 0.23790899, 0.23779561, 0.23768233, 0.23756906, 0.23745589, 0.23734279, 0.23722973, 0.23711675, 0.23700385, 0.236891, 0.23677821, 0.23666549, 0.23655283, 0.23644026, 0.23632772, 0.23621523, 0.23610285, 0.23599052, 0.23587827, 0.23576607, 0.23565392, 0.23554187, 0.23542987, 0.23531792, 0.23520604, 0.23509423, 0.23498251, 0.23487081, 0.2347592, 0.23464766, 0.23453616, 0.23442475, 0.2343134, 0.23420212, 0.23409088, 0.23397972, 0.23386863, 0.2337576, 0.23364665, 0.23353575, 0.23342492, 0.23331413, 0.23320343, 0.2330928, 0.23298222, 0.23287173, 0.23276128, 0.23265091, 0.23254059, 0.23243034, 0.23232016, 0.23221004, 0.23209998, 0.23198999, 0.23188007, 0.2317702, 0.23166043, 0.23155069, 0.23144104, 0.23133144, 0.23122191, 0.23111245, 0.23100303, 0.2308937, 0.23078443, 0.23067522, 0.2305661, 0.23045699, 0.23034799, 0.23023905, 0.23013015, 0.23002136, 0.22991259, 0.2298039, 0.22969531, 0.22958674, 0.22947825, 0.22936982, 0.22926144, 0.22915317, 0.22904485, 0.22893912, 0.2288335, 0.22872798, 0.22862253, 0.22851717, 0.22841194, 0.22830677, 0.22820169, 0.22809672, 0.22799185, 0.22788708, 0.22778238, 0.22767776, 0.22757328, 0.22746886, 0.22736457, 0.22726034, 0.22715621, 0.22705217, 0.22694823, 0.22684439, 0.22674064, 0.22663698, 0.22653341, 0.22642995, 0.22632657, 0.22622328, 0.2261201, 0.226017, 0.22591399, 0.22581108, 0.22570825, 0.22560555, 0.22550292, 0.22540037, 0.22529796, 0.2251956, 0.22509335, 0.22499119, 0.22488913, 0.22478713, 0.22468527, 0.22458349, 0.22448181, 0.22438018, 0.22427869, 0.22417727, 0.22407597, 0.22397475, 0.22387363, 0.22377257, 0.22367164, 0.22357081, 0.22347005, 0.2233694, 0.22326884, 0.22316836, 0.22306797, 0.22296768, 0.2228675, 0.22276741, 0.2226674, 0.22256748, 0.22246768, 0.22236797, 0.22226833, 0.22216879, 0.22206937, 0.22197001, 0.22187077, 0.2217716, 0.22167252, 0.22157355, 0.22147468, 0.22137588, 0.22127721, 0.22117861, 0.22108009, 0.22098172, 0.22088337, 0.22078517, 0.22068703, 0.220589, 0.22049105, 0.22039321, 0.22029547, 0.2201978, 0.22010022, 0.22000276, 0.21990539, 0.2198081, 0.21971092, 0.21961381, 0.2195168, 0.21941988, 0.21932308, 0.21922636, 0.21912974, 0.2190332, 0.21893965, 0.21884483, 0.21875007, 0.21865535, 0.21856068, 0.21846604, 0.21837145, 0.2182769, 0.21818238, 0.21808793, 0.2179935, 0.2178991, 0.21780476, 0.21771049, 0.21761622, 0.21752201, 0.21742782, 0.2173337, 0.2172396, 0.21714555, 0.21705157, 0.21695758, 0.21686368, 0.2167698, 0.21667597, 0.21658218, 0.21648842, 0.21639472, 0.21630104, 0.21620744, 0.21611384, 0.21602032, 0.21592683, 0.21583337, 0.21573995, 0.21564656, 0.21555324, 0.21545996, 0.21536672, 0.21527353, 0.21518037, 0.21508725, 0.21499416, 0.21490115, 0.21480814, 0.2147152, 0.21462229, 0.21452942, 0.21443661, 0.21434383, 0.21425109, 0.2141584, 0.21406575, 0.21397313, 0.21388057, 0.21378805, 0.21369556, 0.21360312, 0.21351071, 0.21341835, 0.21332604, 0.21323377, 0.21314155, 0.21304935, 0.21295723, 0.2128651, 0.21277304, 0.21268103, 0.21258906, 0.21249712, 0.21240522, 0.21231337, 0.21222156, 0.21212979, 0.21203808, 0.21194641, 0.21185476, 0.21176314, 0.21167161, 0.2115801, 0.2114886, 0.2113972, 0.2113058, 0.21121447, 0.21112317, 0.2110319, 0.21094067, 0.21084951, 0.21075839, 0.2106673, 0.21057624, 0.21048523, 0.21039428, 0.21030335, 0.21021245, 0.21012163, 0.21003082, 0.20994008, 0.20984939, 0.20975868, 0.20966795, 0.20957722, 0.20948645, 0.2093956, 0.20930476, 0.20921385, 0.2091229, 0.20903192, 0.20894089, 0.20884983, 0.20875876, 0.20866762, 0.20857644, 0.2084852, 0.20839395, 0.20830265, 0.2082113, 0.20811996, 0.20802853, 0.20793705, 0.20784557, 0.20775403, 0.20766246, 0.20757084, 0.20747919, 0.20738748, 0.20729576, 0.20720398, 0.20711219, 0.20702031, 0.20692845, 0.20683649, 0.20674452, 0.20665251, 0.20656048, 0.20646839, 0.20637625, 0.20628409, 0.20619185, 0.2060996, 0.20600733, 0.20591502, 0.20582265, 0.20573024, 0.20563778, 0.20554531, 0.20545278, 0.20536022, 0.20526761, 0.20517498, 0.20508228, 0.20498957, 0.20489681, 0.20480402, 0.20471117, 0.20461829, 0.20452535, 0.20443241, 0.2043394, 0.20424639, 0.2041533, 0.20406017, 0.20396701, 0.20387381, 0.20378058, 0.2036873, 0.20359397, 0.20350063, 0.20340724, 0.2033138, 0.20322034, 0.20312682, 0.20303327, 0.20293964, 0.20284605, 0.20275237, 0.20265865, 0.20256491, 0.20247112, 0.20237729, 0.20228341, 0.20218952, 0.20209557, 0.20200157, 0.20190755, 0.20181349, 0.20171937, 0.20162523, 0.20153104, 0.2014368, 0.20134254, 0.20124824, 0.20115389, 0.20105952, 0.20096509, 0.20087065, 0.20077612, 0.2006816, 0.200587, 0.2004924, 0.200398, 0.20030221, 0.20020629, 0.2001103, 0.20001422, 0.199918, 0.19982171, 0.19972533, 0.1996288, 0.19953224, 0.19943552, 0.19933875, 0.19924183, 0.19914486, 0.19904776, 0.19895059, 0.19885331, 0.19875592, 0.19865842, 0.19856085, 0.19846317, 0.19836538, 0.1982675, 0.19816953, 0.19807146, 0.19797328, 0.19787501, 0.19777663, 0.19767816, 0.19757961, 0.19748093, 0.19738215, 0.19728328, 0.19718432, 0.19708526, 0.19698611, 0.19688685, 0.19678748, 0.19668803, 0.19658846, 0.1964888, 0.19638905, 0.1962892, 0.19618924, 0.19608918, 0.19598904, 0.19588879, 0.19578843, 0.19568798, 0.19558744, 0.1954868, 0.19538607, 0.19528522, 0.19518426, 0.19508323, 0.1949821, 0.19488084, 0.19477953, 0.19467808, 0.19457656, 0.19447492, 0.19437319, 0.19427136, 0.19416943, 0.1940674, 0.19396527, 0.19386303, 0.19376072, 0.19365829, 0.19355576, 0.19345315, 0.19335042, 0.19324763, 0.19314468, 0.19304167, 0.19293858, 0.19283535, 0.19273204, 0.19262861, 0.19252512, 0.19242151, 0.1923178, 0.19221398, 0.19211009, 0.1920061, 0.19190198, 0.19179779, 0.19169347, 0.19158907, 0.19148459, 0.19137998, 0.19127527, 0.19117047, 0.19106561, 0.19096059, 0.19085549, 0.1907503, 0.19064502, 0.19053963, 0.19043416, 0.19032978, 0.19022331, 0.1901167, 0.19001003, 0.18990318, 0.18979624, 0.18968913, 0.18958196, 0.18947463, 0.18936718, 0.18925963, 0.18915196, 0.18904413, 0.1889362, 0.18882816, 0.18871999, 0.18861167, 0.18850325, 0.18839473, 0.18828607, 0.18817727, 0.18806835, 0.18795934, 0.18785018, 0.18774091, 0.1876315, 0.18752201, 0.18741235, 0.18730262, 0.18719272, 0.18708272, 0.18697257, 0.18686235, 0.18675196, 0.18664148, 0.18653087, 0.18642013, 0.18630928, 0.18619828, 0.18608718, 0.18597597, 0.18586463, 0.18575315, 0.18564157, 0.18552983, 0.18541801, 0.18530604, 0.18519397, 0.18508177, 0.18496944, 0.18485701, 0.18474445, 0.18463176, 0.18451895, 0.184406, 0.18429296, 0.18417977, 0.18406649, 0.18395308, 0.18383953, 0.18372585, 0.18361208, 0.18349816, 0.18338414, 0.18326996, 0.18315572, 0.1830413, 0.1829268, 0.18281215, 0.18269737, 0.18258248, 0.18246748, 0.18235236, 0.1822371, 0.18212175, 0.18200624, 0.18189061, 0.18177488, 0.18165904, 0.18154305, 0.18142693, 0.18131071, 0.18119437, 0.18107788, 0.1809613, 0.18084458, 0.18072775, 0.18061076, 0.18049371, 0.18037648, 0.1802592, 0.18014173, 0.18002419, 0.17990647, 0.17978868, 0.17967072, 0.17955264, 0.17943448, 0.17931621, 0.17919777, 0.17907578, 0.17895688, 0.17883782, 0.17871866, 0.17859936, 0.17847995, 0.1783604, 0.17824073, 0.17812094, 0.17800103, 0.17788099, 0.17776081, 0.17764051, 0.17752011, 0.17739953, 0.17727891, 0.1771581, 0.17703719, 0.17691612, 0.17679498, 0.17667368, 0.17655225, 0.1764307, 0.17630902, 0.17618725, 0.17606533, 0.17594326, 0.1758211, 0.17569883, 0.17557639, 0.17545384, 0.17533118, 0.17520837, 0.17508546, 0.17496242, 0.17483924, 0.17471597, 0.17459251, 0.17446899, 0.17434531, 0.17422152, 0.17409761, 0.17397356, 0.17384936, 0.17372508, 0.17360066, 0.17347611, 0.17335145, 0.17322662, 0.17310171, 0.17297666, 0.17285149, 0.17272618, 0.17260076, 0.1724752, 0.17234953, 0.17222372, 0.17209782, 0.17197178, 0.1718456, 0.1717193, 0.17159289, 0.17146634, 0.17133968, 0.17121287, 0.17108594, 0.17095888, 0.17083171, 0.17070442, 0.170577, 0.17044942, 0.17032176, 0.17019396, 0.17006601, 0.16993797, 0.1698098, 0.16968152, 0.16955309, 0.16942453, 0.16929585, 0.16916706, 0.16903813, 0.16890906, 0.16877989, 0.1686506, 0.16852117, 0.16839163, 0.16826195, 0.16813216, 0.16800222, 0.16787218, 0.16774197, 0.1676117, 0.16748126, 0.16735072, 0.16722001, 0.16708924, 0.16695829, 0.16682726, 0.16669607, 0.16656569, 0.16643417, 0.1663025, 0.16617075, 0.16603884, 0.16590685, 0.16577466, 0.16564243, 0.16551001, 0.16537753, 0.16524491, 0.16511215, 0.16497929, 0.1648463, 0.16471319, 0.16457996, 0.16444662, 0.16431317, 0.16417955, 0.16404583, 0.16391198, 0.16377802, 0.16364394, 0.16350979, 0.16337542, 0.163241, 0.16310643, 0.16297175, 0.16283694, 0.16270201, 0.16256696, 0.16243179, 0.1622965, 0.16216108, 0.16202557, 0.16188991, 0.16175415, 0.16161825, 0.16148224, 0.16134611, 0.16120984, 0.16107348, 0.16093695, 0.16080032, 0.1606636, 0.16052672, 0.16038974, 0.16025265, 0.16011544, 0.15997808, 0.15984063, 0.15970302, 0.1595653, 0.15942748, 0.15928949, 0.15915143, 0.15901324, 0.15887493, 0.1587365, 0.15859793, 0.15845925, 0.15832046, 0.15818153, 0.15804249, 0.15790333, 0.15776405, 0.15762465, 0.15748511, 0.15734547, 0.15720572, 0.15706581, 0.15692578, 0.15678567, 0.1566454, 0.15650503, 0.15636455, 0.15622392, 0.1560832, 0.15594232, 0.15580133, 0.15566024, 0.15551902, 0.15537767, 0.15523618, 0.15509464, 0.15495293, 0.1548111, 0.15466914, 0.15452707, 0.15438488, 0.15424258, 0.15410012, 0.15395759, 0.15381491, 0.15367211, 0.1535292, 0.15338616, 0.15324301, 0.15309973, 0.15295632, 0.1528179, 0.15267371, 0.15252942, 0.152385, 0.1522405, 0.15209591, 0.15195118, 0.15180638, 0.15166146, 0.15151645, 0.15137132, 0.1512261, 0.15108077, 0.15093535, 0.1507898, 0.15064415, 0.15049842, 0.15035258, 0.15020663, 0.15006056, 0.14991441, 0.14976816, 0.14962178, 0.14947532, 0.14932874, 0.14918208, 0.14903529, 0.14888841, 0.14874142, 0.14859435, 0.14844716, 0.14829984, 0.14815244, 0.14800493, 0.14785735, 0.14770964, 0.14756183, 0.14741391, 0.1472659, 0.14711776, 0.14696956, 0.14682122, 0.14667279, 0.14652424, 0.14637561, 0.14622687, 0.14607804, 0.14592908, 0.14578003, 0.14563087, 0.14548162, 0.14533223, 0.14518279, 0.14503321, 0.14488354, 0.14473376, 0.14458387, 0.14443389, 0.1442838, 0.1441336, 0.14398332, 0.14383294, 0.14368242, 0.14353183, 0.1433811, 0.1432303, 0.14307937, 0.14292836, 0.14277725, 0.14262602, 0.14247468, 0.14232327, 0.14217173, 0.14202009, 0.14186835, 0.14171651, 0.14156456, 0.14141251, 0.14126034, 0.1411081, 0.14095575, 0.14080328, 0.14065067, 0.14049801, 0.14034523, 0.14019234, 0.14003937, 0.13988629, 0.13973311, 0.13957979, 0.13942643, 0.13927291, 0.13911933, 0.13896561, 0.1388118, 0.13865787, 0.13850385, 0.13834974, 0.13819553, 0.13804118, 0.13788009, 0.13772422, 0.13756832, 0.1374124, 0.13725638, 0.13710034, 0.13694426, 0.13678811, 0.13663192, 0.13647571, 0.13631943, 0.13616312, 0.13600673, 0.13585033, 0.13569386, 0.13553734, 0.13538079, 0.13522419, 0.13506754, 0.13491085, 0.13475409, 0.13459729, 0.13444047, 0.13428359, 0.13412662, 0.13396966, 0.13381262, 0.13365556, 0.13349843, 0.1333413, 0.13318406, 0.13302681, 0.13286948, 0.13271216, 0.13255474, 0.13239726, 0.13223979, 0.13208224, 0.13192466, 0.13176702, 0.13160932, 0.13145161, 0.13129382, 0.13113599, 0.13097814, 0.1308202, 0.13066226, 0.13050424, 0.13034616, 0.13018806, 0.13002993, 0.12987171, 0.12971349, 0.12955518, 0.12939686, 0.12923844, 0.12908003, 0.12892154, 0.12876301, 0.12860443, 0.1284458, 0.12828712, 0.12812839, 0.12796965, 0.12781084, 0.12765199, 0.12749307, 0.12733413, 0.12717512, 0.1270161, 0.12685698, 0.12669785, 0.12653868, 0.12637945, 0.12622017, 0.12606084, 0.12590146, 0.12574205, 0.12558256, 0.12542306, 0.1252635, 0.12510389, 0.12494424, 0.12478455, 0.12462477, 0.124465, 0.12430515, 0.12414525, 0.12398532, 0.12382531, 0.12366531, 0.12350521, 0.12334511, 0.12318493, 0.12302472, 0.12286446, 0.12270414, 0.12254376, 0.12238338, 0.1222229, 0.12205923, 0.12189747, 0.1217358, 0.12157417, 0.12141265, 0.12125114, 0.12108968, 0.12092832, 0.12076706, 0.1206058, 0.12044462, 0.1202835, 0.12012246, 0.11996147, 0.11980054, 0.11963969, 0.11947887, 0.11931815, 0.11915745, 0.11899687, 0.11883631, 0.11867587, 0.11851542, 0.1183551, 0.11819477, 0.11803455, 0.11787439, 0.11771429, 0.11755427, 0.11739427, 0.11723436, 0.11707452, 0.11691474, 0.11675502, 0.11659533, 0.11643574, 0.11627622, 0.11611677, 0.11595733, 0.11579796, 0.11563873, 0.11547948, 0.11532031, 0.1151612, 0.11500221, 0.11484322, 0.11468433, 0.11452549, 0.11436676, 0.11420803, 0.11404935, 0.11389079, 0.11373226, 0.11357375, 0.11341538, 0.11325705, 0.1130988, 0.11294057, 0.11278243, 0.11262435, 0.11246634, 0.11230838, 0.11215048, 0.11199267, 0.11183488, 0.11167718, 0.11151953, 0.11136197, 0.11120445, 0.11104698, 0.1108896, 0.11073229, 0.11057503, 0.11041781, 0.11026068, 0.11010364, 0.10994662, 0.10978964, 0.10963278, 0.10947598, 0.1093192, 0.10916252, 0.10900588, 0.10884935, 0.10869282, 0.10853639, 0.10838, 0.1082237, 0.10806744, 0.10791122, 0.10775508, 0.10759905, 0.10744306, 0.1072871, 0.10713124, 0.10697544, 0.1068197, 0.10666401, 0.1065084, 0.10635283, 0.10620401, 0.10604883, 0.10589376, 0.10573901, 0.10558444, 0.10543008, 0.10527591, 0.10512192, 0.10496815, 0.10481448, 0.10466114, 0.10450794, 0.1043549, 0.10420207, 0.10404946, 0.10389709, 0.10374484, 0.10359281, 0.10344096, 0.10328936, 0.10313793, 0.10298666, 0.10283564, 0.10268483, 0.10253418, 0.10238376, 0.10223345, 0.10208338, 0.10193355, 0.10178389, 0.10163444, 0.10148516, 0.10133608, 0.10118724, 0.10103854, 0.10089003, 0.10074176, 0.10059371, 0.10044583, 0.10029812, 0.10015059, 0.10000334, 0.099856243, 0.099709317, 0.099562608, 0.099416085, 0.099269792, 0.099123701, 0.098977819, 0.098832063, 0.098686509, 0.098541178, 0.098396093, 0.098251164, 0.098106414, 0.09796185, 0.097817518, 0.097673386, 0.097529396, 0.09738566, 0.097242132, 0.09709879, 0.096955627, 0.096812613, 0.09666986, 0.096527308, 0.096384935, 0.096242763, 0.096100733, 0.095958978, 0.09581738, 0.095676064, 0.095534824, 0.095393807, 0.095252976, 0.095112443, 0.094972044, 0.094831824, 0.094691806, 0.094552018, 0.094412401, 0.094272941, 0.094133697, 0.093994729, 0.093855895, 0.093717322, 0.093578801, 0.093440607, 0.093302526, 0.093164712, 0.093027093, 0.092889592, 0.092752375, 0.092615336, 0.092478476, 0.092341803, 0.092205316, 0.092069067, 0.091932975, 0.091797128, 0.091656156, 0.09152247, 0.091389157, 0.09125609, 0.091123275, 0.09099073, 0.090858623, 0.090726689, 0.090595119, 0.090463743, 0.090332761, 0.090202019, 0.090071589, 0.089941494, 0.089811653, 0.089682043, 0.089552835, 0.089423865, 0.089295156, 0.089166798, 0.089038722, 0.088910922, 0.088783458, 0.088656202, 0.088529296, 0.088402748, 0.088276394, 0.088150427, 0.088024646, 0.087899163, 0.087774053, 0.087649286, 0.087524697, 0.087400414, 0.087276444, 0.087152794, 0.087029442, 0.086906262, 0.086783506, 0.086661085, 0.086538829, 0.08641693, 0.086295344, 0.086173996, 0.086053021, 0.085932322, 0.085811771, 0.085691683, 0.085571855, 0.085452266, 0.085333042, 0.085214078, 0.085095361, 0.084977008, 0.084858872, 0.084741145, 0.084623657, 0.084506378, 0.084389508, 0.084272936, 0.084156543, 0.08404053, 0.083924837, 0.083809368, 0.083694264, 0.083579317, 0.083464786, 0.083350614, 0.08323662, 0.083122917, 0.083009556, 0.082896404, 0.082783654, 0.082671225, 0.08255896, 0.082447074, 0.082335457, 0.082224116, 0.082113117, 0.082002327, 0.081891909, 0.08178179, 0.081671916, 0.081562318, 0.081453092, 0.081344083, 0.081235431, 0.081127092, 0.08101894, 0.080911174, 0.080803692, 0.080696478, 0.080589578, 0.080482893, 0.080376603, 0.080270618, 0.080164813, 0.080059372, 0.079954252, 0.079849325, 0.079746835, 0.079644911, 0.079543315, 0.079442009, 0.079341106, 0.079240344, 0.079140052, 0.079039969, 0.078940257, 0.078840822, 0.078741692, 0.07864286, 0.07854443, 0.078446195, 0.078348368, 0.078250736, 0.078153506, 0.078056552, 0.077959947, 0.077863544, 0.077767625, 0.077671774, 0.077576466, 0.077481337, 0.077386558, 0.077292077, 0.077197962, 0.077104054, 0.077010587, 0.076917328, 0.076824374, 0.076731794, 0.07663954, 0.076547451, 0.076455817, 0.076364361, 0.076273397, 0.076182619, 0.076092146, 0.076002009, 0.075912274, 0.075822659, 0.075733498, 0.07564459, 0.07555601, 0.075467713, 0.075379774, 0.075292088, 0.07520476, 0.075117692, 0.075030982, 0.074944548, 0.074858449, 0.074772656, 0.074687198, 0.074601926, 0.074517116, 0.074432611, 0.074348316, 0.074264333, 0.074180797, 0.074097395, 0.074014448, 0.073931716, 0.073849328, 0.07376726, 0.073685475, 0.073604003, 0.073522888, 0.07344202, 0.073361531, 0.073281273, 0.073201351, 0.073121749, 0.073042497, 0.072963469, 0.072884843, 0.072806448, 0.072728395, 0.072650626, 0.072573185, 0.072496086, 0.072419286, 0.072342739, 0.072266579, 0.072190702, 0.072115093, 0.072039835, 0.071964867, 0.071890213, 0.07181593, 0.071741819, 0.071668118, 0.071594745, 0.071521655, 0.071448863, 0.071376413, 0.07130418, 0.071232371, 0.071160838, 0.071093954, 0.071024798, 0.070955992, 0.070887394, 0.070819013, 0.07075084, 0.07068295, 0.070615336, 0.070547871, 0.070480712, 0.070413701, 0.070347093, 0.070280582, 0.070214428, 0.070148401, 0.070082687, 0.070017144, 0.069951974, 0.069886893, 0.069822185, 0.069757633, 0.069693349, 0.069629274, 0.069565482, 0.069501869, 0.069438636, 0.069375515, 0.06931264, 0.06925004, 0.069187716, 0.069125511, 0.069063708, 0.069001988, 0.068940647, 0.068879493, 0.068818606, 0.068757862, 0.068697505, 0.068637259, 0.06857729, 0.068517536, 0.068458147, 0.068398818, 0.068339951, 0.068281092, 0.06822262, 0.068164364, 0.068106353, 0.068048462, 0.067991033, 0.067933701, 0.067876667, 0.067819789, 0.067763209, 0.067706794, 0.067650773, 0.067594871, 0.067539312, 0.067483902, 0.067428768, 0.067373849, 0.067319237, 0.067264743, 0.067210644, 0.06715671, 0.067102946, 0.067049466, 0.066996351, 0.066943333, 0.066890612, 0.066838138, 0.066785842, 0.066733807, 0.0666821, 0.066630542, 0.06657926, 0.066528231, 0.066477373, 0.066426836, 0.066376567, 0.066326447, 0.066276602, 0.066226944, 0.066177629, 0.066128522, 0.066079654, 0.066030949, 0.06598261, 0.065934449, 0.065886535, 0.065838836, 0.065791413, 0.065744169, 0.065697268, 0.065650545, 0.065604076, 0.065557875, 0.06551192, 0.065466084, 0.06542059, 0.065374322, 0.065329775, 0.065285414, 0.065241061, 0.065196864, 0.065152779, 0.065108873, 0.065065026, 0.065021396, 0.06497775, 0.064934321, 0.064891025, 0.06484779, 0.064804688, 0.064761758, 0.064718954, 0.06467618, 0.064633623, 0.06459108, 0.064548746, 0.064506494, 0.064464413, 0.064422444, 0.064380534, 0.064338826, 0.064297155, 0.064255714, 0.064214326, 0.064173028, 0.06413193, 0.064090878, 0.064050026, 0.064009212, 0.063968614, 0.063928105, 0.063887686, 0.063847423, 0.063807219, 0.063767195, 0.063727237, 0.063687481, 0.063647844, 0.063608266, 0.063568853, 0.063529536, 0.063490391, 0.06345129, 0.063412368, 0.063373573, 0.063334815, 0.063296288, 0.063257813, 0.063219495, 0.063181341, 0.063143216, 0.063105278, 0.063067384, 0.063029706, 0.062992074, 0.062954605, 0.062917277, 0.062880009, 0.06284295, 0.062805928, 0.062769055, 0.062732339, 0.062695689, 0.062659219, 0.062622808, 0.062586568, 0.062550411, 0.062514432, 0.062478516, 0.06244278, 0.062407147, 0.062371567, 0.062336177, 0.062300902, 0.062265765, 0.062230743, 0.062195834, 0.062161051, 0.062126353, 0.062091824, 0.062057391, 0.062023092, 0.061988913, 0.06195483, 0.061920915, 0.061887059, 0.061853401, 0.061819792, 0.061786368, 0.061753094, 0.06171982, 0.061686747, 0.061653763, 0.061620932, 0.061588287, 0.061555639, 0.061526094, 0.061492849, 0.061459638, 0.061426427, 0.061393213, 0.061359998, 0.06132682, 0.061293613, 0.061260428, 0.061227247, 0.061194092, 0.061160915, 0.06112776, 0.061094604, 0.061061449, 0.061028339, 0.060995184, 0.060962066, 0.060928963, 0.060895827, 0.060862716, 0.060829636, 0.06079654, 0.060763452, 0.060730372, 0.060697302, 0.060664233, 0.060631182, 0.060598142, 0.060565088, 0.060532033, 0.060499016, 0.060465988, 0.060432963, 0.060399946, 0.06036694, 0.060333945, 0.060300946, 0.060267955, 0.060234971, 0.060202003, 0.06016903, 0.060136061, 0.060103096, 0.060070172, 0.060037237, 0.060004283, 0.05997134, 0.059938442, 0.05990551, 0.059872597, 0.059839681, 0.059806805, 0.059773903, 0.059741024, 0.059708148, 0.059675291, 0.059642419, 0.059609558, 0.059576705, 0.059543863, 0.059511025, 0.059478186, 0.059445381, 0.059412546, 0.059379734, 0.059346944, 0.059314147, 0.059281338, 0.05924857, 0.059215799, 0.059183005, 0.059150252, 0.059117511, 0.05908474, 0.059051979, 0.059019253, 0.058986537, 0.05895381, 0.058921069, 0.058888353, 0.058855657, 0.058822963, 0.058790255, 0.058757562, 0.058724876, 0.058692224, 0.058659546, 0.058626868, 0.058594223, 0.058561578, 0.058528934, 0.058496296, 0.058463674, 0.058431052, 0.058398437, 0.058365826, 0.058333218, 0.05830064, 0.058268033, 0.058236439, 0.058202419, 0.058168363, 0.058134221, 0.0581, 0.058065724, 0.05803141, 0.057997011, 0.057962522, 0.05792797, 0.057893403, 0.057858717, 0.057823975, 0.057789158, 0.057754293, 0.057719357, 0.057684351, 0.057649277, 0.057614129, 0.057578966, 0.057543691, 0.057508338, 0.057472933, 0.057437494, 0.057401951, 0.057366345, 0.057330653, 0.05729495, 0.057259116, 0.057223268, 0.057187341, 0.057151318, 0.057115283, 0.057079125, 0.057042919, 0.057006679, 0.056970328, 0.056933947, 0.056897491, 0.056860942, 0.056824371, 0.056787666, 0.056750942, 0.056714144, 0.056677274, 0.056640368, 0.056603335, 0.056566287, 0.056529164, 0.056491967, 0.056454714, 0.05641738, 0.056379978, 0.056342535, 0.056304988, 0.056267388, 0.056229748, 0.056192011, 0.056154221, 0.056116331, 0.05607843, 0.056040429, 0.056002364, 0.055964254, 0.055926077, 0.0558878, 0.055849496, 0.055811081, 0.055772629, 0.055734102, 0.055695504, 0.055656839, 0.055618141, 0.055579334, 0.055540491, 0.055501543, 0.05546255, 0.055423521, 0.055384368, 0.0553452, 0.055305921, 0.055266619, 0.055227242, 0.055187769, 0.055148251, 0.055108678, 0.055069007, 0.055029299, 0.054989498, 0.054949656, 0.054909743, 0.05486973, 0.054829706, 0.054789551, 0.054749381, 0.054709133, 0.054668818, 0.054628436, 0.054587997, 0.054547448, 0.054499023, 0.054456949, 0.054414835, 0.054372642, 0.054330327, 0.05428797, 0.054245532, 0.054202989, 0.054160338, 0.054117639, 0.054074846, 0.054031972, 0.053988971, 0.053945933, 0.053902823, 0.053859573, 0.053816266, 0.05377287, 0.053729407, 0.053685851, 0.053642172, 0.053598467, 0.053554624, 0.053510729, 0.053466734, 0.053422648, 0.053378511, 0.053334299, 0.053289924, 0.053245522, 0.053201012, 0.053156458, 0.053111773, 0.05306701, 0.053022187, 0.05297726, 0.052932255, 0.052887153, 0.052841961, 0.052796725, 0.052751396, 0.052705914, 0.052660417, 0.052614816, 0.052569117, 0.052523348, 0.052477498, 0.052431542, 0.052385524, 0.052339405, 0.0522932, 0.052246924, 0.052200556, 0.052154109, 0.052107532, 0.052060928, 0.052014224, 0.051967446, 0.051920556, 0.051873576, 0.051826548, 0.05177943, 0.051732175, 0.051684868, 0.051637493, 0.051590007, 0.051542483, 0.051494807, 0.051447112, 0.051399257, 0.051351372, 0.051303387, 0.051255301, 0.051207192, 0.051158924, 0.051110599, 0.051062193, 0.051013716, 0.050965127, 0.050916478, 0.050867692, 0.050818894, 0.05076997, 0.050720934, 0.050671864, 0.050622664, 0.050573435, 0.050524078, 0.05047464, 0.050425135, 0.05037554, 0.050325848, 0.050276082, 0.050226212, 0.050176293, 0.050126284, 0.050076157, 0.050025962, 0.049975678, 0.049925327, 0.049876951, 0.049825612, 0.049774215, 0.049722761, 0.049671222, 0.049619634, 0.049567997, 0.049516298, 0.049464513, 0.049412705, 0.04936083, 0.049308866, 0.04925688, 0.049204823, 0.049152717, 0.049100503, 0.049048275, 0.048995964, 0.048943631, 0.048891194, 0.048838712, 0.048786175, 0.048733581, 0.048680905, 0.048628196, 0.048575431, 0.048522566, 0.048469689, 0.048416737, 0.048363719, 0.04831063, 0.048257522, 0.048204307, 0.048151065, 0.048097741, 0.04804438, 0.047990948, 0.047937438, 0.047883898, 0.047830284, 0.047776621, 0.047722869, 0.047669087, 0.047615245, 0.047561344, 0.047507357, 0.047453333, 0.047399253, 0.047345091, 0.047290888, 0.047236595, 0.047182288, 0.047127899, 0.047073469, 0.047018934, 0.046964385, 0.046909761, 0.046855088, 0.046800334, 0.046745505, 0.046690669, 0.046635732, 0.04658075, 0.046525702, 0.046470612, 0.046415448, 0.046360224, 0.046304949, 0.046249632, 0.046194188, 0.046138756, 0.046083219, 0.046027619, 0.045972001, 0.045916293, 0.045860533, 0.045804717, 0.045748863, 0.045692902, 0.045636926, 0.045580845, 0.04552475, 0.045468554, 0.045412309, 0.045356028, 0.045299686, 0.045243286, 0.04518678, 0.04513026, 0.045073662, 0.045017015, 0.044960298, 0.044903535, 0.04484671, 0.044789817, 0.044732865, 0.044675823, 0.044618785, 0.044561636, 0.044504452, 0.044449911, 0.044392683, 0.044335429, 0.044278175, 0.044220876, 0.044163574, 0.044106271, 0.044048928, 0.043991551, 0.043934185, 0.043876804, 0.043819387, 0.043761935, 0.043704495, 0.043647047, 0.043589555, 0.043532044, 0.043474521, 0.043416996, 0.043359432, 0.043301858, 0.043244258, 0.043186657, 0.043129016, 0.043071374, 0.043013699, 0.042956024, 0.042898323, 0.042840581, 0.042782839, 0.042725075, 0.042667318, 0.042609513, 0.042551711, 0.042493876, 0.042436045, 0.042378165, 0.042320266, 0.04226236, 0.042204455, 0.042146511, 0.042088553, 0.042030565, 0.041972585, 0.041914567, 0.041856539, 0.041798476, 0.041740432, 0.041682325, 0.041624233, 0.041566093, 0.041507963, 0.041449826, 0.041391633, 0.041333433, 0.041275211, 0.041217007, 0.041158743, 0.041100461, 0.041042183, 0.040983889, 0.040925559, 0.040867221, 0.040808864, 0.040750496, 0.040692095, 0.040633678, 0.04057524, 0.040516805, 0.040458329, 0.040399842, 0.040341325, 0.040282827, 0.040224269, 0.040165711, 0.040107131, 0.040048551, 0.039989937, 0.039931297, 0.039872646, 0.039813962, 0.0397553, 0.039696589, 0.039637856, 0.039579112, 0.039520368, 0.039461583, 0.039402787, 0.039343972, 0.039285153, 0.039226286, 0.039167427, 0.039108533, 0.039049644, 0.038990706, 0.038931772, 0.038872797, 0.038813829, 0.038754828, 0.038695827, 0.038630888, 0.03857227, 0.038513638, 0.038455047, 0.038396455, 0.038337901, 0.03827934, 0.038220778, 0.038162246, 0.038103741, 0.038045231, 0.037986755, 0.037928279, 0.037869815, 0.037811395, 0.037752971, 0.037694551, 0.037636146, 0.037577767, 0.037519407, 0.037461042, 0.037402697, 0.037344396, 0.037286077, 0.037227795, 0.037169501, 0.037111245, 0.037052996, 0.036994755, 0.036936533, 0.036878347, 0.036820143, 0.036761973, 0.036703803, 0.036645647, 0.036587529, 0.036529403, 0.036471296, 0.036413223, 0.036355134, 0.036297102, 0.036239039, 0.036181003, 0.036123008, 0.036065008, 0.036007013, 0.03594904, 0.035891097, 0.035833161, 0.035775229, 0.035717312, 0.03565944, 0.035601553, 0.035543673, 0.035485826, 0.035427984, 0.035370182, 0.035312355, 0.035254564, 0.035196777, 0.035139028, 0.035081286, 0.035023544, 0.034965813, 0.034908123, 0.034850445, 0.03479274, 0.034735091, 0.034677453, 0.034619804, 0.034562197, 0.034504592, 0.034447026, 0.034389459, 0.034331884, 0.034274332, 0.034216821, 0.034159295, 0.034101807, 0.034044318, 0.033986866, 0.0339294, 0.033871952, 0.033814527, 0.033757128, 0.033699736, 0.033642355, 0.033584986, 0.033527624, 0.03347031, 0.033412989, 0.033355679, 0.033298373, 0.033241108, 0.033183847, 0.033126593, 0.033069346, 0.033012148, 0.032954942, 0.032897763, 0.032849964, 0.032793026, 0.032736164, 0.032679316, 0.032622512, 0.032565739, 0.032508969, 0.032452293, 0.032395612, 0.032339007, 0.032282405, 0.032225862, 0.032169305, 0.032112855, 0.032056373, 0.031999957, 0.031943597, 0.031887226, 0.031830925, 0.031774662, 0.031718407, 0.031662203, 0.031606074, 0.031549901, 0.03149385, 0.031437751, 0.031381745, 0.031325754, 0.031269759, 0.031213863, 0.03115798, 0.031102141, 0.031046333, 0.030990541, 0.030934826, 0.030879078, 0.030823424, 0.030767784, 0.030712191, 0.030656628, 0.030601112, 0.030545579, 0.030490139, 0.030434728, 0.030379349, 0.030323986, 0.030268654, 0.030213412, 0.030158142, 0.030102944, 0.030047748, 0.029992644, 0.029937509, 0.029882466, 0.029827425, 0.029772429, 0.029717494, 0.029662542, 0.029607652, 0.029552808, 0.029497998, 0.029443197, 0.029388461, 0.029333724, 0.029279049, 0.029224435, 0.029169789, 0.029115235, 0.029060697, 0.029006239, 0.02895176, 0.0288973, 0.028842947, 0.028788591, 0.028734254, 0.028679991, 0.028625729, 0.028571496, 0.028517324, 0.028463155, 0.028409077, 0.028354984, 0.02830098, 0.028246947, 0.028192991, 0.028139077, 0.028085154, 0.02803129, 0.027977472, 0.027923713, 0.027869942, 0.027816242, 0.027762532, 0.027708927, 0.027655277, 0.027601685, 0.027548192, 0.027494662, 0.027441211, 0.027387761, 0.027330238, 0.027276985, 0.027223809, 0.027170617, 0.02711755, 0.027064512, 0.027011504, 0.02695854, 0.026905639, 0.026852831, 0.026799992, 0.026747242, 0.026694542, 0.0266419, 0.026589306, 0.026536725, 0.026484221, 0.026431767, 0.026379399, 0.02632702, 0.026274731, 0.026222473, 0.026170291, 0.026118107, 0.02606602, 0.026013941, 0.025961947, 0.025910024, 0.025858115, 0.025806256, 0.025754455, 0.025702719, 0.02565098, 0.025599334, 0.025547734, 0.025496148, 0.02544467, 0.025393207, 0.025341807, 0.02529045, 0.025239173, 0.025187859, 0.025136704, 0.025085548, 0.02503445, 0.024983356, 0.024932368, 0.024881439, 0.024830496, 0.024779661, 0.02472884, 0.024678096, 0.024627384, 0.024576748, 0.024526095, 0.02447555, 0.024425065, 0.024374569, 0.024324192, 0.024273846, 0.024223516, 0.024173243, 0.024123067, 0.024072921, 0.024022803, 0.023972733, 0.023922723, 0.023872744, 0.023822857, 0.023773016, 0.023723159, 0.023673426, 0.02362372, 0.023574064, 0.023524437, 0.023474915, 0.023425382, 0.023375893, 0.023326525, 0.023277098, 0.023227852, 0.023178577, 0.023129392, 0.023080194, 0.023031102, 0.022982042, 0.022932995, 0.022884043, 0.02283515, 0.022786271, 0.022737455, 0.022688717, 0.022639977, 0.022591341, 0.022542741, 0.022494154, 0.02244563, 0.022397166, 0.022348776, 0.022300389, 0.022250714, 0.022202587, 0.022154447, 0.022106394, 0.022058435, 0.022010474, 0.021962639, 0.021914845, 0.02186707, 0.021819402, 0.021771794, 0.0217242, 0.02167673, 0.021629276, 0.021581914, 0.021534566, 0.021487311, 0.02144013, 0.021392997, 0.02134591, 0.021298882, 0.021251934, 0.021205045, 0.021158218, 0.021111403, 0.021064714, 0.021018054, 0.020971473, 0.020924937, 0.020878477, 0.02083203, 0.020785708, 0.020739399, 0.020693138, 0.020647001, 0.020600924, 0.020554859, 0.020508826, 0.020462917, 0.020417055, 0.020371236, 0.020325495, 0.020279815, 0.020234166, 0.020188622, 0.020143095, 0.020097645, 0.020052256, 0.020006971, 0.019961644, 0.019916454, 0.019871337, 0.019826258, 0.019781217, 0.019736242, 0.019691372, 0.019646488, 0.019601744, 0.019557025, 0.019512353, 0.019467745, 0.019423226, 0.019378711, 0.019334346, 0.019289982, 0.019245647, 0.01920142, 0.019157287, 0.01911312, 0.019069061, 0.019025095, 0.018981097, 0.018937284, 0.018893454, 0.018849732, 0.01880601, 0.01876238, 0.018718813, 0.018675303, 0.018631827, 0.018588472, 0.018545117, 0.018501854, 0.018458651, 0.018415481, 0.018372402, 0.018329352, 0.018286394, 0.018243499, 0.018200664, 0.018157829, 0.018115131, 0.018072451, 0.018029876, 0.017987302, 0.017944833, 0.017902413, 0.017860036, 0.017817738, 0.017775513, 0.017737025, 0.01769503, 0.017653083, 0.017611166, 0.017569419, 0.017527608, 0.017485952, 0.017444372, 0.017402869, 0.017361348, 0.017319968, 0.017278647, 0.017237388, 0.01719616, 0.017155007, 0.017113933, 0.017072964, 0.017031996, 0.016991179, 0.016950365, 0.016909627, 0.016868979, 0.016828347, 0.016787853, 0.016747374, 0.016706971, 0.016666615, 0.016626397, 0.016586147, 0.016546067, 0.016505986, 0.016465997, 0.016426053, 0.016386185, 0.016346395, 0.016306711, 0.016266998, 0.016227407, 0.016187908, 0.016148439, 0.016109046, 0.016069699, 0.016030459, 0.015991267, 0.015952148, 0.015913108, 0.015874127, 0.015835179, 0.015796369, 0.015757555, 0.015718792, 0.015680194, 0.015641581, 0.015603029, 0.015564587, 0.015526233, 0.015487912, 0.015449636, 0.015411466, 0.015373374, 0.015335329, 0.015297343, 0.01525942, 0.015221586, 0.015183769, 0.015146044, 0.015108412, 0.01507087, 0.015033329, 0.01499591, 0.01495852, 0.014921225, 0.014883958, 0.014846814, 0.01480967, 0.01477265, 0.014735688, 0.014698728, 0.01466189, 0.014625113, 0.014588429, 0.014551744, 0.014515213, 0.01447868, 0.014442301, 0.014405923, 0.014369574, 0.014333348, 0.014297245, 0.014261111, 0.014225007, 0.014189057, 0.014153136, 0.01411734, 0.014081541, 0.014045865, 0.014010223, 0.013974638, 0.013939147, 0.013903746, 0.013861555, 0.013826399, 0.013791275, 0.01375618, 0.013721241, 0.013686299, 0.013651512, 0.013616724, 0.013581997, 0.013547392, 0.013512819, 0.013478369, 0.013443916, 0.013409588, 0.013375227, 0.013341052, 0.013306907, 0.013272791, 0.0132388, 0.013204898, 0.013170998, 0.01313722, 0.013103502, 0.013069816, 0.013036252, 0.013002719, 0.012969278, 0.012935836, 0.012902577, 0.01286932, 0.012836123, 0.012803017, 0.012770005, 0.012737021, 0.0127041, 0.0126713, 0.012638532, 0.012605854, 0.012573238, 0.012540655, 0.012508161, 0.012475822, 0.01244342, 0.012411173, 0.012378923, 0.012346827, 0.012314763, 0.012282759, 0.012250847, 0.012218966, 0.012187176, 0.012155479, 0.012123812, 0.012092237, 0.012060723, 0.01202927, 0.011997939, 0.011966608, 0.011935401, 0.011904222, 0.011873137, 0.011842082, 0.011811119, 0.011780278, 0.011749437, 0.011718657, 0.011688029, 0.011657435, 0.011626869, 0.011596394, 0.011565981, 0.011535691, 0.011505431, 0.011475233, 0.011445097, 0.011415051, 0.011385066, 0.011355144, 0.011325251, 0.01129545, 0.011265771, 0.011236184, 0.011206598, 0.011177104, 0.011147731, 0.011118298, 0.011089018, 0.011059737, 0.01103067, 0.011001543, 0.010972506, 0.010943593, 0.01091471, 0.010885919, 0.01085719, 0.010828551, 0.010799914, 0.010771398, 0.010742913, 0.01071452, 0.010687274, 0.010659202, 0.010631084, 0.010603105, 0.010575199, 0.010547312, 0.010519546, 0.010491811, 0.01046412, 0.010436554, 0.010409016, 0.010381587, 0.010354172, 0.010326897, 0.010299604, 0.010272405, 0.010245327, 0.010218234, 0.010191294, 0.010164308, 0.01013749, 0.010110658, 0.010083948, 0.010057283, 0.01003074, 0.010004228, 0.009977717, 0.0099513587, 0.0099250311, 0.0098987631, 0.0098725883, 0.0098464899, 0.0098204212, 0.0097944457, 0.0097685158, 0.0097426614, 0.0097168684, 0.0096911527, 0.0096654678, 0.0096399337, 0.0096144173, 0.0095889615, 0.009563582, 0.0095382323, 0.0095130065, 0.0094878105, 0.0094627207, 0.0094376327, 0.0094126808, 0.0093877297, 0.0093628708, 0.0093381181, 0.0093133962, 0.0092887357, 0.0092641525, 0.0092396438, 0.0092151975, 0.0091907978, 0.0091665043, 0.0091422722, 0.0091180699, 0.0090939458, 0.0090698805, 0.0090459241, 0.0090220142, 0.008998164, 0.0089743901, 0.0089506786, 0.008926997, 0.0089034531, 0.0088799549, 0.0088565033, 0.0088330973, 0.0088098133, 0.0087865302, 0.008763399, 0.0087402677, 0.0087172296, 0.0086942213, 0.008671334, 0.0086484794, 0.0086256852, 0.0086030131, 0.0085803419, 0.0085577918, 0.0085352119, 0.0085127847, 0.0084904507, 0.0084681762, 0.0084459325, 0.0084236888, 0.0084015988, 0.0083795693, 0.0083576012, 0.0083357245, 0.0083138486, 0.0082920641, 0.0082703717, 0.0082487101, 0.0082271695, 0.0082111396, 0.0081898281, 0.00816858, 0.0081474381, 0.0081263268, 0.0081052305, 0.0080842571, 0.0080633136, 0.0080424314, 0.0080216266, 0.0080008209, 0.0079801381, 0.0079595158, 0.0079389093, 0.0079183644, 0.0078979097, 0.0078775175, 0.0078571709, 0.0078368858, 0.0078166006, 0.0077964826, 0.0077763358, 0.007756249, 0.0077363155, 0.0077163521, 0.0076964493, 0.0076766531, 0.0076569179, 0.0076371534, 0.0076175411, 0.0075979438, 0.0075783781, 0.0075589796, 0.0075395205, 0.0075201835, 0.007500893, 0.0074816472, 0.0074624945, 0.0074433563, 0.0074242949, 0.0074053099, 0.0073863557, 0.007367447, 0.0073486455, 0.0073298896, 0.0073111346, 0.0072925473, 0.007273945, 0.0072553731, 0.0072369082, 0.007218489, 0.0072001768, 0.0071818349, 0.0071635684, 0.0071454402, 0.0071272971, 0.0071092453, 0.0070912391, 0.0070733097, 0.0070553953, 0.0070376038, 0.0070197969, 0.0070020817, 0.0069844727, 0.0069668498, 0.0069492874, 0.0069318474, 0.0069144233, 0.0068970597, 0.006879773, 0.0068625468, 0.0068453518, 0.0068282485, 0.0068111457, 0.0067941644, 0.0067772288, 0.0067603099, 0.0067435126, 0.0067267152, 0.0067100096, 0.0066933497, 0.0066767205, 0.0066602142, 0.0066437377, 0.006627338, 0.0066109691, 0.0065946612, 0.0065784147, 0.0065622139, 0.0065461355, 0.0065300264, 0.0065140403, 0.0064980839, 0.0064821895, 0.0064663864, 0.0064505683, 0.0064348569, 0.0064192377, 0.0064035873, 0.0063880449, 0.0063703889, 0.0063550752, 0.0063397926, 0.0063246009, 0.0063094255, 0.0062942808, 0.0062792269, 0.0062641744, 0.0062492122, 0.0062342356, 0.0062193195, 0.0062044957, 0.006189656, 0.0061748936, 0.0061601615, 0.0061454903, 0.0061308802, 0.006116271, 0.006101707, 0.0060872198, 0.0060727932, 0.006058367, 0.0060440022, 0.0060296985, 0.0060153948, 0.0060011982, 0.0059869862, 0.0059728357, 0.0059587462, 0.0059447018, 0.0059306887, 0.005916737, 0.0059027849, 0.0058889245, 0.0058751106, 0.0058613271, 0.005847543, 0.0058338824, 0.0058202208, 0.0058066356, 0.0057930811, 0.0057795583, 0.0057661114, 0.005752679, 0.0057392782, 0.0057259533, 0.0057126596, 0.0056994115, 0.0056861928, 0.0056730364, 0.0056599262, 0.0056468621, 0.0056338273, 0.0056208242, 0.0056079281, 0.0055950317, 0.0055821505, 0.0055694073, 0.0055566183, 0.0055439048, 0.0055312687, 0.0055186325, 0.005506088, 0.0054935431, 0.0054810448, 0.0054686074, 0.0054562008, 0.0054438398, 0.0054315552, 0.005419286, 0.0054070326, 0.0053948853, 0.0053827385, 0.0053706528, 0.0053586289, 0.0053466195, 0.0053346721, 0.0053227697, 0.0053109294, 0.0052991039, 0.0052873548, 0.0052756211, 0.005263933, 0.005252291, 0.0052406956, 0.0052291607, 0.005217656, 0.0052061826, 0.0051947855, 0.0051834038, 0.0051720832, 0.0051608081, 0.0051495791, 0.0051383656, 0.0051272283, 0.0051161228, 0.0051050768, 0.0050940625, 0.0050831088, 0.0050722011, 0.0050593093, 0.0050485088, 0.0050377157, 0.0050269235, 0.005016176, 0.0050054598, 0.004994751, 0.0049840962, 0.0049734637, 0.0049628546, 0.0049522533, 0.0049417047, 0.0049311724, 0.0049206777, 0.0049102064, 0.0048997644, 0.0048893471, 0.0048789522, 0.0048685949, 0.0048582763, 0.0048479885, 0.0048377081, 0.0048274584, 0.0048172236, 0.0048070354, 0.0047968696, 0.004786727, 0.0047766152, 0.0047665336, 0.0047564902, 0.0047464622, 0.0047364649, 0.004726483, 0.0047165542, 0.0047066258, 0.0046967361, 0.0046868608, 0.0046770545, 0.0046672481, 0.0046574729, 0.004647743, 0.0046379985, 0.00462833, 0.0046186768, 0.0046090088, 0.0045994013, 0.0045898245, 0.0045802789, 0.0045707477, 0.0045612552, 0.0045517934, 0.0045423317, 0.0045329081, 0.0045235227, 0.0045141755, 0.0045048282, 0.0044955267, 0.0044862484, 0.0044770008, 0.0044677681, 0.0044586356, 0.0044494416, 0.004440316, 0.0044312058, 0.0044221189, 0.0044130697, 0.0044040596, 0.0043950486, 0.0043860609, 0.0043771267, 0.0043682158, 0.0043593277, 0.0043504853, 0.0043416275, 0.0043328237, 0.0043240581, 0.0043153148, 0.0043065948, 0.0042978982, 0.0042892392, 0.0042805881, 0.004272006, 0.0042634388, 0.0042548873, 0.0042463583, 0.004237853, 0.0042293696, 0.0042209406, 0.0042125266, 0.0042041508, 0.0041957675, 0.0041874452, 0.0041791461, 0.0041708695, 0.004162624, 0.0041543934, 0.0041462015, 0.0041380399, 0.0041299015, 0.0041218316, 0.004114694, 0.0041065053, 0.0040983399, 0.0040901825, 0.0040820325, 0.0040739169, 0.0040657897, 0.0040576817, 0.0040496117, 0.0040415158, 0.0040334528, 0.0040254099, 0.0040173596, 0.0040093241, 0.0040013273, 0.003993311, 0.0039853253, 0.0039773551, 0.003969396, 0.0039614411, 0.0039534941, 0.0039455849, 0.003937664, 0.0039297626, 0.0039218841, 0.0039140135, 0.0039061538, 0.0038983098, 0.0038904697, 0.0038826445, 0.0038748309, 0.0038670404, 0.0038592501, 0.0038514899, 0.0038437375, 0.0038359892, 0.0038282522, 0.003820542, 0.0038128276, 0.0038051289, 0.0037974571, 0.0037897925, 0.0037821361, 0.003774483, 0.0037668685, 0.0037592424, 0.0037516353, 0.0037440516, 0.0037364713, 0.0037288985, 0.0037213641, 0.0037138185, 0.0037062878, 0.0036987884, 0.0036912803, 0.0036837845, 0.003676319, 0.0036688535, 0.0036614034, 0.0036539605, 0.0036465451, 0.0036391369, 0.0036317287, 0.0036243552, 0.0036169777, 0.003609604, 0.0036022686, 0.0035949405, 0.0035876206, 0.0035803157, 0.0035730149, 0.0035657368, 0.0035584548, 0.003551207, 0.0035439597, 0.0035367312, 0.0035295181, 0.003522313, 0.0035150999, 0.0035079406, 0.0035007731, 0.0034936138, 0.0034864845, 0.0034793559, 0.0034722381, 0.0034651209, 0.0034580417, 0.0034509625, 0.0034438909, 0.0034368539, 0.0034298131, 0.0034227832, 0.0034157729, 0.0034087701, 0.0034017714, 0.003394803, 0.0033878502, 0.0033808975, 0.0033739673, 0.0033670487, 0.0033598661, 0.0033527811, 0.0033456981, 0.0033386229, 0.0033315532, 0.0033244796, 0.0033174157, 0.0033103519, 0.0033032899, 0.0032962298, 0.0032891792, 0.0032821326, 0.0032750955, 0.0032680545, 0.0032610153, 0.003253984, 0.0032469509, 0.0032399253, 0.0032329035, 0.0032258816, 0.0032188748, 0.0032118645, 0.0032048582, 0.0031978572, 0.0031908567, 0.0031838575, 0.0031768666, 0.0031698789, 0.0031628953, 0.0031559211, 0.0031489434, 0.0031419753, 0.0031350029, 0.0031280345, 0.0031210722, 0.0031141175, 0.0031071643, 0.003100221, 0.0030932736, 0.0030863322, 0.0030793867, 0.0030724551, 0.0030655228, 0.0030585967, 0.003051674, 0.0030447557, 0.0030378392, 0.0030309299, 0.0030240212, 0.003017114, 0.0030102124, 0.0030033132, 0.0029964214, 0.0029895371, 0.0029826532, 0.0029757707, 0.0029688941, 0.00296202, 0.0029551471, 0.0029482781, 0.002941417, 0.0029345597, 0.002927708, 0.0029208523, 0.0029140064, 0.0029071586, 0.0029003224, 0.0028934842, 0.0028866499, 0.0028798191, 0.0028730019, 0.0028661827, 0.002859358, 0.0028525463, 0.0028457367, 0.0028389331, 0.0028321233, 0.0028253291, 0.0028185348, 0.0028117422, 0.0028049578, 0.0027981752, 0.0027913959, 0.0027846151, 0.0027778477, 0.0027710765, 0.0027643146, 0.0027575565, 0.0027507988, 0.0027440484, 0.0027372902, 0.0027305477, 0.0027238035, 0.0027170663, 0.0027103312, 0.002703608, 0.0026968766, 0.0026901474, 0.0026834335, 0.0026767214, 0.0026708606, 0.0026639702, 0.0026570787, 0.0026501946, 0.0026433067, 0.0026364222, 0.0026295343, 0.0026226579, 0.0026157796, 0.0026089051, 0.0026020287, 0.0025951557, 0.0025882868, 0.0025814178, 0.0025745493, 0.0025676843, 0.0025608211, 0.002553964, 0.0025471025, 0.002540247, 0.0025333916, 0.0025265398, 0.0025196923, 0.0025128366, 0.0025059925, 0.0024991503, 0.0024923047, 0.0024854625, 0.0024786263, 0.0024717879, 0.0024649536, 0.0024581188, 0.0024512901, 0.0024444598, 0.002437633, 0.0024308064, 0.0024239835, 0.0024171623, 0.002410345, 0.0024035219, 0.0023967104, 0.0023898953, 0.0023830875, 0.0023762723, 0.0023694646, 0.0023626627, 0.0023558608, 0.0023490589, 0.0023422551, 0.0023354571, 0.0023286648, 0.0023218724, 0.0023150782, 0.0023082895, 0.002301499, 0.0022947162, 0.0022879275, 0.0022811505, 0.002274368, 0.002267591, 0.0022608119, 0.0022540386, 0.0022472653, 0.0022404997, 0.0022337264, 0.0022269648, 0.0022201971, 0.0022134355, 0.0022066718, 0.0021999159, 0.0021931599, 0.0021864055, 0.0021796536, 0.0021729032, 0.0021661511, 0.0021594102, 0.0021526637, 0.0021459193, 0.0021391783, 0.0021324416, 0.0021257065, 0.0021189677, 0.0021122347, 0.0021055054, 0.002098778, 0.002092049, 0.0020853234, 0.0020785998, 0.0020718803, 0.0020651605, 0.0020584448, 0.0020517285, 0.0020450149, 0.0020383028, 0.0020315927, 0.0020248862, 0.0020181839, 0.0020114738, 0.002004775, 0.0019980744, 0.0019904559, 0.0019836484, 0.0019768521, 0.0019700597, 0.0019632806, 0.0019564943, 0.0019497209, 0.0019429591, 0.0019362051, 0.0019294434, 0.0019226948, 0.0019159561, 0.0019092211, 0.0019024843, 0.0018957608, 0.0018890429, 0.0018823327, 0.0018756207, 0.001868924, 0.0018622292, 0.0018555421, 0.0018488567, 0.001842179, 0.0018355129, 0.0018288506, 0.0018221959, 0.0018155373, 0.0018088904, 0.0018022568, 0.001795623, 0.0017889932, 0.0017823711, 0.0017757546, 0.0017691478, 0.0017625409, 0.0017559398, 0.0017493501, 0.0017427682, 0.0017361862, 0.0017296078, 0.0017230451, 0.0017164861, 0.0017099251, 0.0017033737, 0.0016968318, 0.0016902956, 0.0016837595, 0.0016772349, 0.001670716, 0.0016642105, 0.0016576954, 0.0016511976, 0.0016447016, 0.0016382171, 0.0016317269, 0.0016252481, 0.0016187769, 0.0016123174, 0.0016058538, 0.0015994018, 0.0015929538, 0.0015865132, 0.0015800843, 0.0015736475, 0.0015672223, 0.0015608105, 0.0015544026, 0.0015479926, 0.0015415904, 0.0015351996, 0.0015288203, 0.0015224334, 0.0015160579, 0.0015096919, 0.0015033336, 0.0014969696, 0.0014906172, 0.001484276, 0.0014779387, 0.0014716015, 0.0014652758, 0.0014589576, 0.0014526433, 0.0014463291, 0.0014400299, 0.0014337311, 0.0014274436, 0.001421154, 0.0014148779, 0.0014086077, 0.0014023413, 0.0013960786, 0.0013898292, 0.00138358, 0.0013773383, 0.0013710968, 0.0013648705, 0.001358644, 0.0013524294, 0.001346222, 0.0013391083, 0.0013329241, 0.0013267744, 0.0013206206, 0.0013144861, 0.0013083516, 0.0013022438, 0.0012961475, 0.001290055, 0.0012839664, 0.0012779083, 0.001271858, 0.0012657999, 0.0012597763, 0.0012537565, 0.001247748, 0.0012417474, 0.0012357736, 0.0012297959, 0.0012238487, 0.0012178938, 0.0012119467, 0.0012060341, 0.0012001251, 0.0011942239, 0.0011883227, 0.001182452, 0.0011765928, 0.0011707374, 0.0011648859, 0.0011590726, 0.0011532517, 0.0011474346, 0.0011416596, 0.0011358693, 0.0011301057, 0.0011243498, 0.0011186054, 0.0011128647, 0.0011071432, 0.0011014293, 0.001095727, 0.0010900514, 0.0010843797, 0.0010787193, 0.001073059, 0.0010674217, 0.0010617919, 0.0010561891, 0.0010505707, 0.0010449907, 0.0010394108, 0.0010338499, 0.0010282891, 0.001022736, 0.0010172095, 0.0010116983, 0.001006191, 0.0010006875, 0.00099520304, 0.00098973396, 0.00098426116, 0.0009788227, 0.00097340328, 0.00096796482, 0.00096256076, 0.00095715671, 0.00095175649, 0.00094639073, 0.00094101339, 0.00093567435, 0.00093032001, 0.00092499633, 0.00091968401, 0.00091436796, 0.00090907863, 0.00090381218, 0.00089853053, 0.00089326804, 0.0008880361, 0.00088279258, 0.00087757985, 0.00087236316, 0.00086716563, 0.00086197187, 0.00085680879, 0.00085163797, 0.00084648258, 0.00084134622, 0.0008362137, 0.0008311118, 0.00082599843, 0.00082090794, 0.00081583281, 0.00081077294, 0.00080570928, 0.00080067996, 0.00079563545, 0.00079062156, 0.00078560761, 0.0007812744, 0.00077640195, 0.0007715142, 0.00076667237, 0.00076183054, 0.00075699633, 0.00075219275, 0.00074737379, 0.00074260839, 0.00073783536, 0.00073310058, 0.00072837359, 0.00072364643, 0.0007189422, 0.00071425334, 0.00070959504, 0.00070493686, 0.00070028618, 0.00069566618, 0.00069104612, 0.00068646437, 0.00068189023, 0.00067732378, 0.00067277258, 0.00066823664, 0.00066373136, 0.00065923372, 0.00065475912, 0.00065026135, 0.00064581726, 0.00064137322, 0.00063696736, 0.00063255389, 0.00062814029, 0.00062378036, 0.00061940507, 0.00061508344, 0.00061073108, 0.0006064247, 0.00060211826, 0.00059784239, 0.00059358188, 0.00058930612, 0.00058508379, 0.00058085384, 0.00057666987, 0.00057247817, 0.00056828646, 0.00056412542, 0.00055997958, 0.00055586442, 0.00055175688, 0.00054765696, 0.00054355705, 0.00053950306, 0.00053545675, 0.00053141802, 0.00052738696, 0.00052338652, 0.00051940139, 0.00051542383, 0.00051146164, 0.00050751475, 0.00050359842, 0.00049968209, 0.00049580401, 0.00049191067, 0.00048804024, 0.00048417749, 0.00048036821, 0.0004765437, 0.00047275747, 0.00046894056, 0.00046518486, 0.00046142918, 0.00045768113, 0.00045397136, 0.00045024627, 0.00044655942, 0.00044287261, 0.0004392163, 0.0004355601, 0.0004319268, 0.00042831642, 0.00042469843, 0.00042112631, 0.00041754657, 0.00041399742, 0.00041045592, 0.00040693732, 0.00040343404, 0.00039995374, 0.00039645811, 0.00039300078, 0.00038955102, 0.00038612421, 0.00038271278, 0.00037929363, 0.00037591276, 0.00037255479, 0.00036985471, 0.00036663449, 0.00036338362, 0.00036017867, 0.00035700429, 0.00035381466, 0.00035065558, 0.00034749653, 0.00034436808, 0.0003412549, 0.00033813409, 0.00033504388, 0.00033197663, 0.00032891697, 0.00032587265, 0.00032285892, 0.00031983753, 0.00031683908, 0.00031386365, 0.00031089579, 0.00030796623, 0.0003050137, 0.00030208411, 0.00029919276, 0.00029630138, 0.000293433, 0.00029056461, 0.00028772681, 0.00028490432, 0.00028208946, 0.00027928993, 0.00027652096, 0.00027374434, 0.00027099068, 0.00026827527, 0.00026554454, 0.00026282915, 0.0002601367, 0.00025747484, 0.00025481294, 0.00025218166, 0.00024952745, 0.00024692676, 0.00024433373, 0.000241756, 0.00023917826, 0.00023663878, 0.00023409929, 0.00023157512, 0.00022908153, 0.00022659558, 0.00022412493, 0.000221639, 0.00021920659, 0.00021678949, 0.00021436474, 0.00021197059, 0.00020958408, 0.00020722818, 0.00020487228, 0.00020253929, 0.0002001987, 0.00019791161, 0.00019561691, 0.00019333749, 0.00019108866, 0.0001888322, 0.00018660632, 0.00018441104, 0.00018221576, 0.00018002813, 0.0001778405, 0.00017570642, 0.00017357235, 0.00017145356, 0.0001693424, 0.00016724657, 0.00016516603, 0.00016311608, 0.00016107377, 0.00015904679, 0.00015703507, 0.00015503101, 0.00015304227, 0.00015109176, 0.0001491336, 0.00014719075, 0.00014526318, 0.00014337388, 0.00014146925, 0.00013960288, 0.00013773651, 0.00013590074, 0.00013407262, 0.00013225216, 0.00013044696, 0.00012866473, 0.00012689781, 0.00012516147, 0.00012342512, 0.00012158936, 0.00011996012, 0.00011836146, 0.00011675899, 0.00011515652, 0.00011357699, 0.00011201657, 0.00011045999, 0.00010891105, 0.00010738125, 0.00010585908, 0.00010434457, 0.00010284154, 0.00010135761, 9.9889003e-05, 9.8428034e-05, 9.6955584e-05, 9.5525211e-05, 9.4110132e-05, 9.2683586e-05, 9.1268514e-05, 8.9876383e-05, 8.8499561e-05, 8.7130378e-05, 8.5765016e-05, 8.4414954e-05, 8.3087842e-05, 8.1756909e-05, 8.043745e-05, 7.9144767e-05, 7.7859724e-05, 7.6574681e-05, 7.5316413e-05, 7.4069612e-05, 7.2822819e-05, 7.1576025e-05, 7.0363654e-05, 6.916275e-05, 6.7965666e-05, 6.6768596e-05, 6.5602107e-05, 6.4447107e-05, 6.3288273e-05, 6.214474e-05, 6.1020331e-05, 5.9911214e-05, 5.8805923e-05, 5.7715937e-05, 5.6633598e-05, 5.5574204e-05, 5.450716e-05, 5.3459244e-05, 5.2438088e-05, 5.1413113e-05, 5.0395789e-05, 4.939377e-05, 4.8414688e-05, 4.7439433e-05, 4.6468002e-05, 4.5515699e-05, 4.4578686e-05, 4.3649325e-05, 4.2727617e-05, 4.1832674e-05, 4.0926265e-05, 4.0054274e-05, 3.9166982e-05, 3.8325587e-05, 3.746889e-05, 3.6638972e-05, 3.5797573e-05, 3.4998247e-05, 3.4191271e-05, 3.3407243e-05, 3.2623215e-05, 3.1858312e-05, 3.1097228e-05, 3.0355272e-05, 2.9617137e-05, 2.8917248e-05, 2.8190589e-05, 2.7494523e-05, 2.6809934e-05, 2.6148293e-05, 2.5478999e-05, 2.4821182e-05, 2.4174835e-05, 2.3566736e-05, 2.2943339e-05, 2.2327589e-05, 2.1753911e-05, 2.1176407e-05, 2.0598902e-05, 2.0036698e-05, 1.9493615e-05, 1.8962004e-05, 1.8434221e-05, 1.7937033e-05, 1.7443666e-05, 1.6946478e-05, 1.6350808e-05, 1.5919593e-05, 1.5507501e-05, 1.5088715e-05, 1.4677578e-05, 1.4274092e-05, 1.3879208e-05, 1.3484327e-05, 1.309518e-05, 1.2718465e-05, 1.2337924e-05, 1.1962164e-05, 1.1592142e-05, 1.123168e-05, 1.0877911e-05, 1.0525098e-05, 1.0180891e-05, 9.8443325e-06, 9.5058622e-06, 9.1712154e-06, 8.8528241e-06, 8.5277388e-06, 8.218909e-06, 7.9062538e-06, 7.6031597e-06, 7.3077149e-06, 7.0103579e-06, 6.7206502e-06, 6.4414589e-06, 6.1651376e-06, 5.8955084e-06, 5.6220547e-06, 5.3591189e-06, 5.1086122e-06, 4.8561933e-06, 4.6075988e-06, 4.3752589e-06, 4.1362259e-06, 3.9048418e-06, 3.6830197e-06, 3.4573725e-06, 3.2489356e-06, 3.040499e-06, 2.8330185e-06, 2.6417922e-06, 2.4476976e-06, 2.2583831e-06, 2.0767184e-06, 1.9046145e-06, 1.7286864e-06, 1.5613631e-06, 1.3949963e-06, 1.2477518e-06, 1.0947709e-06, 9.494388e-07, 8.0984364e-07, 6.7789745e-07, 5.4786346e-07, 4.1974189e-07, 2.9831327e-07, 1.9313862e-07, 8.1271182e-08, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 2.410307e-15, 4.7806587e-08, 1.3194618e-07, 2.1799805e-07, 3.0596215e-07, 3.9583853e-07, 4.8762723e-07, 5.8132809e-07, 6.7502901e-07, 7.7255447e-07, 8.7007993e-07, 9.7142993e-07, 1.0727798e-06, 1.176042e-06, 1.2812166e-06, 1.3863911e-06, 1.4953901e-06, 1.6063013e-06, 1.7172126e-06, 1.8300362e-06, 1.9466843e-06, 2.0633322e-06, 2.1780681e-06, 2.2985407e-06, 2.4190133e-06, 2.5433105e-06, 2.6637831e-06, 2.7919045e-06, 2.9200264e-06, 3.0500603e-06, 3.1800942e-06, 3.3139527e-06, 3.4497234e-06, 3.5854939e-06, 3.7231771e-06, 3.8646845e-06, 4.0061918e-06, 4.1496119e-06, 4.2930319e-06, 4.4383637e-06, 4.5856077e-06, 4.7366766e-06, 4.8877455e-06, 5.0407266e-06, 5.1956199e-06, 5.3524259e-06, 5.5111436e-06, 5.6698614e-06, 5.832404e-06, 5.9949462e-06, 6.1594005e-06   }, 
   { 0.0023050886, 0.00230471, 0.0023043321, 0.0023039533, 0.0023035745, 0.0023031957, 0.0023028157, 0.0023024362, 0.0023020552, 0.0023016753, 0.0023012946, 0.0023009127, 0.0023005318, 0.00230015, 0.0022997677, 0.0022993851, 0.0022990028, 0.0022986189, 0.0022982357, 0.0022978513, 0.0022974676, 0.0022970825, 0.0022966978, 0.0022963132, 0.0022959271, 0.0022955423, 0.002295156, 0.0022947693, 0.0022943828, 0.002293996, 0.0022936082, 0.0022932207, 0.0022928321, 0.0022924438, 0.0022920552, 0.0022916659, 0.0022912771, 0.0022908875, 0.0022904971, 0.0022901071, 0.0022897159, 0.0022893252, 0.0022889336, 0.002288542, 0.0022881504, 0.0022877576, 0.0022873653, 0.0022869725, 0.0022865788, 0.0022861857, 0.0022857913, 0.0022853964, 0.0022850025, 0.0022846076, 0.002284212, 0.0022838169, 0.0022834206, 0.0022830246, 0.0022826274, 0.0022822311, 0.0022818339, 0.002281436, 0.0022810383, 0.0022806404, 0.0022802416, 0.002279843, 0.002279443, 0.0022790437, 0.0022786441, 0.0022782439, 0.0022778434, 0.0022774432, 0.0022770416, 0.0022766404, 0.0022762388, 0.002275836, 0.0022754341, 0.0022750311, 0.0022746283, 0.0022742243, 0.0022738208, 0.0022734171, 0.002273012, 0.0022726073, 0.0022722024, 0.0022717963, 0.0022713915, 0.0022709854, 0.0022705786, 0.0022701724, 0.0022697649, 0.0022693577, 0.0022689505, 0.0022685421, 0.0022681337, 0.0022677246, 0.0022673162, 0.0022669071, 0.0022664971, 0.0022660869, 0.0022656769, 0.0022652657, 0.0022648554, 0.0022644433, 0.0022640324, 0.0022636207, 0.0022632082, 0.0022627958, 0.002262383, 0.0022619695, 0.0022615565, 0.0022611425, 0.002260728, 0.0022603138, 0.0022598982, 0.0022594833, 0.002259067, 0.0022586514, 0.0022582356, 0.0022578186, 0.0022574021, 0.0022569855, 0.0022565676, 0.0022561501, 0.0022557322, 0.0022553131, 0.0022548947, 0.0022544751, 0.002254056, 0.0022536365, 0.0022532158, 0.002252796, 0.0022523743, 0.0022519536, 0.0022515324, 0.0022511103, 0.0022506882, 0.0022502656, 0.0022498432, 0.0022494204, 0.0022489966, 0.0022485731, 0.0022481496, 0.0022477249, 0.0022473, 0.0022468753, 0.0022464499, 0.0022460243, 0.0022455989, 0.0022451719, 0.0022449004, 0.0022441633, 0.002243445, 0.0022427202, 0.0022420082, 0.0022413088, 0.0022406024, 0.0022399155, 0.0022392222, 0.0022385346, 0.0022378662, 0.0022371847, 0.002236516, 0.0022358666, 0.0022352035, 0.0022345728, 0.0022339227, 0.0022332785, 0.0022326598, 0.0022320282, 0.002231403, 0.0022307967, 0.0022301837, 0.00222959, 0.0022289893, 0.0022283951, 0.0022278265, 0.0022272444, 0.0022266691, 0.0022261066, 0.0022255429, 0.0022249799, 0.0022244419, 0.002223891, 0.0022233529, 0.0022228269, 0.0022222952, 0.0022217815, 0.0022212749, 0.0022207615, 0.0022202667, 0.0022197661, 0.002219284, 0.0022187952, 0.002218313, 0.0022178434, 0.0022173731, 0.0022169035, 0.0022164581, 0.0022160134, 0.002215575, 0.0022151363, 0.0022146972, 0.0022142772, 0.0022138569, 0.0022134369, 0.0022130352, 0.0022126278, 0.0022122327, 0.0022118434, 0.0022114606, 0.0022110904, 0.0022107074, 0.002210337, 0.0022099852, 0.0022096206, 0.002209269, 0.0022089358, 0.0022085903, 0.002208251, 0.002207943, 0.0022076159, 0.0022073078, 0.0022069931, 0.0022066843, 0.0022064017, 0.0022061057, 0.0022058222, 0.0022055388, 0.0022052617, 0.0022050028, 0.0022047444, 0.0022044796, 0.0022042396, 0.002203987, 0.0022037597, 0.0022035197, 0.0022032924, 0.0022030773, 0.0022028559, 0.0022026408, 0.0022024505, 0.0022022545, 0.0022020577, 0.0022018803, 0.0022016957, 0.0022015243, 0.002201353, 0.002201187, 0.0022010405, 0.0022000938, 0.0021994105, 0.0021987909, 0.0021982291, 0.002197667, 0.002197156, 0.0021966132, 0.0021961469, 0.0021957064, 0.0021952656, 0.002194863, 0.0021944928, 0.0021942181, 0.0021938605, 0.0021935857, 0.0021933878, 0.0021931515, 0.0021929983, 0.0021927683, 0.0021926663, 0.0021925832, 0.0021924553, 0.0021924106, 0.00219243, 0.0021924425, 0.0021924363, 0.0021925641, 0.0021926726, 0.0021927876, 0.0021929345, 0.0021931005, 0.0021933366, 0.0021935857, 0.0021938477, 0.0021941287, 0.0021944609, 0.0021948311, 0.0021951953, 0.0021956298, 0.0021960638, 0.002196562, 0.0021970731, 0.0021975839, 0.0021981525, 0.002198759, 0.0021993339, 0.0021999725, 0.0022006624, 0.0022013967, 0.0022020994, 0.0022028976, 0.002203664, 0.002204488, 0.0022053437, 0.0022062187, 0.0022071127, 0.002208058, 0.0022090224, 0.0022099868, 0.0022110087, 0.0022120881, 0.0022131547, 0.0022142404, 0.002215409, 0.0022165587, 0.002217785, 0.0022189475, 0.0022202183, 0.0022215338, 0.0022227922, 0.0022241333, 0.0022255064, 0.0022269499, 0.0022283294, 0.0022297727, 0.0022313055, 0.0022327872, 0.0022343518, 0.0022358655, 0.0022375006, 0.0022391549, 0.0022407579, 0.0022424182, 0.002244181, 0.0022459372, 0.0022476555, 0.0022494756, 0.0022513277, 0.0022531671, 0.0022550703, 0.0022569608, 0.002258915, 0.0022609078, 0.0022629069, 0.0022648994, 0.0022669751, 0.0022690701, 0.0022711584, 0.0022733107, 0.0022754692, 0.0022781009, 0.0022804255, 0.0022828779, 0.0022853815, 0.0022879874, 0.0022905676, 0.0022931988, 0.0022959581, 0.0022987679, 0.0023016036, 0.002304567, 0.0023075303, 0.002310545, 0.0023136616, 0.0023167785, 0.0023200228, 0.0023233437, 0.0023266396, 0.0023300881, 0.0023334601, 0.0023370367, 0.0023406134, 0.0023442155, 0.0023478686, 0.0023516752, 0.0023555583, 0.0023593646, 0.00236335, 0.0023673354, 0.0023713973, 0.0023755103, 0.0023796742, 0.0023839662, 0.002388207, 0.0023925242, 0.0023969696, 0.0024014912, 0.0024060386, 0.0024105858, 0.002415261, 0.0024199872, 0.0024247898, 0.002429618, 0.0024344975, 0.0024394791, 0.0024444351, 0.00244957, 0.0024547048, 0.0024599165, 0.002465179, 0.0024704419, 0.0024758831, 0.0024813246, 0.0024867915, 0.0024923864, 0.0024979811, 0.0025036267, 0.0025094259, 0.0025152252, 0.0025210497, 0.0025270022, 0.0025329799, 0.0025390091, 0.0025451405, 0.0025512972, 0.0025575049, 0.0025637893, 0.002570125, 0.002576537, 0.002582975, 0.0025894893, 0.0025960549, 0.0026026969, 0.0026094667, 0.0026161855, 0.0026230067, 0.0026298787, 0.0026368273, 0.0026438781, 0.0026509035, 0.0026580312, 0.002665133, 0.0026723882, 0.0026797203, 0.0026871031, 0.0026945374, 0.0027019461, 0.0027095333, 0.0027171969, 0.0027248359, 0.0027325763, 0.0027403173, 0.0027481341, 0.002756028, 0.0027640243, 0.0027720204, 0.0027801446, 0.002788268, 0.0027964176, 0.0028047711, 0.0028141921, 0.0028234401, 0.0028328157, 0.0028421916, 0.0028517204, 0.0028612493, 0.0028709059, 0.0028805882, 0.002890347, 0.0029001823, 0.0029101202, 0.0029201086, 0.0029301741, 0.0029402906, 0.0029504837, 0.002960779, 0.0029710999, 0.0029815228, 0.0029919969, 0.0030024967, 0.0030132006, 0.0030239047, 0.0030346345, 0.0030454404, 0.0030563746, 0.0030673596, 0.0030784467, 0.0030895851, 0.0031007491, 0.0031120151, 0.0031234343, 0.0031348281, 0.0031463243, 0.0031578711, 0.0031694698, 0.0031811697, 0.0031929724, 0.0032048004, 0.0032167565, 0.0032287121, 0.0032407448, 0.0032529559, 0.0032651417, 0.003277404, 0.0032897431, 0.0033021332, 0.0033146765, 0.0033272202, 0.0033398401, 0.0033524856, 0.0033652592, 0.0033780835, 0.0033910356, 0.0034040133, 0.0034170419, 0.0034301986, 0.0034434062, 0.0034567413, 0.0034700257, 0.0034834633, 0.0034969517, 0.0035104917, 0.0035241591, 0.0035378777, 0.0035516215, 0.0035654679, 0.0035793653, 0.0035933647, 0.0036074412, 0.003621594, 0.0036357467, 0.0036500529, 0.0036643846, 0.0036788438, 0.0036933543, 0.0037078906, 0.0037224775, 0.0037371926, 0.0037519839, 0.0037667756, 0.0037817203, 0.0037966906, 0.0038117121, 0.0038269379, 0.0038421126, 0.0038573896, 0.0038727429, 0.003888122, 0.0039036288, 0.0039192378, 0.0039348216, 0.0039505581, 0.0039663198, 0.0039821337, 0.0039981259, 0.0040140925, 0.0040301359, 0.0040462813, 0.004062478, 0.0040788022, 0.0040934063, 0.0041107275, 0.0041280352, 0.0041454323, 0.0041628806, 0.0041803927, 0.0041978797, 0.0042154938, 0.0042331209, 0.004250735, 0.0042684777, 0.0042862194, 0.0043040509, 0.0043219081, 0.0043398035, 0.0043577757, 0.0043758242, 0.0043938472, 0.004411947, 0.004430098, 0.0044482998, 0.0044665276, 0.0044848444, 0.0045031738, 0.0045215418, 0.0045399996, 0.0045584822, 0.0045770165, 0.0045955884, 0.0046141995, 0.0046328614, 0.0046515991, 0.0046703634, 0.0046891528, 0.0047080447, 0.0047269361, 0.0047459048, 0.0047648861, 0.0047839312, 0.0048029884, 0.0048221615, 0.0048413468, 0.0048605837, 0.0048798709, 0.0048992098, 0.0049185869, 0.0049380152, 0.0049575074, 0.004976999, 0.0049965936, 0.0050162259, 0.0050358842, 0.0050555933, 0.0050753662, 0.0050951522, 0.005115028, 0.0051349285, 0.0051548551, 0.0051749083, 0.0051949113, 0.0052150036, 0.0052351607, 0.0052553806, 0.0052755754, 0.0052958848, 0.0053161941, 0.0053365799, 0.0053570047, 0.0053774165, 0.0053979559, 0.0054185465, 0.0054391501, 0.0054598041, 0.0054805102, 0.0055012535, 0.0055220872, 0.0055429325, 0.0055638426, 0.0055847652, 0.0056058033, 0.0056268279, 0.0056479163, 0.0056690434, 0.0056902347, 0.0057114377, 0.0057327566, 0.0057540755, 0.0057754191, 0.0057968786, 0.0058183381, 0.005839848, 0.0058614346, 0.0058830604, 0.0059046857, 0.0059264386, 0.0059481529, 0.005969957, 0.0059917355, 0.0060136537, 0.0060355859, 0.0060606468, 0.0060827122, 0.0061047468, 0.0061267996, 0.0061488659, 0.0061709378, 0.0061929845, 0.0062150569, 0.0062371166, 0.0062592085, 0.0062812804, 0.0063033523, 0.0063254698, 0.0063475482, 0.0063696592, 0.0063917441, 0.0064138868, 0.0064359717, 0.0064581013, 0.0064802119, 0.0065023354, 0.006524465, 0.0065466017, 0.0065687438, 0.006590886, 0.0066130483, 0.0066351779, 0.0066573583, 0.0066795079, 0.0067016953, 0.00672385, 0.0067460183, 0.0067681926, 0.0067903926, 0.0068125674, 0.0068347547, 0.0068569677, 0.0068791742, 0.0069013736, 0.0069235861, 0.0069458121, 0.0069680186, 0.0069902437, 0.0070124511, 0.0070347083, 0.0070569343, 0.007079198, 0.0071014296, 0.0071236873, 0.0071459319, 0.0071682022, 0.0071904464, 0.0072127236, 0.0072349939, 0.0072572646, 0.00727956, 0.0073018302, 0.0073241387, 0.0073464224, 0.0073687434, 0.0073910328, 0.0074133482, 0.0074356501, 0.0074579651, 0.0074802921, 0.0075026075, 0.0075249481, 0.0075472756, 0.0075696227, 0.0075919507, 0.0076143169, 0.0076366575, 0.0076590362, 0.0076813833, 0.0077037434, 0.0077260961, 0.0077484814, 0.0077708727, 0.0077932393, 0.0078156302, 0.0078380229, 0.0078604268, 0.0078828242, 0.0079052486, 0.0079276403, 0.0079500694, 0.0079724742, 0.0079949107, 0.0080173342, 0.0080397511, 0.0080621941, 0.0080846241, 0.0081070866, 0.0081295287, 0.0081519969, 0.008174439, 0.0081969146, 0.0082193762, 0.0082418444, 0.008264319, 0.0082862163, 0.0083077522, 0.008329263, 0.0083507607, 0.0083722193, 0.0083936593, 0.0084151058, 0.008436501, 0.0084578842, 0.0084792534, 0.0085005984, 0.0085219098, 0.0085432157, 0.0085644899, 0.0085857641, 0.0086070066, 0.0086282166, 0.00864942, 0.0086705917, 0.0086917439, 0.008712884, 0.008733999, 0.0087550813, 0.0087761506, 0.0087972144, 0.0088182325, 0.0088392319, 0.0088602193, 0.0088811927, 0.00890214, 0.0089230565, 0.0089439545, 0.0089648515, 0.0089857038, 0.0090065505, 0.0090273768, 0.0090481723, 0.0090689482, 0.0090896981, 0.0091104293, 0.009131141, 0.0091518406, 0.0091725141, 0.0091931811, 0.0092137856, 0.0092344014, 0.009254992, 0.0092755565, 0.009296109, 0.0093166362, 0.0093371309, 0.0093576135, 0.0093780821, 0.0093985265, 0.0094189504, 0.0094393492, 0.0094597293, 0.0094800768, 0.0095004058, 0.0095207347, 0.0095410319, 0.0095612966, 0.0095815491, 0.0096017811, 0.0096219955, 0.0096421838, 0.0096623525, 0.0096825082, 0.0097026341, 0.0097227329, 0.0097428188, 0.0097628785, 0.0097829271, 0.0098029561, 0.0098229581, 0.0098429164, 0.0098628812, 0.0098828329, 0.0099027473, 0.0099226413, 0.0099425176, 0.0099623734, 0.0099822031, 0.010002009, 0.010021809, 0.010041575, 0.010061328, 0.010081063, 0.010100754, 0.010120443, 0.010140115, 0.010159761, 0.010179393, 0.010198986, 0.010218555, 0.010238124, 0.010257674, 0.010277185, 0.010296684, 0.010316163, 0.010333149, 0.010350841, 0.010368494, 0.010386203, 0.010403914, 0.010421637, 0.010439367, 0.010457103, 0.010474838, 0.010492586, 0.010510336, 0.01052809, 0.010545864, 0.010563657, 0.010581424, 0.01059923, 0.010617037, 0.010634843, 0.010652661, 0.010670487, 0.010688318, 0.010706125, 0.010723988, 0.010741846, 0.010759714, 0.010777585, 0.010795473, 0.010813351, 0.010831226, 0.010849141, 0.010867055, 0.010884989, 0.010902903, 0.010920818, 0.010938765, 0.010956718, 0.010974676, 0.010992643, 0.011010622, 0.011028592, 0.011046566, 0.011064563, 0.011082553, 0.011100584, 0.011118594, 0.011136631, 0.011154635, 0.011172702, 0.011190751, 0.011208812, 0.011226867, 0.011244948, 0.011263015, 0.011281109, 0.011299203, 0.011317321, 0.01133544, 0.01135356, 0.011371672, 0.011389809, 0.011407922, 0.011426074, 0.011444237, 0.011462413, 0.011480584, 0.01149876, 0.01151695, 0.011535157, 0.011553354, 0.011571568, 0.01158979, 0.011608023, 0.011626258, 0.011644498, 0.011662756, 0.011681017, 0.011699275, 0.011717548, 0.011735813, 0.011754106, 0.011772403, 0.011790707, 0.011809011, 0.01182734, 0.011845659, 0.011863993, 0.011882337, 0.011900692, 0.011919061, 0.011937428, 0.011955802, 0.011974177, 0.011992577, 0.012010976, 0.01202939, 0.012047789, 0.012066215, 0.012084628, 0.012103073, 0.012121498, 0.012140494, 0.012157597, 0.012174764, 0.012192109, 0.012209482, 0.012226967, 0.012244633, 0.012262313, 0.012280118, 0.012297987, 0.012316036, 0.012334149, 0.012352351, 0.012370653, 0.012389087, 0.012407594, 0.012426219, 0.012444893, 0.012463707, 0.0124826, 0.012501658, 0.012520804, 0.012540015, 0.012559342, 0.012578731, 0.012598262, 0.012617946, 0.012637667, 0.012657454, 0.012677368, 0.012697447, 0.012717539, 0.012737772, 0.012758171, 0.012778583, 0.012799072, 0.012819802, 0.012840495, 0.01286129, 0.012882213, 0.012903315, 0.012924427, 0.012945671, 0.012967078, 0.012988461, 0.013010035, 0.01303166, 0.013053452, 0.013075268, 0.013097213, 0.013119271, 0.013141459, 0.01316366, 0.013186102, 0.013208506, 0.013231077, 0.013253788, 0.013276512, 0.013299338, 0.013322304, 0.013345423, 0.01336853, 0.013391753, 0.013415153, 0.013438668, 0.013462209, 0.013485867, 0.01350965, 0.013533496, 0.013557472, 0.013581691, 0.013605806, 0.013630038, 0.013654498, 0.013678908, 0.013703471, 0.013728136, 0.013752943, 0.013777825, 0.013802809, 0.013827973, 0.013853111, 0.013878363, 0.013903744, 0.013929291, 0.013954862, 0.013980575, 0.014006441, 0.014032269, 0.014058224, 0.01408441, 0.014110557, 0.014136882, 0.014163207, 0.014189776, 0.014216371, 0.014243028, 0.014269916, 0.014296817, 0.014323793, 0.014347709, 0.014375911, 0.014404422, 0.014432881, 0.014461902, 0.014490719, 0.014520149, 0.014549579, 0.014579366, 0.01460905, 0.014639145, 0.014669698, 0.014700048, 0.014730754, 0.014761666, 0.014792629, 0.014824256, 0.014855729, 0.014887254, 0.01491929, 0.014951375, 0.01498382, 0.015016367, 0.015049014, 0.015082175, 0.01511518, 0.015148391, 0.015182215, 0.015215886, 0.01524976, 0.015284044, 0.015318481, 0.015353173, 0.015387865, 0.015422864, 0.015458221, 0.015493476, 0.015529343, 0.015565006, 0.015600924, 0.01563715, 0.015673732, 0.015710367, 0.015747307, 0.015784349, 0.015821597, 0.015859047, 0.015896805, 0.015934769, 0.015972679, 0.016010845, 0.016049525, 0.016088201, 0.016127031, 0.016166272, 0.01620551, 0.016245158, 0.016284758, 0.016324814, 0.016364923, 0.016405234, 0.01644565, 0.016486473, 0.016527399, 0.016568631, 0.016610119, 0.016651453, 0.016693503, 0.016735349, 0.016777655, 0.016820112, 0.016862569, 0.016905438, 0.01694851, 0.016991632, 0.017035164, 0.017078644, 0.01712238, 0.017166628, 0.01721077, 0.017255222, 0.017299879, 0.017344687, 0.017389955, 0.017435275, 0.017480545, 0.017526222, 0.017572155, 0.017618343, 0.017664582, 0.017710974, 0.017757827, 0.017804733, 0.017851789, 0.017899252, 0.017946668, 0.017994236, 0.018042315, 0.018090343, 0.01813888, 0.018188171, 0.018239776, 0.018291635, 0.018343598, 0.018396122, 0.01844844, 0.01850112, 0.018554255, 0.018607343, 0.018660786, 0.018714586, 0.018768389, 0.018822648, 0.018877165, 0.018931735, 0.018986762, 0.019041738, 0.019096917, 0.019152764, 0.019208355, 0.019264402, 0.019320708, 0.019377165, 0.019434033, 0.019491052, 0.019548226, 0.019605758, 0.01966339, 0.019721381, 0.019779526, 0.019837873, 0.019896327, 0.019955337, 0.020014299, 0.020073723, 0.020133248, 0.020193128, 0.020253265, 0.020313451, 0.020374151, 0.020434849, 0.020495653, 0.020556811, 0.020618273, 0.020679792, 0.020741971, 0.020804049, 0.020866537, 0.020929178, 0.020991869, 0.021055225, 0.021118479, 0.021181937, 0.021245904, 0.021309722, 0.021374151, 0.021438528, 0.02150316, 0.021568306, 0.02163345, 0.021698952, 0.021764759, 0.021830518, 0.021896733, 0.021963155, 0.022029679, 0.022096511, 0.022163697, 0.022230836, 0.022298532, 0.022366229, 0.022434441, 0.022502752, 0.022571063, 0.02263994, 0.022708811, 0.022777991, 0.022847477, 0.02291717, 0.022987066, 0.023057219, 0.02312752, 0.023198238, 0.023269001, 0.023340071, 0.023411449, 0.02348298, 0.023554714, 0.023626756, 0.023699002, 0.023771452, 0.023844412, 0.023917221, 0.02399054, 0.024063757, 0.024137588, 0.024211518, 0.024285503, 0.024359791, 0.024434593, 0.024512973, 0.02459117, 0.024669418, 0.024747796, 0.024826327, 0.024904959, 0.024983773, 0.025062734, 0.025141878, 0.025221122, 0.025300601, 0.025380153, 0.025459908, 0.025539795, 0.025619833, 0.025699997, 0.025780289, 0.025860634, 0.025941258, 0.026021959, 0.026102893, 0.026183927, 0.026265088, 0.026346456, 0.026427923, 0.02650962, 0.026591346, 0.026673272, 0.026755355, 0.026837461, 0.026919797, 0.027002288, 0.027084984, 0.027167778, 0.02725073, 0.027333781, 0.027416984, 0.027500523, 0.027584011, 0.027667677, 0.027751494, 0.027835442, 0.027919512, 0.028003767, 0.028088173, 0.028172707, 0.028257471, 0.028342286, 0.028427253, 0.028512478, 0.028597828, 0.028683256, 0.028768837, 0.028854521, 0.028940307, 0.029026324, 0.029112492, 0.029198814, 0.029285237, 0.029371917, 0.029458778, 0.029545635, 0.029632622, 0.029719811, 0.029807234, 0.029894704, 0.0299822, 0.030069955, 0.030157935, 0.030245997, 0.030334258, 0.030422626, 0.030511221, 0.030599842, 0.030688668, 0.030777596, 0.030866677, 0.030956011, 0.031045273, 0.031134864, 0.031224456, 0.031314433, 0.03140438, 0.031494536, 0.031584769, 0.031675152, 0.031765766, 0.031856455, 0.031947352, 0.03203835, 0.032129448, 0.03222093, 0.032312259, 0.032403819, 0.032495555, 0.03258745, 0.032679491, 0.03277164, 0.032863963, 0.032956496, 0.033053979, 0.033147711, 0.033241466, 0.033335224, 0.03342893, 0.033522531, 0.033616185, 0.033709764, 0.033803418, 0.033896968, 0.033990443, 0.03408397, 0.034177393, 0.034270871, 0.034364294, 0.034457643, 0.034550987, 0.034644414, 0.034737606, 0.034830928, 0.034924123, 0.035017341, 0.035110638, 0.035203729, 0.035296898, 0.03538999, 0.035483059, 0.035576176, 0.035669193, 0.035762154, 0.035855167, 0.035948057, 0.036040973, 0.036133908, 0.036226694, 0.036319606, 0.036412392, 0.036505152, 0.036597885, 0.036690675, 0.036783356, 0.036876015, 0.036968596, 0.037061255, 0.037153833, 0.037246365, 0.037338946, 0.037431423, 0.037523877, 0.037616353, 0.037708782, 0.037801135, 0.037893511, 0.037985865, 0.038078137, 0.038170464, 0.038262658, 0.038354933, 0.03844713, 0.038539279, 0.038631402, 0.038723573, 0.038815618, 0.038907688, 0.038999729, 0.039091699, 0.039183743, 0.039275583, 0.039367549, 0.039459467, 0.039551288, 0.039643202, 0.039734986, 0.039826702, 0.039918493, 0.040010281, 0.040101893, 0.040193602, 0.040285215, 0.040376872, 0.040468484, 0.040560041, 0.040651526, 0.04074306, 0.040834516, 0.040925998, 0.041017354, 0.041108783, 0.041200217, 0.041291498, 0.041382797, 0.041474104, 0.041565351, 0.041656606, 0.041747835, 0.041838933, 0.041930113, 0.042021234, 0.042112309, 0.042203408, 0.042288408, 0.042376671, 0.042464707, 0.042552587, 0.042640418, 0.042727914, 0.042815261, 0.042902499, 0.04298941, 0.043076374, 0.04316305, 0.043249503, 0.043335848, 0.043421991, 0.043508057, 0.043593846, 0.043679532, 0.04376496, 0.043850228, 0.043935429, 0.044020321, 0.044105086, 0.044189621, 0.044274081, 0.04435841, 0.044442452, 0.044526406, 0.044610169, 0.04469363, 0.044777114, 0.044860397, 0.044943374, 0.045026194, 0.045108892, 0.045191459, 0.04527387, 0.045355979, 0.045437958, 0.04551981, 0.045601431, 0.045682974, 0.045764342, 0.045845404, 0.045926385, 0.046007086, 0.046087839, 0.04616829, 0.046248473, 0.046328619, 0.046408553, 0.046488363, 0.046567965, 0.046647366, 0.046726532, 0.046805631, 0.046884466, 0.046963274, 0.047041781, 0.047120132, 0.047198303, 0.047276352, 0.04735424, 0.047431983, 0.047509387, 0.047586739, 0.04766392, 0.047740892, 0.047817733, 0.047894396, 0.047970787, 0.048047096, 0.048123322, 0.048199199, 0.048274994, 0.04835061, 0.048425976, 0.048501313, 0.048576396, 0.048651274, 0.048725996, 0.048800521, 0.048874907, 0.048949223, 0.049023233, 0.049097113, 0.049170762, 0.049244262, 0.049317706, 0.049390849, 0.049463838, 0.049536671, 0.049609326, 0.049681898, 0.049754176, 0.04982632, 0.049898285, 0.049970072, 0.050041754, 0.050113153, 0.050184406, 0.050250009, 0.050316513, 0.050382979, 0.050449196, 0.050515238, 0.050581072, 0.050646778, 0.050712358, 0.050777599, 0.050842717, 0.050907686, 0.050972473, 0.051037002, 0.051101528, 0.051165756, 0.051229853, 0.051293693, 0.051357459, 0.051420994, 0.051484376, 0.051547501, 0.051610425, 0.051673241, 0.051735852, 0.051798396, 0.051860698, 0.051922809, 0.051984653, 0.052046422, 0.052108094, 0.052169483, 0.052230641, 0.052291676, 0.052352369, 0.052413169, 0.052473668, 0.052533962, 0.052594021, 0.052654028, 0.052713908, 0.052773483, 0.052832853, 0.052892096, 0.052951135, 0.053010069, 0.053068772, 0.053127203, 0.053185552, 0.053243667, 0.053301789, 0.053359572, 0.05341721, 0.053474635, 0.053531833, 0.053589057, 0.05364595, 0.053702667, 0.05375915, 0.05381548, 0.053871635, 0.053927761, 0.053983577, 0.05403927, 0.054094732, 0.054149963, 0.054205194, 0.054260116, 0.054314893, 0.054369409, 0.054423824, 0.054478113, 0.054532137, 0.054585967, 0.054639664, 0.054693159, 0.054746553, 0.054799687, 0.05485265, 0.054905452, 0.054958031, 0.055010475, 0.055062816, 0.055114858, 0.05516674, 0.055218425, 0.055269901, 0.055321377, 0.055372521, 0.055423487, 0.055474352, 0.05552496, 0.055575512, 0.055625819, 0.055675916, 0.055725832, 0.055775546, 0.055825159, 0.055874538, 0.055923715, 0.05597274, 0.056022763, 0.056069016, 0.056115218, 0.056161404, 0.056207493, 0.056253549, 0.056299575, 0.056345519, 0.056391411, 0.05643728, 0.056483086, 0.056528866, 0.056574631, 0.056620274, 0.056665946, 0.056711514, 0.056757085, 0.056802601, 0.056848042, 0.056893453, 0.056938816, 0.056984093, 0.057029311, 0.05707458, 0.057119735, 0.057164885, 0.057209939, 0.057254989, 0.057299979, 0.057344913, 0.057389822, 0.057434656, 0.057479493, 0.057524212, 0.057568908, 0.057613526, 0.057658155, 0.05770272, 0.057747249, 0.057791725, 0.057836164, 0.05788051, 0.05792487, 0.057969183, 0.058013406, 0.058057625, 0.058101717, 0.05814581, 0.058189858, 0.058233883, 0.058277823, 0.058321767, 0.058365628, 0.058409452, 0.058453213, 0.058496993, 0.05854062, 0.05858428, 0.058627915, 0.058671355, 0.058714878, 0.058758315, 0.058801737, 0.058845058, 0.058888413, 0.058931664, 0.058974862, 0.059018061, 0.059061203, 0.05910423, 0.059147291, 0.059190232, 0.059233136, 0.059276082, 0.059318896, 0.0593617, 0.059404444, 0.059447169, 0.059489798, 0.059532441, 0.059574988, 0.059617501, 0.059660006, 0.059702415, 0.059744745, 0.059787069, 0.059829384, 0.059871588, 0.059913788, 0.059955943, 0.059998028, 0.060040094, 0.06008213, 0.06012404, 0.060165983, 0.06020787, 0.060249649, 0.060291383, 0.060333136, 0.060374804, 0.060419489, 0.06046195, 0.060504455, 0.060547214, 0.06059004, 0.060632933, 0.060676005, 0.060719151, 0.060762532, 0.060805973, 0.060849488, 0.0608932, 0.060936913, 0.060980853, 0.061024971, 0.061069068, 0.061113436, 0.061157789, 0.06120234, 0.061247047, 0.061291765, 0.061336745, 0.061381727, 0.061426919, 0.061472114, 0.061517563, 0.061563149, 0.061608735, 0.061654545, 0.0617004, 0.061746463, 0.061792646, 0.061838813, 0.061885305, 0.061931726, 0.061978422, 0.062025174, 0.062072027, 0.062119085, 0.062166166, 0.062213436, 0.062260792, 0.062308282, 0.062355924, 0.062403645, 0.062451519, 0.062499501, 0.062547639, 0.062595963, 0.062644221, 0.062692761, 0.062741354, 0.062790088, 0.062838987, 0.062887914, 0.062937029, 0.062986188, 0.06303563, 0.063085079, 0.063134618, 0.063184433, 0.06323421, 0.063284181, 0.063334271, 0.063384458, 0.063434862, 0.063485272, 0.063535877, 0.063586615, 0.063637443, 0.06368839, 0.063739434, 0.063790649, 0.06384185, 0.06389343, 0.063945033, 0.063996658, 0.064048491, 0.064100355, 0.064152472, 0.064204685, 0.064256981, 0.064309426, 0.064361952, 0.064414665, 0.064467467, 0.064520337, 0.064573422, 0.064626537, 0.064679854, 0.064733274, 0.064786844, 0.06484054, 0.064894274, 0.064948246, 0.065002196, 0.065056361, 0.06511075, 0.065165021, 0.065219663, 0.065278135, 0.065335147, 0.065392427, 0.065449759, 0.065507591, 0.065565482, 0.06562373, 0.065681979, 0.065740786, 0.065799698, 0.065858655, 0.065918081, 0.065977708, 0.066037633, 0.066097721, 0.066157907, 0.066218615, 0.066279307, 0.066340312, 0.066401631, 0.066463143, 0.066524863, 0.066586792, 0.06664902, 0.06671156, 0.066774197, 0.066837147, 0.066900194, 0.066963702, 0.067027263, 0.067091182, 0.067155302, 0.06721963, 0.067284264, 0.067349046, 0.067414038, 0.067479491, 0.067544997, 0.067610703, 0.067676656, 0.067743033, 0.067809552, 0.067876182, 0.067943163, 0.068010405, 0.068077795, 0.068145491, 0.068213344, 0.068281606, 0.068349868, 0.068418533, 0.068487413, 0.068556488, 0.068625823, 0.068695359, 0.068765156, 0.068835199, 0.068905562, 0.068976119, 0.06904678, 0.069117852, 0.069189027, 0.0692605, 0.06933219, 0.069404185, 0.069476373, 0.069548726, 0.069621377, 0.069694385, 0.069767401, 0.069840774, 0.069914296, 0.069988281, 0.070062414, 0.070136607, 0.07021115, 0.070285998, 0.070361003, 0.070436209, 0.070511788, 0.070587605, 0.070663482, 0.070739709, 0.070816092, 0.070892833, 0.070969783, 0.071046881, 0.071124345, 0.071202002, 0.071279816, 0.07135804, 0.071436211, 0.071514949, 0.071593687, 0.071672827, 0.071751967, 0.071831621, 0.071911439, 0.071991347, 0.072071612, 0.072155312, 0.072237417, 0.072319731, 0.072402447, 0.072485529, 0.072568655, 0.072652094, 0.072735988, 0.07282009, 0.072904438, 0.072989099, 0.073073916, 0.073159292, 0.073244721, 0.073330462, 0.073416501, 0.07350295, 0.073589556, 0.073676415, 0.073763669, 0.073851198, 0.073938824, 0.074026965, 0.074115098, 0.074203797, 0.074292704, 0.074381903, 0.074471265, 0.074561089, 0.074651167, 0.074741349, 0.07483194, 0.074922882, 0.07501398, 0.075105332, 0.075197048, 0.075289212, 0.075381391, 0.075473867, 0.075566657, 0.075659901, 0.075753346, 0.075846955, 0.07594087, 0.076035179, 0.076129757, 0.076224491, 0.076319613, 0.076414965, 0.076510608, 0.076606557, 0.076702818, 0.076799288, 0.076896101, 0.076993182, 0.077090405, 0.077188201, 0.077286102, 0.077384144, 0.077482708, 0.077581525, 0.077680543, 0.077779815, 0.077879444, 0.077979438, 0.078079477, 0.07818003, 0.078280777, 0.078381792, 0.078483053, 0.078584634, 0.078686506, 0.07878875, 0.078891195, 0.078993842, 0.079096802, 0.079200208, 0.079303622, 0.079407543, 0.079511665, 0.079616055, 0.079720795, 0.079825796, 0.079930946, 0.080036558, 0.080142364, 0.08024843, 0.080354758, 0.080461591, 0.080568485, 0.080675676, 0.080783173, 0.080891088, 0.080999151, 0.081107423, 0.08121594, 0.081325069, 0.08143425, 0.081543751, 0.081653446, 0.081755832, 0.081867114, 0.081978492, 0.082090184, 0.082202129, 0.082314327, 0.082426935, 0.082539864, 0.082652882, 0.082766406, 0.082880035, 0.082994021, 0.083108321, 0.08322297, 0.08333768, 0.083452836, 0.083568253, 0.08368399, 0.083799809, 0.083916202, 0.084032699, 0.084149539, 0.084266596, 0.084384106, 0.084501632, 0.084619761, 0.084737934, 0.084856421, 0.084975317, 0.085094459, 0.085213706, 0.085333474, 0.085453391, 0.085573658, 0.085694142, 0.085815087, 0.085936025, 0.086057305, 0.086179122, 0.086301133, 0.0864233, 0.086545818, 0.086668544, 0.086791627, 0.086915068, 0.087038763, 0.087162666, 0.087286875, 0.087411545, 0.087536164, 0.087661333, 0.08778666, 0.087912247, 0.088038243, 0.088164501, 0.0882909, 0.088417768, 0.088544883, 0.088672213, 0.08879973, 0.08892782, 0.089055918, 0.08918447, 0.089313224, 0.089442395, 0.089571655, 0.089701384, 0.089831166, 0.089961447, 0.090091884, 0.090222739, 0.09035369, 0.090485156, 0.090616718, 0.090748586, 0.090880767, 0.091013357, 0.091146044, 0.091278985, 0.091412447, 0.091546051, 0.091679856, 0.091814138, 0.091948561, 0.092083238, 0.092218481, 0.092353731, 0.092489325, 0.092625238, 0.092761345, 0.092897773, 0.093034595, 0.093171686, 0.093308918, 0.093446508, 0.093584463, 0.093722574, 0.093861133, 0.093999803, 0.094138876, 0.094274566, 0.094415583, 0.094556704, 0.094698124, 0.094839707, 0.094981641, 0.095123731, 0.095266074, 0.095408678, 0.095551595, 0.095694646, 0.095838018, 0.095981538, 0.096125469, 0.096269399, 0.096413791, 0.09655828, 0.096703187, 0.09684813, 0.096993387, 0.097138949, 0.097284824, 0.097430803, 0.097577281, 0.097723722, 0.097870402, 0.098017447, 0.09816476, 0.098312154, 0.09845987, 0.09860789, 0.098756053, 0.098904535, 0.099053212, 0.09920226, 0.099351399, 0.099500842, 0.099650502, 0.09980046, 0.099950559, 0.10010109, 0.10025166, 0.10040264, 0.10055388, 0.10070527, 0.10085686, 0.10100882, 0.10116091, 0.10131328, 0.10146578, 0.10161876, 0.10177184, 0.10192516, 0.10207876, 0.10223265, 0.10238665, 0.10254105, 0.10269555, 0.10285041, 0.10300543, 0.10316076, 0.10331628, 0.10347197, 0.10362805, 0.1037844, 0.10394095, 0.1040977, 0.10425477, 0.10441194, 0.1045695, 0.10472717, 0.10488526, 0.1050434, 0.10520188, 0.10536053, 0.10551959, 0.10567869, 0.1058382, 0.10599787, 0.10615784, 0.10631801, 0.1064785, 0.10663909, 0.10680003, 0.10696118, 0.10712259, 0.10728425, 0.10744621, 0.10760833, 0.10777076, 0.10793328, 0.10809621, 0.10825925, 0.1084227, 0.1085862, 0.10875005, 0.10891411, 0.10907849, 0.10924306, 0.10940789, 0.10959313, 0.10976093, 0.10992879, 0.11009682, 0.11026493, 0.11043332, 0.11060164, 0.11077025, 0.11093889, 0.11110769, 0.11127654, 0.11144561, 0.11161478, 0.11178404, 0.11195337, 0.11212293, 0.11229253, 0.11246233, 0.11263225, 0.11280221, 0.11297237, 0.11314265, 0.11331302, 0.11348356, 0.11365419, 0.11382493, 0.11399583, 0.11416681, 0.1143381, 0.1145094, 0.11468075, 0.11485226, 0.11502388, 0.1151956, 0.11536752, 0.11553957, 0.1157117, 0.11588393, 0.11605632, 0.11622881, 0.11640138, 0.11657422, 0.11674716, 0.11692008, 0.11709321, 0.11726645, 0.11743985, 0.1176134, 0.11778695, 0.11796083, 0.11813475, 0.11830869, 0.11848284, 0.1186571, 0.11883146, 0.11900595, 0.11918058, 0.11935532, 0.11953018, 0.11970521, 0.11988033, 0.12005555, 0.12023096, 0.12040643, 0.12058204, 0.12075783, 0.12093367, 0.12110969, 0.12128577, 0.12146202, 0.12163845, 0.12181503, 0.12199159, 0.12216839, 0.12234523, 0.12252216, 0.12269933, 0.12287663, 0.12305392, 0.12323141, 0.12340902, 0.12358674, 0.12376463, 0.12394267, 0.12412069, 0.12429896, 0.12447733, 0.12465583, 0.12483439, 0.12501314, 0.12519203, 0.1253711, 0.12555017, 0.1257294, 0.12590876, 0.12608831, 0.12626795, 0.12644765, 0.12662746, 0.12680744, 0.12699006, 0.12717219, 0.1273542, 0.1275361, 0.12771797, 0.12789963, 0.12808135, 0.12826294, 0.12844436, 0.12862575, 0.12880708, 0.12898825, 0.12916939, 0.12935042, 0.12953138, 0.12971222, 0.12989299, 0.13007365, 0.13025422, 0.1304348, 0.13061519, 0.13079551, 0.13097574, 0.13115586, 0.13133591, 0.13151595, 0.13169579, 0.13187559, 0.13205531, 0.13223493, 0.13241445, 0.13259389, 0.13277325, 0.13295251, 0.13313164, 0.13331074, 0.1334898, 0.13366868, 0.1338475, 0.13402623, 0.13420488, 0.13438345, 0.13456196, 0.13474029, 0.13491857, 0.13509679, 0.1352749, 0.13545291, 0.13563089, 0.13580878, 0.13598651, 0.13616419, 0.13634174, 0.13651922, 0.13669667, 0.13687398, 0.13705118, 0.13722833, 0.13740541, 0.13758238, 0.13775928, 0.13793604, 0.13811277, 0.13828938, 0.13846585, 0.1386423, 0.13881871, 0.13899495, 0.13917112, 0.1393472, 0.13952312, 0.13969907, 0.13987495, 0.14005063, 0.14022627, 0.14040186, 0.14057732, 0.14075266, 0.14092799, 0.14110322, 0.14127828, 0.14145328, 0.14162822, 0.14180307, 0.14197791, 0.14215255, 0.14232713, 0.14250162, 0.142676, 0.14285029, 0.14302458, 0.14319868, 0.14337273, 0.1435467, 0.1437206, 0.14389439, 0.14406808, 0.14424172, 0.14441521, 0.14458862, 0.14474374, 0.14491573, 0.14508748, 0.14525871, 0.14542978, 0.14560045, 0.1457708, 0.14594084, 0.14611049, 0.14627992, 0.14644904, 0.14661781, 0.14678617, 0.14695433, 0.14712207, 0.14728959, 0.14745672, 0.14762348, 0.14779001, 0.14795622, 0.14812203, 0.14828761, 0.14845283, 0.1486177, 0.14878228, 0.14894658, 0.1491105, 0.14927417, 0.14943744, 0.14960031, 0.14976299, 0.14992535, 0.15008731, 0.15024905, 0.15041043, 0.15057136, 0.15073211, 0.15089254, 0.15105262, 0.15121238, 0.15137191, 0.15153094, 0.15168975, 0.1518482, 0.15200631, 0.15216419, 0.15232162, 0.15247884, 0.15263566, 0.15279229, 0.15294848, 0.15310439, 0.15325989, 0.15341519, 0.15357015, 0.15372467, 0.15387902, 0.15403301, 0.15418659, 0.15433995, 0.154493, 0.15464555, 0.15479808, 0.15495014, 0.15510178, 0.15525316, 0.15540422, 0.15555494, 0.15570547, 0.1558556, 0.15600526, 0.15615475, 0.156304, 0.15645275, 0.15660131, 0.15674956, 0.15689729, 0.15704483, 0.1571921, 0.1573389, 0.15748554, 0.15763174, 0.15777773, 0.15792336, 0.15806858, 0.15821362, 0.15835832, 0.15850258, 0.15864658, 0.15879026, 0.15893359, 0.15907669, 0.1592194, 0.15936178, 0.15950389, 0.15964566, 0.1597871, 0.15992817, 0.160069, 0.16020943, 0.16035084, 0.16048659, 0.16062196, 0.16075668, 0.16089101, 0.16102482, 0.16115828, 0.16129132, 0.16142386, 0.16155577, 0.16168745, 0.16181853, 0.16194925, 0.16207959, 0.1622095, 0.16233875, 0.16246752, 0.16259603, 0.16272408, 0.16285156, 0.16297874, 0.16310522, 0.16323143, 0.16335712, 0.16348252, 0.16360722, 0.16373165, 0.16385548, 0.16397893, 0.16410206, 0.1642247, 0.16434669, 0.16446826, 0.16458945, 0.16471024, 0.16483051, 0.16495042, 0.16506971, 0.16518863, 0.16530704, 0.16542512, 0.16554278, 0.16565999, 0.16577654, 0.16589268, 0.1660085, 0.16612387, 0.1662387, 0.16635305, 0.16646697, 0.16658041, 0.16669343, 0.16680607, 0.16691832, 0.1670298, 0.16714109, 0.16725191, 0.16736223, 0.16747218, 0.16758157, 0.16769041, 0.16779891, 0.16790698, 0.16801457, 0.16812177, 0.16822846, 0.16833459, 0.16844039, 0.16854584, 0.16865073, 0.16875513, 0.16885915, 0.16896258, 0.16906565, 0.16916832, 0.16927056, 0.16937214, 0.16947344, 0.16957414, 0.16967456, 0.16977455, 0.16987407, 0.16997282, 0.17007144, 0.17016955, 0.17026718, 0.17036438, 0.17046115, 0.17055735, 0.17065313, 0.17074855, 0.17084345, 0.17093788, 0.171032, 0.17112544, 0.17121859, 0.17131127, 0.17140356, 0.17149527, 0.17158656, 0.17168166, 0.17176673, 0.17185143, 0.17193574, 0.17201966, 0.17210321, 0.17218627, 0.17226909, 0.17235136, 0.17243335, 0.17251486, 0.17259596, 0.17267668, 0.17275698, 0.17283691, 0.17291647, 0.17299561, 0.17307435, 0.17315266, 0.17323068, 0.17330818, 0.17338525, 0.17346214, 0.17353846, 0.1736144, 0.17368989, 0.17376511, 0.17383985, 0.17391418, 0.17398816, 0.17406169, 0.17413479, 0.17420761, 0.17427996, 0.17435203, 0.17442359, 0.17449477, 0.17456551, 0.17463593, 0.17470586, 0.17477544, 0.17484461, 0.17491335, 0.17498176, 0.17504975, 0.17511731, 0.17518462, 0.17525141, 0.17531769, 0.17538378, 0.1754494, 0.17551453, 0.17557932, 0.17564376, 0.17570774, 0.17577137, 0.17583454, 0.17589732, 0.17595971, 0.17602177, 0.17608336, 0.17614469, 0.17620549, 0.1762659, 0.17632587, 0.17638555, 0.17644474, 0.17650355, 0.17656198, 0.17661999, 0.17667763, 0.17673489, 0.17679173, 0.17684823, 0.17690426, 0.17695986, 0.17701513, 0.17707001, 0.17712444, 0.17717843, 0.17723212, 0.17728534, 0.17733817, 0.17739069, 0.17744283, 0.1774943, 0.17754558, 0.17759651, 0.17764698, 0.17769711, 0.17774671, 0.17779596, 0.17784484, 0.17789325, 0.17794137, 0.17798904, 0.17803627, 0.1780832, 0.17812964, 0.17817578, 0.17821503, 0.17825627, 0.1782973, 0.1783382, 0.17837895, 0.17841953, 0.17845999, 0.17850031, 0.17854042, 0.17858043, 0.17862031, 0.17866001, 0.17869957, 0.17873895, 0.17877816, 0.17881729, 0.17885627, 0.17889501, 0.17893368, 0.1789722, 0.17901051, 0.17904873, 0.17908679, 0.17912464, 0.17916244, 0.17920004, 0.17923746, 0.17927478, 0.17931193, 0.1793489, 0.17938578, 0.17942247, 0.17945899, 0.17949539, 0.17953168, 0.17956772, 0.17960371, 0.17963949, 0.17967509, 0.17971064, 0.17974597, 0.17978115, 0.17981622, 0.17985111, 0.17988583, 0.17992045, 0.17995492, 0.17998917, 0.18002333, 0.18005738, 0.18009114, 0.18012486, 0.18015842, 0.18019177, 0.18022506, 0.18025814, 0.18029107, 0.18032387, 0.18035653, 0.180389, 0.18042137, 0.18045355, 0.18048558, 0.18051748, 0.18054925, 0.18058078, 0.18061224, 0.18064357, 0.18067466, 0.18070567, 0.18073654, 0.18076718, 0.18079776, 0.18082817, 0.18085834, 0.18088844, 0.18091844, 0.18094818, 0.18097785, 0.18100733, 0.18103665, 0.18106584, 0.18109493, 0.18112376, 0.18115251, 0.18118115, 0.18120953, 0.18123788, 0.18126598, 0.18129393, 0.1813218, 0.1813495, 0.18137704, 0.1814044, 0.18143165, 0.18145873, 0.18148568, 0.18151249, 0.1815391, 0.1815656, 0.18159008, 0.18161666, 0.1816435, 0.18167052, 0.18169771, 0.18172504, 0.18175261, 0.18178037, 0.18180823, 0.18183634, 0.18186465, 0.18189313, 0.18192171, 0.18195055, 0.18197961, 0.18200874, 0.18203813, 0.18206769, 0.18209746, 0.18212733, 0.18215744, 0.18218772, 0.18221818, 0.18224885, 0.18227968, 0.18231075, 0.18234187, 0.18237327, 0.18240483, 0.18243654, 0.18246847, 0.18250063, 0.18253292, 0.18256535, 0.18259802, 0.18263088, 0.18266387, 0.18269707, 0.18273047, 0.18276402, 0.18279776, 0.18283169, 0.18286581, 0.18290007, 0.18293457, 0.18296924, 0.18300413, 0.18303907, 0.18307431, 0.18310972, 0.18314528, 0.18318102, 0.18321694, 0.18325311, 0.18328933, 0.18332584, 0.18336251, 0.18339938, 0.18343639, 0.1834736, 0.18351102, 0.18354855, 0.18358633, 0.18362427, 0.18366243, 0.1837007, 0.1837392, 0.18377787, 0.18381669, 0.18385571, 0.18389496, 0.18393436, 0.18397391, 0.18401371, 0.18405366, 0.18409376, 0.18413408, 0.18417455, 0.18421525, 0.18425609, 0.18429711, 0.18433835, 0.18437973, 0.18442133, 0.18446314, 0.18450509, 0.18454719, 0.18458951, 0.18463203, 0.18467465, 0.18471757, 0.18476059, 0.18480386, 0.18484721, 0.18489082, 0.18493459, 0.18497851, 0.1850227, 0.18506701, 0.18511152, 0.1851584, 0.18520884, 0.18525964, 0.18531089, 0.18536258, 0.18541466, 0.18546705, 0.18551987, 0.18557319, 0.18562679, 0.18568093, 0.18573542, 0.18579024, 0.1858456, 0.18590124, 0.18595734, 0.18601391, 0.18607074, 0.18612808, 0.18618581, 0.18624395, 0.18630245, 0.18636139, 0.18642075, 0.18648051, 0.18654074, 0.18660124, 0.1866622, 0.18672356, 0.18678537, 0.1868476, 0.18691015, 0.18697314, 0.18703653, 0.1871004, 0.18716457, 0.18722922, 0.18729417, 0.18735968, 0.18742546, 0.18749174, 0.18755841, 0.18762538, 0.18769291, 0.18776076, 0.18782906, 0.18789765, 0.18796681, 0.18803626, 0.18810615, 0.18817645, 0.18824716, 0.18831822, 0.18838973, 0.18846166, 0.18853405, 0.18860669, 0.18867987, 0.18875341, 0.18882744, 0.18890174, 0.18897653, 0.18905163, 0.18912719, 0.18920323, 0.18927962, 0.1893564, 0.18943359, 0.18951119, 0.18958925, 0.18966755, 0.18974645, 0.18982564, 0.18990532, 0.18998531, 0.19006574, 0.19014663, 0.19022791, 0.19030949, 0.1903916, 0.19047409, 0.19055694, 0.19064023, 0.19072391, 0.19080795, 0.19089253, 0.19097739, 0.19106269, 0.19114836, 0.19123451, 0.19132103, 0.19140798, 0.1914953, 0.19158299, 0.19167116, 0.19175974, 0.1918487, 0.19193807, 0.19202779, 0.192118, 0.19221118, 0.19230913, 0.19240734, 0.19250596, 0.19260502, 0.1927045, 0.19280423, 0.19290446, 0.193005, 0.19310598, 0.19320728, 0.19330907, 0.19341105, 0.19351357, 0.19361645, 0.1937197, 0.19382335, 0.19392741, 0.19403183, 0.19413659, 0.19424181, 0.19434738, 0.19445336, 0.19455957, 0.19466631, 0.1947735, 0.19488092, 0.19498867, 0.19509706, 0.19520561, 0.19531465, 0.19542404, 0.19553378, 0.19564399, 0.19575454, 0.19586551, 0.19597684, 0.19608851, 0.19620059, 0.19631308, 0.19642596, 0.19653922, 0.19665283, 0.19676684, 0.19688123, 0.19699599, 0.19711117, 0.1972267, 0.19734265, 0.197459, 0.19757564, 0.19769277, 0.19781022, 0.19792806, 0.19804624, 0.19816497, 0.19828393, 0.19840331, 0.19852304, 0.19864327, 0.19876388, 0.19888474, 0.19900605, 0.19912767, 0.19924979, 0.19937223, 0.19949508, 0.19961831, 0.1997419, 0.19986591, 0.19999027, 0.20011505, 0.20024022, 0.20036572, 0.20049165, 0.20061794, 0.20074466, 0.20087166, 0.20099913, 0.20112698, 0.20125519, 0.20138389, 0.20151284, 0.20164219, 0.20177194, 0.20190214, 0.20203264, 0.2021635, 0.20229483, 0.20242652, 0.20255858, 0.20269103, 0.20282388, 0.20295708, 0.20309061, 0.20322469, 0.20335901, 0.20349382, 0.20362893, 0.20376441, 0.20390311, 0.20404267, 0.20418239, 0.20432222, 0.20446222, 0.20460233, 0.20474273, 0.20488316, 0.20502378, 0.20516454, 0.20530549, 0.20544653, 0.2055878, 0.20572917, 0.20587073, 0.20601241, 0.20615433, 0.20629629, 0.20643848, 0.20658077, 0.2067233, 0.20686591, 0.20700873, 0.20715167, 0.20729475, 0.20743802, 0.20758139, 0.20772503, 0.20786868, 0.20801257, 0.20815659, 0.20830077, 0.20844512, 0.20858958, 0.20873423, 0.20887905, 0.20902395, 0.20916909, 0.20931435, 0.20945975, 0.20960531, 0.20975105, 0.20989689, 0.21004298, 0.21018915, 0.21033549, 0.21048206, 0.21062867, 0.21077549, 0.21092242, 0.21106958, 0.21121682, 0.21136427, 0.21151182, 0.2116596, 0.21180743, 0.2119555, 0.21210368, 0.21225204, 0.21240057, 0.21254924, 0.21269801, 0.21284702, 0.21299614, 0.21314542, 0.21329489, 0.21344447, 0.21359421, 0.2137441, 0.21389417, 0.21404435, 0.21419476, 0.21434525, 0.21449594, 0.21464676, 0.21479778, 0.21494885, 0.21510021, 0.21525158, 0.21540321, 0.21555497, 0.21570693, 0.21585894, 0.21601121, 0.21616353, 0.21631606, 0.21646877, 0.21662161, 0.21677461, 0.21692777, 0.2170811, 0.21723451, 0.21738812, 0.21754186, 0.21769583, 0.2178499, 0.21800412, 0.21815848, 0.21831307, 0.21846771, 0.21862189, 0.21877472, 0.21892743, 0.21908003, 0.21923256, 0.21938495, 0.21953721, 0.21968943, 0.2198415, 0.21999344, 0.22014533, 0.22029708, 0.22044873, 0.22060026, 0.22075173, 0.22090307, 0.2210543, 0.22120541, 0.22135642, 0.22150733, 0.22165816, 0.22180884, 0.22195944, 0.22210991, 0.2222603, 0.2224106, 0.22256075, 0.2227108, 0.22286081, 0.22301063, 0.22316037, 0.22331002, 0.22345956, 0.22360896, 0.2237583, 0.2239075, 0.22405662, 0.22420564, 0.22435452, 0.22450332, 0.22465204, 0.2248006, 0.22494906, 0.22509745, 0.2252457, 0.22539385, 0.22554192, 0.22568986, 0.22583769, 0.22598544, 0.22613306, 0.22628057, 0.22642802, 0.22657533, 0.22672249, 0.22686961, 0.22701658, 0.22716348, 0.22731027, 0.22745694, 0.22760352, 0.22774996, 0.22789633, 0.22804259, 0.22818872, 0.22833477, 0.2284807, 0.22862653, 0.22877227, 0.22891787, 0.22906336, 0.2292088, 0.22935408, 0.22949927, 0.22964434, 0.22978935, 0.2299342, 0.23007898, 0.23022364, 0.23036818, 0.23051263, 0.23065698, 0.23080122, 0.23094536, 0.23108938, 0.23123331, 0.23137709, 0.23152082, 0.23166443, 0.23180793, 0.23195131, 0.2320946, 0.23223779, 0.23238085, 0.23252383, 0.23266669, 0.23280942, 0.2329521, 0.23309462, 0.23323704, 0.23337445, 0.23351254, 0.23365037, 0.23378798, 0.23392531, 0.23406243, 0.23419927, 0.23433588, 0.23447224, 0.23460837, 0.23474422, 0.23487981, 0.2350152, 0.23515029, 0.23528515, 0.23541979, 0.23555419, 0.23568827, 0.23582217, 0.2359558, 0.23608916, 0.23622231, 0.23635519, 0.23648778, 0.23662022, 0.23675233, 0.23688422, 0.23701587, 0.23714729, 0.2372784, 0.23740931, 0.23753996, 0.23767033, 0.23780051, 0.23793037, 0.23806007, 0.23818947, 0.23831864, 0.23844755, 0.23857622, 0.23870459, 0.23883279, 0.23896071, 0.23908837, 0.23921581, 0.239343, 0.2394699, 0.23959659, 0.23972303, 0.23984919, 0.23997512, 0.24010085, 0.24022625, 0.24035144, 0.24047637, 0.24060106, 0.24072552, 0.2408497, 0.24097368, 0.24109738, 0.24122082, 0.24134403, 0.24146701, 0.2415897, 0.24171214, 0.24183437, 0.24195632, 0.24207804, 0.24219951, 0.24232075, 0.2424417, 0.24256241, 0.24268289, 0.24280311, 0.2429231, 0.24304281, 0.24316232, 0.24328153, 0.24340054, 0.24351926, 0.24363776, 0.24375601, 0.243874, 0.24399175, 0.24410923, 0.24422647, 0.24434349, 0.24446024, 0.24457675, 0.244693, 0.244809, 0.24492477, 0.24504028, 0.24515551, 0.24527054, 0.24538533, 0.24549983, 0.24561413, 0.24572812, 0.24584191, 0.24595585, 0.24606608, 0.24617605, 0.24628574, 0.24639522, 0.2465044, 0.24661334, 0.24672209, 0.24683055, 0.24693877, 0.24704675, 0.24715447, 0.24726191, 0.24736914, 0.24747607, 0.24758279, 0.24768929, 0.24779548, 0.24790145, 0.24800718, 0.24811265, 0.24821787, 0.24832283, 0.24842757, 0.24853203, 0.24863629, 0.24874024, 0.24884398, 0.24894744, 0.24905066, 0.24915367, 0.2492564, 0.24935885, 0.24946108, 0.24956308, 0.2496648, 0.24976628, 0.24986751, 0.24996853, 0.25006926, 0.25016975, 0.25026998, 0.25036997, 0.25046971, 0.25056919, 0.25066841, 0.25076744, 0.25086617, 0.25096464, 0.2510629, 0.25116089, 0.25125864, 0.25135612, 0.25145337, 0.25155035, 0.25164711, 0.25174361, 0.25183988, 0.25193587, 0.25203162, 0.25212714, 0.25222242, 0.2523174, 0.25241214, 0.25250661, 0.25260088, 0.25269488, 0.25278866, 0.25288215, 0.2529754, 0.25306842, 0.25316119, 0.2532537, 0.25334597, 0.25343797, 0.25352973, 0.25362122, 0.25371253, 0.25380352, 0.2538943, 0.25398481, 0.25407508, 0.25416508, 0.25425488, 0.25434437, 0.25443366, 0.25452268, 0.25461146, 0.25469998, 0.25478825, 0.25487629, 0.25496408, 0.25505161, 0.25513884, 0.2552259, 0.25531265, 0.2553992, 0.25548548, 0.25557148, 0.25565726, 0.25574279, 0.25582695, 0.25591087, 0.25599465, 0.25607827, 0.25616172, 0.25624505, 0.25632814, 0.25641111, 0.25649393, 0.25657657, 0.25665903, 0.25674134, 0.25682348, 0.25690547, 0.2569873, 0.25706893, 0.25715041, 0.25723177, 0.25731289, 0.25739393, 0.25747478, 0.25755545, 0.25763595, 0.2577163, 0.2577965, 0.25787646, 0.25795636, 0.25803602, 0.25811556, 0.25819492, 0.25827411, 0.25835314, 0.258432, 0.25851071, 0.25858924, 0.25866765, 0.25874585, 0.25882387, 0.25890177, 0.2589795, 0.25905707, 0.25913447, 0.25921169, 0.25928876, 0.25936568, 0.25944239, 0.25951895, 0.25959539, 0.25967163, 0.25974771, 0.25982365, 0.25989938, 0.25997499, 0.26005042, 0.26012567, 0.2602008, 0.26027572, 0.2603505, 0.26042509, 0.26049954, 0.26057383, 0.26064798, 0.26072189, 0.26079571, 0.26086932, 0.26094279, 0.26101607, 0.26108921, 0.26116219, 0.26123497, 0.26130763, 0.26138014, 0.26145244, 0.26152459, 0.26159659, 0.26166838, 0.26174006, 0.26181155, 0.2618829, 0.26195404, 0.26202506, 0.26209593, 0.26216659, 0.26223707, 0.26230744, 0.26237762, 0.26244769, 0.26251751, 0.26258719, 0.26265672, 0.2627261, 0.2627953, 0.26286435, 0.26293322, 0.26300195, 0.26307049, 0.26313886, 0.26320711, 0.26327515, 0.26334453, 0.26341322, 0.2634818, 0.26355034, 0.2636188, 0.26368716, 0.2637555, 0.26382372, 0.26389188, 0.26395997, 0.26402801, 0.26409599, 0.26416385, 0.26423168, 0.26429942, 0.2643671, 0.26443473, 0.26450226, 0.26456973, 0.26463714, 0.26470447, 0.26477173, 0.26483893, 0.26490605, 0.26497307, 0.26504007, 0.26510695, 0.26517379, 0.26524058, 0.26530728, 0.26537392, 0.26544046, 0.26550695, 0.26557338, 0.26563972, 0.265706, 0.26577222, 0.26583833, 0.2659044, 0.26597041, 0.26603633, 0.26610219, 0.26616797, 0.26623371, 0.26629934, 0.26636493, 0.26643044, 0.26649585, 0.26656124, 0.26662651, 0.26669177, 0.26675692, 0.26682201, 0.26688701, 0.26695198, 0.26701683, 0.26708162, 0.26714638, 0.26721105, 0.26727563, 0.26734015, 0.26740462, 0.26746899, 0.2675333, 0.26759756, 0.26766172, 0.26772586, 0.26778984, 0.26785386, 0.26791772, 0.26798156, 0.26804531, 0.26810899, 0.26817259, 0.26823613, 0.26829964, 0.268363, 0.26842636, 0.2684896, 0.26855281, 0.26861593, 0.26867896, 0.26874197, 0.26880488, 0.26886773, 0.26893049, 0.26899317, 0.26905581, 0.26911837, 0.26918086, 0.2692433, 0.26930565, 0.2693679, 0.26943013, 0.26949227, 0.26955435, 0.26961634, 0.26967826, 0.26974013, 0.26980191, 0.26986474, 0.2699278, 0.26999089, 0.27005392, 0.27011696, 0.27017996, 0.27024293, 0.2703059, 0.27036884, 0.27043176, 0.27049464, 0.27055752, 0.27062038, 0.2706832, 0.27074602, 0.27080882, 0.27087158, 0.27093431, 0.27099705, 0.27105975, 0.27112243, 0.27118513, 0.27124774, 0.27131039, 0.27137297, 0.27143556, 0.27149811, 0.27156067, 0.27162319, 0.27168566, 0.27174816, 0.27181059, 0.27187306, 0.27193546, 0.27199784, 0.27206022, 0.27212259, 0.27218491, 0.27224723, 0.27230951, 0.27237177, 0.27243403, 0.27249625, 0.27255845, 0.27262065, 0.27268279, 0.27274492, 0.27280706, 0.27286917, 0.27293125, 0.2729933, 0.27305532, 0.27311733, 0.27317932, 0.27324131, 0.27330327, 0.2733652, 0.2734271, 0.273489, 0.27355087, 0.27361271, 0.27367452, 0.27373636, 0.27379811, 0.27385989, 0.27392164, 0.27398336, 0.27404508, 0.27410677, 0.2741684, 0.27423003, 0.27429166, 0.27435327, 0.27441484, 0.27447641, 0.27453792, 0.27459943, 0.27466092, 0.2747224, 0.27478385, 0.2748453, 0.27490669, 0.27496806, 0.27502945, 0.27509078, 0.27515212, 0.27521342, 0.27527469, 0.27533597, 0.27539718, 0.27545843, 0.27551961, 0.27558079, 0.27564195, 0.2757031, 0.2757642, 0.27582529, 0.27588636, 0.27594742, 0.27600846, 0.27607116, 0.2761333, 0.27619541, 0.27625749, 0.27631956, 0.27638161, 0.27644363, 0.27650562, 0.27656758, 0.27662954, 0.27669147, 0.27675337, 0.27681524, 0.27687711, 0.27693895, 0.27700078, 0.27706257, 0.27712435, 0.27718607, 0.27724782, 0.27730951, 0.2773712, 0.27743286, 0.27749449, 0.27755612, 0.27761769, 0.27767926, 0.27774081, 0.27780238, 0.27786386, 0.27792534, 0.27798679, 0.27804822, 0.27810964, 0.27817103, 0.2782324, 0.27829376, 0.27835506, 0.27841637, 0.27847767, 0.27853891, 0.27860016, 0.27866137, 0.27872255, 0.27878374, 0.27884486, 0.27890599, 0.27896711, 0.27902818, 0.27908924, 0.27915028, 0.27921128, 0.27927229, 0.27933323, 0.27939418, 0.27945513, 0.27951601, 0.2795769, 0.27963772, 0.27969858, 0.27975941, 0.27982017, 0.27988094, 0.27994168, 0.28000242, 0.28006312, 0.2801238, 0.28018445, 0.28024507, 0.28030568, 0.28036627, 0.28042683, 0.28048736, 0.28054789, 0.28060842, 0.28066888, 0.28072932, 0.28078976, 0.28085017, 0.28091055, 0.28097093, 0.28103125, 0.28109157, 0.28115189, 0.28121215, 0.28127238, 0.28133264, 0.28139284, 0.28145301, 0.28151318, 0.28157333, 0.28163344, 0.28169355, 0.2817536, 0.28181368, 0.2818737, 0.2819337, 0.28199369, 0.28205365, 0.28211358, 0.28217474, 0.28223544, 0.28229603, 0.28235659, 0.28241709, 0.28247753, 0.28253788, 0.28259817, 0.28265843, 0.2827186, 0.28277871, 0.28283876, 0.28289872, 0.28295866, 0.28301853, 0.28307831, 0.28313804, 0.2831977, 0.28325731, 0.28331688, 0.28337634, 0.28343576, 0.2834951, 0.2835544, 0.28361362, 0.28367281, 0.28373191, 0.28379092, 0.28384992, 0.28390884, 0.28396767, 0.28402644, 0.28408515, 0.28414384, 0.28420243, 0.28426096, 0.28431943, 0.28437784, 0.2844362, 0.28449449, 0.28455269, 0.28461084, 0.28466895, 0.28472698, 0.28478494, 0.28484282, 0.28490067, 0.28495845, 0.28501618, 0.28507382, 0.28513139, 0.28518891, 0.28524637, 0.2853038, 0.28536114, 0.28541839, 0.28547558, 0.28553274, 0.28558981, 0.28564686, 0.28570381, 0.28576067, 0.28581753, 0.28587431, 0.28593102, 0.28598765, 0.28604421, 0.28610075, 0.28615716, 0.28621358, 0.2862699, 0.28632617, 0.28638235, 0.28643849, 0.28649458, 0.28655058, 0.28660652, 0.2866624, 0.28671825, 0.28677398, 0.28682971, 0.28688532, 0.28694087, 0.28699639, 0.28705183, 0.2871072, 0.28716254, 0.2872178, 0.28727299, 0.28732809, 0.28738317, 0.28743815, 0.28749311, 0.28754798, 0.28760281, 0.28765753, 0.28771222, 0.28776684, 0.28782138, 0.28787589, 0.28792918, 0.28798354, 0.28803778, 0.2880919, 0.2881459, 0.28819978, 0.28825355, 0.28830719, 0.28836069, 0.28841406, 0.28846735, 0.28852049, 0.2885735, 0.28862643, 0.28867921, 0.28873187, 0.28878441, 0.28883684, 0.28888914, 0.28894132, 0.28899336, 0.2890453, 0.2890971, 0.28914881, 0.2892004, 0.28925183, 0.28930318, 0.28935435, 0.28940547, 0.28945643, 0.28950727, 0.28955796, 0.2896086, 0.28965905, 0.28970945, 0.28975967, 0.28980976, 0.28985977, 0.28990966, 0.2899594, 0.29000905, 0.29005855, 0.29010791, 0.2901572, 0.29020634, 0.29025534, 0.29030424, 0.29035306, 0.29040173, 0.29045025, 0.29049864, 0.29054698, 0.29059511, 0.29064319, 0.29069111, 0.29073894, 0.29078662, 0.29083419, 0.29088163, 0.29092896, 0.29097617, 0.29102325, 0.29107022, 0.29111707, 0.29116377, 0.29121038, 0.29125684, 0.29130319, 0.29134944, 0.29139557, 0.29144153, 0.2914874, 0.29153314, 0.2915788, 0.29162428, 0.2916697, 0.29171494, 0.29176009, 0.29180512, 0.29185, 0.29189479, 0.29193947, 0.29198396, 0.2920284, 0.29207268, 0.29211685, 0.2921609, 0.29220483, 0.29224867, 0.29229233, 0.2923359, 0.29237935, 0.29242265, 0.29246587, 0.29250896, 0.29255193, 0.29259473, 0.29263747, 0.29268008, 0.29272258, 0.29276407, 0.29280573, 0.29284716, 0.29288846, 0.29292962, 0.2929706, 0.2930114, 0.29305199, 0.29309246, 0.29313278, 0.2931729, 0.29321283, 0.29325265, 0.29329219, 0.29333168, 0.29337096, 0.29341003, 0.29344895, 0.29348776, 0.29352632, 0.29356474, 0.293603, 0.29364109, 0.29367903, 0.29371673, 0.29375434, 0.29379171, 0.29382896, 0.29386604, 0.29390293, 0.29393962, 0.29397619, 0.29401261, 0.29404882, 0.29408488, 0.29412073, 0.29415643, 0.29419196, 0.29422733, 0.2942625, 0.29429755, 0.29433241, 0.29436707, 0.29440162, 0.29443595, 0.29447013, 0.29450414, 0.29453799, 0.29457167, 0.2946052, 0.29463845, 0.29467162, 0.29470462, 0.29473746, 0.29477012, 0.29480255, 0.29483488, 0.29486701, 0.29489896, 0.29493079, 0.29496244, 0.29499388, 0.29502517, 0.29505628, 0.29508728, 0.29511803, 0.29514861, 0.29517907, 0.29520935, 0.29523945, 0.2952694, 0.29529914, 0.29532877, 0.29535815, 0.29538739, 0.2954165, 0.29544544, 0.29547417, 0.29550272, 0.29553112, 0.29555938, 0.29558742, 0.29561535, 0.29564309, 0.2956706, 0.29569799, 0.2957252, 0.29575226, 0.29577914, 0.29580584, 0.29583237, 0.29585877, 0.29588497, 0.29591098, 0.29593682, 0.29596254, 0.29598805, 0.29601341, 0.2960386, 0.29606357, 0.29608715, 0.29611114, 0.29613501, 0.29615864, 0.2961821, 0.29620537, 0.29622841, 0.2962513, 0.29627395, 0.29629645, 0.29631871, 0.29634073, 0.29636264, 0.29638433, 0.29640582, 0.2964271, 0.2964482, 0.29646912, 0.29648983, 0.29651037, 0.29653066, 0.29655081, 0.29657075, 0.29659048, 0.29661003, 0.29662937, 0.2966485, 0.29666746, 0.29668623, 0.29670477, 0.29672313, 0.29674134, 0.29675928, 0.29677704, 0.29679462, 0.29681203, 0.29682925, 0.29684627, 0.29686305, 0.29687968, 0.29689607, 0.29691228, 0.29692832, 0.29694414, 0.29695976, 0.2969752, 0.29699045, 0.2970055, 0.29702032, 0.29703498, 0.29704946, 0.29706371, 0.29707778, 0.29709169, 0.29710534, 0.29711884, 0.2971321, 0.29714522, 0.29715812, 0.29717082, 0.29718331, 0.29719561, 0.29720771, 0.29721963, 0.29723138, 0.29724288, 0.29725423, 0.29726538, 0.29727632, 0.29728708, 0.29729766, 0.29730797, 0.29731816, 0.29732814, 0.29733789, 0.29734746, 0.29735684, 0.29736602, 0.29737502, 0.29738382, 0.2973924, 0.29740083, 0.297409, 0.29741701, 0.29742482, 0.29743245, 0.2974399, 0.29744712, 0.29745412, 0.29746097, 0.29746765, 0.29747409, 0.29748034, 0.29748642, 0.2974923, 0.29749793, 0.29750338, 0.29750869, 0.29751378, 0.29751867, 0.29752368, 0.29752842, 0.29753298, 0.2975373, 0.29754141, 0.29754531, 0.29754901, 0.29755247, 0.29755571, 0.29755875, 0.29756156, 0.29756418, 0.29756659, 0.29756874, 0.29757074, 0.29757249, 0.29757404, 0.29757538, 0.29757646, 0.29757741, 0.29757807, 0.29757851, 0.29757881, 0.29757884, 0.29757866, 0.29757825, 0.29757768, 0.29757684, 0.2975758, 0.29757455, 0.29757312, 0.29757145, 0.29756954, 0.29756743, 0.29756513, 0.2975626, 0.29755986, 0.29755688, 0.29755372, 0.29755032, 0.29754671, 0.29754293, 0.29753891, 0.29753464, 0.29753017, 0.2975255, 0.29752061, 0.29751551, 0.29751021, 0.29750466, 0.29749891, 0.29749298, 0.29748678, 0.29748043, 0.29747379, 0.29746696, 0.29745996, 0.29745272, 0.29744527, 0.29743758, 0.29742971, 0.2974216, 0.29741329, 0.29740474, 0.297396, 0.29738703, 0.29737788, 0.29736847, 0.2973589, 0.29734907, 0.29733902, 0.2973288, 0.29731834, 0.2973077, 0.29729676, 0.29728565, 0.29727435, 0.29726282, 0.29725108, 0.29723912, 0.29722694, 0.29721457, 0.29720193, 0.29718915, 0.29717612, 0.29716286, 0.29714942, 0.29713571, 0.29712182, 0.29710776, 0.29709345, 0.29707894, 0.29706413, 0.29704919, 0.29703403, 0.29701865, 0.29700303, 0.29698727, 0.2969712, 0.29695496, 0.2969386, 0.29692224, 0.29690555, 0.29688868, 0.29687157, 0.29685417, 0.29683656, 0.2968187, 0.29680061, 0.29678226, 0.29676366, 0.29674482, 0.29672572, 0.29670638, 0.2966868, 0.29666695, 0.29664689, 0.2966266, 0.29660606, 0.29658526, 0.29656419, 0.29654291, 0.29652137, 0.29649961, 0.29647756, 0.29645529, 0.29643276, 0.29641002, 0.29638699, 0.29636377, 0.29634026, 0.2963165, 0.29629254, 0.29626831, 0.29624382, 0.29621908, 0.29619411, 0.29616892, 0.29614344, 0.29611778, 0.29609182, 0.29606563, 0.29603919, 0.29601249, 0.29598558, 0.29595843, 0.29593101, 0.29590333, 0.2958754, 0.29584727, 0.2958189, 0.29579023, 0.29576135, 0.29573226, 0.29570284, 0.29567322, 0.29564336, 0.29561323, 0.29558289, 0.29555231, 0.29552141, 0.29549038, 0.29545903, 0.29542744, 0.29539564, 0.29536355, 0.29533124, 0.29529867, 0.29526585, 0.2952328, 0.29519951, 0.29516596, 0.29513219, 0.29509816, 0.29506388, 0.29502937, 0.29499462, 0.2949596, 0.29492438, 0.29488885, 0.29485306, 0.29481709, 0.29478088, 0.29474437, 0.29470769, 0.2946707, 0.29463351, 0.29459605, 0.29455835, 0.29452035, 0.2944822, 0.29444376, 0.29440507, 0.29436615, 0.29432696, 0.29428753, 0.2942479, 0.29420793, 0.29416782, 0.2941274, 0.2940855, 0.29404235, 0.29399893, 0.2939553, 0.2939114, 0.29386729, 0.29382297, 0.29377836, 0.29373354, 0.29368848, 0.29364321, 0.29359764, 0.29355186, 0.29350591, 0.29345965, 0.29341316, 0.29336643, 0.29331952, 0.29327232, 0.29322487, 0.29317722, 0.29312932, 0.29308122, 0.29303288, 0.29298425, 0.29293543, 0.29288635, 0.29283705, 0.29278752, 0.29273772, 0.29268771, 0.29263747, 0.29258698, 0.29253626, 0.2924853, 0.2924341, 0.29238266, 0.29233098, 0.29227909, 0.29222697, 0.29217461, 0.29212198, 0.29206914, 0.29201606, 0.29196271, 0.29190919, 0.29185539, 0.29180136, 0.29174709, 0.29169261, 0.29163787, 0.29158288, 0.29152769, 0.29147223, 0.29141656, 0.29136068, 0.29130453, 0.29124814, 0.29119149, 0.29113463, 0.29107755, 0.29102021, 0.29096264, 0.29090488, 0.29084682, 0.29078856, 0.29073003, 0.29067129, 0.29061231, 0.29055306, 0.29049364, 0.29043394, 0.29037401, 0.29031384, 0.29025346, 0.29019281, 0.29013199, 0.29007086, 0.29000953, 0.28994796, 0.28988612, 0.28982407, 0.28976178, 0.28969929, 0.28963652, 0.28957352, 0.28951031, 0.28944683, 0.28938311, 0.28931922, 0.28925502, 0.28919062, 0.28912598, 0.2890611, 0.28899598, 0.28893062, 0.28886503, 0.2887992, 0.28873315, 0.28866687, 0.28859892, 0.2885288, 0.28845856, 0.28838822, 0.28831777, 0.2882472, 0.28817648, 0.2881057, 0.2880348, 0.28796378, 0.28789264, 0.28782141, 0.28775007, 0.2876786, 0.28760701, 0.28753534, 0.28746355, 0.28739163, 0.28731963, 0.28724751, 0.28717524, 0.28710291, 0.28703043, 0.28695786, 0.28688517, 0.28681237, 0.28673947, 0.28666645, 0.28659332, 0.28652003, 0.28644669, 0.28637323, 0.28629965, 0.28622594, 0.28615218, 0.28607824, 0.28600425, 0.28593007, 0.28585583, 0.28578147, 0.285707, 0.28563243, 0.28555772, 0.28548294, 0.28540799, 0.28533298, 0.28525785, 0.2851826, 0.2851072, 0.28503174, 0.28495616, 0.28488046, 0.28480464, 0.28472874, 0.28465271, 0.28457657, 0.2845003, 0.28442395, 0.28434744, 0.28427088, 0.28419417, 0.28411737, 0.28404042, 0.28396338, 0.28388625, 0.28380901, 0.28373164, 0.28365412, 0.28357655, 0.28349885, 0.28342104, 0.28334311, 0.28326505, 0.28318688, 0.28310865, 0.28303027, 0.2829518, 0.28287318, 0.28279448, 0.28271568, 0.28263673, 0.2825577, 0.28247854, 0.28239927, 0.28231987, 0.28224042, 0.28216082, 0.28208113, 0.28200126, 0.28192133, 0.28184131, 0.28176114, 0.28168088, 0.28160051, 0.28152001, 0.28143942, 0.28135869, 0.28127787, 0.28119692, 0.28111589, 0.28103453, 0.28095293, 0.28087145, 0.28079006, 0.28070879, 0.28062758, 0.28054646, 0.28046545, 0.28038454, 0.28030372, 0.28022295, 0.28014231, 0.28006175, 0.27998129, 0.27990091, 0.27982065, 0.27974048, 0.27966037, 0.27958038, 0.27950048, 0.27942067, 0.27934095, 0.27926129, 0.27918178, 0.27910236, 0.27902299, 0.27894372, 0.27886459, 0.2787855, 0.27870652, 0.27862763, 0.27854884, 0.27847016, 0.27839154, 0.27831301, 0.27823457, 0.27815628, 0.27807805, 0.27799988, 0.27792186, 0.27784389, 0.27776602, 0.27768824, 0.27761054, 0.27753296, 0.27745551, 0.27737808, 0.27730078, 0.27722356, 0.27714643, 0.27706939, 0.27699247, 0.27691561, 0.27683884, 0.27676222, 0.27668563, 0.27660918, 0.27653277, 0.27645651, 0.2763803, 0.27630419, 0.27622819, 0.27615225, 0.27607641, 0.27600071, 0.27592504, 0.27584952, 0.27577403, 0.27569869, 0.27562341, 0.27554825, 0.27547315, 0.27539819, 0.27532327, 0.27524844, 0.27517375, 0.27509913, 0.27502459, 0.27495018, 0.27487582, 0.27480158, 0.2747274, 0.27465335, 0.27457938, 0.2745055, 0.27443174, 0.274358, 0.27428442, 0.27421093, 0.2741375, 0.27406415, 0.27399096, 0.27391779, 0.27384475, 0.27377182, 0.27369896, 0.27362621, 0.27355352, 0.27348092, 0.27340844, 0.27333769, 0.27326876, 0.27320006, 0.27313161, 0.27306339, 0.27299544, 0.27292773, 0.27286023, 0.27279299, 0.272726, 0.27265924, 0.27259275, 0.27252647, 0.27246046, 0.27239466, 0.27232909, 0.27226382, 0.27219877, 0.27213398, 0.27206939, 0.27200508, 0.27194101, 0.27187714, 0.27181357, 0.27175018, 0.27168709, 0.27162424, 0.27156159, 0.27149922, 0.27143705, 0.27137518, 0.27131352, 0.2712521, 0.27119091, 0.27113, 0.27106932, 0.27100888, 0.27094868, 0.27088872, 0.27082899, 0.27076954, 0.27071029, 0.27065134, 0.27059257, 0.27053407, 0.2704758, 0.27041781, 0.27036005, 0.27030247, 0.27024522, 0.27018818, 0.27013138, 0.27007481, 0.27001852, 0.26996243, 0.26990658, 0.269851, 0.26979569, 0.26974055, 0.26968572, 0.26963109, 0.2695767, 0.26952258, 0.26946869, 0.26941505, 0.26936164, 0.26930848, 0.26925555, 0.26920289, 0.26915047, 0.26909825, 0.26904634, 0.2689946, 0.26894313, 0.26889193, 0.26884094, 0.26879022, 0.26873973, 0.26868948, 0.26863948, 0.26858971, 0.26854017, 0.26849091, 0.26844189, 0.26839307, 0.26834452, 0.26829624, 0.26824817, 0.26820034, 0.26815277, 0.26810545, 0.26805833, 0.26801148, 0.2679649, 0.2679185, 0.26787239, 0.26782653, 0.26778087, 0.26773548, 0.2676903, 0.26764774, 0.26760757, 0.26756766, 0.267528, 0.26748854, 0.26744935, 0.2674104, 0.26737168, 0.26733318, 0.26729494, 0.26725692, 0.26721913, 0.26718161, 0.26714432, 0.26710728, 0.26707044, 0.26703385, 0.26699752, 0.2669614, 0.26692554, 0.2668899, 0.26685449, 0.26681936, 0.26678446, 0.26674977, 0.26671532, 0.26668113, 0.26664716, 0.26661342, 0.26657996, 0.2665467, 0.26651368, 0.26648092, 0.26644838, 0.26641607, 0.26638401, 0.26635221, 0.26632062, 0.26628926, 0.26625815, 0.26622728, 0.26619667, 0.26616627, 0.26613611, 0.26610619, 0.26607651, 0.26604709, 0.26601785, 0.26598889, 0.26596016, 0.2659317, 0.26590344, 0.2658754, 0.26584762, 0.26582009, 0.26579279, 0.26576573, 0.2657389, 0.26571232, 0.26568598, 0.26565987, 0.265634, 0.26560837, 0.26558295, 0.26555783, 0.26553288, 0.26550817, 0.26548377, 0.26545954, 0.26543558, 0.26541182, 0.26538837, 0.26536509, 0.26534209, 0.26531929, 0.26529676, 0.26527447, 0.26525238, 0.26523057, 0.26520899, 0.26518765, 0.26516652, 0.26514563, 0.26512498, 0.26510462, 0.26508445, 0.26506451, 0.26504484, 0.26502541, 0.26500618, 0.2649872, 0.26496848, 0.26494998, 0.26493174, 0.26491371, 0.26489592, 0.26487839, 0.26486108, 0.264844, 0.26482719, 0.26481193, 0.26479825, 0.26478466, 0.26477119, 0.26475781, 0.26474449, 0.26473126, 0.26471812, 0.26470506, 0.26469207, 0.26467919, 0.26466641, 0.26465368, 0.26464105, 0.26462853, 0.26461604, 0.26460367, 0.2645914, 0.26457921, 0.26456711, 0.26455507, 0.26454312, 0.26453128, 0.26451954, 0.26450783, 0.26449624, 0.2644847, 0.26447329, 0.26446196, 0.2644507, 0.26443955, 0.2644285, 0.26441747, 0.26440659, 0.26439574, 0.26438501, 0.26437435, 0.26436377, 0.26435331, 0.2643429, 0.26433262, 0.2643224, 0.26431227, 0.26430222, 0.26429227, 0.26428241, 0.2642726, 0.26426288, 0.26425326, 0.26424375, 0.2642343, 0.26422492, 0.26421568, 0.26420647, 0.26419735, 0.26418835, 0.26417941, 0.26417059, 0.2641618, 0.26415315, 0.26414457, 0.26413608, 0.26412767, 0.26411933, 0.2641111, 0.26410294, 0.26409486, 0.26408687, 0.26407897, 0.26407114, 0.26406345, 0.26405579, 0.26404822, 0.26404077, 0.26403338, 0.26402608, 0.26401886, 0.26401174, 0.26400474, 0.26399776, 0.26399091, 0.26398411, 0.26397741, 0.26397082, 0.2639643, 0.26395786, 0.26395151, 0.26394525, 0.26393905, 0.26393297, 0.26392698, 0.26392105, 0.26391521, 0.26390946, 0.26390383, 0.26389822, 0.26389271, 0.26388735, 0.26388201, 0.2638768, 0.26387081, 0.26386499, 0.26385906, 0.26385301, 0.26384684, 0.26384062, 0.26383418, 0.26382771, 0.2638211, 0.26381439, 0.26380756, 0.26380062, 0.26379359, 0.26378641, 0.26377913, 0.26377174, 0.26376426, 0.26375663, 0.26374891, 0.26374108, 0.26373315, 0.26372507, 0.26371691, 0.26370862, 0.26370025, 0.26369175, 0.26368311, 0.26367438, 0.26366556, 0.26365662, 0.26364756, 0.26363838, 0.26362911, 0.26361969, 0.26361021, 0.26360059, 0.26359084, 0.26358101, 0.26357102, 0.26356098, 0.26355079, 0.26354051, 0.26353011, 0.26351959, 0.26350898, 0.26349825, 0.2634874, 0.26347643, 0.26346537, 0.26345417, 0.26344287, 0.26343146, 0.26341996, 0.26340833, 0.26339659, 0.26338473, 0.26337275, 0.26336068, 0.26334852, 0.26333621, 0.26332381, 0.26331127, 0.26329863, 0.26328591, 0.26327303, 0.26326007, 0.26324698, 0.26323378, 0.26322049, 0.26320708, 0.26319355, 0.2631799, 0.26316616, 0.2631523, 0.26313832, 0.26312426, 0.26311001, 0.26309574, 0.26308131, 0.26306677, 0.26305211, 0.26303735, 0.26302251, 0.26300755, 0.26299244, 0.26297721, 0.26296192, 0.26294649, 0.26293096, 0.26291531, 0.26289955, 0.26288366, 0.26286769, 0.2628516, 0.26283538, 0.26281908, 0.26280263, 0.26278609, 0.26276943, 0.26275268, 0.26273388, 0.26271406, 0.262694, 0.26267374, 0.2626532, 0.2626324, 0.26261139, 0.26259011, 0.26256862, 0.26254684, 0.26252484, 0.26250258, 0.26248011, 0.26245737, 0.26243439, 0.26241115, 0.26238766, 0.26236397, 0.26234004, 0.26231581, 0.26229137, 0.26226667, 0.26224172, 0.26221657, 0.26219112, 0.26216546, 0.26213956, 0.26211339, 0.26208699, 0.26206034, 0.26203343, 0.26200631, 0.26197892, 0.2619513, 0.26192343, 0.2618953, 0.26186696, 0.26183835, 0.2618095, 0.26178041, 0.26175106, 0.26172152, 0.26169166, 0.26166159, 0.26163128, 0.26160073, 0.26156992, 0.26153886, 0.26150757, 0.26147604, 0.26144427, 0.26141226, 0.26137996, 0.26134744, 0.26131469, 0.26128167, 0.26124844, 0.26121494, 0.26118124, 0.26114723, 0.26111302, 0.26107854, 0.26104382, 0.26100886, 0.26097366, 0.2609382, 0.26090249, 0.26086658, 0.2608304, 0.26079398, 0.2607573, 0.26072037, 0.26068