// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:54:37 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "850" [Number of trees in the forest]
MaxDepth: "3" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.550011345844265);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47497, 1, 1, 0.884664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427816,-99) , 
0, 0.316998, 1, 0, 0.575884,-99) , 
3, 1.11248, 0, 0, 0.698358,-99) , 
NN(
0, 
0, 
-1, -1.49104, 0, -1, 0.250577,-99) , 
3, -0.011497, 0, 0, 0.50232,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.607569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.65118, 1, 1, 0.895292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45022,-99) , 
0, 1.28068, 1, 0, 0.709202,-99) , 
3, 1.48826, 0, 0, 0.765732,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188605,-99) , 
0, -0.118626, 1, 0, 0.503693,-99) , 
NN(
0, 
0, 
-1, -1.49208, 0, -1, 0.207354,-99) , 
3, -0.55608, 0, 0, 0.35551,-99) , 
3, 0.268003, 0, 0, 0.544921,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.50268);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.54535, 1, 1, 0.780281,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321848,-99) , 
0, 0.0804575, 1, 0, 0.546066,-99) , 
NN(
0, 
0, 
-1, -1.51758, 0, -1, 0.30475,-99) , 
3, -0.238914, 0, 0, 0.395824,-99) , 
3, 0.673895, 0, 0, 0.517031,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.452772);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.66887, 0, 1, 0.974087,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313218,-99) , 
1, 1.79442, 1, 0, 0.651518,-99) , 
1, -1.19986, 1, 0, 0.687473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246419,-99) , 
0, -1.15273, 1, 0, 0.400506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.62065, 0, 0, 0.339886,-99) , 
3, -0.145446, 0, 0, 0.535717,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.38293);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.98678, 1, 1, 0.814632,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415999,-99) , 
2, 0.840778, 1, 0, 0.569909,-99) , 
3, 1.73904, 0, 0, 0.602276,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274403,-99) , 
0, -1.56231, 1, 0, 0.370835,-99) , 
NN(
0, 
0, 
-1, -3.11042, 1, -1, 0.0351982,-99) , 
3, -1.56687, 0, 0, 0.32679,-99) , 
3, -0.0725463, 0, 0, 0.477782,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.390051);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.482944, 1, 1, 0.817209,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311128,-99) , 
3, 1.9074, 0, 0, 0.518447,-99) , 
0, 2.34902, 1, 0, 0.731981,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398008,-99) , 
3, -0.615292, 0, 0, 0.66188,-99) , 
NN(
0, 
0, 
-1, -1.55388, 0, -1, 0.367723,-99) , 
1, -0.936379, 1, 0, 0.419832,-99) , 
3, 0.828289, 0, 0, 0.501143,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.354953);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20125, 1, 1, 0.733839,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360319,-99) , 
0, -0.267245, 1, 0, 0.493809,-99) , 
NN(
0, 
0, 
-1, -2.70079, 1, -1, 0.174662,-99) , 
3, -1.36125, 0, 0, 0.450286,-99) , 
3, 0.760049, 0, 0, 0.529758,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.298097);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.76962, 1, 1, 0.614672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367623,-99) , 
3, 0.497648, 0, 0, 0.45937,-99) , 
1, 0.0705562, 1, 0, 0.543457,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316507,-99) , 
0, -3.11229, 0, 0, 0.438925,-99) , 
NN(
0, 
0, 
-1, 1.36921, 0, -1, 0.0245309,-99) , 
1, -0.0761344, 1, 0, 0.216463,-99) , 
3, -1.15439, 0, 0, 0.488374,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.323009);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.981018, 1, 1, 0.622036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620755,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252258,-99) , 
0, -1.48245, 1, 0, 0.441647,-99) , 
3, -0.673444, 0, 0, 0.583806,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.0414256,-99) , 
3, -1.5755, 0, 0, 0.548174,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.202268);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.948021,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.96702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469641,-99) , 
0, -1.74081, 1, 0, 0.50481,-99) , 
NN(
0, 
0, 
-1, -1.17835, 1, -1, 0.257132,-99) , 
3, -1.12645, 0, 0, 0.469929,-99) , 
1, -1.83103, 1, 0, 0.487086,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.309763);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.95, 0, 1, 0.931214,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471849,-99) , 
0, -0.589361, 1, 0, 0.533887,-99) , 
1, -1.39272, 1, 0, 0.568035,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0406453,-99) , 
2, -1.78571, 0, 0, 0.475878,-99) , 
NN(
0, 
0, 
-1, -2.17214, 1, -1, 0.162942,-99) , 
2, -1.17916, 1, 0, 0.300873,-99) , 
3, -0.783748, 0, 0, 0.513131,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.260802);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.18175, 0, 1, 0.778169,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397216,-99) , 
3, -0.201428, 0, 0, 0.509698,-99) , 
1, -1.01234, 1, 0, 0.549749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0395836,-99) , 
3, -1.66842, 0, 0, 0.528594,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.301614);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.98978, 1, 1, 0.82569,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486852,-99) , 
3, 1.08254, 0, 0, 0.564833,-99) , 
1, -1.00832, 1, 0, 0.608674,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363285,-99) , 
0, -0.684155, 1, 0, 0.545602,-99) , 
NN(
0, 
0, 
-1, -0.529699, 0, -1, 0.306799,-99) , 
1, -0.275778, 1, 0, 0.417563,-99) , 
3, 0.256412, 0, 0, 0.513279,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.305586);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.528885, 0, 1, 0.598566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178259,-99) , 
3, 1.66947, 0, 0, 0.357632,-99) , 
0, 1.51194, 1, 0, 0.54691,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251052,-99) , 
2, -1.64004, 0, 0, 0.452954,-99) , 
NN(
0, 
0, 
-1, 0.0795947, 1, -1, 0.0723752,-99) , 
0, -2.39294, 1, 0, 0.278346,-99) , 
3, -1.09027, 0, 0, 0.500443,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.264086);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.118462, 1, 1, 0.599583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395459,-99) , 
0, -2.52467, 1, 0, 0.457135,-99) , 
3, 0.204863, 0, 0, 0.525168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0430042,-99) , 
3, -1.84079, 0, 0, 0.511495,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.283236);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.404277, 0, 1, 0.68591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420498,-99) , 
1, -1.10883, 1, 0, 0.45718,-99) , 
0, -0.87703, 1, 0, 0.525525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0732116,-99) , 
3, -1.5755, 0, 0, 0.505677,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.232799);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.280766, 0, 1, 0.752134,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293477,-99) , 
3, -0.841087, 0, 0, 0.532616,-99) , 
2, -1.32525, 1, 0, 0.55063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
2, -1.86445, 0, 0, 0.536202,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.20966);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.758323, 1, 1, 0.562013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277164,-99) , 
3, -0.764994, 1, 0, 0.390992,-99) , 
3, -0.351246, 0, 0, 0.517029,-99) , 
NN(
0, 
0, 
-1, -1.70952, 0, -1, 0.215192,-99) , 
3, -1.19711, 0, 0, 0.487775,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.226464);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.85974, 1, 1, 0.782236,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376087,-99) , 
3, 0.357259, 0, 0, 0.440403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133423,-99) , 
0, 3.22552, 1, 0, 0.424641,-99) , 
1, -1.42554, 1, 0, 0.449449,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.222605);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.34838, 1, 1, 0.530547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231496,-99) , 
3, -1.72546, 0, 0, 0.513782,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349787,-99) , 
0, 0.781067, 1, 0, 0.440288,-99) , 
NN(
0, 
0, 
-1, 0.462191, 0, -1, 0.242585,-99) , 
2, 0.593859, 0, 0, 0.378912,-99) , 
2, 0.391241, 1, 0, 0.454432,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.300752);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.598215, 0, 1, 0.639445,-99) , 
NN(
0, 
0, 
-1, 0.210885, 1, -1, 0.296035,-99) , 
2, -1.44579, 0, 0, 0.553173,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407968,-99) , 
0, 0.596945, 1, 0, 0.477594,-99) , 
NN(
0, 
0, 
-1, -0.709481, 1, -1, 0.231139,-99) , 
3, 0.00690201, 0, 0, 0.414186,-99) , 
0, -1.04975, 1, 0, 0.445897,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.301211);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.959536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419212,-99) , 
2, 0.988869, 1, 0, 0.505438,-99) , 
0, 1.8749, 1, 0, 0.613956,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3939,-99) , 
3, 0.336852, 0, 0, 0.448558,-99) , 
NN(
0, 
0, 
-1, 0.986664, 0, -1, 0.250329,-99) , 
0, 1.03611, 1, 0, 0.409391,-99) , 
3, 1.30905, 0, 0, 0.441066,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.325971);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434251,-99) , 
1, -0.512321, 1, 0, 0.494968,-99) , 
0, -1.35352, 1, 0, 0.518111,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221408,-99) , 
2, -0.898367, 0, 0, 0.381283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.084287,-99) , 
0, -1.36424, 1, 0, 0.27999,-99) , 
3, -0.613987, 0, 0, 0.456481,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.330003);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36072, 1, 1, 0.677567,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217109,-99) , 
2, 1.60802, 0, 0, 0.40351,-99) , 
2, 1.35399, 1, 0, 0.592137,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385161,-99) , 
3, -0.594833, 0, 0, 0.491446,-99) , 
NN(
0, 
0, 
-1, 0.836209, 1, -1, 0.283967,-99) , 
0, -0.0247421, 1, 0, 0.439667,-99) , 
3, 0.609067, 0, 0, 0.496948,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.161883);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.902741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421906,-99) , 
1, 1.75981, 1, 0, 0.706245,-99) , 
NN(
NN(
0, 
0, 
-1, -0.926214, 1, 1, 0.536479,-99) , 
NN(
0, 
0, 
-1, -1.80108, 1, -1, 0.34951,-99) , 
3, -0.707817, 0, 0, 0.494841,-99) , 
1, 1.38085, 0, 0, 0.513496,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.249039);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327371,-99) , 
3, 0.87935, 0, 0, 0.618126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182672,-99) , 
0, 3.24103, 1, 0, 0.563672,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317928,-99) , 
3, -1.70344, 0, 0, 0.564146,-99) , 
NN(
0, 
0, 
-1, 0.925644, 1, -1, 0.423583,-99) , 
0, -1.96947, 1, 0, 0.446141,-99) , 
3, 0.760049, 0, 0, 0.481049,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.239882);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297962,-99) , 
3, -1.32799, 0, 0, 0.636328,-99) , 
NN(
NN(
0, 
0, 
-1, -1.50979, 0, 1, 0.689763,-99) , 
NN(
0, 
0, 
-1, -0.550657, 0, -1, 0.414502,-99) , 
1, -1.25968, 1, 0, 0.443482,-99) , 
2, -1.15033, 1, 0, 0.463826,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.292854);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.6351, 0, 1, 0.644663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16703,-99) , 
0, 2.97343, 1, 0, 0.622966,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408103,-99) , 
0, 2.25165, 1, 0, 0.599112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322305,-99) , 
0, -0.508282, 1, 0, 0.414651,-99) , 
3, 1.371, 0, 0, 0.443309,-99) , 
1, 0.400437, 1, 0, 0.554972,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.208291);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.12189, 1, 1, 0.784868,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394782,-99) , 
3, -0.0725463, 0, 0, 0.472491,-99) , 
1, 1.27583, 0, 0, 0.505741,-99) , 
NN(
0, 
0, 
-1, 1.04044, 0, -1, 0.193778,-99) , 
1, 1.76787, 1, 0, 0.485299,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.215964);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.2486, 1, 1, 0.685851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263281,-99) , 
2, 0.520855, 1, 0, 0.496288,-99) , 
3, 0.626629, 0, 0, 0.553408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158598,-99) , 
3, 2.25327, 0, 0, 0.347166,-99) , 
0, 2.82704, 1, 0, 0.538982,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.319222);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841648,-99) , 
NN(
0, 
0, 
-1, -2.65189, 1, -1, 0.407421,-99) , 
3, -1.23119, 0, 0, 0.63282,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420018,-99) , 
0, 1.52555, 1, 0, 0.564431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556927,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34181,-99) , 
0, -0.965001, 1, 0, 0.398347,-99) , 
3, 0.902503, 0, 0, 0.448061,-99) , 
0, -1.77233, 1, 0, 0.473609,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.26887);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.35775, 0, 1, 0.593551,-99) , 
NN(
0, 
0, 
-1, 1.25306, 0, -1, 0.384755,-99) , 
0, 1.05523, 1, 0, 0.510303,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204291,-99) , 
2, -0.754186, 1, 0, 0.400512,-99) , 
NN(
0, 
0, 
-1, 0.934957, 0, -1, 0.0850107,-99) , 
1, 0.433898, 1, 0, 0.266917,-99) , 
3, -0.707817, 0, 0, 0.459377,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.227387);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.09948, 0, 1, 0.760318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495204,-99) , 
0, 3.05319, 1, 0, 0.662758,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443561,-99) , 
3, -0.457307, 0, 0, 0.537569,-99) , 
NN(
0, 
0, 
-1, 1.75528, 1, -1, 0.371132,-99) , 
0, 0.375316, 1, 0, 0.474325,-99) , 
3, 1.78981, 0, 0, 0.492871,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.243007);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45107, 0, 1, 0.724271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32705,-99) , 
3, 2.34063, 0, 0, 0.402031,-99) , 
0, 2.19019, 1, 0, 0.601711,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410931,-99) , 
3, -0.644649, 0, 0, 0.51122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191147,-99) , 
0, 1.07094, 1, 0, 0.482909,-99) , 
3, 0.800375, 0, 0, 0.515279,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.26959);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -3.91999, 1, 1, 0.631379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32284,-99) , 
1, -0.720969, 0, 0, 0.466242,-99) , 
2, 0.521751, 1, 0, 0.571985,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49833,-99) , 
2, 1.34988, 1, 0, 0.628606,-99) , 
NN(
0, 
0, 
-1, 1.1542, 0, -1, 0.364684,-99) , 
3, 1.46854, 0, 0, 0.407778,-99) , 
1, 0.531499, 1, 0, 0.515393,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.281117);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.167631, 1, 1, 0.678272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442338,-99) , 
2, -1.25413, 1, 0, 0.49514,-99) , 
3, -0.0942293, 0, 0, 0.556409,-99) , 
NN(
NN(
0, 
0, 
-1, 2.20955, 1, 1, 0.634882,-99) , 
NN(
0, 
0, 
-1, 1.54409, 1, -1, 0.285195,-99) , 
3, 1.28725, 0, 0, 0.430521,-99) , 
0, 0.724078, 1, 0, 0.512858,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.308378);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.24068, 1, 1, 0.632985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350041,-99) , 
2, 1.09754, 1, 0, 0.601861,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398897,-99) , 
2, 0.356926, 1, 0, 0.491935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312487,-99) , 
3, -1.47091, 1, 0, 0.3354,-99) , 
3, 0.342372, 0, 0, 0.410701,-99) , 
1, -0.214065, 1, 0, 0.495316,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.277652);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.123836, 0, 1, 0.745932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397034,-99) , 
3, 0.925448, 0, 0, 0.479534,-99) , 
0, -0.51727, 1, 0, 0.513346,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.104973,-99) , 
3, -1.68618, 0, 0, 0.466606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157805,-99) , 
0, -1.30223, 1, 0, 0.333257,-99) , 
3, -0.445771, 0, 0, 0.46631,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.306701);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464044,-99) , 
2, -0.886773, 1, 0, 0.63519,-99) , 
2, -0.212811, 0, 0, 0.677442,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414961,-99) , 
2, 0.255753, 1, 0, 0.48823,-99) , 
NN(
0, 
0, 
-1, 0.376493, 1, -1, 0.356921,-99) , 
3, 0.347918, 0, 0, 0.436911,-99) , 
0, -0.841201, 1, 0, 0.501432,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.176806);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02491, 0, 1, 0.785081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479132,-99) , 
0, -0.973355, 1, 0, 0.517755,-99) , 
NN(
0, 
0, 
-1, -1.46543, 0, -1, 0.305035,-99) , 
3, -0.925722, 0, 0, 0.485577,-99) , 
0, -2.98925, 1, 0, 0.503915,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.279855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361471,-99) , 
3, -0.32535, 0, 0, 0.528127,-99) , 
2, -1.05939, 1, 0, 0.550768,-99) , 
NN(
0, 
0, 
-1, -2.41213, 1, -1, 0.201117,-99) , 
3, -1.19711, 0, 0, 0.519792,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.210253);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.52978, 0, 1, 0.725134,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454532,-99) , 
0, 1.23915, 1, 0, 0.566286,-99) , 
NN(
0, 
0, 
-1, 0.377324, 1, -1, 0.446986,-99) , 
3, 0.447543, 0, 0, 0.499808,-99) , 
0, -2.19565, 1, 0, 0.528647,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.211107);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.963172,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442954,-99) , 
1, -0.121237, 1, 0, 0.610937,-99) , 
0, 1.91102, 1, 0, 0.69743,-99) , 
NN(
NN(
0, 
0, 
-1, -0.45279, 0, 1, 0.61142,-99) , 
NN(
0, 
0, 
-1, 1.59814, 1, -1, 0.451013,-99) , 
2, -0.446428, 1, 0, 0.509319,-99) , 
3, 1.24934, 0, 0, 0.545796,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.2972);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.966175, 0, 1, 0.782875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325756,-99) , 
1, -0.245173, 0, 0, 0.507751,-99) , 
0, 1.52555, 1, 0, 0.603592,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398129,-99) , 
0, -1.91315, 1, 0, 0.429753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0872633,-99) , 
3, -1.55388, 0, 0, 0.413337,-99) , 
3, 0.828289, 0, 0, 0.461248,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.249848);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.97038, 1, 1, 0.707168,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291734,-99) , 
0, 0.69305, 1, 0, 0.521383,-99) , 
3, 1.06392, 0, 0, 0.550468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589806,-99) , 
NN(
0, 
0, 
-1, 2.12946, 1, -1, 0.214433,-99) , 
3, 2.34935, 0, 0, 0.332441,-99) , 
2, 1.33607, 1, 0, 0.527191,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.273358);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458678,-99) , 
0, 0.300877, 1, 0, 0.554788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239684,-99) , 
3, -0.0623784, 0, 0, 0.38585,-99) , 
1, -0.919085, 0, 0, 0.519129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.68639, 0, 0, 0.504536,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.28268);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.783256, 1, 1, 0.651021,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491534,-99) , 
0, -1.43043, 1, 0, 0.549967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.129724,-99) , 
1, -0.684744, 1, 0, 0.28896,-99) , 
3, -1.02567, 0, 0, 0.480773,-99) , 
3, 0.0559666, 0, 0, 0.571291,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.198463);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66078, 0, 1, 0.568392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211657,-99) , 
0, 3.52436, 1, 0, 0.552975,-99) , 
NN(
0, 
0, 
-1, -2.39294, 1, -1, 0.185823,-99) , 
3, -1.27729, 0, 0, 0.521818,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.246616);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451013,-99) , 
1, 0.101304, 0, 0, 0.519149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191849,-99) , 
3, 1.77333, 0, 0, 0.345467,-99) , 
0, 1.38193, 1, 0, 0.478119,-99) , 
NN(
0, 
0, 
-1, -0.301417, 0, -1, 0.205322,-99) , 
3, -1.44079, 0, 0, 0.46294,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.175645);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43543, 0, 1, 0.541737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205848,-99) , 
3, 2.23287, 0, 0, 0.319242,-99) , 
0, 2.27059, 1, 0, 0.510717,-99) , 
NN(
0, 
0, 
-1, -2.81954, 1, -1, 0.189804,-99) , 
3, -1.16308, 0, 0, 0.484833,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.219534);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.391697, 0, 1, 0.740345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372522,-99) , 
0, 1.17659, 1, 0, 0.658052,-99) , 
NN(
NN(
0, 
0, 
-1, -0.00780329, 1, 1, 0.597934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33991,-99) , 
0, 0.0137742, 1, 0, 0.45441,-99) , 
2, 0.820685, 0, 0, 0.493761,-99) , 
1, -0.796883, 1, 0, 0.521795,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.264023);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488573,-99) , 
0, 2.19477, 1, 0, 0.722913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332232,-99) , 
2, 0.0958339, 1, 0, 0.461293,-99) , 
3, 0.120258, 0, 0, 0.569585,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409506,-99) , 
1, 0.00935478, 1, 0, 0.430422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0413244,-99) , 
1, 2.20993, 1, 0, 0.405677,-99) , 
1, -0.102661, 1, 0, 0.474008,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.243304);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464312,-99) , 
1, 0.263134, 1, 0, 0.574816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223736,-99) , 
1, 0.45974, 0, 0, 0.321979,-99) , 
3, -1.36859, 0, 0, 0.544855,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208812,-99) , 
0, 3.24103, 1, 0, 0.504232,-99) , 
NN(
0, 
0, 
-1, 0.78475, 0, -1, 0.292868,-99) , 
3, 0.772215, 0, 0, 0.439756,-99) , 
2, 0.45817, 1, 0, 0.50448,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.159082);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.75483, 1, 1, 0.555737,-99) , 
NN(
0, 
0, 
-1, 2.00819, 0, -1, 0.257824,-99) , 
2, 1.55244, 1, 0, 0.533973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0922259,-99) , 
3, -1.58953, 0, 0, 0.521547,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.242044);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460815,-99) , 
3, -0.230509, 0, 0, 0.656981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393861,-99) , 
3, 0.495166, 0, 0, 0.479826,-99) , 
0, -0.426633, 1, 0, 0.507049,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230747,-99) , 
2, -0.898367, 0, 0, 0.386271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244139,-99) , 
0, -1.22141, 1, 0, 0.323622,-99) , 
3, -0.582913, 0, 0, 0.456885,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.26054);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.927502, 1, 1, 0.563306,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371464,-99) , 
3, 1.76097, 0, 0, 0.405854,-99) , 
2, 0.375307, 1, 0, 0.485438,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416771,-99) , 
2, -1.49071, 0, 0, 0.592069,-99) , 
NN(
0, 
0, 
-1, -1.01012, 0, -1, 0.176393,-99) , 
0, -2.31713, 1, 0, 0.30038,-99) , 
3, -0.707817, 0, 0, 0.443634,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.22259);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.77811, 1, 1, 0.661428,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463399,-99) , 
1, -0.386868, 1, 0, 0.551458,-99) , 
NN(
0, 
0, 
-1, -0.902614, 0, -1, 0.393198,-99) , 
2, -1.14361, 1, 0, 0.412435,-99) , 
1, -1.41363, 1, 0, 0.425328,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.229071);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495138,-99) , 
3, -0.457307, 0, 0, 0.629352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462603,-99) , 
3, 0.746239, 0, 0, 0.484801,-99) , 
1, -0.480148, 1, 0, 0.534755,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260547,-99) , 
0, 2.78809, 1, 0, 0.500104,-99) , 
NN(
0, 
0, 
-1, 0.677862, 0, -1, 0.235591,-99) , 
3, 1.10386, 0, 0, 0.413886,-99) , 
0, 0.967715, 1, 0, 0.500384,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.322665);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0698819, 0, 1, 0.871646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336168,-99) , 
2, 1.14343, 1, 0, 0.491953,-99) , 
0, 0.0922856, 1, 0, 0.582328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612286,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300443,-99) , 
2, -1.42702, 1, 0, 0.355499,-99) , 
2, -0.188964, 0, 0, 0.401067,-99) , 
3, -0.291428, 0, 0, 0.521034,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.158221);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473778,-99) , 
0, -0.841324, 1, 0, 0.641779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310453,-99) , 
2, -0.231761, 0, 0, 0.455056,-99) , 
2, -0.6892, 1, 0, 0.490273,-99) , 
NN(
0, 
0, 
-1, -2.31616, 1, -1, 0.325922,-99) , 
3, -1.10211, 0, 0, 0.477292,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.220139);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371459,-99) , 
2, -1.09162, 1, 0, 0.484369,-99) , 
3, -0.685839, 0, 0, 0.573306,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196794,-99) , 
1, -1.75498, 0, 0, 0.498587,-99) , 
NN(
0, 
0, 
-1, 0.393477, 0, -1, 0.387977,-99) , 
1, -0.157496, 1, 0, 0.431835,-99) , 
0, -1.06144, 1, 0, 0.464167,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.285439);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.17247, 0, 1, 0.84598,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35755,-99) , 
1, 1.62574, 1, 0, 0.591211,-99) , 
1, -1.29311, 1, 0, 0.616283,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275671,-99) , 
0, 1.44214, 1, 0, 0.387857,-99) , 
3, 2.27216, 0, 0, 0.432562,-99) , 
2, 0.456587, 1, 0, 0.550922,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.182448);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496924,-99) , 
3, 1.92485, 0, 0, 0.520835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21548,-99) , 
0, 3.50619, 1, 0, 0.504413,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318705,-99) , 
3, -0.33506, 0, 0, 0.383554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.118753,-99) , 
3, -1.53441, 0, 0, 0.359681,-99) , 
3, -0.0447319, 0, 0, 0.438215,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.28938);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.473243, 1, 1, 0.841046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333019,-99) , 
2, 0.036099, 1, 0, 0.484155,-99) , 
3, 0.347376, 0, 0, 0.537507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296443,-99) , 
1, -0.218467, 1, 0, 0.363593,-99) , 
3, 2.22512, 0, 0, 0.403864,-99) , 
0, 0.749055, 1, 0, 0.483334,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.287686);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.364201, 1, 1, 0.812625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225534,-99) , 
0, -0.129803, 1, 0, 0.469504,-99) , 
1, 1.5265, 1, 0, 0.672739,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414474,-99) , 
2, 0.0876493, 1, 0, 0.480443,-99) , 
NN(
0, 
0, 
-1, -0.505251, 0, -1, 0.331403,-99) , 
1, 0.36435, 1, 0, 0.440204,-99) , 
1, 1.14035, 0, 0, 0.480886,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.148959);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 3.812, 1, -1, 0.48149,-99) , 
0, -1.40773, 1, 0, 0.500796,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410697,-99) , 
2, -1.49071, 0, 0, 0.591945,-99) , 
NN(
0, 
0, 
-1, -1.21608, 0, -1, 0.249925,-99) , 
0, -2.51925, 1, 0, 0.362133,-99) , 
3, -0.707817, 0, 0, 0.473899,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.229763);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.601811, 0, 1, 0.72812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424576,-99) , 
3, 0.444726, 0, 0, 0.486056,-99) , 
2, -0.73255, 1, 0, 0.539134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.109865,-99) , 
2, -1.63862, 0, 0, 0.521804,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.370883);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83516,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4076,-99) , 
1, 1.2171, 1, 0, 0.755298,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422969,-99) , 
3, 1.61084, 0, 0, 0.490271,-99) , 
0, 0.714928, 1, 0, 0.576836,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28097,-99) , 
3, -1.03448, 0, 0, 0.473029,-99) , 
NN(
0, 
0, 
-1, -0.242535, 0, -1, 0.273697,-99) , 
0, -1.11015, 1, 0, 0.367218,-99) , 
3, -0.0447319, 0, 0, 0.49186,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.231086);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.213586, 1, 1, 0.573073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358993,-99) , 
0, -2.66394, 1, 0, 0.405265,-99) , 
3, -0.362905, 0, 0, 0.506589,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379469,-99) , 
3, 2.07976, 0, 0, 0.43034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217231,-99) , 
0, 3.5849, 1, 0, 0.396446,-99) , 
0, 1.52061, 1, 0, 0.480126,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.18779);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.921309, 1, 1, 0.741876,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443187,-99) , 
1, -0.325804, 0, 0, 0.537601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192299,-99) , 
2, -1.70712, 0, 0, 0.524557,-99) , 
1, -1.40344, 1, 0, 0.540269,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.122165);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.742305, 0, 1, 0.762804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490007,-99) , 
0, 0.921309, 1, 0, 0.686612,-99) , 
NN(
0, 
0, 
-1, -1.68639, 0, -1, 0.453571,-99) , 
1, -1.37148, 1, 0, 0.476516,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.136235);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770675,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483903,-99) , 
1, -0.74258, 1, 0, 0.520919,-99) , 
NN(
0, 
0, 
-1, -1.67822, 0, -1, 0.408961,-99) , 
2, -0.403065, 0, 0, 0.487401,-99) , 
1, -1.86762, 1, 0, 0.497888,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.25298);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.41826, 1, 1, 0.599433,-99) , 
NN(
0, 
0, 
-1, 0.312287, 0, -1, 0.32111,-99) , 
2, 1.59464, 1, 0, 0.576406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669428,-99) , 
NN(
0, 
0, 
-1, -0.667259, 1, -1, 0.331818,-99) , 
1, 0.897865, 0, 0, 0.401201,-99) , 
3, -0.547237, 0, 0, 0.526307,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.169456);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.08195, 0, 1, 0.723057,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348985,-99) , 
0, 1.17428, 1, 0, 0.617023,-99) , 
NN(
0, 
0, 
-1, -0.98855, 0, -1, 0.459795,-99) , 
1, -1.0056, 1, 0, 0.489364,-99) , 
1, 1.47355, 0, 0, 0.511954,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.149421);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788711,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44813,-99) , 
3, 0.925674, 0, 0, 0.480821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240523,-99) , 
1, -1.31109, 0, 0, 0.46944,-99) , 
1, -1.57885, 1, 0, 0.481275,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.167957);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318939,-99) , 
1, 1.30076, 1, 0, 0.575369,-99) , 
2, 0.336622, 1, 0, 0.619084,-99) , 
NN(
NN(
0, 
0, 
-1, -1.49071, 0, 1, 0.693297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.118838,-99) , 
3, -1.1984, 0, 0, 0.489115,-99) , 
0, -2.21611, 1, 0, 0.513498,-99) , 
3, 0.760049, 0, 0, 0.549294,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.249425);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.140897,-99) , 
3, -1.59669, 0, 0, 0.569056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300754,-99) , 
3, 0.456264, 0, 0, 0.424816,-99) , 
0, -0.614172, 1, 0, 0.474319,-99) , 
NN(
0, 
0, 
-1, 2.1931, 1, -1, 0.304254,-99) , 
1, 1.2714, 1, 0, 0.449044,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.201779);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840984,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435872,-99) , 
3, 0.0608814, 0, 0, 0.495099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270372,-99) , 
3, 2.17691, 0, 0, 0.369414,-99) , 
0, 1.93176, 1, 0, 0.470647,-99) , 
1, -1.90873, 1, 0, 0.480909,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.244333);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.736924, 0, 1, 0.80791,-99) , 
NN(
0, 
0, 
-1, 3.55192, 1, -1, 0.46284,-99) , 
2, -0.00026389, 1, 0, 0.53359,-99) , 
NN(
NN(
0, 
0, 
-1, 0.336366, 0, 1, 0.631775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327492,-99) , 
1, -0.687486, 1, 0, 0.376965,-99) , 
0, -2.71816, 1, 0, 0.416734,-99) , 
2, -0.425618, 0, 0, 0.49376,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.256194);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.88343, 1, 1, 0.748933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402599,-99) , 
2, 0.470299, 1, 0, 0.541649,-99) , 
3, 1.2857, 0, 0, 0.573828,-99) , 
NN(
0, 
0, 
-1, 2.29924, 0, -1, 0.306449,-99) , 
0, 2.82704, 1, 0, 0.556075,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.198291);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.740097, 1, 1, 0.567403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369474,-99) , 
3, 1.14479, 0, 0, 0.447516,-99) , 
0, 0.0232608, 1, 0, 0.496111,-99) , 
NN(
0, 
0, 
-1, -0.557568, 1, -1, 0.259639,-99) , 
3, -1.19711, 0, 0, 0.478926,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.275916);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.432052, 1, 1, 0.872019,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313882,-99) , 
0, 2.97201, 1, 0, 0.486355,-99) , 
2, 0.616748, 1, 0, 0.578665,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384391,-99) , 
0, -1.37581, 1, 0, 0.442316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0906922,-99) , 
0, 0.580369, 1, 0, 0.412358,-99) , 
3, 0.668022, 0, 0, 0.472795,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.120146);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.17354, 0, 1, 0.719179,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244158,-99) , 
3, -0.952034, 0, 0, 0.501078,-99) , 
0, -1.96608, 1, 0, 0.52233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0790781,-99) , 
3, -1.5755, 0, 0, 0.506766,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.370308);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430924,-99) , 
0, 2.6791, 1, 0, 0.734311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383854,-99) , 
1, 1.28315, 0, 0, 0.48427,-99) , 
2, 0.514398, 0, 0, 0.567751,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347591,-99) , 
3, -0.0260304, 0, 0, 0.463817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271235,-99) , 
1, -0.780978, 1, 0, 0.324137,-99) , 
0, 0.882147, 1, 0, 0.407913,-99) , 
1, 0.423988, 0, 0, 0.460128,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.271027);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.660711, 0, 1, 0.625585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413907,-99) , 
3, 2.19699, 0, 0, 0.473119,-99) , 
0, 1.57056, 1, 0, 0.582515,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437864,-99) , 
1, 0.763612, 0, 0, 0.582505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177044,-99) , 
0, -2.39294, 1, 0, 0.436771,-99) , 
3, -1.09475, 0, 0, 0.564284,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.286825);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458482,-99) , 
1, 1.0838, 1, 0, 0.700745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386788,-99) , 
2, -0.249256, 0, 0, 0.442056,-99) , 
0, -1.13044, 0, 0, 0.590335,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383075,-99) , 
1, 0.483982, 1, 0, 0.468751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.124222,-99) , 
3, 0.377074, 0, 0, 0.433937,-99) , 
0, 0.411997, 1, 0, 0.513247,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.184736);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29465, 1, 1, 0.69741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448478,-99) , 
2, -0.986742, 1, 0, 0.48395,-99) , 
3, 1.49106, 0, 0, 0.506937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203937,-99) , 
0, 3.35955, 1, 0, 0.495534,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.185696);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.38379, 1, 1, 0.579478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.117324,-99) , 
0, -2.56651, 1, 0, 0.322259,-99) , 
2, -1.3039, 0, 0, 0.55932,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.240968);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5307, 1, 1, 0.797353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469839,-99) , 
3, -0.234345, 0, 0, 0.670709,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398799,-99) , 
2, 0.579534, 1, 0, 0.571475,-99) , 
NN(
0, 
0, 
-1, 0.241847, 0, -1, 0.411449,-99) , 
1, -0.745149, 1, 0, 0.449841,-99) , 
1, 1.14, 0, 0, 0.482482,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.330876);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.631053, 1, 1, 0.660414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278075,-99) , 
2, -1.45184, 0, 0, 0.631479,-99) , 
NN(
NN(
0, 
0, 
-1, 1.09006, 1, 1, 0.711008,-99) , 
NN(
0, 
0, 
-1, 0.0402648, 1, -1, 0.372544,-99) , 
1, 0.589387, 0, 0, 0.463931,-99) , 
2, 0.462259, 1, 0, 0.57121,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.135029);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470101,-99) , 
3, 2.11238, 0, 0, 0.483428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.115852,-99) , 
0, 3.72518, 1, 0, 0.471363,-99) , 
NN(
0, 
0, 
-1, -2.41213, 1, -1, 0.239911,-99) , 
3, -1.27729, 0, 0, 0.454401,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.190817);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263612,-99) , 
3, -0.628396, 0, 0, 0.608519,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3758,-99) , 
1, -0.409811, 0, 0, 0.487606,-99) , 
1, -1.04839, 1, 0, 0.505688,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248875,-99) , 
0, 3.19183, 1, 0, 0.464555,-99) , 
NN(
0, 
0, 
-1, 0.600615, 1, -1, 0.277222,-99) , 
3, 1.2151, 0, 0, 0.403471,-99) , 
0, 1.18426, 1, 0, 0.478414,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.202885);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399692,-99) , 
3, -0.930788, 0, 0, 0.557222,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.175467,-99) , 
3, 2.22653, 0, 0, 0.357553,-99) , 
0, 2.36756, 1, 0, 0.537258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181658,-99) , 
3, -1.5755, 0, 0, 0.521478,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.170237);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426988,-99) , 
3, 0.0973353, 0, 0, 0.49798,-99) , 
NN(
0, 
0, 
-1, 1.53592, 1, -1, 0.283207,-99) , 
0, 2.94166, 1, 0, 0.481322,-99) , 
NN(
0, 
0, 
-1, -1.31625, 0, -1, 0.292921,-99) , 
2, -1.2253, 0, 0, 0.465594,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.18562);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390769,-99) , 
0, -1.79338, 0, 0, 0.586934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433405,-99) , 
1, -0.694082, 1, 0, 0.47836,-99) , 
1, 0.577689, 0, 0, 0.51241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206468,-99) , 
1, 2.11264, 1, 0, 0.503592,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.179294);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.455496, 1, 1, 0.704586,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31324,-99) , 
3, -0.264902, 0, 0, 0.514324,-99) , 
0, -0.773998, 1, 0, 0.545896,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589973,-99) , 
NN(
0, 
0, 
-1, -1.25402, 0, -1, 0.284478,-99) , 
2, -1.32073, 1, 0, 0.377925,-99) , 
3, -0.796906, 0, 0, 0.518642,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.361482);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358054,-99) , 
1, -1.51261, 0, 0, 0.623871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285208,-99) , 
3, 1.09499, 0, 0, 0.445524,-99) , 
0, 0.816707, 1, 0, 0.557008,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264601,-99) , 
2, -0.887846, 0, 0, 0.524819,-99) , 
NN(
0, 
0, 
-1, -0.139777, 0, -1, 0.330225,-99) , 
3, -0.128257, 1, 0, 0.384888,-99) , 
1, 0.370917, 1, 0, 0.48243,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.239828);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.092648, 1, 1, 0.58539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296002,-99) , 
0, -2.12426, 1, 0, 0.397169,-99) , 
2, -1.07143, 0, 0, 0.558512,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336296,-99) , 
1, 1.08809, 1, 0, 0.458944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189152,-99) , 
1, 0.582024, 0, 0, 0.410147,-99) , 
1, 0.444458, 1, 0, 0.50303,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.184505);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487277,-99) , 
2, -0.393846, 1, 0, 0.522351,-99) , 
NN(
0, 
0, 
-1, -1.9253, 1, -1, 0.358366,-99) , 
3, -0.604144, 0, 0, 0.480558,-99) , 
NN(
0, 
0, 
-1, 0.252043, 1, -1, 0.264639,-99) , 
0, 2.29217, 1, 0, 0.451864,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.330938);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.819846, 0, 1, 0.712289,-99) , 
NN(
0, 
0, 
-1, 3.62178, 1, -1, 0.407508,-99) , 
0, 1.58243, 1, 0, 0.495036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.936674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413074,-99) , 
2, -0.211338, 0, 0, 0.472174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21481,-99) , 
3, 0.621942, 0, 0, 0.287802,-99) , 
0, -0.623039, 1, 0, 0.366096,-99) , 
3, 0.828289, 0, 0, 0.408749,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.319551);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288868,-99) , 
2, 1.28889, 1, 0, 0.561519,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224955,-99) , 
1, 1.27043, 0, 0, 0.385624,-99) , 
1, 0.808647, 1, 0, 0.51928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399456,-99) , 
0, -1.7523, 1, 0, 0.444225,-99) , 
NN(
0, 
0, 
-1, -1.38727, 1, -1, 0.245255,-99) , 
2, -0.992474, 0, 0, 0.373926,-99) , 
3, -0.266382, 0, 0, 0.482549,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.250075);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.13641, 0, 1, 0.751187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328545,-99) , 
3, -1.74517, 0, 0, 0.447454,-99) , 
2, -1.17569, 0, 0, 0.640697,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478258,-99) , 
0, -0.467276, 1, 0, 0.522707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539699,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321006,-99) , 
0, -0.0160702, 1, 0, 0.370954,-99) , 
1, 0.104868, 0, 0, 0.43764,-99) , 
0, -1.24835, 1, 0, 0.473231,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.238754);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864862,-99) , 
NN(
NN(
0, 
0, 
-1, 1.85651, 1, 1, 0.723902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418138,-99) , 
0, -2.07156, 1, 0, 0.446973,-99) , 
3, 1.84413, 0, 0, 0.474833,-99) , 
1, 2.04984, 0, 0, 0.49073,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.244457);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47427, 1, 1, 0.745955,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371372,-99) , 
3, 1.64176, 0, 0, 0.5264,-99) , 
2, 1.07753, 1, 0, 0.638422,-99) , 
NN(
NN(
0, 
0, 
-1, -1.56032, 1, 1, 0.618254,-99) , 
NN(
0, 
0, 
-1, -1.29128, 0, -1, 0.427805,-99) , 
1, -0.392075, 1, 0, 0.489235,-99) , 
2, 0.593546, 0, 0, 0.534261,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.335412);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27192, 0, 1, 0.691773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207537,-99) , 
3, 2.42621, 0, 0, 0.371271,-99) , 
0, 2.82894, 1, 0, 0.649465,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396609,-99) , 
3, -0.295166, 1, 0, 0.550494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287254,-99) , 
2, 0.661376, 0, 0, 0.382885,-99) , 
2, 0.165395, 1, 0, 0.514407,-99) , 
0, 0.394028, 0, 0, 0.574983,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.242694);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.639414, 0, 1, 0.695187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388135,-99) , 
0, 2.34754, 1, 0, 0.668696,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456649,-99) , 
3, -1.17384, 0, 0, 0.670935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348764,-99) , 
2, 1.27124, 1, 0, 0.477702,-99) , 
2, -0.784918, 1, 0, 0.505116,-99) , 
1, 0.213586, 0, 0, 0.577588,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.135541);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870894,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421791,-99) , 
0, 2.0709, 1, 0, 0.52816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235147,-99) , 
0, 3.83529, 1, 0, 0.519876,-99) , 
1, -1.67887, 1, 0, 0.531198,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.337939);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.469369, 1, 1, 0.658636,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.118257,-99) , 
3, -0.442927, 0, 0, 0.460318,-99) , 
1, 1.07539, 1, 0, 0.628581,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40932,-99) , 
0, 2.26762, 1, 0, 0.556716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36687,-99) , 
0, -0.390997, 1, 0, 0.39425,-99) , 
3, 1.41844, 0, 0, 0.434799,-99) , 
2, 0.0207206, 1, 0, 0.516263,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.146966);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464429,-99) , 
3, -0.553438, 0, 0, 0.554207,-99) , 
NN(
0, 
0, 
-1, 0.0570068, 0, -1, 0.449644,-99) , 
2, -0.64395, 1, 0, 0.471168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.1111,-99) , 
2, -1.74543, 0, 0, 0.459897,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.287296);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31961,-99) , 
2, 0.562546, 0, 0, 0.550153,-99) , 
2, 0.388738, 1, 0, 0.593317,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421712,-99) , 
3, -0.0922158, 0, 0, 0.479313,-99) , 
NN(
0, 
0, 
-1, 0.925803, 1, -1, 0.226258,-99) , 
0, 0.301108, 1, 0, 0.427883,-99) , 
3, 0.76021, 0, 0, 0.479933,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.196767);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.748613, 0, 1, 0.694634,-99) , 
NN(
0, 
0, 
-1, -0.365617, 0, -1, 0.427674,-99) , 
0, -1.40773, 1, 0, 0.454331,-99) , 
NN(
0, 
0, 
-1, -1.60425, 0, -1, 0.281811,-99) , 
3, -1.19927, 0, 0, 0.438074,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.267949);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.899119, 1, 1, 0.780901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394735,-99) , 
0, 3.83837, 1, 0, 0.726418,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432361,-99) , 
1, -0.917432, 0, 0, 0.554772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372662,-99) , 
3, 1.12498, 0, 0, 0.413428,-99) , 
0, 0.312933, 1, 0, 0.500076,-99) , 
3, 1.30905, 0, 0, 0.542465,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.248382);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418154,-99) , 
1, 1.79179, 1, 0, 0.598908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315798,-99) , 
3, 0.128548, 0, 0, 0.463247,-99) , 
1, -1.36363, 0, 0, 0.586317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23576,-99) , 
3, -1.51856, 0, 0, 0.572075,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.156451);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497849,-99) , 
2, 0.18286, 0, 0, 0.554252,-99) , 
NN(
0, 
0, 
-1, 0.30318, 0, -1, 0.425869,-99) , 
2, 0.456587, 1, 0, 0.499165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209259,-99) , 
1, 1.61612, 1, 0, 0.482688,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.117716);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754445,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498124,-99) , 
0, 1.73463, 0, 0, 0.533566,-99) , 
NN(
0, 
0, 
-1, -1.07123, 0, -1, 0.329133,-99) , 
0, -1.60137, 0, 0, 0.517365,-99) , 
0, -2.54417, 1, 0, 0.530607,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.140969);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.894607, 0, 1, 0.684989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482621,-99) , 
3, 0.857847, 0, 0, 0.523285,-99) , 
0, -1.40205, 1, 0, 0.544215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26475,-99) , 
1, 2.05065, 1, 0, 0.535833,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.202714);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.584342, 0, 1, 0.680338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359093,-99) , 
3, 0.0749486, 0, 0, 0.492219,-99) , 
0, -1.22373, 1, 0, 0.533459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0493533,-99) , 
3, -1.51083, 0, 0, 0.522122,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.180864);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.372023, 1, 1, 0.797531,-99) , 
NN(
NN(
0, 
0, 
-1, 0.289562, 0, 1, 0.555333,-99) , 
NN(
0, 
0, 
-1, 0.93894, 1, -1, 0.410237,-99) , 
1, 0.455302, 1, 0, 0.511719,-99) , 
1, 1.25083, 0, 0, 0.541029,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.221361);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09203, 0, 1, 0.685695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353745,-99) , 
3, -1.25353, 0, 0, 0.506724,-99) , 
3, -0.00785681, 0, 0, 0.568833,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477121,-99) , 
0, 2.13411, 1, 0, 0.537462,-99) , 
NN(
0, 
0, 
-1, 0.38126, 1, -1, 0.265615,-99) , 
3, 1.2151, 0, 0, 0.443392,-99) , 
0, 1.20503, 1, 0, 0.5316,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.127018);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44651,-99) , 
2, 1.54775, 1, 0, 0.634966,-99) , 
NN(
0, 
0, 
-1, -1.5753, 0, -1, 0.45332,-99) , 
3, 2.10642, 0, 0, 0.465602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252708,-99) , 
1, -1.99935, 0, 0, 0.45727,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.262323);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.182326, 0, 1, 0.664278,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42028,-99) , 
2, 0.954249, 1, 0, 0.552679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338789,-99) , 
1, 0.317022, 0, 0, 0.4201,-99) , 
3, 0.122404, 0, 0, 0.490741,-99) , 
0, -2.47643, 1, 0, 0.502051,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.202813);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.332075, 0, 1, 0.74452,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496264,-99) , 
3, 0.328974, 1, 0, 0.527467,-99) , 
2, -0.088399, 1, 0, 0.56388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159248,-99) , 
3, -1.58402, 0, 0, 0.515035,-99) , 
NN(
0, 
0, 
-1, -0.452575, 1, -1, 0.220093,-99) , 
0, -0.835383, 1, 0, 0.415049,-99) , 
3, -0.115595, 0, 0, 0.513028,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.271133);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.819918, 1, 1, 0.608263,-99) , 
NN(
0, 
0, 
-1, 1.06958, 0, -1, 0.435358,-99) , 
0, 1.08713, 1, 0, 0.528106,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222219,-99) , 
2, -0.846381, 0, 0, 0.378564,-99) , 
NN(
0, 
0, 
-1, -1.05693, 1, -1, 0.207184,-99) , 
3, -0.95221, 0, 0, 0.292263,-99) , 
3, -0.454765, 0, 0, 0.465701,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.222302);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01585, 0, 1, 0.629165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562423,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412436,-99) , 
0, 1.35786, 1, 0, 0.506656,-99) , 
1, 0.476954, 0, 0, 0.544987,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161301,-99) , 
1, 1.35556, 0, 0, 0.276914,-99) , 
1, -0.125285, 1, 0, 0.361399,-99) , 
2, -0.936767, 0, 0, 0.514898,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.290718);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0273788, 1, 1, 0.680296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403153,-99) , 
2, 1.20324, 0, 0, 0.542296,-99) , 
1, -0.552256, 0, 0, 0.633328,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491872,-99) , 
3, -0.544234, 0, 0, 0.604193,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364937,-99) , 
2, -1.09381, 1, 0, 0.393932,-99) , 
1, -0.796883, 1, 0, 0.427067,-99) , 
2, 0.521751, 0, 0, 0.499604,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.178097);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404022,-99) , 
1, 1.07026, 1, 0, 0.648304,-99) , 
NN(
0, 
0, 
-1, -1.53413, 0, -1, 0.458101,-99) , 
0, 1.2931, 0, 0, 0.505035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112685,-99) , 
0, 3.35945, 1, 0, 0.490446,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.195466);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2335, 1, 1, 0.698136,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489623,-99) , 
2, -0.0410833, 1, 0, 0.550857,-99) , 
3, 1.3518, 0, 0, 0.578211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164152,-99) , 
3, -1.54964, 0, 0, 0.561603,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.277338);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.767617, 0, 1, 0.851863,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428019,-99) , 
3, 1.37867, 0, 0, 0.520054,-99) , 
2, 0.635556, 1, 0, 0.615104,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47447,-99) , 
3, 0.0593591, 0, 0, 0.51134,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303224,-99) , 
0, -2.18937, 1, 0, 0.369907,-99) , 
1, 0.311043, 1, 0, 0.448466,-99) , 
3, 0.34753, 0, 0, 0.51967,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.201264);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.095886, 1, 1, 0.819549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311154,-99) , 
1, 0.861011, 1, 0, 0.514473,-99) , 
1, 1.26528, 0, 0, 0.542143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237425,-99) , 
1, 1.71189, 1, 0, 0.52703,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.248225);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843763,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419386,-99) , 
1, -0.284135, 0, 0, 0.5156,-99) , 
1, -2.00091, 1, 0, 0.533278,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308572,-99) , 
2, 0.632841, 0, 0, 0.493203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295931,-99) , 
3, 2.3371, 0, 0, 0.368308,-99) , 
0, 2.09865, 1, 0, 0.436745,-99) , 
0, 1.16165, 1, 0, 0.503321,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.29165);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.776769, 1, 1, 0.619861,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485878,-99) , 
2, -0.259522, 1, 0, 0.642065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282579,-99) , 
2, -1.08676, 1, 0, 0.357958,-99) , 
3, 0.0284943, 0, 0, 0.419202,-99) , 
2, 0.143877, 0, 0, 0.527958,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.230909);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412122,-99) , 
3, 0.486444, 0, 0, 0.596649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89728,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331421,-99) , 
3, 0.459667, 1, 0, 0.448577,-99) , 
1, -0.421991, 0, 0, 0.552014,-99) , 
NN(
0, 
0, 
-1, -0.128307, 1, -1, 0.421632,-99) , 
3, 0.27076, 0, 0, 0.487287,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.218173);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488266,-99) , 
1, 0.263134, 1, 0, 0.555757,-99) , 
NN(
0, 
0, 
-1, -0.125285, 1, -1, 0.323497,-99) , 
3, -1.22986, 0, 0, 0.536141,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173723,-99) , 
0, 3.34413, 1, 0, 0.406076,-99) , 
NN(
0, 
0, 
-1, 1.59834, 0, -1, 0.201273,-99) , 
3, 2.06032, 0, 0, 0.300416,-99) , 
0, 2.04848, 1, 0, 0.497746,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.167272);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.375482, 0, 1, 0.564297,-99) , 
NN(
0, 
0, 
-1, 1.25185, 0, -1, 0.38706,-99) , 
2, 1.12155, 1, 0, 0.532878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.115994,-99) , 
2, -1.49291, 0, 0, 0.519552,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.323764);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.219402, 0, 1, 0.711757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280236,-99) , 
3, -1.53104, 0, 0, 0.680684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364395,-99) , 
1, 0.0649024, 1, 0, 0.421403,-99) , 
1, -1.19986, 1, 0, 0.447869,-99) , 
0, 0.394028, 1, 0, 0.559925,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.199061);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.170475, 0, 1, 0.597098,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411098,-99) , 
3, 1.31583, 0, 0, 0.483584,-99) , 
0, 0.321785, 1, 0, 0.546878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185468,-99) , 
1, 2.10403, 1, 0, 0.537617,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.227315);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818221,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456536,-99) , 
0, 1.77847, 1, 0, 0.566153,-99) , 
1, -0.939402, 1, 0, 0.580688,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44695,-99) , 
2, 0.411019, 0, 0, 0.603683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151799,-99) , 
1, -1.31881, 1, 0, 0.44249,-99) , 
1, -1.15052, 0, 0, 0.564381,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.231275);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317991,-99) , 
1, 1.3778, 1, 0, 0.623622,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.108552,-99) , 
3, 0.798675, 0, 0, 0.452786,-99) , 
0, 1.12518, 1, 0, 0.521565,-99) , 
NN(
0, 
0, 
-1, 1.55309, 1, -1, 0.378324,-99) , 
3, 0.163853, 0, 0, 0.455326,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.314266);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377012,-99) , 
3, 0.333614, 0, 0, 0.609422,-99) , 
NN(
0, 
0, 
-1, 4.03724, 0, -1, 0.206712,-99) , 
0, 3.49249, 1, 0, 0.570615,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429019,-99) , 
3, -0.338643, 0, 0, 0.496852,-99) , 
NN(
0, 
0, 
-1, -0.840031, 1, -1, 0.280515,-99) , 
2, -0.121799, 1, 0, 0.428469,-99) , 
3, 0.18735, 0, 0, 0.507258,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.242045);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849094,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311716,-99) , 
1, -0.182326, 1, 0, 0.451718,-99) , 
2, -1.58845, 0, 0, 0.665046,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390976,-99) , 
0, 1.17247, 1, 0, 0.472284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145462,-99) , 
1, 0.382446, 1, 0, 0.309351,-99) , 
2, -0.466376, 0, 0, 0.434516,-99) , 
2, -1.21466, 1, 0, 0.461287,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.253629);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.438917, 1, 1, 0.713897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268593,-99) , 
3, -1.65085, 0, 0, 0.631219,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203534,-99) , 
3, -0.908699, 0, 0, 0.493427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307591,-99) , 
3, 1.66395, 0, 0, 0.366423,-99) , 
3, 0.452598, 1, 0, 0.428021,-99) , 
2, -0.936767, 1, 0, 0.456599,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.203652);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394041,-99) , 
0, -1.52972, 0, 0, 0.567247,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425511,-99) , 
2, -0.749247, 1, 0, 0.43417,-99) , 
2, -1.026, 1, 0, 0.452653,-99) , 
NN(
0, 
0, 
-1, -0.449293, 0, -1, 0.261965,-99) , 
1, 1.60105, 1, 0, 0.441247,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.356832);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.494555, 1, 1, 0.750203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.135063,-99) , 
2, -0.7501, 0, 0, 0.304618,-99) , 
1, 1.50499, 1, 0, 0.633669,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180649,-99) , 
1, -1.74913, 0, 0, 0.544631,-99) , 
NN(
0, 
0, 
-1, 0.760049, 0, -1, 0.325597,-99) , 
1, -0.0914697, 1, 0, 0.442817,-99) , 
1, 0.907319, 0, 0, 0.485506,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.283044);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251021,-99) , 
3, 0.52938, 1, 0, 0.585467,-99) , 
NN(
0, 
0, 
-1, 1.1198, 0, -1, 0.387402,-99) , 
1, 0.860284, 1, 0, 0.542393,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442899,-99) , 
1, -0.197352, 1, 0, 0.501387,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196492,-99) , 
0, 0.601915, 1, 0, 0.283182,-99) , 
3, 0.946129, 0, 0, 0.402335,-99) , 
0, 0.18515, 1, 0, 0.474122,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.294264);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452419,-99) , 
1, 1.36586, 1, 0, 0.600291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362622,-99) , 
1, -0.0931069, 1, 0, 0.424907,-99) , 
3, 0.349483, 0, 0, 0.522108,-99) , 
NN(
0, 
0, 
-1, -0.0692552, 1, -1, 0.347262,-99) , 
1, -0.412188, 0, 0, 0.452164,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.203777);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702262,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320282,-99) , 
2, -2.11537, 1, 0, 0.486256,-99) , 
2, -1.44386, 0, 0, 0.577412,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461621,-99) , 
3, -0.311758, 1, 0, 0.477198,-99) , 
NN(
0, 
0, 
-1, -1.8584, 1, -1, 0.245164,-99) , 
3, -0.571877, 0, 0, 0.445812,-99) , 
2, -1.08144, 1, 0, 0.467909,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.311493);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.949054, 1, 1, 0.722108,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402918,-99) , 
0, -1.10744, 1, 0, 0.53941,-99) , 
3, 0.367327, 0, 0, 0.633722,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429255,-99) , 
1, -1.04243, 1, 0, 0.540052,-99) , 
NN(
0, 
0, 
-1, 0.722282, 0, -1, 0.384819,-99) , 
2, -0.204171, 1, 0, 0.424526,-99) , 
1, 0.0908079, 0, 0, 0.522746,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.264468);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287496,-99) , 
2, -1.73396, 0, 0, 0.48546,-99) , 
2, -0.624656, 0, 0, 0.596434,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315,-99) , 
2, 1.54636, 1, 0, 0.540405,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192677,-99) , 
2, -0.107027, 1, 0, 0.345773,-99) , 
3, 0.141505, 0, 0, 0.492298,-99) , 
3, -0.316527, 1, 0, 0.52052,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.268866);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280728,-99) , 
3, -1.11428, 0, 0, 0.589165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419077,-99) , 
2, 0.495982, 0, 0, 0.491647,-99) , 
1, -0.125008, 0, 0, 0.542382,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417065,-99) , 
2, 1.93736, 1, 0, 0.54256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0571947,-99) , 
2, 1.45491, 0, 0, 0.372269,-99) , 
2, 1.32759, 1, 0, 0.518642,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.214677);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480659,-99) , 
0, -0.481785, 0, 0, 0.555837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2079,-99) , 
3, -1.49662, 0, 0, 0.542642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688548,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323385,-99) , 
2, 1.53485, 0, 0, 0.350678,-99) , 
0, -2.08085, 1, 0, 0.39219,-99) , 
1, 0.704076, 1, 0, 0.498486,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.231633);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.903552,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472594,-99) , 
2, -0.0464914, 1, 0, 0.576969,-99) , 
1, -1.02754, 0, 0, 0.664806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420134,-99) , 
3, 0.4942, 0, 0, 0.444902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250458,-99) , 
3, 2.1035, 0, 0, 0.329733,-99) , 
0, 1.52038, 1, 0, 0.412158,-99) , 
1, -0.826718, 1, 0, 0.457961,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.249863);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475754,-99) , 
0, -0.17218, 1, 0, 0.568569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.130001,-99) , 
3, -1.54363, 0, 0, 0.546741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62505,-99) , 
NN(
0, 
0, 
-1, 1.10386, 0, -1, 0.33254,-99) , 
1, -0.744851, 1, 0, 0.37292,-99) , 
0, 1.1401, 1, 0, 0.488396,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.237933);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.497357, 1, 1, 0.710295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452723,-99) , 
1, -0.297941, 1, 0, 0.515854,-99) , 
3, 0.223044, 0, 0, 0.543505,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393529,-99) , 
0, 3.12363, 1, 0, 0.542149,-99) , 
NN(
0, 
0, 
-1, 0.702409, 1, -1, 0.347138,-99) , 
2, 1.1934, 0, 0, 0.399118,-99) , 
0, 0.369719, 1, 0, 0.471418,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.206906);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.558686, 1, 1, 0.800882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436555,-99) , 
2, 0.653654, 1, 0, 0.504727,-99) , 
1, -1.37704, 1, 0, 0.526318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809181,-99) , 
NN(
0, 
0, 
-1, -1.69392, 1, -1, 0.325255,-99) , 
1, 1.37545, 0, 0, 0.405413,-99) , 
3, -0.636326, 0, 0, 0.505174,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.138169);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423845,-99) , 
3, -1.4809, 0, 0, 0.701744,-99) , 
NN(
0, 
0, 
-1, -0.858005, 0, -1, 0.47038,-99) , 
2, -1.026, 1, 0, 0.496274,-99) , 
NN(
0, 
0, 
-1, 0.294103, 0, -1, 0.218722,-99) , 
1, 1.56855, 1, 0, 0.477412,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.210286);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368764,-99) , 
3, -1.52515, 0, 0, 0.68162,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443081,-99) , 
2, 0.590515, 0, 0, 0.510798,-99) , 
NN(
0, 
0, 
-1, -0.68058, 1, -1, 0.286682,-99) , 
3, -0.478481, 0, 0, 0.479603,-99) , 
0, -1.56562, 1, 0, 0.498548,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.229777);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.153647, 0, 1, 0.58539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136427,-99) , 
3, 2.29195, 0, 0, 0.363439,-99) , 
0, 3.05472, 1, 0, 0.567697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152804,-99) , 
3, 1.48692, 0, 0, 0.337776,-99) , 
1, 1.56855, 1, 0, 0.54674,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.191497);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309653,-99) , 
3, -1.41488, 0, 0, 0.672704,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481704,-99) , 
3, 0.00423536, 1, 0, 0.514681,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301111,-99) , 
3, -0.0632058, 0, 0, 0.343617,-99) , 
2, -0.345555, 0, 0, 0.475186,-99) , 
2, -1.07079, 1, 0, 0.493289,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.246467);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.487501, 0, 1, 0.683818,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325095,-99) , 
3, 0.284123, 0, 0, 0.497425,-99) , 
0, -0.289841, 1, 0, 0.534874,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426078,-99) , 
3, -1.62214, 0, 0, 0.626785,-99) , 
NN(
0, 
0, 
-1, -0.995903, 0, -1, 0.239914,-99) , 
2, -1.19231, 1, 0, 0.380037,-99) , 
3, -0.486409, 0, 0, 0.502856,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.334289);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.802738, 1, 1, 0.787556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435878,-99) , 
0, -2.59875, 1, 0, 0.508094,-99) , 
3, -0.630036, 0, 0, 0.601058,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431381,-99) , 
0, 1.58151, 1, 0, 0.536913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26421,-99) , 
1, -0.733145, 1, 0, 0.389532,-99) , 
3, 0.755488, 0, 0, 0.481326,-99) , 
0, -0.448411, 1, 0, 0.525972,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.282601);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.90209,-99) , 
NN(
NN(
0, 
0, 
-1, 0.533451, 0, 1, 0.621952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332687,-99) , 
0, -1.38674, 1, 0, 0.454982,-99) , 
3, -0.133228, 0, 0, 0.572335,-99) , 
1, -2.0103, 1, 0, 0.584611,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.169104);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.454873, 1, 1, 0.819469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449742,-99) , 
3, -0.555361, 0, 0, 0.689748,-99) , 
NN(
NN(
0, 
0, 
-1, 0.322897, 1, 1, 0.733746,-99) , 
NN(
0, 
0, 
-1, -0.822334, 0, -1, 0.439445,-99) , 
0, -2.56266, 1, 0, 0.455315,-99) , 
1, -1.1971, 1, 0, 0.476262,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.213045);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491711,-99) , 
0, 1.2612, 1, 0, 0.70697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394627,-99) , 
3, -0.40554, 0, 0, 0.642507,-99) , 
NN(
NN(
0, 
0, 
-1, 0.625065, 1, 1, 0.659666,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385326,-99) , 
2, -0.0311793, 1, 0, 0.455279,-99) , 
3, 2.30091, 0, 0, 0.470967,-99) , 
1, -0.723044, 1, 0, 0.499115,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.165914);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.42744, 0, 1, 0.725198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357104,-99) , 
3, -0.375794, 0, 0, 0.491102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.102375,-99) , 
2, 2.40547, 1, 0, 0.475286,-99) , 
0, -2.09317, 1, 0, 0.503504,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.254531);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352154,-99) , 
1, -0.214065, 0, 0, 0.683619,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385858,-99) , 
1, -1.2442, 1, 0, 0.468242,-99) , 
0, -1.06439, 0, 0, 0.556131,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39263,-99) , 
3, 1.01134, 0, 0, 0.447572,-99) , 
NN(
0, 
0, 
-1, -1.61967, 1, -1, 0.176917,-99) , 
1, -1.33919, 0, 0, 0.416594,-99) , 
2, -0.242286, 1, 0, 0.464539,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.276544);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456268,-99) , 
3, -1.11814, 0, 0, 0.67732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302539,-99) , 
3, 0.186516, 0, 0, 0.531047,-99) , 
0, -0.212431, 1, 0, 0.599236,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486483,-99) , 
0, 0.216665, 1, 0, 0.531076,-99) , 
NN(
0, 
0, 
-1, 1.14399, 0, -1, 0.265483,-99) , 
3, 0.0282342, 0, 0, 0.444902,-99) , 
1, 0.434194, 1, 0, 0.537026,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.322464);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44758,-99) , 
0, -1.09297, 0, 0, 0.742908,-99) , 
NN(
0, 
0, 
-1, 0, 1, 1, 0.558565,-99) , 
1, 1.98331, 1, 0, 0.719848,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250305,-99) , 
1, 0.791166, 1, 0, 0.561669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339001,-99) , 
1, -1.14782, 1, 0, 0.405931,-99) , 
2, 0.764297, 1, 0, 0.514699,-99) , 
1, 0.976427, 0, 0, 0.558962,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.21599);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496887,-99) , 
2, 0.0365965, 0, 0, 0.708165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325138,-99) , 
0, 3.44723, 1, 0, 0.501198,-99) , 
2, 0.454775, 1, 0, 0.557577,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483835,-99) , 
1, 1.21814, 1, 0, 0.58418,-99) , 
NN(
0, 
0, 
-1, -0.791583, 1, -1, 0.365866,-99) , 
1, 0.918202, 0, 0, 0.40415,-99) , 
3, 0.131392, 0, 0, 0.492854,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.289583);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40355,-99) , 
0, 0.0850758, 1, 0, 0.588216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350109,-99) , 
2, -1.75768, 0, 0, 0.574024,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393485,-99) , 
0, 1.36867, 1, 0, 0.470269,-99) , 
NN(
0, 
0, 
-1, 0.372488, 0, -1, 0.21085,-99) , 
0, 0.758304, 0, 0, 0.425542,-99) , 
0, 0.438571, 1, 0, 0.503012,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.165212);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786058,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4439,-99) , 
0, 2.44341, 0, 0, 0.458224,-99) , 
3, 2.36584, 0, 0, 0.471141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.134798,-99) , 
0, 4.0092, 1, 0, 0.459031,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.257244);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.82818, 0, 1, 0.81033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492438,-99) , 
3, -0.149338, 0, 0, 0.588464,-99) , 
0, -2.42059, 1, 0, 0.613252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193489,-99) , 
0, 3.31582, 1, 0, 0.594468,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.205627);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.760711, 1, 1, 0.644937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295575,-99) , 
1, -0.125285, 1, 0, 0.460814,-99) , 
2, -1.22556, 0, 0, 0.588275,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454397,-99) , 
1, -1.17388, 1, 0, 0.47952,-99) , 
NN(
0, 
0, 
-1, -0.575292, 0, -1, 0.288403,-99) , 
2, -0.346822, 0, 0, 0.445868,-99) , 
0, -1.00865, 1, 0, 0.478431,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.270401);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798054,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446319,-99) , 
2, -0.171824, 0, 0, 0.475895,-99) , 
1, -1.26741, 1, 0, 0.503838,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436178,-99) , 
1, -0.995876, 0, 0, 0.579796,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333188,-99) , 
3, 2.26969, 0, 0, 0.366598,-99) , 
1, -0.751023, 1, 0, 0.40485,-99) , 
2, 0.0824135, 1, 0, 0.449051,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.166622);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.794408, 0, 1, 0.73152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336232,-99) , 
2, 1.72026, 1, 0, 0.526006,-99) , 
2, -1.49842, 1, 0, 0.541047,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628696,-99) , 
NN(
0, 
0, 
-1, 1.29332, 1, -1, 0.336925,-99) , 
0, -1.52253, 1, 0, 0.380592,-99) , 
1, -0.546241, 0, 0, 0.506724,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.163656);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.919877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46641,-99) , 
1, -0.736043, 0, 0, 0.747235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425971,-99) , 
1, 0.937614, 0, 0, 0.576521,-99) , 
1, -0.0761344, 1, 0, 0.645874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834489,-99) , 
NN(
0, 
0, 
-1, -0.94324, 0, -1, 0.460226,-99) , 
3, 2.86886, 0, 0, 0.473278,-99) , 
2, -0.862357, 1, 0, 0.508289,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.19078);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2982, 0, 1, 0.704319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323261,-99) , 
2, 1.43868, 0, 0, 0.480932,-99) , 
2, 0.856454, 1, 0, 0.636894,-99) , 
NN(
NN(
0, 
0, 
-1, -0.170414, 0, 1, 0.815351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258671,-99) , 
1, 0.43054, 1, 0, 0.472034,-99) , 
1, 0.617047, 0, 0, 0.501324,-99) , 
1, 0.814014, 0, 0, 0.540047,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.204074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882312,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45498,-99) , 
0, 2.12039, 1, 0, 0.530665,-99) , 
2, 0.814161, 1, 0, 0.601216,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456642,-99) , 
0, -0.236941, 1, 0, 0.514232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222488,-99) , 
0, 1.1524, 1, 0, 0.476764,-99) , 
3, 1.15656, 0, 0, 0.511019,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.261434);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.07546, 1, 1, 0.616009,-99) , 
NN(
0, 
0, 
-1, -1.37636, 0, -1, 0.397218,-99) , 
2, 1.00818, 1, 0, 0.553801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242551,-99) , 
3, -1.26157, 0, 0, 0.400732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20073,-99) , 
0, -1.51378, 1, 0, 0.331011,-99) , 
3, -0.707817, 0, 0, 0.514786,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.30998);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.938506,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291604,-99) , 
1, 0.0956, 1, 0, 0.44245,-99) , 
0, 1.91783, 1, 0, 0.559946,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437909,-99) , 
3, -1.61487, 0, 0, 0.598082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364836,-99) , 
1, 1.25419, 0, 0, 0.38489,-99) , 
2, -1.42225, 1, 0, 0.410941,-99) , 
0, 1.65381, 0, 0, 0.446027,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.178112);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76638, 0, 1, 0.558944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369733,-99) , 
1, 0.182851, 1, 0, 0.447996,-99) , 
3, 0.711733, 0, 0, 0.47722,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389204,-99) , 
2, 1.84055, 1, 0, 0.520192,-99) , 
NN(
0, 
0, 
-1, 0.0476952, 1, -1, 0.255577,-99) , 
1, 0.619652, 0, 0, 0.349553,-99) , 
2, 1.35246, 1, 0, 0.459008,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.334803);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.92679,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401339,-99) , 
3, -0.702285, 0, 0, 0.61909,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22276,-99) , 
3, 1.07016, 0, 0, 0.45582,-99) , 
0, 0.868455, 1, 0, 0.555258,-99) , 
3, 3.0872, 0, 0, 0.565789,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.187114);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.894044, 1, 1, 0.634503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407483,-99) , 
0, -0.0225028, 1, 0, 0.461383,-99) , 
1, 0.547514, 0, 0, 0.509459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203551,-99) , 
1, 1.75304, 1, 0, 0.497272,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.24793);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698296,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20985,-99) , 
1, 1.87752, 1, 0, 0.563239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403248,-99) , 
3, 2.24208, 0, 0, 0.417576,-99) , 
1, 1.14, 0, 0, 0.442318,-99) , 
2, -1.74892, 1, 0, 0.451786,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.215062);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09746, 1, 1, 0.616636,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288524,-99) , 
2, 0.455565, 1, 0, 0.474437,-99) , 
2, 0.72642, 0, 0, 0.520152,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328067,-99) , 
0, -0.0869144, 0, 0, 0.454049,-99) , 
NN(
0, 
0, 
-1, 1.57369, 0, -1, 0.17306,-99) , 
2, 0.498656, 1, 0, 0.325206,-99) , 
1, 1.15831, 1, 0, 0.492573,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.308335);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446846,-99) , 
3, 0.379507, 0, 0, 0.651937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409114,-99) , 
3, 2.846, 0, 0, 0.446767,-99) , 
0, 1.59719, 1, 0, 0.574196,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363363,-99) , 
2, -1.7195, 0, 0, 0.553159,-99) , 
NN(
0, 
0, 
-1, 0.0618715, 1, -1, 0.343339,-99) , 
0, -1.47459, 1, 0, 0.424299,-99) , 
3, -0.0725463, 0, 0, 0.518201,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.174616);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487998,-99) , 
1, 0.557621, 0, 0, 0.728463,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369243,-99) , 
0, 2.13846, 1, 0, 0.526499,-99) , 
2, 1.78186, 0, 0, 0.541707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.5755, 0, 0, 0.526067,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.289664);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.215554, 0, 1, 0.673738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437729,-99) , 
3, 1.41844, 0, 0, 0.493331,-99) , 
1, -0.749622, 1, 0, 0.536153,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366314,-99) , 
0, -0.20991, 1, 0, 0.446623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237689,-99) , 
1, 1.12939, 0, 0, 0.288191,-99) , 
3, -0.244509, 0, 0, 0.335769,-99) , 
2, -0.0505193, 0, 0, 0.452909,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.132895);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330328,-99) , 
3, 2.58812, 1, 0, 0.530821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323569,-99) , 
0, 0.0178291, 1, 0, 0.435326,-99) , 
1, 0.975366, 1, 0, 0.514703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249858,-99) , 
1, 1.96083, 1, 0, 0.506522,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.275035);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.857813, 1, 1, 0.613252,-99) , 
NN(
0, 
0, 
-1, 0.666657, 1, -1, 0.327158,-99) , 
1, 1.2987, 1, 0, 0.581612,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344506,-99) , 
2, -0.717201, 1, 0, 0.491929,-99) , 
NN(
0, 
0, 
-1, 0.138879, 0, -1, 0.279334,-99) , 
1, -0.307161, 1, 0, 0.371279,-99) , 
3, -0.291428, 0, 0, 0.527912,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.289801);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383619,-99) , 
2, 1.53206, 1, 0, 0.63251,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291691,-99) , 
0, -2.49884, 1, 0, 0.411044,-99) , 
2, -0.861796, 0, 0, 0.580127,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487423,-99) , 
1, -0.719702, 1, 0, 0.602695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401473,-99) , 
2, 1.43504, 0, 0, 0.428836,-99) , 
0, -1.92996, 1, 0, 0.447694,-99) , 
1, 0.198194, 0, 0, 0.509506,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.146408);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460662,-99) , 
0, 3.22492, 1, 0, 0.604341,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472739,-99) , 
0, -0.949461, 1, 0, 0.507316,-99) , 
3, 1.63922, 0, 0, 0.523888,-99) , 
NN(
0, 
0, 
-1, -1.78888, 1, -1, 0.304352,-99) , 
1, -1.43208, 0, 0, 0.507034,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.184393);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38193, 1, 1, 0.573717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417097,-99) , 
2, -1.07344, 1, 0, 0.469615,-99) , 
2, -0.348668, 0, 0, 0.53866,-99) , 
NN(
0, 
0, 
-1, -2.04421, 1, -1, 0.168232,-99) , 
3, -1.51206, 0, 0, 0.521432,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.286011);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400171,-99) , 
0, 0.560368, 1, 0, 0.537431,-99) , 
NN(
0, 
0, 
-1, -2.39294, 1, -1, 0.222796,-99) , 
3, -1.17896, 0, 0, 0.500858,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609844,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296904,-99) , 
1, -1.18957, 1, 0, 0.321224,-99) , 
3, 2.65876, 0, 0, 0.346794,-99) , 
0, 1.20503, 1, 0, 0.443549,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.16077);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336648,-99) , 
3, -0.835877, 0, 0, 0.581887,-99) , 
NN(
0, 
0, 
-1, -0.336387, 0, -1, 0.457483,-99) , 
2, -0.607866, 1, 0, 0.480606,-99) , 
NN(
0, 
0, 
-1, -2.89495, 1, -1, 0.313278,-99) , 
3, -1.16308, 0, 0, 0.470156,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.264164);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0794313, 1, 1, 0.602773,-99) , 
NN(
0, 
0, 
-1, 1.9033, 1, -1, 0.269189,-99) , 
0, 3.49955, 1, 0, 0.572719,-99) , 
NN(
NN(
0, 
0, 
-1, 0.51308, 0, 1, 0.649359,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329977,-99) , 
1, -0.602747, 1, 0, 0.384086,-99) , 
2, -1.4387, 1, 0, 0.428016,-99) , 
3, -0.0447319, 0, 0, 0.510605,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.19193);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474209,-99) , 
1, -0.286351, 0, 0, 0.542755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40001,-99) , 
0, -1.52831, 1, 0, 0.428444,-99) , 
1, 0.332092, 1, 0, 0.491763,-99) , 
NN(
0, 
0, 
-1, -1.8514, 1, -1, 0.262976,-99) , 
1, -1.52075, 0, 0, 0.473108,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.25488);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452753,-99) , 
0, 3.41049, 1, 0, 0.701831,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446723,-99) , 
1, -1.27579, 0, 0, 0.611313,-99) , 
NN(
0, 
0, 
-1, 2.65584, 1, -1, 0.397787,-99) , 
1, -0.498529, 1, 0, 0.451155,-99) , 
3, 2.31481, 0, 0, 0.469027,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.225774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867865,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314033,-99) , 
3, 0.475076, 1, 0, 0.542187,-99) , 
3, 0.772612, 0, 0, 0.563799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755046,-99) , 
NN(
0, 
0, 
-1, 0.65926, 1, -1, 0.380624,-99) , 
1, -1.37148, 1, 0, 0.406159,-99) , 
2, 0.45817, 1, 0, 0.490131,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.174541);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417756,-99) , 
1, -0.74088, 0, 0, 0.695559,-99) , 
NN(
0, 
0, 
-1, -2.51218, 1, 1, 0.545355,-99) , 
2, 0.930556, 0, 0, 0.574312,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378157,-99) , 
3, 2.35413, 0, 0, 0.459833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21858,-99) , 
1, 0.820625, 1, 0, 0.388687,-99) , 
0, 2.82704, 1, 0, 0.5588,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.227011);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04861, 0, 1, 0.67697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25855,-99) , 
0, 2.74956, 0, 0, 0.423783,-99) , 
0, 2.22157, 1, 0, 0.603601,-99) , 
NN(
0, 
0, 
-1, -1.63791, 0, -1, 0.433929,-99) , 
3, 0.256412, 0, 0, 0.51594,-99)    );
  // itree = 200
  fBoostWeights.push_back(0.185784);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0426547, 1, 1, 0.769879,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.933396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498049,-99) , 
3, 0.779744, 0, 0, 0.53423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348739,-99) , 
3, 1.2208, 1, 0, 0.401019,-99) , 
0, 1.23957, 1, 0, 0.484984,-99) , 
1, 1.45393, 0, 0, 0.507221,-99)    );
  // itree = 201
  fBoostWeights.push_back(0.14718);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.616241, 1, 1, 0.774185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474107,-99) , 
0, 1.00666, 1, 0, 0.695064,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466768,-99) , 
0, -1.59668, 1, 0, 0.478499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210821,-99) , 
3, -1.40304, 0, 0, 0.465913,-99) , 
1, 1.14, 0, 0, 0.495811,-99)    );
  // itree = 202
  fBoostWeights.push_back(0.188409);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13634, 1, 1, 0.634154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449102,-99) , 
0, 0.0707912, 1, 0, 0.526323,-99) , 
2, 0.640143, 0, 0, 0.567236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303859,-99) , 
2, 2.37257, 1, 0, 0.559291,-99)    );
  // itree = 203
  fBoostWeights.push_back(0.162824);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490307,-99) , 
0, -0.0121896, 0, 0, 0.54582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209247,-99) , 
2, 1.03611, 1, 0, 0.389101,-99) , 
1, -1.24897, 0, 0, 0.526979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215577,-99) , 
3, -1.68639, 0, 0, 0.516597,-99)    );
  // itree = 204
  fBoostWeights.push_back(0.176354);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426456,-99) , 
1, 0.236139, 1, 0, 0.588033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379355,-99) , 
3, 0.499474, 0, 0, 0.472051,-99) , 
0, -0.0333402, 1, 0, 0.507655,-99) , 
NN(
0, 
0, 
-1, -1.39466, 0, -1, 0.268057,-99) , 
3, -1.15439, 0, 0, 0.4902,-99)    );
  // itree = 205
  fBoostWeights.push_back(0.249601);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.405515, 1, 1, 0.771786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451077,-99) , 
1, 0.969734, 0, 0, 0.49653,-99) , 
2, 0.112346, 0, 0, 0.556875,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429487,-99) , 
3, 1.30905, 0, 0, 0.526524,-99) , 
NN(
0, 
0, 
-1, 0.850332, 0, -1, 0.357685,-99) , 
1, 0.278048, 1, 0, 0.447175,-99) , 
0, 0.394028, 1, 0, 0.501235,-99)    );
  // itree = 206
  fBoostWeights.push_back(0.194876);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.760629, 0, 1, 0.658537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405859,-99) , 
1, 1.63359, 1, 0, 0.62577,-99) , 
NN(
NN(
0, 
0, 
-1, 0.837407, 0, 1, 0.650597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366788,-99) , 
0, 0.883382, 0, 0, 0.472803,-99) , 
2, 0.367569, 1, 0, 0.507837,-99) , 
0, 0.18515, 1, 0, 0.559125,-99)    );
  // itree = 207
  fBoostWeights.push_back(0.157989);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436656,-99) , 
2, -0.287434, 0, 0, 0.524911,-99) , 
0, -1.9026, 1, 0, 0.539547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279699,-99) , 
3, -1.68639, 0, 0, 0.532621,-99)    );
  // itree = 208
  fBoostWeights.push_back(0.273093);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368291,-99) , 
0, 3.41481, 1, 0, 0.619893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33084,-99) , 
0, 0.89211, 1, 0, 0.504204,-99) , 
3, 1.11457, 0, 0, 0.558804,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33597,-99) , 
3, -1.67406, 0, 0, 0.535037,-99) , 
NN(
0, 
0, 
-1, -0.0827872, 0, -1, 0.342024,-99) , 
2, -0.742326, 1, 0, 0.423222,-99) , 
2, 0.0154847, 0, 0, 0.49831,-99)    );
  // itree = 209
  fBoostWeights.push_back(0.271176);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26262, 0, 1, 0.624342,-99) , 
NN(
0, 
0, 
-1, -3.18364, 0, -1, 0.319474,-99) , 
3, -1.30052, 0, 0, 0.595474,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397266,-99) , 
0, 0.823783, 1, 0, 0.438908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208694,-99) , 
3, 0.419222, 0, 0, 0.407152,-99) , 
2, 0.456587, 1, 0, 0.511716,-99)    );
  // itree = 210
  fBoostWeights.push_back(0.221398);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.965093, 0, 1, 0.683132,-99) , 
NN(
0, 
0, 
-1, 0.425865, 1, -1, 0.455636,-99) , 
2, 0.212584, 0, 0, 0.537046,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372123,-99) , 
2, 1.55266, 0, 0, 0.456685,-99) , 
NN(
0, 
0, 
-1, 3.81753, 0, -1, 0.314884,-99) , 
0, 3.21408, 1, 0, 0.425821,-99) , 
2, 1.0535, 1, 0, 0.505741,-99)    );
  // itree = 211
  fBoostWeights.push_back(0.200994);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434827,-99) , 
2, 1.63581, 1, 0, 0.622252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188888,-99) , 
0, 1.03635, 1, 0, 0.512635,-99) , 
3, 0.876835, 0, 0, 0.551561,-99) , 
NN(
0, 
0, 
-1, 0.867863, 1, -1, 0.321086,-99) , 
1, 1.69291, 1, 0, 0.53618,-99)    );
  // itree = 212
  fBoostWeights.push_back(0.167386);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.08122, 1, 1, 0.579265,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374436,-99) , 
2, -1.13454, 1, 0, 0.467637,-99) , 
3, -0.707817, 0, 0, 0.561149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331483,-99) , 
1, 1.94792, 1, 0, 0.552004,-99)    );
  // itree = 213
  fBoostWeights.push_back(0.128899);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7222, 1, 1, 0.637368,-99) , 
NN(
0, 
0, 
-1, 1.83401, 1, -1, 0.477486,-99) , 
3, 1.63922, 0, 0, 0.494606,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339682,-99) , 
0, -0.868934, 0, 0, 0.4564,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232712,-99) , 
3, 2.12586, 0, 0, 0.288063,-99) , 
2, 0.328535, 1, 0, 0.380121,-99) , 
1, 0.843066, 1, 0, 0.463172,-99)    );
  // itree = 214
  fBoostWeights.push_back(0.334137);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0821531, 1, 1, 0.756047,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384917,-99) , 
3, -0.892544, 0, 0, 0.439063,-99) , 
3, -0.654859, 0, 0, 0.625429,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271181,-99) , 
2, 1.3804, 1, 0, 0.55444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324273,-99) , 
1, 0.978907, 0, 0, 0.392798,-99) , 
1, -0.0188387, 1, 0, 0.452655,-99) , 
2, 0.0824135, 1, 0, 0.524224,-99)    );
  // itree = 215
  fBoostWeights.push_back(0.2267);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.85608, 0, 1, 0.778903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431411,-99) , 
3, 0.713992, 0, 0, 0.566528,-99) , 
0, -0.937939, 1, 0, 0.61855,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428018,-99) , 
0, 0.38203, 1, 0, 0.491709,-99) , 
NN(
0, 
0, 
-1, 0.160441, 1, -1, 0.363921,-99) , 
0, -1.23152, 0, 0, 0.463582,-99) , 
1, 0.665006, 0, 0, 0.511567,-99)    );
  // itree = 216
  fBoostWeights.push_back(0.274084);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358864,-99) , 
2, -1.45728, 0, 0, 0.648364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241104,-99) , 
0, -0.223344, 0, 0, 0.470592,-99) , 
0, -1.05284, 1, 0, 0.511537,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296175,-99) , 
1, 1.47218, 1, 0, 0.47448,-99) , 
NN(
0, 
0, 
-1, 1.42831, 0, -1, 0.269564,-99) , 
2, 0.385083, 1, 0, 0.361365,-99) , 
1, 0.708322, 1, 0, 0.467426,-99)    );
  // itree = 217
  fBoostWeights.push_back(0.238347);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.200696, 0, 1, 0.594816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156458,-99) , 
3, -1.59121, 0, 0, 0.558372,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418208,-99) , 
0, -0.188397, 1, 0, 0.435826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239122,-99) , 
3, 0.0959085, 0, 0, 0.405662,-99) , 
3, -0.128257, 1, 0, 0.452044,-99)    );
  // itree = 218
  fBoostWeights.push_back(0.234814);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367184,-99) , 
0, 2.11537, 1, 0, 0.510933,-99) , 
0, -0.404725, 1, 0, 0.541204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225599,-99) , 
1, 1.1121, 1, 0, 0.454064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139447,-99) , 
0, -0.743958, 1, 0, 0.374243,-99) , 
3, -0.206128, 0, 0, 0.485042,-99)    );
  // itree = 219
  fBoostWeights.push_back(0.176899);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372543,-99) , 
0, -1.32635, 0, 0, 0.572117,-99) , 
NN(
0, 
0, 
-1, 0.814014, 1, -1, 0.457121,-99) , 
2, -0.519703, 1, 0, 0.482068,-99) , 
NN(
0, 
0, 
-1, 0.509936, 1, -1, 0.175521,-99) , 
2, -1.5546, 0, 0, 0.467458,-99)    );
  // itree = 220
  fBoostWeights.push_back(0.263469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.64961, 1, 1, 0.820029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300475,-99) , 
0, -2.81195, 1, 0, 0.495694,-99) , 
3, -1.04018, 0, 0, 0.667465,-99) , 
NN(
NN(
0, 
0, 
-1, 0.447678, 1, 1, 0.560273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349759,-99) , 
2, -0.498841, 1, 0, 0.431233,-99) , 
3, 0.560525, 0, 0, 0.494612,-99) , 
0, -1.22798, 1, 0, 0.522935,-99)    );
  // itree = 221
  fBoostWeights.push_back(0.225126);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0669289, 1, 1, 0.648761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430718,-99) , 
2, -0.780555, 1, 0, 0.488648,-99) , 
1, -0.348419, 0, 0, 0.544624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397957,-99) , 
3, -1.14965, 1, 0, 0.413714,-99) , 
1, 0.284413, 1, 0, 0.432465,-99) , 
1, 0.136163, 1, 0, 0.48459,-99)    );
  // itree = 222
  fBoostWeights.push_back(0.271042);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344536,-99) , 
3, -0.531343, 0, 0, 0.569352,-99) , 
NN(
0, 
0, 
-1, 1.08713, 1, -1, 0.360659,-99) , 
1, 0.949905, 1, 0, 0.536278,-99) , 
NN(
NN(
0, 
0, 
-1, 1.58223, 1, 1, 0.687741,-99) , 
NN(
0, 
0, 
-1, 0.226333, 1, -1, 0.28958,-99) , 
1, 0.969734, 0, 0, 0.392603,-99) , 
2, -0.55359, 0, 0, 0.493708,-99)    );
  // itree = 223
  fBoostWeights.push_back(0.092036);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.182851, 1, 1, 0.695218,-99) , 
NN(
NN(
0, 
0, 
-1, -1.24439, 1, 1, 0.519018,-99) , 
NN(
0, 
0, 
-1, -2.06981, 1, -1, 0.311792,-99) , 
3, -0.860299, 0, 0, 0.499076,-99) , 
0, -2.52052, 1, 0, 0.512063,-99)    );
  // itree = 224
  fBoostWeights.push_back(0.293317);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19769, 1, 1, 0.676017,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133147,-99) , 
0, 3.14658, 1, 0, 0.404964,-99) , 
1, -0.438016, 0, 0, 0.600998,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463431,-99) , 
3, -0.194685, 0, 0, 0.538992,-99) , 
NN(
0, 
0, 
-1, 0.408554, 1, -1, 0.170711,-99) , 
2, 0.25289, 1, 0, 0.466497,-99) , 
2, 0.521751, 0, 0, 0.522176,-99)    );
  // itree = 225
  fBoostWeights.push_back(0.2984);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480656,-99) , 
1, -0.972375, 0, 0, 0.645616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364169,-99) , 
1, 0.607945, 1, 0, 0.460512,-99) , 
2, -0.813047, 0, 0, 0.568601,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365046,-99) , 
2, 1.00045, 1, 0, 0.58628,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338901,-99) , 
3, 2.15324, 0, 0, 0.372465,-99) , 
1, -1.17388, 1, 0, 0.399418,-99) , 
0, -0.0887253, 1, 0, 0.450087,-99)    );
  // itree = 226
  fBoostWeights.push_back(0.272754);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45501,-99) , 
0, 2.33443, 1, 0, 0.726075,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466195,-99) , 
0, -1.29128, 1, 0, 0.517633,-99) , 
2, 0.699803, 0, 0, 0.560287,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.954364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356374,-99) , 
0, 3.41174, 1, 0, 0.645577,-99) , 
NN(
0, 
0, 
-1, -0.0988239, 1, -1, 0.21596,-99) , 
3, 2.09952, 0, 0, 0.394326,-99) , 
2, 1.27141, 1, 0, 0.532984,-99)    );
  // itree = 227
  fBoostWeights.push_back(0.296857);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448397,-99) , 
3, 0.833428, 0, 0, 0.530708,-99) , 
NN(
0, 
0, 
-1, 1.93268, 1, -1, 0.190013,-99) , 
2, 1.44879, 1, 0, 0.496285,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388865,-99) , 
1, -1.27727, 1, 0, 0.471121,-99) , 
NN(
0, 
0, 
-1, -0.604916, 0, -1, 0.181784,-99) , 
1, -0.672856, 1, 0, 0.360217,-99) , 
1, -0.403847, 0, 0, 0.449772,-99)    );
  // itree = 228
  fBoostWeights.push_back(0.233317);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0168277, 0, 1, 0.592038,-99) , 
NN(
0, 
0, 
-1, -1.59299, 0, -1, 0.277844,-99) , 
3, -1.23181, 0, 0, 0.552714,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455698,-99) , 
2, 0.805578, 1, 0, 0.495584,-99) , 
NN(
0, 
0, 
-1, 0.134195, 0, -1, 0.263497,-99) , 
3, 0.716234, 0, 0, 0.420194,-99) , 
2, 0.391241, 1, 0, 0.490506,-99)    );
  // itree = 229
  fBoostWeights.push_back(0.219112);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.373907, 0, 1, 0.71846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320807,-99) , 
1, 1.19187, 1, 0, 0.504545,-99) , 
0, 1.25357, 1, 0, 0.573095,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37684,-99) , 
1, 0.433143, 1, 0, 0.503926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217264,-99) , 
0, -0.292152, 1, 0, 0.460075,-99) , 
3, 0.268003, 0, 0, 0.522202,-99)    );
  // itree = 230
  fBoostWeights.push_back(0.282019);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454038,-99) , 
0, 1.07833, 1, 0, 0.610924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41833,-99) , 
1, 0.938572, 0, 0, 0.459478,-99) , 
3, -0.276801, 0, 0, 0.549052,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324079,-99) , 
2, 1.19788, 1, 0, 0.430805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237959,-99) , 
3, 1.58154, 0, 0, 0.370434,-99) , 
0, 1.65381, 1, 0, 0.507199,-99)    );
  // itree = 231
  fBoostWeights.push_back(0.22909);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.23826, 1, 1, 0.749772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328676,-99) , 
0, -2.55908, 0, 0, 0.526126,-99) , 
3, -0.645647, 0, 0, 0.633893,-99) , 
NN(
NN(
0, 
0, 
-1, 2.70172, 1, 1, 0.596209,-99) , 
NN(
0, 
0, 
-1, 1.15895, 1, -1, 0.41364,-99) , 
3, 1.56805, 0, 0, 0.458671,-99) , 
0, -0.416978, 1, 0, 0.508495,-99)    );
  // itree = 232
  fBoostWeights.push_back(0.208133);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.0354, 0, 1, 0.784235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321091,-99) , 
1, -0.446593, 0, 0, 0.534089,-99) , 
1, -0.868918, 1, 0, 0.567982,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545082,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404825,-99) , 
2, 1.09298, 1, 0, 0.484129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18844,-99) , 
3, 0.158111, 0, 0, 0.444847,-99) , 
2, 0.185719, 1, 0, 0.498459,-99)    );
  // itree = 233
  fBoostWeights.push_back(0.263127);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46615,-99) , 
3, 1.21571, 1, 0, 0.739476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472465,-99) , 
3, -0.584492, 0, 0, 0.680864,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577516,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.00608601,-99) , 
2, -1.49842, 0, 0, 0.548676,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359179,-99) , 
0, -1.48383, 1, 0, 0.406139,-99) , 
1, -0.204197, 0, 0, 0.503019,-99) , 
1, -0.919085, 1, 0, 0.526295,-99)    );
  // itree = 234
  fBoostWeights.push_back(0.305483);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.878645, 0, 1, 0.753795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.162679,-99) , 
2, -1.21074, 1, 0, 0.43832,-99) , 
3, -1.02649, 0, 0, 0.603788,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403075,-99) , 
2, 0.309513, 1, 0, 0.446712,-99) , 
NN(
0, 
0, 
-1, -0.377252, 0, -1, 0.194363,-99) , 
2, -0.318168, 0, 0, 0.404109,-99) , 
0, -1.06144, 1, 0, 0.44527,-99)    );
  // itree = 235
  fBoostWeights.push_back(0.272687);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.38803, 1, 1, 0.650471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292926,-99) , 
3, -1.55038, 0, 0, 0.605359,-99) , 
NN(
NN(
0, 
0, 
-1, 0.490557, 1, 1, 0.597725,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359557,-99) , 
0, -0.741376, 1, 0, 0.398057,-99) , 
3, 0.851763, 0, 0, 0.492012,-99) , 
2, -0.351252, 1, 0, 0.521986,-99)    );
  // itree = 236
  fBoostWeights.push_back(0.258841);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484003,-99) , 
2, 0.530204, 1, 0, 0.570201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343025,-99) , 
0, -2.36379, 1, 0, 0.413517,-99) , 
3, -0.0272888, 0, 0, 0.504823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.128902,-99) , 
2, 2.22841, 1, 0, 0.490248,-99)    );
  // itree = 237
  fBoostWeights.push_back(0.272935);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484974,-99) , 
2, 1.63568, 1, 0, 0.69267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443917,-99) , 
0, 1.05031, 1, 0, 0.54518,-99) , 
3, 1.5318, 0, 0, 0.571822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452821,-99) , 
1, 0.981503, 1, 0, 0.564718,-99) , 
NN(
0, 
0, 
-1, -0.24736, 0, -1, 0.317396,-99) , 
3, 1.37504, 0, 0, 0.382517,-99) , 
1, 0.237261, 1, 0, 0.476808,-99)    );
  // itree = 238
  fBoostWeights.push_back(0.21302);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20644, 1, 1, 0.617518,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363953,-99) , 
0, -0.0247421, 1, 0, 0.496065,-99) , 
3, 0.579812, 0, 0, 0.532598,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377216,-99) , 
3, 2.61399, 1, 0, 0.496335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209898,-99) , 
3, 2.30411, 0, 0, 0.345671,-99) , 
0, 2.56595, 1, 0, 0.509341,-99)    );
  // itree = 239
  fBoostWeights.push_back(0.230447);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.454873, 1, 1, 0.746544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38814,-99) , 
1, 0.303761, 0, 0, 0.466687,-99) , 
1, -0.920106, 1, 0, 0.497758,-99) , 
NN(
0, 
0, 
-1, -1.47513, 1, -1, 0.308863,-99) , 
3, -0.740231, 0, 0, 0.463044,-99)    );
  // itree = 240
  fBoostWeights.push_back(0.172684);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01595, 1, 1, 0.559663,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357711,-99) , 
0, -0.760763, 1, 0, 0.43676,-99) , 
0, 0.301988, 0, 0, 0.502688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.63625, 0, 0, 0.488315,-99)    );
  // itree = 241
  fBoostWeights.push_back(0.125676);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430383,-99) , 
0, 1.32308, 1, 0, 0.490598,-99) , 
1, -1.95752, 1, 0, 0.502056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.147,-99) , 
3, -1.49662, 0, 0, 0.489018,-99)    );
  // itree = 242
  fBoostWeights.push_back(0.169063);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.0176, 0, 1, 0.550031,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394884,-99) , 
1, 0.819825, 0, 0, 0.448796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0995173,-99) , 
1, 1.24012, 1, 0, 0.395966,-99) , 
3, -0.316527, 0, 0, 0.508609,-99)    );
  // itree = 243
  fBoostWeights.push_back(0.275435);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473426,-99) , 
2, -1.21085, 1, 0, 0.520339,-99) , 
NN(
0, 
0, 
-1, -1.22476, 1, -1, 0.31779,-99) , 
1, -0.940758, 0, 0, 0.453179,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340874,-99) , 
0, 0.245212, 1, 0, 0.395655,-99) , 
NN(
0, 
0, 
-1, 1.01584, 0, -1, 0.165802,-99) , 
2, -0.741245, 0, 0, 0.354699,-99) , 
1, 0.0567207, 1, 0, 0.404399,-99)    );
  // itree = 244
  fBoostWeights.push_back(0.287694);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45968, 0, 1, 0.812575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45777,-99) , 
3, -0.255092, 0, 0, 0.677769,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347272,-99) , 
0, 2.73761, 1, 0, 0.505709,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340952,-99) , 
3, -1.4506, 1, 0, 0.364119,-99) , 
3, 0.899086, 0, 0, 0.419388,-99) , 
1, -1.12613, 1, 0, 0.444877,-99)    );
  // itree = 245
  fBoostWeights.push_back(0.255589);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42117, 1, 1, 0.613952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356995,-99) , 
2, 0.453392, 1, 0, 0.500925,-99) , 
2, 0.981041, 0, 0, 0.537303,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265609,-99) , 
1, -1.02201, 0, 0, 0.528174,-99) , 
NN(
0, 
0, 
-1, 0.74373, 0, -1, 0.203444,-99) , 
1, -0.24519, 1, 0, 0.365905,-99) , 
3, -0.774089, 0, 0, 0.510738,-99)    );
  // itree = 246
  fBoostWeights.push_back(0.214301);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495833,-99) , 
0, 1.90207, 1, 0, 0.650292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390608,-99) , 
0, 2.20669, 1, 0, 0.453237,-99) , 
2, 1.24002, 1, 0, 0.550296,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356261,-99) , 
3, -0.797906, 0, 0, 0.51923,-99) , 
NN(
0, 
0, 
-1, 0.530985, 1, -1, 0.385853,-99) , 
1, 0.213586, 1, 0, 0.462524,-99) , 
3, 1.15656, 0, 0, 0.488416,-99)    );
  // itree = 247
  fBoostWeights.push_back(0.186245);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71996, 0, 1, 0.555428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340112,-99) , 
1, -0.0690984, 1, 0, 0.415902,-99) , 
0, 1.32881, 1, 0, 0.498529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131256,-99) , 
2, -1.57103, 0, 0, 0.483526,-99)    );
  // itree = 248
  fBoostWeights.push_back(0.0758013);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25565,-99) , 
3, -0.884514, 0, 0, 0.487757,-99) , 
0, -2.22117, 1, 0, 0.501001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289463,-99) , 
2, -1.51059, 0, 0, 0.49074,-99)    );
  // itree = 249
  fBoostWeights.push_back(0.276252);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17945, 1, 1, 0.747445,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379343,-99) , 
1, -0.996621, 0, 0, 0.510725,-99) , 
3, 0.325498, 0, 0, 0.613944,-99) , 
NN(
NN(
0, 
0, 
-1, 2.30163, 1, 1, 0.612616,-99) , 
NN(
0, 
0, 
-1, 1.12355, 1, -1, 0.381305,-99) , 
2, 1.43186, 0, 0, 0.416984,-99) , 
1, -0.55923, 1, 0, 0.46693,-99)    );
  // itree = 250
  fBoostWeights.push_back(0.18955);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712227,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387287,-99) , 
0, -2.25336, 1, 0, 0.615405,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339868,-99) , 
3, 0.542057, 0, 0, 0.425157,-99) , 
2, -1.08144, 1, 0, 0.44365,-99) , 
1, -1.70534, 1, 0, 0.454432,-99)    );
  // itree = 251
  fBoostWeights.push_back(0.285962);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424029,-99) , 
1, -0.0758372, 1, 0, 0.49005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0810189,-99) , 
2, -1.79293, 0, 0, 0.46997,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232752,-99) , 
0, 0.882667, 1, 0, 0.393097,-99) , 
NN(
0, 
0, 
-1, -0.688051, 1, -1, 0.234628,-99) , 
3, -0.861543, 0, 0, 0.343901,-99) , 
1, -0.438016, 0, 0, 0.436192,-99)    );
  // itree = 252
  fBoostWeights.push_back(0.328148);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.571792, 0, 1, 0.683757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350419,-99) , 
1, 0.386818, 0, 0, 0.546642,-99) , 
1, 0.0932693, 1, 0, 0.610964,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263808,-99) , 
0, 4.11216, 1, 0, 0.544869,-99) , 
NN(
0, 
0, 
-1, 2.02573, 1, -1, 0.271933,-99) , 
3, 1.64917, 0, 0, 0.440717,-99) , 
0, 1.49809, 1, 0, 0.558124,-99)    );
  // itree = 253
  fBoostWeights.push_back(0.284212);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206912,-99) , 
0, 2.41999, 1, 0, 0.622559,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386161,-99) , 
2, 0.863656, 0, 0, 0.443195,-99) , 
1, -0.395305, 1, 0, 0.483693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605372,-99) , 
NN(
0, 
0, 
-1, 0.448731, 0, -1, 0.214917,-99) , 
1, -1.93215, 1, 0, 0.32139,-99) , 
1, -1.1416, 0, 0, 0.463825,-99)    );
  // itree = 254
  fBoostWeights.push_back(0.322249);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499901,-99) , 
2, -0.579733, 0, 0, 0.652002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364084,-99) , 
1, 0.864102, 0, 0, 0.437025,-99) , 
0, 1.00527, 1, 0, 0.603977,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416134,-99) , 
2, 1.34189, 1, 0, 0.604462,-99) , 
NN(
0, 
0, 
-1, 1.40292, 0, -1, 0.346407,-99) , 
1, -0.237758, 1, 0, 0.408074,-99) , 
2, 0.897689, 1, 0, 0.540047,-99)    );
  // itree = 255
  fBoostWeights.push_back(0.159957);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.403002, 1, 1, 0.715557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293239,-99) , 
3, -1.52156, 0, 0, 0.635175,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494388,-99) , 
0, -0.141242, 1, 0, 0.518353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224177,-99) , 
0, -0.973931, 1, 0, 0.36317,-99) , 
3, -0.247133, 0, 0, 0.496607,-99) , 
0, -1.40205, 1, 0, 0.515289,-99)    );
  // itree = 256
  fBoostWeights.push_back(0.161988);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0407191, 0, 1, 0.785718,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496326,-99) , 
0, -1.52773, 1, 0, 0.548609,-99) , 
3, 0.242964, 0, 0, 0.587324,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491331,-99) , 
0, 0.706074, 1, 0, 0.531329,-99) , 
NN(
0, 
0, 
-1, 1.16837, 1, -1, 0.327536,-99) , 
2, 0.315477, 0, 0, 0.491873,-99) , 
0, 0.321785, 1, 0, 0.53577,-99)    );
  // itree = 257
  fBoostWeights.push_back(0.170786);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.00262, 0, 1, 0.737338,-99) , 
NN(
NN(
0, 
0, 
-1, 0.987752, 0, 1, 0.555101,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352458,-99) , 
2, 1.2561, 1, 0, 0.421046,-99) , 
2, 1.0725, 1, 0, 0.528828,-99) , 
3, 2.63866, 0, 0, 0.541011,-99)    );
  // itree = 258
  fBoostWeights.push_back(0.294189);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486654,-99) , 
1, 0.530773, 1, 0, 0.665337,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346598,-99) , 
0, 2.63353, 0, 0, 0.451184,-99) , 
2, 1.10613, 1, 0, 0.559251,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211166,-99) , 
3, -1.96233, 0, 0, 0.529404,-99) , 
NN(
0, 
0, 
-1, -0.226105, 0, -1, 0.337359,-99) , 
2, -0.583373, 1, 0, 0.410833,-99) , 
3, 0.742135, 0, 0, 0.473805,-99)    );
  // itree = 259
  fBoostWeights.push_back(0.161675);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.03092, 0, 1, 0.709351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28358,-99) , 
3, 0.485931, 0, 0, 0.491843,-99) , 
1, -0.411527, 1, 0, 0.54091,-99) , 
NN(
0, 
0, 
-1, -1.51657, 0, -1, 0.420758,-99) , 
3, 0.27076, 0, 0, 0.482056,-99)    );
  // itree = 260
  fBoostWeights.push_back(0.300783);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446829,-99) , 
2, 0.306714, 0, 0, 0.708515,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276355,-99) , 
0, 0.464202, 1, 0, 0.522925,-99) , 
2, 0.183843, 0, 0, 0.591947,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393849,-99) , 
1, -0.131841, 1, 0, 0.488079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207468,-99) , 
0, 3.24824, 1, 0, 0.429638,-99) , 
2, 1.03213, 1, 0, 0.547326,-99)    );
  // itree = 261
  fBoostWeights.push_back(0.244982);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.44496, 0, 1, 0.666921,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227656,-99) , 
3, 0.918736, 0, 0, 0.491738,-99) , 
0, 0.749912, 1, 0, 0.54862,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658351,-99) , 
NN(
0, 
0, 
-1, 0.272882, 1, -1, 0.36432,-99) , 
1, 1.25988, 0, 0, 0.408405,-99) , 
3, -0.231227, 0, 0, 0.507012,-99)    );
  // itree = 262
  fBoostWeights.push_back(0.23816);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.258938, 0, 1, 0.654316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441334,-99) , 
0, 0.575438, 0, 0, 0.496566,-99) , 
1, 0.0962489, 0, 0, 0.585638,-99) , 
NN(
NN(
0, 
0, 
-1, 2.98025, 0, 1, 0.649043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133568,-99) , 
0, 2.78475, 1, 0, 0.442461,-99) , 
3, 2.4428, 0, 0, 0.493034,-99) , 
0, 1.56223, 1, 0, 0.558037,-99)    );
  // itree = 263
  fBoostWeights.push_back(0.205173);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42435,-99) , 
1, 0.747597, 1, 0, 0.530165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236021,-99) , 
1, -1.4346, 0, 0, 0.512548,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235071,-99) , 
2, 2.38082, 1, 0, 0.478509,-99) , 
NN(
0, 
0, 
-1, -0.280281, 1, -1, 0.241942,-99) , 
3, 1.34643, 0, 0, 0.404101,-99) , 
2, 0.973129, 1, 0, 0.478543,-99)    );
  // itree = 264
  fBoostWeights.push_back(0.185701);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0476316, 0, 1, 0.564462,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303556,-99) , 
3, 0.135636, 0, 0, 0.429106,-99) , 
1, 0.291673, 1, 0, 0.500846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184665,-99) , 
0, 4.44906, 1, 0, 0.489185,-99)    );
  // itree = 265
  fBoostWeights.push_back(0.205412);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459926,-99) , 
3, 0.269147, 1, 0, 0.506202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267245,-99) , 
0, -0.929147, 1, 0, 0.412927,-99) , 
2, -0.300753, 0, 0, 0.471458,-99) , 
NN(
0, 
0, 
-1, 1.9033, 0, -1, 0.242063,-99) , 
0, 3.06373, 1, 0, 0.453974,-99)    );
  // itree = 266
  fBoostWeights.push_back(0.20726);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497459,-99) , 
3, -0.995795, 0, 0, 0.636998,-99) , 
NN(
0, 
0, 
-1, -1.11459, 0, -1, 0.387205,-99) , 
1, -0.275778, 0, 0, 0.552187,-99) , 
NN(
0, 
0, 
-1, 0.728324, 0, -1, 0.408105,-99) , 
0, -0.701588, 1, 0, 0.44709,-99)    );
  // itree = 267
  fBoostWeights.push_back(0.200892);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462425,-99) , 
1, 1.15768, 1, 0, 0.666116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254484,-99) , 
3, 1.15657, 0, 0, 0.443923,-99) , 
0, 1.18014, 1, 0, 0.531313,-99) , 
NN(
0, 
0, 
-1, 1.56729, 1, -1, 0.418478,-99) , 
3, 0.0391675, 0, 0, 0.492514,-99)    );
  // itree = 268
  fBoostWeights.push_back(0.10893);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.153097, 0, 1, 0.714343,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866602,-99) , 
NN(
0, 
0, 
-1, -0.396564, 0, -1, 0.466716,-99) , 
0, -3.70314, 1, 0, 0.477657,-99) , 
1, -1.1416, 1, 0, 0.493966,-99)    );
  // itree = 269
  fBoostWeights.push_back(0.262074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0706346, 0, 1, 0.841651,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383195,-99) , 
1, 0.748801, 1, 0, 0.559447,-99) , 
2, -0.331146, 0, 0, 0.61391,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398277,-99) , 
2, 1.06381, 1, 0, 0.51352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358572,-99) , 
0, -0.223702, 1, 0, 0.39277,-99) , 
1, -0.134696, 0, 0, 0.463329,-99) , 
2, -0.0811742, 1, 0, 0.514009,-99)    );
  // itree = 270
  fBoostWeights.push_back(0.192696);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437214,-99) , 
1, -0.480148, 0, 0, 0.52794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379555,-99) , 
3, 2.16535, 0, 0, 0.433658,-99) , 
0, 1.48509, 1, 0, 0.500232,-99) , 
NN(
0, 
0, 
-1, 0.357045, 1, -1, 0.124166,-99) , 
0, 3.63138, 1, 0, 0.481078,-99)    );
  // itree = 271
  fBoostWeights.push_back(0.258706);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.681504, 1, 1, 0.80339,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340713,-99) , 
3, 2.86629, 0, 0, 0.449183,-99) , 
2, 1.32531, 1, 0, 0.629086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779329,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416893,-99) , 
0, -0.957324, 1, 0, 0.455354,-99) , 
3, 1.24988, 0, 0, 0.473994,-99) , 
0, 1.80911, 0, 0, 0.515523,-99)    );
  // itree = 272
  fBoostWeights.push_back(0.139779);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846124,-99) , 
NN(
0, 
0, 
-1, 2.3465, 1, -1, 0.438475,-99) , 
1, -2.0036, 1, 0, 0.449809,-99)    );
  // itree = 273
  fBoostWeights.push_back(0.224515);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369105,-99) , 
1, 0.104677, 1, 0, 0.647119,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440363,-99) , 
1, -0.701484, 1, 0, 0.546941,-99) , 
1, -0.425693, 0, 0, 0.594977,-99) , 
NN(
NN(
0, 
0, 
-1, 0.970258, 1, 1, 0.669547,-99) , 
NN(
0, 
0, 
-1, 0.985494, 1, -1, 0.447162,-99) , 
0, 2.39907, 0, 0, 0.483503,-99) , 
1, 0.234105, 1, 0, 0.545932,-99)    );
  // itree = 274
  fBoostWeights.push_back(0.249636);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42126, 0, 1, 0.615402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422339,-99) , 
0, -1.75807, 1, 0, 0.484812,-99) , 
3, -0.037816, 0, 0, 0.556397,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322513,-99) , 
0, 3.69439, 1, 0, 0.428895,-99) , 
NN(
0, 
0, 
-1, 1.57882, 1, -1, 0.241309,-99) , 
3, 2.21964, 0, 0, 0.330945,-99) , 
0, 1.92994, 1, 0, 0.504032,-99)    );
  // itree = 275
  fBoostWeights.push_back(0.301262);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360791,-99) , 
2, -0.855194, 0, 0, 0.601651,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406741,-99) , 
1, 1.55081, 0, 0, 0.435559,-99) , 
0, 0.931227, 1, 0, 0.519195,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733139,-99) , 
NN(
0, 
0, 
-1, 0.131373, 0, -1, 0.336803,-99) , 
1, -1.76572, 1, 0, 0.386427,-99) , 
1, -0.452168, 0, 0, 0.478592,-99)    );
  // itree = 276
  fBoostWeights.push_back(0.24853);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0660302, 1, 1, 0.614698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154424,-99) , 
0, -0.996603, 1, 0, 0.482772,-99) , 
3, -0.381978, 0, 0, 0.57707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208026,-99) , 
3, 2.84003, 0, 0, 0.326733,-99) , 
2, 1.87156, 1, 0, 0.557985,-99)    );
  // itree = 277
  fBoostWeights.push_back(0.185423);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.473261, 0, 1, 0.873466,-99) , 
NN(
NN(
0, 
0, 
-1, -0.635406, 1, 1, 0.560665,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.134065,-99) , 
0, -2.99026, 1, 0, 0.329538,-99) , 
3, -1.19711, 0, 0, 0.538104,-99) , 
1, -1.48631, 1, 0, 0.557218,-99)    );
  // itree = 278
  fBoostWeights.push_back(0.258579);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450342,-99) , 
2, -0.122419, 1, 0, 0.539386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17913,-99) , 
0, -3.17712, 0, 0, 0.513958,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42665,-99) , 
3, -0.127763, 1, 0, 0.513605,-99) , 
NN(
0, 
0, 
-1, 1.17848, 1, -1, 0.362393,-99) , 
1, 1.41458, 0, 0, 0.395216,-99) , 
1, 0.212582, 1, 0, 0.457936,-99)    );
  // itree = 279
  fBoostWeights.push_back(0.135559);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.664446, 1, 1, 0.551421,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.115162,-99) , 
3, -1.7163, 0, 0, 0.404683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131265,-99) , 
2, -0.738397, 1, 0, 0.340651,-99) , 
3, -0.774089, 0, 0, 0.521706,-99)    );
  // itree = 280
  fBoostWeights.push_back(0.247569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46068, 1, 1, 0.713085,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.101323,-99) , 
3, 2.65887, 0, 0, 0.309433,-99) , 
0, 3.1013, 1, 0, 0.564146,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473849,-99) , 
2, -1.36086, 1, 0, 0.505204,-99) , 
NN(
0, 
0, 
-1, 0.587913, 0, -1, 0.351736,-99) , 
0, 0.179034, 1, 0, 0.436928,-99) , 
0, 1.77235, 0, 0, 0.466673,-99)    );
  // itree = 281
  fBoostWeights.push_back(0.21875);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21271, 1, 1, 0.626124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404699,-99) , 
1, 0.0804066, 0, 0, 0.48731,-99) , 
2, 1.1264, 0, 0, 0.51196,-99) , 
NN(
0, 
0, 
-1, 2.62786, 0, -1, 0.278715,-99) , 
2, 1.80849, 1, 0, 0.486789,-99)    );
  // itree = 282
  fBoostWeights.push_back(0.255934);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22822, 0, 1, 0.818927,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446249,-99) , 
1, -0.237385, 1, 0, 0.518596,-99) , 
0, 0.937097, 0, 0, 0.55914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394889,-99) , 
2, 1.04943, 1, 0, 0.452152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251215,-99) , 
3, 1.27356, 0, 0, 0.397172,-99) , 
0, 1.37578, 1, 0, 0.508728,-99)    );
  // itree = 283
  fBoostWeights.push_back(0.244919);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.095971, 1, 1, 0.921166,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341105,-99) , 
0, 3.03266, 1, 0, 0.552852,-99) , 
NN(
0, 
0, 
-1, -1.58657, 0, -1, 0.370951,-99) , 
3, -0.430822, 0, 0, 0.504688,-99) , 
1, -1.24897, 1, 0, 0.539395,-99)    );
  // itree = 284
  fBoostWeights.push_back(0.183507);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.09899, 0, 1, 0.717929,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583728,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44343,-99) , 
3, 1.2381, 0, 0, 0.491547,-99) , 
0, -1.79155, 1, 0, 0.511435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.74714, 0, 0, 0.497463,-99)    );
  // itree = 285
  fBoostWeights.push_back(0.18488);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.354353, 0, 1, 0.584913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.167211,-99) , 
3, 0.538124, 0, 0, 0.477517,-99) , 
0, 0.470015, 1, 0, 0.522579,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404705,-99) , 
0, 0.627529, 0, 0, 0.467311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203121,-99) , 
1, -1.26997, 1, 0, 0.38557,-99) , 
1, -1.05754, 0, 0, 0.504522,-99)    );
  // itree = 286
  fBoostWeights.push_back(0.253197);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.52486, 1, 1, 0.717645,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465601,-99) , 
1, 0.686406, 1, 0, 0.585269,-99) , 
NN(
0, 
0, 
-1, -0.335635, 1, -1, 0.297558,-99) , 
3, -1.19711, 0, 0, 0.56475,-99) , 
1, 1.26091, 0, 0, 0.587302,-99)    );
  // itree = 287
  fBoostWeights.push_back(0.296017);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0441238, 1, 1, 0.642008,-99) , 
NN(
0, 
0, 
-1, -1.50523, 0, -1, 0.282374,-99) , 
3, -1.10108, 0, 0, 0.604567,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230775,-99) , 
0, 2.97961, 1, 0, 0.639558,-99) , 
NN(
0, 
0, 
-1, 0.705279, 0, -1, 0.410616,-99) , 
1, 0.849741, 0, 0, 0.472841,-99) , 
0, 1.20503, 1, 0, 0.545804,-99)    );
  // itree = 288
  fBoostWeights.push_back(0.187673);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370343,-99) , 
3, -1.11252, 0, 0, 0.621459,-99) , 
NN(
0, 
0, 
-1, 0.0741795, 0, -1, 0.455011,-99) , 
1, -0.124994, 1, 0, 0.497285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552262,-99) , 
NN(
0, 
0, 
-1, 0.528265, 0, -1, 0.280052,-99) , 
0, -0.910985, 1, 0, 0.3382,-99) , 
1, -0.827015, 0, 0, 0.472497,-99)    );
  // itree = 289
  fBoostWeights.push_back(0.137309);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765585,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360359,-99) , 
3, -0.662943, 0, 0, 0.496525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201087,-99) , 
0, 3.33491, 1, 0, 0.484068,-99) , 
2, 2.221, 0, 0, 0.497886,-99)    );
  // itree = 290
  fBoostWeights.push_back(0.226202);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182237,-99) , 
1, 1.14348, 1, 0, 0.575471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424372,-99) , 
2, -1.21669, 1, 0, 0.44654,-99) , 
2, 1.19006, 0, 0, 0.47249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186012,-99) , 
1, -2.21448, 0, 0, 0.463102,-99)    );
  // itree = 291
  fBoostWeights.push_back(0.153065);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.19854, 1, 1, 0.740845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416715,-99) , 
2, -1.54094, 0, 0, 0.657795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685525,-99) , 
NN(
0, 
0, 
-1, -0.592066, 0, -1, 0.451566,-99) , 
2, -0.897932, 1, 0, 0.463128,-99) , 
0, -1.40853, 1, 0, 0.490909,-99)    );
  // itree = 292
  fBoostWeights.push_back(0.293794);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0874684, 1, 1, 0.62785,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371248,-99) , 
2, -0.679326, 1, 0, 0.463262,-99) , 
3, -0.00808146, 0, 0, 0.530292,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433456,-99) , 
0, 3.14662, 1, 0, 0.599923,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256871,-99) , 
2, 0.29645, 1, 0, 0.321865,-99) , 
3, 1.66868, 0, 0, 0.424591,-99) , 
0, 0.676813, 1, 0, 0.481093,-99)    );
  // itree = 293
  fBoostWeights.push_back(0.234408);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.234105, 1, 1, 0.671347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161232,-99) , 
0, -1.97761, 1, 0, 0.40034,-99) , 
3, -0.860835, 0, 0, 0.566075,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27903,-99) , 
3, 0.32035, 0, 0, 0.476471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112607,-99) , 
2, 0.635513, 1, 0, 0.255688,-99) , 
1, 1.25419, 1, 0, 0.444435,-99) , 
0, -0.0887253, 1, 0, 0.489124,-99)    );
  // itree = 294
  fBoostWeights.push_back(0.307947);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299639,-99) , 
0, 1.9162, 1, 0, 0.678159,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419529,-99) , 
2, -1.25179, 1, 0, 0.454566,-99) , 
1, 0.8165, 1, 0, 0.553549,-99) , 
NN(
NN(
0, 
0, 
-1, 0.629865, 0, 1, 0.718953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348671,-99) , 
3, 1.11251, 0, 0, 0.390639,-99) , 
1, -1.41399, 1, 0, 0.428443,-99) , 
1, 0.219717, 0, 0, 0.483879,-99)    );
  // itree = 295
  fBoostWeights.push_back(0.179077);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48465,-99) , 
1, -1.02731, 0, 0, 0.602284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422766,-99) , 
3, 0.771081, 0, 0, 0.478957,-99) , 
1, -0.133281, 1, 0, 0.525804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.119608,-99) , 
2, -1.71417, 0, 0, 0.51402,-99)    );
  // itree = 296
  fBoostWeights.push_back(0.264187);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.338577, 1, 1, 0.732089,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320922,-99) , 
1, 0.749649, 0, 0, 0.414318,-99) , 
2, -0.54776, 0, 0, 0.580461,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430894,-99) , 
2, 1.12874, 1, 0, 0.492957,-99) , 
NN(
0, 
0, 
-1, 0.438088, 1, -1, 0.333119,-99) , 
3, 0.613655, 0, 0, 0.46007,-99) , 
0, 0.394028, 1, 0, 0.512474,-99)    );
  // itree = 297
  fBoostWeights.push_back(0.114349);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157735,-99) , 
3, -0.85021, 0, 0, 0.491579,-99) , 
0, -2.39261, 1, 0, 0.506737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0684199,-99) , 
3, -1.5212, 0, 0, 0.49445,-99)    );
  // itree = 298
  fBoostWeights.push_back(0.192821);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42519,-99) , 
2, 0.035896, 1, 0, 0.483785,-99) , 
3, 1.71637, 0, 0, 0.497005,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189581,-99) , 
0, 3.66665, 1, 0, 0.421781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, 2.08303, 0, 0, 0.253533,-99) , 
0, 2.6865, 1, 0, 0.464352,-99)    );
  // itree = 299
  fBoostWeights.push_back(0.135933);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849683,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192688,-99) , 
2, -1.65985, 0, 0, 0.507538,-99) , 
NN(
0, 
0, 
-1, 3.25412, 1, -1, 0.219703,-99) , 
0, 2.78457, 1, 0, 0.479497,-99) , 
3, 3.12649, 0, 0, 0.49032,-99)    );
  // itree = 300
  fBoostWeights.push_back(0.196691);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.021217, 0, 1, 0.685901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481035,-99) , 
2, 1.14207, 1, 0, 0.61099,-99) , 
NN(
0, 
0, 
-1, -0.408954, 0, -1, 0.406778,-99) , 
1, -1.04839, 1, 0, 0.431788,-99)    );
  // itree = 301
  fBoostWeights.push_back(0.15708);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751787,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496986,-99) , 
2, 0.193098, 0, 0, 0.540239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387585,-99) , 
1, -1.2428, 1, 0, 0.416635,-99) , 
2, 0.769719, 1, 0, 0.495886,-99) , 
3, 3.04613, 0, 0, 0.504208,-99)    );
  // itree = 302
  fBoostWeights.push_back(0.255389);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.721376, 0, 1, 0.725543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389912,-99) , 
1, -0.294079, 0, 0, 0.50102,-99) , 
1, -1.10105, 1, 0, 0.526553,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27923,-99) , 
3, 2.89303, 0, 0, 0.323381,-99) , 
0, 1.34794, 1, 0, 0.370592,-99) , 
3, 1.12461, 1, 0, 0.481217,-99)    );
  // itree = 303
  fBoostWeights.push_back(0.152439);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.77558, 1, 1, 0.740579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19664,-99) , 
1, -0.920302, 0, 0, 0.525293,-99) , 
1, -1.17388, 1, 0, 0.544431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314007,-99) , 
2, 2.2809, 1, 0, 0.534001,-99)    );
  // itree = 304
  fBoostWeights.push_back(0.250211);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449038,-99) , 
0, 1.42386, 1, 0, 0.537115,-99) , 
NN(
0, 
0, 
-1, 0.365136, 1, -1, 0.381722,-99) , 
3, 0.601313, 0, 0, 0.453789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.86182, 0, 0, 0.442078,-99)    );
  // itree = 305
  fBoostWeights.push_back(0.136806);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769999,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464737,-99) , 
1, 0.910358, 0, 0, 0.497871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274502,-99) , 
1, 1.93582, 1, 0, 0.487308,-99) , 
1, -1.64443, 1, 0, 0.49826,-99)    );
  // itree = 306
  fBoostWeights.push_back(0.21169);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.5324, 0, 1, 0.807731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385212,-99) , 
3, -0.0477645, 0, 0, 0.613335,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426162,-99) , 
1, -0.759695, 1, 0, 0.442676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225834,-99) , 
1, -0.952743, 0, 0, 0.436139,-99) , 
1, -1.15069, 1, 0, 0.457523,-99)    );
  // itree = 307
  fBoostWeights.push_back(0.255211);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.8749, 1, 1, 0.678586,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478063,-99) , 
0, 0.615619, 1, 0, 0.581193,-99) , 
NN(
0, 
0, 
-1, 1.66871, 0, -1, 0.319802,-99) , 
1, 1.30904, 1, 0, 0.556882,-99) , 
3, 1.14303, 0, 0, 0.593842,-99)    );
  // itree = 308
  fBoostWeights.push_back(0.344142);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.677228, 1, 1, 0.625761,-99) , 
NN(
0, 
0, 
-1, 2.21499, 1, -1, 0.228075,-99) , 
0, 2.67127, 1, 0, 0.557741,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39605,-99) , 
1, -0.742592, 0, 0, 0.561319,-99) , 
NN(
0, 
0, 
-1, -1.29864, 1, -1, 0.218561,-99) , 
1, 0.107742, 1, 0, 0.344883,-99) , 
2, -0.86672, 0, 0, 0.518455,-99)    );
  // itree = 309
  fBoostWeights.push_back(0.195323);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75544, 1, 1, 0.677873,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442139,-99) , 
3, 2.46845, 0, 0, 0.527382,-99) , 
2, 1.1747, 1, 0, 0.577447,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456286,-99) , 
3, 1.06919, 0, 0, 0.472961,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252833,-99) , 
2, -0.899242, 1, 0, 0.32035,-99) , 
1, 1.01669, 1, 0, 0.446332,-99) , 
2, 0.702607, 0, 0, 0.493886,-99)    );
  // itree = 310
  fBoostWeights.push_back(0.140336);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.19754, 1, 1, 0.552619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307948,-99) , 
1, -1.65097, 0, 0, 0.540622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.141433,-99) , 
2, -1.5546, 0, 0, 0.526935,-99)    );
  // itree = 311
  fBoostWeights.push_back(0.200565);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49794,-99) , 
3, -0.583649, 0, 0, 0.600817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426056,-99) , 
2, 1.2861, 0, 0, 0.476376,-99) , 
3, -0.0996243, 1, 0, 0.512216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204738,-99) , 
3, -1.54964, 0, 0, 0.501551,-99)    );
  // itree = 312
  fBoostWeights.push_back(0.217268);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437301,-99) , 
2, 0.706769, 1, 0, 0.535754,-99) , 
NN(
0, 
0, 
-1, -0.0968092, 1, -1, 0.421889,-99) , 
3, 0.163853, 0, 0, 0.491293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165989,-99) , 
1, 1.78879, 1, 0, 0.477883,-99)    );
  // itree = 313
  fBoostWeights.push_back(0.242141);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261646,-99) , 
1, 1.60337, 1, 0, 0.579262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153853,-99) , 
3, -1.58356, 0, 0, 0.545342,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482336,-99) , 
0, 1.78983, 1, 0, 0.535395,-99) , 
NN(
0, 
0, 
-1, 0.140238, 0, -1, 0.349768,-99) , 
3, 0.953592, 0, 0, 0.450676,-99) , 
2, -0.0811742, 1, 0, 0.485175,-99)    );
  // itree = 314
  fBoostWeights.push_back(0.192655);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.272589, 1, 1, 0.788215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408414,-99) , 
2, 0.523032, 1, 0, 0.576285,-99) , 
1, -1.41528, 1, 0, 0.669081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439005,-99) , 
1, -0.225012, 1, 0, 0.469708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.149775,-99) , 
2, -1.56754, 0, 0, 0.457454,-99) , 
1, -0.936379, 1, 0, 0.492441,-99)    );
  // itree = 315
  fBoostWeights.push_back(0.162078);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.309921, 0, 1, 0.703441,-99) , 
NN(
NN(
0, 
0, 
-1, 0.18286, 0, 1, 0.573543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327693,-99) , 
3, 0.522511, 0, 0, 0.48901,-99) , 
2, 0.455997, 1, 0, 0.53741,-99) , 
2, 1.80849, 0, 0, 0.555904,-99)    );
  // itree = 316
  fBoostWeights.push_back(0.201285);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.44684, 1, 1, 0.76625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418808,-99) , 
3, 3.02628, 0, 0, 0.516772,-99) , 
2, 1.6032, 1, 0, 0.628724,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439888,-99) , 
2, -0.53438, 1, 0, 0.473567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213669,-99) , 
3, -1.41155, 0, 0, 0.462497,-99) , 
3, 1.73863, 0, 0, 0.494472,-99)    );
  // itree = 317
  fBoostWeights.push_back(0.206821);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381165,-99) , 
2, 1.51272, 1, 0, 0.539812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279568,-99) , 
0, -0.446309, 1, 0, 0.364094,-99) , 
1, 1.08782, 1, 0, 0.510947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.179608,-99) , 
3, -1.61485, 0, 0, 0.50053,-99)    );
  // itree = 318
  fBoostWeights.push_back(0.344767);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.531177, 1, 1, 0.826109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358728,-99) , 
2, -1.11994, 1, 0, 0.4684,-99) , 
3, -0.446443, 0, 0, 0.631286,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408306,-99) , 
2, 1.68131, 1, 0, 0.562172,-99) , 
NN(
0, 
0, 
-1, 0.385885, 1, -1, 0.35159,-99) , 
2, 0.754262, 0, 0, 0.467295,-99) , 
0, 0.18515, 1, 0, 0.536201,-99)    );
  // itree = 319
  fBoostWeights.push_back(0.269913);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.62687, 0, 1, 0.622571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237058,-99) , 
2, -0.119249, 0, 0, 0.602526,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480856,-99) , 
2, -0.073541, 0, 0, 0.530142,-99) , 
NN(
0, 
0, 
-1, -0.28397, 1, -1, 0.290816,-99) , 
1, 0.0176327, 0, 0, 0.411727,-99) , 
3, 0.27076, 0, 0, 0.516929,-99)    );
  // itree = 320
  fBoostWeights.push_back(0.255912);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467334,-99) , 
1, 0.560452, 1, 0, 0.591624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357199,-99) , 
0, -1.40299, 1, 0, 0.440092,-99) , 
3, -0.106042, 0, 0, 0.528689,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452748,-99) , 
3, 2.31186, 0, 0, 0.544546,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20722,-99) , 
2, 1.37558, 1, 0, 0.305824,-99) , 
2, 1.75486, 0, 0, 0.400583,-99) , 
2, 1.25629, 1, 0, 0.503232,-99)    );
  // itree = 321
  fBoostWeights.push_back(0.223011);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.671627, 0, 1, 0.875203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.918158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497165,-99) , 
0, 0.89577, 1, 0, 0.565303,-99) , 
1, -1.92948, 1, 0, 0.580733,-99) , 
3, 2.7756, 0, 0, 0.60749,-99)    );
  // itree = 322
  fBoostWeights.push_back(0.12078);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783274,-99) , 
NN(
NN(
0, 
0, 
-1, -2.02319, 1, 1, 0.528102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.50638, 0, 0, 0.502588,-99) , 
2, 2.61809, 0, 0, 0.513698,-99)    );
  // itree = 323
  fBoostWeights.push_back(0.22576);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256283,-99) , 
1, 1.4229, 1, 0, 0.539563,-99) , 
2, 1.54067, 0, 0, 0.560821,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200994,-99) , 
1, -0.26535, 0, 0, 0.385253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.035386,-99) , 
1, 0.626229, 1, 0, 0.268141,-99) , 
0, 3.05472, 1, 0, 0.534336,-99)    );
  // itree = 324
  fBoostWeights.push_back(0.293255);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455462,-99) , 
2, 0.896409, 1, 0, 0.533228,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257706,-99) , 
2, -0.709481, 1, 0, 0.378075,-99) , 
3, -0.0692393, 0, 0, 0.479162,-99) , 
NN(
0, 
0, 
-1, -1.37434, 1, -1, 0.185108,-99) , 
3, -1.15439, 0, 0, 0.443728,-99)    );
  // itree = 325
  fBoostWeights.push_back(0.238448);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419086,-99) , 
3, 1.95372, 0, 0, 0.735141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331474,-99) , 
3, 3.11091, 0, 0, 0.560482,-99) , 
3, 2.5297, 1, 0, 0.674595,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435836,-99) , 
1, 0.607111, 0, 0, 0.474716,-99) , 
NN(
0, 
0, 
-1, 0.0470312, 0, -1, 0.227195,-99) , 
1, -1.52075, 0, 0, 0.455504,-99) , 
3, 1.72681, 0, 0, 0.499188,-99)    );
  // itree = 326
  fBoostWeights.push_back(0.211408);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.200534, 1, 1, 0.563582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347327,-99) , 
0, -1.65898, 1, 0, 0.432666,-99) , 
3, -0.00538588, 0, 0, 0.518489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.12164, 0, 0, 0.503958,-99)    );
  // itree = 327
  fBoostWeights.push_back(0.199553);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.23232, 0, 1, 0.746913,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467595,-99) , 
2, 0.145985, 1, 0, 0.5034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316887,-99) , 
1, -0.0789854, 1, 0, 0.388738,-99) , 
3, 0.388961, 0, 0, 0.447609,-99) , 
3, 2.67406, 0, 0, 0.464165,-99)    );
  // itree = 328
  fBoostWeights.push_back(0.120948);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85355,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395517,-99) , 
3, -0.423501, 0, 0, 0.494735,-99) , 
2, -1.19961, 1, 0, 0.51167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234467,-99) , 
2, -1.49842, 0, 0, 0.500686,-99)    );
  // itree = 329
  fBoostWeights.push_back(0.190346);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869832,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487375,-99) , 
1, 0.239815, 1, 0, 0.559222,-99) , 
NN(
0, 
0, 
-1, 1.92879, 1, -1, 0.405776,-99) , 
1, -0.276973, 0, 0, 0.511176,-99) , 
1, -1.73018, 1, 0, 0.525987,-99)    );
  // itree = 330
  fBoostWeights.push_back(0.274137);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.878934, 0, 1, 0.601989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161734,-99) , 
1, 1.58149, 0, 0, 0.393158,-99) , 
1, 1.39438, 1, 0, 0.549512,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365251,-99) , 
3, -0.747551, 0, 0, 0.542798,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321732,-99) , 
2, 1.38341, 0, 0, 0.367301,-99) , 
1, -0.630395, 1, 0, 0.43937,-99) , 
1, 0.198194, 0, 0, 0.493375,-99)    );
  // itree = 331
  fBoostWeights.push_back(0.248675);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493429,-99) , 
2, -0.49593, 1, 0, 0.666557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338252,-99) , 
0, -2.57351, 1, 0, 0.473296,-99) , 
3, -0.703405, 0, 0, 0.576662,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478109,-99) , 
1, -0.918153, 1, 0, 0.519128,-99) , 
NN(
0, 
0, 
-1, 0.115978, 1, -1, 0.330321,-99) , 
3, 0.616995, 0, 0, 0.456109,-99) , 
2, -0.0811742, 1, 0, 0.49876,-99)    );
  // itree = 332
  fBoostWeights.push_back(0.134827);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485235,-99) , 
2, 0.126871, 0, 0, 0.532941,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255054,-99) , 
2, 1.06315, 0, 0, 0.416381,-99) , 
0, 1.87876, 1, 0, 0.50135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239016,-99) , 
3, -1.62852, 0, 0, 0.492633,-99)    );
  // itree = 333
  fBoostWeights.push_back(0.222213);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423295,-99) , 
3, -1.69193, 0, 0, 0.675046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318787,-99) , 
3, -1.10007, 0, 0, 0.45468,-99) , 
1, 0.101928, 1, 0, 0.590367,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421257,-99) , 
1, -0.814743, 1, 0, 0.438466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216942,-99) , 
2, -0.506211, 0, 0, 0.418778,-99) , 
0, -0.429465, 1, 0, 0.472262,-99)    );
  // itree = 334
  fBoostWeights.push_back(0.190993);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421587,-99) , 
2, 0.319052, 1, 0, 0.631663,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472009,-99) , 
2, 1.84167, 0, 0, 0.507285,-99) , 
0, -0.11779, 1, 0, 0.550383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139356,-99) , 
3, -1.68639, 0, 0, 0.539825,-99)    );
  // itree = 335
  fBoostWeights.push_back(0.0951922);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47372,-99) , 
0, -3.21469, 0, 0, 0.693537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495677,-99) , 
3, 2.02688, 0, 0, 0.513849,-99) , 
0, -2.64538, 1, 0, 0.530188,-99) , 
NN(
0, 
0, 
-1, 2.01313, 0, -1, 0.280594,-99) , 
0, 3.83529, 1, 0, 0.51833,-99)    );
  // itree = 336
  fBoostWeights.push_back(0.315145);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451685,-99) , 
2, 0.101338, 0, 0, 0.72964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254826,-99) , 
2, 0.189369, 0, 0, 0.508686,-99) , 
0, 1.00959, 1, 0, 0.575783,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.921501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408315,-99) , 
3, -0.531252, 0, 0, 0.49863,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528755,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19299,-99) , 
3, 0.0506287, 0, 0, 0.295633,-99) , 
3, -0.284397, 1, 0, 0.394137,-99) , 
3, 0.256412, 0, 0, 0.488269,-99)    );
  // itree = 337
  fBoostWeights.push_back(0.325933);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0993133, 1, 1, 0.712832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335049,-99) , 
2, 1.16697, 0, 0, 0.487114,-99) , 
2, 0.879918, 1, 0, 0.619801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404516,-99) , 
0, -0.307467, 1, 0, 0.607581,-99) , 
NN(
0, 
0, 
-1, 0.0977278, 1, -1, 0.370654,-99) , 
0, -1.27763, 0, 0, 0.46685,-99) , 
2, -0.604833, 0, 0, 0.585743,-99)    );
  // itree = 338
  fBoostWeights.push_back(0.151091);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896157,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465991,-99) , 
3, 2.03768, 0, 0, 0.49106,-99) , 
NN(
0, 
0, 
-1, 0.393938, 0, -1, 0.253151,-99) , 
1, 1.61612, 1, 0, 0.473728,-99) , 
0, -3.22854, 1, 0, 0.490754,-99)    );
  // itree = 339
  fBoostWeights.push_back(0.166122);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483657,-99) , 
3, 0.762716, 0, 0, 0.532561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275027,-99) , 
0, 3.76686, 1, 0, 0.521202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555338,-99) , 
NN(
0, 
0, 
-1, -0.157367, 0, -1, 0.290574,-99) , 
0, -0.910985, 1, 0, 0.340399,-99) , 
1, -0.827015, 0, 0, 0.48731,-99)    );
  // itree = 340
  fBoostWeights.push_back(0.124124);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740391,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485598,-99) , 
3, 0.174884, 0, 0, 0.532557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145278,-99) , 
2, 2.09272, 1, 0, 0.52051,-99) , 
3, 3.0872, 0, 0, 0.529176,-99)    );
  // itree = 341
  fBoostWeights.push_back(0.303292);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345599,-99) , 
1, 1.91474, 1, 0, 0.596874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274766,-99) , 
1, -1.55016, 0, 0, 0.580135,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275392,-99) , 
0, 2.33748, 1, 0, 0.387162,-99) , 
NN(
0, 
0, 
-1, 2.03361, 0, -1, 0.0875774,-99) , 
1, 0.934283, 1, 0, 0.298941,-99) , 
2, 1.33607, 1, 0, 0.516443,-99)    );
  // itree = 342
  fBoostWeights.push_back(0.250332);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380878,-99) , 
0, 0.0873157, 1, 0, 0.575806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214683,-99) , 
0, -2.85026, 0, 0, 0.543492,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465884,-99) , 
3, 2.6026, 1, 0, 0.612363,-99) , 
NN(
0, 
0, 
-1, 0.806267, 0, -1, 0.393654,-99) , 
3, 2.36292, 0, 0, 0.421627,-99) , 
0, 0.394028, 1, 0, 0.475094,-99)    );
  // itree = 343
  fBoostWeights.push_back(0.198208);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.713904, 0, 1, 0.774699,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477141,-99) , 
3, 0.364885, 0, 0, 0.555102,-99) , 
NN(
0, 
0, 
-1, -0.298002, 0, -1, 0.421352,-99) , 
0, 2.34839, 1, 0, 0.527756,-99) , 
0, -2.52052, 1, 0, 0.550495,-99)    );
  // itree = 344
  fBoostWeights.push_back(0.220852);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.329653, 0, 1, 0.659674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395655,-99) , 
2, 1.28188, 1, 0, 0.501421,-99) , 
2, -0.0811742, 1, 0, 0.555745,-99) , 
NN(
0, 
0, 
-1, 0.120258, 0, -1, 0.301743,-99) , 
1, -0.89377, 0, 0, 0.52449,-99)    );
  // itree = 345
  fBoostWeights.push_back(0.222182);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464952,-99) , 
0, 2.5276, 1, 0, 0.581592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237781,-99) , 
3, -1.5876, 0, 0, 0.570792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.127515,-99) , 
0, 4.34671, 1, 0, 0.552954,-99)    );
  // itree = 346
  fBoostWeights.push_back(0.27354);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.839971, 0, 1, 0.604486,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306859,-99) , 
1, -0.0761344, 1, 0, 0.426499,-99) , 
3, -0.642575, 0, 0, 0.540791,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390998,-99) , 
2, 1.57266, 1, 0, 0.540245,-99) , 
NN(
0, 
0, 
-1, 0.876278, 1, -1, 0.333977,-99) , 
0, 2.20909, 0, 0, 0.408601,-99) , 
0, 0.724078, 1, 0, 0.47122,-99)    );
  // itree = 347
  fBoostWeights.push_back(0.318955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.12434, 1, 1, 0.692785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189679,-99) , 
3, -1.51458, 0, 0, 0.623847,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385617,-99) , 
1, 0.340668, 1, 0, 0.532409,-99) , 
NN(
0, 
0, 
-1, 0.404208, 1, -1, 0.349337,-99) , 
3, 0.621931, 0, 0, 0.445618,-99) , 
2, -0.420818, 1, 0, 0.487882,-99)    );
  // itree = 348
  fBoostWeights.push_back(0.260085);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375307,-99) , 
0, 1.13601, 1, 0, 0.621809,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444123,-99) , 
2, 1.4644, 0, 0, 0.479171,-99) , 
1, -0.0249367, 1, 0, 0.50794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171158,-99) , 
1, -0.715414, 1, 0, 0.461084,-99) , 
NN(
0, 
0, 
-1, -0.821843, 0, -1, 0.317248,-99) , 
0, 0.511052, 1, 0, 0.39309,-99) , 
1, -0.452168, 0, 0, 0.473005,-99)    );
  // itree = 349
  fBoostWeights.push_back(0.255679);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365565,-99) , 
1, -1.48631, 0, 0, 0.585822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28969,-99) , 
0, -2.59026, 0, 0, 0.568671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775254,-99) , 
NN(
0, 
0, 
-1, 1.55017, 0, -1, 0.354131,-99) , 
1, -1.41663, 1, 0, 0.404405,-99) , 
0, 1.90065, 1, 0, 0.520007,-99)    );
  // itree = 350
  fBoostWeights.push_back(0.222913);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48659,-99) , 
2, 1.09764, 1, 0, 0.58285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22675,-99) , 
1, 1.96083, 1, 0, 0.568085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0943591,-99) , 
2, -1.51657, 0, 0, 0.550004,-99)    );
  // itree = 351
  fBoostWeights.push_back(0.210919);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.203976, 1, 1, 0.548869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370937,-99) , 
0, 2.44418, 0, 0, 0.447767,-99) , 
1, -0.568554, 0, 0, 0.518119,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343716,-99) , 
1, 0.433898, 1, 0, 0.536459,-99) , 
NN(
0, 
0, 
-1, -0.549075, 0, -1, 0.334452,-99) , 
0, -1.20611, 1, 0, 0.419043,-99) , 
2, 0.00652484, 0, 0, 0.47934,-99)    );
  // itree = 352
  fBoostWeights.push_back(0.269186);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.951665,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272191,-99) , 
0, 4.43244, 1, 0, 0.595536,-99) , 
0, 2.39035, 1, 0, 0.688347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400792,-99) , 
2, -0.91941, 1, 0, 0.432072,-99) , 
1, 1.94792, 0, 0, 0.450052,-99) , 
3, 1.62473, 0, 0, 0.497051,-99)    );
  // itree = 353
  fBoostWeights.push_back(0.176599);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81776,-99) , 
NN(
NN(
0, 
0, 
-1, 0.288417, 0, 1, 0.627544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395174,-99) , 
1, 0.194269, 0, 0, 0.484115,-99) , 
1, -0.545188, 1, 0, 0.517195,-99) , 
3, 3.23208, 0, 0, 0.528816,-99)    );
  // itree = 354
  fBoostWeights.push_back(0.263591);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0342488, 0, 1, 0.594612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383481,-99) , 
1, 0.72751, 1, 0, 0.423991,-99) , 
1, 0.560472, 1, 0, 0.519071,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45736,-99) , 
0, 0.540824, 0, 0, 0.583386,-99) , 
NN(
0, 
0, 
-1, 0.878962, 0, -1, 0.260436,-99) , 
1, -1.30002, 1, 0, 0.377097,-99) , 
1, -0.827015, 0, 0, 0.492526,-99)    );
  // itree = 355
  fBoostWeights.push_back(0.283259);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412956,-99) , 
1, 1.2403, 1, 0, 0.664397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403805,-99) , 
1, -0.210899, 1, 0, 0.472102,-99) , 
1, 0.752753, 0, 0, 0.535364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562218,-99) , 
NN(
0, 
0, 
-1, 0.158471, 1, -1, 0.235883,-99) , 
3, -0.45279, 0, 0, 0.292902,-99) , 
2, -0.665055, 0, 0, 0.484184,-99)    );
  // itree = 356
  fBoostWeights.push_back(0.148475);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87527,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.876513,-99) , 
NN(
0, 
0, 
-1, -1.60492, 0, -1, 0.447375,-99) , 
0, -3.74807, 1, 0, 0.463952,-99) , 
3, 3.58692, 0, 0, 0.475306,-99)    );
  // itree = 357
  fBoostWeights.push_back(0.177742);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312953,-99) , 
3, 0.109194, 0, 0, 0.539212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136736,-99) , 
0, -0.680245, 1, 0, 0.437729,-99) , 
3, -0.0819027, 0, 0, 0.500725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.104968,-99) , 
2, 2.29433, 1, 0, 0.487288,-99)    );
  // itree = 358
  fBoostWeights.push_back(0.154143);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763205,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376844,-99) , 
2, -0.73659, 0, 0, 0.472293,-99) , 
NN(
0, 
0, 
-1, -0.229379, 1, -1, 0.386034,-99) , 
0, 1.09015, 1, 0, 0.43718,-99) , 
3, 3.04613, 0, 0, 0.44685,-99)    );
  // itree = 359
  fBoostWeights.push_back(0.187275);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454133,-99) , 
0, 2.11544, 1, 0, 0.527463,-99) , 
1, 1.7638, 0, 0, 0.547019,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444581,-99) , 
2, -1.20908, 1, 0, 0.501426,-99) , 
NN(
0, 
0, 
-1, 1.08973, 0, -1, 0.326203,-99) , 
1, 0.76347, 1, 0, 0.453966,-99) , 
2, 0.0164094, 0, 0, 0.509166,-99)    );
  // itree = 360
  fBoostWeights.push_back(0.36771);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239057,-99) , 
0, 2.8984, 1, 0, 0.621266,-99) , 
NN(
0, 
0, 
-1, -1.87033, 1, -1, 0.341527,-99) , 
2, -0.741245, 0, 0, 0.573627,-99) , 
NN(
NN(
0, 
0, 
-1, -1.59868, 1, 1, 0.619827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32649,-99) , 
0, 2.92772, 0, 0, 0.381417,-99) , 
1, -1.08097, 1, 0, 0.426308,-99) , 
1, 0.560452, 0, 0, 0.475901,-99)    );
  // itree = 361
  fBoostWeights.push_back(0.189166);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.385083, 1, 1, 0.691717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349494,-99) , 
1, 0.435886, 1, 0, 0.472842,-99) , 
1, 1.32054, 0, 0, 0.500375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206976,-99) , 
1, 2.10403, 1, 0, 0.488356,-99)    );
  // itree = 362
  fBoostWeights.push_back(0.280774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.974187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359382,-99) , 
2, 0.616165, 0, 0, 0.574588,-99) , 
2, 0.433372, 1, 0, 0.614388,-99) , 
NN(
NN(
0, 
0, 
-1, -3.93664, 1, 1, 0.55219,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161332,-99) , 
2, -7.24225e-05, 1, 0, 0.248308,-99) , 
3, 0.237828, 1, 0, 0.459873,-99) , 
3, 0.814561, 0, 0, 0.518639,-99)    );
  // itree = 363
  fBoostWeights.push_back(0.180603);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.931535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302232,-99) , 
3, -0.152639, 0, 0, 0.448783,-99) , 
2, -1.28111, 1, 0, 0.476269,-99) , 
NN(
0, 
0, 
-1, -1.28449, 0, -1, 0.218423,-99) , 
3, -1.25675, 0, 0, 0.459536,-99)    );
  // itree = 364
  fBoostWeights.push_back(0.227524);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.347956, 0, 1, 0.711348,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412974,-99) , 
2, 2.06838, 0, 0, 0.42965,-99) , 
2, -1.36524, 1, 0, 0.445042,-99) , 
1, 1.2714, 0, 0, 0.475975,-99)    );
  // itree = 365
  fBoostWeights.push_back(0.177839);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712505,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344909,-99) , 
0, 3.19354, 1, 0, 0.555721,-99) , 
3, 3.37166, 0, 0, 0.575285,-99) , 
NN(
0, 
0, 
-1, -1.3613, 0, -1, 0.436179,-99) , 
3, 1.24934, 0, 0, 0.475764,-99)    );
  // itree = 366
  fBoostWeights.push_back(0.211657);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.674291, 0, 1, 0.688745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395638,-99) , 
0, 1.69501, 1, 0, 0.48568,-99) , 
1, 0.801459, 1, 0, 0.527733,-99) , 
NN(
0, 
0, 
-1, -1.12645, 0, -1, 0.398137,-99) , 
1, 0.531499, 0, 0, 0.448491,-99)    );
  // itree = 367
  fBoostWeights.push_back(0.247066);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.16791, 1, 1, 0.565055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0821832,-99) , 
1, -0.836676, 0, 0, 0.291411,-99) , 
0, 3.18542, 1, 0, 0.517136,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386419,-99) , 
3, 2.00127, 0, 0, 0.588933,-99) , 
NN(
0, 
0, 
-1, 1.0071, 1, -1, 0.360868,-99) , 
2, 1.33607, 0, 0, 0.404973,-99) , 
1, 0.0962489, 1, 0, 0.460038,-99)    );
  // itree = 368
  fBoostWeights.push_back(0.220731);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388398,-99) , 
0, -1.70943, 0, 0, 0.682715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318466,-99) , 
1, 0.806267, 1, 0, 0.449622,-99) , 
0, -0.843803, 1, 0, 0.485803,-99) , 
NN(
0, 
0, 
-1, -1.28964, 1, -1, 0.235126,-99) , 
3, -1.02193, 0, 0, 0.455008,-99)    );
  // itree = 369
  fBoostWeights.push_back(0.233686);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483204,-99) , 
0, 0.788441, 1, 0, 0.538381,-99) , 
NN(
0, 
0, 
-1, -0.639959, 1, -1, 0.374329,-99) , 
3, 0.297549, 0, 0, 0.454779,-99) , 
NN(
0, 
0, 
-1, 0.0454491, 0, -1, 0.190596,-99) , 
0, 3.22407, 1, 0, 0.430818,-99)    );
  // itree = 370
  fBoostWeights.push_back(0.232656);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489503,-99) , 
1, 1.05903, 1, 0, 0.580895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268226,-99) , 
0, 4.33505, 1, 0, 0.561978,-99) , 
NN(
NN(
0, 
0, 
-1, -1.60304, 1, 1, 0.579908,-99) , 
NN(
0, 
0, 
-1, 1.24302, 0, -1, 0.340142,-99) , 
1, -1.32331, 1, 0, 0.40445,-99) , 
1, -0.133281, 0, 0, 0.497497,-99)    );
  // itree = 371
  fBoostWeights.push_back(0.192313);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.742814, 1, 1, 0.692847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454498,-99) , 
3, 1.00741, 0, 0, 0.543474,-99) , 
1, 0.501006, 0, 0, 0.60546,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713182,-99) , 
NN(
0, 
0, 
-1, -1.69867, 0, -1, 0.4643,-99) , 
2, -1.78455, 1, 0, 0.483372,-99) , 
0, 0.0835435, 0, 0, 0.553672,-99)    );
  // itree = 372
  fBoostWeights.push_back(0.196359);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.195355, 0, 1, 0.755871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462003,-99) , 
2, 0.801662, 1, 0, 0.686719,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459082,-99) , 
0, 1.98594, 0, 0, 0.48386,-99) , 
NN(
0, 
0, 
-1, 4.53826, 1, -1, 0.260388,-99) , 
0, 3.22407, 1, 0, 0.459502,-99) , 
1, 1.14, 0, 0, 0.49703,-99)    );
  // itree = 373
  fBoostWeights.push_back(0.113028);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.207991, 1, 1, 0.68131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302375,-99) , 
2, 2.41423, 1, 0, 0.508415,-99) , 
0, -1.34764, 1, 0, 0.530126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165562,-99) , 
3, -1.49662, 0, 0, 0.519449,-99)    );
  // itree = 374
  fBoostWeights.push_back(0.179724);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.115975, 0, 1, 0.855263,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462236,-99) , 
3, -0.400178, 0, 0, 0.524136,-99) , 
2, -0.329653, 0, 0, 0.598535,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187514,-99) , 
0, 3.93829, 1, 0, 0.505441,-99) , 
NN(
0, 
0, 
-1, -1.43923, 1, -1, 0.32887,-99) , 
1, -0.953941, 0, 0, 0.473276,-99) , 
2, -0.0811742, 1, 0, 0.513794,-99)    );
  // itree = 375
  fBoostWeights.push_back(0.222268);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.373467, 1, 1, 0.695803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470441,-99) , 
2, -1.68383, 0, 0, 0.661136,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459727,-99) , 
3, 0.403823, 1, 0, 0.487595,-99) , 
NN(
0, 
0, 
-1, -0.569481, 1, -1, 0.216018,-99) , 
3, -0.0527124, 0, 0, 0.44504,-99) , 
0, -0.995569, 1, 0, 0.500702,-99)    );
  // itree = 376
  fBoostWeights.push_back(0.276755);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.280805, 1, 1, 0.669016,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187695,-99) , 
2, -1.3002, 1, 0, 0.394925,-99) , 
3, 0.0205666, 0, 0, 0.573067,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241999,-99) , 
1, -1.0412, 0, 0, 0.554156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359565,-99) , 
2, 1.07906, 0, 0, 0.424628,-99) , 
2, -0.351925, 1, 0, 0.45694,-99) , 
1, 0.963407, 0, 0, 0.48012,-99)    );
  // itree = 377
  fBoostWeights.push_back(0.19194);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.353681, 1, 1, 0.566529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410769,-99) , 
1, -0.440103, 1, 0, 0.471893,-99) , 
3, 0.610508, 0, 0, 0.515133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.11798,-99) , 
3, 2.58812, 1, 0, 0.499071,-99)    );
  // itree = 378
  fBoostWeights.push_back(0.208602);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786682,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421825,-99) , 
2, -0.669897, 1, 0, 0.52583,-99) , 
3, 0.411762, 0, 0, 0.549729,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448645,-99) , 
2, 0.49928, 1, 0, 0.486156,-99) , 
NN(
0, 
0, 
-1, -0.330076, 1, -1, 0.296958,-99) , 
0, 0.109069, 0, 0, 0.460326,-99) , 
2, 0.0556663, 1, 0, 0.497359,-99)    );
  // itree = 379
  fBoostWeights.push_back(0.17091);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.589929, 1, 1, 0.736757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251886,-99) , 
1, -1.85134, 1, 0, 0.421467,-99) , 
1, -1.52096, 0, 0, 0.603657,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448027,-99) , 
2, 0.391241, 1, 0, 0.492781,-99) , 
NN(
0, 
0, 
-1, -0.650358, 1, -1, 0.234038,-99) , 
1, -0.591728, 0, 0, 0.473947,-99) , 
1, -0.827015, 1, 0, 0.496473,-99)    );
  // itree = 380
  fBoostWeights.push_back(0.216171);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482158,-99) , 
3, -0.614686, 0, 0, 0.691535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480946,-99) , 
1, 1.02355, 0, 0, 0.524161,-99) , 
1, -0.480148, 1, 0, 0.562233,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823322,-99) , 
NN(
0, 
0, 
-1, 2.1156, 0, -1, 0.367908,-99) , 
0, 1.91102, 1, 0, 0.427487,-99) , 
3, 1.30905, 1, 0, 0.526054,-99)    );
  // itree = 381
  fBoostWeights.push_back(0.289935);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427911,-99) , 
0, -1.70932, 0, 0, 0.673175,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244946,-99) , 
3, -0.0527124, 0, 0, 0.551528,-99) , 
0, -0.494375, 1, 0, 0.587732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22786,-99) , 
2, -1.49842, 0, 0, 0.575798,-99)    );
  // itree = 382
  fBoostWeights.push_back(0.196669);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.733407, 1, 1, 0.592475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370386,-99) , 
2, -1.48506, 0, 0, 0.581575,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295961,-99) , 
2, 2.09899, 0, 0, 0.372518,-99) , 
0, 3.35955, 1, 0, 0.565526,-99)    );
  // itree = 383
  fBoostWeights.push_back(0.283062);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.406333, 0, 1, 0.624235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32579,-99) , 
0, 1.36353, 1, 0, 0.443805,-99) , 
0, 0.464202, 1, 0, 0.585371,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21464,-99) , 
0, 4.4587, 1, 0, 0.609392,-99) , 
NN(
0, 
0, 
-1, 0.703439, 1, -1, 0.380033,-99) , 
3, 1.44821, 0, 0, 0.483016,-99) , 
2, 0.339187, 1, 0, 0.534506,-99)    );
  // itree = 384
  fBoostWeights.push_back(0.205173);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.887889, 1, 1, 0.735003,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402976,-99) , 
0, 3.19941, 1, 0, 0.531607,-99) , 
0, -0.181124, 1, 0, 0.561612,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428338,-99) , 
3, -1.23125, 0, 0, 0.526755,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157165,-99) , 
0, -0.999876, 1, 0, 0.450236,-99) , 
3, -0.547237, 0, 0, 0.537812,-99)    );
  // itree = 385
  fBoostWeights.push_back(0.261739);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476851,-99) , 
3, -0.206658, 0, 0, 0.573099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.179815,-99) , 
3, -1.52693, 0, 0, 0.54125,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273541,-99) , 
1, -0.48289, 0, 0, 0.461969,-99) , 
NN(
0, 
0, 
-1, 0.161255, 1, -1, 0.304655,-99) , 
3, 1.12564, 0, 0, 0.399422,-99) , 
0, 0.394028, 1, 0, 0.452849,-99)    );
  // itree = 386
  fBoostWeights.push_back(0.142867);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.69367, 0, 1, 0.654117,-99) , 
NN(
0, 
0, 
-1, -0.298558, 0, -1, 0.43489,-99) , 
2, -1.31454, 1, 0, 0.449278,-99)    );
  // itree = 387
  fBoostWeights.push_back(0.238187);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460346,-99) , 
3, -0.698745, 0, 0, 0.580148,-99) , 
NN(
0, 
0, 
-1, 0.393477, 0, -1, 0.407022,-99) , 
0, -0.416978, 1, 0, 0.452897,-99) , 
NN(
0, 
0, 
-1, 2.20534, 1, -1, 0.154453,-99) , 
1, 1.75304, 1, 0, 0.434589,-99)    );
  // itree = 388
  fBoostWeights.push_back(0.213843);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.03621, 1, 1, 0.689304,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379182,-99) , 
0, 1.02721, 1, 0, 0.551183,-99) , 
3, 1.07673, 0, 0, 0.587637,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447702,-99) , 
1, 0.8165, 1, 0, 0.50625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260379,-99) , 
2, -1.32053, 0, 0, 0.484817,-99) , 
1, 0.219717, 1, 0, 0.538494,-99)    );
  // itree = 389
  fBoostWeights.push_back(0.133933);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.112386, 1, 1, 0.545596,-99) , 
NN(
0, 
0, 
-1, 2.01461, 1, -1, 0.301322,-99) , 
1, 1.47355, 1, 0, 0.528687,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131899,-99) , 
2, -1.64876, 0, 0, 0.515487,-99)    );
  // itree = 390
  fBoostWeights.push_back(0.172294);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49356,-99) , 
2, 0.336248, 0, 0, 0.543782,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0298791,-99) , 
3, 2.44085, 0, 0, 0.361195,-99) , 
0, 3.06373, 1, 0, 0.517345,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0652277,-99) , 
1, 1.67456, 0, 0, 0.282631,-99) , 
1, 1.48646, 1, 0, 0.498642,-99)    );
  // itree = 391
  fBoostWeights.push_back(0.273188);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.972148, 1, 1, 0.67209,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354669,-99) , 
0, -2.55781, 1, 0, 0.417125,-99) , 
2, -0.741127, 0, 0, 0.55657,-99) , 
NN(
NN(
0, 
0, 
-1, 0.724197, 1, 1, 0.565682,-99) , 
NN(
0, 
0, 
-1, 1.03098, 0, -1, 0.324018,-99) , 
2, 0.919375, 0, 0, 0.453077,-99) , 
3, 0.268003, 1, 0, 0.493958,-99)    );
  // itree = 392
  fBoostWeights.push_back(0.241917);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.3745, 1, 1, 0.566601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139439,-99) , 
2, -1.71713, 0, 0, 0.545432,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328056,-99) , 
2, 1.99394, 0, 0, 0.391895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151427,-99) , 
2, 2.46405, 1, 0, 0.358783,-99) , 
2, 1.06991, 1, 0, 0.48722,-99)    );
  // itree = 393
  fBoostWeights.push_back(0.190533);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.61224, 0, 1, 0.754404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270372,-99) , 
0, -0.0584605, 1, 0, 0.481745,-99) , 
3, 0.342754, 0, 0, 0.542387,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345381,-99) , 
2, 1.61154, 1, 0, 0.472013,-99) , 
NN(
0, 
0, 
-1, 0.37865, 0, -1, 0.257905,-99) , 
0, 0.599431, 0, 0, 0.43699,-99) , 
2, 0.391241, 1, 0, 0.483669,-99)    );
  // itree = 394
  fBoostWeights.push_back(0.162291);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.510941, 0, 1, 0.581526,-99) , 
NN(
0, 
0, 
-1, 0.108085, 0, -1, 0.436874,-99) , 
0, -1.06144, 1, 0, 0.464465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.138083,-99) , 
1, -1.99406, 0, 0, 0.449206,-99)    );
  // itree = 395
  fBoostWeights.push_back(0.258959);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442494,-99) , 
1, 0.403002, 1, 0, 0.71148,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35119,-99) , 
3, -1.45679, 0, 0, 0.43529,-99) , 
0, -2.18972, 0, 0, 0.607231,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419512,-99) , 
2, 0.6783, 1, 0, 0.493654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155339,-99) , 
0, 0.0400958, 1, 0, 0.359962,-99) , 
3, 0.347918, 0, 0, 0.45739,-99) , 
0, -0.953354, 1, 0, 0.49379,-99)    );
  // itree = 396
  fBoostWeights.push_back(0.262171);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.794592, 1, 1, 0.703329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185532,-99) , 
3, -1.50806, 0, 0, 0.602677,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377692,-99) , 
1, 0.321897, 1, 0, 0.480671,-99) , 
NN(
0, 
0, 
-1, -0.305417, 0, -1, 0.373749,-99) , 
0, 2.08844, 1, 0, 0.452395,-99) , 
0, -1.28819, 1, 0, 0.481552,-99)    );
  // itree = 397
  fBoostWeights.push_back(0.207814);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690892,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455601,-99) , 
1, -0.362012, 0, 0, 0.514123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35022,-99) , 
3, 1.42296, 0, 0, 0.406134,-99) , 
1, 0.0618426, 1, 0, 0.451616,-99) , 
0, -2.62228, 1, 0, 0.464001,-99)    );
  // itree = 398
  fBoostWeights.push_back(0.140294);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0697704, 0, 1, 0.805973,-99) , 
NN(
NN(
0, 
0, 
-1, -0.00877973, 1, 1, 0.584464,-99) , 
NN(
0, 
0, 
-1, -0.526875, 0, -1, 0.453622,-99) , 
1, 0.907319, 0, 0, 0.485313,-99) , 
2, 2.23805, 0, 0, 0.503355,-99)    );
  // itree = 399
  fBoostWeights.push_back(0.222424);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0934717, 1, 1, 0.591197,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396152,-99) , 
1, 1.27336, 0, 0, 0.441022,-99) , 
2, -0.439773, 0, 0, 0.547821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0741138,-99) , 
1, -0.219023, 1, 0, 0.312921,-99) , 
0, 3.63805, 1, 0, 0.530491,-99)    );
  // itree = 400
  fBoostWeights.push_back(0.204039);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485511,-99) , 
1, 0.387251, 0, 0, 0.690284,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655627,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470257,-99) , 
1, 0.28541, 0, 0, 0.503291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289952,-99) , 
1, 1.32365, 0, 0, 0.400343,-99) , 
1, 0.604865, 1, 0, 0.471441,-99) , 
3, 2.63866, 0, 0, 0.489114,-99)    );
  // itree = 401
  fBoostWeights.push_back(0.161802);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.929794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459068,-99) , 
0, -1.40235, 1, 0, 0.478369,-99) , 
NN(
0, 
0, 
-1, -2.78954, 1, -1, 0.261996,-99) , 
3, -1.23442, 0, 0, 0.463404,-99) , 
3, 3.56986, 0, 0, 0.480268,-99)    );
  // itree = 402
  fBoostWeights.push_back(0.201155);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272584,-99) , 
2, 2.33269, 1, 0, 0.679661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478405,-99) , 
1, 0.0920198, 0, 0, 0.53741,-99) , 
3, 1.69258, 0, 0, 0.564507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252341,-99) , 
1, -1.95752, 0, 0, 0.55139,-99)    );
  // itree = 403
  fBoostWeights.push_back(0.242875);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.14798, 1, 1, 0.624799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367645,-99) , 
2, 1.46189, 1, 0, 0.586716,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488214,-99) , 
1, 1.15747, 0, 0, 0.665305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36726,-99) , 
3, 1.2991, 0, 0, 0.422726,-99) , 
2, -1.08782, 1, 0, 0.448111,-99) , 
1, -0.480148, 1, 0, 0.479892,-99)    );
  // itree = 404
  fBoostWeights.push_back(0.171377);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.576385, 0, 1, 0.665575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307793,-99) , 
1, -2.01517, 0, 0, 0.595615,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455861,-99) , 
0, 3.6398, 1, 0, 0.583191,-99) , 
NN(
0, 
0, 
-1, 1.93841, 1, -1, 0.44183,-99) , 
3, 2.30091, 0, 0, 0.456715,-99) , 
1, -0.814743, 1, 0, 0.4822,-99)    );
  // itree = 405
  fBoostWeights.push_back(0.291752);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316025,-99) , 
3, 2.4244, 1, 0, 0.591128,-99) , 
NN(
0, 
0, 
-1, 0.333202, 0, -1, 0.244339,-99) , 
1, -1.50161, 0, 0, 0.561395,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198404,-99) , 
0, 2.68457, 1, 0, 0.44866,-99) , 
NN(
0, 
0, 
-1, -0.539447, 1, -1, 0.281331,-99) , 
3, 0.741723, 0, 0, 0.359399,-99) , 
1, 0.843066, 1, 0, 0.512998,-99)    );
  // itree = 406
  fBoostWeights.push_back(0.262003);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.20634, 0, 1, 0.866854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328864,-99) , 
0, -2.0939, 0, 0, 0.469767,-99) , 
1, 0.828729, 0, 0, 0.574287,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401818,-99) , 
0, 4.14082, 1, 0, 0.624643,-99) , 
NN(
0, 
0, 
-1, 1.79985, 1, -1, 0.398989,-99) , 
3, 1.98733, 0, 0, 0.450688,-99) , 
0, -0.0887253, 1, 0, 0.496502,-99)    );
  // itree = 407
  fBoostWeights.push_back(0.33603);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.101394, 1, 1, 0.685971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348254,-99) , 
0, -1.00344, 1, 0, 0.50291,-99) , 
3, -0.037816, 0, 0, 0.613047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421549,-99) , 
0, 3.64799, 1, 0, 0.579807,-99) , 
NN(
0, 
0, 
-1, 2.77208, 0, -1, 0.303198,-99) , 
1, 0.0289228, 1, 0, 0.423674,-99) , 
0, 2.29217, 1, 0, 0.571407,-99)    );
  // itree = 408
  fBoostWeights.push_back(0.246836);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.660308, 0, 1, 0.594552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25726,-99) , 
0, 2.21932, 1, 0, 0.572106,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499008,-99) , 
2, 1.74109, 1, 0, 0.608044,-99) , 
NN(
0, 
0, 
-1, 1.48734, 1, -1, 0.310013,-99) , 
3, 2.27877, 0, 0, 0.380684,-99) , 
2, 1.03367, 1, 0, 0.524373,-99)    );
  // itree = 409
  fBoostWeights.push_back(0.27085);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.16665, 1, 1, 0.682488,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232773,-99) , 
2, -1.01975, 1, 0, 0.390598,-99) , 
3, -0.743516, 0, 0, 0.609359,-99) , 
NN(
0, 
0, 
-1, 3.54173, 1, -1, 0.399369,-99) , 
1, -0.11574, 1, 0, 0.481092,-99)    );
  // itree = 410
  fBoostWeights.push_back(0.207904);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44544, 1, 1, 0.704872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361952,-99) , 
1, 1.00427, 1, 0, 0.548255,-99) , 
1, 1.17197, 0, 0, 0.575033,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451132,-99) , 
1, -1.23575, 1, 0, 0.584279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316951,-99) , 
2, -0.591586, 1, 0, 0.385832,-99) , 
3, 1.0946, 0, 0, 0.433471,-99) , 
1, -0.589204, 0, 0, 0.541811,-99)    );
  // itree = 411
  fBoostWeights.push_back(0.246717);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 4.1021, 1, 1, 0.789115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441621,-99) , 
3, 3.20929, 0, 0, 0.537764,-99) , 
1, -0.0134887, 1, 0, 0.650826,-99) , 
NN(
NN(
0, 
0, 
-1, -0.690192, 0, 1, 0.579601,-99) , 
NN(
0, 
0, 
-1, -0.827771, 0, -1, 0.388632,-99) , 
2, -0.454271, 1, 0, 0.441115,-99) , 
0, 2.29217, 0, 0, 0.480846,-99)    );
  // itree = 412
  fBoostWeights.push_back(0.155668);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.19965, 1, 1, 0.550483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317847,-99) , 
0, -1.90242, 1, 0, 0.399007,-99) , 
2, -0.762521, 0, 0, 0.528219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0289531,-99) , 
3, -1.89389, 0, 0, 0.514006,-99)    );
  // itree = 413
  fBoostWeights.push_back(0.164782);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.46684, 0, 1, 0.559421,-99) , 
NN(
0, 
0, 
-1, -0.749949, 1, -1, 0.263555,-99) , 
3, -1.01522, 0, 0, 0.522263,-99)    );
  // itree = 414
  fBoostWeights.push_back(0.309711);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32611,-99) , 
2, 1.72765, 1, 0, 0.485308,-99) , 
1, 0.657078, 0, 0, 0.586491,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278674,-99) , 
1, -1.17103, 0, 0, 0.486103,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336023,-99) , 
2, -1.20536, 1, 0, 0.365993,-99) , 
1, -0.125008, 1, 0, 0.408653,-99) , 
2, 1.48772, 0, 0, 0.429262,-99)    );
  // itree = 415
  fBoostWeights.push_back(0.251162);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.589937, 1, 1, 0.619673,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320327,-99) , 
2, 0.513747, 1, 0, 0.525849,-99) , 
NN(
0, 
0, 
-1, 0.0554896, 0, -1, 0.364349,-99) , 
3, -0.0728858, 0, 0, 0.432876,-99) , 
3, 0.828289, 0, 0, 0.509457,-99)    );
  // itree = 416
  fBoostWeights.push_back(0.180933);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492564,-99) , 
1, -0.0829569, 1, 0, 0.61654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432691,-99) , 
3, 2.06755, 0, 0, 0.456615,-99) , 
0, -1.26928, 1, 0, 0.478707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.68639, 0, 0, 0.46685,-99)    );
  // itree = 417
  fBoostWeights.push_back(0.265379);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25777, 0, 1, 0.659399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404393,-99) , 
3, 0.613729, 0, 0, 0.474287,-99) , 
1, 1.45818, 1, 0, 0.578541,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37379,-99) , 
1, -1.51858, 0, 0, 0.533719,-99) , 
NN(
0, 
0, 
-1, 1.01032, 1, -1, 0.37962,-99) , 
1, -1.10928, 1, 0, 0.403516,-99) , 
1, 0.843066, 0, 0, 0.444114,-99)    );
  // itree = 418
  fBoostWeights.push_back(0.160756);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.670619, 1, 1, 0.715922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421547,-99) , 
1, -0.521807, 0, 0, 0.485253,-99) , 
1, 0.961198, 0, 0, 0.514092,-99) , 
NN(
0, 
0, 
-1, -0.153899, 1, -1, 0.319414,-99) , 
1, 1.38085, 1, 0, 0.488952,-99)    );
  // itree = 419
  fBoostWeights.push_back(0.298834);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.796883, 1, 1, 0.59763,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291091,-99) , 
0, -2.48524, 1, 0, 0.418138,-99) , 
3, -0.783368, 0, 0, 0.552617,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.934713,-99) , 
NN(
0, 
0, 
-1, 1.6271, 0, -1, 0.312418,-99) , 
0, 1.04, 1, 0, 0.392197,-99) , 
2, 1.0535, 1, 0, 0.506463,-99)    );
  // itree = 420
  fBoostWeights.push_back(0.207007);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479339,-99) , 
3, 0.166609, 0, 0, 0.559164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367861,-99) , 
0, 0.470015, 1, 0, 0.459154,-99) , 
1, 0.465451, 1, 0, 0.525623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155646,-99) , 
1, 2.16737, 1, 0, 0.513319,-99)    );
  // itree = 421
  fBoostWeights.push_back(0.248298);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.2533, 1, 1, 0.661604,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269962,-99) , 
3, -0.47199, 0, 0, 0.441654,-99) , 
1, 1.39715, 1, 0, 0.596147,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491988,-99) , 
2, 0.693394, 0, 0, 0.623228,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361069,-99) , 
0, -1.02837, 1, 0, 0.387783,-99) , 
1, -1.44258, 1, 0, 0.409995,-99) , 
1, 0.413135, 0, 0, 0.47644,-99)    );
  // itree = 422
  fBoostWeights.push_back(0.215169);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470236,-99) , 
0, 0.767677, 1, 0, 0.496594,-99) , 
2, 0.0833073, 1, 0, 0.532269,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197024,-99) , 
3, -1.68452, 0, 0, 0.494338,-99) , 
NN(
0, 
0, 
-1, 0.321661, 0, -1, 0.284066,-99) , 
2, -0.022231, 1, 0, 0.399816,-99) , 
3, 0.760049, 0, 0, 0.460491,-99)    );
  // itree = 423
  fBoostWeights.push_back(0.22733);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455935,-99) , 
1, 0.824082, 1, 0, 0.55949,-99) , 
1, -1.07065, 1, 0, 0.580368,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374414,-99) , 
1, -0.873835, 1, 0, 0.420693,-99) , 
1, 1.29284, 0, 0, 0.447769,-99) , 
3, 0.256412, 0, 0, 0.526456,-99)    );
  // itree = 424
  fBoostWeights.push_back(0.124147);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.48959, 0, 1, 0.696228,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470933,-99) , 
2, 2.6621, 0, 0, 0.480563,-99) , 
1, -1.23602, 1, 0, 0.49612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0836929,-99) , 
1, -2.21448, 0, 0, 0.481088,-99)    );
  // itree = 425
  fBoostWeights.push_back(0.295557);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.648482, 1, 1, 0.835938,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401158,-99) , 
2, 0.164687, 0, 0, 0.570009,-99) , 
0, -2.19565, 1, 0, 0.609953,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325705,-99) , 
0, 2.51683, 1, 0, 0.598845,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359614,-99) , 
3, 0.785531, 0, 0, 0.447758,-99) , 
1, -0.722365, 1, 0, 0.492794,-99) , 
1, 0.368059, 0, 0, 0.541913,-99)    );
  // itree = 426
  fBoostWeights.push_back(0.190426);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.357045, 0, 1, 0.705312,-99) , 
NN(
NN(
0, 
0, 
-1, 1.25419, 0, 1, 0.539786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3552,-99) , 
1, -1.2428, 1, 0, 0.396986,-99) , 
0, 1.13245, 1, 0, 0.484917,-99) , 
3, 2.60454, 0, 0, 0.500651,-99)    );
  // itree = 427
  fBoostWeights.push_back(0.297585);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.627305, 0, 1, 0.638335,-99) , 
NN(
0, 
0, 
-1, -1.09705, 1, -1, 0.398484,-99) , 
3, -0.618837, 0, 0, 0.5841,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245933,-99) , 
3, 3.02825, 1, 0, 0.45611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.110436,-99) , 
3, 2.44364, 0, 0, 0.314903,-99) , 
0, 3.06373, 1, 0, 0.552564,-99)    );
  // itree = 428
  fBoostWeights.push_back(0.231327);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462181,-99) , 
2, -0.170469, 0, 0, 0.637816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257187,-99) , 
1, -1.05754, 0, 0, 0.479508,-99) , 
2, 0.428853, 1, 0, 0.533047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200176,-99) , 
3, -1.76764, 0, 0, 0.507259,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148294,-99) , 
0, -1.27603, 0, 0, 0.302488,-99) , 
2, -0.88462, 1, 0, 0.401969,-99) , 
2, -0.420818, 0, 0, 0.496659,-99)    );
  // itree = 429
  fBoostWeights.push_back(0.232038);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498392,-99) , 
0, 1.91102, 1, 0, 0.59744,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424594,-99) , 
3, 1.8433, 0, 0, 0.434341,-99) , 
2, 1.38813, 0, 0, 0.460761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633179,-99) , 
NN(
0, 
0, 
-1, 0.798266, 0, -1, 0.117079,-99) , 
2, -0.574531, 1, 0, 0.244124,-99) , 
1, 1.18976, 1, 0, 0.432043,-99)    );
  // itree = 430
  fBoostWeights.push_back(0.172117);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377125,-99) , 
0, 2.53864, 1, 0, 0.644062,-99) , 
NN(
0, 
0, 
-1, -1.48425, 0, -1, 0.46992,-99) , 
3, 1.05441, 0, 0, 0.503808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530777,-99) , 
NN(
0, 
0, 
-1, 2.06424, 1, -1, 0.294326,-99) , 
3, 2.9433, 0, 0, 0.332193,-99) , 
2, 1.34534, 1, 0, 0.47441,-99)    );
  // itree = 431
  fBoostWeights.push_back(0.229232);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46616,-99) , 
1, 0.705906, 1, 0, 0.563396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276856,-99) , 
1, -1.72494, 0, 0, 0.550024,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255256,-99) , 
0, 3.33179, 1, 0, 0.478305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204312,-99) , 
2, 1.19242, 0, 0, 0.377746,-99) , 
0, 2.29217, 1, 0, 0.520998,-99)    );
  // itree = 432
  fBoostWeights.push_back(0.245356);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196117,-99) , 
3, -1.51581, 0, 0, 0.564818,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377416,-99) , 
3, 1.78631, 0, 0, 0.450728,-99) , 
0, 0.980853, 1, 0, 0.518144,-99) , 
NN(
0, 
0, 
-1, 0.330858, 0, -1, 0.220587,-99) , 
2, 2.26304, 1, 0, 0.501987,-99)    );
  // itree = 433
  fBoostWeights.push_back(0.313898);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.362886, 0, 1, 0.704529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371171,-99) , 
1, -1.25447, 1, 0, 0.439604,-99) , 
1, 0.247361, 0, 0, 0.56616,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234876,-99) , 
3, 0.168928, 0, 0, 0.470286,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288681,-99) , 
3, 2.64285, 0, 0, 0.348773,-99) , 
0, 1.67405, 1, 0, 0.409158,-99) , 
2, 0.113077, 1, 0, 0.471134,-99)    );
  // itree = 434
  fBoostWeights.push_back(0.178332);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450568,-99) , 
3, 0.773141, 0, 0, 0.498002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143741,-99) , 
2, 2.47179, 1, 0, 0.486884,-99) , 
NN(
0, 
0, 
-1, 0.434174, 1, -1, 0.188438,-99) , 
3, -1.17493, 0, 0, 0.460839,-99)    );
  // itree = 435
  fBoostWeights.push_back(0.154419);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65512, 0, 1, 0.539185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239647,-99) , 
2, 2.25074, 1, 0, 0.52711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233408,-99) , 
3, 1.43323, 0, 0, 0.317086,-99) , 
1, 1.19437, 1, 0, 0.374331,-99) , 
1, 1.04982, 1, 0, 0.495187,-99)    );
  // itree = 436
  fBoostWeights.push_back(0.127556);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498454,-99) , 
2, -0.184055, 1, 0, 0.53952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168323,-99) , 
3, -1.48411, 0, 0, 0.525008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173207,-99) , 
0, 3.94904, 1, 0, 0.511523,-99)    );
  // itree = 437
  fBoostWeights.push_back(0.273481);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0789854, 1, 1, 0.634077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215982,-99) , 
3, 0.608826, 0, 0, 0.438221,-99) , 
0, 0.0729472, 1, 0, 0.50238,-99) , 
NN(
0, 
0, 
-1, -0.405014, 1, -1, 0.272321,-99) , 
3, -1.03873, 0, 0, 0.474896,-99)    );
  // itree = 438
  fBoostWeights.push_back(0.121724);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744776,-99) , 
NN(
0, 
0, 
-1, 0.198194, 1, -1, 0.457784,-99) , 
3, -1.25833, 1, 0, 0.468973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0689104,-99) , 
3, -1.54964, 0, 0, 0.457999,-99)    );
  // itree = 439
  fBoostWeights.push_back(0.301533);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.79337, 1, 1, 0.696473,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.119426,-99) , 
1, 1.4229, 1, 0, 0.479419,-99) , 
2, -0.291482, 0, 0, 0.542255,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423981,-99) , 
1, 0.530773, 0, 0, 0.570332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31574,-99) , 
0, 0.516253, 1, 0, 0.343476,-99) , 
3, 1.58534, 0, 0, 0.412725,-99) , 
0, 0.206177, 1, 0, 0.463852,-99)    );
  // itree = 440
  fBoostWeights.push_back(0.206558);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368673,-99) , 
3, -0.408561, 0, 0, 0.644895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431861,-99) , 
2, -1.13969, 1, 0, 0.453598,-99) , 
1, -1.28006, 1, 0, 0.470004,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157269,-99) , 
1, 1.94792, 1, 0, 0.456882,-99)    );
  // itree = 441
  fBoostWeights.push_back(0.193937);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09304, 1, 1, 0.746982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383761,-99) , 
3, 0.733164, 1, 0, 0.507282,-99) , 
3, 1.05459, 0, 0, 0.545137,-99) , 
NN(
NN(
0, 
0, 
-1, 3.05118, 0, 1, 0.651415,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274791,-99) , 
2, 2.24626, 0, 0, 0.32452,-99) , 
1, -0.48289, 1, 0, 0.403589,-99) , 
0, 1.92994, 1, 0, 0.514887,-99)    );
  // itree = 442
  fBoostWeights.push_back(0.262358);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410032,-99) , 
1, -0.480148, 0, 0, 0.57951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321457,-99) , 
1, -0.193814, 1, 0, 0.413767,-99) , 
2, -0.579156, 0, 0, 0.525669,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252852,-99) , 
0, 0.957944, 0, 0, 0.433771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.111008,-99) , 
0, 4.73638, 1, 0, 0.402762,-99) , 
2, 0.903798, 1, 0, 0.491487,-99)    );
  // itree = 443
  fBoostWeights.push_back(0.296761);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.931039, 0, 1, 0.628186,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346104,-99) , 
2, 1.2629, 1, 0, 0.389444,-99) , 
2, 1.10999, 1, 0, 0.535343,-99) , 
NN(
NN(
0, 
0, 
-1, -3.00968, 0, 1, 0.548545,-99) , 
NN(
0, 
0, 
-1, 0.248774, 1, -1, 0.30606,-99) , 
0, -2.42468, 1, 0, 0.351076,-99) , 
2, -0.346453, 0, 0, 0.476818,-99)    );
  // itree = 444
  fBoostWeights.push_back(0.193519);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772605,-99) , 
NN(
0, 
0, 
-1, -1.21316, 0, -1, 0.419477,-99) , 
0, -2.698, 1, 0, 0.42901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0839247,-99) , 
2, -1.64876, 0, 0, 0.418709,-99)    );
  // itree = 445
  fBoostWeights.push_back(0.270891);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466001,-99) , 
2, 0.229929, 1, 0, 0.729431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339668,-99) , 
1, 0.385885, 1, 0, 0.423173,-99) , 
2, 0.334126, 1, 0, 0.500908,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357483,-99) , 
2, -0.521693, 0, 0, 0.425095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196629,-99) , 
0, -0.835383, 1, 0, 0.381178,-99) , 
3, -0.242742, 0, 0, 0.466798,-99)    );
  // itree = 446
  fBoostWeights.push_back(0.273859);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490356,-99) , 
3, 0.590297, 0, 0, 0.657587,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436264,-99) , 
1, 1.06105, 0, 0, 0.48878,-99) , 
2, 0.68651, 1, 0, 0.540238,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.53393, 0, 0, 0.464224,-99) , 
NN(
0, 
0, 
-1, 0.851695, 1, -1, 0.307209,-99) , 
2, -0.711705, 1, 0, 0.370986,-99) , 
0, 0.438571, 0, 0, 0.458933,-99)    );
  // itree = 447
  fBoostWeights.push_back(0.152859);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458973,-99) , 
1, 1.29839, 0, 0, 0.477969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252465,-99) , 
1, 1.77863, 1, 0, 0.466243,-99) , 
NN(
0, 
0, 
-1, -0.206791, 1, -1, 0.229008,-99) , 
3, -1.19711, 0, 0, 0.452759,-99)    );
  // itree = 448
  fBoostWeights.push_back(0.149153);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.48428, 1, 1, 0.738107,-99) , 
NN(
NN(
0, 
0, 
-1, -0.712145, 1, 1, 0.532751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191739,-99) , 
1, -0.922475, 0, 0, 0.513609,-99) , 
1, -1.13954, 1, 0, 0.544125,-99)    );
  // itree = 449
  fBoostWeights.push_back(0.185287);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17428, 1, 1, 0.796916,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471291,-99) , 
0, 0.810523, 1, 0, 0.522357,-99) , 
NN(
0, 
0, 
-1, -1.09101, 1, -1, 0.266871,-99) , 
3, -0.98855, 0, 0, 0.497117,-99) , 
1, -1.33134, 1, 0, 0.525011,-99)    );
  // itree = 450
  fBoostWeights.push_back(0.136476);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857485,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287105,-99) , 
2, -0.419731, 0, 0, 0.501335,-99) , 
2, -0.662701, 1, 0, 0.516418,-99) , 
NN(
0, 
0, 
-1, -1.34572, 1, -1, 0.359338,-99) , 
3, -0.636326, 0, 0, 0.48815,-99)    );
  // itree = 451
  fBoostWeights.push_back(0.261417);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10109, 0, 1, 0.629439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418274,-99) , 
2, 0.851985, 1, 0, 0.453756,-99) , 
0, 1.60293, 1, 0, 0.530075,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389793,-99) , 
1, 0.290288, 1, 0, 0.498634,-99) , 
NN(
0, 
0, 
-1, 0.125041, 0, -1, 0.332707,-99) , 
2, -0.291734, 1, 0, 0.412423,-99) , 
2, 0.516079, 0, 0, 0.463565,-99)    );
  // itree = 452
  fBoostWeights.push_back(0.26678);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.52527, 0, 1, 0.653479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302464,-99) , 
0, 1.57185, 1, 0, 0.391603,-99) , 
1, 1.08782, 1, 0, 0.607169,-99) , 
NN(
NN(
0, 
0, 
-1, -0.650071, 0, 1, 0.58851,-99) , 
NN(
0, 
0, 
-1, -0.345771, 0, -1, 0.389809,-99) , 
0, -1.42658, 1, 0, 0.466319,-99) , 
3, 0.191234, 0, 0, 0.545544,-99)    );
  // itree = 453
  fBoostWeights.push_back(0.209004);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201199,-99) , 
0, 3.66403, 1, 0, 0.549375,-99) , 
NN(
0, 
0, 
-1, -1.64492, 0, -1, 0.345733,-99) , 
3, -1.04575, 0, 0, 0.521929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0856994,-99) , 
1, 2.41928, 1, 0, 0.507591,-99)    );
  // itree = 454
  fBoostWeights.push_back(0.246531);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485021,-99) , 
0, 0.301855, 0, 0, 0.550932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264118,-99) , 
3, 1.18026, 0, 0, 0.398555,-99) , 
0, 0.703452, 1, 0, 0.479781,-99) , 
NN(
0, 
0, 
-1, 2.4165, 0, -1, 0.202189,-99) , 
0, 3.31582, 1, 0, 0.456889,-99)    );
  // itree = 455
  fBoostWeights.push_back(0.265665);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0488358, 1, 1, 0.632152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305483,-99) , 
2, -1.0666, 1, 0, 0.45988,-99) , 
3, -0.218528, 0, 0, 0.584306,-99) , 
NN(
NN(
0, 
0, 
-1, -0.163862, 1, 1, 0.671736,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300821,-99) , 
0, 0.630829, 1, 0, 0.387358,-99) , 
1, -1.34236, 1, 0, 0.433306,-99) , 
1, 0.0932693, 0, 0, 0.502913,-99)    );
  // itree = 456
  fBoostWeights.push_back(0.232792);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407828,-99) , 
0, -2.27118, 0, 0, 0.654576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.970825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411324,-99) , 
1, -1.35606, 1, 0, 0.430979,-99) , 
2, 2.99574, 0, 0, 0.445559,-99) , 
2, -1.15033, 1, 0, 0.465993,-99)    );
  // itree = 457
  fBoostWeights.push_back(0.226954);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.849618, 0, 1, 0.577901,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305001,-99) , 
3, 3.30718, 0, 0, 0.420025,-99) , 
2, 1.85311, 1, 0, 0.563426,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266366,-99) , 
1, -1.30814, 1, 0, 0.51733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.108403,-99) , 
3, 1.29292, 1, 0, 0.401894,-99) , 
1, -0.919085, 0, 0, 0.539545,-99)    );
  // itree = 458
  fBoostWeights.push_back(0.17621);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432279,-99) , 
0, 1.07096, 1, 0, 0.624116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434502,-99) , 
3, 1.12461, 0, 0, 0.476756,-99) , 
1, -0.753418, 1, 0, 0.494462,-99) , 
NN(
0, 
0, 
-1, -1.57785, 1, -1, 0.285341,-99) , 
1, -1.40231, 0, 0, 0.482288,-99)    );
  // itree = 459
  fBoostWeights.push_back(0.175836);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748823,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256368,-99) , 
1, 1.43118, 1, 0, 0.492413,-99) , 
NN(
0, 
0, 
-1, 0.283669, 1, -1, 0.397936,-99) , 
3, 0.769315, 0, 0, 0.437164,-99) , 
2, -1.9954, 1, 0, 0.446978,-99)    );
  // itree = 460
  fBoostWeights.push_back(0.207203);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46721, 1, 1, 0.698952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413436,-99) , 
3, -0.524541, 0, 0, 0.619358,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47687,-99) , 
0, -0.349975, 1, 0, 0.530395,-99) , 
NN(
0, 
0, 
-1, -0.588556, 0, -1, 0.34538,-99) , 
1, -0.118468, 0, 0, 0.47655,-99) , 
1, -0.705165, 1, 0, 0.499465,-99)    );
  // itree = 461
  fBoostWeights.push_back(0.180543);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44949, 1, 1, 0.76319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468574,-99) , 
1, 1.89736, 1, 0, 0.690234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204584,-99) , 
2, -1.67515, 0, 0, 0.541842,-99) , 
NN(
0, 
0, 
-1, 0.528746, 1, -1, 0.335629,-99) , 
0, 3.54173, 1, 0, 0.520172,-99) , 
1, 1.31207, 0, 0, 0.538814,-99)    );
  // itree = 462
  fBoostWeights.push_back(0.130514);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48102, 1, 1, 0.815376,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470039,-99) , 
2, -1.23635, 1, 0, 0.521926,-99) , 
2, 1.25629, 0, 0, 0.580331,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146237,-99) , 
2, -1.57951, 0, 0, 0.47932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12066,-99) , 
0, 3.73896, 1, 0, 0.459858,-99) , 
1, 0.702061, 0, 0, 0.496226,-99)    );
  // itree = 463
  fBoostWeights.push_back(0.253104);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.16867, 1, 1, 0.582123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383296,-99) , 
0, -2.59984, 0, 0, 0.569093,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387824,-99) , 
1, 1.99112, 1, 0, 0.57707,-99) , 
NN(
0, 
0, 
-1, 0.291241, 0, -1, 0.34795,-99) , 
1, 1.53108, 0, 0, 0.378766,-99) , 
1, 0.0824709, 1, 0, 0.465331,-99)    );
  // itree = 464
  fBoostWeights.push_back(0.294674);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.7101, 0, 1, 0.723487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229339,-99) , 
2, -1.51776, 0, 0, 0.636319,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420946,-99) , 
1, 0.986505, 0, 0, 0.458282,-99) , 
NN(
0, 
0, 
-1, -0.335393, 0, -1, 0.284384,-99) , 
3, 0.108085, 0, 0, 0.411049,-99) , 
0, -1.05284, 1, 0, 0.448942,-99)    );
  // itree = 465
  fBoostWeights.push_back(0.204539);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1451, 0, 1, 0.585514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277649,-99) , 
3, -1.50563, 0, 0, 0.572408,-99) , 
NN(
0, 
0, 
-1, 2.80482, 0, -1, 0.254411,-99) , 
0, 3.54173, 1, 0, 0.552767,-99)    );
  // itree = 466
  fBoostWeights.push_back(0.161205);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314218,-99) , 
3, -0.626701, 0, 0, 0.503447,-99) , 
0, -2.40169, 1, 0, 0.520616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.97131, 0, 0, 0.506842,-99)    );
  // itree = 467
  fBoostWeights.push_back(0.1555);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34615,-99) , 
0, 3.90865, 1, 0, 0.678688,-99) , 
NN(
0, 
0, 
-1, 2.21491, 1, -1, 0.458556,-99) , 
3, 2.14296, 0, 0, 0.480651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146292,-99) , 
2, 2.31809, 1, 0, 0.469508,-99)    );
  // itree = 468
  fBoostWeights.push_back(0.27013);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85927, 0, 1, 0.676768,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309714,-99) , 
3, 3.03645, 0, 0, 0.427954,-99) , 
0, 2.99041, 1, 0, 0.594696,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296013,-99) , 
2, -1.31843, 0, 0, 0.511406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279703,-99) , 
2, 0.0728667, 1, 0, 0.336914,-99) , 
0, 0.630124, 1, 0, 0.452101,-99) , 
2, 0.973129, 0, 0, 0.48813,-99)    );
  // itree = 469
  fBoostWeights.push_back(0.187695);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460562,-99) , 
2, -0.146458, 0, 0, 0.561471,-99) , 
NN(
0, 
0, 
-1, 1.28038, 1, -1, 0.440641,-99) , 
2, 0.481742, 1, 0, 0.494538,-99) , 
NN(
0, 
0, 
-1, 0.154445, 0, -1, 0.276901,-99) , 
3, -1.17939, 0, 0, 0.477145,-99)    );
  // itree = 470
  fBoostWeights.push_back(0.0905902);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.56429, 0, 1, 0.654288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307812,-99) , 
0, -2.06254, 0, 0, 0.495983,-99) , 
0, -2.56266, 1, 0, 0.507252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650365,-99) , 
NN(
0, 
0, 
-1, 0.41031, 0, -1, 0.238114,-99) , 
1, -1.60584, 1, 0, 0.361203,-99) , 
1, -1.21471, 0, 0, 0.494194,-99)    );
  // itree = 471
  fBoostWeights.push_back(0.223838);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0474684, 0, 1, 0.733844,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482753,-99) , 
0, 0.135751, 1, 0, 0.587228,-99) , 
1, 1.20529, 0, 0, 0.664792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477247,-99) , 
1, -0.226658, 1, 0, 0.524368,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28386,-99) , 
2, 0.329446, 1, 0, 0.364323,-99) , 
1, -0.680016, 0, 0, 0.479666,-99) , 
1, 0.907319, 0, 0, 0.528469,-99)    );
  // itree = 472
  fBoostWeights.push_back(0.215247);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49983,-99) , 
3, 0.401729, 0, 0, 0.592069,-99) , 
NN(
0, 
0, 
-1, 1.73589, 1, -1, 0.38421,-99) , 
1, 1.21985, 1, 0, 0.546608,-99) , 
NN(
0, 
0, 
-1, -1.2714, 0, -1, 0.381109,-99) , 
1, -0.102661, 0, 0, 0.480371,-99)    );
  // itree = 473
  fBoostWeights.push_back(0.138074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56248, 1, 1, 0.831485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432584,-99) , 
2, 2.20286, 1, 0, 0.684748,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480484,-99) , 
3, 1.42958, 0, 0, 0.493086,-99) , 
NN(
0, 
0, 
-1, -0.351653, 1, -1, 0.33239,-99) , 
0, 1.87263, 1, 0, 0.468722,-99) , 
3, 2.15836, 0, 0, 0.489148,-99)    );
  // itree = 474
  fBoostWeights.push_back(0.156154);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793563,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192584,-99) , 
3, -1.5964, 0, 0, 0.547785,-99) , 
NN(
0, 
0, 
-1, -0.452168, 0, -1, 0.448323,-99) , 
2, -0.226469, 1, 0, 0.48109,-99) , 
3, 3.09541, 0, 0, 0.495107,-99)    );
  // itree = 475
  fBoostWeights.push_back(0.199755);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.385404, 0, 1, 0.618186,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485148,-99) , 
0, 1.78998, 1, 0, 0.552501,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412045,-99) , 
1, -1.2882, 1, 0, 0.436798,-99) , 
1, 0.501006, 0, 0, 0.477252,-99) , 
2, -0.0811742, 1, 0, 0.528152,-99)    );
  // itree = 476
  fBoostWeights.push_back(0.250816);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.401806, 1, 1, 0.650417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357225,-99) , 
2, -0.465788, 0, 0, 0.462497,-99) , 
1, -0.452168, 0, 0, 0.58731,-99) , 
NN(
NN(
0, 
0, 
-1, 3.13757, 1, 1, 0.719348,-99) , 
NN(
0, 
0, 
-1, 2.6691, 1, -1, 0.401167,-99) , 
3, 2.17027, 0, 0, 0.474666,-99) , 
0, 0.749055, 1, 0, 0.533892,-99)    );
  // itree = 477
  fBoostWeights.push_back(0.13289);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12918, 1, 1, 0.610809,-99) , 
NN(
0, 
0, 
-1, 1.01688, 1, -1, 0.470007,-99) , 
3, 0.891327, 0, 0, 0.519128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155006,-99) , 
2, 2.7171, 1, 0, 0.509138,-99)    );
  // itree = 478
  fBoostWeights.push_back(0.175714);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440695,-99) , 
1, 1.35679, 1, 0, 0.638521,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387529,-99) , 
1, 0.508476, 1, 0, 0.5209,-99) , 
1, 0.907319, 0, 0, 0.541099,-99) , 
NN(
0, 
0, 
-1, -3.05407, 1, -1, 0.309477,-99) , 
3, -1.16308, 0, 0, 0.522025,-99)    );
  // itree = 479
  fBoostWeights.push_back(0.208739);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.287789, 1, 1, 0.565736,-99) , 
NN(
0, 
0, 
-1, 2.25522, 0, -1, 0.276286,-99) , 
0, 3.1712, 1, 0, 0.524065,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373743,-99) , 
1, 0.214965, 1, 0, 0.465226,-99) , 
NN(
0, 
0, 
-1, -1.17038, 1, -1, 0.253032,-99) , 
2, -0.610906, 1, 0, 0.406692,-99) , 
3, -0.218528, 0, 0, 0.490339,-99)    );
  // itree = 480
  fBoostWeights.push_back(0.202785);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.958214, 1, 1, 0.555897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225406,-99) , 
1, 0.580141, 0, 0, 0.528699,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398335,-99) , 
1, -0.198749, 0, 0, 0.493784,-99) , 
NN(
0, 
0, 
-1, 0.0820935, 1, -1, 0.396771,-99) , 
2, 0.190311, 1, 0, 0.440609,-99) , 
1, 0.444458, 0, 0, 0.472232,-99)    );
  // itree = 481
  fBoostWeights.push_back(0.209407);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.31539, 0, 1, 0.786672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486047,-99) , 
2, 2.47945, 0, 0, 0.5494,-99) , 
3, 2.61686, 1, 0, 0.680055,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393804,-99) , 
2, -1.43523, 0, 0, 0.558508,-99) , 
NN(
0, 
0, 
-1, 2.1117, 1, -1, 0.395423,-99) , 
0, 0.438447, 1, 0, 0.473398,-99) , 
3, 2.16453, 0, 0, 0.501189,-99)    );
  // itree = 482
  fBoostWeights.push_back(0.118221);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370706,-99) , 
2, -0.684032, 0, 0, 0.502547,-99) , 
0, -1.74081, 1, 0, 0.513568,-99) , 
NN(
0, 
0, 
-1, -0.365486, 1, -1, 0.273604,-99) , 
3, -1.19711, 0, 0, 0.493685,-99)    );
  // itree = 483
  fBoostWeights.push_back(0.233195);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.66631, 0, 1, 0.727271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351185,-99) , 
2, -0.293904, 0, 0, 0.522702,-99) , 
2, -1.28979, 1, 0, 0.540292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0781093,-99) , 
2, 2.80805, 1, 0, 0.524055,-99)    );
  // itree = 484
  fBoostWeights.push_back(0.173415);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494021,-99) , 
2, 1.08965, 1, 0, 0.568529,-99) , 
3, 3.05591, 0, 0, 0.612204,-99) , 
NN(
NN(
0, 
0, 
-1, -2.94886, 0, 1, 0.716275,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453576,-99) , 
1, 1.60105, 0, 0, 0.472074,-99) , 
2, -1.18626, 1, 0, 0.492859,-99) , 
2, 0.863656, 0, 0, 0.529721,-99)    );
  // itree = 485
  fBoostWeights.push_back(0.115008);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.878661, 1, 1, 0.744647,-99) , 
NN(
0, 
0, 
-1, 3.70336, 1, -1, 0.469778,-99) , 
1, -1.36363, 1, 0, 0.487338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.73941, 0, 0, 0.473094,-99)    );
  // itree = 486
  fBoostWeights.push_back(0.104936);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.955907, 1, 1, 0.526255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194529,-99) , 
3, -1.50563, 0, 0, 0.510181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15777,-99) , 
0, 3.54173, 1, 0, 0.495625,-99)    );
  // itree = 487
  fBoostWeights.push_back(0.197419);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.252043, 1, 1, 0.62547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422061,-99) , 
0, 4.53105, 1, 0, 0.595216,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458062,-99) , 
3, 0.294878, 0, 0, 0.507731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151242,-99) , 
0, 1.64871, 0, 0, 0.301926,-99) , 
0, 1.36021, 1, 0, 0.475582,-99) , 
3, 1.24522, 0, 0, 0.509736,-99)    );
  // itree = 488
  fBoostWeights.push_back(0.24275);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14161, 1, 1, 0.762742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472591,-99) , 
1, 1.19128, 0, 0, 0.495047,-99) , 
3, 0.443205, 0, 0, 0.55386,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.076846,-99) , 
1, 0.703994, 1, 0, 0.512639,-99) , 
NN(
0, 
0, 
-1, 1.66932, 1, -1, 0.361539,-99) , 
0, 2.73326, 0, 0, 0.408225,-99) , 
2, 0.608924, 1, 0, 0.494784,-99)    );
  // itree = 489
  fBoostWeights.push_back(0.1431);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.650894, 1, 1, 0.60808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258048,-99) , 
3, 0.502425, 1, 0, 0.477969,-99) , 
0, -2.76395, 1, 0, 0.500596,-99) , 
3, 0.673895, 0, 0, 0.545332,-99)    );
  // itree = 490
  fBoostWeights.push_back(0.226787);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450129,-99) , 
2, -0.612888, 0, 0, 0.586224,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401322,-99) , 
3, 0.988268, 0, 0, 0.473771,-99) , 
0, -0.794061, 1, 0, 0.50103,-99) , 
NN(
0, 
0, 
-1, 1.95618, 0, -1, 0.307689,-99) , 
1, 1.17188, 1, 0, 0.4768,-99)    );
  // itree = 491
  fBoostWeights.push_back(0.281064);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.337892, 0, 1, 0.615361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281687,-99) , 
2, 0.663559, 1, 0, 0.465907,-99) , 
1, 1.0689, 1, 0, 0.574214,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420673,-99) , 
3, 1.21081, 1, 0, 0.637279,-99) , 
NN(
0, 
0, 
-1, -0.681006, 0, -1, 0.348622,-99) , 
1, -1.24989, 1, 0, 0.420369,-99) , 
1, -0.256338, 0, 0, 0.515508,-99)    );
  // itree = 492
  fBoostWeights.push_back(0.274591);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448989,-99) , 
3, -0.856386, 0, 0, 0.62677,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306949,-99) , 
1, -0.80974, 0, 0, 0.447762,-99) , 
0, 1.41763, 1, 0, 0.56165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448967,-99) , 
1, 0.735187, 0, 0, 0.607703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242543,-99) , 
3, 0.625717, 0, 0, 0.425953,-99) , 
0, -0.413582, 1, 0, 0.462574,-99) , 
1, 0.213586, 1, 0, 0.515939,-99)    );
  // itree = 493
  fBoostWeights.push_back(0.197413);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480576,-99) , 
3, 0.419206, 0, 0, 0.545583,-99) , 
NN(
0, 
0, 
-1, 0.618906, 1, -1, 0.328759,-99) , 
1, 1.2922, 1, 0, 0.517267,-99) , 
NN(
0, 
0, 
-1, 1.8316, 0, -1, 0.158133,-99) , 
0, 3.54173, 1, 0, 0.49417,-99)    );
  // itree = 494
  fBoostWeights.push_back(0.177245);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.89803, 1, 1, 0.577109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749448,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362764,-99) , 
2, 0.825541, 0, 0, 0.415631,-99) , 
0, -2.52308, 1, 0, 0.434042,-99) , 
1, -0.227901, 1, 0, 0.486922,-99)    );
  // itree = 495
  fBoostWeights.push_back(0.257872);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.241798, 0, 1, 0.61419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.77234, 0, 0, 0.576661,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369517,-99) , 
1, -0.125008, 1, 0, 0.427703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0577964,-99) , 
0, 4.56917, 1, 0, 0.409093,-99) , 
2, 0.0876493, 1, 0, 0.483767,-99)    );
  // itree = 496
  fBoostWeights.push_back(0.297081);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483314,-99) , 
3, -0.628792, 0, 0, 0.571956,-99) , 
NN(
0, 
0, 
-1, -0.48594, 1, -1, 0.305821,-99) , 
1, 1.04982, 1, 0, 0.524981,-99) , 
NN(
NN(
0, 
0, 
-1, 3.0119, 0, 1, 0.632743,-99) , 
NN(
0, 
0, 
-1, 1.85301, 1, -1, 0.330272,-99) , 
3, 2.53937, 0, 0, 0.36206,-99) , 
2, 0.0876493, 1, 0, 0.420406,-99)    );
  // itree = 497
  fBoostWeights.push_back(0.0910805);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73813,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485774,-99) , 
2, -1.18673, 1, 0, 0.498692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160594,-99) , 
2, 2.45716, 1, 0, 0.489124,-99) , 
0, -2.89816, 1, 0, 0.502526,-99)    );
  // itree = 498
  fBoostWeights.push_back(0.118065);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86342,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441822,-99) , 
1, 0.19026, 0, 0, 0.618992,-99) , 
3, -1.19935, 0, 0, 0.732851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683558,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360927,-99) , 
2, -0.307157, 0, 0, 0.479126,-99) , 
2, -0.784253, 1, 0, 0.492204,-99) , 
2, -1.02978, 1, 0, 0.516429,-99)    );
  // itree = 499
  fBoostWeights.push_back(0.281531);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.232784, 0, 1, 0.703529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477907,-99) , 
2, -0.512075, 1, 0, 0.529874,-99) , 
1, 0.417036, 0, 0, 0.59879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700705,-99) , 
NN(
0, 
0, 
-1, 0.0793979, 1, -1, 0.199035,-99) , 
3, 3.03842, 0, 0, 0.318358,-99) , 
0, 2.82704, 1, 0, 0.564185,-99)    );
  // itree = 500
  fBoostWeights.push_back(0.177929);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346222,-99) , 
1, 1.61525, 1, 0, 0.547787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214919,-99) , 
2, 2.03776, 1, 0, 0.53327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0273616,-99) , 
0, 4.44906, 1, 0, 0.515817,-99)    );
  // itree = 501
  fBoostWeights.push_back(0.254033);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.575578, 1, 1, 0.566813,-99) , 
NN(
0, 
0, 
-1, 0.386906, 1, -1, 0.289242,-99) , 
1, -0.992532, 0, 0, 0.528806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.103018,-99) , 
2, 1.71297, 1, 0, 0.464133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261117,-99) , 
3, 2.01306, 0, 0, 0.344063,-99) , 
1, -0.134696, 1, 0, 0.390306,-99) , 
0, 1.05495, 1, 0, 0.47273,-99)    );
  // itree = 502
  fBoostWeights.push_back(0.124654);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488248,-99) , 
1, -1.41455, 0, 0, 0.638381,-99) , 
1, -1.83917, 1, 0, 0.682284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718977,-99) , 
NN(
0, 
0, 
-1, 2.84997, 1, -1, 0.459851,-99) , 
2, -1.5071, 1, 0, 0.471697,-99) , 
1, -1.1416, 1, 0, 0.492043,-99)    );
  // itree = 503
  fBoostWeights.push_back(0.293323);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0478431,-99) , 
3, -1.58777, 0, 0, 0.567398,-99) , 
NN(
0, 
0, 
-1, 1.72042, 0, -1, 0.360177,-99) , 
3, 1.43114, 1, 0, 0.517352,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443029,-99) , 
2, 0.914888, 1, 0, 0.559336,-99) , 
NN(
0, 
0, 
-1, 1.20338, 1, -1, 0.299949,-99) , 
3, 1.29329, 0, 0, 0.371286,-99) , 
1, 0.527824, 1, 0, 0.469572,-99)    );
  // itree = 504
  fBoostWeights.push_back(0.180967);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.336981, 0, 1, 0.751617,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455848,-99) , 
0, 0.494648, 1, 0, 0.500693,-99) , 
1, 0.404544, 1, 0, 0.54655,-99) , 
NN(
0, 
0, 
-1, 0.0397269, 1, -1, 0.407247,-99) , 
1, 0.213586, 0, 0, 0.471063,-99)    );
  // itree = 505
  fBoostWeights.push_back(0.113934);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.472324, 1, 1, 0.726302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442724,-99) , 
2, -0.522224, 1, 0, 0.542639,-99) , 
3, 0.0504629, 0, 0, 0.642853,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247469,-99) , 
0, 3.25936, 1, 0, 0.489998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.064845,-99) , 
3, -1.55072, 0, 0, 0.476664,-99) , 
1, -0.733145, 1, 0, 0.507716,-99)    );
  // itree = 506
  fBoostWeights.push_back(0.234168);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.614918, 1, 1, 0.604864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402348,-99) , 
0, -1.38986, 1, 0, 0.449984,-99) , 
2, -0.361663, 0, 0, 0.570762,-99) , 
NN(
0, 
0, 
-1, -1.32073, 1, -1, 0.285802,-99) , 
3, -1.09475, 0, 0, 0.542019,-99)    );
  // itree = 507
  fBoostWeights.push_back(0.225419);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.18651, 1, 1, 0.689415,-99) , 
NN(
0, 
0, 
-1, 3.0461, 1, -1, 0.472094,-99) , 
1, -0.0287129, 1, 0, 0.515299,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236042,-99) , 
1, -1.44973, 1, 0, 0.277864,-99) , 
0, -1.49472, 1, 0, 0.345857,-99) , 
1, -0.392075, 0, 0, 0.464522,-99)    );
  // itree = 508
  fBoostWeights.push_back(0.196416);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.444311, 0, 1, 0.650091,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459866,-99) , 
1, 1.88907, 0, 0, 0.477198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274182,-99) , 
1, -0.689324, 1, 0, 0.315303,-99) , 
3, -0.142518, 0, 0, 0.435787,-99) , 
0, -2.4087, 1, 0, 0.448347,-99)    );
  // itree = 509
  fBoostWeights.push_back(0.157758);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428102,-99) , 
1, 0.593889, 1, 0, 0.503481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252477,-99) , 
2, 2.19931, 1, 0, 0.490984,-99) , 
NN(
0, 
0, 
-1, -1.76877, 1, -1, 0.265791,-99) , 
1, -1.52075, 0, 0, 0.47514,-99)    );
  // itree = 510
  fBoostWeights.push_back(0.296718);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09471, 0, 1, 0.751289,-99) , 
NN(
0, 
0, 
-1, 2.26046, 1, -1, 0.435577,-99) , 
0, 2.29681, 1, 0, 0.617256,-99) , 
NN(
NN(
0, 
0, 
-1, -1.37109, 1, 1, 0.63194,-99) , 
NN(
0, 
0, 
-1, -0.542833, 0, -1, 0.376876,-99) , 
0, -1.30858, 1, 0, 0.439544,-99) , 
3, 0.661338, 0, 0, 0.511377,-99)    );
  // itree = 511
  fBoostWeights.push_back(0.301708);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468181,-99) , 
1, 0.527824, 1, 0, 0.613641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317914,-99) , 
1, 0.384357, 0, 0, 0.443206,-99) , 
0, 1.62587, 1, 0, 0.554493,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254742,-99) , 
1, 0.685091, 1, 0, 0.44152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194103,-99) , 
2, -0.763387, 1, 0, 0.385006,-99) , 
3, -0.547237, 0, 0, 0.521921,-99)    );
  // itree = 512
  fBoostWeights.push_back(0.202835);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.52177, 1, 1, 0.679765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439608,-99) , 
0, 0.652708, 1, 0, 0.499246,-99) , 
2, 1.45905, 0, 0, 0.524153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595611,-99) , 
NN(
0, 
0, 
-1, 0.911442, 0, -1, 0.186514,-99) , 
1, -0.552127, 1, 0, 0.297085,-99) , 
3, -0.95557, 0, 0, 0.49317,-99)    );
  // itree = 513
  fBoostWeights.push_back(0.287733);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21733, 1, 1, 0.689965,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178857,-99) , 
2, -1.12494, 1, 0, 0.322672,-99) , 
2, -0.679292, 0, 0, 0.599556,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577082,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217785,-99) , 
2, 2.0061, 1, 0, 0.535743,-99) , 
NN(
0, 
0, 
-1, 0.525801, 1, -1, 0.387498,-99) , 
2, 0.516079, 0, 0, 0.44232,-99) , 
1, 0.37474, 0, 0, 0.501615,-99)    );
  // itree = 514
  fBoostWeights.push_back(0.22958);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.544063, 1, 1, 0.814067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478767,-99) , 
3, -0.624411, 0, 0, 0.722763,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436078,-99) , 
2, 0.391241, 1, 0, 0.506633,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3492,-99) , 
3, 1.00838, 0, 0, 0.399188,-99) , 
1, -0.177889, 0, 0, 0.472555,-99) , 
1, -1.17388, 1, 0, 0.508359,-99)    );
  // itree = 515
  fBoostWeights.push_back(0.25415);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.95242, 1, 1, 0.62092,-99) , 
NN(
0, 
0, 
-1, 1.28146, 0, -1, 0.404891,-99) , 
0, 1.41586, 1, 0, 0.545474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0720374,-99) , 
3, -1.63625, 0, 0, 0.526747,-99)    );
  // itree = 516
  fBoostWeights.push_back(0.281403);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17505, 0, 1, 0.608635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24698,-99) , 
3, 2.97807, 0, 0, 0.337487,-99) , 
0, 2.98516, 1, 0, 0.577176,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363916,-99) , 
0, -1.24028, 0, 0, 0.500806,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295806,-99) , 
1, -1.2026, 1, 0, 0.325032,-99) , 
1, 0.680702, 0, 0, 0.367202,-99) , 
2, -0.231367, 0, 0, 0.500261,-99)    );
  // itree = 517
  fBoostWeights.push_back(0.101369);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.66056, 1, 1, 0.715133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23692,-99) , 
2, -1.18289, 0, 0, 0.486975,-99) , 
0, -1.81563, 1, 0, 0.511717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.10285,-99) , 
3, -1.99188, 0, 0, 0.498661,-99)    );
  // itree = 518
  fBoostWeights.push_back(0.228452);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52824, 1, 1, 0.684843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267621,-99) , 
3, 2.89514, 0, 0, 0.481651,-99) , 
0, 3.10363, 1, 0, 0.58759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46803,-99) , 
3, 0.26344, 0, 0, 0.510485,-99) , 
NN(
0, 
0, 
-1, 0.991655, 0, -1, 0.335356,-99) , 
2, 0.460061, 1, 0, 0.447492,-99) , 
3, 1.73863, 0, 0, 0.470783,-99)    );
  // itree = 519
  fBoostWeights.push_back(0.242518);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459808,-99) , 
0, -0.113477, 1, 0, 0.564454,-99) , 
3, 1.73502, 0, 0, 0.621134,-99) , 
NN(
NN(
0, 
0, 
-1, -0.00149093, 0, 1, 0.699185,-99) , 
NN(
0, 
0, 
-1, 1.13847, 1, -1, 0.392204,-99) , 
1, -1.29442, 1, 0, 0.415356,-99) , 
1, 1.2714, 0, 0, 0.439124,-99)    );
  // itree = 520
  fBoostWeights.push_back(0.196772);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.280902, 1, 1, 0.706123,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41258,-99) , 
3, -1.61814, 0, 0, 0.697946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301949,-99) , 
3, -0.188399, 0, 0, 0.47064,-99) , 
0, -2.27185, 1, 0, 0.490649,-99) , 
1, -1.04839, 1, 0, 0.516221,-99)    );
  // itree = 521
  fBoostWeights.push_back(0.183742);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.624253, 1, 1, 0.568678,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206275,-99) , 
2, -1.27611, 1, 0, 0.411572,-99) , 
3, -1.07736, 0, 0, 0.549752,-99) , 
NN(
0, 
0, 
-1, 4.49892, 1, -1, 0.294471,-99) , 
3, 2.7756, 1, 0, 0.536353,-99)    );
  // itree = 522
  fBoostWeights.push_back(0.280796);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455992,-99) , 
1, -0.0529098, 1, 0, 0.605058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15848,-99) , 
3, -1.526, 0, 0, 0.550998,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417316,-99) , 
1, 0.413135, 0, 0, 0.478607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.125699,-99) , 
1, -0.67199, 1, 0, 0.214499,-99) , 
3, 0.162467, 0, 0, 0.423849,-99) , 
0, -0.67543, 1, 0, 0.454538,-99)    );
  // itree = 523
  fBoostWeights.push_back(0.194328);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.701675, 1, 1, 0.792512,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360373,-99) , 
2, -1.20418, 1, 0, 0.563931,-99) , 
3, -1.07643, 0, 0, 0.677166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861381,-99) , 
NN(
0, 
0, 
-1, -0.252665, 0, -1, 0.449652,-99) , 
1, 1.94792, 0, 0, 0.462644,-99) , 
0, -1.01549, 1, 0, 0.50952,-99)    );
  // itree = 524
  fBoostWeights.push_back(0.213083);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.843253, 1, 1, 0.600607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405605,-99) , 
1, -1.33134, 1, 0, 0.422325,-99) , 
2, 1.09407, 0, 0, 0.436277,-99) , 
3, 1.30905, 0, 0, 0.479978,-99)    );
  // itree = 525
  fBoostWeights.push_back(0.189626);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49447, 0, 1, 0.730767,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293375,-99) , 
2, 1.55853, 0, 0, 0.525487,-99) , 
2, 1.3133, 1, 0, 0.639736,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491073,-99) , 
3, 0.535355, 0, 0, 0.50846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280812,-99) , 
0, 0.936811, 1, 0, 0.489808,-99) , 
3, 0.822362, 0, 0, 0.545817,-99)    );
  // itree = 526
  fBoostWeights.push_back(0.312051);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13583, 1, 1, 0.722596,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34938,-99) , 
2, -0.529332, 0, 0, 0.409534,-99) , 
3, -0.545376, 0, 0, 0.60244,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430354,-99) , 
3, 1.56325, 0, 0, 0.481922,-99) , 
NN(
0, 
0, 
-1, 3.60471, 0, -1, 0.299405,-99) , 
0, 3.16645, 1, 0, 0.446891,-99) , 
2, 0.462259, 1, 0, 0.528235,-99)    );
  // itree = 527
  fBoostWeights.push_back(0.152095);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.903738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477842,-99) , 
0, 3.93825, 1, 0, 0.686741,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383032,-99) , 
1, 1.27721, 1, 0, 0.515919,-99) , 
NN(
0, 
0, 
-1, 1.68185, 1, -1, 0.231463,-99) , 
2, 1.38835, 1, 0, 0.490215,-99) , 
3, 2.30091, 0, 0, 0.506918,-99)    );
  // itree = 528
  fBoostWeights.push_back(0.25848);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19199,-99) , 
2, 1.23387, 1, 0, 0.668975,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400061,-99) , 
2, -0.0835681, 1, 0, 0.514616,-99) , 
3, 0.552174, 0, 0, 0.5535,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491056,-99) , 
1, -1.27691, 1, 0, 0.533883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176047,-99) , 
3, 1.256, 0, 0, 0.462601,-99) , 
0, 1.44235, 1, 0, 0.525521,-99)    );
  // itree = 529
  fBoostWeights.push_back(0.268634);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394691,-99) , 
1, -1.34746, 0, 0, 0.583208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404639,-99) , 
0, -0.968126, 1, 0, 0.46597,-99) , 
1, 0.0834842, 1, 0, 0.523817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.120548,-99) , 
1, 1.76787, 1, 0, 0.506902,-99)    );
  // itree = 530
  fBoostWeights.push_back(0.267018);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341119,-99) , 
1, 0.330381, 0, 0, 0.730783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457465,-99) , 
2, 1.4644, 0, 0, 0.516152,-99) , 
1, 0.517659, 1, 0, 0.577593,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440262,-99) , 
0, -0.15754, 0, 0, 0.56704,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393613,-99) , 
2, -1.07143, 1, 0, 0.41064,-99) , 
1, -1.10926, 1, 0, 0.438291,-99) , 
1, 0.212582, 0, 0, 0.503223,-99)    );
  // itree = 531
  fBoostWeights.push_back(0.10574);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356856,-99) , 
3, -0.15938, 0, 0, 0.4742,-99) , 
2, -1.01647, 1, 0, 0.491487,-99) , 
NN(
0, 
0, 
-1, -0.24519, 1, -1, 0.304975,-99) , 
3, -1.26544, 0, 0, 0.476816,-99)    );
  // itree = 532
  fBoostWeights.push_back(0.218795);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.767613, 1, 1, 0.592202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260251,-99) , 
0, 4.75063, 1, 0, 0.582109,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284706,-99) , 
0, -2.62055, 1, 0, 0.464146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272939,-99) , 
1, 0.290288, 1, 0, 0.377496,-99) , 
3, -0.98855, 0, 0, 0.561402,-99)    );
  // itree = 533
  fBoostWeights.push_back(0.123591);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7267,-99) , 
NN(
0, 
0, 
-1, 1.71792, 1, -1, 0.463096,-99) , 
2, 2.2809, 0, 0, 0.474675,-99) , 
NN(
0, 
0, 
-1, -2.06533, 0, -1, 0.247084,-99) , 
1, -1.48631, 0, 0, 0.456875,-99)    );
  // itree = 534
  fBoostWeights.push_back(0.174404);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.973578, 1, 1, 0.771216,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461293,-99) , 
1, -0.154998, 0, 0, 0.533974,-99) , 
1, -0.992532, 1, 0, 0.552137,-99) , 
NN(
0, 
0, 
-1, -2.81954, 1, -1, 0.240871,-99) , 
3, -1.19711, 0, 0, 0.529773,-99)    );
  // itree = 535
  fBoostWeights.push_back(0.215259);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.224669, 1, 1, 0.609303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51699,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265879,-99) , 
3, -0.691403, 0, 0, 0.468833,-99) , 
1, -0.543669, 0, 0, 0.564808,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422806,-99) , 
0, 0.0117177, 1, 0, 0.523916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239252,-99) , 
1, 1.44759, 0, 0, 0.395253,-99) , 
1, 1.12702, 1, 0, 0.53875,-99)    );
  // itree = 536
  fBoostWeights.push_back(0.235657);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289725,-99) , 
3, 0.313295, 1, 0, 0.653203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380731,-99) , 
3, 0.679252, 0, 0, 0.469811,-99) , 
0, -0.00235569, 1, 0, 0.500646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364341,-99) , 
3, -0.834033, 0, 0, 0.469626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.120692,-99) , 
0, -0.667841, 1, 0, 0.398318,-99) , 
3, -0.0725463, 0, 0, 0.467663,-99)    );
  // itree = 537
  fBoostWeights.push_back(0.236405);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.00978698, 0, 1, 0.713749,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355333,-99) , 
2, 1.21101, 1, 0, 0.513726,-99) , 
NN(
0, 
0, 
-1, -1.16007, 1, -1, 0.374995,-99) , 
3, -0.157414, 0, 0, 0.475969,-99) , 
0, -2.98925, 1, 0, 0.489447,-99)    );
  // itree = 538
  fBoostWeights.push_back(0.155955);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446925,-99) , 
1, 0.146089, 0, 0, 0.590341,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441526,-99) , 
1, -1.48631, 1, 0, 0.454754,-99) , 
2, -1.13202, 1, 0, 0.466977,-99) , 
3, 3.13521, 0, 0, 0.475358,-99)    );
  // itree = 539
  fBoostWeights.push_back(0.200826);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703803,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420275,-99) , 
0, -2.86574, 1, 0, 0.4345,-99) , 
3, 3.51517, 0, 0, 0.445741,-99) , 
2, -1.71417, 1, 0, 0.457946,-99)    );
  // itree = 540
  fBoostWeights.push_back(0.238892);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.528862, 0, 1, 0.684238,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37816,-99) , 
3, 0.55611, 0, 0, 0.48958,-99) , 
2, -0.605684, 1, 0, 0.514528,-99) , 
NN(
0, 
0, 
-1, -0.157641, 1, -1, 0.192652,-99) , 
3, -1.04575, 0, 0, 0.487613,-99)    );
  // itree = 541
  fBoostWeights.push_back(0.127261);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6635, 0, 1, 0.725139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441196,-99) , 
0, -0.846053, 0, 0, 0.612259,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346229,-99) , 
3, 2.61064, 1, 0, 0.626777,-99) , 
NN(
0, 
0, 
-1, 1.20428, 1, -1, 0.4674,-99) , 
3, 2.14907, 0, 0, 0.481291,-99) , 
1, 1.40358, 0, 0, 0.494721,-99)    );
  // itree = 542
  fBoostWeights.push_back(0.20987);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405994,-99) , 
3, -1.47042, 0, 0, 0.681273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58004,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412429,-99) , 
2, 1.89, 1, 0, 0.566572,-99) , 
0, -1.44156, 1, 0, 0.582999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316819,-99) , 
0, 4.0853, 1, 0, 0.572712,-99)    );
  // itree = 543
  fBoostWeights.push_back(0.147548);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480425,-99) , 
3, 1.53211, 0, 0, 0.675173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323555,-99) , 
3, 2.16818, 0, 0, 0.416715,-99) , 
1, -0.144516, 0, 0, 0.58473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498486,-99) , 
3, 1.05123, 0, 0, 0.51435,-99) , 
NN(
0, 
0, 
-1, 1.74326, 0, -1, 0.297423,-99) , 
0, 1.3716, 1, 0, 0.485449,-99) , 
3, 1.37242, 0, 0, 0.509253,-99)    );
  // itree = 544
  fBoostWeights.push_back(0.2455);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.00785681, 0, 1, 0.712374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41236,-99) , 
1, 0.0222933, 1, 0, 0.554387,-99) , 
1, 0.783756, 0, 0, 0.592095,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482525,-99) , 
0, 2.13411, 1, 0, 0.525762,-99) , 
NN(
0, 
0, 
-1, -0.229379, 0, -1, 0.269593,-99) , 
3, 1.28725, 0, 0, 0.453538,-99) , 
0, 1.20503, 1, 0, 0.545234,-99)    );
  // itree = 545
  fBoostWeights.push_back(0.18134);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.49868, 0, 1, 0.662384,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464209,-99) , 
3, 0.58973, 0, 0, 0.501954,-99) , 
1, -1.09418, 1, 0, 0.521695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290996,-99) , 
3, 2.23435, 0, 0, 0.397191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0663616,-99) , 
0, 4.60542, 1, 0, 0.356511,-99) , 
2, 1.34534, 1, 0, 0.48753,-99)    );
  // itree = 546
  fBoostWeights.push_back(0.311043);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.710786, 1, 1, 0.727895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664433,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430534,-99) , 
1, -0.917432, 0, 0, 0.625601,-99) , 
3, 0.0735584, 0, 0, 0.664224,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449004,-99) , 
0, 1.8184, 1, 0, 0.494437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246347,-99) , 
2, 0.399077, 0, 0, 0.453471,-99) , 
0, 1.19982, 1, 0, 0.585315,-99)    );
  // itree = 547
  fBoostWeights.push_back(0.252928);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.0504, 0, 1, 0.809296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412409,-99) , 
3, -0.995795, 0, 0, 0.570541,-99) , 
2, -0.195808, 0, 0, 0.631989,-99) , 
NN(
NN(
0, 
0, 
-1, 2.54929, 0, 1, 0.573905,-99) , 
NN(
0, 
0, 
-1, 0.10644, 0, -1, 0.34475,-99) , 
3, 0.64368, 0, 0, 0.495959,-99) , 
0, -0.416978, 1, 0, 0.534311,-99)    );
  // itree = 548
  fBoostWeights.push_back(0.228731);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.102, 1, 1, 0.611561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33355,-99) , 
3, -1.25035, 1, 0, 0.443191,-99) , 
3, -1.04758, 0, 0, 0.579167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398943,-99) , 
3, 3.33542, 0, 0, 0.426517,-99) , 
1, -1.2883, 1, 0, 0.457772,-99) , 
0, 1.12719, 1, 0, 0.532489,-99)    );
  // itree = 549
  fBoostWeights.push_back(0.241137);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406937,-99) , 
2, 0.691838, 0, 0, 0.607647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37444,-99) , 
3, 1.45677, 0, 0, 0.495979,-99) , 
3, 0.933718, 1, 0, 0.52433,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185406,-99) , 
2, -1.57914, 0, 0, 0.503753,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345472,-99) , 
3, -0.273398, 1, 0, 0.389428,-99) , 
2, -0.694055, 1, 0, 0.428581,-99) , 
2, 0.385083, 0, 0, 0.474864,-99)    );
  // itree = 550
  fBoostWeights.push_back(0.118795);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718578,-99) , 
NN(
0, 
0, 
-1, -0.795693, 0, -1, 0.464635,-99) , 
0, -1.74126, 1, 0, 0.476762,-99) , 
NN(
0, 
0, 
-1, -1.5413, 0, -1, 0.278508,-99) , 
0, -2.19565, 0, 0, 0.45999,-99)    );
  // itree = 551
  fBoostWeights.push_back(0.288166);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462882,-99) , 
3, -1.61487, 0, 0, 0.732255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395759,-99) , 
2, -1.00064, 1, 0, 0.656216,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231932,-99) , 
3, -0.47781, 0, 0, 0.537257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325535,-99) , 
0, -0.96531, 1, 0, 0.368156,-99) , 
1, 0.237261, 1, 0, 0.461009,-99) , 
2, -0.806007, 1, 0, 0.489424,-99)    );
  // itree = 552
  fBoostWeights.push_back(0.296571);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336775,-99) , 
3, 1.07187, 0, 0, 0.658788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339469,-99) , 
3, 3.298, 0, 0, 0.414127,-99) , 
0, 2.91629, 1, 0, 0.571703,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478123,-99) , 
1, 0.182851, 0, 0, 0.551086,-99) , 
NN(
0, 
0, 
-1, -0.0452558, 0, -1, 0.389425,-99) , 
3, -0.858582, 1, 0, 0.425851,-99) , 
3, 0.85485, 0, 0, 0.482146,-99)    );
  // itree = 553
  fBoostWeights.push_back(0.252663);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.68101, 1, 1, 0.650372,-99) , 
NN(
0, 
0, 
-1, -0.947948, 0, -1, 0.412633,-99) , 
3, -0.218528, 0, 0, 0.585457,-99) , 
NN(
NN(
0, 
0, 
-1, 0.142243, 0, 1, 0.579056,-99) , 
NN(
0, 
0, 
-1, 1.08268, 0, -1, 0.340112,-99) , 
3, 0.725852, 1, 0, 0.475784,-99) , 
1, 0.103994, 0, 0, 0.531366,-99)    );
  // itree = 554
  fBoostWeights.push_back(0.238004);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25774, 0, 1, 0.589503,-99) , 
NN(
0, 
0, 
-1, 1.62757, 0, -1, 0.382818,-99) , 
0, 1.39504, 1, 0, 0.51128,-99) , 
NN(
0, 
0, 
-1, 0.935246, 0, -1, 0.199791,-99) , 
2, -1.09454, 0, 0, 0.485104,-99)    );
  // itree = 555
  fBoostWeights.push_back(0.254742);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0869055, 1, 1, 0.783103,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292306,-99) , 
0, 0.425865, 1, 0, 0.540645,-99) , 
2, 0.117758, 0, 0, 0.577537,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438389,-99) , 
0, 2.25956, 1, 0, 0.509233,-99) , 
NN(
0, 
0, 
-1, -0.501383, 1, -1, 0.227256,-99) , 
3, 0.593848, 0, 0, 0.461415,-99) , 
2, 0.391241, 1, 0, 0.522021,-99)    );
  // itree = 556
  fBoostWeights.push_back(0.283311);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384184,-99) , 
3, 0.0649546, 0, 0, 0.622601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362124,-99) , 
3, 1.24167, 0, 0, 0.487416,-99) , 
0, 0.70387, 1, 0, 0.529477,-99) , 
NN(
0, 
0, 
-1, -0.86934, 1, -1, 0.351603,-99) , 
3, -0.117632, 0, 0, 0.470559,-99)    );
  // itree = 557
  fBoostWeights.push_back(0.176047);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.03347, 1, 1, 0.729573,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466314,-99) , 
2, -0.291482, 0, 0, 0.534212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379142,-99) , 
1, -0.226524, 1, 0, 0.429423,-99) , 
0, 0.557885, 1, 0, 0.488437,-99) , 
3, 2.7172, 0, 0, 0.504482,-99)    );
  // itree = 558
  fBoostWeights.push_back(0.221242);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.462012, 1, 1, 0.590957,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390115,-99) , 
3, -0.480257, 0, 0, 0.455757,-99) , 
3, -0.218528, 0, 0, 0.549174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142948,-99) , 
1, 1.94792, 1, 0, 0.538661,-99)    );
  // itree = 559
  fBoostWeights.push_back(0.137593);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.545061, 0, 1, 0.579241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30166,-99) , 
3, -0.118683, 0, 0, 0.486846,-99) , 
0, -1.07509, 1, 0, 0.505454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188557,-99) , 
0, 4.5045, 1, 0, 0.489953,-99)    );
  // itree = 560
  fBoostWeights.push_back(0.215312);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493601,-99) , 
3, 0.562906, 0, 0, 0.646514,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381244,-99) , 
3, 1.64107, 0, 0, 0.441121,-99) , 
0, 0.777339, 1, 0, 0.47805,-99) , 
NN(
0, 
0, 
-1, -0.555589, 1, -1, 0.381393,-99) , 
3, 0.191234, 0, 0, 0.437101,-99)    );
  // itree = 561
  fBoostWeights.push_back(0.22015);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.682486, 0, 1, 0.624254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298346,-99) , 
3, 1.04678, 1, 0, 0.481322,-99) , 
1, 0.0932693, 0, 0, 0.550377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688987,-99) , 
NN(
0, 
0, 
-1, 2.18961, 0, -1, 0.336187,-99) , 
0, 1.11136, 1, 0, 0.388193,-99) , 
2, 0.983024, 1, 0, 0.505362,-99)    );
  // itree = 562
  fBoostWeights.push_back(0.222729);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304293,-99) , 
3, -1.70587, 0, 0, 0.678433,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399108,-99) , 
3, 2.45184, 1, 0, 0.548228,-99) , 
NN(
0, 
0, 
-1, 0.581975, 1, -1, 0.419709,-99) , 
3, 1.182, 0, 0, 0.466052,-99) , 
0, -2.03899, 1, 0, 0.485686,-99)    );
  // itree = 563
  fBoostWeights.push_back(0.191477);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.648124, 1, 1, 0.807505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350292,-99) , 
3, -1.52303, 0, 0, 0.747559,-99) , 
NN(
NN(
0, 
0, 
-1, 1.94715, 1, 1, 0.573508,-99) , 
NN(
0, 
0, 
-1, 1.25868, 1, -1, 0.463564,-99) , 
3, 1.48643, 0, 0, 0.494003,-99) , 
2, -0.471788, 1, 0, 0.544569,-99)    );
  // itree = 564
  fBoostWeights.push_back(0.232088);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451941,-99) , 
1, -0.0879881, 0, 0, 0.685516,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461239,-99) , 
0, -0.525319, 1, 0, 0.510298,-99) , 
0, 1.15448, 0, 0, 0.531944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275266,-99) , 
3, 1.37099, 1, 0, 0.317921,-99) , 
3, 3.34156, 0, 0, 0.359862,-99) , 
0, 1.63045, 1, 0, 0.477258,-99)    );
  // itree = 565
  fBoostWeights.push_back(0.269189);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04751, 0, 1, 0.634766,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390753,-99) , 
2, 0.988541, 1, 0, 0.446626,-99) , 
0, 1.53415, 1, 0, 0.534074,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425485,-99) , 
1, 1.28028, 0, 0, 0.478838,-99) , 
NN(
0, 
0, 
-1, 0.0166093, 0, -1, 0.306518,-99) , 
2, -0.517979, 1, 0, 0.387231,-99) , 
3, 0.125502, 0, 0, 0.473158,-99)    );
  // itree = 566
  fBoostWeights.push_back(0.221387);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453235,-99) , 
2, -0.0761705, 1, 0, 0.544291,-99) , 
NN(
0, 
0, 
-1, 1.37862, 0, -1, 0.399356,-99) , 
1, 0.992459, 1, 0, 0.517527,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340956,-99) , 
1, -0.368266, 0, 0, 0.491353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237569,-99) , 
2, 0.782379, 1, 0, 0.342583,-99) , 
2, 1.30452, 0, 0, 0.406563,-99) , 
2, 0.462259, 1, 0, 0.462652,-99)    );
  // itree = 567
  fBoostWeights.push_back(0.189263);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496399,-99) , 
3, -0.215737, 0, 0, 0.567897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409022,-99) , 
3, 1.47081, 0, 0, 0.447675,-99) , 
2, -0.342594, 1, 0, 0.487458,-99) , 
NN(
0, 
0, 
-1, 3.09094, 0, -1, 0.258096,-99) , 
0, 3.54173, 1, 0, 0.469847,-99)    );
  // itree = 568
  fBoostWeights.push_back(0.286499);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.429534, 1, 1, 0.616543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330963,-99) , 
1, 1.49164, 0, 0, 0.445401,-99) , 
2, -1.0368, 0, 0, 0.588064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338488,-99) , 
3, 2.9214, 0, 0, 0.392799,-99) , 
3, 1.32702, 1, 0, 0.44876,-99) , 
0, 1.82152, 1, 0, 0.551708,-99)    );
  // itree = 569
  fBoostWeights.push_back(0.265467);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.956577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482754,-99) , 
3, -0.260964, 0, 0, 0.733923,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354926,-99) , 
3, -1.17356, 0, 0, 0.573923,-99) , 
1, -0.796883, 1, 0, 0.601001,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353133,-99) , 
2, 1.46604, 0, 0, 0.544331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224512,-99) , 
1, -0.73929, 0, 0, 0.457602,-99) , 
2, 1.20333, 1, 0, 0.569919,-99)    );
  // itree = 570
  fBoostWeights.push_back(0.188981);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486844,-99) , 
1, -1.07665, 1, 0, 0.615449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367725,-99) , 
1, -1.66933, 0, 0, 0.561189,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380484,-99) , 
2, 0.456587, 1, 0, 0.450936,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15308,-99) , 
1, -0.599097, 0, 0, 0.265353,-99) , 
1, -0.515634, 0, 0, 0.429193,-99) , 
1, -0.715629, 1, 0, 0.451426,-99)    );
  // itree = 571
  fBoostWeights.push_back(0.166057);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492806,-99) , 
3, 1.9025, 0, 0, 0.51728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324332,-99) , 
2, 0.894242, 0, 0, 0.400107,-99) , 
1, 0.501006, 1, 0, 0.475794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
0, 4.79583, 1, 0, 0.462175,-99)    );
  // itree = 572
  fBoostWeights.push_back(0.35697);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.238477, 0, 1, 0.641296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400183,-99) , 
1, -0.700158, 1, 0, 0.513993,-99) , 
2, 0.521751, 1, 0, 0.589867,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33336,-99) , 
2, 0.558882, 0, 0, 0.450179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.135883,-99) , 
0, 3.021, 1, 0, 0.415725,-99) , 
1, 0.387754, 1, 0, 0.520443,-99)    );
  // itree = 573
  fBoostWeights.push_back(0.203187);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901936,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442433,-99) , 
3, -1.24585, 0, 0, 0.702109,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454474,-99) , 
1, -0.751023, 1, 0, 0.49198,-99) , 
NN(
0, 
0, 
-1, -1.05996, 1, -1, 0.290758,-99) , 
3, -0.47879, 0, 0, 0.471133,-99) , 
0, -1.99797, 1, 0, 0.496115,-99)    );
  // itree = 574
  fBoostWeights.push_back(0.235927);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402753,-99) , 
3, -1.23319, 0, 0, 0.57244,-99) , 
NN(
0, 
0, 
-1, 0.523093, 1, -1, 0.317276,-99) , 
1, 1.60105, 1, 0, 0.552685,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166112,-99) , 
2, 2.2589, 0, 0, 0.362779,-99) , 
2, 1.82406, 1, 0, 0.529799,-99)    );
  // itree = 575
  fBoostWeights.push_back(0.222438);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.326993, 0, 1, 0.592942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206196,-99) , 
1, 1.57547, 1, 0, 0.568339,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426175,-99) , 
3, 1.77677, 0, 0, 0.480345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280828,-99) , 
0, 3.77306, 1, 0, 0.461558,-99) , 
0, 0.540177, 1, 0, 0.515484,-99)    );
  // itree = 576
  fBoostWeights.push_back(0.316075);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329024,-99) , 
0, 0.0355056, 0, 0, 0.596621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21104,-99) , 
0, 4.58316, 1, 0, 0.572893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295537,-99) , 
2, -1.37109, 1, 0, 0.349666,-99) , 
1, -0.981759, 1, 0, 0.375275,-99) , 
3, 0.179643, 0, 0, 0.493855,-99)    );
  // itree = 577
  fBoostWeights.push_back(0.19856);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.00667436, 1, 1, 0.594298,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320423,-99) , 
0, -1.06362, 1, 0, 0.470184,-99) , 
3, -0.430308, 0, 0, 0.537375,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626275,-99) , 
NN(
0, 
0, 
-1, 0.862961, 1, -1, 0.381837,-99) , 
1, 1.48967, 0, 0, 0.397339,-99) , 
2, 0.462259, 1, 0, 0.470078,-99)    );
  // itree = 578
  fBoostWeights.push_back(0.227023);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398336,-99) , 
1, -0.365486, 1, 0, 0.515261,-99) , 
2, -0.306105, 0, 0, 0.569025,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427914,-99) , 
2, 0.760653, 1, 0, 0.496497,-99) , 
NN(
0, 
0, 
-1, -0.654053, 1, -1, 0.245659,-99) , 
3, -0.249607, 0, 0, 0.464896,-99) , 
0, -1.0528, 1, 0, 0.487079,-99)    );
  // itree = 579
  fBoostWeights.push_back(0.238113);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.03131, 1, 1, 0.73803,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208924,-99) , 
0, 1.98906, 1, 0, 0.509907,-99) , 
2, 1.38996, 0, 0, 0.561639,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420825,-99) , 
2, 0.514398, 0, 0, 0.518271,-99) , 
NN(
0, 
0, 
-1, 0.359132, 1, -1, 0.356463,-99) , 
1, 0.548395, 0, 0, 0.445621,-99) , 
1, -0.11574, 1, 0, 0.49878,-99)    );
  // itree = 580
  fBoostWeights.push_back(0.257481);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.616241, 0, 1, 0.755463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384655,-99) , 
0, 1.47415, 1, 0, 0.613429,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385758,-99) , 
1, -0.352128, 0, 0, 0.502439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.130916,-99) , 
0, -0.186288, 1, 0, 0.367177,-99) , 
2, -0.00680894, 0, 0, 0.45367,-99) , 
1, 1.12536, 0, 0, 0.475853,-99)    );
  // itree = 581
  fBoostWeights.push_back(0.145113);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0520706, 0, 1, 0.638423,-99) , 
NN(
0, 
0, 
-1, 1.27844, 1, -1, 0.47619,-99) , 
3, 1.03672, 0, 0, 0.501426,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726622,-99) , 
NN(
0, 
0, 
-1, 2.14878, 0, -1, 0.337572,-99) , 
1, -0.793365, 1, 0, 0.380661,-99) , 
3, 1.74472, 1, 0, 0.472709,-99)    );
  // itree = 582
  fBoostWeights.push_back(0.187474);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769488,-99) , 
NN(
NN(
0, 
0, 
-1, 1.59764, 1, 1, 0.644322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400552,-99) , 
1, -0.0856835, 1, 0, 0.477062,-99) , 
1, 1.40835, 0, 0, 0.492046,-99) , 
1, -1.73018, 1, 0, 0.499601,-99)    );
  // itree = 583
  fBoostWeights.push_back(0.278419);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.33006, 1, 1, 0.708899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308211,-99) , 
0, 3.5848, 1, 0, 0.615692,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412471,-99) , 
2, -0.670075, 1, 0, 0.457212,-99) , 
NN(
0, 
0, 
-1, -0.370927, 0, -1, 0.246983,-99) , 
2, -1.33131, 0, 0, 0.435745,-99) , 
0, 1.92129, 0, 0, 0.478147,-99)    );
  // itree = 584
  fBoostWeights.push_back(0.164607);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478082,-99) , 
2, 0.570404, 1, 0, 0.684751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38544,-99) , 
3, 0.179643, 0, 0, 0.467832,-99) , 
1, -0.988276, 1, 0, 0.493954,-99) , 
NN(
0, 
0, 
-1, 1.214, 1, -1, 0.26854,-99) , 
1, -1.52075, 0, 0, 0.47745,-99)    );
  // itree = 585
  fBoostWeights.push_back(0.244313);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482544,-99) , 
0, 0.853092, 0, 0, 0.664613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329259,-99) , 
2, 1.67306, 1, 0, 0.474725,-99) , 
1, -1.10448, 1, 0, 0.508952,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384005,-99) , 
0, -0.761078, 1, 0, 0.498163,-99) , 
NN(
0, 
0, 
-1, -1.38303, 1, -1, 0.266249,-99) , 
1, -0.424961, 0, 0, 0.422307,-99) , 
2, 0.23429, 0, 0, 0.468116,-99)    );
  // itree = 586
  fBoostWeights.push_back(0.182545);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744129,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455851,-99) , 
1, 0.993633, 0, 0, 0.513376,-99) , 
0, -0.761078, 0, 0, 0.591124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445735,-99) , 
3, 2.1131, 0, 0, 0.469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190738,-99) , 
0, 4.5375, 1, 0, 0.456391,-99) , 
2, -0.471788, 1, 0, 0.491669,-99)    );
  // itree = 587
  fBoostWeights.push_back(0.250729);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.581975, 1, 1, 0.661895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367742,-99) , 
1, -0.420956, 0, 0, 0.473173,-99) , 
0, 1.57169, 1, 0, 0.574933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50859,-99) , 
NN(
0, 
0, 
-1, -1.06529, 0, -1, 0.207945,-99) , 
2, -1.27611, 1, 0, 0.321743,-99) , 
3, -0.707817, 0, 0, 0.536424,-99)    );
  // itree = 588
  fBoostWeights.push_back(0.232636);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.1042, 0, 1, 0.719524,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522728,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.108463,-99) , 
0, 3.11626, 1, 0, 0.48571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266585,-99) , 
2, -1.20207, 1, 0, 0.344652,-99) , 
3, 0.0244988, 0, 0, 0.434242,-99) , 
3, 2.75132, 0, 0, 0.450918,-99)    );
  // itree = 589
  fBoostWeights.push_back(0.231872);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803097,-99) , 
NN(
0, 
0, 
-1, 1.25419, 1, -1, 0.425616,-99) , 
0, -0.315992, 1, 0, 0.454507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233576,-99) , 
0, -3.17619, 0, 0, 0.44789,-99) , 
NN(
0, 
0, 
-1, -0.256974, 0, -1, 0.268968,-99) , 
2, -0.884623, 1, 0, 0.348635,-99) , 
3, -0.218528, 0, 0, 0.418474,-99)    );
  // itree = 590
  fBoostWeights.push_back(0.269397);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448004,-99) , 
0, 1.38826, 1, 0, 0.656669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.116361,-99) , 
1, -0.370927, 1, 0, 0.312261,-99) , 
2, -1.4329, 0, 0, 0.617398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795965,-99) , 
NN(
0, 
0, 
-1, 4.42973, 1, -1, 0.416582,-99) , 
3, 3.78565, 0, 0, 0.435185,-99) , 
2, 0.426911, 1, 0, 0.522047,-99)    );
  // itree = 591
  fBoostWeights.push_back(0.19677);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430099,-99) , 
3, 0.240877, 0, 0, 0.531094,-99) , 
2, -1.18072, 1, 0, 0.544112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174509,-99) , 
3, -1.51856, 0, 0, 0.53256,-99)    );
  // itree = 592
  fBoostWeights.push_back(0.268309);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302154,-99) , 
2, 2.41544, 1, 0, 0.590833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263025,-99) , 
0, -2.63315, 0, 0, 0.576227,-99) , 
NN(
NN(
0, 
0, 
-1, 1.08144, 1, 1, 0.624546,-99) , 
NN(
0, 
0, 
-1, 1.2751, 1, -1, 0.308424,-99) , 
0, 0.18515, 1, 0, 0.402951,-99) , 
1, 0.718787, 1, 0, 0.528085,-99)    );
  // itree = 593
  fBoostWeights.push_back(0.248451);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.287847, 0, 1, 0.733808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408011,-99) , 
1, -1.34376, 1, 0, 0.655285,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334535,-99) , 
0, -1.59795, 0, 0, 0.56157,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330727,-99) , 
3, 0.5491, 1, 0, 0.41878,-99) , 
1, 0.0949316, 0, 0, 0.501291,-99) , 
1, -1.1416, 1, 0, 0.524819,-99)    );
  // itree = 594
  fBoostWeights.push_back(0.210018);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.00923, 0, 1, 0.662204,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217295,-99) , 
1, 0.51027, 1, 0, 0.46652,-99) , 
0, 3.05319, 1, 0, 0.564943,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460073,-99) , 
3, 0.924565, 0, 0, 0.483076,-99) , 
NN(
0, 
0, 
-1, 0.134395, 1, -1, 0.311429,-99) , 
0, 1.42743, 1, 0, 0.448256,-99) , 
3, 1.57563, 0, 0, 0.472212,-99)    );
  // itree = 595
  fBoostWeights.push_back(0.213873);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93521, 0, 1, 0.592358,-99) , 
NN(
0, 
0, 
-1, -1.70791, 0, -1, 0.371909,-99) , 
3, -1.09857, 0, 0, 0.571322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528078,-99) , 
NN(
0, 
0, 
-1, 3.1138, 1, -1, 0.252728,-99) , 
2, 2.29078, 0, 0, 0.342592,-99) , 
2, 1.67015, 1, 0, 0.543957,-99)    );
  // itree = 596
  fBoostWeights.push_back(0.259311);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.878709, 1, 1, 0.727154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258404,-99) , 
3, 1.19411, 0, 0, 0.479524,-99) , 
0, 1.34735, 1, 0, 0.53913,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467486,-99) , 
3, -1.15327, 0, 0, 0.620188,-99) , 
NN(
0, 
0, 
-1, -0.446149, 0, -1, 0.379863,-99) , 
2, -1.03785, 1, 0, 0.429621,-99) , 
3, 0.609067, 0, 0, 0.473998,-99)    );
  // itree = 597
  fBoostWeights.push_back(0.178056);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.68658, 1, 1, 0.585572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340315,-99) , 
1, 0.585086, 1, 0, 0.476407,-99) , 
3, 0.256412, 0, 0, 0.534035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0945364,-99) , 
1, 2.11264, 1, 0, 0.521042,-99)    );
  // itree = 598
  fBoostWeights.push_back(0.166911);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.472426, 1, 1, 0.571149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281103,-99) , 
1, -0.584023, 0, 0, 0.430819,-99) , 
3, 0.356052, 0, 0, 0.503078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.071668,-99) , 
0, 4.44906, 1, 0, 0.491774,-99)    );
  // itree = 599
  fBoostWeights.push_back(0.186962);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.209783, 1, 1, 0.542001,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366739,-99) , 
0, -1.2457, 1, 0, 0.428489,-99) , 
3, 0.0499995, 0, 0, 0.495715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721577,-99) , 
NN(
0, 
0, 
-1, 2.2623, 0, -1, 0.289108,-99) , 
1, -0.654166, 1, 0, 0.346888,-99) , 
3, 1.72681, 1, 0, 0.464548,-99)    );
  // itree = 600
  fBoostWeights.push_back(0.319592);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495924,-99) , 
1, -1.40195, 0, 0, 0.618539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328983,-99) , 
1, -0.697145, 0, 0, 0.478643,-99) , 
1, -1.1429, 1, 0, 0.555471,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421014,-99) , 
3, -0.105073, 0, 0, 0.490577,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290874,-99) , 
3, 2.44454, 0, 0, 0.32825,-99) , 
0, 0.206177, 1, 0, 0.387383,-99) , 
1, -0.589204, 1, 0, 0.433266,-99)    );
  // itree = 601
  fBoostWeights.push_back(0.170517);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21528, 1, 1, 0.676931,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271839,-99) , 
1, 1.41277, 1, 0, 0.503976,-99) , 
2, 0.863407, 0, 0, 0.539043,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171662,-99) , 
1, 1.24864, 1, 0, 0.443557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0714715,-99) , 
1, -0.647584, 0, 0, 0.38385,-99) , 
0, 2.56595, 1, 0, 0.504494,-99)    );
  // itree = 602
  fBoostWeights.push_back(0.297294);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0700677, 1, 1, 0.658346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289517,-99) , 
2, -0.739557, 1, 0, 0.437935,-99) , 
3, -0.426037, 0, 0, 0.531511,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395973,-99) , 
2, 1.75434, 0, 0, 0.426649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13213,-99) , 
3, 3.30892, 0, 0, 0.255852,-99) , 
0, 3.20229, 1, 0, 0.393176,-99) , 
0, 0.435941, 1, 0, 0.451621,-99)    );
  // itree = 603
  fBoostWeights.push_back(0.165186);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404106,-99) , 
1, -0.539168, 0, 0, 0.521522,-99) , 
1, -1.40344, 1, 0, 0.536116,-99) , 
NN(
0, 
0, 
-1, 2.94501, 1, -1, 0.37979,-99) , 
0, 2.50199, 1, 0, 0.507013,-99)    );
  // itree = 604
  fBoostWeights.push_back(0.22284);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497099,-99) , 
3, 1.86922, 1, 0, 0.709902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325763,-99) , 
2, 0.158308, 0, 0, 0.5182,-99) , 
1, 1.48178, 1, 0, 0.631635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485465,-99) , 
1, -1.12701, 1, 0, 0.512696,-99) , 
NN(
0, 
0, 
-1, 0.638656, 0, -1, 0.169457,-99) , 
1, 0.666234, 1, 0, 0.452921,-99) , 
1, 1.03461, 0, 0, 0.485312,-99)    );
  // itree = 605
  fBoostWeights.push_back(0.248768);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.38453, 0, 1, 0.735348,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451053,-99) , 
2, 0.0817685, 1, 0, 0.513238,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335121,-99) , 
2, 1.46843, 0, 0, 0.364819,-99) , 
1, -0.125008, 1, 0, 0.425636,-99) , 
0, -2.54258, 1, 0, 0.443176,-99)    );
  // itree = 606
  fBoostWeights.push_back(0.150352);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375357,-99) , 
2, 0.863656, 1, 0, 0.467526,-99) , 
1, 1.83326, 0, 0, 0.478032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220618,-99) , 
1, 2.37972, 1, 0, 0.462307,-99)    );
  // itree = 607
  fBoostWeights.push_back(0.0847541);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.06804, 0, 1, 0.521176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.087513,-99) , 
0, 4.79907, 1, 0, 0.508775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.11173,-99) , 
0, -3.33298, 0, 0, 0.49772,-99)    );
  // itree = 608
  fBoostWeights.push_back(0.32088);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.012855, 0, 1, 0.708724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266248,-99) , 
1, -0.72544, 1, 0, 0.433375,-99) , 
1, -0.354418, 0, 0, 0.532264,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387169,-99) , 
1, 1.01865, 0, 0, 0.470305,-99) , 
NN(
0, 
0, 
-1, 0.800687, 0, -1, 0.301608,-99) , 
2, 0.456587, 1, 0, 0.377393,-99) , 
1, 0.0705562, 1, 0, 0.443492,-99)    );
  // itree = 609
  fBoostWeights.push_back(0.217071);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418313,-99) , 
1, -0.133281, 1, 0, 0.474246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.75765, 0, 0, 0.4582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.113293,-99) , 
2, 2.25816, 1, 0, 0.439098,-99)    );
  // itree = 610
  fBoostWeights.push_back(0.370293);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390375,-99) , 
2, -0.29996, 0, 0, 0.607644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228456,-99) , 
3, 1.49702, 0, 0, 0.457754,-99) , 
0, 1.44, 1, 0, 0.532985,-99) , 
NN(
NN(
0, 
0, 
-1, 0.37658, 0, 1, 0.654633,-99) , 
NN(
0, 
0, 
-1, -0.668255, 0, -1, 0.185023,-99) , 
0, -2.02207, 1, 0, 0.342192,-99) , 
2, -0.86672, 0, 0, 0.499961,-99)    );
  // itree = 611
  fBoostWeights.push_back(0.165176);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45842,-99) , 
3, -0.109394, 0, 0, 0.528398,-99) , 
NN(
0, 
0, 
-1, 0.794829, 0, -1, 0.440955,-99) , 
2, 0.259919, 1, 0, 0.481898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -2.17568, 0, 0, 0.46897,-99)    );
  // itree = 612
  fBoostWeights.push_back(0.34141);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.753406, 1, 1, 0.756846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328156,-99) , 
0, -1.99505, 1, 0, 0.421907,-99) , 
2, -0.812305, 0, 0, 0.567914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382006,-99) , 
3, 0.498006, 1, 0, 0.434065,-99) , 
NN(
0, 
0, 
-1, -0.366279, 0, -1, 0.320642,-99) , 
3, 0.281624, 0, 0, 0.404881,-99) , 
2, -0.351252, 1, 0, 0.45149,-99)    );
  // itree = 613
  fBoostWeights.push_back(0.232598);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408509,-99) , 
2, 1.54775, 1, 0, 0.582689,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168993,-99) , 
0, 0.885954, 1, 0, 0.462661,-99) , 
3, 0.942652, 0, 0, 0.512481,-99) , 
NN(
0, 
0, 
-1, -2.70079, 1, -1, 0.187883,-99) , 
3, -1.26544, 0, 0, 0.487138,-99)    );
  // itree = 614
  fBoostWeights.push_back(0.134199);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.44863, 1, 1, 0.767771,-99) , 
NN(
0, 
0, 
-1, 2.21491, 1, -1, 0.458757,-99) , 
3, 2.20609, 0, 0, 0.478974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200592,-99) , 
0, 3.94904, 1, 0, 0.466807,-99)    );
  // itree = 615
  fBoostWeights.push_back(0.20849);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20009, 1, 1, 0.626608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297783,-99) , 
0, 1.0548, 1, 0, 0.498511,-99) , 
3, 1.05038, 0, 0, 0.545482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208155,-99) , 
3, -1.55736, 0, 0, 0.5349,-99)    );
  // itree = 616
  fBoostWeights.push_back(0.13976);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488539,-99) , 
0, 1.99974, 0, 0, 0.518497,-99) , 
NN(
0, 
0, 
-1, 2.21506, 0, -1, 0.313347,-99) , 
0, 2.92135, 1, 0, 0.491916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.120947,-99) , 
3, -1.62852, 0, 0, 0.477935,-99)    );
  // itree = 617
  fBoostWeights.push_back(0.0770041);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288383,-99) , 
1, 1.78879, 1, 0, 0.49541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227386,-99) , 
0, 4.46416, 1, 0, 0.486586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0678031,-99) , 
3, -1.49662, 0, 0, 0.474974,-99)    );
  // itree = 618
  fBoostWeights.push_back(0.214905);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487448,-99) , 
3, 0.698398, 0, 0, 0.568604,-99) , 
NN(
0, 
0, 
-1, 3.01804, 0, -1, 0.324997,-99) , 
0, 3.25936, 1, 0, 0.537415,-99) , 
NN(
0, 
0, 
-1, -0.449377, 0, -1, 0.337188,-99) , 
2, -0.433831, 0, 0, 0.496975,-99)    );
  // itree = 619
  fBoostWeights.push_back(0.158656);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.99601, 0, 1, 0.545811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292451,-99) , 
3, 2.73303, 0, 0, 0.416053,-99) , 
2, 1.59646, 1, 0, 0.525841,-99) , 
NN(
0, 
0, 
-1, -2.2982, 1, -1, 0.222561,-99) , 
2, -1.18993, 0, 0, 0.502376,-99)    );
  // itree = 620
  fBoostWeights.push_back(0.244852);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.581534, 0, 1, 0.603088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374544,-99) , 
2, -1.30812, 1, 0, 0.470149,-99) , 
1, 0.879524, 1, 0, 0.558397,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460511,-99) , 
1, -1.57033, 1, 0, 0.624024,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377135,-99) , 
3, 2.32842, 0, 0, 0.409579,-99) , 
1, -1.17388, 1, 0, 0.437171,-99) , 
2, -0.351925, 1, 0, 0.474391,-99)    );
  // itree = 621
  fBoostWeights.push_back(0.199178);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.309109, 1, 1, 0.661521,-99) , 
NN(
0, 
0, 
-1, 1.40096, 1, -1, 0.45598,-99) , 
2, 0.46458, 0, 0, 0.531032,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304159,-99) , 
1, 0.0241522, 0, 0, 0.423962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156987,-99) , 
3, 2.3352, 0, 0, 0.350378,-99) , 
0, 2.97343, 1, 0, 0.506703,-99)    );
  // itree = 622
  fBoostWeights.push_back(0.297112);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300766,-99) , 
2, -2.02045, 0, 0, 0.581837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281888,-99) , 
1, -1.52075, 0, 0, 0.558388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369663,-99) , 
1, 0.287506, 0, 0, 0.499579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232633,-99) , 
1, -1.13697, 1, 0, 0.275271,-99) , 
0, 1.91473, 1, 0, 0.336483,-99) , 
0, 1.38601, 1, 0, 0.477754,-99)    );
  // itree = 623
  fBoostWeights.push_back(0.12281);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478215,-99) , 
1, 1.25419, 0, 0, 0.497566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207501,-99) , 
0, 4.34914, 1, 0, 0.485983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172462,-99) , 
2, -1.7549, 0, 0, 0.470055,-99)    );
  // itree = 624
  fBoostWeights.push_back(0.208259);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.05528, 1, 1, 0.573218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264363,-99) , 
0, 4.55447, 1, 0, 0.560731,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254608,-99) , 
1, -0.272567, 1, 0, 0.433797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0200195,-99) , 
1, -1.13021, 0, 0, 0.334554,-99) , 
3, -1.15439, 0, 0, 0.536403,-99)    );
  // itree = 625
  fBoostWeights.push_back(0.191871);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420775,-99) , 
3, -0.0661167, 0, 0, 0.494826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216481,-99) , 
1, 1.54066, 1, 0, 0.302495,-99) , 
1, 1.2714, 1, 0, 0.471193,-99) , 
NN(
0, 
0, 
-1, 3.17048, 1, -1, 0.118491,-99) , 
3, 2.62224, 1, 0, 0.453451,-99)    );
  // itree = 626
  fBoostWeights.push_back(0.285066);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330698,-99) , 
0, 0.0771149, 1, 0, 0.559351,-99) , 
NN(
0, 
0, 
-1, -0.88033, 0, -1, 0.417176,-99) , 
3, -0.420898, 0, 0, 0.484484,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371911,-99) , 
0, 1.78966, 1, 0, 0.43043,-99) , 
NN(
0, 
0, 
-1, 0.882675, 1, -1, 0.272174,-99) , 
3, 0.872223, 0, 0, 0.37635,-99) , 
0, 0.394028, 1, 0, 0.429732,-99)    );
  // itree = 627
  fBoostWeights.push_back(0.284948);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.253871, 0, 1, 0.570718,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298816,-99) , 
1, -1.26858, 1, 0, 0.407973,-99) , 
1, -0.605346, 0, 0, 0.525338,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.103037,-99) , 
0, 4.42491, 1, 0, 0.524189,-99) , 
NN(
0, 
0, 
-1, 0.649644, 1, -1, 0.292408,-99) , 
3, 1.98446, 0, 0, 0.366505,-99) , 
0, 0.749055, 1, 0, 0.457493,-99)    );
  // itree = 628
  fBoostWeights.push_back(0.15326);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482176,-99) , 
2, -1.65279, 0, 0, 0.604656,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452083,-99) , 
3, 1.49562, 0, 0, 0.486905,-99) , 
0, -2.03899, 1, 0, 0.501644,-99) , 
NN(
0, 
0, 
-1, -0.967242, 0, -1, 0.284594,-99) , 
1, 1.60105, 1, 0, 0.485127,-99)    );
  // itree = 629
  fBoostWeights.push_back(0.177765);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16754, 0, 1, 0.552113,-99) , 
NN(
0, 
0, 
-1, 1.08113, 0, -1, 0.370358,-99) , 
1, 0.882798, 1, 0, 0.515104,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16018,-99) , 
0, 3.93825, 1, 0, 0.414567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212218,-99) , 
3, 1.83025, 0, 0, 0.355602,-99) , 
0, 2.01604, 1, 0, 0.473648,-99)    );
  // itree = 630
  fBoostWeights.push_back(0.174859);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.746989, 0, 1, 0.808261,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484816,-99) , 
1, -1.90873, 1, 0, 0.499471,-99) , 
0, -1.18954, 1, 0, 0.534729,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318745,-99) , 
2, -1.64325, 0, 0, 0.501356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.116524,-99) , 
2, -1.06848, 1, 0, 0.332246,-99) , 
2, -0.861796, 0, 0, 0.506558,-99)    );
  // itree = 631
  fBoostWeights.push_back(0.186502);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0761344, 0, 1, 0.771198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451683,-99) , 
2, 0.604845, 1, 0, 0.525734,-99) , 
NN(
0, 
0, 
-1, -2.00339, 1, -1, 0.29252,-99) , 
3, -0.963363, 0, 0, 0.506539,-99) , 
0, -2.89816, 1, 0, 0.521539,-99)    );
  // itree = 632
  fBoostWeights.push_back(0.215545);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.486314, 1, 1, 0.762722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191683,-99) , 
2, 2.42552, 1, 0, 0.50913,-99) , 
2, -0.092879, 1, 0, 0.55198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415826,-99) , 
0, -2.7208, 1, 0, 0.496721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219747,-99) , 
0, -0.803435, 1, 0, 0.429181,-99) , 
3, -0.12622, 0, 0, 0.509175,-99)    );
  // itree = 633
  fBoostWeights.push_back(0.253389);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6885, 0, 1, 0.581489,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234512,-99) , 
3, 3.07466, 0, 0, 0.402078,-99) , 
0, 3.03753, 1, 0, 0.547914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35621,-99) , 
2, -0.718704, 0, 0, 0.445504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139692,-99) , 
0, -0.0365427, 1, 0, 0.399228,-99) , 
3, 0.116464, 0, 0, 0.48323,-99)    );
  // itree = 634
  fBoostWeights.push_back(0.247865);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394185,-99) , 
0, 3.0443, 1, 0, 0.522876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3415,-99) , 
3, 0.89916, 0, 0, 0.397989,-99) , 
1, -0.11574, 0, 0, 0.461812,-99) , 
NN(
0, 
0, 
-1, 1.28903, 0, -1, 0.218359,-99) , 
2, -0.86672, 0, 0, 0.422085,-99)    );
  // itree = 635
  fBoostWeights.push_back(0.18439);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.186504, 0, 1, 0.601032,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426292,-99) , 
0, -0.0459027, 1, 0, 0.451024,-99) , 
0, -0.805919, 1, 0, 0.483005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.105108,-99) , 
3, -1.56789, 0, 0, 0.470186,-99)    );
  // itree = 636
  fBoostWeights.push_back(0.156017);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.36156, 1, 1, 0.792242,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352107,-99) , 
0, 2.08435, 1, 0, 0.505498,-99) , 
3, 2.175, 0, 0, 0.52453,-99) , 
NN(
0, 
0, 
-1, 2.94333, 0, -1, 0.206986,-99) , 
0, 3.94904, 1, 0, 0.505046,-99)    );
  // itree = 637
  fBoostWeights.push_back(0.129619);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.999978, 1, 1, 0.715515,-99) , 
NN(
0, 
0, 
-1, 2.46294, 1, -1, 0.477928,-99) , 
1, -0.919085, 1, 0, 0.510932,-99) , 
NN(
0, 
0, 
-1, -0.970341, 1, -1, 0.305768,-99) , 
0, -2.09317, 0, 0, 0.489036,-99)    );
  // itree = 638
  fBoostWeights.push_back(0.129875);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457487,-99) , 
2, 0.0721134, 1, 0, 0.490206,-99) , 
1, -1.76123, 1, 0, 0.500429,-99) , 
NN(
0, 
0, 
-1, 0.431041, 0, -1, 0.269639,-99) , 
1, 1.73495, 1, 0, 0.479396,-99)    );
  // itree = 639
  fBoostWeights.push_back(0.099631);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.45771, 1, 1, 0.542363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164277,-99) , 
3, -1.99592, 0, 0, 0.53297,-99)    );
  // itree = 640
  fBoostWeights.push_back(0.31571);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.44479, 0, 1, 0.764363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376589,-99) , 
2, 1.01709, 1, 0, 0.620692,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.952842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428455,-99) , 
3, 1.29329, 1, 0, 0.509692,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29915,-99) , 
2, -0.712156, 1, 0, 0.366061,-99) , 
3, 1.12461, 0, 0, 0.409101,-99) , 
1, -1.02741, 1, 0, 0.437725,-99)    );
  // itree = 641
  fBoostWeights.push_back(0.270755);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.520581, 1, 1, 0.715842,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276264,-99) , 
3, 1.30975, 0, 0, 0.430631,-99) , 
0, 0.905154, 1, 0, 0.471838,-99) , 
NN(
0, 
0, 
-1, -0.111733, 1, -1, 0.326406,-99) , 
3, 0.268003, 0, 0, 0.411855,-99)    );
  // itree = 642
  fBoostWeights.push_back(0.21851);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49068,-99) , 
3, 0.117324, 0, 0, 0.615032,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478586,-99) , 
3, 2.93119, 0, 0, 0.515152,-99) , 
2, 0.892651, 1, 0, 0.572187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631401,-99) , 
NN(
0, 
0, 
-1, -2.09869, 1, -1, 0.320805,-99) , 
3, -0.400178, 0, 0, 0.37096,-99) , 
2, -0.660692, 0, 0, 0.532536,-99)    );
  // itree = 643
  fBoostWeights.push_back(0.204662);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.95344, 1, 1, 0.775076,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336352,-99) , 
3, -2.07331, 0, 0, 0.613531,-99) , 
NN(
0, 
0, 
-1, 0.134284, 0, -1, 0.427566,-99) , 
0, -2.26952, 1, 0, 0.44476,-99) , 
3, 2.66293, 0, 0, 0.472295,-99)    );
  // itree = 644
  fBoostWeights.push_back(0.286477);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0613354, 1, 1, 0.733363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27371,-99) , 
0, 1.05011, 0, 0, 0.549972,-99) , 
2, 1.09657, 1, 0, 0.623324,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437148,-99) , 
0, -2.13164, 0, 0, 0.620439,-99) , 
NN(
0, 
0, 
-1, -0.245883, 0, -1, 0.407629,-99) , 
0, -0.922166, 1, 0, 0.491852,-99) , 
3, 0.760049, 0, 0, 0.549628,-99)    );
  // itree = 645
  fBoostWeights.push_back(0.218431);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.237261, 0, 1, 0.588712,-99) , 
NN(
0, 
0, 
-1, -0.776769, 0, -1, 0.419134,-99) , 
0, 1.36998, 1, 0, 0.514579,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255237,-99) , 
2, -0.790369, 1, 0, 0.455693,-99) , 
NN(
0, 
0, 
-1, -1.0877, 1, -1, 0.209691,-99) , 
1, 0.749649, 1, 0, 0.364892,-99) , 
2, -0.55359, 0, 0, 0.475528,-99)    );
  // itree = 646
  fBoostWeights.push_back(0.157665);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.135269, 1, 1, 0.551113,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352615,-99) , 
2, -1.02259, 1, 0, 0.416026,-99) , 
3, -0.0725463, 0, 0, 0.502208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20756,-99) , 
1, 1.7638, 1, 0, 0.488366,-99)    );
  // itree = 647
  fBoostWeights.push_back(0.21579);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417279,-99) , 
1, -1.17391, 0, 0, 0.604401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236388,-99) , 
2, -1.63402, 0, 0, 0.567527,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268555,-99) , 
0, 0.967677, 0, 0, 0.477129,-99) , 
NN(
0, 
0, 
-1, 0.423423, 1, -1, 0.310726,-99) , 
3, 0.962375, 0, 0, 0.426131,-99) , 
0, 0.220525, 1, 0, 0.482448,-99)    );
  // itree = 648
  fBoostWeights.push_back(0.101844);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.47388, 1, 1, 0.532749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297961,-99) , 
3, -1.45781, 0, 0, 0.519905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12336,-99) , 
1, 2.14513, 1, 0, 0.509551,-99)    );
  // itree = 649
  fBoostWeights.push_back(0.206109);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.115415, 1, 1, 0.72817,-99) , 
NN(
0, 
0, 
-1, -1.02741, 0, -1, 0.446496,-99) , 
2, 0.0910407, 1, 0, 0.488302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286139,-99) , 
0, -1.94619, 1, 0, 0.341765,-99) , 
2, -1.49689, 1, 0, 0.383929,-99) , 
2, -0.403065, 0, 0, 0.462384,-99)    );
  // itree = 650
  fBoostWeights.push_back(0.144101);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433304,-99) , 
1, 0.509648, 1, 0, 0.497559,-99) , 
1, -1.25585, 1, 0, 0.515062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.113571,-99) , 
3, 0.34422, 0, 0, 0.325548,-99) , 
1, -1.52075, 0, 0, 0.503602,-99)    );
  // itree = 651
  fBoostWeights.push_back(0.169169);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331585,-99) , 
0, 3.78767, 1, 0, 0.534933,-99) , 
NN(
0, 
0, 
-1, 1.25356, 1, -1, 0.429842,-99) , 
1, 0.104868, 0, 0, 0.479369,-99) , 
NN(
0, 
0, 
-1, -1.32979, 1, -1, 0.274724,-99) , 
3, -1.15439, 0, 0, 0.455086,-99)    );
  // itree = 652
  fBoostWeights.push_back(0.180662);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.550998, 0, 1, 0.795014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479804,-99) , 
1, -1.10883, 1, 0, 0.50761,-99) , 
0, -0.783984, 1, 0, 0.540056,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313377,-99) , 
1, 0.336366, 0, 0, 0.426262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202798,-99) , 
2, -1.10333, 1, 0, 0.358346,-99) , 
2, -0.925344, 0, 0, 0.514885,-99)    );
  // itree = 653
  fBoostWeights.push_back(0.185446);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748397,-99) , 
NN(
NN(
0, 
0, 
-1, -0.0985137, 1, -1, 0.44674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.134841,-99) , 
1, 0.948828, 0, 0, 0.293423,-99) , 
2, -0.936767, 0, 0, 0.427718,-99) , 
1, 1.91964, 0, 0, 0.441603,-99)    );
  // itree = 654
  fBoostWeights.push_back(0.21513);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.107382, 1, 1, 0.585825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316254,-99) , 
3, -0.563071, 0, 0, 0.567629,-99) , 
NN(
0, 
0, 
-1, -1.90981, 1, -1, 0.323583,-99) , 
3, -0.810266, 0, 0, 0.528395,-99)    );
  // itree = 655
  fBoostWeights.push_back(0.176546);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.01763, 0, 1, 0.642133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484952,-99) , 
2, 1.45678, 0, 0, 0.503031,-99) , 
1, -0.11574, 1, 0, 0.562628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207382,-99) , 
3, 2.78754, 1, 0, 0.547192,-99)    );
  // itree = 656
  fBoostWeights.push_back(0.217546);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.64155, 1, 1, 0.805781,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335911,-99) , 
0, 2.21491, 1, 0, 0.538391,-99) , 
3, 2.20609, 0, 0, 0.565143,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185529,-99) , 
3, 3.45184, 0, 0, 0.383223,-99) , 
0, 3.94904, 1, 0, 0.552307,-99)    );
  // itree = 657
  fBoostWeights.push_back(0.154393);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65833, 0, 1, 0.543203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.88414, 0, 0, 0.524723,-99) , 
NN(
0, 
0, 
-1, 1.75908, 1, -1, 0.288368,-99) , 
0, 3.06373, 1, 0, 0.497135,-99)    );
  // itree = 658
  fBoostWeights.push_back(0.185669);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413998,-99) , 
1, 0.806267, 1, 0, 0.527912,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199209,-99) , 
2, 1.30128, 0, 0, 0.423276,-99) , 
2, 1.13161, 1, 0, 0.500729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274424,-99) , 
3, -1.5755, 0, 0, 0.492499,-99)    );
  // itree = 659
  fBoostWeights.push_back(0.234851);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.299504, 0, 1, 0.770101,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424644,-99) , 
2, 1.28965, 0, 0, 0.493398,-99) , 
0, 1.58243, 1, 0, 0.549201,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319869,-99) , 
2, -0.0974837, 1, 0, 0.439404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0391114,-99) , 
2, -1.61578, 0, 0, 0.415829,-99) , 
3, 0.828289, 0, 0, 0.466508,-99)    );
  // itree = 660
  fBoostWeights.push_back(0.326837);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.12772, 0, 1, 0.912272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410989,-99) , 
1, -0.371343, 1, 0, 0.487579,-99) , 
2, -0.282928, 0, 0, 0.593047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380084,-99) , 
2, 0.7984, 0, 0, 0.541192,-99) , 
NN(
0, 
0, 
-1, 0.165771, 1, -1, 0.366478,-99) , 
1, 0.527824, 0, 0, 0.429461,-99) , 
0, -0.416978, 1, 0, 0.480496,-99)    );
  // itree = 661
  fBoostWeights.push_back(0.267288);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08797, 1, 1, 0.613377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330785,-99) , 
1, -0.65388, 1, 0, 0.479098,-99) , 
1, -0.274313, 0, 0, 0.561624,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372703,-99) , 
0, 4.51884, 1, 0, 0.486027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160744,-99) , 
2, 1.7076, 0, 0, 0.354228,-99) , 
0, 3.54173, 1, 0, 0.541972,-99)    );
  // itree = 662
  fBoostWeights.push_back(0.23418);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -3.36955, 0, 1, 0.779589,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309206,-99) , 
3, -1.05134, 0, 0, 0.532226,-99) , 
0, -2.92241, 1, 0, 0.596152,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413095,-99) , 
0, 1.04743, 1, 0, 0.463083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0545911,-99) , 
3, -0.276116, 0, 0, 0.435831,-99) , 
0, -1.04422, 1, 0, 0.472048,-99)    );
  // itree = 663
  fBoostWeights.push_back(0.289552);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3994, 0, 1, 0.732382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346633,-99) , 
2, 1.14901, 1, 0, 0.510212,-99) , 
3, 2.32868, 0, 0, 0.54286,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445163,-99) , 
1, 1.39568, 1, 0, 0.554514,-99) , 
NN(
0, 
0, 
-1, -0.33239, 1, -1, 0.350421,-99) , 
1, 0.993633, 0, 0, 0.377805,-99) , 
3, 0.322617, 0, 0, 0.477963,-99)    );
  // itree = 664
  fBoostWeights.push_back(0.278117);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41026, 0, 1, 0.732552,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333106,-99) , 
2, 1.62374, 1, 0, 0.454376,-99) , 
0, 3.01325, 1, 0, 0.617958,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440909,-99) , 
1, -0.000385954, 0, 0, 0.502212,-99) , 
NN(
0, 
0, 
-1, 1.72124, 1, -1, 0.271314,-99) , 
1, 1.00778, 1, 0, 0.460691,-99) , 
3, 1.24934, 0, 0, 0.511125,-99)    );
  // itree = 665
  fBoostWeights.push_back(0.299091);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2625,-99) , 
0, -1.67263, 0, 0, 0.588029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236679,-99) , 
0, -1.87033, 1, 0, 0.403869,-99) , 
2, -0.90164, 0, 0, 0.549511,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270583,-99) , 
2, 2.35823, 1, 0, 0.530814,-99) , 
NN(
0, 
0, 
-1, 1.74458, 1, -1, 0.317678,-99) , 
2, 1.49812, 0, 0, 0.40004,-99) , 
2, 0.789242, 1, 0, 0.487908,-99)    );
  // itree = 666
  fBoostWeights.push_back(0.172777);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24704, 0, 1, 0.666541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371031,-99) , 
3, 0.660982, 0, 0, 0.449069,-99) , 
2, -0.451301, 1, 0, 0.484313,-99) , 
NN(
0, 
0, 
-1, -1.60648, 0, -1, 0.337368,-99) , 
3, -0.970391, 0, 0, 0.46939,-99)    );
  // itree = 667
  fBoostWeights.push_back(0.150439);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.512928, 0, 1, 0.754243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359516,-99) , 
3, -0.31552, 0, 0, 0.494032,-99) , 
0, -2.77675, 1, 0, 0.510225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0324817,-99) , 
0, 4.44906, 1, 0, 0.498004,-99)    );
  // itree = 668
  fBoostWeights.push_back(0.28051);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.01911, 1, 1, 0.627777,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412809,-99) , 
0, 1.1939, 0, 0, 0.460267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218366,-99) , 
0, -1.39989, 1, 0, 0.274357,-99) , 
1, 0.843066, 1, 0, 0.412955,-99) , 
3, 1.73863, 0, 0, 0.45532,-99)    );
  // itree = 669
  fBoostWeights.push_back(0.261163);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.356116, 1, 1, 0.597101,-99) , 
NN(
0, 
0, 
-1, 0.72636, 1, -1, 0.344801,-99) , 
2, -1.01301, 0, 0, 0.554185,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29805,-99) , 
1, 0.540968, 1, 0, 0.471273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238733,-99) , 
3, 1.58734, 0, 0, 0.397209,-99) , 
0, 1.92879, 1, 0, 0.507829,-99)    );
  // itree = 670
  fBoostWeights.push_back(0.23156);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343171,-99) , 
3, -1.22027, 0, 0, 0.557939,-99) , 
NN(
0, 
0, 
-1, -0.594066, 0, -1, 0.406838,-99) , 
3, 0.974547, 1, 0, 0.508716,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350762,-99) , 
1, 1.14424, 0, 0, 0.417234,-99) , 
NN(
0, 
0, 
-1, 1.34079, 1, -1, 0.235469,-99) , 
2, -0.720059, 0, 0, 0.384634,-99) , 
1, 0.527824, 1, 0, 0.465515,-99)    );
  // itree = 671
  fBoostWeights.push_back(0.181435);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.197275, 0, 1, 0.667483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449508,-99) , 
0, -2.80168, 1, 0, 0.46627,-99) , 
3, 1.49539, 0, 0, 0.493471,-99) , 
NN(
0, 
0, 
-1, 2.35396, 1, -1, 0.338018,-99) , 
2, 1.37221, 1, 0, 0.466453,-99)    );
  // itree = 672
  fBoostWeights.push_back(0.188915);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.84207, 0, 1, 0.638342,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434871,-99) , 
2, 0.60557, 0, 0, 0.491157,-99) , 
2, -0.451417, 1, 0, 0.51994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595944,-99) , 
NN(
0, 
0, 
-1, 1.55585, 0, -1, 0.35177,-99) , 
0, -1.40205, 1, 0, 0.387012,-99) , 
1, 0.370917, 1, 0, 0.470372,-99)    );
  // itree = 673
  fBoostWeights.push_back(0.242944);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480196,-99) , 
3, -0.546696, 0, 0, 0.61858,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18279,-99) , 
3, 0.613655, 0, 0, 0.461508,-99) , 
0, 0.676813, 1, 0, 0.531209,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223288,-99) , 
0, -0.788545, 0, 0, 0.452224,-99) , 
NN(
0, 
0, 
-1, 2.26249, 0, -1, 0.223926,-99) , 
2, 0.791305, 1, 0, 0.356984,-99) , 
1, 0.843066, 1, 0, 0.489177,-99)    );
  // itree = 674
  fBoostWeights.push_back(0.231059);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.911998, 1, 1, 0.77189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353889,-99) , 
0, 0.701405, 1, 0, 0.471295,-99) , 
0, 1.67989, 0, 0, 0.507011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489162,-99) , 
2, 1.83695, 0, 0, 0.561879,-99) , 
NN(
0, 
0, 
-1, 2.41612, 1, -1, 0.229552,-99) , 
1, 0.650998, 0, 0, 0.325266,-99) , 
0, 2.20789, 1, 0, 0.463542,-99)    );
  // itree = 675
  fBoostWeights.push_back(0.128781);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.38311, 0, 1, 0.693174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446293,-99) , 
0, 0.0778227, 1, 0, 0.47143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225798,-99) , 
1, 1.86814, 1, 0, 0.461418,-99) , 
0, -2.19565, 1, 0, 0.477607,-99)    );
  // itree = 676
  fBoostWeights.push_back(0.107507);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.14382, 0, 1, 0.743472,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193221,-99) , 
3, -0.973215, 0, 0, 0.491778,-99) , 
0, -1.77365, 1, 0, 0.514733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.9482, 0, 0, 0.500131,-99)    );
  // itree = 677
  fBoostWeights.push_back(0.189272);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427275,-99) , 
0, -1.92281, 1, 0, 0.442895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156414,-99) , 
3, -1.64107, 0, 0, 0.434901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184367,-99) , 
0, 4.15315, 1, 0, 0.426295,-99)    );
  // itree = 678
  fBoostWeights.push_back(0.211163);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445864,-99) , 
3, 0.164557, 0, 0, 0.519405,-99) , 
NN(
0, 
0, 
-1, 1.66415, 0, -1, 0.360606,-99) , 
0, 2.16629, 1, 0, 0.483762,-99) , 
NN(
0, 
0, 
-1, 4.65019, 1, -1, 0.119272,-99) , 
0, 3.95123, 1, 0, 0.463117,-99)    );
  // itree = 679
  fBoostWeights.push_back(0.237312);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.67543, 1, 1, 0.627307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330103,-99) , 
1, 2.00461, 1, 0, 0.562822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387181,-99) , 
2, 0.514811, 1, 0, 0.443336,-99) , 
NN(
0, 
0, 
-1, -0.309473, 1, -1, 0.254787,-99) , 
2, -0.7797, 0, 0, 0.412761,-99) , 
1, 0.992713, 0, 0, 0.447109,-99)    );
  // itree = 680
  fBoostWeights.push_back(0.199498);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.677866, 0, 1, 0.571017,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264516,-99) , 
3, 1.37273, 0, 0, 0.460761,-99) , 
0, 1.38193, 1, 0, 0.524688,-99) , 
NN(
0, 
0, 
-1, -1.81803, 0, -1, 0.182764,-99) , 
3, -1.45781, 0, 0, 0.506222,-99)    );
  // itree = 681
  fBoostWeights.push_back(0.180727);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0693355, 0, 1, 0.791605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457035,-99) , 
1, 0.607945, 1, 0, 0.676051,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398871,-99) , 
2, 0.7093, 1, 0, 0.656927,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437858,-99) , 
2, 0.609049, 0, 0, 0.488838,-99) , 
1, 1.31085, 0, 0, 0.507196,-99) , 
2, -1.08782, 1, 0, 0.524868,-99)    );
  // itree = 682
  fBoostWeights.push_back(0.255267);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92211, 1, 1, 0.681814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339475,-99) , 
2, 1.35263, 1, 0, 0.544978,-99) , 
3, 2.11049, 0, 0, 0.614183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374466,-99) , 
2, -1.64599, 0, 0, 0.604235,-99) , 
NN(
0, 
0, 
-1, 1.36581, 1, -1, 0.40776,-99) , 
2, -1.25344, 1, 0, 0.430198,-99) , 
3, 1.30905, 0, 0, 0.487437,-99)    );
  // itree = 683
  fBoostWeights.push_back(0.261601);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.294451, 1, 1, 0.664175,-99) , 
NN(
0, 
0, 
-1, 0.255154, 0, -1, 0.413029,-99) , 
0, 0.145663, 1, 0, 0.482788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531728,-99) , 
NN(
0, 
0, 
-1, -0.667429, 1, -1, 0.23236,-99) , 
1, 0.897865, 0, 0, 0.294922,-99) , 
3, -0.613987, 0, 0, 0.449494,-99)    );
  // itree = 684
  fBoostWeights.push_back(0.139592);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71619, 0, 1, 0.732956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408764,-99) , 
0, 3.97953, 1, 0, 0.664781,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497843,-99) , 
0, -2.74629, 1, 0, 0.514987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165152,-99) , 
1, 1.71189, 1, 0, 0.493471,-99) , 
0, 2.50878, 0, 0, 0.525586,-99)    );
  // itree = 685
  fBoostWeights.push_back(0.269153);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.699664, 1, 1, 0.609751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249139,-99) , 
3, 2.44192, 1, 0, 0.585194,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306184,-99) , 
3, 2.28835, 1, 0, 0.525147,-99) , 
NN(
0, 
0, 
-1, 0.748278, 1, -1, 0.311929,-99) , 
3, 0.48763, 0, 0, 0.43958,-99) , 
1, -0.0789854, 1, 0, 0.507049,-99)    );
  // itree = 686
  fBoostWeights.push_back(0.239447);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.898944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445086,-99) , 
3, 0.294515, 1, 0, 0.542414,-99) , 
3, 1.60372, 0, 0, 0.56166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57791,-99) , 
NN(
0, 
0, 
-1, 0.317961, 0, -1, 0.325353,-99) , 
1, 1.42323, 0, 0, 0.359241,-99) , 
0, 2.43894, 1, 0, 0.514588,-99)    );
  // itree = 687
  fBoostWeights.push_back(0.20648);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.488801, 0, 1, 0.650804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380282,-99) , 
3, 0.619328, 0, 0, 0.477461,-99) , 
0, -0.789998, 1, 0, 0.517285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148653,-99) , 
3, -1.5755, 0, 0, 0.506248,-99)    );
  // itree = 688
  fBoostWeights.push_back(0.356376);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339843,-99) , 
0, 3.29961, 1, 0, 0.629544,-99) , 
NN(
0, 
0, 
-1, -1.25609, 0, -1, 0.368973,-99) , 
0, -0.19032, 0, 0, 0.541048,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48791,-99) , 
1, 0.744723, 1, 0, 0.681282,-99) , 
NN(
0, 
0, 
-1, 0.784716, 0, -1, 0.322381,-99) , 
0, -0.608449, 1, 0, 0.400372,-99) , 
1, 0.102755, 1, 0, 0.470492,-99)    );
  // itree = 689
  fBoostWeights.push_back(0.121911);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.45762, 1, 1, 0.788457,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.149997,-99) , 
3, -1.87201, 0, 0, 0.492654,-99) , 
3, 1.79969, 0, 0, 0.518598,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299781,-99) , 
2, 2.47443, 1, 0, 0.434634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.113026,-99) , 
1, 0.387251, 1, 0, 0.289713,-99) , 
2, 1.85311, 1, 0, 0.49464,-99)    );
  // itree = 690
  fBoostWeights.push_back(0.188192);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900765,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.97031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433463,-99) , 
3, -1.05139, 0, 0, 0.589685,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392312,-99) , 
3, 0.589814, 0, 0, 0.448973,-99) , 
0, -1.7412, 1, 0, 0.468937,-99) , 
2, 3.15615, 0, 0, 0.485915,-99)    );
  // itree = 691
  fBoostWeights.push_back(0.111214);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.75782, 0, 1, 0.662399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524811,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299882,-99) , 
2, -0.960645, 0, 0, 0.509133,-99) , 
2, -1.37401, 1, 0, 0.520829,-99) , 
NN(
0, 
0, 
-1, 2.99205, 0, -1, 0.27049,-99) , 
0, 3.63805, 1, 0, 0.508812,-99)    );
  // itree = 692
  fBoostWeights.push_back(0.246185);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356623,-99) , 
0, -1.40205, 0, 0, 0.605482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22567,-99) , 
1, 1.88704, 1, 0, 0.558087,-99) , 
NN(
0, 
0, 
-1, 2.286, 1, -1, 0.400363,-99) , 
1, 0.528386, 0, 0, 0.452285,-99)    );
  // itree = 693
  fBoostWeights.push_back(0.233881);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331678,-99) , 
1, 1.44362, 1, 0, 0.602223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18143,-99) , 
2, -0.120349, 1, 0, 0.4551,-99) , 
2, 0.118792, 0, 0, 0.528435,-99) , 
NN(
0, 
0, 
-1, 2.85186, 0, -1, 0.2776,-99) , 
0, 3.73896, 1, 0, 0.513016,-99)    );
  // itree = 694
  fBoostWeights.push_back(0.222989);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.810696, 1, 1, 0.682163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416368,-99) , 
3, 3.00911, 0, 0, 0.476623,-99) , 
0, 2.43597, 1, 0, 0.596744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341285,-99) , 
0, 1.20918, 1, 0, 0.541565,-99) , 
NN(
0, 
0, 
-1, -0.723657, 0, -1, 0.405769,-99) , 
1, 0.387754, 1, 0, 0.489767,-99) , 
2, 0.949017, 0, 0, 0.523918,-99)    );
  // itree = 695
  fBoostWeights.push_back(0.16612);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.917657,-99) , 
NN(
NN(
0, 
0, 
-1, 0.863407, 0, 1, 0.557294,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37046,-99) , 
3, 2.8929, 0, 0, 0.432524,-99) , 
0, 2.20789, 1, 0, 0.531363,-99) , 
2, 3.13057, 0, 0, 0.543604,-99)    );
  // itree = 696
  fBoostWeights.push_back(0.339677);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.647337, 0, 1, 0.713228,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309869,-99) , 
3, 0.740786, 0, 0, 0.417161,-99) , 
2, -0.09856, 1, 0, 0.521652,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33931,-99) , 
0, 0.753503, 1, 0, 0.403397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.144296,-99) , 
3, -0.667057, 1, 0, 0.276706,-99) , 
2, -0.349281, 0, 0, 0.355748,-99) , 
1, -0.259324, 1, 0, 0.42206,-99)    );
  // itree = 697
  fBoostWeights.push_back(0.176412);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3783, 1, 1, 0.607864,-99) , 
NN(
0, 
0, 
-1, 1.00529, 1, -1, 0.462464,-99) , 
1, 1.16366, 0, 0, 0.494684,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465665,-99) , 
2, 0.937045, 0, 0, 0.596228,-99) , 
NN(
0, 
0, 
-1, 0.494587, 1, -1, 0.315537,-99) , 
1, -1.50805, 1, 0, 0.381376,-99) , 
1, -0.490382, 0, 0, 0.462211,-99)    );
  // itree = 698
  fBoostWeights.push_back(0.320023);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482164,-99) , 
1, 0.722035, 1, 0, 0.627091,-99) , 
NN(
0, 
0, 
-1, -0.685581, 0, -1, 0.363036,-99) , 
0, 2.29211, 1, 0, 0.522033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862345,-99) , 
NN(
0, 
0, 
-1, 0.236123, 0, -1, 0.337864,-99) , 
1, -1.29885, 1, 0, 0.37989,-99) , 
3, 0.336059, 0, 0, 0.461516,-99)    );
  // itree = 699
  fBoostWeights.push_back(0.182573);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.647567, 1, 1, 0.557978,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.116159,-99) , 
3, 3.01804, 0, 0, 0.306061,-99) , 
0, 3.37074, 1, 0, 0.510292,-99) , 
NN(
0, 
0, 
-1, -0.128307, 1, -1, 0.416765,-99) , 
3, 0.268003, 0, 0, 0.469742,-99)    );
  // itree = 700
  fBoostWeights.push_back(0.323583);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.768368, 0, 1, 0.83291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174846,-99) , 
0, -2.53466, 0, 0, 0.474221,-99) , 
2, -0.918213, 0, 0, 0.669084,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443931,-99) , 
3, 1.4982, 0, 0, 0.537532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358971,-99) , 
2, -0.0534368, 1, 0, 0.385507,-99) , 
1, 0.198194, 0, 0, 0.454317,-99) , 
2, -0.471788, 1, 0, 0.508065,-99)    );
  // itree = 701
  fBoostWeights.push_back(0.177433);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451343,-99) , 
1, 1.46901, 1, 0, 0.678224,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260125,-99) , 
2, 1.07358, 1, 0, 0.490747,-99) , 
0, 2.20789, 0, 0, 0.531759,-99) , 
NN(
0, 
0, 
-1, 2.25816, 1, -1, 0.393989,-99) , 
1, -0.148457, 0, 0, 0.470951,-99)    );
  // itree = 702
  fBoostWeights.push_back(0.184406);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.357738, 0, 1, 0.59212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385299,-99) , 
1, -0.0869905, 1, 0, 0.574617,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462705,-99) , 
2, -1.3102, 1, 0, 0.484799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148059,-99) , 
1, 0.386243, 1, 0, 0.255837,-99) , 
3, 2.08537, 1, 0, 0.445621,-99) , 
1, 0.0567207, 1, 0, 0.500975,-99)    );
  // itree = 703
  fBoostWeights.push_back(0.242873);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.747659, 1, 1, 0.711365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180006,-99) , 
1, 1.57426, 1, 0, 0.508591,-99) , 
0, 1.14098, 1, 0, 0.566833,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472489,-99) , 
1, -0.125285, 1, 0, 0.563302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337461,-99) , 
3, 0.305968, 0, 0, 0.395844,-99) , 
2, -0.73659, 1, 0, 0.460196,-99) , 
0, 0.435941, 0, 0, 0.518732,-99)    );
  // itree = 704
  fBoostWeights.push_back(0.157395);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36709, 1, 1, 0.605732,-99) , 
NN(
0, 
0, 
-1, 0.382652, 1, -1, 0.455611,-99) , 
3, 1.16804, 0, 0, 0.503372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.1267,-99) , 
0, 3.83529, 1, 0, 0.486147,-99)    );
  // itree = 705
  fBoostWeights.push_back(0.309533);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393228,-99) , 
3, 0.252673, 1, 0, 0.702051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308657,-99) , 
1, 0.864474, 1, 0, 0.475873,-99) , 
0, -0.361013, 0, 0, 0.548969,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308903,-99) , 
2, 1.7688, 1, 0, 0.533725,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28935,-99) , 
2, 0.0450086, 1, 0, 0.326883,-99) , 
1, -0.239764, 1, 0, 0.389319,-99) , 
0, 0.411997, 1, 0, 0.46634,-99)    );
  // itree = 706
  fBoostWeights.push_back(0.254855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.622977, 1, 1, 0.61169,-99) , 
NN(
0, 
0, 
-1, 1.16475, 0, -1, 0.389398,-99) , 
0, 1.36913, 1, 0, 0.5071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601179,-99) , 
NN(
0, 
0, 
-1, -1.01422, 1, -1, 0.281222,-99) , 
1, -0.749949, 1, 0, 0.348732,-99) , 
3, -0.613987, 0, 0, 0.48116,-99)    );
  // itree = 707
  fBoostWeights.push_back(0.218954);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.131898, 0, 1, 0.670164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410511,-99) , 
1, 0.403857, 0, 0, 0.483573,-99) , 
2, -0.167479, 0, 0, 0.555074,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435304,-99) , 
3, 1.89155, 0, 0, 0.477685,-99) , 
NN(
0, 
0, 
-1, 4.15625, 0, -1, 0.291076,-99) , 
3, 2.61628, 1, 0, 0.455683,-99) , 
2, 0.61766, 1, 0, 0.509048,-99)    );
  // itree = 708
  fBoostWeights.push_back(0.192995);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746386,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255307,-99) , 
0, 3.02206, 1, 0, 0.510622,-99) , 
3, 2.88243, 0, 0, 0.52814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522496,-99) , 
NN(
0, 
0, 
-1, -1.43731, 1, -1, 0.292969,-99) , 
3, -0.992115, 0, 0, 0.355017,-99) , 
3, -0.707817, 0, 0, 0.497503,-99)    );
  // itree = 709
  fBoostWeights.push_back(0.268292);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283599,-99) , 
1, -0.0337698, 0, 0, 0.587764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340247,-99) , 
1, 1.43983, 1, 0, 0.479984,-99) , 
1, 0.281784, 1, 0, 0.511972,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492079,-99) , 
0, 3.53078, 0, 0, 0.58444,-99) , 
NN(
0, 
0, 
-1, 0.497124, 1, -1, 0.290373,-99) , 
3, 1.49539, 0, 0, 0.340412,-99) , 
1, -0.234178, 0, 0, 0.446591,-99)    );
  // itree = 710
  fBoostWeights.push_back(0.225732);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375953,-99) , 
3, -0.350275, 0, 0, 0.507277,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22507,-99) , 
3, 2.73913, 0, 0, 0.343606,-99) , 
2, 1.43186, 1, 0, 0.481545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.167724,-99) , 
1, 2.18426, 1, 0, 0.469306,-99)    );
  // itree = 711
  fBoostWeights.push_back(0.141762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61329, 1, 1, 0.648878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423445,-99) , 
2, 0.566067, 0, 0, 0.473559,-99) , 
1, 1.42885, 0, 0, 0.49101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24214,-99) , 
1, -1.68189, 0, 0, 0.479593,-99)    );
  // itree = 712
  fBoostWeights.push_back(0.247322);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.63219, 1, 1, 0.629285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381095,-99) , 
3, 0.632478, 0, 0, 0.507758,-99) , 
0, -0.794061, 1, 0, 0.539728,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277853,-99) , 
0, 1.44492, 1, 0, 0.432927,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0757973,-99) , 
3, 0.0732159, 0, 0, 0.345805,-99) , 
1, 1.45084, 1, 0, 0.518574,-99)    );
  // itree = 713
  fBoostWeights.push_back(0.236393);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.20729, 1, 1, 0.716695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384586,-99) , 
2, 1.76776, 1, 0, 0.542644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328362,-99) , 
0, -0.376314, 1, 0, 0.388333,-99) , 
1, -0.154985, 1, 0, 0.447293,-99) , 
1, 1.75304, 0, 0, 0.467805,-99)    );
  // itree = 714
  fBoostWeights.push_back(0.117612);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.66634, 0, 1, 0.683973,-99) , 
NN(
0, 
0, 
-1, -0.197152, 0, -1, 0.472647,-99) , 
0, -0.902133, 1, 0, 0.496341,-99) , 
NN(
0, 
0, 
-1, -1.18741, 1, -1, 0.277517,-99) , 
3, -1.09475, 0, 0, 0.479553,-99)    );
  // itree = 715
  fBoostWeights.push_back(0.254122);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0847372, 1, 1, 0.754472,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288113,-99) , 
1, -0.298002, 0, 0, 0.458596,-99) , 
3, 1.46319, 1, 0, 0.543209,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385102,-99) , 
1, -0.237385, 1, 0, 0.446992,-99) , 
NN(
0, 
0, 
-1, -0.205394, 1, -1, 0.21884,-99) , 
2, 0.592297, 1, 0, 0.407944,-99) , 
3, 1.12461, 0, 0, 0.45261,-99)    );
  // itree = 716
  fBoostWeights.push_back(0.114);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468467,-99) , 
3, 2.42113, 0, 0, 0.477896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266196,-99) , 
0, 3.63805, 1, 0, 0.467944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201058,-99) , 
1, -2.21448, 0, 0, 0.458976,-99)    );
  // itree = 717
  fBoostWeights.push_back(0.191845);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.882915, 0, 1, 0.583374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392204,-99) , 
1, -0.237758, 1, 0, 0.482894,-99) , 
2, 1.11941, 1, 0, 0.553066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384047,-99) , 
3, -1.27729, 0, 0, 0.544374,-99)    );
  // itree = 718
  fBoostWeights.push_back(0.330312);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311398,-99) , 
1, -1.06403, 0, 0, 0.574996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355322,-99) , 
0, -2.04428, 1, 0, 0.413722,-99) , 
2, 0.198409, 0, 0, 0.492807,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25777,-99) , 
2, 1.67977, 0, 0, 0.472313,-99) , 
NN(
0, 
0, 
-1, 2.39574, 0, -1, 0.164587,-99) , 
0, 3.02092, 1, 0, 0.334518,-99) , 
2, 1.42744, 1, 0, 0.465088,-99)    );
  // itree = 719
  fBoostWeights.push_back(0.228863);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.921688, 0, 1, 0.69059,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266112,-99) , 
2, 1.15058, 1, 0, 0.510259,-99) , 
1, 1.10329, 1, 0, 0.559427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699611,-99) , 
NN(
0, 
0, 
-1, 0.730834, 1, -1, 0.398686,-99) , 
1, -1.85334, 1, 0, 0.411481,-99) , 
1, 0.860284, 0, 0, 0.446178,-99)    );
  // itree = 720
  fBoostWeights.push_back(0.245014);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112905,-99) , 
2, 2.68706, 1, 0, 0.595056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355295,-99) , 
0, -0.134393, 1, 0, 0.431743,-99) , 
2, 1.20333, 0, 0, 0.46815,-99) , 
1, -1.86762, 1, 0, 0.485028,-99)    );
  // itree = 721
  fBoostWeights.push_back(0.23377);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.591609, 0, 1, 0.597017,-99) , 
NN(
0, 
0, 
-1, 0.65926, 0, -1, 0.441374,-99) , 
2, 0.45817, 1, 0, 0.526328,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29909,-99) , 
1, -0.910584, 0, 0, 0.481039,-99) , 
NN(
0, 
0, 
-1, -0.75082, 1, -1, 0.333089,-99) , 
2, 1.02321, 0, 0, 0.377797,-99) , 
1, -0.480148, 0, 0, 0.479619,-99)    );
  // itree = 722
  fBoostWeights.push_back(0.272024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3467, 1, 1, 0.699516,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481976,-99) , 
2, 1.12809, 1, 0, 0.556856,-99) , 
2, 1.49254, 0, 0, 0.609449,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436516,-99) , 
2, -0.134103, 1, 0, 0.532059,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307265,-99) , 
2, -1.16483, 1, 0, 0.336568,-99) , 
1, 0.213586, 1, 0, 0.436352,-99) , 
2, 0.897689, 0, 0, 0.483025,-99)    );
  // itree = 723
  fBoostWeights.push_back(0.208074);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443887,-99) , 
0, 0.820416, 1, 0, 0.718707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136707,-99) , 
3, -1.64417, 0, 0, 0.500221,-99) , 
3, 0.341457, 0, 0, 0.559648,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466369,-99) , 
0, 1.52146, 1, 0, 0.503286,-99) , 
NN(
0, 
0, 
-1, 1.33844, 1, -1, 0.298153,-99) , 
1, 0.862332, 1, 0, 0.441915,-99) , 
0, 1.20503, 1, 0, 0.514644,-99)    );
  // itree = 724
  fBoostWeights.push_back(0.197443);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481943,-99) , 
1, 0.852195, 1, 0, 0.717126,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374631,-99) , 
3, 0.329683, 0, 0, 0.480543,-99) , 
0, -1.24772, 1, 0, 0.513174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0837696,-99) , 
3, -1.5755, 0, 0, 0.499568,-99)    );
  // itree = 725
  fBoostWeights.push_back(0.157002);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849221,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432232,-99) , 
2, 0.472663, 1, 0, 0.481138,-99) , 
2, -1.2884, 1, 0, 0.496326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0786282,-99) , 
2, -1.56754, 0, 0, 0.481319,-99)    );
  // itree = 726
  fBoostWeights.push_back(0.182192);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.5525, 0, 1, 0.568475,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23293,-99) , 
1, -0.0811313, 1, 0, 0.441375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19679,-99) , 
1, -0.874162, 0, 0, 0.387499,-99) , 
3, -0.707817, 0, 0, 0.540678,-99)    );
  // itree = 727
  fBoostWeights.push_back(0.227307);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.94492, 1, 1, 0.625354,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496464,-99) , 
1, 0.641702, 1, 0, 0.54872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334655,-99) , 
3, 2.04209, 0, 0, 0.38018,-99) , 
1, 0.183913, 0, 0, 0.473719,-99) , 
1, -0.810577, 1, 0, 0.502872,-99)    );
  // itree = 728
  fBoostWeights.push_back(0.253216);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27134, 0, 1, 0.572006,-99) , 
NN(
0, 
0, 
-1, 4.4493, 1, -1, 0.302069,-99) , 
0, 3.46415, 1, 0, 0.546443,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317528,-99) , 
3, -1.18205, 0, 0, 0.484028,-99) , 
NN(
0, 
0, 
-1, -0.424615, 0, -1, 0.233113,-99) , 
0, -1.18683, 1, 0, 0.375515,-99) , 
3, -0.170545, 0, 0, 0.495482,-99)    );
  // itree = 729
  fBoostWeights.push_back(0.266558);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377286,-99) , 
3, -0.841379, 0, 0, 0.681241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283712,-99) , 
3, 0.632478, 0, 0, 0.474424,-99) , 
0, -0.251429, 1, 0, 0.528594,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496942,-99) , 
3, 2.56718, 1, 0, 0.626206,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33199,-99) , 
0, -1.02961, 1, 0, 0.362644,-99) , 
2, 1.49763, 0, 0, 0.387567,-99) , 
1, 0.213586, 0, 0, 0.452636,-99)    );
  // itree = 730
  fBoostWeights.push_back(0.276566);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796278,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397113,-99) , 
3, 2.96762, 0, 0, 0.492578,-99) , 
2, 1.53592, 1, 0, 0.62982,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418576,-99) , 
3, 0.23722, 1, 0, 0.490978,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310699,-99) , 
1, 0.435325, 0, 0, 0.375813,-99) , 
3, -0.365475, 0, 0, 0.456311,-99) , 
3, 2.16453, 0, 0, 0.478801,-99)    );
  // itree = 731
  fBoostWeights.push_back(0.317323);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493112,-99) , 
2, 0.930892, 0, 0, 0.641861,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314223,-99) , 
2, 1.5712, 1, 0, 0.407928,-99) , 
0, 2.31044, 1, 0, 0.544227,-99) , 
NN(
NN(
0, 
0, 
-1, 0.14676, 0, 1, 0.588502,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26799,-99) , 
2, -0.972574, 1, 0, 0.332596,-99) , 
1, -0.32552, 1, 0, 0.41281,-99) , 
2, 0.603252, 0, 0, 0.473942,-99)    );
  // itree = 732
  fBoostWeights.push_back(0.287081);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281942,-99) , 
2, -0.305499, 0, 0, 0.533704,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27561,-99) , 
2, 0.303209, 1, 0, 0.346277,-99) , 
1, 0.730317, 1, 0, 0.472055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602777,-99) , 
NN(
0, 
0, 
-1, -1.24392, 1, -1, 0.27901,-99) , 
1, -0.647816, 1, 0, 0.319554,-99) , 
2, -0.55359, 0, 0, 0.438497,-99)    );
  // itree = 733
  fBoostWeights.push_back(0.162238);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.47123, 0, 1, 0.736329,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466743,-99) , 
3, 1.04916, 0, 0, 0.501873,-99) , 
1, -1.17388, 1, 0, 0.521337,-99) , 
NN(
0, 
0, 
-1, 1.85651, 0, -1, 0.293907,-99) , 
0, 3.0777, 1, 0, 0.495872,-99)    );
  // itree = 734
  fBoostWeights.push_back(0.227385);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90106, 1, 1, 0.678452,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266712,-99) , 
0, 2.45915, 0, 0, 0.407269,-99) , 
2, 1.34988, 1, 0, 0.555406,-99) , 
NN(
0, 
0, 
-1, -1.8514, 0, -1, 0.41843,-99) , 
3, 0.828289, 0, 0, 0.480604,-99)    );
  // itree = 735
  fBoostWeights.push_back(0.333037);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0361468, 0, 1, 0.650352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418471,-99) , 
1, 1.16946, 0, 0, 0.51757,-99) , 
1, 0.446289, 1, 0, 0.583288,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348622,-99) , 
1, -1.19341, 0, 0, 0.577825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236607,-99) , 
2, 1.6588, 0, 0, 0.281159,-99) , 
0, 0.452539, 1, 0, 0.412093,-99) , 
1, -0.562348, 0, 0, 0.529642,-99)    );
  // itree = 736
  fBoostWeights.push_back(0.235609);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495707,-99) , 
0, 1.14022, 1, 0, 0.584597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403686,-99) , 
0, -2.6042, 1, 0, 0.45764,-99) , 
3, -0.291428, 0, 0, 0.554078,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39645,-99) , 
0, 0.449965, 0, 0, 0.564326,-99) , 
NN(
0, 
0, 
-1, -0.973567, 1, -1, 0.335573,-99) , 
1, -1.16057, 1, 0, 0.453454,-99) , 
1, -0.605346, 0, 0, 0.523635,-99)    );
  // itree = 737
  fBoostWeights.push_back(0.205513);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457049,-99) , 
1, -0.180228, 0, 0, 0.544412,-99) , 
NN(
0, 
0, 
-1, 1.27881, 0, -1, 0.306447,-99) , 
1, 1.56322, 1, 0, 0.51779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195352,-99) , 
1, -1.75273, 0, 0, 0.501445,-99)    );
  // itree = 738
  fBoostWeights.push_back(0.204607);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.236764, 1, 1, 0.71362,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376365,-99) , 
3, -0.0154541, 0, 0, 0.492902,-99) , 
1, -1.33919, 1, 0, 0.525458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
0, 4.44906, 1, 0, 0.511226,-99)    );
  // itree = 739
  fBoostWeights.push_back(0.166387);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726924,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186835,-99) , 
0, 3.08613, 1, 0, 0.536827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294217,-99) , 
1, 0.187372, 1, 0, 0.446913,-99) , 
1, 0.547194, 0, 0, 0.476009,-99) , 
3, 3.55151, 0, 0, 0.484523,-99)    );
  // itree = 740
  fBoostWeights.push_back(0.150816);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342771,-99) , 
2, -1.6954, 0, 0, 0.56744,-99) , 
NN(
0, 
0, 
-1, 0.535928, 0, -1, 0.45383,-99) , 
0, 0.166614, 1, 0, 0.493759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210662,-99) , 
3, 2.8375, 1, 0, 0.480319,-99)    );
  // itree = 741
  fBoostWeights.push_back(0.193527);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.1348, 1, 1, 0.833057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40754,-99) , 
3, 0.139897, 0, 0, 0.518298,-99) , 
0, -1.80975, 1, 0, 0.546429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178326,-99) , 
3, -1.62852, 0, 0, 0.536525,-99)    );
  // itree = 742
  fBoostWeights.push_back(0.248246);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.77174, 0, 1, 0.687061,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245799,-99) , 
0, 1.66158, 1, 0, 0.529837,-99) , 
0, 2.24856, 0, 0, 0.570545,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436632,-99) , 
3, -0.442876, 0, 0, 0.557329,-99) , 
NN(
0, 
0, 
-1, -0.0904093, 1, -1, 0.416126,-99) , 
0, 0.749055, 1, 0, 0.482133,-99) , 
1, 0.444458, 0, 0, 0.515681,-99)    );
  // itree = 743
  fBoostWeights.push_back(0.274562);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402291,-99) , 
3, -0.65063, 0, 0, 0.550623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318056,-99) , 
2, 0.478196, 0, 0, 0.446526,-99) , 
0, 0.0729062, 1, 0, 0.492708,-99) , 
NN(
0, 
0, 
-1, 2.74686, 0, -1, 0.260807,-99) , 
2, 1.38996, 1, 0, 0.453205,-99)    );
  // itree = 744
  fBoostWeights.push_back(0.268647);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.03352, 0, 1, 0.743314,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430485,-99) , 
2, 0.454226, 1, 0, 0.548747,-99) , 
NN(
0, 
0, 
-1, 0.442549, 0, -1, 0.379919,-99) , 
1, -0.15853, 1, 0, 0.44986,-99) , 
2, -1.26009, 1, 0, 0.472667,-99)    );
  // itree = 745
  fBoostWeights.push_back(0.216095);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.895849, 0, 1, 0.591272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299256,-99) , 
1, 1.35428, 1, 0, 0.569159,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433295,-99) , 
3, 1.89927, 0, 0, 0.452643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274439,-99) , 
2, 2.61646, 0, 0, 0.331387,-99) , 
0, 2.76921, 1, 0, 0.415793,-99) , 
0, 0.331426, 1, 0, 0.48098,-99)    );
  // itree = 746
  fBoostWeights.push_back(0.211095);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392791,-99) , 
0, 2.2172, 1, 0, 0.678154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473226,-99) , 
3, 1.07176, 0, 0, 0.534135,-99) , 
1, -1.08737, 1, 0, 0.578324,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390427,-99) , 
1, 0.435254, 0, 0, 0.480262,-99) , 
NN(
0, 
0, 
-1, 2.47688, 1, -1, 0.18611,-99) , 
3, 2.31481, 1, 0, 0.446543,-99) , 
1, 0.0567207, 1, 0, 0.509745,-99)    );
  // itree = 747
  fBoostWeights.push_back(0.21549);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222323,-99) , 
0, -0.944774, 0, 0, 0.661039,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460855,-99) , 
2, -0.370275, 1, 0, 0.499447,-99) , 
1, -0.936379, 1, 0, 0.526875,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353468,-99) , 
3, 2.38586, 0, 0, 0.448957,-99) , 
NN(
0, 
0, 
-1, 1.85651, 1, -1, 0.267353,-99) , 
1, 0.261311, 1, 0, 0.34993,-99) , 
3, 1.73863, 1, 0, 0.49305,-99)    );
  // itree = 748
  fBoostWeights.push_back(0.195689);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448639,-99) , 
0, 1.41344, 1, 0, 0.550705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428984,-99) , 
2, -1.19327, 1, 0, 0.471832,-99) , 
2, -0.22962, 0, 0, 0.522512,-99) , 
NN(
0, 
0, 
-1, 2.9955, 0, -1, 0.376052,-99) , 
2, 1.80849, 1, 0, 0.509353,-99)    );
  // itree = 749
  fBoostWeights.push_back(0.271532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.556239, 0, 1, 0.59493,-99) , 
NN(
0, 
0, 
-1, 1.85689, 1, -1, 0.376531,-99) , 
1, 1.38548, 1, 0, 0.561303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287228,-99) , 
0, -1.26524, 1, 0, 0.346553,-99) , 
2, 1.89159, 0, 0, 0.378549,-99) , 
1, -0.417903, 0, 0, 0.496289,-99)    );
  // itree = 750
  fBoostWeights.push_back(0.26577);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.227479, 1, 1, 0.654279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43462,-99) , 
1, -0.818924, 1, 0, 0.479419,-99) , 
0, 2.34629, 1, 0, 0.59345,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437087,-99) , 
0, -0.326367, 0, 0, 0.524659,-99) , 
NN(
0, 
0, 
-1, -0.0561203, 1, -1, 0.353587,-99) , 
1, 0.284447, 0, 0, 0.416901,-99) , 
3, 0.27076, 0, 0, 0.515121,-99)    );
  // itree = 751
  fBoostWeights.push_back(0.235399);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.2134, 1, 1, 0.700725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194148,-99) , 
3, -1.70026, 0, 0, 0.612659,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.952479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476626,-99) , 
0, 2.1379, 1, 0, 0.536153,-99) , 
NN(
0, 
0, 
-1, 1.27367, 1, -1, 0.395791,-99) , 
3, 1.50643, 0, 0, 0.439001,-99) , 
3, -0.774089, 1, 0, 0.466813,-99)    );
  // itree = 752
  fBoostWeights.push_back(0.180301);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.305499, 1, 1, 0.543609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309876,-99) , 
1, -0.703953, 1, 0, 0.384628,-99) , 
2, -0.55359, 0, 0, 0.508795,-99) , 
NN(
0, 
0, 
-1, -1.95129, 1, -1, 0.246925,-99) , 
1, -1.65097, 0, 0, 0.494673,-99)    );
  // itree = 753
  fBoostWeights.push_back(0.24838);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.33519, 0, 1, 0.856444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361905,-99) , 
3, -0.524958, 0, 0, 0.422022,-99) , 
3, -0.0234518, 0, 0, 0.545976,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455512,-99) , 
2, 0.502858, 1, 0, 0.481428,-99) , 
NN(
0, 
0, 
-1, 0.57267, 0, -1, 0.288789,-99) , 
2, 0.330136, 0, 0, 0.436747,-99) , 
2, -0.0505193, 1, 0, 0.469457,-99)    );
  // itree = 754
  fBoostWeights.push_back(0.25049);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.08681, 0, 1, 0.686819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470204,-99) , 
1, 0.619958, 0, 0, 0.545999,-99) , 
0, 3.2467, 1, 0, 0.645049,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.94067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495343,-99) , 
3, -0.0310933, 0, 0, 0.542022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353225,-99) , 
1, -1.19986, 1, 0, 0.401198,-99) , 
0, -0.151943, 1, 0, 0.471153,-99) , 
3, 1.21627, 0, 0, 0.519836,-99)    );
  // itree = 755
  fBoostWeights.push_back(0.305343);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352748,-99) , 
2, -1.14257, 0, 0, 0.690676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216974,-99) , 
3, 2.00833, 1, 0, 0.656752,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330015,-99) , 
2, 1.0535, 1, 0, 0.483402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157864,-99) , 
1, 2.11702, 1, 0, 0.453971,-99) , 
1, 0.0841905, 1, 0, 0.544677,-99)    );
  // itree = 756
  fBoostWeights.push_back(0.18383);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.07785, 0, 1, 0.717785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241956,-99) , 
2, -1.3408, 0, 0, 0.646504,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46476,-99) , 
0, 2.37744, 0, 0, 0.489676,-99) , 
2, 2.55001, 0, 0, 0.505394,-99) , 
0, -1.04422, 1, 0, 0.533218,-99)    );
  // itree = 757
  fBoostWeights.push_back(0.148083);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727028,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489168,-99) , 
2, 0.415442, 0, 0, 0.535478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300156,-99) , 
3, 2.23655, 0, 0, 0.427184,-99) , 
0, 2.01604, 1, 0, 0.511461,-99) , 
1, 1.73177, 0, 0, 0.522349,-99)    );
  // itree = 758
  fBoostWeights.push_back(0.261378);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.656754, 1, 1, 0.656902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357333,-99) , 
0, 3.24435, 0, 0, 0.464842,-99) , 
0, 2.20789, 1, 0, 0.609056,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388977,-99) , 
1, 1.1315, 1, 0, 0.611778,-99) , 
NN(
0, 
0, 
-1, 0.608088, 0, -1, 0.451586,-99) , 
2, 0.863656, 0, 0, 0.505007,-99) , 
1, 0.434194, 1, 0, 0.563654,-99)    );
  // itree = 759
  fBoostWeights.push_back(0.200469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.922813, 0, 1, 0.557973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213122,-99) , 
1, -0.0940381, 0, 0, 0.343296,-99) , 
0, -1.82484, 0, 0, 0.533745,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356883,-99) , 
3, 2.95575, 1, 0, 0.547147,-99) , 
NN(
0, 
0, 
-1, 2.86494, 1, -1, 0.315722,-99) , 
3, 2.40547, 0, 0, 0.413313,-99) , 
0, 2.29217, 1, 0, 0.504933,-99)    );
  // itree = 760
  fBoostWeights.push_back(0.176863);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277377,-99) , 
0, 3.63655, 1, 0, 0.556286,-99) , 
NN(
0, 
0, 
-1, 0.573945, 1, -1, 0.444881,-99) , 
3, 1.25301, 0, 0, 0.477314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227952,-99) , 
2, 2.22841, 1, 0, 0.464852,-99)    );
  // itree = 761
  fBoostWeights.push_back(0.26825);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497923,-99) , 
0, -0.352194, 1, 0, 0.562386,-99) , 
NN(
0, 
0, 
-1, -1.72796, 1, -1, 0.339279,-99) , 
2, -0.830035, 0, 0, 0.504602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817432,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276642,-99) , 
3, 2.17691, 0, 0, 0.351265,-99) , 
0, 0.70387, 1, 0, 0.394851,-99) , 
2, 0.696934, 1, 0, 0.458682,-99)    );
  // itree = 762
  fBoostWeights.push_back(0.217756);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.0467, 1, 1, 0.586376,-99) , 
NN(
0, 
0, 
-1, -0.175545, 1, -1, 0.356949,-99) , 
3, -0.947191, 0, 0, 0.563144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0476791,-99) , 
0, 3.83529, 1, 0, 0.541572,-99)    );
  // itree = 763
  fBoostWeights.push_back(0.296536);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482427,-99) , 
2, 0.0559309, 1, 0, 0.681073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4323,-99) , 
0, -1.86874, 1, 0, 0.505086,-99) , 
3, 0.0265954, 0, 0, 0.569322,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373801,-99) , 
3, 2.23071, 1, 0, 0.589419,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361328,-99) , 
2, 0.704999, 1, 0, 0.417478,-99) , 
2, 1.47377, 0, 0, 0.463094,-99) , 
2, 0.462259, 1, 0, 0.51514,-99)    );
  // itree = 764
  fBoostWeights.push_back(0.193307);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488561,-99) , 
0, -0.069646, 1, 0, 0.532068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176453,-99) , 
3, -0.0480051, 0, 0, 0.341298,-99) , 
1, -1.1416, 0, 0, 0.509716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.876496,-99) , 
NN(
0, 
0, 
-1, 4.04547, 1, -1, 0.250983,-99) , 
2, 2.71426, 0, 0, 0.366272,-99) , 
2, 1.52138, 1, 0, 0.485882,-99)    );
  // itree = 765
  fBoostWeights.push_back(0.243111);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294391,-99) , 
0, 3.84814, 1, 0, 0.567712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256332,-99) , 
2, 0.418364, 1, 0, 0.392613,-99) , 
1, -0.733145, 0, 0, 0.538258,-99) , 
NN(
0, 
0, 
-1, -1.59692, 0, -1, 0.294463,-99) , 
3, -1.16308, 0, 0, 0.522309,-99)    );
  // itree = 766
  fBoostWeights.push_back(0.246846);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.517145, 1, 1, 0.639964,-99) , 
NN(
NN(
0, 
0, 
-1, 1.30021, 1, 1, 0.595724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385459,-99) , 
2, 0.153317, 0, 0, 0.416199,-99) , 
3, 0.684262, 0, 0, 0.514362,-99) , 
1, -0.133281, 1, 0, 0.569118,-99)    );
  // itree = 767
  fBoostWeights.push_back(0.266875);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.90073, 1, 1, 0.664626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.109433,-99) , 
3, -1.56633, 0, 0, 0.619762,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730588,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331702,-99) , 
2, 0.702256, 0, 0, 0.440092,-99) , 
2, -0.0801491, 1, 0, 0.459218,-99) , 
2, -0.283978, 1, 0, 0.511024,-99)    );
  // itree = 768
  fBoostWeights.push_back(0.225268);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.23874, 1, 1, 0.709471,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395988,-99) , 
2, 0.89049, 1, 0, 0.553882,-99) , 
NN(
0, 
0, 
-1, -0.091186, 1, -1, 0.42613,-99) , 
1, 0.743307, 0, 0, 0.462838,-99) , 
0, -1.11562, 1, 0, 0.502423,-99)    );
  // itree = 769
  fBoostWeights.push_back(0.275321);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45089,-99) , 
0, 1.4115, 1, 0, 0.541632,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280945,-99) , 
0, -2.64024, 1, 0, 0.350253,-99) , 
0, -0.675127, 0, 0, 0.483534,-99) , 
NN(
0, 
0, 
-1, 2.38666, 0, -1, 0.230183,-99) , 
2, 1.884, 1, 0, 0.458577,-99)    );
  // itree = 770
  fBoostWeights.push_back(0.169927);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825248,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480227,-99) , 
0, 1.99632, 0, 0, 0.518196,-99) , 
NN(
0, 
0, 
-1, 2.82599, 0, -1, 0.300787,-99) , 
2, 1.67258, 1, 0, 0.493153,-99) , 
1, 1.69217, 0, 0, 0.513196,-99)    );
  // itree = 771
  fBoostWeights.push_back(0.312618);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49378, 0, 1, 0.721841,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270462,-99) , 
1, -0.718445, 0, 0, 0.471497,-99) , 
0, 2.27921, 1, 0, 0.592693,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.96054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440768,-99) , 
3, -0.499989, 0, 0, 0.526804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32612,-99) , 
0, 0.664035, 0, 0, 0.395541,-99) , 
0, -0.685481, 1, 0, 0.451112,-99) , 
3, 0.760049, 0, 0, 0.521521,-99)    );
  // itree = 772
  fBoostWeights.push_back(0.293075);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457246,-99) , 
0, -2.05895, 0, 0, 0.620407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323925,-99) , 
0, 3.8537, 1, 0, 0.609491,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
2, 2.54534, 0, 0, 0.316992,-99) , 
2, 2.31809, 1, 0, 0.587686,-99)    );
  // itree = 773
  fBoostWeights.push_back(0.159339);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.598486, 1, 1, 0.618012,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490031,-99) , 
2, -0.681465, 1, 0, 0.537101,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241142,-99) , 
1, -0.134253, 1, 0, 0.348089,-99) , 
2, 1.17453, 1, 0, 0.515976,-99) , 
0, 1.93176, 0, 0, 0.541696,-99)    );
  // itree = 774
  fBoostWeights.push_back(0.192048);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.948968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490039,-99) , 
1, 0.236576, 1, 0, 0.730546,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312583,-99) , 
1, 0.962294, 0, 0, 0.511239,-99) , 
0, -2.82753, 0, 0, 0.639959,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498965,-99) , 
0, 0.721985, 1, 0, 0.549099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270139,-99) , 
3, -0.133268, 1, 0, 0.416282,-99) , 
3, 0.0447811, 0, 0, 0.50679,-99) , 
0, -1.72297, 1, 0, 0.524499,-99)    );
  // itree = 775
  fBoostWeights.push_back(0.182124);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333328,-99) , 
1, 0.407578, 1, 0, 0.52352,-99) , 
2, -0.800654, 0, 0, 0.612879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713369,-99) , 
NN(
0, 
0, 
-1, -0.966297, 0, -1, 0.450061,-99) , 
0, -1.06353, 1, 0, 0.461372,-99) , 
2, -0.601327, 1, 0, 0.492966,-99)    );
  // itree = 776
  fBoostWeights.push_back(0.145126);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763698,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425024,-99) , 
3, -1.94446, 0, 0, 0.661099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482097,-99) , 
3, 1.63344, 0, 0, 0.514186,-99) , 
0, -1.9816, 1, 0, 0.530699,-99) , 
NN(
0, 
0, 
-1, 2.49504, 0, -1, 0.299882,-99) , 
2, 1.80849, 1, 0, 0.513887,-99)    );
  // itree = 777
  fBoostWeights.push_back(0.316779);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308081,-99) , 
3, 2.5813, 1, 0, 0.629862,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289828,-99) , 
0, 1.15207, 1, 0, 0.399618,-99) , 
1, 0.907319, 1, 0, 0.571206,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456122,-99) , 
0, -1.79232, 0, 0, 0.523111,-99) , 
NN(
0, 
0, 
-1, -0.753346, 0, -1, 0.281801,-99) , 
0, -1.44498, 1, 0, 0.430297,-99) , 
3, -0.218528, 0, 0, 0.534562,-99)    );
  // itree = 778
  fBoostWeights.push_back(0.24802);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.62686, 1, 1, 0.629002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401092,-99) , 
3, 0.15673, 1, 0, 0.606937,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.99875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457324,-99) , 
2, 0.429639, 1, 0, 0.497689,-99) , 
NN(
0, 
0, 
-1, 0.963984, 1, -1, 0.314562,-99) , 
3, 0.997177, 0, 0, 0.427135,-99) , 
0, 0.0835435, 1, 0, 0.497731,-99)    );
  // itree = 779
  fBoostWeights.push_back(0.277352);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.189871, 0, 1, 0.585196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325393,-99) , 
0, 3.34721, 1, 0, 0.546084,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450782,-99) , 
1, 1.21712, 0, 0, 0.568463,-99) , 
NN(
0, 
0, 
-1, 0.156419, 1, -1, 0.33668,-99) , 
3, 1.371, 0, 0, 0.409987,-99) , 
1, -0.092065, 1, 0, 0.458405,-99)    );
  // itree = 780
  fBoostWeights.push_back(0.250727);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.936808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496955,-99) , 
3, 3.48207, 0, 0, 0.610197,-99) , 
0, 3.23648, 1, 0, 0.73285,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470638,-99) , 
2, -1.61456, 0, 0, 0.692559,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426314,-99) , 
2, 0.746937, 0, 0, 0.482601,-99) , 
2, -1.02838, 1, 0, 0.511457,-99) , 
3, 2.08537, 0, 0, 0.55223,-99)    );
  // itree = 781
  fBoostWeights.push_back(0.263874);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0756605, 0, 1, 0.751425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332137,-99) , 
1, 1.89156, 1, 0, 0.555822,-99) , 
2, 0.336622, 1, 0, 0.593074,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364315,-99) , 
0, -2.8511, 0, 0, 0.66223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365673,-99) , 
1, -0.804598, 1, 0, 0.41857,-99) , 
2, -1.04409, 1, 0, 0.47026,-99) , 
3, 0.402144, 0, 0, 0.538801,-99)    );
  // itree = 782
  fBoostWeights.push_back(0.356289);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497876,-99) , 
0, 2.84174, 1, 0, 0.673939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370302,-99) , 
2, 0.0605804, 1, 0, 0.512128,-99) , 
3, 0.904781, 0, 0, 0.60176,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453544,-99) , 
1, 0.948723, 0, 0, 0.581008,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218954,-99) , 
1, 1.09866, 0, 0, 0.318471,-99) , 
0, -2.20452, 1, 0, 0.399989,-99) , 
2, -0.55359, 0, 0, 0.551576,-99)    );
  // itree = 783
  fBoostWeights.push_back(0.224305);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.12528, 0, 1, 0.795034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30962,-99) , 
1, 1.86326, 1, 0, 0.709466,-99) , 
NN(
NN(
0, 
0, 
-1, -2.73423, 0, 1, 0.684987,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434106,-99) , 
3, 2.50716, 0, 0, 0.452121,-99) , 
0, -2.03899, 1, 0, 0.47043,-99) , 
1, 1.12702, 0, 0, 0.504658,-99)    );
  // itree = 784
  fBoostWeights.push_back(0.213925);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815588,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379538,-99) , 
3, 2.8349, 0, 0, 0.518403,-99) , 
0, 3.05319, 1, 0, 0.606624,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393405,-99) , 
3, -0.567053, 0, 0, 0.512836,-99) , 
NN(
0, 
0, 
-1, 2.38915, 1, -1, 0.332484,-99) , 
0, 1.56013, 1, 0, 0.475217,-99) , 
3, 1.84413, 0, 0, 0.491665,-99)    );
  // itree = 785
  fBoostWeights.push_back(0.211962);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.89137, 0, 1, 0.591742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0922089,-99) , 
2, 2.59026, 0, 0, 0.284335,-99) , 
2, 2.25074, 1, 0, 0.569261,-99)    );
  // itree = 786
  fBoostWeights.push_back(0.276338);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.909139, 0, 1, 0.709309,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345983,-99) , 
3, 0.0170205, 0, 0, 0.470865,-99) , 
1, -0.187451, 1, 0, 0.593423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429449,-99) , 
3, 3.41574, 0, 0, 0.449566,-99) , 
1, 1.77312, 0, 0, 0.470021,-99) , 
0, 0.449965, 1, 0, 0.518759,-99)    );
  // itree = 787
  fBoostWeights.push_back(0.282166);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482026,-99) , 
1, 0.689299, 1, 0, 0.584255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291604,-99) , 
3, -1.50699, 0, 0, 0.568471,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254925,-99) , 
2, 2.26277, 1, 0, 0.642503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220254,-99) , 
2, 1.37647, 1, 0, 0.363266,-99) , 
3, 2.3623, 0, 0, 0.460895,-99) , 
2, 1.01032, 1, 0, 0.529297,-99)    );
  // itree = 788
  fBoostWeights.push_back(0.142546);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745142,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469533,-99) , 
2, -0.197081, 1, 0, 0.503087,-99) , 
3, 2.59642, 0, 0, 0.516364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0921514,-99) , 
0, 4.49431, 1, 0, 0.500292,-99)    );
  // itree = 789
  fBoostWeights.push_back(0.175273);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.993052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495788,-99) , 
1, -0.787804, 1, 0, 0.559506,-99) , 
3, 1.9949, 1, 0, 0.633696,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371427,-99) , 
2, 1.17453, 1, 0, 0.531327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.162559,-99) , 
0, 2.2566, 1, 0, 0.513209,-99) , 
3, 1.72681, 0, 0, 0.537122,-99)    );
  // itree = 790
  fBoostWeights.push_back(0.358942);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.926983, 0, 1, 0.646052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27282,-99) , 
3, 1.51499, 0, 0, 0.471267,-99) , 
1, 1.15506, 1, 0, 0.619312,-99) , 
NN(
NN(
0, 
0, 
-1, -2.35875, 0, 1, 0.751198,-99) , 
NN(
0, 
0, 
-1, -0.0643759, 1, -1, 0.311145,-99) , 
2, -1.24626, 1, 0, 0.392184,-99) , 
2, 0.0154847, 0, 0, 0.540253,-99)    );
  // itree = 791
  fBoostWeights.push_back(0.231285);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0807615, 1, 1, 0.729543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410357,-99) , 
2, 0.63267, 0, 0, 0.51121,-99) , 
2, -0.129554, 1, 0, 0.548117,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396117,-99) , 
0, -2.30282, 1, 0, 0.495962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250266,-99) , 
1, -0.591655, 0, 0, 0.431386,-99) , 
3, -0.623168, 0, 0, 0.527873,-99)    );
  // itree = 792
  fBoostWeights.push_back(0.250197);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.345186, 0, 1, 0.824846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267429,-99) , 
1, 1.57547, 1, 0, 0.549541,-99) , 
2, 0.175063, 0, 0, 0.597313,-99) , 
NN(
NN(
0, 
0, 
-1, 1.34794, 1, 1, 0.56768,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205052,-99) , 
2, 0.924344, 0, 0, 0.322237,-99) , 
3, 0.960626, 0, 0, 0.49456,-99) , 
2, 0.456587, 1, 0, 0.547717,-99)    );
  // itree = 793
  fBoostWeights.push_back(0.138157);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822801,-99) , 
NN(
0, 
0, 
-1, -0.858005, 0, -1, 0.452677,-99) , 
0, -2.38379, 1, 0, 0.467897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198534,-99) , 
2, -1.49842, 0, 0, 0.456814,-99)    );
  // itree = 794
  fBoostWeights.push_back(0.262185);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.949205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324982,-99) , 
2, 1.9366, 1, 0, 0.542192,-99) , 
2, 0.6737, 1, 0, 0.581679,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434075,-99) , 
3, 0.447824, 0, 0, 0.47188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284916,-99) , 
0, 1.03406, 1, 0, 0.440488,-99) , 
3, 1.08674, 0, 0, 0.499696,-99)    );
  // itree = 795
  fBoostWeights.push_back(0.275957);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.299455, 1, 1, 0.628595,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390789,-99) , 
1, 0.978958, 0, 0, 0.448433,-99) , 
2, -0.449811, 0, 0, 0.563609,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367084,-99) , 
1, 0.468644, 1, 0, 0.460699,-99) , 
NN(
0, 
0, 
-1, -1.03608, 1, -1, 0.235727,-99) , 
1, -0.182594, 0, 0, 0.362766,-99) , 
2, 0.973129, 1, 0, 0.504911,-99)    );
  // itree = 796
  fBoostWeights.push_back(0.263972);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263824,-99) , 
2, -1.73837, 0, 0, 0.615594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253118,-99) , 
0, 0.833178, 1, 0, 0.585966,-99) , 
NN(
NN(
0, 
0, 
-1, 1.3214, 1, 1, 0.769254,-99) , 
NN(
0, 
0, 
-1, 1.11644, 0, -1, 0.408506,-99) , 
1, -1.41713, 1, 0, 0.443281,-99) , 
2, 0.190311, 1, 0, 0.508737,-99)    );
  // itree = 797
  fBoostWeights.push_back(0.300134);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465723,-99) , 
0, 1.80778, 1, 0, 0.572568,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411897,-99) , 
1, 1.53109, 0, 0, 0.485287,-99) , 
3, 0.53771, 0, 0, 0.535856,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338955,-99) , 
2, -1.40048, 1, 0, 0.369417,-99) , 
3, 1.97292, 0, 0, 0.403771,-99) , 
1, 0.0824709, 0, 0, 0.471162,-99)    );
  // itree = 798
  fBoostWeights.push_back(0.263546);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.886984, 0, 1, 0.814459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487904,-99) , 
2, 0.986794, 0, 0, 0.538742,-99) , 
1, 1.07488, 1, 0, 0.674099,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452043,-99) , 
0, -2.28858, 0, 0, 0.647752,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438121,-99) , 
3, 1.05093, 0, 0, 0.504865,-99) , 
2, -0.351252, 1, 0, 0.541669,-99) , 
1, 0.581975, 0, 0, 0.581309,-99)    );
  // itree = 799
  fBoostWeights.push_back(0.190809);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734415,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399895,-99) , 
2, 0.0118423, 0, 0, 0.487382,-99) , 
NN(
0, 
0, 
-1, -0.370743, 0, -1, 0.386915,-99) , 
0, 1.93176, 1, 0, 0.462644,-99) , 
1, -1.96898, 1, 0, 0.472132,-99)    );
  // itree = 800
  fBoostWeights.push_back(0.24153);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.03379, 0, 1, 0.619756,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37935,-99) , 
0, 3.10073, 1, 0, 0.490675,-99) , 
NN(
0, 
0, 
-1, 1.12078, 1, -1, 0.374157,-99) , 
0, 2.42459, 0, 0, 0.438081,-99) , 
2, 0.949745, 1, 0, 0.555006,-99)    );
  // itree = 801
  fBoostWeights.push_back(0.178176);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.919, 0, 1, 0.691891,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471977,-99) , 
3, 1.45109, 0, 0, 0.507577,-99) , 
NN(
0, 
0, 
-1, 0.347864, 0, -1, 0.327188,-99) , 
2, 1.57074, 1, 0, 0.476189,-99) , 
2, -1.08782, 1, 0, 0.500735,-99)    );
  // itree = 802
  fBoostWeights.push_back(0.225086);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.171874, 1, 1, 0.724969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171221,-99) , 
3, -1.55336, 0, 0, 0.475287,-99) , 
3, -0.654859, 0, 0, 0.587497,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2729,-99) , 
2, -0.10892, 0, 0, 0.500737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300469,-99) , 
2, 0.426811, 1, 0, 0.362276,-99) , 
1, 0.624956, 1, 0, 0.462948,-99) , 
2, -0.351925, 1, 0, 0.499377,-99)    );
  // itree = 803
  fBoostWeights.push_back(0.193667);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823586,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400181,-99) , 
2, 0.88806, 1, 0, 0.505708,-99) , 
3, 3.01201, 0, 0, 0.520722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158983,-99) , 
0, 4.68788, 1, 0, 0.50802,-99)    );
  // itree = 804
  fBoostWeights.push_back(0.308001);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461753,-99) , 
3, 0.613655, 0, 0, 0.548076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.948848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245987,-99) , 
2, 0.520042, 1, 0, 0.336148,-99) , 
1, -0.713402, 0, 0, 0.499845,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262618,-99) , 
2, -1.23605, 1, 0, 0.377292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.10956,-99) , 
2, -1.59299, 0, 0, 0.332909,-99) , 
3, -0.613509, 0, 0, 0.46782,-99)    );
  // itree = 805
  fBoostWeights.push_back(0.311937);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0604018, 0, 1, 0.787964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394158,-99) , 
1, 0.382446, 1, 0, 0.50322,-99) , 
2, -0.0955814, 0, 0, 0.571142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21783,-99) , 
2, 1.56989, 1, 0, 0.470328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328112,-99) , 
2, 2.31028, 0, 0, 0.357858,-99) , 
1, -0.11574, 1, 0, 0.401519,-99) , 
2, 0.456587, 1, 0, 0.484738,-99)    );
  // itree = 806
  fBoostWeights.push_back(0.158483);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164408,-99) , 
2, 2.45947, 1, 0, 0.543593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213647,-99) , 
2, -1.44395, 0, 0, 0.531043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148429,-99) , 
0, 4.60685, 1, 0, 0.520697,-99)    );
  // itree = 807
  fBoostWeights.push_back(0.198357);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.893097, 0, 1, 0.701979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178037,-99) , 
1, -0.910831, 0, 0, 0.615167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781123,-99) , 
NN(
0, 
0, 
-1, 0.00207245, 0, -1, 0.447256,-99) , 
1, -1.90873, 1, 0, 0.46003,-99) , 
0, -0.841201, 1, 0, 0.495256,-99)    );
  // itree = 808
  fBoostWeights.push_back(0.201563);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.69558, 1, 1, 0.694469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339216,-99) , 
1, 0.348063, 0, 0, 0.521866,-99) , 
3, -0.907946, 1, 0, 0.546436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328305,-99) , 
2, 1.2443, 1, 0, 0.486395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245778,-99) , 
1, -0.460924, 0, 0, 0.353773,-99) , 
3, 0.156152, 0, 0, 0.434774,-99) , 
1, 0.198194, 0, 0, 0.490759,-99)    );
  // itree = 809
  fBoostWeights.push_back(0.29022);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.545285, 0, 1, 0.795877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319862,-99) , 
1, -0.176846, 0, 0, 0.519653,-99) , 
0, 2.06263, 1, 0, 0.608266,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438814,-99) , 
1, 0.233601, 1, 0, 0.494197,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292884,-99) , 
0, -0.943167, 1, 0, 0.3472,-99) , 
1, -0.102661, 0, 0, 0.430163,-99) , 
2, 0.923149, 0, 0, 0.483169,-99)    );
  // itree = 810
  fBoostWeights.push_back(0.239305);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.571941, 0, 1, 0.660703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265208,-99) , 
3, 0.796719, 0, 0, 0.497098,-99) , 
0, 0.866868, 1, 0, 0.556524,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389888,-99) , 
1, -0.00674708, 0, 0, 0.522511,-99) , 
NN(
0, 
0, 
-1, -0.899097, 0, -1, 0.287663,-99) , 
0, -1.59415, 1, 0, 0.387736,-99) , 
3, -0.145446, 0, 0, 0.508609,-99)    );
  // itree = 811
  fBoostWeights.push_back(0.286808);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483533,-99) , 
2, -0.359614, 0, 0, 0.595202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208177,-99) , 
1, -1.70534, 0, 0, 0.573481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361982,-99) , 
0, 1.64507, 1, 0, 0.470188,-99) , 
NN(
0, 
0, 
-1, 1.72268, 0, -1, 0.316373,-99) , 
1, -0.0895685, 1, 0, 0.370934,-99) , 
2, 0.462259, 1, 0, 0.479647,-99)    );
  // itree = 812
  fBoostWeights.push_back(0.301945);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40272, 0, 1, 0.762951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388963,-99) , 
0, 0.510216, 0, 0, 0.476753,-99) , 
1, 1.52873, 1, 0, 0.624604,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445273,-99) , 
0, 1.03894, 1, 0, 0.51462,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353253,-99) , 
3, 1.03379, 0, 0, 0.384558,-99) , 
2, 0.789208, 0, 0, 0.433338,-99) , 
1, 1.02152, 0, 0, 0.476534,-99)    );
  // itree = 813
  fBoostWeights.push_back(0.152773);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48958,-99) , 
1, -1.70049, 1, 0, 0.502641,-99) , 
0, -0.902133, 1, 0, 0.520931,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279836,-99) , 
2, -1.46034, 1, 0, 0.420621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13076,-99) , 
3, -1.59648, 0, 0, 0.355708,-99) , 
3, -0.689919, 0, 0, 0.496303,-99)    );
  // itree = 814
  fBoostWeights.push_back(0.288432);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.316886, 0, 1, 0.632288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35771,-99) , 
0, -2.55781, 1, 0, 0.448374,-99) , 
2, -0.916706, 0, 0, 0.586832,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461523,-99) , 
1, -1.15088, 1, 0, 0.541727,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303483,-99) , 
0, 0.563868, 1, 0, 0.346596,-99) , 
3, 1.6958, 0, 0, 0.420826,-99) , 
2, 0.44688, 1, 0, 0.495471,-99)    );
  // itree = 815
  fBoostWeights.push_back(0.14621);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.19754, 1, 1, 0.55348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304394,-99) , 
2, -1.63862, 0, 0, 0.543326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22865,-99) , 
1, -1.63719, 1, 0, 0.377594,-99) , 
1, -1.36363, 0, 0, 0.527056,-99)    );
  // itree = 816
  fBoostWeights.push_back(0.190417);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.458612, 1, 1, 0.64782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31491,-99) , 
1, -0.571615, 1, 0, 0.604792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339878,-99) , 
2, 1.80849, 1, 0, 0.500219,-99) , 
NN(
0, 
0, 
-1, 0.749733, 0, -1, 0.330238,-99) , 
1, 0.11199, 0, 0, 0.452152,-99) , 
1, -0.429674, 1, 0, 0.496623,-99)    );
  // itree = 817
  fBoostWeights.push_back(0.209192);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.941418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433442,-99) , 
3, 2.2247, 0, 0, 0.584297,-99) , 
0, 2.49694, 1, 0, 0.663416,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472403,-99) , 
3, -0.0702086, 0, 0, 0.644219,-99) , 
NN(
0, 
0, 
-1, -0.611939, 0, -1, 0.450226,-99) , 
1, -0.799791, 1, 0, 0.491359,-99) , 
3, 1.6156, 0, 0, 0.533429,-99)    );
  // itree = 818
  fBoostWeights.push_back(0.23138);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398625,-99) , 
1, -1.20214, 0, 0, 0.632857,-99) , 
NN(
0, 
0, 
-1, 1.21968, 0, -1, 0.388172,-99) , 
1, 0.974456, 1, 0, 0.568726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73792,-99) , 
NN(
0, 
0, 
-1, 1.93466, 1, -1, 0.417308,-99) , 
1, -1.64443, 1, 0, 0.433594,-99) , 
3, 1.03886, 0, 0, 0.492593,-99)    );
  // itree = 819
  fBoostWeights.push_back(0.223479);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317811,-99) , 
2, 1.59914, 1, 0, 0.569593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191068,-99) , 
3, -1.29199, 0, 0, 0.552872,-99) , 
NN(
0, 
0, 
-1, 2.95591, 0, -1, 0.245851,-99) , 
2, 1.80513, 1, 0, 0.528436,-99)    );
  // itree = 820
  fBoostWeights.push_back(0.275412);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417624,-99) , 
3, -0.0109085, 0, 0, 0.625771,-99) , 
NN(
0, 
0, 
-1, 1.21975, 1, -1, 0.340254,-99) , 
0, 2.74594, 1, 0, 0.567118,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601516,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434753,-99) , 
3, 0.975754, 0, 0, 0.495113,-99) , 
NN(
0, 
0, 
-1, 0.814268, 0, -1, 0.32483,-99) , 
1, 0.0177365, 1, 0, 0.42647,-99) , 
1, 0.718787, 0, 0, 0.463286,-99)    );
  // itree = 821
  fBoostWeights.push_back(0.228872);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.129066, 0, 1, 0.710188,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289281,-99) , 
1, 1.15803, 1, 0, 0.506441,-99) , 
3, 0.294948, 0, 0, 0.552992,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360477,-99) , 
1, -0.420956, 0, 0, 0.490013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0518543,-99) , 
3, 0.958375, 0, 0, 0.442008,-99) , 
0, 1.03966, 1, 0, 0.505586,-99)    );
  // itree = 822
  fBoostWeights.push_back(0.231049);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.879448,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.115671,-99) , 
0, 4.36414, 1, 0, 0.586119,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424539,-99) , 
2, -0.486121, 1, 0, 0.463568,-99) , 
1, 0.232239, 1, 0, 0.52816,-99) , 
1, 1.96083, 0, 0, 0.54136,-99)    );
  // itree = 823
  fBoostWeights.push_back(0.284615);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459653,-99) , 
2, 0.16146, 1, 0, 0.516754,-99) , 
NN(
0, 
0, 
-1, -1.58459, 0, -1, 0.377927,-99) , 
2, -0.242286, 0, 0, 0.468886,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245917,-99) , 
1, -1.55287, 0, 0, 0.497282,-99) , 
NN(
0, 
0, 
-1, -0.128702, 1, -1, 0.255327,-99) , 
1, -1.14804, 1, 0, 0.339851,-99) , 
1, -0.472426, 0, 0, 0.434469,-99)    );
  // itree = 824
  fBoostWeights.push_back(0.341794);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.998858, 0, 1, 0.707416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36344,-99) , 
3, -0.139853, 1, 0, 0.55995,-99) , 
1, -0.32221, 0, 0, 0.650079,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172056,-99) , 
0, 4.12974, 1, 0, 0.559446,-99) , 
NN(
0, 
0, 
-1, 0.806267, 1, -1, 0.35876,-99) , 
3, 2.0057, 0, 0, 0.406155,-99) , 
0, 0.394028, 1, 0, 0.507529,-99)    );
  // itree = 825
  fBoostWeights.push_back(0.238098);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84886,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44868,-99) , 
1, -0.211126, 1, 0, 0.521868,-99) , 
3, 1.89769, 0, 0, 0.545252,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370351,-99) , 
1, 0.110309, 1, 0, 0.45074,-99) , 
NN(
0, 
0, 
-1, 1.57957, 1, -1, 0.171618,-99) , 
2, 1.8394, 0, 0, 0.312026,-99) , 
0, 2.82704, 1, 0, 0.505059,-99)    );
  // itree = 826
  fBoostWeights.push_back(0.316741);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.479161, 1, 1, 0.704326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423569,-99) , 
3, 1.30362, 0, 0, 0.565351,-99) , 
2, 0.454775, 1, 0, 0.615859,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324213,-99) , 
0, -2.99809, 1, 0, 0.397134,-99) , 
1, 1.2625, 0, 0, 0.443667,-99) , 
3, -0.316527, 0, 0, 0.575533,-99)    );
  // itree = 827
  fBoostWeights.push_back(0.233407);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.218644, 1, 1, 0.666259,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438002,-99) , 
2, 1.91688, 0, 0, 0.489693,-99) , 
0, 1.16982, 1, 0, 0.572034,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286567,-99) , 
0, -3.11797, 0, 0, 0.50051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235068,-99) , 
0, -0.626159, 1, 0, 0.44517,-99) , 
3, -0.133228, 0, 0, 0.531904,-99)    );
  // itree = 828
  fBoostWeights.push_back(0.155632);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279606,-99) , 
3, -1.76194, 0, 0, 0.539623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339951,-99) , 
1, 1.78879, 1, 0, 0.526253,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0591122,-99) , 
3, 3.41263, 0, 0, 0.306093,-99) , 
0, 3.79344, 1, 0, 0.510244,-99)    );
  // itree = 829
  fBoostWeights.push_back(0.213241);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464377,-99) , 
1, 0.413135, 1, 0, 0.538625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0395477,-99) , 
0, 4.56917, 1, 0, 0.522493,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354827,-99) , 
1, 0.0509554, 1, 0, 0.497108,-99) , 
NN(
0, 
0, 
-1, -0.989606, 0, -1, 0.204433,-99) , 
2, -1.12746, 1, 0, 0.319538,-99) , 
3, -0.613987, 0, 0, 0.487555,-99)    );
  // itree = 830
  fBoostWeights.push_back(0.326096);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.983074,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442803,-99) , 
2, -0.977056, 0, 0, 0.631641,-99) , 
2, 2.80805, 0, 0, 0.662646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359134,-99) , 
2, 1.24057, 1, 0, 0.527843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320765,-99) , 
1, -1.62264, 1, 0, 0.348063,-99) , 
3, 0.163853, 0, 0, 0.449294,-99) , 
1, 0.560452, 0, 0, 0.525964,-99)    );
  // itree = 831
  fBoostWeights.push_back(0.221781);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.168442, 0, 1, 0.652797,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422059,-99) , 
3, 1.37742, 0, 0, 0.502205,-99) , 
0, 0.553618, 1, 0, 0.570708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760573,-99) , 
NN(
0, 
0, 
-1, 2.21653, 1, -1, 0.398366,-99) , 
3, 2.42244, 0, 0, 0.419734,-99) , 
1, 0.0841905, 0, 0, 0.504092,-99)    );
  // itree = 832
  fBoostWeights.push_back(0.10429);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.50228, 1, 1, 0.531973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204564,-99) , 
3, -1.6442, 0, 0, 0.522065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215832,-99) , 
3, 2.7172, 1, 0, 0.507004,-99)    );
  // itree = 833
  fBoostWeights.push_back(0.200478);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0793563, 0, 1, 0.689742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244624,-99) , 
1, -2.06154, 0, 0, 0.602452,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260525,-99) , 
0, 3.54173, 1, 0, 0.504016,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198327,-99) , 
0, -0.103564, 1, 0, 0.334807,-99) , 
1, -0.335508, 0, 0, 0.470257,-99) , 
1, -0.796883, 1, 0, 0.493069,-99)    );
  // itree = 834
  fBoostWeights.push_back(0.212656);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3058,-99) , 
2, 2.42651, 1, 0, 0.653037,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432002,-99) , 
2, -1.24189, 1, 0, 0.450789,-99) , 
3, 1.68935, 0, 0, 0.483568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.119295,-99) , 
0, 4.78065, 1, 0, 0.474224,-99)    );
  // itree = 835
  fBoostWeights.push_back(0.270366);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05278, 1, 1, 0.641403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321626,-99) , 
0, -0.111733, 1, 0, 0.500466,-99) , 
3, 0.505231, 0, 0, 0.542391,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325844,-99) , 
0, 2.61311, 0, 0, 0.420806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197714,-99) , 
0, 4.09248, 1, 0, 0.388507,-99) , 
0, 1.85673, 1, 0, 0.488278,-99)    );
  // itree = 836
  fBoostWeights.push_back(0.269549);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427258,-99) , 
3, 0.74377, 0, 0, 0.605255,-99) , 
NN(
0, 
0, 
-1, 4.625, 1, -1, 0.420256,-99) , 
0, 1.64504, 1, 0, 0.48935,-99) , 
NN(
0, 
0, 
-1, 1.01352, 1, -1, 0.344876,-99) , 
3, 0.27076, 0, 0, 0.430725,-99)    );
  // itree = 837
  fBoostWeights.push_back(0.21852);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499759,-99) , 
2, 0.0504869, 1, 0, 0.571127,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228951,-99) , 
2, -0.718704, 1, 0, 0.409066,-99) , 
3, -0.115556, 0, 0, 0.517329,-99) , 
NN(
0, 
0, 
-1, 2.14673, 0, -1, 0.299715,-99) , 
0, 3.35955, 1, 0, 0.498481,-99)    );
  // itree = 838
  fBoostWeights.push_back(0.193044);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.972954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349938,-99) , 
3, 0.252047, 0, 0, 0.504784,-99) , 
0, -0.635467, 1, 0, 0.529152,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377818,-99) , 
3, -0.891657, 0, 0, 0.448323,-99) , 
NN(
0, 
0, 
-1, -0.173781, 1, -1, 0.305526,-99) , 
0, -1.09527, 1, 0, 0.392938,-99) , 
2, -0.411756, 0, 0, 0.493131,-99)    );
  // itree = 839
  fBoostWeights.push_back(0.240519);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362419,-99) , 
0, -1.79338, 0, 0, 0.58694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236434,-99) , 
1, 2.03054, 1, 0, 0.560329,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437819,-99) , 
2, -1.45827, 0, 0, 0.588192,-99) , 
NN(
0, 
0, 
-1, 2.77063, 1, -1, 0.395807,-99) , 
0, -1.23152, 1, 0, 0.428098,-99) , 
1, 0.213586, 0, 0, 0.485352,-99)    );
  // itree = 840
  fBoostWeights.push_back(0.202762);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.131373, 0, 1, 0.664068,-99) , 
NN(
NN(
0, 
0, 
-1, 0.321785, 1, 1, 0.573806,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209506,-99) , 
1, -0.384621, 1, 0, 0.380621,-99) , 
1, -0.181874, 0, 0, 0.516824,-99) , 
1, -1.01826, 1, 0, 0.535501,-99)    );
  // itree = 841
  fBoostWeights.push_back(0.363681);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439537,-99) , 
2, 1.57919, 1, 0, 0.675682,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15549,-99) , 
0, 0.135573, 1, 0, 0.49628,-99) , 
2, 0.360513, 0, 0, 0.578851,-99) , 
NN(
0, 
0, 
-1, 0.577024, 0, -1, 0.365954,-99) , 
1, 0.213586, 1, 0, 0.470737,-99)    );
  // itree = 842
  fBoostWeights.push_back(0.247795);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.829273, 1, 1, 0.573731,-99) , 
NN(
0, 
0, 
-1, 2.01286, 1, -1, 0.208248,-99) , 
0, 3.73922, 1, 0, 0.541881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225789,-99) , 
3, -0.441927, 0, 0, 0.299089,-99) , 
0, -2.93397, 1, 0, 0.358465,-99) , 
3, -0.170449, 0, 0, 0.490015,-99)    );
  // itree = 843
  fBoostWeights.push_back(0.149224);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.66333, 0, 1, 0.664974,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397962,-99) , 
2, 0.446795, 1, 0, 0.448844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0779325,-99) , 
0, 4.16699, 1, 0, 0.436569,-99) , 
1, -1.26741, 1, 0, 0.453323,-99)    );
  // itree = 844
  fBoostWeights.push_back(0.291991);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53286, 0, 1, 0.725947,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334847,-99) , 
0, 2.12653, 1, 0, 0.426369,-99) , 
1, -0.75066, 1, 0, 0.475069,-99) , 
NN(
0, 
0, 
-1, 0.311049, 1, -1, 0.356975,-99) , 
2, 0.903798, 0, 0, 0.399766,-99)    );
  // itree = 845
  fBoostWeights.push_back(0.2907);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.868918, 1, 1, 0.635558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145103,-99) , 
3, -1.55116, 0, 0, 0.602266,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374759,-99) , 
0, 0.344553, 0, 0, 0.560495,-99) , 
NN(
0, 
0, 
-1, 1.48095, 0, -1, 0.380361,-99) , 
0, 1.34109, 1, 0, 0.450481,-99) , 
2, 0.114479, 1, 0, 0.510326,-99)    );
  // itree = 846
  fBoostWeights.push_back(0.162088);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1675, 1, 1, 0.801684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392826,-99) , 
0, 4.02962, 0, 0, 0.600368,-99) , 
1, 0.525278, 1, 0, 0.715175,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335201,-99) , 
0, 2.21684, 1, 0, 0.492487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215625,-99) , 
2, -1.57776, 0, 0, 0.47881,-99) , 
2, 1.43759, 0, 0, 0.513956,-99)    );
  // itree = 847
  fBoostWeights.push_back(0.235135);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24129, 1, 1, 0.742864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388333,-99) , 
1, 0.212582, 0, 0, 0.466729,-99) , 
3, 1.49106, 0, 0, 0.523474,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145364,-99) , 
1, 0.191948, 1, 0, 0.324851,-99) , 
0, 3.3388, 1, 0, 0.507517,-99)    );
  // itree = 848
  fBoostWeights.push_back(0.328654);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450345,-99) , 
2, 1.39273, 1, 0, 0.66537,-99) , 
NN(
0, 
0, 
-1, -1.04406, 1, -1, 0.336615,-99) , 
3, -0.964012, 0, 0, 0.604496,-99) , 
NN(
NN(
0, 
0, 
-1, 2.91829, 1, 1, 0.639787,-99) , 
NN(
0, 
0, 
-1, 0.801278, 1, -1, 0.350315,-99) , 
3, 1.8429, 0, 0, 0.423792,-99) , 
1, -0.102661, 1, 0, 0.491249,-99)    );
  // itree = 849
  fBoostWeights.push_back(0.224788);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89859, 0, 1, 0.728632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368476,-99) , 
1, -1.83171, 0, 0, 0.663929,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484297,-99) , 
0, 1.26691, 1, 0, 0.535701,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395882,-99) , 
1, 1.30523, 0, 0, 0.429966,-99) , 
3, 0.828289, 0, 0, 0.481883,-99) , 
1, -0.835874, 1, 0, 0.514309,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
