// Class: ReadCutsD
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Cuts::CutsD
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:54:11 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VarTransform: "Decorrelate" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
FitMethod: "MC" [Minimisation Method (GA, SA, and MC are the primary methods to be used; the others have been introduced for testing purposes and are depreciated)]
EffMethod: "EffSel" [Selection Method]
# Default:
VerbosityLevel: "Default" [Verbosity level]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
CutRangeMin[0]: "-1.000000e+00" [Minimum of allowed cut range (set per variable)]
    CutRangeMin[1]: "-1.000000e+00"
    CutRangeMin[2]: "-1.000000e+00"
    CutRangeMin[3]: "-1.000000e+00"
CutRangeMax[0]: "-1.000000e+00" [Maximum of allowed cut range (set per variable)]
    CutRangeMax[1]: "-1.000000e+00"
    CutRangeMax[2]: "-1.000000e+00"
    CutRangeMax[3]: "-1.000000e+00"
VarProp[0]: "FSmart" [Categorisation of cuts]
    VarProp[1]: "FSmart"
    VarProp[2]: "FSmart"
    VarProp[3]: "FSmart"
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadCutsD : public IClassifierReader {

 public:

   // constructor
   ReadCutsD( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadCutsD" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -5.64005947113037;
      fVmax[0] = 4.8529167175293;
      fVmin[1] = -2.92915463447571;
      fVmax[1] = 3.70650386810303;
      fVmin[2] = -4.17918729782104;
      fVmax[2] = 3.51799082756042;
      fVmin[3] = -3.33631753921509;
      fVmax[3] = 3.39626932144165;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadCutsD() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   double fDecTF_1[3][4][4];
   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   // not implemented for class: "ReadCutsD"
};
inline double ReadCutsD::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         std::vector<double> iV(inputValues);
         Transform( iV, -1 );
         retval = GetMvaValue__( iV );
   }

   return retval;
}

//_______________________________________________________________________
inline void ReadCutsD::InitTransform_1()
{
   // Decorrelation transformation, initialisation
   fDecTF_1[0][0][0] = 1.2722714631;
   fDecTF_1[0][0][1] = 0.0686064444285;
   fDecTF_1[0][0][2] = -0.12911102307;
   fDecTF_1[0][0][3] = -1.09274831745;
   fDecTF_1[0][1][0] = 0.0686064444285;
   fDecTF_1[0][1][1] = 0.955508716631;
   fDecTF_1[0][1][2] = 0.160135175699;
   fDecTF_1[0][1][3] = -0.260395275481;
   fDecTF_1[0][2][0] = -0.12911102307;
   fDecTF_1[0][2][1] = 0.160135175699;
   fDecTF_1[0][2][2] = 1.82502263962;
   fDecTF_1[0][2][3] = -0.851610263797;
   fDecTF_1[0][3][0] = -1.09274831745;
   fDecTF_1[0][3][1] = -0.260395275481;
   fDecTF_1[0][3][2] = -0.851610263797;
   fDecTF_1[0][3][3] = 2.83594069875;
   fDecTF_1[1][0][0] = 1.25494894161;
   fDecTF_1[1][0][1] = 0.0623620720116;
   fDecTF_1[1][0][2] = -0.196685390931;
   fDecTF_1[1][0][3] = -1.08407302428;
   fDecTF_1[1][1][0] = 0.0623620720116;
   fDecTF_1[1][1][1] = 0.989421920502;
   fDecTF_1[1][1][2] = 0.225698355104;
   fDecTF_1[1][1][3] = -0.268869598248;
   fDecTF_1[1][2][0] = -0.196685390931;
   fDecTF_1[1][2][1] = 0.225698355104;
   fDecTF_1[1][2][2] = 1.81274154375;
   fDecTF_1[1][2][3] = -0.812605958671;
   fDecTF_1[1][3][0] = -1.08407302428;
   fDecTF_1[1][3][1] = -0.268869598248;
   fDecTF_1[1][3][2] = -0.812605958671;
   fDecTF_1[1][3][3] = 2.87018256874;
   fDecTF_1[2][0][0] = 1.14762966212;
   fDecTF_1[2][0][1] = 0.0279230119711;
   fDecTF_1[2][0][2] = -0.199814116336;
   fDecTF_1[2][0][3] = -0.828429139126;
   fDecTF_1[2][1][0] = 0.0279230119711;
   fDecTF_1[2][1][1] = 0.95469118273;
   fDecTF_1[2][1][2] = 0.185805400506;
   fDecTF_1[2][1][3] = -0.162300136235;
   fDecTF_1[2][2][0] = -0.199814116336;
   fDecTF_1[2][2][1] = 0.185805400506;
   fDecTF_1[2][2][2] = 1.79132300554;
   fDecTF_1[2][2][3] = -0.772313501682;
   fDecTF_1[2][3][0] = -0.828429139126;
   fDecTF_1[2][3][1] = -0.162300136235;
   fDecTF_1[2][3][2] = -0.772313501682;
   fDecTF_1[2][3][3] = 2.19181433911;
}

//_______________________________________________________________________
inline void ReadCutsD::Transform_1( std::vector<double>& iv, int cls) const
{
   // Decorrelation transformation
   if (cls < 0 || cls > 2) {
       if (2 > 1 ) cls = 2;
       else cls = 2;
   }

   // define the indices of the variables which are transformed by this transformation
   static std::vector<int> indicesGet;
   static std::vector<int> indicesPut;

   if ( indicesGet.empty() ) {
      indicesGet.reserve(fNvars);
      indicesGet.push_back( 0);
      indicesGet.push_back( 1);
      indicesGet.push_back( 2);
      indicesGet.push_back( 3);
   }
   if ( indicesPut.empty() ) {
      indicesPut.reserve(fNvars);
      indicesPut.push_back( 0);
      indicesPut.push_back( 1);
      indicesPut.push_back( 2);
      indicesPut.push_back( 3);
   }

   std::vector<double> tv;
   for (int i=0; i<4;i++) {
      double v = 0;
      for (int j=0; j<4; j++)
         v += iv[indicesGet.at(j)] * fDecTF_1[cls][i][j];
      tv.push_back(v);
   }
   for (int i=0; i<4;i++) iv[indicesPut.at(i)] = tv[i];
}

//_______________________________________________________________________
inline void ReadCutsD::InitTransform()
{
   InitTransform_1();
}

//_______________________________________________________________________
inline void ReadCutsD::Transform( std::vector<double>& iv, int sigOrBgd ) const
{
   Transform_1( iv, sigOrBgd );
}
