// Class: ReadLikelihood
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::Likelihood
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:54:11 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "True" [Print method-specific help message]
TransformOutput: "True" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <math.h>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihood : public IClassifierReader {

 public:

   // constructor
   ReadLikelihood( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihood" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadLikelihood() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[4]; 
   int    fNbin[4]; // number of bins (discrete variables may have less bins)
   double    fHistMin[4]; 
   double    fHistMax[4]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihood::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = -9.33803939819336;
   fHistMax[0] = 7.69307804107666;
   fNbin[1] = 10000;
   fHistMin[1] = -3.25508260726929;
   fHistMax[1] = 4.02912044525146;
   fNbin[2] = 10000;
   fHistMin[2] = -5.27774286270142;
   fHistMax[2] = 4.64297914505005;
   fNbin[3] = 10000;
   fHistMin[3] = -5.60070276260376;
   fHistMax[3] = 4.67435789108276;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
}

inline double ReadLikelihood::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihood: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihood::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (true) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihood::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihood::fRefS[][10000] = 
{ 
   { 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 0.000905856664758176, 1.31897559185745e-06, 3.94239441448008e-06, 6.58178487356054e-06, 9.24424239201471e-06, 1.19227061077254e-05, 1.46100474012201e-05, 1.73213629750535e-05, 2.0047777070431e-05, 2.28114986384753e-05, 2.55840986937983e-05, 2.83655754174106e-05, 3.11639305436984e-05, 3.39827165589668e-05, 3.68192559108138e-05, 3.96726572944317e-05, 4.2541156290099e-05, 4.54265536973253e-05, 4.83350158901885e-05, 5.1258597522974e-05, 5.42061352462042e-05, 5.71625641896389e-05, 6.01420797465835e-05, 6.31509174127132e-05, 6.61624144413508e-05, 6.91898967488669e-05, 7.22404583939351e-05, 7.52999039832503e-05, 7.83895593485795e-05, 8.14880622783676e-05, 8.46096809254959e-05, 8.77472921274602e-05, 9.08991059986874e-05, 9.4076654931996e-05, 9.72551060840487e-05, 0.000100463745184243, 0.000103688376839273, 0.000106943210994359, 0.000110207809484564, 0.000113487505586818, 0.000116783172416035, 0.000120088625408243, 0.000123417165013961, 0.000126768791233189, 0.000130135507788509, 0.000133519119117409, 0.000136925809783861, 0.000140340489451773, 0.000143779150675982, 0.000147233775351197, 0.000150724852574058, 0.000154205234139226, 0.000157714064698666, 0.00016124063404277, 0.000164779659826308, 0.00016834533016663, 0.000171918945852667, 0.000175522800418548, 0.000179135546204634, 0.00018276424088981, 0.000186409815796651, 0.00019007759692613, 0.000193761370610446, 0.000197462009964511, 0.000201184855541214, 0.000204937896342017, 0.000208686484256759, 0.000212464423384517, 0.000216260086745024, 0.000220062851440161, 0.000223882496356964, 0.00022772436204832, 0.000231590165640227, 0.000235470215557143, 0.000239360932027921, 0.000243280912400223, 0.000247210671659559, 0.000251163524808362, 0.000255133287282661, 0.000259124353760853, 0.000263125140918419, 0.000267142808297649, 0.000271181808784604, 0.000275238591711968, 0.000279310479527339, 0.000283405417576432, 0.000287510134512559, 0.000291629956336692, 0.000295772886602208, 0.000299939740216359, 0.000304121756926179, 0.000308320595650002, 0.000312534568365663, 0.000316779594868422, 0.0003210335271433, 0.000325286557199433, 0.000329572445480153, 0.000333881383994594, 0.000338199286488816, 0.000342539336998016, 0.00034689626772888, 0.000351269205566496, 0.000355665222741663, 0.000360070116585121, 0.00036449811886996, 0.000368934968719259, 0.000373417104128748, 0.000377893069526181, 0.000382392114261165, 0.00038690710789524, 0.000391438108636066, 0.000395993090933189, 0.000400563178118318, 0.000405149214202538, 0.000409743253840134, 0.000414361333241686, 0.000419003335991874, 0.000423660443630069, 0.000428333558375016, 0.000433031498687342, 0.000437743670772761, 0.000442479795310646, 0.00044721775338985, 0.000451977859484032, 0.000456762005342171, 0.000461562070995569, 0.000466378143755719, 0.00047121022362262, 0.000476065353723243, 0.000480929389595985, 0.00048580946167931, 0.000490712525788695, 0.000495638756547123, 0.000500580936204642, 0.000505547097418457, 0.000510521233081818, 0.000515516672749072, 0.00052052375394851, 0.000525552954059094, 0.000530591059941798, 0.000535653089173138, 0.000540737353730947, 0.000545831397175789, 0.000550954777281731, 0.000556087936274707, 0.000561237044166774, 0.000566409202292562, 0.000571596494410187, 0.000576814927626401, 0.00058202794753015, 0.000587271235417575, 0.000592530472204089, 0.000597805599682033, 0.000603096792474389, 0.000608411151915789, 0.00061373965581879, 0.000619085971266031, 0.000624448177404702, 0.000629819289315492, 0.00063522148411721, 0.000640638812910765, 0.000646086293272674, 0.000651536451186985, 0.000657008844427764, 0.000662497186567634, 0.000668002408929169, 0.000673522765282542, 0.000679052784107625, 0.000684619357343763, 0.000690188491716981, 0.000695787894073874, 0.000701396202202886, 0.000707026571035385, 0.000712673936504871, 0.000718330091331154, 0.000724009412806481, 0.000729725114069879, 0.000735442619770765, 0.000741176074370742, 0.000746927282307297, 0.000752700725570321, 0.000758489244617522, 0.000764295517001301, 0.000770116923376918, 0.000775955151766539, 0.000781808572355658, 0.000787685043178499, 0.0007935845060274, 0.000799493805970997, 0.000805439543910325, 0.000811387901194394, 0.000817351450677961, 0.000823331822175533, 0.000829327269457281, 0.000835339596960694, 0.000841374974697828, 0.000847430841531605, 0.000853505334816873, 0.0008595886756666, 0.000865695124957711, 0.000871824740897864, 0.000877962214872241, 0.00088412465993315, 0.000890294148121029, 0.000896501878742129, 0.000902712228707969, 0.000909631955437362, 0.00091717712348327, 0.00092477910220623, 0.00093238108092919, 0.00094007549341768, 0.00094776984769851, 0.000955506751779467, 0.000963307684287429, 0.000971115718130022, 0.000979001983068883, 0.000986930797807872, 0.000994873698800802, 0.00100287364330143, 0.00101090199314058, 0.00101896561682224, 0.0010270862840116, 0.00103524955920875, 0.00104344834107906, 0.00105168973095715, 0.00105994543991983, 0.0010682720458135, 0.00107664847746491, 0.00108501070644706, 0.00109347235411406, 0.00110196240711957, 0.00111045956145972, 0.00111905625090003, 0.00112763151992112, 0.00113629212137312, 0.00114498822949827, 0.00115369155537337, 0.00116247276309878, 0.00117128260899335, 0.00118010654114187, 0.0011890159221366, 0.00119794637430459, 0.00120689847972244, 0.00121592136565596, 0.00122494413517416, 0.0012340594548732, 0.00124321738258004, 0.00125234690494835, 0.00126157584600151, 0.00127083319239318, 0.00128011906053871, 0.0012894687242806, 0.00129883270710707, 0.00130825350061059, 0.00131770980078727, 0.00132720870897174, 0.00133675045799464, 0.00134633458219469, 0.00135594001039863, 0.00136563088744879, 0.00137532164808363, 0.00138505513314158, 0.00139485229738057, 0.00140464247670025, 0.00141451088711619, 0.00142444332595915, 0.00143435434438288, 0.00144435768015683, 0.00145438953768462, 0.00146444968413562, 0.00147456675767899, 0.00148469093255699, 0.00149490020703524, 0.00150513823609799, 0.00151540443766862, 0.00152572034858167, 0.00153607176616788, 0.00154645170550793, 0.00155690975952893, 0.00156736792996526, 0.00157787569332868, 0.00158844026736915, 0.00159901916049421, 0.00160966208204627, 0.00162036158144474, 0.0016310540959239, 0.00164182484149933, 0.00165265949908644, 0.00166345853358507, 0.00167436408810318, 0.00168525567278266, 0.00169623945839703, 0.0017072445480153, 0.00171826395671815, 0.0017293612472713, 0.0017404945101589, 0.00175163452513516, 0.00176286697387695, 0.00177411374170333, 0.00178538891486824, 0.00179673486854881, 0.00180808827280998, 0.00181951245758682, 0.00183096516411752, 0.00184243230614811, 0.00185397721361369, 0.00186556507833302, 0.00187715259380639, 0.00188882567454129, 0.00190049863886088, 0.00191223551519215, 0.00192402931861579, 0.00193582312203944, 0.00194768793880939, 0.00195960234850645, 0.00197153119370341, 0.00198353081941605, 0.00199554488062859, 0.00200759433209896, 0.00201971502974629, 0.00203182129189372, 0.00204402720555663, 0.00205625430680811, 0.00206848839297891, 0.00208080094307661, 0.00209317007102072, 0.00210553221404552, 0.00211796537041664, 0.00213042716495693, 0.00214293831959367, 0.0021555065177381, 0.00216808868572116, 0.00218070670962334, 0.00219338852912188, 0.00220608455128968, 0.00221885880455375, 0.00223165424540639, 0.00224446412175894, 0.00225735176354647, 0.00227024685591459, 0.00228321994654834, 0.00229621445760131, 0.00230922317132354, 0.00232233828864992, 0.00233547482639551, 0.00234860414639115, 0.00236180471256375, 0.00237501948140562, 0.00238831248134375, 0.00240166205912828, 0.00241499720141292, 0.00242841779254377, 0.00244186003692448, 0.00245533767156303, 0.00246886513195932, 0.00248243473470211, 0.00249604019336402, 0.00250969547778368, 0.00252335774712265, 0.00253709102980793, 0.00255088112317026, 0.00256466446444392, 0.00257851858623326, 0.00259244372136891, 0.00260634021833539, 0.00262031517922878, 0.00263431831263006, 0.00264837150461972, 0.00266247428953648, 0.00267659849487245, 0.002690807916224, 0.00270503130741417, 0.00271926913410425, 0.00273357774131, 0.00274792220443487, 0.00276228063739836, 0.00277672428637743, 0.00279115396551788, 0.00280565465800464, 0.0028202049434185, 0.00283476989716291, 0.00284940539859235, 0.00286409049294889, 0.00287876138463616, 0.00289354636333883, 0.00290830293670297, 0.00292313052341342, 0.00293801445513964, 0.00295289186760783, 0.00296786148101091, 0.00298286648467183, 0.00299787148833275, 0.00301295449025929, 0.00302806636318564, 0.00304319942370057, 0.00305841024965048, 0.00307362875901163, 0.00308890361338854, 0.00310424971394241, 0.00311956717632711, 0.0031349912751466, 0.00315042282454669, 0.00316587556153536, 0.00318140629678965, 0.00319695821963251, 0.00321256020106375, 0.003228226210922, 0.00324387056753039, 0.00325961457565427, 0.00327538000419736, 0.00329115940257907, 0.00330702401697636, 0.00332291703671217, 0.0033388314768672, 0.00335480296052992, 0.00337078818120062, 0.00338683789595962, 0.00340295140631497, 0.00341904326342046, 0.00343523477204144, 0.00345145468600094, 0.0034676818177104, 0.00348397297784686, 0.00350029906257987, 0.00351667567156255, 0.00353308743797243, 0.00354953459464014, 0.00356605276465416, 0.00358258583582938, 0.0035991535987705, 0.00361578562296927, 0.00363243906758726, 0.00364912091754377, 0.0036658737808466, 0.00368262641131878, 0.00369945750571787, 0.00371633120812476, 0.00373319745995104, 0.0037501563783735, 0.00376713671721518, 0.00378417363390326, 0.00380123918876052, 0.00381832546554506, 0.00383547646924853, 0.00385267660021782, 0.00386989139951766, 0.00388714857399464, 0.00390448374673724, 0.00392180494964123, 0.00393921136856079, 0.00395663222298026, 0.00397408846765757, 0.00399161549285054, 0.00400914996862411, 0.00402674777433276, 0.00404441030696034, 0.00406205141916871, 0.00407977029681206, 0.00409750360995531, 0.00411531515419483, 0.0041331690736115, 0.00415103742852807, 0.00416894117370248, 0.00418693013489246, 0.00420489767566323, 0.00422294344753027, 0.00424103206023574, 0.00425914907827973, 0.00427732989192009, 0.00429553166031837, 0.00431375531479716, 0.00433206418529153, 0.00435036607086658, 0.00436873873695731, 0.00438715377822518, 0.00440557627007365, 0.0044240839779377, 0.00444259867072105, 0.00446116272360086, 0.0044797845184803, 0.00449841981753707, 0.00451711937785149, 0.00453587574884295, 0.00455463211983442, 0.00457343086600304, 0.00459230085834861, 0.00461117783561349, 0.00463012605905533, 0.00464911013841629, 0.00466810772195458, 0.00468719098716974, 0.00470623839646578, 0.00472539244219661, 0.00474458979442716, 0.00476377923041582, 0.00478305434808135, 0.00480235787108541, 0.00482170330360532, 0.00484109250828624, 0.0048605022020638, 0.0048799691721797, 0.00489947851747274, 0.00491901626810431, 0.00493860384449363, 0.00495823379606009, 0.00497789308428764, 0.00499760825186968, 0.00501735927537084, 0.00503713870421052, 0.00505700334906578, 0.00507683958858252, 0.00509674660861492, 0.00511671788990498, 0.00513668963685632, 0.00515673123300076, 0.00517678819596767, 0.00519690848886967, 0.00521708512678742, 0.00523724872618914, 0.00525748264044523, 0.0052777947857976, 0.00529809296131134, 0.00531844049692154, 0.00533884530887008, 0.00535928551107645, 0.00537978950887918, 0.00540030794218183, 0.00542085431516171, 0.00544147193431854, 0.00546208303421736, 0.00548279285430908, 0.005503517575562, 0.00552425533533096, 0.00554507272318006, 0.00556590408086777, 0.00558679131790996, 0.0056077353656292, 0.00562871573492885, 0.00564971007406712, 0.00567077565938234, 0.0056918547488749, 0.00571297667920589, 0.00573417777195573, 0.00575536349788308, 0.00577662093564868, 0.00579792121425271, 0.0058192415162921, 0.00584063353016973, 0.00586201203987002, 0.00588348926976323, 0.00590499490499496, 0.00592652196064591, 0.00594812026247382, 0.00596972554922104, 0.00599139463156462, 0.00601309956982732, 0.00603481894358993, 0.00605660118162632, 0.00607844162732363, 0.00610028067603707, 0.00612219190225005, 0.00614414503797889, 0.00616611260920763, 0.00618815887719393, 0.00621021166443825, 0.00623232824727893, 0.00625448068603873, 0.00627666851505637, 0.00629890616983175, 0.00632117222994566, 0.00634348066523671, 0.00636583939194679, 0.00638821860775352, 0.00641064811497927, 0.00643313443288207, 0.00645564962178469, 0.00647818529978395, 0.00650077778846025, 0.00652341358363628, 0.00654609175398946, 0.00656881276518106, 0.00659158360213041, 0.006614382378757, 0.00663721654564142, 0.00666010053828359, 0.00668301992118359, 0.00670597516000271, 0.00672898720949888, 0.00675202067941427, 0.00677509652450681, 0.0067982217296958, 0.00682139070704579, 0.00684458017349243, 0.00686784833669662, 0.00689115142449737, 0.00691445404663682, 0.00693782884627581, 0.00696123903617263, 0.00698468368500471, 0.0070081795565784, 0.00703168893232942, 0.0070552765391767, 0.00707887066528201, 0.00710254395380616, 0.00712623028084636, 0.00714996736496687, 0.00717373983934522, 0.00719756167382002, 0.00722141191363335, 0.00724531896412373, 0.00726924696937203, 0.00729321129620075, 0.00731725385412574, 0.00734131736680865, 0.00736540229991078, 0.00738953659310937, 0.00741372816264629, 0.00743793323636055, 0.00746221048757434, 0.00748650822788477, 0.00751086324453354, 0.00753523968160152, 0.00755967292934656, 0.00758414063602686, 0.00760864419862628, 0.00763319153338671, 0.00765778077766299, 0.00768241938203573, 0.00770708685740829, 0.00773179763928056, 0.00775651400908828, 0.00778134493157268, 0.00780615443363786, 0.0078310277312994, 0.00785593036562204, 0.0078809168189764, 0.00790589675307274, 0.00793093349784613, 0.00795601308345795, 0.0079811355099082, 0.00800627935677767, 0.00803148653358221, 0.00805671513080597, 0.00808200053870678, 0.00810730736702681, 0.00813267752528191, 0.00815808493643999, 0.00818351935595274, 0.00820902455598116, 0.00823453720659018, 0.00826012156903744, 0.00828571897000074, 0.00831134617328644, 0.00833702273666859, 0.00836278405040503, 0.00838852487504482, 0.00841432809829712, 0.00844018254429102, 0.00846606399863958, 0.00849200319498777, 0.00851797126233578, 0.00854398123919964, 0.00857004150748253, 0.00859613716602325, 0.00862227473407984, 0.00864844862371683, 0.00867466535419226, 0.00870093051344156, 0.00872719660401344, 0.00875356234610081, 0.0087799271568656, 0.00880634225904942, 0.00883278623223305, 0.00885930750519037, 0.00888582970947027, 0.00891240779310465, 0.00893904361873865, 0.00896570738404989, 0.00899241399019957, 0.00901916995644569, 0.00904594082385302, 0.00907278154045343, 0.00909963715821505, 0.00912653561681509, 0.00915348436683416, 0.00918047502636909, 0.00920750759541988, 0.00923455506563187, 0.00926167983561754, 0.00928882043808699, 0.00931600295007229, 0.00934325717389584, 0.00937054492533207, 0.00939784850925207, 0.00942519400268793, 0.00945259723812342, 0.00948002096265554, 0.00950750894844532, 0.00953501835465431, 0.00956257153302431, 0.00959016382694244, 0.00961781665682793, 0.00964548159390688, 0.00967321824282408, 0.00970099028199911, 0.00972877629101276, 0.0097576268017292, 0.00978753622621298, 0.00981750432401896, 0.00984748639166355, 0.00987755320966244, 0.00990764796733856, 0.00993782933801413, 0.00996802374720573, 0.00999830383807421, 0.0100285969674587, 0.0100589627400041, 0.0100893573835492, 0.0101198218762875, 0.0101503301411867, 0.0101808942854404, 0.0102115152403712, 0.010242179967463, 0.0102729136124253, 0.0103036621585488, 0.0103344675153494, 0.0103653315454721, 0.010396278463304, 0.0104272263124585, 0.0104582319036126, 0.0104892924427986, 0.010520426556468, 0.0105515876784921, 0.0105827897787094, 0.0106140794232488, 0.0106453839689493, 0.010676771402359, 0.0107081877067685, 0.0107396766543388, 0.0107711916789412, 0.0108027514070272, 0.0108343670144677, 0.0108660683035851, 0.010897783562541, 0.0109295407310128, 0.0109613845124841, 0.0109932571649551, 0.0110251698642969, 0.0110571561381221, 0.0110891833901405, 0.011121267452836, 0.01115339435637, 0.0111855501309037, 0.0112177785485983, 0.011250089854002, 0.0112824300304055, 0.0113147851079702, 0.0113472389057279, 0.0113797066733241, 0.0114122470840812, 0.0114448145031929, 0.0114774676039815, 0.0115101346746087, 0.0115428734570742, 0.0115756541490555, 0.0116084925830364, 0.0116413589566946, 0.0116743240505457, 0.011707304045558, 0.0117403268814087, 0.0117734344676137, 0.0118065709248185, 0.0118397632613778, 0.0118729984387755, 0.0119063062593341, 0.0119396131485701, 0.0119730327278376, 0.0120064672082663, 0.012039958499372, 0.0120734916999936, 0.012107097543776, 0.0121407313272357, 0.0121744219213724, 0.0122081832960248, 0.0122419875115156, 0.0122758187353611, 0.0123097086325288, 0.0123436683788896, 0.0123776439577341, 0.012411717325449, 0.0124458055943251, 0.012479935772717, 0.0125141385942698, 0.012548397295177, 0.0125827128067613, 0.0126170562580228, 0.0126514714211226, 0.0126859154552221, 0.0127204153686762, 0.0127549730241299, 0.0127895725890994, 0.0128242149949074, 0.0128589421510696, 0.0128936991095543, 0.0129284970462322, 0.0129633387550712, 0.0129982503131032, 0.0130332047119737, 0.0130682038143277, 0.0131032718345523, 0.0131383836269379, 0.0131735512986779, 0.0132087487727404, 0.0132440300658345, 0.0132793402299285, 0.0133147072046995, 0.013350117020309, 0.0133855836465955, 0.0134210782125592, 0.0134566295892, 0.0134922536090016, 0.0135279037058353, 0.0135636543855071, 0.0135994050651789, 0.0136352134868503, 0.0136710917577147, 0.0137069979682565, 0.0137429619207978, 0.0137789975851774, 0.0138150760903955, 0.0138511667028069, 0.0138873578980565, 0.0139235770329833, 0.0139598390087485, 0.0139961587265134, 0.0140325343236327, 0.0140689676627517, 0.0141054289415479, 0.0141419740393758, 0.01417853590101, 0.0142151527106762, 0.0142518412321806, 0.0142885446548462, 0.0143253318965435, 0.0143621629104018, 0.0143990218639374, 0.0144359664991498, 0.0144729521125555, 0.0145099693909287, 0.0145470835268497, 0.0145841846242547, 0.01462138351053, 0.0146585982292891, 0.0146958976984024, 0.014733225107193, 0.0147705962881446, 0.0148080382496119, 0.0148455360904336, 0.0148830357939005, 0.0149206183850765, 0.0149582726880908, 0.0149959279224277, 0.0150336967781186, 0.015071464702487, 0.0151093332096934, 0.0151472017168999, 0.0151851400732994, 0.0152231361716986, 0.015261160209775, 0.0152992540970445, 0.0153374066576362, 0.0153756020590663, 0.0154138244688511, 0.0154521334916353, 0.0154904704540968, 0.0155288632959127, 0.0155673278495669, 0.0156058073043823, 0.0156443286687136, 0.0156829487532377, 0.0157215856015682, 0.015760276466608, 0.0157990269362926, 0.0158378165215254, 0.0158766806125641, 0.0159155838191509, 0.0159545335918665, 0.0159935224801302, 0.0160325858741999, 0.0160716753453016, 0.0161108206957579, 0.0161500256508589, 0.0161892864853144, 0.0162285733968019, 0.0162679348140955, 0.0163073372095823, 0.0163467954844236, 0.0163862984627485, 0.0164258573204279, 0.0164654441177845, 0.0165051016956568, 0.0165448039770126, 0.016584575176239, 0.0166243892163038, 0.0166642460972071, 0.0167041458189487, 0.0167441181838512, 0.0167841166257858, 0.0168241877108812, 0.0168643146753311, 0.0169044565409422, 0.0169446542859077, 0.0169849377125502, 0.017025263980031, 0.0170656032860279, 0.0171060152351856, 0.0171464830636978, 0.0171870086342096, 0.0172275621443987, 0.0172681715339422, 0.0173088386654854, 0.017349548637867, 0.0173903442919254, 0.0174311678856611, 0.0174720194190741, 0.0175129417330027, 0.0175539068877697, 0.0175949297845364, 0.0176360085606575, 0.0176771320402622, 0.0177182964980602, 0.0177595168352127, 0.0178007949143648, 0.0178421437740326, 0.0178834944963455, 0.017924927175045, 0.0179664045572281, 0.0180079247802496, 0.0180494878441095, 0.018091106787324, 0.018132796511054, 0.0181745011359453, 0.0182163175195456, 0.0182581357657909, 0.018300024792552, 0.0183419436216354, 0.0183839313685894, 0.0184259638190269, 0.018468052148819, 0.0185101684182882, 0.0185523424297571, 0.0185945983976126, 0.0186368580907583, 0.0186791885644197, 0.0187215898185968, 0.0187640301883221, 0.0188064891844988, 0.0188490319997072, 0.0188916176557541, 0.0189342740923166, 0.0189769566059113, 0.0190197005867958, 0.0190624855458736, 0.019105326384306, 0.0191482231020927, 0.0191911514848471, 0.0192341636866331, 0.0192771758884192, 0.019320284947753, 0.0193634238094091, 0.0194066222757101, 0.0194498598575592, 0.0194931551814079, 0.019536480307579, 0.0195799190551043, 0.0196233261376619, 0.0196668226271868, 0.0197103749960661, 0.0197539832442999, 0.019797632470727, 0.0198413133621216, 0.0198850780725479, 0.0199288725852966, 0.019972737878561, 0.0200166124850512, 0.0200605764985085, 0.0201045554131269, 0.0201486311852932, 0.0201927088201046, 0.0202368889003992, 0.0202810931950808, 0.0203253421932459, 0.0203696303069592, 0.0204140227288008, 0.0204583965241909, 0.020502857863903, 0.0205473769456148, 0.0205919221043587, 0.0206365380436182, 0.0206811707466841, 0.0207259152084589, 0.0207706484943628, 0.0208154786378145, 0.0208603218197823, 0.020905252546072, 0.0209501963108778, 0.0209952257573605, 0.0210402701050043, 0.021085400134325, 0.0211305562406778, 0.0211757402867079, 0.0212210267782211, 0.0212663672864437, 0.0213117245584726, 0.0213571358472109, 0.0214026067405939, 0.021448090672493, 0.021493673324585, 0.0215393025428057, 0.0215849708765745, 0.0216306820511818, 0.0216764509677887, 0.021722262725234, 0.0217681434005499, 0.0218140669167042, 0.0218600332736969, 0.0219060443341732, 0.0219521280378103, 0.0219982750713825, 0.0220444016158581, 0.0220906510949135, 0.0221369452774525, 0.0221832543611526, 0.0222296193242073, 0.0222760699689388, 0.0223225355148315, 0.0223690699785948, 0.0224156472831964, 0.0224622711539268, 0.0225089453160763, 0.0225556679069996, 0.0226024705916643, 0.0226492937654257, 0.0226961988955736, 0.0227431170642376, 0.0227900799363852, 0.022837096825242, 0.022884214296937, 0.0229313187301159, 0.0229785237461329, 0.0230257548391819, 0.0230730418115854, 0.0231203753501177, 0.0231677480041981, 0.0232151802629232, 0.023262694478035, 0.0233102384954691, 0.0233577992767096, 0.0234054438769817, 0.0234531443566084, 0.0235009007155895, 0.0235486719757318, 0.0235965307801962, 0.0236444175243378, 0.0236923415213823, 0.023740341886878, 0.0237883999943733, 0.0238364692777395, 0.0238846223801374, 0.0239328220486641, 0.0239810608327389, 0.0240293722599745, 0.0240777023136616, 0.0241260956972837, 0.024174552410841, 0.0242230482399464, 0.0242715869098902, 0.0243201982229948, 0.0243688505142927, 0.0244175586849451, 0.0244662836194038, 0.0245151054114103, 0.0245639439672232, 0.0246128384023905, 0.0246618036180735, 0.0247107967734337, 0.0247598607093096, 0.024808956310153, 0.024858133867383, 0.0249073132872581, 0.0249565895646811, 0.0250058844685555, 0.0250552464276552, 0.0251046232879162, 0.0251541156321764, 0.0252036042511463, 0.0252531841397285, 0.0253027882426977, 0.0253524482250214, 0.0254021398723125, 0.0254519283771515, 0.0255017466843128, 0.0255515947937965, 0.0256015248596668, 0.0256514549255371, 0.0257015004754066, 0.0257515348494053, 0.0258016772568226, 0.0258518382906914, 0.0259020533412695, 0.0259523261338472, 0.0260026380419731, 0.0260529853403568, 0.0261033978313208, 0.0261538699269295, 0.0262044128030539, 0.0262549836188555, 0.0263055842369795, 0.0263562686741352, 0.0264069810509682, 0.0264577362686396, 0.0265085659921169, 0.0265594609081745, 0.0266103744506836, 0.0266613569110632, 0.0267123691737652, 0.0267634503543377, 0.0268145762383938, 0.0268657468259335, 0.0269169677048922, 0.0269682500511408, 0.0270195882767439, 0.0270709563046694, 0.027122363448143, 0.0271738730370998, 0.0272253956645727, 0.0272769629955292, 0.0273285992443562, 0.0273802783340216, 0.0274320002645254, 0.0274837929755449, 0.0275356434285641, 0.0275875218212605, 0.0276394430547953, 0.0276914201676846, 0.0277434699237347, 0.0277955606579781, 0.0278476793318987, 0.0278998706489801, 0.0279521048069, 0.0280044116079807, 0.0280567277222872, 0.0281091202050447, 0.0281615629792213, 0.0282140541821718, 0.0282665733247995, 0.0283191595226526, 0.0283718202263117, 0.028424508869648, 0.0284772552549839, 0.028530040755868, 0.0285828877240419, 0.0286357868462801, 0.0286887306720018, 0.0287417303770781, 0.0287947747856379, 0.0288478601723909, 0.0289010033011436, 0.028954204171896, 0.0290074609220028, 0.029060760512948, 0.0291141048073769, 0.0291674993932247, 0.0292209424078465, 0.0292744413018227, 0.0293279830366373, 0.0293816067278385, 0.0294352490454912, 0.0294889733195305, 0.0295426994562149, 0.029596509411931, 0.0296503640711308, 0.0297042727470398, 0.0297582112252712, 0.0298122372478247, 0.029866274446249, 0.0299203973263502, 0.0299745351076126, 0.0300287567079067, 0.0300830081105232, 0.0301373042166233, 0.0301916692405939, 0.0302460752427578, 0.0303005240857601, 0.0303550604730844, 0.030409624800086, 0.0304642170667648, 0.0305188950151205, 0.0305736009031534, 0.0306283626705408, 0.0306831821799278, 0.0307380314916372, 0.0307929366827011, 0.0308479275554419, 0.0309029296040535, 0.030958004295826, 0.0310144815593958, 0.0310720801353455, 0.0311297401785851, 0.0311874132603407, 0.0312451496720314, 0.0313029251992702, 0.031360749155283, 0.0314186103641987, 0.0314765125513077, 0.0315344370901585, 0.0315924249589443, 0.0316504649817944, 0.0317085161805153, 0.0317666456103325, 0.0318247899413109, 0.0318830087780952, 0.031941220164299, 0.0319995358586311, 0.0320578515529633, 0.0321162231266499, 0.0321746245026588, 0.0322330892086029, 0.0322915650904179, 0.0323501154780388, 0.0324086956679821, 0.0324673354625702, 0.0325259864330292, 0.0325846932828426, 0.0326434448361397, 0.0327022448182106, 0.0327610783278942, 0.0328199416399002, 0.032878864556551, 0.032937828451395, 0.0329968631267548, 0.033055879175663, 0.0331149995326996, 0.0331741236150265, 0.0332333035767078, 0.0332925170660019, 0.0333517901599407, 0.0334110856056213, 0.0334704220294952, 0.0335298255085945, 0.0335892476141453, 0.0336487405002117, 0.0337082520127296, 0.0337678045034409, 0.0338274128735065, 0.0338870622217655, 0.0339467413723469, 0.0340064764022827, 0.0340662561357021, 0.0341260656714439, 0.0341859273612499, 0.0342458114027977, 0.0343057848513126, 0.0343657545745373, 0.0344257727265358, 0.0344858393073082, 0.0345459654927254, 0.0346061177551746, 0.0346663184463978, 0.0347265489399433, 0.034786831587553, 0.0348471738398075, 0.0349075198173523, 0.0349679514765739, 0.0350284092128277, 0.0350889004766941, 0.0351494289934635, 0.0352100245654583, 0.0352706275880337, 0.0353313013911247, 0.0353920012712479, 0.035452775657177, 0.0355135500431061, 0.03557438403368, 0.0356352664530277, 0.0356962084770203, 0.0357571542263031, 0.0358181856572628, 0.0358792059123516, 0.0359403043985367, 0.0360014475882053, 0.0360626056790352, 0.0361238457262516, 0.0361850969493389, 0.0362464003264904, 0.0363077633082867, 0.0363691486418247, 0.0364305637776852, 0.0364920608699322, 0.0365535579621792, 0.0366151370108128, 0.036676712334156, 0.0367383770644665, 0.0368000492453575, 0.0368617996573448, 0.0369235426187515, 0.0369853787124157, 0.0370472371578217, 0.0371091365814209, 0.037171084433794, 0.0372330509126186, 0.0372950844466686, 0.0373571589589119, 0.0374192632734776, 0.0374814234673977, 0.0375436246395111, 0.0376058593392372, 0.0376681536436081, 0.0377304591238499, 0.0377928391098976, 0.0378552563488483, 0.0379176996648312, 0.0379802063107491, 0.0380427315831184, 0.0381053239107132, 0.0381679646670818, 0.0382306165993214, 0.0382933244109154, 0.0383560843765736, 0.0384188629686832, 0.0384816974401474, 0.0385445840656757, 0.0386075042188168, 0.0386704504489899, 0.0387334637343884, 0.0387965217232704, 0.038859598338604, 0.0389227382838726, 0.0389859229326248, 0.0390491411089897, 0.0391123853623867, 0.0391757115721703, 0.039239052683115, 0.0393024384975433, 0.0393658690154552, 0.0394293591380119, 0.039492879062891, 0.0395564362406731, 0.0396200120449066, 0.039683673530817, 0.0397473648190498, 0.0398110784590244, 0.0398748777806759, 0.039938673377037, 0.0400025434792042, 0.040066447108984, 0.040130365639925, 0.0401943661272526, 0.0402584001421928, 0.0403224676847458, 0.0403865873813629, 0.040450744330883, 0.0405149273574352, 0.0405791811645031, 0.0406434535980225, 0.0407077744603157, 0.0407721437513828, 0.0408365465700626, 0.0409009978175163, 0.0409655012190342, 0.041030041873455, 0.0410946197807789, 0.0411592349410057, 0.0412239283323288, 0.041288610547781, 0.0413533747196198, 0.04141815751791, 0.0414830073714256, 0.0415478721261024, 0.041612796485424, 0.0416777618229389, 0.0417427532374859, 0.0418078154325485, 0.0418728925287724, 0.0419380627572536, 0.0420032106339931, 0.0420684404671192, 0.0421337112784386, 0.0421990193426609, 0.0422643348574638, 0.0423297435045242, 0.0423951782286167, 0.0424606502056122, 0.0425261743366718, 0.0425917208194733, 0.0426573343575001, 0.042722973972559, 0.0427886620163918, 0.0428543798625469, 0.0429201535880566, 0.0429859645664692, 0.0430518388748169, 0.043117705732584, 0.0431836880743504, 0.043249636888504, 0.0433156788349152, 0.0433817617595196, 0.0434478595852852, 0.0435140132904053, 0.0435802191495895, 0.0436464473605156, 0.0437127389013767, 0.0437790676951408, 0.0438454188406467, 0.0439118519425392, 0.0439782924950123, 0.0440447852015495, 0.0441113188862801, 0.044177919626236, 0.0442445240914822, 0.0443112216889858, 0.0443779043853283, 0.0444446615874767, 0.0445114597678185, 0.0445782840251923, 0.0446451678872108, 0.0447120778262615, 0.0447790436446667, 0.0448460690677166, 0.0449131168425083, 0.0449801869690418, 0.0450473390519619, 0.0451145060360432, 0.0451817251741886, 0.0452489703893661, 0.0453162863850594, 0.0453836396336555, 0.0454510077834129, 0.0455184429883957, 0.045585922896862, 0.0456534400582314, 0.0457210093736649, 0.0457886084914207, 0.045856237411499, 0.0459239445626736, 0.0459916666150093, 0.0460594370961189, 0.0461272597312927, 0.0461951158940792, 0.0462630167603493, 0.0463309660553932, 0.0463989339768887, 0.0464669615030289, 0.0465350411832333, 0.0466031283140182, 0.0466713048517704, 0.0467394962906837, 0.0468077287077904, 0.0468760207295418, 0.0469443537294865, 0.0470127314329147, 0.0470811277627945, 0.0471495687961578, 0.047218069434166, 0.0472866035997868, 0.047355193644762, 0.0474238134920597, 0.047492478042841, 0.0475611984729767, 0.047629926353693, 0.047698725014925, 0.0477675572037697, 0.0478364452719688, 0.0479053519666195, 0.0479743331670761, 0.0480433218181133, 0.0481123737990856, 0.0481814667582512, 0.0482506044209003, 0.0483197830617428, 0.0483889877796173, 0.0484582595527172, 0.0485275648534298, 0.0485969111323357, 0.0486662834882736, 0.0487357378005981, 0.0488052032887936, 0.0488747358322144, 0.0489442832767963, 0.0490138828754425, 0.049083523452282, 0.0491532236337662, 0.0492229349911213, 0.0492927208542824, 0.0493625365197659, 0.0494323819875717, 0.0495022870600224, 0.0495722182095051, 0.0496422126889229, 0.0497122257947922, 0.0497823096811771, 0.0498524084687233, 0.0499225780367851, 0.049992773681879, 0.0500630065798759, 0.0501332767307758, 0.0502036176621914, 0.0502739809453487, 0.05034439265728, 0.0504148527979851, 0.0504853278398514, 0.0505558736622334, 0.0506264604628086, 0.0506970807909966, 0.0507677271962166, 0.0508384481072426, 0.050909198820591, 0.0509800054132938, 0.0510508231818676, 0.0511217005550861, 0.0511926338076591, 0.0512636005878448, 0.0513345934450626, 0.0514056496322155, 0.051476739346981, 0.0515478700399399, 0.0516190566122532, 0.0516902655363083, 0.0517615377902985, 0.0518328361213207, 0.0519041791558266, 0.0519755594432354, 0.0520470067858696, 0.0521184653043747, 0.0521899834275246, 0.0522615313529968, 0.0523331463336945, 0.0524047873914242, 0.0524764657020569, 0.0525482036173344, 0.0526199601590633, 0.0526917763054371, 0.0527636334300041, 0.0528355464339256, 0.0529074780642986, 0.0529794730246067, 0.053051482886076, 0.0531235747039318, 0.0531956739723682, 0.05326784029603, 0.0533400252461433, 0.0534122660756111, 0.0534845441579819, 0.0535568743944168, 0.053629245609045, 0.0537016540765762, 0.053774107247591, 0.0538465939462185, 0.053919143974781, 0.0539917126297951, 0.0540643371641636, 0.0541370064020157, 0.0542097203433514, 0.0542824566364288, 0.0543552674353123, 0.0544280856847763, 0.054500974714756, 0.0545738749206066, 0.0546468570828438, 0.0547198504209518, 0.0547928921878338, 0.0548659861087799, 0.0549391098320484, 0.055012296885252, 0.0550855100154877, 0.0551587902009487, 0.0552320703864098, 0.055305439978838, 0.0553788058459759, 0.0554522462189198, 0.0555257275700569, 0.0555992387235165, 0.0556728020310402, 0.0557463876903057, 0.055820032954216, 0.0558937229216099, 0.0559674613177776, 0.0560412183403969, 0.0561150498688221, 0.0561888925731182, 0.0562627874314785, 0.0563367269933224, 0.0564107224345207, 0.0564847514033318, 0.0565588288009167, 0.0566329322755337, 0.0567070730030537, 0.0567812845110893, 0.0568555295467377, 0.0569297969341278, 0.0570041202008724, 0.0570784993469715, 0.0571528896689415, 0.0572273395955563, 0.0573018491268158, 0.0573763847351074, 0.0574509464204311, 0.0575255863368511, 0.0576002486050129, 0.057674951851368, 0.0577497072517872, 0.0578244999051094, 0.0578993372619152, 0.0579742081463337, 0.0580491311848164, 0.0581240989267826, 0.0581990964710712, 0.0582741424441338, 0.0583492442965508, 0.0584243647754192, 0.058499563485384, 0.058574765920639, 0.0586500316858292, 0.0587253384292126, 0.058800682425499, 0.058876059949398, 0.0589514933526516, 0.0590269602835178, 0.0591024905443192, 0.0591780506074429, 0.0592536367475986, 0.0593292787671089, 0.0594049580395222, 0.0594807006418705, 0.0595564655959606, 0.0596322752535343, 0.0597081370651722, 0.0597840435802937, 0.0598599687218666, 0.0599359720945358, 0.0600119829177856, 0.0600880533456802, 0.0601641722023487, 0.0602403171360493, 0.0603165104985237, 0.0603927485644817, 0.0604690387845039, 0.0605453476309776, 0.0606217384338379, 0.0606981329619884, 0.0607745945453644, 0.060851089656353, 0.0609276257455349, 0.0610042102634907, 0.0610808320343494, 0.0611574798822403, 0.0612341947853565, 0.061310950666666, 0.0613877438008785, 0.0614645704627037, 0.0615414418280125, 0.0616183690726757, 0.0616953372955322, 0.0617723353207111, 0.0618493780493736, 0.0619264841079712, 0.0620036050677299, 0.0620807819068432, 0.0621579885482788, 0.0622352547943592, 0.062312550842762, 0.0623899027705193, 0.0624672994017601, 0.0625447183847427, 0.0626221969723701, 0.0626997053623199, 0.0627772733569145, 0.0628548711538315, 0.0629325211048126, 0.063010185956955, 0.0630879402160645, 0.063165694475174, 0.0632435008883476, 0.0633213818073273, 0.0633992627263069, 0.0634772107005119, 0.0635551959276199, 0.0636332184076309, 0.0637112855911255, 0.0637894049286842, 0.0638675391674042, 0.0639457553625107, 0.0640239715576172, 0.0641022697091103, 0.0641805827617645, 0.0642589628696442, 0.0643373727798462, 0.0644158273935318, 0.0644943118095398, 0.064572848379612, 0.0646514296531677, 0.0647300481796265, 0.0648087188601494, 0.0648874193429947, 0.0649661645293236, 0.0650449618697166, 0.0651256293058395, 0.0652082189917564, 0.0652908086776733, 0.0653734058141708, 0.0654560327529907, 0.06553865224123, 0.0656212866306305, 0.0657039359211922, 0.0657865926623344, 0.0658692419528961, 0.0659519284963608, 0.0660346075892448, 0.0661173239350319, 0.0662000179290771, 0.0662827268242836, 0.0663654506206512, 0.0664481744170189, 0.0665309131145477, 0.066613681614399, 0.0666964426636696, 0.0667792186141014, 0.0668619945645332, 0.0669447779655457, 0.0670275986194611, 0.0671104043722153, 0.0671932175755501, 0.0672760680317879, 0.0673588961362839, 0.0674417316913605, 0.0675246194005013, 0.067607469856739, 0.0676903650164604, 0.0677732452750206, 0.0678561553359032, 0.0679390653967857, 0.0680219829082489, 0.0681049078702927, 0.0681878477334976, 0.0682708024978638, 0.0683537721633911, 0.0684367343783379, 0.0685197114944458, 0.0686027035117149, 0.0686857029795647, 0.0687687024474144, 0.0688517317175865, 0.068934753537178, 0.0690177828073502, 0.0691008493304253, 0.0691838935017586, 0.0692669674754143, 0.0693500339984894, 0.0694331377744675, 0.0695162266492844, 0.0695993304252625, 0.0696824416518211, 0.0697655752301216, 0.0698487162590027, 0.069931872189045, 0.0700150206685066, 0.0700981765985489, 0.0701813623309135, 0.0702645480632782, 0.0703477337956429, 0.0704309493303299, 0.0705141648650169, 0.0705973729491234, 0.0706806182861328, 0.0707638636231422, 0.0708471238613129, 0.0709303766489029, 0.0710136517882347, 0.0710969492793083, 0.0711802318692207, 0.0712635293602943, 0.0713468566536903, 0.0714301690459251, 0.0715135186910629, 0.0715968608856201, 0.0716802030801773, 0.0717635676264763, 0.0718469396233559, 0.071930319070816, 0.072013720870018, 0.0720971152186394, 0.0721805244684219, 0.0722639486193657, 0.0723473653197289, 0.0724308267235756, 0.0725142732262611, 0.0725977346301079, 0.0726812109351158, 0.0727646872401237, 0.0728481709957123, 0.0729316845536232, 0.0730151832103729, 0.073098711669445, 0.0731822475790977, 0.0732657760381699, 0.0733493268489838, 0.0734328925609589, 0.0735164508223534, 0.0736000314354897, 0.0736836194992065, 0.073767215013504, 0.0738508328795433, 0.0739344507455826, 0.0740180760622025, 0.0741017237305641, 0.0741853639483452, 0.0742690339684486, 0.0743526965379715, 0.0744363591074944, 0.0745200589299202, 0.0746037364006042, 0.0746874585747719, 0.0747711807489395, 0.0748548954725266, 0.0749386325478554, 0.0750223770737648, 0.0751061365008354, 0.0751899033784866, 0.0752736777067184, 0.0753574520349503, 0.0754412636160851, 0.0755250751972198, 0.0756088867783546, 0.07569270581007, 0.075776532292366, 0.075860396027565, 0.0759442374110222, 0.0760280936956406, 0.0761119723320007, 0.0761958658695221, 0.0762797519564629, 0.0763636529445648, 0.0764475762844086, 0.0765315070748329, 0.0766154229640961, 0.076699361205101, 0.0767833292484283, 0.0768672749400139, 0.0769512429833412, 0.0770352408289909, 0.0771192312240601, 0.077203243970871, 0.0772872492671013, 0.0773712620139122, 0.0774553045630455, 0.0775393471121788, 0.0776233822107315, 0.0777074620127678, 0.0777915194630623, 0.0778756141662598, 0.0779596865177155, 0.0780437886714935, 0.0781279057264328, 0.0782120153307915, 0.0782961472868919, 0.0783802941441536, 0.0784644410014153, 0.0785486027598381, 0.0786327719688416, 0.0787169486284256, 0.0788011252880096, 0.0788853392004967, 0.0789695382118225, 0.0790537595748901, 0.0791379809379578, 0.0792222246527672, 0.0793064758181572, 0.0793907269835472, 0.0794750079512596, 0.0795592740178108, 0.0796435549855232, 0.0797278732061386, 0.079812154173851, 0.079896479845047, 0.0799808129668236, 0.0800651460886002, 0.0801494941115379, 0.0802338495850563, 0.0803182050585747, 0.080402597784996, 0.0804869681596756, 0.080571360886097, 0.0806557834148407, 0.0807401910424232, 0.0808246061205864, 0.0809090510010719, 0.0809934958815575, 0.0810779556632042, 0.0811624154448509, 0.0812468826770782, 0.0813313648104668, 0.0814158543944359, 0.0815003588795662, 0.0815848857164383, 0.0816693976521492, 0.0817539319396019, 0.0818384736776352, 0.0819230303168297, 0.0820075944066048, 0.0820921659469604, 0.0821767374873161, 0.0822613313794136, 0.0823459327220917, 0.0824305340647697, 0.0825151726603508, 0.0825998038053513, 0.0826844498515129, 0.0827691033482552, 0.0828537568449974, 0.0829384252429008, 0.0830231010913849, 0.0831077918410301, 0.0831924974918365, 0.083277203142643, 0.0833619236946106, 0.0834466516971588, 0.083531379699707, 0.0836161449551582, 0.0837008953094482, 0.0837856605648994, 0.0838704481720924, 0.0839552283287048, 0.0840400233864784, 0.0841248482465744, 0.0842096507549286, 0.0842944830656052, 0.0843793302774429, 0.0844641774892807, 0.0845490247011185, 0.0846338868141174, 0.0847187712788582, 0.0848036631941795, 0.0848885551095009, 0.0849734619259834, 0.0850583836436272, 0.0851432979106903, 0.0852282419800758, 0.0853132009506226, 0.0853981301188469, 0.0854831114411354, 0.0855680853128433, 0.0856530591845512, 0.0857380703091621, 0.0858230739831924, 0.0859081000089645, 0.0859931036829948, 0.0860781446099281, 0.0861631855368614, 0.0862482413649559, 0.0863332971930504, 0.0864183753728867, 0.0865034610033035, 0.0865885466337204, 0.0866736546158791, 0.0867587700486183, 0.0868438929319382, 0.0869290232658386, 0.0870141610503197, 0.0870993211865425, 0.0871844813227654, 0.0872696489095688, 0.087354838848114, 0.0874400213360786, 0.0875252336263657, 0.0876104384660721, 0.0876956731081009, 0.0877808928489685, 0.0878661274909973, 0.0879513695836067, 0.0880366414785385, 0.0881219133734703, 0.0882071852684021, 0.0882924795150757, 0.0883777886629105, 0.0884630903601646, 0.0885484144091606, 0.088633731007576, 0.0887190848588943, 0.0888044312596321, 0.0888897851109505, 0.0889751613140106, 0.0890605375170708, 0.0891459286212921, 0.0892313197255135, 0.089316725730896, 0.0894021540880203, 0.0894875749945641, 0.0895730033516884, 0.0896584689617157, 0.0897439122200012, 0.0898293778300285, 0.0899148657917976, 0.0900003388524055, 0.0900858491659164, 0.0901713520288467, 0.0902568697929382, 0.0903423950076103, 0.0904279202222824, 0.0905134752392769, 0.0905990228056908, 0.0906845927238464, 0.0907701775431633, 0.0908557623624802, 0.090941347181797, 0.0910269543528557, 0.0911125689744949, 0.0911981835961342, 0.0912838205695152, 0.0913694724440575, 0.0914551168680191, 0.0915407910943031, 0.0916264578700066, 0.0917121544480324, 0.0917978435754776, 0.0918835401535034, 0.091969259083271, 0.0920549631118774, 0.0921407043933868, 0.0922264456748962, 0.0923121944069862, 0.092397965490818, 0.0924837291240692, 0.0925695151090622, 0.0926553010940552, 0.0927411094307899, 0.0928269103169441, 0.0929127410054207, 0.0929985716938972, 0.0930844023823738, 0.0931702554225922, 0.0932561159133911, 0.0933419987559319, 0.093427874147892, 0.0935137569904327, 0.0935996621847153, 0.0936855673789978, 0.0937714800238609, 0.0938574224710464, 0.0939433574676514, 0.0940293073654175, 0.0941152647137642, 0.0942012295126915, 0.09428720921278, 0.0943732112646103, 0.0944591984152794, 0.0945452004671097, 0.0946312248706818, 0.0947172492742538, 0.0948032885789871, 0.094889335334301, 0.0949753895401955, 0.0950614586472511, 0.0951475277543068, 0.0952336192131042, 0.0953197106719017, 0.0954058170318604, 0.0954919308423996, 0.0955780595541, 0.0956642031669617, 0.0957503542304039, 0.0958365052938461, 0.095922663807869, 0.096008837223053, 0.0960950255393982, 0.0961812287569046, 0.0962674245238304, 0.096353642642498, 0.0964398607611656, 0.0965260937809944, 0.0966123417019844, 0.096698597073555, 0.0967848598957062, 0.0968711376190186, 0.0969574004411697, 0.0970437005162239, 0.0971300154924393, 0.0972163155674934, 0.0973026528954506, 0.0973889753222466, 0.0974753201007843, 0.0975616723299026, 0.0976480320096016, 0.0977344065904617, 0.0978207811713219, 0.0979071706533432, 0.0979935601353645, 0.0980799868702888, 0.0981664061546326, 0.0982528477907181, 0.098339281976223, 0.0984257236123085, 0.0985121950507164, 0.0985986590385437, 0.0986851379275322, 0.0987716317176819, 0.0988581329584122, 0.0989446491003036, 0.0990311652421951, 0.099117673933506, 0.0992042273283005, 0.0992907658219337, 0.0993773266673088, 0.0994639024138451, 0.0995504781603813, 0.0996370539069176, 0.0997236669063568, 0.0998102575540543, 0.0998968854546547, 0.0999835208058357, 0.100070148706436, 0.100156791508198, 0.100243456661701, 0.100330114364624, 0.100416801869869, 0.100503474473953, 0.10059018433094, 0.100676879286766, 0.100763596594334, 0.100850321352482, 0.100937061011791, 0.10102379322052, 0.101110562682152, 0.101197332143784, 0.101284094154835, 0.101370885968208, 0.101457670331001, 0.101544484496117, 0.101631298661232, 0.101718120276928, 0.101804949343204, 0.101891785860062, 0.101978644728661, 0.10206551104784, 0.10215237736702, 0.102239280939102, 0.102326154708862, 0.102413058280945, 0.102499984204769, 0.102586902678013, 0.102673821151257, 0.102760776877403, 0.102847725152969, 0.102934680879116, 0.103021666407585, 0.103108637034893, 0.103195637464523, 0.103282637894154, 0.103369638323784, 0.103456668555737, 0.103543691337109, 0.103630721569061, 0.103717781603336, 0.103804849088192, 0.103891924023628, 0.103978991508484, 0.104066073894501, 0.104153178632259, 0.104240290820599, 0.104327410459518, 0.104414537549019, 0.1045016720891, 0.104588814079762, 0.104675978422165, 0.104763142764568, 0.104850322008133, 0.104937508702278, 0.105024702847004, 0.105111919343472, 0.105199135839939, 0.105286359786987, 0.105373606085777, 0.105460844933987, 0.105548113584518, 0.10563537478447, 0.105722650885582, 0.105809934437275, 0.105897232890129, 0.105984531342983, 0.106071852147579, 0.106159172952175, 0.106246516108513, 0.10633385181427, 0.106421202421188, 0.106508575379848, 0.106595940887928, 0.10668333619833, 0.106770724058151, 0.106858134269714, 0.106945529580116, 0.107032969594002, 0.107120402157307, 0.107207842171192, 0.107295304536819, 0.107382759451866, 0.107470229268074, 0.107557713985443, 0.107645228505135, 0.10773291438818, 0.107820555567741, 0.107908137142658, 0.107995711266994, 0.108083240687847, 0.108170732855797, 0.108258165419102, 0.108345575630665, 0.108432941138744, 0.108520269393921, 0.108607552945614, 0.108694814145565, 0.108782030642033, 0.108869194984436, 0.108956336975098, 0.109043426811695, 0.109130494296551, 0.109217494726181, 0.10930448025465, 0.109391421079636, 0.109478324651718, 0.109565190970898, 0.109652020037174, 0.109738796949387, 0.109825558960438, 0.109912253916264, 0.109998919069767, 0.110085554420948, 0.110172152519226, 0.110258691012859, 0.110345222055912, 0.110431686043739, 0.110518142580986, 0.110604539513588, 0.110690891742706, 0.110777221620083, 0.110863491892815, 0.110949739813805, 0.111035943031311, 0.111122108995914, 0.111208230257034, 0.111294329166412, 0.111380375921726, 0.111466392874718, 0.111552357673645, 0.111638285219669, 0.111724197864532, 0.11181004345417, 0.111895859241486, 0.111981645226479, 0.112067379057407, 0.112153083086014, 0.112238749861717, 0.112324371933937, 0.112409964203835, 0.112495496869087, 0.112581007182598, 0.112666480243206, 0.112751916050911, 0.112837307155132, 0.11292265355587, 0.113007970154285, 0.113093242049217, 0.113178484141827, 0.113263688981533, 0.113348834216595, 0.113433964550495, 0.113519035279751, 0.113604076206684, 0.113689079880714, 0.113774053752422, 0.113858968019485, 0.113943874835968, 0.114028722047806, 0.11411352455616, 0.114198289811611, 0.114283032715321, 0.114367723464966, 0.114452376961708, 0.114537000656128, 0.114621564745903, 0.114706113934517, 0.114790618419647, 0.114875078201294, 0.114959500730038, 0.115043871104717, 0.115128226578236, 0.11521252989769, 0.115296803414822, 0.11538103222847, 0.115465223789215, 0.115549378097057, 0.115633487701416, 0.115717567503452, 0.115801595151424, 0.115885592997074, 0.11596954613924, 0.116053469479084, 0.116137348115444, 0.116221196949482, 0.116304986178875, 0.116388767957687, 0.116472490131855, 0.116556167602539, 0.116639815270901, 0.116723425686359, 0.116806998848915, 0.116890534758568, 0.116974033415318, 0.117057472467422, 0.117140896618366, 0.117224276065826, 0.117307610809803, 0.117390915751457, 0.117474168539047, 0.117557391524315, 0.11764057725668, 0.117723725736141, 0.117806822061539, 0.117889888584614, 0.117972917854786, 0.118055902421474, 0.118138857185841, 0.118221774697304, 0.118304647505283, 0.11838748306036, 0.118470273911953, 0.118553027510643, 0.11863574385643, 0.118718437850475, 0.118801072239876, 0.118883669376373, 0.118966229259968, 0.119048751890659, 0.119131229817867, 0.119213692843914, 0.119296103715897, 0.119378462433815, 0.119460798799992, 0.119543090462685, 0.119625352323055, 0.119707562029362, 0.119789734482765, 0.119871877133846, 0.119953975081444, 0.120036043226719, 0.120118051767349, 0.120200030505657, 0.120281986892223, 0.120363883674145, 0.120445750653744, 0.12052758783102, 0.120609372854233, 0.120691113173962, 0.120772816240788, 0.120854504406452, 0.120936125516891, 0.121017724275589, 0.121099285781384, 0.121180787682533, 0.121262282133102, 0.121343716979027, 0.121425122022629, 0.121506489813328, 0.121587805449963, 0.121669098734856, 0.121750332415104, 0.12183154374361, 0.121912710368633, 0.121993832290173, 0.122074924409389, 0.122155986726284, 0.122236989438534, 0.122317977249622, 0.122398912906647, 0.122479811310768, 0.122560665011406, 0.122641488909721, 0.122722260653973, 0.122803002595901, 0.122883707284927, 0.122964382171631, 0.12304499745369, 0.123125582933426, 0.123206131160259, 0.12328664213419, 0.123367123305798, 0.123447559773922, 0.123527936637402, 0.123608291149139, 0.123688615858555, 0.123768880963326, 0.123849131166935, 0.12392932921648, 0.124009482562542, 0.124089606106281, 0.124169692397118, 0.124249748885632, 0.124329753220081, 0.124409712851048, 0.124489635229111, 0.124569535255432, 0.124649383127689, 0.124729193747044, 0.124808974564075, 0.124888710677624, 0.124968402087688, 0.12504805624485, 0.125127673149109, 0.125207260251045, 0.125286802649498, 0.125366300344467, 0.125445768237114, 0.125525176525116, 0.125604584813118, 0.125683918595314, 0.125763237476349, 0.125842496752739, 0.125921741127968, 0.126000925898552, 0.126080095767975, 0.126159191131592, 0.126238271594048, 0.12631730735302, 0.126396313309669, 0.126475259661674, 0.126554176211357, 0.126633077859879, 0.126711905002594, 0.126790717244148, 0.126869484782219, 0.126948222517967, 0.127026915550232, 0.127105548977852, 0.127184167504311, 0.127262741327286, 0.127341270446777, 0.127419769763947, 0.127498224377632, 0.127576634287834, 0.127655014395714, 0.127733364701271, 0.127811655402184, 0.127889931201935, 0.127968147397041, 0.128046333789825, 0.128124475479126, 0.128202602267265, 0.128280654549599, 0.128358691930771, 0.128436684608459, 0.128514632582664, 0.128592550754547, 0.128670424222946, 0.128748267889023, 0.128826066851616, 0.128903821110725, 0.128981545567513, 0.129059210419655, 0.129136845469475, 0.129214465618134, 0.129292041063309, 0.129369556903839, 0.129447042942047, 0.129524499177933, 0.129601910710335, 0.129679277539253, 0.129756614565849, 0.129833906888962, 0.129911154508591, 0.129988357424736, 0.13006554543972, 0.130142688751221, 0.130219802260399, 0.130296856164932, 0.130373865365982, 0.130450859665871, 0.130527809262276, 0.130604729056358, 0.130681589245796, 0.13075840473175, 0.130835205316544, 0.130911946296692, 0.130988672375679, 0.131065338850021, 0.131141975522041, 0.131218567490578, 0.131295129656792, 0.131371647119522, 0.13144813477993, 0.131524577736855, 0.131600975990295, 0.131677329540253, 0.131753653287888, 0.1318299472332, 0.131906196475029, 0.131982401013374, 0.132058575749397, 0.132134705781937, 0.132210806012154, 0.132286861538887, 0.132362872362137, 0.132438853383064, 0.132514804601669, 0.132590681314468, 0.132666543126106, 0.132742375135422, 0.132818147540092, 0.132893905043602, 0.132969602942467, 0.133045271039009, 0.133120894432068, 0.133196488022804, 0.133272036910057, 0.133347555994987, 0.133423030376434, 0.133498460054398, 0.133573859930038, 0.133649215102196, 0.133724540472031, 0.133799806237221, 0.13387505710125, 0.133950248360634, 0.134025409817696, 0.134100541472435, 0.134175628423691, 0.134250670671463, 0.134325683116913, 0.134400650858879, 0.134475588798523, 0.134550482034683, 0.134625315666199, 0.134700134396553, 0.134774908423424, 0.134849652647972, 0.134924337267876, 0.134999006986618, 0.135073632001877, 0.135148212313652, 0.135222747921944, 0.135297268629074, 0.13537172973156, 0.135446146130562, 0.135520547628403, 0.135594889521599, 0.135669216513634, 0.135743468999863, 0.13581770658493, 0.135891899466515, 0.135966062545776, 0.136040180921555, 0.136114254593849, 0.136188298463821, 0.13626229763031, 0.136336252093315, 0.136410176753998, 0.136484056711197, 0.136557921767235, 0.136631712317467, 0.136705487966537, 0.136779218912125, 0.136852905154228, 0.136926546692848, 0.137000173330307, 0.137073755264282, 0.137147277593613, 0.137220770120621, 0.137294232845306, 0.137367650866508, 0.137441039085388, 0.137514382600784, 0.137587696313858, 0.137660965323448, 0.137734174728394, 0.137807369232178, 0.137880519032478, 0.137953624129295, 0.13802669942379, 0.138099730014801, 0.13817273080349, 0.138245686888695, 0.138318598270416, 0.138391479849815, 0.13846430182457, 0.138537108898163, 0.138609856367111, 0.138682588934898, 0.138755276799202, 0.138827934861183, 0.13890053331852, 0.138973087072372, 0.139045625925064, 0.139118120074272, 0.139190554618835, 0.139262974262238, 0.139335349202156, 0.139407679438591, 0.139479979872704, 0.139552235603333, 0.139624446630478, 0.139696627855301, 0.139768779277802, 0.139840885996819, 0.139912948012352, 0.139984965324402, 0.140056967735291, 0.140128895640373, 0.140200808644295, 0.140272691845894, 0.140344515442848, 0.14041630923748, 0.140488058328629, 0.140559777617455, 0.140631452202797, 0.140703082084656, 0.140774682164192, 0.140846237540245, 0.140917763113976, 0.140989258885384, 0.141060695052147, 0.141132101416588, 0.141203477978706, 0.14127479493618, 0.141346082091331, 0.14141733944416, 0.141488552093506, 0.141559720039368, 0.141630843281746, 0.141701951622963, 0.141773015260696, 0.141844019293785, 0.141914993524551, 0.141985952854156, 0.142056837677956, 0.142127707600594, 0.142198532819748, 0.14226932823658, 0.142340064048767, 0.142410770058632, 0.142481431365013, 0.142552062869072, 0.142622664570808, 0.1426932066679, 0.142763718962669, 0.142834201455116, 0.14290463924408, 0.142975032329559, 0.143045395612717, 0.14311571419239, 0.143185988068581, 0.14325624704361, 0.143326446413994, 0.143396615982056, 0.143466740846634, 0.143536821007729, 0.143606886267662, 0.14367687702179, 0.143746852874756, 0.143816784024239, 0.143886685371399, 0.143956542015076, 0.144026353955269, 0.14409613609314, 0.144165873527527, 0.144235581159592, 0.144305229187012, 0.144374847412109, 0.144444435834885, 0.144513979554176, 0.144583493471146, 0.144652962684631, 0.144722387194633, 0.144791781902313, 0.144861131906509, 0.144930452108383, 0.144999727606773, 0.14506895840168, 0.145138159394264, 0.145207300782204, 0.145276427268982, 0.145345509052277, 0.145414561033249, 0.145483553409576, 0.145552515983582, 0.145621448755264, 0.145690321922302, 0.145759180188179, 0.145827978849411, 0.145896762609482, 0.145965486764908, 0.146034196019173, 0.146102845668793, 0.146171450614929, 0.146240040659904, 0.146308556199074, 0.146377056837082, 0.146445527672768, 0.14651395380497, 0.146582335233688, 0.146648153662682, 0.146711334586143, 0.146774455904961, 0.146837517619133, 0.146900504827499, 0.146963432431221, 0.147026285529137, 0.147089079022408, 0.147151798009872, 0.147214442491531, 0.147277012467384, 0.147339537739754, 0.147401988506317, 0.147464364767075, 0.147526681423187, 0.147588923573494, 0.147651106119156, 0.147713214159012, 0.147775262594223, 0.147837221622467, 0.147899121046066, 0.147960960865021, 0.148022726178169, 0.148084431886673, 0.148146063089371, 0.148207619786263, 0.14826911687851, 0.148330554366112, 0.148391917347908, 0.148453205823898, 0.148514449596405, 0.148575589060783, 0.148636683821678, 0.148697689175606, 0.14875864982605, 0.148819550871849, 0.148880362510681, 0.148941099643707, 0.149001806974411, 0.149062395095825, 0.149122938513756, 0.149183437228203, 0.149243831634521, 0.149304181337357, 0.149364471435547, 0.14942467212677, 0.149484798312187, 0.149544879794121, 0.149604886770248, 0.149664834141731, 0.149724662303925, 0.149784475564957, 0.149844214320183, 0.149903878569603, 0.149963468313217, 0.150022998452187, 0.150082468986511, 0.150141850113869, 0.150201186537743, 0.150260433554649, 0.150319635868073, 0.150378733873367, 0.150437816977501, 0.150496810674667, 0.150555700063705, 0.150614559650421, 0.150673344731331, 0.150732070207596, 0.150790691375732, 0.150849252939224, 0.150907784700394, 0.150966212153435, 0.151024594902992, 0.151082903146744, 0.151141136884689, 0.15119931101799, 0.151257425546646, 0.151315450668335, 0.151373416185379, 0.151431307196617, 0.151489153504372, 0.15154692530632, 0.151604622602463, 0.151662230491638, 0.15171979367733, 0.151777282357216, 0.151834711432457, 0.151892066001892, 0.151949346065521, 0.152006566524506, 0.152063727378845, 0.152120813727379, 0.152177825570107, 0.152234777808189, 0.152291640639305, 0.152348473668098, 0.152405202388763, 0.152461886405945, 0.152518481016159, 0.152575045824051, 0.152631536126137, 0.152687937021255, 0.152744263410568, 0.152800530195236, 0.152856707572937, 0.152912870049477, 0.152968913316727, 0.153024941682816, 0.153080865740776, 0.153136715292931, 0.153192520141602, 0.153248265385628, 0.153303906321526, 0.153359487652779, 0.153415009379387, 0.153470456600189, 0.153525844216347, 0.153581172227859, 0.153636440634727, 0.153691604733467, 0.153746739029884, 0.153801783919334, 0.153856754302979, 0.153911665081978, 0.153966531157494, 0.154021292924881, 0.154075995087624, 0.154130637645721, 0.154185220599174, 0.154239729046822, 0.154294162988663, 0.154348522424698, 0.154402822256088, 0.154457062482834, 0.154511228203773, 0.154565319418907, 0.154619336128235, 0.154673308134079, 0.154727205634117, 0.154781028628349, 0.154834792017937, 0.154888480901718, 0.154942110180855, 0.154995650053024, 0.155049130320549, 0.155102550983429, 0.155155912041664, 0.155209198594093, 0.155262425541878, 0.155315563082695, 0.155368626117706, 0.155421659350395, 0.155474603176117, 0.155527472496033, 0.155580282211304, 0.155633017420769, 0.155685693025589, 0.155738294124603, 0.155790835618973, 0.155843302607536, 0.155895695090294, 0.155948027968407, 0.156000301241875, 0.156052500009537, 0.156104609370232, 0.156156688928604, 0.156208679080009, 0.156260594725609, 0.156312465667725, 0.156364247202873, 0.156415969133377, 0.156467631459236, 0.156519219279289, 0.156570732593536, 0.156622171401978, 0.156673565506935, 0.156724855303764, 0.156776115298271, 0.156827300786972, 0.156878411769867, 0.156929448246956, 0.156980440020561, 0.157031327486038, 0.157082185149193, 0.157132938504219, 0.157183647155762, 0.15723429620266, 0.15728485584259, 0.157335340976715, 0.157385796308517, 0.15743613243103, 0.157486453652382, 0.157536670565605, 0.157586827874184, 0.157636925578117, 0.157686948776245, 0.157736897468567, 0.157786786556244, 0.157836616039276, 0.157886371016502, 0.157936066389084, 0.157985657453537, 0.158035218715668, 0.158084705471992, 0.158134117722511, 0.158183470368385, 0.158232733607292, 0.158281952142715, 0.158331081271172, 0.158380150794983, 0.158429175615311, 0.158478111028671, 0.158526971936226, 0.158575773239136, 0.158624514937401, 0.15867318212986, 0.158721789717674, 0.158770322799683, 0.158818781375885, 0.158867165446281, 0.158915504813194, 0.158963739871979, 0.15901193022728, 0.159060090780258, 0.159108132123947, 0.159156113862991, 0.159204035997391, 0.159251898527145, 0.159299656748772, 0.159347400069237, 0.159395039081573, 0.159442618489265, 0.159490138292313, 0.159537583589554, 0.159584954380989, 0.15963226556778, 0.159679502248764, 0.159726694226265, 0.159773796796799, 0.159820824861526, 0.159867778420448, 0.159914687275887, 0.159961521625519, 0.160008296370506, 0.160054996609688, 0.160101637244225, 0.160148173570633, 0.160194680094719, 0.160241112112999, 0.160287469625473, 0.160333767533302, 0.160379990935326, 0.160426124930382, 0.160472229123116, 0.160518243908882, 0.160564184188843, 0.160610064864159, 0.16065588593483, 0.160701647400856, 0.160747319459915, 0.16079293191433, 0.160838469862938, 0.160883948206902, 0.16092936694622, 0.160974696278572, 0.161019995808601, 0.16106516122818, 0.161110311746597, 0.161155372858047, 0.161200389266014, 0.161245316267014, 0.161290198564529, 0.161334976553917, 0.16137969493866, 0.16142438352108, 0.161468952894211, 0.161513492465019, 0.161557957530022, 0.161602348089218, 0.161646649241447, 0.161690905690193, 0.161735102534294, 0.161779209971428, 0.161823257803917, 0.161867260932922, 0.161911159753799, 0.161955013871193, 0.161998778581619, 0.162042513489723, 0.162086144089699, 0.162129729986191, 0.162173226475716, 0.162216663360596, 0.162260040640831, 0.162303358316422, 0.162346586585045, 0.162389770150185, 0.162432849407196, 0.162475898861885, 0.162518858909607, 0.162561744451523, 0.162604555487633, 0.162647351622581, 0.162690028548241, 0.162732645869255, 0.162775203585625, 0.16281770169735, 0.16286014020443, 0.162902474403381, 0.162944763898849, 0.162986978888512, 0.163029134273529, 0.16307121515274, 0.163113221526146, 0.163155168294907, 0.163197040557861, 0.163238868117332, 0.163280606269836, 0.163322269916534, 0.163363888859749, 0.163405433297157, 0.16344690322876, 0.163488313555717, 0.163529619574547, 0.163570895791054, 0.163612097501755, 0.163653239607811, 0.1636942923069, 0.163735285401344, 0.163776218891144, 0.163817077875137, 0.163857892155647, 0.163898602128029, 0.163939237594604, 0.163979843258858, 0.164020374417305, 0.164060816168785, 0.164101213216782, 0.16414150595665, 0.164181768894196, 0.164221942424774, 0.164262071251869, 0.164302110671997, 0.16434209048748, 0.164381995797157, 0.16442184150219, 0.164461627602577, 0.164501324295998, 0.164540946483612, 0.164580538868904, 0.164620041847229, 0.164659470319748, 0.1646988093853, 0.164738118648529, 0.164777368307114, 0.164816528558731, 0.164855614304543, 0.164894640445709, 0.164933621883392, 0.164972499012947, 0.165011316537857, 0.165050074458122, 0.165088757872581, 0.165127396583557, 0.165165945887566, 0.165204405784607, 0.165242835879326, 0.165281191468239, 0.165319457650185, 0.165357679128647, 0.165395811200142, 0.165433898568153, 0.165471911430359, 0.165509849786758, 0.165547713637352, 0.165585532784462, 0.165623277425766, 0.165660932660103, 0.165698543190956, 0.165736079216003, 0.165773525834084, 0.165810942649841, 0.165848255157471, 0.165885522961617, 0.165922731161118, 0.165959864854813, 0.165996909141541, 0.166033878922462, 0.166070818901062, 0.166107684373856, 0.166144475340843, 0.166181191802025, 0.166217833757401, 0.166254416108131, 0.166290938854218, 0.166327387094498, 0.166363760828972, 0.166400074958801, 0.166436299681664, 0.166472494602203, 0.166508600115776, 0.166544646024704, 0.166580632328987, 0.166616514325142, 0.166652366518974, 0.16668812930584, 0.166723817586899, 0.166759446263313, 0.166795030236244, 0.166830524802208, 0.166865944862366, 0.166901305317879, 0.166936621069908, 0.166971832513809, 0.167006984353065, 0.167042091488838, 0.167077109217644, 0.167112067341805, 0.167146950960159, 0.167181774973869, 0.167216524481773, 0.167251199483871, 0.167285799980164, 0.167320370674133, 0.167354837059975, 0.167389243841171, 0.167423591017723, 0.167457863688469, 0.167492061853409, 0.167526215314865, 0.167560294270515, 0.167594283819199, 0.167628213763237, 0.167662084102631, 0.167695894837379, 0.167729631066322, 0.167763277888298, 0.167796894907951, 0.167830407619476, 0.167863875627518, 0.167897269129753, 0.167930588126183, 0.167963847517967, 0.167997032403946, 0.168030142784119, 0.168063208460808, 0.168096199631691, 0.168129116296768, 0.168161973357201, 0.168194755911827, 0.168227463960648, 0.168260097503662, 0.168292671442032, 0.168325200676918, 0.168357640504837, 0.168390020728111, 0.16842232644558, 0.168454572558403, 0.168486729264259, 0.168518841266632, 0.168550863862038, 0.168582826852798, 0.168614745140076, 0.168646559119225, 0.16867832839489, 0.168710008263588, 0.168741673231125, 0.168773218989372, 0.168804705142975, 0.168836131691933, 0.168867498636246, 0.16889876127243, 0.168930009007454, 0.168961152434349, 0.168992236256599, 0.169023260474205, 0.169054210186005, 0.169085100293159, 0.169115900993347, 0.169146627187729, 0.169177338480949, 0.169207945466042, 0.169238477945328, 0.169268935918808, 0.169299364089966, 0.169329687952995, 0.169359967112541, 0.16939015686512, 0.169420301914215, 0.169450357556343, 0.169480368494987, 0.169510290026665, 0.169540151953697, 0.169569969177246, 0.169599682092667, 0.169629335403442, 0.169658944010735, 0.16968846321106, 0.169717907905579, 0.169747292995453, 0.169775605201721, 0.169802844524384, 0.16983000934124, 0.16985709965229, 0.169884130358696, 0.169911101460457, 0.169937998056412, 0.169964805245399, 0.169991567730904, 0.170018270611763, 0.170044869184494, 0.170071437954903, 0.170097917318344, 0.17012432217598, 0.17015066742897, 0.170176938176155, 0.170203164219856, 0.17022930085659, 0.170255362987518, 0.170281365513802, 0.170307293534279, 0.170333161950111, 0.170358955860138, 0.170384705066681, 0.170410335063934, 0.170435920357704, 0.170461475849152, 0.17048691213131, 0.170512288808823, 0.170537605881691, 0.170562848448753, 0.170588031411171, 0.170613139867783, 0.170638188719749, 0.17066316306591, 0.170688062906265, 0.170712888240814, 0.170737653970718, 0.170762360095978, 0.17078697681427, 0.170811548829079, 0.17083603143692, 0.170860454440117, 0.170884817838669, 0.170909106731415, 0.170933321118355, 0.170957460999489, 0.170981541275978, 0.171005561947823, 0.1710294932127, 0.171053394675255, 0.171077191829681, 0.171100914478302, 0.171124577522278, 0.171148180961609, 0.171171724796295, 0.171195179224014, 0.171218559145927, 0.171241894364357, 0.171265169978142, 0.171288341283798, 0.17131145298481, 0.171334519982338, 0.171357467770576, 0.171380400657654, 0.171403244137764, 0.171426013112068, 0.171448722481728, 0.171471357345581, 0.17149393260479, 0.171516433358192, 0.17153887450695, 0.171561241149902, 0.171583533287048, 0.171605750918388, 0.171627908945084, 0.171650007367134, 0.171672016382217, 0.171693980693817, 0.17171585559845, 0.171737685799599, 0.171759426593781, 0.171781092882156, 0.171802714467049, 0.171824246644974, 0.171845704317093, 0.171867117285728, 0.171888455748558, 0.171909734606743, 0.171930924057961, 0.171952053904533, 0.1719731092453, 0.171994104981422, 0.172015026211739, 0.17203588783741, 0.172056660056114, 0.172077387571335, 0.172098025679588, 0.172118604183197, 0.172139123082161, 0.172159552574158, 0.172179937362671, 0.172200232744217, 0.172220483422279, 0.172240629792213, 0.172260731458664, 0.17228077352047, 0.172300726175308, 0.172320634126663, 0.17234043776989, 0.172360196709633, 0.172379896044731, 0.172399505972862, 0.172419056296349, 0.172438532114029, 0.172457948327065, 0.172477290034294, 0.172496572136879, 0.172515764832497, 0.172534912824631, 0.172553971409798, 0.172572985291481, 0.172591909766197, 0.17261078953743, 0.172629579901695, 0.172648295760155, 0.172666952013969, 0.172685548663139, 0.172704070806503, 0.1727225035429, 0.172740906476974, 0.172759220004082, 0.172777473926544, 0.172795638442039, 0.172813758254051, 0.172831788659096, 0.172849759459496, 0.172867655754089, 0.172885477542877, 0.172903254628181, 0.17292095720768, 0.172938570380211, 0.172956138849258, 0.1729736328125, 0.172991037368774, 0.173008412122726, 0.173025697469711, 0.17304290831089, 0.173060059547424, 0.173077136278152, 0.173094138503075, 0.173111096024513, 0.173127949237823, 0.173144772648811, 0.173161506652832, 0.173178136348724, 0.173194766044617, 0.173211291432381, 0.1732277572155, 0.173244148492813, 0.17326046526432, 0.173276737332344, 0.173292905092239, 0.173309028148651, 0.173325076699257, 0.173341065645218, 0.173356965184212, 0.173372805118561, 0.173388585448265, 0.173404291272163, 0.173419922590256, 0.173435509204865, 0.173450991511345, 0.173466429114342, 0.173481792211533, 0.173497095704079, 0.173512309789658, 0.173527464270592, 0.173542559146881, 0.173557579517365, 0.173572510480881, 0.173587396740913, 0.173602223396301, 0.173616960644722, 0.173631638288498, 0.173646241426468, 0.173660799860954, 0.173675253987312, 0.173689648509026, 0.173703983426094, 0.173718258738518, 0.173732444643974, 0.173746585845947, 0.173760652542114, 0.173774644732475, 0.173788547515869, 0.173802420496941, 0.173816174268723, 0.173829898238182, 0.173843547701836, 0.173857137560844, 0.173870652914047, 0.173884093761444, 0.173897460103035, 0.17391075193882, 0.173923999071121, 0.173937156796455, 0.173950254917145, 0.173963263630867, 0.173976257443428, 0.1739891320467, 0.174001947045326, 0.174014717340469, 0.174027398228645, 0.174040004611015, 0.174052551388741, 0.174065053462982, 0.174077451229095, 0.174089789390564, 0.174102082848549, 0.174114257097244, 0.174126401543617, 0.174138471484184, 0.174150481820107, 0.174162417650223, 0.174174278974533, 0.174186065793037, 0.174197793006897, 0.174209445714951, 0.174221023917198, 0.174232542514801, 0.17424401640892, 0.174255385994911, 0.174266695976257, 0.174277946352959, 0.174289107322693, 0.174300223588943, 0.174311265349388, 0.174322232604027, 0.174333125352859, 0.174343973398209, 0.174354732036591, 0.174365431070328, 0.174376055598259, 0.174386605620384, 0.174397110939026, 0.174407511949539, 0.17441788315773, 0.174428164958954, 0.174438387155533, 0.174448519945145, 0.174458593130112, 0.174468606710434, 0.174478530883789, 0.174488410353661, 0.174498215317726, 0.174507945775986, 0.174517631530762, 0.174527212977409, 0.174536734819412, 0.17454619705677, 0.174555599689484, 0.174564927816391, 0.174574166536331, 0.174583330750465, 0.174592480063438, 0.174601525068283, 0.174610495567322, 0.174619406461716, 0.174628257751465, 0.174637034535408, 0.174645736813545, 0.174654364585876, 0.174662932753563, 0.174671426415443, 0.174679860472679, 0.174688220024109, 0.174696519970894, 0.174704730510712, 0.174712896347046, 0.174720987677574, 0.174729004502296, 0.174736946821213, 0.174744829535484, 0.17475263774395, 0.174760386347771, 0.174768045544624, 0.174775660037994, 0.17478321492672, 0.174790665507317, 0.17479807138443, 0.174805417656898, 0.174812659621239, 0.174819856882095, 0.174826979637146, 0.174834042787552, 0.174841031432152, 0.174847960472107, 0.174854815006256, 0.174861580133438, 0.174868300557137, 0.17487496137619, 0.174881517887115, 0.174888044595718, 0.174894466996193, 0.174900859594345, 0.174907132983208, 0.174913391470909, 0.174919560551643, 0.17492564022541, 0.174931675195694, 0.174937635660172, 0.174943536520004, 0.174949362874031, 0.174955114722252, 0.174960792064667, 0.174966394901276, 0.174971953034401, 0.17497743666172, 0.174982845783234, 0.174988180398941, 0.174993440508842, 0.174998641014099, 0.175003796815872, 0.175008863210678, 0.175013855099678, 0.175018787384033, 0.175023645162582, 0.175028443336487, 0.175033152103424, 0.175037801265717, 0.175042405724525, 0.175046935677528, 0.175051376223564, 0.175055742263794, 0.17506006360054, 0.17506431043148, 0.175068482756615, 0.175072595477104, 0.175076618790627, 0.175080597400665, 0.175084486603737, 0.175088316202164, 0.175092086195946, 0.175095781683922, 0.175099402666092, 0.175102949142456, 0.175106450915337, 0.17510986328125, 0.175113216042519, 0.175116494297981, 0.17511972784996, 0.175122871994972, 0.175125941634178, 0.175128951668739, 0.175131902098656, 0.175134748220444, 0.175137549638748, 0.175140291452408, 0.1751429438591, 0.175145551562309, 0.175148084759712, 0.175150543451309, 0.1751529276371, 0.175155237317085, 0.175157487392426, 0.175159692764282, 0.175161808729172, 0.175163835287094, 0.175165832042694, 0.175167739391327, 0.175169587135315, 0.175171345472336, 0.175173044204712, 0.175174683332443, 0.17517626285553, 0.175177738070488, 0.175179183483124, 0.175180554389954, 0.175181835889816, 0.175183057785034, 0.175184205174446, 0.175185292959213, 0.175186306238174, 0.17518724501133, 0.17518812417984, 0.175188928842545, 0.175189688801765, 0.17519037425518, 0.175190970301628, 0.175191521644592, 0.175191983580589, 0.17519237101078, 0.175192713737488, 0.175192967057228, 0.175193160772324, 0.175193294882774, 0.175193339586258, 0.175193324685097, 0.175193250179291, 0.175193101167679, 0.175192877650261, 0.175192579627037, 0.17519223690033, 0.175191819667816, 0.175191327929497, 0.175190761685371, 0.175190135836601, 0.175189420580864, 0.175188660621643, 0.175187826156616, 0.175186932086945, 0.175185948610306, 0.175184905529022, 0.175183817744255, 0.17518262565136, 0.175181359052658, 0.175180062651634, 0.175178676843643, 0.175177216529846, 0.175175681710243, 0.175174087285995, 0.175172433257103, 0.175170704722404, 0.175168916583061, 0.175167039036751, 0.175165101885796, 0.175163105130196, 0.17516103386879, 0.175158888101578, 0.175156682729721, 0.17515441775322, 0.175152063369751, 0.175149664282799, 0.175147175788879, 0.175144612789154, 0.175141990184784, 0.175139307975769, 0.175136551260948, 0.175133734941483, 0.17513082921505, 0.175127863883972, 0.175124824047089, 0.17512172460556, 0.175118565559387, 0.175115317106247, 0.175112009048462, 0.175108626484871, 0.175105199217796, 0.175101682543755, 0.175098106265068, 0.175094455480576, 0.175090730190277, 0.175086945295334, 0.175083085894585, 0.175079151988029, 0.175075143575668, 0.175071120262146, 0.175066977739334, 0.175062775611877, 0.175058513879776, 0.175054162740707, 0.175049781799316, 0.175045281648636, 0.175040751695633, 0.175036162137985, 0.175031453371048, 0.175026714801788, 0.175021886825562, 0.175017014145851, 0.175012066960335, 0.175007030367851, 0.175001934170723, 0.17499677836895, 0.174991548061371, 0.174986243247986, 0.174980893731117, 0.174975454807281, 0.17496994137764, 0.174964383244514, 0.174958735704422, 0.174953028559685, 0.174947261810303, 0.174941390752792, 0.174935504794121, 0.17492949962616, 0.174923464655876, 0.174917325377464, 0.174911141395569, 0.174904897809029, 0.174898535013199, 0.174892157316208, 0.17488569021225, 0.174879163503647, 0.174872562289238, 0.174865886569023, 0.174859151244164, 0.174852356314659, 0.174845471978188, 0.174838528037071, 0.174832165241241, 0.174826413393021, 0.174820631742477, 0.174814760684967, 0.174808830022812, 0.174802824854851, 0.174796774983406, 0.174790650606155, 0.174784436821938, 0.174778193235397, 0.174771845340729, 0.174765452742577, 0.17475900053978, 0.174752444028854, 0.174745872616768, 0.174739181995392, 0.174732461571693, 0.174725651741028, 0.17471881210804, 0.174711853265762, 0.174704849720001, 0.174697786569595, 0.174690663814545, 0.174683466553688, 0.174676194787025, 0.174668863415718, 0.174661457538605, 0.174654006958008, 0.174646466970444, 0.174638852477074, 0.174631208181381, 0.17462345957756, 0.174615651369095, 0.174607798457146, 0.174599856138229, 0.174591854214668, 0.174583792686462, 0.174575656652451, 0.174567475914955, 0.174559190869331, 0.174550861120224, 0.174542486667633, 0.174533993005753, 0.174525454640388, 0.17451685667038, 0.174508184194565, 0.174499452114105, 0.17449064552784, 0.174481794238091, 0.174472853541374, 0.174463868141174, 0.174454778432846, 0.174445644021034, 0.174436450004578, 0.174427181482315, 0.174417853355408, 0.174408435821533, 0.174398973584175, 0.174389436841011, 0.174379840493202, 0.174370169639587, 0.174360424280167, 0.174350634217262, 0.174340754747391, 0.174330830574036, 0.174320846796036, 0.174310743808746, 0.174300625920296, 0.174290403723717, 0.174280151724815, 0.174269810318947, 0.174259424209595, 0.174248948693275, 0.17423839867115, 0.174227803945541, 0.174217134714127, 0.174206390976906, 0.174195602536201, 0.174184739589691, 0.174173787236214, 0.174162775278091, 0.174151703715324, 0.174140587449074, 0.174129381775856, 0.174118101596832, 0.174106761813164, 0.174095377326012, 0.17408387362957, 0.174072355031967, 0.174060761928558, 0.174049079418182, 0.174037337303162, 0.174025535583496, 0.174013674259186, 0.17400173842907, 0.173989728093147, 0.17397765815258, 0.173965513706207, 0.173953294754028, 0.173941031098366, 0.173928692936897, 0.173916295170784, 0.173903807997704, 0.173891291022301, 0.173878684639931, 0.173866018652916, 0.173853278160095, 0.173840463161469, 0.173827603459358, 0.173814669251442, 0.173801645636559, 0.173788592219353, 0.173775434494019, 0.173762232065201, 0.173748970031738, 0.17373563349247, 0.173722222447395, 0.173708736896515, 0.173695206642151, 0.173681616783142, 0.173667922616005, 0.173654183745384, 0.173640385270119, 0.173626512289047, 0.173612579703331, 0.173598572611809, 0.173584505915642, 0.173570349812508, 0.173556134104729, 0.173541873693466, 0.173527538776398, 0.173513129353523, 0.173498645424843, 0.173484116792679, 0.173469498753548, 0.173454836010933, 0.173440113663673, 0.173425301909447, 0.173410415649414, 0.173395469784737, 0.173380464315414, 0.173365384340286, 0.173350244760513, 0.173335030674934, 0.173319756984711, 0.173304423689842, 0.173289015889168, 0.173273533582687, 0.173257991671562, 0.173242405056953, 0.173226714134216, 0.173210978507996, 0.173195168375969, 0.173179298639297, 0.173163369297981, 0.173147350549698, 0.173131287097931, 0.173115119338036, 0.173098921775818, 0.173082649707794, 0.173066303133965, 0.17304989695549, 0.173033431172371, 0.173016875982285, 0.173000276088715, 0.172983601689339, 0.172966852784157, 0.17295004427433, 0.172933161258698, 0.172916233539581, 0.172899231314659, 0.17288213968277, 0.172865003347397, 0.172847792506218, 0.172830507159233, 0.172813162207603, 0.172795757651329, 0.172778278589249, 0.172760725021362, 0.172743126749992, 0.172725453972816, 0.172707691788673, 0.172689884901047, 0.172672003507614, 0.172654077410698, 0.172636061906815, 0.172617986798286, 0.172599852085114, 0.172581627964973, 0.172563344240189, 0.172545000910759, 0.172526597976685, 0.172508135437965, 0.172489583492279, 0.172470971941948, 0.172452300786972, 0.17243355512619, 0.172414734959602, 0.17239585518837, 0.172376900911331, 0.172357901930809, 0.172338828444481, 0.172319680452347, 0.172300457954407, 0.172281190752983, 0.172261863946915, 0.172242432832718, 0.172222971916199, 0.172203406691551, 0.17218379676342, 0.172164112329483, 0.172144383192062, 0.172124564647675, 0.172104671597481, 0.172084733843803, 0.172064736485481, 0.172044634819031, 0.172024488449097, 0.172004297375679, 0.171984016895294, 0.171963676810265, 0.171943247318268, 0.171922788023949, 0.171902239322662, 0.17188161611557, 0.171860948204994, 0.17184017598629, 0.171819388866425, 0.171798497438431, 0.171777546405792, 0.171756520867348, 0.17173545062542, 0.171714305877686, 0.171693086624146, 0.171671822667122, 0.171650469303131, 0.171629056334496, 0.171607568860054, 0.171586021780968, 0.171564400196075, 0.1715427339077, 0.171520993113518, 0.171499162912369, 0.171477288007736, 0.171455338597298, 0.171433314681053, 0.171411246061325, 0.17138908803463, 0.17136687040329, 0.171344593167305, 0.171322271227837, 0.17129984498024, 0.171277359127998, 0.171254813671112, 0.17123219370842, 0.171209514141083, 0.171186774969101, 0.171163946390152, 0.171141058206558, 0.171118125319481, 0.171095103025436, 0.171072021126747, 0.171048879623413, 0.171025663614273, 0.171002373099327, 0.170979022979736, 0.170955613255501, 0.170932129025459, 0.170908570289612, 0.17088495194912, 0.170861259102821, 0.170837536454201, 0.170813709497452, 0.170789822936058, 0.170765891671181, 0.170741870999336, 0.170717790722847, 0.170693635940552, 0.170669421553612, 0.170645132660866, 0.170620799064636, 0.17059637606144, 0.170571893453598, 0.170547336339951, 0.170522719621658, 0.170498043298721, 0.17047330737114, 0.170448467135429, 0.170423582196236, 0.170398637652397, 0.170373618602753, 0.170348525047302, 0.170323386788368, 0.170298159122467, 0.170272901654243, 0.17024752497673, 0.170222103595734, 0.170196622610092, 0.170171082019806, 0.170145452022552, 0.170119762420654, 0.170094028115273, 0.170068204402924, 0.17004232108593, 0.17001636326313, 0.169990360736847, 0.169964253902435, 0.169938117265701, 0.169911891222, 0.169885620474815, 0.169859275221825, 0.169832840561867, 0.169806346297264, 0.169779807329178, 0.169753178954124, 0.169726505875587, 0.169699743390083, 0.169672921299934, 0.169646039605141, 0.169619083404541, 0.169592067599297, 0.169564977288246, 0.169537842273712, 0.169510617852211, 0.169483318924904, 0.169455975294113, 0.169428542256355, 0.169401079416275, 0.169373512268066, 0.169345900416374, 0.169318214058876, 0.169290453195572, 0.169262617826462, 0.169234752655029, 0.169206783175468, 0.169178768992424, 0.169150695204735, 0.169122532010078, 0.169094309210777, 0.169066026806831, 0.169037684798241, 0.169009253382683, 0.168980777263641, 0.168952226638794, 0.168923586606979, 0.168894901871681, 0.168866142630577, 0.168837323784828, 0.168808445334435, 0.168779477477074, 0.168750464916229, 0.168721362948418, 0.168692216277122, 0.16866298019886, 0.168633714318275, 0.168604359030724, 0.168574929237366, 0.168545439839363, 0.168515890836716, 0.168486267328262, 0.168456569314003, 0.168426811695099, 0.16839699447155, 0.168367117643356, 0.168337136507034, 0.16830712556839, 0.16827704012394, 0.168246895074844, 0.168216645717621, 0.168186381459236, 0.168156027793884, 0.168125584721565, 0.168095111846924, 0.168064564466476, 0.168033927679062, 0.168003246188164, 0.167972475290298, 0.16794165968895, 0.167910784482956, 0.167879819869995, 0.16784879565239, 0.167817696928978, 0.167786538600922, 0.167755335569382, 0.167724028229713, 0.167692691087723, 0.167661249637604, 0.16762974858284, 0.167598202824593, 0.167566582560539, 0.16753488779068, 0.167503118515015, 0.167471289634705, 0.167439416050911, 0.167407467961311, 0.167375445365906, 0.167343348264694, 0.167311176657677, 0.167278960347176, 0.167246669530869, 0.167214304208755, 0.167181879281998, 0.167149394750595, 0.167116820812225, 0.167084202170372, 0.167051523923874, 0.167018786072731, 0.166985929012299, 0.166953042149544, 0.166920080780983, 0.166887059807777, 0.166853964328766, 0.166820794343948, 0.166787594556808, 0.16675429046154, 0.166720941662788, 0.166687503457069, 0.166654020547867, 0.166620463132858, 0.166586846113205, 0.166553139686584, 0.16651938855648, 0.166485548019409, 0.166451662778854, 0.166417703032494, 0.166383653879166, 0.166349574923515, 0.16631543636322, 0.166281193494797, 0.166246891021729, 0.166212528944016, 0.166178107261658, 0.166143625974655, 0.166109055280685, 0.166074424982071, 0.166039749979973, 0.166004985570908, 0.165970146656036, 0.165935263037682, 0.165900304913521, 0.165865272283554, 0.165830180048943, 0.165795013308525, 0.165759786963463, 0.165724501013756, 0.165689125657082, 0.165653705596924, 0.16561821103096, 0.165582656860352, 0.165547013282776, 0.165511325001717, 0.165475577116013, 0.165439739823341, 0.165403857827187, 0.165367871522903, 0.165331870317459, 0.165295764803886, 0.165259599685669, 0.165223374962807, 0.1651870906353, 0.165150716900826, 0.165114283561707, 0.165077775716782, 0.165041223168373, 0.165004596114159, 0.164967909455299, 0.164931118488312, 0.164894312620163, 0.164857417345047, 0.164820447564125, 0.164783418178558, 0.164746344089508, 0.164709165692329, 0.164671927690506, 0.164634644985199, 0.164597272872925, 0.164559856057167, 0.164522349834442, 0.164484798908234, 0.164447158575058, 0.164409443736076, 0.164371713995934, 0.164333879947662, 0.164295971393585, 0.164257988333702, 0.164219990372658, 0.164181873202324, 0.164143711328506, 0.164105474948883, 0.164067193865776, 0.164028823375702, 0.163990393280983, 0.163951888680458, 0.163913324475288, 0.163874700665474, 0.163836002349854, 0.163797244429588, 0.163758397102356, 0.163719519972801, 0.163680538535118, 0.163640424609184, 0.16359905898571, 0.163557663559914, 0.16351617872715, 0.16347461938858, 0.163433030247688, 0.16339136660099, 0.163349643349648, 0.163307875394821, 0.163266018033028, 0.163224115967751, 0.163182154297829, 0.163140133023262, 0.163098022341728, 0.163055881857872, 0.163013696670532, 0.162971392273903, 0.162929072976112, 0.162886679172516, 0.162844225764275, 0.162801697850227, 0.162759125232697, 0.162716493010521, 0.162673786282539, 0.162631019949913, 0.162588208913803, 0.162545323371887, 0.162502378225327, 0.16245935857296, 0.16241629421711, 0.162373185157776, 0.162330001592636, 0.162286713719368, 0.162243410944939, 0.162200048565865, 0.162156611680984, 0.162113130092621, 0.162069573998451, 0.162025943398476, 0.161982253193855, 0.161938518285751, 0.161894723773003, 0.161850869655609, 0.16180694103241, 0.161762967705727, 0.161718919873238, 0.161674797534943, 0.161630645394325, 0.16158638894558, 0.161542117595673, 0.161497756838799, 0.16145333647728, 0.161408871412277, 0.161364331841469, 0.161319732666016, 0.161275073885918, 0.161230370402336, 0.161185577511787, 0.161140739917755, 0.161095827817917, 0.161050871014595, 0.161005839705467, 0.160960763692856, 0.160915613174438, 0.160870403051376, 0.160825133323669, 0.160779803991318, 0.16073440015316, 0.16068896651268, 0.160643443465233, 0.160597875714302, 0.160552233457565, 0.160506546497345, 0.160460785031319, 0.160414963960648, 0.160369068384171, 0.16032312810421, 0.160277143120766, 0.160231068730354, 0.160184949636459, 0.16013877093792, 0.160092502832413, 0.160046175122261, 0.159999832510948, 0.159953400492668, 0.159906893968582, 0.159860342741013, 0.159813731908798, 0.159767046570778, 0.159720316529274, 0.159673511981964, 0.159626662731171, 0.159579738974571, 0.159532740712166, 0.159485712647438, 0.159438610076904, 0.159391447901726, 0.15934419631958, 0.159296929836273, 0.159249573945999, 0.15920215845108, 0.159154668450356, 0.159107148647308, 0.159059554338455, 0.159011900424957, 0.158964201807976, 0.158916413784027, 0.158868581056595, 0.158820673823357, 0.158772706985474, 0.158724695444107, 0.158676594495773, 0.158628463745117, 0.158580273389816, 0.158531978726387, 0.158483669161797, 0.158435270190239, 0.158386811614037, 0.158338293433189, 0.158289730548859, 0.158241093158722, 0.158192411065102, 0.158143669366837, 0.158094838261604, 0.158045947551727, 0.157997012138367, 0.1579480022192, 0.15789894759655, 0.157849833369255, 0.157800644636154, 0.157751396298409, 0.157702073454857, 0.157652720808983, 0.157603293657303, 0.157553777098656, 0.157504245638847, 0.157454639673233, 0.157404974102974, 0.157355219125748, 0.157305434346199, 0.157255560159683, 0.157205656170845, 0.157155677676201, 0.157105624675751, 0.157055526971817, 0.157005354762077, 0.156955122947693, 0.156904831528664, 0.156854510307312, 0.156804099678993, 0.15675362944603, 0.156703099608421, 0.156652495265007, 0.156601846218109, 0.156551122665405, 0.156500354409218, 0.156449511647224, 0.156398624181747, 0.156347662210464, 0.156296640634537, 0.156245574355125, 0.156194418668747, 0.156143203377724, 0.156091943383217, 0.156040638685226, 0.155989229679108, 0.155937775969505, 0.155886277556419, 0.155834704637527, 0.155783087015152, 0.155731394886971, 0.155679628252983, 0.155627816915512, 0.155575931072235, 0.155524000525475, 0.155472010374069, 0.155419945716858, 0.155367821455002, 0.15531562268734, 0.155263409018517, 0.155211076140404, 0.155158713459969, 0.155106291174889, 0.155053809285164, 0.155001267790794, 0.154948651790619, 0.154895976185799, 0.154843255877495, 0.154790446162224, 0.154737591743469, 0.154684692621231, 0.154631689190865, 0.154578655958176, 0.154525548219681, 0.154472395777702, 0.154419168829918, 0.15436589717865, 0.154312551021576, 0.154259130358696, 0.154205679893494, 0.154152154922485, 0.154098555445671, 0.154044896364212, 0.153991177678108, 0.153937429189682, 0.153883591294289, 0.153829678893089, 0.153775736689568, 0.15372171998024, 0.153667643666267, 0.153613492846489, 0.153559297323227, 0.153505027294159, 0.153450697660446, 0.153396338224411, 0.153341859579086, 0.153287380933762, 0.15323281288147, 0.153178170323372, 0.15312348306179, 0.153068736195564, 0.153013914823532, 0.152959033846855, 0.152904093265533, 0.152849122881889, 0.152794063091278, 0.152738928794861, 0.15268374979496, 0.152628511190414, 0.152573212981224, 0.152517855167389, 0.152462393045425, 0.152406945824623, 0.152351379394531, 0.152295783162117, 0.152240112423897, 0.152184396982193, 0.152128592133522, 0.152072742581367, 0.152016833424568, 0.151960849761963, 0.151904806494713, 0.151848703622818, 0.151792570948601, 0.151736333966255, 0.151680037379265, 0.151623710989952, 0.151567310094833, 0.151510834693909, 0.1514543145895, 0.151397719979286, 0.151341080665588, 0.151284366846085, 0.151227608323097, 0.151170760393143, 0.151113867759705, 0.151056930422783, 0.150999888777733, 0.15094281733036, 0.150885686278343, 0.15082848072052, 0.150771230459213, 0.150713905692101, 0.150656536221504, 0.150599077343941, 0.150541573762894, 0.150484010577202, 0.150426387786865, 0.150368705391884, 0.150310933589935, 0.150253131985664, 0.150195270776749, 0.150137320160866, 0.150079324841499, 0.150021269917488, 0.149963170289993, 0.14990496635437, 0.149846732616425, 0.149788439273834, 0.149730071425438, 0.149671673774719, 0.149613186717033, 0.149554640054703, 0.149496033787727, 0.149437367916107, 0.149378642439842, 0.149319842457771, 0.149260997772217, 0.149202063679695, 0.149143099784851, 0.149084076285362, 0.149024963378906, 0.148965805768967, 0.148906603455544, 0.148847326636314, 0.14878799021244, 0.148728594183922, 0.148669123649597, 0.148609593510628, 0.148550003767014, 0.148490369319916, 0.148430660367012, 0.148370876908302, 0.148311048746109, 0.148251175880432, 0.148191213607788, 0.14813120663166, 0.148071125149727, 0.148010984063148, 0.147950798273087, 0.147890537977219, 0.147830218076706, 0.14776985347271, 0.147709384560585, 0.147648885846138, 0.147588327527046, 0.147527724504471, 0.147467017173767, 0.147406280040741, 0.147345453500748, 0.147284597158432, 0.14722366631031, 0.147162675857544, 0.147101625800133, 0.147040501236916, 0.146979317069054, 0.146918103098869, 0.146856799721718, 0.146795436739922, 0.146734014153481, 0.146672531962395, 0.146610990166664, 0.146549388766289, 0.146487712860107, 0.146425992250443, 0.146364212036133, 0.146302372217178, 0.146240457892418, 0.146178498864174, 0.146116450428963, 0.146054357290268, 0.145992189645767, 0.145929992198944, 0.145867720246315, 0.14580537378788, 0.145742982625961, 0.145680516958237, 0.145617991685867, 0.145555406808853, 0.145492762327194, 0.145430058240891, 0.145367294549942, 0.145304471254349, 0.14524157345295, 0.145178630948067, 0.145115628838539, 0.145052552223206, 0.144989416003227, 0.144926220178604, 0.144862964749336, 0.144799664616585, 0.144736275076866, 0.144672840833664, 0.144609332084656, 0.144545763731003, 0.144482150673866, 0.144418463110924, 0.144354730844498, 0.144290924072266, 0.144227042794228, 0.144163116812706, 0.14409913122654, 0.144035086035728, 0.143970966339111, 0.143906801939011, 0.143842563033104, 0.143778264522552, 0.143713906407356, 0.143649488687515, 0.143585011363029, 0.143520474433899, 0.143455877900124, 0.143391206860542, 0.143326491117477, 0.143261700868607, 0.143196851015091, 0.143131941556931, 0.143066972494125, 0.143001958727837, 0.142936855554581, 0.142871707677841, 0.142806500196457, 0.142741218209267, 0.142675891518593, 0.142610490322113, 0.142545029520988, 0.142479509115219, 0.142413929104805, 0.142348289489746, 0.142282590270042, 0.142216831445694, 0.14215099811554, 0.14208510518074, 0.142019167542458, 0.141953155398369, 0.141887083649635, 0.141820952296257, 0.141754776239395, 0.141688510775566, 0.141622185707092, 0.141555830836296, 0.141489371657372, 0.141422882676125, 0.141356334090233, 0.141289710998535, 0.141223028302193, 0.141156300902367, 0.141089469194412, 0.141022607684135, 0.140955686569214, 0.140888705849648, 0.140821650624275, 0.140754535794258, 0.140687376260757, 0.140620157122612, 0.140552848577499, 0.140485495328903, 0.140418082475662, 0.140350595116615, 0.140283077955246, 0.140215471386909, 0.140147820115089, 0.140080094337463, 0.140012308955193, 0.139944463968277, 0.139876559376717, 0.13980858027935, 0.1397405564785, 0.139672473073006, 0.139604315161705, 0.139536127448082, 0.139467835426331, 0.139399498701096, 0.139331117272377, 0.139262661337852, 0.139194145798683, 0.139125570654869, 0.139056921005249, 0.138988226652145, 0.138919457793236, 0.138850644230843, 0.138781756162643, 0.138712808489799, 0.138643801212311, 0.138574749231339, 0.138505607843399, 0.138436421751976, 0.138367176055908, 0.138297855854034, 0.138228490948677, 0.138159051537514, 0.138089567422867, 0.138020008802414, 0.137950375676155, 0.137880712747574, 0.137810960412025, 0.137741163372993, 0.137671306729317, 0.137601360678673, 0.137531399726868, 0.137461349368095, 0.137391239404678, 0.137321069836617, 0.13725084066391, 0.137180551886559, 0.137110203504562, 0.13703978061676, 0.136969313025475, 0.136898770928383, 0.136828169226646, 0.136757522821426, 0.1366868019104, 0.13661602139473, 0.136545181274414, 0.136474281549454, 0.136403307318687, 0.136332288384438, 0.136261194944382, 0.136190056800842, 0.136118859052658, 0.136047571897507, 0.135976240038872, 0.135904863476753, 0.135833397507668, 0.135761886835098, 0.135690301656723, 0.135618671774864, 0.135546982288361, 0.135475218296051, 0.135403394699097, 0.13532929122448, 0.13525278866291, 0.13517627120018, 0.135099723935127, 0.135023131966591, 0.134946525096893, 0.134869888424873, 0.134793236851692, 0.134716540575027, 0.13463981449604, 0.134563073515892, 0.13448628783226, 0.134409487247467, 0.134332656860352, 0.134255781769753, 0.134178891777992, 0.13410197198391, 0.134025022387505, 0.133948057889938, 0.13387106359005, 0.133794024586678, 0.133716955780983, 0.133639886975288, 0.133562758564949, 0.13348563015461, 0.133408442139626, 0.133331254124641, 0.133254021406174, 0.133176758885384, 0.133099481463432, 0.133022159337997, 0.132944822311401, 0.132867455482483, 0.132790043950081, 0.132712617516518, 0.132635176181793, 0.132557675242424, 0.132480159401894, 0.132402628660202, 0.132325068116188, 0.13224746286869, 0.132169857621193, 0.132092177867889, 0.132014513015747, 0.131936803460121, 0.131859064102173, 0.131781309843063, 0.131703495979309, 0.131625682115555, 0.131547838449478, 0.131469964981079, 0.131392046809196, 0.131314113736153, 0.131236165761948, 0.131158173084259, 0.131080135703087, 0.131002098321915, 0.13092403113842, 0.130845919251442, 0.130767792463303, 0.130689635872841, 0.130611434578896, 0.130533218383789, 0.130454957485199, 0.130376696586609, 0.130298390984535, 0.1302200704813, 0.130141705274582, 0.130063325166702, 0.129984900355339, 0.129906460642815, 0.129827991127968, 0.129749491810799, 0.129670962691307, 0.129592418670654, 0.129513829946518, 0.12943522632122, 0.129356577992439, 0.129277899861336, 0.129199221730232, 0.129120483994484, 0.129041731357574, 0.128962948918343, 0.12888415157795, 0.128805309534073, 0.128726437687874, 0.128647536039352, 0.12856861948967, 0.128489673137665, 0.128410682082176, 0.128331676125526, 0.128252640366554, 0.128173589706421, 0.128094494342804, 0.128015369176865, 0.127936229109764, 0.12785704433918, 0.127777844667435, 0.127698615193367, 0.127619341015816, 0.127540066838264, 0.127460733056068, 0.127381384372711, 0.127302020788193, 0.127222612500191, 0.127143189311028, 0.127063736319542, 0.126984223723412, 0.126904726028442, 0.126825168728828, 0.126745596528053, 0.126666009426117, 0.126586362719536, 0.126506716012955, 0.126427039504051, 0.126347318291664, 0.126267582178116, 0.126187816262245, 0.126108005642891, 0.126028195023537, 0.125948339700699, 0.125868454575539, 0.125788539648056, 0.12570858001709, 0.125628635287285, 0.125548630952835, 0.125468611717224, 0.125388562679291, 0.125308468937874, 0.125228390097618, 0.125148236751556, 0.125068083405495, 0.124987877905369, 0.124907664954662, 0.124827414751053, 0.12474712729454, 0.124666824936867, 0.124586492776871, 0.124506130814552, 0.124425746500492, 0.124345317482948, 0.124264873564243, 0.124184399843216, 0.124103896319866, 0.124023362994194, 0.123942799866199, 0.123862221837044, 0.123781606554985, 0.123700961470604, 0.12362027913332, 0.123539574444294, 0.123458847403526, 0.123378090560436, 0.123297303915024, 0.12321650236845, 0.123135656118393, 0.123054772615433, 0.122973874211311, 0.122892960906029, 0.122811995446682, 0.122731022536755, 0.122649997472763, 0.12256895750761, 0.122487902641296, 0.122406810522079, 0.122325673699379, 0.122244514524937, 0.122163340449333, 0.122082144021988, 0.122000887989998, 0.121919624507427, 0.121838338673115, 0.121757008135319, 0.121675662696362, 0.121594287455082, 0.12151288241148, 0.121431455016136, 0.121349975466728, 0.121268481016159, 0.121186964213848, 0.121105417609215, 0.12102385610342, 0.120942242443562, 0.120860606431961, 0.120778940618038, 0.120697245001793, 0.120615527033806, 0.120533786714077, 0.120452009141445, 0.120370209217072, 0.120288386940956, 0.120206527411938, 0.120124645531178, 0.120042741298676, 0.119960770010948, 0.119878821074963, 0.119796805083752, 0.119714796543121, 0.119632728397846, 0.11955064535141, 0.119468532502651, 0.119386397302151, 0.119304209947586, 0.119222022593021, 0.119139783084393, 0.119057543575764, 0.118975259363651, 0.118892952799797, 0.11881061643362, 0.118728265166283, 0.1186458542943, 0.118563428521156, 0.118480987846851, 0.118398502469063, 0.118315994739532, 0.118233442306519, 0.118150882422924, 0.118068292737007, 0.117985673248768, 0.117903031408787, 0.117820344865322, 0.117737643420696, 0.117654912173748, 0.117572143673897, 0.117489345371723, 0.117406539618969, 0.117323696613312, 0.117240816354752, 0.11715792119503, 0.117074988782406, 0.116992019116879, 0.116909042000771, 0.11682602763176, 0.116742976009846, 0.11665990203619, 0.116576798260212, 0.116493672132492, 0.11641052365303, 0.116327330470085, 0.116244122385979, 0.116160877048969, 0.116077609360218, 0.115994304418564, 0.115910969674587, 0.11582762748003, 0.115744240581989, 0.115660831332207, 0.115577407181263, 0.115493915975094, 0.115410432219505, 0.115326918661594, 0.115243345499039, 0.115159772336483, 0.115076161921024, 0.114992529153824, 0.114908874034882, 0.114825166761875, 0.114741452038288, 0.114657700061798, 0.114573918282986, 0.114490106701851, 0.114406280219555, 0.114322416484356, 0.114238530397415, 0.11415459215641, 0.114070661365986, 0.113986693322659, 0.113902665674686, 0.113818645477295, 0.113734588027, 0.113650493323803, 0.113566383719444, 0.113482229411602, 0.113398067653179, 0.113313861191273, 0.113229624927044, 0.113145373761654, 0.113061085343361, 0.112976767122746, 0.112892426550388, 0.112808056175709, 0.112723655998707, 0.112639233469963, 0.112554773688316, 0.112470284104347, 0.112385779619217, 0.112301230430603, 0.112216666340828, 0.112132079899311, 0.11204744130373, 0.111962802708149, 0.111878104507923, 0.111793391406536, 0.111708663403988, 0.111623890697956, 0.111539103090763, 0.111454278230667, 0.111369431018829, 0.111284554004669, 0.111199632287025, 0.111114703118801, 0.111029744148254, 0.110944747924805, 0.110859736800194, 0.11077469587326, 0.110689602792263, 0.110604509711266, 0.110519379377365, 0.110434204339981, 0.110349014401436, 0.110263802111149, 0.110178560018539, 0.110093280673027, 0.110007978975773, 0.109922654926777, 0.109837293624878, 0.109751895070076, 0.109666481614113, 0.109581030905247, 0.1094955727458, 0.10941007733345, 0.109324529767036, 0.109238997101784, 0.109153412282467, 0.109067775309086, 0.108982145786285, 0.108896479010582, 0.108810774981976, 0.108725048601627, 0.108639284968376, 0.108553521335125, 0.10846770554781, 0.108381845057011, 0.108295999467373, 0.108210109174252, 0.108124174177647, 0.108038231730461, 0.107952237129211, 0.107866242527962, 0.107780210673809, 0.107694134116173, 0.107608042657375, 0.107521928846836, 0.107435762882233, 0.107349596917629, 0.107263401150703, 0.107177153229713, 0.107090897858143, 0.107004597783089, 0.106918275356293, 0.106831938028336, 0.106745563447475, 0.106659151613712, 0.106572724878788, 0.106486260890961, 0.106399782001972, 0.10631325095892, 0.106226712465286, 0.106140151619911, 0.106053538620472, 0.105966910719872, 0.105880260467529, 0.105793565511703, 0.105706855654716, 0.105620115995407, 0.105533339083195, 0.105446539819241, 0.105359718203545, 0.105272859334946, 0.105185978114605, 0.105099067091942, 0.105012133717537, 0.10492517054081, 0.104838147759438, 0.104751139879227, 0.104664079844952, 0.104577004909515, 0.104489892721176, 0.104402765631676, 0.104315601289272, 0.104228399693966, 0.104141168296337, 0.104053929448128, 0.103966660797596, 0.103879339993, 0.103792004287243, 0.103704646229744, 0.103617250919342, 0.103529833257198, 0.103442378342152, 0.103354915976524, 0.103267423808575, 0.10317987203598, 0.103092305362225, 0.103004716336727, 0.102917097508907, 0.102829456329346, 0.102741770446301, 0.102654077112675, 0.102566361427307, 0.102478593587875, 0.102390810847282, 0.102302998304367, 0.102215148508549, 0.102127283811569, 0.102039366960526, 0.101951442658901, 0.101863503456116, 0.101775504648685, 0.101687498390675, 0.101599454879761, 0.101511381566525, 0.101423285901546, 0.101335160434246, 0.101247012615204, 0.101158827543259, 0.101070612668991, 0.100982375442982, 0.10089410841465, 0.100805819034576, 0.10071749985218, 0.100629143416882, 0.100540764629841, 0.100452356040478, 0.100363917648792, 0.100275456905365, 0.100186966359615, 0.100098446011543, 0.100009895861149, 0.099921315908432, 0.0998327136039734, 0.0997440740466118, 0.0996554121375084, 0.0995667278766632, 0.0994779989123344, 0.0993892624974251, 0.0993004888296127, 0.099211685359478, 0.0991228446364403, 0.0990339890122414, 0.0989451110363007, 0.0988561809062958, 0.0987672507762909, 0.0986782759428024, 0.0985892713069916, 0.0985002443194389, 0.0984111875295639, 0.0983221009373665, 0.0982329994440079, 0.0981438532471657, 0.0980546772480011, 0.0979654788970947, 0.097876250743866, 0.0977870002388954, 0.0976977124810219, 0.0976084023714066, 0.0975190624594688, 0.0974297001957893, 0.0973403081297874, 0.0972508788108826, 0.0971614271402359, 0.0970719456672668, 0.0969824269413948, 0.0968928933143616, 0.0968033447861671, 0.0967137441039085, 0.0966241210699081, 0.0965344607830048, 0.0964447930455208, 0.0963550806045532, 0.0962653383612633, 0.0961755737662315, 0.0960858017206192, 0.0959959775209427, 0.0959061235189438, 0.0958162546157837, 0.0957263484597206, 0.0956364199519157, 0.0955464616417885, 0.0954564586281776, 0.0953664556145668, 0.0952764004468918, 0.095186322927475, 0.095096230506897, 0.095006100833416, 0.0949159413576126, 0.0948257595300674, 0.0947355329990387, 0.0946452990174294, 0.0945550128817558, 0.0944647267460823, 0.0943744033575058, 0.0942840427160263, 0.0941936671733856, 0.0941032618284225, 0.0940128043293953, 0.0939223393797874, 0.0938318520784378, 0.0937413200736046, 0.093650758266449, 0.0935604274272919, 0.0934702754020691, 0.0933801680803299, 0.0932900384068489, 0.0931999683380127, 0.0931099206209183, 0.0930198729038239, 0.0929298475384712, 0.092839851975441, 0.0927498713135719, 0.0926599353551865, 0.0925699844956398, 0.0924800857901573, 0.0923901945352554, 0.0923003256320953, 0.092210479080677, 0.0921206623315811, 0.092030867934227, 0.0919410735368729, 0.0918513089418411, 0.0917615666985512, 0.0916718617081642, 0.0915821567177773, 0.0914924889802933, 0.0914028361439705, 0.0913131907582283, 0.0912235975265503, 0.0911339819431305, 0.0910444259643555, 0.0909548923373222, 0.0908653438091278, 0.090775839984417, 0.0906863808631897, 0.0905968993902206, 0.0905074700713158, 0.0904180556535721, 0.0903286412358284, 0.0902392938733101, 0.0901499092578888, 0.0900605991482735, 0.0899712741374969, 0.0898819863796234, 0.0897927209734917, 0.0897034779191017, 0.089614249765873, 0.089525043964386, 0.0894358456134796, 0.0893466994166374, 0.0892575457692146, 0.0891684517264366, 0.0890793576836586, 0.0889902859926224, 0.0889012068510056, 0.0888121873140335, 0.0887231826782227, 0.088634192943573, 0.0885452032089233, 0.0884562656283379, 0.088367335498333, 0.0882784426212311, 0.0881895422935486, 0.0881006941199303, 0.0880118533968925, 0.0879230126738548, 0.0878342166543007, 0.0877454578876495, 0.0876566842198372, 0.0875679701566696, 0.0874792411923409, 0.0873905718326569, 0.0873018950223923, 0.0872132405638695, 0.0871246010065079, 0.0870359987020493, 0.0869474112987518, 0.0868588536977768, 0.086770310997963, 0.0866817981004715, 0.0865933150053024, 0.0865048170089722, 0.0864163786172867, 0.0863279476761818, 0.0862395316362381, 0.0861511453986168, 0.0860627666115761, 0.0859744101762772, 0.0858861058950424, 0.0857977867126465, 0.0857094973325729, 0.0856212452054024, 0.0855329930782318, 0.0854447782039642, 0.0853565856814384, 0.0852684080600739, 0.0851802602410316, 0.0850921049714088, 0.0850040018558502, 0.0849159210920334, 0.0848278477787971, 0.0847397893667221, 0.0846517607569695, 0.0845637619495392, 0.0844757854938507, 0.0843878090381622, 0.0842998623847961, 0.084211952984333, 0.0841240435838699, 0.084036186337471, 0.0839483141899109, 0.0838604718446732, 0.0837726667523384, 0.0836848765611649, 0.0835971012711525, 0.0835093557834625, 0.0834216326475143, 0.083333931863308, 0.0832462459802628, 0.0831585675477982, 0.0830709561705589, 0.0829833298921585, 0.0828957185149193, 0.082808144390583, 0.0827205777168274, 0.0826330482959747, 0.0825455337762833, 0.082458034157753, 0.0823705792427063, 0.0822831392288208, 0.0821956917643547, 0.0821082890033722, 0.0820209011435509, 0.0819335430860519, 0.0818461999297142, 0.0817588791251183, 0.0816715732216835, 0.0815843045711517, 0.08149703592062, 0.0814098045229912, 0.0813226029276848, 0.0812354013323784, 0.0811482220888138, 0.0810610726475716, 0.0809739455580711, 0.0808868482708931, 0.0807997584342957, 0.0807126834988594, 0.0806256458163261, 0.0805386379361153, 0.0804516449570656, 0.0803646594285965, 0.0802776962518692, 0.0801907703280449, 0.0801038518548012, 0.0800169482827187, 0.0799300968647003, 0.0798432379961014, 0.0797564014792442, 0.0796696096658707, 0.0795828104019165, 0.0794960558414459, 0.0794092938303947, 0.0793225839734077, 0.0792358964681625, 0.0791492015123367, 0.0790625512599945, 0.0789759084582329, 0.078889288008213, 0.0788027048110962, 0.0787161365151405, 0.0786295682191849, 0.0785430446267128, 0.0784565433859825, 0.0783700495958328, 0.0782836005091667, 0.0781971365213394, 0.0781107246875763, 0.078024335205555, 0.0779379606246948, 0.0778515860438347, 0.0777652636170387, 0.0776789486408234, 0.0775926560163498, 0.0775063708424568, 0.077420137822628, 0.0773339122533798, 0.0772476866841316, 0.077161505818367, 0.0770753473043442, 0.0769891962409019, 0.0769030749797821, 0.0768169537186623, 0.0767308920621872, 0.0766448453068733, 0.0765587985515594, 0.0764727741479874, 0.0763867944478989, 0.0763008072972298, 0.0762148797512054, 0.0761289224028587, 0.0760430321097374, 0.0759571492671967, 0.0758712589740753, 0.0757854282855988, 0.0756996050477028, 0.0756138116121292, 0.0755280256271362, 0.075442261993885, 0.0753565207123756, 0.0752708166837692, 0.0751851201057434, 0.07509945333004, 0.0750137940049171, 0.0749281793832779, 0.074842557311058, 0.0747569724917412, 0.0746714025735855, 0.0745858699083328, 0.0745003297924995, 0.0744148418307304, 0.0743293613195419, 0.0742439031600952, 0.0741584599018097, 0.0740730464458466, 0.073987640440464, 0.0739022865891457, 0.0738169252872467, 0.0737315937876701, 0.073646292090416, 0.0735609903931618, 0.0734757408499718, 0.0733904913067818, 0.0733052492141724, 0.0732200667262077, 0.0731348842382431, 0.0730497166514397, 0.0729645863175392, 0.0728794559836388, 0.0727943629026413, 0.0727093070745468, 0.0726242363452911, 0.0725392177700996, 0.0724542066454887, 0.0723692178726196, 0.0722842663526535, 0.0721993297338486, 0.0721143931150436, 0.0720294862985611, 0.0719445943832397, 0.0718597546219826, 0.0717749148607254, 0.0716900825500488, 0.0716052874922752, 0.071520522236824, 0.0714357644319534, 0.0713510438799858, 0.0712663233280182, 0.0711816400289536, 0.0710969790816307, 0.0710123181343079, 0.0709277018904686, 0.0708430930972099, 0.0707585141062737, 0.0706739574670792, 0.0705894157290459, 0.070504903793335, 0.0704204142093658, 0.0703359171748161, 0.0702514722943306, 0.0701670423150063, 0.0700826346874237, 0.0699982419610023, 0.069913886487484, 0.0698295310139656, 0.0697452127933502, 0.069660909473896, 0.0695766434073448, 0.0694923773407936, 0.0694081410765648, 0.0693239197134972, 0.0692397356033325, 0.0691555514931679, 0.0690714046359062, 0.0689872801303864, 0.0689031407237053, 0.0688190534710884, 0.0687349885702133, 0.0686509385704994, 0.0685669183731079, 0.0684829205274582, 0.0683989375829697, 0.0683149695396423, 0.0682310312986374, 0.0681471228599548, 0.0680632218718529, 0.0679793432354927, 0.0678954944014549, 0.0678116604685783, 0.0677278488874435, 0.0676440596580505, 0.0675602853298187, 0.0674765408039093, 0.0673928260803223, 0.0673091039061546, 0.0672254413366318, 0.0671417787671089, 0.0670581385493279, 0.0669745206832886, 0.0668909251689911, 0.0668073520064354, 0.0667238011956215, 0.0666402727365494, 0.0665567591786385, 0.0664732530713081, 0.0663897916674614, 0.0663063451647758, 0.0662229210138321, 0.0661395192146301, 0.0660561472177505, 0.0659727677702904, 0.0658894330263138, 0.065806120634079, 0.0657228156924248, 0.0656395480036736, 0.0655562877655029, 0.0654730424284935, 0.0653898492455482, 0.0653066411614418, 0.0652234777808189, 0.0651403367519379, 0.065057210624218, 0.0649741142988205, 0.0648910030722618, 0.0648079589009285, 0.0647249221801758, 0.0646418854594231, 0.0645589083433151, 0.0644759312272072, 0.0643929913640022, 0.0643100589513779, 0.0642271339893341, 0.0641442313790321, 0.0640613883733749, 0.0639785304665565, 0.0638957098126411, 0.0638129115104675, 0.0637301132082939, 0.0636473670601845, 0.063564620912075, 0.0634818896651268, 0.0633991882205009, 0.0633165165781975, 0.0632338672876358, 0.0631512403488159, 0.0630686059594154, 0.0629860311746597, 0.0629034638404846, 0.0628209039568901, 0.062738373875618, 0.0626558884978294, 0.0625733882188797, 0.0624909326434135, 0.0624084770679474, 0.0623260699212551, 0.062243677675724, 0.0621612891554832, 0.0620789416134357, 0.0619966015219688, 0.0619142800569534, 0.0618319921195507, 0.0617497265338898, 0.0616674944758415, 0.0615852698683739, 0.0615030601620674, 0.0614208802580833, 0.0613387115299702, 0.0612565763294697, 0.0611744485795498, 0.0610923543572426, 0.0610102713108063, 0.0609282292425632, 0.0608461834490299, 0.0607641749083996, 0.0606821812689304, 0.0606002137064934, 0.0605182610452175, 0.0604363270103931, 0.0603544302284718, 0.0602725446224213, 0.0601906776428223, 0.0601088330149651, 0.0600270256400108, 0.0599452182650566, 0.0598634332418442, 0.0597816817462444, 0.0596999600529671, 0.0596182383596897, 0.0595365539193153, 0.0594548769295216, 0.0593732297420502, 0.0592915937304497, 0.0592099912464619, 0.059128399938345, 0.0590468607842922, 0.0589653216302395, 0.0588837936520576, 0.0588022880256176, 0.0587208196520805, 0.0586393475532532, 0.0585579201579094, 0.0584765113890171, 0.0583951026201248, 0.058313749730587, 0.0582324005663395, 0.0581510700285435, 0.0580697618424892, 0.0579884834587574, 0.057907197624445, 0.0578259564936161, 0.0577447414398193, 0.0576635524630547, 0.0575823746621609, 0.0575012043118477, 0.0574200823903084, 0.0573389604687691, 0.0572578646242619, 0.0571768023073673, 0.0570957474410534, 0.0570147186517715, 0.0569337159395218, 0.0568527206778526, 0.0567717514932156, 0.0566908344626427, 0.056609895080328, 0.0565289855003357, 0.056448120623827, 0.0563672818243504, 0.0562864318490028, 0.0562056079506874, 0.0561248175799847, 0.0560440681874752, 0.055963296443224, 0.0558825805783272, 0.055801872164011, 0.0557211935520172, 0.0556405261158943, 0.0555598773062229, 0.055479247123003, 0.0553986690938473, 0.0553180724382401, 0.0552375167608261, 0.0551569908857346, 0.0550764724612236, 0.0549959763884544, 0.0549155063927174, 0.0548350475728512, 0.0547546297311783, 0.0546742044389248, 0.0545938238501549, 0.0545134581625462, 0.0544331111013889, 0.0543527938425541, 0.0542725063860416, 0.054192204028368, 0.0541119538247585, 0.0540317334234715, 0.0539515018463135, 0.0538713112473488, 0.0537911579012871, 0.053711012005806, 0.0536308772861958, 0.0535507500171661, 0.0534706749022007, 0.0533906184136868, 0.0533105693757534, 0.0532305501401424, 0.0531505532562733, 0.053070567548275, 0.0529906153678894, 0.0529106706380844, 0.0528307557106018, 0.0527508743107319, 0.0526709854602814, 0.0525911375880241, 0.0525113083422184, 0.0524314977228642, 0.052351713180542, 0.0522719360888004, 0.0521921962499619, 0.052112489938736, 0.052032757550478, 0.0519530884921551, 0.0518734380602837, 0.0517938025295734, 0.0517141781747341, 0.0516345798969269, 0.0515550039708614, 0.0514754690229893, 0.0513959378004074, 0.0513164401054382, 0.0512369275093079, 0.0511594191193581, 0.0510841496288776, 0.0510089434683323, 0.0509337931871414, 0.0508586913347244, 0.0507836528122425, 0.0507086552679539, 0.0506337136030197, 0.0505588203668594, 0.0504839941859245, 0.0504092089831829, 0.0503344796597958, 0.0502598099410534, 0.050185140222311, 0.0501105859875679, 0.0500360541045666, 0.0499615967273712, 0.0498871989548206, 0.0498128160834312, 0.0497385002672672, 0.049664244055748, 0.0495900399982929, 0.0495158955454826, 0.0494418069720268, 0.0493677332997322, 0.0492937490344048, 0.0492198169231415, 0.0491459406912327, 0.0490721091628075, 0.0489983335137367, 0.0489245876669884, 0.0488509126007557, 0.0487772934138775, 0.048703745007515, 0.0486302152276039, 0.0485567413270473, 0.0484833344817162, 0.0484099686145782, 0.0483366772532463, 0.0482634268701077, 0.0481901951134205, 0.0481170602142811, 0.0480439513921738, 0.0479709133505821, 0.0478979349136353, 0.0478250160813332, 0.0477520935237408, 0.0476792640984058, 0.047606498003006, 0.0475337766110897, 0.047461099922657, 0.047388456761837, 0.0473158955574036, 0.047243382781744, 0.0471709296107292, 0.0470985174179077, 0.047026164829731, 0.0469538532197475, 0.0468816012144089, 0.0468094125390053, 0.0467372722923756, 0.0466651767492294, 0.0465931370854378, 0.0465211495757103, 0.0464492104947567, 0.0463773384690285, 0.0463055036962032, 0.0462337397038937, 0.0461619906127453, 0.0460903234779835, 0.046018723398447, 0.0459471605718136, 0.0458756498992443, 0.0458041504025459, 0.0457327626645565, 0.0456614010035992, 0.0455901063978672, 0.0455188639461994, 0.0454476475715637, 0.0453765019774437, 0.0453054271638393, 0.0452343784272671, 0.0451634339988232, 0.0450924709439278, 0.0450215823948383, 0.0449507646262646, 0.0448799841105938, 0.0448092818260193, 0.0447385720908642, 0.0446679815649986, 0.0445974171161652, 0.0445269234478474, 0.0444564297795296, 0.044386051595211, 0.044315692037344, 0.0442453995347023, 0.0441751629114151, 0.0441049672663212, 0.0440348610281944, 0.0439647436141968, 0.0438946820795536, 0.0438247285783291, 0.0437547750771046, 0.043684896081686, 0.0436150692403316, 0.043545313179493, 0.0434755943715572, 0.0434059351682663, 0.0433363355696201, 0.0432667545974255, 0.0431972295045853, 0.0431278049945831, 0.0430583767592907, 0.0429890342056751, 0.0429197512567043, 0.0428505055606365, 0.0427812822163105, 0.0427121669054031, 0.0426431074738503, 0.0425740368664265, 0.0425050742924213, 0.0424361526966095, 0.042367234826088, 0.0422984473407269, 0.0422296859323978, 0.0421609431505203, 0.0420922972261906, 0.0420236811041832, 0.0419551357626915, 0.0418866313993931, 0.0418181978166103, 0.0417497828602791, 0.041681420058012, 0.041613157838583, 0.0415449105203152, 0.0414767079055309, 0.041408583521843, 0.041340496391058, 0.0412724576890469, 0.0412044823169708, 0.0411365814507008, 0.041068684309721, 0.0410008355975151, 0.0409330986440182, 0.0408653914928436, 0.0407977141439915, 0.0407301485538483, 0.040662556886673, 0.0405950471758842, 0.0405276082456112, 0.0404602102935314, 0.0403928607702255, 0.040325578302145, 0.0402583405375481, 0.0401911586523056, 0.0401240326464176, 0.040056936442852, 0.0399899110198021, 0.0399229414761066, 0.0398560017347336, 0.0397891588509083, 0.0397223234176636, 0.0396555811166763, 0.03958884999156, 0.0395222008228302, 0.0394555851817131, 0.0393890552222729, 0.0393225289881229, 0.0392561107873917, 0.0391896814107895, 0.0391233563423157, 0.0390570573508739, 0.0389908365905285, 0.0389246270060539, 0.0388585366308689, 0.0387924313545227, 0.038726419210434, 0.0386604331433773, 0.0385945290327072, 0.0385286398231983, 0.0384628213942051, 0.0383970737457275, 0.0383313670754433, 0.0382656939327717, 0.0382001176476479, 0.0381345562636852, 0.0380690507590771, 0.0380036048591137, 0.0379382148385048, 0.0378728732466698, 0.037807609885931, 0.0377423651516438, 0.0376771874725819, 0.0376120507717133, 0.0375469997525215, 0.0374819599092007, 0.0374170131981373, 0.0373520739376545, 0.0372872240841389, 0.0372223854064941, 0.0371576361358166, 0.037092924118042, 0.0370282903313637, 0.036963663995266, 0.0368991270661354, 0.0368346124887466, 0.0367702059447765, 0.0367057770490646, 0.0366414710879326, 0.036577183753252, 0.0365129560232162, 0.0364487580955029, 0.0363846644759178, 0.0363205634057522, 0.0362565368413925, 0.0361925922334194, 0.036128681153059, 0.0360647961497307, 0.0360009968280792, 0.035937238484621, 0.0358735360205173, 0.0358098782598972, 0.0357462912797928, 0.0356827490031719, 0.0356192626059055, 0.0355558171868324, 0.035492442548275, 0.0354290828108788, 0.0353658385574818, 0.0353025794029236, 0.0352394171059132, 0.0351762846112251, 0.0351132117211819, 0.0350501909852028, 0.0349872745573521, 0.0349242947995663, 0.0348614640533924, 0.0347986444830894, 0.0347358919680119, 0.0346731916069984, 0.0346105396747589, 0.0345479622483253, 0.0344854146242142, 0.0344228930771351, 0.0343604981899261, 0.034298088401556, 0.0342357568442822, 0.0341734886169434, 0.0341112688183784, 0.0340490713715553, 0.0339869782328606, 0.0339248962700367, 0.0338628739118576, 0.0338009186089039, 0.033739011734724, 0.0336771570146084, 0.0336153618991375, 0.0335536077618599, 0.033491924405098, 0.0334302559494972, 0.0333686880767345, 0.0333071202039719, 0.0332456342875957, 0.0331842079758644, 0.0331228375434875, 0.0330614820122719, 0.0330002382397652, 0.0329389832913876, 0.0328778252005577, 0.0328167118132114, 0.0327556543052197, 0.0326946079730988, 0.0326336808502674, 0.032572764903307, 0.0325119197368622, 0.0324510931968689, 0.0323903746902943, 0.0323296412825584, 0.0322689972817898, 0.0322084240615368, 0.0321478918194771, 0.0320873744785786, 0.032026968896389, 0.0319665819406509, 0.0319062620401382, 0.0318459831178188, 0.0317857675254345, 0.0317255891859531, 0.0316654816269875, 0.0316054224967957, 0.0315454266965389, 0.0314854681491852, 0.0314255766570568, 0.0313656963407993, 0.0313059017062187, 0.0312461536377668, 0.0311864726245403, 0.0311268102377653, 0.031067255884409, 0.0310076903551817, 0.0309482105076313, 0.0308887884020805, 0.0308294072747231, 0.0307700540870428, 0.0307108275592327, 0.0306516066193581, 0.0305924229323864, 0.0305333118885756, 0.0304742436856031, 0.0304152350872755, 0.0303563065826893, 0.0302973669022322, 0.0302385557442904, 0.0301797278225422, 0.0301210004836321, 0.0300622880458832, 0.0300036743283272, 0.0299450736492872, 0.0298865605145693, 0.0298280622810125, 0.0297696590423584, 0.0297112744301558, 0.0296529587358236, 0.0295946858823299, 0.0295364856719971, 0.0294782966375351, 0.0294202249497175, 0.0293621364980936, 0.0293041206896305, 0.0292461887001991, 0.0291882995516062, 0.0291304234415293, 0.0290726367384195, 0.0290148891508579, 0.028957212343812, 0.0288995672017336, 0.0288420040160418, 0.0287844557315111, 0.0287269949913025, 0.028669560328126, 0.0286121945828199, 0.0285548623651266, 0.0284976121038198, 0.0284403767436743, 0.0283832270652056, 0.028326116502285, 0.0282690692692995, 0.0282120332121849, 0.0281551238149405, 0.0280982181429863, 0.0280413776636124, 0.0279845837503672, 0.0279278606176376, 0.027871135622263, 0.0278145261108875, 0.0277579575777054, 0.0277014058083296, 0.0276449378579855, 0.0275885257869959, 0.0275321416556835, 0.0274758469313383, 0.02741957642138, 0.0273633636534214, 0.0273071955889463, 0.027251111343503, 0.0271950289607048, 0.0271390434354544, 0.0270831007510424, 0.02702721580863, 0.0269713588058949, 0.0269155707210302, 0.0268598292022943, 0.026804156601429, 0.0267484989017248, 0.0266929399222136, 0.0266374126076698, 0.0265819523483515, 0.0265265349298716, 0.0264711603522301, 0.0264158304780722, 0.0263606123626232, 0.0263053644448519, 0.0262502338737249, 0.026195116341114, 0.0261400826275349, 0.0260850638151169, 0.0260301325470209, 0.0259752403944731, 0.02592040784657, 0.025865588337183, 0.0258108954876661, 0.0257561895996332, 0.0257015563547611, 0.0256469901651144, 0.0255924854427576, 0.0255379900336266, 0.0254835840314627, 0.0254292190074921, 0.0253749098628759, 0.0253206323832273, 0.0252664647996426, 0.0252122692763805, 0.025158204138279, 0.0251041390001774, 0.0250501427799463, 0.0249962043017149, 0.0249423217028379, 0.0248884670436382, 0.0248347017914057, 0.0247809458523989, 0.0247272904962301, 0.0246736519038677, 0.0246200822293758, 0.0245665535330772, 0.0245131012052298, 0.0244596712291241, 0.0244063436985016, 0.0243530049920082, 0.0242997761815786, 0.0242465771734715, 0.0241934172809124, 0.0241403020918369, 0.0240872744470835, 0.0240342728793621, 0.0239813420921564, 0.0239284411072731, 0.0238756109029055, 0.0238228105008602, 0.0237701088190079, 0.0237174052745104, 0.0236647874116898, 0.0236122291535139, 0.0235597100108862, 0.0235072486102581, 0.0234548579901457, 0.0234024561941624, 0.0233501791954041, 0.0232979170978069, 0.0232457257807255, 0.0231935493648052, 0.0231414996087551, 0.0230894237756729, 0.0230374597012997, 0.0229855086654425, 0.0229336451739073, 0.022881768643856, 0.0228300206363201, 0.0227782689034939, 0.0227266140282154, 0.0226749647408724, 0.0226234421133995, 0.0225718896836042, 0.0225204527378082, 0.0224690288305283, 0.0224176906049252, 0.0223663523793221, 0.0223151557147503, 0.0222639050334692, 0.0222127921879292, 0.0221616961061954, 0.0221106577664614, 0.0220596715807915, 0.0220087487250566, 0.0219578351825476, 0.0219070352613926, 0.0218562502413988, 0.021805526688695, 0.0217548534274101, 0.021704213693738, 0.0216536689549685, 0.0216031558811665, 0.0215526837855577, 0.0215022824704647, 0.0214519388973713, 0.0214016251266003, 0.0213513802736998, 0.0213011913001537, 0.0212510321289301, 0.0212009754031897, 0.0211509000509977, 0.0211009252816439, 0.0210510212928057, 0.0210011042654514, 0.0209513027220964, 0.0209014993160963, 0.02085180580616, 0.0208021327853203, 0.0207524970173836, 0.0207029487937689, 0.0206534322351217, 0.0206039529293776, 0.0205545928329229, 0.020505229011178, 0.0204559210687876, 0.0204066839069128, 0.020357508212328, 0.0203083567321301, 0.0202592629939318, 0.0202102568000555, 0.0201612189412117, 0.0201140064746141, 0.0200685355812311, 0.0200231242924929, 0.0199777521193027, 0.0199324227869511, 0.0198871530592442, 0.0198419690132141, 0.0197968259453773, 0.0197517387568951, 0.01970667950809, 0.0196617096662521, 0.0196167789399624, 0.0195718910545111, 0.0195270460098982, 0.019482271745801, 0.0194375440478325, 0.0193929262459278, 0.0193482786417007, 0.0193037614226341, 0.0192592293024063, 0.0192147959023714, 0.0191703792661428, 0.0191260445863008, 0.0190817657858133, 0.0190375354140997, 0.0189933571964502, 0.0189492236822844, 0.0189051311463118, 0.0188611540943384, 0.0188171900808811, 0.0187732707709074, 0.018729405477643, 0.0186856258660555, 0.0186418741941452, 0.0185981523245573, 0.0185545179992914, 0.0185109227895737, 0.0184673983603716, 0.0184239596128464, 0.0183805096894503, 0.0183371566236019, 0.0182938314974308, 0.0182505641132593, 0.0182073265314102, 0.0181641858071089, 0.0181210748851299, 0.0180780496448278, 0.018035052344203, 0.0179921388626099, 0.0179492123425007, 0.0179063845425844, 0.0178636163473129, 0.0178209021687508, 0.0177782159298658, 0.0177356321364641, 0.0176930613815784, 0.0176505614072084, 0.0176080744713545, 0.0175656899809837, 0.0175233297049999, 0.0174810439348221, 0.0174387991428375, 0.017396654933691, 0.0173544939607382, 0.0173124074935913, 0.0172703769057989, 0.017228415235877, 0.0171864982694387, 0.0171446651220322, 0.0171028338372707, 0.0170611143112183, 0.0170193817466497, 0.0169777348637581, 0.0169361419975758, 0.0168946236371994, 0.0168531183153391, 0.0168117117136717, 0.0167703218758106, 0.0167290139943361, 0.016687722876668, 0.0166465286165476, 0.0166053362190723, 0.01656424254179, 0.016523189842701, 0.0164822116494179, 0.0164412464946508, 0.0164003521203995, 0.0163595136255026, 0.0163187459111214, 0.0162780098617077, 0.0162373278290033, 0.0161967035382986, 0.0161561630666256, 0.0161156263202429, 0.0160751566290855, 0.016034746542573, 0.015994418412447, 0.0159541070461273, 0.0159138813614845, 0.0158736817538738, 0.0158335696905851, 0.0157934706658125, 0.0157534275203943, 0.0157134439796209, 0.0156735442578793, 0.0156336724758148, 0.0155938714742661, 0.0155540863052011, 0.0155144277960062, 0.0154747273772955, 0.0154351396486163, 0.0153955947607756, 0.0153561355546117, 0.0153166754171252, 0.0152773158624768, 0.0152379712089896, 0.0151987103745341, 0.01515943557024, 0.0151203032582998, 0.0150811709463596, 0.0150421522557735, 0.0150031326338649, 0.0149641986936331, 0.0149252666160464, 0.0148864313960075, 0.0148476269096136, 0.0148088913410902, 0.0147702135145664, 0.0147316064685583, 0.0146930143237114, 0.014654534868896, 0.0146160135045648, 0.0145776197314262, 0.0145392837002873, 0.0145009756088257, 0.0144627094268799, 0.014424541965127, 0.0143864043056965, 0.0143483243882656, 0.0143102426081896, 0.0142722744494677, 0.0142343500629067, 0.0141964694485068, 0.0141586586833, 0.0141209028661251, 0.0140831768512726, 0.0140455225482583, 0.0140079110860825, 0.0139703834429383, 0.0139328707009554, 0.0138954576104879, 0.0138580435886979, 0.0138207310810685, 0.0137834465131164, 0.0137462168931961, 0.0137090170755982, 0.0136719448491931, 0.0136348577216268, 0.0135978562757373, 0.0135608995333314, 0.0135239837691188, 0.0134871378540993, 0.0134503357112408, 0.0134135913103819, 0.0133769158273935, 0.0133402841165662, 0.013303711079061, 0.0132671780884266, 0.0132307019084692, 0.0131942695006728, 0.0131579218432307, 0.0131216030567884, 0.0130853690207005, 0.0130491498857737, 0.0130130155012012, 0.0129769090563059, 0.0129408594220877, 0.012904854491353, 0.0128689473494887, 0.0128330681473017, 0.0127972615882754, 0.0127614820376039, 0.0127257723361254, 0.0126901073381305, 0.0126544991508126, 0.012618918903172, 0.0125834373757243, 0.0125479847192764, 0.0125126047059894, 0.0124772666022182, 0.01244199834764, 0.0124067161232233, 0.0123715624213219, 0.0123364087194204, 0.0123013686388731, 0.0122663425281644, 0.0122314020991325, 0.0121964896097779, 0.0121616339311004, 0.0121267922222614, 0.0120920790359378, 0.0120573658496141, 0.012022752314806, 0.0119881518185139, 0.0119536649435759, 0.0119191519916058, 0.011884736828506, 0.0118503496050835, 0.0118160350248218, 0.0117817893624306, 0.0117475874722004, 0.0117134135216475, 0.0116793410852551, 0.0116452807560563, 0.0116112781688571, 0.0115773314610124, 0.0115434704348445, 0.0115096233785152, 0.0114758489653468, 0.0114421434700489, 0.0114084975793958, 0.0113748628646135, 0.0113412998616695, 0.0113077657297254, 0.0112743182107806, 0.0112409256398678, 0.0112076047807932, 0.0111742839217186, 0.0111410468816757, 0.0111078545451164, 0.0110747329890728, 0.0110416542738676, 0.0110086593776941, 0.0109756644815207, 0.0109427701681852, 0.0109099037945271, 0.0108770960941911, 0.0108443284407258, 0.01081164740026, 0.0107789793983102, 0.0107464110478759, 0.0107138715684414, 0.010681388899684, 0.0106489639729261, 0.0106165809556842, 0.0105842547491193, 0.0105520142242312, 0.0105197727680206, 0.0104876458644867, 0.0104555040597916, 0.0104234609752893, 0.0103914486244321, 0.0103595051914454, 0.0103276195004582, 0.010295819491148, 0.0102640045806766, 0.0102322893217206, 0.0102006169036031, 0.0101690152660012, 0.0101373987272382, 0.0101059256121516, 0.0100744375959039, 0.0100430492311716, 0.0100117046386003, 0.00998042803257704, 0.00994915422052145, 0.00991796422749758, 0.00988681707531214, 0.00985574163496494, 0.00982469506561756, 0.00979376118630171, 0.0097628403455019, 0.00973196420818567, 0.00970115792006254, 0.0096703814342618, 0.00963965989649296, 0.00960903987288475, 0.00957843195647001, 0.00954791158437729, 0.00951740331947803, 0.00948699563741684, 0.00945660192519426, 0.00942626409232616, 0.00939598400145769, 0.00936577562242746, 0.00933560915291309, 0.00930551346391439, 0.00927544664591551, 0.00924545060843229, 0.00921546947211027, 0.00918560102581978, 0.00915573257952929, 0.00912597868591547, 0.00909622386097908, 0.00906655471771955, 0.00903692841529846, 0.00900735892355442, 0.00897781737148762, 0.00894837640225887, 0.00891894847154617, 0.00888959225267172, 0.00886029191315174, 0.00883106421679258, 0.00880184955894947, 0.00877269171178341, 0.00874361861497164, 0.00871458929032087, 0.00868561677634716, 0.00865671504288912, 0.00862779933959246, 0.00859902519732714, 0.00857020821422338, 0.00854150578379631, 0.00851286016404629, 0.00848427042365074, 0.00845570955425501, 0.00842723436653614, 0.00839878711849451, 0.00837039668112993, 0.00834203511476517, 0.00831377226859331, 0.00828553829342127, 0.00825740396976471, 0.00822926964610815, 0.00820122007280588, 0.00817318540066481, 0.00814525038003922, 0.00811732839792967, 0.00808949209749699, 0.00806168466806412, 0.00803399085998535, 0.00800628215074539, 0.00797866005450487, 0.0079510509967804, 0.00792352762073278, 0.00789604615420103, 0.00786866433918476, 0.00784128345549107, 0.00781398732215166, 0.00778673402965069, 0.00775955151766539, 0.00773235457018018, 0.00770528567954898, 0.00767824565991759, 0.00765126198530197, 0.00762430671602488, 0.00759745109826326, 0.00757063832134008, 0.00754386791959405, 0.00751712545752525, 0.00749048357829452, 0.0074638407677412, 0.00743731157854199, 0.0074108112603426, 0.00738438218832016, 0.00735799502581358, 0.00733163673430681, 0.0073053352534771, 0.00727911945432425, 0.00725294556468725, 0.00722681451588869, 0.00720075471326709, 0.00717475172132254, 0.00714879110455513, 0.00712287332862616, 0.00709699792787433, 0.00707122217863798, 0.00704547436907887, 0.00701978430151939, 0.00699415104463696, 0.0069685741327703, 0.00694301119074225, 0.00691754836589098, 0.00689211394637823, 0.0068667777813971, 0.00684145744889975, 0.00681619299575686, 0.00679097138345242, 0.00676586339250207, 0.00674069859087467, 0.006715705152601, 0.00669069588184357, 0.00666577229276299, 0.00664086453616619, 0.00661606853827834, 0.00659127300605178, 0.00656656362116337, 0.00654186774045229, 0.00651727151125669, 0.00649268925189972, 0.00646822107955813, 0.00644373800605536, 0.00641936855390668, 0.0063950284384191, 0.00637070182710886, 0.00634646089747548, 0.00632230471819639, 0.00629816297441721, 0.0062741064466536, 0.00625010672956705, 0.00622613588348031, 0.00620216503739357, 0.00617832178249955, 0.0061545493081212, 0.00613077683374286, 0.00610707607120275, 0.00608346005901694, 0.00605985848233104, 0.0060363276861608, 0.00601283926516771, 0.00598939415067434, 0.00596601935103536, 0.00594273023307323, 0.00591945555061102, 0.00589625164866447, 0.00587310502305627, 0.00584995839744806, 0.00582689605653286, 0.00580393383279443, 0.00578098557889462, 0.00575809460133314, 0.00573524599894881, 0.00571248214691877, 0.00568976160138845, 0.00566706946119666, 0.00564446253702044, 0.00562188401818275, 0.00559936137869954, 0.00557691138237715, 0.00555454567074776, 0.00553217995911837, 0.00550988549366593, 0.00548761943355203, 0.00546541064977646, 0.00544331455603242, 0.00542124779894948, 0.00539919501170516, 0.00537725538015366, 0.00535528780892491, 0.00533344782888889, 0.00531163671985269, 0.00528989685699344, 0.00526818446815014, 0.00524651538580656, 0.00522494595497847, 0.00520341796800494, 0.00518190581351519, 0.00516047747805715, 0.00513909244909883, 0.00511777866631746, 0.00509649328887463, 0.00507529312744737, 0.00505410647019744, 0.00503299105912447, 0.00501191895455122, 0.00499094557017088, 0.00496998708695173, 0.00494911428540945, 0.00492825452238321, 0.00490748044103384, 0.0048867492005229, 0.0048660458996892, 0.00484541384503245, 0.00482486747205257, 0.00480434903874993, 0.00478388741612434, 0.00476346863433719, 0.0047431206330657, 0.00472281593829393, 0.00470256805419922, 0.00468234764412045, 0.00466222735121846, 0.00464213499799371, 0.00462212832644582, 0.00460213609039783, 0.00458224304020405, 0.00456232158467174, 0.00454252772033215, 0.00452274829149246, 0.00450305407866836, 0.00448338827118278, 0.00446380814537406, 0.00444425595924258, 0.00442477501928806, 0.00440530804917216, 0.00438594073057175, 0.00436658784747124, 0.00434731971472502, 0.00432809488847852, 0.00430895481258631, 0.0042898147366941, 0.00427074590697885, 0.00425171945244074, 0.00423279264941812, 0.00421387981623411, 0.00419505266472697, 0.00417625345289707, 0.00415752548724413, 0.00413879752159119, 0.00412018364295363, 0.00410285638645291, 0.00408665742725134, 0.00407048035413027, 0.00405435264110565, 0.00403824588283896, 0.00402216846123338, 0.00400611199438572, 0.00399011187255383, 0.00397414108738303, 0.00395818380638957, 0.00394228333607316, 0.00392639776691794, 0.00391055410727859, 0.00389471068046987, 0.00387893826700747, 0.0038631942588836, 0.00384745723567903, 0.0038317774888128, 0.00381611869670451, 0.00380048830993474, 0.00378490798175335, 0.00376931321807206, 0.00375379645265639, 0.00373830832540989, 0.00372284883633256, 0.00370741006918252, 0.00369202136062086, 0.00367663963697851, 0.00366130797192454, 0.00364597584120929, 0.00363071518950164, 0.00361548271030188, 0.00360028585419059, 0.00358511018566787, 0.00356995593756437, 0.00355483707971871, 0.00353975407779217, 0.0035246922634542, 0.00350967282429338, 0.00349470344372094, 0.00347975525073707, 0.00346483499743044, 0.00344995805062354, 0.00343510205857456, 0.00342024606652558, 0.00340546853840351, 0.00339069799520075, 0.0033759840298444, 0.00336130592040718, 0.00334662757813931, 0.00333200627937913, 0.00331738474778831, 0.00330282049253583, 0.00328826997429132, 0.00327376928180456, 0.00325929722748697, 0.00324487430043519, 0.0032304662745446, 0.00321607920341194, 0.00320173474028707, 0.00318741193041205, 0.00317314593121409, 0.00315890787169337, 0.0031446844805032, 0.00313050346449018, 0.00311636505648494, 0.00310222688131034, 0.0030881455168128, 0.00307407835498452, 0.00306007475592196, 0.00304608582518995, 0.00303211784921587, 0.00301819993183017, 0.003004310419783, 0.00299042067490518, 0.00297658797353506, 0.00296279066242278, 0.00294903619214892, 0.00293530966155231, 0.00292160478420556, 0.00290794274769723, 0.00289428746327758, 0.00288067478686571, 0.00286711915396154, 0.00285356328822672, 0.00284005748108029, 0.00282657984644175, 0.00281315203756094, 0.00279972399584949, 0.00278632459230721, 0.00277298223227262, 0.00275966827757657, 0.00274638226255774, 0.0027331318706274, 0.00271991034969687, 0.00270672398619354, 0.00269355205819011, 0.00268042227253318, 0.00266733556054533, 0.00265427748672664, 0.00264124711975455, 0.00262825307436287, 0.00261530093848705, 0.00260232808068395, 0.00258943298831582, 0.00257657328620553, 0.00256374967284501, 0.0025509325787425, 0.0025381725281477, 0.00252542714588344, 0.00251272367313504, 0.00250002066604793, 0.00248738168738782, 0.00247477064840496, 0.00246219546534121, 0.00244966265745461, 0.00243714428506792, 0.00242466852068901, 0.00241217855364084, 0.00239975959993899, 0.00238738325424492, 0.00237502832897007, 0.00236270157620311, 0.00235041044652462, 0.00233816192485392, 0.00232592783868313, 0.00231370772235096, 0.00230155885219574, 0.00228942395187914, 0.00227732490748167, 0.00226525380276144, 0.00225323275662959, 0.00224124011583626, 0.00222926144488156, 0.00221730442717671, 0.00220540398731828, 0.0021935252007097, 0.00218168878927827, 0.00216988055035472, 0.00215809396468103, 0.00214636418968439, 0.00213462742976844, 0.00212293304502964, 0.00211129570379853, 0.00209967233240604, 0.00208809156902134, 0.0020765324588865, 0.0020650087390095, 0.00205353461205959, 0.00204204651527107, 0.00203063618391752, 0.00201923330314457, 0.00200788001529872, 0.00199654814787209, 0.00198525888845325, 0.00197397638112307, 0.00196273671463132, 0.00195154000539333, 0.00194037135224789, 0.00192923122085631, 0.0019181267125532, 0.00190705771092325, 0.00189600978046656, 0.00188497616909444, 0.00187401380389929, 0.00186307262629271, 0.00185215985402465, 0.0018412753706798, 0.00183044071309268, 0.00181962037459016, 0.00180882844142616, 0.00179805757943541, 0.00178733677603304, 0.00177665136288851, 0.00176600855775177, 0.00175538705661893, 0.00174479396082461, 0.0017342222854495, 0.00172367878258228, 0.00171317812055349, 0.00170270586386323, 0.0016922903014347, 0.00168189639225602, 0.00167153053916991, 0.00166120042558759, 0.00165089860092849, 0.0016405968926847, 0.00163035187870264, 0.00162014260422438, 0.00160997570492327, 0.00159984442871064, 0.0015897344565019, 0.00157965288963169, 0.00156960694584996, 0.00155957520473748, 0.00154957175254822, 0.00153961812611669, 0.00152972142677754, 0.00151983881369233, 0.00150997738819569, 0.00150014460086823, 0.00149034720379859, 0.00148058531340212, 0.00147086614742875, 0.00146116828545928, 0.00145151314791292, 0.00144187908153981, 0.00143228785600513, 0.00142273912206292, 0.00141316908411682, 0.00140367017593235, 0.00139419257175177, 0.00138475047424436, 0.00137535098474473, 0.00136596569791436, 0.00135663722176105, 0.0013473016442731, 0.00133803719654679, 0.00132878706790507, 0.00131957931444049, 0.00131038588006049, 0.00130123517010361, 0.00129214103799313, 0.00128301861695945, 0.00127396732568741, 0.0012649514246732, 0.00125597114674747, 0.00124701217282563, 0.00123807450290769, 0.00122919352725148, 0.00122032698709518, 0.00121147464960814, 0.0012026788899675, 0.0011939259711653, 0.00118519447278231, 0.00117649114690721, 0.00116782356053591, 0.00115918426308781, 0.00115055905189365, 0.00114197668153793, 0.00113345112185925, 0.00112495385110378, 0.00111647101584822, 0.00110802345443517, 0.00109961861744523, 0.00109124928712845, 0.00108286587055773, 0.0010745320469141, 0.00106626923661679, 0.00105801364406943, 0.00104980065952986, 0.00104161608032882, 0.00103345990646631, 0.00102532503660768, 0.00101721147075295, 0.00100914773065597, 0.00100112648215145, 0.00099314795807004, 0.000985176535323262, 0.000977247720584273, 0.000969333108514547, 0.00096146110445261, 0.000953624665271491, 0.000945802428759634, 0.000938058365136385, 0.000930321402847767, 0.000922605686355382, 0.000914939737413079, 0.000907266687136143, 0.000899650505743921, 0.000892076874151826, 0.000884531764313579, 0.000877022161148489, 0.000869533803779632, 0.000862095213960856, 0.000854685029480606, 0.000847260700538754, 0.000839900167193264, 0.000832589517813176, 0.000825307215563953, 0.000818046217318624, 0.000810820783954114, 0.00080363085726276, 0.000796440930571407, 0.000789307872764766, 0.000782210263423622, 0.000775148277170956, 0.000768114579841495, 0.00076110934605822, 0.000754146836698055, 0.000747212674468756, 0.000740285555366427, 0.000733422464691103, 0.00072656647535041, 0.000719760195352137, 0.000712996523361653, 0.000706240010913461, 0.000699526106473058, 0.000692826404701918, 0.000686176470480859, 0.000679561984725296, 0.000672968861181289, 0.000666432490106672, 0.000659896177239716, 0.000653409631922841, 0.000646965752821416, 0.000640500511508435, 0.000634127587545663, 0.000627768866252154, 0.000621445768047124, 0.000615136814303696, 0.000608870468568057, 0.000602646789047867, 0.000596451514866203, 0.000590256182476878, 0.000584117835387588, 0.000578021979890764, 0.000571940385270864, 0.000565915601328015, 0.000559905078262091, 0.000553922902327031, 0.000547947885934263, 0.00054204388288781, 0.000536161242052913, 0.000530328310560435, 0.000524502480402589, 0.000518719258252531, 0.000512978702317923, 0.000507223885506392, 0.000501533038914204, 0.000495891959872097, 0.000490257982164621, 0.000484673655591905, 0.000479132024338469, 0.000473597494419664, 0.000468098500277847, 0.000462613679701462, 0.00045718569890596, 0.00045177192077972, 0.000446407881099731, 0.000441079377196729, 0.000435786409070715, 0.000430500542279333, 0.000425250182161108, 0.000420049560489133, 0.000414863141486421, 0.000409719388699159, 0.000404611113481224, 0.000399524171371013, 0.000394494069041684, 0.000389492372050881, 0.000384469400160015, 0.000379524513846263, 0.000374615221517161, 0.00036972007364966, 0.000364867562893778, 0.000360050587914884, 0.000355262076482177, 0.000350509042618796, 0.000345763110090047, 0.000341052713338286, 0.000336384953698143, 0.000331774004735053, 0.000327170215314254, 0.000322594773024321, 0.000318033591611311, 0.000313557626213878, 0.000309074588585645, 0.0003046341589652, 0.000300243467791006, 0.000295867008389905, 0.000291533156996593, 0.000287220580503345, 0.000282908062217757, 0.000278666586382315, 0.000274467747658491, 0.000270275981165469, 0.000266126822680235, 0.000262034533079714, 0.000257935142144561, 0.000253878388321027, 0.000249835808062926, 0.000245850096689537, 0.000241885689320043, 0.00023797812173143, 0.000234084785915911, 0.000230219797231257, 0.000226390387979336, 0.000222575195948593, 0.000218802611925639, 0.000215072650462389, 0.000211392441997305, 0.000207719305763021, 0.000204088835744187, 0.000200479655177332, 0.000196913097170182, 0.000193332351045683, 0.000189836850040592, 0.000186355580808595, 0.000182924006367102, 0.000179506663698703, 0.000176124856807292, 0.000172778542037122, 0.000169446429936215, 0.00016616408538539, 0.000162895943503827, 0.000159684626851231, 0.000156501744640991, 0.000153361455886625, 0.000150221196236089, 0.000147137776366435, 0.000144054341944866, 0.000141027761856094, 0.000138029572553933, 0.000135074034915306, 0.00013212559861131, 0.000129248204757459, 0.000126377926790155, 0.000123543155496009, 0.000120708384201862, 0.000117937561299186, 0.000115209382784087, 0.000112495385110378, 0.000109824039100204, 0.00010719529382186, 0.000104552360426169, 0.00010198047675658, 9.94370057014748e-05, 9.69148386502638e-05, 9.44353159866296e-05, 9.19841913855635e-05, 8.95615085028112e-05, 8.71885422384366e-05, 8.48155832500197e-05, 8.24781527626328e-05, 8.01975547801703e-05, 7.79382535256445e-05, 7.5714495324064e-05, 7.35191497369669e-05, 7.13735425961204e-05, 6.92279281793162e-05, 6.71107336529531e-05, 6.50503789074719e-05, 6.30184513283893e-05, 6.10149290878326e-05, 5.90540403209161e-05, 5.71002565266099e-05, 5.52104102098383e-05, 5.32992526132148e-05, 5.14591447426938e-05, 4.96616630698554e-05, 4.78783913422376e-05, 4.61448507849127e-05, 4.44184152001981e-05, 4.27417107857764e-05, 4.1107639844995e-05, 3.9445141737815e-05, 3.78608019673266e-05, 3.63261933671311e-05, 3.48057910741773e-05, 3.33138123096433e-05, 3.18715610774234e-05, 3.04364166368032e-05, 2.90154821414035e-05, 2.76655955531169e-05, 2.6329915272072e-05, 2.50368648266885e-05, 2.37864423979772e-05, 2.25360254262341e-05, 2.13566454476677e-05, 2.0163060980849e-05, 1.90121027117129e-05, 1.79037760972278e-05, 1.68380720424466e-05, 1.58007933350746e-05, 1.479192997067e-05, 1.38256918944535e-05, 1.28878773466568e-05, 1.1964268196607e-05, 1.10548708107672e-05, 1.02307276392821e-05, 9.40658446779707e-06, 8.61796706885798e-06, 7.88618763181148e-06, 7.15440546628088e-06, 6.45104182694922e-06, 5.77610035179532e-06, 5.15799320055521e-06, 4.58251452073455e-06, 4.00703629566124e-06, 3.48128946825454e-06, 2.99817156701465e-06, 2.53636835623183e-06, 2.07456423595431e-06, 1.66959807756939e-06, 1.3072600495434e-06, 9.94653987618221e-07, 6.82048550970649e-07, 4.12071159416882e-07, 1.77616840346673e-07, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 1.15006756034312e-15, 2.01772718355642e-06, 6.13843758401345e-06, 1.02733565654489e-05, 1.44509040183038e-05, 1.8614242435433e-05, 2.28059998335084e-05, 2.70261753030354e-05, 3.12463525915518e-05, 3.54949443135411e-05, 3.97577459807508e-05, 4.40205549239181e-05, 4.83117764815688e-05, 5.26456242369022e-05, 5.69510557397734e-05, 6.12849034951068e-05, 6.56329648336396e-05, 7.00378659530543e-05, 7.44143399060704e-05, 7.88050310802646e-05, 8.32383448141627e-05, 8.76858684932813e-05, 9.21333921723999e-05, 9.66235529631376e-05, 0.000101099496532697, 0.000105603859992698, 0.000110136636067182, 0.000114655209472403, 0.000119216412713286, 0.000123806035844609, 0.000128381434478797, 0.000132985267555341, 0.00013758908607997, 0.000142249758937396, 0.000146896214573644, 0.00015155688743107, 0.000156260168296285, 0.000160949261044152, 0.000165666759130545, 0.000170426894328557, 0.000175172812305391, 0.000179918730282225, 0.000184735705261119, 0.000189524245797656, 0.000194327003555372, 0.000199172398424707, 0.00020403198141139, 0.000208891593501903, 0.000213779610930942, 0.000218667628359981, 0.000223598253796808, 0.000228514705668204, 0.000233473750995472, 0.000238447028095834, 0.000243420305196196, 0.000248422002186999, 0.000253437872743234, 0.000258468004176393, 0.000263526511844248, 0.000268585048615932, 0.000273643585387617, 0.000278773135505617, 0.000283874309388921, 0.000288989685941488, 0.000294176075840369, 0.000299319857731462, 0.00030449207406491, 0.000309678493067622, 0.000314907520078123, 0.000320136547088623, 0.000325365603202954, 0.000330637267325073, 0.000335923134116456, 0.000341209000907838, 0.000346523302141577, 0.000351866037817672, 0.000357194512616843, 0.000362565682735294, 0.000367936794646084, 0.000373322138329968, 0.000378750119125471, 0.00038416386814788, 0.000389591848943383, 0.000395076640415937, 0.000400547229219228, 0.000406032049795613, 0.00041153107304126, 0.000417072704294696, 0.000422614364651963, 0.000428155995905399, 0.000433754496043548, 0.000439338764408603, 0.000444923032773659, 0.000450564140919596, 0.000456205249065533, 0.000461846386315301, 0.00046754430513829, 0.000473228021292016, 0.000478925998322666, 0.000484666554257274, 0.000490392907522619, 0.000496147724334151, 0.000501902482938021, 0.000507699907757342, 0.000513497332576662, 0.000519323162734509, 0.00052517739823088, 0.00053101743105799, 0.000536885927431285, 0.00054279703181237, 0.000548679672647268, 0.000554590777028352, 0.000560558692086488, 0.000566498201806098, 0.000572451914194971, 0.000578448234591633, 0.000584458757657558, 0.000590469338931143, 0.000596508325543255, 0.000602547312155366, 0.000608614704106003, 0.000614696298725903, 0.000620806298684329, 0.000626930501312017, 0.000633040559478104, 0.000639207370113581, 0.000645374297164381, 0.000651555310469121, 0.000657764787320048, 0.000663974322378635, 0.000670198001898825, 0.000676464289426804, 0.00068271643249318, 0.000688982720021158, 0.00069530593464151, 0.000701614888384938, 0.000707937986589968, 0.00071426120121032, 0.000720655429176986, 0.000727035338059068, 0.000733415421564132, 0.000739837996661663, 0.000746274832636118, 0.000752711668610573, 0.000759176909923553, 0.000765670614782721, 0.000772150058764964, 0.000778672168962657, 0.000785208423621953, 0.000791730533819646, 0.00079830945469439, 0.000804874231107533, 0.00081146729644388, 0.000818103086203337, 0.000824710412416607, 0.000831346202176064, 0.000837996136397123, 0.000844688795041293, 0.000851381395477802, 0.000858073937706649, 0.00086482334882021, 0.000871558615472168, 0.000878308084793389, 0.000885085959453136, 0.000891892239451408, 0.000898684316780418, 0.000905518943909556, 0.000912367831915617, 0.000919202575460076, 0.000926094071473926, 0.000932985625695437, 0.000939877179916948, 0.000946782936807722, 0.000953745446167886, 0.000960708013735712, 0.000967656378634274, 0.00097466167062521, 0.000981652643531561, 0.000988672021776438, 0.000995734124444425, 0.00100278190802783, 0.00100982980802655, 0.00101694872137159, 0.00102403911296278, 0.00103114382363856, 0.00103830534499139, 0.00104545254725963, 0.00105261406861246, 0.00105981819797307, 0.00106702244374901, 0.00107422657310963, 0.00108144490513951, 0.0010887342505157, 0.0010959809878841, 0.00110325624700636, 0.00111057399772108, 0.00111789186485112, 0.00112520961556584, 0.00113257009070367, 0.0011399305658415, 0.00114731944631785, 0.00115472252946347, 0.00116213981527835, 0.00116955698467791, 0.00117703119758517, 0.00118449097499251, 0.00119195098523051, 0.0011994392843917, 0.00120698439422995, 0.00121450121514499, 0.00122203212231398, 0.00122960563749075, 0.00123719358816743, 0.00124478130601346, 0.00125241174828261, 0.00126004219055176, 0.00126767251640558, 0.00127535976935178, 0.00128303293604404, 0.00129072007257491, 0.0012984499335289, 0.00130616570822895, 0.0013139097718522, 0.00132168224081397, 0.00132945482619107, 0.00133722741156816, 0.00134504237212241, 0.00135288597084582, 0.00136071536689997, 0.00136855896562338, 0.00137644517235458, 0.00138434546533972, 0.00139224587474018, 0.00140018889214844, 0.00140813190955669, 0.00141607492696494, 0.00142407475505024, 0.0014320604968816, 0.00144006032496691, 0.00144810287747532, 0.00145614531356841, 0.00146418774966151, 0.00147224450483918, 0.00148035807069391, 0.00148845743387938, 0.00149657088331878, 0.00150469865184277, 0.00151286914478987, 0.00152103940490633, 0.00152922398410738, 0.00153743708506227   }, 
   { 0.000137982351589017, 0.000155545712914318, 0.000173109074239619, 0.000190753882634453, 0.000208425830351189, 0.000226097763516009, 0.000243824018980376, 0.00026157739921473, 0.000279412226518616, 0.000297219899948686, 0.000315054727252573, 0.000332943833200261, 0.000350832939147949, 0.00036877635284327, 0.000386746920412406, 0.000404771766625345, 0.000422796612838283, 0.000440875708591193, 0.000458954862551764, 0.000477088295156136, 0.000495303131174296, 0.000513490871526301, 0.000531705736648291, 0.000549974909517914, 0.000568244024179876, 0.000586567504797131, 0.000604918110184371, 0.000623322965111583, 0.000641727878246456, 0.000660187040921301, 0.000678646203596145, 0.000697214039973915, 0.000715754576958716, 0.000734322296921164, 0.00075291731627658, 0.000771566468756646, 0.000790215679444373, 0.000808919197879732, 0.000827676907647401, 0.000846434675622731, 0.000865219684783369, 0.000884113134816289, 0.000902952393516898, 0.000921845901757479, 0.000940766534768045, 0.000959714350756258, 0.000978689291514456, 0.000997718540020287, 0.00101674778852612, 0.00103583128657192, 0.00105496915057302, 0.00107410701457411, 0.00109327188692987, 0.00111251825001091, 0.00113176472950727, 0.00115103821735829, 0.00117033894639462, 0.00118966680020094, 0.00120902189519256, 0.00122840399853885, 0.00124784035142511, 0.00126730394549668, 0.00128679466433823, 0.00130631250794977, 0.00132591184228659, 0.0013455111766234, 0.00136513763573021, 0.00138476409483701, 0.00140444468706846, 0.00142415275331587, 0.00144388759508729, 0.00146367691922933, 0.00148349348455667, 0.00150333705823869, 0.001523207873106, 0.00154316006228328, 0.00156308512669057, 0.00158303719945252, 0.00160304375458509, 0.00162307755090296, 0.00164311111439019, 0.0016631989274174, 0.00168331409804523, 0.00170348351821303, 0.0017236799467355, 0.00174390361644328, 0.00176420877687633, 0.00178448657970876, 0.00180479185655713, 0.00182512390892953, 0.00184551044367254, 0.00186589697841555, 0.00188633799552917, 0.00190680578816682, 0.0019273009384051, 0.00194787746295333, 0.00196842709556222, 0.00198908499442041, 0.00200971588492393, 0.00203037378378212, 0.00205105892382562, 0.00207177107222378, 0.00209253770299256, 0.00211330433376133, 0.00213412521407008, 0.00215497333556414, 0.00217584823258221, 0.00219677784480155, 0.00221778871491551, 0.00223874533548951, 0.00225975620560348, 0.00228079431690276, 0.0023018594365567, 0.00232297880575061, 0.00234409840777516, 0.00236527202650905, 0.00238647311925888, 0.00240770098753273, 0.0024289833381772, 0.00245031993836164, 0.00247165677137673, 0.00249299313873053, 0.00251438422128558, 0.0025358023121953, 0.00255724764429033, 0.00257871975190938, 0.00260024657472968, 0.00262177316471934, 0.00264335423707962, 0.00266498932614923, 0.00268667889758945, 0.00270834122784436, 0.00273005804046988, 0.00275177485309541, 0.00277354568243027, 0.00279534398578107, 0.0028171690646559, 0.00283902161754668, 0.00286092818714678, 0.00288286223076284, 0.00290479580871761, 0.00292686535976827, 0.00294888066127896, 0.00297092297114432, 0.00299301976338029, 0.0030151167884469, 0.0030372675973922, 0.00305944588035345, 0.00308165093883872, 0.00310388347133994, 0.00312617025338113, 0.00314845680259168, 0.00317087932489812, 0.00319324759766459, 0.00321564287878573, 0.00323806563392282, 0.00326051493175328, 0.003283018944785, 0.00330554996617138, 0.00332810846157372, 0.00335069349966943, 0.0033733060117811, 0.00339597277343273, 0.00341869378462434, 0.0034414422698319, 0.0034641632810235, 0.00348693854175508, 0.00350976805202663, 0.00353259779512882, 0.00355548178777099, 0.00357836578041315, 0.00360133126378059, 0.00362426950596273, 0.00364728923887014, 0.00367036298848689, 0.00369343697093427, 0.00371653819456697, 0.00373966642655432, 0.00376282189972699, 0.00378600438125432, 0.00380924111232162, 0.00383247807621956, 0.00385576928965747, 0.00387908751145005, 0.00390243297442794, 0.0039258599281311, 0.00394925940781832, 0.0039727408438921, 0.00399619434028864, 0.00401970325037837, 0.00404323823750019, 0.00406680116429925, 0.00409041810780764, 0.00411403458565474, 0.00413770601153374, 0.0041614044457674, 0.00418518390506506, 0.00420893682166934, 0.00423274375498295, 0.00425657769665122, 0.00428041163831949, 0.00430430006235838, 0.00432821549475193, 0.00435215840116143, 0.00437615532428026, 0.0044001517817378, 0.00442420318722725, 0.00444833561778069, 0.00447244150564075, 0.00449657393619418, 0.00452076084911823, 0.00454494822770357, 0.00456918962299824, 0.00459345756098628, 0.00461775343865156, 0.00464207585901022, 0.00466642575338483, 0.00469082966446877, 0.00471531553193927, 0.00473977392539382, 0.00476423185318708, 0.0047887722030282, 0.0048133390955627, 0.00483790598809719, 0.0048625273630023, 0.00488717574626207, 0.00491182412952185, 0.0049365540035069, 0.00496128387749195, 0.00498609524220228, 0.00501090660691261, 0.00503574497997761, 0.00506061082705855, 0.00508553069084883, 0.00511045008897781, 0.00513539742678404, 0.00516039878129959, 0.00518542714416981, 0.00521048298105597, 0.00523556536063552, 0.00526072969660163, 0.00528589403256774, 0.00531105790287256, 0.00533627672120929, 0.00536154955625534, 0.00538682239130139, 0.00541212223470211, 0.00543747609481215, 0.00546283088624477, 0.00548823922872543, 0.00551367504522204, 0.00553919235244393, 0.00556468218564987, 0.00559022603556514, 0.00561579735949636, 0.00564136914908886, 0.00566702149808407, 0.00569267477840185, 0.00571835460141301, 0.00574408890679479, 0.00576982321217656, 0.00579561153426766, 0.00582148181274533, 0.00584732415154576, 0.00587322190403938, 0.00589911872521043, 0.00592504255473614, 0.0059510488063097, 0.00597705459222198, 0.00600308738648891, 0.0060291476547718, 0.00605523446574807, 0.00608137575909495, 0.00610759854316711, 0.0061337947845459, 0.00616001756861806, 0.00618626736104488, 0.00621254462748766, 0.00623890338465571, 0.00626526167616248, 0.00629162043333054, 0.00631803367286921, 0.00634450046345592, 0.0063709681853652, 0.00639754347503185, 0.00642406474798918, 0.00645064050331712, 0.00647724373266101, 0.00650390097871423, 0.00653055869042873, 0.00655726995319128, 0.00658400822430849, 0.00661077396944165, 0.00663756672292948, 0.00666438741609454, 0.00669128866866231, 0.00671819038689137, 0.0067451186478138, 0.00677207484841347, 0.00679903104901314, 0.0068260682746768, 0.00685313250869513, 0.00688019674271345, 0.00690731545910239, 0.00693446164950728, 0.00696163438260555, 0.00698888907209039, 0.00701614329591393, 0.00704339798539877, 0.00707070669159293, 0.00709804240614176, 0.00712540559470654, 0.00715279579162598, 0.00718024000525475, 0.00720768421888351, 0.0072351829148829, 0.00726270908489823, 0.00729031627997756, 0.00731789646670222, 0.0073455311357975, 0.00737316533923149, 0.00740085449069738, 0.0074285427108407, 0.00745628634467721, 0.00748411053791642, 0.00751190772280097, 0.00753973191604018, 0.00756761152297258, 0.0075955712236464, 0.00762350438162684, 0.00765146454796195, 0.00767945172265172, 0.00770746637135744, 0.00773553503677249, 0.00776363164186478, 0.00779178133234382, 0.00781993195414543, 0.00784810911864042, 0.00787634029984474, 0.00790462642908096, 0.00793291348963976, 0.00796122569590807, 0.00798956584185362, 0.00801796093583107, 0.00804635602980852, 0.00807480420917273, 0.0081032533198595, 0.0081317825242877, 0.00816031359136105, 0.00818889867514372, 0.00821753684431314, 0.00824614893645048, 0.00827484205365181, 0.00830350816249847, 0.00833222828805447, 0.00836100336164236, 0.00838977750390768, 0.0084186065942049, 0.00844746269285679, 0.00847634579986334, 0.00850525591522455, 0.008534274995327, 0.00856323912739754, 0.00859225820749998, 0.00862127728760242, 0.00865037739276886, 0.0086794774979353, 0.00870860554277897, 0.00873776059597731, 0.0087669687345624, 0.00879623275250196, 0.00882546883076429, 0.00885481294244528, 0.00888415798544884, 0.00891350209712982, 0.00894290115684271, 0.0089723002165556, 0.00900175329297781, 0.00903123430907726, 0.00906076841056347, 0.00909030344337225, 0.00911989249289036, 0.00914950855076313, 0.00917920563369989, 0.00920887663960457, 0.00923857372254133, 0.00926832575351, 0.00929807778447866, 0.00932788383215666, 0.00935771688818932, 0.00938757695257664, 0.0094174649566412, 0.00944740697741508, 0.00947737600654364, 0.00950742606073618, 0.00953745003789663, 0.00956750009208918, 0.00959757715463638, 0.00962768215686083, 0.0096578411757946, 0.00968800019472837, 0.00971821416169405, 0.00974848121404648, 0.00977874919772148, 0.00980907119810581, 0.00983944721519947, 0.00986982323229313, 0.00990022718906403, 0.00993065722286701, 0.00996111426502466, 0.00999160017818213, 0.0100221391767263, 0.0100527051836252, 0.0100832991302013, 0.0101139191538095, 0.010144567117095, 0.0101752681657672, 0.0102060521021485, 0.010236781090498, 0.0102675650268793, 0.0102983750402927, 0.0103292120620608, 0.0103601049631834, 0.0103909969329834, 0.0104219429194927, 0.010452888906002, 0.0104839168488979, 0.0105149988085032, 0.0105460807681084, 0.0105771627277136, 0.0106082996353507, 0.0106394626200199, 0.0106706535443664, 0.0107018705457449, 0.0107331154868007, 0.0107644153758883, 0.0107957413420081, 0.0108270673081279, 0.0108585292473435, 0.0108899371698499, 0.0109213991090655, 0.0109528610482812, 0.0109843779355288, 0.0110158938914537, 0.0110474908724427, 0.0110790897160769, 0.0111107146367431, 0.0111423656344414, 0.0111740734428167, 0.011205805465579, 0.0112376483157277, 0.0112694362178445, 0.0113012511283159, 0.0113331209868193, 0.011364989914, 0.0113969137892127, 0.0114288637414575, 0.0114608416333795, 0.0114928465336561, 0.0115249054506421, 0.01155701931566, 0.0115891601890326, 0.0116213001310825, 0.0116534680128098, 0.0116856638342142, 0.0117179127410054, 0.0117501616477966, 0.0117824655026197, 0.0118147963657975, 0.01184715423733, 0.0118795381858945, 0.0119120329618454, 0.0119444997981191, 0.0119769927114248, 0.0120095135644078, 0.0120420614257455, 0.0120746633037925, 0.0121072651818395, 0.0121398949995637, 0.0121725779026747, 0.0122052887454629, 0.0122380275279284, 0.0122707914561033, 0.0123036662116647, 0.0123365120962262, 0.012369385920465, 0.0124022867530584, 0.0124352155253291, 0.0124681694433093, 0.0125011522322893, 0.0125341881066561, 0.0125672519207001, 0.0126003427430987, 0.012633515521884, 0.012666660360992, 0.0126998601481318, 0.0127330860123038, 0.0127663118764758, 0.0127995936200023, 0.0128329014405608, 0.0128662632778287, 0.0128996260464191, 0.0129330428317189, 0.0129664586856961, 0.0129999564960599, 0.0130334813147783, 0.013067034073174, 0.0131006138399243, 0.0131341936066747, 0.0131678264588118, 0.0132014881819487, 0.0132351759821177, 0.0132688907906413, 0.0133026605471969, 0.0133364293724298, 0.0133702540770173, 0.0134041588753462, 0.0134380096569657, 0.0134719414636493, 0.0135059002786875, 0.0135398609563708, 0.0135738747194409, 0.0136079145595431, 0.0136419832706451, 0.0136760789901018, 0.0137102277949452, 0.0137444315478206, 0.0137786362320185, 0.0138128669932485, 0.0138471247628331, 0.0138814374804497, 0.0139157492667437, 0.0139501160010695, 0.0139844818040729, 0.0140189034864306, 0.0140533512458205, 0.0140878260135651, 0.0141223557293415, 0.0141569394618273, 0.0141915241256356, 0.0142261078581214, 0.0142607726156712, 0.0142954653128982, 0.0143301580101252, 0.0143648777157068, 0.0143996514379978, 0.014434453099966, 0.0144692799076438, 0.0145041355863214, 0.0145390732213855, 0.0145740089938045, 0.0146089727059007, 0.0146439373493195, 0.0146789820864797, 0.0147140277549624, 0.014749126508832, 0.0147842261940241, 0.0148193808272481, 0.0148545345291495, 0.0148897962644696, 0.0149250589311123, 0.0149603225290775, 0.0149956112727523, 0.0150309549644589, 0.0150663536041975, 0.0151017513126135, 0.0151371769607067, 0.015172628685832, 0.0152081092819571, 0.0152436420321465, 0.0152792045846581, 0.0153148462995887, 0.0153504619374871, 0.0153861036524177, 0.0154218003153801, 0.0154574979096651, 0.0154932755976915, 0.0155290272086859, 0.0155648598447442, 0.0156006924808025, 0.0156365521252155, 0.0156724657863379, 0.0157084614038467, 0.0157444290816784, 0.0157804246991873, 0.0158164482563734, 0.0158524960279465, 0.0158886276185513, 0.015924759209156, 0.0159609168767929, 0.0159971043467522, 0.0160333160310984, 0.0160695817321539, 0.0161059033125639, 0.0161422248929739, 0.016178572550416, 0.0162149481475353, 0.0162513516843319, 0.0162878073751926, 0.0163242928683758, 0.0163607764989138, 0.0163973420858383, 0.0164339058101177, 0.0164704993367195, 0.0165071729570627, 0.0165438484400511, 0.0165805500000715, 0.0166172496974468, 0.0166540052741766, 0.0166908148676157, 0.016727652400732, 0.0167645160108805, 0.0168013796210289, 0.0168382991105318, 0.0168752428144217, 0.0169122982770205, 0.0169492978602648, 0.0169863235205412, 0.0170234069228172, 0.0170605145394802, 0.0170976500958204, 0.01713483966887, 0.0171720292419195, 0.0172092728316784, 0.0172465462237597, 0.0172838438302279, 0.0173211954534054, 0.0173585750162601, 0.0173959545791149, 0.0174333900213242, 0.0174708236008883, 0.0175083130598068, 0.0175458267331123, 0.0175833981484175, 0.0176209956407547, 0.0176585912704468, 0.0176962427794933, 0.0177339501678944, 0.0177716817706823, 0.0178094133734703, 0.0178471747785807, 0.0178849622607231, 0.0179228018969297, 0.0179606694728136, 0.0179985947906971, 0.0180365163832903, 0.0180744659155607, 0.0181124713271856, 0.0181505549699068, 0.0181885864585638, 0.0182266719639301, 0.0182647854089737, 0.0183029528707266, 0.0183411464095116, 0.0183793418109417, 0.018417589366436, 0.0184558648616076, 0.0184941943734884, 0.0185325257480145, 0.0185709651559591, 0.0186093486845493, 0.0186477862298489, 0.0186862517148256, 0.0187247451394796, 0.0187632646411657, 0.0188018381595612, 0.018840441480279, 0.0188790690153837, 0.0189177244901657, 0.0189564079046249, 0.0189951714128256, 0.0190339367836714, 0.0190727282315493, 0.0191115457564592, 0.0191503632813692, 0.0191892646253109, 0.0192281641066074, 0.0192670915275812, 0.0193060729652643, 0.0193451084196568, 0.0193841457366943, 0.0194232612848282, 0.0194623526185751, 0.0195014700293541, 0.0195406135171652, 0.0195798389613628, 0.0196190644055605, 0.0196583177894354, 0.0196975972503424, 0.0197369325906038, 0.0197762940078974, 0.0198156554251909, 0.0198551248759031, 0.0198945943266153, 0.0199340656399727, 0.0199735891073942, 0.0200131144374609, 0.0200526937842369, 0.020092299208045, 0.0201319307088852, 0.0201715920120478, 0.0202113054692745, 0.0202510207891464, 0.0202908702194691, 0.0203306674957275, 0.0203704629093409, 0.0204103402793407, 0.0204502157866955, 0.0204901490360498, 0.0205301064997911, 0.0205700937658548, 0.0206101071089506, 0.0206501446664333, 0.0206902399659157, 0.0207304153591394, 0.0207705367356539, 0.0208107139915228, 0.0208509434014559, 0.020891172811389, 0.0209314320236444, 0.020971741527319, 0.0210120547562838, 0.0210524201393127, 0.021092813462019, 0.0211332608014345, 0.0211737621575594, 0.0212142635136843, 0.0212547928094864, 0.0212953481823206, 0.021335931494832, 0.0213765408843756, 0.0214172061532736, 0.0214578695595264, 0.0214985888451338, 0.0215393081307411, 0.021580109372735, 0.0216209627687931, 0.0216618180274963, 0.0217026732861996, 0.021743580698967, 0.0217845439910889, 0.0218254793435335, 0.0218664705753326, 0.0219075139611959, 0.0219485592097044, 0.0219896584749222, 0.0220307838171721, 0.0220720190554857, 0.0221131704747677, 0.0221544317901134, 0.0221934635192156, 0.0222311001271009, 0.0222686976194382, 0.0223064441233873, 0.0223441496491432, 0.0223819650709629, 0.0224197786301374, 0.0224576462060213, 0.0224956348538399, 0.0225335992872715, 0.0225715804845095, 0.0226097051054239, 0.0226477757096291, 0.0226859990507364, 0.0227241516113281, 0.0227624420076609, 0.0228007156401873, 0.0228390600532293, 0.0228774566203356, 0.0229158960282803, 0.0229544304311275, 0.0229929219931364, 0.0230315364897251, 0.0230701398104429, 0.0231088232249022, 0.0231475327163935, 0.0231862682849169, 0.0232251416891813, 0.0232639592140913, 0.023302873596549, 0.0233418401330709, 0.0233808774501085, 0.0234199240803719, 0.0234589483588934, 0.0234981197863817, 0.023537265136838, 0.0235765464603901, 0.0236157961189747, 0.023655129596591, 0.0236944369971752, 0.0237338803708553, 0.0237733777612448, 0.0238128639757633, 0.0238524693995714, 0.0238920338451862, 0.0239317193627357, 0.0239713676273823, 0.0240110959857702, 0.0240508913993835, 0.0240907277911901, 0.0241306442767382, 0.0241705235093832, 0.024210536852479, 0.0242505222558975, 0.0242906138300896, 0.0243307370692492, 0.0243708733469248, 0.0244111027568579, 0.0244512911885977, 0.0244916584342718, 0.0245319698005915, 0.0245723631232977, 0.024612782523036, 0.0246532838791609, 0.0246938411146402, 0.0247343666851521, 0.0247750338166952, 0.024815684184432, 0.0248564165085554, 0.02489716373384, 0.0249379500746727, 0.0249788016080856, 0.0250196699053049, 0.0250606890767813, 0.0251016635447741, 0.0251427497714758, 0.0251837931573391, 0.0252249762415886, 0.0252661015838385, 0.025307334959507, 0.02534862421453, 0.025389913469553, 0.0254312977194786, 0.0254727080464363, 0.0255142003297806, 0.0255556926131248, 0.0255972128361464, 0.0256388410925865, 0.0256804283708334, 0.0257221795618534, 0.0257638748735189, 0.0258057042956352, 0.0258474983274937, 0.0258893556892872, 0.0259312838315964, 0.0259732212871313, 0.0260153263807297, 0.0260573476552963, 0.0260994806885719, 0.0261416099965572, 0.0261838342994452, 0.0262260604649782, 0.0262683406472206, 0.0263107009232044, 0.0263530351221561, 0.0263955052942038, 0.0264379866421223, 0.0264804996550083, 0.0265230908989906, 0.0265656821429729, 0.0266083814203739, 0.02665108256042, 0.0266938507556915, 0.0267366208136082, 0.0267795100808144, 0.0268223714083433, 0.0268653053790331, 0.0269083026796579, 0.0269513428211212, 0.0269944500178099, 0.0270375851541758, 0.027080774307251, 0.0271239634603262, 0.0271672774106264, 0.0272105857729912, 0.0272538829594851, 0.0272973161190748, 0.0273407474160194, 0.027384290471673, 0.0274278484284878, 0.0274714287370443, 0.0275150798261166, 0.0275587178766727, 0.0276024881750345, 0.0276462472975254, 0.0276901163160801, 0.0277339294552803, 0.0277778804302216, 0.0278218537569046, 0.0278658047318459, 0.0279099438339472, 0.0279539749026299, 0.0279981810599566, 0.028042359277606, 0.0280866082757711, 0.0281308982521296, 0.0281752273440361, 0.028219623491168, 0.0282640364021063, 0.0283085126429796, 0.0283530168235302, 0.0283975899219513, 0.028442220762372, 0.0284868478775024, 0.0285315550863743, 0.0285762920975685, 0.0286211390048265, 0.0286659970879555, 0.0287108812481165, 0.0287557933479548, 0.028800830245018, 0.0288458243012428, 0.0288909282535315, 0.0289360545575619, 0.0289811734110117, 0.0290264263749123, 0.0290716774761677, 0.0291170384734869, 0.0291623584926128, 0.0292077027261257, 0.0292532276362181, 0.0292986705899239, 0.0293442495167255, 0.0293898414820433, 0.0294354856014252, 0.0294811986386776, 0.0295268576592207, 0.0295726545155048, 0.0296184495091438, 0.0296643264591694, 0.029710229486227, 0.0297562275081873, 0.0298022255301476, 0.0298482794314623, 0.0298944115638733, 0.0299405083060265, 0.0299867074936628, 0.0300329383462667, 0.0300792213529348, 0.0301255881786346, 0.030171912163496, 0.0302183721214533, 0.0302648190408945, 0.0303113609552383, 0.0303579159080982, 0.0304045639932156, 0.030451200902462, 0.0304978918284178, 0.0305446516722441, 0.0305914096534252, 0.0306382644921541, 0.0306851472705603, 0.0307320915162563, 0.0307790692895651, 0.0308261401951313, 0.0308731570839882, 0.0309203490614891, 0.0309674888849258, 0.0310146939009428, 0.0310619696974754, 0.031109256669879, 0.031156612560153, 0.0312040094286203, 0.0312514193356037, 0.0312989391386509, 0.0313464440405369, 0.0313940457999706, 0.0314416736364365, 0.0314893946051598, 0.031537089496851, 0.0315848924219608, 0.0316327139735222, 0.0316805280745029, 0.0317284390330315, 0.0317763909697533, 0.0318244025111198, 0.0318724513053894, 0.0319205820560455, 0.0319687090814114, 0.0320168919861317, 0.0320651158690453, 0.0321134254336357, 0.0321617722511292, 0.0322100631892681, 0.0322585441172123, 0.0323070026934147, 0.0323555245995522, 0.0324040576815605, 0.0324526652693748, 0.0325013361871243, 0.032550036907196, 0.0325987637042999, 0.0326475575566292, 0.0326964072883129, 0.0327452979981899, 0.032794214785099, 0.0328431837260723, 0.0328922085464001, 0.0329412780702114, 0.0329903811216354, 0.0330395549535751, 0.0330887734889984, 0.0331380181014538, 0.0331873409450054, 0.0332366637885571, 0.0332860536873341, 0.0333354882895947, 0.0333849862217903, 0.0334345549345016, 0.0334840975701809, 0.0335337184369564, 0.0335834510624409, 0.0336331278085709, 0.0336829014122486, 0.0337327271699905, 0.0337825678288937, 0.0338324904441833, 0.0338824093341827, 0.0339324399828911, 0.0339824818074703, 0.0340325422585011, 0.0340826772153378, 0.034132856875658, 0.0341831296682358, 0.0342334061861038, 0.034283734858036, 0.0343340896070004, 0.0343844965100288, 0.0344349481165409, 0.0344854518771172, 0.0345360115170479, 0.0345866270363331, 0.0346372537314892, 0.0346879623830318, 0.0347387231886387, 0.0347895137965679, 0.0348403453826904, 0.0348911881446838, 0.0349421575665474, 0.0349930785596371, 0.0350441262125969, 0.0350951477885246, 0.0351462922990322, 0.0351974330842495, 0.0352486595511436, 0.0352999530732632, 0.0353512428700924, 0.0354025885462761, 0.0354539640247822, 0.0355053916573524, 0.0355568863451481, 0.0356083810329437, 0.0356599725782871, 0.0357115790247917, 0.0357632339000702, 0.0358149744570255, 0.0358667708933353, 0.0359185785055161, 0.0359704382717609, 0.0360223166644573, 0.0360742472112179, 0.0361262299120426, 0.036178283393383, 0.0362303480505943, 0.0362824946641922, 0.0363346710801125, 0.0363868698477745, 0.0364391952753067, 0.0364915058016777, 0.0365438982844353, 0.0365962870419025, 0.0366487614810467, 0.0367012321949005, 0.0367537885904312, 0.0368064232170582, 0.0368590317666531, 0.0369116961956024, 0.0369644537568092, 0.037017248570919, 0.0370701178908348, 0.037122942507267, 0.0371758528053761, 0.0372288674116135, 0.0372818596661091, 0.0373349264264107, 0.0373880229890347, 0.0374411605298519, 0.0374943800270557, 0.0375475995242596, 0.0376009121537209, 0.0376542694866657, 0.0377076417207718, 0.0377610884606838, 0.0378145948052406, 0.0378680974245071, 0.037921667098999, 0.0379752963781357, 0.0380289368331432, 0.0380826443433762, 0.0381363928318024, 0.0381902121007442, 0.0382441058754921, 0.0382979512214661, 0.0383518934249878, 0.0384058840572834, 0.0384599603712559, 0.038514032959938, 0.0385681204497814, 0.0386223159730434, 0.0386765152215958, 0.0387308038771152, 0.0387851111590862, 0.0388394854962826, 0.0388938710093498, 0.0389483384788036, 0.0390028469264507, 0.039057407528162, 0.0391119755804539, 0.0391665920615196, 0.0392212904989719, 0.0392760038375854, 0.0393308103084564, 0.039385661482811, 0.0394405201077461, 0.0394954346120358, 0.0395503789186478, 0.0396054051816463, 0.039660457521677, 0.0397155620157719, 0.0397707223892212, 0.0398259125649929, 0.0398811511695385, 0.0399364233016968, 0.0399917960166931, 0.0400471612811089, 0.0401025973260403, 0.0401580519974232, 0.0402135662734509, 0.0402691625058651, 0.0403247699141502, 0.0403804443776608, 0.0404361225664616, 0.0404919050633907, 0.0405476614832878, 0.0406035408377647, 0.0406594090163708, 0.0407153703272343, 0.040771346539259, 0.0408273749053478, 0.0408834591507912, 0.0409395694732666, 0.0409957319498062, 0.0410519801080227, 0.041108250617981, 0.0411645285785198, 0.0412209220230579, 0.0412773154675961, 0.0413337536156178, 0.0413902439177036, 0.0414467751979828, 0.0415033847093582, 0.041560024023056, 0.0416166670620441, 0.0416734144091606, 0.0417301766574383, 0.0417869798839092, 0.04184390604496, 0.0419008322060108, 0.0419577546417713, 0.0420147590339184, 0.042071845382452, 0.0421289354562759, 0.0421860404312611, 0.0422432608902454, 0.0423004701733589, 0.0423578023910522, 0.0424151048064232, 0.0424725227057934, 0.042529933154583, 0.0425873771309853, 0.0426449105143547, 0.0427024438977242, 0.0427601039409637, 0.042817734181881, 0.0428754463791847, 0.0429331846535206, 0.0429909378290176, 0.0430488251149654, 0.0431066900491714, 0.0431646704673767, 0.0432226546108723, 0.043280653655529, 0.0433387197554111, 0.0433968640863895, 0.0434550121426582, 0.0435132123529911, 0.0435714535415173, 0.0436297617852688, 0.0436881519854069, 0.0437465831637383, 0.0438049994409084, 0.0438634753227234, 0.0439219996333122, 0.0439806059002876, 0.0440392456948757, 0.0440979041159153, 0.0441566482186317, 0.0442153923213482, 0.04427420347929, 0.0443330854177475, 0.044392004609108, 0.0444509238004684, 0.04450998082757, 0.04456901922822, 0.0446280911564827, 0.0446872375905514, 0.0447464026510715, 0.0448056496679783, 0.0448649376630783, 0.0449242368340492, 0.044983621686697, 0.0450430773198605, 0.0451025478541851, 0.0451620072126389, 0.0452215820550919, 0.0452811941504478, 0.0453408360481262, 0.0454005561769009, 0.0454602725803852, 0.0455200783908367, 0.0455799177289009, 0.045639805495739, 0.0456997528672218, 0.0457597188651562, 0.0458197556436062, 0.0458798110485077, 0.0459399372339249, 0.0460000820457935, 0.0460602901875973, 0.0461205430328846, 0.046180859208107, 0.0462411940097809, 0.046301580965519, 0.0463620536029339, 0.0464225299656391, 0.04648307710886, 0.04654361307621, 0.0466042347252369, 0.046664897352457, 0.0467256456613541, 0.0467863120138645, 0.0468471422791481, 0.0469080880284309, 0.046969085931778, 0.0470301061868668, 0.0470912382006645, 0.047152504324913, 0.0472137965261936, 0.0472752340137959, 0.0473366156220436, 0.0473981499671936, 0.0474597662687302, 0.0475214160978794, 0.047583170235157, 0.0476449877023697, 0.0477069057524204, 0.047768909484148, 0.0478309653699398, 0.0478930734097958, 0.0479552634060383, 0.0480175651609898, 0.0480799488723278, 0.0481424033641815, 0.0482048951089382, 0.0482674986124039, 0.0483301468193531, 0.0483929067850113, 0.0484556704759598, 0.0485185943543911, 0.0485815703868866, 0.0486445799469948, 0.0487077757716179, 0.0487709157168865, 0.0488341897726059, 0.0488975197076797, 0.0489609912037849, 0.049024511128664, 0.049088004976511, 0.0491517148911953, 0.0492154508829117, 0.0492792464792728, 0.0493430942296982, 0.0494070537388325, 0.0494710840284824, 0.049535233527422, 0.0495994314551353, 0.0496636629104614, 0.0497279986739159, 0.0497924387454987, 0.0498569421470165, 0.0499215200543404, 0.0499861277639866, 0.0500508137047291, 0.0501156114041805, 0.0501805171370506, 0.0502454191446304, 0.0503104105591774, 0.0503755360841751, 0.0504407100379467, 0.0505059957504272, 0.0505712814629078, 0.0506367012858391, 0.0507021807134151, 0.0507677346467972, 0.050833348184824, 0.0508990697562695, 0.050964817404747, 0.0510306991636753, 0.0510966628789902, 0.0511626228690147, 0.051228754222393, 0.051294881850481, 0.0513611175119877, 0.0514274574816227, 0.0514937750995159, 0.0515602827072144, 0.0516268238425255, 0.0516934357583523, 0.0517601035535336, 0.0518268570303917, 0.0518937446177006, 0.0519606620073318, 0.0520277097821236, 0.0520947016775608, 0.0521618649363518, 0.0522291362285614, 0.0522963963449001, 0.0523638278245926, 0.0524312071502209, 0.0524987950921059, 0.0525663606822491, 0.0526340641081333, 0.0527017936110497, 0.052769660949707, 0.0528375208377838, 0.0529054999351501, 0.0529735796153545, 0.053041685372591, 0.0531099028885365, 0.0531782023608685, 0.0532466135919094, 0.0533149652183056, 0.0533835105597973, 0.0534521043300629, 0.0535208098590374, 0.0535895749926567, 0.0536583587527275, 0.0537272579967976, 0.0537962093949318, 0.0538652911782265, 0.0539344325661659, 0.0540035478770733, 0.054072879254818, 0.0541422069072723, 0.0542117059230804, 0.0542811118066311, 0.0543507412075996, 0.0544203445315361, 0.0544901080429554, 0.0545599572360516, 0.0546298027038574, 0.054699782282114, 0.0547698140144348, 0.0548399388790131, 0.0549101121723652, 0.0549803115427494, 0.0550506711006165, 0.055121086537838, 0.0551916062831879, 0.0552621893584728, 0.0553327947854996, 0.0554035417735577, 0.0554743595421314, 0.0555452108383179, 0.0556161440908909, 0.0556871592998505, 0.0557582788169384, 0.0558294840157032, 0.0559007152915001, 0.0559720024466515, 0.0560434237122536, 0.0561149269342422, 0.0561865046620369, 0.0562580861151218, 0.0563298091292381, 0.0564015507698059, 0.0564734414219856, 0.056545402854681, 0.0566173940896988, 0.0566894672811031, 0.0567616187036037, 0.0568339079618454, 0.0569061934947968, 0.0569786205887794, 0.0570510178804398, 0.0571235530078411, 0.0571962520480156, 0.0572688914835453, 0.0573416464030743, 0.0574145317077637, 0.0574874393641949, 0.057560496032238, 0.0576334856450558, 0.0577066466212273, 0.0577798895537853, 0.0578532032668591, 0.0579265840351582, 0.0580000095069408, 0.0580735467374325, 0.0581471435725689, 0.0582208670675755, 0.0582945980131626, 0.0583684369921684, 0.0584423504769802, 0.0585163272917271, 0.0585904642939568, 0.0586644858121872, 0.0587387308478355, 0.0588130243122578, 0.0588874109089375, 0.0589618124067783, 0.0590363331139088, 0.0591109283268452, 0.0591856315732002, 0.0592603646218777, 0.0593351535499096, 0.0594101026654243, 0.0594850517809391, 0.059560164809227, 0.0596352778375149, 0.0597104728221893, 0.059785719960928, 0.0598611012101173, 0.0599365383386612, 0.0600120052695274, 0.0600876100361347, 0.0601632334291935, 0.0602389946579933, 0.0603148192167282, 0.0603906325995922, 0.0604666471481323, 0.0605426803231239, 0.0606188252568245, 0.0606949664652348, 0.0607712231576443, 0.0608475804328918, 0.0609239973127842, 0.0610004961490631, 0.0610770471394062, 0.0611536465585232, 0.0612304471433163, 0.0613072440028191, 0.0613841749727726, 0.0614610463380814, 0.0615380369126797, 0.0616151802241802, 0.0616923607885838, 0.0617695897817612, 0.0618469305336475, 0.0619243234395981, 0.0620018467307091, 0.0620794072747231, 0.0621570162475109, 0.0622347109019756, 0.0623125098645687, 0.0623904205858707, 0.0624683536589146, 0.0625462830066681, 0.0626244097948074, 0.0627025961875916, 0.0627808272838593, 0.0628591179847717, 0.0629375129938126, 0.0630159601569176, 0.0630945563316345, 0.0631731897592545, 0.063251830637455, 0.0633306428790092, 0.0634094476699829, 0.0634884089231491, 0.0635674297809601, 0.0636464580893517, 0.0637256652116776, 0.063804879784584, 0.0638841688632965, 0.0639635175466537, 0.0640429705381393, 0.0641225427389145, 0.0642021521925926, 0.0642818808555603, 0.0643615871667862, 0.0644414499402046, 0.0645213350653648, 0.064601331949234, 0.0646813586354256, 0.0647615194320679, 0.0648417621850967, 0.064922034740448, 0.06500244140625, 0.0650828257203102, 0.0651633366942406, 0.0652439519762993, 0.0653246641159058, 0.0654054507613182, 0.0654861778020859, 0.0655670687556267, 0.0656481012701988, 0.0657291635870934, 0.0658102482557297, 0.0658914670348167, 0.0659727454185486, 0.0660540983080864, 0.0661355629563332, 0.0662170574069023, 0.0662986561655998, 0.0663802847266197, 0.0664620697498322, 0.0665438324213028, 0.0666257366538048, 0.0667076855897903, 0.0667897239327431, 0.0668718740344048, 0.0669540390372276, 0.0670363232493401, 0.0671186223626137, 0.0672010630369186, 0.067283608019352, 0.0673661381006241, 0.0674487724900246, 0.0675315111875534, 0.0676143318414688, 0.0676971524953842, 0.067780114710331, 0.0678631514310837, 0.067946270108223, 0.0680295005440712, 0.0681126788258553, 0.0681960135698318, 0.0682794377207756, 0.0683629363775253, 0.0684465169906616, 0.0685300976037979, 0.0686138421297073, 0.0686975866556168, 0.0687814950942993, 0.0688654035329819, 0.0689494460821152, 0.0690334960818291, 0.0691176727414131, 0.0692019835114479, 0.0692862495779991, 0.0693706423044205, 0.0694551467895508, 0.0695397108793259, 0.0696243196725845, 0.0697089582681656, 0.0697937607765198, 0.0698786005377769, 0.0699635595083237, 0.070048525929451, 0.0701336339116096, 0.0702187865972519, 0.0703039988875389, 0.0703893452882767, 0.070474661886692, 0.0705601423978806, 0.0706457048654556, 0.0707312971353531, 0.0708170235157013, 0.0709027498960495, 0.070988617837429, 0.0710745304822922, 0.0711605548858643, 0.0712465569376945, 0.071332685649395, 0.0714189261198044, 0.0715052559971809, 0.0715916007757187, 0.0716780424118042, 0.0717645809054375, 0.0718511715531349, 0.0719378739595413, 0.0720245242118835, 0.0721113905310631, 0.072198286652565, 0.0722852870821953, 0.0723723992705345, 0.0724594593048096, 0.072546698153019, 0.0726339742541313, 0.072721354663372, 0.0728087723255157, 0.0728962644934654, 0.0729838609695435, 0.0730714872479439, 0.0731592774391174, 0.073247067630291, 0.0733349621295929, 0.0734229162335396, 0.0735109522938728, 0.0735990926623344, 0.0736872628331184, 0.0737755447626114, 0.0738639011979103, 0.0739523693919182, 0.0740408375859261, 0.0741293579339981, 0.0742180198431015, 0.0743067637085915, 0.0743956044316292, 0.0744844600558281, 0.0745733603835106, 0.0746624544262886, 0.0747515708208084, 0.0748407393693924, 0.0749299749732018, 0.0750192776322365, 0.0751086995005608, 0.0751982256770134, 0.0752878114581108, 0.0753773674368858, 0.0754671096801758, 0.0755569115281105, 0.0756468176841736, 0.0757366940379143, 0.0758267343044281, 0.0759168043732643, 0.0760070383548737, 0.076097272336483, 0.0761875584721565, 0.076277956366539, 0.0763684287667274, 0.0764590501785278, 0.0765496045351028, 0.0766403004527092, 0.0767311006784439, 0.0768219605088234, 0.0769128948450089, 0.0770038589835167, 0.0770949348807335, 0.0771861150860786, 0.0772773548960686, 0.0773686766624451, 0.0774600207805634, 0.07755146920681, 0.0776430368423462, 0.0777347087860107, 0.0778263509273529, 0.0779181346297264, 0.0780099406838417, 0.0781018808484077, 0.0781938806176186, 0.0782858729362488, 0.0783780887722969, 0.0784702822566032, 0.0785626322031021, 0.0786550119519234, 0.0787474066019058, 0.0788399279117584, 0.0789325460791588, 0.0790252238512039, 0.0791179835796356, 0.0792107880115509, 0.0793037116527557, 0.0793967172503471, 0.0794897675514221, 0.0795828476548195, 0.0796760693192482, 0.0797693729400635, 0.0798627510666847, 0.0799561589956284, 0.0800496786832809, 0.0801432803273201, 0.0802369266748428, 0.0803307145833969, 0.0804244503378868, 0.0805183798074722, 0.0806123241782188, 0.0807064399123192, 0.0808005258440971, 0.0808947011828423, 0.0809889510273933, 0.081083282828331, 0.0811778008937836, 0.0812722146511078, 0.0813668444752693, 0.0814615115523338, 0.0815561860799789, 0.0816510394215584, 0.0817458853125572, 0.0818408131599426, 0.0819358751177788, 0.0820310264825821, 0.0821262523531914, 0.0822214335203171, 0.0823167860507965, 0.0824122056365013, 0.0825077071785927, 0.0826032385230064, 0.082698866724968, 0.0827945843338966, 0.0828904062509537, 0.0829862579703331, 0.0830821618437767, 0.0831782072782516, 0.0832743048667908, 0.0833705365657806, 0.0834667980670929, 0.0835630595684052, 0.0836594253778458, 0.0837559252977371, 0.0838524848222733, 0.083949089050293, 0.0840457901358604, 0.0841426402330399, 0.0842394232749939, 0.0843364372849464, 0.0844333842396736, 0.0845304504036903, 0.0846275761723518, 0.0847248136997223, 0.0848221331834793, 0.0849195644259453, 0.085017092525959, 0.0851145684719086, 0.0852121934294701, 0.0853098332881927, 0.0854076147079468, 0.0855054780840874, 0.0856033861637115, 0.0857014432549477, 0.0857994630932808, 0.0858976244926453, 0.0859958380460739, 0.0860941037535667, 0.0861924737691879, 0.0862909629940987, 0.086389534175396, 0.0864880979061127, 0.0865867733955383, 0.0866909623146057, 0.0868012458086014, 0.0869116187095642, 0.0870220363140106, 0.0871325954794884, 0.0872430801391602, 0.0873537063598633, 0.087464340031147, 0.0875750407576561, 0.087685838341713, 0.0877966806292534, 0.0879075974225998, 0.0880185291171074, 0.0881296098232269, 0.0882406309247017, 0.0883517637848854, 0.0884629711508751, 0.088574230670929, 0.08868557959795, 0.088796928524971, 0.088908389210701, 0.0890198573470116, 0.0891314074397087, 0.0892430171370506, 0.0893546938896179, 0.0894664078950882, 0.0895782113075256, 0.0896901115775108, 0.0898019969463348, 0.0899139642715454, 0.0900259763002396, 0.0901380926370621, 0.090250238776207, 0.0903624296188354, 0.0904747769236565, 0.0905870124697685, 0.0906994044780731, 0.0908118933439255, 0.0909243747591972, 0.0910369455814362, 0.0911495611071587, 0.0912623256444931, 0.091375008225441, 0.0914878845214844, 0.0916006714105606, 0.0917136147618294, 0.0918265655636787, 0.0919396132230759, 0.0920528024435043, 0.092165894806385, 0.0922791957855225, 0.0923924222588539, 0.0925057753920555, 0.0926191508769989, 0.0927325859665871, 0.0928462073206902, 0.0929597094655037, 0.0930733978748322, 0.0931870713829994, 0.0933008193969727, 0.0934146344661713, 0.0935285165905952, 0.093642495572567, 0.0937564596533775, 0.0938705429434776, 0.0939846336841583, 0.0940988063812256, 0.0942130386829376, 0.0943273156881332, 0.0944416746497154, 0.0945561081171036, 0.0946706384420395, 0.0947851240634918, 0.0948997288942337, 0.0950143560767174, 0.095129057765007, 0.0952438339591026, 0.0953586772084236, 0.095473624765873, 0.0955885350704193, 0.0957035794854164, 0.0958185940980911, 0.0959337130188942, 0.0960489362478256, 0.0961641892790794, 0.0962795466184616, 0.0963948667049408, 0.0965103432536125, 0.0966257750988007, 0.0967413112521172, 0.0968569293618202, 0.0969725772738457, 0.097088411450386, 0.0972041040658951, 0.0973199903964996, 0.0974358469247818, 0.0975518226623535, 0.0976678282022476, 0.0977839380502701, 0.0979001373052597, 0.098016269505024, 0.0981325805187225, 0.0982488542795181, 0.0983652472496033, 0.098481684923172, 0.0985981673002243, 0.098714791238308, 0.0988313481211662, 0.0989480838179588, 0.099064789712429, 0.0991815477609634, 0.0992984622716904, 0.0994153618812561, 0.0995323657989502, 0.0996493995189667, 0.0997664853930473, 0.0998836383223534, 0.100000843405724, 0.10011813044548, 0.100235439836979, 0.100352853536606, 0.100470341742039, 0.100587829947472, 0.100705400109291, 0.100823052227497, 0.100940726697445, 0.101058468222618, 0.10117631405592, 0.101294167339802, 0.101412080228329, 0.101530119776726, 0.101648151874542, 0.101766265928745, 0.10188440233469, 0.102002643048763, 0.102120950818062, 0.102239266037941, 0.102357663214207, 0.10247615724802, 0.102594695985317, 0.102713242173195, 0.102831937372684, 0.102950632572174, 0.103069387376308, 0.103188216686249, 0.103307098150253, 0.103426046669483, 0.103545002639294, 0.103664137423038, 0.103783249855042, 0.103902421891689, 0.104021675884724, 0.1041409522295, 0.104260332882404, 0.104379773139954, 0.104499228298664, 0.1046187505126, 0.104738354682922, 0.104858003556728, 0.104977756738663, 0.105097532272339, 0.105217382311821, 0.105337269604206, 0.105457194149494, 0.105577208101749, 0.105697304010391, 0.105817452073097, 0.105937629938126, 0.106057889759541, 0.106178231537342, 0.106298558413982, 0.106419019401073, 0.106539495289326, 0.106660045683384, 0.106780655682087, 0.106901332736015, 0.107022106647491, 0.107142865657806, 0.107263721525669, 0.107384577393532, 0.107505597174168, 0.107626639306545, 0.107747718691826, 0.107868857681751, 0.107990078628063, 0.108111329376698, 0.108232654631138, 0.108354069292545, 0.108475513756275, 0.108597002923489, 0.108718566596508, 0.108840197324753, 0.108961880207062, 0.109083592891693, 0.109205447137356, 0.109327331185341, 0.109449215233326, 0.109571188688278, 0.109693244099617, 0.109815344214439, 0.109937481582165, 0.110059730708599, 0.110182039439678, 0.110304355621338, 0.110426753759384, 0.110549233853817, 0.110671736299992, 0.110794298350811, 0.110916964709759, 0.111039683222771, 0.111162416636944, 0.111285232007504, 0.111408092081547, 0.111531056463718, 0.11165402084589, 0.111777111887932, 0.111900240182877, 0.112023375928402, 0.112146608531475, 0.112269930541515, 0.112393260002136, 0.112516656517982, 0.112640164792538, 0.112763695418835, 0.112887263298035, 0.113010920584202, 0.113134622573853, 0.11325841397047, 0.113382250070572, 0.113506153225899, 0.113630063831806, 0.113754078745842, 0.113878153264523, 0.114002294838428, 0.114126496016979, 0.114250726997852, 0.114375039935112, 0.114499405026436, 0.114623807370663, 0.114748299121857, 0.114872857928276, 0.114997461438179, 0.115122139453888, 0.11524686217308, 0.115371614694595, 0.115496471524239, 0.115621373057365, 0.115746334195137, 0.115871347486973, 0.115996487438679, 0.116121612489223, 0.116246789693832, 0.116372048854828, 0.116497375071049, 0.116622738540173, 0.116748183965683, 0.116873703896999, 0.116999246180058, 0.117124855518341, 0.117250546813011, 0.117376260459423, 0.117502100765705, 0.117627941071987, 0.117753863334656, 0.117879845201969, 0.118005871772766, 0.118131965398788, 0.118258118629456, 0.118384324014187, 0.118510633707047, 0.118636935949326, 0.118763357400894, 0.118889771401882, 0.119016267359257, 0.119142822921276, 0.119269490242004, 0.119396179914474, 0.119522951543331, 0.119649767875671, 0.119776606559753, 0.119903542101383, 0.120030514895916, 0.120157591998577, 0.120284721255302, 0.120411857962608, 0.120539091527462, 0.120666362345219, 0.120793707668781, 0.120921097695827, 0.121048606932163, 0.121176116168499, 0.121303714811802, 0.12143138051033, 0.121559046208858, 0.121686808764935, 0.121814593672752, 0.121942520141602, 0.122070476412773, 0.122198484838009, 0.122326545417309, 0.122454643249512, 0.122582830488682, 0.122711069881916, 0.122839376330376, 0.122967712581158, 0.123096160590649, 0.123224638402462, 0.123353160917759, 0.123481750488281, 0.123610436916351, 0.123739130795002, 0.1238679215312, 0.123996749520302, 0.12412566691637, 0.124254614114761, 0.124383598566055, 0.124512709677219, 0.124641820788383, 0.124771043658257, 0.124900296330452, 0.125029593706131, 0.125158950686455, 0.125288367271423, 0.12541788816452, 0.12554743885994, 0.125677034258842, 0.125806733965874, 0.125936433672905, 0.126066237688065, 0.126196071505547, 0.126326009631157, 0.126455962657928, 0.126585975289345, 0.126716092228889, 0.126846253871918, 0.126976415514946, 0.127106726169586, 0.127237036824226, 0.127367421984673, 0.127497836947441, 0.127628356218338, 0.12775893509388, 0.127889513969421, 0.128020241856575, 0.128151014447212, 0.128281801939011, 0.128412619233131, 0.128543555736542, 0.128674566745758, 0.128805577754974, 0.128936693072319, 0.129067823290825, 0.12919907271862, 0.129330337047577, 0.129461660981178, 0.129593104124069, 0.129724532365799, 0.129856050014496, 0.129987627267838, 0.130119279026985, 0.130250930786133, 0.130382731556892, 0.130514532327652, 0.130646422505379, 0.130778342485428, 0.130910351872444, 0.131042420864105, 0.131174519658089, 0.131306663155556, 0.131438881158829, 0.13157120347023, 0.131703555583954, 0.131835997104645, 0.131968438625336, 0.132100954651833, 0.132233530282974, 0.132366165518761, 0.132498934864998, 0.132631674408913, 0.132764533162117, 0.132897436618805, 0.133030369877815, 0.13316336274147, 0.133296430110931, 0.133429571986198, 0.133562743663788, 0.133695989847183, 0.133829310536385, 0.133962661027908, 0.134096071124077, 0.134229570627213, 0.134363129734993, 0.134496733546257, 0.134630396962166, 0.134764090180397, 0.134897887706757, 0.1350317299366, 0.135165616869926, 0.135299608111382, 0.135433614253998, 0.135567680001259, 0.135701820254326, 0.135836020112038, 0.135970294475555, 0.136104598641396, 0.136238977313042, 0.136373400688171, 0.136507928371429, 0.136642456054688, 0.136777132749557, 0.136911779642105, 0.13704651594162, 0.137181311845779, 0.137316107749939, 0.13745105266571, 0.137586057186127, 0.137721091508865, 0.137856185436249, 0.137991338968277, 0.138126567006111, 0.138261839747429, 0.138397127389908, 0.138532534241676, 0.138667985796928, 0.138803511857986, 0.138939082622528, 0.139074683189392, 0.139210388064384, 0.139346122741699, 0.139481917023659, 0.139617815613747, 0.139753744006157, 0.139889732003212, 0.140025779604912, 0.140161857008934, 0.140298053622246, 0.140434265136719, 0.140570551156998, 0.140706911683083, 0.14084330201149, 0.140979766845703, 0.1411162763834, 0.141252890229225, 0.14138950407505, 0.141526222229004, 0.141662999987602, 0.141799807548523, 0.141936674714088, 0.14207361638546, 0.142210617661476, 0.142347693443298, 0.142484813928604, 0.142621994018555, 0.14275923371315, 0.142896547913551, 0.143033862113953, 0.143171280622482, 0.143308788537979, 0.143446311354637, 0.143583878874779, 0.143721550703049, 0.143859267234802, 0.143997058272362, 0.144134879112244, 0.144272804260254, 0.144410729408264, 0.144548758864403, 0.144686818122864, 0.14482493698597, 0.144963145256042, 0.145101398229599, 0.145239725708961, 0.145378082990646, 0.145516529679298, 0.145654991269112, 0.145793542265892, 0.145932137966156, 0.146070823073387, 0.146209537982941, 0.146348342299461, 0.146487191319466, 0.146626099944115, 0.14676508307457, 0.146904096007347, 0.147043168544769, 0.147182300686836, 0.147321537137032, 0.147460773587227, 0.147600099444389, 0.14773952960968, 0.147878929972649, 0.148018434643745, 0.148157984018326, 0.148297622799873, 0.148437350988388, 0.148577034473419, 0.148716852068901, 0.148856729269028, 0.148996636271477, 0.149136602878571, 0.149278029799461, 0.149420604109764, 0.149563118815422, 0.14970563352108, 0.149848148226738, 0.149990633130074, 0.150133118033409, 0.150275588035583, 0.150418072938919, 0.15056049823761, 0.150702923536301, 0.150845363736153, 0.15098774433136, 0.151130139827728, 0.151272535324097, 0.151414915919304, 0.151557251811028, 0.15169957280159, 0.151841923594475, 0.151984244585037, 0.152126535773277, 0.152268812060356, 0.152411133050919, 0.152553379535675, 0.152695626020432, 0.152837872505188, 0.152980074286461, 0.153122305870056, 0.153264507651329, 0.153406709432602, 0.153548881411552, 0.153691053390503, 0.15383318066597, 0.153975307941437, 0.154117450118065, 0.154259547591209, 0.154401659965515, 0.154543742537498, 0.154685840010643, 0.154827877879143, 0.154969915747643, 0.155111968517303, 0.15525396168232, 0.155395984649658, 0.155537992715836, 0.155679985880852, 0.155821949243546, 0.155963882803917, 0.15610583126545, 0.15624774992466, 0.156389683485031, 0.15653158724308, 0.156673476099968, 0.156815364956856, 0.156957224011421, 0.157099068164825, 0.157240927219391, 0.157382741570473, 0.157524555921555, 0.157666385173798, 0.157808169722557, 0.157949939370155, 0.158091723918915, 0.158233448863029, 0.158375188708305, 0.15851691365242, 0.158658638596535, 0.158800348639488, 0.158942043781281, 0.15908370912075, 0.159225359559059, 0.159367009997368, 0.159508630633354, 0.159650295972824, 0.159791871905327, 0.159933492541313, 0.160075068473816, 0.160216614603996, 0.160358190536499, 0.160499721765518, 0.160641297698021, 0.160782799124718, 0.160924315452576, 0.161065801978111, 0.161207273602486, 0.16134874522686, 0.161490201950073, 0.161631673574448, 0.161773085594177, 0.161914512515068, 0.162055909633636, 0.162197276949883, 0.162338674068451, 0.162480041384697, 0.162621408700943, 0.162762746214867, 0.162904098629951, 0.16304537653923, 0.16318666934967, 0.163327977061272, 0.163469240069389, 0.163610517978668, 0.163751780986786, 0.163893029093742, 0.164034232497215, 0.164175465703011, 0.164316639304161, 0.164457827806473, 0.164599016308784, 0.164740175008774, 0.164881333708763, 0.165022447705269, 0.165163591504097, 0.16530467569828, 0.165445774793625, 0.165586888790131, 0.16572792828083, 0.165869012475014, 0.166010037064552, 0.166151091456413, 0.166292086243629, 0.166433081030846, 0.166574105620384, 0.166715070605278, 0.166856050491333, 0.166997000575066, 0.167137965559959, 0.167278870940208, 0.167419776320457, 0.167560696601868, 0.167701587080956, 0.167842477560043, 0.167983338236809, 0.168124198913574, 0.168265044689178, 0.168405845761299, 0.168546676635742, 0.168687462806702, 0.168828263878822, 0.168969035148621, 0.16910982131958, 0.169250562787056, 0.169391304254532, 0.169532001018524, 0.169672697782516, 0.169813439249992, 0.169954106211662, 0.170094802975655, 0.170235455036163, 0.170376107096672, 0.17051674425602, 0.170657351613045, 0.170797973871231, 0.170938551425934, 0.17107917368412, 0.171219721436501, 0.171360298991203, 0.171500816941261, 0.171641334891319, 0.1717818826437, 0.171922385692596, 0.172062888741493, 0.172203361988068, 0.172343820333481, 0.172484278678894, 0.172624707221985, 0.172765150666237, 0.172905564308167, 0.173045977950096, 0.173186361789703, 0.173326760530472, 0.173467114567757, 0.17360745370388, 0.173747822642326, 0.173888117074966, 0.17402845621109, 0.17416875064373, 0.174309030175209, 0.174449294805527, 0.174589589238167, 0.174729824066162, 0.174870058894157, 0.175010278820992, 0.175150498747826, 0.175290688872337, 0.17543089389801, 0.175571084022522, 0.17571122944355, 0.175851359963417, 0.175991490483284, 0.17613160610199, 0.176271736621857, 0.17641182243824, 0.176551893353462, 0.176691979169846, 0.176832020282745, 0.176972091197968, 0.177112117409706, 0.177252128720284, 0.177392140030861, 0.177532121539116, 0.177672117948532, 0.177812054753304, 0.177952036261559, 0.178091987967491, 0.178231924772263, 0.178371801972389, 0.178511738777161, 0.178651615977287, 0.178791463375092, 0.178931370377541, 0.179071202874184, 0.179211050271988, 0.179350852966309, 0.179490685462952, 0.179630473256111, 0.179770305752754, 0.179910063743591, 0.180049806833267, 0.180189564824104, 0.180329293012619, 0.180469021201134, 0.180608734488487, 0.18074843287468, 0.180888131260872, 0.181027770042419, 0.181167438626289, 0.181307092308998, 0.181446731090546, 0.181586354970932, 0.181725978851318, 0.181865558028221, 0.182005152106285, 0.182144701480865, 0.182284265756607, 0.182423815131187, 0.182563334703445, 0.182702898979187, 0.182842388749123, 0.182981848716736, 0.183121353387833, 0.183260798454285, 0.183400258421898, 0.183539688587189, 0.183679148554802, 0.18381854891777, 0.183957934379578, 0.184097334742546, 0.184236705303192, 0.184376075863838, 0.184515431523323, 0.184654787182808, 0.18479411303997, 0.18493340909481, 0.185072720050812, 0.185212001204491, 0.185351297259331, 0.185490533709526, 0.185629799962044, 0.185769036412239, 0.185908257961273, 0.186047464609146, 0.186186641454697, 0.186325833201408, 0.186464995145798, 0.186604171991348, 0.186743319034576, 0.186882436275482, 0.187021568417549, 0.187160670757294, 0.187299758195877, 0.18743884563446, 0.187577962875366, 0.187717005610466, 0.187856033444405, 0.187995076179504, 0.188134074211121, 0.188273072242737, 0.188412055373192, 0.188551053404808, 0.188690006732941, 0.188828989863396, 0.188967913389206, 0.189106822013855, 0.189245745539665, 0.189384654164314, 0.189523532986641, 0.189662426710129, 0.189801305532455, 0.189940124750137, 0.190079003572464, 0.190217822790146, 0.190356612205505, 0.190495416522026, 0.190634205937386, 0.190773010253906, 0.190911754965782, 0.191050514578819, 0.191189244389534, 0.191327944397926, 0.191466644406319, 0.191605344414711, 0.191744044423103, 0.191882699728012, 0.192021355032921, 0.192160025238991, 0.192298635840416, 0.192437261343002, 0.192575871944427, 0.192714467644691, 0.192853048443794, 0.192991644144058, 0.193130180239677, 0.193268716335297, 0.193407237529755, 0.193545758724213, 0.193684265017509, 0.193822756409645, 0.193961247801781, 0.194099694490433, 0.194238156080246, 0.194376602768898, 0.194515004754066, 0.194653451442719, 0.194791868329048, 0.194930225610733, 0.19506861269474, 0.195206984877586, 0.19534532725811, 0.195483654737473, 0.195622012019157, 0.195760294795036, 0.195898607373238, 0.196036890149117, 0.196175187826157, 0.196313425898552, 0.196451663970947, 0.196589902043343, 0.196728125214577, 0.196866348385811, 0.197004541754723, 0.197142735123634, 0.197280868887901, 0.197419047355652, 0.197557210922241, 0.197695314884186, 0.197833448648453, 0.197971552610397, 0.198109656572342, 0.198247715830803, 0.198385760188103, 0.198523834347725, 0.198661893606186, 0.198799923062325, 0.198937922716141, 0.199075952172279, 0.199213907122612, 0.199351891875267, 0.199489876627922, 0.199627816677094, 0.199765771627426, 0.199903696775436, 0.200041621923447, 0.200179502367973, 0.200317412614822, 0.200455263257027, 0.200593128800392, 0.200730979442596, 0.200868830084801, 0.201006650924683, 0.201144456863403, 0.201282247900963, 0.201420024037361, 0.201557815074921, 0.201695591211319, 0.201833307743073, 0.201971054077148, 0.202108770608902, 0.202246487140656, 0.202384188771248, 0.202521875500679, 0.202659547328949, 0.202797189354897, 0.202934861183167, 0.203072473406792, 0.203210100531578, 0.203347712755203, 0.203485280275345, 0.20362289249897, 0.203760460019112, 0.20389798283577, 0.20403553545475, 0.204173073172569, 0.204310581088066, 0.204448059201241, 0.204585567116737, 0.204723060131073, 0.204860538244247, 0.204997986555099, 0.205135405063629, 0.205272823572159, 0.205410271883011, 0.205547645688057, 0.205685019493103, 0.205822423100471, 0.205959782004356, 0.206097096204758, 0.206234455108643, 0.206371814012527, 0.206509098410606, 0.206646382808685, 0.206783682107925, 0.206920951604843, 0.2070582062006, 0.207195445895195, 0.207332700490952, 0.207469895482063, 0.207607120275497, 0.207744315266609, 0.20788149535656, 0.20801867544651, 0.208155795931816, 0.208292990922928, 0.208430096507072, 0.208567202091217, 0.208704337477684, 0.208841413259506, 0.208978489041328, 0.209115549921989, 0.20925261080265, 0.209389671683311, 0.209526672959328, 0.209663704037666, 0.209800705313683, 0.209937706589699, 0.210074663162231, 0.210211649537086, 0.210348576307297, 0.210485517978668, 0.21062245965004, 0.210759356617928, 0.210896253585815, 0.211033150553703, 0.21117003262043, 0.211306899785995, 0.2114437520504, 0.211580574512482, 0.211717382073402, 0.211854219436646, 0.211991012096405, 0.212127774953842, 0.21226455271244, 0.2124013453722, 0.212538048624992, 0.212674796581268, 0.212811514735222, 0.212948217988014, 0.213084921240807, 0.213221594691277, 0.213358297944069, 0.213494941592216, 0.21363154053688, 0.21376821398735, 0.213904812932014, 0.214041441679001, 0.214177995920181, 0.214314609766006, 0.214451164007187, 0.214587703347206, 0.214724242687225, 0.214860782027245, 0.214997306466103, 0.215133801102638, 0.215270295739174, 0.215406775474548, 0.215543240308762, 0.215679675340652, 0.215816125273705, 0.215952545404434, 0.216088935732841, 0.216225370764732, 0.216361746191978, 0.216498136520386, 0.216634467244148, 0.216770812869072, 0.216907173395157, 0.217043474316597, 0.217179805040359, 0.217316091060638, 0.21745240688324, 0.217588648200035, 0.217724904417992, 0.217861160635948, 0.217997387051582, 0.218133613467216, 0.218269795179367, 0.218406021595001, 0.218542188405991, 0.21867835521698, 0.218814507126808, 0.21894682943821, 0.21907451748848, 0.219202145934105, 0.219329714775085, 0.219457224011421, 0.219584628939629, 0.219712048768997, 0.219839349389076, 0.219966620206833, 0.220093816518784, 0.220220938324928, 0.220347985625267, 0.220475003123283, 0.220601961016655, 0.220728829503059, 0.22085565328598, 0.220982432365417, 0.221109122037888, 0.221235737204552, 0.221362322568893, 0.22148884832859, 0.221615269780159, 0.221741676330566, 0.221867993474007, 0.221994251012802, 0.222120478749275, 0.22224660217762, 0.222372695803642, 0.222498700022697, 0.222624689340591, 0.222750544548035, 0.222876399755478, 0.223002180457115, 0.223127901554108, 0.223253518342972, 0.223379105329514, 0.223504662513733, 0.223630100488663, 0.223755493760109, 0.223880842328072, 0.224006146192551, 0.22413133084774, 0.224256500601768, 0.224381595849991, 0.224506616592407, 0.22463159263134, 0.224756494164467, 0.22488135099411, 0.225006118416786, 0.225130841135979, 0.225255504250526, 0.225380077958107, 0.225504636764526, 0.225629091262817, 0.225753530859947, 0.225877851247787, 0.226002186536789, 0.22612638771534, 0.226250544190407, 0.22637465596199, 0.226498678326607, 0.226622685790062, 0.22674660384655, 0.226870462298393, 0.226994261145592, 0.227117985486984, 0.227241665124893, 0.227365255355835, 0.227488800883293, 0.227612316608429, 0.227735742926598, 0.227859079837799, 0.227982386946678, 0.228105634450912, 0.228228807449341, 0.228351950645447, 0.228474989533424, 0.228597983717918, 0.228720918297768, 0.22884376347065, 0.228966593742371, 0.229089304804802, 0.229212015867233, 0.229334607720375, 0.229457184672356, 0.22957968711853, 0.229702115058899, 0.229824483394623, 0.229946807026863, 0.230069056153297, 0.230191245675087, 0.230313360691071, 0.230435431003571, 0.230557441711426, 0.230679407715797, 0.23080125451088, 0.230923056602478, 0.231044843792915, 0.231166556477547, 0.231288179755211, 0.231409758329391, 0.231531247496605, 0.231652677059174, 0.23177407681942, 0.23189540207386, 0.232016682624817, 0.232137888669968, 0.232259020209312, 0.232380077242851, 0.232501089572906, 0.232622057199478, 0.232742950320244, 0.232863768935204, 0.232984527945518, 0.233105272054672, 0.233225926756859, 0.233346462249756, 0.233467027544975, 0.233587458729744, 0.23370786011219, 0.233828201889992, 0.233948469161987, 0.234068691730499, 0.234188839793205, 0.234308928251266, 0.234428957104683, 0.234548926353455, 0.23466882109642, 0.234788671135902, 0.234908431768417, 0.23502816259861, 0.235147804021835, 0.235267415642738, 0.235386967658997, 0.235506415367126, 0.235625833272934, 0.235745176672935, 0.235864445567131, 0.235983669757843, 0.23610283434391, 0.236221954226494, 0.23634098470211, 0.236459955573082, 0.236578896641731, 0.236697748303413, 0.236816510558128, 0.23693522810936, 0.237053915858269, 0.237172514200211, 0.237291067838669, 0.237409546971321, 0.23752798140049, 0.237646341323853, 0.237764626741409, 0.237882867455482, 0.23800103366375, 0.238119170069695, 0.23823718726635, 0.238355219364166, 0.238473117351532, 0.238591000437737, 0.238708809018135, 0.238826528191566, 0.238944217562675, 0.239061817526817, 0.239179387688637, 0.239296868443489, 0.23941433429718, 0.239531695842743, 0.239648997783661, 0.239766255021095, 0.239883422851562, 0.240000560879707, 0.240117624402046, 0.24023462831974, 0.24035157263279, 0.240468412637711, 0.24058523774147, 0.240701988339424, 0.240818709135056, 0.240935310721397, 0.241051912307739, 0.241168424487114, 0.24128483235836, 0.241401210427284, 0.241517543792725, 0.24163381755352, 0.241750001907349, 0.241866171360016, 0.241982206702232, 0.242098197340965, 0.242214202880859, 0.242330074310303, 0.242445901036263, 0.242561668157578, 0.242677390575409, 0.242793008685112, 0.242908582091331, 0.243024125695229, 0.243139579892159, 0.243254944682121, 0.243370294570923, 0.243485555052757, 0.243600755929947, 0.243715912103653, 0.243830978870392, 0.243946015834808, 0.244060978293419, 0.244175866246223, 0.244290739297867, 0.244405493140221, 0.244520232081413, 0.244634866714478, 0.244749471545219, 0.244864001870155, 0.244978442788124, 0.245092868804932, 0.245207205414772, 0.245321482419968, 0.24543571472168, 0.245549872517586, 0.245663985610008, 0.245778009295464, 0.245891973376274, 0.246005892753601, 0.246119737625122, 0.246233522891998, 0.24634724855423, 0.246460914611816, 0.246574535965919, 0.246688067913055, 0.246801540255547, 0.246914982795715, 0.247028335928917, 0.247141599655151, 0.247254833579063, 0.247368022799492, 0.247481137514114, 0.247594177722931, 0.247707158327103, 0.24782007932663, 0.247932955622673, 0.248045742511749, 0.248158469796181, 0.24827116727829, 0.248383790254593, 0.24849633872509, 0.248608812689781, 0.248721241950989, 0.248833641409874, 0.248945936560631, 0.249058172106743, 0.249170333147049, 0.249282479286194, 0.24939452111721, 0.249506533145905, 0.249618455767632, 0.249730318784714, 0.249842151999474, 0.249953910708427, 0.250065565109253, 0.25017723441124, 0.250288814306259, 0.250400274991989, 0.250511735677719, 0.250623106956482, 0.2507344186306, 0.250845700502396, 0.250956892967224, 0.251067996025085, 0.251179069280624, 0.251290082931519, 0.25140106678009, 0.25151190161705, 0.25162273645401, 0.251733481884003, 0.251844197511673, 0.251954853534698, 0.252065420150757, 0.25217592716217, 0.252286404371262, 0.252396792173386, 0.252507090568542, 0.252617388963699, 0.252727597951889, 0.252837747335434, 0.252947807312012, 0.253057837486267, 0.253167778253555, 0.253277659416199, 0.253387540578842, 0.253497302532196, 0.253607034683228, 0.253716647624969, 0.253826260566711, 0.253935784101486, 0.254045248031616, 0.254154652357101, 0.25426396727562, 0.25437331199646, 0.254482507705688, 0.254591643810272, 0.254700720310211, 0.254809767007828, 0.2549187541008, 0.255027621984482, 0.255136460065842, 0.255245268344879, 0.255353987216949, 0.255462646484375, 0.255571246147156, 0.255679786205292, 0.255788266658783, 0.255896717309952, 0.256005048751831, 0.256113350391388, 0.256221562623978, 0.256329745054245, 0.256437838077545, 0.256545901298523, 0.256653875112534, 0.256761759519577, 0.25686964392662, 0.256977438926697, 0.257085174322128, 0.257192850112915, 0.257300436496735, 0.257408022880554, 0.257515490055084, 0.257622927427292, 0.257730305194855, 0.25783759355545, 0.257944852113724, 0.25805202126503, 0.258159130811691, 0.258266180753708, 0.258373200893402, 0.258480131626129, 0.258587002754211, 0.258693814277649, 0.258800536394119, 0.258907228708267, 0.25901386141777, 0.259120404720306, 0.25922691822052, 0.259333342313766, 0.259439736604691, 0.259546041488647, 0.259652316570282, 0.259758472442627, 0.259864628314972, 0.259970664978027, 0.260076701641083, 0.260182619094849, 0.260288536548615, 0.260394334793091, 0.260500103235245, 0.260605782270432, 0.260711431503296, 0.260816961526871, 0.260922491550446, 0.261027961969376, 0.261133342981339, 0.261238664388657, 0.26134392619133, 0.261449128389359, 0.261554300785065, 0.261659353971481, 0.261764377355576, 0.261869341135025, 0.261974215507507, 0.262079060077667, 0.262183845043182, 0.26228854060173, 0.262393206357956, 0.262497812509537, 0.262602299451828, 0.262706756591797, 0.262811183929443, 0.2629154920578, 0.263019800186157, 0.263123989105225, 0.26322814822197, 0.26333224773407, 0.263436257839203, 0.263540238142014, 0.263644099235535, 0.263747990131378, 0.26385173201561, 0.263955503702164, 0.264059156179428, 0.264162749052048, 0.264266282320023, 0.264369755983353, 0.264473140239716, 0.264576494693756, 0.264679789543152, 0.264783024787903, 0.264886200428009, 0.26498931646347, 0.265092343091965, 0.265195280313492, 0.265298217535019, 0.265401035547256, 0.265503853559494, 0.265606611967087, 0.26570925116539, 0.265811920166016, 0.265914440155029, 0.266016930341721, 0.266119301319122, 0.266221702098846, 0.266323983669281, 0.266426235437393, 0.266528397798538, 0.266630530357361, 0.266732573509216, 0.266834557056427, 0.266936510801315, 0.267038345336914, 0.267140179872513, 0.267241895198822, 0.267343610525131, 0.267445236444473, 0.267546772956848, 0.267648249864578, 0.267749696969986, 0.267851054668427, 0.267952412366867, 0.268053650856018, 0.268154829740524, 0.268255949020386, 0.268357038497925, 0.268458008766174, 0.268558949232101, 0.268659830093384, 0.268760651350021, 0.268861413002014, 0.26896208524704, 0.269062727689743, 0.269163310527802, 0.269263803958893, 0.269364267587662, 0.269464671611786, 0.269564986228943, 0.269665211439133, 0.269765406847, 0.269865572452545, 0.269965648651123, 0.270065665245056, 0.270165622234344, 0.270265489816666, 0.270365327596664, 0.270465105772018, 0.270564824342728, 0.27066445350647, 0.270764023065567, 0.270863562822342, 0.27096301317215, 0.271062403917313, 0.271161764860153, 0.271261006593704, 0.271360218524933, 0.271459370851517, 0.271558463573456, 0.27165749669075, 0.2717564702034, 0.271855354309082, 0.27195417881012, 0.272052973508835, 0.272151678800583, 0.272250324487686, 0.272348970174789, 0.272447466850281, 0.272545963525772, 0.272644370794296, 0.272742688655853, 0.272840976715088, 0.272939205169678, 0.273037374019623, 0.273135453462601, 0.273233503103256, 0.273331463336945, 0.273429393768311, 0.273527234792709, 0.273625016212463, 0.273722767829895, 0.273820430040359, 0.273918032646179, 0.274015575647354, 0.274113059043884, 0.274210512638092, 0.274307817220688, 0.274405151605606, 0.274502366781235, 0.274599552154541, 0.27469664812088, 0.274793714284897, 0.274890691041946, 0.274987608194351, 0.275084167718887, 0.27518031001091, 0.275276362895966, 0.275372356176376, 0.27546826004982, 0.275564074516296, 0.275659829378128, 0.275755524635315, 0.275851130485535, 0.27594667673111, 0.276042103767395, 0.27613753080368, 0.276232838630676, 0.276328086853027, 0.276423245668411, 0.276518315076828, 0.2766133248806, 0.276708275079727, 0.276803135871887, 0.27689790725708, 0.276992619037628, 0.277087271213531, 0.277181833982468, 0.277276337146759, 0.277370750904083, 0.277465105056763, 0.277559340000153, 0.27765354514122, 0.277747690677643, 0.277841717004776, 0.277935683727264, 0.278029590845108, 0.278123378753662, 0.278217136859894, 0.278310835361481, 0.2784044444561, 0.278497934341431, 0.278591394424438, 0.278684794902802, 0.278778076171875, 0.278871327638626, 0.278964459896088, 0.279057532548904, 0.279150545597076, 0.279243439435959, 0.279336333274841, 0.279429078102112, 0.279521763324738, 0.279614448547363, 0.279706984758377, 0.279799461364746, 0.27989187836647, 0.279984205961227, 0.280076444149017, 0.280168622732162, 0.280260741710663, 0.280352771282196, 0.280444711446762, 0.280536621809006, 0.280628442764282, 0.280720174312592, 0.280811816453934, 0.280903428792953, 0.280994921922684, 0.281086355447769, 0.28117772936821, 0.281269043684006, 0.281360238790512, 0.281451374292374, 0.281542420387268, 0.28163343667984, 0.281724333763123, 0.281815201044083, 0.281905949115753, 0.281996667385101, 0.28208726644516, 0.282177805900574, 0.282268285751343, 0.282358676195145, 0.282448977231979, 0.282539248466492, 0.282629400491714, 0.282719492912292, 0.282809555530548, 0.282899498939514, 0.282989352941513, 0.283079147338867, 0.283168882131577, 0.283258497714996, 0.283348083496094, 0.283437609672546, 0.283527016639709, 0.28361639380455, 0.283705651760101, 0.283794850111008, 0.283883959054947, 0.283973038196564, 0.284062027931213, 0.284150928258896, 0.284239768981934, 0.284328520298004, 0.28441721200943, 0.284505784511566, 0.284594357013702, 0.284682810306549, 0.284771203994751, 0.284859508275986, 0.284947723150253, 0.285035878419876, 0.285123974084854, 0.285211980342865, 0.285299926996231, 0.28538778424263, 0.285475581884384, 0.285563290119171, 0.285650908946991, 0.285738497972488, 0.285825967788696, 0.285913407802582, 0.286000698804855, 0.286087989807129, 0.286175191402435, 0.286262273788452, 0.286349356174469, 0.286436289548874, 0.286523222923279, 0.286610037088394, 0.286696761846542, 0.286783427000046, 0.286870032548904, 0.286956578493118, 0.287043005228043, 0.287129372358322, 0.287215650081635, 0.287301898002625, 0.287388056516647, 0.287474125623703, 0.287560135126114, 0.287646055221558, 0.287731885910034, 0.287817686796188, 0.287903368473053, 0.287989020347595, 0.288074553012848, 0.288160055875778, 0.288245439529419, 0.288330793380737, 0.288416028022766, 0.288501232862473, 0.288586318492889, 0.288671344518661, 0.288756310939789, 0.288841158151627, 0.288925975561142, 0.28901070356369, 0.289095371961594, 0.289179980754852, 0.289264500141144, 0.289348930120468, 0.289433270692825, 0.28951758146286, 0.289601773023605, 0.289685934782028, 0.289769977331161, 0.289853990077972, 0.289937883615494, 0.29002171754837, 0.290105491876602, 0.290189206600189, 0.290272802114487, 0.290356338024139, 0.290439814329147, 0.290523201227188, 0.290606528520584, 0.290689766407013, 0.290772914886475, 0.290856003761292, 0.290939062833786, 0.291022002696991, 0.291104882955551, 0.291187673807144, 0.291270405054092, 0.291353017091751, 0.29143562912941, 0.291518092155457, 0.291600555181503, 0.29168289899826, 0.291765183210373, 0.291847348213196, 0.291929483413696, 0.29201152920723, 0.292093515396118, 0.29217541217804, 0.292257249355316, 0.292338997125626, 0.29242068529129, 0.292502284049988, 0.292583823204041, 0.292665243148804, 0.292746663093567, 0.292827963829041, 0.292909204959869, 0.292990386486053, 0.293071448802948, 0.293152451515198, 0.29323336482048, 0.293314248323441, 0.293395012617111, 0.293475717306137, 0.293556392192841, 0.293636947870255, 0.293717443943024, 0.293797850608826, 0.293878167867661, 0.293958455324173, 0.294038623571396, 0.294118762016296, 0.294198781251907, 0.294278770685196, 0.294358670711517, 0.294438451528549, 0.294518202543259, 0.294597893953323, 0.294677466154099, 0.294756978750229, 0.294836431741714, 0.294915825128555, 0.294995099306107, 0.295074343681335, 0.295153468847275, 0.295232564210892, 0.295311540365219, 0.295390486717224, 0.295469343662262, 0.29554808139801, 0.295626789331436, 0.295705407857895, 0.295783966779709, 0.295862436294556, 0.295940846204758, 0.296019196510315, 0.296097427606583, 0.296175599098206, 0.296253710985184, 0.296331763267517, 0.296409696340561, 0.29648756980896, 0.296565383672714, 0.296643108129501, 0.296720743179321, 0.296798348426819, 0.296875864267349, 0.296953320503235, 0.297030657529831, 0.297107934951782, 0.297185152769089, 0.29726231098175, 0.297339349985123, 0.29741632938385, 0.297493249177933, 0.297570079565048, 0.297646850347519, 0.297723561525345, 0.297800153493881, 0.297876685857773, 0.29795315861702, 0.298029541969299, 0.298105865716934, 0.298182100057602, 0.298258274793625, 0.298334360122681, 0.298410385847092, 0.298486322164536, 0.298562198877335, 0.298638015985489, 0.298713743686676, 0.298789381980896, 0.298864930868149, 0.298940449953079, 0.29901584982872, 0.299091219902039, 0.299166470766068, 0.299241691827774, 0.299316793680191, 0.299391835927963, 0.299466818571091, 0.299541741609573, 0.299616575241089, 0.299691319465637, 0.299766004085541, 0.299840599298477, 0.299915134906769, 0.299989581108093, 0.300063937902451, 0.300138264894485, 0.300212502479553, 0.300286650657654, 0.30036073923111, 0.300434738397598, 0.300508677959442, 0.300582528114319, 0.300656318664551, 0.300729990005493, 0.300803661346436, 0.300877213478088, 0.300950706005096, 0.301024109125137, 0.301097452640533, 0.301170706748962, 0.301243901252747, 0.301317006349564, 0.301390051841736, 0.301463007926941, 0.301535904407501, 0.301608741283417, 0.301681458950043, 0.301754117012024, 0.30182671546936, 0.301899254322052, 0.301971673965454, 0.302044034004211, 0.302116334438324, 0.302188575267792, 0.30226069688797, 0.302332758903503, 0.302404791116714, 0.302476704120636, 0.30254852771759, 0.302620321512222, 0.302692055702209, 0.302763640880585, 0.302835196256638, 0.302906662225723, 0.302978068590164, 0.303049385547638, 0.303120642900467, 0.303191840648651, 0.303262919187546, 0.303333938121796, 0.303404897451401, 0.303475797176361, 0.303546607494354, 0.30361732840538, 0.303687989711761, 0.303758561611176, 0.303829073905945, 0.303899496793747, 0.303969830274582, 0.304040104150772, 0.304110318422318, 0.304180473089218, 0.304250538349152, 0.304320514202118, 0.304390460252762, 0.304460257291794, 0.304530024528503, 0.304599702358246, 0.304669320583344, 0.304738879203796, 0.304808348417282, 0.304877698421478, 0.304947018623352, 0.305016279220581, 0.305085450410843, 0.305154502391815, 0.305223554372787, 0.30529248714447, 0.305361360311508, 0.305430144071579, 0.305498898029327, 0.305567502975464, 0.305636078119278, 0.305704563856125, 0.305772989988327, 0.305841356515884, 0.305909633636475, 0.305977821350098, 0.306045949459076, 0.306113958358765, 0.306181967258453, 0.306249856948853, 0.306317687034607, 0.306385427713394, 0.306453108787537, 0.306520700454712, 0.306588232517242, 0.306655704975128, 0.306723058223724, 0.306790381669998, 0.306857615709305, 0.306924760341644, 0.306991845369339, 0.307058870792389, 0.307125806808472, 0.307192623615265, 0.307259410619736, 0.307326108217239, 0.307392746210098, 0.30745929479599, 0.307525783777237, 0.307592213153839, 0.307658553123474, 0.307724803686142, 0.307790964841843, 0.307857096195221, 0.307923138141632, 0.307989090681076, 0.308054983615875, 0.308120787143707, 0.308186531066895, 0.308252185583115, 0.30831778049469, 0.308383285999298, 0.308448731899261, 0.30851411819458, 0.308579415082932, 0.308644622564316, 0.308709770441055, 0.308774828910828, 0.308839827775955, 0.308904737234116, 0.308969587087631, 0.309034377336502, 0.309099078178406, 0.309163689613342, 0.309228211641312, 0.309292703866959, 0.309357106685638, 0.309421420097351, 0.309485703706741, 0.309549868106842, 0.309613943099976, 0.309677988290787, 0.309741914272308, 0.309805810451508, 0.30986961722374, 0.309933364391327, 0.309996962547302, 0.3100605905056, 0.310124069452286, 0.310187518596649, 0.310250848531723, 0.310314118862152, 0.310377329587936, 0.310440480709076, 0.310503542423248, 0.310566514730453, 0.310629427433014, 0.310692250728607, 0.310755044221878, 0.310817688703537, 0.310880303382874, 0.310942888259888, 0.31100532412529, 0.311067700386047, 0.31113001704216, 0.311192274093628, 0.311254411935806, 0.311316519975662, 0.311378508806229, 0.311440467834473, 0.31150233745575, 0.311564117670059, 0.311625838279724, 0.311687469482422, 0.311749041080475, 0.311810553073883, 0.311871975660324, 0.311933308839798, 0.311994582414627, 0.312055766582489, 0.312116891145706, 0.312177926301956, 0.312238901853561, 0.312299787998199, 0.312360614538193, 0.312421381473541, 0.3124820291996, 0.312542676925659, 0.312603175640106, 0.312663614749908, 0.312723994255066, 0.312784314155579, 0.312844544649124, 0.312904685735703, 0.312964767217636, 0.313024759292603, 0.313084691762924, 0.313144564628601, 0.313204318284988, 0.313264042139053, 0.313323676586151, 0.313383221626282, 0.313442677259445, 0.313502103090286, 0.31356143951416, 0.313620686531067, 0.313679873943329, 0.313739001750946, 0.313798040151596, 0.313857108354568, 0.31391641497612, 0.313975602388382, 0.314034670591354, 0.314093708992004, 0.314152657985687, 0.314211487770081, 0.314270228147507, 0.314328908920288, 0.314387500286102, 0.314446002244949, 0.314504414796829, 0.314562737941742, 0.31462100148201, 0.314679145812988, 0.314737200737, 0.314795196056366, 0.314853072166443, 0.314910918474197, 0.314968645572662, 0.31502628326416, 0.315083801746368, 0.315141260623932, 0.315198630094528, 0.315255969762802, 0.315313160419464, 0.315370291471481, 0.315427333116531, 0.315484255552292, 0.315541118383408, 0.315597921609879, 0.31565460562706, 0.315711230039597, 0.315767705440521, 0.315824151039124, 0.315880507230759, 0.315936744213104, 0.315992921590805, 0.316049009561539, 0.316105008125305, 0.316160947084427, 0.316216766834259, 0.316272497177124, 0.316328167915344, 0.316383749246597, 0.316439241170883, 0.31649461388588, 0.316549926996231, 0.316605180501938, 0.316660314798355, 0.316715359687805, 0.316770315170288, 0.316825211048126, 0.316879987716675, 0.316934704780579, 0.316989332437515, 0.317043840885162, 0.317098289728165, 0.317152678966522, 0.317206919193268, 0.317261099815369, 0.317315250635147, 0.317369252443314, 0.317423194646835, 0.31747704744339, 0.317530781030655, 0.317584455013275, 0.317638069391251, 0.317691564559937, 0.317744970321655, 0.317798286676407, 0.317851543426514, 0.317904710769653, 0.317957788705826, 0.318010777235031, 0.318063646554947, 0.318116456270218, 0.318169206380844, 0.318221837282181, 0.31827437877655, 0.318326830863953, 0.318379253149033, 0.318431526422501, 0.318483740091324, 0.31853586435318, 0.318587899208069, 0.318639844655991, 0.318691730499268, 0.318743497133255, 0.318795174360275, 0.318846791982651, 0.318898350000381, 0.3189497590065, 0.319001078605652, 0.319052368402481, 0.319103538990021, 0.319154620170593, 0.319205611944199, 0.319256514310837, 0.31930735707283, 0.319358140230179, 0.319408774375916, 0.319459348917007, 0.319509834051132, 0.31956022977829, 0.319610565900803, 0.319660782814026, 0.319710910320282, 0.319760978221893, 0.319810926914215, 0.319860816001892, 0.319910615682602, 0.319960325956345, 0.32000994682312, 0.320059478282928, 0.32010892033577, 0.320158302783966, 0.320207595825195, 0.320256769657135, 0.32030588388443, 0.320354878902435, 0.320403814315796, 0.320452660322189, 0.320501446723938, 0.320550113916397, 0.320598721504211, 0.320647180080414, 0.320695608854294, 0.320743978023529, 0.320792198181152, 0.320840358734131, 0.320888429880142, 0.320936441421509, 0.320984303951263, 0.321032136678696, 0.321079879999161, 0.321127504110336, 0.321175038814545, 0.321222543716431, 0.321269899606705, 0.321317225694656, 0.321364432573318, 0.321411550045013, 0.321458578109741, 0.321505546569824, 0.32155242562294, 0.321599185466766, 0.321645885705948, 0.32169246673584, 0.321739017963409, 0.321785420179367, 0.321831792593002, 0.321878045797348, 0.321924239397049, 0.321970283985138, 0.322016328573227, 0.322062224149704, 0.322108060121536, 0.322153836488724, 0.322199463844299, 0.322245061397552, 0.322290539741516, 0.322335958480835, 0.322381258010864, 0.322426468133926, 0.322471618652344, 0.322516649961472, 0.322561651468277, 0.322606563568115, 0.322651326656342, 0.322696059942245, 0.32274067401886, 0.322785198688507, 0.32282966375351, 0.322874039411545, 0.322918325662613, 0.322962492704391, 0.323006629943848, 0.323050618171692, 0.323094546794891, 0.323138415813446, 0.323182165622711, 0.323225855827332, 0.323269456624985, 0.323312938213348, 0.32335638999939, 0.323399722576141, 0.323442965745926, 0.323486119508743, 0.323529213666916, 0.323572188615799, 0.323615074157715, 0.323657900094986, 0.32370063662529, 0.323743283748627, 0.323785841464996, 0.323828309774399, 0.323870688676834, 0.323912978172302, 0.323955208063126, 0.323997318744659, 0.324039340019226, 0.32408133149147, 0.324123203754425, 0.32416495680809, 0.324206680059433, 0.324248254299164, 0.324289798736572, 0.324331223964691, 0.324372559785843, 0.32441383600235, 0.32445502281189, 0.324496120214462, 0.324537128210068, 0.324578046798706, 0.324618875980377, 0.324659615755081, 0.324700266122818, 0.324740827083588, 0.324781328439713, 0.32482174038887, 0.324862062931061, 0.324902296066284, 0.32494243979454, 0.324982494115829, 0.325022488832474, 0.325062334537506, 0.325102150440216, 0.325141876935959, 0.325181484222412, 0.325221031904221, 0.325260490179062, 0.325299888849258, 0.325339168310165, 0.325378358364105, 0.325417459011078, 0.325456470251083, 0.325495392084122, 0.325534254312515, 0.325573056936264, 0.325611680746078, 0.325650304555893, 0.325688779354095, 0.325727224349976, 0.325765579938889, 0.325803816318512, 0.325841963291168, 0.325880020856857, 0.325918018817902, 0.325955957174301, 0.325993776321411, 0.326031506061554, 0.32606914639473, 0.326106697320938, 0.326144158840179, 0.326181560754776, 0.326218843460083, 0.326256066560745, 0.32629320025444, 0.326330214738846, 0.326367199420929, 0.326404064893723, 0.326440840959549, 0.326477527618408, 0.3265141248703, 0.326550662517548, 0.32658714056015, 0.326623469591141, 0.326659739017487, 0.326695919036865, 0.326732009649277, 0.326768010854721, 0.326803952455521, 0.326839774847031, 0.326875537633896, 0.326911181211472, 0.326946765184402, 0.326982259750366, 0.327017664909363, 0.327052980661392, 0.327088177204132, 0.32712334394455, 0.327158421278, 0.327193379402161, 0.327228277921677, 0.327263087034225, 0.327297776937485, 0.327332437038422, 0.327366977930069, 0.327401429414749, 0.327435791492462, 0.32747009396553, 0.327504277229309, 0.327538371086121, 0.327572405338287, 0.327606350183487, 0.327640205621719, 0.327673971652985, 0.327707648277283, 0.327741235494614, 0.3277747631073, 0.327808171510696, 0.327841520309448, 0.327874779701233, 0.327907919883728, 0.327941000461578, 0.327973991632462, 0.328006893396378, 0.328039705753326, 0.328072428703308, 0.328105092048645, 0.328137665987015, 0.328170150518417, 0.32820251584053, 0.328234821557999, 0.3282670378685, 0.328299164772034, 0.3283312022686, 0.328363180160522, 0.328395038843155, 0.32842680811882, 0.328458517789841, 0.328490138053894, 0.32852166891098, 0.328553080558777, 0.328584432601929, 0.328615754842758, 0.328646898269653, 0.328678011894226, 0.328709006309509, 0.328739911317825, 0.328770756721497, 0.328801542520523, 0.32883220911026, 0.328862756490707, 0.32889324426651, 0.328923672437668, 0.328954011201859, 0.32898423075676, 0.329014360904694, 0.329044431447983, 0.329074412584305, 0.329104274511337, 0.329134076833725, 0.329163819551468, 0.329193472862244, 0.329222977161407, 0.329252421855927, 0.329281806945801, 0.329311102628708, 0.329340308904648, 0.329369425773621, 0.329398423433304, 0.329427391290665, 0.329456239938736, 0.32948499917984, 0.329513669013977, 0.329542309045792, 0.329570800065994, 0.32959920167923, 0.32962754368782, 0.329655826091766, 0.329683989286423, 0.329712063074112, 0.329740047454834, 0.329767942428589, 0.329795747995377, 0.329823523759842, 0.329851150512695, 0.329878717660904, 0.329906195402145, 0.32993358373642, 0.329960882663727, 0.329988121986389, 0.33001521229744, 0.33004230260849, 0.330069243907928, 0.330096125602722, 0.330122917890549, 0.330149590969086, 0.330176204442978, 0.330202758312225, 0.330229163169861, 0.330255538225174, 0.330281794071198, 0.330307990312576, 0.330334097146988, 0.330360114574432, 0.330386012792587, 0.330411851406097, 0.330437630414963, 0.330463260412216, 0.330488860607147, 0.330514341592789, 0.330539762973785, 0.330565065145493, 0.330590337514877, 0.330615490674973, 0.330640524625778, 0.330665498971939, 0.330690383911133, 0.330715179443359, 0.330739945173264, 0.330764532089233, 0.330789089202881, 0.330813556909561, 0.330837935209274, 0.33086222410202, 0.330886423587799, 0.330910563468933, 0.330934554338455, 0.330958515405655, 0.330982357263565, 0.33100613951683, 0.331029832363129, 0.331053406000137, 0.331076949834824, 0.33110037446022, 0.33112370967865, 0.331146955490112, 0.331170111894608, 0.331193208694458, 0.331216186285019, 0.331239104270935, 0.331261932849884, 0.331284642219543, 0.33130732178688, 0.331329852342606, 0.331352353096008, 0.331374734640121, 0.331397026777267, 0.331419289112091, 0.331441402435303, 0.33146345615387, 0.331485420465469, 0.331507295370102, 0.331529051065445, 0.331550776958466, 0.331572383642197, 0.331593900918961, 0.33161535859108, 0.331636697053909, 0.331657975912094, 0.331679165363312, 0.331700295209885, 0.331721276044846, 0.331742227077484, 0.331763058900833, 0.331783801317215, 0.331804484128952, 0.3318250477314, 0.33184552192688, 0.331865966320038, 0.331886291503906, 0.331906527280807, 0.331926673650742, 0.331946730613708, 0.331966698169708, 0.331986606121063, 0.332006424665451, 0.332026153802872, 0.332045763731003, 0.332065314054489, 0.332084804773331, 0.33210414648056, 0.332123428583145, 0.332142621278763, 0.332161754369736, 0.332180798053741, 0.33219975233078, 0.332218587398529, 0.332237362861633, 0.33225604891777, 0.33227464556694, 0.332293152809143, 0.332311570644379, 0.332329928874969, 0.332348197698593, 0.332366347312927, 0.332384437322617, 0.332402437925339, 0.332420349121094, 0.332438141107559, 0.332455933094025, 0.332473576068878, 0.332491129636765, 0.332508623600006, 0.332525998353958, 0.332543313503265, 0.332560539245605, 0.332577645778656, 0.332594722509384, 0.332611680030823, 0.332628548145294, 0.332645356655121, 0.332662045955658, 0.33267867565155, 0.332695215940475, 0.332711666822433, 0.332727998495102, 0.332742542028427, 0.332755237817764, 0.332767844200134, 0.332780361175537, 0.332792818546295, 0.332805156707764, 0.332817405462265, 0.332829594612122, 0.332841694355011, 0.332853704690933, 0.332865625619888, 0.332877457141876, 0.332889229059219, 0.332900881767273, 0.332912474870682, 0.332923978567123, 0.332935392856598, 0.332946687936783, 0.332957923412323, 0.332969069480896, 0.332980155944824, 0.332991123199463, 0.333002030849457, 0.333012849092484, 0.333023548126221, 0.333034217357635, 0.333044737577438, 0.333055227994919, 0.33306559920311, 0.333075910806656, 0.333086133003235, 0.333096265792847, 0.333106279373169, 0.333116263151169, 0.333126127719879, 0.333135902881622, 0.333145618438721, 0.33315521478653, 0.333164751529694, 0.333174169063568, 0.33318355679512, 0.33319279551506, 0.333202034235001, 0.333211094141006, 0.33322012424469, 0.333229064941406, 0.333237916231155, 0.33324670791626, 0.333255350589752, 0.3332639336586, 0.33327242732048, 0.333280861377716, 0.333289176225662, 0.333297431468964, 0.333305597305298, 0.333313673734665, 0.333321660757065, 0.33332958817482, 0.333337396383286, 0.333345115184784, 0.333352774381638, 0.333360314369202, 0.333367824554443, 0.333375185728073, 0.333382487297058, 0.333389729261398, 0.333396852016449, 0.333403915166855, 0.333410859107971, 0.333417743444443, 0.333424538373947, 0.333431273698807, 0.333437889814377, 0.333444386720657, 0.333450853824615, 0.333457201719284, 0.33346351981163, 0.333469718694687, 0.333475828170776, 0.333481848239899, 0.333487778902054, 0.333493620157242, 0.333499401807785, 0.333505064249039, 0.333510667085648, 0.333516180515289, 0.333521634340286, 0.333526939153671, 0.333532184362411, 0.333537369966507, 0.333542466163635, 0.333547443151474, 0.333552360534668, 0.333557218313217, 0.333561956882477, 0.333566606044769, 0.333571165800095, 0.333575636148453, 0.333580046892166, 0.333584368228912, 0.333588600158691, 0.333592742681503, 0.333596795797348, 0.333600759506226, 0.333604633808136, 0.333608448505402, 0.3336121737957, 0.333615779876709, 0.333619356155396, 0.333622813224792, 0.3336261510849, 0.333629488945007, 0.333632677793503, 0.333635777235031, 0.333638817071915, 0.333641737699509, 0.33364462852478, 0.333647400140762, 0.333650082349777, 0.333652675151825, 0.333655208349228, 0.333657622337341, 0.33365997672081, 0.333662241697311, 0.333664447069168, 0.333666533231735, 0.333668529987335, 0.33367046713829, 0.333672285079956, 0.333674043416977, 0.333675712347031, 0.333677262067795, 0.333678752183914, 0.333680182695389, 0.333681493997574, 0.333682745695114, 0.333683878183365, 0.333684951066971, 0.33368593454361, 0.333686828613281, 0.333687633275986, 0.333688348531723, 0.333688974380493, 0.333689540624619, 0.333690047264099, 0.333690404891968, 0.333690673112869, 0.333690911531448, 0.333691030740738, 0.333691090345383, 0.333691030740738, 0.333690881729126, 0.333690673112869, 0.333690375089645, 0.333689987659454, 0.333689510822296, 0.333688944578171, 0.333688318729401, 0.333687573671341, 0.333686769008636, 0.333685845136642, 0.333684861660004, 0.33368381857872, 0.333682656288147, 0.333681374788284, 0.333680093288422, 0.333678662776947, 0.333677142858505, 0.333675563335419, 0.333673894405365, 0.333672165870667, 0.333670318126678, 0.333668380975723, 0.333666354417801, 0.333664268255234, 0.333662092685699, 0.333659827709198, 0.333657473325729, 0.333655029535294, 0.333652526140213, 0.333649903535843, 0.333647191524506, 0.333644419908524, 0.333641529083252, 0.333638608455658, 0.333635568618774, 0.333632439374924, 0.333629220724106, 0.333625942468643, 0.333622545003891, 0.333619087934494, 0.33361554145813, 0.333611905574799, 0.3336081802845, 0.333604365587234, 0.333600491285324, 0.333596497774124, 0.333592444658279, 0.333588272333145, 0.333584040403366, 0.333579748868942, 0.333575308322906, 0.333570837974548, 0.333566248416901, 0.333561599254608, 0.333556860685349, 0.333552002906799, 0.333547085523605, 0.333542108535767, 0.333537012338638, 0.333531826734543, 0.333526581525803, 0.333521217107773, 0.333515793085098, 0.333510249853134, 0.333504676818848, 0.333498954772949, 0.333493202924728, 0.333487331867218, 0.333481401205063, 0.333475381135941, 0.333469241857529, 0.333463042974472, 0.333456784486771, 0.33345040678978, 0.333443939685822, 0.333437383174896, 0.333430767059326, 0.333424061536789, 0.333417236804962, 0.333410352468491, 0.333403408527374, 0.333396315574646, 0.333389222621918, 0.333381980657578, 0.333374679088593, 0.333367258310318, 0.333359807729721, 0.333352208137512, 0.333344548940659, 0.333336800336838, 0.333328992128372, 0.333321094512939, 0.333313077688217, 0.333304971456528, 0.333296835422516, 0.333288580179214, 0.333280235528946, 0.33327180147171, 0.33326330780983, 0.33325469493866, 0.333246022462845, 0.333237260580063, 0.333228439092636, 0.333219468593597, 0.333210468292236, 0.333201348781586, 0.333192139863968, 0.333182871341705, 0.333173513412476, 0.333164066076279, 0.333154529333115, 0.333144903182983, 0.333135187625885, 0.333125412464142, 0.333115547895432, 0.333105564117432, 0.333095520734787, 0.333085358142853, 0.333075165748596, 0.333064883947372, 0.333054482936859, 0.333043992519379, 0.333033442497253, 0.333022803068161, 0.333012044429779, 0.333001226186752, 0.332990348339081, 0.33297935128212, 0.332968264818192, 0.332957118749619, 0.332945883274078, 0.332934528589249, 0.332923114299774, 0.332911640405655, 0.332900047302246, 0.33288836479187, 0.332876592874527, 0.332864761352539, 0.332852840423584, 0.332840830087662, 0.33282870054245, 0.332816541194916, 0.332804262638092, 0.332791894674301, 0.332779467105865, 0.332766950130463, 0.332754343748093, 0.332741618156433, 0.332728832960129, 0.33271598815918, 0.332702994346619, 0.332689970731735, 0.332676827907562, 0.332663655281067, 0.33265033364296, 0.332636952400208, 0.332623481750488, 0.332609921693802, 0.332596272230148, 0.332582592964172, 0.332568764686584, 0.332554876804352, 0.332540899515152, 0.332526832818985, 0.332512676715851, 0.33249843120575, 0.332484096288681, 0.332469701766968, 0.332455217838287, 0.33244064450264, 0.332425951957703, 0.332411199808121, 0.332396358251572, 0.332381457090378, 0.332366466522217, 0.332351356744766, 0.332336187362671, 0.332320928573608, 0.332305580377579, 0.332290142774582, 0.332274615764618, 0.332258999347687, 0.332243323326111, 0.332227528095245, 0.332211703062057, 0.332195729017258, 0.332179725170135, 0.332163572311401, 0.332147359848022, 0.332131087779999, 0.332114726305008, 0.33209827542305, 0.332081735134125, 0.33206507563591, 0.332048356533051, 0.332031577825546, 0.33201465010643, 0.331997722387314, 0.331980645656586, 0.331963509321213, 0.33194625377655, 0.331928968429565, 0.331911563873291, 0.331894069910049, 0.331876486539841, 0.331858843564987, 0.331841081380844, 0.331823259592056, 0.331805348396301, 0.331787377595901, 0.33176925778389, 0.331751108169556, 0.331732869148254, 0.331714510917664, 0.331696063280106, 0.331677556037903, 0.331658959388733, 0.331640273332596, 0.331621527671814, 0.331602662801743, 0.331583738327026, 0.331564694643021, 0.33154559135437, 0.331526398658752, 0.331507116556168, 0.331487745046616, 0.331468284130096, 0.331448793411255, 0.331429123878479, 0.331409424543381, 0.331389635801315, 0.331369757652283, 0.331349790096283, 0.331329703330994, 0.331309586763382, 0.331289380788803, 0.331269085407257, 0.331248670816422, 0.331228196620941, 0.331207633018494, 0.331186980009079, 0.33116626739502, 0.331145435571671, 0.331124544143677, 0.331103563308716, 0.331082463264465, 0.33106130361557, 0.331040054559708, 0.331018716096878, 0.330997288227081, 0.33097580075264, 0.330954223871231, 0.330932527780533, 0.33091077208519, 0.33088892698288, 0.330867022275925, 0.330844968557358, 0.330822885036469, 0.33080068230629, 0.330778419971466, 0.330756068229675, 0.330733627080917, 0.33071106672287, 0.330688446760178, 0.330665767192841, 0.330642968416214, 0.330620110034943, 0.330597162246704, 0.330574095249176, 0.330550968647003, 0.330527782440186, 0.330504477024078, 0.330481082201004, 0.330457627773285, 0.330434054136276, 0.330410420894623, 0.330386728048325, 0.330362886190414, 0.330338984727859, 0.330314993858337, 0.330290943384171, 0.330266773700714, 0.330242544412613, 0.330218195915222, 0.330193787813187, 0.330169320106506, 0.330144733190536, 0.330120056867599, 0.330095291137695, 0.330070465803146, 0.33004555106163, 0.330020517110825, 0.329995423555374, 0.329970240592957, 0.329944968223572, 0.329919636249542, 0.329894185066223, 0.329868674278259, 0.329843074083328, 0.32981738448143, 0.329791605472565, 0.329765737056732, 0.329739779233932, 0.329713761806488, 0.329687625169754, 0.329661428928375, 0.329635113477707, 0.329608768224716, 0.329582303762436, 0.329555749893188, 0.329529106616974, 0.329502373933792, 0.329475611448288, 0.329448699951172, 0.329421728849411, 0.329394668340683, 0.329367518424988, 0.329340308904648, 0.329312980175018, 0.329285562038422, 0.329258054494858, 0.329230517148972, 0.329202830791473, 0.329175114631653, 0.329147279262543, 0.329119354486465, 0.329091370105743, 0.329063296318054, 0.329035103321075, 0.329006850719452, 0.328978508710861, 0.328950077295303, 0.328921556472778, 0.328892946243286, 0.328864276409149, 0.328835487365723, 0.328806638717651, 0.328777700662613, 0.328748673200607, 0.328719586133957, 0.328690350055695, 0.328661054372787, 0.328631699085236, 0.328602254390717, 0.32857272028923, 0.328543096780777, 0.328513383865356, 0.328483581542969, 0.328453719615936, 0.328424006700516, 0.328394412994385, 0.328364729881287, 0.328334927558899, 0.328305125236511, 0.328275233507156, 0.328245252370834, 0.328215211629868, 0.328185081481934, 0.328154891729355, 0.328124642372131, 0.328094303607941, 0.328063905239105, 0.328033417463303, 0.328002870082855, 0.327972233295441, 0.327941536903381, 0.327910780906677, 0.327879905700684, 0.327849000692368, 0.327817976474762, 0.327786952257156, 0.327755838632584, 0.327724605798721, 0.327693343162537, 0.327661991119385, 0.327630579471588, 0.327599078416824, 0.327567517757416, 0.327535837888718, 0.32750415802002, 0.327472358942032, 0.327440500259399, 0.3274085521698, 0.327376574277878, 0.327344477176666, 0.32731232047081, 0.327280133962631, 0.327247828245163, 0.32721546292305, 0.327183037996292, 0.327150493860245, 0.327117949724197, 0.327085256576538, 0.327052533626556, 0.327019721269608, 0.326986879110336, 0.326953917741776, 0.32692089676857, 0.326887786388397, 0.326854646205902, 0.326821386814117, 0.326788067817688, 0.326754719018936, 0.326721251010895, 0.326687723398209, 0.326654136180878, 0.326620429754257, 0.326586723327637, 0.326552867889404, 0.326518982648849, 0.32648503780365, 0.326451003551483, 0.326416909694672, 0.326382726430893, 0.326348483562469, 0.326314151287079, 0.326279729604721, 0.326245278120041, 0.326210707426071, 0.326176077127457, 0.326141446828842, 0.326106667518616, 0.326071828603745, 0.326036900281906, 0.326001942157745, 0.325966894626617, 0.325931787490845, 0.325896561145782, 0.325861304998398, 0.325825989246368, 0.325790524482727, 0.325755059719086, 0.325719505548477, 0.325683891773224, 0.325648158788681, 0.325612396001816, 0.325576514005661, 0.325540632009506, 0.325504630804062, 0.32546854019165, 0.325432419776917, 0.325396180152893, 0.32535994052887, 0.325323551893234, 0.325287133455276, 0.325250655412674, 0.325214087963104, 0.325177431106567, 0.325140684843063, 0.325103938579559, 0.325067043304443, 0.325030118227005, 0.324993103742599, 0.324956029653549, 0.324918866157532, 0.32488164305687, 0.32484433054924, 0.324806988239288, 0.324769526720047, 0.324732005596161, 0.32469442486763, 0.32465672492981, 0.324619024991989, 0.324581205844879, 0.324543327093124, 0.324505388736725, 0.324467360973358, 0.324429273605347, 0.324391096830368, 0.324352860450745, 0.324314534664154, 0.324276119470596, 0.324237704277039, 0.324199140071869, 0.324160546064377, 0.324121862649918, 0.324083089828491, 0.324044317007065, 0.324005395174026, 0.323966443538666, 0.323927372694016, 0.323888272047043, 0.323849081993103, 0.323809832334518, 0.323770523071289, 0.32373109459877, 0.323691606521606, 0.323652058839798, 0.323612451553345, 0.323572754859924, 0.323532968759537, 0.323493152856827, 0.32345324754715, 0.323413252830505, 0.323373198509216, 0.323333084583282, 0.323292881250381, 0.323252588510513, 0.323212265968323, 0.323171824216843, 0.32313135266304, 0.323090761899948, 0.323050141334534, 0.323009431362152, 0.322968631982803, 0.322927802801132, 0.322886884212494, 0.322845876216888, 0.322804808616638, 0.322763651609421, 0.322722434997559, 0.322681158781052, 0.322639793157578, 0.322598338127136, 0.322556853294373, 0.322515279054642, 0.322473615407944, 0.322431892156601, 0.322390079498291, 0.322348207235336, 0.322306275367737, 0.32226425409317, 0.322222173213959, 0.322180032730103, 0.322137773036957, 0.322095483541489, 0.322053074836731, 0.322010666131973, 0.321968138217926, 0.321925550699234, 0.321882873773575, 0.321840137243271, 0.321797311306, 0.321754395961761, 0.321711480617523, 0.321668446063995, 0.321625351905823, 0.321582168340683, 0.321538895368576, 0.321495592594147, 0.32145220041275, 0.321408718824387, 0.321365207433701, 0.321321576833725, 0.321277886629105, 0.321234136819839, 0.32119032740593, 0.321146428585052, 0.321102440357208, 0.321058392524719, 0.321014285087585, 0.320970088243484, 0.320925831794739, 0.320881485939026, 0.320837080478668, 0.320792615413666, 0.320748060941696, 0.320703417062759, 0.3206587433815, 0.320613950490952, 0.32056912779808, 0.32052418589592, 0.320479184389114, 0.320434153079987, 0.320389002561569, 0.320343822240829, 0.3202985227108, 0.320253193378448, 0.320207744836807, 0.320162266492844, 0.32011666893959, 0.320071041584015, 0.320025354623795, 0.319979548454285, 0.31993368268013, 0.319887757301331, 0.319841742515564, 0.319795668125153, 0.319749504327774, 0.319703310728073, 0.319657027721405, 0.31961065530777, 0.319564193487167, 0.31951767206192, 0.319471091032028, 0.319424420595169, 0.319377720355988, 0.319330900907516, 0.319284021854401, 0.31923708319664, 0.319190055131912, 0.31914296746254, 0.319095820188522, 0.319048583507538, 0.319001227617264, 0.318953901529312, 0.318906426429749, 0.318858921527863, 0.318811297416687, 0.318763613700867, 0.318715870380402, 0.318668067455292, 0.318620175123215, 0.318572223186493, 0.318524152040482, 0.318476051092148, 0.318427890539169, 0.318379610776901, 0.318331331014633, 0.318282902240753, 0.318234413862228, 0.318185895681381, 0.318137258291245, 0.318088591098785, 0.318039804697037, 0.317991018295288, 0.317942082881927, 0.317893087863922, 0.317844063043594, 0.317794948816299, 0.317745715379715, 0.317696452140808, 0.317647129297256, 0.317597717046738, 0.317548215389252, 0.317498654127121, 0.317449033260345, 0.317399322986603, 0.317349523305893, 0.317299693822861, 0.317249774932861, 0.317199796438217, 0.317149698734283, 0.317099571228027, 0.317049384117126, 0.316999077796936, 0.316948741674423, 0.316898316144943, 0.316847801208496, 0.316797196865082, 0.316746562719345, 0.316695868968964, 0.316645085811615, 0.316594183444977, 0.316543251276016, 0.316492259502411, 0.316441178321838, 0.316390007734299, 0.316338807344437, 0.316287487745285, 0.316236138343811, 0.31618469953537, 0.316133171319962, 0.316081553697586, 0.316029936075211, 0.315978169441223, 0.315926373004913, 0.315874487161636, 0.315822511911392, 0.315770536661148, 0.315718412399292, 0.315666228532791, 0.315613985061646, 0.315561681985855, 0.315509289503098, 0.315456807613373, 0.315404295921326, 0.315351694822311, 0.31529900431633, 0.315246254205704, 0.315193444490433, 0.315140545368195, 0.315087556838989, 0.315034538507462, 0.314981400966644, 0.314928233623505, 0.314874976873398, 0.314821660518646, 0.314768224954605, 0.314714759588242, 0.314661234617233, 0.314607590436935, 0.314553886651993, 0.314500123262405, 0.314446300268173, 0.314392387866974, 0.314338386058807, 0.314284354448318, 0.314230233430862, 0.314176023006439, 0.314121752977371, 0.314067393541336, 0.314012974500656, 0.313958495855331, 0.313903898000717, 0.313849270343781, 0.313794583082199, 0.313739776611328, 0.313684910535812, 0.313630014657974, 0.313574999570847, 0.313519954681396, 0.313464820384979, 0.313409566879272, 0.313354313373566, 0.313298910856247, 0.313243478536606, 0.31318798661232, 0.313132405281067, 0.313076764345169, 0.313021034002304, 0.312965244054794, 0.312909364700317, 0.312853425741196, 0.312797397375107, 0.312741309404373, 0.312685132026672, 0.312628924846649, 0.312572598457336, 0.312516212463379, 0.312459766864777, 0.31240326166153, 0.312346667051315, 0.312290012836456, 0.312233239412308, 0.312176465988159, 0.312119543552399, 0.312062591314316, 0.312005579471588, 0.311948478221893, 0.311891287565231, 0.311834037303925, 0.311776727437973, 0.311719328165054, 0.311661869287491, 0.311604350805283, 0.311546713113785, 0.311489045619965, 0.311431288719177, 0.311373472213745, 0.311315536499023, 0.311257600784302, 0.311199516057968, 0.311141431331635, 0.311083227396011, 0.311024963855743, 0.310966640710831, 0.310908198356628, 0.310849726200104, 0.310791164636612, 0.310732543468475, 0.310673832893372, 0.310615092515945, 0.31055623292923, 0.310497343540192, 0.310438334941864, 0.310379266738892, 0.310320109128952, 0.31026092171669, 0.310201644897461, 0.310142278671265, 0.310082852840424, 0.310023367404938, 0.309963792562485, 0.309904158115387, 0.309844434261322, 0.309784650802612, 0.309724807739258, 0.309664875268936, 0.30960488319397, 0.309544771909714, 0.309484630823135, 0.309424430131912, 0.3093641102314, 0.309303760528564, 0.309243321418762, 0.309182792901993, 0.309122204780579, 0.30906155705452, 0.309000819921494, 0.308940023183823, 0.308879137039185, 0.308818191289902, 0.308757185935974, 0.308696091175079, 0.30863493680954, 0.308573693037033, 0.308512359857559, 0.308450996875763, 0.308389514684677, 0.308327972888947, 0.308266431093216, 0.308204740285873, 0.308142989873886, 0.308081179857254, 0.308019280433655, 0.307957321405411, 0.3078952729702, 0.307833164930344, 0.307770997285843, 0.307708710432053, 0.30764639377594, 0.307584017515182, 0.307521551847458, 0.307458996772766, 0.307396352291107, 0.307333707809448, 0.307270914316177, 0.307208091020584, 0.307145178318024, 0.307082206010818, 0.307019144296646, 0.306956022977829, 0.306892842054367, 0.306829571723938, 0.306766211986542, 0.306702822446823, 0.306639343500137, 0.306575775146484, 0.306512117385864, 0.306448429822922, 0.306384652853012, 0.306320816278458, 0.306256860494614, 0.306192874908447, 0.306128829717636, 0.306064695119858, 0.306000500917435, 0.305936187505722, 0.305871814489365, 0.305807381868362, 0.305742889642715, 0.305678337812424, 0.305613666772842, 0.305548965930939, 0.305484175682068, 0.30541929602623, 0.305354356765747, 0.30528935790062, 0.305224269628525, 0.305159121751785, 0.305093884468079, 0.305028587579727, 0.304963231086731, 0.304897755384445, 0.304832249879837, 0.304766654968262, 0.304700970649719, 0.304635256528854, 0.304573088884354, 0.304514676332474, 0.304456144571304, 0.30439755320549, 0.304338842630386, 0.304280072450638, 0.3042211830616, 0.304162234067917, 0.304103165864944, 0.304044008255005, 0.303984761238098, 0.303925454616547, 0.303865998983383, 0.303806483745575, 0.3037468791008, 0.303687185049057, 0.303627401590347, 0.303567498922348, 0.303507566452026, 0.303447484970093, 0.303387314081192, 0.303327053785324, 0.303266733884811, 0.303206294775009, 0.303145796060562, 0.303085207939148, 0.303024470806122, 0.302963674068451, 0.302902787923813, 0.30284184217453, 0.302780777215958, 0.302719593048096, 0.302658349275589, 0.302596986293793, 0.302535563707352, 0.302474021911621, 0.302412420511246, 0.302350729703903, 0.302288919687271, 0.302227020263672, 0.302165061235428, 0.302103012800217, 0.302040845155716, 0.301978588104248, 0.301916211843491, 0.301853805780411, 0.301791280508041, 0.301728665828705, 0.301665961742401, 0.301603138446808, 0.301540225744247, 0.301477253437042, 0.30141419172287, 0.30135104060173, 0.301287800073624, 0.301224440336227, 0.301160991191864, 0.301097452640533, 0.301033854484558, 0.300970107316971, 0.300906300544739, 0.300842434167862, 0.300778448581696, 0.300714373588562, 0.300650179386139, 0.300585925579071, 0.300521582365036, 0.300457119941711, 0.300392627716064, 0.300327986478806, 0.300263285636902, 0.300198435783386, 0.300133556127548, 0.300068587064743, 0.300003498792648, 0.299938321113586, 0.29987308382988, 0.299807697534561, 0.299742251634598, 0.299676716327667, 0.299611061811447, 0.299545347690582, 0.29947954416275, 0.299413651227951, 0.299347698688507, 0.299281597137451, 0.299215406179428, 0.299149125814438, 0.29908275604248, 0.299016326665878, 0.298949807882309, 0.298883140087128, 0.298816442489624, 0.298749625682831, 0.29868271946907, 0.298615723848343, 0.298548638820648, 0.298481434583664, 0.298414200544357, 0.298346817493439, 0.298279374837875, 0.298211812973022, 0.298144191503525, 0.298076450824738, 0.298008650541306, 0.297940731048584, 0.297872722148895, 0.297804653644562, 0.297736465930939, 0.297668188810349, 0.297599852085114, 0.297531396150589, 0.297462821006775, 0.297394186258316, 0.29732546210289, 0.297256618738174, 0.297187715768814, 0.297118723392487, 0.297049641609192, 0.296980440616608, 0.296911150217056, 0.29684180021286, 0.296772330999374, 0.296702802181244, 0.296633124351501, 0.296563416719437, 0.296493589878082, 0.296423673629761, 0.296353667974472, 0.296283572912216, 0.296213358640671, 0.296143114566803, 0.296072751283646, 0.296002268791199, 0.295931696891785, 0.295861065387726, 0.295790314674377, 0.295719504356384, 0.295648574829102, 0.295577555894852, 0.295506477355957, 0.29543524980545, 0.295363992452621, 0.295292645692825, 0.295221149921417, 0.295149594545364, 0.295077949762344, 0.295006215572357, 0.294934391975403, 0.294862478971481, 0.29479044675827, 0.294718325138092, 0.294646143913269, 0.294573843479156, 0.294501483440399, 0.294429004192352, 0.294356435537338, 0.294283807277679, 0.294211059808731, 0.294138222932816, 0.294065296649933, 0.293992280960083, 0.293919175863266, 0.293845951557159, 0.29377269744873, 0.29369929432869, 0.293625801801682, 0.293552249670029, 0.293478637933731, 0.293404847383499, 0.293330997228622, 0.293257087469101, 0.29318305850029, 0.293108940124512, 0.293034791946411, 0.292960464954376, 0.292886078357697, 0.29281160235405, 0.292737007141113, 0.292662352323532, 0.292587608098984, 0.292512774467468, 0.292437851428986, 0.292362809181213, 0.292287707328796, 0.292212516069412, 0.292137175798416, 0.292061805725098, 0.291986346244812, 0.291910767555237, 0.291835099458694, 0.291759341955185, 0.291683495044708, 0.291607558727264, 0.291531562805176, 0.291455417871475, 0.29137921333313, 0.291302889585495, 0.291226506233215, 0.291150033473969, 0.291073441505432, 0.290996760129929, 0.29092001914978, 0.290843218564987, 0.29076623916626, 0.290689200162888, 0.290612101554871, 0.290534883737564, 0.29045757651329, 0.29038017988205, 0.290302723646164, 0.290225118398666, 0.290147453546524, 0.290069699287415, 0.289991825819016, 0.289913892745972, 0.289835840463638, 0.28975772857666, 0.289679497480392, 0.28960120677948, 0.289522796869278, 0.289444327354431, 0.289365768432617, 0.289287060499191, 0.289208292961121, 0.289129436016083, 0.289050489664078, 0.288971453905106, 0.288892328739166, 0.28881311416626, 0.288733810186386, 0.288654416799545, 0.288574904203415, 0.28849533200264, 0.288415640592575, 0.288335889577866, 0.288256019353867, 0.2881760597229, 0.288096040487289, 0.288015902042389, 0.287935674190521, 0.287855356931686, 0.287774950265884, 0.287694454193115, 0.287613868713379, 0.287533193826675, 0.287452399730682, 0.287371575832367, 0.28729060292244, 0.287209540605545, 0.287128418684006, 0.287047207355499, 0.286965876817703, 0.286884486675262, 0.286802977323532, 0.286721378564835, 0.28663969039917, 0.286557912826538, 0.286476045846939, 0.286394119262695, 0.286312073469162, 0.286229908466339, 0.286147683858871, 0.286065369844437, 0.285982966423035, 0.285900443792343, 0.285817831754684, 0.285735160112381, 0.285652369260788, 0.285569548606873, 0.285486549139023, 0.285403519868851, 0.285320371389389, 0.285237103700638, 0.285153776407242, 0.285070389509201, 0.284986883401871, 0.284903287887573, 0.284819573163986, 0.284735828638077, 0.284651935100555, 0.284567981958389, 0.284483939409256, 0.284399777650833, 0.284315526485443, 0.284231215715408, 0.284146755933762, 0.284062296152115, 0.283977687358856, 0.28389298915863, 0.28380823135376, 0.283723324537277, 0.283638387918472, 0.283553302288055, 0.283468157052994, 0.283382922410965, 0.283297568559647, 0.283212155103683, 0.283126622438431, 0.283041030168533, 0.282955348491669, 0.282869547605515, 0.282783687114716, 0.282697677612305, 0.282611638307571, 0.282525479793549, 0.282439261674881, 0.282352924346924, 0.282266467809677, 0.282179951667786, 0.282093346118927, 0.282006651163101, 0.281919866800308, 0.281832993030548, 0.281746000051498, 0.281658947467804, 0.28157177567482, 0.281484544277191, 0.281397193670273, 0.28130978345871, 0.281222254037857, 0.281134635210037, 0.281046956777573, 0.280959129333496, 0.280871242284775, 0.280783265829086, 0.280695229768753, 0.280607044696808, 0.280518800020218, 0.280430436134338, 0.280342012643814, 0.280253499746323, 0.280164867639542, 0.280076175928116, 0.279987394809723, 0.27989849448204, 0.279809504747391, 0.279720455408096, 0.27963125705719, 0.279541999101639, 0.27945265173912, 0.279363214969635, 0.279273718595505, 0.279184073209763, 0.279094368219376, 0.279004573822021, 0.2789146900177, 0.278824716806412, 0.278734624385834, 0.278644472360611, 0.278554201126099, 0.278463870286942, 0.278373420238495, 0.278282880783081, 0.2781922519207, 0.278101533651352, 0.278010755777359, 0.277919858694077, 0.277828872203827, 0.27773779630661, 0.277646601200104, 0.277555346488953, 0.277464002370834, 0.277372568845749, 0.277281016111374, 0.277189403772354, 0.277097672224045, 0.277005851268768, 0.276913970708847, 0.276822000741959, 0.276729881763458, 0.276637703180313, 0.276545464992523, 0.276453107595444, 0.276360660791397, 0.276268124580383, 0.27617546916008, 0.276082783937454, 0.275989949703217, 0.275897026062012, 0.275804072618484, 0.275710999965668, 0.275617808103561, 0.275524497032166, 0.27543118596077, 0.275337725877762, 0.275244176387787, 0.275150567293167, 0.275056809186935, 0.274963021278381, 0.274869084358215, 0.274775087833405, 0.274681001901627, 0.274586856365204, 0.274492561817169, 0.27439820766449, 0.274303734302521, 0.274209201335907, 0.274114549160004, 0.274019837379456, 0.273925006389618, 0.273830115795135, 0.273735105991364, 0.273640036582947, 0.27354484796524, 0.273449540138245, 0.273354172706604, 0.273258715867996, 0.273163169622421, 0.273067563772202, 0.27297180891037, 0.272875994443893, 0.27278009057045, 0.272684067487717, 0.272587954998016, 0.272491782903671, 0.272395491600037, 0.272299140691757, 0.272202670574188, 0.272106140851974, 0.272009491920471, 0.271912753582001, 0.271815925836563, 0.271718978881836, 0.271622002124786, 0.271524906158447, 0.271427720785141, 0.271330416202545, 0.271233052015305, 0.271135598421097, 0.271038055419922, 0.270940393209457, 0.270842641592026, 0.270744830369949, 0.270646899938583, 0.270548909902573, 0.270450800657272, 0.270352572202682, 0.270254343748093, 0.270155936479568, 0.2700574696064, 0.269958913326263, 0.26986026763916, 0.26976153254509, 0.26966267824173, 0.269563764333725, 0.269464761018753, 0.269365638494492, 0.269266456365585, 0.26916715502739, 0.269067794084549, 0.268968284130096, 0.268868744373322, 0.268769085407257, 0.268669337034225, 0.268569499254227, 0.268469601869583, 0.26836958527565, 0.268269449472427, 0.26816925406456, 0.268068969249725, 0.267968595027924, 0.267868131399155, 0.267767518758774, 0.267666906118393, 0.2675661444664, 0.26746529340744, 0.267364382743835, 0.267263352870941, 0.26716223359108, 0.267061054706573, 0.266959726810455, 0.266858339309692, 0.266756892204285, 0.266655266284943, 0.266553640365601, 0.266451895236969, 0.26635006070137, 0.266248136758804, 0.266146093606949, 0.266043990850449, 0.265941739082336, 0.265839487314224, 0.2657370865345, 0.265634596347809, 0.26553201675415, 0.265429377555847, 0.265326619148254, 0.265223741531372, 0.265120834112167, 0.265017807483673, 0.264914661645889, 0.264811456203461, 0.264708161354065, 0.264604777097702, 0.264501303434372, 0.264397710561752, 0.264294028282166, 0.264190286397934, 0.264086425304413, 0.26397642493248, 0.263860464096069, 0.263744443655014, 0.263628304004669, 0.263512074947357, 0.263395756483078, 0.263279348611832, 0.263162821531296, 0.263046234846115, 0.262929558753967, 0.26281276345253, 0.262695878744125, 0.262578934431076, 0.262461870908737, 0.262344747781754, 0.26222750544548, 0.262110143899918, 0.26199272274971, 0.261875212192535, 0.261757582426071, 0.261639922857285, 0.261522114276886, 0.26140421628952, 0.26128625869751, 0.261168152093887, 0.26104998588562, 0.260931760072708, 0.260813415050507, 0.260694980621338, 0.26057642698288, 0.260457813739777, 0.260339081287384, 0.260220289230347, 0.260101407766342, 0.259982407093048, 0.259863317012787, 0.259744137525558, 0.259624868631363, 0.2595055103302, 0.25938606262207, 0.259266495704651, 0.259146898984909, 0.259027153253555, 0.258907347917557, 0.258787423372269, 0.258667409420013, 0.258547306060791, 0.258427113294601, 0.258306831121445, 0.258186489343643, 0.25806599855423, 0.257945448160172, 0.257824808359146, 0.257704049348831, 0.257583230733871, 0.257462292909622, 0.257341265678406, 0.257220149040222, 0.257098972797394, 0.256977677345276, 0.256856292486191, 0.256734818220139, 0.256613224744797, 0.25649157166481, 0.256369829177856, 0.256247967481613, 0.256126016378403, 0.256003975868225, 0.25588184595108, 0.255759626626968, 0.255637347698212, 0.255514949560165, 0.255392462015152, 0.255269855260849, 0.255147188901901, 0.255024433135986, 0.254901528358459, 0.25477859377861, 0.254655569791794, 0.254532426595688, 0.254409193992615, 0.254285871982574, 0.254162460565567, 0.254038959741592, 0.253915339708328, 0.253791660070419, 0.253667861223221, 0.253544002771378, 0.253420054912567, 0.253295987844467, 0.2531718313694, 0.253047585487366, 0.252923250198364, 0.252798825502396, 0.25267431139946, 0.252549678087234, 0.252424985170364, 0.252300202846527, 0.2521753013134, 0.252050340175629, 0.251925230026245, 0.251800090074539, 0.251674801111221, 0.251549452543259, 0.251424044370651, 0.251298487186432, 0.251172870397568, 0.251047164201736, 0.250921338796616, 0.250795423984528, 0.250669449567795, 0.250543385744095, 0.250417172908783, 0.250290900468826, 0.250164538621902, 0.250038087368011, 0.249911561608315, 0.249784901738167, 0.249658167362213, 0.249531358480453, 0.249404445290565, 0.24927744269371, 0.249150365591049, 0.249023109674454, 0.248895868659019, 0.248768463730812, 0.24864099919796, 0.248513460159302, 0.248385801911354, 0.248258054256439, 0.248130217194557, 0.248002290725708, 0.24787425994873, 0.247746139764786, 0.247617945075035, 0.247489631175995, 0.24736125767231, 0.247232794761658, 0.247104212641716, 0.246975541114807, 0.246846780180931, 0.246717944741249, 0.246588975191116, 0.246459975838661, 0.246330812573433, 0.246201619505882, 0.24607227742672, 0.245942890644073, 0.245813384652138, 0.245683789253235, 0.245554149150848, 0.245424374938011, 0.245294526219368, 0.245164528489113, 0.245034515857697, 0.244904339313507, 0.244774103164673, 0.244643807411194, 0.244513392448425, 0.24438288807869, 0.244252264499664, 0.244121566414833, 0.243990793824196, 0.24385991692543, 0.243728965520859, 0.243597880005836, 0.243466749787331, 0.243335470557213, 0.243204161524773, 0.243072718381882, 0.242941200733185, 0.24280957877636, 0.24267789721489, 0.242546066641808, 0.242414176464081, 0.242282226681709, 0.242150127887726, 0.242017954587936, 0.241885721683502, 0.241753354668617, 0.241620913147926, 0.241488382220268, 0.241355761885643, 0.241223022341728, 0.24109023809433, 0.240957275032997, 0.240824311971664, 0.240691229701042, 0.24055802822113, 0.240424782037735, 0.240291386842728, 0.240157932043076, 0.240024387836456, 0.23989075422287, 0.239757016301155, 0.239623188972473, 0.239489272236824, 0.239355266094208, 0.239221140742302, 0.239086955785751, 0.238952681422234, 0.238818317651749, 0.238683834671974, 0.238549247384071, 0.238414615392685, 0.238279864192009, 0.238145023584366, 0.238010093569756, 0.237875089049339, 0.237739950418472, 0.237604781985283, 0.237469434738159, 0.237334072589874, 0.237198576331139, 0.237063005566597, 0.236927345395088, 0.236791580915451, 0.236655727028847, 0.236519783735275, 0.236383751034737, 0.236247599124908, 0.236111402511597, 0.235975071787834, 0.235838681459427, 0.235702201724052, 0.235565587878227, 0.235428914427757, 0.235292121767998, 0.235155254602432, 0.2350182980299, 0.234881237149239, 0.234744101762772, 0.234606862068176, 0.234469562768936, 0.234332099556923, 0.234194606542587, 0.234056994318962, 0.233919307589531, 0.233781531453133, 0.233643665909767, 0.233505681157112, 0.23336760699749, 0.233229473233223, 0.233091205358505, 0.232952892780304, 0.232814431190491, 0.232675909996033, 0.232537284493446, 0.232398584485054, 0.232259795069695, 0.232120886445045, 0.231981888413429, 0.231842830777168, 0.231703668832779, 0.231564402580261, 0.231425032019615, 0.231285601854324, 0.231146082282066, 0.231006428599358, 0.230866685509682, 0.230726912617683, 0.230586990714073, 0.230446994304657, 0.230306893587112, 0.23016668856144, 0.230026438832283, 0.229886054992676, 0.229745596647263, 0.229605078697205, 0.229464411735535, 0.229323700070381, 0.229182854294777, 0.229041934013367, 0.228900894522667, 0.228759825229645, 0.228618621826172, 0.228477329015732, 0.228335961699486, 0.228194460272789, 0.22805292904377, 0.227911248803139, 0.227769508957863, 0.22762767970562, 0.227485716342926, 0.227343708276749, 0.227201581001282, 0.227059379220009, 0.226917073130608, 0.226774677634239, 0.226632222533226, 0.22648960351944, 0.226346969604492, 0.226204186677933, 0.226061329245567, 0.225918367505074, 0.225775331258774, 0.225632205605507, 0.225488990545273, 0.22534567117691, 0.22520224750042, 0.225058734416962, 0.224915146827698, 0.224771469831467, 0.224627703428268, 0.224483832716942, 0.224339887499809, 0.224195808172226, 0.22405169904232, 0.22390741109848, 0.223763138055801, 0.223618686199188, 0.223474189639091, 0.223329573869705, 0.223184868693352, 0.223040074110031, 0.222895205020905, 0.222750216722488, 0.222605124115944, 0.222460001707077, 0.222314760088921, 0.222169414162636, 0.222023963928223, 0.221878424286842, 0.221732839941978, 0.221587091684341, 0.221441298723221, 0.221295416355133, 0.221149414777756, 0.221003353595734, 0.220857158303261, 0.220710903406143, 0.220564544200897, 0.220418095588684, 0.220271542668343, 0.220124915242195, 0.219978243112564, 0.219831377267838, 0.219684466719627, 0.219537451863289, 0.219390407204628, 0.219243183732033, 0.219095915555954, 0.218948557972908, 0.218801081180573, 0.218653544783592, 0.218505889177322, 0.218358144164085, 0.218210309743881, 0.218062400817871, 0.217914372682571, 0.217766270041466, 0.217618092894554, 0.217469781637192, 0.217321425676346, 0.217172920703888, 0.217024341225624, 0.216875717043877, 0.216726958751678, 0.216578096151352, 0.216429159045219, 0.21628013253212, 0.216131001710892, 0.215981796383858, 0.215832516551018, 0.215683117508888, 0.215533629059792, 0.215384036302567, 0.215234354138374, 0.215084582567215, 0.214934751391411, 0.214784756302834, 0.214634731411934, 0.214484617114067, 0.21433436870575, 0.214184060692787, 0.214033663272858, 0.2138831615448, 0.213732555508614, 0.21358186006546, 0.213431119918823, 0.213280215859413, 0.213129281997681, 0.212978199124336, 0.212827056646347, 0.212675809860229, 0.212524503469467, 0.212373077869415, 0.212221533060074, 0.212069943547249, 0.211918234825134, 0.211766436696053, 0.211614564061165, 0.211462587118149, 0.211310505867004, 0.211158335208893, 0.211006119847298, 0.210853740572929, 0.210701316595078, 0.210548773407936, 0.21039617061615, 0.210243448615074, 0.210090652108192, 0.209937766194344, 0.209784761071205, 0.209631696343422, 0.209478497505188, 0.209325209259987, 0.209171861410141, 0.209018439054489, 0.208864897489548, 0.208711236715317, 0.208557516336441, 0.208403706550598, 0.208249807357788, 0.208095788955688, 0.207941681146622, 0.20778751373291, 0.207633227109909, 0.207478865981102, 0.207324385643005, 0.207169845700264, 0.207015171647072, 0.206860437989235, 0.206705629825592, 0.206550687551498, 0.206395655870438, 0.206240549683571, 0.206085354089737, 0.205930054187775, 0.205774664878845, 0.20561920106411, 0.205463632941246, 0.205307975411415, 0.205152213573456, 0.204996362328529, 0.204840436577797, 0.204684376716614, 0.204528287053108, 0.204372048377991, 0.204215750098228, 0.204059347510338, 0.203902870416641, 0.203746274113655, 0.203589603304863, 0.203432813286781, 0.203275948762894, 0.203119024634361, 0.202961966395378, 0.20280484855175, 0.202647611498833, 0.202490299940109, 0.202332854270935, 0.202175378799438, 0.202017784118652, 0.201860070228577, 0.201702296733856, 0.201544418931007, 0.201386481523514, 0.201228395104408, 0.20107027888298, 0.20091201364994, 0.200753673911095, 0.200595244765282, 0.200436741113663, 0.200278118252754, 0.20011942088604, 0.199960619211197, 0.199801728129387, 0.199642762541771, 0.199483707547188, 0.199324533343315, 0.199165284633636, 0.199005916714668, 0.198846474289894, 0.198686957359314, 0.198527321219444, 0.198367640376091, 0.198207780718803, 0.198047921061516, 0.197887912392616, 0.197727844119072, 0.197567641735077, 0.197407379746437, 0.19724702835083, 0.197086572647095, 0.196926027536392, 0.1967653632164, 0.196604654192924, 0.196443811058998, 0.196282923221588, 0.19612193107605, 0.195960819721222, 0.195799618959427, 0.195638343691826, 0.195476964116096, 0.1953154951334, 0.195153936743736, 0.194992303848267, 0.194830536842346, 0.194668740034103, 0.194498553872108, 0.194320157170296, 0.194141745567322, 0.193963393568993, 0.193785071372986, 0.193606734275818, 0.19342839717865, 0.193250119686127, 0.193071886897087, 0.192893624305725, 0.192715421319008, 0.192537203431129, 0.192359030246735, 0.192180871963501, 0.192002713680267, 0.191824600100517, 0.191646486520767, 0.191468447446823, 0.191290378570557, 0.19111230969429, 0.190934300422668, 0.190756306052208, 0.190578326582909, 0.190400362014771, 0.190222442150116, 0.190044537186623, 0.18986664712429, 0.18968877196312, 0.189510881900787, 0.189333111047745, 0.189155235886574, 0.188977465033531, 0.188799694180489, 0.188621953129768, 0.188444271683693, 0.188266515731812, 0.188088849186897, 0.187911182641983, 0.18773353099823, 0.187555894255638, 0.187378287315369, 0.187200725078583, 0.187023118138313, 0.186845600605011, 0.186668068170547, 0.186490595340729, 0.18631312251091, 0.186135619878769, 0.185958206653595, 0.18578077852726, 0.185603410005569, 0.185425996780396, 0.185248658061028, 0.185071304440498, 0.184894025325775, 0.184716701507568, 0.184539422392845, 0.184362187981606, 0.184184938669205, 0.184007734060287, 0.183830514550209, 0.183653369545937, 0.183476224541664, 0.183299079537392, 0.183121979236603, 0.182944878935814, 0.182767808437347, 0.182590752840042, 0.18241374194622, 0.182236716151237, 0.182059749960899, 0.181882783770561, 0.181705817580223, 0.181528896093369, 0.181352004408836, 0.181175142526627, 0.180998221039772, 0.180821418762207, 0.180644616484642, 0.180467799305916, 0.180291041731834, 0.180114269256592, 0.179937526583672, 0.179760783910751, 0.179584100842476, 0.179407447576523, 0.179230764508247, 0.179054155945778, 0.178877502679825, 0.178700953722, 0.178524345159531, 0.17834784090519, 0.178171321749687, 0.177994772791862, 0.177818298339844, 0.177641823887825, 0.177465349435806, 0.177288919687271, 0.177112504839897, 0.176936149597168, 0.176759749650955, 0.176583424210548, 0.17640708386898, 0.176230803132057, 0.176054492592812, 0.175878241658211, 0.17570199072361, 0.175525769591331, 0.175349593162537, 0.175173372030258, 0.174997240304947, 0.174821108579636, 0.174644991755486, 0.174468860030174, 0.17429281771183, 0.174116760492325, 0.173940718173981, 0.173764690756798, 0.173588693141937, 0.173412725329399, 0.173236772418022, 0.173060819506645, 0.172884926199913, 0.17270901799202, 0.17253315448761, 0.1723572909832, 0.172181472182274, 0.172005668282509, 0.171829879283905, 0.171654120087624, 0.171478360891342, 0.171302646398544, 0.171126917004585, 0.170951247215271, 0.170775562524796, 0.170599922537804, 0.170424297451973, 0.170248672366142, 0.170073106884956, 0.169897556304932, 0.169722035527229, 0.169546484947205, 0.169370993971825, 0.169195502996445, 0.16902007162571, 0.168844640254974, 0.168669179081917, 0.168493792414665, 0.168318405747414, 0.168143063783646, 0.167967706918716, 0.167792394757271, 0.167617157101631, 0.167441859841347, 0.167266577482224, 0.167091354727745, 0.16691617667675, 0.166740983724594, 0.166565760970116, 0.166390657424927, 0.166215509176254, 0.166040405631065, 0.165865287184715, 0.165690243244171, 0.165515184402466, 0.165340185165405, 0.165165200829506, 0.164990171790123, 0.164815232157707, 0.16464027762413, 0.164465352892876, 0.164290428161621, 0.164115563035011, 0.163940727710724, 0.163765862584114, 0.163591027259827, 0.163416236639023, 0.163241490721703, 0.163066700100899, 0.162891983985901, 0.162717238068581, 0.162542551755905, 0.162367925047874, 0.162193208932877, 0.162018582224846, 0.161843985319138, 0.16166940331459, 0.161494791507721, 0.161320269107819, 0.161145746707916, 0.160971239209175, 0.160796731710434, 0.160622254014015, 0.16044782102108, 0.160273402929306, 0.160098969936371, 0.15992459654808, 0.15975022315979, 0.159575894474983, 0.159401550889015, 0.159227266907692, 0.159052982926369, 0.158878713846207, 0.158704474568367, 0.158530250191689, 0.158356055617332, 0.158181890845299, 0.158007696270943, 0.157833561301231, 0.157659456133842, 0.157485336065292, 0.157311260700226, 0.157137230038643, 0.156963184475899, 0.156789168715477, 0.156615152955055, 0.156441196799278, 0.156267240643501, 0.156093329191208, 0.155919432640076, 0.15574549138546, 0.155571639537811, 0.155397787690163, 0.155223950743675, 0.155050128698349, 0.154876381158829, 0.154702618718147, 0.154528856277466, 0.154355123639107, 0.154181405901909, 0.154007732868195, 0.153834089636803, 0.153660416603088, 0.153486788272858, 0.153313219547272, 0.153139635920525, 0.152966037392616, 0.152792498469353, 0.152618989348412, 0.152445495128632, 0.152272030711174, 0.152098536491394, 0.151925131678581, 0.151751682162285, 0.151578292250633, 0.15140488743782, 0.151231572031975, 0.151058211922646, 0.1508848965168, 0.15071165561676, 0.150538370013237, 0.150365129113197, 0.150191843509674, 0.150018692016602, 0.149845466017723, 0.149672314524651, 0.149499177932739, 0.149326026439667, 0.149152904748917, 0.14897982776165, 0.148806750774384, 0.148633688688278, 0.148460701107979, 0.148287713527679, 0.148114711046219, 0.147941738367081, 0.147768780589104, 0.14759586751461, 0.1474229991436, 0.147250100970268, 0.147077232599258, 0.146904394030571, 0.146731600165367, 0.14655876159668, 0.146385997533798, 0.146213233470917, 0.146040514111519, 0.145867824554443, 0.145695090293884, 0.145522445440292, 0.145349770784378, 0.145177140831947, 0.145004510879517, 0.144831940531731, 0.144659340381622, 0.144486784934998, 0.144314259290695, 0.144141748547554, 0.143969282507896, 0.143796756863594, 0.14362433552742, 0.143451914191246, 0.143279522657394, 0.143107160925865, 0.142934769392014, 0.142762437462807, 0.1425901055336, 0.142417833209038, 0.142245516180992, 0.142073258757591, 0.141901031136513, 0.141728818416595, 0.141556605696678, 0.141384407877922, 0.141212284564972, 0.141040131449699, 0.140868008136749, 0.140695914626122, 0.140523836016655, 0.140351802110672, 0.140179738402367, 0.140007719397545, 0.139835730195045, 0.139663770794868, 0.139491811394691, 0.139319881796837, 0.139147952198982, 0.138976082205772, 0.13880418241024, 0.13863231241703, 0.138460516929626, 0.138288706541061, 0.138116925954819, 0.137945160269737, 0.137773379683495, 0.13760170340538, 0.137429982423782, 0.137258306145668, 0.137086629867554, 0.136915013194084, 0.136743381619453, 0.136571735143661, 0.136400207877159, 0.136228635907173, 0.13605709373951, 0.135885551571846, 0.135714054107666, 0.135542616248131, 0.135371148586273, 0.135199695825577, 0.135028287768364, 0.134856879711151, 0.134685531258583, 0.134514153003693, 0.134342849254608, 0.13417150080204, 0.134000241756439, 0.133828938007355, 0.133657693862915, 0.133486449718475, 0.13331526517868, 0.133144095540047, 0.132972911000252, 0.132801741361618, 0.132630601525307, 0.132459506392479, 0.132288411259651, 0.132117375731468, 0.131946325302124, 0.13177527487278, 0.13160428404808, 0.131433308124542, 0.131262376904488, 0.131091371178627, 0.130920469760895, 0.130749553442001, 0.130578726530075, 0.130407854914665, 0.130236983299255, 0.130066186189651, 0.129895403981209, 0.129724636673927, 0.129553809762001, 0.129383102059364, 0.129212409257889, 0.129041716456413, 0.128871038556099, 0.128700390458107, 0.128529772162437, 0.128359138965607, 0.12818855047226, 0.128017991781235, 0.127847447991371, 0.12767693400383, 0.127506360411644, 0.127335920929909, 0.12716543674469, 0.126994982361794, 0.126824572682381, 0.126654148101807, 0.126483768224716, 0.126313403248787, 0.126143053174019, 0.125972718000412, 0.12580244243145, 0.125632166862488, 0.125461876392365, 0.125291660428047, 0.125121429562569, 0.124951250851154, 0.124781019985676, 0.124610915780067, 0.124440759420395, 0.124270625412464, 0.12410057336092, 0.123930469155312, 0.123760417103767, 0.123590402305126, 0.123420372605324, 0.123250357806683, 0.123080395162106, 0.122910469770432, 0.122740536928177, 0.122570596635342, 0.122400715947151, 0.122230850160122, 0.122061014175415, 0.121891148388386, 0.121721394360065, 0.12155157327652, 0.121381834149361, 0.121212057769299, 0.121042378246784, 0.120872631669044, 0.120702967047691, 0.120533332228661, 0.120363652706146, 0.120194040238857, 0.120024427771568, 0.119854852557182, 0.119685269892216, 0.119515754282475, 0.119346223771572, 0.119176715612411, 0.119007274508476, 0.118837796151638, 0.118668369948864, 0.11849894374609, 0.118329547345638, 0.118160165846348, 0.117990829050541, 0.117821514606476, 0.117652162909508, 0.117482900619507, 0.117313601076603, 0.117144390940666, 0.116975136101246, 0.116805948317051, 0.116636782884598, 0.116467602550983, 0.116298422217369, 0.116129294037819, 0.115960188210011, 0.115791097283363, 0.11562205851078, 0.115453012287617, 0.115283980965614, 0.115114986896515, 0.114945963025093, 0.114777058362961, 0.114608108997345, 0.114439189434052, 0.114270269870758, 0.114101395010948, 0.113932535052299, 0.113763689994812, 0.113594874739647, 0.113426059484482, 0.113257318735123, 0.113088563084602, 0.112919799983501, 0.112751126289368, 0.11258240789175, 0.112413726747036, 0.112245053052902, 0.112076453864574, 0.111907847225666, 0.111739248037338, 0.111570693552494, 0.111402131617069, 0.111233621835709, 0.111065097153187, 0.11089663952589, 0.11072812974453, 0.110559701919556, 0.110391288995743, 0.11022287607193, 0.110054492950439, 0.109886109828949, 0.109717778861523, 0.109549470245838, 0.109381139278412, 0.109212875366211, 0.109044604003429, 0.108876384794712, 0.108708135783672, 0.108539953827858, 0.108371771872044, 0.108203627169132, 0.108035519719124, 0.107876680791378, 0.107727266848087, 0.107577972114086, 0.107428811490536, 0.107279688119888, 0.107130840420723, 0.106982029974461, 0.106833323836327, 0.106684781610966, 0.106536380946636, 0.106388054788113, 0.106239899992943, 0.106091842055321, 0.105943895876408, 0.105796121060848, 0.105648465454578, 0.105500899255276, 0.105353534221649, 0.105206154286861, 0.105059050023556, 0.104911975562572, 0.104765094816685, 0.104618258774281, 0.104471564292908, 0.104325026273727, 0.104178600013256, 0.104032345116138, 0.103886127471924, 0.103740088641644, 0.103594206273556, 0.103448316454887, 0.103302679955959, 0.103157185018063, 0.103011704981327, 0.102866426110268, 0.102721251547337, 0.10257626324892, 0.102431304752827, 0.102286510169506, 0.102141819894314, 0.101997271180153, 0.101852856576443, 0.10170853883028, 0.101564340293407, 0.101420395076275, 0.101276442408562, 0.101132623851299, 0.10098896920681, 0.100845418870449, 0.100702032446861, 0.100558653473854, 0.10041556507349, 0.100272506475449, 0.100129522383213, 0.0999867990612984, 0.0998440831899643, 0.0997015982866287, 0.0995591953396797, 0.0994168892502785, 0.0992747098207474, 0.0991326197981834, 0.0989907905459404, 0.0988489836454391, 0.0987072810530663, 0.0985657647252083, 0.0984243378043175, 0.0982830673456192, 0.0981418788433075, 0.0980008542537689, 0.0978599190711975, 0.0977191105484962, 0.0975784659385681, 0.0974378809332848, 0.0972975119948387, 0.0971572622656822, 0.0970170348882675, 0.0968769863247871, 0.0967370569705963, 0.0965972766280174, 0.0964576080441475, 0.0963181108236313, 0.0961787179112434, 0.0960394069552422, 0.0959001779556274, 0.0957612097263336, 0.0956222712993622, 0.0954834893345833, 0.0953448265790939, 0.0952062979340553, 0.0950678586959839, 0.094929575920105, 0.0947914943099022, 0.0946533679962158, 0.094515435397625, 0.094377726316452, 0.0942400097846985, 0.0941024646162987, 0.0939650535583496, 0.0938278436660767, 0.0936906412243843, 0.0935535430908203, 0.0934166610240936, 0.0932798683643341, 0.0931432470679283, 0.0930066704750061, 0.0928702875971794, 0.0927339717745781, 0.0925978571176529, 0.0924618020653725, 0.0923258289694786, 0.0921900942921638, 0.0920544490218163, 0.0919189378619194, 0.0917835384607315, 0.0916482135653496, 0.0915130600333214, 0.091377928853035, 0.0912430882453918, 0.0911083072423935, 0.0909736603498459, 0.0908391326665878, 0.0907047018408775, 0.0905703827738762, 0.0904362574219704, 0.0903021842241287, 0.0901683047413826, 0.0900345295667648, 0.0899008587002754, 0.0897673889994621, 0.0896339192986488, 0.0895007029175758, 0.0893675535917282, 0.0892344564199448, 0.0891015529632568, 0.0889687836170197, 0.0888361483812332, 0.0887036249041557, 0.0885712280869484, 0.0884389281272888, 0.0883067473769188, 0.0881747975945473, 0.088042788207531, 0.0879110172390938, 0.0877794101834297, 0.0876478627324104, 0.0875164493918419, 0.0873851180076599, 0.0872540846467018, 0.0871230065822601, 0.0869920775294304, 0.0868613198399544, 0.0867306292057037, 0.086600087583065, 0.0864696800708771, 0.0863394364714622, 0.0862092673778534, 0.0860792174935341, 0.0859493538737297, 0.0858195349574089, 0.085689939558506, 0.0855603963136673, 0.0854309499263763, 0.0853016749024391, 0.0851725935935974, 0.0850434899330139, 0.0849146619439125, 0.0847858563065529, 0.0846572071313858, 0.0845286995172501, 0.0844002142548561, 0.0842720046639442, 0.0841437950730324, 0.0840158015489578, 0.083887942135334, 0.0837601199746132, 0.0836324468255043, 0.0835049748420715, 0.0833775848150253, 0.0832502394914627, 0.0831231325864792, 0.0829961225390434, 0.0828691944479942, 0.0827424749732018, 0.0826157554984093, 0.0824892520904541, 0.0823628380894661, 0.082236610352993, 0.0821104124188423, 0.0819843709468842, 0.0818585231900215, 0.0817326977849007, 0.0816070437431335, 0.0814815238118172, 0.0813561901450157, 0.0812308862805367, 0.0811056941747665, 0.0809807106852531, 0.0808558389544487, 0.0807309970259666, 0.0806064009666443, 0.0804818496108055, 0.0803574398159981, 0.0802331939339638, 0.0801090225577354, 0.0799850299954414, 0.0798611864447594, 0.0797374024987221, 0.0796136930584908, 0.0794901549816132, 0.0793668627738953, 0.0792435109615326, 0.0791203752160072, 0.0789974108338356, 0.078874483704567, 0.0787517353892326, 0.0786289870738983, 0.0785065591335297, 0.0783841535449028, 0.0782618597149849, 0.0781397074460983, 0.0780176594853401, 0.0778958052396774, 0.0777740478515625, 0.0776524171233177, 0.0775308758020401, 0.077409453690052, 0.0772881880402565, 0.0771670415997505, 0.0770460516214371, 0.0769251734018326, 0.0768043696880341, 0.0766837149858475, 0.0765632390975952, 0.0764427930116653, 0.0763225629925728, 0.0762024149298668, 0.0760824009776115, 0.0759624987840652, 0.0758427307009697, 0.0757231488823891, 0.075603574514389, 0.0754841566085815, 0.075364962220192, 0.0752457454800606, 0.0751267597079277, 0.075007863342762, 0.0748891532421112, 0.0747704654932022, 0.0746519267559052, 0.074533574283123, 0.0744152963161469, 0.074297159910202, 0.0741791278123856, 0.074061281979084, 0.0739435032010078, 0.0738258510828018, 0.0737083107233047, 0.0735909268260002, 0.0734736621379852, 0.0733565539121628, 0.0732395276427269, 0.073122613132, 0.073005884885788, 0.0728892087936401, 0.0727726444602013, 0.0726563259959221, 0.0725400596857071, 0.0724239349365234, 0.0723079368472099, 0.0721920281648636, 0.072076216340065, 0.0719606280326843, 0.0718450993299484, 0.0717297270894051, 0.0716144442558289, 0.071499340236187, 0.0713843777775764, 0.0712693855166435, 0.0711547210812569, 0.0710400342941284, 0.0709255039691925, 0.0708111152052879, 0.0706968605518341, 0.0705827623605728, 0.0704687163233757, 0.0703548491001129, 0.0702411010861397, 0.0701274201273918, 0.0700139552354813, 0.0699005052447319, 0.0697872787714005, 0.0696742162108421, 0.0695611834526062, 0.0694482326507568, 0.0693354383111, 0.0692228898406029, 0.0691103711724281, 0.0689979568123817, 0.0688857361674309, 0.0687735676765442, 0.0686615407466888, 0.0685496479272842, 0.0684379190206528, 0.0683262944221497, 0.0682147443294525, 0.0681034252047539, 0.067992128431797, 0.0678809955716133, 0.0677700489759445, 0.0676590725779533, 0.0675483420491219, 0.0674377232789993, 0.0673272162675858, 0.0672168955206871, 0.0671065747737885, 0.0669964998960495, 0.0668864473700523, 0.0667765662074089, 0.0666668117046356, 0.0665571689605713, 0.0664476901292801, 0.0663383230566978, 0.066229060292244, 0.0661198794841766, 0.0660109147429466, 0.065902054309845, 0.0657932311296463, 0.0656846240162849, 0.0655761435627937, 0.0654677525162697, 0.0653594732284546, 0.065251350402832, 0.065143384039402, 0.0650354847311974, 0.0649277940392494, 0.0648201331496239, 0.0647126063704491, 0.0646052435040474, 0.0644979402422905, 0.0643908753991127, 0.0642838403582573, 0.0641769915819168, 0.0640702322125435, 0.0639635771512985, 0.0638571083545685, 0.063750721514225, 0.0636444166302681, 0.0635383576154709, 0.0634323284029961, 0.0633264034986496, 0.0632206946611404, 0.0631150752305984, 0.0630095899105072, 0.0629042312502861, 0.0627989396452904, 0.0626937970519066, 0.0625887736678123, 0.0624839849770069, 0.0623792037367821, 0.0622745864093304, 0.0621701031923294, 0.0620656982064247, 0.0619614832103252, 0.0618572495877743, 0.0617533326148987, 0.0616494417190552, 0.0615456961095333, 0.0614420771598816, 0.0613385438919067, 0.0612352006137371, 0.0611319914460182, 0.0610288605093956, 0.0609257891774178, 0.0608229041099548, 0.0607202127575874, 0.0606175772845745, 0.0605150759220123, 0.060412734746933, 0.0603104755282402, 0.0602083541452885, 0.0601063668727875, 0.060004461556673, 0.0599027760326862, 0.0598010830581188, 0.0596996136009693, 0.0595982521772385, 0.0594969429075718, 0.059395931661129, 0.0592948384582996, 0.0591940246522427, 0.0590933114290237, 0.0589926242828369, 0.0588921345770359, 0.0587917752563953, 0.0586915500462055, 0.0585913844406605, 0.0584914050996304, 0.0583915896713734, 0.0582917705178261, 0.0581922046840191, 0.0580926910042763, 0.057993333786726, 0.0578940846025944, 0.0577949769794941, 0.0576959475874901, 0.0575970858335495, 0.0574983321130276, 0.0573997609317303, 0.0573012493550777, 0.0572028458118439, 0.0571046061813831, 0.0570064969360828, 0.0569084733724594, 0.0568106397986412, 0.0567129142582417, 0.056615274399519, 0.0565178208053112, 0.0564204193651676, 0.056323129683733, 0.0562260858714581, 0.0561290383338928, 0.0560322068631649, 0.0559354647994041, 0.0558388456702232, 0.0557424239814281, 0.0556459538638592, 0.0555498264729977, 0.0554536506533623, 0.0553576350212097, 0.0552617236971855, 0.0551660358905792, 0.0550704561173916, 0.0549749284982681, 0.0548796206712723, 0.0547843426465988, 0.0546891652047634, 0.0545942075550556, 0.0544993355870247, 0.0544046275317669, 0.0543100498616695, 0.0542155541479588, 0.0541211701929569, 0.0540269166231155, 0.0539328269660473, 0.053838849067688, 0.0537449568510056, 0.0536512434482574, 0.0535576194524765, 0.0534641034901142, 0.0533707775175571, 0.053277526050806, 0.0531844235956669, 0.0530914142727852, 0.0529985502362251, 0.0529058240354061, 0.0528131425380707, 0.0527207963168621, 0.0526283383369446, 0.0525361225008965, 0.0524439848959446, 0.0523520186543465, 0.0522601790726185, 0.0521684288978577, 0.0520768687129021, 0.0519853308796883, 0.0518940128386021, 0.05180274695158, 0.0517116226255894, 0.0516206547617912, 0.0515297949314117, 0.0514390207827091, 0.0513484328985214, 0.0512579828500748, 0.0511676445603371, 0.0510773845016956, 0.050987284630537, 0.0508972965180874, 0.0508074201643467, 0.0507177039980888, 0.0506280660629272, 0.0505385659635067, 0.0504492297768593, 0.0503599718213081, 0.0502709373831749, 0.0501818992197514, 0.0500930808484554, 0.0500043109059334, 0.0499157309532166, 0.0498272068798542, 0.0497389100492001, 0.0496506504714489, 0.0495625101029873, 0.0494745597243309, 0.0493866875767708, 0.0492989271879196, 0.0492114014923573, 0.0491238906979561, 0.0490365885198116, 0.0489493124186993, 0.0488622039556503, 0.048783116042614, 0.0487113706767559, 0.0486397370696068, 0.0485681369900703, 0.0484966486692429, 0.0484252795577049, 0.0483540520071983, 0.048282764852047, 0.0482117347419262, 0.0481407381594181, 0.0480698347091675, 0.0479990355670452, 0.0479283183813095, 0.047857690602541, 0.0477871522307396, 0.0477167218923569, 0.0476463735103607, 0.0475761331617832, 0.0475060157477856, 0.047435961663723, 0.0473660491406918, 0.0472961477935314, 0.0472263880074024, 0.0471567325294018, 0.0470871292054653, 0.0470176488161087, 0.0469482764601707, 0.0468789413571358, 0.0468097478151321, 0.0467407070100307, 0.046671636402607, 0.0466027893126011, 0.0465339496731758, 0.0464652180671692, 0.0463965944945812, 0.0463280752301216, 0.0462596118450165, 0.0461912900209427, 0.0461230203509331, 0.046054907143116, 0.0459868237376213, 0.0459188707172871, 0.0458510406315327, 0.0457832328975201, 0.0457155592739582, 0.0456479601562023, 0.045580480247736, 0.0455130785703659, 0.0454457700252533, 0.0453785695135593, 0.0453114546835423, 0.0452444441616535, 0.0451775416731834, 0.0451106913387775, 0.0450439974665642, 0.0449773520231247, 0.0449107922613621, 0.0448443628847599, 0.0447779819369316, 0.044711746275425, 0.0446456074714661, 0.0445795059204102, 0.0445135943591595, 0.0444476865231991, 0.0443819388747215, 0.0443162173032761, 0.0442506745457649, 0.0441851355135441, 0.0441197343170643, 0.0440544486045837, 0.043989222496748, 0.0439241230487823, 0.0438590794801712, 0.043794147670269, 0.0437292978167534, 0.0436646118760109, 0.0435999743640423, 0.0435354188084602, 0.0434709489345551, 0.0434065870940685, 0.0433423593640327, 0.0432781614363194, 0.0432140827178955, 0.0431501120328903, 0.0430862121284008, 0.0430224724113941, 0.0429587364196777, 0.0428951568901539, 0.0428316667675972, 0.0427682548761368, 0.0427049212157726, 0.0426417291164398, 0.0425785593688488, 0.0425155535340309, 0.0424526147544384, 0.0423897579312325, 0.0423269979655743, 0.0422643721103668, 0.042201854288578, 0.0421393923461437, 0.0420770533382893, 0.0420147515833378, 0.0419525876641273, 0.0418905057013035, 0.041828490793705, 0.0417665988206863, 0.0417048297822475, 0.0416431128978729, 0.0415815450251102, 0.0415200032293797, 0.0414586029946804, 0.0413973070681095, 0.041336040943861, 0.0412749052047729, 0.0412138849496841, 0.0411529131233692, 0.0410921089351177, 0.0410313382744789, 0.0409706830978394, 0.0409100949764252, 0.0408496670424938, 0.0407892949879169, 0.0407290272414684, 0.040668822824955, 0.0406087338924408, 0.0405487678945065, 0.0404888205230236, 0.0404290407896042, 0.0403693355619907, 0.0403097346425056, 0.0402501672506332, 0.0401908122003078, 0.0401314161717892, 0.0400722622871399, 0.0400131121277809, 0.0399540439248085, 0.0398951098322868, 0.0398362465202808, 0.0397774614393711, 0.0397187992930412, 0.0396602712571621, 0.0396017469465733, 0.0395433828234673, 0.0394850745797157, 0.0394269414246082, 0.039368849247694, 0.0393108651041985, 0.0392529368400574, 0.0391951128840446, 0.03913738951087, 0.0390797592699528, 0.0390222631394863, 0.0389647707343102, 0.0389074645936489, 0.0388502962887287, 0.038793046027422, 0.0387360788881779, 0.038679126650095, 0.0386222414672375, 0.0385654680430889, 0.0385088138282299, 0.0384522005915642, 0.0383957400918007, 0.0383393727242947, 0.0382830575108528, 0.0382268652319908, 0.0381707400083542, 0.0381147786974907, 0.0380588583648205, 0.038003072142601, 0.0379472896456718, 0.0378916934132576, 0.0378361269831657, 0.0377807095646858, 0.0377253443002701, 0.0376700907945633, 0.0376149415969849, 0.0375599190592766, 0.0375049225986004, 0.0374500900506973, 0.0373953320086002, 0.0373406074941158, 0.0372860431671143, 0.0372315645217896, 0.0371771492063999, 0.0371228717267513, 0.0370686315000057, 0.0370145849883556, 0.0369605273008347, 0.0369065701961517, 0.0368527956306934, 0.0367990769445896, 0.0367454066872597, 0.0366919040679932, 0.0366384536027908, 0.0365850850939751, 0.0365318357944489, 0.0364786759018898, 0.0364255905151367, 0.0363726131618023, 0.0363197885453701, 0.0362669490277767, 0.0362143293023109, 0.0361617431044579, 0.0361092202365398, 0.0360568277537823, 0.0360045172274113, 0.0359522886574268, 0.0359001532196999, 0.0358481295406818, 0.0357962809503078, 0.0357443764805794, 0.0356926396489143, 0.0356410481035709, 0.035589512437582, 0.0355380289256573, 0.0354866534471512, 0.0354354046285152, 0.0353842079639435, 0.0353331342339516, 0.035282164812088, 0.0352312698960304, 0.0351804792881012, 0.0351298674941063, 0.0350792221724987, 0.0350287482142448, 0.0349783226847649, 0.0349280089139938, 0.0348777584731579, 0.0348276644945145, 0.0347776040434837, 0.0347276702523232, 0.0346778184175491, 0.0346281267702579, 0.0345784649252892, 0.0345288440585136, 0.0344794653356075, 0.0344300866127014, 0.034380815923214, 0.0343316271901131, 0.0342825762927532, 0.0342335775494576, 0.0341846607625484, 0.0341359041631222, 0.0340871550142765, 0.0340385474264622, 0.0339900813996792, 0.0339416489005089, 0.0338933318853378, 0.033845093101263, 0.033796988427639, 0.0337489433586597, 0.0337009914219379, 0.0336531326174736, 0.0336053967475891, 0.0335577018558979, 0.0335102081298828, 0.0334626883268356, 0.0334153473377228, 0.0333680734038353, 0.0333208926022053, 0.0332737974822521, 0.0332268066704273, 0.03317990899086, 0.0331330858170986, 0.0330863818526268, 0.0330397710204124, 0.0329932309687138, 0.0329467989504337, 0.0329005271196365, 0.0328542962670326, 0.0328081473708153, 0.0327621102333069, 0.0327161513268948, 0.0326703041791916, 0.0326245203614235, 0.0325788483023643, 0.0325332842767239, 0.0324878022074699, 0.0324424840509892, 0.0323971509933472, 0.0323519930243492, 0.0323069021105766, 0.0322618670761585, 0.0322169698774815, 0.0321721620857716, 0.0321274250745773, 0.0320828147232533, 0.0320383086800575, 0.0319938287138939, 0.0319495126605034, 0.0319052785634995, 0.0318611674010754, 0.0318170934915543, 0.0317731611430645, 0.0317292660474777, 0.031685508787632, 0.0316418446600437, 0.0315982475876808, 0.0315547734498978, 0.0315113812685013, 0.0314680710434914, 0.0314249210059643, 0.0313817858695984, 0.0313387848436832, 0.0312958955764771, 0.0312530323863029, 0.031210333108902, 0.0311677139252424, 0.0311251617968082, 0.0310827326029539, 0.0310403984040022, 0.030998133122921, 0.0309559609740973, 0.0309139247983694, 0.0308719612658024, 0.0308301281183958, 0.0307883638888597, 0.0307466555386782, 0.0307050962001085, 0.0306635890156031, 0.0306221805512905, 0.0305808745324612, 0.0305396839976311, 0.0304985400289297, 0.0304575804620981, 0.0304166302084923, 0.0303758271038532, 0.030335109680891, 0.0302944481372833, 0.0302539188414812, 0.0302134696394205, 0.0301731154322624, 0.0301328487694263, 0.0300926864147186, 0.0300526600331068, 0.0300126448273659, 0.029972780495882, 0.0299330111593008, 0.0298933386802673, 0.0298537611961365, 0.0298142228275537, 0.0297748353332281, 0.0297355279326439, 0.029696287587285, 0.0296571850776672, 0.0296181216835976, 0.0295792073011398, 0.0295404549688101, 0.0295016393065453, 0.0294630788266659, 0.0294245053082705, 0.0293860379606485, 0.0293476693332195, 0.029309431090951, 0.0292712096124887, 0.0292331669479609, 0.0291952025145292, 0.0291573219001293, 0.0291195195168257, 0.0290818121284246, 0.029044246301055, 0.0290067289024591, 0.0289693512022495, 0.0289319958537817, 0.0288947932422161, 0.0288576576858759, 0.0288206189870834, 0.0287837143987417, 0.0287468098104, 0.0287100933492184, 0.0286734718829393, 0.028636921197176, 0.0286004487425089, 0.0285641029477119, 0.0285278093069792, 0.0284916236996651, 0.0284555610269308, 0.0284195654094219, 0.0283836908638477, 0.0283478442579508, 0.0283122193068266, 0.0282765477895737, 0.0282410141080618, 0.0282056704163551, 0.0281703379005194, 0.0281351041048765, 0.0280999653041363, 0.0280649457126856, 0.0280299689620733, 0.0279951263219118, 0.0279603656381369, 0.0279257148504257, 0.0278911311179399, 0.0278567224740982, 0.0278223305940628, 0.027788070961833, 0.0277538932859898, 0.0277197733521461, 0.0276858117431402, 0.0276518948376179, 0.0276180990040302, 0.0275843571871519, 0.0275507364422083, 0.0275172777473927, 0.0274838078767061, 0.0274504609405994, 0.0274172592908144, 0.0273841414600611, 0.027351051568985, 0.0273181516677141, 0.027285261079669, 0.0272524859756231, 0.0272198412567377, 0.0271872784942389, 0.0271548014134169, 0.0271223876625299, 0.0270901806652546, 0.0270579569041729, 0.0270258728414774, 0.026993865147233, 0.0269619412720203, 0.0269301403313875, 0.0268984511494637, 0.0268668234348297, 0.0268352665007114, 0.0268038045614958, 0.0267725177109241, 0.0267412625253201, 0.026710070669651, 0.0266790967434645, 0.0266481228172779, 0.0266172606498003, 0.0265864878892899, 0.0265558250248432, 0.0265252348035574, 0.026494737714529, 0.0264643747359514, 0.0264340378344059, 0.0264038518071175, 0.0263737719506025, 0.0263437926769257, 0.0263138636946678, 0.0262840315699577, 0.0262543335556984, 0.0262246765196323, 0.0261951424181461, 0.0261657014489174, 0.0261363685131073, 0.0261070914566517, 0.0260779932141304, 0.0260488670319319, 0.026019899174571, 0.0259911138564348, 0.0259622968733311, 0.0259336307644844, 0.0259050466120243, 0.025876559317112, 0.0258481223136187, 0.0258198473602533, 0.0257916301488876, 0.0257635097950697, 0.0257355086505413, 0.0257076006382704, 0.0256797764450312, 0.0256520733237267, 0.0256244279444218, 0.0255968738347292, 0.0255694463849068, 0.0255420804023743, 0.0255147982388735, 0.0254876390099525, 0.0254605617374182, 0.025433661416173, 0.0254067182540894, 0.0253799241036177, 0.0253532938659191, 0.0253266915678978, 0.0253001693636179, 0.0252737980335951, 0.0252474676817656, 0.0252212435007095, 0.0251951422542334, 0.0251690689474344, 0.0251431856304407, 0.0251173432916403, 0.0250916369259357, 0.0250659976154566, 0.0250404812395573, 0.0250149760395288, 0.0249896217137575, 0.024964390322566, 0.0249391570687294, 0.0249141156673431, 0.0248891264200211, 0.0248642507940531, 0.0248394925147295, 0.0248147770762444, 0.0247901268303394, 0.0247656963765621, 0.0247375387698412, 0.0247059445828199, 0.0246743746101856, 0.0246428269892931, 0.0246113352477551, 0.0245798677206039, 0.024548452347517, 0.0245170406997204, 0.0244856867939234, 0.0244543682783842, 0.0244230479001999, 0.0243918001651764, 0.0243605580180883, 0.0243293587118387, 0.0242981687188148, 0.0242670532315969, 0.0242359451949596, 0.0242048762738705, 0.0241738483309746, 0.0241428483277559, 0.024111894890666, 0.0240809340029955, 0.0240500438958406, 0.0240191575139761, 0.0239883325994015, 0.0239575244486332, 0.0239267516881227, 0.0238959956914186, 0.0238653216511011, 0.0238346606492996, 0.0238039921969175, 0.023773405700922, 0.0237428154796362, 0.0237122811377048, 0.0236817691475153, 0.0236513055860996, 0.0236208476126194, 0.0235904585570097, 0.0235601011663675, 0.0235297232866287, 0.0234994310885668, 0.0234691575169563, 0.0234389156103134, 0.0234086886048317, 0.0233785286545753, 0.0233483705669641, 0.0233182646334171, 0.0232881959527731, 0.023258151486516, 0.0232281479984522, 0.0231981314718723, 0.0231682155281305, 0.0231382884085178, 0.0231084283441305, 0.0230785701423883, 0.0230487622320652, 0.0230189710855484, 0.0229892320930958, 0.0229595005512238, 0.0229298379272223, 0.0229001939296722, 0.0228705648332834, 0.0228409878909588, 0.0228114239871502, 0.0227819290012121, 0.0227524247020483, 0.0227229837328196, 0.022693557664752, 0.0226641856133938, 0.0226348489522934, 0.0226054899394512, 0.0225762482732534, 0.0225469581782818, 0.0225177630782127, 0.0224885661154985, 0.0224594250321388, 0.0224302764981985, 0.0224011987447739, 0.0223721656948328, 0.0223431140184402, 0.02231415361166, 0.0222851745784283, 0.0222562812268734, 0.0222273543477058, 0.0221985280513763, 0.0221696719527245, 0.0221408810466528, 0.0221121553331614, 0.0220834147185087, 0.0220547448843718, 0.0220260433852673, 0.021997444331646, 0.0219688341021538, 0.0219402890652418, 0.0219117850065231, 0.0218832604587078, 0.0218548141419888, 0.02182637155056, 0.021797988563776, 0.0217696093022823, 0.0217413101345301, 0.0217129830271006, 0.0216847509145737, 0.0216564908623695, 0.0216283034533262, 0.0216001383960247, 0.0215720012784004, 0.0215439386665821, 0.0215158350765705, 0.0214878227561712, 0.0214598216116428, 0.0214318763464689, 0.0214039068669081, 0.0213760081678629, 0.0213481429964304, 0.0213203188031912, 0.0212925355881453, 0.0212647430598736, 0.0212370306253433, 0.0212092995643616, 0.0211816728115082, 0.0211540106683969, 0.0211263950914145, 0.0210988223552704, 0.0210712961852551, 0.0210438184440136, 0.0210163258016109, 0.0209889095276594, 0.0209614858031273, 0.0209341216832399, 0.0209067650139332, 0.0208794828504324, 0.0208521876484156, 0.0208249613642693, 0.0207977630198002, 0.020770575851202, 0.0207434426993132, 0.0207163244485855, 0.020689258351922, 0.0206621959805489, 0.0206352267414331, 0.020608214661479, 0.0205813013017178, 0.0205543786287308, 0.0205275174230337, 0.0205006506294012, 0.0204738304018974, 0.020447077229619, 0.0204203259199858, 0.0203936286270618, 0.0203669369220734, 0.0203402992337942, 0.0203136708587408, 0.0202871132642031, 0.0202605649828911, 0.0202340222895145, 0.0202075634151697, 0.0201811101287603, 0.0201547052711248, 0.0201283041387796, 0.0201019868254662, 0.020075649023056, 0.0200493708252907, 0.0200231410562992, 0.0199968926608562, 0.0199707373976707, 0.0199445467442274, 0.0199184603989124, 0.0198923517018557, 0.01986631937325, 0.0198402870446444, 0.0198143217712641, 0.019788371399045, 0.0197624322026968, 0.0197365749627352, 0.0197106916457415, 0.0196848902851343, 0.0196590814739466, 0.0196333546191454, 0.0196075923740864, 0.0195819400250912, 0.019556287676096, 0.0195306353271008, 0.0195050910115242, 0.0194794926792383, 0.0194539874792099, 0.0194284841418266, 0.0194030497223139, 0.0193775985389948, 0.0193522181361914, 0.019326850771904, 0.019301550462842, 0.0192762240767479, 0.0192509777843952, 0.0192257594317198, 0.0192005485296249, 0.0191754177212715, 0.0191502664238214, 0.0191251859068871, 0.0191001016646624, 0.0190750993788242, 0.019050071015954, 0.0190251246094704, 0.019000232219696, 0.0189752988517284, 0.0189504530280828, 0.0189256072044373, 0.0189008321613073, 0.0188760478049517, 0.018851337954402, 0.0188266206532717, 0.0188019722700119, 0.0187773238867521, 0.0187527369707823, 0.0187281761318445, 0.0187036097049713, 0.0186791513115168, 0.0186546444892883, 0.0186302270740271, 0.0186058171093464, 0.0185814741998911, 0.0185571368783712, 0.0185328219085932, 0.0185085665434599, 0.0184843055903912, 0.0184601247310638, 0.0184359382838011, 0.0184118114411831, 0.0183876808732748, 0.0183636490255594, 0.0183395780622959, 0.0183155946433544, 0.0182916186749935, 0.0182676762342453, 0.0182437859475613, 0.0182198770344257, 0.0181960724294186, 0.0181722436100245, 0.0181484781205654, 0.0181247256696224, 0.0181010328233242, 0.0180773623287678, 0.018053725361824, 0.0180301070213318, 0.0180065184831619, 0.0179829970002174, 0.0179594736546278, 0.0179360061883926, 0.017912533134222, 0.0178891606628895, 0.0178657807409763, 0.0178424213081598, 0.0178191307932138, 0.0177958123385906, 0.01777258887887, 0.0177493523806334, 0.0177262015640736, 0.0177030265331268, 0.0176799409091473, 0.0176568664610386, 0.0176338125020266, 0.0176107920706272, 0.0175877939909697, 0.0175648685544729, 0.0175419300794601, 0.0175190530717373, 0.0174961965531111, 0.0174733866006136, 0.0174506120383739, 0.0174278654158115, 0.0174051430076361, 0.0173824355006218, 0.0173598155379295, 0.0173371694982052, 0.0173145979642868, 0.0172920394688845, 0.0172695219516754, 0.0172470193356276, 0.0172245819121599, 0.0172021724283695, 0.0171797648072243, 0.0171574242413044, 0.0171350818127394, 0.01711281016469, 0.0170905217528343, 0.0170683301985264, 0.017046120017767, 0.0170239824801683, 0.0170018505305052, 0.016979768872261, 0.0169577114284039, 0.0169356744736433, 0.0169137082993984, 0.0168917197734118, 0.0168698076158762, 0.0168478935956955, 0.0168260671198368, 0.0168042294681072, 0.0167824365198612, 0.0167606882750988, 0.0167389437556267, 0.016717255115509, 0.0166955981403589, 0.0166739709675312, 0.0166523344814777, 0.0166308078914881, 0.0166092813014984, 0.016587782651186, 0.0165663305670023, 0.0165448766201735, 0.0165234860032797, 0.0165021102875471, 0.0164807923138142, 0.0164594706147909, 0.0164382234215736, 0.0164169669151306, 0.0163957923650742, 0.0163746066391468, 0.0163534935563803, 0.0163323953747749, 0.0163113139569759, 0.016290282830596, 0.016269264742732, 0.0162483248859644, 0.0162273589521646, 0.0162064861506224, 0.0161855891346931, 0.0161647759377956, 0.0161439757794142, 0.0161231942474842, 0.0161024685949087, 0.0160817224532366, 0.0160610843449831, 0.016040425747633, 0.0160198360681534, 0.0159992538392544, 0.0159787312150002, 0.0159582160413265, 0.0159377474337816, 0.0159173142164946, 0.0158968735486269, 0.0158765129745007, 0.0158561617136002, 0.0158358700573444, 0.0158155728131533, 0.0157953668385744, 0.0157751571387053, 0.0157549604773521, 0.0157348327338696, 0.0157147031277418, 0.0156946312636137, 0.0156745687127113, 0.0156545825302601, 0.0156346093863249, 0.0156146436929703, 0.0155947608873248, 0.015574861317873, 0.0155550055205822, 0.0155352028086782, 0.0155154252424836, 0.015495671890676, 0.015475963242352, 0.0154562620446086, 0.0154366213828325, 0.0154169825837016, 0.0153974248096347, 0.0153778847306967, 0.0153583604842424, 0.0153388828039169, 0.0153194339945912, 0.0153000168502331, 0.0152806350961328, 0.0152612719684839, 0.0152419311925769, 0.0152226574718952, 0.0152034256607294, 0.0151841919869184, 0.0151650076732039, 0.0151458624750376, 0.0151267386972904, 0.0151076493784785, 0.0150885982438922, 0.0150695564225316, 0.0150505872443318, 0.0150316404178739, 0.0150127131491899, 0.0149938184767962, 0.0149749526754022, 0.0149561399593949, 0.0149373486638069, 0.0149185843765736, 0.0148998601362109, 0.0148811768740416, 0.0148625215515494, 0.0148438988253474, 0.0148253114894032, 0.0148067362606525, 0.0147882094606757, 0.0147697292268276, 0.0147512573748827, 0.0147328050807118, 0.014714446850121, 0.0146960560232401, 0.0146777536720037, 0.0146594373509288, 0.0146411946043372, 0.0146229602396488, 0.0146047584712505, 0.0145866042003036, 0.0145684573799372, 0.0145503776147962, 0.0145322848111391, 0.0145142739638686, 0.0144962770864367, 0.0144783202558756, 0.0144603895023465, 0.0144424736499786, 0.0144246257841587, 0.0144067769870162, 0.014388982206583, 0.0143711883574724, 0.014353496953845, 0.0143357841297984, 0.0143181057646871, 0.0143004870042205, 0.0142828701063991, 0.0142653053626418, 0.0142477713525295, 0.0142302680760622, 0.0142127778381109, 0.0141953648999333, 0.0141779640689492, 0.0141605762764812, 0.0141432443633676, 0.0141259459778666, 0.0141086680814624, 0.0140914237126708, 0.014074225910008, 0.0140570569783449, 0.0140399076044559, 0.0140228057280183, 0.0140057383105159, 0.0139886634424329, 0.0139716695994139, 0.0139547102153301, 0.0139377573505044, 0.01392085198313, 0.0139039810746908, 0.0138871371746063, 0.0138703128322959, 0.013853557407856, 0.0138367889449, 0.0138200810179114, 0.013803412206471, 0.0137867657467723, 0.0137701518833637, 0.0137535659596324, 0.013737034983933, 0.0137205170467496, 0.0137040391564369, 0.0136875687167048, 0.0136711709201336, 0.0136547964066267, 0.0136384405195713, 0.0136221330612898, 0.0136058451607823, 0.0135895991697907, 0.0135733848437667, 0.013557193800807, 0.0135410204529762, 0.0135249448940158, 0.013508852571249, 0.0134927900508046, 0.013476780615747, 0.0134607926011086, 0.0134448371827602, 0.0134289162233472, 0.0134130418300629, 0.0133971627801657, 0.0133813563734293, 0.0133655769750476, 0.0133498199284077, 0.0133340964093804, 0.0133184194564819, 0.0133027695119381, 0.0132871326059103, 0.0132715441286564, 0.0132559966295958, 0.0132404686883092, 0.0132249491289258, 0.0132095217704773, 0.0131940916180611, 0.0131787052378058, 0.0131633607670665, 0.0131480162963271, 0.0131327277049422, 0.0131174642592669, 0.013102256692946, 0.0130870277062058, 0.0130718806758523, 0.0130545543506742, 0.0130353216081858, 0.0130160879343748, 0.0129968952387571, 0.0129777174443007, 0.0129585387185216, 0.0129393739625812, 0.012920250184834, 0.0129011264070868, 0.0128820156678557, 0.0128629440441728, 0.0128438621759415, 0.0128248054534197, 0.0128057757392526, 0.0127867609262466, 0.0127677442505956, 0.0127487555146217, 0.0127297947183251, 0.012710832990706, 0.012691886164248, 0.0126729784533381, 0.0126540577039123, 0.0126351648941636, 0.012616298161447, 0.0125974444672465, 0.0125785935670137, 0.0125597799196839, 0.0125409811735153, 0.0125221842899919, 0.0125033985823393, 0.0124846547842026, 0.0124659100547433, 0.0124471783638, 0.0124284895136952, 0.0124097857624292, 0.0123911099508405, 0.0123724462464452, 0.0123538123443723, 0.0123351886868477, 0.0123165659606457, 0.0122979851439595, 0.0122794043272734, 0.0122608365491033, 0.012242310680449, 0.012223782017827, 0.0122052561491728, 0.0121867693960667, 0.0121683096513152, 0.0121498368680477, 0.0121313780546188, 0.0121129732578993, 0.0120945544913411, 0.0120761496946216, 0.0120577858760953, 0.012039422057569, 0.0120210703462362, 0.0120027605444193, 0.0119844507426023, 0.0119661269709468, 0.0119478581473231, 0.0119296023622155, 0.0119113475084305, 0.0118931187316775, 0.0118749309331179, 0.0118567161262035, 0.0118385292589664, 0.0118203815072775, 0.0118022346869111, 0.0117841009050608, 0.0117659950628877, 0.0117479022592306, 0.0117298103868961, 0.0117117306217551, 0.011693705804646, 0.0116756670176983, 0.0116576422005892, 0.0116396583616734, 0.011621673591435, 0.0116037046536803, 0.0115857608616352, 0.0115678301081061, 0.0115498993545771, 0.0115319984033704, 0.0115141356363893, 0.0114962607622147, 0.0114783979952335, 0.0114605911076069, 0.0114427553489804, 0.0114249475300312, 0.0114071946591139, 0.0113894147798419, 0.0113716470077634, 0.0113539211452007, 0.0113362083211541, 0.0113184954971075, 0.0113008106127381, 0.0112831508740783, 0.0112654939293861, 0.0112478621304035, 0.0112302582710981, 0.0112126413732767, 0.0111950486898422, 0.0111774858087301, 0.0111599359661341, 0.0111423870548606, 0.0111248642206192, 0.0111073823645711, 0.0110898874700069, 0.0110724056139588, 0.0110549768432975, 0.0110375229269266, 0.0110200950875878, 0.0110027212649584, 0.0109853073954582, 0.0109679345041513, 0.0109505746513605, 0.010933255776763, 0.0109159229323268, 0.0108986040577292, 0.010881339199841, 0.0108640603721142, 0.010846795514226, 0.010829571634531, 0.0108123477548361, 0.0107951229438186, 0.0107779400423169, 0.0107607832178473, 0.0107436133548617, 0.0107264583930373, 0.0107093565165997, 0.0106922406703234, 0.0106751387938857, 0.0106580909341574, 0.0106410169973969, 0.0106239691376686, 0.0106069752946496, 0.0105899414047599, 0.0105729484930634, 0.0105559676885605, 0.0105390287935734, 0.0105220768600702, 0.0105051379650831, 0.0104882530868053, 0.0104713542386889, 0.0104544702917337, 0.0104376263916492, 0.0104207685217261, 0.0104039385914803, 0.0103871207684278, 0.0103703448548913, 0.0103535549715161, 0.0103367930278182, 0.010320071130991, 0.0103033361956477, 0.0102866133674979, 0.0102699333801866, 0.01025325153023, 0.0102365836501122, 0.0102199567481875, 0.0102033168077469, 0.0101866899058223, 0.0101700909435749, 0.0101535320281982, 0.010136959142983, 0.0101204002276063, 0.010103895328939, 0.0100873773917556, 0.0100708724930882, 0.0100544085726142, 0.0100379306823015, 0.0100214807316661, 0.0100050428882241, 0.00998864695429802, 0.00997223798185587, 0.00995584204792976, 0.00993949919939041, 0.00992314424365759, 0.00990680325776339, 0.00989051535725594, 0.0098742013797164, 0.00985791254788637, 0.00984165351837873, 0.00982540659606457, 0.00980917364358902, 0.0097929397597909, 0.0097767598927021, 0.00976056884974241, 0.00974438898265362, 0.00972826406359673, 0.00971212703734636, 0.00969600211828947, 0.00967991817742586, 0.00966382026672363, 0.00964775029569864, 0.00963169243186712, 0.00961567740887403, 0.00959964655339718, 0.00958363153040409, 0.00956766959279776, 0.00955169461667538, 0.00953573267906904, 0.00951981078833342, 0.00950389076024294, 0.00948798283934593, 0.00947210285812616, 0.00945623591542244, 0.00944036990404129, 0.00942452996969223, 0.00940873008221388, 0.00939291808754206, 0.00937712006270885, 0.00936136115342379, 0.00934560317546129, 0.00932985823601484, 0.00931414123624563, 0.00929843727499247, 0.00928274635225534, 0.00926707033067942, 0.00925143342465162, 0.00923578534275293, 0.00922014843672514, 0.00920456647872925, 0.00918897241353989, 0.00917338952422142, 0.00915784854441881, 0.0091423075646162, 0.00912676658481359, 0.00911126658320427, 0.00909579358994961, 0.00908030662685633, 0.00906483363360167, 0.00904941465705633, 0.00903398264199495, 0.00901857763528824, 0.00900319963693619, 0.00898782070726156, 0.00897244270890951, 0.00895711872726679, 0.00894179474562407, 0.00892648473381996, 0.0089111877605319, 0.0088959326967597, 0.00888066273182631, 0.00886540673673153, 0.00885020568966866, 0.00883498974144459, 0.00881978869438171, 0.00880461372435093, 0.00878945272415876, 0.00877430569380522, 0.00875918567180634, 0.0087440786883235, 0.00872897170484066, 0.00871389266103506, 0.00869885366410017, 0.00868380069732666, 0.00866876170039177, 0.00865375064313412, 0.00863876566290855, 0.00862378068268299, 0.00860882457345724, 0.00859388057142496, 0.00857893656939268, 0.00856401957571507, 0.00854914356023073, 0.00853425450623035, 0.00851937849074602, 0.00850455742329359, 0.00848972238600254, 0.00847489945590496, 0.00846010539680719, 0.00844532437622547, 0.00843055732548237, 0.00841581728309393, 0.00840109027922153, 0.00838636327534914, 0.00837166421115398, 0.00835700612515211, 0.00834233313798904, 0.00832766108214855, 0.00831304304301739, 0.00829843804240227, 0.00828382093459368, 0.00826925691217184, 0.00825467985123396, 0.00824012886732817, 0.00822559278458357, 0.00821109674870968, 0.00819657370448112, 0.00818209070712328, 0.00816763564944267, 0.00815318059176207, 0.00813873950392008, 0.00812432449311018, 0.00810993742197752, 0.00809553638100624, 0.00808117631822824, 0.00806682929396629, 0.00805248320102692, 0.00803816318511963, 0.0080238850787282, 0.00800959300249815, 0.0079953009262681, 0.00798106286674738, 0.00796683877706528, 0.00795260071754456, 0.00793840270489454, 0.00792421959340572, 0.00791004952043295, 0.00789589248597622, 0.00788176339119673, 0.00786764733493328, 0.00785353127866983, 0.00783944316208363, 0.00782538112252951, 0.00781131908297539, 0.00779728498309851, 0.00778326438739896, 0.00776925776153803, 0.00775526417419314, 0.00774131016805768, 0.00772734405472875, 0.00771339144557714, 0.00769947888329625, 0.00768558029085398, 0.00767168123275042, 0.00765781011432409, 0.00764396600425243, 0.00763010745868087, 0.00761629082262516, 0.00760248675942421, 0.00758869666606188, 0.00757490657269955, 0.00756117142736912, 0.00754742184653878, 0.00753368576988578, 0.00751999067142606, 0.00750630861148238, 0.00749262701719999, 0.00747895985841751, 0.00746533274650574, 0.00745169166475534, 0.00743807759135962, 0.00742450542747974, 0.00741091836243868, 0.00739735923707485, 0.00738381315022707, 0.00737029453739524, 0.00735677545890212, 0.00734328432008624, 0.00732982018962502, 0.00731635605916381, 0.00730291847139597, 0.00728948134928942, 0.00727607170119882, 0.00726266158744693, 0.00724929245188832, 0.00723593635484576, 0.0072225802578032, 0.00720926560461521, 0.00719596398994327, 0.00718264887109399, 0.00716937473043799, 0.00715612806379795, 0.00714286649599671, 0.00712963379919529, 0.007116440217942, 0.00710323359817266, 0.00709004141390324, 0.00707688881084323, 0.00706375064328313, 0.00705061201006174, 0.00703749991953373, 0.00702440226450562, 0.00701131764799356, 0.00699826097115874, 0.00698521686717868, 0.00697217416018248, 0.00695915799587965, 0.00694616790860891, 0.00693319225683808, 0.00692020310088992, 0.00690726796165109, 0.00689434632658958, 0.00688141118735075, 0.00686853099614382, 0.00685564987361431, 0.00684276968240738, 0.00682991603389382, 0.00681708985939622, 0.00680427672341466, 0.0067914635874331, 0.00677869142964482, 0.00676592020317912, 0.00675317458808422, 0.0067404299043119, 0.00672772480174899, 0.00671502063050866, 0.00670233089476824, 0.00668968027457595, 0.00667701661586761, 0.00666436739265919, 0.00665175775066018, 0.00663916254416108, 0.00662656687200069, 0.0066140117123723, 0.00660147052258253, 0.00658891443163157, 0.00657640025019646, 0.00656390003859997, 0.00655141286551952, 0.0065389396622777, 0.00652649300172925, 0.0065140463411808, 0.00650162808597088, 0.00648922147229314, 0.00647684372961521, 0.00646446505561471, 0.00645211338996887, 0.00643977615982294, 0.00642745103687048, 0.00641515478491783, 0.00640285713598132, 0.00639058696106076, 0.00637831818312407, 0.0063660885207355, 0.00635387236252427, 0.00634165713563561, 0.00632946845144033, 0.00631730724126101, 0.00630514556542039, 0.00629301182925701, 0.00628089159727097, 0.00626877089962363, 0.00625667721033096, 0.00624461099505424, 0.00623254384845495, 0.0062205046415329, 0.00620847987011075, 0.00619648117572069, 0.00618448248133063, 0.00617251126095653, 0.00616055307909846, 0.00614860979840159, 0.00613669212907553, 0.00612477539107203, 0.00611288519576192, 0.00610099546611309, 0.00608914624899626, 0.00607731146737933, 0.00606547528877854, 0.00605366704985499, 0.0060418713837862, 0.0060300906188786, 0.00601833639666438, 0.00600658217445016, 0.00599486893042922, 0.00598314218223095, 0.00597145594656467, 0.00595978228375316, 0.00594811048358679, 0.00593647826462984, 0.00592484604567289, 0.00591322779655457, 0.00590163702145219, 0.00589004484936595, 0.00587849458679557, 0.00586695736274123, 0.00585542060434818, 0.0058439108543098, 0.0058324015699327, 0.00582093186676502, 0.00580947566777468, 0.00579800689592957, 0.00578659260645509, 0.00577517785131931, 0.00576377613469958, 0.00575240235775709, 0.00574102811515331, 0.0057296808809042, 0.00571834808215499, 0.00570704182609916, 0.00569574860855937, 0.00568444235250354, 0.00567319057881832, 0.00566195184364915, 0.00565071403980255, 0.005639489274472, 0.00562829151749611, 0.00561710726469755, 0.00560595002025366, 0.00559479324147105, 0.00558366347104311, 0.00557253370061517, 0.00556144444271922, 0.00555036915466189, 0.00553929386660457, 0.00552824512124062, 0.00551719684153795, 0.00550618954002857, 0.00549558876082301, 0.00548528647050261, 0.00547498511150479, 0.00546470377594233, 0.00545446295291185, 0.00544420164078474, 0.00543396826833487, 0.00542377447709441, 0.00541356112807989, 0.00540336081758142, 0.00539319450035691, 0.00538303516805172, 0.00537288282066584, 0.00536275748163462, 0.00535263167694211, 0.00534252030774951, 0.00533241499215364, 0.00532235065475106, 0.00531227979809046, 0.00530221546068788, 0.00529218511655927, 0.00528216129168868, 0.00527215143665671, 0.00526216812431812, 0.00525215873494744, 0.00524219591170549, 0.00523223308846354, 0.00522231170907617, 0.00521236937493086, 0.0052024545148015, 0.00519255269318819, 0.00518267229199409, 0.00517279095947742, 0.00516294362023473, 0.00515308976173401, 0.00514325592666864, 0.00513344304636121, 0.00512363621965051, 0.00511382287368178, 0.00510405795648694, 0.00509429862722754, 0.00508455326780677, 0.00507480790838599, 0.00506509654223919, 0.00505537819117308, 0.00504568731412292, 0.00503600295633078, 0.00502633908763528, 0.00501668872311711, 0.00500703183934093, 0.00499740801751614, 0.00498780561611056, 0.00497820926830173, 0.0049686199054122, 0.0049590440467, 0.00494948867708445, 0.00493994727730751, 0.00493041193112731, 0.00492090452462435, 0.00491138966754079, 0.00490190228447318, 0.0048924284055829, 0.00488296849653125, 0.00487352814525366, 0.00486410176381469, 0.00485466886311769, 0.00484526949003339, 0.00483587710186839, 0.00482649076730013, 0.00481713283807039, 0.00480778096243739, 0.0047984360717237, 0.00478911772370338, 0.00477980729192495, 0.0047705234028399, 0.00476122600957751, 0.00475196912884712, 0.00474270572885871, 0.00473346235230565, 0.00472423946484923, 0.00471503008157015, 0.00470581464469433, 0.00469663925468922, 0.00468747038394213, 0.00467830896377563, 0.00466914707794785, 0.0046600392088294, 0.00465091178193688, 0.00464181136339903, 0.00463272398337722, 0.00462364358827472, 0.00461457716301084, 0.00460553774610162, 0.00459649786353111, 0.00458747893571854, 0.00457845954224467, 0.0045694806613028, 0.00456049619242549, 0.00455153081566095, 0.00454258639365435, 0.00453364150598645, 0.00452470406889915, 0.00451580667868257, 0.00450690975412726, 0.00449801934882998, 0.00448913592845201, 0.00448030000552535, 0.00447144359350204, 0.00446262117475271, 0.00445381924510002, 0.00444501079618931, 0.00443620840087533, 0.00442745396867394, 0.00441869301721454, 0.00440993113443255, 0.00440122419968247, 0.00439249677583575, 0.00438378984108567, 0.00437508337199688, 0.00436642998829484, 0.00435775704681873, 0.00434909760951996, 0.00434047216549516, 0.00433185324072838, 0.00432323385030031, 0.0043146563693881, 0.00430605746805668, 0.00429749302566051, 0.00428892904892564, 0.00428040511906147, 0.00427187420427799, 0.00426336377859116, 0.00425486080348492, 0.00424638437107205, 0.00423790095373988, 0.00422945199534297, 0.00422100303694606, 0.0042125741019845, 0.00420416612178087, 0.00419576419517398, 0.00418736226856709, 0.00417898781597614, 0.00417062686756253, 0.00416228687390685, 0.00415393942967057, 0.00414563249796629, 0.00413732603192329, 0.00412903307005763, 0.0041207536123693, 0.0041124876588583, 0.00410424172878265, 0.0040959962643683, 0.0040877778083086, 0.00407957332208753, 0.00407137488946319, 0.00406319042667747, 0.00405501294881105, 0.00404686899855733, 0.00403873901814222, 0.0040305950678885, 0.00402248557657003, 0.00401439564302564, 0.0040062996558845, 0.00399821670725942, 0.00399016821756959, 0.00398212624713778, 0.0039740982465446, 0.00396606931462884, 0.00395807530730963, 0.00395008036866784, 0.00394210685044527, 0.00393415288999677, 0.00392619194462895, 0.00391825241968036, 0.00391033897176385, 0.00390243297442794, 0.00389454676769674, 0.00388664053753018, 0.00387879577465355, 0.0038709370419383, 0.00386310555040836, 0.00385528057813644, 0.00384746259078383, 0.00383965112268925, 0.00383189436979592, 0.00382411712780595, 0.00381636014208198, 0.00380860338918865, 0.00380089390091598, 0.00379316415637732, 0.00378546840511262, 0.00377777917310596, 0.00377011019736528, 0.0037624416872859, 0.00375481392256916, 0.00374717242084444, 0.00373955094255507, 0.00373193668201566, 0.00372436293400824, 0.00371677591465414, 0.00370920868590474, 0.00370167568325996, 0.0036941294092685, 0.00368660967797041, 0.00367910391651094, 0.0036716116592288, 0.00366412615403533, 0.00365665438584983, 0.00364920287393034, 0.00364176486618817, 0.00363433384336531, 0.00362692959606647, 0.00361952558159828, 0.00361213507130742, 0.00360477878712118, 0.00359742203727365, 0.00359006528742611, 0.00358275650069118, 0.0035754272248596, 0.00356812495738268, 0.00356082967482507, 0.00355357490479946, 0.00354629987850785, 0.00353905162774026, 0.00353181757964194, 0.00352460355497897, 0.00351738929748535, 0.00351021625101566, 0.00350301573053002, 0.00349586294032633, 0.00348871666938066, 0.003481570398435, 0.0034744378644973, 0.00346733233891428, 0.00346024055033922, 0.00345315528102219, 0.00344608398154378, 0.00343903992325068, 0.00343198841437697, 0.00342496461234987, 0.00341795408166945, 0.00341095752082765, 0.00340396072715521, 0.00339699094183743, 0.00339004141278565, 0.00338309910148382, 0.00337616307660937, 0.00336925452575088, 0.00336234597489238, 0.00335545069538057, 0.0033485759049654, 0.00334171485155821, 0.00333487428724766, 0.00332804024219513, 0.00332120642997324, 0.003314413363114, 0.00330761331133544, 0.00330083374865353, 0.003294060472399, 0.00328731467016041, 0.00328058912418783, 0.00327384355477989, 0.00326713873073459, 0.00326045393012464, 0.00325375562533736, 0.00324708479456604, 0.00324043375439942, 0.00323379668407142, 0.0032271733507514, 0.00322054256685078, 0.00321395974606276, 0.00320736365392804, 0.00320079457014799, 0.00319423177279532, 0.00318768294528127, 0.00318114715628326, 0.00317464605905116, 0.00316813099198043, 0.00316164991818368, 0.00315514858812094, 0.00314870802685618, 0.00314224045723677, 0.00313581386581063, 0.00312939379364252, 0.00312298070639372, 0.00311657437123358, 0.00311021553352475, 0.0031038427259773, 0.00309748388826847, 0.00309113855473697, 0.0030848269816488, 0.00307850213721395, 0.0030722045339644, 0.00306592672131956, 0.00305965635925531, 0.00305339205078781, 0.00304716918617487, 0.00304093235172331, 0.00303470878861845, 0.00302849244326353, 0.00302233058027923, 0.00301613449119031, 0.00300997239537537, 0.0030038442928344, 0.00299770222045481, 0.00299157435074449, 0.00298547348938882, 0.00297939288429916, 0.00297330506145954, 0.00296724471263587, 0.00296119158156216, 0.00295515148900449, 0.00294912490062416, 0.00294313253834844, 0.00293711968697608, 0.00293113384395838, 0.00292517547495663, 0.00291923061013222, 0.00291327224113047, 0.0029073681216687, 0.00290144351311028, 0.00289553916081786, 0.00288964156061411, 0.00288379169069231, 0.0028779215645045, 0.0028720716945827, 0.00286624883301556, 0.00286043947562575, 0.00285462359897792, 0.00284884800203145, 0.00284305261448026, 0.00283730449154973, 0.0028315563686192, 0.00282582198269665, 0.00282008713111281, 0.00281438650563359, 0.00280869286507368, 0.00280301924794912, 0.00279734586365521, 0.00279170623980463, 0.00278605311177671, 0.0027804272249341, 0.00277482811361551, 0.00276922923512757, 0.00276363734155893, 0.00275806593708694, 0.00275252107530832, 0.00274698343127966, 0.00274144555442035, 0.00273594190366566, 0.00273043126799166, 0.00272494787350297, 0.00271947775036097, 0.00271400809288025, 0.00270857219584286, 0.0027031428180635, 0.00269771367311478, 0.00269231176935136, 0.00268692336976528, 0.00268154847435653, 0.00267617357894778, 0.00267083267681301, 0.00266550504602492, 0.00266017788089812, 0.00265486398711801, 0.00264958408661187, 0.0026442906819284, 0.00263902451843023, 0.00263377162627876, 0.00262853247113526, 0.0026233138050884, 0.00261808815412223, 0.00261291000060737, 0.00260771182365716, 0.00260254018940032, 0.0025973895099014, 0.00259225210174918, 0.00258710794150829, 0.00258200452663004, 0.00257689435966313, 0.00257181120105088, 0.0025667215231806, 0.00256167212501168, 0.00255662319250405, 0.0025515875313431, 0.00254656560719013, 0.00254156393930316, 0.0025365692563355, 0.00253160134889185, 0.00252662692219019, 0.00252167298458517, 0.00251673231832683, 0.00251182564534247, 0.00250690570101142, 0.00250200578011572, 0.00249713286757469, 0.00249226717278361, 0.00248740124516189, 0.00248258281499147, 0.00247775088064373, 0.00247292569838464, 0.00246813450939953, 0.00246335007250309, 0.00245856563560665, 0.00245380843989551, 0.00244907825253904, 0.00244434108026326, 0.00243961787782609, 0.00243492145091295, 0.00243023200891912, 0.00242555630393326, 0.00242089410312474, 0.0024162451736629, 0.00241161696612835, 0.00240698154084384, 0.00240239407867193, 0.00239778589457273, 0.00239321193657815, 0.00238865148276091, 0.00238410453312099, 0.00237955758348107, 0.00237504462711513, 0.00237052491866052, 0.00236603221856058, 0.00236154650337994, 0.00235708756372333, 0.00235261535272002, 0.00234817015007138, 0.00234374543651938, 0.00233934097923338, 0.00233492976985872, 0.00233055255375803, 0.00232616858556867, 0.00232181837782264, 0.00231747515499592, 0.00231314520351589, 0.00230880849994719, 0.00230451277457178, 0.00230022380128503, 0.00229594833217561, 0.00229167984798551, 0.00228744512423873, 0.00228319643065333, 0.00227897544391453, 0.00227477448061109, 0.00227058073505759, 0.00226638675667346, 0.00226223329082131, 0.00225807330571115, 0.00225394009612501, 0.00224981387145817, 0.00224570138379931, 0.00224159564822912, 0.00223751692101359, 0.00223345845006406, 0.00222938670776784, 0.00222534872591496, 0.00222132448107004, 0.00221729325130582, 0.00221329601481557, 0.00220931228250265, 0.00220534228719771, 0.0022013655398041, 0.00219742953777313, 0.00219350680708885, 0.00218957732431591, 0.00218567508272827, 0.0021817865781486, 0.00217791134491563, 0.00217402935959399, 0.00217020185664296, 0.00216635409742594, 0.00216253334656358, 0.00215870584361255, 0.00215493235737085, 0.0021511388476938, 0.00214737909846008, 0.00214362633414567, 0.00213988008908927, 0.00213614059612155, 0.00213244883343577, 0.00212874356657267, 0.00212505157105625, 0.00212136656045914, 0.00211772904731333, 0.0021140780299902, 0.00211044726893306, 0.00210683001205325, 0.00210322649218142, 0.00209963647648692, 0.00209607346914709, 0.00209251046180725, 0.00208895443938673, 0.00208542565815151, 0.00208191014826298, 0.00207838788628578, 0.00207489286549389, 0.002071418100968, 0.00206795707345009, 0.00206449627876282, 0.00206072279252112, 0.00205662380903959, 0.00205249758437276, 0.0020483850967139, 0.00204432662576437, 0.00204026838764548, 0.00203619664534926, 0.00203215191140771, 0.00202810717746615, 0.00202407594770193, 0.00202005845494568, 0.0020160679705441, 0.00201206374913454, 0.00200810050591826, 0.00200411025434732, 0.00200016028247774, 0.00199619703926146, 0.00199227454140782, 0.00198833853937685, 0.00198441580869257, 0.00198050681501627, 0.00197662506252527, 0.0019727295730263, 0.00196888856589794, 0.00196499307639897, 0.0019611653406173, 0.00195731082931161, 0.00195349659770727, 0.00194965559057891, 0.00194586871657521, 0.00194205471780151, 0.00193829508498311, 0.0019345082109794, 0.001930748578161, 0.00192697520833462, 0.00192325620446354, 0.00191951019223779, 0.00191580480895936, 0.00191208580508828, 0.00190840743016452, 0.00190470204688609, 0.0019010374089703, 0.00189739989582449, 0.00189373514149338, 0.00189007038716227, 0.00188644649460912, 0.0018828361062333, 0.00187922560144216, 0.00187561532948166, 0.00187204568646848, 0.00186846242286265, 0.00186490616761148, 0.00186136376578361, 0.00185780762694776, 0.00185426499228925, 0.00185074959881604, 0.00184724782593548, 0.00184374605305493, 0.00184027140494436, 0.00183678313624114, 0.00183330848813057, 0.00182986096478999, 0.00182642706204206, 0.00182297953870147, 0.00181958626490086, 0.00181615236215293, 0.00181275908835232, 0.00180936581455171, 0.00180599966552109, 0.00180262001231313, 0.00179926760029048, 0.00179591507185251, 0.00179260328877717, 0.00178926426451653, 0.00178596610203385, 0.00178264069836587, 0.00177938316483051, 0.00177608500234783, 0.00177282746881247, 0.00176954292692244, 0.00176632613874972, 0.00176308222580701, 0.00175986532121897, 0.00175664864946157, 0.00175345898605883, 0.00175024219788611, 0.00174707965925336, 0.00174390361644328, 0.00174075469840318, 0.00173759227618575, 0.00173447048291564, 0.00173133506905288, 0.00172824051696807, 0.00172514584846795, 0.00172203767579049, 0.0017189565114677, 0.0017158892005682, 0.00171282165683806, 0.00170978135429323, 0.00170674105174839, 0.00170372775755823, 0.00170068745501339, 0.00169768778141588, 0.001694728853181, 0.00169172917958349, 0.00168874335940927, 0.00168581155594438, 0.00168286613188684, 0.00167990732006729, 0.00167698902077973, 0.00167407083790749, 0.00167115265503526, 0.00166826171334833, 0.00166539778001606, 0.00166252045892179, 0.00165967002976686, 0.00165680621284992, 0.00165396940428764, 0.00165114633273333, 0.00164833664894104, 0.00164551357738674, 0.00164273113477975, 0.00163993507158011, 0.00163717975374311, 0.00163439731113613, 0.00163168273866177, 0.00162891368381679, 0.00162619911134243, 0.00162347115110606, 0.00162078358698636, 0.001618069014512, 0.00161539518740028, 0.00161272136028856, 0.00161006103735417, 0.00160740071441978, 0.00160476751625538, 0.0016021344345063, 0.00159952836111188, 0.0015968952793628, 0.00159430282656103, 0.00159172399435192, 0.00158915866632015, 0.00158657983411103, 0.00158404163084924, 0.0015815170481801, 0.0015789654571563, 0.00157642725389451, 0.00157394353300333, 0.00157143257092685, 0.00156894861720502, 0.00156646477989852, 0.00156402168795466, 0.0015615513548255, 0.00155910826288164, 0.00155669217929244, 0.00155427632853389, 0.00155184685718268, 0.00154945801477879, 0.00154708267655224, 0.00154469383414835, 0.00154234562069178, 0.00153997039888054, 0.00153762218542397, 0.00153530121315271, 0.0015329938614741, 0.00153065950144082, 0.00152839277870953, 0.00152607180643827, 0.00152380508370697, 0.00152152485679835, 0.0015192988794297, 0.00151703215669841, 0.00151480617932975, 0.00151256669778377, 0.00151038146577775, 0.00150816899258643, 0.00150598376058042, 0.00150378502439708, 0.0015016405377537, 0.00149946880992502, 0.00149733782745898, 0.00149517983663827, 0.00149308948311955, 0.00149095850065351, 0.00148886837996542, 0.0014867780264467, 0.00148470152635127, 0.00148261117283255, 0.00148056168109179, 0.00147851218935102, 0.00147648982238024, 0.00147445395123214, 0.00147244508843869, 0.00147043622564524, 0.00146845460403711, 0.00146648660302162, 0.00146450498141348, 0.001462536980398, 0.00146060960832983, 0.00145865499507636, 0.00145672762300819, 0.00145481387153268, 0.00145292724482715, 0.00145101349335164, 0.00144914037082344, 0.00144729448948056, 0.00144542136695236, 0.00144354847725481, 0.00144174322485924, 0.00143991073127836, 0.00143809209112078, 0.00143628683872521, 0.00143449520692229, 0.00143271719571203, 0.00143093906808645, 0.00142920180223882, 0.00142743729520589, 0.00142569991294295, 0.00142394914291799, 0.00142226601019502, 0.00142054224852473, 0.00141885911580175, 0.00141716259531677, 0.0014155067037791, 0.00141382368747145, 0.00141219492070377, 0.00141055264975876, 0.00140892388299108, 0.00140729511622339, 0.0014056934742257, 0.00140409194864333, 0.0014025173150003, 0.00140092929359525, 0.00139938213396817, 0.0013978211209178, 0.00139630096964538, 0.0013947538100183, 0.00139323365874588, 0.00139172689523548, 0.00139024760574102, 0.00138874084223062, 0.0013872750569135, 0.00138580915518105, 0.00138437037821859, 0.00138290459290147, 0.00138150656130165, 0.00138008128851652, 0.00137865624856204, 0.00137724459636956, 0.00137588742654771, 0.00137451651971787, 0.00137313210871071, 0.00137177482247353, 0.00137044466100633, 0.00136910087894648, 0.00136778433807194, 0.00136649492196739, 0.00136519188527018, 0.00136388884857297, 0.0013626265572384, 0.00136136426590383, 0.00136010197456926, 0.00135886680800468, 0.00135761813726276, 0.00135641021188349, 0.00135518866591156, 0.00135400774888694, 0.00135279982350767, 0.00135164614766836, 0.00135046523064375, 0.00134931155480444, 0.00134815787896514, 0.00134704494848847, 0.0013459047768265, 0.00134480535052717, 0.0013436924200505, 0.00134262011852115, 0.00134153431281447, 0.00134046201128513, 0.00133938970975578, 0.00133837177418172, 0.00133732659742236, 0.00133630866184831, 0.0013352771056816, 0.00133429991547018, 0.00133329548407346, 0.00133233179803938, 0.00133134098723531, 0.00133040442597121, 0.00132944085635245, 0.00132851779926568, 0.00132759485859424, 0.00132668553851545, 0.001325762597844, 0.00132488028611988, 0.00132399809081107, 0.00132314302027225, 0.00132228794973344, 0.0013214327627793, 0.00132059131283313, 0.00131977687124163, 0.00131896254606545, 0.0013181617250666, 0.0013173472834751, 0.00131657358724624, 0.0013158000074327, 0.00131505343597382, 0.0013143204851076, 0.00131356040947139, 0.00131282745860517, 0.00131213525310159, 0.00131142954342067, 0.00131072371732444, 0.00131005863659084, 0.00130938005167991, 0.00130872847512364, 0.00130806339439005, 0.00130743905901909, 0.0013068012194708, 0.00130619038827717, 0.00130556605290622, 0.00130499596707523, 0.00130439875647426, 0.00130384229123592, 0.00130325870122761, 0.00130272936075926, 0.0013021727791056, 0.00130165705922991, 0.00130114133935422, 0.00130063912365586, 0.00130012328736484, 0.00129964831285179, 0.00129917322192341, 0.00129872525576502, 0.00129825028125197, 0.00129782943986356, 0.00129739509429783, 0.0012969879899174, 0.00129655364435166, 0.0012961735483259, 0.0012957799481228, 0.00129541347268969, 0.00129503337666392, 0.00129469414241612, 0.00129435479175299, 0.00129402906168252, 0.0012936897110194, 0.00129340460989624, 0.00129311962518841, 0.00129282101988792, 0.00129252241458744, 0.00129229167941958, 0.00129203381948173, 0.00129177584312856, 0.00129155872855335, 0.00129134161397815, 0.00129111087881029, 0.00129092077258974, 0.00129074440337718, 0.00129056791774929, 0.00129037792794406, 0.00129024218767881, 0.00129010644741356, 0.00128997070714831, 0.00128986209165305, 0.0012897263513878, 0.00128964497707784, 0.00128954998217523, 0.00128948211204261, 0.00128940062131733, 0.00128937349654734, 0.00128930562641472, 0.00128927850164473, 0.00128923775628209, 0.00128925137687474, 0.00128923775628209, 0.00128925137687474, 0.00128926488105208, 0.00128931924700737, 0.00128934637177736, 0.00128941424190998, 0.00128945498727262, 0.00128956348635256, 0.00128963135648519, 0.00128973997198045, 0.00128984858747572, 0.00128997070714831, 0.00129009282682091, 0.00129024218767881, 0.0012903914321214, 0.00129056791774929, 0.00129073078278452, 0.0012909343931824, 0.00129112438298762, 0.00129132799338549, 0.00129153160378337, 0.00129178946372122, 0.00129202019888908, 0.00129227805882692, 0.00129254953935742, 0.00129282101988792, 0.00129309250041842, 0.00129340460989624, 0.00129371683578938, 0.00129402906168252, 0.00129436829593033, 0.00129469414241612, 0.00129504699725658, 0.00129541347268969, 0.00129580707289279, 0.0012961735483259, 0.00129656714852899, 0.00129697436932474, 0.00129740871489048, 0.00129781593568623, 0.00129827740602195, 0.00129871175158769, 0.00129918684251606, 0.00129963469225913, 0.00130015041213483, 0.0013006255030632, 0.00130114133935422, 0.00130164343863726, 0.00130218639969826, 0.0013027157401666, 0.00130327220540494, 0.00130381516646594, 0.00130441237706691, 0.00130498234648257, 0.00130557955708355, 0.00130619038827717, 0.0013068012194708, 0.0013074119342491, 0.00130806339439005, 0.00130871497094631, 0.00130938005167991, 0.00131003151182085, 0.00131072371732444, 0.00131141592282802, 0.00131213525310159, 0.00131282745860517, 0.00131356040947139, 0.00131429336033762, 0.00131505343597382, 0.0013158000074327, 0.00131657358724624, 0.0013173472834751, 0.0013181617250666, 0.0013189489254728, 0.0013197633670643, 0.00132061843760312, 0.0013214327627793, 0.00132226070854813, 0.00132314302027225, 0.00132402521558106, 0.00132488028611988, 0.00132578972261399, 0.00132668553851545, 0.00132758135441691, 0.00132851779926568, 0.00132945436052978, 0.00133040442597121, 0.00133134098723531, 0.00133231829386204, 0.00133330910466611, 0.00133428629487753, 0.00133530423045158, 0.00133629504125565, 0.00133734021801502, 0.00133835815358907, 0.00133941683452576, 0.00134046201128513, 0.00134154781699181, 0.0013426064979285, 0.00134370592422783, 0.00134480535052717, 0.00134591839741915, 0.00134703132789582, 0.00134817149955779, 0.00134931155480444, 0.0013504788512364, 0.00135163252707571, 0.001352813327685, 0.00135399424470961, 0.00135520217008889, 0.00135639659129083, 0.00135763175785542, 0.00135885330382735, 0.00136010197456926, 0.0013613507617265, 0.00136264017783105, 0.00136388884857297, 0.00136519188527018, 0.0013664677971974, 0.0013677979586646, 0.00136910087894648, 0.00137044466100633, 0.00137177482247353, 0.00137314561288804, 0.00137448927853256, 0.00137587380595505, 0.00137727183755487, 0.00137866986915469, 0.00138005428016186, 0.00138149294070899, 0.00138293160125613, 0.00138437037821859, 0.0013858227757737, 0.0013872750569135, 0.00138875446282327, 0.00139023398514837, 0.00139174051582813, 0.00139323365874588, 0.0013947538100183, 0.00139628734905273, 0.00139783474151045, 0.00139936851337552, 0.00140095653478056, 0.0014025173150003, 0.00140410545282066, 0.00140567997004837, 0.00140730862040073, 0.00140891026239842, 0.00141055264975876, 0.00141216779593378, 0.00141385081224144, 0.00141549308318645, 0.00141717621590942, 0.00141883210744709, 0.00142055586911738, 0.00142223876900971, 0.00142397615127265, 0.00142569991294295, 0.00142743729520589, 0.00142917467746884, 0.00143093906808645, 0.00143270357511938, 0.00143449520692229, 0.00143627321813256, 0.00143809209112078, 0.00143989734351635, 0.00144174322485924, 0.00144356186501682, 0.00144542136695236, 0.00144726724829525, 0.0014491539914161, 0.00145104061812162, 0.0014529136242345, 0.00145481387153268, 0.00145674124360085, 0.00145865499507636, 0.00146060960832983, 0.00146256398875266, 0.00146450498141348, 0.00146645936183631, 0.00146846822462976, 0.00147046346683055, 0.00147244508843869, 0.00147446745540947, 0.00147648982238024, 0.00147852580994368, 0.00148056168109179, 0.00148263841401786, 0.00148470152635127, 0.00148676463868469, 0.00148885475937277, 0.00149098574183881, 0.00149307586252689, 0.00149520684499294, 0.00149733782745898, 0.00149949593469501, 0.00150162691716105, 0.00150381214916706, 0.00150598376058042, 0.00150818261317909, 0.0015103678451851, 0.00151259393896908, 0.00151480617932975, 0.00151704566087574, 0.00151927175465971, 0.00152153836097568, 0.00152380508370697, 0.00152608542703092, 0.00152836553752422, 0.00153067288920283, 0.00153298047371209, 0.00153530121315271, 0.00153762218542397, 0.00153997039888054, 0.00154231849592179, 0.00154470733832568, 0.00154705555178225, 0.0015494714025408, 0.00155184685718268, 0.00155427632853389, 0.00155667879153043, 0.0015591352712363, 0.0015615785960108, 0.00156400806736201, 0.00156646477989852, 0.00156896223779768, 0.00157143257092685, 0.00157392991241068, 0.00157645449507982, 0.0015789654571563, 0.00158149003982544, 0.00158404163084924, 0.00158659345470369, 0.00158915866632015, 0.00159173761494458, 0.00159430282656103, 0.00159690889995545, 0.00159951474051923, 0.00160214805509895, 0.00160475389566272, 0.00160740071441978, 0.00161004741676152, 0.00161272136028856, 0.00161538168322295, 0.00161809625569731, 0.00162076996639371, 0.00162348453886807, 0.00162618572358042, 0.0016289409250021, 0.00163165549747646, 0.00163441081531346, 0.00163716613315046, 0.00163996207993478, 0.00164273113477975, 0.00164552696514875, 0.00164830940775573, 0.00165115972049534, 0.00165396940428764, 0.00165681971702725, 0.00165964290499687, 0.0016625338466838, 0.00166538415942341, 0.00166827533394098, 0.00167116627562791, 0.00167407083790749, 0.0016769755166024, 0.00167990732006729, 0.00168285262770951, 0.00168581155594438, 0.00168874335940927, 0.00169174280017614, 0.00169470184482634, 0.00169770128559321, 0.00170071457978338, 0.00170372775755823, 0.00170674105174839, 0.00170978135429323, 0.00171282165683806, 0.0017158892005682, 0.00171897013206035, 0.00172203767579049, 0.00172511872369796, 0.00172824051696807, 0.00173136231023818, 0.00173447048291564, 0.00173761928454041, 0.00174075469840318, 0.00174391712062061, 0.00174706615507603, 0.0017502693226561, 0.00175344536546618, 0.00175663502886891, 0.00175985170062631, 0.00176309561356902, 0.00176631251815706, 0.00176957005169243, 0.00177281396463513, 0.00177609862294048, 0.0017793697770685, 0.00178266793955117, 0.00178596610203385, 0.00178927788510919, 0.00179258966818452, 0.00179592857602984, 0.00179926760029048, 0.00180263363290578, 0.00180598604492843, 0.00180936581455171, 0.00181275908835232, 0.00181616586633027, 0.00181955902371556, 0.00182299315929413, 0.0018264134414494, 0.00182987458538264, 0.00183330848813057, 0.00183678313624114, 0.00184025790076703, 0.00184374605305493, 0.00184723420534283, 0.00185074959881604, 0.00185429223347455, 0.00185780762694776, 0.0018613365245983, 0.00186491978820413, 0.00186848943121731, 0.00187204568646848, 0.00187561532948166, 0.00187923922203481, 0.00188282248564065, 0.00188644649460912, 0.00189009762834758, 0.00189373514149338, 0.00189737265463918, 0.0019010374089703, 0.00190472917165607, 0.00190840743016452, 0.00191211281344295, 0.00191580480895936, 0.0019195235799998, 0.00192325620446354, 0.00192700233310461, 0.00193073495756835, 0.0019345082109794, 0.00193828146439046, 0.00194208195898682, 0.00194585521239787, 0.0019496827153489, 0.00195348309352994, 0.00195729709230363, 0.00196113833226264, 0.00196502008475363, 0.00196886132471263, 0.00197274307720363, 0.00197662506252527, 0.00198053405620158, 0.00198441580869257, 0.00198833853937685, 0.00199226103723049, 0.00199619703926146, 0.0020001467783004, 0.00200411025434732, 0.00200808700174093, 0.00201207748614252, 0.00201608147472143, 0.00202008546330035, 0.00202410318888724, 0.00202812068164349, 0.00203213817439973, 0.00203618290834129, 0.00204025488346815, 0.00204432662576437, 0.00204841210506856, 0.00205251108855009, 0.00205662380903959, 0.00206072279252112   }, 
   { 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.73896574753962e-07, 8.59954809584451e-07, 1.45104786497541e-06, 2.0512036371656e-06, 2.65337348537287e-06, 3.26359872815374e-06, 3.8768453123339e-06, 4.49915478384355e-06, 5.12649876327487e-06, 5.76089178139227e-06, 6.39830523141427e-06, 7.04578860677429e-06, 7.69830694480333e-06, 8.35384707897902e-06, 9.01844850886846e-06, 9.68607128015719e-06, 1.03617494460195e-05, 1.10364217107417e-05, 1.17261979539762e-05, 1.24159751067054e-05, 1.3115821275278e-05, 1.381969468639e-05, 1.45326321216999e-05, 1.52465754581499e-05, 1.5970588719938e-05, 1.669762423262e-05, 1.74337201315211e-05, 1.81718314706814e-05, 1.89190050150501e-05, 1.96671862795483e-05, 2.04284588107839e-05, 2.11887218029005e-05, 2.19620778807439e-05, 2.27354321395978e-05, 2.3517852241639e-05, 2.43032882281113e-05, 2.50987977779005e-05, 2.58963191299699e-05, 2.67039122263668e-05, 2.75135189440334e-05, 2.83311801467789e-05, 2.91528704110533e-05, 2.99826151604066e-05, 3.08204180328175e-05, 3.16582190862391e-05, 3.25050823448692e-05, 3.33589960064273e-05, 3.42149251082446e-05, 3.50819245795719e-05, 3.59499390469864e-05, 3.6826004361501e-05, 3.7711131881224e-05, 3.85982748412061e-05, 3.94944800063968e-05, 4.0391692891717e-05, 4.13009875046555e-05, 4.22092816734221e-05, 4.3130658013979e-05, 4.40520416304935e-05, 4.49834915343672e-05, 4.59169532405213e-05, 4.68604885099921e-05, 4.7804023779463e-05, 4.87616489408538e-05, 4.97172695759218e-05, 5.06859796587378e-05, 5.16556901857257e-05, 5.26334624737501e-05, 5.3615262004314e-05, 5.46061237400863e-05, 5.56000049982686e-05, 5.66029448236804e-05, 5.76068996451795e-05, 5.86199130339082e-05, 5.96359495830256e-05, 6.06630601396319e-05, 6.1692189774476e-05, 6.27313856966794e-05, 6.3769577536732e-05, 6.48208515485749e-05, 6.58741410006769e-05, 6.69354994897731e-05, 6.80008743074723e-05, 6.90743036102504e-05, 7.01477401889861e-05, 7.12342662154697e-05, 7.23217890481465e-05, 7.34193890821189e-05, 7.4519011832308e-05, 7.56297013140284e-05, 7.67454257584177e-05, 7.78631656430662e-05, 7.89899713709019e-05, 8.01197893451899e-05, 8.12586804386228e-05, 8.23975715320557e-05, 8.35495375213213e-05, 8.47025294206105e-05, 8.58655839692801e-05, 8.70306539582089e-05, 8.82047752384096e-05, 8.93819233169779e-05, 9.05691485968418e-05, 9.17563666007482e-05, 9.29556772462092e-05, 9.41569887800142e-05, 9.53643611865118e-05, 9.65757426456548e-05, 9.7799209470395e-05, 9.90236949292012e-05, 0.000100257231679279, 0.000101492783869617, 0.000102739424619358, 0.00010398706945125, 0.000105245773738716, 0.000106503481219988, 0.000107774285424966, 0.000109047105070204, 0.000110324945126195, 0.000111613873741589, 0.000112902802356984, 0.000114197770017199, 0.000115504808491096, 0.000116811868792865, 0.000118128991744015, 0.000119448122859467, 0.000120775308459997, 0.000122110563097522, 0.000123448829981498, 0.000124792117276229, 0.00012614147271961, 0.000127498875372112, 0.000128861312987283, 0.000130230793729424, 0.000131603286718018, 0.000132984860101715, 0.000134369431179948, 0.000135763097205199, 0.000137159760924987, 0.000138566509122029, 0.00013997325731907, 0.000141392069053836, 0.000142809891258366, 0.000144240795634687, 0.000145671714562923, 0.000147112688864581, 0.000148557679494843, 0.000150010746438056, 0.000151466825627722, 0.00015293198521249, 0.000154399138409644, 0.000155874353367835, 0.000157352580572478, 0.000158839888172224, 0.000160332230734639, 0.000161831616424024, 0.000163336022524163, 0.000164847486303188, 0.000166363985044882, 0.000167888560099527, 0.000169414110132493, 0.000170950748724863, 0.000172487387317233, 0.000174036118551157, 0.000175586843397468, 0.000177145659108646, 0.00017871250747703, 0.000180281364009716, 0.000181858282303438, 0.000183437223313376, 0.000185028242412955, 0.000186619261512533, 0.000188221340067685, 0.000189824437256902, 0.000191435610759072, 0.00019305179012008, 0.000194677049876191, 0.000196305321878754, 0.000197943663806655, 0.000199581001652405, 0.00020123143622186, 0.000202881856239401, 0.00020454237528611, 0.000206205877475441, 0.000207878474611789, 0.000209551042644307, 0.000211235717870295, 0.000212921382626519, 0.000214618135942146, 0.000216316897422075, 0.000218023720663041, 0.00021973556431476, 0.000221454465645365, 0.000223177383304574, 0.0002249093959108, 0.000226644406211562, 0.000228385455557145, 0.000230131554417312, 0.000231887708650902, 0.000233644881518558, 0.000235413128393702, 0.000237183397985063, 0.000238962704315782, 0.000240743029280566, 0.00024253546143882, 0.000244333903538063, 0.000246132345637307, 0.000247938849497586, 0.000249751406954601, 0.000251571997068822, 0.000253394653555006, 0.000255227321758866, 0.000257062027230859, 0.000258906802628189, 0.000260752596659586, 0.000262609421042725, 0.000264469330431893, 0.000266338262008503, 0.000268206204054877, 0.000270085205556825, 0.000271969242021441, 0.00027386037982069, 0.000275754457106814, 0.000277658633422107, 0.000279563857475296, 0.000281480111880228, 0.000283398374449462, 0.000285324756987393, 0.000287255097646266, 0.000289193529170007, 0.000291133968858048, 0.00029308648663573, 0.000295039004413411, 0.00029700159211643, 0.000298971252050251, 0.000300943909678608, 0.000302921573165804, 0.000304908346151933, 0.000306897098198533, 0.000308894959744066, 0.000310893810819834, 0.000312905729515478, 0.000314921693643555, 0.000316940655466169, 0.000318968697683886, 0.000320998777169734, 0.00032303886837326, 0.000325081055052578, 0.00032713427208364, 0.000329186470480636, 0.000331250746967271, 0.000333317089825869, 0.000335392425768077, 0.000337470846716315, 0.000339557271217927, 0.000341647741151974, 0.000343747291481122, 0.000345849839504808, 0.000347960478393361, 0.00035007408587262, 0.000352196802850813, 0.000354322488419712, 0.000356457283487543, 0.000358593068085611, 0.000360740959877148, 0.000362887803930789, 0.000365047773811966, 0.000367207743693143, 0.00036937979166396, 0.000371551810530946, 0.0003737339284271, 0.000375920062651858, 0.000378113269107416, 0.000380309444153681, 0.000382514728698879, 0.000384723040042445, 0.000386941363103688, 0.000389161781640723, 0.000391391222365201, 0.000393623660784215, 0.000395865208702162, 0.000398113741539419, 0.000400363322114572, 0.000402621953980997, 0.00040488364174962, 0.000407152343541384, 0.000409426109399647, 0.000411707878811285, 0.000413993693655357, 0.000416289607528597, 0.000418586510932073, 0.000420892465626821, 0.0004232055216562, 0.000425523554440588, 0.000427843595389277, 0.000430173735367134, 0.000432503875344992, 0.000434847112046555, 0.000437191338278353, 0.00043954563443549, 0.000441902957390994, 0.0004442693607416, 0.000446637743152678, 0.000449015205958858, 0.000451396714197472, 0.000453785265563056, 0.000456178851891309, 0.000458580470876768, 0.000460981100331992, 0.000463394797407091, 0.000465810502646491, 0.000468238344183192, 0.000470666185719892, 0.00047310400987044, 0.000475541892228648, 0.000477991852676496, 0.000480444839922711, 0.000482904899399728, 0.000485366908833385, 0.000487839075503871, 0.000490318227093667, 0.000492798397317529, 0.000495288637466729, 0.000497781904414296, 0.000500284251756966, 0.000502789567690343, 0.000505305011756718, 0.000507821445353329, 0.000510346901137382, 0.000512876431457698, 0.000515413994435221, 0.000517953594680876, 0.000520503264851868, 0.000523056893143803, 0.000525618670508265, 0.000528182368725538, 0.000530756253283471, 0.000533332116901875, 0.000535915954969823, 0.000538504915311933, 0.000541102839633822, 0.000543698843102902, 0.000546309922356158, 0.000548920012079179, 0.000551542150788009, 0.000554165337234735, 0.000556798535399139, 0.000559432781301439, 0.000562078144866973, 0.000564725429285318, 0.000567382900044322, 0.000570042233448476, 0.000572708726394922, 0.000575378246139735, 0.000578059873078018, 0.00058074138360098, 0.000583435059525073, 0.000586132693570107, 0.00058883341262117, 0.000591542164329439, 0.000594254001043737, 0.000596976780798286, 0.000599700666498393, 0.000602434563916177, 0.000605169567279518, 0.000607913476414979, 0.000610662566032261, 0.000613418640568852, 0.000616179720964283, 0.000618948950432241, 0.000621722138021141, 0.000624502368737012, 0.000627285626251251, 0.000630079011898488, 0.000632872339338064, 0.000635677773971111, 0.000638483208604157, 0.000641300692223012, 0.000644120271317661, 0.000646947766654193, 0.000649780442472547, 0.00065262004500255, 0.000655461801216006, 0.000658315548207611, 0.000661170342937112, 0.000664034159854054, 0.000666899024508893, 0.000669775879941881, 0.000672653841320425, 0.000675540824886411, 0.000678431824781001, 0.000681331963278353, 0.00068423297489062, 0.000687144172843546, 0.000690059328917414, 0.000692982517648488, 0.000695911876391619, 0.000698841118719429, 0.000701782526448369, 0.00070472591323778, 0.00070767936995253, 0.00071063480572775, 0.000713598274160177, 0.000716566864866763, 0.000719542498700321, 0.00072252209065482, 0.000725512858480215, 0.000728503568097949, 0.000731501320842654, 0.000734504079446197, 0.000737515918444842, 0.000740530842449516, 0.000743555778171867, 0.00074658275116235, 0.000749618804547936, 0.000752655789256096, 0.000755704881157726, 0.000758754031267017, 0.000761815172154456, 0.000764874450396746, 0.000767945661209524, 0.000771018909290433, 0.000774103275034577, 0.000777188688516617, 0.000780282134655863, 0.000783380586653948, 0.000786490098107606, 0.000789600657299161, 0.000792718201410025, 0.000795838830526918, 0.000798968423623592, 0.000802101218141615, 0.000805243907961994, 0.000808391720056534, 0.000811542558949441, 0.000814705505035818, 0.000817866355646402, 0.000821039313450456, 0.000824214250314981, 0.000827399373520166, 0.000830584380310029, 0.000833781552501023, 0.000836976687423885, 0.000840185966808349, 0.000843395129777491, 0.000846616399940103, 0.000849838776048273, 0.000853070057928562, 0.000856304483022541, 0.000859547988511622, 0.000862794404383749, 0.000866047979798168, 0.000869306561071426, 0.000872572127263993, 0.000875840778462589, 0.000879119441378862, 0.000882402178831398, 0.000885693007148802, 0.000888985814526677, 0.00089228869182989, 0.000895593548193574, 0.000898908532690257, 0.000902225496247411, 0.000905552471522242, 0.00090888055274263, 0.000912219635210931, 0.000915558834094554, 0.000918910081963986, 0.000922262202948332, 0.000925623578950763, 0.000928987807128578, 0.000932363152969629, 0.000935743562877178, 0.000939125020522624, 0.000942515500355512, 0.000945907959248871, 0.00094931258354336, 0.000952718139160424, 0.000956132775172591, 0.000959551485721022, 0.000962978112511337, 0.000966406892985106, 0.000969847722444683, 0.000973289599642158, 0.000976740382611752, 0.00098019337747246, 0.000983654404990375, 0.000987120321951807, 0.000990595435723662, 0.000994072528555989, 0.000997558701783419, 0.00100104778539389, 0.00100454606581479, 0.00100804527755827, 0.00101155752781779, 0.00101506989449263, 0.00101859122514725, 0.00102211569901556, 0.00102564808912575, 0.00102918455377221, 0.00102929933927953, 0.00102586764842272, 0.00102244794834405, 0.001019072602503, 0.00101577176246792, 0.00101245276164263, 0.00100920617114753, 0.00100599403958768, 0.00100280391052365, 0.00099966221023351, 0.000996560789644718, 0.000993511523120105, 0.000990462489426136, 0.000987483887001872, 0.000984523445367813, 0.000981619232334197, 0.000978713156655431, 0.000975895673036575, 0.000973096233792603, 0.000970335153397173, 0.000967573956586421, 0.000964919629041106, 0.000962279329542071, 0.000959631055593491, 0.000957063224632293, 0.000954535731580108, 0.000952038448303938, 0.000949551176745445, 0.000947126420214772, 0.000944760045967996, 0.000942423823289573, 0.000940081547014415, 0.000937801843974739, 0.00093559455126524, 0.00093338725855574, 0.00093120412202552, 0.00092908542137593, 0.000927007058635354, 0.000924942782148719, 0.000922936946153641, 0.000920963240787387, 0.000919013749808073, 0.000917126657441258, 0.000915263837669045, 0.000913451251108199, 0.000911644718144089, 0.00090990262106061, 0.000908200920093805, 0.000906535366084427, 0.000904869753867388, 0.000903292850125581, 0.000901730032637715, 0.000900225713849068, 0.000898703059647232, 0.000897271151188761, 0.000895869452506304, 0.00089451001258567, 0.000893146556336433, 0.000891857722308487, 0.00089062110055238, 0.000889370392542332, 0.00088818627409637, 0.00088705844245851, 0.00088592863176018, 0.000884857203345746, 0.000883832108229399, 0.000882849388290197, 0.000881864514667541, 0.000880954146850854, 0.000880074163433164, 0.000879234285093844, 0.000878410588484257, 0.000877643295098096, 0.000876924314070493, 0.000876229489222169, 0.000875550729688257, 0.000874942576047033, 0.000874368532095104, 0.000873802695423365, 0.000873301236424595, 0.000872854085173458, 0.000872423057444394, 0.000872016360517591, 0.000871659838594496, 0.000871357740834355, 0.0008710878319107, 0.000870807911269367, 0.000870614603627473, 0.000870453484822065, 0.000870332587510347, 0.000870209827553481, 0.000870161456987262, 0.00087015941971913, 0.000870197720360011, 0.00087022187653929, 0.000870332645718008, 0.000870459480211139, 0.000870626710820943, 0.000870842137373984, 0.000871097960043699, 0.000871353782713413, 0.000871681899297982, 0.000872056582011282, 0.000872457399964333, 0.00087285612244159, 0.00087334553245455, 0.000873865094035864, 0.000874424993526191, 0.000874968769494444, 0.000875601137522608, 0.00087628181790933, 0.000876986712682992, 0.000877691549248993, 0.000878468970768154, 0.00087929266737774, 0.000880158680956811, 0.000881024694535881, 0.000881945074070245, 0.00088292988948524, 0.000883892585989088, 0.000884933746419847, 0.000886015186551958, 0.000887112808413804, 0.000888266833499074, 0.000889451010152698, 0.00089069566456601, 0.000891940260771662, 0.000893233227543533, 0.000894584634806961, 0.000895968172699213, 0.0008973577641882, 0.00089881190797314, 0.000900306215044111, 0.000901832769159228, 0.000903383479453623, 0.000905000721104443, 0.000906656146980822, 0.00090829556575045, 0.000910021422896534, 0.000911781622562557, 0.000913582160137594, 0.000915380544029176, 0.000917251512873918, 0.00091917283134535, 0.000921116326935589, 0.000923059764318168, 0.000925075670238584, 0.000927140063140541, 0.000929244561120868, 0.000931349175516516, 0.00093352422118187, 0.000935719406697899, 0.000937950913794339, 0.000940230675041676, 0.000942552753258497, 0.00094489089678973, 0.000947299646213651, 0.000949724402744323, 0.00095220556249842, 0.000954686780460179, 0.000957240408752114, 0.000959826400503516, 0.000962452555540949, 0.000965082785114646, 0.000967793515883386, 0.000970526423770934, 0.000973291520494968, 0.000976066861767322, 0.000978920608758926, 0.000981814577244222, 0.000984742888249457, 0.000987675157375634, 0.000990659929811954, 0.000993713038042188, 0.000996770220808685, 0.000999879674054682, 0.00100302346982062, 0.00100622361060232, 0.00100940570700914, 0.00101267639547586, 0.00101598119363189, 0.00101929216179997, 0.00102266948670149, 0.00102608511224389, 0.00102953298483044, 0.00103298900648952, 0.00103652337566018, 0.0010400841711089, 0.00104367500171065, 0.00104729190934449, 0.00105097342748195, 0.00105469324626029, 0.00105844531208277, 0.0010622072732076, 0.00106604991015047, 0.00106991466600448, 0.00107377942185849, 0.001077716704458, 0.00108170020394027, 0.00108572619501501, 0.00108973390888423, 0.00109383219387382, 0.00109796680044383, 0.00110213179141283, 0.0011063045822084, 0.00111054396256804, 0.00111482152715325, 0.00111914949957281, 0.0011234674602747, 0.00112786598037928, 0.00113228859845549, 0.00113672518637031, 0.00114125467371196, 0.00114578206557781, 0.0011503315763548, 0.0011549616465345, 0.00115961779374629, 0.00116430420894176, 0.00116899877320975, 0.00117379194125533, 0.00117859127931297, 0.00118343869689852, 0.00118827831465751, 0.00119319837540388, 0.00119815673679113, 0.00120314920786768, 0.00120814982801676, 0.00121321284677833, 0.00121833442244679, 0.00122348812874407, 0.00122863159049302, 0.00123385596089065, 0.00123912026174366, 0.00124438479542732, 0.00124972162302583, 0.00125509081408381, 0.00126051646657288, 0.00126592582091689, 0.00127140793483704, 0.0012769220629707, 0.0012824583100155, 0.00128806324210018, 0.00129368610214442, 0.00129934737924486, 0.00130502472165972, 0.00131079251877964, 0.00131657265592366, 0.00132239691447467, 0.00132821733132005, 0.00133412820287049, 0.00134007132146508, 0.00134602258913219, 0.00135202216915786, 0.00135807611513883, 0.00136416219174862, 0.00137024035211653, 0.0013764169998467, 0.00138259993400425, 0.00138884712941945, 0.00139510247390717, 0.00140138994902372, 0.00140774995088577, 0.0014141402207315, 0.00142054061871022, 0.00142700539436191, 0.00143349426798522, 0.00144004356116056, 0.00144658901263028, 0.00145319860894233, 0.00145981449168175, 0.00146652688272297, 0.00147324951831251, 0.00148000020999461, 0.00148676102980971, 0.00149361859075725, 0.0015004820888862, 0.00150741206016392, 0.00151431793347001, 0.00152132252696902, 0.00152834306936711, 0.00153540598694235, 0.00154248310718685, 0.00154961831867695, 0.00155680009629577, 0.00156402215361595, 0.0015712259337306, 0.00157852040138096, 0.00158584525343031, 0.00159321422688663, 0.00160061148926616, 0.00160805089399219, 0.00161552266217768, 0.00162300060037524, 0.00163055886514485, 0.00163815950509161, 0.00164577213581651, 0.00165342912077904, 0.00166111439466476, 0.00166887417435646, 0.00167660170700401, 0.00168443191796541, 0.0016922983340919, 0.00170016882475466, 0.00170807167887688, 0.00171604671049863, 0.00172405631747097, 0.00173210410866886, 0.00174015376251191, 0.00174827384762466, 0.0017564264126122, 0.00176458701025695, 0.00177281198557466, 0.00178110937122256, 0.00178940477780998, 0.00179770821705461, 0.00180609431117773, 0.00181452068500221, 0.00182296510320157, 0.00183145795017481, 0.00183995882980525, 0.00184854015242308, 0.00185713171958923, 0.00186578370630741, 0.00187444558832794, 0.00188317208085209, 0.00189190451055765, 0.00190070539247245, 0.00190951058175415, 0.00191838201135397, 0.00192729150876403, 0.00193623546510935, 0.00194520154036582, 0.00195421604439616, 0.00196325243450701, 0.001972371712327, 0.00198146677576005, 0.00199065846391022, 0.00199983990751207, 0.002009087940678, 0.00201836018823087, 0.00202767876908183, 0.00203702156431973, 0.00204643048346043, 0.0020558456890285, 0.00206530932337046, 0.00207483116537333, 0.00208435114473104, 0.00209394353441894, 0.00210355198942125, 0.00211320072412491, 0.00212289625778794, 0.00213263346813619, 0.00214240327477455, 0.00215221126563847, 0.0021620390471071, 0.00217191549018025, 0.00218184827826917, 0.00219178106635809, 0.00220178836025298, 0.00221180776134133, 0.00222188560292125, 0.00223196321167052, 0.00224212976172566, 0.00225229607895017, 0.00226253503933549, 0.00227277399972081, 0.00228306720964611, 0.00229342491365969, 0.00230377656407654, 0.0023141885176301, 0.00232461281120777, 0.00233509740792215, 0.00234562624245882, 0.00235618324950337, 0.00236678286455572, 0.00237741461023688, 0.00238808430731297, 0.00239878846332431, 0.00240953103639185, 0.00242030760273337, 0.00243112235330045, 0.00244200183078647, 0.00245288899168372, 0.00246380874887109, 0.00247478671371937, 0.00248579285107553, 0.00249682529829443, 0.00250792200677097, 0.00251902686432004, 0.00253021251410246, 0.00254140421748161, 0.00255264388397336, 0.00256389356218278, 0.0025752242654562, 0.00258655869401991, 0.00259794760495424, 0.0026093686465174, 0.0026208299677819, 0.00263232341967523, 0.00264385528862476, 0.00265542161650956, 0.00266706012189388, 0.00267869676463306, 0.00269037554971874, 0.0027021027635783, 0.00271386839449406, 0.00272566615603864, 0.00273750396445394, 0.00274937436915934, 0.00276128435507417, 0.0027732434682548, 0.00278521049767733, 0.00279724155552685, 0.00280931126326323, 0.00282139680348337, 0.00283354101702571, 0.00284570106305182, 0.00285791349597275, 0.00287016248330474, 0.00288246595300734, 0.00289476872421801, 0.0029071606695652, 0.00291955261491239, 0.00293198693543673, 0.00294448109343648, 0.0029569857288152, 0.00296952249482274, 0.00298213004134595, 0.00299475318752229, 0.00300740078091621, 0.00302011496387422, 0.00303285126574337, 0.00304563948884606, 0.00305842817761004, 0.00307128927670419, 0.00308418250642717, 0.0030971139203757, 0.0031100797932595, 0.00312308594584465, 0.00313612446188927, 0.00314920069649816, 0.00316231162287295, 0.00317546050064266, 0.00318864383734763, 0.00320189562626183, 0.00321515137329698, 0.00322844344191253, 0.00324178789742291, 0.00325518450699747, 0.00326858321204782, 0.00328203849494457, 0.00329552381299436, 0.00330908177420497, 0.00332262553274632, 0.00333624193444848, 0.00334987230598927, 0.00336357508786023, 0.00337727786973119, 0.00339103722944856, 0.00340481288731098, 0.00341866072267294, 0.00343254092149436, 0.00344642880372703, 0.00346038164570928, 0.00347435637377203, 0.00348837953060865, 0.00350242853164673, 0.00351652409881353, 0.00353064411319792, 0.00354483025148511, 0.00355902058072388, 0.00357327936217189, 0.00358754186891019, 0.00360187329351902, 0.00361623871140182, 0.00363061227835715, 0.00364504824392498, 0.00365952448919415, 0.00367403519339859, 0.0036885857116431, 0.00370316673070192, 0.0037177880294621, 0.0037324414588511, 0.00374715123325586, 0.00376186100766063, 0.00377665949054062, 0.00379145820625126, 0.00380631280131638, 0.0038211839273572, 0.00383610930293798, 0.00385106704197824, 0.003866066923365, 0.00388109683990479, 0.00389616726897657, 0.00391128798946738, 0.00392644479870796, 0.00394160347059369, 0.00395683525130153, 0.00397210102528334, 0.00398740312084556, 0.00400433549657464, 0.00402300897985697, 0.00404169829562306, 0.00406054873019457, 0.00407941499724984, 0.00409837858751416, 0.00411745486781001, 0.00413661170750856, 0.00415584817528725, 0.00417515076696873, 0.00419456465169787, 0.00421405956149101, 0.00423365132883191, 0.00425327522680163, 0.00427301181480289, 0.00429286109283566, 0.00431274296715856, 0.00433275382965803, 0.00435282848775387, 0.00437300046905875, 0.00439325207844377, 0.00441358564421535, 0.00443399883806705, 0.00445447629317641, 0.0044750995002687, 0.00449575483798981, 0.00451650563627481, 0.0045373379252851, 0.00455829920247197, 0.00457929214462638, 0.00460038287565112, 0.00462155323475599, 0.00464283628389239, 0.0046641849912703, 0.00468558073043823, 0.0047071217559278, 0.00472871121019125, 0.00475039752200246, 0.00477216439321637, 0.00479404348880053, 0.00481597101315856, 0.00483799632638693, 0.00486011756584048, 0.00488225463777781, 0.00490456912666559, 0.00492693157866597, 0.0049493913538754, 0.00497189909219742, 0.00499451952055097, 0.00501722097396851, 0.00504001881927252, 0.00506286462768912, 0.00508582359179854, 0.00510886358097196, 0.00513198366388679, 0.00515521690249443, 0.00517848180606961, 0.00520189199596643, 0.00522533385083079, 0.0052488730289042, 0.00527250813320279, 0.00529620889574289, 0.005320037715137, 0.00534388283267617, 0.00536787323653698, 0.00539189530536532, 0.00541607895866036, 0.00544027844443917, 0.00546459062024951, 0.00548896752297878, 0.00551348924636841, 0.00553801096975803, 0.00556263001635671, 0.00558737711980939, 0.00561217311769724, 0.00563711300492287, 0.00566205428913236, 0.00568715576082468, 0.00571228982880712, 0.0057375687174499, 0.00576284807175398, 0.0057882396504283, 0.00581376068294048, 0.00583932967856526, 0.00586499506607652, 0.00589072611182928, 0.00591655261814594, 0.00594245968386531, 0.00596847990527749, 0.00599453272297978, 0.00602068146690726, 0.00604694336652756, 0.00607328535988927, 0.00609970884397626, 0.00612621242180467, 0.00615281192585826, 0.00617947662249207, 0.00620627030730247, 0.00623308029025793, 0.00626003416255116, 0.00628702156245708, 0.00631410535424948, 0.0063413018360734, 0.00636856211349368, 0.00639591971412301, 0.00642334157600999, 0.00645087659358978, 0.00647847540676594, 0.00650617061182857, 0.0065339314751327, 0.00656175566837192, 0.00658974191173911, 0.00661774398759007, 0.00664587458595634, 0.00667405361309648, 0.00670234533026814, 0.00673071807250381, 0.00675915507599711, 0.00678767263889313, 0.00681628612801433, 0.00684501323848963, 0.00687378877773881, 0.00690266024321318, 0.00693161273375154, 0.00696064624935389, 0.00698977569118142, 0.00701900199055672, 0.00704827671870589, 0.0070776641368866, 0.00710711628198624, 0.00713666481897235, 0.00716632651165128, 0.00719601986929774, 0.00722582638263702, 0.00725571298971772, 0.00728569692000747, 0.00731576094403863, 0.00734588969498873, 0.00737611437216401, 0.00740638840943575, 0.0074368235655129, 0.00746725825592875, 0.00749785406515002, 0.00752848200500011, 0.00755923893302679, 0.00759002799168229, 0.00762096233665943, 0.00765191251412034, 0.00768295954912901, 0.00771413557231426, 0.00774534372612834, 0.00777671253308654, 0.00780809810385108, 0.00783961266279221, 0.00787119101732969, 0.00790285039693117, 0.00793458987027407, 0.00796644203364849, 0.00799834355711937, 0.00803032424300909, 0.00806243531405926, 0.00809456128627062, 0.00812684930860996, 0.00815918575972319, 0.00819161720573902, 0.00822408311069012, 0.00825670827180147, 0.00828936696052551, 0.00832212157547474, 0.00835497211664915, 0.00838788878172636, 0.00842093303799629, 0.00845401082187891, 0.00848723202943802, 0.00852047093212605, 0.0085538225248456, 0.00858726911246777, 0.00862076506018639, 0.00865439046174288, 0.00868806336075068, 0.00872186478227377, 0.00875569973140955, 0.00878966227173805, 0.00882365833967924, 0.00885779783129692, 0.00889198761433363, 0.00892625749111176, 0.00896063819527626, 0.00899506919085979, 0.00902964454144239, 0.00906423572450876, 0.009098956361413, 0.00913374032825232, 0.00916862301528454, 0.00920356810092926, 0.00923864357173443, 0.00927375070750713, 0.0093089547008276, 0.00934423878788948, 0.0093796206638217, 0.00941509660333395, 0.00945065543055534, 0.00948629528284073, 0.00952199753373861, 0.00955781433731318, 0.00959367770701647, 0.00962965562939644, 0.00966571271419525, 0.00970183499157429, 0.00973808579146862, 0.00977438502013683, 0.00981081370264292, 0.00984725821763277, 0.00988384708762169, 0.0099205020815134, 0.00995720271021128, 0.0099940337240696, 0.0100309299305081, 0.0100679378956556, 0.0101049933582544, 0.0101421643048525, 0.0101793818175793, 0.0102167278528214, 0.0102541390806437, 0.0102915987372398, 0.0103292195126414, 0.010366840288043, 0.0104046370834112, 0.0104424506425858, 0.010480378754437, 0.0105183692649007, 0.0105564733967185, 0.010594641789794, 0.0106328902766109, 0.0106712197884917, 0.0107096461579204, 0.0107481526210904, 0.0107867391780019, 0.0108254225924611, 0.0108641870319843, 0.010903031565249, 0.0109419571235776, 0.0109809963032603, 0.0110200680792332, 0.0110592506825924, 0.0110985459759831, 0.0111378906294703, 0.0111773321405053, 0.0112168537452817, 0.0112564712762833, 0.0112961549311876, 0.0113359503448009, 0.0113757941871881, 0.0114157497882843, 0.0114557715132833, 0.0114958733320236, 0.0115361036732793, 0.0115763507783413, 0.0116167590022087, 0.0116571821272373, 0.0116977356374264, 0.0117383524775505, 0.0117790987715125, 0.0118198441341519, 0.0118606872856617, 0.0119016915559769, 0.0119427284225821, 0.0119838770478964, 0.0120250741019845, 0.0120663838461041, 0.012107758782804, 0.0121492464095354, 0.0121907964348793, 0.0122323976829648, 0.0122741423547268, 0.0123159363865852, 0.0123578421771526, 0.0123997963964939, 0.0124418800696731, 0.0124840112403035, 0.0125262401998043, 0.0125685334205627, 0.0126109393313527, 0.0126534244045615, 0.0126959914341569, 0.0127386869862676, 0.0127813834697008, 0.0128242233768106, 0.0128671126440167, 0.0129101136699319, 0.0129531640559435, 0.0129963429644704, 0.0130395861342549, 0.0130828786641359, 0.0131263313814998, 0.0131697999313474, 0.0132133979350328, 0.0132570443674922, 0.0133008202537894, 0.0133446427062154, 0.013388579711318, 0.0134325474500656, 0.0134766455739737, 0.0135208396241069, 0.013565082103014, 0.0136094521731138, 0.0136538399383426, 0.0136983878910542, 0.0137429693713784, 0.013787679374218, 0.0138324042782187, 0.0138772428035736, 0.01392219401896, 0.0139671936631203, 0.0140123218297958, 0.0140574825927615, 0.0141027895733714, 0.0141481272876263, 0.0141935618594289, 0.0142390923574567, 0.0142847048118711, 0.0143303973600268, 0.0143761541694403, 0.0144220553338528, 0.0144679732620716, 0.0145140523090959, 0.0145601313561201, 0.0146063715219498, 0.0146526284515858, 0.0146990139037371, 0.0147454626858234, 0.0147920092567801, 0.0148386200889945, 0.0148853436112404, 0.0149321155622602, 0.0149790085852146, 0.0150259807705879, 0.0150730106979609, 0.0151201449334621, 0.0151673601940274, 0.015214647166431, 0.0152620561420918, 0.0153095377609134, 0.0153570817783475, 0.0154047086834908, 0.0154524622485042, 0.0155002493411303, 0.0155481416732073, 0.0155961122363806, 0.0156441815197468, 0.0156923141330481, 0.0157405361533165, 0.015788871794939, 0.0158372558653355, 0.0158857591450214, 0.0159343183040619, 0.0159829836338758, 0.0160317122936249, 0.0160805471241474, 0.0161294545978308, 0.0161784254014492, 0.0162275172770023, 0.0162766817957163, 0.0163259357213974, 0.0163752511143684, 0.0164246670901775, 0.0164741761982441, 0.016523752361536, 0.0165734309703112, 0.0166231598705053, 0.0166730172932148, 0.0167229082435369, 0.0167729519307613, 0.0168230086565018, 0.0168732106685638, 0.0169234573841095, 0.0169738288968801, 0.0170242246240377, 0.0170747265219688, 0.0171253494918346, 0.0171760134398937, 0.0172267965972424, 0.017277654260397, 0.017328605055809, 0.0173795986920595, 0.0174307208508253, 0.0174818988889456, 0.0175331756472588, 0.0175845306366682, 0.0176359657198191, 0.0176875162869692, 0.0177390947937965, 0.0177908390760422, 0.0178425889462233, 0.0178944766521454, 0.0179464109241962, 0.0179984588176012, 0.0180505644530058, 0.0181027576327324, 0.0181550811976194, 0.0182074271142483, 0.0182599108666182, 0.0183124262839556, 0.018365079537034, 0.0184177719056606, 0.0184706021100283, 0.0185234472155571, 0.0185764078050852, 0.0186294540762901, 0.0186825897544622, 0.0187358297407627, 0.0187891032546759, 0.0188425201922655, 0.0188959706574678, 0.0189495552331209, 0.01900315284729, 0.0190568938851357, 0.0191107131540775, 0.019164590165019, 0.0192186050117016, 0.0192726515233517, 0.0193268191069365, 0.0193810407072306, 0.0194353852421045, 0.0194897521287203, 0.019544268026948, 0.0195988230407238, 0.0196534711867571, 0.0197082106024027, 0.0197630226612091, 0.0198179464787245, 0.0198729410767555, 0.0199280213564634, 0.0199831873178482, 0.0200384501367807, 0.0200937762856483, 0.0201491694897413, 0.0202046893537045, 0.0202602650970221, 0.0203159544616938, 0.0203716866672039, 0.0204275362193584, 0.0204834416508675, 0.0205394960939884, 0.0205955561250448, 0.0206517372280359, 0.0207079965621233, 0.0207643453031778, 0.0208207871764898, 0.0208772737532854, 0.0209339000284672, 0.0209905803203583, 0.0210473630577326, 0.0211041979491711, 0.0211611427366734, 0.0212181694805622, 0.0212752781808376, 0.0213324744254351, 0.0213897414505482, 0.0214471071958542, 0.0215045623481274, 0.0215621031820774, 0.0216196943074465, 0.0216773971915245, 0.0217351894825697, 0.0217930302023888, 0.0218510162085295, 0.0219090096652508, 0.0219671577215195, 0.0220253672450781, 0.0220836587250233, 0.0221420228481293, 0.0222005099058151, 0.022259034216404, 0.0223176386207342, 0.0223763752728701, 0.0224351901561022, 0.0224940776824951, 0.0225530285388231, 0.0226120930165052, 0.0226712319999933, 0.0227304492145777, 0.022789740934968, 0.0228491500020027, 0.0229086112231016, 0.022968165576458, 0.0230278205126524, 0.0230875294655561, 0.0231473688036203, 0.0232072323560715, 0.0232672467827797, 0.02332728728652, 0.0233874637633562, 0.02344767190516, 0.0235080160200596, 0.0235684122890234, 0.0236288923770189, 0.0236894898116589, 0.0237501356750727, 0.0238108914345503, 0.0238747205585241, 0.0239417273551226, 0.0240087676793337, 0.0240759383887053, 0.0241432040929794, 0.0242105647921562, 0.0242780260741711, 0.0243455488234758, 0.0244132168591022, 0.0244809333235025, 0.0245487634092569, 0.0246166735887527, 0.0246846973896027, 0.0247528478503227, 0.0248210001736879, 0.0248893294483423, 0.0249577239155769, 0.0250261966139078, 0.0250947996973991, 0.0251634679734707, 0.02523223310709, 0.0253010932356119, 0.0253700669854879, 0.0254391059279442, 0.0255082547664642, 0.025577487424016, 0.0256468616425991, 0.025716258212924, 0.0257857944816351, 0.0258554089814425, 0.0259251277893782, 0.0259949546307325, 0.0260648299008608, 0.0261348336935043, 0.0262049175798893, 0.0262751337140799, 0.026345394551754, 0.0264157876372337, 0.0264862421900034, 0.026556795462966, 0.0266274753957987, 0.0266982074826956, 0.0267690662294626, 0.0268399883061647, 0.0269110258668661, 0.0269821565598249, 0.027053402736783, 0.0271247141063213, 0.0271961335092783, 0.0272676218301058, 0.0273392535746098, 0.0274109188467264, 0.0274827107787132, 0.0275546163320541, 0.0276266038417816, 0.0276986230164766, 0.0277708172798157, 0.0278430953621864, 0.0279154516756535, 0.0279878880828619, 0.0280604232102633, 0.0281330533325672, 0.0282058138400316, 0.0282786209136248, 0.0283515583723783, 0.0284245442599058, 0.0284976586699486, 0.0285709016025066, 0.0286441929638386, 0.0287175811827183, 0.0287910811603069, 0.0288646295666695, 0.0289383083581924, 0.029012069106102, 0.0290859546512365, 0.0291599407792091, 0.0292339567095041, 0.029308132827282, 0.029382361099124, 0.0294566825032234, 0.0295311193913221, 0.0296056494116783, 0.0296802800148726, 0.0297549571841955, 0.0298297945410013, 0.0299047138541937, 0.029979694634676, 0.0300547927618027, 0.030129985883832, 0.03020522557199, 0.03028061427176, 0.0303560774773359, 0.0304316580295563, 0.0305072851479053, 0.0305830575525761, 0.0306589268147945, 0.030734846368432, 0.0308108925819397, 0.0308870021253824, 0.0309632420539856, 0.0310395639389753, 0.031115947291255, 0.0311924777925014, 0.0312690734863281, 0.0313457772135735, 0.0314225666224957, 0.0314994342625141, 0.031576432287693, 0.0316535122692585, 0.0317306667566299, 0.0318079069256783, 0.031885277479887, 0.0319627374410629, 0.0320402532815933, 0.0321179106831551, 0.0321956500411034, 0.0322734825313091, 0.0323513969779015, 0.0324293933808804, 0.0325075350701809, 0.0325857400894165, 0.0326640121638775, 0.0327424071729183, 0.0328209064900875, 0.0328994803130627, 0.0329781733453274, 0.0330569371581078, 0.033135786652565, 0.0332147665321827, 0.0332938097417355, 0.0333729349076748, 0.0334521904587746, 0.0335315391421318, 0.0336109846830368, 0.033690482378006, 0.0337701179087162, 0.0338498391211033, 0.0339296236634254, 0.0340095534920692, 0.0340895429253578, 0.0341696366667747, 0.0342498049139977, 0.0343300886452198, 0.03441047295928, 0.0344909206032753, 0.0345714911818504, 0.0346521586179733, 0.0347328968346119, 0.0348137579858303, 0.0348946899175644, 0.0349757298827171, 0.0350568480789661, 0.0351380705833435, 0.0352194011211395, 0.0353007949888706, 0.0353823192417622, 0.0354639254510403, 0.0355456285178661, 0.0356273949146271, 0.0357092879712582, 0.0357912667095661, 0.03587331995368, 0.0359554886817932, 0.0360377579927444, 0.0361201018095016, 0.0362025573849678, 0.0362851023674011, 0.0363677553832531, 0.0364504680037498, 0.0365333147346973, 0.0366162247955799, 0.0366992130875587, 0.0367823503911495, 0.0368655659258366, 0.0369488783180714, 0.03703223913908, 0.0371157489717007, 0.0371993146836758, 0.0372829847037792, 0.0373667664825916, 0.0374506264925003, 0.0375345833599567, 0.0376186370849609, 0.0377027876675129, 0.0377870313823223, 0.0378713607788086, 0.0379557870328426, 0.0380403101444244, 0.0381249450147152, 0.038209643214941, 0.0382944531738758, 0.0383793599903584, 0.0384643338620663, 0.038549430668354, 0.0386346317827702, 0.0387198925018311, 0.0388052873313427, 0.0388907566666603, 0.038976326584816, 0.0390619933605194, 0.0391477197408676, 0.0392335839569569, 0.0393195003271103, 0.0394055545330048, 0.0394916720688343, 0.0395779013633728, 0.0396641902625561, 0.0397506207227707, 0.0398371331393719, 0.039923720061779, 0.0400104150176048, 0.0400972217321396, 0.04018409922719, 0.0402710549533367, 0.0403581485152245, 0.0404453128576279, 0.0405325554311275, 0.0406199283897877, 0.0407073833048344, 0.0407949015498161, 0.0408825501799583, 0.040970291942358, 0.0410581193864346, 0.0411460362374783, 0.04123405367136, 0.0413221716880798, 0.0414103642106056, 0.0414986833930016, 0.0415870770812035, 0.0416755303740501, 0.041764110326767, 0.0418527871370316, 0.0419415794312954, 0.0420304350554943, 0.0421193838119507, 0.0422084517776966, 0.0422975942492485, 0.0423868373036385, 0.0424761772155762, 0.042565580457449, 0.0426551252603531, 0.0427447371184826, 0.0428344644606113, 0.0429242551326752, 0.043014157563448, 0.0431041717529297, 0.0431942343711853, 0.0432844273746014, 0.0433747172355652, 0.0434650853276253, 0.0435555726289749, 0.0436461307108402, 0.0437367931008339, 0.0438275188207626, 0.0439183712005615, 0.0440093204379082, 0.0441003516316414, 0.0441914759576321, 0.0442827008664608, 0.0443740226328373, 0.0444654226303101, 0.0445569157600403, 0.0446485430002213, 0.0447402186691761, 0.0448320060968399, 0.0449238903820515, 0.045015886425972, 0.0451079308986664, 0.045200128108263, 0.0452923625707626, 0.0453847348690033, 0.0454771816730499, 0.0455697290599346, 0.0456623658537865, 0.0457550920546055, 0.0458479076623917, 0.0459408536553383, 0.0460338369011879, 0.0461269579827785, 0.0462201498448849, 0.0463134832680225, 0.0464068502187729, 0.0465003252029419, 0.0465939380228519, 0.0466875918209553, 0.0467813946306705, 0.0468752309679985, 0.0469691902399063, 0.0470632500946522, 0.0471574030816555, 0.0472516268491745, 0.0473459586501122, 0.0474404022097588, 0.0475349351763725, 0.0476295426487923, 0.047724261879921, 0.0478190593421459, 0.0479139573872089, 0.0480089373886585, 0.0481040552258492, 0.0481992289423943, 0.0482945144176483, 0.0483898743987083, 0.0484853535890579, 0.048580925911665, 0.0486765615642071, 0.048772320151329, 0.0488681606948376, 0.0489640906453133, 0.0490601323544979, 0.0491562709212303, 0.049252487719059, 0.0493488050997257, 0.0494452156126499, 0.0495417416095734, 0.0496383085846901, 0.0497350133955479, 0.0498318113386631, 0.0499286912381649, 0.0500256456434727, 0.0501227378845215, 0.0502199083566666, 0.0503171570599079, 0.0504145212471485, 0.0505119934678078, 0.0506094843149185, 0.0507071539759636, 0.0508048869669437, 0.0509026981890202, 0.0510006099939346, 0.0510986484587193, 0.0511967465281487, 0.0512949340045452, 0.0513932481408119, 0.0514916554093361, 0.0515901148319244, 0.0516887009143829, 0.0517873838543892, 0.051886148750782, 0.0519849918782711, 0.0520839840173721, 0.0521830208599567, 0.0522821731865406, 0.0523814000189304, 0.0524807460606098, 0.052580151706934, 0.0526796914637089, 0.0527793280780315, 0.052879024296999, 0.0529788322746754, 0.0530787445604801, 0.0531787313520908, 0.0532788299024105, 0.0533790178596973, 0.053479291498661, 0.0535796657204628, 0.0536801218986511, 0.0537806898355484, 0.0538813546299934, 0.0539820678532124, 0.0540829263627529, 0.05418386682868, 0.0542849153280258, 0.054386030882597, 0.0544872619211674, 0.054588571190834, 0.0546899773180485, 0.054791484028101, 0.0548930950462818, 0.0549947768449783, 0.0550965704023838, 0.0551984757184982, 0.0553004257380962, 0.0554024949669838, 0.0555046573281288, 0.0556069351732731, 0.0557092763483524, 0.0558117106556892, 0.0559142827987671, 0.0560169145464897, 0.0561196394264698, 0.0562224797904491, 0.0563253834843636, 0.0564283989369869, 0.0565314963459969, 0.056634709239006, 0.0567380003631115, 0.0568414032459259, 0.0569448731839657, 0.0570484697818756, 0.0571521632373333, 0.0572559386491776, 0.0573597773909569, 0.0574637316167355, 0.0575677789747715, 0.0576719380915165, 0.0577761940658092, 0.0578805021941662, 0.0579849369823933, 0.0580894686281681, 0.0581940785050392, 0.0582987777888775, 0.0584036111831665, 0.05850850045681, 0.058613482862711, 0.0587185919284821, 0.05882378667593, 0.0589290447533131, 0.0590344108641148, 0.059139896184206, 0.0592454560101032, 0.0593511015176773, 0.0594568438827991, 0.0595627091825008, 0.0596686266362667, 0.059774674475193, 0.0598808005452156, 0.0599870085716248, 0.0600933283567429, 0.0601997599005699, 0.0603062249720097, 0.060412835329771, 0.060519527643919, 0.0606263317167759, 0.0607332140207291, 0.0608401782810688, 0.0609472580254078, 0.061054416000843, 0.0611617043614388, 0.0612690523266792, 0.0613765008747578, 0.0614840313792229, 0.0615916587412357, 0.0616993941366673, 0.061807207763195, 0.0619151256978512, 0.0620231553912163, 0.0621312595903873, 0.062239482998848, 0.062347773462534, 0.0624561533331871, 0.0625646263360977, 0.0626732110977173, 0.0627818927168846, 0.0628906488418579, 0.0629995316267014, 0.0631084963679314, 0.0632175505161285, 0.0633266866207123, 0.0634359121322632, 0.0635452643036842, 0.0636546760797501, 0.0637642070651054, 0.063873827457428, 0.0639835447072983, 0.0640933439135551, 0.0642032623291016, 0.0643132552504539, 0.0644233450293541, 0.064533494412899, 0.0646438002586365, 0.0647541582584381, 0.0648646205663681, 0.064975194633007, 0.065085843205452, 0.0651965960860252, 0.0653074458241463, 0.0654183924198151, 0.0655293986201286, 0.0656405389308929, 0.0657517537474632, 0.0658630877733231, 0.0659744814038277, 0.0660859942436218, 0.0661975964903831, 0.066309280693531, 0.0664210766553879, 0.0665329769253731, 0.0666449218988419, 0.0667569935321808, 0.0668691545724869, 0.0669814348220825, 0.0670937672257423, 0.0672062113881111, 0.0673187598586082, 0.0674313977360725, 0.0675441324710846, 0.0676569789648056, 0.0677698776125908, 0.0678828805685043, 0.0679959952831268, 0.0681091994047165, 0.0682224854826927, 0.0683358907699585, 0.0684493631124496, 0.0685629472136497, 0.0686766505241394, 0.0687903761863708, 0.0689042508602142, 0.0690182074904442, 0.0691275596618652, 0.0692323371767998, 0.0693372264504433, 0.0694422498345375, 0.0695473477244377, 0.0696526095271111, 0.0697579756379128, 0.0698634386062622, 0.0699690654873848, 0.0700747296214104, 0.0701805725693703, 0.0702865272760391, 0.0703926011919975, 0.0704987570643425, 0.0706050619482994, 0.0707115083932877, 0.0708180367946625, 0.0709246844053268, 0.0710314512252808, 0.0711383298039436, 0.0712453499436378, 0.0713524594902992, 0.071459673345089, 0.07156702876091, 0.0716745257377625, 0.0717821344733238, 0.0718898177146912, 0.071997657418251, 0.0721055939793587, 0.0722136646509171, 0.0723218321800232, 0.0724301487207413, 0.0725385323166847, 0.0726470649242401, 0.0727557390928268, 0.0728645026683807, 0.072973407804966, 0.073082372546196, 0.0731915012001991, 0.0733007416129112, 0.0734100788831711, 0.0735195577144623, 0.0736291483044624, 0.0737388730049133, 0.073848694562912, 0.0739586502313614, 0.0740686878561974, 0.0741788446903229, 0.0742891430854797, 0.0743995681405067, 0.0745100677013397, 0.0746207386255264, 0.0747315064072609, 0.0748424008488655, 0.0749533921480179, 0.0750645101070404, 0.0751757472753525, 0.0752870962023735, 0.0753985643386841, 0.0755101591348648, 0.0756218433380127, 0.0757336616516113, 0.0758456140756607, 0.075957678258419, 0.0760698541998863, 0.0761821195483208, 0.0762945488095284, 0.0764070525765419, 0.076519712805748, 0.0766324773430824, 0.0767453610897064, 0.0768583416938782, 0.0769714564085007, 0.0770847052335739, 0.0771980360150337, 0.0773114934563637, 0.0774250775575638, 0.0775387957692146, 0.0776526108384132, 0.0777665376663208, 0.0778806060552597, 0.0779947638511658, 0.078109048306942, 0.0782234743237495, 0.0783379673957825, 0.0784526318311691, 0.0785673931241035, 0.0786822736263275, 0.0787972584366798, 0.0789123624563217, 0.0790276005864143, 0.0791429430246353, 0.079258419573307, 0.0793740004301071, 0.079489678144455, 0.0796055048704147, 0.0797214284539223, 0.0798374786973, 0.0799536406993866, 0.0800699442625046, 0.0801863595843315, 0.0803028643131256, 0.0804195255041122, 0.0805362686514854, 0.0806531459093094, 0.0807701200246811, 0.0808872282505035, 0.0810044556856155, 0.0811217799782753, 0.0812392383813858, 0.0813568532466888, 0.0814745500683784, 0.0815923362970352, 0.0817102715373039, 0.081828348338604, 0.0819464921951294, 0.082064762711525, 0.0821831598877907, 0.0823016986250877, 0.0824203416705132, 0.0825390964746475, 0.0826579555869102, 0.0827769264578819, 0.0828960463404655, 0.0830152705311775, 0.0831346064805984, 0.0832540392875671, 0.0833736509084702, 0.0834933295845985, 0.0836131572723389, 0.083733081817627, 0.0838531255722046, 0.0839732810854912, 0.0840935707092285, 0.0842139720916748, 0.08433448523283, 0.0844551026821136, 0.0845758616924286, 0.0846967399120331, 0.0848177149891853, 0.0849388241767883, 0.0850600376725197, 0.08518136292696, 0.085302822291851, 0.0854244083166122, 0.0855460911989212, 0.0856679007411003, 0.0857898369431496, 0.0859118923544884, 0.0860340148210526, 0.0861563086509705, 0.0862787067890167, 0.0864012166857719, 0.0865238383412361, 0.0866466015577316, 0.0867694616317749, 0.0868924260139465, 0.0870155617594719, 0.0871387794613838, 0.0872620865702629, 0.0873855352401733, 0.0875091254711151, 0.0876328349113464, 0.0877565890550613, 0.0878805294632912, 0.0880045741796494, 0.0881287157535553, 0.0882530137896538, 0.0883774012327194, 0.0885019153356552, 0.0886265262961388, 0.0887513011693954, 0.0888761281967163, 0.0890011042356491, 0.0891262292861938, 0.0892514362931252, 0.0893767699599266, 0.0895022228360176, 0.0896277949213982, 0.0897534862160683, 0.0898792818188667, 0.0900051891803741, 0.0901312157511711, 0.0902573689818382, 0.0903836563229561, 0.0905100479722023, 0.0906365662813187, 0.090763159096241, 0.0908899307250977, 0.0910167992115021, 0.0911437496542931, 0.0912708416581154, 0.0913980528712273, 0.0915253907442093, 0.0916528329253197, 0.0917803943157196, 0.0919080972671509, 0.0920358970761299, 0.0921638086438179, 0.0922918543219566, 0.0924199894070625, 0.0925482586026192, 0.0926766470074654, 0.0928051620721817, 0.0929337814450264, 0.0930625274777412, 0.0931913703680038, 0.0933203399181366, 0.0934494361281395, 0.0935786738991737, 0.0937079712748528, 0.0938374102115631, 0.0939669758081436, 0.0940966755151749, 0.0942264422774315, 0.0943563655018806, 0.0944864153862, 0.0946165546774864, 0.094746820628643, 0.0948772057890892, 0.0950077101588249, 0.0951383262872696, 0.0952690616250038, 0.0953999310731888, 0.0955308899283409, 0.0956619828939438, 0.0957932025194168, 0.0959245339035988, 0.0960559621453285, 0.0961875021457672, 0.0963191911578178, 0.0964509770274162, 0.0965828895568848, 0.0967149138450623, 0.0968470573425293, 0.0969793424010277, 0.0971117243170738, 0.0972442328929901, 0.0973768159747124, 0.0975095555186272, 0.0976424217224121, 0.0977753847837448, 0.0979084596037865, 0.0980416834354401, 0.098175011575222, 0.0983084291219711, 0.098442018032074, 0.0985756814479828, 0.0987094342708588, 0.0988433733582497, 0.0989774018526077, 0.0991115495562553, 0.0992457866668701, 0.0993801802396774, 0.0995146855711937, 0.0996492803096771, 0.0997840389609337, 0.0999188646674156, 0.100053817033768, 0.100188918411732, 0.100324131548405, 0.100459441542625, 0.100594885647297, 0.100730441510677, 0.100866124033928, 0.101001895964146, 0.101137802004814, 0.101273834705353, 0.101409986615181, 0.101546227931976, 0.101682581007481, 0.101819083094597, 0.101955704391003, 0.102092444896698, 0.102229297161102, 0.102366268634796, 0.102503314614296, 0.102640524506569, 0.102777846157551, 0.102915272116661, 0.103052817285061, 0.103190511465073, 0.10332828015089, 0.103466190397739, 0.103604227304459, 0.103742346167564, 0.103880599141121, 0.104018986225128, 0.104157477617264, 0.104296050965786, 0.104434788227081, 0.104573652148247, 0.104712620377541, 0.104851692914963, 0.104990877211094, 0.105130203068256, 0.105269603431225, 0.105409167706966, 0.105548836290836, 0.105688624083996, 0.105828516185284, 0.105968557298183, 0.106108702719212, 0.106248930096626, 0.106389291584492, 0.106529794633389, 0.106670394539833, 0.106811128556728, 0.10695194453001, 0.107092924416065, 0.107233993709087, 0.107375212013721, 0.107516504824162, 0.107657916843891, 0.107799470424652, 0.107941143214703, 0.108082927763462, 0.108224794268608, 0.108366832137108, 0.108508966863155, 0.108651213347912, 0.108793593943119, 0.108936086297035, 0.109078675508499, 0.109221383929253, 0.109364241361618, 0.109507203102112, 0.109650231897831, 0.109793439507484, 0.109936766326427, 0.110080197453499, 0.110223740339279, 0.110367394983768, 0.110511168837547, 0.110655061900616, 0.110799081623554, 0.110943183302879, 0.111087441444397, 0.111231826245785, 0.111376315355301, 0.111520916223526, 0.111665606498718, 0.111810453236103, 0.111955419182777, 0.112100481987, 0.112245678901672, 0.112390957772732, 0.112536370754242, 0.112681925296783, 0.112827599048615, 0.112973392009735, 0.113119259476662, 0.113265261054039, 0.113411404192448, 0.113557629287243, 0.113703995943069, 0.113850481808186, 0.113997086882591, 0.114143811166286, 0.114290647208691, 0.114437587559223, 0.114584639668465, 0.114731825888157, 0.114879131317139, 0.115026541054249, 0.115174099802971, 0.11532174050808, 0.115469545125961, 0.115617424249649, 0.115765437483788, 0.115913547575474, 0.116061791777611, 0.116210170090199, 0.116358622908592, 0.116507224738598, 0.116655915975571, 0.116804763674736, 0.116953730583191, 0.117102779448032, 0.117251962423325, 0.117401272058487, 0.117550671100616, 0.117700226604939, 0.117849849164486, 0.117999628186226, 0.118149518966675, 0.118299551308155, 0.118449673056602, 0.118599876761436, 0.118750251829624, 0.118900716304779, 0.119051322340965, 0.119202002882957, 0.119352854788303, 0.119503796100616, 0.119654856622219, 0.119806051254272, 0.119957357645035, 0.120108738541603, 0.120260290801525, 0.120411932468414, 0.120563715696335, 0.1207155585289, 0.1208675801754, 0.121019706130028, 0.121171928942204, 0.121324300765991, 0.121476784348488, 0.121629364788532, 0.121782079339027, 0.121934905648232, 0.122087828814983, 0.122240878641605, 0.122394055128098, 0.122547373175621, 0.122700788080692, 0.122854307293892, 0.123007968068123, 0.123161733150482, 0.12331560254097, 0.123469598591328, 0.123623713850975, 0.123777933418751, 0.123932301998138, 0.124086782336235, 0.12424136698246, 0.124396063387394, 0.124550886452198, 0.124705851078033, 0.124860897660255, 0.125016048550606, 0.125171348452568, 0.125326752662659, 0.1254822909832, 0.125637948513031, 0.12579371035099, 0.125949561595917, 0.126105576753616, 0.126261681318283, 0.126417890191078, 0.126574248075485, 0.126730710268021, 0.126887321472168, 0.127044007182121, 0.127200856804848, 0.12735778093338, 0.127514824271202, 0.127672001719475, 0.127829283475876, 0.127986699342728, 0.128144204616547, 0.128301858901978, 0.128459632396698, 0.128617510199547, 0.128775492310524, 0.128933608531952, 0.129091829061508, 0.129250183701515, 0.129408642649651, 0.129567235708237, 0.12972591817379, 0.129884734749794, 0.130043655633926, 0.13020271062851, 0.130361899733543, 0.130521193146706, 0.130680575966835, 0.130840107798576, 0.130999729037285, 0.131159499287605, 0.131319358944893, 0.131479367613792, 0.131639495491982, 0.131799682974815, 0.131960034370422, 0.132120534777641, 0.132281094789505, 0.132441759109497, 0.132602602243423, 0.132763534784317, 0.132924556732178, 0.133085712790489, 0.133247017860413, 0.133408427238464, 0.133569955825806, 0.133731588721275, 0.133893325924873, 0.134055212140083, 0.134217172861099, 0.134379312396049, 0.134541526436806, 0.134703859686852, 0.134866341948509, 0.135028913617134, 0.13519161939621, 0.135354399681091, 0.135517343878746, 0.135680392384529, 0.135843545198441, 0.136006817221642, 0.13618129491806, 0.136367127299309, 0.136553019285202, 0.136739015579224, 0.136925116181374, 0.137111261487007, 0.13729752600193, 0.137483865022659, 0.137670278549194, 0.137856811285019, 0.138043433427811, 0.13823014497757, 0.138416931033134, 0.138603821396828, 0.138790771365166, 0.138977855443954, 0.139164984226227, 0.139352217316628, 0.139539554715157, 0.13972695171833, 0.139914467930794, 0.140102058649063, 0.140289753675461, 0.140477493405342, 0.140665352344513, 0.140853315591812, 0.141041338443756, 0.141229465603828, 0.141417667269707, 0.141605973243713, 0.141794383525848, 0.141982853412628, 0.142171442508698, 0.142360091209412, 0.142548829317093, 0.142737656831741, 0.142926588654518, 0.14311558008194, 0.143304690718651, 0.143493890762329, 0.143683195114136, 0.143872544169426, 0.144062012434006, 0.144251570105553, 0.144441187381744, 0.144630923867226, 0.144820749759674, 0.145010620355606, 0.145200625061989, 0.145390719175339, 0.145580887794495, 0.145771160721779, 0.145961493253708, 0.146151930093765, 0.146342441439629, 0.146533071994781, 0.146723747253418, 0.146914556622505, 0.14710545539856, 0.14729642868042, 0.147487491369247, 0.14767861366272, 0.147869855165482, 0.148061186075211, 0.148252591490746, 0.14844411611557, 0.148635700345039, 0.148827373981476, 0.149019137024879, 0.149211004376411, 0.149402990937233, 0.149595007300377, 0.149787127971649, 0.149979338049889, 0.150171637535095, 0.15036404132843, 0.150556534528732, 0.150749087333679, 0.150941759347916, 0.151134505867958, 0.151327326893806, 0.151520282030106, 0.151713296771049, 0.151906386017799, 0.152099594473839, 0.152292877435684, 0.152486249804497, 0.152679681777954, 0.152873232960701, 0.153066903352737, 0.153260603547096, 0.153454422950745, 0.153648346662521, 0.153842344880104, 0.154036417603493, 0.15423059463501, 0.154424831271172, 0.154619202017784, 0.154813632369041, 0.155008167028427, 0.155202776193619, 0.155397489666939, 0.155592292547226, 0.155787155032158, 0.155982136726379, 0.156177207827568, 0.156372338533401, 0.156567573547363, 0.156762927770615, 0.156958341598511, 0.157153815031052, 0.157349422574043, 0.157545119524002, 0.157740890979767, 0.15793676674366, 0.158132702112198, 0.158328726887703, 0.158524870872498, 0.158721074461937, 0.158917397260666, 0.159113794565201, 0.159310281276703, 0.15950682759285, 0.159703508019447, 0.15990024805069, 0.16009709239006, 0.160294026136398, 0.160491049289703, 0.160688161849976, 0.160885348916054, 0.16108264029026, 0.16127997636795, 0.161477461457253, 0.161675021052361, 0.161872655153275, 0.162070378661156, 0.162268206477165, 0.16246609389782, 0.162664115428925, 0.162862211465836, 0.163060367107391, 0.163258612155914, 0.163456976413727, 0.163655400276184, 0.163853943347931, 0.164052575826645, 0.164251267910004, 0.164450079202652, 0.164648950099945, 0.164847925305367, 0.165046989917755, 0.165246158838272, 0.165445402264595, 0.165644720196724, 0.16584412753582, 0.166043624281883, 0.166243240237236, 0.166442930698395, 0.166642710566521, 0.166842550039291, 0.167042508721352, 0.167242556810379, 0.167442694306374, 0.167642906308174, 0.167843207716942, 0.168043613433838, 0.168244108557701, 0.168444663286209, 0.168645337224007, 0.16884608566761, 0.169046938419342, 0.169247850775719, 0.169448882341385, 0.169649988412857, 0.169851198792458, 0.170052468776703, 0.170253857970238, 0.170455321669579, 0.170656859874725, 0.170858487486839, 0.171060249209404, 0.171262055635452, 0.171463951468468, 0.171665951609612, 0.171868056058884, 0.172070235013962, 0.172272503376007, 0.172474846243858, 0.172677278518677, 0.172879830002785, 0.173082441091537, 0.173285141587257, 0.173487946391106, 0.17369082570076, 0.173893824219704, 0.174096882343292, 0.174300044775009, 0.17450325191021, 0.174706593155861, 0.174910038709641, 0.175113528966904, 0.175317138433456, 0.175520822405815, 0.175724595785141, 0.175928458571434, 0.176132425665855, 0.17633643746376, 0.176540583372116, 0.176744818687439, 0.176949113607407, 0.177153527736664, 0.177358001470566, 0.177562579512596, 0.177767261862755, 0.177972003817558, 0.17817685008049, 0.178381770849228, 0.178586781024933, 0.178791910409927, 0.178997114300728, 0.179202392697334, 0.179407775402069, 0.179613247513771, 0.17981880903244, 0.180024445056915, 0.180230170488358, 0.180435970425606, 0.180641904473305, 0.180847883224487, 0.181053996086121, 0.18126018345356, 0.181466445326805, 0.181672796607018, 0.181879237294197, 0.182085782289505, 0.182292371988297, 0.182499080896378, 0.182705894112587, 0.182912796735764, 0.183119758963585, 0.183326840400696, 0.183533981442451, 0.183741241693497, 0.183948576450348, 0.184155985713005, 0.184363484382629, 0.184571102261543, 0.184778794646263, 0.184986561536789, 0.185194432735443, 0.185402378439903, 0.185610443353653, 0.185818567872047, 0.18602679669857, 0.186235100030899, 0.186443507671356, 0.186652004718781, 0.18686056137085, 0.187069252133369, 0.187278002500534, 0.187486842274666, 0.187695786356926, 0.187904804944992, 0.188113912940025, 0.188323110342026, 0.188532397150993, 0.188741773366928, 0.188951253890991, 0.18916080892086, 0.189370438456535, 0.1895801872015, 0.189790010452271, 0.189999908208847, 0.190209910273552, 0.190420001745224, 0.190630212426186, 0.19084045290947, 0.191050797700882, 0.191261261701584, 0.191471785306931, 0.191682413220406, 0.191893130540848, 0.192103922367096, 0.192314818501472, 0.192525818943977, 0.192736864089966, 0.192948028445244, 0.193159252405167, 0.193370625376701, 0.193582013249397, 0.193793535232544, 0.194005146622658, 0.194216847419739, 0.194428622722626, 0.19464048743248, 0.194852456450462, 0.195064499974251, 0.195276632905006, 0.195488855242729, 0.195701166987419, 0.195913568139076, 0.196126058697701, 0.196338653564453, 0.196551293134689, 0.196764066815376, 0.196976915001869, 0.197189852595329, 0.197402879595757, 0.197615996003151, 0.197829201817513, 0.19804248213768, 0.198255851864815, 0.198469325900078, 0.198682889342308, 0.198896527290344, 0.19911028444767, 0.199324101209641, 0.199538022279739, 0.199752032756805, 0.199966117739677, 0.200180307030678, 0.200394570827484, 0.200608924031258, 0.200823366641998, 0.201037913560867, 0.201252520084381, 0.201467260718346, 0.201682031154633, 0.201896950602531, 0.202111929655075, 0.202326983213425, 0.202542155981064, 0.202757388353348, 0.202972754836082, 0.20318815112114, 0.203403681516647, 0.203619286417961, 0.203834995627403, 0.20405076444149, 0.204266622662544, 0.204482585191727, 0.204698622226715, 0.204914763569832, 0.205131009221077, 0.205347314476967, 0.205563709139824, 0.205780208110809, 0.205996796488762, 0.20621345937252, 0.206430226564407, 0.2066470682621, 0.206864014267921, 0.207081034779549, 0.207298144698143, 0.207515358924866, 0.207732647657394, 0.207950040698051, 0.208167508244514, 0.208385065197945, 0.208602726459503, 0.208820447325706, 0.209038272500038, 0.209256187081337, 0.209474191069603, 0.209692284464836, 0.209910467267036, 0.210128754377365, 0.210347101092339, 0.210565567016602, 0.210784092545509, 0.211002722382545, 0.21122145652771, 0.211440250277519, 0.211659133434296, 0.211878105998039, 0.212097182869911, 0.21231634914875, 0.212535619735718, 0.212754935026169, 0.212974369525909, 0.213193908333778, 0.21341347694397, 0.213633194565773, 0.213852971792221, 0.214072823524475, 0.214292824268341, 0.214512854814529, 0.214732989668846, 0.21495321393013, 0.215173542499542, 0.215393930673599, 0.215614438056946, 0.21583503484726, 0.216055691242218, 0.216276451945305, 0.216497287154198, 0.216718256473541, 0.21693928539753, 0.217160403728485, 0.217381611466408, 0.217602893710136, 0.217824280261993, 0.218045756220818, 0.218267306685448, 0.218488946557045, 0.218710705637932, 0.218932539224625, 0.219154447317123, 0.219376459717751, 0.219598546624184, 0.219820737838745, 0.220042988657951, 0.220265373587608, 0.22048781812191, 0.22071036696434, 0.220932990312576, 0.22115570306778, 0.22137850522995, 0.22160142660141, 0.221824377775192, 0.222047477960587, 0.222270637750626, 0.222493886947632, 0.222717240452766, 0.222940668463707, 0.223164170980453, 0.223387777805328, 0.22361147403717, 0.22383525967598, 0.224059119820595, 0.224283114075661, 0.22450715303421, 0.224731281399727, 0.224955528974533, 0.225179865956306, 0.225404247641563, 0.22562874853611, 0.225853323936462, 0.226078018546104, 0.226302772760391, 0.226527631282806, 0.226752564311028, 0.226977616548538, 0.227202713489532, 0.227427929639816, 0.227653220295906, 0.227878600358963, 0.228104084730148, 0.22832964360714, 0.228555291891098, 0.228781029582024, 0.229006871581078, 0.229232802987099, 0.229458808898926, 0.229684889316559, 0.22991107404232, 0.230137348175049, 0.230363726615906, 0.230590179562569, 0.230816707015038, 0.231043338775635, 0.23127007484436, 0.231496885418892, 0.231723785400391, 0.231950744986534, 0.232177823781967, 0.232405006885529, 0.232632264494896, 0.232859596610069, 0.233087033033371, 0.233314543962479, 0.233542159199715, 0.233769848942757, 0.233997657895088, 0.234225511550903, 0.234453469514847, 0.234681531786919, 0.234909668564796, 0.235137894749641, 0.235366225242615, 0.235594645142555, 0.235823139548302, 0.236051738262177, 0.236280411481857, 0.236509144306183, 0.236738041043282, 0.236966967582703, 0.237196013331413, 0.237425118684769, 0.237654328346252, 0.237883627414703, 0.238113030791283, 0.238342478871346, 0.238572061061859, 0.238801717758179, 0.239031448960304, 0.239261284470558, 0.239491194486618, 0.239721208810806, 0.2399512976408, 0.24019156396389, 0.240441843867302, 0.240691974759102, 0.240942001342773, 0.241191938519478, 0.241441756486893, 0.241691440343857, 0.241941079497337, 0.242190539836884, 0.242439910769463, 0.242689192295074, 0.242938354611397, 0.243187412619591, 0.243436336517334, 0.243685185909271, 0.243933901190758, 0.244182512164116, 0.244430989027023, 0.244679376482964, 0.244927674531937, 0.24517585337162, 0.245423913002014, 0.245671853423119, 0.245919719338417, 0.246167451143265, 0.246415063738823, 0.246662586927414, 0.246909990906715, 0.247157290577888, 0.247404456138611, 0.247651547193527, 0.247898519039154, 0.248145371675491, 0.248392134904861, 0.24863874912262, 0.248885288834572, 0.249131709337234, 0.249378010630608, 0.249624222517014, 0.249870300292969, 0.250116288661957, 0.250362157821655, 0.250607937574387, 0.250853568315506, 0.251099109649658, 0.251344531774521, 0.251589864492416, 0.251835078001022, 0.252080172300339, 0.252325177192688, 0.252570062875748, 0.252814829349518, 0.253059506416321, 0.253304034471512, 0.253548502922058, 0.253792822360992, 0.25403705239296, 0.254281163215637, 0.254525184631348, 0.254769057035446, 0.255012840032578, 0.255256503820419, 0.255500108003616, 0.255743563175201, 0.255986928939819, 0.256230115890503, 0.256473273038864, 0.256716281175613, 0.256959199905396, 0.257201999425888, 0.257444679737091, 0.257687270641327, 0.257929742336273, 0.25817209482193, 0.258414328098297, 0.25865650177002, 0.25889852643013, 0.259140461683273, 0.259382247924805, 0.259623974561691, 0.259865581989288, 0.260107040405273, 0.260348409414291, 0.260589689016342, 0.260830849409103, 0.261071920394897, 0.261312812566757, 0.261553645133972, 0.261794358491898, 0.262034982442856, 0.262275487184525, 0.262515872716904, 0.262756139039993, 0.262996315956116, 0.263236373662949, 0.263476312160492, 0.263716161251068, 0.263955891132355, 0.264195501804352, 0.264434993267059, 0.264674425125122, 0.264913707971573, 0.265152871608734, 0.265391975641251, 0.265630930662155, 0.26586976647377, 0.26610854268074, 0.266347169876099, 0.266585677862167, 0.266824096441269, 0.267062395811081, 0.267300605773926, 0.267538666725159, 0.267776668071747, 0.268014520406723, 0.268252313137054, 0.268489927053452, 0.268727481365204, 0.268964916467667, 0.269202202558517, 0.269439399242401, 0.269676506519318, 0.269913494586945, 0.270150393247604, 0.270387142896652, 0.270623862743378, 0.270860403776169, 0.271096795797348, 0.271333158016205, 0.27156937122345, 0.271805465221405, 0.272041469812393, 0.272277355194092, 0.272513121366501, 0.272748857736588, 0.272984385490417, 0.273219853639603, 0.273455202579498, 0.273690402507782, 0.273925572633743, 0.27416056394577, 0.27439546585083, 0.274630278348923, 0.274864971637726, 0.275099545717239, 0.275334000587463, 0.27556836605072, 0.27580264210701, 0.276036739349365, 0.276270776987076, 0.276504695415497, 0.276738524436951, 0.276972234249115, 0.27720582485199, 0.277439266443253, 0.277672648429871, 0.277905911207199, 0.278139054775238, 0.278372079133987, 0.27860501408577, 0.278837859630585, 0.279070556163788, 0.279303193092346, 0.27953565120697, 0.279768049716949, 0.280000329017639, 0.280232459306717, 0.28046452999115, 0.280696481466293, 0.28092834353447, 0.281160056591034, 0.281391680240631, 0.281623184680939, 0.281854569911957, 0.28208589553833, 0.282317072153091, 0.282548099756241, 0.282779067754745, 0.283009916543961, 0.283240616321564, 0.283471286296844, 0.283701807260513, 0.283932238817215, 0.284162521362305, 0.28439274430275, 0.28462278842926, 0.284852743148804, 0.285082638263702, 0.285312384366989, 0.285542011260986, 0.285771548748016, 0.286000996828079, 0.28623029589653, 0.286459535360336, 0.286688596010208, 0.286917567253113, 0.287146478891373, 0.287375211715698, 0.287603884935379, 0.28783243894577, 0.28806084394455, 0.288289219141006, 0.288517385721207, 0.288745522499084, 0.288973540067673, 0.289201408624649, 0.289429187774658, 0.289656847715378, 0.28988441824913, 0.290111839771271, 0.290339201688766, 0.29056641459465, 0.290793597698212, 0.291020572185516, 0.291247487068176, 0.291474252939224, 0.291700959205627, 0.291927516460419, 0.292153984308243, 0.2923803627491, 0.292606592178345, 0.2928327023983, 0.293058753013611, 0.29328465461731, 0.293510466814041, 0.293736189603806, 0.293961763381958, 0.294187217950821, 0.294412553310394, 0.294637829065323, 0.294862985610962, 0.295088022947311, 0.295312970876694, 0.295537769794464, 0.295762479305267, 0.295987099409103, 0.296211570501328, 0.296436011791229, 0.296660244464874, 0.296884417533875, 0.297108471393585, 0.297332376241684, 0.297556191682816, 0.297779977321625, 0.2980035841465, 0.298227041959763, 0.298450440168381, 0.298673778772354, 0.298896908760071, 0.299119979143143, 0.299342900514603, 0.29956579208374, 0.299788504838943, 0.30001112818718, 0.300233662128448, 0.300456076860428, 0.300678342580795, 0.300900548696518, 0.301122635602951, 0.301344573497772, 0.301566451787949, 0.301788210868835, 0.30200982093811, 0.302231401205063, 0.302452772855759, 0.302674114704132, 0.302895307540894, 0.303116381168365, 0.30333736538887, 0.303558230400085, 0.303779006004333, 0.303999662399292, 0.304220229387283, 0.304440647363663, 0.304660946130753, 0.304881185293198, 0.305101305246353, 0.305321276187897, 0.305541157722473, 0.305760949850082, 0.30598059296608, 0.306200176477432, 0.30641958117485, 0.306638956069946, 0.30685818195343, 0.307077288627625, 0.307296276092529, 0.307515203952789, 0.307733982801437, 0.307952642440796, 0.30817124247551, 0.308389663696289, 0.308608055114746, 0.308826297521591, 0.309044420719147, 0.309262454509735, 0.309480339288712, 0.309698164463043, 0.309915840625763, 0.310133397579193, 0.310350924730301, 0.310568273067474, 0.310785502195358, 0.311002641916275, 0.311219692230225, 0.311436623334885, 0.311653435230255, 0.311870157718658, 0.31208673119545, 0.312303185462952, 0.312519609928131, 0.312735885381699, 0.312952011823654, 0.313168078660965, 0.313383996486664, 0.313599854707718, 0.31381556391716, 0.314031153917313, 0.314246654510498, 0.314462065696716, 0.314677327871323, 0.314892530441284, 0.315107554197311, 0.315322488546371, 0.315537333488464, 0.31575208902359, 0.315966725349426, 0.316181212663651, 0.31639564037323, 0.316609919071198, 0.316824078559875, 0.317038208246231, 0.317252159118652, 0.317465990781784, 0.317679762840271, 0.317893385887146, 0.318106889724731, 0.31832030415535, 0.318533658981323, 0.318746834993362, 0.318959921598434, 0.319172888994217, 0.319385796785355, 0.31959855556488, 0.319811165332794, 0.320023745298386, 0.320236146450043, 0.320448458194733, 0.320660650730133, 0.320872783660889, 0.32108473777771, 0.321296662092209, 0.321508437395096, 0.321720093488693, 0.321931630373001, 0.322143077850342, 0.322354435920715, 0.322565615177155, 0.322776734828949, 0.322987765073776, 0.323198646306992, 0.32340943813324, 0.323620110750198, 0.323830664157867, 0.324041128158569, 0.324251443147659, 0.324461698532104, 0.32467183470726, 0.324881851673126, 0.325091749429703, 0.325301557779312, 0.32551121711731, 0.325720816850662, 0.325930297374725, 0.326139658689499, 0.326348900794983, 0.3265580534935, 0.326767086982727, 0.326976001262665, 0.327184796333313, 0.327393501996994, 0.327602088451385, 0.32781058549881, 0.328018933534622, 0.32822722196579, 0.328435361385345, 0.328643411397934, 0.328851342201233, 0.329059153795242, 0.329266875982285, 0.32947450876236, 0.329681992530823, 0.329889357089996, 0.330096632242203, 0.330303817987442, 0.330510854721069, 0.330717802047729, 0.330924659967422, 0.331131398677826, 0.33133801817894, 0.331544518470764, 0.331750929355621, 0.331957191228867, 0.332163393497467, 0.332369446754456, 0.332575440406799, 0.332781255245209, 0.332987040281296, 0.333192616701126, 0.333398163318634, 0.333603590726852, 0.333808869123459, 0.334014087915421, 0.33421915769577, 0.334424138069153, 0.334629029035568, 0.334833741188049, 0.335038423538208, 0.335242927074432, 0.335447371006012, 0.335651695728302, 0.33585587143898, 0.336059957742691, 0.336263954639435, 0.336467832326889, 0.336671620607376, 0.336875259876251, 0.337078839540482, 0.3372822701931, 0.337485581636429, 0.337688833475113, 0.337891936302185, 0.338094890117645, 0.338297843933105, 0.338500589132309, 0.338703274726868, 0.338905811309814, 0.339108258485794, 0.339310616254807, 0.339512854814529, 0.339714974164963, 0.339916974306107, 0.340118885040283, 0.340320706367493, 0.34052237868309, 0.340723931789398, 0.340925425291061, 0.341126769781113, 0.341328024864197, 0.341529160737991, 0.341730177402496, 0.341931104660034, 0.34213188290596, 0.342332631349564, 0.342533200979233, 0.342733651399612, 0.342934012413025, 0.34313428401947, 0.343334466218948, 0.343534469604492, 0.343734413385391, 0.343934267759323, 0.344133973121643, 0.344333559274673, 0.344533026218414, 0.344732403755188, 0.344931691884995, 0.345130860805511, 0.345329880714417, 0.345528870820999, 0.345727682113647, 0.345926403999329, 0.346125036478043, 0.346323549747467, 0.34652191400528, 0.346720218658447, 0.346918374300003, 0.347116470336914, 0.347314387559891, 0.347512274980545, 0.347709983587265, 0.34790763258934, 0.348105162382126, 0.348302572965622, 0.348499864339828, 0.348697036504745, 0.348894119262695, 0.349091082811356, 0.349287986755371, 0.34948468208313, 0.349681317806244, 0.349877893924713, 0.350074291229248, 0.350270628929138, 0.350466817617416, 0.350662916898727, 0.350858896970749, 0.351054757833481, 0.351250529289246, 0.351446181535721, 0.351631253957748, 0.351805686950684, 0.35197976231575, 0.352153539657593, 0.352327048778534, 0.352500200271606, 0.352673053741455, 0.352845638990402, 0.353017896413803, 0.35318985581398, 0.353361457586288, 0.353532820940018, 0.353703886270523, 0.353874623775482, 0.354045033454895, 0.354215115308762, 0.354384958744049, 0.35455447435379, 0.354723691940308, 0.354892581701279, 0.355061143636703, 0.355229407548904, 0.355397433042526, 0.355565100908279, 0.355732440948486, 0.355899512767792, 0.356066256761551, 0.356232732534409, 0.35639888048172, 0.356564700603485, 0.356730252504349, 0.356895506381989, 0.357060432434082, 0.357225030660629, 0.357389330863953, 0.357553333044052, 0.35771706700325, 0.357880473136902, 0.358043521642685, 0.358206301927567, 0.358368784189224, 0.35853099822998, 0.358692854642868, 0.358854413032532, 0.359015643596649, 0.359176605939865, 0.359337270259857, 0.359497606754303, 0.359657615423203, 0.359817355871201, 0.359976768493652, 0.360135912895203, 0.360294699668884, 0.360453248023987, 0.360611438751221, 0.360769331455231, 0.360926955938339, 0.361084192991257, 0.361241161823273, 0.361397862434387, 0.361554235219955, 0.361710280179977, 0.361866056919098, 0.36202147603035, 0.362176656723022, 0.362331509590149, 0.362486004829407, 0.362640261650085, 0.36279422044754, 0.362947821617126, 0.363101094961166, 0.363254129886627, 0.363406836986542, 0.363559186458588, 0.363711357116699, 0.363863080739975, 0.364014595746994, 0.364165723323822, 0.364316642284393, 0.364467173814774, 0.36461740732193, 0.364767402410507, 0.364917039871216, 0.365066379308701, 0.365215420722961, 0.365364164113998, 0.365512579679489, 0.365660697221756, 0.365808486938477, 0.365956038236618, 0.366103202104568, 0.366250097751617, 0.366396695375443, 0.366542994976044, 0.366688996553421, 0.36683464050293, 0.366980016231537, 0.367125064134598, 0.367269814014435, 0.36741429567337, 0.367558419704437, 0.367702275514603, 0.367845803499222, 0.367989033460617, 0.368131965398788, 0.368274539709091, 0.368416905403137, 0.368558913469315, 0.368700593709946, 0.368841975927353, 0.368983089923859, 0.369123905897141, 0.369264334440231, 0.369404554367065, 0.369544416666031, 0.369683980941772, 0.369823217391968, 0.369962185621262, 0.370100826025009, 0.370239198207855, 0.370377212762833, 0.370514929294586, 0.370652347803116, 0.370789468288422, 0.370926260948181, 0.371062815189362, 0.371198982000351, 0.371334910392761, 0.371470481157303, 0.371605813503265, 0.371740788221359, 0.371875435113907, 0.372009783983231, 0.372143894433975, 0.372277587652206, 0.372411072254181, 0.372544229030609, 0.372677057981491, 0.372809588909149, 0.372941851615906, 0.373073756694794, 0.373205363750458, 0.373336672782898, 0.373467713594437, 0.373598396778107, 0.373728781938553, 0.373858898878098, 0.373988658189774, 0.37411817908287, 0.374247342348099, 0.374376207590103, 0.374504745006561, 0.37463304400444, 0.374760955572128, 0.374888628721237, 0.3750159740448, 0.375142991542816, 0.375269711017609, 0.375396132469177, 0.375522255897522, 0.375648081302643, 0.375773578882217, 0.375898778438568, 0.376023679971695, 0.376148283481598, 0.376272559165955, 0.37639656662941, 0.376520246267319, 0.376643598079681, 0.37676665186882, 0.376889407634735, 0.377011865377426, 0.377133995294571, 0.377255886793137, 0.377377390861511, 0.377498626708984, 0.377619534730911, 0.377740174531937, 0.377860486507416, 0.377980500459671, 0.378100216388702, 0.378219604492188, 0.378338694572449, 0.378457456827164, 0.378575950860977, 0.378694117069244, 0.378811985254288, 0.37892958521843, 0.379046827554703, 0.379163771867752, 0.379280418157578, 0.379396736621857, 0.379512816667557, 0.379628539085388, 0.379743963479996, 0.379859060049057, 0.379973918199539, 0.380088418722153, 0.380202621221542, 0.380316495895386, 0.380430102348328, 0.380543380975723, 0.380656361579895, 0.380769044160843, 0.380881428718567, 0.380993485450745, 0.381105244159698, 0.381216675043106, 0.381327837705612, 0.381438672542572, 0.381549209356308, 0.381659418344498, 0.381769359111786, 0.381878972053528, 0.381988316774368, 0.382097333669662, 0.382205992937088, 0.382314413785934, 0.382422506809235, 0.382530331611633, 0.382637768983841, 0.382744967937469, 0.382851809263229, 0.38295841217041, 0.3830646276474, 0.383170574903488, 0.383276253938675, 0.383381575345993, 0.38348662853241, 0.383591383695602, 0.383695751428604, 0.383799910545349, 0.383903712034225, 0.3840072453022, 0.384110450744629, 0.384213328361511, 0.38431590795517, 0.384418219327927, 0.384520173072815, 0.384621828794479, 0.384723216295242, 0.384824305772781, 0.384925067424774, 0.385025501251221, 0.385125696659088, 0.385225474834442, 0.385325044393539, 0.385424256324768, 0.385523200035095, 0.385621786117554, 0.385720133781433, 0.385818123817444, 0.385915845632553, 0.386013239622116, 0.386110335588455, 0.38620713353157, 0.386303603649139, 0.386399805545807, 0.386495649814606, 0.386591225862503, 0.386686474084854, 0.386781424283981, 0.386876076459885, 0.386970400810242, 0.387064456939697, 0.387158185243607, 0.38725158572197, 0.387344717979431, 0.387437552213669, 0.387530028820038, 0.387622267007828, 0.387714117765427, 0.387805759906769, 0.38789701461792, 0.387988060712814, 0.388078689575195, 0.388169080018997, 0.388259142637253, 0.388348907232285, 0.38843834400177, 0.388527512550354, 0.388616323471069, 0.388704866170883, 0.388793081045151, 0.388881027698517, 0.388968676328659, 0.389055967330933, 0.389142990112305, 0.38922968506813, 0.389316082000732, 0.38940218091011, 0.389487951993942, 0.389573454856873, 0.389658600091934, 0.389743477106094, 0.389828056097031, 0.389912307262421, 0.389996260404587, 0.390079885721207, 0.390163272619247, 0.390246331691742, 0.390329033136368, 0.39041143655777, 0.390493541955948, 0.390575379133224, 0.390656888484955, 0.390738129615784, 0.390819013118744, 0.390899568796158, 0.390979886054993, 0.391059845685959, 0.391139507293701, 0.391218900680542, 0.391297966241837, 0.391376703977585, 0.391455173492432, 0.391533344984055, 0.391611188650131, 0.391688704490662, 0.391765952110291, 0.391842871904373, 0.391919493675232, 0.391995847225189, 0.392071783542633, 0.392147481441498, 0.392222940921783, 0.392298012971878, 0.392372757196426, 0.392447263002396, 0.392521470785141, 0.392595320940018, 0.392668902873993, 0.392742127180099, 0.392815113067627, 0.392887741327286, 0.392960101366043, 0.393032163381577, 0.393103867769241, 0.393175274133682, 0.393246412277222, 0.393317222595215, 0.393387764692307, 0.39345794916153, 0.393527835607529, 0.393597424030304, 0.393666714429855, 0.393735736608505, 0.393804401159286, 0.393872767686844, 0.393940806388855, 0.394008576869965, 0.39407604932785, 0.394143164157867, 0.394210010766983, 0.394276589155197, 0.394342809915543, 0.394408732652664, 0.394474357366562, 0.394539684057236, 0.394604682922363, 0.394669353961945, 0.394733726978302, 0.39479786157608, 0.394861668348312, 0.394925147294998, 0.394988298416138, 0.395051181316376, 0.395113736391068, 0.395175993442535, 0.395237952470779, 0.3952996134758, 0.395360976457596, 0.395422011613846, 0.395482748746872, 0.395543158054352, 0.395603269338608, 0.39566308259964, 0.395722597837448, 0.39578178524971, 0.395840734243393, 0.395899295806885, 0.395957618951797, 0.396015584468842, 0.396073222160339, 0.396130621433258, 0.39618769288063, 0.396244466304779, 0.396300911903381, 0.396357029676437, 0.396412909030914, 0.3964684009552, 0.396523654460907, 0.396578580141068, 0.396633207798004, 0.396687507629395, 0.396741569042206, 0.396795243024826, 0.396848678588867, 0.396901696920395, 0.396954536437988, 0.397007018327713, 0.397059142589569, 0.397111058235168, 0.397162646055222, 0.397213876247406, 0.397264868021011, 0.397315502166748, 0.397365808486938, 0.39741587638855, 0.397465586662292, 0.397515028715134, 0.397564172744751, 0.3976129591465, 0.397661477327347, 0.397709667682648, 0.397757589817047, 0.397805154323578, 0.39785248041153, 0.397899448871613, 0.397946149110794, 0.397992491722107, 0.398038595914841, 0.398084312677383, 0.398129761219025, 0.398174911737442, 0.398219764232635, 0.398264288902283, 0.398308545351028, 0.398352473974228, 0.398396104574203, 0.398439347743988, 0.398482412099838, 0.39852511882782, 0.398567527532578, 0.398609608411789, 0.398651421070099, 0.39869287610054, 0.39873406291008, 0.398774951696396, 0.398815542459488, 0.398855745792389, 0.398895710706711, 0.398935377597809, 0.398974686861038, 0.399013757705688, 0.399052441120148, 0.399090886116028, 0.399129033088684, 0.399166852235794, 0.399204343557358, 0.39924156665802, 0.399278461933136, 0.399315029382706, 0.399351328611374, 0.399387329816818, 0.399423003196716, 0.399458378553391, 0.399493455886841, 0.399528235197067, 0.399562656879425, 0.399596810340881, 0.399630665779114, 0.399664223194122, 0.399697422981262, 0.399730354547501, 0.399762958288193, 0.399795293807983, 0.399827301502228, 0.399859040975571, 0.399890393018723, 0.399921506643295, 0.399952292442322, 0.399982780218124, 0.400012940168381, 0.400042831897736, 0.400072395801544, 0.400101661682129, 0.400130599737167, 0.400159239768982, 0.400187611579895, 0.400215625762939, 0.400243371725082, 0.400270819664001, 0.400297939777374, 0.400324732065201, 0.400351226329803, 0.400377482175827, 0.40040335059166, 0.400428950786591, 0.400454252958298, 0.400479227304459, 0.400503873825073, 0.400528281927109, 0.400552332401276, 0.400576114654541, 0.400599539279938, 0.400622695684433, 0.400645554065704, 0.400668054819107, 0.400690317153931, 0.400700330734253, 0.400698065757751, 0.400695443153381, 0.400692462921143, 0.400689274072647, 0.400685638189316, 0.400681763887405, 0.400677561759949, 0.400673002004623, 0.400668084621429, 0.400662899017334, 0.40065735578537, 0.400651574134827, 0.400645405054092, 0.400638908147812, 0.400632113218307, 0.400624960660934, 0.40061753988266, 0.400609731674194, 0.40060168504715, 0.400593250989914, 0.400584489107132, 0.400575429201126, 0.400566071271896, 0.400556325912476, 0.400546312332153, 0.400535941123962, 0.400525271892548, 0.400514274835587, 0.400502949953079, 0.400491297245026, 0.400479346513748, 0.400467067956924, 0.400454461574554, 0.400441527366638, 0.400428265333176, 0.400414705276489, 0.400400787591934, 0.400386542081833, 0.400371998548508, 0.400357156991959, 0.400341957807541, 0.400326430797577, 0.400310575962067, 0.400294452905655, 0.400277972221375, 0.400261163711548, 0.400243997573853, 0.400226563215256, 0.400208830833435, 0.400190711021423, 0.400172293186188, 0.400153577327728, 0.4001345038414, 0.400115132331848, 0.40009543299675, 0.400075376033783, 0.400055050849915, 0.400034368038177, 0.400013387203217, 0.399992048740387, 0.399970412254333, 0.399948447942734, 0.399926155805588, 0.399903535842896, 0.399880617856979, 0.399857372045517, 0.399833798408508, 0.399809867143631, 0.399785667657852, 0.399761110544205, 0.399736255407333, 0.399711102247238, 0.39968553185463, 0.399659752845764, 0.399633556604385, 0.399607062339783, 0.399580270051956, 0.399553149938583, 0.399525701999664, 0.399497956037521, 0.39946985244751, 0.399441450834274, 0.39941269159317, 0.399383664131165, 0.399354308843613, 0.39932456612587, 0.399294555187225, 0.399264186620712, 0.399233549833298, 0.399202525615692, 0.39917117357254, 0.399139583110809, 0.399107605218887, 0.399075359106064, 0.399042725563049, 0.399009793996811, 0.398976564407349, 0.398942947387695, 0.398909062147141, 0.398874878883362, 0.398840337991714, 0.398805469274521, 0.398770242929459, 0.398734748363495, 0.398698925971985, 0.398662745952606, 0.398626327514648, 0.398589491844177, 0.398552387952805, 0.398514926433563, 0.398477166891098, 0.398439109325409, 0.398400664329529, 0.398361951112747, 0.398322880268097, 0.3982834815979, 0.39824378490448, 0.398203760385513, 0.398163437843323, 0.398122787475586, 0.398081749677658, 0.398040473461151, 0.397998809814453, 0.397956848144531, 0.397914558649063, 0.397872000932693, 0.397829055786133, 0.397785812616348, 0.397742241621017, 0.39769834280014, 0.397654145956039, 0.39760959148407, 0.397564768791199, 0.397519558668137, 0.397474020719528, 0.397428214550018, 0.397382080554962, 0.397335588932037, 0.397288799285889, 0.397241711616516, 0.39719420671463, 0.397146493196487, 0.397098422050476, 0.397049963474274, 0.397001266479492, 0.39695218205452, 0.396902799606323, 0.396853119134903, 0.396803110837936, 0.396752774715424, 0.396702110767365, 0.396651118993759, 0.396599799394608, 0.396548122167587, 0.396496206521988, 0.39644393324852, 0.396391332149506, 0.396338403224945, 0.396285176277161, 0.39623162150383, 0.396177679300308, 0.396123468875885, 0.396068960428238, 0.396014094352722, 0.39595890045166, 0.395903408527374, 0.395847588777542, 0.395791441202164, 0.395734965801239, 0.39567819237709, 0.395621061325073, 0.39556360244751, 0.395505845546722, 0.395447790622711, 0.395389348268509, 0.395330637693405, 0.395271599292755, 0.395212233066559, 0.395152509212494, 0.395092517137527, 0.395032167434692, 0.394971519708633, 0.394910484552383, 0.394849210977554, 0.394787609577179, 0.394725650548935, 0.394663363695145, 0.394600749015808, 0.394537836313248, 0.394474595785141, 0.39441105723381, 0.394347161054611, 0.394282937049866, 0.394218385219574, 0.394153565168381, 0.394088357686996, 0.394022852182388, 0.393957048654556, 0.393890917301178, 0.393824398517609, 0.39375764131546, 0.393690526485443, 0.39362308382988, 0.39355531334877, 0.393487244844437, 0.393418848514557, 0.393350124359131, 0.393281102180481, 0.393211722373962, 0.39314204454422, 0.393072009086609, 0.393001675605774, 0.39293098449707, 0.392860025167465, 0.392788708209991, 0.392717093229294, 0.39264515042305, 0.39257287979126, 0.392500251531601, 0.392427355051041, 0.392354100942612, 0.392280578613281, 0.392206639051437, 0.392132461071014, 0.392057925462723, 0.391983062028885, 0.391907870769501, 0.391832381486893, 0.391756594181061, 0.391680419445038, 0.391603946685791, 0.39152717590332, 0.391450077295303, 0.391372621059418, 0.391294836997986, 0.391216784715652, 0.39113837480545, 0.391059696674347, 0.39098060131073, 0.390901237726212, 0.390821576118469, 0.390741556882858, 0.390661239624023, 0.390580594539642, 0.390499591827393, 0.390418291091919, 0.390336692333221, 0.390254735946655, 0.390172451734543, 0.390089869499207, 0.390006959438324, 0.389923691749573, 0.389840126037598, 0.389756262302399, 0.389672070741653, 0.389587551355362, 0.389502674341202, 0.389417499303818, 0.38933202624321, 0.389246195554733, 0.389160066843033, 0.389073580503464, 0.388986796140671, 0.388899713754654, 0.388812243938446, 0.388724535703659, 0.388636440038681, 0.388548046350479, 0.388459295034409, 0.388370275497437, 0.388280898332596, 0.388191223144531, 0.388101190328598, 0.388010889291763, 0.38792023062706, 0.387829273939133, 0.387737989425659, 0.387646317481995, 0.387554407119751, 0.387462139129639, 0.38736954331398, 0.387276619672775, 0.387183368206024, 0.387089818716049, 0.38699597120285, 0.38690173625946, 0.386807203292847, 0.386712342500687, 0.386617213487625, 0.386521697044373, 0.386425912380219, 0.386329770088196, 0.386233299970627, 0.386136531829834, 0.386039435863495, 0.385941982269287, 0.385844230651855, 0.385746210813522, 0.385647773742676, 0.385549038648605, 0.385450005531311, 0.38535064458847, 0.385250985622406, 0.385150909423828, 0.385050624608994, 0.384950011968613, 0.384849011898041, 0.384747684001923, 0.384646058082581, 0.384544134140015, 0.384441882371902, 0.384339302778244, 0.384236395359039, 0.384133160114288, 0.384029597043991, 0.38392573595047, 0.38382151722908, 0.383716970682144, 0.383612126111984, 0.3835069835186, 0.383401483297348, 0.383295685052872, 0.383189529180527, 0.383083075284958, 0.382976293563843, 0.382869243621826, 0.382761746644974, 0.382654070854187, 0.382545977830887, 0.38243755698204, 0.382328867912292, 0.382219851016998, 0.382110476493835, 0.382000803947449, 0.381890743970871, 0.381780445575714, 0.381669819355011, 0.381558805704117, 0.381447553634644, 0.381335914134979, 0.381223976612091, 0.381111711263657, 0.380999147891998, 0.380886226892471, 0.38077300786972, 0.380659401416779, 0.38054558634758, 0.38043138384819, 0.380316853523254, 0.380201995372772, 0.380086869001389, 0.379971385002136, 0.379855543375015, 0.379739433526993, 0.379622966051102, 0.379506170749664, 0.379389107227325, 0.379271656274796, 0.379153907299042, 0.379035860300064, 0.378917455673218, 0.37879878282547, 0.378679722547531, 0.378560334444046, 0.378440678119659, 0.378320664167404, 0.378200381994247, 0.3780797123909, 0.377958744764328, 0.37783744931221, 0.377715826034546, 0.377593874931335, 0.377471655607224, 0.377349019050598, 0.377226173877716, 0.377102911472321, 0.376979410648346, 0.376855492591858, 0.376731276512146, 0.376606792211533, 0.376481950283051, 0.376356810331345, 0.37623131275177, 0.376105487346649, 0.375979393720627, 0.375852912664413, 0.375726133584976, 0.375599056482315, 0.375471651554108, 0.375343888998032, 0.375215858221054, 0.375087469816208, 0.374958723783493, 0.374829709529877, 0.374700337648392, 0.374570667743683, 0.374440670013428, 0.374310344457626, 0.374179720878601, 0.374048739671707, 0.373917430639267, 0.373785823583603, 0.373653918504715, 0.373521625995636, 0.373389065265656, 0.373256146907806, 0.373122930526733, 0.372989386320114, 0.372855544090271, 0.372721344232559, 0.372586816549301, 0.372451961040497, 0.372316837310791, 0.372181355953217, 0.372045516967773, 0.371909409761429, 0.371772974729538, 0.371636211872101, 0.371499091386795, 0.371361672878265, 0.371223926544189, 0.37108588218689, 0.370947480201721, 0.370808780193329, 0.370669782161713, 0.370530396699905, 0.370390713214874, 0.370250761508942, 0.370110422372818, 0.369969815015793, 0.369828790426254, 0.369687527418137, 0.369545936584473, 0.369404017925262, 0.369261771440506, 0.369119137525558, 0.368976265192032, 0.368833065032959, 0.368689477443695, 0.368545651435852, 0.368401437997818, 0.368256896734238, 0.368112087249756, 0.367966949939728, 0.367821455001831, 0.36767566204071, 0.367529541254044, 0.367383122444153, 0.367236316204071, 0.367089211940765, 0.366941809654236, 0.36679407954216, 0.366646021604538, 0.36649763584137, 0.366348922252655, 0.366199910640717, 0.366050541400909, 0.365900903940201, 0.365750879049301, 0.365600556135178, 0.36544993519783, 0.365298956632614, 0.365147680044174, 0.36499610543251, 0.364844143390656, 0.364691913127899, 0.364539325237274, 0.364386439323425, 0.36423322558403, 0.364079684019089, 0.363925784826279, 0.363771617412567, 0.363617122173309, 0.363462299108505, 0.363307148218155, 0.363151669502258, 0.362995892763138, 0.362839758396149, 0.362683296203613, 0.362526506185532, 0.362369447946548, 0.362212032079697, 0.362054258584976, 0.361896246671677, 0.361737877130508, 0.361579149961472, 0.361420124769211, 0.361260771751404, 0.361101090908051, 0.360941112041473, 0.36078080534935, 0.360620200634003, 0.360459238290787, 0.360297948122025, 0.360136359930038, 0.359974384307861, 0.359812170267105, 0.359649568796158, 0.359486699104309, 0.359313786029816, 0.35913097858429, 0.358947962522507, 0.358764797449112, 0.35858142375946, 0.358397901058197, 0.358214288949966, 0.358030408620834, 0.357846438884735, 0.357662230730057, 0.357477933168411, 0.357293397188187, 0.357108741998672, 0.356923907995224, 0.356738865375519, 0.356553733348846, 0.356368362903595, 0.356182873249054, 0.355997234582901, 0.355811417102814, 0.355625361204147, 0.355439215898514, 0.355252891778946, 0.355066388845444, 0.35487973690033, 0.354692906141281, 0.354505896568298, 0.354318737983704, 0.354131430387497, 0.353943914175034, 0.353756248950958, 0.353568434715271, 0.353380441665649, 0.353192299604416, 0.353003978729248, 0.352815508842468, 0.352626800537109, 0.352438002824783, 0.352248996496201, 0.352059841156006, 0.351870566606522, 0.351681053638458, 0.351491391658783, 0.351301610469818, 0.351111620664597, 0.350921452045441, 0.35073110461235, 0.350540637969971, 0.350349992513657, 0.350159198045731, 0.349968194961548, 0.349777102470398, 0.349585741758347, 0.34939432144165, 0.349202662706375, 0.349010854959488, 0.348818868398666, 0.348626703023911, 0.348434388637543, 0.348241955041885, 0.348049283027649, 0.347856491804123, 0.347663521766663, 0.347470372915268, 0.347277075052261, 0.347083628177643, 0.346889972686768, 0.34669616818428, 0.346502244472504, 0.346308082342148, 0.34611377120018, 0.345919281244278, 0.345724701881409, 0.34552988409996, 0.3453349173069, 0.345139801502228, 0.344944477081299, 0.34474903345108, 0.344553381204605, 0.344357639551163, 0.344161659479141, 0.343965530395508, 0.343769252300262, 0.343572795391083, 0.343376159667969, 0.34317934513092, 0.34298238158226, 0.34278529882431, 0.342588007450104, 0.342390567064285, 0.34219291806221, 0.341995149850845, 0.341797202825546, 0.341599076986313, 0.34140083193779, 0.341202348470688, 0.341003745794296, 0.34080496430397, 0.34060600399971, 0.34040692448616, 0.340207636356354, 0.340008139610291, 0.33980855345726, 0.339608758687973, 0.339408844709396, 0.339208751916885, 0.339008450508118, 0.338808000087738, 0.338607400655746, 0.338406622409821, 0.338205695152283, 0.338004559278488, 0.337803304195404, 0.337601870298386, 0.337400257587433, 0.337198495864868, 0.336996555328369, 0.336794465780258, 0.336592197418213, 0.336389780044556, 0.336187183856964, 0.335984379053116, 0.335781455039978, 0.335578382015228, 0.335375130176544, 0.335171699523926, 0.334968090057373, 0.334764301776886, 0.334560394287109, 0.334356307983398, 0.334152042865753, 0.333947598934174, 0.333743035793304, 0.333538264036179, 0.333333313465118, 0.333128273487091, 0.332923054695129, 0.332717597484589, 0.332511991262436, 0.332306236028671, 0.332100301980972, 0.331894218921661, 0.331687957048416, 0.331481546163559, 0.33127498626709, 0.331068247556686, 0.330861300230026, 0.330654263496399, 0.330446988344193, 0.330239564180374, 0.330031991004944, 0.329824268817902, 0.329616367816925, 0.329408258199692, 0.329200059175491, 0.328991651535034, 0.32878303527832, 0.328574270009995, 0.328365415334702, 0.328156292438507, 0.327947080135345, 0.327737659215927, 0.327528119087219, 0.327318370342255, 0.327108472585678, 0.32689842581749, 0.326688140630722, 0.326477736234665, 0.326267212629318, 0.326056480407715, 0.325845539569855, 0.325634479522705, 0.325423240661621, 0.325211882591248, 0.325000286102295, 0.324788570404053, 0.324576675891876, 0.324364602565765, 0.324152410030365, 0.323939979076385, 0.323727399110794, 0.323514729738235, 0.323301821947098, 0.323088765144348, 0.322875529527664, 0.322662144899368, 0.322448581457138, 0.322234869003296, 0.322020947933197, 0.321806907653809, 0.321592718362808, 0.321378320455551, 0.32116374373436, 0.320949047803879, 0.320734173059464, 0.320519119501114, 0.32030388712883, 0.320088535547256, 0.319873005151749, 0.319657266139984, 0.319441378116608, 0.319225341081619, 0.319009125232697, 0.318792790174484, 0.318576246500015, 0.318359464406967, 0.31814256310463, 0.317925542593002, 0.317708373069763, 0.317490994930267, 0.317273437976837, 0.317055761814117, 0.316837877035141, 0.316619873046875, 0.31640163064003, 0.316183269023895, 0.315964728593826, 0.315746039152145, 0.315527200698853, 0.315308153629303, 0.315088957548141, 0.314869552850723, 0.314650028944016, 0.314430326223373, 0.314210474491119, 0.313990414142609, 0.313770234584808, 0.313549876213074, 0.313329368829727, 0.313108712434769, 0.312887847423553, 0.312666773796082, 0.312445610761642, 0.312224268913269, 0.312002718448639, 0.311781018972397, 0.311559170484543, 0.311337172985077, 0.311114966869354, 0.310892581939697, 0.310670077800751, 0.31044739484787, 0.310224592685699, 0.31000155210495, 0.309778332710266, 0.309554994106293, 0.309331476688385, 0.309107810258865, 0.308883935213089, 0.308659940958023, 0.308435797691345, 0.308211475610733, 0.307986944913864, 0.307762205600739, 0.307537376880646, 0.307312369346619, 0.307087242603302, 0.306861877441406, 0.306636363267899, 0.306410700082779, 0.306184887886047, 0.305958837270737, 0.305732637643814, 0.305506318807602, 0.305279821157455, 0.305053174495697, 0.304826319217682, 0.304599344730377, 0.304372161626816, 0.304144829511642, 0.303917348384857, 0.303689658641815, 0.303461819887161, 0.303233802318573, 0.303005665540695, 0.302777320146561, 0.302548855543137, 0.302320182323456, 0.302091360092163, 0.301862359046936, 0.301633208990097, 0.301403850317001, 0.301174372434616, 0.300944715738297, 0.300714880228043, 0.300484895706177, 0.300254762172699, 0.300024420022964, 0.29979395866394, 0.29956328868866, 0.299332499504089, 0.29910147190094, 0.298870354890823, 0.29863902926445, 0.298407524824142, 0.298175871372223, 0.297944068908691, 0.297712117433548, 0.297479927539825, 0.297247618436813, 0.297015160322189, 0.296782463788986, 0.296549677848816, 0.296316683292389, 0.296083569526672, 0.295850247144699, 0.295616775751114, 0.295383125543594, 0.295149356126785, 0.294915407896042, 0.294681191444397, 0.294446915388107, 0.294212430715561, 0.293977826833725, 0.293743014335632, 0.293508023023605, 0.293272912502289, 0.293037593364716, 0.292802155017853, 0.292566508054733, 0.292330682277679, 0.292094707489014, 0.291858613491058, 0.291622310876846, 0.291385859251022, 0.291149228811264, 0.290912389755249, 0.290675491094589, 0.29043835401535, 0.290201008319855, 0.28996354341507, 0.289725929498672, 0.289488136768341, 0.28925022482872, 0.28901207447052, 0.28877380490303, 0.288535326719284, 0.288296699523926, 0.288057923316956, 0.287818968296051, 0.287579864263535, 0.287340551614761, 0.287101119756699, 0.286861509084702, 0.28662171959877, 0.286381751298904, 0.286141693592072, 0.285901367664337, 0.285660922527313, 0.285420298576355, 0.285179525613785, 0.28493857383728, 0.284697473049164, 0.284456193447113, 0.284214735031128, 0.283973157405853, 0.283731341362, 0.283489435911179, 0.283247292041779, 0.283005028963089, 0.282762587070465, 0.282519996166229, 0.282277196645737, 0.282034277915955, 0.281791210174561, 0.28154793381691, 0.281304478645325, 0.281060844659805, 0.280817121267319, 0.280573159456253, 0.280329048633575, 0.280084788799286, 0.279840379953384, 0.279595792293549, 0.279350996017456, 0.279106110334396, 0.27886101603508, 0.278615713119507, 0.278370320796967, 0.278124690055847, 0.277878940105438, 0.277633041143417, 0.277386903762817, 0.27714067697525, 0.276894271373749, 0.276647657155991, 0.276400923728943, 0.276153951883316, 0.275906890630722, 0.275659620761871, 0.275412231683731, 0.275164633989334, 0.274916887283325, 0.274668961763382, 0.274420917034149, 0.27417266368866, 0.273924201726913, 0.273675620555878, 0.273426920175552, 0.273177981376648, 0.272928893566132, 0.272679626941681, 0.272430270910263, 0.272180676460266, 0.271930932998657, 0.271681010723114, 0.271430939435959, 0.271180689334869, 0.270930290222168, 0.270679712295532, 0.270428985357285, 0.270178079605103, 0.269927024841309, 0.269675761461258, 0.269424378871918, 0.269172787666321, 0.268921047449112, 0.268669128417969, 0.268417090177536, 0.268164843320847, 0.267912447452545, 0.267659902572632, 0.267407149076462, 0.267154276371002, 0.266901165246964, 0.266647964715958, 0.266394555568695, 0.266140997409821, 0.265887290239334, 0.265633404254913, 0.265379339456558, 0.265125095844269, 0.26487073302269, 0.264616161584854, 0.264361411333084, 0.264106512069702, 0.263851463794708, 0.263596266508102, 0.263340890407562, 0.263085335493088, 0.262829601764679, 0.262573719024658, 0.262317687273026, 0.262061446905136, 0.261805057525635, 0.261548489332199, 0.261291772127151, 0.261034905910492, 0.26077789068222, 0.26052063703537, 0.260263293981552, 0.260005742311478, 0.259748041629791, 0.259490132331848, 0.259232074022293, 0.258973896503448, 0.258715510368347, 0.258456975221634, 0.258198291063309, 0.257939398288727, 0.257680386304855, 0.257421135902405, 0.257161796092987, 0.256902247667313, 0.256642550230026, 0.256382644176483, 0.256122618913651, 0.255862414836884, 0.255602031946182, 0.255341529846191, 0.255080819129944, 0.254819959402084, 0.254558920860291, 0.254297703504562, 0.254036337137222, 0.25377482175827, 0.253513127565384, 0.253251284360886, 0.252989232540131, 0.252727061510086, 0.252464711666107, 0.252202183008194, 0.251939475536346, 0.251676619052887, 0.251413583755493, 0.251150399446487, 0.250887036323547, 0.250623553991318, 0.250359863042831, 0.250096023082733, 0.249831974506378, 0.249567776918411, 0.249303430318832, 0.249038904905319, 0.248774230480194, 0.248509392142296, 0.248244360089302, 0.247979193925858, 0.247713834047318, 0.247448354959488, 0.247183471918106, 0.2469192892313, 0.246655210852623, 0.24639119207859, 0.246127277612686, 0.245863378047943, 0.245599567890167, 0.245335817337036, 0.24507212638855, 0.244808524847031, 0.24454490840435, 0.244281396269798, 0.244017958641052, 0.243754550814629, 0.243491247296333, 0.243228033185005, 0.242964819073677, 0.242701679468155, 0.242438614368439, 0.242175623774529, 0.241912677884102, 0.241649776697159, 0.241386920213699, 0.241124168038368, 0.240861490368843, 0.240598872303963, 0.240336313843727, 0.240073785185814, 0.239811345934868, 0.239548981189728, 0.239286616444588, 0.239024370908737, 0.23876217007637, 0.238500013947487, 0.238237991929054, 0.237975969910622, 0.237713992595673, 0.237452119588852, 0.237190306186676, 0.236928537487984, 0.236666798591614, 0.236405208706856, 0.236143633723259, 0.235882088541985, 0.235620692372322, 0.235359311103821, 0.235097974538803, 0.234836727380753, 0.234575510025024, 0.234314367175102, 0.234053283929825, 0.233792275190353, 0.233531311154366, 0.233270421624184, 0.233009621500969, 0.232748851180077, 0.23248815536499, 0.23222753405571, 0.231966897845268, 0.231706440448761, 0.231445997953415, 0.23118557035923, 0.230925261974335, 0.230665013194084, 0.230404824018478, 0.230144679546356, 0.229884624481201, 0.22962461411953, 0.229364603757858, 0.22910475730896, 0.2288448959589, 0.228585138916969, 0.228325456380844, 0.228065803647041, 0.227806255221367, 0.227546751499176, 0.22728730738163, 0.227027893066406, 0.226768538355827, 0.226509317755699, 0.226250097155571, 0.225990936160088, 0.225731879472733, 0.225472867488861, 0.225213930010796, 0.224955037236214, 0.224696218967438, 0.224437400698662, 0.224178701639175, 0.223920091986656, 0.223661497235298, 0.223403006792068, 0.22314453125, 0.22288616001606, 0.222627848386765, 0.222369566559792, 0.222111344337463, 0.22185318171978, 0.221595108509064, 0.221337139606476, 0.221079170703888, 0.220821276307106, 0.22056345641613, 0.220305666327477, 0.220047995448112, 0.21979033946991, 0.21953272819519, 0.219275206327438, 0.219017744064331, 0.218760401010513, 0.218503057956696, 0.218245804309845, 0.217988595366478, 0.217731431126595, 0.217474371194839, 0.217217355966568, 0.21696038544178, 0.216703489422798, 0.216446653008461, 0.216189906001091, 0.215933158993721, 0.215676560997963, 0.215419977903366, 0.215163454413414, 0.21490703523159, 0.214650601148605, 0.214394256472588, 0.214137986302376, 0.213881775736809, 0.213625684380531, 0.213369578123093, 0.213113531470299, 0.212857574224472, 0.212601691484451, 0.212345898151398, 0.212090075016022, 0.211834400892258, 0.211578741669655, 0.211323156952858, 0.211067661643028, 0.210812196135521, 0.21055680513382, 0.210301443934441, 0.210046172142029, 0.209790974855423, 0.209535866975784, 0.209280744194984, 0.209025695919991, 0.208770751953125, 0.208515897393227, 0.208261057734489, 0.208006247878075, 0.207751572132111, 0.207496911287308, 0.207242324948311, 0.20698781311512, 0.206733331084251, 0.20647893846035, 0.206224620342255, 0.205970376729965, 0.205716133117676, 0.205462008714676, 0.205207899212837, 0.204953864216805, 0.204699903726578, 0.204446032643318, 0.204192191362381, 0.203938409686089, 0.203684687614441, 0.203431084752083, 0.203177452087402, 0.202923953533173, 0.202670484781265, 0.202417060732841, 0.202163755893707, 0.201910480856895, 0.201657295227051, 0.201404109597206, 0.20115102827549, 0.200898036360741, 0.200645074248314, 0.200392156839371, 0.20013926923275, 0.199886500835419, 0.199633851647377, 0.199381172657013, 0.199128597974777, 0.198876038193703, 0.198623582720757, 0.198371201753616, 0.198118880391121, 0.19786661863327, 0.197614386677742, 0.197362184524536, 0.197110131382942, 0.196858152747154, 0.196606159210205, 0.196354240179062, 0.196102395653725, 0.195850640535355, 0.195598945021629, 0.195347249507904, 0.195095658302307, 0.194844126701355, 0.194592669606209, 0.194341316819191, 0.194089949131012, 0.193838655948639, 0.193587467074394, 0.193336352705956, 0.193085253238678, 0.192834183573723, 0.192583233118057, 0.192332297563553, 0.192081496119499, 0.191830724477768, 0.191579982638359, 0.191329345107079, 0.19107873737812, 0.190828263759613, 0.190577760338783, 0.190327346324921, 0.190076991915703, 0.189826726913452, 0.189576521515846, 0.189326360821724, 0.189076259732246, 0.188826262950897, 0.188576281070709, 0.18832640349865, 0.18807652592659, 0.187826737761497, 0.187577024102211, 0.187327370047569, 0.187077805399895, 0.18682824075222, 0.186578810214996, 0.186329364776611, 0.186080053448677, 0.185830771923065, 0.185581564903259, 0.185332387685776, 0.185083284974098, 0.184834256768227, 0.184585317969322, 0.184336394071579, 0.184087544679642, 0.183838754892349, 0.183590054512024, 0.183341383934021, 0.183092787861824, 0.182844281196594, 0.182595804333687, 0.182347372174263, 0.18209907412529, 0.181850776076317, 0.181602567434311, 0.181354403495789, 0.181106299161911, 0.180858299136162, 0.180610314011574, 0.180362388491631, 0.180114552378654, 0.179866760969162, 0.179619058966637, 0.179371431469917, 0.179123803973198, 0.178876295685768, 0.178628787398338, 0.178381398320198, 0.178134068846703, 0.177886769175529, 0.177639544010162, 0.177392363548279, 0.177145317196846, 0.176898285746574, 0.176651313900948, 0.176404401659966, 0.176157504320145, 0.175910770893097, 0.175664007663727, 0.175417348742485, 0.175170764327049, 0.174924209713936, 0.174677759408951, 0.174431383609772, 0.174185022711754, 0.173938691616058, 0.173692464828491, 0.173446357250214, 0.173200249671936, 0.172954216599464, 0.172708243131638, 0.172462329268456, 0.172216504812241, 0.171970710158348, 0.171724990010262, 0.171479269862175, 0.171233668923378, 0.170988202095032, 0.170742720365524, 0.170497298240662, 0.170251935720444, 0.170006647706032, 0.169761463999748, 0.169516280293465, 0.169271156191826, 0.169026121497154, 0.168781146407127, 0.168536245822906, 0.168291434645653, 0.168046623468399, 0.167801901698112, 0.167557209730148, 0.167312651872635, 0.167068123817444, 0.166823595762253, 0.166579186916351, 0.166334837675095, 0.166090548038483, 0.165846362709999, 0.165602177381516, 0.165358081459999, 0.165114045143127, 0.164870098233223, 0.164626151323318, 0.164382293820381, 0.164138495922089, 0.163894787430763, 0.163651138544083, 0.163407519459724, 0.163163989782333, 0.162920504808426, 0.162677094340324, 0.16243377327919, 0.162190452218056, 0.161947220563889, 0.161704063415527, 0.161460965871811, 0.161217927932739, 0.160974964499474, 0.16073203086853, 0.160489186644554, 0.1602463722229, 0.160003691911697, 0.159760981798172, 0.159518405795097, 0.159275829792023, 0.159033372998238, 0.158790946006775, 0.158548623323441, 0.158306330442429, 0.158064097166061, 0.157821923494339, 0.157579824328423, 0.157337784767151, 0.157095804810524, 0.156853884458542, 0.156612023711205, 0.156370252370834, 0.156128540635109, 0.155886843800545, 0.155645236372948, 0.155403703451157, 0.155162185430527, 0.154920771718025, 0.15467943251133, 0.15443816781044, 0.15419690310955, 0.153955772519112, 0.153714656829834, 0.153473615646362, 0.153232634067535, 0.152991697192192, 0.152750849723816, 0.152510061860085, 0.152269348502159, 0.152028650045395, 0.151788055896759, 0.151547521352768, 0.151307061314583, 0.151066601276398, 0.150826275348663, 0.150585949420929, 0.150345757603645, 0.150105565786362, 0.149865418672562, 0.149625390768051, 0.149385392665863, 0.149145543575287, 0.148905649781227, 0.148665875196457, 0.148426130414009, 0.148186445236206, 0.147946834564209, 0.14770732820034, 0.14746780693531, 0.14722840487957, 0.146989032626152, 0.146749779582024, 0.146510511636734, 0.146271362900734, 0.146032214164734, 0.145793184638023, 0.145554199814796, 0.145315274596214, 0.145076438784599, 0.144837632775307, 0.14459890127182, 0.144360259175301, 0.144121631979942, 0.143883049488068, 0.14364455640316, 0.143406108021736, 0.143167808651924, 0.142929509282112, 0.142691284418106, 0.142453089356422, 0.142214983701706, 0.141976967453957, 0.141738995909691, 0.141501009464264, 0.141263142228127, 0.141025349497795, 0.140787646174431, 0.140550017356873, 0.140312373638153, 0.140074849128723, 0.139837324619293, 0.139599904417992, 0.139362543821335, 0.139125213027, 0.138887956738472, 0.138650789856911, 0.1384137570858, 0.138176679611206, 0.13793970644474, 0.137702748179436, 0.137465864419937, 0.13722912967205, 0.13699235022068, 0.1367556899786, 0.136519059538841, 0.136282503604889, 0.136046081781387, 0.135809600353241, 0.135573282837868, 0.135336965322495, 0.135100692510605, 0.134864524006844, 0.134628444910049, 0.134392395615578, 0.134156376123428, 0.133920475840569, 0.13368459045887, 0.133448824286461, 0.133213073015213, 0.13297738134861, 0.132741779088974, 0.132506221532822, 0.132270738482475, 0.132035329937935, 0.131799936294556, 0.131564617156982, 0.131329447031021, 0.131094232201576, 0.130859136581421, 0.130624055862427, 0.1303890645504, 0.130154147744179, 0.129919245839119, 0.129684463143349, 0.129449725151062, 0.129215031862259, 0.128980472683907, 0.128745898604393, 0.128511413931847, 0.128276944160461, 0.128042593598366, 0.127808302640915, 0.127574026584625, 0.127339899539948, 0.127105742692947, 0.126871705055237, 0.126637741923332, 0.126403778791428, 0.12616990506649, 0.125936135649681, 0.125702351331711, 0.12546868622303, 0.125235080718994, 0.125001549720764, 0.124768041074276, 0.124534606933594, 0.124301262199879, 0.124067932367325, 0.123834721744061, 0.123601533472538, 0.123368382453918, 0.123135350644588, 0.122914656996727, 0.122706465423107, 0.122498467564583, 0.122290655970573, 0.122083015739918, 0.121875628829002, 0.121668323874474, 0.121461227536201, 0.121254362165928, 0.121047683060169, 0.120841190218925, 0.120634838938713, 0.120428711175919, 0.120222739875317, 0.120017021894455, 0.119811408221722, 0.119605988264084, 0.119400791823864, 0.119195751845837, 0.118991009891033, 0.118786327540874, 0.118581831455231, 0.118377543985844, 0.118173509836197, 0.117969565093517, 0.117765918374062, 0.117562331259251, 0.117358937859535, 0.117155835032463, 0.116952858865261, 0.116750083863735, 0.116547465324402, 0.116345062851906, 0.116142928600311, 0.11594083160162, 0.115738980472088, 0.115537337958813, 0.115335814654827, 0.115134581923485, 0.11493343859911, 0.114732563495636, 0.114531777799129, 0.114331223070621, 0.114130854606628, 0.113930746912956, 0.113730743527412, 0.113530889153481, 0.11333130300045, 0.11313184350729, 0.112932667136192, 0.112733535468578, 0.112534716725349, 0.112336024641991, 0.112137533724308, 0.11193922907114, 0.111741095781326, 0.111543148756027, 0.111345365643501, 0.111147835850716, 0.110950469970703, 0.110753290355206, 0.110556252300739, 0.110359460115433, 0.110162772238255, 0.109966345131397, 0.109770111739635, 0.109573982656002, 0.109378173947334, 0.109182380139828, 0.10898695141077, 0.108791582286358, 0.108596466481686, 0.108401589095592, 0.108206734061241, 0.108012169599533, 0.107817798852921, 0.107623592019081, 0.107429541647434, 0.10723565518856, 0.107042096555233, 0.106848560273647, 0.106655322015285, 0.106462232768536, 0.106269255280495, 0.106076598167419, 0.105884030461311, 0.105691716074944, 0.105499565601349, 0.105307653546333, 0.105115793645382, 0.104924261569977, 0.104732818901539, 0.10454161465168, 0.104350529611111, 0.104159668087959, 0.103968970477581, 0.103778503835201, 0.103588223457336, 0.103398144245148, 0.103208146989346, 0.103018455207348, 0.10282889008522, 0.10263954102993, 0.102450303733349, 0.102261334657669, 0.102072514593601, 0.101883910596371, 0.101695537567139, 0.101507291197777, 0.101319260895252, 0.101131334900856, 0.100943736732006, 0.100756205618382, 0.100568890571594, 0.100381731987, 0.100194841623306, 0.100008010864258, 0.0998215079307556, 0.09963508695364, 0.0994489043951035, 0.0992628857493401, 0.099077083170414, 0.0988914221525192, 0.0987059697508812, 0.0985206887125969, 0.0983356311917305, 0.0981507375836372, 0.0979660674929619, 0.0977815538644791, 0.0975972414016724, 0.0974130854010582, 0.0972291231155396, 0.097045324742794, 0.0968617796897888, 0.0966783612966537, 0.0964950770139694, 0.096312053501606, 0.0961292833089828, 0.0959466099739075, 0.09576416015625, 0.0955818742513657, 0.0953998118638992, 0.0952178239822388, 0.0950361713767052, 0.0948546007275581, 0.0946732461452484, 0.0944921523332596, 0.0943111926317215, 0.0941304117441177, 0.0939497724175453, 0.0937693864107132, 0.0935891047120094, 0.0934090688824654, 0.0932291969656944, 0.093049593269825, 0.0928699746727943, 0.092690721154213, 0.0925116613507271, 0.0923327505588531, 0.09215397387743, 0.0919754281640053, 0.0917970091104507, 0.0916189178824425, 0.091440849006176, 0.0912630707025528, 0.0910854265093803, 0.0909080356359482, 0.0907308161258698, 0.0905537158250809, 0.0903768762946129, 0.090200163424015, 0.0900236740708351, 0.0898473560810089, 0.0896711796522141, 0.0894952490925789, 0.0893194451928139, 0.0891438871622086, 0.0889685600996017, 0.0887933671474457, 0.0886183232069016, 0.0884435474872589, 0.088268868625164, 0.0880944430828094, 0.0879201218485832, 0.0877460837364197, 0.0875722020864487, 0.0873984545469284, 0.0872250273823738, 0.0870516747236252, 0.0868785455822945, 0.0867055580019951, 0.0865327790379524, 0.0863601937890053, 0.0861877650022507, 0.0860155299305916, 0.0858434960246086, 0.0856716558337212, 0.0855000615119934, 0.085328571498394, 0.0851573050022125, 0.0849861353635788, 0.0848152935504913, 0.0846445113420486, 0.084474042057991, 0.084303617477417, 0.084133505821228, 0.0839634761214256, 0.0837937593460083, 0.0836241245269775, 0.0834547653794289, 0.083285465836525, 0.0831164568662643, 0.0829475149512291, 0.0827788487076759, 0.0826103612780571, 0.0824420601129532, 0.0822739154100418, 0.0821060314774513, 0.0819382816553116, 0.0817707851529121, 0.0816033855080605, 0.0814361795783043, 0.081269234418869, 0.0811024084687233, 0.0809357836842537, 0.0807693228125572, 0.0806030780076981, 0.0804370641708374, 0.0802712216973305, 0.0801054984331131, 0.079939991235733, 0.0797746255993843, 0.0796095207333565, 0.0794445276260376, 0.0792798101902008, 0.0791151821613312, 0.0789508149027824, 0.0787866711616516, 0.0786226466298103, 0.0784587934613228, 0.0782952010631561, 0.078131690621376, 0.077968455851078, 0.0778053477406502, 0.0776424556970596, 0.0774796977639198, 0.0773172304034233, 0.0771549120545387, 0.0769927725195885, 0.0768307819962502, 0.076668992638588, 0.0765073597431183, 0.0763460248708725, 0.0761847421526909, 0.0760237276554108, 0.0758628323674202, 0.0757022351026535, 0.0755418017506599, 0.0753815174102783, 0.0752213671803474, 0.0750615075230598, 0.074901819229126, 0.0747422128915787, 0.0745829045772552, 0.0744236931204796, 0.0742647349834442, 0.0741058737039566, 0.07394739985466, 0.0737889334559441, 0.0736306756734848, 0.0734726190567017, 0.0733147636055946, 0.0731570273637772, 0.072999581694603, 0.0728422105312347, 0.0726851522922516, 0.0725281983613968, 0.0723715648055077, 0.0722149536013603, 0.0720586106181145, 0.0719023570418358, 0.0717463940382004, 0.0715905949473381, 0.071434959769249, 0.0712794810533524, 0.0711242035031319, 0.0709691420197487, 0.0708143413066864, 0.0706596076488495, 0.0705050975084305, 0.0703507512807846, 0.070196621119976, 0.0700426697731018, 0.0698888972401619, 0.0697353184223175, 0.0695819333195686, 0.0694286897778511, 0.0692757442593575, 0.0691229775547981, 0.0689703077077866, 0.0688178613781929, 0.068665511906147, 0.0685134828090668, 0.0683615505695343, 0.0682098716497421, 0.0680583342909813, 0.0679070055484772, 0.0677558556199074, 0.0676048845052719, 0.0674540847539902, 0.0673035010695457, 0.0671530961990356, 0.0670028626918793, 0.066852830350399, 0.0667029917240143, 0.0665532872080803, 0.0664038360118866, 0.0662545785307884, 0.0661055147647858, 0.0659565106034279, 0.0658078342676163, 0.0656592547893524, 0.0655109286308289, 0.065362736582756, 0.0652147755026817, 0.0650669261813164, 0.0649193152785301, 0.0647718980908394, 0.064624696969986, 0.0644776001572609, 0.0643307939171791, 0.0641840845346451, 0.0640375912189484, 0.0638912320137024, 0.0637451335787773, 0.0635992661118507, 0.063453420996666, 0.0633080005645752, 0.0631625726819038, 0.063017413020134, 0.0628723725676537, 0.0627276003360748, 0.0625829175114632, 0.0624384880065918, 0.0622942261397839, 0.0621501542627811, 0.0620062202215195, 0.0618625991046429, 0.061719074845314, 0.0615757815539837, 0.0614325813949108, 0.0612896382808685, 0.0611468553543091, 0.0610043033957481, 0.0608618780970573, 0.0607196725904942, 0.0605776347219944, 0.0604359172284603, 0.0602942034602165, 0.0601527765393257, 0.0600114762783051, 0.0598704069852829, 0.0597294606268406, 0.0595888048410416, 0.0594482161104679, 0.0593078508973122, 0.0591676495969296, 0.0590278320014477, 0.0588879510760307, 0.0587484277784824, 0.0586089678108692, 0.0584697611629963, 0.0583306886255741, 0.0581918656826019, 0.0580532103776932, 0.0579147189855576, 0.0577764473855495, 0.0576383732259274, 0.0575004555284977, 0.0573627017438412, 0.0572251752018929, 0.0570878051221371, 0.0569506362080574, 0.0568135902285576, 0.0566767677664757, 0.0565401427447796, 0.0564037747681141, 0.056267537176609, 0.0561315231025219, 0.0559956058859825, 0.0558599457144737, 0.0557244159281254, 0.0555891096591949, 0.0554539635777473, 0.0553190484642982, 0.055184293538332, 0.0550497621297836, 0.0549153871834278, 0.0547812096774578, 0.0546471960842609, 0.0545133762061596, 0.0543797127902508, 0.0542463064193726, 0.0541130006313324, 0.0539799518883228, 0.0538469962775707, 0.0537143088877201, 0.0535818636417389, 0.0534495264291763, 0.053317379206419, 0.0531854256987572, 0.0530536994338036, 0.0529220663011074, 0.0527906939387321, 0.0526594780385494, 0.0525284260511398, 0.0523976050317287, 0.0522670336067677, 0.0521365664899349, 0.0520062558352947, 0.0518761686980724, 0.051746279001236, 0.0516165159642696, 0.0514869764447212, 0.0513576008379459, 0.0512284860014915, 0.0510994642972946, 0.0509707629680634, 0.0508421622216702, 0.0507137551903725, 0.0505854748189449, 0.050457451492548, 0.0503295548260212, 0.050201952457428, 0.0500743798911572, 0.0499471314251423, 0.0498200096189976, 0.0496931783854961, 0.0495663844048977, 0.0494399033486843, 0.0493134632706642, 0.0491872765123844, 0.0490612834692001, 0.0489354841411114, 0.0488098151981831, 0.048684436827898, 0.0485591515898705, 0.0484341606497765, 0.048309326171875, 0.0481845922768116, 0.0480601415038109, 0.0479357950389385, 0.0478117056190968, 0.0476876795291901, 0.0475640073418617, 0.0474403649568558, 0.0473170131444931, 0.0471938923001289, 0.0470708981156349, 0.0469479970633984, 0.0468254201114178, 0.0467029064893723, 0.0465806499123573, 0.0464585609734058, 0.0463366881012917, 0.0462149195373058, 0.046093475073576, 0.045972153544426, 0.0458509884774685, 0.0457300283014774, 0.0456092841923237, 0.0454886741936207, 0.0453683212399483, 0.0452480651438236, 0.0451280698180199, 0.0450081638991833, 0.0448885187506676, 0.0447691008448601, 0.0446498431265354, 0.0445306859910488, 0.0444118417799473, 0.0442930683493614, 0.0441745519638062, 0.0440561324357986, 0.0439380668103695, 0.043820034712553, 0.0437022559344769, 0.0435847714543343, 0.0434672869741917, 0.0433500893414021, 0.0432329922914505, 0.0431161820888519, 0.0429994352161884, 0.0428829863667488, 0.0427666902542114, 0.0426505915820599, 0.0425346530973911, 0.042418971657753, 0.0423033833503723, 0.0421879962086678, 0.04208068177104, 0.0419814847409725, 0.0418823659420013, 0.0417834930121899, 0.0416846610605717, 0.0415860563516617, 0.0414875559508801, 0.0413892902433872, 0.0412910729646683, 0.0411930680274963, 0.0410951413214207, 0.0409974567592144, 0.0408998355269432, 0.0408024080097675, 0.0407050997018814, 0.0406079888343811, 0.0405109338462353, 0.0404141396284103, 0.0403174050152302, 0.0402209237217903, 0.0401244983077049, 0.0400282628834248, 0.039932157844305, 0.0398361831903458, 0.0397404320538044, 0.0396447293460369, 0.0395492501556873, 0.0394538715481758, 0.0393586866557598, 0.0392636060714722, 0.0391687601804733, 0.0390739478170872, 0.0389793701469898, 0.0388848781585693, 0.0387905761599541, 0.0386963859200478, 0.0386023744940758, 0.0385084897279739, 0.0384147725999355, 0.0383211672306061, 0.0382278114557266, 0.0381344966590405, 0.0380414016544819, 0.0379483886063099, 0.0378555692732334, 0.0377628803253174, 0.0376703701913357, 0.0375779382884502, 0.0374857448041439, 0.0373936370015144, 0.0373017527163029, 0.0372099503874779, 0.0371183082461357, 0.0370267778635025, 0.0369354896247387, 0.0368442498147488, 0.0367532223463058, 0.0366622693836689, 0.0365715771913528, 0.0364809334278107, 0.0363905169069767, 0.036300178617239, 0.0362100824713707, 0.0361201167106628, 0.0360302291810513, 0.0359405353665352, 0.0358509384095669, 0.035761583596468, 0.0356722772121429, 0.0355831831693649, 0.0354941971600056, 0.0354054197669029, 0.0353167280554771, 0.0352282412350178, 0.0351398400962353, 0.0350516401231289, 0.0349635295569897, 0.0348756387829781, 0.0347878187894821, 0.034700233489275, 0.034612700343132, 0.0345254242420197, 0.0344382263720036, 0.0343512259423733, 0.0342643037438393, 0.0341776087880135, 0.0340909920632839, 0.0340045876801014, 0.0339182913303375, 0.0338321588933468, 0.0337461233139038, 0.0336602963507175, 0.0335745848715305, 0.0334891118109226, 0.0334036238491535, 0.0333184413611889, 0.0332333073019981, 0.0331483855843544, 0.0330635569989681, 0.0329789221286774, 0.0328944660723209, 0.0328100584447384, 0.0327258743345737, 0.0326418057084084, 0.0325578935444355, 0.0324741490185261, 0.0323905609548092, 0.0323070697486401, 0.0322237908840179, 0.0321405902504921, 0.0320575833320618, 0.0319747030735016, 0.031892005354166, 0.0318094156682491, 0.0317270047962666, 0.0316447094082832, 0.031562652438879, 0.0314806140959263, 0.0313988141715527, 0.0313170962035656, 0.0312356036156416, 0.0311541762202978, 0.0310729574412107, 0.0309918690472841, 0.0309109557420015, 0.0308301392942667, 0.0307495500892401, 0.0306690260767937, 0.0305887255817652, 0.0305085070431232, 0.0304284952580929, 0.0303486119955778, 0.030268831178546, 0.0301891900599003, 0.0301097929477692, 0.0300304405391216, 0.0299513023346663, 0.0298723410815001, 0.0297934915870428, 0.0297148171812296, 0.0296362247318029, 0.0295578259974718, 0.029479555785656, 0.0294014327228069, 0.0293234679847956, 0.0292456801980734, 0.0291679594665766, 0.0290905255824327, 0.0290131419897079, 0.0289359204471111, 0.0288588255643845, 0.0287819262593985, 0.0287051219493151, 0.0286285281181335, 0.0285520143806934, 0.0284757427871227, 0.0283995177596807, 0.0283235032111406, 0.0282476004213095, 0.0281719099730253, 0.0280962958931923, 0.0280208960175514, 0.0279455576092005, 0.0278704781085253, 0.0277954135090113, 0.0277206413447857, 0.0276459138840437, 0.0275713838636875, 0.0274969786405563, 0.027422770857811, 0.0273486264050007, 0.0272747036069632, 0.0272008813917637, 0.0271272677928209, 0.0270537324249744, 0.026980409398675, 0.0269072335213423, 0.0268341340124607, 0.0267612785100937, 0.0266884695738554, 0.0266159027814865, 0.026543416082859, 0.0264711398631334, 0.026398928835988, 0.0263269431889057, 0.0262550339102745, 0.0261833537369967, 0.0261117871850729, 0.0260403491556644, 0.0259690545499325, 0.0258979555219412, 0.0258269663900137, 0.025756174698472, 0.0256854742765427, 0.0256149861961603, 0.025544548407197, 0.0254743490368128, 0.0254042483866215, 0.0253343246877193, 0.0252645295113325, 0.0251948945224285, 0.0251253731548786, 0.0250561088323593, 0.024986894801259, 0.0249178726226091, 0.024848947301507, 0.0247802305966616, 0.0247116778045893, 0.0246431529521942, 0.0245748572051525, 0.0245067216455936, 0.0244386829435825, 0.0243708845227957, 0.0243032164871693, 0.0242356453090906, 0.024168249219656, 0.0241009686142206, 0.0240338947623968, 0.0239668879657984, 0.0239000730216503, 0.0238334182649851, 0.0237669106572866, 0.0237005148082972, 0.0236343760043383, 0.0235682558268309, 0.023502342402935, 0.0234365612268448, 0.0233709681779146, 0.0233054589480162, 0.0232401415705681, 0.0231749713420868, 0.0231099613010883, 0.0230450481176376, 0.0229803435504436, 0.0229157377034426, 0.0228513553738594, 0.0227870382368565, 0.0227229129523039, 0.0226589031517506, 0.0225951001048088, 0.0225313492119312, 0.0224678684026003, 0.0224044360220432, 0.022341214120388, 0.0222781226038933, 0.0222152210772038, 0.0221523717045784, 0.0220897290855646, 0.0220272168517113, 0.0219648964703083, 0.0219026412814856, 0.0218406114727259, 0.0217787753790617, 0.0217169392853975, 0.0216553919017315, 0.0215938948094845, 0.0215326398611069, 0.0214714482426643, 0.0214104503393173, 0.0213495641946793, 0.0212888866662979, 0.0212282612919807, 0.0211678724735975, 0.021107567474246, 0.0210474729537964, 0.0209874883294106, 0.0209276974201202, 0.0208679419010878, 0.0208084881305695, 0.0207491032779217, 0.0206899084150791, 0.0206307638436556, 0.0205718409270048, 0.020513016730547, 0.0204544216394424, 0.0203959215432405, 0.0203376114368439, 0.0202794186770916, 0.0202214010059834, 0.0201634615659714, 0.0201057661324739, 0.0200481340289116, 0.0199907459318638, 0.0199334863573313, 0.0198762733489275, 0.019819239154458, 0.0197624452412128, 0.0197057016193867, 0.0196491312235594, 0.0195928234606981, 0.0195365138351917, 0.0194804426282644, 0.0194244738668203, 0.0193687118589878, 0.0193129498511553, 0.019257478415966, 0.0192021001130342, 0.0191469173878431, 0.0190918184816837, 0.0190369077026844, 0.0189821310341358, 0.0189275611191988, 0.0188730377703905, 0.0188187435269356, 0.0187645424157381, 0.0187105368822813, 0.0186566300690174, 0.0186029430478811, 0.0185493566095829, 0.0184959322214127, 0.0184425860643387, 0.018389530479908, 0.0183365065604448, 0.0182837266474962, 0.0182310082018375, 0.018178453668952, 0.0181260239332914, 0.0180738233029842, 0.0180217046290636, 0.0179698243737221, 0.0179180596023798, 0.0178663395345211, 0.0178148970007896, 0.0177635494619608, 0.017712265253067, 0.0176612567156553, 0.0176103748381138, 0.0175596084445715, 0.0175090339034796, 0.0174585562199354, 0.0174082405865192, 0.0173580199480057, 0.0173081066459417, 0.0172582101076841, 0.0172085370868444, 0.017158929258585, 0.0171095319092274, 0.0170602146536112, 0.0170111376792192, 0.0169621426612139, 0.0169133581221104, 0.0168646201491356, 0.0168161075562239, 0.0167677234858274, 0.0167195666581392, 0.0166714414954185, 0.0166235100477934, 0.0165757071226835, 0.0165281128138304, 0.0164806172251701, 0.0164333134889603, 0.0163860749453306, 0.0163390431553125, 0.0162921436131001, 0.0162454675883055, 0.0161988418549299, 0.0161524564027786, 0.0161060709506273, 0.016059959307313, 0.0160140097141266, 0.0159681402146816, 0.0159223843365908, 0.0158768519759178, 0.0158314164727926, 0.015786224976182, 0.0157411769032478, 0.0156961772590876, 0.0156513713300228, 0.0156066603958607, 0.0155622093006968, 0.0155178215354681, 0.015473660081625, 0.0154295302927494, 0.0153856258839369, 0.0153418350964785, 0.0152982855215669, 0.0152548002079129, 0.0152115095406771, 0.01516826543957, 0.0151252634823322, 0.0150823909789324, 0.0150396944954991, 0.0149970632046461, 0.0149546582251787, 0.0149123491719365, 0.0148702496662736, 0.0148282628506422, 0.0147865014150739, 0.0147447241470218, 0.0147032048553228, 0.014661799184978, 0.0146206170320511, 0.0145795000717044, 0.0145385451614857, 0.0144977020099759, 0.0144570842385292, 0.014416660182178, 0.0143763171508908, 0.014336135238409, 0.0142960343509912, 0.0142560917884111, 0.0142163932323456, 0.0141768399626017, 0.0141373025253415, 0.0140980230644345, 0.0140588385984302, 0.0140198655426502, 0.0139809716492891, 0.0139423524960876, 0.0139037007465959, 0.0138653060421348, 0.0138270417228341, 0.0137889375910163, 0.0137509470805526, 0.0137131167575717, 0.0136754000559449, 0.013637924566865, 0.0136005450040102, 0.0135633442550898, 0.0135262394323945, 0.013489343225956, 0.0134525448083878, 0.0134159382432699, 0.0133794452995062, 0.0133430827409029, 0.0133068794384599, 0.0132708866149187, 0.0132349748164415, 0.0131992697715759, 0.013163679279387, 0.0131282191723585, 0.0130929024890065, 0.0130578111857176, 0.0130227683112025, 0.0129879834130406, 0.012953263707459, 0.01291867159307, 0.012884289957583, 0.012850085273385, 0.0128160249441862, 0.0127819497138262, 0.0127482432872057, 0.0127145536243916, 0.0126811070367694, 0.012647707015276, 0.0126144532114267, 0.0125813763588667, 0.0125485090538859, 0.012515720911324, 0.0124831609427929, 0.0124506624415517, 0.0124183278530836, 0.0123861525207758, 0.0123541541397572, 0.0123222852125764, 0.0122905792668462, 0.0122589506208897, 0.0122275333851576, 0.0121962456032634, 0.0121651506051421, 0.0121341506019235, 0.0121032977476716, 0.0120726199820638, 0.0120421219617128, 0.0120117021724582, 0.0119815254583955, 0.011951332911849, 0.0119214467704296, 0.0118916081264615, 0.0118620274588466, 0.0118325101211667, 0.0118032041937113, 0.0117740258574486, 0.0117449443787336, 0.011716072447598, 0.0116873290389776, 0.0116586349904537, 0.0116302138194442, 0.0116019546985626, 0.0115737915039062, 0.0115458052605391, 0.0115179168060422, 0.0114902043715119, 0.0114626055583358, 0.0114352647215128, 0.0114079704508185, 0.0113809192553163, 0.011353868059814, 0.0113270739093423, 0.0113003933802247, 0.0112738898023963, 0.011247499845922, 0.0112213175743818, 0.0111951697617769, 0.0111692938953638, 0.011143515817821, 0.0111179305240512, 0.0110923610627651, 0.0110670831054449, 0.0110418675467372, 0.0110156862065196, 0.0109883062541485, 0.0109609523788095, 0.0109336823225021, 0.0109064793214202, 0.0108793349936604, 0.0108522428199649, 0.0108252000063658, 0.0107981972396374, 0.0107712708413601, 0.010744396597147, 0.0107175866141915, 0.01069082506001, 0.010664108209312, 0.0106374798342586, 0.0106108961626887, 0.0105843599885702, 0.0105579420924187, 0.0105315018445253, 0.0105051435530186, 0.0104788532480597, 0.0104526123031974, 0.0104264300316572, 0.0104002822190523, 0.0103742172941566, 0.0103482166305184, 0.0103222774341702, 0.0102963894605637, 0.0102705508470535, 0.0102447615936399, 0.0102190347388387, 0.0101933730766177, 0.0101677756756544, 0.0101421941071749, 0.0101166935637593, 0.0100912740454078, 0.0100658899173141, 0.0100405663251877, 0.0100153442472219, 0.00999011658132076, 0.00996495503932238, 0.00993987638503313, 0.00991483218967915, 0.00988986250013113, 0.00986491516232491, 0.00984006281942129, 0.00981525890529156, 0.0097905145958066, 0.00976584013551474, 0.00974121503531933, 0.00971662346273661, 0.00969211012125015, 0.00966764055192471, 0.00964325573295355, 0.00961887557059526, 0.00959458667784929, 0.00957036297768354, 0.00954619143158197, 0.00952206458896399, 0.00949805416166782, 0.0094740241765976, 0.00945007801055908, 0.00942619610577822, 0.00940236076712608, 0.00937859062105417, 0.0093548558652401, 0.00933119934052229, 0.00930760707706213, 0.00928406417369843, 0.00926059018820524, 0.00923717208206654, 0.00921378191560507, 0.00919047184288502, 0.00916721113026142, 0.00914403144270182, 0.00912085454910994, 0.00909777078777552, 0.00907475128769875, 0.00905178394168615, 0.00902886502444744, 0.00900599081069231, 0.00898323394358158, 0.00896048825234175, 0.00893781147897243, 0.00891518220305443, 0.00889261811971664, 0.00887008663266897, 0.00884763430804014, 0.00882524810731411, 0.00880289636552334, 0.00878060236573219, 0.00875837635248899, 0.00873624719679356, 0.00871413759887218, 0.00869208946824074, 0.00867010466754436, 0.00864814128726721, 0.00862625706940889, 0.00860445015132427, 0.00858267955482006, 0.0085609694942832, 0.00853929575532675, 0.00851775053888559, 0.00849620532244444, 0.0084747401997447, 0.00845330860465765, 0.00843195617198944, 0.00841061677783728, 0.00838938169181347, 0.00836819037795067, 0.00834706425666809, 0.00832595489919186, 0.00830494053661823, 0.00828397925943136, 0.00826311204582453, 0.00824226252734661, 0.00822147447615862, 0.00820072274655104, 0.00818005204200745, 0.00815944094210863, 0.00813888292759657, 0.00811837334185839, 0.00809791125357151, 0.00807751342654228, 0.00805722549557686, 0.00803694128990173, 0.00801673717796803, 0.0079965852200985, 0.00797647889703512, 0.00795641541481018, 0.0079364413395524, 0.00791651103645563, 0.00789660960435867, 0.00787679944187403, 0.00785703957080841, 0.00783737935125828, 0.00781773496419191, 0.00779815157875419, 0.00777860451489687, 0.00775913754478097, 0.00773971853777766, 0.00772037729620934, 0.00770107097923756, 0.00768181402236223, 0.00766262132674456, 0.00764354504644871, 0.00762446131557226, 0.00760544510558248, 0.0075864945538342, 0.00756759522482753, 0.00754875689744949, 0.00752998283132911, 0.0075112609192729, 0.00749257206916809, 0.00747395865619183, 0.00745541043579578, 0.00743691436946392, 0.00741851516067982, 0.00740009546279907, 0.00738179264590144, 0.00736352195963264, 0.00734531646594405, 0.00732716219499707, 0.0073090810328722, 0.00729102035984397, 0.00727304397150874, 0.00725512392818928, 0.00723727187141776, 0.00721947243437171, 0.00720171816647053, 0.00718403095379472, 0.00716640520840883, 0.00714882696047425, 0.00713130226358771, 0.00711382459849119, 0.00709642469882965, 0.007079076487571, 0.00706179300323129, 0.00704459007829428, 0.00702738668769598, 0.00701026013121009, 0.0069932178594172, 0.00697620818391442, 0.00695926649495959, 0.00694236624985933, 0.00692553352564573, 0.00690875295549631, 0.0068920492194593, 0.00687537807971239, 0.00685875490307808, 0.00684224860742688, 0.0068257749080658, 0.00680934498086572, 0.00679295510053635, 0.00677665043622255, 0.00676036160439253, 0.00674416916444898, 0.00672802189365029, 0.00671194260939956, 0.00669594760984182, 0.00667996518313885, 0.00666404236108065, 0.00664818892255425, 0.00663238763809204, 0.00661664642393589, 0.00660094944760203, 0.00658534187823534, 0.00656976224854589, 0.00655426643788815, 0.0065388036891818, 0.00652338471263647, 0.00650807935744524, 0.00649279309436679, 0.00647757155820727, 0.00646241055801511, 0.00644730217754841, 0.00643222546204925, 0.00641722977161407, 0.00640229834243655, 0.00638741534203291, 0.00637259660288692, 0.00635784259065986, 0.00634313654154539, 0.00632849521934986, 0.0063139027915895, 0.00629934528842568, 0.00628486555069685, 0.00627043331041932, 0.00625608582049608, 0.00624176673591137, 0.00622753240168095, 0.00621330970898271, 0.00619920389726758, 0.00618513021618128, 0.00617112126201391, 0.00615715701133013, 0.00614322861656547, 0.00612938078120351, 0.00611560139805079, 0.006101846229285, 0.00608817534521222, 0.00607457291334867, 0.00606099935248494, 0.00604748912155628, 0.00603407621383667, 0.0060206800699234, 0.00600733608007431, 0.00599405588582158, 0.00598085206001997, 0.00596768083050847, 0.00595459435135126, 0.00594154000282288, 0.00592852989211679, 0.0059156040661037, 0.00590276718139648, 0.00588994659483433, 0.00587719073519111, 0.00586446607485414, 0.00585182290524244, 0.00583924353122711, 0.00582671677693725, 0.00581423053517938, 0.00580181274563074, 0.00578946294263005, 0.00577715784311295, 0.00576496496796608, 0.00575277674943209, 0.00574063695967197, 0.00572855724021792, 0.00571654178202152, 0.00570459524169564, 0.00569269713014364, 0.00568086327984929, 0.00566906109452248, 0.00565732410177588, 0.00564569933339953, 0.00563409132882953, 0.00562254711985588, 0.00561101967468858, 0.00559958769008517, 0.00558820506557822, 0.00557688716799021, 0.00556560093536973, 0.00555439945310354, 0.00554324174299836, 0.0055321529507637, 0.00552110886201262, 0.00551016442477703, 0.0054992213845253, 0.0054883579723537, 0.00547755556181073, 0.00546680483967066, 0.00545611884444952, 0.00544548081234097, 0.00543487537652254, 0.00542436260730028, 0.00541390664875507, 0.00540352705866098, 0.00539317913353443, 0.00538286380469799, 0.00537264440208673, 0.00536247855052352, 0.00535235600546002, 0.00534226652234793, 0.00533226132392883, 0.0053223161958158, 0.00531242368742824, 0.00530261173844337, 0.00529286032542586, 0.00528312893584371, 0.00527346227318048, 0.00526385940611362, 0.0052543175406754, 0.00524483202025294, 0.00523537443950772, 0.00522600533440709, 0.00521668512374163, 0.00520742917433381, 0.00519826961681247, 0.0051890779286623, 0.00518001895397902, 0.00517098885029554, 0.00516202254220843, 0.00515310885384679, 0.00514422729611397, 0.00513543793931603, 0.00512670166790485, 0.00511801382526755, 0.00510938977822661, 0.00510081090033054, 0.00509231584146619, 0.00508385337889194, 0.00507547101005912, 0.00506712170317769, 0.00505883619189262, 0.00505058281123638, 0.0050424262881279, 0.0050343219190836, 0.00502627436071634, 0.00501825101673603, 0.00501031987369061, 0.00500247394666076, 0.00499465549364686, 0.00498687382787466, 0.00497916853055358, 0.00497149908915162, 0.00496390694752336, 0.00495636649429798, 0.00494889076799154, 0.0049414630047977, 0.00493411673232913, 0.0049268021248281, 0.00491956761106849, 0.00491236569359899, 0.00490523222833872, 0.00489815510809422, 0.00489111850038171, 0.00488415872678161, 0.00487726274877787, 0.00487039890140295, 0.00486358813941479, 0.00485685747116804, 0.00485018733888865, 0.00484359776601195, 0.00483704451471567, 0.00483053922653198, 0.0048240665346384, 0.00481767393648624, 0.00481134233996272, 0.00480506708845496, 0.00479886773973703, 0.0047927014529705, 0.00478659477084875, 0.0047805611975491, 0.00477456394582987, 0.00476865051314235, 0.00476274592801929, 0.00475694611668587, 0.0047511737793684, 0.00474548619240522, 0.00473984284326434, 0.00473423255607486, 0.00472868978977203, 0.0047232280485332, 0.00471784733235836, 0.00471249409019947, 0.00470719346776605, 0.00470192451030016, 0.00469675660133362, 0.0046916133724153, 0.00468653813004494, 0.00468154344707727, 0.0046765529550612, 0.00467166723683476, 0.00466685416176915, 0.00466208485886455, 0.00465732021257281, 0.00465265940874815, 0.00464800745248795, 0.00464349985122681, 0.00463898899033666, 0.00463456194847822, 0.00463019637390971, 0.00462585035711527, 0.0046216007322073, 0.00461736740544438, 0.00461326260119677, 0.00460914196446538, 0.00460508652031422, 0.00460107810795307, 0.00459719961509109, 0.00459336908534169, 0.00458950642496347, 0.0045857927761972, 0.00458210334181786, 0.00457843765616417, 0.00457489723339677, 0.00457131257280707, 0.0045678885653615, 0.00456444500014186, 0.0045611341483891, 0.00455780699849129, 0.00455460464581847, 0.00455145491287112, 0.00454827304929495, 0.00454526813700795, 0.00454223109409213, 0.00453930301591754, 0.00453638238832355, 0.00453357072547078, 0.0045307595282793, 0.00452806474640965, 0.00452542677521706, 0.00452278088778257, 0.00452025886625051, 0.00451778993010521, 0.00451534893363714, 0.0045129805803299, 0.004510632250458, 0.00450838031247258, 0.00450617307797074, 0.00450403476133943, 0.00450194394215941, 0.00449995044618845, 0.00449796859174967, 0.0044960230588913, 0.00449419440701604, 0.0044923615641892, 0.00449067447334528, 0.00448895432054996, 0.00448731472715735, 0.00448571192100644, 0.00448421761393547, 0.00448278756812215, 0.00448134168982506, 0.00448002852499485, 0.00447879545390606, 0.00447752699255943, 0.00447640754282475, 0.00447521917521954, 0.00447421241551638, 0.00447317305952311, 0.00447227898985147, 0.00447135232388973, 0.00447057047858834, 0.00446982169523835, 0.00446905661374331, 0.00446845265105367, 0.00446783192455769, 0.00446731224656105, 0.00446676835417747, 0.00446636136621237, 0.00446603167802095, 0.00446570571511984, 0.00446548778563738, 0.00446523772552609, 0.00446513714268804, 0.00446506915614009, 0.00446504494175315, 0.00446508917957544, 0.00446514971554279, 0.00446530664339662, 0.00446551200002432, 0.00446578208357096, 0.00446610013023019, 0.00446651503443718, 0.00446694996207952, 0.0044674095697701, 0.0044679893180728, 0.0044685653410852, 0.00446922145783901, 0.00446997489780188, 0.00447074836120009, 0.00447161449119449, 0.00447246804833412, 0.00447345152497292, 0.00447441358119249, 0.00447550928220153, 0.0044766771607101, 0.0044778292067349, 0.0044747581705451, 0.00446769362315536, 0.00446063140407205, 0.00445358967408538, 0.00444654002785683, 0.00443950993940234, 0.00443248637020588, 0.0044254744425416, 0.00441846437752247, 0.00441147480159998, 0.00440448196604848, 0.00439751008525491, 0.00439053494483232, 0.0043835761025548, 0.00437662145122886, 0.00436968402937055, 0.00436274847015738, 0.00435582455247641, 0.0043489052914083, 0.00434200372546911, 0.00433510215952992, 0.00432821735739708, 0.00432133348658681, 0.00431446591392159, 0.00430760020390153, 0.00430075312033296, 0.00429390417411923, 0.00428707664832473, 0.00428024539723992, 0.00427343416959047, 0.00426661968231201, 0.00425982289016247, 0.0042530307546258, 0.00424625538289547, 0.00423947721719742, 0.00423271767795086, 0.00422596279531717, 0.00421922374516726, 0.00421248003840446, 0.0042057572863996, 0.00419903872534633, 0.00419233413413167, 0.00418562581762671, 0.0041789417155087, 0.00417225435376167, 0.00416558468714356, 0.00415891874581575, 0.00415226723998785, 0.00414561480283737, 0.00413898332044482, 0.00413234950974584, 0.00412573153153062, 0.00411911960691214, 0.00411252304911613, 0.004105927888304, 0.00409934483468533, 0.0040927673690021, 0.00408620573580265, 0.00407964643090963, 0.00407309923321009, 0.00406655948609114, 0.00406002625823021, 0.00405351305380464, 0.00404699612408876, 0.0040404973551631, 0.00403399812057614, 0.00402752123773098, 0.00402103923261166, 0.00401457492262125, 0.00400811526924372, 0.00400167191401124, 0.00399522576481104, 0.00398879637941718, 0.00398237071931362, 0.00397596322000027, 0.0039695599116385, 0.00396316964179277, 0.00395677518099546, 0.00395040540024638, 0.00394403329119086, 0.0039376812055707, 0.0039313230663538, 0.00392498914152384, 0.00391865149140358, 0.00391233572736382, 0.00390601181425154, 0.00389971234835684, 0.00389340962283313, 0.00388712924905121, 0.00388084561564028, 0.00387458223849535, 0.00386831886135042, 0.00386207364499569, 0.00385582842864096, 0.0038495953194797, 0.00384336709976196, 0.0038371563423425, 0.0038309502415359, 0.00382475228980184, 0.00381855946034193, 0.00381238758563995, 0.00380621175281703, 0.00380005314946175, 0.00379389571025968, 0.00378775922581553, 0.00378161878325045, 0.00377549626864493, 0.00376937678083777, 0.00376327545382082, 0.00375717342831194, 0.00375108513981104, 0.00374500197358429, 0.00373893510550261, 0.00373286916874349, 0.00372681906446815, 0.00372076733037829, 0.00371473538689315, 0.0037087076343596, 0.00370269431732595, 0.00369667843915522, 0.00369067792780697, 0.0036846895236522, 0.00367870577611029, 0.00367273669689894, 0.00366676528938115, 0.00366081623360515, 0.00365486391820014, 0.00364893162623048, 0.00364299770444632, 0.00363708380609751, 0.00363117293454707, 0.00362527603283525, 0.00361937726847827, 0.00361350271850824, 0.00360762397758663, 0.00360176316462457, 0.00359589862637222, 0.0035900583025068, 0.00358421565033495, 0.00357839372009039, 0.00357256806455553, 0.00356675870716572, 0.00356095167808235, 0.0035551656037569, 0.00354937463998795, 0.00354360160417855, 0.00353783275932074, 0.00353208091109991, 0.00352632906287909, 0.00352059118449688, 0.00351485749706626, 0.00350914010778069, 0.00350342411547899, 0.00349772488698363, 0.00349202519282699, 0.00348634412512183, 0.00348066678270698, 0.00347500131465495, 0.00346933840774, 0.00346369110047817, 0.00345805240795016, 0.00345242233015597, 0.00344679201953113, 0.00344118429347873, 0.00343557260930538, 0.00342998281121254, 0.00342438905499876, 0.00341881671920419, 0.00341324484907091, 0.00340768950991333, 0.00340213510207832, 0.00339659373275936, 0.00339106237515807, 0.00338554219342768, 0.00338002317585051, 0.00337451975792646, 0.00336901843547821, 0.00336353783495724, 0.00335805374197662, 0.00335257779806852, 0.00334711908362806, 0.00334166432730854, 0.003336226567626, 0.0033307836856693, 0.00332536431960762, 0.0033199458848685, 0.00331454258412123, 0.00330914137884974, 0.00330375391058624, 0.00329836853779852, 0.00329300528392196, 0.00328764016740024, 0.00328228599391878, 0.00327693717554212, 0.00327160907909274, 0.00326627842150629, 0.00326096336357296, 0.00325564970262349, 0.00325035606510937, 0.00324506429024041, 0.00323978113010526, 0.00323450635187328, 0.00322924880310893, 0.00322398752905428, 0.00321874720975757, 0.00321350269950926, 0.00320828100666404, 0.00320306257344782, 0.00319785764440894, 0.00319264829158783, 0.00318746059201658, 0.00318227475509048, 0.00317710801027715, 0.00317193591035903, 0.00316678732633591, 0.00316163571551442, 0.00315650412812829, 0.00315136671997607, 0.00314625212922692, 0.00314113381318748, 0.00313603831455112, 0.00313094328157604, 0.00312586012296379, 0.00312078278511763, 0.00311572360806167, 0.00311066256836057, 0.00310561573132873, 0.00310057285241783, 0.00309554627165198, 0.00309052132070065, 0.00308551243506372, 0.00308050494641066, 0.00307551841251552, 0.00307052792049944, 0.00306555442512035, 0.00306058209389448, 0.00305562978610396, 0.00305067445151508, 0.00304574007168412, 0.00304080289788544, 0.00303588714450598, 0.00303096696734428, 0.0030260591302067, 0.00302116526290774, 0.00301627512089908, 0.00301140150986612, 0.00300653371959925, 0.00300167431123555, 0.00299681932665408, 0.00299198203720152, 0.00298714847303927, 0.00298232841305435, 0.00297750881873071, 0.00297270552255213, 0.00296791037544608, 0.00296312430873513, 0.00295834010466933, 0.00295357615686953, 0.00294880801811814, 0.00294406106695533, 0.00293931225314736, 0.00293458346277475, 0.00292985467240214, 0.00292514427565038, 0.00292042968794703, 0.00291573605500162, 0.00291104894131422, 0.00290637323632836, 0.00290169799700379, 0.00289703556336462, 0.00289238151162863, 0.00288773933425546, 0.00288310297764838, 0.00287847593426704, 0.00287385727278888, 0.00286925537511706, 0.0028646495193243, 0.00286006135866046, 0.00285547762177885, 0.00285091227851808, 0.00284634553827345, 0.00284179206937551, 0.00283724348992109, 0.00283271237276495, 0.00282818078994751, 0.00282366550527513, 0.00281915231607854, 0.00281465519219637, 0.00281016016378999, 0.00280568515881896, 0.0028012020047754, 0.00279674399644136, 0.0027922831941396, 0.00278784334659576, 0.00278339977376163, 0.00277897319756448, 0.00277455127798021, 0.00277014705352485, 0.00276574259623885, 0.00276135024614632, 0.00275696371681988, 0.0027525934856385, 0.00274822441861033, 0.00274385884404182, 0.00273951492272317, 0.00273517682217062, 0.00273085106164217, 0.00272652297280729, 0.00272221816703677, 0.00271791056729853, 0.00271362368948758, 0.00270932796411216, 0.00270505831576884, 0.00270078983157873, 0.00269653322175145, 0.00269228173419833, 0.00268804235383868, 0.00268380925990641, 0.00267959386110306, 0.00267537659965456, 0.00267117377370596, 0.00266697467304766, 0.00266279350034893, 0.00265861302614212, 0.0026544479187578, 0.00265028420835733, 0.00264613633044064, 0.00264199473895133, 0.00263786129653454, 0.00263373670168221, 0.00262962514534593, 0.00262551754713058, 0.00262142741121352, 0.00261733378283679, 0.00261325784958899, 0.00260918657295406, 0.00260513066314161, 0.00260107242502272, 0.00259703421033919, 0.00259299646131694, 0.00258897664025426, 0.00258495262823999, 0.00258095492608845, 0.00257695326581597, 0.00257296767085791, 0.00256898324005306, 0.0025650158058852, 0.00256105326116085, 0.00255710515193641, 0.00255315937101841, 0.0025492231361568, 0.00254529528319836, 0.00254138396121562, 0.00253746774978936, 0.00253357086330652, 0.00252967793494463, 0.0025258029345423, 0.00252192723564804, 0.00251806457526982, 0.0025142109952867, 0.00251037254929543, 0.00250653177499771, 0.00250270939432085, 0.00249888678081334, 0.00249507231637836, 0.00249127601273358, 0.00248748273588717, 0.00248370389454067, 0.00247992528602481, 0.00247616739943624, 0.00247240532189608, 0.00246866163797677, 0.00246492144651711, 0.00246119871735573, 0.00245747622102499, 0.00245376746170223, 0.00245006266050041, 0.00244637508876622, 0.00244268751703203, 0.00243901717476547, 0.00243534380570054, 0.00243169558234513, 0.00242804223671556, 0.00242440705187619, 0.00242077279835939, 0.00241715484298766, 0.00241354177705944, 0.00240994687192142, 0.0024063428863883, 0.00240276427939534, 0.00239918823353946, 0.00239562569186091, 0.00239205709658563, 0.00238851457834244, 0.00238497112877667, 0.00238144560717046, 0.00237791892141104, 0.0023744108621031, 0.0023709035012871, 0.00236741243861616, 0.00236392230726779, 0.00236045033670962, 0.00235697813332081, 0.002353526186198, 0.00235007051378489, 0.00234663276933134, 0.0023431945592165, 0.00233977823518217, 0.00233636144548655, 0.00233295792713761, 0.00232955417595804, 0.0023261730093509, 0.00232279347255826, 0.00231942906975746, 0.00231606094166636, 0.00231271469965577, 0.00230936845764518, 0.0023060436360538, 0.0023027106653899, 0.00229939958080649, 0.00229609268717468, 0.00229279790073633, 0.00228950101882219, 0.00228622835129499, 0.00228295242413878, 0.00227968906983733, 0.00227644247934222, 0.00227319402620196, 0.00226996070705354, 0.00226673344150186, 0.00226352224126458, 0.00226030754856765, 0.00225711450912058, 0.00225392053835094, 0.00225074426271021, 0.00224756565876305, 0.00224440661258996, 0.00224125292152166, 0.0022381111048162, 0.00223496719263494, 0.00223184772767127, 0.00222872407175601, 0.00222562463022768, 0.00222251936793327, 0.00221943040378392, 0.0022163474932313, 0.00221327599138021, 0.00221020984463394, 0.00220715464092791, 0.00220410572364926, 0.00220107473433018, 0.00219804374501109, 0.00219502463005483, 0.00219201087020338, 0.0021890162024647, 0.00218602037057281, 0.00218304083682597, 0.0021800622344017, 0.00217710062861443, 0.00217414321377873, 0.00217119883745909, 0.00216825515963137, 0.00216533313505352, 0.00216240691952407, 0.00215950072742999, 0.00215659267269075, 0.00215370045043528, 0.00215081451460719, 0.00214794487692416, 0.00214507081545889, 0.00214221910573542, 0.00213936739601195, 0.00213653175160289, 0.00213369820266962, 0.00213088048622012, 0.00212806300260127, 0.00212526391260326, 0.00212246854789555, 0.00211968109942973, 0.00211690389551222, 0.00211413879878819, 0.00211137835867703, 0.0021086276974529, 0.00210588448680937, 0.00210315268486738, 0.00210043578408659, 0.00209771073423326, 0.00209501036442816, 0.00209231139160693, 0.00208962894976139, 0.00208694860339165, 0.00208428408950567, 0.0020816195756197, 0.00207897322252393, 0.00207632686942816, 0.00207369867712259, 0.00207107025198638, 0.00206845812499523, 0.00206585018895566, 0.00206325226463377, 0.0020596741233021, 0.00205519911833107, 0.0020507222507149, 0.00204624910838902, 0.00204177410341799, 0.00203730328939855, 0.00203283620066941, 0.00202836724929512, 0.00202390039339662, 0.00201943540014327, 0.00201497063972056, 0.002010507741943, 0.00200604670681059, 0.00200158590450883, 0.00199712696485221, 0.00199267012067139, 0.00198821537196636, 0.00198376039043069, 0.00197930750437081, 0.00197485485114157, 0.00197040592320263, 0.00196595722809434, 0.00196151039563119, 0.00195706356316805, 0.00195262092165649, 0.00194817816372961, 0.0019437352893874, 0.00193929660599679, 0.00193485792260617, 0.00193041912280023, 0.00192598439753056, 0.0019215497886762, 0.00191711494699121, 0.00191268441267312, 0.00190825364552438, 0.00190382497385144, 0.00189940026029944, 0.00189497577957809, 0.00189055106602609, 0.00188612844794989, 0.00188170582987368, 0.00187728728633374, 0.00187286664731801, 0.00186844996642321, 0.00186403142288327, 0.00185961683746427, 0.0018552023684606, 0.00185079174116254, 0.00184638518840075, 0.00184197467751801, 0.00183756812475622, 0.00183316168840975, 0.00182875723112375, 0.00182435265742242, 0.00181995215825737, 0.00181555165909231, 0.00181115325540304, 0.00180675473529845, 0.00180235831066966, 0.00179796398151666, 0.00179357151500881, 0.00178917718585581, 0.00178478669840842, 0.00178040040191263, 0.00177601189352572, 0.00177162559702992, 0.00176724116317928, 0.00176285696215928, 0.00175847660284489, 0.00175409414805472, 0.00174971588421613, 0.00174533750396222, 0.0017409612191841, 0.00173658493440598, 0.00173221260774881, 0.00172784039750695, 0.00172347016632557, 0.00171909993514419, 0.00171473762020469, 0.00171037146355957, 0.00170600519049913, 0.00170164101291448, 0.00169727671891451, 0.00169291661586612, 0.00168855639640242, 0.00168419815599918, 0.00167984201107174, 0.00167548574972898, 0.0016711336793378, 0.00166678556706756, 0.00166243547573686, 0.00165808538440615, 0.00165373727213591, 0.00164938915986568, 0.00164504500571638, 0.00164070096798241, 0.00163635902572423, 0.00163201685063541, 0.00162767875008285, 0.00162334076594561, 0.00161900266539305, 0.00161466863937676, 0.00161033472977579, 0.00160600268281996, 0.00160167075227946, 0.00159734080079943, 0.00159301073290408, 0.00158868683502078, 0.00158436293713748, 0.00158003682736307, 0.00157571898307651, 0.00157139310613275, 0.00156707514543086, 0.0015627573011443, 0.00155844131950289, 0.00155412557069212, 0.0015498116845265, 0.00154549768194556, 0.00154118787031621, 0.00153688015416265, 0.00153257022611797, 0.00152826646808535, 0.00152395665645599, 0.00151965487748384, 0.00151535111945122, 0.00151105120312423, 0.00150674942415208, 0.00150245369877666, 0.00149815389886498, 0.00149386026896536, 0.00148956850171089, 0.00148527277633548, 0.00148098298814148, 0.00147669122088701, 0.00147240574005991, 0.00146811595186591, 0.00146383233368397, 0.00145954662002623, 0.00145526498090476, 0.00145098124630749, 0.00144670368172228, 0.00144242402166128, 0.00143814843613654, 0.00143387285061181, 0.00142959924414754, 0.00142532563768327, 0.0014210541266948, 0.00141678645741194, 0.00141251483000815, 0.00140824937261641, 0.00140398181974888, 0.00139972032047808, 0.00139545474667102, 0.00139119324740022, 0.00138693570625037, 0.00138267420697957, 0.0013784208567813, 0.00137416331563145, 0.00136990996543318, 0.00136565649881959, 0.00136140501126647, 0.00135715759824961, 0.00135290611069649, 0.00134866079315543, 0.00134441338013858, 0.00134017190430313, 0.00133592658676207, 0.00133168522734195, 0.00132744386792183, 0.00132320448756218, 0.00131896510720253, 0.00131473178043962, 0.0013104984536767, 0.00130626314785331, 0.00130203389562666, 0.00129780254792422, 0.00129357329569757, 0.00128934404347092, 0.00128512072842568, 0.00128089357167482, 0.00127667223569006, 0.00127244903706014, 0.00126822979655117, 0.00126401265151799, 0.00125979539006948, 0.00125557812862098, 0.00125136296264827, 0.00124715187121183, 0.00124293868429959, 0.00123872957192361, 0.00123451638501137, 0.00123031123075634, 0.00122610421385616, 0.0012219010386616, 0.00121769984252751, 0.0012134948046878, 0.00120929768308997, 0.00120509671978652, 0.0012008995981887, 0.00119670247659087, 0.00119250954594463, 0.0011883124243468, 0.00118412345182151, 0.00117993447929621, 0.00117574143223464, 0.00117155641783029, 0.00116736744530499, 0.0011631844099611, 0.00115899939555675, 0.00115481857210398, 0.00115063553676009, 0.00114645867142826, 0.00114227761514485, 0.00113810482434928, 0.0011339319171384, 0.00112975493539125, 0.0011255859863013, 0.00112141319550574, 0.00111724436283112, 0.00111307553015649, 0.00110891065560281, 0.00110474182292819, 0.00110058090649545, 0.00109641603194177, 0.00109225930646062, 0.001088100601919, 0.00108394166454673, 0.00107978493906558, 0.0010756280971691, 0.00107147544622421, 0.001067322678864, 0.00106317386962473, 0.00105902121867985, 0.00105487648397684, 0.00105072779115289, 0.00104658305644989, 0.00104244041722268, 0.00103829766158015, 0.0010341570014134, 0.00103001634124666, 0.00102587963920087, 0.0010217409580946, 0.00101760635152459, 0.00101347570307553, 0.00100934121292084, 0.00100520648993552, 0.00100107991602272, 0.000996951363049448, 0.000992822810076177, 0.00098870019428432, 0.000984573620371521, 0.000980453100055456, 0.000976330600678921, 0.000972212059423327, 0.000968095555435866, 0.000963977014180273, 0.000959864526521415, 0.000955748022533953, 0.000951637572143227, 0.000947525084484369, 0.000943416613154113, 0.000939304183702916, 0.000935199728701264, 0.000931091315578669, 0.00092699087690562, 0.000922886480111629, 0.00091878609964624, 0.000914689735509455, 0.000910587317775935, 0.000906492990907282, 0.000902392552234232, 0.000898302299901843, 0.000894207914825529, 0.000890119641553611, 0.000886025256477296, 0.000881938962265849, 0.000877850688993931, 0.000873766315635294, 0.000869682058691978, 0.000865599839016795, 0.000861517561133951, 0.000857437320519239, 0.000853361038025469, 0.000849280855618417, 0.000845206610392779, 0.00084113038610667, 0.000837060157209635, 0.000832983991131186, 0.000828917836770415, 0.000824851624201983, 0.00082078151172027, 0.00081671733641997, 0.000812651182059199, 0.000808591081295162, 0.000804526905994862, 0.000800466805230826, 0.000796410720795393, 0.000792350620031357, 0.000788298551924527, 0.000784240488428622, 0.000780190399382263, 0.00077613431494683, 0.000772086321376264, 0.000768036232329905, 0.00076399021781981, 0.000759942224249244, 0.00075589818879962, 0.00075185822788626, 0.000747814192436635, 0.000743778247851878, 0.000739734270609915, 0.00073570036329329, 0.000731660344172269, 0.000727630453184247, 0.000723592471331358, 0.000719562580343336, 0.000715530652087182, 0.000711504777427763, 0.000707478902768344, 0.000703451049048454, 0.000699427211657166, 0.000695399299729615, 0.000691381457727402, 0.000687359599396586, 0.000683341757394373, 0.000679319957271218, 0.000675308110658079, 0.000671290326863527, 0.000667278538458049, 0.0006632647709921, 0.000659256998915225, 0.00065524922683835, 0.000651239475701004, 0.000647233799099922, 0.000643228064291179, 0.000639226287603378, 0.000635222590062767, 0.000631222908850759, 0.000627227243967354, 0.000623225525487214, 0.000619225786067545, 0.000615234195720404, 0.00061124050989747, 0.000607248861342669, 0.000603257270995528, 0.000599269638769329, 0.00059528200654313, 0.000591294374316931, 0.000587310816626996, 0.000583329237997532, 0.000579343701247126, 0.000575366080738604, 0.000571382523048669, 0.000567409035284072, 0.000563429435715079, 0.000559455947950482, 0.000555478385649621, 0.000551510893274099, 0.00054753536824137, 0.000543567934073508, 0.000539602478966117, 0.000535633007530123, 0.000531669531483203, 0.000527704076375812, 0.000523742637597024, 0.000519781198818237, 0.000515823776368052, 0.000511864374857396, 0.000507908989675343, 0.000503949588164687, 0.000499998219311237, 0.000496046850457788, 0.000492095481604338, 0.000488148158183321, 0.000484196818433702, 0.000480253511341289, 0.000476306158816442, 0.000472362851724029, 0.000468415528303012, 0.000464480282971635, 0.000460536946775392, 0.000456601701444015, 0.000452664477052167, 0.000448727194452658, 0.000444795965449885, 0.000440860720118508, 0.000436931528383866, 0.000433000299381092, 0.000429073115810752, 0.00042514389497228, 0.000421220756834373, 0.000417299568653107, 0.000413374393247068, 0.000409455242333934, 0.000405532075092196, 0.000401616998715326, 0.000397697847802192, 0.000393782742321491, 0.000389867636840791, 0.000385956518584862, 0.000382041442207992, 0.000378134369384497, 0.000374227325664833, 0.000370318244677037, 0.000366415246389806, 0.000362508173566312, 0.000358607154339552, 0.000354704126948491, 0.000350805144989863, 0.000346906163031235, 0.00034301116829738, 0.000339112157234922, 0.000335221237037331, 0.000331328279571608, 0.000327435322105885, 0.000323548389133066, 0.000319653423503041, 0.000315770535962656, 0.000311881623929366, 0.000308000744553283, 0.000304113811580464, 0.000300234940368682, 0.000296352081932127, 0.000292477256152779, 0.000288600422209129, 0.000284723530057818, 0.0002808487333823, 0.000276975915767252, 0.000273105106316507, 0.00026923228870146, 0.000265365495579317, 0.000261500768829137, 0.000257631967542693, 0.000253769219852984, 0.000249904463998973, 0.000246043724473566, 0.000242180976783857, 0.000238324268138967, 0.000234465551329777, 0.000230610850849189, 0.000226754156756215, 0.000222903501708061, 0.000219052817556076, 0.00021520015434362, 0.000211353515624069, 0.000207504868740216, 0.000203660238184966, 0.000199811591301113, 0.000195973014342599, 0.000192126375623047, 0.000188287784112617, 0.000184449221706018, 0.000180612652911805, 0.000176774061401375, 0.000172939515323378, 0.000169111008290201, 0.000165274439495988, 0.000161445932462811, 0.000157615417265333, 0.000153788903844543, 0.000149960396811366, 0.000146139936987311, 0.000142311429954134, 0.00013849297829438, 0.000134668502141722, 0.000130854095914401, 0.000127035658806562, 0.000123217221698724, 0.000119404816359747, 0.00011558838741621, 0.00011177800479345, 0.000107965606730431, 0.000104157232271973, 0.000100348865089472, 9.65445215115324e-05, 9.27381624933332e-05, 8.89358343556523e-05, 8.51335062179714e-05, 8.13311708043329e-05, 7.75348889874294e-05, 7.37345762900077e-05, 6.99403026374057e-05, 6.61419981042854e-05, 6.23517480562441e-05, 5.85615089221392e-05, 5.47672352695372e-05, 5.09810161020141e-05, 4.71907696919516e-05, 4.34045541624073e-05, 3.96183349948842e-05, 3.58361467078794e-05, 3.20519429806154e-05, 2.82717664958909e-05, 2.44915918301558e-05, 2.0713428966701e-05, 1.69413087860448e-05, 1.31631486510742e-05, 9.39102756092325e-06, 5.6148801377276e-06, 1.84880195774895e-06, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15, 2.06194627954477e-15   }, 
   { 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.99964446517538e-15, 1.103979684558e-06, 4.13463476434117e-06, 7.23561106497073e-06, 1.03506217783433e-05, 1.35535929075559e-05, 1.67635371326469e-05, 2.00473477889318e-05, 2.33733208006015e-05, 2.67204213741934e-05, 3.01448435493512e-05, 3.3604428608669e-05, 3.71202986571006e-05, 4.06572034989949e-05, 4.42855889559723e-05, 4.79244590678718e-05, 5.16266518388875e-05, 5.53639729332644e-05, 5.91716743656434e-05, 6.29968999419361e-05, 6.68854045215994e-05, 7.0805566792842e-05, 7.47960730222985e-05, 7.88041288615204e-05, 8.28684424050152e-05, 8.70065923663788e-05, 9.1165813500993e-05, 9.53848284552805e-05, 9.96284943539649e-05, 0.000103949445474427, 0.000108280983113218, 0.000112689842353575, 0.000117137373308651, 0.000121648197819013, 0.000126169601571746, 0.000130754255224019, 0.00013538813800551, 0.000140078249387443, 0.000144789490150288, 0.000149549945490435, 0.000154387758811936, 0.000159236064064316, 0.000164168814080767, 0.000169115592143498, 0.000174132728716359, 0.00017918496450875, 0.00018430054478813, 0.000189426616998389, 0.000194644162547775, 0.00019987220002804, 0.000205167045351118, 0.000210493599297479, 0.000215897438465618, 0.000221315334783867, 0.000226810618187301, 0.000232312915613875, 0.000237899555941112, 0.000243493312154897, 0.000249150296440348, 0.000254870537901297, 0.000260618951870129, 0.000266444752924144, 0.000272273988230154, 0.000278187624644488, 0.000284122419543564, 0.000290120427962393, 0.000296146579785272, 0.000302246538922191, 0.000308357062749565, 0.000314562581479549, 0.000320771534461528, 0.000327064917655662, 0.000333365285769105, 0.000339714868459851, 0.000346127839293331, 0.000352582894265652, 0.000359115336323157, 0.000365640735253692, 0.000372257549315691, 0.000378902506781742, 0.000385614257538691, 0.000392329471651465, 0.000399139709770679, 0.000405956932809204, 0.000412855035392568, 0.000419774209149182, 0.000426756654633209, 0.000433763721957803, 0.000440823554527014, 0.000447946629719809, 0.000455090834293514, 0.00046232994645834, 0.000469562044600025, 0.00047688907943666, 0.000484223157400265, 0.000491627492010593, 0.000499045883771032, 0.000506562821101397, 0.000514072657097131, 0.000521677429787815, 0.000529292738065124, 0.000536981911864132, 0.000544695649296045, 0.000552451587282121, 0.000560277840122581, 0.000568132207263261, 0.000576063990592957, 0.000584009801968932, 0.000592025928199291, 0.000600066676270217, 0.000608177739195526, 0.000616309873294085, 0.000624519307166338, 0.000632739393040538, 0.000641033228021115, 0.000649369379971176, 0.000657768687233329, 0.000666175037622452, 0.000674648210406303, 0.000683156598825008, 0.000691728258971125, 0.000700342061463743, 0.000708991021383554, 0.000717699818778783, 0.000726450700312853, 0.000735268462449312, 0.000744086166378111, 0.00075300590833649, 0.00076193263521418, 0.000770933169405907, 0.000779961876105517, 0.00078906788257882, 0.000798166904132813, 0.000807360862381756, 0.000816561805550009, 0.000825843599159271, 0.000835160608403385, 0.00084450573194772, 0.000853928155265749, 0.00086338579421863, 0.000872899603564292, 0.000882441701833159, 0.000892047013621777, 0.000901669845916331, 0.000911377079319209, 0.000921101833228022, 0.000930911104660481, 0.000940706231631339, 0.000950620917137712, 0.000960514473263174, 0.000970506574958563, 0.000980501994490623, 0.000990564469248056, 0.00100069353356957, 0.00101082620676607, 0.00102105736732483, 0.0010312955128029, 0.00104159687180072, 0.00105194048956037, 0.00106234045233577, 0.00107276835478842, 0.00108325970359147, 0.00109378597699106, 0.00110438279807568, 0.00111500069033355, 0.00112567481119186, 0.00113640516065061, 0.00114716356620193, 0.00115798541810364, 0.00116884231101722, 0.00117976253386587, 0.00119070732034743, 0.00120170146692544, 0.0012127481168136, 0.00122385122813284, 0.00123499648179859, 0.00124618038535118, 0.00125742051750422, 0.00126868882216513, 0.00128001323901117, 0.00129140471108258, 0.00130281352903694, 0.00131429277826101, 0.00132580380886793, 0.001337367342785, 0.00134898722171783, 0.00136063864920288, 0.00137233932036906, 0.00138409284409136, 0.00139588501770049, 0.00140774028841406, 0.00141960638575256, 0.00143156037665904, 0.00144353532232344, 0.00145556649658829, 0.00146765389945358, 0.0014797659823671, 0.001491948380135, 0.00150417303666472, 0.00151643971912563, 0.00152875226922333, 0.00154111394658685, 0.00155350379645824, 0.00156597094610333, 0.00157846626825631, 0.00159101083409041, 0.00160361512098461, 0.00161625107284635, 0.0016289361519739, 0.00164166011381894, 0.00165445078164339, 0.00166726240422577, 0.00168014096561819, 0.00169306877069175, 0.00170603522565216, 0.00171906140167266, 0.00173210166394711, 0.00174522981978953, 0.00175837206188589, 0.00177157751750201, 0.00178482523187995, 0.00179812568239868, 0.00181145779788494, 0.00182484951801598, 0.00183828710578382, 0.00185177393723279, 0.00186530651990324, 0.00187887414358556, 0.00189250847324729, 0.00190618506167084, 0.00191988993901759, 0.00193366501480341, 0.00194747524801642, 0.00196132063865662, 0.00197523622773588, 0.00198918720707297, 0.00200318382121623, 0.0020172365475446, 0.00203131046146154, 0.00204546167515218, 0.00205962359905243, 0.00207386282272637, 0.00208813697099686, 0.00210246769711375, 0.00211684755049646, 0.00213126232847571, 0.00214573368430138, 0.0021602469496429, 0.00217480282299221, 0.00218940759077668, 0.00220407918095589, 0.00221877894364297, 0.00223352434113622, 0.00224830489605665, 0.00226316275075078, 0.00227803131565452, 0.00229296321049333, 0.00230793352238834, 0.00232297065667808, 0.00233805738389492, 0.00235318252816796, 0.00236835330724716, 0.00238356646150351, 0.00239881104789674, 0.00241412618197501, 0.00242949044331908, 0.00244488962925971, 0.00246034190058708, 0.00247584329918027, 0.0024913833476603, 0.00250697252340615, 0.00252260058186948, 0.0025382915046066, 0.00255402154289186, 0.00256980070844293, 0.00258561503142118, 0.00260148174129426, 0.00261741224676371, 0.00263338815420866, 0.0026493922341615, 0.0026654526591301, 0.00268155871890485, 0.00269771437160671, 0.00271391146816313, 0.00273014442063868, 0.00274644349701703, 0.0027627747040242, 0.00277916225604713, 0.00279558473266661, 0.00281207053922117, 0.00282860896550119, 0.0028451825492084, 0.00286179152317345, 0.00287847057916224, 0.0028951708227396, 0.00291193439625204, 0.00292876129969954, 0.00294559891335666, 0.00296249915845692, 0.00297945644706488, 0.00299644819460809, 0.00301348976790905, 0.00303056952543557, 0.00304770935326815, 0.00306489132344723, 0.00308213639073074, 0.00309938518330455, 0.00311672198586166, 0.00313409348018467, 0.00315151107497513, 0.00316896731965244, 0.00318649038672447, 0.00320403440855443, 0.00322164501994848, 0.00323930522426963, 0.00325700780376792, 0.00327474158257246, 0.00329251051880419, 0.00331036048009992, 0.00332824559882283, 0.00334618682973087, 0.00336414598859847, 0.0033821715041995, 0.00340024987235665, 0.00341836037114263, 0.00343654071912169, 0.00345475622452796, 0.00347300712019205, 0.00349132809787989, 0.0035096772480756, 0.00352806854061782, 0.00354651617817581, 0.0035650203935802, 0.00358355208300054, 0.00360214407555759, 0.00362076028250158, 0.00363944354467094, 0.00365817244164646, 0.00367694348096848, 0.00369576714001596, 0.00371462269686162, 0.00373355904594064, 0.00375252007506788, 0.00377151602879167, 0.00379059300757945, 0.00380967720411718, 0.00382882449775934, 0.00384802441112697, 0.00386725994758308, 0.00388656160794199, 0.00390588468872011, 0.00392527785152197, 0.003944699652493, 0.00396417733281851, 0.00398370437324047, 0.00400326959788799, 0.00402288511395454, 0.00404256628826261, 0.00406227307394147, 0.00408202828839421, 0.0041018333286047, 0.00412167282775044, 0.00414157984778285, 0.00416153902187943, 0.00418151961639524, 0.00420156726613641, 0.00422163540497422, 0.00424176407977939, 0.00426193419843912, 0.00428217183798552, 0.00430242996662855, 0.00432275468483567, 0.00434313993901014, 0.00436539947986603, 0.00438960222527385, 0.00441387528553605, 0.00443821959197521, 0.00446268962696195, 0.00448722997680306, 0.00451186904683709, 0.00453659240156412, 0.00456140097230673, 0.00458633480593562, 0.00461129704490304, 0.0046364008449018, 0.00466158799827099, 0.00468684593215585, 0.00471223006024957, 0.00473767053335905, 0.00476322369650006, 0.00478886114433408, 0.00481458334252238, 0.00484040379524231, 0.00486630853265524, 0.0048923259600997, 0.00491838529706001, 0.00494457129389048, 0.00497085554525256, 0.00499722501263022, 0.0050236638635397, 0.00505020096898079, 0.00507683726027608, 0.00510358531028032, 0.00513037666678429, 0.00515730772167444, 0.00518430955708027, 0.00521138170734048, 0.00523856654763222, 0.00526584917679429, 0.00529321655631065, 0.00532066822052002, 0.00534819019958377, 0.00537583883851767, 0.00540355779230595, 0.00543138897046447, 0.00545929092913866, 0.00548726320266724, 0.00551537564024329, 0.00554355839267373, 0.00557184033095837, 0.00560020608827472, 0.00562864262610674, 0.00565720489248633, 0.0056858379393816, 0.00571458321064711, 0.00574338529258966, 0.00577229959890246, 0.00580131215974689, 0.00583039550110698, 0.00585957709699869, 0.00588884251192212, 0.00591819314286113, 0.005947669968009, 0.00597720267251134, 0.00600684806704521, 0.00603656424209476, 0.00606636516749859, 0.00609630532562733, 0.00612628879025578, 0.00615639891475439, 0.00618659239262342, 0.00621684268116951, 0.00624723406508565, 0.00627766689285636, 0.0063082268461585, 0.00633885664865375, 0.00636957073584199, 0.00640039844438434, 0.0064312950707972, 0.0064623192884028, 0.00649339891970158, 0.00652456376701593, 0.00655586877837777, 0.00658721616491675, 0.0066186897456646, 0.00665023410692811, 0.00668184831738472, 0.00671361759305, 0.00674542924389243, 0.00677733914926648, 0.00680931890383363, 0.0068414113484323, 0.00687360251322389, 0.00690586399286985, 0.00693826610222459, 0.00697069661691785, 0.00700322445482016, 0.00703589385375381, 0.00706859165802598, 0.00710144313052297, 0.007134351413697, 0.00716733001172543, 0.0072004497051239, 0.00723362481221557, 0.00726691354066133, 0.00730025721713901, 0.00733370007947087, 0.00736728357151151, 0.00740089500322938, 0.00743464706465602, 0.0074684415012598, 0.00750236213207245, 0.007536381483078, 0.00757044274359941, 0.00760464509949088, 0.00763893174007535, 0.0076732742600143, 0.0077077578753233, 0.00774226943030953, 0.00777693558484316, 0.00781165808439255, 0.00784647837281227, 0.00788139831274748, 0.0079164020717144, 0.00795150455087423, 0.00798666290938854, 0.00802193395793438, 0.00805731769651175, 0.00809275731444359, 0.00812830962240696, 0.00816395971924067, 0.00819966662675142, 0.00823551416397095, 0.00827141851186752, 0.00830743368715048, 0.00834350660443306, 0.00837970618158579, 0.00841598957777023, 0.00845234282314777, 0.00848880968987942, 0.00852536037564278, 0.00856196694076061, 0.00859872903674841, 0.00863553304225206, 0.00867244880646467, 0.00870944932103157, 0.00874656345695257, 0.00878373254090548, 0.00882100034505129, 0.00885839574038982, 0.00889583211392164, 0.00893338117748499, 0.00897104293107986, 0.00900874752551317, 0.00904660485684872, 0.00908449199050665, 0.00912247784435749, 0.00916058942675591, 0.00919878575950861, 0.00923705194145441, 0.0092754028737545, 0.00931386556476355, 0.00935242790728807, 0.00939107406884432, 0.00942980404943228, 0.00946860574185848, 0.00950753316283226, 0.00954654440283775, 0.00958562735468149, 0.00962484907358885, 0.00966408662497997, 0.00970346294343472, 0.0097429258748889, 0.00978245679289103, 0.00982210226356983, 0.00986184552311897, 0.00990164559334517, 0.00994158443063498, 0.00998156704008579, 0.010021704249084, 0.0100618684664369, 0.0101021332666278, 0.0101425228640437, 0.0101829692721367, 0.0102235274389386, 0.0102641703560948, 0.0103048700839281, 0.0103457234799862, 0.0103866066783667, 0.0104276435449719, 0.0104687223210931, 0.0105098988860846, 0.0105512039735913, 0.0105925500392914, 0.0106340376660228, 0.0106755802407861, 0.0107171945273876, 0.0107589494436979, 0.0108007583767176, 0.0108426818624139, 0.0108846891671419, 0.0109267812222242, 0.0109689710661769, 0.011011216789484, 0.0110536180436611, 0.0110960761085153, 0.0111386170610785, 0.0111812856048346, 0.0112239960581064, 0.0112668331712484, 0.0113097410649061, 0.0113527188077569, 0.0113958502188325, 0.0114390393719077, 0.0114823123440146, 0.0115256831049919, 0.0115691246464849, 0.0116126947104931, 0.0116563327610493, 0.0117000695317984, 0.0117438910529017, 0.0117877824231982, 0.011831815354526, 0.0118758901953697, 0.0119201047345996, 0.0119643621146679, 0.0120087191462517, 0.0120532009750605, 0.0120977535843849, 0.0121424039825797, 0.0121871260926127, 0.0122319459915161, 0.012276865541935, 0.0123218670487404, 0.0123669700697064, 0.0124121680855751, 0.012457424774766, 0.012502821162343, 0.0125482743605971, 0.0125938262790442, 0.0126394759863615, 0.0126851815730333, 0.0127310138195753, 0.012776929885149, 0.012822974473238, 0.0128690451383591, 0.0129152294248343, 0.0129615124315023, 0.0130078792572021, 0.0130543587729335, 0.0131008950993419, 0.0131475292146206, 0.0131942750886083, 0.013241077773273, 0.0132880210876465, 0.013335021212697, 0.0133821051567793, 0.0134293017908931, 0.0134765692055225, 0.013523948378861, 0.0135714272037148, 0.013618947006762, 0.0136666083708405, 0.0137143675237894, 0.0137621816247702, 0.013810102827847, 0.0138580817729235, 0.0139061845839024, 0.0139543870463967, 0.0140026593580842, 0.014051022939384, 0.0140994861721992, 0.0141480462625623, 0.0141966845840216, 0.014245449565351, 0.0142942629754543, 0.0143431546166539, 0.0143921794369817, 0.0144412964582443, 0.014490476809442, 0.0145397540181875, 0.0145891299471259, 0.0146385915577412, 0.0146881230175495, 0.0147377736866474, 0.014787508174777, 0.0148373218253255, 0.0148872528225183, 0.0149372490122914, 0.0149873839691281, 0.0150375766679645, 0.0150878243148327, 0.0151382209733129, 0.0151886669918895, 0.0152392387390137, 0.015289880335331, 0.0153406141325831, 0.015391431748867, 0.0154423341155052, 0.0154933277517557, 0.0155444694682956, 0.0155956326052547, 0.0156469140201807, 0.0156983155757189, 0.0157497655600309, 0.0158013161271811, 0.0158529710024595, 0.0159047171473503, 0.0159565340727568, 0.0160084404051304, 0.0160604491829872, 0.0161125548183918, 0.0161647349596024, 0.0162170212715864, 0.0162693876773119, 0.0163218658417463, 0.0163743998855352, 0.0164270363748074, 0.0164797957986593, 0.016532626003027, 0.0165855325758457, 0.0166385434567928, 0.0166916474699974, 0.0167448446154594, 0.0167981218546629, 0.0168514922261238, 0.0169049762189388, 0.0169585142284632, 0.0170121528208256, 0.0170659087598324, 0.0171197298914194, 0.017173619940877, 0.0172276459634304, 0.0172817539423704, 0.0173359476029873, 0.0173902250826359, 0.0174446012824774, 0.0174990631639957, 0.0175536274909973, 0.0176082625985146, 0.0176630057394505, 0.0177178308367729, 0.0177727565169334, 0.0178277660161257, 0.0178828649222851, 0.0179380550980568, 0.0179933402687311, 0.0180486999452114, 0.0181041732430458, 0.0181597098708153, 0.0182153731584549, 0.018271092325449, 0.0183269456028938, 0.018382865935564, 0.0184388533234596, 0.0184949804097414, 0.0185511708259583, 0.0186074525117874, 0.0186638180166483, 0.0187202766537666, 0.0187768470495939, 0.0188334807753563, 0.0188902113586664, 0.0189470387995243, 0.0190039686858654, 0.019060967490077, 0.0191180799156427, 0.019175274297595, 0.0192325562238693, 0.0192899201065302, 0.0193473976105452, 0.0194049663841724, 0.0194626040756702, 0.0195203479379416, 0.0195781644433737, 0.0196360759437084, 0.0196941159665585, 0.0197522062808275, 0.0198103915899992, 0.0198686700314283, 0.0199270397424698, 0.0199855230748653, 0.020044082775712, 0.020102720707655, 0.0201614424586296, 0.0202202964574099, 0.0202792081981897, 0.0203382261097431, 0.0203973278403282, 0.020456513389945, 0.0205157976597548, 0.0205751787871122, 0.0206346455961466, 0.0206941980868578, 0.0207538399845362, 0.020813575014472, 0.0208734143525362, 0.0209333300590515, 0.0209933407604694, 0.0210534390062094, 0.0211136378347874, 0.0211739260703325, 0.0212343037128448, 0.0212947614490986, 0.0213553179055452, 0.0214159805327654, 0.0214767176657915, 0.0215375442057848, 0.0215984731912613, 0.0216594729572535, 0.0217205714434385, 0.021781774237752, 0.0218430571258068, 0.0219044405966997, 0.0219658855348825, 0.0220274552702904, 0.0220891088247299, 0.0221508461982012, 0.0222126767039299, 0.0222745910286903, 0.0223366040736437, 0.0223987083882093, 0.0224609188735485, 0.0225232038646936, 0.022585567086935, 0.0226480308920145, 0.0227105915546417, 0.0227732285857201, 0.0228359885513783, 0.0228988081216812, 0.0229617357254028, 0.0230247601866722, 0.0230878479778767, 0.0231510568410158, 0.0232143346220255, 0.0232777111232281, 0.0233411937952042, 0.0234047397971153, 0.0234683826565742, 0.0235321391373873, 0.0235959589481354, 0.0236598886549473, 0.0237238854169846, 0.0237879939377308, 0.0238521732389927, 0.0239164624363184, 0.0239808447659016, 0.0240453109145164, 0.0241098906844854, 0.0241745263338089, 0.024239256978035, 0.0243041198700666, 0.024369029328227, 0.0244340356439352, 0.024499149993062, 0.0245643500238657, 0.0246296226978302, 0.0246950034052134, 0.0247604623436928, 0.0248260106891394, 0.0248916726559401, 0.0249574184417725, 0.0250232554972172, 0.0250891670584679, 0.0251551866531372, 0.0252212919294834, 0.025287501513958, 0.025353766977787, 0.0254201628267765, 0.0254866387695074, 0.0255531724542379, 0.0256198327988386, 0.0256865844130516, 0.0257534068077803, 0.0258203279227018, 0.0258873328566551, 0.0259544271975756, 0.0260216444730759, 0.0260889306664467, 0.026156309992075, 0.0262237768620253, 0.026291336864233, 0.0263589899986982, 0.0264267306774855, 0.0264945756644011, 0.026562487706542, 0.0266305096447468, 0.0266986060887575, 0.0267668142914772, 0.0268350914120674, 0.0269034449011087, 0.0269719418138266, 0.0270405020564795, 0.0271091423928738, 0.0271779000759125, 0.0272467192262411, 0.0273156370967627, 0.0273846592754126, 0.0274537671357393, 0.027522973716259, 0.0275922492146492, 0.0276616457849741, 0.0277311112731695, 0.0278032440692186, 0.0278781019151211, 0.0279530473053455, 0.0280280895531178, 0.0281032603234053, 0.028178509324789, 0.0282538775354624, 0.0283293128013611, 0.0284048765897751, 0.0284805372357368, 0.028556264936924, 0.0286321528255939, 0.0287080816924572, 0.0287841353565454, 0.0288603045046329, 0.028936542570591, 0.0290129072964191, 0.0290893390774727, 0.0291658863425255, 0.0292425602674484, 0.0293192900717258, 0.0293961465358734, 0.0294730868190527, 0.0295501258224249, 0.0296272914856672, 0.0297045409679413, 0.0297818891704082, 0.0298593249171972, 0.029936857521534, 0.0300144981592894, 0.030092241242528, 0.0301700960844755, 0.0302480347454548, 0.0303260888904333, 0.0304042231291533, 0.0304824858903885, 0.0305608045309782, 0.030639223754406, 0.0307178068906069, 0.0307964365929365, 0.0308751631528139, 0.0309540182352066, 0.031032957136631, 0.0311120059341192, 0.0311911255121231, 0.0312703736126423, 0.0313497334718704, 0.031429149210453, 0.0315086767077446, 0.0315883308649063, 0.0316680707037449, 0.0317479111254215, 0.0318278335034847, 0.0319078527390957, 0.031988013535738, 0.0320682339370251, 0.0321485623717308, 0.0322290025651455, 0.0323095321655273, 0.0323901548981667, 0.0324708931148052, 0.0325517281889915, 0.0326326489448547, 0.0327136851847172, 0.0327947996556759, 0.0328760482370853, 0.0329573713243008, 0.0330388024449348, 0.0331203155219555, 0.0332019664347172, 0.0332836844027042, 0.0333655178546906, 0.0334474295377731, 0.0335294604301453, 0.0336115919053555, 0.0336938016116619, 0.0337761454284191, 0.0338585413992405, 0.0339410752058029, 0.0340237021446228, 0.034106407314539, 0.0341892689466476, 0.0342721603810787, 0.0343551896512508, 0.0344383344054222, 0.0345215313136578, 0.0346048586070538, 0.0346882827579975, 0.0347717851400375, 0.0348554216325283, 0.0349391289055347, 0.0350229479372501, 0.0351068489253521, 0.0351908765733242, 0.0352750085294247, 0.0353592298924923, 0.0354435257613659, 0.0355279371142387, 0.0356124565005302, 0.0356970727443695, 0.0357818081974983, 0.0358666218817234, 0.0359515063464642, 0.0360365211963654, 0.0361216515302658, 0.0362068563699722, 0.0362921953201294, 0.0363775603473186, 0.0364630781114101, 0.0365487113595009, 0.0366344265639782, 0.0367202311754227, 0.0368061140179634, 0.0368921346962452, 0.0369782485067844, 0.0370644554495811, 0.0371507629752159, 0.0372371673583984, 0.0373236574232578, 0.0374102890491486, 0.037496991455555, 0.0375837907195091, 0.0376706980168819, 0.0377576984465122, 0.0378447957336903, 0.0379320122301579, 0.0380193144083023, 0.0381067097187042, 0.0381942130625248, 0.0382817983627319, 0.0383695438504219, 0.0384573340415955, 0.0385452061891556, 0.0386332273483276, 0.0387213155627251, 0.0388095118105412, 0.0388978160917759, 0.0389861911535263, 0.0390747040510178, 0.0391633026301861, 0.0392519980669022, 0.0393407978117466, 0.0394296944141388, 0.0395186729729176, 0.0396077893674374, 0.0396969802677631, 0.0397862680256367, 0.0398756563663483, 0.0399651676416397, 0.0400547496974468, 0.0401444509625435, 0.0402342453598976, 0.0403241254389286, 0.0404141172766685, 0.0405042059719563, 0.0405943915247917, 0.0406846925616264, 0.0407750681042671, 0.0408655665814877, 0.0409561470150948, 0.0410468690097332, 0.0411376357078552, 0.0412285216152668, 0.0413195192813873, 0.0414105877280235, 0.0415017753839493, 0.041593074798584, 0.0416844300925732, 0.0417759269475937, 0.0418675392866135, 0.0419592000544071, 0.0420509949326515, 0.0421428568661213, 0.0422348305583, 0.0423269458115101, 0.0424191132187843, 0.0425113886594772, 0.0426037684082985, 0.042696263641119, 0.0427888445556164, 0.0428815186023712, 0.0429742969572544, 0.0430672019720078, 0.0431601442396641, 0.0432532168924809, 0.0433464124798775, 0.0434396825730801, 0.0435330644249916, 0.0436265282332897, 0.0437201075255871, 0.0438137948513031, 0.0439075715839863, 0.044001430273056, 0.044095404446125, 0.0441894717514515, 0.0442836508154869, 0.0443779341876507, 0.044472299516201, 0.0445667654275894, 0.0446613393723965, 0.0447560027241707, 0.0448507890105247, 0.0449456423521042, 0.045040600001812, 0.0451356843113899, 0.0452308617532253, 0.0453261137008667, 0.0454214811325073, 0.0455169528722763, 0.0456125475466251, 0.0457081869244576, 0.0458039604127407, 0.0458998344838619, 0.0459957867860794, 0.0460918545722961, 0.0461880341172218, 0.0462842807173729, 0.0463806614279747, 0.0464771017432213, 0.0465736649930477, 0.046670351177454, 0.0467671044170856, 0.0468639507889748, 0.0469609089195728, 0.0470579750835896, 0.0471551269292831, 0.0472524091601372, 0.0473497658967972, 0.0474472120404243, 0.0475447662174702, 0.0476424247026443, 0.0477402061223984, 0.0478380471467972, 0.0479359850287437, 0.0480340756475925, 0.0481322109699249, 0.0482304692268372, 0.0483288317918777, 0.0484272725880146, 0.048525832593441, 0.0486244857311249, 0.0487232394516468, 0.0488220900297165, 0.0489210411906242, 0.0490200743079185, 0.049119234085083, 0.0492184944450855, 0.049317866563797, 0.0494172945618629, 0.0495168343186378, 0.049616489559412, 0.0497162416577339, 0.0498161017894745, 0.0499160327017307, 0.0500160679221153, 0.0501162298023701, 0.0502164736390114, 0.0503168255090714, 0.0504172705113888, 0.0505178086459637, 0.0506184622645378, 0.0507192090153694, 0.0508200563490391, 0.0509209744632244, 0.0510220229625702, 0.0511231794953346, 0.0512244254350662, 0.0513257645070553, 0.0514272004365921, 0.0515287406742573, 0.0516303740441799, 0.0517321117222309, 0.0518339760601521, 0.0519358888268471, 0.0520379170775414, 0.0521400757133961, 0.0522423200309277, 0.0523446574807167, 0.0524470955133438, 0.0525496155023575, 0.0526522658765316, 0.0527549982070923, 0.0528578273952007, 0.0529607571661472, 0.0530637986958027, 0.0531669296324253, 0.0532701835036278, 0.0533735044300556, 0.0534769259393215, 0.0535804592072964, 0.0536840781569481, 0.0537878274917603, 0.0538916550576687, 0.0539955720305443, 0.0540996082127094, 0.0542037338018417, 0.0543079897761345, 0.0544123090803623, 0.0545167326927185, 0.0546212643384933, 0.0547258779406548, 0.0548306107521057, 0.0549354515969753, 0.0550403520464897, 0.0551453903317451, 0.0552505142986774, 0.0553557388484478, 0.0554610677063465, 0.0555664822459221, 0.0556719973683357, 0.0557776391506195, 0.055883351713419, 0.0559891797602177, 0.0560951046645641, 0.0562011152505875, 0.0563072562217712, 0.0564134605228901, 0.0565197803080082, 0.056626208126545, 0.0567327253520489, 0.0568393394351006, 0.0569460727274418, 0.057052880525589, 0.0571597889065742, 0.0572668090462685, 0.0573739223182201, 0.0574811324477196, 0.0575884692370892, 0.0576958619058132, 0.0578033775091171, 0.0579109974205494, 0.0580187067389488, 0.0581265352666378, 0.0582344233989716, 0.0583424605429173, 0.0584505647420883, 0.0585587695240974, 0.0586671009659767, 0.0587754733860493, 0.0588839985430241, 0.0589926205575466, 0.0591013357043266, 0.0592101439833641, 0.0593190379440784, 0.0594280548393726, 0.0595371723175049, 0.0596463605761528, 0.0597556754946709, 0.0598650798201561, 0.0599745884537697, 0.0600841976702213, 0.060193907469511, 0.0603036992251873, 0.0604136027395725, 0.0605236068367958, 0.0606337040662766, 0.060743935406208, 0.0608542263507843, 0.0609645992517471, 0.0610751286149025, 0.0611857287585735, 0.0612964183092117, 0.0614072382450104, 0.0615181140601635, 0.0616291165351868, 0.0617402195930481, 0.0618514157831669, 0.0619627423584461, 0.0620741099119186, 0.0621856041252613, 0.0622972249984741, 0.0624089129269123, 0.0625207051634789, 0.0626326054334641, 0.0627445951104164, 0.0628566965460777, 0.0629688799381256, 0.0630811750888824, 0.0631935596466064, 0.06330606341362, 0.0634186565876007, 0.0635313391685486, 0.0636441484093666, 0.0637570321559906, 0.063870020210743, 0.0639831125736237, 0.0640963166952133, 0.0642095878720284, 0.0643229708075523, 0.0644364655017853, 0.0645500421524048, 0.0646637380123138, 0.0647775381803513, 0.0648913979530334, 0.0650054067373276, 0.0651194900274277, 0.0652336850762367, 0.0653479844331741, 0.0654623284935951, 0.0655768364667892, 0.0656914263963699, 0.0658060908317566, 0.0659208968281746, 0.0660357624292374, 0.0661507248878479, 0.066265843808651, 0.066380999982357, 0.0664962753653526, 0.0666116774082184, 0.0667271390557289, 0.066842719912529, 0.066958412528038, 0.067074179649353, 0.0671900436282158, 0.0673060417175293, 0.0674221143126488, 0.0675382986664772, 0.0676545798778534, 0.0677709355950356, 0.0678874179720879, 0.0680039972066879, 0.0681206807494164, 0.0682374611496925, 0.0683543160557747, 0.068471297621727, 0.0685883685946465, 0.0687055364251137, 0.0688228160142899, 0.0689401775598526, 0.0690576359629631, 0.0691752135753632, 0.0692928954958916, 0.0694106742739677, 0.0695285201072693, 0.0696465075016022, 0.0697645768523216, 0.0698827356100082, 0.0700010135769844, 0.0701193735003471, 0.0702378302812576, 0.0703564137220383, 0.0704750791192055, 0.0705938264727592, 0.0707127079367638, 0.0708316713571548, 0.0709507167339325, 0.0710699036717415, 0.0711891651153564, 0.0713085308670998, 0.0714279860258102, 0.0715475380420685, 0.0716672241687775, 0.0717869773507118, 0.0719068124890327, 0.0720268040895462, 0.0721468552947044, 0.072267010807991, 0.0723872855305672, 0.0725076273083687, 0.0726280733942986, 0.0727486535906792, 0.0728692933917046, 0.0729900747537613, 0.073110930621624, 0.0732318684458733, 0.0733529254794121, 0.0734741017222404, 0.0735953375697136, 0.0737166702747345, 0.0738381445407867, 0.0739597156643867, 0.0740813538432121, 0.0742031112313271, 0.0743249654769897, 0.0744468867778778, 0.0745689496397972, 0.0746911093592644, 0.0748133733868599, 0.074935719370842, 0.0750581547617912, 0.0751807019114494, 0.0753033682703972, 0.0754261091351509, 0.0755489617586136, 0.0756718963384628, 0.075794942677021, 0.0759180933237076, 0.0760413482785225, 0.076164685189724, 0.0762881338596344, 0.0764116644859314, 0.0765353068709373, 0.076659083366394, 0.0767829120159149, 0.0769068375229836, 0.0770309045910835, 0.0771550238132477, 0.077279269695282, 0.0774036273360252, 0.0775280520319939, 0.0776522755622864, 0.0777762532234192, 0.0779003128409386, 0.0780244916677475, 0.0781487450003624, 0.0782730802893639, 0.0783975422382355, 0.0785220563411713, 0.0786466598510742, 0.0787713751196861, 0.078896164894104, 0.0790210589766502, 0.0791460201144218, 0.0792710706591606, 0.0793962329626083, 0.0795214995741844, 0.0796468183398247, 0.0797722339630127, 0.0798977464437485, 0.0800233781337738, 0.0801490619778633, 0.08027483522892, 0.080400712788105, 0.0805266797542572, 0.0806527435779572, 0.0807788968086243, 0.0809051096439362, 0.0810314267873764, 0.0811578556895256, 0.0812843516469002, 0.0814109668135643, 0.0815376341342926, 0.0816644132137299, 0.0817912817001343, 0.0819182321429253, 0.0820452719926834, 0.0821724161505699, 0.0822996348142624, 0.0824269577860832, 0.0825543627142906, 0.0826818272471428, 0.0828094407916069, 0.0829371064901352, 0.0830648615956306, 0.0831927284598351, 0.0833206623792648, 0.0834486857056618, 0.0835768282413483, 0.0837050378322601, 0.0838333293795586, 0.0839617401361465, 0.0840902104973793, 0.0842187851667404, 0.0843474417924881, 0.0844761952757835, 0.0846050381660461, 0.0847339853644371, 0.0848630145192146, 0.0849921181797981, 0.0851213186979294, 0.085250623524189, 0.0853800028562546, 0.0855094641447067, 0.0856390371918678, 0.0857686996459961, 0.0858984366059303, 0.0860282778739929, 0.0861581936478615, 0.0862882137298584, 0.0864183157682419, 0.0865485146641731, 0.0866787806153297, 0.0868091583251953, 0.0869396179914474, 0.0870701819658279, 0.0872008129954338, 0.087331548333168, 0.0874623730778694, 0.0875932797789574, 0.0877243131399155, 0.0878553912043571, 0.0879865512251854, 0.088117852807045, 0.0882492139935493, 0.0883806645870209, 0.088512197136879, 0.0886438265442848, 0.0887755677103996, 0.0889073759317398, 0.0890392661094666, 0.0891712754964828, 0.0893033593893051, 0.0894355177879333, 0.0895678102970123, 0.0897001400589943, 0.089832566678524, 0.0899651274085045, 0.0900977477431297, 0.0902304574847221, 0.0903632640838623, 0.090496152639389, 0.0906291455030441, 0.0907622203230858, 0.0908953472971916, 0.0910286158323288, 0.0911619812250137, 0.0912954062223434, 0.0914289206266403, 0.0915625393390656, 0.0916962474584579, 0.0918300300836563, 0.091963917016983, 0.0920978859066963, 0.0922319516539574, 0.092366099357605, 0.0925003439188004, 0.0926346927881241, 0.0927691087126732, 0.0929036140441895, 0.0930382162332535, 0.0931729152798653, 0.0933076962828636, 0.0934425666928291, 0.0935775339603424, 0.0937125682830811, 0.0938477292656898, 0.093982957303524, 0.0941182672977448, 0.094253696501255, 0.0943892076611519, 0.0945247858762741, 0.0946604758501053, 0.0947962403297424, 0.0949320942163467, 0.0950680673122406, 0.095204085111618, 0.095340222120285, 0.0954764559864998, 0.0956127569079399, 0.0957491919398308, 0.095885656774044, 0.0960222408175468, 0.096158929169178, 0.0962956771254539, 0.0964325144886971, 0.0965694785118103, 0.0967065021395683, 0.0968436300754547, 0.0969808474183083, 0.0971181318163872, 0.097255527973175, 0.0973930209875107, 0.0975305885076523, 0.0976682379841805, 0.0978059992194176, 0.0979438573122025, 0.0980817675590515, 0.0982198044657707, 0.0983579233288765, 0.0984961092472076, 0.0986344069242477, 0.098772794008255, 0.0989112555980682, 0.0990498214960098, 0.0991884768009186, 0.0993272066116333, 0.0994660630822182, 0.099604956805706, 0.099743977189064, 0.0998831018805504, 0.10002226382494, 0.10016156733036, 0.100300930440426, 0.100440390408039, 0.100579954683781, 0.100719593465328, 0.100859314203262, 0.100999161601067, 0.101139046251774, 0.101279050111771, 0.101419158279896, 0.101559333503246, 0.101699590682983, 0.101839974522591, 0.101980395615101, 0.102120950818062, 0.102261580526829, 0.102402299642563, 0.102543123066425, 0.102684020996094, 0.102825008332729, 0.102966092526913, 0.103107273578644, 0.103248529136181, 0.103389881551266, 0.103531315922737, 0.103672854602337, 0.103814482688904, 0.103956192731857, 0.104097977280617, 0.104239888489246, 0.104381859302521, 0.104523919522762, 0.104666091501713, 0.10480834543705, 0.104950681328773, 0.105093128979206, 0.105235636234283, 0.105378247797489, 0.105520956218243, 0.105663731694221, 0.105806611478329, 0.105949595570564, 0.106092661619186, 0.106235794723034, 0.106379047036171, 0.106522381305695, 0.106665790081024, 0.106809310615063, 0.106952920556068, 0.107096597552299, 0.10724038630724, 0.107384257018566, 0.10752822458744, 0.107672274112701, 0.107816405594349, 0.107960648834705, 0.108104951679707, 0.108249381184578, 0.108393870294094, 0.108538456261158, 0.10868314653635, 0.108827903866768, 0.108972780406475, 0.109117724001408, 0.109262764453888, 0.109407901763916, 0.109553121030331, 0.109698429703712, 0.109843820333481, 0.109989322721958, 0.110134907066822, 0.110280573368073, 0.11042632907629, 0.110572189092636, 0.110718131065369, 0.110864147543907, 0.111010290682316, 0.111156485974789, 0.11130279302597, 0.111449189484119, 0.111595652997494, 0.111742228269577, 0.111888885498047, 0.112035654485226, 0.112182483077049, 0.112329408526421, 0.112476445734501, 0.112623549997807, 0.112770743668079, 0.112918041646481, 0.113065414130688, 0.113212898373604, 0.113360457122326, 0.113508090376854, 0.113655835390091, 0.113803677260876, 0.113951586186886, 0.114099591970444, 0.11424770206213, 0.114395894110203, 0.114544160664082, 0.114692538976669, 0.114841006696224, 0.114989563822746, 0.115138188004494, 0.11528692394495, 0.115435741841793, 0.115584649145603, 0.11573364585638, 0.115882739424706, 0.116031929850578, 0.116181187331676, 0.116330556571484, 0.116480000317097, 0.116629540920258, 0.116779170930386, 0.116928890347481, 0.117078714072704, 0.117228612303734, 0.117378585040569, 0.117528676986694, 0.117678843438625, 0.117829099297523, 0.117979452013969, 0.118129901587963, 0.118280433118343, 0.11843103915453, 0.118581756949425, 0.118732564151287, 0.118883438408375, 0.119034416973591, 0.119185492396355, 0.119336642324924, 0.119487904012203, 0.119639247655869, 0.11979066580534, 0.11994219571352, 0.120093800127506, 0.12024549394846, 0.120397284626961, 0.120549164712429, 0.120701134204865, 0.120853185653687, 0.121005348861217, 0.121157601475716, 0.121309906244278, 0.12146233767271, 0.121614843606949, 0.121767453849316, 0.121920138597488, 0.122072912752628, 0.122225791215897, 0.122378751635551, 0.122531801462173, 0.122684940695763, 0.122838169336319, 0.122991472482681, 0.123144894838333, 0.12329838424921, 0.123451977968216, 0.123605661094189, 0.123759426176548, 0.123913295567036, 0.12406724691391, 0.12422127276659, 0.124375395476818, 0.124529629945755, 0.124683946371078, 0.124838337302208, 0.124992825090885, 0.12514740228653, 0.125302076339722, 0.12545682489872, 0.125611677765846, 0.12576662003994, 0.125921651721001, 0.126076772809029, 0.126231968402863, 0.126387268304825, 0.126542672514915, 0.126698151230812, 0.126853704452515, 0.127009376883507, 0.127165123820305, 0.12732096016407, 0.127476885914803, 0.127632915973663, 0.127789005637169, 0.127945214509964, 0.128101512789726, 0.128257885575294, 0.12841434776783, 0.128570914268494, 0.128727570176125, 0.128884300589561, 0.129041120409966, 0.129198059439659, 0.129355043172836, 0.129512161016464, 0.129669353365898, 0.129826620221138, 0.129983991384506, 0.13014143705368, 0.130299001932144, 0.130456626415253, 0.130614370107651, 0.130772188305855, 0.130930081009865, 0.131088107824326, 0.13124617934227, 0.131404370069504, 0.131562635302544, 0.131720989942551, 0.131879404187202, 0.132037982344627, 0.132196620106697, 0.13235530257225, 0.132514119148254, 0.132673025131226, 0.132832035422325, 0.132991090416908, 0.13315024971962, 0.13330951333046, 0.133468881249428, 0.133628308773041, 0.133787825703621, 0.133947461843491, 0.134107157588005, 0.134266957640648, 0.134426832199097, 0.134586811065674, 0.134746879339218, 0.13490703701973, 0.135067284107208, 0.135227650403976, 0.135388076305389, 0.13554859161377, 0.135709196329117, 0.13586987555027, 0.136030673980713, 0.136191561818123, 0.136352524161339, 0.136513575911522, 0.136674731969833, 0.136835977435112, 0.136997297406197, 0.137158706784248, 0.137320220470428, 0.137481823563576, 0.13764351606369, 0.137805297970772, 0.137967169284821, 0.138129085302353, 0.138291165232658, 0.13845331966877, 0.138615518808365, 0.138777837157249, 0.138940259814262, 0.139102727174759, 0.139265328645706, 0.139428019523621, 0.139590784907341, 0.139753639698029, 0.139916583895683, 0.140079647302628, 0.140242755413055, 0.140405967831612, 0.140569284558296, 0.140732660889626, 0.140896171331406, 0.141059741377831, 0.141223415732384, 0.141387164592743, 0.14155101776123, 0.141714960336685, 0.141878977417946, 0.142043098807335, 0.14220729470253, 0.142371594905853, 0.142535999417305, 0.142700463533401, 0.142865031957626, 0.143029674887657, 0.143194437026978, 0.143359273672104, 0.143524214625359, 0.143689230084419, 0.143854334950447, 0.144019529223442, 0.144184812903404, 0.144350200891495, 0.144515663385391, 0.144681215286255, 0.144846856594086, 0.145012602210045, 0.14517842233181, 0.145344346761703, 0.145510345697403, 0.14567643404007, 0.145842641592026, 0.146008908748627, 0.146175265312195, 0.146341741085052, 0.146508291363716, 0.146674916148186, 0.146841660141945, 0.147008463740349, 0.147175371646881, 0.147342368960381, 0.147509455680847, 0.147676631808281, 0.147843882441521, 0.14801125228405, 0.148178696632385, 0.148346245288849, 0.148513868451118, 0.148681595921516, 0.148849382996559, 0.149017289280891, 0.149185284972191, 0.149353355169296, 0.14952152967453, 0.14968977868557, 0.149858117103577, 0.150026559829712, 0.150195091962814, 0.150363698601723, 0.150532409548759, 0.150701224803925, 0.15087802708149, 0.151062741875648, 0.15124748647213, 0.151432231068611, 0.151617005467415, 0.15180179476738, 0.151986613869667, 0.152171432971954, 0.152356296777725, 0.152541175484657, 0.152726054191589, 0.152910977602005, 0.153095915913582, 0.153280884027481, 0.153465837240219, 0.153650835156441, 0.153835847973824, 0.154020875692368, 0.154205948114395, 0.154391005635262, 0.15457609295845, 0.154761210083961, 0.154946342110634, 0.155131474137306, 0.155316650867462, 0.155501842498779, 0.155687063932419, 0.155872270464897, 0.15605753660202, 0.156242817640305, 0.156428083777428, 0.156613394618034, 0.156798720359802, 0.156984075903893, 0.157169431447983, 0.157354831695557, 0.15754023194313, 0.157725661993027, 0.157911121845245, 0.158096581697464, 0.158282056450844, 0.158467575907707, 0.158653095364571, 0.158838629722595, 0.159024208784103, 0.159209802746773, 0.159395396709442, 0.159581020474434, 0.159766659140587, 0.159952327609062, 0.160138010978699, 0.160323724150658, 0.160509452223778, 0.160695180296898, 0.160880967974663, 0.161066725850105, 0.161252528429031, 0.161438345909119, 0.16162420809269, 0.161810055375099, 0.161995947360992, 0.162181854248047, 0.162367761135101, 0.162553697824478, 0.162739664316177, 0.162925645709038, 0.163111627101898, 0.163297653198242, 0.163483694195747, 0.163669750094414, 0.163855835795403, 0.164041936397552, 0.164228051900864, 0.164414182305336, 0.164600357413292, 0.164786517620087, 0.164972707629204, 0.165158927440643, 0.165345162153244, 0.165531426668167, 0.165717706084251, 0.165904000401497, 0.166090309619904, 0.166276648640633, 0.166463017463684, 0.166649386286736, 0.166835784912109, 0.167022198438644, 0.167208626866341, 0.167395070195198, 0.167581558227539, 0.167768031358719, 0.167954564094543, 0.168141081929207, 0.168327659368515, 0.168514221906662, 0.16870079934597, 0.168887421488762, 0.169074043631554, 0.169260695576668, 0.169447377324104, 0.169634059071541, 0.169820785522461, 0.170007511973381, 0.170194253325462, 0.170381009578705, 0.170567810535431, 0.170754626393318, 0.170941442251205, 0.171128287911415, 0.171315178275108, 0.17150205373764, 0.171688973903656, 0.171875894069672, 0.172062829136848, 0.172249808907509, 0.172436788678169, 0.172623798251152, 0.172810822725296, 0.172997877001762, 0.173184931278229, 0.173372030258179, 0.173559129238129, 0.173746258020401, 0.173933386802673, 0.174120560288429, 0.174307748675346, 0.174494951963425, 0.174682170152664, 0.174869418144226, 0.175056681036949, 0.175243958830833, 0.17543126642704, 0.175618574023247, 0.175805926322937, 0.175993293523788, 0.176180675625801, 0.176368072628975, 0.176555499434471, 0.17674295604229, 0.176930397748947, 0.177117884159088, 0.17730538547039, 0.177492916584015, 0.177680432796478, 0.177868008613586, 0.178055584430695, 0.178243175148964, 0.178430795669556, 0.17861844599247, 0.178806096315384, 0.17899377644062, 0.179181486368179, 0.179369196295738, 0.17955693602562, 0.179744675755501, 0.179932460188866, 0.180120244622231, 0.180308073759079, 0.180495902895927, 0.180683761835098, 0.18087163567543, 0.181059539318085, 0.181247442960739, 0.181435391306877, 0.181623339653015, 0.181811302900314, 0.181999310851097, 0.182187333703041, 0.182375341653824, 0.182563424110413, 0.18275149166584, 0.182939574122429, 0.18312768638134, 0.183315813541412, 0.183503970503807, 0.183692142367363, 0.183880344033241, 0.184068560600281, 0.18425677716732, 0.184445008635521, 0.184633299708366, 0.184821575880051, 0.185009881854057, 0.185198217630386, 0.185386568307877, 0.185574933886528, 0.185763314366341, 0.185951739549637, 0.186140164732933, 0.186328619718552, 0.186517089605331, 0.186705559492111, 0.186894074082375, 0.187082603573799, 0.187271147966385, 0.187459722161293, 0.187648296356201, 0.187836915254593, 0.188025519251823, 0.188214182853699, 0.188402846455574, 0.188591539859772, 0.188780233263969, 0.188968971371651, 0.189157709479332, 0.189346477389336, 0.1895352602005, 0.189724057912827, 0.189912885427475, 0.190101727843285, 0.190290585160255, 0.190479472279549, 0.190668374300003, 0.190857291221619, 0.191046237945557, 0.191235214471817, 0.191424176096916, 0.191613167524338, 0.191802188754082, 0.191991254687309, 0.192180305719376, 0.192369386553764, 0.192558482289314, 0.192747607827187, 0.19293674826622, 0.193125903606415, 0.193315073847771, 0.19350428879261, 0.193693488836288, 0.19388273358345, 0.194071993231773, 0.194261267781258, 0.194450557231903, 0.194639891386032, 0.194829210639, 0.195018574595451, 0.195207938551903, 0.195397347211838, 0.195586770772934, 0.195776224136353, 0.195965647697449, 0.19615513086319, 0.196344628930092, 0.196534141898155, 0.196723684668541, 0.196913227438927, 0.197102814912796, 0.197292402386665, 0.197482004761696, 0.19767165184021, 0.197861298918724, 0.198050960898399, 0.198240652680397, 0.198430344462395, 0.198620110750198, 0.198809862136841, 0.198999613523483, 0.199189409613609, 0.199379220604897, 0.199569061398506, 0.199758902192116, 0.199948772788048, 0.200138658285141, 0.200328573584557, 0.200518503785133, 0.200708448886871, 0.200898408889771, 0.201088413596153, 0.201278418302536, 0.20146843791008, 0.201658502221107, 0.201848566532135, 0.202038660645485, 0.202228739857674, 0.202418878674507, 0.202609017491341, 0.202799201011658, 0.202989384531975, 0.203179597854614, 0.203369811177254, 0.203560054302216, 0.2037503272295, 0.203940600156784, 0.204130917787552, 0.20432123541832, 0.204511567950249, 0.204701945185661, 0.204892337322235, 0.205082729458809, 0.205273151397705, 0.205463603138924, 0.205654039978981, 0.205844521522522, 0.206035047769547, 0.20622555911541, 0.206416115164757, 0.206606656312943, 0.206797242164612, 0.206987842917442, 0.207178473472595, 0.207369104027748, 0.207559764385223, 0.20775043964386, 0.207941144704819, 0.208131864666939, 0.20832259953022, 0.208513364195824, 0.208704128861427, 0.208894938230515, 0.209085762500763, 0.209276601672173, 0.209467455744743, 0.209658339619637, 0.20984922349453, 0.210040137171745, 0.210231065750122, 0.210422024130821, 0.210612997412682, 0.210804000496864, 0.210995003581047, 0.211186066269875, 0.211377114057541, 0.211568176746368, 0.21175928413868, 0.211950391530991, 0.212141513824463, 0.212332665920258, 0.212523847818375, 0.212715044617653, 0.212906256318092, 0.213097482919693, 0.213288724422455, 0.2134800106287, 0.213671296834946, 0.213862597942352, 0.214053943753242, 0.214245289564133, 0.214436680078506, 0.214628055691719, 0.214819461107254, 0.215010896325111, 0.21520234644413, 0.215393826365471, 0.215585306286812, 0.215776816010475, 0.2159683406353, 0.216159895062447, 0.216351449489594, 0.216543048620224, 0.216734647750854, 0.216926276683807, 0.217117935419083, 0.217309594154358, 0.217501267790794, 0.217692971229553, 0.217884719371796, 0.218076452612877, 0.218268215656281, 0.218460008502007, 0.218651816248894, 0.218843638896942, 0.219035476446152, 0.219227343797684, 0.219419226050377, 0.219611153006554, 0.219803065061569, 0.219994992017746, 0.220186963677406, 0.220378965139389, 0.220570936799049, 0.220762968063354, 0.220955014228821, 0.221147075295448, 0.221339151263237, 0.221531257033348, 0.22172337770462, 0.221915528178215, 0.222107693552971, 0.222299858927727, 0.222492069005966, 0.222684279084206, 0.222876533865929, 0.223068788647652, 0.223261058330536, 0.223453357815742, 0.223645687103271, 0.223838001489639, 0.224030375480652, 0.224222764372826, 0.224415138363838, 0.224607557058334, 0.224800005555153, 0.224992454051971, 0.225184932351112, 0.225377425551414, 0.225569948554039, 0.225762471556664, 0.22595502436161, 0.22614760696888, 0.22634020447731, 0.226532801985741, 0.226725459098816, 0.226918116211891, 0.227110788226128, 0.227303475141525, 0.227496176958084, 0.227688923478127, 0.22788168489933, 0.228074446320534, 0.22826723754406, 0.228460043668747, 0.228652879595757, 0.228845745325089, 0.22903861105442, 0.229231506586075, 0.22942441701889, 0.229617342352867, 0.229810297489166, 0.230003252625465, 0.230196252465248, 0.230389267206192, 0.230582281947136, 0.230775341391563, 0.230968415737152, 0.231161490082741, 0.231354609131813, 0.231547713279724, 0.231740891933441, 0.231934040784836, 0.232127234339714, 0.232320442795753, 0.232513666152954, 0.232706904411316, 0.232900172472, 0.233093470335007, 0.233286768198013, 0.233480095863342, 0.233673438429832, 0.233866810798645, 0.234060198068619, 0.234253600239754, 0.23444701731205, 0.234640464186668, 0.234833940863609, 0.23502741754055, 0.235220924019814, 0.235414430499077, 0.235607966780663, 0.235801547765732, 0.23599511384964, 0.236188739538193, 0.236382350325584, 0.23657600581646, 0.236769646406174, 0.236963331699371, 0.237157046794891, 0.237350761890411, 0.237544491887093, 0.237738251686096, 0.237932041287422, 0.238125830888748, 0.238319650292397, 0.238513484597206, 0.238707348704338, 0.238901227712631, 0.239095121622086, 0.239289045333862, 0.2394829839468, 0.239676937460899, 0.239870920777321, 0.240064918994904, 0.240258917212486, 0.240452960133553, 0.24064701795578, 0.24084110558033, 0.24103519320488, 0.241229310631752, 0.241423472762108, 0.241617605090141, 0.241811782121658, 0.242005974054337, 0.242200180888176, 0.242394417524338, 0.242588669061661, 0.242782950401306, 0.242977231740952, 0.243171572685242, 0.243365868926048, 0.2435602247715, 0.243754595518112, 0.243948996067047, 0.244143411517143, 0.244337826967239, 0.244532287120819, 0.244726777076721, 0.244921252131462, 0.245115771889687, 0.245310321450233, 0.245504826307297, 0.245702087879181, 0.24590191245079, 0.24610161781311, 0.246301174163818, 0.246500596404076, 0.246699869632721, 0.246899023652077, 0.247098043560982, 0.247296929359436, 0.247495695948601, 0.24769426882267, 0.247892752289772, 0.248091101646423, 0.248289331793785, 0.248487398028374, 0.248685330152512, 0.248883128166199, 0.249080777168274, 0.24927830696106, 0.249475717544556, 0.249672964215279, 0.249870076775551, 0.250067085027695, 0.250263929367065, 0.250460654497147, 0.250657230615616, 0.250853687524796, 0.251049995422363, 0.251246154308319, 0.251442193984985, 0.251638114452362, 0.251833885908127, 0.25202950835228, 0.252225011587143, 0.252420395612717, 0.252615600824356, 0.252810686826706, 0.253005623817444, 0.253200471401215, 0.253395140171051, 0.25358971953392, 0.253784149885178, 0.253978401422501, 0.254172533750534, 0.2543665766716, 0.254560440778732, 0.254754185676575, 0.254947781562805, 0.255141258239746, 0.255334585905075, 0.255527794361115, 0.255720853805542, 0.255913764238358, 0.256106555461884, 0.25629922747612, 0.256491780281067, 0.256684154272079, 0.256876409053802, 0.257068514823914, 0.257260501384735, 0.257452309131622, 0.257644057273865, 0.257835626602173, 0.258027046918869, 0.258218348026276, 0.258409529924393, 0.258600562810898, 0.258791476488113, 0.258982211351395, 0.259172856807709, 0.259363353252411, 0.259553700685501, 0.259743899106979, 0.25993400812149, 0.26012396812439, 0.260313779115677, 0.260503470897675, 0.260692983865738, 0.260882437229156, 0.261071711778641, 0.261260837316513, 0.261449843645096, 0.261638700962067, 0.26182746887207, 0.262016028165817, 0.262204498052597, 0.262392848730087, 0.262581020593643, 0.262769103050232, 0.262957006692886, 0.263144791126251, 0.263332456350327, 0.263519942760468, 0.263707309961319, 0.263894587755203, 0.264081686735153, 0.264268666505814, 0.264455527067184, 0.264642208814621, 0.26482880115509, 0.265015244483948, 0.265201508998871, 0.265387684106827, 0.265573680400848, 0.26575955748558, 0.265945374965668, 0.266130983829498, 0.266316473484039, 0.266501814126968, 0.266687005758286, 0.266872107982635, 0.267057061195374, 0.267241835594177, 0.267426520586014, 0.267611056566238, 0.267795443534851, 0.267979741096497, 0.268163859844208, 0.268347889184952, 0.268531709909439, 0.268715471029282, 0.268899083137512, 0.269082516431808, 0.269265830516815, 0.269449025392532, 0.269632071256638, 0.269814997911453, 0.269997745752335, 0.270180404186249, 0.270362943410873, 0.270545274019241, 0.270727545022964, 0.270909637212753, 0.271091610193253, 0.27127343416214, 0.271455138921738, 0.271636694669724, 0.271818101406097, 0.271999418735504, 0.272180587053299, 0.272361606359482, 0.272542476654053, 0.272723227739334, 0.272903859615326, 0.273084312677383, 0.273264706134796, 0.273444890975952, 0.273624956607819, 0.273804873228073, 0.27398470044136, 0.274164378643036, 0.274343907833099, 0.274523288011551, 0.274702548980713, 0.274881690740585, 0.275060683488846, 0.275239527225494, 0.275418251752853, 0.2755968272686, 0.275775283575058, 0.275953620672226, 0.276131808757782, 0.276309818029404, 0.276487767696381, 0.276665478944778, 0.276843160390854, 0.277020663022995, 0.277198016643524, 0.277375251054764, 0.277552336454391, 0.27772930264473, 0.277906149625778, 0.278082817792892, 0.27825939655304, 0.27843576669693, 0.278612107038498, 0.278788238763809, 0.278964251279831, 0.279140114784241, 0.279315859079361, 0.279491484165192, 0.27966696023941, 0.279842287302017, 0.280017524957657, 0.28019255399704, 0.280367493629456, 0.280542314052582, 0.280716985464096, 0.280891478061676, 0.281065851449966, 0.28124013543129, 0.281414240598679, 0.281588226556778, 0.281762093305588, 0.281935811042786, 0.282109379768372, 0.282282799482346, 0.282456129789352, 0.282629311084747, 0.28280234336853, 0.282975256443024, 0.283148020505905, 0.283320635557175, 0.283493161201477, 0.283665508031845, 0.283837735652924, 0.28400981426239, 0.284181773662567, 0.284353584051132, 0.284525275230408, 0.284696847200394, 0.284868240356445, 0.285039514303207, 0.28521066904068, 0.285381674766541, 0.285552561283112, 0.285723298788071, 0.285893887281418, 0.286064356565475, 0.286234676837921, 0.286404877901077, 0.286574959754944, 0.286744832992554, 0.286914676427841, 0.287084311246872, 0.287253856658936, 0.287423253059387, 0.287592470645905, 0.287761569023132, 0.287930548191071, 0.288099408149719, 0.288268119096756, 0.288436681032181, 0.288605093955994, 0.288773417472839, 0.288941591978073, 0.289109617471695, 0.289277523756027, 0.289445281028748, 0.289612919092178, 0.289780408143997, 0.289947777986526, 0.290114969015121, 0.290282070636749, 0.290449023246765, 0.290615797042847, 0.290782481431961, 0.290949046611786, 0.291115462779999, 0.2912817299366, 0.291447877883911, 0.291613847017288, 0.291779726743698, 0.291945457458496, 0.292111068964005, 0.292276501655579, 0.292441815137863, 0.292607009410858, 0.292772084474564, 0.292936980724335, 0.293101787567139, 0.293266445398331, 0.293430984020233, 0.293595314025879, 0.29375958442688, 0.293923676013947, 0.294087648391724, 0.294251471757889, 0.294415175914764, 0.294578790664673, 0.294742166996002, 0.294905513525009, 0.295068651437759, 0.29523167014122, 0.295394539833069, 0.295557290315628, 0.295719921588898, 0.295882403850555, 0.296044766902924, 0.29620698094368, 0.296369045972824, 0.296530991792679, 0.296692818403244, 0.296854436397552, 0.297016024589539, 0.297177404165268, 0.297338664531708, 0.29749983549118, 0.297660797834396, 0.297821670770645, 0.297982394695282, 0.298142969608307, 0.298303425312042, 0.298463732004166, 0.298623949289322, 0.298783957958221, 0.298943907022476, 0.299103677272797, 0.299263298511505, 0.299422830343246, 0.299582183361053, 0.299741446971893, 0.299900531768799, 0.300059497356415, 0.300218343734741, 0.300377011299133, 0.300535589456558, 0.300693988800049, 0.300852298736572, 0.301010429859161, 0.301168441772461, 0.301326364278793, 0.301484107971191, 0.301641702651978, 0.301799178123474, 0.301956534385681, 0.302113741636276, 0.302270799875259, 0.302427768707275, 0.302584558725357, 0.302741199731827, 0.302897721529007, 0.303054124116898, 0.303210377693176, 0.303366512060165, 0.303522497415543, 0.30367836356163, 0.303834080696106, 0.30398964881897, 0.304145127534866, 0.304300427436829, 0.304455578327179, 0.30461061000824, 0.304765552282333, 0.304920315742493, 0.305074959993362, 0.305229485034943, 0.305383801460266, 0.305538058280945, 0.305692166090012, 0.305846124887466, 0.305999904870987, 0.306153625249863, 0.306307166814804, 0.306460589170456, 0.306613862514496, 0.306767046451569, 0.306920021772385, 0.307072907686234, 0.30722564458847, 0.307378232479095, 0.307530701160431, 0.307683080434799, 0.307835280895233, 0.307987302541733, 0.308139234781265, 0.308291047811508, 0.308442711830139, 0.308594226837158, 0.308745622634888, 0.308896839618683, 0.309047996997833, 0.309198975563049, 0.309349834918976, 0.30950054526329, 0.309651106595993, 0.309801548719406, 0.309951841831207, 0.310102015733719, 0.310252070426941, 0.310401946306229, 0.310551732778549, 0.310701340436935, 0.310850858688354, 0.311000198125839, 0.311149448156357, 0.31129851937294, 0.311447471380234, 0.311596244573593, 0.31174498796463, 0.31189352273941, 0.312041908502579, 0.31219020485878, 0.312338382005692, 0.312486350536346, 0.312634229660034, 0.31278195977211, 0.312929540872574, 0.313077002763748, 0.313224345445633, 0.313371539115906, 0.313518583774567, 0.31366553902626, 0.313812285661697, 0.313958942890167, 0.314105480909348, 0.314251840114594, 0.314398109912872, 0.314544230699539, 0.314690202474594, 0.314836025238037, 0.314981728792191, 0.315127313137054, 0.315272718667984, 0.315418064594269, 0.315563201904297, 0.315708249807358, 0.315853118896484, 0.315997868776321, 0.316142499446869, 0.316287010908127, 0.316431373357773, 0.316575586795807, 0.316719651222229, 0.316863566637039, 0.317007392644882, 0.317151129245758, 0.317294657230377, 0.317438036203384, 0.317581295967102, 0.31772443652153, 0.317867428064346, 0.318010270595551, 0.31815305352211, 0.318295627832413, 0.318438082933426, 0.31858041882515, 0.318722575902939, 0.318864643573761, 0.319006562232971, 0.319148331880569, 0.319289982318878, 0.319431513547897, 0.319572865962982, 0.319714099168777, 0.319855213165283, 0.319996207952499, 0.320137023925781, 0.320277750492096, 0.320418298244476, 0.320558726787567, 0.320699006319046, 0.320839166641235, 0.320979177951813, 0.321119040250778, 0.321258842945099, 0.321398466825485, 0.321537911891937, 0.321677297353745, 0.321816474199295, 0.321955561637878, 0.32209450006485, 0.322233289480209, 0.322371989488602, 0.32251051068306, 0.322648912668228, 0.322787135839462, 0.322925299406052, 0.323063284158707, 0.32320111989975, 0.323338866233826, 0.32347646355629, 0.323613911867142, 0.323751240968704, 0.323888421058655, 0.324025452136993, 0.324162364006042, 0.32429912686348, 0.324435770511627, 0.324572294950485, 0.324708640575409, 0.324844866991043, 0.324980974197388, 0.32511693239212, 0.325252771377563, 0.325388461351395, 0.325524032115936, 0.325659424066544, 0.325794726610184, 0.325929880142212, 0.326064884662628, 0.326199769973755, 0.326334476470947, 0.326469093561172, 0.326603591442108, 0.326737910509109, 0.326872140169144, 0.327006250619888, 0.327140122652054, 0.327273964881897, 0.327407598495483, 0.327541142702103, 0.327674508094788, 0.327807784080505, 0.327940881252289, 0.328073889017105, 0.328206777572632, 0.328339457511902, 0.328472048044205, 0.328604489564896, 0.328729331493378, 0.328846544027328, 0.328963458538055, 0.32908022403717, 0.329196631908417, 0.329312831163406, 0.329428791999817, 0.329544484615326, 0.329659938812256, 0.329775094985962, 0.329890072345734, 0.330004721879959, 0.330119162797928, 0.330233335494995, 0.330347269773483, 0.33046093583107, 0.330574333667755, 0.330687493085861, 0.330800414085388, 0.330913066864014, 0.33102548122406, 0.331137657165527, 0.331249564886093, 0.331361174583435, 0.331472605466843, 0.331583738327026, 0.331694602966309, 0.331805258989334, 0.331915646791458, 0.332025796175003, 0.332135647535324, 0.332245290279388, 0.332354664802551, 0.332463771104813, 0.332572668790817, 0.33268129825592, 0.3327896296978, 0.332897782325745, 0.333005636930466, 0.333113253116608, 0.333220601081848, 0.33332771062851, 0.333434551954269, 0.33354115486145, 0.333647519350052, 0.33375358581543, 0.333859443664551, 0.33396503329277, 0.334070354700089, 0.334175437688828, 0.334280282258987, 0.334384858608246, 0.334489196538925, 0.334593266248703, 0.334697067737579, 0.334800630807877, 0.334903985261917, 0.335007011890411, 0.335109829902649, 0.335212409496307, 0.335314691066742, 0.33541676402092, 0.335518538951874, 0.335620135068893, 0.335721373558044, 0.335822433233261, 0.335923224687576, 0.33602374792099, 0.336124062538147, 0.33622407913208, 0.336323857307434, 0.336423397064209, 0.336522668600082, 0.336621701717377, 0.33672046661377, 0.336818993091583, 0.336917251348495, 0.337015271186829, 0.33711302280426, 0.337210536003113, 0.337307751178741, 0.337404787540436, 0.337501525878906, 0.33759805560112, 0.33769428730011, 0.337790280580521, 0.33788600564003, 0.337981522083282, 0.338076710700989, 0.338171720504761, 0.338266432285309, 0.338360905647278, 0.33845517039299, 0.338549107313156, 0.338642835617065, 0.338736325502396, 0.338829517364502, 0.338922441005707, 0.3390152156353, 0.339107662439346, 0.339199870824814, 0.339291840791702, 0.339383482933044, 0.339474976062775, 0.339566141366959, 0.339657127857208, 0.339747786521912, 0.339838206768036, 0.339928388595581, 0.340018332004547, 0.340108036994934, 0.340197443962097, 0.340286582708359, 0.340375542640686, 0.340464234352112, 0.340552598237991, 0.340640783309937, 0.34072870016098, 0.340816348791122, 0.340903759002686, 0.34099093079567, 0.341077834367752, 0.341164499521255, 0.341250836849213, 0.341336995363235, 0.341422855854034, 0.341508537530899, 0.34159392118454, 0.341679036617279, 0.341763943433762, 0.341848582029343, 0.341932952404022, 0.3420170545578, 0.342100948095322, 0.342184573411942, 0.34226793050766, 0.342351019382477, 0.342433869838715, 0.342516481876373, 0.342598855495453, 0.342680931091309, 0.342762798070908, 0.342844396829605, 0.342925757169724, 0.34300684928894, 0.343087702989578, 0.343168288469315, 0.343248605728149, 0.343328714370728, 0.343408524990082, 0.343488097190857, 0.343567430973053, 0.343646466732025, 0.343725323677063, 0.343803882598877, 0.343882203102112, 0.343960255384445, 0.344038069248199, 0.344115614891052, 0.344192951917648, 0.344269961118698, 0.344346791505814, 0.344423294067383, 0.34449964761734, 0.344575673341751, 0.344651490449905, 0.344726949930191, 0.344802260398865, 0.344877302646637, 0.344952076673508, 0.345026582479477, 0.345100879669189, 0.345174938440323, 0.34524866938591, 0.34532219171524, 0.345395445823669, 0.345468461513519, 0.345541208982468, 0.345613747835159, 0.345685988664627, 0.345757991075516, 0.345829725265503, 0.345901250839233, 0.34597247838974, 0.346043467521667, 0.346114218235016, 0.346184700727463, 0.346254885196686, 0.346324890851974, 0.346394628286362, 0.346464097499847, 0.346533358097076, 0.346602290868759, 0.346671015024185, 0.34673947095871, 0.346807718276978, 0.346875697374344, 0.346943378448486, 0.34701082110405, 0.347078055143356, 0.347144991159439, 0.347211688756943, 0.347278088331223, 0.347344309091568, 0.347410261631012, 0.347475945949554, 0.347541391849518, 0.34760656952858, 0.347671508789062, 0.347736150026321, 0.347800612449646, 0.347864776849747, 0.347928702831268, 0.347992360591888, 0.348055779933929, 0.348118931055069, 0.348181843757629, 0.348244518041611, 0.348306924104691, 0.348369091749191, 0.348430961370468, 0.348492622375488, 0.348554015159607, 0.348615139722824, 0.348676025867462, 0.348736673593521, 0.348797082901001, 0.348857223987579, 0.348917067050934, 0.348976701498032, 0.349036067724228, 0.349095195531845, 0.349154055118561, 0.349212676286697, 0.349271088838577, 0.349329173564911, 0.349387019872665, 0.349444627761841, 0.349501967430115, 0.349559098482132, 0.349615931510925, 0.34967252612114, 0.349728882312775, 0.349784970283508, 0.34984079003334, 0.349896401166916, 0.349951714277267, 0.35000678896904, 0.350061655044556, 0.350116193294525, 0.350170522928238, 0.350224584341049, 0.350278407335281, 0.350331991910934, 0.350385308265686, 0.350438386201859, 0.350491166114807, 0.350543737411499, 0.350596040487289, 0.350648105144501, 0.350699871778488, 0.350751429796219, 0.350802719593048, 0.350853741168976, 0.350904554128647, 0.350955039262772, 0.35100531578064, 0.351055383682251, 0.351105153560638, 0.351154714822769, 0.351203948259354, 0.351252973079681, 0.351301789283752, 0.351350277662277, 0.351398527622223, 0.351446539163589, 0.351494312286377, 0.351541817188263, 0.35158908367157, 0.351636081933975, 0.351682811975479, 0.351729303598404, 0.35177555680275, 0.351821541786194, 0.351867288351059, 0.351912766695023, 0.351957976818085, 0.35200297832489, 0.352047681808472, 0.352092176675797, 0.35213640332222, 0.352180361747742, 0.352224111557007, 0.352267563343048, 0.352310746908188, 0.352353721857071, 0.352396428585052, 0.35243883728981, 0.352481067180634, 0.352523028850555, 0.352564752101898, 0.352606177330017, 0.352647364139557, 0.352688312530518, 0.352728992700577, 0.352769404649734, 0.352809607982635, 0.352849543094635, 0.352889209985733, 0.352928638458252, 0.352967798709869, 0.35300675034523, 0.353045374155045, 0.353083819150925, 0.353121966123581, 0.353159844875336, 0.353197515010834, 0.35323491692543, 0.353272080421448, 0.353309005498886, 0.353345632553101, 0.353382050991058, 0.353418171405792, 0.353454053401947, 0.353489696979523, 0.353525072336197, 0.353560209274292, 0.353595077991486, 0.3536297082901, 0.353664100170135, 0.353698194026947, 0.353732079267502, 0.353765696287155, 0.353799045085907, 0.35383215546608, 0.353865027427673, 0.353897631168365, 0.353929966688156, 0.353962063789368, 0.353993922472, 0.354025512933731, 0.354056835174561, 0.354087948799133, 0.354118794202805, 0.354149371385574, 0.354179680347443, 0.354209780693054, 0.354239612817764, 0.35426914691925, 0.354298502206802, 0.354327589273453, 0.354356408119202, 0.354384958744049, 0.35441330075264, 0.354441374540329, 0.354469120502472, 0.354496687650681, 0.354523986577988, 0.354551047086716, 0.354577839374542, 0.354604423046112, 0.354630649089813, 0.354656755924225, 0.354682505130768, 0.354708045721054, 0.354733288288116, 0.354758352041245, 0.354783147573471, 0.354807615280151, 0.354831904172897, 0.354855924844742, 0.354879707098007, 0.354903221130371, 0.354926466941833, 0.354949504137039, 0.354972273111343, 0.354994773864746, 0.355017006397247, 0.355038970708847, 0.355060756206512, 0.355082243680954, 0.355103462934494, 0.3551245033741, 0.355145215988159, 0.355165719985962, 0.355185925960541, 0.355205923318863, 0.355225652456284, 0.355245113372803, 0.355264335870743, 0.355283319950104, 0.355301976203918, 0.355320483446121, 0.355338662862778, 0.3553566634655, 0.355374366044998, 0.355391800403595, 0.355409026145935, 0.355425924062729, 0.355442643165588, 0.355459064245224, 0.355475306510925, 0.35549122095108, 0.355506896972656, 0.355522334575653, 0.355537533760071, 0.355552434921265, 0.355567127466202, 0.355581551790237, 0.355595707893372, 0.355609625577927, 0.35562327504158, 0.355636715888977, 0.35564985871315, 0.355662763118744, 0.355675429105759, 0.355687856674194, 0.355699986219406, 0.355711877346039, 0.355723530054092, 0.355734884738922, 0.355746060609818, 0.355756908655167, 0.355767577886581, 0.355777949094772, 0.355788081884384, 0.355797946453094, 0.355807572603226, 0.355816960334778, 0.355826050043106, 0.3558349609375, 0.355843544006348, 0.355851948261261, 0.35586005449295, 0.355867892503738, 0.355875492095947, 0.355882823467255, 0.355889946222305, 0.355896800756454, 0.355903387069702, 0.355909734964371, 0.35591584444046, 0.355921626091003, 0.355927228927612, 0.35593256354332, 0.355937659740448, 0.355942457914352, 0.355947017669678, 0.355951339006424, 0.355955421924591, 0.355959206819534, 0.355962812900543, 0.355966120958328, 0.355969160795212, 0.355971962213516, 0.355974525213242, 0.355976849794388, 0.35597887635231, 0.355980694293976, 0.355982214212418, 0.35598349571228, 0.355984538793564, 0.355985343456268, 0.355985879898071, 0.355986148118973, 0.355986177921295, 0.355985939502716, 0.35598549246788, 0.355984717607498, 0.355983793735504, 0.355982542037964, 0.355981051921844, 0.355979293584824, 0.355977356433868, 0.355975091457367, 0.355972558259964, 0.355969816446304, 0.355966806411743, 0.355963557958603, 0.355960071086884, 0.35595628619194, 0.35595229268074, 0.355948030948639, 0.355943530797958, 0.355938732624054, 0.35593369603157, 0.355928421020508, 0.355922907590866, 0.355917125940323, 0.355911105871201, 0.355904787778854, 0.355898261070251, 0.355891495943069, 0.355884402990341, 0.355877131223679, 0.355869561433792, 0.355861783027649, 0.355853766202927, 0.35584545135498, 0.355836868286133, 0.355818241834641, 0.355789631605148, 0.355760753154755, 0.355731606483459, 0.355702251195908, 0.355672717094421, 0.355642855167389, 0.355612844228745, 0.355582565069199, 0.355552047491074, 0.355521321296692, 0.355490297079086, 0.355459123849869, 0.355427712202072, 0.355396032333374, 0.355364114046097, 0.355331987142563, 0.355299651622772, 0.355267018079758, 0.355234175920486, 0.355201154947281, 0.355167835950851, 0.355134308338165, 0.3551005423069, 0.3550665974617, 0.355032384395599, 0.354997903108597, 0.354963213205338, 0.354928314685822, 0.354893177747726, 0.35485777258873, 0.354822158813477, 0.354786336421967, 0.354750275611877, 0.354713916778564, 0.354677379131317, 0.354640603065491, 0.354603618383408, 0.354566395282745, 0.354528933763504, 0.354491204023361, 0.354453295469284, 0.354415118694305, 0.35437673330307, 0.354338109493256, 0.354299247264862, 0.354260176420212, 0.354220807552338, 0.354181289672852, 0.354141473770142, 0.354101479053497, 0.354061245918274, 0.354020744562149, 0.353980004787445, 0.353939056396484, 0.353897929191589, 0.35385650396347, 0.35381481051445, 0.35377299785614, 0.353730887174606, 0.353688538074493, 0.353645980358124, 0.353603184223175, 0.35356017947197, 0.35351687669754, 0.353473395109177, 0.353429645299911, 0.353385716676712, 0.353341519832611, 0.353297084569931, 0.353252410888672, 0.353207528591156, 0.353162407875061, 0.353117048740387, 0.353071480989456, 0.353025645017624, 0.352979630231857, 0.352933317422867, 0.352886825799942, 0.352840095758438, 0.352793097496033, 0.352745890617371, 0.352698475122452, 0.352650791406631, 0.352602869272232, 0.352554738521576, 0.352506369352341, 0.352457761764526, 0.352408945560455, 0.352359890937805, 0.352310568094254, 0.35226109623909, 0.35221129655838, 0.352161318063736, 0.352111101150513, 0.352060616016388, 0.352009981870651, 0.351959049701691, 0.351907908916473, 0.351856529712677, 0.351804912090302, 0.351753056049347, 0.351700961589813, 0.351648688316345, 0.351596117019653, 0.351543307304382, 0.351490348577499, 0.35143706202507, 0.351383626461029, 0.351329952478409, 0.351276040077209, 0.351221829652786, 0.351167440414429, 0.35111278295517, 0.351057916879654, 0.351002871990204, 0.35094752907753, 0.350892007350922, 0.350836187601089, 0.350780189037323, 0.350723922252655, 0.35066744685173, 0.350610703229904, 0.350553780794144, 0.350496590137482, 0.350439161062241, 0.350381523370743, 0.350323677062988, 0.350265562534332, 0.350207179784775, 0.350148677825928, 0.350089848041534, 0.350030839443207, 0.349971503019333, 0.349912047386169, 0.349852323532104, 0.34979236125946, 0.349732160568237, 0.349671691656113, 0.349611073732376, 0.349550157785416, 0.349489063024521, 0.349427700042725, 0.349366098642349, 0.34930431842804, 0.349242240190506, 0.349179953336716, 0.349117428064346, 0.34905469417572, 0.348991751670837, 0.348928481340408, 0.348865061998367, 0.348801404237747, 0.348737508058548, 0.348673343658447, 0.348609000444412, 0.348544389009476, 0.348479568958282, 0.348414480686188, 0.348349183797836, 0.348283678293228, 0.348217874765396, 0.348151922225952, 0.348085671663284, 0.34801921248436, 0.347952514886856, 0.347885638475418, 0.347818464040756, 0.347751080989838, 0.34768345952034, 0.347615599632263, 0.347547560930252, 0.347479224205017, 0.347410678863525, 0.347341924905777, 0.347272902727127, 0.34720367193222, 0.347134202718735, 0.34706449508667, 0.346994549036026, 0.346924394369125, 0.346853971481323, 0.346783369779587, 0.346712499856949, 0.346641421318054, 0.346570074558258, 0.346498489379883, 0.346426725387573, 0.346354693174362, 0.346282452344894, 0.346209973096848, 0.346137255430222, 0.346064299345016, 0.345991104841232, 0.345917671918869, 0.345844060182571, 0.345770180225372, 0.345696061849594, 0.345621734857559, 0.345547169446945, 0.34547233581543, 0.34539732336998, 0.345322072505951, 0.345246523618698, 0.345170795917511, 0.345094829797745, 0.345018655061722, 0.344942182302475, 0.344865560531616, 0.344788670539856, 0.344711512327194, 0.344634145498276, 0.344556570053101, 0.344478785991669, 0.344400733709335, 0.344322443008423, 0.344243884086609, 0.344165176153183, 0.344086199998856, 0.344006955623627, 0.343927532434464, 0.343847841024399, 0.3437679708004, 0.343687772750854, 0.343607485294342, 0.343526870012283, 0.343446016311646, 0.343364924192429, 0.343283623456955, 0.343202114105225, 0.343120336532593, 0.343038320541382, 0.342956095933914, 0.34287366271019, 0.342790961265564, 0.342708021402359, 0.34262490272522, 0.342541486024857, 0.342457860708237, 0.342374056577682, 0.342289954423904, 0.342205613851547, 0.342121094465256, 0.342036306858063, 0.341951310634613, 0.341866075992584, 0.341780602931976, 0.341694891452789, 0.341609001159668, 0.341522753238678, 0.341436356306076, 0.341349750757217, 0.341262876987457, 0.341175764799118, 0.341088443994522, 0.341000884771347, 0.340913116931915, 0.340825080871582, 0.340736836194992, 0.340648353099823, 0.340559601783752, 0.340470641851425, 0.340381473302841, 0.340292036533356, 0.340202420949936, 0.340112537145615, 0.340022414922714, 0.339932084083557, 0.339841514825821, 0.339750677347183, 0.339659661054611, 0.339568376541138, 0.339476853609085, 0.339385151863098, 0.33929318189621, 0.339200973510742, 0.339108556509018, 0.339015871286392, 0.338922947645187, 0.338829815387726, 0.33873650431633, 0.33864289522171, 0.338549077510834, 0.338455021381378, 0.338360726833344, 0.338266223669052, 0.338171482086182, 0.33807647228241, 0.337981283664703, 0.337885826826096, 0.337790161371231, 0.337694257497787, 0.337598115205765, 0.337501704692841, 0.337405145168304, 0.337308287620544, 0.337211221456528, 0.337113916873932, 0.337016373872757, 0.336918592453003, 0.336820602416992, 0.336722403764725, 0.336623907089233, 0.336525231599808, 0.336426317691803, 0.336327165365219, 0.336227774620056, 0.336128115653992, 0.336028277873993, 0.335928231477737, 0.335827887058258, 0.335727334022522, 0.335626602172852, 0.335525542497635, 0.335424304008484, 0.335322827100754, 0.335221081972122, 0.335119187831879, 0.335017025470734, 0.33491462469101, 0.334811985492706, 0.334709078073502, 0.334605991840363, 0.334502667188644, 0.334399074316025, 0.334295302629471, 0.334191262722015, 0.334087044000626, 0.333982527256012, 0.333877831697464, 0.333772867918015, 0.333667665719986, 0.333562254905701, 0.333456575870514, 0.333350718021393, 0.33324459195137, 0.333138257265091, 0.333031684160233, 0.332924872636795, 0.332817822694778, 0.332710534334183, 0.332603007555008, 0.332495301961899, 0.332387357950211, 0.332279175519943, 0.332170724868774, 0.332062035799026, 0.331953138113022, 0.331844002008438, 0.33173468708992, 0.331625044345856, 0.331515252590179, 0.331405192613602, 0.331294894218445, 0.331184357404709, 0.331073641777039, 0.330962628126144, 0.330851435661316, 0.330739974975586, 0.330628275871277, 0.330516397953033, 0.330404251813889, 0.330291837453842, 0.330179244279861, 0.330066412687302, 0.329953342676163, 0.329840034246445, 0.32972651720047, 0.329612731933594, 0.329498738050461, 0.329384475946426, 0.329270035028458, 0.329155325889587, 0.32904040813446, 0.328925251960754, 0.328809887170792, 0.328694254159927, 0.328578412532806, 0.328462272882462, 0.328345984220505, 0.328229427337646, 0.328112632036209, 0.327995657920837, 0.327878385782242, 0.327760934829712, 0.327643215656281, 0.32752525806427, 0.327407121658325, 0.327288687229156, 0.327170014381409, 0.327051162719727, 0.326932102441788, 0.326812773942947, 0.326693177223206, 0.326573401689529, 0.326453357934952, 0.326333075761795, 0.326212584972382, 0.326091915369034, 0.325970888137817, 0.325849711894989, 0.325728327035904, 0.325606644153595, 0.325484752655029, 0.325362652540207, 0.325240314006805, 0.325117707252502, 0.324994921684265, 0.324871838092804, 0.324748575687408, 0.324625074863434, 0.324501305818558, 0.324377357959747, 0.324253171682358, 0.324128717184067, 0.324004054069519, 0.323879182338715, 0.323754012584686, 0.323628664016724, 0.323503047227859, 0.323377251625061, 0.323251157999039, 0.323124885559082, 0.322998344898224, 0.322871625423431, 0.322744607925415, 0.322617411613464, 0.322489947080612, 0.322362273931503, 0.322234392166138, 0.322106242179871, 0.321977823972702, 0.321849197149277, 0.321720361709595, 0.321591317653656, 0.321462005376816, 0.321332484483719, 0.32120269536972, 0.321072727441788, 0.320942491292953, 0.320811986923218, 0.320681303739548, 0.320550352334976, 0.320419192314148, 0.320287793874741, 0.320156186819077, 0.320024311542511, 0.319892257452011, 0.319759905338287, 0.319627374410629, 0.31949457526207, 0.319361537694931, 0.319228321313858, 0.319094866514206, 0.318961173295975, 0.318827152252197, 0.31869301199913, 0.318558573722839, 0.318423926830292, 0.31828910112381, 0.318153977394104, 0.318018645048141, 0.317883104085922, 0.317747265100479, 0.317611247301102, 0.317474961280823, 0.317338466644287, 0.317201763391495, 0.317064791917801, 0.31692761182785, 0.316790223121643, 0.316652536392212, 0.316514641046524, 0.316376537084579, 0.316238194704056, 0.316099613904953, 0.315960764884949, 0.315821707248688, 0.31568244099617, 0.315542936325073, 0.315403193235397, 0.315263211727142, 0.315123021602631, 0.314982563257217, 0.314841896295547, 0.314701020717621, 0.31455984711647, 0.314418524503708, 0.314276933670044, 0.314135044813156, 0.313993006944656, 0.313850730657578, 0.313708186149597, 0.313565462827682, 0.313422471284866, 0.313279241323471, 0.313135772943497, 0.312992125749588, 0.312848180532455, 0.312704026699066, 0.31255504488945, 0.312401413917542, 0.312247723340988, 0.312093913555145, 0.311940014362335, 0.31178605556488, 0.311631888151169, 0.31147775053978, 0.311323463916779, 0.311169058084488, 0.31101456284523, 0.31086003780365, 0.310705333948135, 0.310550600290298, 0.31039571762085, 0.310240745544434, 0.31008568406105, 0.309930562973022, 0.309775322675705, 0.30961999297142, 0.309464544057846, 0.309309005737305, 0.309153378009796, 0.308997601270676, 0.308841794729233, 0.3086858689785, 0.308529883623123, 0.308373749256134, 0.308217525482178, 0.308061242103577, 0.307904809713364, 0.307748317718506, 0.307591736316681, 0.307435005903244, 0.307278275489807, 0.307121336460114, 0.30696439743042, 0.306807309389114, 0.306650102138519, 0.306492865085602, 0.306335479021072, 0.306178033351898, 0.306020468473434, 0.305862814188004, 0.305705040693283, 0.30554723739624, 0.305389255285263, 0.305231213569641, 0.30507305264473, 0.304914861917496, 0.304756492376328, 0.304598122835159, 0.304439574480057, 0.304280936717987, 0.304122239351273, 0.303963422775269, 0.303804516792297, 0.303645521402359, 0.303486406803131, 0.303327232599258, 0.303167939186096, 0.303008526563644, 0.302849024534225, 0.302689462900162, 0.302529752254486, 0.302369982004166, 0.302210122346878, 0.302050173282623, 0.301890105009079, 0.30172997713089, 0.301569670438766, 0.301409363746643, 0.301248848438263, 0.301088333129883, 0.300927698612213, 0.300766944885254, 0.30060613155365, 0.300445228815079, 0.300284177064896, 0.300123006105423, 0.29996183514595, 0.299800515174866, 0.299639105796814, 0.299477607011795, 0.299315959215164, 0.299154251813889, 0.298992484807968, 0.298830598592758, 0.298668593168259, 0.298506498336792, 0.298344314098358, 0.298182010650635, 0.298019707202911, 0.297857195138931, 0.297694623470306, 0.297531962394714, 0.297369182109833, 0.297206372022629, 0.297043412923813, 0.296880304813385, 0.296717196702957, 0.29655396938324, 0.29639059305191, 0.296227186918259, 0.296063631772995, 0.295900017023087, 0.295736283063889, 0.295572489500046, 0.295408546924591, 0.295244544744492, 0.295080453157425, 0.294916242361069, 0.294751942157745, 0.294587552547455, 0.294423013925552, 0.29425847530365, 0.294093757867813, 0.293928980827332, 0.293764114379883, 0.293599098920822, 0.293434053659439, 0.293268889188766, 0.293103605508804, 0.292938262224197, 0.292772799730301, 0.292607247829437, 0.292441576719284, 0.292275846004486, 0.292109966278076, 0.291944056749344, 0.291778028011322, 0.291611909866333, 0.291445672512054, 0.291279375553131, 0.291112929582596, 0.290946424007416, 0.290779769420624, 0.290613085031509, 0.290446281433105, 0.290279358625412, 0.290112376213074, 0.289945304393768, 0.289778113365173, 0.289610803127289, 0.28944343328476, 0.289275944232941, 0.289108365774155, 0.288940697908401, 0.288772910833359, 0.288605034351349, 0.288437098264694, 0.28826904296875, 0.288100898265839, 0.28793266415596, 0.287764251232147, 0.287595868110657, 0.287427306175232, 0.28725865483284, 0.287089943885803, 0.286921113729477, 0.286752164363861, 0.2865831553936, 0.286414057016373, 0.286244809627533, 0.286075532436371, 0.285906136035919, 0.285736590623856, 0.28556701540947, 0.285397291183472, 0.285227537155151, 0.285057634115219, 0.28488764166832, 0.284717559814453, 0.284547418355942, 0.284377098083496, 0.284206718206406, 0.28403627872467, 0.283865720033646, 0.283695042133331, 0.283524304628372, 0.283353447914124, 0.283182501792908, 0.283011466264725, 0.282840311527252, 0.282669097185135, 0.282497763633728, 0.282326310873032, 0.282154768705368, 0.28198316693306, 0.281811445951462, 0.281639605760574, 0.281467735767365, 0.281295746564865, 0.281123578548431, 0.280951410531998, 0.280779093503952, 0.280606746673584, 0.280434250831604, 0.280261695384979, 0.280088990926743, 0.279916167259216, 0.27974334359169, 0.279570370912552, 0.279397279024124, 0.279224097728729, 0.27905085682869, 0.278877526521683, 0.278704047203064, 0.2785305082798, 0.278356850147247, 0.278183132410049, 0.27800926566124, 0.277835369110107, 0.277661323547363, 0.277487218379974, 0.277312994003296, 0.277138650417328, 0.276964247226715, 0.27678969502449, 0.276615113019943, 0.276440411806107, 0.276265621185303, 0.276090741157532, 0.275915712118149, 0.275740623474121, 0.275565475225449, 0.275390177965164, 0.275214791297913, 0.275039345026016, 0.274863719940186, 0.274688094854355, 0.274512350559235, 0.274336457252502, 0.274160534143448, 0.273984491825104, 0.273808300495148, 0.273632049560547, 0.273455739021301, 0.273279279470444, 0.273102730512619, 0.272926092147827, 0.272749364376068, 0.272572547197342, 0.272395640611649, 0.272218614816666, 0.272041529417038, 0.271864354610443, 0.271687000989914, 0.271509617567062, 0.271332114934921, 0.271154493093491, 0.270976841449738, 0.270799040794373, 0.27062115073204, 0.270443171262741, 0.270265102386475, 0.270086914300919, 0.269908666610718, 0.269730299711227, 0.26955184340477, 0.269373297691345, 0.269194632768631, 0.26901587843895, 0.268837034702301, 0.268658101558685, 0.26847904920578, 0.26829993724823, 0.268120646476746, 0.267941355705261, 0.267761945724487, 0.267582416534424, 0.267402827739716, 0.267223089933395, 0.267043262720108, 0.266863375902176, 0.266683340072632, 0.266503274440765, 0.266323089599609, 0.266142785549164, 0.265962392091751, 0.265781939029694, 0.265601336956024, 0.265420645475388, 0.265239864587784, 0.265058994293213, 0.264878064393997, 0.264697015285492, 0.264515817165375, 0.264334589242935, 0.264153212308884, 0.26397180557251, 0.263790249824524, 0.263608604669571, 0.263426899909973, 0.263245046138763, 0.263063132762909, 0.262881100177765, 0.262698978185654, 0.262516766786575, 0.262334436178207, 0.262152045965195, 0.261969536542892, 0.261786937713623, 0.261604219675064, 0.261421412229538, 0.261238545179367, 0.261055558919907, 0.260872453451157, 0.260689288377762, 0.260506004095078, 0.260322630405426, 0.260139167308807, 0.259955644607544, 0.259771913290024, 0.259588211774826, 0.259404361248016, 0.259220391511917, 0.259036332368851, 0.25885221362114, 0.258667945861816, 0.258483648300171, 0.258299201726913, 0.258114635944366, 0.257930010557175, 0.257745325565338, 0.257560521364212, 0.257375627756119, 0.257190585136414, 0.257005482912064, 0.256820261478424, 0.256634950637817, 0.256449580192566, 0.256264090538025, 0.256078481674194, 0.255892813205719, 0.255707025527954, 0.255521148443222, 0.255335181951523, 0.255149126052856, 0.254962950944901, 0.254776656627655, 0.254590302705765, 0.254403859376907, 0.25421729683876, 0.254030674695969, 0.253843903541565, 0.253657072782516, 0.253470152616501, 0.253283113241196, 0.253095984458923, 0.252908766269684, 0.252721458673477, 0.252534061670303, 0.25234654545784, 0.252158880233765, 0.251971185207367, 0.25178337097168, 0.251595497131348, 0.251407504081726, 0.251219391822815, 0.251031219959259, 0.250842928886414, 0.250654548406601, 0.250466048717499, 0.250277519226074, 0.250088810920715, 0.249900072813034, 0.249711200594902, 0.249522238969803, 0.249333187937737, 0.249144047498703, 0.248954817652702, 0.24876543879509, 0.248576030135155, 0.248386457562447, 0.248196825385094, 0.248007103800774, 0.247817263007164, 0.247627377510071, 0.247437343001366, 0.247247233986855, 0.247057020664215, 0.24686673283577, 0.246676281094551, 0.246485829353333, 0.24629519879818, 0.246104523539543, 0.24591375887394, 0.245722845196724, 0.245531871914864, 0.245340764522552, 0.245149612426758, 0.244958341121674, 0.244766980409622, 0.244575515389442, 0.244383931159973, 0.244192317128181, 0.244000539183617, 0.243808656930923, 0.243616759777069, 0.243424698710442, 0.243232578039169, 0.243040338158607, 0.24284802377224, 0.242655575275421, 0.242463082075119, 0.242270454764366, 0.242077738046646, 0.241884902119637, 0.241692006587982, 0.241499036550522, 0.241305902600288, 0.241112694144249, 0.240919411182404, 0.24072602391243, 0.240532547235489, 0.24033896625042, 0.240145266056061, 0.239951491355896, 0.239757657051086, 0.239563658833504, 0.239369601011276, 0.23917543888092, 0.238981187343597, 0.238786831498146, 0.238592401146889, 0.238397821784019, 0.238203182816505, 0.238008484244347, 0.237813621759415, 0.237618684768677, 0.237423673272133, 0.237228542566299, 0.23703333735466, 0.236838012933731, 0.236642584204674, 0.23644708096981, 0.236251473426819, 0.236055791378021, 0.235859990119934, 0.235664084553719, 0.235468089580536, 0.235272035002708, 0.23507584631443, 0.234879553318024, 0.234683200716972, 0.23448671400547, 0.234290152788162, 0.234093487262726, 0.233896702528, 0.233699858188629, 0.23350290954113, 0.233305856585503, 0.233108714222908, 0.232911497354507, 0.232714131474495, 0.232516691088676, 0.232319191098213, 0.232121527194977, 0.231923818588257, 0.231726005673409, 0.231528073549271, 0.231330081820488, 0.231131970882416, 0.230933755636215, 0.230735465884209, 0.230537056922913, 0.230338558554649, 0.23013998568058, 0.22994127869606, 0.229742497205734, 0.229543626308441, 0.229344621300697, 0.229145556688309, 0.228946402668953, 0.228747129440308, 0.228547781705856, 0.228348344564438, 0.228148758411407, 0.227949112653732, 0.22774937748909, 0.227549523115158, 0.22734959423542, 0.227149575948715, 0.226949423551559, 0.226749196648598, 0.226548880338669, 0.226348474621773, 0.226147949695587, 0.225947335362434, 0.225746601819992, 0.225545823574066, 0.22534491121769, 0.225143924355507, 0.224942833185196, 0.224741622805595, 0.224540323019028, 0.224338978528976, 0.224137455224991, 0.223935887217522, 0.223739728331566, 0.223549127578735, 0.223358541727066, 0.223168045282364, 0.222977533936501, 0.22278705239296, 0.222596630454063, 0.222406223416328, 0.222215875983238, 0.222025543451309, 0.22183521091938, 0.221644937992096, 0.221454724669456, 0.221264481544495, 0.221074298024178, 0.220884144306183, 0.220694065093994, 0.220503985881805, 0.220313906669617, 0.220123887062073, 0.21993388235569, 0.219743922352791, 0.219554007053375, 0.219364121556282, 0.219174280762672, 0.218984395265579, 0.218794643878937, 0.218604862689972, 0.218415126204491, 0.218225419521332, 0.218035727739334, 0.217846095561981, 0.217656508088112, 0.217466875910759, 0.217277362942696, 0.217087864875793, 0.21689835190773, 0.216708928346634, 0.216519460082054, 0.216330096125603, 0.216140747070312, 0.215951427817345, 0.215762108564377, 0.215572834014893, 0.215383633971214, 0.215194433927536, 0.215005248785019, 0.214816093444824, 0.214627012610435, 0.21443797647953, 0.214248895645142, 0.214059889316559, 0.213870897889137, 0.21368196606636, 0.213493064045906, 0.213304162025452, 0.213115304708481, 0.212926462292671, 0.21273772418499, 0.212548926472664, 0.212360233068466, 0.212171524763107, 0.211982846260071, 0.21179424226284, 0.211605653166771, 0.211417078971863, 0.211228519678116, 0.211040034890175, 0.210851550102234, 0.210663124918938, 0.210474699735641, 0.21028633415699, 0.2100979834795, 0.209909647703171, 0.209721371531487, 0.209533140063286, 0.209344908595085, 0.209156706929207, 0.208968594670296, 0.208780452609062, 0.20859232544899, 0.208404332399368, 0.208216235041618, 0.20802828669548, 0.207840293645859, 0.207652375102043, 0.207464456558228, 0.207276597619057, 0.207088753581047, 0.206900924444199, 0.206713184714317, 0.206525415182114, 0.206337690353394, 0.206150010228157, 0.205962359905243, 0.205774769186974, 0.205587193369865, 0.205399602651596, 0.205212101340294, 0.205024585127831, 0.204837128520012, 0.204649731516838, 0.204462304711342, 0.204274952411652, 0.204087600111961, 0.203900322318077, 0.203713044524193, 0.20352578163147, 0.203338593244553, 0.203151434659958, 0.202964290976524, 0.202777177095413, 0.202590063214302, 0.202403023838997, 0.202215984463692, 0.202029049396515, 0.201842084527016, 0.201655119657516, 0.201468259096146, 0.201281413435936, 0.201094582676888, 0.200907751917839, 0.200720995664597, 0.200534284114838, 0.200347602367401, 0.200160920619965, 0.199974253773689, 0.199787646532059, 0.199601069092751, 0.199414521455765, 0.199228033423424, 0.19904151558876, 0.198855102062225, 0.198668673634529, 0.198482260107994, 0.198295935988426, 0.198109641671181, 0.197923317551613, 0.197737067937851, 0.197550848126411, 0.19736459851265, 0.197178483009338, 0.196992352604866, 0.196806237101555, 0.196620151400566, 0.196434125304222, 0.196248143911362, 0.196062117815018, 0.195876240730286, 0.195690289139748, 0.195504397153854, 0.195318564772606, 0.195132747292519, 0.194946959614754, 0.194761201739311, 0.194575503468513, 0.194389790296555, 0.194204151630402, 0.194018542766571, 0.19383293390274, 0.193647369742393, 0.193461835384369, 0.193276315927505, 0.193090870976448, 0.192905426025391, 0.192720010876656, 0.192534670233727, 0.192349314689636, 0.192163959145546, 0.191978693008423, 0.191793471574783, 0.191608235239983, 0.19142310321331, 0.191237911581993, 0.191052779555321, 0.190867722034454, 0.190682664513588, 0.190497621893883, 0.190312638878822, 0.190127685666084, 0.189942717552185, 0.189757868647575, 0.189572960138321, 0.189388141036034, 0.189203336834908, 0.189018592238426, 0.1888337880373, 0.188649132847786, 0.188464418053627, 0.188279762864113, 0.188095182180405, 0.187910601496696, 0.187726050615311, 0.187541514635086, 0.187357038259506, 0.187172561883926, 0.18698813021183, 0.186803758144379, 0.186619386076927, 0.186435043811798, 0.186250761151314, 0.186066493391991, 0.18588225543499, 0.185698091983795, 0.185513883829117, 0.1853296905756, 0.185145631432533, 0.184961557388306, 0.184777483344078, 0.184593513607979, 0.184409499168396, 0.184225544333458, 0.184041678905487, 0.18385773897171, 0.183673873543739, 0.183490067720413, 0.183306291699409, 0.183122500777245, 0.182938814163208, 0.182755097746849, 0.182571440935135, 0.182387799024582, 0.182204201817513, 0.182020604610443, 0.18183708190918, 0.181653544306755, 0.181470081210136, 0.181286662817001, 0.181103229522705, 0.180919870734215, 0.180736511945724, 0.180553168058395, 0.18036986887455, 0.180186673998833, 0.18000340461731, 0.179820224642754, 0.179637089371681, 0.179453939199448, 0.179270818829536, 0.179087772965431, 0.178904742002487, 0.178721740841866, 0.178538799285889, 0.178355827927589, 0.178172931075096, 0.177990064024925, 0.177807196974754, 0.177624359726906, 0.177441641688347, 0.177258893847466, 0.177076146006584, 0.176893442869186, 0.176710799336433, 0.17652815580368, 0.176345556974411, 0.176163017749786, 0.175980463624001, 0.175797984004021, 0.175615563988686, 0.175433129072189, 0.175250664353371, 0.175068348646164, 0.174885988235474, 0.174703672528267, 0.174521416425705, 0.174339175224304, 0.174156948924065, 0.173974767327309, 0.173792645335197, 0.173610478639603, 0.173428416252136, 0.17324635386467, 0.173064351081848, 0.172882407903671, 0.172700390219688, 0.172518447041512, 0.172336563467979, 0.172154739499092, 0.171972885727882, 0.171791106462479, 0.171609312295914, 0.171427577733994, 0.171245887875557, 0.171064183115959, 0.170882537961006, 0.170700967311859, 0.17051936686039, 0.170337811112404, 0.170156329870224, 0.169974803924561, 0.169793367385864, 0.16961196064949, 0.169430568814278, 0.169249176979065, 0.169067904353142, 0.168886587023735, 0.168705314397812, 0.168524101376534, 0.168342888355255, 0.168161690235138, 0.167980596423149, 0.167799487709999, 0.167618378996849, 0.167437389492989, 0.167256325483322, 0.167075365781784, 0.166894391179085, 0.166713520884514, 0.166532605886459, 0.166351735591888, 0.166170984506607, 0.165990129113197, 0.165809348225594, 0.165628656744957, 0.165447980165482, 0.165267303586006, 0.165086701512337, 0.164906069636345, 0.16472552716732, 0.164544984698296, 0.164364457130432, 0.164183974266052, 0.16400358080864, 0.163823187351227, 0.163642808794975, 0.163462460041046, 0.163282126188278, 0.163101822137833, 0.162921592593193, 0.162741348147392, 0.162561148405075, 0.162381038069725, 0.162200897932053, 0.162020817399025, 0.161840751767159, 0.161660701036453, 0.161480709910393, 0.161300748586655, 0.161120817065239, 0.160940870642662, 0.160761073231697, 0.160581201314926, 0.160401374101639, 0.160221621394157, 0.160041868686676, 0.159862101078033, 0.159682482481003, 0.15950283408165, 0.159323200583458, 0.159143641591072, 0.158964037895203, 0.158784538507462, 0.158605068922043, 0.158425569534302, 0.158246144652367, 0.158066764473915, 0.157887384295464, 0.157708033919334, 0.157528772950172, 0.157349482178688, 0.15717026591301, 0.156991004943848, 0.156811863183975, 0.15663269162178, 0.156453609466553, 0.156274512410164, 0.15609547495842, 0.155916407704353, 0.155737489461899, 0.155558481812477, 0.155379593372345, 0.155200704932213, 0.155021801590919, 0.15484294295311, 0.15466420352459, 0.154485419392586, 0.154306665062904, 0.154128029942513, 0.153949335217476, 0.153770685195923, 0.153592094779015, 0.153413519263268, 0.153234928846359, 0.153056457638741, 0.152877986431122, 0.152699515223503, 0.15252111852169, 0.152342692017555, 0.152164354920387, 0.151986047625542, 0.151807755231857, 0.151629462838173, 0.151451274752617, 0.1512730717659, 0.151094898581505, 0.150916799902916, 0.150738671422005, 0.150560602545738, 0.150382578372955, 0.150204584002495, 0.150026574730873, 0.149848654866219, 0.149670720100403, 0.149492859840393, 0.149315029382706, 0.149137169122696, 0.14895935356617, 0.148781642317772, 0.148603945970535, 0.148426234722137, 0.148248597979546, 0.148070961236954, 0.147893339395523, 0.147715762257576, 0.147538274526596, 0.147360727190971, 0.147183284163475, 0.147005870938301, 0.146828442811966, 0.146651044487953, 0.146473735570908, 0.146296411752701, 0.146119132637978, 0.145941913127899, 0.145764648914337, 0.145587459206581, 0.14541032910347, 0.14523321390152, 0.145056113600731, 0.144879072904587, 0.144702032208443, 0.144525051116943, 0.144348114728928, 0.144171133637428, 0.143994227051735, 0.143817394971848, 0.14364056289196, 0.143463715910912, 0.143286988139153, 0.143110230565071, 0.142933502793312, 0.142756834626198, 0.142580211162567, 0.142403572797775, 0.142227023839951, 0.142050474882126, 0.14187391102314, 0.141697451472282, 0.141520977020264, 0.141344532370567, 0.141168162226677, 0.140991806983948, 0.140815436840057, 0.140639200806618, 0.140462905168533, 0.140286669135094, 0.140110492706299, 0.139934301376343, 0.139758169651031, 0.13958203792572, 0.139405980706215, 0.139229908585548, 0.139053910970688, 0.138877913355827, 0.138701990246773, 0.138526082038879, 0.138350158929825, 0.138174280524254, 0.137998461723328, 0.137822717428207, 0.137646913528442, 0.137471184134483, 0.137295499444008, 0.137119844555855, 0.136944189667702, 0.136768594384193, 0.136592984199524, 0.136417463421822, 0.136242002248764, 0.136066496372223, 0.135891020298004, 0.135715648531914, 0.135540261864662, 0.135364904999733, 0.135189577937126, 0.135014295578003, 0.134839028120041, 0.134663790464401, 0.134488627314568, 0.134313449263573, 0.134138360619545, 0.133963271975517, 0.133788153529167, 0.133613154292107, 0.133438125252724, 0.133263155817986, 0.133088245987892, 0.132913306355476, 0.132738411426544, 0.13256362080574, 0.132390901446342, 0.132219806313515, 0.132048934698105, 0.131878033280373, 0.131707295775414, 0.131536662578583, 0.131366103887558, 0.1311956346035, 0.131025314331055, 0.13085500895977, 0.130684822797775, 0.130514875054359, 0.13034488260746, 0.130175024271011, 0.130005270242691, 0.129835680127144, 0.129666090011597, 0.129496678709984, 0.129327312111855, 0.129158079624176, 0.128988951444626, 0.128819867968559, 0.128650918602943, 0.128482058644295, 0.128313332796097, 0.128144696354866, 0.127976164221764, 0.12780773639679, 0.127639457583427, 0.127471163868904, 0.127303093671799, 0.127134993672371, 0.126967057585716, 0.126799255609512, 0.12663146853447, 0.126463875174522, 0.12629634141922, 0.126128941774368, 0.125961542129517, 0.125794410705566, 0.125627234578133, 0.12546019256115, 0.125293284654617, 0.125126421451569, 0.124959729611874, 0.124793104827404, 0.124626569449902, 0.124460145831108, 0.124293923377991, 0.124127626419067, 0.123961485922337, 0.123795449733734, 0.123629592359066, 0.123463727533817, 0.1232980042696, 0.123132422566414, 0.122966893017292, 0.122801512479782, 0.122636146843433, 0.1224709674716, 0.122305832803249, 0.122140817344189, 0.121975883841515, 0.121811114251614, 0.121646374464035, 0.121481776237488, 0.121317259967327, 0.121152862906456, 0.120988540351391, 0.120824366807938, 0.120660252869129, 0.120496191084385, 0.1203323751688, 0.120168536901474, 0.120004862546921, 0.11984121799469, 0.119677722454071, 0.119514316320419, 0.119350977241993, 0.119187816977501, 0.119024731218815, 0.118861734867096, 0.118698827922344, 0.118536062538624, 0.118373319506645, 0.118210777640343, 0.118048258125782, 0.117885798215866, 0.11772358417511, 0.117561355233192, 0.117399260401726, 0.117237314581871, 0.117075406014919, 0.116913594305515, 0.116751953959465, 0.116590335965157, 0.116428837180138, 0.116267472505569, 0.116106137633324, 0.115944974124432, 0.115783914923668, 0.115622915327549, 0.115462027490139, 0.115301288664341, 0.115140572190285, 0.11497999727726, 0.114819534122944, 0.11465910077095, 0.11449883133173, 0.114338703453541, 0.114178635179996, 0.114018596708775, 0.113858781754971, 0.113698989152908, 0.113539315760136, 0.113379754126072, 0.113220296800137, 0.113060899078846, 0.112901628017426, 0.112742483615875, 0.112583339214325, 0.112424425780773, 0.112265571951866, 0.112106755375862, 0.111948125064373, 0.111789584159851, 0.111631087958813, 0.111472733318806, 0.111314460635185, 0.11115624755621, 0.110998205840588, 0.110840246081352, 0.110682420432568, 0.110524632036686, 0.110367015004158, 0.110209420323372, 0.110051989555359, 0.109894625842571, 0.109737366437912, 0.109580218791962, 0.109423138201237, 0.109266214072704, 0.109109297394753, 0.108952634036541, 0.108795911073685, 0.108639389276505, 0.108482964336872, 0.108326584100723, 0.108170337975025, 0.108014173805714, 0.107858158648014, 0.107702143490314, 0.107546381652355, 0.107390582561493, 0.107234954833984, 0.107079423964024, 0.106924019753933, 0.106768608093262, 0.10661344230175, 0.106458261609077, 0.106303207576275, 0.106148302555084, 0.105993419885635, 0.105838716030121, 0.105684019625187, 0.10552953928709, 0.105375073850155, 0.105220794677734, 0.105066478252411, 0.104912385344505, 0.104758396744728, 0.10460440069437, 0.104450568556786, 0.104296863079071, 0.104143239557743, 0.103989690542221, 0.103836312890053, 0.103682950139046, 0.103529736399651, 0.103376612067223, 0.103223599493504, 0.103070624172688, 0.102917805314064, 0.102765113115311, 0.102612465620041, 0.102459937334061, 0.102307520806789, 0.102155230939388, 0.102002963423729, 0.101850904524326, 0.101698845624924, 0.101546972990036, 0.10139511525631, 0.101243361830711, 0.101091794669628, 0.100940249860287, 0.100788898766041, 0.100637517869473, 0.100486390292645, 0.100335218012333, 0.100184254348278, 0.100033298134804, 0.099882535636425, 0.0997317507863045, 0.0995811596512794, 0.099430650472641, 0.0992802307009697, 0.0991300120949745, 0.0989797562360764, 0.0988296717405319, 0.0986796393990517, 0.0985297486186028, 0.0983799174427986, 0.0982302576303482, 0.0980806276202202, 0.0979311317205429, 0.097781777381897, 0.0976324304938316, 0.0974832400679588, 0.0973341464996338, 0.0971851870417595, 0.0970362573862076, 0.0968875214457512, 0.0967387855052948, 0.0965902134776115, 0.0964417085051537, 0.0962933152914047, 0.0961449667811394, 0.0959968268871307, 0.0958487093448639, 0.0957007110118866, 0.0955529063940048, 0.0954050421714783, 0.095257431268692, 0.095109798014164, 0.0949622988700867, 0.0948149412870407, 0.0946676433086395, 0.0945204496383667, 0.0943733528256416, 0.0942263901233673, 0.0940795168280602, 0.0939327105879784, 0.0937860608100891, 0.0936395227909088, 0.0934930145740509, 0.0933465585112572, 0.0932003557682037, 0.0930541530251503, 0.0929080620408058, 0.0927621424198151, 0.0926162824034691, 0.0924704596400261, 0.092324860394001, 0.0921792089939117, 0.0920337736606598, 0.0918884128332138, 0.091743104159832, 0.0915979444980621, 0.0914528965950012, 0.0913079380989075, 0.0911630466580391, 0.0910182818770409, 0.0908735916018486, 0.0907290503382683, 0.0905845984816551, 0.0904402434825897, 0.0902959853410721, 0.090151809155941, 0.0900077447295189, 0.0898637846112251, 0.0897199511528015, 0.0895761623978615, 0.089432492852211, 0.0892889946699142, 0.0891454964876175, 0.0890021547675133, 0.0888589695096016, 0.0887157693505287, 0.0885726287961006, 0.0884297490119934, 0.0882868692278862, 0.0881441757082939, 0.0880014598369598, 0.0878589451313019, 0.0877164900302887, 0.0875741615891457, 0.0874319225549698, 0.0872897729277611, 0.0871477052569389, 0.0870057418942451, 0.0868638977408409, 0.0867221429944038, 0.0865805298089981, 0.086438961327076, 0.0862975642085075, 0.0861562043428421, 0.086014986038208, 0.0858738422393799, 0.0857327580451965, 0.0855918526649475, 0.0854509919881821, 0.0853103250265121, 0.085169605910778, 0.0850291103124619, 0.0848886743187904, 0.0847483575344086, 0.0846080780029297, 0.0844680070877075, 0.0843279659748077, 0.0841879770159721, 0.084048219025135, 0.0839084014296532, 0.0837688371539116, 0.0836293250322342, 0.083489902317524, 0.0833505317568779, 0.0832113698124886, 0.0830721855163574, 0.0829331874847412, 0.082794263958931, 0.0826554074883461, 0.0825167447328568, 0.0823780819773674, 0.0822395831346512, 0.082101121544838, 0.081962838768959, 0.0818246603012085, 0.0816865265369415, 0.0815484821796417, 0.0814106017351151, 0.0812727212905884, 0.081134982407093, 0.080997422337532, 0.0808598548173904, 0.0807225406169891, 0.0805851742625237, 0.0804480165243149, 0.0803108811378479, 0.0801738947629929, 0.080036923289299, 0.0799002051353455, 0.0797634199261665, 0.079626776278019, 0.0794903337955475, 0.0793539211153984, 0.0792176201939583, 0.0790814235806465, 0.0789453834295273, 0.0788092762231827, 0.0786734446883202, 0.0785376206040382, 0.0784019231796265, 0.0782662853598595, 0.078130804002285, 0.0779954195022583, 0.0778600797057152, 0.07772496342659, 0.0775898396968842, 0.0774548873305321, 0.0773199275135994, 0.0771851763129234, 0.0770504549145699, 0.0769159197807312, 0.0767813920974731, 0.076646976172924, 0.0765127316117287, 0.0763784795999527, 0.0762444511055946, 0.0761104300618172, 0.0759765729308128, 0.0758427157998085, 0.0757091194391251, 0.0755754560232162, 0.0754420533776283, 0.0753086730837822, 0.0751753225922585, 0.075042150914669, 0.0749091058969498, 0.0747761428356171, 0.0746432170271873, 0.0745104625821114, 0.0743777677416801, 0.0742452070116997, 0.0741127207875252, 0.0739803314208984, 0.0738480538129807, 0.0737159103155136, 0.0735838338732719, 0.0734518244862556, 0.0733200013637543, 0.0731882303953171, 0.0730565413832664, 0.0729249566793442, 0.0727935582399368, 0.0726621448993683, 0.0725308507680893, 0.072399690747261, 0.0722686201334, 0.0721377208828926, 0.0720067843794823, 0.0718760564923286, 0.0717453807592392, 0.0716148763895035, 0.0714843347668648, 0.0713539943099022, 0.0712237060070038, 0.0710935741662979, 0.0709634870290756, 0.0708335414528847, 0.0707037374377251, 0.0705739557743073, 0.070444293320179, 0.0703147426247597, 0.0701852515339851, 0.0700559169054031, 0.0699267014861107, 0.0697975233197212, 0.0696684718132019, 0.0695395469665527, 0.0694106370210648, 0.0692819803953171, 0.0691532418131828, 0.0690247341990471, 0.0688962787389755, 0.0687679648399353, 0.0686396807432175, 0.0685115903615952, 0.0683834999799728, 0.0682555288076401, 0.0681277438998222, 0.067999966442585, 0.0678723305463791, 0.0677447766065598, 0.0676173865795135, 0.067489966750145, 0.0673628076910973, 0.0672356486320496, 0.0671086236834526, 0.066981665790081, 0.0668548122048378, 0.0667281076312065, 0.0666014552116394, 0.066474936902523, 0.0663484781980515, 0.0662222132086754, 0.0660959258675575, 0.0659698322415352, 0.0658437982201576, 0.0657178536057472, 0.065592035651207, 0.0654662773013115, 0.0653406977653503, 0.0652151331305504, 0.0650897398591042, 0.0649643838405609, 0.0648391917347908, 0.0647140592336655, 0.0645890682935715, 0.0644640922546387, 0.064339242875576, 0.0642145574092865, 0.0640899538993835, 0.0639654621481895, 0.0638410300016403, 0.0637167096138, 0.0635924711823463, 0.063468411564827, 0.063344344496727, 0.0632204413414001, 0.0630966275930405, 0.0629729032516479, 0.0628492832183838, 0.0627257749438286, 0.0626023858785629, 0.0624790787696838, 0.0623559132218361, 0.0622327774763107, 0.0621097721159458, 0.0619868338108063, 0.0618640594184399, 0.0617413446307182, 0.061618734151125, 0.0614962168037891, 0.0613737814128399, 0.0612515434622765, 0.0611293353140354, 0.0610072612762451, 0.0608852468430996, 0.0607633478939533, 0.0606415271759033, 0.0605198554694653, 0.0603982321918011, 0.060276698321104, 0.0601553320884705, 0.0600340478122234, 0.0599128492176533, 0.0597917661070824, 0.0596707910299301, 0.0595498718321323, 0.059433676302433, 0.0593212209641933, 0.0592089407145977, 0.059096772223711, 0.0589846596121788, 0.0588727444410324, 0.0587609373033047, 0.0586492456495762, 0.0585376657545567, 0.0584262534976006, 0.0583149045705795, 0.0582036934792995, 0.0580926723778248, 0.0579817444086075, 0.0578708648681641, 0.0577601343393326, 0.0576495677232742, 0.0575390830636024, 0.0574287436902523, 0.0573185123503208, 0.057208426296711, 0.0570984184741974, 0.0569886453449726, 0.0568788386881351, 0.0567692555487156, 0.0566597543656826, 0.0565503984689713, 0.0564412102103233, 0.0563320517539978, 0.0562230870127678, 0.0561141818761826, 0.0560054704546928, 0.0558967888355255, 0.0557882525026798, 0.0556798800826073, 0.0555715933442116, 0.0554634407162666, 0.0553554035723209, 0.0552475675940514, 0.0551397874951363, 0.0550322011113167, 0.0549246184527874, 0.0548172295093536, 0.0547099262475967, 0.0546027943491936, 0.0544957108795643, 0.0543887726962566, 0.0542820021510124, 0.0541752651333809, 0.054068747907877, 0.0539622902870178, 0.0538560226559639, 0.053749818354845, 0.053643811494112, 0.0535378567874432, 0.053432073444128, 0.0533263385295868, 0.0532207265496254, 0.0531153082847595, 0.0530099160969257, 0.0529047511518002, 0.0527996383607388, 0.0526947006583214, 0.0525898449122906, 0.0524851568043232, 0.0523805245757103, 0.0522761158645153, 0.0521717108786106, 0.0520674996078014, 0.0519633777439594, 0.0518593341112137, 0.0517555736005306, 0.0516517609357834, 0.0515481680631638, 0.0514446310698986, 0.0513412952423096, 0.0512380115687847, 0.051134929060936, 0.0510318726301193, 0.0509289838373661, 0.050826296210289, 0.0507236085832119, 0.0506210811436176, 0.0505186729133129, 0.0504164323210716, 0.0503142178058624, 0.0502122603356838, 0.0501102991402149, 0.0500085651874542, 0.049906887114048, 0.0498052947223186, 0.0497039519250393, 0.0496026128530502, 0.0495014674961567, 0.0494003780186176, 0.0492994897067547, 0.0491986237466335, 0.0490979626774788, 0.0489974059164524, 0.0488969683647156, 0.0487966127693653, 0.0486964248120785, 0.0485963486135006, 0.0484963580965996, 0.0483965910971165, 0.0482968837022781, 0.0481973141431808, 0.0480978302657604, 0.0479985140264034, 0.0478992275893688, 0.04780013859272, 0.0477011874318123, 0.047602292150259, 0.0475035980343819, 0.0474049523472786, 0.0473064817488194, 0.0472081266343594, 0.0471099056303501, 0.047011774033308, 0.0469138361513615, 0.0468159541487694, 0.0467181280255318, 0.0466205328702927, 0.0465230159461498, 0.046425636857748, 0.046328317373991, 0.0462312251329422, 0.0461341887712479, 0.0460372902452946, 0.0459405072033405, 0.0458438917994499, 0.0457473620772362, 0.0456509701907635, 0.0455546639859676, 0.0454584434628487, 0.0453624464571476, 0.0452665314078331, 0.0451707355678082, 0.0450750440359116, 0.0449795015156269, 0.0448840707540512, 0.0447888039052486, 0.0446935370564461, 0.0445984676480293, 0.0445035398006439, 0.0444087497889996, 0.0443140789866447, 0.0442195162177086, 0.0441250652074814, 0.0440307036042213, 0.0439365282654762, 0.0438424199819565, 0.0437484756112099, 0.043654590845108, 0.0435608401894569, 0.0434672646224499, 0.0433737710118294, 0.0432804487645626, 0.0431872345507145, 0.043094165623188, 0.0430011488497257, 0.0429082997143269, 0.0428155660629272, 0.0427229478955269, 0.0426304116845131, 0.0425380133092403, 0.042445782572031, 0.0423536114394665, 0.042261641472578, 0.0421697497367859, 0.042077973484993, 0.0419863387942314, 0.041894868016243, 0.0418034568428993, 0.0417121835052967, 0.0416210554540157, 0.0415299795567989, 0.0414390452206135, 0.0413482785224915, 0.0412576533854008, 0.0411670580506325, 0.0410766862332821, 0.0409863442182541, 0.0408961698412895, 0.0408061929047108, 0.040716215968132, 0.0406264327466488, 0.0405366830527782, 0.0404471531510353, 0.0403577126562595, 0.0402684099972248, 0.0401791892945766, 0.0400901138782501, 0.0400011762976646, 0.0399123504757881, 0.0398236140608788, 0.0397350154817104, 0.0396466106176376, 0.0395582355558872, 0.0394700579345226, 0.0393819138407707, 0.0392939560115337, 0.0392061173915863, 0.0391183868050575, 0.0390307754278183, 0.0389433018863201, 0.0388559103012085, 0.038768608123064, 0.0386815816164017, 0.0385945327579975, 0.0385076999664307, 0.0384209305047989, 0.0383343547582626, 0.0382477827370167, 0.0381614603102207, 0.0380751676857471, 0.0379890166223049, 0.0379030033946037, 0.0378170758485794, 0.0377312898635864, 0.0376456193625927, 0.0375601388514042, 0.0374746881425381, 0.0373894385993481, 0.0373042710125446, 0.0372192710638046, 0.0371343269944191, 0.0370495542883873, 0.03696483746171, 0.0368802584707737, 0.0367958769202232, 0.0367115288972855, 0.0366273745894432, 0.0365432985126972, 0.0364593714475632, 0.0363754965364933, 0.0362918749451637, 0.0362082831561565, 0.0361248850822449, 0.0360414907336235, 0.0359582677483559, 0.0358752347528934, 0.0357922315597534, 0.0357094295322895, 0.0356266498565674, 0.0355440974235535, 0.0354615747928619, 0.0353792458772659, 0.0352970026433468, 0.0352149270474911, 0.0351329408586025, 0.035051092505455, 0.0349693298339844, 0.0348877012729645, 0.0348062478005886, 0.0347248204052448, 0.0346436202526093, 0.0345624424517155, 0.0344814695417881, 0.0344005487859249, 0.0343197956681252, 0.0342391580343246, 0.0341585762798786, 0.0340782143175602, 0.0339979976415634, 0.0339178331196308, 0.0338378176093102, 0.0337579064071178, 0.0336780548095703, 0.0335984863340855, 0.03351891040802, 0.0334394574165344, 0.033360168337822, 0.0332809910178185, 0.033201951533556, 0.0331230014562607, 0.0330441929399967, 0.0329655483365059, 0.0328870192170143, 0.0328085422515869, 0.0327302701771259, 0.0326520465314388, 0.0325739420950413, 0.0324959978461266, 0.0324181467294693, 0.0323404334485531, 0.0322628282010555, 0.032185398042202, 0.0321080200374126, 0.0320308953523636, 0.0319537706673145, 0.0318767875432968, 0.0317999459803104, 0.0317231900990009, 0.0316466018557549, 0.0315700955688953, 0.0314937308430672, 0.0314175076782703, 0.0313413701951504, 0.0312653407454491, 0.0311895124614239, 0.0311137102544308, 0.0310381632298231, 0.0309626702219248, 0.0308872330933809, 0.030811995267868, 0.0307368393987417, 0.0306618250906467, 0.0305868946015835, 0.0305121634155512, 0.0304374862462282, 0.0303629506379366, 0.0302885286509991, 0.0302142724394798, 0.0301400758326054, 0.0300660170614719, 0.0299921855330467, 0.0299183502793312, 0.0298447161912918, 0.0297711361199617, 0.0296977516263723, 0.0296243969351053, 0.029551213607192, 0.0294781383126974, 0.0294051505625248, 0.0293323863297701, 0.0292596500366926, 0.0291871130466461, 0.0291146300733089, 0.0290423706173897, 0.028970142826438, 0.0288980826735497, 0.0288260765373707, 0.0287542976438999, 0.0286825466901064, 0.0286108795553446, 0.0285394657403231, 0.0284680519253016, 0.0283968634903431, 0.0283257309347391, 0.0282547939568758, 0.0281838569790125, 0.0281132031232119, 0.0280425790697336, 0.0279720909893513, 0.0279016904532909, 0.0278314296156168, 0.0277613382786512, 0.0276912748813629, 0.0276214350014925, 0.0275516249239445, 0.0274820104241371, 0.0274124834686518, 0.0273430924862623, 0.0272737592458725, 0.0272046830505133, 0.0271356869488955, 0.0270667206496, 0.0269980058073997, 0.0269292928278446, 0.0268607474863529, 0.0267923157662153, 0.0267240796238184, 0.0266558155417442, 0.0265878327190876, 0.026519849896431, 0.0264520943164825, 0.0263843648135662, 0.0263167768716812, 0.0262494403868914, 0.0261820778250694, 0.0261149387806654, 0.0260478015989065, 0.0259808860719204, 0.0259140003472567, 0.025847340002656, 0.0257807355374098, 0.0257143005728722, 0.0256478935480118, 0.0255816839635372, 0.0255155842751265, 0.0254496559500694, 0.0253838393837214, 0.0253180805593729, 0.0252525173127651, 0.0251869801431894, 0.0251216422766447, 0.0250563602894545, 0.0249913018196821, 0.0249262731522322, 0.0248613283038139, 0.0247966088354588, 0.0247320029884577, 0.0246674790978432, 0.0246031247079372, 0.0245389100164175, 0.0244746971875429, 0.0244107097387314, 0.0243468340486288, 0.0242830421775579, 0.0242193639278412, 0.0241558533161879, 0.0240924563258886, 0.024029141291976, 0.0239659678190947, 0.0239029377698898, 0.0238400176167488, 0.023777212947607, 0.0237146280705929, 0.0236520189791918, 0.0235896036028862, 0.0235272757709026, 0.0234650876373053, 0.0234030392020941, 0.0233410764485598, 0.023279283195734, 0.0232175439596176, 0.0231560301035643, 0.0230945441871881, 0.0230332314968109, 0.0229719970375299, 0.0229109339416027, 0.0228499826043844, 0.0227891188114882, 0.0227284207940102, 0.0226678345352411, 0.022607333958149, 0.0225470028817654, 0.0224867835640907, 0.022426649928093, 0.0223666820675135, 0.0223067998886108, 0.0222470033913851, 0.0221874304115772, 0.0221279431134462, 0.0220685936510563, 0.0220093596726656, 0.0219502355903387, 0.0218912269920111, 0.0218323301523924, 0.0217735730111599, 0.0217149294912815, 0.0216563958674669, 0.0215979777276516, 0.0215397253632545, 0.0214815326035023, 0.0214235074818134, 0.0213656239211559, 0.0213079061359167, 0.0212501883506775, 0.0211926996707916, 0.0211352650076151, 0.0210779700428247, 0.0210207886993885, 0.020963691174984, 0.0209067892283201, 0.0208499450236559, 0.0207933001220226, 0.0207367073744535, 0.0206802859902382, 0.0206239763647318, 0.0205678064376116, 0.0205117501318455, 0.0204558037221432, 0.0203999746590853, 0.0203442275524139, 0.0202886778861284, 0.0202331524342299, 0.0201778579503298, 0.0201225895434618, 0.0200675446540117, 0.0200125556439161, 0.0199577081948519, 0.0199029464274645, 0.0198483802378178, 0.0197939276695251, 0.0197395011782646, 0.0196853298693895, 0.0196311566978693, 0.0195772107690573, 0.0195232927799225, 0.0194695703685284, 0.0194159038364887, 0.0193624328821898, 0.0193089935928583, 0.0192557759582996, 0.0192026179283857, 0.0191496293991804, 0.0190967489033937, 0.0190439540892839, 0.0189913306385279, 0.0189387612044811, 0.0188863892108202, 0.0188340712338686, 0.0187819264829159, 0.0187298636883497, 0.0186779405921698, 0.0186261888593435, 0.0185744632035494, 0.0185229629278183, 0.0184759199619293, 0.018434027209878, 0.0183922704309225, 0.0183505453169346, 0.0183088891208172, 0.0182673465460539, 0.018225846812129, 0.0181844010949135, 0.018143068999052, 0.0181017909198999, 0.0180605575442314, 0.0180194247514009, 0.017978373914957, 0.0179374497383833, 0.0178965255618095, 0.0178556852042675, 0.0178149286657572, 0.0177742000669241, 0.0177335850894451, 0.0176930539309978, 0.0176525805145502, 0.0176121331751347, 0.0175718273967505, 0.0175315495580435, 0.0174913574010134, 0.0174512472003698, 0.0174112245440483, 0.0173712857067585, 0.0173313859850168, 0.0172915868461132, 0.0172518026083708, 0.0172121431678534, 0.0171725396066904, 0.0171330086886883, 0.0170935336500406, 0.0170541554689407, 0.0170148480683565, 0.0169755965471268, 0.0169364158064127, 0.0168973337858915, 0.0168583374470472, 0.0168194081634283, 0.016780536621809, 0.0167416948825121, 0.0167029928416014, 0.0166643187403679, 0.0166257545351982, 0.0165872219949961, 0.0165487732738256, 0.0165104083716869, 0.0164720993489027, 0.0164338760077953, 0.0163957346230745, 0.0163576528429985, 0.0163197088986635, 0.0162817668169737, 0.0162438806146383, 0.016206132248044, 0.016168400645256, 0.0161307528614998, 0.0160931777209044, 0.0160556826740503, 0.0160182621330023, 0.0159809235483408, 0.0159436259418726, 0.0159064289182425, 0.015869315713644, 0.0158322714269161, 0.0157953128218651, 0.0157584100961685, 0.0157215371727943, 0.0156847890466452, 0.0156480986624956, 0.0156114492565393, 0.0155748976394534, 0.0155384326353669, 0.0155020076781511, 0.0154656674712896, 0.0154294269159436, 0.0153932701796293, 0.0153571553528309, 0.0153211522847414, 0.0152851790189743, 0.0152492616325617, 0.015213456004858, 0.0151777062565088, 0.0151419993489981, 0.0151064330711961, 0.0150708807632327, 0.0150354122743011, 0.0150000294670463, 0.0149647016078234, 0.0149295013397932, 0.0148943299427629, 0.0148592544719577, 0.0148242376744747, 0.0147892758250237, 0.0147544126957655, 0.0147196054458618, 0.0146848689764738, 0.0146502032876015, 0.0146156214177608, 0.0145810814574361, 0.0145466551184654, 0.0145122827962041, 0.0144779970869422, 0.0144438231363893, 0.014409676194191, 0.0143756018951535, 0.0143415816128254, 0.0143076609820127, 0.0142737831920385, 0.0142400022596121, 0.0142062921077013, 0.0141726238653064, 0.0141390701755881, 0.0141055984422565, 0.014072154648602, 0.0140388263389468, 0.0140055939555168, 0.0139723615720868, 0.0139392707496881, 0.0139061650261283, 0.0138731738552451, 0.0138403065502644, 0.0138074411079288, 0.0137746585533023, 0.0137420035898685, 0.0137093206867576, 0.0136767774820328, 0.0136443190276623, 0.0136119173839688, 0.0135796274989843, 0.0135473804548383, 0.0135151902213693, 0.0134830679744482, 0.0134510323405266, 0.0134190665557981, 0.013387156650424, 0.0133553454652429, 0.013323575258255, 0.013291890732944, 0.0132603049278259, 0.0132287750020623, 0.0131973149254918, 0.0131659246981144, 0.0131346769630909, 0.0131034282967448, 0.0130722485482693, 0.0130411554127932, 0.0130101451650262, 0.0129791777580976, 0.0129482951015234, 0.0129174962639809, 0.0128868091851473, 0.012856095097959, 0.0128255216404796, 0.0127950320020318, 0.0127645432949066, 0.0127342501655221, 0.0127039859071374, 0.0126737356185913, 0.0126435691490769, 0.0126135023310781, 0.0125834764912724, 0.0125535633414984, 0.0125236939638853, 0.01249392144382, 0.0124642048031092, 0.0124345598742366, 0.0124049978330731, 0.0123755494132638, 0.0123461149632931, 0.0123167922720313, 0.0122874993830919, 0.0122582754120231, 0.0122291641309857, 0.0122000947594643, 0.0121710961684585, 0.0121422093361616, 0.0121133793145418, 0.0120845641940832, 0.012055916711688, 0.0120272841304541, 0.0119987493380904, 0.0119702983647585, 0.0119418911635876, 0.0119135538116097, 0.0118853142485023, 0.0118571175262332, 0.0118289897218347, 0.011800947599113, 0.0117730032652617, 0.0117451157420874, 0.0117172710597515, 0.011689524166286, 0.0116618322208524, 0.0116342408582568, 0.0116067603230476, 0.0115792946889997, 0.011551913805306, 0.0115245888009667, 0.0114973625168204, 0.0114702051505446, 0.0114431055262685, 0.0114160608500242, 0.0113891158252954, 0.0113622266799212, 0.0113354213535786, 0.0113087296485901, 0.011282037012279, 0.011255512945354, 0.0112290326505899, 0.0112025504931808, 0.011176167987287, 0.0111499121412635, 0.0111236833035946, 0.0110975122079253, 0.011071452870965, 0.0110454484820366, 0.0110195018351078, 0.0109936529770494, 0.0109678748995066, 0.0109421405941248, 0.0109165571630001, 0.0108909904956818, 0.0108655085787177, 0.010840080678463, 0.0108147393912077, 0.0107894539833069, 0.0107642514631152, 0.0107391197234392, 0.0107140596956015, 0.0106890555471182, 0.0106641473248601, 0.0106393126770854, 0.0106145329773426, 0.0105898370966315, 0.0105652827769518, 0.0105407284572721, 0.0105162439867854, 0.0104918433353305, 0.010467542335391, 0.0104432413354516, 0.0104190800338984, 0.0103949755430222, 0.0103709269315004, 0.0103469351306558, 0.0103230550885201, 0.0102992318570614, 0.0102754645049572, 0.0102518377825618, 0.0102282539010048, 0.0102047258988023, 0.0101812547072768, 0.0101578673347831, 0.010134563781321, 0.0101113170385361, 0.0100881680846214, 0.0100650489330292, 0.0100420126691461, 0.0100190890952945, 0.00999622233211994, 0.00997338350862265, 0.00995072722434998, 0.0099280858412385, 0.00990545749664307, 0.00988298282027245, 0.00986053980886936, 0.00983813591301441, 0.0098158735781908, 0.00979365315288305, 0.00977148953825235, 0.00974941067397594, 0.00972741469740868, 0.00970549043267965, 0.00968367792665958, 0.00966190733015537, 0.00964019447565079, 0.0096185365691781, 0.00959697738289833, 0.00957547407597303, 0.00955405551940203, 0.00953270774334669, 0.00951141584664583, 0.00949022173881531, 0.00946909934282303, 0.00944803189486265, 0.00942706316709518, 0.00940612237900496, 0.00938533805310726, 0.00936457980424166, 0.00934386439621449, 0.00932324770838022, 0.00930272880941629, 0.00928222388029099, 0.00926183350384235, 0.00924149714410305, 0.00922124553471804, 0.00920103676617146, 0.00918095372617245, 0.00916091352701187, 0.00914091616868973, 0.00912110041826963, 0.00910128466784954, 0.00908151175826788, 0.00906185153871775, 0.00904224719852209, 0.00902269873768091, 0.00900324899703264, 0.00898388400673866, 0.00896457489579916, 0.00894530862569809, 0.0089261531829834, 0.00890705548226833, 0.00888802763074636, 0.0088690984994173, 0.00885025411844254, 0.008831437677145, 0.00881271809339523, 0.00879408419132233, 0.00877546425908804, 0.00875695701688528, 0.00873854756355286, 0.00872019585222006, 0.00870185717940331, 0.00868365913629532, 0.00866550300270319, 0.00864740274846554, 0.00862940307706594, 0.00861154217272997, 0.00859365332871675, 0.00857589114457369, 0.00855818577110767, 0.00854052230715752, 0.00852297060191631, 0.00850547570735216, 0.00848805159330368, 0.00847071129828691, 0.00845341384410858, 0.00843622721731663, 0.0084190983325243, 0.00840205419808626, 0.00838512182235718, 0.00836818944662809, 0.00835136976093054, 0.00833457708358765, 0.00831791292876005, 0.0083012618124485, 0.00828472245484591, 0.00826825574040413, 0.0082518570125103, 0.00823551509529352, 0.00821927189826965, 0.00820304360240698, 0.00818696804344654, 0.00817092135548592, 0.00815498828887939, 0.00813912507146597, 0.00812328886240721, 0.00810755230486393, 0.00809185765683651, 0.00807627569884062, 0.00806073565036058, 0.00804526545107365, 0.00802989490330219, 0.00801457930356264, 0.00799933448433876, 0.00798417441546917, 0.00796915497630835, 0.00795410666614771, 0.00793915800750256, 0.00792427826672792, 0.00790949817746878, 0.00789474509656429, 0.00788010563701391, 0.00786553602665663, 0.00785099435597658, 0.00783656537532806, 0.00782220717519522, 0.00780787551775575, 0.00779365794733167, 0.00777959451079369, 0.00776548916473985, 0.00775151001289487, 0.00773757323622704, 0.00772372120991349, 0.00770993856713176, 0.00769621273502707, 0.00768257118761539, 0.00766900042071939, 0.0076555130071938, 0.00764209683984518, 0.00762873701751232, 0.00761548895388842, 0.0076023256406188, 0.00758920470252633, 0.00757613964378834, 0.00756314536556602, 0.00755026284605265, 0.00753739476203918, 0.00752463983371854, 0.0075119542889297, 0.00749932555481791, 0.00748675270006061, 0.00747429253533483, 0.00746186031028628, 0.00744956964626908, 0.00743730599060655, 0.00742518343031406, 0.00741304690018296, 0.00740102212876081, 0.0073890401981771, 0.00737715652212501, 0.00736532965674996, 0.00735360058024526, 0.00734189990907907, 0.00733031192794442, 0.00731879379600286, 0.00730731803923845, 0.00729595497250557, 0.00728463428094983, 0.00727346772328019, 0.00726227322593331, 0.00725116347894073, 0.007240179926157, 0.00722919637337327, 0.0072183390147984, 0.00720751052722335, 0.00719678029417992, 0.00718616181984544, 0.00717558665201068, 0.00716508133336902, 0.00715461792424321, 0.0071442537009716, 0.00713404361158609, 0.00712380558252335, 0.00711363740265369, 0.00710355397313833, 0.00709355482831597, 0.00708361249417067, 0.00707379635423422, 0.00706397974863648, 0.00705427583307028, 0.00704464223235846, 0.00703509338200092, 0.00702555850148201, 0.00701616425067186, 0.00700682587921619, 0.00699757225811481, 0.00698840338736773, 0.00697926199063659, 0.00697017693892121, 0.00696123251691461, 0.00695231650024652, 0.00694348430261016, 0.00693468097597361, 0.00692601827904582, 0.00691738305613399, 0.00690883211791515, 0.00690038036555052, 0.00689204083755612, 0.0068836729042232, 0.00687543209642172, 0.0068672327324748, 0.00685913255438209, 0.00685111666098237, 0.00684312824159861, 0.00683525297790766, 0.00682740565389395, 0.00681967101991177, 0.00681200623512268, 0.00680436939001083, 0.00679687364026904, 0.00678947614505887, 0.00678209355100989, 0.00677476590499282, 0.00676755188032985, 0.00676037976518273, 0.00675326306372881, 0.00674624601379037, 0.00673932675272226, 0.00673240702599287, 0.0067256148904562, 0.00671889213845134, 0.00671225460246205, 0.00670564454048872, 0.0066991476342082, 0.0066927345469594, 0.00668640621006489, 0.00668010534718633, 0.00667390413582325, 0.00666772993281484, 0.006661640945822, 0.00665566325187683, 0.00664972886443138, 0.00664386479184031, 0.00663811201229692, 0.00663234619423747, 0.00662672100588679, 0.00661524338647723, 0.00659881718456745, 0.00658233510330319, 0.00656596524640918, 0.0065495390444994, 0.00653319759294391, 0.00651688408106565, 0.00650054262951016, 0.00648434134200215, 0.0064681121148169, 0.00645188335329294, 0.00643568206578493, 0.00641953758895397, 0.00640339264646173, 0.00638736039400101, 0.00637132814154029, 0.00635523954406381, 0.00633920775726438, 0.00632328726351261, 0.00630731135606766, 0.00629141973331571, 0.00627552811056376, 0.00625966489315033, 0.00624380121007562, 0.00622802227735519, 0.00621224334463477, 0.00619652029126883, 0.00618079770356417, 0.00616510258987546, 0.00614943634718657, 0.00613382598385215, 0.00611818768084049, 0.00610266113653779, 0.00608713505789638, 0.00607160944491625, 0.0060561397112906, 0.00604066997766495, 0.00602522864937782, 0.00600987114012241, 0.00599451409652829, 0.00597918452695012, 0.005963827483356, 0.00594855472445488, 0.00593328196555376, 0.00591809349134564, 0.00590290501713753, 0.00588774494826794, 0.00587258487939835, 0.00585745228454471, 0.00584240444004536, 0.00582741294056177, 0.00581233715638518, 0.00579737359657884, 0.00578241050243378, 0.00576744647696614, 0.00575253926217556, 0.00573771679773927, 0.00572283798828721, 0.00570804299786687, 0.00569324800744653, 0.00567845348268747, 0.00566374324262142, 0.00564908934757113, 0.00563440751284361, 0.00561978109180927, 0.00560515513643622, 0.00559052964672446, 0.00557598797604442, 0.00556150265038013, 0.00554698891937733, 0.00553253199905157, 0.00551807507872581, 0.00550361815840006, 0.00548927299678326, 0.00547495670616627, 0.00546061201021075, 0.00544635206460953, 0.00543206324800849, 0.00541780283674598, 0.00540359923616052, 0.00538947945460677, 0.00537530332803726, 0.0053611840121448, 0.00534706423059106, 0.00533300079405308, 0.00531899370253086, 0.00530493026599288, 0.00529100792482495, 0.00527708465233445, 0.005263133905828, 0.00524923950433731, 0.0052354009822011, 0.00522153452038765, 0.00520778074860573, 0.00519399810582399, 0.00518021639436483, 0.00516654690727592, 0.00515282060950994, 0.00513915112242103, 0.00512559432536364, 0.00511195231229067, 0.00509836757555604, 0.00508486665785313, 0.00507136574015021, 0.00505783688277006, 0.00504442071542144, 0.005030975677073, 0.00501758744940162, 0.005004255566746, 0.00499089527875185, 0.00497756339609623, 0.00496431533247232, 0.00495103932917118, 0.00493782013654709, 0.00492465635761619, 0.00491149351000786, 0.00489833019673824, 0.00488525116816163, 0.00487217213958502, 0.00485909311100841, 0.00484612677246332, 0.004833132494241, 0.00482013775035739, 0.00480725569650531, 0.00479431729763746, 0.00478143524378538, 0.00476860953494906, 0.00475578382611275, 0.00474298605695367, 0.00473027257248759, 0.00471753161400557, 0.00470481812953949, 0.00469216099008918, 0.00467950385063887, 0.00466690305620432, 0.00465433020144701, 0.00464175781235099, 0.00462921289727092, 0.00461678113788366, 0.00460429256781936, 0.00459180492907763, 0.00457945745438337, 0.00456705316901207, 0.00455467775464058, 0.00454241409897804, 0.00453009502962232, 0.00451780343428254, 0.00450562452897429, 0.00449338927865028, 0.0044811824336648, 0.00446905940771103, 0.00445693684741855, 0.00444481428712606, 0.00443283235654235, 0.0044207377359271, 0.00440872740000486, 0.00439680181443691, 0.00438484782353044, 0.00437292270362377, 0.0043610529974103, 0.00434918375685811, 0.00433731405064464, 0.00432550068944693, 0.00431380001828074, 0.00430201459676027, 0.00429034233093262, 0.00427864119410515, 0.00426696892827749, 0.00425532413646579, 0.00424376456066966, 0.00423217611387372, 0.00422061560675502, 0.00420914031565189, 0.00419763615354896, 0.00418616086244583, 0.00417479733005166, 0.00416337791830301, 0.00415198691189289, 0.00414070766419172, 0.00412937253713608, 0.00411806581541896, 0.00410687131807208, 0.00409562094137073, 0.00408442644402385, 0.00407328782603145, 0.00406212173402309, 0.00405101152136922, 0.00403995765373111, 0.00402893219143152, 0.00401787832379341, 0.00400693668052554, 0.00399596756324172, 0.00398499798029661, 0.00397414108738303, 0.00396322831511497, 0.00395237095654011, 0.00394162675365806, 0.003930798266083, 0.00392002519220114, 0.00390933733433485, 0.00389862083829939, 0.00388796092011034, 0.00387732917442918, 0.00386669696308672, 0.00385612156242132, 0.0038456020411104, 0.00383505458012223, 0.00382453505881131, 0.00381410005502403, 0.00380363687872887, 0.00379323004744947, 0.00378287932835519, 0.00377252860926092, 0.00376217812299728, 0.00375191168859601, 0.00374164548702538, 0.00373137928545475, 0.003721225541085, 0.00371104362420738, 0.00370086170732975, 0.00369076430797577, 0.00368066690862179, 0.00367059744894505, 0.00366058433428407, 0.00365057121962309, 0.00364055787213147, 0.00363065744750202, 0.00362075679004192, 0.00361085613258183, 0.0036010118201375, 0.00359116750769317, 0.00358135113492608, 0.00357161927968264, 0.00356185948476195, 0.00355212739668787, 0.00354247982613742, 0.00353280454874039, 0.00352315697818995, 0.00351362186484039, 0.00350403087213635, 0.00349446758627892, 0.00348498881794512, 0.00347548210993409, 0.00346603151410818, 0.00345663703046739, 0.00344721483998001, 0.0034378485288471, 0.00342848221771419, 0.00341920065693557, 0.00340991863049567, 0.00340066500939429, 0.00339146750047803, 0.00338227022439241, 0.00337310065515339, 0.00336398766376078, 0.00335487443953753, 0.00334578962065279, 0.00333676091395319, 0.00332773220725358, 0.00331873167306185, 0.00330981542356312, 0.00330087100155652, 0.0032919270452112, 0.00328312325291336, 0.00327423517592251, 0.00326540344394743, 0.0032566839363426, 0.0032478803768754, 0.00323916133493185, 0.00323049817234278, 0.00322180707007647, 0.00321314390748739, 0.00320456526242197, 0.00319598661735654, 0.00318740773946047, 0.00317891361191869, 0.00317039107903838, 0.00316192489117384, 0.00315351504832506, 0.00314510520547628, 0.00313669536262751, 0.00312839797697961, 0.0031200444791466, 0.00311171892099082, 0.00310350582003593, 0.00309526477940381, 0.00308705167844892, 0.00307889492250979, 0.00307073816657066, 0.00306260958313942, 0.0030545371118933, 0.00304646487347782, 0.00303842057473958, 0.00303046079352498, 0.00302247260697186, 0.00301448442041874, 0.00300663709640503, 0.00299870548769832, 0.00299085816368461, 0.00298306695185602, 0.00297521962784231, 0.00296745682135224, 0.0029597501270473, 0.00295201526023448, 0.00294430856592953, 0.00293668592348695, 0.00292906351387501, 0.00292144133709371, 0.00291390344500542, 0.00290636532008648, 0.00289882742799819, 0.00289140176028013, 0.0028839202132076, 0.00287646660581231, 0.00286912568844855, 0.00286172819323838, 0.00285438727587461, 0.00284710223786533, 0.00283981743268669, 0.00283256080001593, 0.00282536051236093, 0.00281815975904465, 0.00281098764389753, 0.00280389958061278, 0.00279678357765079, 0.00278966734185815, 0.00278260768391192, 0.00277563231065869, 0.00276862853206694, 0.00276165315881371, 0.00275476230308414, 0.00274784304201603, 0.00274095195345581, 0.00273414538241923, 0.00272731063887477, 0.00272050383500755, 0.00271380972117186, 0.0027070592623204, 0.00270033697597682, 0.00269372714683414, 0.00268706097267568, 0.00268042320385575, 0.00267386971972883, 0.00266731600277126, 0.00266076251864433, 0.00265432149171829, 0.00264782435260713, 0.00264138332568109, 0.00263499841094017, 0.00262861372902989, 0.00262222881428897, 0.00261595682241023, 0.00260965619236231, 0.00260335602797568, 0.00259716785512865, 0.00259095197543502, 0.00258476403541863, 0.00257866061292589, 0.00257250084541738, 0.00256639742292464, 0.00256037805229425, 0.00255433097481728, 0.00254831183701754, 0.00254237721674144, 0.00253641419112682, 0.00253047957085073, 0.00252465717494488, 0.00251877889968455, 0.00251292833127081, 0.00250716228038073, 0.0025013682898134, 0.00249563041143119, 0.00248994887806475, 0.00248423917219043, 0.00247858557850122, 0.00247298856265843, 0.00246739108115435, 0.00246179383248091, 0.00245628110133111, 0.00245076813735068, 0.00244525563903153, 0.00243985513225198, 0.00243442668579519, 0.00242899800650775, 0.00242365407757461, 0.00241830991581082, 0.00241299392655492, 0.00240773451514542, 0.00240250281058252, 0.00239727110601962, 0.00239212391898036, 0.00238692061975598, 0.00238177343271673, 0.00237671053037047, 0.00237161945551634, 0.00236655678600073, 0.00236157840117812, 0.00235659978352487, 0.00235159322619438, 0.0023467275314033, 0.00234180525876582, 0.00233691115863621, 0.00233210134319961, 0.00232729176059365, 0.00232245423831046, 0.00231770076788962, 0.0023130034096539, 0.00230827811174095, 0.00230360915884376, 0.00229902449063957, 0.00229438347741961, 0.00228977063670754, 0.002285270486027, 0.00228074216283858, 0.00227621360681951, 0.00227179774083197, 0.00226735370233655, 0.00226290966384113, 0.00225857808254659, 0.00225421856157482, 0.00224988698028028, 0.00224561174400151, 0.00224133627489209, 0.0022370892111212, 0.00223289825953543, 0.00222873548045754, 0.0022245729342103, 0.00222049443982542, 0.00221635983325541, 0.00221230951137841, 0.00220831553451717, 0.00220429338514805, 0.00220029940828681, 0.00219638994894922, 0.0021924520842731, 0.00218857056461275, 0.00218474538996816, 0.00218089204281569, 0.0021770668681711, 0.00217335415072739, 0.0021696132607758, 0.00216584443114698, 0.00216221599839628, 0.00215855962596834, 0.00215490278787911, 0.00215135887265205, 0.00214775861240923, 0.00214418675750494, 0.00214072712697089, 0.00213723932392895, 0.00213377992622554, 0.00213037640787661, 0.00212697312235832, 0.00212362594902515, 0.00212030718103051, 0.00211698818020523, 0.00211369735188782, 0.00211046263575554, 0.0021072281524539, 0.00210404978133738, 0.00210092775523663, 0.00209774938412011, 0.00209465553052723, 0.00209161778911948, 0.00208855210803449, 0.0020855141337961, 0.00208258908241987, 0.00207957951352, 0.00207665446214378, 0.00207378529012203, 0.00207091658376157, 0.00206801947206259, 0.00206526299007237, 0.00206247833557427, 0.00205969391390681, 0.00205699354410172, 0.0020542936399579, 0.00205159350298345, 0.00204900559037924, 0.00204638997092843, 0.00204380229115486, 0.00204127072356641, 0.00203873962163925, 0.00203623599372804, 0.00203373283147812, 0.00203134212642908, 0.00202892324887216, 0.00202656071633101, 0.00202419795095921, 0.00202186335809529, 0.00201958534307778, 0.00201733503490686, 0.00201508495956659, 0.00201289099641144, 0.00201072520576417, 0.00200855941511691, 0.0020064499694854, 0.00200436846353114, 0.0020023153629154, 0.00200026202946901, 0.00199832138605416, 0.00199629622511566, 0.00199435534887016, 0.00199249899014831, 0.00199055834673345, 0.0019887019880116, 0.00198692991398275, 0.0019850735552609, 0.00198330171406269, 0.00198161415755749, 0.00197989819571376, 0.00197818246670067, 0.00197657942771912, 0.00197494798339903, 0.00197331677190959, 0.0019717977847904, 0.00197025085799396, 0.00196870393119752, 0.00196726946160197, 0.00196580681949854, 0.00196437234990299, 0.0019629942253232, 0.00196164404042065, 0.0019602938555181, 0.00195900024846196, 0.00195770617574453, 0.00195646868087351, 0.00195525912567973, 0.00195407797582448, 0.0019528967095539, 0.001951799611561, 0.00195067469030619, 0.00194957759231329, 0.00194859330076724, 0.00194755254779011, 0.00194653996732086, 0.00194563996046782, 0.00194468360859901, 0.00194375542923808, 0.00194293970707804, 0.00194209592882544, 0.00194125215057284, 0.00194049277342856, 0.00193973327986896, 0.00193897378630936, 0.00193832698278129, 0.00193765189033002, 0.00193697679787874, 0.001936414395459, 0.00193582370411605, 0.00193526106886566, 0.00193475477863103, 0.00193427677731961, 0.00193379854317755, 0.00193337665405124, 0.00193295476492494, 0.00193258922081441, 0.00193225161638111, 0.00193191412836313, 0.00193163275253028, 0.00193132343702018, 0.00193112646229565, 0.00193092960398644, 0.00193078897427768, 0.00193062028847635, 0.00193047965876758, 0.00193039525765926, 0.00193033902905881, 0.00193031085655093, 0.00193031085655093, 0.00193039525765926, 0.00193039525765926, 0.00193047965876758, 0.00193064834456891, 0.00193076080176979, 0.00193092960398644, 0.00193118269089609, 0.00193135149311274, 0.00193160469643772, 0.00193194218445569, 0.00193225161638111, 0.00193256104830652, 0.00193301099352539, 0.00193340482655913, 0.00193379854317755, 0.00193430483341217, 0.00193478295113891, 0.00193526106886566, 0.00193587993271649, 0.00193644256796688, 0.00193700497038662, 0.0019376800628379, 0.00193835515528917, 0.00193903013132513, 0.0019397895084694, 0.00194052094593644, 0.00194130837917328, 0.00194212410133332, 0.00194296787958592, 0.00194383983034641, 0.00194476800970733, 0.00194566801656038, 0.00194662436842918, 0.00194763694889843, 0.0019486213568598, 0.00194966199342161, 0.00195078714750707, 0.00195182778406888, 0.00195295293815434, 0.00195416226051748, 0.00195534364320338, 0.00195652502588928, 0.00195781886577606, 0.00195908453315496, 0.00196035020053387, 0.00196172832511365, 0.0019630785100162, 0.00196445663459599, 0.00196591927669942, 0.00196735374629498, 0.00196878821589053, 0.00197036331519485, 0.0019718820694834, 0.00197342922911048, 0.00197506044059992, 0.00197666371241212, 0.00197832309640944, 0.00198001088574529, 0.00198169844225049, 0.00198344234377146, 0.00198521418496966, 0.0019870144315064, 0.00198884261772037, 0.0019907271489501, 0.00199258350767195, 0.00199449597857893, 0.00199646502733231, 0.00199840567074716, 0.00200040265917778, 0.00200242782011628, 0.00200453726574779, 0.00200659059919417, 0.00200875638984144, 0.00201089400798082, 0.00201303162612021, 0.00201522558927536, 0.00201750383712351, 0.0020197257399559, 0.00202200398780406, 0.00202436652034521, 0.00202667317353189, 0.00202903570607305, 0.00203148275613785, 0.00203392980620265, 0.00203634868375957, 0.00203888025134802, 0.00204141158610582, 0.00204391498118639, 0.0020465306006372, 0.00204914622008801, 0.00205173413269222, 0.00205446244217455, 0.00205716234631836, 0.00205986271612346, 0.00206264713779092, 0.00206540361978114, 0.00206821644678712, 0.00207108515314758, 0.00207395409233868, 0.00207682326436043, 0.00207977648824453, 0.00208272971212864, 0.00208571110852063, 0.00208877702243626, 0.00209178659133613, 0.00209485227242112, 0.00209800247102976, 0.00210106838494539, 0.00210421858355403, 0.00210748123936355, 0.00211065961048007, 0.00211389409378171, 0.002117213094607, 0.0021205039229244, 0.0021237947512418, 0.00212722620926797, 0.00213060132227838, 0.00213397666811943, 0.00213749264366925, 0.00214095204137266, 0.00214441167190671, 0.00214801193214953, 0.00215155584737659, 0.0021551561076194, 0.00215878454037011, 0.00216244091279805, 0.00216609751805663, 0.00216983840800822, 0.00217357906512916, 0.00217734812758863, 0.00218114512972534, 0.00218497053720057, 0.00218882388435304, 0.00219276151619852, 0.00219661486335099, 0.00220055249519646, 0.00220457464456558, 0.00220854068174958, 0.00221256259828806, 0.00221666926518083, 0.00222071935422719, 0.00222482602111995, 0.00222901697270572, 0.00223317951895297, 0.00223734229803085, 0.00224164570681751, 0.00224589300341904, 0.00225014006718993, 0.00225449982099235, 0.00225885934196413, 0.00226319092325866, 0.00226763496175408, 0.00227207900024951, 0.00227652303874493, 0.00228099524974823, 0.00228555174544454, 0.00229010824114084, 0.00229463656432927, 0.0022993057500571, 0.00230391859076917, 0.00230855937115848, 0.00231331284157932, 0.00231801019981503, 0.00232276320457458, 0.00232757302001119, 0.00233238283544779, 0.00233722059056163, 0.00234208651818335, 0.00234698061831295, 0.0023519026581198, 0.0023568810429424, 0.00236185966059566, 0.00236686621792614, 0.00237195705994964, 0.00237699178978801, 0.0023820826318115, 0.00238728616386652, 0.00239240517839789, 0.00239758053794503, 0.00240284041501582   }, 
}; 

// background map
float ReadLikelihood::fRefB[][10000] = 
{ 
   { 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 6.5103094e-08, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 2.6814895e-08, 1.3404446e-07, 2.3361278e-07, 3.791381e-07, 5.3232122e-07, 7.1614119e-07, 9.4208809e-07, 1.1910072e-06, 1.4475886e-06, 1.7309792e-06, 2.0794701e-06, 2.3973253e-06, 2.7764518e-06, 3.1747275e-06, 3.5921498e-06, 4.0440391e-06, 4.5418819e-06, 5.0397271e-06, 5.5413984e-06, 6.0966886e-06, 6.6979273e-06, 7.2991706e-06, 7.9157271e-06, 8.5820739e-06, 9.2484152e-06, 9.9645413e-06, 1.0703649e-05, 1.1454245e-05, 1.2235471e-05, 1.3070321e-05, 1.3886017e-05, 1.4747669e-05, 1.5647618e-05, 1.6551392e-05, 1.7485805e-05, 1.8466171e-05, 1.946569e-05, 2.0476691e-05, 2.152599e-05, 2.2590606e-05, 2.3682036e-05, 2.481175e-05, 2.5975944e-05, 2.7109492e-05, 2.8315804e-05, 2.9568071e-05, 3.0797361e-05, 3.2068776e-05, 3.3393801e-05, 3.4695851e-05, 3.6063e-05, 3.7449296e-05, 3.8866245e-05, 4.0283176e-05, 4.1749892e-05, 4.3239601e-05, 4.4744611e-05, 4.6276436e-05, 4.785039e-05, 4.9409016e-05, 5.1028921e-05, 5.2679461e-05, 5.432234e-05, 5.6037985e-05, 5.7768942e-05, 5.9473099e-05, 6.1250008e-05, 6.3069056e-05, 6.4868946e-05, 6.6710963e-05, 6.8587455e-05, 7.0506052e-05, 7.2413175e-05, 7.4350937e-05, 7.635379e-05, 7.8337507e-05, 8.035951e-05, 8.2435145e-05, 8.4491599e-05, 8.6594038e-05, 8.8734763e-05, 9.0879308e-05, 9.3069815e-05, 9.5287134e-05, 9.7496784e-05, 9.977154e-05, 0.00010205396, 0.00010434403, 0.00010668772, 0.00010907737, 0.00011147468, 0.00011385666, 0.00011631524, 0.00011879297, 0.00012126303, 0.00012379052, 0.00012634486, 0.00012889916, 0.00013150711, 0.00013413417, 0.00013675742, 0.00013944578, 0.00014215327, 0.00014486077, 0.00014761422, 0.00015040213, 0.00015317855, 0.00015603541, 0.00015888843, 0.00016178357, 0.00016466342, 0.00016761984, 0.00017057624, 0.00017353649, 0.00017656184, 0.00017961017, 0.00018265468, 0.00018573363, 0.00018887388, 0.00019197963, 0.00019515818, 0.00019835203, 0.00020154589, 0.00020480482, 0.0002080791, 0.00021137251, 0.00021467743, 0.00021803597, 0.00022143277, 0.00022479129, 0.00022823023, 0.00023169216, 0.00023515789, 0.0002386696, 0.00024219281, 0.00024572367, 0.00024931578, 0.0002529347, 0.00025654599, 0.00026019555, 0.00026390256, 0.00026759808, 0.00027133955, 0.00027509252, 0.00027890294, 0.00028268268, 0.00028654293, 0.00029040308, 0.00029427864, 0.00029820774, 0.00030215221, 0.00030611578, 0.00031009471, 0.00031412338, 0.00031815592, 0.00032223819, 0.000326332, 0.00033044879, 0.0003346077, 0.00033878192, 0.00034296376, 0.00034719546, 0.00035145774, 0.00035575067, 0.0003600168, 0.00036435187, 0.0003687329, 0.00037309475, 0.00037751021, 0.00038195631, 0.0003863833, 0.0003908792, 0.00039539809, 0.00039991696, 0.00040448946, 0.00040908874, 0.00041368805, 0.00041832565, 0.00042300537, 0.0004276736, 0.00043240309, 0.00043716319, 0.0004419272, 0.00044669883, 0.00045153173, 0.00045639143, 0.00046122819, 0.00046615681, 0.00047108164, 0.0004760141, 0.00048098486, 0.00048601304, 0.00049102592, 0.00049607333, 0.00050117425, 0.00050624844, 0.00051139155, 0.00051656144, 0.00052172755, 0.00052693574, 0.00053218601, 0.00053745165, 0.00054271729, 0.00054803275, 0.00055338268, 0.00055872486, 0.00056413986, 0.00056957023, 0.00057497749, 0.00058045762, 0.00058596453, 0.0005914676, 0.00059700513, 0.00060259242, 0.00060817209, 0.00061379012, 0.00061944633, 0.00062514853, 0.00063081243, 0.00063655298, 0.00064233172, 0.00064806844, 0.00065388175, 0.00065972173, 0.00066558865, 0.00067144021, 0.0006773569, 0.00068328506, 0.00068925152, 0.00069524092, 0.00070122653, 0.00070727721, 0.00071335858, 0.00071942841, 0.00072553265, 0.00073168683, 0.00073786773, 0.00074404478, 0.00075025251, 0.00075652148, 0.00076275982, 0.00076906331, 0.00077541271, 0.00078174681, 0.00078810391, 0.00079451071, 0.00080093287, 0.00080736651, 0.00081385765, 0.00082035636, 0.00082688581, 0.00083344191, 0.00083999819, 0.00084661948, 0.00085326761, 0.00085993868, 0.00086658675, 0.0008733038, 0.00088005536, 0.00088678394, 0.00089358521, 0.00090041716, 0.00090725283, 0.00091409625, 0.00092100102, 0.00092790183, 0.00093484099, 0.00094181846, 0.00094881124, 0.00095581543, 0.00096287334, 0.00096994272, 0.00097702735, 0.0009841657, 0.00099132315, 0.00099848059, 0.0010056993, 0.0010129218, 0.0010201521, 0.0010274436, 0.0010347656, 0.0010420915, 0.0010494289, 0.0010568314, 0.0010642225, 0.0010716519, 0.0010791234, 0.0010865949, 0.0010941046, 0.0011016488, 0.0011091931, 0.0011167832, 0.0011244079, 0.0011320785, 0.0011397031, 0.0011474082, 0.00115514, 0.0011628643, 0.0011706498, 0.0011784468, 0.0011862743, 0.0011941058, 0.0012019909, 0.0012098568, 0.0012177993, 0.0012257647, 0.0012337264, 0.0012417072, 0.0012497646, 0.0012578373, 0.0012658831, 0.0012739981, 0.0012821435, 0.0012902699, 0.0012984651, 0.0013067063, 0.0013149283, 0.0013231733, 0.0013314721, 0.0013397975, 0.0013481077, 0.0013564866, 0.0013648621, 0.0013732831, 0.0013817388, 0.0013901715, 0.0013986847, 0.0014072207, 0.0014157683, 0.0014243005, 0.0014329285, 0.0014415565, 0.0014501845, 0.0014588585, 0.0014675822, 0.0014763098, 0.001485045, 0.0014938529, 0.0015026417, 0.0015114612, 0.0015203266, 0.0015291882, 0.0015380996, 0.0015470455, 0.0015559951, 0.0015649832, 0.0015739941, 0.0015830433, 0.0015920886, 0.0016011799, 0.0016103135, 0.0016194164, 0.0016286151, 0.001637806, 0.0016470351, 0.0016562529, 0.0016655435, 0.0016748416, 0.0016841436, 0.001693503, 0.0017028509, 0.001712264, 0.0017217002, 0.0017311361, 0.0017405952, 0.0017501116, 0.0017596739, 0.0017692018, 0.0017787835, 0.0017884034, 0.0017980154, 0.0018076812, 0.0018173624, 0.0018270817, 0.0018368012, 0.001846578, 0.0018563663, 0.0018661624, 0.0018760082, 0.0018858579, 0.0018957611, 0.0019056757, 0.0019156096, 0.001925574, 0.0019355809, 0.0019456295, 0.0019556284, 0.0019657155, 0.0019758295, 0.0019859241, 0.0019960762, 0.002006263, 0.0020164801, 0.0020266974, 0.0020369452, 0.0020472391, 0.0020575253, 0.0020678728, 0.0020782126, 0.0020885945, 0.0020990109, 0.0021094582, 0.002119882, 0.0021303867, 0.0021409139, 0.0021514185, 0.0021620034, 0.0021725958, 0.0021832152, 0.0021938386, 0.002204519, 0.0022152036, 0.0022259073, 0.0022366606, 0.0022474483, 0.0022582326, 0.0022690548, 0.0022798886, 0.0022907683, 0.0023016711, 0.0023126083, 0.0023235301, 0.0023345288, 0.0023455464, 0.0023565295, 0.0023676122, 0.0023786949, 0.0023898198, 0.002400937, 0.002412085, 0.0024232899, 0.00243448, 0.0024457353, 0.0024569826, 0.002468257, 0.0024795847, 0.0024909086, 0.0025022593, 0.0025136673, 0.0025250986, 0.0025365187, 0.0025480073, 0.0025594961, 0.0025710037, 0.0025825535, 0.0025941422, 0.0026057377, 0.0026173452, 0.0026290177, 0.0026406902, 0.0026523781, 0.002664112, 0.0026758648, 0.0026876293, 0.0026994511, 0.0027112577, 0.0027231139, 0.0027350162, 0.0027469452, 0.0027588396, 0.0027708109, 0.0027828165, 0.0027948029, 0.0028068433, 0.0028189218, 0.0028310115, 0.0028431169, 0.002855276, 0.002867423, 0.0028796126, 0.0028918404, 0.0029040948, 0.0029163416, 0.0029286423, 0.0029409504, 0.0029533124, 0.0029656894, 0.0029781088, 0.002990505, 0.003002974, 0.0030154584, 0.0030279197, 0.0030404653, 0.0030530416, 0.0030656257, 0.0030782018, 0.0030908508, 0.0031035228, 0.0031161832, 0.0031288934, 0.00314165, 0.0031543907, 0.0031671971, 0.0031800258, 0.0031934956, 0.0032080326, 0.0032226157, 0.0032371986, 0.0032518734, 0.0032665939, 0.003281361, 0.0032961429, 0.0033110017, 0.003325891, 0.0033408264, 0.0033558074, 0.0033708652, 0.0033859229, 0.0034010573, 0.0034162225, 0.003431418, 0.0034466905, 0.0034620087, 0.0034773115, 0.0034927216, 0.0035081776, 0.0035236184, 0.0035391664, 0.0035547605, 0.003570385, 0.003586025, 0.0036017413, 0.0036175039, 0.0036332966, 0.0036491512, 0.0036650363, 0.0036809675, 0.0036970051, 0.0037130283, 0.0037290817, 0.0037452118, 0.003761403, 0.0037775638, 0.003793847, 0.003810161, 0.0038264901, 0.0038429115, 0.0038593633, 0.0038758304, 0.0038923586, 0.0039089331, 0.0039255531, 0.0039422042, 0.003958947, 0.0039757048, 0.0039924784, 0.0040093437, 0.0040262402, 0.0040431973, 0.0040602004, 0.0040772343, 0.0040942836, 0.0041114246, 0.0041286265, 0.0041457987, 0.0041630622, 0.0041803871, 0.0041977274, 0.0042151138, 0.0042325608, 0.0042500696, 0.0042675785, 0.0042851791, 0.0043027797, 0.0043204413, 0.0043381648, 0.0043559186, 0.0043737185, 0.0043915794, 0.0044094864, 0.0044274391, 0.0044454536, 0.0044634831, 0.0044815587, 0.0044996799, 0.0045178626, 0.0045360606, 0.0045543201, 0.0045726406, 0.0045910073, 0.004609358, 0.0046278168, 0.0046463213, 0.0046648253, 0.0046834373, 0.0047020488, 0.0047207065, 0.0047394405, 0.0047582057, 0.0047769859, 0.0047958423, 0.0048148064, 0.0048337393, 0.0048527038, 0.0048717749, 0.0048908456, 0.0049099629, 0.0049291411, 0.0049483506, 0.0049676057, 0.0049869218, 0.005006284, 0.0050256466, 0.0050451155, 0.0050646155, 0.0050841467, 0.0051037078, 0.0051233764, 0.0051430142, 0.0051627443, 0.0051825354, 0.0052023567, 0.0052222093, 0.0052421079, 0.0052620517, 0.0052820272, 0.005302079, 0.0053221607, 0.0053422889, 0.0053624632, 0.0053826831, 0.0054029338, 0.005423246, 0.0054436042, 0.0054639922, 0.0054844581, 0.0055049686, 0.0055254642, 0.0055460669, 0.0055667008, 0.0055873962, 0.0056080907, 0.005628862, 0.0056497101, 0.0056705433, 0.0056914683, 0.0057124235, 0.0057333787, 0.005754441, 0.0057755187, 0.005796643, 0.0058178129, 0.0058390591, 0.0058602896, 0.005881628, 0.0059029968, 0.0059243659, 0.0059458115, 0.005967333, 0.0059888707, 0.0060104392, 0.0060320986, 0.0060537746, 0.0060754651, 0.0060972781, 0.006119106, 0.0061409506, 0.0061628553, 0.0061847907, 0.0062067881, 0.0062288465, 0.0062509198, 0.0062730545, 0.0062952354, 0.0063174623, 0.0063397503, 0.0063620536, 0.0063844025, 0.0064068134, 0.0064292541, 0.0064517567, 0.00647429, 0.0064968686, 0.0065194936, 0.0065422109, 0.0065649278, 0.0065877065, 0.00661053, 0.0066333702, 0.0066563012, 0.0066792476, 0.0067022094, 0.0067252787, 0.0067483792, 0.0067714942, 0.0067946706, 0.006817908, 0.0068411916, 0.0068644914, 0.0068878513, 0.0069112568, 0.006934694, 0.0069582229, 0.0069817519, 0.0070053106, 0.0070289774, 0.0070526903, 0.0070763878, 0.0071001612, 0.0071239816, 0.0071478472, 0.0071717594, 0.0071957167, 0.0072197355, 0.0072437543, 0.0072678658, 0.0072919917, 0.0073161637, 0.0073403972, 0.0073646614, 0.0073889559, 0.0074133421, 0.0074377595, 0.0074622077, 0.007486701, 0.0075112414, 0.0075358264, 0.0075605046, 0.0075851828, 0.0076098908, 0.0076346905, 0.0076595214, 0.0076843831, 0.0077092596, 0.0077342289, 0.0077592279, 0.0077842735, 0.0078093801, 0.0078345016, 0.0078596687, 0.007884929, 0.0079102041, 0.0079354942, 0.0079608615, 0.0079862745, 0.0080117183, 0.0080372384, 0.0080627734, 0.0080883857, 0.0081140595, 0.0081397472, 0.0081654675, 0.0081912167, 0.0082170591, 0.0082429312, 0.0082688183, 0.0082947984, 0.0083208084, 0.0083468342, 0.0083729057, 0.0083990693, 0.008425233, 0.0084514739, 0.0084777437, 0.008504061, 0.0085304547, 0.0085568624, 0.0085833324, 0.0086098025, 0.0086363638, 0.0086630024, 0.0086896252, 0.0087163243, 0.0087430403, 0.0087698167, 0.0087966388, 0.0088235065, 0.0088504059, 0.0088773808, 0.0089043872, 0.0089314235, 0.0089585371, 0.0089856805, 0.0090128398, 0.0090400912, 0.0090673575, 0.0090947002, 0.0091220438, 0.0091494787, 0.0091769444, 0.0092044557, 0.0092320126, 0.009259616, 0.0092872512, 0.0093149301, 0.0093426714, 0.0093704434, 0.009398276, 0.0094261402, 0.0094540352, 0.0094820065, 0.0095100235, 0.0095380396, 0.0095661636, 0.0095943036, 0.0096225049, 0.0096507361, 0.0096790139, 0.0097073521, 0.0097356914, 0.0097641377, 0.0097926138, 0.0098211057, 0.009849689, 0.0098782722, 0.0099069029, 0.0099356091, 0.0099643311, 0.0099930828, 0.010021927, 0.010050787, 0.010079708, 0.010108691, 0.010137702, 0.010166762, 0.010195835, 0.010225002, 0.010254197, 0.010283395, 0.010312699, 0.010342017, 0.010371396, 0.010400824, 0.010430296, 0.010459798, 0.010489363, 0.010518958, 0.010548598, 0.010578299, 0.010608032, 0.010637796, 0.010667635, 0.010697507, 0.010727438, 0.010757402, 0.010787425, 0.010817464, 0.010847563, 0.010877709, 0.010907916, 0.01093811, 0.010968425, 0.010998755, 0.0110291, 0.011059583, 0.01109002, 0.011120519, 0.011151109, 0.011181699, 0.011212352, 0.011243034, 0.011273779, 0.011304582, 0.011335373, 0.01136627, 0.011397197, 0.011428138, 0.011459174, 0.011490209, 0.011521306, 0.011552478, 0.011583665, 0.011614898, 0.011646179, 0.01167755, 0.011708907, 0.011740325, 0.011771804, 0.01180333, 0.011834884, 0.01186647, 0.011898133, 0.011929812, 0.011961565, 0.011993351, 0.012025167, 0.012057059, 0.012088982, 0.012120921, 0.012152952, 0.012185012, 0.012217104, 0.012249272, 0.01228144, 0.012313686, 0.012345977, 0.012378343, 0.012410741, 0.01244314, 0.012475614, 0.01250815, 0.012540687, 0.012573282, 0.012605942, 0.01263863, 0.012671381, 0.012704163, 0.012736989, 0.012769893, 0.012802828, 0.012835762, 0.012868788, 0.012901859, 0.012934931, 0.012968111, 0.013001274, 0.013034545, 0.013067847, 0.013101179, 0.013134574, 0.013167997, 0.013201484, 0.013235, 0.013268531, 0.013302155, 0.013335809, 0.013369494, 0.013403239, 0.013437017, 0.013470839, 0.013504754, 0.013538683, 0.013572658, 0.013606651, 0.013640718, 0.013674846, 0.013708976, 0.013743198, 0.013777449, 0.013811745, 0.013846105, 0.013880479, 0.013914884, 0.013949364, 0.013983876, 0.014018419, 0.014053053, 0.014087703, 0.014122384, 0.014157156, 0.014191927, 0.014226777, 0.014261641, 0.014296567, 0.014331554, 0.014366556, 0.014401619, 0.014436759, 0.014471885, 0.014507086, 0.014542378, 0.014577656, 0.014613012, 0.014648382, 0.014683796, 0.014719289, 0.014754795, 0.01479035, 0.01482598, 0.014861627, 0.014897348, 0.014933069, 0.014968868, 0.015004714, 0.015040589, 0.015076525, 0.015112506, 0.01514849, 0.015184594, 0.015220699, 0.015256866, 0.015293078, 0.015329337, 0.01536561, 0.01540196, 0.015438342, 0.015474753, 0.01551124, 0.015547759, 0.015584338, 0.01562095, 0.015657606, 0.015694324, 0.015731057, 0.015767852, 0.015804708, 0.015841562, 0.01587851, 0.015915489, 0.015952496, 0.015989583, 0.01602673, 0.016063845, 0.016101068, 0.016139589, 0.016179571, 0.016219627, 0.016259715, 0.016299864, 0.01634006, 0.016380301, 0.016420571, 0.016460935, 0.016501283, 0.016541738, 0.016582239, 0.016622772, 0.016663318, 0.01670396, 0.016744599, 0.016785314, 0.016826076, 0.016866898, 0.016907798, 0.016948713, 0.016989658, 0.017030666, 0.017071718, 0.017112833, 0.017153962, 0.017195169, 0.017236419, 0.017277703, 0.017319016, 0.017360406, 0.017401857, 0.017443324, 0.017484866, 0.017526455, 0.017568059, 0.01760974, 0.017651467, 0.01769324, 0.017735105, 0.017776968, 0.017818864, 0.017860806, 0.017902823, 0.017944871, 0.017986966, 0.018029151, 0.018071324, 0.018113572, 0.018155895, 0.018198252, 0.018240605, 0.018283067, 0.01832556, 0.018368097, 0.018410683, 0.018453283, 0.018495943, 0.018538697, 0.01858145, 0.018624296, 0.018667186, 0.018710108, 0.018753061, 0.01879609, 0.018839149, 0.018882239, 0.018925421, 0.018968634, 0.019011848, 0.019055136, 0.019098502, 0.019141898, 0.019185325, 0.019228829, 0.019272393, 0.01931596, 0.0193596, 0.019403288, 0.019447021, 0.019490801, 0.019534627, 0.019578513, 0.019622415, 0.019666394, 0.019710403, 0.019754473, 0.019798605, 0.019842766, 0.019886976, 0.019931216, 0.019975547, 0.020019861, 0.020064287, 0.020108767, 0.020153221, 0.020197768, 0.020242358, 0.020286981, 0.020331679, 0.020376407, 0.0204212, 0.02046605, 0.020510947, 0.020555859, 0.020600837, 0.020645857, 0.020690953, 0.02073605, 0.020781206, 0.020826412, 0.02087166, 0.020916959, 0.020962344, 0.021007732, 0.021053197, 0.021098692, 0.021144234, 0.021189835, 0.021235483, 0.021281179, 0.021326918, 0.021372719, 0.021418568, 0.021464415, 0.021510353, 0.021556338, 0.021602372, 0.021648431, 0.021694588, 0.021740723, 0.021786954, 0.021833234, 0.021879537, 0.021925889, 0.021972319, 0.022018762, 0.022065271, 0.022111807, 0.022158407, 0.022205049, 0.022251757, 0.022298478, 0.022345256, 0.022392131, 0.02243905, 0.02248597, 0.022532966, 0.022579992, 0.022627052, 0.022674186, 0.022721367, 0.022768561, 0.02281585, 0.02286315, 0.02291053, 0.022957942, 0.023005411, 0.023052912, 0.023100464, 0.023148071, 0.023195725, 0.023243427, 0.023291187, 0.023338949, 0.023386775, 0.023434719, 0.023482651, 0.023530642, 0.023578679, 0.023626765, 0.023674877, 0.02372307, 0.023771308, 0.023819558, 0.023867872, 0.023916263, 0.023964684, 0.02401315, 0.02406165, 0.024110178, 0.024158813, 0.024207463, 0.024256175, 0.024304917, 0.024353722, 0.024402587, 0.024451494, 0.024500439, 0.024549443, 0.024598461, 0.024647553, 0.024696665, 0.024745852, 0.024795068, 0.024844376, 0.024893686, 0.024943072, 0.024992488, 0.025041968, 0.025091475, 0.02514106, 0.025190663, 0.02524031, 0.025290031, 0.025339754, 0.025389599, 0.02543943, 0.025489353, 0.025539288, 0.025589287, 0.025639333, 0.025689423, 0.025739575, 0.025789756, 0.025839984, 0.025890274, 0.025940627, 0.025990974, 0.026041405, 0.026091846, 0.026142396, 0.02619295, 0.02624356, 0.026294231, 0.026344934, 0.026395714, 0.026446542, 0.026497383, 0.026548317, 0.026599264, 0.026650257, 0.026701313, 0.026752384, 0.026803518, 0.026854709, 0.026905963, 0.026957236, 0.02700858, 0.027059989, 0.027111411, 0.027162867, 0.027214397, 0.027265988, 0.027317578, 0.027369263, 0.027420979, 0.02747274, 0.027524542, 0.027576398, 0.027628325, 0.027680283, 0.027732307, 0.02778434, 0.027836438, 0.027888613, 0.027940786, 0.027993053, 0.028045349, 0.028097643, 0.028150065, 0.028202483, 0.028254962, 0.028307473, 0.028360046, 0.028412696, 0.028465359, 0.028518068, 0.028570857, 0.02862367, 0.028676519, 0.028729444, 0.028782431, 0.028835462, 0.028888494, 0.028941557, 0.028994726, 0.029047957, 0.029101171, 0.02915448, 0.029207816, 0.02926123, 0.029314645, 0.029368136, 0.029421689, 0.029475255, 0.029528903, 0.029582547, 0.029636297, 0.029690035, 0.029743878, 0.02979772, 0.029851671, 0.029905653, 0.029959634, 0.030013723, 0.030067841, 0.030121977, 0.030176204, 0.030230461, 0.03028472, 0.030339083, 0.030393461, 0.030447919, 0.03050239, 0.030556936, 0.030611532, 0.030666141, 0.030720828, 0.030775575, 0.030830352, 0.03088516, 0.030940061, 0.030994976, 0.031049954, 0.031104976, 0.031160031, 0.031215144, 0.031270307, 0.03132553, 0.03138075, 0.031436078, 0.031491425, 0.031546816, 0.031602267, 0.031657767, 0.031713296, 0.031768881, 0.031824522, 0.031880233, 0.03193593, 0.03199172, 0.032047536, 0.032103434, 0.032159362, 0.032215334, 0.032271381, 0.032327447, 0.032383572, 0.032439731, 0.032495935, 0.032552183, 0.032608505, 0.032664828, 0.032721233, 0.032777697, 0.032834191, 0.032890759, 0.032947347, 0.033003975, 0.033060666, 0.033117395, 0.033174194, 0.033231054, 0.033287901, 0.033344883, 0.033401821, 0.033458866, 0.033515926, 0.033573046, 0.033630215, 0.033687428, 0.033744704, 0.03380201, 0.033859361, 0.033916775, 0.033974245, 0.034031752, 0.034089301, 0.034146868, 0.034204528, 0.034262199, 0.034319963, 0.034377743, 0.03443557, 0.034493472, 0.034551423, 0.034609418, 0.03466744, 0.034725543, 0.034783646, 0.034841828, 0.034900032, 0.034958307, 0.035016593, 0.035074968, 0.035133392, 0.03519183, 0.035250362, 0.03530889, 0.0353675, 0.03542617, 0.035484854, 0.035543598, 0.035602387, 0.035661258, 0.03572014, 0.035779051, 0.035838075, 0.035897098, 0.035956178, 0.036015321, 0.036074482, 0.036133703, 0.036192998, 0.036252294, 0.036311667, 0.036371101, 0.036430538, 0.036490049, 0.036549605, 0.036609206, 0.036668889, 0.036728602, 0.036788326, 0.036848128, 0.036907978, 0.03696787, 0.037027795, 0.037087839, 0.037147857, 0.037207965, 0.037268061, 0.037328262, 0.037388477, 0.037448771, 0.037509091, 0.037569448, 0.037629861, 0.037690338, 0.037750844, 0.037811432, 0.037872043, 0.037932687, 0.037993394, 0.038054146, 0.038114961, 0.038175788, 0.038236707, 0.038297646, 0.03835867, 0.038419701, 0.038480803, 0.038541909, 0.038603105, 0.038664363, 0.038725618, 0.03878697, 0.038848318, 0.03890973, 0.03897123, 0.03903275, 0.039094329, 0.039155923, 0.039217595, 0.039279297, 0.039341044, 0.039402854, 0.039464723, 0.039526623, 0.039588556, 0.039650578, 0.03971263, 0.039774731, 0.039836884, 0.03989904, 0.039961293, 0.040023595, 0.040085908, 0.040148266, 0.04021072, 0.040273201, 0.040335704, 0.040398292, 0.040460911, 0.040523581, 0.040586278, 0.040649049, 0.040711854, 0.040774722, 0.040837653, 0.040900573, 0.040963609, 0.04102667, 0.041089755, 0.041152898, 0.041216083, 0.04127932, 0.041342627, 0.04140595, 0.041469354, 0.041532774, 0.041596267, 0.041659776, 0.041723348, 0.04178698, 0.04185066, 0.041914348, 0.041978121, 0.04204195, 0.042107072, 0.042173363, 0.042239647, 0.042305961, 0.042372335, 0.042438701, 0.042505112, 0.042571582, 0.042638045, 0.042704549, 0.042771079, 0.042837653, 0.042904258, 0.04297084, 0.04303753, 0.043104213, 0.043170922, 0.043237649, 0.043304432, 0.04337123, 0.043438055, 0.043504935, 0.043571811, 0.043638725, 0.043705683, 0.043772649, 0.043839682, 0.04390673, 0.0439738, 0.044040885, 0.044108011, 0.044175185, 0.044242375, 0.044309579, 0.044376858, 0.044444114, 0.044511415, 0.044578765, 0.044646122, 0.04471352, 0.04478097, 0.044848386, 0.044915915, 0.044983417, 0.045050956, 0.045118555, 0.04518614, 0.04525381, 0.045321442, 0.045389149, 0.045456886, 0.045524612, 0.045592435, 0.045660235, 0.045728069, 0.045795955, 0.045863863, 0.045931794, 0.04599975, 0.046067759, 0.046135772, 0.046203829, 0.046271905, 0.046340022, 0.04640818, 0.046476346, 0.046544556, 0.046612773, 0.046681043, 0.046749346, 0.046817664, 0.046885997, 0.046954382, 0.047022808, 0.047091227, 0.047159739, 0.047228206, 0.047296736, 0.047365308, 0.047433872, 0.047502503, 0.047571179, 0.047639836, 0.047708567, 0.047777288, 0.047846071, 0.04791484, 0.047983691, 0.048052564, 0.04812143, 0.048190355, 0.048259292, 0.048328266, 0.048397291, 0.048466325, 0.048535392, 0.048604492, 0.048673622, 0.048742753, 0.048811957, 0.048881169, 0.048950419, 0.049019706, 0.049089003, 0.049158346, 0.0492277, 0.049297098, 0.049366523, 0.049435969, 0.049505468, 0.049574979, 0.049644522, 0.049714074, 0.049783703, 0.049853321, 0.049922977, 0.049992688, 0.050062414, 0.05013217, 0.050201956, 0.050271742, 0.050341584, 0.050411481, 0.050481383, 0.050551306, 0.050621275, 0.050691243, 0.050761268, 0.050831333, 0.050901417, 0.050971512, 0.051041644, 0.05111184, 0.051182013, 0.051252231, 0.05132252, 0.051392797, 0.05146312, 0.051533472, 0.051603843, 0.051674247, 0.051744677, 0.051815178, 0.051885664, 0.051956184, 0.052026756, 0.052097335, 0.052167963, 0.052238602, 0.052309271, 0.052379988, 0.052450728, 0.052521467, 0.052592266, 0.052663114, 0.052733943, 0.052804846, 0.052875765, 0.052946698, 0.053017668, 0.053088687, 0.053159725, 0.053230777, 0.053301886, 0.053373009, 0.053444158, 0.05351533, 0.05358655, 0.053657785, 0.053729057, 0.053800363, 0.053871684, 0.053943072, 0.054014456, 0.054085854, 0.054157306, 0.054228805, 0.054300308, 0.054371864, 0.054443441, 0.054515034, 0.054586641, 0.054658312, 0.054730013, 0.054801736, 0.054873489, 0.054945253, 0.055017058, 0.055088889, 0.05516078, 0.055232652, 0.055304602, 0.055376567, 0.055448532, 0.055520557, 0.055592604, 0.055664673, 0.055736799, 0.055808924, 0.055881094, 0.055953298, 0.056025524, 0.056097791, 0.056170061, 0.056242391, 0.056314744, 0.056387108, 0.056459505, 0.056531943, 0.0566044, 0.056676898, 0.056749426, 0.056821976, 0.056894567, 0.056967188, 0.057039797, 0.057112489, 0.057185195, 0.057257954, 0.057330694, 0.057403494, 0.057476312, 0.057549141, 0.057622042, 0.057694964, 0.057767894, 0.057840887, 0.05791387, 0.057986908, 0.058059942, 0.058133069, 0.05820616, 0.058279339, 0.058352515, 0.058425695, 0.058498941, 0.058572225, 0.058645535, 0.058718834, 0.0587922, 0.058865614, 0.058939017, 0.059012454, 0.05908595, 0.059159432, 0.059232995, 0.059306569, 0.059380148, 0.059453778, 0.059527438, 0.059601106, 0.059674844, 0.05974859, 0.059822362, 0.05989616, 0.059970003, 0.060043864, 0.060117759, 0.060191698, 0.060265645, 0.060339626, 0.060413644, 0.060487684, 0.060561761, 0.06063588, 0.060709994, 0.060784169, 0.060858369, 0.060932595, 0.061006825, 0.061081111, 0.061155435, 0.061229754, 0.061304159, 0.06137855, 0.06145297, 0.061527431, 0.061601929, 0.061676458, 0.061750993, 0.061825577, 0.061900202, 0.061974827, 0.062049489, 0.062124211, 0.062198911, 0.062273707, 0.062348507, 0.062423289, 0.062498137, 0.062573023, 0.062647931, 0.062722884, 0.062797852, 0.062872857, 0.062947869, 0.063022934, 0.063098043, 0.063173115, 0.063248292, 0.063323461, 0.063398667, 0.063473925, 0.063549183, 0.063624464, 0.063699782, 0.063775152, 0.063850537, 0.063925952, 0.064001396, 0.064076863, 0.064152345, 0.064227909, 0.064303488, 0.064379074, 0.064454697, 0.064530343, 0.064606026, 0.064681746, 0.064757489, 0.064833261, 0.064909063, 0.064984918, 0.06506075, 0.065136626, 0.06521257, 0.065288514, 0.06536451, 0.065440528, 0.065516539, 0.065592632, 0.065668732, 0.065744877, 0.065820999, 0.065897211, 0.065973446, 0.066049673, 0.066125952, 0.066202268, 0.066278599, 0.066354983, 0.066431381, 0.066507794, 0.066584282, 0.066660747, 0.066737264, 0.066813812, 0.066890381, 0.066966996, 0.06704364, 0.067120306, 0.067197017, 0.067273706, 0.067350499, 0.067427278, 0.067504078, 0.067580938, 0.067657799, 0.067734696, 0.067811646, 0.06788861, 0.067965612, 0.068042628, 0.06811972, 0.068196766, 0.06827388, 0.068351038, 0.068428189, 0.068505421, 0.068582669, 0.068659909, 0.068737201, 0.068814524, 0.068891875, 0.06896925, 0.069046676, 0.069124117, 0.069201574, 0.069279067, 0.069356613, 0.069434173, 0.069511764, 0.069589406, 0.069667034, 0.069744736, 0.069822423, 0.06990017, 0.069977939, 0.070055738, 0.070133582, 0.070211433, 0.070289306, 0.070367232, 0.070445195, 0.07052318, 0.070601173, 0.07067921, 0.0707573, 0.070835382, 0.070913509, 0.070991658, 0.071069844, 0.071148075, 0.071226306, 0.071304612, 0.07138288, 0.071461216, 0.071539603, 0.071617998, 0.071696408, 0.071774885, 0.071853377, 0.071931869, 0.072010413, 0.072088994, 0.072167598, 0.072246231, 0.072324902, 0.072403595, 0.072482295, 0.07256107, 0.072639845, 0.072718665, 0.072797514, 0.072876386, 0.072955288, 0.073034212, 0.073113173, 0.073192157, 0.073271185, 0.073350236, 0.073429331, 0.073508419, 0.073587559, 0.073666744, 0.073745951, 0.073825166, 0.07390444, 0.073983729, 0.074063048, 0.074142389, 0.07422176, 0.074301183, 0.074380621, 0.074460089, 0.074539587, 0.074619107, 0.074698664, 0.074778274, 0.074857876, 0.07493753, 0.075017214, 0.075096913, 0.075176634, 0.075256415, 0.075336196, 0.075416036, 0.075495884, 0.075575799, 0.075655699, 0.075735629, 0.075815611, 0.07589563, 0.075975642, 0.076055735, 0.076135822, 0.076215945, 0.076296091, 0.076376267, 0.076456487, 0.07653673, 0.076616995, 0.076697327, 0.07677763, 0.076858006, 0.076938391, 0.07701882, 0.077099279, 0.077179752, 0.077260263, 0.077340804, 0.077421367, 0.07750199, 0.077582613, 0.077663273, 0.077743955, 0.077824697, 0.077905431, 0.077986211, 0.078067027, 0.078147858, 0.078228734, 0.078309648, 0.078390561, 0.078471519, 0.078552499, 0.078633532, 0.078714579, 0.078795657, 0.078876786, 0.078959309, 0.079043537, 0.079127759, 0.079211965, 0.079296172, 0.079380378, 0.079464555, 0.079548724, 0.079632886, 0.079717025, 0.079801179, 0.079885311, 0.079969421, 0.080053531, 0.08013764, 0.080221727, 0.0803058, 0.080389872, 0.080473945, 0.08055798, 0.080642015, 0.080726065, 0.080810085, 0.08089409, 0.080978073, 0.081062071, 0.081146061, 0.081230029, 0.081313983, 0.081397928, 0.081481867, 0.081565782, 0.081649728, 0.081733614, 0.08181753, 0.081901409, 0.081985295, 0.082069159, 0.082153015, 0.082236849, 0.082320705, 0.082404532, 0.082488328, 0.082572155, 0.082655951, 0.082739741, 0.082823515, 0.082907267, 0.082991041, 0.083074786, 0.083158523, 0.083242252, 0.083325952, 0.083409674, 0.083493374, 0.083577044, 0.083660722, 0.083744384, 0.083828039, 0.083911695, 0.083995327, 0.084078945, 0.084162563, 0.084246159, 0.084329769, 0.084413342, 0.084496923, 0.084580503, 0.084664039, 0.084747568, 0.084831119, 0.084914647, 0.084998153, 0.085081667, 0.085165143, 0.085248649, 0.085332118, 0.085415564, 0.085499033, 0.085582457, 0.085665897, 0.085749328, 0.085832745, 0.085916147, 0.085999526, 0.086082913, 0.086166292, 0.086249642, 0.086332999, 0.086416341, 0.086499676, 0.086583003, 0.086666316, 0.086749613, 0.086832911, 0.086916186, 0.086999439, 0.087082714, 0.087165944, 0.08724919, 0.087332442, 0.087415643, 0.087498866, 0.087582067, 0.087665252, 0.087748438, 0.087831594, 0.087914757, 0.087997906, 0.088081047, 0.088164188, 0.088247299, 0.088330403, 0.088413507, 0.088496603, 0.088579662, 0.088662736, 0.088745795, 0.088828847, 0.088911876, 0.088994905, 0.089077942, 0.089160942, 0.089243948, 0.089326918, 0.089409895, 0.089492872, 0.089575827, 0.089658767, 0.089741722, 0.089824639, 0.089907557, 0.089990474, 0.090073355, 0.090156242, 0.090239115, 0.090321988, 0.090404831, 0.090487696, 0.090570524, 0.090653367, 0.090736166, 0.090818964, 0.09090177, 0.090984553, 0.091067322, 0.091150075, 0.091232836, 0.09131559, 0.091398321, 0.091481052, 0.091563761, 0.091646463, 0.091729164, 0.091811851, 0.091894515, 0.091977179, 0.092059828, 0.092142478, 0.092225119, 0.092307732, 0.092390351, 0.092472963, 0.092555545, 0.09263812, 0.092720695, 0.092803255, 0.092885815, 0.092968352, 0.093050882, 0.093133412, 0.093215927, 0.09329842, 0.093380898, 0.093463391, 0.093545869, 0.093628332, 0.093710773, 0.093793221, 0.093875647, 0.093958065, 0.094040483, 0.094122872, 0.09420526, 0.094287656, 0.094370015, 0.094452389, 0.094534725, 0.094617069, 0.094699405, 0.094781734, 0.094864026, 0.09494634, 0.095028609, 0.095110908, 0.095193177, 0.095275417, 0.095357686, 0.095439911, 0.09552215, 0.095604368, 0.095686562, 0.095768765, 0.095850959, 0.095933132, 0.096015304, 0.096097469, 0.096179612, 0.096261755, 0.096343867, 0.09642598, 0.096508093, 0.096590191, 0.096672282, 0.096754357, 0.096836418, 0.096918486, 0.097000539, 0.097082548, 0.097164586, 0.09724661, 0.097328603, 0.097410612, 0.097492583, 0.097574577, 0.097656526, 0.09773849, 0.097820431, 0.097902365, 0.097984292, 0.098066218, 0.098148115, 0.098229989, 0.098311886, 0.098393768, 0.098475635, 0.09855748, 0.098639324, 0.098721161, 0.098802984, 0.098884806, 0.098966606, 0.099048391, 0.099130183, 0.099211954, 0.099293709, 0.099375471, 0.099457212, 0.099538937, 0.099620678, 0.099702366, 0.099784076, 0.099865764, 0.099947453, 0.10002912, 0.10011079, 0.10019244, 0.10027409, 0.10035571, 0.10043732, 0.10051895, 0.10060054, 0.10068214, 0.10076372, 0.10084528, 0.10092685, 0.1010084, 0.10108995, 0.10117147, 0.10125299, 0.1013345, 0.10141601, 0.10149749, 0.10157897, 0.10166045, 0.1017419, 0.10182335, 0.10190478, 0.10198622, 0.10206764, 0.10214905, 0.10223044, 0.10231183, 0.1023932, 0.10247459, 0.10255594, 0.10263728, 0.10271862, 0.10279994, 0.10288126, 0.10296258, 0.10304388, 0.10312516, 0.10320644, 0.1032877, 0.10336896, 0.10345022, 0.10353145, 0.10361268, 0.10369388, 0.1037751, 0.1038563, 0.10393747, 0.10401866, 0.10409982, 0.10418098, 0.10426212, 0.10434326, 0.10442437, 0.10450549, 0.1045866, 0.10466771, 0.10474879, 0.10482986, 0.10491092, 0.10499197, 0.10507302, 0.10515407, 0.10523508, 0.10531611, 0.1053971, 0.10547809, 0.10555907, 0.10564005, 0.10572101, 0.10580198, 0.10588291, 0.10596385, 0.10604477, 0.10612569, 0.1062066, 0.10628748, 0.10636836, 0.10644924, 0.10653009, 0.10661094, 0.10669179, 0.10677262, 0.10685345, 0.10693427, 0.10701505, 0.10709585, 0.10717663, 0.10725739, 0.10733817, 0.10741892, 0.10749964, 0.10758038, 0.10766111, 0.10774183, 0.10782252, 0.1079032, 0.10798389, 0.10806456, 0.10814521, 0.10822587, 0.10830651, 0.10838714, 0.10846775, 0.10854837, 0.10862897, 0.10870957, 0.10879014, 0.1088707, 0.10895126, 0.1090318, 0.10911235, 0.10919286, 0.1092734, 0.10935389, 0.10943439, 0.1095149, 0.10959537, 0.10967582, 0.10975629, 0.10983674, 0.10991718, 0.1099976, 0.11007802, 0.11015843, 0.11023883, 0.11031919, 0.1103996, 0.11047995, 0.11056031, 0.11064065, 0.11072099, 0.11080132, 0.11088163, 0.11096194, 0.11104224, 0.11112252, 0.11120279, 0.11128307, 0.11136331, 0.11144356, 0.1115238, 0.11160403, 0.11168425, 0.11176444, 0.11184464, 0.11192483, 0.112005, 0.11208514, 0.11216532, 0.11224546, 0.11232559, 0.11240572, 0.11248583, 0.11256593, 0.11264603, 0.11272611, 0.11280619, 0.11288625, 0.11296631, 0.11304635, 0.11312637, 0.1132064, 0.11328641, 0.11336641, 0.11344641, 0.11352638, 0.11360635, 0.11368632, 0.11376627, 0.11384621, 0.11392614, 0.11400606, 0.11408598, 0.11416589, 0.11424576, 0.11432564, 0.11440552, 0.11448538, 0.11456523, 0.11464506, 0.1147249, 0.11480473, 0.11488453, 0.11496433, 0.1150441, 0.1151239, 0.11520367, 0.11528341, 0.11536317, 0.11544292, 0.11552264, 0.11560237, 0.11568207, 0.11576176, 0.11584146, 0.11592112, 0.11600081, 0.11608046, 0.1161601, 0.11623975, 0.11631937, 0.11639899, 0.1164786, 0.11655819, 0.11663778, 0.11671738, 0.11679693, 0.11687649, 0.11695603, 0.11703558, 0.11711511, 0.11719462, 0.11727411, 0.11735363, 0.1174331, 0.11751258, 0.11759204, 0.1176715, 0.11775097, 0.11783038, 0.1179098, 0.11798922, 0.11806864, 0.11814801, 0.11822741, 0.11830678, 0.11838616, 0.1184655, 0.11854484, 0.11862419, 0.11870351, 0.11878281, 0.11886213, 0.11894141, 0.11902071, 0.11909997, 0.11917924, 0.11925849, 0.11933773, 0.11941697, 0.1194962, 0.1195754, 0.1196546, 0.1197338, 0.11981217, 0.11988975, 0.11996727, 0.12004475, 0.12012217, 0.12019952, 0.12027682, 0.12035406, 0.12043124, 0.12050837, 0.12058546, 0.12066246, 0.12073944, 0.12081634, 0.12089319, 0.12097, 0.12104672, 0.1211234, 0.12120002, 0.1212766, 0.1213531, 0.12142957, 0.12150596, 0.12158231, 0.12165859, 0.12173481, 0.121811, 0.1218871, 0.12196317, 0.12203918, 0.12211513, 0.12219103, 0.12226687, 0.12234263, 0.12241837, 0.12249403, 0.12256964, 0.12264521, 0.1227207, 0.12279616, 0.12287153, 0.12294686, 0.12302215, 0.12309735, 0.12317251, 0.12324762, 0.12332267, 0.12339766, 0.1234726, 0.12354748, 0.12362231, 0.12369708, 0.12377179, 0.12384644, 0.12392104, 0.12399559, 0.12407006, 0.12414449, 0.12421887, 0.12429319, 0.12436744, 0.12444165, 0.12451579, 0.12458989, 0.12466393, 0.1247379, 0.12481183, 0.1248857, 0.1249595, 0.12503326, 0.12510696, 0.1251806, 0.12525418, 0.12532772, 0.12540118, 0.1254746, 0.12554796, 0.12562127, 0.12569453, 0.12576771, 0.12584084, 0.12591393, 0.12598695, 0.12605992, 0.12613282, 0.12620567, 0.12627847, 0.12635122, 0.12642391, 0.12649654, 0.12656911, 0.12664162, 0.12671408, 0.12678649, 0.12685883, 0.1269311, 0.12700337, 0.12707552, 0.12714766, 0.12721972, 0.12729174, 0.1273637, 0.12743559, 0.12750743, 0.1275792, 0.12765095, 0.12772261, 0.12779422, 0.12786579, 0.12793729, 0.12800874, 0.12808011, 0.12815146, 0.12822275, 0.12829395, 0.12836513, 0.12843624, 0.12850729, 0.12857829, 0.12864923, 0.12872012, 0.12879094, 0.1288617, 0.12893242, 0.12900308, 0.12907368, 0.12914424, 0.12921472, 0.12928516, 0.12935553, 0.12942585, 0.12949611, 0.12956633, 0.12963647, 0.12970658, 0.12977661, 0.1298466, 0.12991652, 0.12998641, 0.1300562, 0.13012595, 0.13019568, 0.13026533, 0.1303349, 0.13040443, 0.13047393, 0.13054334, 0.1306127, 0.13068202, 0.13075128, 0.13082047, 0.13088959, 0.13095868, 0.13102771, 0.13109668, 0.13116558, 0.13123445, 0.13130325, 0.131372, 0.1314407, 0.1315093, 0.13157789, 0.13164642, 0.13171488, 0.13178328, 0.13185164, 0.13191992, 0.13198818, 0.13205634, 0.13212447, 0.13219255, 0.13226055, 0.13232853, 0.13239641, 0.13246426, 0.13253206, 0.13259979, 0.13266745, 0.13273509, 0.13280265, 0.13287015, 0.13293761, 0.13300499, 0.13307235, 0.13313961, 0.13320684, 0.133274, 0.13334113, 0.13340817, 0.13347518, 0.13354212, 0.13360903, 0.13367584, 0.13374262, 0.13380936, 0.133876, 0.13394262, 0.13400917, 0.13407567, 0.13414209, 0.13420847, 0.1342748, 0.13434106, 0.13440727, 0.13447344, 0.13453953, 0.13460559, 0.13467157, 0.13473751, 0.13480337, 0.1348692, 0.13493495, 0.13500066, 0.13506632, 0.1351319, 0.13519743, 0.13526292, 0.13532835, 0.13539371, 0.13545902, 0.13552429, 0.1355895, 0.13565463, 0.13571972, 0.13578475, 0.13584971, 0.13591464, 0.1359795, 0.13604431, 0.13610905, 0.13617375, 0.13623838, 0.13630296, 0.1363675, 0.13643195, 0.13649637, 0.13656072, 0.13662502, 0.13668928, 0.13675347, 0.13681759, 0.13688165, 0.13694566, 0.13700964, 0.13707355, 0.13713738, 0.13720118, 0.13726492, 0.13732859, 0.13739222, 0.13745578, 0.1375193, 0.13758276, 0.13764614, 0.1377095, 0.1377728, 0.13783599, 0.13789919, 0.1379623, 0.13802537, 0.13808836, 0.1381513, 0.13821422, 0.13827704, 0.1383398, 0.13840254, 0.13846521, 0.13852784, 0.13859038, 0.13865286, 0.13871533, 0.1387777, 0.13884003, 0.13890229, 0.13896452, 0.13902669, 0.13908878, 0.13915083, 0.13921283, 0.13927476, 0.13933662, 0.13939846, 0.13946024, 0.13952193, 0.13958357, 0.13964517, 0.13970673, 0.1397682, 0.13982965, 0.13989101, 0.13995233, 0.14001359, 0.1400748, 0.14013594, 0.14019702, 0.14025806, 0.14031903, 0.14037995, 0.14044084, 0.14050163, 0.1405624, 0.14062309, 0.14068373, 0.14074431, 0.14080486, 0.14086533, 0.14092572, 0.14098608, 0.1410464, 0.14110664, 0.14116684, 0.14122696, 0.14128704, 0.14134707, 0.14140701, 0.14146693, 0.1415268, 0.14158659, 0.14164633, 0.14170602, 0.14176562, 0.1418252, 0.14188471, 0.14194418, 0.1420036, 0.14206293, 0.14212222, 0.14218146, 0.14224063, 0.14229974, 0.14235881, 0.14241782, 0.14247678, 0.14253567, 0.1425945, 0.1426533, 0.14271203, 0.14277069, 0.14282931, 0.14288788, 0.14294636, 0.14300482, 0.1430632, 0.14312153, 0.14317982, 0.14323802, 0.14329621, 0.14335431, 0.14341235, 0.14347036, 0.14352828, 0.14358617, 0.14364401, 0.14370176, 0.14375949, 0.14381714, 0.14387475, 0.1439323, 0.14398979, 0.1440472, 0.14410459, 0.14416191, 0.14421917, 0.14427638, 0.14433354, 0.14439063, 0.14444765, 0.14450465, 0.14456157, 0.14461844, 0.14467525, 0.14473203, 0.14478871, 0.14484537, 0.14490195, 0.14495848, 0.14501496, 0.14507137, 0.14512774, 0.14518404, 0.14524031, 0.14529648, 0.14535263, 0.1454087, 0.14546472, 0.1455207, 0.14557661, 0.14563248, 0.14568828, 0.14574401, 0.14579971, 0.14585532, 0.14591092, 0.14596643, 0.14602189, 0.14607731, 0.14613265, 0.14618795, 0.14624317, 0.14629836, 0.1463535, 0.14640854, 0.14646356, 0.14651851, 0.14657342, 0.14662826, 0.14668305, 0.14673778, 0.14679246, 0.14684707, 0.14690164, 0.14695615, 0.14701059, 0.14706498, 0.14711933, 0.14717361, 0.14722784, 0.147282, 0.14733611, 0.14739017, 0.14744416, 0.14749812, 0.147552, 0.14760582, 0.14765958, 0.14771332, 0.14776698, 0.14782059, 0.14787413, 0.14792764, 0.14798106, 0.14803445, 0.14808777, 0.14814103, 0.14819425, 0.14824741, 0.14830051, 0.14835353, 0.14840654, 0.14845946, 0.14851233, 0.14856516, 0.14861789, 0.14867061, 0.14872326, 0.14877585, 0.1488284, 0.14888088, 0.14893329, 0.14898567, 0.14903797, 0.14909022, 0.14914243, 0.14919457, 0.14924665, 0.14929868, 0.14935066, 0.14940259, 0.14945444, 0.14950624, 0.14955799, 0.14960968, 0.14966132, 0.14971291, 0.1497644, 0.14981589, 0.1498673, 0.14991865, 0.14996994, 0.1500212, 0.15007237, 0.15012351, 0.15017457, 0.15022558, 0.15027654, 0.15032746, 0.1503783, 0.1504291, 0.15047982, 0.1505305, 0.15058112, 0.1506317, 0.15068221, 0.15073267, 0.15078306, 0.1508334, 0.15088367, 0.15093391, 0.15098408, 0.15103419, 0.15108426, 0.15113425, 0.1511842, 0.15123411, 0.15128392, 0.1513337, 0.15138343, 0.15143311, 0.1514827, 0.15153225, 0.15157834, 0.15162081, 0.1516632, 0.15170552, 0.15174778, 0.15178996, 0.15183209, 0.15187414, 0.1519161, 0.15195802, 0.15199988, 0.15204164, 0.15208335, 0.152125, 0.15216656, 0.15220806, 0.1522495, 0.15229087, 0.15233217, 0.15237339, 0.15241455, 0.15245564, 0.15249667, 0.15253761, 0.15257852, 0.15261933, 0.15266007, 0.15270075, 0.15274137, 0.15278192, 0.15282239, 0.1528628, 0.15290314, 0.15294342, 0.15298362, 0.15302375, 0.15306382, 0.15310381, 0.15314375, 0.15318361, 0.1532234, 0.15326311, 0.15330279, 0.15334237, 0.15338188, 0.15342134, 0.15346073, 0.15350004, 0.15353927, 0.15357846, 0.15361758, 0.1536566, 0.15369558, 0.15373449, 0.15377331, 0.15381208, 0.15385078, 0.1538894, 0.15392797, 0.15396647, 0.15400489, 0.15404324, 0.15408152, 0.15411974, 0.15415789, 0.15419598, 0.15423401, 0.15427193, 0.15430982, 0.15434763, 0.15438537, 0.15442304, 0.15446064, 0.15449819, 0.15453565, 0.15457305, 0.15461038, 0.15464765, 0.15468484, 0.15472196, 0.15475902, 0.154796, 0.15483293, 0.15486978, 0.15490657, 0.15494329, 0.15497993, 0.15501651, 0.155053, 0.15508947, 0.15512583, 0.15516213, 0.15519835, 0.15523453, 0.15527064, 0.15530667, 0.15534262, 0.15537852, 0.15541434, 0.15545011, 0.15548579, 0.15552142, 0.15555696, 0.15559244, 0.15562786, 0.15566321, 0.15569849, 0.1557337, 0.15576884, 0.15580392, 0.15583892, 0.15587386, 0.15590873, 0.15594353, 0.15597826, 0.15601292, 0.15604751, 0.15608203, 0.15611649, 0.15615088, 0.15618519, 0.15621947, 0.15625365, 0.15628776, 0.15632181, 0.1563558, 0.15638971, 0.15642355, 0.15645732, 0.15649103, 0.15652467, 0.15655823, 0.15659173, 0.15662517, 0.15665853, 0.15669182, 0.15672505, 0.15675822, 0.1567913, 0.15682432, 0.15685728, 0.15689015, 0.15692297, 0.15695572, 0.1569884, 0.15702102, 0.15705355, 0.15708603, 0.15711842, 0.15715078, 0.15718304, 0.15721524, 0.15724738, 0.15727943, 0.15731144, 0.15734337, 0.15737522, 0.15740702, 0.15743874, 0.15747039, 0.15750197, 0.15753348, 0.15756494, 0.15759632, 0.15762763, 0.15765886, 0.15769005, 0.15772116, 0.1577522, 0.15778317, 0.15781407, 0.1578449, 0.15787567, 0.15790635, 0.15793701, 0.15796755, 0.15799806, 0.15802845, 0.15805881, 0.15808912, 0.15811931, 0.15814947, 0.15817955, 0.15820955, 0.1582395, 0.15826938, 0.15829919, 0.15832892, 0.15835859, 0.1583882, 0.15841773, 0.15844721, 0.15847661, 0.15850592, 0.15853518, 0.15856437, 0.15859349, 0.15862255, 0.15865153, 0.15868044, 0.15870932, 0.15873809, 0.15876681, 0.15879543, 0.15882401, 0.15885252, 0.15888098, 0.15890934, 0.15893763, 0.15896589, 0.15899405, 0.15902214, 0.15905018, 0.15907814, 0.15910603, 0.15913384, 0.15916161, 0.15918928, 0.15921691, 0.15924446, 0.15927194, 0.15929933, 0.15932669, 0.15935397, 0.15938117, 0.15940832, 0.15943539, 0.15946241, 0.15948932, 0.1595162, 0.15954299, 0.15956973, 0.15959638, 0.15962298, 0.15964951, 0.15967597, 0.15970235, 0.15972866, 0.15975492, 0.1597811, 0.15980721, 0.15983325, 0.15985923, 0.15988515, 0.15991099, 0.15993676, 0.15996245, 0.15998811, 0.16001366, 0.16003916, 0.16006459, 0.16008995, 0.16011523, 0.16014047, 0.16016562, 0.16019072, 0.16021574, 0.16024069, 0.16026558, 0.16029038, 0.16031514, 0.16033979, 0.16036442, 0.16038896, 0.16041343, 0.16043784, 0.16046216, 0.16048644, 0.16051061, 0.16053475, 0.16055882, 0.16058281, 0.16060676, 0.1606306, 0.16065438, 0.16067812, 0.16070177, 0.16072534, 0.16074885, 0.16077231, 0.16079567, 0.16081898, 0.16084224, 0.16086541, 0.16088851, 0.16091153, 0.16093452, 0.16095741, 0.16098024, 0.16100302, 0.16102572, 0.16104832, 0.1610709, 0.16109337, 0.16111581, 0.16113815, 0.16116042, 0.16118264, 0.1612048, 0.16122688, 0.16124888, 0.16127083, 0.16129269, 0.1613145, 0.16133624, 0.16135792, 0.1613795, 0.16140106, 0.16142251, 0.16144389, 0.16146523, 0.16148649, 0.16150768, 0.1615288, 0.16154985, 0.16157083, 0.16159175, 0.1616126, 0.16163337, 0.16165408, 0.16167472, 0.1616953, 0.16171582, 0.16173625, 0.1617566, 0.16177692, 0.16179715, 0.16181731, 0.16183741, 0.16185744, 0.16187739, 0.16189727, 0.16191711, 0.16193685, 0.16195655, 0.16197617, 0.16199571, 0.16201517, 0.16203459, 0.16205394, 0.16207321, 0.16209242, 0.16211155, 0.16213064, 0.16214962, 0.16216856, 0.16218744, 0.16220623, 0.16222496, 0.1622436, 0.1622622, 0.16228071, 0.16229917, 0.16231756, 0.16233587, 0.16235413, 0.16237231, 0.16239041, 0.16240847, 0.16242646, 0.16244435, 0.16246217, 0.16247995, 0.16249764, 0.1625153, 0.16253285, 0.16255035, 0.16256778, 0.16258514, 0.16260242, 0.16261965, 0.1626368, 0.16265389, 0.16267091, 0.16268787, 0.16270474, 0.16272154, 0.16273831, 0.16275497, 0.16277155, 0.16278814, 0.16280459, 0.16282099, 0.16283731, 0.16285358, 0.16286978, 0.16288592, 0.16290198, 0.16291797, 0.16293387, 0.16294976, 0.16296555, 0.16298124, 0.16299689, 0.16301247, 0.163028, 0.16304345, 0.16305882, 0.16307412, 0.16308935, 0.16310452, 0.16311963, 0.16313468, 0.16314963, 0.16316453, 0.16317935, 0.16319412, 0.16320881, 0.16322343, 0.163238, 0.1632525, 0.1632669, 0.16328125, 0.16329552, 0.16330974, 0.16332389, 0.16333796, 0.16335197, 0.16336592, 0.16337977, 0.16339359, 0.16340733, 0.16342098, 0.16343458, 0.16344811, 0.16346158, 0.16347498, 0.16348828, 0.16350155, 0.16351473, 0.16352786, 0.16354091, 0.16355389, 0.1635668, 0.16357967, 0.16359241, 0.16360512, 0.16361776, 0.16363037, 0.16364285, 0.16365528, 0.16366765, 0.16367996, 0.16369219, 0.16370434, 0.16371645, 0.16372848, 0.16374043, 0.16375232, 0.16376413, 0.16377589, 0.16378757, 0.1637992, 0.16381073, 0.16382219, 0.16383362, 0.16384496, 0.16385621, 0.16386743, 0.16387857, 0.16388962, 0.16390063, 0.16391157, 0.16392243, 0.16393323, 0.16394393, 0.16395459, 0.16396518, 0.1639757, 0.16398616, 0.16399655, 0.16400686, 0.1640171, 0.16402729, 0.16403741, 0.16404743, 0.1640574, 0.16406731, 0.16407713, 0.16408692, 0.16409662, 0.16410625, 0.1641158, 0.16412531, 0.16413474, 0.16414408, 0.16415338, 0.16416261, 0.16417174, 0.16418085, 0.16418985, 0.16419882, 0.16420767, 0.16421649, 0.16422522, 0.16423389, 0.16424252, 0.16425104, 0.16425951, 0.16426791, 0.164276, 0.16428366, 0.16429125, 0.16429882, 0.16430633, 0.16431376, 0.16432118, 0.16432852, 0.16433582, 0.16434309, 0.16435027, 0.16435744, 0.16436456, 0.16437161, 0.16437861, 0.16438556, 0.16439246, 0.16439931, 0.16440612, 0.16441286, 0.16441955, 0.16442621, 0.16443284, 0.16443938, 0.16444589, 0.16445234, 0.16445874, 0.16446508, 0.16447139, 0.16447763, 0.16448383, 0.16449, 0.16449609, 0.16450214, 0.16450813, 0.16451411, 0.16452, 0.16452584, 0.16453162, 0.1645374, 0.16454309, 0.16454874, 0.16455434, 0.16455989, 0.1645654, 0.16457084, 0.16457625, 0.16458158, 0.16458689, 0.16459213, 0.16459735, 0.16460249, 0.16460758, 0.16461264, 0.16461763, 0.16462259, 0.16462746, 0.16463232, 0.16463712, 0.16464189, 0.16464657, 0.16465123, 0.1646558, 0.16466036, 0.16466486, 0.16466931, 0.1646737, 0.16467805, 0.16468233, 0.16468661, 0.16469081, 0.16469492, 0.16469902, 0.16470306, 0.16470706, 0.16471101, 0.1647149, 0.16471875, 0.16472255, 0.16472629, 0.16473, 0.16473363, 0.16473722, 0.16474079, 0.16474426, 0.1647477, 0.16475111, 0.16475447, 0.16475776, 0.16476099, 0.16476418, 0.16476732, 0.16477042, 0.16477348, 0.16477646, 0.16477939, 0.16478229, 0.16478513, 0.16478793, 0.16479068, 0.16479337, 0.16479602, 0.1647986, 0.16480114, 0.16480362, 0.16480607, 0.16480847, 0.16481082, 0.16481309, 0.16481534, 0.16481753, 0.16481967, 0.16482177, 0.1648238, 0.1648258, 0.16482773, 0.16482963, 0.16483146, 0.16483326, 0.16483499, 0.1648367, 0.16483833, 0.16483991, 0.16484146, 0.16484295, 0.16484438, 0.16484578, 0.16484711, 0.16484839, 0.16484964, 0.16485083, 0.16485196, 0.16485304, 0.16485411, 0.16485509, 0.16485603, 0.1648569, 0.16485776, 0.16485853, 0.16485928, 0.16485997, 0.16486061, 0.16486117, 0.16486172, 0.16486222, 0.16486265, 0.16486304, 0.16486338, 0.16486366, 0.1648639, 0.16486409, 0.16486421, 0.1648643, 0.16486436, 0.16486432, 0.16486426, 0.16486412, 0.16486397, 0.16486377, 0.16486351, 0.16486318, 0.16486283, 0.16486241, 0.16486193, 0.16486143, 0.16486086, 0.16486025, 0.16485959, 0.16485888, 0.16485809, 0.16485728, 0.16485643, 0.16485551, 0.16485454, 0.16485351, 0.16485244, 0.16485134, 0.16485018, 0.16484895, 0.16484767, 0.16484636, 0.16484499, 0.16484359, 0.16484211, 0.16484059, 0.16483903, 0.16483742, 0.16483575, 0.16483401, 0.16483225, 0.16483043, 0.16482857, 0.16482665, 0.16482466, 0.16482267, 0.16482058, 0.16481847, 0.16481631, 0.16481407, 0.1648118, 0.1648095, 0.16480711, 0.16480468, 0.16480222, 0.16479969, 0.16479714, 0.1647945, 0.16479184, 0.16478913, 0.16478634, 0.16478354, 0.16478066, 0.16477776, 0.16477476, 0.16477174, 0.16476867, 0.16476557, 0.16476239, 0.16475916, 0.16475588, 0.16475257, 0.16474921, 0.16474578, 0.16474229, 0.16473877, 0.16473518, 0.16473159, 0.1647279, 0.16472417, 0.16472043, 0.1647166, 0.16471271, 0.16470878, 0.16470481, 0.16470079, 0.16469672, 0.16469258, 0.16468842, 0.16468418, 0.16467993, 0.16467559, 0.1646712, 0.16466677, 0.16466232, 0.1646578, 0.16465323, 0.16464859, 0.16464393, 0.16463919, 0.16463441, 0.16462958, 0.16462471, 0.16461979, 0.16461481, 0.16460977, 0.16460471, 0.16459958, 0.1645944, 0.16458917, 0.16458389, 0.16457859, 0.16457319, 0.16456775, 0.16456228, 0.16455674, 0.16455118, 0.16454555, 0.16453987, 0.16453417, 0.16452837, 0.16452254, 0.16451667, 0.16451074, 0.16450477, 0.16449873, 0.16449265, 0.16448653, 0.16448034, 0.16447411, 0.16446783, 0.16446149, 0.16445512, 0.16444869, 0.1644422, 0.16443567, 0.16442908, 0.16442247, 0.16441579, 0.16440906, 0.16440226, 0.16439545, 0.16438857, 0.16438164, 0.16437465, 0.1643676, 0.16436052, 0.1643534, 0.16434623, 0.16433901, 0.1643317, 0.16432437, 0.16431698, 0.16430956, 0.16430207, 0.16429454, 0.16428697, 0.16427933, 0.16427165, 0.16426392, 0.16425614, 0.1642483, 0.1642404, 0.16423249, 0.16422449, 0.16421644, 0.1642084, 0.16420026, 0.16419205, 0.16418384, 0.16417556, 0.16416721, 0.16415882, 0.16415039, 0.16414191, 0.16413336, 0.16412477, 0.16411614, 0.16410746, 0.16409872, 0.16408995, 0.16408111, 0.16407222, 0.16406329, 0.16405429, 0.16404524, 0.16403615, 0.16402702, 0.16401784, 0.16400862, 0.1639993, 0.16399001, 0.1639806, 0.16397116, 0.16396166, 0.16395213, 0.16394255, 0.1639329, 0.16392322, 0.16391349, 0.1639037, 0.16389386, 0.16388398, 0.16387403, 0.16386405, 0.163854, 0.16384391, 0.16383377, 0.16382359, 0.16381334, 0.16380306, 0.16379271, 0.16378231, 0.16377187, 0.16376139, 0.16375086, 0.16374026, 0.16372961, 0.16371894, 0.1637082, 0.16369741, 0.16368656, 0.16367565, 0.16366473, 0.16365375, 0.1636427, 0.16363162, 0.16362046, 0.16360927, 0.16359802, 0.16358674, 0.1635754, 0.163564, 0.16355255, 0.16354108, 0.16352953, 0.16351794, 0.1635063, 0.16349457, 0.16348284, 0.16347106, 0.16345921, 0.16344732, 0.16343537, 0.16342339, 0.16341133, 0.16339926, 0.1633871, 0.16337492, 0.16336268, 0.16335037, 0.16333805, 0.16332564, 0.16331318, 0.16330069, 0.16328813, 0.16327554, 0.1632629, 0.16325022, 0.16323747, 0.16322468, 0.16321182, 0.16319892, 0.16318598, 0.163173, 0.16315995, 0.16314684, 0.1631337, 0.16312048, 0.16310725, 0.16309397, 0.1630806, 0.16306721, 0.16305377, 0.16304027, 0.16302672, 0.16301313, 0.16299948, 0.16298577, 0.16297202, 0.16295822, 0.16294438, 0.16293047, 0.16291653, 0.16290255, 0.16288847, 0.1628744, 0.16286024, 0.16284601, 0.1628318, 0.16281749, 0.16280311, 0.16278873, 0.16277428, 0.1627598, 0.16274522, 0.16273062, 0.16271597, 0.16270128, 0.16268654, 0.16267173, 0.16265687, 0.16264197, 0.16262703, 0.16261204, 0.16259699, 0.16258189, 0.16256672, 0.16255152, 0.16253628, 0.16252097, 0.16250563, 0.1624902, 0.16247477, 0.16245925, 0.16244371, 0.1624281, 0.16241245, 0.16239676, 0.16238099, 0.1623652, 0.16234934, 0.16233343, 0.16231748, 0.16230148, 0.16228545, 0.16226932, 0.16225317, 0.16223697, 0.1622207, 0.1622044, 0.16218805, 0.16217165, 0.16215521, 0.16213869, 0.16212215, 0.16210553, 0.16208889, 0.16207215, 0.1620554, 0.16203859, 0.16202174, 0.16200484, 0.1619879, 0.16197088, 0.16195382, 0.1619367, 0.16191956, 0.16190235, 0.1618851, 0.16186778, 0.16185233, 0.16183873, 0.16182506, 0.1618114, 0.16179764, 0.16178384, 0.16177003, 0.16175614, 0.16174223, 0.16172826, 0.16171427, 0.16170019, 0.16168611, 0.16167197, 0.16165778, 0.16164355, 0.16162926, 0.16161494, 0.16160059, 0.1615862, 0.16157174, 0.16155721, 0.16154268, 0.16152811, 0.16151346, 0.16149879, 0.16148406, 0.16146931, 0.1614545, 0.16143964, 0.16142474, 0.1614098, 0.16139482, 0.1613798, 0.16136469, 0.16134959, 0.16133443, 0.16131921, 0.16130397, 0.16128866, 0.16127332, 0.16125792, 0.16124249, 0.161227, 0.16121149, 0.16119593, 0.16118032, 0.16116466, 0.16114895, 0.16113321, 0.16111743, 0.16110158, 0.16108572, 0.1610698, 0.16105384, 0.1610378, 0.16102175, 0.16100566, 0.16098951, 0.16097331, 0.16095708, 0.16094081, 0.16092449, 0.16090813, 0.16089171, 0.16087525, 0.16085875, 0.16084221, 0.16082561, 0.16080895, 0.16079231, 0.16077559, 0.16075881, 0.16074198, 0.16072515, 0.16070823, 0.16069129, 0.1606743, 0.16065727, 0.1606402, 0.16062304, 0.16060589, 0.16058868, 0.16057143, 0.16055411, 0.16053677, 0.16051938, 0.16050194, 0.16048445, 0.16046694, 0.16044936, 0.16043174, 0.1604141, 0.1603964, 0.16037865, 0.16036084, 0.16034301, 0.16032512, 0.1603072, 0.16028924, 0.16027121, 0.16025314, 0.16023506, 0.1602169, 0.1601987, 0.16018046, 0.16016218, 0.16014387, 0.16012548, 0.16010708, 0.16008861, 0.16007009, 0.16005155, 0.16003296, 0.16001432, 0.15999563, 0.15997691, 0.15995814, 0.15993933, 0.15992045, 0.15990157, 0.15988262, 0.15986362, 0.15984456, 0.15982547, 0.15980637, 0.15978719, 0.15976797, 0.15974872, 0.15972942, 0.15971003, 0.15969065, 0.15967122, 0.15965174, 0.15963221, 0.15961263, 0.15959302, 0.15957335, 0.15955363, 0.1595339, 0.15951408, 0.15949427, 0.15947436, 0.15945444, 0.15943448, 0.15941444, 0.15939437, 0.15937428, 0.15935412, 0.15933391, 0.15931369, 0.15929338, 0.15927307, 0.1592527, 0.15923229, 0.15921181, 0.15919131, 0.15917076, 0.15915014, 0.15912952, 0.15910882, 0.15908809, 0.15906732, 0.1590465, 0.15902562, 0.15900472, 0.15898375, 0.15896277, 0.15894172, 0.15892063, 0.15889952, 0.15887833, 0.15885711, 0.15883584, 0.15881453, 0.15879318, 0.15877178, 0.15875033, 0.15872885, 0.15870731, 0.15868574, 0.15866412, 0.15864244, 0.15862073, 0.15859897, 0.15857719, 0.15855534, 0.15853345, 0.15851152, 0.15848954, 0.15846752, 0.15844545, 0.15842335, 0.15840118, 0.15837899, 0.15835674, 0.15833445, 0.15831211, 0.15828973, 0.1582673, 0.15824483, 0.15822233, 0.15819977, 0.15817718, 0.15815453, 0.15813185, 0.15810911, 0.15808631, 0.1580635, 0.15804063, 0.15801772, 0.15799476, 0.15797177, 0.1579487, 0.15792564, 0.15790249, 0.15787931, 0.15785609, 0.15783282, 0.15780951, 0.15778613, 0.15776275, 0.1577393, 0.15771581, 0.15769225, 0.15766868, 0.15764506, 0.15762138, 0.15759769, 0.15757391, 0.15755011, 0.15752627, 0.15750237, 0.15747844, 0.15745446, 0.15743043, 0.15740636, 0.15738225, 0.15735808, 0.1573339, 0.15730964, 0.15728533, 0.157261, 0.15723661, 0.15721218, 0.15718772, 0.15716322, 0.15713863, 0.15711403, 0.1570894, 0.15706469, 0.15703996, 0.15701517, 0.15699033, 0.15696548, 0.15694055, 0.15691559, 0.15689059, 0.15686554, 0.15684044, 0.15681531, 0.15679012, 0.15676489, 0.15673962, 0.15671431, 0.15668896, 0.15666354, 0.15663809, 0.15661258, 0.15658705, 0.15656146, 0.15653583, 0.15651016, 0.15648445, 0.15645868, 0.15643288, 0.15640703, 0.15638113, 0.15635519, 0.1563292, 0.15630317, 0.15627709, 0.15625098, 0.15622482, 0.15619861, 0.15617236, 0.15614606, 0.15611972, 0.15609333, 0.15606691, 0.15604042, 0.15601392, 0.15598734, 0.15596074, 0.15593408, 0.15590738, 0.15588064, 0.15585385, 0.15582703, 0.15580015, 0.15577324, 0.15574627, 0.15571925, 0.1556922, 0.1556651, 0.15563795, 0.15561077, 0.15558355, 0.15555626, 0.15552895, 0.15550157, 0.15547417, 0.15544671, 0.15541922, 0.15539168, 0.1553641, 0.15533645, 0.15530877, 0.15528105, 0.15525329, 0.15522549, 0.15519762, 0.15516971, 0.15514177, 0.15511379, 0.15508574, 0.15505768, 0.15502955, 0.1550014, 0.15497318, 0.15494493, 0.15491661, 0.15488827, 0.15485989, 0.15483145, 0.15480298, 0.15477446, 0.15474589, 0.15471727, 0.15468861, 0.15465991, 0.15463117, 0.15460238, 0.15457354, 0.15454467, 0.15451573, 0.15448678, 0.15445776, 0.15442869, 0.1543996, 0.15437046, 0.15434127, 0.15431203, 0.15428273, 0.15425342, 0.15422405, 0.15419464, 0.15416518, 0.15413569, 0.15410614, 0.15407653, 0.15404691, 0.15401722, 0.1539875, 0.15395772, 0.15392791, 0.15389806, 0.15386815, 0.1538382, 0.15380822, 0.15377818, 0.1537481, 0.15371796, 0.1536878, 0.15365759, 0.15362732, 0.15359703, 0.15356667, 0.15353629, 0.15350583, 0.15347536, 0.15344484, 0.15341426, 0.15338366, 0.15335299, 0.15332228, 0.15329154, 0.15326074, 0.15322989, 0.15319902, 0.15316808, 0.15313712, 0.15310609, 0.15307504, 0.15304394, 0.15301278, 0.15298159, 0.15295036, 0.15291907, 0.15288773, 0.15285636, 0.15282495, 0.15279348, 0.15276198, 0.15273044, 0.15269884, 0.15266719, 0.15263551, 0.15260378, 0.15257201, 0.15254019, 0.15250833, 0.15247642, 0.15244447, 0.15241247, 0.15238042, 0.15234834, 0.15231623, 0.15228406, 0.15225182, 0.15221956, 0.15218726, 0.15215491, 0.15212251, 0.15209007, 0.15205759, 0.15202506, 0.15199247, 0.15195985, 0.1519272, 0.15189449, 0.15186173, 0.15182893, 0.15179609, 0.1517632, 0.15173028, 0.15169729, 0.15166429, 0.15163121, 0.15159811, 0.15156494, 0.15153176, 0.15149851, 0.15146522, 0.15143189, 0.15139851, 0.1513651, 0.15133163, 0.15129812, 0.15126456, 0.15123096, 0.15119733, 0.15116364, 0.1511299, 0.15109612, 0.15106231, 0.15102844, 0.15099452, 0.15096058, 0.15092658, 0.15089253, 0.15085845, 0.15082432, 0.15079014, 0.15075591, 0.15072164, 0.15068734, 0.15065297, 0.15061857, 0.15058413, 0.15054964, 0.15051511, 0.15048052, 0.15044591, 0.15041123, 0.15037653, 0.15034176, 0.15030697, 0.15027212, 0.15023723, 0.15020229, 0.15016732, 0.1501323, 0.15009722, 0.15006211, 0.15002696, 0.14999175, 0.14995651, 0.14992121, 0.14988589, 0.1498505, 0.14981508, 0.1497796, 0.14974409, 0.14970852, 0.14967294, 0.14963728, 0.14960161, 0.14956586, 0.14953007, 0.14949356, 0.14945638, 0.14941914, 0.14938185, 0.14934453, 0.14930713, 0.1492697, 0.14923222, 0.1491947, 0.14915712, 0.1491195, 0.14908183, 0.14904408, 0.14900632, 0.14896849, 0.14893062, 0.1488927, 0.14885473, 0.14881672, 0.14877866, 0.14874053, 0.14870237, 0.14866416, 0.14862591, 0.14858758, 0.14854923, 0.14851081, 0.14847235, 0.14843385, 0.14839529, 0.14835671, 0.14831804, 0.14827934, 0.1482406, 0.14820179, 0.14816295, 0.14812404, 0.14808509, 0.14804611, 0.14800707, 0.14796796, 0.14792883, 0.14788964, 0.14785039, 0.1478111, 0.14777178, 0.14773238, 0.14769295, 0.14765348, 0.14761394, 0.14757437, 0.14753473, 0.14749505, 0.14745532, 0.14741555, 0.14737572, 0.14733584, 0.14729592, 0.14725594, 0.14721593, 0.14717586, 0.14713573, 0.14709558, 0.14705534, 0.14701508, 0.14697477, 0.14693442, 0.14689401, 0.14685354, 0.14681304, 0.14677247, 0.14673187, 0.14669122, 0.14665051, 0.14660975, 0.14656895, 0.1465281, 0.14648719, 0.14644626, 0.14640526, 0.14636421, 0.14632311, 0.14628197, 0.14624077, 0.14619954, 0.14615825, 0.1461169, 0.14607552, 0.14603408, 0.14599259, 0.14595105, 0.14590947, 0.14586784, 0.14582616, 0.14578444, 0.14574265, 0.14570083, 0.14565894, 0.14561702, 0.14557505, 0.14553303, 0.14549094, 0.14544883, 0.14540665, 0.14536443, 0.14532217, 0.14527984, 0.14523748, 0.14519508, 0.1451526, 0.1451101, 0.14506754, 0.14502494, 0.14498228, 0.14493956, 0.14489681, 0.14485399, 0.14481114, 0.14476824, 0.14472529, 0.14468229, 0.14463924, 0.14459614, 0.14455299, 0.14450979, 0.14446655, 0.14442326, 0.14437991, 0.14433652, 0.14429308, 0.1442496, 0.14420606, 0.14416248, 0.14411885, 0.14407516, 0.14403142, 0.14398764, 0.1439438, 0.14389992, 0.14385599, 0.14381202, 0.143768, 0.14372392, 0.1436798, 0.14363563, 0.1435914, 0.14354713, 0.14350282, 0.14345844, 0.14341402, 0.14336957, 0.14332505, 0.14328048, 0.14323586, 0.1431912, 0.14314649, 0.14310174, 0.14305693, 0.14301206, 0.14296718, 0.14292221, 0.14287722, 0.14283216, 0.14278705, 0.1427419, 0.14269671, 0.14265145, 0.14260615, 0.14256081, 0.14251542, 0.14246997, 0.14242449, 0.14237896, 0.14233336, 0.14228773, 0.14224204, 0.1421963, 0.14215051, 0.14210469, 0.14205879, 0.14201286, 0.14196688, 0.14192086, 0.14187478, 0.14182864, 0.14178248, 0.14173625, 0.14168997, 0.14164366, 0.14159729, 0.14155085, 0.14150439, 0.14145787, 0.14141132, 0.14136469, 0.14131802, 0.14127132, 0.14122455, 0.14117774, 0.14113088, 0.14108397, 0.14103702, 0.14099, 0.14094296, 0.14089584, 0.14084871, 0.1408015, 0.14075425, 0.14070696, 0.1406596, 0.1406122, 0.14056475, 0.14051726, 0.14046971, 0.14042212, 0.14037448, 0.1403268, 0.14027905, 0.14023127, 0.14018343, 0.14013556, 0.14008762, 0.14003964, 0.1399916, 0.13994351, 0.13989539, 0.1398472, 0.13979898, 0.1397507, 0.13970238, 0.13965401, 0.13960558, 0.13955711, 0.13950859, 0.13946003, 0.1394114, 0.13936275, 0.13931403, 0.13926525, 0.13921644, 0.13916758, 0.13911867, 0.13906971, 0.13902071, 0.13897166, 0.13892254, 0.13887337, 0.13882418, 0.13877492, 0.13872562, 0.13867627, 0.13862687, 0.13857742, 0.13852793, 0.13847838, 0.13842878, 0.13837914, 0.13832946, 0.13827971, 0.13822991, 0.13818008, 0.13813019, 0.13808025, 0.13803026, 0.13798022, 0.13793014, 0.13788001, 0.13782983, 0.13777961, 0.13772932, 0.13767898, 0.13762861, 0.13757819, 0.13752773, 0.1374772, 0.13742661, 0.13737601, 0.13732535, 0.13727461, 0.13722384, 0.13717303, 0.13712215, 0.13707124, 0.13702029, 0.13696927, 0.13691822, 0.13686709, 0.13681594, 0.13676473, 0.13671347, 0.13666219, 0.13661082, 0.13655943, 0.13650796, 0.13645646, 0.13640492, 0.13635331, 0.13630167, 0.13624997, 0.13619822, 0.13614644, 0.1360946, 0.1360427, 0.13599077, 0.13593878, 0.13588674, 0.13583465, 0.13578252, 0.13573034, 0.1356781, 0.13562581, 0.13557349, 0.1355211, 0.13546868, 0.13541619, 0.13536367, 0.1353111, 0.13525848, 0.13520581, 0.13515308, 0.13510031, 0.13504748, 0.13499463, 0.1349417, 0.13488874, 0.13483573, 0.13478266, 0.13472955, 0.1346764, 0.13462318, 0.13456991, 0.13451661, 0.13446327, 0.13440986, 0.13435639, 0.13430288, 0.13424934, 0.13419573, 0.13414209, 0.13408838, 0.13403465, 0.13398084, 0.133927, 0.13387311, 0.13381918, 0.13376518, 0.13371113, 0.13365704, 0.13360292, 0.13354872, 0.13349448, 0.13344021, 0.13338587, 0.13333148, 0.13327706, 0.13322257, 0.13316804, 0.13311346, 0.13305883, 0.13300416, 0.13294946, 0.13289467, 0.13283984, 0.13278498, 0.13273005, 0.13267508, 0.13262007, 0.13256499, 0.13250989, 0.13245472, 0.13239951, 0.13234425, 0.13228893, 0.13223357, 0.13217816, 0.13212273, 0.1320672, 0.13201165, 0.13195604, 0.1319004, 0.13184468, 0.13178894, 0.13173315, 0.1316773, 0.13162141, 0.13156545, 0.13150945, 0.13145341, 0.13139732, 0.13134119, 0.131285, 0.13122876, 0.13117246, 0.13111614, 0.13105974, 0.13100331, 0.13094683, 0.13089029, 0.1308337, 0.13077709, 0.13072041, 0.13066368, 0.13060689, 0.13055007, 0.13049321, 0.13043629, 0.1303793, 0.13032229, 0.13026522, 0.1302081, 0.13015094, 0.13009372, 0.13003646, 0.12997913, 0.12992179, 0.12986436, 0.12980692, 0.1297494, 0.12969184, 0.12963423, 0.12957658, 0.12951888, 0.12946112, 0.12940332, 0.12934548, 0.12928757, 0.12922962, 0.12917162, 0.12911358, 0.12905549, 0.12899734, 0.12893915, 0.1288809, 0.12882261, 0.12876427, 0.12870589, 0.12864745, 0.12858897, 0.12853044, 0.12847185, 0.12841322, 0.12835452, 0.12829581, 0.12823702, 0.12817819, 0.12811932, 0.12806039, 0.12800142, 0.1279424, 0.12788332, 0.1278242, 0.12776503, 0.12770581, 0.12764655, 0.12758723, 0.12752786, 0.12746845, 0.127409, 0.12734948, 0.12728992, 0.1272303, 0.12717065, 0.12711094, 0.12705117, 0.12699138, 0.12693152, 0.12687163, 0.12681168, 0.12675168, 0.12669162, 0.12663153, 0.12657139, 0.12651119, 0.12645094, 0.12639065, 0.1263303, 0.12626992, 0.12620948, 0.12614898, 0.12608846, 0.12602787, 0.12596723, 0.12590654, 0.12584582, 0.12578502, 0.12572421, 0.12566333, 0.12560239, 0.12554142, 0.1254804, 0.1254193, 0.12535819, 0.12529702, 0.1252358, 0.12517452, 0.1251132, 0.12505184, 0.12499042, 0.12492895, 0.12486745, 0.12480342, 0.12473693, 0.12467039, 0.12460382, 0.12453724, 0.12447062, 0.12440397, 0.12433729, 0.1242706, 0.12420386, 0.1241371, 0.12407031, 0.12400349, 0.12393665, 0.12386978, 0.12380289, 0.12373595, 0.12366899, 0.12360201, 0.12353499, 0.12346795, 0.12340087, 0.12333378, 0.12326665, 0.1231995, 0.12313231, 0.12306511, 0.12299787, 0.12293059, 0.1228633, 0.12279598, 0.12272862, 0.12266123, 0.12259383, 0.12252638, 0.12245893, 0.12239143, 0.12232391, 0.12225636, 0.12218878, 0.12212116, 0.12205353, 0.12198587, 0.12191818, 0.12185045, 0.12178271, 0.12171493, 0.12164713, 0.12157929, 0.12151143, 0.12144353, 0.12137561, 0.12130767, 0.1212397, 0.1211717, 0.12110366, 0.1210356, 0.12096751, 0.12089941, 0.12083125, 0.12076308, 0.12069488, 0.12062665, 0.12055839, 0.1204901, 0.1204218, 0.12035345, 0.12028508, 0.12021668, 0.12014825, 0.1200798, 0.12001131, 0.1199428, 0.11987427, 0.11980569, 0.1197371, 0.11966848, 0.11959981, 0.11953114, 0.11946243, 0.11939369, 0.11932493, 0.11925612, 0.1191873, 0.11911846, 0.11904958, 0.11898066, 0.11891173, 0.11884277, 0.11877377, 0.11870475, 0.11863571, 0.11856662, 0.11849753, 0.11842838, 0.11835923, 0.11829004, 0.11822081, 0.11815158, 0.11808229, 0.11801299, 0.11794366, 0.11787429, 0.11780491, 0.11773549, 0.11766604, 0.11759657, 0.11752707, 0.11745755, 0.11738798, 0.1173184, 0.11724878, 0.11717913, 0.11710947, 0.11703978, 0.11697004, 0.1169003, 0.11683051, 0.11676069, 0.11669085, 0.11662099, 0.11655108, 0.11648116, 0.11641121, 0.11634123, 0.11627122, 0.11620117, 0.11613111, 0.11606101, 0.1159909, 0.11592074, 0.11585056, 0.11578035, 0.11571012, 0.11563985, 0.11556955, 0.11549924, 0.11542889, 0.1153585, 0.11528811, 0.11521767, 0.11514721, 0.11507672, 0.11500619, 0.11493564, 0.11486508, 0.11479447, 0.11472384, 0.11465318, 0.11458249, 0.11451177, 0.11444103, 0.11437026, 0.11429946, 0.11422862, 0.11415776, 0.11408687, 0.11401596, 0.11394501, 0.11387405, 0.11380306, 0.11373202, 0.11366097, 0.11358989, 0.11351877, 0.11344763, 0.11337645, 0.11330526, 0.11323404, 0.11316279, 0.11309151, 0.11302019, 0.11294886, 0.11287749, 0.11280609, 0.11273468, 0.11266322, 0.11259173, 0.11252022, 0.11244869, 0.11237712, 0.11230554, 0.11223391, 0.11216226, 0.11209059, 0.11201887, 0.11194715, 0.11187538, 0.11180359, 0.11173177, 0.11165993, 0.11158805, 0.11151614, 0.11144421, 0.11137225, 0.11130027, 0.11122824, 0.1111562, 0.11108413, 0.11101203, 0.1109399, 0.11086774, 0.11079555, 0.11072334, 0.11065109, 0.11057883, 0.11050652, 0.1104342, 0.11036184, 0.11028945, 0.11021704, 0.1101446, 0.11007212, 0.10999963, 0.10992712, 0.10985456, 0.10978197, 0.10970937, 0.10963672, 0.10956406, 0.10949136, 0.10941863, 0.10934588, 0.1092731, 0.1092003, 0.10912746, 0.1090546, 0.1089817, 0.10890878, 0.10883582, 0.10876285, 0.10868984, 0.10861681, 0.10854375, 0.10847066, 0.10839753, 0.10832439, 0.10825121, 0.108178, 0.10810477, 0.10803152, 0.10795823, 0.10788491, 0.10781156, 0.1077382, 0.10766479, 0.10759135, 0.10751789, 0.10744441, 0.10737089, 0.10729735, 0.10722377, 0.10715018, 0.10707656, 0.10700289, 0.10692922, 0.1068555, 0.10678175, 0.10670799, 0.10663419, 0.10656036, 0.10648651, 0.10641263, 0.10633871, 0.10626478, 0.10619081, 0.10611682, 0.10604279, 0.10596874, 0.10589465, 0.10582055, 0.10574642, 0.10567224, 0.10559805, 0.10552383, 0.10544958, 0.1053753, 0.105301, 0.10522667, 0.10515229, 0.10507791, 0.10500349, 0.10492904, 0.10485456, 0.10478006, 0.10470553, 0.10463097, 0.10455637, 0.10448176, 0.10440711, 0.10433244, 0.10425773, 0.10418301, 0.10410824, 0.10403346, 0.10395865, 0.1038838, 0.10380893, 0.10373402, 0.1036591, 0.10358415, 0.10350917, 0.10343415, 0.1033591, 0.10328404, 0.10320894, 0.10313381, 0.10305865, 0.10298347, 0.10290827, 0.10283301, 0.10275776, 0.10268246, 0.10260713, 0.10253178, 0.10245641, 0.10238099, 0.10230555, 0.10223009, 0.1021546, 0.10207908, 0.10200353, 0.10192795, 0.10185234, 0.1017767, 0.10170105, 0.10162535, 0.10154963, 0.10147388, 0.10139811, 0.10132231, 0.10124648, 0.10117061, 0.10109472, 0.1010188, 0.10094286, 0.10086688, 0.10079088, 0.10071485, 0.1006388, 0.1005627, 0.10048658, 0.10041044, 0.10033427, 0.10025807, 0.10018185, 0.10010559, 0.10002929, 0.099952973, 0.099876642, 0.099800281, 0.099723876, 0.099647447, 0.099571005, 0.099494517, 0.099417999, 0.099341467, 0.099264897, 0.099188305, 0.099111669, 0.09903501, 0.098958351, 0.098881632, 0.098804891, 0.09872812, 0.098651335, 0.098574512, 0.098497666, 0.098420776, 0.098343879, 0.098266937, 0.09818998, 0.098112993, 0.098035969, 0.097958915, 0.097881839, 0.097804733, 0.097727604, 0.097650431, 0.097573251, 0.097496048, 0.097418785, 0.097341515, 0.0972642, 0.097186886, 0.097109519, 0.097032137, 0.096954711, 0.096877269, 0.096799798, 0.09672229, 0.096644767, 0.096567214, 0.096489623, 0.096412018, 0.096334375, 0.096256703, 0.096179001, 0.096101277, 0.096023515, 0.095945746, 0.095867932, 0.095790088, 0.09571223, 0.095634319, 0.095556401, 0.095478445, 0.095400468, 0.095322467, 0.095244408, 0.095166355, 0.095088258, 0.095010132, 0.09493199, 0.094853811, 0.094775602, 0.094697371, 0.094619103, 0.094540812, 0.094462484, 0.094384149, 0.094305769, 0.094227351, 0.094148926, 0.094070464, 0.093991973, 0.093913443, 0.093834914, 0.093756333, 0.093677737, 0.093599096, 0.09352044, 0.093441762, 0.093363032, 0.093284294, 0.093205519, 0.093126714, 0.093047887, 0.092969023, 0.092890143, 0.092811242, 0.092732295, 0.092653312, 0.092574328, 0.092495285, 0.092416249, 0.092337154, 0.092258036, 0.092178911, 0.092099726, 0.092020541, 0.091941312, 0.09186206, 0.091782786, 0.091703467, 0.091624126, 0.09154477, 0.091465369, 0.091385946, 0.0913065, 0.091227017, 0.091147505, 0.09106797, 0.090988412, 0.090908818, 0.090829208, 0.090749554, 0.090669878, 0.090590157, 0.090510435, 0.090430677, 0.090350874, 0.090271071, 0.090191223, 0.090111338, 0.090031438, 0.0899515, 0.089871556, 0.089791566, 0.089711547, 0.089631505, 0.089551441, 0.089471325, 0.089391194, 0.089311048, 0.089230858, 0.089150645, 0.089070395, 0.088990122, 0.088909835, 0.088829488, 0.088749141, 0.088668771, 0.08858835, 0.088507906, 0.088427439, 0.088346943, 0.088266425, 0.088185869, 0.088105284, 0.088024475, 0.087943248, 0.087862052, 0.087780878, 0.087699696, 0.087618537, 0.087537393, 0.087456271, 0.087375157, 0.08729405, 0.087212972, 0.087131903, 0.087050848, 0.0869698, 0.086888775, 0.086807765, 0.086726777, 0.086645789, 0.086564809, 0.086483866, 0.086402915, 0.086321987, 0.086241096, 0.086160183, 0.086079307, 0.085998431, 0.085917592, 0.085836746, 0.085755922, 0.085675113, 0.085594319, 0.085513532, 0.08543276, 0.085352011, 0.085271277, 0.085190564, 0.08510983, 0.085029162, 0.084948473, 0.084867798, 0.08478716, 0.08470653, 0.084625892, 0.084545292, 0.084464684, 0.084384114, 0.08430355, 0.084223002, 0.084142469, 0.084061958, 0.083981439, 0.083900951, 0.083820462, 0.083740003, 0.083659567, 0.083579108, 0.083498709, 0.083418302, 0.083337903, 0.083257541, 0.083177172, 0.083096817, 0.083016492, 0.082936175, 0.082855865, 0.082775578, 0.08269529, 0.082615033, 0.08253479, 0.082454555, 0.082374357, 0.082294136, 0.082213961, 0.082133785, 0.082053617, 0.081973471, 0.08189334, 0.081813224, 0.081733115, 0.081653036, 0.081572957, 0.081492916, 0.081412852, 0.081332825, 0.081252821, 0.081172809, 0.081092834, 0.081012867, 0.0809329, 0.080852963, 0.080773026, 0.080693111, 0.080613218, 0.080533333, 0.080453455, 0.080373615, 0.08029376, 0.080213934, 0.080134124, 0.08005432, 0.079974547, 0.079894766, 0.079815008, 0.079735279, 0.079655528, 0.079575844, 0.079496138, 0.079416461, 0.079336785, 0.079257116, 0.079177499, 0.07909786, 0.079018258, 0.078938656, 0.078859083, 0.078779511, 0.078699954, 0.078620426, 0.078540891, 0.078461394, 0.078381889, 0.078302413, 0.078222945, 0.078143477, 0.078064054, 0.077984639, 0.077905223, 0.077825829, 0.077746451, 0.077667087, 0.077587746, 0.07750839, 0.077429079, 0.077349775, 0.077270471, 0.077191196, 0.077111945, 0.077032685, 0.076953456, 0.076874226, 0.076795027, 0.076715834, 0.076636657, 0.076557487, 0.076478355, 0.076399207, 0.076320089, 0.076240979, 0.076161899, 0.076082826, 0.07600376, 0.075924709, 0.075845689, 0.07576666, 0.075687654, 0.075608671, 0.075529695, 0.075450733, 0.07537178, 0.075292863, 0.075213939, 0.075135037, 0.075056151, 0.074977279, 0.074898407, 0.07481958, 0.074740738, 0.074661918, 0.074583128, 0.074504331, 0.074425571, 0.074346803, 0.074268058, 0.074189328, 0.07411062, 0.074031912, 0.073953226, 0.073874563, 0.0737959, 0.073717266, 0.073638625, 0.073560014, 0.073481433, 0.073402829, 0.073324271, 0.073245704, 0.073167168, 0.073088646, 0.073010117, 0.07293164, 0.072853148, 0.072774678, 0.072696216, 0.072617784, 0.072539352, 0.072460942, 0.072382547, 0.072304159, 0.072225794, 0.072147444, 0.072069108, 0.071990788, 0.071912467, 0.071834177, 0.071755886, 0.071677633, 0.071599387, 0.071521133, 0.071442917, 0.071364708, 0.071286507, 0.071208328, 0.071130171, 0.071052007, 0.070973881, 0.070895754, 0.070817649, 0.070739567, 0.07066147, 0.070583411, 0.070505358, 0.070427328, 0.070349306, 0.070271283, 0.070193306, 0.070115328, 0.070037358, 0.069959417, 0.069881484, 0.069803566, 0.069725648, 0.069647767, 0.069569878, 0.069492035, 0.069414169, 0.069336347, 0.069258533, 0.06918072, 0.069102935, 0.069025159, 0.068947397, 0.06886965, 0.068791911, 0.068714201, 0.068636499, 0.068558797, 0.068481125, 0.068403475, 0.068325825, 0.068248205, 0.068170585, 0.068092972, 0.068015389, 0.067937814, 0.067860261, 0.067782715, 0.067705184, 0.067627668, 0.067550175, 0.067472681, 0.067395218, 0.067317754, 0.067240313, 0.067162894, 0.06708546, 0.067008063, 0.066930681, 0.066853307, 0.066775963, 0.066698618, 0.066621296, 0.066543967, 0.066466667, 0.066389382, 0.066312119, 0.066234864, 0.066157624, 0.066080406, 0.066003181, 0.065925993, 0.065848798, 0.065771632, 0.065694489, 0.065617338, 0.065540224, 0.065463111, 0.065385997, 0.065308928, 0.06523186, 0.065154806, 0.065077767, 0.065000743, 0.064923733, 0.064846739, 0.06476976, 0.064692788, 0.064615853, 0.064538904, 0.064461984, 0.064385064, 0.064308174, 0.064231299, 0.064154431, 0.064077586, 0.064000748, 0.063923933, 0.063847125, 0.063770331, 0.063693546, 0.063616782, 0.063540027, 0.063463293, 0.063386582, 0.063309871, 0.063233182, 0.0631565, 0.063079834, 0.063003197, 0.062926553, 0.062849939, 0.062773332, 0.062696733, 0.062620163, 0.062543601, 0.062467057, 0.062390521, 0.062314015, 0.062237505, 0.062161017, 0.062084533, 0.062008075, 0.061931636, 0.061855197, 0.061778788, 0.061702386, 0.061625984, 0.061549619, 0.06147325, 0.061396915, 0.061320581, 0.061244272, 0.061167959, 0.06109168, 0.061015405, 0.060939141, 0.06086291, 0.060786664, 0.060710467, 0.060634252, 0.060558073, 0.060481902, 0.060405735, 0.060329605, 0.060253475, 0.06017736, 0.060101252, 0.060025163, 0.059949104, 0.059873052, 0.059797011, 0.059720978, 0.059644975, 0.059568968, 0.059492987, 0.059417013, 0.059341054, 0.059265118, 0.059189193, 0.059113283, 0.059037391, 0.058961511, 0.058885641, 0.058809787, 0.058733948, 0.058658123, 0.058582302, 0.058506511, 0.058430735, 0.058354959, 0.058279213, 0.058203481, 0.058127753, 0.058052048, 0.057976346, 0.057900671, 0.057824995, 0.05774935, 0.057673719, 0.057598088, 0.057522487, 0.057446886, 0.057371322, 0.057295747, 0.057220194, 0.057144664, 0.057069134, 0.056993637, 0.056918133, 0.056842666, 0.056767199, 0.056691747, 0.05661631, 0.056540903, 0.056465495, 0.056390096, 0.056314718, 0.056239355, 0.056164015, 0.056088675, 0.056013357, 0.055938058, 0.055862762, 0.055787493, 0.055712223, 0.05563698, 0.055561759, 0.055486526, 0.055411331, 0.05533614, 0.055260964, 0.055185806, 0.055110663, 0.05503552, 0.054960407, 0.054885302, 0.054810215, 0.054735158, 0.054660082, 0.054585043, 0.054510016, 0.054434996, 0.054359999, 0.054285001, 0.054210041, 0.054135084, 0.054060131, 0.053985216, 0.053910293, 0.053835396, 0.053760506, 0.05368565, 0.053610779, 0.053535946, 0.053461108, 0.053386293, 0.053311504, 0.053236712, 0.053161949, 0.053087194, 0.053012449, 0.052937727, 0.052863006, 0.052788313, 0.052713625, 0.052638955, 0.052564304, 0.052489676, 0.052415043, 0.052340437, 0.052265845, 0.05219125, 0.052116688, 0.052042138, 0.051967595, 0.051893074, 0.051818553, 0.051744062, 0.051669583, 0.05159511, 0.051520668, 0.051446218, 0.051371802, 0.051297396, 0.051223002, 0.051148616, 0.051074259, 0.050999902, 0.050925571, 0.050851252, 0.050776944, 0.05070265, 0.050628364, 0.050554104, 0.050479863, 0.050405618, 0.050331403, 0.050257195, 0.050182998, 0.05010882, 0.050034661, 0.049960513, 0.049886391, 0.049812257, 0.049738158, 0.049664076, 0.049589988, 0.049515937, 0.049441881, 0.049367841, 0.049293835, 0.049221449, 0.049150825, 0.049080241, 0.049009703, 0.048939209, 0.048868772, 0.048798364, 0.048728015, 0.0486577, 0.048587456, 0.048517235, 0.048447065, 0.048376944, 0.048306894, 0.048236836, 0.048166875, 0.048096936, 0.048027042, 0.047957204, 0.047887404, 0.047817655, 0.047747962, 0.047678299, 0.047608677, 0.047539122, 0.047469594, 0.047400124, 0.047330696, 0.047261313, 0.047191989, 0.047122702, 0.047053464, 0.046984266, 0.046915121, 0.046846014, 0.046776973, 0.046707958, 0.046638992, 0.046570085, 0.046501204, 0.046432387, 0.046363603, 0.046294883, 0.046226196, 0.046157558, 0.046088967, 0.046020418, 0.045951918, 0.045883477, 0.045815054, 0.045746703, 0.045678392, 0.045610126, 0.045541905, 0.045473743, 0.045405589, 0.045337532, 0.045269474, 0.045201492, 0.045133557, 0.045065649, 0.0449978, 0.044930015, 0.044862222, 0.044794533, 0.044726856, 0.044659261, 0.044591676, 0.044524144, 0.044456668, 0.044389244, 0.044321842, 0.044254512, 0.044187211, 0.044119962, 0.044052765, 0.043985602, 0.043918483, 0.043851443, 0.04378441, 0.043717459, 0.043650527, 0.043583654, 0.043516826, 0.043450035, 0.043383285, 0.043316606, 0.043249946, 0.043183364, 0.043116804, 0.043050293, 0.042983845, 0.042917434, 0.042851049, 0.042784736, 0.042718444, 0.042652238, 0.042586058, 0.042519905, 0.042453825, 0.042387784, 0.042321775, 0.04225583, 0.042189922, 0.042124063, 0.042058263, 0.041992493, 0.041926768, 0.041861113, 0.041795466, 0.041729908, 0.041664362, 0.041598868, 0.041533429, 0.041468035, 0.041402686, 0.041337393, 0.041272126, 0.04120693, 0.041141763, 0.041076645, 0.041011564, 0.040946547, 0.040881556, 0.040816642, 0.040751763, 0.04068692, 0.040622126, 0.040557373, 0.04049268, 0.040428035, 0.040363431, 0.040298864, 0.040234342, 0.040169884, 0.040105455, 0.040041074, 0.039976764, 0.039912481, 0.039848235, 0.039784044, 0.039719902, 0.039655801, 0.039591763, 0.039527748, 0.039463788, 0.039399877, 0.039336018, 0.039272193, 0.039208423, 0.039144684, 0.039081018, 0.039017376, 0.038953796, 0.038890246, 0.03882676, 0.038763303, 0.038699903, 0.038636539, 0.038573235, 0.038509972, 0.038446754, 0.038383599, 0.038320471, 0.038257375, 0.03819437, 0.038131367, 0.038068447, 0.038005546, 0.037942693, 0.037879903, 0.037817139, 0.037754439, 0.037691783, 0.037629157, 0.037566602, 0.037504062, 0.037441604, 0.037379157, 0.037316784, 0.03725443, 0.037192158, 0.037129909, 0.037067715, 0.037005555, 0.036943454, 0.036881391, 0.03681938, 0.036757413, 0.036695499, 0.036633611, 0.03657179, 0.036510009, 0.036448285, 0.03638659, 0.036324967, 0.036263343, 0.036201824, 0.0361403, 0.036078848, 0.036017444, 0.035956074, 0.03589477, 0.035833504, 0.035772249, 0.035711098, 0.035649955, 0.035588875, 0.035527822, 0.035466839, 0.035405889, 0.035344999, 0.035284132, 0.035223328, 0.035162568, 0.035101861, 0.035041168, 0.034980562, 0.034919981, 0.034859456, 0.03479898, 0.034738533, 0.034678135, 0.034617811, 0.034557488, 0.034497265, 0.034437042, 0.034376882, 0.034316778, 0.034256708, 0.03419669, 0.034136716, 0.034076802, 0.034016915, 0.033957068, 0.033897296, 0.033837538, 0.033777852, 0.033718199, 0.033658601, 0.033599053, 0.033539541, 0.033480067, 0.033420656, 0.033361275, 0.033301953, 0.03324268, 0.033183444, 0.033124257, 0.033065118, 0.033006024, 0.03294697, 0.032887977, 0.03282902, 0.032770127, 0.032711245, 0.032652449, 0.032593664, 0.032534946, 0.032476272, 0.032417655, 0.032359049, 0.032300521, 0.032242041, 0.032183588, 0.032125186, 0.032066837, 0.032008521, 0.031950284, 0.031892043, 0.031833909, 0.031775776, 0.031717706, 0.031659674, 0.031601682, 0.031543747, 0.031485882, 0.031428024, 0.031370234, 0.031312477, 0.031254772, 0.031197116, 0.031139512, 0.031081932, 0.031024436, 0.030966943, 0.030909533, 0.030852148, 0.030794812, 0.030737523, 0.03068031, 0.030623088, 0.030565944, 0.030508837, 0.030451793, 0.030394794, 0.030337818, 0.030280916, 0.030224048, 0.030167203, 0.03011046, 0.030053711, 0.02999704, 0.029940385, 0.029883787, 0.029827252, 0.029770762, 0.029714296, 0.029657895, 0.029601533, 0.029545214, 0.029488953, 0.029432742, 0.029376555, 0.029320434, 0.029264357, 0.029208321, 0.029152326, 0.029096378, 0.02904048, 0.028984638, 0.028928839, 0.028873073, 0.028817369, 0.028761702, 0.028706091, 0.028650502, 0.02859498, 0.028539518, 0.028484074, 0.028428691, 0.028373346, 0.028318062, 0.028262813, 0.028207596, 0.028152468, 0.028097352, 0.028042298, 0.027987275, 0.02793229, 0.027877383, 0.027822513, 0.027767656, 0.027712896, 0.02765814, 0.027603462, 0.027548814, 0.027494213, 0.027439658, 0.027385162, 0.027330689, 0.027276281, 0.027221901, 0.027167588, 0.027113311, 0.027059082, 0.027004896, 0.026950769, 0.026896689, 0.02684263, 0.026788648, 0.026734682, 0.026680784, 0.026626941, 0.026573105, 0.026519369, 0.026465639, 0.02641198, 0.026358336, 0.026304746, 0.02625123, 0.026197754, 0.026144294, 0.026090911, 0.026037555, 0.025984263, 0.025931004, 0.025877802, 0.025824625, 0.025771517, 0.025718441, 0.025665423, 0.025612438, 0.025559522, 0.025506629, 0.025453785, 0.025400992, 0.025348252, 0.02529555, 0.025242893, 0.025190299, 0.025137736, 0.025085209, 0.025032766, 0.024980325, 0.024927959, 0.024875632, 0.024823336, 0.024771117, 0.024718912, 0.024666773, 0.024614688, 0.02456262, 0.024510628, 0.024458669, 0.024406759, 0.02435489, 0.024303067, 0.024251292, 0.024199577, 0.024147892, 0.024096265, 0.02404467, 0.023993133, 0.023941632, 0.023890188, 0.023838786, 0.023787431, 0.023736125, 0.023684856, 0.023633637, 0.023582477, 0.023531342, 0.023480287, 0.023429241, 0.023378266, 0.023327319, 0.023276418, 0.023225576, 0.023174774, 0.023124048, 0.023073329, 0.023022655, 0.022972051, 0.022921469, 0.022870958, 0.022820484, 0.022770058, 0.022719678, 0.022669334, 0.022619059, 0.022568798, 0.022518618, 0.02246845, 0.022418352, 0.022368291, 0.022318279, 0.02226831, 0.022218397, 0.022168519, 0.022118699, 0.022068912, 0.022019181, 0.021969505, 0.02191986, 0.021870252, 0.021820705, 0.021771196, 0.021721773, 0.021672333, 0.021622999, 0.021573674, 0.021524396, 0.02147517, 0.021425983, 0.021376858, 0.021327786, 0.021278715, 0.021229757, 0.021180799, 0.021131907, 0.02108304, 0.021034244, 0.020985471, 0.020936765, 0.020888094, 0.020839471, 0.02079089, 0.020742377, 0.020693881, 0.020645451, 0.020597054, 0.020548709, 0.02050041, 0.020452159, 0.020403946, 0.020355808, 0.020307677, 0.02025963, 0.020211594, 0.020163635, 0.020115711, 0.020067818, 0.020019993, 0.019972187, 0.019924467, 0.019876774, 0.019829098, 0.019781519, 0.019733956, 0.01968812, 0.019644149, 0.019600224, 0.019556351, 0.019512549, 0.019468786, 0.019425061, 0.019381395, 0.019337777, 0.019294214, 0.019250708, 0.019207234, 0.019163838, 0.019120466, 0.019077167, 0.019033901, 0.018990697, 0.018947538, 0.018904433, 0.018861387, 0.018818373, 0.018775444, 0.018732531, 0.018689664, 0.018646887, 0.018604141, 0.018561441, 0.018518804, 0.018476196, 0.018433649, 0.018391157, 0.018348726, 0.018306324, 0.018263984, 0.018221701, 0.018179458, 0.018137265, 0.018095125, 0.018053038, 0.01801102, 0.017969018, 0.017927092, 0.01788521, 0.017843379, 0.017801598, 0.017759886, 0.017718198, 0.01767657, 0.017634988, 0.017593475, 0.017552001, 0.017510582, 0.017469199, 0.017427893, 0.017386602, 0.017345404, 0.01730423, 0.017263116, 0.017222039, 0.017181017, 0.017140057, 0.01709915, 0.017058264, 0.017017473, 0.016976705, 0.016936002, 0.016895333, 0.016854741, 0.016814169, 0.016773667, 0.016733212, 0.016692827, 0.016652456, 0.016612168, 0.016571904, 0.016531724, 0.016491545, 0.016451465, 0.016411399, 0.016371412, 0.01633147, 0.016291566, 0.016251739, 0.016211949, 0.016172184, 0.016132502, 0.016092865, 0.016053276, 0.016013732, 0.015974265, 0.015934812, 0.015895428, 0.015856093, 0.01581681, 0.015777593, 0.015738409, 0.015699264, 0.015660195, 0.015621165, 0.015582202, 0.015543255, 0.015504393, 0.01546557, 0.01542679, 0.015388067, 0.015349404, 0.015310771, 0.015272199, 0.015233689, 0.015195226, 0.015156801, 0.015118442, 0.015080109, 0.015041852, 0.015003649, 0.014965475, 0.014927371, 0.014889313, 0.014851285, 0.014813343, 0.014775438, 0.014737586, 0.014699789, 0.014662022, 0.014624324, 0.01458667, 0.014549073, 0.014511527, 0.014474029, 0.014436553, 0.014399168, 0.014361823, 0.014324515, 0.014287285, 0.014250091, 0.01421293, 0.014175845, 0.014138813, 0.014101812, 0.014064895, 0.014028008, 0.013991145, 0.013954373, 0.013917633, 0.013880962, 0.013844312, 0.01380774, 0.013771214, 0.013734725, 0.013698292, 0.013661933, 0.013625584, 0.013589333, 0.013553089, 0.013516915, 0.013480803, 0.013444722, 0.013408693, 0.013372727, 0.013336805, 0.013300937, 0.013265109, 0.013229363, 0.013193625, 0.01315798, 0.013122357, 0.013086796, 0.013051281, 0.013015827, 0.012980396, 0.012945049, 0.012909741, 0.012874493, 0.012839269, 0.012804122, 0.012769018, 0.012733963, 0.012698961, 0.012664021, 0.012629095, 0.012594253, 0.012559466, 0.012524717, 0.012490014, 0.012455379, 0.012420767, 0.012386218, 0.012351735, 0.012317293, 0.012282903, 0.012248567, 0.012214262, 0.012180034, 0.012145844, 0.012111707, 0.012077623, 0.012043594, 0.012009603, 0.011975674, 0.011941789, 0.011907975, 0.011874176, 0.011840452, 0.011806782, 0.011773151, 0.011739573, 0.011706058, 0.011672566, 0.011639148, 0.011605784, 0.011572461, 0.011539181, 0.011505978, 0.011472792, 0.011439674, 0.01140661, 0.011373599, 0.011340642, 0.011307723, 0.01127485, 0.011242061, 0.011209296, 0.011176583, 0.011143941, 0.011111305, 0.011078761, 0.011046257, 0.011013797, 0.0109814, 0.010949054, 0.010916726, 0.010884489, 0.010852282, 0.010820136, 0.010788045, 0.010756, 0.010723984, 0.010692053, 0.010660153, 0.010628314, 0.010596521, 0.010564783, 0.010533089, 0.010501456, 0.010469863, 0.010438329, 0.010406835, 0.010375409, 0.010344015, 0.010312689, 0.01028141, 0.010250176, 0.010218973, 0.010187862, 0.010156773, 0.010125738, 0.010094757, 0.010063853, 0.010032956, 0.010002136, 0.0099713849, 0.0099406559, 0.0099099744, 0.0098793684, 0.0098487856, 0.0098182717, 0.0097877961, 0.0097573893, 0.0097270133, 0.0096967062, 0.0096664457, 0.0096362298, 0.0096060606, 0.0095759602, 0.0095458832, 0.009515875, 0.0094859274, 0.0094560189, 0.0094261635, 0.0093963621, 0.0093666064, 0.0093368962, 0.009307256, 0.0092776455, 0.0092480816, 0.009218609, 0.0091891447, 0.0091597494, 0.0091304146, 0.009101104, 0.0090718614, 0.0090426803, 0.009013514, 0.0089844326, 0.0089553967, 0.0089263991, 0.0088974554, 0.0088685732, 0.0088397441, 0.0088109616, 0.0087822163, 0.0087535558, 0.0087249028, 0.0086963121, 0.0086677978, 0.0086393207, 0.0086108819, 0.0085825054, 0.0085541736, 0.0085258894, 0.0084976731, 0.0084695024, 0.0084413709, 0.0084132999, 0.008385268, 0.0083573125, 0.0083293952, 0.0083015077, 0.0082737133, 0.0082459264, 0.0082182148, 0.0081905732, 0.0081629548, 0.008135397, 0.0081078699, 0.0080804043, 0.0080530085, 0.0080256341, 0.007998338, 0.0079710856, 0.0079438733, 0.0079167141, 0.0078896089, 0.0078625493, 0.0078355353, 0.0078085903, 0.0077816993, 0.0077548316, 0.0077280477, 0.0077012866, 0.0076745944, 0.0076479483, 0.0076213484, 0.0075948173, 0.0075683245, 0.0075418851, 0.0075155073, 0.0074891448, 0.0074628512, 0.0074366257, 0.0074104397, 0.0073842835, 0.0073582199, 0.0073321788, 0.0073061991, 0.0072802501, 0.00725437, 0.0072285361, 0.007202778, 0.0071770279, 0.007151355, 0.0071257353, 0.0071001691, 0.0070746336, 0.0070491745, 0.0070237308, 0.0069983797, 0.0069730435, 0.0069477838, 0.0069225617, 0.0068973945, 0.0068722726, 0.0068472121, 0.0068221739, 0.0067972438, 0.0067722979, 0.0067474367, 0.006722644, 0.006697875, 0.0066731581, 0.0066485191, 0.0066239028, 0.0065993327, 0.0065748463, 0.0065503987, 0.0065259575, 0.0065016481, 0.006477315, 0.0064530815, 0.0064288941, 0.0064047137, 0.0063806185, 0.0063565844, 0.0063325735, 0.006308631, 0.0062847422, 0.0062609068, 0.0062371022, 0.0062133595, 0.0061896695, 0.0061660414, 0.006142451, 0.006118923, 0.0060954243, 0.0060719876, 0.0060486118, 0.0060252668, 0.0060019828, 0.0059787608, 0.005955569, 0.0059324387, 0.0059093693, 0.0058863307, 0.0058633531, 0.00584043, 0.0058175367, 0.0057947356, 0.0057719732, 0.0057492405, 0.0057265847, 0.0057039363, 0.005681396, 0.005658871, 0.0056363908, 0.0056140032, 0.0055916235, 0.0055692974, 0.0055470248, 0.0055248206, 0.0055026552, 0.0054805437, 0.0054584849, 0.0054364651, 0.0054145292, 0.0053926171, 0.0053707575, 0.005348952, 0.0053271852, 0.0053054714, 0.0052838502, 0.0052622282, 0.0052407132, 0.0052191992, 0.0051977234, 0.0051763542, 0.0051550008, 0.0051336931, 0.0051124617, 0.0050912546, 0.0050701229, 0.0050490219, 0.0050279978, 0.0050069885, 0.004986064, 0.0049651698, 0.0049443292, 0.0049235499, 0.0049028173, 0.0048821145, 0.0048615038, 0.0048408932, 0.0048203976, 0.0047999015, 0.0047794743, 0.0047590937, 0.0047387588, 0.0047184927, 0.0046982653, 0.004678091, 0.0046579782, 0.0046378961, 0.0046178675, 0.0045979079, 0.0045779864, 0.0045580883, 0.00453832, 0.0045185289, 0.0044988068, 0.0044791535, 0.0044595385, 0.0044399467, 0.004420477, 0.0044010077, 0.0043815994, 0.0043622372, 0.0043429285, 0.0043236581, 0.004304457, 0.0042852941, 0.0042662076, 0.0042471513, 0.0042281342, 0.0042091929, 0.0041902824, 0.0041714413, 0.0041526454, 0.004133896, 0.0041152076, 0.0040965504, 0.0040779538, 0.0040607448, 0.004044814, 0.0040289252, 0.004013048, 0.0039972318, 0.0039814156, 0.003965653, 0.003949902, 0.0039341897, 0.0039185267, 0.0039028791, 0.0038872545, 0.0038716835, 0.0038561241, 0.0038406143, 0.0038251239, 0.0038096525, 0.0037942347, 0.003778836, 0.003763468, 0.0037481461, 0.0037328391, 0.0037175787, 0.0037023406, 0.0036871296, 0.0036719532, 0.0036568113, 0.0036416999, 0.0036265997, 0.0036115609, 0.003596534, 0.0035815374, 0.0035665908, 0.0035516634, 0.0035367778, 0.0035219074, 0.0035070716, 0.0034922818, 0.0034775038, 0.0034627635, 0.0034480658, 0.0034333873, 0.0034187583, 0.0034041447, 0.0033895504, 0.0033750057, 0.0033604878, 0.0033459968, 0.0033315441, 0.0033171065, 0.0033027076, 0.0032883545, 0.0032740205, 0.0032597093, 0.0032454517, 0.0032312097, 0.0032170019, 0.0032028328, 0.0031886827, 0.0031745823, 0.0031604932, 0.0031464351, 0.0031324415, 0.0031184487, 0.0031044823, 0.0030905658, 0.0030766679, 0.0030628163, 0.0030489801, 0.0030351747, 0.0030214153, 0.0030076634, 0.0029939574, 0.0029802858, 0.0029666449, 0.0029530234, 0.0029394515, 0.0029258984, 0.0029123803, 0.0028989001, 0.0028854355, 0.0028720053, 0.0028586325, 0.0028452636, 0.0028319249, 0.0028186403, 0.0028053634, 0.00279214, 0.0027789278, 0.0027657431, 0.0027526149, 0.0027394949, 0.0027264054, 0.0027133697, 0.0027003416, 0.0026873669, 0.0026744041, 0.0026614754, 0.0026485813, 0.0026357255, 0.0026228889, 0.0026100865, 0.002597342, 0.0025846008, 0.0025718906, 0.0025592225, 0.0025465772, 0.0025339744, 0.0025213943, 0.002508837, 0.0024963296, 0.0024838338, 0.0024713879, 0.002458961, 0.0024465532, 0.0024342027, 0.0024218755, 0.0024095711, 0.0023973128, 0.0023850698, 0.0023728574, 0.0023606946, 0.0023485627, 0.002336442, 0.0023243753, 0.0023123196, 0.0023003025, 0.0022883238, 0.0022763601, 0.0022644389, 0.0022525557, 0.0022406841, 0.0022288698, 0.0022170672, 0.0022052913, 0.0021935613, 0.0021818546, 0.0021701744, 0.0021585438, 0.0021469251, 0.0021353599, 0.0021238022, 0.0021122906, 0.0021008209, 0.0020893628, 0.0020779318, 0.0020665503, 0.0020551879, 0.0020438563, 0.0020325631, 0.0020212927, 0.0020100528, 0.0019988553, 0.0019876768, 0.0019765289, 0.001965431, 0.0019543406, 0.0019432885, 0.0019322824, 0.0019212953, 0.0019103503, 0.0018994247, 0.0018885373, 0.0018776921, 0.0018668582, 0.0018560705, 0.0018452978, 0.0018345558, 0.0018238638, 0.0018131946, 0.0018025446, 0.0017919445, 0.0017813595, 0.001770813, 0.0017602894, 0.0017498155, 0.0017393533, 0.0017289369, 0.0017185396, 0.0017081806, 0.0016978676, 0.0016875584, 0.0016772838, 0.001667074, 0.0016568684, 0.0016467047, 0.0016365604, 0.0016264425, 0.0016163784, 0.0016063298, 0.001596304, 0.0015863319, 0.0015763789, 0.0015664527, 0.0015565685, 0.0015467075, 0.001536877, 0.0015270849, 0.0015173156, 0.001507577, 0.0014978806, 0.0014882034, 0.0014785682, 0.0014689714, 0.0014593975, 0.001449858, 0.0014403339, 0.001430852, 0.0014214083, 0.0014119836, 0.0014025897, 0.001393238, 0.0013839055, 0.0013746187, 0.0013653551, 0.0013561181, 0.0013469234, 0.0013377439, 0.0013285989, 0.0013194999, 0.0013104124, 0.001301367, 0.0012923637, 0.0012833872, 0.0012744261, 0.0012655148, 0.0012566263, 0.0012477648, 0.0012389453, 0.0012301488, 0.0012213753, 0.0012126592, 0.001203947, 0.0011952922, 0.0011866488, 0.0011780324, 0.0011694696, 0.0011609219, 0.0011524127, 0.0011439226, 0.0011354669, 0.0011270611, 0.0011186589, 0.0011103144, 0.0011019928, 0.0010936941, 0.0010854261, 0.001077204, 0.0010689973, 0.0010608251, 0.0010526987, 0.001044584, 0.0010365036, 0.0010284692, 0.00102045, 0.0010124616, 0.0010045306, 0.00099660351, 0.00098872604, 0.00098086393, 0.00097303255, 0.00096523936, 0.00095747685, 0.00094974501, 0.00094206294, 0.00093438471, 0.00092675618, 0.00091915065, 0.00091156433, 0.0009040201, 0.00089651794, 0.00088902743, 0.00088157511, 0.00087416486, 0.00086677767, 0.00085941725, 0.00085209898, 0.0008448037, 0.00083754666, 0.00083031267, 0.00082310539, 0.00081594416, 0.00080880208, 0.00080169825, 0.00079464033, 0.00078758638, 0.00078058586, 0.00077360077, 0.00076665013, 0.00075973396, 0.00075284846, 0.00074598973, 0.00073916925, 0.00073237182, 0.00072560494, 0.0007188879, 0.00071218243, 0.00070550747, 0.00069888239, 0.00069227256, 0.00068570103, 0.00067916012, 0.00067264994, 0.00066617801, 0.00065972516, 0.00065329915, 0.0006469306, 0.00064056594, 0.0006342394, 0.00062796281, 0.00062169385, 0.00061547081, 0.00060926314, 0.00060309755, 0.00059696642, 0.00059086207, 0.00058478076, 0.00057874538, 0.00057273294, 0.00056675507, 0.0005608116, 0.00055489107, 0.00054899743, 0.00054316496, 0.00053732871, 0.00053152698, 0.0005257788, 0.00052004977, 0.00051433995, 0.00050868752, 0.00050304655, 0.00049745542, 0.00049187959, 0.00048632672, 0.00048082747, 0.00047534358, 0.00046989412, 0.0004644868, 0.00045909858, 0.00045374871, 0.00044842181, 0.00044313321, 0.00043787519, 0.00043265554, 0.00042745497, 0.00042227359, 0.00041714965, 0.00041204103, 0.00040696686, 0.00040192716, 0.00039692194, 0.00039195118, 0.00038699576, 0.00038207092, 0.00037720354, 0.00037234384, 0.00036753013, 0.00036273547, 0.00035797153, 0.00035324972, 0.00034855085, 0.00034387875, 0.00033926032, 0.00033464571, 0.00033008092, 0.00032554669, 0.00032102785, 0.00031654726, 0.00031210878, 0.00030769329, 0.00030330464, 0.0002989581, 0.00029463452, 0.00029034159, 0.00028608696, 0.00028185532, 0.00027767345, 0.00027349539, 0.00026935947, 0.00026526951, 0.00026119102, 0.00025715085, 0.0002531528, 0.00024917003, 0.00024524092, 0.0002413233, 0.00023743247, 0.00023359142, 0.00022975805, 0.00022596295, 0.0002222138, 0.00021848001, 0.00021477682, 0.00021112344, 0.00020748534, 0.00020388173, 0.00020031258, 0.00019677408, 0.00019325854, 0.0001897928, 0.00018634622, 0.00018292639, 0.0001795564, 0.00017619022, 0.00017289296, 0.00016960337, 0.00016633677, 0.00016312378, 0.00015991462, 0.00015673992, 0.00015362263, 0.0001505207, 0.00014745707, 0.00014441641, 0.0001413987, 0.0001384308, 0.00013547821, 0.00013256393, 0.00012968411, 0.00012683107, 0.0001240087, 0.00012123228, 0.00011847117, 0.0001157407, 0.00011306766, 0.00011039081, 0.00010775607, 0.00010517111, 0.00010259001, 0.00010006248, 9.7542637e-05, 9.5064919e-05, 9.2629321e-05, 9.0209047e-05, 8.7823231e-05, 8.5483371e-05, 8.3158833e-05, 8.0880236e-05, 7.8616969e-05, 7.6392003e-05, 7.4193835e-05, 7.2037801e-05, 6.9900911e-05, 6.7798486e-05, 6.5749664e-05, 6.3700863e-05, 6.1697996e-05, 5.9721951e-05, 5.7776531e-05, 5.5880901e-05, 5.3989104e-05, 5.2124109e-05, 5.0320381e-05, 4.8524325e-05, 4.6758902e-05, 4.5047087e-05, 4.3342934e-05, 4.1696228e-05, 4.0061004e-05, 3.8464081e-05, 3.6897796e-05, 3.5350651e-05, 3.384181e-05, 3.2375086e-05, 3.0942836e-05, 2.9525898e-05, 2.8151084e-05, 2.6799251e-05, 2.5478055e-05, 2.4195153e-05, 2.2935228e-05, 2.1705939e-05, 2.0518779e-05, 1.9350764e-05, 1.8217215e-05, 1.712196e-05, 1.6053511e-05, 1.5027191e-05, 1.4016187e-05, 1.3039653e-05, 1.2105236e-05, 1.1189974e-05, 1.0316836e-05, 9.462844e-06, 8.6548089e-06, 7.8659195e-06, 7.1153245e-06, 6.3838802e-06, 5.6983877e-06, 5.0320436e-06, 4.4039971e-06, 3.8104147e-06, 3.2359803e-06, 2.692183e-06, 2.1943401e-06, 1.7118147e-06, 1.2714149e-06, 8.6548152e-07, 4.7869577e-07, 1.3020532e-07, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 1.2398172e-15, 3.61893e-07, 1.0895085e-06, 1.8132945e-06, 2.5447396e-06, 3.2742701e-06, 4.0114596e-06, 4.7467342e-06, 5.4858383e-06, 6.2326017e-06, 6.9755351e-06, 7.7280438e-06, 8.4767216e-06, 9.2349737e-06, 9.989395e-06, 1.0749563e-05, 1.1515473e-05, 1.227947e-05, 1.305304e-05, 1.3822782e-05, 1.4600181e-05, 1.5375665e-05, 1.615881e-05, 1.6940039e-05, 1.7727012e-05, 1.8517816e-05, 1.930862e-05, 2.0107082e-05, 2.0901714e-05, 2.1705921e-05, 2.2506298e-05, 2.3312419e-05, 2.4124285e-05, 2.4934236e-05, 2.5753761e-05, 2.6569456e-05, 2.7392813e-05, 2.8216165e-05, 2.9045264e-05, 2.987245e-05, 3.0703464e-05, 3.1540218e-05, 3.2378892e-05, 3.322331e-05, 3.4063898e-05, 3.4914057e-05, 3.5762303e-05, 3.6614379e-05, 3.7470287e-05, 3.8328108e-05, 3.9191669e-05, 4.0055234e-05, 4.0924544e-05, 4.179194e-05, 4.2668908e-05, 4.3542044e-05, 4.4419012e-05, 4.5301724e-05, 4.6186356e-05, 4.7074813e-05, 4.7963265e-05, 4.8859383e-05, 4.9753588e-05, 5.0651615e-05, 5.1555395e-05, 5.2459167e-05, 5.336677e-05, 5.427629e-05, 5.5191555e-05, 5.6106819e-05, 5.7029742e-05, 5.7948837e-05, 5.8873673e-05, 5.980234e-05, 6.073101e-05, 6.1667335e-05, 6.2601743e-05, 6.3541898e-05, 6.4483975e-05, 6.5427957e-05, 6.6375775e-05, 6.7327419e-05, 6.8280977e-05, 6.9236448e-05, 7.0193833e-05, 7.1158887e-05, 7.2125848e-05, 7.3092808e-05, 7.406361e-05, 7.5038224e-05, 7.601476e-05, 7.6995129e-05, 7.7977413e-05, 7.8963523e-05, 7.9951547e-05, 8.0941492e-05, 8.1937178e-05, 8.2932856e-05, 8.3934283e-05, 8.4935717e-05, 8.5939057e-05, 8.6950058e-05, 8.7962981e-05, 8.8975896e-05, 8.9992638e-05, 9.1013222e-05, 9.2033792e-05, 9.306203e-05, 9.4090268e-05, 9.5122326e-05, 9.6156313e-05, 9.7190285e-05, 9.8233839e-05, 9.9275479e-05, 0.00010032287, 0.00010137025, 0.00010241954, 0.0001034765, 0.00010453538, 0.00010559616, 0.00010665695, 0.0001077254, 0.00010879384, 0.00010986612, 0.00011094031, 0.00011201834, 0.00011309826, 0.00011418012, 0.00011526771, 0.0001163553, 0.00011745056, 0.00011854389, 0.00011963915, 0.00012074206, 0.00012184688, 0.00012295363, 0.00012406036, 0.00012517477, 0.00012628725, 0.0001274074, 0.00012852755, 0.0001296496, 0.00013077933, 0.00013190521, 0.00013304068, 0.00013417422, 0.00013531544, 0.00013645281, 0.00013759593, 0.0001387448, 0.00013989558, 0.00014104828, 0.00014220098, 0.00014336132, 0.00014452169, 0.00014568778, 0.00014685196, 0.00014802189, 0.00014919757, 0.00015036942, 0.00015155083, 0.00015273034, 0.0001539175, 0.00015510083, 0.00015628991, 0.00015748665, 0.00015867956, 0.00015988204, 0.00016108068, 0.00016228699, 0.00016349139, 0.00016470536, 0.0001659155, 0.00016713138, 0.00016835301, 0.00016957081, 0.00017079817, 0.00017202363, 0.00017325675, 0.00017448796, 0.00017572298, 0.00017696376, 0.00017820262, 0.00017945106, 0.00018069567, 0.00018194984, 0.0001832002, 0.00018446012, 0.00018571621, 0.00018697805, 0.00018824372, 0.00018951131, 0.00019078465, 0.00019205605, 0.00019333512, 0.00019461226, 0.00019589324, 0.00019717807, 0.00019846672, 0.00019975727, 0.00020104974, 0.00020234988, 0.0002036481, 0.00020495207, 0.00020625413, 0.00020756191, 0.00020887546, 0.00021018708, 0.00021150635, 0.00021282372, 0.00021414875, 0.00021547187, 0.00021680072, 0.00021813149, 0.00021946608, 0.00022080452, 0.00022214293, 0.00022348712, 0.00022483128, 0.00022618311, 0.00022753113, 0.00022888488, 0.00023024245, 0.00023160195, 0.00023296718, 0.00023433051, 0.00023570149, 0.00023707247, 0.00023844535, 0.000239824, 0.00024120264, 0.00024258702, 0.0002439714, 0.00024536153, 0.0002467536, 0.00024814755, 0.00024954532, 0.00025094504, 0.00025234857, 0.000253754, 0.00025516519, 0.00025657448, 0.00025799143, 0.00025940835, 0.00026082719, 0.00026225179, 0.00026367832, 0.00026510865, 0.00026653899, 0.00026797125, 0.00026941113, 0.00027085299, 0.00027229672, 0.00027374236, 0.00027519185, 0.00027664326, 0.0002781004, 0.00027955754, 0.00028101853, 0.0002824814, 0.00028394622, 0.0002854187, 0.00028688923, 0.00028836553, 0.00028984374, 0.00029132195, 0.00029280974, 0.0002942975, 0.00029578528, 0.00029727499, 0.00029877428, 0.00030027161, 0.00030177474, 0.00030327591, 0.00030478093, 0.0003062936, 0.00030780435, 0.00030932279, 0.00031083927, 0.00031236344, 0.00031388568, 0.00031540985, 0.00031694357, 0.00031847734, 0.00032001297, 0.00032154861, 0.00032309195, 0.00032463527, 0.00032618429, 0.00032773337, 0.00032928435, 0.00033084294, 0.00033239968, 0.00033396404, 0.00033552651, 0.00033709666, 0.0003386648, 0.00034023687, 0.00034181465, 0.00034339627, 0.00034497786, 0.00034655948, 0.00034814875, 0.00034973799, 0.000351333, 0.00035292801, 0.00035452496, 0.00035613144, 0.00035773221, 0.00035934441, 0.00036095094, 0.00036256699, 0.0003641831, 0.00036580107, 0.0003674248, 0.00036905237, 0.000370678, 0.00037230749, 0.00037394269, 0.00037557792, 0.0003772208, 0.00037885984, 0.00038050464, 0.00038215518, 0.0003838038, 0.00038546009, 0.00038711447, 0.00038877648, 0.00039043659, 0.00039210246, 0.00039377023, 0.00039544184, 0.00039711918, 0.0003987927, 0.00040047578, 0.00040215501, 0.00040384388, 0.00040552887, 0.0004072196, 0.00040891609, 0.00041061261, 0.00041231487, 0.00041401517, 0.00041572316, 0.00041742923, 0.000419141, 0.0004208567, 0.00042257231, 0.00042429368, 0.00042601509, 0.00042774604, 0.00042947126, 0.00043120605, 0.000432937, 0.00043467371, 0.00043641616, 0.00043815857, 0.00043990489, 0.00044165307, 0.00044340891, 0.00044516096, 0.00044691679, 0.00044867839, 0.0004504419, 0.00045220923, 0.00045397657, 0.00045574966, 0.00045752467, 0.00045930542, 0.00046108424, 0.00046286496, 0.00046465339, 0.00046644179, 0.00046823593, 0.00047003009, 0.00047182804, 0.00047362794, 0.00047543165, 0.00047723923, 0.00047904867, 0.00048086196, 0.00048267527, 0.00048449432, 0.00048631526, 0.00048814196, 0.00048996677, 0.00049179536, 0.0004936278, 0.00049546408, 0.00049730227, 0.00049914239, 0.00050098822, 0.00050283404, 0.0005046837, 0.00050653727, 0.00050839264, 0.00051025191, 0.00051211112, 0.00051397807, 0.00051584304, 0.00051771378, 0.00051958644, 0.00052146101, 0.00052334135, 0.00052522164, 0.00052710768, 0.00052899373, 0.00053088169, 0.00053277734, 0.00053467107, 0.00053657242, 0.00053847383, 0.00054037903, 0.00054228614, 0.00054419704, 0.00054610992, 0.00054802664, 0.00054994522, 0.00055186386, 0.00055379199, 0.00055571832, 0.00055765029, 0.00055958232, 0.00056151627, 0.00056345784, 0.00056539749, 0.00056734675, 0.00056929025, 0.00057124521, 0.00057319639, 0.00057515135, 0.000577114, 0.00057907664, 0.00058104121, 0.00058300578, 0.00058497995, 0.00058695214, 0.0005889301, 0.00059091003, 0.00059288985, 0.00059487741, 0.00059686304, 0.00059885631, 0.00060084771, 0.00060284673, 0.00060484576, 0.0006068467, 0.00060885528, 0.00061086391, 0.0006128744, 0.00061488495, 0.00061690499, 0.00061892316, 0.00062094902, 0.00062297104, 0.00062499882, 0.00062703423, 0.00062906579, 0.00063110498, 0.00063314231, 0.00063518732, 0.00063723233, 0.0006392792, 0.00064133381, 0.00064338639, 0.00064544479, 0.00064750318, 0.00064956921, 0.00065163337, 0.00065370323, 0.0006557731, 0.0006578468, 0.00065992813, 0.00066200568, 0.00066409085, 0.00066617416, 0.00066826702, 0.00067035604, 0.00067244889, 0.00067454751, 0.00067664799, 0.00067875424, 0.00068085862, 0.00068297063, 0.00068507873, 0.00068719656, 0.00068931235, 0.00069143198, 0.00069355738, 0.00069568277, 0.00069781585, 0.00069994514, 0.000702082, 0.000704217, 0.00070635771, 0.00070850225, 0.00071064872, 0.00071279902, 0.00071495125, 0.00071710919, 0.00071926333, 0.00072142895, 0.00072358875, 0.00072575628, 0.00072792574, 0.00073009712, 0.00073227426, 0.00073445129, 0.00073663605, 0.00073881703, 0.00074100372, 0.00074319419, 0.00074538664, 0.00074758282, 0.00074978103, 0.00075198303, 0.00075418694, 0.00075639662, 0.00075860432, 0.00076081592, 0.00076303317, 0.00076525053, 0.0007674736, 0.00076969661, 0.00077192544, 0.00077415421, 0.00077638682, 0.00077862333, 0.00078086171, 0.00078310387, 0.00078534806, 0.00078759791, 0.00078984583, 0.00079210335, 0.00079435704, 0.00079661456, 0.00079887779, 0.00080114114, 0.00080341013, 0.00080567913, 0.0008079501, 0.0008102287, 0.00081250718, 0.00081479159, 0.00081707584, 0.00081936404, 0.0008216541, 0.00082394801, 0.00082624384, 0.00082854542, 0.00083084696, 0.00083315047, 0.00083545968, 0.00083776889, 0.00084008387, 0.00084240077, 0.00084471767, 0.00084704213, 0.00084936479, 0.00085169513, 0.00085402536, 0.00085636135, 0.0008586974, 0.00086103723, 0.00086337904, 0.00086572656, 0.00086807407, 0.00087042159, 0.00087277865, 0.00087513577, 0.00087749667, 0.00087985757, 0.00088222045, 0.00088459288, 0.00088696141, 0.00088933774, 0.00089171203, 0.00089409592, 0.0008964779, 0.00089886371, 0.00090125145, 0.00090364489, 0.00090603839, 0.00090843375, 0.0009108368, 0.000913236, 0.00091564481, 0.00091805361, 0.00092046242, 0.00092288078, 0.00092529529, 0.00092771754, 0.00093013782, 0.00093256764, 0.00093499367, 0.00093742926, 0.00093986298, 0.0009422985, 0.00094474177, 0.00094718125, 0.00094963022, 0.00095207733, 0.00095453201, 0.0009569868, 0.00095944159, 0.00096190587, 0.00096436637, 0.00096683641, 0.00096930261, 0.00097177655, 0.00097425043, 0.00097672618, 0.00097921153, 0.00098169129, 0.00098418235, 0.00098666782, 0.00098916469, 0.00099165575, 0.00099415646, 0.00099665532, 0.0009991579, 0.0010016682, 0.0010041746, 0.0010066906, 0.0010092028, 0.0010117246, 0.0010142444, 0.0010167662, 0.0010192955, 0.001021823, 0.0010243602, 0.0010268915, 0.0010294343, 0.0010319733, 0.00103452, 0.0010370647, 0.0010396133, 0.0010421675, 0.0010447219, 0.0010472839, 0.0010498421, 0.0010524098, 0.0010549756, 0.0010575433, 0.0010601187, 0.001062694, 0.0010652732, 0.0010678543, 0.0010704412, 0.0010730261, 0.0010756188, 0.0010782095, 0.0010808059, 0.0010834062, 0.0010860064, 0.0010886124, 0.0010912184, 0.0010938321, 0.0010964439, 0.0010990595, 0.0011016789, 0.0011043001, 0.0011069273, 0.0011095525, 0.0011121853, 0.001114818, 0.0011174566, 0.0011200934, 0.0011227357, 0.0011253819, 0.0011280281, 0.0011306801, 0.001133334, 0.0011359898, 0.0011386494, 0.0011413109, 0.0011439782, 0.0011466455, 0.0011493167, 0.0011519897, 0.0011546685, 0.0011573472, 0.0011600318, 0.0011627163, 0.0011654027, 0.0011680948, 0.001170789, 0.0011734869, 0.0011761847, 0.0011788846, 0.0011815941, 0.0011843016, 0.0011870149, 0.001189728, 0.0011924452, 0.001195164, 0.0011978889, 0.0012006136, 0.001203344, 0.0012060745, 0.0012088069, 0.0012115469, 0.001214285, 0.0012170289, 0.0012197747, 0.0012225205, 0.0012252759, 0.0012280274, 0.0012307885, 0.0012335477, 0.0012363127, 0.0012390777, 0.0012418462, 0.001244619, 0.0012473934, 0.0012501719, 0.0012529483, 0.0012557342, 0.0012585203, 0.0012613101, 0.0012641018, 0.0012668936, 0.0012696949, 0.0012724925, 0.0012752995, 0.0012781027, 0.0012809155, 0.0012837264, 0.001286543, 0.0012893598, 0.0012921782, 0.0012950044, 0.0012978286, 0.0013006607, 0.0013034906, 0.0013063303, 0.0013091661, 0.0013120057, 0.0013148511, 0.0013176965, 0.0013205495, 0.0013233987, 0.0013262574, 0.0013291143, 0.0013319768, 0.0013348394, 0.0013377039, 0.0013405762, 0.0013434464, 0.0013463263, 0.0013492022   }, 
   { 0.0079891365, 0.0079901963, 0.0079913139, 0.0079924315, 0.0079935202, 0.0079947235, 0.0079959277, 0.0079971021, 0.0079983342, 0.007999653, 0.0080009131, 0.0080022598, 0.0080036065, 0.0080050109, 0.0080063855, 0.0080078468, 0.0080093089, 0.0080107413, 0.0080122594, 0.0080137793, 0.0080153542, 0.0080169598, 0.0080185924, 0.008020197, 0.0080219163, 0.0080236066, 0.008025269, 0.0080270739, 0.0080288509, 0.0080306269, 0.0080324616, 0.0080343522, 0.0080362149, 0.0080381343, 0.0080400826, 0.0080420887, 0.008044037, 0.0080461008, 0.0080481349, 0.0080501689, 0.0080522895, 0.0080544101, 0.0080565587, 0.008058737, 0.0080609713, 0.0080632064, 0.0080654705, 0.0080677625, 0.0080700265, 0.0080723763, 0.0080747539, 0.0080771325, 0.0080795679, 0.0080820322, 0.0080845254, 0.0080869896, 0.0080895405, 0.0080921184, 0.0080946404, 0.0080972472, 0.0080999415, 0.0081025492, 0.0081052715, 0.0081079928, 0.0081107439, 0.0081134951, 0.008116303, 0.0081191398, 0.0081219478, 0.0081248414, 0.0081277648, 0.0081306584, 0.0081336387, 0.0081366468, 0.0081395982, 0.0081426641, 0.00814573, 0.008148768, 0.0081519196, 0.0081551, 0.0081582237, 0.008161433, 0.0081646712, 0.0081679085, 0.0081712035, 0.0081744986, 0.0081778802, 0.0081811752, 0.0081846137, 0.0081880242, 0.0081914049, 0.0081949001, 0.0081983963, 0.0082018925, 0.0082054455, 0.0082090553, 0.008212666, 0.0082162768, 0.0082199154, 0.0082236119, 0.0082272794, 0.0082310336, 0.0082347579, 0.0082385698, 0.0082424087, 0.0082462486, 0.0082500884, 0.008254014, 0.0082579395, 0.0082618371, 0.0082658194, 0.0082698595, 0.0082738427, 0.0082779117, 0.0082820086, 0.0082861353, 0.0082902322, 0.0082944445, 0.008298628, 0.0083027836, 0.0083070807, 0.0083113499, 0.00831562, 0.0083199469, 0.0083243018, 0.0083286576, 0.0083330702, 0.0083375117, 0.0083419811, 0.0083464226, 0.0083509507, 0.0083554778, 0.0083600339, 0.0083646467, 0.0083692316, 0.0083739022, 0.0083785728, 0.0083833002, 0.0083879707, 0.0083927568, 0.0083975419, 0.0084022982, 0.00840717, 0.0084120408, 0.0084168827, 0.0084218122, 0.0084267687, 0.008431755, 0.0084367115, 0.0084417546, 0.0084467977, 0.0084518408, 0.0084569417, 0.0084620994, 0.0084671993, 0.0084724147, 0.0084776292, 0.0084828446, 0.0084881168, 0.0084934179, 0.0084986901, 0.0085040201, 0.0085094357, 0.0085147945, 0.0085202381, 0.0085256826, 0.0085311839, 0.0085366573, 0.0085421875, 0.0085477466, 0.0085532758, 0.0085589495, 0.0085645663, 0.0085702101, 0.0085759126, 0.0085816439, 0.0085873455, 0.0085931337, 0.0085989507, 0.0086047677, 0.0086106127, 0.0086164866, 0.0086224182, 0.008628292, 0.0086342813, 0.008640212, 0.0086462582, 0.0086523043, 0.0086583784, 0.0086644245, 0.0086705862, 0.008676718, 0.0086828498, 0.0086890673, 0.0086953146, 0.0087015321, 0.0087078074, 0.0087141395, 0.0087204725, 0.0087268334, 0.0087332232, 0.0087396419, 0.0087460317, 0.0087525072, 0.0087590404, 0.0087655168, 0.0087720789, 0.0087786689, 0.0087852301, 0.0087918779, 0.0087985545, 0.0088052303, 0.008811879, 0.0088186692, 0.0088253748, 0.008832166, 0.0088389851, 0.0088458341, 0.0088526821, 0.0088596158, 0.0088665504, 0.0088734273, 0.0088804476, 0.008887439, 0.0088944593, 0.0089015085, 0.0089086145, 0.0089156926, 0.0089228554, 0.0089300191, 0.0089372108, 0.0089444034, 0.0089516528, 0.00895896, 0.0089661805, 0.0089735156, 0.0089809084, 0.0089882435, 0.0089956373, 0.0090031149, 0.0090105655, 0.009018044, 0.0090255514, 0.0090330299, 0.0090406239, 0.0090482449, 0.00905581, 0.0090634609, 0.0090711685, 0.0090788482, 0.0090865847, 0.0090943212, 0.0091021154, 0.0091098798, 0.0091177309, 0.0091256117, 0.0091334628, 0.0091413707, 0.0091493372, 0.0091572739, 0.0091652684, 0.0091733197, 0.0091813719, 0.0091893943, 0.0091975322, 0.0092056701, 0.0092137801, 0.0092219459, 0.0092301415, 0.009238393, 0.0092466744, 0.0092549557, 0.0092632072, 0.0092716031, 0.0092799701, 0.0092883371, 0.0092967618, 0.0093052145, 0.0093136672, 0.0093221776, 0.0093307169, 0.0093392842, 0.0093478523, 0.0093564475, 0.0093651013, 0.0093737254, 0.009382437, 0.0093911765, 0.0093998872, 0.0094086556, 0.0094174808, 0.0094262492, 0.0094351312, 0.0094440151, 0.009452926, 0.0094618378, 0.0094707776, 0.0094797462, 0.0094887717, 0.0094978269, 0.0095068812, 0.0095159654, 0.0095251054, 0.0095342174, 0.0095433863, 0.009552585, 0.0095618395, 0.0095710382, 0.0095803505, 0.0095896348, 0.0095989751, 0.0096083162, 0.0096177151, 0.009627142, 0.009636512, 0.0096460255, 0.009655538, 0.0096650226, 0.0096745649, 0.009684192, 0.0096937055, 0.0097033903, 0.0097130183, 0.0097227031, 0.0097323889, 0.0097421305, 0.0097518731, 0.0097616725, 0.0097715296, 0.0097813001, 0.0097911861, 0.0098011009, 0.0098110149, 0.0098209288, 0.0098309005, 0.0098409289, 0.0098509016, 0.0098609878, 0.0098711019, 0.0098811593, 0.0098913033, 0.009901504, 0.0099116471, 0.0099219056, 0.0099321352, 0.0099424217, 0.0099526802, 0.0099629955, 0.0099733686, 0.0099836839, 0.0099941138, 0.010004544, 0.010015002, 0.01002549, 0.010036006, 0.010046493, 0.010057095, 0.010067698, 0.010078271, 0.01008893, 0.010099618, 0.010110278, 0.010120993, 0.010131768, 0.01014257, 0.010153373, 0.010164204, 0.010175035, 0.010185923, 0.010196812, 0.010207816, 0.010218704, 0.010229707, 0.010240739, 0.0102518, 0.010262831, 0.010273948, 0.010285095, 0.010296185, 0.010307416, 0.010318591, 0.010329824, 0.010341085, 0.010352375, 0.010363693, 0.010375041, 0.010386416, 0.010397734, 0.010409196, 0.010420657, 0.010432119, 0.010443609, 0.010455157, 0.010466676, 0.01047828, 0.010489886, 0.010501519, 0.010513152, 0.010524844, 0.010536592, 0.010548282, 0.010560087, 0.010571893, 0.010583699, 0.010595533, 0.010607424, 0.010619344, 0.010631235, 0.010643213, 0.010655162, 0.010667168, 0.010679231, 0.010691266, 0.010703358, 0.010715507, 0.010727656, 0.010739805, 0.010752012, 0.010764219, 0.010776425, 0.010788718, 0.010801068, 0.010813331, 0.01082571, 0.010838089, 0.010850525, 0.01086296, 0.010875396, 0.010887918, 0.010900383, 0.01091299, 0.010925541, 0.01093812, 0.010950756, 0.010963392, 0.010976058, 0.010988751, 0.011001531, 0.011014225, 0.011027061, 0.011039871, 0.011052679, 0.011065545, 0.011078467, 0.011091333, 0.011104314, 0.011117293, 0.011130302, 0.011143311, 0.011156377, 0.011169473, 0.01118251, 0.01119569, 0.011208871, 0.011221995, 0.011235233, 0.011248471, 0.011261767, 0.011275006, 0.011288358, 0.01130171, 0.011315063, 0.011328473, 0.011341883, 0.011355351, 0.011368847, 0.011382343, 0.011395867, 0.011409449, 0.011423032, 0.011436613, 0.011450253, 0.011463978, 0.011477618, 0.011491343, 0.011505096, 0.01151888, 0.011532662, 0.01154653, 0.011560399, 0.01157421, 0.011588193, 0.011602119, 0.011616046, 0.011630028, 0.011644068, 0.011658108, 0.011672149, 0.011686305, 0.011700403, 0.011714557, 0.011728712, 0.011742925, 0.011757136, 0.011771406, 0.011785676, 0.011800004, 0.011814331, 0.011828686, 0.0118431, 0.011857512, 0.011871953, 0.011886424, 0.011900923, 0.011915422, 0.011930036, 0.011944592, 0.011959177, 0.011973819, 0.01198846, 0.012003161, 0.01201786, 0.012032617, 0.012047403, 0.012062187, 0.012077001, 0.012091844, 0.012106716, 0.012121616, 0.012136516, 0.012151473, 0.012166489, 0.012181445, 0.012196518, 0.012211561, 0.012226662, 0.012241762, 0.01225692, 0.01227205, 0.012287266, 0.012302481, 0.012317725, 0.012333026, 0.012348298, 0.012363657, 0.012378986, 0.012394401, 0.012409789, 0.012425205, 0.012440708, 0.012456152, 0.012471682, 0.012487241, 0.012502801, 0.012518417, 0.012534005, 0.012549649, 0.012565352, 0.012581054, 0.012596757, 0.012612516, 0.012628305, 0.012644093, 0.012659967, 0.012675813, 0.012691716, 0.012707648, 0.012723578, 0.01273954, 0.012755529, 0.012771546, 0.012787621, 0.012803695, 0.0128198, 0.012835931, 0.012852092, 0.012868281, 0.0128845, 0.012900718, 0.012916993, 0.012933269, 0.012949602, 0.012965934, 0.012982325, 0.012998715, 0.013015133, 0.01303158, 0.013048057, 0.01306459, 0.013081096, 0.013097658, 0.013114247, 0.013130867, 0.013147514, 0.013164163, 0.013180869, 0.013197574, 0.013214337, 0.0132311, 0.01324789, 0.013264739, 0.013281588, 0.013298464, 0.013315398, 0.013332305, 0.013349268, 0.013366261, 0.013383252, 0.013400329, 0.013417378, 0.013434485, 0.013451591, 0.013468755, 0.01348592, 0.01350314, 0.013520333, 0.013537582, 0.013554889, 0.013572196, 0.013589531, 0.013606897, 0.013624289, 0.013641711, 0.013659132, 0.013676612, 0.01369412, 0.013711626, 0.013729191, 0.013746756, 0.013764379, 0.013782029, 0.013799652, 0.01381736, 0.013835069, 0.013852775, 0.013870599, 0.013888364, 0.013906187, 0.01392401, 0.013941891, 0.013959771, 0.013977707, 0.013995645, 0.01401364, 0.014031635, 0.014049659, 0.014067737, 0.014085791, 0.014103929, 0.014122066, 0.014140232, 0.014158458, 0.014176624, 0.014194904, 0.014213186, 0.014231468, 0.014249805, 0.014268144, 0.01428654, 0.014304965, 0.01432339, 0.014341843, 0.014360353, 0.014378835, 0.014397374, 0.014415942, 0.014434568, 0.014453135, 0.014471817, 0.014490471, 0.014509181, 0.014527922, 0.014546661, 0.014565459, 0.014584255, 0.01460311, 0.014621965, 0.014640847, 0.014659788, 0.014678699, 0.014697668, 0.014716695, 0.014735692, 0.014754746, 0.014773831, 0.014792914, 0.014812055, 0.014831196, 0.014850394, 0.014869592, 0.014888848, 0.014908102, 0.014927386, 0.014946728, 0.014966041, 0.01498544, 0.01500481, 0.015024266, 0.015043695, 0.015063179, 0.015082693, 0.015102205, 0.015121777, 0.015141346, 0.015160975, 0.015180603, 0.015200258, 0.015219972, 0.015239687, 0.015259429, 0.015279229, 0.015299, 0.01531883, 0.015338715, 0.015358543, 0.015378487, 0.015398401, 0.015418373, 0.015438374, 0.015458374, 0.015478432, 0.015498461, 0.015518577, 0.015538664, 0.015558836, 0.015579007, 0.015599238, 0.015619438, 0.015639696, 0.015659984, 0.01568027, 0.015700616, 0.015721016, 0.015741361, 0.015761793, 0.015782222, 0.015802681, 0.015823197, 0.015843712, 0.015864287, 0.015884832, 0.015905434, 0.015926093, 0.015946724, 0.015967442, 0.01598813, 0.016008874, 0.016029621, 0.016050423, 0.016071225, 0.016092086, 0.016112946, 0.016133836, 0.016154781, 0.016175698, 0.016196674, 0.016217705, 0.016238738, 0.016259769, 0.016280888, 0.016300226, 0.016318392, 0.016336586, 0.016354825, 0.016373092, 0.016391402, 0.01640977, 0.016428135, 0.016446605, 0.016465059, 0.016483566, 0.016502121, 0.016520703, 0.016539328, 0.016557982, 0.016576692, 0.016595447, 0.01661423, 0.016633041, 0.01665191, 0.016670791, 0.016689733, 0.016708732, 0.016727772, 0.016746769, 0.016765852, 0.016784979, 0.016804177, 0.016823404, 0.016842645, 0.016861929, 0.016881242, 0.016900612, 0.016920011, 0.016939439, 0.016958937, 0.01697845, 0.016997993, 0.017017607, 0.017037233, 0.017056905, 0.017076604, 0.017096361, 0.017116161, 0.017135963, 0.017155848, 0.017175734, 0.017195677, 0.017215662, 0.017235678, 0.017255735, 0.017275834, 0.017295994, 0.017316153, 0.017336354, 0.017356642, 0.017376898, 0.017397227, 0.017417602, 0.017438019, 0.017458463, 0.01747895, 0.017499452, 0.017520025, 0.017540628, 0.017561274, 0.017581932, 0.017602663, 0.017623425, 0.017644212, 0.017665058, 0.017685933, 0.017706849, 0.017727783, 0.017748784, 0.017769787, 0.017790863, 0.017811967, 0.017833114, 0.017854303, 0.017875507, 0.017896798, 0.01791806, 0.017939419, 0.017960796, 0.017982185, 0.018003661, 0.018025152, 0.018046686, 0.018068248, 0.018089868, 0.018111501, 0.018133221, 0.018154914, 0.018176705, 0.018198466, 0.018220343, 0.018242249, 0.018264126, 0.018286103, 0.018308097, 0.018330146, 0.018352196, 0.018374316, 0.01839648, 0.018418659, 0.018440893, 0.018463144, 0.018485464, 0.018507799, 0.018530192, 0.018552586, 0.018575065, 0.018597573, 0.018620081, 0.018642675, 0.018665297, 0.018687949, 0.018710641, 0.01873338, 0.018756131, 0.018778952, 0.018801792, 0.018824698, 0.018847607, 0.018870575, 0.018893583, 0.018916607, 0.018939702, 0.018962797, 0.018985994, 0.019009158, 0.019032411, 0.019055692, 0.019078989, 0.019102328, 0.019125737, 0.019149162, 0.019172629, 0.019196142, 0.01921968, 0.019243263, 0.019266902, 0.019290555, 0.019314239, 0.019337993, 0.01936176, 0.019385574, 0.019409427, 0.019433338, 0.019457251, 0.019481219, 0.019505246, 0.0195293, 0.019553371, 0.019577513, 0.019601652, 0.019625865, 0.019650092, 0.019674404, 0.019698689, 0.019723088, 0.019747471, 0.019771887, 0.019796371, 0.019820884, 0.019845456, 0.019870054, 0.019894697, 0.01991934, 0.019944053, 0.019968795, 0.019993596, 0.02001841, 0.020043282, 0.020068182, 0.020093109, 0.020118097, 0.020143112, 0.02016817, 0.020193256, 0.0202184, 0.020243574, 0.020268774, 0.020294018, 0.020319305, 0.020344635, 0.020369994, 0.020395409, 0.020420827, 0.020446315, 0.020471858, 0.020497406, 0.020523021, 0.020548653, 0.020574326, 0.020600043, 0.020625789, 0.020651592, 0.020677395, 0.020703269, 0.020729188, 0.020755118, 0.020781107, 0.020807154, 0.020833187, 0.020859303, 0.020885451, 0.020911612, 0.020937832, 0.020964107, 0.020990398, 0.021016702, 0.02104309, 0.02106951, 0.021095943, 0.02112242, 0.021148954, 0.02117553, 0.021202121, 0.021228783, 0.021255476, 0.021282166, 0.021308944, 0.021335749, 0.021362599, 0.021389475, 0.021416381, 0.021443317, 0.021470308, 0.021497358, 0.02152445, 0.021551512, 0.021578677, 0.021605842, 0.021633092, 0.021660384, 0.021687675, 0.021715013, 0.021742407, 0.021769814, 0.021797251, 0.021824772, 0.021852294, 0.021879874, 0.02190748, 0.021935133, 0.021962812, 0.021990536, 0.022018317, 0.022046139, 0.022073962, 0.022101855, 0.02212978, 0.022157731, 0.022185741, 0.022213764, 0.022241846, 0.02226997, 0.022298122, 0.022326317, 0.022354526, 0.022382809, 0.022411147, 0.022439472, 0.022467868, 0.022496279, 0.022524746, 0.02255323, 0.022581797, 0.02261035, 0.022638975, 0.022667645, 0.022696326, 0.022725066, 0.02275385, 0.022782661, 0.022811502, 0.022840397, 0.022869326, 0.022898281, 0.022927294, 0.022956362, 0.02298543, 0.023014557, 0.023043713, 0.023072911, 0.023102168, 0.023131438, 0.02316075, 0.023190092, 0.02321949, 0.023248931, 0.023278402, 0.023307916, 0.023337446, 0.02336706, 0.023396643, 0.023426343, 0.02345603, 0.023485815, 0.023515558, 0.023545356, 0.023575231, 0.023605131, 0.023635104, 0.023665074, 0.023695089, 0.023725133, 0.023755223, 0.023785351, 0.023815535, 0.023845725, 0.023875982, 0.02390627, 0.02393657, 0.023966974, 0.023997348, 0.024027793, 0.024058264, 0.024088766, 0.024119342, 0.024149913, 0.024180559, 0.02421122, 0.024241952, 0.024272682, 0.024303501, 0.024334304, 0.024365164, 0.024396081, 0.024427013, 0.024458002, 0.024489019, 0.024520082, 0.024551189, 0.024582304, 0.024613494, 0.024644725, 0.024675945, 0.024707235, 0.024738569, 0.024769945, 0.024801347, 0.024832794, 0.024864303, 0.024895808, 0.024927367, 0.024958974, 0.024990622, 0.0250223, 0.025054006, 0.025085768, 0.025117557, 0.025149396, 0.02518126, 0.02521318, 0.025245113, 0.025277123, 0.02530914, 0.02534122, 0.025373312, 0.025405448, 0.025437625, 0.02546986, 0.025502127, 0.025534419, 0.025566753, 0.025599118, 0.025631569, 0.025664022, 0.025696497, 0.025729021, 0.025761573, 0.025794225, 0.025826892, 0.025859557, 0.025892276, 0.025925016, 0.025957838, 0.025990691, 0.02602357, 0.026056482, 0.026089434, 0.026122442, 0.026155466, 0.026188547, 0.026221653, 0.026254807, 0.026288005, 0.026321216, 0.026354481, 0.026387807, 0.026421132, 0.026454544, 0.026487939, 0.026521407, 0.026554903, 0.026588442, 0.026622009, 0.026655635, 0.026689274, 0.026722999, 0.026756711, 0.026790466, 0.026824294, 0.026858132, 0.026892032, 0.026925957, 0.026959911, 0.026993908, 0.027027979, 0.027062021, 0.027096147, 0.027130304, 0.027164502, 0.027198756, 0.02723301, 0.027267339, 0.027301669, 0.027336067, 0.027370509, 0.027404951, 0.027439479, 0.027474007, 0.027508607, 0.027543236, 0.027577894, 0.027612578, 0.02764732, 0.027682092, 0.027716922, 0.027751766, 0.027786667, 0.027821595, 0.027856566, 0.027891584, 0.027926613, 0.027961727, 0.02799687, 0.028031999, 0.0280672, 0.028102444, 0.028137779, 0.028173063, 0.028208438, 0.028243812, 0.028279269, 0.028314758, 0.028350247, 0.028385807, 0.02842138, 0.028457023, 0.028492684, 0.028528402, 0.028564163, 0.028599923, 0.028635751, 0.028671628, 0.028707504, 0.028743478, 0.028779425, 0.028815458, 0.028851504, 0.028887596, 0.028923728, 0.028959902, 0.028996123, 0.029032353, 0.029068645, 0.029104978, 0.029141355, 0.029177759, 0.029214194, 0.029250668, 0.029287176, 0.029323751, 0.029360341, 0.02939699, 0.029433655, 0.029470373, 0.029507125, 0.029543929, 0.029580763, 0.029617628, 0.029654535, 0.029691482, 0.029728461, 0.029765466, 0.029802544, 0.029839637, 0.029876787, 0.029913953, 0.029951176, 0.029988436, 0.03002573, 0.030063068, 0.030100431, 0.030137854, 0.030175304, 0.030213609, 0.030252479, 0.030291406, 0.030330418, 0.030369455, 0.030408585, 0.030447742, 0.030486982, 0.03052628, 0.03056561, 0.030604992, 0.030644478, 0.030683964, 0.030723579, 0.030763207, 0.030802863, 0.030842634, 0.030882452, 0.030922281, 0.030962193, 0.031002179, 0.031042181, 0.031082299, 0.031122427, 0.031162629, 0.031202888, 0.03124319, 0.031283561, 0.031324022, 0.031364497, 0.031405028, 0.031445641, 0.031486318, 0.031527005, 0.031567778, 0.03160863, 0.031649504, 0.031690463, 0.031731453, 0.031772517, 0.031813633, 0.031854808, 0.031896044, 0.031937357, 0.031978678, 0.032020099, 0.032061547, 0.032103054, 0.032144643, 0.032186277, 0.032227971, 0.032269705, 0.032311521, 0.032353356, 0.032395307, 0.032437272, 0.032479309, 0.032521401, 0.032563534, 0.032605745, 0.032648038, 0.032690343, 0.03273271, 0.032775149, 0.032817669, 0.03286019, 0.032902814, 0.03294548, 0.032988187, 0.033030983, 0.033073805, 0.033116717, 0.033159655, 0.033202648, 0.033245716, 0.033288855, 0.03333202, 0.033375304, 0.0334186, 0.033461899, 0.033505321, 0.033548787, 0.033592343, 0.033635911, 0.033679567, 0.03372325, 0.033766992, 0.033810828, 0.033854701, 0.033898614, 0.033942569, 0.033986636, 0.03403075, 0.034074876, 0.034119088, 0.034163374, 0.034207702, 0.034252085, 0.034296516, 0.034341015, 0.034385554, 0.034430198, 0.034474842, 0.034519602, 0.034564357, 0.034609213, 0.034654099, 0.03469909, 0.034744076, 0.034789134, 0.034834281, 0.034879453, 0.034924712, 0.03497, 0.035015374, 0.03506076, 0.035106264, 0.035151765, 0.03519737, 0.035243001, 0.035288714, 0.035334464, 0.035380267, 0.035426155, 0.035472114, 0.035518065, 0.03556411, 0.035610229, 0.035656404, 0.035702609, 0.035748873, 0.035795204, 0.03584158, 0.035888057, 0.035934534, 0.035981115, 0.036027715, 0.036074378, 0.03612113, 0.036167949, 0.036214769, 0.036261644, 0.036308624, 0.036355633, 0.036402743, 0.03644985, 0.036497068, 0.036544319, 0.036591601, 0.036638949, 0.036686402, 0.036733881, 0.036781449, 0.036829039, 0.036876649, 0.036924388, 0.036972169, 0.037019964, 0.037067827, 0.037115782, 0.037163761, 0.037211843, 0.037259925, 0.037308108, 0.037356317, 0.037404615, 0.037452921, 0.037501335, 0.037549775, 0.037598271, 0.037646856, 0.037695479, 0.037744164, 0.037792888, 0.037841689, 0.037890542, 0.03793947, 0.037988394, 0.038037449, 0.038086534, 0.038135663, 0.038184863, 0.03823413, 0.038283419, 0.038332801, 0.038382214, 0.038431685, 0.038481258, 0.038530871, 0.038580503, 0.038630188, 0.038679987, 0.038729787, 0.038779702, 0.038829617, 0.038879622, 0.038929678, 0.038979765, 0.039029967, 0.039080199, 0.039130457, 0.039180789, 0.039231218, 0.039281677, 0.039332177, 0.039382756, 0.039433386, 0.039484072, 0.039534833, 0.039585594, 0.039636485, 0.039687388, 0.039738365, 0.039789382, 0.03984049, 0.039891638, 0.039942872, 0.039994087, 0.040045377, 0.040096771, 0.040148173, 0.040199723, 0.040251274, 0.040302865, 0.040354513, 0.040406264, 0.040457997, 0.040509846, 0.040561739, 0.040613659, 0.040665694, 0.040717773, 0.040769868, 0.040822029, 0.040874295, 0.040926591, 0.040978923, 0.04103132, 0.041083783, 0.041136295, 0.041188888, 0.041241512, 0.041294221, 0.041346956, 0.041399766, 0.04145262, 0.041505542, 0.041558523, 0.041611534, 0.041664645, 0.041717783, 0.041771021, 0.041824248, 0.041877583, 0.041930955, 0.041984409, 0.042037889, 0.042091459, 0.042145059, 0.042198725, 0.042252451, 0.042306192, 0.04236006, 0.042413976, 0.0424679, 0.042521898, 0.042575985, 0.04263011, 0.042684294, 0.042738523, 0.042792823, 0.042847168, 0.042901594, 0.042956036, 0.043010581, 0.043065149, 0.043119792, 0.043174498, 0.043229267, 0.043284066, 0.043338925, 0.043393843, 0.043448854, 0.043503884, 0.043558944, 0.043614134, 0.043669362, 0.043724608, 0.043779925, 0.043835327, 0.043890774, 0.043946303, 0.044001836, 0.044057466, 0.044113126, 0.044168875, 0.044224635, 0.044280466, 0.044336401, 0.044392347, 0.044448365, 0.044504412, 0.044560559, 0.044616736, 0.044672985, 0.044729274, 0.044785663, 0.044842042, 0.044898521, 0.044955067, 0.045011658, 0.045068294, 0.045125, 0.045181748, 0.045238599, 0.045295466, 0.04535237, 0.045409363, 0.045466412, 0.045523521, 0.045580685, 0.045637906, 0.045695156, 0.045752507, 0.045809887, 0.045867354, 0.045924831, 0.045982413, 0.046040006, 0.046097703, 0.046155423, 0.046213206, 0.046271071, 0.046328969, 0.046386924, 0.046444945, 0.046503026, 0.046561167, 0.046619367, 0.046677586, 0.046735898, 0.046794269, 0.046852708, 0.046911173, 0.046969686, 0.047028299, 0.047086965, 0.047145668, 0.047204409, 0.047263246, 0.047322132, 0.047381058, 0.047440056, 0.047499109, 0.047558211, 0.047617428, 0.047676578, 0.047735881, 0.047795221, 0.047854591, 0.047914095, 0.047973588, 0.048033163, 0.048092779, 0.048152495, 0.048212208, 0.048272025, 0.048331864, 0.048391778, 0.048451725, 0.048511785, 0.048571832, 0.048631977, 0.048692193, 0.048752449, 0.048812751, 0.048873112, 0.048933543, 0.048994064, 0.049054578, 0.049115155, 0.04917581, 0.049236532, 0.049297322, 0.049358141, 0.049419012, 0.049479943, 0.049540978, 0.049601998, 0.049663141, 0.049724307, 0.049785495, 0.049846806, 0.049908154, 0.049969558, 0.05003101, 0.050092541, 0.050154105, 0.050215736, 0.050277416, 0.050339151, 0.050400943, 0.050462835, 0.05052473, 0.050586693, 0.050648734, 0.050710838, 0.050772991, 0.050835155, 0.050897431, 0.050959766, 0.051022135, 0.051084545, 0.051147051, 0.051209576, 0.051272195, 0.05133485, 0.051397558, 0.051460341, 0.051523164, 0.051586062, 0.051649041, 0.051712018, 0.051775072, 0.051838227, 0.05190137, 0.051964603, 0.052027885, 0.052091256, 0.052154668, 0.052218162, 0.052281652, 0.052345246, 0.052408844, 0.052472569, 0.052536312, 0.052600108, 0.052663982, 0.052727938, 0.05279189, 0.052855916, 0.052920017, 0.052984156, 0.053048383, 0.053112641, 0.053176973, 0.053241327, 0.053305756, 0.053370271, 0.053434823, 0.053499412, 0.053564087, 0.053628832, 0.053693619, 0.053758442, 0.053823303, 0.053888287, 0.053953275, 0.054018367, 0.054083481, 0.054148655, 0.054213885, 0.054279212, 0.054344531, 0.054409984, 0.054475442, 0.054540973, 0.054606549, 0.054672167, 0.054737866, 0.054803628, 0.054869443, 0.05493531, 0.05500124, 0.055067245, 0.055133294, 0.05519937, 0.055265531, 0.055331737, 0.05539801, 0.05546435, 0.055530708, 0.055597156, 0.05566366, 0.055730198, 0.055796832, 0.055863496, 0.055930205, 0.055997025, 0.056063876, 0.056130767, 0.056197703, 0.056264739, 0.056331817, 0.056398924, 0.056466103, 0.05653337, 0.056600679, 0.056668043, 0.056735434, 0.056803733, 0.056873392, 0.056943074, 0.057012789, 0.05708262, 0.057152506, 0.057222456, 0.057292413, 0.057362515, 0.05743264, 0.057502776, 0.057573035, 0.05764338, 0.057713754, 0.057784162, 0.057854649, 0.057925209, 0.057995822, 0.058066543, 0.058137245, 0.058208067, 0.058278956, 0.058349859, 0.058420852, 0.058491942, 0.058563057, 0.058634207, 0.058705442, 0.058776792, 0.058848124, 0.05891956, 0.058991037, 0.059062582, 0.059134204, 0.059205886, 0.059277616, 0.059349414, 0.05942129, 0.059493225, 0.059565194, 0.059637256, 0.059709363, 0.059781525, 0.059853766, 0.059926074, 0.059998434, 0.060070865, 0.060143296, 0.060215864, 0.060288493, 0.060361154, 0.060433879, 0.060506701, 0.060579557, 0.06065245, 0.060725462, 0.060798485, 0.060871609, 0.060944777, 0.06101796, 0.0610913, 0.061164644, 0.061238069, 0.061311539, 0.061385062, 0.061458688, 0.06153233, 0.061606068, 0.06167987, 0.061753727, 0.061827607, 0.061901592, 0.061975654, 0.062049732, 0.062123906, 0.062198132, 0.062272433, 0.062346745, 0.062421177, 0.062495664, 0.062570177, 0.06264478, 0.062719442, 0.062794164, 0.062868923, 0.062943816, 0.063018702, 0.063093655, 0.063168727, 0.063243806, 0.06331896, 0.063394181, 0.063469492, 0.063544802, 0.063620202, 0.063695677, 0.063771211, 0.063846797, 0.063922442, 0.063998178, 0.06407395, 0.064149804, 0.064225711, 0.064301655, 0.064377688, 0.064453781, 0.064529926, 0.0646061, 0.064682402, 0.064758755, 0.064835131, 0.064911604, 0.064988159, 0.065064728, 0.065141343, 0.065218069, 0.065294854, 0.065371707, 0.06544856, 0.065525547, 0.065602593, 0.065679625, 0.065756805, 0.065834008, 0.065911293, 0.06598863, 0.066065975, 0.066143446, 0.066220991, 0.066298567, 0.066376172, 0.066453911, 0.066531688, 0.066609487, 0.066687383, 0.066765368, 0.066843376, 0.066921428, 0.06699957, 0.067077801, 0.067156039, 0.067234352, 0.067312755, 0.067391209, 0.067469724, 0.067548297, 0.067626931, 0.067705631, 0.067784391, 0.067863196, 0.06794212, 0.068021059, 0.068100087, 0.068179138, 0.068258286, 0.068337463, 0.068416707, 0.068496048, 0.068575412, 0.06865488, 0.068734363, 0.068813972, 0.068893589, 0.06897328, 0.069053039, 0.069132842, 0.06921275, 0.069292694, 0.069372676, 0.069452733, 0.069532849, 0.069613069, 0.069693319, 0.069773644, 0.069853991, 0.069934443, 0.070014954, 0.070095502, 0.070176125, 0.070256844, 0.070337586, 0.070418358, 0.070499249, 0.070580214, 0.070661172, 0.070742264, 0.070823386, 0.070904598, 0.070985794, 0.071067147, 0.071148477, 0.071229927, 0.071311451, 0.071392991, 0.071474612, 0.071556292, 0.071638048, 0.071719848, 0.071801707, 0.071883671, 0.071965635, 0.072047681, 0.072129808, 0.072212018, 0.07229422, 0.072376549, 0.072458901, 0.072541341, 0.072623819, 0.072706386, 0.072788976, 0.072871655, 0.072954416, 0.073037207, 0.073120065, 0.07320299, 0.073285982, 0.073369041, 0.073452123, 0.073535331, 0.073618554, 0.073701806, 0.073785193, 0.073868647, 0.073952131, 0.074035659, 0.074119285, 0.074202955, 0.074286677, 0.074370474, 0.074454337, 0.074538261, 0.074622244, 0.074706286, 0.074790359, 0.074874572, 0.074958801, 0.07504306, 0.075127415, 0.07521186, 0.075296335, 0.075380847, 0.075465478, 0.075550146, 0.075634852, 0.075719669, 0.075804546, 0.075889438, 0.075974405, 0.076059431, 0.076144516, 0.076229714, 0.076314919, 0.07640022, 0.076485559, 0.076570958, 0.076656483, 0.076741979, 0.076827586, 0.076913275, 0.076998949, 0.077084757, 0.077170618, 0.077256531, 0.077342473, 0.077428505, 0.077514604, 0.077600755, 0.077686988, 0.077773243, 0.077859603, 0.077946022, 0.078032471, 0.07811901, 0.078205615, 0.078292266, 0.078378983, 0.078465752, 0.078552604, 0.078639507, 0.07872647, 0.078813471, 0.078900561, 0.07898774, 0.079074964, 0.079162195, 0.079249531, 0.079336964, 0.079424396, 0.07951194, 0.079599552, 0.0796872, 0.079774864, 0.079862691, 0.079950519, 0.080038384, 0.08012636, 0.080214359, 0.080302462, 0.080390625, 0.080478832, 0.080567062, 0.080655396, 0.080743842, 0.080832273, 0.080920793, 0.081009381, 0.08109802, 0.081186719, 0.081275478, 0.081364341, 0.081453182, 0.081542142, 0.081631169, 0.081720248, 0.081809387, 0.0818986, 0.081987858, 0.082077183, 0.08216656, 0.082256027, 0.08234553, 0.082435116, 0.082524769, 0.082614444, 0.082704179, 0.082794033, 0.082883924, 0.082973875, 0.083063856, 0.083153956, 0.083244093, 0.083334267, 0.083424553, 0.083514884, 0.08360526, 0.08369571, 0.083786219, 0.083876789, 0.083967417, 0.084058113, 0.084148824, 0.084239684, 0.084330574, 0.084421508, 0.084512502, 0.08460357, 0.084694713, 0.084785879, 0.084877141, 0.08496847, 0.085059851, 0.085151255, 0.085242763, 0.085334368, 0.085425965, 0.085517652, 0.085609391, 0.085701257, 0.085793093, 0.085885055, 0.08597704, 0.086069092, 0.086161241, 0.086253405, 0.086345658, 0.086437985, 0.086530365, 0.086622767, 0.086715296, 0.086807862, 0.086900458, 0.086993121, 0.087085873, 0.087178715, 0.087271571, 0.087364495, 0.087457471, 0.087550543, 0.087643668, 0.087736838, 0.087830074, 0.087923385, 0.088016756, 0.088110186, 0.088203669, 0.08829724, 0.08839085, 0.088484533, 0.088578232, 0.088672049, 0.088765919, 0.088859811, 0.0889538, 0.089047879, 0.089141995, 0.08923614, 0.089330412, 0.089424729, 0.089519024, 0.08961349, 0.089707986, 0.089802533, 0.089897141, 0.089991823, 0.09008652, 0.090181351, 0.090276212, 0.090371087, 0.090466097, 0.090561174, 0.090656243, 0.090751395, 0.09084665, 0.090941958, 0.091037288, 0.0911327, 0.091228209, 0.091323741, 0.091419332, 0.091514997, 0.091610737, 0.091706507, 0.091802374, 0.091898285, 0.091994256, 0.092090294, 0.092186444, 0.092282563, 0.09237878, 0.092475101, 0.092571422, 0.09266784, 0.092764311, 0.09286087, 0.092957452, 0.093054071, 0.093150854, 0.093247637, 0.093344472, 0.093441382, 0.093538359, 0.09363538, 0.093732476, 0.093829632, 0.093926847, 0.094024144, 0.094121493, 0.094218895, 0.094316348, 0.094413906, 0.094511487, 0.094609112, 0.094706833, 0.094804622, 0.094902471, 0.095000356, 0.095098339, 0.095196389, 0.095294423, 0.0953926, 0.095490836, 0.095589109, 0.095687434, 0.095785841, 0.095884316, 0.09598279, 0.096081421, 0.096180029, 0.096278794, 0.096377559, 0.096476391, 0.096575275, 0.096674249, 0.096773282, 0.096872345, 0.096971482, 0.097070724, 0.097169988, 0.097269304, 0.097368725, 0.097468197, 0.09756767, 0.097667262, 0.097766899, 0.097866617, 0.09796638, 0.098066196, 0.098166086, 0.098266058, 0.098366067, 0.098466158, 0.098566294, 0.098666489, 0.098766759, 0.098867081, 0.098967485, 0.099067934, 0.099168427, 0.099269025, 0.099371046, 0.099474594, 0.099578142, 0.09968175, 0.099785455, 0.099889144, 0.099992901, 0.1000967, 0.10020056, 0.10030443, 0.10040839, 0.10051239, 0.10061639, 0.10072049, 0.10082462, 0.10092881, 0.10103302, 0.10113732, 0.10124165, 0.10134599, 0.10145042, 0.10155489, 0.10165942, 0.10176396, 0.10186856, 0.10197322, 0.1020779, 0.10218266, 0.10228748, 0.10239233, 0.10249719, 0.10260215, 0.10270713, 0.10281215, 0.10291726, 0.10302236, 0.10312754, 0.10323277, 0.10333804, 0.10344334, 0.10354871, 0.10365412, 0.10375956, 0.10386508, 0.10397064, 0.10407624, 0.10418189, 0.10428756, 0.1043933, 0.1044991, 0.10460494, 0.10471084, 0.10481678, 0.10492276, 0.10502877, 0.10513487, 0.10524096, 0.10534713, 0.10545335, 0.10555962, 0.10566591, 0.10577228, 0.10587869, 0.10598511, 0.10609163, 0.10619819, 0.10630477, 0.10641138, 0.10651814, 0.10662483, 0.10673162, 0.10683846, 0.10694534, 0.10705223, 0.1071592, 0.10726627, 0.10737331, 0.10748041, 0.1075876, 0.1076948, 0.10780205, 0.10790937, 0.10801674, 0.1081241, 0.10823154, 0.10833906, 0.10844658, 0.10855416, 0.10866182, 0.10876949, 0.1088772, 0.108985, 0.10909282, 0.10920067, 0.10930859, 0.10941656, 0.10952457, 0.10963263, 0.10974075, 0.1098489, 0.10995709, 0.11006538, 0.11017365, 0.110282, 0.11039038, 0.11049887, 0.11060731, 0.11071583, 0.11082444, 0.11093306, 0.11104175, 0.11115046, 0.11125925, 0.11136805, 0.11147691, 0.11158585, 0.11169478, 0.11180378, 0.11191286, 0.11202197, 0.11213107, 0.11224028, 0.11234953, 0.1124588, 0.11256815, 0.11267754, 0.11278697, 0.11289645, 0.11300599, 0.11311557, 0.11322518, 0.11333485, 0.11344457, 0.11355433, 0.11366412, 0.113774, 0.11388391, 0.11399384, 0.11410386, 0.11421391, 0.114324, 0.11443417, 0.11454436, 0.11465456, 0.11476488, 0.11487518, 0.11498556, 0.11509597, 0.11520645, 0.11531699, 0.11542755, 0.11553817, 0.11564884, 0.11575954, 0.11587029, 0.1159811, 0.11609197, 0.11620286, 0.11631379, 0.1164248, 0.11653583, 0.11664692, 0.11675808, 0.11686925, 0.11698046, 0.11709175, 0.11720308, 0.11731443, 0.11742588, 0.11753731, 0.11764886, 0.1177604, 0.11787199, 0.11798366, 0.11809537, 0.11820713, 0.11831891, 0.11843078, 0.11854266, 0.11865462, 0.11876661, 0.11887863, 0.11899071, 0.11910284, 0.119215, 0.11932722, 0.11943951, 0.1195518, 0.11966418, 0.11977661, 0.11988904, 0.12000158, 0.12011413, 0.12022673, 0.12033939, 0.12045208, 0.12056483, 0.12067761, 0.12079044, 0.12090334, 0.12101627, 0.12112927, 0.12124228, 0.12135538, 0.12146849, 0.12158166, 0.12169486, 0.12180813, 0.12192145, 0.12203481, 0.12214822, 0.12226167, 0.12237516, 0.12248871, 0.12260232, 0.12271595, 0.12282964, 0.12294336, 0.12305715, 0.12317101, 0.12328487, 0.12339883, 0.12351277, 0.12362682, 0.12374087, 0.12385496, 0.12396916, 0.12408335, 0.12419764, 0.12431194, 0.1244263, 0.1245407, 0.12465513, 0.12476964, 0.12488417, 0.12499876, 0.1251134, 0.12522809, 0.1253428, 0.12545757, 0.12557243, 0.12568729, 0.12580222, 0.12591717, 0.12603219, 0.12614726, 0.12626235, 0.12637751, 0.12649271, 0.12660797, 0.12672326, 0.12683861, 0.12695403, 0.12706949, 0.12718494, 0.12730049, 0.12741609, 0.12753169, 0.1276474, 0.12776311, 0.12787889, 0.1279947, 0.12811054, 0.12822649, 0.12834243, 0.12845844, 0.12857451, 0.12869063, 0.12880674, 0.12892295, 0.1290392, 0.12915547, 0.12927185, 0.12938823, 0.12950467, 0.12962112, 0.12973765, 0.12985425, 0.12997086, 0.13008754, 0.13020425, 0.13032103, 0.13043784, 0.13055468, 0.13067161, 0.13078855, 0.13090555, 0.1310226, 0.1311397, 0.13125685, 0.13137406, 0.13149127, 0.13160856, 0.13172591, 0.13184327, 0.1319607, 0.1320782, 0.13219571, 0.13231328, 0.1324309, 0.13254856, 0.13266625, 0.13278405, 0.13290185, 0.13301972, 0.1331376, 0.13325554, 0.13337356, 0.13349159, 0.13360967, 0.13372782, 0.133846, 0.13396423, 0.13408251, 0.13420084, 0.1343192, 0.13443764, 0.1345561, 0.13467464, 0.13479319, 0.13491179, 0.13503045, 0.13514914, 0.1352679, 0.13538672, 0.13550557, 0.13562444, 0.13574342, 0.13586241, 0.13598143, 0.13610052, 0.13621965, 0.13633884, 0.13645805, 0.13657734, 0.13669665, 0.13681601, 0.13693543, 0.13705489, 0.1371744, 0.13729395, 0.13741356, 0.1375332, 0.13765289, 0.13777265, 0.13789245, 0.13801228, 0.13813217, 0.13825212, 0.13837209, 0.13849211, 0.13861221, 0.13873233, 0.13885251, 0.13897273, 0.139093, 0.13921331, 0.13933367, 0.13945407, 0.13957451, 0.13969505, 0.13981557, 0.13993619, 0.14005685, 0.14017755, 0.14029826, 0.14041905, 0.14053988, 0.14066078, 0.14078172, 0.14090267, 0.1410237, 0.14114477, 0.14126588, 0.14138705, 0.14150827, 0.14162952, 0.14175083, 0.1418722, 0.1419936, 0.14211504, 0.14223653, 0.14235809, 0.14247969, 0.14260131, 0.14272302, 0.14284474, 0.14296651, 0.14308834, 0.1432102, 0.14333214, 0.1434541, 0.14357613, 0.14369819, 0.14382029, 0.14394248, 0.14406466, 0.14418693, 0.14430922, 0.14443159, 0.14455396, 0.14467643, 0.1447989, 0.14492147, 0.14504406, 0.14516668, 0.14528936, 0.14541209, 0.14553487, 0.14565769, 0.14578055, 0.14590345, 0.1460264, 0.14614943, 0.14627248, 0.14639561, 0.14651877, 0.14664194, 0.1467652, 0.14688848, 0.14701182, 0.14713523, 0.14725867, 0.14738214, 0.14750566, 0.14762925, 0.14775287, 0.14787656, 0.14800029, 0.14812405, 0.14824785, 0.14837171, 0.14849566, 0.14861959, 0.14874361, 0.14886767, 0.14899176, 0.14911589, 0.14924011, 0.14936432, 0.14948861, 0.14961296, 0.14973733, 0.14986178, 0.14998624, 0.15011077, 0.15023534, 0.15035996, 0.15048464, 0.15060933, 0.1507341, 0.15085891, 0.15098378, 0.15110868, 0.15123361, 0.15135863, 0.15148365, 0.15160877, 0.15173391, 0.1518591, 0.15198432, 0.15210959, 0.15223494, 0.15236031, 0.15248576, 0.1526112, 0.15273674, 0.1528623, 0.15298788, 0.15311359, 0.15323927, 0.15336502, 0.15349083, 0.1536167, 0.15374258, 0.15386854, 0.1539945, 0.15412056, 0.15424666, 0.15437277, 0.15449896, 0.15462519, 0.15475146, 0.15487778, 0.15500414, 0.15513057, 0.15525703, 0.15538354, 0.1555101, 0.15563671, 0.15576337, 0.15589006, 0.15601681, 0.15614359, 0.15627046, 0.15639734, 0.15652429, 0.15665127, 0.15677829, 0.15690538, 0.1570342, 0.15716428, 0.15729436, 0.15742446, 0.15755455, 0.15768465, 0.15781477, 0.15794489, 0.15807503, 0.15820518, 0.15833534, 0.15846549, 0.15859568, 0.15872586, 0.15885603, 0.15898626, 0.15911645, 0.15924667, 0.15937692, 0.15950714, 0.15963739, 0.15976763, 0.15989791, 0.16002817, 0.16015847, 0.16028877, 0.16041909, 0.16054942, 0.16067971, 0.16081007, 0.16094039, 0.16107075, 0.16120112, 0.16133149, 0.16146186, 0.16159225, 0.16172266, 0.16185305, 0.16198349, 0.16211389, 0.16224435, 0.16237478, 0.16250522, 0.1626357, 0.16276616, 0.16289665, 0.16302715, 0.16315766, 0.16328816, 0.16341868, 0.16354921, 0.16367973, 0.16381033, 0.16394088, 0.16407146, 0.16420202, 0.16433261, 0.16446321, 0.1645938, 0.16472444, 0.16485503, 0.16498569, 0.16511633, 0.16524698, 0.16537765, 0.1655083, 0.165639, 0.16576968, 0.16590039, 0.16603109, 0.16616182, 0.16629253, 0.16642326, 0.16655402, 0.16668476, 0.16681555, 0.16694631, 0.16707712, 0.16720791, 0.1673387, 0.16746952, 0.16760035, 0.1677312, 0.16786201, 0.16799287, 0.16812374, 0.1682546, 0.16838548, 0.16851637, 0.16864726, 0.16877817, 0.16890909, 0.16904001, 0.16917096, 0.16930188, 0.16943283, 0.16956381, 0.16969478, 0.16982578, 0.16995676, 0.17008775, 0.17021878, 0.17034979, 0.17048083, 0.17061186, 0.17074293, 0.17087397, 0.17100506, 0.17113613, 0.17126718, 0.17139831, 0.1715294, 0.17166051, 0.17179163, 0.17192277, 0.1720539, 0.17218505, 0.17231622, 0.17244738, 0.17257857, 0.17270976, 0.17284095, 0.17297216, 0.17310339, 0.17323461, 0.17336586, 0.17349711, 0.17362837, 0.17375964, 0.1738909, 0.1740222, 0.17415349, 0.17428477, 0.1744161, 0.1745474, 0.17467874, 0.17481008, 0.17494145, 0.17507277, 0.17520414, 0.17533553, 0.17546691, 0.17559832, 0.17572972, 0.17586114, 0.17599256, 0.17612398, 0.17625543, 0.17638688, 0.17651835, 0.17664982, 0.17678131, 0.17691281, 0.17704432, 0.1771758, 0.17730734, 0.17743887, 0.17757039, 0.17770195, 0.1778335, 0.17796507, 0.17809662, 0.17822821, 0.17835982, 0.17849141, 0.17862305, 0.17875466, 0.17888629, 0.17901793, 0.17914957, 0.17928123, 0.1794129, 0.1795446, 0.17967626, 0.17980798, 0.17993967, 0.18007138, 0.18020314, 0.18033487, 0.18046661, 0.18059835, 0.18073015, 0.18086191, 0.18099368, 0.18112548, 0.18125726, 0.18138909, 0.18152091, 0.18165274, 0.18178457, 0.1819164, 0.18204828, 0.18218014, 0.18231203, 0.1824439, 0.18257582, 0.1827077, 0.18283962, 0.18297155, 0.18310346, 0.18323542, 0.18336737, 0.18349935, 0.18363132, 0.18376331, 0.18389529, 0.18402727, 0.18415928, 0.18429129, 0.18442334, 0.18455537, 0.18468742, 0.18481947, 0.18495153, 0.18508363, 0.18521568, 0.18534778, 0.18547988, 0.18561202, 0.18574411, 0.18587624, 0.18600838, 0.18614052, 0.18627271, 0.18640485, 0.18653704, 0.18666923, 0.18680142, 0.18693365, 0.18706584, 0.18719809, 0.18733031, 0.18746257, 0.1875948, 0.18772708, 0.18785934, 0.18799162, 0.18812391, 0.1882562, 0.18838851, 0.18852083, 0.18865317, 0.18878551, 0.18891783, 0.1890502, 0.18918256, 0.18931498, 0.18944733, 0.18957974, 0.18971214, 0.18984452, 0.18997698, 0.1901094, 0.19024186, 0.19037428, 0.19050676, 0.19063924, 0.19077168, 0.19090419, 0.19103669, 0.1911692, 0.1913017, 0.19143425, 0.19156677, 0.19169931, 0.19183187, 0.19196443, 0.19209702, 0.19222957, 0.19236219, 0.19249478, 0.19262737, 0.19275999, 0.19289263, 0.19302528, 0.19315793, 0.19329061, 0.19342329, 0.19355595, 0.19368863, 0.19382131, 0.19395402, 0.19408675, 0.19421946, 0.19435218, 0.19448495, 0.19461769, 0.19475043, 0.19488323, 0.195016, 0.19514878, 0.19528157, 0.19541439, 0.19554722, 0.19568001, 0.19581288, 0.1959457, 0.19607857, 0.19621141, 0.19634432, 0.19647719, 0.19661009, 0.19674301, 0.19687589, 0.19700882, 0.19714177, 0.1972747, 0.19740763, 0.19754058, 0.19767356, 0.19780655, 0.19793953, 0.19807252, 0.19820555, 0.19833855, 0.19847159, 0.19860461, 0.19873764, 0.19887072, 0.19900377, 0.19913684, 0.19926992, 0.19940302, 0.1995361, 0.19966923, 0.19980234, 0.19993547, 0.20006862, 0.20020176, 0.20033495, 0.20046808, 0.20060125, 0.20073445, 0.20086764, 0.20100084, 0.20113406, 0.2012673, 0.2014005, 0.20153373, 0.20166701, 0.20180026, 0.2019335, 0.20206681, 0.2022001, 0.20233339, 0.20246668, 0.20260003, 0.20273334, 0.20286666, 0.20299999, 0.20313336, 0.20326674, 0.20340011, 0.20353352, 0.20366688, 0.20380031, 0.2039337, 0.20406711, 0.20420054, 0.20433398, 0.20446745, 0.20460092, 0.20473439, 0.20486785, 0.20500132, 0.20513479, 0.20526832, 0.20540184, 0.20553535, 0.20566888, 0.20580246, 0.20593598, 0.20606954, 0.2062031, 0.20633668, 0.20647028, 0.20660388, 0.2067375, 0.20687114, 0.20700474, 0.20713839, 0.20727202, 0.20740569, 0.20753933, 0.20767303, 0.20780672, 0.2079404, 0.20807409, 0.2082078, 0.20834154, 0.20847526, 0.20860901, 0.20874274, 0.20887649, 0.20901027, 0.20914404, 0.20927784, 0.20941162, 0.20954545, 0.20967925, 0.20981307, 0.2099469, 0.21008076, 0.2102146, 0.21034847, 0.21048234, 0.21061623, 0.2107501, 0.21088402, 0.21101794, 0.21115185, 0.21128577, 0.2114197, 0.21155366, 0.21168761, 0.21182159, 0.21195556, 0.21208952, 0.21222353, 0.21235754, 0.21249156, 0.21262558, 0.21275961, 0.21289364, 0.21302769, 0.21316178, 0.21329582, 0.21342991, 0.21356401, 0.2136981, 0.2138322, 0.21396631, 0.21410045, 0.21423461, 0.21436875, 0.21450287, 0.21463706, 0.21477124, 0.2149054, 0.2150396, 0.21517378, 0.21530801, 0.21544221, 0.21557645, 0.21571068, 0.21584494, 0.2159792, 0.21611345, 0.21624774, 0.21638203, 0.21651635, 0.21665061, 0.21678495, 0.21691926, 0.21705359, 0.21718793, 0.21732229, 0.21745667, 0.21759103, 0.21772541, 0.21785979, 0.2179942, 0.21812859, 0.21826302, 0.21839744, 0.21853189, 0.21866633, 0.21880075, 0.21893524, 0.21906972, 0.21920422, 0.2193387, 0.2194732, 0.21960773, 0.21974222, 0.21987675, 0.22001129, 0.22014587, 0.22028041, 0.22041498, 0.22054957, 0.22068414, 0.22081873, 0.22095335, 0.22108798, 0.22122259, 0.22135721, 0.22149186, 0.22162651, 0.22176118, 0.22189584, 0.22203052, 0.22216523, 0.22229992, 0.22243465, 0.22256936, 0.22270408, 0.2228388, 0.22297354, 0.22310831, 0.22324374, 0.22337933, 0.22351483, 0.22365029, 0.22378571, 0.22392109, 0.22405645, 0.22419176, 0.224327, 0.22446221, 0.22459738, 0.22473252, 0.22486758, 0.2250026, 0.22513761, 0.22527257, 0.22540745, 0.22554234, 0.22567715, 0.2258119, 0.22594665, 0.22608134, 0.22621599, 0.22635058, 0.22648515, 0.22661969, 0.22675413, 0.22688854, 0.22702293, 0.22715729, 0.22729157, 0.22742583, 0.22756004, 0.2276942, 0.22782834, 0.22796237, 0.22809643, 0.22823043, 0.22836439, 0.22849827, 0.22863214, 0.22876596, 0.22889972, 0.22903344, 0.22916713, 0.22930078, 0.22943439, 0.22956792, 0.22970146, 0.22983493, 0.22996834, 0.23010172, 0.23023504, 0.23036836, 0.23050158, 0.23063479, 0.23076795, 0.23090106, 0.23103414, 0.2311672, 0.23130018, 0.23143314, 0.23156604, 0.23169889, 0.2318317, 0.23196445, 0.23209721, 0.2322299, 0.23236252, 0.23249511, 0.23262766, 0.23276018, 0.23289265, 0.23302506, 0.23315744, 0.23328979, 0.23342207, 0.23355435, 0.23368654, 0.23381868, 0.23395081, 0.23408288, 0.23421493, 0.2343469, 0.23447883, 0.23461074, 0.23474258, 0.2348744, 0.23500617, 0.23513791, 0.23526959, 0.23540123, 0.23553281, 0.23566435, 0.23579586, 0.23592734, 0.23605877, 0.23619014, 0.23632146, 0.23645276, 0.23658399, 0.23671518, 0.23684636, 0.23697749, 0.23710854, 0.23723957, 0.23737055, 0.23750149, 0.23763239, 0.23776326, 0.23789407, 0.23802483, 0.23815556, 0.23828624, 0.23841688, 0.23854744, 0.23867802, 0.23880853, 0.23893896, 0.2390694, 0.23919977, 0.2393301, 0.23946038, 0.23959062, 0.23972082, 0.23985097, 0.23998107, 0.24011116, 0.24024118, 0.24037117, 0.24050109, 0.24063101, 0.24076086, 0.24089065, 0.24102046, 0.24115016, 0.24127984, 0.24140948, 0.24153906, 0.24166858, 0.24179809, 0.24192755, 0.24205698, 0.24218635, 0.24231569, 0.24244496, 0.24257419, 0.24270341, 0.24283256, 0.24296166, 0.24309075, 0.24321975, 0.24334875, 0.24347766, 0.24360657, 0.2437354, 0.24386421, 0.24399298, 0.2441217, 0.24425039, 0.244379, 0.2445076, 0.24463616, 0.24476467, 0.24489309, 0.24502151, 0.2451499, 0.24527819, 0.24540646, 0.24553472, 0.24566291, 0.24579106, 0.24591918, 0.24604727, 0.24617527, 0.24630325, 0.24643119, 0.24655908, 0.24668692, 0.24681473, 0.24694248, 0.24707019, 0.24719787, 0.24732551, 0.24745311, 0.24758063, 0.24770814, 0.24783559, 0.247963, 0.24809036, 0.24821769, 0.24834497, 0.2484722, 0.24859938, 0.24872658, 0.24885367, 0.24898073, 0.24910776, 0.24923472, 0.24936168, 0.24948855, 0.24961539, 0.24974221, 0.24986894, 0.24999568, 0.25012234, 0.25024897, 0.25037554, 0.25050208, 0.25062859, 0.25075504, 0.25088143, 0.25100783, 0.25113413, 0.2512604, 0.25138667, 0.25151283, 0.25163898, 0.2517651, 0.25189114, 0.25201717, 0.25214314, 0.25226906, 0.25239494, 0.2525208, 0.2526466, 0.25277236, 0.25289807, 0.25302371, 0.25314936, 0.25327495, 0.25340047, 0.25352597, 0.25365144, 0.25377682, 0.2539022, 0.25402755, 0.25415277, 0.25427803, 0.2544032, 0.25452837, 0.25465348, 0.25477853, 0.25490355, 0.25502852, 0.25515342, 0.25527832, 0.25540319, 0.25552797, 0.25565273, 0.25577742, 0.25590211, 0.25602672, 0.25615129, 0.25627586, 0.25640035, 0.25652477, 0.25664917, 0.25677353, 0.25689787, 0.25702214, 0.25714639, 0.25727057, 0.25739467, 0.2575188, 0.25764284, 0.25776684, 0.25789082, 0.25801477, 0.25813866, 0.25826249, 0.25838625, 0.25851002, 0.2586337, 0.25875738, 0.258881, 0.25900462, 0.25912812, 0.25925162, 0.25937507, 0.25949848, 0.25962183, 0.25974515, 0.25986844, 0.25999165, 0.26011485, 0.26023796, 0.26036108, 0.26048413, 0.26060712, 0.26073012, 0.26085302, 0.26097593, 0.26109874, 0.26122153, 0.26134425, 0.26146701, 0.26158965, 0.26171231, 0.26183486, 0.26195735, 0.26207986, 0.26220232, 0.26232472, 0.26244709, 0.2625694, 0.26269165, 0.2628139, 0.26293609, 0.26305822, 0.26318032, 0.26330236, 0.26342437, 0.26354632, 0.26366827, 0.26379013, 0.26391196, 0.26403376, 0.26415551, 0.26427722, 0.26439887, 0.2645205, 0.26464206, 0.26476359, 0.2648851, 0.26500654, 0.2651279, 0.26524928, 0.26537058, 0.26549187, 0.26561308, 0.26573426, 0.26585537, 0.26597649, 0.26609755, 0.26621857, 0.26633951, 0.26646042, 0.2665813, 0.26670215, 0.26682293, 0.26694366, 0.26706439, 0.26718506, 0.26730564, 0.26742622, 0.26754674, 0.26766723, 0.26778764, 0.26790807, 0.26802841, 0.26814872, 0.268269, 0.2683892, 0.26850942, 0.26862955, 0.26874962, 0.2688697, 0.26898968, 0.26910961, 0.26922956, 0.26934946, 0.26946926, 0.26958907, 0.26970878, 0.2698285, 0.26994815, 0.27006775, 0.27018735, 0.27030686, 0.27042633, 0.27054578, 0.27066517, 0.27078453, 0.2709038, 0.27102309, 0.2711423, 0.27126148, 0.27138063, 0.27149969, 0.27161878, 0.27173775, 0.2718567, 0.27197564, 0.27209452, 0.27221334, 0.27233213, 0.27245089, 0.27256957, 0.27268821, 0.27280682, 0.27292541, 0.2730439, 0.27316239, 0.27328083, 0.27339923, 0.27351758, 0.27363586, 0.27375415, 0.27387238, 0.27399054, 0.27410868, 0.27422675, 0.2743448, 0.27446279, 0.27458078, 0.27469867, 0.27481654, 0.27493435, 0.27505216, 0.27516991, 0.27528757, 0.27540523, 0.27552286, 0.2756404, 0.27575791, 0.27587539, 0.27599284, 0.27611023, 0.27622756, 0.27634487, 0.27646214, 0.27657935, 0.27669653, 0.27681369, 0.27693075, 0.27704775, 0.27716479, 0.27728176, 0.27739865, 0.27751553, 0.27763233, 0.27774912, 0.27786586, 0.27798256, 0.27809921, 0.2782158, 0.27833238, 0.27844888, 0.27856535, 0.27868181, 0.27879819, 0.27891451, 0.27903083, 0.27914709, 0.27926329, 0.27937949, 0.2794956, 0.27961168, 0.27972773, 0.27984372, 0.27995965, 0.28007558, 0.28019145, 0.28030726, 0.28042307, 0.28053877, 0.28065449, 0.28077012, 0.28088573, 0.28100127, 0.28111678, 0.28123227, 0.28134772, 0.28146309, 0.28157842, 0.28169373, 0.281809, 0.28192422, 0.28203937, 0.28215447, 0.28226957, 0.2823846, 0.28249961, 0.28261456, 0.28272945, 0.28284433, 0.28295916, 0.2830739, 0.28318867, 0.28330335, 0.283418, 0.28353262, 0.28364718, 0.28376168, 0.28387615, 0.28399056, 0.28410494, 0.28421929, 0.28433359, 0.28444785, 0.28456202, 0.28467622, 0.28479031, 0.28490442, 0.28501844, 0.28513244, 0.2852464, 0.28536028, 0.28547418, 0.28558674, 0.28569815, 0.28580943, 0.28592062, 0.28603172, 0.2861428, 0.28625372, 0.28636456, 0.2864753, 0.28658596, 0.28669652, 0.28680703, 0.28691739, 0.28702769, 0.28713793, 0.28724802, 0.28735805, 0.28746802, 0.28757784, 0.2876876, 0.28779724, 0.28790686, 0.28801632, 0.28812569, 0.28823501, 0.2883442, 0.28845337, 0.28856239, 0.28867131, 0.28878015, 0.28888896, 0.28899759, 0.28910619, 0.28921467, 0.28932306, 0.28943133, 0.28953958, 0.28964773, 0.28975573, 0.28986368, 0.28997156, 0.2900793, 0.290187, 0.29029456, 0.29040205, 0.29050946, 0.29061678, 0.29072398, 0.29083112, 0.29093817, 0.2910451, 0.29115194, 0.29125872, 0.29136541, 0.29147202, 0.29157847, 0.2916849, 0.29179123, 0.29189745, 0.29200357, 0.29210961, 0.29221556, 0.29232144, 0.29242721, 0.29253289, 0.29263848, 0.29274395, 0.29284939, 0.29295468, 0.29305995, 0.29316506, 0.29327011, 0.29337507, 0.29347995, 0.29358473, 0.2936894, 0.29379401, 0.29389849, 0.29400292, 0.29410726, 0.29421148, 0.29431561, 0.29441968, 0.29452363, 0.29462749, 0.29473129, 0.294835, 0.29493856, 0.2950421, 0.29514551, 0.29524884, 0.29535204, 0.29545519, 0.29555824, 0.29566121, 0.29576412, 0.29586688, 0.29596961, 0.29607216, 0.29617471, 0.29627714, 0.29637948, 0.2964817, 0.29658386, 0.2966859, 0.29678789, 0.29688978, 0.29699156, 0.29709324, 0.29719484, 0.29729638, 0.29739776, 0.29749912, 0.29760039, 0.29770151, 0.2978026, 0.29790357, 0.29800448, 0.29810527, 0.29820594, 0.29830655, 0.29840708, 0.29850748, 0.29860789, 0.29870811, 0.29880828, 0.29890832, 0.29900831, 0.29910818, 0.29920799, 0.2993077, 0.29940733, 0.29950684, 0.29960626, 0.29970562, 0.29980487, 0.29990405, 0.30000311, 0.30010206, 0.30020097, 0.30029976, 0.30039853, 0.30049711, 0.30059564, 0.30069408, 0.30079243, 0.30089068, 0.30098885, 0.3010869, 0.30118492, 0.30128282, 0.3013806, 0.30147833, 0.30157593, 0.30167347, 0.30177093, 0.30186829, 0.30196553, 0.30206272, 0.30215979, 0.30225679, 0.30235368, 0.30245051, 0.30254722, 0.30264384, 0.30274037, 0.30283684, 0.30293319, 0.30302945, 0.30312562, 0.3032217, 0.30331773, 0.30341363, 0.30350944, 0.30360514, 0.30370077, 0.30379635, 0.30389178, 0.30398715, 0.30408239, 0.30417758, 0.30427268, 0.30436769, 0.30446261, 0.30455741, 0.30465212, 0.30474678, 0.30484131, 0.30493575, 0.30503014, 0.3051244, 0.30521861, 0.30531269, 0.30540669, 0.30550063, 0.30559441, 0.30568814, 0.30578178, 0.30587533, 0.30596882, 0.30606216, 0.30615547, 0.30624864, 0.30634177, 0.30643475, 0.30652764, 0.30662048, 0.30671322, 0.30680588, 0.30689842, 0.30699089, 0.30708325, 0.30717555, 0.30726776, 0.30735984, 0.30745184, 0.30754375, 0.30763561, 0.30772734, 0.30781901, 0.30791056, 0.30800202, 0.30809337, 0.30818468, 0.30827588, 0.30836698, 0.308458, 0.30854893, 0.30863976, 0.30873051, 0.30882117, 0.30891171, 0.30900219, 0.30909258, 0.30918285, 0.30927306, 0.30936316, 0.30945319, 0.30954313, 0.30963296, 0.30972272, 0.3098124, 0.30990192, 0.30999142, 0.3100808, 0.31017011, 0.31025931, 0.31034842, 0.31043744, 0.31052637, 0.31061521, 0.31070396, 0.31079262, 0.3108812, 0.31096971, 0.31105807, 0.31114635, 0.31123456, 0.31132269, 0.31141073, 0.31149867, 0.3115865, 0.31167427, 0.31176195, 0.3118495, 0.311937, 0.31202438, 0.31211168, 0.31219891, 0.31228605, 0.31237307, 0.31246001, 0.31254685, 0.3126336, 0.3127203, 0.31280684, 0.31289336, 0.31297976, 0.31306604, 0.31315228, 0.31323838, 0.31332445, 0.31341037, 