// Class: ReadLikelihoodPCA
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::LikelihoodPCA
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:54:12 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VarTransform: "PCA" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
TransformOutput: "False" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <math.h>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihoodPCA : public IClassifierReader {

 public:

   // constructor
   ReadLikelihoodPCA( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihoodPCA" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -11.2719573974609;
      fVmax[0] = 9.09155368804932;
      fVmin[1] = -3.98751449584961;
      fVmax[1] = 3.38363432884216;
      fVmin[2] = -2.01709818840027;
      fVmax[2] = 2.19576525688171;
      fVmin[3] = -1.01762998104095;
      fVmax[3] = 1.061687707901;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadLikelihoodPCA() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   void X2P_1( const double*, double*, int ) const;
   double fMeanValues_1[3][4];
   double fEigenVectors_1[3][4][4];

   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[4]; 
   int    fNbin[4]; // number of bins (discrete variables may have less bins)
   double    fHistMin[4]; 
   double    fHistMax[4]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihoodPCA::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = -12.0934629440308;
   fHistMax[0] = 9.88210773468018;
   fNbin[1] = 10000;
   fHistMin[1] = -3.54455327987671;
   fHistMax[1] = 4.11745309829712;
   fNbin[2] = 10000;
   fHistMin[2] = -2.29971814155579;
   fHistMax[2] = 2.23682618141174;
   fNbin[3] = 10000;
   fHistMin[3] = -1.25347244739532;
   fHistMax[3] = 1.25178468227386;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
}

inline double ReadLikelihoodPCA::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   Transform(inputValuesSig,0);
   Transform(inputValuesBgd,1);
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihoodPCA: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihoodPCA::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (false) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihoodPCA::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihoodPCA::fRefS[][10000] = 
{ 
   { 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 6.9944590563864e-08, 3.2123296023201e-07, 5.67342851809371e-07, 8.4454035231829e-07, 1.14505269266374e-06, 1.45075023283425e-06, 1.80307415575953e-06, 2.15798900171649e-06, 2.52326753980014e-06, 2.92999720841181e-06, 3.35226900460839e-06, 3.76936259272043e-06, 4.23308210883988e-06, 4.72271131002344e-06, 5.2071582103963e-06, 5.72528369957581e-06, 6.26154587735073e-06, 6.81075880493154e-06, 7.3962382884929e-06, 7.99208464741241e-06, 8.60088221088517e-06, 9.24335836316459e-06, 9.91174329101341e-06, 1.05619883470354e-05, 1.12692241600598e-05, 1.19868291221792e-05, 1.27070261441986e-05, 1.34686670207884e-05, 1.42406788654625e-05, 1.50385867527802e-05, 1.58624134201091e-05, 1.66836380230961e-05, 1.75514960574219e-05, 1.84271284524584e-05, 1.93053565453738e-05, 2.02379778784234e-05, 2.1178379029152e-05, 2.21135924221016e-05, 2.31006215472007e-05, 2.40980170929106e-05, 2.51083583862055e-05, 2.61472068814328e-05, 2.72093602688983e-05, 2.82818782579852e-05, 2.93803113891045e-05, 3.04890945699299e-05, 3.16134282911662e-05, 3.2781797926873e-05, 3.39709004038014e-05, 3.51340931956656e-05, 3.63724138878752e-05, 3.76107345800847e-05, 3.88464613934048e-05, 4.01262295781635e-05, 4.14319038100075e-05, 4.27349987148773e-05, 4.4066571717849e-05, 4.54344262834638e-05, 4.6799690608168e-05, 4.82038049085531e-05, 4.96001521241851e-05, 5.10405407112557e-05, 5.2512015827233e-05, 5.39783213753253e-05, 5.54679354536347e-05, 5.69912226637825e-05, 5.85196939937305e-05, 6.0081834817538e-05, 6.1651757278014e-05, 6.32372320978902e-05, 6.48641362204216e-05, 6.65091938572004e-05, 6.81412784615532e-05, 6.98277799529023e-05, 7.15272253728472e-05, 7.32241023797542e-05, 7.496758189518e-05, 7.67292222008109e-05, 7.84882504376583e-05, 8.02913273219019e-05, 8.21125358925201e-05, 8.39285785332322e-05, 8.57964187161997e-05, 8.76746198628098e-05, 8.95605990081094e-05, 9.14854317670688e-05, 9.34284034883603e-05, 9.53584240050986e-05, 9.73454370978288e-05, 9.93454013951123e-05, 0.000101353143691085, 0.000103376405604649, 0.000105443737993483, 0.000107505882624537, 0.000109593929664697, 0.00011171823280165, 0.000113845155283343, 0.000116000541311223, 0.00011818185885204, 0.000120365744805895, 0.000122596291475929, 0.000124821628560312, 0.000127070306916721, 0.000129352643853053, 0.000131634980789386, 0.000133940658997744, 0.000136298112920485, 0.000138645220431499, 0.000141005279147066, 0.000143411991302855, 0.000145823854836635, 0.000148240913404152, 0.000150720137753524, 0.000153178654727526, 0.000155673420522362, 0.000158201888552867, 0.00016072514699772, 0.000163263961439952, 0.000165849400218576, 0.000168445229064673, 0.000171051404322498, 0.000173688647919334, 0.000176333691342734, 0.000179007212864235, 0.000181704046553932, 0.000184416436241008, 0.000187157304026186, 0.000189908590982668, 0.000192677936865948, 0.000195480999536812, 0.000198289271793328, 0.00020110268087592, 0.000203973104362376, 0.000206848693778738, 0.000209729463676922, 0.000212664643186145, 0.000215573920286261, 0.000218529821722768, 0.00022152200108394, 0.000224496048758738, 0.000227514130529016, 0.000230560690397397, 0.000233602098887786, 0.000236669424339198, 0.000239762623095885, 0.00024286875850521, 0.000246003444772214, 0.000249166594585404, 0.000252329744398594, 0.000255529186688364, 0.000258744170423597, 0.000261964305536821, 0.000265228474745527, 0.000268487492576241, 0.00027180090546608, 0.000275111757218838, 0.000278438121313229, 0.000281798129435629, 0.000285163405351341, 0.000288557086605579, 0.000291974138235673, 0.000295404141070321, 0.00029883929528296, 0.000302313332213089, 0.000305821042275056, 0.00030931580113247, 0.000312844233121723, 0.000316408928483725, 0.000319976214086637, 0.000323561660479754, 0.000327178189763799, 0.000330805050907657, 0.000334465614287183, 0.000338133948389441, 0.000341825594659895, 0.000345545733580366, 0.00034927882370539, 0.000353017094312236, 0.000356799428118393, 0.000360589532647282, 0.000364410690963268, 0.000368229288142174, 0.000372084119589999, 0.000375957111828029, 0.000379863777197897, 0.000383752310881391, 0.000387710810173303, 0.000391648558434099, 0.0003956044674851, 0.000399622513214126, 0.000403617246774957, 0.000407650833949447, 0.000411707791499794, 0.000415767310187221, 0.000419855321524665, 0.000423979596234858, 0.000428101280704141, 0.000432256638305262, 0.000436432746937498, 0.000440619187429547, 0.00044481860822998, 0.000449062034022063, 0.000453302956884727, 0.000457595597254112, 0.000461875286418945, 0.000466191297164187, 0.000470520259113982, 0.000474880245747045, 0.000479229900520295, 0.000483639189042151, 0.000488040619529784, 0.000492473191116005, 0.000496936903800815, 0.000501395319588482, 0.000505877134855837, 0.000510408135596663, 0.000514920975547284, 0.000519475375767797, 0.000524060742463917, 0.000528630625922233, 0.000533236772753298, 0.000537879182957113, 0.000542524154298007, 0.000547184725292027, 0.000551897042896599, 0.000556599057745188, 0.000561337335966527, 0.000566080736462027, 0.000570857839193195, 0.000575640122406185, 0.000580458668991923, 0.000585282454267144, 0.000590137264225632, 0.000595012854319066, 0.000599880644585937, 0.000604815781116486, 0.000609737995546311, 0.000614683493040502, 0.000619670492596924, 0.000624644511844963, 0.000629644375294447, 0.000634693482425064, 0.000639734847936779, 0.000644791754893959, 0.000649900524877012, 0.000655009294860065, 0.00066013348987326, 0.000665291387122124, 0.000670454523060471, 0.000675633258651942, 0.00068084814120084, 0.000686078565195203, 0.000691337569151074, 0.000696599134244025, 0.000701894401572645, 0.00070720782969147, 0.000712544482666999, 0.000717886374332011, 0.00072326191002503, 0.000728642626199871, 0.000734067405574024, 0.000739489565603435, 0.000744927325285971, 0.000750411709304899, 0.000755901215597987, 0.000761393399443477, 0.000766939949244261, 0.000772483879700303, 0.000778043351601809, 0.000783628667704761, 0.000789247802458704, 0.000794864259660244, 0.000800516980234534, 0.000806198280770332, 0.000811882084235549, 0.000817597028799355, 0.000823319714982063, 0.000829078664537519, 0.000834840233437717, 0.000840630324091762, 0.000846448936499655, 0.000852277793455869, 0.000858122250065207, 0.000864000350702554, 0.000869886309374124, 0.000875787693075836, 0.000881722837220877, 0.000887668400537223, 0.000893632008228451, 0.000899634440429509, 0.000905631808564067, 0.00091165240155533, 0.000917711877264082, 0.000923779036384076, 0.000929854169953614, 0.000935978430788964, 0.000942097511142492, 0.000948242435697466, 0.00095442112069577, 0.000960607489105314, 0.000966817198786885, 0.00097304506925866, 0.000979285920038819, 0.000985562917776406, 0.000991853070445359, 0.000998158589936793, 0.00100448750890791, 0.00101083714980632, 0.00101719982922077, 0.00102360127493739, 0.00103000516537577, 0.00103641964960843, 0.00104288593865931, 0.00104935467243195, 0.00105582864489406, 0.00106235442217439, 0.001068867277354, 0.00107541889883578, 0.00108199391979724, 0.00108857150189579, 0.00109517760574818, 0.00110182003118098, 0.00110846234019846, 0.00111512292642146, 0.00112181704025716, 0.00112852163147181, 0.00113524950575083, 0.00114199286326766, 0.0011487725423649, 0.00115555746015161, 0.00116236822213978, 0.00116919190622866, 0.00117605179548264, 0.00118290667887777, 0.00118980556726456, 0.00119671213906258, 0.00120363687165082, 0.00121057208161801, 0.00121755374129862, 0.00122453027870506, 0.00123153266031295, 0.00123857159633189, 0.00124561542179435, 0.00125267496332526, 0.0012597783934325, 0.00126687670126557, 0.00127399060875177, 0.00128114596009254, 0.00128831155598164, 0.00129550322890282, 0.00130271282978356, 0.00130994338542223, 0.00131719966884702, 0.00132445862982422, 0.00133174355141819, 0.00133905687835068, 0.00134637276642025, 0.00135372497607023, 0.00136110826861113, 0.00136849156115204, 0.00137589545920491, 0.00138332031201571, 0.00139076053164899, 0.00139823462814093, 0.00140572933014482, 0.00141321879345924, 0.00142076006159186, 0.00142830656841397, 0.00143585563637316, 0.0014434513868764, 0.00145105738192797, 0.00145867385435849, 0.00146631360985339, 0.00147399224806577, 0.00148167344741523, 0.00148938316851854, 0.00149711628910154, 0.00150485429912806, 0.00151262886356562, 0.00152041891124099, 0.00152822444215417, 0.00153605337254703, 0.00154389766976237, 0.00155177584383637, 0.00155965134035796, 0.0015675580361858, 0.00157549302093685, 0.00158343592192978, 0.00159139186143875, 0.00159939168952405, 0.00160738884005696, 0.00161540694534779, 0.00162347406148911, 0.00163152837194502, 0.00163960584904999, 0.001647719880566, 0.00165583624038845, 0.00166398123838007, 0.00167217280250043, 0.00168033060617745, 0.00168855069205165, 0.00169677333906293, 0.00170502450782806, 0.00171328079886734, 0.00172157341148704, 0.0017298711463809, 0.00173821824137121, 0.00174655218143016, 0.00175491475965828, 0.0017633136594668, 0.00177170720417053, 0.00178012670949101, 0.00178859033621848, 0.0017970436019823, 0.00180551502853632, 0.00181403546594083, 0.00182256114203483, 0.00183108972851187, 0.00183967768680304, 0.00184824992902577, 0.00185685593169183, 0.00186550081707537, 0.00187412509694695, 0.00188278814312071, 0.00189149787183851, 0.00190018699504435, 0.00190890429075807, 0.00191767350770533, 0.00192642223555595, 0.00193520693574101, 0.00194401503540576, 0.00195284117944539, 0.00196168851107359, 0.00197054306045175, 0.00197942880913615, 0.00198835646733642, 0.00199726549908519, 0.00200622132979333, 0.00201518228277564, 0.00202415860258043, 0.00203317683190107, 0.00204220484010875, 0.00205123866908252, 0.00206029275432229, 0.00206938851624727, 0.00207848683930933, 0.00208760076202452, 0.0020967717282474, 0.00210591917857528, 0.00211510015651584, 0.00212430232204497, 0.00213353522121906, 0.00214277068153024, 0.00215205014683306, 0.00216132751666009, 0.00217065354809165, 0.00217996956780553, 0.00218930351547897, 0.0021986817009747, 0.00220805453136563, 0.00221745320595801, 0.00222688331268728, 0.00223632878623903, 0.00224580243229866, 0.00225528166629374, 0.00226478674449027, 0.00227431766688824, 0.00228385371156037, 0.00229340535588562, 0.00230300379917026, 0.00231261481530964, 0.00232222094200552, 0.0023318943567574, 0.00234152865596116, 0.00235121021978557, 0.00236090924590826, 0.0023706576321274, 0.00238038552924991, 0.00239074556156993, 0.00240163668058813, 0.00241257948800921, 0.00242356373928487, 0.00243457895703614, 0.00244560465216637, 0.00245670322328806, 0.00246783252805471, 0.00247899279929698, 0.00249016331508756, 0.00250140693970025, 0.0025126812979579, 0.00252395565621555, 0.00253529218025506, 0.00254669110290706, 0.00255812099203467, 0.00256951968185604, 0.00258104270324111, 0.00259256572462618, 0.00260410993359983, 0.00261570536531508, 0.0026273219846189, 0.00263900030404329, 0.00265071005560458, 0.00266244052909315, 0.00267420173622668, 0.00268603581935167, 0.00269788014702499, 0.00270975567400455, 0.00272169313393533, 0.00273365154862404, 0.00274565140716732, 0.0027576822321862, 0.00276973377913237, 0.00278184749186039, 0.00279398215934634, 0.00280616828240454, 0.00281838583759964, 0.00283064460381866, 0.00284289312548935, 0.00285523477941751, 0.00286761811003089, 0.0028799909632653, 0.00289242598228157, 0.00290487124584615, 0.00291739962995052, 0.00292994873598218, 0.00294249760918319, 0.00295513984747231, 0.00296779256314039, 0.0029804555233568, 0.00299318064935505, 0.00300594721920788, 0.00301874498836696, 0.00303156347945333, 0.00304445461370051, 0.00305735575966537, 0.00307031930424273, 0.00308326212689281, 0.00309628760442138, 0.00310936523601413, 0.00312243239022791, 0.00313555123284459, 0.0031487219966948, 0.00316192395985126, 0.00317516713403165, 0.00318843103013933, 0.00320171588100493, 0.00321507314220071, 0.00322845112532377, 0.00324186007492244, 0.00325531070120633, 0.00326882349327207, 0.00328232580795884, 0.00329588004387915, 0.003309486201033, 0.0033231230918318, 0.00333678093738854, 0.00335050071589649, 0.00336424144916236, 0.0033780443482101, 0.00339183676987886, 0.0034057020675391, 0.00341959809884429, 0.00343349413014948, 0.00344748352654278, 0.00346147292293608, 0.00347552448511124, 0.00348958652466536, 0.00350370025262237, 0.00351784517988563, 0.00353202084079385, 0.00354623841121793, 0.00356046599335968, 0.00357479741796851, 0.00358910788781941, 0.0036034497898072, 0.00361788482405245, 0.00363229890353978, 0.00364675489254296, 0.00366128329187632, 0.00367583194747567, 0.00369041180238128, 0.00370503356680274, 0.00371968606486917, 0.00373436976224184, 0.00374910514801741, 0.00376386125572026, 0.00377865904010832, 0.00379350851289928, 0.00380838918499649, 0.00382328010164201, 0.00383823295123875, 0.00385322794318199, 0.00386825297027826, 0.00388327892869711, 0.00389836658723652, 0.00391351664438844, 0.00392866693437099, 0.00394385866820812, 0.0039591328240931, 0.00397437578067183, 0.00398968113586307, 0.0040050488896668, 0.00402042688801885, 0.00403585657477379, 0.00405130721628666, 0.00406678859144449, 0.0040823221206665, 0.00409790733829141, 0.00411348231136799, 0.00412914017215371, 0.00414480827748775, 0.00416050758212805, 0.00417624786496162, 0.00419205101206899, 0.0042078741826117, 0.00422370852902532, 0.00423962529748678, 0.00425555231049657, 0.00427152076736093, 0.00428752042353153, 0.00430355127900839, 0.00431962357833982, 0.00433574756607413, 0.00435188226401806, 0.0043680788949132, 0.00438429648056626, 0.00440056528896093, 0.00441684480756521, 0.00443317601457238, 0.00444955937564373, 0.00446596322581172, 0.00448238803073764, 0.00449887430295348, 0.00451539224013686, 0.00453192042186856, 0.00454851053655148, 0.00456514302641153, 0.00458181602880359, 0.00459849974140525, 0.00461522489786148, 0.00463199149817228, 0.00464879907667637, 0.00466562807559967, 0.0046825185418129, 0.00469944067299366, 0.00471637304872274, 0.00473335711285472, 0.00475038308650255, 0.00476745003834367, 0.00478454865515232, 0.00480167753994465, 0.00481885857880116, 0.00483606057241559, 0.00485329329967499, 0.00487056747078896, 0.00488788355141878, 0.0049052401445806, 0.00492260791361332, 0.00494005810469389, 0.00495750876143575, 0.00497499061748385, 0.00499253440648317, 0.00501010892912745, 0.00502771465107799, 0.00504536228254437, 0.0050630304031074, 0.00508073996752501, 0.00509851146489382, 0.00511628342792392, 0.00513410661369562, 0.00515198241919279, 0.00516987778246403, 0.00518779503181577, 0.00520576350390911, 0.00522378413006663, 0.00524183548986912, 0.00525988731533289, 0.00527802109718323, 0.00529616652056575, 0.00531436316668987, 0.00533258030191064, 0.0053508491255343, 0.00536914961412549, 0.00538749108090997, 0.00540584279224277, 0.00542424665763974, 0.00544272316619754, 0.00546117871999741, 0.00547969620674849, 0.00549824582412839, 0.00551684619858861, 0.00553546752780676, 0.00555412005633116, 0.00557283498346806, 0.00559155968949199, 0.00561032630503178, 0.00562915531918406, 0.00564799457788467, 0.00566687434911728, 0.00568578625097871, 0.00570474984124303, 0.00572373392060399, 0.00574275897815824, 0.0057618161663413, 0.00578091433271766, 0.0058000641874969, 0.00581922475248575, 0.00583843654021621, 0.00585769023746252, 0.00587698491290212, 0.005896280054003, 0.00591563759371638, 0.00593504589051008, 0.00595447607338428, 0.00597391603514552, 0.00599341839551926, 0.00601297244429588, 0.00603252649307251, 0.00605213223025203, 0.00607180036604404, 0.00609146850183606, 0.00611117761582136, 0.00613094959408045, 0.00615074206143618, 0.0061705862171948, 0.00619043037295341, 0.00621032621711493, 0.00623027421534061, 0.00625025294721127, 0.00627024238929152, 0.00629030400887132, 0.00631038658320904, 0.00633050035685301, 0.00635065557435155, 0.00637085177004337, 0.00639110011979938, 0.00641136942431331, 0.00643164897337556, 0.00645199045538902, 0.00647237384691834, 0.00649277772754431, 0.00651322258636355, 0.00653371959924698, 0.00655422685667872, 0.00657477602362633, 0.00659537641331553, 0.00661600800231099, 0.00663668150082231, 0.00665738573297858, 0.00667812116444111, 0.00669889803975821, 0.00671971635892987, 0.00674054492264986, 0.00676144612953067, 0.0067823682911694, 0.00680331094190478, 0.00682430528104305, 0.00684535130858421, 0.00686642853543162, 0.006887495983392, 0.00690863560885191, 0.00692983716726303, 0.00695104897022247, 0.00697228172793984, 0.00699358712881804, 0.00701490277424455, 0.00703624961897731, 0.00705765839666128, 0.00707908812910318, 0.00710055977106094, 0.00712206168100238, 0.00714359525591135, 0.00716516934335232, 0.00718680629506707, 0.00720846466720104, 0.00723012210801244, 0.00725185219198465, 0.00727362325415015, 0.00729539524763823, 0.00731721892952919, 0.00733911478891969, 0.00736103113740683, 0.00738293817266822, 0.00740493787452579, 0.00742694782093167, 0.00744899921119213, 0.00747108133509755, 0.00749321514740586, 0.00751536106690764, 0.00753756705671549, 0.00755979493260384, 0.00758207403123379, 0.00760437361896038, 0.00762670487165451, 0.00764908874407411, 0.00767151359468699, 0.00769396871328354, 0.00771644478663802, 0.00773898372426629, 0.00776154221966863, 0.00778414309024811, 0.00780676491558552, 0.00782944820821285, 0.00785214267671108, 0.00787488836795092, 0.00789766479283571, 0.00792048312723637, 0.00794335268437862, 0.00796623341739178, 0.00798914488404989, 0.00801210850477219, 0.00803511310368776, 0.00805814936757088, 0.00808120518922806, 0.00810433458536863, 0.00812747422605753, 0.00815064460039139, 0.00817387737333775, 0.00819712039083242, 0.00822041556239128, 0.00824373215436935, 0.00826708786189556, 0.00829051807522774, 0.00831393711268902, 0.00833738781511784, 0.00836093164980412, 0.00838445406407118, 0.00840802956372499, 0.00843164417892694, 0.00845531281083822, 0.00847901217639446, 0.00850271061062813, 0.00852649286389351, 0.00855028443038464, 0.00857413001358509, 0.00859799422323704, 0.00862190127372742, 0.0086458483710885, 0.00866983737796545, 0.00869384687393904, 0.0087179085239768, 0.00874201208353043, 0.00876611564308405, 0.00879028160125017, 0.00881449785083532, 0.00883873645216227, 0.00886301510035992, 0.00888731516897678, 0.00891166739165783, 0.00893604010343552, 0.00896045379340649, 0.00898490939289331, 0.009009406901896, 0.00903395563364029, 0.00905849412083626, 0.00908310431987047, 0.0091077471151948, 0.00913243088871241, 0.00915712490677834, 0.00918185990303755, 0.00920665729790926, 0.00923147518187761, 0.0092563247308135, 0.00928122643381357, 0.00930615793913603, 0.0093311108648777, 0.00935612618923187, 0.00938117224723101, 0.00940623972564936, 0.00943133700639009, 0.00945650693029165, 0.00948167778551579, 0.00950691103935242, 0.00953216385096312, 0.00955745857208967, 0.00958278495818377, 0.00960815325379372, 0.00963355135172606, 0.00965900160372257, 0.00968448258936405, 0.00970997475087643, 0.0097355293110013, 0.00976111367344856, 0.00978673994541168, 0.00981238670647144, 0.00983808655291796, 0.00986383762210608, 0.00988958775997162, 0.00991538073867559, 0.00994123518466949, 0.00996711011976004, 0.00999301671981812, 0.0100189745426178, 0.0100449426099658, 0.0100709842517972, 0.0100970352068543, 0.0101231280714273, 0.0101492730900645, 0.0101754376664758, 0.0102016348391771, 0.0102278720587492, 0.0102541511878371, 0.0102804731577635, 0.0103068137541413, 0.0103331971913576, 0.0103596113622189, 0.01038608700037, 0.0104125738143921, 0.0104391016066074, 0.0104656917974353, 0.0104922819882631, 0.0105189140886068, 0.0105456281453371, 0.0105723226442933, 0.0105990571901202, 0.0106258653104305, 0.0106526836752892, 0.0106795430183411, 0.0107064237818122, 0.0107333762571216, 0.0107603603973985, 0.0107873436063528, 0.0108144003897905, 0.0108414571732283, 0.0108685865998268, 0.0108957262709737, 0.0109229171648622, 0.0109501397237182, 0.0109774237498641, 0.0110047189518809, 0.0110320243984461, 0.0110594229772687, 0.0110868318006396, 0.0111142601817846, 0.011141742579639, 0.0111692659556866, 0.0111968088895082, 0.0112243937328458, 0.0112520307302475, 0.0112796882167459, 0.0113073978573084, 0.011335127055645, 0.0113628879189491, 0.0113907111808658, 0.0114185661077499, 0.0114464210346341, 0.0114743374288082, 0.0115023069083691, 0.0115302735939622, 0.0115582942962646, 0.0115863773971796, 0.0116144912317395, 0.0116425938904285, 0.0116707691922784, 0.0116989873349667, 0.0117272343486547, 0.0117555139586329, 0.011783835478127, 0.0118121756240726, 0.0118405790999532, 0.011869003996253, 0.0118974698707461, 0.0119259767234325, 0.0119545049965382, 0.0119830649346113, 0.0120116854086518, 0.0120403487235308, 0.0120690213516355, 0.0120977256447077, 0.0121264914050698, 0.0121552888303995, 0.0121841067448258, 0.0122129675000906, 0.0122418897226453, 0.0122708212584257, 0.0122997732833028, 0.0123287886381149, 0.0123578244820237, 0.0123877096921206, 0.0124185690656304, 0.0124495020136237, 0.0124804964289069, 0.0125115225091577, 0.0125425672158599, 0.0125736864283681, 0.0126048354431987, 0.0126360058784485, 0.0126672387123108, 0.0126985022798181, 0.0127298384904861, 0.0127611747011542, 0.0127925528213382, 0.0128240035846829, 0.0128555055707693, 0.012886987067759, 0.0129185505211353, 0.0129501773044467, 0.0129818040877581, 0.0130134811624885, 0.0130452122539282, 0.0130770038813353, 0.013108785264194, 0.0131406299769878, 0.0131725259125233, 0.013204462826252, 0.0132364211603999, 0.0132684614509344, 0.0133005129173398, 0.0133326053619385, 0.0133647294715047, 0.0133969252929091, 0.0134291425347328, 0.0134614109992981, 0.0134937111288309, 0.0135260634124279, 0.0135584566742182, 0.0135908704251051, 0.0136233456432819, 0.0136558637022972, 0.0136884022504091, 0.0137209920212626, 0.0137536348775029, 0.0137863075360656, 0.0138190425932407, 0.0138517888262868, 0.0138845853507519, 0.0139174247160554, 0.0139503153041005, 0.0139832478016615, 0.0140161998569965, 0.014049225486815, 0.0140822716057301, 0.014115359634161, 0.0141484970226884, 0.0141816893592477, 0.0142148798331618, 0.0142481438815594, 0.0142814284190536, 0.0143147949129343, 0.0143481632694602, 0.0143815614283085, 0.0144150424748659, 0.0144485654309392, 0.0144820986315608, 0.0145156644284725, 0.0145493187010288, 0.0145829981192946, 0.0146166756749153, 0.0146504482254386, 0.0146842608228326, 0.0147180827334523, 0.0147519474849105, 0.0147858755663037, 0.0148198436945677, 0.0148538425564766, 0.0148878740146756, 0.0149219864979386, 0.0149561017751694, 0.0149902449920774, 0.0150244617834687, 0.015058720484376, 0.0150930108502507, 0.0151273086667061, 0.0151617238298059, 0.015196138061583, 0.0152305839583278, 0.015265079215169, 0.0152996480464935, 0.0153342075645924, 0.0153688183054328, 0.0154035128653049, 0.0154382055625319, 0.0154729606583714, 0.0155077390372753, 0.015542577020824, 0.0155774261802435, 0.0156123479828238, 0.0156473219394684, 0.0156822931021452, 0.0157173406332731, 0.0157524384558201, 0.0157875381410122, 0.0158227067440748, 0.0158578865230083, 0.0158931612968445, 0.0159284472465515, 0.01596375182271, 0.0159991290420294, 0.0160345360636711, 0.0160699877887964, 0.016105480492115, 0.0161410234868526, 0.0161765869706869, 0.0162122026085854, 0.0162478499114513, 0.016283581033349, 0.0163192898035049, 0.0163550600409508, 0.0163909047842026, 0.0164267886430025, 0.0164626743644476, 0.0164986215531826, 0.0165346320718527, 0.0165706425905228, 0.016606705263257, 0.016642838716507, 0.0166789814829826, 0.0167151689529419, 0.0167514160275459, 0.0167876966297626, 0.0168240256607533, 0.0168603789061308, 0.0168967824429274, 0.016933236271143, 0.0169697236269712, 0.0170062184333801, 0.0170427989214659, 0.0170794203877449, 0.0171160399913788, 0.0171527657657862, 0.0171895138919353, 0.0172262787818909, 0.0172630846500397, 0.0172999575734138, 0.0173368453979492, 0.0173737872391939, 0.0174107607454062, 0.0174477882683277, 0.0174848530441523, 0.017521983012557, 0.0175590999424458, 0.0175963025540113, 0.0176335256546736, 0.0176708195358515, 0.0177081041038036, 0.0177454706281424, 0.0177828911691904, 0.0178203210234642, 0.0178577899932861, 0.0178953036665916, 0.0179328788071871, 0.0179704818874598, 0.0180080998688936, 0.0180458072572947, 0.0180835574865341, 0.0181212984025478, 0.0181591119617224, 0.0181969664990902, 0.018234871327877, 0.0182727891951799, 0.0183107573539019, 0.0183487962931395, 0.0183868501335382, 0.0184249300509691, 0.018463084474206, 0.0185012705624104, 0.0185395199805498, 0.0185777693986893, 0.0186160765588284, 0.0186544395983219, 0.0186928100883961, 0.0187312457710505, 0.0187697224318981, 0.0188082419335842, 0.0188467781990767, 0.0188853777945042, 0.0189240202307701, 0.0189627055078745, 0.0190014187246561, 0.0190401952713728, 0.019078990444541, 0.0191178414970636, 0.0191567316651344, 0.0191956534981728, 0.0192346163094044, 0.0192736200988293, 0.0193126872181892, 0.0193517748266459, 0.0193909052759409, 0.0194300822913647, 0.0194693151861429, 0.0195085592567921, 0.019547862932086, 0.0195871889591217, 0.0196265876293182, 0.0196660291403532, 0.0197054985910654, 0.0197449997067451, 0.0197845343500376, 0.019824119284749, 0.0198637656867504, 0.0199034232646227, 0.0199431646615267, 0.0199829135090113, 0.0200227256864309, 0.0200625397264957, 0.0201024245470762, 0.0201423615217209, 0.0201823096722364, 0.0202222988009453, 0.0202623810619116, 0.020302452147007, 0.0203425753861666, 0.0203827507793903, 0.0204229597002268, 0.020463215187192, 0.0205034855753183, 0.0205438565462828, 0.0205842405557632, 0.0206246431916952, 0.0206650886684656, 0.0207056067883968, 0.0207461435347795, 0.0207867138087749, 0.0208273436874151, 0.0208680275827646, 0.0209087412804365, 0.0209494568407536, 0.0209902748465538, 0.0210311021655798, 0.0210719723254442, 0.0211128946393728, 0.0211538355797529, 0.0211948622018099, 0.0212358962744474, 0.0212769638746977, 0.0213180929422379, 0.0213592424988747, 0.0214004535228014, 0.0214417260140181, 0.0214829910546541, 0.0215243268758059, 0.0215657148510218, 0.0216070916503668, 0.0216485634446144, 0.0216900557279587, 0.0217315871268511, 0.0217731613665819, 0.0218147784471512, 0.0218564756214619, 0.0218981448560953, 0.0219398960471153, 0.0219816863536835, 0.0220235306769609, 0.0220653638243675, 0.0221072696149349, 0.022149259224534, 0.0221912283450365, 0.0222332384437323, 0.0222753304988146, 0.0223174449056387, 0.0223595984280109, 0.0224017929285765, 0.0224440507590771, 0.0224863309413195, 0.0225286297500134, 0.0225710142403841, 0.022613437846303, 0.0226558726280928, 0.0226983483880758, 0.0227408763021231, 0.0227834545075893, 0.0228260550647974, 0.0228687282651663, 0.0229114219546318, 0.0229541771113873, 0.0229969434440136, 0.0230397507548332, 0.0230826213955879, 0.0231255311518908, 0.0231684427708387, 0.0232114586979151, 0.0232544839382172, 0.0232975296676159, 0.0233406592160463, 0.0233838185667992, 0.0234269984066486, 0.0234702304005623, 0.0235134959220886, 0.0235568098723888, 0.0236001871526241, 0.023643596097827, 0.0236870255321264, 0.0237305164337158, 0.0237740371376276, 0.0238175820559263, 0.0238611679524183, 0.0239048562943935, 0.0239485446363688, 0.0239922516047955, 0.0240360237658024, 0.0240798573940992, 0.0241237115114927, 0.0241676066070795, 0.0242115333676338, 0.0242555122822523, 0.024299543350935, 0.0243435949087143, 0.0243877079337835, 0.0244318507611752, 0.0244760159403086, 0.0245202537626028, 0.0245645232498646, 0.0246088523417711, 0.0246532056480646, 0.0246975868940353, 0.0247420221567154, 0.0247864872217178, 0.0248310044407845, 0.0248755533248186, 0.0249201748520136, 0.0249648168683052, 0.0250094793736935, 0.0250542238354683, 0.0250989701598883, 0.0251438077539206, 0.0251886248588562, 0.0252335257828236, 0.0252784583717585, 0.0253234319388866, 0.0253684259951115, 0.025413503870368, 0.0254585985094309, 0.0255037192255259, 0.0255489088594913, 0.0255941301584244, 0.0256394036114216, 0.0256846882402897, 0.0257300455123186, 0.0257754344493151, 0.0258208625018597, 0.0258663333952427, 0.0259118247777224, 0.0259573999792337, 0.0260029751807451, 0.0260486099869013, 0.0260942988097668, 0.0261400286108255, 0.0261857602745295, 0.0262315813452005, 0.0262774154543877, 0.0263233091682196, 0.0263692270964384, 0.0264151934534311, 0.0264612045139074, 0.0265072546899319, 0.0265533365309238, 0.0265994817018509, 0.0266456361860037, 0.0266918744891882, 0.0267381016165018, 0.0267844013869762, 0.0268307514488697, 0.0268771350383759, 0.0269235372543335, 0.0269700139760971, 0.0270165111869574, 0.0270630475133657, 0.0271096285432577, 0.0271562803536654, 0.0272029638290405, 0.0272496473044157, 0.0272964127361774, 0.027343200519681, 0.0273900385946035, 0.0274369176477194, 0.0274838171899319, 0.0275308024138212, 0.0275778062641621, 0.0276248324662447, 0.0276719406247139, 0.0277190580964088, 0.0277661960572004, 0.0278134308755398, 0.0278606619685888, 0.0279079750180244, 0.0279552917927504, 0.0280026700347662, 0.0280500892549753, 0.0280975494533777, 0.0281450394541025, 0.0281925611197948, 0.028240168467164, 0.028287785127759, 0.0283354409039021, 0.0283831395208836, 0.0284308902919292, 0.0284786820411682, 0.0285265147686005, 0.0285743810236454, 0.0286222863942385, 0.0286702532321215, 0.0287182312458754, 0.0287662837654352, 0.0288143455982208, 0.0288624782115221, 0.0289106331765652, 0.0289588291198015, 0.0290070790797472, 0.0290553644299507, 0.0291036870330572, 0.029152050614357, 0.0292004533112049, 0.0292489156126976, 0.0292973928153515, 0.0293459389358759, 0.0293945092707872, 0.0294431317597628, 0.0294917840510607, 0.0295404884964228, 0.0295892208814621, 0.0296380072832108, 0.0296868272125721, 0.0297356974333525, 0.029784606769681, 0.0298335384577513, 0.0298825316131115, 0.0299315489828587, 0.0299806334078312, 0.0300297439098358, 0.0300789028406143, 0.0301280934363604, 0.0301773268729448, 0.0302266031503677, 0.0302759148180485, 0.0303252823650837, 0.0303746871650219, 0.030424140393734, 0.0304736010730267, 0.0305231437087059, 0.030572697520256, 0.0306223221123219, 0.0306719709187746, 0.0307216588407755, 0.0307713877409697, 0.0308211706578732, 0.0308709815144539, 0.0309208463877439, 0.0309707410633564, 0.0310206785798073, 0.0310706570744514, 0.0311206877231598, 0.0311707612127066, 0.0312208607792854, 0.031271006911993, 0.031321182847023, 0.0313714183866978, 0.0314216986298561, 0.0314720086753368, 0.0315223559737206, 0.0315727591514587, 0.0316231846809387, 0.0316736735403538, 0.03172417730093, 0.0317747592926025, 0.0318253599107265, 0.0318760015070438, 0.0319266840815544, 0.0319774076342583, 0.0320281758904457, 0.032078992575407, 0.0321298502385616, 0.032180730253458, 0.0322316735982895, 0.0322826355695724, 0.0323336608707905, 0.0323847271502018, 0.0324358120560646, 0.0324869640171528, 0.0325381346046925, 0.0325893647968769, 0.0326406210660934, 0.0326919332146645, 0.0327432900667191, 0.0327946692705154, 0.0328460857272148, 0.0328975692391396, 0.0329491049051285, 0.033001821488142, 0.0330557785928249, 0.0331097766757011, 0.0331638306379318, 0.0332178696990013, 0.0332719646394253, 0.0333260782063007, 0.0333802290260792, 0.0334344133734703, 0.0334886088967323, 0.0335428602993488, 0.0335971266031265, 0.0336514264345169, 0.0337057448923588, 0.0337601006031036, 0.0338144898414612, 0.0338689014315605, 0.0339233465492725, 0.0339778363704681, 0.034032329916954, 0.0340868793427944, 0.0341414362192154, 0.0341960191726685, 0.0342506468296051, 0.0343052893877029, 0.034359984099865, 0.0344147048890591, 0.0344694443047047, 0.034524217247963, 0.0345790237188339, 0.0346338525414467, 0.0346887148916721, 0.0347436033189297, 0.0347985364496708, 0.0348534658551216, 0.0349084623157978, 0.0349634848535061, 0.0350184999406338, 0.0350735858082771, 0.0351286828517914, 0.0351838059723377, 0.0352389626204967, 0.0352941565215588, 0.0353493839502335, 0.0354046411812305, 0.0354599095880985, 0.0355152189731598, 0.0355705544352531, 0.0356259308755398, 0.0356813184916973, 0.0357367470860481, 0.0357922092080116, 0.0358476862311363, 0.0359032079577446, 0.0359587594866753, 0.036014337092638, 0.0360699370503426, 0.0361255668103695, 0.0361812263727188, 0.0362369231879711, 0.0362926535308361, 0.0363484062254429, 0.0364041849970818, 0.0364599972963333, 0.0365158654749393, 0.0365717150270939, 0.0366276353597641, 0.0366835482418537, 0.0367395170032978, 0.0367955081164837, 0.0368515178561211, 0.0369075872004032, 0.0369636714458466, 0.0370197705924511, 0.0370759144425392, 0.03713209182024, 0.0371882766485214, 0.037244513630867, 0.0373007692396641, 0.0373570583760738, 0.0374133884906769, 0.0374697186052799, 0.0375261269509792, 0.0375825278460979, 0.0376389510929585, 0.0376954227685928, 0.0377519130706787, 0.0378084480762482, 0.0378650017082691, 0.0379215888679028, 0.0379782095551491, 0.0380348451435566, 0.0380915366113186, 0.0381482355296612, 0.0382049605250359, 0.0382617264986038, 0.0383185259997845, 0.0383753441274166, 0.0384322181344032, 0.038489080965519, 0.0385460071265697, 0.0386029444634914, 0.0386599078774452, 0.0387169234454632, 0.0387739390134811, 0.0388310141861439, 0.0388880930840969, 0.0389452278614044, 0.0390023812651634, 0.0390595607459545, 0.039116770029068, 0.0391740128397942, 0.0392312742769718, 0.0392885766923428, 0.0393458940088749, 0.0394032746553421, 0.0394606590270996, 0.0395180694758892, 0.0395755283534527, 0.0396330058574677, 0.0396905019879341, 0.0397480502724648, 0.0398056134581566, 0.0398632138967514, 0.0399208404123783, 0.0399784930050373, 0.0400361865758896, 0.0400939024984837, 0.0401516519486904, 0.040209423750639, 0.0402672216296196, 0.0403250679373741, 0.0403829179704189, 0.0404408201575279, 0.0404987521469593, 0.0405566953122616, 0.0406146794557571, 0.0406727008521557, 0.0407307408750057, 0.0407888144254684, 0.0408469140529633, 0.0409050472080708, 0.04096320271492, 0.0410214066505432, 0.0410796254873276, 0.0411378741264343, 0.0411961600184441, 0.0412544794380665, 0.0413127988576889, 0.0413711741566658, 0.0414295755326748, 0.0414880104362965, 0.0415464639663696, 0.0416049510240555, 0.0416634865105152, 0.0417220182716846, 0.041780598461628, 0.0418392084538937, 0.0418978407979012, 0.0419565215706825, 0.0420152023434639, 0.0420739389955997, 0.0421327017247677, 0.0421914719045162, 0.0422502867877483, 0.042309146374464, 0.0423680059611797, 0.0424269214272499, 0.0424858592450619, 0.0425448194146156, 0.0426038354635239, 0.0426628477871418, 0.0427218973636627, 0.0427809730172157, 0.0428400747478008, 0.042899239808321, 0.0429584011435509, 0.0430176146328449, 0.0430768430233002, 0.0431361086666584, 0.0431954003870487, 0.0432547107338905, 0.0433140657842159, 0.0433734506368637, 0.0434328578412533, 0.0434922985732555, 0.0435517691075802, 0.0436112694442272, 0.0436708107590675, 0.0437303632497787, 0.0437899604439735, 0.0438495613634586, 0.0439092069864273, 0.0439689047634602, 0.0440286099910736, 0.0440883487462997, 0.0441481061279774, 0.0442078970372677, 0.0442677438259125, 0.0443275906145573, 0.0443874783813953, 0.0444473922252655, 0.0445073358714581, 0.0445673167705536, 0.0446273051202297, 0.0446873567998409, 0.044747419655323, 0.0448075123131275, 0.044867642223835, 0.0449277795851231, 0.0449879691004753, 0.0450481884181499, 0.045108437538147, 0.0451686978340149, 0.045229010283947, 0.0452893376350403, 0.0453496985137463, 0.0454100854694843, 0.0454705022275448, 0.0455309711396694, 0.0455914437770844, 0.0456519536674023, 0.0457124970853329, 0.0457730628550053, 0.0458336696028709, 0.0458942875266075, 0.0459549650549889, 0.0460156388580799, 0.0460763685405254, 0.0461371093988419, 0.046197883784771, 0.0462586916983128, 0.0463195405900478, 0.0463804043829441, 0.0464413017034531, 0.0465022139251232, 0.0465631783008575, 0.0466241762042046, 0.0466851927340031, 0.0467462278902531, 0.0468073040246964, 0.0468684025108814, 0.0469295531511307, 0.0469907075166702, 0.0470519065856934, 0.0471131205558777, 0.0471743755042553, 0.0472356639802456, 0.0472969748079777, 0.0473583228886127, 0.0474196970462799, 0.0474810972809792, 0.0475425273180008, 0.0476039759814739, 0.0476654805243015, 0.0477270036935806, 0.0477885529398918, 0.0478501357138157, 0.0479117371141911, 0.04797338321805, 0.048035055398941, 0.0480967611074448, 0.0481584854424, 0.0482202358543873, 0.0482820272445679, 0.0483438484370708, 0.0484057068824768, 0.0484675839543343, 0.0485294871032238, 0.048591423779726, 0.0486533977091312, 0.0487153679132462, 0.048777412623167, 0.0488394722342491, 0.048901554197073, 0.0489636659622192, 0.0490258112549782, 0.049088004976511, 0.0491501986980438, 0.0492124371230602, 0.0492746978998184, 0.0493369847536087, 0.0493993125855923, 0.0494616664946079, 0.0495240539312363, 0.0495864637196064, 0.0496489219367504, 0.0497113764286041, 0.0497739054262638, 0.0498364083468914, 0.0498989820480347, 0.0499615669250488, 0.0500241816043854, 0.0500868521630764, 0.050149530172348, 0.0502122305333614, 0.0502749755978584, 0.0503377504646778, 0.0504005439579487, 0.0504633560776711, 0.0505262315273285, 0.0505891144275665, 0.0506520308554173, 0.0507149919867516, 0.0507779717445374, 0.0508409775793552, 0.0509040169417858, 0.0509670712053776, 0.0510301664471626, 0.0510933138430119, 0.0511564575135708, 0.0512196496129036, 0.0512828640639782, 0.0513461120426655, 0.0514093898236752, 0.0514726787805557, 0.0515360198915005, 0.051599383354187, 0.0516627840697765, 0.0517262071371078, 0.051789652556181, 0.0518531501293182, 0.051916666328907, 0.0519802048802376, 0.0520437620580196, 0.0521073639392853, 0.0521710030734539, 0.0522346720099449, 0.0522983595728874, 0.0523620843887329, 0.0524258241057396, 0.0524896234273911, 0.0525534339249134, 0.052617259323597, 0.0526811294257641, 0.0527450144290924, 0.0528089553117752, 0.052872933447361, 0.0529369115829468, 0.0530009381473064, 0.0530649870634079, 0.0531290620565414, 0.0531931594014168, 0.0532572865486145, 0.0533214658498764, 0.0533856675028801, 0.0534498877823353, 0.0535141453146935, 0.0535784289240837, 0.0536427609622478, 0.0537071116268635, 0.0537714622914791, 0.0538358651101589, 0.0539003014564514, 0.0539647825062275, 0.0540292710065842, 0.0540937967598438, 0.0541583485901356, 0.05422293394804, 0.0542875491082668, 0.0543521903455257, 0.0544168576598167, 0.0544815622270107, 0.0545462928712368, 0.054611049592495, 0.054675854742527, 0.0547406636178493, 0.0548055171966553, 0.0548704005777836, 0.0549352951347828, 0.0550002455711365, 0.0550651997327805, 0.0551302246749401, 0.0551952496170998, 0.0552602969110012, 0.0553253926336765, 0.0553905218839645, 0.0554556623101234, 0.0555208437144756, 0.0555860437452793, 0.055651281028986, 0.0557165592908859, 0.0557818412780762, 0.0558471791446209, 0.0559125356376171, 0.0559779219329357, 0.056043341755867, 0.0561087764799595, 0.0561742559075356, 0.0562397614121437, 0.0563052892684937, 0.0563708655536175, 0.0564364455640316, 0.0565020889043808, 0.0565677396953106, 0.0566334016621113, 0.056699126958847, 0.0567648634314537, 0.0568306371569633, 0.056896448135376, 0.0569622777402401, 0.0570281408727169, 0.0570940300822258, 0.0571599528193474, 0.0572259128093719, 0.057291891425848, 0.0573578923940659, 0.0574239268898964, 0.0574900060892105, 0.057556115090847, 0.0576222203671932, 0.0576884038746357, 0.0577545799314976, 0.0578207895159721, 0.0578870438039303, 0.0579533167183399, 0.0580196306109428, 0.0580859705805779, 0.0581523254513741, 0.0582187473773956, 0.0582851506769657, 0.0583516247570515, 0.0584181100130081, 0.0584846138954163, 0.058551162481308, 0.0586177296936512, 0.0586843341588974, 0.0587509907782078, 0.0588176473975182, 0.0588843449950218, 0.0589510574936867, 0.0590177960693836, 0.0590846054255962, 0.0591514147818089, 0.0592182651162148, 0.0592851266264915, 0.0593520253896713, 0.0594189800322056, 0.0594859160482883, 0.0595529265701771, 0.0596199259161949, 0.0596869774162769, 0.0597540661692619, 0.0598211921751499, 0.0598883144557476, 0.0599554665386677, 0.0600226894021034, 0.0600899234414101, 0.0601571723818779, 0.060224462300539, 0.0602917782962322, 0.0603591352701187, 0.0604265071451664, 0.0604939162731171, 0.0605613440275192, 0.0606288239359856, 0.0606963150203228, 0.060763843357563, 0.0608314014971256, 0.0608989782631397, 0.060966607183218, 0.0610342472791672, 0.061101920902729, 0.0611696243286133, 0.0612373650074005, 0.0613051354885101, 0.0613729134202003, 0.0614407397806644, 0.0615085922181606, 0.0615764819085598, 0.0616443902254105, 0.0617123395204544, 0.0617803037166595, 0.0618483200669289, 0.0619163438677788, 0.0619843974709511, 0.0620524995028973, 0.0621206127107143, 0.062188770622015, 0.0622569508850574, 0.062325157225132, 0.0623933933675289, 0.0624616667628288, 0.062529981136322, 0.0625982955098152, 0.0626666396856308, 0.0627350509166718, 0.0628034695982933, 0.0628719106316566, 0.0629403814673424, 0.0630088895559311, 0.0630774423480034, 0.0631460025906563, 0.0632145926356316, 0.0632832199335098, 0.0633518770337105, 0.0634205639362335, 0.0634892806410789, 0.0635580271482468, 0.063626803457737, 0.0636968836188316, 0.0637681856751442, 0.0638394728302956, 0.0639107674360275, 0.0639820694923401, 0.0640533566474915, 0.0641246512532234, 0.0641959384083748, 0.0642672255635262, 0.0643385201692581, 0.0644097998738289, 0.0644810870289803, 0.064552366733551, 0.0646236538887024, 0.0646949261426926, 0.0647662058472633, 0.0648374781012535, 0.0649087578058243, 0.0649800300598145, 0.0650513097643852, 0.0651225671172142, 0.065193846821785, 0.0652651116251945, 0.0653363689780235, 0.0654076486825943, 0.0654789060354233, 0.0655501633882523, 0.0656214281916618, 0.0656926929950714, 0.0657639503479004, 0.0658352002501488, 0.0659064576029778, 0.0659777149558067, 0.0660489648580551, 0.0661201998591423, 0.0661914572119713, 0.0662627145648003, 0.0663339495658875, 0.0664051994681358, 0.0664764493703842, 0.0665476769208908, 0.0666189193725586, 0.0666901618242264, 0.0667613968253136, 0.0668326318264008, 0.0669038668274879, 0.0669751018285751, 0.0670463368296623, 0.0671175569295883, 0.0671887919306755, 0.0672600194811821, 0.0673312470316887, 0.0674024745821953, 0.0674736872315407, 0.0675449147820473, 0.0676161348819733, 0.0676873549818993, 0.0677585601806641, 0.0678297877311707, 0.0679009929299355, 0.0679722130298615, 0.0680434182286263, 0.0681146308779716, 0.0681858360767365, 0.0682570412755013, 0.0683282539248466, 0.0683994442224503, 0.0684706494212151, 0.0685418620705605, 0.0686130523681641, 0.0686842501163483, 0.0687554404139519, 0.0688266456127167, 0.0688978284597397, 0.0689690262079239, 0.0690402090549469, 0.0691114068031311, 0.0691826045513153, 0.0692537799477577, 0.0693249627947807, 0.0693961456418037, 0.0694673284888268, 0.0695385113358498, 0.0696096867322922, 0.0696808621287346, 0.0697520449757576, 0.0698232054710388, 0.0698943883180618, 0.0699655711650848, 0.0700367167592049, 0.0701078996062279, 0.0701790601015091, 0.0702502280473709, 0.0703213885426521, 0.0703925490379333, 0.0704637169837952, 0.0705348774790764, 0.0706060379743576, 0.0706771835684776, 0.0707483440637589, 0.0708194896578789, 0.0708906427025795, 0.0709617957472801, 0.0710329487919807, 0.0711041018366814, 0.0711752399802208, 0.0712463781237602, 0.0713175162672997, 0.0713886693120003, 0.0714598149061203, 0.0715309530496597, 0.0716020911931992, 0.0716732293367386, 0.071744367480278, 0.0718154981732368, 0.0718866214156151, 0.0719577521085739, 0.0720288753509521, 0.0721000134944916, 0.0721711441874504, 0.0722422525286674, 0.0723133832216263, 0.0723845064640045, 0.0724556297063828, 0.0725267380475998, 0.0725978538393974, 0.0726689845323563, 0.0727401003241539, 0.0728112012147903, 0.0728823095560074, 0.0729534327983856, 0.0730245411396027, 0.0730956420302391, 0.0731667429208755, 0.0732378363609314, 0.073308952152729, 0.0733800455927849, 0.0734511539340019, 0.0735222399234772, 0.0735933557152748, 0.0736644342541695, 0.0737355500459671, 0.0738066136837006, 0.073877714574337, 0.0739488005638123, 0.0740198940038681, 0.0740909725427628, 0.0741620659828186, 0.0742331594228745, 0.0743042305111885, 0.0743753165006638, 0.0744463875889778, 0.0745174586772919, 0.0745885372161865, 0.0746596232056618, 0.0747306942939758, 0.0748017579317093, 0.0748728290200233, 0.0749439001083374, 0.0750149711966515, 0.0750860273838043, 0.0751570984721184, 0.0752281695604324, 0.0752992257475853, 0.0753702819347382, 0.075441338121891, 0.0755124017596245, 0.0755834579467773, 0.0756545141339302, 0.0757255554199219, 0.0757966041564941, 0.075867660343647, 0.0759387165307999, 0.0760097503662109, 0.0760807991027832, 0.0761518403887749, 0.0762228891253471, 0.0762939304113388, 0.0763649567961693, 0.0764359980821609, 0.0765070393681526, 0.0765780732035637, 0.0766490995883942, 0.0767201259732246, 0.0767911672592163, 0.0768622010946274, 0.0769332274794579, 0.0770042464137077, 0.0770752727985382, 0.0771462991833687, 0.0772173181176186, 0.077288344502449, 0.0773593559861183, 0.0774303749203682, 0.0775014013051987, 0.0775724053382874, 0.0776434168219566, 0.0777144357562065, 0.0777854472398758, 0.0778564512729645, 0.0779274478554726, 0.0779984667897224, 0.0780694708228111, 0.0781404674053192, 0.0782114714384079, 0.0782824605703354, 0.0783534571528435, 0.0784244611859322, 0.0784954577684402, 0.0785664469003677, 0.0786374509334564, 0.0787084400653839, 0.0787794217467308, 0.0788504108786583, 0.0789214000105858, 0.0789923891425133, 0.0790633708238602, 0.0791343599557877, 0.079205334186554, 0.0792763084173203, 0.0793472975492477, 0.0794182792305946, 0.0794892385601997, 0.0795602202415466, 0.0796311870217323, 0.0797021687030792, 0.0797731280326843, 0.07984409481287, 0.0799150615930557, 0.079986035823822, 0.0800569951534271, 0.0801279470324516, 0.0801989063620567, 0.0802698582410812, 0.0803408324718475, 0.0804117769002914, 0.0804827362298965, 0.0805536881089211, 0.0806246474385262, 0.0806955918669701, 0.080766536295414, 0.0808374807238579, 0.0809084326028824, 0.0809793770313263, 0.081050306558609, 0.0811212584376335, 0.0811921954154968, 0.0812631398439407, 0.081334076821804, 0.0814050063490868, 0.0814759358763695, 0.0815468654036522, 0.0816178098320961, 0.0816887319087982, 0.0817596539855003, 0.0818305835127831, 0.0819015204906464, 0.0819724351167679, 0.0820433497428894, 0.0821142792701721, 0.0821851938962936, 0.0822561234235764, 0.0823270380496979, 0.0823979452252388, 0.0824688524007797, 0.0825397744774818, 0.0826106891036034, 0.0826815888285637, 0.0827524960041046, 0.0828234031796455, 0.0828943029046059, 0.0829652100801468, 0.0830361098051071, 0.0831070095300674, 0.0831779092550278, 0.0832488015294075, 0.0833197087049484, 0.0833905935287476, 0.0834614932537079, 0.0835323855280876, 0.0836032703518867, 0.0836741477251053, 0.083745039999485, 0.0838159397244453, 0.0838868096470833, 0.083957701921463, 0.0840285792946815, 0.0840994566679001, 0.0841703414916992, 0.0842412114143372, 0.0843120887875557, 0.084382951259613, 0.0844538435339928, 0.0845247060060501, 0.084595575928688, 0.0846664384007454, 0.0847373083233833, 0.0848081782460213, 0.0848790407180786, 0.0849498957395554, 0.0850207582116127, 0.0850916355848312, 0.0851624757051468, 0.0852333307266235, 0.0853041857481003, 0.085375040769577, 0.0854458957910538, 0.0855167433619499, 0.0855875909328461, 0.0856584310531616, 0.0857292860746384, 0.0858001261949539, 0.0858709663152695, 0.0859418138861656, 0.0860126465559006, 0.0860834941267967, 0.0861543193459511, 0.0862251669168472, 0.0862959921360016, 0.0863668397068977, 0.0864376574754715, 0.0865084901452065, 0.0865793153643608, 0.0866501405835152, 0.0867209732532501, 0.0867917835712433, 0.0868626236915588, 0.086933434009552, 0.0870042592287064, 0.0870750769972801, 0.0871458873152733, 0.087216705083847, 0.0872875228524208, 0.087358333170414, 0.0874291434884071, 0.0874999389052391, 0.0875707492232323, 0.0876415744423866, 0.0877123773097992, 0.0877831727266312, 0.0878539755940437, 0.0879247710108757, 0.0879955664277077, 0.0880663692951202, 0.0881371647119522, 0.0882079601287842, 0.0882787555456161, 0.0883495509624481, 0.0884203314781189, 0.0884911268949509, 0.0885619074106216, 0.088632695376873, 0.0887034758925438, 0.0887742638587952, 0.0888450443744659, 0.0889158248901367, 0.0889865979552269, 0.0890573784708977, 0.0891281589865685, 0.089198924601078, 0.0892697051167488, 0.089340478181839, 0.0894112437963486, 0.0894820094108582, 0.0895527750253677, 0.0896235480904579, 0.0896943137049675, 0.0897650644183159, 0.0898358300328255, 0.0899065881967545, 0.0899773463606834, 0.090048111975193, 0.0901188552379608, 0.0901896134018898, 0.0902603715658188, 0.090331107378006, 0.090401865541935, 0.0904726013541222, 0.0905433595180511, 0.0906140953302383, 0.0906848534941673, 0.0907555893063545, 0.0908263325691223, 0.0908970683813095, 0.0909677967429161, 0.0910385400056839, 0.0911092683672905, 0.0911800041794777, 0.0912507325410843, 0.0913214683532715, 0.0913921967148781, 0.0914629250764847, 0.0915336534380913, 0.0916043668985367, 0.0916751027107239, 0.0917458161711693, 0.0918165445327759, 0.0918872505426407, 0.0919579640030861, 0.0920286923646927, 0.0920994058251381, 0.0921701192855835, 0.0922408327460289, 0.0923115313053131, 0.0923822447657585, 0.0924529507756233, 0.0925236567854881, 0.0925943553447723, 0.0926650539040565, 0.0927357599139214, 0.0928064584732056, 0.0928771495819092, 0.0929478630423546, 0.0930185467004776, 0.0930892452597618, 0.0931599363684654, 0.093230627477169, 0.0933013111352921, 0.0933720022439957, 0.0934426859021187, 0.0935133695602417, 0.0935840606689453, 0.0936547219753265, 0.0937254205346107, 0.0937960967421532, 0.093866765499115, 0.0939374342560768, 0.0940081253647804, 0.0940788015723228, 0.0941494628787041, 0.0942201390862465, 0.0942907929420471, 0.0943614766001701, 0.0944321379065514, 0.0945028066635132, 0.0945734530687332, 0.094644121825695, 0.0947147831320763, 0.0947854369878769, 0.0948560982942581, 0.0949267521500587, 0.09499741345644, 0.0950680673122406, 0.0951387137174606, 0.0952093526721001, 0.0952800065279007, 0.0953506529331207, 0.0954212993383408, 0.0954919457435608, 0.0955625846982002, 0.0956332311034203, 0.0957038626074791, 0.0957745090126991, 0.0958451256155968, 0.0959157794713974, 0.0959864109754562, 0.0960570424795151, 0.0961276665329933, 0.0961982980370522, 0.096268929541111, 0.0963395461440086, 0.0964101776480675, 0.0964807942509651, 0.096551425755024, 0.0966220423579216, 0.0966926589608192, 0.0967632681131363, 0.0968338847160339, 0.0969045013189316, 0.0969751179218292, 0.0970457270741463, 0.0971163362264633, 0.0971869453787804, 0.097257561981678, 0.0973281636834145, 0.0973987579345703, 0.0974693521857262, 0.0975399687886238, 0.0976105704903603, 0.0976811572909355, 0.097751758992672, 0.0978223532438278, 0.0978929549455643, 0.0979635417461395, 0.0980341210961342, 0.0981047227978706, 0.0981753170490265, 0.0982458963990211, 0.0983164831995964, 0.0983870476484299, 0.0984576493501663, 0.098528228700161, 0.0985988080501556, 0.0986693724989891, 0.0987399518489838, 0.098810538649559, 0.0988811105489731, 0.0989516749978065, 0.0990222543478012, 0.0990928187966347, 0.099163256585598, 0.0992333590984344, 0.0993033945560455, 0.099373422563076, 0.0994433909654617, 0.0995133295655251, 0.0995832234621048, 0.099653072655201, 0.0997228920459747, 0.0997926518321037, 0.0998623892664909, 0.0999320670962334, 0.100001707673073, 0.100071333348751, 0.100140884518623, 0.100210405886173, 0.10027989000082, 0.100349336862564, 0.100418731570244, 0.100488103926182, 0.100557416677475, 0.100626684725285, 0.100695930421352, 0.100765131413937, 0.100834280252457, 0.100903391838074, 0.100972466170788, 0.101041503250599, 0.101110495626926, 0.10117943584919, 0.101248346269131, 0.10131723433733, 0.101386047899723, 0.101454846560955, 0.101523585617542, 0.101592294871807, 0.101660951972008, 0.101729579269886, 0.101798161864281, 0.101866699755192, 0.1019352003932, 0.102003663778305, 0.102072082459927, 0.102140448987484, 0.10220880061388, 0.102277092635632, 0.102345339953899, 0.102413550019264, 0.102481737732887, 0.102549873292446, 0.102617956697941, 0.102686010301113, 0.102754011750221, 0.102821990847588, 0.10288991779089, 0.102957800030708, 0.103025645017624, 0.103093445301056, 0.103161215782166, 0.103228941559792, 0.103296622633934, 0.103364259004593, 0.103431865572929, 0.103499427437782, 0.103566937148571, 0.103634417057037, 0.10370185226202, 0.10376925766468, 0.103836618363857, 0.103903919458389, 0.10397119820118, 0.104038432240486, 0.104105614125729, 0.104172766208649, 0.104239873588085, 0.104306936264038, 0.104373969137669, 0.104440964758396, 0.104507900774479, 0.104574806988239, 0.104641668498516, 0.10470849275589, 0.10477527230978, 0.104842014610767, 0.104908712208271, 0.104975387454033, 0.10504200309515, 0.105108574032784, 0.105175107717514, 0.105241611599922, 0.105308063328266, 0.105374470353127, 0.105440847575665, 0.105507172644138, 0.10557347536087, 0.105639718472958, 0.105705916881561, 0.105772092938423, 0.105838224291801, 0.105904310941696, 0.105970352888107, 0.106036357581615, 0.10610231757164, 0.106168247759342, 0.10623412579298, 0.106299966573715, 0.106365762650967, 0.106431528925896, 0.106497243046761, 0.106562912464142, 0.106628552079201, 0.106694146990776, 0.106759704649448, 0.106825225055218, 0.106890685856342, 0.106956116855145, 0.107021510601044, 0.107086859643459, 0.107152163982391, 0.107217438519001, 0.107282660901546, 0.10734785348177, 0.107412986457348, 0.107478089630604, 0.107543163001537, 0.107608191668987, 0.107673168182373, 0.107738107442856, 0.107803009450436, 0.107867859303951, 0.107932679355145, 0.107997462153435, 0.108062192797661, 0.108126893639565, 0.108191542327404, 0.10825614631176, 0.108320727944374, 0.108385257422924, 0.10844974219799, 0.108514197170734, 0.108578607439995, 0.108642980456352, 0.108707301318645, 0.108771592378616, 0.108835831284523, 0.108900025486946, 0.108964197337627, 0.109028324484825, 0.109092399477959, 0.10915644466877, 0.109220430254936, 0.10928438603878, 0.109348319470882, 0.10941219329834, 0.109476022422314, 0.109539821743965, 0.109603576362133, 0.109667286276817, 0.109730951488018, 0.109794586896896, 0.109858177602291, 0.109921731054783, 0.109985239803791, 0.110048703849316, 0.110112130641937, 0.110175520181656, 0.110238865017891, 0.110302165150642, 0.11036542057991, 0.110428646206856, 0.110491827130318, 0.110554970800877, 0.110618062317371, 0.110681116580963, 0.110744141042233, 0.110807113349438, 0.110870055854321, 0.110932946205139, 0.110995791852474, 0.111058615148067, 0.111121378839016, 0.111184105277061, 0.111246801912785, 0.111309446394444, 0.111372053623199, 0.111434616148472, 0.111497148871422, 0.111559621989727, 0.11162207275629, 0.111684486269951, 0.111746840178967, 0.111809149384499, 0.11187145113945, 0.111933693289757, 0.111995883285999, 0.112058043479919, 0.112120158970356, 0.11218223720789, 0.11224427074194, 0.112306259572506, 0.112368211150169, 0.11243012547493, 0.112492002546787, 0.112553820014, 0.11261560767889, 0.112677358090878, 0.112739086151123, 0.112800739705563, 0.11286236345768, 0.112923942506313, 0.112985491752625, 0.113046996295452, 0.113108456134796, 0.113169871270657, 0.113231249153614, 0.113292597234249, 0.113353900611401, 0.113415151834488, 0.113476365804672, 0.113537549972534, 0.113598689436913, 0.113659776747227, 0.113720826804638, 0.113781832158566, 0.113842807710171, 0.113903738558292, 0.11396461725235, 0.114025473594666, 0.114086285233498, 0.114147052168846, 0.11420776695013, 0.114268451929092, 0.114329099655151, 0.114389710128307, 0.114450260996819, 0.114510789513588, 0.114571258425713, 0.114631704986095, 0.114692106842995, 0.11475245654583, 0.114812768995762, 0.114873044192791, 0.114933289587498, 0.114993467926979, 0.115053623914719, 0.115113727748394, 0.115173816680908, 0.115233846008778, 0.115293830633163, 0.115353770554066, 0.115413680672646, 0.115473546087742, 0.115533366799355, 0.115593150258064, 0.115652896463871, 0.115712597966194, 0.115772269666195, 0.115831889212132, 0.115891471505165, 0.115950994193554, 0.116010501980782, 0.116069965064526, 0.116129368543625, 0.116188742220402, 0.116248093545437, 0.116307370364666, 0.116366617381573, 0.116425842046738, 0.116485007107258, 0.116544142365456, 0.116603225469589, 0.11666227132082, 0.116721279919147, 0.116780258715153, 0.116839170455933, 0.11689805239439, 0.116956897079945, 0.117015682160854, 0.117074459791183, 0.117133185267448, 0.117191858589649, 0.117250502109528, 0.117309086024761, 0.117367647588253, 0.117426156997681, 0.117484629154205, 0.117543071508408, 0.117601446807384, 0.117659814655781, 0.117718115448952, 0.1177763864398, 0.117834620177746, 0.117892809212208, 0.117950960993767, 0.118009068071842, 0.118067130446434, 0.118125170469284, 0.118183121085167, 0.11824107915163, 0.118298977613449, 0.118356853723526, 0.118414670228958, 0.118472434580326, 0.118530169129372, 0.118587866425514, 0.118645533919334, 0.11870314180851, 0.118760712444782, 0.118818245828152, 0.118875749409199, 0.118933193385601, 0.1189906001091, 0.119047977030277, 0.11910530179739, 0.11916259676218, 0.119219839572906, 0.119277037680149, 0.11933421343565, 0.119391344487667, 0.11944841593504, 0.11950546503067, 0.119562461972237, 0.1196194216609, 0.11967633664608, 0.119733221828938, 0.11979004740715, 0.119846850633621, 0.119903609156609, 0.119960315525532, 0.120017006993294, 0.12007362395525, 0.120130218565464, 0.120186775922775, 0.120243273675442, 0.120299741625786, 0.120356172323227, 0.120412565767765, 0.120468907058239, 0.120525218546391, 0.120581477880478, 0.120637707412243, 0.120693884789944, 0.120750024914742, 0.120806142687798, 0.120862185955048, 0.120918206870556, 0.120974183082581, 0.121030129492283, 0.121086023747921, 0.121141873300076, 0.121197685599327, 0.121253453195095, 0.12130918353796, 0.121364884078503, 0.121420532464981, 0.121476151049137, 0.121531717479229, 0.121587239205837, 0.121642731130123, 0.121698170900345, 0.121753588318825, 0.121808953583241, 0.121864274144173, 0.121919550001621, 0.121974796056747, 0.122030004858971, 0.122085154056549, 0.122140280902386, 0.122195348143578, 0.122250385582447, 0.122305370867252, 0.122360333800316, 0.122415252029896, 0.122470125555992, 0.122524961829185, 0.122579753398895, 0.122634492814541, 0.122689209878445, 0.122743874788284, 0.122798502445221, 0.122853092849255, 0.122907638549805, 0.122962146997452, 0.123016610741615, 0.123071029782295, 0.123125411570072, 0.123179756104946, 0.123234041035175, 0.123288311064243, 0.123342528939247, 0.123396702110767, 0.123450852930546, 0.123504929244518, 0.123559013009071, 0.123613007366657, 0.123666971921921, 0.123720914125443, 0.1237748041749, 0.123828664422035, 0.123882465064526, 0.123936243355274, 0.123989962041378, 0.124043636023998, 0.124097302556038, 0.124150894582272, 0.124204464256763, 0.124257981777191, 0.124311454594135, 0.124364905059338, 0.124418310821056, 0.12447165697813, 0.124524980783463, 0.124578267335892, 0.124631494283676, 0.124684691429138, 0.124737851321697, 0.124790951609612, 0.124844044446945, 0.124897077679634, 0.124950058758259, 0.125003010034561, 0.125055909156799, 0.125108778476715, 0.125161603093147, 0.125214397907257, 0.125267133116722, 0.125319838523865, 0.125372499227524, 0.12542513012886, 0.125477701425552, 0.125530257821083, 0.125582739710808, 0.125635221600533, 0.12568761408329, 0.125740006566048, 0.12579233944416, 0.12584462761879, 0.125896900892258, 0.12594909965992, 0.126001253724098, 0.126053392887115, 0.12610550224781, 0.126157537102699, 0.126209542155266, 0.12626151740551, 0.126313447952271, 0.126365318894386, 0.126417174935341, 0.126468986272812, 0.126520738005638, 0.126572459936142, 0.126624152064323, 0.12667578458786, 0.126727387309074, 0.126778945326805, 0.126830458641052, 0.126881942152977, 0.126933380961418, 0.126984775066376, 0.12703612446785, 0.12708742916584, 0.127138704061508, 0.127189934253693, 0.127241119742393, 0.127292290329933, 0.127343401312828, 0.127394452691078, 0.127445474267006, 0.127496480941772, 0.127547428011894, 0.127598315477371, 0.127649173140526, 0.127700001001358, 0.127750769257545, 0.127801507711411, 0.127852216362953, 0.127902880311012, 0.127953499555588, 0.12800407409668, 0.128054618835449, 0.128105089068413, 0.128155544400215, 0.128205969929695, 0.12825633585453, 0.128306671977043, 0.128356963396072, 0.128407195210457, 0.128457427024841, 0.128507599234581, 0.128557696938515, 0.128607779741287, 0.128657832741737, 0.128707826137543, 0.128757804632187, 0.128807708621025, 0.128857612609863, 0.128907442092896, 0.128957241773605, 0.129006996750832, 0.129056721925735, 0.129104852676392, 0.129151374101639, 0.129197806119919, 0.129244193434715, 0.129290491342545, 0.129336729645729, 0.129382893443108, 0.129429012537003, 0.129475057125092, 0.129521057009697, 0.129566937685013, 0.129612788558006, 0.129658564925194, 0.129704281687737, 0.129749923944473, 0.129795506596565, 0.129841014742851, 0.129886463284492, 0.129931837320328, 0.129977151751518, 0.130022421479225, 0.130067586898804, 0.130112707614899, 0.130157738924026, 0.130202740430832, 0.13024765253067, 0.130292490124702, 0.130337283015251, 0.130382001399994, 0.130426645278931, 0.130471244454384, 0.13051575422287, 0.130560204386711, 0.130604594945908, 0.130648910999298, 0.130693167448044, 0.130737349390984, 0.130781471729279, 0.130825534462929, 0.130869507789612, 0.130913451313972, 0.130957290530205, 0.131001099944115, 0.131044819951057, 0.131088465452194, 0.131132066249847, 0.131175592541695, 0.131219059228897, 0.131262436509132, 0.131305769085884, 0.131349012255669, 0.131392225623131, 0.131435349583626, 0.131478399038315, 0.13152140378952, 0.13156433403492, 0.131607204675674, 0.131649985909462, 0.131692722439766, 0.131735384464264, 0.131778001785278, 0.131820514798164, 0.131862983107567, 0.131905391812325, 0.131947711110115, 0.131990000605583, 0.132032185792923, 0.132074311375618, 0.132116377353668, 0.132158398628235, 0.132200315594673, 0.132242187857628, 0.132284015417099, 0.132325723767281, 0.13236740231514, 0.132409021258354, 0.132450550794601, 0.132492020726204, 0.132533431053162, 0.132574751973152, 0.132616028189659, 0.132657244801521, 0.132698372006416, 0.132739454507828, 0.132780447602272, 0.132821410894394, 0.132862269878387, 0.132903069257736, 0.132943823933601, 0.132984504103661, 0.133025109767914, 0.133065670728683, 0.133106142282486, 0.133146539330482, 0.133186906576157, 0.133227169513702, 0.133267387747765, 0.133307531476021, 0.133347615599632, 0.133387625217438, 0.133427575230598, 0.133467450737953, 0.133507266640663, 0.133547022938728, 0.133586704730988, 0.133626326918602, 0.13366587460041, 0.133705347776413, 0.133744776248932, 0.133784115314484, 0.133823409676552, 0.133862629532814, 0.13390177488327, 0.133940860629082, 0.133979886770248, 0.134018838405609, 0.134057730436325, 0.134096547961235, 0.1341353058815, 0.134173989295959, 0.134212598204613, 0.134251177310944, 0.134289667010307, 0.134328067302704, 0.134366437792778, 0.134404733777046, 0.13444297015667, 0.134481117129326, 0.134519204497337, 0.134557232260704, 0.134595200419426, 0.134633079171181, 0.134670913219452, 0.134708672761917, 0.134746387600899, 0.134783998131752, 0.134821563959122, 0.134859070181847, 0.134896501898766, 0.134933859109879, 0.134971156716347, 0.13500839471817, 0.135045543313026, 0.135082647204399, 0.135119691491127, 0.135156646370888, 0.135193556547165, 0.135230392217636, 0.135267153382301, 0.135303869843483, 0.135340481996536, 0.135377049446106, 0.135413557291031, 0.13544999063015, 0.135486364364624, 0.135522678494453, 0.135558918118477, 0.135595083236694, 0.135631203651428, 0.135667219758034, 0.135703206062317, 0.135739102959633, 0.135774925351143, 0.135810717940331, 0.135846436023712, 0.135882079601288, 0.135917648673058, 0.135953158140182, 0.13598857820034, 0.136023968458176, 0.136059284210205, 0.136094525456429, 0.136129707098007, 0.13616481423378, 0.136199861764908, 0.13623483479023, 0.136269748210907, 0.136304602026939, 0.136339381337166, 0.136374086141586, 0.136408731341362, 0.136443316936493, 0.13647785782814, 0.136512279510498, 0.136546671390533, 0.136580973863602, 0.136615231633186, 0.136649414896965, 0.136683523654938, 0.136717587709427, 0.13675157725811, 0.136785492300987, 0.13681934773922, 0.136853128671646, 0.136886835098267, 0.136920511722565, 0.136954084038734, 0.136987596750259, 0.137021064758301, 0.137054473161697, 0.137087792158127, 0.13712103664875, 0.13715423643589, 0.137187346816063, 0.137220412492752, 0.137253403663635, 0.137286320328712, 0.137319177389145, 0.137351989746094, 0.137384712696075, 0.137417361140251, 0.137449949979782, 0.137482479214668, 0.13751494884491, 0.137547343969345, 0.137579664587975, 0.137611925601959, 0.13764414191246, 0.137676268815994, 0.137708321213722, 0.137740314006805, 0.137772262096405, 0.137804120779037, 0.137835919857025, 0.137867659330368, 0.137899324297905, 0.137930914759636, 0.137962460517883, 0.137993916869164, 0.138025313615799, 0.13805665075779, 0.138087928295135, 0.138119131326675, 0.138150259852409, 0.138181328773499, 0.138212338089943, 0.138243272900581, 0.138274148106575, 0.138304933905602, 0.138335689902306, 0.138366356492043, 0.138396978378296, 0.138427510857582, 0.138457998633385, 0.13848839700222, 0.13851872086525, 0.138549000024796, 0.138579204678535, 0.138609364628792, 0.138639435172081, 0.138669446110725, 0.138699397444725, 0.138729274272919, 0.138759091496468, 0.138788834214211, 0.138818517327309, 0.138848125934601, 0.138877674937248, 0.13890714943409, 0.138936564326286, 0.138965904712677, 0.138995185494423, 0.139024406671524, 0.139053553342819, 0.13908264040947, 0.139111638069153, 0.139140591025352, 0.139169484376907, 0.139198303222656, 0.13922706246376, 0.139255732297897, 0.139284357428551, 0.139312908053398, 0.139341399073601, 0.139369815587997, 0.139398172497749, 0.139426469802856, 0.139454677700996, 0.139482825994492, 0.139510929584503, 0.139538943767548, 0.139566898345947, 0.139594778418541, 0.139622613787651, 0.139650374650955, 0.139678061008453, 0.139705687761307, 0.139733254909515, 0.139760732650757, 0.139788165688515, 0.139815524220467, 0.139842823147774, 0.139870047569275, 0.139897212386131, 0.139924302697182, 0.139951348304749, 0.139978304505348, 0.140005201101303, 0.140032038092613, 0.140058785676956, 0.140085488557816, 0.140112116932869, 0.140138685703278, 0.14016517996788, 0.140191599726677, 0.140217989683151, 0.140244290232658, 0.14027051627636, 0.140296682715416, 0.140322774648666, 0.140348821878433, 0.140374794602394, 0.140400692820549, 0.140426531434059, 0.140452295541763, 0.140478000044823, 0.140503644943237, 0.140529215335846, 0.14055472612381, 0.140580162405968, 0.140605539083481, 0.140630841255188, 0.14065608382225, 0.140681251883507, 0.140706360340118, 0.140731409192085, 0.140756368637085, 0.140781283378601, 0.140806138515472, 0.140830904245377, 0.140855625271797, 0.140880256891251, 0.140904828906059, 0.140929341316223, 0.140953794121742, 0.140978172421455, 0.141002491116524, 0.141026720404625, 0.141050904989243, 0.141075015068054, 0.141099080443382, 0.141123041510582, 0.141146972775459, 0.141170814633369, 0.141194596886635, 0.141218319535255, 0.141241952776909, 0.141265541315079, 0.141289070248604, 0.141312509775162, 0.141335904598236, 0.141359224915504, 0.141382470726967, 0.141405671834946, 0.141428783535957, 0.141451835632324, 0.141474828124046, 0.141497761011124, 0.141520604491234, 0.141543388366699, 0.141566097736359, 0.141588777303696, 0.141611352562904, 0.141633868217468, 0.14165635406971, 0.141678720712662, 0.141701072454453, 0.141723304986954, 0.141745507717133, 0.141767621040344, 0.141789704561234, 0.141811698675156, 0.141833618283272, 0.141855463385582, 0.141877263784409, 0.14189900457859, 0.141920655965805, 0.141942262649536, 0.141963794827461, 0.14198525249958, 0.142006650567055, 0.142027989029884, 0.142049238085747, 0.142070457339287, 0.14209158718586, 0.142112642526627, 0.142133638262749, 0.142154589295387, 0.142175450921059, 0.142196252942085, 0.142216980457306, 0.142237648367882, 0.142258256673813, 0.142278805375099, 0.142299264669418, 0.142319664359093, 0.142340004444122, 0.142360270023346, 0.142380475997925, 0.14240063726902, 0.142420694231987, 0.142440691590309, 0.142460629343987, 0.14248052239418, 0.142500326037407, 0.142520055174828, 0.142539739608765, 0.142559349536896, 0.142578899860382, 0.142598360776901, 0.142617776989937, 0.142637133598328, 0.142656400799751, 0.142675623297691, 0.142694756388664, 0.142713829874992, 0.142732843756676, 0.142751783132553, 0.142770677804947, 0.142789497971535, 0.142808243632317, 0.142826914787292, 0.142845526337624, 0.14286407828331, 0.14288255572319, 0.142900973558426, 0.142919316887856, 0.14293760061264, 0.14295582473278, 0.142973989248276, 0.142992064356804, 0.143010079860687, 0.143028035759926, 0.143045917153358, 0.143063738942146, 0.143081501126289, 0.143099188804626, 0.143116801977158, 0.143134370446205, 0.143151849508286, 0.143169268965721, 0.143186628818512, 0.143203914165497, 0.143221139907837, 0.143238291144371, 0.143255397677422, 0.143272414803505, 0.143289372324944, 0.143306270241737, 0.143323078751564, 0.143339857459068, 0.143356546759605, 0.143373176455498, 0.143389746546745, 0.143406242132187, 0.143422663211823, 0.143439024686813, 0.143455326557159, 0.1434715539217, 0.143487706780434, 0.143503829836845, 0.143519848585129, 0.143535807728767, 0.143551722168922, 0.143567532300949, 0.143583312630653, 0.143599003553391, 0.143614649772644, 0.14363020658493, 0.143645718693733, 0.143661141395569, 0.14367650449276, 0.143691822886467, 0.143707051873207, 0.143722236156464, 0.143737331032753, 0.143752366304398, 0.143767341971397, 0.143782243132591, 0.14379708468914, 0.143811851739883, 0.143826559185982, 0.143841207027435, 0.143855780363083, 0.143870279192924, 0.143884718418121, 0.143899098038673, 0.143913418054581, 0.143927663564682, 0.143941834568977, 0.143955945968628, 0.143969967961311, 0.143983960151672, 0.143997877836227, 0.144011721014977, 0.14402548968792, 0.144039198756218, 0.144052863121033, 0.14406643807888, 0.144079938530922, 0.14409239590168, 0.144103825092316, 0.144115164875984, 0.144126430153847, 0.144137635827065, 0.144148752093315, 0.144159808754921, 0.144170805811882, 0.144181728363037, 0.144192561507225, 0.144203335046768, 0.144214034080505, 0.144224643707275, 0.144235208630562, 0.144245699048042, 0.144256114959717, 0.144266456365585, 0.144276723265648, 0.144286930561066, 0.144297063350677, 0.144307121634483, 0.144317105412483, 0.144327029585838, 0.144336864352226, 0.144346624612808, 0.144356340169907, 0.144365951418877, 0.144375517964363, 0.144385010004044, 0.144394427537918, 0.144403785467148, 0.14441305398941, 0.144422262907028, 0.144431382417679, 0.144440442323685, 0.144449427723885, 0.14445835351944, 0.144467189908028, 0.144475966691971, 0.144484668970108, 0.1444933116436, 0.144501850008965, 0.144510343670845, 0.14451876282692, 0.144527122378349, 0.144535392522812, 0.14454360306263, 0.14455172419548, 0.144559800624847, 0.144567787647247, 0.144575700163841, 0.144583538174629, 0.144591316580772, 0.144599035382271, 0.144606664776802, 0.144614219665527, 0.144621729850769, 0.144629135727882, 0.144636482000351, 0.144643753767014, 0.144650980830193, 0.144658103585243, 0.144665166735649, 0.144672140479088, 0.144679069519043, 0.144685924053192, 0.144692704081535, 0.144699409604073, 0.144706040620804, 0.14471261203289, 0.144719108939171, 0.144725516438484, 0.144731879234314, 0.144738152623177, 0.144744351506233, 0.144750505685806, 0.144756555557251, 0.144762545824051, 0.144768476486206, 0.144774332642555, 0.144780099391937, 0.144785806536674, 0.144791454076767, 0.144797012209892, 0.144802510738373, 0.144807934761047, 0.144813269376755, 0.144818559288979, 0.144823774695396, 0.144828915596008, 0.144833967089653, 0.144838973879814, 0.144843891263008, 0.144848734140396, 0.144853517413139, 0.144858241081238, 0.144862875342369, 0.144867449998856, 0.144871935248375, 0.14487636089325, 0.144880712032318, 0.144885003566742, 0.144889205694199, 0.14489334821701, 0.144897416234016, 0.144901409745216, 0.144905343651772, 0.14490918815136, 0.144912973046303, 0.14491668343544, 0.144920334219933, 0.144923895597458, 0.144927397370338, 0.144930824637413, 0.144934192299843, 0.144937455654144, 0.144940659403801, 0.144943803548813, 0.14494688808918, 0.14494988322258, 0.144952803850174, 0.144955664873123, 0.144958436489105, 0.144961163401604, 0.144963800907135, 0.14496636390686, 0.144968867301941, 0.144971296191216, 0.144973650574684, 0.144975930452347, 0.144978150725365, 0.144980296492577, 0.144982367753983, 0.144984364509583, 0.144986286759377, 0.144988149404526, 0.144989937543869, 0.144991651177406, 0.144993290305138, 0.144994869828224, 0.144996374845505, 0.144997805356979, 0.144999146461487, 0.145000442862511, 0.145001649856567, 0.145002812147141, 0.145003885030746, 0.145004868507385, 0.14500580728054, 0.14500667154789, 0.145007461309433, 0.14500817656517, 0.14500880241394, 0.145009398460388, 0.145009890198708, 0.145010307431221, 0.145010679960251, 0.145010977983475, 0.145011201500893, 0.145011335611343, 0.145011410117149, 0.145011410117149, 0.145011350512505, 0.145011201500893, 0.145010992884636, 0.145010709762573, 0.145010352134705, 0.145009934902191, 0.145009428262711, 0.145008876919746, 0.145008221268654, 0.145007520914078, 0.145006746053696, 0.145005881786346, 0.145004957914352, 0.145003959536552, 0.145002901554108, 0.145001769065857, 0.145000547170639, 0.144999280571938, 0.144997924566269, 0.144996508955956, 0.144995003938675, 0.14499343931675, 0.144991800189018, 0.144990101456642, 0.144988313317299, 0.144986465573311, 0.144984543323517, 0.144982546567917, 0.144980490207672, 0.14497834444046, 0.144976139068604, 0.144973859190941, 0.144971519708633, 0.14496910572052, 0.144966602325439, 0.144964024424553, 0.144961401820183, 0.144958674907684, 0.144955903291702, 0.144953072071075, 0.14495013654232, 0.144947156310081, 0.144944086670876, 0.144940942525864, 0.144937738776207, 0.144934460520744, 0.144931122660637, 0.144927695393562, 0.144924223423004, 0.144920662045479, 0.144917011260986, 0.14491331577301, 0.144909530878067, 0.144905686378479, 0.144901767373085, 0.144897788763046, 0.14489372074604, 0.14488959312439, 0.144885390996933, 0.144881099462509, 0.144876763224602, 0.144872352480888, 0.144867837429047, 0.144863277673721, 0.144858658313751, 0.144853964447975, 0.144849181175232, 0.144844338297844, 0.14483942091465, 0.14483442902565, 0.144829377532005, 0.144824236631393, 0.144819051027298, 0.144813761115074, 0.144808411598206, 0.144803002476692, 0.144797518849373, 0.144791960716248, 0.144786328077316, 0.144780620932579, 0.144774839282036, 0.144769012928009, 0.144763097167015, 0.144757106900215, 0.14475105702877, 0.144744902849197, 0.144738718867302, 0.144732445478439, 0.14472608268261, 0.144719690084457, 0.144713193178177, 0.144706651568413, 0.14470000565052, 0.144693315029144, 0.144686535000801, 0.144679710268974, 0.144672781229019, 0.144665792584419, 0.144658744335175, 0.144651606678963, 0.144644409418106, 0.144637152552605, 0.144629806280136, 0.144622385501862, 0.144614905118942, 0.144607350230217, 0.144599735736847, 0.144592016935349, 0.144584253430367, 0.144576415419579, 0.144568502902985, 0.144560515880585, 0.14455246925354, 0.144544333219528, 0.144536137580872, 0.144527867436409, 0.144519537687302, 0.144511118531227, 0.144502624869347, 0.144494086503983, 0.144485473632812, 0.144476756453514, 0.144467979669571, 0.144459158182144, 0.14445024728775, 0.14444126188755, 0.144432216882706, 0.144423082470894, 0.144413888454437, 0.144404605031013, 0.144395276904106, 0.144385859370232, 0.144376382231712, 0.144366830587387, 0.144357219338417, 0.144347503781319, 0.144337743520737, 0.144327908754349, 0.144318014383316, 0.144308030605316, 0.14429797232151, 0.14428785443306, 0.144277647137642, 0.144267395138741, 0.144257053732872, 0.144246652722359, 0.144236162304878, 0.144225597381592, 0.144214987754822, 0.144204288721085, 0.144193530082703, 0.144182696938515, 0.144171804189682, 0.144160807132721, 0.144149765372276, 0.144138649106026, 0.144127458333969, 0.144116178154945, 0.144104853272438, 0.144093438982964, 0.144081965088844, 0.144070416688919, 0.144058808684349, 0.144047096371651, 0.144035339355469, 0.144023507833481, 0.144011601805687, 0.143999621272087, 0.143987566232681, 0.143975451588631, 0.143963262438774, 0.143950998783112, 0.143938660621643, 0.14392626285553, 0.143913790583611, 0.143901243805885, 0.143888622522354, 0.143875926733017, 0.143863156437874, 0.143850341439247, 0.143837422132492, 0.143824443221092, 0.143811419606209, 0.143798291683197, 0.14378510415554, 0.143771857023239, 0.143758520483971, 0.143745109438896, 0.143731638789177, 0.143718078732491, 0.143704473972321, 0.143690779805183, 0.143677026033401, 0.143663197755814, 0.14364929497242, 0.143635302782059, 0.143621280789375, 0.143607139587402, 0.143592953681946, 0.143578708171844, 0.143564373254776, 0.143549963831902, 0.143535494804382, 0.143520951271057, 0.143506333231926, 0.143491640686989, 0.143476888537407, 0.143462061882019, 0.143447160720825, 0.143432199954987, 0.143417149782181, 0.143402025103569, 0.143386840820312, 0.14337158203125, 0.143356263637543, 0.143340870738029, 0.143325388431549, 0.143309861421585, 0.143294245004654, 0.143278554081917, 0.143262788653374, 0.143246963620186, 0.143231064081192, 0.143215090036392, 0.143199056386948, 0.143182948231697, 0.143166750669479, 0.143150508403778, 0.14313417673111, 0.143117770552635, 0.143101289868355, 0.143084779381752, 0.143068164587021, 0.143051475286484, 0.143034726381302, 0.143017888069153, 0.14300100505352, 0.142984017729759, 0.142966985702515, 0.142949864268303, 0.142932683229446, 0.142915442585945, 0.142898127436638, 0.142880722880363, 0.142863243818283, 0.142845705151558, 0.142828091979027, 0.142810419201851, 0.142792657017708, 0.14277483522892, 0.142756938934326, 0.142738983035088, 0.142720922827721, 0.142702832818031, 0.142684638500214, 0.142666399478912, 0.142648071050644, 0.142629683017731, 0.14261120557785, 0.142592668533325, 0.142574056982994, 0.142555385828018, 0.142536610364914, 0.142517805099487, 0.142498925328255, 0.142479956150055, 0.14246092736721, 0.142441809177399, 0.142422631382942, 0.14240337908268, 0.142384052276611, 0.142364636063576, 0.142345190048218, 0.142325654625893, 0.142306059598923, 0.142286375164986, 0.142266616225243, 0.142246797680855, 0.142226904630661, 0.142206937074661, 0.142186895012856, 0.142166808247566, 0.142146617174149, 0.142126381397247, 0.142106056213379, 0.142085671424866, 0.142065182328224, 0.142044678330421, 0.142024055123329, 0.142003387212753, 0.14198262989521, 0.141961812973022, 0.141940921545029, 0.14191997051239, 0.141898930072784, 0.141877815127373, 0.141856640577316, 0.141835391521454, 0.141814097762108, 0.141792684793472, 0.141771227121353, 0.141749694943428, 0.141728088259697, 0.141706421971321, 0.141684666275978, 0.14166285097599, 0.141640961170197, 0.141618996858597, 0.141596972942352, 0.141574874520302, 0.141552686691284, 0.141530439257622, 0.141508132219315, 0.14148573577404, 0.141463279724121, 0.141440749168396, 0.141418144106865, 0.141395479440689, 0.141372725367546, 0.141349926590919, 0.141327023506165, 0.141304060816765, 0.14128103852272, 0.141257926821709, 0.141234755516052, 0.141211524605751, 0.141188204288483, 0.141164809465408, 0.141141355037689, 0.141117826104164, 0.141094222664833, 0.141070559620857, 0.141046807169914, 0.141022995114326, 0.140999108552933, 0.140975162386894, 0.140951126813889, 0.140927016735077, 0.14090184867382, 0.140875637531281, 0.140849351882935, 0.140823006629944, 0.140796601772308, 0.140770122408867, 0.140743613243103, 0.140717014670372, 0.140690356492996, 0.140663668513298, 0.140636891126633, 0.140610054135323, 0.140583157539368, 0.140556216239929, 0.140529215335846, 0.140502139925957, 0.140475004911423, 0.140447810292244, 0.14042055606842, 0.140393242239952, 0.140365868806839, 0.140338435769081, 0.140310943126678, 0.14028337597847, 0.140255779027939, 0.140228092670441, 0.140200346708298, 0.140172556042671, 0.1401447057724, 0.140116766095161, 0.140088796615601, 0.140060752630234, 0.140032649040222, 0.140004485845566, 0.139976263046265, 0.13994799554348, 0.139919638633728, 0.139891237020493, 0.139862760901451, 0.139834254980087, 0.139805659651756, 0.139777004718781, 0.139748305082321, 0.139719545841217, 0.139690712094307, 0.139661818742752, 0.139632880687714, 0.139603853225708, 0.13957479596138, 0.139545664191246, 0.139516487717628, 0.139487236738205, 0.139457911252975, 0.139428526163101, 0.139399111270905, 0.139369606971741, 0.139340057969093, 0.139310449361801, 0.139280751347542, 0.139251038432121, 0.139221236109734, 0.139191374182701, 0.139161467552185, 0.139131471514702, 0.139101445674896, 0.139071345329285, 0.139041185379028, 0.139010965824127, 0.138980686664581, 0.138950347900391, 0.138919934630394, 0.138889476656914, 0.138858959078789, 0.138828366994858, 0.138797730207443, 0.138767018914223, 0.138736248016357, 0.138705432415009, 0.138674542307854, 0.138643607497215, 0.13861258327961, 0.138581514358521, 0.138550400733948, 0.138519197702408, 0.138487949967384, 0.138456642627716, 0.138425275683403, 0.138393834233284, 0.138362348079681, 0.138330802321434, 0.138299182057381, 0.138267502188683, 0.138235777616501, 0.138203978538513, 0.138172119855881, 0.138140201568604, 0.138108238577843, 0.138076201081276, 0.138044103980064, 0.138011947274208, 0.137979716062546, 0.1379474401474, 0.13791511952877, 0.137882694602013, 0.137850239872932, 0.137817725539207, 0.137785136699677, 0.137752488255501, 0.137719795107841, 0.137687027454376, 0.137654200196266, 0.137621328234673, 0.137588381767273, 0.137555375695229, 0.137522310018539, 0.137489169836044, 0.137455999851227, 0.137422740459442, 0.137389436364174, 0.137356072664261, 0.137322634458542, 0.137289151549339, 0.137255609035492, 0.137221977114677, 0.137188300490379, 0.137154564261436, 0.13712078332901, 0.137086927890778, 0.137053027749062, 0.13701905310154, 0.136985018849373, 0.1369509100914, 0.136916771531105, 0.136882543563843, 0.136848270893097, 0.136813923716545, 0.13677953183651, 0.136745065450668, 0.136710554361343, 0.136675968766212, 0.136641338467598, 0.136606633663177, 0.136571869254112, 0.136537045240402, 0.136502161622047, 0.136467218399048, 0.136432215571404, 0.136397153139114, 0.13636203110218, 0.136326849460602, 0.136291593313217, 0.136256277561188, 0.136220932006836, 0.136185497045517, 0.136150002479553, 0.136114463210106, 0.136078849434853, 0.136043176054955, 0.136007457971573, 0.135971680283546, 0.135935813188553, 0.135899901390076, 0.135863929986954, 0.135827898979187, 0.135791808366776, 0.135755643248558, 0.135719418525696, 0.135683164000511, 0.135646820068359, 0.135610431432724, 0.135573968291283, 0.135537445545197, 0.135500863194466, 0.135464236140251, 0.135427534580231, 0.135390773415565, 0.135353952646255, 0.135317072272301, 0.135280132293701, 0.135243132710457, 0.135206073522568, 0.135168939828873, 0.135131761431694, 0.135094508528709, 0.135057225823402, 0.135019853711128, 0.134982407093048, 0.134944945573807, 0.134907379746437, 0.134869784116745, 0.134832113981247, 0.134794384241104, 0.134756609797478, 0.134718745946884, 0.134680837392807, 0.134642869234085, 0.134604841470718, 0.134566739201546, 0.134528577327728, 0.134490370750427, 0.134452104568481, 0.13441376388073, 0.134375393390656, 0.134336933493614, 0.134298413991928, 0.134259834885597, 0.13422118127346, 0.134182497859001, 0.134143725037575, 0.134104922413826, 0.13406603038311, 0.134027108550072, 0.133988097310066, 0.133949041366577, 0.133909910917282, 0.133870750665665, 0.133831486105919, 0.133792206645012, 0.133752837777138, 0.133713409304619, 0.133673921227455, 0.133634373545647, 0.133594781160355, 0.133555099368095, 0.133515372872353, 0.133475586771965, 0.133435755968094, 0.133395835757256, 0.133355855941772, 0.133315831422806, 0.133275747299194, 0.133235603570938, 0.133195385336876, 0.133155137300491, 0.13311479985714, 0.133074387907982, 0.133033946156502, 0.132993414998055, 0.132952854037285, 0.132912218570709, 0.132871508598328, 0.132830768823624, 0.132789954543114, 0.132749080657959, 0.132708132266998, 0.132667139172554, 0.132626071572304, 0.132584944367409, 0.13254377245903, 0.132502555847168, 0.132461249828339, 0.132419884204865, 0.132378444075584, 0.132336974143982, 0.132295429706573, 0.13225382566452, 0.132212162017822, 0.132170438766479, 0.132128641009331, 0.132086798548698, 0.132044896483421, 0.132002934813499, 0.131960913538933, 0.13191881775856, 0.131876662373543, 0.131834462285042, 0.131792202591896, 0.131749868392944, 0.131707474589348, 0.131665021181107, 0.131622523069382, 0.13157993555069, 0.131537303328514, 0.131494611501694, 0.13145187497139, 0.131409034132957, 0.131366178393364, 0.131323233246803, 0.131280228495598, 0.131237179040909, 0.131194069981575, 0.131150886416435, 0.131107658147812, 0.131064355373383, 0.131020992994308, 0.13097757101059, 0.130934089422226, 0.130890548229218, 0.130846932530403, 0.130803272128105, 0.130759567022324, 0.130715787410736, 0.130671948194504, 0.130628034472466, 0.130584061145782, 0.130540028214455, 0.130495965480804, 0.130451798439026, 0.130407601594925, 0.130363330245018, 0.130318999290466, 0.13027460873127, 0.13023017346859, 0.130185663700104, 0.130141079425812, 0.130096450448036, 0.130051776766777, 0.130007013678551, 0.129962205886841, 0.129917323589325, 0.129872381687164, 0.129827409982681, 0.129782348871231, 0.129737228155136, 0.129692062735558, 0.129646822810173, 0.129601523280144, 0.12955616414547, 0.129510745406151, 0.129465267062187, 0.12941974401474, 0.129374131560326, 0.129328459501266, 0.129282742738724, 0.129236966371536, 0.129191115498543, 0.129145219922066, 0.129099264740944, 0.129053220152855, 0.129007145762444, 0.128961011767387, 0.128914803266525, 0.128868520259857, 0.128822207450867, 0.12877582013607, 0.12872938811779, 0.128682866692543, 0.128636285662651, 0.128589659929276, 0.128542974591255, 0.128496244549751, 0.12844942510128, 0.128402546048164, 0.128355607390404, 0.12830862402916, 0.128261566162109, 0.128214463591576, 0.128167286515236, 0.128120049834251, 0.128072768449783, 0.128025397658348, 0.127977967262268, 0.127930507063866, 0.127882972359657, 0.127835378050804, 0.127787709236145, 0.127739980816841, 0.127692222595215, 0.12764436006546, 0.127596467733383, 0.127548515796661, 0.127500489354134, 0.127452403306961, 0.127404272556305, 0.127356067299843, 0.127307787537575, 0.127259477972984, 0.127211093902588, 0.127162635326385, 0.127114146947861, 0.127065569162369, 0.127016946673393, 0.126968249678612, 0.126919507980347, 0.126870706677437, 0.12682181596756, 0.126772910356522, 0.126723900437355, 0.126674860715866, 0.126625746488571, 0.126576587557793, 0.126527339220047, 0.126478046178818, 0.126428693532944, 0.126379296183586, 0.126329809427261, 0.126280277967453, 0.126230672001839, 0.126181036233902, 0.126131296157837, 0.126081526279449, 0.126031696796417, 0.125981792807579, 0.125931844115257, 0.12588182091713, 0.125831738114357, 0.12578159570694, 0.125731378793716, 0.125681132078171, 0.125630810856819, 0.125580415129662, 0.125529989600182, 0.125479459762573, 0.125428900122643, 0.125378280878067, 0.125327587127686, 0.12527684867382, 0.125226050615311, 0.125175178050995, 0.125124245882034, 0.125073254108429, 0.12502221763134, 0.124971114099026, 0.124919921159744, 0.124868705868721, 0.124817401170731, 0.124766059219837, 0.124714657664299, 0.124663166701794, 0.124611645936966, 0.124560035765171, 0.124508388340473, 0.12445667386055, 0.124404892325401, 0.124353066086769, 0.12430115789175, 0.124249197542667, 0.124197192490101, 0.124145112931728, 0.124092981219292, 0.124040775001049, 0.123988509178162, 0.12393619120121, 0.123883813619614, 0.123831383883953, 0.123778872191906, 0.123726308345795, 0.123673684895039, 0.123621009290218, 0.123568274080753, 0.123515456914902, 0.123462587594986, 0.123409666121006, 0.123356685042381, 0.12330362200737, 0.123250506818295, 0.123197361826897, 0.12314411252737, 0.123090825974941, 0.123037487268448, 0.122984074056149, 0.122930593788624, 0.122877068817616, 0.122823484241962, 0.122769817709923, 0.122716121375561, 0.122662335634232, 0.122608497738838, 0.1225546002388, 0.122500658035278, 0.122446648776531, 0.122392572462559, 0.12233842164278, 0.122284233570099, 0.122229963541031, 0.122175663709641, 0.122121281921864, 0.122066825628281, 0.122012339532375, 0.121957778930664, 0.121903151273727, 0.121848464012146, 0.1217937245965, 0.121738933026791, 0.121684066951275, 0.121629133820534, 0.121574133634567, 0.121519111096859, 0.121463999152184, 0.121408835053444, 0.12135361135006, 0.12129832804203, 0.121242977678776, 0.121187552809715, 0.121132098138332, 0.121076561510563, 0.121020972728729, 0.120965324342251, 0.120909623801708, 0.120853841304779, 0.120798006653786, 0.120742112398148, 0.120686158537865, 0.120630159974098, 0.120574072003365, 0.120517946779728, 0.120461732149124, 0.120405480265617, 0.120349176228046, 0.12029280513525, 0.12023501098156, 0.120175831019878, 0.120116636157036, 0.120057389140129, 0.119998142123222, 0.119938842952251, 0.119879513978958, 0.119820155203342, 0.119760766625404, 0.119701355695724, 0.1196418851614, 0.119582422077656, 0.119522899389267, 0.119463346898556, 0.119403779506683, 0.119344159960747, 0.11928453296423, 0.119224868714809, 0.119165167212486, 0.119105435907841, 0.119045667350292, 0.118985868990421, 0.11892606317997, 0.118866205215454, 0.118806309998035, 0.118746407330036, 0.118686445057392, 0.118626482784748, 0.118566460907459, 0.11850643157959, 0.118446342647076, 0.118386246263981, 0.118326112627983, 0.118265949189663, 0.118205763399601, 0.118145540356636, 0.118085272610188, 0.118024982511997, 0.117964662611485, 0.117904312908649, 0.117843940854073, 0.117783524096012, 0.117723077535629, 0.117662593722343, 0.117602095007896, 0.117541566491127, 0.117481000721455, 0.11742040514946, 0.117359757423401, 0.117299109697342, 0.117238432168961, 0.117177695035934, 0.117116935551167, 0.117056146264076, 0.116995334625244, 0.11693449318409, 0.116873621940613, 0.116812713444233, 0.116751775145531, 0.116690792143345, 0.116629801690578, 0.116568773984909, 0.116507686674595, 0.116446599364281, 0.116385482251644, 0.116324335336685, 0.116263136267662, 0.116201907396317, 0.116140678524971, 0.116079397499561, 0.116018086671829, 0.115956738591194, 0.115895360708237, 0.115833953022957, 0.115772515535355, 0.115711040794849, 0.115649558603764, 0.115588039159775, 0.115526467561722, 0.115464881062508, 0.11540325731039, 0.115341618657112, 0.115279920399189, 0.115218214690685, 0.115156464278698, 0.115094684064388, 0.115032881498337, 0.114971034228802, 0.114909172058105, 0.114847272634506, 0.114785343408585, 0.11472337692976, 0.114661380648613, 0.114599354565144, 0.114537306129932, 0.114475227892399, 0.114413097500801, 0.114350952208042, 0.1142887622118, 0.114226564764977, 0.114164315164089, 0.11410204321146, 0.114039748907089, 0.113977402448654, 0.113915041089058, 0.113852642476559, 0.113790214061737, 0.113727763295174, 0.113665275275707, 0.113602757453918, 0.113540202379227, 0.113477617502213, 0.113415002822876, 0.113352358341217, 0.113289691507816, 0.113226987421513, 0.113164238631725, 0.113101467490196, 0.113038659095764, 0.112975843250751, 0.112912975251675, 0.112850084900856, 0.112787164747715, 0.11272419989109, 0.112661220133305, 0.112598210573196, 0.112535163760185, 0.112472079694271, 0.112408973276615, 0.112345829606056, 0.112282663583755, 0.112219460308552, 0.112156219780445, 0.112092964351177, 0.112029671669006, 0.111966341733932, 0.111902974545956, 0.111839585006237, 0.111776165664196, 0.111712716519833, 0.111649237573147, 0.111585728824139, 0.111522182822227, 0.111458599567413, 0.111395008862019, 0.111331358551979, 0.111267700791359, 0.111203998327255, 0.11114027351141, 0.111076511442661, 0.11101271212101, 0.110948897898197, 0.110885038971901, 0.110821157693863, 0.110757239162922, 0.110693298280239, 0.110629320144653, 0.110565304756165, 0.110501274466515, 0.110437199473381, 0.110373102128506, 0.110308960080147, 0.110244803130627, 0.110180608928204, 0.110116384923458, 0.11005213111639, 0.109987832605839, 0.109923519194126, 0.10985916852951, 0.109794795513153, 0.109730377793312, 0.109665930271149, 0.109601452946663, 0.109536953270435, 0.109472423791885, 0.109407857060432, 0.109343260526657, 0.109278626739979, 0.109213970601559, 0.109149277210236, 0.10908455401659, 0.109019801020622, 0.108955010771751, 0.108890205621719, 0.108825355768204, 0.108760483562946, 0.108695581555367, 0.108630634844303, 0.108565665781498, 0.10850065946579, 0.10843563824892, 0.108370579779148, 0.108305484056473, 0.108240351080894, 0.108175195753574, 0.108110018074512, 0.108044795691967, 0.107979543507099, 0.10791426897049, 0.107848949730396, 0.107783608138561, 0.107718244194984, 0.107652828097343, 0.107587404549122, 0.107521936297417, 0.107456438243389, 0.10739091783762, 0.107325352728367, 0.107259765267372, 0.107194140553474, 0.107128486037254, 0.107062809169292, 0.106997087597847, 0.10693135112524, 0.106865577399731, 0.106799781322479, 0.106733933091164, 0.106668062508106, 0.106602169573307, 0.106536231935024, 0.106470257043839, 0.106404274702072, 0.106338247656822, 0.10627219825983, 0.106206119060516, 0.106139995157719, 0.106073848903179, 0.106007672846317, 0.105941466987133, 0.105875216424465, 0.105808936059475, 0.105742648243904, 0.10567631572485, 0.105609945952892, 0.105543546378613, 0.105477124452591, 0.105410672724247, 0.105344176292419, 0.10527765005827, 0.105211108922958, 0.105144523084164, 0.105077922344208, 0.105011276900768, 0.104944594204426, 0.104877896606922, 0.104811154305935, 0.104744389653206, 0.104677580296993, 0.104610756039619, 0.104543894529343, 0.104477003216743, 0.104410082101822, 0.104343123733997, 0.10427613556385, 0.104209132492542, 0.10414207726717, 0.104074992239475, 0.104007884860039, 0.10394075512886, 0.103873588144779, 0.103806383907795, 0.103739149868488, 0.10367189347744, 0.103604592382908, 0.103537268936634, 0.103469900786877, 0.103402525186539, 0.103335097432137, 0.103267654776573, 0.103200174868107, 0.103132665157318, 0.103065118193626, 0.102997533977032, 0.102929942309856, 0.102862298488617, 0.102794639766216, 0.102726936340332, 0.102659203112125, 0.102591454982758, 0.102523654699326, 0.102455839514732, 0.102387987077236, 0.102320104837418, 0.102252185344696, 0.102184243500233, 0.102116271853447, 0.102048248052597, 0.101980216801167, 0.101912148296833, 0.101844042539597, 0.101775914430618, 0.101707763969898, 0.101639553904533, 0.101571336388588, 0.101503074169159, 0.101434797048569, 0.101366475224495, 0.101298123598099, 0.1012297347188, 0.101161330938339, 0.101092889904976, 0.10102441906929, 0.100955918431282, 0.100887380540371, 0.100818812847137, 0.100750215351582, 0.100681580603123, 0.100612930953503, 0.10054424405098, 0.100475527346134, 0.100406765937805, 0.100337989628315, 0.100269176065922, 0.100200325250626, 0.100131452083588, 0.100062541663647, 0.0999936014413834, 0.0999246388673782, 0.0998556390404701, 0.099786601960659, 0.0997175425291061, 0.0996484532952309, 0.0995793268084526, 0.099510170519352, 0.0994409844279289, 0.0993717759847641, 0.0993025153875351, 0.0992332473397255, 0.0991639271378517, 0.0990945845842361, 0.0990252196788788, 0.0989558175206184, 0.0988863855600357, 0.09881691634655, 0.0987474247813225, 0.098677895963192, 0.0986083447933197, 0.0985387414693832, 0.0984691306948662, 0.0983994752168655, 0.0983298048377037, 0.0982600823044777, 0.0981903448700905, 0.0981205627322197, 0.0980507656931877, 0.0979809239506721, 0.0979110449552536, 0.0978411585092545, 0.0977712199091911, 0.0977012664079666, 0.0976312756538391, 0.0975612476468086, 0.0974911972880363, 0.0974211171269417, 0.097350999712944, 0.0972808450460434, 0.097210668027401, 0.0971404612064362, 0.0970702171325684, 0.0969999581575394, 0.0969296470284462, 0.0968593209981918, 0.0967889502644539, 0.0967185571789742, 0.0966481268405914, 0.0965776741504669, 0.0965071842074394, 0.0964366644620895, 0.0963661223649979, 0.0962955355644226, 0.096224918961525, 0.0961542800068855, 0.0960836112499237, 0.0960128977894783, 0.0959421694278717, 0.0958713963627815, 0.0958006083965302, 0.0957297831773758, 0.0956589132547379, 0.0955880209803581, 0.095517098903656, 0.0954461544752121, 0.095375157892704, 0.0953041464090347, 0.0952331125736237, 0.095162034034729, 0.0950909182429314, 0.0950197726488113, 0.0949486121535301, 0.0948773995041847, 0.0948061794042587, 0.0947349146008492, 0.0946636125445366, 0.0945922881364822, 0.0945209413766861, 0.0944495499134064, 0.0943781286478043, 0.0943066850304604, 0.0942352116107941, 0.0941637009382248, 0.0940921530127525, 0.0940205752849579, 0.0939489677548409, 0.0938773453235626, 0.0938056781888008, 0.093733973801136, 0.09366225451231, 0.0935904905200005, 0.0935187041759491, 0.0934468731284142, 0.0933750197291374, 0.0933031439781189, 0.0932312309741974, 0.0931592956185341, 0.0930873081088066, 0.0930152982473373, 0.0929432660341263, 0.0928712114691734, 0.0927990972995758, 0.092726968228817, 0.0926547944545746, 0.0925826132297516, 0.092510387301445, 0.0924381390213966, 0.0923658385872841, 0.0922935381531715, 0.0922211855649948, 0.0921487957239151, 0.0920763835310936, 0.0920039489865303, 0.091931477189064, 0.0918589755892754, 0.0917864367365837, 0.0917138680815697, 0.0916412845253944, 0.0915686637163162, 0.0914959907531738, 0.0914233028888702, 0.0913505852222443, 0.0912778377532959, 0.0912050604820251, 0.0911322385072708, 0.0910593941807747, 0.0909865200519562, 0.0909136235713959, 0.090840682387352, 0.0907677039504051, 0.0906947106122971, 0.0906216874718666, 0.0905486196279526, 0.0904755294322968, 0.0904024168848991, 0.0903292521834373, 0.0902560651302338, 0.0901828557252884, 0.0901095941662788, 0.0900363251566887, 0.0899630188941956, 0.08988968282938, 0.0898163020610809, 0.08974289894104, 0.0896694734692574, 0.0895959958434105, 0.0895225033164024, 0.0894489735364914, 0.0893754214048386, 0.0893018320202827, 0.0892282202839851, 0.0891545787453651, 0.089080885052681, 0.0890071764588356, 0.0889334380626678, 0.0888596624135971, 0.088785856962204, 0.0887120068073273, 0.0886381566524506, 0.0885642617940903, 0.0884903147816658, 0.0884163603186607, 0.0883423760533333, 0.0882683470845222, 0.0881942957639694, 0.0881202071905136, 0.088046096265316, 0.087971955537796, 0.0878977850079536, 0.0878235623240471, 0.0877493321895599, 0.0876750573515892, 0.0876007601618767, 0.0875264182686806, 0.0874520540237427, 0.087377667427063, 0.0873032435774803, 0.0872287899255753, 0.0871542990207672, 0.0870797783136368, 0.0870052352547646, 0.0869306549429893, 0.0868560373783112, 0.0867814049124718, 0.0867067649960518, 0.0866321325302124, 0.0865574851632118, 0.0864828675985336, 0.086408257484436, 0.0863336622714996, 0.0862590596079826, 0.0861844718456268, 0.0861098989844322, 0.0860353335738182, 0.0859607756137848, 0.0858862325549126, 0.0858116969466209, 0.0857371613383293, 0.0856626555323601, 0.0855881497263908, 0.085513636469841, 0.085439145565033, 0.0853646695613861, 0.0852902010083199, 0.0852157473564148, 0.0851412862539291, 0.0850668475031853, 0.0849924087524414, 0.0849179849028587, 0.0848435685038567, 0.0847691670060158, 0.0846947655081749, 0.0846203863620758, 0.0845460146665573, 0.0844716504216194, 0.0843972787261009, 0.0843229368329048, 0.0842485949397087, 0.0841742530465126, 0.0840999409556389, 0.0840256363153458, 0.0839513391256332, 0.0838770419359207, 0.0838027521967888, 0.0837284922599792, 0.0836542174220085, 0.0835799723863602, 0.0835057199001312, 0.0834314972162247, 0.0833572670817375, 0.083283044397831, 0.0832088440656662, 0.0831346362829208, 0.0830604583024979, 0.0829862803220749, 0.0829121097922325, 0.0828379392623901, 0.0827637985348701, 0.0826896578073502, 0.0826155170798302, 0.0825414061546326, 0.0824672803282738, 0.0823931843042374, 0.082319088280201, 0.0822450071573257, 0.0821709334850311, 0.0820968672633171, 0.0820228084921837, 0.0819487571716309, 0.0818747282028198, 0.0818006917834282, 0.0817266777157784, 0.0816526710987091, 0.0815786644816399, 0.0815046727657318, 0.0814306885004044, 0.0813567265868187, 0.081282764673233, 0.0812088176608086, 0.0811348631978035, 0.0810609385371208, 0.0809870213270187, 0.0809131041169167, 0.0808391869068146, 0.0807652845978737, 0.0806914120912552, 0.0806175395846367, 0.0805436670780182, 0.0804698020219803, 0.0803959593176842, 0.0803221091628075, 0.0802482888102531, 0.0801744610071182, 0.0801006555557251, 0.0800268575549126, 0.0799530670046806, 0.0798792913556099, 0.0798055082559586, 0.0797317400574684, 0.0796579942107201, 0.0795842483639717, 0.079510509967804, 0.0794367790222168, 0.0793630629777908, 0.0792893543839455, 0.0792156606912613, 0.0791419744491577, 0.0790682956576347, 0.0789946243166924, 0.0789209604263306, 0.0788473039865494, 0.07877366989851, 0.0787000358104706, 0.0786264166235924, 0.0785528048872948, 0.0784792006015778, 0.0784056037664413, 0.0783320292830467, 0.0782584473490715, 0.0781848803162575, 0.0781113281846046, 0.0780377835035324, 0.0779642388224602, 0.0778907239437103, 0.0778171867132187, 0.0777436792850494, 0.0776701867580414, 0.0775966942310333, 0.0775232017040253, 0.0774497464299202, 0.0773762837052345, 0.0773028284311295, 0.077229380607605, 0.0771559476852417, 0.0770825296640396, 0.0770091190934181, 0.0769357085227966, 0.0768623054027557, 0.0767889320850372, 0.0767155513167381, 0.0766421779990196, 0.0765688195824623, 0.0764954686164856, 0.0764221325516701, 0.0763488039374352, 0.076275497674942, 0.0762021616101265, 0.0761288553476334, 0.0760555788874626, 0.0759822949767113, 0.0759090110659599, 0.075835756957531, 0.075762502849102, 0.0756892561912537, 0.0756160169839859, 0.0755427852272987, 0.0754695683717728, 0.0753963738679886, 0.0753231719136238, 0.075249969959259, 0.0751767978072166, 0.0751036256551743, 0.0750304758548737, 0.0749573186039925, 0.0748841688036919, 0.0748110413551331, 0.0747379213571548, 0.0746648088097572, 0.0745917037129402, 0.0745186060667038, 0.0744455233216286, 0.0743724554777145, 0.0742993950843811, 0.0742263272404671, 0.0741532817482948, 0.0740802437067032, 0.0740072205662727, 0.0739341825246811, 0.0738611817359924, 0.0737881809473038, 0.0737151950597763, 0.0736422091722488, 0.0735692381858826, 0.0734962895512581, 0.0734233260154724, 0.0733503773808479, 0.0732774436473846, 0.073204517364502, 0.0731316059827805, 0.0730587020516396, 0.0729858055710793, 0.0729129239916801, 0.0728400349617004, 0.0727671831846237, 0.0726943239569664, 0.0726214572787285, 0.072548620402813, 0.0724757984280586, 0.0724029764533043, 0.0723301619291306, 0.072257362306118, 0.0721845626831055, 0.0721117928624153, 0.072039008140564, 0.0719662457704544, 0.0718934908509254, 0.0718207433819771, 0.0717480182647705, 0.0716752856969833, 0.0716025680303574, 0.0715298652648926, 0.0714571550488472, 0.0713844746351242, 0.0713117867708206, 0.0712391212582588, 0.071166455745697, 0.0710938051342964, 0.071021169424057, 0.0709485337138176, 0.0708759129047394, 0.0708032995462418, 0.0707307010889053, 0.0706580951809883, 0.0705855116248131, 0.070512942969799, 0.070440374314785, 0.0703678205609322, 0.0702952668070793, 0.0702227279543877, 0.0701501965522766, 0.0700776875019073, 0.0700051710009575, 0.0699326694011688, 0.0698601827025414, 0.0697877034544945, 0.0697152316570282, 0.0696427598595619, 0.0695703104138374, 0.0694978758692741, 0.0694254338741302, 0.0693530067801476, 0.069280594587326, 0.0692081898450851, 0.0691357851028442, 0.0690634027123451, 0.0689910277724266, 0.0689186602830887, 0.068846307694912, 0.0687739551067352, 0.0687016099691391, 0.0686292797327042, 0.0685569643974304, 0.0684846490621567, 0.0684123411774635, 0.0683400556445122, 0.0682677552103996, 0.0681954845786095, 0.0681232288479805, 0.0680509656667709, 0.0679787248373032, 0.067906491458416, 0.0678342655301094, 0.067762054502964, 0.0676898285746574, 0.0676176398992538, 0.0675454512238503, 0.0674732699990273, 0.0674010962247849, 0.0673289373517036, 0.067256785929203, 0.0671846494078636, 0.0671125128865242, 0.0670403838157654, 0.0669682770967484, 0.0668961778283119, 0.0668240860104561, 0.0667519941926003, 0.066679909825325, 0.0666078478097916, 0.0665358006954193, 0.0664637461304665, 0.0663917139172554, 0.0663196817040443, 0.0662476569414139, 0.066175639629364, 0.0661036521196365, 0.0660316497087479, 0.065959669649601, 0.0658877044916153, 0.0658157393336296, 0.0657437816262245, 0.0656718462705612, 0.0655999034643173, 0.0655279830098152, 0.0654560551047325, 0.0653841570019722, 0.0653122588992119, 0.0652403756976128, 0.0651685073971748, 0.0650966316461563, 0.0650247633457184, 0.0649529248476028, 0.0648810863494873, 0.0648092478513718, 0.064737431704998, 0.0646656155586243, 0.0645938217639923, 0.0645220205187798, 0.0644502341747284, 0.0643784627318382, 0.0643066987395287, 0.0642349496483803, 0.0641631931066513, 0.0640914663672447, 0.0640197247266769, 0.0639480203390121, 0.0638763085007668, 0.0638045966625214, 0.0637329146265984, 0.063661240041256, 0.0635895654559135, 0.0635178908705711, 0.0634462535381317, 0.0633746087551117, 0.0633029714226723, 0.063231348991394, 0.063159741461277, 0.06308813393116, 0.0630165413022041, 0.0629449635744095, 0.0628733783960342, 0.0628018155694008, 0.0627302601933479, 0.0626587122678757, 0.062587171792984, 0.0625156387686729, 0.0624441243708134, 0.0623726174235344, 0.062301117926836, 0.062229610979557, 0.0621581263840199, 0.0620866604149342, 0.0620151907205582, 0.061943743377924, 0.0618722997605801, 0.0618008673191071, 0.0617294386029243, 0.0616580247879028, 0.0615866184234619, 0.061515212059021, 0.0614438280463219, 0.0613724552094936, 0.061301089823246, 0.0612297244369984, 0.0611583702266216, 0.0610870346426964, 0.0610157176852226, 0.0609443709254265, 0.0608730688691139, 0.0608017630875111, 0.0607304722070694, 0.0606591962277889, 0.0605879127979279, 0.0605166591703892, 0.0604453980922699, 0.0603741556406021, 0.0603029131889343, 0.0602316856384277, 0.060160469263792, 0.0600892640650272, 0.0600180551409721, 0.0599468685686588, 0.0598756968975067, 0.0598045215010643, 0.0597333572804928, 0.0596621967852116, 0.0595910660922527, 0.0595199279487133, 0.0594488084316254, 0.059377696365118, 0.0593065731227398, 0.0592354908585548, 0.0591644048690796, 0.0590933337807655, 0.0590222664177418, 0.0589512102305889, 0.0588801614940166, 0.0588091239333153, 0.0587380938231945, 0.058667067438364, 0.0585960522294044, 0.0585250593721867, 0.0584540702402592, 0.0583830773830414, 0.0583121031522751, 0.0582411475479603, 0.0581701956689358, 0.0580992549657822, 0.0580283030867577, 0.0579573847353458, 0.0578864738345146, 0.0578155554831028, 0.0577446706593037, 0.0576737783849239, 0.0576028972864151, 0.0575320310890675, 0.0574611686170101, 0.0573903247714043, 0.0573194772005081, 0.0572486519813538, 0.0571778230369091, 0.0571070052683353, 0.0570362061262131, 0.0569654144346714, 0.0568946339190006, 0.0568238645792007, 0.05675308406353, 0.0566823296248913, 0.0566115900874138, 0.0565408580005169, 0.05647012591362, 0.056399405002594, 0.0563286952674389, 0.0562579967081547, 0.056187316775322, 0.0561166331171989, 0.0560459606349468, 0.0559752956032753, 0.0559046529233456, 0.0558339953422546, 0.0557633638381958, 0.0556927472352982, 0.0556221269071102, 0.0555515214800835, 0.0554809309542179, 0.0554103441536427, 0.0553397573530674, 0.0552691966295242, 0.0551986396312714, 0.0551280863583088, 0.0550575479865074, 0.0549870207905769, 0.0549165047705173, 0.0548459850251675, 0.0547754839062691, 0.0547050051391125, 0.054634515196085, 0.0545640364289284, 0.0544935800135136, 0.0544231235980988, 0.0543526858091354, 0.0542822480201721, 0.0542118176817894, 0.0541414022445679, 0.0540709942579269, 0.0540006011724472, 0.0539302043616772, 0.0538598261773586, 0.0537894666194916, 0.0537191070616245, 0.0536487475037575, 0.0535784140229225, 0.0535080768167973, 0.0534377582371235, 0.0533674359321594, 0.0532971434295177, 0.0532268434762955, 0.0531565546989441, 0.0530862882733345, 0.0530160292983055, 0.0529457554221153, 0.0528755113482475, 0.0528052784502506, 0.0527350567281246, 0.0526648238301277, 0.0525946207344532, 0.052524421364069, 0.052454236894846, 0.0523840561509132, 0.0523138754069805, 0.0522437170147896, 0.0521735735237598, 0.0521034263074398, 0.0520332902669907, 0.0519631691277027, 0.051893062889576, 0.0518229492008686, 0.0517528615891933, 0.0516827628016472, 0.0516126863658428, 0.0515426285564899, 0.0514725595712662, 0.0514025129377842, 0.0513324774801731, 0.0512624494731426, 0.0511924177408218, 0.0511224120855331, 0.051052413880825, 0.0509824119508266, 0.05091243237257, 0.0508424639701843, 0.0507724955677986, 0.0507025420665741, 0.0506339035928249, 0.0505666509270668, 0.0504994131624699, 0.0504322126507759, 0.0503650568425655, 0.0502979457378387, 0.0502308756113052, 0.0501638352870941, 0.0500968396663666, 0.050029881298542, 0.0499629750847816, 0.049896102398634, 0.0498292595148087, 0.0497624613344669, 0.0496957004070282, 0.0496289879083633, 0.0495623014867306, 0.0494956523180008, 0.0494290553033352, 0.0493625029921532, 0.0492959767580032, 0.0492294915020466, 0.0491630472242832, 0.0490966364741325, 0.049030277878046, 0.0489639416337013, 0.0488976500928402, 0.0488314069807529, 0.0487652085721493, 0.048699039965868, 0.0486328974366188, 0.0485668145120144, 0.0485007800161839, 0.0484347566962242, 0.048368789255619, 0.048302847892046, 0.0482369586825371, 0.0481711141765118, 0.0481053031980991, 0.0480395220220089, 0.0479737743735313, 0.0479081012308598, 0.0478424392640591, 0.0477768108248711, 0.0477112419903278, 0.0476457066833973, 0.04758021235466, 0.0475147552788258, 0.047449316829443, 0.0473839342594147, 0.0473186112940311, 0.0472533069550991, 0.0471880324184895, 0.0471228174865246, 0.0470576398074627, 0.0469924919307232, 0.0469273775815964, 0.0468623042106628, 0.0467972904443741, 0.046732310205698, 0.0466673597693443, 0.046602439135313, 0.0465375781059265, 0.046472754329443, 0.046407975256443, 0.0463432148098946, 0.0462784953415394, 0.0462138317525387, 0.0461492016911507, 0.0460846051573753, 0.0460200496017933, 0.0459555462002754, 0.0458910651504993, 0.0458266288042068, 0.045762225985527, 0.045697882771492, 0.0456335619091988, 0.0455692708492279, 0.045505054295063, 0.0454408414661884, 0.0453766845166683, 0.0453125759959221, 0.0452484823763371, 0.0451844409108162, 0.0451204441487789, 0.0450564846396446, 0.044992558658123, 0.0449286662042141, 0.0448648259043694, 0.044801015406847, 0.0447372607886791, 0.0446735322475433, 0.0446098409593105, 0.0445462092757225, 0.044482596218586, 0.0444190129637718, 0.044355496764183, 0.0442919880151749, 0.0442285612225533, 0.0441651456058025, 0.0441017597913742, 0.0440384484827518, 0.0439751483500004, 0.0439118929207325, 0.0438486821949482, 0.0437854938209057, 0.0437223762273788, 0.0436592772603035, 0.0435962080955505, 0.0435332059860229, 0.0434702187776566, 0.0434072911739349, 0.0433443896472454, 0.0432815216481686, 0.0432187020778656, 0.0431559383869171, 0.0430931933224201, 0.0430304855108261, 0.0429678149521351, 0.0429051928222179, 0.0428426191210747, 0.0427800789475441, 0.0427175648510456, 0.0426550880074501, 0.04259267821908, 0.0425302870571613, 0.0424679294228554, 0.0424056276679039, 0.0423433631658554, 0.0422811470925808, 0.0422189496457577, 0.0421567820012569, 0.0420946925878525, 0.0420326106250286, 0.0419705882668495, 0.0419085994362831, 0.0418466217815876, 0.0417847223579884, 0.0417228415608406, 0.0416610166430473, 0.0415992327034473, 0.0415374599397182, 0.0414757505059242, 0.0414140708744526, 0.0413524247705936, 0.041290819644928, 0.0412292778491974, 0.0411677546799183, 0.041106253862381, 0.041044820100069, 0.0409834198653698, 0.0409220531582832, 0.0408607497811317, 0.0407994464039803, 0.0407382063567638, 0.0406770184636116, 0.0406158417463303, 0.0405547209084034, 0.0404936261475086, 0.0404325798153877, 0.0403715707361698, 0.0403105989098549, 0.0402496606111526, 0.0401887781918049, 0.0401279330253601, 0.0400671437382698, 0.0400063470005989, 0.0399456024169922, 0.0398849286139011, 0.0398242771625519, 0.0397636629641056, 0.0397030934691429, 0.0396425500512123, 0.0395820587873459, 0.0395215898752213, 0.0394611805677414, 0.0394007936120033, 0.0393404737114906, 0.0392801724374294, 0.03921989351511, 0.039159681648016, 0.0390994995832443, 0.039039358496666, 0.0389792770147324, 0.0389191918075085, 0.0388591773808002, 0.038799200206995, 0.0387392491102219, 0.0386793576180935, 0.0386194698512554, 0.0385596454143524, 0.0384998731315136, 0.0384401232004166, 0.0383804216980934, 0.0383207388222218, 0.0382611192762852, 0.0382015369832516, 0.0381419658660889, 0.0380824655294418, 0.0380230024456978, 0.0379635542631149, 0.0379041656851768, 0.0378448106348515, 0.0377855040132999, 0.0377262234687805, 0.0376669839024544, 0.0376077964901924, 0.0375486277043819, 0.0374895185232162, 0.0374304503202438, 0.0373713970184326, 0.0373124144971371, 0.037253450602293, 0.0371945239603519, 0.0371356494724751, 0.0370767898857594, 0.0370180085301399, 0.0369592420756817, 0.0369005128741264, 0.0368418358266354, 0.0367831848561764, 0.0367245823144913, 0.0366660207509995, 0.0366074852645397, 0.0365490093827248, 0.0364905670285225, 0.0364321507513523, 0.0363737903535366, 0.0363154485821724, 0.0362571626901627, 0.0361989215016365, 0.0361406952142715, 0.0360825285315514, 0.0360243991017342, 0.0359662994742393, 0.0359082520008087, 0.0358502417802811, 0.0357922650873661, 0.0357343070209026, 0.0356764309108257, 0.0356185734272003, 0.0355607457458973, 0.035502977669239, 0.0354452468454838, 0.0353875383734703, 0.0353298857808113, 0.0352722518146038, 0.0352146811783314, 0.0351571440696716, 0.0350996367633343, 0.0350421853363514, 0.0349847450852394, 0.0349273569881916, 0.0348700359463692, 0.0348127074539661, 0.0347554683685303, 0.0346982441842556, 0.0346410311758518, 0.0345839038491249, 0.0345267876982689, 0.0344697088003159, 0.0344126932322979, 0.0343556925654411, 0.0342987440526485, 0.0342418365180492, 0.0341849662363529, 0.0341281406581402, 0.0340713411569595, 0.0340145975351334, 0.0339578725397587, 0.0339011922478676, 0.0338445566594601, 0.0337879545986652, 0.0337314084172249, 0.0336748957633972, 0.0336184203624725, 0.0335619747638702, 0.0335055701434612, 0.0334492288529873, 0.0333928987383842, 0.0333366058766842, 0.0332803726196289, 0.0332241654396057, 0.0331680215895176, 0.0331118889153004, 0.0330557972192764, 0.0329997539520264, 0.0329437553882599, 0.0328877866268158, 0.0328318737447262, 0.0327759645879269, 0.0327201224863529, 0.0326643213629723, 0.0326085537672043, 0.032552819699049, 0.0324971415102482, 0.0324414856731892, 0.0323858708143234, 0.0323303081095219, 0.0322747714817524, 0.0322192721068859, 0.0321638323366642, 0.0321084037423134, 0.0320530384778976, 0.0319976918399334, 0.031942393630743, 0.0318871438503265, 0.0318319238722324, 0.0317767523229122, 0.0317216366529465, 0.0316665060818195, 0.0316114500164986, 0.0315564349293709, 0.0315014608204365, 0.0314465314149857, 0.0313916057348251, 0.0313367284834385, 0.0312819220125675, 0.0312271360307932, 0.0311724003404379, 0.0311176981776953, 0.0310630146414042, 0.031008392572403, 0.030953811481595, 0.0308992508798838, 0.030844759196043, 0.0307902917265892, 0.0307358652353287, 0.0306814573705196, 0.0306271128356457, 0.0305727943778038, 0.0305185355246067, 0.0304643083363771, 0.0304101128131151, 0.0303559582680464, 0.0303018335253, 0.0302477646619081, 0.0301937405019999, 0.0301397237926722, 0.030085776001215, 0.0300318673253059, 0.0299779884517193, 0.0299241319298744, 0.0298703387379646, 0.0298165883868933, 0.0297628808766603, 0.029709180817008, 0.0296555273234844, 0.029601939022541, 0.0295483656227589, 0.0294948630034924, 0.029441375285387, 0.0293879210948944, 0.0293345171958208, 0.0292811580002308, 0.0292278435081244, 0.0291745271533728, 0.029121296480298, 0.0290680937469006, 0.0290149040520191, 0.0289617870002985, 0.0289087016135454, 0.0288556534796953, 0.0288026388734579, 0.0287496540695429, 0.0286967419087887, 0.0286438558250666, 0.0285909846425056, 0.0285381749272346, 0.0284853894263506, 0.0284326672554016, 0.0283799730241299, 0.0283273085951805, 0.0282746888697147, 0.0282221101224422, 0.0281695816665888, 0.0281170960515738, 0.0280646197497845, 0.0280121862888336, 0.0279598347842693, 0.0279074739664793, 0.027855172753334, 0.0278029032051563, 0.0277506876736879, 0.027698490768671, 0.0276463571935892, 0.0275942664593458, 0.0275421738624573, 0.0274901650846004, 0.0274381749331951, 0.0273862183094025, 0.0273343231528997, 0.0272824484854937, 0.0272306147962809, 0.027178842574358, 0.0271270722150803, 0.0270753744989634, 0.0270237065851688, 0.026972059160471, 0.0269204750657082, 0.026868911460042, 0.02681740000844, 0.0267659388482571, 0.026714488863945, 0.0266631133854389, 0.0266117341816425, 0.0265604201704264, 0.0265091452747583, 0.026457903906703, 0.0264067016541958, 0.0263555534183979, 0.0263044349849224, 0.0262533482164145, 0.0262023005634546, 0.0261512976139784, 0.0261003449559212, 0.0260494239628315, 0.0259985215961933, 0.0259476937353611, 0.0258968863636255, 0.0258461125195026, 0.0257953982800245, 0.0257447138428688, 0.0256940610706806, 0.0256434511393309, 0.0255928728729486, 0.0255423318594694, 0.0254918690770864, 0.0254414118826389, 0.0253909900784492, 0.0253406278789043, 0.0252902861684561, 0.025239996612072, 0.0251897498965263, 0.0251395236700773, 0.025089368224144, 0.0250392351299524, 0.0249891318380833, 0.0249390695244074, 0.024889038875699, 0.0248390715569258, 0.02478913590312, 0.0247392393648624, 0.0246893763542175, 0.0246395524591208, 0.0245897714048624, 0.0245400406420231, 0.0244903322309256, 0.0244406647980213, 0.0243910476565361, 0.0243414640426636, 0.0242919102311134, 0.0242424197494984, 0.0241929590702057, 0.0241435188800097, 0.0240941308438778, 0.0240447763353586, 0.0239954702556133, 0.0239462070167065, 0.0238969847559929, 0.023847782984376, 0.0237986445426941, 0.0237495359033346, 0.0237004701048136, 0.0236514247953892, 0.0236024204641581, 0.0235534869134426, 0.0235045664012432, 0.0234556775540113, 0.0234068594872952, 0.0233580525964499, 0.0233092959970236, 0.0232605822384357, 0.0232118982821703, 0.0231632571667433, 0.0231146570295095, 0.02306610904634, 0.0230175890028477, 0.0229690950363874, 0.0229206494987011, 0.0228722784668207, 0.0228239055722952, 0.0227755643427372, 0.02272729575634, 0.0226790476590395, 0.0226308330893517, 0.0225826650857925, 0.0225345529615879, 0.0224864389747381, 0.0224384106695652, 0.0223904103040695, 0.0223424416035414, 0.0222945045679808, 0.0222466103732586, 0.0221987664699554, 0.0221509542316198, 0.0221031922847033, 0.0220554545521736, 0.022007754072547, 0.0219601076096296, 0.0219140090048313, 0.0218695122748613, 0.0218250788748264, 0.0217806752771139, 0.0217363443225622, 0.0216920338571072, 0.0216477755457163, 0.0216035693883896, 0.0215593948960304, 0.0215152911841869, 0.0214712303131819, 0.0214271992444992, 0.021383211016655, 0.0213393047451973, 0.0212954189628363, 0.0212515760213137, 0.0212077833712101, 0.0211640428751707, 0.0211203452199697, 0.0210767071694136, 0.0210330914705992, 0.0209895391017199, 0.0209460277110338, 0.0209025554358959, 0.0208591260015965, 0.0208157487213612, 0.02077242359519, 0.020729148760438, 0.0206859279423952, 0.0206427257508039, 0.0205995962023735, 0.0205565001815557, 0.0205134525895119, 0.0204704608768225, 0.0204275064170361, 0.0203845854848623, 0.0203417371958494, 0.0202989280223846, 0.0202561523765326, 0.0202134288847446, 0.0201707649976015, 0.0201281346380711, 0.0200855452567339, 0.0200430061668158, 0.0200005285441875, 0.019958084449172, 0.0199156813323498, 0.0198733396828175, 0.0198310408741236, 0.0197887737303972, 0.0197465866804123, 0.019704420119524, 0.0196622963994741, 0.0196202266961336, 0.0195782165974379, 0.0195362269878387, 0.0194942895323038, 0.0194524135440588, 0.0194105710834265, 0.0193687900900841, 0.0193270388990641, 0.0192853305488825, 0.0192436818033457, 0.0192020777612925, 0.0191605146974325, 0.0191190112382174, 0.0190775413066149, 0.0190361216664314, 0.0189947560429573, 0.0189534183591604, 0.0189121346920729, 0.0188709329813719, 0.0188297312706709, 0.018788592889905, 0.0187474843114614, 0.0187064483761787, 0.0186654552817345, 0.0186244919896126, 0.0185835901647806, 0.0185427218675613, 0.0185019131749868, 0.0184611566364765, 0.0184204112738371, 0.0183797515928745, 0.0183391384780407, 0.0182985290884972, 0.018257999792695, 0.0182175152003765, 0.0181770790368319, 0.0181366764008999, 0.0180963259190321, 0.0180560257285833, 0.018015755340457, 0.0179755706340075, 0.0179353859275579, 0.0178952608257532, 0.0178552102297544, 0.017815200611949, 0.0177752003073692, 0.0177352838218212, 0.0176953878253698, 0.0176555551588535, 0.0176157634705305, 0.0175760127604008, 0.0175363142043352, 0.0174966566264629, 0.0174570530653, 0.0174174979329109, 0.0173779856413603, 0.0173385236412287, 0.0172991268336773, 0.0172597281634808, 0.0172204133123159, 0.0171811189502478, 0.0171418972313404, 0.0171027146279812, 0.0170635562390089, 0.0170244686305523, 0.016985422000289, 0.0169464275240898, 0.0169074758887291, 0.0168685540556908, 0.0168297048658133, 0.0167908873409033, 0.0167521089315414, 0.0167133864015341, 0.0166747029870749, 0.0166360810399055, 0.0165975224226713, 0.0165589526295662, 0.0165204759687185, 0.0164820309728384, 0.0164436288177967, 0.0164052974432707, 0.0163669884204865, 0.0163287278264761, 0.0162905026227236, 0.0162523575127125, 0.0162142552435398, 0.016176151111722, 0.0161381419748068, 0.0161001831293106, 0.0160622149705887, 0.0160243604332209, 0.015986505895853, 0.0159487258642912, 0.0159109849482775, 0.0158732645213604, 0.0158356186002493, 0.0157980136573315, 0.0157604496926069, 0.0157229565083981, 0.0156854763627052, 0.0156480688601732, 0.0156107014045119, 0.0155733535066247, 0.0155360801145434, 0.0154988262802362, 0.0154616571962833, 0.0154245281592011, 0.0153874084353447, 0.0153503715991974, 0.015313358977437, 0.0152764050289989, 0.0152395153418183, 0.0152026349678636, 0.0151658169925213, 0.0151290614157915, 0.0150923253968358, 0.0150556629523635, 0.0150190321728587, 0.0149824423715472, 0.0149459159001708, 0.0149094182997942, 0.0148729830980301, 0.0148365786299109, 0.0148002170026302, 0.0147639280185103, 0.0147276585921645, 0.0146914627403021, 0.0146553069353104, 0.0146191725507379, 0.0145831117406487, 0.0145470714196563, 0.0145110934972763, 0.0144751975312829, 0.0144392810761929, 0.0144034465774894, 0.0143676539883018, 0.0143319042399526, 0.0142962159588933, 0.0142605472356081, 0.014224941842258, 0.014189388602972, 0.0141538754105568, 0.0141184162348509, 0.0140829654410481, 0.0140476087108254, 0.0140123032033443, 0.0139769874513149, 0.0139417862519622, 0.0139065738767385, 0.01387142483145, 0.0138363586738706, 0.0138012925162911, 0.0137662971392274, 0.0137313343584538, 0.0136964228004217, 0.0136615633964539, 0.0136267449706793, 0.0135919796302915, 0.0135572645813227, 0.0135225923731923, 0.0134879499673843, 0.0134533504024148, 0.0134188318625093, 0.0133843459188938, 0.0133498897776008, 0.0133155081421137, 0.0132811348885298, 0.0132468454539776, 0.013212607242167, 0.0131783597171307, 0.0131442351266742, 0.0131100816652179, 0.0130760092288256, 0.0130419991910458, 0.013007989153266, 0.0129740834236145, 0.012940208427608, 0.0129063436761498, 0.0128725720569491, 0.0128388106822968, 0.0128051014617085, 0.0127714760601521, 0.0127378599718213, 0.0127042960375547, 0.0126707926392555, 0.0126373022794724, 0.0126038929447532, 0.0125705050304532, 0.0125371888279915, 0.0125039154663682, 0.012470661662519, 0.0124374916777015, 0.0124043310061097, 0.0123712541535497, 0.0123382080346346, 0.012305193580687, 0.0122722517699003, 0.0122393285855651, 0.0122064696624875, 0.0121736619621515, 0.0121408747509122, 0.0121081713587046, 0.012075487524271, 0.0120428455993533, 0.0120102865621448, 0.0119777070358396, 0.0119452513754368, 0.0119128171354532, 0.0118803819641471, 0.0118480511009693, 0.0118157621473074, 0.0117834722623229, 0.0117512755095959, 0.0117191001772881, 0.0116869769990444, 0.0116549348458648, 0.0116228852421045, 0.0115909157320857, 0.0115589685738087, 0.0115270828828216, 0.0114952595904469, 0.0114634465426207, 0.0114316958934069, 0.0113999769091606, 0.0113683706149459, 0.0113367438316345, 0.0113051598891616, 0.0112736783921719, 0.0112421968951821, 0.0112107768654823, 0.0111794313415885, 0.0111480634659529, 0.0111167998984456, 0.0110855782404542, 0.0110543444752693, 0.0110232373699546, 0.0109921284019947, 0.0109610818326473, 0.0109300781041384, 0.0108990930020809, 0.0108682131394744, 0.0108373537659645, 0.0108065251260996, 0.0107757691293955, 0.0107450243085623, 0.0107143614441156, 0.0106837395578623, 0.0106531288474798, 0.0106226010248065, 0.0105920936912298, 0.0105616701766849, 0.0105312764644623, 0.0105009144172072, 0.0104706045240164, 0.0104403551667929, 0.0104101588949561, 0.0103799737989902, 0.0103498389944434, 0.0103197880089283, 0.0102897575125098, 0.010259778238833, 0.0102298520505428, 0.0101999351754785, 0.0101701114326715, 0.0101403295993805, 0.0101105691865087, 0.0100808693096042, 0.0100512336939573, 0.0100216064602137, 0.00999206304550171, 0.00996251963078976, 0.00993306934833527, 0.00990364979952574, 0.00987426191568375, 0.00984493643045425, 0.00981565099209547, 0.00978640839457512, 0.00975722819566727, 0.00972807873040438, 0.00969898048788309, 0.00966994371265173, 0.00964091904461384, 0.00961197633296251, 0.00958307553082705, 0.00955420546233654, 0.00952538847923279, 0.00949663203209639, 0.00946789607405663, 0.00943920202553272, 0.00941058155149221, 0.00938200019299984, 0.00935346260666847, 0.00932498648762703, 0.00929653085768223, 0.00926811713725328, 0.00923977605998516, 0.00921147596091032, 0.00918321684002876, 0.00915499962866306, 0.00912683457136154, 0.0090987104922533, 0.0090706292539835, 0.00904260762035847, 0.00901462975889444, 0.00898669194430113, 0.00895879603922367, 0.00893096253275871, 0.00890315975993872, 0.00887541938573122, 0.00884769950062037, 0.00882006343454123, 0.00879245717078447, 0.00876487232744694, 0.00873738061636686, 0.00870990939438343, 0.00868246890604496, 0.00865511316806078, 0.00862777605652809, 0.00860049109905958, 0.00857325829565525, 0.0085460776463151, 0.00851890817284584, 0.00849183090031147, 0.00846478436142206, 0.00843776855617762, 0.00841081701219082, 0.00838391575962305, 0.00835703499615192, 0.00833022687584162, 0.00830346066504717, 0.00827672518789768, 0.00825006235390902, 0.00822340045124292, 0.00819682981818914, 0.00817030295729637, 0.00814378447830677, 0.00811733957380056, 0.00809093564748764, 0.00806459411978722, 0.00803829357028008, 0.00801201537251472, 0.00798581819981337, 0.00795965269207954, 0.00793351884931326, 0.00790745671838522, 0.00788142625242472, 0.00785542745143175, 0.00782951060682535, 0.00780362449586391, 0.00777778029441833, 0.00775198824703693, 0.00772623717784882, 0.00770052755251527, 0.00767488079145551, 0.00764928571879864, 0.00762371066957712, 0.00759817752987146, 0.00757272727787495, 0.00754729751497507, 0.00752193015068769, 0.0074966037645936, 0.0074712997302413, 0.0074460762552917, 0.0074208858422935, 0.00739574572071433, 0.0073706591501832, 0.00734558096155524, 0.00732058705762029, 0.00729562295600772, 0.0072707012295723, 0.00724585168063641, 0.00722101330757141, 0.00719624618068337, 0.00717153260484338, 0.00714683858677745, 0.00712221721187234, 0.00709762703627348, 0.0070730778388679, 0.00704860175028443, 0.00702415639534593, 0.00699974223971367, 0.00697540119290352, 0.00695110112428665, 0.00692683178931475, 0.00690262485295534, 0.00687845982611179, 0.00685432506725192, 0.00683025317266583, 0.00680623296648264, 0.00678224395960569, 0.00675831642001867, 0.00673441030085087, 0.00671056564897299, 0.00668678432703018, 0.00666302302852273, 0.00663932412862778, 0.00661567645147443, 0.00659206043928862, 0.0065685068257153, 0.00654498348012567, 0.00652151275426149, 0.00649810349568725, 0.00647470494732261, 0.0064513785764575, 0.00642809458076954, 0.00640485156327486, 0.00638168072327971, 0.00635852059349418, 0.00633542286232114, 0.00631239730864763, 0.00628937175497413, 0.00626640766859055, 0.00624349666759372, 0.00622063688933849, 0.00619782926514745, 0.00617504166439176, 0.00615232717245817, 0.00612963316962123, 0.00610700156539679, 0.00608442164957523, 0.00606187293305993, 0.00603938661515713, 0.00601693103089929, 0.00599452713504434, 0.00597219588235021, 0.00594986462965608, 0.00592762650921941, 0.0059054302982986, 0.00588322337716818, 0.00586110958829522, 0.00583904795348644, 0.00581700680777431, 0.00579502806067467, 0.00577309029176831, 0.00575118418782949, 0.00572938099503517, 0.00570755777880549, 0.00568580720573664, 0.00566410785540938, 0.00564243970438838, 0.0056208441965282, 0.00559927988797426, 0.0055777570232749, 0.00555628584697843, 0.00553487706929445, 0.00551349949091673, 0.00549216289073229, 0.00547193316742778, 0.00545276282355189, 0.00543363904580474, 0.00541456649079919, 0.00539548881351948, 0.00537645863369107, 0.00535746430978179, 0.00533850584179163, 0.00531958369538188, 0.00530068296939135, 0.00528183300048113, 0.00526301981881261, 0.00524420151486993, 0.0052254400216043, 0.00520672556012869, 0.00518801063299179, 0.00516935857012868, 0.00515072699636221, 0.00513210520148277, 0.00511356675997376, 0.00509503856301308, 0.005076521076262, 0.00505806505680084, 0.0050396197475493, 0.00502123683691025, 0.00500285904854536, 0.0049845171160996, 0.00496622733771801, 0.00494795851409435, 0.00492972554638982, 0.00491150794550776, 0.00489334249868989, 0.0048752031289041, 0.00485709449276328, 0.00483901705592871, 0.00482100201770663, 0.00480299210175872, 0.00478500267490745, 0.00476708076894283, 0.00474916910752654, 0.00473128305748105, 0.00471344403922558, 0.00469565717503428, 0.00467785447835922, 0.00466011837124825, 0.00464241998270154, 0.00462473556399345, 0.00460710888728499, 0.00458949338644743, 0.00457189232110977, 0.00455437460914254, 0.00453686201944947, 0.00451936991885304, 0.0045019299723208, 0.00448451610282063, 0.00446712737902999, 0.00444978615269065, 0.00443247007206082, 0.00441518519073725, 0.00439794221892953, 0.00438072485849261, 0.00436353357508779, 0.00434639398008585, 0.00432926975190639, 0.0043121874332428, 0.00429512560367584, 0.00427810987457633, 0.00426113093271852, 0.00424417294561863, 0.00422726618126035, 0.00421038083732128, 0.00419351598247886, 0.00417669210582972, 0.00415991526097059, 0.00414315424859524, 0.00412642396986485, 0.00410975562408566, 0.00409307703375816, 0.00407646596431732, 0.00405987538397312, 0.00404331646859646, 0.00402680365368724, 0.00401030667126179, 0.00399384554475546, 0.00397742120549083, 0.00396103272214532, 0.00394466519355774, 0.00392833445221186, 0.00391203397884965, 0.00389577983878553, 0.00387955270707607, 0.00386334024369717, 0.00384718040004373, 0.00383106619119644, 0.00381496269255877, 0.00379889574833214, 0.00378286000341177, 0.00376686011441052, 0.00375090166926384, 0.00373495905660093, 0.00371906324289739, 0.00370321376249194, 0.00368735892698169, 0.00367156136780977, 0.00365581037476659, 0.0036400593817234, 0.00362437055446208, 0.00360870757140219, 0.00359305506572127, 0.00357745937071741, 0.00356188975274563, 0.00354633573442698, 0.00353084364905953, 0.00351538276299834, 0.00349993212148547, 0.00348452338948846, 0.00346916588023305, 0.00345381395891309, 0.00343850837089121, 0.00342322885990143, 0.00340799079276621, 0.00339278392493725, 0.00337761314585805, 0.00336246308870614, 0.00334735447540879, 0.00333227193914354, 0.00331723596900702, 0.00330222072079778, 0.00328725227154791, 0.00327230407856405, 0.00325738731771708, 0.00324250687845051, 0.00322766765020788, 0.00321283889934421, 0.00319806183688343, 0.0031833213288337, 0.00316858594305813, 0.0031539227347821, 0.00313927023671567, 0.00312465406022966, 0.00311008421704173, 0.00309553509578109, 0.00308101740665734, 0.00306653068400919, 0.00305208005011082, 0.00303766061551869, 0.00302327238023281, 0.00300891534425318, 0.00299459928646684, 0.00298030953854322, 0.00296604004688561, 0.0029518436640501, 0.00293765193782747, 0.00292349164374173, 0.00290937279351056, 0.00289526954293251, 0.00288121262565255, 0.00286719738505781, 0.00285319751128554, 0.00283924443647265, 0.0028253379277885, 0.00281141605228186, 0.00279756146483123, 0.0027837585657835, 0.00276995054446161, 0.00275618908926845, 0.00274248444475234, 0.00272876466624439, 0.00271511194296181, 0.00270149041898549, 0.00268787937238812, 0.00267431978136301, 0.00266080209985375, 0.00264729466289282, 0.00263382843695581, 0.00262041413225234, 0.00260700518265367, 0.00259363767690957, 0.00258030090481043, 0.00256700557656586, 0.00255374191328883, 0.0025404985062778, 0.00252729142084718, 0.00251413113437593, 0.00250099669210613, 0.00248788786120713, 0.00247482606209815, 0.00246179010719061, 0.00244879047386348, 0.002435811329633, 0.00242288410663605, 0.00240997783839703, 0.002397091826424, 0.00238425796851516, 0.00237146019935608, 0.0023586677853018, 0.00234593730419874, 0.00233323290012777, 0.0023205594625324, 0.00230793282389641, 0.00229531642980874, 0.00228272587992251, 0.00227020285092294, 0.0022576954215765, 0.0022452031262219, 0.00223276810720563, 0.00222035916522145, 0.00220796070061624, 0.00219563418067992, 0.00218331324867904, 0.00217103376053274, 0.00215880572795868, 0.00214657303877175, 0.00213439692743123, 0.00212225737050176, 0.0021101227030158, 0.00209804018959403, 0.00208601448684931, 0.00207397853955626, 0.00206198915839195, 0.00205003563314676, 0.0020381344947964, 0.00202625361271203, 0.00201438879594207, 0.00200258078984916, 0.00199079350568354, 0.00197903718799353, 0.00196732766926289, 0.00195562816224992, 0.00194397033192217, 0.00193235406186432, 0.00192076351959258, 0.0019092041766271, 0.00189768616110086, 0.00188621482811868, 0.0018747434951365, 0.00186332932207733, 0.00185193575453013, 0.00184057338628918, 0.00182925211265683, 0.00181795179378241, 0.00180668768007308, 0.00179547036532313, 0.00178426341153681, 0.00177311338484287, 0.00176198908593506, 0.00175089610274881, 0.00173983408603817, 0.00172881362959743, 0.00171780330128968, 0.00170683476608247, 0.00169591780286282, 0.00168500596191734, 0.00167416164185852, 0.00166331208311021, 0.0016525040846318, 0.00164176325779408, 0.00163101742509753, 0.0016203336417675, 0.00160967058036476, 0.00159901275765151, 0.00158842746168375, 0.00157786812633276, 0.00156731402967125, 0.00155682186596096, 0.00154635577928275, 0.00153589982073754, 0.00152550626080483, 0.00151514902245253, 0.00150479678995907, 0.00149450171738863, 0.00148421165067703, 0.00147397874388844, 0.00146377691999078, 0.00145360082387924, 0.00144345604348928, 0.0014333629515022, 0.00142327498178929, 0.00141322333365679, 0.00140323385130614, 0.00139324960764498, 0.00138331204652786, 0.00137342093512416, 0.00136351957917213, 0.00135368038900197, 0.00134388776496053, 0.00133408489637077, 0.00132434407714754, 0.00131462409626693, 0.00130495068151504, 0.00129530322737992, 0.00128568685613573, 0.00127610669005662, 0.00126656785141677, 0.00125705520622432, 0.001247568288818, 0.00123811780940741, 0.00122869818005711, 0.00121931487228721, 0.00120995752513409, 0.00120065198279917, 0.00119136204011738, 0.00118209794163704, 0.00117288576439023, 0.00116371491458267, 0.00115454394835979, 0.00114544061943889, 0.00113635789602995, 0.00112728029489517, 0.00111826485954225, 0.00110928574576974, 0.00110031710937619, 0.0010914052836597, 0.00108251941855997, 0.00107363879214972, 0.00106483057606965, 0.00105605367571115, 0.00104728678707033, 0.00103857205249369, 0.00102985196281224, 0.00102119927760214, 0.0010125880362466, 0.00100398191716522, 0.000995422480627894, 0.000986904604360461, 0.000978391733951867, 0.000969941145740449, 0.000961531943175942, 0.000953117560129613, 0.000944749801419675, 0.000936418422497809, 0.00092812319053337, 0.000919859099667519, 0.000911615672521293, 0.000903419044334441, 0.00089527404634282, 0.000887118803802878, 0.000879020430147648, 0.000870973919518292, 0.000862932647578418, 0.000854932819493115, 0.000846979557536542, 0.00083902123151347, 0.000831130135338753, 0.000823259761091322, 0.000815410283394158, 0.000807607255410403, 0.000799840549007058, 0.00079209974501282, 0.000784400384873152, 0.000776732165832072, 0.000769084610510617, 0.000761488860007375, 0.00075391394784674, 0.000746370002161711, 0.000738862378057092, 0.00073138577863574, 0.000723945500794798, 0.000716541544534266, 0.000709158251993358, 0.000701805984135717, 0.000694490037858486, 0.00068722601281479, 0.000679987773764879, 0.000672765134368092, 0.000665594241581857, 0.00065845443168655, 0.000651325099170208, 0.000644252635538578, 0.000637211313005537, 0.000630185531917959, 0.000623216736130416, 0.000616273900959641, 0.000609336188063025, 0.000602471001911908, 0.000595631776377559, 0.00058879773132503, 0.000582036154810339, 0.000575274578295648, 0.000568549323361367, 0.000561870750971138, 0.000555223145056516, 0.000548585958313197, 0.000542010995559394, 0.000535451457835734, 0.000528928299900144, 0.000522462069056928, 0.000515990715939552, 0.000509565987158567, 0.00050317746354267, 0.000496825261507183, 0.000490498961880803, 0.00048420371604152, 0.000477944762678817, 0.000471732433652505, 0.000465530436486006, 0.000459375121863559, 0.000453256070613861, 0.000447157741291448, 0.000441106036305428, 0.000435090594692156, 0.000429085543146357, 0.000423127086833119, 0.000417204922996461, 0.000411298271501437, 0.000405443453928456, 0.00039960935828276, 0.000393806345527992, 0.000388044834835455, 0.000382329890271649, 0.000376620126189664, 0.000370962225133553, 0.000365330197382718, 0.000359729252522811, 0.000354164629243314, 0.000348620669683442, 0.000343133724527434, 0.00033766747219488, 0.000332216819515452, 0.000326817942550406, 0.000321439816616476, 0.000316103105433285, 0.000310828589135781, 0.000305543711874634, 0.00030031061032787, 0.000295119010843337, 0.000289932591840625, 0.000284792797174305, 0.000279704778222367, 0.000274611607892439, 0.000269565091002733, 0.000264580710791051, 0.000259591150097549, 0.000254658603807911, 0.000249767501372844, 0.000244871218455955, 0.000240042281802744, 0.000235239262110554, 0.000230451798415743, 0.000225700598093681, 0.000221006368519738, 0.000216317333979532, 0.000211669757845812, 0.000207053250051104, 0.00020247302018106, 0.000197949790162966, 0.000193426545592956, 0.000188949954463169, 0.000184509612154216, 0.000180089991772547, 0.000175701468833722, 0.000171354404301383, 0.000167038422659971, 0.000162758704391308, 0.000158504903083667, 0.000154282184666954, 0.000150106090586632, 0.000145950732985511, 0.000141836819238961, 0.000137769529828802, 0.000133691879455, 0.000129686770378612, 0.000125702383229509, 0.000121733544801828, 0.000117821698950138, 0.000113935755507555, 0.000110065360786393, 0.000106262326880824, 0.000102485188108403, 9.87184175755829e-05, 9.50034591369331e-05, 9.13144031073898e-05, 8.76564372447319e-05, 8.40243810671382e-05, 8.04182272986509e-05, 7.68742538639344e-05, 7.33510023565032e-05, 6.98432922945358e-05, 6.6387394326739e-05, 6.29729474894702e-05, 5.95533201703802e-05, 5.62217792321462e-05, 5.29005919815972e-05, 4.95742278872058e-05, 4.63255819340702e-05, 4.30924810643774e-05, 3.98956508433912e-05, 3.67454485967755e-05, 3.35900622303598e-05, 3.04968543787254e-05, 2.74502781394403e-05, 2.43933391175233e-05, 2.14089377550408e-05, 1.8455622921465e-05, 1.55126690515317e-05, 1.26163504319265e-05, 9.75111834122799e-06, 6.90660999680404e-06, 4.11391511079273e-06, 1.35230686737486e-06, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16, 9.00897572315214e-16   }, 
   { 0.000888906477484852, 0.000879667291883379, 0.000870518677402288, 0.000861370121128857, 0.000852266792207956, 0.000843208807054907, 0.000834150880109519, 0.000825273978989571, 0.000816261337604374, 0.000807475007604808, 0.000798643508460373, 0.000789811951108277, 0.000781161594204605, 0.000772420666180551, 0.000763815536629409, 0.000755165063310415, 0.000746605335734785, 0.000738136062864214, 0.000729666848201305, 0.000721242919098586, 0.000712864333763719, 0.000704530859366059, 0.000696333474479616, 0.000688045402057469, 0.000679802615195513, 0.000671740970574319, 0.000663634040392935, 0.000655617739539593, 0.000647601380478591, 0.000639585079625249, 0.00063174992101267, 0.000623824191279709, 0.00061598903266713, 0.000608289730735123, 0.000600499857682735, 0.000592800555750728, 0.000585191824939102, 0.000577583094127476, 0.000570064992643893, 0.000562546832952648, 0.000555164588149637, 0.000547691714018583, 0.000540309469215572, 0.000533017795532942, 0.000525771349202842, 0.000518524961080402, 0.000511369144078344, 0.000504213327076286, 0.00049714813940227, 0.000490082893520594, 0.000483017647638917, 0.000476133573101833, 0.000469158898340538, 0.000462320138467476, 0.000455526605946943, 0.000448733131634071, 0.000442075484897941, 0.00043532729614526, 0.000428760249633342, 0.000422147888457403, 0.000415580841945484, 0.000409104395657778, 0.000402627920266241, 0.000396242045098916, 0.000389901426387951, 0.000383560836780816, 0.000377220218069851, 0.000371060828911141, 0.000364856095984578, 0.000358787219738588, 0.000352627801476046, 0.000346604239894077, 0.000340671220328659, 0.00033464765874669, 0.000328850554069504, 0.000322917563607916, 0.000317165715387091, 0.000311413896270096, 0.000305616791592911, 0.000300000829156488, 0.000294339581159875, 0.000288723618723452, 0.000283198256511241, 0.000277718150755391, 0.00027223807410337, 0.000266893854131922, 0.000261504348600283, 0.000256250699749216, 0.000250951765337959, 0.000245743431150913, 0.000240580367972143, 0.000235417319345288, 0.00023039014195092, 0.000225317649892531, 0.000220290457946248, 0.000215399137232453, 0.000210462530958466, 0.000205571210244671, 0.000200815760763362, 0.000196015025721863, 0.000191395462024957, 0.000186639997991733, 0.000182020434294827, 0.000177491427166387, 0.000172917134477757, 0.000168478727573529, 0.000163995020557195, 0.000159647184773348, 0.000155254048877396, 0.00015095149865374, 0.00014669424854219, 0.000142482269438915, 0.000138270319439471, 0.000134194211568683, 0.000130072818137705, 0.000126042010379024, 0.00012214707385283, 0.000118116266094148, 0.000114311907964293, 0.000110416971438099, 0.000106567320472095, 0.000102853548014536, 9.91397682810202e-05, 9.55165742198005e-05, 9.18480727705173e-05, 8.82701715454459e-05, 8.47375486046076e-05, 8.12502184999175e-05, 7.77628956711851e-05, 7.44567296351306e-05, 7.10599779267795e-05, 6.77990974509157e-05, 6.45382242510095e-05, 6.12773437751457e-05, 5.81976200919598e-05, 5.49820360902231e-05, 5.1992894441355e-05, 4.89584672322962e-05, 4.59240363852587e-05, 4.30707732448354e-05, 4.01269207941368e-05, 3.73189432139043e-05, 3.44656727975234e-05, 3.17029844154604e-05, 2.90761654468952e-05, 2.6358768081991e-05, 2.37319491134258e-05, 2.1195710360189e-05, 1.86594716069521e-05, 1.62138130690437e-05, 1.37681536216405e-05, 1.12772040665732e-05, 9.01270595932147e-06, 6.70291683491087e-06, 4.48370792582864e-06, 2.26449901674641e-06, 4.52899797664941e-08, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 9.5108958930723e-07, 3.07971868096502e-06, 5.29892759004724e-06, 7.60871671445784e-06, 9.91850538412109e-06, 1.22282945085317e-05, 1.46739539559348e-05, 1.70743223861791e-05, 1.96558503375854e-05, 2.21920909098117e-05, 2.46830386458896e-05, 2.74004378297832e-05, 3.00272567983484e-05, 3.28352361975703e-05, 3.55526353814639e-05, 3.83606129616965e-05, 4.12591725762468e-05, 4.41124393546488e-05, 4.70562881673686e-05, 5.00907190144062e-05, 5.3125146223465e-05, 5.6295444665011e-05, 5.93751610722393e-05, 6.25454631517641e-05, 6.58063436276279e-05, 6.90219312673435e-05, 7.23733901395462e-05, 7.5724849011749e-05, 7.90763006079942e-05, 8.26089235488325e-05, 8.60962536535226e-05, 8.96741621545516e-05, 9.32520706555806e-05, 9.68299791566096e-05, 0.000100589044450317, 0.000104257538623642, 0.000108016603917349, 0.000111911533167586, 0.000115715898573399, 0.000119701413495932, 0.000123641642858274, 0.000127581864944659, 0.000131703258375637, 0.000135779366246425, 0.000139946030685678, 0.000144112709676847, 0.000148324688780122, 0.000152627224451862, 0.000156929774675518, 0.000161232324899174, 0.000165716031915508, 0.000170109167811461, 0.000174728731508367, 0.000179212438524701, 0.000183786731213331, 0.000188496895134449, 0.00019311647338327, 0.000197917208424769, 0.000202672672457993, 0.000207473392947577, 0.000212410013773479, 0.000217256034375168, 0.000222283211769536, 0.000227265118155628, 0.000232292310101911, 0.000237319487496279, 0.000242527850787155, 0.000247736199526116, 0.000252989819273353, 0.000258243468124419, 0.000263632973656058, 0.000268977193627506, 0.000274321413598955, 0.000279846775811166, 0.000285372167127207, 0.000290942844003439, 0.000296513491775841, 0.000302129454212263, 0.000307881273329258, 0.000313542521325871, 0.000319339655106887, 0.000325182045344263, 0.00033102446468547, 0.000337048026267439, 0.000342935702065006, 0.000348959292750806, 0.000355028168996796, 0.000361097016138956, 0.000367301749065518, 0.00037346119643189, 0.000379665929358453, 0.000386006489861757, 0.000392347079468891, 0.000398687698179856, 0.000405164173571393, 0.000411550048738718, 0.000418071809690446, 0.000424638856202364, 0.000431251188274473, 0.000437954091466963, 0.000444611738203093, 0.000451405212515965, 0.000458153430372477, 0.000464946933789179, 0.000471876293886453, 0.000478805653983727, 0.000485825614305213, 0.000492800259962678, 0.000499820220284164, 0.000506976037286222, 0.000514086568728089, 0.000521287671290338, 0.000528534059412777, 0.000535825733095407, 0.000543117464985698, 0.000550544995348901, 0.000557927298359573, 0.000565490685403347, 0.00057291827397421, 0.000580572232138366, 0.000588180962949991, 0.000595789693761617, 0.000603534223046154, 0.000611233583185822, 0.000619023398030549, 0.000626858614850789, 0.000634739059023559, 0.00064266484696418, 0.000650681147817522, 0.000658652221318334, 0.000666759093292058, 0.000674865965265781, 0.000682972895447165, 0.000691260967869312, 0.000699413183610886, 0.000707791827153414, 0.000716125126928091, 0.000724549114238471, 0.00073297304334119, 0.000741396914236248, 0.000749956758227199, 0.0007584712584503, 0.000767076388001442, 0.000775817316025496, 0.00078446778934449, 0.000793208717368543, 0.000801994930952787, 0.000810826488304883, 0.00081974861677736, 0.000828670745249838, 0.000837638159282506, 0.000846696144435555, 0.000855754187796265, 0.000864902744069695, 0.000874051358550787, 0.000883199856616557, 0.000892529613338411, 0.000901814084500074, 0.000911098497454077, 0.000920564169064164, 0.000929939153138548, 0.000939495395869017, 0.000948960951063782, 0.00095851713558659, 0.000968209176789969, 0.000977810705080628, 0.000987593317404389, 0.000997285358607769, 0.00100715854205191, 0.00101694115437567, 0.00102681445423514, 0.00103677820879966, 0.00104674196336418, 0.00105679640546441, 0.00106689613312483, 0.00107699574436992, 0.00108709535561502, 0.0010973762255162, 0.001107566524297, 0.00111798313446343, 0.0011283092899248, 0.00113863544538617, 0.00114914262667298, 0.00115955935325474, 0.00117015722207725, 0.00118070980533957, 0.00119130767416209, 0.00120199611410499, 0.00121268455404788, 0.00122346344869584, 0.00123428786173463, 0.0012451121583581, 0.00125602702610195, 0.0012669418938458, 0.00127790204714984, 0.00128899805713445, 0.00130004878155887, 0.00131123547907919, 0.00132237677462399, 0.00133351818658412, 0.00134484062436968, 0.00135611789301038, 0.00136753101833165, 0.0013788987416774, 0.00139031175058335, 0.00140186084900051, 0.00141336431261152, 0.00142491329461336, 0.00143664341885597, 0.001448237686418, 0.00146001309622079, 0.00147174310404807, 0.00148351863026619, 0.00149542978033423, 0.00150729587767273, 0.00151925242971629, 0.00153125426732004, 0.00154325610492378, 0.00155539368279278, 0.00156748609151691, 0.00157962390221655, 0.00159189745318145, 0.00160412571858615, 0.00161649007350206, 0.00162880879361182, 0.00164117303211242, 0.00165371841285378, 0.00166612782049924, 0.00167876365594566, 0.00169130892027169, 0.00170389958657324, 0.00171662599314004, 0.00172930734697729, 0.00174207903910428, 0.00175489601679146, 0.00176775851286948, 0.00178062089253217, 0.00179361901246011, 0.00180657196324319, 0.00181970605626702, 0.00183274957817048, 0.00184592907316983, 0.00185906316619366, 0.00187224242836237, 0.00188560294918716, 0.00189887301530689, 0.00191227870527655, 0.00192568462807685, 0.00193909043446183, 0.00195263221394271, 0.00196612859144807, 0.00197971565648913, 0.00199334789067507, 0.00200702552683651, 0.00202074833214283, 0.00203451630659401, 0.00204832991585135, 0.00206223409622908, 0.00207613781094551, 0.00209013256244361, 0.00210412708111107, 0.00211816700175405, 0.00213225209154189, 0.00214638281613588, 0.00216051307506859, 0.00217477953992784, 0.00218904600478709, 0.0022033576387912, 0.00221771444194019, 0.00223211664706469, 0.00224665459245443, 0.00226110219955444, 0.00227564014494419, 0.00229026889428496, 0.00230485224165022, 0.00231961696408689, 0.00233433628454804, 0.00234910054132342, 0.00236391043290496, 0.00237876572646201, 0.00239371135830879, 0.00240865699015558, 0.00242360262200236, 0.00243872962892056, 0.00245376583188772, 0.00246889260597527, 0.00248415535315871, 0.00249932752922177, 0.0025146808475256, 0.00252994359470904, 0.00254538748413324, 0.00256078597158194, 0.00257622986100614, 0.00259176432155073, 0.00260729878209531, 0.00262287864461541, 0.00263850367628038, 0.00265421927906573, 0.00266993488185108, 0.00268574128858745, 0.00270154722966254, 0.00271748937666416, 0.0027333409525454, 0.00274928286671638, 0.0027653609868139, 0.0027813483029604, 0.00279751676134765, 0.00281368545256555, 0.00282985391095281, 0.0028461127076298, 0.00286232680082321, 0.00287872180342674, 0.00289502623490989, 0.00291142100468278, 0.00292790657840669, 0.00294443732127547, 0.0029609682969749, 0.00297758961096406, 0.00299421115778387, 0.00301096844486892, 0.00302772573195398, 0.00304439244791865, 0.00306133064441383, 0.00307817873544991, 0.00309511739760637, 0.00311210099607706, 0.00312908482737839, 0.00314620439894497, 0.00316323339939117, 0.00318035297095776, 0.00319756311364472, 0.00321481865830719, 0.00323216454125941, 0.00324946572072804, 0.00326681160368025, 0.00328424829058349, 0.0033017301466316, 0.00331930280663073, 0.00333682983182371, 0.0033544022589922, 0.00337211089208722, 0.00338977389037609, 0.00340752745978534, 0.00342532643117011, 0.00344312540255487, 0.00346106011420488, 0.00347894988954067, 0.00349688460119069, 0.00351495551876724, 0.00353298056870699, 0.00355118722654879, 0.00356930331327021, 0.00358741916716099, 0.00360576179809868, 0.00362401362508535, 0.00364240142516792, 0.00366074359044433, 0.00367917655967176, 0.00369765516370535, 0.00371613330207765, 0.00373470224440098, 0.00375336175784469, 0.00377197586931288, 0.00379072595387697, 0.00380943086929619, 0.00382818072102964, 0.00384711194783449, 0.00386595260351896, 0.00388492923229933, 0.00390390562824905, 0.0039228368550539, 0.00394199462607503, 0.00396106159314513, 0.00398026453331113, 0.00399946747347713, 0.00401867041364312, 0.00403796369209886, 0.00405734777450562, 0.00407668668776751, 0.00409620674327016, 0.00411559082567692, 0.00413515605032444, 0.00415472174063325, 0.00417433213442564, 0.00419403333216906, 0.00421373452991247, 0.00423352606594563, 0.00425327243283391, 0.00427310960367322, 0.00429303711280227, 0.00431296462193131, 0.00433289213106036, 0.00435295607894659, 0.00437301909551024, 0.00439312821254134, 0.00441328203305602, 0.00443348148837686, 0.00445381691679358, 0.00447401590645313, 0.00449448730796576, 0.0045148222707212, 0.00453520286828279, 0.004555718973279, 0.00457628071308136, 0.00459684245288372, 0.00461744936183095, 0.00463810143992305, 0.0046587991528213, 0.00467958720400929, 0.00470037525519729, 0.00472129927948117, 0.00474208733066916, 0.00476314732804894, 0.00478407088667154, 0.0048050400801003, 0.0048261908814311, 0.00484729604795575, 0.00486849155277014, 0.00488968752324581, 0.0049108830280602, 0.00493226014077663, 0.00495354644954205, 0.00497496826574206, 0.00499639054760337, 0.00501790316775441, 0.00503941578790545, 0.00506101921200752, 0.00508262263610959, 0.00510436203330755, 0.00512601062655449, 0.0051478398963809, 0.00516962446272373, 0.00519140949472785, 0.00521337473765016, 0.00523534044623375, 0.00525726098567247, 0.00527936220169067, 0.00530137307941914, 0.00532347476109862, 0.00534566678106785, 0.00536790397018194, 0.00539023196324706, 0.00541246961802244, 0.00543479714542627, 0.00545726157724857, 0.00547968037426472, 0.00550218904390931, 0.00552474334836006, 0.00554734328761697, 0.00556994276121259, 0.00559263303875923, 0.00561536848545074, 0.00563810393214226, 0.00566088501363993, 0.00568380206823349, 0.00570662785321474, 0.00572959007695317, 0.00575259746983647, 0.00577565003186464, 0.00579879293218255, 0.00582184549421072, 0.00584503402933478, 0.00586831290274858, 0.0058915470726788, 0.00591487158089876, 0.00593824125826359, 0.00596161093562841, 0.00598507095128298, 0.00600857613608241, 0.00603208225220442, 0.00605572294443846, 0.00607927376404405, 0.00610305089503527, 0.00612673768773675, 0.0061504696495831, 0.00617438275367022, 0.00619811471551657, 0.00622211862355471, 0.00624603172764182, 0.00626999046653509, 0.00629412988200784, 0.00631813332438469, 0.0063423179090023, 0.00636650295928121, 0.00639068800956011, 0.00641496293246746, 0.00643932912498713, 0.00646364968270063, 0.00648806151002645, 0.00651251804083586, 0.00653706537559628, 0.00656161224469543, 0.00658611441031098, 0.00661084242165089, 0.00663552526384592, 0.00666025374084711, 0.00668502785265446, 0.00670980103313923, 0.00673471065238118, 0.00675957510247827, 0.00678369123488665, 0.00680669955909252, 0.00682979729026556, 0.00685296254232526, 0.00687610637396574, 0.00689936196431518, 0.00692261895164847, 0.00694596581161022, 0.00696938065811992, 0.00699284067377448, 0.00701632397249341, 0.00703991949558258, 0.00706347078084946, 0.00708713475614786, 0.00711088953539729, 0.00713462103158236, 0.00715848850086331, 0.00718235690146685, 0.00720624718815088, 0.0072302739135921, 0.00725427689030766, 0.00727841630578041, 0.00730257853865623, 0.00732674077153206, 0.0073510161601007, 0.00737529201433063, 0.00739968055859208, 0.0074240923859179, 0.00744859408587217, 0.00747309578582644, 0.00749762076884508, 0.00752225797623396, 0.00754694081842899, 0.00757171493023634, 0.00759648811072111, 0.00762132974341512, 0.00764617137610912, 0.0076711717993021, 0.00769614893943071, 0.00772126251831651, 0.00774637563154101, 0.00777151202782989, 0.00779673783108592, 0.0078220097348094, 0.00784735009074211, 0.00787273421883583, 0.00789814256131649, 0.00792361795902252, 0.00794913899153471, 0.00797472801059484, 0.00800042971968651, 0.00802608579397202, 0.00805190205574036, 0.00807771645486355, 0.0081035103648901, 0.00812946073710918, 0.00815543532371521, 0.00818147696554661, 0.0082075409591198, 0.00823364965617657, 0.00825982820242643, 0.00828602816909552, 0.00831234082579613, 0.00833872240036726, 0.00836510397493839, 0.00839153118431568, 0.00841802638024092, 0.00844458863139153, 0.00847126450389624, 0.00849789567291737, 0.00852466095238924, 0.0085514048114419, 0.0085782166570425, 0.00860507413744926, 0.00863204337656498, 0.00865901354700327, 0.00868607498705387, 0.00871318113058805, 0.00874028634279966, 0.00876750610768795, 0.00879474822431803, 0.00882210303097963, 0.00884943548589945, 0.00887683592736721, 0.00890430342406034, 0.00893181748688221, 0.00895944517105818, 0.00898707192391157, 0.0090147890150547, 0.00904250703752041, 0.00907024648040533, 0.00909810047596693, 0.0091260215267539, 0.00915396586060524, 0.00918197724968195, 0.00921003427356482, 0.00923811364918947, 0.00926630664616823, 0.00929452292621136, 0.00932285189628601, 0.00935113523155451, 0.00937950890511274, 0.0094079514965415, 0.00943643879145384, 0.00946499407291412, 0.00949357263743877, 0.00952221732586622, 0.00955095421522856, 0.00957969110459089, 0.00960849598050117, 0.00963736791163683, 0.00966628547757864, 0.00969529431313276, 0.00972427893429995, 0.00975337810814381, 0.00978245493024588, 0.00981168914586306, 0.00984092429280281, 0.00987022649496794, 0.00989957433193922, 0.00992901250720024, 0.00995840597897768, 0.00998791214078665, 0.0100175095722079, 0.0100471060723066, 0.0100767938420177, 0.0101065039634705, 0.0101362597197294, 0.0101660834625363, 0.010195997543633, 0.0102259339764714, 0.0102559383958578, 0.010285965166986, 0.0103160161525011, 0.0103462236002088, 0.0103764096274972, 0.0104066636413336, 0.0104370079934597, 0.0104673746973276, 0.0104977414011955, 0.0105282450094819, 0.0105587476864457, 0.0105893183499575, 0.0106200017035007, 0.0106506859883666, 0.0106813926249743, 0.0107121895998716, 0.0107430322095752, 0.0107739428058267, 0.0108049213886261, 0.0108359213918447, 0.0108669679611921, 0.0108980825170875, 0.0109292417764664, 0.0109604923054576, 0.010991764254868, 0.011023105122149, 0.01105444598943, 0.0110858995467424, 0.0111173996701837, 0.0111489659175277, 0.0111805545166135, 0.011212213896215, 0.0112438704818487, 0.0112756658345461, 0.0113074583932757, 0.0113393198698759, 0.0113712949678302, 0.0114032467827201, 0.0114352675154805, 0.0114673310890794, 0.0114994887262583, 0.0115316435694695, 0.0115639129653573, 0.0115962279960513, 0.011628519743681, 0.0116609688848257, 0.0116933975368738, 0.0117259388789535, 0.0117585016414523, 0.0117911333218217, 0.0118237407878041, 0.0118564860895276, 0.0118892760947347, 0.0119220884516835, 0.0119549911469221, 0.0119879404082894, 0.0120208896696568, 0.0120539274066687, 0.0120870573446155, 0.0121202319860458, 0.0121534308418632, 0.0121867414563894, 0.012220005504787, 0.0122533617541194, 0.0122867645695806, 0.0123202782124281, 0.0123537695035338, 0.0123873986303806, 0.0124210258945823, 0.0124546764418483, 0.0124884396791458, 0.0125222494825721, 0.0125561039894819, 0.0125900031998754, 0.0126239256933331, 0.0126579385250807, 0.0126920184120536, 0.012726167216897, 0.0127602936699986, 0.0127945775166154, 0.0128288175910711, 0.0128631247207522, 0.0128975212574005, 0.0129319876432419, 0.0129664987325668, 0.0130010554566979, 0.0130356112495065, 0.0130702806636691, 0.0131049724295735, 0.0131397778168321, 0.0131745608523488, 0.0132094565778971, 0.0132443308830261, 0.0132793169468641, 0.0133143486455083, 0.013349425047636, 0.0133846160024405, 0.0134198060259223, 0.0134549951180816, 0.0134902996942401, 0.0135256489738822, 0.0135610662400723, 0.0135965719819069, 0.0136320572346449, 0.013667588122189, 0.0137032307684422, 0.0137388743460178, 0.013774630613625, 0.0138104325160384, 0.0138462567701936, 0.0138821257278323, 0.0139180636033416, 0.0139540694653988, 0.0139900967478752, 0.0140262385830283, 0.0140623804181814, 0.0140986116603017, 0.0141348214820027, 0.0141711663454771, 0.0142075354233384, 0.0142439696937799, 0.0142804738134146, 0.0143169546499848, 0.0143535267561674, 0.0143901882693172, 0.0144268963485956, 0.0144636491313577, 0.0145004251971841, 0.0145372906699777, 0.0145741794258356, 0.0146111361682415, 0.0146481385454535, 0.0146852536126971, 0.0147223453968763, 0.0147595526650548, 0.0147967347875237, 0.0148340314626694, 0.0148713504895568, 0.0149087812751532, 0.0149461915716529, 0.0149836922064424, 0.015021214261651, 0.0150588499382138, 0.0150965312495828, 0.0151342358440161, 0.0151719842106104, 0.0152097567915916, 0.0152476420626044, 0.0152855729684234, 0.0153235709294677, 0.0153615903109312, 0.0153997028246522, 0.0154377920553088, 0.0154759930446744, 0.0155142638832331, 0.015552556142211, 0.0155909396708012, 0.0156293231993914, 0.0156678184866905, 0.0157062709331512, 0.0157448798418045, 0.0157834906131029, 0.0158221684396267, 0.0158609133213758, 0.0158996805548668, 0.0159384943544865, 0.0159773994237185, 0.0160163696855307, 0.0160553436726332, 0.0160944052040577, 0.0161335133016109, 0.0161726661026478, 0.0162118654698133, 0.0162511318922043, 0.0162904653698206, 0.0163298230618238, 0.0163692720234394, 0.0164087191224098, 0.0164482556283474, 0.0164878629148006, 0.0165274906903505, 0.0165672115981579, 0.0166069511324167, 0.0166467409580946, 0.0166865717619658, 0.0167264956980944, 0.0167664643377066, 0.0168064776808023, 0.0168465599417686, 0.0168866403400898, 0.0169268343597651, 0.0169670768082142, 0.0170073602348566, 0.0170476920902729, 0.0170881133526564, 0.017128512263298, 0.0171690247952938, 0.0172096025198698, 0.0172501839697361, 0.0172908753156662, 0.0173315685242414, 0.0173723082989454, 0.0174131821841002, 0.0174540113657713, 0.0174949299544096, 0.0175359416753054, 0.0175769720226526, 0.0176180507987738, 0.0176591742783785, 0.0177003871649504, 0.0177416261285543, 0.0177829526364803, 0.0178243238478899, 0.0178656745702028, 0.0179071594029665, 0.0179486908018589, 0.0179902669042349, 0.0180318877100945, 0.0180735550820827, 0.0181152671575546, 0.0181570705026388, 0.0181989185512066, 0.018240787088871, 0.0182827711105347, 0.0183247551321983, 0.0183668080717325, 0.0184089057147503, 0.0184510704129934, 0.0184932816773653, 0.0185355804860592, 0.01857790350914, 0.018620228394866, 0.0186626650393009, 0.0187051687389612, 0.0187476966530085, 0.0187902916222811, 0.0188329555094242, 0.018875639885664, 0.0189183726906776, 0.0189611706882715, 0.0190039929002523, 0.0190469492226839, 0.0190899297595024, 0.0191329549998045, 0.0191759578883648, 0.0192191191017628, 0.0192622803151608, 0.019305532798171, 0.0193488746881485, 0.0193921495229006, 0.0194355379790068, 0.0194789934903383, 0.0195225179195404, 0.0195660404860973, 0.0196096785366535, 0.0196533147245646, 0.0196970198303461, 0.019740791991353, 0.0197846554219723, 0.0198285188525915, 0.0198724493384361, 0.0199164040386677, 0.0199604257941246, 0.0200045388191938, 0.0200486965477467, 0.0200928989797831, 0.02013717032969, 0.0201814193278551, 0.0202257800847292, 0.0202702321112156, 0.020314684137702, 0.0203592050820589, 0.020403815433383, 0.0204483810812235, 0.0204930584877729, 0.0205378048121929, 0.0205825977027416, 0.0206274334341288, 0.0206723622977734, 0.020717266947031, 0.020762262865901, 0.0208073277026415, 0.0208524577319622, 0.0208976119756699, 0.0209428332746029, 0.0209881477057934, 0.0210333894938231, 0.0210787933319807, 0.0211241971701384, 0.0211697593331337, 0.0212152525782585, 0.0212608817964792, 0.0213064663112164, 0.0213521420955658, 0.021397951990366, 0.0214437413960695, 0.0214896202087402, 0.0215355213731527, 0.021581444889307, 0.0216274596750736, 0.0216735638678074, 0.0217197388410568, 0.0217659119516611, 0.021812129765749, 0.0218583941459656, 0.0219047721475363, 0.0219511482864618, 0.0219976361840963, 0.0220441278070211, 0.0220906846225262, 0.022137263789773, 0.0221838932484388, 0.0222306530922651, 0.0222774371504784, 0.0223242677748203, 0.0223711431026459, 0.0224180407822132, 0.0224650520831347, 0.0225120857357979, 0.0225591640919447, 0.0226063560694456, 0.0226535033434629, 0.0227007437497377, 0.0227480921894312, 0.0227954220026731, 0.0228428859263659, 0.0228903498500586, 0.0229378566145897, 0.0229854136705399, 0.023033058270812, 0.0230807233601809, 0.0231284592300653, 0.0231762882322073, 0.023224089294672, 0.0232719630002975, 0.0233199447393417, 0.023367952555418, 0.023416006937623, 0.0234641265124083, 0.0235122703015804, 0.023560481145978, 0.0236087813973427, 0.0236571300774813, 0.0237055011093616, 0.0237539149820805, 0.0238024424761534, 0.0238509029150009, 0.0238995216786861, 0.0239481851458549, 0.0239969193935394, 0.024045629426837, 0.024094495922327, 0.0241433195769787, 0.0241922326385975, 0.0242411904036999, 0.0242901928722858, 0.0243393089622259, 0.0243884269148111, 0.0244375877082348, 0.0244868416339159, 0.0245361402630806, 0.0245854835957289, 0.0246348734945059, 0.0246843509376049, 0.0247338078916073, 0.0247834008187056, 0.0248330160975456, 0.0248826760798693, 0.0249324049800634, 0.0249827615916729, 0.0250345263630152, 0.0250863377004862, 0.0251382403075695, 0.0251901876181364, 0.025242205709219, 0.0252943113446236, 0.0253464393317699, 0.0253986585885286, 0.0254509020596743, 0.0255032312124968, 0.0255556125193834, 0.025608079507947, 0.0256605707108974, 0.0257131066173315, 0.0257657580077648, 0.0258184969425201, 0.0258712377399206, 0.0259240679442883, 0.0259768981486559, 0.0260298419743776, 0.0260829012840986, 0.0261359345167875, 0.0261890590190887, 0.0262422282248735, 0.0262954905629158, 0.0263487994670868, 0.0264022182673216, 0.0264556128531694, 0.0265091452747583, 0.0265627019107342, 0.0266162808984518, 0.0266700387001038, 0.0267237052321434, 0.026777533814311, 0.0268314518034458, 0.0268853921443224, 0.0269393119961023, 0.0269933622330427, 0.0270474851131439, 0.0271016992628574, 0.0271559543907642, 0.0272102132439613, 0.0272646062076092, 0.0273190010339022, 0.027373505756259, 0.0274280570447445, 0.0274826772511005, 0.027537340298295, 0.0275920983403921, 0.0276469010859728, 0.0277017429471016, 0.0277566388249397, 0.0278116632252932, 0.0278666913509369, 0.0279218070209026, 0.0279769264161587, 0.0280321557074785, 0.028087455779314, 0.0281428229063749, 0.0281982813030481, 0.0282537154853344, 0.0283092427998781, 0.028364859521389, 0.0284205190837383, 0.0284762922674417, 0.0285320244729519, 0.0285878628492355, 0.0286437533795834, 0.0286997556686401, 0.0287557560950518, 0.0288118924945593, 0.0288680531084538, 0.0289242789149284, 0.0289805512875319, 0.0290368255227804, 0.0290932338684797, 0.0291497334837914, 0.0292062759399414, 0.0292628686875105, 0.0293194781988859, 0.0293762069195509, 0.029432974755764, 0.0294898375868797, 0.0295467227697372, 0.0296036954969168, 0.0296606943011284, 0.0297178067266941, 0.0297749396413565, 0.0298320911824703, 0.0298893880099058, 0.0299467910081148, 0.0300041269510984, 0.0300616007298231, 0.0301190745085478, 0.0301766600459814, 0.0302343126386404, 0.0302920583635569, 0.0303497798740864, 0.0304075926542282, 0.0304654967039824, 0.0305234454572201, 0.030581483617425, 0.0306395459920168, 0.0306976288557053, 0.0307558290660381, 0.030814116820693, 0.0308724492788315, 0.0309308040887117, 0.0309892762452364, 0.0310477241873741, 0.0311063043773174, 0.0311649329960346, 0.0312236063182354, 0.0312824174761772, 0.0313412435352802, 0.0314000807702541, 0.0314589999616146, 0.0315180122852325, 0.0315771177411079, 0.031636219471693, 0.0316954366862774, 0.0317546091973782, 0.0318138897418976, 0.0318733118474483, 0.0319327786564827, 0.031992245465517, 0.0320518016815186, 0.0321114026010036, 0.0321710705757141, 0.032230831682682, 0.0322906151413918, 0.0323504917323589, 0.0324104502797127, 0.0324704125523567, 0.0325304232537746, 0.0325905457139015, 0.0326507389545441, 0.0327109955251217, 0.0327713191509247, 0.0328316278755665, 0.0328920185565948, 0.032952506095171, 0.033013079315424, 0.0330737456679344, 0.0331343673169613, 0.0331950522959232, 0.0332558788359165, 0.0333167277276516, 0.0333776883780956, 0.0334386229515076, 0.0334996543824673, 0.0335607267916203, 0.033621933311224, 0.033683143556118, 0.0337444245815277, 0.0338057912886143, 0.0338672026991844, 0.0339286625385284, 0.033990167081356, 0.0340517833828926, 0.0341134667396545, 0.0341751985251904, 0.0342369750142097, 0.0342987738549709, 0.0343606844544411, 0.0344226397573948, 0.0344847105443478, 0.0345468036830425, 0.0346089191734791, 0.0346711687743664, 0.034733422100544, 0.0347957648336887, 0.0348581708967686, 0.0349206477403641, 0.0349831469357014, 0.0350457392632961, 0.0351083539426327, 0.0351710580289364, 0.0352338291704655, 0.0352966897189617, 0.0353595986962318, 0.0354225523769855, 0.0354854799807072, 0.0355485938489437, 0.0356117524206638, 0.0356749556958675, 0.0357381999492645, 0.0358015410602093, 0.0358649455010891, 0.0359283946454525, 0.0359918922185898, 0.0360554344952106, 0.0361191108822823, 0.036182813346386, 0.0362465567886829, 0.0363104157149792, 0.0363742299377918, 0.0364381782710552, 0.0365022197365761, 0.0365662835538387, 0.0366303883492947, 0.0366945639252663, 0.0367588549852371, 0.0368231646716595, 0.0368875712156296, 0.0369519516825676, 0.0370164439082146, 0.0370810255408287, 0.0371456779539585, 0.0372103713452816, 0.0372750945389271, 0.0373398587107658, 0.0374047346413136, 0.0374697037041187, 0.0375346951186657, 0.037599753588438, 0.0376648791134357, 0.0377300754189491, 0.0377952456474304, 0.0378605797886848, 0.0379259549081326, 0.0379914008080959, 0.0380568876862526, 0.0381224676966667, 0.0381879806518555, 0.0382536947727203, 0.0383194573223591, 0.0383852608501911, 0.0384511388838291, 0.0385170541703701, 0.0385830216109753, 0.0386490523815155, 0.0387151762843132, 0.0387813225388527, 0.0388475619256496, 0.0389138646423817, 0.0389802120625973, 0.0390466116368771, 0.0391130745410919, 0.0391796268522739, 0.0392462499439716, 0.0393129624426365, 0.0393796749413013, 0.0394463874399662, 0.0395132303237915, 0.0395801924169064, 0.039647176861763, 0.039714228361845, 0.0397812575101852, 0.0398484021425247, 0.0399156548082829, 0.0399829559028149, 0.0400502569973469, 0.0401176922023296, 0.0401851311326027, 0.0402526818215847, 0.0403202548623085, 0.0403879173099995, 0.040455624461174, 0.040523424744606, 0.0405912697315216, 0.0406591147184372, 0.0407270714640617, 0.0407951436936855, 0.0408632569015026, 0.0409313961863518, 0.0409995131194592, 0.0410678349435329, 0.0411361530423164, 0.0412045642733574, 0.0412730649113655, 0.0413415431976318, 0.0414100661873817, 0.0414787493646145, 0.0415474511682987, 0.0416162498295307, 0.0416850708425045, 0.0417539291083813, 0.0418228842318058, 0.0418919064104557, 0.0419609732925892, 0.042030107229948, 0.0420993342995644, 0.0421686284244061, 0.0422378778457642, 0.0423072390258312, 0.042376734316349, 0.0424462109804153, 0.0425157994031906, 0.0425854325294495, 0.0426550656557083, 0.0427248552441597, 0.0427946969866753, 0.0428645759820938, 0.0429344810545444, 0.0430045016109943, 0.0430745892226696, 0.0431446731090546, 0.0432148948311806, 0.043285071849823, 0.043355405330658, 0.0434258095920086, 0.0434962548315525, 0.0435667298734188, 0.0436372496187687, 0.0437078773975372, 0.0437785983085632, 0.0438493601977825, 0.0439201705157757, 0.0439909622073174, 0.0440618842840195, 0.044132899492979, 0.0442039594054222, 0.044275090098381, 0.0443462170660496, 0.0444174595177174, 0.0444887913763523, 0.0445602126419544, 0.0446315445005894, 0.0447030514478683, 0.0447745658457279, 0.0448461920022964, 0.0449178665876389, 0.0449896045029163, 0.0450613908469677, 0.045133288949728, 0.0452051647007465, 0.0452771075069904, 0.0453491620719433, 0.0454213097691536, 0.0454934537410736, 0.0455656945705414, 0.0456379130482674, 0.0457103028893471, 0.0457827262580395, 0.0458552092313766, 0.0459277406334877, 0.0460003167390823, 0.0460729636251926, 0.0461456775665283, 0.0462184995412827, 0.0462913289666176, 0.0463642477989197, 0.0464372113347054, 0.0465102642774582, 0.0465833097696304, 0.0466564297676086, 0.0467296876013279, 0.0468030162155628, 0.0468763150274754, 0.0469497554004192, 0.0470231436192989, 0.0470966771245003, 0.0471702925860882, 0.0472439602017403, 0.0473176687955856, 0.0473913997411728, 0.0474652014672756, 0.0475391373038292, 0.0476130917668343, 0.0476870946586132, 0.0477611720561981, 0.0478353053331375, 0.0479095205664635, 0.0479837954044342, 0.0480581112205982, 0.0481325201690197, 0.0482069402933121, 0.0482815057039261, 0.0483560115098953, 0.0484306663274765, 0.0485053509473801, 0.0485801510512829, 0.0486550182104111, 0.0487298332154751, 0.048804759979248, 0.0488798096776009, 0.0489548780024052, 0.0490300096571445, 0.0491051934659481, 0.0491804666817188, 0.0492557398974895, 0.049331147223711, 0.0494065992534161, 0.0494820512831211, 0.0495576411485672, 0.0496332719922066, 0.0497089326381683, 0.049784678965807, 0.0498604997992516, 0.0499364025890827, 0.0500123538076878, 0.0500883273780346, 0.0501643419265747, 0.0502404794096947, 0.0503166541457176, 0.0503929443657398, 0.0504692159593105, 0.0505456030368805, 0.0506220012903214, 0.05069849640131, 0.0507750995457172, 0.05085164681077, 0.0509283430874348, 0.0510051064193249, 0.0510818473994732, 0.0511587522923946, 0.0512356571853161, 0.0513126291334629, 0.0513897091150284, 0.051466841250658, 0.0515439659357071, 0.0516211874783039, 0.0516984984278679, 0.051775835454464, 0.0518532991409302, 0.0519307665526867, 0.0520082376897335, 0.0520858839154243, 0.0521635822951794, 0.0522412732243538, 0.0523190572857857, 0.0523969158530235, 0.0524748116731644, 0.052552804350853, 0.0526308789849281, 0.0527089647948742, 0.0527870915830135, 0.0528653487563133, 0.0529436059296131, 0.0530219152569771, 0.0531003586947918, 0.053178820759058, 0.0532573536038399, 0.0533359795808792, 0.0534145832061768, 0.053493294864893, 0.0535720773041248, 0.0536509454250336, 0.053729847073555, 0.0538087859749794, 0.053887814283371, 0.0539668723940849, 0.054046057164669, 0.0541252233088017, 0.0542045049369335, 0.0542838796973228, 0.0543632656335831, 0.0544427074491978, 0.0545221865177155, 0.0546017922461033, 0.0546814538538456, 0.0547611378133297, 0.0548409670591354, 0.0549207888543606, 0.0550006106495857, 0.0550806187093258, 0.0551606416702271, 0.0552406907081604, 0.0553208142518997, 0.0554010421037674, 0.0554812736809254, 0.0555616170167923, 0.0556419864296913, 0.0557223968207836, 0.0558029413223267, 0.0558835119009018, 0.0559641346335411, 0.0560448430478573, 0.0561255924403667, 0.0562063902616501, 0.0562872514128685, 0.0563682354986668, 0.0564492382109165, 0.0565302819013596, 0.0566114373505116, 0.0566925778985023, 0.0567738749086857, 0.0568551681935787, 0.0569365099072456, 0.0570179894566536, 0.0570994652807713, 0.0571810305118561, 0.0572626441717148, 0.0573443435132504, 0.0574260465800762, 0.0575078651309013, 0.0575897470116615, 0.0576716773211956, 0.0577536560595036, 0.0578356981277466, 0.0579178519546986, 0.0580000095069408, 0.05808225274086, 0.0581645965576172, 0.0582468882203102, 0.0583293326199055, 0.0584118068218231, 0.0584943480789661, 0.0585782565176487, 0.0586634427309036, 0.0587487258017063, 0.0588340535759926, 0.0589194223284721, 0.0590048618614674, 0.0590903721749783, 0.0591759011149406, 0.0592614747583866, 0.0593471676111221, 0.0594328306615353, 0.0595185868442059, 0.0596043653786182, 0.0596902146935463, 0.0597761273384094, 0.0598620660603046, 0.059948094189167, 0.0600341446697712, 0.0601202435791492, 0.0602064318954945, 0.0602926649153233, 0.0603788942098618, 0.0604652129113674, 0.0605516098439693, 0.0606379956007004, 0.0607244744896889, 0.060811024159193, 0.0608975738286972, 0.0609842352569103, 0.0610709227621555, 0.0611576288938522, 0.0612444281578064, 0.0613313019275665, 0.0614181645214558, 0.0615051165223122, 0.0615921393036842, 0.0616791248321533, 0.0617662593722343, 0.0618533976376057, 0.0619405992329121, 0.0620278529822826, 0.0621151775121689, 0.0622025392949581, 0.0622899457812309, 0.0623774006962776, 0.0624649487435818, 0.0625524967908859, 0.0626401081681252, 0.0627278089523315, 0.0628154948353767, 0.0629032924771309, 0.0629911497235298, 0.063078947365284, 0.0631669238209724, 0.0632549002766609, 0.0633429139852524, 0.063431054353714, 0.0635191574692726, 0.0636073425412178, 0.0636955723166466, 0.0637838840484619, 0.0638722479343414, 0.0639606490731239, 0.0640491247177124, 0.0641375780105591, 0.0642261654138565, 0.0643147304654121, 0.0644034072756767, 0.0644921287894249, 0.0645808950066566, 0.064669705927372, 0.0647585690021515, 0.0648474916815758, 0.0649364441633224, 0.0650254637002945, 0.0651145651936531, 0.0652036964893341, 0.0652928948402405, 0.0653820782899857, 0.065471388399601, 0.0655606761574745, 0.0656501054763794, 0.0657395422458649, 0.0658290386199951, 0.0659185796976089, 0.0660081654787064, 0.0660978332161903, 0.0661875084042549, 0.0662772804498672, 0.0663670599460602, 0.0664569139480591, 0.0665468350052834, 0.0666367635130882, 0.0667268261313438, 0.0668168589472771, 0.0669069439172745, 0.066997155547142, 0.0670873746275902, 0.0671776905655861, 0.0672679468989372, 0.0673583224415779, 0.0674487873911858, 0.0675392374396324, 0.0676297917962074, 0.0677203983068466, 0.0678109750151634, 0.0679016634821892, 0.0679924711585045, 0.0680832117795944, 0.0681740641593933, 0.0682649835944176, 0.0683558881282806, 0.0684469193220139, 0.0685379654169083, 0.0686290487647057, 0.0687202140688896, 0.068811446428299, 0.0689026638865471, 0.0689939931035042, 0.0690853893756866, 0.0691767334938049, 0.0692682266235352, 0.0693597570061684, 0.0694513097405434, 0.0695429518818855, 0.0696346461772919, 0.0697263553738594, 0.0698181316256523, 0.0699099749326706, 0.0700018554925919, 0.0700937956571579, 0.0701857954263687, 0.0702778249979019, 0.0703699216246605, 0.0704620629549026, 0.070554256439209, 0.0706464871764183, 0.0707387626171112, 0.0708311572670937, 0.0709235295653343, 0.0710160061717033, 0.071108490228653, 0.0712010636925697, 0.0712936818599701, 0.071386344730854, 0.0714790746569633, 0.0715718120336533, 0.0716646537184715, 0.0717575401067734, 0.0718504339456558, 0.0719434097409248, 0.072036437690258, 0.072129525244236, 0.0722226500511169, 0.0723158493638039, 0.0724090561270714, 0.0725023597478867, 0.0725957006216049, 0.0726890861988068, 0.0727825462818146, 0.0728760212659836, 0.0729695707559586, 0.0730631873011589, 0.0731568485498428, 0.073250524699688, 0.0733442977070808, 0.0734381154179573, 0.0735319331288338, 0.0736258700489998, 0.0737198442220688, 0.0738138407468796, 0.0739079117774963, 0.0740020200610161, 0.0740961804986, 0.0741904303431511, 0.0742847248911858, 0.0743790343403816, 0.0744734182953835, 0.0745678469538689, 0.0746623203158379, 0.0747568681836128, 0.0748514533042908, 0.0749461129307747, 0.0750407874584198, 0.0751355364918709, 0.0752303525805473, 0.0753251686692238, 0.0754200741648674, 0.075515016913414, 0.0756100416183472, 0.0757050812244415, 0.0758001878857613, 0.075895369052887, 0.0759905651211739, 0.0760858356952667, 0.0761811211705208, 0.0762765258550644, 0.0763719379901886, 0.076467402279377, 0.0765629410743713, 0.0766585022211075, 0.076754130423069, 0.0768498033285141, 0.0769455507397652, 0.0770413428544998, 0.0771371722221375, 0.0772330537438393, 0.0773289725184441, 0.077424943447113, 0.0775210037827492, 0.0776171535253525, 0.0777132585644722, 0.0778094530105591, 0.0779057145118713, 0.078002005815506, 0.078098364174366, 0.0781948044896126, 0.078291229903698, 0.0783877670764923, 0.0784843266010284, 0.0785809233784676, 0.078677624464035, 0.0787743628025055, 0.0788710936903954, 0.0789679288864136, 0.0790648236870766, 0.0791617035865784, 0.0792587101459503, 0.0793557390570641, 0.079452782869339, 0.0795499458909035, 0.0796471834182739, 0.0797443836927414, 0.0798416584730148, 0.0799390152096748, 0.080036386847496, 0.0801338702440262, 0.0802313834428787, 0.0803288668394089, 0.0804265141487122, 0.0805241838097572, 0.0806219205260277, 0.0807196348905563, 0.0808174610137939, 0.0809153541922569, 0.0810132250189781, 0.0811112299561501, 0.0812092423439026, 0.0813072919845581, 0.0814054384827614, 0.0815036222338676, 0.0816018357872963, 0.0817001089453697, 0.0817984864115715, 0.0818968117237091, 0.0819952487945557, 0.0820937529206276, 0.0821922793984413, 0.0822908729314804, 0.0823894962668419, 0.0824882015585899, 0.082586981356144, 0.0826857835054398, 0.0827846005558968, 0.0828835368156433, 0.0829824507236481, 0.0830814763903618, 0.0831805542111397, 0.083279624581337, 0.083378829061985, 0.0834780186414719, 0.0835772901773453, 0.0836766138672829, 0.0837760046124458, 0.08387541025877, 0.0839748978614807, 0.0840744376182556, 0.0841740071773529, 0.0842736288905144, 0.0843733251094818, 0.0844730362296104, 0.0845728367567062, 0.084672674536705, 0.0847725868225098, 0.0848724693059921, 0.0849725157022476, 0.0850725620985031, 0.0851726531982422, 0.0852728113532066, 0.0853729918599129, 0.0854732841253281, 0.0855735838413239, 0.0856739431619644, 0.0857743769884109, 0.0858748108148575, 0.0859753265976906, 0.0860758870840073, 0.0861765295267105, 0.0862771570682526, 0.0863779336214066, 0.0864786729216576, 0.0865795090794563, 0.0866804048418999, 0.0867813155055046, 0.0868823006749153, 0.0869833454489708, 0.0870844274759293, 0.0871855914592743, 0.0872867628931999, 0.0873880311846733, 0.0874893069267273, 0.0875906348228455, 0.0876920893788338, 0.0877935290336609, 0.0878950282931328, 0.08799659460783, 0.0880982130765915, 0.0881998315453529, 0.0883015841245651, 0.0884033218026161, 0.0885051339864731, 0.0886070355772972, 0.0887089148163795, 0.0888109058141708, 0.0889129415154457, 0.0890149995684624, 0.0891171395778656, 0.0892193093895912, 0.0893215537071228, 0.089423842728138, 0.0895261690020561, 0.0896285623311996, 0.0897309929132462, 0.089833490550518, 0.0899360179901123, 0.0900386050343513, 0.0901412591338158, 0.090243972837925, 0.0903467088937759, 0.0904495269060135, 0.090552382171154, 0.0906552821397781, 0.0907582342624664, 0.0908612385392189, 0.0909643322229385, 0.0910674333572388, 0.0911706015467644, 0.0912738516926765, 0.0913770645856857, 0.091480441391468, 0.0915837809443474, 0.0916872322559357, 0.0917906984686852, 0.0918942540884018, 0.0919978246092796, 0.0921014696359634, 0.0922051444649696, 0.0923088788986206, 0.0924127027392387, 0.0925165042281151, 0.0926204472780228, 0.0927243903279305, 0.0928283780813217, 0.0929324626922607, 0.093036524951458, 0.0931406989693642, 0.0932449027895927, 0.0933491438627243, 0.0934534668922424, 0.0935578122735023, 0.0936622619628906, 0.0937667116522789, 0.0938712731003761, 0.093975804746151, 0.0940804407000542, 0.0941851213574409, 0.0942898318171501, 0.0943946465849876, 0.0944994390010834, 0.0946043357253075, 0.0947092697024345, 0.094814270734787, 0.0949193239212036, 0.095024399459362, 0.095129556953907, 0.095234714448452, 0.0953399762511253, 0.0954452976584435, 0.0955506414175034, 0.095656044781208, 0.0957614928483963, 0.0958670154213905, 0.0959725603461266, 0.0960781797766685, 0.0961838364601135, 0.0962895676493645, 0.0963953360915184, 0.0965011194348335, 0.0966070219874382, 0.0967129170894623, 0.0968189239501953, 0.0969249680638313, 0.0970310345292091, 0.0971371755003929, 0.0972433388233185, 0.09734957665205, 0.0974558517336845, 0.0975621938705444, 0.0976686254143715, 0.0977750644087791, 0.0978815630078316, 0.0979881063103676, 0.0980946943163872, 0.0982013270258904, 0.0983080491423607, 0.0984147936105728, 0.0985216498374939, 0.0986284762620926, 0.0987353697419167, 0.0988423824310303, 0.0989493504166603, 0.0990564301609993, 0.0991635844111443, 0.0992707386612892, 0.0993779525160789, 0.0994852334260941, 0.0995925739407539, 0.099699929356575, 0.0998073741793633, 0.0999148711562157, 0.10002239793539, 0.100129999220371, 0.100237607955933, 0.100345328450203, 0.100453078746796, 0.100560821592808, 0.100668720901012, 0.100776605308056, 0.100884549319744, 0.100992560386658, 0.101100616157055, 0.101208716630936, 0.101316891610622, 0.101425118744373, 0.101533353328705, 0.101641707122326, 0.101750046014786, 0.101858504116535, 0.101966939866543, 0.102075457572937, 0.10218407958746, 0.102292694151402, 0.102401353418827, 0.10251010209322, 0.102618865668774, 0.102727711200714, 0.102836601436138, 0.102945566177368, 0.103054516017437, 0.103163562715054, 0.103272669017315, 0.10338182002306, 0.10349103063345, 0.103600278496742, 0.103709578514099, 0.10381892323494, 0.103928335011005, 0.104037798941135, 0.104147277772427, 0.104256860911846, 0.104366488754749, 0.104476161301136, 0.104585856199265, 0.104695655405521, 0.104805439710617, 0.104915358126163, 0.105025306344032, 0.105135262012482, 0.105245321989059, 0.105355367064476, 0.10546550899744, 0.105575710535049, 0.105685941874981, 0.105796255171299, 0.105906590819359, 0.106016993522644, 0.106127418577671, 0.106237933039665, 0.106348469853401, 0.106459103524685, 0.10656975209713, 0.106680452823639, 0.106791257858276, 0.106902033090591, 0.107012897729874, 0.10712381452322, 0.107234790921211, 0.107345797121525, 0.107456870377064, 0.107567988336086, 0.107680924236774, 0.107794158160686, 0.10790740698576, 0.108020715415478, 0.108134001493454, 0.108247317373753, 0.108360670506954, 0.108474045991898, 0.108587428927422, 0.108700849115849, 0.108814306557178, 0.108927756547928, 0.109041258692741, 0.109154753386974, 0.109268292784691, 0.10938186198473, 0.10949544608593, 0.109609059989452, 0.109722696244717, 0.109836347401142, 0.10995002835989, 0.11006373912096, 0.110177464783192, 0.110291212797165, 0.110404998064041, 0.110518783330917, 0.110632620751858, 0.110746458172798, 0.11086031794548, 0.110974229872227, 0.111088149249554, 0.111202076077461, 0.111316055059433, 0.111430034041405, 0.11154405772686, 0.111658096313477, 0.111772142350674, 0.111886262893677, 0.112000346183777, 0.11211446672678, 0.112228654325008, 0.112342827022076, 0.112457022070885, 0.112571261823177, 0.112685509026051, 0.112799815833569, 0.112914077937603, 0.113028407096863, 0.113142773509026, 0.113257139921188, 0.113371506333351, 0.113485962152481, 0.113600395619869, 0.11371485888958, 0.113829366862774, 0.113943874835968, 0.114058405160904, 0.114172980189323, 0.114287555217743, 0.114402182400227, 0.11451680958271, 0.114631466567516, 0.114746160805225, 0.114860855042934, 0.114975579082966, 0.1150903403759, 0.115205116569996, 0.115319907665253, 0.115434758365154, 0.115549579262733, 0.115664459764957, 0.115779355168343, 0.11589427292347, 0.116009227931499, 0.11612419039011, 0.116239167749882, 0.116354204714298, 0.116469234228134, 0.116584293544292, 0.116699405014515, 0.116814509034157, 0.116929620504379, 0.117044799029827, 0.117159970104694, 0.117275178432465, 0.117390416562557, 0.11750566214323, 0.117620922625065, 0.117736220359802, 0.117851555347443, 0.117966897785664, 0.118082262575626, 0.118197679519653, 0.1183130890131, 0.118428535759449, 0.118544012308121, 0.118659503757954, 0.118775010108948, 0.118890538811684, 0.119006104767323, 0.119121693074703, 0.119237326085567, 0.11935293674469, 0.119468599557877, 0.119584292173386, 0.119699977338314, 0.119815699756145, 0.119931481778622, 0.120047248899937, 0.120163038372993, 0.120278872549534, 0.120394721627235, 0.120510585606098, 0.120626501739025, 0.120742417871952, 0.120858371257782, 0.120974339544773, 0.121090315282345, 0.121206343173981, 0.121322378516197, 0.121438436210155, 0.121554538607597, 0.121670633554459, 0.121786773204803, 0.12190293520689, 0.122019119560719, 0.122135318815708, 0.122251555323601, 0.122367806732655, 0.122484102845192, 0.122600391507149, 0.122716709971428, 0.122833073139191, 0.122949436306953, 0.123065829277039, 0.123182266950607, 0.123298697173595, 0.123415164649487, 0.123531684279442, 0.123648189008236, 0.123764716088772, 0.12388127297163, 0.123997867107391, 0.124114498496056, 0.12423112988472, 0.124347776174545, 0.124464467167854, 0.124581165611744, 0.124697886407375, 0.124814637005329, 0.124931424856186, 0.125048235058784, 0.125165045261383, 0.125281915068626, 0.12539878487587, 0.125515669584274, 0.12563256919384, 0.125749543309212, 0.125866487622261, 0.125983506441116, 0.126100525259972, 0.126217544078827, 0.126334592700005, 0.126451715826988, 0.126568809151649, 0.126685932278633, 0.126803115010262, 0.126920282840729, 0.127037480473518, 0.127154722809792, 0.127271980047226, 0.127389252185822, 0.127506569027901, 0.127623915672302, 0.127741262316704, 0.127858638763428, 0.127976015210152, 0.128093436360359, 0.128210872411728, 0.128328338265419, 0.128445863723755, 0.128563359379768, 0.128680884838104, 0.128798469901085, 0.128916069865227, 0.129033640027046, 0.129151299595833, 0.129268959164619, 0.12938666343689, 0.12950436770916, 0.129622086882591, 0.129739865660667, 0.129857614636421, 0.129975408315659, 0.130093261599541, 0.130211099982262, 0.130328968167305, 0.130446881055832, 0.13056480884552, 0.130682736635208, 0.13080070912838, 0.130918696522713, 0.131036728620529, 0.131154775619507, 0.131272822618484, 0.131390944123268, 0.131509035825729, 0.131627157330513, 0.13174532353878, 0.13186351954937, 0.131981715559959, 0.132099956274033, 0.132218211889267, 0.132336482405663, 0.13245478272438, 0.132573112845421, 0.132691457867622, 0.132809832692146, 0.132928222417831, 0.133046656847, 0.133165091276169, 0.133283585309982, 0.133402049541473, 0.133520573377609, 0.133639127016068, 0.133757680654526, 0.133876264095306, 0.133994877338409, 0.134113535284996, 0.134232178330421, 0.13435086607933, 0.134469553828239, 0.134588301181793, 0.134707063436508, 0.134825825691223, 0.134944632649422, 0.135063484311104, 0.135182321071625, 0.135301157832146, 0.135420098900795, 0.135539010167122, 0.135657951235771, 0.135776922106743, 0.135895937681198, 0.136014953255653, 0.136133968830109, 0.136253044009209, 0.13637213408947, 0.136491253972054, 0.13661040365696, 0.136729553341866, 0.136848747730255, 0.136967942118645, 0.137087181210518, 0.137206420302391, 0.137325704097748, 0.137445017695427, 0.137564346194267, 0.137683719396591, 0.137803092598915, 0.137922465801239, 0.138041913509369, 0.138161346316338, 0.138280808925629, 0.138400316238403, 0.138519823551178, 0.138639360666275, 0.138758927583694, 0.138878509402275, 0.138998121023178, 0.139117777347565, 0.139237433671951, 0.139357134699821, 0.139476835727692, 0.139596551656723, 0.139716312289238, 0.139836117625237, 0.139955893158913, 0.140075713396072, 0.140195578336716, 0.140315443277359, 0.140435323119164, 0.140555277466774, 0.140675202012062, 0.140795186161995, 0.140915185213089, 0.141035199165344, 0.141155242919922, 0.141275301575661, 0.141395404934883, 0.141515508294106, 0.14163564145565, 0.141755804419518, 0.141875982284546, 0.141996189951897, 0.14211642742157, 0.142236679792404, 0.1423569470644, 0.14247727394104, 0.142597585916519, 0.142717942595482, 0.142838329076767, 0.142958715558052, 0.143079161643982, 0.143199592828751, 0.143320053815842, 0.143440559506416, 0.143561080098152, 0.143681615591049, 0.14380219578743, 0.14392277598381, 0.144043400883675, 0.144164025783539, 0.144284680485725, 0.144405379891396, 0.144526094198227, 0.144646808505058, 0.144767597317696, 0.144888386130333, 0.145009145140648, 0.145130008459091, 0.145250841975212, 0.145371705293655, 0.145492628216743, 0.145613551139832, 0.145734488964081, 0.145855456590652, 0.145976454019547, 0.146097481250763, 0.146218538284302, 0.146339580416679, 0.146460697054863, 0.146581813693047, 0.14670293033123, 0.146824106574059, 0.146945282816887, 0.147066488862038, 0.147187724709511, 0.147308975458145, 0.147430256009102, 0.147551581263542, 0.147672906517982, 0.147794231772423, 0.147915631532669, 0.148037016391754, 0.148158431053162, 0.148279875516891, 0.148401349782944, 0.14852286875248, 0.148644343018532, 0.148765921592712, 0.148887485265732, 0.149009048938751, 0.149130702018738, 0.149252340197563, 0.14937399327755, 0.149495676159859, 0.149617373943329, 0.149739101529121, 0.149860888719559, 0.149982661008835, 0.150104433298111, 0.150226294994354, 0.150348141789436, 0.15047000348568, 0.150591909885406, 0.150713846087456, 0.150835782289505, 0.150957778096199, 0.151079759001732, 0.151201769709587, 0.151323810219765, 0.151445880532265, 0.151567995548248, 0.151690095663071, 0.151812225580215, 0.151934400200844, 0.152056589722633, 0.152178794145584, 0.152301028370857, 0.152423277497292, 0.152545556426048, 0.152667880058289, 0.152790203690529, 0.15291254222393, 0.153034940361977, 0.153157323598862, 0.153279766440392, 0.153402209281921, 0.153524667024612, 0.153647169470787, 0.153769701719284, 0.153892233967781, 0.154014810919762, 0.154137387871742, 0.154259994626045, 0.154382660984993, 0.15450531244278, 0.154627978801727, 0.154750719666481, 0.154873460531235, 0.15499621629715, 0.155119001865387, 0.155241772532463, 0.155364647507668, 0.155487477779388, 0.155610352754593, 0.155733242630959, 0.155856192111969, 0.155979111790657, 0.15610209107399, 0.156225100159645, 0.156348124146461, 0.156471148133278, 0.156594216823578, 0.156717330217361, 0.156840413808823, 0.156963542103767, 0.157086730003357, 0.157209903001785, 0.157333120703697, 0.157456383109093, 0.157579615712166, 0.157702893018723, 0.157826200127602, 0.157949522137642, 0.158072873950005, 0.15819625556469, 0.158319652080536, 0.158443123102188, 0.158566534519196, 0.158690005540848, 0.158813506364822, 0.158937022089958, 0.159060582518578, 0.159184172749519, 0.159307733178139, 0.159431338310242, 0.159555003046989, 0.159678652882576, 0.159802332520485, 0.159926056861877, 0.160049796104431, 0.160173565149307, 0.160297334194183, 0.160421133041382, 0.160544961690903, 0.160668805241585, 0.16079269349575, 0.160916611552238, 0.161040529608727, 0.161164462566376, 0.16128845512867, 0.161412432789803, 0.161536440253258, 0.161660522222519, 0.161784574389458, 0.161908701062202, 0.162032797932625, 0.16215692460537, 0.162281110882759, 0.162405282258987, 0.162529483437538, 0.162653729319572, 0.162777990102768, 0.162902265787125, 0.163026586174965, 0.163150921463966, 0.163275256752968, 0.163399651646614, 0.163524031639099, 0.163648471236229, 0.16377292573452, 0.163897395133972, 0.164021879434586, 0.164146423339844, 0.164270952343941, 0.164395496249199, 0.164520099759102, 0.164644733071327, 0.164769351482391, 0.164894014596939, 0.16501872241497, 0.165143415331841, 0.165268152952194, 0.16539292037487, 0.165517702698708, 0.165642485022545, 0.165767356753349, 0.165892198681831, 0.166017070412636, 0.166141971945763, 0.166266903281212, 0.166391834616661, 0.166516825556755, 0.166641816496849, 0.166766822338104, 0.166891887784004, 0.167016953229904, 0.167142063379288, 0.167266830801964, 0.167391732335091, 0.167516604065895, 0.167641490697861, 0.167766317725182, 0.167891189455986, 0.168016016483307, 0.168140813708305, 0.168265655636787, 0.168390437960625, 0.168515235185623, 0.168640002608299, 0.168764784932137, 0.168889537453651, 0.169014275074005, 0.169138997793198, 0.169263705611229, 0.16938841342926, 0.16951310634613, 0.169637814164162, 0.169762477278709, 0.169887125492096, 0.170011788606644, 0.170136421918869, 0.170261040329933, 0.170385658740997, 0.1705102622509, 0.170634850859642, 0.170759424567223, 0.170883983373642, 0.171008557081223, 0.17113308608532, 0.171257600188255, 0.171382158994675, 0.171506643295288, 0.171631142497063, 0.171755656599998, 0.171880096197128, 0.172004550695419, 0.172129020094872, 0.172253459692001, 0.172377914190292, 0.1725023239851, 0.172626703977585, 0.172751098871231, 0.172875463962555, 0.17299984395504, 0.173124209046364, 0.173248559236526, 0.173372894525528, 0.173497200012207, 0.173621520400047, 0.173745810985565, 0.173870116472244, 0.173994392156601, 0.174118652939796, 0.174242913722992, 0.174367159605026, 0.174491375684738, 0.17461559176445, 0.174739792943001, 0.174864009022713, 0.17498816549778, 0.175112351775169, 0.175236523151398, 0.175360664725304, 0.175484791398048, 0.175608932971954, 0.175733044743538, 0.175857126712799, 0.175981238484383, 0.176105320453644, 0.176229387521744, 0.176353424787521, 0.176477462053299, 0.176601514220238, 0.176725521683693, 0.176849544048309, 0.176973536610603, 0.177097544074059, 0.177221491932869, 0.177345469594002, 0.177469417452812, 0.177593350410461, 0.177717298269272, 0.177841201424599, 0.177965104579926, 0.178089007735252, 0.178212866187096, 0.178336769342422, 0.178460627794266, 0.178584441542625, 0.178708299994469, 0.17883212864399, 0.178955927491188, 0.179079726338387, 0.179203495383263, 0.1793272793293, 0.179451063275337, 0.179574802517891, 0.179698571562767, 0.179822281002998, 0.179946020245552, 0.180069714784622, 0.180193409323692, 0.180317059159279, 0.18044076859951, 0.180564418435097, 0.180688083171844, 0.180811733007431, 0.180935308337212, 0.181058928370476, 0.181182533502579, 0.181306153535843, 0.181429728865623, 0.181553304195404, 0.181676834821701, 0.181800380349159, 0.181923910975456, 0.182047441601753, 0.182170957326889, 0.182294428348541, 0.182417929172516, 0.182541415095329, 0.18266487121582, 0.182788327336311, 0.182911783456802, 0.18303519487381, 0.183158621191978, 0.183282017707825, 0.183405414223671, 0.183528795838356, 0.183652177453041, 0.183775499463081, 0.183898881077766, 0.184022203087807, 0.184145539999008, 0.184268847107887, 0.184392139315605, 0.184515431523323, 0.184638693928719, 0.184761971235275, 0.184885233640671, 0.185008481144905, 0.185131698846817, 0.18525493144989, 0.18537811934948, 0.18550132215023, 0.185624524950981, 0.185747683048248, 0.185870841145515, 0.185993999242783, 0.186117127537727, 0.186240240931511, 0.186363369226456, 0.186486467719078, 0.1866095662117, 0.186732649803162, 0.1868557035923, 0.186978787183762, 0.187101811170578, 0.187224864959717, 0.187347859144211, 0.187470868229866, 0.187593877315521, 0.187716871500015, 0.187839835882187, 0.187962800264359, 0.18808576464653, 0.188208699226379, 0.188331663608551, 0.188454568386078, 0.188577458262444, 0.188700348138809, 0.188823223114014, 0.188946112990379, 0.189068973064423, 0.189191818237305, 0.189314633607864, 0.189437478780746, 0.189560279250145, 0.189683079719543, 0.189805880188942, 0.189928650856018, 0.190051451325417, 0.190174162387848, 0.19029688835144, 0.190419659018517, 0.190542370080948, 0.190665081143379, 0.190787792205811, 0.190910458564758, 0.191033124923706, 0.191155806183815, 0.19127844274044, 0.191401079297066, 0.19152370095253, 0.191646307706833, 0.191768959164619, 0.1918915361166, 0.192014113068581, 0.192136690020561, 0.192259222269058, 0.192381769418716, 0.192504316568375, 0.192626848816872, 0.192749321460724, 0.19287183880806, 0.192994311451912, 0.193116784095764, 0.193239271640778, 0.193361699581146, 0.193484172224998, 0.193606585264206, 0.193728998303413, 0.19385139644146, 0.193973809480667, 0.194096192717552, 0.194218561053276, 0.194340929389, 0.194463267922401, 0.194585636258125, 0.194707930088043, 0.194830223917961, 0.194952562451363, 0.195074826478958, 0.195197120308876, 0.195319384336472, 0.195441618561745, 0.195563897490501, 0.195686116814613, 0.195808336138725, 0.195930540561676, 0.196052730083466, 0.196174919605255, 0.196297109127045, 0.196419268846512, 0.196541413664818, 0.196663558483124, 0.196785673499107, 0.196907803416252, 0.197029888629913, 0.197152003645897, 0.197274103760719, 0.197396174073219, 0.197518199682236, 0.197640269994736, 0.197762250900269, 0.197884306311607, 0.198006331920624, 0.198128297924995, 0.198250278830528, 0.198372274637222, 0.198494255542755, 0.198616206645966, 0.198738142848015, 0.198860049247742, 0.198982000350952, 0.199103906750679, 0.199225783348083, 0.199347674846649, 0.199469536542892, 0.199591398239136, 0.199713259935379, 0.1998350918293, 0.19995690882206, 0.200078725814819, 0.200200513005257, 0.200322344899178, 0.200444102287292, 0.200565859675407, 0.200687646865845, 0.200809389352798, 0.200931087136269, 0.201052829623222, 0.201174527406693, 0.201296240091324, 0.201417937874794, 0.201539590954781, 0.201661258935928, 0.201782912015915, 0.201904535293579, 0.202026158571243, 0.202147781848907, 0.20226939022541, 0.202390998601913, 0.202512547373772, 0.202634125947952, 0.202755704522133, 0.202877253293991, 0.202998772263527, 0.203120306134224, 0.20324182510376, 0.203363299369812, 0.203484818339348, 0.203606277704239, 0.20372773706913, 0.20384918153286, 0.20397062599659, 0.204092055559158, 0.204213470220566, 0.204334884881973, 0.204456314444542, 0.204577684402466, 0.20469905436039, 0.204820439219475, 0.204941764473915, 0.205063104629517, 0.205184429883957, 0.205305725336075, 0.205427020788193, 0.205548316240311, 0.205669596791267, 0.205790862441063, 0.205912113189697, 0.206033363938332, 0.206154629588127, 0.206275835633278, 0.206397041678429, 0.206518232822418, 0.206639423966408, 0.206760600209236, 0.206881776452065, 0.207002907991409, 0.207124039530754, 0.20724518597126, 0.207366302609444, 0.207487404346466, 0.207608476281166, 0.207729563117027, 0.207850649952888, 0.207971706986427, 0.208092749118805, 0.208213806152344, 0.208334818482399, 0.208455815911293, 0.208576828241348, 0.208697825670242, 0.208818793296814, 0.208939775824547, 0.209060698747635, 0.209181651473045, 0.209302589297295, 0.20942348241806, 0.209544405341148, 0.209665313363075, 0.209786176681519, 0.209907069802284, 0.210027933120728, 0.210148766636848, 0.210269600152969, 0.21039043366909, 0.21051125228405, 0.210632055997849, 0.210752844810486, 0.210873633623123, 0.210994407534599, 0.211115151643753, 0.211235925555229, 0.211356639862061, 0.211477369070053, 0.211598098278046, 0.211718767881393, 0.211839452385902, 0.211960136890411, 0.212080776691437, 0.212201416492462, 0.212322100996971, 0.212442710995674, 0.2125633507967, 0.212683945894241, 0.212804526090622, 0.212925106287003, 0.213045671582222, 0.213166236877441, 0.2132867872715, 0.213407307863235, 0.213527828454971, 0.213648393750191, 0.213768869638443, 0.213889345526695, 0.214009821414948, 0.214130312204361, 0.21425074338913, 0.214371204376221, 0.214491620659828, 0.214612051844597, 0.214732453227043, 0.214852854609489, 0.214973255991936, 0.215093612670898, 0.215213969349861, 0.215334340929985, 0.215454682707787, 0.215574994683266, 0.215695306658745, 0.215815603733063, 0.215935900807381, 0.216056168079376, 0.216176450252533, 0.21629673242569, 0.21641694009304, 0.216537177562714, 0.216657415032387, 0.216777622699738, 0.216897815465927, 0.217018008232117, 0.217138186097145, 0.217258334159851, 0.217378512024879, 0.217498645186424, 0.217618778347969, 0.217738881707191, 0.217858999967575, 0.217979103326797, 0.218099176883698, 0.218219250440598, 0.218339279294014, 0.218459352850914, 0.21857938170433, 0.218699410557747, 0.218819454312325, 0.218939393758774, 0.21905942261219, 0.219179376959801, 0.219299361109734, 0.219419315457344, 0.219539269804955, 0.219659209251404, 0.219779118895531, 0.219899013638496, 0.220018938183784, 0.220138803124428, 0.220258668065071, 0.220378547906876, 0.220498412847519, 0.220618233084679, 0.220738068223, 0.220857873558998, 0.220977678894997, 0.221097469329834, 0.22121724486351, 0.221337035298347, 0.221456781029701, 0.221576526761055, 0.221696272492409, 0.221815973520279, 0.221935674548149, 0.22205539047718, 0.222175091505051, 0.222294747829437, 0.222414419054985, 0.222534075379372, 0.222653731703758, 0.2227733284235, 0.222892954945564, 0.223012581467628, 0.22313217818737, 0.22325174510479, 0.22337132692337, 0.223490908741951, 0.223610430955887, 0.223729968070984, 0.22384949028492, 0.223968997597694, 0.22408851981163, 0.224207997322083, 0.224327489733696, 0.224446952342987, 0.224566400051117, 0.224685832858086, 0.224805280566216, 0.224924668669701, 0.225044116377831, 0.225163519382477, 0.225282892584801, 0.225402265787125, 0.225521624088287, 0.225640967488289, 0.225760325789452, 0.225879639387131, 0.22599895298481, 0.22611828148365, 0.226237550377846, 0.226356849074364, 0.226476103067398, 0.226595371961594, 0.226714625954628, 0.226833835244179, 0.226953059434891, 0.227072283625603, 0.227191478013992, 0.227310657501221, 0.227429836988449, 0.227549016475677, 0.227668166160583, 0.22778731584549, 0.227906450629234, 0.228025570511818, 0.228144660592079, 0.228263527154922, 0.228382647037506, 0.228501662611961, 0.228620648384094, 0.228739604353905, 0.228858515620232, 0.228977352380753, 0.229096159338951, 0.229214906692505, 0.229333594441414, 0.229452311992645, 0.229570910334587, 0.229689493775368, 0.229808002710342, 0.229926481842995, 0.230044916272163, 0.23016332089901, 0.230281636118889, 0.230399966239929, 0.230518206954002, 0.230636402964592, 0.230754569172859, 0.230872675776482, 0.23099073767662, 0.231108754873276, 0.231226727366447, 0.231344670057297, 0.231462508440018, 0.231580346822739, 0.231698155403137, 0.23181588947773, 0.231933578848839, 0.232051223516464, 0.232168823480606, 0.232286363840103, 0.232403889298439, 0.232521340250969, 0.232638746500015, 0.232756122946739, 0.232873469591141, 0.232990726828575, 0.233107939362526, 0.233225122094154, 0.233342260122299, 0.23345935344696, 0.233576416969299, 0.233693405985832, 0.233810365200043, 0.233927264809608, 0.234044104814529, 0.234160929918289, 0.234277695417404, 0.234394431114197, 0.234511107206345, 0.234627723693848, 0.234744295477867, 0.234860837459564, 0.234977349638939, 0.235093772411346, 0.23521015048027, 0.235326513648033, 0.235442817211151, 0.235559061169624, 0.235675305128098, 0.235791444778442, 0.235907554626465, 0.236023634672165, 0.23613965511322, 0.236255630850792, 0.236371546983719, 0.236487448215485, 0.236603304743767, 0.236719086766243, 0.236834838986397, 0.236950516700745, 0.237066179513931, 0.237181797623634, 0.237297371029854, 0.237412855029106, 0.237528339028358, 0.237643763422966, 0.237759113311768, 0.237874463200569, 0.237989723682404, 0.238104984164238, 0.238220170140266, 0.238335311412811, 0.238450407981873, 0.238565474748611, 0.238680467009544, 0.238795429468155, 0.238910317420959, 0.239025205373764, 0.239140033721924, 0.2392548173666, 0.239369541406631, 0.239484190940857, 0.239598855376244, 0.239713415503502, 0.23982797563076, 0.239942476153374, 0.240056931972504, 0.240171298384666, 0.24028567969799, 0.240399986505508, 0.240514263510704, 0.240628480911255, 0.240742638707161, 0.240856766700745, 0.240970849990845, 0.2410848736763, 0.241198867559433, 0.241312816739082, 0.241426691412926, 0.241540521383286, 0.241654351353645, 0.241768077015877, 0.241881802678108, 0.241995468735695, 0.242109060287476, 0.242222651839256, 0.242336168885231, 0.242449641227722, 0.24256306886673, 0.242676451802254, 0.242789804935455, 0.24290306866169, 0.243016317486763, 0.243129521608353, 0.243242666125298, 0.24335578083992, 0.243468835949898, 0.243581861257553, 0.243694797158241, 0.243807747960091, 0.243920609354973, 0.244033440947533, 0.244146227836609, 0.244258940219879, 0.244371637701988, 0.244484275579453, 0.244596868753433, 0.24470941722393, 0.244821935892105, 0.244934394955635, 0.24504679441452, 0.245159164071083, 0.24527145922184, 0.245383754372597, 0.245495975017548, 0.245608165860176, 0.24572029709816, 0.24583238363266, 0.245944425463676, 0.246056392788887, 0.246168345212936, 0.246280238032341, 0.246392115950584, 0.246503919363022, 0.246615678071976, 0.246727392077446, 0.246839076280594, 0.246950671076775, 0.247062265872955, 0.24717378616333, 0.24728524684906, 0.24739670753479, 0.247508093714714, 0.247619450092316, 0.247730746865273, 0.247841969132423, 0.247953206300735, 0.24806435406208, 0.248175457119942, 0.248286530375481, 0.248397558927536, 0.248508542776108, 0.248619437217712, 0.248730346560478, 0.248841166496277, 0.248951956629753, 0.249062716960907, 0.249173387885094, 0.24928405880928, 0.249394670128822, 0.249505206942558, 0.249615699052811, 0.249726176261902, 0.249836593866348, 0.249946966767311, 0.250057280063629, 0.250167578458786, 0.250277817249298, 0.250387966632843, 0.25049814581871, 0.250608205795288, 0.250718235969543, 0.250828266143799, 0.250938206911087, 0.251048117876053, 0.251157969236374, 0.251267790794373, 0.251377582550049, 0.25148731470108, 0.251596987247467, 0.251706600189209, 0.251816183328629, 0.251925736665726, 0.252035230398178, 0.252144664525986, 0.252254068851471, 0.252363413572311, 0.252472698688507, 0.25258195400238, 0.252691179513931, 0.252800345420837, 0.252909451723099, 0.25301855802536, 0.253127574920654, 0.253236562013626, 0.253345489501953, 0.253454357385635, 0.253563225269318, 0.253672003746033, 0.253780752420425, 0.253889471292496, 0.253998130559921, 0.254106730222702, 0.25421530008316, 0.254323810338974, 0.254432290792465, 0.254540711641312, 0.254649102687836, 0.254757404327393, 0.254865676164627, 0.254973948001862, 0.255082160234451, 0.255190283060074, 0.255298376083374, 0.255406439304352, 0.255514442920685, 0.255622416734695, 0.255730301141739, 0.255838185548782, 0.255946010351181, 0.256053775548935, 0.256161540746689, 0.256269186735153, 0.256376832723618, 0.256484419107437, 0.256591975688934, 0.256699472665787, 0.256806910037994, 0.25691431760788, 0.257021695375443, 0.257128983736038, 0.257236272096634, 0.257343471050262, 0.257450670003891, 0.257557779550552, 0.257664859294891, 0.257771879434586, 0.25787889957428, 0.257985830307007, 0.258092731237411, 0.258199572563171, 0.258306384086609, 0.258413136005402, 0.258519858121872, 0.258626520633698, 0.258733093738556, 0.258839696645737, 0.25894621014595, 0.259052693843842, 0.259159117937088, 0.259265512228012, 0.259371876716614, 0.259478151798248, 0.25958439707756, 0.25969061255455, 0.259796738624573, 0.259902864694595, 0.260008901357651, 0.260114938020706, 0.260220915079117, 0.260326832532883, 0.260432720184326, 0.260538548231125, 0.260644316673279, 0.26075005531311, 0.260855734348297, 0.260961383581161, 0.261067003011703, 0.261172562837601, 0.261278033256531, 0.261383503675461, 0.261488914489746, 0.261594295501709, 0.261699616909027, 0.2618048787117, 0.261910080909729, 0.262015283107758, 0.262120395898819, 0.26222550868988, 0.262330532073975, 0.262435525655746, 0.262540489435196, 0.262645393610001, 0.262750267982483, 0.262855052947998, 0.262959837913513, 0.263064533472061, 0.263169229030609, 0.26327383518219, 0.263378411531448, 0.263482958078384, 0.263587445020676, 0.263691902160645, 0.263796269893646, 0.263900607824326, 0.264004915952682, 0.264109164476395, 0.264213383197784, 0.264317542314529, 0.26442164182663, 0.26452574133873, 0.264629751443863, 0.264733701944351, 0.264837652444839, 0.264941543340683, 0.265045404434204, 0.265149176120758, 0.265252888202667, 0.265356600284576, 0.265460252761841, 0.265563875436783, 0.26566743850708, 0.265770941972733, 0.265874415636063, 0.265977829694748, 0.266081184148788, 0.266184508800507, 0.266287803649902, 0.266391038894653, 0.266494244337082, 0.266597390174866, 0.266700476408005, 0.266803532838821, 0.266906529664993, 0.26700946688652, 0.267112404108047, 0.267215251922607, 0.267318069934845, 0.267420828342438, 0.267523556947708, 0.267626225948334, 0.267728894948959, 0.267831444740295, 0.267933994531631, 0.268036514520645, 0.268138945102692, 0.268241316080093, 0.268343687057495, 0.268446028232574, 0.268548250198364, 0.268650472164154, 0.268752664327621, 0.268854767084122, 0.2689568400383, 0.269058883190155, 0.269160866737366, 0.269262790679932, 0.269364655017853, 0.269466549158096, 0.26956832408905, 0.269670069217682, 0.269771784543991, 0.269873440265656, 0.269975036382675, 0.270076602697372, 0.270178139209747, 0.270279586315155, 0.270381063222885, 0.270482420921326, 0.270583748817444, 0.27068504691124, 0.270786285400391, 0.270887464284897, 0.270988643169403, 0.271089732646942, 0.271190792322159, 0.271291822195053, 0.27139276266098, 0.271493673324585, 0.271594554185867, 0.271695405244827, 0.27179616689682, 0.27189689874649, 0.271997600793839, 0.272098243236542, 0.2721988260746, 0.272299349308014, 0.272399842739105, 0.272500336170197, 0.272600710391998, 0.2727010846138, 0.272801399230957, 0.272901684045792, 0.273001879453659, 0.273102045059204, 0.273202210664749, 0.273302286863327, 0.27340230345726, 0.273502290248871, 0.273602247238159, 0.273702144622803, 0.273801982402802, 0.273901790380478, 0.274001568555832, 0.274101257324219, 0.274200916290283, 0.274300575256348, 0.274400115013123, 0.274499654769897, 0.274599134922028, 0.274698585271835, 0.274797976016998, 0.274897307157516, 0.274996608495712, 0.275095850229263, 0.275195062160492, 0.275294214487076, 0.275393337011337, 0.275492370128632, 0.275591403245926, 0.275690406560898, 0.275789320468903, 0.275888174772263, 0.2759869992733, 0.276085793972015, 0.276184558868408, 0.276283204555511, 0.276381880044937, 0.276480495929718, 0.276579022407532, 0.276677548885345, 0.276776015758514, 0.276874423027039, 0.27697280049324, 0.277071118354797, 0.27716937661171, 0.277267605066299, 0.277365803718567, 0.27746394276619, 0.277562022209167, 0.277660071849823, 0.277758061885834, 0.277856051921844, 0.277953952550888, 0.278051793575287, 0.278149604797363, 0.278247386217117, 0.278345078229904, 0.278442770242691, 0.278540402650833, 0.27863797545433, 0.278735518455505, 0.278833001852036, 0.278930455446243, 0.279027819633484, 0.279125183820724, 0.27922248840332, 0.279319763183594, 0.279416978359222, 0.279514104127884, 0.279611229896545, 0.279708296060562, 0.279805332422256, 0.279902309179306, 0.279999226331711, 0.280096113681793, 0.280192971229553, 0.280289769172668, 0.280386507511139, 0.280483216047287, 0.28057986497879, 0.280676484107971, 0.280773043632507, 0.280869543552399, 0.280966013669968, 0.281062424182892, 0.281158804893494, 0.281255155801773, 0.281351417303085, 0.281447678804398, 0.281543850898743, 0.281640022993088, 0.281736105680466, 0.281832158565521, 0.281928151845932, 0.282024055719376, 0.282119691371918, 0.282215237617493, 0.282310724258423, 0.282406121492386, 0.282501429319382, 0.282596677541733, 0.282691806554794, 0.282786905765533, 0.282881885766983, 0.282976806163788, 0.283071637153625, 0.283166408538818, 0.283261060714722, 0.28335565328598, 0.283450186252594, 0.283544600009918, 0.283638954162598, 0.28373321890831, 0.2838274538517, 0.283921539783478, 0.284015566110611, 0.284109532833099, 0.284203410148621, 0.284297198057175, 0.284390896558762, 0.284484535455704, 0.284578084945679, 0.284671545028687, 0.284764915704727, 0.284858256578445, 0.284951478242874, 0.285044640302658, 0.285137683153152, 0.285230696201324, 0.285323590040207, 0.285416424274445, 0.285509169101715, 0.285601824522018, 0.285694420337677, 0.285786956548691, 0.285879343748093, 0.285971701145172, 0.286063969135284, 0.28615614771843, 0.28624826669693, 0.286340296268463, 0.286432236433029, 0.28652411699295, 0.286615878343582, 0.286707580089569, 0.286799222230911, 0.286890774965286, 0.286982238292694, 0.287073612213135, 0.287164926528931, 0.287256151437759, 0.287347286939621, 0.287438333034515, 0.287529349327087, 0.287620216608047, 0.287711054086685, 0.287801802158356, 0.287892460823059, 0.287983030080795, 0.288073569536209, 0.288163959980011, 0.288254290819168, 0.288344591856003, 0.288434743881226, 0.288524866104126, 0.288614869117737, 0.288704812526703, 0.288794666528702, 0.288884460926056, 0.288974165916443, 0.289063781499863, 0.289153307676315, 0.289242774248123, 0.289332181215286, 0.289421439170837, 0.289510667324066, 0.289599776268005, 0.289688885211945, 0.289777845144272, 0.289866715669632, 0.28995555639267, 0.290044277906418, 0.290132939815521, 0.290221512317657, 0.290310025215149, 0.290398418903351, 0.29048678278923, 0.290574997663498, 0.290663182735443, 0.290751308202744, 0.290839314460754, 0.290927231311798, 0.291015088558197, 0.291102886199951, 0.291190564632416, 0.291278153657913, 0.291365712881088, 0.291453152894974, 0.291540563106537, 0.29162785410881, 0.291715055704117, 0.291802167892456, 0.291889220476151, 0.291976183652878, 0.29206308722496, 0.292149901390076, 0.292236626148224, 0.292323291301727, 0.292409867048264, 0.29249632358551, 0.292582750320435, 0.292669117450714, 0.292755335569382, 0.292841494083405, 0.292927592992783, 0.293013602495193, 0.293099522590637, 0.293185383081436, 0.293271124362946, 0.293356835842133, 0.29344242811203, 0.293527990579605, 0.293613433837891, 0.293698787689209, 0.29378405213356, 0.293869286775589, 0.293954402208328, 0.294039458036423, 0.294124394655228, 0.29420930147171, 0.294294118881226, 0.294378846883774, 0.294463485479355, 0.294548034667969, 0.29463255405426, 0.29471692442894, 0.294801265001297, 0.294885486364365, 0.294969648122787, 0.295053750276566, 0.295137763023376, 0.29522168636322, 0.295305520296097, 0.295389264822006, 0.295472949743271, 0.295556575059891, 0.295640081167221, 0.295723527669907, 0.295806884765625, 0.295890182256699, 0.295973360538483, 0.296056479215622, 0.296139538288116, 0.296222507953644, 0.296305388212204, 0.296388179063797, 0.296470880508423, 0.296553552150726, 0.296636074781418, 0.296718567609787, 0.296800971031189, 0.296883285045624, 0.296965509653091, 0.297047674655914, 0.29712975025177, 0.297211766242981, 0.297293663024902, 0.297375530004501, 0.297457247972488, 0.297538936138153, 0.297620564699173, 0.297702074050903, 0.297783493995667, 0.297864854335785, 0.297946125268936, 0.29802730679512, 0.29810842871666, 0.298189491033554, 0.298270404338837, 0.298351287841797, 0.29843208193779, 0.298512786626816, 0.298593461513519, 0.298673987388611, 0.298754453659058, 0.29883486032486, 0.298915177583694, 0.298995405435562, 0.299075543880463, 0.299155622720718, 0.299235612154007, 0.299315541982651, 0.299395352602005, 0.299475133419037, 0.299554795026779, 0.299634397029877, 0.299713879823685, 0.29979333281517, 0.299872666597366, 0.299951940774918, 0.300031125545502, 0.300110220909119, 0.300189286470413, 0.300268203020096, 0.300347089767456, 0.300425887107849, 0.300504595041275, 0.300583213567734, 0.300661742687225, 0.300740212202072, 0.300818592309952, 0.300896912813187, 0.300975143909454, 0.301053285598755, 0.301131337881088, 0.301209330558777, 0.301287233829498, 0.301365077495575, 0.301442801952362, 0.301520496606827, 0.301598072052002, 0.30167555809021, 0.301752984523773, 0.301830351352692, 0.301907598972321, 0.301984757184982, 0.302061885595322, 0.302138894796371, 0.302215874195099, 0.302292704582214, 0.302369505167007, 0.302446186542511, 0.302522838115692, 0.302599370479584, 0.302675813436508, 0.30275222659111, 0.302828520536423, 0.302904725074768, 0.302980870008469, 0.303056925535202, 0.303132921457291, 0.30320879817009, 0.303284645080566, 0.303360372781754, 0.303436040878296, 0.303511589765549, 0.303587108850479, 0.303662538528442, 0.303737848997116, 0.303813129663467, 0.303888320922852, 0.303963392972946, 0.304038405418396, 0.304113358259201, 0.304188221693039, 0.30426299571991, 0.304337710142136, 0.304412305355072, 0.304486840963364, 0.304561287164688, 0.304635673761368, 0.30470997095108, 0.304784178733826, 0.304858326911926, 0.304932355880737, 0.305006355047226, 0.305080235004425, 0.305154055356979, 0.305227786302567, 0.305301457643509, 0.305375009775162, 0.30544850230217, 0.305521935224533, 0.305595248937607, 0.305668532848358, 0.30574169754982, 0.305814743041992, 0.305887788534164, 0.305960714817047, 0.306033551692963, 0.306106358766556, 0.306179046630859, 0.306251645088196, 0.306324154138565, 0.30639660358429, 0.306468993425369, 0.306541264057159, 0.306613475084305, 0.306685596704483, 0.306757688522339, 0.306829631328583, 0.306901514530182, 0.306973338127136, 0.307045042514801, 0.307116717100143, 0.307188242673874, 0.307259768247604, 0.307331174612045, 0.307402491569519, 0.307473748922348, 0.30754491686821, 0.307615995407104, 0.307686984539032, 0.307757943868637, 0.30782875418663, 0.307899534702301, 0.307970196008682, 0.308040827512741, 0.30811133980751, 0.308181792497635, 0.308252155780792, 0.308322429656982, 0.308392643928528, 0.308462768793106, 0.308532804250717, 0.308602780103683, 0.308672666549683, 0.308742463588715, 0.308812171220779, 0.308881819248199, 0.308951407670975, 0.30902087688446, 0.309090286493301, 0.309159606695175, 0.309228837490082, 0.309298008680344, 0.309367060661316, 0.309436082839966, 0.309504985809326, 0.309573829174042, 0.309642612934113, 0.309711277484894, 0.30977988243103, 0.3098483979702, 0.309916824102402, 0.309985190629959, 0.310053467750549, 0.310121685266495, 0.310189783573151, 0.310257822275162, 0.310325771570206, 0.310393661260605, 0.310461461544037, 0.310529172420502, 0.310596793889999, 0.310664355754852, 0.310731828212738, 0.310799241065979, 0.31086653470993, 0.310933768749237, 0.311000943183899, 0.311067998409271, 0.311134994029999, 0.311201930046082, 0.311268776655197, 0.311335504055023, 0.311402171850204, 0.311468780040741, 0.31153529882431, 0.311601728200912, 0.311668068170547, 0.311734348535538, 0.311800539493561, 0.311866641044617, 0.311932682991028, 0.311998635530472, 0.312064498662949, 0.312130302190781, 0.312196016311646, 0.312261641025543, 0.312327176332474, 0.31239265203476, 0.312458068132401, 0.31252333521843, 0.312588572502136, 0.312653750181198, 0.312718778848648, 0.312783807516098, 0.312848716974258, 0.312913537025452, 0.312978297472, 0.313042938709259, 0.313107520341873, 0.31317201256752, 0.313236474990845, 0.31330081820488, 0.31336510181427, 0.313429266214371, 0.313493371009827, 0.313557386398315, 0.313621342182159, 0.313685208559036, 0.313748985528946, 0.313812732696533, 0.313876330852509, 0.313939869403839, 0.314003348350525, 0.314066708087921, 0.314130038022995, 0.314193248748779, 0.314256399869919, 0.314319431781769, 0.314382433891296, 0.314445346593857, 0.31450816988945, 0.314570903778076, 0.314633578062057, 0.314696162939072, 0.314758658409119, 0.314821094274521, 0.314883410930634, 0.314945667982101, 0.315007835626602, 0.315069943666458, 0.315131962299347, 0.315193921327591, 0.315255761146545, 0.315317541360855, 0.31537926197052, 0.315440863370895, 0.315502405166626, 0.315563887357712, 0.315625250339508, 0.315686523914337, 0.315747767686844, 0.315808922052383, 0.315869957208633, 0.315930932760239, 0.315991818904877, 0.31605264544487, 0.316113382577896, 0.316174060106277, 0.316234648227692, 0.316295117139816, 0.316355526447296, 0.316415876150131, 0.316476136445999, 0.3165363073349, 0.316596388816833, 0.316656410694122, 0.316716343164444, 0.316776216030121, 0.316835969686508, 0.316895663738251, 0.316955268383026, 0.317014813423157, 0.317074298858643, 0.317133635282516, 0.317192941904068, 0.31725212931633, 0.317311257123947, 0.31737032532692, 0.317429304122925, 0.317488163709641, 0.317546993494034, 0.31760573387146, 0.317664384841919, 0.317722946405411, 0.317781418561935, 0.317839831113815, 0.317898154258728, 0.317956417798996, 0.318014591932297, 0.31807267665863, 0.318130671977997, 0.318188607692719, 0.318246483802795, 0.318304240703583, 0.318361937999725, 0.318419545888901, 0.318477064371109, 0.318534523248672, 0.318591892719269, 0.318649172782898, 0.31870636343956, 0.3187635242939, 0.31882056593895, 0.318877518177032, 0.318934381008148, 0.318991184234619, 0.319047927856445, 0.319104582071304, 0.319161117076874, 0.319217592477798, 0.319274038076401, 0.319330334663391, 0.319386601448059, 0.319442749023438, 0.319498836994171, 0.319554835557938, 0.319610774517059, 0.319666594266891, 0.319722384214401, 0.319778054952621, 0.319832354784012, 0.319885194301605, 0.319937914609909, 0.319990575313568, 0.320043087005615, 0.320095539093018, 0.32014787197113, 0.320200085639954, 0.32025220990181, 0.320304214954376, 0.320356130599976, 0.320407956838608, 0.32045966386795, 0.320511281490326, 0.320562779903412, 0.320614218711853, 0.320665508508682, 0.320716708898544, 0.320767790079117, 0.320818781852722, 0.32086968421936, 0.320920467376709, 0.32097116112709, 0.321021765470505, 0.321072220802307, 0.321122616529465, 0.321172922849655, 0.321223080158234, 0.321273148059845, 0.321323096752167, 0.321372985839844, 0.321422755718231, 0.321472406387329, 0.32152196764946, 0.321571439504623, 0.321620792150497, 0.321670055389404, 0.321719199419022, 0.321768224239349, 0.321817189455032, 0.321866005659103, 0.32191476225853, 0.321963399648666, 0.322011917829514, 0.322060376405716, 0.322108715772629, 0.322156935930252, 0.322205036878586, 0.322253078222275, 0.322301000356674, 0.322348833084106, 0.322396546602249, 0.322444140911102, 0.322491645812988, 0.322539061307907, 0.322586357593536, 0.322633564472198, 0.322680681943893, 0.322727650403976, 0.322774559259415, 0.322821348905563, 0.322868049144745, 0.322914630174637, 0.322961121797562, 0.323007524013519, 0.323053777217865, 0.323099970817566, 0.323146045207977, 0.323192030191422, 0.323237866163254, 0.323283642530441, 0.323329299688339, 0.32337486743927, 0.323420345783234, 0.323465704917908, 0.323510944843292, 0.32355609536171, 0.32360115647316, 0.32364609837532, 0.323690950870514, 0.32373571395874, 0.323780328035355, 0.323824852705002, 0.323869287967682, 0.323913633823395, 0.323957890272141, 0.324001997709274, 0.324046015739441, 0.324089914560318, 0.32413375377655, 0.324177473783493, 0.324221074581146, 0.324264585971832, 0.324308007955551, 0.32435131072998, 0.324394524097443, 0.324437618255615, 0.324480623006821, 0.324523508548737, 0.324566304683685, 0.324609011411667, 0.324651569128036, 0.324694097042084, 0.324736475944519, 0.324778735637665, 0.324820935726166, 0.324862986803055, 0.324904978275299, 0.324946850538254, 0.324988603591919, 0.325030297040939, 0.325071841478348, 0.325113296508789, 0.325154691934586, 0.32519593834877, 0.325237095355988, 0.325278133153915, 0.325319081544876, 0.325359910726547, 0.325400680303574, 0.325441300868988, 0.325481861829758, 0.325522303581238, 0.325562626123428, 0.325602859258652, 0.325643002986908, 0.325682997703552, 0.325722932815552, 0.325762748718262, 0.325802475214005, 0.32584211230278, 0.325881600379944, 0.325921028852463, 0.325960338115692, 0.325999528169632, 0.326038658618927, 0.32607764005661, 0.326116532087326, 0.326155334711075, 0.326194018125534, 0.326232641935349, 0.326271116733551, 0.326309502124786, 0.326347768306732, 0.326385945081711, 0.326424032449722, 0.326462030410767, 0.326499879360199, 0.326537638902664, 0.326575338840485, 0.326612889766693, 0.326650351285934, 0.326687723398209, 0.326724976301193, 0.326762139797211, 0.326799184083939, 0.326836138963699, 0.326873004436493, 0.326909750699997, 0.326946377754211, 0.326982915401459, 0.327019363641739, 0.327055692672729, 0.327091902494431, 0.327128052711487, 0.327164083719254, 0.327199995517731, 0.327235847711563, 0.327271550893784, 0.327307164669037, 0.327342689037323, 0.32737809419632, 0.327413409948349, 0.327448636293411, 0.327483713626862, 0.327518731355667, 0.327553629875183, 0.327588438987732, 0.327623128890991, 0.327657729387283, 0.327692180871964, 0.327726572751999, 0.327760875225067, 0.327795058488846, 0.327829152345657, 0.327863126993179, 0.327897012233734, 0.327930778264999, 0.327964425086975, 0.327998012304306, 0.328031450510025, 0.328064829111099, 0.328098088502884, 0.328131258487701, 0.328164309263229, 0.328197240829468, 0.328230142593384, 0.328262835741043, 0.328295528888702, 0.328328043222427, 0.328360497951508, 0.328392833471298, 0.328425079584122, 0.328457206487656, 0.3284892141819, 0.3285211622715, 0.32855299115181, 0.32858470082283, 0.328616321086884, 0.328647822141647, 0.328679233789444, 0.328710585832596, 0.328741788864136, 0.328772872686386, 0.328803896903992, 0.328834772109985, 0.328865617513657, 0.328896284103394, 0.328926891088486, 0.328957349061966, 0.328987747430801, 0.32901805639267, 0.329048216342926, 0.329078316688538, 0.329108327627182, 0.329138189554214, 0.329167932271957, 0.329197615385056, 0.329227209091187, 0.329256653785706, 0.32928603887558, 0.329315304756165, 0.32934445142746, 0.329373508691788, 0.329402446746826, 0.32943132519722, 0.329460054636002, 0.329488694667816, 0.329517245292664, 0.329545706510544, 0.329574048519135, 0.329602271318436, 0.32963040471077, 0.329658448696136, 0.329686373472214, 0.329714208841324, 0.329741925001144, 0.329769551753998, 0.329797059297562, 0.329824477434158, 0.329851806163788, 0.329879015684128, 0.329906105995178, 0.329933136701584, 0.329960018396378, 0.329986840486526, 0.330013513565063, 0.330040127038956, 0.330066621303558, 0.330092996358871, 0.330119282007217, 0.330145478248596, 0.330171555280685, 0.330197542905807, 0.330223441123962, 0.330249220132828, 0.330274879932404, 0.330300450325012, 0.330325931310654, 0.330351293087006, 0.33037656545639, 0.330401718616486, 0.330426782369614, 0.330451726913452, 0.330476582050323, 0.330501347780228, 0.330525994300842, 0.330550521612167, 0.330574959516525, 0.330599337816238, 0.330623537302017, 0.330647677183151, 0.330671727657318, 0.330695658922195, 0.330719470977783, 0.330743223428726, 0.330766826868057, 0.330790340900421, 0.33081379532814, 0.330837100744247, 0.330860316753387, 0.33088344335556, 0.330906420946121, 0.330929338932037, 0.330952167510986, 0.330974847078323, 0.330997437238693, 0.331019937992096, 0.331042319536209, 0.331064611673355, 0.331086814403534, 0.331108897924423, 0.331130892038345, 0.331152737140656, 0.331174552440643, 0.331196188926697, 0.331217765808105, 0.331239253282547, 0.331260651350021, 0.331281900405884, 0.331303060054779, 0.331324130296707, 0.331345051527023, 0.331365942955017, 0.331386685371399, 0.331407338380814, 0.331427901983261, 0.331448346376419, 0.331468671560287, 0.331488937139511, 0.331509053707123, 0.331529080867767, 0.331549018621445, 0.331568866968155, 0.331588596105576, 0.331608235836029, 0.331627726554871, 0.331647127866745, 0.331666439771652, 0.331685662269592, 0.331704795360565, 0.331723809242249, 0.331742703914642, 0.331761509180069, 0.331780254840851, 0.331798821687698, 0.331817328929901, 0.331835746765137, 0.33185401558876, 0.331872195005417, 0.331890285015106, 0.331908285617828, 0.331926137208939, 0.331943929195404, 0.331961631774902, 0.331979185342789, 0.33199667930603, 0.33201402425766, 0.332031309604645, 0.332048445940018, 0.332065522670746, 0.332082480192184, 0.332099348306656, 0.332116097211838, 0.332132756710052, 0.332149296998978, 0.332165747880936, 0.332182109355927, 0.332198351621628, 0.33221447467804, 0.332230508327484, 0.332246422767639, 0.332262277603149, 0.33227801322937, 0.332293659448624, 0.332309156656265, 0.33232456445694, 0.332339912652969, 0.332355141639709, 0.33237025141716, 0.332385241985321, 0.332400143146515, 0.332414984703064, 0.332429707050323, 0.332444280385971, 0.332458794116974, 0.332473158836365, 0.332487463951111, 0.33250167965889, 0.332515746355057, 0.332529753446579, 0.332543611526489, 0.332557410001755, 0.332571089267731, 0.332584649324417, 0.332598119974136, 0.332611501216888, 0.332624763250351, 0.332637935876846, 0.332651019096375, 0.332663983106613, 0.332676827907562, 0.332689583301544, 0.332702249288559, 0.332714796066284, 0.332727253437042, 0.332739591598511, 0.332751840353012, 0.332763999700546, 0.332776010036469, 0.332787960767746, 0.332799792289734, 0.332811504602432, 0.332823157310486, 0.33283469080925, 0.332846105098724, 0.332857429981232, 0.332868635654449, 0.3328797519207, 0.332890778779984, 0.332901686429977, 0.332912504673004, 0.332923203706741, 0.332933813333511, 0.332944303750992, 0.332954704761505, 0.332964986562729, 0.332975208759308, 0.332985281944275, 0.332995265722275, 0.333005160093307, 0.333014935255051, 0.333024621009827, 0.333034217357635, 0.333043694496155, 0.333053082227707, 0.333062320947647, 0.333071500062943, 0.333080559968948, 0.333089530467987, 0.333098411560059, 0.333107143640518, 0.333115786314011, 0.333124339580536, 0.333132803440094, 0.333141148090363, 0.333149403333664, 0.333157539367676, 0.33316558599472, 0.333173513412476, 0.333181351423264, 0.333189100027084, 0.333196699619293, 0.33320426940918, 0.333211690187454, 0.333218991756439, 0.333226233720779, 0.33323335647583, 0.333240360021591, 0.333247303962708, 0.333254098892212, 0.333260774612427, 0.333267390727997, 0.333273887634277, 0.333280295133591, 0.333286613225937, 0.333292812108994, 0.333298891782761, 0.333304882049561, 0.333310782909393, 0.333316564559937, 0.33332222700119, 0.333327829837799, 0.333333313465118, 0.333338677883148, 0.333343952894211, 0.333349108695984, 0.333354204893112, 0.333359152078629, 0.3333640396595, 0.33336877822876, 0.333373427391052, 0.333377987146378, 0.333382457494736, 0.333386808633804, 0.333391040563583, 0.333395183086395, 0.33339923620224, 0.333403170108795, 0.333407014608383, 0.333410769701004, 0.333414375782013, 0.333417892456055, 0.333421319723129, 0.333424657583237, 0.333427876234055, 0.333431005477905, 0.333434015512466, 0.33343693614006, 0.333439767360687, 0.333442449569702, 0.333445072174072, 0.333447575569153, 0.333449989557266, 0.33345228433609, 0.333454489707947, 0.333456546068192, 0.333458542823792, 0.333460479974747, 0.33346226811409, 0.333463281393051, 0.333463579416275, 0.333463758230209, 0.333463847637177, 0.333463817834854, 0.333463698625565, 0.333463400602341, 0.333463042974472, 0.333462595939636, 0.333461999893188, 0.333461314439774, 0.333460509777069, 0.333459615707397, 0.333458602428436, 0.333457469940186, 0.333456218242645, 0.333454877138138, 0.333453416824341, 0.333451867103577, 0.333450227975845, 0.333448439836502, 0.333446532487869, 0.333444535732269, 0.333442449569702, 0.333440244197845, 0.333437889814377, 0.333435475826263, 0.333432912826538, 0.333430290222168, 0.333427518606186, 0.333424657583237, 0.333421647548676, 0.33341857790947, 0.333415418863297, 0.333412051200867, 0.333408653736115, 0.333405137062073, 0.333401501178741, 0.333397775888443, 0.333393901586533, 0.333389967679977, 0.333385854959488, 0.333381712436676, 0.333377420902252, 0.333373039960861, 0.333368539810181, 0.333363920450211, 0.333359181880951, 0.333354353904724, 0.333349406719208, 0.333344370126724, 0.333339184522629, 0.333333939313889, 0.333328574895859, 0.333323091268539, 0.333317488431931, 0.333311796188354, 0.333305954933167, 0.333300054073334, 0.333293974399567, 0.333287864923477, 0.333281636238098, 0.333275258541107, 0.333268821239471, 0.333262234926224, 0.333255529403687, 0.333248734474182, 0.333241850137711, 0.333234816789627, 0.333227694034576, 0.333220452070236, 0.333213120698929, 0.333205670118332, 0.333198130130768, 0.333190470933914, 0.333182662725449, 0.333174794912338, 0.333166778087616, 0.333158731460571, 0.33315047621727, 0.333142191171646, 0.33313375711441, 0.333125174045563, 0.333116561174393, 0.333107799291611, 0.333098918199539, 0.3330899477005, 0.333080857992172, 0.333071678876877, 0.333062380552292, 0.333052963018417, 0.333043456077576, 0.333033800125122, 0.333024054765701, 0.333014219999313, 0.333004266023636, 0.332994192838669, 0.332984030246735, 0.332973748445511, 0.332963347434998, 0.332952857017517, 0.332942247390747, 0.332931518554688, 0.332920700311661, 0.332909733057022, 0.332898706197739, 0.332887560129166, 0.332876294851303, 0.332864910364151, 0.332853436470032, 0.332841843366623, 0.332830131053925, 0.332818329334259, 0.332806408405304, 0.332794398069382, 0.332782238721848, 0.332769989967346, 0.332757651805878, 0.332745164632797, 0.33273258805275, 0.332719922065735, 0.332707107067108, 0.332694232463837, 0.332681208848953, 0.332668095827103, 0.332654863595963, 0.332641512155533, 0.332628071308136, 0.332614541053772, 0.332600861787796, 0.332587093114853, 0.33257320523262, 0.33255922794342, 0.332545131444931, 0.332530915737152, 0.332516610622406, 0.332502156496048, 0.332487642765045, 0.33247298002243, 0.332458227872849, 0.332443356513977, 0.332428395748138, 0.33241331577301, 0.332398116588593, 0.332382798194885, 0.332367390394211, 0.332351863384247, 0.332336276769638, 0.332320541143417, 0.332304686307907, 0.332288712263107, 0.332272678613663, 0.332256495952606, 0.332240223884583, 0.332223802804947, 0.332207322120667, 0.332190722227097, 0.332174003124237, 0.332157164812088, 0.332140237092972, 0.332123190164566, 0.332106053829193, 0.332088798284531, 0.332071423530579, 0.332053929567337, 0.332036346197128, 0.33201864361763, 0.332000821828842, 0.331982910633087, 0.331964880228043, 0.331946760416031, 0.33192852139473, 0.331910163164139, 0.331891685724258, 0.331873148679733, 0.331854432821274, 0.33183565735817, 0.331816762685776, 0.331797748804092, 0.331778645515442, 0.331759423017502, 0.331740081310272, 0.331720620393753, 0.331701070070267, 0.331681430339813, 0.33166167140007, 0.331641793251038, 0.331621795892715, 0.331601709127426, 0.331581473350525, 0.331561148166656, 0.331540763378143, 0.331520229578018, 0.331499546766281, 0.331478834152222, 0.33145797252655, 0.331436991691589, 0.331415921449661, 0.331394731998444, 0.331373423337936, 0.331352025270462, 0.331330507993698, 0.331308871507645, 0.331287145614624, 0.331265300512314, 0.331243366003036, 0.331221282482147, 0.331199109554291, 0.331176847219467, 0.331154465675354, 0.331131964921951, 0.331109344959259, 0.331086665391922, 0.331063807010651, 0.331040918827057, 0.331017851829529, 0.330994695425034, 0.330971449613571, 0.330948084592819, 0.330924570560455, 0.330900996923447, 0.330877304077148, 0.330853492021561, 0.330829590559006, 0.330805569887161, 0.330781400203705, 0.330757200717926, 0.330732852220535, 0.330708384513855, 0.330683827400208, 0.330659151077271, 0.330634355545044, 0.33060947060585, 0.330584466457367, 0.330559313297272, 0.330534130334854, 0.330508798360825, 0.330483347177505, 0.330457806587219, 0.330432146787643, 0.330406367778778, 0.330380499362946, 0.330354511737823, 0.330328434705734, 0.330302238464355, 0.330275893211365, 0.330249458551407, 0.330222934484482, 0.33019632101059, 0.330169558525085, 0.330142706632614, 0.330115735530853, 0.330088675022125, 0.330061465501785, 0.330034166574478, 0.330006778240204, 0.329979240894318, 0.329951643943787, 0.329923927783966, 0.329896062612534, 0.329868137836456, 0.329840064048767, 0.329811930656433, 0.329783648252487, 0.329755246639252, 0.329726755619049, 0.329698175191879, 0.329669445753098, 0.329640626907349, 0.32961168885231, 0.329582661390305, 0.329553514719009, 0.329524278640747, 0.329494893550873, 0.329465419054031, 0.3294358253479, 0.329406142234802, 0.329376339912415, 0.329346418380737, 0.329316407442093, 0.329286277294159, 0.329256057739258, 0.329225689172745, 0.329195231199265, 0.329164654016495, 0.329133987426758, 0.329103201627731, 0.329072326421738, 0.329041302204132, 0.329010218381882, 0.328978985548019, 0.32894766330719, 0.328916221857071, 0.328884661197662, 0.328853011131287, 0.328821241855621, 0.328789383172989, 0.328757405281067, 0.328725337982178, 0.328693091869354, 0.328660786151886, 0.328628391027451, 0.328595846891403, 0.328563213348389, 0.328530460596085, 0.328497618436813, 0.328464657068253, 0.328431576490402, 0.328398406505585, 0.328365117311478, 0.328331708908081, 0.328298181295395, 0.328264594078064, 0.328230828046799, 0.328197002410889, 0.328163057565689, 0.3281289935112, 0.328094840049744, 0.328060567378998, 0.328026205301285, 0.32799169421196, 0.327957093715668, 0.327922403812408, 0.327887564897537, 0.327852636575699, 0.327817589044571, 0.327782481908798, 0.327747225761414, 0.327711850404739, 0.327676385641098, 0.327640801668167, 0.327605128288269, 0.327569305896759, 0.327533394098282, 0.327497392892838, 0.327461242675781, 0.32742503285408, 0.32738870382309, 0.327352225780487, 0.32731568813324, 0.32727900147438, 0.327242225408554, 0.32720535993576, 0.327168345451355, 0.327131241559982, 0.327093988656998, 0.327056676149368, 0.327019244432449, 0.326981693506241, 0.326944023370743, 0.3269062936306, 0.326868385076523, 0.326830446720123, 0.326792359352112, 0.326754152774811, 0.326715856790543, 0.326677441596985, 0.326638907194138, 0.326600253582001, 0.326561510562897, 0.326522678136826, 0.326483726501465, 0.326444655656815, 0.326405465602875, 0.326366156339645, 0.326326787471771, 0.326287269592285, 0.32624763250351, 0.326207935810089, 0.326168090105057, 0.326128154993057, 0.326088100671768, 0.32604792714119, 0.326007664203644, 0.325967311859131, 0.325926810503006, 0.325886219739914, 0.32584547996521, 0.325804710388184, 0.325763761997223, 0.325722724199295, 0.3256815969944, 0.325640350580215, 0.325598984956741, 0.325557500123978, 0.325515955686569, 0.325474262237549, 0.325432419776917, 0.325390547513962, 0.325348526239395, 0.325306415557861, 0.325264155864716, 0.325221836566925, 0.325179398059845, 0.325136840343475, 0.325094163417816, 0.325051367282867, 0.325008481740952, 0.324965506792068, 0.324922412633896, 0.324879169464111, 0.324835866689682, 0.324792414903641, 0.324748873710632, 0.324705243110657, 0.324661463499069, 0.324617624282837, 0.324573636054993, 0.324529558420181, 0.324485331773758, 0.32444104552269, 0.324396640062332, 0.324352115392685, 0.324307501316071, 0.324262738227844, 0.324217915534973, 0.324172914028168, 0.324127852916718, 0.324082672595978, 0.324037402868271, 0.323992013931274, 0.323946505784988, 0.323900908231735, 0.32385516166687, 0.32380935549736, 0.323763400316238, 0.323717355728149, 0.323671191930771, 0.323624938726425, 0.32357856631279, 0.323532074689865, 0.323485463857651, 0.323438793420792, 0.323391973972321, 0.32334503531456, 0.323298007249832, 0.323250889778137, 0.32320362329483, 0.323156267404556, 0.323108792304993, 0.323061227798462, 0.323013544082642, 0.322965741157532, 0.322917848825455, 0.322869807481766, 0.322821706533432, 0.322773486375809, 0.322725147008896, 0.322676688432693, 0.322628140449524, 0.322579473257065, 0.322530716657639, 0.3224818110466, 0.322432816028595, 0.322383761405945, 0.322334498167038, 0.322285205125809, 0.322235763072968, 0.322186231613159, 0.322136580944061, 0.322086811065674, 0.322036981582642, 0.321986973285675, 0.321936905384064, 0.321886718273163, 0.321836411952972, 0.321785986423492, 0.321735471487045, 0.321684867143631, 0.321634113788605, 0.321583271026611, 0.321532338857651, 0.321481227874756, 0.321430057287216, 0.321378797292709, 0.321327388286591, 0.321275889873505, 0.321224272251129, 0.321172565221786, 0.321120738983154, 0.321068793535233, 0.321016758680344, 0.320964604616165, 0.320912331342697, 0.320859968662262, 0.320807486772537, 0.320754885673523, 0.320702224969864, 0.320649385452271, 0.320596486330032, 0.320543438196182, 0.320490300655365, 0.320437043905258, 0.320383697748184, 0.320330262184143, 0.32027667760849, 0.32022300362587, 0.32016921043396, 0.320115298032761, 0.320061296224594, 0.320006340742111, 0.319950431585312, 0.319894403219223, 0.319838285446167, 0.319782078266144, 0.319725722074509, 0.319669336080551, 0.319612771272659, 0.319556146860123, 0.319499373435974, 0.319442540407181, 0.319385588169098, 0.319328546524048, 0.319271385669708, 0.319214135408401, 0.319156765937805, 0.319099277257919, 0.319041728973389, 0.318984061479568, 0.318926244974136, 0.318868398666382, 0.318810403347015, 0.318752318620682, 0.318694114685059, 0.318635821342468, 0.318577408790588, 0.318518906831741, 0.318460315465927, 0.318401575088501, 0.31834277510643, 0.31828385591507, 0.318224847316742, 0.318165689706802, 0.318106472492218, 0.318047165870667, 0.317987680435181, 0.31792813539505, 0.317868530750275, 0.317808777093887, 0.31774890422821, 0.317688971757889, 0.317628890275955, 0.317568749189377, 0.317508459091187, 0.317448109388351, 0.317387610673904, 0.31732702255249, 0.317266345024109, 0.31720557808876, 0.317144691944122, 0.317083686590195, 0.3170225918293, 0.316961407661438, 0.316900104284286, 0.316838711500168, 0.316777169704437, 0.316715568304062, 0.316653847694397, 0.316592037677765, 0.316530078649521, 0.316468060016632, 0.316405951976776, 0.316343724727631, 0.316281378269196, 0.316218912601471, 0.316156357526779, 0.31609371304512, 0.316030949354172, 0.315968096256256, 0.315905153751373, 0.315842062234879, 0.315778911113739, 0.31571564078331, 0.315652251243591, 0.315588772296906, 0.315525203943253, 0.315461486577988, 0.315397709608078, 0.315333813428879, 0.315269827842712, 0.315205693244934, 0.315141499042511, 0.315077185630798, 0.315012782812119, 0.314948260784149, 0.314883649349213, 0.314818918704987, 0.314754098653793, 0.314689159393311, 0.314624130725861, 0.314558982849121, 0.314493745565414, 0.314428418874741, 0.314362972974777, 0.314297407865524, 0.314231753349304, 0.314165979623795, 0.314100116491318, 0.314034163951874, 0.313968062400818, 0.313901901245117, 0.313835620880127, 0.31376925110817, 0.313702762126923, 0.313636183738708, 0.313569456338882, 0.313502669334412, 0.313435763120651, 0.313368767499924, 0.313301652669907, 0.313234448432922, 0.313167124986649, 0.313099712133408, 0.313032180070877, 0.312964558601379, 0.312896817922592, 0.31282901763916, 0.312761038541794, 0.312692999839783, 0.312624871730804, 0.312556624412537, 0.312488257884979, 0.312419801950455, 0.312351256608963, 0.312282592058182, 0.312213808298111, 0.312144964933395, 0.312075972557068, 0.312006890773773, 0.311937719583511, 0.31186842918396, 0.311799049377441, 0.311729550361633, 0.311659961938858, 0.311590224504471, 0.311520427465439, 0.31145054101944, 0.311380535364151, 0.311310410499573, 0.311240196228027, 0.311169862747192, 0.31109943985939, 0.311028897762299, 0.310958296060562, 0.310887545347214, 0.310816705226898, 0.310745775699615, 0.310674697160721, 0.310603588819504, 0.310532301664352, 0.310460954904556, 0.310389488935471, 0.310317903757095, 0.310246258974075, 0.310174465179443, 0.310102611780167, 0.310030609369278, 0.309958547353745, 0.309886336326599, 0.309814065694809, 0.309741646051407, 0.30966916680336, 0.309596568346024, 0.309523850679398, 0.309451043605804, 0.309378147125244, 0.309305131435394, 0.309231996536255, 0.309158772230148, 0.309085428714752, 0.309012025594711, 0.308938473463058, 0.308864861726761, 0.308791100978851, 0.308717250823975, 0.308643281459808, 0.308569252490997, 0.308495074510574, 0.308420836925507, 0.308346450328827, 0.308272004127502, 0.308197408914566, 0.308122724294662, 0.308047980070114, 0.307973086833954, 0.307898104190826, 0.307823002338409, 0.307747781276703, 0.307672500610352, 0.307597130537033, 0.307521611452103, 0.307446002960205, 0.307370275259018, 0.307294487953186, 0.307218551635742, 0.307142525911331, 0.307066380977631, 0.306990146636963, 0.30691385269165, 0.306837409734726, 0.306760847568512, 0.306684225797653, 0.306607455015182, 0.306530624628067, 0.30645364522934, 0.306376606225967, 0.306299448013306, 0.306222170591354, 0.306144773960114, 0.306067317724228, 0.305989742279053, 0.30591207742691, 0.305834263563156, 0.305756360292435, 0.305678367614746, 0.30560028553009, 0.305522084236145, 0.30544376373291, 0.305365383625031, 0.305286884307861, 0.305208265781403, 0.305129528045654, 0.305050700902939, 0.304971784353256, 0.304892748594284, 0.304813623428345, 0.304734379053116, 0.30465504527092, 0.304575622081757, 0.304496049880981, 0.304416388273239, 0.30433663725853, 0.304256796836853, 0.304176837205887, 0.304096758365631, 0.304016590118408, 0.303936332464218, 0.303855925798416, 0.303775459527969, 0.303694844245911, 0.30361419916153, 0.303533405065536, 0.303452521562576, 0.303371518850327, 0.303290396928787, 0.303209185600281, 0.303127884864807, 0.303046464920044, 0.302964925765991, 0.302883327007294, 0.302801609039307, 0.30271977186203, 0.302637845277786, 0.302555799484253, 0.302473664283752, 0.302391439676285, 0.302309095859528, 0.302226632833481, 0.302144080400467, 0.302061438560486, 0.301978647708893, 0.301895797252655, 0.301812827587128, 0.301729738712311, 0.301646560430527, 0.301563292741776, 0.301479905843735, 0.301396429538727, 0.301312834024429, 0.301229149103165, 0.301145374774933, 0.301061421632767, 0.300977408885956, 0.3008933365345, 0.300809115171432, 0.300724804401398, 0.300640374422073, 0.300555855035782, 0.300471216440201, 0.300386488437653, 0.300301641225815, 0.30021670460701, 0.300131678581238, 0.300046533346176, 0.299961298704147, 0.299875915050507, 0.299790471792221, 0.299704909324646, 0.299619257450104, 0.299533486366272, 0.299447625875473, 0.299361646175385, 0.299275577068329, 0.299189388751984, 0.299103081226349, 0.299016684293747, 0.2989302277565, 0.298843622207642, 0.298756927251816, 0.2986701130867, 0.298583209514618, 0.298496186733246, 0.298409074544907, 0.298321843147278, 0.298234522342682, 0.298147141933441, 0.298059582710266, 0.297971963882446, 0.297884196043015, 0.297796368598938, 0.297708421945572, 0.297620385885239, 0.297532230615616, 0.297443985939026, 0.297355592250824, 0.297267138957977, 0.297178566455841, 0.297089904546738, 0.297001123428345, 0.296912282705307, 0.296823292970657, 0.296734213829041, 0.296645015478134, 0.296555727720261, 0.296466320753098, 0.296376824378967, 0.296287208795547, 0.296197503805161, 0.296107709407806, 0.296017795801163, 0.295927792787552, 0.295837670564651, 0.295747399330139, 0.295657098293304, 0.29556667804718, 0.295476138591766, 0.295385479927063, 0.295294761657715, 0.295203894376755, 0.295112937688828, 0.295021891593933, 0.294930756092072, 0.294839471578598, 0.294748097658157, 0.29465663433075, 0.294565081596375, 0.29447340965271, 0.294381588697433, 0.294289737939835, 0.294197738170624, 0.294105648994446, 0.294013470411301, 0.293921172618866, 0.293828755617142, 0.293736279010773, 0.293643653392792, 0.293550908565521, 0.293458104133606, 0.293365180492401, 0.293272167444229, 0.29317906498909, 0.293085813522339, 0.292992502450943, 0.292899042367935, 0.292805463075638, 0.292711853981018, 0.292618095874786, 0.292524248361588, 0.292430311441422, 0.292336225509644, 0.292242079973221, 0.292147785425186, 0.292053431272507, 0.291958957910538, 0.291864395141602, 0.291769683361053, 0.291674911975861, 0.291580021381378, 0.291485041379929, 0.291389912366867, 0.291294753551483, 0.291199415922165, 0.291104018688202, 0.291008502244949, 0.29091289639473, 0.290817201137543, 0.290721356868744, 0.290625423192978, 0.290529370307922, 0.290433257818222, 0.290337026119232, 0.290240675210953, 0.290144234895706, 0.290047705173492, 0.289951056241989, 0.289854288101196, 0.289757430553436, 0.289660483598709, 0.28956338763237, 0.289466202259064, 0.289368957281113, 0.289271593093872, 0.28917407989502, 0.289076507091522, 0.288978815078735, 0.288881033658981, 0.288783133029938, 0.288685113191605, 0.288587003946304, 0.288488805294037, 0.288390517234802, 0.288292109966278, 0.288193583488464, 0.288094937801361, 0.287996232509613, 0.287897408008575, 0.287798464298248, 0.287699460983276, 0.287600308656693, 0.287501066923141, 0.287401705980301, 0.287302225828171, 0.287202715873718, 0.287103056907654, 0.2870032787323, 0.286903411149979, 0.28680345416069, 0.286703377962112, 0.286603212356567, 0.286502927541733, 0.286402523517609, 0.28630205988884, 0.286201477050781, 0.286100775003433, 0.285999983549118, 0.285899072885513, 0.285798072814941, 0.28569695353508, 0.285595744848251, 0.285494446754456, 0.285392999649048, 0.285291463136673, 0.285189837217331, 0.285088121891022, 0.284986287355423, 0.284884363412857, 0.284782290458679, 0.284680157899857, 0.284577906131744, 0.284475564956665, 0.284373104572296, 0.284270524978638, 0.284167885780334, 0.284065127372742, 0.283962249755859, 0.28385928273201, 0.283756166696548, 0.283652991056442, 0.283549726009369, 0.283446311950684, 0.283342838287354, 0.283239215612411, 0.283135563135147, 0.283031731843948, 0.282927811145782, 0.282823801040649, 0.282719671726227, 0.282615453004837, 0.28251114487648, 0.282406717538834, 0.282302170991898, 0.282197564840317, 0.282092839479446, 0.281987965106964, 0.281883031129837, 0.28177797794342, 0.281672835350037, 0.281567573547363, 0.281462222337723, 0.281356781721115, 0.281251192092896, 0.281145513057709, 0.281039744615555, 0.280933886766434, 0.280827879905701, 0.280721813440323, 0.280615627765656, 0.280509352684021, 0.280402928590775, 0.280296444892883, 0.280189841985703, 0.280083119869232, 0.279976308345795, 0.279869377613068, 0.279762387275696, 0.279655277729034, 0.279548048973083, 0.279440730810165, 0.279333263635635, 0.279225736856461, 0.279115229845047, 0.27900168299675, 0.27888810634613, 0.278774410486221, 0.27866068482399, 0.278546839952469, 0.278432995080948, 0.27831906080246, 0.278205007314682, 0.278090924024582, 0.277976810932159, 0.27786260843277, 0.277748286724091, 0.277633935213089, 0.27751949429512, 0.277404993772507, 0.277290463447571, 0.277175813913345, 0.277061134576797, 0.276946365833282, 0.276831537485123, 0.276716619729996, 0.276601672172546, 0.27648663520813, 0.276371508836746, 0.27625635266304, 0.276141107082367, 0.276025801897049, 0.275910407304764, 0.275794982910156, 0.275679469108582, 0.275563895702362, 0.275448232889175, 0.275332510471344, 0.275216728448868, 0.275100886821747, 0.274984955787659, 0.274868935346603, 0.274752885103226, 0.274636775255203, 0.274520576000214, 0.274404287338257, 0.274287968873978, 0.274171561002731, 0.27405509352684, 0.273938566446304, 0.273821979761124, 0.273705273866653, 0.273588538169861, 0.273471713066101, 0.273354858160019, 0.27323791384697, 0.273120909929276, 0.273003786802292, 0.272886663675308, 0.272769451141357, 0.272652149200439, 0.272534787654877, 0.272417366504669, 0.272299885749817, 0.272182315587997, 0.272064685821533, 0.271946996450424, 0.271829217672348, 0.271711379289627, 0.271593511104584, 0.271475523710251, 0.271357506513596, 0.271239399909973, 0.271121203899384, 0.271002948284149, 0.270884662866592, 0.270766288042068, 0.270647823810577, 0.270529329776764, 0.270410746335983, 0.270292073488235, 0.270173341035843, 0.270054578781128, 0.269935727119446, 0.269816786050797, 0.269697785377502, 0.269578754901886, 0.26945960521698, 0.269340425729752, 0.269221156835556, 0.269101828336716, 0.268982410430908, 0.268862932920456, 0.268743395805359, 0.268623799085617, 0.268504112958908, 0.268384397029877, 0.268264561891556, 0.26814466714859, 0.268024772405624, 0.267904728651047, 0.267784655094147, 0.267664521932602, 0.267544269561768, 0.267423987388611, 0.267303615808487, 0.267183214426041, 0.267062723636627, 0.266942173242569, 0.266821533441544, 0.266700834035873, 0.266580075025558, 0.266459226608276, 0.266338318586349, 0.266217350959778, 0.266096323728561, 0.265975207090378, 0.265854030847549, 0.265732765197754, 0.265611469745636, 0.265490114688873, 0.265368640422821, 0.265247166156769, 0.265125542879105, 0.265003889799118, 0.264882177114487, 0.264760404825211, 0.264638513326645, 0.264516621828079, 0.264394581317902, 0.264272570610046, 0.264150440692902, 0.26402822136879, 0.263905942440033, 0.263783633708954, 0.263661235570908, 0.263538748025894, 0.263416230678558, 0.263293623924255, 0.263170927762985, 0.26304817199707, 0.262925386428833, 0.262802511453629, 0.262679547071457, 0.262556523084641, 0.262433439493179, 0.262310296297073, 0.262187063694, 0.262063771486282, 0.261940449476242, 0.26181697845459, 0.26169353723526, 0.261569947004318, 0.261446297168732, 0.261322617530823, 0.261198878288269, 0.261075019836426, 0.260951101779938, 0.260827153921127, 0.260703086853027, 0.260578989982605, 0.260454833507538, 0.260330587625504, 0.260206282138824, 0.260081887245178, 0.25995746254921, 0.259832948446274, 0.259708344936371, 0.259583681821823, 0.259458988904953, 0.259334176778793, 0.259209305047989, 0.259084403514862, 0.258959382772446, 0.258834332227707, 0.258709192276001, 0.258584022521973, 0.258458733558655, 0.258333414793015, 0.258208006620407, 0.258082538843155, 0.257957011461258, 0.257831394672394, 0.257705718278885, 0.257579982280731, 0.25745415687561, 0.257328301668167, 0.257202327251434, 0.257076323032379, 0.256950259208679, 0.25682407617569, 0.256697833538055, 0.256571561098099, 0.256445199251175, 0.256318747997284, 0.256192296743393, 0.25606569647789, 0.255939096212387, 0.255812406539917, 0.255685597658157, 0.255558788776398, 0.255431860685349, 0.255304902791977, 0.255177855491638, 0.255050778388977, 0.254923582077026, 0.254796326160431, 0.254669010639191, 0.254541635513306, 0.254414200782776, 0.254286676645279, 0.254159092903137, 0.254031449556351, 0.253903716802597, 0.253775924444199, 0.253648072481155, 0.253520131111145, 0.253392159938812, 0.253264099359512, 0.253135949373245, 0.253007769584656, 0.252879470586777, 0.252751171588898, 0.252622753381729, 0.252494275569916, 0.252365738153458, 0.252237141132355, 0.252108454704285, 0.251979738473892, 0.25185090303421, 0.251722037792206, 0.251593083143234, 0.251464039087296, 0.251334965229034, 0.251205801963806, 0.251076579093933, 0.250947296619415, 0.250817954540253, 0.250688493251801, 0.250559031963348, 0.250429481267929, 0.25029981136322, 0.250170141458511, 0.250040322542191, 0.249910533428192, 0.249780640006065, 0.249650657176971, 0.249520614743233, 0.249390512704849, 0.249260321259499, 0.249130085110664, 0.248999789357185, 0.248869359493256, 0.248738929629326, 0.24860842525959, 0.248477816581726, 0.248347148299217, 0.248216450214386, 0.248085662722588, 0.247954785823822, 0.247823849320412, 0.24769289791584, 0.247561827301979, 0.247430667281151, 0.247299477458, 0.247168242931366, 0.247036874294281, 0.246905475854874, 0.24677400290966, 0.24664244055748, 0.246510863304138, 0.246379151940346, 0.246247425675392, 0.246115624904633, 0.245983734726906, 0.245851770043373, 0.245719760656357, 0.245587676763535, 0.245455503463745, 0.245323330163956, 0.245190992951393, 0.245058655738831, 0.244926244020462, 0.244793727993965, 0.244661167263985, 0.244528517127037, 0.244395837187767, 0.244263052940369, 0.244130209088326, 0.243997320532799, 0.243864357471466, 0.243731305003166, 0.243598207831383, 0.243465051054955, 0.243331775069237, 0.243198469281197, 0.243065074086189, 0.242931619286537, 0.242798119783401, 0.242664515972137, 0.24253086745739, 0.242397144436836, 0.242263361811638, 0.242129474878311, 0.241995573043823, 0.241861566901207, 0.241727501153946, 0.24159337580204, 0.241459161043167, 0.241324916481972, 0.241190582513809, 0.241056174039841, 0.240921676158905, 0.240787133574486, 0.240652546286583, 0.240517869591713, 0.240383103489876, 0.240248307585716, 0.24011342227459, 0.239978462457657, 0.239843428134918, 0.239708364009857, 0.239573195576668, 0.239437997341156, 0.239302679896355, 0.239167332649231, 0.23903189599514, 0.238896384835243, 0.238760828971863, 0.238625213503838, 0.238489508628845, 0.238353729248047, 0.238217905163765, 0.238081991672516, 0.237946018576622, 0.237810000777245, 0.237673878669739, 0.237537696957588, 0.237401470541954, 0.237265139818192, 0.237128734588623, 0.236992284655571, 0.236855790019035, 0.236719191074371, 0.236582517623901, 0.236445799469948, 0.236309051513672, 0.236172154545784, 0.236035227775574, 0.235898226499557, 0.235761165618896, 0.23562403023243, 0.235486835241318, 0.235349580645561, 0.235212236642838, 0.235074803233147, 0.234937340021133, 0.234799817204475, 0.234662190079689, 0.234524518251419, 0.234386771917343, 0.234248951077461, 0.234111070632935, 0.233973130583763, 0.233835101127625, 0.233697012066841, 0.233558848500252, 0.233420625329018, 0.233282327651978, 0.233143955469131, 0.233005538582802, 0.232867062091827, 0.232728466391563, 0.232589855790138, 0.232451155781746, 0.232312366366386, 0.232173547148705, 0.232034638524055, 0.2318956553936, 0.231756627559662, 0.231617525219917, 0.231478318572044, 0.231339082121849, 0.231199756264687, 0.231060370802879, 0.23092095553875, 0.230781406164169, 0.230641812086105, 0.230502143502235, 0.230362415313721, 0.230222642421722, 0.230082809925079, 0.229942843317986, 0.229802861809731, 0.22966280579567, 0.229522675275803, 0.22938247025013, 0.229242190718651, 0.229101836681366, 0.228961452841759, 0.228820949792862, 0.228680416941643, 0.228539809584618, 0.228399127721786, 0.228258401155472, 0.22811758518219, 0.227976694703102, 0.22783574461937, 0.227694734930992, 0.227553635835648, 0.227412477135658, 0.227271258831024, 0.227129966020584, 0.226988583803177, 0.226847156882286, 0.226705685257912, 0.226564109325409, 0.226422443985939, 0.226280778646469, 0.22613899409771, 0.225997149944305, 0.225855261087418, 0.225713267922401, 0.225571230053902, 0.225429117679596, 0.225286960601807, 0.225144684314728, 0.225002378225327, 0.224859967827797, 0.224717527627945, 0.224575012922287, 0.224432408809662, 0.224289759993553, 0.224147036671638, 0.224004238843918, 0.223861381411552, 0.223718479275703, 0.223575443029404, 0.223432391881943, 0.223289266228676, 0.223146051168442, 0.223002776503563, 0.222859442234039, 0.222716048359871, 0.222572579979897, 0.222429007291794, 0.22228541970253, 0.22214175760746, 0.221997976303101, 0.22185418009758, 0.221710294485092, 0.221566319465637, 0.22142231464386, 0.221278220415115, 0.221134051680565, 0.220989838242531, 0.220845550298691, 0.220701187849045, 0.220556750893593, 0.220412239432335, 0.220267683267593, 0.220123052597046, 0.21997831761837, 0.219833552837372, 0.219688728451729, 0.21954382956028, 0.219398856163025, 0.219253808259964, 0.219108685851097, 0.218963518738747, 0.218818247318268, 0.218672960996628, 0.218527555465698, 0.218382105231285, 0.218236565589905, 0.218091011047363, 0.217945337295532, 0.217799633741379, 0.217653855681419, 0.217507973313332, 0.217362031340599, 0.217216044664383, 0.217069953680038, 0.216923847794533, 0.216777622699738, 0.216631352901459, 0.216485023498535, 0.216338589787483, 0.21619214117527, 0.21604560315609, 0.21589894592762, 0.21575228869915, 0.215605556964874, 0.215458706021309, 0.215311825275421, 0.215164914727211, 0.21501787006855, 0.214870780706406, 0.214723616838455, 0.21457639336586, 0.214429125189781, 0.214281722903252, 0.214134305715561, 0.213986814022064, 0.213837638497353, 0.213687062263489, 0.213536515831947, 0.213385924696922, 0.213235378265381, 0.213084787130356, 0.212934195995331, 0.212783649563789, 0.212633058428764, 0.212482497096062, 0.212331965565681, 0.212181374430656, 0.212030827999115, 0.211880296468735, 0.211729735136032, 0.211579188704491, 0.211428642272949, 0.211278110742569, 0.211127579212189, 0.210977077484131, 0.210826486349106, 0.210675984621048, 0.210525438189507, 0.210374921560287, 0.21022441983223, 0.210073888301849, 0.20992337167263, 0.209772855043411, 0.209622353315353, 0.209471851587296, 0.209321334958076, 0.209170833230019, 0.209020331501961, 0.208869859576225, 0.208719357848167, 0.208568871021271, 0.208418354392052, 0.208267867565155, 0.208117410540581, 0.207966893911362, 0.207816436886787, 0.207665964961052, 0.207515463232994, 0.207364991307259, 0.207214549183846, 0.207064062356949, 0.206913590431213, 0.2067631483078, 0.206612706184387, 0.206462234258652, 0.206311777234077, 0.206161350011826, 0.206010892987251, 0.205860435962677, 0.205709993839264, 0.205559566617012, 0.205409124493599, 0.205258667469025, 0.205108240246773, 0.204957827925682, 0.20480740070343, 0.204656988382339, 0.204506546258926, 0.204356133937836, 0.204205736517906, 0.204055324196815, 0.203904926776886, 0.203754484653473, 0.203604117035866, 0.203453689813614, 0.203303277492523, 0.203152894973755, 0.203002512454987, 0.202852115035057, 0.202701717615128, 0.202551335096359, 0.20240093767643, 0.202250570058823, 0.202100187540054, 0.201949805021286, 0.20179945230484, 0.201649069786072, 0.201498731970787, 0.201348349452019, 0.20119796693325, 0.201047614216805, 0.20089727640152, 0.200746893882751, 0.200596541166306, 0.200446218252182, 0.200295850634575, 0.20014551281929, 0.199995175004005, 0.19984482228756, 0.199694484472275, 0.199544176459312, 0.199393838644028, 0.199243530631065, 0.199093192815781, 0.198942855000496, 0.198792532086372, 0.198642194271088, 0.198491916060448, 0.198341608047485, 0.198191285133362, 0.198040977120399, 0.197890684008598, 0.197740361094475, 0.197590067982674, 0.19743974506855, 0.19728946685791, 0.197139203548431, 0.196988895535469, 0.19683863222599, 0.19668835401535, 0.196538031101227, 0.196387767791748, 0.196237504482269, 0.196087226271629, 0.195936977863312, 0.195786699652672, 0.195636421442032, 0.195486158132553, 0.195335894823074, 0.195185631513596, 0.195035383105278, 0.194885104894638, 0.194734886288643, 0.194584667682648, 0.194434404373169, 0.194284170866013, 0.194133952260017, 0.193983688950539, 0.193833470344543, 0.193683251738548, 0.19353298842907, 0.193382769823074, 0.193232551217079, 0.193082317709923, 0.192932114005089, 0.192781880497932, 0.19263169169426, 0.192481502890587, 0.192331299185753, 0.192181095480919, 0.192030891776085, 0.19188067317009, 0.191730484366417, 0.191580310463905, 0.19143009185791, 0.191279903054237, 0.191129729151726, 0.190979540348053, 0.190829366445541, 0.190679177641869, 0.190529003739357, 0.190378814935684, 0.190228641033173, 0.190078496932983, 0.189928352832794, 0.189778178930283, 0.189628034830093, 0.189477905631065, 0.189327716827393, 0.189177572727203, 0.189027413725853, 0.188877299427986, 0.188727155327797, 0.188576981425285, 0.188426852226257, 0.188276737928391, 0.18812657892704, 0.187976449728012, 0.187826335430145, 0.187676191329956, 0.187526077032089, 0.187375977635384, 0.187225863337517, 0.187075763940811, 0.186925634741783, 0.186775520443916, 0.186625435948372, 0.186475291848183, 0.186325222253799, 0.186175137758255, 0.186025023460388, 0.185874924063683, 0.185724839568138, 0.185574740171432, 0.185424670577049, 0.185274586081505, 0.185124531388283, 0.1849744617939, 0.184824362397194, 0.184674307703972, 0.18452425301075, 0.184374153614044, 0.184224098920822, 0.184074029326439, 0.183923974633217, 0.183773919939995, 0.183623850345612, 0.18347379565239, 0.183323785662651, 0.183173716068268, 0.183023661375046, 0.182873651385307, 0.182723611593246, 0.182573571801186, 0.182423546910286, 0.182273507118225, 0.182123512029648, 0.181973472237587, 0.181823432445526, 0.181673437356949, 0.18152342736721, 0.18137338757515, 0.181223392486572, 0.181073382496834, 0.180923372507095, 0.180773392319679, 0.180623352527618, 0.180473372340202, 0.180323377251625, 0.180173397064209, 0.180023431777954, 0.179873451590538, 0.179723426699638, 0.179573446512222, 0.179423496127129, 0.179273501038551, 0.179123535752296, 0.178973570466042, 0.178823590278625, 0.178673624992371, 0.178523659706116, 0.178373724222183, 0.178223744034767, 0.178073808550835, 0.177923828363419, 0.177773892879486, 0.177623957395554, 0.177474021911621, 0.177324086427689, 0.177174106240273, 0.177024185657501, 0.17687426507473, 0.176724314689636, 0.176574394106865, 0.176424458622932, 0.176274523139, 0.176124632358551, 0.175974696874619, 0.175824791193008, 0.17567490041256, 0.175524979829788, 0.175375074148178, 0.175225168466568, 0.175075262784958, 0.17492538690567, 0.17477548122406, 0.17462557554245, 0.174475699663162, 0.174325779080391, 0.174175903201103, 0.174026027321815, 0.173876136541367, 0.173726260662079, 0.173576399683952, 0.173426508903503, 0.173276647925377, 0.173126801848412, 0.172976940870285, 0.172827064990997, 0.172677233815193, 0.172527343034744, 0.172377496957779, 0.172227621078491, 0.172077789902687, 0.171927958726883, 0.171778097748756, 0.171628251671791, 0.171478435397148, 0.171328574419022, 0.171178758144379, 0.171028941869736, 0.17087909579277, 0.170729279518127, 0.170579448342323, 0.170429646968842, 0.170279815793037, 0.170129999518394, 0.169980183243752, 0.169830396771431, 0.169680580496788, 0.169530779123306, 0.169380992650986, 0.169231176376343, 0.169081389904022, 0.16893158853054, 0.168781772255898, 0.168632000684738, 0.168482229113579, 0.168332457542419, 0.16818268597126, 0.168032884597778, 0.167883113026619, 0.167733356356621, 0.167583584785461, 0.167433813214302, 0.167284056544304, 0.167134284973145, 0.166984528303146, 0.166834786534309, 0.16668501496315, 0.166535273194313, 0.166385546326637, 0.166235774755478, 0.16608601808548, 0.165936306118965, 0.165786564350128, 0.165636837482452, 0.165487080812454, 0.16533736884594, 0.165187656879425, 0.165037900209427, 0.164888188242912, 0.164738476276398, 0.164588749408722, 0.164439037442207, 0.164289340376854, 0.164139613509178, 0.163989916443825, 0.163840234279633, 0.163690522313118, 0.163540810346603, 0.16339111328125, 0.163241446018219, 0.163091763854027, 0.162942051887512, 0.162792384624481, 0.16264271736145, 0.162493005394936, 0.162343353033066, 0.162193670868874, 0.162043988704681, 0.16189432144165, 0.161744683980942, 0.161594986915588, 0.16144534945488, 0.161295682191849, 0.161146029829979, 0.160996362566948, 0.160846740007401, 0.160697087645531, 0.160547435283661, 0.160397797822952, 0.160248175263405, 0.160098537802696, 0.159948885440826, 0.159799262881279, 0.159649640321732, 0.159499987959862, 0.159350365400314, 0.159200727939606, 0.159051135182381, 0.158901527523994, 0.158751904964447, 0.158602312207222, 0.158452704548836, 0.15830309689045, 0.158153504133224, 0.158003911375999, 0.157854303717613, 0.157704696059227, 0.157555133104324, 0.157405525445938, 0.157255932688713, 0.157106325030327, 0.156956762075424, 0.15680718421936, 0.156657606363297, 0.156508028507233, 0.156358480453491, 0.156208902597427, 0.156059354543686, 0.155909791588783, 0.155760213732719, 0.155610665678978, 0.155461117625237, 0.155311554670334, 0.155162021517754, 0.155012458562851, 0.154862925410271, 0.154713377356529, 0.154563829302788, 0.154414311051369, 0.15426479279995, 0.154115214943886, 0.153965711593628, 0.153816178441048, 0.153666660189629, 0.15351714193821, 0.153367638587952, 0.153218105435371, 0.153068602085114, 0.152919068932533, 0.152769580483437, 0.15262009203434, 0.15247055888176, 0.152321085333824, 0.152171611785889, 0.15202209353447, 0.151872590184212, 0.151723116636276, 0.151573643088341, 0.151424154639244, 0.15127469599247, 0.151125207543373, 0.150975719094276, 0.15082623064518, 0.150676757097244, 0.150527313351631, 0.150377854704857, 0.150228381156921, 0.150078937411308, 0.149929463863373, 0.14978002011776, 0.149630591273308, 0.149481117725372, 0.149331659078598, 0.149182215332985, 0.149032801389694, 0.148883357644081, 0.148733898997307, 0.148584470152855, 0.148435086011887, 0.148285627365112, 0.148136213421822, 0.147986799478531, 0.147837355732918, 0.147687941789627, 0.147538542747498, 0.147389099001884, 0.147239699959755, 0.147090330719948, 0.146940901875496, 0.146791517734528, 0.146642118692398, 0.146492704749107, 0.1463433355093, 0.14619392156601, 0.146044552326202, 0.145895153284073, 0.145745754241943, 0.145596399903297, 0.145447015762329, 0.145297631621361, 0.145148262381554, 0.144998922944069, 0.144849538803101, 0.144700169563293, 0.144550815224648, 0.144401460886002, 0.144252121448517, 0.144102737307549, 0.143953397870064, 0.14380407333374, 0.143654704093933, 0.143505364656448, 0.143356025218964, 0.143206685781479, 0.143057346343994, 0.142908021807671, 0.142758697271347, 0.142609372735023, 0.142460033297539, 0.142310708761215, 0.142161399126053, 0.142012089490891, 0.141862794756889, 0.141713500022888, 0.141564160585403, 0.141414865851402, 0.141265586018562, 0.141116261482239, 0.140966951847076, 0.140817672014236, 0.140668362379074, 0.140519082546234, 0.140369772911072, 0.140220493078232, 0.140071228146553, 0.139921933412552, 0.139772668480873, 0.139623388648033, 0.139474123716354, 0.139324858784676, 0.139175623655319, 0.139026328921318, 0.138879045844078, 0.138734325766563, 0.138589605689049, 0.138445034623146, 0.138300463557243, 0.138155996799469, 0.138011619448662, 0.137867271900177, 0.137722998857498, 0.137578800320625, 0.137434661388397, 0.137290596961975, 0.13714662194252, 0.137002676725388, 0.136858850717545, 0.136715054512024, 0.136571303009987, 0.136427640914917, 0.136284023523331, 0.136140525341034, 0.135997086763382, 0.135853677988052, 0.13571035861969, 0.135567128658295, 0.135423898696899, 0.135280817747116, 0.135137781500816, 0.134994789958, 0.134851858019829, 0.134709075093269, 0.134566277265549, 0.134423539042473, 0.134280949831009, 0.134138345718384, 0.133995816111565, 0.133853375911713, 0.133711010217667, 0.133568733930588, 0.133426502346992, 0.133284315466881, 0.133142217993736, 0.133000195026398, 0.132858231663704, 0.132716327905655, 0.132574498653412, 0.132432773709297, 0.132291078567505, 0.132149443030357, 0.132007881999016, 0.131866350769997, 0.131724938750267, 0.131583601236343, 0.131442293524742, 0.131301075220108, 0.131159961223602, 0.131018847227097, 0.13087785243988, 0.130736887454987, 0.13059601187706, 0.130455195903778, 0.130314469337463, 0.130173802375793, 0.130033195018768, 0.129892662167549, 0.129752188920975, 0.129611775279045, 0.129471451044083, 0.129331186413765, 0.12919095158577, 0.129050835967064, 0.128910779953003, 0.128770783543587, 0.128630787134171, 0.12849098443985, 0.128351166844368, 0.128211453557014, 0.128071784973145, 0.127932190895081, 0.127792716026306, 0.127653226256371, 0.127513810992241, 0.127374514937401, 0.127235278487206, 0.127096056938171, 0.126956969499588, 0.126817882061005, 0.126678913831711, 0.126539990305901, 0.126401171088219, 0.12626239657402, 0.126123651862144, 0.125985011458397, 0.125846445560455, 0.12570795416832, 0.125569492578506, 0.125431150197983, 0.12529282271862, 0.125154554843903, 0.125016450881958, 0.124878317117691, 0.124740272760391, 0.1246023401618, 0.124464437365532, 0.124326571822166, 0.124188862740993, 0.124051138758659, 0.123913511633873, 0.123775981366634, 0.123638428747654, 0.123501025140285, 0.123363733291626, 0.123226389288902, 0.123089164495468, 0.122952021658421, 0.122814930975437, 0.12267792224884, 0.122540958225727, 0.122404061257839, 0.122267283499241, 0.122130528092384, 0.121993847191334, 0.12185725569725, 0.121720723807812, 0.121584221720695, 0.121447831392288, 0.121311500668526, 0.121175236999989, 0.121039040386677, 0.12090290337801, 0.120766803622246, 0.120630815625191, 0.1204948797822, 0.120358996093273, 0.120223209261894, 0.120087459683418, 0.119951829314232, 0.119816213846207, 0.119680680334568, 0.119545243680477, 0.11940985172987, 0.119274526834488, 0.119139306247234, 0.119004100561142, 0.118868954479694, 0.118733942508698, 0.118598952889442, 0.118464015424252, 0.11832918971777, 0.118194431066513, 0.118059694766998, 0.117925018072128, 0.11779048293829, 0.117655947804451, 0.117521487176418, 0.117387138307095, 0.117252826690674, 0.11711860448122, 0.116984479129314, 0.116850353777409, 0.116716273128986, 0.116582311689854, 0.116448402404785, 0.116314604878426, 0.116180814802647, 0.116047114133835, 0.11591350287199, 0.11577994376421, 0.115646407008171, 0.115513011813164, 0.11537966132164, 0.115246348083019, 0.115113146603107, 0.114979967474937, 0.114846907556057, 0.114713907241821, 0.114580981433392, 0.114448055624962, 0.114315271377563, 0.114182531833649, 0.114049829542637, 0.113917209208012, 0.113784670829773, 0.113652184605598, 0.113519817590714, 0.113387420773506, 0.11325516551733, 0.11312297731638, 0.112990841269493, 0.112858794629574, 0.112726770341396, 0.112594813108444, 0.112462975084782, 0.112331159412861, 0.112199418246746, 0.112067796289921, 0.111936174333096, 0.111804641783237, 0.111673191189766, 0.11154180765152, 0.111410461366177, 0.111279234290123, 0.111148051917553, 0.111016899347305, 0.110885843634605, 0.110754892230034, 0.110623963177204, 0.110493116080761, 0.110362343490124, 0.11023161560297, 0.110100962221622, 0.109970338642597, 0.109839871525764, 0.109709389507771, 0.109579034149647, 0.109448753297329, 0.109318517148495, 0.109188310801983, 0.109058164060116, 0.108928196132183, 0.108798205852509, 0.108668312430382, 0.108538493514061, 0.108408734202385, 0.108279027044773, 0.108149401843548, 0.108019836246967, 0.107890300452709, 0.107760928571224, 0.107631541788578, 0.10750225186348, 0.107373051345348, 0.107243873178959, 0.107114762067795, 0.106985785067081, 0.106856793165207, 0.106727935373783, 0.106599129736423, 0.106470376253128, 0.1063417121768, 0.106213085353374, 0.106084495782852, 0.105956062674522, 0.105827614665031, 0.10569928586483, 0.105571024119854, 0.105442807078362, 0.105314664542675, 0.105186611413956, 0.105058588087559, 0.104930654168129, 0.104802802205086, 0.104675032198429, 0.104547269642353, 0.104419641196728, 0.104292042553425, 0.104164473712444, 0.104037061333656, 0.103909581899643, 0.103782296180725, 0.103655017912388, 0.103527814149857, 0.103400737047195, 0.103273674845695, 0.103146679699421, 0.103019781410694, 0.10289291292429, 0.102766111493111, 0.102639399468899, 0.102512776851654, 0.102386198937893, 0.102259688079357, 0.102133244276047, 0.102006867527962, 0.101880572736263, 0.101754307746887, 0.101628124713898, 0.101502023637295, 0.101376004517078, 0.101250000298023, 0.101124100387096, 0.100998289883137, 0.100872494280338, 0.100746810436249, 0.10062114149332, 0.100495614111423, 0.10037013143301, 0.100244671106339, 0.100119367241859, 0.0999940410256386, 0.0998687967658043, 0.0997436419129372, 0.0996185690164566, 0.0994935482740402, 0.0993685647845268, 0.0992437079548836, 0.0991188883781433, 0.0989941284060478, 0.0988694727420807, 0.098744809627533, 0.0986202880740166, 0.0984958559274673, 0.0983714163303375, 0.0982470586895943, 0.0981227979063988, 0.0979985669255257, 0.0978744328022003, 0.0977504104375839, 0.0976263284683228, 0.0975024178624153, 0.0973785221576691, 0.0972547009587288, 0.097131036221981, 0.0970073267817497, 0.0968837141990662, 0.0967602282762527, 0.0966367423534393, 0.0965133532881737, 0.0963900461792946, 0.0962667763233185, 0.0961435884237289, 0.0960204750299454, 0.0958973839879036, 0.0957744047045708, 0.0956515222787857, 0.0955286398530006, 0.0954058393836021, 0.095283143222332, 0.095160499215126, 0.0950378775596619, 0.0949154123663902, 0.0947928950190544, 0.0946705415844917, 0.0945482701063156, 0.0944259539246559, 0.0943038314580917, 0.0941817089915276, 0.0940596833825111, 0.0939377024769783, 0.0938158184289932, 0.0936939567327499, 0.0935721918940544, 0.0934504866600037, 0.0933288559317589, 0.0932073146104813, 0.0930858105421066, 0.0929643586277962, 0.0928430035710335, 0.0927217528223991, 0.092600479722023, 0.0924793258309364, 0.09235829859972, 0.0922372117638588, 0.0921162664890289, 0.0919953882694244, 0.0918745547533035, 0.0917538106441498, 0.091633103787899, 0.0915125012397766, 0.0913919433951378, 0.0912714675068855, 0.0911510288715363, 0.0910307094454765, 0.0909104123711586, 0.0907902047038078, 0.0906700864434242, 0.090549997985363, 0.0904300063848495, 0.0903100967407227, 0.0901902243494987, 0.0900703817605972, 0.0899506583809853, 0.0898309722542763, 0.0897113680839539, 0.0895918682217598, 0.0894723907113075, 0.0893529728055, 0.0892336741089821, 0.0891144201159477, 0.0889952033758163, 0.0888761058449745, 0.0887570157647133, 0.0886380448937416, 0.0885191112756729, 0.0884002223610878, 0.088281475007534, 0.088162750005722, 0.088044062256813, 0.0879255160689354, 0.0878070145845413, 0.087688535451889, 0.0875701755285263, 0.0874518528580666, 0.0873335972428322, 0.0872154384851456, 0.0870973467826843, 0.0869792476296425, 0.0868613123893738, 0.0867434218525887, 0.0866255536675453, 0.0865078270435333, 0.0863901153206825, 0.0862724781036377, 0.0861548855900764, 0.0860373750329018, 0.0859199613332748, 0.0858025923371315, 0.0856852680444717, 0.0855680853128433, 0.0854509174823761, 0.0853337943553925, 0.0852167904376984, 0.085099846124649, 0.0849829316139221, 0.0848661586642265, 0.0847494006156921, 0.0846326947212219, 0.0845160633325577, 0.0843995362520218, 0.0842830240726471, 0.0841665863990784, 0.0840502828359604, 0.0839340016245842, 0.0838177651166916, 0.0837016403675079, 0.0835855826735497, 0.0834695026278496, 0.0833536088466644, 0.0832377523183823, 0.0831219255924225, 0.0830061882734299, 0.0828904956579208, 0.0827749148011208, 0.0826593562960625, 0.0825438648462296, 0.082428514957428, 0.0823131874203682, 0.0821978971362114, 0.0820827260613441, 0.0819675996899605, 0.0818525180220604, 0.0817375481128693, 0.0816226080060005, 0.0815077275037766, 0.0813929811120033, 0.0812782570719719, 0.081163614988327, 0.0810490548610687, 0.080934539437294, 0.0808200687170029, 0.0807056874036789, 0.0805913507938385, 0.0804771110415459, 0.0803629755973816, 0.0802487805485725, 0.080134779214859, 0.0800207927823067, 0.0799068585038185, 0.0797930434346199, 0.0796792581677437, 0.0795655772089958, 0.0794519707560539, 0.0793383792042732, 0.0792248621582985, 0.0791114792227745, 0.0789980739355087, 0.0788847580552101, 0.0787715762853622, 0.0786583721637726, 0.0785452574491501, 0.0784322693943977, 0.0783193111419678, 0.078206405043602, 0.0780936107039452, 0.0779808610677719, 0.0778681486845016, 0.077755518257618, 0.0776429995894432, 0.0775305032730103, 0.0774180889129639, 0.0773057192564011, 0.0771934688091278, 0.0770812183618546, 0.0769690349698067, 0.0768569856882095, 0.0767450109124184, 0.0766330286860466, 0.076521135866642, 0.0764093697071075, 0.0762976333498955, 0.0761859267950058, 0.0760743543505669, 0.0759628117084503, 0.0758513510227203, 0.0757399573922157, 0.0756286382675171, 0.0755173563957214, 0.0754061713814735, 0.0752950087189674, 0.0751839503645897, 0.0750729739665985, 0.0749656930565834, 0.0748617351055145, 0.0747579261660576, 0.074654147028923, 0.074550449848175, 0.0744468942284584, 0.0743434354662895, 0.0742400139570236, 0.0741366967558861, 0.0740334689617157, 0.0739303454756737, 0.0738273039460182, 0.0737243369221687, 0.0736214444041252, 0.0735186561942101, 0.0734159350395203, 0.07331333309412, 0.073210820555687, 0.0731083899736404, 0.0730060413479805, 0.0729037597775459, 0.0728015303611755, 0.0726994723081589, 0.0725974589586258, 0.0724955126643181, 0.0723937451839447, 0.0722919777035713, 0.0721902847290039, 0.072088785469532, 0.0719872415065765, 0.0718858391046524, 0.0717845931649208, 0.0716833472251892, 0.071582168340683, 0.0714811980724335, 0.0713801980018616, 0.071279339492321, 0.0711786150932312, 0.0710778906941414, 0.0709772557020187, 0.0708767548203468, 0.0707763284444809, 0.0706759914755821, 0.0705757588148117, 0.0704755783081055, 0.0703754425048828, 0.0702754929661751, 0.0701755732297897, 0.0700758025050163, 0.0699760764837265, 0.069876417517662, 0.069776825606823, 0.069677360355854, 0.0695780217647552, 0.06947872787714, 0.0693795159459114, 0.0692804008722305, 0.069181352853775, 0.0690824165940285, 0.0689835697412491, 0.0688847675919533, 0.0687861293554306, 0.0686875581741333, 0.0685889795422554, 0.0684905648231506, 0.0683922916650772, 0.068294033408165, 0.0681958645582199, 0.0680978149175644, 0.0679998099803925, 0.0679018869996071, 0.0678041577339172, 0.0677064135670662, 0.0676087513566017, 0.0675112158060074, 0.0674137473106384, 0.0673163756728172, 0.0672191381454468, 0.0671218857169151, 0.0670248046517372, 0.0669277235865593, 0.0668308287858963, 0.0667339563369751, 0.066637210547924, 0.0665405616164207, 0.0664440020918846, 0.0663474500179291, 0.0662510693073273, 0.0661547407507896, 0.066058523952961, 0.0659623891115189, 0.0658663287758827, 0.065770335495472, 0.0656744390726089, 0.0655786916613579, 0.0654829517006874, 0.0653873682022095, 0.0652918517589569, 0.0651963576674461, 0.0651010200381279, 0.0650057345628738, 0.0649105757474899, 0.0648155137896538, 0.0647204741835594, 0.0646255239844322, 0.0645307302474976, 0.0644359365105629, 0.0643413290381432, 0.0642467588186264, 0.0641522631049156, 0.0640578344464302, 0.0639635175466537, 0.0638693422079086, 0.0637752041220665, 0.0636811330914497, 0.0635872110724449, 0.0634933188557625, 0.063399501144886, 0.0633058175444603, 0.0632122457027435, 0.0631187260150909, 0.0630252957344055, 0.0629319548606873, 0.0628385916352272, 0.062745489180088, 0.0626523792743683, 0.0625593960285187, 0.0624665506184101, 0.0623736381530762, 0.0622808858752251, 0.0621882900595665, 0.0620957165956497, 0.0620032139122486, 0.06191086769104, 0.0618185438215733, 0.0617263093590736, 0.0616342127323151, 0.0615421831607819, 0.0614502467215061, 0.061358354985714, 0.0612665936350822, 0.0611748844385147, 0.0610833056271076, 0.0609918236732483, 0.0609003789722919, 0.0608090087771416, 0.0607177726924419, 0.0606266260147095, 0.0605355463922024, 0.0604446083307266, 0.0603537298738956, 0.060262855142355, 0.0601721405982971, 0.0600815154612064, 0.0599909573793411, 0.0599005185067654, 0.0598101615905762, 0.0597198531031609, 0.0596296340227127, 0.0595395527780056, 0.0594495162367821, 0.0593595951795578, 0.0592697598040104, 0.0591799505054951, 0.0590902790427208, 0.0590006932616234, 0.0589112006127834, 0.0588218197226524, 0.0587324909865856, 0.0586432218551636, 0.0585540421307087, 0.0584650300443172, 0.0583760552108288, 0.0582871325314045, 0.0581983812153339, 0.0581095702946186, 0.0580209642648697, 0.057932436466217, 0.0578439868986607, 0.057755671441555, 0.0576673820614815, 0.0575791597366333, 0.0574910677969456, 0.0574030466377735, 0.0573151372373104, 0.0572273172438145, 0.0571395717561245, 0.0570518672466278, 0.0569642968475819, 0.0568768233060837, 0.0567894354462624, 0.0567021407186985, 0.0566149316728115, 0.0565277524292469, 0.0564407035708427, 0.0563537441194057, 0.0562668815255165, 0.0561800859868526, 0.0560933537781239, 0.0560067594051361, 0.0559202544391155, 0.0558337941765785, 0.0557474717497826, 0.0556611940264702, 0.0555749870836735, 0.0554889105260372, 0.0554029084742069, 0.0553170144557953, 0.055231187492609, 0.0551454313099384, 0.0550597682595253, 0.0549742169678211, 0.054888729006052, 0.0548033602535725, 0.0547180771827698, 0.054632842540741, 0.0545476973056793, 0.054462693631649, 0.0543777011334896, 0.0542928539216518, 0.0542081147432327, 0.0541234202682972, 0.054038729518652, 0.053954191505909, 0.0538698025047779, 0.0537854731082916, 0.0537012033164501, 0.0536170601844788, 0.0535329543054104, 0.053448960185051, 0.0533650889992714, 0.0532812550663948, 0.0531975328922272, 0.0531139560043812, 0.0530303232371807, 0.0529468357563019, 0.0528635196387768, 0.0527802146971226, 0.052697017788887, 0.0526139102876186, 0.0525308437645435, 0.0524479225277901, 0.0523650832474232, 0.0522822923958302, 0.0521996393799782, 0.0521170757710934, 0.0520345158874989, 0.0519521124660969, 0.0518697947263718, 0.0517875477671623, 0.05170539021492, 0.0516232810914516, 0.0515413284301758, 0.0514594465494156, 0.0513776279985905, 0.0512959249317646, 0.0512143149971962, 0.0511327013373375, 0.0510512925684452, 0.0509699247777462, 0.050888653844595, 0.0508074723184109, 0.050726380199194, 0.0506453104317188, 0.0505643784999847, 0.0504835806787014, 0.0504028052091599, 0.0503221452236176, 0.0502415746450424, 0.0501610040664673, 0.0500806607306004, 0.0500003397464752, 0.0499200597405434, 0.0498399883508682, 0.049759890884161, 0.0496798902750015, 0.0496000461280346, 0.0495202429592609, 0.0494405552744865, 0.0493609085679054, 0.0492813847959042, 0.049201924353838, 0.0491225756704807, 0.0490432940423489, 0.048964150249958, 0.0488850548863411, 0.0488060638308525, 0.0487271025776863, 0.0486482754349709, 0.0485695376992226, 0.0484908930957317, 0.0484123378992081, 0.0483338497579098, 0.0482554323971272, 0.0481771230697632, 0.0480989068746567, 0.0480208061635494, 0.0479427464306355, 0.0478648245334625, 0.0477869026362896, 0.047709122300148, 0.0476314462721348, 0.0475538447499275, 0.0474763363599777, 0.0473989136517048, 0.0473215281963348, 0.0472442656755447, 0.0471671372652054, 0.0470900535583496, 0.047013059258461, 0.0469361171126366, 0.046859297901392, 0.0467825569212437, 0.046705923974514, 0.0466293878853321, 0.046552911400795, 0.0464765056967735, 0.0464002192020416, 0.0463240183889866, 0.0462478660047054, 0.0461718887090683, 0.0460958890616894, 0.0460200048983097, 0.0459442846477032, 0.0458685830235481, 0.0457929708063602, 0.0457174740731716, 0.0456420667469501, 0.0455666817724705, 0.0454914532601833, 0.0454163178801537, 0.0453412272036076, 0.0452662706375122, 0.0451913811266422, 0.0451165214180946, 0.0450417920947075, 0.0449672006070614, 0.0448926314711571, 0.0448181927204132, 0.0447438545525074, 0.044669508934021, 0.0445953235030174, 0.0445212312042713, 0.0444472022354603, 0.044373270124197, 0.0442994423210621, 0.0442256480455399, 0.0441519841551781, 0.0440784096717834, 0.0440049022436142, 0.0439315102994442, 0.0438582114875317, 0.0437849014997482, 0.0437117628753185, 0.0436387360095978, 0.0435657724738121, 0.0434929020702839, 0.0434201136231422, 0.0433473363518715, 0.0432747378945351, 0.043202206492424, 0.0431297644972801, 0.0430573895573616, 0.0429851561784744, 0.0429129377007484, 0.042840838432312, 0.0427687764167786, 0.0426969043910503, 0.0426250547170639, 0.0425532683730125, 0.0424816645681858, 0.0424100421369076, 0.0423385724425316, 0.0422671735286713, 0.0421958863735199, 0.0421245992183685, 0.0420534946024418, 0.0419824346899986, 0.0419114865362644, 0.0418406315147877, 0.0417698211967945, 0.0416991002857685, 0.0416284948587418, 0.0415579788386822, 0.0414875745773315, 0.0414172150194645, 0.0413469709455967, 0.0412767492234707, 0.0412066839635372, 0.0411366894841194, 0.0410667844116688, 0.0409969463944435, 0.0409272238612175, 0.0408575460314751, 0.0407879576086998, 0.0407185070216656, 0.0406491421163082, 0.0405798517167568, 0.0405106469988823, 0.0404414907097816, 0.0403724238276482, 0.0403034910559654, 0.0402346514165401, 0.0401658788323402, 0.0400972180068493, 0.0400285571813583, 0.0399600565433502, 0.0398916490375996, 0.039823304861784, 0.0397550761699677, 0.0396869145333767, 0.0396187976002693, 0.039550818502903, 0.0394829288125038, 0.0394151322543621, 0.0393474213778973, 0.0392797812819481, 0.0392121858894825, 0.0391446799039841, 0.0390773825347424, 0.0390100330114365, 0.0389428474009037, 0.038875725120306, 0.038808673620224, 0.0387417376041412, 0.0386748872697353, 0.0386081524193287, 0.0385414659976959, 0.0384748429059982, 0.0384083576500416, 0.0383419394493103, 0.0382756106555462, 0.0382093749940395, 0.0381432510912418, 0.0380771309137344, 0.0380111858248711, 0.0379452891647816, 0.0378794856369495, 0.0378137901425362, 0.0377481654286385, 0.0376825854182243, 0.037617139518261, 0.037551786750555, 0.0374865010380745, 0.0374213308095932, 0.0373562499880791, 0.0372911654412746, 0.0372262857854366, 0.0371614322066307, 0.037096694111824, 0.0370320416986942, 0.0369674786925316, 0.036902941763401, 0.0368385389447212, 0.0367742255330086, 0.0367100313305855, 0.0366458743810654, 0.0365818366408348, 0.0365178436040878, 0.0364539623260498, 0.0363901928067207, 0.036326490342617, 0.0362628810107708, 0.0361993610858917, 0.0361358858644962, 0.0360724851489067, 0.0360092595219612, 0.0359461046755314, 0.0358829461038113, 0.0358200147747993, 0.0357570387423038, 0.0356942005455494, 0.0356314517557621, 0.0355688109993935, 0.0355062671005726, 0.0354437902569771, 0.0353813581168652, 0.0353190377354622, 0.0352568551898003, 0.0351947210729122, 0.035132672637701, 0.0350707359611988, 0.0350088253617287, 0.0349470749497414, 0.0348853878676891, 0.0348237939178944, 0.034762267023325, 0.0347008556127548, 0.0346394665539265, 0.0345782339572906, 0.0345170684158802, 0.0344559960067272, 0.0343950130045414, 0.0343341194093227, 0.0342732705175877, 0.0342125371098518, 0.0341518968343735, 0.0340913683176041, 0.0340308807790279, 0.0339704640209675, 0.03391208127141, 0.0338554456830025, 0.0337988771498203, 0.0337423793971539, 0.0336859486997128, 0.0336295142769814, 0.0335731953382492, 0.0335169695317745, 0.0334607884287834, 0.0334046743810177, 0.0333486497402191, 0.0332926027476788, 0.0332366935908794, 0.0331808738410473, 0.0331250317394733, 0.0330693237483501, 0.0330137088894844, 0.0329580456018448, 0.0329025201499462, 0.0328470431268215, 0.0327916517853737, 0.0327363274991512, 0.0326810777187347, 0.032625824213028, 0.0325706824660301, 0.0325156301259995, 0.0324606038630009, 0.0324056670069695, 0.0323507972061634, 0.0322959534823895, 0.0322411954402924, 0.0321865081787109, 0.0321319103240967, 0.0320773608982563, 0.032022874802351, 0.0319684185087681, 0.0319140441715717, 0.0318597629666328, 0.0318055525422096, 0.0317513644695282, 0.0316972658038139, 0.0316432304680347, 0.0315892472863197, 0.0315353311598301, 0.0314815267920494, 0.0314277671277523, 0.0313740558922291, 0.0313203632831573, 0.0312667824327946, 0.0312132742255926, 0.0311598554253578, 0.0311064813286066, 0.031053151935339, 0.0309998672455549, 0.0309466738253832, 0.030893549323082, 0.0308405160903931, 0.0307875238358974, 0.030734583735466, 0.0306817293167114, 0.0306288972496986, 0.03057617880404, 0.0305235311388969, 0.0304709263145924, 0.0304183904081583, 0.0303658731281757, 0.0303134750574827, 0.0302611421793699, 0.0302088558673859, 0.0301567036658525, 0.0301045291125774, 0.0300523769110441, 0.0300004091113806, 0.0299484599381685, 0.0298965591937304, 0.029844768345356, 0.029792957007885, 0.0297412816435099, 0.0296896975487471, 0.0296381115913391, 0.0295866392552853, 0.0295352134853601, 0.0294838082045317, 0.0294324941933155, 0.0293812938034534, 0.0293301157653332, 0.0292790085077286, 0.0292280111461878, 0.0291769914329052, 0.0291260611265898, 0.0290752481669188, 0.0290244575589895, 0.028973750770092, 0.0289231166243553, 0.0288725085556507, 0.028821986168623, 0.0287715569138527, 0.0287211462855339, 0.0286708325147629, 0.0286205597221851, 0.0285703539848328, 0.0285202190279961, 0.0284701511263847, 0.0284201726317406, 0.0283702425658703, 0.0283203776925802, 0.0282705575227737, 0.0282208304852247, 0.0281711686402559, 0.028121579438448, 0.0280720293521881, 0.0280225519090891, 0.0279731173068285, 0.0279237739741802, 0.0278744734823704, 0.0278252903372049, 0.0277761295437813, 0.0277270320802927, 0.0276780072599649, 0.0276290494948626, 0.0275801569223404, 0.0275313556194305, 0.0274825803935528, 0.027433892711997, 0.0273852292448282, 0.0273366775363684, 0.0272881723940372, 0.0272397603839636, 0.0271913893520832, 0.0271430872380733, 0.0270948093384504, 0.0270466655492783, 0.0269985217601061, 0.026950515806675, 0.0269025303423405, 0.0268546156585217, 0.0268067643046379, 0.0267589595168829, 0.026711268350482, 0.0266636237502098, 0.0266160257160664, 0.0265685170888901, 0.0265210065990686, 0.0264736320823431, 0.0264263283461332, 0.02637904509902, 0.0263318549841642, 0.02628468349576, 0.0262376274913549, 0.0261906404048204, 0.0261436961591244, 0.0260968450456858, 0.0260500367730856, 0.0260032750666142, 0.0259566027671099, 0.0259099807590246, 0.0258634407073259, 0.0258169751614332, 0.0257705524563789, 0.0257241744548082, 0.025677889585495, 0.025631669908762, 0.0255855210125446, 0.0255394373089075, 0.0254934225231409, 0.0254474338144064, 0.0254015754908323, 0.0253557190299034, 0.0253099538385868, 0.0252643004059792, 0.0252186506986618, 0.0251730419695377, 0.0251275505870581, 0.0250821001827717, 0.025036720559001, 0.0249914508312941, 0.0249461848288774, 0.0249009840190411, 0.0248558986932039, 0.0248108338564634, 0.0247658416628838, 0.0247209593653679, 0.0246760975569487, 0.0246312823146582, 0.0245865825563669, 0.0245419032871723, 0.0244972929358482, 0.02445281855762, 0.0244083236902952, 0.0243638921529055, 0.024319576099515, 0.0242753066122532, 0.0242311246693134, 0.0241870116442442, 0.0241429228335619, 0.0240988545119762, 0.0240549463778734, 0.0240110605955124, 0.0239672642201185, 0.0239235386252403, 0.0238798782229424, 0.0238361973315477, 0.0237926729023457, 0.0237491484731436, 0.0237057618796825, 0.023662393912673, 0.0236191190779209, 0.0235758703202009, 0.0235327072441578, 0.0234896615147591, 0.02344661206007, 0.0234036315232515, 0.0233607646077871, 0.0233178772032261, 0.0232751220464706, 0.0232324376702309, 0.0231897942721844, 0.0231471993029118, 0.0231047421693802, 0.0230622123926878, 0.0230198446661234, 0.0229775458574295, 0.0229353103786707, 0.0228931251913309, 0.0228509809821844, 0.0228089280426502, 0.0227669235318899, 0.0227250512689352, 0.0226832032203674, 0.0226413793861866, 0.0225996430963278, 0.0225579775869846, 0.0225163791328669, 0.0224748477339745, 0.0224333833903074, 0.022392014041543, 0.0223506186157465, 0.022309361025691, 0.0222681425511837, 0.0222269967198372, 0.022185942158103, 0.0221449546515942, 0.0221039466559887, 0.0220630951225758, 0.0220222659409046, 0.0219815280288458, 0.0219408553093672, 0.0219002310186625, 0.0218596272170544, 0.0218191631138325, 0.0217787642031908, 0.0217383876442909, 0.0216981023550034, 0.0216578859835863, 0.021617665886879, 0.0215776078402996, 0.0215375497937202, 0.021497605368495, 0.0214577242732048, 0.0214178692549467, 0.0213780608028173, 0.0213383659720421, 0.0212987121194601, 0.0212591513991356, 0.0212196595966816, 0.0211801901459694, 0.0211407858878374, 0.0211014524102211, 0.021062208339572, 0.0210230331867933, 0.0209839250892401, 0.0209448616951704, 0.0209058225154877, 0.0208669174462557, 0.0208280365914106, 0.0207892451435328, 0.0207505449652672, 0.0207118690013885, 0.0206732582300901, 0.020634738728404, 0.0205962434411049, 0.0205578356981277, 0.0205195210874081, 0.020481251180172, 0.020442983135581, 0.0204048473387957, 0.020366782322526, 0.0203287601470947, 0.0202908311039209, 0.0202529449015856, 0.0202150829136372, 0.0201773345470428, 0.0201396532356739, 0.0201020389795303, 0.0200644936412573, 0.0200269483029842, 0.0199895389378071, 0.0199521742761135, 0.0199148561805487, 0.019877627491951, 0.0198404882103205, 0.0198033507913351, 0.0197662822902203, 0.019729370251298, 0.019692437723279, 0.0196555927395821, 0.0196188408881426, 0.019582087174058, 0.0195454023778439, 0.0195088759064674, 0.019472349435091, 0.0194359142333269, 0.0193995460867882, 0.0193631555885077, 0.019326901063323, 0.0192907378077507, 0.0192545726895332, 0.0192185454070568, 0.0191825833171606, 0.0191465802490711, 0.019110755994916, 0.0190749298781157, 0.0190391968935728, 0.0190035309642553, 0.0189679563045502, 0.0189323574304581, 0.0188968740403652, 0.0188614781945944, 0.0188261289149523, 0.0187908504158258, 0.0187556818127632, 0.018720468506217, 0.0186853930354118, 0.0186503827571869, 0.0186154413968325, 0.018580524250865, 0.0185457393527031, 0.0185109134763479, 0.0184762198477983, 0.0184416174888611, 0.0184070616960526, 0.0183725748211145, 0.018338130787015, 0.0183037556707859, 0.0182694252580404, 0.0182352084666491, 0.0182010382413864, 0.0181669350713491, 0.0181328542530537, 0.0180988851934671, 0.0180649645626545, 0.018031133338809, 0.0179973915219307, 0.0179636273533106, 0.0179299544543028, 0.0178963951766491, 0.0178628340363503, 0.0178294125944376, 0.0177960339933634, 0.0177627000957727, 0.0177293885499239, 0.0176962148398161, 0.0176630616188049, 0.0176300220191479, 0.0175970066338778, 0.0175641253590584, 0.0175311993807554, 0.0174983646720648, 0.0174656640738249, 0.0174329653382301, 0.0174003802239895, 0.0173678379505873, 0.0173352975398302, 0.0173029154539108, 0.0172705557197332, 0.017238287255168, 0.0172060411423445, 0.0171739291399717, 0.0171417742967606, 0.0171097535640001, 0.0170778464525938, 0.0170459412038326, 0.0170141011476517, 0.016982352361083, 0.0169506054371595, 0.016918970271945, 0.0168874487280846, 0.0168559029698372, 0.0168244950473309, 0.0167931318283081, 0.0167617686092854, 0.0167305190116167, 0.016699381172657, 0.0166682451963425, 0.0166371986269951, 0.01660624332726, 0.0165752880275249, 0.016544422134757, 0.0165136698633432, 0.0164829175919294, 0.0164522584527731, 0.0164217315614223, 0.0163911152631044, 0.0163606591522694, 0.0163303129374981, 0.016299968585372, 0.0162696931511164, 0.0162394847720861, 0.0162093453109264, 0.0161792486906052, 0.0161493122577667, 0.0161193292587996, 0.0160894393920898, 0.0160596370697021, 0.0160298813134432, 0.0160001944750547, 0.0159706436097622, 0.0159410461783409, 0.0159115400165319, 0.0158821474760771, 0.0158527549356222, 0.0158234518021345, 0.0157942846417427, 0.0157650951296091, 0.0157359950244427, 0.0157069656997919, 0.0156780015677214, 0.0156491082161665, 0.0156203033402562, 0.0155915217474103, 0.0155628072097898, 0.0155341625213623, 0.0155055830255151, 0.0154770510271192, 0.0154486540704966, 0.015420257113874, 0.0153919514268637, 0.015363690443337, 0.0153354732319713, 0.0153073947876692, 0.0152793601155281, 0.0152513710781932, 0.0152234490960836, 0.0151955522596836, 0.0151677653193474, 0.0151400258764625, 0.0151123767718673, 0.0150847947224975, 0.0150572806596756, 0.0150297889485955, 0.015002366155386, 0.0149750346317887, 0.0149477925151587, 0.0149205736815929, 0.0148934433236718, 0.0148663390427828, 0.0148393232375383, 0.0148123763501644, 0.0147855412214994, 0.0147586837410927, 0.0147318718954921, 0.0147052425891161, 0.014678611420095, 0.0146520705893636, 0.0146255772560835, 0.014599172398448, 0.0145727451890707, 0.0145465014502406, 0.0145202549174428, 0.0144940996542573, 0.0144680142402649, 0.0144419707357883, 0.0144159970805049, 0.0143900690600276, 0.0143642323091626, 0.0143384849652648, 0.0143127590417862, 0.0142871253192425, 0.0142615139484406, 0.0142359919846058, 0.0142105855047703, 0.0141851995140314, 0.0141598824411631, 0.0141346119344234, 0.0141094066202641, 0.0140842935070395, 0.014059248380363, 0.0140342488884926, 0.0140093388035893, 0.0139844520017505, 0.0139596555382013, 0.0139349270612001, 0.0139102442190051, 0.0138856740668416, 0.013861128129065, 0.0138366715982556, 0.0138122383505106, 0.0137878935784101, 0.0137636410072446, 0.0137394340708852, 0.0137146096676588, 0.0136893149465322, 0.0136640891432762, 0.0136388624086976, 0.0136136915534735, 0.0135885681957006, 0.0135634317994118, 0.0135383857414126, 0.0135133415460587, 0.0134883187711239, 0.0134633406996727, 0.0134383859112859, 0.0134134646505117, 0.0133886113762856, 0.0133637590333819, 0.0133389523252845, 0.0133142005652189, 0.0132894273847342, 0.0132647212594748, 0.0132400384172797, 0.0132154002785683, 0.0131908087059855, 0.0131662050262094, 0.0131416795775294, 0.0131171559914947, 0.0130926426500082, 0.013068231754005, 0.0130437985062599, 0.0130194080993533, 0.0129950884729624, 0.0129707679152489, 0.0129464697092772, 0.0129222394898534, 0.0128980204463005, 0.0128738237544894, 0.0128496838733554, 0.0128255682066083, 0.0128014618530869, 0.0127774467691779, 0.0127534316852689, 0.0127294287085533, 0.0127054927870631, 0.0126815568655729, 0.012657655403018, 0.0126338321715593, 0.0126099986955523, 0.0125862322747707, 0.0125624556094408, 0.0125387459993362, 0.012515059672296, 0.0124914068728685, 0.012467797845602, 0.0124442027881742, 0.0124206524342299, 0.0123971467837691, 0.012373642064631, 0.0123501587659121, 0.0123267667368054, 0.0123033737763762, 0.0122800264507532, 0.0122567256912589, 0.0122334007173777, 0.0122101660817862, 0.0121869333088398, 0.0121637340635061, 0.0121405562385917, 0.0121174696832895, 0.0120943831279874, 0.0120713086798787, 0.0120482789352536, 0.0120252938941121, 0.0120023200288415, 0.0119794374331832, 0.0119565203785896, 0.0119336610659957, 0.0119108455255628, 0.0118880420923233, 0.01186528429389, 0.0118425711989403, 0.0118198804557323, 0.011797190643847, 0.0117745921015739, 0.0117519916966558, 0.0117293912917376, 0.011706905439496, 0.0116843841969967, 0.0116619104519486, 0.0116395354270935, 0.011617106385529, 0.0115947332233191, 0.0115724401548505, 0.0115500995889306, 0.0115278735756874, 0.0115056484937668, 0.0114834439009428, 0.0114612746983767, 0.0114391278475523, 0.0114170257002115, 0.0113949477672577, 0.0113729359582067, 0.01135094743222, 0.0113289598375559, 0.0113070625811815, 0.0112851411104202, 0.0112632671371102, 0.0112414602190256, 0.0112196411937475, 0.0111978687345982, 0.0111761409789324, 0.0111544355750084, 0.0111327869817615, 0.0111111383885145, 0.0110895335674286, 0.0110679538920522, 0.0110464291647077, 0.011024939827621, 0.0110034374520183, 0.0109820161014795, 0.0109606171026826, 0.0109392162412405, 0.0109179187566042, 0.0108966212719679, 0.0108753126114607, 0.0108541175723076, 0.0108328871428967, 0.0108117256313562, 0.0107905864715576, 0.0107694696635008, 0.0107483994215727, 0.0107273953035474, 0.0107063362374902, 0.0106853889301419, 0.0106644425541162, 0.0106435418128967, 0.0106226401403546, 0.0106018297374249, 0.0105810184031725, 0.0105602080002427, 0.0105395102873445, 0.0105187790468335, 0.0104980925098062, 0.0104774627834558, 0.0104568563401699, 0.010436293669045, 0.010415755212307, 0.010395216755569, 0.0103747677057981, 0.010354308411479, 0.0103339171037078, 0.0103135127574205, 0.0102931782603264, 0.0102728875353932, 0.0102525763213634, 0.0102323535829782, 0.0102121206000447, 0.0101919546723366, 0.0101718120276928, 0.010151669383049, 0.0101315844804049, 0.0101115424185991, 0.0100915469229221, 0.0100715747103095, 0.0100516015663743, 0.010031696408987, 0.0100118145346642, 0.00999195408076048, 0.0099721634760499, 0.00995235983282328, 0.00993260182440281, 0.00991290062665939, 0.00989322271198034, 0.00987356621772051, 0.00985393300652504, 0.00983434543013573, 0.00981481373310089, 0.00979528296738863, 0.00977580808103085, 0.00975635554641485, 0.00973694957792759, 0.00971754267811775, 0.00969820376485586, 0.00967889837920666, 0.00965959392488003, 0.00964032299816608, 0.00962112005800009, 0.00960194040089846, 0.00958277098834515, 0.00956367049366236, 0.00954456906765699, 0.00952551234513521, 0.00950649101287127, 0.00948749203234911, 0.00946853775531054, 0.00944961793720722, 0.00943074375391006, 0.00941186957061291, 0.00939304009079933, 0.0093742785975337, 0.00935551710426807, 0.00933677796274424, 0.00931808538734913, 0.00929942540824413, 0.0092807887122035, 0.00926222000271082, 0.00924366246908903, 0.00922512728720903, 0.00920664984732866, 0.00918819289654493, 0.00916976016014814, 0.00915138423442841, 0.00913300830870867, 0.00911464262753725, 0.00909639056771994, 0.00907811615616083, 0.00905988737940788, 0.00904170237481594, 0.00902352947741747, 0.00900540314614773, 0.00898728705942631, 0.00896923895925283, 0.00895123649388552, 0.00893321074545383, 0.0089152529835701, 0.00889731850475073, 0.00887940544635057, 0.0088615957647562, 0.00884372927248478, 0.00882592983543873, 0.0088081881403923, 0.00879042316228151, 0.0087727252393961, 0.0087550850585103, 0.00873744487762451, 0.00871982704848051, 0.00870228838175535, 0.00868474971503019, 0.0086672455072403, 0.00864978600293398, 0.00863233767449856, 0.00861493498086929, 0.00859760027378798, 0.00858024321496487, 0.00856291968375444, 0.00854568649083376, 0.00852843094617128, 0.00851122103631496, 0.0084940567612648, 0.00847691390663385, 0.00845981761813164, 0.00844273157417774, 0.00842572562396526, 0.00840872991830111, 0.00839170068502426, 0.00837478507310152, 0.00835789181292057, 0.00834099855273962, 0.00832420773804188, 0.00830737128853798, 0.00829060189425945, 0.00827387906610966, 0.00825714413076639, 0.00824046693742275, 0.00822385679930449, 0.00820723455399275, 0.00819064769893885, 0.00817412789911032, 0.00815762020647526, 0.00814113393425941, 0.0081246942281723, 0.0081082982942462, 0.00809192657470703, 0.00807559955865145, 0.00805926136672497, 0.00804299023002386, 0.00802675448358059, 0.00801054108887911, 0.00799434911459684, 0.00797820370644331, 0.00796211417764425, 0.00794600322842598, 0.0079299695789814, 0.00791398249566555, 0.0078979954123497, 0.00788204185664654, 0.00786613300442696, 0.00785023625940084, 0.00783440750092268, 0.00781857874244452, 0.00780279515311122, 0.00778705673292279, 0.00777135277166963, 0.00775564881041646, 0.00774002354592085, 0.00772442109882832, 0.00770881911739707, 0.00769326137378812, 0.00767777254804969, 0.00766228325664997, 0.00764681678265333, 0.00763144064694643, 0.00761601887643337, 0.0076006893068552, 0.00758540350943804, 0.00757005019113421, 0.00755482167005539, 0.00753963738679886, 0.00752443168312311, 0.00750929350033402, 0.00749416695907712, 0.0074790739454329, 0.00746401492506266, 0.00744903506711125, 0.00743399932980537, 0.00741905346512794, 0.00740417512133718, 0.0073892530053854, 0.00737439794465899, 0.00735961040481925, 0.00734477723017335, 0.00733002461493015, 0.00731536187231541, 0.00730064325034618, 0.00728596886619925, 0.00727137411013246, 0.00725677935406566, 0.00724219623953104, 0.00722770299762487, 0.0072131878696382, 0.0071987179107964, 0.00718433782458305, 0.00716995866969228, 0.00715555623173714, 0.00714127859100699, 0.00712697859853506, 0.00711268885061145, 0.00709850247949362, 0.00708429189398885, 0.0070701171644032, 0.00705602066591382, 0.00704192370176315, 0.00702783837914467, 0.00701384386047721, 0.00699984980747104, 0.00698585482314229, 0.00697195064276457, 0.00695806974545121, 0.00694416603073478, 0.0069303740747273, 0.00691658351570368, 0.00690277060493827, 0.00688909320160747, 0.0068753925152123, 0.00686170347034931, 0.00684810522943735, 0.00683448417112231, 0.00682092038914561, 0.00680738966912031, 0.00679389340803027, 0.0067804423160851, 0.00676701404154301, 0.0067536192946136, 0.00674024736508727, 0.00672693224623799, 0.00671361712738872, 0.00670034717768431, 0.00668713357299566, 0.00667391996830702, 0.00666074082255363, 0.00664762873202562, 0.00663451757282019, 0.00662145158275962, 0.00660843076184392, 0.00659543229267001, 0.0065824338234961, 0.00656950427219272, 0.00655663060024381, 0.0065437569282949, 0.00653089443221688, 0.00651809992268682, 0.00650532776489854, 0.00649261334910989, 0.00647990917786956, 0.00646721664816141, 0.00645460328087211, 0.00644197873771191, 0.00642941100522876, 0.0064168768003583, 0.00640435377135873, 0.00639191037043929, 0.00637944415211678, 0.00636705802753568, 0.0063546821475029, 0.00634232955053449, 0.00633004447445273, 0.00631775986403227, 0.00630549713969231, 0.00629332568496466, 0.00628114258870482, 0.00626899348571897, 0.00625690165907145, 0.00624480890110135, 0.00623277295380831, 0.00622077099978924, 0.00620879232883453, 0.00619685789570212, 0.00618494674563408, 0.00617306958884001, 0.00616120360791683, 0.0061494167894125, 0.00613764114677906, 0.00612586596980691, 0.00611418159678578, 0.0061024958267808, 0.00609083427116275, 0.00607924023643136, 0.00606764620169997, 0.00605611968785524, 0.00604459270834923, 0.00603311229497194, 0.00602167565375566, 0.00601026322692633, 0.00599889596924186, 0.00598752778023481, 0.00597620522603393, 0.00596492784097791, 0.00595367373898625, 0.00594246387481689, 0.00593130011111498, 0.00592013634741306, 0.00590901728719473, 0.00589794386178255, 0.00588689325377345, 0.00587586546316743, 0.00586488237604499, 0.00585394445806742, 0.0058430302888155, 0.00583216082304716, 0.00582129135727882, 0.00581046612933278, 0.00579970981925726, 0.00578893115743995, 0.0057782088406384, 0.00576754286885262, 0.00575686618685722, 0.00574626820161939, 0.00573566975072026, 0.00572511786594987, 0.00571458740159869, 0.00570409232750535, 0.00569366384297609, 0.00568322464823723, 0.00567283062264323, 0.00566250458359718, 0.00565217854455113, 0.00564187439158559, 0.00563162798061967, 0.00562138156965375, 0.00561120174825191, 0.00560105685144663, 0.00559092313051224, 0.005580835044384, 0.00557078048586845, 0.00556077156215906, 0.00555076263844967, 0.00554082123562694, 0.00553088029846549, 0.00552099570631981, 0.00551115674898028, 0.00550129450857639, 0.00549151236191392, 0.00548177491873503, 0.00547203700989485, 0.00546234520152211, 0.00545266456902027, 0.00544305192306638, 0.00543345045298338, 0.00542389415204525, 0.00541438302025199, 0.00540488306432962, 0.00539540639147162, 0.00538598652929068, 0.00537658855319023, 0.00536721386015415, 0.00535789504647255, 0.00534858787432313, 0.00533933751285076, 0.00533012114465237, 0.00532090477645397, 0.00531175592914224, 0.0053026070818305, 0.00529351551085711, 0.0052844462916255, 0.00527541106566787, 0.005266432184726, 0.00525743095204234, 0.00524853076785803, 0.0052396091632545, 0.00523073226213455, 0.00522192334756255, 0.00521311443299055, 0.00520337140187621, 0.0051925415173173, 0.0051817400380969, 0.00517095532268286, 0.00516015943139791, 0.00514940312132239, 0.00513865193352103, 0.00512790121138096, 0.00511717889457941, 0.00510647334158421, 0.00509577337652445, 0.00508507387712598, 0.00507440790534019, 0.00506376521661878, 0.00505309924483299, 0.00504249008372426, 0.00503187533468008, 0.0050212605856359, 0.00501068541780114, 0.00500011024996638, 0.00498955184593797, 0.00497901625931263, 0.00496847508475184, 0.00495796790346503, 0.00494744908064604, 0.0049369758926332, 0.00492651388049126, 0.00491605186834931, 0.00490557868033648, 0.00489515066146851, 0.00488475104793906, 0.00487431697547436, 0.0048639397136867, 0.00485356897115707, 0.00484322570264339, 0.00483285402879119, 0.00482253916561604, 0.00481220195069909, 0.00480188149958849, 0.00479160621762276, 0.00478131975978613, 0.00477106729522347, 0.00476079760119319, 0.00475056795403361, 0.00474035507068038, 0.00473013613373041, 0.00471994606778026, 0.00470976158976555, 0.00469958828762174, 0.004689437802881, 0.00467930408194661, 0.00466916477307677, 0.00465904828161001, 0.00464896531775594, 0.00463888794183731, 0.00462880590930581, 0.00461873970925808, 0.00460870284587145, 0.00459868228062987, 0.00458866730332375, 0.00457867560908198, 0.00456869462504983, 0.00455871364101768, 0.00454876152798533, 0.0045388201251626, 0.00452889082953334, 0.00451894896104932, 0.00450906483456492, 0.00449918024241924, 0.00448929006233811, 0.00447943946346641, 0.00446961168199778, 0.00445977784693241, 0.00444994401186705, 0.00444015627726912, 0.00443036202341318, 0.00442057941108942, 0.00441080797463655, 0.00440107099711895, 0.00439132191240788, 0.00438161892816424, 0.00437190430238843, 0.00436221761628985, 0.00435253139585257, 0.00434287311509252, 0.00433322647586465, 0.00432357983663678, 0.00431395554915071, 0.00430435407906771, 0.00429474143311381, 0.00428516231477261, 0.00427560601383448, 0.00426606694236398, 0.0042565162293613, 0.00424698879942298, 0.00423749489709735, 0.00422800052911043, 0.00421849545091391, 0.00420904671773314, 0.00419958680868149, 0.00419013248756528, 0.00418072380125523, 0.0041713030077517, 0.00416190596297383, 0.00415251357480884, 0.00414314400404692, 0.00413379212841392, 0.00412442814558744, 0.00411512656137347, 0.00410579703748226, 0.00409649545326829, 0.0040872055105865, 0.0040779379196465, 0.00406867638230324, 0.00405942555516958, 0.00405020359903574, 0.00404098723083735, 0.0040317764505744, 0.00402257684618235, 0.00401340564712882, 0.00400424003601074, 0.00399509165436029, 0.00398596562445164, 0.00397686194628477, 0.0039677363820374, 0.00395864993333817, 0.00394957512617111, 0.00394049426540732, 0.0039314478635788, 0.00392243498936296, 0.00391341047361493, 0.00390438688918948, 0.0038954084739089, 0.00388642377220094, 0.0038774621207267, 0.00386849464848638, 0.00385956675745547, 0.00385063886642456, 0.00384172797203064, 0.00383284012787044, 0.00382394599728286, 0.0038150807376951, 0.00380622083321214, 0.0037974005099386, 0.00378856901079416, 0.00377973751164973, 0.00377095141448081, 0.00376215949654579, 0.00375339016318321, 0.00374463223852217, 0.00373589689843357, 0.00372714432887733, 0.003718426451087, 0.00370974163524806, 0.0037010689266026, 0.00369238434359431, 0.00368372281081975, 0.00367510644719005, 0.00366644468158484, 0.00365782831795514, 0.00364923430606723, 0.0036406519357115, 0.0036320467479527, 0.0036235039588064, 0.00361497839912772, 0.00360643537715077, 0.00359792076051235, 0.00358941173180938, 0.00358092598617077, 0.00357242836616933, 0.00356396497227252, 0.00355552975088358, 0.00354709406383336, 0.00353867001831532, 0.003530269023031, 0.00352186779491603, 0.00351347774267197, 0.00350511050783098, 0.00349676585756242, 0.00348841538652778, 0.0034801047295332, 0.00347179966047406, 0.00346349459141493, 0.00345520651899278, 0.00344695243984461, 0.00343868136405945, 0.00343044428154826, 0.00342221860773861, 0.00341403228230774, 0.00340580078773201, 0.00339762587100267, 0.00338947377167642, 0.00338131585158408, 0.00337316375225782, 0.00336503423750401, 0.00335692171938717, 0.00334879220463336, 0.00334073626436293, 0.00333266844972968, 0.00332461856305599, 0.00331655121408403, 0.00330852926708758, 0.00330050708726048, 0.00329250795766711, 0.00328452559188008, 0.00327654904685915, 0.00326859462074935, 0.0032606350723654, 0.00325272069312632, 0.00324479467235506, 0.00323688052594662, 0.00322898314334452, 0.00322110834531486, 0.00321325031109154, 0.00320539250969887, 0.00319756870158017, 0.00318974512629211, 0.00318194390274584, 0.00317414267919958, 0.00316636962816119, 0.003158591222018, 0.0031508409883827, 0.00314313056878746, 0.00313540827482939, 0.00312767503783107, 0.00311997579410672, 0.00311231054365635, 0.00310462270863354, 0.00309696840122342, 0.00308934831991792, 0.00308171706274152, 0.00307409116066992, 0.00306652230210602, 0.00305893598124385, 0.0030513727106154, 0.00304379826411605, 0.00303626852110028, 0.00302873901091516, 0.00302120973356068, 0.00301372539252043, 0.00300623546354473, 0.00299875717610121, 0.00299129565246403, 0.00298385112546384, 0.00297642359510064, 0.00296901306137443, 0.00296160811558366, 0.00295421457849443, 0.00294684362597764, 0.00293948384933174, 0.00293214665725827, 0.00292478734627366, 0.00291747832670808, 0.00291019235737622, 0.00290287821553648, 0.0028956204187125, 0.00288835144601762, 0.00288112205453217, 0.00287387007847428, 0.00286664627492428, 0.00285944528877735, 0.00285226106643677, 0.00284505402669311, 0.00283791543915868, 0.00283076521009207, 0.00282360962592065, 0.00281650456599891, 0.00280939973890781, 0.00280228932388127, 0.0027952182572335, 0.00278814160265028, 0.00278110476210713, 0.00277405069209635, 0.00276703643612564, 0.00276002218015492, 0.00275301933288574, 0.00274603883735836, 0.0027390702161938, 0.00273210112936795, 0.00272516603581607, 0.00271825375966728, 0.00271134707145393, 0.00270444038324058, 0.00269755627959967, 0.00269067217595875, 0.00268382183276117, 0.00267697172239423, 0.00267013325355947, 0.00266333948820829, 0.00265652337111533, 0.00264974124729633, 0.00264297029934824, 0.00263621634803712, 0.00262944563291967, 0.00262273708358407, 0.00261603388935328, 0.00260929157957435, 0.00260263402014971, 0.00259594805538654, 0.0025892904959619, 0.00258263293653727, 0.00257600913755596, 0.00256938533857465, 0.00256277318112552, 0.00255618337541819, 0.00254961079917848, 0.00254304381087422, 0.00253648241050541, 0.00252996059134603, 0.0025234161876142, 0.00251692836172879, 0.00251042935997248, 0.00250395270995796, 0.00249747629277408, 0.00249102804809809, 0.00248459703288972, 0.00247816019691527, 0.00247174594551325, 0.00246535451151431, 0.00245899125002325, 0.00245260540395975, 0.00244624190963805, 0.0024399240501225, 0.00243358337320387, 0.00242726551368833, 0.00242097582668066, 0.00241469754837453, 0.00240840227343142, 0.00240216357633471, 0.00239592487923801, 0.00238969759084284, 0.00238348706625402, 0.00237728795036674, 0.00237109465524554, 0.00236491253599524, 0.00235875882208347, 0.00235262187197804, 0.00234646815806627, 0.00234036520123482, 0.00233426247723401, 0.00232816534116864, 0.00232209078967571, 0.00231602764688432, 0.00230998708866537, 0.0023039523512125, 0.00229792855679989, 0.002291927812621, 0.00228593242354691, 0.0022799598518759, 0.00227399286814034, 0.00226805987767875, 0.00226210406981409, 0.00225617690011859, 0.00225029489956796, 0.00224437890574336, 0.00223850249312818, 0.00223264307714999, 0.00222679506987333, 0.00222093565389514, 0.00221512722782791, 0.00220931880176067, 0.00220353296026587, 0.00219774711877108, 0.00219197827391326, 0.00218623224645853, 0.00218047481030226, 0.00217475113458931, 0.00216903327964246, 0.00216333824209869, 0.00215765973553061, 0.00215198169462383, 0.00214634300209582, 0.00214068754576147, 0.002135060261935, 0.00212944997474551, 0.00212383409962058, 0.00211825757287443, 0.00211268127895892, 0.00210712756961584, 0.00210157968103886, 0.00209604855626822, 0.00209052325226367, 0.00208502053283155, 0.00207954039797187, 0.00207406608387828, 0.00206859153695405, 0.00206315657123923, 0.00205773906782269, 0.00205232109874487, 0.00204689195379615, 0.0020415079779923, 0.00203612982295454, 0.00203075166791677, 0.00202542450278997, 0.00202009733766317, 0.00201477017253637, 0.00200946535915136, 0.00200417777523398, 0.0019988901913166, 0.0019936366006732, 0.00198836601339281, 0.00198313500732183, 0.00197790958918631, 0.00197270140051842, 0.00196751556359231, 0.00196232995949686, 0.0019571443554014, 0.00195198669098318, 0.00194686336908489, 0.00194172281771898, 0.00193662778474391, 0.00193152134306729, 0.00192643760237843, 0.00192136503756046, 0.0019163154065609, 0.00191127683501691, 0.00190623837988824, 0.00190122239291668, 0.00189622910693288, 0.00189125875476748, 0.00188627687748522, 0.00188132293988019, 0.00187639216892421, 0.00187143858056515, 0.00186653586570174, 0.00186162756290287, 0.00185673625674099, 0.0018518507713452, 0.00184700475074351, 0.00184216420166194, 0.00183733517769724, 0.00183250615373254, 0.0018276940099895, 0.00182291038800031, 0.0018181266495958, 0.00181336549576372, 0.0018086270429194, 0.00180388288572431, 0.00179917842615396, 0.00179447385016829, 0.00178976380266249, 0.00178508751560003, 0.00178042275365442, 0.00177576905116439, 0.00177113828249276, 0.00176651868969202, 0.0017619215650484, 0.00175731349736452, 0.00175272789783776, 0.00174817070364952, 0.00174359069205821, 0.00173906155396253, 0.00173455523326993, 0.00173003750387579, 0.00172551989089698, 0.00172104756347835, 0.00171658082399517, 0.00171214248985052, 0.00170766992960125, 0.00170326547231525, 0.00169884413480759, 0.00169443397317082, 0.00169006932992488, 0.00168569304514676, 0.00168135087005794, 0.00167698040604591, 0.00167265522759408, 0.00166835263371468, 0.00166403874754906, 0.00165974744595587, 0.00165547896176577, 0.0016511989524588, 0.00164696446154267, 0.0016427468508482, 0.00163850653916597, 0.00163431721739471, 0.001630122307688, 0.0016259781550616, 0.00162179453764111, 0.00161763932555914, 0.00161351775750518, 0.00160936801694334, 0.00160527497064322, 0.00160119321662933, 0.00159711728338152, 0.00159304670523852, 0.00158899335656315, 0.00158497376833111, 0.00158094870857894, 0.00157692341599613, 0.00157293793745339, 0.00156895816326141, 0.00156497815623879, 0.00156103796325624, 0.00155710929539055, 0.00155318016186357, 0.00154926255345345, 0.0015453677624464, 0.00154148403089494, 0.00153761182446033, 0.00153300922829658, 0.00152780092321336, 0.0015226264949888, 0.00151744077447802, 0.00151226646266878, 0.001507080742158, 0.00150192901492119, 0.00149677717126906, 0.00149164814502001, 0.00148651900235564, 0.0014814012683928, 0.00147628341801465, 0.00147118850145489, 0.00146609323564917, 0.00146099808625877, 0.00145590305328369, 0.00145083048846573, 0.00144575804006308, 0.00144071958493441, 0.0014356697211042, 0.00143063126597553, 0.00142559269443154, 0.00142056553158909, 0.00141556106973439, 0.00141056766733527, 0.00140557449776679, 0.00140058132819831, 0.00139562215190381, 0.0013906400417909, 0.0013856808654964, 0.00138072157278657, 0.0013757738051936, 0.00137082580476999, 0.00136591179762036, 0.00136099779047072, 0.00135609519202262, 0.00135119259357452, 0.00134630117099732, 0.00134143268223852, 0.00133652985095978, 0.00133167253807187, 0.00132680393289775, 0.00132195791229606, 0.0013171344762668, 0.00131228845566511, 0.00130746513605118, 0.00130264170002192, 0.00129782967269421, 0.00129304022993892, 0.00128825090359896, 0.00128348404541612, 0.00127870589494705, 0.00127393915317953, 0.00126919511239976, 0.00126443966291845, 0.00125969550572336, 0.00125495134852827, 0.00125024118460715, 0.00124553102068603, 0.00124082097318023, 0.00123613339383155, 0.00123144593089819, 0.00122676976025105, 0.00122211605776101, 0.00121742859482765, 0.00121276371646672, 0.00120813283137977, 0.00120350194629282, 0.00119888235349208, 0.00119426287710667, 0.00118964316789061, 0.00118503498379141, 0.00118043797556311, 0.00117585249245167, 0.0011712780687958, 0.00116671517025679, 0.001162163564004, 0.00115762313362211, 0.00115308293607086, 0.00114854250568897, 0.00114400230813771, 0.00113948457874358, 0.00113497814163566, 0.00113049452193081, 0.00112599949352443, 0.00112151575740427, 0.0011170320212841, 0.00111258227843791, 0.0011081212433055, 0.00110367150045931, 0.00109922175761312, 0.0010948060080409, 0.00109037884976715, 0.00108597439248115, 0.00108157005161047, 0.00107715430203825, 0.00107277242932469, 0.00106839067302644, 0.00106400880031288, 0.00105966103728861, 0.00105531315784901, 0.00105096539482474, 0.00104664009995759, 0.00104230362921953, 0.00103798974305391, 0.00103366444818676, 0.00102936197072268, 0.00102507078554481, 0.00102079089265317, 0.00101651099976152, 0.00101224239915609, 0.00100797379855067, 0.00100371649023145, 0.000999470590613782, 0.000995258684270084, 0.000991023960523307, 0.000986812054179609, 0.000982611440122128, 0.000978410709649324, 0.00097422138787806, 0.000970020773820579, 0.00096585409482941, 0.000961687415838242, 0.000957543437834829, 0.000953388051129878, 0.000949244014918804, 0.000945111270993948, 0.000941001228056848, 0.00093687983462587, 0.000932781083974987, 0.000928659690544009, 0.000924583582673222, 0.000920496182516217, 0.000916431366931647, 0.000912377960048616, 0.000908313202671707, 0.000904259679373354, 0.00090021756477654, 0.000896186800673604, 0.000892178679350764, 0.000888170441612601, 0.0008841622620821, 0.000880176841747016, 0.000876191246788949, 0.000872217060532421, 0.000868231523782015, 0.000864280038513243, 0.000860317144542933, 0.000856376893352717, 0.00085244799265638, 0.000848519091960043, 0.000844612834043801, 0.000840706576127559, 0.000836800318211317, 0.000832905410788953, 0.000829010386951268, 0.00082513818051666, 0.000821277149952948, 0.000817416235804558, 0.000813577906228602, 0.000809739576652646, 0.000805889896582812, 0.000802062859293073, 0.000798247230704874, 0.000794454186689109, 0.000790649792179465, 0.0007868567481637, 0.000783086405135691, 0.000779316003900021, 0.000775545660872012, 0.00077178655192256, 0.000768038793466985, 0.000764302385505289, 0.00076057726982981, 0.000756863504648209, 0.000753149681258947, 0.000749447266571224, 0.000745756085962057, 0.000742064963560551, 0.000738373841159046, 0.000734705361537635, 0.000731036881916225, 0.00072739104507491, 0.000723756558727473, 0.000720110721886158, 0.000716498761903495, 0.00071285292506218, 0.000709252373781055, 0.000705651822499931, 0.000702073913998902, 0.000698484655003995, 0.000694906804710627, 0.000691351538989693, 0.000687784922774881, 0.000684229657053947, 0.000680685741826892, 0.000677141768392175, 0.000673631846439093, 0.000670110573992133, 0.00066660059383139, 0.000663113198243082, 0.000659625919070095, 0.000656149873975664, 0.000652673887088895, 0.000649197900202125, 0.000645744556095451, 0.000642291153781116, 0.000638860452454537, 0.000635429751127958, 0.000632010342087597, 0.000628602283541113, 0.000625171582214534, 0.000621786108240485, 0.00061838940018788, 0.000615015276707709, 0.000611652503721416, 0.000608289730735123, 0.000604949600528926, 0.00060159811982885, 0.000598257989622653, 0.000594929209910333, 0.000591600371990353, 0.00058828282635659, 0.000584999332204461, 0.000581704487558454, 0.000578420993406326, 0.000575126148760319, 0.000571865239180624, 0.000568604387808591, 0.000565354828722775, 0.000562116561923176, 0.000558878353331238, 0.000555674079805613, 0.000552447163499892, 0.000549242889974266, 0.000546027324162424, 0.000542834401130676, 0.000539652770385146, 0.000536493782419711, 0.000533323443960398, 0.000530175806488842, 0.000527016818523407, 0.000523891823831946, 0.000520755478646606, 0.000517630483955145, 0.000514505489263684, 0.000511403137352318, 0.000508300785440952, 0.00050522101810202, 0.000502141308970749, 0.000499061599839479, 0.000495993182994425, 0.00049293611664325, 0.000489901751279831, 0.00048686726950109, 0.000483844167320058, 0.000480821065139025, 0.000477820605738088, 0.000474820146337152, 0.000471819686936215, 0.000468819227535278, 0.000465841381810606, 0.000462874915683642, 0.000459919770946726, 0.000456964568002149, 0.000454020744655281, 0.000451099534984678, 0.000448166974820197, 0.000445257115643471, 0.000442347256466746, 0.00043943733908236, 0.000436538772191852, 0.000433651555795223, 0.000430798274464905, 0.000427922379458323, 0.000425069098128006, 0.000422204495407641, 0.000419362564571202, 0.000416543247411028, 0.000413712637964636, 0.000410893349908292, 0.000408096675528213, 0.000405300001148134, 0.000402526027755812, 0.000399740703869611, 0.000396955321775749, 0.000394192640669644, 0.000391429959563538, 0.000388701242627576, 0.000385961204301566, 0.000383221165975556, 0.000380515091819689, 0.000377797667169943, 0.000375102943507954, 0.00037238554796204, 0.000369702116586268, 0.000367029977496713, 0.00036435789661482, 0.000361708400305361, 0.000359058962203562, 0.000356409524101764, 0.000353760027792305, 0.000351133203366771, 0.000348506408045068, 0.000345913547789678, 0.00034330936614424, 0.000340727827278897, 0.000338146317517385, 0.00033557612914592, 0.000333005882566795, 0.000330424372805282, 0.00032788811950013, 0.000325340573908761, 0.000322815641993657, 0.000320290739182383, 0.000317777128657326, 0.000315274868626148, 0.000312772579491138, 0.000310281640850008, 0.000307790702208877, 0.000305311084957793, 0.000302865402773023, 0.000300408428302035, 0.000297962775221094, 0.000295528443530202, 0.000293094111839309, 0.000290659751044586, 0.000288248062133789, 0.000285836373222992, 0.000283458648482338, 0.000281058280961588, 0.000278680556220934, 0.000276325474260375, 0.000273959100013599, 0.000271615310339257, 0.000269248936092481, 0.000266916496912017, 0.000264584057731554, 0.000262285582721233, 0.000259964494034648, 0.000257666019024327, 0.000255356222623959, 0.000253069098107517, 0.000250793265877292, 0.000248540076427162, 0.000246275594690815, 0.0002440224197926, 0.000241791873122565, 0.000239561341004446, 0.000237342130276375, 0.000235100276768208, 0.000232903723372146, 0.000230695834034123, 0.000228510602028109, 0.000226336662308313, 0.000224162751692347, 0.000221988841076382, 0.000219848880078644, 0.000217697612242773, 0.000215568972635083, 0.000213417690247297, 0.000211289079743437, 0.000209183082915843, 0.000207077115192078, 0.000204993775696494, 0.000202899100258946, 0.00020080445392523, 0.000198732435819693, 0.000196671739104204, 0.00019463368516881, 0.000192584324395284, 0.000190534949069843, 0.000188519537914544, 0.000186504141311161, 0.000184500066097826, 0.000182473319000565, 0.000180480565177277, 0.000178499132744037, 0.000176529021700844, 0.000174558896105736, 0.000172600106452592, 0.000170641331351362, 0.000168716491316445, 0.000166780358995311, 0.000164855518960394, 0.000162919372087345, 0.000161017203936353, 0.000159115021233447, 0.000157235481310636, 0.00015535595593974, 0.000153476416016929, 0.000151585569255985, 0.000149739993503317, 0.000147894432302564, 0.000146060177939944, 0.000144225938129239, 0.000142403019708581, 0.000140602744068019, 0.000138791147037409, 0.000136990871396847, 0.000135190595756285, 0.000133412962895818, 0.000131646651425399, 0.00012988033995498, 0.000128136671264656, 0.000126381681184284, 0.000124649348435923, 0.000122928322525695, 0.000121207303891424, 0.000119486285257153, 0.000117776595288888, 0.000116078219434712, 0.000114391164970584, 0.000112726760562509, 0.000111051027488429, 0.000109397944470402, 0.000107722218672279, 0.000106091778434347, 0.000104450016806368, 0.000102842226624489, 0.000101223100500647, 9.96039816527627e-05, 9.80188415269367e-05, 9.64223727351055e-05, 9.48372180573642e-05, 9.32520706555806e-05, 9.1678237367887e-05, 9.01157327461988e-05, 8.85872068465687e-05, 8.70360236149281e-05, 8.55188045534305e-05, 8.39902713778429e-05, 8.24843737063929e-05, 8.09784833109006e-05, 7.94725929154083e-05, 7.79780239099637e-05, 7.64947762945667e-05, 7.50341787352227e-05, 7.35622452339157e-05, 7.21016476745717e-05, 7.0663692895323e-05, 6.92030880600214e-05, 6.77764546708204e-05, 6.6361142671667e-05, 6.49458306725137e-05, 6.35531614534557e-05, 6.21491781203076e-05, 6.0779151681345e-05, 5.93978074903134e-05, 5.80277883273084e-05, 5.66577655263245e-05, 5.52990677533671e-05, 5.39516877324786e-05, 5.2626957767643e-05, 5.13022241648287e-05, 4.99888155900408e-05, 4.86527605971787e-05, 4.73506770504173e-05, 4.60712326457724e-05, 4.47804668510798e-05, 4.35123474744614e-05, 4.2244228097843e-05, 4.09987551392987e-05, 3.9741957152728e-05, 3.84964841941837e-05, 3.72623326256871e-05, 3.60281774192117e-05, 3.48053508787416e-05, 3.36164885084145e-05, 3.24163047480397e-05, 3.12274387397338e-05, 3.00499013974331e-05, 2.88723604171537e-05, 2.77174676739378e-05, 2.65625731117325e-05, 2.53963553404901e-05, 2.42641053773696e-05, 2.31205340242013e-05, 2.20109304791549e-05, 2.09013251151191e-05, 1.97917215700727e-05, 1.86821162060369e-05, 1.75951572600752e-05, 1.65195215231506e-05, 1.54552053572843e-05, 1.44022133099497e-05, 1.33378989630728e-05, 1.22962301247753e-05, 1.12658817670308e-05, 1.02355352282757e-05, 9.21651098906295e-06, 8.19748584035551e-06, 7.18978435543249e-06, 6.21604976913659e-06, 5.21967012900859e-06, 4.24593554271269e-06, 3.28352348333283e-06, 2.32111142395297e-06, 1.38134430471837e-06, 4.30254800676266e-07, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 2.67017289863906e-15, 9.28444535475137e-07, 1.89085665169841e-06, 2.84194607047539e-06, 3.80435835722892e-06, 4.76677041660878e-06, 5.76315005673678e-06, 6.77085199640715e-06, 7.75590888224542e-06, 8.76361082191579e-06, 9.7939582701656e-06, 1.08129825093783e-05, 1.18433299576282e-05, 1.28736764963833e-05, 1.39153471536702e-05, 1.49909828905948e-05, 1.60552972374717e-05, 1.71196115843486e-05, 1.82065723492997e-05, 1.93048545042984e-05, 2.04031348403078e-05, 2.15014188142959e-05, 2.26223455683794e-05, 2.37545937125105e-05, 2.48868436756311e-05, 2.60304150287993e-05, 2.7173988200957e-05, 2.83288827631623e-05, 2.95064201054629e-05, 3.06839610857423e-05, 3.18728234560695e-05, 3.30730072164442e-05   }, 
   { 0.00174000416882336, 0.00172991072759032, 0.00171990890521556, 0.001709861215204, 0.00169983645901084, 0.00168990332167596, 0.00167994713410735, 0.00167003693059087, 0.00166014942806214, 0.00165028485935181, 0.00164044322445989, 0.00163064734078944, 0.00162080582231283, 0.00161105568986386, 0.00160132849123329, 0.00159157835878432, 0.00158191984519362, 0.00157221534755081, 0.00156260258518159, 0.0015529670054093, 0.00154337706044316, 0.00153383309952915, 0.00152424315456301, 0.00151474482845515, 0.00150524650234729, 0.00149579381104559, 0.00148631841875613, 0.00147693452890962, 0.00146750488784164, 0.00145814381539822, 0.00144880567677319, 0.00143946765456349, 0.00143017526715994, 0.00142090581357479, 0.00141163624357432, 0.00140245829243213, 0.00139323470648378, 0.00138407957274467, 0.0013749246718362, 0.00136581540573388, 0.00135668320581317, 0.00134766555856913, 0.00133860216010362, 0.00132956146262586, 0.0013205895666033, 0.00131157180294394, 0.00130266859196126, 0.00129371962975711, 0.0012848392361775, 0.0012759588425979, 0.0012671243166551, 0.00125831249170005, 0.00124947784934193, 0.0012407349422574, 0.00123194605112076, 0.00122327171266079, 0.00121455150656402, 0.00120589998550713, 0.00119722553063184, 0.00118861987721175, 0.00118003704119474, 0.00117143127135932, 0.00116289430297911, 0.00115435710176826, 0.00114584295079112, 0.00113739748485386, 0.00112897495273501, 0.00112050655297935, 0.00111210672184825, 0.00110375275835395, 0.00109537586104125, 0.00108709069900215, 0.00107875955291092, 0.0010704742744565, 0.00106225768104196, 0.00105399521999061, 0.00104584731161594, 0.00103763060178608, 0.00102950551081449, 0.00102135760243982, 0.00101327826268971, 0.00100517610553652, 0.000997119699604809, 0.000989108928479254, 0.000981075456365943, 0.000973156362306327, 0.000965168583206832, 0.000957295240368694, 0.000949353328906, 0.000941457110457122, 0.000933652394451201, 0.000925779109820724, 0.000917997327633202, 0.00091021548723802, 0.000902479572687298, 0.000894743541721255, 0.00088705332018435, 0.000879340223036706, 0.00087169575272128, 0.000864097091834992, 0.000856452679727226, 0.000848922645673156, 0.000841346860397607, 0.000833771075122058, 0.000826309726107866, 0.000818802625872195, 0.00081140996189788, 0.000803948554676026, 0.000796555948909372, 0.000789163226727396, 0.000781793380156159, 0.000774469401221722, 0.000767168297898024, 0.000759912887588143, 0.000752611726056784, 0.000745447992812842, 0.000738192640710622, 0.000731028849259019, 0.000723864999599755, 0.00071672402555123, 0.000709651852957904, 0.000702556688338518, 0.000695507333148271, 0.000688480795361102, 0.000681477191392332, 0.000674473645631224, 0.000667561602313071, 0.000660603807773441, 0.000653691706247628, 0.000646825472358614, 0.000639936304651201, 0.000633138697594404, 0.000626318214926869, 0.000619497674051672, 0.000612791627645493, 0.000606062705628574, 0.000599379534833133, 0.000592650612816215, 0.000586013193242252, 0.00057935289805755, 0.000572738412301987, 0.000566169677767903, 0.000559623818844557, 0.000553100893739611, 0.000546600786037743, 0.000540123612154275, 0.000533646438270807, 0.000527215015608817, 0.000520806526765227, 0.000514397979713976, 0.000508081051521003, 0.000501718313898891, 0.000495424203108996, 0.000489153026137501, 0.000482904724776745, 0.000476633518701419, 0.000470453902380541, 0.000464251352241263, 0.000458094611531124, 0.000451960746431723, 0.000445826852228492, 0.000439784547779709, 0.000433696463005617, 0.000427677034167573, 0.000421657605329528, 0.000415706832427531, 0.000409710279200226, 0.000403782411012799, 0.00039787738933228, 0.000391949521144852, 0.000386113213608041, 0.0003802768769674, 0.000374463445041329, 0.000368695764336735, 0.000362905208021402, 0.000357206212356687, 0.000351484311977401, 0.000345808221027255, 0.000340154976584017, 0.000334478885633871, 0.000328894297126681, 0.000323286862112582, 0.0003177480539307, 0.000312209274852648, 0.000306716246996075, 0.000301200343528762, 0.000295776000712067, 0.000290305848466232, 0.000284858630038798, 0.000279525818768889, 0.000274124351562932, 0.000268837320618331, 0.000263481633737683, 0.000258217507507652, 0.00025295335217379, 0.000247689225943759, 0.00024249374109786, 0.000237298256251961, 0.000232148566283286, 0.000226975971600041, 0.000221872047404759, 0.000216790998820215, 0.000211732854950242, 0.000206697586691007, 0.000201662318431772, 0.000196718610823154, 0.000191706247278489, 0.00018678541528061, 0.000181887473445386, 0.000176966641447507, 0.000172114479937591, 0.00016726233297959, 0.000162478827405721, 0.000157672431669198, 0.000152911816257983, 0.000148151200846769, 0.000143482131534256, 0.00013876729644835, 0.000134075351525098, 0.000129474952700548, 0.000124805883388035, 0.00012027414777549, 0.00011567374895094, 0.000111142013338394, 0.000106610270449892, 0.000102124307886697, 9.76612354861572e-05, 9.32210459723137e-05, 8.88037466211244e-05, 8.44322275952436e-05, 8.00835914560594e-05, 7.56891749915667e-05, 7.13863119017333e-05, 6.71063389745541e-05, 6.28034758847207e-05, 5.8615052694222e-05, 5.43579626537394e-05, 5.01695431012195e-05, 4.60040027974173e-05, 4.1838466131594e-05, 3.77415926777758e-05, 3.36447192239575e-05, 2.95936206384795e-05, 2.55425220530014e-05, 2.15371965168742e-05, 1.75089880940504e-05, 1.35494374262635e-05, 9.61277783062542e-06, 5.67611596125062e-06, 1.80811753125454e-06, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 4.4813125107436e-15, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 0.00117695948574692, 2.31164403885487e-06, 6.2254171098175e-06, 1.01163032013574e-05, 1.40758520501549e-05, 1.80582883331226e-05, 2.20178371819202e-05, 2.60918222920736e-05, 3.00971478282008e-05, 3.41940212820191e-05, 3.82908947358374e-05, 4.2410654714331e-05, 4.65304183308035e-05, 5.0718845159281e-05, 5.49301548744552e-05, 5.91414682276081e-05, 6.33985546301119e-05, 6.76327545079403e-05, 7.19356175977737e-05, 7.62613635743037e-05, 8.05871095508337e-05, 8.5004408902023e-05, 8.93759352038614e-05, 9.3816124717705e-05, 9.82334313448519e-05, 0.000102719393908046, 0.000107228239357937, 0.000111714201921131, 0.000116268820420373, 0.000120823446195573, 0.000125446735182777, 0.000130047134007327, 0.00013471620331984, 0.000139362382469699, 0.000144077217555605, 0.000148792052641511, 0.000153506902279332, 0.00015831328346394, 0.000163073884323239, 0.000167926060385071, 0.000172755331732333, 0.000177630383404903, 0.000182505435077474, 0.000187426267075352, 0.00019236997468397, 0.000197313682292588, 0.000202348950551823, 0.000207338453037664, 0.000212419472518377, 0.000217454740777612, 0.000222558679524809, 0.000227685493882746, 0.000232789403526112, 0.000237984888372011, 0.000243157483055256, 0.000248398719122633, 0.000253639998845756, 0.000258881249465048, 0.000264168251305819, 0.000269478186964989, 0.000274856778560206, 0.000280189560726285, 0.000285613903542981, 0.000291015399852768, 0.000296439742669463, 0.000301932741422206, 0.000307379988953471, 0.000312918768031523, 0.000318457576213405, 0.000324042135616764, 0.000329626724123955, 0.000335257034748793, 0.000340864498866722, 0.000346517714206129, 0.000352239614585415, 0.000357915705535561, 0.000363706290954724, 0.000369428162230179, 0.00037526449887082, 0.000381055055186152, 0.000386914267437533, 0.000392773479688913, 0.000398632721044123, 0.000404560589231551, 0.000410488457418978, 0.000416462105931714, 0.00042245865915902, 0.000428432307671756, 0.000434497516835108, 0.000440562696894631, 0.000446650810772553, 0.000452738924650475, 0.000458918540971354, 0.000465052406070754, 0.000471209175884724, 0.00047745747724548, 0.000483682902995497, 0.000489954079966992, 0.000496248190756887, 0.00050256511894986, 0.000508904980961233, 0.000515267718583345, 0.000521676265634596, 0.000528039003256708, 0.000534493301529437, 0.000540924724191427, 0.000547424773685634, 0.00055397063260898, 0.000560516433324665, 0.000567039416637272, 0.000573630968574435, 0.000580222636926919, 0.000586859998293221, 0.000593543227296323, 0.000600226398091763, 0.000606932444497943, 0.000613684242125601, 0.000620458973571658, 0.000627210771199316, 0.000634031312074512, 0.000640828919131309, 0.000647695153020322, 0.000654630130156875, 0.000661519297864288, 0.00066843128297478, 0.00067541201133281, 0.000682369864080101, 0.00068937340984121, 0.000696422765031457, 0.000703495054040104, 0.000710544467438012, 0.000717662449460477, 0.00072482624091208, 0.000731967156752944, 0.000739153882022947, 0.00074634060729295, 0.000753573083784431, 0.000760874187108129, 0.000768129539210349, 0.000775430700741708, 0.000782777613494545, 0.000790101592428982, 0.000797494256403297, 0.000804932729806751, 0.000812371203210205, 0.000819786742795259, 0.000827271025627851, 0.000834823877085, 0.000842308159917593, 0.000849883886985481, 0.000857482547871768, 0.000865058391354978, 0.000872702803462744, 0.000880370149388909, 0.000888037495315075, 0.000895750592462718, 0.000903463689610362, 0.000911222596187145, 0.000919004320167005, 0.000926831911783665, 0.000934636569581926, 0.000942486978601664, 0.000950406130868942, 0.000958279415499419, 0.000966221385169774, 0.00097418628865853, 0.000982128316536546, 0.000990138971246779, 0.00099819537717849, 0.0010062517831102, 0.00101433112286031, 0.0010224562138319, 0.00103053543716669, 0.00103870639577508, 0.00104690005537122, 0.00105507089756429, 0.00106331042479724, 0.00107159581966698, 0.00107983534689993, 0.00108816637657583, 0.00109649740625173, 0.00110482855234295, 0.00111320533324033, 0.00112162798177451, 0.00113005051389337, 0.00113849609624594, 0.00114698742982, 0.00115545571316034, 0.00116401573177427, 0.00117257575038821, 0.00117936229798943, 0.00118437479250133, 0.00118942139670253, 0.00119450245983899, 0.00119962927419692, 0.00120477890595794, 0.00120997440535575, 0.0012151813134551, 0.00122051418293267, 0.00122578977607191, 0.00123113405425102, 0.00123654690105468, 0.00124193693045527, 0.00124740693718195, 0.00125296867918223, 0.00125848466996104, 0.00126409204676747, 0.00126973388250917, 0.00127534125931561, 0.00128112046513706, 0.00128683086950332, 0.00129257561638951, 0.00129844632465392, 0.00130428257398307, 0.00131023349240422, 0.00131613842677325, 0.00132208911236376, 0.00132814305834472, 0.00133418524637818, 0.00134030776098371, 0.00134646438527852, 0.00135260971728712, 0.0013588237343356, 0.00136509502772242, 0.00137138902209699, 0.0013777632266283, 0.00138410297222435, 0.00139053445309401, 0.00139698875136673, 0.00140346598345786, 0.00141002330929041, 0.00141656911000609, 0.00142316077835858, 0.00142985524144024, 0.001436538528651, 0.001443290268071, 0.00145003059878945, 0.00145683973096311, 0.00146369449794292, 0.001470583723858, 0.00147748447488993, 0.00148447649553418, 0.00149145722389221, 0.00149849511217326, 0.00150561321061105, 0.00151271990034729, 0.00151988363359123, 0.00152708170935512, 0.00153431412763894, 0.00154162675607949, 0.00154893926810473, 0.00155625189654529, 0.00156367896124721, 0.00157111743465066, 0.00157857872545719, 0.00158613151870668, 0.00159367301966995, 0.00160127168055624, 0.00160890480037779, 0.00161662930622697, 0.0016242852434516, 0.00163202115800232, 0.00163986010011286, 0.00164767622482032, 0.00165554974228144, 0.00166346866171807, 0.00167141063138843, 0.00167940987739712, 0.00168744346592575, 0.00169546552933753, 0.00170363648794591, 0.00171172711998224, 0.00171990948729217, 0.00172818335704505, 0.00173641147557646, 0.00174469663761556, 0.00175307353492826, 0.0017614389071241, 0.00176989601459354, 0.00177835288923234, 0.00178684422280639, 0.00179541553370655, 0.00180394120980054, 0.00181258120574057, 0.0018212212016806, 0.00182994152419269, 0.00183868443127722, 0.00184745038859546, 0.00185626221355051, 0.00186515389941633, 0.00187401147559285, 0.00188297184649855, 0.00189195538405329, 0.00190091587137431, 0.00191001361235976, 0.00191908841952682, 0.00192818639334291, 0.00193740997929126, 0.00194662238936871, 0.0019558344502002, 0.00196513836272061, 0.00197445368394256, 0.00198386050760746, 0.00199322146363556, 0.00200267392210662, 0.00201217224821448, 0.00202169362455606, 0.00203123758547008, 0.00204085046425462, 0.00205050897784531, 0.00206020195037127, 0.00206989469006658, 0.00207966798916459, 0.00208949786610901, 0.00209929374977946, 0.00210918136872351, 0.00211911462247372, 0.00212904764339328, 0.00213907239958644, 0.00214912020601332, 0.00215920200571418, 0.00216929544694722, 0.00217944616451859, 0.00218959688208997, 0.00219990755431354, 0.0022101269569248, 0.00222042645327747, 0.00223081721924245, 0.00224117399193347, 0.00225162203423679, 0.00226209312677383, 0.00227263290435076, 0.00228317268192768, 0.0022937236353755, 0.00230441219173372, 0.00231504370458424, 0.00232573202811182, 0.00233650067821145, 0.00234726932831109, 0.00235807220451534, 0.00236897822469473, 0.0023798611946404, 0.00239081284962595, 0.00240179896354675, 0.00241278507746756, 0.00242388527840376, 0.00243495148606598, 0.00244608637876809, 0.00245728995651007, 0.00246850471012294, 0.0024797769729048, 0.00249104900285602, 0.00250238995067775, 0.00251375348307192, 0.00252516288310289, 0.0025366295594722, 0.00254814187064767, 0.00255964300595224, 0.00257122423499823, 0.00258283969014883, 0.00259448913857341, 0.00260620797052979, 0.00261791469529271, 0.00262971338815987, 0.00264151184819639, 0.00265333335846663, 0.00266524637117982, 0.00267714797519147, 0.0026890835724771, 0.00270112254656851, 0.002713184338063, 0.00272528035566211, 0.0027373880147934, 0.00274955295026302, 0.00276178610511124, 0.00277397385798395, 0.00278625288046896, 0.00279861246235669, 0.00281090289354324, 0.00282333069480956, 0.00283580436371267, 0.00284824403934181, 0.0028607863932848, 0.00287331710569561, 0.0028859053272754, 0.00289858528412879, 0.00291121890768409, 0.00292393309064209, 0.0029367043171078, 0.0029494755435735, 0.00296230404637754, 0.00297518982551992, 0.00298808701336384, 0.00300104124471545, 0.00301404134370387, 0.00302711012773216, 0.00304015632718801, 0.00305322487838566, 0.00306640821509063, 0.00307956850156188, 0.00309277465566993, 0.00310608395375311, 0.00311939301900566, 0.00313273654319346, 0.0031461026519537, 0.00315950345247984, 0.00317301857285202, 0.00318648782558739, 0.00319999153725803, 0.00321364379487932, 0.00322723924182355, 0.00324085727334023, 0.00325460126623511, 0.00326831103302538, 0.00328208948485553, 0.00329592474736273, 0.00330974883399904, 0.00332368747331202, 0.00333759165368974, 0.0033515531104058, 0.00336558348499238, 0.00337963597849011, 0.00339373480528593, 0.00340784504078329, 0.0034220467787236, 0.00343625992536545, 0.00345047330483794, 0.00346481218002737, 0.00347911706194282, 0.00349343311972916, 0.00350784091278911, 0.00352231692522764, 0.00353680504485965, 0.00355135020799935, 0.00356589513830841, 0.00358050898648798, 0.00359515706077218, 0.00360981654375792, 0.00362454447895288, 0.00363928428851068, 0.00365410395897925, 0.00366896949708462, 0.00368382316082716, 0.00369875784963369, 0.00371369160711765, 0.00372869451530278, 0.00374376587569714, 0.00375880324281752, 0.0037739088293165, 0.00378911755979061, 0.00380424642935395, 0.00381947821006179, 0.00383479008451104, 0.00385007867589593, 0.00386543618515134, 0.00388085097074509, 0.00389624270610511, 0.0039117494598031, 0.00392723269760609, 0.00394275039434433, 0.00395839428529143, 0.00397398043423891, 0.00398963550105691, 0.00400537112727761, 0.00402111746370792, 0.0040368870832026, 0.00405272515490651, 0.00406860932707787, 0.00408449303358793, 0.00410041119903326, 0.00411643320694566, 0.00413243100047112, 0.0041484753601253, 0.0041646109893918, 0.00418073544278741, 0.00419690553098917, 0.00421313289552927, 0.00422936026006937, 0.00424570171162486, 0.00426205480471253, 0.00427835108712316, 0.0042948299087584, 0.00431127473711967, 0.00432770838961005, 0.00434429012238979, 0.00436086067929864, 0.00437746569514275, 0.00439412798732519, 0.00441080145537853, 0.00442754384130239, 0.00444428622722626, 0.00446109659969807, 0.00447797635570168, 0.00449483329430223, 0.00451175821945071, 0.00452872971072793, 0.00454573472961783, 0.00456279795616865, 0.00457986071705818, 0.00459701474756002, 0.00461416877806187, 0.00463134609162807, 0.00464862631633878, 0.00466587161645293, 0.00468316348269582, 0.0047005582600832, 0.00471796374768019, 0.00473540462553501, 0.00475285621359944, 0.00477036507800221, 0.00478797685354948, 0.00480555463582277, 0.00482314359396696, 0.00484084757044911, 0.00485856272280216, 0.00487628905102611, 0.00489410664886236, 0.0049119358882308, 0.00492981122806668, 0.00494769867509604, 0.00496564153581858, 0.00498367799445987, 0.00500166695564985, 0.00501972530037165, 0.00503785256296396, 0.00505601335316896, 0.00507417460903525, 0.00509240478277206, 0.00511065730825067, 0.00512896804139018, 0.00514731183648109, 0.005165736656636, 0.00518414983525872, 0.00520256254822016, 0.00522110192105174, 0.00523962918668985, 0.00525820255279541, 0.0052768443711102, 0.0052954750135541, 0.0053141969256103, 0.00533294165506959, 0.0053516523912549, 0.00537053495645523, 0.00538935977965593, 0.00540821859613061, 0.00542721524834633, 0.00544616673141718, 0.00546517455950379, 0.00548422895371914, 0.00550330569967628, 0.00552247371524572, 0.00554163055494428, 0.0055608106777072, 0.00558009371161461, 0.00559935299679637, 0.00561867048963904, 0.00563804479315877, 0.00565747590735555, 0.00567691866308451, 0.00569638470187783, 0.00571594201028347, 0.0057354997843504, 0.0057550803758204, 0.00577469496056437, 0.00579443527385592, 0.00581410713493824, 0.00583387073129416, 0.00585370324552059, 0.00587352365255356, 0.00589341297745705, 0.00591333629563451, 0.00593330571427941, 0.00595330959185958, 0.00597330182790756, 0.00599341979250312, 0.0060135037638247, 0.00603364501148462, 0.00605387752875686, 0.00607407605275512, 0.00609437702223659, 0.00611466681584716, 0.00613502552732825, 0.00615545269101858, 0.00617585657164454, 0.00619629584252834, 0.00621684780344367, 0.0062373555265367, 0.00625793170183897, 0.00627859868109226, 0.00629924423992634, 0.0063199563883245, 0.00634071603417397, 0.00636147521436214, 0.00638232566416264, 0.00640315283089876, 0.00642403867095709, 0.00644503766670823, 0.0064660026691854, 0.00648697931319475, 0.00650807004421949, 0.00652917195111513, 0.00655029760673642, 0.00657146843150258, 0.00659274216741323, 0.00661397073417902, 0.00663522211834788, 0.00665662158280611, 0.00667798751965165, 0.0066993641667068, 0.00672083301469684, 0.00674232421442866, 0.00676388433203101, 0.00678543327376246, 0.00680702738463879, 0.00682871323078871, 0.00685039907693863, 0.00687206257134676, 0.00689390860497952, 0.00691569782793522, 0.00693750893697143, 0.00695942435413599, 0.00698133930563927, 0.00700333388522267, 0.00702530611306429, 0.00704734679311514, 0.00706944521516562, 0.0070915431715548, 0.00711370958015323, 0.00713592162355781, 0.00715816859155893, 0.00718043837696314, 0.00720277614891529, 0.00722511485219002, 0.00724754435941577, 0.00726992869749665, 0.00729244947433472, 0.00731497164815664, 0.00733749289065599, 0.00736010540276766, 0.00738274119794369, 0.00740537699311972, 0.00742810452356935, 0.00745087815448642, 0.00747369648888707, 0.00749650411307812, 0.00751934619620442, 0.00754229072481394, 0.00756523525342345, 0.00758818024769425, 0.00761125097051263, 0.00763431005179882, 0.00765741476789117, 0.00768057722598314, 0.00770373968407512, 0.00772699387744069, 0.00775024760514498, 0.00777350086718798, 0.0077969147823751, 0.00782028306275606, 0.0078436741605401, 0.00786715745925903, 0.00789066217839718, 0.00791419111192226, 0.00793776474893093, 0.00796138495206833, 0.00798506196588278, 0.00800876226276159, 0.00803249701857567, 0.0080562774091959, 0.00808005779981613, 0.00810387171804905, 0.00812780018895864, 0.00815174169838428, 0.00817572791129351, 0.00819971319288015, 0.00822379067540169, 0.00824790354818106, 0.0082719698548317, 0.0082961842417717, 0.00832037720829248, 0.00834461487829685, 0.00836894474923611, 0.008393251337111, 0.00841760355979204, 0.00844202470034361, 0.00846646819263697, 0.00849095731973648, 0.0085155051201582, 0.00854002870619297, 0.00856465566903353, 0.00858849659562111, 0.00861145276576281, 0.00863452348858118, 0.00865768548101187, 0.00868087075650692, 0.00870414730161428, 0.00872749276459217, 0.008750906214118, 0.00877436716109514, 0.00879798643290997, 0.00882167462259531, 0.00884536374360323, 0.00886918976902962, 0.00889310613274574, 0.00891704764217138, 0.0089410562068224, 0.00896508898586035, 0.00898932665586472, 0.00901358667761087, 0.00903793983161449, 0.00906236097216606, 0.00908682774752378, 0.00911134015768766, 0.00913603603839874, 0.00916073191910982, 0.009185541421175, 0.00921032950282097, 0.00923525355756283, 0.00926033779978752, 0.009285400621593, 0.00931055471301079, 0.00933579914271832, 0.00936113577336073, 0.00938649475574493, 0.00941187795251608, 0.00943744275718927, 0.00946312304586172, 0.00948875676840544, 0.0095145283266902, 0.00954041350632906, 0.00956623163074255, 0.00959227699786425, 0.0096183679997921, 0.00964450649917126, 0.00967064406722784, 0.00969698745757341, 0.00972333084791899, 0.00974978972226381, 0.00977629236876965, 0.00980291143059731, 0.00982959847897291, 0.00985630881041288, 0.00988315511494875, 0.00990995764732361, 0.00993691850453615, 0.0099640404805541, 0.00999111589044333, 0.0100183514878154, 0.010045656003058, 0.010072915814817, 0.0101003814488649, 0.0101278461515903, 0.0101553797721863, 0.0101830521598458, 0.0102107459679246, 0.0102385757490993, 0.0102664297446609, 0.0102943535894156, 0.0103224366903305, 0.0103505430743098, 0.0103786941617727, 0.0104069840162992, 0.0104352263733745, 0.0104635609313846, 0.010492124594748, 0.0105206668376923, 0.0105492984876037, 0.0105779534205794, 0.0106068141758442, 0.0106356292963028, 0.0106645608320832, 0.0106934905052185, 0.0107226027175784, 0.0107517167925835, 0.0107809659093618, 0.0108102615922689, 0.0108396504074335, 0.0108690829947591, 0.0108986767008901, 0.0109282247722149, 0.0109579563140869, 0.0109875956550241, 0.0110175097361207, 0.011047400534153, 0.0110773369669914, 0.0111074578016996, 0.0111375553533435, 0.0111677665263414, 0.0111980242654681, 0.0112284189090133, 0.0112588135525584, 0.0112892994657159, 0.0113198775798082, 0.0113505469635129, 0.0113812843337655, 0.0114120692014694, 0.0114429658278823, 0.0114739332348108, 0.0115049686282873, 0.0115360282361507, 0.0115672461688519, 0.0115985330194235, 0.0116298664361238, 0.011661222204566, 0.0116927623748779, 0.0117243016138673, 0.0117559088394046, 0.0117876539006829, 0.0118194222450256, 0.0118513042107224, 0.011883232742548, 0.0119152069091797, 0.0119473170489073, 0.0119794514030218, 0.0120117459446192, 0.0120440637692809, 0.0120764039456844, 0.0121088577434421, 0.0121413813903928, 0.0121739963069558, 0.0122067257761955, 0.0122394552454352, 0.0122723206877708, 0.0123052559792995, 0.0123381912708282, 0.0123712867498398, 0.0124044511467218, 0.0124375922605395, 0.0124708712100983, 0.0125043103471398, 0.0125377029180527, 0.012571232393384, 0.0126048550009727, 0.0126385223120451, 0.012672258540988, 0.0127060189843178, 0.0127399610355496, 0.0127738788723946, 0.0128078917041421, 0.0128420842811465, 0.0128762554377317, 0.0129105420783162, 0.0129448724910617, 0.0129793416708708, 0.0130138099193573, 0.0130483936518431, 0.0130829988047481, 0.0131177194416523, 0.0131524847820401, 0.0131873674690723, 0.0132223386317492, 0.0132574029266834, 0.0132925119251013, 0.0133276674896479, 0.013362891972065, 0.0133982067927718, 0.0134335458278656, 0.0134690431877971, 0.0135046113282442, 0.0135402241721749, 0.0135759525001049, 0.0136117022484541, 0.0136476140469313, 0.0136835239827633, 0.0137194572016597, 0.0137555748224258, 0.0137917129322886, 0.0138278985396028, 0.0138642443343997, 0.0139006348326802, 0.0139370728284121, 0.0139736235141754, 0.0140102216973901, 0.0140469092875719, 0.0140836220234632, 0.0141204707324505, 0.0141573892906308, 0.0141943749040365, 0.0142314527183771, 0.0142685296013951, 0.014305722899735, 0.0143430754542351, 0.0143804047256708, 0.0144178029149771, 0.01445531565696, 0.0144928516820073, 0.0145305478945374, 0.0145682655274868, 0.0146060986444354, 0.0146440016105771, 0.0146819483488798, 0.01471998821944, 0.0147580504417419, 0.0147962039336562, 0.0148345176130533, 0.0148728536441922, 0.0149112138897181, 0.0149497333914042, 0.014988275244832, 0.0150269102305174, 0.0150656597688794, 0.0151044307276607, 0.0151432706043124, 0.0151822017505765, 0.0152212036773562, 0.0152603173628449, 0.015299478545785, 0.0153387542814016, 0.015378050506115, 0.0154174184426665, 0.0154568767175078, 0.0154963806271553, 0.0155359990894794, 0.0155757088214159, 0.0156154641881585, 0.0156553573906422, 0.0156952496618032, 0.0157351884990931, 0.0157753117382526, 0.015815457329154, 0.015855623409152, 0.0158959291875362, 0.0159363020211458, 0.0159767214208841, 0.0160172786563635, 0.0160578805953264, 0.0160985309630632, 0.0161392688751221, 0.0161800775676966, 0.0162210017442703, 0.0162619259208441, 0.0163029618561268, 0.016344090923667, 0.0163852889090776, 0.0164266005158424, 0.016467934474349, 0.0165093149989843, 0.0165508575737476, 0.0165924429893494, 0.0166339837014675, 0.016675777733326, 0.0167175699025393, 0.0167594309896231, 0.0168013833463192, 0.016843406483531, 0.01688551902771, 0.0169277004897594, 0.0169699508696795, 0.0170122925192118, 0.0170546136796474, 0.0170971378684044, 0.0171396397054195, 0.0171822793781757, 0.0172249656170607, 0.0172677654772997, 0.0173106342554092, 0.0173535700887442, 0.0173965748399496, 0.0174396280199289, 0.0174827706068754, 0.0175259597599506, 0.0175693091005087, 0.0176126807928085, 0.0176561214029789, 0.0176996532827616, 0.0177432764321566, 0.0177869703620672, 0.0178306847810745, 0.0178744904696941, 0.0179184358566999, 0.0179624035954475, 0.0180064383894205, 0.0180505886673927, 0.0180948078632355, 0.0181390959769487, 0.0181834511458874, 0.0182278994470835, 0.0182723924517632, 0.0183169785887003, 0.0183616299182177, 0.0184063520282507, 0.0184511430561543, 0.0184960719197989, 0.0185410231351852, 0.0185860432684422, 0.0186311323195696, 0.0186762902885675, 0.0187215842306614, 0.0187669228762388, 0.0188123099505901, 0.0188578553497791, 0.0189033783972263, 0.0189489964395761, 0.0189947728067636, 0.0190405230969191, 0.0190863199532032, 0.0191323235630989, 0.019178306683898, 0.0192244239151478, 0.0192705653607845, 0.0193167757242918, 0.0193631444126368, 0.0194095373153687, 0.0194559786468744, 0.0195025075227022, 0.0195491295307875, 0.0195958204567432, 0.0196426026523113, 0.0196894090622663, 0.0197363514453173, 0.0197833627462387, 0.0198304206132889, 0.0198775678873062, 0.0199247617274523, 0.0199720468372107, 0.0200193785130978, 0.020066823810339, 0.0201143845915794, 0.0201619919389486, 0.0202096439898014, 0.0202574096620083, 0.0203051995486021, 0.02035310305655, 0.0204010289162397, 0.0204490702599287, 0.0204972475767136, 0.0205454025417566, 0.0205936748534441, 0.0206420365720987, 0.0206904653459787, 0.0207389872521162, 0.0207875538617373, 0.0208361446857452, 0.0208848938345909, 0.0209336709231138, 0.0209825336933136, 0.0210315119475126, 0.0210805386304855, 0.0211296770721674, 0.0211788192391396, 0.0212280955165625, 0.0212774183601141, 0.0213267616927624, 0.0213762223720551, 0.0214258227497339, 0.0214754398912191, 0.0215251296758652, 0.0215749107301235, 0.021624781191349, 0.0216747019439936, 0.021724708378315, 0.0217747651040554, 0.0218249093741179, 0.0218751467764378, 0.0219254791736603, 0.0219758320599794, 0.0220262743532658, 0.0220768582075834, 0.0221274401992559, 0.0221781115978956, 0.0222288519144058, 0.0222796890884638, 0.022330567240715, 0.0223815608769655, 0.0224326234310865, 0.0224838219583035, 0.022534953430295, 0.0225862413644791, 0.0226376261562109, 0.0226890314370394, 0.0227405298501253, 0.0227921418845654, 0.0228437501937151, 0.022895522415638, 0.0229473188519478, 0.0229992046952248, 0.0230512041598558, 0.0231032054871321, 0.0231553204357624, 0.0232074819505215, 0.0232597347348928, 0.0233120992779732, 0.0233644898980856, 0.0234169941395521, 0.0234695672988892, 0.0235221851617098, 0.0235749650746584, 0.0236277207732201, 0.0236805696040392, 0.0237334612756968, 0.0237864907830954, 0.0238396152853966, 0.0238927826285362, 0.0239460170269012, 0.0239993445575237, 0.0240527428686619, 0.0241061840206385, 0.0241597630083561, 0.0242132991552353, 0.0242669936269522, 0.0243207793682814, 0.0243746116757393, 0.0244285576045513, 0.0244825482368469, 0.0245366077870131, 0.0245907846838236, 0.0246449820697308, 0.0246992260217667, 0.0247535835951567, 0.024808008223772, 0.0248625501990318, 0.0249171853065491, 0.0249718632549047, 0.0250266082584858, 0.0250814240425825, 0.0251363329589367, 0.0251913089305162, 0.0252462849020958, 0.0253014657646418, 0.0253566242754459, 0.0254118759185076, 0.0254672635346651, 0.0255226977169514, 0.0255781784653664, 0.0256337709724903, 0.0256893634796143, 0.0257451180368662, 0.0258008949458599, 0.0258567649871111, 0.0259127710014582, 0.0259687528014183, 0.0260248519480228, 0.0260810852050781, 0.0261373203247786, 0.0261936485767365, 0.0262499954551458, 0.0263064838945866, 0.0263630375266075, 0.0264196377247572, 0.0264763552695513, 0.0265331398695707, 0.0265899915248156, 0.0266469568014145, 0.0267039462924004, 0.0267610307782888, 0.0268181338906288, 0.026875352486968, 0.0269327107816935, 0.0269900895655155, 0.0270475149154663, 0.0271050315350294, 0.0271626617759466, 0.0272203367203474, 0.0272781290113926, 0.0273359194397926, 0.0273938477039337, 0.0274518225342035, 0.0275098439306021, 0.0275680236518383, 0.0276262275874615, 0.02768449857831, 0.0277429074048996, 0.0278012938797474, 0.0278598181903362, 0.0279183872044086, 0.0279770232737064, 0.0280357990413904, 0.0280945990234613, 0.0281534641981125, 0.0282124690711498, 0.0282714515924454, 0.0283305905759335, 0.0283897314220667, 0.028449010103941, 0.0285083819180727, 0.0285677779465914, 0.0286272130906582, 0.0286868121474981, 0.0287464819848537, 0.0288061499595642, 0.0288659781217575, 0.0289258286356926, 0.0289857257157564, 0.0290457606315613, 0.0291058421134949, 0.0291660111397505, 0.0292262751609087, 0.0292866062372923, 0.0293470080941916, 0.0294074527919292, 0.029468197375536, 0.0295293070375919, 0.0295904614031315, 0.0296518206596375, 0.0297132525593042, 0.0297748651355505, 0.0298366397619247, 0.0298983454704285, 0.0299603026360273, 0.0300223045051098, 0.0300843976438046, 0.0301467683166265, 0.0302090886980295, 0.0302716214209795, 0.0303341709077358, 0.0303969513624907, 0.0304598454385996, 0.0305227879434824, 0.0305858664214611, 0.030649034306407, 0.0307123437523842, 0.0307758338749409, 0.0308392979204655, 0.0309030190110207, 0.0309667829424143, 0.0310306623578072, 0.0310946777462959, 0.0311587881296873, 0.0312231238931417, 0.0312873721122742, 0.0313518904149532, 0.0314165689051151, 0.0314812064170837, 0.0315460450947285, 0.0316109545528889, 0.0316760241985321, 0.0317411608994007, 0.031806506216526, 0.0318719632923603, 0.0319374240934849, 0.0320030637085438, 0.0320688188076019, 0.0321346893906593, 0.0322007648646832, 0.0322667956352234, 0.0323330573737621, 0.0323993638157845, 0.0324658527970314, 0.0325324311852455, 0.0325990803539753, 0.0326658897101879, 0.0327327437698841, 0.0327998250722885, 0.0328670926392078, 0.0329342447221279, 0.033001720905304, 0.033069234341383, 0.0331367775797844, 0.0332044772803783, 0.0332723408937454, 0.0333403870463371, 0.0334084071218967, 0.0334766358137131, 0.033545047044754, 0.0336134135723114, 0.0336819849908352, 0.0337506234645844, 0.0338193997740746, 0.0338882468640804, 0.0339572951197624, 0.034026462584734, 0.0340956747531891, 0.0341650731861591, 0.0342346057295799, 0.0343041345477104, 0.0343739204108715, 0.0344436354935169, 0.0345136262476444, 0.0345837324857712, 0.0346538834273815, 0.0347242131829262, 0.034794595092535, 0.0348651111125946, 0.0349357649683952, 0.035006508231163, 0.0350773707032204, 0.0351483672857285, 0.0352194793522358, 0.035290751606226, 0.0353620685636997, 0.0354335233569145, 0.0355051159858704, 0.0355768464505672, 0.0356486439704895, 0.035720556974411, 0.0357925854623318, 0.0358646810054779, 0.035937026143074, 0.0360093750059605, 0.0360819026827812, 0.0361545532941818, 0.0362272672355175, 0.0363001637160778, 0.0363730601966381, 0.0364462099969387, 0.0365194045007229, 0.0365927331149578, 0.0366661548614502, 0.0367397181689739, 0.0368134193122387, 0.0368872508406639, 0.0369610898196697, 0.0370351299643517, 0.037109263241291, 0.0371834635734558, 0.0372578240931034, 0.0373323224484921, 0.0374069586396217, 0.037481639534235, 0.0375565066933632, 0.0376314893364906, 0.0377065576612949, 0.0377816967666149, 0.0378569513559341, 0.0379324145615101, 0.0380079224705696, 0.0380836352705956, 0.0381593890488148, 0.0382352620363235, 0.0383112952113152, 0.0383873246610165, 0.0384636111557484, 0.0385399907827377, 0.0386163629591465, 0.0386930145323277, 0.0387696623802185, 0.0388465002179146, 0.0389234237372875, 0.0390005074441433, 0.0390776135027409, 0.0391548834741116, 0.039232287555933, 0.0393098294734955, 0.0393874682486057, 0.0394651927053928, 0.039543054997921, 0.0396210588514805, 0.0396990813314915, 0.0397773161530495, 0.0398557037115097, 0.0399340912699699, 0.0400126688182354, 0.0400913543999195, 0.0401701107621193, 0.0402490235865116, 0.0403280332684517, 0.0404071994125843, 0.0404864177107811, 0.040565837174654, 0.0406453907489777, 0.040724903345108, 0.0408046469092369, 0.0408844761550426, 0.0409643985331059, 0.0410445742309093, 0.0411246791481972, 0.0412050373852253, 0.0412853956222534, 0.0413659811019897, 0.0414465926587582, 0.0415273644030094, 0.0416082702577114, 0.0416892506182194, 0.0417703874409199, 0.0418516397476196, 0.0419329591095448, 0.0420144833624363, 0.0420960523188114, 0.042177714407444, 0.042259469628334, 0.0423414520919323, 0.0424235984683037, 0.0425056293606758, 0.042587973177433, 0.0426703952252865, 0.0427529253065586, 0.0428355298936367, 0.0429182648658752, 0.0430011227726936, 0.0430840402841568, 0.0431671887636185, 0.0432504341006279, 0.0433337017893791, 0.0434172190725803, 0.0435007512569427, 0.0435844324529171, 0.0436682924628258, 0.0437521077692509, 0.043836172670126, 0.0439202599227428, 0.0440045818686485, 0.0440890118479729, 0.0441734902560711, 0.0442580804228783, 0.0443427413702011, 0.0444276370108128, 0.0445126630365849, 0.0445976182818413, 0.0446828752756119, 0.0447681769728661, 0.0448535978794098, 0.0449391007423401, 0.0450248196721077, 0.0451106019318104, 0.0451964251697063, 0.0452825054526329, 0.0453686118125916, 0.0454548485577106, 0.0455411858856678, 0.0456275828182697, 0.0457142367959023, 0.0458008646965027, 0.0458877719938755, 0.0459747463464737, 0.0460617169737816, 0.0461489148437977, 0.0462361872196198, 0.0463235899806023, 0.0464111641049385, 0.0464987270534039, 0.0465865284204483, 0.0466743260622025, 0.0467623956501484, 0.0468505136668682, 0.0469387248158455, 0.0470270439982414, 0.047115433961153, 0.0472040362656116, 0.0472927503287792, 0.047381479293108, 0.0474704429507256, 0.0475595034658909, 0.047648623585701, 0.0477378666400909, 0.0478271953761578, 0.0479167774319649, 0.0480062887072563, 0.0480961464345455, 0.0481859371066093, 0.0482759103178978, 0.0483659915626049, 0.0484561659395695, 0.0485465303063393, 0.0486368648707867, 0.0487274080514908, 0.0488181561231613, 0.0489088632166386, 0.0489998422563076, 0.0490908361971378, 0.0491819344460964, 0.0492732115089893, 0.0493645295500755, 0.0494560599327087, 0.0495475605130196, 0.0496393442153931, 0.0497311428189278, 0.0498230196535587, 0.0499151609838009, 0.0500072576105595, 0.0500996559858322, 0.0501920804381371, 0.050284493714571, 0.0503772161900997, 0.0504699572920799, 0.0505627654492855, 0.0506558008491993, 0.0507489107549191, 0.0508421063423157, 0.0509353987872601, 0.0510289408266544, 0.0511225275695324, 0.0512161813676357, 0.0513099543750286, 0.0514038391411304, 0.0514979287981987, 0.051592044532299, 0.0516862943768501, 0.0517807714641094, 0.0518752038478851, 0.0519698932766914, 0.0520645566284657, 0.0521593801677227, 0.052254430949688, 0.0523494817316532, 0.052444651722908, 0.0525399968028069, 0.0526354648172855, 0.0527309514582157, 0.0528266429901123, 0.052922498434782, 0.0530183538794518, 0.0531142726540565, 0.0532104484736919, 0.0533067099750042, 0.0534031316637993, 0.0534995384514332, 0.053596168756485, 0.0536928474903107, 0.0537896826863289, 0.0538866147398949, 0.0539837256073952, 0.0540808364748955, 0.0541781783103943, 0.0542755648493767, 0.054373137652874, 0.05447081848979, 0.0545684807002544, 0.0546663925051689, 0.0547643080353737, 0.0548624955117702, 0.0549607053399086, 0.0550590977072716, 0.0551574937999249, 0.0552560687065125, 0.0553547851741314, 0.055453609675169, 0.0555525124073029, 0.055651567876339, 0.0557506904006004, 0.0558499544858932, 0.0559493079781532, 0.0560489185154438, 0.0561485029757023, 0.0562482215464115, 0.0563481040298939, 0.0564480498433113, 0.0565482079982758, 0.0566483438014984, 0.0567486397922039, 0.0568491369485855, 0.0569496378302574, 0.0570503398776054, 0.0571510940790176, 0.0572520047426224, 0.0573530532419682, 0.0574541948735714, 0.0575554706156254, 0.0576567687094212, 0.0577581822872162, 0.0578598529100418, 0.0579615868628025, 0.0580633692443371, 0.0581653565168381, 0.0582674294710159, 0.0583696477115154, 0.0584719106554985, 0.0585743337869644, 0.0586768463253975, 0.0587794706225395, 0.058882262557745, 0.0589851662516594, 0.0590881370007992, 0.0591912232339382, 0.0592944733798504, 0.059397853910923, 0.0595012344419956, 0.0596048720180988, 0.0597085729241371, 0.0598123669624329, 0.0599162541329861, 0.0600203014910221, 0.0601245351135731, 0.0602287650108337, 0.060333177447319, 0.0604377239942551, 0.0605422742664814, 0.0606470592319965, 0.0607518814504147, 0.0608568638563156, 0.0609619878232479, 0.0610671564936638, 0.0611725300550461, 0.0612779781222343, 0.0613835081458092, 0.0614891350269318, 0.0615949220955372, 0.0617008209228516, 0.0618068836629391, 0.0619130097329617, 0.062019307166338, 0.062125638127327, 0.0622321628034115, 0.0623387694358826, 0.0624454915523529, 0.0625522881746292, 0.0626592189073563, 0.0627662837505341, 0.0628734678030014, 0.0629807859659195, 0.0630882456898689, 0.0631957501173019, 0.0633033886551857, 0.0634111911058426, 0.0635190606117249, 0.0636270642280579, 0.0637351423501968, 0.0638433992862701, 0.0639517232775688, 0.0640602111816406, 0.0641687884926796, 0.0642775073647499, 0.0643863156437874, 0.0644952356815338, 0.0646042749285698, 0.0647134706377983, 0.0648226886987686, 0.0649321600794792, 0.0650416761636734, 0.0651512369513512, 0.065261036157608, 0.0653708949685097, 0.0654809102416039, 0.0655909553170204, 0.0657011568546295, 0.0658115223050117, 0.0659219771623611, 0.0660324841737747, 0.0661432147026062, 0.0662539824843407, 0.0663648992776871, 0.0664758533239365, 0.0665870234370232, 0.0666982755064964, 0.0668096765875816, 0.066921204328537, 0.0670327618718147, 0.067144587635994, 0.067256323993206, 0.0673683360219002, 0.0674803778529167, 0.0675925239920616, 0.0677048340439796, 0.0678173005580902, 0.067929819226265, 0.0680424720048904, 0.0681552588939667, 0.0682681873440742, 0.0683811604976654, 0.0684942901134491, 0.0686074495315552, 0.0687208101153374, 0.0688343048095703, 0.0689479261636734, 0.0690616741776466, 0.0691754519939423, 0.0692893639206886, 0.0694034546613693, 0.069517619907856, 0.069631852209568, 0.0697462856769562, 0.0698607265949249, 0.0699753910303116, 0.0700901746749878, 0.0702050477266312, 0.0703200325369835, 0.0704351589083672, 0.0705503523349762, 0.0706656873226166, 0.0707811266183853, 0.0708966851234436, 0.0710123851895332, 0.0711281076073647, 0.071244053542614, 0.0713601186871529, 0.0714762434363365, 0.0715924948453903, 0.0717088952660561, 0.0718253701925278, 0.0719420090317726, 0.0720586702227592, 0.0721755549311638, 0.0722924619913101, 0.072409600019455, 0.0725267827510834, 0.0726441293954849, 0.0727616176009178, 0.0728790760040283, 0.0729966834187508, 0.0731145367026329, 0.0732324048876762, 0.0733503699302673, 0.0734685212373734, 0.0735867321491241, 0.0737050771713257, 0.0738236382603645, 0.073942244052887, 0.0740608498454094, 0.0741796866059303, 0.0742986276745796, 0.0744177103042603, 0.0745392218232155, 0.0746630430221558, 0.0747870057821274, 0.0749111026525497, 0.075035385787487, 0.0751598030328751, 0.0752843022346497, 0.0754089057445526, 0.0755337849259377, 0.0756586566567421, 0.0757838040590286, 0.0759089514613152, 0.0760343745350838, 0.0761598497629166, 0.0762854516506195, 0.0764111950993538, 0.0765371695160866, 0.0766631439328194, 0.0767893493175507, 0.0769157335162163, 0.0770421624183655, 0.0771687775850296, 0.0772954449057579, 0.0774223208427429, 0.0775493532419205, 0.0776764675974846, 0.07780372351408, 0.0779311656951904, 0.078058697283268, 0.0781864076852798, 0.0783142521977425, 0.0784422010183334, 0.0785702764987946, 0.0786985382437706, 0.0788269340991974, 0.0789554193615913, 0.0790841057896614, 0.079212911427021, 0.0793418139219284, 0.0794709026813507, 0.0796000733971596, 0.0797293931245804, 0.0798589885234833, 0.079988531768322, 0.080118253827095, 0.0802481696009636, 0.0803781673312187, 0.0805083960294724, 0.0806386768817902, 0.0807690843939781, 0.0808997303247452, 0.0810304135084152, 0.0811613351106644, 0.0812923386693001, 0.081423394382, 0.0815546736121178, 0.0816860496997833, 0.0818176120519638, 0.0819493532180786, 0.0820810943841934, 0.0822130143642426, 0.0823451280593872, 0.0824774205684662, 0.0826097950339317, 0.0827422738075256, 0.0828749313950539, 0.0830077230930328, 0.0831406489014626, 0.083273634314537, 0.0834068357944489, 0.0835402235388756, 0.0836736187338829, 0.0838072746992111, 0.0839409828186035, 0.0840748772025108, 0.0842089504003525, 0.0843430235981941, 0.0844774171710014, 0.0846118703484535, 0.0847463011741638, 0.084881067276001, 0.0850158333778381, 0.0851508677005768, 0.0852859541773796, 0.0854212567210197, 0.0855566188693047, 0.0856922045350075, 0.0858278796076775, 0.0859636962413788, 0.0860996022820473, 0.0862357392907143, 0.086371973156929, 0.0865082889795303, 0.0866447910666466, 0.0867813751101494, 0.0869182422757149, 0.0870550200343132, 0.0871921107172966, 0.0873293057084084, 0.0874666422605515, 0.0876040980219841, 0.0877416431903839, 0.0878793895244598, 0.0880172625184059, 0.0881553217768669, 0.0882934257388115, 0.0884317606687546, 0.0885701775550842, 0.0887086912989616, 0.088847391307354, 0.0889862701296806, 0.0891251564025879, 0.0892643183469772, 0.0894035622477531, 0.0895429998636246, 0.089682474732399, 0.0898221731185913, 0.0899618789553642, 0.0901018604636192, 0.090241938829422, 0.0903821438550949, 0.0905224457383156, 0.0906629636883736, 0.0908036008477211, 0.0909443125128746, 0.0910852551460266, 0.0912262424826622, 0.0913674533367157, 0.0915087684988976, 0.0916501581668854, 0.0917918309569359, 0.0919335559010506, 0.0920753255486488, 0.0922173708677292, 0.0923594534397125, 0.0925017669796944, 0.092644177377224, 0.0927867144346237, 0.0929293483495712, 0.0930722132325172, 0.0932151675224304, 0.0933583527803421, 0.0935015305876732, 0.0936449095606804, 0.0937884524464607, 0.0939320474863052, 0.0940758362412453, 0.0942197442054749, 0.094363808631897, 0.0945080444216728, 0.0946523249149323, 0.0947967916727066, 0.0949414521455765, 0.0950861796736717, 0.0952311009168625, 0.0953760743141174, 0.0955212265253067, 0.0956665724515915, 0.0958119928836823, 0.0959576517343521, 0.096103310585022, 0.0962491035461426, 0.0963951274752617, 0.0965411961078644, 0.096687488257885, 0.0968338847160339, 0.0969804003834724, 0.0971270650625229, 0.0972738713026047, 0.0974209010601044, 0.0975679308176041, 0.0977151393890381, 0.0978625416755676, 0.0980100259184837, 0.0981576889753342, 0.0983054041862488, 0.0984534025192261, 0.0986013934016228, 0.0987495630979538, 0.0988979637622833, 0.0990463718771935, 0.0991949662566185, 0.0993437319993973, 0.0994925945997238, 0.0996416807174683, 0.0997906774282455, 0.0999400019645691, 0.100089505314827, 0.100239008665085, 0.100388690829277, 0.100538559257984, 0.100688599050045, 0.100838661193848, 0.100988887250423, 0.101139307022095, 0.101289816200733, 0.101440504193306, 0.10159133374691, 0.101742208003998, 0.101893320679665, 0.102044463157654, 0.102195888757706, 0.102347314357758, 0.102498918771744, 0.102650798857212, 0.102802686393261, 0.10295470058918, 0.103106908500195, 0.103259153664112, 0.103411629796028, 0.103564195334911, 0.103716902434826, 0.103869840502739, 0.104022778570652, 0.104175940155983, 0.104329191148281, 0.104482680559158, 0.104636073112488, 0.10478987544775, 0.10494377464056, 0.105097576975822, 0.105251744389534, 0.105406008660793, 0.10556036233902, 0.105714857578278, 0.10586953163147, 0.106024339795113, 0.106179296970367, 0.106334276497364, 0.106489509344101, 0.106644876301289, 0.106800317764282, 0.106955960392952, 0.107111737132072, 0.107267588376999, 0.107423596084118, 0.107579827308655, 0.107736103236675, 0.107892476022243, 0.108049117028713, 0.108205802738667, 0.108362719416618, 0.10851962864399, 0.108676731586456, 0.108834065496922, 0.108991481363773, 0.109148994088173, 0.109306693077087, 0.109464578330517, 0.109622456133366, 0.109780512750149, 0.109938763082027, 0.110097147524357, 0.110255613923073, 0.110414326190948, 0.110572971403599, 0.110731944441795, 0.11089101433754, 0.111050225794315, 0.111209563910961, 0.111368998885155, 0.111528612673283, 0.111688420176506, 0.111848272383213, 0.112008258700371, 0.112168461084366, 0.112328670918941, 0.112489074468613, 0.112649664282799, 0.112810425460339, 0.112971268594265, 0.11313221603632, 0.113293386995792, 0.113454565405846, 0.113615967333317, 0.113777555525303, 0.113939233124256, 0.114100910723209, 0.114262953400612, 0.114425048232079, 0.114587277173996, 0.114749543368816, 0.114912047982216, 0.115074686706066, 0.115237511694431, 0.11540038138628, 0.115563377737999, 0.115726575255394, 0.115889936685562, 0.116053357720375, 0.116217002272606, 0.116380698978901, 0.116544522345066, 0.11670858412981, 0.116872690618038, 0.117037020623684, 0.117201447486877, 0.117365963757038, 0.117530658841133, 0.117695495486259, 0.117860473692417, 0.118025586009026, 0.118190787732601, 0.118356212973595, 0.118521690368652, 0.118687361478806, 0.118853107094765, 0.119019083678722, 0.119185067713261, 0.1193513199687, 0.119517758488655, 0.119684241712093, 0.119850814342499, 0.120017528533936, 0.120184525847435, 0.120351508259773, 0.120518729090691, 0.120685987174511, 0.120853431522846, 0.121021009981632, 0.121188640594482, 0.121356546878815, 0.121524639427662, 0.121692717075348, 0.121860951185226, 0.122029438614845, 0.122197993099689, 0.12236662209034, 0.122535444796085, 0.122704446315765, 0.122873440384865, 0.123042725026608, 0.123212091624737, 0.1233816370368, 0.123551197350025, 0.123721025884151, 0.123890936374664, 0.124060988426208, 0.124231234192848, 0.124401554465294, 0.124571934342384, 0.124742574989796, 0.124913319945335, 0.12508425116539, 0.125255271792412, 0.125426426529884, 0.125597715377808, 0.125769138336182, 0.12594074010849, 0.126112401485443, 0.126284241676331, 0.12645623087883, 0.126628383994102, 0.126800671219826, 0.126973032951355, 0.127145543694496, 0.12731821835041, 0.127491056919098, 0.127664059400558, 0.127837032079697, 0.128010243177414, 0.128183647990227, 0.128357082605362, 0.12853080034256, 0.128704562783241, 0.128878504037857, 0.129052460193634, 0.129226759076118, 0.129401028156281, 0.129575535655022, 0.129750072956085, 0.129924789071083, 0.130099698901176, 0.130274653434753, 0.130449786782265, 0.13062509894371, 0.130800515413284, 0.130976155400276, 0.131151840090752, 0.131327658891678, 0.131503716111183, 0.13167966902256, 0.131855994462967, 0.132032319903374, 0.132208928465843, 0.132385522127151, 0.132562309503555, 0.13273923099041, 0.132916331291199, 0.1330935806036, 0.133270904421806, 0.133448332548141, 0.133626028895378, 0.133803740143776, 0.133981615304947, 0.134159684181213, 0.134337887167931, 0.134516179561615, 0.13469460606575, 0.134873270988464, 0.135051980614662, 0.13523080945015, 0.13540980219841, 0.135588973760605, 0.135768219828606, 0.135947659611702, 0.136127188801765, 0.136306896805763, 0.136486664414406, 0.136666640639305, 0.136846721172333, 0.13702704012394, 0.137207299470901, 0.137387871742249, 0.137568548321724, 0.137749284505844, 0.137930274009705, 0.138111263513565, 0.138292536139488, 0.138473808765411, 0.138655349612236, 0.138836994767189, 0.139018714427948, 0.139200523495674, 0.139382585883141, 0.139564722776413, 0.13974703848362, 0.139929503202438, 0.140112057328224, 0.140294790267944, 0.140477657318115, 0.140660613775253, 0.140843778848648, 0.141027048230171, 0.141210421919823, 0.14139398932457, 0.141577586531639, 0.141761422157288, 0.141945391893387, 0.142129495739937, 0.142313659191132, 0.142498046159744, 0.142682611942291, 0.142867162823677, 0.143051967024803, 0.143236890435219, 0.143421918153763, 0.143607124686241, 0.143792405724525, 0.143977954983711, 0.144163578748703, 0.144349217414856, 0.144535169005394, 0.144721105694771, 0.144907340407372, 0.145093575119972, 0.14528001844883, 0.145466595888138, 0.145653322339058, 0.145840138196945, 0.146027117967606, 0.146214157342911, 0.146401420235634, 0.146588817238808, 0.146776363253593, 0.146964088082314, 0.147151827812195, 0.147339820861816, 0.147527903318405, 0.147716119885445, 0.147904440760612, 0.148092970252037, 0.148281559348106, 0.148470282554626, 0.148659184575081, 0.148848280310631, 0.149037420749664, 0.149226754903793, 0.14941617846489, 0.149605825543404, 0.14979550242424, 0.149985432624817, 0.1501754373312, 0.150365546345711, 0.150555789470673, 0.15074622631073, 0.15093682706356, 0.151127442717552, 0.151318311691284, 0.151509299874306, 0.151700392365456, 0.151891604065895, 0.15208300948143, 0.152274519205093, 0.152466133236885, 0.152657970786095, 0.152849912643433, 0.153041943907738, 0.153234139084816, 0.153426542878151, 0.153621882200241, 0.153820425271988, 0.154019117355347, 0.154217913746834, 0.154416739940643, 0.154615849256516, 0.154814898967743, 0.155014157295227, 0.155213549733162, 0.155413016676903, 0.155612647533417, 0.155812352895737, 0.156012147665024, 0.156212165951729, 0.156412184238434, 0.156612366437912, 0.156812742352486, 0.157013088464737, 0.157213643193245, 0.157414257526398, 0.157615065574646, 0.1578159481287, 0.158016875386238, 0.158218100667, 0.158419340848923, 0.15862064063549, 0.158822134137154, 0.1590236723423, 0.159225404262543, 0.159427151083946, 0.159629195928574, 0.159831181168556, 0.160033389925957, 0.160235673189163, 0.160438105463982, 0.160640582442284, 0.160843223333359, 0.161045998334885, 0.161248847842216, 0.16145184636116, 0.16165491938591, 0.161858186125755, 0.162061467766762, 0.162264958024025, 0.162468507885933, 0.162672221660614, 0.162875980138779, 0.163079887628555, 0.163283973932266, 0.163488179445267, 0.163692355155945, 0.163896843791008, 0.164101362228394, 0.16430589556694, 0.164510726928711, 0.164715513586998, 0.164920523762703, 0.165125548839569, 0.165330827236176, 0.165536135435104, 0.165741547942162, 0.165947064757347, 0.166152849793434, 0.166358575224876, 0.166564524173737, 0.16677051782608, 0.166976690292358, 0.167182922363281, 0.167389288544655, 0.167595833539963, 0.167802363634109, 0.168009117245674, 0.168215960264206, 0.168422907590866, 0.168630018830299, 0.1688372194767, 0.169044509530067, 0.169251948595047, 0.169459402561188, 0.169667154550552, 0.169874891638756, 0.170082792639732, 0.170290768146515, 0.170498937368393, 0.170707225799561, 0.170915484428406, 0.171123996376991, 0.171332597732544, 0.171541288495064, 0.171750113368034, 0.171959117054939, 0.172168135643005, 0.172377333045006, 0.172586664557457, 0.172796025872231, 0.173005551099777, 0.17321515083313, 0.173424929380417, 0.173634842038155, 0.173844814300537, 0.174054950475693, 0.174265205860138, 0.174475580453873, 0.174686029553413, 0.174896597862244, 0.175107300281525, 0.175318017601967, 0.175529032945633, 0.175740018486977, 0.175951227545738, 0.176162466406822, 0.176373913884163, 0.17658543586731, 0.176797017455101, 0.177008792757988, 0.177220672369003, 0.177432656288147, 0.177644729614258, 0.177856937050819, 0.178069263696671, 0.178281709551811, 0.178494304418564, 0.178706929087639, 0.178919732570648, 0.179132699966431, 0.17934575676918, 0.179558858275414, 0.179772108793259, 0.179985553026199, 0.180199012160301, 0.180412620306015, 0.180626377463341, 0.180840238928795, 0.1810542345047, 0.181268289685249, 0.181482434272766, 0.181696757674217, 0.18191123008728, 0.182125717401505, 0.182340443134308, 0.182555258274078, 0.182770177721977, 0.182985156774521, 0.183200269937515, 0.183415606617928, 0.183630928397179, 0.18384638428688, 0.184061959385872, 0.184277728199959, 0.184493541717529, 0.184709489345551, 0.184925526380539, 0.185141712427139, 0.185358062386513, 0.185574516654015, 0.185791000723839, 0.186007663607597, 0.186224460601807, 0.186441332101822, 0.186658293008804, 0.18687541782856, 0.187092706561089, 0.18731002509594, 0.187527477741241, 0.187745094299316, 0.187962800264359, 0.188180610537529, 0.188398584723473, 0.188616618514061, 0.188834816217422, 0.189053073525429, 0.189271479845047, 0.189489990472794, 0.189708635210991, 0.189927384257317, 0.190146222710609, 0.190365225076675, 0.190584301948547, 0.190803557634354, 0.191022887825966, 0.191242426633835, 0.191461980342865, 0.191681668162346, 0.191901445388794, 0.19212132692337, 0.192341446876526, 0.19256155192852, 0.192781835794449, 0.193002223968506, 0.193222746253014, 0.19344337284565, 0.193664148449898, 0.193884968757629, 0.194105923175812, 0.194327056407928, 0.194548264145851, 0.194769561290741, 0.194991037249565, 0.195212587714195, 0.195434227585793, 0.195656061172485, 0.195877924561501, 0.196099981665611, 0.196322157979012, 0.196544349193573, 0.196766793727875, 0.196989268064499, 0.197211906313896, 0.197434544563293, 0.197657436132431, 0.197880417108536, 0.198103427886963, 0.19832669198513, 0.198550000786781, 0.198773443698883, 0.19899694621563, 0.199220582842827, 0.199444353580475, 0.199668258428574, 0.199892312288284, 0.20011642575264, 0.200340673327446, 0.200565025210381, 0.200789511203766, 0.201014116406441, 0.201238766312599, 0.201463609933853, 0.201688572764397, 0.201913610100746, 0.202138856053352, 0.202364176511765, 0.202589571475983, 0.202815070748329, 0.203040733933449, 0.20326654613018, 0.203492388129234, 0.203718334436417, 0.203944444656372, 0.204170688986778, 0.204397037625313, 0.204623490571976, 0.204850047826767, 0.205076768994331, 0.205303579568863, 0.205530568957329, 0.205757528543472, 0.205984756350517, 0.206212073564529, 0.206439435482025, 0.206666946411133, 0.206894636154175, 0.2071223706007, 0.207350239157677, 0.207578182220459, 0.207806274294853, 0.208034485578537, 0.208262801170349, 0.208491295576096, 0.208719864487648, 0.208948567509651, 0.20917734503746, 0.209406271576881, 0.209635272622108, 0.209864437580109, 0.210093751549721, 0.210323110222816, 0.210552617907524, 0.21078222990036, 0.211011946201324, 0.211241781711578, 0.211471751332283, 0.211701914668083, 0.2119320333004, 0.21216244995594, 0.212392792105675, 0.212623357772827, 0.212854027748108, 0.213084846735001, 0.213315695524216, 0.213546723127365, 0.213777840137482, 0.214009135961533, 0.214240491390228, 0.214471980929375, 0.214703559875488, 0.214935332536697, 0.215167179703712, 0.215399116277695, 0.215631201863289, 0.215863406658173, 0.216095641255379, 0.216328084468842, 0.216560631990433, 0.216793283820152, 0.217026069760323, 0.217258900403976, 0.217491939663887, 0.217725068330765, 0.217958316206932, 0.21819169819355, 0.218425184488297, 0.218658789992332, 0.218892455101013, 0.219126254320145, 0.219360217452049, 0.21959425508976, 0.219828397035599, 0.220062673091888, 0.220297113060951, 0.22053162753582, 0.220766320824623, 0.221001029014587, 0.221235916018486, 0.221470937132835, 0.221706002950668, 0.221941262483597, 0.222176611423492, 0.222412079572678, 0.222647607326508, 0.222883313894272, 0.223119139671326, 0.223355025053024, 0.22359111905098, 0.223827198147774, 0.224063575267792, 0.224299937486649, 0.224536448717117, 0.224773049354553, 0.225009769201279, 0.225246638059616, 0.225483626127243, 0.225720718502998, 0.225957974791527, 0.226195260882378, 0.226432725787163, 0.226670235395432, 0.226907908916473, 0.227145776152611, 0.227383688092232, 0.227621659636497, 0.227859809994698, 0.228098079562187, 0.228336468338966, 0.228574976325035, 0.228813543915749, 0.229052260518074, 0.229291141033173, 0.229530081152916, 0.229769170284271, 0.230008378624916, 0.23024770617485, 0.230487152934074, 0.230726689100266, 0.230966374278069, 0.231206148862839, 0.231445997953415, 0.231685996055603, 0.231926143169403, 0.232166394591331, 0.232406765222549, 0.232647210359573, 0.232887834310532, 0.233128562569618, 0.233369380235672, 0.233610317111015, 0.233851402997971, 0.234092622995377, 0.234333887696266, 0.23457533121109, 0.23481684923172, 0.235058471560478, 0.23530025780201, 0.235542103648186, 0.235784068703651, 0.236026212573051, 0.23626846075058, 0.236510813236237, 0.236753284931183, 0.236995860934258, 0.237238571047783, 0.237481400370598, 0.237724289298058, 0.237967327237129, 0.238210514187813, 0.238453805446625, 0.238697215914726, 0.238940730690956, 0.239184379577637, 0.239428088068962, 0.239671960473061, 0.23991596698761, 0.24016010761261, 0.240404337644577, 0.240648627281189, 0.240893080830574, 0.241137653589249, 0.24138231575489, 0.241627126932144, 0.241872027516365, 0.242117062211037, 0.242362201213837, 0.242607489228249, 0.24285289645195, 0.243098452687263, 0.243344008922577, 0.243589758872986, 0.243835613131523, 0.244081571698189, 0.244327709078789, 0.244573831558228, 0.244820192456245, 0.245066598057747, 0.245313167572021, 0.245559856295586, 0.245806619524956, 0.24605356156826, 0.246300593018532, 0.246547728776932, 0.246794998645782, 0.247042372822762, 0.247289881110191, 0.247537434101105, 0.247785165905952, 0.248033002018929, 0.248280957341194, 0.248528972268105, 0.24877718091011, 0.249025493860245, 0.249273970723152, 0.249522492289543, 0.249771118164062, 0.250019878149033, 0.250268787145615, 0.250517785549164, 0.250766843557358, 0.251016199588776, 0.251265555620193, 0.251515001058578, 0.251764595508575, 0.252014309167862, 0.252264112234116, 0.252514064311981, 0.252764105796814, 0.253014326095581, 0.253264605998993, 0.253515034914017, 0.253765493631363, 0.254016131162643, 0.254266917705536, 0.254517793655396, 0.254768788814545, 0.255019843578339, 0.255271166563034, 0.255522519350052, 0.255773901939392, 0.256025493144989, 0.256277233362198, 0.256529062986374, 0.256780922412872, 0.257032960653305, 0.25728514790535, 0.257537454366684, 0.257789820432663, 0.258042275905609, 0.258294939994812, 0.258547693490982, 0.258800536394119, 0.259053528308868, 0.259306609630585, 0.259559869766235, 0.259813189506531, 0.260066658258438, 0.260320216417313, 0.260573893785477, 0.260827660560608, 0.261081576347351, 0.261335581541061, 0.261589765548706, 0.261844009160995, 0.262098342180252, 0.262352854013443, 0.262607514858246, 0.262862235307693, 0.263117045164108, 0.263372004032135, 0.263627111911774, 0.26388230919838, 0.264137625694275, 0.264393091201782, 0.264648616313934, 0.264904320240021, 0.265160024166107, 0.26541593670845, 0.265671938657761, 0.265928119421005, 0.266184359788895, 0.266440749168396, 0.266697198152542, 0.2669537961483, 0.26721054315567, 0.267471641302109, 0.267737507820129, 0.268003433942795, 0.268269389867783, 0.268535375595093, 0.268801420927048, 0.26906743645668, 0.26933354139328, 0.269599616527557, 0.269865810871124, 0.270131975412369, 0.27039822936058, 0.270664513111115, 0.270930767059326, 0.271197140216827, 0.271463513374329, 0.271729975938797, 0.271996378898621, 0.272262901067734, 0.272529393434525, 0.27279594540596, 0.273062586784363, 0.273329198360443, 0.273595869541168, 0.273862570524216, 0.274129301309586, 0.274396121501923, 0.27466294169426, 0.274929732084274, 0.275196641683578, 0.275463581085205, 0.275730490684509, 0.275997519493103, 0.276264548301697, 0.276531577110291, 0.276798725128174, 0.277065843343735, 0.277332991361618, 0.277600258588791, 0.277867496013641, 0.278134793043137, 0.278402119874954, 0.278669476509094, 0.278936833143234, 0.279204279184341, 0.279471725225449, 0.279739230871201, 0.280006766319275, 0.280274301767349, 0.280541956424713, 0.280809611082077, 0.281077295541763, 0.281344950199127, 0.281612783670425, 0.281880557537079, 0.282148391008377, 0.282416254281998, 0.282684147357941, 0.282952100038528, 0.283220082521439, 0.283488065004349, 0.283756136894226, 0.284024208784103, 0.284292310476303, 0.284560471773148, 0.284828662872314, 0.285096883773804, 0.285365134477615, 0.285633444786072, 0.285901725292206, 0.286170125007629, 0.286438554525375, 0.286707013845444, 0.286975502967834, 0.287244021892548, 0.287512540817261, 0.287781178951263, 0.288049757480621, 0.288318395614624, 0.288587123155594, 0.288855850696564, 0.289124578237534, 0.289393454790115, 0.289662271738052, 0.289931118488312, 0.290200054645538, 0.290468990802765, 0.290737956762314, 0.29100701212883, 0.291276067495346, 0.291545212268829, 0.291814357042313, 0.292083501815796, 0.292352706193924, 0.292621970176697, 0.292891204357147, 0.293160557746887, 0.293429851531982, 0.293699234724045, 0.29396864771843, 0.294238150119781, 0.294507563114166, 0.294777125120163, 0.295046716928482, 0.295316308736801, 0.295585960149765, 0.295855641365051, 0.296125382184982, 0.296395123004913, 0.296664863824844, 0.296934723854065, 0.297204583883286, 0.297474473714828, 0.297744363546371, 0.298014312982559, 0.298284351825714, 0.298554390668869, 0.298824489116669, 0.299094557762146, 0.29936471581459, 0.299634873867035, 0.299905151128769, 0.300175309181213, 0.300445675849915, 0.300715982913971, 0.300986379384995, 0.301256746053696, 0.301527172327042, 0.301797688007355, 0.302068203687668, 0.302338689565659, 0.302609294652939, 0.302879929542542, 0.303150564432144, 0.303421258926392, 0.303691953420639, 0.303962707519531, 0.304233491420746, 0.30450439453125, 0.304775208234787, 0.305046200752258, 0.305317103862762, 0.305588096380234, 0.305859118700027, 0.306130141019821, 0.306401252746582, 0.306672364473343, 0.306943506002426, 0.307214707136154, 0.307485938072205, 0.3077572286129, 0.308028489351273, 0.308299869298935, 0.308571249246597, 0.308842658996582, 0.309114068746567, 0.309385597705841, 0.309657067060471, 0.309928685426712, 0.310200273990631, 0.310471892356873, 0.310743600130081, 0.311015278100967, 0.311287015676498, 0.311558783054352, 0.311830580234528, 0.312102466821671, 0.312374293804169, 0.312646210193634, 0.312918186187744, 0.313190221786499, 0.313462197780609, 0.313734263181686, 0.314006417989731, 0.31427851319313, 0.31455072760582, 0.314822912216187, 0.315095156431198, 0.315367490053177, 0.315639734268188, 0.315912157297134, 0.316184520721436, 0.316456973552704, 0.316729426383972, 0.317001909017563, 0.317274451255798, 0.317546963691711, 0.317819625139236, 0.318092286586761, 0.318364918231964, 0.318637639284134, 0.318910449743271, 0.319183260202408, 0.319456040859222, 0.319728910923004, 0.320001810789108, 0.32027480006218, 0.320547729730606, 0.320820689201355, 0.321093797683716, 0.321366846561432, 0.321639984846115, 0.321913123130798, 0.322186291217804, 0.322459518909454, 0.32273280620575, 0.323006063699722, 0.323279410600662, 0.323552787303925, 0.323826193809509, 0.324099659919739, 0.324373126029968, 0.32464662194252, 0.324920207262039, 0.325193792581558, 0.3254674077034, 0.325741082429886, 0.326014757156372, 0.326288461685181, 0.326562285423279, 0.326836079359055, 0.327109903097153, 0.327383756637573, 0.327657669782639, 0.327931642532349, 0.328205615282059, 0.328479677438736, 0.328753739595413, 0.32902780175209, 0.329301953315735, 0.329576134681702, 0.329850345849991, 0.33012455701828, 0.330398797988892, 0.330673158168793, 0.330947488546371, 0.331221848726273, 0.331496298313141, 0.331770747900009, 0.332045257091522, 0.332319796085358, 0.332594335079193, 0.332868903875351, 0.333143621683121, 0.333418250083923, 0.333692997694016, 0.333967745304108, 0.3342424929142, 0.334517329931259, 0.334792196750641, 0.335067063570023, 0.335341989994049, 0.33561697602272, 0.335891932249069, 0.336166948080063, 0.336442053318024, 0.336717158555984, 0.336992293596268, 0.337267458438873, 0.337542712688446, 0.337817966938019, 0.338093280792236, 0.338368594646454, 0.338643968105316, 0.338919371366501, 0.339194804430008, 0.33947029709816, 0.339745759963989, 0.340021282434464, 0.340296864509583, 0.340572506189346, 0.34084814786911, 0.341123849153519, 0.34139958024025, 0.341675311326981, 0.341951131820679, 0.342226952314377, 0.342502862215042, 0.342778772115707, 0.343054711818695, 0.343330681324005, 0.343606650829315, 0.343882709741592, 0.344158798456192, 0.344434916973114, 0.344711095094681, 0.344987273216248, 0.345263540744781, 0.345539778470993, 0.345816075801849, 0.34609243273735, 0.346368819475174, 0.346645206212997, 0.346921652555466, 0.347198158502579, 0.347474634647369, 0.34775123000145, 0.348027884960175, 0.348304480314255, 0.348581165075302, 0.348857820034027, 0.349134564399719, 0.349411368370056, 0.349688172340393, 0.349964946508408, 0.350241899490356, 0.350518822669983, 0.350795775651932, 0.351072728633881, 0.351349771022797, 0.351626813411713, 0.351903915405273, 0.352181077003479, 0.352458268404007, 0.352735489606857, 0.353012770414352, 0.35328996181488, 0.353567332029343, 0.353844672441483, 0.354122072458267, 0.354399502277374, 0.354676902294159, 0.354954451322556, 0.35523197054863, 0.355509579181671, 0.35578715801239, 0.356064796447754, 0.356342494487762, 0.356620192527771, 0.356897979974747, 0.357175767421722, 0.357453584671021, 0.357731491327286, 0.358009397983551, 0.358287274837494, 0.358565241098404, 0.358843266963959, 0.359121292829514, 0.359399408102036, 0.359677493572235, 0.359955638647079, 0.360233843326569, 0.36051207780838, 0.360790312290192, 0.361068606376648, 0.361346900463104, 0.361625343561172, 0.361903727054596, 0.362182170152664, 0.362460672855377, 0.36273917555809, 0.363017708063126, 0.363296329975128, 0.363574922084808, 0.363853573799133, 0.364132285118103, 0.364410996437073, 0.364689767360687, 0.364968568086624, 0.365247398614883, 0.365526258945465, 0.365805178880692, 0.36608412861824, 0.366363167762756, 0.36664217710495, 0.366921216249466, 0.367200314998627, 0.36747944355011, 0.367758601903915, 0.368037849664688, 0.368317037820816, 0.368596315383911, 0.368875622749329, 0.369154989719391, 0.369434356689453, 0.36971378326416, 0.36999323964119, 0.370272755622864, 0.370552271604538, 0.370831817388535, 0.371111422777176, 0.371391087770462, 0.371670782566071, 0.371950477361679, 0.372230172157288, 0.372509986162186, 0.372789800167084, 0.373069673776627, 0.373349517583847, 0.373629510402679, 0.373909443616867, 0.374189376831055, 0.374469459056854, 0.374749511480331, 0.375029623508453, 0.37530979514122, 0.375589936971664, 0.375870227813721, 0.37615042924881, 0.376430720090866, 0.376711040735245, 0.376991450786591, 0.377271801233292, 0.37755224108696, 0.37783271074295, 0.378113210201263, 0.378393769264221, 0.378674328327179, 0.378954976797104, 0.379235595464706, 0.379516273736954, 0.379797041416168, 0.380077809095383, 0.380358576774597, 0.380639404058456, 0.380920320749283, 0.381201207637787, 0.381482154130936, 0.381763130426407, 0.3820441365242, 0.382325172424316, 0.382606238126755, 0.38288739323616, 0.383168518543243, 0.383449733257294, 0.383730977773666, 0.384012222290039, 0.384293526411057, 0.384574860334396, 0.384856224060059, 0.385137647390366, 0.385419130325317, 0.385700643062592, 0.385982096195221, 0.386263728141785, 0.386545270681381, 0.386826902627945, 0.387108594179153, 0.38739025592804, 0.387672036886215, 0.387953788042068, 0.388235598802567, 0.388517439365387, 0.388799339532852, 0.389081209897995, 0.389363139867783, 0.38964518904686, 0.389927178621292, 0.390209317207336, 0.390491366386414, 0.390773504972458, 0.391055703163147, 0.391337901353836, 0.391620188951492, 0.391902416944504, 0.392184734344482, 0.392467111349106, 0.392749458551407, 0.39303195476532, 0.393314361572266, 0.393596887588501, 0.393879383802414, 0.394161969423294, 0.394444555044174, 0.394727200269699, 0.395009845495224, 0.395292639732361, 0.395575374364853, 0.39585816860199, 0.396141022443771, 0.396423846483231, 0.396706759929657, 0.396989673376083, 0.397272616624832, 0.397555649280548, 0.397838681936264, 0.398121803998947, 0.398404866456985, 0.398688048124313, 0.398971199989319, 0.399254471063614, 0.399537712335587, 0.399820983409882, 0.400104373693466, 0.400387734174728, 0.400671154260635, 0.400954574346542, 0.401238024234772, 0.401521593332291, 0.401805102825165, 0.402088671922684, 0.402372300624847, 0.402655959129333, 0.402939647436142, 0.403223395347595, 0.403507143259048, 0.403790980577469, 0.404074817895889, 0.404358685016632, 0.404642552137375, 0.404929220676422, 0.405218034982681, 0.405506700277328, 0.405795305967331, 0.406083822250366, 0.406372219324112, 0.406660497188568, 0.40694871544838, 0.407236814498901, 0.407524764537811, 0.407812714576721, 0.408100426197052, 0.408388167619705, 0.408675789833069, 0.408963263034821, 0.409250646829605, 0.409537941217422, 0.409825176000595, 0.410112261772156, 0.410399258136749, 0.410686165094376, 0.41097292304039, 0.411259651184082, 0.411546230316162, 0.411832720041275, 0.412119090557098, 0.412405401468277, 0.412691563367844, 0.412977695465088, 0.413263708353043, 0.413549572229385, 0.413835346698761, 0.414121031761169, 0.414406597614288, 0.414692133665085, 0.414977550506592, 0.415262848138809, 0.415548026561737, 0.415833085775375, 0.416118055582047, 0.416402995586395, 0.41668775677681, 0.416972458362579, 0.417257070541382, 0.417541563510895, 0.417825907468796, 0.418110221624374, 0.418394386768341, 0.418678522109985, 0.418962478637695, 0.41924637556076, 0.419530183076859, 0.419813901185989, 0.420097470283508, 0.420380979776382, 0.420664340257645, 0.420947641134262, 0.421230852603912, 0.421513915061951, 0.421796858310699, 0.422079801559448, 0.422362565994263, 0.42264524102211, 0.42292782664299, 0.423210293054581, 0.423492699861526, 0.423774987459183, 0.424057126045227, 0.424339324235916, 0.424621254205704, 0.424903184175491, 0.425184965133667, 0.425466626882553, 0.425748199224472, 0.426029711961746, 0.426311075687408, 0.426592350006104, 0.426873534917831, 0.427154630422592, 0.427435576915741, 0.427716463804245, 0.427997261285782, 0.428277969360352, 0.428558528423309, 0.428839027881622, 0.429119408130646, 0.429399728775024, 0.429679900407791, 0.429959982633591, 0.430239975452423, 0.430519849061966, 0.430799603462219, 0.43107932806015, 0.431358903646469, 0.431638330221176, 0.431917726993561, 0.432197034358978, 0.432476192712784, 0.432755291461945, 0.433034241199493, 0.433313131332397, 0.433591932058334, 0.433870583772659, 0.434149235486984, 0.434427678585052, 0.434706032276154, 0.434984356164932, 0.435262560844421, 0.435540616512299, 0.435818582773209, 0.436096459627151, 0.436374217271805, 0.436651915311813, 0.436929494142532, 0.437206953763962, 0.437484323978424, 0.437761604785919, 0.438038796186447, 0.438315898180008, 0.438592880964279, 0.438869744539261, 0.43914657831192, 0.439423263072968, 0.439699798822403, 0.439976274967194, 0.440252631902695, 0.440528959035873, 0.440805107355118, 0.441081196069717, 0.441357105970383, 0.441633015871048, 0.441908776760101, 0.442184448242188, 0.442460060119629, 0.442735522985458, 0.443010926246643, 0.443286180496216, 0.443561375141144, 0.443836450576782, 0.444111436605453, 0.444386303424835, 0.44466108083725, 0.444935739040375, 0.445210367441177, 0.445484787225723, 0.445759177207947, 0.446033447980881, 0.446307629346848, 0.446581661701202, 0.446855634450912, 0.447129517793655, 0.447403341531754, 0.447676956653595, 0.447950512170792, 0.448224037885666, 0.448497414588928, 0.448770672082901, 0.449043840169907, 0.449316948652267, 0.449589908123016, 0.449862748384476, 0.450135558843613, 0.450408220291138, 0.450680762529373, 0.450953274965286, 0.451225608587265, 0.451497882604599, 0.451770067214966, 0.452042132616043, 0.452314078807831, 0.452585965394974, 0.452857732772827, 0.453129440546036, 0.453400999307632, 0.45367243885994, 0.453943848609924, 0.454215109348297, 0.454486280679703, 0.454757362604141, 0.45502832531929, 0.455299198627472, 0.455569893121719, 0.455840617418289, 0.456111192703247, 0.456381618976593, 0.456652015447617, 0.456922233104706, 0.457192450761795, 0.457462519407272, 0.457732528448105, 0.458002358675003, 0.458272159099579, 0.458541810512543, 0.458811342716217, 0.459080815315247, 0.459350198507309, 0.459619462490082, 0.459888607263565, 0.460157692432404, 0.460426658391953, 0.460695505142212, 0.460964262485504, 0.461232960224152, 0.46150153875351, 0.461769968271255, 0.462038338184357, 0.462306648492813, 0.462574750185013, 0.462842881679535, 0.463110774755478, 0.463378667831421, 0.463646471500397, 0.463914096355438, 0.464181661605835, 0.464449137449265, 0.464716464281082, 0.464983731508255, 0.465250909328461, 0.465517967939377, 0.465784966945648, 0.466051787137985, 0.466318607330322, 0.466585248708725, 0.466851770877838, 0.467118233442307, 0.46738463640213, 0.467650830745697, 0.467917025089264, 0.468183100223541, 0.468449085950851, 0.468714892864227, 0.468980669975281, 0.469246327877045, 0.469511926174164, 0.469777375459671, 0.470042735338211, 0.470307976007462, 0.470573127269745, 0.470838189125061, 0.47110316157341, 0.471368014812469, 0.471632778644562, 0.471897423267365, 0.472162038087845, 0.472426444292068, 0.472690790891647, 0.472955048084259, 0.473219245672226, 0.473483264446259, 0.473747193813324, 0.474011063575745, 0.474274843931198, 0.474538505077362, 0.474802047014236, 0.475065529346466, 0.475328892469406, 0.475592136383057, 0.47585529088974, 0.476118355989456, 0.476381301879883, 0.476644158363342, 0.476906955242157, 0.477169573307037, 0.477432131767273, 0.477694600820541, 0.47795695066452, 0.478219211101532, 0.478481382131577, 0.478743404150009, 0.479005366563797, 0.479267239570618, 0.479528993368149, 0.47979062795639, 0.480052173137665, 0.480313658714294, 0.480575025081635, 0.480836272239685, 0.481097370386124, 0.481358498334885, 0.481619447469711, 0.481880277395248, 0.482141047716141, 0.482401669025421, 0.482662230730057, 0.482922673225403, 0.483182996511459, 0.483443260192871, 0.483703434467316, 0.483963489532471, 0.484223455190659, 0.484483271837234, 0.484743028879166, 0.48500269651413, 0.485262215137482, 0.485521733760834, 0.485781043767929, 0.48604029417038, 0.486299455165863, 0.486558496952057, 0.486817449331284, 0.487076252698898, 0.487335026264191, 0.487593680620193, 0.487852215766907, 0.488110691308975, 0.488369047641754, 0.488627314567566, 0.488885432481766, 0.489143490791321, 0.489401429891586, 0.489659279584885, 0.489917010068893, 0.49017471075058, 0.490432262420654, 0.490689635276794, 0.490947008132935, 0.491204261779785, 0.491461426019669, 0.491718471050262, 0.491975426673889, 0.492232233285904, 0.492488950490952, 0.492745667695999, 0.49300217628479, 0.493258655071259, 0.493514955043793, 0.493771225214005, 0.494027376174927, 0.494283407926559, 0.494539320468903, 0.494795203208923, 0.495050966739655, 0.495306611061096, 0.495562136173248, 0.495817571878433, 0.496072977781296, 0.496328204870224, 0.496583312749863, 0.496838361024857, 0.497093319892883, 0.497348129749298, 0.497602909803391, 0.497857570648193, 0.498112082481384, 0.498366504907608, 0.498620897531509, 0.498875111341476, 0.499129295349121, 0.499383330345154, 0.499637216329575, 0.499891102313995, 0.500144839286804, 0.500398457050323, 0.500652015209198, 0.500905454158783, 0.501158773899078, 0.501412034034729, 0.50166517496109, 0.501918196678162, 0.502171158790588, 0.502424001693726, 0.502676725387573, 0.502929329872131, 0.503181874752045, 0.503434360027313, 0.503686726093292, 0.503938972949982, 0.504191100597382, 0.504443109035492, 0.504695057868958, 0.504946887493134, 0.505198657512665, 0.505450308322906, 0.505701839923859, 0.505953252315521, 0.506204545497894, 0.506455779075623, 0.506706953048706, 0.5069580078125, 0.507208943367004, 0.507459759712219, 0.507710516452789, 0.50796115398407, 0.508211672306061, 0.508462131023407, 0.508712470531464, 0.508962690830231, 0.509212851524353, 0.509462833404541, 0.509712755680084, 0.509962618350983, 0.510212421417236, 0.510461986064911, 0.510711550712585, 0.51096099615097, 0.511210322380066, 0.511459529399872, 0.511708617210388, 0.511957705020905, 0.512206673622131, 0.512455463409424, 0.512704253196716, 0.512952864170074, 0.513201415538788, 0.513449788093567, 0.513698160648346, 0.513946354389191, 0.514194488525391, 0.514442563056946, 0.514690518379211, 0.514938354492188, 0.515186071395874, 0.515433669090271, 0.515681207180023, 0.515928626060486, 0.516175985336304, 0.516423165798187, 0.516670286655426, 0.51691734790802, 0.517164289951324, 0.517411112785339, 0.517657876014709, 0.51790452003479, 0.518150985240936, 0.518397450447083, 0.518643796443939, 0.518889963626862, 0.519136190414429, 0.519382178783417, 0.51962810754776, 0.519873917102814, 0.520119667053223, 0.520365238189697, 0.520610809326172, 0.520856201648712, 0.521101593971252, 0.521346807479858, 0.521591901779175, 0.521836936473846, 0.522081851959229, 0.522326707839966, 0.522571444511414, 0.522816061973572, 0.523060619831085, 0.523305058479309, 0.523549377918243, 0.523793578147888, 0.524037718772888, 0.524281740188599, 0.52452564239502, 0.524769484996796, 0.525013208389282, 0.525256812572479, 0.525500357151031, 0.525743782520294, 0.525987088680267, 0.52623039484024, 0.526473462581635, 0.526716470718384, 0.526959419250488, 0.527202248573303, 0.527444958686829, 0.527687609195709, 0.5279301404953, 0.528172552585602, 0.528414905071259, 0.528657078742981, 0.528899192810059, 0.529141187667847, 0.529383182525635, 0.529624998569489, 0.529866695404053, 0.530108332633972, 0.530349791049957, 0.530591249465942, 0.530832648277283, 0.531073808670044, 0.53131490945816, 0.531555950641632, 0.531796872615814, 0.532037675380707, 0.532278418540955, 0.532519042491913, 0.532759547233582, 0.532999992370605, 0.53324031829834, 0.533480525016785, 0.533720672130585, 0.53396064043045, 0.534200549125671, 0.534440398216248, 0.534680128097534, 0.534919738769531, 0.535159289836884, 0.535398662090302, 0.535638034343719, 0.535877227783203, 0.536116302013397, 0.536355316638947, 0.536594271659851, 0.536828517913818, 0.537057995796204, 0.537287175655365, 0.537516117095947, 0.537744879722595, 0.537973463535309, 0.538201749324799, 0.538429856300354, 0.53865772485733, 0.538885474205017, 0.539112865924835, 0.539340078830719, 0.539567112922668, 0.539793908596039, 0.54002046585083, 0.540246784687042, 0.54047292470932, 0.540698826313019, 0.540924549102783, 0.541150033473969, 0.54137521982193, 0.541600227355957, 0.54182505607605, 0.542049646377563, 0.542273998260498, 0.542498171329498, 0.542722105979919, 0.542945861816406, 0.543169319629669, 0.543392598628998, 0.543615639209747, 0.543838500976562, 0.544061064720154, 0.544283449649811, 0.544505655765533, 0.544727563858032, 0.544949352741241, 0.545170843601227, 0.545392096042633, 0.545613169670105, 0.545834064483643, 0.546054720878601, 0.546275079250336, 0.546495318412781, 0.546715319156647, 0.546935021877289, 0.547154605388641, 0.54737389087677, 0.547592997550964, 0.54781186580658, 0.54803055524826, 0.548249006271362, 0.548467218875885, 0.548685193061829, 0.548902988433838, 0.549120545387268, 0.549337863922119, 0.549555003643036, 0.549771904945374, 0.549988567829132, 0.550205051898956, 0.550421297550201, 0.550637364387512, 0.550853133201599, 0.551068723201752, 0.551284074783325, 0.551499247550964, 0.55171412229538, 0.551928877830505, 0.552143335342407, 0.552357614040375, 0.552571654319763, 0.552785456180573, 0.552999079227448, 0.553212463855743, 0.553425669670105, 0.553638637065887, 0.553851246833801, 0.554063856601715, 0.55427610874176, 0.554488182067871, 0.554700016975403, 0.554911673069, 0.555123090744019, 0.555334270000458, 0.555545210838318, 0.555755972862244, 0.555966556072235, 0.556176841259003, 0.556386947631836, 0.556596755981445, 0.556806445121765, 0.557015895843506, 0.557225167751312, 0.557434141635895, 0.557642936706543, 0.557851493358612, 0.558059811592102, 0.558267891407013, 0.558475852012634, 0.558683454990387, 0.55889093875885, 0.559098184108734, 0.559305191040039, 0.55951201915741, 0.559718549251556, 0.559924960136414, 0.560131072998047, 0.560337007045746, 0.560542702674866, 0.560748159885406, 0.560953438282013, 0.56115847826004, 0.561363279819489, 0.561567902565002, 0.561772286891937, 0.561976432800293, 0.56218034029007, 0.562384128570557, 0.56258761882782, 0.562790930271149, 0.562994003295898, 0.563196837902069, 0.563399434089661, 0.563601851463318, 0.563804090023041, 0.56400603055954, 0.56420773267746, 0.564409255981445, 0.564610600471497, 0.564811646938324, 0.565012574195862, 0.565213203430176, 0.565413594245911, 0.565613806247711, 0.565813839435577, 0.56601357460022, 0.566213130950928, 0.566412508487701, 0.566611647605896, 0.566810488700867, 0.567009150981903, 0.567207634449005, 0.567405819892883, 0.567603886127472, 0.567801654338837, 0.567999243736267, 0.568196594715118, 0.568393707275391, 0.568590641021729, 0.568787336349487, 0.568983852863312, 0.569180071353912, 0.569376111030579, 0.569571912288666, 0.569767534732819, 0.569962918758392, 0.570158064365387, 0.570352971553802, 0.570547759532928, 0.570742189884186, 0.570936501026154, 0.571130514144897, 0.571324408054352, 0.571518063545227, 0.571711421012878, 0.571904599666595, 0.572097539901733, 0.572290301322937, 0.572482824325562, 0.572675108909607, 0.572867214679718, 0.573059022426605, 0.573250710964203, 0.573442161083221, 0.573633372783661, 0.573824346065521, 0.574015140533447, 0.574205636978149, 0.574396014213562, 0.574586093425751, 0.574775993824005, 0.574965596199036, 0.575155138969421, 0.575344264507294, 0.575533270835876, 0.57572215795517, 0.575910687446594, 0.576099038124084, 0.576287150382996, 0.576475083827972, 0.57666277885437, 0.576850295066833, 0.577037513256073, 0.577224612236023, 0.577411413192749, 0.577597916126251, 0.577784359455109, 0.577970445156097, 0.578156411647797, 0.578342080116272, 0.578527629375458, 0.578712940216064, 0.578897953033447, 0.579082727432251, 0.57926732301712, 0.579451858997345, 0.579635977745056, 0.579819917678833, 0.580003678798676, 0.580187201499939, 0.580370426177979, 0.580553591251373, 0.580736398696899, 0.580919027328491, 0.581101477146149, 0.581283748149872, 0.581465661525726, 0.581647455692291, 0.581828951835632, 0.582010328769684, 0.582191407680511, 0.582372307777405, 0.582552969455719, 0.582733392715454, 0.582913637161255, 0.583093583583832, 0.583273410797119, 0.583452999591827, 0.583632290363312, 0.583811461925507, 0.583990335464478, 0.584169030189514, 0.584347546100616, 0.58452570438385, 0.584703803062439, 0.584881544113159, 0.58505916595459, 0.585236608982086, 0.585413694381714, 0.585590600967407, 0.585767328739166, 0.585943758487701, 0.586120069026947, 0.586296141147614, 0.586471915245056, 0.586647510528564, 0.586822986602783, 0.586998105049133, 0.587173104286194, 0.587347865104675, 0.587522387504578, 0.587696611881256, 0.587870717048645, 0.58804452419281, 0.588218212127686, 0.588391602039337, 0.58856475353241, 0.588737785816193, 0.588910579681396, 0.589083075523376, 0.589255392551422, 0.589427411556244, 0.589599311351776, 0.589771032333374, 0.589942455291748, 0.590113699436188, 0.590284705162048, 0.59045547246933, 0.590626001358032, 0.590796411037445, 0.590966522693634, 0.591136395931244, 0.591306090354919, 0.591475546360016, 0.591644704341888, 0.591813743114471, 0.591982662677765, 0.592151165008545, 0.592319548130035, 0.592487692832947, 0.592655599117279, 0.592823386192322, 0.592990815639496, 0.593158066272736, 0.593325138092041, 0.593491971492767, 0.593658566474915, 0.593824923038483, 0.593991100788116, 0.594157040119171, 0.594322800636292, 0.594488322734833, 0.59465354681015, 0.594818592071533, 0.594983458518982, 0.595148146152496, 0.595312595367432, 0.595476686954498, 0.59564071893692, 0.595804512500763, 0.595968008041382, 0.596131324768066, 0.596294343471527, 0.596457242965698, 0.59661990404129, 0.596782326698303, 0.596944510936737, 0.597106575965881, 0.597268342971802, 0.597429871559143, 0.59759122133255, 0.597752332687378, 0.597913205623627, 0.598073899745941, 0.598234355449677, 0.598394572734833, 0.59855455160141, 0.598714470863342, 0.598874032497406, 0.599033355712891, 0.599192559719086, 0.599351406097412, 0.599510133266449, 0.599668622016907, 0.599826872348785, 0.59998494386673, 0.600142776966095, 0.600300312042236, 0.600457727909088, 0.600614845752716, 0.600771844387054, 0.600928485393524, 0.601085007190704, 0.60124135017395, 0.601397395133972, 0.60155326128006, 0.601708829402924, 0.601864278316498, 0.602019429206848, 0.602174460887909, 0.602329194545746, 0.602483689785004, 0.602638006210327, 0.602792024612427, 0.602945983409882, 0.603099644184113, 0.603253066539764, 0.603406250476837, 0.603559195995331, 0.603712022304535, 0.60386449098587, 0.604016840457916, 0.604169011116028, 0.604320883750916, 0.604472517967224, 0.604624032974243, 0.604775190353394, 0.604926288127899, 0.605077028274536, 0.605227589607239, 0.605378031730652, 0.605528116226196, 0.605678081512451, 0.605827689170837, 0.605977237224579, 0.606126487255096, 0.60627543926239, 0.606424391269684, 0.606572866439819, 0.60672128200531, 0.606869518756866, 0.607017338275909, 0.607165038585663, 0.607312619686127, 0.607459902763367, 0.607606947422028, 0.607753813266754, 0.607900381088257, 0.60804682970047, 0.608192980289459, 0.608339011669159, 0.60848468542099, 0.608630239963531, 0.608775496482849, 0.608920633792877, 0.609065473079681, 0.609210073947906, 0.609354555606842, 0.609498679637909, 0.609642684459686, 0.609786450862885, 0.609930038452148, 0.610073387622833, 0.610216438770294, 0.610359311103821, 0.610501945018768, 0.610644459724426, 0.61078667640686, 0.610928654670715, 0.611070454120636, 0.611212015151978, 0.611353397369385, 0.611494481563568, 0.611635446548462, 0.611776173114777, 0.611916601657867, 0.612056791782379, 0.612196862697601, 0.612336695194244, 0.612476289272308, 0.612615644931793, 0.612754821777344, 0.612893760204315, 0.613032400608063, 0.613170921802521, 0.6133092045784, 0.613447248935699, 0.613585114479065, 0.613722801208496, 0.613860130310059, 0.613997220993042, 0.614134252071381, 0.61427104473114, 0.614407539367676, 0.614543795585632, 0.614679932594299, 0.614815771579742, 0.614951431751251, 0.615086793899536, 0.615221977233887, 0.615356981754303, 0.61549174785614, 0.615626335144043, 0.615760624408722, 0.615894794464111, 0.616028606891632, 0.616162300109863, 0.616295695304871, 0.616428971290588, 0.616561889648438, 0.616694688796997, 0.616827249526978, 0.616959571838379, 0.617091715335846, 0.617223680019379, 0.617355346679688, 0.617486774921417, 0.617618083953857, 0.617749094963074, 0.617879807949066, 0.618010461330414, 0.618140876293182, 0.618270933628082, 0.618400871753693, 0.618530690670013, 0.618660092353821, 0.618789434432983, 0.618918418884277, 0.619047284126282, 0.619175910949707, 0.619304239749908, 0.61943244934082, 0.619560360908508, 0.619688034057617, 0.619815647602081, 0.619942903518677, 0.620070040225983, 0.62019681930542, 0.620323419570923, 0.620449960231781, 0.620576083660126, 0.620701968669891, 0.620827794075012, 0.620953321456909, 0.621078670024872, 0.621203780174255, 0.621328592300415, 0.62145334482193, 0.621577739715576, 0.621701955795288, 0.621825993061066, 0.621949791908264, 0.622073292732239, 0.622196614742279, 0.62231969833374, 0.622442662715912, 0.62256532907486, 0.622687876224518, 0.622810065746307, 0.622932136058807, 0.623053848743439, 0.623175382614136, 0.623296856880188, 0.623417973518372, 0.623538911342621, 0.623659551143646, 0.623780012130737, 0.623900353908539, 0.624020457267761, 0.624135494232178, 0.624245941638947, 0.624356150627136, 0.624466061592102, 0.624575674533844, 0.624685108661652, 0.624794125556946, 0.624902963638306, 0.625011503696442, 0.625119864940643, 0.625227868556976, 0.62533563375473, 0.625443160533905, 0.625550329685211, 0.625657379627228, 0.625764071941376, 0.625870525836945, 0.62597668170929, 0.626082599163055, 0.626188278198242, 0.626293659210205, 0.626398801803589, 0.626503586769104, 0.626608192920685, 0.626712560653687, 0.62681645154953, 0.626920342445374, 0.627023875713348, 0.627127051353455, 0.627230107784271, 0.627332806587219, 0.627435326576233, 0.627537488937378, 0.627639353275299, 0.627741038799286, 0.627842426300049, 0.627943515777588, 0.628044366836548, 0.628144919872284, 0.62824535369873, 0.628345370292664, 0.628445148468018, 0.628544688224792, 0.628643989562988, 0.62874299287796, 0.628841757774353, 0.628940105438232, 0.629038333892822, 0.629136323928833, 0.629233956336975, 0.629331350326538, 0.629428565502167, 0.629525363445282, 0.629621922969818, 0.629718363285065, 0.629814386367798, 0.629910230636597, 0.630005776882172, 0.630101025104523, 0.63019597530365, 0.630290687084198, 0.630385279655457, 0.630479395389557, 0.630573391914368, 0.63066703081131, 0.630760431289673, 0.630853652954102, 0.630946516990662, 0.631039142608643, 0.6311314702034, 0.631223499774933, 0.631315410137177, 0.631406903266907, 0.631498277187347, 0.631589233875275, 0.631680011749268, 0.631770491600037, 0.631860673427582, 0.631950676441193, 0.63204038143158, 0.632129848003387, 0.632219016551971, 0.632307887077332, 0.632396519184113, 0.63248485326767, 0.632572948932648, 0.632660746574402, 0.632748365402222, 0.632835626602173, 0.6329225897789, 0.633009433746338, 0.633095860481262, 0.633182168006897, 0.633268058300018, 0.63335382938385, 0.633439302444458, 0.633524477481842, 0.633609414100647, 0.633693933486938, 0.633778393268585, 0.633862495422363, 0.633946299552917, 0.634029865264893, 0.634113252162933, 0.634196221828461, 0.634279012680054, 0.634361565113068, 0.634443759918213, 0.634525835514069, 0.634607493877411, 0.634688913822174, 0.634770095348358, 0.634851038455963, 0.634931743144989, 0.635012090206146, 0.63509213924408, 0.635172009468079, 0.635251641273499, 0.63533091545105, 0.635410010814667, 0.635488748550415, 0.635567307472229, 0.635645627975464, 0.63572359085083, 0.635801255702972, 0.635878801345825, 0.635955929756165, 0.636032938957214, 0.636109590530396, 0.636185944080353, 0.636262118816376, 0.63633805513382, 0.63641357421875, 0.636488854885101, 0.636563956737518, 0.636638760566711, 0.636713266372681, 0.636787533760071, 0.636861562728882, 0.636935412883759, 0.637008845806122, 0.637081980705261, 0.637154877185822, 0.637227654457092, 0.637300074100494, 0.637372195720673, 0.637444019317627, 0.637515664100647, 0.637587070465088, 0.637657999992371, 0.637728869915009, 0.637799441814423, 0.637869715690613, 0.637939751148224, 0.638009488582611, 0.638078987598419, 0.638148248195648, 0.638217091560364, 0.63828581571579, 0.638354241847992, 0.638422429561615, 0.638490319252014, 0.638557910919189, 0.63862532377243, 0.638692378997803, 0.638759195804596, 0.638825833797455, 0.638892114162445, 0.638958036899567, 0.639023840427399, 0.639089345932007, 0.639154553413391, 0.639219522476196, 0.639284253120422, 0.639348685741425, 0.639412939548492, 0.639476776123047, 0.639540374279022, 0.639603734016418, 0.639666855335236, 0.639729738235474, 0.639792263507843, 0.639854669570923, 0.639916598796844, 0.639978408813477, 0.64003998041153, 0.640101134777069, 0.640162169933319, 0.6402228474617, 0.640283226966858, 0.640343427658081, 0.640403389930725, 0.6404629945755, 0.640522420406342, 0.640581488609314, 0.640640377998352, 0.640698969364166, 0.640757262706757, 0.640815377235413, 0.640873074531555, 0.640930652618408, 0.640987873077393, 0.641044855117798, 0.641101598739624, 0.641158103942871, 0.641214311122894, 0.641270220279694, 0.641325831413269, 0.64138126373291, 0.641436398029327, 0.641491234302521, 0.641545832157135, 0.641600072383881, 0.641654253005981, 0.641708016395569, 0.641761541366577, 0.641814827919006, 0.641867816448212, 0.641920506954193, 0.64197301864624, 0.642025291919708, 0.642077088356018, 0.642128825187683, 0.642180204391479, 0.642231404781342, 0.642282247543335, 0.642332851886749, 0.64238315820694, 0.642433226108551, 0.642483055591583, 0.642532646656036, 0.642581880092621, 0.642630934715271, 0.642679691314697, 0.6427281498909, 0.642776370048523, 0.642824292182922, 0.642871975898743, 0.642919421195984, 0.642966568470001, 0.643013477325439, 0.643060088157654, 0.643106400966644, 0.643152594566345, 0.643198370933533, 0.643243908882141, 0.64328920841217, 0.643334209918976, 0.643378973007202, 0.643423497676849, 0.643467664718628, 0.643511712551117, 0.643555343151093, 0.643598735332489, 0.643641889095306, 0.643684864044189, 0.643727540969849, 0.643769860267639, 0.643811881542206, 0.643853724002838, 0.643895328044891, 0.643936634063721, 0.643977642059326, 0.644018411636353, 0.6440589427948, 0.644099235534668, 0.644139170646667, 0.644178807735443, 0.644218325614929, 0.644257485866547, 0.644296407699585, 0.644334971904755, 0.644373416900635, 0.644411504268646, 0.644449353218079, 0.644486963748932, 0.644524276256561, 0.644561350345612, 0.644598126411438, 0.644634664058685, 0.644670903682709, 0.644706845283508, 0.644742608070374, 0.64477801322937, 0.644813239574432, 0.644848108291626, 0.64488273859024, 0.644917190074921, 0.644951283931732, 0.644985139369965, 0.645018815994263, 0.645052015781403, 0.645085096359253, 0.645117938518524, 0.645150423049927, 0.645182728767395, 0.645214796066284, 0.645246505737305, 0.645277857780457, 0.645309150218964, 0.645340025424957, 0.645370662212372, 0.645401120185852, 0.645431280136108, 0.645461142063141, 0.645490765571594, 0.645520091056824, 0.645549118518829, 0.645577907562256, 0.645606458187103, 0.645634770393372, 0.645662784576416, 0.645690500736237, 0.645717978477478, 0.645745277404785, 0.645772159099579, 0.645798861980438, 0.645825266838074, 0.645851373672485, 0.645877242088318, 0.645902872085571, 0.645928263664246, 0.645953238010406, 0.645978152751923, 0.64600270986557, 0.646026968955994, 0.646051049232483, 0.646074712276459, 0.646098256111145, 0.646121501922607, 0.646144390106201, 0.646167039871216, 0.646189451217651, 0.646211683750153, 0.64623361825943, 0.646255254745483, 0.646276593208313, 0.646297633647919, 0.64631849527359, 0.646339058876038, 0.646359384059906, 0.646379411220551, 0.646399140357971, 0.646418631076813, 0.646437883377075, 0.646456837654114, 0.646475553512573, 0.646494030952454, 0.64651221036911, 0.646530091762543, 0.646547734737396, 0.646565139293671, 0.646582245826721, 0.646599054336548, 0.646615564823151, 0.646631956100464, 0.646647930145264, 0.646663725376129, 0.646679222583771, 0.646694481372833, 0.646709501743317, 0.646724164485931, 0.646738648414612, 0.646752893924713, 0.646766722202301, 0.646780371665955, 0.646793782711029, 0.64680689573288, 0.646819770336151, 0.646832346916199, 0.646844685077667, 0.646856665611267, 0.646868526935577, 0.646880090236664, 0.646891295909882, 0.64690226316452, 0.646913051605225, 0.646923422813416, 0.646933674812317, 0.646943688392639, 0.646953225135803, 0.646962702274323, 0.646971821784973, 0.6469806432724, 0.646989226341248, 0.646997630596161, 0.647005617618561, 0.647013425827026, 0.647020936012268, 0.647028267383575, 0.647035300731659, 0.647041976451874, 0.64704841375351, 0.647054731845856, 0.647060573101044, 0.647066295146942, 0.647071659564972, 0.647076904773712, 0.647081792354584, 0.647086322307587, 0.647090673446655, 0.647094786167145, 0.64709860086441, 0.647102177143097, 0.64710545539856, 0.647108376026154, 0.647111177444458, 0.647113680839539, 0.64711582660675, 0.647117853164673, 0.647119522094727, 0.647120893001556, 0.647122144699097, 0.647122979164124, 0.647123634815216, 0.647123992443085, 0.647124052047729, 0.64712393283844, 0.647123456001282, 0.647122740745544, 0.647121727466583, 0.647120475769043, 0.647118985652924, 0.64711731672287, 0.647115230560303, 0.647112905979156, 0.647110402584076, 0.647107481956482, 0.647104382514954, 0.647101104259491, 0.647097408771515, 0.647093534469604, 0.64708936214447, 0.647084951400757, 0.64708024263382, 0.647075295448303, 0.647070050239563, 0.647064566612244, 0.647058844566345, 0.647052824497223, 0.647046506404877, 0.647039949893951, 0.647033095359802, 0.647026002407074, 0.647018671035767, 0.64701110124588, 0.647003173828125, 0.646995067596436, 0.646986603736877, 0.646977961063385, 0.646968960762024, 0.646959841251373, 0.646950244903564, 0.646940529346466, 0.646930515766144, 0.646920204162598, 0.646909773349762, 0.646898865699768, 0.646887898445129, 0.646876454353333, 0.646864891052246, 0.646853029727936, 0.646840810775757, 0.646828413009644, 0.646815776824951, 0.64680278301239, 0.64678966999054, 0.646776139736176, 0.646762490272522, 0.646748423576355, 0.646734178066254, 0.646719634532928, 0.646704912185669, 0.646689772605896, 0.646674454212189, 0.646658897399902, 0.646642982959747, 0.646626889705658, 0.6466104388237, 0.646593868732452, 0.646576881408691, 0.646559715270996, 0.646542310714722, 0.646524488925934, 0.646506547927856, 0.64648824930191, 0.646469831466675, 0.646450936794281, 0.646431922912598, 0.64641261100769, 0.646393060684204, 0.646373212337494, 0.646353006362915, 0.646332681179047, 0.646312057971954, 0.646291136741638, 0.646269917488098, 0.646248519420624, 0.646226763725281, 0.646204829216003, 0.646183013916016, 0.646161198616028, 0.646139204502106, 0.646116852760315, 0.646094262599945, 0.646071434020996, 0.646048307418823, 0.646024763584137, 0.646001160144806, 0.645977199077606, 0.645952880382538, 0.645928382873535, 0.645903468132019, 0.645878374576569, 0.645853042602539, 0.645827353000641, 0.645801484584808, 0.645775198936462, 0.645748734474182, 0.645721912384033, 0.64569491147995, 0.645667552947998, 0.645639955997467, 0.645612061023712, 0.645583868026733, 0.645555436611176, 0.645526766777039, 0.645497739315033, 0.645468473434448, 0.64543890953064, 0.645409047603607, 0.645378947257996, 0.64534854888916, 0.645317912101746, 0.645286917686462, 0.6452556848526, 0.645224213600159, 0.645192325115204, 0.645160317420959, 0.645127952098846, 0.645095407962799, 0.645062446594238, 0.645029306411743, 0.644995808601379, 0.644962012767792, 0.64492803812027, 0.644893825054169, 0.644859194755554, 0.644824326038361, 0.644789159297943, 0.644753754138947, 0.644718050956726, 0.644682109355927, 0.644645869731903, 0.644609332084656, 0.644572556018829, 0.644535481929779, 0.64449816942215, 0.644460499286652, 0.64442253112793, 0.644384384155273, 0.644345879554749, 0.644307076931, 0.644268095493317, 0.64422881603241, 0.644189238548279, 0.644149303436279, 0.644109129905701, 0.644068717956543, 0.644028067588806, 0.643987059593201, 0.643945813179016, 0.643904209136963, 0.643862366676331, 0.643820285797119, 0.643777966499329, 0.643735289573669, 0.643692374229431, 0.643649160861969, 0.643605649471283, 0.643561899662018, 0.643517851829529, 0.643473565578461, 0.643428862094879, 0.643383979797363, 0.643338859081268, 0.643293440341949, 0.643247604370117, 0.64320170879364, 0.64315539598465, 0.64310884475708, 0.643061995506287, 0.643014848232269, 0.642967522144318, 0.642919838428497, 0.642871797084808, 0.642823696136475, 0.642775118350983, 0.642726302146912, 0.642677366733551, 0.642627954483032, 0.642578303813934, 0.642528414726257, 0.642478227615356, 0.642427742481232, 0.642377018928528, 0.6423259973526, 0.642274737358093, 0.642223179340363, 0.642171323299408, 0.642119228839874, 0.642066776752472, 0.64201408624649, 0.64196115732193, 0.641907811164856, 0.641854345798492, 0.641800582408905, 0.641746401786804, 0.641692161560059, 0.641637444496155, 0.641582608222961, 0.641527354717255, 0.641471862792969, 0.641416132450104, 0.641360104084015, 0.641303718090057, 0.64124721288681, 0.641190350055695, 0.641133189201355, 0.641075789928436, 0.641018033027649, 0.640960037708282, 0.640901803970337, 0.640843272209167, 0.640784442424774, 0.640725374221802, 0.640665948390961, 0.640606343746185, 0.640546381473541, 0.640486180782318, 0.640425682067871, 0.6403648853302, 0.640303909778595, 0.640242516994476, 0.640180945396423, 0.640119016170502, 0.640056908130646, 0.639994382858276, 0.639931797981262, 0.63986873626709, 0.639805436134338, 0.639741957187653, 0.639678061008453, 0.639613926410675, 0.639549553394318, 0.639484822750092, 0.639419913291931, 0.639354705810547, 0.639289200305939, 0.639223337173462, 0.639157354831696, 0.639091074466705, 0.639024376869202, 0.638957500457764, 0.638890385627747, 0.638822853565216, 0.638755083084106, 0.638687133789062, 0.63861882686615, 0.638550221920013, 0.638481378555298, 0.638412237167358, 0.638342916965485, 0.638273179531097, 0.638203144073486, 0.638132989406586, 0.638062417507172, 0.637991666793823, 0.637920618057251, 0.63784921169281, 0.63777756690979, 0.637705624103546, 0.637633502483368, 0.637560904026031, 0.63748824596405, 0.637415289878845, 0.637341916561127, 0.637268304824829, 0.637194395065308, 0.637120306491852, 0.637045919895172, 0.636971175670624, 0.636896133422852, 0.636820912361145, 0.636745452880859, 0.636669516563416, 0.636593520641327, 0.636517107486725, 0.636440455913544, 0.636363506317139, 0.636286318302155, 0.636208772659302, 0.636131107807159, 0.636053025722504, 0.635974645614624, 0.63589608669281, 0.635817229747772, 0.63573807477951, 0.635658621788025, 0.635578870773315, 0.635498881340027, 0.635418593883514, 0.635338068008423, 0.635257244110107, 0.635176122188568, 0.63509476184845, 0.635013103485107, 0.634931147098541, 0.634848833084106, 0.634766399860382, 0.634683609008789, 0.634600520133972, 0.634517192840576, 0.634433507919312, 0.634349703788757, 0.634265542030334, 0.634181082248688, 0.634096264839172, 0.634011268615723, 0.633926033973694, 0.633840382099152, 0.63375461101532, 0.633668482303619, 0.633582055568695, 0.633495330810547, 0.63340836763382, 0.633321225643158, 0.633233606815338, 0.633145809173584, 0.633057713508606, 0.632969379425049, 0.632880747318268, 0.632791876792908, 0.632702708244324, 0.632613182067871, 0.632523417472839, 0.632433414459229, 0.632343173027039, 0.632252514362335, 0.632161676883698, 0.632070481777191, 0.63197910785675, 0.631887435913086, 0.631795465946198, 0.63170313835144, 0.631610631942749, 0.631517827510834, 0.63142466545105, 0.631331384181976, 0.631237685680389, 0.631143808364868, 0.631049573421478, 0.630955040454865, 0.630860269069672, 0.6307652592659, 0.630669951438904, 0.630574345588684, 0.63047844171524, 0.630382299423218, 0.630285918712616, 0.630189120769501, 0.630092144012451, 0.629994869232178, 0.629897356033325, 0.629799425601959, 0.629701375961304, 0.629603028297424, 0.629504323005676, 0.629405319690704, 0.629306137561798, 0.629206657409668, 0.629106879234314, 0.629006803035736, 0.628906428813934, 0.628805875778198, 0.628704965114594, 0.628603756427765, 0.628502368927002, 0.628400564193726, 0.628298580646515, 0.62819629907608, 0.628093659877777, 0.627990901470184, 0.627887785434723, 0.627784371376038, 0.627680659294128, 0.62757670879364, 0.627472519874573, 0.627368032932281, 0.627263128757477, 0.627158105373383, 0.627052783966064, 0.626947104930878, 0.626841247081757, 0.626734972000122, 0.626628577709198, 0.62652176618576, 0.626414716243744, 0.626307427883148, 0.626199841499329, 0.626092076301575, 0.625983893871307, 0.625875413417816, 0.625766694545746, 0.625657737255096, 0.625548481941223, 0.625438988208771, 0.62532913684845, 0.62521904706955, 0.62510871887207, 0.624997973442078, 0.624887049198151, 0.624775886535645, 0.624664425849915, 0.624552607536316, 0.624440610408783, 0.624328255653381, 0.624215722084045, 0.624102771282196, 0.623989641666412, 0.623876214027405, 0.623762488365173, 0.623648524284363, 0.623534262180328, 0.623419642448425, 0.623304903507233, 0.623189747333527, 0.623074352741241, 0.622958660125732, 0.622842788696289, 0.622726559638977, 0.622610032558441, 0.622493267059326, 0.622376203536987, 0.622258841991425, 0.622141242027283, 0.622023344039917, 0.621905207633972, 0.621786773204803, 0.621668040752411, 0.621549069881439, 0.621429681777954, 0.621310174465179, 0.621190309524536, 0.621070146560669, 0.620949804782867, 0.620829045772552, 0.620708167552948, 0.620586931705475, 0.620465397834778, 0.620343565940857, 0.620221555233002, 0.620099127292633, 0.61997652053833, 0.619853615760803, 0.619730472564697, 0.619606971740723, 0.619483172893524, 0.619359135627747, 0.619234919548035, 0.619110226631165, 0.618985414505005, 0.618860304355621, 0.618734836578369, 0.618609189987183, 0.618483185768127, 0.618357002735138, 0.618230402469635, 0.618103563785553, 0.617976546287537, 0.617849111557007, 0.617721438407898, 0.617593586444855, 0.617465376853943, 0.617336869239807, 0.617208123207092, 0.617079079151154, 0.616949737071991, 0.616820156574249, 0.616690278053284, 0.616560101509094, 0.616429626941681, 0.616298973560333, 0.616168022155762, 0.616036713123322, 0.615905165672302, 0.615773320198059, 0.615641236305237, 0.615508854389191, 0.615376174449921, 0.615243256092072, 0.615110039710999, 0.614976584911346, 0.614842772483826, 0.614708662033081, 0.614574372768402, 0.614439725875854, 0.614304840564728, 0.614169716835022, 0.614034235477448, 0.613898515701294, 0.613762497901917, 0.61362624168396, 0.61348968744278, 0.613352835178375, 0.613215684890747, 0.613078236579895, 0.612940669059753, 0.612802684307098, 0.612664401531219, 0.612525880336761, 0.612387120723724, 0.612248063087463, 0.612108647823334, 0.61196905374527, 0.611829161643982, 0.61168897151947, 0.61154842376709, 0.611407697200775, 0.611266732215881, 0.611125469207764, 0.610983908176422, 0.610841929912567, 0.610699832439423, 0.610557436943054, 0.610414743423462, 0.610271811485291, 0.610128462314606, 0.609984934329987, 0.609841167926788, 0.609697043895721, 0.60955274105072, 0.609408020973206, 0.609263122081757, 0.609117984771729, 0.608972430229187, 0.608826696872711, 0.608680665493011, 0.608534276485443, 0.608387768268585, 0.608240842819214, 0.608093619346619, 0.607946217060089, 0.60779857635498, 0.607650518417358, 0.607502281665802, 0.607353806495667, 0.607204914093018, 0.60705578327179, 0.606906414031982, 0.606756806373596, 0.606606781482697, 0.606456637382507, 0.606306135654449, 0.606155335903168, 0.606004238128662, 0.605852961540222, 0.605701327323914, 0.605549454689026, 0.605397284030914, 0.605244815349579, 0.60509204864502, 0.604939162731171, 0.604785859584808, 0.604632258415222, 0.604478418827057, 0.604324281215668, 0.604169905185699, 0.604015231132507, 0.603860259056091, 0.603705048561096, 0.603549540042877, 0.603393733501434, 0.603237628936768, 0.603081285953522, 0.602924704551697, 0.602767765522003, 0.60261058807373, 0.602453172206879, 0.602295339107513, 0.602137386798859, 0.60197901725769, 0.601820528507233, 0.601661622524261, 0.601502478122711, 0.601343095302582, 0.601183354854584, 0.601023375988007, 0.600863218307495, 0.60070264339447, 0.600535273551941, 0.600361287593842, 0.600187063217163, 0.600012719631195, 0.599837899208069, 0.599663019180298, 0.599487841129303, 0.599312365055084, 0.599136769771576, 0.598960757255554, 0.598784625530243, 0.598608255386353, 0.598431646823883, 0.59825474023819, 0.598077535629272, 0.597900211811066, 0.59772253036499, 0.597544729709625, 0.597366690635681, 0.597188353538513, 0.597009778022766, 0.59683084487915, 0.59665185213089, 0.596472561359406, 0.596292972564697, 0.59611314535141, 0.595933079719543, 0.595752894878387, 0.595572292804718, 0.595391511917114, 0.595210552215576, 0.595029294490814, 0.594847738742828, 0.594666004180908, 0.594484031200409, 0.594301819801331, 0.594119369983673, 0.593936622142792, 0.593753635883331, 0.593570530414581, 0.593387007713318, 0.593203365802765, 0.593019425868988, 0.592835307121277, 0.592650830745697, 0.592466235160828, 0.592281341552734, 0.592096149921417, 0.591910839080811, 0.591725170612335, 0.591539263725281, 0.591353118419647, 0.591166794300079, 0.590980172157288, 0.590793371200562, 0.590606272220612, 0.590418934822083, 0.590231418609619, 0.590043604373932, 0.589855551719666, 0.589667320251465, 0.589478731155396, 0.589289844036102, 0.58910083770752, 0.588911592960358, 0.588722169399261, 0.588532328605652, 0.588342368602753, 0.58815211057663, 0.587961673736572, 0.587770879268646, 0.587579965591431, 0.587388753890991, 0.587197303771973, 0.58700555562973, 0.586813688278198, 0.586621403694153, 0.586428999900818, 0.586236298084259, 0.586043477058411, 0.585850358009338, 0.585656940937042, 0.585463225841522, 0.585269391536713, 0.585075318813324, 0.584880888462067, 0.584686279296875, 0.584491372108459, 0.58429628610611, 0.584101021289825, 0.583905398845673, 0.583709537982941, 0.583513557910919, 0.583317160606384, 0.58312064409256, 0.582923889160156, 0.582726776599884, 0.582529604434967, 0.582331955432892, 0.582134246826172, 0.581936240196228, 0.58173805475235, 0.581539452075958, 0.581340730190277, 0.581141769886017, 0.580942511558533, 0.580743134021759, 0.580543279647827, 0.58034336566925, 0.580143213272095, 0.57994282245636, 0.579742133617401, 0.579541206359863, 0.579340040683746, 0.579138576984406, 0.57893693447113, 0.578735113143921, 0.578532934188843, 0.57833057641983, 0.578127861022949, 0.577925086021423, 0.577721953392029, 0.5775186419487, 0.577314972877502, 0.577111124992371, 0.576907098293304, 0.57670271396637, 0.576498210430145, 0.576293408870697, 0.576088309288025, 0.575883030891418, 0.575677514076233, 0.575471758842468, 0.57526570558548, 0.575059413909912, 0.574852883815765, 0.57464611530304, 0.574439167976379, 0.574231863021851, 0.574024438858032, 0.573816776275635, 0.573608756065369, 0.573400557041168, 0.573192119598389, 0.57298344373703, 0.572774469852448, 0.572565257549286, 0.572355926036835, 0.57214617729187, 0.571936309337616, 0.571726143360138, 0.571515798568726, 0.571305096149445, 0.571094214916229, 0.570883095264435, 0.570671737194061, 0.570460140705109, 0.570248305797577, 0.570036172866821, 0.569823861122131, 0.569611310958862, 0.569398462772369, 0.569185376167297, 0.568972051143646, 0.568758547306061, 0.568544745445251, 0.568330705165863, 0.568116426467896, 0.567901909351349, 0.567687153816223, 0.567472100257874, 0.56725686788559, 0.567041397094727, 0.56682562828064, 0.566609680652618, 0.566393435001373, 0.566177010536194, 0.565960288047791, 0.565743327140808, 0.565526187419891, 0.565308749675751, 0.565091013908386, 0.564873099327087, 0.564654946327209, 0.564436554908752, 0.564217865467072, 0.563998997211456, 0.563779830932617, 0.563560485839844, 0.563340842723846, 0.56312096118927, 0.562900900840759, 0.562680542469025, 0.562459945678711, 0.562239110469818, 0.562018036842346, 0.56179666519165, 0.56157511472702, 0.561353325843811, 0.561131298542023, 0.56090897321701, 0.560686469078064, 0.560463726520538, 0.560240626335144, 0.56001740694046, 0.559793949127197, 0.559570133686066, 0.559346199035645, 0.559121906757355, 0.558897435665131, 0.558672726154327, 0.5584477186203, 0.558222591876984, 0.557997107505798, 0.557771384716034, 0.557545483112335, 0.557319283485413, 0.557092845439911, 0.556866228580475, 0.556639313697815, 0.556412160396576, 0.556184768676758, 0.555957138538361, 0.555729269981384, 0.555501103401184, 0.555272817611694, 0.555044174194336, 0.554815292358398, 0.554586231708527, 0.554356873035431, 0.554127335548401, 0.553897500038147, 0.553667426109314, 0.553437113761902, 0.553206562995911, 0.552975833415985, 0.552744746208191, 0.552513480186462, 0.552281975746155, 0.552050232887268, 0.551818192005157, 0.551585972309113, 0.551353454589844, 0.551120758056641, 0.550887763500214, 0.550654530525208, 0.550421059131622, 0.550187349319458, 0.549953401088715, 0.549719214439392, 0.54948478937149, 0.54925012588501, 0.54901522397995, 0.548780024051666, 0.548544645309448, 0.548308968544006, 0.548073053359985, 0.54783695936203, 0.547600567340851, 0.547363996505737, 0.5471271276474, 0.546890020370483, 0.546652615070343, 0.546415030956268, 0.546177268028259, 0.545939147472382, 0.54570084810257, 0.545462310314178, 0.545223414897919, 0.544984459877014, 0.544745147228241, 0.544505596160889, 0.544265866279602, 0.544025778770447, 0.543785572052002, 0.543545067310333, 0.543304324150085, 0.543063342571259, 0.542822062969208, 0.542580664157867, 0.542338907718658, 0.542096972465515, 0.541854739189148, 0.541612267494202, 0.541369616985321, 0.541126668453217, 0.540883481502533, 0.54064005613327, 0.540396392345428, 0.540152490139008, 0.539908349514008, 0.539663970470428, 0.539419293403625, 0.539174437522888, 0.538929343223572, 0.538683950901031, 0.538438379764557, 0.538192510604858, 0.537946403026581, 0.537700116634369, 0.537453532218933, 0.537206709384918, 0.536959648132324, 0.536712288856506, 0.536464810371399, 0.536217033863068, 0.535969018936157, 0.535720705986023, 0.535472214221954, 0.535223424434662, 0.534974455833435, 0.534725189208984, 0.534475684165955, 0.53422600030899, 0.533975958824158, 0.533725798130035, 0.533475279808044, 0.533224582672119, 0.532973647117615, 0.532722532749176, 0.532471060752869, 0.532219409942627, 0.531967461109161, 0.531715333461761, 0.531462907791138, 0.531210243701935, 0.530957341194153, 0.530704200267792, 0.530450880527496, 0.530197262763977, 0.529943406581879, 0.529689252376556, 0.5294349193573, 0.529180347919464, 0.528925538063049, 0.528670430183411, 0.528415143489838, 0.528159618377686, 0.52790379524231, 0.527647733688354, 0.52739143371582, 0.527134954929352, 0.526878118515015, 0.526621103286743, 0.526363849639893, 0.526106357574463, 0.525848627090454, 0.525590598583221, 0.525332391262054, 0.525073945522308, 0.524815201759338, 0.524556279182434, 0.524297058582306, 0.524037659168243, 0.523777961730957, 0.523518025875092, 0.523257851600647, 0.522997379302979, 0.522736787796021, 0.522475838661194, 0.522214710712433, 0.521953284740448, 0.521691679954529, 0.521429777145386, 0.521167695522308, 0.520905315876007, 0.520642757415771, 0.520379900932312, 0.520116806030273, 0.519853472709656, 0.519589900970459, 0.519326090812683, 0.519062042236328, 0.518797755241394, 0.518533170223236, 0.518268406391144, 0.518003344535828, 0.517738103866577, 0.517472624778748, 0.517206847667694, 0.516940832138062, 0.51667457818985, 0.516408145427704, 0.516141414642334, 0.515874445438385, 0.515607237815857, 0.515339732170105, 0.515072047710419, 0.514804124832153, 0.514535903930664, 0.514267444610596, 0.513998806476593, 0.513729870319366, 0.513460695743561, 0.513191282749176, 0.512921690940857, 0.512651801109314, 0.512381672859192, 0.512111306190491, 0.51184070110321, 0.511569857597351, 0.511298775672913, 0.51102739572525, 0.510755777359009, 0.510483980178833, 0.510211884975433, 0.509939610958099, 0.509667038917542, 0.509394288063049, 0.509121239185333, 0.508847892284393, 0.508574426174164, 0.508300602436066, 0.508026599884033, 0.507752358913422, 0.507477879524231, 0.507203102111816, 0.506928145885468, 0.50665295124054, 0.506377398967743, 0.506101667881012, 0.505825757980347, 0.505549550056458, 0.505273103713989, 0.504996418952942, 0.504719495773315, 0.504442393779755, 0.504164934158325, 0.503887236118317, 0.503609359264374, 0.503331243991852, 0.503052890300751, 0.502774178981781, 0.502495348453522, 0.502216219902039, 0.501936852931976, 0.501657247543335, 0.501377463340759, 0.501097321510315, 0.500817000865936, 0.500536441802979, 0.500255644321442, 0.499974608421326, 0.499693274497986, 0.499411761760712, 0.499130010604858, 0.498847961425781, 0.498565703630447, 0.49828314781189, 0.498000413179398, 0.497717380523682, 0.497434169054031, 0.49715068936348, 0.496866941452026, 0.496583044528961, 0.496298789978027, 0.496014326810837, 0.495729625225067, 0.495444744825363, 0.495159536600113, 0.494874119758606, 0.494588404893875, 0.49430251121521, 0.494016349315643, 0.49372997879982, 0.493443340063095, 0.493156403303146, 0.492869287729263, 0.492581963539124, 0.492294311523438, 0.492006450891495, 0.491718351840973, 0.491430044174194, 0.49114140868187, 0.490852653980255, 0.490563601255417, 0.490274220705032, 0.489984720945358, 0.48969492316246, 0.489404857158661, 0.489114612340927, 0.488824069499969, 0.488533318042755, 0.488242268562317, 0.487951010465622, 0.48765954375267, 0.48736783862114, 0.48707577586174, 0.486783564090729, 0.486491113901138, 0.486198395490646, 0.485905438661575, 0.485612213611603, 0.485318839550018, 0.485025137662888, 0.484731256961823, 0.484437048435211, 0.484142631292343, 0.483848005533218, 0.48355308175087, 0.48324778676033, 0.4829321205616, 0.48261633515358, 0.482300490140915, 0.481984585523605, 0.481668561697006, 0.481352478265762, 0.481036454439163, 0.480720192193985, 0.480403870344162, 0.480087548494339, 0.479771107435226, 0.479454576969147, 0.479138016700745, 0.478821367025375, 0.478504687547684, 0.478187888860703, 0.477870941162109, 0.477554023265839, 0.477237015962601, 0.476919919252396, 0.476602733135223, 0.476285517215729, 0.475968241691589, 0.475650817155838, 0.475333333015442, 0.475015848875046, 0.474698215723038, 0.474380522966385, 0.474062770605087, 0.47374501824379, 0.473427057266235, 0.473109126091003, 0.47279104590416, 0.472472906112671, 0.472154706716537, 0.471836477518082, 0.471518099308014, 0.471199661493301, 0.470881223678589, 0.470562666654587, 0.47024405002594, 0.469925343990326, 0.469606548547745, 0.469287693500519, 0.468968778848648, 0.46864977478981, 0.46833074092865, 0.468011528253555, 0.467692345380783, 0.467373073101044, 0.467053592205048, 0.466734200716019, 0.4664146900177, 0.466095119714737, 0.465775460004807, 0.465455740690231, 0.465135902166367, 0.464816033840179, 0.464496105909348, 0.464176058769226, 0.463855981826782, 0.463535815477371, 0.463215559720993, 0.46289524435997, 0.462574869394302, 0.462254405021667, 0.461933821439743, 0.461613208055496, 0.461292505264282, 0.460971742868423, 0.460650891065598, 0.460330009460449, 0.460009008646011, 0.459687978029251, 0.459366858005524, 0.459045648574829, 0.45872437953949, 0.458403050899506, 0.458081632852554, 0.457760125398636, 0.457438558340073, 0.457116901874542, 0.456795215606689, 0.456473410129547, 0.456151604652405, 0.455829590559006, 0.455507606267929, 0.455185532569885, 0.454863369464874, 0.454541146755219, 0.454218864440918, 0.453896522521973, 0.453574001789093, 0.453251510858536, 0.452928930521011, 0.45260626077652, 0.452283531427383, 0.45196071267128, 0.451637804508209, 0.451314866542816, 0.450991839170456, 0.450668752193451, 0.450345516204834, 0.450022250413895, 0.449698954820633, 0.449375540018082, 0.449052035808563, 0.448728531599045, 0.448404908180237, 0.448081195354462, 0.447757452726364, 0.447433620691299, 0.447109669446945, 0.446785748004913, 0.446461617946625, 0.446137517690659, 0.445813328027725, 0.445489019155502, 0.445164680480957, 0.444840222597122, 0.444515734910965, 0.444191157817841, 0.443866491317749, 0.443541795015335, 0.443216979503632, 0.442892074584961, 0.44256716966629, 0.44224214553833, 0.441917061805725, 0.441591918468475, 0.441266715526581, 0.440941363573074, 0.440616011619568, 0.440290510654449, 0.439965009689331, 0.439639419317245, 0.43931370973587, 0.438987970352173, 0.438662141561508, 0.438336253166199, 0.438010275363922, 0.437684237957001, 0.437358111143112, 0.437031924724579, 0.436705678701401, 0.436379343271255, 0.436052918434143, 0.435726463794708, 0.435399889945984, 0.435073286294937, 0.434746593236923, 0.434419810771942, 0.434092998504639, 0.433765977621078, 0.433438986539841, 0.433111906051636, 0.432784795761108, 0.432457596063614, 0.432130306959152, 0.431802928447723, 0.43147549033165, 0.431147992610931, 0.430820375680923, 0.430492758750916, 0.43016505241394, 0.429837226867676, 0.429509371519089, 0.429181396961212, 0.428853392601013, 0.428525298833847, 0.428197085857391, 0.427868843078613, 0.427540570497513, 0.4272121489048, 0.426883637905121, 0.426555156707764, 0.426226526498795, 0.425897866487503, 0.425569087266922, 0.425240278244019, 0.424911379814148, 0.424582421779633, 0.424253344535828, 0.423924267292023, 0.423595011234283, 0.423265755176544, 0.42293643951416, 0.422607004642487, 0.422277480363846, 0.421947956085205, 0.42161825299263, 0.421288579702377, 0.420958817005157, 0.420628935098648, 0.420298993587494, 0.41996905207634, 0.419638931751251, 0.41930878162384, 0.418978571891785, 0.418648302555084, 0.418317884206772, 0.417987495660782, 0.417656987905502, 0.417326390743256, 0.416995644569397, 0.416664958000183, 0.41633415222168, 0.416003257036209, 0.415672302246094, 0.415341258049011, 0.415010184049606, 0.414678990840912, 0.41434770822525, 0.414016425609589, 0.41368505358696, 0.413353562355042, 0.413022011518478, 0.412690341472626, 0.412358701229095, 0.412026911973953, 0.411695063114166, 0.411363244056702, 0.411031186580658, 0.410699129104614, 0.410366982221603, 0.41003480553627, 0.40970253944397, 0.409370183944702, 0.409037709236145, 0.408705234527588, 0.408372670412064, 0.408040076494217, 0.407707333564758, 0.407374531030655, 0.407041698694229, 0.406708717346191, 0.406375706195831, 0.406042635440826, 0.405709475278854, 0.405376195907593, 0.405042916536331, 0.404709577560425, 0.404376089572906, 0.404042571783066, 0.403708964586258, 0.403375297784805, 0.403041571378708, 0.402707755565643, 0.402373880147934, 0.402039915323257, 0.401705861091614, 0.401371777057648, 0.40103754401207, 0.400703281164169, 0.400368988513947, 0.400034606456757, 0.399700045585632, 0.39936551451683, 0.399030894041061, 0.398696184158325, 0.398361444473267, 0.398026585578918, 0.397691667079926, 0.397356688976288, 0.397021621465683, 0.396686494350433, 0.396351277828217, 0.396016001701355, 0.395680636167526, 0.395345211029053, 0.395009696483612, 0.394674122333527, 0.394338458776474, 0.394002735614777, 0.393666923046112, 0.393331050872803, 0.392995089292526, 0.392659068107605, 0.392322987318039, 0.391986846923828, 0.391650587320328, 0.391314268112183, 0.390977889299393, 0.39064148068428, 0.390304893255234, 0.389968305826187, 0.389631628990173, 0.389294862747192, 0.388958036899567, 0.388621181249619, 0.388284146785736, 0.387947112321854, 0.387609958648682, 0.38727280497551, 0.386935502290726, 0.386598169803619, 0.386260807514191, 0.38592329621315, 0.385585784912109, 0.385248124599457, 0.384910374879837, 0.384572595357895, 0.384234756231308, 0.383896857500076, 0.383558869361877, 0.383220762014389, 0.382882624864578, 0.3825443983078, 0.382206082344055, 0.381867706775665, 0.381529301404953, 0.381190747022629, 0.380852192640305, 0.380513519048691, 0.380174785852432, 0.379835993051529, 0.379497140645981, 0.379158169031143, 0.378819137811661, 0.378480046987534, 0.378140896558762, 0.377801597118378, 0.377462327480316, 0.377122938632965, 0.376783400774002, 0.376443862915039, 0.376104235649109, 0.375764578580856, 0.375424832105637, 0.375085026025772, 0.374745100736618, 0.374405115842819, 0.374065071344376, 0.373724967241287, 0.373384684324265, 0.373044461011887, 0.372704118490219, 0.372363716363907, 0.372023224830627, 0.371682673692703, 0.37134200334549, 0.371001243591309, 0.370660454034805, 0.370319604873657, 0.36997863650322, 0.369637668132782, 0.369296580553055, 0.368955433368683, 0.368614196777344, 0.368272930383682, 0.367931514978409, 0.367590099573135, 0.367248594760895, 0.366906970739365, 0.36656528711319, 0.366223603487015, 0.365881770849228, 0.365539878606796, 0.36519792675972, 0.364855885505676, 0.364513754844666, 0.364171594381332, 0.363829284906387, 0.363486975431442, 0.363144606351852, 0.362802177667618, 0.362459570169449, 0.362116932868958, 0.361774295568466, 0.361431509256363, 0.361088633537292, 0.3607457280159, 0.36040273308754, 0.360059678554535, 0.359716534614563, 0.359373390674591, 0.35903000831604, 0.358686685562134, 0.35834327340126, 0.357999742031097, 0.357656180858612, 0.357312560081482, 0.356968820095062, 0.356625020503998, 0.356281161308289, 0.355937212705612, 0.355593204498291, 0.355249106884003, 0.35490494966507, 0.354560732841492, 0.354216456413269, 0.353872060775757, 0.353527635335922, 0.353183031082153, 0.352838456630707, 0.352493762969971, 0.35214900970459, 0.351804196834564, 0.351459324359894, 0.351114273071289, 0.350769311189651, 0.350424200296402, 0.350078999996185, 0.349733740091324, 0.349388390779495, 0.349043011665344, 0.348697513341904, 0.348351955413818, 0.348006337881088, 0.347660630941391, 0.347314834594727, 0.346968978643417, 0.346623063087463, 0.34627702832222, 0.345930993556976, 0.345584839582443, 0.345238655805588, 0.344892382621765, 0.344545990228653, 0.344199538230896, 0.343853056430817, 0.343506455421448, 0.343159794807434, 0.342813074588776, 0.34246626496315, 0.342119455337524, 0.341772466897964, 0.341425389051437, 0.341078281402588, 0.340731143951416, 0.340383917093277, 0.340036571025848, 0.339689165353775, 0.339341729879379, 0.338994204998016, 0.338646590709686, 0.338298946619034, 0.337951183319092, 0.337603330612183, 0.337255448102951, 0.33690744638443, 0.336559414863586, 0.336211293935776, 0.33586311340332, 0.335514783859253, 0.335166424512863, 0.334818035364151, 0.334469527006149, 0.334120959043503, 0.333772361278534, 0.333423644304276, 0.33307483792305, 0.332726001739502, 0.332377105951309, 0.332028090953827, 0.331678986549377, 0.331329852342606, 0.330980658531189, 0.330631285905838, 0.330281943082809, 0.329932540655136, 0.329582959413528, 0.329233348369598, 0.328883737325668, 0.328533977270126, 0.328184127807617, 0.32783430814743, 0.327484339475632, 0.327134311199188, 0.326784193515778, 0.326434046030045, 0.326083779335022, 0.325733482837677, 0.325383067131042, 0.325032562017441, 0.324682086706161, 0.324331432580948, 0.323980778455734, 0.323629915714264, 0.323279112577438, 0.322928220033646, 0.322577238082886, 0.322226166725159, 0.321875035762787, 0.32152384519577, 0.321172535419464, 0.320821225643158, 0.32046976685524, 0.320118308067322, 0.319766700267792, 0.319415062665939, 0.319063395261765, 0.318711578845978, 0.318359732627869, 0.31800776720047, 0.317655771970749, 0.317303597927094, 0.31695145368576, 0.316599249839783, 0.316251814365387, 0.315909683704376, 0.315567642450333, 0.315225750207901, 0.314884006977081, 0.314542442560196, 0.314200967550278, 0.313859611749649, 0.313518434762955, 0.31317737698555, 0.312836438417435, 0.312495708465576, 0.312155038118362, 0.311814576387405, 0.311474144458771, 0.311133950948715, 0.310793846845627, 0.31045389175415, 0.310114115476608, 0.309774428606033, 0.309434920549393, 0.309095501899719, 0.308756291866302, 0.308417141437531, 0.30807814002037, 0.307739317417145, 0.307400614023209, 0.30706200003624, 0.30672362446785, 0.306385338306427, 0.306047171354294, 0.305709064006805, 0.305371254682541, 0.305033475160599, 0.304695874452591, 0.30435848236084, 0.304021120071411, 0.303683936595917, 0.303346902132034, 0.303009927272797, 0.302673161029816, 0.302336513996124, 0.302000015974045, 0.301663666963577, 0.301327437162399, 0.300991386175156, 0.300655484199524, 0.300319641828537, 0.29998391866684, 0.299648433923721, 0.299312978982925, 0.298977792263031, 0.298642665147781, 0.298307657241821, 0.297972738742828, 0.297638088464737, 0.297303527593613, 0.2969691157341, 0.296634823083878, 0.296300739049911, 0.295966625213623, 0.295632839202881, 0.295299082994461, 0.294965475797653, 0.294632017612457, 0.294298648834229, 0.293965429067612, 0.293632447719574, 0.293299496173859, 0.292966693639755, 0.292634099721909, 0.292301625013351, 0.291969299316406, 0.291637063026428, 0.291305005550385, 0.290972977876663, 0.290641248226166, 0.290309548377991, 0.289977997541428, 0.289646595716476, 0.28931537270546, 0.28898423910141, 0.28865322470665, 0.288322359323502, 0.287991672754288, 0.287661164999008, 0.287330716848373, 0.287000447511673, 0.28667026758194, 0.286340296268463, 0.286010414361954, 0.285680651664734, 0.285351067781448, 0.285021543502808, 0.284692317247391, 0.284363061189651, 0.284034013748169, 0.283705115318298, 0.283376425504684, 0.283047765493393, 0.282719254493713, 0.282390892505646, 0.282062649726868, 0.281734555959702, 0.281406611204147, 0.281078815460205, 0.280751168727875, 0.280423611402512, 0.280096262693405, 0.279768973588943, 0.279441893100739, 0.279114902019501, 0.278788089752197, 0.278461366891861, 0.278134852647781, 0.277808398008347, 0.277482062578201, 0.277155935764313, 0.276829898357391, 0.276504069566727, 0.276178330183029, 0.275852739810944, 0.275527268648148, 0.275201976299286, 0.274876832962036, 0.274551749229431, 0.27422684431076, 0.273902058601379, 0.27357742190361, 0.273252934217453, 0.272928595542908, 0.27260434627533, 0.272280275821686, 0.271956324577332, 0.271632522344589, 0.271308839321136, 0.270985335111618, 0.270661950111389, 0.270338714122772, 0.270015627145767, 0.269692629575729, 0.269369810819626, 0.269047111272812, 0.268724530935287, 0.268402099609375, 0.268079847097397, 0.267757654190063, 0.267435669898987, 0.2671138048172, 0.266792088747025, 0.266470462083817, 0.266149044036865, 0.265827715396881, 0.265506505966187, 0.265185475349426, 0.264864563941956, 0.264543801546097, 0.264223158359528, 0.26390266418457, 0.263582319021225, 0.263262093067169, 0.262942016124725, 0.262622147798538, 0.262302279472351, 0.261982679367065, 0.261663198471069, 0.261343777179718, 0.261024504899979, 0.260705351829529, 0.260386407375336, 0.260067582130432, 0.259748876094818, 0.259430348873138, 0.259111881256104, 0.258793622255325, 0.258475482463837, 0.258157432079315, 0.257839649915695, 0.25752192735672, 0.257204294204712, 0.256886869668961, 0.256569504737854, 0.256252348423004, 0.255935281515121, 0.255618423223495, 0.255301624536514, 0.254985004663467, 0.25466850399971, 0.254352152347565, 0.254035949707031, 0.253719836473465, 0.253403931856155, 0.25308820605278, 0.252772480249405, 0.252456963062286, 0.25214159488678, 0.25182631611824, 0.251511245965958, 0.25119623541832, 0.250881433486938, 0.250566750764847, 0.250252187252045, 0.249937728047371, 0.249623447656631, 0.249309346079826, 0.248995378613472, 0.248681485652924, 0.248367711901665, 0.248054146766663, 0.247740730643272, 0.247427389025688, 0.247114196419716, 0.246801197528839, 0.24648828804493, 0.246175482869148, 0.245862886309624, 0.245550394058228, 0.245238080620766, 0.244925886392593, 0.244613766670227, 0.244301855564117, 0.243990048766136, 0.243678405880928, 0.243366867303848, 0.24305547773838, 0.242744192481041, 0.242433145642281, 0.242122158408165, 0.241811349987984, 0.24150063097477, 0.241190075874329, 0.2408796697855, 0.240569442510605, 0.240259289741516, 0.239949300885201, 0.239639446139336, 0.239329680800438, 0.239020064473152, 0.238710641860962, 0.2384013235569, 0.23809215426445, 0.237783044576645, 0.237474232912064, 0.237165436148643, 0.236856862902641, 0.236548349261284, 0.236240044236183, 0.235931843519211, 0.235623762011528, 0.235315844416618, 0.235008031129837, 0.234700351953506, 0.234392821788788, 0.234085440635681, 0.233778193593025, 0.233471110463142, 0.233164086937904, 0.232857301831245, 0.23255068063736, 0.232244119048119, 0.231937661767006, 0.231631398200989, 0.231325253844261, 0.231019258499146, 0.230713367462158, 0.230407670140266, 0.230102121829987, 0.229796633124352, 0.229491323232651, 0.229186177253723, 0.228881180286407, 0.228576242923737, 0.228271469473839, 0.227966845035553, 0.227662310004234, 0.227358058094978, 0.227053835988045, 0.226749777793884, 0.226445809006691, 0.226142019033432, 0.225838363170624, 0.225534826517105, 0.225231513381004, 0.224928259849548, 0.224625200033188, 0.224322184920311, 0.224019393324852, 0.223716735839844, 0.22341413795948, 0.223111659288406, 0.222809389233589, 0.222507297992706, 0.222205311059952, 0.221903428435326, 0.221601739525795, 0.221300154924393, 0.220998704433441, 0.220697477459908, 0.220396250486374, 0.220095202326775, 0.219794303178787, 0.219493567943573, 0.219192937016487, 0.218892484903336, 0.218592122197151, 0.218291878700256, 0.217991828918457, 0.217691898345947, 0.217392116785049, 0.217092424631119, 0.216792955994606, 0.216493591666222, 0.216194316744804, 0.215895220637321, 0.215596288442612, 0.215297505259514, 0.214998751878738, 0.21470020711422, 0.214401796460152, 0.214103534817696, 0.213805451989174, 0.213507473468781, 0.213209539651871, 0.212911814451218, 0.212614297866821, 0.21231684088707, 0.212019562721252, 0.211722388863564, 0.211425319314003, 0.211128428578377, 0.210831671953201, 0.210535064339638, 0.210238575935364, 0.209942266345024, 0.209646016359329, 0.20934996008873, 0.209054127335548, 0.208758383989334, 0.208462655544281, 0.208167135715485, 0.207871809601784, 0.207576543092728, 0.207281425595284, 0.206986427307129, 0.206691607832909, 0.2063969373703, 0.206102460622787, 0.205807998776436, 0.205513745546341, 0.205219611525536, 0.204925641417503, 0.204631820321083, 0.204338058829308, 0.204044476151466, 0.203751057386398, 0.203457713127136, 0.203164547681808, 0.20287150144577, 0.202578604221344, 0.202285900712013, 0.20199328660965, 0.201700761914253, 0.201408430933952, 0.201116293668747, 0.200824245810509, 0.200532302260399, 0.200240537524223, 0.199948891997337, 0.19965735077858, 0.199365988373756, 0.199074804782867, 0.198783665895462, 0.19849269092083, 0.198201864957809, 0.19791117310524, 0.197620645165443, 0.197330221533775, 0.19703996181488, 0.196749851107597, 0.196459889411926, 0.196170061826706, 0.195880323648453, 0.195590734481812, 0.195301294326782, 0.195011973381042, 0.194722831249237, 0.194433823227882, 0.194144919514656, 0.193856179714203, 0.193567559123039, 0.193279102444649, 0.192990735173225, 0.19270259141922, 0.192414477467537, 0.192126527428627, 0.191838786005974, 0.191551178693771, 0.191263720393181, 0.190976276993752, 0.190689086914062, 0.190401911735535, 0.190115004777908, 0.189828157424927, 0.189541548490524, 0.189254954457283, 0.188968598842621, 0.188682287931442, 0.188396155834198, 0.188110172748566, 0.187824279069901, 0.187538623809814, 0.187253087759018, 0.186967611312866, 0.186682388186455, 0.186397135257721, 0.18611216545105, 0.185827240347862, 0.185542479157448, 0.185257896780968, 0.1849734634161, 0.184689074754715, 0.184404924511909, 0.184120893478394, 0.183836966753006, 0.183553233742714, 0.183269515633583, 0.182985976338387, 0.18270269036293, 0.182419404387474, 0.182136386632919, 0.181853339076042, 0.181570529937744, 0.181287810206413, 0.181005299091339, 0.180722907185555, 0.180440708994865, 0.180158644914627, 0.179876580834389, 0.179594784975052, 0.179312974214554, 0.179031491279602, 0.178749978542328, 0.178468704223633, 0.178187534213066, 0.177906483411789, 0.177625685930252, 0.177344873547554, 0.177064284682274, 0.176783785223961, 0.176503509283066, 0.17622335255146, 0.175943300127983, 0.175663381814957, 0.175383552908897, 0.175103947520256, 0.174824416637421, 0.174545049667358, 0.174265787005424, 0.173986777663231, 0.173707783222198, 0.173428893089294, 0.173150286078453, 0.172871738672256, 0.172593384981155, 0.172315120697021, 0.172036990523338, 0.171759039163589, 0.171481147408485, 0.17120349407196, 0.170925870537758, 0.170648455619812, 0.170371159911156, 0.17009399831295, 0.169816955924034, 0.169540122151375, 0.16926346719265, 0.168986782431602, 0.168710276484489, 0.168434023857117, 0.168157771229744, 0.167881771922112, 0.16760578751564, 0.16733007133007, 0.167054399847984, 0.166778951883316, 0.16650353372097, 0.166228324174881, 0.165953189134598, 0.165678262710571, 0.165403544902802, 0.165128797292709, 0.164854303002357, 0.164579853415489, 0.164305612444878, 0.164031520485878, 0.163757488131523, 0.163483664393425, 0.163209944963455, 0.162936419248581, 0.162662923336029, 0.162401154637337, 0.162150576710701, 0.161900490522385, 0.161650434136391, 0.161400675773621, 0.16115115582943, 0.160901695489883, 0.160652622580528, 0.160403653979301, 0.160155087709427, 0.159906566143036, 0.15965823829174, 0.159410193562508, 0.159162402153015, 0.158914759755135, 0.158667385578156, 0.1584203094244, 0.158173382282257, 0.157926619052887, 0.157680109143257, 0.157433792948723, 0.157187759876251, 0.156941935420036, 0.156696319580078, 0.156450822949409, 0.156205594539642, 0.155960708856583, 0.155715897679329, 0.155471473932266, 0.155227154493332, 0.154983147978783, 0.154739230871201, 0.154495537281036, 0.154252097010612, 0.154008939862251, 0.153765887022018, 0.153522998094559, 0.153280481696129, 0.153038054704666, 0.152796000242233, 0.15255406498909, 0.152312383055687, 0.152070924639702, 0.151829689741135, 0.151588618755341, 0.151347860693932, 0.151107266545296, 0.150866836309433, 0.150626659393311, 0.150386720895767, 0.150146976113319, 0.149907499551773, 0.149668216705322, 0.149429097771645, 0.149190276861191, 0.148951664566994, 0.148713365197182, 0.148475155234337, 0.148237213492393, 0.147999495267868, 0.14776186645031, 0.147524490952492, 0.147287458181381, 0.147050514817238, 0.146813929080963, 0.146577507257462, 0.146341294050217, 0.146105229854584, 0.145869538187981, 0.145633921027184, 0.145398542284966, 0.14516344666481, 0.144928425550461, 0.144693791866302, 0.14445935189724, 0.144225120544434, 0.143991053104401, 0.143757283687592, 0.143523648381233, 0.14329032599926, 0.143057137727737, 0.142824292182922, 0.14259161055088, 0.142359167337418, 0.142126679420471, 0.141894698143005, 0.141662836074829, 0.141431167721748, 0.141199827194214, 0.14096862077713, 0.140737682580948, 0.140506833791733, 0.140276417136192, 0.140046060085297, 0.139816045761108, 0.139586120843887, 0.139356359839439, 0.139126896858215, 0.138897702097893, 0.138668730854988, 0.138439998030663, 0.138211399316788, 0.137983068823814, 0.13775497674942, 0.137527018785477, 0.137299373745918, 0.137071967124939, 0.13684469461441, 0.136617511510849, 0.136390820145607, 0.13616418838501, 0.135937824845314, 0.135711714625359, 0.135485857725143, 0.135260000824928, 0.135034546256065, 0.134809285402298, 0.13458426296711, 0.134359419345856, 0.134134843945503, 0.133910357952118, 0.133686155080795, 0.133462131023407, 0.133238419890404, 0.133014917373657, 0.132791563868523, 0.132568508386612, 0.132345587015152, 0.132122933864594, 0.131900563836098, 0.13167841732502, 0.131456300616264, 0.131234481930733, 0.131012931466103, 0.130791693925858, 0.130570560693741, 0.130349695682526, 0.130129009485245, 0.129908606410027, 0.129688337445259, 0.129468247294426, 0.129248529672623, 0.129028797149658, 0.128809496760368, 0.128590285778046, 0.128371298313141, 0.128152668476105, 0.127934128046036, 0.127715885639191, 0.127497851848602, 0.127280011773109, 0.127062395215034, 0.126844972372055, 0.126627802848816, 0.126410827040672, 0.126194089651108, 0.125977471470833, 0.125761106610298, 0.125545144081116, 0.125329211354256, 0.125113561749458, 0.12489815056324, 0.124683000147343, 0.124468050897121, 0.124253310263157, 0.124038711190224, 0.123824395239353, 0.123610310256481, 0.123396307229996, 0.123182587325573, 0.122969143092632, 0.122755914926529, 0.122542925179005, 0.122330069541931, 0.12211748957634, 0.121905192732811, 0.121692977845669, 0.121481083333492, 0.121269330382347, 0.121057882905006, 0.12084649503231, 0.120635472238064, 0.120424628257751, 0.120214067399502, 0.120003648102283, 0.119793444871902, 0.119583524763584, 0.11937391012907, 0.119164302945137, 0.118955060839653, 0.118745923042297, 0.118537046015263, 0.118328370153904, 0.118119947612286, 0.117911674082279, 0.117703758180141, 0.117495983839035, 0.117288403213024, 0.117081128060818, 0.11687395721674, 0.116667091846466, 0.116460412740707, 0.116253964602947, 0.116047710180283, 0.115841627120972, 0.115635775029659, 0.115430243313313, 0.115224845707417, 0.11501969397068, 0.114814795553684, 0.114610090851784, 0.114405609667301, 0.114201322197914, 0.113997302949429, 0.113793417811394, 0.113589949905872, 0.113386429846287, 0.11318327486515, 0.11298031359911, 0.11277762055397, 0.112575061619282, 0.112372778356075, 0.112170681357384, 0.111968815326691, 0.111767143011093, 0.111565731465816, 0.111364543437958, 0.111163586378098, 0.110962674021721, 0.110762134194374, 0.110561832785606, 0.110361702740192, 0.110161796212196, 0.109962128102779, 0.109762735664845, 0.10956346988678, 0.109364442527294, 0.109165593981743, 0.108967073261738, 0.108768723905087, 0.108570568263531, 0.108372636139393, 0.108174934983253, 0.107977449893951, 0.107780158519745, 0.10758314281702, 0.107386313378811, 0.107189670205116, 0.106993332505226, 0.106797136366367, 0.106601178646088, 0.10640549659729, 0.106209844350815, 0.10601457208395, 0.105819471180439, 0.105624608695507, 0.105429977178574, 0.105235576629639, 0.105041392147541, 0.104847297072411, 0.104653581976891, 0.104460053145885, 0.104266740381718, 0.104073613882065, 0.103880621492863, 0.103687912225723, 0.103495523333549, 0.103303261101246, 0.103111371397972, 0.102919578552246, 0.102728001773357, 0.102536663413048, 0.102345511317253, 0.102154590189457, 0.101963877677917, 0.101773403584957, 0.101583026349545, 0.101393021643162, 0.101203188300133, 0.101013593375683, 0.100824169814587, 0.100635021924973, 0.100446067750454, 0.100257329642773, 0.100068792700768, 0.0998805090785027, 0.0996924340724945, 0.0995045602321625, 0.0993167981505394, 0.0991294831037521, 0.0989421755075455, 0.0987552255392075, 0.0985684618353844, 0.0983819216489792, 0.0981957092881203, 0.0980096012353897, 0.0978237465023994, 0.0976379886269569, 0.0974525660276413, 0.097267359495163, 0.0970822796225548, 0.0968974381685257, 0.0967129170894623, 0.0965284928679466, 0.0963443890213966, 0.0961605086922646, 0.0959767624735832, 0.0957932993769646, 0.0956100076436996, 0.0954270139336586, 0.0952441841363907, 0.0950615406036377, 0.094879075884819, 0.0946969389915466, 0.0945149287581444, 0.0943332985043526, 0.0941517129540443, 0.0939704850316048, 0.0937893614172935, 0.0936085432767868, 0.093427911400795, 0.0932475551962852, 0.093067392706871, 0.0928874015808105, 0.0927075073122978, 0.0925280153751373, 0.092348724603653, 0.092169500887394, 0.0919907093048096, 0.0918120071291924, 0.0916335731744766, 0.0914553180336952, 0.0912773013114929, 0.0910995155572891, 0.0909220054745674, 0.0907445773482323, 0.0905674248933792, 0.0903904587030411, 0.090213768184185, 0.0900373458862305, 0.0898610204458237, 0.089684970676899, 0.0895091518759727, 0.0893335491418839, 0.0891581401228905, 0.0889830067753792, 0.0888080149888992, 0.0886334255337715, 0.0884588435292244, 0.0882845744490623, 0.0881103947758675, 0.087936595082283, 0.0877630114555359, 0.0875896215438843, 0.0874163433909416, 0.0872433632612228, 0.0870706140995026, 0.0868981331586838, 0.0867257490754128, 0.0865536704659462, 0.086381696164608, 0.0862100422382355, 0.0860385671257973, 0.0858673229813576, 0.0856963023543358, 0.0855255648493767, 0.0853550061583519, 0.085184633731842, 0.0850145369768143, 0.0848445668816566, 0.0846749320626259, 0.0845054164528847, 0.084336094558239, 0.0841670110821724, 0.083998367190361, 0.0838296860456467, 0.0836613774299622, 0.0834931433200836, 0.0833251997828484, 0.0831575244665146, 0.0829899907112122, 0.0828227177262306, 0.0826556459069252, 0.0824888423085213, 0.0823220387101173, 0.0821556895971298, 0.0819894820451736, 0.081823542714119, 0.0816577523946762, 0.0814922302961349, 0.0813268348574638, 0.0811617746949196, 0.0809968858957291, 0.0808322429656982, 0.0806678161025047, 0.0805035755038261, 0.0803395137190819, 0.0801756829023361, 0.0800121277570724, 0.0798487663269043, 0.0796857476234436, 0.0795228332281113, 0.079360157251358, 0.0791976526379585, 0.0790353864431381, 0.0788733810186386, 0.078711561858654, 0.0785498917102814, 0.0783885717391968, 0.0782273188233376, 0.0780663713812828, 0.077905610203743, 0.0777451172471046, 0.0775848627090454, 0.0774247348308563, 0.0772649273276329, 0.077105313539505, 0.0769459307193756, 0.0767866745591164, 0.0766277462244034, 0.0764688551425934, 0.0763103887438774, 0.0761520564556122, 0.0759939849376678, 0.0758360624313354, 0.0756784155964851, 0.0755209997296333, 0.0753638446331024, 0.0752067938446999, 0.0750500187277794, 0.0748935490846634, 0.0747371390461922, 0.0745810493826866, 0.074424996972084, 0.0742693096399307, 0.0741138160228729, 0.0739585980772972, 0.0738035142421722, 0.0736487433314323, 0.0734941139817238, 0.0733398050069809, 0.0731856375932693, 0.0730316489934921, 0.0728779807686806, 0.0727244541049004, 0.0725711137056351, 0.0724180340766907, 0.0722651928663254, 0.0721125230193138, 0.0719601437449455, 0.0718079432845116, 0.0716560110449791, 0.071504220366478, 0.0713528022170067, 0.071201466023922, 0.0710503607988358, 0.0708993971347809, 0.0707487538456917, 0.0705983340740204, 0.070448100566864, 0.0702980905771255, 0.0701483190059662, 0.069998674094677, 0.0698494017124176, 0.0697002708911896, 0.0695513635873795, 0.0694026425480843, 0.0692541897296906, 0.0691059231758118, 0.0689577981829643, 0.068809986114502, 0.0686623677611351, 0.0685150176286697, 0.0683678984642029, 0.0682210028171539, 0.0680741965770721, 0.0679277628660202, 0.067781463265419, 0.0676354020833969, 0.0674895122647285, 0.0673440471291542, 0.0671985223889351, 0.0670533180236816, 0.0669083520770073, 0.0667635649442673, 0.0666190534830093, 0.0664747282862663, 0.0663306713104248, 0.0661868005990982, 0.0660431087017059, 0.0658997446298599, 0.0657565146684647, 0.0656135082244873, 0.0654706433415413, 0.0653281062841415, 0.0651857405900955, 0.065043605864048, 0.0649017542600632, 0.0647599846124649, 0.0646185427904129, 0.0644824281334877, 0.0643510967493057, 0.0642199069261551, 0.0640888959169388, 0.063958115875721, 0.0638272911310196, 0.0636967867612839, 0.0635664686560631, 0.0634363293647766, 0.0633062347769737, 0.0631765052676201, 0.0630468279123306, 0.0629173740744591, 0.0627880617976189, 0.062658928334713, 0.0625299364328384, 0.0624010749161243, 0.0622724033892155, 0.0621438659727573, 0.0620156042277813, 0.061887476593256, 0.0617595836520195, 0.0616318248212337, 0.061504203826189, 0.061376765370369, 0.0612495131790638, 0.0611223466694355, 0.060995414853096, 0.0608686171472073, 0.0607420019805431, 0.0606156177818775, 0.0604893229901791, 0.0603632591664791, 0.0602373294532299, 0.0601116307079792, 0.0599859803915024, 0.0598606020212173, 0.0597353652119637, 0.0596103519201279, 0.0594854280352592, 0.0593606941401958, 0.0592360943555832, 0.0591117702424526, 0.0589875318109989, 0.0588634833693504, 0.058739572763443, 0.0586158819496632, 0.0584923401474953, 0.0583690665662289, 0.058245837688446, 0.058122843503952, 0.058000024408102, 0.0578772574663162, 0.0577547177672386, 0.0576323606073856, 0.0575102791190147, 0.0573882423341274, 0.0572663880884647, 0.0571447648108006, 0.0570232756435871, 0.0569019690155983, 0.0567808523774147, 0.0566597767174244, 0.056539062410593, 0.05641845241189, 0.0562978759407997, 0.0561775788664818, 0.0560574680566788, 0.0559374913573265, 0.0558176971971989, 0.0556981340050697, 0.0555786564946175, 0.0554594583809376, 0.0553403086960316, 0.0552213825285435, 0.055102601647377, 0.0549840405583382, 0.0548655278980732, 0.0547472424805164, 0.0546291917562485, 0.0545113198459148, 0.0543935410678387, 0.0542759895324707, 0.0541585795581341, 0.0540413446724415, 0.0539242997765541, 0.0538074336946011, 0.0536906644701958, 0.0535742081701756, 0.0534576661884785, 0.0533414445817471, 0.0532254502177238, 0.053109597414732, 0.052993830293417, 0.0528783835470676, 0.0527629815042019, 0.0526478141546249, 0.0525328256189823, 0.0524179749190807, 0.0523033104836941, 0.0521887838840485, 0.0520743876695633, 0.0519602261483669, 0.0518462024629116, 0.0517324022948742, 0.0516186952590942, 0.0515052676200867, 0.051391925662756, 0.0512788631021976, 0.0511658005416393, 0.0510530099272728, 0.0509403981268406, 0.0508279763162136, 0.0507155582308769, 0.050603449344635, 0.0504915304481983, 0.0503797456622124, 0.0502680987119675, 0.0501566417515278, 0.0500454045832157, 0.0499342642724514, 0.0498233959078789, 0.0497125759720802, 0.0496020279824734, 0.0494916178286076, 0.0493812523782253, 0.0492712147533894, 0.0491613075137138, 0.0490515381097794, 0.0489419959485531, 0.0488325953483582, 0.0487233735620975, 0.0486142933368683, 0.0485054850578308, 0.0483967252075672, 0.0482881441712379, 0.0481797941029072, 0.0480714477598667, 0.0479634627699852, 0.0478556156158447, 0.0477478615939617, 0.0476403832435608, 0.0475330352783203, 0.0474258773028851, 0.0473188571631908, 0.0472119674086571, 0.0471054092049599, 0.0469987951219082, 0.0468925088644028, 0.0467862151563168, 0.046680249273777, 0.0465744584798813, 0.0464687645435333, 0.0463632568717003, 0.0462579727172852, 0.0461528263986111, 0.0460478588938713, 0.0459430404007435, 0.0458384901285172, 0.0457339808344841, 0.0456297099590302, 0.0455254763364792, 0.0454215705394745, 0.0453177951276302, 0.045214120298624, 0.0451107546687126, 0.0450074411928654, 0.044904351234436, 0.0448014475405216, 0.0446986891329288, 0.0445961058139801, 0.0444936603307724, 0.0443914458155632, 0.0442892275750637, 0.0441873334348202, 0.044085618108511, 0.043984092772007, 0.0438826084136963, 0.0437814444303513, 0.0436804182827473, 0.0435795299708843, 0.0434787757694721, 0.043378259986639, 0.0432778261601925, 0.0431776270270348, 0.0430775135755539, 0.0429776757955551, 0.0428779795765877, 0.0427784696221352, 0.0426791310310364, 0.0425799377262592, 0.0424809269607067, 0.0423820540308952, 0.0422834120690823, 0.04218490421772, 0.0420865714550018, 0.0419884324073792, 0.0418903380632401, 0.0417924746870995, 0.0416948311030865, 0.0415974222123623, 0.0415000580251217, 0.0414029248058796, 0.0413059294223785, 0.0412091538310051, 0.0411125719547272, 0.0410160757601261, 0.0409198142588139, 0.040823683142662, 0.0407276935875416, 0.0406318865716457, 0.0405362620949745, 0.0404407754540443, 0.0403455197811127, 0.040250439196825, 0.040155503898859, 0.0400607995688915, 0.0399661771953106, 0.0398717895150185, 0.0397775433957577, 0.0396835170686245, 0.039589449763298, 0.0394957028329372, 0.0394021347165108, 0.0393087118864059, 0.0392155088484287, 0.0391224958002567, 0.0390296615660191, 0.0389368794858456, 0.0388443693518639, 0.0387519933283329, 0.038659755140543, 0.0385677479207516, 0.0384757854044437, 0.0383841022849083, 0.0382925942540169, 0.0382012724876404, 0.038110040128231, 0.0380189977586269, 0.0379281789064407, 0.0378375463187695, 0.0377470441162586, 0.0376566872000694, 0.0375665053725243, 0.0374765619635582, 0.0373866595327854, 0.0372970327734947, 0.0372074991464615, 0.0371181853115559, 0.0370290614664555, 0.0369401201605797, 0.0368512719869614, 0.0367626994848251, 0.0366742573678493, 0.0365860052406788, 0.0364977978169918, 0.0364098660647869, 0.0363220199942589, 0.0362344086170197, 0.0361469760537148, 0.0360596813261509, 0.0359726175665855, 0.0358856879174709, 0.0357989482581615, 0.0357123427093029, 0.035626009106636, 0.0355396755039692, 0.0354536212980747, 0.0353677459061146, 0.0352818705141544, 0.0351963639259338, 0.0351109504699707, 0.0350257605314255, 0.0349406637251377, 0.0348557978868484, 0.0347710661590099, 0.0346865206956863, 0.0346021130681038, 0.0345179289579391, 0.0344339311122894, 0.0343500711023808, 0.034266259521246, 0.0341827198863029, 0.034099455922842, 0.0340162813663483, 0.033933199942112, 0.0338503941893578, 0.0337677225470543, 0.0336852371692657, 0.0336028859019279, 0.0335207208991051, 0.0334387384355068, 0.0333569347858429, 0.0332752279937267, 0.0331936553120613, 0.033112358301878, 0.0330312475562096, 0.0329503156244755, 0.0328694768249989, 0.0327888689935207, 0.0327084399759769, 0.0326281487941742, 0.0325480438768864, 0.0324681214988232, 0.032388336956501, 0.0323086380958557, 0.0322291739284992, 0.0321498923003674, 0.0320708379149437, 0.0319918766617775, 0.0319131873548031, 0.031834501773119, 0.0317561328411102, 0.0316778570413589, 0.0315998569130898, 0.0315219014883041, 0.0314442217350006, 0.031366590410471, 0.0312891826033592, 0.0312119144946337, 0.0311348754912615, 0.03105797059834, 0.0309813432395458, 0.0309047158807516, 0.0308283641934395, 0.0307521484792233, 0.0306761618703604, 0.0306002646684647, 0.0305245984345675, 0.0304489806294441, 0.0303736347705126, 0.0302984714508057, 0.0302234459668398, 0.0301486030220985, 0.0300739891827106, 0.0299995131790638, 0.0299251731485128, 0.0298509728163481, 0.0297770015895367, 0.0297032110393047, 0.0296294651925564, 0.0295559074729681, 0.0294826216995716, 0.029409471899271, 0.0293365512043238, 0.0292637683451176, 0.0291911233216524, 0.0291187074035406, 0.0290464293211699, 0.0289742890745401, 0.0289023276418447, 0.028830599039793, 0.0287589151412249, 0.0286874603480101, 0.0286161433905363, 0.0285451002418995, 0.028474148362875, 0.0284034702926874, 0.0283327959477901, 0.0282623935490847, 0.0281921736896038, 0.028122091665864, 0.0280521921813488, 0.0279824770987034, 0.0279129464179277, 0.0278434604406357, 0.0277741998434067, 0.0277052186429501, 0.0276362337172031, 0.0275675281882286, 0.0274990014731884, 0.0274306572973728, 0.0273624062538147, 0.0272944308817387, 0.0272265449166298, 0.0271588452160358, 0.0270913727581501, 0.0270239003002644, 0.0269567500799894, 0.0268897339701653, 0.0268229022622108, 0.0267562996596098, 0.0266897883266211, 0.0266234129667282, 0.0265573151409626, 0.0264912620186806, 0.0264254827052355, 0.026359748095274, 0.0262943375855684, 0.0262289233505726, 0.0261638313531876, 0.02609883248806, 0.0260341037064791, 0.025969423353672, 0.0259049721062183, 0.0258407033979893, 0.0257765725255013, 0.025712626054883, 0.0256488621234894, 0.0255852807313204, 0.0255218334496021, 0.0254585742950439, 0.0253954045474529, 0.0253324639052153, 0.0252696592360735, 0.0252071768045425, 0.0251446943730116, 0.0250824857503176, 0.0250204149633646, 0.0249584820121527, 0.0248967763036489, 0.0248352084308863, 0.0247738230973482, 0.024712486192584, 0.0246514659374952, 0.024590540677309, 0.0245298873633146, 0.0244693271815777, 0.0244089961051941, 0.0243488475680351, 0.0242887437343597, 0.0242289640009403, 0.0241692252457142, 0.0241096708923578, 0.024050347507, 0.0239912085235119, 0.0239320639520884, 0.0238732453435659, 0.0238145589828491, 0.0237561073154211, 0.02369774132967, 0.0236396081745625, 0.0235816109925508, 0.0235237963497639, 0.0234661661088467, 0.0234087184071541, 0.0233513601124287, 0.0232942346483469, 0.0232371967285872, 0.0231803897768259, 0.0231237690895796, 0.0230673719197512, 0.0230110231786966, 0.022954948246479, 0.0228989664465189, 0.0228432565927505, 0.0227875933051109, 0.0227322056889534, 0.0226769112050533, 0.0226217526942492, 0.0225668214261532, 0.0225121211260557, 0.0224575083702803, 0.0224030837416649, 0.0223488844931126, 0.0222947783768177, 0.0222409032285213, 0.0221871621906757, 0.0221336036920547, 0.0220802295953035, 0.0220270417630672, 0.0219739433377981, 0.0219209790229797, 0.021868247538805, 0.0218157432973385, 0.021763376891613, 0.0217111930251122, 0.0216591451317072, 0.0216072835028172, 0.0215556025505066, 0.0215041060000658, 0.0214526988565922, 0.0214015692472458, 0.0213505309075117, 0.0212996285408735, 0.0212489552795887, 0.0211984645575285, 0.0211482048034668, 0.0210980791598558, 0.0210480019450188, 0.0209981985390186, 0.0209485348314047, 0.0208991430699825, 0.020849796012044, 0.0208006333559752, 0.0207516998052597, 0.020702812820673, 0.0206541512161493, 0.0206057690083981, 0.0205574296414852, 0.0205093193799257, 0.0204613953828812, 0.0204136036336422, 0.0203660447150469, 0.0203186236321926, 0.0202713813632727, 0.0202242340892553, 0.0201773121953011, 0.0201304852962494, 0.0200839322060347, 0.0200370885431767, 0.0199906472116709, 0.0199442207813263, 0.0198979061096907, 0.0198516640812159, 0.01980553381145, 0.0197593700140715, 0.0197134222835302, 0.0196674522012472, 0.0196216870099306, 0.0195759236812592, 0.0195303317159414, 0.0194847397506237, 0.0194392632693052, 0.0193938184529543, 0.0193484798073769, 0.0193032417446375, 0.0192580837756395, 0.0192129965871572, 0.0191680565476418, 0.0191230941563845, 0.0190783366560936, 0.0190335586667061, 0.0189889278262854, 0.0189443659037352, 0.0188998021185398, 0.0188554227352142, 0.0188111010938883, 0.0187668595463037, 0.0187227204442024, 0.0186786409467459, 0.0186346862465143, 0.0185907389968634, 0.0185468997806311, 0.0185031276196241, 0.0184594802558422, 0.0184159353375435, 0.0183724164962769, 0.0183291006833315, 0.0182857178151608, 0.0182425286620855, 0.0181993748992682, 0.0181562881916761, 0.0181132592260838, 0.0180703345686197, 0.0180275235325098, 0.0179848279803991, 0.0179421529173851, 0.0178995933383703, 0.0178571380674839, 0.0178146809339523, 0.0177723616361618, 0.0177301578223705, 0.017687963321805, 0.0176458731293678, 0.0176039077341557, 0.0175620131194592, 0.0175202190876007, 0.017478484660387, 0.0174367725849152, 0.0173952300101519, 0.0173537135124207, 0.0173123441636562, 0.0172709971666336, 0.0172297544777393, 0.017188623547554, 0.0171475652605295, 0.0171066075563431, 0.0170656740665436, 0.0170248635113239, 0.0169841125607491, 0.0169434882700443, 0.0169028621166945, 0.0168624091893435, 0.016822000965476, 0.0167816616594791, 0.0167414471507072, 0.016701303422451, 0.0166612155735493, 0.0166212879121304, 0.0165812913328409, 0.0165414903312922, 0.0165017694234848, 0.0164621509611607, 0.0164225324988365, 0.0163830853998661, 0.0163436736911535, 0.0163044109940529, 0.0162651222199202, 0.0162259507924318, 0.0161868929862976, 0.0161479394882917, 0.0161089841276407, 0.0160702131688595, 0.016031451523304, 0.0159928519278765, 0.0159542411565781, 0.0159158129245043, 0.0158773269504309, 0.0158390365540981, 0.0158008150756359, 0.0157626494765282, 0.0157245993614197, 0.0156866274774075, 0.01564871519804, 0.0156109044328332, 0.0155731746926904, 0.0155355585739017, 0.0154979079961777, 0.0154604418203235, 0.015423065982759, 0.0153857134282589, 0.0153485555201769, 0.0153113743290305, 0.0152743086218834, 0.015237333253026, 0.0152004500851035, 0.0151636237278581, 0.0151268439367414, 0.0150901889428496, 0.0150536615401506, 0.0150171434506774, 0.0149807864800096, 0.0149444527924061, 0.0149082792922854, 0.0148721057921648, 0.0148360338062048, 0.0148000102490187, 0.0147640993818641, 0.0147282909601927, 0.0146925989538431, 0.0146569283679128, 0.0146214058622718, 0.0145859075710177, 0.0145504772663116, 0.0145151847973466, 0.0144799258559942, 0.0144447488710284, 0.0144097646698356, 0.0143747124820948, 0.0143398549407721, 0.0143050774931908, 0.0142703568562865, 0.0142356818541884, 0.0142010981217027, 0.014166665263474, 0.0141322081908584, 0.0140979094430804, 0.0140636814758182, 0.0140295568853617, 0.013995511457324, 0.0139615340158343, 0.0139276264235377, 0.0138938101008534, 0.0138600738719106, 0.01382642891258, 0.0137928193435073, 0.0137594025582075, 0.0137259755283594, 0.0136926975101233, 0.0136593729257584, 0.0136262653395534, 0.0135932397097349, 0.013560269959271, 0.0135273225605488, 0.0134945716708899, 0.0134617947041988, 0.0134292375296354, 0.0133965779095888, 0.013364146463573, 0.013331726193428, 0.0132994316518307, 0.0132671939209104, 0.0132350716739893, 0.0132030071690679, 0.0131710665300488, 0.013139127753675, 0.0131073826923966, 0.0130755333229899, 0.0130439484491944, 0.013012420386076, 0.0129808699712157, 0.012949526309967, 0.0129181928932667, 0.0128870662301779, 0.0128557551652193, 0.0128247551620007, 0.0127937877550721, 0.0127628790214658, 0.0127320820465684, 0.0127014480531216, 0.0126707330346107, 0.0126401884481311, 0.0126096801832318, 0.0125793544575572, 0.012548946775496, 0.0125187477096915, 0.012488616630435, 0.0124585535377264, 0.0124286059290171, 0.0123987132683396, 0.0123689360916615, 0.0123392064124346, 0.0123095214366913, 0.0122799845412374, 0.0122504821047187, 0.0122210718691349, 0.0121917873620987, 0.0121626053005457, 0.0121334008872509, 0.0121043808758259, 0.0120754046365619, 0.012046542018652, 0.0120176477357745, 0.0119889583438635, 0.0119602903723717, 0.0119317267090082, 0.0119032775983214, 0.0118749430403113, 0.0118466084823012, 0.0118183642625809, 0.0117902243509889, 0.0117622558027506, 0.0117341959849, 0.0117063531652093, 0.0116785801947117, 0.0116507606580853, 0.011623133905232, 0.011595600284636, 0.0115681700408459, 0.0115407267585397, 0.0115134343504906, 0.011486254632473, 0.0114590870216489, 0.0114320470020175, 0.0114050833508372, 0.0113782016560435, 0.0113513441756368, 0.011324611492455, 0.0112980268895626, 0.0112714665010571, 0.0112449740990996, 0.0112185850739479, 0.0111922649666667, 0.0111660361289978, 0.0111399423331022, 0.0111138625070453, 0.0110878506675363, 0.0110619533807039, 0.0110362619161606, 0.0110104903578758, 0.0109848454594612, 0.0109592694789171, 0.0109338406473398, 0.0109083894640207, 0.0108831329271197, 0.0108579462394118, 0.0108328144997358, 0.0108077190816402, 0.010782771743834, 0.0107579259201884, 0.01073301397264, 0.0107083637267351, 0.0106837246567011, 0.0106591666117311, 0.0106346663087606, 0.0106103708967566, 0.0105860289186239, 0.0105617800727487, 0.0105375992134213, 0.0105136130005121, 0.010489558801055, 0.0104656983166933, 0.0104419523850083, 0.0104182297363877, 0.0103945750743151, 0.0103710237890482, 0.0103475982323289, 0.0103241382166743, 0.0103008849546313, 0.0102776419371367, 0.0102544687688351, 0.0102314557880163, 0.0102085107937455, 0.0101856226101518, 0.0101627688854933, 0.0101400762796402, 0.0101174293085933, 0.0100948614999652, 0.0100723979994655, 0.0100500946864486, 0.0100277680903673, 0.0100055551156402, 0.00998339895159006, 0.00996138155460358, 0.00993940979242325, 0.00991749484091997, 0.0098956935107708, 0.00987391732633114, 0.00985234603285789, 0.00983079615980387, 0.00980939716100693, 0.0097879059612751, 0.00976664293557405, 0.00974543765187263, 0.00972435902804136, 0.00970319844782352, 0.00968233589082956, 0.00966143980622292, 0.00964062381535769, 0.00961986463516951, 0.0095992898568511, 0.0095787588506937, 0.00955824088305235, 0.00953784771263599, 0.00951765011996031, 0.00949733704328537, 0.00947726424783468, 0.00945721380412579, 0.00943716522306204, 0.00941729918122292, 0.00939753465354443, 0.0093778520822525, 0.00935822539031506, 0.00933862198144197, 0.00931921415030956, 0.00929974857717752, 0.00928047578781843, 0.0092612961307168, 0.00924215093255043, 0.00922308675944805, 0.00920412410050631, 0.00918532162904739, 0.00916654150933027, 0.00914778560400009, 0.00912913214415312, 0.00911057088524103, 0.00909209996461868, 0.00907367561012506, 0.0090554803609848, 0.00903725065290928, 0.0090190889313817, 0.00900107622146606, 0.00898314453661442, 0.00896522309631109, 0.00894739385694265, 0.00892974715679884, 0.00891202129423618, 0.00889450032263994, 0.00887709390372038, 0.00885974522680044, 0.00884238537400961, 0.00882522016763687, 0.00880805402994156, 0.00879098009318113, 0.00877400860190392, 0.008757209405303, 0.00874042138457298, 0.00872364453971386, 0.00870702788233757, 0.00869053788483143, 0.0086739668622613, 0.00865762587636709, 0.00864137522876263, 0.00862509105354548, 0.00860896706581116, 0.0085930023342371, 0.00857701525092125, 0.00856113247573376, 0.00854531582444906, 0.00852963794022799, 0.00851396005600691, 0.00849843118339777, 0.00848301593214273, 0.0084676705300808, 0.00845234654843807, 0.0084371380507946, 0.00842203199863434, 0.0084069948643446, 0.00839199218899012, 0.00837709195911884, 0.00836229603737593, 0.00834756810218096, 0.00833299942314625, 0.00831845495849848, 0.00830397848039865, 0.00828960537910461, 0.00827536825090647, 0.00826112087816, 0.00824694242328405, 0.00823292415589094, 0.00821901950985193, 0.00820509251207113, 0.0081913135945797, 0.00817761570215225, 0.00816404353827238, 0.00815042480826378, 0.00813700258731842, 0.00812365859746933, 0.00811026897281408, 0.0080970972776413, 0.00808402895927429, 0.00807090289890766, 0.00805797055363655, 0.0080451313406229, 0.0080323712900281, 0.00801964569836855, 0.00800697784870863, 0.00799447018653154, 0.00798197276890278, 0.00796959083527327, 0.00795738026499748, 0.00794511195272207, 0.00793298147618771, 0.00792095437645912, 0.00790904182940722, 0.00789719726890326, 0.00788533035665751, 0.00787366926670074, 0.00786196161061525, 0.0078504728153348, 0.00783902872353792, 0.00782767683267593, 0.00781638082116842, 0.0078051551245153, 0.00779404304921627, 0.00778304506093264, 0.00777201354503632, 0.00776119902729988, 0.00775036169216037, 0.00773967336863279, 0.00772904232144356, 0.00771852536126971, 0.00770807731896639, 0.0076976977288723, 0.00768738659098744, 0.00767727056518197, 0.00766701670363545, 0.00765703758224845, 0.00764707056805491, 0.00763726327568293, 0.00762738659977913, 0.00761771760880947, 0.00760811567306519, 0.00759852584451437, 0.00758909666910768, 0.00757975829765201, 0.00757041992619634, 0.00756123056635261, 0.00755215575918555, 0.00754314940422773, 0.0075341546908021, 0.00752528570592403, 0.00751656526699662, 0.00750770792365074, 0.00749917095527053, 0.00749064516276121, 0.00748219946399331, 0.00747376540675759, 0.00746552646160126, 0.00745735503733158, 0.00744926417246461, 0.00744111649692059, 0.00743324309587479, 0.00742528913542628, 0.00741755403578281, 0.00740987528115511, 0.00740226451307535, 0.00739467795938253, 0.00738723948597908, 0.00737991509959102, 0.0073726256377995, 0.00736534735187888, 0.00735827488824725, 0.00735125970095396, 0.00734426733106375, 0.00733738951385021, 0.00733066070824862, 0.0073239547200501, 0.00731730600818992, 0.00731077184900641, 0.0073043517768383, 0.0072979205287993, 0.0072916834615171, 0.00728551531210542, 0.00727935880422592, 0.007273328024894, 0.00726739969104528, 0.00726151745766401, 0.00725572649389505, 0.00725002819672227, 0.00724440859630704, 0.00723885931074619, 0.00723342318087816, 0.00722810160368681, 0.0072228373028338, 0.00721757300198078, 0.00721244653686881, 0.00720746908336878, 0.00720252469182014, 0.00719447946175933, 0.00718338740989566, 0.00717231538146734, 0.0071612810716033, 0.00715023512020707, 0.007139234803617, 0.00712826568633318, 0.00711730541661382, 0.00710637122392654, 0.00709546217694879, 0.00708456430584192, 0.00707368971779943, 0.00706284446641803, 0.00705201271921396, 0.00704120425507426, 0.00703043257817626, 0.00701967533677816, 0.00700894417241216, 0.00699823535978794, 0.0069875530898571, 0.0069768731482327, 0.00696620438247919, 0.00695558497682214, 0.0069449907168746, 0.00693440809845924, 0.00692385341972113, 0.00691332295536995, 0.00690280552953482, 0.00689232302829623, 0.00688185775652528, 0.00687139248475432, 0.00686095887795091, 0.00685056485235691, 0.00684018805623055, 0.00682983454316854, 0.00681949499994516, 0.00680918991565704, 0.00679889647290111, 0.00678861141204834, 0.00677836872637272, 0.00676815258339047, 0.00675793876871467, 0.00674775941297412, 0.00673760939389467, 0.00672747846692801, 0.00671736476942897, 0.00670727714896202, 0.00669718952849507, 0.00668715359643102, 0.00667712558060884, 0.00666712690144777, 0.00665715057402849, 0.00664718635380268, 0.00663725845515728, 0.00662734778597951, 0.00661743804812431, 0.00660757627338171, 0.00659772567451, 0.00658791325986385, 0.00657811667770147, 0.00656834384426475, 0.00655857101082802, 0.00654884381219745, 0.00653913384303451, 0.00652942340821028, 0.00651975395157933, 0.00651011802256107, 0.006500493735075, 0.00649089831858873, 0.00648131361231208, 0.00647176941856742, 0.00646222336217761, 0.00645268755033612, 0.00644320622086525, 0.00643373653292656, 0.00642430083826184, 0.00641488283872604, 0.00640547554939985, 0.0063961036503315, 0.00638674851506948, 0.00637741573154926, 0.00636807736009359, 0.00635879067704082, 0.00634952122345567, 0.0063402783125639, 0.00633106287568808, 0.00632186746224761, 0.00631268694996834, 0.00630353158339858, 0.00629437947645783, 0.00628527346998453, 0.00627618422731757, 0.00626711500808597, 0.00625807093456388, 0.00624904176220298, 0.00624004984274507, 0.00623107282444835, 0.00622209487482905, 0.00621316861361265, 0.00620425445958972, 0.00619537336751819, 0.00618651043623686, 0.00617765914648771, 0.00616882974281907, 0.00616004085168242, 0.00615126360207796, 0.00614249194040895, 0.00613375194370747, 0.0061250519938767, 0.00611635996028781, 0.00610769726336002, 0.00609905971214175, 0.00609042309224606, 0.00608182232826948, 0.00607322249561548, 0.00606467388570309, 0.00605614809319377, 0.00604763999581337, 0.00603915145620704, 0.00603069132193923, 0.00602224329486489, 0.00601382926106453, 0.00600542407482862, 0.00599702401086688, 0.00598866492509842, 0.00598033890128136, 0.00597203057259321, 0.00596374599263072, 0.005955477245152, 0.00594722898676991, 0.00593902124091983, 0.00593079859390855, 0.00592261692509055, 0.00591446040198207, 0.00590632623061538, 0.00589821580797434, 0.00589013332501054, 0.00588206574320793, 0.0058740321546793, 0.00586598692461848, 0.00585799338296056, 0.00585001427680254, 0.00584205845370889, 0.00583412731066346, 0.00582621991634369, 0.00581832649186254, 0.00581045588478446, 0.0058026285842061, 0.00579477520659566, 0.00578698515892029, 0.00577920256182551, 0.00577146140858531, 0.00576371932402253, 0.00575601775199175, 0.00574832176789641, 0.00574065744876862, 0.00573299312964082, 0.0057253772392869, 0.00571777252480388, 0.00571020832285285, 0.00570265576243401, 0.00569512788206339, 0.00568760093301535, 0.0056801144964993, 0.00567263877019286, 0.00566518539562821, 0.00565776973962784, 0.00565036898478866, 0.00564300501719117, 0.00563564337790012, 0.00562831666320562, 0.00562101555988193, 0.00561372004449368, 0.00560643337666988, 0.0055991979315877, 0.00559197133406997, 0.00558477314189076, 0.00557759776711464, 0.00557044800370932, 0.00556332478299737, 0.00555621506646276, 0.00554910534992814, 0.00554204452782869, 0.00553498649969697, 0.0055279778316617, 0.00552097428590059, 0.00551400473341346, 0.00550704402849078, 0.00550012337043881, 0.00549321435391903, 0.00548630813136697, 0.0054794386960566, 0.0054726037196815, 0.0054657687433064, 0.0054589775390923, 0.00545220263302326, 0.00544544495642185, 0.00543871289119124, 0.00543198361992836, 0.00542530091479421, 0.00541864335536957, 0.00541200069710612, 0.00540538318455219, 0.00539877684786916, 0.00539220822975039, 0.00538565125316381, 0.00537909939885139, 0.00537259364500642, 0.00536611117422581, 0.00535964500159025, 0.00535320211201906, 0.00534678855910897, 0.0053403964266181, 0.0053340052254498, 0.0053276508115232, 0.00532130245119333, 0.00531499413773417, 0.00530871422961354, 0.00530244875699282, 0.0052962121553719, 0.00528998393565416, 0.00528379529714584, 0.00527761643752456, 0.00527144176885486, 0.00526530249044299, 0.00525920279324055, 0.00525311194360256, 0.0052470494993031, 0.00524100987240672, 0.00523499911651015, 0.00522899674251676, 0.00522302323952317, 0.00521704973652959, 0.0052111130207777, 0.00520521122962236, 0.00519932946190238, 0.00519346399232745, 0.00518761621788144, 0.00518180290237069, 0.00517600681632757, 0.00517021026462317, 0.00516446027904749, 0.00515873776748776, 0.00515302736312151, 0.00514733418822289, 0.0051416726782918, 0.00513603864237666, 0.00513041485100985, 0.00512481806799769, 0.0051192226819694, 0.00511366641148925, 0.00510814506560564, 0.00510263442993164, 0.00509715359658003, 0.00509168300777674, 0.00508623849600554, 0.00508082052692771, 0.00507539790123701, 0.00507003115490079, 0.00506468396633863, 0.00505935400724411, 0.00505404733121395, 0.00504876580089331, 0.00504349917173386, 0.00503825722262263, 0.00503303902223706, 0.00502780918031931, 0.00502263940870762, 0.00501748733222485, 0.00501235434785485, 0.00500725070014596, 0.00500216940417886, 0.00499711697921157, 0.00499207619577646, 0.0049870265647769, 0.00498202256858349, 0.00497705629095435, 0.00497210118919611, 0.00496717449277639, 0.00496227061375976, 0.00495738442987204, 0.00495253223925829, 0.00494766840711236, 0.00494284508749843, 0.00493804132565856, 0.00493326643481851, 0.00492851436138153, 0.00492378557100892, 0.00491908472031355, 0.00491439877077937, 0.00490973517298698, 0.00490507436916232, 0.0049004633910954, 0.0048958626575768, 0.00489129079505801, 0.0048867417499423, 0.00488220434635878, 0.00487770698964596, 0.00487321522086859, 0.0048687350936234, 0.00486429734155536, 0.00485987728461623, 0.00485547725111246, 0.0048511060886085, 0.00484674610197544, 0.0048424256965518, 0.00483811739832163, 0.00483383191749454, 0.00482954829931259, 0.00482531171292067, 0.00482109468430281, 0.0048168976791203, 0.00481272907927632, 0.0048085805028677, 0.0048044384457171, 0.00480032945051789, 0.004796227440238, 0.00479217013344169, 0.00478812213987112, 0.00478411419317126, 0.00478012021631002, 0.00477615185081959, 0.00477219512686133, 0.00476826401427388, 0.00476436223834753, 0.00476044788956642, 0.00475659174844623, 0.00475274911150336, 0.00474893022328615, 0.00474513601511717, 0.00474137114360929, 0.00473761791363358, 0.00473388656973839, 0.0047301622107625, 0.00472648302093148, 0.00472280383110046, 0.00471916468814015, 0.00471554836258292, 0.0047119609080255, 0.00470839021727443, 0.00470484280958772, 0.00470128934830427, 0.00469778757542372, 0.00469430023804307, 0.0046908357180655, 0.00468739680945873, 0.0046839751303196, 0.00468058791011572, 0.00467721186578274, 0.00467385863885283, 0.00467051146551967, 0.00466720992699265, 0.00466392235830426, 0.00466066086664796, 0.00465742545202374, 0.00465420121327043, 0.0046510030515492, 0.00464784121140838, 0.00464467145502567, 0.00464153289794922, 0.00463843438774347, 0.00463535031303763, 0.00463228905573487, 0.00462925666943192, 0.00462623266503215, 0.0046232370659709, 0.00462026474997401, 0.00461729755625129, 0.00461436295881867, 0.00461145024746656, 0.00460857758298516, 0.0046057109721005, 0.00460287882015109, 0.00460005737841129, 0.00459727365523577, 0.00459447037428617, 0.00459171552211046, 0.00458899466320872, 0.00458629103377461, 0.00458360742777586, 0.00458094663918018, 0.00457830308005214, 0.00457568792626262, 0.00457306997850537, 0.00457050418481231, 0.00456795794889331, 0.00456541730090976, 0.00456291437149048, 0.0045604333281517, 0.0045579788275063, 0.0045555355027318, 0.00455312104895711, 0.00455070612952113, 0.00454832566902041, 0.00454598618671298, 0.00454365694895387, 0.00454134540632367, 0.00453906785696745, 0.0045368024148047, 0.00453456491231918, 0.00453232182189822, 0.00453013321384788, 0.00452796742320061, 0.00452581606805325, 0.00452369311824441, 0.00452159065753222, 0.00451949331909418, 0.00451742811128497, 0.00451537920162082, 0.00451335404068232, 0.00451136520132422, 0.0045093884691596, 0.00450744293630123, 0.0045055178925395, 0.00450361799448729, 0.00450173206627369, 0.00449987314641476, 0.00449801376089454, 0.00449619069695473, 0.00449440535157919, 0.00449263211339712, 0.00449088402092457, 0.00448915828019381, 0.00448745070025325, 0.00448576547205448, 0.00448408629745245, 0.00448243878781796, 0.00448083039373159, 0.00447923457249999, 0.00447766343131661, 0.0044761155731976, 0.00447459379211068, 0.00447308598086238, 0.00447160704061389, 0.00447012484073639, 0.00446869153529406, 0.00446726102381945, 0.00446586776524782, 0.00446449732407928, 0.00446315575391054, 0.00446182209998369, 0.00446052942425013, 0.00445922464132309, 0.00445795711129904, 0.00445672729983926, 0.00445550819858909, 0.00445430679246783, 0.00445313658565283, 0.00445199804380536, 0.00445086508989334, 0.00444974051788449, 0.00444865925237536, 0.00444759521633387, 0.00444656517356634, 0.00444554956629872, 0.00444455957040191, 0.00444358075037599, 0.00444263126701117, 0.00444170413538814, 0.00444077746942639, 0.00443990202620625, 0.00443903775885701, 0.00443819677457213, 0.00443738419562578, 0.00443659443408251, 0.00443583074957132, 0.00443507824093103, 0.0044343201443553, 0.0044336193241179, 0.00443293247371912, 0.00443228334188461, 0.00443164492025971, 0.0044310325756669, 0.00443043187260628, 0.00442987121641636, 0.00442932220175862, 0.00442877830937505, 0.00442825490608811, 0.00442778272554278, 0.00442731939256191, 0.00442688446491957, 0.00442647794261575, 0.00442607793956995, 0.00442570634186268, 0.00442533381283283, 0.00442501343786716, 0.00442471588030457, 0.00442442391067743, 0.00442416407167912, 0.00442393217235804, 0.00442370865494013, 0.00442352844402194, 0.00442335428670049, 0.00442318851128221, 0.00442305626347661, 0.00442295940592885, 0.00442287884652615, 0.0044228108599782, 0.00442276755347848, 0.00442276196554303, 0.00442054169252515, 0.0044160271063447, 0.0044115181080997, 0.00440700957551599, 0.00440250616520643, 0.00439800880849361, 0.00439351703971624, 0.00438903132453561, 0.00438454514369369, 0.00438005896285176, 0.00437558488920331, 0.00437111034989357, 0.00436664698645473, 0.00436217244714499, 0.00435772119089961, 0.00435325782746077, 0.0043488061055541, 0.00434436043724418, 0.0043399203568697, 0.00433547422289848, 0.0043310453183949, 0.00432661082595587, 0.00432218797504902, 0.00431775953620672, 0.00431334180757403, 0.00430892454460263, 0.00430451892316341, 0.00430010724812746, 0.00429570721462369, 0.00429130718111992, 0.00428691832348704, 0.00428252387791872, 0.00427814107388258, 0.0042737522162497, 0.00426937500014901, 0.00426500337198377, 0.00426063174381852, 0.00425627175718546, 0.0042519117705524, 0.00424755178391933, 0.00424320297315717, 0.004238854162395, 0.00423450535163283, 0.00423016864806414, 0.00422583147883415, 0.00422149384394288, 0.00421716831624508, 0.00421284278854728, 0.00420852843672037, 0.00420421408489347, 0.00419989973306656, 0.00419559702277184, 0.00419129384681582, 0.0041869911365211, 0.00418269401416183, 0.00417840806767344, 0.00417411653324962, 0.00416983664035797, 0.00416555674746633, 0.00416128849610686, 0.00415701419115067, 0.00415275152772665, 0.00414848839864135, 0.00414423691108823, 0.00413997424766421, 0.00413572276011109, 0.00413147732615471, 0.00412724306806922, 0.00412300322204828, 0.00411877455189824, 0.00411454029381275, 0.00411032373085618, 0.00410610064864159, 0.00410188362002373, 0.00409767217934132, 0.00409346120432019, 0.00408926093950868, 0.00408506114035845, 0.00408086134120822, 0.00407667271792889, 0.00407249014824629, 0.00406830757856369, 0.00406413059681654, 0.00405995361506939, 0.00405578780919313, 0.00405161082744598, 0.0040474571287632, 0.00404329132288694, 0.00403914274647832, 0.00403499463573098, 0.00403085211291909, 0.0040267095901072, 0.00402256660163403, 0.00401843525469303, 0.00401430996134877, 0.00401017861440778, 0.00400605890899897, 0.00400194525718689, 0.00399783067405224, 0.00399372261017561, 0.00398962013423443, 0.00398552324622869, 0.00398142635822296, 0.00397732947021723, 0.00397324375808239, 0.00396915851160884, 0.00396508444100618, 0.00396100478246808, 0.00395693629980087, 0.00395286828279495, 0.00394880585372448, 0.00394474901258945, 0.00394069775938988, 0.00393664697185159, 0.00393260130658746, 0.00392855005338788, 0.00392451649531722, 0.00392048247158527, 0.00391645403578877, 0.00391243165358901, 0.00390840927138925, 0.00390439224429429, 0.00390038127079606, 0.00389637611806393, 0.00389237049967051, 0.00388836534693837, 0.00388436554931104, 0.00388037739321589, 0.0038763836491853, 0.00387240131385624, 0.00386841874569654, 0.00386444781906903, 0.00386047689244151, 0.00385651155374944, 0.00385254621505737, 0.0038485866971314, 0.00384462694637477, 0.00384067883715034, 0.0038367307279259, 0.00383279426023364, 0.00382885197177529, 0.00382492085918784, 0.00382098997943103, 0.00381706492044032, 0.0038131452165544, 0.00380923156626523, 0.00380530627444386, 0.00380140403285623, 0.0037974959705025, 0.00379359349608421, 0.00378969707526267, 0.00378580600954592, 0.00378192099742591, 0.00377803575247526, 0.00377415609546006, 0.00377027690410614, 0.00376640306785703, 0.00376253528520465, 0.00375867285765707, 0.00375481625087559, 0.00375095987692475, 0.00374710327014327, 0.00374325807206333, 0.00373941869474947, 0.00373557931743562, 0.00373174576088786, 0.00372791197150946, 0.00372408400289714, 0.00372026185505092, 0.00371644529514015, 0.00371263455599546, 0.00370882358402014, 0.00370501284487545, 0.00370121351443231, 0.00369742000475526, 0.00369362626224756, 0.0036898385733366, 0.00368604483082891, 0.00368226855061948, 0.00367848621681333, 0.00367472134530544, 0.00367095065303147, 0.00366719136945903, 0.00366342626512051, 0.00365967256948352, 0.00365591910667717, 0.00365217705257237, 0.00364842335693538, 0.00364468712359667, 0.00364095065742731, 0.00363722001202404, 0.00363349495455623, 0.00362976989708841, 0.00362605648115277, 0.00362234306521714, 0.00361863523721695, 0.00361492764204741, 0.00361121958121657, 0.00360752339474857, 0.00360382674261928, 0.00360013614408672, 0.00359645718708634, 0.00359277240931988, 0.00358909880742431, 0.00358542520552874, 0.00358175183646381, 0.00357808964326978, 0.00357442768290639, 0.00357076595537364, 0.0035671154037118, 0.0035634646192193, 0.00355982547625899, 0.00355618633329868, 0.00355254742316902, 0.0035489194560796, 0.00354529195465147, 0.00354166445322335, 0.00353804789483547, 0.00353443762287498, 0.00353082711808383, 0.00352721661329269, 0.003523611696437, 0.00352002424187958, 0.00351641373708844, 0.00351283187046647, 0.00350924395024776, 0.00350566208362579, 0.00350208021700382, 0.00349851534701884, 0.00349494488909841, 0.00349138001911342, 0.00348782120272517, 0.00348426215350628, 0.00348070333711803, 0.00347715569660068, 0.00347360805608332, 0.00347007182426751, 0.00346653000451624, 0.00346299982629716, 0.00345947500318289, 0.00345595018006861, 0.00345242558978498, 0.00344891217537224, 0.00344539899379015, 0.0034418972209096, 0.00343839544802904, 0.00343489367514849, 0.00343140331096947, 0.0034279131796211, 0.00342442840337753, 0.00342094362713397, 0.00341746490448713, 0.00341399176977575, 0.00341052422299981, 0.00340704526752234, 0.00340358330868185, 0.00340012763626873, 0.00339667708612978, 0.00339322676882148, 0.00338978227227926, 0.0033863375429064, 0.00338290445506573, 0.00337947136722505, 0.00337604968808591, 0.00337261660024524, 0.00336920050904155, 0.0033657846506685, 0.0033623743802309, 0.00335896410979331, 0.00335556524805725, 0.00335216661915183, 0.00334876775741577, 0.00334538053721189, 0.00334199308417737, 0.00333860004320741, 0.00333521841093898, 0.003331842366606, 0.0033284779638052, 0.0033251135610044, 0.00332174892537296, 0.00331839011050761, 0.00331503711640835, 0.00331168971024454, 0.00330834253691137, 0.00330500677227974, 0.00330166518688202, 0.00329833501018584, 0.00329500483348966, 0.00329168047755957, 0.00328835612162948, 0.00328503735363483, 0.00328172999434173, 0.00327842286787927, 0.00327511550858617, 0.00327181979082525, 0.00326851243153214, 0.00326522253453732, 0.0032619321718812, 0.00325865345075727, 0.00325537496246397, 0.00325210206210613, 0.00324882916174829, 0.00324556208215654, 0.00324229476973414, 0.00323904468677938, 0.00323578319512308, 0.0032325389329344, 0.00322929467074573, 0.00322605017572641, 0.00322281173430383, 0.00321957864798605, 0.00321635184809566, 0.00321312458254397, 0.00320990895852447, 0.00320668728090823, 0.00320346606895328, 0.00320025580003858, 0.00319705158472061, 0.00319385319016874, 0.00319065479561687, 0.0031874617561698, 0.00318427453748882, 0.00318109337240458, 0.00317791197448969, 0.00317473616451025, 0.00317157199606299, 0.00316840200684965, 0.00316523783840239, 0.00316207366995513, 0.00315892673097551, 0.00315577397122979, 0.00315262703225017, 0.00314948544837534, 0.00314634991809726, 0.00314321438781917, 0.00314008444547653, 0.003136943327263, 0.0031338247936219, 0.0031307062599808, 0.00312759377993643, 0.00312448665499687, 0.00312137976288795, 0.00311828427948058, 0.00311518856324255, 0.00311208725906909, 0.0031090029515326, 0.00310591910965741, 0.00310284062288702, 0.00309976213611662, 0.00309669529087842, 0.00309362285770476, 0.00309056136757135, 0.00308750593103468, 0.00308445049449801, 0.00308139505796134, 0.00307835103012621, 0.00307529559358954, 0.00307225715368986, 0.00306922476738691, 0.00306619191542268, 0.00306316511705518, 0.00306014390662313, 0.00305712851695716, 0.0030541131272912, 0.00305110332556069, 0.00304809934459627, 0.00304509536363184, 0.00304209697060287, 0.00303911021910608, 0.00303611764684319, 0.00303313671611249, 0.0030301499646157, 0.00302717438898981, 0.00302420463413, 0.00302123511210084, 0.00301827117800713, 0.00301531841978431, 0.00301234307698905, 0.00300939637236297, 0.00300644966773689, 0.00300350855104625, 0.00300056743435562, 0.00299763213843107, 0.00299469707533717, 0.00299177295528352, 0.00298884930089116, 0.00298593076877296, 0.00298301852308214, 0.00298010604456067, 0.00297720497474074, 0.00297430390492082, 0.00297140865586698, 0.00296851363964379, 0.00296561815775931, 0.00296273455023766, 0.00295985629782081, 0.00295697804540396, 0.0029540944378823, 0.0029512217734009, 0.00294836098328233, 0.00294549996033311, 0.00294264475814998, 0.0029397897887975, 0.00293694576248527, 0.00293410196900368, 0.00293126399628818, 0.00292842579074204, 0.00292559945955873, 0.00292276684194803, 0.00291994609870017, 0.00291713094338775, 0.00291431578807533, 0.00291150063276291, 0.00290869688615203, 0.00290589290671051, 0.00290309498086572, 0.00290029705502093, 0.00289751030504704, 0.00289471237920225, 0.00289193168282509, 0.00288915657438338, 0.00288638146594167, 0.0028836119454354, 0.00288084265775979, 0.00287808477878571, 0.00287532666698098, 0.00287258019670844, 0.00286982790566981, 0.00286708725616336, 0.00286434078589082, 0.00286160549148917, 0.00285887625068426, 0.00285614700987935, 0.00285342335700989, 0.00285070552490652, 0.0028479874599725, 0.00284528103657067, 0.00284257438033819, 0.00283986236900091, 0.00283716153353453, 0.00283446675166488, 0.00283177150413394, 0.00282908789813519, 0.00282640452496707, 0.00282372650690377, 0.0028210545424372, 0.00281838234513998, 0.00281571596860886, 0.00281306100077927, 0.00281040603294969, 0.00280775129795074, 0.00280509609729052, 0.00280245253816247, 0.00279981479980052, 0.00279717706143856, 0.00279454491101205, 0.00279191276058555, 0.00278929225169122, 0.0027866717427969, 0.00278405100107193, 0.00278143049217761, 0.00277882697992027, 0.00277622346766293, 0.00277362577617168, 0.00277102808468044, 0.00276844156906009, 0.00276584946550429, 0.00276326900348067, 0.00276068854145706, 0.00275811948813498, 0.00275554461404681, 0.00275298114866018, 0.00275041768327355, 0.00274785980582237, 0.00274530239403248, 0.00274276197887957, 0.00274020992219448, 0.00273766927421093, 0.00273513467982411, 0.00273258844390512, 0.0027300592046231, 0.00272753578610718, 0.00272501818835735, 0.00272250059060752, 0.00271998858079314, 0.0027174826245755, 0.00271497643552721, 0.00271247560158372, 0.00270998128689826, 0.00270749209448695, 0.0027049973141402, 0.00270251394249499, 0.00270004221238196, 0.00269756442867219, 0.00269509851932526, 0.00269262678921223, 0.00269016623497009, 0.0026877059135586, 0.00268525676801801, 0.00268280203454196, 0.00268034730106592, 0.00267789838835597, 0.00267546670511365, 0.00267303502187133, 0.00267060287296772, 0.00266817677766085, 0.00266575650312006, 0.00266334181651473, 0.00266092736274004, 0.0026585184969008, 0.00265611498616636, 0.00265371194109321, 0.00265131471678615, 0.00264892261475325, 0.00264654238708317, 0.00264415075071156, 0.00264177611097693, 0.00263940170407295, 0.00263702706433833, 0.0026346636004746, 0.00263228360563517, 0.00262992596253753, 0.00262757437303662, 0.00262522278353572, 0.00262287678197026, 0.00262053636834025, 0.00261819618754089, 0.00261586182750762, 0.00261353282257915, 0.00261120405048132, 0.00260888086631894, 0.00260656932368875, 0.00260425754822791, 0.00260194600559771, 0.00259964005090296, 0.00259733968414366, 0.0025950453709811, 0.00259275082498789, 0.00259046233259141, 0.0025881789624691, 0.00258589605800807, 0.00258361315354705, 0.00258133583702147, 0.00257906992919743, 0.00257680402137339, 0.00257454975508153, 0.00257229525595903, 0.00257004052400589, 0.00256779766641557, 0.00256555480882525, 0.00256331171840429, 0.00256108026951551, 0.00255884858779609, 0.00255662272684276, 0.00255439686588943, 0.00255218264646828, 0.00254996842704713, 0.00254775956273079, 0.00254555093124509, 0.00254335370846093, 0.00254115648567677, 0.00253894808702171, 0.00253676227293909, 0.00253457622602582, 0.00253239646553993, 0.00253021623939276, 0.00252804765477777, 0.00252587907016277, 0.00252371630631387, 0.00252155354246497, 0.00251940195448697, 0.00251725036650896, 0.0025150990113616, 0.00251295906491578, 0.00251081888563931, 0.00250867917202413, 0.00250655063427985, 0.00250442209653556, 0.00250230496749282, 0.00250018201768398, 0.00249807070940733, 0.00249595916830003, 0.00249384227208793, 0.00249174213968217, 0.0024896424729377, 0.00248755398206413, 0.00248545967042446, 0.00248337700031698, 0.00248129409737885, 0.00247921701520681, 0.00247713993303478, 0.00247507449239492, 0.00247300881892443, 0.00247094896622002, 0.00246888911351562, 0.00246684066951275, 0.00246479222550988, 0.00246274936944246, 0.00246070674620569, 0.00245867529883981, 0.00245664408430457, 0.00245461869053543, 0.0024525816552341, 0.0024505618494004, 0.00244854181073606, 0.00244653946720064, 0.00244452524930239, 0.00244252826087177, 0.00244053127244115, 0.00243853451684117, 0.002436543116346, 0.00243455776944757, 0.00243257801048458, 0.00243059825152159, 0.00242862990126014, 0.0024266557302326, 0.00242469320073724, 0.00242273043841124, 0.00242077931761742, 0.00241882260888815, 0.00241687125526369, 0.00241493154317141, 0.00241297483444214, 0.00241104071028531, 0.00240910681895912, 0.00240718410350382, 0.00240525580011308, 0.00240333913825452, 0.00240142201073468, 0.00239951093681157, 0.00239760568365455, 0.00239570043049753, 0.00239380076527596, 0.00239190668798983, 0.0023900184314698, 0.00238813040778041, 0.00238624773919582, 0.00238437112420797, 0.00238249404355884, 0.00238062301650643, 0.00237876339815557, 0.00237689819186926, 0.00237504416145384, 0.00237317313440144, 0.00237133051268756, 0.00236948253586888, 0.00236763991415501, 0.00236580334603786, 0.00236397236585617, 0.00236214138567448, 0.00236032181419432, 0.00235849665477872, 0.00235668267123401, 0.00235487474128604, 0.00235306634567678, 0.00235125841572881, 0.00234946166165173, 0.00234767072834074, 0.00234587397426367, 0.00234408886171877, 0.00234230351634324, 0.00234052957966924, 0.00233875028789043, 0.00233697076328099, 0.00233520288020372, 0.00233344594016671, 0.0023316836450249, 0.00232993275858462, 0.00232818187214434, 0.00232643680647016, 0.00232469150796533, 0.00232295785099268, 0.00232122396118939, 0.00231949612498283, 0.00231776805594563, 0.00231605139560997, 0.00231433496810496, 0.00231262412853539, 0.00231091305613518, 0.00230920827016234, 0.00230750860646367, 0.00230581522919238, 0.00230412138625979, 0.0023024333640933, 0.00230073975399137, 0.00229906314052641, 0.00229738652706146, 0.0022957157343626, 0.00229404494166374, 0.00229238579049706, 0.00229072640649974, 0.00228907284326851, 0.00228742486797273, 0.00228577712550759, 0.00228413473814726, 0.00228249817155302, 0.00228086183778942, 0.00227923109196126, 0.00227761175483465, 0.00227598682977259, 0.00227437308058143, 0.00227275956422091, 0.00227115186862648, 0.0022695439402014, 0.00226793019101024, 0.00226633413694799, 0.0022647432051599, 0.00226315250620246, 0.0022615734487772, 0.00225999392569065, 0.00225841486826539, 0.00225684698671103, 0.0022552793379873, 0.00225371145643294, 0.00225215521641076, 0.00225059874355793, 0.0022490480914712, 0.00224750326015055, 0.00224596401676536, 0.00224441895261407, 0.00224289135076106, 0.00224135792814195, 0.00223983591422439, 0.00223830807954073, 0.00223679188638926, 0.00223526963964105, 0.00223375926725566, 0.00223225448280573, 0.00223075528629124, 0.00222925608977675, 0.00222776271402836, 0.00222627492621541, 0.00222479295916855, 0.0022233109921217, 0.00222183484584093, 0.00222036428749561, 0.0022188937291503, 0.00221743457950652, 0.00221596984192729, 0.0022145165130496, 0.00221306318417192, 0.00221162126399577, 0.00221017352305353, 0.00220873742364347, 0.00220730109140277, 0.00220585917122662, 0.0022044344805181, 0.00220300978980958, 0.00220159068703651, 0.00220017740502954   }, 
   { 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 0.00614380417391658, 1.358183544653e-05, 2.88596438622335e-05, 4.43893222836778e-05, 5.99571758357342e-05, 7.56929803173989e-05, 9.14594056666829e-05, 0.000107409025076777, 0.000123450241517276, 0.000139545009005815, 0.000155830522999167, 0.000172215339262038, 0.000188714679097757, 0.000205183518119156, 0.000221957772737369, 0.0002387395943515, 0.000255651189945638, 0.000272593402769417, 0.00028971879510209, 0.000306974106933922, 0.000324320892104879, 0.000341789884259924, 0.00035933536128141, 0.00037702574627474, 0.000394830625737086, 0.00041277299169451, 0.000430806947406381, 0.000448955572210252, 0.000466997094918042, 0.000485374766867608, 0.000503866875078529, 0.000522435351740569, 0.000541011337190866, 0.00055986235383898, 0.000578766688704491, 0.00059777038404718, 0.000616888573858887, 0.000636136566754431, 0.000655476120300591, 0.000674876850098372, 0.000694407266564667, 0.00071407511131838, 0.00073389575118199, 0.000753647706005722, 0.000773651467170566, 0.00079380813986063, 0.000814025697764009, 0.000834380742162466, 0.000854758662171662, 0.000875319878105074, 0.000895896286237985, 0.000916732475161552, 0.000937576114665717, 0.000958610675297678, 0.00097960710991174, 0.00100085546728224, 0.00102218019310385, 0.00104364240542054, 0.00106516561936587, 0.0010866429656744, 0.00110844860319048, 0.00113031535875052, 0.00115231203380972, 0.00117433909326792, 0.00119656487368047, 0.0012188438558951, 0.00124132167547941, 0.00126382196322083, 0.00128650583792478, 0.0013092199806124, 0.00133193423971534, 0.00135496922302991, 0.00137806532438844, 0.00140126061160117, 0.00142444064840674, 0.00144788785837591, 0.00147141912020743, 0.00149506481830031, 0.00151880236808211, 0.00154261605348438, 0.00156654417514801, 0.00159061013255268, 0.00161476735956967, 0.00163910025730729, 0.00166350952349603, 0.00168789585586637, 0.00171257229521871, 0.00173732521943748, 0.00176216196268797, 0.0017871210584417, 0.00181209528818727, 0.00183722225483507, 0.00186251720879227, 0.00188789609819651, 0.00191342015750706, 0.0019389441004023, 0.00196472019888461, 0.00199051131494343, 0.00201651616953313, 0.00204257457517087, 0.00206870934925973, 0.00209486740641296, 0.00212120823562145, 0.00214774766936898, 0.00217437092214823, 0.00220099440775812, 0.0022278162650764, 0.00225478317588568, 0.00228180410340428, 0.00230896170251071, 0.00233621103689075, 0.00236358284018934, 0.00239103101193905, 0.00241861632093787, 0.00244632409885526, 0.00247410801239312, 0.00250198366120458, 0.00252997362986207, 0.002558154752478, 0.00258642737753689, 0.00261471490375698, 0.00264317868277431, 0.00267171859741211, 0.00270041101612151, 0.00272921798750758, 0.00275817769579589, 0.00278719095513225, 0.00281623471528292, 0.00284551526419818, 0.00287489523179829, 0.00290432805195451, 0.00293382978998125, 0.00296348426491022, 0.00299326097592711, 0.00302317528985441, 0.00305324210785329, 0.00308323255740106, 0.00311349052935839, 0.00314382440410554, 0.0031742884311825, 0.00320488191209733, 0.00323550612665713, 0.00326618389226496, 0.00329712894745171, 0.00332815013825893, 0.00335929333232343, 0.00339051312766969, 0.00342170218937099, 0.00345318950712681, 0.00348474481143057, 0.00351639976724982, 0.00354810827411711, 0.00358000746928155, 0.00361192226409912, 0.00364405033178627, 0.00367630086839199, 0.00370861263945699, 0.00374108436517417, 0.00377348740585148, 0.00380621151998639, 0.00383895798586309, 0.00387189583852887, 0.00390471122227609, 0.00393780134618282, 0.00397101417183876, 0.00400429544970393, 0.00403779000043869, 0.00407127756625414, 0.0041048564016819, 0.00413862615823746, 0.00417252583429217, 0.00420649442821741, 0.004240607842803, 0.00427459878847003, 0.00430891057476401, 0.00434336811304092, 0.0043779625557363, 0.0044125490821898, 0.00444722780957818, 0.00448208954185247, 0.00451701926067472, 0.0045521636493504, 0.00458730757236481, 0.00462258979678154, 0.0046578785404563, 0.00469344295561314, 0.00472906045615673, 0.00476481532678008, 0.00480065401643515, 0.0048364931717515, 0.00487259216606617, 0.00490877451375127, 0.00494507933035493, 0.00498139904811978, 0.00501786405220628, 0.00505450461059809, 0.0050912220031023, 0.00512803765013814, 0.00516502233222127, 0.00520208245143294, 0.00523917376995087, 0.00527644064277411, 0.00531384442001581, 0.00535134039819241, 0.00538876745849848, 0.00542651489377022, 0.00546434661373496, 0.00550230080261827, 0.00554026989266276, 0.00557842943817377, 0.00561668910086155, 0.00565511640161276, 0.00569357443600893, 0.00573220709338784, 0.00577085604891181, 0.00580953527241945, 0.00584851996973157, 0.0058875810354948, 0.00592670263722539, 0.00596585543826222, 0.00600525224581361, 0.00604472542181611, 0.00608434388414025, 0.0061239548958838, 0.00616283435374498, 0.00620149821043015, 0.00624058954417706, 0.00627980334684253, 0.00631944462656975, 0.00635920790955424, 0.00639933766797185, 0.0064398949034512, 0.00648057460784912, 0.00652168178930879, 0.00656291143968701, 0.00660438509657979, 0.00664622476324439, 0.00668843183666468, 0.00673088245093822, 0.00677363900467753, 0.00681670056656003, 0.00685988459736109, 0.00690361810848117, 0.00694729061797261, 0.00699169607833028, 0.00703597953543067, 0.00708069046959281, 0.0071256454102695, 0.00717108929529786, 0.00721665564924479, 0.00726246600970626, 0.00730864237993956, 0.00735512468963861, 0.00740185147151351, 0.00744876125827432, 0.0074961599893868, 0.00754368025809526, 0.00759156700223684, 0.00763975968584418, 0.00768825737759471, 0.00773699954152107, 0.007785864174366, 0.00783521682024002, 0.00788487587124109, 0.00793477799743414, 0.00798498652875423, 0.00803525559604168, 0.0080860136076808, 0.00813707709312439, 0.00818838365375996, 0.0082400580868125, 0.00829197745770216, 0.00834401790052652, 0.00839666835963726, 0.00844925921410322, 0.00850246008485556, 0.00855559948831797, 0.00860922876745462, 0.00866310112178326, 0.00871721841394901, 0.00877188518643379, 0.00882649142295122, 0.00888158567249775, 0.0089369248598814, 0.00899256952106953, 0.00904833618551493, 0.00910465233027935, 0.0091610299423337, 0.00921777356415987, 0.00927469972521067, 0.00933217629790306, 0.00938989780843258, 0.00944761838763952, 0.00950582791119814, 0.0095643438398838, 0.00962310377508402, 0.00968216732144356, 0.00974135473370552, 0.00980096869170666, 0.00986095052212477, 0.0099211148917675, 0.00998164527118206, 0.0100424205884337, 0.01010337844491, 0.0101647647097707, 0.0102263940498233, 0.0102883912622929, 0.0103503875434399, 0.0104128737002611, 0.0104757249355316, 0.0105387596413493, 0.0106020998209715, 0.0106658078730106, 0.0107296984642744, 0.0107938321307302, 0.0108584556728601, 0.0109231388196349, 0.0109881898388267, 0.011053423397243, 0.0111191468313336, 0.0111850518733263, 0.0112513247877359, 0.0113178407773376, 0.0113845411688089, 0.0114516075700521, 0.0115189794450998, 0.0115866558626294, 0.0116545166820288, 0.0117228040471673, 0.0117911528795958, 0.0118599915876985, 0.0119290733709931, 0.0119984606280923, 0.0120680313557386, 0.0121379690244794, 0.0122081497684121, 0.0122786369174719, 0.0123496120795608, 0.0124204652383924, 0.0124918082728982, 0.0125634549185634, 0.0126354079693556, 0.0127076664939523, 0.0127801680937409, 0.0128529760986567, 0.0129259675741196, 0.0129994470626116, 0.0130730485543609, 0.0131470793858171, 0.0132211083546281, 0.0132956868037581, 0.0133703891187906, 0.0134456399828196, 0.0135210128501058, 0.0135965701192617, 0.0136725530028343, 0.0137487826868892, 0.0138253765180707, 0.0139020327478647, 0.0139792384579778, 0.0140564450994134, 0.0141341388225555, 0.0142121380195022, 0.0142904436215758, 0.0143688106909394, 0.0144476648420095, 0.0145268253982067, 0.0146061675623059, 0.0146858189254999, 0.0147657096385956, 0.014845909550786, 0.0149264736101031, 0.0150073450058699, 0.0150883980095387, 0.015169819816947, 0.0152514828369021, 0.015333391726017, 0.0154157290235162, 0.0154981259256601, 0.0155811347067356, 0.0156639590859413, 0.015747519209981, 0.0158310756087303, 0.0159150622785091, 0.0159993525594473, 0.0160838272422552, 0.0161687284708023, 0.0162538141012192, 0.0163392648100853, 0.0164247769862413, 0.0165108405053616, 0.0165969617664814, 0.0166835766285658, 0.0167703106999397, 0.0168575923889875, 0.0169448796659708, 0.017032528296113, 0.0171205438673496, 0.0172088667750359, 0.0172973740845919, 0.017386183142662, 0.0174752399325371, 0.0175646003335714, 0.017654325813055, 0.0177443586289883, 0.0178346373140812, 0.0179252196103334, 0.0180159844458103, 0.018106933683157, 0.0181984938681126, 0.0182902980595827, 0.0183820389211178, 0.0184743944555521, 0.0185669306665659, 0.0186597127467394, 0.0187529213726521, 0.0188463125377893, 0.0189398881047964, 0.0190338902175426, 0.0191283226013184, 0.0192227512598038, 0.0193177312612534, 0.0194126516580582, 0.0195081196725368, 0.0196038316935301, 0.0196999106556177, 0.0197961144149303, 0.0198926813900471, 0.0199895557016134, 0.0200866740196943, 0.0201840959489346, 0.0202817656099796, 0.0203798580914736, 0.0204778946936131, 0.020576598122716, 0.020675428211689, 0.0207745619118214, 0.0208738148212433, 0.0209736842662096, 0.0210735499858856, 0.0211739055812359, 0.0212745051831007, 0.0213752873241901, 0.0214764382690191, 0.0215778928250074, 0.0216796509921551, 0.0217816568911076, 0.0218839645385742, 0.0219863969832659, 0.0220893174409866, 0.0221926048398018, 0.0222958903759718, 0.022399727255106, 0.0225035659968853, 0.0226078927516937, 0.0227124001830816, 0.0228173974901438, 0.0229225158691406, 0.0230279415845871, 0.0231336709111929, 0.0232396461069584, 0.0233459863811731, 0.0234525110572577, 0.0235594641417265, 0.0236664153635502, 0.0237739775329828, 0.0238817241042852, 0.0239897761493921, 0.0240978263318539, 0.0242065489292145, 0.0243155173957348, 0.0244246069341898, 0.0245340634137392, 0.0246438235044479, 0.0247537717223167, 0.0248640198260546, 0.024974636733532, 0.0250855591148138, 0.025196785107255, 0.0253080744296312, 0.0254198517650366, 0.0255318116396666, 0.0256442613899708, 0.0257568936794996, 0.0258695874363184, 0.0259828921407461, 0.0260962545871735, 0.0262100491672754, 0.0263240858912468, 0.0264384280890226, 0.0265530180186033, 0.026667969301343, 0.0267831068485975, 0.0268984865397215, 0.0270142965018749, 0.0271301046013832, 0.0272466447204351, 0.0273631252348423, 0.0274800956249237, 0.0275970660150051, 0.0277146436274052, 0.027832405641675, 0.0279504749923944, 0.0280687864869833, 0.0281874071806669, 0.0283063314855099, 0.0284254979342222, 0.0285449121147394, 0.0286646913737059, 0.0287847723811865, 0.0289049781858921, 0.0290256142616272, 0.0291463695466518, 0.0292676761746407, 0.0293891653418541, 0.029510835185647, 0.0296329986304045, 0.0297552198171616, 0.0298779290169477, 0.0300007630139589, 0.0301240216940641, 0.0302474666386843, 0.0303712151944637, 0.0304953921586275, 0.0306196287274361, 0.0307442340999842, 0.0308690220117569, 0.0309943594038486, 0.0311197582632303, 0.0312456432729959, 0.0313715301454067, 0.0314980298280716, 0.031624648720026, 0.0317515134811401, 0.0318786837160587, 0.0320062190294266, 0.032133936882019, 0.032261960208416, 0.0323902927339077, 0.0325189270079136, 0.032647930085659, 0.0327771119773388, 0.0329065471887589, 0.0330362804234028, 0.0331663824617863, 0.0332967266440392, 0.0334273763000965, 0.0335582122206688, 0.0336894094944, 0.0338210389018059, 0.0339527316391468, 0.0340847820043564, 0.0342172086238861, 0.0343496948480606, 0.0344827249646187, 0.0346158780157566, 0.0347495265305042, 0.034883227199316, 0.0350173637270927, 0.0351515561342239, 0.0352864190936089, 0.0354211069643497, 0.035556398332119, 0.0356919355690479, 0.035827774554491, 0.0359638631343842, 0.036100011318922, 0.036236833781004, 0.0363736525177956, 0.0365109629929066, 0.0366483330726624, 0.0367861911654472, 0.0369242317974567, 0.0370626412332058, 0.0372012928128242, 0.0373402535915375, 0.0374795757234097, 0.0376189574599266, 0.0377588346600533, 0.0378988310694695, 0.0380392000079155, 0.0381798632442951, 0.0383208394050598, 0.0384620577096939, 0.0386035144329071, 0.0387452840805054, 0.0388873592019081, 0.0390298590064049, 0.0391724817454815, 0.0393155328929424, 0.0394586473703384, 0.0396021828055382, 0.0397459045052528, 0.0398900583386421, 0.0400343872606754, 0.0401792116463184, 0.0403240956366062, 0.0404692180454731, 0.0406148955225945, 0.0407605729997158, 0.0409067384898663, 0.0410530902445316, 0.041199803352356, 0.0413466393947601, 0.0414939671754837, 0.0416413545608521, 0.0417892895638943, 0.0419374108314514, 0.042085774242878, 0.0422345064580441, 0.0423834808170795, 0.0425327010452747, 0.0426821671426296, 0.0428320541977882, 0.0429820716381073, 0.0431325137615204, 0.043283075094223, 0.0434341281652451, 0.0435852371156216, 0.0437368452548981, 0.0438887514173985, 0.0440407767891884, 0.0441932342946529, 0.0443458743393421, 0.0444988794624805, 0.0446521304547787, 0.0448055639863014, 0.0449595525860786, 0.0451135970652103, 0.0452680699527264, 0.0454225987195969, 0.0455776825547218, 0.0457328855991364, 0.0458885803818703, 0.0460442155599594, 0.0462004579603672, 0.046356949955225, 0.0465134978294373, 0.0466704741120338, 0.0468277558684349, 0.0469853468239307, 0.0471430532634258, 0.0473012514412403, 0.0474596321582794, 0.0476183816790581, 0.0477773733437061, 0.0479365475475788, 0.0480960309505463, 0.0482559986412525, 0.0484160929918289, 0.0485765486955643, 0.0487372502684593, 0.0488982014358044, 0.0490595139563084, 0.049221009016037, 0.0493829324841499, 0.0495450422167778, 0.0497073940932751, 0.0498700477182865, 0.0500330738723278, 0.0501965284347534, 0.0503598526120186, 0.0505238547921181, 0.0506879165768623, 0.0508524067699909, 0.0510170198976994, 0.0511820614337921, 0.0513473451137543, 0.0515129901468754, 0.0516787655651569, 0.0518449656665325, 0.0520114079117775, 0.0521779768168926, 0.0523450933396816, 0.0525122657418251, 0.0526799336075783, 0.052847720682621, 0.0530159398913383, 0.0531842745840549, 0.0533530414104462, 0.0535220466554165, 0.0536913052201271, 0.053860992193222, 0.0540307313203812, 0.0542008988559246, 0.0543713793158531, 0.0545421540737152, 0.0547131821513176, 0.0548843294382095, 0.0550559610128403, 0.0552277863025665, 0.0553998500108719, 0.0555723384022713, 0.0557451955974102, 0.0559181161224842, 0.0560913980007172, 0.0562649928033352, 0.0564388893544674, 0.056613028049469, 0.0567874759435654, 0.056962288916111, 0.0571372210979462, 0.0573126412928104, 0.0574881248176098, 0.0576640404760838, 0.0578401349484921, 0.0580166541039944, 0.0581932999193668, 0.0583704337477684, 0.058547630906105, 0.0587253086268902, 0.0589031800627708, 0.0590812861919403, 0.0592598281800747, 0.0594385489821434, 0.0596175752580166, 0.0597968474030495, 0.0599764846265316, 0.0601563081145287, 0.0603364296257496, 0.0605168603360653, 0.0606977194547653, 0.0608786381781101, 0.0610600486397743, 0.0612485446035862, 0.0614421702921391, 0.0616365894675255, 0.0618312545120716, 0.0620265901088715, 0.0622219815850258, 0.0624180547893047, 0.0626144856214523, 0.0628113448619843, 0.0630086436867714, 0.0632062926888466, 0.0634043142199516, 0.0636029541492462, 0.0638018324971199, 0.0640011951327324, 0.0642009899020195, 0.0644012093544006, 0.0646017417311668, 0.064802810549736, 0.0650043115019798, 0.0652063116431236, 0.0654083043336868, 0.0656112805008888, 0.065814308822155, 0.0660179555416107, 0.0662219002842903, 0.0664263367652893, 0.0666310116648674, 0.06683649122715, 0.0670419037342072, 0.067248173058033, 0.0674546286463737, 0.0676615014672279, 0.0678688734769821, 0.0680766031146049, 0.0682848915457726, 0.0684934183955193, 0.0687025561928749, 0.0689120069146156, 0.0691218748688698, 0.0693321749567986, 0.0695428475737572, 0.0697540566325188, 0.0699655190110207, 0.0701777115464211, 0.070389911532402, 0.0706029534339905, 0.0708160027861595, 0.0710296705365181, 0.0712437480688095, 0.0714583843946457, 0.0716733336448669, 0.0718885734677315, 0.0721043720841408, 0.0723205357789993, 0.0725371316075325, 0.0727541446685791, 0.0729715973138809, 0.0731894075870514, 0.0734077021479607, 0.0736264437437057, 0.0738454088568687, 0.0740651190280914, 0.0742850601673126, 0.0745055079460144, 0.0747261345386505, 0.0749475508928299, 0.0751690939068794, 0.0753912329673767, 0.0756137520074844, 0.0758366957306862, 0.076059877872467, 0.0762838050723076, 0.0765079110860825, 0.076732449233532, 0.0769575238227844, 0.0771829038858414, 0.0774089023470879, 0.077635146677494, 0.0778618827462196, 0.0780889764428139, 0.0783165618777275, 0.0785445719957352, 0.0787728950381279, 0.079001821577549, 0.0792308822274208, 0.0794605985283852, 0.0796906277537346, 0.0799211487174034, 0.0801519080996513, 0.0803832188248634, 0.0806150138378143, 0.0808471888303757, 0.0810798406600952, 0.0813129246234894, 0.081546314060688, 0.0817801281809807, 0.082014374434948, 0.0822490453720093, 0.0824842602014542, 0.0827197209000587, 0.0829556807875633, 0.0831921249628067, 0.0834288150072098, 0.0836661085486412, 0.0839037075638771, 0.0841419845819473, 0.0843803212046623, 0.0846193358302116, 0.0848585218191147, 0.0850983262062073, 0.0853384286165237, 0.0855790227651596, 0.0858201161026955, 0.0860615000128746, 0.0863033756613731, 0.0865456238389015, 0.0867882370948792, 0.087031215429306, 0.087274856865406, 0.0875188782811165, 0.087763138115406, 0.0880080759525299, 0.088253065943718, 0.0884989202022552, 0.0887447670102119, 0.0889914631843567, 0.089238241314888, 0.0894856750965118, 0.0897332280874252, 0.0899815261363983, 0.0902300029993057, 0.0904790833592415, 0.0907284170389175, 0.0909782946109772, 0.0912286043167114, 0.0914792791008949, 0.0917303785681725, 0.0919819697737694, 0.0922337993979454, 0.0924861282110214, 0.0927389413118362, 0.0929921120405197, 0.0932459086179733, 0.0934998765587807, 0.0937542840838432, 0.0940092280507088, 0.0942644253373146, 0.0945204198360443, 0.0947762727737427, 0.0950330048799515, 0.0952899008989334, 0.0955473557114601, 0.0958052352070808, 0.0960634276270866, 0.0963221564888954, 0.0965812057256699, 0.0968407317996025, 0.0971007570624352, 0.0973610207438469, 0.097621776163578, 0.0978830084204674, 0.0981445536017418, 0.098406657576561, 0.098669059574604, 0.0989319533109665, 0.0991953313350677, 0.0994589477777481, 0.0997233018279076, 0.0999877825379372, 0.100252754986286, 0.100518018007278, 0.100784033536911, 0.101050086319447, 0.101316951215267, 0.101583883166313, 0.101851478219032, 0.102119490504265, 0.102387815713882, 0.102656446397305, 0.102925695478916, 0.103195182979107, 0.103465281426907, 0.1037358045578, 0.104006573557854, 0.104277826845646, 0.104549758136272, 0.104821749031544, 0.105094417929649, 0.105367258191109, 0.105640783905983, 0.105914480984211, 0.106188789010048, 0.106463342905045, 0.106738515198231, 0.107013992965221, 0.10728994756937, 0.10756628960371, 0.107843160629272, 0.10812022536993, 0.108397893607616, 0.108675926923752, 0.108954280614853, 0.109233170747757, 0.10951242595911, 0.109792239964008, 0.110072284936905, 0.110352829098701, 0.110633797943592, 0.110915020108223, 0.111197151243687, 0.11147915571928, 0.111761957406998, 0.112045004963875, 0.112328477203846, 0.112612389028072, 0.112896777689457, 0.113181285560131, 0.113466583192348, 0.113752327859402, 0.114038303494453, 0.114324703812599, 0.114611603319645, 0.114898800849915, 0.115186549723148, 0.115474671125412, 0.115763276815414, 0.116052187979221, 0.116341583430767, 0.116631284356117, 0.116921789944172, 0.117212161421776, 0.117503397166729, 0.117794871330261, 0.118086829781532, 0.118378989398479, 0.118671931326389, 0.118964865803719, 0.119258537888527, 0.119552403688431, 0.119846992194653, 0.120141886174679, 0.12043709307909, 0.120732843875885, 0.121028833091259, 0.121325440704823, 0.121622294187546, 0.121919766068459, 0.122217521071434, 0.12251578271389, 0.122814401984215, 0.123113393783569, 0.123413048684597, 0.123712778091431, 0.124013282358646, 0.124313876032829, 0.124615117907524, 0.124916672706604, 0.125218763947487, 0.125521063804626, 0.125823959708214, 0.126127228140831, 0.126430973410606, 0.126735165715218, 0.127039581537247, 0.127344503998756, 0.127649828791618, 0.127955600619316, 0.128261864185333, 0.128568306565285, 0.128875479102135, 0.129183024168015, 0.129490926861763, 0.129799202084541, 0.130108013749123, 0.130416974425316, 0.130726769566536, 0.131036505103111, 0.13134703040123, 0.131657868623734, 0.131969317793846, 0.132280766963959, 0.132593020796776, 0.132905498147011, 0.133218482136726, 0.133531838655472, 0.133845582604408, 0.134159728884697, 0.134474366903305, 0.134789407253265, 0.135105013847351, 0.135420724749565, 0.135737195611, 0.136053830385208, 0.136371031403542, 0.136688455939293, 0.137006625533104, 0.137324914336205, 0.13764388859272, 0.137962892651558, 0.138282716274261, 0.138602733612061, 0.138923287391663, 0.139244258403778, 0.139565542340279, 0.139887288212776, 0.140209555625916, 0.140532195568085, 0.140855178236961, 0.14117868244648, 0.141502574086189, 0.141826912760735, 0.142151549458504, 0.142476752400398, 0.142802253365517, 0.143128246068954, 0.143454849720001, 0.143781363964081, 0.144108757376671, 0.144436404109001, 0.144764512777328, 0.145092949271202, 0.145422056317329, 0.14575132727623, 0.146081164479256, 0.146411314606667, 0.14674186706543, 0.147072732448578, 0.147404342889786, 0.147736206650734, 0.14806841313839, 0.148401185870171, 0.14873431622982, 0.1490678191185, 0.149401858448982, 0.149736225605011, 0.150071129202843, 0.150406286120415, 0.150741964578629, 0.151077970862389, 0.151414647698402, 0.151751324534416, 0.152088865637779, 0.152426391839981, 0.152764767408371, 0.153103351593018, 0.153442338109016, 0.153781831264496, 0.154121622443199, 0.154461950063705, 0.154802650213242, 0.155143663287163, 0.155485302209854, 0.155827224254608, 0.156169638037682, 0.156512439250946, 0.156855762004852, 0.157199382781982, 0.15754346549511, 0.157887846231461, 0.15823295712471, 0.158578053116798, 0.15892393887043, 0.159270092844963, 0.159616723656654, 0.159963726997375, 0.160311251878738, 0.16065913438797, 0.161007210612297, 0.161355912685394, 0.161705061793327, 0.162054553627968, 0.162404552102089, 0.162754848599434, 0.163105741143227, 0.163456901907921, 0.163808673620224, 0.16416072845459, 0.164513364434242, 0.164866045117378, 0.165219500660896, 0.165573164820671, 0.165927365422249, 0.166281878948212, 0.166637003421783, 0.166992247104645, 0.167348355054855, 0.167704567313194, 0.168061152100563, 0.168418288230896, 0.168775856494904, 0.169133722782135, 0.169492155313492, 0.169850811362267, 0.17021007835865, 0.170569717884064, 0.170929923653603, 0.171290352940559, 0.17165133357048, 0.172012433409691, 0.172374352812767, 0.172736436128616, 0.17309907078743, 0.173462003469467, 0.173825487494469, 0.174189165234566, 0.174553632736206, 0.174918368458748, 0.175283327698708, 0.175648868083954, 0.176014930009842, 0.176381215453148, 0.176748067140579, 0.177115246653557, 0.177482932806015, 0.177850812673569, 0.178219377994537, 0.178588315844536, 0.178957417607307, 0.179327204823494, 0.179697528481483, 0.180067852139473, 0.180439040064812, 0.18081022799015, 0.181182324886322, 0.181554436683655, 0.181927278637886, 0.18230040371418, 0.182673782110214, 0.183047741651535, 0.183422163128853, 0.183796808123589, 0.184172093868256, 0.184547632932663, 0.184923753142357, 0.185300186276436, 0.185677066445351, 0.186054483056068, 0.1864323168993, 0.186810284852982, 0.187188982963562, 0.187567755579948, 0.187947303056717, 0.188326895236969, 0.188707441091537, 0.189087972044945, 0.189469248056412, 0.189850509166718, 0.190232500433922, 0.190614745020866, 0.190997585654259, 0.191380798816681, 0.191764384508133, 0.192148476839066, 0.192532911896706, 0.192917838692665, 0.193303138017654, 0.193688675761223, 0.1940748244524, 0.194461584091187, 0.194848597049713, 0.195235833525658, 0.195623874664307, 0.196011945605278, 0.196400657296181, 0.196789726614952, 0.197179242968559, 0.197568982839584, 0.197959661483765, 0.198350414633751, 0.198741495609283, 0.199133157730103, 0.19952504336834, 0.19991759955883, 0.200310409069061, 0.200703665614128, 0.201097503304482, 0.201491460204124, 0.201886028051376, 0.202280923724174, 0.202676370739937, 0.203072234988213, 0.203468516469002, 0.203865095973015, 0.204262256622314, 0.204659581184387, 0.205057710409164, 0.20545594394207, 0.205854684114456, 0.206253781914711, 0.206653565168381, 0.207053452730179, 0.20745413005352, 0.207854837179184, 0.208256125450134, 0.208657830953598, 0.209059953689575, 0.209462583065033, 0.209865525364876, 0.210268840193748, 0.210685774683952, 0.211116030812263, 0.211547136306763, 0.211978226900101, 0.21241007745266, 0.212842047214508, 0.213274493813515, 0.213707312941551, 0.214140877127647, 0.21457451581955, 0.215008556842804, 0.215443164110184, 0.21587797999382, 0.216313377022743, 0.216748982667923, 0.217185109853745, 0.217621713876724, 0.218058571219444, 0.218495905399323, 0.218933597207069, 0.219371780753136, 0.219810351729393, 0.220249146223068, 0.220688566565514, 0.221128329634666, 0.22156848013401, 0.222009122371674, 0.222449883818626, 0.222891360521317, 0.223332867026329, 0.223775327205658, 0.224217668175697, 0.22466079890728, 0.225104063749313, 0.22554786503315, 0.225991874933243, 0.226436540484428, 0.226881384849548, 0.227326840162277, 0.227772548794746, 0.228218927979469, 0.228665307164192, 0.229112416505814, 0.229559645056725, 0.230007484555244, 0.230455696582794, 0.230904266238213, 0.231353089213371, 0.231802761554718, 0.23225249350071, 0.232702702283859, 0.233153373003006, 0.233604267239571, 0.234055772423744, 0.234507516026497, 0.234959751367569, 0.235412374138832, 0.235865339636803, 0.236318796873093, 0.236772522330284, 0.237226709723473, 0.237681314349174, 0.238136440515518, 0.238591730594635, 0.239047557115555, 0.239503890275955, 0.239960536360741, 0.240417540073395, 0.240875020623207, 0.24133288860321, 0.241791069507599, 0.242249712347984, 0.2427087277174, 0.243168294429779, 0.243628233671188, 0.244088485836983, 0.244549289345741, 0.245010063052177, 0.245471715927124, 0.245933473110199, 0.246395736932755, 0.246858477592468, 0.247321575880051, 0.247784942388535, 0.248248904943466, 0.248713001608849, 0.249177947640419, 0.249642893671989, 0.250108450651169, 0.250574231147766, 0.251040637493134, 0.251507192850113, 0.251974523067474, 0.252441853284836, 0.25290983915329, 0.253378093242645, 0.253846824169159, 0.254316031932831, 0.254785448312759, 0.255255579948425, 0.255725771188736, 0.256196588277817, 0.256667643785477, 0.257139176130295, 0.257610976696014, 0.258083313703537, 0.258556187152863, 0.259029299020767, 0.259502738714218, 0.259976714849472, 0.260451078414917, 0.260925740003586, 0.261400878429413, 0.261876434087753, 0.262352615594864, 0.262828856706619, 0.263305723667145, 0.263782769441605, 0.264260351657867, 0.264738380908966, 0.265216648578644, 0.265695482492447, 0.266174733638763, 0.266654282808304, 0.267134189605713, 0.267614603042603, 0.268095433712006, 0.26857653260231, 0.26905819773674, 0.269540101289749, 0.270022600889206, 0.270505368709564, 0.270988672971725, 0.271472007036209, 0.271956145763397, 0.272440522909164, 0.272925317287445, 0.273410648107529, 0.273896157741547, 0.274382293224335, 0.27486863732338, 0.275355517864227, 0.275842756032944, 0.276330351829529, 0.276818215847015, 0.277306824922562, 0.277795672416687, 0.278284877538681, 0.278774470090866, 0.279264539480209, 0.279754996299744, 0.280245840549469, 0.280736953020096, 0.281228691339493, 0.281720817089081, 0.28221333026886, 0.28270611166954, 0.283199369907379, 0.283692985773087, 0.28418704867363, 0.284681469202042, 0.285176455974579, 0.285671800374985, 0.286167353391647, 0.286663502454758, 0.28715991973877, 0.287656933069229, 0.288154035806656, 0.288651674985886, 0.289149850606918, 0.289648532867432, 0.2901471555233, 0.29064667224884, 0.291146278381348, 0.29164645075798, 0.292146891355515, 0.292647749185562, 0.29314911365509, 0.29365086555481, 0.294152915477753, 0.294655591249466, 0.295158326625824, 0.295661777257919, 0.296165347099304, 0.296669483184814, 0.297174125909805, 0.29767906665802, 0.298184394836426, 0.298690140247345, 0.299196362495422, 0.299702793359756, 0.300209820270538, 0.300716906785965, 0.301224768161774, 0.301732987165451, 0.302241623401642, 0.302750527858734, 0.303259938955307, 0.303769648075104, 0.304279714822769, 0.304790258407593, 0.305301278829575, 0.30581271648407, 0.306324452161789, 0.306836664676666, 0.307349175214767, 0.307862132787704, 0.308375537395477, 0.308889210224152, 0.309403508901596, 0.309918284416199, 0.310433149337769, 0.310948669910431, 0.311464369297028, 0.31198063492775, 0.312497138977051, 0.31301411986351, 0.313531517982483, 0.314049512147903, 0.314567625522614, 0.315086334943771, 0.315605252981186, 0.316124707460403, 0.316644340753555, 0.317164659500122, 0.317685216665268, 0.318206518888474, 0.318727880716324, 0.319249749183655, 0.319771945476532, 0.32029464840889, 0.320817619562149, 0.321340978145599, 0.321864902973175, 0.322389185428619, 0.322913765907288, 0.323438823223114, 0.323964297771454, 0.32449021935463, 0.325016379356384, 0.32554292678833, 0.326070189476013, 0.326597690582275, 0.327125519514084, 0.327653855085373, 0.328182518482208, 0.328711539506912, 0.329241126775742, 0.329770743846893, 0.33030116558075, 0.330832004547119, 0.331362903118134, 0.331894636154175, 0.332426369190216, 0.33295875787735, 0.333491325378418, 0.334024459123611, 0.334557920694351, 0.335091799497604, 0.335626274347305, 0.336161017417908, 0.336696088314056, 0.337231636047363, 0.337767452001572, 0.338303804397583, 0.338840633630753, 0.339377641677856, 0.33991527557373, 0.340453147888184, 0.340991377830505, 0.341530323028564, 0.342069298028946, 0.342608869075775, 0.343148857355118, 0.343689143657684, 0.344229996204376, 0.344771206378937, 0.345312714576721, 0.345854729413986, 0.34639698266983, 0.346939831972122, 0.347482979297638, 0.348026543855667, 0.348570466041565, 0.349114865064621, 0.349659591913223, 0.350204795598984, 0.350750327110291, 0.3512963950634, 0.351842701435089, 0.352389544248581, 0.352936685085297, 0.353484272956848, 0.35403236746788, 0.354580730199814, 0.355129539966583, 0.355678707361221, 0.35622838139534, 0.356778293848038, 0.357328772544861, 0.357879728078842, 0.358430743217468, 0.358982414007187, 0.359534382820129, 0.360086768865585, 0.360639691352844, 0.361192762851715, 0.361746519804001, 0.362300664186478, 0.362854927778244, 0.36340993642807, 0.363964974880219, 0.364520609378815, 0.365076750516891, 0.365633100271225, 0.366190075874329, 0.366747260093689, 0.367304921150208, 0.367863088846207, 0.368421405553818, 0.368980318307877, 0.369539648294449, 0.370099276304245, 0.370659381151199, 0.371219873428345, 0.371780693531036, 0.372342050075531, 0.372903674840927, 0.373465687036514, 0.374028235673904, 0.374591141939163, 0.375154405832291, 0.375718057155609, 0.376282215118408, 0.376846700906754, 0.377411603927612, 0.377976685762405, 0.378542602062225, 0.379108726978302, 0.37967523932457, 0.380242198705673, 0.380809485912323, 0.381377279758453, 0.381945222616196, 0.382513791322708, 0.383082836866379, 0.383652061223984, 0.384221881628036, 0.384791821241379, 0.385362386703491, 0.385933399200439, 0.386504679918289, 0.387076437473297, 0.387648731470108, 0.388221144676208, 0.388794183731079, 0.389367371797562, 0.389941155910492, 0.390515446662903, 0.391089856624603, 0.391664803028107, 0.392240345478058, 0.392815887928009, 0.393392205238342, 0.393968671560287, 0.39454573392868, 0.395123094320297, 0.39570090174675, 0.396278977394104, 0.396857678890228, 0.397436708211899, 0.398016035556793, 0.398595780134201, 0.399176031351089, 0.399756610393524, 0.400337517261505, 0.400918841362, 0.401500821113586, 0.402082949876785, 0.402665615081787, 0.40324854850769, 0.403832048177719, 0.404415875673294, 0.405000030994415, 0.405584514141083, 0.406169861555099, 0.406755119562149, 0.407341003417969, 0.407927125692368, 0.408513784408569, 0.409101009368896, 0.409688234329224, 0.410276114940643, 0.410864442586899, 0.411453008651733, 0.412042140960693, 0.41263148188591, 0.41322135925293, 0.413811713457108, 0.414402157068253, 0.414993286132812, 0.415584892034531, 0.416176646947861, 0.416769057512283, 0.417361527681351, 0.417954623699188, 0.418548256158829, 0.419141948223114, 0.419736206531525, 0.420331031084061, 0.420926094055176, 0.421521633863449, 0.422117471694946, 0.422713786363602, 0.423310518264771, 0.423907607793808, 0.42450487613678, 0.425102978944778, 0.425701260566711, 0.426299899816513, 0.426899045705795, 0.427498519420624, 0.428098440170288, 0.428698778152466, 0.4292993247509, 0.429900646209717, 0.430502206087112, 0.43110403418541, 0.431706368923187, 0.432309180498123, 0.432912260293961, 0.433515816926956, 0.434119582176208, 0.434724181890488, 0.435328811407089, 0.435934066772461, 0.4365394115448, 0.437145411968231, 0.437751919031143, 0.438358515501022, 0.438965737819672, 0.439573228359222, 0.440181314945221, 0.440789699554443, 0.441398322582245, 0.442007482051849, 0.442617237567902, 0.443226993083954, 0.443837463855743, 0.444448202848434, 0.445059359073639, 0.445671081542969, 0.446282833814621, 0.44689530134201, 0.447508245706558, 0.44812136888504, 0.448734879493713, 0.449348986148834, 0.449963450431824, 0.450578272342682, 0.451193362474442, 0.451808869838715, 0.452424973249435, 0.453041464090347, 0.453658163547516, 0.454275459051132, 0.454893112182617, 0.455511122941971, 0.456129521131516, 0.456748276948929, 0.457367599010468, 0.457987278699875, 0.458607167005539, 0.459227710962296, 0.459848582744598, 0.46046981215477, 0.461091369390488, 0.461713284254074, 0.46233606338501, 0.462958723306656, 0.463582009077072, 0.464205712080002, 0.4648297727108, 0.465454280376434, 0.466079026460648, 0.466704308986664, 0.467330098152161, 0.467956095933914, 0.468582540750504, 0.469209462404251, 0.46983677148819, 0.470464468002319, 0.471092402935028, 0.471720904111862, 0.472349911928177, 0.472979098558426, 0.473608791828156, 0.474238961935043, 0.474869549274445, 0.47550043463707, 0.476150631904602, 0.476819843053818, 0.47748938202858, 0.478158980607986, 0.478828608989716, 0.479498475790024, 0.480168461799622, 0.480838507413864, 0.481508731842041, 0.482178956270218, 0.482849538326263, 0.483520179986954, 0.484190791845322, 0.484861642122269, 0.485532701015472, 0.486203759908676, 0.486874967813492, 0.487546235322952, 0.488217800855637, 0.488889455795288, 0.48956111073494, 0.490233063697815, 0.49090513586998, 0.491577327251434, 0.492249459028244, 0.492921859025955, 0.493594408035278, 0.494266986846924, 0.494939804077148, 0.495612621307373, 0.496285706758499, 0.496958792209625, 0.497632026672363, 0.498305469751358, 0.498979091644287, 0.499652683734894, 0.50032639503479, 0.501000285148621, 0.50167441368103, 0.502348601818085, 0.503022789955139, 0.503697276115417, 0.504371881484985, 0.505046427249908, 0.505721271038055, 0.506396114826202, 0.507071375846863, 0.507746458053589, 0.508421897888184, 0.509097278118134, 0.509772777557373, 0.510448575019836, 0.511124312877655, 0.511800348758698, 0.512476444244385, 0.513152599334717, 0.513828933238983, 0.514505386352539, 0.515182018280029, 0.515858829021454, 0.516535460948944, 0.517212569713593, 0.517889618873596, 0.518566846847534, 0.519244253635406, 0.519921779632568, 0.52059930562973, 0.521277129650116, 0.521954894065857, 0.522632956504822, 0.523311078548431, 0.523989319801331, 0.524667620658875, 0.525346219539642, 0.526024699211121, 0.526703655719757, 0.527382552623749, 0.528061509132385, 0.528740644454956, 0.529419958591461, 0.530099272727966, 0.530778884887695, 0.531458497047424, 0.532138347625732, 0.532818198204041, 0.533498287200928, 0.53417843580246, 0.534858703613281, 0.535539209842682, 0.536219716072083, 0.536900341510773, 0.537581205368042, 0.538262069225311, 0.538943111896515, 0.539624273777008, 0.540305733680725, 0.540987133979797, 0.541668593883514, 0.542350351810455, 0.543032169342041, 0.543714165687561, 0.544396162033081, 0.545078337192535, 0.545760810375214, 0.546443283557892, 0.547125816345215, 0.547808587551117, 0.548491418361664, 0.549174427986145, 0.549857378005981, 0.550540626049042, 0.551224052906036, 0.551907539367676, 0.55259108543396, 0.553274869918823, 0.553958773612976, 0.554642796516418, 0.555326759815216, 0.556011021137238, 0.556695520877838, 0.557380020618439, 0.558064520359039, 0.558749318122864, 0.559434354305267, 0.560119330883026, 0.560804426670074, 0.561489701271057, 0.562175214290619, 0.562860608100891, 0.563546359539032, 0.564232051372528, 0.564918041229248, 0.565604031085968, 0.566290199756622, 0.566976428031921, 0.5676628947258, 0.568349421024323, 0.569036185741425, 0.569722890853882, 0.570409834384918, 0.571096837520599, 0.57178407907486, 0.57247132062912, 0.573158860206604, 0.573846399784088, 0.574533998966217, 0.575221836566925, 0.575909912586212, 0.576598048210144, 0.577286124229431, 0.577974498271942, 0.578662991523743, 0.579351544380188, 0.580040276050568, 0.580729067325592, 0.581418097019196, 0.582107186317444, 0.582796454429626, 0.583485722541809, 0.584175288677216, 0.584864854812622, 0.585554599761963, 0.586244463920593, 0.586934447288513, 0.587624549865723, 0.588314771652222, 0.589005172252655, 0.589695692062378, 0.59038633108139, 0.591077089309692, 0.591767966747284, 0.59245902299881, 0.59315013885498, 0.593841373920441, 0.59453284740448, 0.595224380493164, 0.595916032791138, 0.596607744693756, 0.597299635410309, 0.597991704940796, 0.598683834075928, 0.599376082420349, 0.60006856918335, 0.600761115550995, 0.60145378112793, 0.602146565914154, 0.602839469909668, 0.603532493114471, 0.604225814342499, 0.604919016361237, 0.605612456798553, 0.606305956840515, 0.606999754905701, 0.607693612575531, 0.608387589454651, 0.609081506729126, 0.609775841236115, 0.610470175743103, 0.611164569854736, 0.611859083175659, 0.612553894519806, 0.613248705863953, 0.613943636417389, 0.61463874578476, 0.615334033966064, 0.616029322147369, 0.616724789142609, 0.617420315742493, 0.61811625957489, 0.618812024593353, 0.619507968425751, 0.620204150676727, 0.620900452136993, 0.621596872806549, 0.622293293476105, 0.62298995256424, 0.623686671257019, 0.624383568763733, 0.625080585479736, 0.625777721405029, 0.626474976539612, 0.627172350883484, 0.62786990404129, 0.628567576408386, 0.629265308380127, 0.629963219165802, 0.630661249160767, 0.631359398365021, 0.632057726383209, 0.632756114006042, 0.633454620838165, 0.634153246879578, 0.634852111339569, 0.635551035404205, 0.636250138282776, 0.636949181556702, 0.63764876127243, 0.63834810256958, 0.639047622680664, 0.639747262001038, 0.640447199344635, 0.641147196292877, 0.641847133636475, 0.642547369003296, 0.643247663974762, 0.643948078155518, 0.644648671150208, 0.645349383354187, 0.64605039358139, 0.646751224994659, 0.647452354431152, 0.648153483867645, 0.648854970932007, 0.649556398391724, 0.650258004665375, 0.650959730148315, 0.651661515235901, 0.652363538742065, 0.65306568145752, 0.653767883777618, 0.654470384120941, 0.655172884464264, 0.655875444412231, 0.656578242778778, 0.657281100749969, 0.65798407793045, 0.658687174320221, 0.659390449523926, 0.660093903541565, 0.660797417163849, 0.661501049995422, 0.66220486164093, 0.662908792495728, 0.66361278295517, 0.664316892623901, 0.665021181106567, 0.665725588798523, 0.666430175304413, 0.667134821414948, 0.667839527130127, 0.66854453086853, 0.669249713420868, 0.669954776763916, 0.670660138130188, 0.67136561870575, 0.672071099281311, 0.672776758670807, 0.673482596874237, 0.674188613891602, 0.674894630908966, 0.675600826740265, 0.676307201385498, 0.677013695240021, 0.677720189094543, 0.678426921367645, 0.679133713245392, 0.679840683937073, 0.680547773838043, 0.681254982948303, 0.681962311267853, 0.682669818401337, 0.68337744474411, 0.684085130691528, 0.684792995452881, 0.685501039028168, 0.686209201812744, 0.686917424201965, 0.687625765800476, 0.688334286212921, 0.689042925834656, 0.689751625061035, 0.690460503101349, 0.691169440746307, 0.691878616809845, 0.692587971687317, 0.693297266960144, 0.69400680065155, 0.694716393947601, 0.695426225662231, 0.696136176586151, 0.696846127510071, 0.697556436061859, 0.698266625404358, 0.698977053165436, 0.699687480926514, 0.70039826631546, 0.701109051704407, 0.701820015907288, 0.702531039714813, 0.703242182731628, 0.703953504562378, 0.704664885997772, 0.705376446247101, 0.706088244915009, 0.706799983978271, 0.707511901855469, 0.708223938941956, 0.708936214447021, 0.709648549556732, 0.710360944271088, 0.711073458194733, 0.711786329746246, 0.71249908208847, 0.713212072849274, 0.713925123214722, 0.714638352394104, 0.715351760387421, 0.716065168380737, 0.716778755187988, 0.717492580413818, 0.718206346035004, 0.718920350074768, 0.719634413719177, 0.720348834991455, 0.721063077449799, 0.721777558326721, 0.722492158412933, 0.723206996917725, 0.723921895027161, 0.724636793136597, 0.725351989269257, 0.726067245006561, 0.7267826795578, 0.727498173713684, 0.728213727474213, 0.72892951965332, 0.729645431041718, 0.730361461639404, 0.731077611446381, 0.731793940067291, 0.732510387897491, 0.733226835727692, 0.733943521976471, 0.734660446643829, 0.735377311706543, 0.736094355583191, 0.736811459064484, 0.737528860569, 0.738246202468872, 0.738963782787323, 0.739681422710419, 0.740399241447449, 0.741117179393768, 0.741835236549377, 0.742553412914276, 0.743271827697754, 0.743990242481232, 0.744708776473999, 0.745427489280701, 0.746146380901337, 0.746865332126617, 0.747584402561188, 0.748303592205048, 0.749023020267487, 0.749742448329926, 0.750462055206299, 0.751181840896606, 0.751901626586914, 0.752621650695801, 0.753341794013977, 0.754061937332153, 0.754782438278198, 0.755502820014954, 0.756223440170288, 0.756944060325623, 0.75766509771347, 0.758386015892029, 0.759107232093811, 0.759828388690948, 0.76054984331131, 0.761271476745605, 0.761992931365967, 0.762714684009552, 0.763436675071716, 0.764158725738525, 0.764880836009979, 0.765603125095367, 0.76632559299469, 0.767048120498657, 0.767770826816559, 0.76849353313446, 0.769216477870941, 0.769939541816711, 0.770662665367126, 0.771386027336121, 0.772109508514404, 0.772832930088043, 0.773556649684906, 0.774280488491058, 0.775004386901855, 0.775728523731232, 0.776452720165253, 0.777176916599274, 0.777901470661163, 0.778625905513763, 0.779350697994232, 0.780075550079346, 0.780800461769104, 0.781525671482086, 0.782250881195068, 0.782976150512695, 0.783701598644257, 0.784427285194397, 0.785153031349182, 0.785878896713257, 0.786604762077332, 0.787330985069275, 0.788057148456573, 0.788783550262451, 0.789509952068329, 0.790236592292786, 0.790963411331177, 0.791690289974213, 0.792417168617249, 0.793144404888153, 0.793871641159058, 0.794598937034607, 0.795326471328735, 0.796054184436798, 0.796781957149506, 0.797509789466858, 0.798237860202789, 0.798966109752655, 0.799694359302521, 0.800422728061676, 0.801151156425476, 0.80188000202179, 0.802608728408813, 0.803337574005127, 0.804066598415375, 0.804795801639557, 0.805525124073029, 0.806254506111145, 0.806984007358551, 0.807713747024536, 0.808443486690521, 0.809173464775085, 0.809903502464294, 0.810633718967438, 0.811363995075226, 0.812094509601593, 0.81282502412796, 0.813555836677551, 0.814286708831787, 0.815017580986023, 0.815748691558838, 0.816479921340942, 0.817211329936981, 0.817942678928375, 0.818674325942993, 0.819406092166901, 0.820137858390808, 0.82086980342865, 0.821602046489716, 0.822334289550781, 0.823066532611847, 0.823799014091492, 0.824531614780426, 0.825264453887939, 0.825997233390808, 0.826735198497772, 0.827477931976318, 0.828220367431641, 0.828962326049805, 0.829703986644745, 0.830445230007172, 0.831186234951019, 0.831926941871643, 0.832667231559753, 0.83340710401535, 0.834146857261658, 0.834886074066162, 0.835624992847443, 0.836363613605499, 0.837101936340332, 0.837839901447296, 0.838577449321747, 0.839314639568329, 0.840051651000977, 0.840788185596466, 0.841524422168732, 0.842260241508484, 0.842995941638947, 0.843731105327606, 0.844465970993042, 0.845200479030609, 0.845934808254242, 0.846668601036072, 0.847402095794678, 0.84813529253006, 0.848868250846863, 0.849600672721863, 0.850332856178284, 0.851064622402191, 0.851796269416809, 0.852527320384979, 0.853258192539215, 0.853988587856293, 0.854718804359436, 0.855448603630066, 0.856177985668182, 0.856907188892365, 0.857635974884033, 0.858364403247833, 0.859092473983765, 0.859820246696472, 0.860547721385956, 0.861274778842926, 0.862001538276672, 0.86272794008255, 0.863453984260559, 0.864179790019989, 0.864905118942261, 0.865630149841309, 0.866355001926422, 0.867079317569733, 0.867803275585175, 0.868526995182037, 0.869250416755676, 0.869973480701447, 0.870696127414703, 0.871418416500092, 0.872140407562256, 0.872862160205841, 0.873583436012268, 0.874304413795471, 0.87502509355545, 0.875745415687561, 0.876465380191803, 0.877185046672821, 0.877904295921326, 0.878623247146606, 0.879341900348663, 0.880060195922852, 0.880778074264526, 0.881495714187622, 0.882212996482849, 0.882929921150208, 0.883646547794342, 0.884362876415253, 0.885078608989716, 0.885794222354889, 0.886509478092194, 0.887224435806274, 0.887938857078552, 0.888653099536896, 0.889366984367371, 0.890080571174622, 0.890793740749359, 0.891506552696228, 0.892219066619873, 0.892931282520294, 0.893643140792847, 0.894354641437531, 0.895065724849701, 0.895776629447937, 0.89648711681366, 0.897197246551514, 0.897907018661499, 0.89861661195755, 0.899325668811798, 0.900034487247467, 0.900742888450623, 0.901451051235199, 0.902158856391907, 0.902866244316101, 0.903573334217072, 0.904280126094818, 0.904986560344696, 0.905692636966705, 0.906398296356201, 0.907103776931763, 0.907808840274811, 0.90851354598999, 0.909217834472656, 0.909922003746033, 0.910625755786896, 0.911329030990601, 0.912032127380371, 0.912734866142273, 0.913437187671661, 0.914139211177826, 0.914840817451477, 0.915542244911194, 0.916243255138397, 0.916943848133087, 0.917644202709198, 0.91834419965744, 0.919043779373169, 0.919743061065674, 0.9204421043396, 0.921140789985657, 0.9218390583992, 0.922536909580231, 0.923234581947327, 0.923931896686554, 0.924628794193268, 0.925325334072113, 0.926021575927734, 0.926717638969421, 0.927413165569305, 0.928108394145966, 0.928803265094757, 0.929497897624969, 0.930192112922668, 0.930885910987854, 0.93157947063446, 0.932272732257843, 0.932965576648712, 0.933658123016357, 0.934350252151489, 0.935042202472687, 0.935733675956726, 0.936424791812897, 0.937115609645844, 0.937806189060211, 0.938496351242065, 0.939186155796051, 0.939875602722168, 0.940564811229706, 0.941253542900085, 0.941942036151886, 0.942630112171173, 0.943318068981171, 0.94400542974472, 0.944692492485046, 0.945379257202148, 0.946065723896027, 0.946751832962036, 0.947437524795532, 0.948122978210449, 0.948808133602142, 0.949492871761322, 0.950177133083344, 0.950861215591431, 0.951545000076294, 0.952228367328644, 0.952911376953125, 0.953594088554382, 0.954276502132416, 0.954958438873291, 0.955640137195587, 0.956321537494659, 0.957002580165863, 0.957683205604553, 0.95836353302002, 0.959043502807617, 0.959723114967346, 0.960402488708496, 0.961081504821777, 0.961760103702545, 0.962438404560089, 0.963116407394409, 0.963794052600861, 0.964471280574799, 0.965148210525513, 0.965824842453003, 0.966500997543335, 0.967177033424377, 0.967852532863617, 0.968527972698212, 0.969202876091003, 0.969877243041992, 0.970551550388336, 0.971225440502167, 0.971899032592773, 0.972572207450867, 0.973245143890381, 0.973917722702026, 0.974589884281158, 0.975261747837067, 0.975933194160461, 0.976604402065277, 0.977275311946869, 0.977945864200592, 0.978615939617157, 0.979285836219788, 0.979955315589905, 0.980624437332153, 0.981293201446533, 0.981961727142334, 0.982629835605621, 0.983297646045685, 0.98396509885788, 0.984632253646851, 0.985298991203308, 0.985965430736542, 0.986631453037262, 0.987297296524048, 0.987962782382965, 0.988627791404724, 0.989292562007904, 0.98995703458786, 0.990621149539948, 0.991284728050232, 0.991948127746582, 0.992611289024353, 0.993273973464966, 0.993936240673065, 0.994598269462585, 0.995260059833527, 0.99592137336731, 0.996582388877869, 0.997243046760559, 0.99790346622467, 0.998563468456268, 0.999223113059998, 0.999882400035858, 1.00054144859314, 1.00120007991791, 1.0018584728241, 1.00251638889313, 1.00317406654358, 1.00383126735687, 1.00448822975159, 1.00514483451843, 1.0058012008667, 1.00645709037781, 1.00711262226105, 1.00776791572571, 1.0084228515625, 1.00907742977142, 1.00973165035248, 1.01038563251495, 1.01103913784027, 1.01169240474701, 1.01234531402588, 1.01299774646759, 1.01365005970001, 1.01430189609528, 1.01495337486267, 1.01560461521149, 1.01625549793243, 1.01690590381622, 1.01755619049072, 1.01820600032806, 1.01885545253754, 1.01950466632843, 1.02015352249146, 1.02080202102661, 1.0214501619339, 1.02209794521332, 1.02274537086487, 1.02339255809784, 1.02403926849365, 1.02468574047089, 1.02533185482025, 1.02597773075104, 1.02662312984467, 1.02726817131042, 1.0279129743576, 1.02855730056763, 1.02920150756836, 1.02984511852264, 1.03048849105835, 1.03113162517548, 1.03177440166473, 1.03241670131683, 1.03305876255035, 1.03370046615601, 1.03434181213379, 1.03498291969299, 1.03562355041504, 1.0362640619278, 1.0369039773941, 1.03754365444183, 1.03818297386169, 1.03882205486298, 1.03946053981781, 1.04009890556335, 1.04073679447174, 1.04137456417084, 1.04201185703278, 1.04264879226685, 1.04328548908234, 1.04392170906067, 1.04455757141113, 1.04519331455231, 1.04582846164703, 1.04646348953247, 1.04709815979004, 1.04773223400116, 1.04836630821228, 1.04899990558624, 1.04963302612305, 1.05026602745056, 1.05089843273163, 1.0515308380127, 1.0521627664566, 1.05279421806335, 1.05342531204224, 1.05405616760254, 1.05468678474426, 1.05531692504883, 1.05594682693481, 1.05657625198364, 1.05720543861389, 1.05783426761627, 1.05846273899078, 1.05909097194672, 1.05971884727478, 1.06034624576569, 1.06097340583801, 1.06160032749176, 1.06222665309906, 1.06285274028778, 1.06347846984863, 1.06410396099091, 1.0647292137146, 1.06535375118256, 1.06597828865051, 1.0666024684906, 1.06722617149353, 1.06784951686859, 1.06847262382507, 1.06909537315369, 1.06971776485443, 1.07033979892731, 1.07096147537231, 1.07158291339874, 1.0722039937973, 1.0728245973587, 1.07344508171082, 1.07406497001648, 1.07468473911285, 1.07530403137207, 1.075923204422, 1.0765415430069, 1.0771598815918, 1.07777810096741, 1.07839560508728, 1.07901298999786, 1.07962989807129, 1.08024656772614, 1.08086287975311, 1.08147883415222, 1.08209443092346, 1.08270978927612, 1.08332479000092, 1.08393919467926, 1.08455348014832, 1.08516752719879, 1.08578109741211, 1.08639442920685, 1.08700716495514, 1.08761966228485, 1.08823204040527, 1.08884394168854, 1.08945548534393, 1.09006667137146, 1.09067761898041, 1.09128820896149, 1.0918984413147, 1.09250819683075, 1.09311759471893, 1.09372675418854, 1.09433567523956, 1.09494423866272, 1.09555232524872, 1.09616029262543, 1.09676778316498, 1.09737479686737, 1.09798157215118, 1.09858810901642, 1.09919428825378, 1.09980010986328, 1.10040557384491, 1.10101056098938, 1.10161530971527, 1.10221970081329, 1.10282397270203, 1.10342764854431, 1.10403120517731, 1.10463428497314, 1.10523688793182, 1.10583925247192, 1.10644137859344, 1.10704302787781, 1.10764455795288, 1.1082456111908, 1.10884618759155, 1.10944664478302, 1.11004674434662, 1.11064636707306, 1.11124563217163, 1.11184453964233, 1.11244332790375, 1.113041639328, 1.11363971233368, 1.11423742771149, 1.11483478546143, 1.1154317855835, 1.1160284280777, 1.11662471294403, 1.1172206401825, 1.11781632900238, 1.1184116601944, 1.11900651454926, 1.11960101127625, 1.12019538879395, 1.1207891702652, 1.12138295173645, 1.12197625637054, 1.12256896495819, 1.12316155433655, 1.12375378608704, 1.12434577941895, 1.12493741512299, 1.12552857398987, 1.12611949443817, 1.12671005725861, 1.12730026245117, 1.12788999080658, 1.1284795999527, 1.12906873226166, 1.12965762615204, 1.13024616241455, 1.13083434104919, 1.13142216205597, 1.13200962543488, 1.13259673118591, 1.13318359851837, 1.13377010822296, 1.13435614109039, 1.13494193553925, 1.13552749156952, 1.13611268997192, 1.13669741153717, 1.13728189468384, 1.13786602020264, 1.13844978809357, 1.13903319835663, 1.13961613178253, 1.14019894599915, 1.14078140258789, 1.14136350154877, 1.14194524288177, 1.1425267457962, 1.14310765266418, 1.14368844032288, 1.14426863193512, 1.14484894275665, 1.14542853832245, 1.14600789546967, 1.14658689498901, 1.14716565608978, 1.14774394035339, 1.14832198619843, 1.14889967441559, 1.14947712421417, 1.15005385875702, 1.15063059329987, 1.15120697021484, 1.15178287029266, 1.1523585319519, 1.15293383598328, 1.15350878238678, 1.15408337116241, 1.15465772151947, 1.15523159503937, 1.15578639507294, 1.15632152557373, 1.15685594081879, 1.15738964080811, 1.15792274475098, 1.15845513343811, 1.15898668766022, 1.15951776504517, 1.16004800796509, 1.16057753562927, 1.16110634803772, 1.16163468360901, 1.16216206550598, 1.16268885135651, 1.16321516036987, 1.16374027729034, 1.16426515579224, 1.1647891998291, 1.16531240940094, 1.16583514213562, 1.16635704040527, 1.16687834262848, 1.16739881038666, 1.16791880130768, 1.16843783855438, 1.16895639896393, 1.16947400569916, 1.16999125480652, 1.17050755023956, 1.17102313041687, 1.17153823375702, 1.17205250263214, 1.17256605625153, 1.17307901382446, 1.17359113693237, 1.17410278320312, 1.17461359500885, 1.17512369155884, 1.17563307285309, 1.17614209651947, 1.17665004730225, 1.17715740203857, 1.17766392230988, 1.17816996574402, 1.17867517471313, 1.17917966842651, 1.17968380451202, 1.18018686771393, 1.18068933486938, 1.18119120597839, 1.18169224262238, 1.1821928024292, 1.18269240856171, 1.18319153785706, 1.18368983268738, 1.18418753147125, 1.1846843957901, 1.18518054485321, 1.18567621707916, 1.18617105484009, 1.18666517734528, 1.18715882301331, 1.18765151500702, 1.188143491745, 1.18863499164581, 1.1891256570816, 1.18961560726166, 1.19010508060455, 1.19059360027313, 1.19108164310455, 1.19156885147095, 1.19205522537231, 1.19254112243652, 1.19302618503571, 1.19351065158844, 1.19399440288544, 1.19447755813599, 1.19495987892151, 1.19544160366058, 1.19592249393463, 1.19640290737152, 1.19688236713409, 1.19736135005951, 1.1978394985199, 1.19831705093384, 1.19879388809204, 1.19927000999451, 1.19974541664124, 1.20022022724152, 1.20069408416748, 1.20116758346558, 1.20164012908936, 1.20211219787598, 1.20258331298828, 1.20305395126343, 1.20352399349213, 1.20399308204651, 1.20446145534515, 1.20492935180664, 1.2053964138031, 1.20586287975311, 1.2063285112381, 1.20679342746735, 1.20725786685944, 1.2077214717865, 1.20818436145782, 1.2086466550827, 1.20910811424255, 1.20956909656525, 1.21002912521362, 1.21048855781555, 1.21094739437103, 1.21140539646149, 1.2118626832962, 1.21231961250305, 1.21277546882629, 1.21323072910309, 1.21368551254272, 1.21413934230804, 1.21459257602692, 1.21504509449005, 1.21549689769745, 1.2159481048584, 1.21639847755432, 1.21684813499451, 1.21729719638824, 1.21774554252625, 1.2181932926178, 1.21864032745361, 1.2190865278244, 1.21953201293945, 1.21997690200806, 1.22042107582092, 1.22086465358734, 1.22130739688873, 1.22174954414368, 1.22219097614288, 1.22263169288635, 1.22307169437408, 1.22351086139679, 1.22394967079163, 1.22438764572144, 1.22482478618622, 1.22526144981384, 1.22569727897644, 1.2261323928833, 1.22656691074371, 1.22700071334839, 1.22743380069733, 1.22786617279053, 1.22829782962799, 1.22872889041901, 1.22915923595428, 1.22958874702454, 1.23001778125763, 1.23044586181641, 1.23087334632874, 1.23130023479462, 1.23172640800476, 1.23215186595917, 1.23257648944855, 1.23300063610077, 1.23342394828796, 1.23384666442871, 1.23426854610443, 1.23468995094299, 1.23511052131653, 1.23553049564362, 1.23594951629639, 1.23636794090271, 1.23678600788116, 1.23720300197601, 1.23761940002441, 1.23803520202637, 1.23845028877258, 1.23886454105377, 1.2392783164978, 1.23969113826752, 1.24010348320007, 1.2405149936676, 1.24092590808868, 1.24133598804474, 1.24174559116364, 1.24215424060822, 1.24256229400635, 1.24296975135803, 1.24337637424469, 1.24378252029419, 1.24418783187866, 1.2445924282074, 1.2449963092804, 1.24539959430695, 1.24580216407776, 1.24620401859283, 1.24660515785217, 1.24700570106506, 1.24740529060364, 1.24780440330505, 1.24820280075073, 1.24860060214996, 1.24899744987488, 1.24939370155334, 1.24978935718536, 1.25018417835236, 1.2505784034729, 1.25097191333771, 1.25136470794678, 1.2517569065094, 1.25214815139771, 1.25253915786743, 1.25292909145355, 1.25331854820251, 1.25370693206787, 1.25409495830536, 1.25448226928711, 1.25486898422241, 1.2552547454834, 1.25564002990723, 1.25602447986603, 1.25640833377838, 1.25679135322571, 1.2571736574173, 1.25755548477173, 1.25793647766113, 1.2583167552948, 1.25869655609131, 1.2590754032135, 1.25945365428925, 1.25983130931854, 1.26020789146423, 1.26058411598206, 1.26095962524414, 1.26133453845978, 1.2617084980011, 1.26208198070526, 1.26245450973511, 1.2628265619278, 1.26319789886475, 1.26356840133667, 1.26393842697144, 1.26430749893188, 1.26467609405518, 1.26504397392273, 1.26541113853455, 1.26577758789062, 1.26614332199097, 1.26650822162628, 1.26687276363373, 1.26723635196686, 1.26759934425354, 1.26796162128448, 1.26832330226898, 1.26868414878845, 1.26904439926147, 1.26940369606018, 1.26976251602173, 1.27012073993683, 1.27047801017761, 1.27083480358124, 1.27119076251984, 1.2715460062027, 1.27190089225769, 1.27225494384766, 1.27260792255402, 1.27296054363251, 1.27331233024597, 1.27366375923157, 1.27401411533356, 1.27436399459839, 1.2747129201889, 1.27506148815155, 1.27540898323059, 1.27575600147247, 1.27610230445862, 1.27644801139832, 1.27679288387299, 1.27713716030121, 1.27748048305511, 1.27782356739044, 1.27816569805145, 1.27850699424744, 1.27884781360626, 1.27918791770935, 1.27952742576599, 1.27986598014832, 1.28020405769348, 1.28054118156433, 1.28087794780731, 1.28121364116669, 1.2815488576889, 1.28188335895538, 1.28221714496613, 1.28255033493042, 1.28288269042969, 1.2832145690918, 1.28354561328888, 1.28387606143951, 1.28420543670654, 1.2845344543457, 1.28486275672913, 1.2851904630661, 1.28551721572876, 1.28584349155426, 1.28616893291473, 1.28649377822876, 1.28681778907776, 1.28714120388031, 1.28746390342712, 1.28778576850891, 1.28810715675354, 1.28842794895172, 1.28874790668488, 1.289067029953, 1.28938555717468, 1.28970324993134, 1.29002046585083, 1.2903368473053, 1.2906528711319, 1.29096782207489, 1.29128229618073, 1.29159593582153, 1.29190897941589, 1.29222118854523, 1.29253280162811, 1.29284369945526, 1.29315388202667, 1.29346346855164, 1.29377222061157, 1.29408049583435, 1.29438781738281, 1.29469466209412, 1.2950005531311, 1.29530608654022, 1.29561066627502, 1.29591464996338, 1.296217918396, 1.29652047157288, 1.29682230949402, 1.29712355136871, 1.29742395877838, 1.2977237701416, 1.29802286624908, 1.29832136631012, 1.29861903190613, 1.2989159822464, 1.29921245574951, 1.2995080947876, 1.29980301856995, 1.30009734630585, 1.30039083957672, 1.30068361759186, 1.30097579956055, 1.3012672662735, 1.30155801773071, 1.30184805393219, 1.30213749408722, 1.30242621898651, 1.30271434783936, 1.30300152301788, 1.30328810214996, 1.3035740852356, 1.30385935306549, 1.30414378643036, 1.30442774295807, 1.30471074581146, 1.3049932718277, 1.30527496337891, 1.30555605888367, 1.30583643913269, 1.30611610412598, 1.30639505386353, 1.30667340755463, 1.30695080757141, 1.30722773075104, 1.30750405788422, 1.30777955055237, 1.30805420875549, 1.30832839012146, 1.30860185623169, 1.30887460708618, 1.30914664268494, 1.30941784381866, 1.30968856811523, 1.30995845794678, 1.31022775173187, 1.31049633026123, 1.31076419353485, 1.31103146076202, 1.31129789352417, 1.31156361103058, 1.31182885169983, 1.31209325790405, 1.31235694885254, 1.31261992454529, 1.3128821849823, 1.31314396858215, 1.31340479850769, 1.31366491317749, 1.31392455101013, 1.31418335437775, 1.31444156169891, 1.31469893455505, 1.31495571136475, 1.31521189212799, 1.31546711921692, 1.31572186946869, 1.31597578525543, 1.31622910499573, 1.31648170948029, 1.31673359870911, 1.31698489189148, 1.31723535060883, 1.31748521327972, 1.3177342414856, 1.31798255443573, 1.31823039054871, 1.31847751140594, 1.31872391700745, 1.31896948814392, 1.31921434402466, 1.31945872306824, 1.31970238685608, 1.3199450969696, 1.32018744945526, 1.3204288482666, 1.32066965103149, 1.32090973854065, 1.32114911079407, 1.32138800621033, 1.32162582874298, 1.32186317443848, 1.32209992408752, 1.32233583927155, 1.32257103919983, 1.32280564308167, 1.32303929328918, 1.32327270507812, 1.32350504398346, 1.32373690605164, 1.32396793365479, 1.32419836521149, 1.32442796230316, 1.32465696334839, 1.32488524913788, 1.32511281967163, 1.32533991336823, 1.3255660533905, 1.32579159736633, 1.32601642608643, 1.32624053955078, 1.32646405696869, 1.32668673992157, 1.326908826828, 1.32713007926941, 1.32735085487366, 1.32757067680359, 1.32778990268707, 1.32800853252411, 1.32822644710541, 1.32844364643097, 1.32866013050079, 1.32887589931488, 1.32909107208252, 1.32930552959442, 1.32951927185059, 1.32973229885101, 1.32994449138641, 1.33015620708466, 1.33036708831787, 1.33057737350464, 1.33078706264496, 1.33099579811096, 1.33120405673981, 1.33141160011292, 1.331618309021, 1.33182442188263, 1.33202981948853, 1.33223450183868, 1.3324385881424, 1.33264172077179, 1.33284449577332, 1.33304631710052, 1.333247423172, 1.33344805240631, 1.33364796638489, 1.33384716510773, 1.33404552936554, 1.33424317836761, 1.33444035053253, 1.33463656902313, 1.33483242988586, 1.33502733707428, 1.33522152900696, 1.33541524410248, 1.33560812473297, 1.33580029010773, 1.33599185943604, 1.33618259429932, 1.33637273311615, 1.33656227588654, 1.33673632144928, 1.33689451217651, 1.3370521068573, 1.33720886707306, 1.33736503124237, 1.33752012252808, 1.33767449855804, 1.33782815933228, 1.33798110485077, 1.33813333511353, 1.33828449249268, 1.33843529224396, 1.33858489990234, 1.33873391151428, 1.33888208866119, 1.33902966976166, 1.33917629718781, 1.33932209014893, 1.33946716785431, 1.33961141109467, 1.33975505828857, 1.33989775180817, 1.34003973007202, 1.34018087387085, 1.34032130241394, 1.340460896492, 1.34059989452362, 1.34073805809021, 1.34087526798248, 1.34101164340973, 1.34114742279053, 1.3412823677063, 1.34141659736633, 1.34154999256134, 1.34168255329132, 1.34181439876556, 1.34194540977478, 1.34207582473755, 1.34220504760742, 1.34233391284943, 1.34246182441711, 1.34258890151978, 1.3427152633667, 1.34284090995789, 1.34296584129333, 1.34308969974518, 1.34321308135986, 1.34333562850952, 1.34345722198486, 1.34357810020447, 1.34369826316833, 1.34381747245789, 1.34393608570099, 1.34405398368835, 1.34417104721069, 1.34428715705872, 1.34440267086029, 1.34451723098755, 1.34463131427765, 1.34474444389343, 1.3448566198349, 1.34496819972992, 1.34507894515991, 1.34518897533417, 1.34529805183411, 1.34540665149689, 1.34551417827606, 1.34562122821808, 1.3457270860672, 1.34583258628845, 1.34593713283539, 1.3460408449173, 1.34614372253418, 1.34624588489532, 1.34634745121002, 1.3464480638504, 1.34654784202576, 1.34664690494537, 1.34674525260925, 1.34684264659882, 1.34693956375122, 1.34703552722931, 1.34713053703308, 1.34722495079041, 1.34731864929199, 1.34741151332855, 1.34750354290009, 1.34759473800659, 1.34768521785736, 1.34777498245239, 1.3478639125824, 1.34795212745667, 1.34803950786591, 1.34812605381012, 1.3482118844986, 1.34829688072205, 1.34838116168976, 1.34846460819244, 1.3485472202301, 1.34862923622131, 1.3487104177475, 1.34879064559937, 1.34887027740479, 1.34894907474518, 1.34902715682983, 1.34910440444946, 1.34918081760406, 1.34925639629364, 1.34933125972748, 1.34940540790558, 1.34947884082794, 1.34955132007599, 1.3496230840683, 1.34969425201416, 1.34976422786713, 1.34983384609222, 1.34990239143372, 1.34997034072876, 1.35003745555878, 1.35010373592377, 1.35016918182373, 1.35023403167725, 1.35029792785645, 1.35036110877991, 1.35042357444763, 1.35048508644104, 1.35054612159729, 1.35060608386993, 1.35066533088684, 1.35072386264801, 1.35078167915344, 1.35083854198456, 1.35089480876923, 1.35095012187958, 1.35100495815277, 1.35105860233307, 1.35111165046692, 1.35116398334503, 1.35121536254883, 1.35126626491547, 1.3513160943985, 1.35136520862579, 1.35141348838806, 1.35146129131317, 1.35150802135468, 1.35155391693115, 1.35159933567047, 1.35164368152618, 1.35168743133545, 1.35173046588898, 1.35177254676819, 1.35181379318237, 1.35185432434082, 1.35189425945282, 1.3519332408905, 1.35197138786316, 1.35200905799866, 1.35204565525055, 1.35208141803741, 1.35211658477783, 1.35215091705322, 1.35218441486359, 1.3522173166275, 1.3522492647171, 1.35228049755096, 1.3523108959198, 1.35234045982361, 1.35236942768097, 1.35239744186401, 1.35242486000061, 1.35245132446289, 1.35247719287872, 1.35250198841095, 1.35252630710602, 1.35254967212677, 1.35257232189178, 1.35259413719177, 1.35261535644531, 1.35263550281525, 1.35265517234802, 1.35267388820648, 1.35269176959991, 1.3527090549469, 1.35272526741028, 1.3527410030365, 1.3527557849884, 1.35276985168457, 1.35278308391571, 1.35279560089111, 1.35280740261078, 1.35281825065613, 1.35282850265503, 1.35283780097961, 1.35284650325775, 1.35285413265228, 1.35286128520966, 1.35286748409271, 1.35287296772003, 1.35287761688232, 1.35288155078888, 1.35288465023041, 1.3528870344162, 1.35288870334625, 1.35288941860199, 1.35288941860199, 1.35288870334625, 1.35288727283478, 1.3528847694397, 1.35288155078888, 1.35287773609161, 1.35287320613861, 1.35286772251129, 1.35286140441895, 1.35285460948944, 1.35284674167633, 1.35283803939819, 1.35282874107361, 1.352818608284, 1.35280787944794, 1.35279607772827, 1.35278356075287, 1.35277032852173, 1.35275638103485, 1.35274147987366, 1.35272598266602, 1.35270953178406, 1.35269224643707, 1.35267460346222, 1.35265576839447, 1.35263621807098, 1.35261607170105, 1.3525949716568, 1.35257315635681, 1.35255062580109, 1.35252714157104, 1.35250294208527, 1.35247802734375, 1.35245227813721, 1.35242581367493, 1.35239851474762, 1.35237050056458, 1.3523416519165, 1.35231196880341, 1.35228168964386, 1.35225045681, 1.3522185087204, 1.35218584537506, 1.35215210914612, 1.35211789608002, 1.3520827293396, 1.35204684734344, 1.35201025009155, 1.35197293758392, 1.35193479061127, 1.35189568996429, 1.35185599327087, 1.35181546211243, 1.35177409648895, 1.35173189640045, 1.3516891002655, 1.35164535045624, 1.35160100460052, 1.35155582427979, 1.35150969028473, 1.35146296024323, 1.35141539573669, 1.35136711597443, 1.35131788253784, 1.35126793384552, 1.35121738910675, 1.35116589069366, 1.35111355781555, 1.3510605096817, 1.3510068655014, 1.35095226764679, 1.35089695453644, 1.35084068775177, 1.35078382492065, 1.35072612762451, 1.35066759586334, 1.35060834884644, 1.35054838657379, 1.35048735141754, 1.35042583942413, 1.3503634929657, 1.35030031204224, 1.35023629665375, 1.35017168521881, 1.35010612010956, 1.35003983974457, 1.34997272491455, 1.3499048948288, 1.3498363494873, 1.34976696968079, 1.34969675540924, 1.34962582588196, 1.34955406188965, 1.34948146343231, 1.34940826892853, 1.34933412075043, 1.34925925731659, 1.34918367862701, 1.34910726547241, 1.34903013706207, 1.34895205497742, 1.34887325763702, 1.34879386425018, 1.34871339797974, 1.34863233566284, 1.34855043888092, 1.34846782684326, 1.34838438034058, 1.34830009937286, 1.34821510314941, 1.34812927246094, 1.34804272651672, 1.34795546531677, 1.3478672504425, 1.34777843952179, 1.34768867492676, 1.34759819507599, 1.34750699996948, 1.34741497039795, 1.34732210636139, 1.34722852706909, 1.34713423252106, 1.347039103508, 1.34694314002991, 1.34684646129608, 1.34674894809723, 1.34665071964264, 1.34655177593231, 1.34645187854767, 1.346351146698, 1.34624981880188, 1.34614753723145, 1.34604465961456, 1.34594106674194, 1.34583652019501, 1.34573113918304, 1.34562528133392, 1.3455183506012, 1.34541070461273, 1.34530222415924, 1.3451931476593, 1.34508323669434, 1.34497237205505, 1.34486079216003, 1.34474861621857, 1.34463548660278, 1.34452164173126, 1.344407081604, 1.34429156780243, 1.34417533874512, 1.34405839443207, 1.34394061565399, 1.34382200241089, 1.34370267391205, 1.34358274936676, 1.34346175193787, 1.34334003925323, 1.34321773052216, 1.34309434890747, 1.34297049045563, 1.34284555912018, 1.34272015094757, 1.34259378910065, 1.34246671199799, 1.34233868122101, 1.34221005439758, 1.34208071231842, 1.34195041656494, 1.34181928634644, 1.34168756008148, 1.34155488014221, 1.3414214849472, 1.34128737449646, 1.34115254878998, 1.34101688861847, 1.34088039398193, 1.34074306488037, 1.34060502052307, 1.34046626091003, 1.34032666683197, 1.34018623828888, 1.34004509449005, 1.3399031162262, 1.3397604227066, 1.33961689472198, 1.33947253227234, 1.33932757377625, 1.33918166160583, 1.33903503417969, 1.33888781070709, 1.33873951435089, 1.33859062194824, 1.33844089508057, 1.33829033374786, 1.33813893795013, 1.33798694610596, 1.33783411979675, 1.33768045902252, 1.33752596378326, 1.33737087249756, 1.33721470832825, 1.33705806732178, 1.33690059185028, 1.33674216270447, 1.33658313751221, 1.33642315864563, 1.33626246452332, 1.33610105514526, 1.33593893051147, 1.33577585220337, 1.33561217784882, 1.33544743061066, 1.33528220653534, 1.335116147995, 1.33494913578033, 1.33478152751923, 1.3346129655838, 1.33444380760193, 1.33427369594574, 1.33410310745239, 1.33393144607544, 1.33375906944275, 1.33358585834503, 1.33341193199158, 1.33323740959167, 1.33306181430817, 1.33288550376892, 1.33270847797394, 1.33253061771393, 1.33235204219818, 1.3321727514267, 1.3319925069809, 1.33181154727936, 1.33162987232208, 1.33144748210907, 1.33126401901245, 1.33108007907867, 1.33089530467987, 1.33070957660675, 1.33052325248718, 1.33033585548401, 1.33014810085297, 1.32995927333832, 1.32976973056793, 1.32957935333252, 1.32938838005066, 1.32919657230377, 1.32900393009186, 1.32881033420563, 1.32861626148224, 1.32842135429382, 1.32822549343109, 1.32802891731262, 1.32783174514771, 1.32763361930847, 1.32743465900421, 1.32723498344421, 1.32703459262848, 1.32683324813843, 1.32663142681122, 1.32642865180969, 1.32622504234314, 1.32602071762085, 1.32581567764282, 1.32560956478119, 1.32540309429169, 1.32519555091858, 1.32498729228973, 1.32477819919586, 1.32456851005554, 1.32435786724091, 1.32414650917053, 1.32393443584442, 1.32372152805328, 1.32350766658783, 1.32329332828522, 1.323077917099, 1.32286202907562, 1.32264518737793, 1.3224276304245, 1.32220923900604, 1.32199001312256, 1.32177007198334, 1.32154941558838, 1.3213278055191, 1.32110559940338, 1.32088255882263, 1.32065856456757, 1.32043409347534, 1.3202086687088, 1.31998252868652, 1.31975555419922, 1.31952786445618, 1.31929922103882, 1.3190701007843, 1.31883990764618, 1.31859481334686, 1.31833493709564, 1.31807434558868, 1.31781315803528, 1.31755137443542, 1.31728887557983, 1.3170257806778, 1.31676208972931, 1.31649780273438, 1.3162328004837, 1.31596708297729, 1.31570088863373, 1.31543397903442, 1.31516647338867, 1.31489825248718, 1.31462943553925, 1.31436002254486, 1.31409001350403, 1.31381928920746, 1.31354784965515, 1.31327593326569, 1.31300342082977, 1.31273019313812, 1.31245625019073, 1.31218183040619, 1.31190669536591, 1.31163084506989, 1.31135451793671, 1.31107747554779, 1.31079983711243, 1.31052148342133, 1.31024265289307, 1.30996286869049, 1.30968284606934, 1.30940198898315, 1.30912053585052, 1.30883836746216, 1.30855560302734, 1.30827236175537, 1.30798840522766, 1.30770361423492, 1.30741846561432, 1.30713248252869, 1.3068460226059, 1.30655896663666, 1.3062709569931, 1.30598258972168, 1.30569350719452, 1.30540382862091, 1.30511343479156, 1.30482244491577, 1.30453085899353, 1.30423867702484, 1.30394566059113, 1.30365228652954, 1.30335819721222, 1.30306339263916, 1.30276799201965, 1.30247187614441, 1.30217528343201, 1.30187785625458, 1.30157995223999, 1.30128133296967, 1.30098211765289, 1.30068230628967, 1.30038189888, 1.3000807762146, 1.29977905750275, 1.29947674274445, 1.29917371273041, 1.29886996746063, 1.29856562614441, 1.29826080799103, 1.29795515537262, 1.29764902591705, 1.29734241962433, 1.297034740448, 1.2967267036438, 1.29641819000244, 1.29610860347748, 1.29579865932465, 1.29548799991608, 1.29517674446106, 1.29486501216888, 1.29455256462097, 1.29423928260803, 1.29392552375793, 1.2936110496521, 1.29329597949982, 1.29298031330109, 1.29266405105591, 1.29234707355499, 1.29202938079834, 1.29171133041382, 1.29139244556427, 1.29107284545898, 1.29075276851654, 1.29043209552765, 1.29011070728302, 1.28978860378265, 1.28946602344513, 1.28914272785187, 1.28881883621216, 1.28849422931671, 1.28816914558411, 1.28784310817719, 1.28751683235168, 1.28718972206116, 1.28686189651489, 1.28653359413147, 1.28620457649231, 1.2858749628067, 1.28554475307465, 1.28521382808685, 1.28488230705261, 1.28455018997192, 1.28421723842621, 1.28388392925262, 1.2835499048233, 1.28321516513824, 1.28287971019745, 1.28254389762878, 1.28220736980438, 1.28187000751495, 1.28153216838837, 1.28119361400604, 1.28085458278656, 1.28051471710205, 1.28017437458038, 1.27983331680298, 1.27949178218842, 1.27914941310883, 1.27880644798279, 1.2784628868103, 1.27811884880066, 1.2777738571167, 1.27742838859558, 1.27708220481873, 1.27673554420471, 1.27638816833496, 1.27604019641876, 1.27569162845612, 1.27534222602844, 1.27499234676361, 1.27464187145233, 1.27429068088531, 1.27393877506256, 1.27358651161194, 1.27323341369629, 1.2728796005249, 1.27252531051636, 1.27217030525208, 1.27181482315063, 1.27145850658417, 1.27110183238983, 1.27074408531189, 1.27038609981537, 1.27002739906311, 1.26966786384583, 1.26930785179138, 1.26894700527191, 1.26858580112457, 1.2682238817215, 1.26786124706268, 1.26749813556671, 1.26713418960571, 1.26676976680756, 1.26640462875366, 1.26603889465332, 1.26567256450653, 1.265305519104, 1.26493787765503, 1.26456964015961, 1.26420068740845, 1.26383113861084, 1.26346099376678, 1.26309025287628, 1.26271867752075, 1.26234662532806, 1.26197397708893, 1.26160061359406, 1.26122653484344, 1.26085186004639, 1.26047670841217, 1.26010072231293, 1.25972425937653, 1.25934720039368, 1.25896954536438, 1.25859093666077, 1.25821197032928, 1.25783228874207, 1.2574520111084, 1.25707101821899, 1.25668942928314, 1.25630712509155, 1.25592446327209, 1.25554084777832, 1.2551566362381, 1.25477194786072, 1.2543865442276, 1.25400054454803, 1.25361394882202, 1.25322663784027, 1.25283873081207, 1.25245010852814, 1.25206100940704, 1.25167119503021, 1.25128078460693, 1.25088965892792, 1.25049781799316, 1.25010550022125, 1.2497124671936, 1.2493189573288, 1.24892461299896, 1.24852979183197, 1.24813413619995, 1.24773812294006, 1.24734127521515, 1.24694395065308, 1.24654591083527, 1.24614703655243, 1.24574780464172, 1.24534773826599, 1.24494731426239, 1.24454605579376, 1.24414396286011, 1.24374151229858, 1.2433385848999, 1.2429347038269, 1.24253034591675, 1.24212527275085, 1.24171960353851, 1.24131333827972, 1.24090647697449, 1.24049878120422, 1.2400906085968, 1.23968183994293, 1.23927235603333, 1.23886227607727, 1.23845160007477, 1.23804008960724, 1.23762822151184, 1.23721551895142, 1.23680222034454, 1.23638832569122, 1.23597383499146, 1.23555862903595, 1.235142827034, 1.2347264289856, 1.23430931568146, 1.23389160633087, 1.23347330093384, 1.23305439949036, 1.23263478279114, 1.23221457004547, 1.23179364204407, 1.23137211799622, 1.23094999790192, 1.23052716255188, 1.23010385036469, 1.22967982292175, 1.22925508022308, 1.22882986068726, 1.22840392589569, 1.22797727584839, 1.22755002975464, 1.22712218761444, 1.2266937494278, 1.22626459598541, 1.22583484649658, 1.22540462017059, 1.22497355937958, 1.22454178333282, 1.2241096496582, 1.22367656230927, 1.22324311733246, 1.22280895709991, 1.22237432003021, 1.22193872928619, 1.22150266170502, 1.2210658788681, 1.22062861919403, 1.22019076347351, 1.21975195407867, 1.21931278705597, 1.21887290477753, 1.21843230724335, 1.21799123287201, 1.21754944324493, 1.21710705757141, 1.21666407585144, 1.21622025966644, 1.21577596664429, 1.21533095836639, 1.21488547325134, 1.21443915367126, 1.21399247646332, 1.21354484558105, 1.21309673786163, 1.21264803409576, 1.21219861507416, 1.21174848079681, 1.2112979888916, 1.21084654331207, 1.21039462089539, 1.20994210243225, 1.20948886871338, 1.20903515815735, 1.20858061313629, 1.20812571048737, 1.20766985416412, 1.20721352100372, 1.20675659179688, 1.20629906654358, 1.20584058761597, 1.20538175106049, 1.20492231845856, 1.20446217060089, 1.20400130748749, 1.20353996753693, 1.20307791233063, 1.20261526107788, 1.20215177536011, 1.20168793201447, 1.2012232542038, 1.20075809955597, 1.20029211044312, 1.19982576370239, 1.19935858249664, 1.19889080524445, 1.19842231273651, 1.19795334339142, 1.19748377799988, 1.19701337814331, 1.1965423822403, 1.19607090950012, 1.19559872150421, 1.19512593746185, 1.19465231895447, 1.19417834281921, 1.19370353221893, 1.19322824478149, 1.19275224208832, 1.1922755241394, 1.19179832935333, 1.19132041931152, 1.19084191322327, 1.19036269187927, 1.18988287448883, 1.18940246105194, 1.1889214515686, 1.18843972682953, 1.18795740604401, 1.18747448921204, 1.18699085712433, 1.18650650978088, 1.18602168560028, 1.18553626537323, 1.18505001068115, 1.18456315994263, 1.18407595157623, 1.18358790874481, 1.18309915065765, 1.18260991573334, 1.18211996555328, 1.18162941932678, 1.18113803863525, 1.18064630031586, 1.18015384674072, 1.17966067790985, 1.17916691303253, 1.17867267131805, 1.17817759513855, 1.1776819229126, 1.17718577384949, 1.17668890953064, 1.17619121074677, 1.17569315433502, 1.17519426345825, 1.17469489574432, 1.17419481277466, 1.17369401454926, 1.1731926202774, 1.1726907491684, 1.17218804359436, 1.17168486118317, 1.17118096351624, 1.17067646980286, 1.17017126083374, 1.16966557502747, 1.16915905475616, 1.16865205764771, 1.16814434528351, 1.16763603687286, 1.16712713241577, 1.16661739349365, 1.16610729694366, 1.16559648513794, 1.16508495807648, 1.16457295417786, 1.16405999660492, 1.16354668140411, 1.16303265094757, 1.16251814365387, 1.16200280189514, 1.16148698329926, 1.16097033023834, 1.16045308113098, 1.15993523597717, 1.15941679477692, 1.15889775753021, 1.15837800502777, 1.15785765647888, 1.15733671188354, 1.15681493282318, 1.15629279613495, 1.15576982498169, 1.15524637699127, 1.15472221374512, 1.15419745445251, 1.15367209911346, 1.15314590930939, 1.15261924266815, 1.15209186077118, 1.15156400203705, 1.15103542804718, 1.15050601959229, 1.14997625350952, 1.14944589138031, 1.14891469478607, 1.14838302135468, 1.14785039424896, 1.14731740951538, 1.14678382873535, 1.14624965190887, 1.14571464061737, 1.14517903327942, 1.14464282989502, 1.14410603046417, 1.14356851577759, 1.14303052425385, 1.14249169826508, 1.14195251464844, 1.14141249656677, 1.14087176322937, 1.14033055305481, 1.13978862762451, 1.13924610614777, 1.13870286941528, 1.13815915584564, 1.13761448860168, 1.13706946372986, 1.13652384281158, 1.13597750663757, 1.1354306936264, 1.13488292694092, 1.13433480262756, 1.13378596305847, 1.13323640823364, 1.13268613815308, 1.13213551044464, 1.13158392906189, 1.13103199005127, 1.13047933578491, 1.12992608547211, 1.12937211990356, 1.12881755828857, 1.12826228141785, 1.12770652770996, 1.12714993953705, 1.12659287452698, 1.12603521347046, 1.12547671794891, 1.1249178647995, 1.12435817718506, 1.12379789352417, 1.12323701381683, 1.12267541885376, 1.12211310863495, 1.12155032157898, 1.12098693847656, 1.12042284011841, 1.1198582649231, 1.11929285526276, 1.11872684955597, 1.11816036701202, 1.11759305000305, 1.11702525615692, 1.11645650863647, 1.11588752269745, 1.1153177022934, 1.1147472858429, 1.11417639255524, 1.11360454559326, 1.11303234100342, 1.11245930194855, 1.11188578605652, 1.11131155490875, 1.11073672771454, 1.1101610660553, 1.10957002639771, 1.10896348953247, 1.10835671424866, 1.10774946212769, 1.10714209079742, 1.10653436183929, 1.10592651367188, 1.10531854629517, 1.1047101020813, 1.10410153865814, 1.10349261760712, 1.10288345813751, 1.10227394104004, 1.10166430473328, 1.10105443000793, 1.10044431686401, 1.09983384609222, 1.09922313690186, 1.0986123085022, 1.09800100326538, 1.09738981723785, 1.09677815437317, 1.09616613388062, 1.09555399417877, 1.09494149684906, 1.09432876110077, 1.0937157869339, 1.09310281276703, 1.09248924255371, 1.0918755531311, 1.09126162528992, 1.09064745903015, 1.09003305435181, 1.08941829204559, 1.0888032913208, 1.08818805217743, 1.08757257461548, 1.08695697784424, 1.08634102344513, 1.08572471141815, 1.08510828018188, 1.08449172973633, 1.08387458324432, 1.08325743675232, 1.08263993263245, 1.08202219009399, 1.08140408992767, 1.08078598976135, 1.08016741275787, 1.07954883575439, 1.07892966270447, 1.07831037044525, 1.07769095897675, 1.07707118988037, 1.07645118236542, 1.07583105564117, 1.07521045207977, 1.07458961009979, 1.07396864891052, 1.07334733009338, 1.07272589206696, 1.07210397720337, 1.07148194313049, 1.07085978984833, 1.070237159729, 1.06961441040039, 1.0689914226532, 1.06836807727814, 1.0677444934845, 1.06712067127228, 1.06649672985077, 1.06587243080139, 1.06524789333344, 1.06462323665619, 1.0639979839325, 1.0633727312088, 1.06274712085724, 1.0621212720871, 1.06149530410767, 1.06086885929108, 1.06024241447449, 1.05961549282074, 1.0589884519577, 1.05836129188538, 1.0577335357666, 1.05710566043854, 1.05647754669189, 1.05584919452667, 1.05522060394287, 1.05459177494049, 1.05396270751953, 1.05333340167999, 1.0527036190033, 1.05207395553589, 1.05144381523132, 1.05081343650818, 1.05018270015717, 1.04955196380615, 1.04892075061798, 1.04828929901123, 1.04765772819519, 1.04702579975128, 1.04639387130737, 1.04576134681702, 1.04512870311737, 1.04449582099915, 1.04386258125305, 1.04322934150696, 1.04259550571442, 1.04196166992188, 1.04132759571075, 1.04069316387177, 1.0400584936142, 1.03942358493805, 1.03878843784332, 1.03815305233002, 1.03751730918884, 1.03688144683838, 1.03624534606934, 1.03560888767242, 1.03497207164764, 1.03433525562286, 1.03369784355164, 1.03306066989899, 1.0324227809906, 1.0317850112915, 1.03114676475525, 1.03050827980042, 1.029869556427, 1.0292307138443, 1.02859139442444, 1.02795195579529, 1.02731227874756, 1.02667236328125, 1.02603209018707, 1.02539169788361, 1.02475082874298, 1.02410995960236, 1.02346873283386, 1.02282726764679, 1.02218556404114, 1.02154350280762, 1.02090132236481, 1.02025878429413, 1.01961600780487, 1.01897311210632, 1.01832985877991, 1.01768636703491, 1.01704263687134, 1.01639866828918, 1.01575434207916, 1.01510977745056, 1.01446509361267, 1.01382005214691, 1.01317477226257, 1.01252925395966, 1.01188349723816, 1.01123738288879, 1.01059114933014, 1.00994467735291, 1.0092978477478, 1.00865077972412, 1.00800347328186, 1.00735604763031, 1.0067081451416, 1.0060601234436, 1.00541186332703, 1.00476324558258, 1.00411450862885, 1.00346541404724, 1.00281608104706, 1.0021665096283, 1.00151669979095, 1.00086665153503, 1.00021636486053, 0.999565720558167, 0.998914957046509, 0.998263895511627, 0.997612595558167, 0.996960997581482, 0.996309101581573, 0.995657026767731, 0.995004653930664, 0.994352102279663, 0.993699252605438, 0.99304610490799, 0.992392778396606, 0.991739213466644, 0.991085350513458, 0.990431189537048, 0.989776849746704, 0.989122331142426, 0.988467395305634, 0.987812280654907, 0.987156927585602, 0.986501276493073, 0.985845446586609, 0.985189318656921, 0.984532833099365, 0.983876287937164, 0.983219385147095, 0.982562243938446, 0.981904804706573, 0.981247246265411, 0.980589270591736, 0.979931175708771, 0.979272723197937, 0.978614151477814, 0.977955222129822, 0.977296054363251, 0.976636528968811, 0.975976884365082, 0.975317060947418, 0.974656820297241, 0.97399640083313, 0.973335742950439, 0.97267484664917, 0.972013592720032, 0.971352159976959, 0.970690488815308, 0.970028579235077, 0.969366371631622, 0.968703925609589, 0.968041241168976, 0.967378258705139, 0.966715037822723, 0.966051578521729, 0.965387880802155, 0.964723944664001, 0.964059710502625, 0.963395237922668, 0.962730526924133, 0.962065577507019, 0.961400330066681, 0.960734844207764, 0.960069179534912, 0.959403216838837, 0.958736956119537, 0.958070456981659, 0.957403719425201, 0.956736743450165, 0.956069469451904, 0.955402016639709, 0.954734206199646, 0.954066276550293, 0.953397929668427, 0.952729523181915, 0.952060699462891, 0.951391696929932, 0.950722455978394, 0.950052917003632, 0.949383199214935, 0.948713064193726, 0.948042869567871, 0.947372317314148, 0.946701526641846, 0.94603043794632, 0.945359230041504, 0.944687724113464, 0.944015860557556, 0.943343758583069, 0.942671537399292, 0.941998958587646, 0.941326200962067, 0.940653085708618, 0.939979791641235, 0.939306259155273, 0.938632428646088, 0.937958359718323, 0.937284052371979, 0.936609506607056, 0.935934662818909, 0.935259580612183, 0.934584259986877, 0.933908700942993, 0.933232843875885, 0.932556688785553, 0.931880474090576, 0.931203842163086, 0.930526971817017, 0.929849863052368, 0.929172515869141, 0.928494989871979, 0.927817165851593, 0.927138924598694, 0.926460564136505, 0.925781965255737, 0.92510312795639, 0.924423933029175, 0.92374461889267, 0.923065066337585, 0.922385215759277, 0.921704947948456, 0.921024680137634, 0.920344054698944, 0.919663190841675, 0.918981969356537, 0.918300569057465, 0.917618989944458, 0.916937112808228, 0.916254937648773, 0.91557252407074, 0.914889872074127, 0.914206981658936, 0.913523733615875, 0.912840306758881, 0.912156760692596, 0.911472856998444, 0.910788595676422, 0.910104215145111, 0.909419596195221, 0.908734619617462, 0.908049404621124, 0.907364010810852, 0.906678318977356, 0.905992448329926, 0.905306220054626, 0.904619753360748, 0.903932988643646, 0.903246104717255, 0.902558922767639, 0.9018714427948, 0.901183724403381, 0.900495886802673, 0.899807631969452, 0.899119138717651, 0.898430407047272, 0.897741436958313, 0.89705228805542, 0.896362721920013, 0.895673036575317, 0.894983053207397, 0.894292831420898, 0.893602252006531, 0.892911493778229, 0.892220556735992, 0.891529381275177, 0.890837788581848, 0.89014607667923, 0.889454126358032, 0.888761878013611, 0.888069272041321, 0.887376546859741, 0.886683583259583, 0.885990381240845, 0.885296761989594, 0.884603083133698, 0.883909046649933, 0.883214771747589, 0.882520198822021, 0.881825387477875, 0.881130456924438, 0.880435109138489, 0.879739582538605, 0.879043757915497, 0.878347814083099, 0.877651512622833, 0.876954913139343, 0.876258134841919, 0.875561058521271, 0.874863803386688, 0.874166131019592, 0.873468399047852, 0.872770309448242, 0.872072041034698, 0.871373414993286, 0.870674610137939, 0.869975507259369, 0.869276225566864, 0.86857658624649, 0.867876768112183, 0.867176711559296, 0.86647641658783, 0.865775763988495, 0.865074872970581, 0.864373862743378, 0.86367255449295, 0.862970888614655, 0.862269043922424, 0.861566960811615, 0.860864639282227, 0.860161960124969, 0.859459161758423, 0.858756005764008, 0.858052670955658, 0.857349038124084, 0.856645107269287, 0.8559410572052, 0.855236649513245, 0.854531943798065, 0.853827178478241, 0.853121936321259, 0.852416634559631, 0.851710915565491, 0.851005077362061, 0.850298941135406, 0.849592566490173, 0.848885834217072, 0.848178923130035, 0.847471833229065, 0.846764504909515, 0.846056699752808, 0.84534877538681, 0.844640672206879, 0.843932330608368, 0.843223512172699, 0.842514634132385, 0.841805458068848, 0.841096103191376, 0.84038633108139, 0.839676380157471, 0.838966190814972, 0.838255822658539, 0.837545037269592, 0.836834192276001, 0.836122989654541, 0.835411608219147, 0.834699749946594, 0.833987832069397, 0.833275616168976, 0.83256322145462, 0.831850469112396, 0.831137478351593, 0.830424308776855, 0.829710841178894, 0.828997075557709, 0.828283071517944, 0.827568888664246, 0.826854407787323, 0.826139628887177, 0.825424611568451, 0.824709475040436, 0.823993980884552, 0.8232781291008, 0.822562217712402, 0.821845948696136, 0.821129441261292, 0.820412755012512, 0.819695711135864, 0.818978369235992, 0.818260967731476, 0.817543268203735, 0.816825091838837, 0.816106915473938, 0.815388381481171, 0.814669549465179, 0.813950479030609, 0.813231229782104, 0.812511742115021, 0.811792016029358, 0.811071872711182, 0.810351610183716, 0.809631168842316, 0.808910250663757, 0.808189153671265, 0.807467877864838, 0.806746363639832, 0.806024551391602, 0.805302441120148, 0.804580211639404, 0.803857624530792, 0.803134858608246, 0.802411675453186, 0.801688373088837, 0.800964832305908, 0.800241053104401, 0.799516916275024, 0.798792660236359, 0.798067986965179, 0.797343254089355, 0.796618044376373, 0.795892775058746, 0.795167148113251, 0.794441282749176, 0.793715119361877, 0.792988836765289, 0.792262196540833, 0.791535377502441, 0.790808260440826, 0.790080845355988, 0.789353311061859, 0.788625419139862, 0.787897169589996, 0.787168800830841, 0.786440253257751, 0.785711407661438, 0.784982204437256, 0.784252822399139, 0.783523201942444, 0.782793343067169, 0.782063126564026, 0.781332790851593, 0.780602157115936, 0.779871225357056, 0.779140055179596, 0.778408706188202, 0.777677059173584, 0.776945173740387, 0.776212871074677, 0.775480508804321, 0.774756133556366, 0.774040758609772, 0.773325443267822, 0.772610306739807, 0.771895587444305, 0.771180868148804, 0.770466268062592, 0.769751965999603, 0.769037902355194, 0.76832389831543, 0.767610013484955, 0.766896426677704, 0.766183078289032, 0.76546984910965, 0.764756739139557, 0.764043867588043, 0.763331174850464, 0.762618660926819, 0.761906266212463, 0.761194109916687, 0.76048219203949, 0.759770452976227, 0.759058654308319, 0.758347272872925, 0.75763601064682, 0.756925046443939, 0.756214082241058, 0.755503296852112, 0.754792869091034, 0.754082560539246, 0.753372251987457, 0.752662420272827, 0.751952648162842, 0.751242935657501, 0.750533401966095, 0.749824285507202, 0.749115228652954, 0.748406231403351, 0.747697532176971, 0.746989071369171, 0.74628072977066, 0.745572447776794, 0.744864523410797, 0.744156718254089, 0.743448972702026, 0.742741644382477, 0.742034375667572, 0.741327226161957, 0.740620374679565, 0.739913642406464, 0.739207148551941, 0.738500714302063, 0.737794518470764, 0.737088680267334, 0.736382663249969, 0.735677123069763, 0.734971642494202, 0.734266340732574, 0.733561277389526, 0.732856452465057, 0.732151687145233, 0.731447160243988, 0.730742752552032, 0.730038583278656, 0.729334592819214, 0.728630721569061, 0.727927148342133, 0.727223634719849, 0.726520299911499, 0.725817263126373, 0.725114345550537, 0.72441154718399, 0.723709046840668, 0.723006725311279, 0.722304463386536, 0.721602380275726, 0.720900595188141, 0.72019898891449, 0.719497561454773, 0.718796193599701, 0.718095123767853, 0.717394232749939, 0.71669340133667, 0.71599280834198, 0.715292513370514, 0.714592278003693, 0.713892340660095, 0.713192403316498, 0.712492823600769, 0.71179324388504, 0.711094081401825, 0.710394859313965, 0.709695935249329, 0.708997189998627, 0.708298683166504, 0.707600176334381, 0.706902027130127, 0.706204056739807, 0.705506265163422, 0.704808473587036, 0.704110980033875, 0.703413784503937, 0.702716648578644, 0.70201963186264, 0.701322972774506, 0.700626313686371, 0.699929893016815, 0.699233710765839, 0.698537707328796, 0.697841823101044, 0.69714617729187, 0.696450710296631, 0.695755362510681, 0.695060193538666, 0.694365322589874, 0.693670511245728, 0.69297593832016, 0.692281484603882, 0.691587328910828, 0.690893232822418, 0.690199375152588, 0.689505755901337, 0.68881231546402, 0.688118815422058, 0.68742573261261, 0.686732888221741, 0.686040043830872, 0.685347437858582, 0.684655070304871, 0.683962881565094, 0.683270752429962, 0.682578921318054, 0.681887209415436, 0.681195735931396, 0.680504441261292, 0.679813206195831, 0.67912220954895, 0.678431510925293, 0.677740931510925, 0.677050530910492, 0.676360189914703, 0.675670266151428, 0.674980342388153, 0.674290657043457, 0.673601090908051, 0.672911882400513, 0.67222273349762, 0.671533703804016, 0.670844972133636, 0.670156359672546, 0.669467806816101, 0.66877955198288, 0.668091535568237, 0.667403757572174, 0.666715919971466, 0.666028380393982, 0.665341138839722, 0.664653956890106, 0.66396701335907, 0.663280189037323, 0.66259354352951, 0.661907136440277, 0.661220908164978, 0.660534858703613, 0.659848868846893, 0.659163236618042, 0.658477783203125, 0.657792329788208, 0.657107174396515, 0.656422257423401, 0.655737519264221, 0.655052781105042, 0.65436840057373, 0.653684139251709, 0.652999997138977, 0.652316093444824, 0.65163242816925, 0.650948882102966, 0.650265514850616, 0.649582386016846, 0.64889931678772, 0.648216545581818, 0.64753395318985, 0.646851420402527, 0.646169126033783, 0.645487070083618, 0.644805312156677, 0.644123494625092, 0.643441915512085, 0.642760694026947, 0.642079532146454, 0.641398429870605, 0.640717566013336, 0.640036940574646, 0.639356553554535, 0.638676285743713, 0.637996137142181, 0.637316286563873, 0.63663649559021, 0.635957062244415, 0.635277628898621, 0.63459849357605, 0.633919417858124, 0.633240640163422, 0.632562041282654, 0.631883561611176, 0.631205201148987, 0.630527079105377, 0.629849135875702, 0.629171371459961, 0.628494024276733, 0.627816557884216, 0.627139329910278, 0.626462340354919, 0.62578558921814, 0.625108957290649, 0.624432325363159, 0.623756170272827, 0.62308007478714, 0.622404158115387, 0.621728301048279, 0.621052742004395, 0.620377361774445, 0.619702219963074, 0.619027137756348, 0.618352353572845, 0.617677688598633, 0.617003202438354, 0.616328954696655, 0.615654766559601, 0.614980936050415, 0.614307165145874, 0.613633513450623, 0.61296021938324, 0.612287044525146, 0.611613988876343, 0.610941112041473, 0.610268414020538, 0.609596014022827, 0.608923673629761, 0.608251452445984, 0.607579588890076, 0.606907844543457, 0.606236219406128, 0.605564773082733, 0.604893684387207, 0.604222595691681, 0.603551745414734, 0.602881073951721, 0.602210581302643, 0.601540327072144, 0.600870192050934, 0.600200235843658, 0.599530398845673, 0.598860859870911, 0.598191559314728, 0.597522139549255, 0.596853256225586, 0.596184372901917, 0.595515727996826, 0.594847083091736, 0.594178855419159, 0.593510806560516, 0.592842817306519, 0.59217494726181, 0.591507375240326, 0.590840041637421, 0.590172827243805, 0.589505791664124, 0.588838875293732, 0.588172197341919, 0.587505757808685, 0.586839377880096, 0.586173117160797, 0.585507273674011, 0.58484148979187, 0.584175884723663, 0.583510458469391, 0.582845270633698, 0.582180202007294, 0.581515252590179, 0.580850601196289, 0.580186069011688, 0.579521834850311, 0.57885754108429, 0.578193604946136, 0.577529847621918, 0.576866269111633, 0.576202809810638, 0.575539588928223, 0.574876546859741, 0.574213624000549, 0.573550879955292, 0.572888553142548, 0.572226107120514, 0.571563899517059, 0.570901930332184, 0.570240199565887, 0.569578528404236, 0.568917155265808, 0.56825590133667, 0.567594766616821, 0.566933870315552, 0.566273272037506, 0.565612614154816, 0.564952433109283, 0.564292252063751, 0.563632249832153, 0.562972366809845, 0.562312841415405, 0.56165337562561, 0.560994029045105, 0.560335040092468, 0.559676170349121, 0.559017479419708, 0.55835884809494, 0.557700574398041, 0.557042300701141, 0.556384384632111, 0.555726587772369, 0.555068969726562, 0.5544114112854, 0.553754210472107, 0.553097128868103, 0.552440345287323, 0.551783502101898, 0.551127016544342, 0.550470530986786, 0.549814522266388, 0.54915851354599, 0.548502624034882, 0.547847032546997, 0.547191560268402, 0.546536266803741, 0.54588121175766, 0.545226335525513, 0.5445716381073, 0.543917000293732, 0.543262600898743, 0.542608499526978, 0.541954457759857, 0.541300594806671, 0.540647029876709, 0.539993584156036, 0.539340436458588, 0.538687169551849, 0.53803426027298, 0.537381589412689, 0.536729037761688, 0.536076605319977, 0.535424411296844, 0.534772455692291, 0.534120678901672, 0.533468902111053, 0.532817423343658, 0.532166242599487, 0.531515061855316, 0.530864119529724, 0.530213356018066, 0.529562890529633, 0.528912484645844, 0.528262317180634, 0.527612268924713, 0.526962399482727, 0.526312828063965, 0.525663316249847, 0.525013983249664, 0.524364948272705, 0.523715972900391, 0.52306717634201, 0.522418677806854, 0.521770358085632, 0.521122097969055, 0.520474076271057, 0.519826173782349, 0.519178569316864, 0.518531084060669, 0.517883718013763, 0.517236709594727, 0.516589760780334, 0.515942931175232, 0.515296339988708, 0.514649927616119, 0.514003813266754, 0.513357758522034, 0.512711882591248, 0.512066125869751, 0.511420726776123, 0.510775446891785, 0.510130226612091, 0.509485304355621, 0.508840680122375, 0.50819605588913, 0.507551550865173, 0.506907343864441, 0.506263375282288, 0.505619525909424, 0.50497579574585, 0.50433224439621, 0.503689050674438, 0.503045916557312, 0.50240284204483, 0.501760065555573, 0.501117646694183, 0.500475168228149, 0.499832928180695, 0.499190896749496, 0.498548984527588, 0.497907400131226, 0.497265875339508, 0.49662446975708, 0.495983451604843, 0.495342403650284, 0.494701623916626, 0.494060963392258, 0.493420660495758, 0.492780417203903, 0.492140293121338, 0.491500407457352, 0.490860819816589, 0.490221261978149, 0.489581882953644, 0.488942742347717, 0.488303899765015, 0.487665057182312, 0.487026393413544, 0.486388057470322, 0.485749810934067, 0.485111683607101, 0.484473764896393, 0.483836114406586, 0.483198642730713, 0.48256129026413, 0.481924086809158, 0.481287091970444, 0.480650395154953, 0.480013817548752, 0.479377418756485, 0.478741019964218, 0.478105008602142, 0.477469205856323, 0.476833403110504, 0.476197868585587, 0.475562512874603, 0.474927395582199, 0.474292427301407, 0.473657578229904, 0.473022967576981, 0.472388565540314, 0.471754372119904, 0.471120178699493, 0.470486372709274, 0.469852715730667, 0.469219088554382, 0.468585699796677, 0.46795254945755, 0.467319637537003, 0.466686874628067, 0.466054201126099, 0.465421706438065, 0.464789390563965, 0.464157462120056, 0.463525503873825, 0.462893754243851, 0.462262153625488, 0.461630970239639, 0.460999697446823, 0.460368663072586, 0.459737807512283, 0.459107309579849, 0.458476722240448, 0.457846611738205, 0.45721647143364, 0.456586629152298, 0.455956697463989, 0.455327272415161, 0.454697877168655, 0.454068720340729, 0.453439652919769, 0.452811032533646, 0.452182203531265, 0.451553851366043, 0.450925529003143, 0.450297474861145, 0.449669539928436, 0.449041813611984, 0.448414206504822, 0.447786837816238, 0.447159677743912, 0.446532726287842, 0.445905804634094, 0.445279151201248, 0.444652676582336, 0.444026410579681, 0.443400204181671, 0.442774385213852, 0.442148655653, 0.441523194313049, 0.440897703170776, 0.440272510051727, 0.439666390419006, 0.439078211784363, 0.4384905397892, 0.43790328502655, 0.437316536903381, 0.436729997396469, 0.436143934726715, 0.43555822968483, 0.434972941875458, 0.434388220310211, 0.433803707361221, 0.433219492435455, 0.432635962963104, 0.432052791118622, 0.431469827890396, 0.430887341499329, 0.430305361747742, 0.429723739624023, 0.429142266511917, 0.42856153845787, 0.427981019020081, 0.427401095628738, 0.426821291446686, 0.426242053508759, 0.425663322210312, 0.425084739923477, 0.424506694078445, 0.423929154872894, 0.423351883888245, 0.422775000333786, 0.422198444604874, 0.421622544527054, 0.421046853065491, 0.420471668243408, 0.41989666223526, 0.41932225227356, 0.418748259544373, 0.418174654245377, 0.417601317167282, 0.417028486728668, 0.416456133127213, 0.415883988142014, 0.415312319993973, 0.414741069078445, 0.414170235395432, 0.413599759340286, 0.413029789924622, 0.412460118532181, 0.411890804767609, 0.411321938037872, 0.410753548145294, 0.410185426473618, 0.409617781639099, 0.409050583839417, 0.408483773469925, 0.40791729092598, 0.407351195812225, 0.406785696744919, 0.406220376491547, 0.405655592679977, 0.405091136693954, 0.404527187347412, 0.403963536024094, 0.403400152921677, 0.40283739566803, 0.402274936437607, 0.40171292424202, 0.401151299476624, 0.400590091943741, 0.400029301643372, 0.399468839168549, 0.398908734321594, 0.398349046707153, 0.397789835929871, 0.397231161594391, 0.396672606468201, 0.396114617586136, 0.395556956529617, 0.394999772310257, 0.394442975521088, 0.39388644695282, 0.393330425024033, 0.392774879932404, 0.392219513654709, 0.391664773225784, 0.391110330820084, 0.390556424856186, 0.390002608299255, 0.389449506998062, 0.388896614313126, 0.388344138860703, 0.38779217004776, 0.387240678071976, 0.386689275503159, 0.386138409376144, 0.385588109493256, 0.385038018226624, 0.38448840379715, 0.383939176797867, 0.383390486240387, 0.382841885089874, 0.382293939590454, 0.38174632191658, 0.38119900226593, 0.380652129650116, 0.380105823278427, 0.379559874534607, 0.379014164209366, 0.378468960523605, 0.377924203872681, 0.377379834651947, 0.37683579325676, 0.376292079687119, 0.375748991966248, 0.375206172466278, 0.374663710594177, 0.374121755361557, 0.373580127954483, 0.3730388879776, 0.372498095035553, 0.371957659721375, 0.371417582035065, 0.37087807059288, 0.370338797569275, 0.369799971580505, 0.369261592626572, 0.368723630905151, 0.368185967206955, 0.367648869752884, 0.36711198091507, 0.366575628519058, 0.366039454936981, 0.365503937005997, 0.364968746900558, 0.364434003829956, 0.363899409770966, 0.363365590572357, 0.362831979990005, 0.362298756837845, 0.361765891313553, 0.361233651638031, 0.360701560974121, 0.360169887542725, 0.359638720750809, 0.359108030796051, 0.358577489852905, 0.358047544956207, 0.357517957687378, 0.356988608837128, 0.356459975242615, 0.355931520462036, 0.355403631925583, 0.354875832796097, 0.35434877872467, 0.353822022676468, 0.353295505046844, 0.352769494056702, 0.352244079113007, 0.351718783378601, 0.351193964481354, 0.350669533014297, 0.350145667791367, 0.349622040987015, 0.349098801612854, 0.348576039075851, 0.348053574562073, 0.347531735897064, 0.34701007604599, 0.346488833427429, 0.345968008041382, 0.345447778701782, 0.344927728176117, 0.344408124685287, 0.343888908624649, 0.343370199203491, 0.342851728200912, 0.342333793640137, 0.34181621670723, 0.341299086809158, 0.340782195329666, 0.340265899896622, 0.339749872684479, 0.339234411716461, 0.338719069957733, 0.338204354047775, 0.337689936161041, 0.337176024913788, 0.336662441492081, 0.336149275302887, 0.335636526346207, 0.33512407541275, 0.334612101316452, 0.334100604057312, 0.333589345216751, 0.333078473806381, 0.332568228244781, 0.332058131694794, 0.331548541784286, 0.33103945851326, 0.330530732870102, 0.330022126436234, 0.329514354467392, 0.329006731510162, 0.328499525785446, 0.327992677688599, 0.327486425638199, 0.326980501413345, 0.326474845409393, 0.325969666242599, 0.325465053319931, 0.324960649013519, 0.324456632137299, 0.323953032493591, 0.32344976067543, 0.322947174310684, 0.322444826364517, 0.321942776441574, 0.321441203355789, 0.32094007730484, 0.320439338684082, 0.31993892788887, 0.319438964128494, 0.318939477205276, 0.318440318107605, 0.317941457033157, 0.31744310259819, 0.316945254802704, 0.316447734832764, 0.315950453281403, 0.315453737974167, 0.314957439899445, 0.314461469650269, 0.313965916633606, 0.31347069144249, 0.312975853681564, 0.312481671571732, 0.311987698078156, 0.311494112014771, 0.311000913381577, 0.310508102178574, 0.310015827417374, 0.309523850679398, 0.309032261371613, 0.30854120850563, 0.308050274848938, 0.307560116052628, 0.307069927453995, 0.306580573320389, 0.30609130859375, 0.305602610111237, 0.305114239454269, 0.30462634563446, 0.304138690233231, 0.303651660680771, 0.303164839744568, 0.302678525447845, 0.302192628383636, 0.301707088947296, 0.301221877336502, 0.300737023353577, 0.300252676010132, 0.299768805503845, 0.29928532242775, 0.2988021671772, 0.298319488763809, 0.297837197780609, 0.297355026006699, 0.296873539686203, 0.296392440795898, 0.29591166973114, 0.295431464910507, 0.294951468706131, 0.294471919536591, 0.293992906808853, 0.293513894081116, 0.293035596609116, 0.292557865381241, 0.292080253362656, 0.291603088378906, 0.291126430034637, 0.290650069713593, 0.290174245834351, 0.289698421955109, 0.289223343133926, 0.28874871134758, 0.288274377584457, 0.287800341844559, 0.287326991558075, 0.286853700876236, 0.286381006240845, 0.285908669233322, 0.285436719655991, 0.284965217113495, 0.284494161605835, 0.284023404121399, 0.283553123474121, 0.283083081245422, 0.282613545656204, 0.282144337892532, 0.281675755977631, 0.28120744228363, 0.280739367008209, 0.280271917581558, 0.279804736375809, 0.279338181018829, 0.278871774673462, 0.278405785560608, 0.277940362691879, 0.277475118637085, 0.277010381221771, 0.276546150445938, 0.276082217693329, 0.275618880987167, 0.275155663490295, 0.274692952632904, 0.274230509996414, 0.273768573999405, 0.273307114839554, 0.272846072912216, 0.27238529920578, 0.271925002336502, 0.27146515250206, 0.271005630493164, 0.270546317100525, 0.270087659358978, 0.269629389047623, 0.269171476364136, 0.268713980913162, 0.268256843090057, 0.267800331115723, 0.267343819141388, 0.266887813806534, 0.266432464122772, 0.265977323055267, 0.265522629022598, 0.26506832242012, 0.264614462852478, 0.26416078209877, 0.263707846403122, 0.263255089521408, 0.262802749872208, 0.262350827455521, 0.261899352073669, 0.261448264122009, 0.260997533798218, 0.260547280311584, 0.260097414255142, 0.259647876024246, 0.259198755025864, 0.258750110864639, 0.258301734924316, 0.257853746414185, 0.257406413555145, 0.256959170103073, 0.256512492895126, 0.256066292524338, 0.255620211362839, 0.25517463684082, 0.254729747772217, 0.25428494811058, 0.253840833902359, 0.253396838903427, 0.252953320741653, 0.252510070800781, 0.252067416906357, 0.251625180244446, 0.251183390617371, 0.250741809606552, 0.250300735235214, 0.249860152602196, 0.249419897794724, 0.248979732394218, 0.248540326952934, 0.248101219534874, 0.247662603855133, 0.247224405407906, 0.246786400675774, 0.246349051594734, 0.245911911129951, 0.245475068688393, 0.245038837194443, 0.244602963328362, 0.244167521595955, 0.243732497096062, 0.243297785520554, 0.242863431572914, 0.242429614067078, 0.241996049880981, 0.241562992334366, 0.24113042652607, 0.240697965025902, 0.240266129374504, 0.239834651350975, 0.239403545856476, 0.238973066210747, 0.238542556762695, 0.238112807273865, 0.237683340907097, 0.237254247069359, 0.236825466156006, 0.236397281289101, 0.235969364643097, 0.235541805624962, 0.23511478304863, 0.234688133001328, 0.234261676669121, 0.233835935592651, 0.233410462737083, 0.232985451817513, 0.232560783624649, 0.232136443257332, 0.231712535023689, 0.231288999319077, 0.230865955352783, 0.230443403124809, 0.230021104216576, 0.229599222540855, 0.229177832603455, 0.228756666183472, 0.228335902094841, 0.227915719151497, 0.227495849132538, 0.22707636654377, 0.226657345890999, 0.226238697767258, 0.225820541381836, 0.225402623414993, 0.224984958767891, 0.224567964673042, 0.224151313304901, 0.223735064268112, 0.223319292068481, 0.22290375828743, 0.222488775849342, 0.222074061632156, 0.221659734845161, 0.221245855093002, 0.220832467079163, 0.220419436693192, 0.220006719231606, 0.219594553112984, 0.219182625412941, 0.218771174550056, 0.218360185623169, 0.217949405312538, 0.217539310455322, 0.217129409313202, 0.216719791293144, 0.216310858726501, 0.215902164578438, 0.215493902564049, 0.215086072683334, 0.214678674936295, 0.214271575212479, 0.21386481821537, 0.213458597660065, 0.213052839040756, 0.212647378444672, 0.212242290377617, 0.21183767914772, 0.211433410644531, 0.211029425263405, 0.210626095533371, 0.210223034024239, 0.20982038974762, 0.20941823720932, 0.209016278386116, 0.208614856004715, 0.208213806152344, 0.20781309902668, 0.207412838935852, 0.207013085484505, 0.20661361515522, 0.206214636564255, 0.205816015601158, 0.205417782068253, 0.20501971244812, 0.204622387886047, 0.204225361347198, 0.203828766942024, 0.203432530164719, 0.203036680817604, 0.202641308307648, 0.202246099710464, 0.201851412653923, 0.201457262039185, 0.201063469052315, 0.20066998898983, 0.200277060270309, 0.199884429574013, 0.199492126703262, 0.199100285768509, 0.198708757758141, 0.198317855596542, 0.197927176952362, 0.197536930441856, 0.197147041559219, 0.196757599711418, 0.19636857509613, 0.195980042219162, 0.195602878928185, 0.195237129926682, 0.194871857762337, 0.194506660103798, 0.194142132997513, 0.193777844309807, 0.193414121866226, 0.193050637841225, 0.192687511444092, 0.192324742674828, 0.191962376236916, 0.191600516438484, 0.191238924860954, 0.190877825021744, 0.190517202019691, 0.190156757831573, 0.189796686172485, 0.189437046647072, 0.189077839255333, 0.188719123601913, 0.188360571861267, 0.188002571463585, 0.187644839286804, 0.187287628650665, 0.186930507421494, 0.186574026942253, 0.186217918992043, 0.185862138867378, 0.185506761074066, 0.185151785612106, 0.184797197580338, 0.184443056583405, 0.1840890198946, 0.183735683560371, 0.183382570743561, 0.18302994966507, 0.182677581906319, 0.182325705885887, 0.181974172592163, 0.18162302672863, 0.18127229809761, 0.180921897292137, 0.180571973323822, 0.18022233247757, 0.179873183369637, 0.17952436208725, 0.179175853729248, 0.178827852010727, 0.178480073809624, 0.178132951259613, 0.177785962820053, 0.177439510822296, 0.177093297243118, 0.176747530698776, 0.176402240991592, 0.176057249307632, 0.175712689757347, 0.175368517637253, 0.175024583935738, 0.174681156873703, 0.174338147044182, 0.173995479941368, 0.173653200268745, 0.17331138253212, 0.172969937324524, 0.17262864112854, 0.172287985682487, 0.171947583556175, 0.171607598662376, 0.171268120408058, 0.170928940176964, 0.170590192079544, 0.170251742005348, 0.169913604855537, 0.16957588493824, 0.169238731265068, 0.168901920318604, 0.16856537759304, 0.168229311704636, 0.167893558740616, 0.167558342218399, 0.167223125696182, 0.166888579726219, 0.166554480791092, 0.166220754384995, 0.165887355804443, 0.165554240345955, 0.165221571922302, 0.164889425039291, 0.164557456970215, 0.164225965738297, 0.163894847035408, 0.163564220070839, 0.163233786821365, 0.16290383040905, 0.162574365735054, 0.162245139479637, 0.161916330456734, 0.161587923765182, 0.161259964108467, 0.160932272672653, 0.160605013370514, 0.160278216004372, 0.15995167195797, 0.159625634551048, 0.15929988026619, 0.158974573016167, 0.158649638295174, 0.158325061202049, 0.158001020550728, 0.157677114009857, 0.157353818416595, 0.157030761241913, 0.156708061695099, 0.156385943293571, 0.156063973903656, 0.155742570757866, 0.155421406030655, 0.155100733041763, 0.154780611395836, 0.154460623860359, 0.154141038656235, 0.15382182598114, 0.153503119945526, 0.15318475663662, 0.152866721153259, 0.152549162507057, 0.152231901884079, 0.15191513299942, 0.151598572731018, 0.151282534003258, 0.150966748595238, 0.150651514530182, 0.150336638092995, 0.150022089481354, 0.149708017706871, 0.149394050240517, 0.149080768227577, 0.148767739534378, 0.148455187678337, 0.148142993450165, 0.147831112146378, 0.147519737482071, 0.147208526730537, 0.146897882223129, 0.146587699651718, 0.146277785301208, 0.145968228578568, 0.145659044384956, 0.14535029232502, 0.145041882991791, 0.144733980298042, 0.144426450133324, 0.144119203090668, 0.143812462687492, 0.143505826592445, 0.143199816346169, 0.142894178628922, 0.142588838934898, 0.142284035682678, 0.14197950065136, 0.141675367951393, 0.141371428966522, 0.141068175435066, 0.140765279531479, 0.140462622046471, 0.140160456299782, 0.139858648180962, 0.139557301998138, 0.139255970716476, 0.138955399394035, 0.138655200600624, 0.13835534453392, 0.138055920600891, 0.137756749987602, 0.137458071112633, 0.137159824371338, 0.136861562728882, 0.13656410574913, 0.136266887187958, 0.135970145463943, 0.135673731565475, 0.135377734899521, 0.135082110762596, 0.13478684425354, 0.134491756558418, 0.134197294712067, 0.13390326499939, 0.133609458804131, 0.133316203951836, 0.133023336529732, 0.132730633020401, 0.13243855535984, 0.132146656513214, 0.13185527920723, 0.131564363837242, 0.131273612380028, 0.130983486771584, 0.130693480372429, 0.130404010415077, 0.130114793777466, 0.129826128482819, 0.129537954926491, 0.129249900579453, 0.128962337970734, 0.128675132989883, 0.128388419747353, 0.128102019429207, 0.12781597673893, 0.127530351281166, 0.127245053648949, 0.126960173249245, 0.126675665378571, 0.126391708850861, 0.126108050346375, 0.125824630260468, 0.125541761517525, 0.125259146094322, 0.124976955354214, 0.124695137143135, 0.124413803219795, 0.124132946133614, 0.123852223157883, 0.123571984469891, 0.123292051255703, 0.12301266938448, 0.122733414173126, 0.122454881668091, 0.122176602482796, 0.121898621320724, 0.121621139347553, 0.121343888342381, 0.121067255735397, 0.120790868997574, 0.120514720678329, 0.120239190757275, 0.119963899254799, 0.119689092040062, 0.11941459774971, 0.119140595197678, 0.11886689811945, 0.118593499064445, 0.118320651352406, 0.118048116564751, 0.117775991559029, 0.117504253983498, 0.117232874035835, 0.116961851716042, 0.116691149771214, 0.116421058773994, 0.116151139140129, 0.115881770849228, 0.115612715482712, 0.11534383893013, 0.115075692534447, 0.114807672798634, 0.114540264010429, 0.114273220300674, 0.114006415009499, 0.113740116357803, 0.113473854959011, 0.113208346068859, 0.112943194806576, 0.112678408622742, 0.112414047122002, 0.112149938941002, 0.111886188387871, 0.11162281781435, 0.111359991133213, 0.1110974624753, 0.110835433006287, 0.110573694109917, 0.110312335193157, 0.110051460564137, 0.109790585935116, 0.109530501067638, 0.109270669519901, 0.109011255204678, 0.108752340078354, 0.108493603765965, 0.108235411345959, 0.107977472245693, 0.107719838619232, 0.107462808489799, 0.107206031680107, 0.106949791312218, 0.106693744659424, 0.106438241899014, 0.106183059513569, 0.105928227305412, 0.105673760175705, 0.105419732630253, 0.105166122317314, 0.10491281747818, 0.104660004377365, 0.104407504200935, 0.104155302047729, 0.103903718292713, 0.103652246296406, 0.103401385247707, 0.103150710463524, 0.102900587022305, 0.102650836110115, 0.102401316165924, 0.102152355015278, 0.101903632283211, 0.101655460894108, 0.101407594978809, 0.101159974932671, 0.100913032889366, 0.100666262209415, 0.100420050323009, 0.100173957645893, 0.0999284163117409, 0.0996833071112633, 0.0994384288787842, 0.0991941094398499, 0.0989499613642693, 0.098706379532814, 0.0984632149338722, 0.0982202962040901, 0.0979779288172722, 0.0977358743548393, 0.0974939838051796, 0.0972526594996452, 0.0970117598772049, 0.0967712327837944, 0.0965311154723167, 0.0962913185358047, 0.0960518792271614, 0.0958129987120628, 0.0955741703510284, 0.0953361392021179, 0.0950982943177223, 0.094860814511776, 0.0946236997842789, 0.0943868905305862, 0.0941506922245026, 0.093914620578289, 0.0936790928244591, 0.0934441164135933, 0.0932091996073723, 0.0929748341441154, 0.0927407741546631, 0.0925072655081749, 0.0922739952802658, 0.092041090130806, 0.0918087437748909, 0.0915766432881355, 0.0913450196385384, 0.0911135822534561, 0.0908827632665634, 0.0906522497534752, 0.0904220417141914, 0.0901924297213554, 0.0899630188941956, 0.0897339656949043, 0.0895051583647728, 0.0892769619822502, 0.0890493169426918, 0.0888217240571976, 0.0885948091745377, 0.0883680805563927, 0.0881418436765671, 0.0879158452153206, 0.0876902192831039, 0.0874651893973351, 0.0872404202818871, 0.0870161280035973, 0.0867920219898224, 0.0865685939788818, 0.0863452851772308, 0.0861224606633186, 0.0859001278877258, 0.085677906870842, 0.0854563191533089, 0.0852350816130638, 0.0850140973925591, 0.0847938358783722, 0.0845733433961868, 0.0843538120388985, 0.0841343551874161, 0.0839154422283173, 0.0836968943476677, 0.0834787115454674, 0.0832609087228775, 0.0830434560775757, 0.0828263759613037, 0.0826096013188362, 0.0823933854699135, 0.0821776390075684, 0.0819620862603188, 0.0817469581961632, 0.0815322026610374, 0.081317812204361, 0.0811038464307785, 0.0808902457356453, 0.0806772038340569, 0.0804643929004669, 0.0802519023418427, 0.0800398290157318, 0.0798282399773598, 0.0796169638633728, 0.0794060528278351, 0.0791956260800362, 0.0789855197072029, 0.0787757039070129, 0.0785662531852722, 0.0783573612570763, 0.0781489610671997, 0.0779406130313873, 0.0777329355478287, 0.0775253847241402, 0.0773183777928352, 0.0771118104457855, 0.0769054740667343, 0.0766997635364532, 0.0764942839741707, 0.0762891173362732, 0.0760841891169548, 0.0758799389004707, 0.0756761729717255, 0.0754726007580757, 0.075269378721714, 0.0750666558742523, 0.0748642310500145, 0.0746621116995811, 0.0744604915380478, 0.0742592960596085, 0.0740584060549736, 0.0738580524921417, 0.0736579522490501, 0.073458157479763, 0.0732589140534401, 0.0730599164962769, 0.0728613436222076, 0.0726630836725235, 0.0724654793739319, 0.0722680687904358, 0.0720709562301636, 0.0718745291233063, 0.0716781541705132, 0.0714823305606842, 0.071286752820015, 0.0710918456315994, 0.0708970576524734, 0.0707027614116669, 0.0705088898539543, 0.0703152045607567, 0.0701220706105232, 0.069929301738739, 0.0697370693087578, 0.0695449784398079, 0.0693534910678864, 0.0691622495651245, 0.0689711272716522, 0.0687808692455292, 0.0685907825827599, 0.0684011280536652, 0.0682119056582451, 0.0680228620767593, 0.0678343623876572, 0.0676460564136505, 0.0674583539366722, 0.0672708973288536, 0.067084051668644, 0.0668975114822388, 0.0667112693190575, 0.0665254145860672, 0.0663399696350098, 0.0661548301577568, 0.0659701824188232, 0.0657859072089195, 0.0656021162867546, 0.065418504178524, 0.0652355030179024, 0.0650525763630867, 0.064870186150074, 0.0646883547306061, 0.0645066350698471, 0.0643255338072777, 0.0641446113586426, 0.063964307308197, 0.0637843012809753, 0.0636044815182686, 0.0634252652525902, 0.0632463619112968, 0.0630678236484528, 0.0628895312547684, 0.0627120360732079, 0.0625345930457115, 0.0623575821518898, 0.0621809996664524, 0.0620047822594643, 0.0618290528655052, 0.0616535693407059, 0.0614785738289356, 0.0613038279116154, 0.0611296221613884, 0.0609557256102562, 0.0607851855456829, 0.0606197230517864, 0.0604543760418892, 0.0602893978357315, 0.0601246058940887, 0.05995998904109, 0.0597958080470562, 0.0596316233277321, 0.0594678074121475, 0.0593043565750122, 0.0591410249471664, 0.0589779987931252, 0.0588152222335339, 0.0586527474224567, 0.058490339666605, 0.058328352868557, 0.0581666715443134, 0.0580049306154251, 0.0578438602387905, 0.0576826073229313, 0.0575219057500362, 0.0573615059256554, 0.0572011061012745, 0.0570411421358585, 0.0568812303245068, 0.0567217543721199, 0.0565624535083771, 0.0564035251736641, 0.0562447719275951, 0.0560861490666866, 0.0559280104935169, 0.0557698756456375, 0.0556121058762074, 0.0554545745253563, 0.0552973560988903, 0.0551403164863586, 0.0549835227429867, 0.0548270381987095, 0.0546706654131413, 0.0545147284865379, 0.0543589144945145, 0.0542034059762955, 0.0540483221411705, 0.0538932383060455, 0.0537384562194347, 0.053583987057209, 0.0534297004342079, 0.0532757118344307, 0.0531219728291035, 0.0529684796929359, 0.0528151653707027, 0.0526622831821442, 0.0525094009935856, 0.0523569397628307, 0.0522047877311707, 0.0520527027547359, 0.0519009754061699, 0.0517494976520538, 0.0515982583165169, 0.0514472723007202, 0.0512964650988579, 0.0511460825800896, 0.0509958267211914, 0.0508458726108074, 0.0506961010396481, 0.0505465194582939, 0.0503974184393883, 0.0502483211457729, 0.0500997714698315, 0.0499511659145355, 0.0498029850423336, 0.0496550463140011, 0.0495072342455387, 0.0493597835302353, 0.0492124557495117, 0.0490656197071075, 0.0489188469946384, 0.0487723760306835, 0.0486262738704681, 0.0484802275896072, 0.0483345538377762, 0.0481889955699444, 0.0480438061058521, 0.0478987991809845, 0.0477541014552116, 0.0476097092032433, 0.0474654994904995, 0.0473215281963348, 0.0471776872873306, 0.0470343865454197, 0.0468910932540894, 0.0467481687664986, 0.0466055423021317, 0.0464629866182804, 0.0463208518922329, 0.0461788363754749, 0.0460371933877468, 0.0458957888185978, 0.045754574239254, 0.0456136576831341, 0.0454728044569492, 0.0453324466943741, 0.0451922044157982, 0.0450523272156715, 0.0449126996099949, 0.0447731949388981, 0.0446340516209602, 0.0444950945675373, 0.0443564429879189, 0.0442180298268795, 0.0440798066556454, 0.0439419485628605, 0.0438041500747204, 0.0436667799949646, 0.0435294695198536, 0.0433927141129971, 0.043256014585495, 0.0431195013225079, 0.0429834127426147, 0.0428474508225918, 0.0427117273211479, 0.0425763726234436, 0.0424412041902542, 0.0423062779009342, 0.0421716533601284, 0.0420372150838375, 0.0419029667973518, 0.0417691357433796, 0.0416354909539223, 0.0415019690990448, 0.0413689352571964, 0.0412359610199928, 0.041103295981884, 0.0409708730876446, 0.0408387556672096, 0.0407068841159344, 0.0405751951038837, 0.0404438078403473, 0.040312547236681, 0.0401817746460438, 0.0400510020554066, 0.0399206578731537, 0.0397906787693501, 0.0396606363356113, 0.039531085640192, 0.0394015945494175, 0.0392724722623825, 0.0391435921192169, 0.039014957845211, 0.0388866253197193, 0.0387583561241627, 0.0386305749416351, 0.0385028570890427, 0.0383755043148994, 0.0382484570145607, 0.038121473044157, 0.0379949100315571, 0.0378684736788273, 0.0377423465251923, 0.0376165769994259, 0.0374908782541752, 0.0373655408620834, 0.0372403264045715, 0.0371154733002186, 0.0369908101856709, 0.0368665717542171, 0.0367424003779888, 0.0366185232996941, 0.0364949591457844, 0.0363714545965195, 0.0362483784556389, 0.0361254811286926, 0.0360029563307762, 0.0358806140720844, 0.035758450627327, 0.0356366559863091, 0.0355149246752262, 0.0353936813771725, 0.0352724939584732, 0.0351516157388687, 0.0350311659276485, 0.0349107161164284, 0.034790575504303, 0.0346707291901112, 0.0345511361956596, 0.0344318449497223, 0.0343127362430096, 0.0341939367353916, 0.0340752564370632, 0.0339570045471191, 0.0338387563824654, 0.0337210521101952, 0.0336034707725048, 0.0334860160946846, 0.0333690419793129, 0.0332521349191666, 0.0331355333328247, 0.0330193005502224, 0.0329031236469746, 0.0327873788774014, 0.0326718129217625, 0.0325564295053482, 0.0324412956833839, 0.0323264636099339, 0.0322120562195778, 0.0320975929498672, 0.0319835543632507, 0.0318697020411491, 0.031756155192852, 0.0316429100930691, 0.0315297283232212, 0.0314169749617577, 0.0313043408095837, 0.0311920754611492, 0.0310798697173595, 0.0309682171791792, 0.0308566223829985, 0.0307452734559774, 0.0306342281401157, 0.0305233672261238, 0.0304128732532263, 0.0303025022149086, 0.030192494392395, 0.0300827324390411, 0.0299730952829123, 0.0298638194799423, 0.0297547932714224, 0.0296460092067719, 0.029537346214056, 0.0294291116297245, 0.0293211210519075, 0.0292132534086704, 0.0291058123111725, 0.0289983712136745, 0.0288914199918509, 0.0287846494466066, 0.0286780670285225, 0.0285718478262424, 0.0284656882286072, 0.0283600203692913, 0.0282544121146202, 0.0281491093337536, 0.0280441734939814, 0.0279392376542091, 0.0278347283601761, 0.0277304630726576, 0.0276265051215887, 0.0275227911770344, 0.0274191368371248, 0.0273159705102444, 0.0272128693759441, 0.027110131457448, 0.0270075164735317, 0.0269052665680647, 0.0268033854663372, 0.0267014410346746, 0.026600107550621, 0.0264987163245678, 0.0263977497816086, 0.0262969061732292, 0.0261963699012995, 0.0260961931198835, 0.0259961448609829, 0.0258964002132416, 0.02579683996737, 0.0256976447999477, 0.0255985725671053, 0.0254998058080673, 0.0254014059901237, 0.0253031272441149, 0.0252050943672657, 0.0251073036342859, 0.0250098798424006, 0.0249126385897398, 0.0248156450688839, 0.0247188918292522, 0.0246222633868456, 0.0245261825621128, 0.0244300421327353, 0.024334330111742, 0.0242389850318432, 0.0241435747593641, 0.0240486580878496, 0.0239539220929146, 0.0238594897091389, 0.0237652417272329, 0.0236712414771318, 0.023577481508255, 0.0234839674085379, 0.02339081838727, 0.0232977941632271, 0.0232050120830536, 0.0231126602739096, 0.0230203680694103, 0.0229283794760704, 0.0228366367518902, 0.0227452013641596, 0.0226539447903633, 0.0225629955530167, 0.0224722921848297, 0.0223817713558674, 0.0222916770726442, 0.0222015827894211, 0.0221119187772274, 0.0220226179808378, 0.0219331961125135, 0.0218442641198635, 0.0217555724084377, 0.0216671302914619, 0.0215788688510656, 0.0214909128844738, 0.0214032623916864, 0.0213157329708338, 0.0212286338210106, 0.0211415328085423, 0.021054919809103, 0.0209683701395988, 0.0208822470158339, 0.0207964293658733, 0.0207105483859777, 0.0206251591444016, 0.02053995244205, 0.0204549878835678, 0.0203703921288252, 0.0202858578413725, 0.0202016867697239, 0.0201177019625902, 0.0200341437011957, 0.0199505873024464, 0.0198674537241459, 0.0197845697402954, 0.0197018049657345, 0.0196194089949131, 0.0195371937006712, 0.019455224275589, 0.019373681396246, 0.0192921999841928, 0.0192110240459442, 0.0191300921142101, 0.0190494656562805, 0.0189689006656408, 0.0188887026160955, 0.0188089311122894, 0.018729280680418, 0.0186498779803514, 0.0185705944895744, 0.018491679802537, 0.0184129476547241, 0.0183346420526505, 0.0182564593851566, 0.0181785207241774, 0.0181008875370026, 0.0180233754217625, 0.0179463513195515, 0.0178694538772106, 0.0177927352488041, 0.0177163239568472, 0.0176401566714048, 0.017564233392477, 0.0174885541200638, 0.0174132436513901, 0.017338115721941, 0.0172632299363613, 0.0171885900199413, 0.017114132642746, 0.0170400403439999, 0.0169660113751888, 0.016892408952117, 0.0168191734701395, 0.016745937988162, 0.0166730079799891, 0.0166003853082657, 0.0165280047804117, 0.0164559297263622, 0.0163839161396027, 0.0163122676312923, 0.0162409245967865, 0.0161698888987303, 0.016098914667964, 0.0160283036530018, 0.0159580018371344, 0.0158877596259117, 0.0158179420977831, 0.0157481897622347, 0.0156789869070053, 0.0156097207218409, 0.0155409434810281, 0.0154723506420851, 0.0154039403423667, 0.0153357749804854, 0.0152678536251187, 0.0152002368122339, 0.0151330484077334, 0.0150658609345555, 0.0149990385398269, 0.0149323381483555, 0.0148660046979785, 0.0147997932508588, 0.0147340716794133, 0.01466847024858, 0.0146031156182289, 0.0145380031317472, 0.0144730135798454, 0.0144085120409727, 0.0143441334366798, 0.0142799988389015, 0.0142162926495075, 0.014152585528791, 0.0140893068164587, 0.0140262087807059, 0.0139632970094681, 0.0139008117839694, 0.0138384476304054, 0.0137763908132911, 0.0137143936008215, 0.0136528247967362, 0.0135914999991655, 0.0135304192081094, 0.0134696448221803, 0.0134090529754758, 0.0133486436679959, 0.0132885407656431, 0.0132287433370948, 0.013169189915061, 0.0131099419668317, 0.0130508160218596, 0.0129919350147247, 0.0129334796220064, 0.0128750875592232, 0.0128170000389218, 0.012759156525135, 0.0127014964818954, 0.0126442033797503, 0.012587214820087, 0.0125303491950035, 0.0124737890437245, 0.01241753436625, 0.0123614612966776, 0.0123055120930076, 0.0122501123696566, 0.0121945897117257, 0.0121397394686937, 0.0120849497616291, 0.0120302829891443, 0.0119760446250439, 0.0119218658655882, 0.0118681769818068, 0.0118144862353802, 0.0117612248286605, 0.0117083285003901, 0.0116554945707321, 0.0116029037162662, 0.0115505577996373, 0.0114986393600702, 0.0114467209205031, 0.0113951088860631, 0.0113439224660397, 0.0112928589805961, 0.0112421624362469, 0.011191587895155, 0.0111412573605776, 0.0110912332311273, 0.0110414521768689, 0.0109919169917703, 0.0109425010159612, 0.0108936987817287, 0.0108447121456265, 0.010796214453876, 0.0107480827718973, 0.0106998905539513, 0.010652125813067, 0.0106045445427299, 0.010557328350842, 0.0105103580281138, 0.0104636317119002, 0.0104170888662338, 0.0103707276284695, 0.0103247947990894, 0.0102789234369993, 0.0102334804832935, 0.0101882200688124, 0.0101431412622333, 0.010098491795361, 0.0100538423284888, 0.0100096808746457, 0.00996552035212517, 0.00992190837860107, 0.00987835787236691, 0.00983499083667994, 0.00979217328131199, 0.00974935572594404, 0.00970684457570314, 0.00966457650065422, 0.00962261389940977, 0.0095808357000351, 0.00953924003988504, 0.00949800945818424, 0.00945708621293306, 0.00941634550690651, 0.00937591027468443, 0.00933341030031443, 0.00928909610956907, 0.00924487505108118, 0.00920071266591549, 0.00915664341300726, 0.00911271199584007, 0.00906887091696262, 0.00902502983808517, 0.00898146536201239, 0.00893791485577822, 0.0088944248855114, 0.00885111931711435, 0.00880787428468466, 0.00876475125551224, 0.0087217204272747, 0.00867884233593941, 0.00863602384924889, 0.00859323795884848, 0.008550725877285, 0.00850819796323776, 0.00846570078283548, 0.00842343457043171, 0.00838119629770517, 0.00833908189088106, 0.00829715002328157, 0.00825524888932705, 0.00821342412382364, 0.00817172229290009, 0.00813018716871738, 0.00808866694569588, 0.00804733112454414, 0.0080060251057148, 0.00796487275511026, 0.00792382657527924, 0.00788284093141556, 0.00784197822213173, 0.00780123798176646, 0.00776052754372358, 0.00772003177553415, 0.00767953600734472, 0.00763920694589615, 0.00759893981739879, 0.00755887106060982, 0.00751877203583717, 0.00747893191874027, 0.00743904616683722, 0.0073992982506752, 0.00735965697094798, 0.007320168428123, 0.00728074088692665, 0.00724137527868152, 0.00720216147601604, 0.00716306967660785, 0.00712413107976317, 0.00708520784974098, 0.00704637542366982, 0.00700765009969473, 0.00696904771029949, 0.00693056732416153, 0.00689223920926452, 0.00685389526188374, 0.00681573571637273, 0.006777698174119, 0.00673965970054269, 0.00670179072767496, 0.00666404236108065, 0.00662632565945387, 0.00658876122906804, 0.00655130296945572, 0.00651401421055198, 0.00647673942148685, 0.00643954146653414, 0.00640248088166118, 0.00636551156640053, 0.00632877182215452, 0.00629197107627988, 0.00625529233366251, 0.0062187509611249, 0.00618236232548952, 0.00614598859101534, 0.00610985979437828, 0.00607363926246762, 0.00603763200342655, 0.00600174767896533, 0.00596595369279385, 0.00593019183725119, 0.00589461252093315, 0.00585906347259879, 0.00582369836047292, 0.00578842405229807, 0.00575318047776818, 0.00571805937215686, 0.00568309053778648, 0.00564818317070603, 0.00561351981014013, 0.00557882618159056, 0.00554423918947577, 0.00550966802984476, 0.00547535624355078, 0.00544105935841799, 0.00540697667747736, 0.00537283252924681, 0.00533890258520842, 0.00530506437644362, 0.0052712862379849, 0.00523760076612234, 0.0052040982991457, 0.00517062610015273, 0.005137306638062, 0.00510404817759991, 0.00507094291970134, 0.00503785256296396, 0.00500497547909617, 0.00497214496135712, 0.00493942154571414, 0.00490681920200586, 0.00487426342442632, 0.00484182965010405, 0.0048095490783453, 0.0047773290425539, 0.00474521610885859, 0.00471322517842054, 0.0046812491491437, 0.00464954879134893, 0.00461784796789289, 0.00458625424653292, 0.00455473689362407, 0.00452328007668257, 0.00449215993285179, 0.00446093268692493, 0.00442978134378791, 0.00439890520647168, 0.00436802906915545, 0.00433724420145154, 0.00430661253631115, 0.0042760418727994, 0.00424548611044884, 0.00421520601958036, 0.0041849403642118, 0.00415475154295564, 0.0041248369961977, 0.0040948772802949, 0.00406497810035944, 0.00403524748980999, 0.00400559278205037, 0.00397604517638683, 0.00394668104127049, 0.00391730107367039, 0.003888089209795, 0.00385901518166065, 0.0038300019223243, 0.00380108039826155, 0.00377225037664175, 0.00374360359273851, 0.00371498754248023, 0.00368650886230171, 0.00365802994929254, 0.00362971937283874, 0.00360159180127084, 0.00357349473051727, 0.00354548939503729, 0.00351766706444323, 0.00348984519951046, 0.00346214510500431, 0.00343456724658608, 0.00340711162425578, 0.00337983900681138, 0.00335255125537515, 0.00332535547204316, 0.00329823582433164, 0.00327145191840827, 0.00324448477476835, 0.00321771646849811, 0.00319103966467083, 0.0031645002309233, 0.00313817453570664, 0.00311180274002254, 0.00308549264445901, 0.00305947242304683, 0.00303337536752224, 0.00300746224820614, 0.00298159476369619, 0.00295587978325784, 0.00293025653809309, 0.00290487776510417, 0.00287934625521302, 0.00285399775020778, 0.0028289242181927, 0.00280382018536329, 0.00277877715416253, 0.00275387172587216, 0.00272907293401659, 0.00270433537662029, 0.00267985742539167, 0.00265534874051809, 0.00263093179091811, 0.00260674417950213, 0.00258252560161054, 0.00255847512744367, 0.00253445538692176, 0.00251060351729393, 0.00248693488538265, 0.00246320501901209, 0.00243959738872945, 0.00241614249534905, 0.00239285570569336, 0.00236962991766632, 0.00234644976444542, 0.00232339184731245, 0.00230047130025923, 0.00227764272131026, 0.00225487491115928, 0.00223219906911254, 0.00220981286838651, 0.0021873963996768, 0.00216504093259573, 0.0021428382024169, 0.0021206506062299, 0.00209873798303306, 0.0020767489913851, 0.00205497397109866, 0.00203325971961021, 0.00201175967231393, 0.0019902135245502, 0.00196885061450303, 0.00194753345567733, 0.00192636915016919, 0.00190520484466106, 0.00188419315963984, 0.00186334946192801, 0.00184262788388878, 0.00182201329153031, 0.0018013680819422, 0.00178093672730029, 0.00176065787672997, 0.00174037925899029, 0.00172014639247209, 0.00170003564562649, 0.00168006238527596, 0.00166025699581951, 0.00164061959367245, 0.0016209518071264, 0.00160129903815687, 0.00158198247663677, 0.00156263506505638, 0.00154341012239456, 0.00152424606494606, 0.00150521961040795, 0.00148626929149032, 0.00146754819434136, 0.00144878134597093, 0.00143009063322097, 0.00141169014386833, 0.00139328965451568, 0.00137496565002948, 0.00135679414961487, 0.00133868376724422, 0.00132071098778397, 0.00130276847630739, 0.00128499406855553, 0.00126734178047627, 0.00124981184490025, 0.00123232742771506, 0.00121488911099732, 0.00119760329835117, 0.00118042435497046, 0.00116341351531446, 0.00114643317647278, 0.00112954434007406, 0.00111288472544402, 0.00109622499439865, 0.00107970274984837, 0.00106315000448376, 0.00104681099765003, 0.00103062472771853, 0.00101453007664531, 0.000998374191112816, 0.000982462777756155, 0.000966719235293567, 0.000951006251852959, 0.000935369695071131, 0.000919809506740421, 0.000904463115148246, 0.000889131857547909, 0.000873846409376711, 0.000858759565744549, 0.000843779649585485, 0.000828876043669879, 0.00081409455742687, 0.000799389381427318, 0.000784867559559643, 0.00077028467785567, 0.000755915476474911, 0.00074162264354527, 0.000727406179066747, 0.00071331177605316, 0.000699477095622569, 0.000685611856169999, 0.000671731366310269, 0.00065814092522487, 0.000644611602183431, 0.000631128204986453, 0.000617659941781312, 0.000604435976129025, 0.000591379997786134, 0.000578339386265725, 0.000565283466130495, 0.000552456534933299, 0.000539812841452658, 0.000527153897564858, 0.000514617131557316, 0.000502217910252512, 0.000489788013510406, 0.000477632973343134, 0.000465539080323651, 0.000453491025837138, 0.000441687152488157, 0.00042979174759239, 0.000418110139435157, 0.000406443752581254, 0.000394975912058726, 0.000383538543246686, 0.000372360926121473, 0.000361060985596851, 0.000349974900018424, 0.000339072110364214, 0.00032823026413098, 0.00031735806260258, 0.000306668953271583, 0.000296040874673054, 0.000285550428088754, 0.000275212456472218, 0.000264951027929783, 0.000254750630119815, 0.000244855531491339, 0.000234868814004585, 0.000224973846343346, 0.000215262058191001, 0.000205519725568593, 0.000196052307728678, 0.000186615332495421, 0.000177270063431934, 0.000167970545589924, 0.000158945942530409, 0.000149890722241253, 0.000140957781695761, 0.000132101064082235, 0.000123427671496756, 0.000114784772449639, 0.000106264029454906, 9.78349999058992e-05, 8.95280682016164e-05, 8.14348895801231e-05, 7.32501066522673e-05, 6.52180315228179e-05, 5.7399709476158e-05, 4.96120010211598e-05, 4.18853378505446e-05, 3.42502753483132e-05, 2.67679188254988e-05, 1.95298689504853e-05, 1.22307710626046e-05, 5.05382604387705e-06, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15, 8.05654879561159e-15   }, 
}; 

// background map
float ReadLikelihoodPCA::fRefB[][10000] = 
{ 
   { 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 1.7504932e-07, 4.4512538e-07, 7.5521297e-07, 1.0753031e-06, 1.4254019e-06, 1.7855035e-06, 2.1756136e-06, 2.5857291e-06, 3.0158499e-06, 3.4559748e-06, 3.9261067e-06, 4.4162443e-06, 4.9213877e-06, 5.4415332e-06, 6.0016932e-06, 6.576854e-06, 7.1670206e-06, 7.7671893e-06, 8.407369e-06, 9.0625554e-06, 9.7127386e-06, 1.0417937e-05, 1.1138142e-05, 1.1878348e-05, 1.2618558e-05, 1.339878e-05, 1.4199002e-05, 1.5029237e-05, 1.5844469e-05, 1.6699709e-05, 1.7584958e-05, 1.8490216e-05, 1.9390467e-05, 2.0340736e-05, 2.1296004e-05, 2.229629e-05, 2.3276567e-05, 2.4301853e-05, 2.5347148e-05, 2.6422455e-05, 2.7487751e-05, 2.8593069e-05, 2.9723386e-05, 3.0843697e-05, 3.2024032e-05, 3.3214368e-05, 3.4434714e-05, 3.5625049e-05, 3.6895406e-05, 3.8165763e-05, 3.9456125e-05, 4.0746494e-05, 4.2086871e-05, 4.3437256e-05, 4.4797638e-05, 4.6193032e-05, 4.7618436e-05, 4.9048838e-05, 5.0499242e-05, 5.1954656e-05, 5.346008e-05, 5.4980505e-05, 5.650094e-05, 5.8061378e-05, 5.9631817e-05, 6.1242266e-05, 6.284273e-05, 6.4483189e-05, 6.6133653e-05, 6.7844136e-05, 6.9514615e-05, 7.1235096e-05, 7.2975585e-05, 7.4726078e-05, 7.6516582e-05, 7.8322089e-05, 8.014762e-05, 8.1973129e-05, 8.3848659e-05, 8.5739179e-05, 8.7639717e-05, 8.955026e-05, 9.1510818e-05, 9.3471368e-05, 9.5461925e-05, 9.7452496e-05, 9.9493074e-05, 0.00010153364, 0.00010361423, 0.00010567481, 0.00010779042, 0.00010992601, 0.00011208661, 0.00011423723, 0.00011643786, 0.00011865848, 0.0001208741, 0.00012312473, 0.00012540037, 0.00012771104, 0.00013003168, 0.00013234233, 0.00013470299, 0.00013708867, 0.00013947434, 0.00014188503, 0.00014433572, 0.00014678641, 0.0001492571, 0.0001517678, 0.00015428354, 0.00015681924, 0.00015938496, 0.00016197069, 0.00016456142, 0.00016717217, 0.00016983293, 0.00017247366, 0.00017517443, 0.00017787519, 0.00018059595, 0.00018335672, 0.00018611751, 0.0001888983, 0.00019169909, 0.0001945399, 0.00019737569, 0.0002002415, 0.00020312732, 0.00020603313, 0.00020896895, 0.00021191478, 0.00021490564, 0.00021787648, 0.00022088732, 0.00022392817, 0.00022697904, 0.0002300499, 0.00023313078, 0.00023626167, 0.00023938253, 0.00024254844, 0.00024572431, 0.00024892524, 0.00025214112, 0.00025536705, 0.00025863797, 0.00026190392, 0.00026520985, 0.00026853077, 0.0002718617, 0.00027523265, 0.00027860361, 0.00028201457, 0.00028542551, 0.00028886649, 0.00029232749, 0.00029580848, 0.00029931945, 0.00030283045, 0.00030640647, 0.00030995245, 0.00031355349, 0.00031714948, 0.00032077552, 0.00032441653, 0.00032809758, 0.0003317786, 0.00033547968, 0.0003392107, 0.00034297176, 0.00034674283, 0.00035052389, 0.00035433497, 0.00035817106, 0.00036202715, 0.00036589825, 0.00036979432, 0.00037369045, 0.00037764158, 0.00038158268, 0.00038557878, 0.00038955489, 0.00039359104, 0.00039761217, 0.00040168833, 0.00040575949, 0.00040984561, 0.00041397681, 0.00041810295, 0.00042228415, 0.00042645031, 0.00043066652, 0.00043487272, 0.0004391289, 0.00044338009, 0.00044766627, 0.00045196252, 0.00045629375, 0.000460635, 0.00046499618, 0.00046937744, 0.00047379872, 0.00047821991, 0.00048268121, 0.00048713243, 0.00049163372, 0.00049613498, 0.00050065626, 0.00050521758, 0.00050976884, 0.00051438011, 0.00051898143, 0.00052362273, 0.00052827405, 0.0005329554, 0.0005376467, 0.00054234802, 0.00054708938, 0.0005518407, 0.00055662199, 0.00056141341, 0.00056622474, 0.00057106611, 0.00057592749, 0.00058080885, 0.00058570027, 0.00059063663, 0.00059556303, 0.00060051441, 0.00060550583, 0.00061049726, 0.00061552867, 0.00062056008, 0.0006256316, 0.00063072296, 0.0006358294, 0.00064094085, 0.00064609729, 0.00065124879, 0.00065644528, 0.00066165172, 0.00066687819, 0.00067212462, 0.00067738618, 0.0006826676, 0.00068799418, 0.00069331063, 0.00069867214, 0.0007040287, 0.00070941512, 0.0007148367, 0.00072026829, 0.00072573975, 0.00073119631, 0.00073669787, 0.00074219942, 0.00074775104, 0.00075329258, 0.00075888913, 0.00076447072, 0.00077008229, 0.00077572389, 0.0007813804, 0.00078705704, 0.00079275866, 0.00079848029, 0.0008042219, 0.00080997351, 0.00081576518, 0.00082155684, 0.00082736852, 0.00083322014, 0.00083907176, 0.00084496342, 0.00085087004, 0.00085680682, 0.00086273847, 0.00086871511, 0.00087469182, 0.00088071346, 0.00088674016, 0.00089276693, 0.00089885364, 0.00090492039, 0.00091105211, 0.0009171688, 0.00092333555, 0.00092949724, 0.00093567907, 0.00094189582, 0.00094812247, 0.00095438433, 0.00096065603, 0.00096694782, 0.00097326469, 0.00097959139, 0.00098595314, 0.00099232502, 0.00099872681, 0.0010051436, 0.0010115805, 0.0010180422, 0.0010245042, 0.0010310259, 0.0010375227, 0.0010440846, 0.0010506365, 0.0010572233, 0.0010638202, 0.0010704522, 0.0010770889, 0.0010837357, 0.0010904328, 0.0010971245, 0.0011038615, 0.0011105933, 0.0011173603, 0.0011241521, 0.0011309542, 0.0011377861, 0.0011446279, 0.0011515099, 0.0011583919, 0.0011652939, 0.0011722308, 0.0011791777, 0.0011861597, 0.0011931417, 0.0012001587, 0.0012071856, 0.0012142475, 0.0012213195, 0.0012284116, 0.0012355336, 0.0012426607, 0.0012498175, 0.0012569898, 0.0012641917, 0.0012714087, 0.0012786308, 0.0012858979, 0.0012931699, 0.001300472, 0.001307784, 0.0013151212, 0.0013224882, 0.0013298653, 0.0013372924, 0.0013446944, 0.0013521566, 0.0013595987, 0.0013671058, 0.0013745979, 0.001382135, 0.0013896672, 0.0013972293, 0.0014048214, 0.0014124236, 0.0014200557, 0.0014276979, 0.0014353701, 0.0014430622, 0.0014507644, 0.0014584966, 0.0014662438, 0.001474006, 0.0014818031, 0.0014896053, 0.0014974575, 0.0015052997, 0.001513192, 0.0015210642, 0.0015289965, 0.0015369087, 0.0015448909, 0.0015528533, 0.0015608354, 0.0015688727, 0.00157691, 0.0015849723, 0.0015930396, 0.0016011468, 0.0016092591, 0.0016174014, 0.0016255637, 0.0016337361, 0.0016419385, 0.0016501608, 0.001658403, 0.0016666653, 0.0016749526, 0.00168326, 0.0016915824, 0.0016999496, 0.0017082971, 0.0017166694, 0.0017250917, 0.0017335041, 0.0017419665, 0.0017504191, 0.0017589213, 0.0017674338, 0.0017759661, 0.0017845185, 0.001793091, 0.0018016833, 0.0018102909, 0.0018189233, 0.0018275757, 0.0018362581, 0.0018449256, 0.001853648, 0.0018623855, 0.001871133, 0.0018799356, 0.0018887129, 0.0018975205, 0.0019063629, 0.0019152253, 0.0019241179, 0.0019329955, 0.001941943, 0.0019508604, 0.001959848, 0.0019688106, 0.0019778132, 0.0019868356, 0.0019958783, 0.0020049459, 0.0020140284, 0.0020231358, 0.0020322611, 0.0020413985, 0.0020505637, 0.0020597512, 0.0020689589, 0.0020781865, 0.002087424, 0.0020966991, 0.002105982, 0.0021152869, 0.0021246222, 0.0021339871, 0.0021433423, 0.00215275, 0.0021621652, 0.0021716028, 0.002181048, 0.0021905054, 0.0022000135, 0.0022095134, 0.0022190737, 0.0022286114, 0.0022382017, 0.0022477917, 0.0022574021, 0.0022670422, 0.0022766949, 0.0022863753, 0.002296088, 0.0023057982, 0.0023155434, 0.0023252936, 0.0023350841, 0.0023448817, 0.002354712, 0.0023645398, 0.0023744127, 0.0023843029, 0.0023941933, 0.0024041233, 0.0024140563, 0.0024240366, 0.0024340218, 0.0024440323, 0.0024540676, 0.0024641103, 0.0024741758, 0.0024842608, 0.0024943838, 0.0025045017, 0.0025146445, 0.0025248225, 0.0025350079, 0.0025452357, 0.0025554611, 0.0025657266, 0.0025759768, 0.0025862921, 0.0025965953, 0.0026069307, 0.0026172935, 0.0026276589, 0.0026380643, 0.00264847, 0.0026589152, 0.0026693733, 0.0026798588, 0.0026903567, 0.0027014723, 0.0027130756, 0.0027247088, 0.0027364222, 0.0027481355, 0.0027598687, 0.0027716821, 0.0027834952, 0.0027953689, 0.0028072521, 0.0028192154, 0.0028311587, 0.0028431623, 0.0028552157, 0.0028672891, 0.0028794226, 0.0028915459, 0.0029037492, 0.0029159528, 0.0029282065, 0.0029404999, 0.0029528434, 0.0029651867, 0.0029775901, 0.0029900337, 0.0030024974, 0.0030149908, 0.0030275243, 0.0030401277, 0.0030527415, 0.0030653749, 0.0030780686, 0.0030907921, 0.0031035258, 0.0031163194, 0.003129153, 0.0031420467, 0.0031549102, 0.0031678539, 0.0031808175, 0.0031938413, 0.003206885, 0.0032199686, 0.0032330723, 0.0032462061, 0.0032593997, 0.0032726035, 0.0032858872, 0.0032991711, 0.0033125049, 0.0033258684, 0.0033392524, 0.0033526761, 0.00336616, 0.0033796735, 0.0033932175, 0.0034067815, 0.0034204251, 0.0034340492, 0.0034477429, 0.0034614566, 0.0034752407, 0.0034890042, 0.0035028486, 0.0035167022, 0.0035305962, 0.0035445602, 0.0035584939, 0.003572528, 0.0035865821, 0.0036006561, 0.0036147598, 0.003628914, 0.0036430983, 0.0036573124, 0.0036715961, 0.00368587, 0.0037002042, 0.0037145584, 0.0037289725, 0.0037433964, 0.00375786, 0.0037723947, 0.0037869285, 0.0038015228, 0.0038161071, 0.0038307607, 0.0038454749, 0.0038601691, 0.0038749434, 0.0038897179, 0.003904572, 0.0039194259, 0.0039343303, 0.0039492743, 0.0039642486, 0.0039792424, 0.003994287, 0.0040093814, 0.0040244954, 0.00403962, 0.0040548444, 0.0040700384, 0.0040853028, 0.0041005872, 0.0041159312, 0.0041312855, 0.0041467003, 0.0041621444, 0.004177609, 0.0041931327, 0.0042086579, 0.004224272, 0.0042398763, 0.0042555211, 0.0042711953, 0.0042869397, 0.004302694, 0.0043184785, 0.0043343334, 0.0043501877, 0.0043660719, 0.0043820064, 0.0043980111, 0.0044140154, 0.00443005, 0.0044461144, 0.0044622491, 0.0044783936, 0.0044945884, 0.0045107929, 0.0045270775, 0.0045433617, 0.0045597064, 0.0045760609, 0.0045924862, 0.0046089203, 0.0046253954, 0.0046419101, 0.0046584345, 0.0046750293, 0.0046916339, 0.0047083185, 0.0047249831, 0.0047417078, 0.0047584828, 0.0047752676, 0.0047920924, 0.0048089572, 0.0048258817, 0.0048428066, 0.0048597809, 0.0048767962, 0.004893851, 0.0049109356, 0.004928031, 0.0049452055, 0.0049623903, 0.0049796049, 0.0049968702, 0.0050141648, 0.00503152, 0.0050488748, 0.0050662896, 0.0050837249, 0.0051011997, 0.0051186946, 0.0051362393, 0.0051538348, 0.0051714494, 0.005189104, 0.0052067894, 0.0052245143, 0.0052422695, 0.0052600745, 0.0052779196, 0.0052957744, 0.0053136991, 0.0053316345, 0.0053495998, 0.0053676246, 0.0053856494, 0.0054037748, 0.0054218601, 0.0054400251, 0.0054582004, 0.0054764557, 0.0054947101, 0.0055129956, 0.0055313404, 0.0055497065, 0.0055681108, 0.0055865366, 0.0056050317, 0.0056235469, 0.0056420821, 0.0056606871, 0.0056792926, 0.005697968, 0.0057166233, 0.0057353685, 0.0057541239, 0.0057729087, 0.0057917642, 0.0058106296, 0.0058295452, 0.0058484706, 0.0058674859, 0.0058864807, 0.0059055267, 0.0059246118, 0.005943737, 0.0059628924, 0.0059820781, 0.0060012937, 0.0060205688, 0.0060398644, 0.0060591898, 0.0060785552, 0.0060979808, 0.0061174263, 0.0061368817, 0.0061564073, 0.006175953, 0.006195548, 0.0062151537, 0.0062348396, 0.0062545049, 0.0062742503, 0.006294006, 0.0063138218, 0.0063336673, 0.0063535026, 0.0063734483, 0.0063933739, 0.0064133494, 0.0064333552, 0.0064534312, 0.0064734966, 0.0064936024, 0.0065137981, 0.0065339739, 0.0065541998, 0.0065744454, 0.0065947808, 0.0066151065, 0.0066354722, 0.0066558882, 0.006676334, 0.0066967998, 0.0067173052, 0.0067378515, 0.0067584673, 0.0067790831, 0.0067997384, 0.0068204347, 0.0068411506, 0.0068619265, 0.0068827122, 0.0069035776, 0.0069244341, 0.00694534, 0.0069662752, 0.0069872714, 0.0070082778, 0.0070293332, 0.0070504299, 0.0070715458, 0.0070926817, 0.0071138968, 0.0071351337, 0.0071563898, 0.0071776859, 0.0071990215, 0.0072204177, 0.0072418135, 0.0072632497, 0.0072847451, 0.0073062619, 0.0073277983, 0.007349384, 0.00737102, 0.0073926756, 0.0074143624, 0.0074361181, 0.0074578742, 0.0074796705, 0.0075015067, 0.0075233933, 0.0075452896, 0.0075672353, 0.0075892312, 0.0076112379, 0.0076332842, 0.0076553603, 0.0076774862, 0.007699653, 0.0077218493, 0.0077440855, 0.0077663618, 0.0077886479, 0.0078109936, 0.0078333709, 0.0078557972, 0.0078782234, 0.0079007, 0.0079232054, 0.0079457825, 0.0079683689, 0.0079909759, 0.0080136517, 0.0080363574, 0.0080590844, 0.0080818301, 0.0081046466, 0.0081274929, 0.0081503699, 0.0081732757, 0.0081962124, 0.0082191993, 0.008242216, 0.008265282, 0.0082883686, 0.0083114859, 0.0083346423, 0.008357848, 0.0083810845, 0.008404321, 0.0084276581, 0.0084509943, 0.0084743518, 0.0084977774, 0.0085212244, 0.0085447114, 0.008568218, 0.0085917646, 0.0086153811, 0.0086389976, 0.0086626448, 0.0086863516, 0.008710078, 0.0087338537, 0.0087576509, 0.0087815076, 0.0088053849, 0.0088292714, 0.0088532278, 0.0088772252, 0.0089012412, 0.0089252796, 0.0089493953, 0.0089735026, 0.0089976788, 0.0090218559, 0.0090461224, 0.0090703694, 0.0090946769, 0.0091190133, 0.0091434103, 0.0091678062, 0.0091922637, 0.0092167407, 0.009241268, 0.0092658149, 0.0092904018, 0.0093150381, 0.0093396958, 0.0093643917, 0.0093891295, 0.0094139073, 0.0094387038, 0.009463531, 0.009488428, 0.0095133353, 0.0095382715, 0.0095632691, 0.0095882853, 0.0096133538, 0.0096384389, 0.0096635465, 0.0096887341, 0.0097139208, 0.0097391475, 0.0097644255, 0.0097897425, 0.0098150894, 0.0098404465, 0.0098658744, 0.009891321, 0.009916788, 0.0099423258, 0.0099678822, 0.0099934703, 0.010019097, 0.010044775, 0.010070471, 0.010096199, 0.010121967, 0.010147794, 0.010173622, 0.010199498, 0.010225405, 0.010251362, 0.01027736, 0.010303368, 0.010329435, 0.010355532, 0.01038165, 0.010407797, 0.010434015, 0.010460251, 0.010486519, 0.010512827, 0.010539184, 0.010565561, 0.010591969, 0.010618417, 0.010644904, 0.010671422, 0.010697979, 0.010724576, 0.010751204, 0.010777862, 0.010804549, 0.010831317, 0.010858075, 0.010884882, 0.010911729, 0.010938616, 0.010965524, 0.010992463, 0.011019479, 0.011046488, 0.011073534, 0.011100633, 0.01112778, 0.011154927, 0.011182135, 0.011209384, 0.011236641, 0.011263959, 0.011291286, 0.011318694, 0.011346092, 0.01137355, 0.011401038, 0.011428565, 0.011456112, 0.011483701, 0.011511348, 0.011539007, 0.011566704, 0.011594431, 0.01162223, 0.011650028, 0.011677866, 0.011705764, 0.011733681, 0.011761619, 0.011789607, 0.011817635, 0.011845692, 0.011873781, 0.011901909, 0.011930087, 0.011958284, 0.011986522, 0.012014781, 0.012043118, 0.012071447, 0.012099835, 0.012128253, 0.012156711, 0.012185199, 0.012213716, 0.012242285, 0.012270863, 0.012299511, 0.012328169, 0.012356888, 0.012385606, 0.012414383, 0.012443211, 0.01247206, 0.012500907, 0.012529846, 0.012558813, 0.012587792, 0.0126168, 0.012645878, 0.012674977, 0.012704105, 0.012733263, 0.012762481, 0.012791709, 0.012820988, 0.012850297, 0.012879634, 0.012909043, 0.012938431, 0.01296844, 0.012999638, 0.013030877, 0.013062135, 0.013093455, 0.013124804, 0.013156192, 0.013187622, 0.01321913, 0.013250609, 0.013282158, 0.013313747, 0.013345386, 0.013377074, 0.013408784, 0.013440533, 0.013472321, 0.013504141, 0.013536009, 0.013567949, 0.013599887, 0.013631877, 0.013663906, 0.013695995, 0.013728084, 0.013760223, 0.013792441, 0.013824661, 0.01385693, 0.013889248, 0.013921588, 0.013954007, 0.013986418, 0.014018896, 0.014051415, 0.014083935, 0.014116544, 0.014149204, 0.014181842, 0.014214571, 0.01424731, 0.014280111, 0.014312949, 0.014345787, 0.014378717, 0.014411667, 0.014444657, 0.014477696, 0.014510773, 0.014543874, 0.014577044, 0.014610193, 0.014643451, 0.014676721, 0.014710021, 0.01474338, 0.014776769, 0.014810199, 0.014843659, 0.014877178, 0.014910748, 0.014944336, 0.014977948, 0.015011636, 0.015045326, 0.015079094, 0.015112895, 0.015146705, 0.015180584, 0.015214482, 0.015248442, 0.015282442, 0.015316451, 0.015350533, 0.015384661, 0.015418802, 0.01545299, 0.015487219, 0.015521501, 0.015555799, 0.015590119, 0.015624538, 0.015658978, 0.015693437, 0.015727937, 0.015762508, 0.015797097, 0.015831728, 0.015866388, 0.015901126, 0.015935836, 0.015970627, 0.016005477, 0.016040327, 0.016075257, 0.016110206, 0.016145196, 0.016180206, 0.016215276, 0.016250396, 0.016285555, 0.016320735, 0.016355965, 0.016391246, 0.016426565, 0.016461905, 0.016497284, 0.016532745, 0.016568195, 0.016603695, 0.016639264, 0.016674835, 0.016710475, 0.016746145, 0.016781857, 0.016817605, 0.016853387, 0.016889207, 0.016925087, 0.016961006, 0.016996946, 0.017032957, 0.017068978, 0.017105047, 0.017141137, 0.017177286, 0.017213479, 0.017249707, 0.017285977, 0.017322307, 0.017358648, 0.017395029, 0.017431449, 0.01746794, 0.017504441, 0.017540989, 0.017577589, 0.017614199, 0.017650871, 0.01768758, 0.017724341, 0.017761122, 0.017797953, 0.017834822, 0.017871743, 0.017908674, 0.017945655, 0.017982706, 0.018019786, 0.018056875, 0.018094026, 0.018131217, 0.018168459, 0.018205708, 0.01824303, 0.018280379, 0.01831775, 0.01835518, 0.01839265, 0.018430162, 0.01846773, 0.018505301, 0.018542942, 0.018580614, 0.018618295, 0.018656064, 0.018693855, 0.018731676, 0.018769547, 0.018807458, 0.018845407, 0.01888339, 0.018921399, 0.018959509, 0.0189976, 0.019035744, 0.019073943, 0.019112164, 0.019150434, 0.019188734, 0.019227086, 0.019265497, 0.019303888, 0.019342359, 0.01938089, 0.01941943, 0.01945802, 0.01949667, 0.019535324, 0.019574044, 0.019612756, 0.019651575, 0.019690387, 0.019729247, 0.019768167, 0.01980713, 0.0198461, 0.019885151, 0.019924203, 0.019963324, 0.020002456, 0.020041635, 0.020080896, 0.020120138, 0.020159449, 0.0201988, 0.020238182, 0.020277623, 0.020317072, 0.020356575, 0.020396136, 0.020435706, 0.020475337, 0.020515028, 0.020554719, 0.020594472, 0.020634243, 0.020674095, 0.020713944, 0.020753846, 0.020793807, 0.020833818, 0.02087382, 0.020913882, 0.020954013, 0.020994155, 0.021034334, 0.021074567, 0.021114828, 0.021155139, 0.021195481, 0.021235883, 0.021276293, 0.021316774, 0.021357266, 0.021397838, 0.021438399, 0.02147902, 0.021519691, 0.021560423, 0.021601155, 0.021641927, 0.02168278, 0.02172365, 0.021764543, 0.021805482, 0.021846484, 0.021887517, 0.021928566, 0.021969689, 0.02201082, 0.022052022, 0.022093253, 0.022134505, 0.022175817, 0.02221716, 0.022258541, 0.022299992, 0.022341436, 0.022382945, 0.022424489, 0.022466099, 0.022507712, 0.022549383, 0.022591075, 0.022632847, 0.022674609, 0.022716431, 0.022758331, 0.022800224, 0.022842165, 0.022884136, 0.02292617, 0.022968251, 0.023010341, 0.023052506, 0.023094708, 0.023136899, 0.023179172, 0.023221482, 0.023263825, 0.023306228, 0.023348629, 0.023391111, 0.023433613, 0.023476144, 0.023518756, 0.023561379, 0.02360403, 0.023646751, 0.023689486, 0.023732297, 0.02377509, 0.02381796, 0.023860894, 0.023903813, 0.023946797, 0.023989839, 0.024032902, 0.024076015, 0.024119148, 0.024162339, 0.024205582, 0.024248824, 0.024292134, 0.024335487, 0.02437887, 0.024422301, 0.024465784, 0.024509275, 0.024552839, 0.02459638, 0.024640033, 0.024683686, 0.024727387, 0.02477115, 0.024814922, 0.024858754, 0.024902616, 0.024946529, 0.024990482, 0.025034444, 0.025078475, 0.025122549, 0.025166651, 0.025210805, 0.025254985, 0.025299219, 0.02534348, 0.025387773, 0.025432127, 0.02547651, 0.025520943, 0.025565416, 0.025609907, 0.025654459, 0.025699032, 0.025743663, 0.025788337, 0.02583302, 0.025877772, 0.025922565, 0.025967387, 0.026012251, 0.026057152, 0.026102114, 0.026147097, 0.026192112, 0.026237164, 0.026282286, 0.02632742, 0.026372623, 0.026417855, 0.026463106, 0.02650841, 0.026553754, 0.026599165, 0.026644558, 0.026690021, 0.026735526, 0.026781077, 0.026826659, 0.026872274, 0.026917957, 0.026963668, 0.027009413, 0.027055185, 0.027101008, 0.02714687, 0.027192773, 0.027238745, 0.027284717, 0.027330713, 0.027376784, 0.027422899, 0.027469041, 0.027515246, 0.027561458, 0.02760773, 0.027654033, 0.027700357, 0.027746741, 0.027793193, 0.027839646, 0.027886139, 0.027932692, 0.027979294, 0.028025907, 0.028072549, 0.028119277, 0.028166009, 0.028212793, 0.028259614, 0.028306475, 0.02835338, 0.028400334, 0.028447317, 0.028494341, 0.028541412, 0.028588505, 0.028635671, 0.028682834, 0.028730057, 0.028777342, 0.028824635, 0.028871987, 0.028919352, 0.028966794, 0.029014248, 0.02906174, 0.029109284, 0.029156888, 0.029204512, 0.029252177, 0.029299879, 0.02934761, 0.029395387, 0.029443217, 0.02949108, 0.029538985, 0.029586928, 0.029634895, 0.029682945, 0.029731011, 0.029779106, 0.029827235, 0.029875429, 0.029923657, 0.029971918, 0.030020213, 0.030068567, 0.03011696, 0.030165374, 0.030213846, 0.030262331, 0.030310873, 0.030359466, 0.030408092, 0.030456757, 0.03050545, 0.030554201, 0.030602986, 0.030651789, 0.030700663, 0.030749567, 0.030798523, 0.030847495, 0.03089652, 0.030945584, 0.030994687, 0.031043841, 0.031093022, 0.031142227, 0.0311915, 0.031240815, 0.031290129, 0.031339534, 0.03138895, 0.03143841, 0.031487927, 0.031537447, 0.031587034, 0.031636667, 0.031686321, 0.031736024, 0.031785768, 0.031835545, 0.031885397, 0.031935234, 0.031985145, 0.032035079, 0.032085065, 0.032135088, 0.032185145, 0.032235254, 0.032285389, 0.032335587, 0.032385796, 0.032436062, 0.032486368, 0.032536689, 0.032587085, 0.03263751, 0.032687973, 0.032738484, 0.032789033, 0.032839607, 0.032890242, 0.032940887, 0.032991588, 0.033042323, 0.033093117, 0.033143934, 0.033194788, 0.03324569, 0.033296637, 0.033347622, 0.033398654, 0.033449709, 0.033500802, 0.033553295, 0.033606719, 0.033660181, 0.033713691, 0.033767212, 0.033820771, 0.033874325, 0.033927929, 0.033981577, 0.034035239, 0.034088932, 0.034142651, 0.034196414, 0.034250204, 0.034303982, 0.034357831, 0.034411684, 0.034465577, 0.03451952, 0.034573443, 0.034627426, 0.034681454, 0.03473546, 0.034789532, 0.03484362, 0.03489773, 0.034951877, 0.035006043, 0.03506026, 0.035114493, 0.035168748, 0.035223033, 0.035277359, 0.035331704, 0.035386059, 0.035440464, 0.035494901, 0.035549369, 0.035603851, 0.035658371, 0.035712913, 0.035767477, 0.035822075, 0.03587671, 0.035931364, 0.035986051, 0.036040775, 0.0360955, 0.036150273, 0.036205072, 0.036259897, 0.036314748, 0.036369618, 0.036424536, 0.036479469, 0.036534455, 0.03658944, 0.036644496, 0.03669953, 0.036754604, 0.03680972, 0.036864847, 0.036920022, 0.03697522, 0.037030444, 0.037085693, 0.037140984, 0.037196293, 0.037251618, 0.037306994, 0.037362378, 0.037417784, 0.03747325, 0.037528716, 0.037584219, 0.037639763, 0.037695333, 0.03775093, 0.037806541, 0.0378622, 0.037917886, 0.037973572, 0.038029302, 0.038085081, 0.038140859, 0.03819669, 0.038252521, 0.038308397, 0.038364291, 0.038420234, 0.038476203, 0.038532179, 0.038588203, 0.038644254, 0.038700305, 0.038756415, 0.03881254, 0.038868718, 0.038924903, 0.038981102, 0.039037362, 0.039093625, 0.039149929, 0.039206263, 0.039262608, 0.039319001, 0.039375409, 0.039431848, 0.039488327, 0.039544825, 0.039601348, 0.039657917, 0.039714489, 0.03977111, 0.039827738, 0.039884407, 0.039941113, 0.039997827, 0.040054586, 0.040111352, 0.040168177, 0.040225022, 0.040281884, 0.040338784, 0.040395703, 0.040452655, 0.040509656, 0.040566638, 0.040623672, 0.040680751, 0.040737838, 0.040794961, 0.040852107, 0.040909298, 0.040966507, 0.041023735, 0.041081008, 0.04113828, 0.041195609, 0.041252963, 0.041310336, 0.041367747, 0.041425165, 0.04148265, 0.041540138, 0.041597649, 0.041655201, 0.041712791, 0.041770373, 0.041828018, 0.041885663, 0.04194336, 0.042001091, 0.042058818, 0.042116597, 0.042174399, 0.04223223, 0.042290092, 0.042347979, 0.042405896, 0.042463828, 0.042521808, 0.042579807, 0.042637836, 0.042695895, 0.042753991, 0.04281209, 0.042870242, 0.042928398, 0.042986605, 0.043044839, 0.043103088, 0.043161377, 0.043219674, 0.043278027, 0.043336399, 0.0433948, 0.043453217, 0.043511678, 0.043570165, 0.043628678, 0.043687206, 0.043745779, 0.043804381, 0.043863006, 0.043921657, 0.043980323, 0.044039037, 0.044097774, 0.044156555, 0.044215348, 0.044274159, 0.044333018, 0.0443919, 0.044450793, 0.044509746, 0.044568699, 0.044627685, 0.044686724, 0.044745747, 0.044804845, 0.044863958, 0.044923075, 0.044982247, 0.045041431, 0.045100659, 0.045159914, 0.045219176, 0.045278482, 0.045337819, 0.045397174, 0.045456566, 0.045515995, 0.045575432, 0.045634914, 0.045694407, 0.045753941, 0.045813493, 0.045873098, 0.045932714, 0.045992341, 0.046052024, 0.046111725, 0.046171464, 0.046231214, 0.046290997, 0.046350818, 0.04641065, 0.046470519, 0.046530437, 0.046590351, 0.046650305, 0.046710305, 0.046770301, 0.046830352, 0.046890415, 0.046950519, 0.047010645, 0.047070809, 0.047130987, 0.04719118, 0.047251433, 0.047311697, 0.047371998, 0.04743233, 0.047492664, 0.047553059, 0.047613468, 0.047673903, 0.04773438, 0.047794871, 0.047855385, 0.047915954, 0.047976512, 0.048037115, 0.048097771, 0.048158433, 0.048219122, 0.048279855, 0.048340596, 0.048401382, 0.048462179, 0.048523013, 0.048583869, 0.048644781, 0.048705697, 0.048766628, 0.048827618, 0.048888624, 0.048949655, 0.049010716, 0.049071796, 0.049132928, 0.049194079, 0.049255241, 0.049316458, 0.049377676, 0.049438935, 0.049500234, 0.049561545, 0.049622886, 0.049684264, 0.049745664, 0.049807109, 0.049868554, 0.049930044, 0.04999157, 0.05005309, 0.050114669, 0.05017627, 0.050237905, 0.050299559, 0.050361246, 0.050422966, 0.050484687, 0.050546471, 0.05060827, 0.050670091, 0.050731961, 0.050793827, 0.050855733, 0.050917685, 0.050979655, 0.051041655, 0.051103685, 0.051165733, 0.05122783, 0.051289912, 0.05135205, 0.051414233, 0.051476419, 0.051538657, 0.051600892, 0.051663179, 0.051725492, 0.051787827, 0.051850192, 0.051912576, 0.051975012, 0.052037463, 0.052099932, 0.052162442, 0.052224975, 0.052287534, 0.052350141, 0.052412752, 0.052475411, 0.052538089, 0.052600779, 0.052663527, 0.052726276, 0.05278907, 0.0528519, 0.052914742, 0.052977607, 0.053040508, 0.053103454, 0.053166412, 0.053229406, 0.053292423, 0.053355467, 0.053418536, 0.053481638, 0.053544763, 0.053607933, 0.053671118, 0.053734325, 0.053797584, 0.053860836, 0.053924154, 0.053987484, 0.054050837, 0.054114226, 0.054177623, 0.054241072, 0.054304559, 0.054368045, 0.054431573, 0.054495141, 0.05455872, 0.054622333, 0.054685965, 0.054749634, 0.05481334, 0.054877061, 0.05494082, 0.055004586, 0.055068411, 0.055132251, 0.055196118, 0.05526001, 0.055323929, 0.055387888, 0.055451874, 0.05551587, 0.055579919, 0.055643991, 0.055708069, 0.055772204, 0.055836331, 0.055900522, 0.055964753, 0.056028962, 0.056093235, 0.056157544, 0.056221861, 0.05628622, 0.056350574, 0.056414984, 0.056479421, 0.056543883, 0.056608375, 0.056672897, 0.056737438, 0.056802016, 0.056866609, 0.056931254, 0.056995913, 0.057060611, 0.057125326, 0.057190053, 0.057254836, 0.057319641, 0.057384476, 0.057449337, 0.057514224, 0.057579152, 0.05764408, 0.057709061, 0.057774067, 0.057839088, 0.057904143, 0.05796925, 0.058034349, 0.05809949, 0.058164656, 0.058229852, 0.058295079, 0.058360338, 0.058425624, 0.058490925, 0.058556277, 0.058621656, 0.058687046, 0.058752477, 0.058817916, 0.058883406, 0.058948934, 0.059014458, 0.059080034, 0.059145633, 0.05921125, 0.059276912, 0.059342586, 0.059408296, 0.059474044, 0.059539795, 0.059605598, 0.059671413, 0.059737269, 0.059803147, 0.059869055, 0.059935, 0.060000975, 0.06006695, 0.060132973, 0.060199022, 0.060265101, 0.06033121, 0.060397346, 0.060463496, 0.060529701, 0.060595922, 0.060662173, 0.060728438, 0.060794752, 0.060861088, 0.060927439, 0.060993828, 0.061060261, 0.061126702, 0.061193183, 0.061259676, 0.061326209, 0.061392769, 0.061459355, 0.061525967, 0.06159262, 0.061659299, 0.061726004, 0.061792728, 0.061859481, 0.061926279, 0.061993092, 0.062059935, 0.062126808, 0.062193692, 0.062260624, 0.062327586, 0.062394571, 0.062461581, 0.062528618, 0.06259571, 0.062662788, 0.062729917, 0.062797077, 0.062864266, 0.062931463, 0.062998712, 0.063065976, 0.063133284, 0.063200608, 0.063267961, 0.063335344, 0.06340275, 0.063470185, 0.063537657, 0.063605145, 0.063672669, 0.063740224, 0.063809223, 0.063879155, 0.063949086, 0.064019009, 0.064088948, 0.064158887, 0.064228795, 0.064298727, 0.064368643, 0.064438581, 0.06450849, 0.064578407, 0.064648323, 0.064718239, 0.06478814, 0.064858057, 0.064927965, 0.064997882, 0.065067783, 0.065137684, 0.065207586, 0.06527748, 0.065347381, 0.065417275, 0.065487161, 0.065557055, 0.065626957, 0.06569685, 0.065766722, 0.065836616, 0.065906502, 0.065976381, 0.06604626, 0.066116132, 0.066186011, 0.066255882, 0.066325769, 0.06639564, 0.066465497, 0.066535369, 0.06660524, 0.066675104, 0.066744961, 0.066814825, 0.066884674, 0.066954538, 0.067024387, 0.067094237, 0.067164086, 0.067233957, 0.067303792, 0.067373633, 0.067443475, 0.067513324, 0.067583166, 0.067653, 0.067722842, 0.067792676, 0.067862511, 0.067932338, 0.068002172, 0.068071984, 0.068141811, 0.068211645, 0.068281464, 0.068351291, 0.068421103, 0.06849093, 0.068560742, 0.068630554, 0.068700358, 0.06877017, 0.068839982, 0.068909794, 0.068979591, 0.069049403, 0.0691192, 0.069188997, 0.069258794, 0.069328591, 0.069398381, 0.06946817, 0.069537967, 0.06960775, 0.069677539, 0.069747321, 0.069817103, 0.069886886, 0.069956675, 0.070026442, 0.070096225, 0.070165992, 0.070235766, 0.070305541, 0.070375308, 0.070445068, 0.070514843, 0.070584595, 0.070654355, 0.070724122, 0.070793882, 0.070863634, 0.070933387, 0.071003146, 0.071072891, 0.071142644, 0.071212389, 0.071282133, 0.071351878, 0.071421616, 0.071491368, 0.071561098, 0.071630843, 0.071700573, 0.071770303, 0.071840033, 0.071909755, 0.071979485, 0.072049223, 0.072118938, 0.072188661, 0.072258376, 0.072328106, 0.072397813, 0.072467528, 0.072537236, 0.072606951, 0.072676659, 0.072746366, 0.072816074, 0.072885789, 0.072955474, 0.073025182, 0.073094882, 0.073164575, 0.073234275, 0.073303975, 0.073373653, 0.073443338, 0.073513031, 0.073582724, 0.073652402, 0.073722087, 0.073791772, 0.07386145, 0.07393112, 0.074000806, 0.074070461, 0.074140146, 0.074209809, 0.07427948, 0.074349143, 0.074418813, 0.074488476, 0.074558131, 0.074627794, 0.07469745, 0.074767105, 0.074836768, 0.074906416, 0.074976072, 0.075045705, 0.07511536, 0.075185008, 0.075254641, 0.07532429, 0.07539393, 0.075463563, 0.075533204, 0.075602837, 0.075672463, 0.075742096, 0.075811729, 0.075881355, 0.075950973, 0.076020598, 0.076090224, 0.076159835, 0.076229446, 0.076299071, 0.07636869, 0.076438293, 0.076507911, 0.076577522, 0.076647133, 0.076716729, 0.076786339, 0.076855935, 0.076925538, 0.076995134, 0.077064738, 0.077134319, 0.077203915, 0.077273518, 0.077343099, 0.077412687, 0.077482268, 0.077551849, 0.077621438, 0.077691019, 0.0777606, 0.077830166, 0.077899754, 0.077969328, 0.078038886, 0.07810846, 0.078178026, 0.078247592, 0.078317158, 0.078386724, 0.078456275, 0.078525841, 0.078595392, 0.078664951, 0.078734502, 0.078804053, 0.078873605, 0.078943141, 0.079012699, 0.079082243, 0.079151787, 0.079221323, 0.079290867, 0.079360403, 0.079429932, 0.079499476, 0.079569004, 0.079638526, 0.079708062, 0.079777591, 0.079847112, 0.079916634, 0.079986155, 0.080055669, 0.08012519, 0.080194704, 0.080264218, 0.080333732, 0.080403246, 0.080472752, 0.080542251, 0.080611758, 0.080681257, 0.080750778, 0.08082027, 0.080889761, 0.080959253, 0.081028752, 0.081098251, 0.081167735, 0.081237219, 0.081306696, 0.081376195, 0.081445679, 0.081515156, 0.081584632, 0.081654117, 0.081723586, 0.081793062, 0.081862539, 0.081931993, 0.082001477, 0.082070954, 0.082140408, 0.08220987, 0.082279339, 0.082348794, 0.082418248, 0.08248771, 0.082557157, 0.082626611, 0.082696065, 0.08276552, 0.082834959, 0.082904406, 0.082973845, 0.083043292, 0.083112724, 0.083182164, 0.083251618, 0.083321042, 0.083390482, 0.083459906, 0.083529338, 0.083598763, 0.083668187, 0.083737612, 0.083807029, 0.083876461, 0.08394587, 0.084015287, 0.084084697, 0.084154122, 0.084223539, 0.084292933, 0.08436235, 0.084431745, 0.084501162, 0.084570557, 0.084639959, 0.084709361, 0.084778756, 0.084848151, 0.084917545, 0.084986933, 0.085056327, 0.085125722, 0.085195102, 0.085264489, 0.085333869, 0.085403249, 0.085472621, 0.085542008, 0.085611373, 0.085680746, 0.085750125, 0.085819498, 0.085888863, 0.085958228, 0.0860276, 0.086096957, 0.086166315, 0.08623568, 0.086305022, 0.086374395, 0.086443745, 0.086513102, 0.086582445, 0.086651802, 0.086721137, 0.086790495, 0.08685983, 0.086929172, 0.086998515, 0.087067857, 0.087137178, 0.08720652, 0.087275855, 0.08734519, 0.087414511, 0.087483838, 0.087553158, 0.087622494, 0.087691814, 0.087761134, 0.087830439, 0.087899774, 0.08796908, 0.088038385, 0.08810769, 0.08817701, 0.088246316, 0.088315621, 0.088384919, 0.088454224, 0.088523537, 0.088592827, 0.088662118, 0.088731408, 0.088800706, 0.088870004, 0.088939287, 0.089008585, 0.08907786, 0.089147158, 0.089216433, 0.089285709, 0.089354977, 0.08942426, 0.08949355, 0.089562818, 0.089632086, 0.089701355, 0.089770623, 0.089839883, 0.089909151, 0.089978419, 0.090047672, 0.09011694, 0.090186194, 0.090255447, 0.0903247, 0.090393953, 0.090463199, 0.090532444, 0.090601698, 0.090670928, 0.090740189, 0.090809435, 0.090878665, 0.090947889, 0.091017142, 0.091086365, 0.091155589, 0.091224834, 0.091294058, 0.091363288, 0.091432512, 0.091501743, 0.091570951, 0.091640174, 0.091709383, 0.091778606, 0.091847807, 0.091917023, 0.091986246, 0.092055447, 0.092124663, 0.092193857, 0.092263073, 0.092332266, 0.092401467, 0.092470661, 0.092539862, 0.092609048, 0.092678249, 0.092747428, 0.092816621, 0.092885807, 0.092955001, 0.093024172, 0.093093358, 0.093162537, 0.093231715, 0.093300894, 0.093370073, 0.093439236, 0.093508422, 0.093577579, 0.09364675, 0.093715914, 0.093785077, 0.093854241, 0.093923397, 0.093992561, 0.09406171, 0.094130866, 0.09420003, 0.094269179, 0.09433832, 0.094407469, 0.094476618, 0.094545767, 0.094614901, 0.094684049, 0.094753183, 0.09482231, 0.094891444, 0.094960585, 0.095029712, 0.095098846, 0.095167972, 0.095237099, 0.095306218, 0.095375352, 0.095444471, 0.095513582, 0.095582709, 0.095651813, 0.095720939, 0.095790043, 0.095859148, 0.095928259, 0.095997371, 0.096066467, 0.096135579, 0.096204668, 0.096273772, 0.096342877, 0.096411966, 0.096481062, 0.096550152, 0.096619248, 0.09668833, 0.096757412, 0.096826509, 0.096895576, 0.096964665, 0.097033747, 0.097102828, 0.097171895, 0.097240977, 0.097310044, 0.097379111, 0.097448178, 0.097517245, 0.097586311, 0.097655378, 0.097724438, 0.09779349, 0.097862549, 0.097931609, 0.098000668, 0.09806972, 0.098138765, 0.098207824, 0.098276854, 0.098345906, 0.09841495, 0.098484002, 0.098552726, 0.098621301, 0.098689832, 0.098758325, 0.098826781, 0.0988952, 0.098963574, 0.099031903, 0.099100202, 0.099168457, 0.099236667, 0.099304847, 0.099372983, 0.099441081, 0.099509135, 0.099577159, 0.09964513, 0.099713072, 0.099780969, 0.099848822, 0.099916637, 0.099984415, 0.10005216, 0.10011987, 0.10018753, 0.10025514, 0.10032273, 0.10039027, 0.10045777, 0.10052523, 0.10059265, 0.10066004, 0.10072738, 0.10079468, 0.10086194, 0.10092918, 0.10099635, 0.1010635, 0.10113061, 0.10119766, 0.1012647, 0.10133168, 0.10139862, 0.10146554, 0.10153241, 0.10159924, 0.10166602, 0.10173277, 0.10179947, 0.10186615, 0.10193278, 0.10199937, 0.10206591, 0.10213242, 0.1021989, 0.10226533, 0.10233171, 0.10239807, 0.10246439, 0.10253066, 0.10259689, 0.10266308, 0.10272924, 0.10279536, 0.10286143, 0.10292745, 0.10299346, 0.10305942, 0.10312533, 0.1031912, 0.10325704, 0.10332284, 0.10338859, 0.10345432, 0.10351999, 0.10358563, 0.10365123, 0.10371679, 0.1037823, 0.10384779, 0.10391323, 0.10397863, 0.10404398, 0.1041093, 0.10417458, 0.10423983, 0.10430504, 0.1043702, 0.10443532, 0.10450041, 0.10456545, 0.10463045, 0.10469541, 0.10476033, 0.10482523, 0.10489007, 0.10495488, 0.10501964, 0.10508437, 0.10514905, 0.1052137, 0.10527831, 0.10534286, 0.10540741, 0.10547189, 0.10553633, 0.10560074, 0.10566512, 0.10572946, 0.10579374, 0.10585798, 0.1059222, 0.10598637, 0.1060505, 0.10611459, 0.10617864, 0.10624266, 0.10630664, 0.10637057, 0.10643446, 0.10649832, 0.10656213, 0.1066259, 0.10668964, 0.10675333, 0.106817, 0.10688061, 0.10694418, 0.10700772, 0.10707123, 0.10713468, 0.1071981, 0.10726147, 0.1073248, 0.10738812, 0.10745137, 0.10751458, 0.10757776, 0.10764091, 0.10770401, 0.10776706, 0.10783009, 0.10789307, 0.10795602, 0.10801892, 0.10808178, 0.1081446, 0.10820739, 0.10827013, 0.10833284, 0.10839549, 0.10845812, 0.10852072, 0.10858326, 0.10864575, 0.10870823, 0.10877066, 0.10883304, 0.10889539, 0.1089577, 0.10901996, 0.1090822, 0.10914438, 0.10920653, 0.10926864, 0.10933071, 0.10939275, 0.10945472, 0.10951668, 0.10957858, 0.10964047, 0.10970229, 0.10976409, 0.10982584, 0.10988756, 0.10994923, 0.11001086, 0.11007246, 0.110134, 0.11019553, 0.110257, 0.11031843, 0.11037983, 0.11044119, 0.1105025, 0.11056378, 0.11062501, 0.11068621, 0.11074738, 0.11080848, 0.11086956, 0.11093061, 0.11099162, 0.11105258, 0.11111349, 0.11117437, 0.11123521, 0.11129601, 0.11135677, 0.11141749, 0.11147817, 0.11153883, 0.11159942, 0.11165999, 0.11172051, 0.11178099, 0.11184145, 0.11190183, 0.1119622, 0.11202253, 0.11208282, 0.11214306, 0.11220328, 0.11226344, 0.11232355, 0.11238366, 0.11244369, 0.1125037, 0.11256368, 0.1126236, 0.1126835, 0.11274335, 0.11280315, 0.11286291, 0.11292265, 0.11298234, 0.11304199, 0.11310161, 0.11316118, 0.11322071, 0.1132802, 0.11333965, 0.11339907, 0.11345844, 0.11351778, 0.11357707, 0.11363633, 0.11369553, 0.11375472, 0.11381385, 0.11387295, 0.113932, 0.11399102, 0.11405, 0.11410893, 0.11416783, 0.11422668, 0.11428552, 0.11434428, 0.11440302, 0.11446173, 0.11452039, 0.11457901, 0.11463758, 0.11469613, 0.11475462, 0.1148131, 0.11487152, 0.1149299, 0.11498825, 0.11504655, 0.1151048, 0.11516303, 0.11522122, 0.11527936, 0.11533747, 0.11539554, 0.11545355, 0.11551154, 0.1155695, 0.11562739, 0.11568526, 0.11574309, 0.11580088, 0.11585863, 0.11591633, 0.11597401, 0.11603164, 0.11608922, 0.11614677, 0.11620428, 0.11626174, 0.11631917, 0.11637658, 0.11643393, 0.11649122, 0.11654849, 0.11660574, 0.11666293, 0.1167201, 0.1167772, 0.11683428, 0.11689131, 0.11694831, 0.11700526, 0.11706217, 0.11711905, 0.11717588, 0.1172327, 0.11728943, 0.11734615, 0.11740284, 0.11745947, 0.11751608, 0.11757263, 0.11762916, 0.11768563, 0.11774208, 0.11779848, 0.11785483, 0.11791116, 0.11796743, 0.11802367, 0.11807987, 0.11813604, 0.11819215, 0.11824823, 0.11830428, 0.1183603, 0.11841625, 0.11847217, 0.11852806, 0.1185839, 0.11863972, 0.11869548, 0.1187512, 0.11880689, 0.11886252, 0.11891815, 0.11897371, 0.11902925, 0.11908472, 0.11914018, 0.11919558, 0.11925095, 0.11930628, 0.11936156, 0.11941682, 0.11947202, 0.11952719, 0.11958233, 0.11963744, 0.11969248, 0.11974748, 0.11980245, 0.11985739, 0.11991229, 0.11996714, 0.12002195, 0.12007674, 0.12013146, 0.12018616, 0.12024082, 0.12029543, 0.12035, 0.12040454, 0.12045903, 0.12051348, 0.12056792, 0.12062228, 0.12067664, 0.12073092, 0.12078519, 0.12083941, 0.12089358, 0.12094773, 0.12100183, 0.12105589, 0.12110991, 0.12116389, 0.12121783, 0.12127173, 0.1213256, 0.12137943, 0.12143321, 0.12148695, 0.12154065, 0.12159431, 0.12164795, 0.12170152, 0.12175507, 0.12180857, 0.12186203, 0.12191547, 0.12196885, 0.1220222, 0.12207551, 0.12212878, 0.122182, 0.1222352, 0.12228834, 0.12234145, 0.12239451, 0.12244754, 0.12250053, 0.12255349, 0.1226064, 0.12265927, 0.12271211, 0.12276489, 0.12281765, 0.12287036, 0.12292303, 0.12297566, 0.12302826, 0.1230808, 0.12313332, 0.1231858, 0.12323824, 0.12329062, 0.12334298, 0.12339531, 0.12344757, 0.12349982, 0.123552, 0.12360417, 0.1236563, 0.12370837, 0.1237604, 0.12381241, 0.12386437, 0.12391628, 0.12396816, 0.12402, 0.1240718, 0.12412357, 0.12417529, 0.12422697, 0.12427861, 0.12433021, 0.12438177, 0.12443329, 0.12448479, 0.12453622, 0.12458763, 0.12463898, 0.12469032, 0.12474161, 0.12479286, 0.12484405, 0.12489522, 0.12494635, 0.12499744, 0.12504849, 0.1250995, 0.12515047, 0.12520139, 0.12525228, 0.12530312, 0.12535393, 0.12540472, 0.12545542, 0.12550613, 0.12555678, 0.12560739, 0.12565796, 0.12570849, 0.12575898, 0.12580943, 0.12585986, 0.12591022, 0.12596057, 0.12601085, 0.1260611, 0.12611131, 0.1261615, 0.12621163, 0.12626173, 0.12631178, 0.1263618, 0.12641177, 0.12646171, 0.1265116, 0.12656146, 0.12661128, 0.12666106, 0.1267108, 0.12676051, 0.12681016, 0.12685977, 0.12690936, 0.12695891, 0.12700841, 0.12705787, 0.12710729, 0.12715666, 0.12720601, 0.12725532, 0.12730457, 0.1273538, 0.12740299, 0.12745214, 0.12750123, 0.1275503, 0.12759931, 0.12764831, 0.12769724, 0.12774616, 0.12779503, 0.12784386, 0.12789114, 0.1279369, 0.1279826, 0.12802821, 0.12807377, 0.12811927, 0.12816471, 0.12821007, 0.12825537, 0.12830061, 0.12834579, 0.12839089, 0.12843594, 0.12848094, 0.12852585, 0.12857071, 0.1286155, 0.12866023, 0.12870489, 0.12874949, 0.12879403, 0.12883851, 0.12888293, 0.12892726, 0.12897155, 0.12901576, 0.12905991, 0.129104, 0.12914802, 0.12919199, 0.12923589, 0.12927972, 0.12932348, 0.12936722, 0.12941083, 0.12945442, 0.12949795, 0.12954138, 0.12958477, 0.12962811, 0.12967137, 0.12971455, 0.12975767, 0.12980075, 0.12984376, 0.12988669, 0.12992957, 0.12997238, 0.13001513, 0.13005781, 0.13010043, 0.130143, 0.13018548, 0.13022792, 0.13027027, 0.13031258, 0.13035481, 0.13039699, 0.13043909, 0.13048114, 0.13052312, 0.13056505, 0.13060689, 0.13064869, 0.1306904, 0.13073206, 0.13077366, 0.13081519, 0.13085666, 0.13089807, 0.13093939, 0.1309807, 0.13102192, 0.13106306, 0.13110414, 0.13114516, 0.13118613, 0.13122703, 0.13126785, 0.13130862, 0.13134933, 0.13138995, 0.13143054, 0.13147104, 0.13151149, 0.13155188, 0.1315922, 0.13163246, 0.13167265, 0.13171276, 0.13175283, 0.13179284, 0.13183276, 0.13187264, 0.13191245, 0.1319522, 0.13199188, 0.1320315, 0.13207105, 0.13211054, 0.13214996, 0.13218933, 0.13222861, 0.13226785, 0.13230702, 0.13234612, 0.13238516, 0.13242415, 0.13246305, 0.1325019, 0.13254069, 0.13257942, 0.13261807, 0.13265666, 0.13269518, 0.13273367, 0.13277207, 0.1328104, 0.13284868, 0.13288689, 0.13292503, 0.13296312, 0.13300113, 0.13303909, 0.13307698, 0.13311481, 0.13315257, 0.13319027, 0.1332279, 0.13326548, 0.13330299, 0.13334043, 0.13337782, 0.13341512, 0.13345239, 0.13348956, 0.1335267, 0.13356376, 0.13360076, 0.1336377, 0.13367455, 0.13371137, 0.1337481, 0.13378477, 0.1338214, 0.13385794, 0.13389443, 0.13393085, 0.13396721, 0.13400349, 0.13403973, 0.13407589, 0.134112, 0.13414803, 0.13418399, 0.13421991, 0.13425575, 0.13429154, 0.13432725, 0.13436292, 0.13439851, 0.13443404, 0.13446949, 0.1345049, 0.13454023, 0.1345755, 0.1346107, 0.13464585, 0.13468094, 0.13471594, 0.13475089, 0.13478579, 0.13482061, 0.13485537, 0.13489006, 0.13492469, 0.13495925, 0.13499378, 0.13502821, 0.13506259, 0.13509691, 0.13513114, 0.13516532, 0.13519946, 0.13523351, 0.1352675, 0.13530143, 0.13533531, 0.13536909, 0.13540283, 0.13543651, 0.13547012, 0.13550366, 0.13553715, 0.13557056, 0.1356039, 0.13563721, 0.13567044, 0.13570358, 0.13573669, 0.13576974, 0.1358027, 0.1358356, 0.13586845, 0.13590123, 0.13593395, 0.13596658, 0.13599917, 0.13603172, 0.13606417, 0.13609655, 0.1361289, 0.13616116, 0.13619336, 0.13622551, 0.13625757, 0.1362896, 0.13632154, 0.13635342, 0.13638523, 0.136417, 0.1364487, 0.13648033, 0.13651188, 0.13654338, 0.13657482, 0.13660619, 0.13663749, 0.13666876, 0.13669993, 0.13673104, 0.1367621, 0.13679309, 0.13682401, 0.13685487, 0.13688567, 0.1369164, 0.13694707, 0.13697769, 0.13700822, 0.13703871, 0.13706912, 0.13709946, 0.13712975, 0.13715997, 0.13719013, 0.13722023, 0.13725027, 0.13728024, 0.13731013, 0.13733998, 0.13736975, 0.13739945, 0.1374291, 0.13745868, 0.1374882, 0.13751765, 0.13754706, 0.13757639, 0.13760564, 0.13763484, 0.13766399, 0.13769305, 0.13772206, 0.13775101, 0.13777988, 0.13780871, 0.13783745, 0.13786615, 0.13789476, 0.13792333, 0.13795184, 0.13798027, 0.13800864, 0.13803694, 0.13806517, 0.13809337, 0.13812147, 0.13814951, 0.1381775, 0.13820544, 0.1382333, 0.13826108, 0.13828883, 0.13831647, 0.13834409, 0.13837162, 0.13839911, 0.1384265, 0.13845387, 0.13848116, 0.13850835, 0.13853551, 0.13856259, 0.13858964, 0.13861659, 0.13864349, 0.13867033, 0.13869709, 0.13872381, 0.13875045, 0.13877703, 0.13880354, 0.13883001, 0.13885638, 0.13888271, 0.13890898, 0.13893518, 0.1389613, 0.13898738, 0.13901336, 0.13903931, 0.13906519, 0.13909101, 0.13911675, 0.13914244, 0.13916805, 0.13919361, 0.13921912, 0.13924454, 0.1392699, 0.13929521, 0.13932045, 0.13934563, 0.13937072, 0.13939579, 0.13942078, 0.13944568, 0.13947053, 0.13949533, 0.13952005, 0.13954473, 0.13956933, 0.13959384, 0.13961832, 0.13964273, 0.13966708, 0.13969137, 0.13971558, 0.13973972, 0.1397638, 0.13978784, 0.13981178, 0.1398357, 0.13985953, 0.13988329, 0.139907, 0.13993064, 0.13995421, 0.13997772, 0.14000118, 0.14002456, 0.14004788, 0.14007115, 0.14009431, 0.14011745, 0.14014052, 0.14016353, 0.14018647, 0.14020933, 0.14023215, 0.1402549, 0.14027756, 0.14030018, 0.14032274, 0.14034525, 0.14036767, 0.14039002, 0.14041233, 0.14043456, 0.14045674, 0.14047883, 0.14050089, 0.14052287, 0.14054477, 0.14056663, 0.14058842, 0.14061014, 0.14063179, 0.14065339, 0.14067492, 0.14069639, 0.14071779, 0.14073913, 0.14076042, 0.14078163, 0.14080277, 0.14082386, 0.14084488, 0.14086583, 0.14088671, 0.14090754, 0.14092833, 0.14094903, 0.14096966, 0.14099023, 0.14101073, 0.14103118, 0.14105156, 0.14107187, 0.14109212, 0.14111233, 0.14113244, 0.14115252, 0.14117251, 0.14119244, 0.14121231, 0.14123212, 0.14125186, 0.14127153, 0.14129116, 0.14131069, 0.14133018, 0.1413496, 0.14136899, 0.14138827, 0.1414075, 0.14142667, 0.14144579, 0.14146481, 0.14148378, 0.14150269, 0.14152156, 0.14154033, 0.14155905, 0.14157771, 0.14159629, 0.14161482, 0.14163329, 0.1416517, 0.14167002, 0.1416883, 0.1417065, 0.14172465, 0.14174272, 0.14176075, 0.14177869, 0.14179659, 0.14181441, 0.14183217, 0.14184988, 0.14186752, 0.14188509, 0.14190258, 0.14192003, 0.1419374, 0.14195472, 0.14197198, 0.14198916, 0.14200628, 0.14202334, 0.14204033, 0.14205727, 0.14207412, 0.14209092, 0.14210767, 0.14212434, 0.14214094, 0.14215751, 0.14217399, 0.14219041, 0.14220676, 0.14222306, 0.14223927, 0.14225544, 0.14227153, 0.14228757, 0.14230354, 0.14231944, 0.1423353, 0.14235108, 0.1423668, 0.14238244, 0.14239803, 0.14241356, 0.14242902, 0.14244442, 0.14245975, 0.14247502, 0.14249022, 0.14250538, 0.14252044, 0.14253546, 0.14255041, 0.1425653, 0.14258011, 0.14259486, 0.14260957, 0.1426242, 0.14263876, 0.14265327, 0.14266771, 0.14268209, 0.1426964, 0.14271064, 0.14272483, 0.14273892, 0.14275299, 0.14276698, 0.1427809, 0.14279391, 0.14280595, 0.14281794, 0.14282985, 0.1428417, 0.14285348, 0.1428652, 0.14287683, 0.1428884, 0.1428999, 0.14291133, 0.14292268, 0.14293398, 0.1429452, 0.14295635, 0.14296745, 0.14297846, 0.1429894, 0.14300027, 0.14301108, 0.14302182, 0.14303249, 0.14304309, 0.14305362, 0.14306407, 0.14307447, 0.14308478, 0.14309505, 0.14310524, 0.14311534, 0.14312537, 0.14313535, 0.14314525, 0.1431551, 0.14316487, 0.14317456, 0.14318419, 0.14319374, 0.14320324, 0.14321265, 0.143222, 0.14323129, 0.1432405, 0.14324965, 0.14325872, 0.14326774, 0.14327666, 0.14328551, 0.14329432, 0.14330305, 0.14331171, 0.14332031, 0.14332882, 0.14333726, 0.14334565, 0.14335395, 0.14336219, 0.14337038, 0.14337848, 0.14338651, 0.14339449, 0.14340237, 0.14341019, 0.14341795, 0.14342564, 0.14343326, 0.14344081, 0.14344829, 0.1434557, 0.14346303, 0.1434703, 0.14347751, 0.14348465, 0.1434917, 0.1434987, 0.14350563, 0.14351249, 0.14351927, 0.14352599, 0.14353265, 0.14353922, 0.14354573, 0.14355217, 0.14355855, 0.14356484, 0.14357106, 0.14357723, 0.14358333, 0.14358936, 0.14359531, 0.14360119, 0.14360701, 0.14361276, 0.14361845, 0.14362404, 0.14362958, 0.14363505, 0.14364044, 0.14364578, 0.14365104, 0.14365624, 0.14366135, 0.1436664, 0.14367139, 0.1436763, 0.14368115, 0.14368594, 0.14369063, 0.14369528, 0.14369984, 0.14370435, 0.14370878, 0.14371313, 0.14371742, 0.14372166, 0.1437258, 0.14372988, 0.14373389, 0.14373784, 0.14374171, 0.14374553, 0.14374925, 0.14375293, 0.14375652, 0.14376006, 0.14376351, 0.14376689, 0.14377022, 0.14377348, 0.14377667, 0.14377977, 0.14378282, 0.1437858, 0.1437887, 0.14379153, 0.14379428, 0.143797, 0.14379962, 0.14380217, 0.14380467, 0.14380708, 0.14380944, 0.14381173, 0.14381392, 0.14381608, 0.14381815, 0.14382015, 0.14382209, 0.14382395, 0.14382575, 0.14382747, 0.14382914, 0.14383073, 0.14383224, 0.1438337, 0.14383507, 0.14383638, 0.14383762, 0.14383879, 0.1438399, 0.14384092, 0.14384191, 0.14384279, 0.14384361, 0.14384437, 0.14384505, 0.14384566, 0.14384623, 0.14384671, 0.14384711, 0.14384745, 0.14384772, 0.14384793, 0.14384806, 0.14384811, 0.14384811, 0.14384803, 0.1438479, 0.14384769, 0.14384739, 0.14384705, 0.14384663, 0.14384612, 0.14384556, 0.14384493, 0.14384423, 0.14384347, 0.14384264, 0.14384173, 0.14384076, 0.1438397, 0.14383858, 0.14383741, 0.14383614, 0.14383481, 0.14383343, 0.14383197, 0.14383043, 0.14382884, 0.14382717, 0.14382543, 0.14382362, 0.14382176, 0.14381979, 0.14381778, 0.1438157, 0.14381355, 0.14381133, 0.14380902, 0.14380665, 0.14380422, 0.14380172, 0.14379914, 0.14379652, 0.14379381, 0.14379102, 0.14378819, 0.14378527, 0.14378229, 0.14377922, 0.1437761, 0.1437729, 0.14376964, 0.1437663, 0.1437629, 0.14375943, 0.14375588, 0.14375228, 0.1437486, 0.14374484, 0.14374103, 0.14373715, 0.1437332, 0.14372917, 0.14372508, 0.14372091, 0.14371666, 0.14371236, 0.14370799, 0.14370355, 0.14369904, 0.14369445, 0.14368981, 0.14368509, 0.14368029, 0.14367545, 0.14367051, 0.14366552, 0.14366046, 0.1436553, 0.1436501, 0.14364484, 0.14363949, 0.14363408, 0.1436286, 0.14362304, 0.14361744, 0.14361173, 0.14360596, 0.14360015, 0.14359424, 0.14358829, 0.14358224, 0.14357615, 0.14356996, 0.14356372, 0.1435574, 0.14355104, 0.14354458, 0.14353806, 0.14353146, 0.1435248, 0.14351808, 0.14351128, 0.14350441, 0.14349747, 0.14349046, 0.14348339, 0.14347625, 0.14346904, 0.14346175, 0.14345437, 0.14344697, 0.14343947, 0.1434319, 0.14342429, 0.14341657, 0.14340881, 0.14340097, 0.14339305, 0.14338508, 0.14337705, 0.14336893, 0.14336075, 0.14335248, 0.14334416, 0.14333577, 0.14332731, 0.14331877, 0.14331017, 0.1433015, 0.14329275, 0.14328396, 0.14327507, 0.14326613, 0.14325711, 0.14324802, 0.14323887, 0.14322965, 0.14322035, 0.14321099, 0.14320156, 0.14319204, 0.14318249, 0.14317285, 0.14316314, 0.14315335, 0.1431435, 0.14313358, 0.1431236, 0.14311354, 0.14310341, 0.14309323, 0.14308296, 0.14307262, 0.14306223, 0.14305176, 0.14304121, 0.1430306, 0.14301991, 0.14300916, 0.14299835, 0.14298746, 0.14297649, 0.14296547, 0.14295438, 0.14294322, 0.14293197, 0.14292067, 0.1429093, 0.14289786, 0.14288634, 0.14287476, 0.14286312, 0.14285138, 0.14283961, 0.14282775, 0.14281581, 0.14280382, 0.14279176, 0.14277962, 0.1427674, 0.14275514, 0.1427428, 0.14273037, 0.1427179, 0.14270535, 0.14269271, 0.14268003, 0.14266728, 0.14265445, 0.14264154, 0.14262857, 0.14261554, 0.14260243, 0.14258927, 0.14257602, 0.1425627, 0.14254932, 0.14253587, 0.14252234, 0.14250875, 0.14249508, 0.14248136, 0.14246756, 0.14245369, 0.14243974, 0.14242575, 0.14241166, 0.14239752, 0.14238329, 0.14236902, 0.14235467, 0.14234024, 0.14232576, 0.14231119, 0.14229657, 0.14228186, 0.14226708, 0.14225225, 0.14223734, 0.14222236, 0.14220731, 0.14219218, 0.14217702, 0.14216174, 0.14214644, 0.14213105, 0.14211558, 0.14210005, 0.14208443, 0.14206879, 0.14205304, 0.14203723, 0.14202134, 0.14200541, 0.14198938, 0.1419733, 0.14195713, 0.14194092, 0.14192462, 0.14190824, 0.14189182, 0.14187531, 0.14185874, 0.1418421, 0.14182539, 0.14180863, 0.14179176, 0.14177483, 0.14175785, 0.1417408, 0.14172368, 0.14170647, 0.1416892, 0.14167188, 0.14165448, 0.141637, 0.14161946, 0.14160185, 0.14158416, 0.1415664, 0.14154859, 0.14153071, 0.14151274, 0.14149472, 0.14147662, 0.14145845, 0.14144023, 0.14142193, 0.14140353, 0.14138511, 0.14136659, 0.141348, 0.14132936, 0.14131063, 0.14129183, 0.14127299, 0.14125405, 0.14123505, 0.14121599, 0.14119685, 0.14117764, 0.14115837, 0.14113902, 0.1411196, 0.14110014, 0.14108057, 0.14106095, 0.14104126, 0.1410215, 0.14100169, 0.14098178, 0.14096181, 0.14094177, 0.14092167, 0.14090148, 0.14088124, 0.14086092, 0.14084055, 0.14082009, 0.14079957, 0.14077896, 0.14075831, 0.14073758, 0.14071679, 0.14069591, 0.14067498, 0.14065397, 0.14063288, 0.14061174, 0.14059053, 0.14056924, 0.14054789, 0.14052646, 0.14050497, 0.14048341, 0.14046177, 0.14044008, 0.14041831, 0.14039646, 0.14037456, 0.14035256, 0.14033054, 0.14030841, 0.14028622, 0.14026397, 0.14024164, 0.14021924, 0.14019679, 0.14017335, 0.14014894, 0.14012447, 0.14009994, 0.14007536, 0.14005069, 0.14002599, 0.14000122, 0.1399764, 0.13995151, 0.13992655, 0.13990153, 0.13987648, 0.13985133, 0.13982613, 0.13980091, 0.13977559, 0.1397502, 0.13972476, 0.13969927, 0.13967372, 0.13964809, 0.13962242, 0.13959669, 0.13957089, 0.13954502, 0.13951911, 0.13949312, 0.13946709, 0.13944098, 0.13941485, 0.13938861, 0.13936232, 0.13933598, 0.13930959, 0.13928312, 0.13925658, 0.13923001, 0.13920335, 0.13917665, 0.13914987, 0.13912305, 0.13909617, 0.13906923, 0.13904221, 0.13901515, 0.13898802, 0.13896084, 0.13893358, 0.13890627, 0.13887891, 0.13885148, 0.13882397, 0.13879643, 0.13876881, 0.13874114, 0.13871342, 0.1386856, 0.13865773, 0.13862984, 0.13860185, 0.13857383, 0.13854574, 0.13851756, 0.13848935, 0.13846107, 0.13843273, 0.13840434, 0.13837586, 0.13834734, 0.13831876, 0.13829012, 0.13826142, 0.13823266, 0.13820384, 0.13817495, 0.13814601, 0.138117, 0.13808793, 0.13805881, 0.13802962, 0.13800037, 0.13797107, 0.1379417, 0.13791227, 0.13788277, 0.13785324, 0.13782363, 0.13779394, 0.13776423, 0.13773443, 0.13770457, 0.13767466, 0.13764469, 0.13761465, 0.13758455, 0.13755441, 0.13752419, 0.13749389, 0.13746358, 0.13743319, 0.13740273, 0.13737221, 0.13734162, 0.137311, 0.13728029, 0.13724953, 0.1372187, 0.13718782, 0.13715689, 0.13712588, 0.13709483, 0.13706371, 0.13703252, 0.13700128, 0.13696997, 0.1369386, 0.13690718, 0.13687567, 0.13684414, 0.13681254, 0.13678087, 0.13674913, 0.13671735, 0.13668551, 0.13665359, 0.13662162, 0.13658959, 0.1365575, 0.13652533, 0.13649315, 0.13646086, 0.13642852, 0.13639614, 0.13636369, 0.13633117, 0.13629858, 0.13626595, 0.13623326, 0.1362005, 0.13616769, 0.1361348, 0.13610187, 0.13606887, 0.13603581, 0.13600267, 0.1359695, 0.13593626, 0.13590296, 0.13586961, 0.13583617, 0.13580272, 0.13576916, 0.13573556, 0.13570189, 0.13566816, 0.13563438, 0.13560054, 0.13556662, 0.13553265, 0.13549863, 0.13546453, 0.1354304, 0.13539618, 0.13536191, 0.13532758, 0.13529319, 0.13525873, 0.13522422, 0.13518967, 0.13515502, 0.13512035, 0.13508557, 0.13505076, 0.13501589, 0.13498095, 0.13494596, 0.1349109, 0.13487579, 0.13484059, 0.13480537, 0.13477007, 0.13473471, 0.1346993, 0.13466382, 0.13462828, 0.13459267, 0.13455699, 0.13452128, 0.1344855, 0.13444965, 0.13441375, 0.13437778, 0.13434176, 0.13430567, 0.13426954, 0.13423333, 0.13419707, 0.13416073, 0.13412435, 0.13408789, 0.13405141, 0.13401482, 0.13397819, 0.1339415, 0.13390476, 0.13386795, 0.13383108, 0.13379414, 0.13375714, 0.1337201, 0.13368297, 0.13364582, 0.13360856, 0.13357127, 0.13353392, 0.13349651, 0.133459, 0.13342148, 0.13338389, 0.13334623, 0.1333085, 0.13327074, 0.13323289, 0.133195, 0.13315701, 0.133119, 0.13308093, 0.13304278, 0.13300458, 0.13296631, 0.13292798, 0.13288961, 0.13285115, 0.13281265, 0.13277408, 0.13273546, 0.13269678, 0.13265803, 0.13261922, 0.13258035, 0.13254142, 0.13250244, 0.13246338, 0.13242428, 0.1323851, 0.13234587, 0.13230658, 0.13226722, 0.13222781, 0.13218834, 0.1321488, 0.13210921, 0.13206956, 0.13202983, 0.13199005, 0.13195021, 0.13191032, 0.13187036, 0.13183035, 0.13179027, 0.13175012, 0.13170993, 0.13166967, 0.13162933, 0.13158897, 0.13154852, 0.13150802, 0.13146746, 0.13142684, 0.13138616, 0.13134541, 0.13130461, 0.13126373, 0.13122281, 0.13118184, 0.13114078, 0.13109967, 0.13105851, 0.13101727, 0.13097598, 0.13093463, 0.13089323, 0.13085175, 0.13081022, 0.13076863, 0.13072698, 0.13068527, 0.13064349, 0.13060166, 0.13055976, 0.13051781, 0.13047579, 0.13043371, 0.13039157, 0.13034938, 0.13030712, 0.1302648, 0.13022242, 0.13017999, 0.13013749, 0.13009493, 0.13005231, 0.13000964, 0.12996688, 0.12992407, 0.12988122, 0.1298383, 0.12979531, 0.12975226, 0.12970917, 0.129666, 0.12962277, 0.1295795, 0.12953614, 0.12949274, 0.12944926, 0.12940575, 0.12936215, 0.12931851, 0.1292748, 0.12923102, 0.1291872, 0.1291433, 0.12909935, 0.12905535, 0.12901126, 0.12896714, 0.12892294, 0.12887868, 0.12883437, 0.12878999, 0.12874556, 0.12870106, 0.12865649, 0.12861189, 0.12856722, 0.12852247, 0.12847768, 0.12843281, 0.1283879, 0.12834291, 0.12829788, 0.12825276, 0.12820761, 0.12816238, 0.1281171, 0.12807176, 0.12802635, 0.1279809, 0.12793535, 0.12788977, 0.12784413, 0.12779842, 0.12775266, 0.12770683, 0.12766095, 0.12761497, 0.12756899, 0.12752292, 0.1274768, 0.12743059, 0.12738433, 0.12733802, 0.12729165, 0.12724522, 0.12719873, 0.12715217, 0.12710556, 0.12705888, 0.12701216, 0.12696536, 0.12691851, 0.12687159, 0.1268246, 0.12677757, 0.12673047, 0.12668331, 0.12663609, 0.12658881, 0.12654148, 0.12649406, 0.1264466, 0.1263991, 0.12635151, 0.12630387, 0.12625615, 0.12620839, 0.12616056, 0.12611268, 0.12606473, 0.12601672, 0.12596866, 0.12592053, 0.12587236, 0.12582411, 0.1257758, 0.12572743, 0.12567899, 0.12563051, 0.12558195, 0.12553334, 0.12548468, 0.12543593, 0.12538715, 0.12533829, 0.12528938, 0.12524042, 0.12519136, 0.12514228, 0.12509312, 0.1250439, 0.12499464, 0.1249453, 0.12489589, 0.12484644, 0.12479692, 0.12474734, 0.12469769, 0.124648, 0.12459823, 0.12454841, 0.12449853, 0.12444858, 0.12439858, 0.12434851, 0.1242984, 0.12424821, 0.12419796, 0.12414767, 0.1240973, 0.12404686, 0.12399638, 0.12394584, 0.12389522, 0.12384456, 0.12379383, 0.12374303, 0.12369218, 0.12364128, 0.1235903, 0.12353928, 0.12348818, 0.12343704, 0.12338582, 0.12333454, 0.12328319, 0.12323181, 0.12318035, 0.12312884, 0.12307727, 0.12302563, 0.12297393, 0.12292217, 0.12287036, 0.12281847, 0.12276653, 0.12271454, 0.12266248, 0.12261035, 0.12255818, 0.12250593, 0.12245364, 0.12240127, 0.12234884, 0.12229636, 0.12224382, 0.12219121, 0.12213854, 0.12208582, 0.12203302, 0.12198018, 0.12192728, 0.12187431, 0.12182127, 0.12176819, 0.12171503, 0.12166183, 0.12160856, 0.12155522, 0.12150183, 0.12144838, 0.12139487, 0.12134129, 0.12128765, 0.12123396, 0.12118021, 0.12112641, 0.12107253, 0.12101859, 0.12096459, 0.12091053, 0.12085641, 0.12080223, 0.12074798, 0.1206937, 0.12063933, 0.12058493, 0.12053044, 0.1204759, 0.12041984, 0.1203623, 0.12030474, 0.12024714, 0.12018951, 0.12013186, 0.12007415, 0.12001641, 0.11995866, 0.11990086, 0.11984304, 0.11978517, 0.11972727, 0.11966933, 0.11961139, 0.11955339, 0.11949538, 0.11943731, 0.11937921, 0.11932109, 0.11926293, 0.11920474, 0.11914652, 0.11908825, 0.11902996, 0.11897165, 0.11891329, 0.11885491, 0.11879648, 0.11873803, 0.11867954, 0.11862102, 0.11856248, 0.11850389, 0.11844527, 0.1183866, 0.11832794, 0.11826923, 0.11821046, 0.11815168, 0.11809287, 0.11803402, 0.11797515, 0.11791623, 0.11785727, 0.11779831, 0.1177393, 0.11768024, 0.11762117, 0.11756207, 0.11750291, 0.11744373, 0.11738452, 0.11732529, 0.11726601, 0.11720672, 0.11714736, 0.11708798, 0.11702859, 0.11696914, 0.11690966, 0.11685016, 0.11679061, 0.11673106, 0.11667145, 0.11661182, 0.11655213, 0.11649244, 0.1164327, 0.11637294, 0.11631312, 0.1162533, 0.11619343, 0.11613353, 0.11607361, 0.11601363, 0.11595364, 0.11589359, 0.11583354, 0.11577344, 0.11571331, 0.11565315, 0.11559295, 0.11553272, 0.11547246, 0.11541217, 0.11535183, 0.11529148, 0.11523107, 0.11517066, 0.11511019, 0.11504971, 0.1149892, 0.11492863, 0.11486805, 0.11480741, 0.11474676, 0.11468607, 0.11462535, 0.11456461, 0.1145038, 0.114443, 0.11438214, 0.11432125, 0.11426034, 0.11419938, 0.11413839, 0.11407737, 0.11401632, 0.11395524, 0.11389413, 0.11383298, 0.11377181, 0.11371058, 0.11364933, 0.11358805, 0.11352675, 0.11346539, 0.11340404, 0.11334261, 0.11328116, 0.11321969, 0.11315817, 0.11309663, 0.11303506, 0.11297344, 0.11291181, 0.11285012, 0.11278842, 0.11272668, 0.11266492, 0.1126031, 0.11254127, 0.11247939, 0.11241749, 0.11235556, 0.11229359, 0.11223158, 0.11216953, 0.11210747, 0.11204537, 0.11198325, 0.11192106, 0.11185887, 0.11179664, 0.11173436, 0.11167207, 0.11160973, 0.11154737, 0.11148497, 0.11142255, 0.11136009, 0.11129759, 0.11123505, 0.11117249, 0.1111099, 0.11104727, 0.11098462, 0.11092191, 0.11085919, 0.11079642, 0.11073364, 0.11067082, 0.11060795, 0.11054506, 0.11048214, 0.11041918, 0.11035619, 0.11029316, 0.11023013, 0.11016703, 0.11010391, 0.11004075, 0.10997757, 0.10991435, 0.10985108, 0.10978781, 0.10972449, 0.10966115, 0.10959776, 0.10953433, 0.10947089, 0.10940741, 0.1093439, 0.10928034, 0.10921676, 0.10915315, 0.10908951, 0.10902583, 0.10896211, 0.10889836, 0.10883459, 0.10877078, 0.10870694, 0.10864306, 0.10857914, 0.10851521, 0.10845123, 0.10838722, 0.10832319, 0.1082591, 0.108195, 0.10813086, 0.10806669, 0.10800248, 0.10793825, 0.10787398, 0.10780967, 0.10774533, 0.10768096, 0.10761656, 0.10755213, 0.10748766, 0.10742316, 0.10735863, 0.10729406, 0.10722945, 0.10716482, 0.10710015, 0.10703546, 0.10697072, 0.10690595, 0.10684116, 0.10677634, 0.10671147, 0.10664658, 0.10658165, 0.10651668, 0.10645171, 0.10638666, 0.10632161, 0.10625652, 0.1061914, 0.10612623, 0.10606103, 0.10599581, 0.10593056, 0.10586526, 0.10579994, 0.10573459, 0.1056692, 0.10560378, 0.10553832, 0.10547283, 0.10540731, 0.10534175, 0.10527618, 0.10521056, 0.1051449, 0.10507923, 0.1050135, 0.10494775, 0.10488197, 0.10481615, 0.10475031, 0.10468442, 0.10461851, 0.10455257, 0.10448659, 0.10442057, 0.10435453, 0.10428844, 0.10422234, 0.10415619, 0.10409001, 0.10402381, 0.10395756, 0.10389128, 0.10382497, 0.10375863, 0.10369226, 0.10362585, 0.1035594, 0.10349294, 0.10342643, 0.10335989, 0.10329332, 0.10322672, 0.10316008, 0.1030934, 0.1030267, 0.10295997, 0.1028932, 0.10282639, 0.10275955, 0.10269269, 0.1026258, 0.10255887, 0.1024919, 0.1024249, 0.10235786, 0.10229081, 0.10222369, 0.10215656, 0.10208941, 0.10202222, 0.10195499, 0.10188771, 0.10182042, 0.10175309, 0.10168574, 0.10161834, 0.10155091, 0.10148346, 0.10141597, 0.10134844, 0.10128088, 0.10121328, 0.10114566, 0.10107801, 0.10101032, 0.1009426, 0.10087484, 0.10080706, 0.10073923, 0.10067138, 0.1006035, 0.10053557, 0.10046762, 0.10039964, 0.10033162, 0.10026357, 0.10019549, 0.10012738, 0.10005922, 0.099991046, 0.099922836, 0.099854581, 0.099786289, 0.099717982, 0.09964963, 0.099581257, 0.099512845, 0.099444389, 0.099375926, 0.099307418, 0.099238865, 0.09917029, 0.099101685, 0.099033035, 0.098964363, 0.098895654, 0.098826908, 0.098758139, 0.09868934, 0.098620497, 0.098551616, 0.098482706, 0.098413773, 0.09834481, 0.09827581, 0.098206758, 0.098137692, 0.098068595, 0.097999461, 0.097930282, 0.097861089, 0.097791843, 0.09772259, 0.097653292, 0.09758395, 0.097514585, 0.09744519, 0.097375758, 0.097306289, 0.097236797, 0.097167261, 0.09709771, 0.097028114, 0.096958481, 0.096888818, 0.096819125, 0.096749395, 0.096679635, 0.096609838, 0.096540019, 0.09647017, 0.096400268, 0.096330345, 0.096260384, 0.096190408, 0.096120387, 0.096050307, 0.095980227, 0.095910117, 0.095839962, 0.09576977, 0.095699541, 0.095629297, 0.095559008, 0.09548869, 0.095418327, 0.095347956, 0.095277533, 0.095207088, 0.095136613, 0.095066085, 0.094995536, 0.094924957, 0.094854347, 0.094783694, 0.09471301, 0.094642304, 0.094571561, 0.09450078, 0.094429962, 0.09435913, 0.094288252, 0.09421733, 0.094146393, 0.094075419, 0.094004408, 0.093933366, 0.093862295, 0.093791187, 0.093720049, 0.093648866, 0.093577668, 0.093506418, 0.093435153, 0.093363851, 0.093292519, 0.093221143, 0.093149737, 0.093078293, 0.093006834, 0.092935331, 0.092863798, 0.092792235, 0.092720628, 0.09264899, 0.092577331, 0.092505626, 0.0924339, 0.092362128, 0.092290334, 0.092218503, 0.092146643, 0.092074737, 0.092002824, 0.091930859, 0.091858856, 0.091786824, 0.09171477, 0.09164267, 0.091570549, 0.09149839, 0.091426194, 0.091353983, 0.09128172, 0.091209427, 0.091137104, 0.091064751, 0.090992361, 0.090919927, 0.090847485, 0.090774998, 0.090702474, 0.09062992, 0.090557329, 0.090484716, 0.090412058, 0.090339378, 0.090266645, 0.090193905, 0.090121128, 0.090048313, 0.089975461, 0.089902572, 0.089829654, 0.089756712, 0.089683741, 0.089610711, 0.089537658, 0.08946459, 0.089391485, 0.089318343, 0.089245148, 0.089171946, 0.089098692, 0.08902543, 0.088952109, 0.088878766, 0.0888054, 0.088731997, 0.088658556, 0.088585064, 0.088511571, 0.088438027, 0.088364452, 0.08829084, 0.088217221, 0.088143542, 0.088069841, 0.087996095, 0.087922327, 0.087848529, 0.087774694, 0.087700836, 0.087626912, 0.087552868, 0.087478638, 0.087404415, 0.087330207, 0.087255985, 0.087181792, 0.087107584, 0.087033406, 0.086959213, 0.086885042, 0.086810879, 0.086736724, 0.086662576, 0.08658842, 0.086514279, 0.086440168, 0.086366042, 0.086291924, 0.086217813, 0.086143725, 0.086069643, 0.085995555, 0.085921481, 0.085847415, 0.085773356, 0.085699297, 0.085625254, 0.085551217, 0.085477196, 0.085403182, 0.085329145, 0.085255146, 0.085181154, 0.085107163, 0.085033186, 0.084959194, 0.084885232, 0.084811278, 0.084737323, 0.084663376, 0.084589429, 0.084515505, 0.084441587, 0.084367678, 0.08429376, 0.084219858, 0.084145978, 0.084072091, 0.083998211, 0.083924338, 0.083850481, 0.083776623, 0.083702788, 0.08362893, 0.08355511, 0.083481282, 0.083407477, 0.083333664, 0.083259858, 0.083186068, 0.083112277, 0.083038509, 0.082964733, 0.082890965, 0.082817212, 0.082743466, 0.082669728, 0.082595989, 0.082522273, 0.082448564, 0.082374841, 0.08230114, 0.082227454, 0.082153752, 0.082080081, 0.082006417, 0.081932738, 0.081859097, 0.08178544, 0.081711799, 0.081638165, 0.081564538, 0.081490919, 0.081417315, 0.081343718, 0.081270114, 0.081196532, 0.081122942, 0.081049375, 0.080975808, 0.080902249, 0.080828704, 0.080755167, 0.080681629, 0.080608092, 0.080534585, 0.08046107, 0.080387563, 0.080314055, 0.080240577, 0.080167092, 0.080093622, 0.080020159, 0.079946697, 0.079873241, 0.079799809, 0.079726376, 0.079652943, 0.079579517, 0.079506107, 0.079432704, 0.0793593, 0.079285905, 0.079212524, 0.079139158, 0.079065792, 0.078992426, 0.078919075, 0.078845732, 0.078772403, 0.078699067, 0.078625739, 0.078552425, 0.078479126, 0.078405827, 0.078332528, 0.078259252, 0.078185976, 0.078112699, 0.078039445, 0.077966183, 0.077892944, 0.077819712, 0.077746481, 0.077673249, 0.07760004, 0.07752683, 0.077453636, 0.077380434, 0.077307247, 0.077234082, 0.07716091, 0.077087753, 0.077014588, 0.076941438, 0.076868303, 0.076795176, 0.076722041, 0.076648921, 0.076575823, 0.076502718, 0.076429628, 0.076356545, 0.076283462, 0.076210395, 0.076137334, 0.076064274, 0.075991221, 0.07591819, 0.075845152, 0.075772129, 0.075699106, 0.075626098, 0.075553104, 0.075480111, 0.075407118, 0.075334132, 0.075261161, 0.075188205, 0.075115256, 0.0750423, 0.074969351, 0.074896425, 0.074823499, 0.074750565, 0.074677661, 0.074604765, 0.074531868, 0.074458987, 0.074386097, 0.074313223, 0.074240364, 0.074167505, 0.074094646, 0.074021794, 0.073948972, 0.073876143, 0.073803328, 0.073730513, 0.073657706, 0.073584907, 0.073512122, 0.073439337, 0.073366567, 0.073293798, 0.073221043, 0.073148295, 0.07307554, 0.073002808, 0.072930075, 0.072857365, 0.07278464, 0.072711945, 0.072639249, 0.072566561, 0.072493874, 0.072421193, 0.07234852, 0.07227587, 0.072203219, 0.072130568, 0.072057933, 0.071985304, 0.071912684, 0.07184007, 0.071767464, 0.071694858, 0.071622267, 0.071549684, 0.071477108, 0.071404546, 0.071331985, 0.071259424, 0.071186878, 0.071114339, 0.071041808, 0.070969291, 0.070896775, 0.070824265, 0.070751764, 0.070679277, 0.07060679, 0.070534311, 0.070461839, 0.070389375, 0.070316918, 0.070244476, 0.070172027, 0.0700996, 0.070027173, 0.06995476, 0.069882356, 0.069809951, 0.069737554, 0.069665171, 0.069592789, 0.069520414, 0.069448054, 0.069375694, 0.069303349, 0.069231011, 0.069158673, 0.069086358, 0.069014028, 0.068941727, 0.068869419, 0.068797119, 0.068724833, 0.068652548, 0.068580285, 0.068508022, 0.068435766, 0.06836351, 0.068291277, 0.068219036, 0.06814681, 0.068074599, 0.068002388, 0.067930184, 0.067857988, 0.067785792, 0.067713618, 0.067641445, 0.067569271, 0.067497112, 0.067424968, 0.067352831, 0.067280695, 0.067208558, 0.067136437, 0.06706433, 0.066992223, 0.066920117, 0.066848032, 0.066775955, 0.066703878, 0.066631816, 0.066559747, 0.0664877, 0.06641566, 0.066343628, 0.066271588, 0.066199571, 0.066127546, 0.066055551, 0.065983564, 0.065911561, 0.065839574, 0.065767601, 0.065695636, 0.065623678, 0.065551728, 0.06547977, 0.065407835, 0.065335907, 0.065263987, 0.065192074, 0.065120168, 0.065048277, 0.064976372, 0.064904489, 0.064832605, 0.064760752, 0.064688884, 0.06461703, 0.064545184, 0.064473346, 0.064401515, 0.064329684, 0.064257868, 0.064186066, 0.064114273, 0.064042479, 0.063970678, 0.063898906, 0.063827142, 0.063755378, 0.063683622, 0.063611872, 0.063540131, 0.063468404, 0.063396677, 0.063324951, 0.063253239, 0.063181542, 0.063109845, 0.063038163, 0.062966481, 0.062894814, 0.062823147, 0.062751494, 0.062679842, 0.062608197, 0.062536567, 0.062464945, 0.062393323, 0.062321723, 0.062250119, 0.06217853, 0.06210693, 0.062035356, 0.061963778, 0.061892223, 0.061820667, 0.061749104, 0.061677564, 0.061606035, 0.061534513, 0.061462991, 0.061391465, 0.06131997, 0.061248474, 0.061176993, 0.061105497, 0.061034027, 0.060962558, 0.060891103, 0.060819659, 0.060748205, 0.060676776, 0.060605343, 0.06053393, 0.060462505, 0.060391109, 0.060319707, 0.060248315, 0.060176942, 0.060105551, 0.060034193, 0.059962839, 0.059891481, 0.059820138, 0.059748802, 0.05967747, 0.059606142, 0.05953484, 0.059463535, 0.05939224, 0.059320949, 0.059249658, 0.05917839, 0.059107117, 0.05903586, 0.05896461, 0.05889336, 0.058822118, 0.058750886, 0.05867967, 0.05860845, 0.058537234, 0.058466043, 0.058394853, 0.058323663, 0.058252491, 0.058181308, 0.058110151, 0.058039006, 0.057967857, 0.057896711, 0.05782558, 0.057754457, 0.057683345, 0.057612248, 0.057541125, 0.057470039, 0.057398953, 0.057327878, 0.057256799, 0.057185739, 0.057114683, 0.057043638, 0.056972601, 0.056901574, 0.056830537, 0.056759525, 0.056688514, 0.05661751, 0.056546524, 0.056475546, 0.056404553, 0.056333575, 0.056262612, 0.05619166, 0.056120716, 0.056049775, 0.055978831, 0.055907913, 0.055836994, 0.055766083, 0.055695184, 0.05562428, 0.055553392, 0.055482518, 0.055411644, 0.055340771, 0.055269916, 0.055199072, 0.055128224, 0.055057395, 0.054986555, 0.054915741, 0.054844931, 0.054774128, 0.054703321, 0.054632537, 0.054561753, 0.054490987, 0.054420214, 0.054349456, 0.054278702, 0.054207969, 0.054137226, 0.054066505, 0.053995769, 0.05392506, 0.053854357, 0.053783663, 0.053712972, 0.053642292, 0.053571612, 0.053500943, 0.053430285, 0.053359639, 0.053288992, 0.053218354, 0.053147722, 0.053077102, 0.053006485, 0.052935883, 0.052865285, 0.052794684, 0.052724101, 0.052653529, 0.052582964, 0.052512404, 0.052441839, 0.052371293, 0.052300762, 0.052230239, 0.052159697, 0.052089188, 0.05201868, 0.051948186, 0.051877689, 0.051807206, 0.051736727, 0.05166626, 0.0515958, 0.051525336, 0.051454891, 0.05138579, 0.051317997, 0.05125026, 0.051182542, 0.05111488, 0.051047251, 0.050979663, 0.050912105, 0.050844606, 0.050777119, 0.050709676, 0.050642282, 0.050574932, 0.050507609, 0.050440338, 0.050373092, 0.050305881, 0.050238717, 0.050171595, 0.050104499, 0.050037462, 0.049970444, 0.049903475, 0.049836554, 0.049769651, 0.04970279, 0.049635988, 0.049569208, 0.049502477, 0.049435776, 0.049369104, 0.049302492, 0.049235906, 0.049169373, 0.049102854, 0.049036387, 0.048969965, 0.048903588, 0.048837237, 0.048770916, 0.048704654, 0.048638415, 0.048572235, 0.048506077, 0.048439957, 0.048373882, 0.04830784, 0.048241839, 0.048175894, 0.048109952, 0.048044078, 0.047978241, 0.047912437, 0.047846675, 0.047780942, 0.047715265, 0.047649615, 0.04758399, 0.047518428, 0.047452904, 0.04738741, 0.047321934, 0.047256526, 0.047191154, 0.047125813, 0.047060531, 0.046995245, 0.046930034, 0.046864845, 0.046799708, 0.046734598, 0.046669528, 0.046604507, 0.046539512, 0.046474554, 0.046409655, 0.046344783, 0.046279941, 0.046215154, 0.046150394, 0.046085685, 0.046021011, 0.045956366, 0.045891758, 0.045827188, 0.045762684, 0.045698188, 0.045633752, 0.045569349, 0.045504976, 0.045440637, 0.045376349, 0.04531211, 0.045247898, 0.045183729, 0.045119584, 0.045055483, 0.044991445, 0.044927418, 0.044863444, 0.044799503, 0.044735603, 0.044671737, 0.044607904, 0.044544138, 0.044480376, 0.044416688, 0.044353005, 0.044289373, 0.044225797, 0.044162236, 0.044098735, 0.044035256, 0.043971807, 0.043908421, 0.043845065, 0.043781757, 0.043718468, 0.043655217, 0.043592021, 0.043528862, 0.043465756, 0.043402646, 0.043339591, 0.043276601, 0.043213625, 0.043150708, 0.04308781, 0.043024953, 0.042962141, 0.042899363, 0.042836633, 0.042773947, 0.042711284, 0.042648666, 0.042586088, 0.042523548, 0.042461041, 0.042398583, 0.042336155, 0.042273775, 0.042211413, 0.042149108, 0.042086847, 0.042024609, 0.041962419, 0.041900262, 0.041838165, 0.04177608, 0.041714031, 0.041652054, 0.041590076, 0.041528177, 0.041466285, 0.041404434, 0.041342646, 0.041280877, 0.041219164, 0.041157458, 0.041095812, 0.041034218, 0.040972643, 0.040911101, 0.040849611, 0.040788162, 0.040726762, 0.040665377, 0.04060404, 0.04054274, 0.040481463, 0.040420264, 0.040359069, 0.04029794, 0.040236834, 0.040175758, 0.040114742, 0.040053762, 0.039992798, 0.039931901, 0.039871011, 0.039810184, 0.039749406, 0.039688651, 0.039627932, 0.039567258, 0.039506596, 0.039446011, 0.039385468, 0.039324947, 0.039264448, 0.039204005, 0.039143607, 0.039083242, 0.039022923, 0.038962625, 0.038902361, 0.038842171, 0.038781993, 0.038721848, 0.038661771, 0.038601704, 0.038541708, 0.038481712, 0.038421784, 0.038361888, 0.038302008, 0.03824221, 0.038182404, 0.038122669, 0.03806296, 0.038003303, 0.03794368, 0.037884083, 0.037824534, 0.037765022, 0.037705559, 0.037646126, 0.037586726, 0.037527371, 0.037468053, 0.037408777, 0.03734953, 0.037290353, 0.03723117, 0.037172049, 0.037112974, 0.037053917, 0.036994942, 0.036935952, 0.036877029, 0.036818139, 0.036759283, 0.036700498, 0.036641702, 0.036582954, 0.036524266, 0.036465604, 0.036407005, 0.036348421, 0.036289874, 0.036231376, 0.036172908, 0.036114503, 0.036056109, 0.035997748, 0.035939455, 0.035881191, 0.035822969, 0.035764765, 0.035706617, 0.03564851, 0.035590436, 0.035532389, 0.035474401, 0.035416447, 0.03535853, 0.035300653, 0.035242796, 0.035185013, 0.035127252, 0.035069529, 0.035011843, 0.034954187, 0.034896579, 0.034839004, 0.034781486, 0.034724001, 0.034666535, 0.034609128, 0.034551751, 0.034494415, 0.034437127, 0.034379851, 0.03432266, 0.034265462, 0.034208316, 0.03415123, 0.034094155, 0.034037147, 0.03398015, 0.033923198, 0.033866297, 0.033809423, 0.033752609, 0.03369581, 0.033639036, 0.033582337, 0.033525664, 0.033469025, 0.033412427, 0.033355866, 0.03329936, 0.033242866, 0.033186428, 0.033130031, 0.033073675, 0.033017337, 0.032961041, 0.032904807, 0.032848589, 0.032792427, 0.032736301, 0.032680202, 0.03262414, 0.032568134, 0.032512169, 0.032456219, 0.032400329, 0.032344449, 0.032288644, 0.032232866, 0.03217712, 0.032121427, 0.032065753, 0.032010134, 0.031954542, 0.031898994, 0.031843487, 0.031788014, 0.031732596, 0.031677183, 0.031621836, 0.03156653, 0.031511236, 0.031455986, 0.031400811, 0.031345647, 0.031290535, 0.031235449, 0.0311804, 0.031125406, 0.031070421, 0.031015495, 0.030960612, 0.030905763, 0.03085096, 0.030796183, 0.030741457, 0.03068677, 0.030632107, 0.03057749, 0.030522905, 0.030468382, 0.030413885, 0.030359419, 0.030305004, 0.03025062, 0.030196264, 0.03014197, 0.030087704, 0.030033479, 0.029979283, 0.02992513, 0.02987103, 0.029816948, 0.029762944, 0.029708918, 0.02965495, 0.029601056, 0.029547183, 0.029493326, 0.029439531, 0.029385753, 0.029332051, 0.029278364, 0.029224722, 0.029171126, 0.029117538, 0.029064022, 0.029010532, 0.028957076, 0.028903667, 0.028850304, 0.02879698, 0.028743675, 0.028690407, 0.028637204, 0.02858402, 0.028530875, 0.028477779, 0.028424727, 0.028371701, 0.028318716, 0.028265759, 0.028212866, 0.02816, 0.028107164, 0.02805437, 0.028001618, 0.02794892, 0.027896248, 0.0278436, 0.027791006, 0.027738452, 0.027685946, 0.027633462, 0.027581006, 0.027528612, 0.027476236, 0.027423922, 0.027371649, 0.027319394, 0.02726719, 0.027215023, 0.027162898, 0.027110793, 0.02705873, 0.027006734, 0.02695477, 0.026902836, 0.026850931, 0.026799057, 0.026747253, 0.026695488, 0.026643733, 0.026592037, 0.026540363, 0.026488749, 0.026437165, 0.026385609, 0.026334105, 0.026282631, 0.026231216, 0.026179813, 0.026128467, 0.026077144, 0.026025878, 0.025974656, 0.02592344, 0.025872285, 0.02582117, 0.025770076, 0.025719032, 0.025668047, 0.025617072, 0.025566148, 0.025515264, 0.025464421, 0.025413606, 0.02536284, 0.025312107, 0.025261421, 0.025210759, 0.025160154, 0.025109569, 0.025059037, 0.025008542, 0.024958078, 0.024907663, 0.024857288, 0.024806935, 0.02475664, 0.024706377, 0.024656143, 0.024605958, 0.024555793, 0.024505699, 0.024455637, 0.024405602, 0.024355616, 0.024305644, 0.02425574, 0.024205854, 0.024156032, 0.024106236, 0.024056463, 0.024006749, 0.023957055, 0.02390741, 0.023857838, 0.023808243, 0.02375873, 0.023709234, 0.023659782, 0.023610367, 0.023561005, 0.023511669, 0.023462385, 0.023413122, 0.023363907, 0.023314724, 0.023265619, 0.023216495, 0.023167443, 0.023118408, 0.023069434, 0.02302048, 0.022971576, 0.022922713, 0.022873878, 0.022825098, 0.022776352, 0.022727638, 0.022678964, 0.022630341, 0.022581737, 0.022533204, 0.022484669, 0.022436196, 0.022387762, 0.022340914, 0.022295741, 0.022250649, 0.022205586, 0.022160543, 0.022115579, 0.022070628, 0.022025766, 0.02198093, 0.021936139, 0.021891408, 0.021846695, 0.021802071, 0.02175748, 0.021712897, 0.021668416, 0.021623934, 0.021579539, 0.021535156, 0.021490835, 0.021446582, 0.02140235, 0.021358175, 0.021314025, 0.021269953, 0.021225929, 0.021181928, 0.021137975, 0.021094082, 0.021050241, 0.021006437, 0.020962676, 0.020918963, 0.020875301, 0.020831687, 0.020788116, 0.020744594, 0.020701133, 0.0206577, 0.020614317, 0.020570986, 0.020527693, 0.020484461, 0.020441258, 0.020398116, 0.020355003, 0.020311963, 0.02026896, 0.020225996, 0.020183086, 0.020140193, 0.020097401, 0.020054638, 0.020011896, 0.019969236, 0.019926574, 0.01988402, 0.01984147, 0.019798957, 0.019756544, 0.019714134, 0.01967179, 0.019629478, 0.019587219, 0.019545024, 0.019502863, 0.019460762, 0.01941867, 0.019376639, 0.019334666, 0.019292744, 0.019250853, 0.019209022, 0.019167239, 0.019125497, 0.019083794, 0.019042172, 0.019000562, 0.018959008, 0.018917508, 0.018876046, 0.018834624, 0.018793264, 0.018751932, 0.018710662, 0.01866946, 0.018628277, 0.018587155, 0.018546054, 0.018505001, 0.01846402, 0.01842309, 0.018382188, 0.018341355, 0.018300515, 0.018259782, 0.018219061, 0.018178411, 0.018137788, 0.018097227, 0.018056696, 0.018016225, 0.017975813, 0.017935432, 0.017895078, 0.017854808, 0.017814538, 0.017774366, 0.017734235, 0.017694123, 0.017654071, 0.017614041, 0.0175741, 0.017534168, 0.017494317, 0.017454505, 0.017414723, 0.017375013, 0.017335322, 0.01729569, 0.01725612, 0.017216567, 0.017177068, 0.017137628, 0.017098244, 0.017058903, 0.017019602, 0.016980322, 0.016941121, 0.016901949, 0.016862849, 0.016823769, 0.016784767, 0.016745785, 0.016706865, 0.016667983, 0.016629143, 0.016590351, 0.016551603, 0.01651291, 0.01647426, 0.016435679, 0.016397117, 0.016358608, 0.016320156, 0.016281724, 0.016243372, 0.016205054, 0.016166791, 0.016128572, 0.016090371, 0.016052259, 0.016014149, 0.015976109, 0.015938139, 0.015900176, 0.015862297, 0.015824446, 0.015786644, 0.015748914, 0.015711164, 0.015673513, 0.015635882, 0.015598311, 0.015560802, 0.015523341, 0.015485919, 0.015448519, 0.015411179, 0.015373888, 0.015336658, 0.015299456, 0.015262307, 0.015225227, 0.015188166, 0.015151165, 0.015114205, 0.015077286, 0.015040433, 0.015003595, 0.014966832, 0.014930135, 0.014893433, 0.0148568, 0.014820192, 0.014783683, 0.014747192, 0.01471074, 0.014674341, 0.014637991, 0.01460171, 0.01456544, 0.014529241, 0.01449308, 0.014456939, 0.014420889, 0.01438484, 0.014348879, 0.014312979, 0.014277068, 0.014241247, 0.014205438, 0.014169699, 0.014134017, 0.014098369, 0.014062778, 0.014027218, 0.013991699, 0.013956248, 0.013920838, 0.013885489, 0.013850149, 0.013814868, 0.013779638, 0.013744489, 0.013709368, 0.013674268, 0.013639239, 0.013604229, 0.013569289, 0.013534399, 0.013499539, 0.013464749, 0.01342999, 0.01339529, 0.01336062, 0.013326, 0.013291421, 0.013256911, 0.013222421, 0.013188032, 0.013153641, 0.013119302, 0.013084992, 0.013050773, 0.013016563, 0.012982412, 0.012948333, 0.012914265, 0.012880274, 0.012846295, 0.012812396, 0.012778535, 0.012744707, 0.012710947, 0.012677197, 0.012643527, 0.012609898, 0.012576319, 0.012542799, 0.01250929, 0.012475841, 0.012442441, 0.012409091, 0.012375803, 0.012342553, 0.012309343, 0.012276175, 0.012243056, 0.012210015, 0.012176966, 0.012143977, 0.012111058, 0.012078199, 0.012045349, 0.01201257, 0.011979821, 0.011947132, 0.011914472, 0.011881882, 0.011849324, 0.011816824, 0.011784376, 0.011751946, 0.011719567, 0.011687257, 0.011654988, 0.01162276, 0.01159058, 0.011558451, 0.011526392, 0.011494353, 0.011462355, 0.011430416, 0.011398486, 0.011366648, 0.011334849, 0.0113031, 0.0112714, 0.011239733, 0.011208112, 0.011176534, 0.011145015, 0.011113566, 0.011082098, 0.011050729, 0.011019399, 0.01098811, 0.010956902, 0.010925673, 0.010894544, 0.010863416, 0.010832386, 0.010801368, 0.01077043, 0.010739501, 0.010708632, 0.010677823, 0.010647045, 0.010616326, 0.010585657, 0.010554998, 0.01052444, 0.010493901, 0.010463413, 0.010432964, 0.010402546, 0.010372207, 0.010341898, 0.01031168, 0.010281461, 0.010251292, 0.010221174, 0.010191086, 0.010161096, 0.01013111, 0.01010117, 0.010071302, 0.010041463, 0.010011685, 0.0099819265, 0.0099522388, 0.0099225994, 0.0098929815, 0.0098634427, 0.009833945, 0.0098044863, 0.0097750779, 0.00974569, 0.0097163925, 0.0096870838, 0.0096578654, 0.0096286973, 0.0095995786, 0.0095705101, 0.0095414529, 0.0095124645, 0.0094835162, 0.0094546173, 0.0094257798, 0.0093969516, 0.0093682138, 0.0093395049, 0.0093108369, 0.009282249, 0.0092536509, 0.0092251329, 0.0091966456, 0.0091682272, 0.0091398694, 0.0091115311, 0.009083244, 0.0090549849, 0.0090268068, 0.0089986492, 0.0089705409, 0.0089424932, 0.0089144865, 0.0088865478, 0.0088586099, 0.0088307625, 0.0088029439, 0.0087751662, 0.0087474389, 0.0087197404, 0.008692123, 0.0086645642, 0.0086370073, 0.0086095389, 0.0085820714, 0.008554684, 0.0085273366, 0.0085000079, 0.0084727714, 0.0084455637, 0.0084184064, 0.0083912788, 0.0083642099, 0.0083372016, 0.0083102155, 0.0082832873, 0.0082563991, 0.0082295816, 0.0082028247, 0.008176038, 0.0081493501, 0.0081227021, 0.0080961045, 0.0080695469, 0.0080430303, 0.0080166021, 0.0079901842, 0.0079638278, 0.0079374993, 0.007911223, 0.007884996, 0.0078588072, 0.0078326799, 0.0078066029, 0.0077805752, 0.0077545885, 0.0077286409, 0.0077027432, 0.0076768757, 0.0076510883, 0.0076253316, 0.0075996048, 0.0075739673, 0.0075483397, 0.0075227828, 0.0074972655, 0.0074717784, 0.0074463515, 0.0074209445, 0.0073956363, 0.0073703397, 0.0073451232, 0.0073199258, 0.0072947489, 0.0072696712, 0.0072446037, 0.0072195972, 0.0071946508, 0.0071697431, 0.0071448861, 0.0071200598, 0.0070952824, 0.0070705749, 0.0070458688, 0.0070212414, 0.006996654, 0.0069721378, 0.0069476306, 0.0069231936, 0.0068988167, 0.0068744398, 0.006850143, 0.006825876, 0.006801669, 0.0067775222, 0.0067534158, 0.0067293392, 0.0067053223, 0.0066813254, 0.0066574086, 0.006633522, 0.006609695, 0.0065858983, 0.0065621715, 0.0065384954, 0.0065148384, 0.0064912317, 0.0064676749, 0.0064441585, 0.0064206915, 0.006397285, 0.0063739489, 0.0063506118, 0.006327345, 0.0063040988, 0.0062809424, 0.006257806, 0.0062347096, 0.0062116729, 0.0061886865, 0.0061657699, 0.0061428831, 0.0061200066, 0.0060972204, 0.0060744341, 0.0060517378, 0.0060290713, 0.0060064648, 0.0059839087, 0.0059613623, 0.0059389062, 0.0059164595, 0.0058940831, 0.0058717569, 0.0058494508, 0.0058272444, 0.0058050379, 0.005782892, 0.0057607857, 0.0057387194, 0.0057167229, 0.0056947572, 0.0056728511, 0.0056509846, 0.0056291786, 0.0056084809, 0.0055889003, 0.0055693546, 0.0055498444, 0.0055303788, 0.0055109132, 0.0054915179, 0.005472152, 0.0054528168, 0.0054335068, 0.0054142163, 0.0053949906, 0.0053757704, 0.0053565996, 0.0053374544, 0.0053183641, 0.0052992888, 0.0052802484, 0.0052612326, 0.0052422523, 0.0052233227, 0.0052044219, 0.005185537, 0.0051667062, 0.0051479163, 0.0051291259, 0.0051103854, 0.0050916849, 0.0050730151, 0.0050543696, 0.0050357743, 0.0050172089, 0.004998669, 0.0049801641, 0.0049616937, 0.0049432586, 0.0049248431, 0.0049064779, 0.0048881527, 0.0048698424, 0.0048515773, 0.0048333327, 0.0048151324, 0.0047969618, 0.0047788168, 0.0047607166, 0.0047426717, 0.0047246367, 0.0047066319, 0.0046886415, 0.004670721, 0.0046528117, 0.0046349415, 0.0046171113, 0.0045993216, 0.0045815562, 0.0045638215, 0.0045461161, 0.0045284461, 0.0045108115, 0.0044932114, 0.0044756415, 0.0044581215, 0.0044406164, 0.0044231513, 0.0044057169, 0.0043883221, 0.004370952, 0.004353622, 0.0043363124, 0.0043190527, 0.0043018274, 0.0042846324, 0.0042674677, 0.0042503229, 0.004233228, 0.0042161634, 0.0041991333, 0.0041821389, 0.004165194, 0.004148249, 0.0041313693, 0.0041144849, 0.0040976549, 0.0040808599, 0.0040640905, 0.0040473654, 0.0040306863, 0.0040140362, 0.0039973967, 0.0039808019, 0.0039642323, 0.0039477129, 0.0039312029, 0.003914733, 0.0038983237, 0.0038819294, 0.0038655747, 0.0038492351, 0.0038329503, 0.003816681, 0.0038004613, 0.0037842612, 0.0037681272, 0.0037519874, 0.0037358929, 0.0037198334, 0.0037037991, 0.0036878095, 0.0036718498, 0.0036559203, 0.003640041, 0.0036241864, 0.0036083523, 0.0035925675, 0.0035768084, 0.0035610737, 0.003545389, 0.00352972, 0.0035141001, 0.0034985261, 0.0034829667, 0.0034674373, 0.0034519529, 0.0034364937, 0.0034210742, 0.0034056648, 0.0033903103, 0.0033750013, 0.003359702, 0.0033444627, 0.0033292284, 0.0033140541, 0.0032988798, 0.0032837605, 0.0032686763, 0.0032536371, 0.0032386177, 0.0032236136, 0.0032086545, 0.0031937351, 0.0031788559, 0.0031640017, 0.0031491825, 0.0031344036, 0.0031196591, 0.0031049249, 0.003090241, 0.0030755969, 0.0030609528, 0.0030463736, 0.0030318145, 0.0030173205, 0.0030028212, 0.0029883822, 0.0029739582, 0.002959579, 0.0029452201, 0.0029308961, 0.002916612, 0.0029023581, 0.0028881491, 0.0028739648, 0.0028598108, 0.0028456922, 0.0028316129, 0.0028175639, 0.002803545, 0.0027895612, 0.0027756323, 0.0027617083, 0.0027478095, 0.0027339703, 0.0027201464, 0.0027063678, 0.0026926089, 0.0026789051, 0.0026652312, 0.0026515974, 0.0026379733, 0.0026243897, 0.0026108406, 0.002597312, 0.0025838332, 0.0025703795, 0.0025569908, 0.0025436119, 0.0025302682, 0.0025169444, 0.0025036656, 0.0024904169, 0.0024771981, 0.0024640244, 0.0024508757, 0.002437772, 0.0024246883, 0.0024116496, 0.0023986311, 0.0023856473, 0.0023727037, 0.0023597952, 0.0023469315, 0.0023340879, 0.0023212694, 0.0023084907, 0.002295742, 0.0022830234, 0.0022703549, 0.0022577061, 0.0022451025, 0.0022325392, 0.0022199955, 0.0022074871, 0.0021950135, 0.00218256, 0.0021701467, 0.002157768, 0.0021454245, 0.0021331261, 0.0021208476, 0.0021086142, 0.0020964057, 0.0020842375, 0.002072084, 0.0020599805, 0.0020479071, 0.0020358637, 0.0020238704, 0.002011887, 0.0019999437, 0.0019880401, 0.001976172, 0.0019643186, 0.0019525151, 0.0019407619, 0.0019290186, 0.0019173103, 0.001905622, 0.0018939888, 0.0018823805, 0.0018708123, 0.0018592689, 0.0018477808, 0.0018363075, 0.0018248794, 0.001813471, 0.0018020879, 0.0017907495, 0.0017794415, 0.0017681881, 0.0017569402, 0.0017457519, 0.0017345637, 0.0017234456, 0.0017123275, 0.0017012693, 0.0016902264, 0.0016792432, 0.0016682701, 0.0016573271, 0.0016464189, 0.0016355509, 0.0016247128, 0.0016139098, 0.0016031517, 0.0015924289, 0.0015817358, 0.0015710578, 0.0015604247, 0.0015498167, 0.0015392489, 0.0015287207, 0.0015181978, 0.0015077549, 0.0014973219, 0.001486929, 0.0014765561, 0.0014662232, 0.0014559152, 0.0014456473, 0.0014354195, 0.0014252167, 0.0014150687, 0.0014049258, 0.001394833, 0.0013847653, 0.0013747273, 0.0013647346, 0.0013547767, 0.001344844, 0.001334956, 0.0013250883, 0.0013152605, 0.0013054579, 0.0012956901, 0.0012859623, 0.0012762496, 0.0012665968, 0.0012569842, 0.0012473916, 0.0012378289, 0.0012282861, 0.0012187983, 0.0012093257, 0.0011999031, 0.0011904954, 0.0011811578, 0.0011718251, 0.0011625326, 0.0011532649, 0.0011440373, 0.0011348447, 0.0011256773, 0.0011165496, 0.001107477, 0.0010984245, 0.001089377, 0.0010803894, 0.0010714319, 0.0010624994, 0.0010536069, 0.0010447444, 0.0010359319, 0.0010271394, 0.0010183869, 0.0010096595, 0.0010009621, 0.00099229463, 0.00098368211, 0.00097507471, 0.00096653233, 0.00095801486, 0.00094952254, 0.00094106013, 0.00093263271, 0.00092425541, 0.00091588311, 0.00090755569, 0.00089926331, 0.00089103112, 0.00088279875, 0.00087461644, 0.00086645409, 0.00085832685, 0.00085023954, 0.00084218231, 0.00083416502, 0.00082618278, 0.00081824057, 0.00081030332, 0.00080242107, 0.00079455884, 0.00078674167, 0.00077894953, 0.00077119225, 0.0007634901, 0.0007558029, 0.00074815581, 0.00074052362, 0.0007329465, 0.00072537939, 0.00071786222, 0.00071036519, 0.00070294301, 0.00069552095, 0.00068813883, 0.00068077684, 0.00067344971, 0.00066617265, 0.00065891567, 0.00065169856, 0.00064451655, 0.00063737453, 0.00063025253, 0.00062317058, 0.00061610859, 0.0006090916, 0.00060210959, 0.00059515267, 0.00058825075, 0.00058137381, 0.00057451183, 0.0005677049, 0.000560913, 0.00055416615, 0.00054744922, 0.00054076232, 0.00053411047, 0.00052751857, 0.00052093674, 0.00051438488, 0.00050786312, 0.00050138624, 0.00049492443, 0.00048851757, 0.00048213082, 0.00047580904, 0.00046948722, 0.00046319549, 0.00045695875, 0.00045073696, 0.00044456025, 0.0004384185, 0.00043230175, 0.00042623005, 0.00042018836, 0.00041416666, 0.00040819001, 0.00040224328, 0.00039632662, 0.000390445, 0.00038460334, 0.0003788117, 0.00037303008, 0.00036728848, 0.00036156684, 0.00035589025, 0.00035023366, 0.00034463211, 0.00033904551, 0.00033349893, 0.0003280174, 0.00032253083, 0.00031708929, 0.00031168282, 0.00030630629, 0.00030095977, 0.00029564329, 0.00029036176, 0.00028514033, 0.00027992885, 0.00027474738, 0.00026961093, 0.00026449451, 0.00025942805, 0.00025437164, 0.00024938025, 0.00024440882, 0.00023947244, 0.00023456106, 0.00022968969, 0.00022484333, 0.00022002697, 0.00021526564, 0.00021052429, 0.00020582798, 0.00020115664, 0.00019651535, 0.00019189905, 0.00018733276, 0.00018278648, 0.00017827022, 0.00017380893, 0.0001693877, 0.00016498646, 0.00016060524, 0.00015627901, 0.0001519628, 0.00014769658, 0.00014345041, 0.00013926423, 0.00013506305, 0.00013094187, 0.00012684573, 0.00012276958, 0.00011873843, 0.00011472231, 0.00011075619, 0.00010684509, 0.00010294399, 9.9067896e-05, 9.5221811e-05, 9.1425747e-05, 8.7654684e-05, 8.3923631e-05, 8.020259e-05, 7.6561555e-05, 7.2920535e-05, 6.9329522e-05, 6.5748514e-05, 6.2217521e-05, 5.8711528e-05, 5.5245557e-05, 5.1804585e-05, 4.8423633e-05, 4.5052686e-05, 4.1711744e-05, 3.842582e-05, 3.5149897e-05, 3.1913987e-05, 2.8713084e-05, 2.5557194e-05, 2.2416312e-05, 1.9335444e-05, 1.6259577e-05, 1.3218722e-05, 1.0232881e-05, 7.2670459e-06, 4.3312193e-06, 1.4203998e-06, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 8.6962686e-16, 2.5690827e-09, 7.5997955e-09, 1.2640277e-08, 1.7710065e-08, 2.2799385e-08, 2.7908246e-08, 3.3046412e-08, 3.8194347e-08, 4.3371582e-08, 4.8548824e-08, 5.3784671e-08, 5.9010755e-08, 6.4256369e-08, 6.9531296e-08, 7.4815986e-08, 8.0139749e-08, 8.5463512e-08, 9.0816577e-08, 9.617942e-08, 1.0157157e-07, 1.0697347e-07, 1.1243399e-07, 1.1786521e-07, 1.233355e-07, 1.288351e-07, 1.3434446e-07, 1.3988313e-07, 1.4543157e-07, 1.5099954e-07, 1.5658705e-07, 1.621941e-07, 1.6782069e-07, 1.7348633e-07, 1.7916177e-07, 1.8484695e-07, 1.9057123e-07, 1.9630527e-07, 2.0205883e-07, 2.0781241e-07, 2.1361483e-07, 2.1942699e-07, 2.2524897e-07, 2.3111974e-07, 2.3699053e-07, 2.4287112e-07, 2.4878096e-07, 2.5472991e-07, 2.6067886e-07, 2.6664733e-07, 2.7263536e-07, 2.7864289e-07, 2.8468952e-07, 2.9073612e-07, 2.9682184e-07, 3.0290752e-07, 3.0901276e-07, 3.1514733e-07, 3.2131118e-07, 3.2747502e-07, 3.3366817e-07, 3.3988081e-07, 3.4612282e-07, 3.523746e-07, 3.5864588e-07, 3.6492696e-07, 3.7123732e-07, 3.7756723e-07, 3.8392645e-07, 3.9030519e-07, 3.9670348e-07, 4.0312131e-07, 4.0956843e-07, 4.1601555e-07, 4.224822e-07, 4.2896843e-07, 4.3548394e-07, 4.4200917e-07, 4.4856378e-07, 4.5514767e-07, 4.6174131e-07, 4.6836428e-07, 4.7499699e-07, 4.8164929e-07, 4.8833084e-07, 4.9500261e-07, 5.0172326e-07, 5.084537e-07, 5.1522318e-07, 5.219926e-07, 5.2879147e-07, 5.3560001e-07, 5.424281e-07, 5.4929529e-07, 5.5616243e-07, 5.630589e-07, 5.6996515e-07, 5.7691045e-07, 5.8386553e-07, 5.9084994e-07, 5.9783434e-07, 6.0484797e-07, 6.1188126e-07, 6.18934e-07, 6.2601606e-07, 6.331079e-07, 6.402193e-07, 6.4735019e-07, 6.5452019e-07, 6.6169019e-07, 6.6887969e-07, 6.7608875e-07, 6.8332713e-07, 6.9058507e-07, 6.978625e-07, 7.0516921e-07, 7.1247598e-07, 7.1981202e-07, 7.2717739e-07, 7.3455249e-07, 7.4194713e-07, 7.4935156e-07, 7.5678531e-07, 7.6423862e-07, 7.7173092e-07, 7.7922329e-07, 7.8673514e-07, 7.9427633e-07, 8.0183702e-07, 8.0941732e-07, 8.1700733e-07, 8.246169e-07, 8.3224603e-07, 8.3990437e-07, 8.475921e-07, 8.5528956e-07, 8.6299679e-07, 8.707334e-07, 8.7847974e-07, 8.8627485e-07, 8.9407979e-07, 9.0187501e-07, 9.0970917e-07, 9.1757272e-07, 9.2545582e-07, 9.3335848e-07, 9.412708e-07, 9.4920279e-07, 9.5715427e-07, 9.651252e-07, 9.7313523e-07, 9.8115504e-07, 9.8918463e-07, 9.9723388e-07, 1.0053318e-06, 1.01342e-06, 1.0215473e-06, 1.0296649e-06, 1.0378312e-06, 1.0460074e-06, 1.0542128e-06, 1.0624279e-06, 1.0706627e-06, 1.078917e-06, 1.0872104e-06, 1.0955036e-06, 1.1038167e-06, 1.112149e-06, 1.120501e-06, 1.1288726e-06, 1.1372831e-06, 1.1457034e-06, 1.1541433e-06, 1.1625831e-06, 1.1710913e-06, 1.1795802e-06, 1.1880981e-06, 1.1966259e-06, 1.205183e-06, 1.2137597e-06, 1.2223753e-06, 1.2309813e-06, 1.2396165e-06, 1.2482714e-06, 1.2569457e-06, 1.2656591e-06, 1.2743823e-06, 1.2831053e-06, 1.2918773e-06, 1.3006493e-06, 1.3094605e-06, 1.3182715e-06, 1.3271119e-06, 1.335962e-06, 1.3448415e-06, 1.3537307e-06, 1.3626687e-06, 1.371597e-06, 1.3805546e-06, 1.3895416e-06, 1.398548e-06, 1.4075544e-06, 1.4166e-06, 1.4256456e-06, 1.4347301e-06, 1.4438244e-06, 1.4529676e-06, 1.4621011e-06, 1.471254e-06, 1.4804461e-06, 1.4896381e-06, 1.4988594e-06, 1.5080905e-06, 1.5173509e-06, 1.5266212e-06, 1.5359304e-06, 1.5452495e-06, 1.5545978e-06, 1.5639559e-06, 1.5733335e-06, 1.5827502e-06, 1.5921572e-06, 1.6015935e-06, 1.6110492e-06, 1.6205246e-06, 1.6300194e-06, 1.639563e-06, 1.649097e-06, 1.6586505e-06, 1.6682235e-06, 1.6778258e-06, 1.6874673e-06, 1.6970891e-06, 1.7067598e-06, 1.7164402e-06, 1.7261304e-06, 1.7358695e-06, 1.7456086e-06, 1.7553575e-06, 1.7651356e-06, 1.7749333e-06, 1.7847505e-06, 1.7946068e-06, 1.8044631e-06, 1.8143388e-06, 1.8242537e-06, 1.8341688e-06, 1.8441226e-06, 1.8540766e-06, 1.8640501e-06, 1.8740531e-06, 1.8840655e-06, 1.8941172e-06, 1.9041786e-06, 1.9142597e-06, 1.9243698e-06, 1.9344898e-06, 1.9446295e-06, 1.954779e-06, 1.9649574e-06, 1.9751556e-06, 1.9853831e-06, 1.9956301e-06, 2.0058967e-06, 2.0161731e-06, 2.0264786e-06, 2.0368136e-06, 2.0471487e-06, 2.057503e-06, 2.0678867e-06, 2.0782804e-06, 2.0887032e-06, 2.0991554e-06, 2.1096173e-06, 2.1200988e-06, 2.13059e-06, 2.1411204e-06, 2.1516798e-06, 2.1622297e-06, 2.1728088e-06, 2.1834076e-06, 2.1940452e-06, 2.2046831e-06, 2.2153406e-06, 2.2260174e-06, 2.2367233e-06, 2.2474394e-06, 2.2581746e-06, 2.2689592e-06, 2.2797335e-06, 2.2905472e-06, 2.3013704e-06, 2.3122232e-06, 2.3230759e-06, 2.3339578e-06, 2.3448595e-06, 2.3557707e-06, 2.3667112e-06, 2.3776909e-06, 2.3886705e-06, 2.3996697e-06, 2.410708e-06, 2.4217461e-06, 2.432804e-06, 2.4438814e-06, 2.4549784e-06, 2.466114e-06, 2.4772501e-06, 2.488425e-06, 2.4996198e-06, 2.5108143e-06, 2.5220284e-06, 2.5332815e-06, 2.5445543e-06, 2.5558268e-06, 2.5671191e-06, 2.5784504e-06, 2.5898012e-06, 2.6011717e-06, 2.6125422e-06, 2.6239516e-06, 2.6353609e-06, 2.6468094e-06, 2.6582775e-06, 2.6697653e-06, 2.6812722e-06, 2.6927992e-06, 2.7043452e-06, 2.715911e-06, 2.7274964e-06, 2.7391013e-06, 2.750706e-06, 2.7623498e-06, 2.774033e-06, 2.7857159e-06, 2.7974183e-06, 2.8091404e-06, 2.8209017e-06, 2.8326626e-06, 2.8444433e-06, 2.8562436e-06, 2.8680633e-06, 2.8799025e-06, 2.8917614e-06, 2.9036787e-06, 2.9155767e-06, 2.9274941e-06, 2.9394309e-06, 2.9514069e-06, 2.9634027e-06, 2.975398e-06, 2.9874327e-06, 2.9994674e-06, 3.0115411e-06, 3.0236345e-06, 3.0357276e-06, 3.04786e-06, 3.0599924e-06, 3.0721637e-06, 3.0843546e-06, 3.096565e-06, 3.1087757e-06, 3.121025e-06, 3.1332943e-06, 3.1455827e-06, 3.1578909e-06, 3.1702186e-06, 3.1825659e-06, 3.194913e-06, 3.2072994e-06, 3.2197247e-06, 3.2321502e-06, 3.2445951e-06, 3.257079e-06, 3.2695434e-06, 3.2820469e-06, 3.29457e-06, 3.3071126e-06, 3.3196748e-06, 3.3322758e-06, 3.3448771e-06, 3.3575175e-06, 3.3701576e-06, 3.3828371e-06, 3.3955164e-06, 3.4082348e-06, 3.4209534e-06, 3.4336911e-06, 3.4464488e-06, 3.4592647e-06, 3.4720615e-06, 3.4848774e-06, 3.4977327e-06, 3.5105877e-06, 3.5235016e-06, 3.5363958e-06, 3.549329e-06, 3.5622625e-06, 3.575235e-06, 3.5882267e-06, 3.6012382e-06, 3.6142696e-06, 3.6273004e-06, 3.6403703e-06, 3.65346e-06, 3.6665695e-06, 3.679698e-06, 3.6928463e-06, 3.7060142e-06, 3.7192015e-06, 3.7324276e-06, 3.7456541e-06, 3.7589e-06, 3.7721461e-06, 3.7854309e-06, 3.7987356e-06, 3.8120791e-06, 3.8254225e-06, 3.8387857e-06, 3.852188e-06, 3.8656094e-06, 3.8790313e-06, 3.8924727e-06, 3.9059337e-06, 3.9194333e-06, 3.9329334e-06, 3.9464726e-06, 3.9600113e-06, 3.9735892e-06, 3.987187e-06, 4.0007844e-06, 4.0144214e-06, 4.0280579e-06, 4.0417335e-06, 4.0554091e-06, 4.0691434e-06, 4.0828586e-06, 4.0966124e-06, 4.1103658e-06, 4.1241592e-06, 4.1379908e-06, 4.1518228e-06, 4.1656554e-06, 4.1795261e-06, 4.1934168e-06, 4.207327e-06, 4.2212569e-06, 4.2352062e-06, 4.2491747e-06, 4.2631632e-06, 4.2771512e-06, 4.2912179e-06, 4.3052451e-06, 4.3193313e-06, 4.3334176e-06, 4.347542e-06, 4.3616674e-06, 4.3758118e-06, 4.3899763e-06, 4.4041594e-06, 4.418363e-06, 4.4326052e-06, 4.4468475e-06, 4.4611288e-06, 4.4754106e-06, 4.4897306e-06, 4.504051e-06, 4.5184106e-06, 4.5327702e-06, 4.5471688e-06, 4.5615675e-06, 4.5760248e-06, 4.5904626e-06, 4.604939e-06, 4.6194154e-06, 4.633951e-06, 4.648467e-06, 4.6630216e-06, 4.6775763e-06, 4.6921705e-06, 4.7067838e-06, 4.7214166e-06, 4.7360695e-06, 4.7507419e-06, 4.7654335e-06, 4.7801445e-06, 4.7948947e-06, 4.8096254e-06, 4.8243951e-06, 4.8391844e-06, 4.8539937e-06, 4.8688416e-06, 4.8836896e-06, 4.8985567e-06, 4.9134437e-06, 4.9283503e-06, 4.9432765e-06, 4.9582413e-06, 4.9732066e-06, 4.988211e-06, 5.0032149e-06, 5.0182584e-06, 5.033321e-06, 5.0483841e-06, 5.0634662e-06, 5.0785684e-06, 5.0937097e-06, 5.10887e-06, 5.1240304e-06, 5.1392299e-06, 5.1544489e-06, 5.1696875e-06, 5.1849456e-06, 5.2002042e-06, 5.2154819e-06, 5.2307987e-06, 5.2461351e-06, 5.261491e-06, 5.276866e-06, 5.2922614e-06, 5.3076565e-06, 5.3231097e-06, 5.3385634e-06, 5.354017e-06, 5.3695098e-06, 5.3850217e-06, 5.4005732e-06, 5.4161242e-06, 5.4316952e-06, 5.4472857e-06, 5.4628954e-06, 5.4785246e-06, 5.4941934e-06, 5.5098617e-06, 5.5255496e-06, 5.541257e-06, 5.556984e-06, 5.5727505e-06, 5.5885362e-06, 5.6043218e-06, 5.620127e-06, 5.6359518e-06, 5.6518156e-06, 5.667699e-06, 5.683602e-06, 5.699505e-06, 5.7154471e-06, 5.7314087e-06, 5.7473699e-06, 5.7633511e-06, 5.7793709e-06, 5.7953912e-06, 5.8114506e-06, 5.8275491e-06, 5.8436276e-06, 5.8597452e-06, 5.8758828e-06, 5.8920396e-06, 5.9082158e-06, 5.9244121e-06, 5.9406275e-06, 5.9568429e-06, 5.9730974e-06, 5.989391e-06, 6.0056846e-06, 6.0219782e-06, 6.0383113e-06, 6.0546831e-06, 6.0710549e-06, 6.0874459e-06, 6.1038572e-06, 6.1203068e-06, 6.1367568e-06, 6.1532264e-06, 6.1697351e-06, 6.1862438e-06, 6.2027716e-06, 6.2193194e-06, 6.2359059e-06, 6.2525119e-06, 6.2691183e-06, 6.2857443e-06, 6.302409e-06, 6.3190932e-06, 6.3357775e-06, 6.3525013e-06, 6.3692246e-06, 6.385987e-06, 6.4027499e-06, 6.419571e-06, 6.4363726e-06, 6.4532132e-06, 6.4700735e-06, 6.4869528e-06, 6.503833e-06, 6.5207519e-06, 6.5376903e-06, 6.5546283e-06, 6.5716058e-06, 6.5886225e-06, 6.6056391e-06, 6.6226748e-06, 6.6397306e-06, 6.6568255e-06, 6.6738999e-06, 6.6910147e-06, 6.7081482e-06, 6.7253013e-06, 6.7424739e-06, 6.7596861e-06, 6.7768979e-06, 6.7941296e-06, 6.8113809e-06, 6.8286513e-06, 6.8459603e-06, 6.8632899e-06, 6.8806185e-06, 6.8979675e-06, 6.9153552e-06, 6.9327625e-06, 6.9501698e-06, 6.9675966e-06, 6.9850621e-06, 7.0025276e-06, 7.0200135e-06, 7.0375577e-06, 7.0550823e-06, 7.0726451e-06, 7.0902288e-06, 7.1078312e-06, 7.1254531e-06, 7.143075e-06, 7.1607169e-06, 7.1784175e-06, 7.1960976e-06, 7.2138378e-06, 7.231577e-06, 7.2493162e-06, 7.2671141e-06, 7.2849125e-06, 7.3027295e-06, 7.3205474e-06, 7.338404e-06, 7.3562796e-06, 7.3741953e-06, 7.3921105e-06, 7.4100449e-06, 7.4279997e-06, 7.4459731e-06, 7.4639861e-06, 7.4819991e-06, 7.5000512e-06, 7.5181028e-06, 7.5361745e-06, 7.5542844e-06, 7.5723956e-06, 7.5905255e-06, 7.6086753e-06, 7.6268639e-06, 7.6450533e-06, 7.6632996e-06, 7.6815277e-06, 7.699794e-06, 7.7180612e-06, 7.7363875e-06, 7.7546929e-06, 7.7730183e-06, 7.7913828e-06, 7.8097473e-06, 7.828151e-06, 7.8465546e-06, 7.8650173e-06, 7.8834792e-06, 7.901941e-06, 7.9204619e-06, 7.9389829e-06, 7.9575229e-06, 7.9760639e-06, 7.9946431e-06, 8.0132422e-06, 8.0318614e-06, 8.0505179e-06, 8.0691752e-06, 8.0878526e-06, 8.1065691e-06, 8.1252856e-06, 8.1440021e-06, 8.1627759e-06, 8.1815515e-06, 8.2003462e-06, 8.2191791e-06, 8.238012e-06, 8.2568849e-06, 8.2757579e-06, 8.294649e-06, 8.313581e-06, 8.3325112e-06, 8.3514815e-06, 8.3704526e-06, 8.389442e-06, 8.4084904e-06, 8.4275189e-06, 8.4465673e-06, 8.4656549e-06, 8.4847416e-06, 8.5038682e-06, 8.523034e-06, 8.5421798e-06, 8.5613647e-06, 8.5805505e-06, 8.5997945e-06, 8.6190375e-06, 8.6382815e-06, 8.6575637e-06, 8.6768659e-06, 8.6961682e-06, 8.7155095e-06, 8.7348908e-06, 8.7542712e-06, 8.7736707e-06, 8.7930903e-06, 8.8125489e-06, 8.8320076e-06, 8.8514862e-06, 8.8709839e-06, 8.8905008e-06, 8.9100567e-06, 8.9296136e-06, 8.9491896e-06, 8.9687846e-06, 8.9884188e-06, 9.008053e-06, 9.0277072e-06, 9.0474005e-06, 9.0670937e-06, 9.0868061e-06, 9.1065576e-06, 9.1263291e-06, 9.1460997e-06, 9.1659103e-06, 9.185721e-06, 9.2055898e-06, 9.2254386e-06, 9.2453274e-06, 9.2652153e-06, 9.2851233e-06, 9.3050903e-06, 9.3250565e-06, 9.3450235e-06, 9.3650287e-06, 9.3850349e-06   }, 
   { 0.01031357, 0.010302517, 0.010291534, 0.010280597, 0.010269661, 0.010258771, 0.010247882, 0.010237087, 0.010226364, 0.010215594, 0.010204846, 0.010194169, 0.01018354, 0.010172912, 0.010162329, 0.010151794, 0.010141283, 0.010130843, 0.010120379, 0.010109963, 0.01009957, 0.010089272, 0.010078949, 0.010068675, 0.010058447, 0.010048242, 0.010038109, 0.010027952, 0.010017843, 0.010007757, 0.0099977665, 0.0099877985, 0.0099778064, 0.0099678859, 0.0099579655, 0.00994814, 0.0099383127, 0.0099285105, 0.0099187791, 0.0099090002, 0.0098993871, 0.0098897256, 0.0098801125, 0.0098704994, 0.0098609803, 0.0098514613, 0.0098419655, 0.0098325415, 0.0098230699, 0.0098137632, 0.009804409, 0.0097951023, 0.0097857965, 0.0097765848, 0.0097673722, 0.0097581837, 0.009749067, 0.0097399484, 0.0097309258, 0.0097218798, 0.0097128563, 0.0097038811, 0.0096949758, 0.009686118, 0.0096772136, 0.0096684033, 0.009659593, 0.0096508767, 0.0096421372, 0.009633421, 0.0096247522, 0.0096161542, 0.0096076038, 0.0095990533, 0.0095905028, 0.0095819989, 0.0095735909, 0.0095651578, 0.0095567489, 0.0095484108, 0.0095401676, 0.009531877, 0.0095236097, 0.0095153898, 0.0095071932, 0.0094990917, 0.0094909659, 0.0094829118, 0.0094748568, 0.0094668968, 0.0094589135, 0.0094509535, 0.0094430642, 0.009435175, 0.0094273565, 0.0094195614, 0.0094118379, 0.009404067, 0.0093964376, 0.0093887364, 0.009381108, 0.0093735019, 0.0093659433, 0.0093584796, 0.0093509443, 0.009343504, 0.0093360636, 0.0093287416, 0.009321372, 0.0093140258, 0.0093067503, 0.0092994757, 0.0092923185, 0.0092851147, 0.0092779808, 0.0092708478, 0.0092637613, 0.0092567457, 0.009249731, 0.009242787, 0.0092357947, 0.009228969, 0.0092220716, 0.0092152217, 0.0092084184, 0.009201616, 0.0091949319, 0.0091882236, 0.0091815628, 0.0091749486, 0.0091683818, 0.0091617927, 0.0091552725, 0.0091487542, 0.0091422815, 0.0091359038, 0.0091295261, 0.0091231493, 0.0091168191, 0.0091105597, 0.0091043003, 0.0090980642, 0.0090918764, 0.0090857111, 0.009079664, 0.0090735694, 0.0090675, 0.0090614762, 0.0090555474, 0.0090495711, 0.0090436423, 0.0090377852, 0.0090319514, 0.0090261875, 0.0090204002, 0.0090146372, 0.0090089208, 0.0090032993, 0.0089976536, 0.0089920796, 0.0089864573, 0.0089809541, 0.0089754742, 0.0089700175, 0.0089645619, 0.0089591527, 0.0089538377, 0.0089484993, 0.0089432327, 0.0089379186, 0.0089327209, 0.0089275725, 0.008922399, 0.008917274, 0.0089121722, 0.0089071402, 0.0089021325, 0.0088971723, 0.0088921888, 0.0088872761, 0.0088824332, 0.008877567, 0.0088727493, 0.0088679539, 0.0088632545, 0.0088585289, 0.0088539002, 0.0088492231, 0.0088446168, 0.0088400822, 0.0088355234, 0.0088310353, 0.0088265482, 0.008822131, 0.0088177845, 0.0088133914, 0.008809045, 0.008804746, 0.0088005178, 0.0087962663, 0.0087920856, 0.0087879281, 0.0087837949, 0.0087797325, 0.0087756692, 0.00877163, 0.0087676616, 0.0087637408, 0.0087598199, 0.0087559223, 0.0087520489, 0.0087482464, 0.0087444903, 0.0087407343, 0.0087370025, 0.0087333415, 0.008729727, 0.0087261135, 0.0087225474, 0.0087189805, 0.0087154843, 0.0087120356, 0.0087085878, 0.0087051857, 0.0087018088, 0.0086985249, 0.0086951945, 0.0086919349, 0.0086886752, 0.0086854864, 0.0086823683, 0.008679227, 0.0086761322, 0.0086730616, 0.008670086, 0.008667062, 0.0086641097, 0.0086611807, 0.0086582759, 0.0086554652, 0.0086526303, 0.0086498428, 0.0086470796, 0.0086443638, 0.0086417412, 0.0086390721, 0.0086364504, 0.008633852, 0.0086313486, 0.008628821, 0.0086263409, 0.0086239073, 0.0086214989, 0.0086191604, 0.0086167986, 0.0086145066, 0.0086122155, 0.0086100195, 0.0086078225, 0.0086056497, 0.0086035002, 0.0086013982, 0.0085993661, 0.0085973348, 0.0085953278, 0.0085933432, 0.0085914778, 0.0085895872, 0.0085876985, 0.0085858796, 0.008584084, 0.0085823601, 0.0085806353, 0.0085789347, 0.0085772816, 0.0085756993, 0.008574116, 0.008572557, 0.0085710455, 0.0085695572, 0.0085681407, 0.0085667232, 0.008565329, 0.0085639833, 0.0085627073, 0.0085614324, 0.0085601807, 0.0085589755, 0.0085577946, 0.0085567078, 0.0085555976, 0.0085545117, 0.0085534723, 0.0085525038, 0.0085515352, 0.0085506141, 0.0085496921, 0.0085488427, 0.008548039, 0.0085472362, 0.0085464809, 0.008545748, 0.0085451109, 0.0085444255, 0.0085438108, 0.0085431971, 0.0085426541, 0.0085421819, 0.0085416855, 0.0085412124, 0.0085407877, 0.0085404571, 0.008540079, 0.0085397726, 0.0085394885, 0.0085392529, 0.0085390871, 0.0085388748, 0.0085387565, 0.008538615, 0.0085385442, 0.0085385442, 0.0085385442, 0.0085385675, 0.008538615, 0.0085387565, 0.0085388748, 0.0085390396, 0.0085392529, 0.0085394653, 0.0085397959, 0.008540079, 0.0085404096, 0.0085407645, 0.0085412366, 0.0085416613, 0.0085421344, 0.0085426308, 0.0085431738, 0.0085438108, 0.0085444013, 0.0085450392, 0.0085457014, 0.0085464809, 0.0085472362, 0.0085479915, 0.0085488185, 0.0085496455, 0.0085505899, 0.0085514877, 0.0085524563, 0.0085534481, 0.0085545117, 0.0085555743, 0.008556637, 0.0085577704, 0.008558928, 0.0085601564, 0.0085614081, 0.0085626366, 0.008563959, 0.0085653057, 0.0085666757, 0.008568069, 0.0085695097, 0.0085709747, 0.0085725104, 0.0085740685, 0.0085756276, 0.0085772341, 0.0085789114, 0.0085805887, 0.0085822893, 0.0085840365, 0.0085858088, 0.00858765, 0.0085895173, 0.0085913828, 0.0085932957, 0.0085953036, 0.0085972641, 0.0085992953, 0.0086013274, 0.0086034294, 0.0086055789, 0.0086077284, 0.0086099254, 0.0086121447, 0.00861446, 0.0086167278, 0.0086190654, 0.0086214039, 0.0086238133, 0.0086262934, 0.0086287502, 0.0086312536, 0.008633757, 0.008636333, 0.008638978, 0.0086416239, 0.0086442921, 0.0086469855, 0.008649772, 0.0086525362, 0.0086553469, 0.0086581819, 0.0086610625, 0.008664039, 0.008666968, 0.0086699445, 0.0086729443, 0.0086760381, 0.0086791087, 0.0086822268, 0.0086853681, 0.0086885579, 0.0086918408, 0.0086950762, 0.0086983591, 0.0087016905, 0.0087050917, 0.0087084929, 0.008711894, 0.008715366, 0.008718838, 0.0087224292, 0.0087259719, 0.0087295854, 0.0087332232, 0.0087369084, 0.008740616, 0.0087443488, 0.0087481281, 0.0087519074, 0.008755804, 0.0087596541, 0.0087635759, 0.0087675201, 0.008771535, 0.0087755509, 0.0087795667, 0.0087836524, 0.0087877633, 0.008791944, 0.008796148, 0.0088003529, 0.0088046035, 0.0088089267, 0.0088132489, 0.0088175954, 0.0088219652, 0.0088264057, 0.0088308938, 0.0088353818, 0.0088398932, 0.0088444753, 0.0088490816, 0.0088537354, 0.0088583883, 0.0088630645, 0.0088678123, 0.0088726077, 0.0088774022, 0.0088822441, 0.0088871103, 0.0088920705, 0.0088969842, 0.0089019677, 0.0089069512, 0.0089120064, 0.0089171082, 0.0089222342, 0.0089273835, 0.0089325318, 0.0089377528, 0.0089430436, 0.0089483112, 0.0089536253, 0.0089589637, 0.0089644203, 0.0089698052, 0.0089752618, 0.0089807417, 0.0089862691, 0.0089918664, 0.0089974646, 0.0090030627, 0.0090087317, 0.0090144714, 0.0090201879, 0.0090259509, 0.0090317382, 0.009037572, 0.0090434775, 0.009049383, 0.0090553109, 0.0090612639, 0.009067311, 0.0090733338, 0.0090794042, 0.009085522, 0.0090916632, 0.009097876, 0.0091040637, 0.0091103232, 0.0091165826, 0.009122937, 0.0091292905, 0.0091356682, 0.0091420691, 0.0091485176, 0.0091550602, 0.0091615561, 0.0091681229, 0.0091746887, 0.0091813495, 0.0091880104, 0.0091946954, 0.0092014037, 0.0092081586, 0.0092150094, 0.0092218351, 0.0092286849, 0.0092355823, 0.0092425505, 0.0092495186, 0.0092565101, 0.0092635257, 0.0092706112, 0.0092777452, 0.0092848781, 0.0092920354, 0.0092992391, 0.0093065146, 0.0093137892, 0.009321088, 0.0093284342, 0.0093358038, 0.0093432683, 0.0093507078, 0.0093581723, 0.0093656834, 0.0093732178, 0.0093808481, 0.0093884775, 0.009396106, 0.0094038062, 0.0094115548, 0.0094193248, 0.0094270967, 0.0094349151, 0.0094427802, 0.0094506936, 0.0094586294, 0.0094665894, 0.0094745737, 0.0094826287, 0.009490706, 0.0094988085, 0.0095069334, 0.0095151067, 0.0095233256, 0.0095315697, 0.0095398137, 0.0095481277, 0.0095565123, 0.0095648747, 0.0095732836, 0.0095817158, 0.0095901955, 0.0095987469, 0.0096072732, 0.0096158711, 0.0096244691, 0.0096331611, 0.0096418299, 0.0096505461, 0.0096592847, 0.0096680727, 0.0096769528, 0.0096857874, 0.0096946685, 0.0097035738, 0.0097125731, 0.0097215725, 0.0097305952, 0.009739642, 0.0097487364, 0.0097579248, 0.0097670658, 0.0097762542, 0.0097854892, 0.0097947959, 0.0098041017, 0.0098134084, 0.0098227859, 0.0098321866, 0.0098416591, 0.0098511307, 0.0098606255, 0.0098701688, 0.0098797344, 0.009889395, 0.0098990323, 0.0099087171, 0.009918401, 0.0099282041, 0.0099379588, 0.0099477852, 0.0099576348, 0.0099675087, 0.0099774757, 0.0099874204, 0.0099974116, 0.010007426, 0.010017512, 0.010027622, 0.010037708, 0.010047888, 0.010058069, 0.010068344, 0.010078595, 0.010088894, 0.010099215, 0.010109608, 0.010120025, 0.010130442, 0.010140905, 0.010151416, 0.010161974, 0.010172557, 0.010183139, 0.010193791, 0.010204492, 0.010215215, 0.01022594, 0.01023671, 0.010247528, 0.010258418, 0.010269282, 0.010280196, 0.010291131, 0.010302163, 0.01031317, 0.010324224, 0.010335301, 0.010346427, 0.010357623, 0.010368796, 0.010380039, 0.010391282, 0.01040262, 0.010413934, 0.010425296, 0.01043668, 0.010448113, 0.010459592, 0.010471095, 0.010482646, 0.010494197, 0.010505841, 0.010517462, 0.010529131, 0.010540823, 0.010552563, 0.010564396, 0.010576182, 0.010588016, 0.010599874, 0.010611849, 0.010623801, 0.010635753, 0.010647776, 0.010659799, 0.01067194, 0.010684033, 0.010696198, 0.010708362, 0.010720598, 0.010732881, 0.010745163, 0.010757493, 0.010769847, 0.010782271, 0.010794695, 0.010807144, 0.010819638, 0.010832157, 0.01084477, 0.01085736, 0.010869998, 0.010882634, 0.010895389, 0.01090812, 0.010920876, 0.010933678, 0.010946503, 0.010959423, 0.010972344, 0.010985265, 0.010998257, 0.011011271, 0.011024333, 0.011037394, 0.011050504, 0.011063637, 0.011076865, 0.011090092, 0.011103319, 0.011116618, 0.011129963, 0.011143309, 0.011156701, 0.011170118, 0.011183582, 0.011197093, 0.011210627, 0.011224162, 0.011237767, 0.011251419, 0.011265095, 0.011278796, 0.011292495, 0.011306266, 0.011320108, 0.011333949, 0.011347791, 0.011361703, 0.011375663, 0.011389646, 0.011403653, 0.011417683, 0.011431738, 0.011445886, 0.011460035, 0.011474207, 0.011488403, 0.011502718, 0.011516959, 0.011531298, 0.011545636, 0.01156002, 0.011574476, 0.011588909, 0.011603411, 0.011617914, 0.01163251, 0.011647086, 0.011661706, 0.011676375, 0.011689543, 0.011701046, 0.011712501, 0.011724087, 0.01173565, 0.01174733, 0.011758997, 0.011770772, 0.011782526, 0.011794393, 0.011806298, 0.011818203, 0.011830225, 0.011842201, 0.011854296, 0.011866413, 0.011878612, 0.01189086, 0.011903084, 0.011915438, 0.011927754, 0.011940179, 0.011952627, 0.01196511, 0.011977665, 0.011990301, 0.012002962, 0.012015599, 0.01202839, 0.012041144, 0.012054006, 0.012066878, 0.012079787, 0.01209279, 0.012105817, 0.012118902, 0.012132, 0.012145217, 0.012158385, 0.012171671, 0.012184945, 0.012198327, 0.012211732, 0.012225207, 0.012238706, 0.01225224, 0.012265869, 0.012279486, 0.012293186, 0.012306887, 0.012320691, 0.012334569, 0.012348435, 0.012362334, 0.012376295, 0.012390361, 0.012404415, 0.012418552, 0.012432676, 0.01244692, 0.01246121, 0.012475489, 0.012489849, 0.012504223, 0.012518713, 0.012533193, 0.012547743, 0.012562305, 0.012576962, 0.012591701, 0.012606416, 0.01262119, 0.012635978, 0.012650882, 0.012665822, 0.012680798, 0.012695784, 0.01271089, 0.012725983, 0.012741159, 0.012756381, 0.012771606, 0.012786925, 0.012802278, 0.012817688, 0.012833103, 0.012848632, 0.012864174, 0.012879753, 0.012895414, 0.012911073, 0.012926816, 0.012942617, 0.012958444, 0.012974327, 0.012990225, 0.013006251, 0.013022195, 0.013038293, 0.013054376, 0.013070545, 0.01308676, 0.013103035, 0.013119309, 0.013135655, 0.013152108, 0.013168523, 0.013185022, 0.013201544, 0.01321815, 0.013234754, 0.013251467, 0.013268178, 0.013284948, 0.013301835, 0.013318666, 0.013335603, 0.013352539, 0.01336958, 0.013386599, 0.013403757, 0.013420871, 0.01343808, 0.013455404, 0.013472648, 0.013489997, 0.013507383, 0.013524837, 0.013542364, 0.013559878, 0.013577439, 0.013595096, 0.013612777, 0.01363048, 0.0136483, 0.013666064, 0.013683967, 0.013701883, 0.013719836, 0.013737882, 0.013755916, 0.013774045, 0.013792161, 0.013810395, 0.013828619, 0.013846913, 0.013865266, 0.013883655, 0.013902116, 0.013920597, 0.013939115, 0.013957693, 0.013976365, 0.013995001, 0.014013733, 0.014032498, 0.014051324, 0.014070231, 0.014089094, 0.014108085, 0.014127064, 0.014146161, 0.014165234, 0.01418439, 0.014203582, 0.014222855, 0.014242166, 0.014261463, 0.014280891, 0.014300284, 0.014319818, 0.014339316, 0.014358886, 0.014378562, 0.014398215, 0.014417937, 0.014437683, 0.014457513, 0.014477366, 0.014497302, 0.014517237, 0.014537244, 0.014557333, 0.014577434, 0.014597571, 0.014617731, 0.014637996, 0.014658286, 0.01467866, 0.014699007, 0.014719452, 0.014739978, 0.014760468, 0.014781053, 0.014801638, 0.014822342, 0.014843056, 0.014863831, 0.014884593, 0.014905486, 0.014926425, 0.014947377, 0.014968376, 0.014989397, 0.015010525, 0.015031666, 0.015052865, 0.015074065, 0.015095394, 0.015116735, 0.015138112, 0.015159559, 0.015180983, 0.015202548, 0.015224125, 0.015245738, 0.015267421, 0.015289128, 0.015310908, 0.015332709, 0.015354558, 0.01537644, 0.01539842, 0.015420411, 0.015442473, 0.015464582, 0.015486701, 0.015508916, 0.01553112, 0.01555343, 0.015575751, 0.015598131, 0.015620558, 0.015643056, 0.015665591, 0.015688112, 0.015710765, 0.015733404, 0.01575614, 0.015778873, 0.015801704, 0.015824545, 0.01584748, 0.015870428, 0.015893409, 0.015916463, 0.015939539, 0.015962701, 0.015985873, 0.016009115, 0.016032416, 0.01605574, 0.016079077, 0.016102521, 0.016126024, 0.016149525, 0.016173098, 0.016196696, 0.016220376, 0.016244113, 0.016267851, 0.016291674, 0.016315496, 0.016339399, 0.016363349, 0.016387347, 0.016411358, 0.016435474, 0.016459638, 0.01648378, 0.016508048, 0.016532307, 0.016556624, 0.016581012, 0.016605459, 0.016629882, 0.016654436, 0.016678967, 0.016703613, 0.016728297, 0.016752992, 0.016777724, 0.016802523, 0.016827408, 0.016852245, 0.016877212, 0.016902203, 0.016927252, 0.016952362, 0.016977444, 0.017002672, 0.017027875, 0.017053183, 0.017078517, 0.017103838, 0.017129289, 0.017154751, 0.017180298, 0.017205806, 0.017231436, 0.017257087, 0.017282808, 0.017308556, 0.017334338, 0.017360214, 0.017386101, 0.017412072, 0.017437996, 0.017464085, 0.017490139, 0.017516296, 0.017542446, 0.017568676, 0.017594978, 0.01762129, 0.017647674, 0.017674046, 0.017700536, 0.01772704, 0.017753635, 0.017780198, 0.017806865, 0.017833577, 0.017860342, 0.017887127, 0.017913947, 0.017940873, 0.017967837, 0.017994789, 0.018021798, 0.018048903, 0.018076031, 0.018103205, 0.01813044, 0.018157685, 0.018185027, 0.018212393, 0.018239802, 0.018267274, 0.018294768, 0.018322334, 0.018349944, 0.018377593, 0.018405253, 0.018433029, 0.018460831, 0.018488655, 0.018516563, 0.018544471, 0.018572485, 0.018600533, 0.018628594, 0.018656692, 0.018684881, 0.018713074, 0.018741369, 0.018769704, 0.018798059, 0.018826475, 0.018854912, 0.018883435, 0.01891198, 0.018940585, 0.018969236, 0.018997947, 0.019026693, 0.019055463, 0.01908434, 0.01911319, 0.019142127, 0.019171083, 0.019200137, 0.019229215, 0.01925835, 0.019287523, 0.019316716, 0.019346006, 0.019375294, 0.01940468, 0.019434074, 0.01946353, 0.019493043, 0.019522615, 0.019552223, 0.019581832, 0.019611547, 0.019641273, 0.019671069, 0.01970089, 0.019730793, 0.019760698, 0.019790707, 0.019820753, 0.019850763, 0.019880913, 0.019911077, 0.0199413, 0.019971522, 0.020001862, 0.020032216, 0.02006265, 0.020093108, 0.020123579, 0.020154143, 0.020184742, 0.020215379, 0.020246049, 0.020276792, 0.02030758, 0.020338429, 0.020369314, 0.020400221, 0.020431198, 0.020462235, 0.020493308, 0.02052444, 0.020555573, 0.020586809, 0.020618048, 0.020649381, 0.020680713, 0.020712093, 0.020743579, 0.020775098, 0.020806633, 0.020838177, 0.020869853, 0.02090154, 0.020933298, 0.020965019, 0.020996872, 0.021028748, 0.021060718, 0.0210927, 0.021124672, 0.021156747, 0.021188859, 0.021221042, 0.021253236, 0.021285489, 0.021317778, 0.021350175, 0.021382559, 0.02141499, 0.021447502, 0.021480052, 0.021512637, 0.021545233, 0.021577934, 0.021610707, 0.021643467, 0.021676278, 0.021709146, 0.021742096, 0.021775071, 0.021808105, 0.021841137, 0.021874264, 0.021907439, 0.021940637, 0.021973884, 0.022007165, 0.02204054, 0.022073915, 0.022107374, 0.022140833, 0.02217442, 0.022208009, 0.022241633, 0.022275327, 0.02230902, 0.022342812, 0.022376636, 0.022410531, 0.022444403, 0.022478404, 0.022512393, 0.022546466, 0.022580586, 0.022614729, 0.022648944, 0.022683205, 0.022717511, 0.022751834, 0.022786237, 0.022820674, 0.022855159, 0.022889743, 0.022924285, 0.022958925, 0.022993578, 0.023028348, 0.023063116, 0.023097919, 0.02313282, 0.023167685, 0.023202688, 0.023237696, 0.023272745, 0.023307847, 0.023343839, 0.023380756, 0.023417769, 0.023454852, 0.023491938, 0.02352914, 0.023566363, 0.02360373, 0.023641124, 0.023678586, 0.023716094, 0.023753677, 0.02379135, 0.023829117, 0.023866914, 0.023904728, 0.023942711, 0.023980619, 0.024018718, 0.024056867, 0.024095062, 0.024133349, 0.024171639, 0.024210021, 0.024248526, 0.024287047, 0.024325665, 0.024364334, 0.024403002, 0.024441857, 0.024480758, 0.024519661, 0.024558682, 0.024597704, 0.024636842, 0.024676029, 0.024715332, 0.02475471, 0.024794059, 0.024833528, 0.02487302, 0.024912704, 0.024952319, 0.024992092, 0.02503187, 0.025071738, 0.025111709, 0.025151694, 0.025191782, 0.025231911, 0.025272137, 0.02531234, 0.025352754, 0.025393119, 0.025433607, 0.025474185, 0.025514742, 0.025555439, 0.025596162, 0.025637003, 0.025677841, 0.025718775, 0.025759781, 0.025800878, 0.025842074, 0.025883244, 0.025924532, 0.025965847, 0.026007274, 0.026048705, 0.026090302, 0.026131921, 0.026173584, 0.026215345, 0.026257131, 0.026299058, 0.02634096, 0.026383001, 0.026425024, 0.026467187, 0.026509419, 0.026551725, 0.026594076, 0.026636453, 0.026678968, 0.026721509, 0.026764143, 0.026806803, 0.026849555, 0.026892381, 0.026935223, 0.026978191, 0.027021227, 0.027064335, 0.027107444, 0.027150668, 0.027193919, 0.027237307, 0.02728077, 0.027324229, 0.027367786, 0.027411366, 0.027455088, 0.027498856, 0.027542673, 0.027586536, 0.027630517, 0.02767452, 0.027718596, 0.027762815, 0.027806984, 0.027851298, 0.027895631, 0.027940014, 0.027984563, 0.028029133, 0.028073778, 0.028118419, 0.02816318, 0.028208012, 0.028252937, 0.028297862, 0.028342908, 0.028387953, 0.028433163, 0.028478371, 0.028523674, 0.028569048, 0.028614473, 0.02865994, 0.028705483, 0.02875114, 0.028796844, 0.0288426, 0.028888421, 0.028934337, 0.028980305, 0.029026363, 0.029072449, 0.029118581, 0.02916483, 0.029211124, 0.029257465, 0.029303906, 0.029350437, 0.029396992, 0.02944362, 0.029490341, 0.029537085, 0.029583948, 0.029630858, 0.029677793, 0.029724797, 0.02977192, 0.029819138, 0.029866355, 0.029913642, 0.029960977, 0.030008432, 0.030055929, 0.030103529, 0.030151146, 0.030198857, 0.030246619, 0.030294474, 0.0303424, 0.030390348, 0.030438391, 0.030486483, 0.03053467, 0.030582903, 0.030631229, 0.030679606, 0.030728023, 0.030776542, 0.030825106, 0.030873742, 0.030922469, 0.030971244, 0.03102009, 0.031068964, 0.031117976, 0.031167036, 0.031216143, 0.031265296, 0.031314522, 0.031363863, 0.031413183, 0.031462692, 0.031512201, 0.031561777, 0.031611383, 0.031661104, 0.031710871, 0.031760756, 0.031810645, 0.03186065, 0.03191065, 0.031960778, 0.03201104, 0.032061256, 0.032111544, 0.032161929, 0.032212406, 0.03226288, 0.0323135, 0.032364119, 0.032414854, 0.032465685, 0.032516494, 0.032567441, 0.032618415, 0.032669436, 0.032720573, 0.032771755, 0.032823015, 0.032874342, 0.03292574, 0.032977186, 0.033028677, 0.033080243, 0.033131924, 0.033183653, 0.033235427, 0.03328732, 0.033339214, 0.033391207, 0.033443309, 0.033495437, 0.033547569, 0.033599842, 0.033652186, 0.033704553, 0.033757038, 0.033809569, 0.033862147, 0.033914797, 0.033967517, 0.034020286, 0.034073148, 0.034126107, 0.03417911, 0.034232136, 0.034285285, 0.0343385, 0.034391742, 0.034445077, 0.034498505, 0.034551911, 0.034605432, 0.03465905, 0.034712743, 0.034766454, 0.034820214, 0.034874093, 0.03492802, 0.034982085, 0.035036106, 0.035090242, 0.035144452, 0.035198662, 0.035253059, 0.035307433, 0.035361897, 0.035416417, 0.035471004, 0.035525683, 0.03558046, 0.035635259, 0.035690106, 0.035745025, 0.03580004, 0.035855118, 0.035910271, 0.03596545, 0.036020722, 0.036076039, 0.03613143, 0.036186941, 0.036242492, 0.036298096, 0.036353722, 0.036409467, 0.036465283, 0.03652117, 0.036577124, 0.036633153, 0.036689159, 0.036745325, 0.036801495, 0.03685781, 0.036914162, 0.036970571, 0.03702702, 0.037083525, 0.037140213, 0.037196878, 0.037253615, 0.037310395, 0.037367299, 0.037424225, 0.037481289, 0.037538353, 0.037595496, 0.037652683, 0.037709936, 0.037767332, 0.037824731, 0.03788222, 0.037939761, 0.03799735, 0.038055032, 0.038112804, 0.038170628, 0.038228497, 0.03828644, 0.038344454, 0.038402513, 0.038460709, 0.038518909, 0.038577206, 0.038635574, 0.038693912, 0.038752444, 0.038811024, 0.038869601, 0.038928278, 0.038987022, 0.039045811, 0.039104767, 0.039163724, 0.039222728, 0.039281826, 0.039340924, 0.039400212, 0.0394595, 0.039518833, 0.03957824, 0.039637737, 0.039697263, 0.039756928, 0.039816614, 0.039876353, 0.039936181, 0.039996039, 0.040056009, 0.040116098, 0.040176142, 0.040236305, 0.04029651, 0.040356766, 0.040417142, 0.040477585, 0.040538076, 0.040598664, 0.040659271, 0.04071993, 0.040780727, 0.040841576, 0.040902425, 0.040963411, 0.04102442, 0.04108553, 0.041146707, 0.041207928, 0.041269198, 0.041330565, 0.041392002, 0.041453537, 0.04151509, 0.041576713, 0.041638408, 0.041700155, 0.041762017, 0.041823946, 0.041885883, 0.041947912, 0.042010006, 0.042072155, 0.042134367, 0.042196728, 0.042259037, 0.042321488, 0.042383987, 0.042446535, 0.042509228, 0.04257194, 0.042634696, 0.0426975, 0.042760406, 0.042823352, 0.042886443, 0.042949509, 0.043012671, 0.043075927, 0.043139204, 0.043202624, 0.043266069, 0.043329563, 0.04339315, 0.043456759, 0.043520439, 0.043584239, 0.043648083, 0.043711975, 0.043775942, 0.043839999, 0.043904081, 0.043968327, 0.044032555, 0.04409685, 0.044161212, 0.044225648, 0.044290155, 0.044354755, 0.044419359, 0.044484105, 0.044548869, 0.044613685, 0.044678643, 0.044743624, 0.044808667, 0.044873793, 0.044938937, 0.045004152, 0.045069534, 0.045134865, 0.045200348, 0.04526582, 0.045331411, 0.045397028, 0.045462817, 0.045528572, 0.045594424, 0.045660332, 0.045726325, 0.045792393, 0.04585848, 0.045924667, 0.045990922, 0.046057198, 0.046123575, 0.046190087, 0.046256602, 0.046323191, 0.046389818, 0.046456527, 0.04652337, 0.046590216, 0.046657108, 0.04672407, 0.046791155, 0.04685824, 0.046925463, 0.046992704, 0.047060024, 0.047127437, 0.047194876, 0.047262408, 0.047330007, 0.047397655, 0.047465403, 0.047533121, 0.047600981, 0.047668912, 0.047736961, 0.047805011, 0.047873139, 0.047941305, 0.048009548, 0.04807793, 0.048146281, 0.04821473, 0.048283234, 0.048351854, 0.048420493, 0.048489273, 0.048558034, 0.048626911, 0.048695836, 0.04876478, 0.048833895, 0.048903033, 0.048972216, 0.049041498, 0.049110793, 0.049180213, 0.04924969, 0.049319226, 0.049388807, 0.049458463, 0.049528193, 0.04959802, 0.049667865, 0.049737774, 0.049807813, 0.049877852, 0.049947973, 0.050018225, 0.050088469, 0.050159458, 0.050231386, 0.050303474, 0.050375562, 0.050447822, 0.050520122, 0.050592467, 0.050664842, 0.05073731, 0.050809965, 0.050882597, 0.050955303, 0.051028054, 0.051100947, 0.051173888, 0.051246922, 0.051320028, 0.051393151, 0.051466353, 0.051539674, 0.051613037, 0.051686496, 0.051760025, 0.051833607, 0.051907297, 0.051981043, 0.052054834, 0.052128766, 0.052202716, 0.052276772, 0.052350845, 0.05242506, 0.052499324, 0.052573636, 0.052648012, 0.052722532, 0.052797027, 0.052871626, 0.052946411, 0.053021144, 0.053095974, 0.053170901, 0.053245913, 0.053320955, 0.053396091, 0.053471301, 0.053546555, 0.053621948, 0.053697351, 0.053772908, 0.053848471, 0.053924128, 0.053999834, 0.054075632, 0.054151472, 0.054227415, 0.054303445, 0.054379549, 0.054455709, 0.05453188, 0.054608289, 0.054684635, 0.054761112, 0.054837599, 0.054914225, 0.054990873, 0.055067636, 0.055144452, 0.055221364, 0.05529834, 0.055375341, 0.055452533, 0.05552968, 0.055606965, 0.055684272, 0.055761654, 0.055839196, 0.055916671, 0.055994339, 0.056072026, 0.056149807, 0.05622771, 0.056305587, 0.056383606, 0.056461662, 0.056539781, 0.056617983, 0.056696288, 0.056774661, 0.056853082, 0.056931596, 0.057010155, 0.057088815, 0.057167567, 0.057246357, 0.057325251, 0.057404194, 0.057483204, 0.05756231, 0.057641458, 0.057720728, 0.057800051, 0.057879385, 0.057958897, 0.058038425, 0.058118027, 0.05819767, 0.058277458, 0.058357231, 0.05843718, 0.058517162, 0.058597188, 0.058677308, 0.058757547, 0.05883776, 0.058918141, 0.05899857, 0.059078995, 0.059159592, 0.059240233, 0.059320919, 0.059401676, 0.059482552, 0.059563473, 0.05964449, 0.059725579, 0.059806719, 0.059887923, 0.059969224, 0.060050599, 0.060132015, 0.060213558, 0.060295142, 0.060376797, 0.060458478, 0.060540341, 0.060622189, 0.060704131, 0.060786206, 0.060868267, 0.060950443, 0.061032686, 0.061115008, 0.061197441, 0.061279904, 0.061362404, 0.061445072, 0.061527744, 0.061610445, 0.061693329, 0.061776232, 0.06185919, 0.061942238, 0.062025383, 0.062108573, 0.062191859, 0.06227519, 0.062358618, 0.062442143, 0.062525667, 0.0626093, 0.062693015, 0.062776797, 0.062860653, 0.062944598, 0.063028559, 0.063112698, 0.063196838, 0.063281044, 0.063365363, 0.063449718, 0.063534155, 0.063618675, 0.063703284, 0.063787915, 0.06387271, 0.063957483, 0.064042419, 0.064127333, 0.064212352, 0.064297497, 0.06438265, 0.064467922, 0.064553216, 0.06463863, 0.06472411, 0.064809635, 0.064895242, 0.064980961, 0.065066703, 0.065152556, 0.065238468, 0.065324441, 0.065410517, 0.065496638, 0.065582849, 0.065669112, 0.065755494, 0.065841876, 0.06592837, 0.06601496, 0.066101603, 0.066188291, 0.066275142, 0.066361971, 0.06644889, 0.066535927, 0.06662298, 0.066710152, 0.066797391, 0.066884741, 0.066972084, 0.067059554, 0.067147091, 0.067234628, 0.067322329, 0.067410074, 0.067497879, 0.067585766, 0.06767375, 0.067761742, 0.067849889, 0.067938045, 0.068026282, 0.068114676, 0.068203069, 0.068291523, 0.068380073, 0.06846875, 0.068557367, 0.068646178, 0.068735018, 0.068823896, 0.068912901, 0.069001995, 0.069091097, 0.06918031, 0.06926962, 0.069358952, 0.069448426, 0.069537893, 0.069627471, 0.069717132, 0.069806866, 0.069896646, 0.0699865, 0.070076473, 0.070166484, 0.070256568, 0.070346735, 0.070436962, 0.070527241, 0.070617639, 0.070708051, 0.070798613, 0.070889242, 0.070979923, 0.071070671, 0.071161471, 0.071252383, 0.07134334, 0.071434408, 0.071525514, 0.071616687, 0.071707949, 0.071799308, 0.071890704, 0.07198216, 0.072073787, 0.07216534, 0.072257072, 0.072348818, 0.072440676, 0.072532594, 0.072624616, 0.072716631, 0.072808854, 0.072901048, 0.072993301, 0.073085681, 0.073178083, 0.073270604, 0.073363177, 0.073455863, 0.07354854, 0.073641405, 0.073734209, 0.0738272, 0.073920235, 0.074013308, 0.074106537, 0.074199721, 0.07429301, 0.074386433, 0.0744799, 0.07457339, 0.074667022, 0.074760675, 0.074854448, 0.074948318, 0.075042181, 0.0751362, 0.075230226, 0.075324357, 0.075418524, 0.075512797, 0.075607114, 0.075701572, 0.07579603, 0.075890608, 0.075985275, 0.07607995, 0.076174714, 0.076269574, 0.076364525, 0.076459505, 0.076554596, 0.076649696, 0.076744981, 0.076840244, 0.076935574, 0.077031054, 0.077126548, 0.077222139, 0.077317841, 0.077413559, 0.077509336, 0.077605262, 0.077701159, 0.077797174, 0.077893339, 0.077989466, 0.078085698, 0.078182071, 0.078278415, 0.078374907, 0.078471437, 0.078568026, 0.078664772, 0.078761496, 0.078858323, 0.078955233, 0.079052202, 0.079149231, 0.079246409, 0.07934358, 0.079440869, 0.079538211, 0.07963562, 0.079733126, 0.079830676, 0.079928324, 0.080026045, 0.080123805, 0.080221668, 0.080319621, 0.080417618, 0.080515675, 0.080613859, 0.08071205, 0.080810361, 0.08090876, 0.08100716, 0.081105679, 0.081204295, 0.081302986, 0.081401713, 0.081500545, 0.081599377, 0.081698388, 0.081797384, 0.081896476, 0.081995659, 0.08209493, 0.082194231, 0.082293622, 0.08239311, 0.08249265, 0.082592279, 0.08269196, 0.082791708, 0.082891576, 0.082991496, 0.083091453, 0.083191529, 0.083291635, 0.083391853, 0.083492167, 0.083592512, 0.083692946, 0.083793379, 0.08389397, 0.083994627, 0.084095344, 0.084196128, 0.084296986, 0.084397897, 0.084498964, 0.084600031, 0.08470118, 0.084802441, 0.084903695, 0.085005075, 0.085106552, 0.085208096, 0.085309669, 0.085411325, 0.085513063, 0.085614912, 0.085716784, 0.085818738, 0.085920796, 0.086022906, 0.086125068, 0.086227365, 0.086329661, 0.086432062, 0.086534552, 0.086637065, 0.086739689, 0.08684244, 0.086945191, 0.087048031, 0.087150954, 0.087253936, 0.087356992, 0.087460138, 0.087563314, 0.087666653, 0.087769963, 0.087873429, 0.087976955, 0.088080458, 0.088184178, 0.088287868, 0.088391654, 0.088495493, 0.088599496, 0.088703446, 0.08880759, 0.088911705, 0.089015946, 0.089120254, 0.089224651, 0.089329131, 0.089433648, 0.089538246, 0.08964292, 0.089747705, 0.089852482, 0.089957386, 0.090062328, 0.090167396, 0.090272494, 0.090377703, 0.090482995, 0.090588257, 0.090693697, 0.09079916, 0.090904772, 0.091010377, 0.091116086, 0.091221854, 0.091327697, 0.091433629, 0.091539592, 0.09164568, 0.091751821, 0.091858044, 0.091964312, 0.092070699, 0.092177115, 0.092283614, 0.09239018, 0.09249685, 0.092603631, 0.092710428, 0.092817269, 0.092924215, 0.093031272, 0.09313833, 0.093245529, 0.093352742, 0.093460053, 0.093567453, 0.093674868, 0.093782447, 0.093890063, 0.093997747, 0.094105475, 0.094213329, 0.094321184, 0.094429173, 0.094537236, 0.094645351, 0.094753526, 0.094861805, 0.094970122, 0.095078573, 0.095187061, 0.095297344, 0.095409326, 0.095521331, 0.095633462, 0.095745586, 0.095857807, 0.09597005, 0.096082419, 0.096194796, 0.096307255, 0.096419752, 0.096532308, 0.096644975, 0.096757613, 0.096870385, 0.096983202, 0.097096078, 0.097209014, 0.097321987, 0.097435065, 0.097548157, 0.097661331, 0.097774498, 0.097887866, 0.098001167, 0.098114595, 0.098228067, 0.098341584, 0.098455183, 0.098568819, 0.098682545, 0.09879633, 0.098910153, 0.099024005, 0.099137999, 0.099251986, 0.099366054, 0.099480182, 0.099594332, 0.099708617, 0.099822938, 0.099937312, 0.10005171, 0.10016624, 0.10028075, 0.10039537, 0.10051003, 0.10062476, 0.1007395, 0.1008544, 0.10096934, 0.10108427, 0.10119928, 0.10131438, 0.10142955, 0.1015447, 0.10165999, 0.1017753, 0.1018907, 0.10200617, 0.10212167, 0.10223725, 0.10235286, 0.10246856, 0.1025843, 0.10270014, 0.10281594, 0.1029319, 0.10304788, 0.10316392, 0.10328001, 0.10339621, 0.10351245, 0.10362873, 0.10374506, 0.10386147, 0.10397796, 0.10409446, 0.10421105, 0.1043277, 0.10444438, 0.10456115, 0.10467798, 0.10479489, 0.1049118, 0.10502882, 0.10514586, 0.10526302, 0.10538018, 0.10549741, 0.10561473, 0.10573211, 0.1058495, 0.10596702, 0.10608458, 0.10620215, 0.10631984, 0.10643755, 0.10655534, 0.10667318, 0.10679109, 0.10690905, 0.10702707, 0.10714513, 0.1072633, 0.10738152, 0.10749976, 0.10761812, 0.10773648, 0.10785494, 0.10797343, 0.108092, 0.10821059, 0.10832931, 0.10844805, 0.10856684, 0.10868572, 0.10880461, 0.10892364, 0.10904265, 0.10916176, 0.10928092, 0.10940015, 0.1095194, 0.10963876, 0.10975815, 0.1098776, 0.10999715, 0.11011671, 0.11023641, 0.11035608, 0.11047583, 0.11059566, 0.11071557, 0.11083548, 0.11095551, 0.11107553, 0.11119569, 0.11131589, 0.1114361, 0.11155643, 0.11167677, 0.11179721, 0.11191768, 0.11203823, 0.1121588, 0.1122795, 0.11240019, 0.11252097, 0.11264184, 0.11276273, 0.11288368, 0.11300468, 0.11312579, 0.11324691, 0.11336814, 0.11348934, 0.1136107, 0.11373206, 0.11385349, 0.11397504, 0.11409659, 0.11421821, 0.11433989, 0.11446161, 0.1145834, 0.1147053, 0.11482718, 0.11494916, 0.11507121, 0.11519333, 0.11531549, 0.11543772, 0.11555999, 0.11568233, 0.11580473, 0.11592717, 0.11604971, 0.11617227, 0.11629491, 0.11641762, 0.11654039, 0.1166632, 0.11678609, 0.11690904, 0.11703201, 0.1171551, 0.1172782, 0.11740136, 0.11752459, 0.11764792, 0.11777124, 0.11789468, 0.11801816, 0.11814171, 0.1182653, 0.11838893, 0.11851268, 0.11863644, 0.11876028, 0.11888418, 0.11900813, 0.11913216, 0.11925622, 0.1193804, 0.11950457, 0.11962887, 0.11975313, 0.11987755, 0.12000196, 0.12012646, 0.120251, 0.12037564, 0.12050032, 0.12062506, 0.12074986, 0.12087471, 0.12099964, 0.1211246, 0.12124967, 0.12137473, 0.12149989, 0.1216251, 0.1217504, 0.12187573, 0.1220011, 0.12212655, 0.12225209, 0.12237768, 0.1225033, 0.12262899, 0.12275474, 0.12288056, 0.12300643, 0.12313238, 0.12325837, 0.12338442, 0.12351054, 0.1236367, 0.12376297, 0.12388925, 0.12401559, 0.124142, 0.12426849, 0.12439502, 0.12452164, 0.1246483, 0.12477501, 0.12490179, 0.1250286, 0.12515551, 0.12528245, 0.12540948, 0.12553655, 0.12566367, 0.12579085, 0.12591815, 0.12604545, 0.12617281, 0.12630026, 0.12642772, 0.12655531, 0.12668291, 0.12681057, 0.12693831, 0.12706611, 0.12719393, 0.12732187, 0.12744984, 0.12757786, 0.12770601, 0.12783414, 0.12796235, 0.12809063, 0.12821895, 0.12834734, 0.1284758, 0.12860428, 0.12873287, 0.12886153, 0.1289902, 0.12911899, 0.12924777, 0.12937662, 0.12950559, 0.12963454, 0.12976362, 0.12989274, 0.1300219, 0.13015114, 0.13028042, 0.13040979, 0.13053921, 0.13066866, 0.13079819, 0.13092777, 0.13105743, 0.13118711, 0.13131693, 0.13144672, 0.13157666, 0.13170663, 0.13183659, 0.13196668, 0.13209681, 0.132227, 0.13235724, 0.13248757, 0.13261791, 0.13274838, 0.13287884, 0.13300939, 0.13314004, 0.13327068, 0.13340144, 0.13353221, 0.13366306, 0.13379398, 0.13392493, 0.13405594, 0.13418707, 0.1343182, 0.13444942, 0.13458072, 0.13471203, 0.13484341, 0.13497484, 0.1351064, 0.13523793, 0.13536957, 0.13550124, 0.13563301, 0.13576481, 0.13589668, 0.13602862, 0.1361606, 0.13629264, 0.13642476, 0.13655692, 0.13668914, 0.13682145, 0.13695379, 0.13708623, 0.13721865, 0.1373512, 0.13748382, 0.13761643, 0.13774914, 0.13788192, 0.13801475, 0.13814762, 0.1382806, 0.13841358, 0.13854666, 0.13867979, 0.13881297, 0.13894621, 0.13907953, 0.13921291, 0.13934632, 0.13947983, 0.13961336, 0.13974696, 0.13988061, 0.14001437, 0.14014813, 0.14028199, 0.14041588, 0.14054988, 0.14068389, 0.14081794, 0.14095213, 0.14108631, 0.14122061, 0.14135493, 0.14148931, 0.14162375, 0.14175828, 0.14189284, 0.14202747, 0.14216214, 0.1422969, 0.14243169, 0.14256655, 0.14270148, 0.14283647, 0.14297153, 0.14310664, 0.14324181, 0.14337702, 0.14351232, 0.14364767, 0.14378305, 0.14391854, 0.14405406, 0.14418963, 0.14432526, 0.14446099, 0.14459677, 0.14473255, 0.14486846, 0.14500441, 0.14514041, 0.14527644, 0.14541261, 0.14554878, 0.14568503, 0.14582132, 0.14595769, 0.14609411, 0.14623061, 0.14636715, 0.14650373, 0.14664042, 0.14677714, 0.14691395, 0.14705077, 0.14718765, 0.14732462, 0.14746167, 0.14759874, 0.14773591, 0.14787312, 0.14801034, 0.1481477, 0.14828505, 0.14842249, 0.14856002, 0.14869757, 0.14883517, 0.14897288, 0.14911063, 0.14924841, 0.1493863, 0.14952421, 0.1496622, 0.14980021, 0.1499383, 0.15007648, 0.1502147, 0.15035297, 0.15049134, 0.15062976, 0.15076822, 0.15090674, 0.15104529, 0.15118396, 0.15132263, 0.15146142, 0.15160026, 0.15173912, 0.15187806, 0.15201707, 0.15215614, 0.15229525, 0.15243445, 0.15257367, 0.152713, 0.15285233, 0.15299176, 0.15313125, 0.1532708, 0.15341036, 0.15355003, 0.15368977, 0.15382954, 0.15396938, 0.15410925, 0.15424925, 0.15438925, 0.15452933, 0.15466949, 0.1548097, 0.15494992, 0.15509027, 0.15523064, 0.15537106, 0.1555116, 0.15565214, 0.15579276, 0.15593345, 0.15607418, 0.15621497, 0.15635584, 0.15649675, 0.15663776, 0.1567788, 0.1569199, 0.15706107, 0.15720226, 0.15734352, 0.15748489, 0.15762629, 0.1577677, 0.15790927, 0.15805084, 0.15819249, 0.1583342, 0.15847592, 0.15861776, 0.1587632, 0.15891214, 0.15906103, 0.15920994, 0.15935886, 0.1595078, 0.15965673, 0.15980566, 0.15995462, 0.16010356, 0.1602525, 0.16040148, 0.16055043, 0.16069941, 0.16084838, 0.16099735, 0.16114636, 0.16129534, 0.16144432, 0.16159332, 0.16174233, 0.16189133, 0.16204035, 0.16218938, 0.16233839, 0.16248743, 0.16263646, 0.16278552, 0.16293456, 0.1630836, 0.16323267, 0.16338171, 0.16353077, 0.16367984, 0.16382892, 0.16397801, 0.16412707, 0.16427615, 0.16442525, 0.16457437, 0.16472346, 0.16487259, 0.1650217, 0.1651708, 0.16531995, 0.16546907, 0.16561818, 0.16576734, 0.16591649, 0.16606565, 0.16621479, 0.16636394, 0.16651312, 0.16666231, 0.16681148, 0.16696067, 0.16710985, 0.16725902, 0.16740824, 0.16755745, 0.16770662, 0.16785587, 0.16800509, 0.16815428, 0.16830353, 0.16845277, 0.16860199, 0.16875124, 0.16890049, 0.16904972, 0.16919899, 0.16934825, 0.16949752, 0.1696468, 0.16979606, 0.16994537, 0.17009464, 0.1702439, 0.17039324, 0.17054254, 0.17069182, 0.17084116, 0.17099047, 0.17113979, 0.17128913, 0.17143846, 0.17158781, 0.17173713, 0.17188647, 0.17203586, 0.17218521, 0.17233455, 0.17248397, 0.17263332, 0.17278269, 0.17293209, 0.17308147, 0.17323086, 0.17338027, 0.17352967, 0.1736791, 0.1738285, 0.17397791, 0.17412733, 0.17427677, 0.17442621, 0.17457564, 0.17472509, 0.17487454, 0.17502399, 0.17517345, 0.17532291, 0.17547239, 0.17562187, 0.17577137, 0.17592084, 0.17607032, 0.17621982, 0.17636932, 0.17651883, 0.17666835, 0.17681783, 0.17696737, 0.17711693, 0.17726643, 0.17741597, 0.17756552, 0.17771506, 0.17786463, 0.17801417, 0.17816372, 0.1783133, 0.17846286, 0.17861243, 0.17876202, 0.17891163, 0.17906119, 0.17921081, 0.1793604, 0.17951, 0.17965966, 0.17980926, 0.17995889, 0.1801085, 0.18025813, 0.18040778, 0.18055741, 0.18070705, 0.18085672, 0.18100637, 0.18115604, 0.18130572, 0.18145537, 0.18160506, 0.18175475, 0.18190444, 0.18205416, 0.18220384, 0.18235353, 0.18250324, 0.18265297, 0.18280266, 0.1829524, 0.18310213, 0.18325186, 0.18340161, 0.18355137, 0.18370108, 0.18385085, 0.1840006, 0.1841504, 0.18430017, 0.18444991, 0.18459973, 0.18474951, 0.18489927, 0.18504909, 0.18519889, 0.18534867, 0.18549851, 0.18564831, 0.18579812, 0.18594797, 0.1860978, 0.18624763, 0.18639748, 0.18654731, 0.18669717, 0.18684703, 0.18699688, 0.18714677, 0.18729661, 0.18744652, 0.18759638, 0.18774626, 0.18789615, 0.18804607, 0.18819596, 0.18834586, 0.18849578, 0.18864569, 0.18879563, 0.18894552, 0.18909545, 0.18924543, 0.18939535, 0.1895453, 0.18969527, 0.18984522, 0.18999515, 0.19014518, 0.19029512, 0.19044513, 0.19059511, 0.19074509, 0.19089507, 0.19104509, 0.19119509, 0.19134508, 0.19149511, 0.19164512, 0.19179514, 0.19194517, 0.19209518, 0.19224524, 0.19239528, 0.19254535, 0.19269539, 0.19284545, 0.19299553, 0.19314557, 0.19329566, 0.19344574, 0.19359581, 0.19374591, 0.19389603, 0.19404611, 0.19419622, 0.19434634, 0.19449644, 0.19464658, 0.1947967, 0.1949468, 0.19509697, 0.1952471, 0.19539724, 0.19554739, 0.19569756, 0.19584769, 0.19599788, 0.19614804, 0.19629821, 0.1964484, 0.19659859, 0.19674878, 0.19689897, 0.19704916, 0.19719939, 0.19734961, 0.1974998, 0.19765005, 0.19780028, 0.19795047, 0.19810075, 0.19825098, 0.19840121, 0.19855149, 0.19870174, 0.198852, 0.19900227, 0.19915254, 0.19930282, 0.1994531, 0.19960338, 0.19975369, 0.19990396, 0.20005429, 0.2002046, 0.20035487, 0.20050521, 0.20065555, 0.20080587, 0.20095618, 0.20110655, 0.20125687, 0.20140727, 0.20155759, 0.20170794, 0.20185831, 0.20200866, 0.20215903, 0.20230947, 0.20245983, 0.20261019, 0.20276064, 0.202911, 0.2030614, 0.20321183, 0.20336224, 0.20351265, 0.2036631, 0.20381349, 0.20396395, 0.20411439, 0.20426483, 0.20441528, 0.20456575, 0.20471621, 0.20486668, 0.20501715, 0.20516759, 0.20531809, 0.20546858, 0.2056191, 0.20576958, 0.20592007, 0.2060706, 0.20622109, 0.20637162, 0.20652211, 0.20667268, 0.20682317, 0.20697372, 0.20712426, 0.20727479, 0.20742537, 0.2075759, 0.20772648, 0.20787704, 0.2080276, 0.20817824, 0.20832878, 0.20847936, 0.20862997, 0.20878057, 0.20893116, 0.20908177, 0.20923239, 0.20938298, 0.20953362, 0.20968425, 0.20983489, 0.20998552, 0.21013615, 0.21028683, 0.21043746, 0.21058811, 0.21073879, 0.21088946, 0.21104014, 0.21119083, 0.21134149, 0.21149217, 0.21164289, 0.21179357, 0.2119443, 0.21209499, 0.21224572, 0.21239643, 0.21254714, 0.21269788, 0.21284862, 0.21299936, 0.21315008, 0.21330085, 0.21345159, 0.21360233, 0.21375316, 0.2139039, 0.21405469, 0.21420546, 0.21435624, 0.21450704, 0.21465783, 0.21480864, 0.21495944, 0.21511023, 0.21526106, 0.21541189, 0.21556272, 0.21571352, 0.21586441, 0.21601522, 0.21616608, 0.21631694, 0.21646775, 0.21661866, 0.2167695, 0.21692038, 0.21707124, 0.21722215, 0.21737303, 0.21752392, 0.21767481, 0.21782573, 0.21797661, 0.21812755, 0.21827845, 0.21842937, 0.21858028, 0.21873124, 0.21888217, 0.21903311, 0.21918406, 0.21933502, 0.21948595, 0.21963693, 0.21978788, 0.21993887, 0.22008985, 0.22024083, 0.22039182, 0.22054283, 0.2206938, 0.22084485, 0.22099581, 0.22114684, 0.22129786, 0.2214489, 0.22159989, 0.22175096, 0.221902, 0.22205302, 0.2222041, 0.22235514, 0.2225062, 0.22265726, 0.22280835, 0.22295943, 0.22311048, 0.22326156, 0.22341268, 0.22356376, 0.22371484, 0.22386599, 0.22401708, 0.22416817, 0.22431929, 0.22447042, 0.22462156, 0.22477271, 0.22492383, 0.22507501, 0.22522613, 0.22537731, 0.22552846, 0.22567961, 0.22583076, 0.22598197, 0.22613314, 0.22628433, 0.22643554, 0.22658673, 0.22673793, 0.22688912, 0.22704035, 0.22719158, 0.22734277, 0.22749403, 0.22764523, 0.22779649, 0.22794773, 0.228099, 0.22825022, 0.22840145, 0.22855276, 0.22870401, 0.2288553, 0.22900657, 0.22915785, 0.22930914, 0.22946043, 0.22961171, 0.22976305, 0.22991432, 0.23006566, 0.23021697, 0.23036832, 0.23051964, 0.23067097, 0.23082231, 0.23097363, 0.23112498, 0.23127632, 0.23142773, 0.23157908, 0.23173042, 0.23188183, 0.23203318, 0.23218456, 0.23233598, 0.23248737, 0.23263875, 0.23279016, 0.23294158, 0.23309296, 0.23324439, 0.23339581, 0.23354727, 0.2336987, 0.23384972, 0.23400065, 0.23415153, 0.23430227, 0.23445301, 0.2346036, 0.23475416, 0.23490465, 0.235055, 0.23520532, 0.23535556, 0.23550574, 0.23565583, 0.23580582, 0.23595576, 0.23610565, 0.23625542, 0.2364051, 0.23655476, 0.23670429, 0.23685378, 0.23700318, 0.2371525, 0.23730174, 0.23745094, 0.23760003, 0.23774907, 0.23789801, 0.23804685, 0.23819569, 0.2383444, 0.23849301, 0.2386416, 0.23879008, 0.23893848, 0.23908685, 0.23923507, 0.23938328, 0.2395314, 0.23967941, 0.23982738, 0.23997527, 0.24012306, 0.24027081, 0.24041845, 0.24056602, 0.24071352, 0.24086095, 0.24100827, 0.24115558, 0.24130277, 0.24144988, 0.24159694, 0.24174391, 0.24189077, 0.24203761, 0.24218431, 0.24233101, 0.2424776, 0.24262409, 0.24277054, 0.24291688, 0.24306317, 0.24320938, 0.2433555, 0.24350156, 0.24364755, 0.24379344, 0.24393928, 0.244085, 0.24423067, 0.24437629, 0.2445218, 0.24466726, 0.24481264, 0.24495791, 0.24510312, 0.24524827, 0.24539335, 0.24553831, 0.24568322, 0.24582806, 0.24597283, 0.24611752, 0.2462621, 0.24640664, 0.2465511, 0.2466955, 0.24683979, 0.24698398, 0.24712814, 0.24727222, 0.24741624, 0.24756014, 0.247704, 0.24784777, 0.24799146, 0.2481351, 0.24827862, 0.24842209, 0.24856548, 0.24870878, 0.24885201, 0.24899518, 0.24913828, 0.24928129, 0.2494242, 0.24956709, 0.24970984, 0.24985255, 0.24999519, 0.25013772, 0.25028023, 0.2504226, 0.25056493, 0.25070721, 0.25084937, 0.25099146, 0.25113347, 0.25127542, 0.25141728, 0.25155908, 0.25170079, 0.25184241, 0.251984, 0.25212547, 0.25226685, 0.25240821, 0.25254947, 0.25269067, 0.25283176, 0.25297278, 0.25311372, 0.25325462, 0.25339541, 0.25353613, 0.2536768, 0.25381738, 0.25395787, 0.2540983, 0.25423864, 0.25437889, 0.25451908, 0.25465921, 0.25479928, 0.25493923, 0.25507909, 0.25521889, 0.25535864, 0.25549832, 0.25563788, 0.25577739, 0.25591686, 0.25605616, 0.25619546, 0.25633469, 0.25647381, 0.25661287, 0.25675184, 0.25689071, 0.25702956, 0.25716826, 0.25730693, 0.25744554, 0.25758407, 0.2577225, 0.25786087, 0.25799915, 0.25813738, 0.25827548, 0.25841355, 0.25855157, 0.25868943, 0.2588273, 0.25896508, 0.25910273, 0.25924033, 0.25937787, 0.25951535, 0.2596527, 0.25978997, 0.25992718, 0.26006433, 0.26020139, 0.26033843, 0.26047534, 0.26061216, 0.26074895, 0.26088566, 0.26102227, 0.26115879, 0.26129526, 0.26143163, 0.26156795, 0.26170418, 0.26184034, 0.26197642, 0.26211244, 0.26224834, 0.26238421, 0.26251999, 0.26265568, 0.26279134, 0.26292685, 0.26306233, 0.26319772, 0.26333305, 0.2634683, 0.26360345, 0.26373854, 0.26387358, 0.26400849, 0.26414338, 0.26427817, 0.26441285, 0.26454753, 0.26468205, 0.26481652, 0.26495096, 0.26508528, 0.26521954, 0.26535371, 0.26548785, 0.26562187, 0.2657558, 0.26588967, 0.26602346, 0.26615718, 0.26629084, 0.26642442, 0.2665579, 0.26669133, 0.26682463, 0.26695791, 0.2670911, 0.26722419, 0.26735726, 0.26749024, 0.2676231, 0.2677559, 0.26788867, 0.26802132, 0.26815388, 0.26828638, 0.26841882, 0.26855114, 0.26868343, 0.26881567, 0.26894778, 0.2690798, 0.26921177, 0.26934367, 0.26947549, 0.26960725, 0.26973888, 0.26987052, 0.27000201, 0.27013344, 0.2702648, 0.27039608, 0.2705273, 0.27065843, 0.2707895, 0.27092049, 0.27105138, 0.27118224, 0.27131295, 0.27144364, 0.27157423, 0.27170476, 0.27183521, 0.27196556, 0.27209589, 0.2722261, 0.27235624, 0.2724863, 0.2726163, 0.27274624, 0.27287605, 0.27300581, 0.27313551, 0.27326512, 0.27339467, 0.27352411, 0.27365351, 0.27378282, 0.27391201, 0.27404115, 0.27417028, 0.27429926, 0.27442819, 0.27455705, 0.27468583, 0.27481452, 0.27494314, 0.27507168, 0.27520013, 0.27532855, 0.27545688, 0.27558511, 0.27571326, 0.27584136, 0.27596936, 0.2760973, 0.27622515, 0.27635294, 0.27648067, 0.27660832, 0.27673581, 0.27686331, 0.27699074, 0.27711806, 0.27724528, 0.27737248, 0.27749959, 0.2776266, 0.27775353, 0.27788043, 0.27800721, 0.27813393, 0.27826056, 0.27838716, 0.27851364, 0.27864003, 0.27876639, 0.27889264, 0.27901882, 0.27914494, 0.27927098, 0.27939692, 0.27952281, 0.2796486, 0.27977434, 0.27989998, 0.28002557, 0.28015107, 0.28027651, 0.28040183, 0.28052711, 0.28065228, 0.28077745, 0.28090248, 0.28102744, 0.28115234, 0.28127715, 0.2814019, 0.28152654, 0.28165114, 0.28177565, 0.28190008, 0.28202444, 0.28214872, 0.28227293, 0.28239706, 0.28252113, 0.28264508, 0.28276902, 0.28289282, 0.28301656, 0.28314024, 0.28326383, 0.28338736, 0.2835108, 0.28363419, 0.28375748, 0.28388068, 0.28400382, 0.28412688, 0.28424987, 0.28437278, 0.28449562, 0.28461838, 0.28474107, 0.28486368, 0.2849862, 0.28510866, 0.28523105, 0.28535336, 0.28547555, 0.28559771, 0.28571981, 0.28584182, 0.28596371, 0.28608558, 0.28620732, 0.28632903, 0.28645068, 0.28657222, 0.28669366, 0.28681505, 0.28693637, 0.28705761, 0.28717875, 0.28729984, 0.28742087, 0.28754178, 0.28766266, 0.28778341, 0.28790414, 0.28802478, 0.2881453, 0.28826579, 0.2883862, 0.28850651, 0.28862676, 0.28874692, 0.28886703, 0.28898707, 0.28910699, 0.28922686, 0.28934667, 0.28946638, 0.28958601, 0.28970554, 0.28982505, 0.28994447, 0.2900638, 0.29018307, 0.29030225, 0.29042137, 0.29054037, 0.29065934, 0.29077822, 0.29089701, 0.29101574, 0.29113439, 0.29125297, 0.29137146, 0.29148987, 0.29160821, 0.2917265, 0.29184467, 0.29196277, 0.29208085, 0.29219881, 0.2923167, 0.29243451, 0.29255223, 0.29266986, 0.29278746, 0.29290497, 0.29302245, 0.29313979, 0.29325706, 0.29337424, 0.29349136, 0.29360843, 0.2937254, 0.29384232, 0.29395911, 0.29407588, 0.29419252, 0.29430914, 0.29442567, 0.2945421, 0.29465848, 0.29477474, 0.29489097, 0.29500711, 0.29512316, 0.29523915, 0.29535505, 0.29547086, 0.29558665, 0.29570234, 0.29581791, 0.29593349, 0.29604891, 0.29616427, 0.29627958, 0.2963948, 0.29650995, 0.29662502, 0.29674003, 0.29685497, 0.2969698, 0.29708454, 0.29719925, 0.29731387, 0.2974284, 0.29754284, 0.29765725, 0.29777157, 0.29788581, 0.29799998, 0.29811403, 0.29822803, 0.29834196, 0.29845583, 0.29856962, 0.29868332, 0.29879692, 0.29891047, 0.29902399, 0.29913735, 0.29925066, 0.29936391, 0.2994771, 0.29959017, 0.29970318, 0.29981145, 0.29991487, 0.30001813, 0.30012134, 0.30022436, 0.30032733, 0.30043012, 0.30053285, 0.30063543, 0.30073789, 0.30084023, 0.30094248, 0.30104458, 0.30114657, 0.30124843, 0.30135021, 0.30145183, 0.30155337, 0.30165476, 0.30175605, 0.30185723, 0.30195829, 0.30205923, 0.30216002, 0.30226073, 0.30236131, 0.30246177, 0.30256212, 0.30266231, 0.30276245, 0.30286244, 0.30296233, 0.30306205, 0.30316168, 0.30326122, 0.30336061, 0.30345988, 0.30355906, 0.3036581, 0.30375701, 0.30385587, 0.30395454, 0.3040531, 0.30415156, 0.30424991, 0.30434811, 0.30444622, 0.30454421, 0.30464208, 0.30473983, 0.30483747, 0.30493498, 0.30503237, 0.30512968, 0.3052268, 0.30532384, 0.30542079, 0.30551758, 0.30561426, 0.30571082, 0.30580729, 0.30590361, 0.30599985, 0.30609596, 0.30619195, 0.3062878, 0.30638355, 0.30647916, 0.30657467, 0.30667007, 0.30676532, 0.30686048, 0.30695555, 0.30705044, 0.30714524, 0.30723992, 0.30733448, 0.30742893, 0.30752328, 0.30761749, 0.30771157, 0.30780554, 0.30789942, 0.30799314, 0.30808678, 0.30818027, 0.30827367, 0.30836692, 0.30846009, 0.30855313, 0.30864602, 0.30873883, 0.30883151, 0.30892408, 0.3090165, 0.30910885, 0.30920103, 0.30929312, 0.30938509, 0.30947694, 0.3095687, 0.30966032, 0.30975181, 0.30984318, 0.30993447, 0.3100256, 0.31011665, 0.31020755, 0.31029832, 0.31038898, 0.31047955, 0.31057, 0.31066033, 0.31075054, 0.31084061, 0.31093055, 0.31102043, 0.31111017, 0.31119978, 0.31128928, 0.31137866, 0.31146792, 0.31155702, 0.31164607, 0.31173497, 0.31182379, 0.31191245, 0.31200096, 0.31208944, 0.31217775, 0.31226593, 0.312354, 0.31244197, 0.31252983, 0.31261754, 0.31270516, 0.31279263, 0.31288001, 0.31296727, 0.31305441, 0.31314141, 0.31322834, 0.31331512, 0.31340179, 0.3134883, 0.31357476, 0.31366107, 0.31374729, 0.31383333, 0.31391931, 0.31400514, 0.31409085, 0.31417644, 0.31426194, 0.31434733, 0.31443256, 0.31451771, 0.3146027, 0.31468761, 0.3147724, 0.31485704, 0.31494159, 0.31502602, 0.31511033, 0.31519452, 0.31527859, 0.31536254, 0.31544638, 0.31553009, 0.31561369, 0.31569719, 0.31578055, 0.31586376, 0.31594691, 0.31602994, 0.31611279, 0.31619558, 0.31627825, 0.31636077, 0.31644318, 0.31652549, 0.31660768, 0.31668973, 0.31677169, 0.31685355, 0.31693524, 0.31701684, 0.31709832, 0.31717968, 0.31726092, 0.31734201, 0.31742305, 0.31750393, 0.31758469, 0.31766537, 0.31774589, 0.3178263, 0.31790659, 0.31798679, 0.31806684, 0.3181468, 0.31822661, 0.31830633, 0.3183859, 0.31846538, 0.31854475, 0.31862396, 0.31870309, 0.31878209, 0.31886098, 0.31893975, 0.31901839, 0.31909692, 0.31917533, 0.31925362, 0.31933179, 0.31940985, 0.31948778, 0.31956565, 0.31964332, 0.31972092, 0.31979835, 0.31987572, 0.31995296, 0.32003006, 0.32010707, 0.32018396, 0.3202607, 0.32033736, 0.32041386, 0.32049027, 0.32056656, 0.32064274, 0.3207188, 0.32079473, 0.32087055, 0.32094625, 0.32102183, 0.32109728, 0.32117265, 0.32124788, 0.32132295, 0.32139796, 0.32147285, 0.3215476, 0.32162222, 0.32169673, 0.32177114, 0.32184544, 0.32191959, 0.32199365, 0.32206759, 0.32214141, 0.32221508, 0.32228866, 0.32236212, 0.32243547, 0.32250866, 0.3225818, 0.32265478, 0.32272765, 0.3228004, 0.32287303, 0.32294556, 0.32301793, 0.32309023, 0.32316238, 0.32323444, 0.32330635, 0.32337815, 0.32344985, 0.32352141, 0.32359287, 0.32366422, 0.32373545, 0.32380652, 0.32387751, 0.32394838, 0.3240191, 0.32408974, 0.32416025, 0.32423064, 0.32430092, 0.3243711, 0.32444113, 0.32451102, 0.32458085, 0.32465053, 0.32472008, 0.32478958, 0.32485887, 0.3249281, 0.32499719, 0.32506618, 0.32513505, 0.32520378, 0.32527241, 0.3253409, 0.32540929, 0.32547757, 0.3255457, 0.32561374, 0.32568166, 0.32574946, 0.32581714, 0.32588473, 0.32595217, 0.32601947, 0.3260867, 0.32615378, 0.32622075, 0.3262876, 0.32635438, 0.32642096, 0.32648748, 0.32655385, 0.3266201, 0.32668623, 0.32675231, 0.3268182, 0.326884, 0.32694969, 0.32701522, 0.32708067, 0.32714599, 0.3272112, 0.32727629, 0.32734126, 0.32740611, 0.32747084, 0.32753545, 0.32759997, 0.32766435, 0.3277286, 0.32779273, 0.32785678, 0.32792068, 0.32798445, 0.32804814, 0.32811168, 0.32817513, 0.32823843, 0.32830167, 0.32836473, 0.32842767, 0.32849053, 0.32855326, 0.32861587, 0.32867837, 0.32874075, 0.328803, 0.32886514, 0.32892716, 0.32898906, 0.32905084, 0.3291125, 0.32917407, 0.32923546, 0.3292968, 0.32935801, 0.32941908, 0.32948005, 0.32954088, 0.32960162, 0.3296622, 0.3297227, 0.32978308, 0.32984331, 0.32990345, 0.32996348, 0.33002335, 0.33008316, 0.33014283, 0.33020234, 0.33026177, 0.33032107, 0.33038026, 0.33043936, 0.33049828, 0.33055714, 0.33061588, 0.33067447, 0.33073297, 0.33079132, 0.33084956, 0.33090767, 0.3309657, 0.3310236, 0.33108136, 0.33113903, 0.33119658, 0.33125401, 0.33131132, 0.33136848, 0.33142555, 0.3314825, 0.33153936, 0.33159608, 0.33165264, 0.33170915, 0.3317655, 0.33182174, 0.33187786, 0.33193386, 0.33198977, 0.33204553, 0.3321012, 0.33215672, 0.33221212, 0.33226743, 0.33232263, 0.33237764, 0.33243263, 0.33248743, 0.33254218, 0.33259675, 0.33265123, 0.33270559, 0.3327598, 0.33281395, 0.33286792, 0.33292183, 0.3329756, 0.33302924, 0.33308277, 0.3331362, 0.33318946, 0.33324268, 0.3332957, 0.33334866, 0.33340147, 0.33345419, 0.33350676, 0.33355924, 0.33361161, 0.33366382, 0.33371595, 0.33376795, 0.33381984, 0.3338716, 0.33392325, 0.33397475, 0.33402619, 0.33407748, 0.33412865, 0.33417967, 0.33423063, 0.33428141, 0.33433214, 0.33438274, 0.3344332, 0.33448356, 0.33453375, 0.33458388, 0.33463386, 0.33468375, 0.33473352, 0.33478311, 0.33483267, 0.33488208, 0.33493134, 0.33498052, 0.33502957, 0.33507848, 0.33512732, 0.33517602, 0.3352246, 0.33527306, 0.3353214, 0.33536962, 0.33541772, 0.3354657, 0.33551359, 0.33556134, 0.33560899, 0.33565649, 0.33570391, 0.33575118, 0.33579832, 0.33584538, 0.33589232, 0.33593914, 0.33598581, 0.33603239, 0.33607882, 0.3361252, 0.33617139, 0.33621749, 0.33626348, 0.33630934, 0.33635509, 0.33640072, 0.33644626, 0.33649164, 0.33653691, 0.33658209, 0.33662713, 0.33667204, 0.33671686, 0.33676153, 0.33680487, 0.33684677, 0.33688852, 0.33693019, 0.33697173, 0.33701316, 0.33705446, 0.33709568, 0.33713678, 0.33717775, 0.33721864, 0.33725938, 0.33730003, 0.33734056, 0.33738101, 0.3374213, 0.3374615, 0.33750162, 0.33754158, 0.33758146, 0.33762121, 0.33766085, 0.33770037, 0.3377398, 0.3377791, 0.33781829, 0.3378574, 0.33789635, 0.33793521, 0.33797395, 0.33801261, 0.33805111, 0.33808953, 0.33812785, 0.33816603, 0.33820409, 0.33824208, 0.3382799, 0.33831763, 0.3383553, 0.33839282, 0.33843023, 0.33846751, 0.33850473, 0.33854178, 0.33857873, 0.3386156, 0.33865231, 0.33868897, 0.33872548, 0.3387619, 0.33879814, 0.33883435, 0.33887041, 0.33890635, 0.3389422, 0.33897796, 0.33901358, 0.33904907, 0.33908445, 0.33911973, 0.3391549, 0.33918998, 0.3392249, 0.33925974, 0.33929446, 0.33932909, 0.3393636, 0.339398, 0.33943227, 0.33946645, 0.33950052, 0.33953443, 0.33956826, 0.33960199, 0.33963558, 0.33966911, 0.33970249, 0.33973575, 0.33976892, 0.33980197, 0.3398349, 0.33986774, 0.33990043, 0.33993307, 0.33996555, 0.33999792, 0.34003019, 0.34006235, 0.34009439, 0.34012634, 0.34015813, 0.34018987, 0.34022143, 0.34025294, 0.34028432, 0.34031558, 0.34034672, 0.34037778, 0.34040871, 0.3404395, 0.34047019, 0.3405008, 0.34053126, 0.34056163, 0.34059191, 0.34062204, 0.34065211, 0.340682, 0.34071183, 0.34074152, 0.34077108, 0.34080058, 0.34082994, 0.3408592, 0.34088832, 0.34091732, 0.34094629, 0.34097508, 0.34100378, 0.34103233, 0.34106082, 0.34108916, 0.34111741, 0.34114555, 0.34117359, 0.34120148, 0.34122926, 0.34125698, 0.34128454, 0.34131202, 0.34133935, 0.34136659, 0.34139371, 0.34142074, 0.34144765, 0.34147444, 0.34150115, 0.3415277, 0.34155416, 0.34158051, 0.34160671, 0.34163284, 0.34165886, 0.34168476, 0.34171054, 0.34173623, 0.34176177, 0.34178725, 0.34181255, 0.34183779, 0.34186292, 0.34188792, 0.34191281, 0.3419376, 0.34196225, 0.34198684, 0.34201127, 0.34203559, 0.34205985, 0.34208393, 0.34210792, 0.34213182, 0.34215561, 0.34217927, 0.34220284, 0.34222627, 0.34224957, 0.34227282, 0.34229591, 0.34231889, 0.34234178, 0.34236455, 0.34238723, 0.34240976, 0.3424322, 0.34245449, 0.34247673, 0.34249884, 0.34252083, 0.34254268, 0.34256446, 0.34258613, 0.34260765, 0.3426291, 0.34265038, 0.3426716, 0.3426927, 0.34271371, 0.34273455, 0.34275532, 0.34277597, 0.3427965, 0.34281695, 0.34283724, 0.34285742, 0.34287751, 0.3428975, 0.34291735, 0.34293711