// Class: ReadRuleFit
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : RuleFit::RuleFit
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:54:40 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "True" [Print method-specific help message]
GDTau: "-1.000000e+00" [Gradient-directed (GD) path: default fit cut-off]
GDTauPrec: "1.000000e-02" [GD path: precision of tau]
GDStep: "1.000000e-02" [GD path: step size]
GDNSteps: "10000" [GD path: number of steps]
GDErrScale: "1.020000e+00" [Stop scan when error > scale*errmin]
fEventsMin: "1.000000e-02" [Minimum fraction of events in a splittable node]
fEventsMax: "5.000000e-01" [Maximum fraction of events in a splittable node]
nTrees: "20" [Number of trees in forest.]
RuleMinDist: "1.000000e-03" [Minimum distance between rules]
MinImp: "1.000000e-03" [Minimum rule importance accepted]
Model: "modrulelinear" [Model to be used]
RuleFitModule: "rftmva" [Which RuleFit module to use]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
LinQuantile: "2.500000e-02" [Quantile of linear terms (removes outliers)]
GDPathEveFrac: "5.000000e-01" [Fraction of events used for the path search]
GDValidEveFrac: "5.000000e-01" [Fraction of events used for the validation]
ForestType: "adaboost" [Method to use for forest generation (AdaBoost or RandomForest)]
RFWorkDir: "./rulefit" [Friedman's RuleFit module (RFF): working dir]
RFNrules: "2000" [RFF: Mximum number of rules]
RFNendnodes: "4" [RFF: Average number of end nodes]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.33803939819,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.25508260727,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.2777428627,4.64297914505]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-5.6007027626,4.67435789108]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.91655540466,8.7030172348]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.874833107,13.0545253754]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadRuleFit : public IClassifierReader {

 public:

   // constructor
   ReadRuleFit( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadRuleFit" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadRuleFit() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   // not implemented for class: "ReadRuleFit"
};
void   ReadRuleFit::Initialize(){}
void   ReadRuleFit::Clear(){}
double ReadRuleFit::GetMvaValue__( const std::vector<double>& inputValues ) const {
   double rval=9.468034304;
   //
   // here follows all rules ordered in importance (most important first)
   // at the end of each line, the relative importance of the rule is given
   //
   if ((-0.70781672<inputValues[3])) rval+=-2.091079549;   // importance = 0.429
   if ((inputValues[2]<-0.08117419481)) rval+=-1.576325233;   // importance = 0.368
   if ((-0.08117419481<inputValues[2])) rval+=-1.442072296;   // importance = 0.336
   if ((-0.8769411445<inputValues[2])&&(0.2707604766<inputValues[3])) rval+=-1.260829168;   // importance = 0.293
   if ((inputValues[0]<2.827044487)&&(-1.668748856<inputValues[2])) rval+=-1.795034421;   // importance = 0.271
   if ((inputValues[0]<1.45515871)&&(inputValues[3]<0.2707604766)) rval+=-1.024584403;   // importance = 0.239
   if ((inputValues[3]<-0.70781672)) rval+=-0.9273179807;   // importance = 0.190
   if ((inputValues[2]<0.2560286522)&&(inputValues[3]<-0.70781672)) rval+=-0.9273179807;   // importance = 0.190
   if ((inputValues[0]<-2.849994659)) rval+=-1.532530451;   // importance = 0.169
   if ((-2.849994659<inputValues[0])&&(inputValues[0]<2.677224874)) rval+=-1.091577898;   // importance = 0.161
   if ((inputValues[1]<-0.4801481068)) rval+=-0.7241598431;   // importance = 0.156
   if ((-0.8270149231<inputValues[1])) rval+=-0.8220294808;   // importance = 0.156
   if ((-1.288185716<inputValues[0])&&(-0.8270149231<inputValues[1])) rval+=0.6224654513;   // importance = 0.143
   if ((-2.849994659<inputValues[0])&&(inputValues[0]<2.677224874)&&(inputValues[3]<1.365207195)) rval+=-0.7262142926;   // importance = 0.142
   if ((-1.227983475<inputValues[0])) rval+=-0.6233421574;   // importance = 0.126
   if ((inputValues[0]<2.827044487)&&(inputValues[2]<-1.668748856)&&(inputValues[3]<1.055167794)) rval+=-0.9595582911;   // importance = 0.115
   if ((inputValues[0]<2.827044487)&&(inputValues[2]<-1.668748856)) rval+=-0.9595582911;   // importance = 0.115
   if ((-0.4801481068<inputValues[1])&&(inputValues[2]<1.026640177)&&(inputValues[3]<0.1015381813)) rval+=-0.4813952666;   // importance = 0.106
   if ((-0.4832004011<inputValues[0])&&(-1.173881769<inputValues[1])&&(inputValues[1]<0.333245039)&&(inputValues[3]<0.3934768736)) rval+=0.6412101521;   // importance = 0.082
   if ((-2.849994659<inputValues[0])&&(inputValues[0]<2.677224874)&&(-0.8270149231<inputValues[1])&&(0.639572084<inputValues[2])&&(1.365207195<inputValues[3])) rval+=-0.5241224191;   // importance = 0.065
   if ((-1.173881769<inputValues[1])&&(inputValues[3]<0.7600490451)) rval+=-0.2753584246;   // importance = 0.063
   if ((0.1851498783<inputValues[0])&&(inputValues[1]<0.560452342)) rval+=-0.287826213;   // importance = 0.062
   if ((inputValues[0]<0.402831614)&&(-0.8270149231<inputValues[1])) rval+=0.2529612326;   // importance = 0.059
   if ((-2.849994659<inputValues[0])&&(inputValues[0]<2.677224874)&&(-0.8270149231<inputValues[1])&&(1.365207195<inputValues[3])) rval+=-0.4020894256;   // importance = 0.054
   if ((-0.4832004011<inputValues[0])&&(-1.173881769<inputValues[1])&&(0.3934768736<inputValues[3])) rval+=-0.1649581607;   // importance = 0.037
   if ((-0.4832004011<inputValues[0])&&(-1.173881769<inputValues[1])&&(inputValues[3]<0.3934768736)) rval+=-0.2097252133;   // importance = 0.036
   if ((inputValues[0]<0.39402771)&&(inputValues[1]<-0.07898536325)) rval+=-0.1711831296;   // importance = 0.036
   if ((-0.4832004011<inputValues[0])&&(inputValues[0]<1.440462112)&&(-1.173881769<inputValues[1])&&(inputValues[3]<0.3934768736)) rval+=-0.2097252133;   // importance = 0.035
   if ((inputValues[1]<-0.4801481068)&&(0.7600490451<inputValues[3])) rval+=0.2628324415;   // importance = 0.035
   if ((inputValues[1]<0.4341939986)&&(inputValues[3]<0.2707604766)) rval+=-0.1536235098;   // importance = 0.034
   if ((1.255346656<inputValues[1])&&(inputValues[1]<1.667604685)) rval+=0.2576251168;   // importance = 0.031
   if ((inputValues[2]<-0.08117419481)&&(-1.143110514<inputValues[3])) rval+=0.1298085529;   // importance = 0.028
   if ((inputValues[0]<-0.4832004011)&&(-1.173881769<inputValues[1])&&(inputValues[3]<-0.5545815229)) rval+=0.1237706907;   // importance = 0.025
   if ((-0.04954601452<inputValues[0])&&(inputValues[0]<0.4785142541)&&(0.6734923124<inputValues[3])) rval+=0.2769769595;   // importance = 0.020
   if ((-1.173881769<inputValues[1])&&(-1.03785038<inputValues[2])&&(0.7600490451<inputValues[3])) rval+=-0.09475895678;   // importance = 0.020
   if ((-1.173881769<inputValues[1])&&(0.7600490451<inputValues[3])) rval+=-0.09475895678;   // importance = 0.020
   if ((inputValues[0]<-0.4832004011)&&(-1.173881769<inputValues[1])&&(inputValues[1]<0.009230102412)&&(-0.5545815229<inputValues[3])) rval+=0.1850187744;   // importance = 0.019
   if ((inputValues[0]<-0.4832004011)&&(-1.173881769<inputValues[1])&&(-0.5545815229<inputValues[3])) rval+=-0.1192046981;   // importance = 0.018
   if ((inputValues[0]<-0.04954601452)&&(inputValues[1]<-0.4050141275)&&(-1.073310018<inputValues[3])) rval+=0.1165014314;   // importance = 0.017
   if ((1.255346656<inputValues[1])&&(inputValues[1]<1.667604685)&&(inputValues[2]<-0.00680893939)) rval+=0.184618271;   // importance = 0.017
   if ((inputValues[0]<1.878756404)&&(1.255346656<inputValues[1])&&(inputValues[1]<1.667604685)&&(inputValues[2]<-0.00680893939)) rval+=0.184618271;   // importance = 0.016
   if ((-0.04954601452<inputValues[0])&&(0.6734923124<inputValues[3])) rval+=-0.05217549148;   // importance = 0.011
   if ((0.01624130271<inputValues[1])&&(inputValues[1]<1.667604685)&&(-0.00680893939<inputValues[2])) rval+=-0.05902541412;   // importance = 0.011
   if ((0.6471375823<inputValues[0])&&(inputValues[0]<1.878756404)&&(1.255346656<inputValues[1])&&(inputValues[1]<1.667604685)&&(inputValues[2]<-0.00680893939)) rval+=-0.3327916655;   // importance = 0.010
   if ((-2.849994659<inputValues[0])&&(inputValues[0]<2.677224874)&&(-0.8270149231<inputValues[1])&&(inputValues[2]<0.639572084)&&(1.365207195<inputValues[3])) rval+=0.1220329935;   // importance = 0.007
   if ((1.20957303<inputValues[0])&&(inputValues[1]<0.4341939986)&&(inputValues[3]<0.2707604766)) rval+=-0.1511810893;   // importance = 0.005
   if ((-1.173881769<inputValues[1])&&(-1.03785038<inputValues[2])&&(inputValues[2]<-0.1674731225)&&(0.7600490451<inputValues[3])) rval+=-0.08947314749;   // importance = 0.004
   if ((-0.08117419481<inputValues[2])&&(inputValues[2]<1.270822406)) rval+=-0.01472221915;   // importance = 0.003
   if ((-1.61920917<inputValues[0])&&(inputValues[0]<2.827044487)&&(inputValues[1]<0.2844472229)&&(inputValues[2]<-1.668748856)&&(0.05907710269<inputValues[3])) rval+=-0.1511810893;   // importance = 0.003
   if ((inputValues[0]<2.827044487)&&(inputValues[1]<0.2844472229)&&(inputValues[2]<-1.668748856)&&(0.05907710269<inputValues[3])) rval+=-0.1511810893;   // importance = 0.003
   if ((-0.7362146974<inputValues[0])&&(inputValues[0]<2.827044487)&&(inputValues[2]<-1.668748856)&&(0.05907710269<inputValues[3])) rval+=-0.1511810893;   // importance = 0.003
   if ((-2.849994659<inputValues[0])&&(inputValues[0]<2.677224874)&&(inputValues[1]<-0.8270149231)&&(1.365207195<inputValues[3])) rval+=0.03672581977;   // importance = 0.002
   //
   // here follows all linear terms
   // at the end of each line, the relative importance of the term is given
   //
   rval+=-0.6337562808*std::min( double(3.274564505), std::max( double(inputValues[0]), double(-3.351432562)));   // importance = 0.472
   rval+=-0.4487935322*std::min( double(2.157360792), std::max( double(inputValues[1]), double(-2.052939415)));   // importance = 0.209
   rval+=-0.2809793072*std::min( double(1.966724753), std::max( double(inputValues[2]), double(-2.075380087)));   // importance = 0.129
   rval+=1.84962748*std::min( double(2.508529902), std::max( double(inputValues[3]), double(-2.35084939)));   // importance = 1.000
   return rval;
}
inline double ReadRuleFit::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
