// Class: ReadBDTG
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:55:26 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 4000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "1000" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
MinNodeSize: "5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-3.65916013718,3.26447582245]
var2                          var2                          var2                          Variable 2                                                      'F'    [-3.68905711174,3.78774046898]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-4.57268333435,4.56402540207]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-4.84856987,5.04116535187]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTGNode

#ifndef BDTGNode__def
#define BDTGNode__def

class BDTGNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTGNode ( BDTGNode* left,BDTGNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTGNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTGNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTGNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTGNode*   fLeft;     // pointer to the left daughter node
   BDTGNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTGNode::~BDTGNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTGNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTGNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG : public IClassifierReader {

 public:

   // constructor
   ReadBDTG( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   std::vector<double> GetMulticlassValues__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTGNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

std::vector<double> ReadBDTG::GetMulticlassValues__( const std::vector<double>& inputValues ) const
{
   uint nClasses = 4;
   std::vector<double> fMulticlassReturnVal;
   fMulticlassReturnVal.reserve(nClasses);

   std::vector<double> temp(nClasses);
   auto forestSize = fForest.size();
   // trees 0, nClasses, 2*nClasses, ... belong to class 0
   // trees 1, nClasses+1, 2*nClasses+1, ... belong to class 1 and so forth
   uint classOfTree = 0;
   for (uint itree = 0; itree < forestSize; ++itree) {
      BDTGNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTGNode*)current->GetRight();
         else current=(BDTGNode*)current->GetLeft();
      }
      temp[classOfTree] += current->GetResponse();
      if (++classOfTree == nClasses) classOfTree = 0; // cheap modulo
   }

   // we want to calculate sum of exp(temp[j] - temp[i]) for all i,j (i!=j)
   // first calculate exp(), then replace minus with division.
   std::transform(temp.begin(), temp.end(), temp.begin(), [](double d){return exp(d);});

   for(uint iClass=0; iClass<nClasses; iClass++){
      double norm = 0.0;
      for(uint j=0;j<nClasses;j++){
         if(iClass!=j)
            norm += temp[j] / temp[iClass];
      }
      fMulticlassReturnVal.push_back(1.0/(1.0+norm));
   }

   return fMulticlassReturnVal;
}
void ReadBDTG::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178947,-0.0284211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0902439) , 
1, 0.50809, 1, 0, 0.128854,-0.121146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41203,0.064812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830189,0.232075) , 
3, 1.92871, 1, 0, 0.46952,0.21952) , 
3, 0.371425, 1, 0, 0.257859,0.00785855)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337403,0.0349612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257075,0.00283019) , 
3, -0.314986, 1, 0, 0.311698,-0.126226) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0288462,-0.0884615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15025,-0.0398998) , 
2, -0.475893, 1, 0, 0.13229,0.222262) , 
3, 0.436997, 1, 0, 0.249507,-0.00542406)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270169,0.00806754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37581,0.050324) , 
1, -0.121454, 1, 0, 0.319277,-0.148594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135266,-0.0458937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217949,-0.0128205) , 
1, 1.14557, 1, 0, 0.167161,0.149604) , 
3, -0.112181, 1, 0, 0.242651,0.00161933)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244521,-0.00219146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189744,-0.0241026) , 
3, -0.339196, 1, 0, 0.227526,-0.113166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,-0.0304348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402353,0.0609412) , 
1, 0.815475, 1, 0, 0.308011,0.229282) , 
3, 0.414913, 1, 0, 0.256941,0.0119889)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172749,-0.0284416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0304114,-0.085365) , 
1, -0.312563, 1, 0, 0.0907217,-0.147395) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372203,0.0440625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790323,0.182263) , 
3, 1.85501, 1, 0, 0.425488,0.162154) , 
3, -0.112181, 1, 0, 0.258363,0.00761843)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374803,0.0460886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275,0.00699395) , 
0, -0.251813, 1, 0, 0.32987,-0.131579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155039,-0.0366571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118143,-0.0492055) , 
1, 0.785042, 1, 0, 0.134727,0.169913) , 
3, 0.108015, 1, 0, 0.246528,-0.00281685)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323741,0.0270321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280618,0.0116606) , 
3, -0.885863, 1, 0, 0.297781,-0.0901902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0990588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126068,-0.0464656) , 
2, 0.0294952, 1, 0, 0.103873,0.240756) , 
3, 0.702073, 1, 0, 0.24173,0.00547261)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0484115,-0.0802957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433155,0.0738409) , 
1, 0.081299, 1, 0, 0.225041,-0.111931) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24,-0.00359499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366667,0.0421458) , 
1, 1.14262, 1, 0, 0.299291,0.180167) , 
3, 0.414913, 1, 0, 0.252205,-0.00506591)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.0700272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266487,0.00604574) , 
3, -0.543371, 1, 0, 0.161755,-0.0762349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216418,-0.0246771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593496,0.107894) , 
2, 0.292709, 1, 0, 0.493042,0.201033) , 
3, 0.802707, 1, 0, 0.243842,-0.0075326)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357052,0.0345466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273585,0.00730164) , 
3, -0.408377, 1, 0, 0.327828,-0.107272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159509,-0.0309472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0926366,-0.0560541) , 
1, 0.90081, 1, 0, 0.121821,0.166682) , 
3, 0.331768, 1, 0, 0.249234,-0.0027552)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271272,0.00675405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242593,-0.00232476) , 
1, 0.863356, 1, 0, 0.262305,-0.0338372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0930233,-0.05801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0616438,-0.0680693) , 
3, 1.81161, 1, 0, 0.0763636,0.350365) , 
3, 1.38245, 1, 0, 0.236763,0.0189378)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19859,-0.0186227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223022,-0.011197) , 
3, -0.289703, 1, 0, 0.206625,-0.105256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161585,-0.0350551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373134,0.041101) , 
1, 1.06882, 1, 0, 0.268477,0.210963) , 
3, 0.471159, 1, 0, 0.227861,0.0033161)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0719823,-0.0634934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,0.0126085) , 
3, -0.227752, 1, 0, 0.0997151,-0.117856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535934,0.0912028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301848,0.00339965) , 
1, 0.872282, 1, 0, 0.418891,0.128774) , 
3, 0.000826949, 1, 0, 0.253083,0.000652876)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335878,0.0206046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290909,0.00746625) , 
0, -0.529333, 1, 0, 0.312849,-0.108018) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218487,-0.00745157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130769,-0.0369615) , 
1, 0.844635, 1, 0, 0.172691,0.0890334) , 
3, -0.0530968, 1, 0, 0.245411,-0.0132048)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,0.0407218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289157,0.0114803) , 
0, 0.290385, 1, 0, 0.346939,-0.110762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0403727,-0.0809459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175355,-0.0197757) , 
1, 0.701961, 1, 0, 0.116935,0.150219) , 
3, 0.331768, 1, 0, 0.26003,-0.0121487)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0453074,-0.0797105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342222,0.0394266) , 
0, -0.867997, 1, 0, 0.248984,-0.121188) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123832,-0.0473046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,0.0348227) , 
1, 0.785042, 1, 0, 0.251337,0.144203) , 
3, -0.0682472, 1, 0, 0.25013,0.00811937)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158371,-0.0239841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0308989,-0.0848723) , 
0, 0.269894, 1, 0, 0.121774,-0.0948025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606557,0.0944298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284848,-0.00705154) , 
1, 1.06882, 1, 0, 0.454023,0.136281) , 
3, 0.414599, 1, 0, 0.241219,-0.0117272)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316877,0.0158352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234043,-0.00914953) , 
0, 0.151201, 1, 0, 0.289799,-0.081452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990415,-0.0539087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0412242) , 
1, 0.90122, 1, 0, 0.105783,0.139793) , 
3, 0.471159, 1, 0, 0.224663,-0.00313813)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338137,0.0261933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29717,0.0125703) , 
1, 0.57597, 1, 0, 0.325038,-0.0774062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0959405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137476,-0.0341231) , 
2, -0.149209, 1, 0, 0.113354,0.159439) , 
3, 0.436997, 1, 0, 0.255838,1.92004e-05)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0531136,-0.0742671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376389,0.047908) , 
1, -0.186835, 1, 0, 0.236967,-0.0810494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184066,-0.0201086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428947,0.0539314) , 
1, 0.996955, 1, 0, 0.30914,0.135703) , 
3, 0.356305, 1, 0, 0.263682,-0.000818754)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203163,-0.00213414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0335196,-0.0817501) , 
0, -0.00769512, 1, 0, 0.13613,-0.0752161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621547,0.0868732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,0.0137984) , 
1, 1.10362, 1, 0, 0.491924,0.158907) , 
3, 0.478331, 1, 0, 0.254902,0.00293971)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33563,0.0236872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261194,0.00507288) , 
0, 0.243402, 1, 0, 0.309923,-0.0832091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0230769,-0.0840023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142487,-0.0248477) , 
2, 0.275862, 1, 0, 0.112403,0.166546) , 
3, 0.802707, 1, 0, 0.260638,-0.0208911)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335443,0.0199228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184662,-0.020804) , 
3, -0.436093, 1, 0, 0.251544,-0.029683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0545455,-0.0647118) , 
3, 1.74551, 1, 0, 0.234841,0.00621853)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0766332,-0.0638645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553648,0.104531) , 
1, 0.422467, 1, 0, 0.252773,-0.0860292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138158,-0.0363798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366822,0.0270569) , 
1, 0.808479, 1, 0, 0.271858,0.125051) , 
3, 0.356305, 1, 0, 0.259779,-0.00854155)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0292276,-0.078654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106742,-0.0382004) , 
3, -1.05891, 1, 0, 0.0622755,-0.124873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516279,0.0749668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256281,-0.0109705) , 
1, 0.786563, 1, 0, 0.391304,0.0934229) , 
3, -0.435343, 1, 0, 0.259027,0.00566303)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362195,0.0260953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196411,-0.0125817) , 
3, -0.437949, 1, 0, 0.270982,-0.0408963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0348837,-0.0735822) , 
3, 1.74551, 1, 0, 0.250627,-0.010051)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338255,0.0193871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226135,-0.00284819) , 
3, -0.531538, 1, 0, 0.27193,-0.0400513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0552486,-0.0621758) , 
3, 1.67914, 1, 0, 0.252369,-0.00580231)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249307,0.00993747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241042,-0.00387367) , 
3, -1.2309, 1, 0, 0.244103,-0.107582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152455,-0.0279662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350548,0.022331) , 
1, 0.583004, 1, 0, 0.275828,0.101015) , 
3, -0.112181, 1, 0, 0.26037,-0.000625181)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193548,0.00350048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0504648,-0.065226) , 
0, -1.31179, 1, 0, 0.0748899,-0.10332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56681,0.076059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274168,-0.00753984) , 
1, 0.585691, 1, 0, 0.398174,0.0824153) , 
3, -0.280496, 1, 0, 0.251623,-0.00178226)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325883,0.0225984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0791667,-0.063671) , 
1, 1.17822, 1, 0, 0.262453,-0.0439382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0808081,-0.0490541) , 
3, 1.55602, 1, 0, 0.245036,-0.0166521)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346764,0.0242606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304556,0.012542) , 
0, 0.124395, 1, 0, 0.332524,-0.0880605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0930524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.013197) , 
2, -0.322084, 1, 0, 0.143662,0.134404) , 
3, 0.414913, 1, 0, 0.263618,-0.00689419)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220917,-0.00725521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276316,0.00700693) , 
3, -0.340326, 1, 0, 0.251697,-0.0278325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916667,-0.0682228) , 
3, 1.83453, 1, 0, 0.24226,-0.00191222)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194753,-0.00280855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0579399,-0.0738155) , 
0, 0.259177, 1, 0, 0.150995,-0.0567425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416279,0.0202645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787402,0.120566) , 
3, 1.84127, 1, 0, 0.500898,0.134178) , 
3, 0.702073, 1, 0, 0.247766,-0.00394075)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35217,0.0251067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123845,-0.0475147) , 
1, 0.660444, 1, 0, 0.27154,-0.0400893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0380952,-0.0723691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112069,-0.0331198) , 
2, 0.378601, 1, 0, 0.0949227,0.155352) , 
3, 0.893281, 1, 0, 0.231234,0.00451263)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333669,0.0189075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29927,0.0125101) , 
0, 0.289115, 1, 0, 0.323592,-0.0604652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0914179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127273,-0.0297216) , 
2, -0.033015, 1, 0, 0.10311,0.110357) , 
3, 0.591507, 1, 0, 0.256703,-0.00864183)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108215,-0.0477494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56072,0.0877729) , 
1, 0.801165, 1, 0, 0.264356,-0.0335504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113475,-0.0592399) , 
3, 1.76176, 1, 0, 0.254098,-0.011237)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215,0.00657264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0871212,-0.0631691) , 
0, 0.199932, 1, 0, 0.170812,-0.0400665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22807,-0.042351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631579,0.0746617) , 
2, 0.275862, 1, 0, 0.538462,0.149719) , 
3, 0.824791, 1, 0, 0.260633,0.00630046)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377422,0.0365664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108911,-0.045754) , 
1, 0.863356, 1, 0, 0.28667,-0.0378205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0497512,-0.0616817) , 
3, 1.57074, 1, 0, 0.262788,-0.00558599)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295094,0.00856721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226923,-0.00853985) , 
0, 0.87343, 1, 0, 0.284326,-0.033233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100457,-0.0399323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0743802,-0.0461572) , 
3, 1.84086, 1, 0, 0.0911765,0.167827) , 
3, 1.12905, 1, 0, 0.251259,0.00118812)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223602,-0.0122902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546219,0.127585) , 
0, 1.13684, 1, 0, 0.265152,-0.0322959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154472,-0.038744) , 
3, 1.76176, 1, 0, 0.258245,-0.01135)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245734,0.00827096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110811,-0.0692703) , 
0, 0.858919, 1, 0, 0.218529,-0.0203314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788618,0.0917719) , 
3, 1.92601, 1, 0, 0.254341,-8.44676e-05)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36204,0.0272411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691824,-0.0623419) , 
1, 0.99493, 1, 0, 0.278542,-0.0325342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0829268,-0.0449239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0825688,-0.0356021) , 
3, 1.87717, 1, 0, 0.0828025,0.171807) , 
3, 1.29216, 1, 0, 0.247609,-0.000242774)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413428,0.0381793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288546,-0.00393463) , 
0, -0.894606, 1, 0, 0.336499,-0.109839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129676,-0.0468077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238889,0.0136313) , 
1, 0.210607, 1, 0, 0.205227,0.050444) , 
3, -0.610112, 1, 0, 0.252699,-0.00751886)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0880121,-0.0557719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137931,-0.0377818) , 
3, -0.364179, 1, 0, 0.113122,0.0412291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641283,0.100457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305785,0.00645387) , 
3, 1.67958, 1, 0, 0.575806,-0.107204) , 
1, 1.0791, 1, 0, 0.260534,-0.00606203)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159624,-0.00906992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0279232,-0.0733687) , 
1, -0.906039, 1, 0, 0.0636132,-0.0986727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469248,0.0692248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314839,-0.00657761) , 
0, 0.0820385, 1, 0, 0.370675,0.0546949) , 
3, -0.462334, 1, 0, 0.25,-0.00557855)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413223,0.0270206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328358,0.00737356) , 
0, -1.30513, 1, 0, 0.350877,-0.127734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272321,-0.00840411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201937,-0.00723382) , 
1, -0.512346, 1, 0, 0.212005,0.0343226) , 
3, -1.04915, 1, 0, 0.243323,-0.00222433)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365079,0.0189463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350078,0.0179174) , 
0, -1.14828, 1, 0, 0.353511,-0.0878937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857788,-0.0598396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244706,0.0182001) , 
1, 0.366441, 1, 0, 0.190255,0.05664) , 
3, -0.462334, 1, 0, 0.253893,0.000299837)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0563003,-0.066988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356822,0.0410587) , 
0, -0.790152, 1, 0, 0.249038,-0.0837431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238853,-0.016222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254054,0.00219537) , 
0, 0.857503, 1, 0, 0.244489,0.0900583) , 
3, -0.0237104, 1, 0, 0.246811,0.00136672)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284112,0.0186481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141207,-0.0432424) , 
1, 0.529246, 1, 0, 0.223905,-0.0178863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87156,0.109285) , 
3, 1.92037, 1, 0, 0.259959,0.0030801)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418689,0.0355786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16476,-0.0245926) , 
1, 0.1243, 1, 0, 0.287986,-0.0380188) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,-0.0618814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108247,-0.0232361) , 
2, 0.888457, 1, 0, 0.0835913,0.153613) , 
3, 1.22047, 1, 0, 0.255319,-0.00739194)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317039,0.00555774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31087,0.0102982) , 
0, -0.161333, 1, 0, 0.314626,-0.055069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112648,-0.0409679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180371,0.000239874) , 
0, 0.732248, 1, 0, 0.141563,0.0973742) , 
3, 0.108015, 1, 0, 0.240408,0.0103061)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00823045,-0.0890276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262537,0.00380707) , 
0, -1.03979, 1, 0, 0.213492,-0.0626539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268519,-0.0045003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232258,-0.0102589) , 
0, 0.840978, 1, 0, 0.253369,0.0936247) , 
3, 0.356305, 1, 0, 0.228272,-0.00473246)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0957447,-0.0371183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497496,0.0509155) , 
3, -0.364179, 1, 0, 0.287192,0.0342839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0639432,-0.0677602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0284277) , 
3, 1.38148, 1, 0, 0.159501,-0.092742) , 
1, 0.940933, 1, 0, 0.240647,-0.0120183)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345992,0.0173614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11094,-0.0363287) , 
1, 0.798076, 1, 0, 0.262814,-0.0220931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,-0.0560567) , 
3, 1.73078, 1, 0, 0.248599,-0.00432853)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295699,0.000763336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327935,0.0162275) , 
1, 0.228601, 1, 0, 0.308562,-0.0568119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0905145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164577,-0.00887455) , 
2, -0.317479, 1, 0, 0.138158,0.103986) , 
3, 0.331768, 1, 0, 0.243744,0.00435246)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140236,-0.0338831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364729,0.035533) , 
0, -0.111652, 1, 0, 0.229002,-0.0592013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.866667,0.184881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18408,-0.0323681) , 
2, -0.197427, 1, 0, 0.285311,0.0889) , 
3, 0.414913, 1, 0, 0.249239,-0.00597503)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144928,-0.0111731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0228311,-0.0753869) , 
0, -0.392656, 1, 0, 0.0868621,-0.0700668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564639,0.060387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263048,-0.0162915) , 
1, 0.983147, 1, 0, 0.420896,0.0736518) , 
3, -0.139172, 1, 0, 0.261163,0.00492659)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495652,0.0466348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26301,-0.014401) , 
1, -1.01739, 1, 0, 0.319872,-0.0634432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225049,-0.0075879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138138,-0.0128012) , 
1, 0.593026, 1, 0, 0.175871,0.0664624) , 
3, -0.280496, 1, 0, 0.239849,0.00874702)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39759,0.0257976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289796,-0.00309719) , 
0, -1.05097, 1, 0, 0.317073,-0.0684109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125948,-0.0335308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232295,0.0195975) , 
1, 1.22177, 1, 0, 0.163043,0.0580783) , 
3, -0.151872, 1, 0, 0.238978,-0.00427909)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0755509,-0.05634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0953757,-0.0463172) , 
3, 0.178242, 1, 0, 0.0808314,0.0438332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561208,0.0656175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318627,0.00669683) , 
3, 1.40654, 1, 0, 0.501801,-0.0707267) , 
1, 0.767416, 1, 0, 0.24531,-0.000926828)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266998,0.00843543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122542,-0.0428849) , 
1, 0.813541, 1, 0, 0.215854,-0.0201745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.858586,0.091361) , 
3, 1.91802, 1, 0, 0.24822,-0.00444961)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638298,0.0863173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289286,-0.00795803) , 
1, -1.01739, 1, 0, 0.377005,-0.0815401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112811,-0.0459966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223577,0.0153468) , 
0, 0.189927, 1, 0, 0.177637,0.0352871) , 
3, -0.551853, 1, 0, 0.251867,-0.00821055)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383663,0.0219579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128954,-0.0430446) , 
3, -0.742105, 1, 0, 0.255215,0.0537544) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286631,0.0168811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114754,-0.0221364) , 
3, 1.34326, 1, 0, 0.25106,-0.0591059) , 
1, 0.0962332, 1, 0, 0.252758,-0.0129769)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203168,-0.0200826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526882,0.0972701) , 
0, 0.811019, 1, 0, 0.269189,-0.0371976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141844,-0.0377472) , 
3, 1.74551, 1, 0, 0.260051,-0.0166368)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,0.00196146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714286,-0.0656113) , 
0, 0.289115, 1, 0, 0.157432,-0.0415684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217742,-0.0436672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589947,0.0469554) , 
2, 0.292709, 1, 0, 0.498008,0.0779818) , 
3, 0.802707, 1, 0, 0.243693,-0.0112887)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385475,0.0154691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301782,0.00706696) , 
0, -0.790152, 1, 0, 0.325637,-0.0488055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0844749,-0.0439598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176895,0.0127307) , 
0, 0.860719, 1, 0, 0.12028,0.103529) , 
3, 0.356305, 1, 0, 0.251142,0.00645524)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477124,0.047377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334333,0.00805483) , 
0, -1.14659, 1, 0, 0.360976,-0.0887772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110565,-0.0408178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236111,0.016046) , 
1, 0.366441, 1, 0, 0.193495,0.0273015) , 
3, -0.435343, 1, 0, 0.261516,-0.0198429)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217848,0.0116377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260355,0.0126265) , 
3, -1.19187, 1, 0, 0.23783,-0.0926181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116822,-0.033743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264706,-0.00793533) , 
1, -0.250596, 1, 0, 0.240399,0.0470174) , 
3, -0.578844, 1, 0, 0.239485,-0.00265996)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215686,0.00823759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0462777,-0.0751451) , 
0, 0.243402, 1, 0, 0.160185,-0.0369058) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274194,-0.0257686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614084,0.0530994) , 
2, 0.275862, 1, 0, 0.526096,0.101799) , 
3, 0.802707, 1, 0, 0.247996,-0.00361953)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334197,0.0173391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248447,-0.00640175) , 
0, 0.597113, 1, 0, 0.315541,-0.0388591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533808,-0.0557934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16318,0.0123782) , 
0, 0.977148, 1, 0, 0.103846,0.0700143) , 
3, 0.802707, 1, 0, 0.2605,-0.010552)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227273,-0.0297041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399232,0.0265245) , 
1, -1.01739, 1, 0, 0.355811,-0.0870393) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199229,-0.0107599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,0.00421738) , 
0, 0.729549, 1, 0, 0.194215,0.0532306) , 
3, -0.580667, 1, 0, 0.253277,0.00196257)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0874786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348485,0.0508375) , 
0, -1.19764, 1, 0, 0.247845,-0.119788) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234131,-0.012705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294521,0.0125788) , 
0, 0.570868, 1, 0, 0.256958,0.0184356) , 
3, -1.08105, 1, 0, 0.254853,-0.0134887)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0897487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0639386,-0.045828) , 
3, -1.88631, 1, 0, 0.0469925,-0.094946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368345,0.0462607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265918,-0.0185503) , 
0, 0.22287, 1, 0, 0.313503,0.0261533) , 
3, -0.976372, 1, 0, 0.24359,-0.0056144)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310121,0.0083601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241379,-0.00822659) , 
0, 0.799602, 1, 0, 0.297049,-0.0396456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0503597,-0.0600294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116022,-0.0100455) , 
2, 0.322878, 1, 0, 0.0978044,0.103778) , 
3, 0.832675, 1, 0, 0.247779,-0.0041791)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289898,0.00680254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217617,-0.00190881) , 
0, 0.75123, 1, 0, 0.273973,-0.0328996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0879487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12037,-0.012429) , 
2, 1.23077, 1, 0, 0.0616114,0.164374) , 
3, 1.55602, 1, 0, 0.251146,-0.011695)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.064275,-0.0562661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459075,0.0489138) , 
1, 0.092515, 1, 0, 0.244517,-0.0574718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.77451,0.134881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177706,-0.0352239) , 
2, -0.336733, 1, 0, 0.262136,0.0612862) , 
3, 0.356305, 1, 0, 0.251025,-0.0136068)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224112,0.0029177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127315,-0.0593331) , 
0, 0.759116, 1, 0, 0.200673,-0.0283938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.762963,0.0709733) , 
3, 1.74459, 1, 0, 0.240229,-0.0106832)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491765,0.0384426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241195,-0.0102582) , 
1, -0.513925, 1, 0, 0.319383,-0.043422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0941884,-0.0333084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172093,0.0118381) , 
0, 1.18421, 1, 0, 0.117647,0.0695069) , 
3, 0.436997, 1, 0, 0.25,-0.00458228)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41129,0.0276112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194175,-0.0425183) , 
1, 0.0153917, 1, 0, 0.347578,-0.113384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162304,-0.0492034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222529,-0.000583111) , 
0, -0.843497, 1, 0, 0.215507,0.0329498) , 
3, -1.33958, 1, 0, 0.238813,0.00712622)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.005,-0.0837725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40339,0.0606125) , 
0, -0.962955, 1, 0, 0.242424,-0.0881054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138996,-0.0194892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302676,0.00512054) , 
1, -0.339721, 1, 0, 0.27354,0.0255756) , 
3, -0.973894, 1, 0, 0.265641,-0.00328186)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195604,0.0105338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0591195,-0.0558717) , 
1, -0.341064, 1, 0, 0.1088,-0.0519394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617284,0.0496486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327586,-0.00426634) , 
1, 0.923889, 1, 0, 0.472256,0.0710899) , 
3, 0.297184, 1, 0, 0.251819,-0.00352754)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423773,0.0245358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355828,0.00985692) , 
3, -1.24596, 1, 0, 0.403636,-0.0893241) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,-0.00570156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195307,-0.00247568) , 
1, -0.696864, 1, 0, 0.207177,0.0351725) , 
3, -0.871513, 1, 0, 0.260483,0.00139198)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278196,-0.0120059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362989,0.0189709) , 
1, -0.417711, 1, 0, 0.327784,-0.0671249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122291,-0.0306092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228235,0.0161976) , 
1, 1.14113, 1, 0, 0.164332,0.0421636) , 
3, -0.176954, 1, 0, 0.241634,-0.00952256)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00995025,-0.0809451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331288,0.0367932) , 
1, -0.984839, 1, 0, 0.237681,-0.0774914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101721,-0.0444682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378671,0.00798396) , 
1, 0.717924, 1, 0, 0.241058,0.0330785) , 
3, -0.610112, 1, 0, 0.239879,-0.00553144)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218931,0.0034545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0898876,-0.0663777) , 
0, 0.662508, 1, 0, 0.187534,-0.0285174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623853,0.0511156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737864,0.0479004) , 
0, 1.19923, 1, 0, 0.679245,0.152194) , 
3, 1.57074, 1, 0, 0.238609,-0.00974681)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57193,0.0527925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227348,-0.0231907) , 
1, -0.691095, 1, 0, 0.337444,-0.0531514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222857,-0.0102012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115057,-0.022966) , 
1, 0.354143, 1, 0, 0.150854,0.0460834) , 
3, -0.277105, 1, 0, 0.236382,0.000596522)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372995,0.019733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147854,-0.0261944) , 
3, -0.271208, 1, 0, 0.270153,0.0264596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210145,-0.00502419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994152,-0.0202085) , 
3, 1.42959, 1, 0, 0.177778,-0.0919709) , 
0, 0.696888, 1, 0, 0.24261,-0.00885223)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0344828,-0.0616316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433962,0.0762606) , 
1, -0.454614, 1, 0, 0.185714,-0.123838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0858896,-0.0490435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289172,0.00794669) , 
0, -0.895189, 1, 0, 0.270052,0.0112319) , 
3, -1.51764, 1, 0, 0.258321,-0.00755573)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104037,-0.0242965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493056,0.0413466) , 
3, -0.395221, 1, 0, 0.287705,0.033854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10951,-0.0452559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737864,0.0448412) , 
3, 1.82623, 1, 0, 0.190715,-0.060343) , 
1, 0.767416, 1, 0, 0.24938,-0.00336714)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377005,0.0110093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332248,0.00701084) , 
3, -1.18309, 1, 0, 0.356828,-0.0765972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134058,-0.0372958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212,0.00655769) , 
0, -0.299746, 1, 0, 0.195141,0.0230407) , 
3, -0.580667, 1, 0, 0.251405,-0.0116314)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190698,-0.0397874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369661,0.0177799) , 
1, -0.948041, 1, 0, 0.326622,-0.0719734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0702703,-0.0588752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200869,0.00445534) , 
1, -0.223304, 1, 0, 0.179024,0.0474888) , 
3, -0.305034, 1, 0, 0.245,-0.00591078)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875796,-0.0457887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12982,-0.036039) , 
3, -0.563648, 1, 0, 0.110953,0.0229025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634831,0.0692363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219298,-0.0135321) , 
3, 1.68156, 1, 0, 0.561728,-0.086197) , 
1, 1.02693, 1, 0, 0.253165,-0.0115164)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195122,0.020919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0546164,-0.0541108) , 
0, -0.976274, 1, 0, 0.0886699,-0.0538719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558989,0.0406273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289831,-0.0133804) , 
1, 0.593026, 1, 0, 0.39112,0.0246785) , 
3, -0.0237104, 1, 0, 0.234574,-0.0159786)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426003,0.0185132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162011,-0.0251913) , 
1, 0.216245, 1, 0, 0.313492,-0.0427405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0564516,-0.0545582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0989583,-0.0269953) , 
2, -0.200007, 1, 0, 0.0914286,0.0985179) , 
3, 0.440469, 1, 0, 0.234184,0.00770895)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315287,0.0153789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249471,0.00870854) , 
0, 0.576099, 1, 0, 0.297282,-0.0321749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0737705,-0.0436063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0578512,-0.0414461) , 
3, 1.83143, 1, 0, 0.0658436,0.119204) , 
3, 1.36188, 1, 0, 0.268763,-0.0135212)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227273,0.0183941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227273,-0.00412193) , 
3, -1.18443, 1, 0, 0.227273,-0.0834457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28442,0.0021014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234681,-0.0158934) , 
0, 0.163166, 1, 0, 0.255497,0.0439786) , 
3, -0.580667, 1, 0, 0.245477,-0.0012586)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207237,0.022231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0794492,-0.0443834) , 
0, -0.867997, 1, 0, 0.110577,-0.044769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990099,-0.0731096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555916,0.0384897) , 
2, -0.339484, 1, 0, 0.491643,0.0698571) , 
3, 0.356305, 1, 0, 0.249746,-0.00290658)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.663793,0.0658497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301124,-0.0071296) , 
1, -1.35126, 1, 0, 0.376114,-0.0769349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293333,-0.00903804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172158,-0.00315136) , 
1, -0.203775, 1, 0, 0.196169,0.020151) , 
3, -0.900958, 1, 0, 0.244819,-0.00609726)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364296,0.0133652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189394,-0.0105423) , 
3, -0.533572, 1, 0, 0.270763,0.0221531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190625,-0.0200113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140704,0.0130047) , 
3, 1.08356, 1, 0, 0.171484,-0.0798712) , 
0, 0.813325, 1, 0, 0.245,-0.00432225)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0642978,-0.047498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356632,0.0187804) , 
1, -0.201174, 1, 0, 0.263243,-0.00946371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0901445) , 
3, 1.99526, 1, 0, 0.249232,0.0030892)    );
  // itree = 100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813648,-0.0309835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425445,0.0394764) , 
3, -0.334141, 1, 0, 0.249833,0.0270553) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0326531,-0.0897054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495098,-0.010294) , 
3, 1.08427, 1, 0, 0.242762,-0.109342) , 
0, 0.944261, 1, 0, 0.248198,-0.00448039)    );
  // itree = 101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363467,0.0179781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147849,-0.0308514) , 
0, 0.900791, 1, 0, 0.307958,0.0205916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0765432,-0.0425244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0753425,-0.021868) , 
3, 1.41057, 1, 0, 0.076225,-0.08139) , 
1, 1.13826, 1, 0, 0.243988,-0.00756061)    );
  // itree = 102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10061,-0.0749177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434231,0.0407455) , 
2, -0.838721, 1, 0, 0.320125,-0.0399134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121908,-0.0341242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215054,0.0278708) , 
0, 0.6884, 1, 0, 0.163919,0.0521349) , 
3, -0.112181, 1, 0, 0.239196,0.00777594)    );
  // itree = 103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0468384,-0.0553549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364407,0.0263436) , 
1, -0.362366, 1, 0, 0.231072,-0.041175) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284866,-0.00512051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246933,-0.010069) , 
0, 0.113928, 1, 0, 0.259858,0.0611031) , 
3, -0.127334, 1, 0, 0.245264,0.00925023)    );
  // itree = 104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0361757,-0.0608865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344673,0.0341711) , 
3, -1.07187, 1, 0, 0.265293,0.0349283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0471014,-0.083891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629412,0.0225439) , 
3, 1.25332, 1, 0, 0.269058,-0.0792159) , 
0, 0.900791, 1, 0, 0.266154,0.00882145)    );
  // itree = 105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431232,0.0162073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182628,-0.0235873) , 
3, -0.226556, 1, 0, 0.333915,0.0494937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141145,-0.0126092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0904255,-0.0086407) , 
3, 1.4084, 1, 0, 0.13099,-0.0498534) , 
1, 0.583399, 1, 0, 0.24257,0.00477324)    );
  // itree = 106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358575,0.0141799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125997,-0.0278521) , 
3, -0.0905164, 1, 0, 0.262951,0.0363349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220183,-0.00455095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112426,-0.00637743) , 
3, 1.38828, 1, 0, 0.183468,-0.0807966) , 
0, 0.834197, 1, 0, 0.243444,0.00758815)    );
  // itree = 107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0707317,-0.0436775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105474,-0.0371638) , 
3, -0.969901, 1, 0, 0.0931838,0.0418319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518167,0.0345986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284974,0.00552058) , 
3, 1.3813, 1, 0, 0.46368,-0.0478308) , 
1, 0.670673, 1, 0, 0.247355,0.0045214)    );
  // itree = 108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0694006,-0.039172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436364,0.0650449) , 
3, -1.00565, 1, 0, 0.256569,0.0495651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138023,-0.0370907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62963,0.0317541) , 
3, 1.34918, 1, 0, 0.233309,-0.0393994) , 
1, -0.187201, 1, 0, 0.240686,-0.0111837)    );
  // itree = 109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365079,0.00995626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304927,0.00758203) , 
0, -0.430397, 1, 0, 0.330804,-0.0430657) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826923,-0.0333402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216216,0.0498077) , 
0, 1.25535, 1, 0, 0.11773,0.036892) , 
3, 0.371425, 1, 0, 0.25655,-0.0152011)    );
  // itree = 110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334913,0.0141659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122,-0.0193524) , 
3, 0.500807, 1, 0, 0.274632,0.00669474) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192857,-0.0209658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226087,0.0761772) , 
3, 1.25349, 1, 0, 0.207843,-0.120192) , 
0, 1.26376, 1, 0, 0.266205,-0.00931527)    );
  // itree = 111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0519031,-0.0466084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313452,0.0132613) , 
1, -0.745534, 1, 0, 0.243268,-0.0410509) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135,-0.0178632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37961,0.00231292) , 
1, 0.815475, 1, 0, 0.26597,0.0412913) , 
3, 0.130099, 1, 0, 0.253354,-0.00446855)    );
  // itree = 112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306973,0.0333092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137131,-0.035032) , 
1, 1.14086, 1, 0, 0.258182,0.0294109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0532787,-0.0798757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550388,-0.0173453) , 
3, 1.41401, 1, 0, 0.225201,-0.112715) , 
0, 1.07303, 1, 0, 0.252101,0.00320587)    );
  // itree = 113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404531,0.0153454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186983,-0.00716447) , 
3, -0.706049, 1, 0, 0.271753,0.0426842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,-0.0331431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140741,0.0294388) , 
3, 1.44946, 1, 0, 0.161616,-0.111889) , 
0, 1.01723, 1, 0, 0.249748,0.0118008)    );
  // itree = 114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423792,0.033368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305389,-0.00868706) , 
3, -1.44573, 1, 0, 0.37844,-0.0805571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104762,-0.0714893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216988,-7.67582e-05) , 
0, -0.917883, 1, 0, 0.209163,0.0189408) , 
3, -1.08105, 1, 0, 0.247168,-0.00339751)    );
  // itree = 115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0102708,-0.0869809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618962,0.0589566) , 
1, 1.029, 1, 0, 0.219018,0.00932167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586667,0.103152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0151506) , 
3, 1.38165, 1, 0, 0.42735,-0.0886222) , 
0, 1.01723, 1, 0, 0.255931,-0.00803235)    );
  // itree = 116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298651,0.0233747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169492,-0.0661927) , 
0, 1.06608, 1, 0, 0.274725,0.0128252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0802139,-0.0532761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72449,0.0396916) , 
3, 1.82916, 1, 0, 0.176024,-0.0627338) , 
1, 1.01701, 1, 0, 0.241076,-0.0129345)    );
  // itree = 117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508333,0.014416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30064,-0.0100882) , 
3, -1.99356, 1, 0, 0.342954,-0.0600889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277311,-0.0078372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154749,-0.00101786) , 
1, 0.185608, 1, 0, 0.196037,0.0346406) , 
3, -0.871513, 1, 0, 0.239261,0.00677063)    );
  // itree = 118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.0135725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199465,-0.00533118) , 
3, -0.63839, 1, 0, 0.275888,0.0257653) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178261,-0.0225425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0848485,-0.0249168) , 
3, 1.54646, 1, 0, 0.1536,-0.0714343) , 
0, 0.6269, 1, 0, 0.236653,-0.00542039)    );
  // itree = 119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0896706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323457,0.0467359) , 
0, 0.52664, 1, 0, 0.102344,0.0208417) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619247,0.0475543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321429,0.0122934) , 
3, 1.38148, 1, 0, 0.541796,-0.0634004) , 
1, 0.939437, 1, 0, 0.24974,-0.00741394)    );
  // itree = 120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153765,-0.00615828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587196,0.0395611) , 
3, 0.178242, 1, 0, 0.294413,0.0304604) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533333,-0.0584652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534884,0.0144918) , 
3, 1.32662, 1, 0, 0.186495,-0.0546439) , 
1, 1.13826, 1, 0, 0.26115,0.00422902)    );
  // itree = 121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666667,0.0556997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274962,-0.0107977) , 
1, -1.0542, 1, 0, 0.366313,-0.0461741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229391,-0.0120684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128954,-0.00867708) , 
1, 0.0813332, 1, 0, 0.154405,0.034863) , 
3, -0.343942, 1, 0, 0.246667,-0.000419311)    );
  // itree = 122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370752,0.0189966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112754,-0.028822) , 
3, 0.135946, 1, 0, 0.278439,0.024759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204268,-0.00298051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.00684644) , 
3, 1.59531, 1, 0, 0.177528,-0.100224) , 
0, 0.900791, 1, 0, 0.255493,-0.00366079)    );
  // itree = 123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0207469,-0.0631732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319249,0.0285297) , 
1, -0.841372, 1, 0, 0.2375,-0.0440136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271003,-0.00922035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242898,-0.0170922) , 
0, 0.0754209, 1, 0, 0.252563,0.0319812) , 
3, -0.36221, 1, 0, 0.245776,-0.00226122)    );
  // itree = 124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219839,0.0223363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105332,-0.0493661) , 
0, -0.25398, 1, 0, 0.161716,-0.0255731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241935,-0.0371844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615012,0.0348089) , 
2, 0.275862, 1, 0, 0.528864,0.0541887) , 
3, 0.802707, 1, 0, 0.257797,-0.00469975)    );
  // itree = 125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402913,-0.00427832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216028,-0.0276287) , 
3, -1.41071, 1, 0, 0.294118,0.0552497) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273431,0.00634001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0725806,-0.0283736) , 
3, 1.03687, 1, 0, 0.224756,-0.0283333) , 
0, -0.691888, 1, 0, 0.241617,-0.00801454)    );
  // itree = 126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160494,-0.0475826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337,0.00831702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126021,-0.0164598) , 
3, 0.196496, 1, 0, 0.239634,-0.0189837) , 
1, -1.23776, 1, 0, 0.233284,-0.00808448)    );
  // itree = 127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185535,0.00169012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228621,-0.0222595) , 
3, -0.730586, 1, 0, 0.213244,0.011516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.698413,0.166813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186916,-0.0323846) , 
1, 0.464314, 1, 0, 0.463519,-0.104508) , 
0, 1.32631, 1, 0, 0.242184,-0.0019002)    );
  // itree = 128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154286,0.0114596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0500677,-0.0509752) , 
1, -1.05542, 1, 0, 0.0700219,-0.0522349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629167,0.0693787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34937,-0.00470915) , 
1, 0.0010035, 1, 0, 0.409703,0.0342071) , 
3, -0.245873, 1, 0, 0.256537,-0.0047707)    );
  // itree = 129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378947,0.0109962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15361,-0.00925165) , 
3, -0.268078, 1, 0, 0.281541,0.0193951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228495,-0.00510115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135593,0.0261436) , 
3, 1.41401, 1, 0, 0.198543,-0.0782248) , 
0, 0.759972, 1, 0, 0.259367,-0.0066844)    );
  // itree = 130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44843,0.0366626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225225,-0.0265685) , 
1, -0.0524885, 1, 0, 0.374251,-0.0896811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238889,-0.0250065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21671,-0.00121849) , 
0, -0.843497, 1, 0, 0.219042,0.0196858) , 
3, -1.40089, 1, 0, 0.244379,0.0018322)    );
  // itree = 131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.088809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295511,0.0219902) , 
0, -1.31179, 1, 0, 0.243577,-0.0492384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278049,-0.00527996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247458,-0.017486) , 
0, 0.268653, 1, 0, 0.26,0.0402831) , 
3, -0.207485, 1, 0, 0.251901,-0.00386512)    );
  // itree = 132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1375,0.000500175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0232558,-0.064248) , 
0, -1.19824, 1, 0, 0.0502959,-0.0554643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389126,0.0308365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298701,-0.0334298) , 
0, 0.864065, 1, 0, 0.362812,0.0289321) , 
3, -0.718083, 1, 0, 0.257129,0.000391832)    );
  // itree = 133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462857,0.0129797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360913,0.0101676) , 
0, -1.33441, 1, 0, 0.381279,-0.0477332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994318,-0.0359977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226257,0.02632) , 
0, 0.0754209, 1, 0, 0.184457,0.0241551) , 
3, -0.36221, 1, 0, 0.273148,-0.00823902)    );
  // itree = 134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539267,0.0543703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201117,-0.0349386) , 
3, -1.32754, 1, 0, 0.375676,0.0751823) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264045,0.000615927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100478,-0.0189743) , 
3, 0.950883, 1, 0, 0.222957,-0.0200804) , 
0, -0.863316, 1, 0, 0.250737,-0.00275142)    );
  // itree = 135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158713,-0.0236154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26584,-0.0148469) , 
3, -0.155467, 1, 0, 0.206515,0.0203013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.587549,0.0806658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148387,-0.00926448) , 
3, 1.38828, 1, 0, 0.42233,-0.0965003) , 
0, 0.944261, 1, 0, 0.250123,-0.00329964)    );
  // itree = 136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178683,-0.00252196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720833,0.0440026) , 
3, 0.54378, 1, 0, 0.287385,0.0225941) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102817,-0.0423594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756757,0.0393378) , 
3, 1.82623, 1, 0, 0.19123,-0.0479688) , 
1, 0.807077, 1, 0, 0.248266,-0.00611356)    );
  // itree = 137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42268,-0.00179244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204586,-0.0247262) , 
3, -1.63846, 1, 0, 0.260184,0.0337106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281139,0.00958714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133971,0.0143012) , 
3, 0.827586, 1, 0, 0.232355,-0.0428274) , 
0, -0.293879, 1, 0, 0.242829,-0.0140216)    );
  // itree = 138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252598,-0.0150005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545455,0.115998) , 
2, 0.697661, 1, 0, 0.316906,-0.0244095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0869502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118841,-0.00382208) , 
2, 0.377094, 1, 0, 0.0854167,0.0580999) , 
3, 0.853537, 1, 0, 0.263562,-0.00539626)    );
  // itree = 139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0802247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,0.0562568) , 
3, -2.00821, 1, 0, 0.219373,-0.0801174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129032,-0.0032243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30312,0.00205662) , 
1, -0.425837, 1, 0, 0.273231,0.0188445) , 
3, -1.33958, 1, 0, 0.263664,0.00126573)    );
  // itree = 140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304603,0.034981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112903,-0.0387501) , 
1, 1.14086, 1, 0, 0.25341,0.033039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875576,-0.0637054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628141,0.0189404) , 
3, 1.31867, 1, 0, 0.257504,-0.0588539) , 
0, 0.57508, 1, 0, 0.254689,0.00432815)    );
  // itree = 141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36618,0.007122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13783,-0.00965678) , 
3, -0.200461, 1, 0, 0.262633,0.0123834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188854,-0.0116707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119403,0.00633116) , 
3, 1.38148, 1, 0, 0.16849,-0.0614112) , 
0, 0.900791, 1, 0, 0.240694,-0.004814)    );
  // itree = 142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423469,0.0169438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,-0.0350496) , 
3, -0.977713, 1, 0, 0.342193,0.0826245) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242105,-0.000295199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173442,0.000346932) , 
0, 1.00531, 1, 0, 0.226309,-0.0308643) , 
0, -0.972742, 1, 0, 0.244619,-0.0129325)    );
  // itree = 143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00608519,-0.0877055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661017,0.0640124) , 
1, 1.08675, 1, 0, 0.218107,0.00469185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435897,0.0349784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450777,0.0640299) , 
0, 1.35697, 1, 0, 0.441584,-0.0855904) , 
0, 0.759972, 1, 0, 0.275599,-0.0185341)    );
  // itree = 144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0510638,-0.0472681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369863,0.0329286) , 
3, -0.888861, 1, 0, 0.245,0.0214902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140351,-0.0439359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744186,0.0375204) , 
3, 1.73696, 1, 0, 0.243386,-0.0502242) , 
0, 0.301989, 1, 0, 0.244376,-0.00622762)    );
  // itree = 145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404639,0.0153867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323529,-0.00652349) , 
3, -1.18984, 1, 0, 0.383588,-0.0650887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234375,-0.000183142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213102,0.00514507) , 
0, -0.680403, 1, 0, 0.215901,0.0139635) , 
3, -0.90214, 1, 0, 0.260212,-0.0069257)    );
  // itree = 146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296572,-0.00581959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,0.0249459) , 
1, 0.0263458, 1, 0, 0.330727,-0.037099) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0929648,-0.0303379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180851,0.0305191) , 
0, 0.8676, 1, 0, 0.129412,0.0383141) , 
3, 0.414913, 1, 0, 0.260847,-0.0109219)    );
  // itree = 147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125253,-0.0159319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22376,-0.0181241) , 
3, -0.913399, 1, 0, 0.187959,0.0250144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442786,0.0300406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19685,-0.0147449) , 
3, 1.08337, 1, 0, 0.347561,-0.0559415) , 
0, 0.57508, 1, 0, 0.239841,-0.0013023)    );
  // itree = 148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134021,0.00219137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.031746,-0.0642946) , 
2, -0.146606, 1, 0, 0.09375,-0.0303228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516432,0.0393745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360697,-0.0170706) , 
0, 0.843471, 1, 0, 0.456292,0.0486183) , 
3, -0.112181, 1, 0, 0.282359,0.0107455)    );
  // itree = 149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343949,-0.0218384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343066,-0.00145577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188058,-0.00629755) , 
3, -0.866363, 1, 0, 0.222163,-0.0037825) , 
0, -1.35128, 1, 0, 0.231605,0.00799774)    );
  // itree = 150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341176,-0.000509822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110345,-0.0550478) , 
3, -1.15249, 1, 0, 0.218349,0.0702565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359442,0.0265918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102662,-0.019879) , 
3, 0.67389, 1, 0, 0.266804,-0.0265796) , 
1, -0.327527, 1, 0, 0.25362,-0.000231257)    );
  // itree = 151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0125,-0.0644606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.035461,-0.0561677) , 
3, -1.20563, 1, 0, 0.0232558,0.104357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296571,0.00756114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286424,-0.0103957) , 
3, 0.604952, 1, 0, 0.292929,-0.00910213) , 
1, -0.840753, 1, 0, 0.252016,0.0081112)    );
  // itree = 152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224425,0.00507517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12037,-0.0541896) , 
0, 0.487188, 1, 0, 0.193226,-0.0226826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73224,0.0324406) , 
3, 1.74551, 1, 0, 0.242944,-0.0119676)    );
  // itree = 153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417219,0.00900413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22796,0.000781549) , 
3, -0.563648, 1, 0, 0.309728,0.0179317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0862944,-0.0272661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0657277,-0.034999) , 
2, 1.19286, 1, 0, 0.0790774,-0.0680773) , 
1, 1.05738, 1, 0, 0.2399,-0.00810691)    );
  // itree = 154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366292,0.00596939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,-0.0409836) , 
3, -0.743648, 1, 0, 0.24239,0.0301406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291391,0.014579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.076,-0.0239788) , 
3, 1.44094, 1, 0, 0.24481,-0.0407256) , 
1, 0.227361, 1, 0, 0.243759,-0.00995795)    );
  // itree = 155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0352113,-0.0497816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0902367,-0.0358296) , 
3, -1.33416, 1, 0, 0.0739583,0.0141936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443054,0.0189886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268939,0.00300011) , 
3, 1.27335, 1, 0, 0.399812,-0.045555) , 
1, 0.259956, 1, 0, 0.24518,-0.0172018)    );
  // itree = 156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0209059,-0.0693608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307355,0.0241308) , 
3, -1.41669, 1, 0, 0.238731,0.0157613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0803738,-0.0582173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565574,0.00932649) , 
3, 1.27427, 1, 0, 0.232349,-0.0555189) , 
0, 0.30526, 1, 0, 0.236216,-0.0123254)    );
  // itree = 157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548523,0.0242967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404255,0.0140477) , 
3, -1.11042, 1, 0, 0.470135,0.0421412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199176,-0.0208607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160811,0.0175052) , 
3, 0.215079, 1, 0, 0.179837,-0.0259158) , 
1, -0.418323, 1, 0, 0.255662,-0.00813944)    );
  // itree = 158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386768,0.0134915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175063,-0.00540746) , 
3, -0.356224, 1, 0, 0.28038,0.0179134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149826,-0.0217233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264151,0.0529308) , 
1, 0.905359, 1, 0, 0.190583,-0.0827693) , 
0, 0.900791, 1, 0, 0.260612,-0.00425072)    );
  // itree = 159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0789645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298969,0.0397724) , 
3, -1.98138, 1, 0, 0.231076,-0.0672053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213568,-0.0118388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274194,-0.00652384) , 
0, -0.308546, 1, 0, 0.258256,0.00188017) , 
3, -1.08105, 1, 0, 0.251488,-0.0153227)    );
  // itree = 160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0671642,-0.0352034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464684,0.0597118) , 
3, -0.923571, 1, 0, 0.266294,0.0474508) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107692,-0.0359863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478011,0.00998162) , 
3, 0.65682, 1, 0, 0.242847,-0.0256138) , 
1, -0.368349, 1, 0, 0.249239,-0.00569717)    );
  // itree = 161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46988,0.0231184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153153,-0.0342748) , 
3, -0.748397, 1, 0, 0.372222,0.0717934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351421,0.0192141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155738,0.00533673) , 
3, 0.156632, 1, 0, 0.248772,-0.0251748) , 
0, -0.805301, 1, 0, 0.271127,-0.00761521)    );
  // itree = 162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416,0.01143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299389,-0.00845553) , 
0, -0.87178, 1, 0, 0.338731,-0.0463689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826772,-0.0496808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191549,0.000446312) , 
1, -0.218181, 1, 0, 0.170584,0.0240708) , 
3, -0.578844, 1, 0, 0.231068,-0.00126701)    );
  // itree = 163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0812666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0330578,-0.0827087) , 
3, -1.26711, 1, 0, 0.0128205,0.0837853) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.0063259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279026,-0.000346711) , 
3, 0.755495, 1, 0, 0.283617,-0.0145046) , 
0, -1.02158, 1, 0, 0.241687,0.000714513)    );
  // itree = 164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0414013,-0.0503699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40613,0.0505989) , 
3, -1.16784, 1, 0, 0.269139,0.0457057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038961,-0.0620862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448097,0.00903974) , 
3, 0.430044, 1, 0, 0.250671,-0.0246285) , 
1, 0.162984, 1, 0, 0.258577,0.00547874)    );
  // itree = 165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478386,0.00557263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321799,0.00385203) , 
3, -1.02225, 1, 0, 0.380541,0.0412547) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16934,-0.0101944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125475,0.0101992) , 
3, 0.491928, 1, 0, 0.148114,-0.02418) , 
1, 0.269773, 1, 0, 0.25497,0.00590308)    );
  // itree = 166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402778,0.0239714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181467,-0.0249624) , 
3, -1.50801, 1, 0, 0.260546,0.066163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308855,0.0116359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227948,0.00103962) , 
1, 0.141048, 1, 0, 0.251244,-0.0265975) , 
1, -0.628404, 1, 0, 0.253108,-0.00800851)    );
  // itree = 167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111517,-0.0199936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278689,0.00475462) , 
3, -0.671955, 1, 0, 0.184805,0.024371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355155,0.0155089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253769,-0.014244) , 
3, 0.748548, 1, 0, 0.315164,-0.0393119) , 
0, -0.0324937, 1, 0, 0.251135,-0.00803243)    );
  // itree = 168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0641509,-0.0311329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410765,0.0424414) , 
3, -1.04872, 1, 0, 0.262136,0.0391612) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0957775,-0.0412656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542923,0.0176814) , 
3, 0.865541, 1, 0, 0.233238,-0.0279387) , 
1, -0.187201, 1, 0, 0.242079,-0.00741012)    );
  // itree = 169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642534,0.043541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314286,-0.0210342) , 
3, -1.0595, 1, 0, 0.482599,0.0735363) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227593,-0.00689874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112397,-0.0033486) , 
3, 0.604141, 1, 0, 0.18398,-0.0225909) , 
1, -0.537387, 1, 0, 0.247413,-0.00217153)    );
  // itree = 170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368039,0.00583974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292546,-0.00128678) , 
0, -0.637359, 1, 0, 0.320285,-0.0260568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127971,-0.0101802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208459,0.0296947) , 
1, 1.16852, 1, 0, 0.158314,0.0471802) , 
3, 0.108015, 1, 0, 0.249251,0.00606208)    );
  // itree = 171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00654308,-0.0834752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337325,0.0251637) , 
0, 0.482577, 1, 0, 0.123413,0.00600501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564356,0.027576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567404,0.03881) , 
1, 1.23228, 1, 0, 0.56689,-0.0615866) , 
1, 1.10301, 1, 0, 0.25496,-0.0140445)    );
  // itree = 172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0444444,-0.0473155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46281,0.136082) , 
3, -1.48419, 1, 0, 0.242188,0.0932495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0757764,-0.037812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427632,0.010469) , 
3, 0.0593154, 1, 0, 0.262667,-0.00907759) , 
0, -1.02158, 1, 0, 0.26001,0.00419952)    );
  // itree = 173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369947,0.0138477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134483,-0.0373183) , 
0, 1.01677, 1, 0, 0.322129,0.0156127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0431655,-0.0533007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0632318,-0.0379888) , 
2, -0.200713, 1, 0, 0.0583039,-0.0629374) , 
1, 1.10301, 1, 0, 0.247242,-0.00668386)    );
  // itree = 174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496241,0.0335496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261261,-0.0300615) , 
3, -1.62611, 1, 0, 0.389344,0.0828027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296402,-0.000642071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138852,-0.000591114) , 
3, 0.308814, 1, 0, 0.231025,-0.0209175) , 
0, -1.05347, 1, 0, 0.249878,-0.00856625)    );
  // itree = 175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127632,-0.0247507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34647,0.0151863) , 
0, -0.0466833, 1, 0, 0.224982,-0.0246376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274611,-0.00966566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238298,-0.00385238) , 
0, 1.03211, 1, 0, 0.26087,0.0603044) , 
3, 0.613245, 1, 0, 0.236181,0.00186941)    );
  // itree = 176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32493,0.0450203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169118,-0.0553364) , 
0, 0.944261, 1, 0, 0.3,0.0536171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.019685,-0.0702127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387889,-0.00308284) , 
3, 0.255126, 1, 0, 0.220733,-0.0365565) , 
1, 0.162984, 1, 0, 0.254952,0.00237067)    );
  // itree = 177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495413,0.00685887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214953,-0.0383136) , 
3, -1.66402, 1, 0, 0.356481,0.102129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345659,0.00222288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15757,-0.00744723) , 
3, -0.43043, 1, 0, 0.224118,-0.000748507) , 
0, -1.14631, 1, 0, 0.238602,0.0105086)    );
  // itree = 178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43956,0.0281165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.00580428) , 
3, -1.25024, 1, 0, 0.272324,0.0252468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222603,0.00399629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120482,0.0110726) , 
3, 1.4205, 1, 0, 0.18559,-0.0487611) , 
0, 0.900791, 1, 0, 0.252823,0.00860679)    );
  // itree = 179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0980253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254408,-0.00114803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298246,0.00187446) , 
3, 0.619174, 1, 0, 0.268597,-0.0119768) , 
0, -1.29224, 1, 0, 0.241327,0.00302242)    );
  // itree = 180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0968208,-0.0198933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578947,0.0398883) , 
3, -0.226556, 1, 0, 0.273144,0.0220334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00558659,-0.0915597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243451,-0.00726498) , 
2, -0.395212, 1, 0, 0.192029,-0.0345401) , 
1, 0.606823, 1, 0, 0.238145,-0.00237663)    );
  // itree = 181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447619,0.0337581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153199,-0.038781) , 
2, -0.0592513, 1, 0, 0.316027,-0.0213922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0737705,-0.0363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100193,-0.0116919) , 
2, -0.0304354, 1, 0, 0.0951638,0.0475465) , 
3, 0.521064, 1, 0, 0.244162,0.00103915)    );
  // itree = 182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255034,-0.0234574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.0666866) , 
3, -1.13554, 1, 0, 0.16041,0.0691983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297227,0.0164444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218085,0.00273376) , 
1, 1.14807, 1, 0, 0.271246,-0.0258032) , 
1, -0.87377, 1, 0, 0.255097,-0.0119616)    );
  // itree = 183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171975,-0.0128143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322884,-0.0076644) , 
2, 0.628441, 1, 0, 0.205924,-0.0100946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565517,0.0789627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140673,-0.0443755) , 
2, 0.623949, 1, 0, 0.271186,0.054529) , 
3, 0.802707, 1, 0, 0.222222,0.00604423)    );
  // itree = 184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0326486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467742,0.115033) , 
3, -1.62203, 1, 0, 0.253846,0.0934753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19773,-0.0173024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753521,0.0281423) , 
3, 1.74258, 1, 0, 0.241189,-0.0227331) , 
0, -1.05347, 1, 0, 0.242775,-0.00817907)    );
  // itree = 185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358209,-0.0292594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234234,-0.0303389) , 
3, -1.52116, 1, 0, 0.302041,0.118235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280255,0.00294361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103314,-0.00212129) , 
3, 0.783011, 1, 0, 0.228943,-0.0186421) , 
0, -1.05347, 1, 0, 0.237835,-0.00199124)    );
  // itree = 186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207071,-0.0209583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27781,0.00830205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0522388,-0.0365553) , 
3, 1.8644, 1, 0, 0.261637,-0.0233423) , 
1, -1.102, 1, 0, 0.25641,-0.0125268)    );
  // itree = 187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0788223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0357143,-0.0709024) , 
3, -1.42403, 1, 0, 0.0151515,0.0749528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267062,0.00928579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288462,-0.00632949) , 
3, 0.277136, 1, 0, 0.276021,-0.0212969) , 
0, -1.05347, 1, 0, 0.241638,-0.00861097)    );
  // itree = 188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240838,0.0604954) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182495,-0.0186258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65368,0.0207942) , 
3, 1.49665, 1, 0, 0.241585,-0.0210442) , 
0, -1.29224, 1, 0, 0.241515,-0.0105327)    );
  // itree = 189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360671,0.00823384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119737,-0.00779658) , 
1, 0.697188, 1, 0, 0.260775,0.00197189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174757,0.00865829) , 
0, 1.3944, 1, 0, 0.252084,-0.00831216)    );
  // itree = 190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27619,-0.0310256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504854,0.0433351) , 
2, -0.786685, 1, 0, 0.389423,0.0944978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259027,0.00515617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182292,-0.0127134) , 
1, 1.16801, 1, 0, 0.235135,-0.0227256) , 
0, -1.26434, 1, 0, 0.250729,-0.0108779)    );
  // itree = 191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0208333,-0.0413287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0702703,-0.0297432) , 
3, -1.39549, 1, 0, 0.0486322,0.0618378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274229,0.0068423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287938,-0.00663115) , 
3, 0.298302, 1, 0, 0.280524,-0.0225278) , 
1, -0.840753, 1, 0, 0.24253,-0.00870493)    );
  // itree = 192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0983607,-0.0103337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500795,0.0314216) , 
3, -0.388717, 1, 0, 0.293077,0.0316037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0618182,-0.0536383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678261,0.0168668) , 
3, 1.73696, 1, 0, 0.168421,-0.055119) , 
1, 1.01701, 1, 0, 0.250891,0.00225478)    );
  // itree = 193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534286,0.0195849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323741,0.00527508) , 
3, -1.03039, 1, 0, 0.405077,0.0309123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190909,0.0174853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104798,-0.0228365) , 
2, 0.0696759, 1, 0, 0.130125,-0.0339605) , 
1, 0.227361, 1, 0, 0.252959,-0.00497884)    );
  // itree = 194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351464,0.0125863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125234,-0.0111575) , 
3, 0.3925, 1, 0, 0.281503,-0.00339246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147059,-0.0206305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180451,0.0213275) , 
0, 1.4756, 1, 0, 0.165957,-0.0963254) , 
0, 1.28629, 1, 0, 0.267684,-0.0145066)    );
  // itree = 195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,0.000101573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0993976,-0.0246196) , 
3, -1.33416, 1, 0, 0.0903156,0.0335626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41042,0.0120979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0843988) , 
3, 1.93339, 1, 0, 0.373544,-0.0383361) , 
1, 0.162984, 1, 0, 0.250825,-0.00718336)    );
  // itree = 196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0912863,-0.0118675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45283,0.0354091) , 
3, -0.413963, 1, 0, 0.235,0.0256486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14245,-0.0397442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758333,0.0312414) , 
3, 1.68156, 1, 0, 0.23236,-0.0451561) , 
0, 0.297203, 1, 0, 0.233927,-0.00313547)    );
  // itree = 197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358932,0.0101599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0945274,-0.0228043) , 
3, 0.292664, 1, 0, 0.270405,-0.00482572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142157,-0.00570771) , 
0, 1.38197, 1, 0, 0.257357,-0.0175291)    );
  // itree = 198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29029,0.00308893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195965,-0.0186648) , 
1, 0.695697, 1, 0, 0.251624,0.023646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20614,-0.000374111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11215,0.00726315) , 
3, 1.57489, 1, 0, 0.176119,-0.104242) , 
0, 1.09727, 1, 0, 0.239152,0.0025205)    );
  // itree = 199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180822,-0.0143865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288288,-0.00873167) , 
3, 0.409676, 1, 0, 0.211826,0.0312398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491329,0.0356235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103774,-0.0138471) , 
3, 1.64522, 1, 0, 0.400442,-0.0672843) , 
0, 0.900791, 1, 0, 0.254646,0.0088727)    );
  // itree = 200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293413,0.0219516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133144,-0.0398923) , 
1, 1.30089, 1, 0, 0.256242,0.0167362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620155,-0.0695643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674797,0.00139803) , 
3, 1.53993, 1, 0, 0.259843,-0.0715035) , 
0, 1.01723, 1, 0, 0.256963,-0.000930325)    );
  // itree = 201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315994,-0.000694771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132701,-0.032582) , 
0, 1.26376, 1, 0, 0.290193,0.0261944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0394737,-0.0554128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.089172,-0.0113499) , 
1, 1.39275, 1, 0, 0.0682657,-0.0446089) , 
1, 1.2054, 1, 0, 0.231259,0.00739215)    );
  // itree = 202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293333,-0.0101685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113744,-0.0436156) , 
3, -1.08833, 1, 0, 0.206422,0.078557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25704,-0.000298597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164835,0.001624) , 
0, 1.2265, 1, 0, 0.241858,-0.0199845) , 
1, -0.621769, 1, 0, 0.234479,0.000533253)    );
  // itree = 203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0859633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256591,0.0249504) , 
0, -1.6578, 1, 0, 0.216939,-0.0387585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155388,0.00418653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30235,-0.0132573) , 
1, 0.146166, 1, 0, 0.258427,0.0234208) , 
3, -0.736148, 1, 0, 0.244522,0.00258081)    );
  // itree = 204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160952,-0.00299498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677489,0.0465165) , 
3, 0.434486, 1, 0, 0.318783,0.0350656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925926,-0.0462318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408805,-0.00089655) , 
2, 1.51519, 1, 0, 0.18622,-0.0477937) , 
1, 1.21354, 1, 0, 0.284041,0.0133499)    );
  // itree = 205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454118,0.0197987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149123,-0.014605) , 
3, 0.0352882, 1, 0, 0.347626,0.0256864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.0307275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0910747,-0.013161) , 
0, -0.508877, 1, 0, 0.0881935,-0.0485304) , 
1, 0.940933, 1, 0, 0.256844,-0.000283927)    );
  // itree = 206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396739,0.0130773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146809,-0.0320398) , 
3, -1.01241, 1, 0, 0.256563,0.0392865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376161,0.0216148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127737,-0.00601252) , 
3, 0.546007, 1, 0, 0.262144,-0.0374986) , 
1, 0.0962332, 1, 0, 0.259843,-0.0058323)    );
  // itree = 207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015,-0.055228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326203,0.0377396) , 
1, -0.948041, 1, 0, 0.244415,-0.0311401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0855856,-0.0405408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3309,-0.00824357) , 
1, 0.329439, 1, 0, 0.244866,0.0224968) , 
3, -0.555244, 1, 0, 0.244697,0.00235978)    );
  // itree = 208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261307,0.0530159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0951456,-0.0290112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461942,0.0071273) , 
3, 0.308814, 1, 0, 0.251116,-0.0142048) , 
0, -1.16999, 1, 0, 0.252135,-0.00417117)    );
  // itree = 209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35157,0.00784271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673317,-0.0268277) , 
3, 0.460871, 1, 0, 0.276385,0.00432553) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17847,-0.0162076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116505,0.037661) , 
3, 1.67958, 1, 0, 0.164474,-0.0702325) , 
0, 0.900791, 1, 0, 0.250507,-0.0129151)    );
  // itree = 210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273038,0.0016899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268503,0.00365715) , 
1, -0.187201, 1, 0, 0.270023,0.0117648) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,-0.0478224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156463,0.0268294) , 
3, 0.848925, 1, 0, 0.137184,-0.0925476) , 
0, 1.2265, 1, 0, 0.251852,-0.00250408)    );
  // itree = 211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0907696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292216,0.0100452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196262,-0.0184214) , 
0, 1.52688, 1, 0, 0.286438,-0.0112888) , 
0, -1.16999, 1, 0, 0.259959,-2.70996e-05)    );
  // itree = 212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15625,0.0211463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0314286,-0.0593256) , 
1, -0.723563, 1, 0, 0.0678138,-0.0357402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528571,0.0504562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360947,-0.00897103) , 
0, 0.113928, 1, 0, 0.418129,0.0297389) , 
3, -0.112181, 1, 0, 0.246276,-0.00238291)    );
  // itree = 213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37889,-0.000376339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142643,-0.00935076) , 
3, -0.406474, 1, 0, 0.266904,0.033854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252796,0.016966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813954,-0.00815255) , 
3, 1.38148, 1, 0, 0.20517,-0.0482192) , 
0, 0.6269, 1, 0, 0.248024,0.00875357)    );
  // itree = 214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,-0.0321901) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29614,0.00294406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894118,-0.0218123) , 
3, 0.935104, 1, 0, 0.248649,-0.015156) , 
1, -1.20023, 1, 0, 0.242095,-0.00377972)    );
  // itree = 215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0844573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545817,0.0372597) , 
1, 0.725444, 1, 0, 0.204173,0.0131901) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446154,0.0276159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.03,-0.0599645) , 
3, 1.82636, 1, 0, 0.379032,-0.0580841) , 
0, 0.6269, 1, 0, 0.259429,-0.00933284)    );
  // itree = 216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301408,0.0324616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202186,-0.0147586) , 
1, 0.128807, 1, 0, 0.245538,0.0116742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20979,-0.0372298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362832,-0.0617442) , 
2, 1.5004, 1, 0, 0.253133,-0.0849143) , 
0, 0.96156, 1, 0, 0.247036,-0.00736671)    );
  // itree = 217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.628019,0.0301629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323144,-0.0229346) , 
3, -1.11042, 1, 0, 0.46789,0.057677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251008,0.00293737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0858144,-0.013359) , 
3, 0.604141, 1, 0, 0.190659,-0.0115441) , 
1, -0.537387, 1, 0, 0.251126,0.00355364)    );
  // itree = 218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447761,0.0315285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163174,-0.0255769) , 
3, -1.16093, 1, 0, 0.244658,0.0245891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308239,0.0103787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940767,-0.0159542) , 
3, 1.08051, 1, 0, 0.246216,-0.0320234) , 
1, 0.344779, 1, 0, 0.245459,-0.00452506)    );
  // itree = 219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0934286) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234364,-0.00782699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415704,0.035992) , 
0, 0.880265, 1, 0, 0.277412,-0.01228) , 
0, -1.37702, 1, 0, 0.253761,-0.00404033)    );
  // itree = 220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.057971,-0.0363439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562874,0.0821287) , 
3, -0.957749, 1, 0, 0.283422,0.0662581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679157,-0.0441613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433584,0.00844091) , 
3, 0.20737, 1, 0, 0.244552,-0.018155) , 
1, -0.66368, 1, 0, 0.251728,-0.00257233)    );
  // itree = 221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416357,-0.0069934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202312,-0.0195769) , 
3, -1.00395, 1, 0, 0.332579,0.066268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253794,0.00548709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100279,0.0046817) , 
3, 1.13289, 1, 0, 0.218123,-0.0173195) , 
0, -0.705811, 1, 0, 0.243583,0.00127415)    );
  // itree = 222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525926,0.0400612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243697,-0.0213214) , 
0, -1.05806, 1, 0, 0.393701,-0.0766651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239332,-0.000542648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0196078,-0.0640913) , 
3, 1.918, 1, 0, 0.226294,0.0118432) , 
3, -1.51764, 1, 0, 0.247846,0.00044882)    );
  // itree = 223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0631579,-0.0358108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253623,-0.00199216) , 
3, -0.663939, 1, 0, 0.1139,0.0404584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3099,0.0164442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247718,-0.0199309) , 
3, 0.145409, 1, 0, 0.277322,-0.0213518) , 
0, -0.637159, 1, 0, 0.234611,-0.00519759)    );
  // itree = 224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306667,0.0888293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238095,-0.00589257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264095,-0.045508) , 
0, 1.06676, 1, 0, 0.242944,-0.0248435) , 
0, -1.35128, 1, 0, 0.247828,-0.0118348)    );
  // itree = 225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505319,-0.00612342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294964,-0.0203933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204353,-0.00471664) , 
0, -1.16056, 1, 0, 0.211378,-0.0105379) , 
1, -1.19679, 1, 0, 0.239273,0.000431322)    );
  // itree = 226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329949,0.000415843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396396,0.00788484) , 
1, -0.571998, 1, 0, 0.365155,-0.0578983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180328,-0.039278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230608,0.00759952) , 
0, -0.893671, 1, 0, 0.226658,0.0167921) , 
3, -1.16568, 1, 0, 0.256085,0.000922302)    );
  // itree = 227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921788,-0.00122312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119617,-0.0349462) , 
3, -1.1996, 1, 0, 0.112616,0.00551052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.669789,0.0521956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32,-0.031174) , 
0, 0.62327, 1, 0, 0.568106,-0.0513789) , 
1, 1.10301, 1, 0, 0.249377,-0.0115705)    );
  // itree = 228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0669216,-0.0255303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422886,0.0268932) , 
3, -0.660474, 1, 0, 0.257549,0.0193961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0993485,-0.0539469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632959,0.0186111) , 
3, 1.25332, 1, 0, 0.261067,-0.0430602) , 
0, 0.249369, 1, 0, 0.259093,-0.00801995)    );
  // itree = 229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359641,0.0103437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0918803,-0.0091359) , 
3, 0.389481, 1, 0, 0.28048,0.00674594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157556,-0.0138916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201754,0.0290101) , 
0, 1.50795, 1, 0, 0.169412,-0.0606293) , 
0, 0.956597, 1, 0, 0.256972,-0.00751425)    );
  // itree = 230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339906,0.010819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0698795,-0.0379508) , 
3, 0.422166, 1, 0, 0.264189,0.00775727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178218,-0.0211015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280967,0.0331626) , 
1, 1.37199, 1, 0, 0.242026,-0.0540418) , 
1, 1.16021, 1, 0, 0.258321,-0.00860583)    );
  // itree = 231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116244,-0.0203943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265525,-0.00250889) , 
3, -0.387124, 1, 0, 0.177504,0.0281083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372287,0.00696096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267101,0.0143659) , 
3, 1.10033, 1, 0, 0.336645,-0.0441452) , 
0, 0.182779, 1, 0, 0.248043,-0.003918)    );
  // itree = 232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296335,0.0185158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113872,-0.0286473) , 
1, 1.06218, 1, 0, 0.235049,0.00812013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0480769,-0.0680956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578947,0.0124824) , 
3, 1.07612, 1, 0, 0.245852,-0.0425626) , 
0, 0.57508, 1, 0, 0.238458,-0.00787352)    );
  // itree = 233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394558,-0.0184138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,-0.0224589) , 
3, -1.34824, 1, 0, 0.325758,0.104476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276937,0.00142394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107547,0.00622912) , 
3, 0.760649, 1, 0, 0.222626,-0.00259067) , 
0, -0.972742, 1, 0, 0.236828,0.0121541)    );
  // itree = 234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401869,-0.000175931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134228,-0.0531285) , 
3, -1.05539, 1, 0, 0.292011,0.0506617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241281,0.00300507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151111,-0.00394199) , 
0, 1.32365, 1, 0, 0.228834,-0.0198221) , 
0, -0.813509, 1, 0, 0.240341,-0.00698432)    );
  // itree = 235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152778,0.026467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221077,-0.0109674) , 
3, -1.27217, 1, 0, 0.204134,0.0271388) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392917,0.005662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145833,-0.0204782) , 
3, 1.40654, 1, 0, 0.332484,-0.0435522) , 
0, 0.30526, 1, 0, 0.25591,-0.00137737)    );
  // itree = 236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776699,-0.0205922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43239,0.0269324) , 
3, -0.367494, 1, 0, 0.24392,0.0165104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195804,-0.0159456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248408,-0.0401211) , 
0, 1.13023, 1, 0, 0.223333,-0.0493188) , 
0, 0.6269, 1, 0, 0.237609,-0.00367231)    );
  // itree = 237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41048,-0.00827995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196172,-0.0266969) , 
3, -1.22633, 1, 0, 0.308219,0.0567435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291621,0.00122401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113422,0.00366645) , 
3, 0.597196, 1, 0, 0.226519,-0.0172788) , 
0, -0.691888, 1, 0, 0.245493,-8.80735e-05)    );
  // itree = 238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343066,0.0136985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106195,-0.0422089) , 
3, -1.37096, 1, 0, 0.236,0.06242) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348096,0.0100416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916399,-0.0231999) , 
3, 0.545565, 1, 0, 0.256996,-0.0168944) , 
1, -0.999833, 1, 0, 0.254373,-0.00698507)    );
  // itree = 239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,0.00124316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288177,-0.0211225) , 
2, 0.548851, 1, 0, 0.230148,-0.0193852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306991,-0.00685734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191388,-0.0230786) , 
0, 1.08047, 1, 0, 0.262082,0.043568) , 
3, 0.721703, 1, 0, 0.238636,-0.0026516)    );
  // itree = 240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213598,-7.55703e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132013,-0.05868) , 
2, 1.0387, 1, 0, 0.200322,-0.0170335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.785714,0.0327247) , 
3, 1.77248, 1, 0, 0.237425,-0.0105534)    );
  // itree = 241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586735,0.0170218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,-0.0142372) , 
3, -1.44503, 1, 0, 0.454158,0.0569259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229713,-0.0089974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14628,0.0185149) , 
3, 0.215079, 1, 0, 0.188206,-0.0164348) , 
1, -0.537387, 1, 0, 0.248667,0.00024295)    );
  // itree = 242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338395,-0.00298634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.083815,-0.0393572) , 
3, -0.478987, 1, 0, 0.229244,0.0265547) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283388,0.00480947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225681,0.0212197) , 
0, 0.370586, 1, 0, 0.257092,-0.0334332) , 
1, 0.144707, 1, 0, 0.245478,-0.00841501)    );
  // itree = 243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0783893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0892308,-0.00855682) , 
3, -1.64614, 1, 0, 0.0620985,0.0536236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322285,0.00373306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163462,-0.0263767) , 
0, 1.55221, 1, 0, 0.311432,-0.0222315) , 
1, -0.484715, 1, 0, 0.252891,-0.00442137)    );
  // itree = 244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287293,0.0581797) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0984095,-0.0262553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459259,0.00613963) , 
3, 0.385816, 1, 0, 0.243308,-0.0134973) , 
0, -1.26434, 1, 0, 0.247583,-0.00266321)    );
  // itree = 245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392405,-0.0169539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227979,-0.0277105) , 
3, -1.61427, 1, 0, 0.301994,0.0756148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241979,0.00452286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194444,0.0129002) , 
0, 1.44561, 1, 0, 0.236874,-0.0197876) , 
0, -0.863316, 1, 0, 0.24815,-0.00326753)    );
  // itree = 246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321892,-0.00140268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120611,-0.0180801) , 
3, 0.205541, 1, 0, 0.245816,0.00888978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.079646,-0.0500879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3125,0.106828) , 
2, 0.9315, 1, 0, 0.195556,-0.0843221) , 
0, 1.32631, 1, 0, 0.240041,-0.00182149)    );
  // itree = 247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925325,-0.0266234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166867,-0.0220485) , 
3, -0.596089, 1, 0, 0.135266,0.0116772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697368,0.049215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421875,0.0210901) , 
3, 1.06012, 1, 0, 0.590726,-0.0581154) , 
1, 1.16801, 1, 0, 0.251414,-0.00612078)    );
  // itree = 248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0545723,-0.0343025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380721,0.0119668) , 
3, -0.524859, 1, 0, 0.251026,0.00129581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1875,-0.0318043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438095,-0.0457902) , 
0, 1.60228, 1, 0, 0.308756,-0.0765748) , 
0, 1.32355, 1, 0, 0.257544,-0.00749604)    );
  // itree = 249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403571,0.00811013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1347,-0.00591364) , 
3, -0.245339, 1, 0, 0.282994,0.0129873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180064,-0.0150735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177305,0.0676698) , 
1, 1.01211, 1, 0, 0.179204,-0.0559143) , 
0, 0.900791, 1, 0, 0.259241,-0.00278158)    );
  // itree = 250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579439,0.0446686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232,-0.0338945) , 
3, -1.56127, 1, 0, 0.392241,0.11499) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255838,0.0083511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201024,-0.00574602) , 
1, 0.770313, 1, 0, 0.231597,-0.0174197) , 
0, -1.05347, 1, 0, 0.25025,-0.00204479)    );
  // itree = 251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155797,0.00374216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259199,-0.0112889) , 
3, -0.847528, 1, 0, 0.227042,-0.0106557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.656,0.100504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230089,0.0019184) , 
0, 1.5093, 1, 0, 0.453782,-0.0789036) , 
0, 1.32355, 1, 0, 0.25385,-0.0187248)    );
  // itree = 252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0823529,-0.0150548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43484,0.0253451) , 
3, -0.356224, 1, 0, 0.257086,0.0193304) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106145,-0.0445422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745763,0.0168991) , 
3, 1.73696, 1, 0, 0.264706,-0.0388604) , 
0, 0.900791, 1, 0, 0.258906,0.00543232)    );
  // itree = 253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468468,0.00560669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308442,0.00716386) , 
3, -0.832986, 1, 0, 0.375472,0.0202165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183295,0.0210549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0755064,-0.0329932) , 
2, 0.582159, 1, 0, 0.123203,-0.0344143) , 
1, 0.432054, 1, 0, 0.254671,-0.00594397)    );
  // itree = 254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464052,0.0124019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245614,-0.0288666) , 
3, -1.63564, 1, 0, 0.370787,0.0786253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356375,0.00764292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166251,-0.00517192) , 
3, -0.362984, 1, 0, 0.23301,-0.00777517) , 
0, -1.05347, 1, 0, 0.250354,0.00310128)    );
  // itree = 255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0828691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18427,0.00033329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301757,-0.000441586) , 
0, -0.617366, 1, 0, 0.27195,-0.00902219) , 
1, -1.18003, 1, 0, 0.245497,0.00482321)    );
  // itree = 256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0326087,-0.0535298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369565,0.0694211) , 
3, -1.37072, 1, 0, 0.219807,0.0487864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232425,-0.0129983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277108,-0.0484063) , 
0, 1.40206, 1, 0, 0.237179,-0.0298791) , 
0, -0.73078, 1, 0, 0.233536,-0.0133809)    );
  // itree = 257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578947,0.00796204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330827,-0.0300318) , 
3, -1.20171, 1, 0, 0.463158,0.0683596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258883,-0.0141205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197342,0.00177977) , 
0, -1.02887, 1, 0, 0.204465,-0.0131082) , 
1, -0.840753, 1, 0, 0.24157,-0.00142308)    );
  // itree = 258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00981419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0406977,-0.0540234) , 
3, 0.626183, 1, 0, 0.265772,0.0218484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0974076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298913,0.0396428) , 
2, -0.315544, 1, 0, 0.222672,-0.0564959) , 
1, 1.19106, 1, 0, 0.25504,0.00234126)    );
  // itree = 259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.02,-0.0212563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102857,-0.00253343) , 
3, -1.40937, 1, 0, 0.0646154,0.0489263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317678,0.00617482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104839,-0.00789188) , 
3, 1.818, 1, 0, 0.30175,-0.0229927) , 
1, -0.768694, 1, 0, 0.262866,-0.0111997)    );
  // itree = 260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0085387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432675,0.0361677) , 
3, -1.02225, 1, 0, 0.304948,0.0464104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,-0.0324015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492228,0.00644007) , 
3, 0.905392, 1, 0, 0.237257,-0.0204389) , 
1, 0.260518, 1, 0, 0.267454,0.00938249)    );
  // itree = 261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526316,-0.000787864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288591,0.00845775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0806794,-0.0138733) , 
1, 1.26542, 1, 0, 0.234547,-0.0182519) , 
1, -1.26922, 1, 0, 0.257128,-0.00685966)    );
  // itree = 262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505952,0.0189127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22549,-0.0232653) , 
3, -1.29599, 1, 0, 0.4,0.0608667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248629,0.00249102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0849057,-0.00574839) , 
3, 1.88098, 1, 0, 0.238695,-0.00576463) , 
0, -1.02158, 1, 0, 0.260288,0.00315479)    );
  // itree = 263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0720268,-0.0404103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603865,0.0336939) , 
1, 0.956666, 1, 0, 0.253994,0.00418209) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596154,0.0652123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165049,-0.0315368) , 
2, 1.00785, 1, 0, 0.381643,-0.103705) , 
0, 1.3861, 1, 0, 0.267062,-0.00686277)    );
  // itree = 264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0748663,-0.0140987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567797,0.0969421) , 
3, -1.00565, 1, 0, 0.265574,0.0752673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218873,-0.00938218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823009,0.0325922) , 
3, 1.84124, 1, 0, 0.260525,-0.00867593) , 
1, -0.847297, 1, 0, 0.261317,0.00449417)    );
  // itree = 265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437202,0.0104155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265152,-0.0144816) , 
0, 0.880791, 1, 0, 0.407359,0.0239428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211111,0.00641051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0667808,-0.0248917) , 
1, 1.15133, 1, 0, 0.14168,-0.0340461) , 
1, 0.0962332, 1, 0, 0.244051,-0.011702)    );
  // itree = 266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407407,-0.0122038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247788,-0.0331181) , 
3, -1.62494, 1, 0, 0.325792,0.0844302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315451,0.00118564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15855,0.00687489) , 
3, 0.134128, 1, 0, 0.239118,-0.00853635) , 
0, -1.1224, 1, 0, 0.248527,0.00155481)    );
  // itree = 267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00263852,-0.0790403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438144,0.0555818) , 
0, 0.900791, 1, 0, 0.0913866,0.0156303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448792,0.00625724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233945,0.001249) , 
3, 1.38514, 1, 0, 0.405704,-0.0319673) , 
1, 0.324332, 1, 0, 0.25895,-0.00974418)    );
  // itree = 268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304945,0.0366984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197165,-0.0127864) , 
1, 0.262152, 1, 0, 0.249335,0.0199581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0335196,-0.0765143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56682,-0.00158394) , 
3, 1.15723, 1, 0, 0.234783,-0.0584317) , 
0, 0.731231, 1, 0, 0.24531,-0.00172258)    );
  // itree = 269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468908,0.0288518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20597,-0.0229065) , 
2, -0.369069, 1, 0, 0.329644,-0.0193844) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106195,-0.0116968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156098,0.0275095) , 
2, -0.331461, 1, 0, 0.148352,0.0224699) , 
3, 0.331768, 1, 0, 0.263422,-0.00409592)    );
  // itree = 270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239044,-0.0027246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276029,0.00759265) , 
1, -0.887572, 1, 0, 0.271151,-0.0209059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128713,0.0383595) , 
3, 1.99526, 1, 0, 0.263972,-0.0163802)    );
  // itree = 271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0767009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00943396,-0.0853337) , 
3, -1.56127, 1, 0, 0.00403226,0.0652535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301901,0.0107669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28733,0.000365521) , 
3, 0.917255, 1, 0, 0.298236,-0.0196398) , 
0, -1.11841, 1, 0, 0.261845,-0.00913925)    );
  // itree = 272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238095,0.0635355) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122896,-0.0194613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493192,0.0181947) , 
3, 0.503798, 1, 0, 0.255273,-0.000494889) , 
1, -1.28125, 1, 0, 0.254008,0.00620365)    );
  // itree = 273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346921,0.00793103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111374,0.00870162) , 
3, 0.3925, 1, 0, 0.28381,0.0113239) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184466,-0.00718919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0901639,-0.0249127) , 
2, 1.47278, 1, 0, 0.157773,-0.0671766) , 
0, 0.956597, 1, 0, 0.25673,-0.00554234)    );
  // itree = 274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218466,-0.0332586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478947,0.0540182) , 
2, -0.0269118, 1, 0, 0.32935,-0.0180326) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722543,-0.0312794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153605,0.0018181) , 
1, 1.16326, 1, 0, 0.111278,0.0519649) , 
3, 0.414913, 1, 0, 0.256986,0.00519509)    );
  // itree = 275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135389,-0.0173863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409563,0.0348695) , 
0, -0.00769512, 1, 0, 0.242869,-0.0336581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.820755,0.118805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178886,-0.0461922) , 
2, -0.336733, 1, 0, 0.265228,0.0201026) , 
3, 0.331768, 1, 0, 0.251613,-0.0126341)    );
  // itree = 276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210181,0.00822137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13544,-0.0497886) , 
2, 0.628441, 1, 0, 0.190247,-0.0116803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615385,0.0567584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706587,-0.00318125) , 
3, 1.74577, 1, 0, 0.666667,0.0640967) , 
3, 1.30934, 1, 0, 0.262513,-0.000186015)    );
  // itree = 277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0173306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213873,-0.000633835) , 
3, -1.01567, 1, 0, 0.306122,0.0393224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315871,0.0063681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162534,0.0194771) , 
3, 0.28947, 1, 0, 0.234909,-0.0320849) , 
0, -0.402053, 1, 0, 0.258612,-0.00831713)    );
  // itree = 278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292683,-0.00434104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.0370986) , 
3, -1.39549, 1, 0, 0.201717,0.0767397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321642,0.00110322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122324,-0.00261389) , 
3, 0.524498, 1, 0, 0.250137,-0.010331) , 
1, -0.999833, 1, 0, 0.24465,-0.000463523)    );
  // itree = 279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0371287,-0.0326128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127148,-0.00835898) , 
3, -0.641584, 1, 0, 0.0748201,0.0443292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357041,0.00811606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299674,-0.00428161) , 
3, 0.444203, 1, 0, 0.330296,-0.0259116) , 
1, -0.128677, 1, 0, 0.242048,-0.00164852)    );
  // itree = 280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338164,-0.0501803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410658,0.0454881) , 
3, -1.32589, 1, 0, 0.262357,0.0372189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121145,-0.0253918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481696,0.00833403) , 
3, 0.67389, 1, 0, 0.252277,-0.0134551) , 
1, -0.390081, 1, 0, 0.254992,0.000192921)    );
  // itree = 281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489362,0.0170225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291429,-0.0332235) , 
0, -0.890622, 1, 0, 0.393939,-0.0639129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301205,0.00727367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220452,0.00485105) , 
0, -0.835549, 1, 0, 0.228469,0.0248232) , 
3, -1.30768, 1, 0, 0.257985,0.00899462)    );
  // itree = 282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420091,0.00493689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170492,-0.0420305) , 
3, -1.303, 1, 0, 0.274809,0.0492784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285588,0.0107346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0657534,-0.0337254) , 
3, 1.02416, 1, 0, 0.231952,-0.0173499) , 
0, -0.637159, 1, 0, 0.243069,-6.61461e-05)    );
  // itree = 283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.076875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13198,0.054119) , 
3, -1.64614, 1, 0, 0.0828025,0.0650741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0917384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309539,0.00357632) , 
0, -1.29224, 1, 0, 0.288745,-0.0142481) , 
1, -0.848848, 1, 0, 0.256589,-0.00186268)    );
  // itree = 284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306122,0.0701527) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104405,-0.0282137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492823,0.0117493) , 
3, 0.528814, 1, 0, 0.235834,-0.013464) , 
1, -1.28125, 1, 0, 0.241,-0.00412426)    );
  // itree = 285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409043,0.0189537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.0409483) , 
2, 0.218008, 1, 0, 0.299162,-0.0173075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.036036,-0.0572026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.099723,-0.00213252) , 
2, 0.297411, 1, 0, 0.0847458,0.0443494) , 
3, 0.853537, 1, 0, 0.249135,-0.00292187)    );
  // itree = 286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343284,0.0107724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0677507,-0.0365153) , 
3, 0.588658, 1, 0, 0.27873,0.0119865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0627768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170909,0.0207616) , 
3, 0.0851123, 1, 0, 0.146465,-0.0735861) , 
0, 1.00007, 1, 0, 0.252156,-0.00520621)    );
  // itree = 287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197662,0.0052406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280488,-0.0173979) , 
3, -0.0708865, 1, 0, 0.234068,0.0082905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.745614,0.0857843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309392,0.0111576) , 
2, 0.459101, 1, 0, 0.477966,-0.0638467) , 
0, 1.14463, 1, 0, 0.270517,-0.00248988)    );
  // itree = 288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673077,-0.0248375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475728,0.0967008) , 
3, -1.62611, 1, 0, 0.270531,0.0902281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212791,-0.0102453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86,0.0433866) , 
3, 1.89048, 1, 0, 0.249295,-0.00922696) , 
0, -1.14631, 1, 0, 0.251515,0.00117061)    );
  // itree = 289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528,0.0131181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284298,-0.00326551) , 
3, -0.987872, 1, 0, 0.377551,0.0262405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122263,-0.0283458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100559,-0.00101798) , 
3, 0.487166, 1, 0, 0.111521,-0.0212276) , 
1, 0.324332, 1, 0, 0.237772,0.00129965)    );
  // itree = 290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311927,0.00183201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183562,-0.0229101) , 
1, 1.2364, 1, 0, 0.277117,0.0226945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243553,0.00396449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0876494,-0.0163904) , 
3, 1.07612, 1, 0, 0.178333,-0.0526443) , 
0, 0.57508, 1, 0, 0.24666,-0.00053431)    );
  // itree = 291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0805559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0931383) , 
3, -1.62611, 1, 0, 0,0.0924315) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13882,-0.0202725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598993,0.0369505) , 
1, 1.09193, 1, 0, 0.291273,-0.00994803) , 
0, -1.15037, 1, 0, 0.26005,0.00102665)    );
  // itree = 292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275862,0.0599808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485933,-0.0365586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405456,0.00688596) , 
3, -0.291614, 1, 0, 0.254201,-0.00588032) , 
1, -1.28125, 1, 0, 0.256067,0.00267724)    );
  // itree = 293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330566,0.00892037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0878906,-0.0113935) , 
3, 0.595761, 1, 0, 0.262929,0.00401613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158163,-0.000430914) , 
0, 1.38197, 1, 0, 0.252828,-0.00411828)    );
  // itree = 294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437853,0.0231827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184543,-0.014577) , 
3, -0.987872, 1, 0, 0.275304,0.0198582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307102,-0.00600109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113924,-0.0134858) , 
3, 0.420403, 1, 0, 0.207635,-0.0237839) , 
1, 0.370854, 1, 0, 0.240058,-0.00287293)    );
  // itree = 295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164826,-0.0152177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278351,-0.015308) , 
3, 0.409676, 1, 0, 0.197954,0.00676291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.583333,0.0429265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277228,-9.05841e-05) , 
2, 0.609584, 1, 0, 0.404624,-0.0598144) , 
0, 1.00803, 1, 0, 0.233566,-0.00470907)    );
  // itree = 296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136986,0.00796839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0281125,-0.0633534) , 
0, -0.473442, 1, 0, 0.0832507,-0.0229962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634921,0.0450317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34903,-2.81757e-05) , 
1, 0.156863, 1, 0, 0.422998,0.0273309) , 
3, -0.112181, 1, 0, 0.250126,0.00172321)    );
  // itree = 297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316832,-0.0302757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30303,-0.0193018) , 
0, -1.65119, 1, 0, 0.31,0.0922826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310571,-0.000776348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105341,0.00549251) , 
1, 0.909504, 1, 0, 0.231211,-0.00786047) , 
0, -1.17397, 1, 0, 0.239321,0.00244762)    );
  // itree = 298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457801,0.0241305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0436084) , 
3, -0.974354, 1, 0, 0.302991,0.0373514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293944,0.00736194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109029,-0.00671792) , 
3, 0.515866, 1, 0, 0.20807,-0.0135359) , 
0, -0.293879, 1, 0, 0.243974,0.00571264)    );
  // itree = 299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0802139,0.0242453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380488,0.0726782) , 
3, -1.74562, 1, 0, 0.237245,-0.0416697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,-0.00591994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257597,-0.00823424) , 
0, -0.893671, 1, 0, 0.247468,0.0224634) , 
3, -1.2271, 1, 0, 0.245436,0.00971482)    );
  // itree = 300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273115,0.0357798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.0374031) , 
1, 1.11993, 1, 0, 0.230439,0.028549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561404,-0.057144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546025,0.0115323) , 
3, 0.599808, 1, 0, 0.27958,-0.0198822) , 
0, -0.0763418, 1, 0, 0.256436,0.00292764)    );
  // itree = 301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371609,0.00796394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0976492,-0.00338038) , 
1, 0.939437, 1, 0, 0.280289,0.0073444) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162162,-0.0273388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188525,0.0363724) , 
3, 0.528703, 1, 0, 0.180282,-0.0884523) , 
0, 1.07303, 1, 0, 0.262661,-0.00954132)    );
  // itree = 302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376771,0.00378721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205902,-0.00855939) , 
3, -1.27221, 1, 0, 0.238612,-0.0103945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0594059,-0.0233003) , 
3, 1.98299, 1, 0, 0.229306,-0.00334693)    );
  // itree = 303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0900741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0892116,-0.0168234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352433,-9.0038e-05) , 
1, -0.187201, 1, 0, 0.280182,-0.012997) , 
0, -1.2056, 1, 0, 0.25192,-0.00130086)    );
  // itree = 304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157393,-0.0103665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561728,0.0381371) , 
3, 0.717426, 1, 0, 0.240202,0.00710816) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172161,-0.0470143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457944,-0.0100882) , 
1, 1.06882, 1, 0, 0.252632,-0.0576034) , 
0, 1.01723, 1, 0, 0.24261,-0.00542517)    );
  // itree = 305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371638,-0.000816376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256809,0.00220954) , 
0, 0.30526, 1, 0, 0.327327,0.015969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0641026,-0.0311545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100817,0.00870941) , 
2, 0.357268, 1, 0, 0.0865225,-0.0459459) , 
1, 1.01701, 1, 0, 0.252457,-0.0032813)    );
  // itree = 306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322842,0.00652981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0478873,-0.0419762) , 
3, 0.604967, 1, 0, 0.256305,0.024803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132948,-0.0456824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221053,0.0150719) , 
0, -0.29956, 1, 0, 0.19349,-0.0345152) , 
1, 1.19106, 1, 0, 0.239109,0.00856389)    );
  // itree = 307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18139,0.00617338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250265,-0.0233811) , 
3, -0.334141, 1, 0, 0.217634,0.0134723) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684211,0.0616578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.018464) , 
3, 1.42959, 1, 0, 0.397321,-0.0620543) , 
0, 1.28629, 1, 0, 0.237599,0.00508044)    );
  // itree = 308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0351351,-0.0448173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383361,0.0313687) , 
3, -1.04896, 1, 0, 0.252289,0.0238762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10981,-0.0394241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601424,0.00881227) , 
3, 1.08356, 1, 0, 0.253112,-0.0279252) , 
0, 0.0899978, 1, 0, 0.252696,-0.00177178)    );
  // itree = 309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478873,0.00802903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231527,-0.0248491) , 
3, -1.64764, 1, 0, 0.333333,0.0531549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252306,0.00794521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171233,0.0764809) , 
1, 1.56373, 1, 0, 0.245192,-0.0236482) , 
0, -0.880679, 1, 0, 0.260329,-0.0104591)    );
  // itree = 310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291317,-0.0096978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.00906363) , 
0, -0.0221055, 1, 0, 0.241206,0.0180914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860656,-0.0674074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273636,0.0207519) , 
2, -0.579517, 1, 0, 0.239583,-0.0239198) , 
1, -0.187201, 1, 0, 0.240082,-0.0109983)    );
  // itree = 311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,0.0106619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,0.0410395) , 
3, -1.0595, 1, 0, 0.0887574,0.067491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308776,0.0178711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291667,-0.00731936) , 
3, 0.20737, 1, 0, 0.30114,-0.0153971) , 
1, -0.761509, 1, 0, 0.265337,-0.00142398)    );
  // itree = 312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270878,0.0128898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218553,-0.025726) , 
0, 0.30526, 1, 0, 0.249682,-0.00402478) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0429448,-0.0883785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222973,-0.0146746) , 
0, -0.128422, 1, 0, 0.159041,-0.0583175) , 
1, 1.28142, 1, 0, 0.229177,-0.0163069)    );
  // itree = 313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446682,0.0106037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151815,-0.0163201) , 
3, 0.158612, 1, 0, 0.368788,0.00141871) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121951,-0.00202034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15981,0.0260377) , 
0, -0.262472, 1, 0, 0.147987,-0.0503819) , 
1, 0.583399, 1, 0, 0.270571,-0.0216233)    );
  // itree = 314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0383699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189516,-0.0137073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267273,0.0146753) , 
1, -0.796791, 1, 0, 0.257113,0.00553646) , 
3, -1.98623, 1, 0, 0.270418,0.000439957)    );
  // itree = 315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0885199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152033,-0.0118878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548032,0.0227212) , 
1, 1.01709, 1, 0, 0.286863,-0.0148914) , 
0, -1.35128, 1, 0, 0.263807,-0.00836031)    );
  // itree = 316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0490196,-0.0362393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441718,0.0663193) , 
3, -1.61915, 1, 0, 0.290566,0.0636032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283898,0.00309319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174138,-0.0242457) , 
1, 1.10333, 1, 0, 0.247727,-0.00827187) , 
1, -0.910541, 1, 0, 0.253333,0.00113401)    );
  // itree = 317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446953,-0.00344888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387931,0.0170896) , 
0, 0.631053, 1, 0, 0.434705,0.0149849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251185,0.0208406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108183,-0.0189274) , 
2, 0.384897, 1, 0, 0.175037,-0.0261436) , 
1, -0.220858, 1, 0, 0.250915,-0.0141254)    );
  // itree = 318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288493,0.0062935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156863,-0.0266957) , 
1, 0.866069, 1, 0, 0.247354,0.0138796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370968,0.0721641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345588,0.102042) , 
0, 0.801038, 1, 0, 0.357692,-0.0887607) , 
2, 1.46433, 1, 0, 0.261314,0.00089348)    );
  // itree = 319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0773163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916497,-0.0122507) , 
3, -1.70941, 1, 0, 0.0735294,0.0333133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346037,0.0023719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163462,-0.0525122) , 
0, 1.55221, 1, 0, 0.332627,-0.0176057) , 
1, -0.186478, 1, 0, 0.254438,-0.00223961)    );
  // itree = 320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0138889,-0.0653212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346567,0.0183001) , 
3, -1.49716, 1, 0, 0.283972,0.0161877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111562,-0.0485832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338279,0.00637094) , 
0, 0.512029, 1, 0, 0.203614,-0.0368427) , 
1, 0.680932, 1, 0, 0.250253,-0.0060647)    );
  // itree = 321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364372,0.00277379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113346,-0.0080772) , 
3, 0.0377678, 1, 0, 0.274919,0.00782818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16358,-0.0208834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177305,0.0522636) , 
1, 0.963449, 1, 0, 0.167742,-0.0507991) , 
0, 0.900791, 1, 0, 0.25,-0.00580266)    );
  // itree = 322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390511,0.00688611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192112,-0.0108002) , 
3, -0.730312, 1, 0, 0.273613,0.0169846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0708333,-0.0545595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270202,0.0365087) , 
2, 0.26257, 1, 0, 0.194969,-0.0383789) , 
0, 0.599733, 1, 0, 0.248223,-0.000889116)    );
  // itree = 323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0103093,-0.068321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0836336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303758,0.00361307) , 
0, -1.29224, 1, 0, 0.278689,-0.0156501) , 
1, -1.07868, 1, 0, 0.252165,-0.00480609)    );
  // itree = 324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319307,0.0596883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25283,0.00349071) , 
1, -0.33402, 1, 0, 0.275229,0.0349754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11794,-0.0301202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645299,0.0164928) , 
3, 1.40895, 1, 0, 0.26555,-0.0145433) , 
0, 0.297203, 1, 0, 0.271253,0.0146326)    );
  // itree = 325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461538,-0.00319051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248,-0.0255182) , 
3, -1.69704, 1, 0, 0.35124,0.0666227) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246316,3.95128e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171745,-9.76418e-05) , 
0, 1.06235, 1, 0, 0.231243,-0.00902857) , 
0, -1.07672, 1, 0, 0.245562,-1.15609e-06)    );
  // itree = 326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.034568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438849,0.000616785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248503,0.00682081) , 
0, -1.26434, 1, 0, 0.263129,-0.0019755) , 
1, -1.29933, 1, 0, 0.255123,0.00444842)    );
  // itree = 327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00116686,-0.0804997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455556,0.00565692) , 
1, 0.57445, 1, 0, 0.193679,0.00964405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362903,0.0484282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406467,0.0110717) , 
1, -0.203775, 1, 0, 0.396768,-0.0607556) , 
0, 0.759972, 1, 0, 0.249022,-0.00954019)    );
  // itree = 328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0084806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44359,0.0240411) , 
3, -0.0708865, 1, 0, 0.259132,0.0169415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255102,-0.0108132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345455,-0.0534334) , 
2, 0.934932, 1, 0, 0.302885,-0.0650436) , 
0, 1.32355, 1, 0, 0.263775,0.00824105)    );
  // itree = 329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501742,0.00372736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357639,0.00484259) , 
3, -1.22827, 1, 0, 0.405562,0.00959077) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188889,0.00812083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125794,-0.00550793) , 
2, 0.0825409, 1, 0, 0.145597,-0.02721) , 
1, 0.144707, 1, 0, 0.257214,-0.0114095)    );
  // itree = 330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373676,0.0033092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201621,-0.00261467) , 
3, -0.671165, 1, 0, 0.270631,0.00873357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131737,-0.0174411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202532,0.0211587) , 
1, 0.46436, 1, 0, 0.166154,-0.0564291) , 
0, 1.12459, 1, 0, 0.253421,-0.00200026)    );
  // itree = 331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,-0.0156889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329942,0.0239981) , 
0, -0.69946, 1, 0, 0.239815,-0.0220115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300221,-0.00104878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240964,-0.018621) , 
0, 0.558766, 1, 0, 0.271889,0.0313065) , 
3, 0.0840329, 1, 0, 0.254107,0.00174625)    );
  // itree = 332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134221,-0.0109058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489177,0.0246397) , 
3, 0.177006, 1, 0, 0.248261,0.00845412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225108,-0.017619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0540776) , 
0, 1.54014, 1, 0, 0.246073,-0.0434793) , 
0, 0.676581, 1, 0, 0.247638,-0.00634342)    );
  // itree = 333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302083,-0.0278586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250178,-0.00152857) , 
0, -1.25012, 1, 0, 0.256426,0.0196408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289256,0.0276416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147239,-0.0139428) , 
2, -0.0314155, 1, 0, 0.185682,-0.0524284) , 
0, 0.941261, 1, 0, 0.24094,0.00386463)    );
  // itree = 334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233251,-0.0199231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515957,0.0714012) , 
2, 0.697661, 1, 0, 0.300315,-0.0173426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.082916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0825083,-0.0196456) , 
2, 0.474326, 1, 0, 0.0576037,0.0314718) , 
3, 0.920143, 1, 0, 0.248143,-0.00684953)    );
  // itree = 335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.039666,-0.0304877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136905,-0.00426869) , 
3, -0.54823, 1, 0, 0.0797546,0.0250234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394313,0.00191312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104,-0.00770539) , 
3, 1.80096, 1, 0, 0.363559,-0.0264318) , 
1, 0.0861832, 1, 0, 0.247619,-0.00541126)    );
  // itree = 336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0451977,-0.039242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544,0.0788319) , 
3, -1.33079, 1, 0, 0.251656,0.0547652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197729,-0.0127932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853448,0.0518268) , 
3, 1.83855, 1, 0, 0.244885,-0.0077068) , 
0, -0.940853, 1, 0, 0.245953,0.00214518)    );
  // itree = 337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300493,-0.0249363) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264762,0.0054444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0590717,-0.0321845) , 
3, 1.39666, 1, 0, 0.237859,-0.00926771) , 
0, -1.29224, 1, 0, 0.244169,-0.000834512)    );
  // itree = 338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23301,-0.0183139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189542,0.000609091) , 
0, -0.81877, 1, 0, 0.207031,0.0638202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326064,-0.00391014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148289,0.00167171) , 
3, 0.205652, 1, 0, 0.246005,-0.0075965) , 
1, -0.999833, 1, 0, 0.241036,0.00150842)    );
  // itree = 339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.08551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305635,0.00895424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916031,-0.0124592) , 
3, 1.83189, 1, 0, 0.290784,-0.0107691) , 
0, -1.37918, 1, 0, 0.270177,-0.00437312)    );
  // itree = 340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.008,-0.0738356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335616,0.0438336) , 
3, -1.93694, 1, 0, 0.262877,0.0396954) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0893513,-0.0321749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470199,0.00671085) , 
3, 0.524498, 1, 0, 0.251232,-0.0135926) , 
1, -0.327527, 1, 0, 0.254536,0.00152894)    );
  // itree = 341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285194,0.00646615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.081483) , 
3, 1.65844, 1, 0, 0.268112,-0.00184988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12963,-0.0375472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139344,0.0209013) , 
3, 1.10126, 1, 0, 0.134783,-0.0895076) , 
0, 1.32355, 1, 0, 0.252647,-0.0120169)    );
  // itree = 342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296763,0.00263166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157576,-0.0086842) , 
0, 1.26376, 1, 0, 0.278778,0.0195754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188679,-0.0192096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230032,0.0209617) , 
0, 0.353591, 1, 0, 0.206242,-0.0385068) , 
1, 0.75851, 1, 0, 0.252234,-0.00167913)    );
  // itree = 343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188912,0.026527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247765,-0.0110293) , 
2, -0.576505, 1, 0, 0.225197,-0.0265098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.831683,0.0892541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185714,-0.0375361) , 
2, -0.339484, 1, 0, 0.274966,0.0255416) , 
3, 0.371425, 1, 0, 0.243378,-0.0074945)    );
  // itree = 344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299065,0.041262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22,-0.0391125) , 
0, 0.575385, 1, 0, 0.281752,0.0365085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,-0.0345827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508929,0.0108038) , 
3, 0.88329, 1, 0, 0.238023,-0.0162305) , 
1, -0.128677, 1, 0, 0.253,0.0018326)    );
  // itree = 345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412451,0.00342197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225092,0.0128418) , 
3, -0.872066, 1, 0, 0.285357,0.00636444) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189286,-0.00122842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155963,0.0661181) , 
3, 1.77598, 1, 0, 0.179949,-0.0639986) , 
0, 1.01723, 1, 0, 0.264721,-0.0074107)    );
  // itree = 346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361011,0.00281919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170543,-0.0038359) , 
3, -0.356224, 1, 0, 0.261822,0.00568116) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149123,-0.0360945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228571,0.0668848) , 
3, 0.833951, 1, 0, 0.192913,-0.0661027) , 
0, 1.2265, 1, 0, 0.253018,-0.00349041)    );
  // itree = 347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211834,0.0108546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289227,-0.000763571) , 
3, -0.226556, 1, 0, 0.250736,0.00181201) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364286,0.0239905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251799,-0.0370995) , 
1, 1.41495, 1, 0, 0.308244,-0.0628364) , 
2, 1.46433, 1, 0, 0.258847,-0.00730675)    );
  // itree = 348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0695187,-0.0203967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390181,0.0459898) , 
3, -0.985365, 1, 0, 0.232589,0.0352119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0411215,-0.0552817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415989,-0.000781511) , 
3, 0.153718, 1, 0, 0.258445,-0.0212684) , 
0, -0.293879, 1, 0, 0.248771,-0.000136907)    );
  // itree = 349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,-0.00532181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287625,-0.00918327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191686,0.0105514) , 
3, -0.555244, 1, 0, 0.221929,-0.0110166) , 
1, -1.12426, 1, 0, 0.24869,-0.00333087)    );
  // itree = 350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342308,0.00200993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964467,-0.0282682) , 
3, -0.0241086, 1, 0, 0.259796,0.0172818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197917,-0.012952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414062,0.111666) , 
1, 1.70565, 1, 0, 0.228795,-0.0213681) , 
1, 0.680932, 1, 0, 0.246377,0.000552171)    );
  // itree = 351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0868516,-0.0198412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158228,-0.00015418) , 
3, 0.178242, 1, 0, 0.10655,0.019402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498437,0.00194673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23913,0.0527319) , 
3, 1.68156, 1, 0, 0.452442,-0.0316039) , 
1, 0.670673, 1, 0, 0.24649,-0.00123378)    );
  // itree = 352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262411,0.0606665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227137,-0.00541416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323171,-0.0324778) , 
0, 1.44414, 1, 0, 0.23571,-0.0136714) , 
0, -1.37918, 1, 0, 0.237614,-0.00597048)    );
  // itree = 353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469799,-0.00313484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352734,0.00289794) , 
3, -1.82131, 1, 0, 0.377095,-0.0318937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25286,0.0156616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.099537,0.00850842) , 
1, 1.24837, 1, 0, 0.202144,0.0105656) , 
3, -0.610112, 1, 0, 0.264095,-0.00446943)    );
  // itree = 354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312358,0.00232618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122931,-0.00414134) , 
3, 0.570683, 1, 0, 0.26636,0.00807818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782123,-0.0178244) , 
3, 1.61709, 1, 0, 0.248829,0.00110227)    );
  // itree = 355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00689655,-0.0699955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286225,0.0461044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256956,-0.0115621) , 
3, -0.701828, 1, 0, 0.266143,-0.00996472) , 
1, -1.33599, 1, 0, 0.246625,-0.0036149)    );
  // itree = 356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0304878,-0.0514532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472603,0.0633144) , 
3, -1.42576, 1, 0, 0.23871,0.0411952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0550661,-0.0423032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423445,0.00399639) , 
3, 0.119606, 1, 0, 0.231651,-0.0159584) , 
0, -0.940853, 1, 0, 0.232717,-0.0073325)    );
  // itree = 357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390338,0.0100538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0164879) , 
1, 0.909404, 1, 0, 0.279113,-0.00474932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206452,-0.0191714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115741,-0.0109941) , 
1, 0.276978, 1, 0, 0.153639,-0.0546954) , 
0, 1.0112, 1, 0, 0.255767,-0.0140422)    );
  // itree = 358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444444,-0.00117082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344086,0.00313201) , 
0, -1.56401, 1, 0, 0.363002,-0.0313969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156584,-0.0163948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244344,0.0164329) , 
1, 0.409101, 1, 0, 0.210235,0.0125871) , 
3, -0.871513, 1, 0, 0.253591,0.000104255)    );
  // itree = 359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349593,0.100725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155756,-0.0050787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259313,-0.00925958) , 
0, -0.604289, 1, 0, 0.233996,0.020362) , 
2, -1.50168, 1, 0, 0.241344,0.0142185)    );
  // itree = 360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274854,0.0468992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963749,-0.0232855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489943,0.0118061) , 
3, 0.385816, 1, 0, 0.246305,-0.00502641) , 
0, -1.2923, 1, 0, 0.248749,0.00178944)    );
  // itree = 361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452055,-0.0100981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313726,-0.00378426) , 
3, -1.00565, 1, 0, 0.375,0.0185905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179245,-0.00405315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,0.0166355) , 
3, 0.293632, 1, 0, 0.156195,-0.0249031) , 
1, 0.162984, 1, 0, 0.247716,-0.00671083)    );
  // itree = 362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172949,-0.0453348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508604,0.0459824) , 
2, -0.445906, 1, 0, 0.353183,-0.0223922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16124,0.00183981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185714,0.0151252) , 
0, 0.797129, 1, 0, 0.170892,0.0224732) , 
3, -0.112181, 1, 0, 0.25797,0.00104164)    );
  // itree = 363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0723684,-0.0274648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109661,-0.0257901) , 
3, -0.0127876, 1, 0, 0.0848644,0.0176363) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.725857,0.0673432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274436,-0.036245) , 
2, 0.273454, 1, 0, 0.444314,-0.0334529) , 
1, 0.583399, 1, 0, 0.238477,-0.00419691)    );
  // itree = 364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460526,-0.0366839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490683,0.0602412) , 
3, -1.32589, 1, 0, 0.27476,0.0515593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204485,-0.0117961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846939,0.0395503) , 
3, 1.91364, 1, 0, 0.243494,-0.0107387) , 
1, -0.840753, 1, 0, 0.248573,-0.000619684)    );
  // itree = 365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509091,0.0122374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23956,-0.0161724) , 
3, -0.652318, 1, 0, 0.38,0.025724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30303,0.0353047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113436,-0.00957947) , 
1, 0.493891, 1, 0, 0.132075,-0.0188731) , 
1, 0.324332, 1, 0, 0.252427,0.00277596)    );
  // itree = 366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413462,0.0163533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127517,-0.0173673) , 
3, -0.384659, 1, 0, 0.284743,0.0181217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226766,-0.00814861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190128,-0.00311226) , 
0, -0.163753, 1, 0, 0.202206,-0.020511) , 
1, 0.751632, 1, 0, 0.253271,0.00339072)    );
  // itree = 367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189258,0.0068665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297297,0.00164323) , 
3, -0.367691, 1, 0, 0.23742,0.0138501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334375,-0.00954555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159817,-0.00801041) , 
3, 1.08051, 1, 0, 0.263451,-0.0487209) , 
2, 0.726098, 1, 0, 0.244615,-0.00344515)    );
  // itree = 368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117512,0.00583478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491039,0.0513911) , 
3, -0.659436, 1, 0, 0.263675,0.045971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209241,-0.0166574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87619,0.0485948) , 
3, 1.87724, 1, 0, 0.265176,-0.0137265) , 
0, -0.362191, 1, 0, 0.264631,0.00793472)    );
  // itree = 369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388889,-0.0132392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252945,0.00506151) , 
3, -1.35261, 1, 0, 0.278992,0.0103424) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0186916,-0.0789702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0178373) , 
3, 1.08579, 1, 0, 0.0491071,-0.0565906) , 
2, 1.51846, 1, 0, 0.25336,0.00287947)    );
  // itree = 370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384709,0.0148978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114155,-0.0271885) , 
3, -0.17411, 1, 0, 0.264686,0.0185918) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205405,-0.00526027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303704,0.0507802) , 
0, 0.583613, 1, 0, 0.231683,-0.0498709) , 
1, 1.28142, 1, 0, 0.256294,0.00118311)    );
  // itree = 371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124601,-0.0137622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278396,0.00450449) , 
3, -0.387124, 1, 0, 0.188837,0.0266945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378653,0.00292196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985916,-0.00894982) , 
3, 1.73696, 1, 0, 0.335845,-0.0174203) , 
0, 0.133846, 1, 0, 0.256986,0.00624407)    );
  // itree = 372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0660714,-0.0274502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462963,0.0251005) , 
3, -0.587187, 1, 0, 0.270364,0.0119626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0946746,-0.0676103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241979,-0.0107973) , 
0, -0.560955, 1, 0, 0.214831,-0.0308877) , 
1, 0.583399, 1, 0, 0.245775,-0.0070107)    );
  // itree = 373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,-0.00734536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20444,0.00284188) , 
3, -0.730586, 1, 0, 0.261054,0.0171288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185714,-0.0102572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865385,-0.00981439) , 
3, 1.54878, 1, 0, 0.152866,-0.0514303) , 
0, 1.14463, 1, 0, 0.243766,0.00617329)    );
  // itree = 374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357798,-0.0249413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336134,-0.00138154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214394,0.00664265) , 
3, -0.698741, 1, 0, 0.252219,-0.011151) , 
0, -1.61601, 1, 0, 0.257905,-0.00565189)    );
  // itree = 375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.0137958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230675,-0.0197174) , 
3, -0.660832, 1, 0, 0.204453,0.0216158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525,0.0320911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183267,-0.0283321) , 
3, 0.997648, 1, 0, 0.393241,-0.029432) , 
0, 0.662508, 1, 0, 0.262072,0.00603579)    );
  // itree = 376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11811,-0.0097027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499115,0.019448) , 
3, 0.497287, 1, 0, 0.235422,0.00629181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39604,-0.0516721) , 
0, 1.55221, 1, 0, 0.243802,8.22952e-05)    );
  // itree = 377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316327,-0.022282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297771,0.00284783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925553,0.00372801) , 
1, 1.21354, 1, 0, 0.239589,-0.0148814) , 
0, -1.11841, 1, 0, 0.247306,-0.00670189)    );
  // itree = 378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280405,-0.00171159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116129,-0.0181752) , 
0, 0.782376, 1, 0, 0.246319,0.0337287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247331,-0.00144673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202073,0.0136981) , 
0, 1.31918, 1, 0, 0.240699,-0.0157838) , 
1, -0.0805323, 1, 0, 0.242733,0.00213572)    );
  // itree = 379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130404,-0.0265412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653631,0.0389941) , 
1, 1.25783, 1, 0, 0.234933,0.00804564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420561,-0.00326038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0839695,-0.057134) , 
3, 1.01867, 1, 0, 0.235294,-0.0799251) , 
2, 1.51846, 1, 0, 0.234975,-0.00226817)    );
  // itree = 380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0876404,-0.0143298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407252,0.0161754) , 
3, -0.193194, 1, 0, 0.230243,0.00652368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186747,-0.0494389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415888,-0.00219865) , 
0, 0.532457, 1, 0, 0.315789,-0.0340276) , 
2, 1.07686, 1, 0, 0.246603,-0.00123148)    );
  // itree = 381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612245,0.0528102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237288,-0.0309886) , 
2, -0.93928, 1, 0, 0.390651,-0.0246894) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258242,0.00509047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,0.00796667) , 
1, 1.11371, 1, 0, 0.204348,0.0171876) , 
3, -0.736148, 1, 0, 0.260738,0.00451234)    );
  // itree = 382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311167,-0.0091656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0811688,-0.0422379) , 
3, -0.306729, 1, 0, 0.210899,0.0138482) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418895,0.0587203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865385,-0.0128022) , 
3, 1.73915, 1, 0, 0.366917,-0.0458933) , 
2, 0.648293, 1, 0, 0.260828,-0.0052702)    );
  // itree = 383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0767301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0267857,-0.0608829) , 
3, -1.58581, 1, 0, 0.0125523,0.0560055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306452,0.0128465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289916,0.00869224) , 
3, 0.381995, 1, 0, 0.299531,-0.000362799) , 
0, -1.05347, 1, 0, 0.264267,0.00656369)    );
  // itree = 384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0618557,-0.0236592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450216,0.0590063) , 
3, -1.02921, 1, 0, 0.233716,0.04049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0582524,-0.0394103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443489,0.00804569) , 
3, 0.125323, 1, 0, 0.262541,-0.00795901) , 
0, -0.653242, 1, 0, 0.255226,0.00433578)    );
  // itree = 385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629956,0.0135214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3125,-0.0204631) , 
3, -0.878172, 1, 0, 0.515493,0.0363099) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221709,-0.00258622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208385,0.0127094) , 
0, 0.22964, 1, 0, 0.215265,-0.0118812) , 
1, -0.840753, 1, 0, 0.267717,-0.003462)    );
  // itree = 386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367164,0.00385427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192905,-0.00313786) , 
3, -0.594351, 1, 0, 0.267176,0.004197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15873,-0.00529758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2375,0.0237778) , 
1, 0.0488807, 1, 0, 0.215247,-0.0464715) , 
0, 0.900791, 1, 0, 0.255699,-0.00700128)    );
  // itree = 387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0807611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259446,0.00672704) , 
0, 0.30526, 1, 0, 0.0940639,0.0228477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545455,0.0379048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405063,-0.00164422) , 
0, -0.192062, 1, 0, 0.454118,-0.0205999) , 
1, 0.568457, 1, 0, 0.251414,0.00386032)    );
  // itree = 388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0899471,-0.011417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480799,0.0267891) , 
3, -0.515634, 1, 0, 0.298851,0.0234193) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0719305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229167,-0.00612457) , 
0, -0.508877, 1, 0, 0.190896,-0.0282417) , 
1, 0.909404, 1, 0, 0.260137,0.00489316)    );
  // itree = 389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547619,0.0228261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183529,-0.0442544) , 
2, -0.566293, 1, 0, 0.354919,-0.0225171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209719,-0.00150092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,0.0095377) , 
1, 1.22177, 1, 0, 0.17198,0.0261603) , 
3, -0.435343, 1, 0, 0.245614,0.00656734)    );
  // itree = 390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208633,-0.0097371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275036,0.00106708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159389,-0.0136685) , 
0, 0.873363, 1, 0, 0.246187,-0.00842763) , 
1, -1.29934, 1, 0, 0.243544,-0.000508346)    );
  // itree = 391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016,-0.0129665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0404624,-0.0431488) , 
3, -1.52154, 1, 0, 0.0302013,0.0325373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297741,0.0174303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27044,-0.0131182) , 
3, 0.216588, 1, 0, 0.285472,-0.0149922) , 
1, -0.840753, 1, 0, 0.24867,-0.00813989)    );
  // itree = 392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0631868,-0.0140263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456471,0.0337621) , 
3, -0.987872, 1, 0, 0.275032,0.0297805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226606,-0.010948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496124,0.0343593) , 
1, 1.61093, 1, 0, 0.255127,-0.00651523) , 
1, 0.00862622, 1, 0, 0.262948,0.0077464)    );
  // itree = 393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352159,-0.00391898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239517,0.001533) , 
0, -0.933673, 1, 0, 0.2576,-0.00877869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0692308,-0.00686399) , 
3, 1.91538, 1, 0, 0.245387,0.000396184)    );
  // itree = 394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38254,0.0032546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126195,-0.0164174) , 
3, -0.44585, 1, 0, 0.266262,0.0144899) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.030303,-0.0741951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283647,0.0186074) , 
2, -0.335015, 1, 0, 0.234813,-0.0208392) , 
1, 0.583399, 1, 0, 0.252862,-0.000563218)    );
  // itree = 395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00331858,-0.0758663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43318,0.0346052) , 
0, 0.900791, 1, 0, 0.0865299,0.0334838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.852381,0.0786683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34492,-0.00546347) , 
2, -0.230069, 1, 0, 0.456159,-0.0269067) , 
1, 0.51317, 1, 0, 0.256854,0.00565597)    );
  // itree = 396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0901639,-0.00659904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486301,0.0542237) , 
3, -0.728767, 1, 0, 0.203125,0.0271844) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0713376,-0.0396791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477243,0.00680453) , 
3, 0.308814, 1, 0, 0.272201,-0.0114579) , 
0, -0.617366, 1, 0, 0.255082,-0.00188146)    );
  // itree = 397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48538,0.00417663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187891,-0.00137798) , 
1, -0.450788, 1, 0, 0.266154,-0.000910618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0639513) , 
0, 1.55221, 1, 0, 0.265276,-0.00757013)    );
  // itree = 398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243523,0.00679741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265526,0.00224805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168317,0.000360995) , 
0, 1.31425, 1, 0, 0.254494,-0.0118507) , 
1, -1.13162, 1, 0, 0.253421,-0.00573526)    );
  // itree = 399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.04038,-0.0224765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117904,-0.00977145) , 
3, -0.850554, 1, 0, 0.0807736,0.0230645) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392345,-0.00162104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351974,0.0404468) , 
3, 1.08546, 1, 0, 0.381579,-0.0410712) , 
1, 0.144707, 1, 0, 0.250619,-0.0131488)    );
  // itree = 400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257143,0.074371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237366,0.00137991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245614,-0.0288035) , 
0, 0.675014, 1, 0, 0.239872,-0.0124347) , 
0, -1.68098, 1, 0, 0.240787,-0.0061551)    );
  // itree = 401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369863,-0.00574057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347095,-0.00843141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161107,-0.00794913) , 
3, -0.481655, 1, 0, 0.225704,-0.00339467) , 
0, -1.43147, 1, 0, 0.236077,0.00218873)    );
  // itree = 402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290578,0.00261776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190355,-0.00526823) , 
1, 1.28142, 1, 0, 0.266747,0.00264074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109948,-0.0329779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188235,0.00985622) , 
1, 0.536577, 1, 0, 0.146814,-0.0469525) , 
0, 1.08217, 1, 0, 0.245292,-0.00623099)    );
  // itree = 403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117557,-0.0273472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624217,0.0291713) , 
1, 1.21354, 1, 0, 0.253214,-0.000949961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443878,0.0507512) , 
0, 1.38948, 1, 0, 0.27204,-0.00938632)    );
  // itree = 404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.040404,-0.0379727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458333,0.0725224) , 
3, -1.58724, 1, 0, 0.269406,0.0553184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176715,-0.0169227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651639,0.0158019) , 
3, 1.35645, 1, 0, 0.245406,-0.0130352) , 
1, -0.999833, 1, 0, 0.248164,-0.00518135)    );
  // itree = 405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585106,0.0130991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257554,-0.00230271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.092827,-0.00813342) , 
3, 0.939027, 1, 0, 0.215665,-0.00180523) , 
1, -1.19679, 1, 0, 0.249513,0.0056153)    );
  // itree = 406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415966,0.00793667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253886,0.00559327) , 
0, -1.07088, 1, 0, 0.275533,0.00515342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,0.000621941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206452,0.0306036) , 
3, 0.903218, 1, 0, 0.2,-0.0665891) , 
0, 1.28629, 1, 0, 0.265916,-0.00398129)    );
  // itree = 407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208745,0.022672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276634,-0.0083998) , 
3, -0.659596, 1, 0, 0.250274,-6.60393e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440367,0.0433715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165049,-0.0477259) , 
2, 1.84146, 1, 0, 0.306604,-0.0688093) , 
2, 1.55405, 1, 0, 0.256133,-0.00721696)    );
  // itree = 408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273256,0.00823314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0944882,-0.0339179) , 
1, 1.09845, 1, 0, 0.225053,-0.00175857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851485,0.041958) , 
3, 1.97947, 1, 0, 0.256927,0.00341911)    );
  // itree = 409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422222,0.0229187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13089,-0.0295554) , 
2, 0.257727, 1, 0, 0.312253,-0.0169891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0856164,-0.0138117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0256684) , 
2, 1.45206, 1, 0, 0.0791855,0.0450385) , 
3, 0.897545, 1, 0, 0.259694,-0.00300122)    );
  // itree = 410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12037,-0.0492615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194539,-0.0282213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334359,0.0394479) , 
2, 0.147227, 1, 0, 0.268069,-0.0133649) , 
1, -1.44249, 1, 0, 0.259939,-0.00908168)    );
  // itree = 411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0052356,-0.0582079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335206,0.0390084) , 
1, -0.976786, 1, 0, 0.248276,-0.0234812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24569,-0.0108779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245983,-0.0160648) , 
0, 0.0820385, 1, 0, 0.245876,0.0195035) , 
3, -0.580667, 1, 0, 0.246747,0.00390599)    );
  // itree = 412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224719,0.0358724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230517,-0.0103799) , 
1, -1.14885, 1, 0, 0.229912,-0.00827905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0253165,-0.0848393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657407,-0.00216738) , 
3, 1.32992, 1, 0, 0.281955,-0.062026) , 
2, 1.46433, 1, 0, 0.236936,-0.0155326)    );
  // itree = 413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288004,0.00966327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0803571,0.00496272) , 
3, 1.659, 1, 0, 0.275898,-0.0118507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686275,-0.00408038) , 
3, 1.99526, 1, 0, 0.265447,-0.00581611)    );
  // itree = 414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561905,0.0582278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334465,-0.00426177) , 
3, -2.02313, 1, 0, 0.368876,-0.0252408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168367,-0.0183437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208235,0.0117707) , 
0, -0.0179641, 1, 0, 0.195652,0.0133131) , 
3, -0.610112, 1, 0, 0.257748,-0.000507375)    );
  // itree = 415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189944,0.00296714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284211,0.000656809) , 
2, -0.0874936, 1, 0, 0.231726,-0.0206027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309783,0.00346424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235099,-0.00921754) , 
0, 0.797129, 1, 0, 0.276119,0.0156149) , 
3, 0.467199, 1, 0, 0.246933,-0.0081969)    );
  // itree = 416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782241,-0.0130876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483871,0.0283674) , 
3, -0.663668, 1, 0, 0.279318,0.0221438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156934,-0.0310875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259036,-0.00487752) , 
0, 0.364598, 1, 0, 0.205545,-0.0262798) , 
1, 0.259956, 1, 0, 0.240423,-0.00338599)    );
  // itree = 417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494253,0.0208001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1883,-0.0287254) , 
2, -0.369485, 1, 0, 0.337699,-0.00947149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155585,0.00864976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19214,0.0179545) , 
0, 1.18687, 1, 0, 0.164118,0.0268796) , 
3, -0.0530968, 1, 0, 0.254634,0.00792383)    );
  // itree = 418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384146,-0.00180012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244071,0.0017064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193758,-0.00975145) , 
1, 0.840541, 1, 0, 0.222347,-0.00489611) , 
0, -1.25174, 1, 0, 0.23599,0.00259154)    );
  // itree = 419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2282,0.00842686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322222,0.00424734) , 
3, 0.158612, 1, 0, 0.262881,0.00420406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306569,0.0159924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227642,-0.0321881) , 
1, 1.40284, 1, 0, 0.269231,-0.0543147) , 
2, 1.46214, 1, 0, 0.263719,-0.00352708)    );
  // itree = 420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188144,0.00498056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543103,0.0339482) , 
3, 0.735558, 1, 0, 0.247135,0.0182485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191489,-0.040917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261538,-0.0159222) , 
1, 0.583004, 1, 0, 0.2263,-0.043711) , 
0, 0.6269, 1, 0, 0.240488,-0.00151809)    );
  // itree = 421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.00871524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129815,-0.0034183) , 
3, -0.0905164, 1, 0, 0.244389,0.0207273) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144681,-0.0235349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281553,0.0629346) , 
0, 1.52159, 1, 0, 0.186391,-0.0366496) , 
0, 1.08209, 1, 0, 0.234295,0.010741)    );
  // itree = 422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319328,0.00828702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,-0.0197776) , 
3, -1.39549, 1, 0, 0.212851,0.0590034) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352263,0.00932742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106457,-0.0161964) , 
3, 0.620308, 1, 0, 0.269412,-0.00242884) , 
1, -0.910541, 1, 0, 0.262186,0.00541961)    );
  // itree = 423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0762319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,0.00986843) , 
0, -0.446466, 1, 0, 0.0298507,0.0581876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276027,-0.00568958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208955,0.0074452) , 
3, 1.34924, 1, 0, 0.265625,-0.00915893) , 
1, -1.06103, 1, 0, 0.241058,-0.00214149)    );
  // itree = 424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125581,0.0264016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0190476,-0.0668764) , 
2, -0.582275, 1, 0, 0.0729412,-0.0117316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423448,0.0201648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318182,-0.00916926) , 
0, 0.732248, 1, 0, 0.382477,0.0181813) , 
3, -0.347261, 1, 0, 0.253314,0.00569924)    );
  // itree = 425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368785,-0.00243594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0978261,-0.0209996) , 
3, -0.197913, 1, 0, 0.263514,0.0312781) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198592,-0.00565206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673077,-0.0123091) , 
3, 1.97783, 1, 0, 0.181818,-0.0188909) , 
0, 0.30526, 1, 0, 0.23023,0.0108388)    );
  // itree = 426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427873,0.0142795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173989,-0.0279969) , 
3, -0.932474, 1, 0, 0.280164,0.0187383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273492,0.0121396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0960854,-0.0151806) , 
3, 1.08766, 1, 0, 0.22334,-0.0264057) , 
0, -0.0142405, 1, 0, 0.251521,-0.00401688)    );
  // itree = 427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198795,0.0339134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26338,0.00389743) , 
2, -0.636999, 1, 0, 0.236755,-0.0193479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243945,-0.0211116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268775,-0.00299967) , 
0, 1.03549, 1, 0, 0.251504,0.0258826) , 
3, 0.159145, 1, 0, 0.242766,-0.000914097)    );
  // itree = 428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269939,0.0646576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24581,-0.000484485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421348,0.0385635) , 
0, 1.44407, 1, 0, 0.263276,0.0061303) , 
0, -1.37918, 1, 0, 0.263832,0.0132998)    );
  // itree = 429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357616,-0.0127636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351415,0.00500793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159478,0.00678936) , 
3, -0.0786923, 1, 0, 0.247696,-0.000480842) , 
0, -1.43147, 1, 0, 0.256012,0.00534179)    );
  // itree = 430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.089172,-0.0713732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475352,0.0313586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226824,-0.00133718) , 
3, -1.21442, 1, 0, 0.265928,0.00710468) , 
2, -1.52711, 1, 0, 0.251784,0.00199293)    );
  // itree = 431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0793383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0926078) , 
3, -1.61775, 1, 0, 0,0.105714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253629,-0.00503502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332215,0.0160565) , 
3, 0.571062, 1, 0, 0.280136,-0.00356311) , 
0, -1.17397, 1, 0, 0.2475,0.00916769)    );
  // itree = 432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16,0.0109116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0263591,-0.0459871) , 
0, -1.52344, 1, 0, 0.0452617,-0.0235646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37844,0.0186329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314149,-0.0155901) , 
0, 0.878853, 1, 0, 0.357642,0.0138605) , 
3, -0.580667, 1, 0, 0.246994,0.000604195)    );
  // itree = 433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312169,-0.0173933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315195,0.000370394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130178,-0.00292601) , 
3, 0.147093, 1, 0, 0.229247,0.00616663) , 
0, -1.26434, 1, 0, 0.237052,0.0133763)    );
  // itree = 434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326531,-0.00205398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0932203,-0.0319443) , 
3, -1.08973, 1, 0, 0.212058,0.0522001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366158,0.00338519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15067,-0.0103348) , 
3, -0.024141, 1, 0, 0.246753,-0.00307999) , 
1, -0.484715, 1, 0, 0.238799,0.00959385)    );
  // itree = 435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0856879) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16527,-0.0113576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560694,0.0219748) , 
1, 1.2054, 1, 0, 0.277293,-0.0163945) , 
0, -1.43147, 1, 0, 0.257606,-0.0122853)    );
  // itree = 436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271795,0.0601834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203704,-0.0261173) , 
0, -0.130442, 1, 0, 0.247525,0.0408366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0669693,-0.0360161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433162,0.00921284) , 
3, 0.198434, 1, 0, 0.238698,-0.00860977) , 
1, -0.840753, 1, 0, 0.240061,-0.000973548)    );
  // itree = 437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381443,0.00556559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,-0.0129148) , 
1, 0.863356, 1, 0, 0.274924,0.00785316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126126,-0.0429283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171233,0.00914866) , 
2, -0.0160937, 1, 0, 0.158809,-0.030953) , 
0, 0.948657, 1, 0, 0.252187,0.00025408)    );
  // itree = 438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341646,-0.0104943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311741,-0.00116805) , 
0, -0.588183, 1, 0, 0.32514,-0.0107747) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0849421,-0.0240157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188525,0.000486944) , 
1, 0.098775, 1, 0, 0.16442,0.0247941) , 
3, -0.343942, 1, 0, 0.236056,0.00894045)    );
  // itree = 439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208268,-0.00400127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278119,-0.0106087) , 
3, 0.436698, 1, 0, 0.227555,0.0200982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,-0.0038136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.059322,-0.0714707) , 
3, 1.26568, 1, 0, 0.222727,-0.0454786) , 
2, 1.53606, 1, 0, 0.227022,0.0128522)    );
  // itree = 440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273782,0.0359655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233051,-0.00456666) , 
1, -0.33754, 1, 0, 0.245818,0.0110253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103516,-0.0410395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73743,0.0239672) , 
3, 1.53993, 1, 0, 0.267728,-0.0211004) , 
0, 0.57508, 1, 0, 0.253146,0.000280466)    );
  // itree = 441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00759006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301695,0.000470194) , 
3, -0.909406, 1, 0, 0.383234,0.0173808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148837,0.0100079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0787879,0.00383861) , 
3, 1.67958, 1, 0, 0.137561,-0.0273105) , 
1, 0.432054, 1, 0, 0.259003,-0.00521838)    );
  // itree = 442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.472603,0.0294881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228368,-0.00942669) , 
3, -1.75586, 1, 0, 0.256511,0.0127927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167339,-0.0214292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360947,0.0702093) , 
1, 1.5456, 1, 0, 0.216541,-0.0319828) , 
1, 1.01701, 1, 0, 0.242754,-0.00261916)    );
  // itree = 443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0854573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243354,-0.00323084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418182,0.0220951) , 
0, 1.06676, 1, 0, 0.279698,-0.00693292) , 
0, -1.35128, 1, 0, 0.256055,-0.00148634)    );
  // itree = 444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313035,0.0175954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143376,-0.0223502) , 
1, 0.939437, 1, 0, 0.254682,0.00863643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,-0.0628586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282051,-0.0163893) , 
1, 0.0643141, 1, 0, 0.226361,-0.0465009) , 
0, 1.07303, 1, 0, 0.249616,-0.00122668)    );
  // itree = 445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466135,0.00931707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171908,-0.0345897) , 
2, -0.402511, 1, 0, 0.322778,-0.0217601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.07,-0.0490237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18551,0.0182689) , 
2, -0.737804, 1, 0, 0.174085,0.0157196) , 
3, -0.112181, 1, 0, 0.247236,-0.00271893)    );
  // itree = 446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360176,0.00400452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105461,-0.0216445) , 
3, -0.226556, 1, 0, 0.248764,0.0142037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00598802,-0.0846324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26138,0.00734936) , 
2, -0.478644, 1, 0, 0.211085,-0.0258808) , 
1, 0.767416, 1, 0, 0.233269,-0.00228112)    );
  // itree = 447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0196078,-0.0115607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610619,0.0707613) , 
1, -0.164953, 1, 0, 0.230284,-0.0395271) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.000160761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258427,-0.010667) , 
0, -0.937814, 1, 0, 0.247387,0.0145124) , 
3, -1.32666, 1, 0, 0.244728,0.00611096)    );
  // itree = 448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0821736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335366,0.0572093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25716,-0.000109719) , 
1, -1.03676, 1, 0, 0.264266,0.00779118) , 
3, -1.98613, 1, 0, 0.248956,0.00283537)    );
  // itree = 449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426087,-0.026715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345853,0.0020711) , 
3, -1.35051, 1, 0, 0.367089,0.0160649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252874,0.0241477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934891,0.00513376) , 
1, 1.07569, 1, 0, 0.167707,-0.0252477) , 
1, 0.227361, 1, 0, 0.254774,-0.00720716)    );
  // itree = 450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340364,0.000955609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110465,-0.0216825) , 
3, 0.151252, 1, 0, 0.264272,0.00447529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102941,-0.0330296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187654,-0.00340351) , 
1, -0.0525078, 1, 0, 0.166359,-0.041435) , 
0, 0.780176, 1, 0, 0.239048,-0.00735206)    );
  // itree = 451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192923,-0.0132285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312016,-1.708e-05) , 
3, 0.3925, 1, 0, 0.229008,-0.00557516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644444,0.0651881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183673,-0.00318926) , 
2, 0.887673, 1, 0, 0.404255,-0.0434063) , 
0, 1.2265, 1, 0, 0.253904,-0.0109497)    );
  // itree = 452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828729,-0.00699559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561644,0.0546773) , 
3, -1.04142, 1, 0, 0.296636,0.0482046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0757946,-0.030643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414425,0.00613129) , 
3, 0.113891, 1, 0, 0.24511,-0.0066721) , 
1, -0.796791, 1, 0, 0.253693,0.00246936)    );
  // itree = 453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353266,0.00635036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114865,-0.00467577) , 
3, 0.222278, 1, 0, 0.269208,0.0104544) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220472,-0.0147402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139831,0.00491125) , 
1, 0.0972641, 1, 0, 0.168044,-0.0365387) , 
0, 1.07303, 1, 0, 0.251224,0.00210061)    );
  // itree = 454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225225,-0.0421208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447368,0.00546462) , 
1, -0.605898, 1, 0, 0.337778,0.0590447) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267196,0.00742027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211816,-0.000533287) , 
1, 0.909504, 1, 0, 0.246171,-0.00891388) , 
0, -1.1012, 1, 0, 0.25621,-0.00146591)    );
  // itree = 455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0828001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468468,0.00969804) , 
1, 0.877893, 1, 0, 0.12065,0.0366967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274336,-0.00411955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307571,0.0028669) , 
3, 0.45939, 1, 0, 0.288036,-0.00231506) , 
0, -0.691888, 1, 0, 0.251397,0.00622433)    );
  // itree = 456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246002,0.00580238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122642,-0.0486124) , 
0, 1.17934, 1, 0, 0.231774,-0.000488338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841667,0.0361714) , 
3, 1.87344, 1, 0, 0.269152,0.00461803)    );
  // itree = 457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391026,0.00327417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144828,-0.00174104) , 
3, -0.700559, 1, 0, 0.31291,0.0426545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280551,-0.000706265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621891,-0.020903) , 
1, 1.29547, 1, 0, 0.224425,-0.00615999) , 
0, -0.691888, 1, 0, 0.244433,0.00487822)    );
  // itree = 458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302714,-0.00164085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189591,0.0108548) , 
0, -0.00935426, 1, 0, 0.262032,0.00566676) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305037,0.0115394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.053719,-0.0405776) , 
3, 1.44094, 1, 0, 0.258752,-0.0175416) , 
1, -0.0382711, 1, 0, 0.259942,-0.00912264)    );
  // itree = 459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192575,0.0195624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274823,0.0253605) , 
2, -0.571895, 1, 0, 0.239196,-0.0101206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121043,-0.0156817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384146,-0.0113847) , 
1, 0.878112, 1, 0, 0.246842,0.0202934) , 
3, -0.139172, 1, 0, 0.243083,0.00534183)    );
  // itree = 460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,-0.00765871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460087,0.0183721) , 
3, 0.178242, 1, 0, 0.243067,0.00943432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240385,-0.0279687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,-0.0426976) , 
2, 1.81259, 1, 0, 0.274038,-0.0573659) , 
2, 1.51846, 1, 0, 0.246214,0.00264661)    );
  // itree = 461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344515,0.00418216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0360397) , 
2, 0.2817, 1, 0, 0.254454,0.00385539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540541,-0.0325822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0961538,0.0112102) , 
2, 1.26278, 1, 0, 0.0744186,-0.0686437) , 
3, 1.55602, 1, 0, 0.235206,-0.00389564)    );
  // itree = 462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386318,0.00307892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190889,-0.0139103) , 
3, -0.730312, 1, 0, 0.292276,0.0109989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104762,-0.0339589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228052,0.00643779) , 
1, -0.689672, 1, 0, 0.216241,-0.0183156) , 
0, -0.0763418, 1, 0, 0.251704,-0.00464311)    );
  // itree = 463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114447,0.000199206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26078,0.00362737) , 
3, -0.708228, 1, 0, 0.184314,0.0171929) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.691729,0.0847084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248079,-0.0176059) , 
2, -0.916838, 1, 0, 0.304598,-0.0219693) , 
0, -0.0324937, 1, 0, 0.245155,-0.00261592)    );
  // itree = 464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132964,0.0213991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828025,-0.037527) , 
2, -0.831083, 1, 0, 0.0986038,-0.0182893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538278,0.027489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358242,-0.0052702) , 
0, 0.631454, 1, 0, 0.444444,0.0212921) , 
3, 0.0840329, 1, 0, 0.248143,-0.00117459)    );
  // itree = 465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447205,-0.0122424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311245,-0.0121181) , 
3, -1.80267, 1, 0, 0.344461,-0.0235887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124324,-0.020521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205691,0.008781) , 
0, -0.557783, 1, 0, 0.195053,0.0139588) , 
3, -0.707321, 1, 0, 0.242527,0.00202833)    );
  // itree = 466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105085,-0.064541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438995,0.0288745) , 
2, -0.930873, 1, 0, 0.351901,-0.0263178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0973684,-0.0257947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213573,0.0223218) , 
0, 0.479025, 1, 0, 0.163451,0.015857) , 
3, 0.130099, 1, 0, 0.269384,-0.00785059)    );
  // itree = 467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0781716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0458716,-0.0403239) , 
3, -1.42576, 1, 0, 0.0205761,0.0534504) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121272,-0.010946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505291,0.0113314) , 
1, 0.770313, 1, 0, 0.286039,-0.00805297) , 
0, -1.05347, 1, 0, 0.253865,-0.000598946)    );
  // itree = 468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,0.039309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23554,-0.0058036) , 
1, -1.09844, 1, 0, 0.239264,-0.00039826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0310078,-0.0827937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346154,-0.0142864) , 
2, 0.289248, 1, 0, 0.241645,-0.0445228) , 
0, 1.00007, 1, 0, 0.239723,-0.00889972)    );
  // itree = 469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439252,-0.0192116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334728,-0.00613858) , 
3, -1.92035, 1, 0, 0.367052,-0.0326159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295302,0.0214418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224557,0.00982228) , 
0, -0.917883, 1, 0, 0.230861,0.00294893) , 
3, -1.30738, 1, 0, 0.254212,-0.00314891)    );
  // itree = 470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289902,-0.000935583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113269,-0.0341914) , 
0, 0.780176, 1, 0, 0.245528,0.0173668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189655,-0.021834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215789,0.00714794) , 
0, -0.528422, 1, 0, 0.209677,-0.0265702) , 
1, 0.863356, 1, 0, 0.232016,0.000806959)    );
  // itree = 471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196944,0.0148199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282246,0.0125441) , 
2, -0.390196, 1, 0, 0.241987,-0.018353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343826,0.00864275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182663,-0.0251899) , 
2, 0.886393, 1, 0, 0.273098,0.0208762) , 
3, 0.356305, 1, 0, 0.253528,-0.00380022)    );
  // itree = 472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314024,0.0354987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183333,-0.0133905) , 
1, 0.672427, 1, 0, 0.267717,0.0272789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106858,-0.0399917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562069,-0.000463417) , 
3, 1.09883, 1, 0, 0.250818,-0.0304345) , 
0, 0.0686318, 1, 0, 0.2597,-9.9875e-05)    );
  // itree = 473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373868,-0.0110047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19201,-0.00432962) , 
3, -0.35283, 1, 0, 0.282763,0.0273416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0663265,-0.0183279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0771812,-0.00510315) , 
2, 0.579924, 1, 0, 0.0728745,-0.0240669) , 
1, 1.27218, 1, 0, 0.232012,0.014911)    );
  // itree = 474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225583,-0.0129326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493458,0.0594276) , 
2, 0.554158, 1, 0, 0.310284,0.000954841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0811153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0754717,-0.0322073) , 
2, 0.670402, 1, 0, 0.0511182,-0.0440497) , 
3, 1.27365, 1, 0, 0.269825,-0.0060708)    );
  // itree = 475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.078067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151943,0.00817472) , 
0, -0.621361, 1, 0, 0.0970655,0.0197533) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413625,0.0100595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334286,-0.0141407) , 
0, -0.0701772, 1, 0, 0.363636,-0.0125764) , 
1, 0.162984, 1, 0, 0.245368,0.00176719)    );
  // itree = 476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0209974,-0.0571441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283539,0.00345863) , 
3, -1.24052, 1, 0, 0.226705,-0.00517329) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0408163,-0.0797699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645455,-0.00597917) , 
3, 1.38367, 1, 0, 0.299611,-0.0573422) , 
2, 1.46214, 1, 0, 0.235994,-0.0118205)    );
  // itree = 477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339093,0.0121842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0877193,-0.013242) , 
3, 1.06493, 1, 0, 0.303649,-0.0160258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.019802,-0.0752151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0597826,-0.0321128) , 
3, 1.08579, 1, 0, 0.0388601,0.0320446) , 
2, 1.12881, 1, 0, 0.252621,-0.0067621)    );
  // itree = 478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209101,-0.0268693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394397,0.0505347) , 
2, 0.304412, 1, 0, 0.271089,0.00589768) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244851,-0.00894737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134615,0.0113822) , 
3, 1.06012, 1, 0, 0.209302,-0.0503605) , 
1, 1.01709, 1, 0, 0.251476,-0.0119598)    );
  // itree = 479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254015,0.00122313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392157,0.102813) , 
3, 1.59694, 1, 0, 0.261918,-0.00429333) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,0.00409095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105769,-0.045066) , 
3, 1.07875, 1, 0, 0.25,-0.0659656) , 
2, 1.51846, 1, 0, 0.260695,-0.0106251)    );
  // itree = 480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623656,-0.022929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379452,0.0285758) , 
3, -0.913399, 1, 0, 0.256067,0.0225851) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118462,-0.0271301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672646,0.0144393) , 
3, 1.37269, 1, 0, 0.260023,-0.01287) , 
0, 0.297203, 1, 0, 0.257737,0.00761785)    );
  // itree = 481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488,-0.0142703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382114,0.00974768) , 
3, -2.02313, 1, 0, 0.4,-0.0239369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925926,-0.0513222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191544,0.00289637) , 
2, -0.949328, 1, 0, 0.18311,0.0277778) , 
3, -0.610112, 1, 0, 0.263079,0.00871013)    );
  // itree = 482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369632,0.0044715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201242,-0.00468328) , 
3, -0.638748, 1, 0, 0.276596,0.0166643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231144,-0.00369388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109827,-0.0035643) , 
3, 1.38148, 1, 0, 0.195205,-0.0231973) , 
0, 0.676581, 1, 0, 0.253307,0.00525853)    );
  // itree = 483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679134,-0.0439713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662577,0.0379607) , 
1, 1.30089, 1, 0, 0.21237,0.00849168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440449,0.012741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0380952,-0.045364) , 
3, 1.70477, 1, 0, 0.363636,-0.0265646) , 
0, 0.759972, 1, 0, 0.256343,-0.00169909)    );
  // itree = 484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0310078,-0.049885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41573,0.0653639) , 
3, -1.67289, 1, 0, 0.254072,0.045896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485294,-0.0380124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391304,0.00262449) , 
3, -0.166898, 1, 0, 0.251648,-0.00842698) , 
0, -0.940853, 1, 0, 0.252024,1.28682e-05)    );
  // itree = 485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,0.00942769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340351,-0.000847132) , 
0, -1.64858, 1, 0, 0.349845,-0.0130951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106557,-0.0269466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17607,0.0128897) , 
2, -0.757282, 1, 0, 0.168696,0.018812) , 
3, -0.151872, 1, 0, 0.251534,0.00422117)    );
  // itree = 486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367722,0.00966645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0317086) , 
3, 0.178242, 1, 0, 0.27416,0.010252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184906,-0.0145075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239669,0.0097342) , 
0, 0.213984, 1, 0, 0.211045,-0.0252523) , 
1, 1.21709, 1, 0, 0.257884,0.00109601)    );
  // itree = 487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0781157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0379747,-0.0600622) , 
3, -1.67929, 1, 0, 0.0208333,0.0377041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291209,0.0204328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276842,-0.00524707) , 
3, -0.0552135, 1, 0, 0.283075,-0.0143911) , 
0, -0.972742, 1, 0, 0.244659,-0.00675969)    );
  // itree = 488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136669,-0.0136009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524664,0.0138795) , 
3, 0.656214, 1, 0, 0.233613,-0.00381422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135135,-0.0750698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33557,-0.0171083) , 
1, 0.422751, 1, 0, 0.25,-0.0575922) , 
0, 1.28629, 1, 0, 0.235697,-0.0106515)    );
  // itree = 489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335156,0.0051505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0479233,-0.0298976) , 
1, 1.35667, 1, 0, 0.278719,0.00666922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154122,-0.0100294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246154,0.0425681) , 
0, 1.541, 1, 0, 0.183374,-0.0450923) , 
0, 1.00007, 1, 0, 0.259241,-0.00390544)    );
  // itree = 490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396122,0.0109354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161787,-0.00929923) , 
3, -0.287708, 1, 0, 0.285193,-0.000373912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106918,-0.0239121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212048,0.000757119) , 
1, 0.00448539, 1, 0, 0.182927,-0.0366038) , 
0, 0.676581, 1, 0, 0.255013,-0.0110659)    );
  // itree = 491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0837438,0.00308614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132196,0.000135072) , 
3, -0.467933, 1, 0, 0.104824,0.00623207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569678,0.0272266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248387,-0.0157322) , 
2, 1.19286, 1, 0, 0.466251,-0.0190228) , 
1, 0.51317, 1, 0, 0.275355,-0.00568387)    );
  // itree = 492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.034188,-0.0393075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370021,0.0177096) , 
3, -1.15288, 1, 0, 0.279693,0.0133232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0394737,-0.0680834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263432,0.00242287) , 
2, -0.0446769, 1, 0, 0.2,-0.0155438) , 
1, 0.75851, 1, 0, 0.249289,0.00230998)    );
  // itree = 493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318681,0.00922032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670391,-0.0412248) , 
2, 1.3076, 1, 0, 0.292584,0.00694382) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0508475,-0.0288756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0960452,-0.0016317) , 
2, 0.88807, 1, 0, 0.0779661,-0.0482889) , 
3, 1.3043, 1, 0, 0.261257,-0.00111836)    );
  // itree = 494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384615,0.00521822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151329,-0.00823544) , 
3, -0.683288, 1, 0, 0.271556,0.0197934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679612,-0.0489033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281038,0.00774847) , 
2, -0.336733, 1, 0, 0.240842,-0.0109283) , 
1, 0.328845, 1, 0, 0.255593,0.00382573)    );
  // itree = 495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185022,0.0228036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323651,0.0444682) , 
2, -0.979329, 1, 0, 0.279267,-0.0142029) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940171,-0.0207573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2835,-0.00732086) , 
1, -0.244742, 1, 0, 0.250188,0.0232809) , 
3, -0.610112, 1, 0, 0.260294,0.0102535)    );
  // itree = 496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111285,-0.0108304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549419,0.0238915) , 
3, -0.245906, 1, 0, 0.264766,0.00919795) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00598802,-0.0885639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260045,-0.00407999) , 
2, -0.475893, 1, 0, 0.220132,-0.0162497) , 
1, 0.22651, 1, 0, 0.241565,-0.00402985)    );
  // itree = 497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483871,-0.0186491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366372,-0.00627343) , 
3, -1.70989, 1, 0, 0.391667,0.0187583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180135,0.00849953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0891089,0.0113071) , 
3, 1.90546, 1, 0, 0.173002,-0.0158025) , 
1, -0.0997873, 1, 0, 0.251369,-0.00341633)    );
  // itree = 498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552846,0.028207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290909,-0.0181896) , 
3, -1.61838, 1, 0, 0.429185,0.0637018) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226341,-0.00576695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21875,0.00262293) , 
1, 1.21354, 1, 0, 0.224157,-0.00323359) , 
0, -1.16999, 1, 0, 0.247889,0.00451403)    );
  // itree = 499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255045,-0.000345159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311594,0.0922108) , 
3, 1.65076, 1, 0, 0.259105,1.23085e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0458716,-0.114868) , 
1, 1.65151, 1, 0, 0.247661,-0.00763763)    );
  // itree = 500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0945946,-0.00629147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517176,0.0285247) , 
3, -0.373137, 1, 0, 0.280672,0.0222793) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0615385,-0.0942481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23252,0.00040448) , 
0, -0.612066, 1, 0, 0.202685,-0.021816) , 
1, 0.680932, 1, 0, 0.250646,0.00530203)    );
  // itree = 501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427027,0.00510913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169133,-0.0124816) , 
3, 0.0754625, 1, 0, 0.339771,0.0215759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0810811,-0.00393537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124211,0.0251013) , 
0, -0.50255, 1, 0, 0.113965,-0.0206133) , 
1, 0.987081, 1, 0, 0.270163,0.00857054)    );
  // itree = 502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241692,-0.00677827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522876,0.0605545) , 
2, 1.49807, 1, 0, 0.265487,-0.000830047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939227,0.00513871) , 
3, 1.64499, 1, 0, 0.249874,-0.00655869)    );
  // itree = 503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228055,0.00762055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282164,-0.0169532) , 
3, 0.197992, 1, 0, 0.248104,0.00603814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170886,0.0542409) , 
3, 1.76176, 1, 0, 0.242016,-0.000805199)    );
  // itree = 504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253846,0.0285731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131707,-0.0289608) , 
1, 0.829616, 1, 0, 0.21931,0.0161761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143757,-0.0260839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596817,0.0172431) , 
3, 1.07653, 1, 0, 0.27218,-0.00913708) , 
0, -0.362191, 1, 0, 0.253528,-0.000206658)    );
  // itree = 505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493827,-0.00205661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316505,-0.0085916) , 
3, -0.987872, 1, 0, 0.384982,0.0163375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214188,0.0290919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0837104,-0.0192898) , 
2, 0.877064, 1, 0, 0.165106,-0.0164489) , 
1, 0.144707, 1, 0, 0.256703,-0.0027906)    );
  // itree = 506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147059,-0.0239958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243433,-0.00211847) , 
1, -1.42512, 1, 0, 0.238017,0.0026818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422222,0.0563763) , 
2, 1.60075, 1, 0, 0.254637,-0.00330471)    );
  // itree = 507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0825352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276327,0.0053772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314696,0.00544875) , 
3, 0.586766, 1, 0, 0.289575,-0.00943339) , 
0, -1.45539, 1, 0, 0.265957,-0.00364705)    );
  // itree = 508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0373134,-0.0362353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385,0.0494106) , 
3, -1.6676, 1, 0, 0.245509,0.04152) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0320198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447236,0.0120212) , 
3, 0.156632, 1, 0, 0.253547,-0.00050272) , 
0, -0.817158, 1, 0, 0.252174,0.00667661)    );
  // itree = 509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,-0.00244289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230812,-0.00281934) , 
3, -2.00914, 1, 0, 0.245902,-0.00150753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213592,0.0316316) , 
0, 1.58326, 1, 0, 0.244233,-0.00568706)    );
  // itree = 510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483871,0.0180369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179191,-0.02631) , 
3, -1.37919, 1, 0, 0.337047,0.0344428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347156,0.0173971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146732,-0.00152986) , 
3, 0.229216, 1, 0, 0.248943,-0.0169511) , 
0, -0.805343, 1, 0, 0.264647,-0.00779)    );
  // itree = 511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0530035,-0.0529868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663934,0.0320435) , 
1, 1.28147, 1, 0, 0.20227,0.00234547) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.680272,0.0513013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244048,-0.00620947) , 
2, 0.0696759, 1, 0, 0.376812,-0.0414085) , 
0, 0.871315, 1, 0, 0.244826,-0.00832246)    );
  // itree = 512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0719424,-0.0183681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456522,0.0413731) , 
3, -0.708228, 1, 0, 0.225108,0.0206413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205341,-0.0185226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731034,0.015166) , 
3, 1.71171, 1, 0, 0.267262,-0.0166588) , 
0, -0.333741, 1, 0, 0.252079,-0.00322375)    );
  // itree = 513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400398,0.000108115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281421,-0.00774733) , 
0, -0.402053, 1, 0, 0.329822,0.0128955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10219,0.0110582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.099278,0.00172733) , 
0, -0.605273, 1, 0, 0.0998553,-0.0263631) , 
1, 0.857587, 1, 0, 0.247273,-0.00119678)    );
  // itree = 514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,-0.00788775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306011,-0.00523329) , 
0, -1.63293, 1, 0, 0.32485,-0.0210748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0889831,-0.0575836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229264,0.0140885) , 
0, -0.395089, 1, 0, 0.203973,0.008456) , 
3, -0.729479, 1, 0, 0.244815,-0.00152204)    );
  // itree = 515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00546448,-0.0502413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26,0.0189747) , 
1, -1.08336, 1, 0, 0.200511,-0.0237281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249351,-0.00712135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315678,0.00421459) , 
0, 0.732248, 1, 0, 0.274557,0.00398246) , 
3, -0.462334, 1, 0, 0.245926,-0.00673228)    );
  // itree = 516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242718,0.0451278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261111,-0.00750564) , 
0, -0.460677, 1, 0, 0.252616,0.0211956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226606,-0.00779288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312102,-0.0376869) , 
0, 1.35858, 1, 0, 0.23737,-0.0176668) , 
1, -0.0805323, 1, 0, 0.242693,-0.00409738)    );
  // itree = 517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456261,0.0142707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199147,-0.0162195) , 
2, -0.352487, 1, 0, 0.315708,-0.0160843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11745,-0.0214496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138667,0.0435311) , 
1, 0.90081, 1, 0, 0.129272,0.0291464) , 
3, 0.436997, 1, 0, 0.251659,-0.000545616)    );
  // itree = 518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11215,-0.0419973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19802,0.00562012) , 
1, -1.55998, 1, 0, 0.153846,0.0469576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362477,-0.00263888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200639,-0.00232336) , 
3, -0.616189, 1, 0, 0.25,-0.0069362) , 
1, -1.19679, 1, 0, 0.24004,-0.00135358)    );
  // itree = 519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0780607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,0.0720213) , 
0, -1.13818, 1, 0, 0.164706,-0.0466614) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247093,-0.00400319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290862,-0.000641613) , 
3, 0.356424, 1, 0, 0.265893,0.00119856) , 
3, -1.51764, 1, 0, 0.253391,-0.00471437)    );
  // itree = 520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154964,0.0219236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0941597,-0.0406143) , 
2, -0.742079, 1, 0, 0.114217,-0.0187982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.0694425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527961,0.012886) , 
2, -0.322084, 1, 0, 0.462396,0.00811678) , 
3, 0.371425, 1, 0, 0.241117,-0.00898856)    );
  // itree = 521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389706,0.00691856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213166,-0.00258165) , 
0, 0.780176, 1, 0, 0.345397,-1.36529e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547264,-0.0279634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110647,0.013133) , 
0, -0.297086, 1, 0, 0.0941176,-0.0315807) , 
1, 0.940933, 1, 0, 0.257816,-0.011016)    );
  // itree = 522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331163,0.00305665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0874704,-0.0241663) , 
3, 0.409676, 1, 0, 0.26235,0.0158137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0245902,-0.0635683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261438,0.0197435) , 
2, 0.0801233, 1, 0, 0.193925,-0.0280119) , 
0, 0.896613, 1, 0, 0.247144,0.00607469)    );
  // itree = 523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202899,0.0251017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206125,-0.0114834) , 
2, -0.711925, 1, 0, 0.205067,-0.0104944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159036,-0.0127536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,-0.000141322) , 
1, 1.08629, 1, 0, 0.277411,0.027076) , 
3, 0.297184, 1, 0, 0.232178,0.00358522)    );
  // itree = 524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254098,0.0620754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243295,0.00425322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228172,-0.0172651) , 
0, 0.260745, 1, 0, 0.236469,-0.00854142) , 
0, -1.59608, 1, 0, 0.237531,-0.00320764)    );
  // itree = 525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401656,0.0168145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125234,-0.0260596) , 
2, 0.30557, 1, 0, 0.303131,-0.00597559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122807,0.010311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.095057,-0.0100021) , 
2, 0.906928, 1, 0, 0.107943,0.0369631) , 
3, 0.824791, 1, 0, 0.25502,0.0046082)    );
  // itree = 526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351616,0.0116521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0885093,-0.0275019) , 
3, 0.0890925, 1, 0, 0.24985,0.00424439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420792,0.026665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,-0.00447187) , 
3, 1.60124, 1, 0, 0.319079,-0.0361552) , 
2, 1.27188, 1, 0, 0.260538,-0.00199302)    );
  // itree = 527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195911,0.0125696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261069,0.00171238) , 
2, -0.344156, 1, 0, 0.230274,-0.0101904) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309375,0.000329225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0796489) , 
3, 1.91843, 1, 0, 0.265416,0.0224829) , 
3, 0.356305, 1, 0, 0.243461,0.00207027)    );
  // itree = 528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.017094,-0.0731325) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313131,0.0208004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24903,-0.00316426) , 
1, -0.141858, 1, 0, 0.269251,0.00666185) , 
2, -1.63537, 1, 0, 0.2545,0.00275264)    );
  // itree = 529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493333,-0.000487147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302782,-0.00195246) , 
3, -1.01241, 1, 0, 0.375254,0.0203141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156206,0.00994559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0668896,-0.0264366) , 
2, 1.18431, 1, 0, 0.129921,-0.0239786) , 
1, 0.344779, 1, 0, 0.250749,-0.00216411)    );
  // itree = 530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233704,-0.0130809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312977,0.0344618) , 
2, 0.125851, 1, 0, 0.257015,0.0288332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27833,0.00821623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,0.0153095) , 
0, 1.41437, 1, 0, 0.27289,-0.0201862) , 
1, 0.233753, 1, 0, 0.265835,0.00159751)    );
  // itree = 531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152672,0.0180817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225673,-0.0168321) , 
3, -0.888861, 1, 0, 0.2,0.0177648) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4375,0.0399946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40617,0.0176047) , 
1, -0.0257289, 1, 0, 0.414634,-0.0327884) , 
0, 0.759972, 1, 0, 0.25655,0.00444554)    );
  // itree = 532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288534,0.0168863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131635,-0.0262109) , 
1, 0.756695, 1, 0, 0.240391,0.00696194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287554,-0.0520577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266272,-0.0174866) , 
1, 1.34215, 1, 0, 0.278607,-0.0580336) , 
2, 1.07686, 1, 0, 0.248322,-0.00652707)    );
  // itree = 533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381119,0.0110884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109726,-0.0274752) , 
2, 0.630787, 1, 0, 0.31068,-0.0111884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00925926,-0.0667365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104369,-0.00883592) , 
0, -0.0625468, 1, 0, 0.0846154,0.0392596) , 
3, 0.802707, 1, 0, 0.253753,0.00151519)    );
  // itree = 534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39375,-0.0129331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237534,-0.00352631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186016,-0.00992715) , 
1, 0.886747, 1, 0, 0.21655,-0.00689505) , 
0, -1.35128, 1, 0, 0.230579,-0.00135433)    );
  // itree = 535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0840858) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2584,-0.00104523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258706,-0.00996961) , 
3, 0.586766, 1, 0, 0.2585,-0.00151675) , 
0, -1.37918, 1, 0, 0.238903,0.0043395)    );
  // itree = 536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101293,-0.0116812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471248,0.0251523) , 
3, -0.155467, 1, 0, 0.262035,0.0136583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180412,-0.039961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326425,9.71687e-05) , 
1, 0.603403, 1, 0, 0.25323,-0.0252972) , 
0, 1.01723, 1, 0, 0.260355,0.0062245)    );
  // itree = 537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365945,0.00408708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0959147,-0.0196511) , 
3, 0.177006, 1, 0, 0.272448,0.018163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485437,-0.0692283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183962,0.0130069) , 
3, 0.260692, 1, 0, 0.139683,-0.041034) , 
0, 1.07303, 1, 0, 0.250902,0.00855608)    );
  // itree = 538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0122777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252028,-0.000567527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410959,0.0488459) , 
2, 1.70673, 1, 0, 0.264423,-0.0172048) , 
1, -1.28125, 1, 0, 0.257171,-0.0121933)    );
  // itree = 539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231465,0.00560603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309774,3.40673e-05) , 
3, 0.158612, 1, 0, 0.26087,0.00798073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386364,0.0065447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102804,-0.0022575) , 
3, 1.34155, 1, 0, 0.259414,-0.0467182) , 
2, 1.49351, 1, 0, 0.260697,0.00147673)    );
  // itree = 540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0152284,-0.0643669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0148148,-0.0360188) , 
1, -0.484724, 1, 0, 0.0150602,-0.0360578) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289209,0.0154017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307985,-0.0357751) , 
2, 1.42319, 1, 0, 0.292196,0.00962588) , 
3, -1.33425, 1, 0, 0.245844,0.00198509)    );
  // itree = 541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523077,-0.00306578) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28125,-0.00471379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216637,-0.00398491) , 
0, -1.11214, 1, 0, 0.220147,0.00395046) , 
3, -1.91277, 1, 0, 0.240907,-0.000220382)    );
  // itree = 542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231731,-0.00247193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379791,0.0125511) , 
2, 1.0387, 1, 0, 0.25526,0.00377607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10274,0.00229548) , 
3, 1.76176, 1, 0, 0.243852,-0.00070378)    );
  // itree = 543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172875,-0.0090134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289809,-0.0131364) , 
3, 0.19031, 1, 0, 0.216716,0.0100581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619403,0.031215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239264,0.00837981) , 
2, 0.590046, 1, 0, 0.410774,-0.0328394) , 
0, 1.15605, 1, 0, 0.245943,0.00359738)    );
  // itree = 544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0760626,-0.00815072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472973,0.0388948) , 
3, -0.679066, 1, 0, 0.207773,0.0190218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199501,-0.0159603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.784,0.0294458) , 
3, 1.812, 1, 0, 0.254518,-0.0111393) , 
0, -0.419895, 1, 0, 0.238858,-0.00103524)    );
  // itree = 545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282962,0.00286132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0306748,-0.060408) , 
2, 1.36808, 1, 0, 0.260417,-0.000871575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141892,0.0474716) , 
3, 1.76176, 1, 0, 0.251521,-0.00700317)    );
  // itree = 546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359712,-0.0140036) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319337,0.00203145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160085,-0.0105156) , 
3, -0.0805621, 1, 0, 0.238328,-0.00817176) , 
0, -1.46396, 1, 0, 0.246845,-0.00375264)    );
  // itree = 547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483136,-0.0551585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472093,0.0310978) , 
0, 0.782376, 1, 0, 0.167649,0.000656589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.893939,0.0763901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291667,-0.0235722) , 
2, 0.582159, 1, 0, 0.537037,-0.0294272) , 
1, 1.28142, 1, 0, 0.256831,-0.00660657)    );
  // itree = 548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308571,0.0538345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204765,-0.00170072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539683,-0.0190557) , 
3, 1.34414, 1, 0, 0.251524,-0.00805824) , 
0, -1.35128, 1, 0, 0.256566,-0.000394157)    );
  // itree = 549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569966,0.00466616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225564,-0.0335263) , 
3, -0.690667, 1, 0, 0.462441,0.0288032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238232,0.00429705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122047,0.0103444) , 
3, 0.72089, 1, 0, 0.200129,-0.00751364) , 
1, -0.484715, 1, 0, 0.256709,0.000319757)    );
  // itree = 550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403846,0.016504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118785,-0.00434503) , 
3, -0.498617, 1, 0, 0.286848,0.0113368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228395,-0.00693609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387931,0.0616689) , 
1, 1.5842, 1, 0, 0.245404,-0.0230648) , 
1, 0.227361, 1, 0, 0.263959,-0.00766268)    );
  // itree = 551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218468,-0.00594561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327703,0.0113667) , 
2, 0.170268, 1, 0, 0.262162,-0.00944433) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.705426,0.0553313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126904,-0.0358015) , 
2, 0.292709, 1, 0, 0.269598,0.027893) , 
3, 0.802707, 1, 0, 0.264104,0.000304764)    );
  // itree = 552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184258,0.0324443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103933,-0.035989) , 
2, -0.390196, 1, 0, 0.13926,-0.00266416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203704,-0.0293676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5625,0.0215926) , 
2, -0.200007, 1, 0, 0.505848,0.0323591) , 
3, 0.414913, 1, 0, 0.267519,0.00958948)    );
  // itree = 553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378698,-0.00895185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334842,-0.0151133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212055,0.00578232) , 
3, -0.854284, 1, 0, 0.241891,-0.007783) , 
0, -1.35128, 1, 0, 0.253521,-0.0025343)    );
  // itree = 554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334343,0.00262285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103734,-0.0128124) , 
3, 0.215429, 1, 0, 0.258832,0.0186945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0585774,-0.0529853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,0.00269784) , 
2, 0.569817, 1, 0, 0.181651,-0.0189035) , 
1, 1.15314, 1, 0, 0.237977,0.00853536)    );
  // itree = 555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0822368,0.0127262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124783,-0.0248492) , 
3, -1.31328, 1, 0, 0.115912,0.00197737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.859155,0.0659656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286533,-0.0325762) , 
2, 0.579924, 1, 0, 0.543444,-0.0278083) , 
1, 1.08497, 1, 0, 0.245337,-0.00703953)    );
  // itree = 556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0186916,-0.0552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120235,0.00681553) , 
3, -1.16156, 1, 0, 0.0637191,-0.0164191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458537,0.0217484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244706,-0.00885206) , 
1, 1.22177, 1, 0, 0.385542,0.0205901) , 
3, -0.551853, 1, 0, 0.262661,0.00645901)    );
  // itree = 557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330097,-0.0237136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309914,-0.00174454) , 
0, -1.61601, 1, 0, 0.311416,0.0109044) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.047619,-0.0295954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110024,0.0176035) , 
0, -0.118825, 1, 0, 0.0875,-0.0306948) , 
1, 1.06218, 1, 0, 0.240613,-0.00224948)    );
  // itree = 558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140921,-0.0425702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450704,0.0220684) , 
2, -0.831083, 1, 0, 0.337302,-0.0085027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0815819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164627,-0.00818831) , 
2, -0.565092, 1, 0, 0.144956,0.0270928) , 
3, -0.127334, 1, 0, 0.240513,0.00940908)    );
  // itree = 559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218868,-0.0146892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398936,0.0153782) , 
2, 1.30435, 1, 0, 0.237908,-0.00820958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504762,0.0804551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.059322,-0.0313913) , 
2, 1.23421, 1, 0, 0.269058,0.0316107) , 
3, 1.55602, 1, 0, 0.241379,-0.00377184)    );
  // itree = 560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160643,0.00206114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536058,0.0340484) , 
3, 0.53774, 1, 0, 0.254666,0.0192997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916335,-0.0587405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689189,0.00965312) , 
3, 1.46014, 1, 0, 0.313283,-0.0311717) , 
2, 1.08337, 1, 0, 0.266019,0.00952389)    );
  // itree = 561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363052,0.0110631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0643087,-0.0485638) , 
2, 0.771847, 1, 0, 0.303342,-0.00564961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.00627418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0780781,-0.0165956) , 
3, 1.23598, 1, 0, 0.0892857,0.0515505) , 
3, 0.827607, 1, 0, 0.250971,0.00834498)    );
  // itree = 562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413534,0.0221115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167653,-0.0228563) , 
3, -1.74141, 1, 0, 0.21875,0.0142223) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328488,0.00683568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23357,0.000205714) , 
0, -0.488206, 1, 0, 0.255782,-0.014543) , 
1, -0.187201, 1, 0, 0.24455,-0.005818)    );
  // itree = 563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0892774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295493,0.00427645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0799027) , 
3, 1.89048, 1, 0, 0.277005,-0.00840418) , 
0, -1.29224, 1, 0, 0.250847,-0.00392359)    );
  // itree = 564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299531,0.0202081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143519,-0.0213856) , 
1, 1.14086, 1, 0, 0.254509,0.0123353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185654,-0.0457497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268212,-0.00717877) , 
1, 0.464235, 1, 0, 0.231911,-0.0329438) , 
0, 0.780176, 1, 0, 0.248527,0.000348366)    );
  // itree = 565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288171,-0.00545636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190202,0.00164025) , 
0, 0.900791, 1, 0, 0.269295,0.0102365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0148148,-0.0652411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0825688,-0.0245739) , 
0, 1.02575, 1, 0, 0.045082,-0.0553933) , 
2, 1.48783, 1, 0, 0.242543,0.00240582)    );
  // itree = 566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191271,-0.0288282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503937,0.0343953) , 
2, 0.0167879, 1, 0, 0.314685,-0.0109931) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.07995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145833,-0.00755525) , 
2, -0.0123846, 1, 0, 0.119195,0.0275106) , 
3, 0.440469, 1, 0, 0.249353,0.00187463)    );
  // itree = 567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199807,0.000394263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300847,0.00276904) , 
2, 0.31591, 1, 0, 0.231432,-0.0082465) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733945,0.094691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120735,-0.0296515) , 
2, 0.275862, 1, 0, 0.257143,0.0357194) , 
3, 0.802707, 1, 0, 0.237738,0.00253593)    );
  // itree = 568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776173,-0.00949893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406593,0.0299581) , 
3, -0.708228, 1, 0, 0.240909,0.0208652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939597,-0.0374229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554455,-0.00226191) , 
3, 1.07395, 1, 0, 0.249166,-0.0257702) , 
0, 0.145985, 1, 0, 0.244622,-0.00010792)    );
  // itree = 569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615385,0.0109503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782609,-0.0457385) , 
1, -0.24629, 1, 0, 0.407407,0.037563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23462,0.00291182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0495868,-0.0309014) , 
3, 1.89178, 1, 0, 0.222035,0.000567029) , 
2, -1.07513, 1, 0, 0.248555,0.0058598)    );
  // itree = 570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316977,0.00307709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0765766,-0.0371155) , 
3, 0.0631277, 1, 0, 0.221958,0.00746021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338843,0.010764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423729,0.0417311) , 
1, 1.38788, 1, 0, 0.380753,-0.0621849) , 
2, 1.46433, 1, 0, 0.241684,-0.00119114)    );
  // itree = 571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18997,0.000485956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285106,0.000860258) , 
2, -0.0394886, 1, 0, 0.22961,-0.0197873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297723,-0.00481874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152985,-0.0253188) , 
2, 1.19475, 1, 0, 0.25149,0.0253411) , 
3, 0.159145, 1, 0, 0.238943,-0.000538308)    );
  // itree = 572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265625,0.0512634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279503,0.0273191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242118,-0.00953411) , 
0, -1.26434, 1, 0, 0.245385,-0.00824145) , 
1, -1.41766, 1, 0, 0.246701,-0.00332821)    );
  // itree = 573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521739,0.0488349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238655,-0.00183177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.06,-0.0185682) , 
3, 1.8901, 1, 0, 0.229178,0.000384819) , 
2, -1.57666, 1, 0, 0.246,-0.00304023)    );
  // itree = 574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257611,0.00184754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0641026,-0.0427562) , 
1, 1.05744, 1, 0, 0.215993,0.0184081) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39911,0.0258209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0942408,-0.0110649) , 
3, 1.58808, 1, 0, 0.331792,-0.0190428) , 
2, 0.30194, 1, 0, 0.267281,0.00182081)    );
  // itree = 575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00558659,-0.0835652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255034,0.0087214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281928,-0.0066541) , 
3, 0.248325, 1, 0, 0.266951,-0.00276171) , 
1, -1.23776, 1, 0, 0.244152,0.00438664)    );
  // itree = 576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0816334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0400183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253783,-0.00139181) , 
0, -1.08054, 1, 0, 0.260754,0.00408536) , 
3, -2.02293, 1, 0, 0.24748,0.000413289)    );
  // itree = 577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442244,0.0129058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204762,0.00347642) , 
2, -0.411784, 1, 0, 0.291667,-0.00739171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.029703,-0.0509198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0687831,-0.0305493) , 
2, 0.888457, 1, 0, 0.0551724,0.0473241) , 
3, 1.29328, 1, 0, 0.256423,0.000762232)    );
  // itree = 578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311647,0.0120285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146552,-0.0169672) , 
0, 0.933605, 1, 0, 0.279325,0.00620199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180702,-0.0115702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336879,0.0123554) , 
2, 1.19286, 1, 0, 0.232394,-0.0185208) , 
1, 0.680932, 1, 0, 0.259696,-0.00413861)    );
  // itree = 579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0537262,-0.0305315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110294,-0.00484644) , 
2, 0.351609, 1, 0, 0.0645161,0.0202638) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377522,0.0441699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328025,-0.00349625) , 
0, -0.402053, 1, 0, 0.34135,-0.0286374) , 
1, -0.0805323, 1, 0, 0.242757,-0.0112215)    );
  // itree = 580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.024,-0.0502557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0153846,-0.0486958) , 
3, -1.98412, 1, 0, 0.0196078,-0.0309086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490741,0.0385123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271073,-0.00662689) , 
0, -1.09185, 1, 0, 0.284576,-0.00421344) , 
3, -1.51228, 1, 0, 0.250994,-0.00759677)    );
  // itree = 581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397746,-0.00627428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117333,0.00656241) , 
1, 0.496873, 1, 0, 0.292169,0.0168583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225951,0.00118187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629371,-0.0178955) , 
3, 1.73915, 1, 0, 0.203472,-0.021771) , 
0, -0.0324937, 1, 0, 0.246926,-0.00284583)    );
  // itree = 582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42,0.0129793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250637,-0.00103972) , 
3, -2.07868, 1, 0, 0.2639,0.00930473) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2529,-0.00375603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184549,0.0172504) , 
3, 0.969279, 1, 0, 0.228916,-0.0236064) , 
1, 0.939437, 1, 0, 0.251932,-0.00195388)    );
  // itree = 583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0800333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274566,0.0322363) , 
1, -1.49624, 1, 0, 0.237203,-0.0224491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23676,-0.0177145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354369,0.0288788) , 
0, 1.30655, 1, 0, 0.257485,0.0129961) , 
3, -0.462334, 1, 0, 0.249239,-0.00141586)    );
  // itree = 584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00515464,-0.0737439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382716,0.0296545) , 
3, -1.4287, 1, 0, 0.241313,0.012591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176245,-0.0371372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25226,-0.0077217) , 
0, -0.727763, 1, 0, 0.238836,-0.0168043) , 
1, -0.421021, 1, 0, 0.239479,-0.00917562)    );
  // itree = 585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284438,0.00144841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228319,0.0142166) , 
0, 0.57508, 1, 0, 0.26782,-0.00212918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0891089,-0.00113355) , 
2, 1.85179, 1, 0, 0.258835,0.00134509)    );
  // itree = 586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319424,0.00417691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173669,-0.0162241) , 
1, 0.807886, 1, 0, 0.269962,0.0252804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0297619,-0.0555003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256724,0.00343641) , 
2, -0.622573, 1, 0, 0.218053,-0.01383) , 
0, 0.0899978, 1, 0, 0.244848,0.00635847)    );
  // itree = 587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204327,-0.00345551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380952,0.10742) , 
3, 1.65076, 1, 0, 0.214811,-0.0107994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.691589,0.0291547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187845,-0.0624492) , 
3, 0.55773, 1, 0, 0.375,0.0321867) , 
1, 1.4386, 1, 0, 0.237239,-0.00478093)    );
  // itree = 588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252809,0.0366189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22562,-0.0072468) , 
1, -1.26196, 1, 0, 0.228153,-0.00404353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465347,0.0285895) , 
1, 1.7097, 1, 0, 0.24006,-0.00103718)    );
  // itree = 589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371199,0.00498145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137306,-0.0044492) , 
3, 0.434486, 1, 0, 0.31117,0.0113408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0709877,-0.00261212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15,0.0435484) , 
0, 0.648437, 1, 0, 0.0948276,-0.0277452) , 
1, 1.26358, 1, 0, 0.260163,0.00212541)    );
  // itree = 590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391892,-0.00146575) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308478,-0.000658455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177273,0.0110422) , 
3, 0.130068, 1, 0, 0.246369,-0.00141483) , 
0, -1.45539, 1, 0, 0.2571,0.00212621)    );
  // itree = 591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0047619,-0.0597743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0791667,-0.0359228) , 
3, -1.11181, 1, 0, 0.0444444,0.0188839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374539,0.0319881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283629,-0.00639834) , 
3, -0.221543, 1, 0, 0.316456,-0.0128005) , 
1, -0.484715, 1, 0, 0.253716,-0.00549245)    );
  // itree = 592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0488827,-0.0242097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350557,0.0114717) , 
3, -0.587187, 1, 0, 0.223723,0.00414393) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262136,-0.0166716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292857,-0.0421213) , 
2, 1.70384, 1, 0, 0.279835,-0.0503558) , 
2, 1.46214, 1, 0, 0.23073,-0.00266153)    );
  // itree = 593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.00707848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341117,0.000568275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146886,0.00958087) , 
3, 0.140234, 1, 0, 0.251089,-0.00467599) , 
0, -1.36791, 1, 0, 0.260101,0.00304184)    );
  // itree = 594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335101,0.0133929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219136,-0.00607452) , 
1, 0.695697, 1, 0, 0.287869,0.00864548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0453426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,-0.00510543) , 
1, 0.119255, 1, 0, 0.170732,-0.0304906) , 
0, 0.900791, 1, 0, 0.263868,0.000626588)    );
  // itree = 595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0762152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.077748,-0.0193448) , 
0, -0.808621, 1, 0, 0.0506993,0.0275258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341322,0.00448766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143885,-0.0315477) , 
2, 1.75717, 1, 0, 0.323219,-0.0108284) , 
1, -0.368349, 1, 0, 0.248563,-0.000321417)    );
  // itree = 596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17851,0.0366522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162996,-0.0278186) , 
2, -0.404402, 1, 0, 0.169024,-0.00300435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513158,0.0541933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526471,-0.00417565) , 
3, 1.20693, 1, 0, 0.522358,0.0272584) , 
3, 0.802707, 1, 0, 0.256955,0.00452688)    );
  // itree = 597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45273,0.0136416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127586,-0.0318718) , 
2, -0.00924307, 1, 0, 0.311044,-0.018495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131034,-0.00975518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0699589,-0.0132169) , 
1, 1.30387, 1, 0, 0.109145,0.0242144) , 
3, 0.436997, 1, 0, 0.242907,-0.00408137)    );
  // itree = 598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302947,0.00420704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1841,-0.0116423) , 
1, 1.17822, 1, 0, 0.266624,-0.00202051) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.0477189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159292,-0.0141601) , 
1, 0.236459, 1, 0, 0.129944,-0.0399603) , 
0, 1.00058, 1, 0, 0.241397,-0.00902295)    );
  // itree = 599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187705,-0.0142446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330065,0.013952) , 
2, 0.666113, 1, 0, 0.216252,0.000758194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201613,-0.000638187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376569,0.00647178) , 
1, 1.19487, 1, 0, 0.287474,0.0380698) , 
3, 0.802707, 1, 0, 0.233482,0.00978489)    );
  // itree = 600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103399,-0.00330867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495077,0.02374) , 
3, -0.388717, 1, 0, 0.299929,0.0208804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.097035,-0.0444568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326772,0.0130411) , 
0, 0.398106, 1, 0, 0.1904,-0.0236057) , 
1, 1.02693, 1, 0, 0.266405,0.00726442)    );
  // itree = 601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638655,0.028996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296948,-0.0136789) , 
2, -1.48816, 1, 0, 0.338826,-0.0159943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165625,-0.0217977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147929,0.0197812) , 
1, 0.366441, 1, 0, 0.153614,0.0165692) , 
3, -0.151872, 1, 0, 0.245043,0.000494367)    );
  // itree = 602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207809,-0.0137978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536066,0.044416) , 
2, -0.0111987, 1, 0, 0.350427,-0.0103358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0790682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127178,-0.0205459) , 
2, -0.033015, 1, 0, 0.104435,0.0385093) , 
3, 0.528814, 1, 0, 0.268664,0.00589941)    );
  // itree = 603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0716418,-0.0231038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128821,-0.0135355) , 
3, -0.226556, 1, 0, 0.0948582,0.0170665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52324,0.00736658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153226,0.0331238) , 
3, 1.73915, 1, 0, 0.470924,-0.0106992) , 
1, 0.680932, 1, 0, 0.259352,0.0049216)    );
  // itree = 604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140728,0.00576222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0930851,-0.0453125) , 
2, -0.39387, 1, 0, 0.114307,-0.0208399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116505,-0.0366328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574431,0.0225173) , 
2, -0.339484, 1, 0, 0.504451,0.0328104) , 
3, 0.478331, 1, 0, 0.243842,-0.00302693)    );
  // itree = 605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317757,-0.036201) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350515,-0.0224416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22807,0.00464105) , 
3, -1.2602, 1, 0, 0.247541,0.00648844) , 
0, -1.7049, 1, 0, 0.25142,0.0126382)    );
  // itree = 606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296943,0.00672725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26014,-0.000491971) , 
1, 0.262152, 1, 0, 0.278174,0.010669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225191,0.00441043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135922,-0.02429) , 
0, 1.30925, 1, 0, 0.185897,-0.0329263) , 
0, 0.780176, 1, 0, 0.25508,-0.000241453)    );
  // itree = 607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0837993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245922,0.011093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263838,-0.0156553) , 
3, -0.223125, 1, 0, 0.256247,0.00231999) , 
0, -1.58783, 1, 0, 0.242211,0.00572936)    );
  // itree = 608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287089,0.0132603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0895522,-0.0245074) , 
1, 0.905689, 1, 0, 0.222703,0.00436414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607362,-0.0277197) , 
3, 1.7145, 1, 0, 0.25385,-0.00124569)    );
  // itree = 609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482456,0.00208984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248,-0.002632) , 
3, -1.64702, 1, 0, 0.359833,0.049766) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28402,0.00743327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0747423,-0.0210323) , 
3, 1.03687, 1, 0, 0.239429,0.00378617) , 
0, -1.05347, 1, 0, 0.253398,0.00912071)    );
  // itree = 610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162338,-0.0106959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247449,0.000318159) , 
1, -1.29069, 1, 0, 0.239837,0.00846005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320312,0.00139407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,0.0268173) , 
1, 1.40284, 1, 0, 0.364372,-0.0513529) , 
2, 1.46433, 1, 0, 0.25546,0.00095685)    );
  // itree = 611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0414365,0.00306892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111842,-0.0158656) , 
3, -0.489019, 1, 0, 0.0622568,0.033732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307534,-0.00223803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289474,-0.000620375) , 
3, 0.685442, 1, 0, 0.301133,-0.00731663) , 
1, -0.469111, 1, 0, 0.240199,0.00315433)    );
  // itree = 612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288172,0.0282757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126087,-0.034528) , 
1, 0.57445, 1, 0, 0.234532,0.012072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16502,-0.0260723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657778,0.0251646) , 
3, 1.42677, 1, 0, 0.254648,-0.0133313) , 
0, -0.340193, 1, 0, 0.247412,-0.00419298)    );
  // itree = 613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515837,0.0193385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20935,-0.0164531) , 
2, -0.527558, 1, 0, 0.35439,-0.0140588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0753623,-0.0239138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178354,0.00434135) , 
0, 0.113928, 1, 0, 0.142857,0.0235508) , 
3, -0.139172, 1, 0, 0.244961,0.00539714)    );
  // itree = 614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593939,0.040432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224638,-0.0283511) , 
3, -1.42576, 1, 0, 0.425743,0.0201756) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2239,-0.0012716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341935,0.0364315) , 
1, 1.57058, 1, 0, 0.234803,-0.0191902) , 
0, -0.953749, 1, 0, 0.264008,-0.0131691)    );
  // itree = 615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220488,-0.012577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347134,0.00744347) , 
2, 0.958641, 1, 0, 0.242729,-0.00294308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0955414,-0.00352027) , 
3, 1.74551, 1, 0, 0.230848,0.00470398)    );
  // itree = 616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0856423,-0.0155997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505556,0.0277683) , 
3, -0.743648, 1, 0, 0.285337,0.0165643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13739,-0.0199038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619433,0.0107013) , 
3, 1.49459, 1, 0, 0.231438,-0.011432) , 
1, 0.00862622, 1, 0, 0.251607,-0.000955879)    );
  // itree = 617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481818,-0.0219037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253484,0.00347559) , 
3, -1.98663, 1, 0, 0.269017,0.00493235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28972,0.00508418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141414,-0.00493858) , 
1, -0.268292, 1, 0, 0.180693,-0.0442408) , 
0, 1.00007, 1, 0, 0.251361,-0.00489741)    );
  // itree = 618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40678,-0.0049716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244604,-0.000634355) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183486,0.00309135) , 
0, 1.35528, 1, 0, 0.23754,-0.0152746) , 
0, -1.61174, 1, 0, 0.247505,-0.0109929)    );
  // itree = 619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180676,-0.00777775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442953,0.0382749) , 
2, 1.02828, 1, 0, 0.213682,0.0224377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38522,0.011949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137143,-0.00638017) , 
3, 1.40654, 1, 0, 0.331689,-0.0185756) , 
0, 0.249369, 1, 0, 0.261654,0.00576513)    );
  // itree = 620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260231,0.025463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.056391,-0.0407875) , 
1, 0.912532, 1, 0, 0.215751,0.0178552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309091,-0.0662953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290456,-0.013259) , 
1, -0.0398639, 1, 0, 0.292917,-0.0302409) , 
2, 0.357823, 1, 0, 0.247076,-0.00166915)    );
  // itree = 621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330585,0.00190011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923754,-0.0184703) , 
3, 0.287002, 1, 0, 0.244855,0.00154729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241071,0.0435462) , 
0, 1.52799, 1, 0, 0.244644,-0.00203973)    );
  // itree = 622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218927,-0.00829325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379167,0.0186076) , 
2, 0.705366, 1, 0, 0.259494,-0.0164312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0466367) , 
3, 1.74459, 1, 0, 0.245098,-0.00990718)    );
  // itree = 623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0903601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299394,0.0244111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266194,-0.00677627) , 
3, -0.0562561, 1, 0, 0.281302,-0.0030685) , 
0, -1.20662, 1, 0, 0.255,0.00181633)    );
  // itree = 624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0811142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0524345,-0.0295085) , 
3, -1.86439, 1, 0, 0.0424242,-0.0278378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357713,0.0196612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343643,-0.010514) , 
2, 0.699428, 1, 0, 0.351574,0.0101821) , 
3, -0.691091, 1, 0, 0.249248,-0.00240226)    );
  // itree = 625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617647,-0.0116959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433566,-0.0160002) , 
3, -1.6232, 1, 0, 0.510204,0.0507418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219145,0.000269645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0307692,-0.0505419) , 
3, 1.75945, 1, 0, 0.205472,-0.00210703) , 
1, -1.06103, 1, 0, 0.242141,0.00425249)    );
  // itree = 626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410256,0.0512458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.0178692) , 
3, -1.62966, 1, 0, 0.259912,0.0408175) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354167,-0.00891469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213722,0.000728873) , 
3, -0.707321, 1, 0, 0.255011,0.00226265) , 
1, -1.09811, 1, 0, 0.255561,0.00658887)    );
  // itree = 627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212766,0.0140893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309441,0.0214734) , 
2, -0.311273, 1, 0, 0.25951,-0.0192437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.854369,0.0861222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19385,-0.0186902) , 
2, -0.451265, 1, 0, 0.273796,0.00987024) , 
3, 0.159145, 1, 0, 0.265487,-0.00706279)    );
  // itree = 628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240506,0.0377351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213076,-0.00984548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781955,0.0226738) , 
3, 1.83189, 1, 0, 0.254063,-0.00750956) , 
0, -1.35128, 1, 0, 0.252994,-0.00331483)    );
  // itree = 629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270498,-0.0045093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238776,0.00687649) , 
0, 0.538838, 1, 0, 0.261838,-0.000704673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.036036,-0.0452875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.047619,-0.0326847) , 
3, 1.92217, 1, 0, 0.0416667,0.0557827) , 
3, 1.55602, 1, 0, 0.23819,0.0053626)    );
  // itree = 630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179612,-0.0115041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28396,0.00444307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17517,-0.0204503) , 
1, 1.17894, 1, 0, 0.250132,-0.0145275) , 
1, -1.19679, 1, 0, 0.243205,-0.00822351)    );
  // itree = 631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0878328) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282018,0.0199271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262911,-0.00929861) , 
3, -0.223125, 1, 0, 0.270947,-0.00326756) , 
0, -1.43147, 1, 0, 0.249749,0.0011066)    );
  // itree = 632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185668,0.00944608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226891,-0.0407736) , 
3, 0.77929, 1, 0, 0.190385,0.00132116) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241153,-0.023646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811881,0.0229422) , 
3, 1.9529, 1, 0, 0.30787,-0.0221732) , 
2, 0.30194, 1, 0, 0.243697,-0.00934015)    );
  // itree = 633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385542,-0.00479204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340659,0.0136059) , 
0, 0.0235697, 1, 0, 0.367292,0.0131392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118644,0.0151299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134409,0.011004) , 
0, -0.133691, 1, 0, 0.128957,-0.0213595) , 
1, 0.568457, 1, 0, 0.264199,-0.00178341)    );
  // itree = 634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362319,-0.0270704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337405,0.0053874) , 
0, -1.41669, 1, 0, 0.34174,-0.015163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0660377,-0.0221394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186213,-0.00857388) , 
1, -0.584667, 1, 0, 0.175797,0.00920964) , 
3, -0.435343, 1, 0, 0.241071,-0.000377424)    );
  // itree = 635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183673,-0.0158983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330189,0.0140202) , 
2, 0.412971, 1, 0, 0.226428,-0.00269691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.737288,0.0571984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165236,-0.0129339) , 
2, 0.0978855, 1, 0, 0.280822,0.0202344) , 
3, 0.702073, 1, 0, 0.242023,0.0038774)    );
  // itree = 636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0731441,-0.0198327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385863,0.0113935) , 
3, -0.226556, 1, 0, 0.224845,0.00178975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193548,-0.0561932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452991,0.00785968) , 
2, 1.8264, 1, 0, 0.305147,-0.030574) , 
2, 1.46214, 1, 0, 0.235495,-0.00250227)    );
  // itree = 637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449153,-0.0255093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255732,-0.0057667) , 
3, -1.95376, 1, 0, 0.289051,0.0266868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22356,-0.00223046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0458015,-0.0342298) , 
3, 1.812, 1, 0, 0.205564,-0.00546425) , 
0, -0.362191, 1, 0, 0.234462,0.00566433)    );
  // itree = 638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324742,0.00638989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0344828,-0.066838) , 
3, -1.42703, 1, 0, 0.14425,0.024277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300074,0.00845468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0566038,-0.0393249) , 
3, 1.88413, 1, 0, 0.282385,-0.0166728) , 
2, -0.695641, 1, 0, 0.24645,-0.00602005)    );
  // itree = 639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0860064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26636,0.0141012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279046,-0.00119139) , 
3, -0.0786923, 1, 0, 0.273025,0.00393868) , 
0, -1.35128, 1, 0, 0.250375,0.00770613)    );
  // itree = 640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0878788,-0.0143496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480905,0.0243102) , 
3, -0.261763, 1, 0, 0.291149,0.0162709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0785498,-0.0401017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34,0.0118062) , 
2, 1.16117, 1, 0, 0.177024,-0.0175906) , 
1, 1.2054, 1, 0, 0.25922,0.00679752)    );
  // itree = 641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511811,-0.014617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337838,-0.000676115) , 
3, -1.08158, 1, 0, 0.418182,0.0141907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21448,0.00793906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0737463,-0.0178162) , 
2, 1.13343, 1, 0, 0.18144,-0.00895945) , 
1, -0.327527, 1, 0, 0.24674,-0.00257402)    );
  // itree = 642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394737,-0.00496297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317016,-0.000544643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15139,-0.0117087) , 
3, -0.0706474, 1, 0, 0.229087,0.00325054) , 
0, -1.37918, 1, 0, 0.241797,0.00813566)    );
  // itree = 643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238193,0.0183092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263077,0.00491829) , 
2, -0.519283, 1, 0, 0.252419,-0.0108055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249564,-0.0108382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263538,-0.00409691) , 
0, 0.985471, 1, 0, 0.254118,0.0112723) , 
3, 0.130099, 1, 0, 0.253145,-0.00136104)    );
  // itree = 644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258065,0.0486808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207003,0.0150546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314943,-0.00973374) , 
2, 0.275604, 1, 0, 0.258012,0.00255851) , 
0, -1.37918, 1, 0, 0.258016,0.0076683)    );
  // itree = 645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371795,-0.00339518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124625,0.00568345) , 
1, 0.525212, 1, 0, 0.26378,0.0185412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232,-0.00797643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106509,-0.0216222) , 
1, -0.0903139, 1, 0, 0.140389,-0.0253944) , 
0, 0.900791, 1, 0, 0.235028,0.0083036)    );
  // itree = 646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355721,0.00525304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272045,-0.00356014) , 
0, -0.135442, 1, 0, 0.322363,-0.0106627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0180412,-0.0679451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0118287) , 
2, 0.886393, 1, 0, 0.128378,0.0156334) , 
3, 0.331768, 1, 0, 0.25325,-0.00129382)    );
  // itree = 647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0940118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259394,0.0111497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265594,-0.0112022) , 
3, -0.0786923, 1, 0, 0.262782,-0.0014315) , 
0, -1.16999, 1, 0, 0.236049,0.00434029)    );
  // itree = 648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234375,0.01048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27972,-0.0145712) , 
2, 0.369685, 1, 0, 0.250627,0.00146922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0522876,-0.0808335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37234,0.00586587) , 
2, 0.403161, 1, 0, 0.25977,-0.023085) , 
0, 0.900791, 1, 0, 0.252585,-0.00378981)    );
  // itree = 649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38913,-0.00763815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235814,0.00497302) , 
3, -1.03745, 1, 0, 0.274629,0.00667677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.0518733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0638298,-0.0167411) , 
1, 1.40652, 1, 0, 0.0507246,-0.0531649) , 
2, 1.48783, 1, 0, 0.245103,-0.00121444)    );
  // itree = 650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269113,-0.00991692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0649351,-0.0283388) , 
3, -0.593896, 1, 0, 0.203742,0.0304031) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289727,0.00493431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629921,-0.0343996) , 
3, 1.3256, 1, 0, 0.251333,-0.016763) , 
1, -0.507025, 1, 0, 0.239778,-0.00531077)    );
  // itree = 651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235377,0.00583561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334862,0.00187243) , 
3, 0.582531, 1, 0, 0.25876,-0.00677889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252252,0.059467) , 
3, 1.64499, 1, 0, 0.258065,-0.0151861)    );
  // itree = 652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175347,0.0189268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154676,-0.0267722) , 
2, -0.411784, 1, 0, 0.163121,-0.00745032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194175,-0.0306705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590805,0.0170652) , 
2, 0.0810381, 1, 0, 0.51487,0.0217186) , 
3, 0.721703, 1, 0, 0.260267,0.000605586)    );
  // itree = 653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505882,-0.0261206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225603,-0.00101115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119497,0.0465169) , 
3, 1.7528, 1, 0, 0.216728,-0.00882509) , 
1, -1.24613, 1, 0, 0.240464,-0.000924669)    );
  // itree = 654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28284,-0.00595429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187768,0.00102918) , 
0, -0.201825, 1, 0, 0.232977,0.00464403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336634,-0.00821385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485714,0.0656504) , 
2, 1.84146, 1, 0, 0.412621,-0.0505155) , 
2, 1.55405, 1, 0, 0.251639,-0.00108611)    );
  // itree = 655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171717,-0.0196561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247295,-0.014771) , 
3, -0.0708865, 1, 0, 0.203511,0.00351847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.649485,0.0368844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200743,-0.022113) , 
3, 0.42479, 1, 0, 0.388769,-0.040222) , 
0, 0.823646, 1, 0, 0.246377,-0.00660238)    );
  // itree = 656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233577,0.0494006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235724,0.000761419) , 
1, -1.43776, 1, 0, 0.235545,0.00587163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221239,-0.0307053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0597742) , 
0, 1.03549, 1, 0, 0.268041,-0.0686163) , 
2, 1.07686, 1, 0, 0.241753,-0.00835846)    );
  // itree = 657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337589,0.0107479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11359,-0.00141107) , 
2, 0.709315, 1, 0, 0.279559,-0.0166265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,0.0468057) , 
3, 1.99526, 1, 0, 0.270109,-0.0123835)    );
  // itree = 658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118033,-0.0455589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406344,0.0118513) , 
2, -0.937239, 1, 0, 0.315408,-0.0170053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15457,-0.0120374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204778,0.0268419) , 
0, 1.08333, 1, 0, 0.168756,0.0164498) , 
3, -0.127334, 1, 0, 0.239521,0.000306563)    );
  // itree = 659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0756368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0531401,0.0217772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288473,0.000672399) , 
1, -0.952569, 1, 0, 0.262339,0.000856961) , 
3, -1.97613, 1, 0, 0.248855,-0.00212978)    );
  // itree = 660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2019,-0.000716803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7109,0.0356418) , 
3, 0.96499, 1, 0, 0.274763,0.0103842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0508475,-0.0780425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179245,-0.0062804) , 
0, -0.51993, 1, 0, 0.151292,-0.0234046) , 
1, 1.16021, 1, 0, 0.241567,0.00130009)    );
  // itree = 661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288165,-0.00452302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237762,-0.000113163) , 
0, 0.75123, 1, 0, 0.278237,-0.00224886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0818182,-0.015336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111717,0.0018268) , 
2, 0.275862, 1, 0, 0.104822,0.0543933) , 
3, 0.824791, 1, 0, 0.235355,0.0117575)    );
  // itree = 662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1875,-0.00150642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366071,0.00141359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204252,-0.00252041) , 
3, -0.713481, 1, 0, 0.252531,-0.00545821) , 
1, -1.20023, 1, 0, 0.247423,-0.000442735)    );
  // itree = 663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0539683,0.00360052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82243,0.0792281) , 
1, 0.265449, 1, 0, 0.248815,-0.0301514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275434,0.00784233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2568,-0.0143511) , 
0, -0.384366, 1, 0, 0.261343,-0.000384079) , 
3, -1.16842, 1, 0, 0.258795,-0.00643795)    );
  // itree = 664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0615186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210526,-0.0168561) , 
2, -0.782068, 1, 0, 0.241803,0.0358936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141517,-0.0159047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511344,0.00702172) , 
3, 0.713706, 1, 0, 0.262887,-0.00515254) , 
0, -0.988513, 1, 0, 0.260302,-0.000119745)    );
  // itree = 665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444444,-0.0199323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233437,0.0138998) , 
1, -0.832468, 1, 0, 0.266213,-0.0061949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10274,0.00735663) , 
1, 1.58018, 1, 0, 0.254616,-0.0026523)    );
  // itree = 666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352542,0.0166874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17734,0.01344) , 
0, -0.24447, 1, 0, 0.281125,-0.0297172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328963,0.0010376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136812,-0.0172706) , 
3, 0.319938, 1, 0, 0.240956,-0.00221884) , 
1, -0.507025, 1, 0, 0.250733,-0.008912)    );
  // itree = 667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0269542,-0.0311812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336336,0.0170788) , 
1, -0.513925, 1, 0, 0.225651,-0.00184671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280822,-0.000507704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255061,-0.0188217) , 
0, 1.18687, 1, 0, 0.274309,0.0299875) , 
3, -0.0237104, 1, 0, 0.249255,0.0135962)    );
  // itree = 668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341667,0.0903399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275281,0.0150107) , 
2, -0.996979, 1, 0, 0.302013,0.062581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154246,-0.0103817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492007,0.00734979) , 
3, 0.634186, 1, 0, 0.264997,-0.00188631) , 
0, -1.01642, 1, 0, 0.270471,0.00764782)    );
  // itree = 669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371206,0.00974144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119403,-0.00564378) , 
3, 0.182818, 1, 0, 0.278662,0.0089758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213793,0.0287968) , 
0, 1.44177, 1, 0, 0.273882,0.00330579)    );
  // itree = 670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189956,-0.0182764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43058,0.0103744) , 
2, -0.527558, 1, 0, 0.323272,-0.0125919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114035,-0.00760306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162741,-0.0189107) , 
1, 0.843129, 1, 0, 0.138678,0.0292382) , 
3, -0.0237104, 1, 0, 0.235897,0.00720768)    );
  // itree = 671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0755566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0735294,0.0648551) , 
0, -0.734526, 1, 0, 0.0413223,0.038652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191176,0.0193877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315309,0.00648865) , 
0, -0.71134, 1, 0, 0.291383,-0.015659) , 
1, -0.988042, 1, 0, 0.261216,-0.00910699)    );
  // itree = 672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167959,0.00170521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0295652,-0.0583485) , 
1, -0.437849, 1, 0, 0.0852391,-0.0187225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545794,0.0166088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,-0.016137) , 
1, 0.923889, 1, 0, 0.402792,0.0046183) , 
3, -0.139172, 1, 0, 0.247328,-0.00680861)    );
  // itree = 673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339755,0.00188859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0466321,-0.02875) , 
1, 1.22653, 1, 0, 0.265707,0.00906808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284483,0.0013429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158209,0.00359353) , 
1, -0.0903139, 1, 0, 0.190687,-0.0290655) , 
0, 0.871315, 1, 0, 0.24861,0.000377706)    );
  // itree = 674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330906,0.00972118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0535714,-0.0351708) , 
3, 0.735558, 1, 0, 0.279683,0.000833062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.00824189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237838,0.0115169) , 
1, 0.638362, 1, 0, 0.177057,-0.0306593) , 
0, 0.944261, 1, 0, 0.258216,-0.00575453)    );
  // itree = 675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191257,0.0345339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256601,-0.00349473) , 
3, -1.2115, 1, 0, 0.243625,-0.0017281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72093,0.0556406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201342,0.0111011) , 
3, 1.11219, 1, 0, 0.442446,-0.0438012) , 
0, 1.26376, 1, 0, 0.269684,-0.00724263)    );
  // itree = 676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0689655,-0.0211024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385224,0.0102292) , 
3, -0.61646, 1, 0, 0.248132,0.00151905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0991379,-0.0435226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716667,0.0156462) , 
3, 1.64522, 1, 0, 0.226027,-0.0296507) , 
0, 0.676581, 1, 0, 0.241415,-0.00795188)    );
  // itree = 677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362903,-0.0160613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392954,-0.00755002) , 
0, -1.43273, 1, 0, 0.385396,-0.0192882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32562,0.00201375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150106,0.00783229) , 
1, 0.29434, 1, 0, 0.218569,0.0143957) , 
3, -1.04915, 1, 0, 0.258806,0.00627136)    );
  // itree = 678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416084,0.0152353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114094,-0.0499598) , 
0, 0.239832, 1, 0, 0.353675,-0.0261425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0554415,-0.0443678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282152,0.0176794) , 
2, 0.197813, 1, 0, 0.193755,0.00022717) , 
3, -0.580667, 1, 0, 0.252284,-0.00942384)    );
  // itree = 679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219697,0.0177067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22931,-0.00590078) , 
2, -0.732547, 1, 0, 0.22541,-0.0124332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153704,-0.0178181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416201,-0.0102896) , 
1, 1.11713, 1, 0, 0.258352,0.0128611) , 
3, -0.0237104, 1, 0, 0.241195,-0.000312466)    );
  // itree = 680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00746269,-0.0727884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321311,0.0339735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256824,-0.00431267) , 
0, -0.79645, 1, 0, 0.267084,0.00320539) , 
3, -1.90433, 1, 0, 0.250122,-0.000766147)    );
  // itree = 681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382542,-0.000706219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147436,0.00316048) , 
3, -0.268078, 1, 0, 0.277976,0.00357437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246575,-0.000433219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174641,0.0053026) , 
2, -0.0446769, 1, 0, 0.193262,-0.0290214) , 
0, 0.676581, 1, 0, 0.253686,-0.00577186)    );
  // itree = 682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300404,0.00968893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.068323,-0.0185923) , 
3, 1.3362, 1, 0, 0.280655,-0.0143958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102804,0.00150948) , 
3, 1.99526, 1, 0, 0.271136,-0.0107477)    );
  // itree = 683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0716049,-0.0277408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118252,-0.0112912) , 
3, 0.0212932, 1, 0, 0.086739,0.00596201) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582888,0.0296793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464286,0.00162901) , 
0, -0.507772, 1, 0, 0.491905,-0.0187689) , 
1, 0.670673, 1, 0, 0.249251,-0.00395752)    );
  // itree = 684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123578,-0.0115545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40797,0.00945106) , 
3, 0.510181, 1, 0, 0.204767,-0.00178972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.822368,0.0350869) , 
3, 1.76176, 1, 0, 0.251752,0.00406387)    );
  // itree = 685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484375,-0.0111705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337255,-0.00121521) , 
3, -2.01211, 1, 0, 0.386423,-0.0283468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220779,-0.00217045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220199,0.0053459) , 
0, -0.306929, 1, 0, 0.220359,0.0072846) , 
3, -1.33958, 1, 0, 0.251339,0.00063734)    );
  // itree = 686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272538,-0.000300207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140777,-0.0163764) , 
0, 0.900791, 1, 0, 0.243258,-0.0140814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33,0.0291909) , 
1, 1.7097, 1, 0, 0.247697,-0.00910437)    );
  // itree = 687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168109,-0.0110616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276995,-0.00116421) , 
3, -0.197913, 1, 0, 0.21616,0.00778515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408805,0.0314017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394299,0.0164073) , 
1, 0.00448539, 1, 0, 0.398276,-0.0325084) , 
0, 0.676581, 1, 0, 0.268245,-0.00373864)    );
  // itree = 688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222851,0.00916956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37963,-0.0579131) , 
3, 1.65599, 1, 0, 0.231876,0.00223018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868687,0.0406518) , 
3, 1.91802, 1, 0, 0.263797,0.00633466)    );
  // itree = 689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,0.00786238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101124,0.0039518) , 
3, 0.881124, 1, 0, 0.324926,-0.00819125) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923077,-0.0248345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0486486,-0.0394979) , 
3, 1.42013, 1, 0, 0.0796875,0.0199485) , 
2, 0.648293, 1, 0, 0.245976,0.000867827)    );
  // itree = 690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210303,-0.0106854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457143,0.0381545) , 
2, 0.721196, 1, 0, 0.277034,-0.00145845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0551181,-0.0467533) , 
3, 1.79915, 1, 0, 0.263412,0.002892)    );
  // itree = 691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.086975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227648,-0.00808982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404255,0.0125032) , 
0, 1.0099, 1, 0, 0.263934,-0.0147806) , 
0, -1.37918, 1, 0, 0.242836,-0.0082828)    );
  // itree = 692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220887,0.012139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180247,-0.0265048) , 
2, 0.744255, 1, 0, 0.211406,0.00434217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338028,-0.0502461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626582,0.00157989) , 
2, 1.19475, 1, 0, 0.49,-0.0497528) , 
3, 1.27365, 1, 0, 0.252456,-0.0036286)    );
  // itree = 693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338135,0.00846951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0573614,-0.0270464) , 
1, 1.03371, 1, 0, 0.258415,-0.00640597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782609,-0.00694607) , 
1, 1.73516, 1, 0, 0.247828,-0.00161634)    );
  // itree = 694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140127,-0.0396786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0974576,-0.022413) , 
1, -0.148672, 1, 0, 0.121818,0.0148203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26873,0.00418581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340768,0.0210742) , 
2, 0.340048, 1, 0, 0.309641,-0.0167204) , 
2, -0.656951, 1, 0, 0.25723,-0.00791906)    );
  // itree = 695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0735524,-0.00914403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141791,-0.014465) , 
3, 0.358741, 1, 0, 0.0853816,0.0243736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376128,-0.00204302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.0416165) , 
0, 1.29403, 1, 0, 0.375972,-0.012053) , 
1, 0.0861832, 1, 0, 0.259585,0.00253653)    );
  // itree = 696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219934,-0.0040209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278846,-0.03089) , 
2, 0.94019, 1, 0, 0.227087,-0.00979246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135593,-0.0112943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853448,0.0518252) , 
3, 1.68156, 1, 0, 0.419795,0.0435312) , 
2, 1.42243, 1, 0, 0.255234,-0.00200392)    );
  // itree = 697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448661,-0.00804666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184659,0.000765585) , 
1, -0.390081, 1, 0, 0.263298,0.00987168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196517,0.000432548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110092,0.0249655) , 
3, 1.74375, 1, 0, 0.178082,-0.0248753) , 
0, 0.731231, 1, 0, 0.241687,0.00105991)    );
  // itree = 698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225171,0.000146998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0795756) , 
3, 1.32562, 1, 0, 0.208861,0.00207984) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377907,0.0345163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300948,-0.0055948) , 
1, 0.560207, 1, 0, 0.323232,-0.0292306) , 
2, 0.742881, 1, 0, 0.24256,-0.00714555)    );
  // itree = 699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0870871,-0.00660871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258772,-0.00474019) , 
3, -0.860159, 1, 0, 0.156863,0.0132932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313417,0.00771952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276986,0.00800672) , 
3, 0.794196, 1, 0, 0.301038,-0.0170106) , 
0, -0.528156, 1, 0, 0.260718,-0.00853582)    );
  // itree = 700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281343,-0.00259762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18578,-0.0221135) , 
1, 0.40488, 1, 0, 0.237135,-0.0133214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464286,0.030616) , 
1, 1.62191, 1, 0, 0.25284,-0.00841934)    );
  // itree = 701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273859,-0.00422798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217257,-0.00374874) , 
0, 0.350327, 1, 0, 0.254045,0.00377137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0277778,-0.0528911) , 
3, 1.64499, 1, 0, 0.234022,0.00760159)    );
  // itree = 702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162791,-0.0301549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463235,0.0243477) , 
2, -0.938963, 1, 0, 0.366584,-0.0240194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114815,-0.0340371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231106,0.0162004) , 
0, -0.280643, 1, 0, 0.204565,0.0166382) , 
3, -0.462334, 1, 0, 0.270025,0.000211262)    );
  // itree = 703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214153,-0.0123226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272,-0.00126846) , 
2, 0.33431, 1, 0, 0.235433,-0.00704017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430769,0.0235581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0573248,-0.0407055) , 
2, 1.08831, 1, 0, 0.226481,0.0554812) , 
3, 1.29216, 1, 0, 0.234139,0.00199489)    );
  // itree = 704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0778547,-0.0117637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323741,0.0151705) , 
3, -0.675427, 1, 0, 0.198413,0.00625883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.096,-0.0518705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577957,0.00793187) , 
3, 0.803101, 1, 0, 0.301605,-0.0153271) , 
2, 0.314309, 1, 0, 0.24327,-0.00312448)    );
  // itree = 705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394137,0.00342862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161248,0.0141114) , 
3, -0.149065, 1, 0, 0.288166,0.0057306) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203125,0.00148437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134454,0.0271759) , 
2, 1.20446, 1, 0, 0.176849,-0.0373305) , 
0, 1.13453, 1, 0, 0.270865,-0.000962055)    );
  // itree = 706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399317,0.011582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163265,-0.0217941) , 
3, -0.555656, 1, 0, 0.286222,0.000665565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0806452,-0.0221356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285444,0.0114099) , 
2, 0.26257, 1, 0, 0.209774,-0.0283787) , 
0, 0.297203, 1, 0, 0.253564,-0.0117418)    );
  // itree = 707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.045283,0.0234645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109955,-0.0070015) , 
3, -1.36115, 1, 0, 0.0916844,0.011928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420523,0.00433629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0792439) , 
3, 1.90546, 1, 0, 0.38,-0.0117725) , 
1, 0.22651, 1, 0, 0.247301,-0.000864202)    );
  // itree = 708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.06,-0.0136716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493243,0.0615455) , 
3, -1.61915, 1, 0, 0.318548,0.0619118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24166,0.000849664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23676,-0.0302796) , 
0, 1.09727, 1, 0, 0.240719,-0.00746748) , 
1, -0.935986, 1, 0, 0.250782,0.00150336)    );
  // itree = 709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458689,-0.00682012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262357,-0.00566314) , 
3, -1.08002, 1, 0, 0.322807,0.0168159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0791367,-0.01628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0933908,-0.0113285) , 
0, -0.656486, 1, 0, 0.091018,-0.0112229) , 
1, 0.634378, 1, 0, 0.22481,0.0049615)    );
  // itree = 710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214571,-0.00989733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0801963) , 
3, 0.852195, 1, 0, 0.192652,0.0119592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383382,0.0146383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0842105,-0.0244534) , 
3, 1.52611, 1, 0, 0.318493,-0.0206529) , 
2, 0.32187, 1, 0, 0.247992,-0.00238223)    );
  // itree = 711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0757595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295019,0.0464398) , 
3, -2.03916, 1, 0, 0.210959,-0.017783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112,-0.0344779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26288,-0.00890288) , 
0, -0.937814, 1, 0, 0.251373,0.0159279) , 
3, -1.22331, 1, 0, 0.244012,0.00978795)    );
  // itree = 712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0382353,-0.030598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37637,0.0243933) , 
3, -1.24415, 1, 0, 0.277347,0.0191414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0771993,-0.0482032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633218,0.0157845) , 
3, 1.08337, 1, 0, 0.267139,-0.0132992) , 
0, 0.30526, 1, 0, 0.273044,0.00546686)    );
  // itree = 713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302902,0.00745253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0756972,-0.0138977) , 
3, 1.20819, 1, 0, 0.272966,-0.00291314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109589,0.0262522) , 
1, 1.56373, 1, 0, 0.261336,0.00105391)    );
  // itree = 714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0898204,-0.0533201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405505,0.0114847) , 
2, -1.18266, 1, 0, 0.331461,-0.0141248) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188725,-0.00320174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21328,0.000142814) , 
1, 1.11713, 1, 0, 0.19802,0.019223) , 
3, -0.580667, 1, 0, 0.244938,0.00749775)    );
  // itree = 715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0865129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289687,0.00999752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123188,0.0301253) , 
3, 1.8016, 1, 0, 0.277361,-0.00762762) , 
0, -1.68098, 1, 0, 0.263238,-0.00276376)    );
  // itree = 716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210191,0.0166086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0489796,-0.0443622) , 
0, -0.867997, 1, 0, 0.0972355,-0.014864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613293,0.0329083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290469,-0.0112018) , 
1, 0.4527, 1, 0, 0.398185,0.00819956) , 
3, -0.0530968, 1, 0, 0.243508,-0.00365429)    );
  // itree = 717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611111,0.0337046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210169,-0.0282908) , 
2, -0.881437, 1, 0, 0.341686,-0.0173986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201884,0.0017207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0855615,0.0072361) , 
1, 1.22177, 1, 0, 0.162936,0.0290586) , 
3, -0.322723, 1, 0, 0.241604,0.00861278)    );
  // itree = 718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322878,-0.0105054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308743,0.00183961) , 
0, -0.531031, 1, 0, 0.314757,-0.00446919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0785871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108414,-0.0260905) , 
2, -0.214446, 1, 0, 0.0910326,0.0407809) , 
3, 0.414913, 1, 0, 0.232836,0.0121)    );
  // itree = 719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234437,0.0151973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,-0.00710119) , 
3, -0.509416, 1, 0, 0.25883,0.00773457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325,0.0179705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141509,-0.0144562) , 
0, 0.962014, 1, 0, 0.238938,-0.0366842) , 
2, 1.53606, 1, 0, 0.256528,0.00259445)    );
  // itree = 720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151899,0.0209017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0804438,-0.0368423) , 
2, -0.937239, 1, 0, 0.102218,-0.0135776) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482283,0.0350165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324009,-0.0166395) , 
0, 0.732248, 1, 0, 0.409819,0.0187037) , 
3, -0.0237104, 1, 0, 0.248227,0.00174538)    );
  // itree = 721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552941,-0.00660896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392857,-0.00904362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197076,0.00148178) , 
1, -0.758595, 1, 0, 0.21459,-0.00469704) , 
1, -1.23776, 1, 0, 0.242676,-0.00208152)    );
  // itree = 722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36036,-0.0254849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294702,-0.00409934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229779,0.00263654) , 
3, -1.22691, 1, 0, 0.239917,-0.00131036) , 
0, -1.59608, 1, 0, 0.246455,0.002545)    );
  // itree = 723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.060423,-0.0201922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284609,-0.00260491) , 
0, -0.850908, 1, 0, 0.23494,-0.00699704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28777,0.010235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239437,-0.0415967) , 
1, 1.44902, 1, 0, 0.275492,0.0285059) , 
3, 0.744587, 1, 0, 0.245981,0.00266986)    );
  // itree = 724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627907,-0.0212162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409091,0.0154739) , 
3, -0.866904, 1, 0, 0.280277,0.00869677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136024,-0.0265191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452381,0.0149981) , 
2, 1.7988, 1, 0, 0.186164,-0.0198462) , 
1, 0.75851, 1, 0, 0.241927,-0.002934)    );
  // itree = 725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33211,-0.00445768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128169,-0.00544479) , 
3, 0.101523, 1, 0, 0.251667,0.0148778) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.0622963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143713,0.00535365) , 
3, 0.887313, 1, 0, 0.116364,-0.0418164) , 
0, 1.26376, 1, 0, 0.233735,0.00736412)    );
  // itree = 726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267123,-0.00246681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487179,0.021689) , 
2, -0.979645, 1, 0, 0.365019,-0.03673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24031,-0.0271214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233662,0.00255142) , 
0, -0.957593, 1, 0, 0.234152,-0.00417596) , 
3, -1.51764, 1, 0, 0.251241,-0.00842705)    );
  // itree = 727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145062,-0.00692857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255924,-0.0197942) , 
3, -0.555656, 1, 0, 0.199844,0.0118341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311628,0.0241879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411311,0.00297451) , 
1, 0.65155, 1, 0, 0.358974,-0.0165536) , 
0, 0.30526, 1, 0, 0.261905,0.000762898)    );
  // itree = 728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219081,0.00526133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0726698,-0.0429748) , 
0, -0.0282615, 1, 0, 0.156545,-0.0109334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696035,0.0323419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343284,-0.0106108) , 
1, 1.11766, 1, 0, 0.50505,0.0193955) , 
3, 0.802707, 1, 0, 0.243804,-0.00333966)    );
  // itree = 729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362356,-0.00196163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1703,0.00814585) , 
3, -0.290838, 1, 0, 0.269307,0.0143505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303922,0.0103464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12012,-0.0123299) , 
1, -0.14278, 1, 0, 0.163218,-0.0252363) , 
0, 0.900791, 1, 0, 0.245641,0.0055196)    );
  // itree = 730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,0.00300517) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268004,0.01208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229665,-0.00148478) , 
1, 0.680932, 1, 0, 0.251423,-0.00568683) , 
0, -1.68098, 1, 0, 0.26087,-0.00182688)    );
  // itree = 731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.076008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0396825,-0.0327524) , 
3, -1.6232, 1, 0, 0.0218341,0.0471525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29049,0.000745414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253406,0.00166058) , 
2, 1.16166, 1, 0, 0.282545,-0.00291612) , 
1, -1.102, 1, 0, 0.251802,0.00298796)    );
  // itree = 732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189513,-0.00314512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371287,-0.0400143) , 
3, 1.07474, 1, 0, 0.213403,-0.0138825) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0456621,-0.0590843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655367,0.0271892) , 
3, 1.07875, 1, 0, 0.318182,0.0092381) , 
2, 1.08337, 1, 0, 0.234868,-0.00914596)    );
  // itree = 733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482456,-0.0214264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325315,0.0047346) , 
3, -1.94264, 1, 0, 0.343465,-0.0188024) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15299,0.00476926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188498,0.00536323) , 
0, 0.932109, 1, 0, 0.16376,0.0147996) , 
3, -0.151872, 1, 0, 0.25161,-0.00162693)    );
  // itree = 734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,0.0163755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208065,-0.00318845) , 
3, -1.69133, 1, 0, 0.248383,0.00651612) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295918,0.00305518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185764,-0.0156578) , 
1, 1.13115, 1, 0, 0.245642,-0.0206383) , 
1, 0.00862622, 1, 0, 0.246683,-0.0103236)    );
  // itree = 735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0755324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272285,0.0262151) , 
3, -2.02492, 1, 0, 0.230453,-0.0182002) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130552,-0.0164132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417166,-0.0083172) , 
1, 0.983147, 1, 0, 0.245981,0.016465) , 
3, -0.610112, 1, 0, 0.240243,0.00365661)    );
  // itree = 736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22807,0.0332527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.089011,-0.0180602) , 
0, -1.65333, 1, 0, 0.104492,-0.00723349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5875,0.0352757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281307,0.000201866) , 
1, 0.717924, 1, 0, 0.410095,0.026671) , 
3, -0.0530968, 1, 0, 0.251646,0.00909215)    );
  // itree = 737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412098,0.000277635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226913,0.0147976) , 
3, -0.877483, 1, 0, 0.285714,-0.0067362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137255,-0.0296124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142105,0.00881645) , 
3, 0.785477, 1, 0, 0.139942,-0.0422434) , 
0, 1.08217, 1, 0, 0.260826,-0.0127984)    );
  // itree = 738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206897,0.0205255) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116992,-0.025661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289116,0.00326687) , 
2, -0.747708, 1, 0, 0.255331,-0.0103666) , 
1, -1.3293, 1, 0, 0.252442,-0.00757437)    );
  // itree = 739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249175,-0.00149267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255046,-0.00318552) , 
2, -0.421898, 1, 0, 0.252948,-0.0101535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56,0.0971094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20098,0.0233956) , 
0, 0.712439, 1, 0, 0.319079,-0.0499113) , 
3, 1.29328, 1, 0, 0.263,-0.0161967)    );
  // itree = 740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00840336,-0.0741827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00819672,-0.0507298) , 
0, -1.13045, 1, 0, 0.00829876,-0.0429236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522523,0.0479274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273881,0.00244079) , 
0, -1.09185, 1, 0, 0.289518,0.00881742) , 
3, -1.51764, 1, 0, 0.255733,0.00260127)    );
  // itree = 741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258939,-0.00316585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0517241,-0.0350987) , 
3, 1.36291, 1, 0, 0.240042,-0.00782485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.039604,-0.0317239) , 
3, 1.89284, 1, 0, 0.229965,-0.00393236)    );
  // itree = 742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333738,0.00439821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0329964) , 
3, 0.158612, 1, 0, 0.257366,0.0135445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236842,-0.0097002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215156,-0.00374506) , 
0, -0.656486, 1, 0, 0.218855,-0.0207042) , 
1, 0.680932, 1, 0, 0.240587,-0.00137759)    );
  // itree = 743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244493,0.00238325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343925,5.33148e-05) , 
3, 0.488581, 1, 0, 0.272536,0.0107023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204225,0.0801167) , 
3, 1.74459, 1, 0, 0.267778,0.00474932)    );
  // itree = 744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,0.0260297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205272,-0.0102801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341699,0.00835063) , 
2, 0.839392, 1, 0, 0.245198,-0.0047649) , 
1, -1.24613, 1, 0, 0.247828,-0.00090152)    );
  // itree = 745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395349,0.00335451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138636,-0.014355) , 
3, 0.196719, 1, 0, 0.311243,0.0149997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620155,-0.0198243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0805085,-0.0112207) , 
0, -0.522912, 1, 0, 0.0765391,-0.0145094) , 
1, 1.02223, 1, 0, 0.238683,0.00587676)    );
  // itree = 746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367299,0.00133434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135452,-0.018965) , 
3, -0.197913, 1, 0, 0.271151,-0.00238456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00653595,-0.0742923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245524,0.0101715) , 
2, -0.0314155, 1, 0, 0.178309,-0.0279299) , 
0, 0.708151, 1, 0, 0.24572,-0.00938187)    );
  // itree = 747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0754196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247694,0.0112074) , 
3, -2.02519, 1, 0, 0.218351,-0.0167014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237931,-0.0202469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259392,-0.00897032) , 
0, 0.526183, 1, 0, 0.248464,0.0173424) , 
3, -0.343942, 1, 0, 0.2355,0.00268651)    );
  // itree = 748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265193,0.0390812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0617716,-0.0272617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429429,0.00946735) , 
3, -0.109025, 1, 0, 0.259558,0.000231182) , 
0, -1.22153, 1, 0, 0.260059,0.0050712)    );
  // itree = 749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474453,0.0199594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316279,-0.0151688) , 
0, -0.860896, 1, 0, 0.377841,-0.0216666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267606,0.00130316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153614,0.00103324) , 
2, -0.114059, 1, 0, 0.183568,0.0078548) , 
3, -0.610112, 1, 0, 0.250122,-0.00225863)    );
  // itree = 750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34192,-0.000492372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305882,-0.00691505) , 
3, -1.18614, 1, 0, 0.325945,-0.0167215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841122,-0.0167691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187907,-0.0108444) , 
1, -0.218181, 1, 0, 0.170675,0.0155727) , 
3, -0.580667, 1, 0, 0.228599,0.00352518)    );
  // itree = 751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151579,0.0124427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207854,-0.0216997) , 
3, -0.945601, 1, 0, 0.190257,0.0188223) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455357,0.0360357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37594,0.00328268) , 
1, -0.159304, 1, 0, 0.393346,-0.0388865) , 
0, 0.834197, 1, 0, 0.241379,0.00429564)    );
  // itree = 752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338583,0.079513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00816326,-0.0639756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303012,0.0107397) , 
3, -1.38833, 1, 0, 0.265092,0.00923445) , 
1, -1.40737, 1, 0, 0.269685,0.0158192)    );
  // itree = 753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39749,-0.00903806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280044,0.0141904) , 
3, -0.909406, 1, 0, 0.320578,0.00441233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0979499,-0.0188712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.056701,-0.0246844) , 
3, 1.38367, 1, 0, 0.0853081,-0.0229737) , 
2, 0.681691, 1, 0, 0.246779,-0.00417804)    );
  // itree = 754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426829,0.0121203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308231,-0.00565195) , 
3, -1.82131, 1, 0, 0.334694,-0.0184262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136499,0.00253836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245207,0.00858601) , 
1, 0.0345142, 1, 0, 0.21762,0.0136937) , 
3, -0.610112, 1, 0, 0.259331,0.00225009)    );
  // itree = 755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0394737,0.00769819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921053,-0.0178453) , 
3, -1.41793, 1, 0, 0.0777512,0.0173145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338798,0.0204762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348095,-0.0163307) , 
0, -0.691888, 1, 0, 0.34662,-0.0101161) , 
1, 0.0962332, 1, 0, 0.233668,0.00140749)    );
  // itree = 756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0196078,-0.0572626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0458515,-0.0270745) , 
3, -1.99376, 1, 0, 0.0410714,-0.021777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291701,0.0123305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612903,-0.0196653) , 
3, 1.62114, 1, 0, 0.334284,0.00861026) , 
3, -0.871513, 1, 0, 0.250637,-5.85552e-05)    );
  // itree = 757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480138,0.00661557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233983,0.0166432) , 
1, -0.125736, 1, 0, 0.34387,0.00926087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10804,-0.0156565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100402,0.0128507) , 
3, 1.08579, 1, 0, 0.1051,-0.0212937) , 
2, 0.648293, 1, 0, 0.264403,-0.000908272)    );
  // itree = 758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326146,0.0109921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175676,-0.00972729) , 
1, 1.2364, 1, 0, 0.288604,0.00263003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160606,0.00187337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221719,0.0021549) , 
1, 0.836111, 1, 0, 0.185118,-0.0254481) , 
0, 0.780176, 1, 0, 0.26057,-0.00497619)    );
  // itree = 759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120748,-0.0170395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278481,0.00981465) , 
3, -0.609321, 1, 0, 0.191149,0.0187366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364749,0.00841347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0955882,-0.0134581) , 
3, 1.73713, 1, 0, 0.326338,-0.0117933) , 
0, 0.133846, 1, 0, 0.255087,0.00429742)    );
  // itree = 760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841379,-0.0265253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487589,0.0285139) , 
3, -0.24307, 1, 0, 0.260667,0.00790068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155172,-0.063812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,-0.014062) , 
1, -0.239905, 1, 0, 0.246006,-0.0281583) , 
0, 0.624761, 1, 0, 0.255875,-0.00388676)    );
  // itree = 761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485149,-0.0169151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354988,-0.00227202) , 
3, -1.99356, 1, 0, 0.379699,-0.0253285) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167702,0.00484134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216466,0.00609227) , 
0, -0.422992, 1, 0, 0.205274,0.0139987) , 
3, -0.871513, 1, 0, 0.25323,0.00318627)    );
  // itree = 762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286031,-0.00103189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182519,-0.0193213) , 
1, 1.29547, 1, 0, 0.262916,-0.0016982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190083,-0.0123129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129167,-0.0196922) , 
3, 0.518013, 1, 0, 0.149584,-0.0425229) , 
0, 1.08217, 1, 0, 0.243462,-0.00870615)    );
  // itree = 763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0914972,-0.027734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171296,0.0168188) , 
3, 0.827607, 1, 0, 0.104777,0.00921526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.648033,0.02314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348178,0.0157884) , 
2, 1.19318, 1, 0, 0.546575,-0.022269) , 
1, 0.939437, 1, 0, 0.263807,-0.00211784)    );
  // itree = 764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241109,0.0109174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0798479,-0.0524796) , 
0, 1.08472, 1, 0, 0.219043,0.0029353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796407,0.0255685) , 
3, 1.74551, 1, 0, 0.265199,0.00695275)    );
  // itree = 765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485149,0.00828793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239398,-0.0120744) , 
2, -0.854841, 1, 0, 0.311412,-0.00899281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0746269,0.00129482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163158,0.00792253) , 
0, -0.308546, 1, 0, 0.149888,0.0215964) , 
3, 0.0482632, 1, 0, 0.236515,0.00519118)    );
  // itree = 766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229702,-0.00720772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473684,0.0115206) , 
2, 0.901513, 1, 0, 0.269988,-0.00243297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0851925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158974,0.0149324) , 
1, 0.938773, 1, 0, 0.0990415,-0.0907545) , 
3, 1.27365, 1, 0, 0.243747,-0.0159909)    );
  // itree = 767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15625,0.0280853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154577,-0.0204572) , 
3, -1.16379, 1, 0, 0.154967,0.0193266) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711538,0.0424239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30814,-0.0317404) , 
0, 0.312724, 1, 0, 0.550926,-0.0203286) , 
1, 1.29547, 1, 0, 0.243048,0.0105053)    );
  // itree = 768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0163934,-0.0747835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260046,0.00616974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300971,-0.0292317) , 
2, 1.5906, 1, 0, 0.264374,0.00250732) , 
2, -1.59508, 1, 0, 0.249758,-0.000381744)    );
  // itree = 769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398544,0.00882477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138249,0.00128623) , 
2, 0.832336, 1, 0, 0.355623,-0.00266886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0447761,-0.0325977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985401,0.00454287) , 
0, -0.635545, 1, 0, 0.0879765,-0.0284801) , 
1, 0.939437, 1, 0, 0.264264,-0.0114793)    );
  // itree = 770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475728,0.0320237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227964,-0.0108892) , 
3, -1.98663, 1, 0, 0.242563,0.00341137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188482,0.0258182) , 
0, 1.3861, 1, 0, 0.237236,-0.00600639)    );
  // itree = 771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00943396,0.0189779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384146,0.0600798) , 
1, -1.10591, 1, 0, 0.237037,-0.0375203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25414,-0.017063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202532,-0.0100608) , 
2, 1.51926, 1, 0, 0.247371,0.0154224) , 
3, -1.51228, 1, 0, 0.246028,0.00854008)    );
  // itree = 772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0422535,-0.0304118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383954,0.0479072) , 
3, -1.7081, 1, 0, 0.285132,0.0440639) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242718,0.00115114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256944,-0.0334553) , 
0, 1.08631, 1, 0, 0.245407,-0.00821126) , 
1, -0.418323, 1, 0, 0.255087,0.00452677)    );
  // itree = 773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404863,0.00186429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151839,0.00192521) , 
1, 0.263264, 1, 0, 0.285634,0.00184333) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0451128,-0.043406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925926,0.0121679) , 
1, 1.40284, 1, 0, 0.06639,-0.0506615) , 
2, 1.53606, 1, 0, 0.259606,-0.00439)    );
  // itree = 774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125874,-0.0529751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0868585) , 
3, -1.31914, 1, 0, 0.0708661,-0.028183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347247,0.00999254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128728,-0.00666022) , 
3, 0.467902, 1, 0, 0.268293,0.00290834) , 
2, -1.24791, 1, 0, 0.243431,-0.00100697)    );
  // itree = 775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962199,-0.0127159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112903,-0.0135591) , 
2, -0.297262, 1, 0, 0.105581,0.0123246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.691824,0.0477778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494465,0.00816133) , 
0, -0.505399, 1, 0, 0.53923,-0.0294155) , 
1, 0.946985, 1, 0, 0.25555,-0.00211042)    );
  // itree = 776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0154867,-0.0578811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,0.00518535) , 
3, -1.05906, 1, 0, 0.0391459,-0.0231194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469605,0.0258403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242678,-0.0106065) , 
1, 0.561996, 1, 0, 0.351273,0.0118164) , 
3, -0.871513, 1, 0, 0.260712,0.00168014)    );
  // itree = 777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.011364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120623,-0.044933) , 
3, -0.354416, 1, 0, 0.373212,0.0138282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137421,-0.0289969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160643,0.0124701) , 
3, 0.0183182, 1, 0, 0.151639,-0.0119438) , 
2, -0.22187, 1, 0, 0.237305,-0.00197968)    );
  // itree = 778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333669,0.00233044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131111,-0.0166785) , 
3, -0.152026, 1, 0, 0.237315,0.00402764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485981,0.0703477) , 
1, 1.65151, 1, 0, 0.250625,-0.00175565)    );
  // itree = 779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00595238,-0.0483949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445578,0.0386026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231153,-0.00729341) , 
2, -0.905545, 1, 0, 0.26435,-0.00436822) , 
1, -1.28125, 1, 0, 0.243348,-0.00780376)    );
  // itree = 780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0456432,-0.0350066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378352,0.01412) , 
3, -0.926195, 1, 0, 0.270651,0.00614524) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0410448,-0.0119684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3125,-0.0255301) , 
3, 0.791636, 1, 0, 0.169291,-0.0279622) , 
1, 1.2054, 1, 0, 0.244867,-0.00253108)    );
  // itree = 781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48,0.00517035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345745,-0.00948418) , 
0, -1.08631, 1, 0, 0.405325,-0.0311889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273585,0.0126332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218551,0.00207776) , 
0, -1.01312, 1, 0, 0.222024,0.00339109) , 
3, -1.30768, 1, 0, 0.252725,-0.0024008)    );
  // itree = 782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3375,0.0062028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259976,-0.00182483) , 
0, -0.268514, 1, 0, 0.296057,0.0119974) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0813155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147059,-0.0159834) , 
2, 0.597803, 1, 0, 0.10101,-0.0347497) , 
3, 0.873167, 1, 0, 0.248776,0.000665464)    );
  // itree = 783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.076595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225,0.100161) , 
0, -0.162489, 1, 0, 0.0888158,-0.0425119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304569,0.00442477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148515,-0.0426961) , 
0, 1.56036, 1, 0, 0.29517,-0.00479361) , 
1, -0.761509, 1, 0, 0.263503,-0.0105818)    );
  // itree = 784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245283,0.0250987) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221572,-0.00935884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382759,0.0074944) , 
2, 1.31942, 1, 0, 0.24713,-0.00769134) , 
0, -1.29224, 1, 0, 0.246982,-0.00453929)    );
  // itree = 785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334311,0.00260378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119205,-0.0252284) , 
0, 1.36141, 1, 0, 0.312871,-0.00195296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0651558,-0.0112013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216667,0.105887) , 
1, 1.71848, 1, 0, 0.103594,-0.0320564) , 
1, 1.22922, 1, 0, 0.263078,-0.00911541)    );
  // itree = 786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319549,0.00423009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.04375,-0.0438091) , 
3, -0.692654, 1, 0, 0.215962,0.0382685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281227,-0.000109078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0823045,-0.0234407) , 
3, 1.35645, 1, 0, 0.250633,0.00010879) , 
1, -0.53797, 1, 0, 0.24327,0.0082125)    );
  // itree = 787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0305484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0597826,-0.0586817) , 
3, -0.957749, 1, 0, 0.0340633,0.0468957) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296471,-0.00281145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273103,-0.00742429) , 
3, 0.280106, 1, 0, 0.285714,0.00267934) , 
1, -0.628404, 1, 0, 0.233635,0.0118299)    );
  // itree = 788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27027,0.0458004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238579,0.0173559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245758,-0.00455335) , 
1, -1.09844, 1, 0, 0.245016,-0.00273729) , 
0, -1.35128, 1, 0, 0.246835,0.0016032)    );
  // itree = 789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365035,-0.00907389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293103,-0.0011313) , 
0, 0.0899978, 1, 0, 0.336726,0.00222537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101408,-0.0029068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113971,-0.00225576) , 
0, -0.128422, 1, 0, 0.10901,-0.0182092) , 
1, 0.583399, 1, 0, 0.23821,-0.00661517)    );
  // itree = 790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419118,0.00251414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30867,0.00349351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0966667,-0.0238078) , 
3, 0.636233, 1, 0, 0.243034,-0.00582348) , 
0, -1.52623, 1, 0, 0.254581,-0.00304317)    );
  // itree = 791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00549451,-0.0675298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,0.00348627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304552,0.00341559) , 
1, -0.481205, 1, 0, 0.268036,-0.00389203) , 
1, -1.19679, 1, 0, 0.243952,0.0011599)    );
  // itree = 792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230415,0.00544819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179245,-0.0988599) , 
0, 0.0796156, 1, 0, 0.213622,-0.0441057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294779,0.00837541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164286,-0.0224693) , 
1, 1.29935, 1, 0, 0.261862,0.00100277) , 
1, -0.752382, 1, 0, 0.254024,-0.00632623)    );
  // itree = 793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318925,0.00094606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214082,-0.0125728) , 
0, -0.207394, 1, 0, 0.261143,-0.00211278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0542169,-0.0242059) , 
3, 1.73078, 1, 0, 0.244573,0.00150319)    );
  // itree = 794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419355,0.0183821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.00369454) , 
3, -1.292, 1, 0, 0.263158,0.0111568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312178,0.00534447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230858,0.00432801) , 
0, -0.0600417, 1, 0, 0.263668,-0.0140368) , 
1, -0.239149, 1, 0, 0.263517,-0.00657564)    );
  // itree = 795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0842886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288932,0.000994305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231076,0.00491727) , 
3, 1.39666, 1, 0, 0.280886,-0.00516493) , 
0, -1.43147, 1, 0, 0.258673,-0.000215966)    );
  // itree = 796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274319,0.010546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228324,-0.00664946) , 
1, -0.3871, 1, 0, 0.24078,-0.00213047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44,0.030309) , 
1, 1.77419, 1, 0, 0.250751,0.000765235)    );
  // itree = 797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40099,0.00352093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25052,0.00944276) , 
3, -1.24052, 1, 0, 0.283469,-0.00159203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0123177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485437,-0.0409885) , 
2, 1.82416, 1, 0, 0.0628019,-0.0403247) , 
2, 1.52497, 1, 0, 0.261209,-0.00549928)    );
  // itree = 798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345124,0.00165794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13371,0.000224568) , 
3, 0.135946, 1, 0, 0.273938,0.0060799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204724,0.00145338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173134,0.0037769) , 
0, 1.04668, 1, 0, 0.181818,-0.0299139) , 
0, 0.821543, 1, 0, 0.253065,-0.00207563)    );
  // itree = 799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0787524) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269036,-0.00133007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00884956,-0.0702321) , 
3, 1.89048, 1, 0, 0.253446,-0.0113843) , 
0, -1.58783, 1, 0, 0.238523,-0.00813466)    );
  // itree = 800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103685,-0.0105027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4687,0.0137035) , 
3, 0.276577, 1, 0, 0.230726,0.00292326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327044,-0.0248577) , 
0, 1.4416, 1, 0, 0.238584,-0.000780433)    );
  // itree = 801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394608,-0.000725555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.072,-0.0163501) , 
1, 0.886747, 1, 0, 0.318949,0.0153601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438406,-0.00550093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180544,0.00158198) , 
1, -0.469325, 1, 0, 0.228341,-0.0120356) , 
0, -0.617366, 1, 0, 0.252226,-0.00481405)    );
  // itree = 802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350975,-0.000298686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123874,-0.0132588) , 
3, -0.204472, 1, 0, 0.2642,0.0115101) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205357,0.000709985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234542,0.00813806) , 
0, -0.0336202, 1, 0, 0.22236,-0.0210177) , 
1, 0.767416, 1, 0, 0.247077,-0.001802)    );
  // itree = 803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237795,0.00460351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234582,-0.00943711) , 
2, -0.415198, 1, 0, 0.235904,-0.00532386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578947,0.0365401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112121,-0.0275804) , 
2, 0.582159, 1, 0, 0.271457,0.025188) , 
3, 0.802707, 1, 0, 0.244618,0.00215482)    );
  // itree = 804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108974,-0.00404321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446809,0.0187668) , 
3, -0.0387591, 1, 0, 0.248432,0.0104519) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189655,-0.0419859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38843,0.0108228) , 
1, 0.836111, 1, 0, 0.25779,-0.0271881) , 
0, 1.07303, 1, 0, 0.250128,0.00362756)    );
  // itree = 805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570025,0.0315633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239948,-0.0111017) , 
2, -0.739844, 1, 0, 0.35399,-0.0170039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0518519,-0.0204679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148096,-0.000671947) , 
0, -0.308546, 1, 0, 0.132701,0.0144905) , 
3, 0.0803776, 1, 0, 0.261622,-0.00385785)    );
  // itree = 806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470085,0.00559183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237794,-0.000864298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.0256299) , 
3, 1.93393, 1, 0, 0.228231,-0.0113485) , 
0, -1.52623, 1, 0, 0.242625,-0.00707991)    );
  // itree = 807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197605,0.0399085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209542,-0.00396646) , 
2, -1.3798, 1, 0, 0.207929,-0.0111786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.767241,0.0577856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182749,-0.0200167) , 
2, -0.312105, 1, 0, 0.2675,0.0157816) , 
3, 0.331768, 1, 0, 0.231336,-0.000585209)    );
  // itree = 808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212121,0.0227739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241259,-0.0100094) , 
0, -1.44988, 1, 0, 0.239177,-0.00828061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389163,0.0302724) , 
0, 1.32355, 1, 0, 0.254022,-0.00263361)    );
  // itree = 809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267823,-0.00342753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193252,-0.00473752) , 
0, 0.943194, 1, 0, 0.254912,0.00224949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0482759,-0.0212233) , 
3, 1.74551, 1, 0, 0.240138,-0.00186064)    );
  // itree = 810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327386,0.00855499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0359222) , 
3, 0.46859, 1, 0, 0.251262,0.00994345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409524,0.0286463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319672,0.00114732) , 
1, 1.2548, 1, 0, 0.361233,-0.0361355) , 
2, 1.53606, 1, 0, 0.263682,0.0047395)    );
  // itree = 811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177358,-0.0150502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316923,0.0139106) , 
3, 0.781585, 1, 0, 0.204848,-0.00228628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503876,0.0169805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348039,0.00844466) , 
1, 0.300446, 1, 0, 0.408408,-0.033828) , 
0, 1.08217, 1, 0, 0.239032,-0.007583)    );
  // itree = 812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267016,0.0248758) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255659,-0.00379481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273092,-0.0236748) , 
0, 1.23857, 1, 0, 0.258138,-0.00830683) , 
1, -1.102, 1, 0, 0.259011,-0.00417191)    );
  // itree = 813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459519,0.00509561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144578,-0.012106) , 
2, -0.441097, 1, 0, 0.26412,-0.0209793) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208494,-0.0163248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124088,0.0144364) , 
3, 1.10016, 1, 0, 0.179293,0.011242) , 
0, 0.363001, 1, 0, 0.230461,-0.0081941)    );
  // itree = 814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495726,0.0289203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245059,-0.0301759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208103,-0.00895338) , 
0, -0.862516, 1, 0, 0.213071,0.00279657) , 
3, -1.98613, 1, 0, 0.229615,0.000237913)    );
  // itree = 815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0770716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220339,0.0841392) , 
0, -0.0221055, 1, 0, 0.0722222,-0.0330679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0906433,-0.0194377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351014,0.00188631) , 
1, -0.076417, 1, 0, 0.296182,-0.00191058) , 
1, -0.701998, 1, 0, 0.255544,-0.00756413)    );
  // itree = 816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248466,0.0187726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431655,-0.0342612) , 
3, 1.23306, 1, 0, 0.266112,0.0119716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0965147,-0.0445132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72449,0.00854227) , 
3, 1.75791, 1, 0, 0.227176,-0.0301505) , 
0, 0.823646, 1, 0, 0.256531,0.00160614)    );
  // itree = 817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527273,0.00465611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326437,0.00329361) , 
3, -1.01241, 1, 0, 0.413072,0.00578252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171875,0.00746253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132191,-0.0150385) , 
0, -0.291291, 1, 0, 0.144879,-0.0153113) , 
1, -0.0805323, 1, 0, 0.249237,-0.00710338)    );
  // itree = 818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131944,-0.0349389) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349166,-0.00433813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175295,-0.00318483) , 
3, -0.27198, 1, 0, 0.24734,-0.00602468) , 
1, -1.25764, 1, 0, 0.23913,-0.00224873)    );
  // itree = 819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0866373,-0.0314147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168724,-0.012088) , 
3, -0.388717, 1, 0, 0.129078,0.00582437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.743243,0.0387005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399177,0.00862222) , 
3, 0.788606, 1, 0, 0.588126,-0.0271704) , 
1, 1.19106, 1, 0, 0.256029,-0.00330041)    );
  // itree = 820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112426,0.0438935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124339,-0.0199434) , 
2, -1.37453, 1, 0, 0.122794,-0.0104495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165217,-0.0315628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554257,0.0102445) , 
2, -0.179376, 1, 0, 0.491597,0.0117772) , 
3, 0.486829, 1, 0, 0.253347,-0.00258144)    );
  // itree = 821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548872,0.00924662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226457,-0.00960669) , 
2, -0.70647, 1, 0, 0.378698,-0.0183463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962343,-0.016402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231863,0.0194985) , 
0, 0.189927, 1, 0, 0.176969,0.00121955) , 
3, -0.435343, 1, 0, 0.261106,-0.00694092)    );
  // itree = 822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378738,0.00447403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196875,-0.00601767) , 
3, -1.23725, 1, 0, 0.255048,0.0179987) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246701,-0.00635462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201613,0.00707257) , 
0, 1.40806, 1, 0, 0.241659,-0.00879376) , 
1, 0.259956, 1, 0, 0.247805,0.00350464)    );
  // itree = 823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14881,-0.0119477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155682,-0.00121609) , 
2, -0.297262, 1, 0, 0.152706,-0.0108463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627604,0.00160822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,-0.0292874) , 
3, 1.40895, 1, 0, 0.530488,0.0137076) , 
1, 1.21354, 1, 0, 0.24364,-0.00493605)    );
  // itree = 824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129252,0.0334306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0747283,-0.0378535) , 
2, -0.971344, 1, 0, 0.0902913,-0.0132089) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990099,-0.0624255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457666,0.0112185) , 
2, -0.737804, 1, 0, 0.420513,0.0114116) , 
3, -0.0682472, 1, 0, 0.250873,-0.00123635)    );
  // itree = 825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35845,-0.0030161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,-0.00761874) , 
3, -0.0708865, 1, 0, 0.256789,0.00250507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101695,-0.0437266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191111,0.0177819) , 
3, 0.44461, 1, 0, 0.16035,-0.0435782) , 
0, 1.13798, 1, 0, 0.24055,-0.00525466)    );
  // itree = 826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413223,-0.000677953) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26377,0.00231401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0284198) , 
3, 1.49665, 1, 0, 0.237687,-0.00652577) , 
0, -1.58783, 1, 0, 0.248366,-0.00237232)    );
  // itree = 827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679887,-0.01183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17757,0.0255502) , 
3, 0.155094, 1, 0, 0.0934783,0.0133542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103448,-0.0200405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46267,0.0154349) , 
1, 0.567181, 1, 0, 0.395584,-0.024619) , 
1, 0.227361, 1, 0, 0.2571,-0.00721225)    );
  // itree = 828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244444,0.00404313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287812,-0.0304028) , 
0, -0.416819, 1, 0, 0.270557,-0.020523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128788,-0.0570192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234899,0.00703625) , 
0, -0.635545, 1, 0, 0.218928,-0.00173506) , 
1, 0.552807, 1, 0, 0.248008,-0.0123173)    );
  // itree = 829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00255534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350993,-0.00926272) , 
0, -0.790152, 1, 0, 0.406639,0.0160634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280822,0.0125356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123994,0.00321415) , 
3, 0.417812, 1, 0, 0.215765,-0.0110056) , 
2, -0.703426, 1, 0, 0.262254,-0.00441278)    );
  // itree = 830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535971,0.0415293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181303,-0.00935793) , 
3, -1.2743, 1, 0, 0.281504,0.0254429) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.00263575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0742574,-0.0182831) , 
3, 1.40041, 1, 0, 0.242394,-0.0167313) , 
1, 0.415644, 1, 0, 0.261929,0.00433441)    );
  // itree = 831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186235,0.0242717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285417,0.027073) , 
2, -0.879111, 1, 0, 0.251719,-0.0125502) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277108,-0.00281125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219394,-0.0166309) , 
0, 0.0754209, 1, 0, 0.241119,0.0133936) , 
3, -0.551853, 1, 0, 0.244878,0.00419306)    );
  // itree = 832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258621,0.0580276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207122,-0.00958138) , 
1, -1.36935, 1, 0, 0.210439,-0.00447841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770701,0.0307328) , 
3, 1.73078, 1, 0, 0.255363,0.00122925)    );
  // itree = 833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655738,0.0662207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383333,-0.00677678) , 
2, -1.61257, 1, 0, 0.438538,0.0201416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272,-0.00244786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129754,3.01352e-05) , 
1, 0.244165, 1, 0, 0.180775,-0.01524) , 
2, -0.549836, 1, 0, 0.258517,-0.00456883)    );
  // itree = 834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310345,0.000912536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0226131,-0.0632895) , 
3, -0.354416, 1, 0, 0.205667,0.0053016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393372,0.0186145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0359609) , 
3, 1.5651, 1, 0, 0.320136,-0.0184173) , 
2, 0.30194, 1, 0, 0.256825,-0.00529875)    );
  // itree = 835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237632,-0.00519449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276786,-0.00259283) , 
2, 0.542231, 1, 0, 0.249861,0.00220514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,0.0721356) , 
3, 1.64499, 1, 0, 0.251277,-0.00611748)    );
  // itree = 836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584416,-0.00670546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495868,0.0442783) , 
3, -1.45297, 1, 0, 0.250909,0.034056) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221039,-0.0115444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418182,0.0218805) , 
1, 1.66028, 1, 0, 0.233743,-0.00972408) , 
0, -0.972742, 1, 0, 0.236125,-0.00364965)    );
  // itree = 837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447368,-0.0255917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259238,0.0108218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654206,-0.00711882) , 
3, 1.89909, 1, 0, 0.247792,0.00379063) , 
3, -1.95723, 1, 0, 0.259605,0.000519411)    );
  // itree = 838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388724,0.00900874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150769,-0.0148968) , 
3, -1.25544, 1, 0, 0.21189,0.00458273) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459259,0.0122955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10728,-0.00426741) , 
3, 1.07875, 1, 0, 0.321321,-0.0256569) , 
2, 0.648293, 1, 0, 0.248736,-0.00559908)    );
  // itree = 839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227357,-0.00979891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284178,0.00701523) , 
2, 0.31591, 1, 0, 0.248702,-0.00647612) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256881,0.010963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233333,-0.0142326) , 
1, 1.4124, 1, 0, 0.248521,0.0336946) , 
3, 1.29328, 1, 0, 0.248672,7.99989e-05)    );
  // itree = 840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0462963,-0.0258588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357143,0.0454645) , 
3, -1.58724, 1, 0, 0.204545,0.0251167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194737,-0.0429394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251376,-0.00592325) , 
1, -0.68479, 1, 0, 0.245479,-0.0120253) , 
1, -1.09318, 1, 0, 0.241076,-0.00802962)    );
  // itree = 841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462555,-0.00375446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24714,0.00949984) , 
1, -0.416787, 1, 0, 0.320783,0.0100209) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0901408,-0.0235652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112628,0.00873262) , 
3, 0.832101, 1, 0, 0.100309,-0.0199218) , 
2, 0.638026, 1, 0, 0.248482,0.0002016)    );
  // itree = 842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476923,0.00451132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350844,0.0137588) , 
0, -1.53713, 1, 0, 0.375566,-0.0122148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10828,-0.0220286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.363985,0.0257256) , 
2, 0.826745, 1, 0, 0.210406,0.0191844) , 
3, -0.729479, 1, 0, 0.26599,0.00861706)    );
  // itree = 843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214174,-0.00799063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293617,-0.00916756) , 
3, 0.438251, 1, 0, 0.235462,0.00391828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504425,0.0982546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17037,0.0189546) , 
0, 1.17142, 1, 0, 0.322581,-0.0614018) , 
3, 1.45397, 1, 0, 0.246254,-0.00417332)    );
  // itree = 844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197926,0.00248203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0692771,-0.0606471) , 
2, 0.628441, 1, 0, 0.169241,-0.00687729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.69637,0.0357903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382979,-0.0030808) , 
1, 1.19016, 1, 0, 0.55948,0.0364687) , 
3, 0.824791, 1, 0, 0.272817,0.00462746)    );
  // itree = 845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353933,-0.00336553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179218,-0.000533591) , 
3, -0.382409, 1, 0, 0.259412,0.00450575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160714,0.0496071) , 
1, 1.68939, 1, 0, 0.254022,0.00218053)    );
  // itree = 846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341501,-0.00493288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0183486,-0.0729432) , 
3, 0.313975, 1, 0, 0.295276,-0.0229162) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245087,0.00140715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165591,-0.0131281) , 
0, 0.839136, 1, 0, 0.217293,0.00267726) , 
0, -0.333741, 1, 0, 0.245698,-0.00664503)    );
  // itree = 847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248434,0.025541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248313,0.00126275) , 
2, -0.636036, 1, 0, 0.248361,-0.0130107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125436,-0.0193472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370518,-0.00445051) , 
1, 0.701961, 1, 0, 0.281369,0.00275577) , 
3, 0.331768, 1, 0, 0.261324,-0.00681871)    );
  // itree = 848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116216,-0.00111375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453249,0.0160013) , 
3, 0.178242, 1, 0, 0.238369,0.00918377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328859,-0.0127762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304,-0.0413561) , 
1, 1.40284, 1, 0, 0.317518,-0.0357103) , 
2, 1.46433, 1, 0, 0.249132,0.00307907)    );
  // itree = 849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431579,0.00355049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267176,0.00657322) , 
3, -0.476105, 1, 0, 0.352834,0.00633341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12642,-0.00639849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273973,-0.0489504) , 
3, 1.67862, 1, 0, 0.109412,-0.0178163) , 
2, 0.342305, 1, 0, 0.246399,-0.00422589)    );
  // itree = 850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0257898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380634,0.005725) , 
1, -1.40627, 1, 0, 0.347949,-0.018256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119385,-0.0196363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343115,0.0166482) , 
2, 0.888457, 1, 0, 0.196276,0.0141278) , 
3, -0.610112, 1, 0, 0.25,0.00265717)    );
  // itree = 851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233983,0.0457976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238897,-0.00361318) , 
3, -1.26054, 1, 0, 0.237154,-0.0056157) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00698072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302583,-0.0132682) , 
1, 0.150446, 1, 0, 0.265595,0.0267036) , 
3, -0.139172, 1, 0, 0.251691,0.0109031)    );
  // itree = 852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130178,-0.00568363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474699,0.0216918) , 
3, 0.037542, 1, 0, 0.243651,0.00859428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107794,-0.0430736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680851,0.01059) , 
3, 1.53977, 1, 0, 0.243995,-0.0244667) , 
0, 0.399075, 1, 0, 0.243784,-0.00415621)    );
  // itree = 853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440298,0.00433684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354402,-0.0165157) , 
0, -1.41669, 1, 0, 0.37435,-0.0171246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163043,-0.00120232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21256,0.00307396) , 
0, -0.169891, 1, 0, 0.197324,0.000927112) , 
3, -0.871513, 1, 0, 0.246622,-0.00409984)    );
  // itree = 854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140696,-0.0244512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304646,0.0102166) , 
2, -0.477015, 1, 0, 0.249747,-0.0114191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347107,0.0372635) , 
2, 1.85179, 1, 0, 0.25537,-0.00803407)    );
  // itree = 855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0847122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27493,0.00269824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186992,-0.0263127) , 
0, 1.50857, 1, 0, 0.269231,-0.0105931) , 
0, -1.35128, 1, 0, 0.246265,-0.00735875)    );
  // itree = 856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939716,-0.0172031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554479,0.0298621) , 
3, -0.306924, 1, 0, 0.288639,0.0117713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110345,-0.0752939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233184,-0.00137095) , 
0, -0.700917, 1, 0, 0.216008,-0.0139996) , 
1, 0.344779, 1, 0, 0.251241,-0.00149806)    );
  // itree = 857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275701,-0.00488764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779661,-0.00315804) , 
3, 1.00874, 1, 0, 0.243168,0.00714815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225806,0.0281136) , 
0, 1.44177, 1, 0, 0.241786,0.00156835)    );
  // itree = 858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155756,-0.0215511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389497,0.0160508) , 
2, -0.065042, 1, 0, 0.274444,-0.017284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0611111,-0.0255487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.035778) , 
0, 1.37735, 1, 0, 0.0659722,0.0250405) , 
3, 1.34716, 1, 0, 0.24569,-0.0114461)    );
  // itree = 859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0910326,0.00942369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0938967,-0.0193266) , 
1, -0.0424473, 1, 0, 0.0916754,0.0087821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132231,-0.00603811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435979,0.00836293) , 
1, 0.492495, 1, 0, 0.401501,-0.0134676) , 
1, 0.324332, 1, 0, 0.255583,-0.00298873)    );
  // itree = 860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218794,0.0105892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0966952,-0.0356866) , 
0, -0.280691, 1, 0, 0.153595,-0.00923607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354545,-0.00890038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56686,0.0243938) , 
3, 1.02558, 1, 0, 0.515419,0.0322634) , 
3, 0.824791, 1, 0, 0.236391,0.00026028)    );
  // itree = 861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485981,-0.017326) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00608111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221732,-0.00325889) , 
0, -1.1532, 1, 0, 0.224649,-0.00130238) , 
3, -2.02293, 1, 0, 0.238424,-0.00383166)    );
  // itree = 862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326087,0.00216781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0414747,-0.0259414) , 
3, -0.0662826, 1, 0, 0.250307,0.0138371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283019,0.0012076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235602,0.00571996) , 
0, 0.271811, 1, 0, 0.259516,-0.0146278) , 
1, 0.0934277, 1, 0, 0.255708,-0.00285772)    );
  // itree = 863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00420757,-0.0671831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552147,0.0484867) , 
0, 0.901874, 1, 0, 0.106164,0.0180103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425234,0.0140479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316129,-0.0176389) , 
0, 0.520025, 1, 0, 0.379404,-0.0115721) , 
1, 0.22651, 1, 0, 0.258699,0.00149607)    );
  // itree = 864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284024,0.0504436) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186751,-0.00313818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545788,-0.023127) , 
3, 1.38149, 1, 0, 0.239505,-0.00966504) , 
0, -1.35128, 1, 0, 0.243217,-0.00370552)    );
  // itree = 865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29003,-0.00120326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23356,-0.0065121) , 
0, 0.586991, 1, 0, 0.275921,-3.86489e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0648649,-0.0230904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113208,0.0180835) , 
2, 1.50105, 1, 0, 0.0824742,0.0409623) , 
3, 1.29328, 1, 0, 0.248541,0.0057645)    );
  // itree = 866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166232,-0.0222495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317949,0.0045497) , 
2, 0.328363, 1, 0, 0.227579,0.00586812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440298,0.0856658) , 
1, 1.65151, 1, 0, 0.241396,-0.0026705)    );
  // itree = 867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229199,-0.00346845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277211,-0.0170048) , 
3, 0.335191, 1, 0, 0.244361,0.00358582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268293,0.0504345) , 
3, 1.55602, 1, 0, 0.246734,-0.00295015)    );
  // itree = 868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0275862,-0.039258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357222,0.0154862) , 
3, -1.26751, 1, 0, 0.27736,0.0101736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153509,-0.0212007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0145103) , 
1, 1.78828, 1, 0, 0.197704,-0.013867) , 
1, 0.751632, 1, 0, 0.245835,0.000659326)    );
  // itree = 869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454918,-0.00773749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298834,-0.0155464) , 
3, -1.34311, 1, 0, 0.339785,0.0376045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147643,0.00428467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512821,-0.0336173) , 
3, 1.35849, 1, 0, 0.123262,0.00336554) , 
1, 0.29434, 1, 0, 0.223494,0.0192153)    );
  // itree = 870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290865,-0.000624313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0354331,-0.0538024) , 
3, 0.523018, 1, 0, 0.21697,0.000692247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31405,-0.015247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316239,-0.00502848) , 
1, 1.34215, 1, 0, 0.315126,-0.0399226) , 
2, 1.48783, 1, 0, 0.228686,-0.00415546)    );
  // itree = 871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316206,0.0394755) , 
3, -2.01251, 1, 0, 0.226629,-0.0237496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111562,-0.0125559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490909,0.0115244) , 
1, 0.909014, 1, 0, 0.255814,-0.000579111) , 
3, -1.33958, 1, 0, 0.250514,-0.0047865)    );
  // itree = 872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0169492,-0.0576124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229405,-0.00163657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835938,0.0291922) , 
3, 1.84137, 1, 0, 0.270789,0.00198779) , 
3, -1.85976, 1, 0, 0.255767,-0.000493444)    );
  // itree = 873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411669,-0.00828964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190438,0.00229283) , 
1, -0.219298, 1, 0, 0.263355,0.00335217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0641026,-0.00184359) , 
3, 1.73078, 1, 0, 0.248028,-0.00284879)    );
  // itree = 874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301587,0.00376789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405117,-0.0443884) , 
3, 0.46859, 1, 0, 0.230769,0.00869559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308271,-0.0165418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373832,0.0154027) , 
2, 1.82362, 1, 0, 0.3375,-0.0421807) , 
2, 1.46214, 1, 0, 0.243779,0.00249431)    );
  // itree = 875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146959,-0.0163081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294049,0.00442111) , 
0, -0.460677, 1, 0, 0.233954,-0.0121573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29798,-0.0122865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134921,0.0139358) , 
3, 1.81233, 1, 0, 0.258621,0.0156038) , 
3, 0.802707, 1, 0, 0.240487,-0.00480504)    );
  // itree = 876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0242718,-0.0389376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311548,0.00689353) , 
3, -1.1996, 1, 0, 0.252012,0.00309826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268657,-0.0443952) , 
1, 1.62191, 1, 0, 0.253063,-0.00227569)    );
  // itree = 877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367868,-0.00564083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200747,-0.00608815) , 
3, -0.759995, 1, 0, 0.264824,0.00253641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568182,-0.0291791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0758621,0.00120829) , 
1, 1.29413, 1, 0, 0.0654206,0.0411606) , 
3, 1.29216, 1, 0, 0.233722,0.00856087)    );
  // itree = 878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136207,-0.0381957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481538,0.0207851) , 
2, -0.390196, 1, 0, 0.318699,-0.0116123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0798005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148377,-0.0137025) , 
2, -0.200007, 1, 0, 0.125163,0.0145309) , 
3, 0.275101, 1, 0, 0.244367,-0.00157131)    );
  // itree = 879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.018018,0.0354211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0839695,0.0641694) , 
2, -1.09591, 1, 0, 0.053719,-0.0415607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283165,0.000925895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33121,0.0183889) , 
0, 1.47114, 1, 0, 0.287269,0.0018585) , 
1, -1.00498, 1, 0, 0.260096,-0.00319316)    );
  // itree = 880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252677,0.0132064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0472441,-0.0372679) , 
1, 1.10768, 1, 0, 0.208754,0.00639157) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305556,-0.0681723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324633,-0.0115251) , 
1, 0.0488807, 1, 0, 0.321775,-0.0237993) , 
2, 0.495408, 1, 0, 0.251441,-0.00501107)    );
  // itree = 881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385965,-0.00862647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792952,-0.0172498) , 
3, -0.358647, 1, 0, 0.291892,0.0312356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28934,0.00689637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124378,0.0112575) , 
3, 0.855556, 1, 0, 0.233613,-0.0107825) , 
0, -0.285518, 1, 0, 0.255959,0.00532806)    );
  // itree = 882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312213,-0.00117868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0868217,-0.0170219) , 
3, 0.164912, 1, 0, 0.228374,-0.00462593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415842,0.00686968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287129,-0.0125079) , 
0, 1.02575, 1, 0, 0.351485,-0.0325175) , 
2, 1.60075, 1, 0, 0.241219,-0.0075361)    );
  // itree = 883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0133333,-0.0445869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112957,-0.0217648) , 
3, -1.81507, 1, 0, 0.10192,0.0129727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.677419,0.0375867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507881,0.0122416) , 
0, -0.635545, 1, 0, 0.53813,-0.00908509) , 
1, 0.940933, 1, 0, 0.249878,0.00549091)    );
  // itree = 884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110619,-0.00462133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515098,0.0340585) , 
3, -0.0166131, 1, 0, 0.265849,0.0187073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0444444,-0.0761745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359873,0.00590418) , 
2, 0.26257, 1, 0, 0.244939,-0.0193163) , 
0, 0.780176, 1, 0, 0.260581,0.00912872)    );
  // itree = 885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464531,-0.000338404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0289855,-0.0690022) , 
2, 0.0442816, 1, 0, 0.36,-0.0213515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204509,0.0140196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248548,0.0110772) , 
0, 0.0811208, 1, 0, 0.230094,0.0140858) , 
3, -0.871513, 1, 0, 0.266407,0.00417994)    );
  // itree = 886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29589,0.00283782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0847458,0.0159103) , 
3, -0.471842, 1, 0, 0.226937,0.0137966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244648,0.000146021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315476,0.00855488) , 
2, 1.73743, 1, 0, 0.25271,-0.0109809) , 
1, -0.368349, 1, 0, 0.245788,-0.0043261)    );
  // itree = 887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0330189,-0.0298139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681319,0.0442146) , 
1, -0.396608, 1, 0, 0.332487,0.0234876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254093,-0.000412375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238095,0.0289092) , 
3, 1.54736, 1, 0, 0.251834,-0.0155113) , 
2, -0.932967, 1, 0, 0.267488,-0.00794202)    );
  // itree = 888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0269461,-0.0399844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314145,0.0101145) , 
3, -1.25024, 1, 0, 0.252258,0.00533298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153153,-0.0570821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263804,-0.0157297) , 
1, -0.0814273, 1, 0, 0.235698,-0.0347559) , 
0, 0.900791, 1, 0, 0.248616,-0.00348375)    );
  // itree = 889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363178,-0.000696335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211462,0.0131937) , 
3, -0.455126, 1, 0, 0.278116,-0.00991149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0326797,-0.0400558) , 
3, 1.74459, 1, 0, 0.258938,-0.00550688)    );
  // itree = 890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200565,0.00289159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1974,-0.00648686) , 
1, -0.691095, 1, 0, 0.198333,0.0122176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,0.024828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339806,0.0159416) , 
1, 0.206918, 1, 0, 0.340909,-0.0247176) , 
2, 0.32187, 1, 0, 0.260358,-0.00385024)    );
  // itree = 891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172676,-0.00887871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256223,0.00532189) , 
2, -0.420441, 1, 0, 0.219835,-0.0081671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15528,0.00749195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351899,-0.0086616) , 
1, 0.857901, 1, 0, 0.263598,0.0204724) , 
3, 0.356305, 1, 0, 0.236118,0.00248913)    );
  // itree = 892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129781,-0.00582235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562147,0.0244978) , 
3, -0.10288, 1, 0, 0.270718,0.00971477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127907,-0.0574533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232456,0.00315304) , 
0, -0.325275, 1, 0, 0.203822,-0.0148102) , 
1, 0.475892, 1, 0, 0.239645,-0.00167702)    );
  // itree = 893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32664,0.0050831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0942857,-0.00886133) , 
2, 0.898648, 1, 0, 0.282538,-0.00122758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.06875,0.00129812) , 
3, 1.74459, 1, 0, 0.265469,0.00303042)    );
  // itree = 894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26506,0.0032629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00492611,-0.076645) , 
3, 1.06493, 1, 0, 0.232342,-0.0078865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378378,0.0173385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288462,-0.00336804) , 
1, 0.808479, 1, 0, 0.315364,-0.0348377) , 
2, 1.12881, 1, 0, 0.247859,-0.0129237)    );
  // itree = 895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164456,-0.01822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308123,-0.0094505) , 
3, 0.517573, 1, 0, 0.198925,0.0072136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684524,0.0267626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265683,0.00591329) , 
2, 0.375148, 1, 0, 0.425968,-0.0296591) , 
0, 0.834197, 1, 0, 0.250649,-0.00118655)    );
  // itree = 896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197257,0.00487146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0652591,-0.0422487) , 
0, 0.151201, 1, 0, 0.150442,-0.00748757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480952,0.0405293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537313,-0.00280693) , 
3, 1.20733, 1, 0, 0.515596,0.0210983) , 
3, 0.721703, 1, 0, 0.249255,0.000247942)    );
  // itree = 897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468468,-0.0194833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256767,0.00340392) , 
3, -1.95473, 1, 0, 0.273504,0.00492946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265306,-0.0106986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0111597) , 
1, 0.4527, 1, 0, 0.195122,-0.0212511) , 
0, 0.676581, 1, 0, 0.250758,-0.00266793)    );
  // itree = 898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439232,0.0250364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137143,-0.00646619) , 
3, -0.663668, 1, 0, 0.279678,0.0121886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,-0.006269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423729,0.0304789) , 
2, 1.8058, 1, 0, 0.232448,-0.00704291) , 
1, 0.367449, 1, 0, 0.255371,0.00229113)    );
  // itree = 899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228337,-0.00391307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598765,0.0448532) , 
0, 1.34822, 1, 0, 0.260428,-0.000615869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0788591) , 
3, 1.98299, 1, 0, 0.24534,0.00316211)    );
  // itree = 900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,-0.0714857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26204,0.00445075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29765,-0.02593) , 
2, 1.16684, 1, 0, 0.269638,-0.00267912) , 
2, -1.33738, 1, 0, 0.244389,-0.00736382)    );
  // itree = 901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361727,-0.00236189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147516,0.000632737) , 
3, -0.291836, 1, 0, 0.26982,0.00310991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252252,-0.00546253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123778,-0.00383842) , 
1, 0.464235, 1, 0, 0.177694,-0.0161063) , 
0, 0.759972, 1, 0, 0.245813,-0.00189768)    );
  // itree = 902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144578,-0.0129964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338739,0.00524026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103501,-0.0106222) , 
3, 0.487041, 1, 0, 0.251273,0.00049549) , 
1, -1.23776, 1, 0, 0.242111,0.00368714)    );
  // itree = 903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273556,-0.0361953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338235,0.0179338) , 
1, -0.592622, 1, 0, 0.236868,-0.00974681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424699,0.00682508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157895,-0.0206004) , 
2, 0.273454, 1, 0, 0.245079,0.0180815) , 
3, -0.112181, 1, 0, 0.240988,0.00421544)    );
  // itree = 904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265306,0.0466898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0706638,-0.0206213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431438,0.00638019) , 
3, -0.0305328, 1, 0, 0.247406,-0.00135945) , 
0, -1.61174, 1, 0, 0.248315,0.00156026)    );
  // itree = 905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396414,0.00366087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106862,-0.0158107) , 
1, 0.377333, 1, 0, 0.260433,0.00269169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117188,0.0208561) , 
1, 1.65151, 1, 0, 0.251361,0.00548486)    );
  // itree = 906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319843,-0.00396393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284314,0.00954675) , 
0, -0.259717, 1, 0, 0.300475,-0.00613489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0257732,-0.0644953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107595,-0.0133892) , 
0, 1.04647, 1, 0, 0.0625,0.0346472) , 
3, 1.14387, 1, 0, 0.259332,0.00091585)    );
  // itree = 907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0879121,-0.00849811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226044,-0.0173061) , 
3, -1.0735, 1, 0, 0.16083,0.0228168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302222,0.000181657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232759,-0.00456317) , 
3, 1.07653, 1, 0, 0.282853,-0.0118433) , 
0, -0.307347, 1, 0, 0.236256,0.00139244)    );
  // itree = 908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,0.0104615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103576,-0.0404404) , 
0, -0.295476, 1, 0, 0.151958,-0.0123283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209524,-0.00896104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674157,0.0285266) , 
2, 0.108199, 1, 0, 0.56833,0.0441604) , 
3, 0.897545, 1, 0, 0.249492,0.000904075)    );
  // itree = 909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441631,0.00501881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225455,0.000548961) , 
3, -0.23968, 1, 0, 0.347343,0.00502461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.09319,0.018918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122449,0.0168621) , 
0, -0.147531, 1, 0, 0.111111,-0.0241402) , 
1, 0.863356, 1, 0, 0.261484,-0.00557541)    );
  // itree = 910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0982143,-0.0497015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394472,0.00694932) , 
2, -1.14288, 1, 0, 0.329412,-0.0153392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129969,-0.0117384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23262,0.0152918) , 
1, 1.24837, 1, 0, 0.167315,0.00256945) , 
3, -0.112181, 1, 0, 0.248047,-0.0063499)    );
  // itree = 911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209283,-0.0243182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287234,0.00390153) , 
2, 0.603233, 1, 0, 0.23086,-0.00129892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,0.0523653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277228,-0.0270837) , 
1, 0.87878, 1, 0, 0.258065,0.0257851) , 
3, 1.30934, 1, 0, 0.23506,0.00288238)    );
  // itree = 912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165657,0.00106193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.047393) , 
2, 0.2817, 1, 0, 0.143624,-0.0110831) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397059,0.0022011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651163,0.020538) , 
3, 1.42838, 1, 0, 0.520755,0.0235172) , 
3, 0.824791, 1, 0, 0.242574,-0.00200482)    );
  // itree = 913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606061,0.0135676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.0232581) , 
1, 0.0153917, 1, 0, 0.440083,0.0192437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236559,-0.0026087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729167,-0.0263841) , 
2, 0.836193, 1, 0, 0.173971,-0.0123255) , 
2, -0.656951, 1, 0, 0.238693,-0.00464733)    );
  // itree = 914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341667,-0.0342015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238598,-0.002506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352564,0.0276535) , 
1, 1.56373, 1, 0, 0.247697,-0.00660339) , 
0, -1.68098, 1, 0, 0.253134,-0.00270713)    );
  // itree = 915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194888,0.00145722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33547,-0.00611453) , 
3, -0.00130422, 1, 0, 0.241649,0.00343027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293065,0.0107034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282051,0.028992) , 
2, 1.60907, 1, 0, 0.28972,-0.0228775) , 
2, 0.684685, 1, 0, 0.256711,-0.00481256)    );
  // itree = 916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231638,0.0223282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21445,-0.0052204) , 
0, -0.645332, 1, 0, 0.219432,0.00378545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65,-0.0276184) , 
3, 1.76176, 1, 0, 0.25,-0.000580907)    );
  // itree = 917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389497,-0.00489001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123711,-0.00878438) , 
1, 0.624389, 1, 0, 0.310292,0.017477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14377,0.000794476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0631868,-0.013227) , 
1, 1.00054, 1, 0, 0.100443,-0.0121038) , 
2, 0.642203, 1, 0, 0.238504,0.00735763)    );
  // itree = 918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0201414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316327,0.0184331) , 
2, -0.473246, 1, 0, 0.222433,0.0376948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270653,0.00349671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163743,0.0115345) , 
0, 1.38178, 1, 0, 0.257975,-0.0155439) , 
1, -0.418323, 1, 0, 0.248476,-0.00131445)    );
  // itree = 919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214826,0.019778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270742,-0.00827014) , 
3, -0.728037, 1, 0, 0.250277,0.00664894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254144,0.0427941) , 
3, 1.64499, 1, 0, 0.250629,0.00313908)    );
  // itree = 920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107692,0.0138208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537037,0.0453591) , 
3, -1.09031, 1, 0, 0.302521,0.0433076) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0927374,-0.0261458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458115,0.013237) , 
3, 0.298302, 1, 0, 0.261001,0.00104498) , 
1, -0.761509, 1, 0, 0.268353,0.00852899)    );
  // itree = 921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281883,0.000876378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144928,0.0208945) , 
3, 1.10099, 1, 0, 0.266843,0.00135749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0820896,0.0276695) , 
3, 1.73078, 1, 0, 0.254581,-0.00272897)    );
  // itree = 922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,0.00441118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265396,0.00758802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161209,-0.0167955) , 
0, 0.918133, 1, 0, 0.241908,-0.014354) , 
0, -1.14631, 1, 0, 0.253579,-0.00950239)    );
  // itree = 923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210694,-0.0120562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305344,-0.0130916) , 
3, 1.5254, 1, 0, 0.217979,-0.00428025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636364,0.00726865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328947,0.0448761) , 
2, 0.678268, 1, 0, 0.450199,-0.0512056) , 
0, 1.26376, 1, 0, 0.247824,-0.0103111)    );
  // itree = 924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305344,0.0760582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0402145,-0.0416886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38696,0.00155334) , 
3, -0.412408, 1, 0, 0.252724,-0.00767102) , 
1, -1.36544, 1, 0, 0.256074,-0.000994784)    );
  // itree = 925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733333,0.0339741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373303,-0.011804) , 
1, -1.42321, 1, 0, 0.457539,0.0204509) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184894,0.00631799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121547,-0.00390157) , 
0, 1.34189, 1, 0, 0.176997,-0.012596) , 
1, -0.29203, 1, 0, 0.256777,-0.00319825)    );
  // itree = 926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282486,0.0121495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0733945,0.00814783) , 
3, -0.983567, 1, 0, 0.202797,0.0378536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260471,-0.00307032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174603,0.00473481) , 
0, 1.41437, 1, 0, 0.251019,-0.00392951) , 
1, -0.887572, 1, 0, 0.244134,0.00203653)    );
  // itree = 927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237131,0.000700356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694805,0.0698825) , 
3, 0.968149, 1, 0, 0.289768,-0.0186626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204545,-0.028374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202667,-0.00207462) , 
0, 0.259684, 1, 0, 0.203361,0.00467534) , 
2, 0.689402, 1, 0, 0.263185,-0.0114826)    );
  // itree = 928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154215,0.0068911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544444,0.0428256) , 
3, 0.388176, 1, 0, 0.254274,0.0237963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287719,0.00607327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283582,-0.0438677) , 
0, 0.71989, 1, 0, 0.286008,-0.0218789) , 
2, 0.851789, 1, 0, 0.262434,0.0120513)    );
  // itree = 929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418785,0.00368092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132404,-0.0203055) , 
3, 0.36418, 1, 0, 0.349832,0.0112064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121134,0.0205916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115464,0.000424381) , 
0, -0.0171721, 1, 0, 0.117984,-0.0145503) , 
1, 0.670673, 1, 0, 0.251816,0.000317486)    );
  // itree = 930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413194,0.021539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126126,-0.0163004) , 
3, -1.07081, 1, 0, 0.259259,0.0304528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291018,-2.92965e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183908,-0.00440983) , 
0, 0.46308, 1, 0, 0.249816,-0.0101897) , 
1, -0.187201, 1, 0, 0.252781,0.00257018)    );
  // itree = 931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304676,0.0312445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240395,-0.00357781) , 
2, -0.401432, 1, 0, 0.267471,-0.012747) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330645,0.104654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261261,-0.000319968) , 
1, 0.977875, 1, 0, 0.286127,0.0334016) , 
2, 1.18512, 1, 0, 0.270833,-0.00443062)    );
  // itree = 932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228908,-0.00161511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273224,-0.0785877) , 
2, 1.4704, 1, 0, 0.208357,-0.00775144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698864,0.0224912) , 
3, 1.64499, 1, 0, 0.252156,-0.00278253)    );
  // itree = 933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453745,-0.0107968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224417,0.00380737) , 
3, -1.41669, 1, 0, 0.290816,0.00338254) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269406,0.00561624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100287,-0.00126041) , 
3, 1.04621, 1, 0, 0.221224,-0.0179788) , 
0, -0.293879, 1, 0, 0.248382,-0.00964268)    );
  // itree = 934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234973,-0.00341705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42517,0.0318756) , 
2, 0.685365, 1, 0, 0.275144,-0.00696529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255172,-0.00423706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196237,0.00803085) , 
3, 0.418347, 1, 0, 0.222054,0.0222166) , 
1, 1.01709, 1, 0, 0.258033,0.00243996)    );
  // itree = 935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0469314,-0.0403819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103943,0.0279972) , 
2, -0.711042, 1, 0, 0.0755396,0.0178958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330215,0.00553304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291262,0.0184972) , 
3, 1.13993, 1, 0, 0.32148,-0.0162284) , 
1, -0.300045, 1, 0, 0.250776,-0.00641814)    );
  // itree = 936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00934579,-0.0681567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260504,0.00666585) , 
3, -1.98773, 1, 0, 0.2463,0.00414134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458333,0.0433877) , 
1, 1.62191, 1, 0, 0.258946,0.00826695)    );
  // itree = 937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515152,0.00364626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0986547,-0.0304525) , 
1, 0.0852079, 1, 0, 0.379562,-0.0157719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265351,-0.00113897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146028,0.00657775) , 
1, 0.31377, 1, 0, 0.1875,0.0133109) , 
3, -0.610112, 1, 0, 0.25338,0.00333506)    );
  // itree = 938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40708,0.00869579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291971,-0.0658544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274041,0.00389096) , 
2, -0.955204, 1, 0, 0.23807,0.00203748) , 
3, -2.02293, 1, 0, 0.247725,-0.000666549)    );
  // itree = 939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193548,0.0282809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232818,-0.00656682) , 
2, -1.39557, 1, 0, 0.228203,-0.0108698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261062,0.000960155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352941,-0.0092355) , 
1, 1.35548, 1, 0, 0.291233,0.00897442) , 
3, 0.467199, 1, 0, 0.249498,-0.00416542)    );
  // itree = 940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0903226,0.00849622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0304348,-0.0491839) , 
2, -0.874477, 1, 0, 0.0545455,-0.0120556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517964,0.0245978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320242,-0.000863088) , 
1, 0.0813332, 1, 0, 0.370008,0.00866377) , 
3, -0.580667, 1, 0, 0.254173,0.00105579)    );
  // itree = 941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437567,0.00597247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137313,-0.0110557) , 
3, 0.268463, 1, 0, 0.358491,-0.00124457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,0.0254314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127434,0.0125487) , 
0, -0.333636, 1, 0, 0.123905,-0.0244876) , 
1, 0.670673, 1, 0, 0.267986,-0.0102118)    );
  // itree = 942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212676,-0.0106877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0143541,-0.0692174) , 
1, 0.863748, 1, 0, 0.167573,0.0242786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429619,0.00911445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120482,-0.00372669) , 
3, 0.823091, 1, 0, 0.312671,-0.00704699) , 
2, -0.0302898, 1, 0, 0.246528,0.00723289)    );
  // itree = 943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0421053,0.00356615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129464,-0.00636698) , 
3, -0.489019, 1, 0, 0.0745033,0.0129923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36338,0.000952898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234127,-0.0105387) , 
3, 1.34571, 1, 0, 0.338648,-0.0138654) , 
1, -0.186478, 1, 0, 0.255596,-0.00542081)    );
  // itree = 944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136771,-0.0120476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506787,0.0105783) , 
3, 0.641492, 1, 0, 0.228652,-0.0027588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288136,-0.02232) , 
0, 1.3861, 1, 0, 0.234032,-0.00576118)    );
  // itree = 945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457096,0.00263695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236462,-0.00744413) , 
3, -0.592362, 1, 0, 0.351724,0.0184166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13242,-0.00478924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102459,0.0132045) , 
3, 1.32315, 1, 0, 0.124306,-0.0172717) , 
2, 0.30194, 1, 0, 0.252305,0.00281484)    );
  // itree = 946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31746,0.0145559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.0183431) , 
3, -0.781411, 1, 0, 0.224747,0.033917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290936,0.00704258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210112,-0.0124664) , 
1, 0.489873, 1, 0, 0.245235,-0.00466471) , 
1, -0.66368, 1, 0, 0.241117,0.00309079)    );
  // itree = 947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0186916,-0.00401048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679612,0.0730259) , 
1, -0.666503, 1, 0, 0.342857,0.0421305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0496894,0.015189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240809,-0.0109955) , 
1, -0.99794, 1, 0, 0.223648,-0.00460456) , 
2, -1.31469, 1, 0, 0.236146,0.000295264)    );
  // itree = 948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1875,-0.0037652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174757,-0.074714) , 
0, -0.291613, 1, 0, 0.182796,-0.0361303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0415973,-0.0232532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381686,0.0131417) , 
3, -0.444419, 1, 0, 0.261737,0.00854689) , 
1, -0.889814, 1, 0, 0.25063,0.00226098)    );
  // itree = 949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278846,0.000651204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208791,-0.0013973) , 
0, 0.627404, 1, 0, 0.261206,-0.00249497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0738255,0.0167066) , 
3, 1.74459, 1, 0, 0.246933,-0.00816511)    );
  // itree = 950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329918,-0.005217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.00928806) , 
3, 0.15983, 1, 0, 0.26376,0.00561856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143529,-0.00683923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309859,0.02513) , 
1, 1.10555, 1, 0, 0.185185,-0.0259221) , 
0, 0.676581, 1, 0, 0.241099,-0.00347785)    );
  // itree = 951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264938,0.00579642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279279,-0.0566774) , 
1, 1.56373, 1, 0, 0.265783,0.00620027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217949,0.0520919) , 
3, 1.76021, 1, 0, 0.262126,0.0013934)    );
  // itree = 952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250401,0.0180046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303279,-0.0137656) , 
0, -0.109009, 1, 0, 0.276561,0.0010513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0893855,-0.0652477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201309,-0.00451783) , 
0, -0.507772, 1, 0, 0.175949,-0.0197715) , 
1, 0.736848, 1, 0, 0.237271,-0.0070802)    );
  // itree = 953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346734,-0.0136334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257344,0.00107853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.036036,-0.0382187) , 
3, 1.89048, 1, 0, 0.243795,-0.00352131) , 
0, -1.20662, 1, 0, 0.253976,0.00349291)    );
  // itree = 954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253406,0.00100591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.015873,-0.054877) , 
3, -0.0382585, 1, 0, 0.182078,0.0218525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37633,0.00251139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102703,0.0100203) , 
3, 1.5456, 1, 0, 0.322305,-0.0185266) , 
2, 0.26197, 1, 0, 0.248238,0.00280155)    );
  // itree = 955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201908,-0.00624534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542683,0.0273109) , 
3, 1.01104, 1, 0, 0.24121,0.00878633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290249,0.00834993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120419,-0.0023341) , 
3, 1.38367, 1, 0, 0.238924,-0.0182445) , 
2, 0.684685, 1, 0, 0.240506,0.000469161)    );
  // itree = 956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0165289,-0.0530216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3125,0.0254231) , 
3, -1.73509, 1, 0, 0.236786,0.0188876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2248,-0.0148842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368794,0.00864256) , 
2, 1.40866, 1, 0, 0.251305,-0.0112842) , 
1, -0.516144, 1, 0, 0.24788,-0.00416635)    );
  // itree = 957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533835,-0.00575505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429185,-0.0207596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206743,0.0050886) , 
1, -0.796791, 1, 0, 0.235457,0.00890066) , 
3, -1.98613, 1, 0, 0.255934,0.00544885)    );
  // itree = 958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298077,-0.00984739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514019,-0.00593048) , 
1, -0.406433, 1, 0, 0.407583,0.0669825) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245637,-0.00339899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0746888,-0.00896886) , 
3, 1.49665, 1, 0, 0.222595,0.0016185) , 
0, -1.17397, 1, 0, 0.242121,0.00851785)    );
  // itree = 959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144457,-0.0172315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29927,-0.000942174) , 
3, 0.401272, 1, 0, 0.180805,0.0148106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383358,0.00748437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207921,-0.00245724) , 
3, 1.40654, 1, 0, 0.342857,-0.0130722) , 
0, 0.297203, 1, 0, 0.250245,0.00286277)    );
  // itree = 960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,0.0342916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234375,-0.0282679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24892,-0.00210183) , 
1, -0.0254922, 1, 0, 0.244085,-0.0125525) , 
0, -1.31621, 1, 0, 0.248265,-0.00849661)    );
  // itree = 961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346887,0.00720975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304668,0.00113756) , 
0, -0.0151447, 1, 0, 0.332496,-0.00386096) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00925926,-0.0701491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158865,0.00959411) , 
0, -0.370772, 1, 0, 0.138991,0.0301214) , 
3, 0.297184, 1, 0, 0.254111,0.00990467)    );
  // itree = 962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25062,-0.00299487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165049,0.0307089) , 
0, 0.597113, 1, 0, 0.233202,0.0313896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304678,0.00315632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247024,0.012583) , 
0, 0.297203, 1, 0, 0.278196,-0.00127818) , 
1, -0.368349, 1, 0, 0.266633,0.00711689)    );
  // itree = 963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0844358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278333,0.00384116) , 
0, -1.5973, 1, 0, 0.260666,0.0067934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130137,0.0120147) , 
3, 1.76176, 1, 0, 0.251451,0.00125131)    );
  // itree = 964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208191,0.000435146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635294,0.0244571) , 
3, 1.53993, 1, 0, 0.245851,0.00471612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348624,-0.0360973) , 
1, 1.7097, 1, 0, 0.25135,0.000954406)    );
  // itree = 965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398058,-0.00590794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325945,-0.00281704) , 
0, -1.65333, 1, 0, 0.334483,-0.0105748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235772,0.00135468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0914761,-0.00832152) , 
1, 0.936658, 1, 0, 0.172445,0.0134387) , 
3, -0.343942, 1, 0, 0.244151,0.00281221)    );
  // itree = 966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297479,0.00753069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0117647,-0.070937) , 
3, -0.509791, 1, 0, 0.193583,0.0113724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243243,-0.00151981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314715,0.00778879) , 
2, 0.179136, 1, 0, 0.304912,-0.0200766) , 
2, -0.0414875, 1, 0, 0.253227,-0.00547642)    );
  // itree = 967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0922432,-0.0200652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.925676,0.0489585) , 
1, 0.901905, 1, 0, 0.2896,0.0204483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145833,0.0806942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246983,-0.0050216) , 
1, -0.673007, 1, 0, 0.236482,-0.00533524) , 
2, -0.472985, 1, 0, 0.252982,0.00267407)    );
  // itree = 968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236767,0.000863461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203008,-0.0517272) , 
0, 1.41437, 1, 0, 0.234392,-0.00298211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486726,0.0312362) , 
2, 1.84379, 1, 0, 0.248627,0.000167489)    );
  // itree = 969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.599291,0.0175915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227679,-0.0174152) , 
2, -0.843662, 1, 0, 0.371233,-0.0151461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289308,-0.0148071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176249,0.00133765) , 
1, -0.488883, 1, 0, 0.190984,0.0114555) , 
3, -0.610112, 1, 0, 0.258462,0.001497)    );
  // itree = 970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338129,0.00565362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.0183577) , 
3, -0.245906, 1, 0, 0.251816,0.00731149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283828,0.00891579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204465,-0.0116234) , 
1, 0.579552, 1, 0, 0.225303,-0.0114433) , 
1, 0.105598, 1, 0, 0.236364,-0.0036193)    );
  // itree = 971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00662252,-0.0582175) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252658,0.00121673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385906,-0.00432194) , 
1, 1.44765, 1, 0, 0.27359,-0.00124571) , 
1, -1.2819, 1, 0, 0.253906,0.00453946)    );
  // itree = 972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0610687,0.00588253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385892,0.0602985) , 
3, -1.24327, 1, 0, 0.2167,0.0424489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247604,0.00603861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218045,-0.0254796) , 
1, 1.42767, 1, 0, 0.242424,-0.000440616) , 
0, -0.691888, 1, 0, 0.236022,0.010234)    );
  // itree = 973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452174,0.00142495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346103,0.0133279) , 
3, -1.16754, 1, 0, 0.37931,0.00359373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149367,0.00816881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0550459,-0.0162775) , 
3, 1.85859, 1, 0, 0.137931,-0.0189478) , 
2, 0.239841, 1, 0, 0.270865,-0.00653364)    );
  // itree = 974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32173,0.00271232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0148148,-0.0675706) , 
3, 0.636073, 1, 0, 0.283472,-0.0112916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281307,0.000152769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124051,-0.00705185) , 
3, 0.745695, 1, 0, 0.215645,0.0155814) , 
0, 0.0809145, 1, 0, 0.251848,0.00123767)    );
  // itree = 975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186019,-0.0121773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412651,0.0116832) , 
3, -0.0126863, 1, 0, 0.25,0.0100831) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294751,0.0161775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0265487,-0.0895528) , 
1, 1.63992, 1, 0, 0.259346,-0.0133339) , 
2, 0.342305, 1, 0, 0.253937,0.000218453)    );
  // itree = 976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216794,0.011101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304511,-0.0154354) , 
2, 0.70054, 1, 0, 0.242128,0.00293747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305556,-0.0246362) , 
1, 1.56373, 1, 0, 0.247774,-0.000893605)    );
  // itree = 977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545455,-0.0065939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398438,-0.0189136) , 
0, -0.296125, 1, 0, 0.491379,-0.0264923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248858,0.0022602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0955414,-0.00516728) , 
3, 0.94347, 1, 0, 0.208403,0.00579603) , 
1, -0.840753, 1, 0, 0.254571,0.000528176)    );
  // itree = 978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165829,-0.0135448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205479,-0.0130874) , 
1, 0.597422, 1, 0, 0.126838,0.019265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229508,-0.00450539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324895,0.0085376) , 
2, 0.199652, 1, 0, 0.289913,-0.00138191) , 
2, -0.695641, 1, 0, 0.246448,0.00412122)    );
  // itree = 979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0782617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324561,0.00590378) , 
0, 0.482577, 1, 0, 0.0849598,0.0120611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291217,0.000852122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514019,-0.000398658) , 
1, 1.28084, 1, 0, 0.379759,-0.0200783) , 
1, 0.174878, 1, 0, 0.247947,-0.00570792)    );
  // itree = 980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15393,0.00809446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409692,0.0442062) , 
3, 0.319079, 1, 0, 0.204724,0.0186892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218841,-0.0237468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712329,0.0198345) , 
3, 1.39384, 1, 0, 0.337734,-0.00802272) , 
2, 0.30194, 1, 0, 0.263645,0.00685631)    );
  // itree = 981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341874,0.00981193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996169,-0.0126169) , 
3, 0.622143, 1, 0, 0.274894,-0.00546463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184466,0.0663806) , 
1, 1.80063, 1, 0, 0.270216,-0.00841121)    );
  // itree = 982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358722,0.00400462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.038835,-0.04595) , 
3, 0.355715, 1, 0, 0.294118,-0.0126706) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272873,0.00308452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110276,-0.015443) , 
3, 0.745695, 1, 0, 0.209393,0.00877159) , 
0, -0.0631136, 1, 0, 0.251714,-0.00193901)    );
  // itree = 983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0487239,-0.0306775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776316,0.0522348) , 
1, 0.109923, 1, 0, 0.300455,0.0119375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150442,0.0536427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231325,-0.00593901) , 
1, -0.738196, 1, 0, 0.224595,-0.0138322) , 
2, -0.472985, 1, 0, 0.24938,-0.00541261)    );
  // itree = 984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,0.05438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0811911) , 
1, 0.569253, 1, 0, 0.169355,0.0386048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277295,-0.00262325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261194,-0.0222956) , 
2, 1.08379, 1, 0, 0.272791,-0.00942234) , 
2, -0.656951, 1, 0, 0.246249,0.00290122)    );
  // itree = 985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353591,-0.00583534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242265,-0.000754331) , 
0, -1.23453, 1, 0, 0.252904,-0.00183951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0611111,-0.00170717) , 
3, 1.69392, 1, 0, 0.236258,-0.00660155)    );
  // itree = 986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239425,0.0042232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339713,0.00635908) , 
2, 0.679573, 1, 0, 0.265625,0.01011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126246,-0.0143541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341969,0.00346232) , 
2, 1.23437, 1, 0, 0.210526,-0.0162442) , 
1, 1.28142, 1, 0, 0.252627,0.00389272)    );
  // itree = 987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0779698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134884,-0.00953918) , 
0, -0.713643, 1, 0, 0.0982218,0.015427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561404,0.0563506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465149,0.00223991) , 
0, -0.746253, 1, 0, 0.47858,-0.0288737) , 
1, 0.680932, 1, 0, 0.253754,-0.00268794)    );
  // itree = 988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265602,0.0076715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165171,-0.0128914) , 
1, -0.119724, 1, 0, 0.20355,-0.00346479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636364,0.0160457) , 
3, 1.55138, 1, 0, 0.244221,1.15651e-05)    );
  // itree = 989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428571,0.00681856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236073,-0.00650607) , 
0, -1.67474, 1, 0, 0.246611,-0.00232157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346154,0.0859018) , 
0, 1.55221, 1, 0, 0.251731,-0.00698685)    );
  // itree = 990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275184,0.00393535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0474684,-0.0296743) , 
3, -0.686896, 1, 0, 0.175657,0.0139227) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36148,0.0122873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0853081,-0.0100877) , 
3, 1.41316, 1, 0, 0.315415,-0.00895678) , 
2, -0.22187, 1, 0, 0.264588,-0.000635918)    );
  // itree = 991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138095,-0.0168533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181435,-0.0201108) , 
3, 0.351746, 1, 0, 0.151575,0.0141044) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.668161,0.0189411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341121,-0.00886957) , 
3, 0.791652, 1, 0, 0.508009,-0.0363488) , 
1, 1.29547, 1, 0, 0.231005,0.00286117)    );
  // itree = 992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200131,-0.00218802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526012,-0.0379712) , 
3, 1.3735, 1, 0, 0.233353,-0.00932707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0608108,-0.0025356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737864,0.0358416) , 
3, 1.40243, 1, 0, 0.338645,0.0352555) , 
0, 1.26376, 1, 0, 0.24692,-0.0035826)    );
  // itree = 993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450382,0.0208576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278997,-0.000936042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223607,-0.00703428) , 
0, -0.691412, 1, 0, 0.233189,0.000738082) , 
0, -1.35128, 1, 0, 0.247595,-0.00149399)    );
  // itree = 994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203297,-0.0166012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400749,0.00360945) , 
2, -0.980109, 1, 0, 0.320713,-0.0307378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284672,0.00393125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0767754,-0.0264677) , 
3, 0.784651, 1, 0, 0.217687,0.00689161) , 
0, -0.716617, 1, 0, 0.240077,-0.00128633)    );
  // itree = 995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234594,0.00200517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390728,0.0177882) , 
3, 0.600911, 1, 0, 0.249525,0.0123551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428994,0.0347897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0603448,-0.00435381) , 
3, 1.87132, 1, 0, 0.334802,-0.0171314) , 
3, 0.873167, 1, 0, 0.268569,0.00577035)    );
  // itree = 996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126316,0.0205556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0397112,-0.0427084) , 
2, -0.930532, 1, 0, 0.0691299,-0.0102128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557252,0.046389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369863,-0.000853137) , 
0, -0.557783, 1, 0, 0.392593,0.00880383) , 
3, -0.302435, 1, 0, 0.251172,0.000489643)    );
  // itree = 997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343718,-0.00312025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168618,0.0037144) , 
3, -0.0928637, 1, 0, 0.26142,-0.00158283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0363636,-0.0489688) , 
2, 1.85179, 1, 0, 0.248573,0.00236512)    );
  // itree = 998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252874,0.000640957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100559,-0.0248067) , 
0, 1.32631, 1, 0, 0.237991,-0.00610428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360656,0.028977) , 
1, 1.63393, 1, 0, 0.24565,-0.00178861)    );
  // itree = 999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141085,-0.00476794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285285,-0.00100333) , 
0, -0.295561, 1, 0, 0.21434,-0.00747891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284884,-0.0278091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294589,-0.00125143) , 
3, 0.835888, 1, 0, 0.292101,0.0204579) , 
3, 0.521064, 1, 0, 0.240666,0.001979)    );
  // itree = 1000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0284091,-0.0366842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281879,0.0142887) , 
3, -1.75988, 1, 0, 0.224093,0.00817239) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153032,-0.0233217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564356,0.0153581) , 
3, 1.21207, 1, 0, 0.245902,-0.00893681) , 
0, -0.362191, 1, 0, 0.237938,-0.00268879)    );
  // itree = 1001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492308,-0.0114952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454082,-0.0111148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220093,0.00812561) , 
1, -0.882113, 1, 0, 0.244004,0.00833668) , 
3, -1.97613, 1, 0, 0.259766,0.0056088)    );
  // itree = 1002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283019,0.019275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,0.00420518) , 
0, -0.420077, 1, 0, 0.219048,-0.061686) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304348,0.00865545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259117,0.00502723) , 
1, 0.32534, 1, 0, 0.277136,-0.00957778) , 
1, -1.06103, 1, 0, 0.270855,-0.0152125)    );
  // itree = 1003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0763324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330189,0.0572767) , 
0, -1.19764, 1, 0, 0.154185,-0.0320057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00970874,-0.0808678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297362,0.00886935) , 
0, -1.09185, 1, 0, 0.280632,0.0025357) , 
3, -1.57733, 1, 0, 0.266266,-0.00138868)    );
  // itree = 1004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00980392,-0.068365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251129,-0.00050298) , 
3, -2.02462, 1, 0, 0.237994,-0.00313147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279279,-0.0478282) , 
1, 1.68641, 1, 0, 0.240302,-0.0076363)    );
  // itree = 1005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.00592748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256821,0.000336416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0751445,0.0131187) , 
3, 1.68098, 1, 0, 0.239914,-0.00482313) , 
0, -1.2923, 1, 0, 0.248035,-0.00220622)    );
  // itree = 1006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321696,-0.00873784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208502,0.00830728) , 
3, -0.453269, 1, 0, 0.259218,-0.00171745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.064,-0.0109398) , 
3, 1.74459, 1, 0, 0.246475,-0.00527457)    );
  // itree = 1007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.107582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255054,0.0176309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31405,0.00195042) , 
0, -0.235947, 1, 0, 0.293578,-0.0101192) , 
0, -1.31621, 1, 0, 0.267322,-0.00563775)    );
  // itree = 1008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144554,0.0126014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120948,-0.019888) , 
2, -0.572415, 1, 0, 0.130069,-0.00403296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.624096,0.0238774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326087,-0.00610809) , 
1, 1.16326, 1, 0, 0.493894,0.0173459) , 
3, 0.414913, 1, 0, 0.261252,0.00367558)    );
  // itree = 1009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344322,0.00151238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730089,-0.0195119) , 
3, 0.3925, 1, 0, 0.264896,0.0102549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187817,0.00109077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128114,-0.0121671) , 
0, 1.22745, 1, 0, 0.15272,-0.0187415) , 
0, 0.900791, 1, 0, 0.238378,0.00340016)    );
  // itree = 1010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405204,0.0116487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139384,-0.0178764) , 
3, -0.587187, 1, 0, 0.263203,0.00881108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159341,-0.00270025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341379,-0.00458285) , 
2, 1.1542, 1, 0, 0.222488,-0.0175161) , 
1, 0.670673, 1, 0, 0.246107,-0.00224345)    );
  // itree = 1011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0757621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0877193,-0.0119524) , 
3, -1.61915, 1, 0, 0.0549451,0.0293189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334454,0.0232042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268468,-0.00390653) , 
3, -0.390674, 1, 0, 0.291496,0.00167064) , 
1, -0.848848, 1, 0, 0.258847,0.0054866)    );
  // itree = 1012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260504,0.060988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0829694,-0.0274036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403996,0.00399221) , 
3, 0.00785522, 1, 0, 0.242157,-0.00559174) , 
0, -1.48114, 1, 0, 0.243285,-0.000865238)    );
  // itree = 1013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536264,0.00901441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157895,-0.0301988) , 
3, -0.35892, 1, 0, 0.432907,0.0142907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211849,-0.00652996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180892,0.015248) , 
3, 0.008986, 1, 0, 0.193741,-0.0119121) , 
2, -0.500189, 1, 0, 0.269817,-0.00357728)    );
  // itree = 1014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27886,-0.00273468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0245054) , 
0, 0.809247, 1, 0, 0.261457,0.000534506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194245,-0.00347174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0927835,-0.0195293) , 
3, 1.40673, 1, 0, 0.152542,0.0380326) , 
0, 1.28629, 1, 0, 0.248194,0.00510084)    );
  // itree = 1015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0846654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0849343,-0.0207673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453409,0.00639088) , 
1, 0.574614, 1, 0, 0.258427,0.00235404) , 
1, -1.52668, 1, 0, 0.24431,-8.09399e-06)    );
  // itree = 1016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0222222,-0.0513461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0194175,0.00161722) , 
1, -0.741671, 1, 0, 0.0210084,-0.0194861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373206,0.0336455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280259,0.0044852) , 
0, -0.81958, 1, 0, 0.291334,0.0106828) , 
3, -1.51764, 1, 0, 0.259036,0.00707829)    );
  // itree = 1017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303502,0.0112105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161538,-0.0305299) , 
0, 0.42191, 1, 0, 0.290459,0.0106513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228516,0.00975208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865385,0.0167405) , 
3, 1.83904, 1, 0, 0.204545,-0.0130475) , 
0, 0.6269, 1, 0, 0.264402,0.00346352)    );
  // itree = 1018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223853,0.000219743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320819,-0.00868674) , 
2, 1.08058, 1, 0, 0.238589,-0.00109898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268293,-0.013381) , 
2, 1.84379, 1, 0, 0.240371,0.00238665)    );
  // itree = 1019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0179641,-0.0204801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284602,0.00144405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0786429) , 
3, 1.91538, 1, 0, 0.266854,-0.00286484) , 
1, -1.23776, 1, 0, 0.245506,-0.00706229)    );
  // itree = 1020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0421793,-0.0270022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332915,0.0156785) , 
3, -0.72479, 1, 0, 0.211722,0.00548308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257732,-0.0330972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438596,0.0146952) , 
0, 1.25367, 1, 0, 0.304878,-0.0221813) , 
2, 0.648293, 1, 0, 0.241959,-0.00349654)    );
  // itree = 1021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274194,-0.0046322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225951,0.00608607) , 
0, 0.72313, 1, 0, 0.26268,0.0015783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0780142,-0.00036237) , 
3, 1.83453, 1, 0, 0.249752,0.00615297)    );
  // itree = 1022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266585,0.00629621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297774,0.00728163) , 
1, 0.0377094, 1, 0, 0.284355,-0.00165137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714286,-0.00272888) , 
3, 1.73078, 1, 0, 0.26699,-0.00528555)    );
  // itree = 1023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145833,-0.01217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321133,0.000416215) , 
0, -0.351367, 1, 0, 0.243581,-0.00651097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.727273,0.0470328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125714,-0.0335012) , 
2, 0.275862, 1, 0, 0.290456,0.0358032) , 
3, 0.824791, 1, 0, 0.254873,0.00368164)    );
  // itree = 1024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142143,-0.00651837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432624,0.0452054) , 
3, 0.602294, 1, 0, 0.168722,0.00147272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345455,-0.0388971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539894,-0.00369459) , 
0, 0.119274, 1, 0, 0.495885,-0.0227706) , 
3, 0.876105, 1, 0, 0.247163,-0.00433994)    );
  // itree = 1025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363478,-0.0141882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218509,-0.00149835) , 
3, -0.836436, 1, 0, 0.26636,0.00520658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132653,0.0324886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0756303,-0.00879183) , 
2, 0.936401, 1, 0, 0.101382,-0.0374519) , 
1, 1.47592, 1, 0, 0.248086,0.000481257)    );
  // itree = 1026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287715,0.000787468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0340136,-0.0336861) , 
3, 1.19736, 1, 0, 0.247721,-0.00649031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417323,0.0396833) , 
1, 1.65151, 1, 0, 0.258534,-0.00375057)    );
  // itree = 1027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186416,-0.00850223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281553,-0.028234) , 
3, 1.37331, 1, 0, 0.193006,0.0047653) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469136,-0.000813996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146552,0.029421) , 
3, 1.74375, 1, 0, 0.384091,-0.0310489) , 
0, 0.900791, 1, 0, 0.236637,-0.0034123)    );
  // itree = 1028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295209,0.0259618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213579,-0.00109978) , 
1, 0.174878, 1, 0, 0.252585,0.012689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18408,-0.0383075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260526,0.000138634) , 
0, 1.00966, 1, 0, 0.234079,-0.0133114) , 
0, 0.670376, 1, 0, 0.247028,0.00488212)    );
  // itree = 1029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335029,0.00875744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.076555,-0.0166764) , 
3, 0.656214, 1, 0, 0.274805,0.00487458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0754717,-0.042666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245455,0.0282356) , 
0, 1.51272, 1, 0, 0.162037,-0.0436624) , 
0, 1.32355, 1, 0, 0.262687,-0.00034133)    );
  // itree = 1030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215385,-0.00236531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389155,0.00284656) , 
2, 0.532819, 1, 0, 0.273899,0.00182265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0784314,0.00506522) , 
3, 1.76021, 1, 0, 0.259057,-0.00183619)    );
  // itree = 1031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0360934,-0.0378491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326781,0.00622758) , 
1, -0.357566, 1, 0, 0.220233,-0.00623568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.833333,0.0758735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154374,-0.0285263) , 
2, -0.197427, 1, 0, 0.265423,0.0245725) , 
3, 0.436997, 1, 0, 0.236125,0.00459848)    );
  // itree = 1032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0725806,0.015762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48,0.036273) , 
3, -1.62494, 1, 0, 0.254464,0.0363374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157635,-0.0439612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261874,0.00466559) , 
0, -0.697364, 1, 0, 0.249858,6.71257e-05) , 
0, -1.11841, 1, 0, 0.250378,0.0041601)    );
  // itree = 1033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376081,-0.00561124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199664,0.00211346) , 
3, -0.706049, 1, 0, 0.264581,-0.00334013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137143,-0.0234957) , 
0, 1.41437, 1, 0, 0.25376,-0.00736899)    );
  // itree = 1034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0701754,-0.0516823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361736,0.013975) , 
2, -1.3488, 1, 0, 0.326502,-0.00826383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0702948,-0.0164567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196172,0.00507231) , 
1, 1.35548, 1, 0, 0.110769,0.034845) , 
3, 0.540694, 1, 0, 0.258596,0.00530553)    );
  // itree = 1035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0924658,0.0179966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35828,0.00534421) , 
1, -0.29203, 1, 0, 0.273913,0.00166118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0779394) , 
3, 1.99526, 1, 0, 0.260062,0.00799005)    );
  // itree = 1036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174129,0.00736399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456647,0.0622859) , 
2, -0.140518, 1, 0, 0.25913,0.0298541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188024,-0.0149753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337545,0.011842) , 
2, 0.706369, 1, 0, 0.24766,-0.00246259) , 
1, -0.29203, 1, 0, 0.251018,0.00699877)    );
  // itree = 1037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310617,0.00863013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0320856,-0.0413508) , 
3, 1.14122, 1, 0, 0.277672,0.00181581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147929,-0.0240402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17,0.0160513) , 
3, 0.77639, 1, 0, 0.159892,-0.0299299) , 
0, 1.01723, 1, 0, 0.255385,-0.00419146)    );
  // itree = 1038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0226086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365672,0.00322749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22818,-0.00566849) , 
0, -1.05662, 1, 0, 0.237944,-0.00224975) , 
3, -1.98613, 1, 0, 0.251383,-0.00445565)    );
  // itree = 1039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144385,-0.00214113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356322,0.00276386) , 
3, -0.974354, 1, 0, 0.267857,0.00945757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254444,0.000531585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140845,0.00369495) , 
3, 1.48982, 1, 0, 0.232704,-0.00937549) , 
2, 0.0236201, 1, 0, 0.248382,-0.000976077)    );
  // itree = 1040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166863,0.00272098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.642857,0.020342) , 
3, 0.158612, 1, 0, 0.301601,0.0109926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0437018,0.0122963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382114,-0.0186786) , 
3, 0.748548, 1, 0, 0.208443,-0.0149432) , 
1, 0.75851, 1, 0, 0.265296,0.000884975)    );
  // itree = 1041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396061,-0.016579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177551,-0.00418769) , 
1, -0.29203, 1, 0, 0.247042,0.00827073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210811,-0.0369057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139908,0.000141105) , 
1, 0.113466, 1, 0, 0.161031,-0.0270842) , 
0, 0.6269, 1, 0, 0.221088,-0.00239758)    );
  // itree = 1042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333925,-0.00266535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238022,0.00136487) , 
0, -0.53067, 1, 0, 0.267097,-0.00401034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0787879,0.00741324) , 
3, 1.73078, 1, 0, 0.251731,-0.00740685)    );
  // itree = 1043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0681342,-0.0221307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468005,0.0113824) , 
1, 0.42511, 1, 0, 0.250143,0.00350483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262032,0.0273915) , 
3, 1.64499, 1, 0, 0.25129,-0.000714003)    );
  // itree = 1044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0634921,-0.0104844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560345,0.0449866) , 
3, -1.18399, 1, 0, 0.252459,0.0208446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229659,-0.013135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359155,0.0129983) , 
1, 1.59745, 1, 0, 0.240696,-0.010866) , 
0, -0.940853, 1, 0, 0.242516,-0.00595894)    );
  // itree = 1045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439068,-0.00643629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232941,0.0133797) , 
1, 0.0263458, 1, 0, 0.349949,0.0136236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175743,-0.000663117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0716912,-0.0227672) , 
2, 0.840367, 1, 0, 0.116034,-0.0120549) , 
2, 0.213212, 1, 0, 0.235111,0.00101703)    );
  // itree = 1046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285,0.00288136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371841,-0.00320334) , 
1, -0.874525, 1, 0, 0.348806,-0.014917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170426,0.00485438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242894,0.0070496) , 
1, 1.22177, 1, 0, 0.194093,0.00895127) , 
3, -0.435343, 1, 0, 0.254255,-0.000330155)    );
  // itree = 1047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291262,0.0187748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,0.00741001) , 
3, -1.11042, 1, 0, 0.0655022,0.0471718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304676,-0.00121186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239216,-0.0176334) , 
3, 1.34571, 1, 0, 0.294118,0.00590398) , 
1, -0.517663, 1, 0, 0.242766,0.0151736)    );
  // itree = 1048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0727273,-0.0228569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373702,0.0116849) , 
3, -0.106439, 1, 0, 0.213247,-0.000248801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669118,-0.0264188) , 
3, 1.77248, 1, 0, 0.244355,-0.00380228)    );
  // itree = 1049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454988,-0.0080428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187817,-0.000366701) , 
2, -0.640677, 1, 0, 0.266476,0.0146314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238095,0.00390923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0249692) , 
3, 1.46923, 1, 0, 0.191257,-0.014093) , 
0, 0.68993, 1, 0, 0.245244,0.00652361)    );
  // itree = 1050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222772,-0.0161588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381308,-0.00188288) , 
1, -0.909586, 1, 0, 0.337856,-0.0145634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00395257,-0.0789016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238647,-0.00203454) , 
2, -0.336733, 1, 0, 0.192547,0.00795917) , 
3, -0.610112, 1, 0, 0.245432,-0.000237935)    );
  // itree = 1051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207202,-0.00751687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531915,0.0144409) , 
0, 1.08472, 1, 0, 0.249175,0.001242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228395,0.0442993) , 
3, 1.71106, 1, 0, 0.247475,-0.00469759)    );
  // itree = 1052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183007,-0.0254056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338279,0.0469328) , 
1, -1.19215, 1, 0, 0.289796,0.0288888) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25259,-0.00793282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258929,-0.0347571) , 
0, 1.2265, 1, 0, 0.25355,-0.0143282) , 
1, -0.343262, 1, 0, 0.26257,-0.00357333)    );
  // itree = 1053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584314,0.0104768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247596,-0.00530753) , 
2, -0.879111, 1, 0, 0.375559,-0.0172539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228903,-0.00196883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0806045,-0.0119627) , 
1, 1.22177, 1, 0, 0.18513,0.0158586) , 
3, -0.691091, 1, 0, 0.248512,0.00483755)    );
  // itree = 1054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442446,0.0163403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172652,-0.0136425) , 
3, -1.28228, 1, 0, 0.247505,0.0247386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356808,0.0225717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209848,-0.00666474) , 
1, 0.657643, 1, 0, 0.239212,-0.00560435) , 
1, 0.324332, 1, 0, 0.24323,0.0090976)    );
  // itree = 1055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2275,0.0502212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283019,0.00671986) , 
3, -1.18507, 1, 0, 0.270529,0.000118059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0875544) , 
1, 1.62191, 1, 0, 0.255486,0.00542901)    );
  // itree = 1056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16314,0.00441599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487751,-0.0155614) , 
3, 0.818131, 1, 0, 0.239289,-0.00372856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527778,0.0184446) , 
0, 1.55221, 1, 0, 0.254698,-0.00153341)    );
  // itree = 1057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430421,-0.0100276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230444,0.0174121) , 
1, -0.331883, 1, 0, 0.309463,-0.0120828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267554,-0.00150044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925926,-0.00701067) , 
3, 1.04582, 1, 0, 0.218261,0.00736128) , 
0, -0.262665, 1, 0, 0.255176,-0.000508928)    );
  // itree = 1058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53913,0.0496012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875764,-0.0347617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319505,0.0125506) , 
2, -0.48647, 1, 0, 0.258445,0.00487702) , 
3, -1.98613, 1, 0, 0.274747,0.00174488)    );
  // itree = 1059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148315,-0.00774324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627119,0.0434849) , 
0, 0.253124, 1, 0, 0.284566,0.0284443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187166,0.00494019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227731,-0.00473473) , 
0, -0.724834, 1, 0, 0.222222,-0.00415987) , 
2, -0.472985, 1, 0, 0.241621,0.0059851)    );
  // itree = 1060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198582,-0.011734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279133,0.0114742) , 
0, -0.362191, 1, 0, 0.247792,0.00287893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327044,-0.0236865) , 
1, 1.56373, 1, 0, 0.254186,-0.000611853)    );
  // itree = 1061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261863,-0.00375072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0229008,-0.0517756) , 
3, 1.62424, 1, 0, 0.244831,0.0028514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201493,0.0666822) , 
1, 1.63393, 1, 0, 0.241886,-0.000382547)    );
  // itree = 1062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292122,0.00269958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0663507,-0.0212931) , 
3, 1.11648, 1, 0, 0.267692,0.00711827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0961538,0.00752152) , 
3, 1.74459, 1, 0, 0.254986,0.0029569)    );
  // itree = 1063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.101138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287111,-0.00699848) , 
1, -1.11614, 1, 0, 0.249228,0.01104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314402,0.0257895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0694444,-0.0579468) , 
1, 1.54306, 1, 0, 0.259027,-0.00998243) , 
2, 0.689402, 1, 0, 0.252457,0.00411227)    );
  // itree = 1064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167,0.008024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572626,0.0278307) , 
3, 0.38655, 1, 0, 0.273932,0.0179194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242075,-0.0306671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309904,0.00493995) , 
1, 0.586525, 1, 0, 0.274242,-0.0161818) , 
0, 0.596152, 1, 0, 0.274034,0.00676638)    );
  // itree = 1065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633721,0.0257921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240469,0.00367464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0891089,0.0188651) , 
3, 1.91538, 1, 0, 0.232004,-0.00204216) , 
1, -1.18003, 1, 0, 0.266936,-0.00497766)    );
  // itree = 1066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343633,-0.00131539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764873,-0.036888) , 
3, 0.387834, 1, 0, 0.27727,0.015501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0376569,-0.0388418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254593,-0.00132176) , 
2, 0.363787, 1, 0, 0.170968,-0.0206231) , 
0, 0.6269, 1, 0, 0.244978,0.00452749)    );
  // itree = 1067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195522,-0.000156251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346549,6.94611e-05) , 
3, -0.5513, 1, 0, 0.271651,0.00760916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172727,0.0298162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245714,-0.00586309) , 
1, 0.172741, 1, 0, 0.233071,-0.0248816) , 
2, 0.648293, 1, 0, 0.259315,-0.00277938)    );
  // itree = 1068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308762,0.013318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131635,-0.0266291) , 
1, 0.606823, 1, 0, 0.238655,-0.00236736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0827586,-0.0926834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253061,-0.0131882) , 
1, -0.290095, 1, 0, 0.225,-0.0303851) , 
0, 0.297203, 1, 0, 0.23285,-0.0142783)    );
  // itree = 1069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328405,0.00153175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139073,-0.00940333) , 
3, 0.434356, 1, 0, 0.308496,0.00857045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122931,0.0321467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170068,0.00502049) , 
0, 1.32568, 1, 0, 0.135088,-0.0363201) , 
3, 0.702073, 1, 0, 0.259222,-0.00418508)    );
  // itree = 1070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335361,0.00482218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129518,-0.0107403) , 
3, 0.292664, 1, 0, 0.260055,0.00845994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916031,0.00761827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259615,0.00629226) , 
2, 1.23421, 1, 0, 0.165957,-0.0434558) , 
0, 1.32631, 1, 0, 0.249268,0.00250862)    );
  // itree = 1071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184244,0.000981771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228117,-0.0120546) , 
3, -0.356224, 1, 0, 0.205711,0.0159649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545455,0.0169126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125786,-0.0346578) , 
3, 1.41401, 1, 0, 0.408998,-0.0189699) , 
0, 0.900791, 1, 0, 0.25468,0.00754955)    );
  // itree = 1072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.095057,0.00239758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0168539,-0.0626356) , 
2, -0.939744, 1, 0, 0.0500808,-0.0154778) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282551,0.00442483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676,0.0242066) , 
3, 1.45001, 1, 0, 0.35388,0.013425) , 
3, -0.736148, 1, 0, 0.25976,0.00447064)    );
  // itree = 1073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32207,0.00443513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234609,-0.0168074) , 
0, -0.00751679, 1, 0, 0.288114,-0.00568705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00813008,-0.0656903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994898,-0.0166058) , 
0, 0.145392, 1, 0, 0.0776699,0.0386222) , 
3, 0.802707, 1, 0, 0.235579,0.00537416)    );
  // itree = 1074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214876,-0.0368333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62931,0.0363658) , 
2, -0.623943, 1, 0, 0.417722,0.0311766) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249688,0.00534382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.0186697) , 
3, 1.84217, 1, 0, 0.236994,-0.0052329) , 
0, -1.11841, 1, 0, 0.25877,-0.000845989)    );
  // itree = 1075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145969,-0.0164218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568306,0.0412963) , 
0, 1.26376, 1, 0, 0.195513,-0.0145933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719697,0.0365051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0296318) , 
1, 1.46795, 1, 0, 0.464103,0.0189264) , 
1, 1.35667, 1, 0, 0.249231,-0.00788938)    );
  // itree = 1076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223374,0.00519173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117564,-0.0233092) , 
0, 0.10773, 1, 0, 0.181098,-0.0043676) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510949,0.0308919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707317,0.00146743) , 
3, 1.74022, 1, 0, 0.61794,0.030855) , 
3, 1.30263, 1, 0, 0.244681,0.000759094)    );
  // itree = 1077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363344,0.0104804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293629,-0.00720156) , 
0, -0.430397, 1, 0, 0.325893,-0.00860086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126789,-0.00486864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841584,0.00952753) , 
3, 1.55938, 1, 0, 0.114327,0.0172492) , 
3, 0.436997, 1, 0, 0.254054,0.000176725)    );
  // itree = 1078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564815,0.0354344) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270332,-0.000774849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0824742,0.00539002) , 
3, 1.6239, 1, 0, 0.251546,0.0026234) , 
3, -1.95723, 1, 0, 0.268066,5.24722e-05)    );
  // itree = 1079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153359,-0.0190692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3184,-0.00212992) , 
3, -0.348039, 1, 0, 0.226308,0.0131227) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205021,0.0474642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301242,-0.00393927) , 
1, 0.998227, 1, 0, 0.26025,-0.011059) , 
2, 0.726098, 1, 0, 0.235949,0.00625386)    );
  // itree = 1080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291971,-0.0257251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303943,0.00754357) , 
3, -1.16154, 1, 0, 0.241417,0.00407122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172131,-0.00828577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338235,-0.0233819) , 
1, 0.35101, 1, 0, 0.25969,-0.02419) , 
0, 1.28629, 1, 0, 0.243702,0.00053857)    );
  // itree = 1081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522184,0.00365869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479167,0.0148212) , 
0, -0.135442, 1, 0, 0.505155,-0.0245413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188047,-0.00347469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191358,0.0114364) , 
0, 1.41437, 1, 0, 0.188396,-0.00425199) , 
1, -0.484715, 1, 0, 0.264487,-0.00912585)    );
  // itree = 1082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281081,-0.00681396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0668896,-0.040431) , 
3, 1.0075, 1, 0, 0.245081,-0.00122059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,-0.0133587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238532,0.0315926) , 
1, 0.355876, 1, 0, 0.168224,-0.0415108) , 
0, 1.3861, 1, 0, 0.236829,-0.00554678)    );
  // itree = 1083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22314,0.00132155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33463,0.00891002) , 
3, 1.14122, 1, 0, 0.238798,-0.00165243) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.794118,0.0613703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186916,0.0123244) , 
3, 1.14616, 1, 0, 0.483254,-0.0385469) , 
0, 1.35023, 1, 0, 0.263855,-0.00543416)    );
  // itree = 1084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194866,-0.00309671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0522388,-0.0784892) , 
2, 1.5124, 1, 0, 0.184524,-0.00665619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666667,0.0235431) , 
3, 1.57074, 1, 0, 0.233722,-0.00104142)    );
  // itree = 1085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.630824,0.0229248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141791,-0.0362367) , 
1, -0.445867, 1, 0, 0.391225,-0.014669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146597,-0.0080962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198541,-0.00516452) , 
0, -0.64517, 1, 0, 0.191579,0.0169627) , 
3, -0.871513, 1, 0, 0.246957,0.00818856)    );
  // itree = 1086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169811,0.00569715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240741,0.0121363) , 
1, -1.50008, 1, 0, 0.205607,0.0260453) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198953,-0.0185102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249091,-0.00183837) , 
1, -0.65405, 1, 0, 0.243889,-0.0100472) , 
1, -1.12426, 1, 0, 0.239903,-0.00628868)    );
  // itree = 1087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266588,0.00997687) , 
3, -1.90613, 1, 0, 0.25,-0.0070204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0275229,-0.0983822) , 
1, 1.71285, 1, 0, 0.237403,-0.00287426)    );
  // itree = 1088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245989,0.0412539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308343,0.00312132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217221,-0.0150262) , 
1, 0.344779, 1, 0, 0.257977,-0.00740696) , 
0, -1.25174, 1, 0, 0.256876,-0.00256841)    );
  // itree = 1089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414397,-0.00551744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198473,0.00302876) , 
2, -0.624804, 1, 0, 0.25932,-0.00200044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204724,0.059934) , 
1, 1.62191, 1, 0, 0.255766,0.0018223)    );
  // itree = 1090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443396,0.00343375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238095,-0.00245935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148718,0.00176895) , 
0, 1.3814, 1, 0, 0.229004,-0.00387694) , 
0, -1.68098, 1, 0, 0.240237,-0.000300663)    );
  // itree = 1091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0788403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177893,-0.00116158) , 
0, -0.219079, 1, 0, 0.0914742,-0.0120187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.880952,0.0347105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366716,0.000109098) , 
2, -0.645954, 1, 0, 0.447205,0.0131227) , 
1, 0.601922, 1, 0, 0.239772,-0.00153766)    );
  // itree = 1092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174839,-0.00279258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485816,0.0150195) , 
3, 1.01679, 1, 0, 0.222707,0.00231971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74,-0.0159945) , 
3, 1.83453, 1, 0, 0.261857,-0.00025475)    );
  // itree = 1093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348624,-0.0142234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26776,-0.00338678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21513,0.00582987) , 
0, 0.260745, 1, 0, 0.244856,-0.00147198) , 
0, -1.59608, 1, 0, 0.250365,0.00319619)    );
  // itree = 1094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175676,-0.00425628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256812,-0.0026047) , 
1, -1.3158, 1, 0, 0.249381,0.00870699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250909,-0.00203403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174419,0.0047252) , 
3, 1.0876, 1, 0, 0.221477,-0.0231784) , 
1, 1.29547, 1, 0, 0.243335,0.00179823)    );
  // itree = 1095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104218,-0.0194179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299246,0.00288652) , 
0, -0.715752, 1, 0, 0.24024,-0.0176678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244681,-0.0284239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308,0.00046561) , 
3, 0.81389, 1, 0, 0.290698,0.0153143) , 
3, 0.436997, 1, 0, 0.257426,-0.00643425)    );
  // itree = 1096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207262,-0.00921346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287129,-0.063643) , 
3, 1.35572, 1, 0, 0.21293,-0.016236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129032,-0.00413858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682243,0.0180187) , 
3, 1.25551, 1, 0, 0.354962,0.0142949) , 
2, 0.843823, 1, 0, 0.251156,-0.00801914)    );
  // itree = 1097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443946,0.0089508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179464,-0.00673609) , 
2, -0.411784, 1, 0, 0.278368,-0.0101811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104348,0.0416604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963303,-0.00322523) , 
2, 0.902897, 1, 0, 0.0990991,0.0194459) , 
3, 1.29328, 1, 0, 0.250236,-0.00553179)    );
  // itree = 1098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201923,0.00246532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0377358,-0.00357373) , 
0, 0.579671, 1, 0, 0.168582,0.0126699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355556,0.00233349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2777,0.0112072) , 
0, 0.00479293, 1, 0, 0.309603,-0.00913075) , 
2, -0.22187, 1, 0, 0.254144,-0.000557218)    );
  // itree = 1099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146766,-0.00151318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268672,-0.00701306) , 
3, -1.0334, 1, 0, 0.232796,0.0180161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331849,0.0147761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0873786,-0.014598) , 
3, 1.38367, 1, 0, 0.254962,-0.0137063) , 
2, 0.726098, 1, 0, 0.23998,0.00773495)    );
  // itree = 1100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0183948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246377,-0.0669124) , 
2, -1.09591, 1, 0, 0.198444,-0.0426515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18775,-0.0121413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635451,0.0153278) , 
3, 1.34924, 1, 0, 0.262077,-0.00414829) , 
1, -0.999833, 1, 0, 0.25413,-0.00895652)    );
  // itree = 1101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00616994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198802,-0.000165582) , 
2, -0.7458, 1, 0, 0.286321,-0.00393541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191626,-0.0155442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0809524,-0.00659101) , 
3, 1.40895, 1, 0, 0.163658,0.0212483) , 
0, 0.249369, 1, 0, 0.235558,0.00648674)    );
  // itree = 1102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0773196,-0.0480883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35443,0.00261464) , 
2, -1.37865, 1, 0, 0.313077,-0.00367571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0780685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17175,0.00600763) , 
2, -0.0123846, 1, 0, 0.141534,0.0386085) , 
3, 0.356305, 1, 0, 0.25,0.0118724)    );
  // itree = 1103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0191792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262626,0.0523782) , 
2, -1.50414, 1, 0, 0.22807,-0.0207354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621212,0.0554869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198099,-0.0150684) , 
2, -1.04968, 1, 0, 0.235333,0.0122064) , 
3, -1.04915, 1, 0, 0.233482,0.00381141)    );
  // itree = 1104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0726257,-0.0090362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288043,0.0406273) , 
3, -0.862975, 1, 0, 0.181818,0.0201098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248511,-0.00715035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846847,0.0309389) , 
3, 1.95018, 1, 0, 0.300156,-0.0018746) , 
2, -0.251291, 1, 0, 0.257455,0.00605814)    );
  // itree = 1105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340502,0.00590859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.01,-0.0605975) , 
3, 0.837704, 1, 0, 0.305229,-0.00783571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252912,-0.00707784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113475,-0.000644229) , 
3, 0.72878, 1, 0, 0.195312,0.0146321) , 
0, -0.0763418, 1, 0, 0.247833,0.00389658)    );
  // itree = 1106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32235,-0.0047319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31411,0.00678935) , 
0, -0.351367, 1, 0, 0.317911,-0.0060364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15,0.0251995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,-0.0119624) , 
3, 1.10744, 1, 0, 0.0976562,0.0257718) , 
3, 0.830113, 1, 0, 0.262222,0.00200597)    );
  // itree = 1107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223881,-0.0148188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468354,-0.0128868) , 
3, 1.2506, 1, 0, 0.248562,-0.000319781) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30742,0.028891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159292,-0.00680205) , 
0, 1.31159, 1, 0, 0.265152,-0.0397975) , 
2, 1.07686, 1, 0, 0.251912,-0.00829182)    );
  // itree = 1108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0645161,-0.0335022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248822,0.00405145) , 
2, -1.06954, 1, 0, 0.210448,-0.00155358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255474,-0.0925695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328302,-0.00576716) , 
1, 0.311935, 1, 0, 0.313343,-0.0256247) , 
2, 0.684685, 1, 0, 0.244644,-0.0095533)    );
  // itree = 1109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258012,-0.00434393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0762712,-0.015397) , 
2, 1.58588, 1, 0, 0.247065,0.0118372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0176991,-0.0670984) , 
2, 1.85179, 1, 0, 0.234556,0.0152523)    );
  // itree = 1110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306818,-0.0178598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264385,-0.00208818) , 
0, -0.826291, 1, 0, 0.273043,-7.79832e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0815561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107692,-0.018689) , 
2, 0.905427, 1, 0, 0.0646154,-0.0354144) , 
3, 1.25904, 1, 0, 0.24,-0.0056801)    );
  // itree = 1111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174965,-0.0139713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543624,0.0826026) , 
3, 1.2941, 1, 0, 0.209404,-0.00259588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471154,-0.00135358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277946,-0.0271311) , 
1, -0.14278, 1, 0, 0.324138,0.0288295) , 
0, 0.956597, 1, 0, 0.23399,0.00413813)    );
  // itree = 1112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0881696,-0.01173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441301,0.0156705) , 
3, -0.0905164, 1, 0, 0.243918,0.00586053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160173,-0.0359117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281046,0.00188686) , 
0, 1.43202, 1, 0, 0.208333,-0.0178042) , 
0, 1.00007, 1, 0, 0.237041,0.00128718)    );
  // itree = 1113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277812,0.000916865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120567,-0.0238522) , 
0, 1.05367, 1, 0, 0.2548,5.53489e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0373832,-0.0349219) , 
3, 1.83453, 1, 0, 0.243363,0.00312239)    );
  // itree = 1114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334821,-0.00385532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280788,0.00833519) , 
3, -0.732691, 1, 0, 0.305256,0.00249199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0176991,-0.0433683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120344,0.00065662) , 
0, 0.119274, 1, 0, 0.0952381,-0.0237844) , 
3, 0.893281, 1, 0, 0.255396,-0.0037463)    );
  // itree = 1115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213765,-0.0205447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27169,-0.00607176) , 
2, 0.64072, 1, 0, 0.22893,-0.00467667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544643,0.0314479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0742574,-0.0381607) , 
2, 0.888457, 1, 0, 0.242038,0.0520595) , 
3, 1.22047, 1, 0, 0.231002,0.00428918)    );
  // itree = 1116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214429,0.0185085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0409836,-0.049516) , 
0, 1.04003, 1, 0, 0.195536,0.0117724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.0602097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34443,-0.00775676) , 
2, 0.49073, 1, 0, 0.332958,-0.0182109) , 
2, 0.314309, 1, 0, 0.256346,-0.00149549)    );
  // itree = 1117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470919,0.00184452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208368,0.00201999) , 
2, -0.591796, 1, 0, 0.289352,-0.00719585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0421687,-0.0219666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110236,-0.00493872) , 
0, 1.19527, 1, 0, 0.0716724,0.0517329) , 
3, 1.3043, 1, 0, 0.257793,0.00134751)    );
  // itree = 1118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370667,0.0147445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170455,0.00858283) , 
3, -0.529216, 1, 0, 0.262577,0.0089428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381295,0.0029636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285156,-0.0114423) , 
0, 0.352787, 1, 0, 0.318987,-0.0252584) , 
2, 1.12881, 1, 0, 0.27358,0.00227146)    );
  // itree = 1119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0838684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224293,0.00108849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387471,-0.00295428) , 
0, 0.91042, 1, 0, 0.261702,0.00366905) , 
0, -1.68098, 1, 0, 0.248485,0.00729201)    );
  // itree = 1120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0992366,0.00371679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566406,0.0446686) , 
3, -0.685408, 1, 0, 0.283513,0.0290633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161429,-0.0230502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328767,0.00765626) , 
2, 0.551649, 1, 0, 0.242447,-0.00584855) , 
1, -0.187201, 1, 0, 0.255733,0.00544646)    );
  // itree = 1121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526316,-0.00110503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336554,-0.000747362) , 
3, -1.30995, 1, 0, 0.393461,0.0280229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168574,0.00135384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0843373,0.00847015) , 
3, 1.5456, 1, 0, 0.156167,-0.00830675) , 
2, -0.0929401, 1, 0, 0.260675,0.00769345)    );
  // itree = 1122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310409,0.00363743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0688468,-0.0323549) , 
3, -0.723818, 1, 0, 0.184987,0.0191695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28125,-0.00593044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36017,0.0101459) , 
2, 0.505829, 1, 0, 0.348086,-0.0177978) , 
2, 0.30194, 1, 0, 0.254731,0.0033615)    );
  // itree = 1123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222039,0.0329766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250232,-0.0141876) , 
3, -0.737428, 1, 0, 0.240071,0.00563821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360465,0.0687189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158879,-0.0500653) , 
1, 1.38231, 1, 0, 0.283154,-0.0432928) , 
3, 1.29328, 1, 0, 0.246185,-0.00130571)    );
  // itree = 1124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275207,0.00320582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15192,-0.0261936) , 
1, 0.785572, 1, 0, 0.234384,-0.00559495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372781,0.017676) , 
1, 1.5317, 1, 0, 0.246208,-0.00256652)    );
  // itree = 1125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533923,0.00440986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257642,-0.00529175) , 
2, -0.831083, 1, 0, 0.348928,-0.00541475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181979,-0.00817214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104723,0.0115437) , 
3, 0.871475, 1, 0, 0.146249,0.0233387) , 
3, -0.112181, 1, 0, 0.246272,0.00914867)    );
  // itree = 1126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411606,0.0183676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184923,-0.00927478) , 
3, -0.45652, 1, 0, 0.290566,-0.00138562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159722,-0.00935692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125874,-0.0220922) , 
0, 1.47802, 1, 0, 0.148492,-0.0213249) , 
0, 0.944261, 1, 0, 0.260267,-0.00563788)    );
  // itree = 1127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202153,-0.0114179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282971,-0.0112064) , 
3, -0.26864, 1, 0, 0.241187,0.0038611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242718,0.0650096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235099,-0.00289012) , 
1, 0.687371, 1, 0, 0.237037,-0.0167647) , 
2, 1.08337, 1, 0, 0.240356,-0.000270183)    );
  // itree = 1128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101786,-0.00497405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412831,0.0184327) , 
3, 0.114642, 1, 0, 0.22319,0.00865418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576531,-0.0262441) , 
3, 1.65362, 1, 0, 0.257255,0.00288422)    );
  // itree = 1129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271512,-0.00184148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940594,-0.00756807) , 
3, 1.12139, 1, 0, 0.252862,-0.00230707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101562,0.0417323) , 
3, 1.74551, 1, 0, 0.243415,-0.00493015)    );
  // itree = 1130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301471,-0.000725725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860534,-0.0314961) , 
3, 0.818349, 1, 0, 0.261866,0.00299477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,0.0529158) , 
3, 1.76176, 1, 0, 0.251897,-0.00150156)    );
  // itree = 1131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204403,0.020888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226528,0.00883235) , 
2, -0.930873, 1, 0, 0.219414,-0.00665594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294537,-0.0124255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0645161,-0.0166995) , 
3, 1.85258, 1, 0, 0.26501,0.0142756) , 
3, -0.112181, 1, 0, 0.241944,0.00368671)    );
  // itree = 1132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00628931,-0.0688364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241462,0.00156305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769231,0.0280291) , 
3, 1.81106, 1, 0, 0.2796,0.00545865) , 
3, -1.75118, 1, 0, 0.257406,0.00223425)    );
  // itree = 1133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400236,-0.00265025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,-0.0284087) , 
3, 0.279349, 1, 0, 0.333333,0.0161278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127907,0.0174918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118421,0.00332497) , 
0, -0.570041, 1, 0, 0.120172,-0.015227) , 
1, 0.552807, 1, 0, 0.2359,0.00179596)    );
  // itree = 1134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318471,0.0269395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.0315844) , 
0, -0.404593, 1, 0, 0.247458,-0.0277743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323401,-0.00226745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.096828,-0.0153631) , 
3, 0.633609, 1, 0, 0.245402,-0.0047149) , 
1, -0.87377, 1, 0, 0.2457,-0.00805766)    );
  // itree = 1135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189944,-0.00460114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265239,0.0155945) , 
2, -0.420441, 1, 0, 0.229895,-0.0141509) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252613,-0.00705547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23494,-0.028318) , 
0, 0.962369, 1, 0, 0.246137,0.0259695) , 
3, 0.130099, 1, 0, 0.237073,0.00358037)    );
  // itree = 1136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140248,-0.00800082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431925,0.02268) , 
3, 0.590776, 1, 0, 0.209471,0.00425109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548387,-0.0288575) , 
3, 1.64499, 1, 0, 0.241292,-0.00181882)    );
  // itree = 1137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606061,0.00305726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343284,0.0178873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115466,-0.00366766) , 
1, 0.516321, 1, 0, 0.229012,-0.0149995) , 
1, -1.12426, 1, 0, 0.264904,-0.0107057)    );
  // itree = 1138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299738,-0.00515923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246649,0.00977205) , 
0, -0.35699, 1, 0, 0.268189,0.00136547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0294118,-0.0601292) , 
3, 1.76176, 1, 0, 0.252105,0.0058299)    );
  // itree = 1139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188937,0.00601249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453125,0.00790782) , 
0, 0.631053, 1, 0, 0.246059,-0.000335958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299065,-0.0163296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,0.00524642) , 
3, 1.60096, 1, 0, 0.246988,0.0351673) , 
3, 1.30934, 1, 0, 0.246205,0.00525563)    );
  // itree = 1140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102784,0.00583232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448598,0.0311873) , 
3, -0.675427, 1, 0, 0.243655,0.0202059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252217,-0.00588204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304813,-0.0313457) , 
2, 1.57008, 1, 0, 0.260399,-0.0116593) , 
0, -0.293879, 1, 0, 0.253769,0.000958645)    );
  // itree = 1141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451895,0.00444134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175501,-0.00604545) , 
2, -0.282335, 1, 0, 0.299023,-0.00234424) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118243,0.0167642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.076555,-0.01456) , 
2, 1.19475, 1, 0, 0.10099,0.0207496) , 
3, 0.802707, 1, 0, 0.25,0.00337262)    );
  // itree = 1142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355107,-0.000792354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0136054,-0.0644366) , 
3, 0.572562, 1, 0, 0.304348,-0.01045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275434,0.00404669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189107,0.010752) , 
3, 0.0851123, 1, 0, 0.221805,0.00914559) , 
0, -0.0324937, 1, 0, 0.261568,-0.000294291)    );
  // itree = 1143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219839,0.00218068) , 
1, -0.987037, 1, 0, 0.178455,-0.00795856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359401,0.0175278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255507,-0.0109452) , 
3, 0.599808, 1, 0, 0.314692,0.0126936) , 
0, -0.0763418, 1, 0, 0.251266,0.00307892)    );
  // itree = 1144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294798,0.0615312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244726,-0.000736707) , 
0, -0.979193, 1, 0, 0.258114,0.0182538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20464,-0.0171232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302326,-0.0423546) , 
0, 1.32355, 1, 0, 0.216824,-0.0232728) , 
1, -0.187201, 1, 0, 0.23001,-0.0100113)    );
  // itree = 1145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281269,-0.00374739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0687023,-0.0117177) , 
3, 1.22291, 1, 0, 0.251973,-0.00132241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131737,0.0106334) , 
1, 1.58018, 1, 0, 0.242263,-0.00669323)    );
  // itree = 1146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206767,0.000615052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294154,0.00643631) , 
1, -0.887572, 1, 0, 0.28175,-0.00135116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0733945,-0.0221539) , 
3, 1.95294, 1, 0, 0.270298,0.0017888)    );
  // itree = 1147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0756469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985916,0.0114851) , 
0, -0.576462, 1, 0, 0.0520446,0.0315171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239726,0.0179896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335512,-0.00245472) , 
0, -0.0233042, 1, 0, 0.293083,-0.00881969) , 
1, -0.887572, 1, 0, 0.259259,-0.0031595)    );
  // itree = 1148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329897,0.0714164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.000132729) , 
0, -0.327972, 1, 0, 0.313099,0.0528953) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227129,0.0125307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308696,-0.0111764) , 
2, 0.922723, 1, 0, 0.248843,0.00540606) , 
1, -0.840753, 1, 0, 0.258697,0.0126888)    );
  // itree = 1149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595588,0.00982247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288364,-0.000892376) , 
2, -1.45016, 1, 0, 0.31997,0.00972256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0508475,-0.038753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0905923,-0.00202848) , 
3, 0.745695, 1, 0, 0.0686427,-0.0262515) , 
1, 1.04069, 1, 0, 0.237901,-0.00202446)    );
  // itree = 1150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398693,-0.0148359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.00982308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245438,-0.00456666) , 
1, -1.18003, 1, 0, 0.239284,-0.00445378) , 
0, -1.35128, 1, 0, 0.251503,0.00081154)    );
  // itree = 1151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223017,-0.00147773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455696,0.035414) , 
3, 1.12545, 1, 0, 0.254084,-0.0101606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481481,0.04508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.04,-0.0564724) , 
3, 1.10609, 1, 0, 0.244635,0.0292754) , 
2, 1.51846, 1, 0, 0.252988,-0.00558464)    );
  // itree = 1152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23436,0.00751335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167315,-0.019779) , 
0, 0.170012, 1, 0, 0.206298,-0.00417714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624242,-0.0243073) , 
3, 1.74459, 1, 0, 0.240658,-0.00808563)    );
  // itree = 1153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275268,-0.00596763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12381,0.0224267) , 
1, 1.45677, 1, 0, 0.258457,-0.0118319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0519481,-0.0301331) , 
3, 1.74459, 1, 0, 0.242913,-0.00805758)    );
  // itree = 1154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22542,0.0101369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0247525,-0.0705165) , 
1, 0.0863002, 1, 0, 0.159935,0.0171232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264151,0.0202157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289634,-0.0056642) , 
1, -0.738196, 1, 0, 0.287729,-0.00912156) , 
2, -0.472985, 1, 0, 0.248895,-0.00114634)    );
  // itree = 1155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0126571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285366,-0.00908851) , 
0, -0.306566, 1, 0, 0.219737,0.00655424) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459574,0.0252655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121094,-0.0100021) , 
2, 0.93199, 1, 0, 0.283096,-0.0222575) , 
3, 0.853537, 1, 0, 0.235206,-0.00048036)    );
  // itree = 1156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.087281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193858,0.029967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288184,-0.00488284) , 
2, -0.45197, 1, 0, 0.262441,0.00340886) , 
2, -1.63537, 1, 0, 0.24802,0.000791445)    );
  // itree = 1157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425373,0.0183473) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302521,-0.0322173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207523,-0.0015631) , 
3, -1.03302, 1, 0, 0.225382,0.00588414) , 
0, -1.45539, 1, 0, 0.238564,0.00313424)    );
  // itree = 1158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232526,0.00630371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290123,-0.0155277) , 
2, 0.785012, 1, 0, 0.247022,0.0061966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454545,0.0416338) , 
1, 1.68939, 1, 0, 0.258207,0.00185458)    );
  // itree = 1159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0149254,0.0278832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,0.0171253) , 
3, -1.00565, 1, 0, 0.0555556,-0.0592812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309645,0.00210334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226266,-0.00334044) , 
2, 0.623107, 1, 0, 0.277056,-0.0117917) , 
1, -0.840753, 1, 0, 0.24181,-0.0193485)    );
  // itree = 1160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197225,0.0114346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192362,-0.0208476) , 
2, 0.2699, 1, 0, 0.195221,-0.00142017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339806,-0.0296265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755682,0.039808) , 
2, 0.888457, 1, 0, 0.602151,0.0339414) , 
3, 1.29216, 1, 0, 0.25213,0.00352514)    );
  // itree = 1161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319749,0.00143532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258341,0.0101545) , 
0, -0.480903, 1, 0, 0.281565,-0.00694778) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0159366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.085,-0.0180622) , 
0, 0.839716, 1, 0, 0.0660377,0.0600465) , 
3, 1.27365, 1, 0, 0.247382,0.00367774)    );
  // itree = 1162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292289,-0.00016458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0316456,-0.0531946) , 
3, 1.37331, 1, 0, 0.268969,0.00245868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,-0.026919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206612,0.0448687) , 
0, 1.50475, 1, 0, 0.163717,-0.0350264) , 
0, 1.32631, 1, 0, 0.257028,-0.00179414)    );
  // itree = 1163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291262,0.0103509) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0817657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291161,0.00136284) , 
0, -1.40162, 1, 0, 0.273764,0.00106158) , 
1, -1.11873, 1, 0, 0.249145,0.00634057)    );
  // itree = 1164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198505,0.00195942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134361,-0.0269618) , 
2, 0.615033, 1, 0, 0.180941,-0.00403878) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365297,-0.0354953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794393,0.012026) , 
3, 1.85725, 1, 0, 0.506135,-0.0379621) , 
3, 1.14622, 1, 0, 0.234375,-0.00961288)    );
  // itree = 1165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38835,-0.00623195) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264574,-0.00220152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.066879,-0.0236054) , 
3, 1.23003, 1, 0, 0.231467,0.0075499) , 
0, -1.68098, 1, 0, 0.239636,0.0113466)    );
  // itree = 1166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309623,0.0101877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0451128,-0.0422019) , 
3, -1.31063, 1, 0, 0.144201,0.0288479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336142,0.00138641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691489,-0.00613932) , 
3, 1.57365, 1, 0, 0.299636,-0.000587775) , 
2, -0.472985, 1, 0, 0.250373,0.00874157)    );
  // itree = 1167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0462287,-0.00876792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115453,-0.0155762) , 
3, -0.909406, 1, 0, 0.0862423,0.0220252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439169,0.0170653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391667,0.0148813) , 
0, 0.62088, 1, 0, 0.422631,-0.0172051) , 
1, 0.380883, 1, 0, 0.259462,0.00182391)    );
  // itree = 1168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148292,-0.0130427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519916,0.0126992) , 
3, 0.560956, 1, 0, 0.248725,-0.00168392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.0285085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431193,-0.0368503) , 
0, 0.99702, 1, 0, 0.328063,-0.0455109) , 
2, 1.46433, 1, 0, 0.258672,-0.00717858)    );
  // itree = 1169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28528,0.00405583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.087963,0.00226726) , 
3, 1.21919, 1, 0, 0.262366,-0.00726186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0490196,-0.0264766) , 
3, 2.06951, 1, 0, 0.251274,-0.00310856)    );
  // itree = 1170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195455,-0.020057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535885,0.0249533) , 
2, -0.719993, 1, 0, 0.361305,-0.016738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213846,-0.0112699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221384,0.000291314) , 
0, 0.0918307, 1, 0, 0.217993,0.00778815) , 
3, -1.04915, 1, 0, 0.2508,0.00217358)    );
  // itree = 1171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0481928,-0.000150606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0968343,-0.0262982) , 
3, -1.33416, 1, 0, 0.0814249,0.0253815) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404292,0.00985137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0791717) , 
3, 1.95034, 1, 0, 0.370866,-0.00572963) , 
1, -0.0220085, 1, 0, 0.260214,0.00616403)    );
  // itree = 1172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122271,0.0293484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860077,-0.0234577) , 
2, -1.14288, 1, 0, 0.094246,-0.00619969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436455,0.0213506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441096,-0.00748226) , 
2, 0.914543, 1, 0, 0.438214,0.0148728) , 
3, 0.000826949, 1, 0, 0.262303,0.00409601)    );
  // itree = 1173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382231,-0.00754465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213803,0.00495853) , 
3, -0.944869, 1, 0, 0.258668,0.00506302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158824,0.00455237) , 
0, 1.41877, 1, 0, 0.250126,-0.000159741)    );
  // itree = 1174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118397,-0.0248532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279938,0.00070479) , 
2, -0.564188, 1, 0, 0.231608,0.00182774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44,0.0465516) , 
1, 1.65151, 1, 0, 0.242377,-0.000871479)    );
  // itree = 1175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193477,-0.00352836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413502,0.00935294) , 
0, 0.708151, 1, 0, 0.250686,0.00126258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0196078,-0.0989184) , 
1, 1.73788, 1, 0, 0.238442,0.00493396)    );
  // itree = 1176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0814144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257926,0.0107101) , 
3, -1.97613, 1, 0, 0.244275,0.00791869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354545,-0.0283232) , 
1, 1.68641, 1, 0, 0.25012,0.00452249)    );
  // itree = 1177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373045,-0.00349849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167808,0.00407253) , 
3, -0.356224, 1, 0, 0.267721,0.00974621) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178571,0.000929246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109375,0.016973) , 
3, 1.73713, 1, 0, 0.153409,-0.0146624) , 
0, 1.07303, 1, 0, 0.248179,0.00557339)    );
  // itree = 1178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346939,-0.00518459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115839,-0.024078) , 
3, -0.652318, 1, 0, 0.239869,0.00954307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304054,0.0152934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231016,-0.00592836) , 
0, -0.73748, 1, 0, 0.240997,-0.015433) , 
1, 0.259956, 1, 0, 0.240481,-0.00400858)    );
  // itree = 1179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0368421,0.0810185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323353,0.0317525) , 
1, -0.884815, 1, 0, 0.244573,-0.00708566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107744,-0.00663229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315539,-0.00442748) , 
1, -0.0777464, 1, 0, 0.269688,0.0168972) , 
3, -0.691091, 1, 0, 0.261168,0.00876162)    );
  // itree = 1180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131313,0.0345006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00729927,-0.0740481) , 
0, -1.63293, 1, 0, 0.0313726,-0.015975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0550161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303459,0.00834174) , 
0, -0.641105, 1, 0, 0.329001,0.0193463) , 
3, -0.976372, 1, 0, 0.252028,0.0102115)    );
  // itree = 1181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618182,0.00460756) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361789,0.00808955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201805,0.00374636) , 
2, -0.960393, 1, 0, 0.223706,0.00557168) , 
1, -1.24613, 1, 0, 0.256881,0.00212657)    );
  // itree = 1182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234111,-0.00415794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467626,0.0105918) , 
2, 0.655412, 1, 0, 0.292771,-0.0107092) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0181818,-0.054997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985916,-0.0255652) , 
0, 0.740673, 1, 0, 0.0712074,0.0488822) , 
3, 1.22047, 1, 0, 0.256682,-0.00100266)    );
  // itree = 1183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197949,0.0077238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319415,0.00478925) , 
0, -0.0142405, 1, 0, 0.258148,0.00122213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0173913,-0.0865941) , 
1, 1.7097, 1, 0, 0.244629,-0.00322066)    );
  // itree = 1184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185466,-0.0207185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275244,0.00257945) , 
0, -0.147505, 1, 0, 0.221354,-0.0111935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729167,0.00934978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626866,0.0381362) , 
3, 1.08427, 1, 0, 0.300613,0.0382248) , 
0, 0.782376, 1, 0, 0.240494,0.000740106)    );
  // itree = 1185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355717,-0.0151144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24,0.00823944) , 
3, -0.903767, 1, 0, 0.279213,0.00212742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291262,-0.0298523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,-0.00189518) , 
0, 0.581359, 1, 0, 0.081571,-0.0368295) , 
3, 1.17778, 1, 0, 0.245784,-0.00446161)    );
  // itree = 1186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451537,0.0188512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175701,-0.0277399) , 
3, -0.974354, 1, 0, 0.297495,0.0153989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260404,0.00385078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102041,0.00233801) , 
3, 1.40654, 1, 0, 0.230473,-0.00556745) , 
0, -0.0763418, 1, 0, 0.262657,0.00450062)    );
  // itree = 1187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251163,-0.000645814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366337,-0.0235375) , 
3, 1.41686, 1, 0, 0.257551,0.00593119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0379771) , 
3, 1.73078, 1, 0, 0.254462,0.00237695)    );
  // itree = 1188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238938,0.00156535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0864662,-0.0350109) , 
0, 1.05367, 1, 0, 0.216991,-0.00322537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736264,0.0193788) , 
3, 1.73078, 1, 0, 0.263547,0.000323303)    );
  // itree = 1189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338843,-0.0171609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304348,0.0129947) , 
0, 0.30526, 1, 0, 0.326768,0.0158804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133903,0.0204339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110368,-0.00577731) , 
0, -0.133691, 1, 0, 0.119073,-0.0169718) , 
1, 0.529246, 1, 0, 0.231365,0.000790027)    );
  // itree = 1190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28555,0.00295496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485437,-0.0571162) , 
3, 1.25406, 1, 0, 0.272283,-0.00734483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0966184,0.0212963) , 
3, 1.57074, 1, 0, 0.254519,-0.00367059)    );
  // itree = 1191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147005,-0.00989371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294406,0.0065057) , 
0, -0.533121, 1, 0, 0.242675,-0.00205914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536458,0.0120637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0790514,-0.0423787) , 
2, 0.888457, 1, 0, 0.276405,0.0272217) , 
3, 0.934112, 1, 0, 0.250124,0.00440735)    );
  // itree = 1192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116959,0.0158298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544118,0.0330077) , 
3, -0.341471, 1, 0, 0.238494,0.0216592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112568,-0.0348861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565534,0.0178804) , 
3, 0.863966, 1, 0, 0.253203,-0.00648495) , 
0, -0.402053, 1, 0, 0.248043,0.00338753)    );
  // itree = 1193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532294,0.00789646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204082,-0.0133493) , 
2, -0.255879, 1, 0, 0.402423,0.014721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163339,0.000448368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0642202,-0.00084155) , 
3, 1.85865, 1, 0, 0.154418,-0.0104136) , 
1, -0.0541425, 1, 0, 0.248721,-0.000856279)    );
  // itree = 1194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324242,-0.011283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131687,0.000101012) , 
3, -0.855205, 1, 0, 0.242583,0.0141854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229647,-0.00664445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388889,0.0209012) , 
2, 1.79169, 1, 0, 0.243697,-0.0104583) , 
1, -0.239149, 1, 0, 0.243378,-0.00340142)    );
  // itree = 1195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0404762,-0.00124923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102941,-0.042617) , 
3, -0.424003, 1, 0, 0.0608974,0.0229738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387387,0.00344649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221311,-0.0114827) , 
2, 0.821558, 1, 0, 0.328488,-0.00470669) , 
1, -0.187201, 1, 0, 0.245,0.00392964)    );
  // itree = 1196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240125,0.0269502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133697,-0.0133467) , 
0, 0.0170503, 1, 0, 0.1941,0.00907568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52,-0.0122751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485437,-0.032657) , 
0, 0.977148, 1, 0, 0.501312,-0.0478093) , 
3, 1.12933, 1, 0, 0.250482,-0.00136419)    );
  // itree = 1197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348135,0.00132546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186441,0.0131164) , 
3, 0.116128, 1, 0, 0.296319,0.00537532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0862069,0.0151813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0794702,-0.0107887) , 
2, 1.26942, 1, 0, 0.0830769,-0.0293734) , 
3, 1.29216, 1, 0, 0.261352,-0.000322631)    );
  // itree = 1198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275572,-0.00351464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151515,0.00858007) , 
3, 1.24997, 1, 0, 0.268597,-0.0125687) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.020202,-0.0162119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0982143,-0.0232888) , 
1, 1.24765, 1, 0, 0.0616114,0.0300157) , 
3, 1.55602, 1, 0, 0.24645,-0.00801226)    );
  // itree = 1199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0808431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203846,0.0321402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290443,0.0114637) , 
0, -0.759434, 1, 0, 0.278345,-0.00324061) , 
0, -1.43147, 1, 0, 0.25913,-0.000670031)    );
  // itree = 1200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176647,-0.0241823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224835,0.00655785) , 
0, -0.792183, 1, 0, 0.213314,-0.00121655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252381,-0.0444887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.00350639) , 
2, 1.65326, 1, 0, 0.289735,-0.036533) , 
2, 0.721559, 1, 0, 0.236382,-0.0118768)    );
  // itree = 1201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509677,0.00559004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244568,0.000131914) , 
2, -1.55665, 1, 0, 0.265641,-0.00206692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797872,0.0135783) , 
3, 1.74459, 1, 0, 0.249298,-0.00583619)    );
  // itree = 1202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508621,0.0242133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253731,0.00230977) , 
0, -1.13386, 1, 0, 0.372,-0.0173913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180328,-0.0430383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231021,0.00175536) , 
0, -0.866028, 1, 0, 0.225599,0.00992962) , 
3, -1.51764, 1, 0, 0.244263,0.00644659)    );
  // itree = 1203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0799729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0202703,-0.00931275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297106,-0.000644478) , 
1, -1.18003, 1, 0, 0.274851,-0.000960604) , 
0, -1.43977, 1, 0, 0.255169,0.00225419)    );
  // itree = 1204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201923,0.0101779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0380282,-0.0417637) , 
0, -1.6491, 1, 0, 0.0589681,-0.01579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316151,0.0333724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385106,0.000207681) , 
2, -0.183086, 1, 0, 0.368806,0.00962609) , 
3, -0.462334, 1, 0, 0.245477,-0.000490646)    );
  // itree = 1205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506494,0.00478281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123944,-0.0256942) , 
1, -0.0186132, 1, 0, 0.340269,-0.0120985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221889,0.00337754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11157,0.00525551) , 
1, 1.0361, 1, 0, 0.1755,0.0151613) , 
3, -0.386748, 1, 0, 0.243902,0.00384465)    );
  // itree = 1206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185446,-0.0154025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178371,-0.0100433) , 
1, -0.475312, 1, 0, 0.181019,0.00813249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361789,0.00177433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26969,0.00882516) , 
0, 0.588381, 1, 0, 0.319429,-0.0158668) , 
2, 0.30194, 1, 0, 0.242557,-0.00253776)    );
  // itree = 1207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139313,-0.000729653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244952,-0.00976323) , 
0, -0.59762, 1, 0, 0.211666,-0.00699297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.657534,0.0234405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168421,-0.0477245) , 
3, 0.816234, 1, 0, 0.380952,0.0161653) , 
0, 1.07303, 1, 0, 0.24012,-0.00310044)    );
  // itree = 1208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171756,0.0246742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218454,-0.0135591) , 
2, -0.591796, 1, 0, 0.204799,-0.00299617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646465,0.0201351) , 
3, 1.55602, 1, 0, 0.248744,0.00147014)    );
  // itree = 1209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.743902,0.0255237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342342,-0.00604114) , 
2, -0.921977, 1, 0, 0.581818,-0.0379277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32381,0.00122374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160729,0.00550028) , 
1, 0.0349923, 1, 0, 0.210162,-0.0069094) , 
1, -0.952616, 1, 0, 0.261086,-0.0111595)    );
  // itree = 1210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322034,-0.00140928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516779,0.0239035) , 
1, -0.682114, 1, 0, 0.430712,0.0360568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254062,-0.00535523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0851064,0.00658927) , 
3, 1.03687, 1, 0, 0.217341,0.000785362) , 
0, -1.05347, 1, 0, 0.245869,0.00550118)    );
  // itree = 1211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207679,0.012163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23431,-0.00924579) , 
3, -0.868506, 1, 0, 0.225679,0.00600445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72381,0.0209014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268966,0.00469125) , 
3, 0.833951, 1, 0, 0.46,-0.0299089) , 
0, 1.28629, 1, 0, 0.254708,0.00155532)    );
  // itree = 1212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232742,0.00454067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103448,-0.0511137) , 
1, 0.784032, 1, 0, 0.195775,-0.0119288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13089,-0.00085264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549213,0.0296027) , 
3, 0.651123, 1, 0, 0.297956,0.0208598) , 
0, -0.340193, 1, 0, 0.261352,0.00911414)    );
  // itree = 1213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322384,0.00694342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20629,-0.00358322) , 
0, -0.179217, 1, 0, 0.256437,-0.00609746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136,0.0045075) , 
1, 1.68939, 1, 0, 0.249014,-0.00262205)    );
  // itree = 1214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.024765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163158,0.00417748) , 
2, -1.033, 1, 0, 0.123529,0.0231844) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244755,0.0109707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295858,0.00117044) , 
2, -0.159155, 1, 0, 0.285909,-0.0174409) , 
2, -0.656951, 1, 0, 0.244063,-0.00697155)    );
  // itree = 1215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244493,0.00520062) , 
3, -2.12097, 1, 0, 0.217861,-0.0117887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.00153214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349282,-0.00817156) , 
1, 0.645786, 1, 0, 0.279468,0.0228959) , 
3, -0.112181, 1, 0, 0.249155,0.00582996)    );
  // itree = 1216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179707,-0.00652819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366197,-0.0328797) , 
3, 0.575536, 1, 0, 0.207292,-0.0144664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287787,0.0218192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262857,-0.0310965) , 
0, 1.41627, 1, 0, 0.283433,0.0110942) , 
0, 0.0296075, 1, 0, 0.246177,-0.00141251)    );
  // itree = 1217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452174,-0.0117288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259162,0.0160513) , 
2, -0.99296, 1, 0, 0.294714,0.00028584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0462963,-0.0359697) , 
2, 1.85179, 1, 0, 0.281171,0.00418699)    );
  // itree = 1218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264201,0.0085152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404959,0.0304979) , 
2, 0.667991, 1, 0, 0.283599,0.00911597) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244444,-0.00638083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225806,-0.00464697) , 
0, -0.436558, 1, 0, 0.230352,-0.00929801) , 
1, 0.259956, 1, 0, 0.253904,-0.00115319)    );
  // itree = 1219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0918018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124209,-0.0158045) , 
1, -1.48567, 1, 0, 0.114766,0.0152962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.657328,0.0317647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320675,-0.0196304) , 
1, 1.48462, 1, 0, 0.543509,-0.0169183) , 
1, 0.939437, 1, 0, 0.260029,0.00438156)    );
  // itree = 1220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0616883,-0.0119976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292823,0.0166553) , 
3, -0.737428, 1, 0, 0.207104,0.00910227) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386555,-0.0467433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692308,-0.000818858) , 
2, 1.21031, 1, 0, 0.553435,-0.0394882) , 
3, 1.29328, 1, 0, 0.25429,0.00248204)    );
  // itree = 1221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410526,-0.00321769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116592,-0.012314) , 
3, -0.690253, 1, 0, 0.301824,0.0186827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347059,0.0105373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11611,-0.00207306) , 
1, 0.601922, 1, 0, 0.230825,-0.00528854) , 
0, -0.49228, 1, 0, 0.252535,0.0020414)    );
  // itree = 1222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288066,0.000890334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0463918,-0.0201521) , 
3, 0.827607, 1, 0, 0.23727,-0.00284464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306878,0.0171269) , 
1, 1.50236, 1, 0, 0.243735,0.000801554)    );
  // itree = 1223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0830196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253076,-0.00749535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262009,0.036043) , 
2, 1.55405, 1, 0, 0.254132,0.00589675) , 
0, -1.68098, 1, 0, 0.241058,0.00881443)    );
  // itree = 1224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24854,0.0161008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.784,0.0463628) , 
3, 1.14122, 1, 0, 0.299094,0.0225126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147059,-0.0314816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207513,0.00354518) , 
0, -0.635545, 1, 0, 0.198185,-0.00260528) , 
1, 1.01709, 1, 0, 0.265491,0.0141484)    );
  // itree = 1225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50838,-0.0172823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,-0.0183432) , 
1, 0.365922, 1, 0, 0.384158,0.0236755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278519,0.000566785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125794,-0.000140831) , 
1, 0.464077, 1, 0, 0.196306,-0.00837029) , 
2, -0.695641, 1, 0, 0.244535,-0.000142964)    );
  // itree = 1226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370229,0.00872318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266004,-0.00461894) , 
0, -0.529333, 1, 0, 0.304196,-0.00434562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0868443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127854,5.40904e-06) , 
0, 0.0264848, 1, 0, 0.100539,0.0159607) , 
3, 0.702073, 1, 0, 0.247106,0.0013467)    );
  // itree = 1227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0854372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0700935,0.0328479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305539,0.00229158) , 
1, -0.889814, 1, 0, 0.278406,-0.00253963) , 
0, -1.23109, 1, 0, 0.253183,0.00177405)    );
  // itree = 1228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296233,0.0106813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139073,-0.033084) , 
0, 0.823167, 1, 0, 0.263946,0.00170003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204373,-0.0248365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360825,0.0133406) , 
0, 1.23754, 1, 0, 0.228732,-0.0163123) , 
1, -0.0227523, 1, 0, 0.241797,-0.00962928)    );
  // itree = 1229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522124,0.0144646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229917,-0.00362536) , 
3, -0.357995, 1, 0, 0.408207,0.00989351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201646,0.0175263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0752475,-0.0206314) , 
2, 0.569817, 1, 0, 0.137235,-0.0161604) , 
1, 0.29434, 1, 0, 0.268127,-0.00357517)    );
  // itree = 1230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0859375,-0.0493326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400818,0.0128999) , 
2, -1.49125, 1, 0, 0.335494,0.00674773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158451,-0.0242215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246835,0.0146612) , 
0, -0.43055, 1, 0, 0.228777,-0.0151993) , 
3, -0.759517, 1, 0, 0.261584,-0.00845224)    );
  // itree = 1231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255682,-0.00836747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268008,0.00105395) , 
2, 0.0167879, 1, 0, 0.262061,0.00121124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,-0.0263724) , 
3, 1.74459, 1, 0, 0.251527,0.0039832)    );
  // itree = 1232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0491453,-0.0163279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326656,0.0150544) , 
3, -0.969901, 1, 0, 0.253114,0.0106503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259843,-0.0567067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36,0.000474864) , 
1, 1.40271, 1, 0, 0.303965,-0.0284876) , 
2, 1.51846, 1, 0, 0.258906,0.00619256)    );
  // itree = 1233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298592,-0.00637828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963597,-0.00408838) , 
3, 0.703459, 1, 0, 0.248543,-0.0104777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165605,0.0351817) , 
1, 1.56373, 1, 0, 0.242172,-0.00664076)    );
  // itree = 1234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246945,0.00415966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411184,-0.000219588) , 
2, 1.08237, 1, 0, 0.273803,-0.0153921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654762,-0.0302543) , 
3, 1.74551, 1, 0, 0.256537,-0.0087786)    );
  // itree = 1235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0579151,-0.0233529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237952,-0.00744922) , 
3, -1.17374, 1, 0, 0.159052,0.0156159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328654,0.00653281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234513,0.00302528) , 
2, 1.50094, 1, 0, 0.313848,-0.0113403) , 
0, -0.525822, 1, 0, 0.268738,-0.00348472)    );
  // itree = 1236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146468,-0.0176308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50308,0.00747375) , 
3, 0.660906, 1, 0, 0.241266,-0.00730619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390476,-0.0479762) , 
0, 1.55221, 1, 0, 0.249355,-0.012038)    );
  // itree = 1237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612903,0.00406752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39172,-0.0124129) , 
3, -1.4376, 1, 0, 0.474,0.0304484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226891,-0.000461103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106572,-0.00448559) , 
3, 0.604952, 1, 0, 0.182178,-0.00271869) , 
1, -0.426085, 1, 0, 0.254591,0.00551136)    );
  // itree = 1238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26373,-0.00021344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1875,0.0332442) , 
0, 1.20668, 1, 0, 0.258529,0.00343689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107784,-0.0277263) , 
0, 1.44542, 1, 0, 0.246207,0.00671211)    );
  // itree = 1239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0139535,-0.0462985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420561,0.01115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22215,-0.00638459) , 
2, -0.776353, 1, 0, 0.2563,0.000453668) , 
1, -1.07868, 1, 0, 0.23125,0.00497205)    );
  // itree = 1240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0191781,-0.0545862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341362,0.0139918) , 
3, -1.21451, 1, 0, 0.266412,0.00568287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0954198,-0.0399863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323308,0.00335314) , 
2, 1.54101, 1, 0, 0.172152,-0.0225325) , 
1, 1.35324, 1, 0, 0.247454,8.19302e-06)    );
  // itree = 1241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282572,0.00415293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276339,0.0033185) , 
0, 0.369698, 1, 0, 0.280522,-0.00159178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.025641,-0.029325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100917,-0.0189483) , 
0, 1.21527, 1, 0, 0.0619469,0.04409) , 
3, 1.45397, 1, 0, 0.255662,0.00360403)    );
  // itree = 1242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284141,0.00636769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282792,-0.000916589) , 
1, 0.349497, 1, 0, 0.283496,0.00246045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,-0.00942711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177966,0.0315691) , 
0, 1.17362, 1, 0, 0.104317,-0.0635475) , 
3, 1.29973, 1, 0, 0.2588,-0.00663732)    );
  // itree = 1243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.100017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.038835,-0.0383622) , 
1, -1.52313, 1, 0, 0.0194175,0.0347668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118367,0.0207996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306632,0.0013872) , 
0, -0.900816, 1, 0, 0.280543,-0.00551173) , 
1, -1.06103, 1, 0, 0.253293,-0.0013084)    );
  // itree = 1244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138593,-0.0160493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588235,0.0192228) , 
3, 0.208261, 1, 0, 0.278797,0.000208634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0379747,-0.0587038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267568,-0.000621322) , 
2, 0.601047, 1, 0, 0.161808,-0.0172734) , 
1, 0.939437, 1, 0, 0.239629,-0.00564431)    );
  // itree = 1245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404537,0.0010635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209322,0.00161981) , 
3, -0.921426, 1, 0, 0.269748,0.00459145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183544,-0.00948488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152778,0.0146814) , 
3, 1.10126, 1, 0, 0.168874,-0.0445312) , 
0, 1.23761, 1, 0, 0.2546,-0.0027855)    );
  // itree = 1246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252185,-0.00426295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24504,-0.00771075) , 
1, 0.204761, 1, 0, 0.248203,-0.00171833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15,0.0337245) , 
3, 1.76176, 1, 0, 0.241149,-0.00676048)    );
  // itree = 1247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244134,-0.00504527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34375,0.031029) , 
2, 1.00867, 1, 0, 0.260938,-0.000210917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184874,0.00797141) , 
2, 1.77577, 1, 0, 0.256448,-0.0039276)    );
  // itree = 1248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237037,0.0411182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186293,-0.0180082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63964,0.0154339) , 
3, 1.49665, 1, 0, 0.241379,-0.0102272) , 
0, -1.43147, 1, 0, 0.241081,-0.00613261)    );
  // itree = 1249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379349,0.000945692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0927022,-0.0140657) , 
3, 0.037542, 1, 0, 0.275393,0.0106856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205882,-0.00253472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147239,0.0361334) , 
1, 1.16856, 1, 0, 0.190083,-0.0187584) , 
0, 0.6269, 1, 0, 0.249626,0.00179214)    );
  // itree = 1250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536,0.0495518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0131579,-0.0745689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270654,0.00499059) , 
2, -1.09708, 1, 0, 0.238919,-0.00489194) , 
3, -2.02293, 1, 0, 0.257722,-0.00759828)    );
  // itree = 1251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273349,0.0353941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302842,-0.00151282) , 
1, -0.390081, 1, 0, 0.225559,-0.00489559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479167,-0.00545833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345833,-0.00594413) , 
1, -0.0257289, 1, 0, 0.383929,0.0293811) , 
0, 1.09727, 1, 0, 0.253551,0.00116277)    );
  // itree = 1252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0876847,-0.0215559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324433,0.00790829) , 
3, -0.145945, 1, 0, 0.188209,-0.00353088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469388,-0.000704518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.877193,0.0459062) , 
3, 1.89165, 1, 0, 0.619355,0.0316296) , 
3, 1.30934, 1, 0, 0.252652,0.00172455)    );
  // itree = 1253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356164,-0.00375821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121127,-0.00687716) , 
1, 0.550472, 1, 0, 0.263712,0.00117683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629921,-0.0128073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,0.00468392) , 
1, 1.21433, 1, 0, 0.0733591,-0.0496759) , 
3, 1.36188, 1, 0, 0.239826,-0.0052044)    );
  // itree = 1254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32674,0.0100096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.025641,-0.0278549) , 
3, 1.04537, 1, 0, 0.289103,0.00374432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182353,-0.00937343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12844,0.00221685) , 
3, 1.67958, 1, 0, 0.169265,-0.0316368) , 
0, 0.900791, 1, 0, 0.26232,-0.00416317)    );
  // itree = 1255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0575163,-0.0255706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15873,-0.00907341) , 
3, 0.535414, 1, 0, 0.0718294,0.0157489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435798,-0.00238871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267062,0.00503243) , 
2, 1.19404, 1, 0, 0.384477,-0.0120809) , 
1, 0.227361, 1, 0, 0.245123,0.00032348)    );
  // itree = 1256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0880421,-0.00486054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429515,0.0151901) , 
3, -0.382409, 1, 0, 0.273817,0.00987035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153153,0.0108579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230392,-0.0319714) , 
0, -0.118825, 1, 0, 0.203175,-0.0228553) , 
1, 1.4386, 1, 0, 0.262601,0.00467449)    );
  // itree = 1257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493554,0.00363829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197889,-0.0127558) , 
3, -0.336181, 1, 0, 0.372017,0.0263491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157527,0.00568256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0432099,-0.0255575) , 
3, 1.71053, 1, 0, 0.141631,-0.014412) , 
1, 0.21309, 1, 0, 0.243412,0.00359558)    );
  // itree = 1258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241518,-0.0101453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00653595,-0.0692241) , 
3, 1.56282, 1, 0, 0.222516,-0.00275972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,0.0222352) , 
1, 1.68939, 1, 0, 0.231848,-0.00497471)    );
  // itree = 1259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13416,-0.0278298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253119,-0.0142898) , 
3, 0.0377678, 1, 0, 0.180249,0.01165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488372,-0.00433261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145833,-0.0158742) , 
3, 1.44946, 1, 0, 0.387295,-0.0143641) , 
0, 0.83144, 1, 0, 0.232438,0.00509274)    );
  // itree = 1260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826446,0.0399571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533333,0.0482548) , 
3, -1.61775, 1, 0, 0.292035,0.0566625) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1125,-0.076864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25641,-0.00591813) , 
1, -1.06103, 1, 0, 0.243604,-0.0130682) , 
0, -1.14631, 1, 0, 0.249012,-0.00528204)    );
  // itree = 1261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330758,0.00921659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0681818,-0.00500276) , 
3, 1.22291, 1, 0, 0.301875,-0.0102584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714286,-0.0147142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.059322,-0.0187594) , 
3, 1.54307, 1, 0, 0.0682819,0.0149602) , 
1, 1.29547, 1, 0, 0.250243,-0.00468427)    );
  // itree = 1262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382199,-0.00944482) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239782,0.00398027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241769,0.00751119) , 
1, 0.22651, 1, 0, 0.240957,-0.00234378) , 
0, -1.20662, 1, 0, 0.254527,0.0022253)    );
  // itree = 1263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218248,-0.00673514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537143,0.04262) , 
3, 1.11321, 1, 0, 0.254369,-0.00251153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343931,0.012844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0431034,-0.0154918) , 
3, 1.73915, 1, 0, 0.268398,0.0253544) , 
2, 0.990341, 1, 0, 0.257598,0.00390304)    );
  // itree = 1264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22741,0.0148063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192147,-0.0114003) , 
0, -0.419091, 1, 0, 0.204729,-0.0021525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738562,0.0351504) , 
3, 1.73078, 1, 0, 0.245283,0.00332397)    );
  // itree = 1265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418079,-0.0284348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237762,0.00139539) , 
1, -0.406433, 1, 0, 0.3375,0.042753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299522,-0.0050566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128843,0.00516474) , 
3, 0.403939, 1, 0, 0.23206,0.00384516) , 
0, -0.940853, 1, 0, 0.248535,0.00992451)    );
  // itree = 1266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325974,0.00528381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265101,0.00457903) , 
0, -0.259717, 1, 0, 0.293269,0.0084075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0797946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128889,-0.00384215) , 
2, 0.637969, 1, 0, 0.0863095,-0.0400853) , 
3, 1.14622, 1, 0, 0.2585,0.000260713)    );
  // itree = 1267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134206,-0.0177103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294224,0.00651028) , 
0, -0.456532, 1, 0, 0.237347,-0.00887351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496124,0.0363547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.056338,-0.0173288) , 
2, 1.21031, 1, 0, 0.265683,0.0233429) , 
3, 1.28501, 1, 0, 0.241206,-0.00448624)    );
  // itree = 1268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196262,0.0645218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263158,0.0125025) , 
1, -1.37869, 1, 0, 0.257237,0.0164144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201754,-0.0577449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.000421526) , 
1, -0.542515, 1, 0, 0.243276,-0.00986813) , 
0, 0.297203, 1, 0, 0.251603,0.00580805)    );
  // itree = 1269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672131,-5.22075e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261868,0.010051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143898,-0.0161635) , 
0, 0.709543, 1, 0, 0.226954,-0.011104) , 
1, -1.33599, 1, 0, 0.254426,-0.00747102)    );
  // itree = 1270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267541,-0.00111631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485437,-0.0123996) , 
3, 1.43289, 1, 0, 0.255388,-0.00736437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0479452,-0.0509798) , 
3, 1.74551, 1, 0, 0.24026,-0.00356119)    );
  // itree = 1271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0367347,-0.0342433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,0.0140908) , 
2, -0.879464, 1, 0, 0.0702028,-0.0258303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31773,0.00484026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31631,-0.0145659) , 
0, 0.353094, 1, 0, 0.317073,0.00641574) , 
1, -0.128677, 1, 0, 0.236047,-0.00416783)    );
  // itree = 1272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216724,-0.00157725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507812,-0.041552) , 
3, 1.57254, 1, 0, 0.236479,-0.00652936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42029,0.0278444) , 
1, 1.56373, 1, 0, 0.249012,-0.00313921)    );
  // itree = 1273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.689076,0.0300304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389937,-0.0236814) , 
1, -1.42315, 1, 0, 0.517986,0.0288744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509259,0.0531488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189781,-0.00116038) , 
1, -0.669552, 1, 0, 0.209475,-0.00542856) , 
1, -0.887572, 1, 0, 0.251724,-0.000730912)    );
  // itree = 1274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361874,0.00105445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202322,-0.00250967) , 
3, -0.730586, 1, 0, 0.256438,0.000682486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221429,0.0270835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,0.00894214) , 
3, 1.07632, 1, 0, 0.187279,-0.0301393) , 
0, 1.26376, 1, 0, 0.247154,-0.00345535)    );
  // itree = 1275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326923,-0.0114912) , 
1, 0.101415, 1, 0, 0.140264,0.0263761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488636,0.00958669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231441,-0.00756308) , 
2, -0.621136, 1, 0, 0.279631,-0.00838846) , 
0, -0.523167, 1, 0, 0.237717,0.00206679)    );
  // itree = 1276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196262,0.0130344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0642857,-0.0475575) , 
0, 0.746881, 1, 0, 0.175478,0.00467293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263374,-0.0462424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374083,0.0220774) , 
0, 0.761402, 1, 0, 0.303163,-0.0213619) , 
2, -0.0414875, 1, 0, 0.247163,-0.00994358)    );
  // itree = 1277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291578,0.00153612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226829,0.00784113) , 
0, 0.759116, 1, 0, 0.277016,-0.00287873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962963,0.0557599) , 
3, 1.76021, 1, 0, 0.264556,-0.00965431)    );
  // itree = 1278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252994,-0.000612693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299263,-0.00174715) , 
1, -0.119724, 1, 0, 0.281642,-0.0031561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0232558,-0.0166425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102362,-0.00730131) , 
1, 1.29413, 1, 0, 0.0625,0.0299821) , 
3, 1.36188, 1, 0, 0.253731,0.00106449)    );
  // itree = 1279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164535,-0.00867289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404612,-0.00168373) , 
0, 0.508035, 1, 0, 0.233939,-0.00437248) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352273,0.0326603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168224,0.0117823) , 
0, 1.27083, 1, 0, 0.299191,-0.029714) , 
2, 1.12881, 1, 0, 0.245918,-0.00902449)    );
  // itree = 1280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251588,0.00862211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204831,-0.0159167) , 
1, 0.0611893, 1, 0, 0.225027,-0.00380578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38255,0.0353341) , 
1, 1.56373, 1, 0, 0.236936,0.000532701)    );
  // itree = 1281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582781,-0.0167041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279661,-0.0302359) , 
3, -1.20171, 1, 0, 0.449814,0.0446057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22383,-9.65911e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15,-0.0069545) , 
0, 0.678037, 1, 0, 0.20118,-0.00473724) , 
1, -0.889814, 1, 0, 0.235234,0.00202104)    );
  // itree = 1282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00453266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29559,0.00797334) , 
0, -0.351367, 1, 0, 0.31225,0.00199169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0601093,-0.0318269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171717,0.0239351) , 
0, 1.16767, 1, 0, 0.0992908,0.0219367) , 
3, 0.802707, 1, 0, 0.254114,0.00743649)    );
  // itree = 1283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184086,-0.0131853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271375,-0.021947) , 
3, 1.0075, 1, 0, 0.197489,0.00299648) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.75,0.0405812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170543,-0.00868015) , 
3, 1.15758, 1, 0, 0.429185,-0.0515294) , 
0, 1.32355, 1, 0, 0.224685,-0.00340378)    );
  // itree = 1284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24077,0.0146569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196721,-0.0151208) , 
0, -0.428611, 1, 0, 0.211612,-0.00461203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797101,0.0295919) , 
3, 1.76176, 1, 0, 0.252398,-0.000380954)    );
  // itree = 1285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300444,-0.000498595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230072,-0.00268915) , 
0, 0.306857, 1, 0, 0.277281,-0.000956615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119658,0.00479205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0783133,0.00798779) , 
3, 1.65173, 1, 0, 0.0954064,0.0384853) , 
3, 1.29328, 1, 0, 0.25102,0.00473831)    );
  // itree = 1286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24478,-0.00762941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0229008,-0.0197237) , 
3, 1.63849, 1, 0, 0.229111,-0.00749896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392157,0.0221192) , 
1, 1.62191, 1, 0, 0.237609,-0.0047921)    );
  // itree = 1287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255742,0.00166839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254717,-0.010456) , 
2, 1.62002, 1, 0, 0.255679,-0.00197668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530612,0.0796924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0283019,-0.0426841) , 
2, 1.23077, 1, 0, 0.269608,-0.0734856) , 
3, 1.55602, 1, 0, 0.257158,-0.00957055)    );
  // itree = 1288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13601,-0.00805361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112069,-0.0761259) , 
3, 0.554173, 1, 0, 0.132883,-0.0155232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3322,0.0188004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284314,-0.0173534) , 
1, 1.50194, 1, 0, 0.323204,0.0116324) , 
2, -0.010647, 1, 0, 0.237589,-0.000583504)    );
  // itree = 1289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386728,-0.00379863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286905,0.00107097) , 
3, -1.09076, 1, 0, 0.321065,-0.0105408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970149,-0.00703578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157143,0.0145879) , 
0, 1.20752, 1, 0, 0.113941,0.0235064) , 
3, 0.414913, 1, 0, 0.244686,0.00201444)    );
  // itree = 1290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276376,-0.000277834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0145985,-0.0485708) , 
3, 1.51559, 1, 0, 0.25731,0.00668607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177885,0.0134174) , 
0, 1.3861, 1, 0, 0.249402,0.000116727)    );
  // itree = 1291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25635,0.00406706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376,0.0273089) , 
3, 1.61197, 1, 0, 0.264576,0.00378359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242268,-0.0275841) , 
1, 1.52467, 1, 0, 0.262425,0.00772339)    );
  // itree = 1292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164384,0.0143743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254936,-0.0188877) , 
2, -0.656037, 1, 0, 0.230193,-0.0100469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0143569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727273,0.0367372) , 
3, 1.46622, 1, 0, 0.313953,0.0223862) , 
0, 0.956597, 1, 0, 0.247909,-0.00318694)    );
  // itree = 1293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378194,0.0167819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0480769,-0.0191398) , 
3, 0.299875, 1, 0, 0.328509,-0.0241017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461078,0.0161454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168248,-0.0110806) , 
1, -0.74297, 1, 0, 0.205128,0.00567618) , 
0, -0.402053, 1, 0, 0.247397,-0.00452535)    );
  // itree = 1294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27581,0.00465868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163606,-0.0116039) , 
1, 0.891167, 1, 0, 0.240914,-0.000319215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492754,0.0445778) , 
1, 1.62191, 1, 0, 0.257752,-0.002859)    );
  // itree = 1295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0517241,0.0206091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306899,0.00572473) , 
0, -0.96589, 1, 0, 0.266703,-0.00485104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163636,0.0212152) , 
3, 1.76176, 1, 0, 0.258225,-0.00905043)    );
  // itree = 1296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189076,0.017536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0571429,-0.0294598) , 
1, -0.784061, 1, 0, 0.0906183,-0.00703148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554054,0.0450077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397993,0.00534452) , 
0, -0.394689, 1, 0, 0.420096,0.0161035) , 
3, -0.112181, 1, 0, 0.264246,0.00516015)    );
  // itree = 1297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402357,-0.00747368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199441,-0.00454054) , 
3, -0.760544, 1, 0, 0.271746,-0.000337124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159533,-0.0132405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152174,0.0327114) , 
2, 1.19404, 1, 0, 0.156962,-0.0351253) , 
0, 1.00007, 1, 0, 0.249758,-0.00700121)    );
  // itree = 1298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211009,-0.0127354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179262,-0.00418523) , 
1, -0.179087, 1, 0, 0.194794,0.0163512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284483,-0.0097385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335948,0.0104203) , 
2, 0.543892, 1, 0, 0.329171,-0.00949521) , 
2, 0.342305, 1, 0, 0.254135,0.0049373)    );
  // itree = 1299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232949,0.0074153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31813,-0.00544054) , 
3, -0.117751, 1, 0, 0.27377,0.0127823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178862,0.0342199) , 
3, 1.76176, 1, 0, 0.267793,0.00793168)    );
  // itree = 1300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038961,-0.0274129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304786,0.0103256) , 
3, -0.74018, 1, 0, 0.214167,0.00344496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611842,-0.0471203) , 
3, 1.76176, 1, 0, 0.245023,-0.00356852)    );
  // itree = 1301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576577,-0.00590584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331839,-0.0393939) , 
3, -1.55685, 1, 0, 0.413174,0.0324452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257954,0.00417675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108456,0.00104187) , 
3, 0.668253, 1, 0, 0.21031,-0.00381751) , 
1, -0.752382, 1, 0, 0.243508,0.0021167)    );
  // itree = 1302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37069,-0.0183346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319913,0.000543519) , 
0, -1.57261, 1, 0, 0.325604,-0.00516213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16129,-0.0100145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140845,-0.00724619) , 
0, 1.0772, 1, 0, 0.155642,0.0147874) , 
3, -0.112181, 1, 0, 0.240911,0.00477879)    );
  // itree = 1303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210944,-0.00792994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,-0.00544072) , 
3, 0.409676, 1, 0, 0.241263,0.00479008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431034,0.0803542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,-0.0293246) , 
1, 1.40652, 1, 0, 0.287611,-0.0392506) , 
2, 1.53606, 1, 0, 0.2465,-0.000186517)    );
  // itree = 1304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116981,-0.0093801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498127,0.0207287) , 
3, 0.173431, 1, 0, 0.244668,0.00577471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186335,-0.0335483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461538,0.00962409) , 
2, 1.49723, 1, 0, 0.259681,-0.0205334) , 
0, 0.956597, 1, 0, 0.247909,9.38179e-05)    );
  // itree = 1305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483636,-0.00710867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0363636,-0.0510866) , 
1, 0.144952, 1, 0, 0.355844,-0.0146311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157556,-0.0225254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228352,0.0044827) , 
0, -0.524784, 1, 0, 0.214728,0.0127582) , 
3, -1.19799, 1, 0, 0.241879,0.00748842)    );
  // itree = 1306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0124977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345711,0.00230243) , 
1, -1.38228, 1, 0, 0.325028,-0.00960648) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0726496,-0.0116899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21547,0.0114553) , 
1, -0.0645568, 1, 0, 0.186128,0.00820613) , 
3, -0.364179, 1, 0, 0.246785,0.000427432)    );
  // itree = 1307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0890052,-0.0523986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293201,0.00300071) , 
0, -0.778048, 1, 0, 0.249721,-0.00870926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240385,-0.00662331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234783,-0.00649329) , 
1, 1.25828, 1, 0, 0.237443,0.0321408) , 
3, 1.55602, 1, 0, 0.248385,-0.00426506)    );
  // itree = 1308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238806,0.0213993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181373,-0.0194901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304591,0.00259218) , 
2, 0.312141, 1, 0, 0.238892,-0.00831167) , 
1, -1.39599, 1, 0, 0.238886,-0.00626106)    );
  // itree = 1309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334862,0.00250433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125616,-0.00672709) , 
3, 0.412354, 1, 0, 0.285298,-0.000427259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764331,0.0233363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962963,-0.0108645) , 
0, 1.12383, 1, 0, 0.0856164,-0.0513537) , 
3, 1.29216, 1, 0, 0.256231,-0.00784028)    );
  // itree = 1310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487179,0.0410875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258176,-0.0032883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0582011,-0.0184542) , 
3, 1.68077, 1, 0, 0.238613,0.00364707) , 
3, -2.02293, 1, 0, 0.252806,0.00155741)    );
  // itree = 1311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204511,-0.000279666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268657,-0.00875621) , 
0, 0.509749, 1, 0, 0.212933,-0.00163411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509485,0.0409371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149533,-0.036262) , 
0, 1.56628, 1, 0, 0.428571,-0.0207798) , 
0, 0.883261, 1, 0, 0.264076,-0.00617489)    );
  // itree = 1312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233796,0.00190049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295826,-0.0181832) , 
2, 0.646639, 1, 0, 0.252301,-0.00444816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319444,0.0359654) , 
1, 1.50236, 1, 0, 0.259331,0.000858676)    );
  // itree = 1313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285809,-0.00349269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123288,0.00714987) , 
3, 0.801917, 1, 0, 0.254255,0.00168952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0384615,-0.0332651) , 
3, 1.74459, 1, 0, 0.237721,0.00561329)    );
  // itree = 1314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0680628,-0.0430577) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344444,0.00833027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0809061,-0.0318717) , 
3, 0.55157, 1, 0, 0.257721,0.000937752) , 
2, -1.4149, 1, 0, 0.240213,0.00482277)    );
  // itree = 1315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0758741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279621,0.0397808) , 
1, -1.41565, 1, 0, 0.223909,-0.019507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227787,-0.0179945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316832,0.00278775) , 
1, 1.47221, 1, 0, 0.240278,0.0109497) , 
3, -1.04915, 1, 0, 0.235892,0.00278974)    );
  // itree = 1316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245283,0.0265216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188327,-0.0145704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65534,0.0130766) , 
3, 1.47037, 1, 0, 0.239829,-0.00852321) , 
0, -1.35128, 1, 0, 0.240257,-0.00557324)    );
  // itree = 1317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28125,-0.00314903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0176322) , 
2, 1.45386, 1, 0, 0.260664,5.72735e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0803571,-0.0277231) , 
1, 1.68641, 1, 0, 0.250622,0.00529034)    );
  // itree = 1318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305158,5.72843e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208178,-0.000741004) , 
0, -0.293879, 1, 0, 0.246336,0.000861175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345361,0.00816083) , 
1, 1.5317, 1, 0, 0.256098,-0.00400853)    );
  // itree = 1319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0142857,0.0531043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274019,-0.00330766) , 
1, -1.32583, 1, 0, 0.254871,0.000766194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128049,-0.0235005) , 
3, 1.71142, 1, 0, 0.244789,0.00418878)    );
  // itree = 1320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221728,-0.00262055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386973,0.0227905) , 
2, 0.952577, 1, 0, 0.245232,0.00160511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,-0.0114239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396226,-0.0471329) , 
0, 0.962014, 1, 0, 0.331897,-0.0407027) , 
2, 1.53606, 1, 0, 0.254959,-0.00314352)    );
  // itree = 1321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458333,-0.00830132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302326,-0.0175643) , 
3, -1.16784, 1, 0, 0.352809,0.0336486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15567,0.00590402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143885,0.018928) , 
0, 1.32961, 1, 0, 0.154193,-0.0101519) , 
1, 0.162984, 1, 0, 0.242621,0.00934907)    );
  // itree = 1322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303641,0.00145173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0661157,-0.0302199) , 
3, 1.01857, 1, 0, 0.271348,0.00457894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121429,0.0422667) , 
3, 1.73786, 1, 0, 0.260417,-0.00116973)    );
  // itree = 1323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185407,-0.00811349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340426,0.0052776) , 
3, -0.193194, 1, 0, 0.247857,0.00828336) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207944,-0.00414504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235808,0.00912111) , 
0, 1.06748, 1, 0, 0.217656,-0.0178067) , 
2, 0.648293, 1, 0, 0.238211,-4.97353e-05)    );
  // itree = 1324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109938,-0.0123494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436893,0.00862276) , 
3, 0.15442, 1, 0, 0.236814,-0.000231415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477064,0.030158) , 
1, 1.65151, 1, 0, 0.250127,0.00282368)    );
  // itree = 1325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338235,-0.0314955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387097,0.00637298) , 
0, -1.05806, 1, 0, 0.368272,-0.020418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260151,0.0067107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0601504,-0.0170686) , 
3, 1.39328, 1, 0, 0.229203,0.00687051) , 
3, -1.30768, 1, 0, 0.252896,0.00222146)    );
  // itree = 1326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25447,-0.00157398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475728,0.0320541) , 
1, 1.56373, 1, 0, 0.267266,-0.007917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0362319,-0.0504458) , 
3, 1.76021, 1, 0, 0.250651,-0.00420256)    );
  // itree = 1327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0771354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0192308,0.00388969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261877,0.00155142) , 
1, -1.19679, 1, 0, 0.241764,-0.00409725) , 
0, -1.61174, 1, 0, 0.22807,-0.00714299)    );
  // itree = 1328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210753,0.0150688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301913,-0.00892926) , 
2, 0.129425, 1, 0, 0.250903,0.00404294) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0511628,-0.055389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35461,-0.000410483) , 
2, 1.19475, 1, 0, 0.171348,-0.0273525) , 
1, 1.35324, 1, 0, 0.236868,-0.00149561)    );
  // itree = 1329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276596,-0.00118127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128889,0.0334588) , 
3, 1.13379, 1, 0, 0.257883,-0.000855449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0318471,-0.0389711) , 
3, 1.76176, 1, 0, 0.239524,0.00249003)    );
  // itree = 1330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364993,-0.00375509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153729,-0.0207918) , 
3, -0.449219, 1, 0, 0.265423,0.0134947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190987,0.00927972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119266,0.0408052) , 
3, 1.67974, 1, 0, 0.177391,-0.0149936) , 
0, 0.624761, 1, 0, 0.239716,0.00517535)    );
  // itree = 1331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0786125) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,0.0537133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342927,0.00811862) , 
1, -0.755589, 1, 0, 0.307371,-0.00284993) , 
0, -1.4036, 1, 0, 0.286689,-2.9954e-05)    );
  // itree = 1332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1985,-0.00325404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434783,-0.0238261) , 
3, 1.3281, 1, 0, 0.213203,-0.00575154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.691589,0.0193741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711538,0.0300029) , 
1, 1.35259, 1, 0, 0.701422,0.0483943) , 
3, 1.64135, 1, 0, 0.263235,-0.000202843)    );
  // itree = 1333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2968,-0.00671254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.082232,-0.0270429) , 
3, 0.400621, 1, 0, 0.221129,0.00963118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196078,0.052593) , 
1, 1.82294, 1, 0, 0.219872,0.00619042)    );
  // itree = 1334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486726,0.00556768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182459,-0.0117314) , 
3, -1.95182, 1, 0, 0.207194,0.0141888) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394558,-0.012441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104712,-0.00427083) , 
3, 1.35562, 1, 0, 0.306962,-0.0195107) , 
2, 0.70054, 1, 0, 0.238378,0.00365564)    );
  // itree = 1335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0151515,0.00778246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0972222,0.0885531) , 
2, -1.02913, 1, 0, 0.057971,-0.0317644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0663507,-0.0510181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31809,0.00475185) , 
1, -0.503767, 1, 0, 0.286808,0.00687749) , 
1, -0.951508, 1, 0, 0.254813,0.00147467)    );
  // itree = 1336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198556,0.0159512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205224,-0.0525449) , 
0, -0.873089, 1, 0, 0.0811808,-0.00620163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339362,0.00483886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667969,0.023043) , 
3, 1.44931, 1, 0, 0.409699,0.0141968) , 
3, -0.351275, 1, 0, 0.276755,0.00594196)    );
  // itree = 1337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311575,0.00327309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112245,-0.00684612) , 
3, 0.8536, 1, 0, 0.278652,0.00441716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,0.0357563) , 
3, 1.64499, 1, 0, 0.262051,0.000540827)    );
  // itree = 1338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401264,0.0223873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184384,-0.000129401) , 
3, -0.620356, 1, 0, 0.26533,0.00978263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554745,0.020182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18,0.0160669) , 
3, 1.42925, 1, 0, 0.396624,-0.041278) , 
2, 1.51846, 1, 0, 0.281428,0.00352222)    );
  // itree = 1339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170049,-0.0104464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40107,0.00574928) , 
0, 0.557732, 1, 0, 0.235176,-0.00287437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12037,-0.0440302) , 
0, 1.55221, 1, 0, 0.229266,-0.00714824)    );
  // itree = 1340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213777,0.0242965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507937,-0.0237687) , 
3, 0.875316, 1, 0, 0.252066,0.0135095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0732984,-0.0684734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328947,-0.012328) , 
2, 0.26257, 1, 0, 0.243433,-0.0294172) , 
0, 0.696888, 1, 0, 0.249629,0.00139323)    );
  // itree = 1341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401961,0.0104608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250142,-0.00553758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.06875,0.00925697) , 
3, 1.8016, 1, 0, 0.235018,0.00131099) , 
0, -1.7049, 1, 0, 0.243444,0.00515835)    );
  // itree = 1342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404255,0.00478503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24505,-0.0014575) , 
3, -1.18853, 1, 0, 0.282746,0.0042559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190283,0.00602438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151961,0.0176062) , 
3, 1.14123, 1, 0, 0.172949,-0.0356876) , 
0, 0.944261, 1, 0, 0.25846,-0.00457907)    );
  // itree = 1343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222445,-0.00188148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30485,-0.0129759) , 
3, 0.821581, 1, 0, 0.240933,0.00798199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.042735,-0.0705044) , 
1, 1.65151, 1, 0, 0.229604,0.00438079)    );
  // itree = 1344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162471,-0.00903399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483108,0.0243787) , 
3, 0.772676, 1, 0, 0.221531,0.00189776) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.00568624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39548,-0.042655) , 
0, 1.03569, 1, 0, 0.339578,-0.0294442) , 
2, 1.10251, 1, 0, 0.246313,-0.00468189)    );
  // itree = 1345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337662,-0.00849904) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254709,0.00595775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184834,-0.000411475) , 
0, 0.627225, 1, 0, 0.230852,0.000576542) , 
0, -1.35128, 1, 0, 0.239044,0.00457094)    );
  // itree = 1346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28513,-0.0157428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252577,0.00483454) , 
0, -0.300762, 1, 0, 0.266588,0.000984921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00961538,-0.0730412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137143,0.00385568) , 
0, 1.0312, 1, 0, 0.0896057,0.0365497) , 
3, 1.30934, 1, 0, 0.241675,0.00599127)    );
  // itree = 1347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107544,-0.023416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542056,0.0773914) , 
3, 0.287606, 1, 0, 0.171233,-0.0207624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308411,0.00232399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0852713,-0.0342782) , 
3, 1.77277, 1, 0, 0.286371,0.00639763) , 
0, -0.362191, 1, 0, 0.245088,-0.0033405)    );
  // itree = 1348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0694444,2.49958e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330537,-0.0241424) , 
3, -0.997712, 1, 0, 0.232218,-0.0186596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11054,-0.0201296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553846,0.0263989) , 
3, 1.07612, 1, 0, 0.24116,0.00461123) , 
1, 0.29434, 1, 0, 0.237008,-0.00619347)    );
  // itree = 1349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54,0.0159119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27506,-0.0081629) , 
3, -2.05591, 1, 0, 0.294729,-0.00536515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,-0.0107147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,0.0433183) , 
0, 1.42821, 1, 0, 0.121495,0.0216547) , 
3, 0.436997, 1, 0, 0.238813,0.0033562)    );
  // itree = 1350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200542,-0.0140005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515275,0.0143349) , 
2, 0.0436109, 1, 0, 0.326282,-0.00665898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15087,-0.0174702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0613718,-0.0182586) , 
3, 1.39177, 1, 0, 0.119647,0.0165762) , 
3, 0.297184, 1, 0, 0.24518,0.00246051)    );
  // itree = 1351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0770529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262953,0.00216108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261324,0.00601764) , 
2, 1.34771, 1, 0, 0.262698,-0.00560555) , 
0, -1.7049, 1, 0, 0.248322,-0.0014686)    );
  // itree = 1352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.025139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244836,0.00224965) , 
1, -1.13141, 1, 0, 0.245455,0.00522919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377193,-0.0393369) , 
0, 1.55221, 1, 0, 0.253024,0.00135833)    );
  // itree = 1353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321678,-0.00131844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0862069,-0.00379229) , 
2, 1.05473, 1, 0, 0.285714,0.00196645) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0472973,-0.0319593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126582,0.0415096) , 
3, 1.02064, 1, 0, 0.0748899,-0.0307935) , 
1, 1.29547, 1, 0, 0.237202,-0.00557182)    );
  // itree = 1354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276504,-0.00964982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.050885,-0.0208395) , 
3, 0.753782, 1, 0, 0.22132,0.0105575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436364,0.0399736) , 
2, 1.80124, 1, 0, 0.233401,0.00627834)    );
  // itree = 1355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00490196,-0.0369781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378531,0.0403009) , 
0, -1.02756, 1, 0, 0.241935,-0.0162385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238857,-0.00208415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318182,-0.0032241) , 
0, 0.6884, 1, 0, 0.26871,0.00782915) , 
3, -0.873831, 1, 0, 0.261091,0.000980744)    );
  // itree = 1356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215962,0.0461189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329268,-0.00135133) , 
2, -0.674346, 1, 0, 0.265252,0.0275314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193305,-0.0159215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335196,0.00387128) , 
2, 0.559081, 1, 0, 0.255177,-0.00599442) , 
1, -0.66368, 1, 0, 0.257058,0.000265729)    );
  // itree = 1357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.607735,-0.00620006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308824,-0.0262943) , 
3, -1.08158, 1, 0, 0.479495,0.0292668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277123,-0.00160894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142515,0.00775888) , 
3, 0.201336, 1, 0, 0.210339,-0.000508452) , 
1, -0.847297, 1, 0, 0.253,0.00421092)    );
  // itree = 1358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279113,-0.00754307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196305,-0.0135452) , 
0, 0.0616272, 1, 0, 0.2423,-0.00333227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256881,0.0450114) , 
0, 1.55221, 1, 0, 0.243072,-0.000566171)    );
  // itree = 1359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0437956,-0.00419991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118056,-0.014808) , 
3, -1.22827, 1, 0, 0.0941176,0.015368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145455,-0.00682154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443243,0.0113874) , 
1, 0.495325, 1, 0, 0.386026,-0.0120195) , 
1, 0.144707, 1, 0, 0.261654,-0.000350634)    );
  // itree = 1360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201413,-0.00288362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192381,-0.0210905) , 
2, 0.709315, 1, 0, 0.198969,-0.00745207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748092,0.0144195) , 
3, 1.73078, 1, 0, 0.233704,-0.00526828)    );
  // itree = 1361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447489,0.0367148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285512,0.00367421) , 
0, -1.05601, 1, 0, 0.307222,-0.00134383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00763359,-0.0737357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148936,0.0445788) , 
3, 0.491928, 1, 0, 0.0983607,-0.0484011) , 
2, 1.0891, 1, 0, 0.269,-0.00995531)    );
  // itree = 1362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347319,0.00116675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0944444,-0.0167417) , 
3, 0.177006, 1, 0, 0.272578,0.0177102) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180365,0.0143213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261438,0.0135933) , 
1, 0.877544, 1, 0, 0.21371,-0.0158246) , 
0, 0.399075, 1, 0, 0.250255,0.00499362)    );
  // itree = 1363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0626959,0.00234192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.0247752) , 
3, -1.06656, 1, 0, 0.0919786,0.00966348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130435,-0.0274878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480589,0.00323479) , 
1, 0.832532, 1, 0, 0.380497,-0.0111568) , 
1, 0.337264, 1, 0, 0.244321,-0.00132997)    );
  // itree = 1364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106,-0.0027124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318966,0.0582947) , 
3, -0.354416, 1, 0, 0.173497,0.0153115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155039,-0.0467863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315217,-0.00248889) , 
2, 0.0082856, 1, 0, 0.298459,-0.0063882) , 
2, -0.22187, 1, 0, 0.251908,0.00169537)    );
  // itree = 1365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439667,0.0039712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159276,-0.00642289) , 
2, -0.282286, 1, 0, 0.269989,0.00708862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116505,0.00139859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0847458,-0.012683) , 
2, 0.931001, 1, 0, 0.0995475,-0.0503691) , 
1, 1.46286, 1, 0, 0.251588,0.000885326)    );
  // itree = 1366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323256,0.00696122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216359,-0.0138389) , 
1, 1.14086, 1, 0, 0.298981,-0.00203895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00925926,-0.0456553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135135,0.0244909) , 
0, 0.325428, 1, 0, 0.0980926,-0.0404776) , 
3, 1.12905, 1, 0, 0.26277,-0.00896773)    );
  // itree = 1367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0149254,-0.0697062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28246,0.00649404) , 
1, -1.12426, 1, 0, 0.263492,0.000711244) , 
3, -1.98613, 1, 0, 0.249499,-0.00212627)    );
  // itree = 1368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143079,0.00487246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434783,0.0318781) , 
3, 0.559197, 1, 0, 0.191033,0.0106141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502058,-0.0248516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630631,0.0192515) , 
0, 1.40219, 1, 0, 0.542373,-0.0159444) , 
3, 1.12905, 1, 0, 0.256735,0.00564753)    );
  // itree = 1369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349927,-0.00659793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202163,0.00493493) , 
3, -0.701039, 1, 0, 0.255703,-0.00377069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228571,0.0432343) , 
0, 1.55221, 1, 0, 0.254271,-0.00788337)    );
  // itree = 1370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242571,0.00345072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255924,-0.0283697) , 
2, 1.30608, 1, 0, 0.244086,-0.00620943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309735,-0.00890334) , 
2, 1.82177, 1, 0, 0.247846,-0.00243911)    );
  // itree = 1371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0786504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.008,-0.0548143) , 
0, -1.64201, 1, 0, 0.00423729,-0.0220758) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0772532,0.00448032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329122,0.00281861) , 
1, -0.837758, 1, 0, 0.296806,0.00636127) , 
0, -1.11841, 1, 0, 0.263158,0.00309074)    );
  // itree = 1372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0231073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195734,0.0206374) , 
0, -0.792183, 1, 0, 0.186794,0.00433236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293255,-0.0459346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280632,0.000919832) , 
1, 0.753578, 1, 0, 0.285714,-0.0165781) , 
2, 0.30194, 1, 0, 0.228729,-0.00453209)    );
  // itree = 1373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456311,0.00255811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203363,0.00237831) , 
1, -0.391299, 1, 0, 0.277211,-0.00618204) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00826446,-0.0667901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123894,0.00306826) , 
0, 1.25097, 1, 0, 0.0641026,0.0498493) , 
3, 1.45397, 1, 0, 0.252252,0.000380183)    );
  // itree = 1374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392265,-0.0101068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312176,0.000578103) , 
0, -0.788807, 1, 0, 0.337743,-0.00993784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0779322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170765,-0.000745072) , 
2, -0.339484, 1, 0, 0.145518,0.0338405) , 
3, 0.130099, 1, 0, 0.254892,0.00893098)    );
  // itree = 1375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324561,0.0603584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26062,-0.00431596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125828,0.0196817) , 
3, 1.73373, 1, 0, 0.249868,0.00982836) , 
2, -1.63537, 1, 0, 0.254111,0.00719508)    );
  // itree = 1376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264758,0.0196516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187548,-0.000852913) , 
1, -0.359856, 1, 0, 0.210753,0.00602253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6,-0.0345818) , 
3, 1.76176, 1, 0, 0.237093,0.0013518)    );
  // itree = 1377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392857,-0.00528414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256185,-0.000174125) , 
0, -1.68707, 1, 0, 0.264112,-0.00708205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18018,-0.00247113) , 
0, 1.5208, 1, 0, 0.259549,-0.00373036)    );
  // itree = 1378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274819,0.00152437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269697,-0.00125848) , 
1, 1.35667, 1, 0, 0.273906,-0.000282594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0606061,-0.0377988) , 
3, 1.99526, 1, 0, 0.263077,0.00268588)    );
  // itree = 1379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205047,0.000535157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478261,0.0109787) , 
1, 1.43338, 1, 0, 0.245567,-0.00568702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330935,0.00731338) , 
0, 1.47114, 1, 0, 0.2515,-0.00261152)    );
  // itree = 1380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178896,-0.00323143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549849,0.0184793) , 
3, 0.805054, 1, 0, 0.248581,0.00363019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153226,-0.00435024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336364,-0.0542865) , 
2, 0.89244, 1, 0, 0.239316,-0.0476275) , 
0, 1.26376, 1, 0, 0.247495,-0.00237898)    );
  // itree = 1381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398964,-0.00384917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,0.0101593) , 
3, -1.30546, 1, 0, 0.308585,0.0302128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291963,0.00301916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0975104,-0.000499751) , 
3, 0.760649, 1, 0, 0.227986,-0.00565673) , 
0, -0.691888, 1, 0, 0.246308,0.00249715)    );
  // itree = 1382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44697,-0.000541324) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274021,-0.00923277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232198,0.00106928) , 
0, -0.37972, 1, 0, 0.244876,-0.00834435) , 
0, -1.43949, 1, 0, 0.258308,-0.00314097)    );
  // itree = 1383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181586,-0.008736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276923,0.0324589) , 
2, -0.571314, 1, 0, 0.232861,-0.0035226) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309309,-0.00106867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189616,-0.0100126) , 
2, 0.802654, 1, 0, 0.261497,0.0247945) , 
3, -0.322723, 1, 0, 0.249105,0.0125407)    );
  // itree = 1384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170172,0.0230773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216263,-0.015222) , 
2, -0.630979, 1, 0, 0.201906,-0.00272989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544776,0.055447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690909,-0.000551195) , 
3, 1.74872, 1, 0, 0.625418,0.0457171) , 
3, 1.30934, 1, 0, 0.265925,0.00459349)    );
  // itree = 1385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441624,0.0112303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303125,-0.0174274) , 
0, -0.962955, 1, 0, 0.355899,-0.0146128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221493,0.00471221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175097,0.00129801) , 
0, 1.1733, 1, 0, 0.213415,0.0102702) , 
3, -0.976372, 1, 0, 0.250376,0.00381532)    );
  // itree = 1386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188088,-0.0106181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432612,0.0149021) , 
2, 0.128282, 1, 0, 0.282413,0.00270154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0775733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146628,0.00730398) , 
2, 0.355196, 1, 0, 0.102459,0.0294108) , 
3, 0.873167, 1, 0, 0.239492,0.00907208)    );
  // itree = 1387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0309598,-0.00678188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311594,0.0049675) , 
1, -0.610897, 1, 0, 0.222113,-0.000286956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123636,-0.0179256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315436,-0.00908689) , 
1, 0.262706, 1, 0, 0.263725,0.0299922) , 
3, -0.151872, 1, 0, 0.242991,0.0149048)    );
  // itree = 1388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177703,0.000317649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579365,0.0188803) , 
3, 0.947705, 1, 0, 0.236143,0.00482263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512821,-0.0114172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548387,-0.029425) , 
3, 1.42959, 1, 0, 0.271429,-0.0335727) , 
0, 1.2265, 1, 0, 0.241054,-0.000520663)    );
  // itree = 1389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463415,-0.0266255) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363057,-0.00208588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172215,-0.00292259) , 
1, -0.41837, 1, 0, 0.204158,-0.00464596) , 
1, -1.12426, 1, 0, 0.229697,1.81805e-05)    );
  // itree = 1390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134615,-0.00964443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0195057) , 
1, -1.13852, 1, 0, 0.101655,-0.0170917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272879,0.00746094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357616,0.0100932) , 
2, 1.27852, 1, 0, 0.289894,0.011127) , 
2, -0.751916, 1, 0, 0.248573,0.00493267)    );
  // itree = 1391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.076082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,0.0105384) , 
0, -0.527912, 1, 0, 0.0777202,-0.0285864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279212,-0.0114849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365269,0.00633627) , 
0, 1.35858, 1, 0, 0.28798,0.00399154) , 
1, -0.71469, 1, 0, 0.247901,-0.00221837)    );
  // itree = 1392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0767888,-0.00852003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357274,0.0243808) , 
3, -0.675427, 1, 0, 0.213262,0.0114557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350515,-0.0571565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312147,0.00224647) , 
1, 0.247885, 1, 0, 0.320399,-0.0104837) , 
2, 0.30194, 1, 0, 0.26115,0.00164927)    );
  // itree = 1393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513333,0.0134804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246466,0.0012065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,-0.0311014) , 
2, 1.66447, 1, 0, 0.227349,-0.000683347) , 
2, -1.52711, 1, 0, 0.249359,-0.00346836)    );
  // itree = 1394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287845,0.00232577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00793651,-0.0662522) , 
3, 0.881124, 1, 0, 0.243566,0.0100388) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389313,0.0236322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34981,0.00464127) , 
1, 0.930279, 1, 0, 0.362944,-0.0160098) , 
2, 1.10989, 1, 0, 0.267237,0.0048737)    );
  // itree = 1395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0867025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219595,0.0136326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293355,-0.00626076) , 
0, -0.358069, 1, 0, 0.269441,0.00404353) , 
1, -1.3293, 1, 0, 0.249619,0.000360108)    );
  // itree = 1396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0493506,-0.0473189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0111732,0.00935833) , 
0, -0.36653, 1, 0, 0.037234,-0.0224087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128205,-0.040209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372977,0.00879411) , 
2, -0.754358, 1, 0, 0.339623,0.00583836) , 
3, -0.871513, 1, 0, 0.254135,-0.00214727)    );
  // itree = 1397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275245,0.000541784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0116041) , 
3, 1.53993, 1, 0, 0.259497,-0.00893555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128713,-0.00311957) , 
1, 1.7097, 1, 0, 0.252792,-0.00592412)    );
  // itree = 1398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59,0.0538757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332579,-0.00787495) , 
3, -1.99787, 1, 0, 0.380074,-0.0119396) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149635,-0.042068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260714,0.0148579) , 
0, -0.395089, 1, 0, 0.238881,0.00939882) , 
3, -0.871513, 1, 0, 0.278409,0.00342493)    );
  // itree = 1399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316418,0.0242024) , 
3, -1.98138, 1, 0, 0.239278,-0.0199117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.079646,-0.0210315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307826,-0.005834) , 
1, -0.0132411, 1, 0, 0.243446,0.00933959) , 
3, -1.08105, 1, 0, 0.242543,0.003003)    );
  // itree = 1400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0680272,-0.038893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0313901,0.0445046) , 
2, 0.0698174, 1, 0, 0.0579531,-0.0185562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38311,0.014553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319502,-0.0246194) , 
2, 1.4453, 1, 0, 0.370462,0.00898494) , 
3, -0.462334, 1, 0, 0.24518,-0.00205601)    );
  // itree = 1401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332536,-0.00232713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105691,0.000289889) , 
1, 0.879105, 1, 0, 0.257892,0.00499034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0186916,-0.062624) , 
2, 1.85179, 1, 0, 0.244939,0.00844771)    );
  // itree = 1402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225743,-0.00956997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232449,-0.00471179) , 
1, -0.426085, 1, 0, 0.230554,-0.00649042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463636,-0.0271671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,0.0125662) , 
3, 0.98958, 1, 0, 0.348018,0.0324688) , 
2, 1.53606, 1, 0, 0.243793,-0.00209928)    );
  // itree = 1403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0763543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369942,0.0470861) , 
0, -1.37965, 1, 0, 0.277657,-0.0245609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272281,0.00323645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0692308,-0.00121968) , 
3, 1.83457, 1, 0, 0.255305,0.0105038) , 
3, -1.08105, 1, 0, 0.260417,0.00248552)    );
  // itree = 1404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00625,-0.0686809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353383,0.03431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266013,-0.00482796) , 
1, -1.12426, 1, 0, 0.27224,-0.00140389) , 
3, -1.75118, 1, 0, 0.251234,-0.00371162)    );
  // itree = 1405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293936,-0.00555945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263323,0.00838684) , 
0, 0.112177, 1, 0, 0.281813,0.00632903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0676692,-0.0024492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0552764,-0.0344982) , 
2, 0.916434, 1, 0, 0.060241,0.0450608) , 
3, 1.20529, 1, 0, 0.243953,0.0129471)    );
  // itree = 1406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31913,0.00662606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241667,0.00509665) , 
0, 0.435233, 1, 0, 0.296319,0.00220876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0128205,-0.0616552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114035,-0.0235884) , 
0, 1.18494, 1, 0, 0.0555556,0.0599778) , 
3, 1.27365, 1, 0, 0.262105,0.010418)    );
  // itree = 1407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149502,-0.0207576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437956,0.00595727) , 
3, -0.870304, 1, 0, 0.286957,0.020539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165517,0.0521177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247751,0.00165485) , 
1, -0.573583, 1, 0, 0.239035,-0.0102158) , 
2, -0.472985, 1, 0, 0.253217,-0.00111442)    );
  // itree = 1408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.025253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225641,-0.049737) , 
0, -0.780815, 1, 0, 0.221498,-0.0255752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195527,-0.000211128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618182,0.0135652) , 
3, 1.30071, 1, 0, 0.265503,0.00403066) , 
1, -0.887572, 1, 0, 0.258638,-0.000587734)    );
  // itree = 1409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.715686,0.0212087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323923,-0.00214728) , 
1, -1.45472, 1, 0, 0.375484,-0.00672176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103175,-0.0397173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194245,0.0060439) , 
2, -0.83643, 1, 0, 0.184976,0.0240906) , 
3, -0.462334, 1, 0, 0.258321,0.0122279)    );
  // itree = 1410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257812,0.00879405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547445,0.0362873) , 
2, -1.23866, 1, 0, 0.407547,-0.0236577) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0721248,-0.0268706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303371,0.0087872) , 
2, -0.391748, 1, 0, 0.23593,0.000929031) , 
3, -1.55199, 1, 0, 0.258399,-0.00229008)    );
  // itree = 1411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24438,0.000679238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497326,0.0336486) , 
3, 1.1149, 1, 0, 0.274585,-0.00312249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227642,0.0359386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274368,0.00137126) , 
1, 0.936397, 1, 0, 0.26,0.0261677) , 
2, 1.10989, 1, 0, 0.271618,0.00283686)    );
  // itree = 1412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206897,-0.0151333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2811,0.0161001) , 
0, -0.770079, 1, 0, 0.258038,0.00648073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158273,-0.0496535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285223,-0.00454339) , 
1, -0.342762, 1, 0, 0.260749,-0.01608) , 
0, 0.385741, 1, 0, 0.259049,-0.00192997)    );
  // itree = 1413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585938,-0.000316068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281839,0.00713586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110429,-0.00214323) , 
3, 0.760066, 1, 0, 0.235683,-0.00167399) , 
1, -1.33599, 1, 0, 0.258745,0.00133953)    );
  // itree = 1414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407692,-0.011527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268097,0.00536696) , 
0, -1.46199, 1, 0, 0.279285,-0.00346927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170418,-0.00653599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169355,0.0130111) , 
0, 1.50613, 1, 0, 0.170115,-0.0262611) , 
0, 0.956597, 1, 0, 0.256198,-0.00828914)    );
  // itree = 1415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235054,-0.0105975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349112,0.0100939) , 
2, 0.975183, 1, 0, 0.256354,0.0113251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19375,0.0227109) , 
3, 1.74459, 1, 0, 0.251269,0.00534144)    );
  // itree = 1416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202492,-0.0292687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252252,0.0100278) , 
1, -0.770088, 1, 0, 0.243197,0.00275012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0162602,-0.0304738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629032,0.041745) , 
3, 1.08356, 1, 0, 0.323887,0.0434866) , 
0, 1.28629, 1, 0, 0.253108,0.00775355)    );
  // itree = 1417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387826,0.0117954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0699301,-0.000717181) , 
3, 0.954868, 1, 0, 0.352668,-0.0117546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.058296,-0.0394558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0974843,-2.94521e-05) , 
3, 0.919611, 1, 0, 0.0746073,0.0324075) , 
2, 0.553784, 1, 0, 0.249392,0.00464788)    );
  // itree = 1418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422018,-0.0179654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24248,-0.00139534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243968,0.010156) , 
1, 1.36335, 1, 0, 0.242757,-0.00937165) , 
0, -1.7049, 1, 0, 0.252013,-0.00668914)    );
  // itree = 1419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0342435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233284,0.0118923) , 
2, -0.967035, 1, 0, 0.227319,-0.0115127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27409,-0.00359658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865385,-0.0472877) , 
0, 1.60047, 1, 0, 0.255299,0.0258733) , 
3, -0.151872, 1, 0, 0.241704,0.00770804)    );
  // itree = 1420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178082,0.0113823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107717,-0.0334654) , 
2, -0.31113, 1, 0, 0.141791,-0.00435258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348684,-0.0520865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421779,-0.0120609) , 
0, -0.156325, 1, 0, 0.40796,-0.0310888) , 
3, 0.312307, 1, 0, 0.248259,-0.0150471)    );
  // itree = 1421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.639098,0.00120356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268409,-0.0142435) , 
1, -1.12365, 1, 0, 0.357401,-0.0124159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25641,-0.00467758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112698,-0.000776846) , 
1, 0.847861, 1, 0, 0.193927,0.0132262) , 
3, -0.871513, 1, 0, 0.239141,0.00613398)    );
  // itree = 1422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2784,-0.00234154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149338,-0.00784918) , 
0, 0.676581, 1, 0, 0.240022,0.00846188) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194444,-0.00565414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,0.0223019) , 
1, 1.57471, 1, 0, 0.318681,-0.0273901) , 
1, 1.4671, 1, 0, 0.250487,0.0036921)    );
  // itree = 1423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0759084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00909091,-0.10321) , 
3, -1.62203, 1, 0, 0.00409836,0.0341057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243363,-0.000818115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354271,-0.0103893) , 
0, 0.964569, 1, 0, 0.268529,-0.000186104) , 
0, -1.05347, 1, 0, 0.236236,0.00400168)    );
  // itree = 1424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0735294,-0.00748762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438144,0.0309201) , 
3, -1.02722, 1, 0, 0.225322,0.0142313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145597,-0.0225084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55611,0.00715685) , 
3, 1.03698, 1, 0, 0.251938,-0.00844391) , 
0, -0.691888, 1, 0, 0.24578,-0.00319732)    );
  // itree = 1425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481553,0.00120288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240602,0.00321571) , 
2, -0.572415, 1, 0, 0.33511,-0.00842826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126437,-0.0022937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130337,0.0186039) , 
2, 0.476856, 1, 0, 0.128895,0.0232134) , 
3, 0.414913, 1, 0, 0.263001,0.00263615)    );
  // itree = 1426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260274,0.00103415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128788,-0.0173866) , 
0, -0.0221055, 1, 0, 0.21934,0.00772099) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238474,-0.00767991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352151,0.00736143) , 
2, 1.22657, 1, 0, 0.264417,-0.00781285) , 
1, -0.57495, 1, 0, 0.255112,-0.00460625)    );
  // itree = 1427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0703625,-0.0245664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248366,0.0519155) , 
2, 0.82362, 1, 0, 0.0953254,0.0211948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474315,0.0110851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392283,-0.00212852) , 
1, 1.40297, 1, 0, 0.44581,-0.0155381) , 
1, 0.529246, 1, 0, 0.253273,0.00464092)    );
  // itree = 1428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217742,0.0428092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20376,-0.00404484) , 
0, -1.46837, 1, 0, 0.204738,0.000129333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70303,0.03021) , 
3, 1.65362, 1, 0, 0.247162,0.00516733)    );
  // itree = 1429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279051,-0.010998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267857,0.0145158) , 
0, 0.586991, 1, 0, 0.276403,0.00895347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127049,0.0452182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654206,-0.011774) , 
3, 1.97338, 1, 0, 0.108262,-0.0264956) , 
3, 1.22488, 1, 0, 0.247012,0.00275695)    );
  // itree = 1430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177866,-0.00116637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305067,0.0126) , 
2, -0.223322, 1, 0, 0.249131,0.00517685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396396,0.0430103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31875,-0.0149731) , 
1, 1.18996, 1, 0, 0.350554,-0.0215518) , 
2, 1.46214, 1, 0, 0.262894,0.00154968)    );
  // itree = 1431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261865,-0.00357419) , 
3, -2.08729, 1, 0, 0.247102,0.0111633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204724,0.00426383) , 
2, 1.78274, 1, 0, 0.244444,0.015276)    );
  // itree = 1432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0209205,-0.0374199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289509,0.0179597) , 
3, -1.5995, 1, 0, 0.252722,0.0137383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107843,0.00685508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,-0.031531) , 
2, 0.594589, 1, 0, 0.277397,-0.0337099) , 
0, 1.2265, 1, 0, 0.256259,0.00693668)    );
  // itree = 1433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483607,-0.0209885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280303,-0.00399774) , 
3, -1.90752, 1, 0, 0.297503,-0.00329367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00787402,-0.0661567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0902935,-0.0210321) , 
0, -0.0115316, 1, 0, 0.0719298,0.0276096) , 
3, 0.721703, 1, 0, 0.233598,0.00546122)    );
  // itree = 1434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241493,-0.00836661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382883,0.00620738) , 
2, 0.648181, 1, 0, 0.269197,0.0117801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34902,0.0319856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200935,-0.00811321) , 
1, 1.05175, 1, 0, 0.243032,-0.0132172) , 
1, 0.589589, 1, 0, 0.257635,0.00073446)    );
  // itree = 1435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284861,0.0173551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210604,-0.00140674) , 
2, 0.191547, 1, 0, 0.254902,0.00632476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353383,0.0178132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258993,0.0383935) , 
0, 0.930979, 1, 0, 0.305147,-0.0271937) , 
2, 1.36808, 1, 0, 0.261893,0.00166132)    );
  // itree = 1436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0553936,-0.0334219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.018018,-0.00802621) , 
0, -0.493577, 1, 0, 0.040708,-0.0144683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503759,0.0438769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309971,0.00607334) , 
0, -0.807019, 1, 0, 0.326961,0.011057) , 
3, -0.871513, 1, 0, 0.24928,0.00413011)    );
  // itree = 1437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330732,0.00582634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0345658) , 
3, 0.829491, 1, 0, 0.297909,-0.00725079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22067,-0.00410754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,0.0187711) , 
3, 1.72976, 1, 0, 0.199052,0.00954113) , 
0, 0.145985, 1, 0, 0.256024,-0.000136142)    );
  // itree = 1438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345588,0.00143393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348684,0.00140599) , 
3, -1.46644, 1, 0, 0.347222,-0.0123053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208102,-0.0137981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157303,-0.00632581) , 
0, 1.1733, 1, 0, 0.199214,0.00566989) , 
3, -0.900958, 1, 0, 0.239772,0.000744239)    );
  // itree = 1439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252322,0.0288552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248307,-0.00454763) , 
3, -0.812446, 1, 0, 0.25,-0.00553414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616667,0.0615747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232877,-0.0169602) , 
0, 0.0967494, 1, 0, 0.327835,-0.0340921) , 
3, 0.802707, 1, 0, 0.268716,-0.0124011)    );
  // itree = 1440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,0.00198292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0656371,-0.038965) , 
0, 1.05367, 1, 0, 0.211413,-0.00261761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753968,0.0317217) , 
3, 1.73078, 1, 0, 0.246185,0.00165612)    );
  // itree = 1441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601307,-0.00772079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345865,0.00328493) , 
1, -1.09151, 1, 0, 0.416667,0.0187997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303178,0.0182098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0738162,-0.0206003) , 
2, 0.58661, 1, 0, 0.195964,-0.0158567) , 
2, -0.656951, 1, 0, 0.25431,-0.00669464)    );
  // itree = 1442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354571,0.000664575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283142,-0.016686) , 
3, -1.22866, 1, 0, 0.309671,-0.00892268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.068,-0.00985942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184576,-0.00263795) , 
1, 0.0845765, 1, 0, 0.15658,0.0212739) , 
3, -0.112181, 1, 0, 0.230502,0.00669314)    );
  // itree = 1443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142276,0.00579866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307996,-0.00075202) , 
0, -0.580628, 1, 0, 0.253821,0.000982702) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.000230175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326471,0.0246144) , 
2, 1.18552, 1, 0, 0.313333,-0.0279986) , 
2, 0.935005, 1, 0, 0.267519,-0.00568818)    );
  // itree = 1444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234703,0.00525543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155705,-0.0194328) , 
0, 0.170012, 1, 0, 0.202717,-0.00424491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741497,0.0225861) , 
3, 1.73078, 1, 0, 0.242577,-0.000986845)    );
  // itree = 1445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522472,-0.0188808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289514,0.0108499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0632054,-0.0169694) , 
2, 0.992408, 1, 0, 0.232518,-0.00527636) , 
1, -1.102, 1, 0, 0.259164,0.00125453)    );
  // itree = 1446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173114,-0.00326984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342193,0.0234168) , 
2, 0.149735, 1, 0, 0.211236,0.0117084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343653,0.0120587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331361,0.00169606) , 
2, 1.2082, 1, 0, 0.337368,-0.0127947) , 
2, 0.648293, 1, 0, 0.253006,0.00359387)    );
  // itree = 1447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218978,-0.00557758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477509,0.00858171) , 
0, 1.13453, 1, 0, 0.257631,-0.00238659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0413223,-0.0637448) , 
1, 1.65151, 1, 0, 0.244888,-0.00632792)    );
  // itree = 1448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0818991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40113,0.0367856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255692,0.000865093) , 
0, -1.05662, 1, 0, 0.269312,0.00543907) , 
3, -2.02293, 1, 0, 0.254373,0.00275867)    );
  // itree = 1449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316209,-0.00810477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131436,-0.00615933) , 
3, 0.197992, 1, 0, 0.243171,0.00287712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0866667,0.0412283) , 
3, 1.76176, 1, 0, 0.231532,-0.00151263)    );
  // itree = 1450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343385,0.00952493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0396825,-0.0363227) , 
3, 0.586772, 1, 0, 0.283594,0.00572172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286885,0.0430421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178431,-0.0149071) , 
0, -0.634961, 1, 0, 0.199367,-0.0140883) , 
1, 0.939437, 1, 0, 0.255753,-0.000826362)    );
  // itree = 1451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114815,-0.0179353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103634,-0.00177366) , 
2, -0.397281, 1, 0, 0.10834,0.0189623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644401,0.0184737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254237,-0.00838291) , 
2, 1.18431, 1, 0, 0.520805,-0.00687638) , 
1, 0.844504, 1, 0, 0.259862,0.00947025)    );
  // itree = 1452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0719794,2.85399e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262087,0.0444432) , 
3, -0.870421, 1, 0, 0.167519,0.0229287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138443,-0.0252297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577273,0.00775114) , 
3, 0.791064, 1, 0, 0.293034,-0.00512477) , 
2, -0.191298, 1, 0, 0.244707,0.00567673)    );
  // itree = 1453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614379,0.00791098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289499,-0.00489587) , 
2, -1.39557, 1, 0, 0.330579,0.00527293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0991379,0.00753837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123188,0.0155834) , 
0, -0.258277, 1, 0, 0.116071,-0.0305402) , 
1, 0.75851, 1, 0, 0.246239,-0.00880805)    );
  // itree = 1454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280082,0.00548815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227154,-0.0087695) , 
1, 1.30089, 1, 0, 0.269148,0.00910916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533333,-0.0244105) , 
3, 1.76176, 1, 0, 0.252994,0.00462482)    );
  // itree = 1455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218251,-0.00226195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32,0.0354156) , 
3, 1.3735, 1, 0, 0.22714,-0.000644042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621795,0.0257026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137931,-0.0431171) , 
3, 1.07888, 1, 0, 0.388704,0.0345328) , 
0, 1.19707, 1, 0, 0.251239,0.00460285)    );
  // itree = 1456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268089,-0.00402267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306818,0.0300983) , 
1, 0.504488, 1, 0, 0.277622,0.0043161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0541401,-0.00401277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3379,-0.0180833) , 
3, 0.970894, 1, 0, 0.170732,-0.0150978) , 
1, 1.2054, 1, 0, 0.248599,-0.000955226)    );
  // itree = 1457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403279,0.000860697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250948,0.00565124) , 
3, -1.41988, 1, 0, 0.27557,0.000734347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670391,0.012965) , 
3, 1.69879, 1, 0, 0.257502,-0.00284154)    );
  // itree = 1458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366782,-0.00420248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308501,0.0078701) , 
0, -0.900213, 1, 0, 0.32028,0.0107934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00763359,-0.0715267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152809,0.0251484) , 
0, 0.0820385, 1, 0, 0.119792,-0.0280477) , 
3, 0.721703, 1, 0, 0.262712,-0.000359348)    );
  // itree = 1459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0977011,0.0165975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110945,-0.0169041) , 
3, -0.626849, 1, 0, 0.10513,0.0221357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540984,0.0180925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430476,0.0182389) , 
0, -0.115543, 1, 0, 0.471084,-0.0113595) , 
1, 0.670673, 1, 0, 0.255572,0.00836599)    );
  // itree = 1460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154004,0.0110284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0363636,-0.0417176) , 
0, -0.473442, 1, 0, 0.0947047,-0.00401316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704348,0.0716893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391068,0.00690481) , 
1, -0.41196, 1, 0, 0.425944,0.0208921) , 
3, -0.127334, 1, 0, 0.264516,0.00875466)    );
  // itree = 1461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509554,-0.0293682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24821,0.00377187) , 
1, -1.27602, 1, 0, 0.277228,0.00665298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258312,0.015483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127962,0.0142764) , 
1, 1.04084, 1, 0, 0.212625,-0.0252108) , 
0, 0.676581, 1, 0, 0.257937,-0.00286191)    );
  // itree = 1462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336761,-0.000535952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262159,0.0112271) , 
0, -0.833657, 1, 0, 0.285714,-0.00846637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195531,-0.00677772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212389,0.0189931) , 
0, 1.56894, 1, 0, 0.197829,0.0159004) , 
0, 0.297203, 1, 0, 0.250364,0.00133472)    );
  // itree = 1463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198478,-0.00110075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746114,0.0397187) , 
1, 1.34974, 1, 0, 0.258192,-0.00392502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163636,-0.0378685) , 
1, 1.56335, 1, 0, 0.250129,-0.00642677)    );
  // itree = 1464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233503,0.011421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165217,-0.0786994) , 
0, -0.162489, 1, 0, 0.208333,-0.0229405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0815155,-0.0232018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453815,0.00899446) , 
3, 0.201336, 1, 0, 0.253399,1.48791e-05) , 
1, -0.752382, 1, 0, 0.246114,-0.00369605)    );
  // itree = 1465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303284,0.00672929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,0.0546072) , 
3, 1.6047, 1, 0, 0.288976,-0.00676135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0818182,0.0113234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0619469,-0.0107125) , 
1, 1.34215, 1, 0, 0.0717489,0.0173) , 
2, 1.51846, 1, 0, 0.264983,-0.00410376)    );
  // itree = 1466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284921,0.00510015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178309,-0.0045846) , 
1, 0.967046, 1, 0, 0.252772,-0.000581528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342342,0.021939) , 
2, 1.85179, 1, 0, 0.257963,0.00270778)    );
  // itree = 1467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0779782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287656,6.60793e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.0396988) , 
0, 1.5063, 1, 0, 0.281585,0.00590922) , 
0, -1.35128, 1, 0, 0.261561,0.00266029)    );
  // itree = 1468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131387,0.033712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0667614,-0.0344394) , 
2, -0.972835, 1, 0, 0.0848671,-0.00671398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404082,0.0518523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493671,-0.00602271) , 
3, 0.871475, 1, 0, 0.448133,0.0255924) , 
3, -0.112181, 1, 0, 0.265191,0.00932278)    );
  // itree = 1469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651376,0.00257899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252232,0.0061932) , 
1, -1.54069, 1, 0, 0.275118,-0.00256868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186567,0.0504459) , 
1, 1.62191, 1, 0, 0.269287,-0.00562968)    );
  // itree = 1470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260452,-0.00121881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219955,0.00348789) , 
1, 1.2364, 1, 0, 0.251053,-0.0038926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09,-0.0212666) , 
3, 1.99526, 1, 0, 0.243,-0.000537467)    );
  // itree = 1471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00549451,-0.0912194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171636,-0.00348999) , 
1, -1.14821, 1, 0, 0.150387,0.0084515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688995,0.0285462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243421,-0.0409501) , 
0, 0.583613, 1, 0, 0.570175,-0.0152762) , 
1, 1.1695, 1, 0, 0.270447,0.00166534)    );
  // itree = 1472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,0.0460609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251429,-0.00519711) , 
2, -1.36445, 1, 0, 0.237714,-0.0018871) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192308,-0.0120527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539216,0.0434286) , 
1, 0.578249, 1, 0, 0.364078,0.0336062) , 
0, 1.28629, 1, 0, 0.251022,0.00185095)    );
  // itree = 1473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533937,0.0105531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273713,0.0288306) , 
1, -0.515399, 1, 0, 0.371186,-0.0222628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255286,0.00264031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483092,-0.0282559) , 
3, 1.52985, 1, 0, 0.226415,0.00915476) , 
0, -0.49228, 1, 0, 0.267599,0.000217253)    );
  // itree = 1474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347036,0.00904128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136816,-0.00286197) , 
3, 0.419716, 1, 0, 0.296341,0.00231542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0372671,0.0151511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138211,-0.00511739) , 
0, 1.19527, 1, 0, 0.0809859,-0.0366675) , 
3, 1.29328, 1, 0, 0.264992,-0.00335919)    );
  // itree = 1475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230508,-0.00349555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327586,-0.01494) , 
3, 0.802532, 1, 0, 0.24904,-0.00453422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183544,0.0439159) , 
3, 1.74459, 1, 0, 0.243816,-0.00778642)    );
  // itree = 1476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12782,0.00079786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499142,0.0170789) , 
3, 0.422166, 1, 0, 0.240983,0.00854786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359375,-0.0343497) , 
1, 1.65151, 1, 0, 0.248408,0.0046456)    );
  // itree = 1477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308235,-0.000460199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289439,0.00448337) , 
0, -0.110012, 1, 0, 0.29932,-0.00041054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0891089,-0.00228082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120482,0.0303278) , 
2, 1.20904, 1, 0, 0.103261,-0.0407631) , 
3, 1.07342, 1, 0, 0.262972,-0.00789152)    );
  // itree = 1478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235236,-0.00673644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343972,-0.00265735) , 
2, 0.679573, 1, 0, 0.25886,-0.000399552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238994,0.0332165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182886,-0.0113262) , 
0, -0.529259, 1, 0, 0.194702,-0.0220956) , 
1, 0.863356, 1, 0, 0.235265,-0.00837836)    );
  // itree = 1479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730271,-0.0329341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529954,0.011917) , 
1, 0.513068, 1, 0, 0.227592,0.00383009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.859813,0.0967665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195933,-0.00412219) , 
2, -0.192485, 1, 0, 0.305556,-0.0231913) , 
3, 0.436997, 1, 0, 0.253755,-0.00523766)    );
  // itree = 1480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0317163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415638,0.0353251) , 
3, -1.68319, 1, 0, 0.304348,0.0286324) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261084,-0.0293413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242711,0.000537555) , 
0, -0.900816, 1, 0, 0.245079,-0.0038451) , 
1, -0.66368, 1, 0, 0.255729,0.0019907)    );
  // itree = 1481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408832,0.000923157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256545,0.0159753) , 
2, -0.351133, 1, 0, 0.329468,-0.00544366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0179779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0647059,-0.0152227) , 
3, 1.38367, 1, 0, 0.0729367,0.0183375) , 
2, 0.843823, 1, 0, 0.262204,0.000791856)    );
  // itree = 1482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356098,0.0043394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365772,0.0133271) , 
3, -1.18443, 1, 0, 0.36017,-0.009034) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.0542805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20053,-0.00688954) , 
0, -0.680446, 1, 0, 0.188095,0.016441) , 
3, -0.580667, 1, 0, 0.25,0.00727619)    );
  // itree = 1483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174952,-0.0129278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371034,0.0101399) , 
0, 0.170012, 1, 0, 0.255223,0.00273521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196078,0.061496) , 
3, 1.76176, 1, 0, 0.25052,-0.00125524)    );
  // itree = 1484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109399,-0.00159576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483376,0.0202108) , 
3, -0.258713, 1, 0, 0.25,0.00979972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148515,-0.0332835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349421,-0.00511833) , 
2, 0.553619, 1, 0, 0.261388,-0.0168507) , 
0, 0.133846, 1, 0, 0.255352,-0.00272406)    );
  // itree = 1485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641221,0.0105407) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289703,0.0111237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186028,-0.0148923) , 
0, -0.402053, 1, 0, 0.218192,-0.000808046) , 
1, -1.33599, 1, 0, 0.246208,0.00220068)    );
  // itree = 1486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129771,-0.037994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0825741) , 
3, -1.34368, 1, 0, 0.062963,-0.0170603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261528,0.00180301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345794,-0.00118433) , 
2, 1.58219, 1, 0, 0.272346,0.00349489) , 
2, -1.12981, 1, 0, 0.24316,0.000629691)    );
  // itree = 1487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0203376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638298,0.0740738) , 
3, -1.02921, 1, 0, 0.382927,-0.0212061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279661,0.00886644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220083,-0.00159625) , 
2, -0.600586, 1, 0, 0.224555,0.00986704) , 
2, -0.860447, 1, 0, 0.257316,0.00343919)    );
  // itree = 1488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217466,0.00935356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530435,0.0423366) , 
3, 1.41686, 1, 0, 0.236743,0.0129665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677596,-0.0199319) , 
3, 1.73078, 1, 0, 0.276098,0.00855981)    );
  // itree = 1489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681081,0.0284363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0995671,-0.0672391) , 
2, -1.03431, 1, 0, 0.358173,-0.0106252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286282,-0.00217518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115192,0.00918994) , 
2, 0.693478, 1, 0, 0.22243,0.0113225) , 
3, -1.13113, 1, 0, 0.250371,0.00680477)    );
  // itree = 1490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260474,-0.0011081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237781,-0.00100765) , 
1, 0.606823, 1, 0, 0.251213,0.00628386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0858896,0.0338624) , 
3, 1.76176, 1, 0, 0.237859,0.000312019)    );
  // itree = 1491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244847,-0.000281038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0198555) , 
2, 1.16006, 1, 0, 0.258575,0.00109537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0265487,-0.0749161) , 
1, 1.65151, 1, 0, 0.245518,-0.00334147)    );
  // itree = 1492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144385,-0.0035989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476703,0.0248916) , 
3, 0.689902, 1, 0, 0.19662,0.00375117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491525,-0.0343559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544218,0.00582542) , 
0, 1.15142, 1, 0, 0.515432,-0.0276043) , 
3, 1.27365, 1, 0, 0.245831,-0.00108884)    );
  // itree = 1493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435685,-0.0257545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238786,0.00333161) , 
1, -0.967115, 1, 0, 0.265794,-0.0101194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0381679,-0.023047) , 
3, 1.74551, 1, 0, 0.25,-0.00731879)    );
  // itree = 1494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289497,0.000112508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232339,0.00931402) , 
0, 0.199932, 1, 0, 0.268927,-0.00347233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621762,-0.0157516) , 
3, 1.56809, 1, 0, 0.248599,0.000565371)    );
  // itree = 1495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0791786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239437,-0.00234998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35786,-0.0104375) , 
0, 1.18497, 1, 0, 0.257764,-0.000931662) , 
0, -1.58783, 1, 0, 0.244838,-0.00411299)    );
  // itree = 1496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232184,0.0273756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139061,-0.0072604) , 
1, -0.546258, 1, 0, 0.164962,0.0039361) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412698,-0.0261956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577465,0.0221783) , 
2, 1.51309, 1, 0, 0.457692,-0.0212614) , 
3, 0.824791, 1, 0, 0.238004,-0.00235119)    );
  // itree = 1497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492212,0.000262812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326409,-0.00817021) , 
1, -0.807472, 1, 0, 0.407295,0.0175135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167331,-0.00539075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158341,0.00323786) , 
0, -0.592964, 1, 0, 0.160061,-0.00635283) , 
1, -0.128677, 1, 0, 0.24264,0.00161877)    );
  // itree = 1498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245614,-0.0151014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149254,0.0187791) , 
0, 0.169007, 1, 0, 0.218487,0.0313708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196078,-0.00151105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32913,0.00265758) , 
2, 0.429995, 1, 0, 0.261653,0.000792759) , 
1, -0.537387, 1, 0, 0.251799,0.00777364)    );
  // itree = 1499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0443686,0.00735277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0759162,-0.0310146) , 
3, -0.987872, 1, 0, 0.0622222,0.032384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361088,0.00711745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139535,-0.00663901) , 
2, 1.79945, 1, 0, 0.339204,-0.00388514) , 
1, -0.128677, 1, 0, 0.244826,0.00847311)    );
  // itree = 1500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3125,0.0373311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263356,-0.00163679) , 
1, -1.14821, 1, 0, 0.269103,0.0037532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947368,0.00446546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250965,-0.0370387) , 
2, 0.886393, 1, 0, 0.169118,-0.0208402) , 
1, 1.1695, 1, 0, 0.242557,-0.00277622)    );
  // itree = 1501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350082,0.00418547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0904348,-0.0182104) , 
1, 0.863356, 1, 0, 0.266629,-0.0101597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,-0.0155864) , 
3, 1.74551, 1, 0, 0.250907,-0.00539919)    );
  // itree = 1502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246988,-0.00239889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176,0.0287024) , 
0, -0.275009, 1, 0, 0.216495,-0.0342598) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273616,0.00279009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196319,0.0185265) , 
0, 1.41135, 1, 0, 0.266196,0.00826034) , 
1, -0.87377, 1, 0, 0.258924,0.00203944)    );
  // itree = 1503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226322,0.0109821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251208,-0.0125913) , 
3, -0.39965, 1, 0, 0.238879,-0.00426822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497207,0.0575791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0778708) , 
3, 1.95243, 1, 0, 0.317857,-0.0366384) , 
3, 1.36188, 1, 0, 0.25039,-0.00898642)    );
  // itree = 1504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237477,0.0230927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159855,-0.00853889) , 
1, -0.356432, 1, 0, 0.185366,0.00307236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541463,-0.000538828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487603,-0.0353325) , 
0, 1.34519, 1, 0, 0.521472,-0.0289935) , 
3, 1.22047, 1, 0, 0.241099,-0.00224476)    );
  // itree = 1505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301887,-0.0395756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,0.0100001) , 
0, -1.66157, 1, 0, 0.336364,0.0321852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248632,-0.000949732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0873786,0.0281214) , 
3, 1.89048, 1, 0, 0.23913,-0.00632581) , 
0, -1.14631, 1, 0, 0.25,-0.00202072)    );
  // itree = 1506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265693,0.00757123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281629,0.000957018) , 
1, -0.119724, 1, 0, 0.275693,0.00846803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0353982,-0.0215943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0535714,-0.0456599) , 
3, 1.92406, 1, 0, 0.0444444,0.0575825) , 
3, 1.55602, 1, 0, 0.250484,0.0138221)    );
  // itree = 1507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,0.0173672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297449,0.0045587) , 
1, -1.19143, 1, 0, 0.272163,-0.00538169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137255,-0.0421866) , 
1, 1.56335, 1, 0, 0.261435,-0.00922132)    );
  // itree = 1508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114094,-0.0421678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158999,-0.00841593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507282,0.00924219) , 
3, 0.991711, 1, 0, 0.234921,-0.001164) , 
0, -1.43147, 1, 0, 0.226091,-0.00438099)    );
  // itree = 1509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488688,-0.00184412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246485,0.0100422) , 
2, -0.649472, 1, 0, 0.317429,-0.0116435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0220588,-0.055497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0106611) , 
0, -0.324768, 1, 0, 0.0652174,0.00970368) , 
1, 1.28142, 1, 0, 0.258507,-0.00665634)    );
  // itree = 1510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160819,-0.00746702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246774,-0.00624203) , 
2, -0.325612, 1, 0, 0.201687,0.0119598) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283753,-0.00741618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350515,0.00228684) , 
1, 1.40284, 1, 0, 0.304279,-0.0149077) , 
2, 0.689402, 1, 0, 0.235142,0.00319836)    );
  // itree = 1511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0781047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297066,0.00747145) , 
0, -1.35128, 1, 0, 0.268954,-0.00471236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145161,-0.0220486) , 
1, 1.56373, 1, 0, 0.261005,-0.00815583)    );
  // itree = 1512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238896,0.000696219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217877,-0.0182316) , 
0, 0.900791, 1, 0, 0.234816,-0.00321608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.041927) , 
2, 1.85179, 1, 0, 0.245632,0.000109525)    );
  // itree = 1513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39441,0.00337247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130252,-0.0172501) , 
3, -0.533572, 1, 0, 0.255523,0.0174507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216495,-0.00311577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136054,0.0549214) , 
3, 1.64535, 1, 0, 0.197785,-0.0156287) , 
0, 0.6269, 1, 0, 0.237186,0.0069451)    );
  // itree = 1514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384615,-0.0144446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202648,-0.00867643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352332,-0.0075063) , 
2, 1.63767, 1, 0, 0.217617,-0.00550028) , 
0, -1.35128, 1, 0, 0.232008,-0.00314282)    );
  // itree = 1515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0819532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253491,-0.00220633) , 
1, -1.38335, 1, 0, 0.224762,-0.0113897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.808696,0.0740148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177671,-0.0203807) , 
2, -0.461244, 1, 0, 0.254219,0.0243134) , 
3, 0.0386592, 1, 0, 0.238739,0.00555054)    );
  // itree = 1516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.059719,-0.0228244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34229,0.0256226) , 
3, -0.387978, 1, 0, 0.20117,0.00754857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509434,-0.0809409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461538,0.00470052) , 
1, 1.05516, 1, 0, 0.479167,-0.0471658) , 
3, 1.26906, 1, 0, 0.241241,-0.000338186)    );
  // itree = 1517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343354,0.00181411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,-0.0456482) , 
2, 0.486366, 1, 0, 0.317664,0.010324) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0264554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964126,-0.0105306) , 
0, -0.19926, 1, 0, 0.0831918,-0.018441) , 
2, 0.689402, 1, 0, 0.248369,0.00182296)    );
  // itree = 1518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180233,0.00559932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0217298) , 
1, -0.486291, 1, 0, 0.12037,-0.023165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295485,0.00360349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.0134671) , 
3, 1.9202, 1, 0, 0.281734,0.00745332) , 
2, -1.02375, 1, 0, 0.25477,0.00233711)    );
  // itree = 1519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229204,0.00669765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542857,-0.00545084) , 
1, 1.4556, 1, 0, 0.258938,-0.00221751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0188679,-0.0652547) , 
1, 1.7097, 1, 0, 0.245902,-0.00499631)    );
  // itree = 1520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104396,0.0192243) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102222,-0.0531354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253411,-0.00781968) , 
2, -0.89966, 1, 0, 0.234127,-0.0117762) , 
2, -1.4149, 1, 0, 0.221994,-0.00936281)    );
  // itree = 1521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435696,-0.0139666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227737,0.0118777) , 
1, -0.615609, 1, 0, 0.272987,-0.0040438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216216,0.0125818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122905,-0.00664254) , 
1, 0.172439, 1, 0, 0.158621,-0.0418277) , 
0, 1.2265, 1, 0, 0.256737,-0.00941241)    );
  // itree = 1522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341833,0.0100275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0743134,-0.0261044) , 
3, 0.402068, 1, 0, 0.253469,-0.0114439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359649,0.00366543) , 
2, 1.82177, 1, 0, 0.259557,-0.00672301)    );
  // itree = 1523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584795,-0.0444089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32,0.0403983) , 
3, -0.582035, 1, 0, 0.138211,-0.032635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301692,0.00878781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189189,-0.00413092) , 
0, 1.54024, 1, 0, 0.293197,-0.0086303) , 
0, -0.653242, 1, 0, 0.254332,-0.0146498)    );
  // itree = 1524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202198,0.00863839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0845714,-0.0224006) , 
0, -0.595612, 1, 0, 0.124812,-0.00498998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504323,0.036282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525836,-0.00479387) , 
2, 0.888457, 1, 0, 0.514793,0.0243232) , 
3, 0.519658, 1, 0, 0.256231,0.00488825)    );
  // itree = 1525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296245,0.00350242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0155039,-0.0604552) , 
3, 1.29838, 1, 0, 0.273133,0.0100227) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148551,-0.0201364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132231,0.00368429) , 
1, 0.944524, 1, 0, 0.143577,-0.0203291) , 
0, 1.01723, 1, 0, 0.246945,0.00388747)    );
  // itree = 1526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253372,0.00504738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17801,-0.0154823) , 
1, 1.44422, 1, 0, 0.245781,-0.0009757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457944,0.033016) , 
1, 1.68641, 1, 0, 0.257114,-0.00475602)    );
  // itree = 1527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179949,-0.0104024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434442,0.0135185) , 
0, 0.423294, 1, 0, 0.257449,-0.00982257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31068,-0.0154542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239837,-0.0137267) , 
3, 1.4536, 1, 0, 0.260745,0.054639) , 
3, 1.27365, 1, 0, 0.258017,0.00127615)    );
  // itree = 1528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163588,-0.0178741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495495,0.0156712) , 
3, 0.999919, 1, 0, 0.186232,-0.0107455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578616,-0.00559639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607143,0.0223969) , 
0, 1.19527, 1, 0, 0.591973,0.0197532) , 
3, 1.29328, 1, 0, 0.249221,-0.00601076)    );
  // itree = 1529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534392,-0.00921388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232572,-0.00422928) , 
1, -1.15151, 1, 0, 0.262658,-0.00163012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,0.0184483) , 
3, 1.74459, 1, 0, 0.249633,0.00142017)    );
  // itree = 1530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2282,0.00682866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415309,0.0060346) , 
2, 0.345267, 1, 0, 0.296099,-0.00571744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.039604,0.0114268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144928,-0.00737296) , 
1, 1.31793, 1, 0, 0.0823529,0.0342129) , 
3, 1.27365, 1, 0, 0.260335,0.000963822)    );
  // itree = 1531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210993,0.018145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280488,2.23301e-05) , 
3, -0.890873, 1, 0, 0.25864,0.00587504) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528846,0.0043105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0254237,-0.0631487) , 
2, 1.23077, 1, 0, 0.261261,0.0470447) , 
3, 1.55602, 1, 0, 0.258929,0.0104086)    );
  // itree = 1532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,0.0394586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151235,-0.0176555) , 
0, -1.50286, 1, 0, 0.160698,-0.00807772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373626,0.0345854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322993,-0.00610612) , 
2, 0.835181, 1, 0, 0.343202,0.010328) , 
2, 0.213212, 1, 0, 0.243878,0.000311077)    );
  // itree = 1533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507853,0.0292319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237231,-0.00661758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0854701,-0.00739737) , 
3, 1.17744, 1, 0, 0.208265,0.00636779) , 
2, -1.45592, 1, 0, 0.236453,0.00345888)    );
  // itree = 1534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275064,0.00978357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360656,-0.00103658) , 
2, 1.42243, 1, 0, 0.284071,-0.00458862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165468,-0.0100563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0660377,-0.0485876) , 
3, 1.42959, 1, 0, 0.122449,0.0498239) , 
0, 1.28629, 1, 0, 0.264113,0.00213067)    );
  // itree = 1535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309278,0.0478291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237392,0.00479697) , 
2, -1.25948, 1, 0, 0.251241,-0.00462117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116129,-0.0215921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292683,-0.0183629) , 
1, 0.315942, 1, 0, 0.236025,0.0251031) , 
3, -0.0237104, 1, 0, 0.243791,0.00993212)    );
  // itree = 1536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00952381,-0.0678168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27065,0.0106854) , 
3, -2.05294, 1, 0, 0.255519,0.00793248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252525,-0.0511432) , 
2, 1.53606, 1, 0, 0.255224,0.00216245)    );
  // itree = 1537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365922,-0.00229902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142077,-0.0249044) , 
0, 1.2265, 1, 0, 0.333333,0.0133884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1264,0.0213225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,-0.0511663) , 
3, 1.73696, 1, 0, 0.112329,-0.020613) , 
1, 0.863356, 1, 0, 0.252139,0.000896698)    );
  // itree = 1538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300912,-0.0141376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229133,0.00250041) , 
0, -0.434936, 1, 0, 0.254255,-0.00103811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213592,0.023809) , 
0, 1.55221, 1, 0, 0.252143,-0.00342909)    );
  // itree = 1539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0955585,0.0144599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367536,-0.00331198) , 
1, -0.0805323, 1, 0, 0.26294,0.00541771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0348235) , 
2, 1.82177, 1, 0, 0.252801,0.00874558)    );
  // itree = 1540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232407,0.00148301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581633,-0.0334065) , 
3, 1.70126, 1, 0, 0.251537,-0.00139227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38125,0.0338404) , 
0, 1.44542, 1, 0, 0.262186,0.00260348)    );
  // itree = 1541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360153,-0.00190476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172063,0.00616673) , 
3, -0.433504, 1, 0, 0.251073,0.00815357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227848,0.0207643) , 
0, 1.44177, 1, 0, 0.249258,0.00385441)    );
  // itree = 1542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14433,-0.0224132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482517,0.00981174) , 
2, -0.879111, 1, 0, 0.345833,-0.0146806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0902256,-0.0133052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217873,-0.00644109) , 
1, -0.81572, 1, 0, 0.206456,0.0159077) , 
3, -0.976372, 1, 0, 0.240468,0.0084433)    );
  // itree = 1543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0778045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269346,-0.00119336) , 
0, -1.64238, 1, 0, 0.254247,-0.00680164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267442,0.0253792) , 
3, 1.65076, 1, 0, 0.255418,-0.0116498)    );
  // itree = 1544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209459,0.00784448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277641,-0.0331878) , 
2, 0.409624, 1, 0, 0.226901,-0.00377726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0619048,0.00608508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613065,0.0238172) , 
3, 0.98958, 1, 0, 0.330073,0.0235588) , 
2, 1.07686, 1, 0, 0.248,0.00181297)    );
  // itree = 1545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437421,0.0060295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157143,-0.022544) , 
3, 0.178242, 1, 0, 0.351446,0.0174149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160377,0.0250717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0635838,-0.0147063) , 
3, 1.38165, 1, 0, 0.139679,-0.017498) , 
1, 0.601922, 1, 0, 0.26359,0.00293052)    );
  // itree = 1546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15847,-0.00667124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291204,0.00215473) , 
2, -0.278838, 1, 0, 0.240147,0.00500319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391667,-0.000293422) , 
1, 1.68939, 1, 0, 0.249135,0.00750818)    );
  // itree = 1547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0756378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103175,0.0395689) , 
1, -0.401784, 1, 0, 0.046595,-0.0362045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140625,0.0313702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36075,-0.000580553) , 
1, -0.537387, 1, 0, 0.319461,-0.00816389) , 
0, -0.954752, 1, 0, 0.281108,-0.0121051)    );
  // itree = 1548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214008,0.0267702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0680101,-0.0309396) , 
1, -0.919259, 1, 0, 0.103711,-0.00486056) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436019,0.0133143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391447,-0.00414683) , 
2, 1.08831, 1, 0, 0.421558,0.0106005) , 
3, -0.0237104, 1, 0, 0.253521,0.00242667)    );
  // itree = 1549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312966,-0.00116518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144531,0.0109883) , 
3, 0.497816, 1, 0, 0.266451,0.00109027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09375,0.0358073) , 
3, 1.74551, 1, 0, 0.252731,-0.00232967)    );
  // itree = 1550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415301,0.014595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157113,-0.0167011) , 
3, -1.61915, 1, 0, 0.229358,0.0220913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241088,0.0112431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355556,0.00112786) , 
2, 1.18431, 1, 0, 0.267198,-0.000876241) , 
1, -0.187201, 1, 0, 0.255037,0.00650496)    );
  // itree = 1551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,0.00681978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235185,-0.0020954) , 
2, -1.23956, 1, 0, 0.221113,-0.00617323) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130809,-0.00372636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323442,-0.012883) , 
1, 0.593026, 1, 0, 0.234263,0.0104503) , 
3, -0.580667, 1, 0, 0.22955,0.00449271)    );
  // itree = 1552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198113,0.00182795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513986,-0.0229499) , 
3, 1.15253, 1, 0, 0.246269,-0.0051156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405594,0.0236967) , 
1, 1.59198, 1, 0, 0.257553,-0.00196498)    );
  // itree = 1553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481481,-0.00412617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,-0.00289809) , 
3, -0.987872, 1, 0, 0.375839,0.0112394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127139,-0.0236672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137353,0.0086823) , 
3, 0.19987, 1, 0, 0.133201,-0.0132365) , 
1, 0.367449, 1, 0, 0.256711,-0.000777567)    );
  // itree = 1554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503185,0.0218596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336752,0.00806046) , 
0, -1.21702, 1, 0, 0.371968,-0.00797971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14442,-0.0160535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247742,0.00157917) , 
1, 0.366441, 1, 0, 0.209416,0.0193377) , 
3, -0.551853, 1, 0, 0.270517,0.00906946)    );
  // itree = 1555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0769284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287819,0.00411773) , 
0, -1.37918, 1, 0, 0.265969,0.000759929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0472441,-0.0579473) , 
1, 1.65151, 1, 0, 0.252332,-0.00235417)    );
  // itree = 1556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226204,0.00185047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841122,-0.0490998) , 
1, 1.56509, 1, 0, 0.218172,-0.00134569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648276,-0.0322741) , 
3, 1.76176, 1, 0, 0.248773,-0.00544634)    );
  // itree = 1557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637584,0.00264578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355769,0.0216845) , 
2, -0.806866, 1, 0, 0.521739,-0.0441068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230526,0.00273872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10917,-0.00653957) , 
1, 1.50411, 1, 0, 0.215155,0.00190098) , 
1, -1.00949, 1, 0, 0.25279,-0.00374674)    );
  // itree = 1558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193182,-0.000503609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280769,0.00341762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253247,-0.0093093) , 
1, -0.53534, 1, 0, 0.257222,0.00183118) , 
1, -1.23776, 1, 0, 0.251518,-0.00253326)    );
  // itree = 1559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0762536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0937895) , 
2, -0.777566, 1, 0, 0,0.0294747) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281169,-0.00176203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305556,0.00247048) , 
3, 0.660534, 1, 0, 0.289247,0.00171197) , 
0, -1.14631, 1, 0, 0.258878,0.00462683)    );
  // itree = 1560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284722,0.0196422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122024,-0.0208256) , 
1, 1.25783, 1, 0, 0.253941,0.0130032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.027027,-0.0612701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560748,-0.0452516) , 
3, 1.40895, 1, 0, 0.288991,-0.0612251) , 
2, 1.51846, 1, 0, 0.257773,0.00488795)    );
  // itree = 1561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336641,0.00580331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109244,0.00879896) , 
2, 0.709315, 1, 0, 0.276036,-0.00307131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.023622,-0.0530222) , 
3, 1.76176, 1, 0, 0.259279,0.00136165)    );
  // itree = 1562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447619,0.0208794) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256599,0.00106662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169184,0.00893203) , 
0, 1.12709, 1, 0, 0.241837,-0.00293477) , 
0, -1.61174, 1, 0, 0.2523,-0.00499173)    );
  // itree = 1563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0842311,-0.00835099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461949,0.00830075) , 
1, 0.427648, 1, 0, 0.244068,0.00676011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325,0.00556465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0661157,-0.0598131) , 
0, 1.37735, 1, 0, 0.227414,0.043468) , 
3, 1.29328, 1, 0, 0.241511,0.0123953)    );
  // itree = 1564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224975,0.000933471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757396,0.0448599) , 
3, 0.884938, 1, 0, 0.301358,0.0103975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,-0.0449502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22103,0.00682435) , 
0, -0.0392497, 1, 0, 0.179648,-0.0142735) , 
1, 0.770313, 1, 0, 0.25228,0.000449104)    );
  // itree = 1565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396285,-0.000828284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1712,0.00288703) , 
2, -0.363611, 1, 0, 0.24789,-0.00284279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19802,0.00100855) , 
0, 1.58326, 1, 0, 0.245368,0.0016981)    );
  // itree = 1566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314779,-0.000750114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0473934,-0.0159376) , 
3, 0.827607, 1, 0, 0.269753,0.00762397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237805,-0.0071484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140078,0.028901) , 
3, 1.05793, 1, 0, 0.204272,-0.024593) , 
1, 0.844504, 1, 0, 0.245255,-0.00442924)    );
  // itree = 1567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00840336,-0.05906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139145,-0.00354064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522095,0.00141475) , 
1, 1.03481, 1, 0, 0.268847,-0.00319909) , 
1, -1.35856, 1, 0, 0.25273,0.000393579)    );
  // itree = 1568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194444,0.0143425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0589623,-0.0330498) , 
1, -1.02488, 1, 0, 0.0864662,-0.00901052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394495,0.0321249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427907,-0.00284019) , 
2, 0.273454, 1, 0, 0.416667,0.00945672) , 
3, 0.000826949, 1, 0, 0.244106,-0.000194137)    );
  // itree = 1569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450151,-0.00300036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340686,-0.00412939) , 
0, -0.414289, 1, 0, 0.389716,0.0178222) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193078,0.00870307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0552995,-0.0258604) , 
3, 1.47086, 1, 0, 0.170342,-0.00846755) , 
1, -0.0805323, 1, 0, 0.24927,0.000991125)    );
  // itree = 1570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356618,0.00231204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0583942,-0.0321442) , 
3, -0.022881, 1, 0, 0.296623,0.0198619) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280784,0.0138739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0575916,-0.0262506) , 
3, 1.52985, 1, 0, 0.247031,0.0017655) , 
0, -0.362191, 1, 0, 0.264403,0.00810484)    );
  // itree = 1571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221723,-0.00648998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390728,0.0375401) , 
3, 0.55644, 1, 0, 0.238896,-0.00265852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415254,0.00835107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196226,-0.028661) , 
0, 0.712439, 1, 0, 0.299401,0.0305866) , 
3, 0.824791, 1, 0, 0.254152,0.00572387)    );
  // itree = 1572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259557,0.0310603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113027,-0.0246437) , 
1, -0.379543, 1, 0, 0.160286,0.000601218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392157,-0.0196163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588571,0.0251918) , 
0, 0.119274, 1, 0, 0.544248,0.0299276) , 
3, 0.873167, 1, 0, 0.247366,0.00725226)    );
  // itree = 1573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502825,0.015883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20264,-0.00683122) , 
1, -0.786778, 1, 0, 0.259497,0.0012155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138158,0.0186551) , 
1, 1.57058, 1, 0, 0.250371,-0.00269722)    );
  // itree = 1574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424125,-0.00228141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209845,-0.019211) , 
3, -1.29599, 1, 0, 0.29549,0.0215558) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254049,0.00457936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568182,-0.0126854) , 
3, 1.59871, 1, 0, 0.228317,-0.00745698) , 
0, -0.402053, 1, 0, 0.25,0.00190809)    );
  // itree = 1575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25358,-0.0133178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233883,0.00977888) , 
2, 0.345126, 1, 0, 0.246494,-0.00662122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411215,0.0126759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0446429,-0.0265539) , 
3, 1.42925, 1, 0, 0.223744,0.0372573) , 
2, 1.51846, 1, 0, 0.244091,-0.00198572)    );
  // itree = 1576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130782,0.00643824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435726,-0.0195234) , 
3, 0.422166, 1, 0, 0.229358,-0.00645835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478992,0.0361031) , 
1, 1.7097, 1, 0, 0.244422,-0.00195402)    );
  // itree = 1577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333755,0.00455437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273988,0.00440515) , 
0, -0.203826, 1, 0, 0.302536,-0.000402028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,0.0118388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142336,0.0368248) , 
2, 0.582159, 1, 0, 0.12766,-0.0461791) , 
3, 1.14622, 1, 0, 0.270177,-0.00887259)    );
  // itree = 1578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294118,-0.00342622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,-0.00975819) , 
0, 0.112177, 1, 0, 0.259631,0.00665822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0459184,-0.0240345) , 
3, 1.56809, 1, 0, 0.238551,0.0104715)    );
  // itree = 1579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0682788,-0.000419658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102362,-0.027149) , 
1, -0.145787, 1, 0, 0.077325,0.00580707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436306,0.0194351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359477,0.000707618) , 
0, -0.275039, 1, 0, 0.381835,-0.0116335) , 
1, 0.227361, 1, 0, 0.238703,-0.00343577)    );
  // itree = 1580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266055,0.0165478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235606,-0.0122721) , 
0, -1.16489, 1, 0, 0.239922,-0.00665023) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0825758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466238,0.0182253) , 
3, 0.487166, 1, 0, 0.290581,0.015714) , 
0, 0.873363, 1, 0, 0.252332,-0.00117171)    );
  // itree = 1581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310516,0.00224452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25572,0.00470954) , 
0, 0.0732507, 1, 0, 0.287264,-0.00377313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.00509579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0628272,-0.0358077) , 
0, 0.781427, 1, 0, 0.0535117,0.0288127) , 
3, 1.35645, 1, 0, 0.253171,0.000979633)    );
  // itree = 1582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161905,-0.035925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523179,0.030608) , 
2, -1.19653, 1, 0, 0.375,-0.0208166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212276,-0.00938057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330275,0.0231388) , 
1, 1.49547, 1, 0, 0.226712,0.0127415) , 
3, -1.51764, 1, 0, 0.245339,0.00852613)    );
  // itree = 1583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208556,0.021435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23839,0.0122941) , 
3, -1.21586, 1, 0, 0.222382,-0.0108656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925926,0.00108788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289673,-0.000730294) , 
1, -0.488883, 1, 0, 0.266075,0.0091817) , 
3, -0.610112, 1, 0, 0.25122,0.00236563)    );
  // itree = 1584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183737,-0.00726478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366071,-0.0350798) , 
3, 1.26207, 1, 0, 0.195589,-0.00962477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574074,-0.00056804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690722,0.0167166) , 
0, 1.20902, 1, 0, 0.629268,0.0166256) , 
3, 1.57074, 1, 0, 0.241701,-0.00683362)    );
  // itree = 1585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396569,-0.00294277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105422,-0.0203604) , 
1, 0.866069, 1, 0, 0.323507,0.008265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0280374,-0.0443792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103093,-0.00639509) , 
0, -0.432543, 1, 0, 0.0914369,-0.00783466) , 
2, 0.648293, 1, 0, 0.244036,0.00275175)    );
  // itree = 1586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538462,0.0356736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236663,0.00337648) , 
3, -1.99752, 1, 0, 0.253483,0.00918569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490385,0.0430416) , 
2, 1.85179, 1, 0, 0.26599,0.00483465)    );
  // itree = 1587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240074,0.00104417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291457,-0.0300798) , 
3, 1.28856, 1, 0, 0.245721,0.0171607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31016,-0.00339577) , 
0, 1.41437, 1, 0, 0.251752,0.0132787)    );
  // itree = 1588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.00284787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0234604,-0.0610909) , 
2, -1.19684, 1, 0, 0.0397614,-0.0176951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421769,0.0258978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,-0.00279758) , 
1, 0.242287, 1, 0, 0.326746,0.00955891) , 
3, -0.976372, 1, 0, 0.255319,0.00277575)    );
  // itree = 1589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323872,0.000102996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0676328,-0.0225127) , 
3, 0.656214, 1, 0, 0.264541,0.00802401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,0.0284624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140187,-0.00755039) , 
1, 0.358974, 1, 0, 0.186603,-0.0269896) , 
0, 1.35023, 1, 0, 0.256385,0.00435959)    );
  // itree = 1590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295181,0.00905727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.087963,-0.0100596) , 
3, 1.13032, 1, 0, 0.271322,-0.00130371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921053,0.0247008) , 
3, 1.76176, 1, 0, 0.25789,-0.00463881)    );
  // itree = 1591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0922388) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167192,-0.0306602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29275,0.0046249) , 
0, -0.61593, 1, 0, 0.270377,0.0130532) , 
0, -1.26434, 1, 0, 0.24591,0.00859227)    );
  // itree = 1592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0757576,-0.0143482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41704,0.0137115) , 
3, -0.388717, 1, 0, 0.263906,0.00570167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916667,0.0108046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271845,-0.0229606) , 
1, 1.48032, 1, 0, 0.205521,-0.0174278) , 
1, 1.36335, 1, 0, 0.254115,0.00182296)    );
  // itree = 1593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338182,-0.0163576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282558,0.00670718) , 
3, -0.85678, 1, 0, 0.304255,0.00837146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121429,0.000346117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104265,0.00194878) , 
1, 0.463434, 1, 0, 0.108541,-0.0138902) , 
3, 0.721703, 1, 0, 0.248479,0.00202711)    );
  // itree = 1594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250939,-0.0074484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174576,-0.00677546) , 
0, 0.550703, 1, 0, 0.227486,-0.00366836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351852,-0.00623782) , 
1, 1.68939, 1, 0, 0.234105,-0.000400433)    );
  // itree = 1595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00552486,-0.011434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356164,0.0198493) , 
1, -0.734782, 1, 0, 0.1975,-0.0185716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947226,-0.0131633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371362,-0.00245235) , 
1, 0.432021, 1, 0, 0.243429,0.0123648) , 
3, -1.20032, 1, 0, 0.234234,0.00617135)    );
  // itree = 1596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.00613182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508772,0.063908) , 
3, -0.683569, 1, 0, 0.224719,0.0265145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236641,-0.0556924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262346,0.00352401) , 
1, -0.935986, 1, 0, 0.259986,-0.00323646) , 
0, -0.605694, 1, 0, 0.250382,0.00486504)    );
  // itree = 1597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617886,0.00301511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3243,0.00551437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105053,0.00214225) , 
1, 0.824221, 1, 0, 0.235611,-0.00933201) , 
1, -1.40737, 1, 0, 0.259334,-0.00462193)    );
  // itree = 1598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425577,0.0158088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169118,-0.00843702) , 
3, -0.752593, 1, 0, 0.288932,0.0138448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207084,0.00470596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334416,-0.011084) , 
2, 1.19404, 1, 0, 0.244722,-0.00770066) , 
1, 0.324332, 1, 0, 0.266602,0.00296241)    );
  // itree = 1599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0919083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223881,0.0118359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291517,0.00605202) , 
0, -0.828113, 1, 0, 0.284267,-0.00600568) , 
0, -1.26434, 1, 0, 0.256373,-0.00254634)    );
  // itree = 1600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167785,-0.0431507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.00188968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355932,-0.0187902) , 
1, 1.54516, 1, 0, 0.26072,-0.00148602) , 
1, -1.28125, 1, 0, 0.253425,-0.00527853)    );
  // itree = 1601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280563,0.00320735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0298507,-0.0245946) , 
3, 1.65076, 1, 0, 0.262965,-0.0056931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165138,0.0149031) , 
1, 1.68939, 1, 0, 0.257681,-0.00356898)    );
  // itree = 1602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403061,0.000597054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29064,-0.00159281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245625,0.00365641) , 
0, -0.788061, 1, 0, 0.250693,0.000694678) , 
0, -1.21886, 1, 0, 0.265633,0.00314536)    );
  // itree = 1603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0152672,0.00649942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100917,-0.0204076) , 
3, -0.969061, 1, 0, 0.0541667,0.0348029) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337629,-0.00023862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29212,0.00139194) , 
3, 0.313295, 1, 0, 0.315476,-0.00300381) , 
1, -0.484715, 1, 0, 0.25251,0.00610624)    );
  // itree = 1604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252229,0.00357481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138122,-0.0418741) , 
0, 1.26376, 1, 0, 0.240434,-0.00129369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0272727,0.0283523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6125,0.0291218) , 
3, 0.800103, 1, 0, 0.374074,0.0332142) , 
2, 1.38493, 1, 0, 0.258288,0.00331646)    );
  // itree = 1605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601942,-0.0117985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,-0.0249087) , 
3, -1.58724, 1, 0, 0.521951,0.059897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225326,-0.00340565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11215,0.0311664) , 
2, 1.80489, 1, 0, 0.218277,0.00264712) , 
1, -1.19679, 1, 0, 0.25065,0.0087502)    );
  // itree = 1606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267673,-0.00470962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151261,-0.0238058) , 
0, 0.775176, 1, 0, 0.251327,0.000939741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.0190488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126667,-0.0117993) , 
3, 1.1233, 1, 0, 0.148699,0.045847) , 
0, 1.24796, 1, 0, 0.237271,0.00709048)    );
  // itree = 1607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0905882,0.00876816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432914,0.00950053) , 
1, 0.259956, 1, 0, 0.271619,0.00263329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934579,-0.0498252) , 
2, 1.86481, 1, 0, 0.261643,0.00551466)    );
  // itree = 1608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0136054,-0.0683348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190445,0.000990869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527211,-0.0150736) , 
3, 1.17602, 1, 0, 0.244786,-0.00432178) , 
2, -1.52711, 1, 0, 0.227527,-0.00723533)    );
  // itree = 1609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,-0.00600999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35473,-0.00304168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179873,-0.00396247) , 
3, -0.481655, 1, 0, 0.235707,0.0099391) , 
0, -1.2923, 1, 0, 0.245821,0.0131189)    );
  // itree = 1610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,0.00498051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288562,0.0104171) , 
1, -0.53461, 1, 0, 0.274224,-0.00796026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0822857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283708,-0.00155052) , 
2, -0.0167021, 1, 0, 0.20911,0.0159093) , 
1, 1.28142, 1, 0, 0.258972,-0.0023691)    );
  // itree = 1611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18254,-0.0163386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284298,-0.00458673) , 
3, 0.0631277, 1, 0, 0.220707,0.0129739) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535849,0.0236913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216049,0.0262603) , 
2, 1.19838, 1, 0, 0.41452,-0.0282387) , 
0, 0.944261, 1, 0, 0.261275,0.0043475)    );
  // itree = 1612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190635,0.0132689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0325733,-0.0727565) , 
2, 0.744255, 1, 0, 0.15835,0.00301906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406349,-0.0285367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582938,0.0171368) , 
2, 1.19475, 1, 0, 0.477186,-0.0133094) , 
3, 0.802707, 1, 0, 0.241005,-0.00121396)    );
  // itree = 1613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40367,0.0061654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274235,0.00269418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0505837,-0.0227716) , 
3, 1.39666, 1, 0, 0.24274,0.00563089) , 
0, -1.7049, 1, 0, 0.25181,0.00995383)    );
  // itree = 1614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374784,0.00173749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126316,-0.0132736) , 
3, -0.467933, 1, 0, 0.262808,0.00962792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323344,0.00232975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143322,0.0191091) , 
3, 0.957296, 1, 0, 0.264612,-0.0168006) , 
1, 0.431825, 1, 0, 0.263659,-0.00283786)    );
  // itree = 1615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875,-0.0266806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357542,0.0532348) , 
2, -0.985937, 1, 0, 0.230089,-0.0189043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0724638,-0.0305691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250633,-0.00886615) , 
0, -0.916166, 1, 0, 0.236321,0.0107994) , 
3, -1.40089, 1, 0, 0.235294,0.00590414)    );
  // itree = 1616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0448097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253793,0.0101754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259375,-0.0150284) , 
0, 1.06608, 1, 0, 0.254802,0.00436159) , 
1, -1.42227, 1, 0, 0.248929,0.0014572)    );
  // itree = 1617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375435,0.00295575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156307,-0.0117153) , 
3, -0.364179, 1, 0, 0.252938,0.00397272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,-0.0111614) , 
1, 1.68641, 1, 0, 0.245997,0.00623376)    );
  // itree = 1618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143791,-0.025741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371841,-0.0140801) , 
2, -0.916476, 1, 0, 0.290698,0.0193711) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,0.00306249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242888,0.00866766) , 
1, -0.83377, 1, 0, 0.236328,-0.0110117) , 
0, -0.691888, 1, 0, 0.24822,-0.00436641)    );
  // itree = 1619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167539,0.0126665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200337,-0.0123526) , 
3, -1.18853, 1, 0, 0.192357,0.0183014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471698,0.0330699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391061,0.0254773) , 
1, 0.612701, 1, 0, 0.434783,-0.0197802) , 
0, 0.944261, 1, 0, 0.240694,0.0107084)    );
  // itree = 1620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260417,0.0759883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166537,-0.000752844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530957,0.0194491) , 
3, 0.708978, 1, 0, 0.273377,0.0094936) , 
0, -1.7049, 1, 0, 0.272727,0.0127778)    );
  // itree = 1621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521739,0.00250363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325048,-0.00271933) , 
3, -1.15288, 1, 0, 0.396594,0.0115571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172727,-0.00608198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146641,0.00301893) , 
0, -0.858844, 1, 0, 0.1491,-0.014175) , 
1, 0.0861832, 1, 0, 0.251383,-0.00354062)    );
  // itree = 1622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,-0.00590284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256602,-0.000100533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328244,-0.00989303) , 
2, 1.78144, 1, 0, 0.261612,-0.00691629) , 
1, -1.23776, 1, 0, 0.255528,-0.00370917)    );
  // itree = 1623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175336,-0.00414549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264706,0.00507194) , 
2, 0.662437, 1, 0, 0.196679,0.00331512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511706,0.0379146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315152,0.00087159) , 
0, 1.4451, 1, 0, 0.44181,-0.0280876) , 
0, 0.900791, 1, 0, 0.252709,-0.00386264)    );
  // itree = 1624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226092,-0.000696635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595588,-0.0369477) , 
3, 1.65076, 1, 0, 0.251928,-0.00497261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483333,0.0289656) , 
1, 1.68939, 1, 0, 0.265375,-0.00132998)    );
  // itree = 1625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.646018,0.0184707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407035,0.0217873) , 
0, -0.982756, 1, 0, 0.49359,-0.0292514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218866,-0.000649869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.027027,-0.0511164) , 
3, 1.88413, 1, 0, 0.206578,0.0164914) , 
2, -1.05527, 1, 0, 0.250367,0.00951253)    );
  // itree = 1626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339142,0.0058264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.042328,-0.0425219) , 
3, 0.39728, 1, 0, 0.279144,0.01457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306931,0.0129832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232583,-0.000305248) , 
1, 0.489077, 1, 0, 0.239845,-0.0044482) , 
1, 0.344779, 1, 0, 0.258507,0.00458277)    );
  // itree = 1627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,0.0156122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112103,-0.0141324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456163,0.00267654) , 
1, 0.697232, 1, 0, 0.262953,0.00728344) , 
3, -1.74385, 1, 0, 0.248101,0.00482)    );
  // itree = 1628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238777,0.0238346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0357143,-0.0335368) , 
0, 1.03558, 1, 0, 0.219154,0.0171904) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284418,-0.0260525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47191,0.0164949) , 
0, 1.27832, 1, 0, 0.324195,-0.0132968) , 
2, 0.38325, 1, 0, 0.263263,0.0043882)    );
  // itree = 1629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387872,0.0056292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138614,0.00133123) , 
3, -0.155467, 1, 0, 0.276407,0.013498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123077,-0.0378818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171429,0.0239622) , 
3, 0.793426, 1, 0, 0.15,-0.0311128) , 
0, 0.956597, 1, 0, 0.248887,0.00378563)    );
  // itree = 1630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352049,0.0058711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145228,-0.0088446) , 
3, -0.616979, 1, 0, 0.229205,0.00986927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327402,0.0056743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362903,-0.00202779) , 
2, 1.80818, 1, 0, 0.338272,-0.0255076) , 
2, 1.12881, 1, 0, 0.250986,0.00280437)    );
  // itree = 1631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0514403,-0.0146202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31284,-0.00656426) , 
1, -0.475808, 1, 0, 0.241107,0.00217269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443478,0.0372837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134228,-0.00778211) , 
2, 1.76034, 1, 0, 0.268939,-0.0358743) , 
2, 1.46433, 1, 0, 0.244717,-0.00276314)    );
  // itree = 1632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258251,0.0199072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103226,-0.0177952) , 
0, 0.590144, 1, 0, 0.215265,0.00911673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.676692,-0.00443844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598726,0.0424333) , 
1, 1.16357, 1, 0, 0.634483,0.0474241) , 
3, 1.3043, 1, 0, 0.277072,0.0147645)    );
  // itree = 1633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425806,-0.00745988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261925,-0.00827748) , 
3, -1.1996, 1, 0, 0.296651,0.0173292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0647059,-0.00592802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142222,0.0264967) , 
0, 0.339898, 1, 0, 0.0955752,-0.00995155) , 
1, 1.17822, 1, 0, 0.240631,0.00972876)    );
  // itree = 1634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186072,-0.00173305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353559,0.00556757) , 
2, 0.0505464, 1, 0, 0.266892,0.0028992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104478,0.0415677) , 
3, 1.71106, 1, 0, 0.255497,-0.00354861)    );
  // itree = 1635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.096181,-0.015186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137109,-0.0109864) , 
3, -0.388717, 1, 0, 0.11611,0.0147689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6,0.00880191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241135,-0.0199544) , 
3, 1.59135, 1, 0, 0.521061,-0.00562778) , 
1, 1.02223, 1, 0, 0.244676,0.00829329)    );
  // itree = 1636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201236,0.00731831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.077135,-0.0822834) , 
2, 0.628441, 1, 0, 0.171123,-0.00482851) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387665,-0.00703535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628205,0.0284265) , 
2, 0.916434, 1, 0, 0.509761,0.0220422) , 
3, 0.897545, 1, 0, 0.250894,0.00150127)    );
  // itree = 1637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483871,-0.000484736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280374,0.00394247) , 
3, -1.69813, 1, 0, 0.35503,0.0254097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265823,0.00142452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108761,0.0250819) , 
3, 1.17029, 1, 0, 0.233229,-0.00450123) , 
0, -0.837233, 1, 0, 0.254527,0.000728933)    );
  // itree = 1638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383648,-0.00615913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291834,0.00481281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195005,-0.00973723) , 
0, -0.0889264, 1, 0, 0.235459,-0.00174994) , 
0, -1.43147, 1, 0, 0.24756,0.00111455)    );
  // itree = 1639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0710383,-0.00447726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321236,-0.00288391) , 
1, -0.33754, 1, 0, 0.246746,-0.00576862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182353,0.0276566) , 
3, 1.73078, 1, 0, 0.241311,-0.00933666)    );
  // itree = 1640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0227273,-0.0494172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267052,0.0133044) , 
3, -1.39165, 1, 0, 0.217512,0.00567922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,-0.0873409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306773,-0.0127671) , 
2, 0.505829, 1, 0, 0.292541,-0.0238187) , 
2, 0.30194, 1, 0, 0.250643,-0.00734665)    );
  // itree = 1641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33244,0.00679542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273973,-0.0560619) , 
3, 1.22545, 1, 0, 0.30525,0.00255028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128713,0.0121511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0716846,-0.00562299) , 
1, 0.808479, 1, 0, 0.0868421,-0.0401245) , 
2, 1.08337, 1, 0, 0.264123,-0.00548561)    );
  // itree = 1642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255268,-0.00504632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00787402,-0.0594156) , 
3, 1.5254, 1, 0, 0.237696,0.00591546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0707965,-0.0281084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216981,-0.00298821) , 
1, 0.501597, 1, 0, 0.141553,-0.03229) , 
0, 1.32631, 1, 0, 0.227205,0.00174655)    );
  // itree = 1643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0993136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220716,0.00571738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335135,0.00672678) , 
0, 0.136968, 1, 0, 0.27477,-0.00587185) , 
1, -1.45172, 1, 0, 0.259277,-0.0032641)    );
  // itree = 1644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209677,0.0283632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236654,-0.00413938) , 
0, -1.29447, 1, 0, 0.234149,-0.00129037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412844,0.0282751) , 
2, 1.82177, 1, 0, 0.243371,0.000871274)    );
  // itree = 1645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334884,0.00677794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0696629,-0.0227272) , 
2, 0.741869, 1, 0, 0.266859,0.0013672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190909,0.00721901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127119,0.00241852) , 
2, 0.929672, 1, 0, 0.157895,-0.0306727) , 
0, 1.32355, 1, 0, 0.254203,-0.0023542)    );
  // itree = 1646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244991,0.00673605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315271,0.0101242) , 
2, 1.30511, 1, 0, 0.252308,-0.00672565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290598,-0.0117663) , 
2, 1.82177, 1, 0, 0.254475,-0.00239322)    );
  // itree = 1647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204,0.00470235) , 
3, -1.95603, 1, 0, 0.169154,-0.0144555) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329094,-0.0156302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232365,-0.00414187) , 
2, 0.269021, 1, 0, 0.277367,0.00707482) , 
0, -0.49228, 1, 0, 0.24399,0.000434016)    );
  // itree = 1648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309645,0.0179951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174174,-0.0097793) , 
1, 0.428439, 1, 0, 0.247593,0.0049889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0779643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317021,-0.024644) , 
3, -0.285267, 1, 0, 0.251265,-0.0271363) , 
0, 0.708151, 1, 0, 0.248657,-0.00431753)    );
  // itree = 1649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299046,0.00271806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108696,0.00350609) , 
1, 1.5027, 1, 0, 0.28269,-0.00111159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17193,-0.0178467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131783,0.0546155) , 
3, 1.62257, 1, 0, 0.15942,-0.0226685) , 
0, 0.956597, 1, 0, 0.257426,-0.0055297)    );
  // itree = 1650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128159,-0.0148062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240175,-0.0106448) , 
2, -0.636658, 1, 0, 0.16092,-0.0150633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370031,0.00833219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0724638,-0.0100873) , 
3, 1.46892, 1, 0, 0.318182,0.0231804) , 
2, -0.22187, 1, 0, 0.255708,0.00798771)    );
  // itree = 1651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255615,0.0089632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267959,0.00262361) , 
2, 0.0167879, 1, 0, 0.261589,0.000510383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335821,-0.0208285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12381,-0.018089) , 
0, 1.19527, 1, 0, 0.242678,0.0370942) , 
3, 1.45397, 1, 0, 0.259386,0.00477344)    );
  // itree = 1652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163399,-0.0171258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380952,0.0137347) , 
2, -0.070749, 1, 0, 0.275884,0.000337808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.096463,-0.0474392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382353,0.0139319) , 
2, 1.50105, 1, 0, 0.183445,-0.0217336) , 
1, 1.29547, 1, 0, 0.255539,-0.00451985)    );
  // itree = 1653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360553,0.00878104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0387597,-0.0122655) , 
3, 0.642441, 1, 0, 0.315676,-0.0149586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2267,-0.00747414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0842105,-0.0123009) , 
3, 1.17437, 1, 0, 0.189064,0.0102623) , 
0, -0.0763418, 1, 0, 0.247505,-0.00137906)    );
  // itree = 1654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20339,0.00177166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409253,0.0116359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242462,0.00662584) , 
0, -0.898907, 1, 0, 0.267485,2.23944e-05) , 
1, -1.23776, 1, 0, 0.261951,-0.00343541)    );
  // itree = 1655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0788382,-0.0130783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111727,-0.0200188) , 
3, -1.33982, 1, 0, 0.10574,0.0130249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.709898,0.024675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414365,-0.00324717) , 
3, 0.393957, 1, 0, 0.546565,-0.014835) , 
1, 1.01701, 1, 0, 0.251642,0.00380393)    );
  // itree = 1656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114603,0.000435346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368497,0.0223252) , 
3, 0.0438207, 1, 0, 0.213641,0.0111643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561905,-0.0770568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548077,0.00250162) , 
1, 1.25983, 1, 0, 0.555024,-0.0570968) , 
3, 1.57074, 1, 0, 0.249622,0.00396988)    );
  // itree = 1657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41675,0.00820288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,0.00674134) , 
3, 0.881124, 1, 0, 0.383128,-0.0112019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119159,-0.00679245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10962,0.00218571) , 
3, 0.412945, 1, 0, 0.114286,0.0088319) , 
1, 0.583399, 1, 0, 0.266269,-0.0024937)    );
  // itree = 1658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368,-0.0264732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251882,0.00634126) , 
0, -1.52623, 1, 0, 0.259719,0.00438716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476923,0.0376785) , 
1, 1.65151, 1, 0, 0.273966,-1.67386e-05)    );
  // itree = 1659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196194,-0.00386192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472141,0.0101378) , 
0, 1.00058, 1, 0, 0.246649,0.00344564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175325,-0.0301504) , 
1, 1.54903, 1, 0, 0.241209,0.00116423)    );
  // itree = 1660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235981,0.00831286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219067,-0.0177348) , 
0, -0.727763, 1, 0, 0.222863,-0.0105268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457944,0.0285061) , 
2, 1.85179, 1, 0, 0.235353,-0.00768018)    );
  // itree = 1661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371069,-0.0113356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,-0.0147778) , 
1, 0.784032, 1, 0, 0.302381,0.0405841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24208,-0.00319956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0984849,0.0236523) , 
3, 1.32646, 1, 0, 0.216722,0.00493784) , 
0, -0.727763, 1, 0, 0.235509,0.0127558)    );
  // itree = 1662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370945,0.007688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139746,-0.00511298) , 
3, -0.226556, 1, 0, 0.269841,0.0100252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188679,-0.0176077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222411,0.00875159) , 
0, -0.507772, 1, 0, 0.215241,-0.0168786) , 
1, 0.767416, 1, 0, 0.249502,3.28268e-06)    );
  // itree = 1663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0125,0.169136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136104,-0.0127042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580247,0.0219781) , 
1, 1.10981, 1, 0, 0.276477,0.00460168) , 
1, -1.3293, 1, 0, 0.254862,0.0100871)    );
  // itree = 1664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143271,0.00582018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4447,0.0260933) , 
3, 0.525669, 1, 0, 0.215308,0.0116784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597884,-0.0188914) , 
3, 1.56352, 1, 0, 0.251372,0.00724861)    );
  // itree = 1665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553191,0.0125633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260504,-0.00141253) , 
3, -1.64986, 1, 0, 0.369393,0.024943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632353,0.0292017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203839,0.00248416) , 
1, -1.19679, 1, 0, 0.239223,-0.00806561) , 
0, -0.796057, 1, 0, 0.263574,-0.00189075)    );
  // itree = 1666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335059,0.00761021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125926,-0.0239217) , 
3, 0.571943, 1, 0, 0.300247,-0.00488506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115789,0.0109608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0612245,-0.017624) , 
3, 1.71468, 1, 0, 0.0919881,0.0424501) , 
3, 1.14622, 1, 0, 0.264421,0.00325785)    );
  // itree = 1667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229965,-0.00188494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361702,0.0225611) , 
3, 0.844783, 1, 0, 0.257316,-0.00285661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428571,0.00944974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113208,-0.0411965) , 
3, 1.08051, 1, 0, 0.28,0.0336795) , 
1, 1.50469, 1, 0, 0.259823,0.00118103)    );
  // itree = 1668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335484,0.0553076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289474,0.00915301) , 
0, -0.589147, 1, 0, 0.310145,0.0349729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192852,-0.0126174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655,0.0175554) , 
3, 1.62307, 1, 0, 0.247772,-0.00481946) , 
1, -0.840753, 1, 0, 0.258383,0.00194996)    );
  // itree = 1669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380165,0.00724988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18,-0.0144858) , 
2, -0.0997722, 1, 0, 0.305865,0.0104737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102421,0.0180116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207921,0.0217258) , 
0, 1.4768, 1, 0, 0.119122,-0.0166273) , 
2, 0.648293, 1, 0, 0.245844,0.00176318)    );
  // itree = 1670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277151,0.00296907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0118343,-0.0661151) , 
3, 0.928947, 1, 0, 0.226082,-0.00624233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477876,-0.00627075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21,0.0121711) , 
3, 1.09697, 1, 0, 0.352113,0.0362136) , 
2, 1.49351, 1, 0, 0.239716,-0.00164958)    );
  // itree = 1671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0770143) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221744,-0.0092616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310415,-0.00561451) , 
0, 0.134775, 1, 0, 0.267466,0.00363607) , 
0, -1.43147, 1, 0, 0.246279,0.000251839)    );
  // itree = 1672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0570175,-0.0173096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471698,0.0416766) , 
3, -1.11181, 1, 0, 0.256818,0.0237921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182517,-0.00614865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809917,0.0224658) , 
3, 1.85865, 1, 0, 0.231464,-0.00162321) , 
1, -0.484715, 1, 0, 0.237067,0.00399343)    );
  // itree = 1673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27652,0.00333001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0289855,-0.0261685) , 
3, 1.62424, 1, 0, 0.257709,-0.0135344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156522,0.0124222) , 
1, 1.62191, 1, 0, 0.251683,-0.0109842)    );
  // itree = 1674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215686,0.00567528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309707,0.00307904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232902,0.00585143) , 
0, -0.244376, 1, 0, 0.261698,0.00476768) , 
1, -1.24613, 1, 0, 0.257962,0.000822206)    );
  // itree = 1675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228643,0.0284436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244688,0.00276712) , 
3, -1.19852, 1, 0, 0.241249,0.00605439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0357662) , 
2, 1.82177, 1, 0, 0.234663,0.00912079)    );
  // itree = 1676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261398,0.00427378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238095,-0.041393) , 
0, -0.0794829, 1, 0, 0.253521,-0.0112732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293103,0.0544828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253165,0.0109161) , 
1, -0.226026, 1, 0, 0.256177,0.0128967) , 
1, -0.421021, 1, 0, 0.255528,0.00699378)    );
  // itree = 1677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414508,-0.0186745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447811,0.00932016) , 
0, -0.611514, 1, 0, 0.434694,0.0147866) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270358,0.00972763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174578,0.00287754) , 
0, -0.617366, 1, 0, 0.193548,-0.00901965) , 
1, -0.421021, 1, 0, 0.251471,-0.00330149)    );
  // itree = 1678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413174,0.0129331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234724,-0.0103022) , 
3, -1.24415, 1, 0, 0.278388,0.0125481) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12931,0.0165189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217699,0.00249164) , 
1, -0.366642, 1, 0, 0.202643,-0.0307553) , 
0, 0.530412, 1, 0, 0.253177,-0.00186519)    );
  // itree = 1679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295606,0.0208803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186441,0.0159347) , 
2, -0.251668, 1, 0, 0.280783,-0.0264828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299578,0.0240452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180404,-0.0193965) , 
3, 0.206848, 1, 0, 0.230976,0.0235737) , 
2, -0.0855223, 1, 0, 0.252769,0.00167083)    );
  // itree = 1680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213325,0.00795741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582524,0.0220593) , 
3, 1.31412, 1, 0, 0.254615,0.0102949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291925,-0.0156585) , 
1, 1.56373, 1, 0, 0.257614,0.0076713)    );
  // itree = 1681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402311,0.00712575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0185185,-0.0602251) , 
3, 0.925716, 1, 0, 0.363208,-0.0111092) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105155,-0.0146305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875706,-0.0243438) , 
3, 0.826941, 1, 0, 0.0977354,0.00692892) , 
2, 0.314309, 1, 0, 0.245919,-0.00313977)    );
  // itree = 1682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289024,-0.00144432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0647773,-0.029966) , 
3, 1.07371, 1, 0, 0.259671,-0.00276121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0754717,0.0142991) , 
3, 1.69879, 1, 0, 0.245357,-0.00895425)    );
  // itree = 1683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.079575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587719,0.0681555) , 
1, 0.655646, 1, 0, 0.150224,-0.022657) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275918,-0.0079019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282759,0.0200325) , 
2, 1.27239, 1, 0, 0.277228,0.0031907) , 
0, -0.727763, 1, 0, 0.248343,-0.00268797)    );
  // itree = 1684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204774,-0.022586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244282,0.0062766) , 
0, -0.219079, 1, 0, 0.227634,-0.00557069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339286,-0.0403506) , 
1, 1.65151, 1, 0, 0.233883,-0.00889857)    );
  // itree = 1685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664,0.0228286) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,0.0114991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207738,-0.007246) , 
0, -1.05662, 1, 0, 0.222517,0.00421666) , 
1, -1.42458, 1, 0, 0.25,0.000588542)    );
  // itree = 1686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295714,-0.00853153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206667,-0.0170687) , 
0, -0.401729, 1, 0, 0.28,0.0224534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278137,-0.000943528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.0038863) , 
3, 0.796812, 1, 0, 0.215474,0.000614307) , 
0, -0.236551, 1, 0, 0.242203,0.00966071)    );
  // itree = 1687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0760147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,0.0490667) , 
0, -0.41159, 1, 0, 0.085034,-0.0356431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292909,-0.0044782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240506,0.00528191) , 
2, 1.56032, 1, 0, 0.285796,0.00705324) , 
1, -0.840753, 1, 0, 0.256863,0.000899948)    );
  // itree = 1688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267857,0.0385922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254973,0.00556868) , 
1, -1.12426, 1, 0, 0.256158,0.00832559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413462,-0.0291376) , 
0, 1.55221, 1, 0, 0.26463,0.00518089)    );
  // itree = 1689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289337,-0.00574177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0710227,-0.00359363) , 
2, 1.01291, 1, 0, 0.248677,0.000624425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126126,-0.00371863) , 
1, 1.68939, 1, 0, 0.241879,0.00351686)    );
  // itree = 1690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241794,0.00332062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.021164,-0.047494) , 
0, 0.774762, 1, 0, 0.203989,-0.00959516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300699,0.00940629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31811,-0.00357775) , 
2, 0.628023, 1, 0, 0.312704,0.00731915) , 
2, 0.213212, 1, 0, 0.253458,-0.00189848)    );
  // itree = 1691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193333,-0.000155372) , 
3, -1.96773, 1, 0, 0.15371,0.00477252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36673,0.0327594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267522,0.000399832) , 
3, -0.285631, 1, 0, 0.301556,-0.0170831) , 
0, -0.617366, 1, 0, 0.26186,-0.0112149)    );
  // itree = 1692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209916,-0.00776495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18018,-0.042365) , 
2, 0.961435, 1, 0, 0.207933,-0.00932138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458904,0.0351293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286996,-0.00551107) , 
1, 1.12839, 1, 0, 0.355014,0.0110521) , 
2, 1.17781, 1, 0, 0.234629,-0.00562349)    );
  // itree = 1693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.631579,0.0138428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438914,0.00671836) , 
1, -1.45282, 1, 0, 0.511299,-0.0348404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271222,-0.00236897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0960758,-0.00859867) , 
2, 0.561844, 1, 0, 0.195308,0.0022141) , 
1, -0.796791, 1, 0, 0.249636,-0.00415661)    );
  // itree = 1694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309953,-0.00100368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144254,-0.00842031) , 
0, 0.782376, 1, 0, 0.263661,0.00788714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239583,0.00583848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162698,0.00596166) , 
3, 0.788606, 1, 0, 0.203704,-0.0159314) , 
1, 1.13266, 1, 0, 0.247505,0.00146896)    );
  // itree = 1695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197183,0.0265345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257108,0.0166629) , 
2, -1.4503, 1, 0, 0.24816,-0.0100817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381579,0.00389404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238789,-0.0142219) , 
0, -0.42269, 1, 0, 0.259579,0.010988) , 
3, -0.207485, 1, 0, 0.254135,0.000944227)    );
  // itree = 1696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.0641852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259484,0.00653909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251701,-0.0185956) , 
0, 0.680132, 1, 0, 0.257083,-0.00172222) , 
0, -1.61174, 1, 0, 0.248139,-0.00508271)    );
  // itree = 1697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299228,-0.00469305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285489,0.0144798) , 
0, 0.210765, 1, 0, 0.294012,-0.00142531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0636364,-0.0235119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10929,0.0262449) , 
1, 0.886102, 1, 0, 0.0921502,0.0234424) , 
3, 1.29328, 1, 0, 0.263882,0.00228648)    );
  // itree = 1698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22293,0.0191347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276923,0.00200127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160156,0.00535677) , 
0, 1.2265, 1, 0, 0.259852,-0.00822307) , 
1, -1.21515, 1, 0, 0.256813,-0.0109775)    );
  // itree = 1699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131973,-0.0219552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259677,-0.0146017) , 
3, -0.311854, 1, 0, 0.190406,0.00573208) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537356,0.0335999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193416,-0.00532474) , 
2, 0.877064, 1, 0, 0.395939,-0.0154909) , 
0, 0.6269, 1, 0, 0.252826,-0.00071335)    );
  // itree = 1700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195918,-0.000902749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354545,-0.0272148) , 
3, 1.41258, 1, 0, 0.205479,-0.00382966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705128,0.0139774) , 
3, 1.73078, 1, 0, 0.244826,-0.00148281)    );
  // itree = 1701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622951,0.0125793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23125,0.00263811) , 
2, -1.1821, 1, 0, 0.339367,0.0187851) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243974,0.00654201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156716,0.0254313) , 
1, 1.57058, 1, 0, 0.236194,-0.0048794) , 
0, -0.691888, 1, 0, 0.25964,0.000498333)    );
  // itree = 1702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249479,0.00191277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0875411) , 
3, 1.14278, 1, 0, 0.227215,-0.00859884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435811,0.00473629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0597015,-0.0497989) , 
3, 1.57489, 1, 0, 0.318605,0.0119471) , 
2, 0.937895, 1, 0, 0.246766,-0.00420344)    );
  // itree = 1703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0688468,-0.0206418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102526,-0.0255466) , 
3, -0.611724, 1, 0, 0.0869218,0.0122341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535256,0.0115545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403409,-0.00181693) , 
0, -0.0972321, 1, 0, 0.452381,-0.0178545) , 
1, 0.670673, 1, 0, 0.233524,0.000164183)    );
  // itree = 1704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21659,0.00482668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703704,0.0276925) , 
3, 0.893392, 1, 0, 0.279872,0.00934001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131387,-0.0704809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175,-0.0080991) , 
1, 1.01579, 1, 0, 0.16731,-0.0195479) , 
1, 0.75851, 1, 0, 0.23666,-0.00174986)    );
  // itree = 1705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324191,0.00457351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0520607,-0.035052) , 
2, 0.810561, 1, 0, 0.257568,0.00162237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182353,-0.00291084) , 
0, 1.44542, 1, 0, 0.251339,-0.00149095)    );
  // itree = 1706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0699301,-0.0412934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273499,0.0115702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.0116932) , 
1, 1.54293, 1, 0, 0.282884,0.00185488) , 
2, -1.52711, 1, 0, 0.267347,-0.00138024)    );
  // itree = 1707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190813,0.00458559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373476,0.00538526) , 
0, 0.316369, 1, 0, 0.25783,-0.000660366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2375,0.0361586) , 
3, 1.73078, 1, 0, 0.25616,-0.00718949)    );
  // itree = 1708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17765,0.0219806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250771,-0.00930579) , 
2, -0.291606, 1, 0, 0.220227,0.00297663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.639344,0.00889941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573643,0.0401414) , 
1, 1.38231, 1, 0, 0.612179,0.0428719) , 
3, 1.27365, 1, 0, 0.281896,0.00925364)    );
  // itree = 1709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521739,0.00417085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0310078,-0.0720551) , 
2, -0.428342, 1, 0, 0.365432,-0.0169039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243728,-0.0313103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204856,0.00576743) , 
2, -0.672603, 1, 0, 0.211647,0.00509147) , 
3, -1.18088, 1, 0, 0.242757,0.000641866)    );
  // itree = 1710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365994,-0.000150607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196648,0.0164301) , 
3, -0.464913, 1, 0, 0.27061,0.0075087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180328,-0.000177523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375887,0.0135206) , 
2, 1.24735, 1, 0, 0.251948,-0.029079) , 
1, 1.35324, 1, 0, 0.266971,0.000372792)    );
  // itree = 1711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0800497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653631,0.0240131) , 
1, 0.822487, 1, 0, 0.189935,0.0351723) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151194,0.0220815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330724,-0.00332632) , 
1, -0.128677, 1, 0, 0.282345,0.00323581) , 
0, -0.488206, 1, 0, 0.254094,0.012999)    );
  // itree = 1712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203488,0.0038917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211679,-0.0548385) , 
0, -0.443026, 1, 0, 0.20712,-0.0256574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324022,0.0372052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250494,-0.00154726) , 
1, -0.434153, 1, 0, 0.258255,0.00271834) , 
1, -0.812876, 1, 0, 0.250374,-0.00165478)    );
  // itree = 1713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632812,0.0147415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229885,-0.00943873) , 
2, -0.979921, 1, 0, 0.379161,-0.0113241) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0708661,-0.030177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203273,0.00786875) , 
0, -0.680446, 1, 0, 0.190217,0.00858004) , 
3, -0.632362, 1, 0, 0.25619,0.00163017)    );
  // itree = 1714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315607,-0.00690461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170512,-0.00868511) , 
3, -0.334141, 1, 0, 0.237916,0.00697232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228571,0.0396979) , 
0, 1.55221, 1, 0, 0.237417,0.00309595)    );
  // itree = 1715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281359,0.0127887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253991,-0.0032254) , 
2, 0.390849, 1, 0, 0.271094,-0.00443037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0508475,-0.0645643) , 
1, 1.65151, 1, 0, 0.257801,-0.00901499)    );
  // itree = 1716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19105,0.00703407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470238,0.0268531) , 
3, 1.0913, 1, 0, 0.215594,0.00934376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608939,-0.0307497) , 
3, 1.61709, 1, 0, 0.249282,0.00364705)    );
  // itree = 1717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479769,-0.000933992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188802,-0.00204217) , 
1, -0.689672, 1, 0, 0.242295,0.00266541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252336,0.0349299) , 
0, 1.55221, 1, 0, 0.242836,-0.000834987)    );
  // itree = 1718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283088,0.00189156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00626959,-0.0800323) , 
3, 0.764107, 1, 0, 0.230494,0.0166981) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306011,0.01317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404255,0.0105793) , 
2, 1.72562, 1, 0, 0.348765,-0.0177443) , 
2, 1.19224, 1, 0, 0.249626,0.0111268)    );
  // itree = 1719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239808,-0.00108044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48731,0.0098753) , 
1, 1.46286, 1, 0, 0.265952,0.00294226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156863,0.0139055) , 
3, 1.76176, 1, 0, 0.257681,0.00630882)    );
  // itree = 1720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118881,-0.00744807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251748,-0.0562714) , 
2, -0.997521, 1, 0, 0.185315,-0.0364144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178191,-0.00152624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620209,0.0208646) , 
3, 1.34571, 1, 0, 0.249023,0.00493792) , 
1, -0.910541, 1, 0, 0.24025,-0.000756234)    );
  // itree = 1721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300423,-0.00231656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107399,0.019298) , 
3, 0.773693, 1, 0, 0.256396,-0.008097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184211,0.000413406) , 
0, 1.49754, 1, 0, 0.252178,-0.0053377)    );
  // itree = 1722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356481,0.00618375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159964,-0.00846899) , 
3, -0.706049, 1, 0, 0.232032,0.0115305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403846,0.0231823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393162,0.0199028) , 
1, 1.40271, 1, 0, 0.39819,-0.0261813) , 
2, 1.51846, 1, 0, 0.250503,0.0073382)    );
  // itree = 1723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308756,0.0155032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241104,-0.00903511) , 
2, -0.802648, 1, 0, 0.257316,-0.00220453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0416667,-0.0546177) , 
1, 1.68939, 1, 0, 0.24646,-7.18478e-06)    );
  // itree = 1724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118644,0.0180583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584559,0.0404881) , 
3, -0.409074, 1, 0, 0.288978,0.0295903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0420842,-0.00531112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374491,-0.0214481) , 
3, 0.0759578, 1, 0, 0.240291,-0.0183601) , 
1, -0.0132411, 1, 0, 0.258586,-0.000342371)    );
  // itree = 1725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582192,0.00375439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238434,0.0276251) , 
2, -0.937239, 1, 0, 0.355972,-0.0165852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229072,-0.00599578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.087156,-0.0137027) , 
1, 1.49547, 1, 0, 0.208877,0.00650904) , 
0, -0.727763, 1, 0, 0.240939,0.00147523)    );
  // itree = 1726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304223,0.0114819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176955,-0.0102937) , 
1, 1.17822, 1, 0, 0.271375,-0.0167077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217822,0.0154783) , 
0, 1.55221, 1, 0, 0.268649,-0.0124452)    );
  // itree = 1727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246851,0.0227179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208571,0.00828889) , 
3, -1.18915, 1, 0, 0.228916,-0.0109624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21916,-0.0101189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266284,-0.00853269) , 
3, 0.764907, 1, 0, 0.238318,0.0270027) , 
3, -0.578844, 1, 0, 0.23486,0.0130392)    );
  // itree = 1728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293279,0.0228362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389961,-0.0199951) , 
2, 0.648181, 1, 0, 0.313457,0.0144791) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0582011,-0.0447298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293362,0.00669681) , 
2, 0.583555, 1, 0, 0.188166,-0.00798558) , 
1, 0.75851, 1, 0, 0.262704,0.00537908)    );
  // itree = 1729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35503,-0.0117144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212409,0.00736505) , 
3, -0.903884, 1, 0, 0.250932,0.00180371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0677966,-0.000919777) , 
2, 1.85179, 1, 0, 0.2401,-0.000518562)    );
  // itree = 1730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207384,-0.0115143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437372,0.00434504) , 
2, 0.545702, 1, 0, 0.271023,0.0101215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0755814,0.00505148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,0.0033584) , 
3, 1.8172, 1, 0, 0.0719178,-0.047486) , 
3, 1.23573, 1, 0, 0.24269,0.00192396)    );
  // itree = 1731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0763345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260719,-0.00703352) , 
0, -1.42422, 1, 0, 0.236068,-0.00744565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.713115,0.0436848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0949367,-0.0420969) , 
2, 0.582159, 1, 0, 0.267123,0.053081) , 
3, 1.00886, 1, 0, 0.242752,0.00558171)    );
  // itree = 1732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0829533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22093,5.17225e-05) , 
3, -2.03269, 1, 0, 0.207877,-0.00282344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72549,0.0277999) , 
3, 1.73078, 1, 0, 0.247855,0.00158001)    );
  // itree = 1733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312613,0.00482178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0245902,-0.0449585) , 
2, 1.17435, 1, 0, 0.284091,-0.00964557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221757,-0.0133542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0913706,0.00672225) , 
2, 1.20143, 1, 0, 0.183704,0.010212) , 
0, 0.446909, 1, 0, 0.248558,-0.00261682)    );
  // itree = 1734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200952,-0.00336638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371274,0.00481451) , 
2, 0.280775, 1, 0, 0.271253,-0.0103431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0793838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104762,-0.0153378) , 
1, 1.26298, 1, 0, 0.0536585,0.0532001) , 
3, 1.56809, 1, 0, 0.248871,-0.00380708)    );
  // itree = 1735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203681,-0.0132321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556213,0.00837979) , 
0, 1.10657, 1, 0, 0.236798,-0.00333574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321168,0.0126617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196078,-0.0227139) , 
1, 1.35259, 1, 0, 0.267782,0.0419544) , 
3, 1.45397, 1, 0, 0.240432,0.00197552)    );
  // itree = 1736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00943396,-0.0710374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197411,0.000271443) , 
2, -1.61477, 1, 0, 0.185342,-0.00216977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.00693075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734043,0.0456354) , 
2, 0.902897, 1, 0, 0.570978,0.048059) , 
3, 1.22047, 1, 0, 0.247459,0.00592095)    );
  // itree = 1737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462025,-0.0113196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431034,-0.00127934) , 
0, -0.978708, 1, 0, 0.440711,0.0174564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218081,0.00509607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0787037,0.00519925) , 
3, 1.49459, 1, 0, 0.197698,-0.00624436) , 
1, -0.418323, 1, 0, 0.259708,-0.000196647)    );
  // itree = 1738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353448,-0.0365045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264195,0.00364145) , 
0, -1.51484, 1, 0, 0.269815,-0.00783493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179612,0.0247062) , 
0, 1.40235, 1, 0, 0.260742,-0.00348437)    );
  // itree = 1739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037931,-0.046411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289256,0.00279854) , 
0, -0.930295, 1, 0, 0.240667,0.00402504) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570248,0.0810666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216578,-0.00572295) , 
0, 0.160665, 1, 0, 0.30303,-0.0364994) , 
3, 0.824791, 1, 0, 0.25614,-0.00602989)    );
  // itree = 1740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168243,0.00311966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548098,0.0237812) , 
3, 0.784824, 1, 0, 0.256357,0.0108663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,-0.0481227) , 
2, 1.85179, 1, 0, 0.265556,0.00599695)    );
  // itree = 1741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469136,-0.00170404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192531,-0.000789174) , 
1, -0.774615, 1, 0, 0.240277,-0.00332568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172727,-0.00686759) , 
0, 1.61599, 1, 0, 0.236537,-0.00757729)    );
  // itree = 1742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24,0.00400332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300813,-0.000658146) , 
2, 0.589704, 1, 0, 0.248568,-0.00856005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398323,0.0194001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162461,-0.00262351) , 
3, 0.206735, 1, 0, 0.263726,0.0140382) , 
1, 0.162984, 1, 0, 0.257056,0.00409453)    );
  // itree = 1743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,0.0709352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125455,-0.0139984) , 
1, -0.994927, 1, 0, 0.112101,0.00220783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.605882,0.00765376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510563,0.0130952) , 
0, -0.558585, 1, 0, 0.53252,-0.0163447) , 
1, 0.909504, 1, 0, 0.260911,-0.00435898)    );
  // itree = 1744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198658,0.00614335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697802,0.0355701) , 
3, 0.39728, 1, 0, 0.296656,0.0145289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280255,-0.0524693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200448,-0.00629553) , 
1, 0.587758, 1, 0, 0.212381,-0.0116605) , 
1, 0.313785, 1, 0, 0.251897,0.000619518)    );
  // itree = 1745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314614,0.00253666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857843,-0.0119432) , 
2, 0.895948, 1, 0, 0.265111,-0.00039364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.062069,0.0070059) , 
3, 1.74551, 1, 0, 0.250615,0.00261985)    );
  // itree = 1746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369369,0.0118037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0734694,-0.0446915) , 
3, -1.00565, 1, 0, 0.214133,0.0292406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311582,-0.00327882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218543,-0.00940957) , 
1, 0.535629, 1, 0, 0.25609,-0.0100817) , 
1, -0.484715, 1, 0, 0.246224,-0.000835196)    );
  // itree = 1747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.077307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26883,0.00843907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256545,0.00244897) , 
3, 1.59101, 1, 0, 0.267606,0.00473013) , 
0, -1.68098, 1, 0, 0.253584,0.00680115)    );
  // itree = 1748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121739,-0.0107763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414474,-0.0552022) , 
3, -0.453747, 1, 0, 0.211268,-0.0309789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258278,0.0283205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294282,-0.00155049) , 
0, 0.159967, 1, 0, 0.275815,0.0118927) , 
1, -0.410129, 1, 0, 0.259523,0.00107135)    );
  // itree = 1749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512545,1.14143e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212276,-0.00321844) , 
1, -0.892044, 1, 0, 0.257732,0.00626354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158273,0.0186211) , 
1, 1.65151, 1, 0, 0.250757,0.0032552)    );
  // itree = 1750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402597,0.013055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235534,-0.0069031) , 
3, -1.39512, 1, 0, 0.264491,0.00404905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10596,0.0217429) , 
3, 1.74459, 1, 0, 0.252075,-0.00418739)    );
  // itree = 1751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191781,-0.00646081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480198,0.0277279) , 
0, 0.662508, 1, 0, 0.25684,0.00572685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407407,-0.0071928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0380952,-0.0307566) , 
2, 1.53446, 1, 0, 0.225352,0.0610634) , 
3, 1.55602, 1, 0, 0.253493,0.0116084)    );
  // itree = 1752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163265,-0.012782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135593,-0.0664136) , 
3, 0.603433, 1, 0, 0.159437,-0.0167727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314885,0.024314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329323,-0.00485187) , 
0, 0.215888, 1, 0, 0.32296,0.00617872) , 
2, -0.0855223, 1, 0, 0.254652,-0.00340871)    );
  // itree = 1753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45,0.0100258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281292,0.00755716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0971867,0.0142847) , 
3, 1.01792, 1, 0, 0.242941,0.000997571) , 
0, -1.68098, 1, 0, 0.253414,0.00318331)    );
  // itree = 1754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184971,-0.00900416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237787,-0.0057876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314815,0.00890843) , 
2, 1.84213, 1, 0, 0.242391,0.00483852) , 
1, -1.19679, 1, 0, 0.237374,0.00915466)    );
  // itree = 1755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200401,-0.0132796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309904,0.00959797) , 
2, 1.0891, 1, 0, 0.219337,-0.000907188) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572973,-0.00440222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0737705,-0.024541) , 
3, 1.42959, 1, 0, 0.374593,0.0332686) , 
0, 1.2265, 1, 0, 0.241852,0.00404887)    );
  // itree = 1756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276923,0.0442374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195971,-0.00565661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656388,0.0262893) , 
3, 1.49665, 1, 0, 0.252011,0.00229426) , 
0, -1.43949, 1, 0, 0.253634,0.00523128)    );
  // itree = 1757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328467,-0.0172517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271296,-0.00756626) , 
0, -0.968524, 1, 0, 0.282866,0.0113238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11501,0.0200636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167939,-0.00383305) , 
0, 1.41703, 1, 0, 0.125776,-0.0284251) , 
3, 0.540694, 1, 0, 0.232232,-0.00148819)    );
  // itree = 1758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369369,0.0352359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123894,-0.00658777) , 
3, -1.50657, 1, 0, 0.245536,0.0277086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222973,-0.0068309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265306,0.00708448) , 
1, -0.420272, 1, 0, 0.258402,-0.0113773) , 
1, -1.12426, 1, 0, 0.256989,-0.00708343)    );
  // itree = 1759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0780805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150794,0.025576) , 
3, -0.781411, 1, 0, 0.0538244,-0.0187903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201741,-0.0201984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0210814) , 
1, 1.34905, 1, 0, 0.267571,0.00359133) , 
1, -0.761509, 1, 0, 0.229367,-0.00040903)    );
  // itree = 1760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134545,-0.0395673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112727,-0.0150719) , 
0, -0.466087, 1, 0, 0.123636,-0.0242029) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0707547,-0.0110514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453461,0.0150887) , 
3, 0.0183182, 1, 0, 0.288331,0.00986707) , 
2, -0.656951, 1, 0, 0.243577,0.000608926)    );
  // itree = 1761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331169,0.0059374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275943,0.0132486) , 
0, -0.643318, 1, 0, 0.290657,-0.00830912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792079,-0.0287415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104575,0.0399486) , 
3, 1.7183, 1, 0, 0.0944882,0.039092) , 
3, 1.36188, 1, 0, 0.265594,-0.00225285)    );
  // itree = 1762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194995,-0.00669457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0779966) , 
3, 0.794289, 1, 0, 0.172669,-0.0122302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39281,0.00759672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0981595,0.00613374) , 
3, 1.58808, 1, 0, 0.340263,0.0179188) , 
2, 0.30194, 1, 0, 0.249374,0.0015686)    );
  // itree = 1763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.105746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292405,0.015751) , 
1, -1.43509, 1, 0, 0.272245,-0.00289063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478261,0.046293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140187,-0.0119629) , 
0, 0.712439, 1, 0, 0.258359,0.0309801) , 
3, 1.22488, 1, 0, 0.26999,0.00260959)    );
  // itree = 1764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137931,0.0164138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0532725,-0.03599) , 
2, -0.980109, 1, 0, 0.0791975,-0.00726139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452221,0.019975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349614,-0.00214868) , 
0, 0.932109, 1, 0, 0.416961,0.0147326) , 
3, -0.213885, 1, 0, 0.263107,0.0047142)    );
  // itree = 1765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510204,-0.0166029) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228946,0.00565816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167568,-0.00490682) , 
0, 1.41877, 1, 0, 0.222595,-0.00795899) , 
1, -1.20023, 1, 0, 0.251008,-0.0023885)    );
  // itree = 1766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459807,0.0245595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208111,-0.00846048) , 
3, -1.17015, 1, 0, 0.270833,0.00874183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158672,-0.013047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.0174934) , 
2, 1.76314, 1, 0, 0.180685,-0.0172298) , 
1, 0.946985, 1, 0, 0.240212,-8.02961e-05)    );
  // itree = 1767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259824,0.0105477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237542,-0.0119219) , 
2, 0.534932, 1, 0, 0.252569,-0.00174878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.0321009) , 
2, 1.82177, 1, 0, 0.245283,-0.0045405)    );
  // itree = 1768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177489,0.0338318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277918,-0.0129896) , 
2, -0.640677, 1, 0, 0.249849,-0.00102693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0470588,-0.03146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592593,-0.0263583) , 
3, 1.43574, 1, 0, 0.288525,-0.0384776) , 
0, 1.17225, 1, 0, 0.255873,-0.00686066)    );
  // itree = 1769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434402,-0.0112712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208,0.00703232) , 
1, -0.404714, 1, 0, 0.271757,0.000540606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241722,-0.00922211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173333,0.0201556) , 
3, 0.415516, 1, 0, 0.20384,-0.039533) , 
0, 0.446909, 1, 0, 0.247493,-0.0137759)    );
  // itree = 1770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382629,0.0050506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251344,0.00897802) , 
0, -0.480903, 1, 0, 0.299145,-0.00716265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228571,0.0166433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214651,0.00165088) , 
0, -0.507772, 1, 0, 0.217848,0.0170097) , 
1, 0.75851, 1, 0, 0.267081,0.00237115)    );
  // itree = 1771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0979463,-0.0185884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594406,0.00361563) , 
1, 0.940933, 1, 0, 0.252448,0.0099487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186667,0.0407292) , 
2, 1.69747, 1, 0, 0.247485,0.00655778)    );
  // itree = 1772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679612,-0.0460483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0488215,-0.0118867) , 
1, -1.37035, 1, 0, 0.0516499,-0.0109481) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363636,0.0198113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331731,-0.0166675) , 
0, 1.23869, 1, 0, 0.358605,0.0142246) , 
3, -0.691091, 1, 0, 0.25248,0.00552152)    );
  // itree = 1773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516129,-0.014405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254125,-0.0190115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237005,0.00230049) , 
0, -0.768546, 1, 0, 0.239708,0.00511927) , 
3, -2.02293, 1, 0, 0.256486,0.00260152)    );
  // itree = 1774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258437,-0.00399626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22585,-0.00595721) , 
1, 0.697188, 1, 0, 0.245567,-0.00750219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100719,0.0219547) , 
3, 1.76021, 1, 0, 0.2355,-0.0114225)    );
  // itree = 1775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0429594,-0.0384461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289578,0.00151526) , 
1, -0.545749, 1, 0, 0.227924,-0.00738098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280303,-0.0313802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261803,0.0258423) , 
3, 1.65173, 1, 0, 0.268493,0.0396929) , 
3, 1.29328, 1, 0, 0.235179,0.00103743)    );
  // itree = 1776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280303,0.0628869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241135,-0.0174755) , 
1, -0.563873, 1, 0, 0.260073,0.0263308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218274,-0.0291441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254569,0.00367384) , 
1, -0.942303, 1, 0, 0.250434,-0.000244161) , 
0, -1.05347, 1, 0, 0.251748,0.00337969)    );
  // itree = 1777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427481,-0.0338541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256148,-0.000136467) , 
1, -0.904921, 1, 0, 0.292407,0.0100199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362903,0.0320794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226401,0.00748023) , 
0, -0.350173, 1, 0, 0.238262,-0.00919918) , 
0, -0.528156, 1, 0, 0.254643,-0.00338462)    );
  // itree = 1778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405172,-0.0205704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374302,-0.00764202) , 
0, -1.58359, 1, 0, 0.386441,-0.0197293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23913,-0.0157683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231922,0.0109755) , 
0, -0.181309, 1, 0, 0.234282,0.00474989) , 
0, -0.972742, 1, 0, 0.256941,0.00110457)    );
  // itree = 1779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0821596,-0.0286902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337165,0.0107482) , 
0, -0.69946, 1, 0, 0.247312,0.000485396) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518919,0.0604535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235507,-0.0187149) , 
0, -0.103068, 1, 0, 0.306649,-0.021469) , 
3, 0.331768, 1, 0, 0.269784,-0.0078293)    );
  // itree = 1780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114943,-0.0187027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262447,0.00404876) , 
2, -0.523974, 1, 0, 0.212375,-0.00222544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725352,-0.0161174) , 
3, 1.76021, 1, 0, 0.25,-0.00425605)    );
  // itree = 1781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317073,0.00718554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0690691,-0.0129087) , 
1, 1.36335, 1, 0, 0.271421,-0.00778792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114458,-0.0359709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12963,-3.47549e-05) , 
1, 0.536577, 1, 0, 0.120438,0.0323015) , 
0, 1.28629, 1, 0, 0.25156,-0.00251451)    );
  // itree = 1782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330028,0.00256612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256501,-0.00551342) , 
0, -0.259717, 1, 0, 0.289948,0.00320568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.040404,0.0273956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137072,0.00592783) , 
1, 0.539961, 1, 0, 0.114286,0.0260801) , 
3, 1.00021, 1, 0, 0.252535,0.0080775)    );
  // itree = 1783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0773398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301316,-0.00856303) , 
1, -1.43262, 1, 0, 0.262615,-0.0121426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213508,-0.0109207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286275,0.03384) , 
2, 1.46451, 1, 0, 0.229327,0.0096028) , 
2, -0.0855223, 1, 0, 0.243521,0.000330424)    );
  // itree = 1784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227887,0.00273575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0820513,-0.0542329) , 
2, 1.30525, 1, 0, 0.212287,-0.00194571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596491,-0.0270012) , 
3, 1.76176, 1, 0, 0.234899,-0.00499982)    );
  // itree = 1785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416856,0.000258521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283203,0.00200205) , 
3, -1.11946, 1, 0, 0.323308,0.000522129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0181818,-0.0478363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140909,0.00726103) , 
0, -0.128422, 1, 0, 0.116364,-0.0323995) , 
3, 0.721703, 1, 0, 0.266766,-0.00847285)    );
  // itree = 1786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313322,-0.00703686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196296,-0.020031) , 
3, 0.281662, 1, 0, 0.292059,0.00937897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0997151,0.00885987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0406504,-0.0504952) , 
3, 1.83049, 1, 0, 0.0843882,-0.031131) , 
3, 0.824791, 1, 0, 0.241837,-0.000417835)    );
  // itree = 1787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243841,0.00193605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383459,0.0331063) , 
3, 1.20819, 1, 0, 0.263926,-0.00180903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0420168,-0.0538947) , 
1, 1.65151, 1, 0, 0.250508,0.000379771)    );
  // itree = 1788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242063,0.0332184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163984,-0.00839428) , 
0, -0.300762, 1, 0, 0.197714,0.00974632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527559,0.0560236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621212,0.00165664) , 
3, 1.64273, 1, 0, 0.584615,0.0397509) , 
3, 1.28958, 1, 0, 0.258313,0.0144458)    );
  // itree = 1789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385586,-0.00023505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206337,-0.00114956) , 
3, -0.903884, 1, 0, 0.260141,0.00320948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0181818,-0.0598782) , 
2, 1.84306, 1, 0, 0.246554,0.00813683)    );
  // itree = 1790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259791,-0.00347187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0170455,-0.00929586) , 
3, 1.32638, 1, 0, 0.234778,-0.00745137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548673,0.00966169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241071,0.0185558) , 
3, 1.09095, 1, 0, 0.395556,0.0370445) , 
2, 1.51846, 1, 0, 0.253492,-0.00227207)    );
  // itree = 1791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0141844,0.0501272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278859,0.00643631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256849,-0.00300425) , 
3, 1.34175, 1, 0, 0.275354,0.00192727) , 
1, -1.28125, 1, 0, 0.256709,0.00513262)    );
  // itree = 1792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159722,-0.0100038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520408,0.0381967) , 
3, 1.06842, 1, 0, 0.180737,-0.00304656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392157,-0.0101738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626866,-0.0330968) , 
2, 1.00103, 1, 0, 0.525424,-0.0455699) , 
3, 1.36188, 1, 0, 0.223149,-0.00827883)    );
  // itree = 1793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274182,-0.00408151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231343,-0.0121639) , 
0, 0.733717, 1, 0, 0.270528,-0.00683714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16092,-0.0157697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155172,0.0139188) , 
3, 1.14461, 1, 0, 0.158621,0.00999044) , 
0, 0.956597, 1, 0, 0.246261,-0.00318809)    );
  // itree = 1794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304569,-0.00258431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0241811) , 
3, -1.0595, 1, 0, 0.214706,0.0156337) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300649,0.00556224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0689655,-0.0203974) , 
3, 1.31599, 1, 0, 0.263956,-0.0106619) , 
1, -0.71469, 1, 0, 0.255533,-0.00616469)    );
  // itree = 1795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0774653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26276,0.000213675) , 
0, -1.58921, 1, 0, 0.246746,0.00221117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319372,0.0303224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317829,0.0596941) , 
1, 1.38231, 1, 0, 0.31875,-0.0317844) , 
3, 1.22047, 1, 0, 0.258209,-0.00320106)    );
  // itree = 1796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231461,0.0078484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183908,-0.0191918) , 
0, -0.0576888, 1, 0, 0.207955,-0.00457069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74,0.0363962) , 
3, 1.73078, 1, 0, 0.249738,0.00154977)    );
  // itree = 1797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304501,0.00154076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0449827,-0.0278762) , 
2, 1.09499, 1, 0, 0.260666,0.00645331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113208,-0.025393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179487,0.0173593) , 
2, 0.637185, 1, 0, 0.152672,-0.0202275) , 
0, 1.26376, 1, 0, 0.246325,0.00291029)    );
  // itree = 1798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340092,0.00585915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150857,-0.0024539) , 
3, 0.0167245, 1, 0, 0.255612,-0.00886346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,-0.013501) , 
1, 1.68641, 1, 0, 0.261813,-0.00382978)    );
  // itree = 1799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0766804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221154,-0.00563047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30137,0.0105592) , 
0, -0.293168, 1, 0, 0.274531,-0.0038299) , 
0, -1.37918, 1, 0, 0.252964,8.47996e-05)    );
  // itree = 1800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24,0.0228321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159363,-0.0348348) , 
1, -0.545749, 1, 0, 0.187902,-0.0107099) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290891,0.0197284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,-0.0221471) , 
1, 1.48476, 1, 0, 0.290186,0.0118516) , 
0, -0.293879, 1, 0, 0.249617,0.002903)    );
  // itree = 1801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483444,-0.0268689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23441,0.00189976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143519,-0.00906627) , 
0, 0.900791, 1, 0, 0.212138,0.00260638) , 
1, -1.23113, 1, 0, 0.233542,0.00734338)    );
  // itree = 1802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373684,-0.0113613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214982,-0.00577242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389222,0.0318896) , 
1, 1.56335, 1, 0, 0.231067,0.00279489) , 
0, -1.26434, 1, 0, 0.244622,0.00700281)    );
  // itree = 1803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161392,-0.0108946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366071,0.0160434) , 
0, -0.0159776, 1, 0, 0.254042,0.00444938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422018,-0.000190545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14218,-0.0458854) , 
0, 0.792299, 1, 0, 0.2375,0.0619508) , 
3, 1.27365, 1, 0, 0.251462,0.0134165)    );
  // itree = 1804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366379,-0.026244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193196,0.0288026) , 
3, -1.11872, 1, 0, 0.136752,0.00855935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377432,-0.0340213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488636,0.00416446) , 
2, 0.579924, 1, 0, 0.447633,-0.0127002) , 
3, 0.356305, 1, 0, 0.245968,0.00109066)    );
  // itree = 1805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331593,-0.00731349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180451,-0.0211205) , 
0, 0.798531, 1, 0, 0.30318,0.00258278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533333,-0.00845311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118421,0.00379848) , 
0, -0.227163, 1, 0, 0.10231,-0.021207) , 
2, 0.721559, 1, 0, 0.242949,-0.00455061)    );
  // itree = 1806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155405,-0.0247427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394737,0.000974212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252735,0.00963777) , 
0, -1.22422, 1, 0, 0.264161,0.0093236) , 
1, -1.33599, 1, 0, 0.256259,0.00550914)    );
  // itree = 1807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205128,-0.0158254) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231912,-0.00103342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441358,-0.00144793) , 
1, 1.41616, 1, 0, 0.268162,0.00149139) , 
1, -1.19679, 1, 0, 0.244799,-0.00169911)    );
  // itree = 1808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155556,-0.062154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24828,0.00607948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337838,-0.0225509) , 
1, 1.57741, 1, 0, 0.255285,0.00255745) , 
1, -1.33599, 1, 0, 0.248643,-0.00149286)    );
  // itree = 1809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617486,0.0188228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33,0.00438246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194663,-0.00237222) , 
2, -1.1076, 1, 0, 0.209302,0.00613085) , 
1, -1.19679, 1, 0, 0.246063,0.00205854)    );
  // itree = 1810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257074,-0.00163502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321782,0.00159756) , 
1, 1.45677, 1, 0, 0.26409,-0.004769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0410959,-0.0341994) , 
3, 1.69879, 1, 0, 0.247885,-0.000762476)    );
  // itree = 1811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240971,-0.00511303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60396,0.0595414) , 
0, 1.36221, 1, 0, 0.260545,-0.00120596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0808081,-0.0649737) , 
0, 1.61599, 1, 0, 0.251521,0.00114985)    );
  // itree = 1812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260309,-0.00146709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222552,-0.0289816) , 
0, 0.508035, 1, 0, 0.248877,-0.0105972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,-0.04857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252511,0.0166522) , 
0, -0.635545, 1, 0, 0.229391,0.00817411) , 
1, 0.583399, 1, 0, 0.240513,-0.00253997)    );
  // itree = 1813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285447,0.00390184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104072,0.00737778) , 
3, 1.12782, 1, 0, 0.263447,-0.005923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0723684,0.00207177) , 
3, 1.76176, 1, 0, 0.248734,-0.00156077)    );
  // itree = 1814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272563,-0.00411501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149533,0.0251745) , 
3, 1.24997, 1, 0, 0.265122,-0.00236065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0463918,-0.044814) , 
3, 1.55602, 1, 0, 0.243505,0.00280144)    );
  // itree = 1815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233432,-0.00364604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315556,-0.00655407) , 
3, 0.457817, 1, 0, 0.245104,0.00715903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0590695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373665,-0.0158498) , 
1, 0.90122, 1, 0, 0.326711,-0.0176476) , 
3, 0.893134, 1, 0, 0.263261,0.00163968)    );
  // itree = 1816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196034,-0.00578247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3379,0.0211928) , 
2, 0.590782, 1, 0, 0.231561,0.00209191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00990099,-0.0703195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482993,-0.0439791) , 
3, 0.802835, 1, 0, 0.290323,-0.0455896) , 
2, 1.45386, 1, 0, 0.238858,-0.00382948)    );
  // itree = 1817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.602837,0.0229975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139373,-0.037114) , 
1, -0.453973, 1, 0, 0.369069,-0.0083855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326667,-0.0031063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185527,-0.00179988) , 
3, -0.621812, 1, 0, 0.200138,0.0103771) , 
3, -0.871513, 1, 0, 0.24777,0.00508677)    );
  // itree = 1818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349765,0.00770894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211216,-0.00123079) , 
3, -1.10495, 1, 0, 0.244024,0.000494317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148515,-0.00330081) , 
0, 1.35023, 1, 0, 0.234383,0.00376976)    );
  // itree = 1819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.048951,0.0162335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291604,-0.00770118) , 
1, -0.85034, 1, 0, 0.248765,-0.00747926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230769,0.0386944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235495,-0.023283) , 
1, 0.873189, 1, 0, 0.234043,0.0247819) , 
2, 1.08337, 1, 0, 0.245717,-0.00079964)    );
  // itree = 1820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249699,0.00340567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251142,0.0433733) , 
1, 1.45677, 1, 0, 0.249867,0.00820271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419048,-0.0318176) , 
2, 1.84652, 1, 0, 0.258812,0.00537265)    );
  // itree = 1821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558442,0.0235032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109705,-0.0400724) , 
1, -0.184382, 1, 0, 0.363303,-0.0114129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285393,0.00163549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150924,-0.00385375) , 
1, 0.0813332, 1, 0, 0.193094,0.0096668) , 
3, -0.871513, 1, 0, 0.240326,0.0038173)    );
  // itree = 1822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289827,-0.00794069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0237805) , 
3, -0.150144, 1, 0, 0.232996,-0.0150288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00241658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21978,0.00204705) , 
3, -0.616634, 1, 0, 0.244946,0.014003) , 
1, -0.128677, 1, 0, 0.240769,0.00385582)    );
  // itree = 1823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238931,0.00155955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316623,0.00726803) , 
3, 0.41387, 1, 0, 0.256365,-0.00489673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297297,-0.0387535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148649,0.0219912) , 
3, 1.73525, 1, 0, 0.222973,0.0262221) , 
3, 1.29216, 1, 0, 0.251385,-0.000256349)    );
  // itree = 1824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00952381,-0.0674221) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147541,0.0206879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308993,-0.00330146) , 
2, -0.814754, 1, 0, 0.276965,0.000379946) , 
3, -2.02293, 1, 0, 0.262564,-0.00189071)    );
  // itree = 1825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318605,0.00571375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234918,-0.00158069) , 
0, -0.728949, 1, 0, 0.254486,-0.00289173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156627,-0.0189482) , 
0, 1.44177, 1, 0, 0.246384,0.00225998)    );
  // itree = 1826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350254,-0.012299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348214,-0.00124266) , 
1, -0.0247107, 1, 0, 0.349515,-0.0314617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221725,0.00162021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382353,0.00475036) , 
2, 1.83257, 1, 0, 0.231554,0.00422781) , 
0, -0.868745, 1, 0, 0.25,-0.00135319)    );
  // itree = 1827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233732,0.0129067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24,-0.011969) , 
3, -0.490758, 1, 0, 0.236806,0.00637218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525253,0.0492966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105634,-0.0169567) , 
2, 0.888457, 1, 0, 0.278008,-0.0165541) , 
3, 0.880369, 1, 0, 0.246939,0.000734189)    );
  // itree = 1828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0440599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.00775069) , 
1, -1.26382, 1, 0, 0.038961,-0.0107601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389381,0.0274553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3117,0.00231513) , 
0, -0.293939, 1, 0, 0.334411,0.0112505) , 
3, -1.08105, 1, 0, 0.266434,0.00618632)    );
  // itree = 1829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494929,0.0087167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226721,-0.00418133) , 
1, -0.147047, 1, 0, 0.360689,-0.00721705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.098063,-0.016022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,-0.0262346) , 
0, 1.43433, 1, 0, 0.101253,0.0143032) , 
2, 0.213212, 1, 0, 0.232905,0.00338264)    );
  // itree = 1830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272028,-0.00436675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0352941,-0.0249379) , 
3, 1.38332, 1, 0, 0.250403,-0.00121933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129032,-0.00609729) , 
0, 1.44177, 1, 0, 0.241071,0.00139011)    );
  // itree = 1831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24491,0.00369082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386364,0.0487356) , 
3, 1.64941, 1, 0, 0.254997,-0.00357041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146789,0.010801) , 
2, 1.82177, 1, 0, 0.24898,-0.000830589)    );
  // itree = 1832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195889,0.0065012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524904,-0.0165858) , 
3, 1.23305, 1, 0, 0.240731,0.000572888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439655,0.0295537) , 
1, 1.68641, 1, 0, 0.252093,0.00330175)    );
  // itree = 1833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369863,-0.00290561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307268,-0.000499858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129395,0.0100241) , 
3, 0.348714, 1, 0, 0.23693,-0.0150827) , 
0, -1.37918, 1, 0, 0.246914,-0.0107721)    );
  // itree = 1834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19598,-0.0121613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450593,0.00956106) , 
2, -0.785377, 1, 0, 0.338496,-0.016211) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164557,-0.00838945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217092,-0.00260145) , 
1, -0.999833, 1, 0, 0.211933,0.00576394) , 
0, -0.727763, 1, 0, 0.239689,0.000944586)    );
  // itree = 1835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0761352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328267,0.0308863) , 
1, -1.13401, 1, 0, 0.241071,-0.00857526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237778,-0.0104541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271845,-0.0159279) , 
3, 1.56281, 1, 0, 0.242288,0.0142241) , 
3, -1.04915, 1, 0, 0.242016,0.00912722)    );
  // itree = 1836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251064,0.0198644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227333,-0.0162637) , 
0, -1.08959, 1, 0, 0.230548,-0.0101884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191617,0.00532058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472727,0.0253954) , 
2, 1.20097, 1, 0, 0.303249,0.020678) , 
0, 1.24796, 1, 0, 0.240557,-0.00593888)    );
  // itree = 1837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494062,-0.00399065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220833,-0.0116496) , 
3, -0.453747, 1, 0, 0.394856,0.0159369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213836,-0.00425386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0886427,-0.0152222) , 
2, 0.509685, 1, 0, 0.147275,-0.00832308) , 
1, -0.128677, 1, 0, 0.228331,-0.000380625)    );
  // itree = 1838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19697,-0.00888899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0326087,0.0152157) , 
1, 0.92562, 1, 0, 0.158098,0.00190386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26506,0.00861099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32996,0.00498533) , 
2, 0.199726, 1, 0, 0.316896,-0.0158794) , 
2, -0.201421, 1, 0, 0.255583,-0.0090132)    );
  // itree = 1839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0267176,-0.000767221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125874,0.0898522) , 
2, -0.571696, 1, 0, 0.0617284,-0.0223512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301325,-0.00376661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151786,-0.0317371) , 
0, 1.55221, 1, 0, 0.290999,0.0049456) , 
1, -0.621769, 1, 0, 0.24519,-0.000508381)    );
  // itree = 1840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152174,-0.0123743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515625,0.0160236) , 
3, 0.669831, 1, 0, 0.248194,-0.000295548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352941,-0.0262031) , 
0, 1.55221, 1, 0, 0.253431,-0.00264972)    );
  // itree = 1841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379854,0.00469589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182868,-0.00433071) , 
3, -0.462189, 1, 0, 0.269995,0.00316254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0904255,0.0289779) , 
3, 1.70618, 1, 0, 0.253535,-0.000835342)    );
  // itree = 1842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338521,0.00643848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230205,0.00223014) , 
3, -0.922295, 1, 0, 0.259851,0.00322604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,0.0182556) , 
0, 1.3861, 1, 0, 0.2523,-0.000875189)    );
  // itree = 1843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00625,-0.0420131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271753,-0.00298477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301158,0.0130721) , 
2, 1.44307, 1, 0, 0.275881,-0.00405756) , 
1, -1.23776, 1, 0, 0.254364,-0.000336244)    );
  // itree = 1844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221591,0.0414048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207927,-0.00329779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633136,-0.0238424) , 
3, 1.71724, 1, 0, 0.247651,-0.00663627) , 
1, -1.18003, 1, 0, 0.24534,-0.00230818)    );
  // itree = 1845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352796,0.00256627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10461,0.00394952) , 
1, 0.940933, 1, 0, 0.274157,0.000452903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0578947,-0.012214) , 
3, 1.57074, 1, 0, 0.2533,0.00394869)    );
  // itree = 1846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291986,0.00426674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0324074,0.017373) , 
3, 1.14806, 1, 0, 0.258025,-0.0165269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894309,0.0140096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292887,-0.00771802) , 
2, 0.342808, 1, 0, 0.223757,0.00953553) , 
1, 1.36335, 1, 0, 0.251863,-0.01184)    );
  // itree = 1847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191729,-0.0104943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396648,-0.000320985) , 
0, 0.6269, 1, 0, 0.25067,0.0042594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,-0.0400035) , 
1, 1.65151, 1, 0, 0.237475,-0.00072841)    );
  // itree = 1848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145038,-0.0402361) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115942,-0.018826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4825,0.0045918) , 
3, 0.364099, 1, 0, 0.269958,-0.00345078) , 
0, -1.43147, 1, 0, 0.261916,-0.00570396)    );
  // itree = 1849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306266,0.0038438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12766,0.0162327) , 
1, 1.40748, 1, 0, 0.2871,-0.00471994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797101,0.00527563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0451613,-0.0315779) , 
1, 1.3101, 1, 0, 0.0614334,0.0198859) , 
2, 1.31942, 1, 0, 0.254768,-0.00119451)    );
  // itree = 1850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289845,-0.00450519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994318,-0.0106562) , 
3, 0.809278, 1, 0, 0.253399,0.00316724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.04286) , 
3, 1.74551, 1, 0, 0.238071,0.00919629)    );
  // itree = 1851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183994,-0.00373491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,-0.00316735) , 
3, 0.935436, 1, 0, 0.200647,0.00459525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457317,0.00735788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419689,0.0121765) , 
0, 1.32792, 1, 0, 0.436975,-0.0159363) , 
0, 1.00007, 1, 0, 0.245005,0.000741538)    );
  // itree = 1852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172222,-0.00908187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396947,-0.0279754) , 
3, 1.093, 1, 0, 0.203507,-0.0125117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.847619,0.0241993) , 
3, 1.89284, 1, 0, 0.237544,-0.00961965)    );
  // itree = 1853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30578,-0.000919433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135135,-0.00535222) , 
3, 0.695421, 1, 0, 0.280481,-0.00701403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0315789,-0.0524573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797101,-0.0136698) , 
2, 1.48609, 1, 0, 0.0518293,0.0361135) , 
3, 1.28958, 1, 0, 0.244337,-0.000196757)    );
  // itree = 1854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348868,0.0125328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0446429,-0.0191841) , 
3, 0.523968, 1, 0, 0.309386,-0.0170643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242105,0.00390133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.057971,-0.0167926) , 
3, 1.56017, 1, 0, 0.209162,0.00569369) , 
0, -0.179217, 1, 0, 0.25198,-0.00402914)    );
  // itree = 1855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00995025,-0.0609213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275994,-0.00156536) , 
1, -1.07773, 1, 0, 0.240557,8.98079e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387534,0.0149492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729927,-0.0438593) , 
2, 1.51309, 1, 0, 0.302372,-0.0362312) , 
3, 0.853537, 1, 0, 0.256079,-0.009031)    );
  // itree = 1856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25523,0.0278022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209231,-0.00459717) , 
0, -1.08651, 1, 0, 0.215129,0.00012507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726667,0.0241324) , 
3, 1.74459, 1, 0, 0.253227,0.00343346)    );
  // itree = 1857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352021,-0.00230856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179732,0.00312106) , 
3, -0.440375, 1, 0, 0.25262,0.0130486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205674,0.0383357) , 
1, 1.58039, 1, 0, 0.249232,0.00972483)    );
  // itree = 1858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124324,-0.0138456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.078137) , 
3, -0.0628756, 1, 0, 0.0976645,-0.0138139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221429,-0.00975412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284941,-0.00361332) , 
2, -0.0102515, 1, 0, 0.267495,0.000600329) , 
2, -0.773942, 1, 0, 0.2275,-0.00279422)    );
  // itree = 1859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218548,-0.00197581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318903,0.00224609) , 
3, 0.395402, 1, 0, 0.254527,-0.0119612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0892857,-0.0360473) , 
0, 1.58326, 1, 0, 0.245477,-0.0084921)    );
  // itree = 1860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197279,-0.0322492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251163,0.0212225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314974,-0.00984558) , 
2, 0.80156, 1, 0, 0.270978,0.00932012) , 
0, -1.35128, 1, 0, 0.26561,0.00613991)    );
  // itree = 1861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.017209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0413793,-0.0166073) , 
3, 0.57776, 1, 0, 0.32381,-0.0238867) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242553,-0.00786738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0830565,-0.0166502) , 
3, 1.07632, 1, 0, 0.194831,0.00377616) , 
0, -0.0432279, 1, 0, 0.257304,-0.0096228)    );
  // itree = 1862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295278,0.00259575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.088785,0.00219009) , 
3, 1.13379, 1, 0, 0.27186,-0.00305092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0718954,-0.0162385) , 
3, 1.76176, 1, 0, 0.256863,0.000223462)    );
  // itree = 1863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.00185528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332215,0.000549025) , 
0, -0.177398, 1, 0, 0.253216,-0.00164929) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,-0.0270259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234848,-0.0208993) , 
1, 1.26596, 1, 0, 0.209738,0.0465423) , 
3, 1.36188, 1, 0, 0.247344,0.00485913)    );
  // itree = 1864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209009,-0.0166783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182718,0.0180437) , 
1, -0.309093, 1, 0, 0.191477,0.00298039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387387,-0.0616345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593607,-0.0171681) , 
0, 0.600509, 1, 0, 0.524242,-0.0537184) , 
3, 1.22047, 1, 0, 0.246493,-0.00639365)    );
  // itree = 1865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370234,0.0119009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.010101,-0.0604923) , 
3, 0.798828, 1, 0, 0.33114,-0.0115903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226667,-0.0107902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187675,0.0150133) , 
0, 1.06912, 1, 0, 0.213178,0.00854916) , 
0, -0.0324937, 1, 0, 0.268519,-0.000898961)    );
  // itree = 1866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330645,0.00338856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0423077,-0.0285366) , 
3, 0.604967, 1, 0, 0.276163,0.00214646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238693,-0.00598184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144615,-0.00622411) , 
3, 0.78527, 1, 0, 0.196404,-0.0201312) , 
1, 0.940933, 1, 0, 0.24869,-0.00552707)    );
  // itree = 1867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0147783,0.0437994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310409,0.0086271) , 
1, -1.01739, 1, 0, 0.22942,-0.0119641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12766,-0.0109464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287611,-0.00250185) , 
1, 0.0345142, 1, 0, 0.244931,0.00691983) , 
3, -0.580667, 1, 0, 0.239108,-0.000168816)    );
  // itree = 1868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.0150251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495763,0.0270115) , 
3, -0.33724, 1, 0, 0.213828,0.00402652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175676,-0.061132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26079,-0.0111448) , 
0, -0.122423, 1, 0, 0.250606,-0.015854) , 
0, -0.293879, 1, 0, 0.236373,-0.00815988)    );
  // itree = 1869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650485,-0.00252094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235532,-0.0026456) , 
1, -1.43545, 1, 0, 0.262429,0.0113452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15812,-0.0119132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16129,0.0248695) , 
3, 1.09695, 1, 0, 0.159383,-0.0254375) , 
0, 1.00007, 1, 0, 0.242164,0.00411136)    );
  // itree = 1870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0777778,-0.0367668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359292,0.00977943) , 
2, -1.38466, 1, 0, 0.320611,-0.000519195) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0298507,-0.0485269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117978,-0.0165104) , 
1, 0.90122, 1, 0, 0.0801282,0.0290775) , 
3, 0.540694, 1, 0, 0.24302,0.00903009)    );
  // itree = 1871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169014,-0.0205981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233784,0.00902384) , 
2, -1.48816, 1, 0, 0.223356,-0.00775577) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119122,-0.0222165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30292,-0.00663669) , 
1, 0.163788, 1, 0, 0.251534,0.0117089) , 
3, -0.388717, 1, 0, 0.239249,0.00322258)    );
  // itree = 1872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20418,-0.00553508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311594,0.0629656) , 
0, -0.486301, 1, 0, 0.223684,0.00749545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121462,-0.0275772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53653,0.00507367) , 
3, 0.827586, 1, 0, 0.26283,-0.0081691) , 
0, -0.333741, 1, 0, 0.248289,-0.0023504)    );
  // itree = 1873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299245,0.00129458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195572,-0.00434249) , 
0, 0.904481, 1, 0, 0.282986,-0.000237167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11413,0.0283148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0265487,-0.0601882) , 
3, 1.89298, 1, 0, 0.0808081,0.0429782) , 
3, 1.30934, 1, 0, 0.253333,0.00610108)    );
  // itree = 1874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326,-0.00412633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250522,0.0056657) , 
3, -0.099077, 1, 0, 0.301555,0.00726581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00961538,-0.0542376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141791,0.00895932) , 
1, 0.371583, 1, 0, 0.114625,-0.0152498) , 
3, 0.795947, 1, 0, 0.253904,0.00152631)    );
  // itree = 1875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183383,-0.0097886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222707,-0.0159856) , 
0, 0.408901, 1, 0, 0.189137,0.00261584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481735,0.0266874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185484,-0.0698322) , 
1, 1.18709, 1, 0, 0.41637,-0.0178089) , 
0, 0.782376, 1, 0, 0.249177,-0.00278083)    );
  // itree = 1876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113586,-0.00259367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274194,0.0649119) , 
3, -0.376971, 1, 0, 0.16063,0.0132318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300832,-0.0157043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271028,0.0087573) , 
1, 0.956795, 1, 0, 0.289244,-0.0050815) , 
2, -0.472985, 1, 0, 0.248633,0.000701185)    );
  // itree = 1877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367521,-0.0158137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268995,0.00572614) , 
0, -1.56609, 1, 0, 0.275586,-0.00514091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137681,-0.0198653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,-0.0173064) , 
3, 1.07632, 1, 0, 0.121771,0.0397902) , 
0, 1.2265, 1, 0, 0.25495,0.000886975)    );
  // itree = 1878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302711,0.002674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0419162,-0.0213752) , 
3, 0.170607, 1, 0, 0.250301,0.0282145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302439,-0.00396348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.092437,-0.0116152) , 
3, 1.01712, 1, 0, 0.238743,-0.00854629) , 
1, 0.0962332, 1, 0, 0.243526,0.00666695)    );
  // itree = 1879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222779,-0.000129306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311538,-0.00679528) , 
3, 0.488581, 1, 0, 0.246868,0.00043264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219858,0.0368502) , 
3, 1.74459, 1, 0, 0.245017,-0.00278481)    );
  // itree = 1880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198925,0.0900223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,0.0152607) , 
2, -1.33209, 1, 0, 0.136364,0.0175439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354037,-0.0608143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442509,-0.00640419) , 
0, -0.146829, 1, 0, 0.423129,-0.0266087) , 
3, 0.331768, 1, 0, 0.24473,0.000859016)    );
  // itree = 1881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378132,0.0087565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325103,0.00439628) , 
0, -0.529333, 1, 0, 0.35027,-0.00753162) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155606,0.000553789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196078,0.00403082) , 
0, 1.51222, 1, 0, 0.159836,0.0123265) , 
3, -0.112181, 1, 0, 0.252499,0.00266382)    );
  // itree = 1882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240619,-0.00978308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0448718,0.0264016) , 
3, 1.4867, 1, 0, 0.223978,-0.00115037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375887,0.0130513) , 
1, 1.60739, 1, 0, 0.234818,-0.00712494)    );
  // itree = 1883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266423,0.0233833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23227,-0.00109523) , 
2, -1.01348, 1, 0, 0.238944,0.00664477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375734,0.00954806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0267857,-0.0476387) , 
3, 1.87894, 1, 0, 0.313002,-0.0254015) , 
3, 0.636233, 1, 0, 0.261728,-0.00321439)    );
  // itree = 1884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234234,0.0358916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235079,-0.0306592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258903,0.00421182) , 
1, 0.264688, 1, 0, 0.248387,-0.00924636) , 
1, -1.44249, 1, 0, 0.24759,-0.00631389)    );
  // itree = 1885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39599,-0.000776686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237209,0.00440744) , 
3, -1.19766, 1, 0, 0.270483,-0.00108216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.045045,-0.0306687) , 
2, 1.85179, 1, 0, 0.258065,0.00188718)    );
  // itree = 1886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425101,-0.001959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129496,-0.049387) , 
3, -0.89686, 1, 0, 0.318653,0.0281411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212334,-0.0072935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371951,0.00895459) , 
1, 1.57058, 1, 0, 0.228787,9.09063e-05) , 
0, -0.805301, 1, 0, 0.246333,0.00556758)    );
  // itree = 1887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239088,0.00445056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430894,0.019013) , 
3, 1.11563, 1, 0, 0.265581,-0.008018) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477941,0.0241272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.062995) , 
3, 1.07875, 1, 0, 0.273077,0.0160223) , 
2, 1.46433, 1, 0, 0.266536,-0.00495555)    );
  // itree = 1888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241667,0.0417828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.052755,-0.0337734) , 
1, -1.49624, 1, 0, 0.0760534,-0.00879834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335832,0.0150777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537604,0.0280385) , 
3, 1.09432, 1, 0, 0.406433,0.0272608) , 
3, -0.139172, 1, 0, 0.245623,0.00970927)    );
  // itree = 1889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352874,-0.00458166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176171,-0.00677168) , 
3, -0.364179, 1, 0, 0.259179,0.0117781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254902,0.0626292) , 
1, 1.68939, 1, 0, 0.258956,0.00743449)    );
  // itree = 1890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15674,-0.0121639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453674,0.00823897) , 
2, -0.283354, 1, 0, 0.303797,-0.00169594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0854352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234086,0.00411688) , 
2, 0.579924, 1, 0, 0.137184,0.0181301) , 
3, 0.356305, 1, 0, 0.237709,0.00616822)    );
  // itree = 1891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0784965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369535,-0.00724309) , 
1, 0.162984, 1, 0, 0.188083,0.014442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318584,0.0297413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387611,0.00502032) , 
1, -0.366642, 1, 0, 0.376106,-0.010715) , 
0, 0.57508, 1, 0, 0.249638,0.00620613)    );
  // itree = 1892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,0.0248206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235983,-0.00971368) , 
0, -1.49999, 1, 0, 0.232331,-0.00510064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203175,0.0635775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369318,-0.0136663) , 
2, 0.58131, 1, 0, 0.290855,0.0163041) , 
0, 0.46308, 1, 0, 0.251878,0.00204856)    );
  // itree = 1893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338028,-0.0166857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273684,0.00146995) , 
0, -1.39286, 1, 0, 0.279515,0.00150505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106481,0.0191957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714286,-0.0324153) , 
2, 1.51309, 1, 0, 0.0945122,0.0347775) , 
3, 1.27365, 1, 0, 0.247493,0.00726407)    );
  // itree = 1894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387097,0.0534778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375358,0.0129563) , 
1, -0.931883, 1, 0, 0.378436,0.0115672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275742,0.0088232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813954,-0.0145905) , 
3, 1.08221, 1, 0, 0.230872,-0.0140071) , 
0, -0.691888, 1, 0, 0.266429,-0.00784477)    );
  // itree = 1895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.030837,-0.00161679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109091,0.0527813) , 
2, -0.571696, 1, 0, 0.0563798,-0.0251528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257143,-0.00839649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419558,0.0169835) , 
1, 1.42941, 1, 0, 0.287129,0.00767684) , 
1, -0.71469, 1, 0, 0.24927,0.00229048)    );
  // itree = 1896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934844,-0.00676358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394775,0.0125435) , 
3, 0.174631, 1, 0, 0.212243,0.00461608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788043,0.0292269) , 
3, 1.74459, 1, 0, 0.267081,0.00921169)    );
  // itree = 1897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281825,-0.0109733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243373,0.0167906) , 
0, 0.627404, 1, 0, 0.272236,0.00616579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0530973,-0.0365309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894737,0.00151287) , 
1, 0.886102, 1, 0, 0.0759076,-0.030329) , 
3, 1.24777, 1, 0, 0.241993,0.000544069)    );
  // itree = 1898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,-0.0113243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28382,0.0103345) , 
1, -1.26519, 1, 0, 0.260917,0.0134584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386861,0.0391073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216805,-0.00967294) , 
0, -0.73748, 1, 0, 0.237965,-0.0102284) , 
1, 0.227361, 1, 0, 0.248389,0.000528739)    );
  // itree = 1899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0987914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221818,0.023277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288973,0.00184757) , 
0, -0.68246, 1, 0, 0.279007,-0.00386168) , 
0, -1.27942, 1, 0, 0.25368,-7.09327e-05)    );
  // itree = 1900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0433884,-0.021352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330764,0.00894435) , 
3, -1.02623, 1, 0, 0.25798,0.00421122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379562,-0.0274272) , 
1, 1.59745, 1, 0, 0.266113,0.000706797)    );
  // itree = 1901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276719,-0.00753562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239531,-0.00154571) , 
0, 0.350327, 1, 0, 0.264412,0.00559535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.027027,-0.0391493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0775862,0.00153292) , 
1, 1.26298, 1, 0, 0.0528634,0.0362283) , 
3, 1.55602, 1, 0, 0.240768,0.00901912)    );
  // itree = 1902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504202,0.0293911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346154,0.00236018) , 
3, -2.00223, 1, 0, 0.379679,-0.0100118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199021,-0.0183255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20681,0.000475835) , 
0, 0.127706, 1, 0, 0.203414,0.017901) , 
3, -0.871513, 1, 0, 0.253686,0.00994012)    );
  // itree = 1903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.077117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39823,0.0102361) , 
0, 0.692057, 1, 0, 0.0809353,0.0205891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0791367,-0.0169031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336463,-0.00442215) , 
1, -0.105276, 1, 0, 0.311221,-0.00626919) , 
1, -0.300045, 1, 0, 0.246325,0.00129959)    );
  // itree = 1904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148485,-0.0106221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495984,0.0190254) , 
3, 0.54378, 1, 0, 0.243674,0.0035808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0183486,-0.000970743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511628,-0.0356991) , 
3, 0.753965, 1, 0, 0.285714,-0.0324446) , 
2, 1.53606, 1, 0, 0.248541,-0.000589458)    );
  // itree = 1905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309929,0.000571899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150134,0.0249501) , 
3, 0.705587, 1, 0, 0.2765,-0.00403923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0164835,-0.0680628) , 
3, 1.63849, 1, 0, 0.252417,0.00584675)    );
  // itree = 1906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405594,-0.00234729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209677,0.00648522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252962,0.00787841) , 
1, -1.00949, 1, 0, 0.248666,-0.00956945) , 
0, -1.43147, 1, 0, 0.259792,-0.00499385)    );
  // itree = 1907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0760427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270781,0.0105303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264292,-0.00875607) , 
3, -0.214705, 1, 0, 0.267061,-0.0019678) , 
0, -1.50708, 1, 0, 0.251518,0.00048643)    );
  // itree = 1908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256261,-0.00134298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22,-0.0541071) , 
0, 1.35843, 1, 0, 0.253348,-0.00552538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428571,0.0336347) , 
1, 1.62191, 1, 0, 0.264425,-0.00168245)    );
  // itree = 1909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464151,0.00698577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126316,-0.0202055) , 
2, 0.257238, 1, 0, 0.354894,0.00128011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149284,0.0216567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0657439,-0.00789601) , 
2, 1.18431, 1, 0, 0.118252,-0.0255759) , 
1, 0.680932, 1, 0, 0.260625,-0.00941827)    );
  // itree = 1910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261029,0.000433804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0203046,-0.0331396) , 
3, 1.40727, 1, 0, 0.235101,0.0050858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459459,0.0629625) , 
2, 1.82177, 1, 0, 0.247938,0.0020267)    );
  // itree = 1911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00222222,-0.074913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634483,0.0205888) , 
1, 0.961992, 1, 0, 0.156303,0.0208418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158145,-0.00767656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476431,0.0047391) , 
1, 0.879105, 1, 0, 0.289895,-0.0103541) , 
0, -0.528156, 1, 0, 0.250739,-0.00121046)    );
  // itree = 1912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242169,-0.0075191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169118,-0.0453021) , 
0, 1.03529, 1, 0, 0.236637,-0.00940592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227273,0.0433428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47619,0.00340571) , 
1, 0.265197, 1, 0, 0.36965,0.0210577) , 
0, 1.26376, 1, 0, 0.253288,-0.00559241)    );
  // itree = 1913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298202,0.00905391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0222222,-0.0514503) , 
2, 1.36808, 1, 0, 0.264418,0.00650159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0913979,-0.0178132) , 
1, 1.54903, 1, 0, 0.248518,0.00346904)    );
  // itree = 1914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253751,-0.000855672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331361,-0.0115047) , 
2, 1.40754, 1, 0, 0.261457,-0.00744671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0363636,-0.0174584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192771,-0.0134511) , 
2, 0.637185, 1, 0, 0.130435,0.0336944) , 
0, 1.2265, 1, 0, 0.243175,-0.00170609)    );
  // itree = 1915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185283,-0.00685583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310924,-0.00837296) , 
3, -0.367691, 1, 0, 0.240413,0.010845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241192,0.0175887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317726,0.0187887) , 
2, 1.42823, 1, 0, 0.275449,-0.0163191) , 
2, 0.689402, 1, 0, 0.251976,0.00187975)    );
  // itree = 1916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952903,-0.00639265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489083,0.0282277) , 
3, -0.0556637, 1, 0, 0.226842,0.0093502) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11811,-0.0509083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274,-0.00874377) , 
1, -0.286534, 1, 0, 0.242424,-0.0176952) , 
0, 0.57508, 1, 0, 0.231732,0.000862966)    );
  // itree = 1917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348703,-0.000723935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271429,0.00958764) , 
0, -0.853921, 1, 0, 0.297039,-0.013592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245675,-0.02176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196947,0.000600326) , 
0, 0.58253, 1, 0, 0.211864,0.00369682) , 
0, 0.133846, 1, 0, 0.256655,-0.00539481)    );
  // itree = 1918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329978,-0.00294109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154463,0.000136035) , 
3, -0.35283, 1, 0, 0.237441,0.0082173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,0.0163517) , 
1, 1.58285, 1, 0, 0.251101,0.00532614)    );
  // itree = 1919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151203,0.00883708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27881,-0.00705408) , 
3, -1.29291, 1, 0, 0.244991,0.00415702) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299065,0.00362212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189542,0.0046263) , 
3, 0.552156, 1, 0, 0.24239,-0.0412078) , 
2, 0.30194, 1, 0, 0.243829,-0.0161143)    );
  // itree = 1920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196679,0.0268482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0787992,-0.0261859) , 
0, -0.120908, 1, 0, 0.148936,0.0067495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40678,-0.027091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549356,0.00803701) , 
2, 1.1949, 1, 0, 0.458204,-0.0235235) , 
3, 0.540694, 1, 0, 0.250765,-0.00321808)    );
  // itree = 1921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36182,-0.00903946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00951832) , 
1, 0.324332, 1, 0, 0.248527,0.00505531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118182,-0.0289612) , 
0, 1.55221, 1, 0, 0.241275,0.00861845)    );
  // itree = 1922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336694,-0.00742855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195122,-0.00837895) , 
1, 0.57445, 1, 0, 0.295292,-0.00964611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283333,-0.00921247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0920354,-0.0256018) , 
3, 0.536741, 1, 0, 0.199222,0.016027) , 
0, -0.362191, 1, 0, 0.233132,0.00696513)    );
  // itree = 1923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165782,-0.0193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357698,0.0008298) , 
3, -0.361512, 1, 0, 0.254116,0.00220115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308793,0.017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.01,-0.0429722) , 
3, 1.87846, 1, 0, 0.258065,-0.0216609) , 
2, 0.705366, 1, 0, 0.255287,-0.00487577)    );
  // itree = 1924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226496,-0.00713517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0883978,-0.0482595) , 
1, 0.728035, 1, 0, 0.187982,-0.015154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162225,0.000265086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56531,0.0191506) , 
3, 0.827586, 1, 0, 0.303759,0.0116299) , 
0, -0.402053, 1, 0, 0.265791,0.00284629)    );
  // itree = 1925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283537,-0.00245841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0505618,-0.0240654) , 
2, 1.36808, 1, 0, 0.260726,0.00232277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0635838,0.00821942) , 
3, 1.64135, 1, 0, 0.243596,0.00473752)    );
  // itree = 1926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325217,-0.000927215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260465,-0.00483061) , 
3, 0.158171, 1, 0, 0.315018,-0.000986408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0245902,-0.05646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116761,-0.00717011) , 
0, -0.241105, 1, 0, 0.0995406,-0.026275) , 
3, 0.555767, 1, 0, 0.245292,-0.00916948)    );
  // itree = 1927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0837178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255583,0.0161423) , 
0, -1.16405, 1, 0, 0.169967,-0.0111015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193333,-0.021097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305361,-0.00442866) , 
0, -0.311196, 1, 0, 0.293667,0.00949992) , 
0, -0.49228, 1, 0, 0.256975,0.00338907)    );
  // itree = 1928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0688448,-0.0142577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269868,0.0316456) , 
3, -0.349644, 1, 0, 0.151951,0.00686717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365217,-0.0382495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505025,-0.00319546) , 
0, 0.0131157, 1, 0, 0.473684,-0.0193285) , 
3, 0.753782, 1, 0, 0.235562,5.94848e-05)    );
  // itree = 1929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371154,-0.00589648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108374,-0.0180323) , 
3, 0.732839, 1, 0, 0.328238,0.0142335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1152,-0.00217411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0232558,-0.0528939) , 
3, 1.60075, 1, 0, 0.0994695,-0.00229589) , 
1, 0.767416, 1, 0, 0.241863,0.00799256)    );
  // itree = 1930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161616,-0.00235958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0359281,-0.0288159) , 
1, -0.521241, 1, 0, 0.10411,-0.0250449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31669,-0.00278946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23085,0.00634708) , 
0, -0.0771581, 1, 0, 0.267231,0.00766191) , 
2, -0.976087, 1, 0, 0.237741,0.00174909)    );
  // itree = 1931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0328467,-0.0292701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277583,-0.00460191) , 
1, -0.990891, 1, 0, 0.238067,0.00576195) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362205,0.0350119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246305,-0.0047542) , 
3, 1.60244, 1, 0, 0.290909,-0.0328861) , 
3, 1.30934, 1, 0, 0.24667,-0.000530033)    );
  // itree = 1932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259542,0.0491516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231772,-0.00972339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401316,0.023342) , 
0, 1.46819, 1, 0, 0.245786,-0.00489629) , 
1, -1.23776, 1, 0, 0.246701,-0.00128057)    );
  // itree = 1933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460925,0.00855614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230769,0.00398549) , 
3, -0.473776, 1, 0, 0.344937,-0.000484641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106987,-0.00589342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107595,0.0233825) , 
3, 0.789667, 1, 0, 0.107235,-0.0255786) , 
1, 0.807077, 1, 0, 0.254661,-0.0100149)    );
  // itree = 1934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306977,0.00367583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289557,-0.00111554) , 
1, 0.162984, 1, 0, 0.298356,-0.00278131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268085,0.00841556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0932836,-0.02007) , 
3, 1.09085, 1, 0, 0.204607,0.0198879) , 
0, 0.446909, 1, 0, 0.26402,0.00552136)    );
  // itree = 1935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0645161,0.0123399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227704,0.00702225) , 
3, -1.63846, 1, 0, 0.185133,0.0138655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288756,-9.64301e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00979119) , 
1, 1.54903, 1, 0, 0.27391,-0.00710232) , 
0, -0.362191, 1, 0, 0.242574,0.00029869)    );
  // itree = 1936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,-0.013518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232787,0.0412029) , 
3, -1.30311, 1, 0, 0.15619,0.017384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266171,-0.00586719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.0288533) , 
1, 1.63589, 1, 0, 0.273982,-0.00863923) , 
2, -0.67247, 1, 0, 0.242655,-0.00171814)    );
  // itree = 1937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309507,-0.00311049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148936,0.00206067) , 
3, 0.73045, 1, 0, 0.290976,0.00270097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0859729,0.00145049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.07,-0.0153587) , 
2, 1.51309, 1, 0, 0.0809969,-0.0215042) , 
3, 1.22047, 1, 0, 0.25641,-0.00128358)    );
  // itree = 1938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368687,-0.000739336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415842,0.0273029) , 
1, -0.121454, 1, 0, 0.384615,-0.0333793) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312925,0.0142184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218194,0.00420234) , 
0, -0.740506, 1, 0, 0.226562,-0.00558416) , 
0, -0.940853, 1, 0, 0.250637,-0.00981786)    );
  // itree = 1939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200378,0.00160639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301496,-0.00205737) , 
3, -0.884868, 1, 0, 0.263233,0.0137338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221359,-0.017466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26087,0.0192696) , 
0, 1.2852, 1, 0, 0.230769,-0.022022) , 
2, 0.689402, 1, 0, 0.252652,0.00207951)    );
  // itree = 1940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225352,0.0106309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0617978,-0.0478437) , 
2, 1.34721, 1, 0, 0.208621,0.00514431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601942,0.0157416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695238,0.0227691) , 
0, 1.24308, 1, 0, 0.649038,0.0393707) , 
3, 1.55602, 1, 0, 0.255647,0.00879887)    );
  // itree = 1941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438172,0.00362701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178099,0.00107023) , 
2, -0.170177, 1, 0, 0.300952,-0.00208794) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970874,-0.00239636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10231,0.00449462) , 
2, 0.654939, 1, 0, 0.100196,-0.0420707) , 
3, 0.853537, 1, 0, 0.251919,-0.0118534)    );
  // itree = 1942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171591,-0.00891456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292683,0.0244296) , 
2, -0.0681148, 1, 0, 0.201371,0.00360022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291613,-0.00238374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361905,-0.0107136) , 
1, 1.63992, 1, 0, 0.3,-0.0187201) , 
2, 0.30194, 1, 0, 0.243771,-0.00599521)    );
  // itree = 1943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35277,0.028405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259021,0.00450091) , 
2, -0.956007, 1, 0, 0.275989,-0.00599064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0173913,-0.0654994) , 
1, 1.68939, 1, 0, 0.261194,-0.00201039)    );
  // itree = 1944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235632,0.0347726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261342,0.00140076) , 
0, -1.35128, 1, 0, 0.258769,0.00443216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211009,-0.0415973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38,-0.00290849) , 
1, 1.8435, 1, 0, 0.291866,-0.0298385) , 
1, 1.5317, 1, 0, 0.26232,0.000755271)    );
  // itree = 1945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368512,-0.00739604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193077,-0.00522378) , 
3, -0.86348, 1, 0, 0.247071,0.00174565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101562,0.0567986) , 
3, 1.87344, 1, 0, 0.237787,-0.000957883)    );
  // itree = 1946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246014,0.000654731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433071,-0.0124414) , 
2, 1.65499, 1, 0, 0.25863,0.00209981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,0.051395) , 
3, 1.84308, 1, 0, 0.25025,-0.0031421)    );
  // itree = 1947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243211,0.0113145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661157,0.0326832) , 
0, 1.33509, 1, 0, 0.271074,-0.00182135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216374,-0.010228) , 
3, 1.63849, 1, 0, 0.266365,0.000953539)    );
  // itree = 1948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239801,0.0134829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117378,-0.0307794) , 
0, 0.112177, 1, 0, 0.191451,-0.00214053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.718232,0.0382687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509091,0.0113865) , 
1, 1.19487, 1, 0, 0.618497,0.0480272) , 
3, 1.22047, 1, 0, 0.265072,0.00650822)    );
  // itree = 1949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380058,-0.00337782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0798969,-0.0243703) , 
3, -0.300612, 1, 0, 0.272222,0.0124779) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254682,0.0189869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131707,-0.0176295) , 
0, 0.977846, 1, 0, 0.201271,-0.0167132) , 
0, 0.0899978, 1, 0, 0.23913,-0.00113692)    );
  // itree = 1950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228682,-0.00733379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,0.0113331) , 
0, -0.0221368, 1, 0, 0.205333,-0.0135362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322506,-0.0142535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144531,-0.0119787) , 
3, 0.20737, 1, 0, 0.23865,0.00512279) , 
1, -0.676742, 1, 0, 0.232419,0.00163294)    );
  // itree = 1951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00729927,-0.0418317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292509,0.0013087) , 
1, -1.41766, 1, 0, 0.271028,-0.00374997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208955,0.0409407) , 
3, 1.76176, 1, 0, 0.266769,-0.00695129)    );
  // itree = 1952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229369,-0.00702307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125828,-0.0557445) , 
1, 1.48186, 1, 0, 0.220678,-0.0108413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352459,0.0386092) , 
2, 1.75447, 1, 0, 0.229047,-0.00766688)    );
  // itree = 1953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528302,-0.0118838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458564,0.0183895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19965,0.00145537) , 
1, -0.755274, 1, 0, 0.224393,-0.00863005) , 
1, -1.23776, 1, 0, 0.24793,-0.00584583)    );
  // itree = 1954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477387,0.034658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309278,0.00422309) , 
0, -1.22721, 1, 0, 0.333822,-0.00510399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0363636,-0.0197283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13879,-0.0034015) , 
0, -0.0384529, 1, 0, 0.115543,0.027422) , 
3, 0.440469, 1, 0, 0.257895,0.00621009)    );
  // itree = 1955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722222,-0.0151574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218229,-0.0132905) , 
3, -1.61427, 1, 0, 0.190824,0.0210532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384707,0.0235818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15859,-0.0367122) , 
3, 1.52342, 1, 0, 0.336466,-0.0037536) , 
0, -0.0142405, 1, 0, 0.267425,0.00800603)    );
  // itree = 1956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142352,-0.00012172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312,0.0658492) , 
3, 0.271207, 1, 0, 0.159236,0.0061477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672269,0.0112011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409683,-0.0251268) , 
1, 0.113466, 1, 0, 0.457317,-0.0293518) , 
3, 0.479711, 1, 0, 0.261506,-0.00603205)    );
  // itree = 1957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396597,-0.00274217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145147,-0.0088128) , 
1, -0.0240634, 1, 0, 0.246953,-0.00494962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280374,0.0612554) , 
1, 1.7097, 1, 0, 0.248746,-0.0091486)    );
  // itree = 1958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231034,0.0051272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278777,0.00545299) , 
1, -0.987037, 1, 0, 0.271706,-0.00511337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0723684,-0.0128329) , 
3, 1.74551, 1, 0, 0.257346,-0.00828721)    );
  // itree = 1959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106977,-0.02369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616766,0.0108435) , 
1, 1.06218, 1, 0, 0.249581,-0.00113769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261905,0.0296563) , 
3, 1.64499, 1, 0, 0.250638,-0.00486318)    );
  // itree = 1960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181347,-0.0300616) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251085,-6.98585e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457944,0.0274042) , 
0, 1.51247, 1, 0, 0.263953,0.00277721) , 
1, -1.24613, 1, 0, 0.255619,-0.000881819)    );
  // itree = 1961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.70297,0.00412358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,-0.0406751) , 
3, -1.66577, 1, 0, 0.483568,0.0257359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241359,0.00249426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132743,0.0781693) , 
3, 1.85456, 1, 0, 0.234506,-0.00670802) , 
2, -1.31469, 1, 0, 0.260978,-0.00325964)    );
  // itree = 1962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242344,-0.000950244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0516796,-0.0419524) , 
0, 0.0357757, 1, 0, 0.177504,0.0143296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33122,0.0162915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255708,-0.0185392) , 
1, 1.39274, 1, 0, 0.311765,-0.0113268) , 
2, 0.30194, 1, 0, 0.234909,0.0033598)    );
  // itree = 1963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221711,-0.00775851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373913,0.00589665) , 
3, 0.806314, 1, 0, 0.249866,-0.00543047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196203,0.0714337) , 
3, 1.76021, 1, 0, 0.245675,-0.0110873)    );
  // itree = 1964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0443038,-0.0243281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.444444,0.0666347) , 
3, -1.19881, 1, 0, 0.214545,0.0329181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158416,-0.0740252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239216,-0.00897963) , 
0, -0.972742, 1, 0, 0.229792,-0.0146848) , 
1, -0.887572, 1, 0, 0.227703,-0.0081622)    );
  // itree = 1965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324074,-0.00951576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255319,-0.00599689) , 
0, -0.268514, 1, 0, 0.289788,0.0101833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168919,0.0251744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0829694,0.00481775) , 
3, 1.52212, 1, 0, 0.131429,-0.0426918) , 
3, 0.853537, 1, 0, 0.248893,-0.00347111)    );
  // itree = 1966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189873,-0.0147933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267026,-0.00264098) , 
1, -0.791106, 1, 0, 0.253474,0.00229704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764331,-0.00241785) , 
3, 1.76176, 1, 0, 0.239264,0.00656472)    );
  // itree = 1967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181159,-0.0207818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256954,0.00332814) , 
2, -0.065042, 1, 0, 0.217309,0.00144597) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384615,-0.0461235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153191,0.00777015) , 
2, 0.902897, 1, 0, 0.271784,0.025336) , 
3, 0.802707, 1, 0, 0.230024,0.00702224)    );
  // itree = 1968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251462,0.0270501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200732,-0.00895789) , 
1, -1.23776, 1, 0, 0.205525,-0.00369446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637755,0.0223777) , 
3, 1.55602, 1, 0, 0.247757,0.000676821)    );
  // itree = 1969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285802,0.0022475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0817844,-0.0152104) , 
3, 1.09612, 1, 0, 0.25675,-0.00545472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0571429,-0.0124149) , 
3, 1.93088, 1, 0, 0.246239,-0.00861662)    );
  // itree = 1970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283077,-0.00230972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236779,0.0140534) , 
0, -0.105719, 1, 0, 0.26176,-0.00136036) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190141,0.0215652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125984,0.0300198) , 
3, 1.28155, 1, 0, 0.159851,-0.0547537) , 
0, 1.26376, 1, 0, 0.248555,-0.00827886)    );
  // itree = 1971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215646,-0.00546482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3829,0.025855) , 
3, 0.726135, 1, 0, 0.241518,-0.00464936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362319,0.0179323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0945946,-0.0513261) , 
0, 1.15142, 1, 0, 0.223776,0.033104) , 
3, 1.30934, 1, 0, 0.239012,0.000682717)    );
  // itree = 1972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321691,0.0361331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160099,-0.0120016) , 
1, 0.398556, 1, 0, 0.252632,0.0140182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23702,-0.0271756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265886,0.00451927) , 
1, 0.432209, 1, 0, 0.253602,-0.00879834) , 
0, -0.0324937, 1, 0, 0.253139,0.00208852)    );
  // itree = 1973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44302,-0.00325634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211921,0.0439884) , 
3, 0.382558, 1, 0, 0.40211,-0.00980402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128371,-0.0101057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121693,-0.00693182) , 
1, 1.54157, 1, 0, 0.12724,0.0115697) , 
1, 0.233753, 1, 0, 0.246318,0.00231029)    );
  // itree = 1974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278921,0.0032251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255172,0.000644884) , 
1, 1.32996, 1, 0, 0.274868,0.00188097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0368098,0.0290183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0993377,-0.0116684) , 
1, 1.26324, 1, 0, 0.066879,0.0229209) , 
3, 1.29216, 1, 0, 0.242424,0.0051629)    );
  // itree = 1975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0232558,0.0301534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304636,0.00769714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234681,-0.015894) , 
2, 0.461847, 1, 0, 0.275219,0.00748766) , 
1, -1.19679, 1, 0, 0.253507,0.00441993)    );
  // itree = 1976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220083,-0.00398183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348485,0.0502012) , 
2, 0.853513, 1, 0, 0.230769,0.0016452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0277778,0.00153386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425532,-0.0376839) , 
3, 0.696281, 1, 0, 0.253012,-0.0346657) , 
2, 1.12881, 1, 0, 0.234619,-0.00464011)    );
  // itree = 1977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453704,0.012399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25552,-0.0071136) , 
0, -1.67615, 1, 0, 0.268163,0.00344906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916031,0.0246769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828729,0.00832544) , 
1, 0.886102, 1, 0, 0.0865385,-0.0274361) , 
3, 1.27365, 1, 0, 0.2399,-0.001357)    );
  // itree = 1978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18552,-0.014462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256799,-0.00631175) , 
1, -1.102, 1, 0, 0.248058,0.00324084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0612245,-0.0176417) , 
3, 1.77248, 1, 0, 0.233966,-0.000515946)    );
  // itree = 1979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0657277,-0.000470061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293065,0.00427462) , 
1, -0.554772, 1, 0, 0.238257,0.00551861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509434,0.0228701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252174,0.0159854) , 
3, 0.831944, 1, 0, 0.375566,-0.051575) , 
1, 1.47592, 1, 0, 0.253521,-0.000828312)    );
  // itree = 1980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620253,-0.0168147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297269,0.0108378) , 
3, -0.485184, 1, 0, 0.190586,0.00189756) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59292,-0.0590332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507937,-0.00260881) , 
1, 0.759809, 1, 0, 0.534247,-0.0347669) , 
3, 1.27365, 1, 0, 0.250119,-0.00445391)    );
  // itree = 1981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345528,-0.00223209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276085,0.00589267) , 
0, -1.10741, 1, 0, 0.288939,-0.0163823) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202073,-0.00786352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0840336,0.00651737) , 
2, 1.75131, 1, 0, 0.181948,0.0153827) , 
0, 0.46308, 1, 0, 0.252097,-0.00544402)    );
  // itree = 1982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348525,0.000693148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317204,-0.00104434) , 
3, -0.685811, 1, 0, 0.335123,-0.0078755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0680529,-0.0129213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31746,0.0245552) , 
2, 1.20483, 1, 0, 0.148528,0.0231653) , 
3, 0.312307, 1, 0, 0.265228,0.00375177)    );
  // itree = 1983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10682,-0.0135132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59707,0.0094697) , 
1, 0.879105, 1, 0, 0.25865,-0.00149365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,0.0209548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0283019,-0.0458694) , 
3, 1.47866, 1, 0, 0.231111,0.0225697) , 
2, 1.53606, 1, 0, 0.255533,0.00122982)    );
  // itree = 1984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211864,0.0420011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276636,0.00772185) , 
0, -1.59608, 1, 0, 0.2722,0.00909493) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00757576,-0.0261959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319249,-0.0188124) , 
3, 0.490019, 1, 0, 0.2,-0.0191508) , 
1, 1.41354, 1, 0, 0.260155,0.00438275)    );
  // itree = 1985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279729,-0.000650097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0675676,0.00195979) , 
2, 1.5124, 1, 0, 0.261999,0.00284053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.00302615) , 
3, 1.63849, 1, 0, 0.245351,0.0064956)    );
  // itree = 1986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436464,-0.0197136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328413,0.0171089) , 
0, -1.07762, 1, 0, 0.371681,-0.0240244) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234043,0.00299272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137931,-0.0104526) , 
0, 1.43469, 1, 0, 0.222819,0.00752847) , 
3, -1.04915, 1, 0, 0.257467,0.000184545)    );
  // itree = 1987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.076005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208661,3.12682e-06) , 
0, -1.3329, 1, 0, 0.153846,0.00950385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210983,0.0145259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418333,0.00109885) , 
1, 0.670784, 1, 0, 0.307276,-0.0112911) , 
0, -0.402053, 1, 0, 0.253912,-0.00405854)    );
  // itree = 1988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782123,-0.0108769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416961,0.041858) , 
3, -0.860159, 1, 0, 0.227769,0.0172674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0542373,-0.0385656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429825,0.00765697) , 
3, 0.238099, 1, 0, 0.255887,-0.00226601) , 
0, -0.402053, 1, 0, 0.246475,0.00427233)    );
  // itree = 1989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55,-0.000916598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242848,-0.00235748) , 
1, -1.13141, 1, 0, 0.274387,-0.00240182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.075,0.00377716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115646,0.0137118) , 
1, 1.25983, 1, 0, 0.0944625,0.046667) , 
3, 1.30934, 1, 0, 0.247573,0.00491087)    );
  // itree = 1990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25814,0.00113351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462963,0.00971016) , 
1, 1.65151, 1, 0, 0.270241,-0.00573052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141509,-0.00343934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131387,-0.0111857) , 
0, 1.50994, 1, 0, 0.135802,0.0242102) , 
0, 1.32355, 1, 0, 0.254466,-0.00221744)    );
  // itree = 1991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0238095,0.0258891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113001,0.0057526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410933,-0.00168085) , 
1, 0.398033, 1, 0, 0.280786,-0.00491869) , 
1, -1.23776, 1, 0, 0.259747,-0.00809586)    );
  // itree = 1992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186299,-0.00980256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348315,-0.0391451) , 
3, 0.893392, 1, 0, 0.207273,-0.0142306) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333966,0.0259306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.0342812) , 
1, 1.59164, 1, 0, 0.341158,0.0100775) , 
2, 0.648293, 1, 0, 0.249752,-0.00651815)    );
  // itree = 1993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622378,0.0169199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27178,0.00379897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0868762,0.00665886) , 
1, 1.22757, 1, 0, 0.218684,-0.0130574) , 
1, -1.28651, 1, 0, 0.247163,-0.0172481)    );
  // itree = 1994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442478,-0.00861071) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291667,-0.011952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143064,0.0171388) , 
3, 0.35491, 1, 0, 0.2359,-0.00231226) , 
0, -1.61601, 1, 0, 0.247828,0.000603049)    );
  // itree = 1995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.0409099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31746,0.00673813) , 
2, -1.59189, 1, 0, 0.277132,0.0129755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204204,0.0012157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314421,-0.00747531) , 
0, 0.814042, 1, 0, 0.23699,-0.00855612) , 
2, -0.656951, 1, 0, 0.247678,-0.00282325)    );
  // itree = 1996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242485,0.0208951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138132,-0.0124734) , 
0, -0.616028, 1, 0, 0.172233,0.000448233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261682,-0.00453602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651235,0.0257636) , 
2, 0.295661, 1, 0, 0.554524,0.0327759) , 
3, 0.824791, 1, 0, 0.256384,0.00756428)    );
  // itree = 1997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615894,0.0229501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351351,-0.0198741) , 
1, -1.2925, 1, 0, 0.48495,0.0287736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249306,0.00992132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165975,0.00989493) , 
0, 1.25844, 1, 0, 0.237359,-0.0110852) , 
1, -0.887572, 1, 0, 0.274747,-0.00506614)    );
  // itree = 1998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305485,0.00389508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0636704,-0.0211403) , 
3, 1.04759, 1, 0, 0.2703,0.00437544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0932203,0.00965013) , 
3, 1.87058, 1, 0, 0.259601,0.0015241)    );
  // itree = 1999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0438596,-0.0368013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329822,0.0124169) , 
1, -0.469111, 1, 0, 0.252663,-0.00116207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288732,0.00676602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229508,-0.0425323) , 
1, 1.24849, 1, 0, 0.261364,0.0344603) , 
3, 1.27365, 1, 0, 0.253838,0.00365078)    );
  // itree = 2000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254673,0.00378903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142255,-0.0222645) , 
1, 0.162984, 1, 0, 0.195568,-0.00687611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.656716,0.0258924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7,0.00533882) , 
0, 1.23923, 1, 0, 0.67623,0.0265139) , 
3, 1.522, 1, 0, 0.252806,-0.00289995)    );
  // itree = 2001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601942,-0.0106667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415789,-0.00843374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209762,0.00083645) , 
1, -0.792498, 1, 0, 0.230246,0.00137072) , 
1, -1.43776, 1, 0, 0.249255,0.00372928)    );
  // itree = 2002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1787,0.00552161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396277,-0.00234926) , 
2, -0.497591, 1, 0, 0.303982,-0.00625539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0242915,-0.0632857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153333,0.00411995) , 
0, 0.242864, 1, 0, 0.107604,0.0171115) , 
3, 0.440469, 1, 0, 0.235647,0.00187578)    );
  // itree = 2003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32,0.0331021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229415,-0.00188782) , 
2, -1.47882, 1, 0, 0.23722,-0.0093722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460784,0.0414116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09,-0.026816) , 
0, 1.18494, 1, 0, 0.277228,-0.0456323) , 
3, 1.57074, 1, 0, 0.241379,-0.0131419)    );
  // itree = 2004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00881057,-0.0670939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232092,0.0070103) , 
3, -1.64475, 1, 0, 0.200863,0.00133534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401747,-0.0271051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838095,0.0167334) , 
3, 1.99174, 1, 0, 0.538922,-0.0236823) , 
3, 1.27365, 1, 0, 0.258559,-0.00293441)    );
  // itree = 2005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393701,-0.0241649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292683,0.0162273) , 
3, -1.68487, 1, 0, 0.344,-0.0218342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290909,-0.0109451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211726,-0.00194324) , 
0, -0.645934, 1, 0, 0.223757,0.0125771) , 
0, -1.05347, 1, 0, 0.23835,0.00840095)    );
  // itree = 2006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425197,-0.0137456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393939,0.0408592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229499,-0.00126609) , 
0, -0.983167, 1, 0, 0.241379,-0.00707359) , 
0, -1.43147, 1, 0, 0.253327,-0.010204)    );
  // itree = 2007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0987224,-0.0281437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788889,0.0283737) , 
1, 0.788267, 1, 0, 0.263484,0.0120067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223853,0.00691388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0160141) , 
2, 1.18849, 1, 0, 0.265143,-0.0128263) , 
2, 0.314309, 1, 0, 0.264207,0.00117474)    );
  // itree = 2008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223529,0.0337457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243502,-0.00456995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226776,-0.0245106) , 
0, 1.05225, 1, 0, 0.240153,-0.00821321) , 
0, -1.29224, 1, 0, 0.238739,-0.00488427)    );
  // itree = 2009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404642,0.0033364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113883,-0.00605421) , 
1, 0.377333, 1, 0, 0.264506,-0.00490948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,0.0465349) , 
1, 1.65151, 1, 0, 0.263054,-0.00807641)    );
  // itree = 2010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42,-0.0247932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216418,-0.00709635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229385,-0.00347697) , 
1, -0.220858, 1, 0, 0.225668,-0.00382891) , 
0, -1.68098, 1, 0, 0.235533,-0.000132277)    );
  // itree = 2011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.03125,-0.00769002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164773,0.00849115) , 
3, -0.855205, 1, 0, 0.0856481,0.0209189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302041,0.0156275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329091,-0.00431948) , 
0, -0.402053, 1, 0, 0.320755,-0.0119685) , 
1, -0.564482, 1, 0, 0.270524,-0.00494212)    );
  // itree = 2012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255102,0.0274877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.081422,-0.0368375) , 
0, -0.900213, 1, 0, 0.125214,-0.00667602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552561,0.0297623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401848,-0.00323806) , 
0, 0.558766, 1, 0, 0.471393,0.0178743) , 
3, 0.275101, 1, 0, 0.266497,0.0033435)    );
  // itree = 2013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288071,-0.00376471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0603448,0.0069071) , 
2, 1.49807, 1, 0, 0.272459,0.00236057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,0.013059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.092437,-0.0181164) , 
1, 1.38231, 1, 0, 0.0869565,0.0436148) , 
3, 1.29216, 1, 0, 0.244601,0.00855595)    );
  // itree = 2014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234469,0.00852066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112016,-0.028954) , 
1, -0.2272, 1, 0, 0.173737,0.0173767) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298701,-0.00617012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572727,0.0846621) , 
2, 1.90749, 1, 0, 0.325833,-0.00859746) , 
2, 0.0236201, 1, 0, 0.254165,0.00364166)    );
  // itree = 2015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108929,-0.0325054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341326,0.00580187) , 
0, -0.473442, 1, 0, 0.238771,-0.00553908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.775,0.0410099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182104,-0.0210705) , 
2, -0.331461, 1, 0, 0.27609,0.0172816) , 
3, 0.331768, 1, 0, 0.252715,0.00298769)    );
  // itree = 2016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229072,0.00601451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0125786,-0.0717206) , 
0, 1.18156, 1, 0, 0.208824,0.00130005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482143,-0.00617867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611111,0.025778) , 
0, 0.748315, 1, 0, 0.564516,0.0291889) , 
3, 1.27365, 1, 0, 0.263682,0.00560131)    );
  // itree = 2017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484163,-0.00477688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268542,-0.0062084) , 
3, -0.641584, 1, 0, 0.382953,0.0109067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159176,-0.00979044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169381,0.0312824) , 
3, 0.309594, 1, 0, 0.164634,-0.0227543) , 
1, 0.104677, 1, 0, 0.256436,-0.00860002)    );
  // itree = 2018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12963,-0.0212213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327103,0.0433343) , 
2, -0.77017, 1, 0, 0.208178,-0.0342154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0110231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186424,-0.000347714) , 
3, -0.296715, 1, 0, 0.241974,0.00377493) , 
1, -0.999833, 1, 0, 0.237314,-0.0014631)    );
  // itree = 2019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00606061,-0.0541921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256988,-0.00233914) , 
1, -1.27602, 1, 0, 0.228493,-0.00376824) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290419,-0.00676893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211538,-0.021693) , 
0, 1.19527, 1, 0, 0.265306,0.0311672) , 
3, 0.802707, 1, 0, 0.237777,0.00504205)    );
  // itree = 2020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272503,0.00728265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229478,-0.0120629) , 
1, 0.0613383, 1, 0, 0.248009,-0.00283999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375839,0.0307439) , 
1, 1.56373, 1, 0, 0.257382,0.000692606)    );
  // itree = 2021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366197,-0.00018566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27974,0.00122367) , 
0, -0.69946, 1, 0, 0.304261,-0.0040132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0534759,0.00324931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127869,-0.00305539) , 
0, 0.506745, 1, 0, 0.0995935,0.0153714) , 
3, 0.795947, 1, 0, 0.253761,0.000769757)    );
  // itree = 2022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284537,0.0149128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144186,0.0227165) , 
0, 1.26376, 1, 0, 0.267708,-0.00256468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537037,0.0428406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205882,-0.00274023) , 
3, 1.08747, 1, 0, 0.37619,0.0279583) , 
1, 1.51134, 1, 0, 0.279081,0.000635433)    );
  // itree = 2023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00840336,0.133627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,0.0331084) , 
3, -1.37096, 1, 0, 0.0550847,-0.0334857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280793,0.00224797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258294,-0.0112206) , 
3, 0.205652, 1, 0, 0.270255,0.000525976) , 
1, -0.991711, 1, 0, 0.245339,-0.00341257)    );
  // itree = 2024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,-0.00123003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493243,-0.0254779) , 
3, 1.58959, 1, 0, 0.2362,-0.00424311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481481,0.0492299) , 
2, 1.85179, 1, 0, 0.249498,0.000169367)    );
  // itree = 2025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463277,-0.0161173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487179,0.0180718) , 
0, -0.379627, 1, 0, 0.474474,-0.0235179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247273,-0.00607403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180357,-0.000875969) , 
3, -0.530819, 1, 0, 0.202395,0.00455596) , 
1, -0.800226, 1, 0, 0.247629,-0.00011133)    );
  // itree = 2026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37218,0.00741745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369792,0.00876989) , 
1, -0.405245, 1, 0, 0.371179,-0.0137069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108303,-0.0289303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243978,0.000370496) , 
1, -0.409525, 1, 0, 0.219949,0.0043844) , 
3, -1.12835, 1, 0, 0.254204,0.00028657)    );
  // itree = 2027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0444444,-0.0141067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327586,0.0101932) , 
1, -0.391299, 1, 0, 0.226624,-0.00794379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292007,-0.00920054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0929179) , 
1, 1.61207, 1, 0, 0.24758,0.0228225) , 
3, 0.356305, 1, 0, 0.234257,0.00326226)    );
  // itree = 2028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193987,0.00711206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493711,-0.0126387) , 
3, 0.828803, 1, 0, 0.249563,0.000766917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203883,0.0783278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459627,0.0057976) , 
2, 0.590046, 1, 0, 0.359848,0.0342917) , 
0, 1.26376, 1, 0, 0.264275,0.00523915)    );
  // itree = 2029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40411,0.00813872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115607,0.022141) , 
1, 0.660444, 1, 0, 0.322422,-0.02295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226473,-0.0083117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0583942,-0.0225312) , 
3, 1.79399, 1, 0, 0.210526,0.00816825) , 
0, -0.488206, 1, 0, 0.243796,-0.00108395)    );
  // itree = 2030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325658,-0.0134466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245053,-0.000713926) , 
0, -0.887505, 1, 0, 0.260198,-0.002024) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146018,0.0030474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188119,0.00365993) , 
0, 1.54687, 1, 0, 0.159021,0.0250742) , 
0, 1.13798, 1, 0, 0.243188,0.00253183)    );
  // itree = 2031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156946,-0.0158362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434389,0.00307125) , 
0, 0.224168, 1, 0, 0.245487,-0.000582417) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262295,0.0803163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,0.00451068) , 
1, 0.0619297, 1, 0, 0.306092,-0.0206592) , 
3, 0.471159, 1, 0, 0.265306,-0.00714787)    );
  // itree = 2032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14303,-0.00646329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415094,-0.0304363) , 
3, 0.299253, 1, 0, 0.19865,-0.0125803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334262,0.046045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252951,-0.00728086) , 
1, 0.323796, 1, 0, 0.283613,0.0144761) , 
0, 0.133846, 1, 0, 0.239316,0.000369759)    );
  // itree = 2033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275761,-0.00189316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722222,-0.0281379) , 
1, 1.5027, 1, 0, 0.256356,0.00730746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164948,0.00669852) , 
0, 1.32631, 1, 0, 0.247839,0.00271059)    );
  // itree = 2034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269822,0.00510555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376344,0.00608576) , 
2, 0.697661, 1, 0, 0.28904,-0.0133305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239161,-0.0047025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729614,-0.019764) , 
3, 1.30769, 1, 0, 0.198312,0.00826733) , 
0, 0.0296075, 1, 0, 0.245579,-0.00298451)    );
  // itree = 2035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12,-0.0225555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284404,0.0279299) , 
2, 1.34045, 1, 0, 0.132948,0.00535892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.755187,0.0249827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432343,0.00874397) , 
3, 0.39681, 1, 0, 0.575368,-0.0232945) , 
1, 1.21354, 1, 0, 0.25778,-0.00272587)    );
  // itree = 2036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0871671,-0.0337678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288462,0.0221086) , 
2, -0.849609, 1, 0, 0.224364,0.00641398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309677,-0.0180531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383838,0.00266494) , 
2, 1.58107, 1, 0, 0.331825,-0.0131324) , 
2, 0.648293, 1, 0, 0.260714,-0.000197873)    );
  // itree = 2037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31136,0.00156537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,-0.0206259) , 
3, 0.624895, 1, 0, 0.29525,-0.00294979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0735294,-0.00514186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0355769) , 
0, 1.35435, 1, 0, 0.111588,-0.0496718) , 
3, 0.897545, 1, 0, 0.252964,-0.0137069)    );
  // itree = 2038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402913,-0.00824576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279554,0.00516584) , 
0, -1.17832, 1, 0, 0.295938,-0.00559359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.058651,-0.0228631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126126,-0.020467) , 
0, 1.40804, 1, 0, 0.0752212,0.0335568) , 
3, 0.893134, 1, 0, 0.246131,0.00324114)    );
  // itree = 2039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251022,0.00371657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427835,0.049249) , 
3, 1.45925, 1, 0, 0.269009,-0.000199209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126214,-0.0489861) , 
0, 1.58326, 1, 0, 0.261692,0.00347319)    );
  // itree = 2040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,0.00379834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39644,0.0192153) , 
3, -0.348039, 1, 0, 0.231399,0.0117148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324675,-0.0465624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313559,0.0013554) , 
1, 0.454036, 1, 0, 0.316294,-0.00913871) , 
2, 0.689402, 1, 0, 0.258376,0.00508824)    );
  // itree = 2041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349057,-0.0102797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290749,0.0171639) , 
0, 0.638642, 1, 0, 0.336744,-0.0051043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10219,-0.0137754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104839,-0.00269643) , 
3, 0.897465, 1, 0, 0.103261,0.0241083) , 
2, 0.342305, 1, 0, 0.229073,0.00836717)    );
  // itree = 2042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377593,-0.0135954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322709,0.00506223) , 
0, -1.05097, 1, 0, 0.336016,-0.0123869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0829016,-0.0197716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186799,0.00730845) , 
0, -0.197434, 1, 0, 0.166667,0.00661993) , 
3, -0.139172, 1, 0, 0.251256,-0.00287394)    );
  // itree = 2043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275745,0.00112233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291284,0.000727374) , 
2, 1.01108, 1, 0, 0.279289,0.0111182) , 
3, -1.98613, 1, 0, 0.263574,0.00831817)    );
  // itree = 2044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169374,7.25962e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.074813,-0.0364052) , 
1, -0.406433, 1, 0, 0.107867,-0.010484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487365,0.0217439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,-0.00280663) , 
2, 1.49933, 1, 0, 0.490463,0.0231311) , 
3, 0.414913, 1, 0, 0.250635,0.0020597)    );
  // itree = 2045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.769231,0.0409263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262019,0.00655515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199804,-0.00351964) , 
0, -0.13571, 1, 0, 0.227739,0.00127596) , 
1, -1.58794, 1, 0, 0.256515,-0.00195105)    );
  // itree = 2046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460784,0.0190472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344156,0.0116921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226474,-0.0021502) , 
0, -0.771535, 1, 0, 0.245531,-0.0052328) , 
0, -1.7049, 1, 0, 0.256487,-0.00208696)    );
  // itree = 2047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220749,-0.00667542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32,0.00589157) , 
3, 1.51559, 1, 0, 0.228647,0.00399568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325153,-0.0153571) , 
0, 1.40235, 1, 0, 0.236328,-0.00258488)    );
  // itree = 2048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134615,0.107428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182512,-0.0151585) , 
2, -1.59458, 1, 0, 0.179288,-0.00637783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530769,0.0469674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51952,0.00582185) , 
0, 0.301051, 1, 0, 0.522678,0.0280082) , 
3, 0.853537, 1, 0, 0.258466,0.00155082)    );
  // itree = 2049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332737,0.0104442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220183,-0.00432263) , 
0, -0.53067, 1, 0, 0.253883,-0.0037856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.049505,-0.0254504) , 
3, 2.00929, 1, 0, 0.243394,0.000656633)    );
  // itree = 2050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.00456456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411111,-0.00204218) , 
2, -0.187326, 1, 0, 0.308943,0.0165179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224414,2.21183e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213528,-0.0063089) , 
1, 0.601922, 1, 0, 0.219169,-0.00945297) , 
0, -0.691888, 1, 0, 0.240642,-0.00324117)    );
  // itree = 2051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215818,-0.009701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481865,0.0110158) , 
0, 0.900791, 1, 0, 0.270501,0.00187627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0991736,-0.0472014) , 
2, 1.82177, 1, 0, 0.26013,0.00543473)    );
  // itree = 2052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180602,0.0209095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237624,-0.00949026) , 
2, 0.0505464, 1, 0, 0.209302,0.00413385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.715686,0.0235701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728155,0.0281528) , 
0, 1.15142, 1, 0, 0.721951,0.0480903) , 
3, 1.63849, 1, 0, 0.261561,0.00861474)    );
  // itree = 2053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435185,0.0115819) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252874,0.000505796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,0.0192494) , 
3, 1.8016, 1, 0, 0.242179,-0.00960659) , 
0, -1.68098, 1, 0, 0.252803,-0.00598736)    );
  // itree = 2054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290612,-0.00710169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0206897,-0.00435414) , 
3, 1.23305, 1, 0, 0.262044,-0.0106618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132075,-0.012786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210643,-0.00768313) , 
1, 1.27942, 1, 0, 0.190164,0.0135908) , 
1, 1.02693, 1, 0, 0.239899,-0.00319006)    );
  // itree = 2055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208638,-0.000324915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446352,0.05601) , 
3, 1.14122, 1, 0, 0.240506,-0.00347073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633333,-0.0200488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297619,0.0197661) , 
2, 0.637185, 1, 0, 0.4375,0.0326054) , 
0, 1.2265, 1, 0, 0.268509,0.00165756)    );
  // itree = 2056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221929,-0.0046055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399209,0.0288494) , 
2, 0.936344, 1, 0, 0.247312,0.000591911) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0188679,0.0563785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540741,-0.0289989) , 
3, 0.98958, 1, 0, 0.311203,-0.0253345) , 
2, 1.51846, 1, 0, 0.25498,-0.00251978)    );
  // itree = 2057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317574,-0.0067618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0798611,-0.0139549) , 
2, 0.528326, 1, 0, 0.236889,-0.000482669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12,0.000811806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206061,0.0246558) , 
3, 0.656624, 1, 0, 0.173585,-0.0527682) , 
0, 1.26376, 1, 0, 0.228338,-0.00754468)    );
  // itree = 2058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350917,0.00562074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.015748,-0.0495956) , 
3, 0.65471, 1, 0, 0.308308,-0.00727802) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304945,0.00723174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181543,-0.000715184) , 
3, 0.0848536, 1, 0, 0.225366,0.0144612) , 
0, -0.0324937, 1, 0, 0.266304,0.00373123)    );
  // itree = 2059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211871,-0.00202272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617284,0.037471) , 
3, 1.00327, 1, 0, 0.259636,-0.00289312) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124324,-0.0603896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240741,-0.00196744) , 
2, 1.01546, 1, 0, 0.205835,0.0220393) , 
2, 0.708843, 1, 0, 0.242972,0.00482943)    );
  // itree = 2060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28436,0.0356328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224316,-0.0064711) , 
1, -1.09318, 1, 0, 0.231142,-0.000419886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.804878,0.0270397) , 
3, 1.83453, 1, 0, 0.266801,0.00239828)    );
  // itree = 2061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289886,-0.00248148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0427046,-0.0346758) , 
3, 0.919999, 1, 0, 0.248665,0.00870817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174497,-0.0102659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102703,-0.0193299) , 
1, 0.341652, 1, 0, 0.134731,-0.0222928) , 
0, 1.10784, 1, 0, 0.229817,0.00357972)    );
  // itree = 2062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276474,0.00435922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179487,-0.0146608) , 
0, 0.991364, 1, 0, 0.269776,-0.0068796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0943396,-0.0528422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211111,0.0537659) , 
3, 0.44461, 1, 0, 0.167832,0.0340694) , 
0, 1.2265, 1, 0, 0.255051,-0.000964739)    );
  // itree = 2063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0322581,0.00334752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337209,0.0113879) , 
1, -0.67394, 1, 0, 0.242485,0.000958592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250583,-0.0186144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230769,0.0124779) , 
3, 1.60993, 1, 0, 0.246914,0.0308831) , 
3, -0.112181, 1, 0, 0.244759,0.0163221)    );
  // itree = 2064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114016,-0.0184812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452675,0.014247) , 
3, 0.506155, 1, 0, 0.202362,-0.00214001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643836,-0.0370756) , 
3, 1.76176, 1, 0, 0.234445,-0.00709091)    );
  // itree = 2065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307811,-0.00551863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152582,0.00220294) , 
3, 0.287209, 1, 0, 0.269343,0.0111203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0482759,-0.0278397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0918367,0.0071978) , 
2, 0.902897, 1, 0, 0.0733138,-0.0186657) , 
3, 1.14622, 1, 0, 0.236893,0.00618968)    );
  // itree = 2066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347826,0.0135456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23306,-0.00178805) , 
3, -1.0595, 1, 0, 0.261236,0.00837753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0397351,-0.037715) , 
3, 1.74551, 1, 0, 0.243915,0.00602608)    );
  // itree = 2067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258162,0.00485478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38961,0.0109613) , 
1, 1.50526, 1, 0, 0.269358,-0.00416257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113772,-0.0250844) , 
3, 1.74459, 1, 0, 0.256203,-0.00103015)    );
  // itree = 2068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150094,0.0134685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216405,-0.0240657) , 
2, -0.645539, 1, 0, 0.184448,-0.00618229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401496,0.0337047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275789,-0.00209787) , 
1, 0.753578, 1, 0, 0.333333,0.0122117) , 
2, 0.280272, 1, 0, 0.250252,0.00194747)    );
  // itree = 2069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42471,-0.00337455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160976,-0.00635712) , 
3, 0.182088, 1, 0, 0.369654,0.00623409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141831,-0.00768672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105392,0.00854313) , 
3, 0.757751, 1, 0, 0.126425,-0.0187954) , 
1, 0.388779, 1, 0, 0.249101,-0.0061714)    );
  // itree = 2070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378082,0.00337068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211451,-0.0100186) , 
0, -0.836766, 1, 0, 0.243428,-0.00436069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405941,0.0149757) , 
2, 1.87748, 1, 0, 0.251623,0.000123846)    );
  // itree = 2071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249476,0.0531054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259916,-0.00337421) , 
3, -0.96239, 1, 0, 0.256446,-0.00341134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633333,0.0550603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145161,-0.00857113) , 
2, 0.637969, 1, 0, 0.32449,-0.032283) , 
3, 0.832675, 1, 0, 0.273766,-0.0107605)    );
  // itree = 2072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188034,0.0187272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18239,-0.0320328) , 
0, -1.5452, 1, 0, 0.183502,-0.0163481) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260905,0.0142843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326087,-0.0345897) , 
0, 1.50529, 1, 0, 0.267442,0.00550283) , 
0, -0.488206, 1, 0, 0.242132,-0.00108571)    );
  // itree = 2073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297009,0.00265339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237968,-0.00299927) , 
0, -0.0901045, 1, 0, 0.280153,-0.00204999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373874,0.00963776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119318,-0.00872615) , 
1, 0.0281962, 1, 0, 0.194667,-0.0225479) , 
0, 0.446909, 1, 0, 0.249029,-0.00951282)    );
  // itree = 2074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122951,-0.0239262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208,-0.00532201) , 
2, -0.983999, 1, 0, 0.165992,-0.0221406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281016,0.00446717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237833,-0.00331812) , 
1, 0.249458, 1, 0, 0.254266,0.00397338) , 
1, -0.999833, 1, 0, 0.243392,0.000756346)    );
  // itree = 2075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0755459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0789079) , 
0, -1.66157, 1, 0, 0,-0.040957) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.0126253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243007,0.00339312) , 
2, -0.120508, 1, 0, 0.264449,-0.0084728) , 
0, -1.14631, 1, 0, 0.23647,-0.0119097)    );
  // itree = 2076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0160428,-0.0593721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221865,0.00911765) , 
3, -1.21593, 1, 0, 0.174289,0.000344469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,0.00723184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57672,-0.0453895) , 
2, 0.905427, 1, 0, 0.507692,-0.0459221) , 
3, 1.20103, 1, 0, 0.230057,-0.0073944)    );
  // itree = 2077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537313,0.00470559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396825,0.0167654) , 
0, 0.0521192, 1, 0, 0.492386,-0.0272534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205231,-0.000846599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161137,0.0105399) , 
0, 1.35139, 1, 0, 0.199765,0.00648707) , 
1, -0.761509, 1, 0, 0.254771,0.000144632)    );
  // itree = 2078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227848,-0.00627806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362832,-0.00463945) , 
2, 1.19674, 1, 0, 0.24474,-0.0118049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.00714327) , 
3, 1.74551, 1, 0, 0.230691,-0.00632975)    );
  // itree = 2079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0141521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247423,0.0579705) , 
2, 0.626163, 1, 0, 0.109551,-0.00487048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495601,0.00400352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223577,-0.0380814) , 
3, 1.42013, 1, 0, 0.423491,0.0184227) , 
1, 0.51317, 1, 0, 0.255511,0.00595922)    );
  // itree = 2080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485294,-0.0317659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324115,0.00767629) , 
3, -0.584807, 1, 0, 0.205808,-0.00227694) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.694611,0.0401995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427711,0.00484809) , 
1, 1.26448, 1, 0, 0.561562,0.0402011) , 
3, 1.12905, 1, 0, 0.267606,0.00510187)    );
  // itree = 2081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588957,0.0318213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248062,-0.0171552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216107,-0.00628446) , 
0, -1.31621, 1, 0, 0.218329,0.0109438) , 
2, -1.52711, 1, 0, 0.248266,0.00729028)    );
  // itree = 2082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363636,0.000579565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280797,0.006684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,-0.0144339) , 
3, 1.31891, 1, 0, 0.249478,0.00152726) , 
0, -1.45539, 1, 0, 0.256259,-0.00212404)    );
  // itree = 2083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0268817,0.127356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269103,-0.0049183) , 
1, -1.2134, 1, 0, 0.24246,-0.00146121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188119,0.0271092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228155,-0.0569602) , 
1, 0.783036, 1, 0, 0.214984,0.0454198) , 
3, 1.27365, 1, 0, 0.238238,0.00574222)    );
  // itree = 2084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248328,0.0121321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255639,-0.0193785) , 
0, 0.29574, 1, 0, 0.250157,0.00331476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0799052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492647,0.0230649) , 
3, 0.42479, 1, 0, 0.330864,0.0247103) , 
0, 0.956597, 1, 0, 0.2665,0.00764736)    );
  // itree = 2085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323308,-0.00397471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261283,0.00436559) , 
0, -1.47516, 1, 0, 0.265823,0.00394744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0761905,-0.0302201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0227131) , 
3, 0.785477, 1, 0, 0.161172,-0.0363917) , 
0, 1.26376, 1, 0, 0.252153,-0.00132174)    );
  // itree = 2086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320558,-0.0136101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272789,0.00436777) , 
0, -0.894928, 1, 0, 0.280543,-0.00853168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0861154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209877,0.0345615) , 
2, 1.19475, 1, 0, 0.107595,0.0161841) , 
3, 1.27365, 1, 0, 0.254319,-0.00478399)    );
  // itree = 2087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185399,-0.0170801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403846,-0.0135971) , 
3, 0.321675, 1, 0, 0.241993,0.0218992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234568,-0.00184306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289817,0.0152331) , 
2, 1.18801, 1, 0, 0.268371,-0.0156052) , 
2, 0.721559, 1, 0, 0.250123,0.0103395)    );
  // itree = 2088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0387244,-0.026897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352761,0.0124923) , 
3, -0.985273, 1, 0, 0.255469,0.00525568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215753,-0.0327464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279279,0.00778624) , 
1, 0.583004, 1, 0, 0.2496,-0.0144342) , 
0, 0.57508, 1, 0, 0.253673,-0.000770845)    );
  // itree = 2089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416667,0.00746933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338776,0.0047587) , 
0, -1.57261, 1, 0, 0.346507,0.00162862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148725,0.00894194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164706,-0.00503422) , 
0, 1.32568, 1, 0, 0.151826,-0.027538) , 
3, 0.0840329, 1, 0, 0.259674,-0.0113805)    );
  // itree = 2090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176937,-0.0040904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300896,-0.00871626) , 
2, 0.280272, 1, 0, 0.227439,-0.00404338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.00378401) , 
0, 1.55465, 1, 0, 0.224368,0.00234383)    );
  // itree = 2091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,0.016301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104167,0.020479) , 
2, -0.711042, 1, 0, 0.0660661,-0.0164955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309013,0.00215458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288095,0.0119501) , 
3, 0.935104, 1, 0, 0.30347,0.00841965) , 
1, -0.71469, 1, 0, 0.262252,0.00409393)    );
  // itree = 2092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141503,0.00155033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370492,-0.0374517) , 
3, 0.554407, 1, 0, 0.183174,-0.00769616) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405882,0.0133487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703349,0.0446078) , 
2, 0.916434, 1, 0, 0.569921,0.0594694) , 
3, 1.12905, 1, 0, 0.254501,0.00469106)    );
  // itree = 2093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305161,-0.00638859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149425,0.00308964) , 
3, 0.401304, 1, 0, 0.279725,-0.00332237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0277092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100478,-0.00144744) , 
1, 1.11766, 1, 0, 0.0835322,0.0174356) , 
3, 0.951289, 1, 0, 0.238969,0.000989764)    );
  // itree = 2094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.0187828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539216,0.0121871) , 
1, -0.534468, 1, 0, 0.393204,0.0404876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288136,-0.00720193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222015,-0.00654788) , 
0, -0.816117, 1, 0, 0.228571,-0.00236929) , 
0, -1.26434, 1, 0, 0.245605,0.00206493)    );
  // itree = 2095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216606,-0.00728328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176298,-0.0147123) , 
2, -0.44591, 1, 0, 0.190476,0.00235219) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71223,0.03322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339806,0.0252402) , 
3, 0.490019, 1, 0, 0.489855,-0.0269874) , 
1, 1.36335, 1, 0, 0.244271,-0.00291976)    );
  // itree = 2096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133888,0.000449836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487078,0.0155269) , 
3, 0.510181, 1, 0, 0.231233,0.0067737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666667,-0.0164623) , 
3, 1.76176, 1, 0, 0.261224,0.00422314)    );
  // itree = 2097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398678,0.00599261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219697,0.036415) , 
0, 0.922971, 1, 0, 0.375962,-0.00261774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1375,-0.0302262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108974,-0.00406058) , 
2, 0.420865, 1, 0, 0.11383,0.0178427) , 
2, 0.213212, 1, 0, 0.251515,0.00709581)    );
  // itree = 2098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300499,-0.0106339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186824,-0.00435879) , 
0, -0.288514, 1, 0, 0.236943,-0.00643702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40146,0.029386) , 
1, 1.56373, 1, 0, 0.248466,-0.00275917)    );
  // itree = 2099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0240964,-0.0207737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0989761,-0.00467296) , 
3, -1.12276, 1, 0, 0.0645756,0.0111464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350689,-0.000118166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0763359,0.016168) , 
3, 1.84124, 1, 0, 0.325678,-0.0178963) , 
1, -0.368349, 1, 0, 0.254169,-0.00994221)    );
  // itree = 2100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,-0.0483021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298969,-0.0561083) , 
3, -1.38031, 1, 0, 0.158416,-0.0516907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213389,-0.00832946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351711,0.0143881) , 
2, 0.805657, 1, 0, 0.255665,-0.000238121) , 
1, -1.09318, 1, 0, 0.24545,-0.00564292)    );
  // itree = 2101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647303,0.020257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228145,-0.020902) , 
1, -0.723563, 1, 0, 0.370423,-0.011551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267442,-0.0160948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185289,0.0135198) , 
1, -0.414076, 1, 0, 0.196629,0.0145472) , 
3, -0.580667, 1, 0, 0.259714,0.00507394)    );
  // itree = 2102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298521,0.00826446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246256,-0.00788961) , 
0, 0.258972, 1, 0, 0.279857,0.00461055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0862853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177632,0.0264752) , 
2, 1.21031, 1, 0, 0.0912162,-0.0412205) , 
3, 1.27365, 1, 0, 0.251642,-0.00224442)    );
  // itree = 2103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193746,-0.00104983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376471,0.00224221) , 
3, 1.23959, 1, 0, 0.212675,-0.000301353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517134,0.00437644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136752,-0.0142209) , 
2, 1.50435, 1, 0, 0.415525,-0.0232121) , 
0, 1.00007, 1, 0, 0.255411,-0.00512814)    );
  // itree = 2104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250759,0.00686048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239669,-0.031402) , 
0, 1.2265, 1, 0, 0.249338,0.000633121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324324,-0.0403627) , 
1, 1.65151, 1, 0, 0.2535,-0.00245852)    );
  // itree = 2105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342932,-0.00718366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114235,-0.00583522) , 
1, 0.757817, 1, 0, 0.267055,0.00760834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0823529,0.00708864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.059322,-0.0375236) , 
2, 1.43656, 1, 0, 0.0729167,-0.049843) , 
3, 1.30934, 1, 0, 0.239141,-0.00065226)    );
  // itree = 2106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0628272,-0.035227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27374,0.0017711) , 
2, -1.40027, 1, 0, 0.252504,-0.00353022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.00778463) , 
3, 1.76176, 1, 0, 0.239395,0.00198011)    );
  // itree = 2107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103532,-0.0152777) , 
0, -1.08651, 1, 0, 0.0823643,0.0105135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130841,-0.0317086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430601,0.0011251) , 
1, 0.493193, 1, 0, 0.399217,-0.0171097) , 
1, 0.344779, 1, 0, 0.240019,-0.00323085)    );
  // itree = 2108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155286,0.00207625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382514,0.0247289) , 
3, 0.509675, 1, 0, 0.193401,0.00636531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295416,-0.0271688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313726,0.0149099) , 
1, 1.41494, 1, 0, 0.300126,-0.0142233) , 
2, 0.38325, 1, 0, 0.238323,-0.00230071)    );
  // itree = 2109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373259,-0.0054364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262887,0.00638088) , 
3, -0.593674, 1, 0, 0.323846,0.00774826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187919,0.0227941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0522388,-0.0396762) , 
3, 1.00637, 1, 0, 0.11,-0.0140082) , 
3, 0.440469, 1, 0, 0.249,0.000133492)    );
  // itree = 2110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242149,-0.00106564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515075,0.00194922) , 
2, 0.648627, 1, 0, 0.309702,0.00365978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122302,-0.00824927) , 
2, 0.582159, 1, 0, 0.0750552,-0.0228434) , 
3, 0.873167, 1, 0, 0.258127,-0.00216551)    );
  // itree = 2111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0757001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185111,0.0200105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293306,0.00820087) , 
0, -0.502014, 1, 0, 0.265673,-0.0141791) , 
0, -1.68098, 1, 0, 0.251949,-0.0123751)    );
  // itree = 2112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195876,0.0482021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20857,-0.006647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569672,-0.0159726) , 
3, 1.39666, 1, 0, 0.25669,-0.00873379) , 
0, -1.69913, 1, 0, 0.253631,-0.00554904)    );
  // itree = 2113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564103,0.00408407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321739,-0.0194771) , 
3, -1.39739, 1, 0, 0.409259,0.0302835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197727,0.00707958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216,0.0369168) , 
1, 1.59305, 1, 0, 0.199308,-0.0120483) , 
1, -0.365442, 1, 0, 0.256423,-0.000532357)    );
  // itree = 2114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405941,0.0313914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163842,0.0162982) , 
3, -1.61915, 1, 0, 0.251799,0.0384912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297505,-0.0081474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225275,-0.0125898) , 
0, -0.362191, 1, 0, 0.248605,-0.00473467) , 
1, -0.848848, 1, 0, 0.249075,0.00162006)    );
  // itree = 2115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242387,0.000458746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312195,-0.00951775) , 
2, 1.47471, 1, 0, 0.250135,0.000393982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,-0.0629679) , 
0, 1.55221, 1, 0, 0.242175,-0.00450687)    );
  // itree = 2116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0759494,-0.00634391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491379,0.0667191) , 
3, -1.17962, 1, 0, 0.251825,0.0353016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203268,-0.00018041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706897,0.0183063) , 
3, 1.7134, 1, 0, 0.254695,0.00311941) , 
1, -0.887572, 1, 0, 0.254297,0.00757741)    );
  // itree = 2117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505155,-0.0283278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239675,0.00477465) , 
1, -1.1131, 1, 0, 0.268415,0.00187807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0662651,0.0145319) , 
3, 1.73078, 1, 0, 0.251277,-0.00230082)    );
  // itree = 2118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32304,0.00239552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224363,0.00270404) , 
0, -0.778048, 1, 0, 0.246531,-0.000727047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42328,0.0236275) , 
2, 1.62671, 1, 0, 0.262724,-0.00302658)    );
  // itree = 2119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0736393,-0.0271161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47931,0.0059433) , 
1, 0.496873, 1, 0, 0.228741,0.00359818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344214,0.0198965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254237,0.0485238) , 
0, 1.36137, 1, 0, 0.320879,-0.0450502) , 
3, 0.920143, 1, 0, 0.25,-0.00762648)    );
  // itree = 2120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265,0.0198038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145855,-0.0332887) , 
0, -0.259717, 1, 0, 0.200228,-0.00341314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.753012,0.0548623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450331,-6.13191e-05) , 
1, 1.2453, 1, 0, 0.608833,0.0499593) , 
3, 1.29328, 1, 0, 0.262802,0.00476033)    );
  // itree = 2121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503448,0.00758555) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511811,0.00441055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223429,0.011234) , 
1, -1.07203, 1, 0, 0.242941,-0.00052682) , 
3, -1.85976, 1, 0, 0.261622,-0.00262347)    );
  // itree = 2122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0591716,-0.0329904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180451,0.000349851) , 
2, -1.41896, 1, 0, 0.151213,-0.0204303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324492,-0.0035994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100671,0.00548893) , 
3, 1.67541, 1, 0, 0.298438,0.000778535) , 
2, -0.33601, 1, 0, 0.24634,-0.00672647)    );
  // itree = 2123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0166667,0.0584522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132231,-0.00819616) , 
3, -0.897801, 1, 0, 0.0631229,0.024796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292426,-0.002589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248945,0.00434085) , 
3, 1.49336, 1, 0, 0.28623,-0.00538337) , 
1, -0.872401, 1, 0, 0.252037,-0.000758115)    );
  // itree = 2124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214832,-0.0176853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614815,0.0265276) , 
3, 1.51559, 1, 0, 0.244275,-0.0106766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216931,-0.0408397) , 
0, 1.38197, 1, 0, 0.24172,-0.0144915)    );
  // itree = 2125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.806122,0.0424797) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323051,0.00399646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0121388) , 
2, 0.52005, 1, 0, 0.237426,-0.000793097) , 
1, -1.59669, 1, 0, 0.26605,-0.00379175)    );
  // itree = 2126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404412,0.00263366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323764,0.00223711) , 
0, -1.41669, 1, 0, 0.338139,-0.0139449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102041,-0.029381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223722,0.00105452) , 
0, -0.32833, 1, 0, 0.200468,0.0109304) , 
3, -0.610112, 1, 0, 0.251834,0.00164933)    );
  // itree = 2127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157123,-0.00975774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279762,0.019495) , 
3, 1.31412, 1, 0, 0.17,-0.00771495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62439,-0.000895414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416309,0.00907284) , 
0, 0.101056, 1, 0, 0.513699,0.0185833) , 
1, 1.29547, 1, 0, 0.243867,-0.00206302)    );
  // itree = 2128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0992579,0.0029527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185484,-0.0544649) , 
3, 0.0846182, 1, 0, 0.108153,-0.00361642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464789,0.00210066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515748,0.0203103) , 
2, 1.19286, 1, 0, 0.482024,0.0119212) , 
3, 0.331768, 1, 0, 0.25192,0.00235837)    );
  // itree = 2129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341158,0.000344061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857741,-0.0115093) , 
1, 1.06218, 1, 0, 0.27164,0.000721284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0800211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.00610636) , 
0, 1.19527, 1, 0, 0.044335,-0.0502351) , 
3, 1.55602, 1, 0, 0.248086,-0.00455904)    );
  // itree = 2130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964912,-0.0378396) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244933,-0.00112501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378882,0.00155152) , 
2, 1.70673, 1, 0, 0.256356,0.00245607) , 
1, -1.40737, 1, 0, 0.247253,0.000362939)    );
  // itree = 2131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211062,-0.00881261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393365,0.0156008) , 
3, 1.22082, 1, 0, 0.232623,-0.0037642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288,-0.0226561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201299,-0.00268546) , 
0, 0.594745, 1, 0, 0.240143,0.0257797) , 
2, 1.45937, 1, 0, 0.23364,0.000231314)    );
  // itree = 2132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208083,0.00618166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197512,-0.0306732) , 
2, 0.405637, 1, 0, 0.204319,-0.0056608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68718,0.0277438) , 
3, 1.56809, 1, 0, 0.251374,-0.000442116)    );
  // itree = 2133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396694,0.002297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241303,-0.00505355) , 
0, -1.42757, 1, 0, 0.251035,0.000867728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146789,-0.0175062) , 
0, 1.55221, 1, 0, 0.245468,0.00311552)    );
  // itree = 2134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391566,-0.00599814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.0058408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259725,0.00604065) , 
1, -0.999833, 1, 0, 0.24866,0.00104043) , 
0, -1.32859, 1, 0, 0.260335,0.00511493)    );
  // itree = 2135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0606061,0.0391377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28484,-0.00911796) , 
1, -0.72175, 1, 0, 0.243753,-0.00725318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294798,-0.0181692) , 
0, 1.3861, 1, 0, 0.248227,-0.00340965)    );
  // itree = 2136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223572,-0.00121149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410835,0.0303243) , 
2, 0.232296, 1, 0, 0.2891,0.0082087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0821918,-0.0615805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191693,-0.00638545) , 
0, -0.557974, 1, 0, 0.170984,-0.0144665) , 
1, 0.807077, 1, 0, 0.244357,-0.000380721)    );
  // itree = 2137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471358,-0.00364841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180982,-0.0272392) , 
3, -0.376971, 1, 0, 0.370331,0.0117618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138603,0.00536156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0179584) , 
0, 1.29403, 1, 0, 0.13371,-0.00556259) , 
2, 0.0236201, 1, 0, 0.244622,0.00255796)    );
  // itree = 2138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2879,-0.00191901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205059,0.0131394) , 
0, -0.333741, 1, 0, 0.237678,0.0043961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513514,0.00212387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,0.0408509) , 
3, 1.07875, 1, 0, 0.388186,-0.0474803) , 
2, 1.51846, 1, 0, 0.254968,-0.00156353)    );
  // itree = 2139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273423,0.0306061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305785,0.0481076) , 
3, -0.887284, 1, 0, 0.279503,-0.00849992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223669,-0.00909742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311579,0.00820792) , 
0, 0.6884, 1, 0, 0.255303,0.0106885) , 
3, -0.691091, 1, 0, 0.263238,0.00439657)    );
  // itree = 2140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242478,0.0244338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185751,-0.00770791) , 
0, -0.543004, 1, 0, 0.204128,0.00297222) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384,-0.0327609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725888,0.00347734) , 
2, 0.927031, 1, 0, 0.593168,-0.0160082) , 
3, 1.3043, 1, 0, 0.264763,1.39982e-05)    );
  // itree = 2141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471572,-0.000818951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47482,0.0315784) , 
2, -1.10705, 1, 0, 0.472603,-0.0255932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28,0.0302716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200289,-0.000804624) , 
0, -1.09185, 1, 0, 0.205664,-0.00441973) , 
2, -0.796501, 1, 0, 0.266528,-0.00924742)    );
  // itree = 2142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25235,0.000293646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0826981) , 
3, 1.23923, 1, 0, 0.226623,-0.00833372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,-0.000231415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115108,-0.00216528) , 
3, 1.42013, 1, 0, 0.319101,0.0204229) , 
2, 0.992408, 1, 0, 0.247355,-0.00188702)    );
  // itree = 2143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258222,0.00989341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284615,-0.00612645) , 
3, -0.428114, 1, 0, 0.272972,0.00706646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19186,0.0257065) , 
3, 1.76176, 1, 0, 0.266109,0.00128011)    );
  // itree = 2144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22314,0.0416764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23913,-0.0276941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261666,0.00485212) , 
1, -0.760411, 1, 0, 0.25897,0.000377834) , 
1, -1.41766, 1, 0, 0.256849,0.00270526)    );
  // itree = 2145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336746,-0.0152588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26484,0.000133223) , 
0, 0.653434, 1, 0, 0.322404,0.00641084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108926,0.00248476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125561,-0.00678835) , 
0, 1.08631, 1, 0, 0.113122,-0.0127012) , 
2, 0.293652, 1, 0, 0.229062,-0.0021134)    );
  // itree = 2146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460993,0.00573331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229487,0.00226987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223529,-0.00137372) , 
1, 0.227361, 1, 0, 0.225995,-0.00315023) , 
0, -1.37918, 1, 0, 0.242349,0.000157842)    );
  // itree = 2147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196942,-0.00835928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25498,-0.00912359) , 
0, 0.169415, 1, 0, 0.20763,0.00829275) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395876,0.0266382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313253,-0.0196179) , 
1, 1.11713, 1, 0, 0.374808,-0.0139828) , 
0, 0.57508, 1, 0, 0.261668,0.00109246)    );
  // itree = 2148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206349,0.00876027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527778,-0.0456516) , 
3, 1.51156, 1, 0, 0.232323,-0.000434971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418605,0.0468298) , 
1, 1.5317, 1, 0, 0.248721,0.00530828)    );
  // itree = 2149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.710526,0.0355869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231366,-0.0105495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171701,0.00422364) , 
0, 0.6269, 1, 0, 0.211789,-0.00285439) , 
1, -1.44249, 1, 0, 0.239783,-0.00726922)    );
  // itree = 2150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282652,-0.0026735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227384,0.0219405) , 
0, 0.858919, 1, 0, 0.270768,0.00347272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0896552,-0.00341744) , 
3, 1.77248, 1, 0, 0.257938,-0.00190719)    );
  // itree = 2151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135379,-0.00108292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233108,-0.00546387) , 
0, -0.562714, 1, 0, 0.195562,0.00951167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507082,0.0119823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15493,-0.0086563) , 
2, 1.46482, 1, 0, 0.406061,-0.0195551) , 
0, 0.813325, 1, 0, 0.249355,0.00208365)    );
  // itree = 2152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540541,-0.0228376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340102,0.0247099) , 
3, -0.72479, 1, 0, 0.217391,0.0100762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201238,-0.0541086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373494,0.0118157) , 
0, 0.542969, 1, 0, 0.28855,-0.0190507) , 
2, 0.648293, 1, 0, 0.240295,0.000701228)    );
  // itree = 2153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310044,-0.00101208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0818182,-0.0508163) , 
3, 0.628649, 1, 0, 0.293127,0.00143626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0272727,-0.0322593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131429,0.0107225) , 
0, 0.119274, 1, 0, 0.106522,-0.0283795) , 
3, 0.849715, 1, 0, 0.248971,-0.00561892)    );
  // itree = 2154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373377,0.016094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129606,-0.00815743) , 
3, -1.27971, 1, 0, 0.198174,0.00727514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358696,0.0119442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33429,0.0067445) , 
0, -0.392104, 1, 0, 0.339387,-0.0127733) , 
2, 0.314309, 1, 0, 0.261134,-0.00166348)    );
  // itree = 2155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232772,0.00365105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267532,-0.0195497) , 
3, 0.432314, 1, 0, 0.240686,0.0148903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225,0.0341754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309783,-0.0184577) , 
1, 1.08324, 1, 0, 0.276316,-0.023054) , 
3, 1.3043, 1, 0, 0.246115,0.00910832)    );
  // itree = 2156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102804,0.0155492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201408,-0.0159577) , 
2, -1.41454, 1, 0, 0.178571,-0.00806562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354317,0.0343552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328205,0.00185739) , 
2, 0.801679, 1, 0, 0.340929,0.017583) , 
2, -0.0855223, 1, 0, 0.268281,0.00610633)    );
  // itree = 2157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439153,0.0168147) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354883,-0.00441372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128722,0.000734448) , 
1, 0.227361, 1, 0, 0.221719,0.00633234) , 
0, -1.2923, 1, 0, 0.242718,0.00382691)    );
  // itree = 2158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468468,0.0317999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266254,-0.00111924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0528169,-0.0213914) , 
3, 1.34237, 1, 0, 0.234334,-0.00147467) , 
3, -2.02293, 1, 0, 0.247264,-0.00429726)    );
  // itree = 2159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0475207,-0.00745917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156085,0.00932475) , 
3, -0.501857, 1, 0, 0.0951276,0.0066517) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407497,0.0129249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223214,-0.0133179) , 
3, 1.44094, 1, 0, 0.368221,-0.0150719) , 
1, 0.227361, 1, 0, 0.245165,-0.00528322)    );
  // itree = 2160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267216,0.000698177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28125,-0.0410552) , 
2, 1.01291, 1, 0, 0.269472,-0.00533848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00961538,-0.0364273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360996,0.0302531) , 
3, 0.418347, 1, 0, 0.198218,0.0227478) , 
1, 1.302, 1, 0, 0.253797,0.000840229)    );
  // itree = 2161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267571,-0.00424643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112745,0.00159715) , 
3, 1.13456, 1, 0, 0.250274,-0.000559085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117188,0.0715524) , 
3, 1.76176, 1, 0, 0.241556,-0.00326658)    );
  // itree = 2162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350554,-0.00385374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26793,-0.0111186) , 
0, -0.539721, 1, 0, 0.302888,-0.0027702) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038961,-0.0358745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155779,-0.00624281) , 
0, -0.128422, 1, 0, 0.131824,-0.0240095) , 
3, 0.331768, 1, 0, 0.239665,-0.0106199)    );
  // itree = 2163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349398,0.0486892) , 
3, -1.98908, 1, 0, 0.211679,-0.0160235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0192308,-0.0267217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285122,0.00629995) , 
0, -1.11178, 1, 0, 0.269682,0.010979) , 
3, -1.51764, 1, 0, 0.261985,0.00739607)    );
  // itree = 2164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101266,0.034544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256997,-0.00319726) , 
2, -1.40027, 1, 0, 0.242775,-0.000642247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00862069,-0.0518239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472868,-0.0371637) , 
3, 1.04155, 1, 0, 0.253061,-0.0462936) , 
0, 1.26376, 1, 0, 0.244051,-0.00630533)    );
  // itree = 2165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557576,-0.0020582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282609,-0.0314094) , 
3, -1.08158, 1, 0, 0.432343,0.0396563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26484,0.00733718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921273,-0.0131425) , 
3, 0.597472, 1, 0, 0.203901,-0.00321075) , 
1, -0.791106, 1, 0, 0.238596,0.00329988)    );
  // itree = 2166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521212,0.0243032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,-0.00544891) , 
3, -1.29599, 1, 0, 0.423792,0.0278475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21957,-0.0103714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202551,-0.00640064) , 
0, -0.380271, 1, 0, 0.206621,-0.00764408) , 
0, -0.988513, 1, 0, 0.235527,-0.00292007)    );
  // itree = 2167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969697,0.000125329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512387,0.0145122) , 
1, 0.404035, 1, 0, 0.293397,0.00693419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11215,-0.00505506) , 
1, 1.62191, 1, 0, 0.283627,0.00441939)    );
  // itree = 2168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198864,0.0178684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.095092,-0.0198768) , 
0, -0.268514, 1, 0, 0.148968,0.00275666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405594,-0.0409808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482079,-0.00363921) , 
0, -0.128422, 1, 0, 0.466476,-0.0166169) , 
3, 0.521064, 1, 0, 0.257171,-0.0038456)    );
  // itree = 2169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6,0.0274808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354545,-0.00900159) , 
0, -1.11218, 1, 0, 0.42,-0.0209669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234243,0.000663692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103524,-0.00261607) , 
3, 0.803092, 1, 0, 0.195122,0.00937038) , 
2, -0.703426, 1, 0, 0.246568,0.00242998)    );
  // itree = 2170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377049,-0.0151901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244094,0.00544191) , 
0, -1.45539, 1, 0, 0.254773,0.00872282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262745,0.00953327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210256,0.0326609) , 
3, 0.787904, 1, 0, 0.24,-0.0357435) , 
1, 1.28142, 1, 0, 0.251397,-0.00143962)    );
  // itree = 2171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0918919,-0.0181011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485616,0.0166861) , 
1, 0.379325, 1, 0, 0.282609,-0.00230273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0364963,-0.0488084) , 
1, 1.65151, 1, 0, 0.265148,-0.00634205)    );
  // itree = 2172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167832,0.0157107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0571429,-0.0322196) , 
2, -0.583057, 1, 0, 0.101983,-0.00253973) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399371,0.0358615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440957,0.0036628) , 
2, 0.280475, 1, 0, 0.427558,0.0163281) , 
3, -0.0237104, 1, 0, 0.259042,0.00656219)    );
  // itree = 2173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375278,0.008914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295082,0.0224599) , 
3, -0.336566, 1, 0, 0.365686,-0.00753721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0863309,-0.0358494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13396,-0.0124708) , 
2, -0.425932, 1, 0, 0.127273,0.0230544) , 
3, -0.112181, 1, 0, 0.248259,0.00753029)    );
  // itree = 2174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303174,0.00359454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.080597,0.00758157) , 
3, 0.919999, 1, 0, 0.262115,-0.0107468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165644,-0.00293389) , 
0, 1.44542, 1, 0, 0.254169,-0.00760318)    );
  // itree = 2175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206872,-0.00347567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348718,0.0295945) , 
3, 0.766862, 1, 0, 0.237829,-0.00861123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621622,0.0249293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138614,-0.000375873) , 
3, 1.3762, 1, 0, 0.391509,0.0437129) , 
0, 1.35843, 1, 0, 0.254127,-0.00306209)    );
  // itree = 2176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175732,-0.0302092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187544,0.000481057) , 
0, -1.05097, 1, 0, 0.185835,-0.00360542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268519,-0.0916249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567901,-0.0143849) , 
0, 0.325428, 1, 0, 0.475783,-0.0616872) , 
3, 1.12905, 1, 0, 0.236645,-0.0137835)    );
  // itree = 2177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505155,-0.0211577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283833,0.00903863) , 
3, -2.07625, 1, 0, 0.298497,-0.00475625) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0254237,-0.0423102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121739,0.0172807) , 
2, 0.275862, 1, 0, 0.0971922,0.0185924) , 
3, 0.935104, 1, 0, 0.25013,0.000853731)    );
  // itree = 2178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248649,0.0143292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288084,-0.00158775) , 
1, -0.691095, 1, 0, 0.279481,0.00022043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0820828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,-0.0142306) , 
2, 1.23011, 1, 0, 0.0681818,0.0539867) , 
3, 1.34716, 1, 0, 0.25102,0.00746242)    );
  // itree = 2179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140167,-0.00916666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254307,-0.00814206) , 
0, -0.638118, 1, 0, 0.222157,0.00306807) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496732,-0.00278143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195489,-0.0112414) , 
0, 1.50576, 1, 0, 0.356643,0.0258136) , 
0, 1.2265, 1, 0, 0.241553,0.00634857)    );
  // itree = 2180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246575,0.0449664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244044,-0.00774348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541667,0.0295187) , 
0, 1.54965, 1, 0, 0.263444,-0.00253814) , 
0, -1.35255, 1, 0, 0.262204,0.00127708)    );
  // itree = 2181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279838,-0.00193808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0157895,-0.061602) , 
3, 1.34913, 1, 0, 0.253653,-0.00175858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188119,0.0270946) , 
1, 1.7097, 1, 0, 0.250372,0.00142539)    );
  // itree = 2182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281052,-0.00574873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227666,-0.00083982) , 
0, 0.219693, 1, 0, 0.260434,-0.00183955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0426829,-0.0364195) , 
3, 1.69879, 1, 0, 0.242223,0.00212923)    );
  // itree = 2183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0885348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257976,0.00320628) , 
1, -1.29069, 1, 0, 0.231398,-0.00523196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414179,0.0195842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232662,-0.00864948) , 
0, 0.330515, 1, 0, 0.300699,0.0140435) , 
3, 0.371425, 1, 0, 0.256966,0.00187946)    );
  // itree = 2184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24955,0.00161456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31677,0.0442516) , 
2, 1.20397, 1, 0, 0.25547,0.00459979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0334664) , 
2, 1.65194, 1, 0, 0.26308,0.000859409)    );
  // itree = 2185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348649,0.00855927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0515152,-0.0253003) , 
3, 0.517573, 1, 0, 0.280556,0.000234271) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184524,-0.0193908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178478,-0.000500634) , 
3, 0.107504, 1, 0, 0.180328,-0.0250388) , 
0, 0.708151, 1, 0, 0.252891,-0.00674156)    );
  // itree = 2186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290909,0.00719406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127119,-0.00450807) , 
3, -1.58724, 1, 0, 0.20614,-0.0357016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275862,-0.00727674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24478,-0.0063411) , 
1, -0.187407, 1, 0, 0.252193,-0.000806875) , 
1, -1.102, 1, 0, 0.247076,-0.00468407)    );
  // itree = 2187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.076225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160377,0.0585264) , 
0, -0.443026, 1, 0, 0.0735931,-0.0308986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306956,-0.00088307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247619,0.00962716) , 
2, 1.56239, 1, 0, 0.299944,0.00165846) , 
1, -0.999833, 1, 0, 0.273904,-0.00208689)    );
  // itree = 2188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220655,0.00779619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603175,-0.0315662) , 
3, 1.62424, 1, 0, 0.246048,0.00240675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430894,0.0296311) , 
1, 1.68939, 1, 0, 0.257298,0.00536792)    );
  // itree = 2189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735294,0.0526396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411392,0.00382879) , 
1, -1.36226, 1, 0, 0.561224,-0.0460822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299458,-0.0121072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118355,-0.00375187) , 
1, 0.436146, 1, 0, 0.195389,0.00181821) , 
1, -0.910541, 1, 0, 0.248398,-0.00512251)    );
  // itree = 2190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154994,-0.00948882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244565,0.0206122) , 
2, -0.0157038, 1, 0, 0.170616,-0.00796013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384224,0.0240161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298279,0.00983266) , 
0, 0.22964, 1, 0, 0.335153,0.0135939) , 
2, 0.213212, 1, 0, 0.247083,0.00205687)    );
  // itree = 2191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0823979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261932,0.00458458) , 
1, -1.54156, 1, 0, 0.247389,0.00596395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0763889,-0.0207297) , 
1, 1.62191, 1, 0, 0.234845,0.00903047)    );
  // itree = 2192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190789,-0.0111958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124031,-0.0618549) , 
1, 0.358896, 1, 0, 0.170901,-0.0213038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251366,0.0215157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265979,-0.00377401) , 
0, 0.0169816, 1, 0, 0.260698,0.00423004) , 
0, -0.727763, 1, 0, 0.240779,-0.00143397)    );
  // itree = 2193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608911,0.0102031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294643,-0.0203777) , 
3, -1.10067, 1, 0, 0.443662,0.0276627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235602,-0.00557262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15509,0.00215132) , 
3, -0.296715, 1, 0, 0.183498,-0.000300436) , 
1, -0.57495, 1, 0, 0.237561,0.00551045)    );
  // itree = 2194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180377,-0.00557934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300766,-0.00406745) , 
2, 0.211614, 1, 0, 0.221424,0.00240253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301587,-0.00499893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329861,0.00510535) , 
2, 1.37902, 1, 0, 0.321256,-0.0166958) , 
2, 1.10251, 1, 0, 0.242674,-0.00166261)    );
  // itree = 2195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2508,0.000281288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475,0.0313717) , 
3, 1.01683, 1, 0, 0.266786,-0.0183827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294737,-0.0349974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204545,-0.0297378) , 
1, 1.41419, 1, 0, 0.257764,0.0222612) , 
3, 1.30934, 1, 0, 0.265337,-0.0118553)    );
  // itree = 2196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24981,0.00561003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247563,-0.0207633) , 
0, 0.489935, 1, 0, 0.24918,-0.00218548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372093,0.0300779) , 
0, 1.3861, 1, 0, 0.25974,0.00132087)    );
  // itree = 2197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264796,-0.00182188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172222,0.0177353) , 
0, 1.3861, 1, 0, 0.255635,-0.00661294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164474,0.0198556) , 
1, 1.5317, 1, 0, 0.248605,-0.00199046)    );
  // itree = 2198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133858,-0.0023403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255814,0.00156822) , 
2, -0.718651, 1, 0, 0.164706,-0.0180988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406964,0.00586815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0981308,-0.00561481) , 
3, 0.791064, 1, 0, 0.308834,0.00216775) , 
2, -0.42528, 1, 0, 0.260483,-0.00463108)    );
  // itree = 2199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0333333,0.0197192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113924,-0.0149789) , 
3, -0.983567, 1, 0, 0.0746753,0.0245627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147177,0.0104759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436384,-0.00446067) , 
1, 0.528798, 1, 0, 0.333333,-0.0152924) , 
1, -0.239358, 1, 0, 0.253984,-0.00306595)    );
  // itree = 2200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128205,0.0109351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516667,0.0393674) , 
3, -0.798902, 1, 0, 0.259887,0.024576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215416,-0.00873245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424084,0.0324258) , 
2, 1.57331, 1, 0, 0.239659,-0.00242086) , 
1, -0.707251, 1, 0, 0.243243,0.00236238)    );
  // itree = 2201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320563,-0.000989011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101942,0.000926248) , 
3, 0.400621, 1, 0, 0.249341,0.00185779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137255,-0.00458508) , 
1, 1.68939, 1, 0, 0.243622,-0.00047409)    );
  // itree = 2202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27088,-0.00270424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151079,0.018407) , 
0, 1.08217, 1, 0, 0.250156,0.00191394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307143,-0.00667061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144654,-0.0218777) , 
3, 0.789667, 1, 0, 0.220736,0.0404997) , 
1, 1.41354, 1, 0, 0.24554,0.00796701)    );
  // itree = 2203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207473,0.00456812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30591,-0.0038064) , 
3, -0.0663985, 1, 0, 0.25266,-0.00395001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180233,-0.0346115) , 
1, 1.54693, 1, 0, 0.246589,0.000330896)    );
  // itree = 2204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195035,-0.0528847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246062,-0.00503316) , 
1, -0.768694, 1, 0, 0.237152,-0.0117287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289655,0.0616505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304348,0.00862246) , 
1, 0.113466, 1, 0, 0.299287,0.029837) , 
0, 0.956597, 1, 0, 0.25,-0.00313383)    );
  // itree = 2205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348018,-0.00157267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180751,-0.00779571) , 
3, 0.0611162, 1, 0, 0.30237,0.00178219) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366972,0.00193123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135501,0.0193625) , 
0, 0.0953573, 1, 0, 0.112971,-0.0334037) , 
3, 0.873167, 1, 0, 0.25797,-0.00646638)    );
  // itree = 2206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207921,0.000718485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297721,0.00215989) , 
1, -0.596258, 1, 0, 0.277655,-0.00728553) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0172414,-0.0257849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109091,0.0148011) , 
0, 1.15142, 1, 0, 0.0619469,-0.0351386) , 
3, 1.45397, 1, 0, 0.253687,-0.0103803)    );
  // itree = 2207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185693,-0.0136301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637097,-0.00963451) , 
3, 0.274928, 1, 0, 0.257362,0.00457562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129353,0.00387808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351504,-0.0184948) , 
1, 0.850065, 1, 0, 0.23348,-0.0136907) , 
2, -0.124141, 1, 0, 0.243215,-0.006245)    );
  // itree = 2208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144622,-0.00503503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4625,0.0293985) , 
3, 0.675411, 1, 0, 0.177734,0.0010274) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542373,0.0528797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562914,0.00324729) , 
3, 1.22536, 1, 0, 0.557143,0.025289) , 
3, 0.951289, 1, 0, 0.259202,0.00623694)    );
  // itree = 2209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338235,0.013668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15035,0.000211827) , 
3, 0.556566, 1, 0, 0.304182,-0.00211214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.08,0.00244286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0604027,-0.0253052) , 
2, 1.19475, 1, 0, 0.0716332,-0.0283027) , 
3, 1.12905, 1, 0, 0.262065,-0.00685553)    );
  // itree = 2210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55102,0.0194312) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289916,-0.0231767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22314,0.00178351) , 
0, -0.838599, 1, 0, 0.231916,-0.000606911) , 
3, -1.95723, 1, 0, 0.248298,-0.00246012)    );
  // itree = 2211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223868,0.000774299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272917,-0.012707) , 
2, 0.626246, 1, 0, 0.237758,-0.0029106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364162,0.04248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215278,-0.00812696) , 
1, 1.31793, 1, 0, 0.29653,-0.046804) , 
3, 1.22488, 1, 0, 0.247018,-0.00982622)    );
  // itree = 2212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00621118,-0.0724496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385768,0.0418005) , 
3, -1.46631, 1, 0, 0.242991,0.0161232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0256697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231278,-0.0236492) , 
0, -0.938506, 1, 0, 0.240852,-0.0156509) , 
1, -0.469325, 1, 0, 0.241326,-0.0086083)    );
  // itree = 2213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35277,-0.0111206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288259,0.0016631) , 
0, -0.902666, 1, 0, 0.302281,0.000694511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921986,0.0101786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11898,0.0209408) , 
1, 0.660677, 1, 0, 0.111336,-0.0396316) , 
3, 0.880369, 1, 0, 0.256757,-0.00891993)    );
  // itree = 2214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267717,-0.00985988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243902,0.0155264) , 
1, 0.398556, 1, 0, 0.258373,0.0165754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203991,-0.00146768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272,0.0439986) , 
0, 1.5124, 1, 0, 0.212269,-0.015791) , 
0, -0.0142405, 1, 0, 0.235521,0.000532795)    );
  // itree = 2215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214184,-0.0128155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370968,0.00776477) , 
3, 0.77634, 1, 0, 0.251085,-0.00578269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209581,0.00162546) , 
2, 1.63767, 1, 0, 0.247638,-0.00160907)    );
  // itree = 2216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22938,-0.00472978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320675,0.0394307) , 
2, 1.41921, 1, 0, 0.24078,5.61505e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401869,-0.0318409) , 
0, 1.55221, 1, 0, 0.249377,-0.0031087)    );
  // itree = 2217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449074,-0.00260313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191667,0.0513994) , 
3, 0.382558, 1, 0, 0.408854,-0.0134786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163121,0.00353171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107042,-0.0251375) , 
0, 0.780176, 1, 0, 0.146545,0.00693706) , 
1, -0.0132411, 1, 0, 0.248857,-0.00102599)    );
  // itree = 2218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286477,0.00359963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0397351,-0.00784158) , 
3, 1.38332, 1, 0, 0.266195,0.00036288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145631,0.0330525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206897,0.0357315) , 
0, 1.50787, 1, 0, 0.178082,-0.0272583) , 
0, 1.32631, 1, 0, 0.256809,-0.00257926)    );
  // itree = 2219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00448431,-0.0893413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297521,0.00755955) , 
1, -0.925206, 1, 0, 0.228662,-0.00106199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336032,0.000619445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16791,-0.01834) , 
2, 1.1949, 1, 0, 0.291378,-0.0192472) , 
3, -0.151872, 1, 0, 0.260981,-0.0104332)    );
  // itree = 2220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163743,-0.0344883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302425,0.0266949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205467,-0.00481062) , 
1, 0.239317, 1, 0, 0.244041,0.00744522) , 
1, -1.19679, 1, 0, 0.236937,0.00383432)    );
  // itree = 2221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338843,-0.0221406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268987,0.000131146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.073913,0.00109598) , 
3, 1.38149, 1, 0, 0.244199,-0.00598918) , 
0, -1.5123, 1, 0, 0.250129,-0.00243235)    );
  // itree = 2222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132597,-0.0113987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247788,0.0125344) , 
2, -0.684942, 1, 0, 0.176871,0.0290211) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284238,-0.015374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232055,0.000128648) , 
0, -0.114651, 1, 0, 0.254606,0.00225485) , 
1, -0.887572, 1, 0, 0.243645,0.00602908)    );
  // itree = 2223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0181159,-0.0262157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276923,-0.030554) , 
0, -0.975482, 1, 0, 0.125265,0.0224199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104839,0.0629755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297159,-0.00282413) , 
1, -1.00498, 1, 0, 0.281229,-0.00894176) , 
0, -0.691888, 1, 0, 0.243902,-0.00143599)    );
  // itree = 2224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169811,0.0321689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0492846,-0.0342411) , 
1, -1.37018, 1, 0, 0.0666667,-0.00708935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329973,0.00792145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773109,0.0316926) , 
3, 1.78879, 1, 0, 0.373554,0.0136605) , 
3, -0.555244, 1, 0, 0.257584,0.00581933)    );
  // itree = 2225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.00391545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277932,-0.00116472) , 
0, -0.716617, 1, 0, 0.304494,-0.00463385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.047619,-0.0112292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0911681,-0.011422) , 
3, 0.490019, 1, 0, 0.0759259,0.0265654) , 
2, 0.851789, 1, 0, 0.243722,0.00366138)    );
  // itree = 2226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283531,-0.00370435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127551,-0.0106432) , 
0, 0.577043, 1, 0, 0.244586,-0.0105838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280374,-0.00632077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206693,-0.0156788) , 
1, 0.383164, 1, 0, 0.219512,0.0144572) , 
1, 0.0377094, 1, 0, 0.22928,0.00470179)    );
  // itree = 2227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231541,0.0177739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235786,-0.0278964) , 
3, 0.10531, 1, 0, 0.233038,0.00578061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435644,0.0103073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.087156,-0.0678711) , 
0, 0.725383, 1, 0, 0.197492,0.0714368) , 
3, 1.27365, 1, 0, 0.227408,0.01618)    );
  // itree = 2228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193838,-0.00284424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248918,0.015923) , 
0, -0.316993, 1, 0, 0.223723,0.00603297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128788,-0.0643416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349345,-0.0104832) , 
1, 0.124009, 1, 0, 0.268698,-0.0331627) , 
0, 1.08217, 1, 0, 0.231589,-0.000822475)    );
  // itree = 2229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53719,-0.00705786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254443,-0.00656634) , 
2, -1.14255, 1, 0, 0.306636,0.00502142) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15,0.0259683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129296,0.0209965) , 
1, 0.10375, 1, 0, 0.132695,-0.0231292) , 
3, 0.436997, 1, 0, 0.244368,-0.005056)    );
  // itree = 2230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231988,0.00354136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370861,0.0221065) , 
2, 0.812828, 1, 0, 0.245614,0.00382703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329004,0.0104809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356725,0.0241584) , 
1, 1.40603, 1, 0, 0.340796,-0.0209253) , 
2, 1.08337, 1, 0, 0.265327,-0.00129941)    );
  // itree = 2231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.145981) , 
3, -1.87011, 1, 0, 0,0.035559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102138,0.0122319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338161,0.0051011) , 
1, -0.368349, 1, 0, 0.283019,-0.0131234) , 
0, -1.15037, 1, 0, 0.252475,-0.00786958)    );
  // itree = 2232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249591,-0.00357431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73913,0.0252453) , 
3, 1.23305, 1, 0, 0.299265,0.00135437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.065,-0.0474514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324675,0.0126645) , 
2, 1.20814, 1, 0, 0.160063,-0.0166976) , 
1, 1.06218, 1, 0, 0.255148,-0.00436676)    );
  // itree = 2233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331046,-0.0010347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921986,-0.0093387) , 
3, 0.3925, 1, 0, 0.253179,-0.00356991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0518519,-0.0505528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189189,-0.00892404) , 
0, 1.50625, 1, 0, 0.113821,0.029651) , 
0, 1.29927, 1, 0, 0.23583,0.000565894)    );
  // itree = 2234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397059,0.0138613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0576923,-0.0483776) , 
3, -0.307722, 1, 0, 0.303191,0.014973) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293651,-0.0103536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228672,0.0121993) , 
0, -0.124303, 1, 0, 0.235154,-0.00354856) , 
0, -0.293879, 1, 0, 0.260546,0.0033637)    );
  // itree = 2235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11194,-0.0596095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325581,0.0549402) , 
2, -1.23866, 1, 0, 0.25977,-0.0105631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215054,-0.0209284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253942,-0.0161932) , 
0, -0.492686, 1, 0, 0.246631,0.0167173) , 
3, -1.04915, 1, 0, 0.249609,0.0105334)    );
  // itree = 2236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24709,-0.00500919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.033557,-0.0588338) , 
1, 1.10768, 1, 0, 0.20212,-0.0112631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306452,0.0601789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359202,0.00333619) , 
0, 0.0481497, 1, 0, 0.343799,0.0169014) , 
2, 0.689402, 1, 0, 0.246101,-0.00252001)    );
  // itree = 2237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378378,-0.028393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376923,0.0246985) , 
3, -1.89465, 1, 0, 0.377593,-0.0310687) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264916,-0.00121249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0167458) , 
3, 1.58428, 1, 0, 0.245263,0.000682416) , 
0, -1.12185, 1, 0, 0.260536,-0.00298235)    );
  // itree = 2238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200174,-0.00253195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403374,0.00881799) , 
2, 0.412957, 1, 0, 0.273737,0.00136297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.078534,0.000428784) , 
3, 1.64499, 1, 0, 0.25502,0.00443641)    );
  // itree = 2239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239486,0.00763694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365741,-0.0175726) , 
3, 1.11648, 1, 0, 0.253631,0.00173386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154362,0.00369605) , 
3, 1.74459, 1, 0, 0.246509,-0.00451141)    );
  // itree = 2240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191547,-0.0102933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367965,0.0356388) , 
2, 0.283413, 1, 0, 0.221891,-0.000617709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25974,-0.0480135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420168,0.0371794) , 
1, 1.55329, 1, 0, 0.288754,-0.0233452) , 
2, 0.689402, 1, 0, 0.243878,-0.00809132)    );
  // itree = 2241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386161,0.00139653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132999,-0.00770236) , 
2, 0.049814, 1, 0, 0.266982,0.00360054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0327869,-0.0467525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116071,0.0166931) , 
1, 1.38423, 1, 0, 0.0644068,0.0438167) , 
3, 1.30794, 1, 0, 0.236922,0.00956823)    );
  // itree = 2242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423237,0.0132424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213542,-0.00851003) , 
3, -0.753145, 1, 0, 0.330254,0.0262808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238397,0.00044486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0382514,-0.0420509) , 
3, 1.52985, 1, 0, 0.206012,0.00175403) , 
0, -0.17445, 1, 0, 0.25989,0.0123901)    );
  // itree = 2243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122871,-0.0137965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564103,0.0591978) , 
3, 0.642441, 1, 0, 0.177849,-0.00390047) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370482,0.0116865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216828,-0.0242365) , 
3, 1.07632, 1, 0, 0.321686,0.023188) , 
0, -0.075678, 1, 0, 0.251046,0.00988459)    );
  // itree = 2244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262508,0.00574989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174041,-0.0186021) , 
1, 1.36335, 1, 0, 0.246539,0.00104912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49505,0.0215842) , 
0, 1.55221, 1, 0, 0.259222,0.00302833)    );
  // itree = 2245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302436,0.00482742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.093617,0.0274782) , 
3, 1.12914, 1, 0, 0.273789,0.00604408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0340136,-0.059993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167785,0.0385826) , 
3, 0.750458, 1, 0, 0.101351,-0.0275958) , 
1, 1.4386, 1, 0, 0.248382,0.00108768)    );
  // itree = 2246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272222,-0.0050537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,0.0154033) , 
1, 0.516772, 1, 0, 0.286364,0.00469914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140725,-0.00130318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338983,0.00420552) , 
2, 1.19286, 1, 0, 0.207092,-0.0142687) , 
1, 0.940933, 1, 0, 0.258765,-0.00190446)    );
  // itree = 2247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015814,-0.057478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602941,0.0324272) , 
0, 1.2265, 1, 0, 0.109461,-0.00473176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573975,0.00506631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203704,-0.0228666) , 
3, 1.54838, 1, 0, 0.49101,0.0126978) , 
1, 0.879105, 1, 0, 0.247253,0.00156272)    );
  // itree = 2248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239344,0.000584425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182692,0.0701596) , 
1, 1.31262, 1, 0, 0.231092,0.0089292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,-0.0990396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24147,-0.0147911) , 
1, -0.752382, 1, 0, 0.235524,-0.021081) , 
0, -0.380943, 1, 0, 0.233936,-0.0103243)    );
  // itree = 2249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315895,0.00136053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0672269,-0.034122) , 
2, 0.853938, 1, 0, 0.297516,0.0070806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0774908,-0.0113078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0992366,0.0273247) , 
3, 1.5509, 1, 0, 0.0845771,-0.0238841) , 
2, 1.07686, 1, 0, 0.25497,0.000893827)    );
  // itree = 2250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348624,-0.0128807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291733,0.0109063) , 
0, -1.61863, 1, 0, 0.296269,0.00273861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241636,0.00648644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181102,0.0170282) , 
3, 0.487166, 1, 0, 0.206154,-0.0299709) , 
0, 0.6269, 1, 0, 0.267229,-0.00780238)    );
  // itree = 2251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0809061,0.0372249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0935829,0.00260065) , 
2, -0.690678, 1, 0, 0.0878477,-0.0229962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0335101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377477,0.000142223) , 
1, 0.21201, 1, 0, 0.333846,-0.00241733) , 
1, -0.0997873, 1, 0, 0.249117,-0.00950528)    );
  // itree = 2252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227059,0.00645999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0902256,-0.0306726) , 
0, 1.34822, 1, 0, 0.21713,0.00313711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65493,-0.0333061) , 
3, 1.74551, 1, 0, 0.248608,-0.00109011)    );
  // itree = 2253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410651,0.00835278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0695297,-0.0221273) , 
2, 0.2817, 1, 0, 0.285607,0.00241962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244275,0.0116556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0914634,0.00871732) , 
3, 1.59531, 1, 0, 0.207849,-0.0247779) , 
0, 0.6269, 1, 0, 0.259149,-0.00683452)    );
  // itree = 2254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217742,0.0188712) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263889,-0.0032579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10274,0.0324224) , 
3, 1.72867, 1, 0, 0.251334,-0.0107034) , 
1, -1.3293, 1, 0, 0.249249,-0.00752084)    );
  // itree = 2255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.07689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.088,0.0824392) , 
3, -1.19881, 1, 0, 0.0423077,-0.0255135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121585,-0.000504754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441061,0.0148365) , 
1, 0.383512, 1, 0, 0.307429,0.0048407) , 
1, -0.9788, 1, 0, 0.273134,0.000914283)    );
  // itree = 2256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245098,0.0403849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.095151,-0.0172018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440945,0.012273) , 
3, 0.234388, 1, 0, 0.237197,0.00188864) , 
0, -1.61174, 1, 0, 0.237609,0.0045074)    );
  // itree = 2257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582609,0.0229742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261239,-0.00116234) , 
2, -1.65383, 1, 0, 0.282226,-0.00335803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841122,0.0595507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,0.0171229) , 
2, 1.76034, 1, 0, 0.0877193,-0.036954) , 
2, 1.46433, 1, 0, 0.25993,-0.00720915)    );
  // itree = 2258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306991,-0.00309643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.054878,-0.00158112) , 
3, 0.0564175, 1, 0, 0.256691,0.00770744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317181,-0.00093588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231915,0.0021787) , 
1, 0.494693, 1, 0, 0.2485,-0.0181391) , 
1, 0.144707, 1, 0, 0.251885,-0.00745741)    );
  // itree = 2259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246174,0.000911271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340517,0.010272) , 
3, 0.838543, 1, 0, 0.268429,-0.00295473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0875693) , 
1, 1.82294, 1, 0, 0.254458,0.000198065)    );
  // itree = 2260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114486,-0.000404008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391437,0.0351559) , 
3, -0.0126863, 1, 0, 0.19104,0.0121484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230159,-0.0708741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338505,0.000450772) , 
2, 0.505503, 1, 0, 0.322156,-0.00902298) , 
2, 0.30194, 1, 0, 0.245292,0.00338817)    );
  // itree = 2261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464286,-0.00157757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222346,0.000708403) , 
3, -1.27789, 1, 0, 0.284289,0.0133835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204651,-0.00447236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0854701,0.00360073) , 
3, 1.82623, 1, 0, 0.186352,-0.00748532) , 
0, 0.30526, 1, 0, 0.24631,0.00529084)    );
  // itree = 2262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302572,-0.00815796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253846,-0.00117236) , 
0, -0.480903, 1, 0, 0.271436,0.000887226) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.100366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.00501583) , 
3, 1.92217, 1, 0, 0.0412844,0.0310632) , 
3, 1.55138, 1, 0, 0.24695,0.00409775)    );
  // itree = 2263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0760005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764331,-0.0124004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300065,-0.00496207) , 
1, -0.676742, 1, 0, 0.262251,0.00497404) , 
0, -1.37918, 1, 0, 0.240375,0.00182247)    );
  // itree = 2264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187328,0.0408978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261836,-2.38609e-05) , 
2, -0.745991, 1, 0, 0.242489,0.00871869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0756098,-0.0610701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714286,0.0188702) , 
3, 1.40243, 1, 0, 0.271959,-0.0151907) , 
0, 0.6269, 1, 0, 0.251256,0.00160594)    );
  // itree = 2265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343693,-0.00102617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225443,-0.00811046) , 
0, -0.562449, 1, 0, 0.261599,0.0129467) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130137,-0.0181362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133929,0.014814) , 
3, 1.46932, 1, 0, 0.131783,-0.0208744) , 
0, 1.26376, 1, 0, 0.245237,0.00868396)    );
  // itree = 2266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181159,-0.0123896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,0.00118548) , 
1, -1.30423, 1, 0, 0.336127,-0.00176864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0605187,-0.0385019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200653,0.0111857) , 
0, 0.225803, 1, 0, 0.15,0.0177127) , 
3, 0.000826949, 1, 0, 0.248279,0.00742611)    );
  // itree = 2267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231129,0.00026349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328904,-0.0131362) , 
3, 0.821644, 1, 0, 0.247497,-0.00165489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925926,-0.058742) , 
3, 1.76176, 1, 0, 0.234694,0.00386834)    );
  // itree = 2268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240741,0.0498796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247399,0.00130609) , 
0, -1.68098, 1, 0, 0.247008,0.00410097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,0.00257057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391304,-0.0471548) , 
3, 0.977445, 1, 0, 0.236364,-0.0462363) , 
1, 1.49217, 1, 0, 0.24587,-0.00128008)    );
  // itree = 2269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427273,-0.0421633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286486,0.00225464) , 
1, -0.925206, 1, 0, 0.338983,0.0350568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270877,0.0107264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124528,-0.0152256) , 
0, 1.22619, 1, 0, 0.247929,-0.0085725) , 
0, -1.02158, 1, 0, 0.261461,-0.00208854)    );
  // itree = 2270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346491,0.00577177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,-0.0358043) , 
3, -1.13219, 1, 0, 0.228889,0.00701353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288194,0.00649536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.060241,-0.0176878) , 
3, 1.7145, 1, 0, 0.264633,-0.00752962) , 
1, -0.484715, 1, 0, 0.256809,-0.00434653)    );
  // itree = 2271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0889571,0.000233982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300839,0.00486629) , 
1, -0.761509, 1, 0, 0.264,-0.00660256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0738255,-0.0470459) , 
3, 1.77248, 1, 0, 0.25,-0.00358754)    );
  // itree = 2272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0660377,0.00587259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0122449,-0.0581599) , 
2, -1.37844, 1, 0, 0.02849,-0.0115764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441026,0.0516238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297704,0.00704251) , 
1, -0.628404, 1, 0, 0.315293,0.0130102) , 
3, -1.20991, 1, 0, 0.263402,0.00856182)    );
  // itree = 2273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301939,0.00567049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193809,-0.00799489) , 
0, 0.170012, 1, 0, 0.257941,-0.000469461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10559,0.0562462) , 
3, 1.74551, 1, 0, 0.245596,-0.00431332)    );
  // itree = 2274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307497,0.00906213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0447154,0.000648645) , 
3, 1.21387, 1, 0, 0.271978,-0.00583917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0344298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251969,0.0169667) , 
1, 0.355876, 1, 0, 0.170124,0.0270073) , 
0, 1.28629, 1, 0, 0.260068,-0.00199831)    );
  // itree = 2275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00571429,-0.0452889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212544,0.00656503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550971,0.00869097) , 
1, 1.31017, 1, 0, 0.288035,-0.00134735) , 
1, -1.28125, 1, 0, 0.2636,0.00379767)    );
  // itree = 2276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289575,0.0373781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218931,-0.000549437) , 
1, -0.990081, 1, 0, 0.229029,0.00494699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75,0.0346936) , 
3, 1.74459, 1, 0, 0.269348,0.00902859)    );
  // itree = 2277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526946,-0.0236841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281298,0.00834238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0831858,0.00190326) , 
2, 0.803696, 1, 0, 0.221087,-0.00516312) , 
1, -1.18003, 1, 0, 0.246298,-0.00258679)    );
  // itree = 2278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387755,-0.00722451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243484,-0.00518913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227011,-0.00493001) , 
1, 1.35324, 1, 0, 0.24031,-0.00467087) , 
0, -1.66344, 1, 0, 0.247899,-0.00164267)    );
  // itree = 2279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189655,0.0101976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261601,-0.000832292) , 
3, -1.4388, 1, 0, 0.249859,-0.00421085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.649123,0.04869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.091954,-0.028999) , 
3, 0.748548, 1, 0, 0.3125,0.0387982) , 
2, 1.37511, 1, 0, 0.258596,0.00178751)    );
  // itree = 2280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130841,-0.0673231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222936,-0.0138195) , 
1, -1.45268, 1, 0, 0.214703,-0.015511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371179,0.0492901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277677,0.00642542) , 
0, 0.769247, 1, 0, 0.305128,0.018281) , 
0, 0.353094, 1, 0, 0.250379,-0.0021788)    );
  // itree = 2281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305665,0.00663853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0931174,-0.0105671) , 
1, 1.40574, 1, 0, 0.275921,-0.00638609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0635313) , 
3, 1.55602, 1, 0, 0.249746,-0.00040598)    );
  // itree = 2282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386139,-0.0108877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118056,-0.0367828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265411,0.00955334) , 
1, -1.19679, 1, 0, 0.254219,-0.010819) , 
0, -1.61174, 1, 0, 0.260891,-0.00890439)    );
  // itree = 2283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239602,-0.012412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247525,-0.00496707) , 
2, 0.388251, 1, 0, 0.242407,-0.0014181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248804,0.00512881) , 
2, 1.55405, 1, 0, 0.243103,-0.0066346)    );
  // itree = 2284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208378,-0.00118655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294118,-0.0288481) , 
2, 0.118629, 1, 0, 0.246089,-0.0118267) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0959596,0.011908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764151,0.0334418) , 
3, 1.64535, 1, 0, 0.328947,0.0275289) , 
0, 1.13453, 1, 0, 0.258901,-0.00574116)    );
  // itree = 2285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384127,-0.0274994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287915,-0.00745077) , 
3, -1.30425, 1, 0, 0.314064,0.0103508) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292683,0.0439367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10568,0.00471011) , 
2, 0.495876, 1, 0, 0.131818,-0.0156223) , 
2, 0.314309, 1, 0, 0.23541,-0.000858775)    );
  // itree = 2286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365854,0.0180014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298077,0.00164357) , 
3, -1.15268, 1, 0, 0.320451,0.0134012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673077,-0.0304883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157795,-0.0096788) , 
0, 0.113928, 1, 0, 0.132153,-0.0168576) , 
3, 0.331768, 1, 0, 0.250506,0.00216135)    );
  // itree = 2287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0758177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219697,-0.00740814) , 
1, -1.1131, 1, 0, 0.180685,-0.0142565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328508,0.0099287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169492,0.0151425) , 
2, 1.55312, 1, 0, 0.302326,0.00344349) , 
0, -0.0771581, 1, 0, 0.244848,-0.00492013)    );
  // itree = 2288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234328,0.00441494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301095,-0.023632) , 
2, 0.704833, 1, 0, 0.253708,-0.003763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456311,0.0292931) , 
1, 1.73788, 1, 0, 0.264189,-0.00133974)    );
  // itree = 2289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361958,0.00653299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.034188,-0.0303222) , 
3, 1.10701, 1, 0, 0.333822,0.00141713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00507614,-0.0774309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102273,-0.00590011) , 
3, 0.113248, 1, 0, 0.0722135,-0.0187434) , 
2, 0.689402, 1, 0, 0.2505,-0.00500401)    );
  // itree = 2290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,0.00927941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356725,0.0195041) , 
2, -0.630308, 1, 0, 0.252358,-0.0286917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34013,0.000611422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106599,0.00118691) , 
3, 0.604141, 1, 0, 0.257485,0.0193196) , 
1, -0.537387, 1, 0, 0.256447,0.00959815)    );
  // itree = 2291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212916,-0.0103195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478261,0.0359241) , 
0, 1.3861, 1, 0, 0.237681,-0.00756912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429348,-0.00917129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,0.0207311) , 
3, 1.54307, 1, 0, 0.311189,0.0264151) , 
1, 1.46286, 1, 0, 0.248135,-0.00273596)    );
  // itree = 2292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184466,0.0317613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164634,-0.0393844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265385,-0.00405877) , 
0, -0.737419, 1, 0, 0.247881,-0.00831214) , 
0, -1.68098, 1, 0, 0.244601,-0.0061177)    );
  // itree = 2293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306429,0.00819612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173684,0.00835471) , 
3, 0.524774, 1, 0, 0.290566,-0.00279452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.066879,-0.0126297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137097,0.023735) , 
1, 1.46126, 1, 0, 0.086758,0.0163014) , 
3, 0.956967, 1, 0, 0.246548,0.00132975)    );
  // itree = 2294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312862,0.00810041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103604,-0.0201028) , 
0, 0.900791, 1, 0, 0.270046,-0.00953308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225138,-0.0124314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0569106,-0.0304153) , 
3, 1.73696, 1, 0, 0.200708,0.0218453) , 
1, 0.568457, 1, 0, 0.239648,0.00422339)    );
  // itree = 2295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0459184,0.056662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11284,0.0430175) , 
1, -1.09536, 1, 0, 0.0838852,-0.0228571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306088,-0.00931247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256614,-0.0140448) , 
3, 0.993703, 1, 0, 0.29423,0.00418473) , 
1, -0.484715, 1, 0, 0.247291,-0.00184973)    );
  // itree = 2296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132743,-0.0449601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289226,0.011545) , 
3, -1.57818, 1, 0, 0.250466,0.00674728) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189831,-0.0372741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39604,0.0108941) , 
1, 1.02726, 1, 0, 0.242424,-0.0246525) , 
0, 1.00007, 1, 0, 0.248878,0.000545631)    );
  // itree = 2297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498929,0.0211647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205267,4.13169e-05) , 
2, -0.802648, 1, 0, 0.275667,0.00507035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123967,-0.0199393) , 
1, 1.68641, 1, 0, 0.266796,0.00893941)    );
  // itree = 2298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0535714,-0.0482538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0859375,-0.00951944) , 
2, -1.69242, 1, 0, 0.0708333,-0.0222026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243781,0.0074943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281188,0.0030118) , 
1, -0.85461, 1, 0, 0.276807,0.00708784) , 
2, -1.24791, 1, 0, 0.251534,0.00349392)    );
  // itree = 2299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261006,0.0206178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270983,0.0120655) , 
3, -0.787539, 1, 0, 0.266667,0.00151555) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246154,-0.0182482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314721,-0.012971) , 
1, 1.35302, 1, 0, 0.272031,0.0351898) , 
3, 0.824791, 1, 0, 0.268072,0.0103398)    );
  // itree = 2300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158697,-0.000196651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486034,-0.0189048) , 
3, 0.888604, 1, 0, 0.223765,-0.00550108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327485,0.0157752) , 
1, 1.5317, 1, 0, 0.232759,-0.00318499)    );
  // itree = 2301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306362,0.00826598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163793,-0.0191671) , 
0, 0.9566, 1, 0, 0.286651,-0.000269951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0639535,0.0137449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167702,0.0293757) , 
0, 1.01035, 1, 0, 0.114114,-0.0389372) , 
3, 1.22488, 1, 0, 0.258081,-0.00667283)    );
  // itree = 2302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202726,-0.0203478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249556,-0.00327389) , 
1, -0.221119, 1, 0, 0.233508,0.00538381) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240741,-0.00481337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294393,0.0186196) , 
3, 0.0992809, 1, 0, 0.276398,-0.0252063) , 
1, 1.41142, 1, 0, 0.240295,0.000543508)    );
  // itree = 2303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125296,-0.0204715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568182,0.0425884) , 
3, 0.65471, 1, 0, 0.185072,-0.0142699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319104,-0.00328162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916667,-0.0427585) , 
0, 1.57029, 1, 0, 0.293283,0.0221712) , 
0, 0.0296075, 1, 0, 0.241278,0.00465797)    );
  // itree = 2304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228571,-0.001896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326531,0.0489259) , 
1, -1.24793, 1, 0, 0.289979,0.0289347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162857,-0.0189378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352876,0.017061) , 
2, 0.197813, 1, 0, 0.26995,0.00450883) , 
1, -0.484715, 1, 0, 0.274481,0.010035)    );
  // itree = 2305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321892,-0.00768045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231214,0.0126375) , 
3, 0.0365974, 1, 0, 0.29986,-0.00978383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0446429,-0.0590585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12178,0.0284566) , 
1, 0.343247, 1, 0, 0.105751,0.0254127) , 
3, 0.692862, 1, 0, 0.246561,-0.000119574)    );
  // itree = 2306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325,0.00736718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104348,-0.0347484) , 
0, 0.900791, 1, 0, 0.273038,-0.0131593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227766,0.0024693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0763359,-0.0232453) , 
3, 1.54175, 1, 0, 0.194257,0.014579) , 
1, 1.08497, 1, 0, 0.250365,-0.0051763)    );
  // itree = 2307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382423,0.0272785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23989,-0.00492021) , 
2, -0.802648, 1, 0, 0.271809,0.00102553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0837425) , 
1, 1.77419, 1, 0, 0.257951,-0.00088905)    );
  // itree = 2308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224638,-0.00366717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288136,0.0699939) , 
0, -0.834236, 1, 0, 0.238722,0.00836265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24581,-0.0344077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240938,-0.00543284) , 
1, -0.835152, 1, 0, 0.241488,-0.00827518) , 
0, -0.691888, 1, 0, 0.240793,-0.00409608)    );
  // itree = 2309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313869,0.000869328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254975,0.0018335) , 
0, -0.0159776, 1, 0, 0.287011,-0.0102314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0241935,-0.0243425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152672,0.0168077) , 
0, 1.19527, 1, 0, 0.0901961,0.010497) , 
3, 1.45397, 1, 0, 0.262141,-0.0076121)    );
  // itree = 2310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330579,0.015526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366972,0.0582403) , 
3, 0.705139, 1, 0, 0.297071,0.00852978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305936,0.000416994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0675991,-0.0264562) , 
3, 0.785477, 1, 0, 0.211786,-0.0213673) , 
1, 0.255725, 1, 0, 0.251714,-0.00737043)    );
  // itree = 2311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0665054,-0.0380391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232394,0.00487495) , 
2, 0.654342, 1, 0, 0.0908153,0.00671955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448619,0.0116562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275362,-0.0109124) , 
0, 1.23754, 1, 0, 0.425695,-0.0133578) , 
1, 0.367449, 1, 0, 0.264414,-0.00368833)    );
  // itree = 2312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138028,-0.00775978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443515,0.0210141) , 
3, 0.689902, 1, 0, 0.182037,6.86921e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31,-0.0536544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573991,-0.00698884) , 
0, 0.56862, 1, 0, 0.49226,-0.0326243) , 
3, 1.27365, 1, 0, 0.232593,-0.00525918)    );
  // itree = 2313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478049,-0.00785275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282979,-0.00939389) , 
3, -0.850554, 1, 0, 0.373864,0.0143705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177122,0.00897781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0591716,-0.00637346) , 
2, 1.15492, 1, 0, 0.142485,-0.00834155) , 
1, 0.227361, 1, 0, 0.242738,0.0014992)    );
  // itree = 2314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333691,0.00416644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14243,-0.00708604) , 
3, -0.245054, 1, 0, 0.234504,-0.00451009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,0.0184109) , 
2, 1.88316, 1, 0, 0.243376,-0.00268954)    );
  // itree = 2315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0490196,0.0290606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.0338114) , 
2, -0.77017, 1, 0, 0.0756303,-0.0284499) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0823542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314667,0.00137316) , 
0, -1.21886, 1, 0, 0.291358,-0.00128016) , 
1, -0.71469, 1, 0, 0.252403,-0.00618638)    );
  // itree = 2316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0513761,-0.0376658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00666667,0.0458573) , 
0, 0.0809852, 1, 0, 0.0417266,-0.0140375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566372,0.0529164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346561,0.000270655) , 
1, -0.608193, 1, 0, 0.36648,0.00654846) , 
3, -0.578844, 1, 0, 0.250257,-0.000818824)    );
  // itree = 2317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388235,-0.00187329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144097,0.00201169) , 
3, -0.178283, 1, 0, 0.289621,0.0058296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185841,-0.0283547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178042,0.00805273) , 
3, 0.415516, 1, 0, 0.181172,-0.0160686) , 
0, 0.676581, 1, 0, 0.258924,-0.000368836)    );
  // itree = 2318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281818,-0.0137047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133891,0.0070461) , 
3, -1.09191, 1, 0, 0.204793,0.014009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282158,-0.0106389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275194,0.00476996) , 
1, -0.103033, 1, 0, 0.27629,-0.00193862) , 
1, -0.517663, 1, 0, 0.259799,0.00173974)    );
  // itree = 2319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351852,0.0442174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224638,-0.00511773) , 
2, -1.13874, 1, 0, 0.245455,-0.00995545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366812,-0.0292551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11,0.086874) , 
3, 1.85868, 1, 0, 0.288754,0.0399991) , 
3, 1.15117, 1, 0, 0.252653,-0.00165073)    );
  // itree = 2320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224678,0.000363032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168,0.0479818) , 
1, 1.51134, 1, 0, 0.220639,0.0032857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644578,-0.0235287) , 
3, 1.74459, 1, 0, 0.257292,-0.000481414)    );
  // itree = 2321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285085,-0.000406012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149123,0.0154148) , 
1, 1.58039, 1, 0, 0.275984,-0.00195757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0821918,-0.0301621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162162,-0.0201023) , 
0, 1.56976, 1, 0, 0.116732,0.0264038) , 
0, 1.28629, 1, 0, 0.255102,0.00176125)    );
  // itree = 2322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181081,-0.0101443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0125786,-0.0378007) , 
0, 0.702786, 1, 0, 0.151279,0.0110831) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24055,-0.00547686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340476,-0.0021584) , 
2, 0.35744, 1, 0, 0.314766,-0.00604348) , 
2, -0.0855223, 1, 0, 0.242365,0.00154115)    );
  // itree = 2323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18123,-0.0146313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380583,-0.0183723) , 
3, -0.491208, 1, 0, 0.271845,0.0147971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317829,0.0419664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22619,-0.00920423) , 
0, -0.54731, 1, 0, 0.239548,-0.00445486) , 
2, 0.30194, 1, 0, 0.257681,0.00635407)    );
  // itree = 2324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277533,0.0321591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218524,-0.000461025) , 
1, -1.03776, 1, 0, 0.226849,0.00443695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,-0.0869677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278431,-0.0115274) , 
1, 0.969552, 1, 0, 0.288945,-0.0385828) , 
2, 1.07686, 1, 0, 0.239163,-0.00409411)    );
  // itree = 2325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528846,-0.00810661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310259,0.00164001) , 
3, -1.98839, 1, 0, 0.327705,-0.00405344) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0318471,-0.0308077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111776,-0.0209151) , 
0, -0.0269407, 1, 0, 0.0927052,0.0270834) , 
3, 0.525776, 1, 0, 0.248853,0.00639432)    );
  // itree = 2326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264256,0.0118643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237575,-0.000740099) , 
1, -0.0744646, 1, 0, 0.248696,0.00330353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357143,0.00679934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316667,0.0127856) , 
0, 1.09591, 1, 0, 0.340278,-0.0358099) , 
2, 1.46433, 1, 0, 0.261798,-0.00229243)    );
  // itree = 2327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654952,-0.0418854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116022,-0.0143284) , 
2, -0.0629795, 1, 0, 0.0840081,0.015231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443925,-0.000560289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35443,0.0253964) , 
3, 0.804134, 1, 0, 0.409836,-0.0182129) , 
1, 0.344779, 1, 0, 0.250864,-0.00189558)    );
  // itree = 2328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0275862,-0.0316019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344411,0.0301592) , 
3, -1.64126, 1, 0, 0.247899,0.0159206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244833,-0.00836142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29595,-0.0309822) , 
2, 1.19224, 1, 0, 0.255225,-0.01237) , 
0, -0.691888, 1, 0, 0.253528,-0.00581705)    );
  // itree = 2329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322282,0.0104839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0223881,-0.047488) , 
3, 1.10741, 1, 0, 0.2942,-0.0013013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249292,-0.00463387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110553,0.0108725) , 
3, 1.26151, 1, 0, 0.199275,-0.0212254) , 
0, 0.676581, 1, 0, 0.267776,-0.00684749)    );
  // itree = 2330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33887,-0.00217273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0173733) , 
3, 0.38655, 1, 0, 0.270202,0.0070197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219858,0.0203729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22963,0.0105316) , 
1, -0.290095, 1, 0, 0.227941,-0.017705) , 
0, 0.307804, 1, 0, 0.252994,-0.00304784)    );
  // itree = 2331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225471,-0.00315447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34413,0.0143524) , 
3, 0.686473, 1, 0, 0.241881,-0.00722572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186667,-0.00337043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254335,-0.036352) , 
1, 1.14176, 1, 0, 0.22291,0.0241339) , 
3, 1.27365, 1, 0, 0.238976,-0.00242291)    );
  // itree = 2332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186961,0.00975774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22096,-0.00917003) , 
2, 0.212369, 1, 0, 0.201635,0.00089763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751678,0.0236743) , 
3, 1.76176, 1, 0, 0.242944,0.00402353)    );
  // itree = 2333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618056,0.0052912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256924,-0.00123027) , 
1, -1.38429, 1, 0, 0.285171,-0.00171476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0614035,-0.0288664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0648649,-0.0186779) , 
1, 1.01673, 1, 0, 0.0635452,0.0401876) , 
3, 1.27365, 1, 0, 0.254206,0.00413982)    );
  // itree = 2334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528302,0.0497589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239511,-0.000976066) , 
3, -1.97613, 1, 0, 0.254902,-0.00352528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472222,0.0510789) , 
1, 1.73788, 1, 0, 0.266094,-0.00633205)    );
  // itree = 2335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00531915,0.100957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230904,-0.00718917) , 
1, -1.08981, 1, 0, 0.198945,0.00702397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416667,0.00322247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227586,0.0528502) , 
2, 1.5004, 1, 0, 0.374422,-0.0227309) , 
0, 0.6269, 1, 0, 0.256579,-0.00274875)    );
  // itree = 2336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159122,-0.0214629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0505618,0.0382353) , 
1, 0.158876, 1, 0, 0.113222,-0.00562343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478405,0.013165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36413,-0.0147202) , 
2, 1.49933, 1, 0, 0.451654,0.0104019) , 
3, 0.275101, 1, 0, 0.243045,0.000523934)    );
  // itree = 2337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515152,-0.00752453) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218732,-0.00412212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225806,0.0447802) , 
1, 1.62486, 1, 0, 0.219208,0.000429678) , 
2, -1.52711, 1, 0, 0.243526,0.00325602)    );
  // itree = 2338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235915,-0.00507184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389439,0.00778877) , 
2, 0.34624, 1, 0, 0.27619,-0.0135999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241463,-0.0140532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135945,-0.000146126) , 
3, 0.487166, 1, 0, 0.187204,0.0154823) , 
1, 0.630385, 1, 0, 0.238619,-0.00132109)    );
  // itree = 2339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0840336,0.00443414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106232,-0.0204723) , 
3, -0.539111, 1, 0, 0.0960799,0.0139927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59887,0.00760256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35082,-0.00601706) , 
0, 0.311456, 1, 0, 0.484067,-0.00931819) , 
1, 0.939437, 1, 0, 0.226531,0.00615499)    );
  // itree = 2340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405728,-0.0254918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339926,0.021939) , 
3, -1.09621, 1, 0, 0.237785,0.00975492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119355,0.00971937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34238,-0.0181677) , 
2, 0.274947, 1, 0, 0.254753,-0.0111683) , 
0, 0.353094, 1, 0, 0.244422,0.00157028)    );
  // itree = 2341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427757,0.00847306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31457,0.00669508) , 
0, -0.305233, 1, 0, 0.367257,-0.0101513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122616,-0.00207942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0607735,-0.0137345) , 
3, 1.40895, 1, 0, 0.110383,0.0098302) , 
1, 0.583399, 1, 0, 0.252323,-0.0012109)    );
  // itree = 2342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343923,-0.0036081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125664,-0.0315452) , 
3, -0.2095, 1, 0, 0.248254,0.0111642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0592593,-0.0103814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290541,0.0074521) , 
2, 0.360899, 1, 0, 0.203081,-0.0107954) , 
1, 0.879105, 1, 0, 0.232152,0.00333633)    );
  // itree = 2343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.128526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0186335,-0.0912907) , 
3, -1.69459, 1, 0, 0.0111111,0.0179902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0760234,0.025214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318124,0.0109539) , 
1, -0.917455, 1, 0, 0.294454,-0.0100874) , 
0, -0.972742, 1, 0, 0.256563,-0.0063326)    );
  // itree = 2344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121622,-0.0303303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0323194,-0.018206) , 
0, -1.07762, 1, 0, 0.0588235,-0.0125349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332463,0.0143479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.883929,0.0394926) , 
3, 1.88222, 1, 0, 0.381443,0.0203981) , 
3, -0.578844, 1, 0, 0.261324,0.00813632)    );
  // itree = 2345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276869,-0.00388565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104418,0.000876632) , 
1, 1.41354, 1, 0, 0.254972,0.011794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0190476,-0.0635081) , 
2, 1.87748, 1, 0, 0.242982,0.0167685)    );
  // itree = 2346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0993789,-0.0251542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302775,0.00869967) , 
2, -0.870686, 1, 0, 0.259431,-0.00986021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273224,-0.0467337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330645,0.0250938) , 
2, 0.594062, 1, 0, 0.201856,0.0212442) , 
1, 1.28142, 1, 0, 0.246653,-0.00295702)    );
  // itree = 2347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.120843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251562,-0.0062906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157895,0.00285725) , 
3, 1.7528, 1, 0, 0.244119,-0.0149566) , 
1, -1.45172, 1, 0, 0.230276,-0.011912)    );
  // itree = 2348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0616883,-0.0100366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451902,0.0341884) , 
3, -1.01241, 1, 0, 0.292715,0.020161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168675,-0.0152111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692308,0.0168372) , 
3, 1.63519, 1, 0, 0.239583,-0.00599935) , 
1, 0.0775028, 1, 0, 0.260619,0.00435781)    );
  // itree = 2349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284553,-0.00710345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0514019,-0.0307447) , 
1, 1.29547, 1, 0, 0.228523,0.00360294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163043,0.0218354) , 
0, 1.38197, 1, 0, 0.222392,-0.000692361)    );
  // itree = 2350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316239,-0.00273858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139928,-0.0186835) , 
3, 0.0181379, 1, 0, 0.238576,0.00940378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220513,0.0335943) , 
0, 1.44177, 1, 0, 0.23688,0.00601015)    );
  // itree = 2351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15016,-0.00910143) , 
3, -1.81996, 1, 0, 0.107798,0.0284062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330784,0.00899559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250877,0.00837741) , 
2, 0.723486, 1, 0, 0.302599,-0.00466265) , 
0, -0.727763, 1, 0, 0.261209,0.00236367)    );
  // itree = 2352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226729,-0.0147954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278646,0.0107382) , 
0, 1.01723, 1, 0, 0.237288,-0.00740866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471698,0.0279019) , 
1, 1.7097, 1, 0, 0.249749,-0.00452043)    );
  // itree = 2353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430345,-0.00632064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231672,0.0317221) , 
3, 0.0281018, 1, 0, 0.366792,-0.0122362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111607,-0.0301491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101449,0.0103944) , 
2, 0.579924, 1, 0, 0.106,0.0119224) , 
1, 0.51317, 1, 0, 0.240561,-0.00054278)    );
  // itree = 2354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343993,0.0110535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104121,-0.0200198) , 
3, 0.3925, 1, 0, 0.275649,0.00556935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159864,-0.00658634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188525,-0.0121372) , 
0, 1.50795, 1, 0, 0.168269,-0.0309218) , 
0, 0.956597, 1, 0, 0.253687,-0.00189394)    );
  // itree = 2355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25441,-0.00806495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277556,0.00577247) , 
2, 0.328363, 1, 0, 0.263934,0.0041536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0853137) , 
1, 1.77419, 1, 0, 0.250649,0.000919422)    );
  // itree = 2356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258883,-0.00423699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245322,0.0164091) , 
1, 0.227361, 1, 0, 0.251429,0.00638332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118881,-0.0569614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,-0.00164755) , 
1, 0.48698, 1, 0, 0.252918,-0.0303874) , 
0, 1.28629, 1, 0, 0.251619,0.00167476)    );
  // itree = 2357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288221,1.34784e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120438,0.00323326) , 
3, 0.955817, 1, 0, 0.263636,0.00471026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722892,0.0135154) , 
3, 1.71152, 1, 0, 0.248035,2.64806e-05)    );
  // itree = 2358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284876,-0.000152893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0362319,-0.00811909) , 
3, 1.00923, 1, 0, 0.246961,-0.00373715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296875,-0.0211669) , 
1, 1.63393, 1, 0, 0.250258,0.00147665)    );
  // itree = 2359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14974,-0.0187393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339572,-0.0011337) , 
0, -0.25398, 1, 0, 0.243404,0.00206128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355491,0.0180885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242268,-0.000543127) , 
0, 1.14124, 1, 0, 0.314815,-0.0193377) , 
3, 0.802707, 1, 0, 0.26216,-0.00355908)    );
  // itree = 2360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.088429,-0.027482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37469,0.0215967) , 
3, 0.129514, 1, 0, 0.167121,-0.0041445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371859,-0.0439835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60166,-0.00116671) , 
2, 0.905427, 1, 0, 0.497727,-0.0309482) , 
3, 0.951289, 1, 0, 0.243442,-0.0103321)    );
  // itree = 2361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369792,0.00506031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347826,0.022596) , 
0, -1.16412, 1, 0, 0.359773,-0.019535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252421,0.00162834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0656934,-0.0131439) , 
3, 1.76492, 1, 0, 0.237248,0.00169132) , 
0, -0.805343, 1, 0, 0.25846,-0.00198347)    );
  // itree = 2362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314991,0.00874517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264081,-0.00426631) , 
0, -0.543004, 1, 0, 0.280745,0.00409748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0495495,0.0584907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165414,0.00460015) , 
1, 1.38231, 1, 0, 0.0929577,-0.0221897) , 
3, 1.12905, 1, 0, 0.246819,-0.000651607)    );
  // itree = 2363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0577617,0.0520928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288265,-0.00260948) , 
1, -0.903139, 1, 0, 0.253659,-0.00273128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.048,-0.00610232) , 
1, 1.65151, 1, 0, 0.240609,-0.00732014)    );
  // itree = 2364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278846,0.0668909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253086,0.0364217) , 
2, -0.961985, 1, 0, 0.263158,0.0514803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250827,-0.00235926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331126,-0.0536631) , 
2, 1.69396, 1, 0, 0.258123,-0.00702621) , 
0, -0.940853, 1, 0, 0.258817,0.00104575)    );
  // itree = 2365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521739,-0.0261106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210462,-0.00244273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,0.0268681) , 
1, 1.71017, 1, 0, 0.209262,-0.000266951) , 
1, -1.06103, 1, 0, 0.239007,0.00534399)    );
  // itree = 2366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283439,0.001805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.00473527) , 
0, 1.01723, 1, 0, 0.263464,0.00601756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447619,0.0112259) , 
1, 1.7097, 1, 0, 0.273137,0.0027496)    );
  // itree = 2367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0384615,0.26727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.047619,-0.0271465) , 
2, -1.06957, 1, 0, 0.0430622,0.041042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290942,-0.00244773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12844,-0.0215617) , 
0, 1.52799, 1, 0, 0.280968,0.00337387) , 
1, -1.102, 1, 0, 0.255919,0.00733993)    );
  // itree = 2368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212963,0.0324828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0911708,-0.0190759) , 
1, -1.52311, 1, 0, 0.102609,-0.00414948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517094,0.0249528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339492,-0.0013955) , 
0, 0.593631, 1, 0, 0.431743,0.0159141) , 
3, 0.0619493, 1, 0, 0.247196,0.00466442)    );
  // itree = 2369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666667,-0.00723566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130081,-0.0224327) , 
1, -0.319031, 1, 0, 0.439863,0.0218978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236919,0.000215939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101695,0.00368849) , 
3, 1.20783, 1, 0, 0.213046,-0.00358689) , 
2, -1.09203, 1, 0, 0.246687,0.000192949)    );
  // itree = 2370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282258,0.0137096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.000357207) , 
1, -0.619588, 1, 0, 0.341954,0.0329262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258442,0.0029806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0829694,-0.0080658) , 
3, 1.44298, 1, 0, 0.234524,-0.000102281) , 
0, -0.824386, 1, 0, 0.252959,0.00556534)    );
  // itree = 2371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10076,-0.00370436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467516,0.000325275) , 
1, 0.552515, 1, 0, 0.257485,-0.00288441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09,-0.034495) , 
2, 1.84379, 1, 0, 0.248838,0.000146981)    );
  // itree = 2372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178218,0.0543189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342857,0.0147369) , 
2, -0.983999, 1, 0, 0.262136,0.0289194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280261,-0.0117365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205405,0.00973309) , 
1, 0.844592, 1, 0, 0.249724,-0.00274583) , 
1, -1.04974, 1, 0, 0.25099,0.0004834)    );
  // itree = 2373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262123,-0.0140075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244019,0.00606978) , 
0, -0.252752, 1, 0, 0.251659,-0.00450492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.04,-0.0417269) , 
3, 1.73078, 1, 0, 0.235444,-0.00135377)    );
  // itree = 2374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230483,-0.00628108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217857,-0.0218245) , 
1, -0.950252, 1, 0, 0.224044,0.022992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291621,0.0116169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221269,0.00215737) , 
0, 0.52927, 1, 0, 0.264314,-0.00287837) , 
1, -0.343262, 1, 0, 0.253535,0.00404647)    );
  // itree = 2375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0482315,-0.00844893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311321,0.0706744) , 
3, -0.690253, 1, 0, 0.115108,-0.0235622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301508,-0.000857058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279883,-0.0149333) , 
3, 1.07023, 1, 0, 0.296682,0.00424689) , 
0, -0.73378, 1, 0, 0.257932,-0.0016878)    );
  // itree = 2376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26259,0.0255842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173184,-0.00656941) , 
0, -0.976279, 1, 0, 0.187719,-0.00015842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478947,-0.0489479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505882,0.00283685) , 
1, 1.34923, 1, 0, 0.491667,-0.0410761) , 
3, 1.14622, 1, 0, 0.24058,-0.00727454)    );
  // itree = 2377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414231,0.00820568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211988,-0.00923808) , 
2, -0.288846, 1, 0, 0.32019,0.00299608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0474138,-0.0196571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13369,0.0211887) , 
3, 0.490019, 1, 0, 0.10066,-0.0238629) , 
2, 0.721559, 1, 0, 0.256139,-0.00484048)    );
  // itree = 2378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165621,-0.0022026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296656,0.007065) , 
2, -0.218323, 1, 0, 0.236079,0.00378733) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,-0.00193138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346154,-0.00683776) , 
1, 1.26601, 1, 0, 0.331967,-0.0293768) , 
2, 1.46214, 1, 0, 0.247967,-0.000324476)    );
  // itree = 2379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0433333,0.0241119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318596,0.00665024) , 
0, -0.947875, 1, 0, 0.273667,-0.00562493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0846154,0.0020466) , 
1, 1.65114, 1, 0, 0.261179,-0.00817964)    );
  // itree = 2380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184739,0.00211535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417431,-0.0275943) , 
3, 0.88238, 1, 0, 0.219412,-0.00462106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,-0.0128585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350993,0.0480069) , 
1, 1.02344, 1, 0, 0.354125,0.0295222) , 
2, 0.859936, 1, 0, 0.253571,0.00403669)    );
  // itree = 2381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459344,-0.00130634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139905,-0.0139346) , 
2, -0.000686839, 1, 0, 0.308271,0.00540262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0958904,0.00247863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0879541,-0.0128847) , 
0, -0.51993, 1, 0, 0.0896861,-0.015121) , 
1, 0.939437, 1, 0, 0.235118,-0.00146595)    );
  // itree = 2382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31051,-0.0078076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112116,-0.0141288) , 
3, 0.3925, 1, 0, 0.249862,0.0134376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13125,-0.0174749) , 
0, 1.44177, 1, 0, 0.240223,0.0184622)    );
  // itree = 2383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0792472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614173,0.00478627) , 
1, 0.933525, 1, 0, 0.148571,0.0184298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329242,0.0103669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00990099,-0.0862417) , 
3, 1.87731, 1, 0, 0.307537,-0.00737403) , 
0, -0.617366, 1, 0, 0.266037,-0.000637574)    );
  // itree = 2384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116379,0.0104918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380216,-0.0133621) , 
3, 0.00244967, 1, 0, 0.224762,-0.00359698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276423,0.00758627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465116,0.0413404) , 
0, 1.14777, 1, 0, 0.341333,0.0236612) , 
2, 1.0891, 1, 0, 0.247179,0.00164498)    );
  // itree = 2385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.661017,0.0141528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306338,0.000491812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213267,0.00460162) , 
0, -0.919971, 1, 0, 0.227201,0.00174844) , 
1, -1.40737, 1, 0, 0.252605,-0.00203924)    );
  // itree = 2386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429752,0.00836162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264114,0.00609371) , 
0, -1.38129, 1, 0, 0.276173,-0.00837508) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144231,-0.00586851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139394,-0.0153059) , 
3, 0.555304, 1, 0, 0.141264,0.0455542) , 
0, 1.19707, 1, 0, 0.25738,-0.000862406)    );
  // itree = 2387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0759241) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,0.024665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275924,-0.00365566) , 
0, -0.884057, 1, 0, 0.256263,-0.000126603) , 
0, -1.58783, 1, 0, 0.241872,-0.00294321)    );
  // itree = 2388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.08253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207207,-0.0266879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282126,0.0154855) , 
1, -1.25541, 1, 0, 0.277564,0.0116035) , 
3, -2.02293, 1, 0, 0.262584,0.00884478)    );
  // itree = 2389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440443,0.000740371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17161,-0.0148315) , 
3, -0.226556, 1, 0, 0.334171,0.0147868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176056,0.00661313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0676101,-0.0241452) , 
1, 1.07016, 1, 0, 0.101087,-0.00617418) , 
1, 0.528797, 1, 0, 0.232734,0.00566472)    );
  // itree = 2390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281516,-0.00854519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171096,0.00562459) , 
0, 0.482577, 1, 0, 0.246438,0.00286252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378049,0.0169871) , 
2, 1.63767, 1, 0, 0.256921,-0.000722988)    );
  // itree = 2391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0892253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286392,0.0205757) , 
0, -1.19764, 1, 0, 0.227673,-0.0130842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242424,0.0265015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255238,-0.010818) , 
3, -0.206739, 1, 0, 0.254134,0.012194) , 
3, -0.397795, 1, 0, 0.243313,0.00185648)    );
  // itree = 2392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254545,0.0684071) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260606,0.0390572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237084,-0.0101931) , 
1, -1.12426, 1, 0, 0.239119,-0.0051432) , 
0, -1.56147, 1, 0, 0.23996,-0.0015138)    );
  // itree = 2393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498507,0.00861471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225974,0.0095953) , 
1, -0.761509, 1, 0, 0.274667,-0.00358701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,0.0310193) , 
3, 1.76176, 1, 0, 0.260633,-0.0067866)    );
  // itree = 2394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272294,-0.00625221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156682,-0.0108178) , 
0, 0.80515, 1, 0, 0.245927,-0.00181121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235849,0.0409775) , 
0, 1.55221, 1, 0, 0.245396,-0.00445561)    );
  // itree = 2395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00500835,-0.0335925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44186,0.00886603) , 
0, 0.782376, 1, 0, 0.0824176,-0.00833439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.729412,0.0455864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268421,-0.000131408) , 
2, -0.768628, 1, 0, 0.328244,0.010616) , 
1, -0.128677, 1, 0, 0.240432,0.00384668)    );
  // itree = 2396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160714,-0.0268091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24735,0.0072935) , 
1, -1.19679, 1, 0, 0.23955,0.00313574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39,-0.0321696) , 
0, 1.55221, 1, 0, 0.247202,0.000354185)    );
  // itree = 2397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314922,-0.00443893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112,-0.00242505) , 
3, 0.400621, 1, 0, 0.245919,0.0103083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127273,-0.0199472) , 
1, 1.65151, 1, 0, 0.23922,0.00622244)    );
  // itree = 2398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,-0.0129975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253341,0.000435459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0737705,-0.00566013) , 
3, 1.77725, 1, 0, 0.241454,-0.00916967) , 
0, -1.68098, 1, 0, 0.247041,-0.0070995)    );
  // itree = 2399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253901,0.000550065) , 
0, -1.56366, 1, 0, 0.235837,-0.00510892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.739496,0.052067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163488,-0.0207245) , 
2, 0.326079, 1, 0, 0.304527,0.0163037) , 
3, 0.824791, 1, 0, 0.252495,8.3962e-05)    );
  // itree = 2400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317073,0.0579473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135537,-0.000195049) , 
1, -1.04974, 1, 0, 0.181481,0.0118554) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223108,-0.0661456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322613,-0.00709425) , 
2, 0.23021, 1, 0, 0.302568,-0.0166828) , 
2, -0.158971, 1, 0, 0.254864,-0.00543961)    );
  // itree = 2401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446154,-0.00861506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220546,0.00384621) , 
1, -0.776769, 1, 0, 0.26325,0.00163383) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,0.004519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114428,0.0249927) , 
2, 0.888457, 1, 0, 0.0965732,-0.0367405) , 
3, 1.29328, 1, 0, 0.236997,-0.00441042)    );
  // itree = 2402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12,-0.0120013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357542,-0.00907999) , 
2, -0.725787, 1, 0, 0.287402,0.00315457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547945,0.00877886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109827,-0.0217712) , 
1, 0.626734, 1, 0, 0.0934959,0.0239223) , 
3, 0.824791, 1, 0, 0.240079,0.00822288)    );
  // itree = 2403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686813,0.0280454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304348,-0.0093357) , 
1, -0.621741, 1, 0, 0.258203,0.0088821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0190476,-0.047451) , 
1, 1.68939, 1, 0, 0.245418,0.00631887)    );
  // itree = 2404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180556,-0.0398769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231206,-0.0104988) , 
1, -1.09318, 1, 0, 0.224477,-0.0121634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217391,0.0468773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440298,-0.0116664) , 
2, 1.20527, 1, 0, 0.299451,0.0185176) , 
0, 0.944261, 1, 0, 0.238191,-0.00655139)    );
  // itree = 2405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.68595,0.0371051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356522,0.00962021) , 
0, -0.653631, 1, 0, 0.525424,-0.0318313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200229,-0.0135165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121495,-0.0359686) , 
0, 1.54393, 1, 0, 0.195687,0.0180711) , 
2, -1.24791, 1, 0, 0.232903,0.0124389)    );
  // itree = 2406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135878,-0.00846095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248366,0.00136177) , 
2, -0.390815, 1, 0, 0.190213,0.0144728) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398287,-0.00160079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0995261,0.00250672) , 
3, 1.3286, 1, 0, 0.30531,-0.0196125) , 
2, 0.654386, 1, 0, 0.230334,0.00259118)    );
  // itree = 2407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0846154,-0.0620095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669811,0.0595761) , 
3, -1.34368, 1, 0, 0.347458,-0.030086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225564,-0.0099237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266932,-0.00049212) , 
2, 0.967329, 1, 0, 0.2369,0.00439565) , 
2, -1.24791, 1, 0, 0.249516,0.000460612)    );
  // itree = 2408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219731,-0.0245483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303069,0.0287306) , 
1, -1.00171, 1, 0, 0.284577,0.0144238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188608,-0.0227018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353982,0.0225064) , 
2, 1.47182, 1, 0, 0.225394,-0.00879052) , 
1, 0.388779, 1, 0, 0.254824,0.00275349)    );
  // itree = 2409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36,0.00380385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0330578,-0.0559545) , 
3, 1.08004, 1, 0, 0.32825,0.00412224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.078534,-0.0253843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142466,0.0297721) , 
0, 0.279683, 1, 0, 0.109772,-0.0181829) , 
1, 0.807077, 1, 0, 0.246362,-0.00423798)    );
  // itree = 2410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320783,0.00456946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0536585,0.00737116) , 
3, 0.155094, 1, 0, 0.257768,0.00978967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241344,-0.0017788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233333,0.0265254) , 
0, 1.38542, 1, 0, 0.240283,-0.00475917) , 
1, 0.162984, 1, 0, 0.247876,0.00155914)    );
  // itree = 2411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0833068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45098,0.0240917) , 
1, -1.24256, 1, 0, 0.324706,0.0186902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0848214,-0.0130012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283054,-0.00632036) , 
1, -0.0777464, 1, 0, 0.224704,-0.00536321) , 
2, -0.860447, 1, 0, 0.246533,-0.000112726)    );
  // itree = 2412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0417755,-0.0128062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342256,0.01828) , 
3, -1.15048, 1, 0, 0.261721,0.0121617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13,0.0238366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324675,-0.0187638) , 
2, 0.324469, 1, 0, 0.25812,-0.00937895) , 
0, 0.676581, 1, 0, 0.260675,0.00590488)    );
  // itree = 2413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310631,-0.00749044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228371,-0.000358263) , 
0, -0.543811, 1, 0, 0.254642,0.00121841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.03,-0.0450008) , 
3, 1.99526, 1, 0, 0.243325,0.00397472)    );
  // itree = 2414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30869,0.00397432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241153,0.000314223) , 
1, 0.388779, 1, 0, 0.275098,-0.000766432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0754717,-0.0310653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197952,0.0112878) , 
1, -0.107859, 1, 0, 0.165414,-0.0309694) , 
0, 0.956597, 1, 0, 0.252457,-0.00700077)    );
  // itree = 2415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278395,-0.00534152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215596,-0.0201805) , 
2, 0.37097, 1, 0, 0.25589,0.00445262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311927,0.0210038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12381,-0.0467335) , 
0, 0.810246, 1, 0, 0.219626,-0.0416572) , 
2, 1.53606, 1, 0, 0.252084,-0.000386764)    );
  // itree = 2416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130876,-0.00572047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520064,0.017162) , 
3, 0.1401, 1, 0, 0.272834,0.00666666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0858209,-0.0556582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327586,0.00381129) , 
2, 1.43933, 1, 0, 0.158854,-0.032187) , 
1, 1.36335, 1, 0, 0.251912,-0.000465185)    );
  // itree = 2417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56,-0.0106016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255892,0.00145751) , 
1, -1.34692, 1, 0, 0.279503,-0.0091482) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679245,0.00824124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130137,0.0112317) , 
0, 1.16767, 1, 0, 0.0900243,0.0191136) , 
3, 0.951289, 1, 0, 0.24097,-0.00340075)    );
  // itree = 2418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243463,0.00430651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0803003) , 
3, 0.893392, 1, 0, 0.214116,-0.0106727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332589,0.00469607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338095,-0.0107718) , 
2, 1.58107, 1, 0, 0.334347,0.00608788) , 
2, 0.648293, 1, 0, 0.255341,-0.00492573)    );
  // itree = 2419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0754363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276323,0.00280852) , 
0, -1.50708, 1, 0, 0.257128,-0.000157487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0833547) , 
1, 1.80063, 1, 0, 0.243018,-0.00324212)    );
  // itree = 2420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148676,-0.0136537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456456,0.007779) , 
3, 0.809278, 1, 0, 0.205426,-0.00486393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744361,0.0245157) , 
3, 1.74551, 1, 0, 0.242393,-0.00152217)    );
  // itree = 2421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410828,-0.00640502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40681,0.0147723) , 
0, -0.728051, 1, 0, 0.408257,-0.000122201) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176667,-0.0163866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13879,0.0111912) , 
1, 0.0780164, 1, 0, 0.148731,-0.0168538) , 
2, -0.0929401, 1, 0, 0.261042,-0.00961312)    );
  // itree = 2422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535714,0.0266684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28,-0.0153285) , 
3, -2.00999, 1, 0, 0.371795,0.0311114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275862,-0.00019057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227068,0.00550538) , 
3, -0.729463, 1, 0, 0.239093,0.000368836) , 
0, -0.934124, 1, 0, 0.259027,0.00498688)    );
  // itree = 2423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00613497,-0.0866216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0652174,0.0232523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318236,0.0051924) , 
0, -0.940853, 1, 0, 0.287736,-0.00682543) , 
1, -1.25764, 1, 0, 0.265572,-0.00449915)    );
  // itree = 2424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267931,-0.00685995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176642,0.0203562) , 
1, 0.757817, 1, 0, 0.234984,0.00197599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0384174) , 
3, 2.06951, 1, 0, 0.267267,0.00517191)    );
  // itree = 2425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530612,0.0175663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207988,0.00100613) , 
1, -0.645247, 1, 0, 0.274251,-0.00901695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106509,-0.0219493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875,-0.0259167) , 
3, 1.10126, 1, 0, 0.0972644,0.0335431) , 
0, 1.13557, 1, 0, 0.245123,-0.00201232)    );
  // itree = 2426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371681,-0.0171938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262608,-0.0036005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.07393,0.00164113) , 
3, 1.38149, 1, 0, 0.236856,0.00358049) , 
0, -1.58783, 1, 0, 0.244489,0.00597796)    );
  // itree = 2427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223031,-0.00174693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.00192912) , 
3, 1.15349, 1, 0, 0.245048,0.00672022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.594828,-0.00898058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192308,-0.00877032) , 
0, 1.5093, 1, 0, 0.404545,-0.0232881) , 
0, 1.32355, 1, 0, 0.262708,0.00339771)    );
  // itree = 2428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00662252,-0.0833033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260213,-0.000631346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352941,-0.0321351) , 
1, 1.6377, 1, 0, 0.26522,-0.00349391) , 
2, -1.52711, 1, 0, 0.246078,-0.00627796)    );
  // itree = 2429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358209,0.00372225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921596,-0.00619404) , 
1, 0.697188, 1, 0, 0.250695,0.00189851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261905,0.0341544) , 
0, 1.49754, 1, 0, 0.251429,-0.00158554)    );
  // itree = 2430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327088,0.00538617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0271739,-0.0583784) , 
3, 0.941133, 1, 0, 0.28942,0.0048225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,0.0143783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22673,0.0221861) , 
1, -0.286534, 1, 0, 0.20794,-0.0169096) , 
0, 0.759972, 1, 0, 0.267803,-0.000942927)    );
  // itree = 2431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233758,0.0116513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357143,0.00647534) , 
3, 1.01683, 1, 0, 0.241974,-0.00811805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448113,0.0297392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0833431) , 
3, 1.89298, 1, 0, 0.285285,-0.0415954) , 
3, 1.30934, 1, 0, 0.249132,-0.0136505)    );
  // itree = 2432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252336,0.0637365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286745,0.003013) , 
0, -1.7049, 1, 0, 0.283717,0.00838172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112948,-0.0504938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275701,0.00232809) , 
0, 0.144459, 1, 0, 0.201011,-0.0211115) , 
1, 0.767416, 1, 0, 0.251121,-0.00324217)    );
  // itree = 2433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384181,-0.000160762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230016,0.00456704) , 
3, -0.884422, 1, 0, 0.276608,0.0024578) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620155,0.0134461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.047619,-0.0318882) , 
3, 1.40895, 1, 0, 0.0555556,-0.0258765) , 
2, 1.49368, 1, 0, 0.250628,-0.000872303)    );
  // itree = 2434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220249,0.00239328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381883,-0.000280887) , 
2, -0.165952, 1, 0, 0.301066,0.0051266) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160985,0.0125437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311927,0.00122239) , 
2, 0.887673, 1, 0, 0.218713,-0.0180721) , 
0, 0.244109, 1, 0, 0.265522,-0.00488598)    );
  // itree = 2435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293447,0.003937) , 
0, -1.37918, 1, 0, 0.271053,0.00631645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0810555) , 
1, 1.72304, 1, 0, 0.256986,0.00196612)    );
  // itree = 2436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129088,0.00771682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251799,-0.0327949) , 
2, -0.544684, 1, 0, 0.201413,-0.0156184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342105,0.0733045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336735,0.007084) , 
0, -0.311943, 1, 0, 0.337748,0.0168078) , 
2, 0.721559, 1, 0, 0.242199,-0.00591787)    );
  // itree = 2437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326446,-0.00247647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255878,0.000926749) , 
0, -0.631311, 1, 0, 0.284176,-0.00278237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213693,-0.00998859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0984849,-0.0128608) , 
3, 1.08427, 1, 0, 0.172922,0.0158845) , 
0, 0.446909, 1, 0, 0.241679,0.00434793)    );
  // itree = 2438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271409,-0.000913131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2075,-0.00414285) , 
1, 1.2364, 1, 0, 0.257576,0.0108572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0412371,-0.0153844) , 
3, 1.62567, 1, 0, 0.237023,0.0140631)    );
  // itree = 2439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0223881,0.237834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303704,-0.00453043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227126,-0.00427381) , 
2, 0.211207, 1, 0, 0.265742,0.00372683) , 
1, -1.40498, 1, 0, 0.249502,0.000682268)    );
  // itree = 2440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167089,0.0144132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711864,0.0373172) , 
3, 0.383863, 1, 0, 0.266805,0.0190547) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0495868,0.00601721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378761,-0.0165325) , 
3, 0.360867, 1, 0, 0.226883,-0.0120817) , 
1, 0.324332, 1, 0, 0.246032,0.00285327)    );
  // itree = 2441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323668,0.0036829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12336,-0.0137703) , 
3, 0.475705, 1, 0, 0.27761,0.00715314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0609756,0.0248121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0991736,0.0133005) , 
1, 1.4136, 1, 0, 0.077193,-0.0347929) , 
3, 1.36188, 1, 0, 0.248198,0.000997311)    );
  // itree = 2442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263804,-0.0100696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0806366) , 
3, 1.5254, 1, 0, 0.247411,-0.00218562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135266,-0.0208358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,0.0645784) , 
3, 1.59149, 1, 0, 0.153846,-0.0565517) , 
0, 1.2265, 1, 0, 0.233171,-0.0104599)    );
  // itree = 2443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353293,0.0434367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23251,0.00085882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290667,0.00678254) , 
2, 1.15553, 1, 0, 0.244408,0.00456366) , 
2, -1.4149, 1, 0, 0.2535,0.00931153)    );
  // itree = 2444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00900901,-0.0741924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259953,0.00069737) , 
2, -1.56297, 1, 0, 0.239943,-0.00247584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194286,-0.0418393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,-0.00610429) , 
1, 0.247885, 1, 0, 0.253521,-0.0213781) , 
0, 0.759972, 1, 0, 0.243515,-0.00744907)    );
  // itree = 2445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450893,0.00393659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29697,-0.0227556) , 
1, -0.527763, 1, 0, 0.409462,0.0142796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213546,0.0167443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.031427) , 
3, 1.80096, 1, 0, 0.196403,-0.00797279) , 
1, -0.239358, 1, 0, 0.261608,-0.00116266)    );
  // itree = 2446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30763,-0.000943683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25885,0.00425183) , 
0, 0.475581, 1, 0, 0.294537,-3.65776e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0277778,-0.0470123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.00810464) , 
0, 1.04647, 1, 0, 0.0827741,0.0455907) , 
3, 0.970157, 1, 0, 0.250117,0.00953424)    );
  // itree = 2447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255072,0.00573218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277904,-0.0193718) , 
3, 0.660906, 1, 0, 0.260583,0.00856111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0641745) , 
0, 1.55221, 1, 0, 0.251697,0.00462215)    );
  // itree = 2448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178439,-0.00208728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385321,0.0323413) , 
2, -0.121975, 1, 0, 0.271047,0.011586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186401,-0.0255223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313043,0.010565) , 
2, 1.51021, 1, 0, 0.213296,-0.0148248) , 
1, 0.344779, 1, 0, 0.240642,-0.00231913)    );
  // itree = 2449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493377,-0.0216839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259146,-0.00205795) , 
1, -0.426195, 1, 0, 0.371429,0.0167798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252358,0.0109498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141741,-0.00147816) , 
1, 0.197346, 1, 0, 0.177273,-0.0112866) , 
2, -0.472985, 1, 0, 0.24,-0.00221897)    );
  // itree = 2450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21393,-0.010671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,-0.0183288) , 
1, -1.12556, 1, 0, 0.202564,-0.0184712) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37415,0.0144229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247751,0.00967373) , 
0, -0.653242, 1, 0, 0.272248,0.00501534) , 
1, -0.621769, 1, 0, 0.257997,0.000212123)    );
  // itree = 2451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0756949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22542,0.000223454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284416,-0.00519478) , 
0, -0.590943, 1, 0, 0.271104,-0.00970992) , 
0, -1.43949, 1, 0, 0.251002,-0.00595298)    );
  // itree = 2452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219966,0.00673375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546875,-0.0381858) , 
3, 1.60186, 1, 0, 0.241978,0.00110389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0265083) , 
2, 1.82177, 1, 0, 0.256092,0.00322401)    );
  // itree = 2453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402985,-0.0248858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,-0.00721618) , 
3, -1.55664, 1, 0, 0.338583,0.0255827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351381,0.000644031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10289,-0.00959594) , 
1, 0.552515, 1, 0, 0.229943,-0.00372956) , 
0, -1.02158, 1, 0, 0.243577,-5.10399e-05)    );
  // itree = 2454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250765,-0.0118217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143646,-0.00964231) , 
0, -0.118159, 1, 0, 0.212598,-0.0149873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250689,0.00623563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373626,0.014097) , 
2, 1.34931, 1, 0, 0.27533,0.00802745) , 
1, -0.327527, 1, 0, 0.258289,0.00177533)    );
  // itree = 2455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0775819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6,0.000629607) , 
1, 0.660444, 1, 0, 0.161238,-0.0152619) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281609,-0.0137135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449541,0.0391799) , 
1, 1.47069, 1, 0, 0.307103,0.0141069) , 
0, -0.525822, 1, 0, 0.263415,0.00531056)    );
  // itree = 2456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0294118,-0.0397738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272588,0.0135551) , 
2, -1.61801, 1, 0, 0.254972,0.0099208) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254042,-0.0223449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402174,0.0213213) , 
1, 1.16856, 1, 0, 0.298217,-0.00745026) , 
0, 0.6269, 1, 0, 0.268148,0.00462799)    );
  // itree = 2457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359712,-0.0130266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225641,0.00579292) , 
3, -0.730586, 1, 0, 0.275603,0.00949625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670103,0.00286777) , 
2, 1.61382, 1, 0, 0.255949,0.00410025)    );
  // itree = 2458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0771277,-0.033587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289263,-0.006174) , 
2, -0.836229, 1, 0, 0.240148,0.00245341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264151,0.00242808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244681,0.0370503) , 
3, 0.750458, 1, 0, 0.253602,-0.0259378) , 
1, 1.35324, 1, 0, 0.242516,-0.00254494)    );
  // itree = 2459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0921877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261946,0.000392072) , 
1, -1.43509, 1, 0, 0.24688,-0.00189976) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259615,0.0531085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205357,0.00284863) , 
1, 1.30104, 1, 0, 0.231481,-0.0541393) , 
3, 1.65076, 1, 0, 0.245265,-0.00737996)    );
  // itree = 2460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222639,-0.000802331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351852,0.0453251) , 
2, 0.940146, 1, 0, 0.238017,0.00431069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227642,-0.065435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451852,0.00406389) , 
2, 1.78239, 1, 0, 0.344961,-0.0185587) , 
2, 1.42243, 1, 0, 0.251327,0.00146442)    );
  // itree = 2461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498978,0.00322699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377358,0.035621) , 
0, 0.736604, 1, 0, 0.477311,-0.00895056) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280528,-0.0109618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14087,-0.00294185) , 
1, 0.164538, 1, 0, 0.169993,0.00893345) , 
1, -0.33402, 1, 0, 0.259277,0.00373766)    );
  // itree = 2462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319565,0.00425824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0678466,-0.0261268) , 
3, 0.777067, 1, 0, 0.269924,-0.0119674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0933333,-0.0263699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232,0.00782867) , 
0, 1.50819, 1, 0, 0.156364,0.0344342) , 
0, 1.2265, 1, 0, 0.254263,-0.00556797)    );
  // itree = 2463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212416,-0.00490836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403101,-0.000738384) , 
3, 1.5254, 1, 0, 0.226298,0.00637163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.589552,-0.00287974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186207,0.01709) , 
3, 1.08356, 1, 0, 0.379928,-0.032026) , 
0, 1.2265, 1, 0, 0.247196,0.00114836)    );
  // itree = 2464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254413,0.0057741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123119,-0.017802) , 
1, 0.427648, 1, 0, 0.197757,-0.00230084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673203,-0.0127891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552795,0.0393663) , 
1, 1.19487, 1, 0, 0.611465,0.0235692) , 
3, 1.29328, 1, 0, 0.26245,0.00174458)    );
  // itree = 2465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390244,0.00412398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319699,-0.00650734) , 
0, -0.755215, 1, 0, 0.338107,0.000562283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120411,0.010276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0862069,0.0321267) , 
2, 1.8058, 1, 0, 0.115433,-0.0180843) , 
1, 0.767416, 1, 0, 0.251704,-0.00667304)    );
  // itree = 2466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351603,0.0130429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255814,-0.0190251) , 
3, -0.227752, 1, 0, 0.340328,0.00335866) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113636,-0.0175963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196881,0.0130962) , 
0, 0.479025, 1, 0, 0.160616,-0.00730153) , 
3, 0.000826949, 1, 0, 0.258853,-0.00147431)    );
  // itree = 2467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248622,0.00306062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38191,0.0141476) , 
2, 1.30479, 1, 0, 0.2631,0.00829369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132743,0.000658399) , 
2, 1.82177, 1, 0, 0.255527,0.00624969)    );
  // itree = 2468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187879,-0.0242985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118624,0.0124156) , 
1, -0.0673547, 1, 0, 0.149035,-0.00475416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367521,-0.0403818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600806,0.00584866) , 
3, 1.51604, 1, 0, 0.464107,-0.0305782) , 
3, 0.702073, 1, 0, 0.23882,-0.0121131)    );
  // itree = 2469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310102,-0.00762169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115727,0.00436491) , 
3, 0.688091, 1, 0, 0.269517,0.0151572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0488722,-0.00703908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127517,0.01828) , 
0, 1.01965, 1, 0, 0.0771084,-0.0155525) , 
2, 1.07686, 1, 0, 0.230163,0.00887602)    );
  // itree = 2470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265591,-0.00250386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330049,-0.0151561) , 
2, 1.16944, 1, 0, 0.273946,0.00433738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19469,-0.0116539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151079,0.0188043) , 
3, 1.3788, 1, 0, 0.182008,-0.0179436) , 
0, 0.900791, 1, 0, 0.252446,-0.000873147)    );
  // itree = 2471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0590406,-0.00412824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141089,-0.0055391) , 
3, -0.415467, 1, 0, 0.0940803,0.00845312) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424427,-0.00740319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385151,0.0104994) , 
3, 0.751741, 1, 0, 0.40884,-0.011187) , 
1, 0.324332, 1, 0, 0.262303,-0.00204355)    );
  // itree = 2472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290749,0.0178299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280498,-0.00980219) , 
0, -1.05347, 1, 0, 0.282123,-0.00366313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120823,-0.000143913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351515,0.0417202) , 
0, 0.570868, 1, 0, 0.189531,0.0127473) , 
1, 1.15314, 1, 0, 0.256294,0.000914602)    );
  // itree = 2473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520134,0.00703294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250185,0.0124845) , 
1, -0.768694, 1, 0, 0.298851,-0.00414922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0849057,-0.0190887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0617284,0.00410973) , 
3, 1.71414, 1, 0, 0.0708955,0.0249772) , 
3, 1.36188, 1, 0, 0.267048,-8.57683e-05)    );
  // itree = 2474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146341,-0.0281334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296573,0.001695) , 
1, -1.38429, 1, 0, 0.28588,0.00362077) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.03125,-0.00875143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101064,-0.0219145) , 
0, 0.828175, 1, 0, 0.0727848,0.0475086) , 
3, 1.22047, 1, 0, 0.252935,0.0104058)    );
  // itree = 2475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0757658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15243,-0.00158361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556876,0.0105867) , 
1, 1.13826, 1, 0, 0.274782,0.000113918) , 
0, -1.7049, 1, 0, 0.260976,0.00318715)    );
  // itree = 2476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140625,0.0156352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300885,-0.0630778) , 
2, -1.02913, 1, 0, 0.215768,-0.0227642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.0500835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298962,0.0160053) , 
2, -0.794754, 1, 0, 0.261503,0.00815442) , 
1, -0.951508, 1, 0, 0.255873,0.00434881)    );
  // itree = 2477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316208,0.00368814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138462,-0.018818) , 
3, 0.570599, 1, 0, 0.300926,0.00010769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136508,0.0302456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101604,0.00754108) , 
2, 1.20799, 1, 0, 0.123506,-0.0411758) , 
3, 0.795947, 1, 0, 0.256703,-0.0101824)    );
  // itree = 2478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193906,-0.0135964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00970874,-0.0628032) , 
1, 0.952272, 1, 0, 0.153017,0.029249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33758,0.00903768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30897,-0.00302935) , 
2, 1.34238, 1, 0, 0.32965,-0.00673758) , 
2, 0.0236201, 1, 0, 0.248262,0.00984413)    );
  // itree = 2479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259029,-0.0107718) , 
3, -1.99752, 1, 0, 0.24467,0.00300295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115044,-0.0135207) , 
2, 1.82177, 1, 0, 0.237305,-0.000237572)    );
  // itree = 2480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199465,-0.00944733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567961,0.0322871) , 
3, 1.22082, 1, 0, 0.244118,0.000429967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287582,-0.0137385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424528,-0.0399439) , 
0, 1.09591, 1, 0, 0.343629,-0.0325722) , 
2, 1.46214, 1, 0, 0.257274,-0.00393326)    );
  // itree = 2481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611111,-0.00763103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320442,-0.0215297) , 
3, -1.42193, 1, 0, 0.449231,0.0233854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39899,0.0171636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160358,-0.0107625) , 
1, -0.338121, 1, 0, 0.188976,-0.000413992) , 
1, -0.761509, 1, 0, 0.231781,0.00350037)    );
  // itree = 2482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25187,0.00452119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282473,0.000460312) , 
1, -0.484715, 1, 0, 0.275164,0.0102995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164103,0.0104877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145455,0.0301607) , 
3, 1.43856, 1, 0, 0.157377,-0.0328612) , 
0, 1.2265, 1, 0, 0.257056,0.00366441)    );
  // itree = 2483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0760967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155172,0.00105816) , 
0, -0.204124, 1, 0, 0.0602007,-0.0265971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291483,0.00854079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233083,-0.00345507) , 
3, 1.35063, 1, 0, 0.281941,-0.00216952) , 
1, -0.840753, 1, 0, 0.247535,-0.00595979)    );
  // itree = 2484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236364,0.0505429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215331,0.0043444) , 
1, -1.28125, 1, 0, 0.217183,0.00725018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671756,-0.0325965) , 
3, 1.76176, 1, 0, 0.246883,0.00340915)    );
  // itree = 2485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341772,-0.00627742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246753,-0.00198523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0542169,-0.0175882) , 
3, 1.67532, 1, 0, 0.228828,-0.00815368) , 
0, -1.37918, 1, 0, 0.238022,-0.00521274)    );
  // itree = 2486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383142,0.00512882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134752,0.0109948) , 
3, -1.08833, 1, 0, 0.254144,0.0302579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303226,0.0117073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243883,-0.00474918) , 
1, -0.100009, 1, 0, 0.250352,-0.00222523) , 
1, -0.29203, 1, 0, 0.251399,0.00675102)    );
  // itree = 2487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0762088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227848,-0.0125464) , 
1, -0.791106, 1, 0, 0.175097,0.023045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228659,-0.00319224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.363322,-0.00628595) , 
1, 0.242834, 1, 0, 0.31457,-0.00995788) , 
0, 0.0899978, 1, 0, 0.240434,0.00758452)    );
  // itree = 2488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216851,0.00201596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466667,0.0302292) , 
3, 1.24904, 1, 0, 0.238155,0.00547619) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,0.00228752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733945,-0.0294624) , 
3, 1.82798, 1, 0, 0.323529,-0.0129671) , 
2, 1.08337, 1, 0, 0.25565,0.00169675)    );
  // itree = 2489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42735,0.00669806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26002,2.28698e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216471,0.0134892) , 
0, 0.265629, 1, 0, 0.240256,0.00748095) , 
0, -1.58783, 1, 0, 0.251256,0.00449162)    );
  // itree = 2490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272862,0.00408786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111782,-0.00992214) , 
0, 0.813835, 1, 0, 0.24105,-0.00801326) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453125,-0.0065181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221739,0.00724303) , 
3, 0.791652, 1, 0, 0.327014,0.01616) , 
2, 1.0772, 1, 0, 0.258341,-0.00315095)    );
  // itree = 2491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0579268,-0.0467123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297372,0.00521631) , 
1, -0.768694, 1, 0, 0.2531,0.00672684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0320137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256637,0.0389716) , 
1, 1.2453, 1, 0, 0.263374,-0.0738481) , 
3, 1.45397, 1, 0, 0.254338,-0.0029805)    );
  // itree = 2492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20985,0.00683657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236641,-0.0311282) , 
0, -0.192376, 1, 0, 0.222093,-0.00971296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158192,-0.0303373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243299,0.0158637) , 
0, -0.724072, 1, 0, 0.230166,0.00850195) , 
1, 0.162984, 1, 0, 0.226707,0.000696857)    );
  // itree = 2493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608696,0.0288202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23467,0.00515647) , 
1, -1.26208, 1, 0, 0.267097,-0.00529141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24,0.0370357) , 
1, 1.7097, 1, 0, 0.265713,-0.00788711)    );
  // itree = 2494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275754,0.0088034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202864,0.000143992) , 
1, 0.349497, 1, 0, 0.241801,-0.00212283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428571,0.0198292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284672,-0.0170493) , 
0, 0.689132, 1, 0, 0.347107,-0.0226861) , 
2, 1.46433, 1, 0, 0.254287,-0.004561)    );
  // itree = 2495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629213,0.0022419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308487,-0.00968517) , 
1, -0.421021, 1, 0, 0.247778,-0.00265647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204724,0.00865513) , 
0, 1.5208, 1, 0, 0.24494,0.000967072)    );
  // itree = 2496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17203,-0.00278704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559633,0.0439728) , 
3, 0.981401, 1, 0, 0.196522,0.00219611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360465,-0.0418188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738806,-0.000122655) , 
3, 1.81236, 1, 0, 0.526144,-0.0438096) , 
3, 1.27365, 1, 0, 0.246184,-0.00473533)    );
  // itree = 2497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434856,0.00538923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220846,0.0152193) , 
2, -0.39387, 1, 0, 0.301923,-0.00512534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0192592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.00803129) , 
2, 1.51309, 1, 0, 0.0833333,0.0258457) , 
3, 0.953956, 1, 0, 0.255556,0.00144428)    );
  // itree = 2498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292915,-0.000905158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0656028,-0.0165293) , 
3, 0.608207, 1, 0, 0.226591,0.00559802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439024,0.0303078) , 
2, 1.85179, 1, 0, 0.2393,0.00206113)    );
  // itree = 2499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170437,0.00701751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242481,-0.0138313) , 
0, -0.364974, 1, 0, 0.214823,0.0113153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52,0.0345273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22549,-0.0168486) , 
1, 0.708763, 1, 0, 0.400794,-0.0436489) , 
0, 1.28629, 1, 0, 0.238504,0.00431634)    );
  // itree = 2500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18536,0.0128537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298897,-0.0127994) , 
2, -0.00474452, 1, 0, 0.246746,-0.00203841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385185,0.0298222) , 
0, 1.49754, 1, 0, 0.25619,0.00112804)    );
  // itree = 2501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306676,-0.000826482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113082,0.0207059) , 
3, 0.771965, 1, 0, 0.260455,-0.00783781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113208,-0.0304142) , 
1, 1.68939, 1, 0, 0.252632,-0.00514356)    );
  // itree = 2502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182805,-0.00455005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369565,-0.00255121) , 
2, 0.390638, 1, 0, 0.251059,-0.00403658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0258065,-0.0687576) , 
3, 1.74551, 1, 0, 0.23397,0.000299282)    );
  // itree = 2503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227961,-0.00510077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317614,-0.00226061) , 
3, 0.158612, 1, 0, 0.263015,0.00255188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0225564,-0.0458214) , 
1, 1.65151, 1, 0, 0.246839,5.20718e-05)    );
  // itree = 2504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216931,0.00625021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12,-0.0300374) , 
0, -0.515917, 1, 0, 0.158114,-0.00922148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486275,0.0372076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557769,-0.0219495) , 
3, 1.40317, 1, 0, 0.521739,0.00752178) , 
3, 0.795947, 1, 0, 0.252567,-0.00487236)    );
  // itree = 2505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473296,0.00732582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155251,-0.0126508) , 
1, -0.280273, 1, 0, 0.24825,0.00581871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255102,0.0367964) , 
0, 1.55221, 1, 0, 0.248593,0.00147538)    );
  // itree = 2506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267428,0.000409426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192982,0.0100335) , 
0, 1.10386, 1, 0, 0.262655,0.00216746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0582524,-0.0284014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,0.0140209) , 
2, 0.934932, 1, 0, 0.188341,-0.0281933) , 
0, 1.32631, 1, 0, 0.254373,-0.00121607)    );
  // itree = 2507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123096,-0.0187652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344875,0.0269897) , 
0, -0.204299, 1, 0, 0.229139,-0.00189704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336898,-0.0168479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101911,-0.0331111) , 
2, 1.50435, 1, 0, 0.26742,0.021397) , 
3, 0.702073, 1, 0, 0.239098,0.00416328)    );
  // itree = 2508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0877193,-0.00141874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355769,-0.0623569) , 
3, -1.00565, 1, 0, 0.189091,-0.0350646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284127,0.0187634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190588,-0.0129864) , 
1, 1.28138, 1, 0, 0.260534,0.00950652) , 
1, -0.887572, 1, 0, 0.25051,0.00325291)    );
  // itree = 2509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404,0.0049246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990991,-0.0358922) , 
3, 0.307037, 1, 0, 0.327832,0.0161077) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124424,0.0158001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0331492,-0.0415874) , 
2, 1.56116, 1, 0, 0.097561,-0.0204059) , 
2, 0.685365, 1, 0, 0.255133,0.00458007)    );
  // itree = 2510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155,0.00215243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27653,-0.00109189) , 
2, -0.546381, 1, 0, 0.237969,0.00539536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349693,0.00286933) , 
2, 1.68765, 1, 0, 0.246835,0.00295572)    );
  // itree = 2511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19256,-0.00190885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550296,0.0193061) , 
0, 0.794662, 1, 0, 0.263312,-0.00638437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34507,-0.022212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.056,-0.0220918) , 
3, 1.83405, 1, 0, 0.209738,0.0305792) , 
3, 1.36188, 1, 0, 0.256073,-0.0013898)    );
  // itree = 2512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196262,-0.00749009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266129,-0.0682168) , 
1, -1.13439, 1, 0, 0.221893,-0.0306328) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223835,-0.00189189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390909,-0.0334706) , 
0, 1.55221, 1, 0, 0.23426,-0.00460278) , 
1, -0.828867, 1, 0, 0.23227,-0.00879038)    );
  // itree = 2513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292879,0.000540948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0987654,-0.0201657) , 
3, 0.995935, 1, 0, 0.267492,-0.000287719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0684211,0.0156719) , 
3, 1.61197, 1, 0, 0.249023,-0.00540629)    );
  // itree = 2514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243312,-0.00387607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00340136,-0.0730834) , 
3, 0.055345, 1, 0, 0.177943,0.00397108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406206,0.0119303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0697674,-0.012491) , 
3, 1.60975, 1, 0, 0.340522,-0.0173248) , 
2, 0.30194, 1, 0, 0.25102,-0.0056012)    );
  // itree = 2515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015873,-0.0179806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308504,0.0019976) , 
1, -1.14796, 1, 0, 0.279303,-0.000478954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0199158) , 
1, 1.65151, 1, 0, 0.264532,-0.0046936)    );
  // itree = 2516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.089372,0.00124752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498861,0.0312685) , 
3, -0.718672, 1, 0, 0.300117,0.0192332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164454,-0.00634205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721854,0.0175711) , 
3, 1.73696, 1, 0, 0.238938,-3.52983e-05) , 
1, 0.227361, 1, 0, 0.265255,0.00825318)    );
  // itree = 2517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.728682,0.0224496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293636,-0.00510691) , 
1, -1.45472, 1, 0, 0.3393,0.00894884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.0139452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171381,0.0242219) , 
0, -0.394689, 1, 0, 0.150917,-0.0167715) , 
3, 0.331768, 1, 0, 0.270382,-0.000460723)    );
  // itree = 2518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383333,0.00722387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154976,-0.00672169) , 
3, -0.44585, 1, 0, 0.267931,0.00156652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210744,-0.00534641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243243,0.0173296) , 
3, -0.17895, 1, 0, 0.233375,-0.023634) , 
1, 0.75851, 1, 0, 0.254229,-0.00842592)    );
  // itree = 2519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238759,-0.00300579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381579,0.021914) , 
2, 1.0387, 1, 0, 0.261816,-0.0038836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189944,-0.0293184) , 
3, 1.61709, 1, 0, 0.255577,0.00066028)    );
  // itree = 2520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173522,0.00260903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325203,-0.041243) , 
3, 0.990137, 1, 0, 0.184634,-0.00269132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421801,0.00703774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862385,0.0305959) , 
3, 1.87477, 1, 0, 0.571875,0.0264025) , 
3, 1.28501, 1, 0, 0.246623,0.00196602)    );
  // itree = 2521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436963,0.0121206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213043,-0.0436365) , 
0, 0.173689, 1, 0, 0.381466,-0.00173562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180328,-0.0234205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157303,0.00779185) , 
2, 0.100837, 1, 0, 0.164208,0.0240312) , 
3, -0.127334, 1, 0, 0.267866,0.0117373)    );
  // itree = 2522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364583,0.00392792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18171,-0.00817625) , 
3, -0.449219, 1, 0, 0.268944,-0.00620073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178571,-0.0219071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00593103) , 
3, 1.09085, 1, 0, 0.162228,0.025606) , 
0, 0.956597, 1, 0, 0.247158,0.000292676)    );
  // itree = 2523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170772,0.00277822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239389,0.00797889) , 
0, -0.425772, 1, 0, 0.204508,0.00561581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558659,-0.00582789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26015,0.00146722) , 
2, -0.351924, 1, 0, 0.32346,-0.0092513) , 
0, 0.30526, 1, 0, 0.253673,-0.000529067)    );
  // itree = 2524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149329,0.000776564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491429,-0.0153725) , 
3, 0.441796, 1, 0, 0.253931,-0.00596154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0360825,-0.0257515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534884,0.0344882) , 
3, 1.07875, 1, 0, 0.235294,0.0191748) , 
1, 1.41142, 1, 0, 0.25098,-0.00198162)    );
  // itree = 2525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446875,0.0177423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123894,0.0084345) , 
3, -0.670623, 1, 0, 0.362587,-0.0214678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299089,0.0102126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776119,-0.00184264) , 
2, 1.08778, 1, 0, 0.250973,-0.000621566) , 
0, -0.727763, 1, 0, 0.275443,-0.00519191)    );
  // itree = 2526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409302,-0.00745013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1875,-0.0199544) , 
3, -0.999797, 1, 0, 0.320334,-0.021448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0899358,-0.00591933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287986,0.00322547) , 
2, -0.317391, 1, 0, 0.230144,0.00761518) , 
0, -0.805343, 1, 0, 0.24668,0.00228644)    );
  // itree = 2527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193788,0.00142493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410377,-0.0284885) , 
0, 1.26376, 1, 0, 0.22091,-0.00898172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470238,0.0148615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209524,0.0549608) , 
3, 1.37466, 1, 0, 0.369963,-0.0379998) , 
1, 1.4386, 1, 0, 0.241607,-0.0130112)    );
  // itree = 2528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296399,0.0468862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23115,0.00459438) , 
1, -0.469111, 1, 0, 0.251282,0.0150181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137405,-0.0733917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251095,-0.0213682) , 
1, -0.522402, 1, 0, 0.232843,-0.0316454) , 
0, 0.297203, 1, 0, 0.243706,-0.00415483)    );
  // itree = 2529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463964,0.011177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189787,-0.00110675) , 
1, -0.219298, 1, 0, 0.282103,-0.000495206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101449,0.0339861) , 
3, 1.74459, 1, 0, 0.270321,-0.00522805)    );
  // itree = 2530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469027,0.0294484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230375,-0.00117431) , 
3, -1.24415, 1, 0, 0.283918,0.0111248) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12987,0.0108634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207824,0.00121532) , 
1, 0.00448539, 1, 0, 0.186501,-0.0171191) , 
0, 0.759972, 1, 0, 0.257473,0.00345784)    );
  // itree = 2531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326923,0.0298082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227774,-0.00648353) , 
2, -1.02824, 1, 0, 0.244468,0.0103055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0393701,-0.0379072) , 
1, 1.65151, 1, 0, 0.231313,0.00598587)    );
  // itree = 2532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163934,-0.0292303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219653,0.0250483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238754,-0.00590486) , 
1, -1.07868, 1, 0, 0.237022,-0.00292881) , 
0, -1.43147, 1, 0, 0.232627,-0.00457013)    );
  // itree = 2533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290485,-0.00226073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0855019,-0.0128953) , 
1, 1.37047, 1, 0, 0.260776,-0.00150652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0394737,-0.0232675) , 
3, 1.73078, 1, 0, 0.244024,0.00246173)    );
  // itree = 2534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291714,0.00236471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990099,-0.00739052) , 
3, 1.39842, 1, 0, 0.281267,0.00338456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,0.00836743) , 
3, 1.71106, 1, 0, 0.267662,-0.00354374)    );
  // itree = 2535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169753,-0.00594354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382716,0.0118681) , 
3, 0.164912, 1, 0, 0.232389,0.00799512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323944,0.0124741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16129,0.0262388) , 
3, 1.25551, 1, 0, 0.269051,-0.0199374) , 
2, 0.686256, 1, 0, 0.244059,-0.000896275)    );
  // itree = 2536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0973154,-0.018247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256757,0.0249562) , 
2, -1.09505, 1, 0, 0.221139,0.0136644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229358,-0.107759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321755,0.00400563) , 
1, 0.172741, 1, 0, 0.306402,-0.0088831) , 
2, 0.648293, 1, 0, 0.249246,0.00623168)    );
  // itree = 2537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327229,0.00048405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162791,0.00660224) , 
2, 0.482706, 1, 0, 0.311913,0.0071409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108173,0.00574477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0759494,-0.00894298) , 
1, 1.35302, 1, 0, 0.0964778,-0.0145579) , 
2, 0.689402, 1, 0, 0.242885,0.000188331)    );
  // itree = 2538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298285,0.000518201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254967,-0.00282528) , 
1, 1.27905, 1, 0, 0.290323,-0.00899836) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0815855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107692,-0.00745001) , 
2, 0.65241, 1, 0, 0.0687961,0.0318977) , 
3, 1.07342, 1, 0, 0.246341,-0.000878994)    );
  // itree = 2539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225352,0.0106292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251269,-0.023961) , 
2, 0.810561, 1, 0, 0.231459,0.00389403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522727,0.0153846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211538,0.0262377) , 
3, 1.21889, 1, 0, 0.407143,-0.0466645) , 
1, 1.4386, 1, 0, 0.25666,-0.00335822)    );
  // itree = 2540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151899,0.0912537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205526,-0.00266813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512545,-0.0198963) , 
3, 1.2224, 1, 0, 0.254112,-0.00697216) , 
2, -1.4149, 1, 0, 0.245705,-0.00172925)    );
  // itre