// Class: ReadMLP
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : MLP::MLP
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 03:55:52 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 4000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
NCycles: "1000" [Number of training cycles]
HiddenLayers: "N+5,5" [Specification of hidden layer architecture]
NeuronType: "tanh" [Neuron activation function type]
EstimatorType: "MSE" [MSE (Mean Square Estimator) for Gaussian Likelihood or CE(Cross-Entropy) for Bernoulli Likelihood]
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
TestRate: "5" [Test for overtraining performed at each #th epochs]
# Default:
RandomSeed: "1" [Random seed for initial synapse weights (0 means unique seed for each run; default value '1')]
NeuronInputType: "sum" [Neuron input function type]
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
TrainingMethod: "BP" [Train with Back-Propagation (BP), BFGS Algorithm (BFGS), or Genetic Algorithm (GA - slower and worse)]
LearningRate: "2.000000e-02" [ANN learning rate parameter]
DecayRate: "1.000000e-02" [Decay rate for learning parameter]
EpochMonitoring: "False" [Provide epoch-wise monitoring plots according to TestRate (caution: causes big ROOT output file!)]
Sampling: "1.000000e+00" [Only 'Sampling' (randomly selected) events are trained each epoch]
SamplingEpoch: "1.000000e+00" [Sampling is used for the first 'SamplingEpoch' epochs, afterwards, all events are taken for training]
SamplingImportance: "1.000000e+00" [ The sampling weights of events in epochs which successful (worse estimator than before) are multiplied with SamplingImportance, else they are divided.]
SamplingTraining: "True" [The training sample is sampled]
SamplingTesting: "False" [The testing sample is sampled]
ResetStep: "50" [How often BFGS should reset history]
Tau: "3.000000e+00" [LineSearch "size step"]
BPMode: "sequential" [Back-propagation learning mode: sequential or batch]
BatchSize: "-1" [Batch size: number of events/batch, only set if in Batch Mode, -1 for BatchSize=number_of_events]
ConvergenceImprove: "1.000000e-30" [Minimum improvement which counts as improvement (<0 means automatic convergence check is turned off)]
ConvergenceTests: "-1" [Number of steps (without improvement) required for convergence (<0 means automatic convergence check is turned off)]
UseRegulator: "False" [Use regulator to avoid over-training]
UpdateLimit: "10000" [Maximum times of regulator update]
CalculateErrors: "False" [Calculates inverse Hessian matrix at the end of the training to be able to calculate the uncertainties of an MVA value]
WeightRange: "1.000000e+00" [Take the events for the estimator calculations from small deviations from the desired value to large deviations only over the weight range]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-3.65916013718,3.26447582245]
var2                          var2                          var2                          Variable 2                                                      'F'    [-3.68905711174,3.78774046898]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-4.57268333435,4.56402540207]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-4.84856987,5.04116535187]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadMLP : public IClassifierReader {

 public:

   // constructor
   ReadMLP( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadMLP" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadMLP() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   std::vector<double> GetMulticlassValues__( const std::vector<double>& inputValues ) const;

   // private members (method specific)

   double ActivationFnc(double x) const;
   double OutputActivationFnc(double x) const;

   double fWeightMatrix0to1[10][5];   // weight matrix from layer 0 to 1
   double fWeightMatrix1to2[6][10];   // weight matrix from layer 1 to 2
   double fWeightMatrix2to3[4][6];   // weight matrix from layer 2 to 3

};

inline void ReadMLP::Initialize()
{
   // build network structure
   // weight matrix from layer 0 to 1
   fWeightMatrix0to1[0][0] = -1.06651200319108;
   fWeightMatrix0to1[1][0] = 2.78386988043118;
   fWeightMatrix0to1[2][0] = 0.101393252285154;
   fWeightMatrix0to1[3][0] = 0.206941798604133;
   fWeightMatrix0to1[4][0] = -1.78286501698958;
   fWeightMatrix0to1[5][0] = -0.860777618534828;
   fWeightMatrix0to1[6][0] = -0.808727112289036;
   fWeightMatrix0to1[7][0] = 2.47804262221377;
   fWeightMatrix0to1[8][0] = -1.13551735547915;
   fWeightMatrix0to1[0][1] = 3.71378925654866;
   fWeightMatrix0to1[1][1] = 1.69096355947333;
   fWeightMatrix0to1[2][1] = 0.237366503241686;
   fWeightMatrix0to1[3][1] = -0.73602253713693;
   fWeightMatrix0to1[4][1] = -1.4854832241276;
   fWeightMatrix0to1[5][1] = -0.965663960944631;
   fWeightMatrix0to1[6][1] = 1.27201233522517;
   fWeightMatrix0to1[7][1] = -0.0651979297580546;
   fWeightMatrix0to1[8][1] = 4.60539585604408;
   fWeightMatrix0to1[0][2] = 0.142204729367398;
   fWeightMatrix0to1[1][2] = 0.977147297405069;
   fWeightMatrix0to1[2][2] = -1.22212905685236;
   fWeightMatrix0to1[3][2] = -0.123352194790325;
   fWeightMatrix0to1[4][2] = -2.02701841995523;
   fWeightMatrix0to1[5][2] = -0.00825727752816287;
   fWeightMatrix0to1[6][2] = -2.80282340746091;
   fWeightMatrix0to1[7][2] = -0.0256599583030388;
   fWeightMatrix0to1[8][2] = -0.202155755792556;
   fWeightMatrix0to1[0][3] = -0.442817815050983;
   fWeightMatrix0to1[1][3] = -4.4536829927998;
   fWeightMatrix0to1[2][3] = 0.231276547713158;
   fWeightMatrix0to1[3][3] = 2.18864663038851;
   fWeightMatrix0to1[4][3] = 4.08552885807348;
   fWeightMatrix0to1[5][3] = 1.70260974665176;
   fWeightMatrix0to1[6][3] = 1.55486472026845;
   fWeightMatrix0to1[7][3] = 0.365736245687583;
   fWeightMatrix0to1[8][3] = 0.508488311462387;
   fWeightMatrix0to1[0][4] = -6.88388268719374;
   fWeightMatrix0to1[1][4] = 1.09728226906791;
   fWeightMatrix0to1[2][4] = -1.03660907192257;
   fWeightMatrix0to1[3][4] = 0.628591791670253;
   fWeightMatrix0to1[4][4] = 1.6733138429079;
   fWeightMatrix0to1[5][4] = 2.88267349959512;
   fWeightMatrix0to1[6][4] = 3.78423644920161;
   fWeightMatrix0to1[7][4] = -1.88203499450257;
   fWeightMatrix0to1[8][4] = -5.36735871461378;
   // weight matrix from layer 1 to 2
   fWeightMatrix1to2[0][0] = -0.357235796862591;
   fWeightMatrix1to2[1][0] = 0.04505062489752;
   fWeightMatrix1to2[2][0] = 0.340588167356101;
   fWeightMatrix1to2[3][0] = 3.9929498015394;
   fWeightMatrix1to2[4][0] = 0.145228923116718;
   fWeightMatrix1to2[0][1] = 2.79393964714356;
   fWeightMatrix1to2[1][1] = 0.215732000789057;
   fWeightMatrix1to2[2][1] = 0.23033176153333;
   fWeightMatrix1to2[3][1] = 0.185230972693792;
   fWeightMatrix1to2[4][1] = -2.09502080886405;
   fWeightMatrix1to2[0][2] = -0.0189434307875217;
   fWeightMatrix1to2[1][2] = -1.03322674362896;
   fWeightMatrix1to2[2][2] = -1.07708655007349;
   fWeightMatrix1to2[3][2] = 0.0851539991212902;
   fWeightMatrix1to2[4][2] = 0.149434494803098;
   fWeightMatrix1to2[0][3] = -0.271010033517566;
   fWeightMatrix1to2[1][3] = -1.55390366610449;
   fWeightMatrix1to2[2][3] = -0.0669792697717976;
   fWeightMatrix1to2[3][3] = -0.282630749551357;
   fWeightMatrix1to2[4][3] = 0.343249727100533;
   fWeightMatrix1to2[0][4] = 2.70532126867034;
   fWeightMatrix1to2[1][4] = 0.272681859582698;
   fWeightMatrix1to2[2][4] = 0.040338893188297;
   fWeightMatrix1to2[3][4] = 0.529662776529901;
   fWeightMatrix1to2[4][4] = 0.584154232222749;
   fWeightMatrix1to2[0][5] = 0.669218600470071;
   fWeightMatrix1to2[1][5] = -1.2688687650503;
   fWeightMatrix1to2[2][5] = -0.803695836169736;
   fWeightMatrix1to2[3][5] = 2.21566550678552;
   fWeightMatrix1to2[4][5] = 1.35717620272584;
   fWeightMatrix1to2[0][6] = 0.209308698854902;
   fWeightMatrix1to2[1][6] = -0.731317432299243;
   fWeightMatrix1to2[2][6] = -0.506532607488316;
   fWeightMatrix1to2[3][6] = 1.70474804097025;
   fWeightMatrix1to2[4][6] = 2.0272958402778;
   fWeightMatrix1to2[0][7] = 0.134850207060653;
   fWeightMatrix1to2[1][7] = 0.807221505342792;
   fWeightMatrix1to2[2][7] = 0.541274616894995;
   fWeightMatrix1to2[3][7] = -3.11772539853194;
   fWeightMatrix1to2[4][7] = -0.106183680509714;
   fWeightMatrix1to2[0][8] = 0.0189265853772227;
   fWeightMatrix1to2[1][8] = -0.167053790176189;
   fWeightMatrix1to2[2][8] = 0.217742419049963;
   fWeightMatrix1to2[3][8] = -3.75105316235857;
   fWeightMatrix1to2[4][8] = -0.0393298810581988;
   fWeightMatrix1to2[0][9] = -1.45552886865421;
   fWeightMatrix1to2[1][9] = -0.29335486135367;
   fWeightMatrix1to2[2][9] = 1.11555186966183;
   fWeightMatrix1to2[3][9] = -2.40365415835108;
   fWeightMatrix1to2[4][9] = -1.70261245590261;
   // weight matrix from layer 2 to 3
   fWeightMatrix2to3[0][0] = -1.4794134225943;
   fWeightMatrix2to3[1][0] = 1.11172320132498;
   fWeightMatrix2to3[2][0] = -1.05853789432097;
   fWeightMatrix2to3[3][0] = -0.811113655311863;
   fWeightMatrix2to3[0][1] = -1.57415343464894;
   fWeightMatrix2to3[1][1] = -2.00617289268192;
   fWeightMatrix2to3[2][1] = -1.73396745628971;
   fWeightMatrix2to3[3][1] = 2.54079329268742;
   fWeightMatrix2to3[0][2] = 1.26121184490424;
   fWeightMatrix2to3[1][2] = 0.520765319749485;
   fWeightMatrix2to3[2][2] = 2.33123364578584;
   fWeightMatrix2to3[3][2] = -2.89527287902075;
   fWeightMatrix2to3[0][3] = 0.66272014779784;
   fWeightMatrix2to3[1][3] = 0.564421555704318;
   fWeightMatrix2to3[2][3] = 1.16864581662824;
   fWeightMatrix2to3[3][3] = -4.68276776259688;
   fWeightMatrix2to3[0][4] = 3.13744173280683;
   fWeightMatrix2to3[1][4] = -0.428900582056675;
   fWeightMatrix2to3[2][4] = -2.79045078130764;
   fWeightMatrix2to3[3][4] = -0.315304266179115;
   fWeightMatrix2to3[0][5] = 0.0539164770048504;
   fWeightMatrix2to3[1][5] = -0.194351274022359;
   fWeightMatrix2to3[2][5] = -0.470818380105623;
   fWeightMatrix2to3[3][5] = 2.63756733325277;
}

inline double ReadMLP::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   if (inputValues.size() != (unsigned int)4) {
      std::cout << "Input vector needs to be of size " << 4 << std::endl;
      return 0;
   }

   std::array<double, 10> fWeights1 {{}};
   std::array<double, 6> fWeights2 {{}};
   std::array<double, 4> fWeights3 {{}};
   fWeights1.back() = 1.;
   fWeights2.back() = 1.;

   // layer 0 to 1
   for (int o=0; o<9; o++) {
      std::array<double, 5> buffer; // no need to initialise
      for (int i = 0; i<5 - 1; i++) {
         buffer[i] = fWeightMatrix0to1[o][i] * inputValues[i];
      } // loop over i
      buffer.back() = fWeightMatrix0to1[o][4];
      for (int i=0; i<5; i++) {
         fWeights1[o] += buffer[i];
      } // loop over i
    } // loop over o
   for (int o=0; o<9; o++) {
      fWeights1[o] = ActivationFnc(fWeights1[o]);
   } // loop over o
   // layer 1 to 2
   for (int o=0; o<5; o++) {
      std::array<double, 10> buffer; // no need to initialise
      for (int i=0; i<10; i++) {
         buffer[i] = fWeightMatrix1to2[o][i] * fWeights1[i];
      } // loop over i
      for (int i=0; i<10; i++) {
         fWeights2[o] += buffer[i];
      } // loop over i
    } // loop over o
   for (int o=0; o<5; o++) {
      fWeights2[o] = ActivationFnc(fWeights2[o]);
   } // loop over o
   // layer 2 to 3
   for (int o=0; o<4; o++) {
      std::array<double, 6> buffer; // no need to initialise
      for (int i=0; i<6; i++) {
         buffer[i] = fWeightMatrix2to3[o][i] * fWeights2[i];
      } // loop over i
      for (int i=0; i<6; i++) {
         fWeights3[o] += buffer[i];
      } // loop over i
    } // loop over o
   for (int o=0; o<4; o++) {
      fWeights3[o] = OutputActivationFnc(fWeights3[o]);
   } // loop over o

   return fWeights3[0];
}

double ReadMLP::ActivationFnc(double x) const {
   // hyperbolic tan
   return tanh(x);
}
double ReadMLP::OutputActivationFnc(double x) const {
   // identity
   return x;
}

// Clean up
inline void ReadMLP::Clear()
{
}
inline std::vector<double> ReadMLP::GetMulticlassValues( const std::vector<double>& inputValues ) const
{
   // classifier response value
   std::vector<double> retval;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMulticlassValues__( inputValues );
   }

   return retval;
}
