// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:11:48 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 1600
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
NTrees: "400" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "16" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 256
vars                          vars[0]                       vars                          [0]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[1]                       vars                          [1]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[2]                       vars                          [2]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[3]                       vars                          [3]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[4]                       vars                          [4]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[5]                       vars                          [5]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[6]                       vars                          [6]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[7]                       vars                          [7]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[8]                       vars                          [8]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[9]                       vars                          [9]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[10]                      vars                          [10]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[11]                      vars                          [11]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[12]                      vars                          [12]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[13]                      vars                          [13]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[14]                      vars                          [14]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[15]                      vars                          [15]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[16]                      vars                          [16]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[17]                      vars                          [17]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[18]                      vars                          [18]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[19]                      vars                          [19]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[20]                      vars                          [20]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[21]                      vars                          [21]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[22]                      vars                          [22]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[23]                      vars                          [23]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[24]                      vars                          [24]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[25]                      vars                          [25]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[26]                      vars                          [26]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[27]                      vars                          [27]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[28]                      vars                          [28]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[29]                      vars                          [29]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[30]                      vars                          [30]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[31]                      vars                          [31]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[32]                      vars                          [32]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[33]                      vars                          [33]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[34]                      vars                          [34]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[35]                      vars                          [35]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[36]                      vars                          [36]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[37]                      vars                          [37]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[38]                      vars                          [38]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[39]                      vars                          [39]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[40]                      vars                          [40]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[41]                      vars                          [41]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[42]                      vars                          [42]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[43]                      vars                          [43]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[44]                      vars                          [44]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[45]                      vars                          [45]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[46]                      vars                          [46]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[47]                      vars                          [47]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[48]                      vars                          [48]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[49]                      vars                          [49]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[50]                      vars                          [50]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[51]                      vars                          [51]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[52]                      vars                          [52]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[53]                      vars                          [53]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[54]                      vars                          [54]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[55]                      vars                          [55]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[56]                      vars                          [56]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[57]                      vars                          [57]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[58]                      vars                          [58]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[59]                      vars                          [59]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[60]                      vars                          [60]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[61]                      vars                          [61]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[62]                      vars                          [62]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[63]                      vars                          [63]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[64]                      vars                          [64]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[65]                      vars                          [65]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[66]                      vars                          [66]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[67]                      vars                          [67]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[68]                      vars                          [68]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[69]                      vars                          [69]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[70]                      vars                          [70]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[71]                      vars                          [71]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[72]                      vars                          [72]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[73]                      vars                          [73]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[74]                      vars                          [74]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[75]                      vars                          [75]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[76]                      vars                          [76]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[77]                      vars                          [77]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[78]                      vars                          [78]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[79]                      vars                          [79]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[80]                      vars                          [80]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[81]                      vars                          [81]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[82]                      vars                          [82]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[83]                      vars                          [83]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[84]                      vars                          [84]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[85]                      vars                          [85]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[86]                      vars                          [86]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[87]                      vars                          [87]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[88]                      vars                          [88]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[89]                      vars                          [89]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[90]                      vars                          [90]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[91]                      vars                          [91]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[92]                      vars                          [92]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[93]                      vars                          [93]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[94]                      vars                          [94]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[95]                      vars                          [95]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[96]                      vars                          [96]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[97]                      vars                          [97]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[98]                      vars                          [98]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[99]                      vars                          [99]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[100]                     vars                          [100]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[101]                     vars                          [101]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[102]                     vars                          [102]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[103]                     vars                          [103]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[104]                     vars                          [104]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[105]                     vars                          [105]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[106]                     vars                          [106]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[107]                     vars                          [107]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[108]                     vars                          [108]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[109]                     vars                          [109]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[110]                     vars                          [110]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[111]                     vars                          [111]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[112]                     vars                          [112]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[113]                     vars                          [113]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[114]                     vars                          [114]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[115]                     vars                          [115]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[116]                     vars                          [116]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[117]                     vars                          [117]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[118]                     vars                          [118]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[119]                     vars                          [119]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[120]                     vars                          [120]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[121]                     vars                          [121]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[122]                     vars                          [122]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[123]                     vars                          [123]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[124]                     vars                          [124]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[125]                     vars                          [125]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[126]                     vars                          [126]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[127]                     vars                          [127]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[128]                     vars                          [128]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[129]                     vars                          [129]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[130]                     vars                          [130]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[131]                     vars                          [131]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[132]                     vars                          [132]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[133]                     vars                          [133]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[134]                     vars                          [134]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[135]                     vars                          [135]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[136]                     vars                          [136]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[137]                     vars                          [137]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[138]                     vars                          [138]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[139]                     vars                          [139]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[140]                     vars                          [140]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[141]                     vars                          [141]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[142]                     vars                          [142]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[143]                     vars                          [143]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[144]                     vars                          [144]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[145]                     vars                          [145]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[146]                     vars                          [146]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[147]                     vars                          [147]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[148]                     vars                          [148]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[149]                     vars                          [149]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[150]                     vars                          [150]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[151]                     vars                          [151]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[152]                     vars                          [152]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[153]                     vars                          [153]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[154]                     vars                          [154]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[155]                     vars                          [155]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[156]                     vars                          [156]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[157]                     vars                          [157]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[158]                     vars                          [158]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[159]                     vars                          [159]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[160]                     vars                          [160]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[161]                     vars                          [161]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[162]                     vars                          [162]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[163]                     vars                          [163]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[164]                     vars                          [164]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[165]                     vars                          [165]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[166]                     vars                          [166]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[167]                     vars                          [167]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[168]                     vars                          [168]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[169]                     vars                          [169]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[170]                     vars                          [170]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[171]                     vars                          [171]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[172]                     vars                          [172]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[173]                     vars                          [173]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[174]                     vars                          [174]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[175]                     vars                          [175]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[176]                     vars                          [176]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[177]                     vars                          [177]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[178]                     vars                          [178]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[179]                     vars                          [179]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[180]                     vars                          [180]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[181]                     vars                          [181]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[182]                     vars                          [182]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[183]                     vars                          [183]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[184]                     vars                          [184]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[185]                     vars                          [185]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[186]                     vars                          [186]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[187]                     vars                          [187]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[188]                     vars                          [188]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[189]                     vars                          [189]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[190]                     vars                          [190]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[191]                     vars                          [191]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[192]                     vars                          [192]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[193]                     vars                          [193]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[194]                     vars                          [194]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[195]                     vars                          [195]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[196]                     vars                          [196]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[197]                     vars                          [197]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[198]                     vars                          [198]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[199]                     vars                          [199]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[200]                     vars                          [200]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[201]                     vars                          [201]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[202]                     vars                          [202]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[203]                     vars                          [203]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[204]                     vars                          [204]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[205]                     vars                          [205]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[206]                     vars                          [206]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[207]                     vars                          [207]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[208]                     vars                          [208]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[209]                     vars                          [209]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[210]                     vars                          [210]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[211]                     vars                          [211]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[212]                     vars                          [212]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[213]                     vars                          [213]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[214]                     vars                          [214]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[215]                     vars                          [215]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[216]                     vars                          [216]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[217]                     vars                          [217]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[218]                     vars                          [218]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[219]                     vars                          [219]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[220]                     vars                          [220]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[221]                     vars                          [221]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[222]                     vars                          [222]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[223]                     vars                          [223]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[224]                     vars                          [224]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[225]                     vars                          [225]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[226]                     vars                          [226]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[227]                     vars                          [227]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[228]                     vars                          [228]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[229]                     vars                          [229]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[230]                     vars                          [230]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[231]                     vars                          [231]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[232]                     vars                          [232]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[233]                     vars                          [233]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[234]                     vars                          [234]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[235]                     vars                          [235]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[236]                     vars                          [236]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[237]                     vars                          [237]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[238]                     vars                          [238]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[239]                     vars                          [239]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[240]                     vars                          [240]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[241]                     vars                          [241]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[242]                     vars                          [242]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[243]                     vars                          [243]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[244]                     vars                          [244]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[245]                     vars                          [245]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[246]                     vars                          [246]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[247]                     vars                          [247]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[248]                     vars                          [248]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[249]                     vars                          [249]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[250]                     vars                          [250]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[251]                     vars                          [251]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[252]                     vars                          [252]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[253]                     vars                          [253]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[254]                     vars                          [254]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[255]                     vars                          [255]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 256 )
   {
      // the training input variables
      const char* inputVars[] = { "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;
      fVmin[4] = 0;
      fVmax[4] = 0;
      fVmin[5] = 0;
      fVmax[5] = 0;
      fVmin[6] = 0;
      fVmax[6] = 0;
      fVmin[7] = 0;
      fVmax[7] = 0;
      fVmin[8] = 0;
      fVmax[8] = 0;
      fVmin[9] = 0;
      fVmax[9] = 0;
      fVmin[10] = 0;
      fVmax[10] = 0;
      fVmin[11] = 0;
      fVmax[11] = 0;
      fVmin[12] = 0;
      fVmax[12] = 0;
      fVmin[13] = 0;
      fVmax[13] = 0;
      fVmin[14] = 0;
      fVmax[14] = 0;
      fVmin[15] = 0;
      fVmax[15] = 0;
      fVmin[16] = 0;
      fVmax[16] = 0;
      fVmin[17] = 0;
      fVmax[17] = 0;
      fVmin[18] = 0;
      fVmax[18] = 0;
      fVmin[19] = 0;
      fVmax[19] = 0;
      fVmin[20] = 0;
      fVmax[20] = 0;
      fVmin[21] = 0;
      fVmax[21] = 0;
      fVmin[22] = 0;
      fVmax[22] = 0;
      fVmin[23] = 0;
      fVmax[23] = 0;
      fVmin[24] = 0;
      fVmax[24] = 0;
      fVmin[25] = 0;
      fVmax[25] = 0;
      fVmin[26] = 0;
      fVmax[26] = 0;
      fVmin[27] = 0;
      fVmax[27] = 0;
      fVmin[28] = 0;
      fVmax[28] = 0;
      fVmin[29] = 0;
      fVmax[29] = 0;
      fVmin[30] = 0;
      fVmax[30] = 0;
      fVmin[31] = 0;
      fVmax[31] = 0;
      fVmin[32] = 0;
      fVmax[32] = 0;
      fVmin[33] = 0;
      fVmax[33] = 0;
      fVmin[34] = 0;
      fVmax[34] = 0;
      fVmin[35] = 0;
      fVmax[35] = 0;
      fVmin[36] = 0;
      fVmax[36] = 0;
      fVmin[37] = 0;
      fVmax[37] = 0;
      fVmin[38] = 0;
      fVmax[38] = 0;
      fVmin[39] = 0;
      fVmax[39] = 0;
      fVmin[40] = 0;
      fVmax[40] = 0;
      fVmin[41] = 0;
      fVmax[41] = 0;
      fVmin[42] = 0;
      fVmax[42] = 0;
      fVmin[43] = 0;
      fVmax[43] = 0;
      fVmin[44] = 0;
      fVmax[44] = 0;
      fVmin[45] = 0;
      fVmax[45] = 0;
      fVmin[46] = 0;
      fVmax[46] = 0;
      fVmin[47] = 0;
      fVmax[47] = 0;
      fVmin[48] = 0;
      fVmax[48] = 0;
      fVmin[49] = 0;
      fVmax[49] = 0;
      fVmin[50] = 0;
      fVmax[50] = 0;
      fVmin[51] = 0;
      fVmax[51] = 0;
      fVmin[52] = 0;
      fVmax[52] = 0;
      fVmin[53] = 0;
      fVmax[53] = 0;
      fVmin[54] = 0;
      fVmax[54] = 0;
      fVmin[55] = 0;
      fVmax[55] = 0;
      fVmin[56] = 0;
      fVmax[56] = 0;
      fVmin[57] = 0;
      fVmax[57] = 0;
      fVmin[58] = 0;
      fVmax[58] = 0;
      fVmin[59] = 0;
      fVmax[59] = 0;
      fVmin[60] = 0;
      fVmax[60] = 0;
      fVmin[61] = 0;
      fVmax[61] = 0;
      fVmin[62] = 0;
      fVmax[62] = 0;
      fVmin[63] = 0;
      fVmax[63] = 0;
      fVmin[64] = 0;
      fVmax[64] = 0;
      fVmin[65] = 0;
      fVmax[65] = 0;
      fVmin[66] = 0;
      fVmax[66] = 0;
      fVmin[67] = 0;
      fVmax[67] = 0;
      fVmin[68] = 0;
      fVmax[68] = 0;
      fVmin[69] = 0;
      fVmax[69] = 0;
      fVmin[70] = 0;
      fVmax[70] = 0;
      fVmin[71] = 0;
      fVmax[71] = 0;
      fVmin[72] = 0;
      fVmax[72] = 0;
      fVmin[73] = 0;
      fVmax[73] = 0;
      fVmin[74] = 0;
      fVmax[74] = 0;
      fVmin[75] = 0;
      fVmax[75] = 0;
      fVmin[76] = 0;
      fVmax[76] = 0;
      fVmin[77] = 0;
      fVmax[77] = 0;
      fVmin[78] = 0;
      fVmax[78] = 0;
      fVmin[79] = 0;
      fVmax[79] = 0;
      fVmin[80] = 0;
      fVmax[80] = 0;
      fVmin[81] = 0;
      fVmax[81] = 0;
      fVmin[82] = 0;
      fVmax[82] = 0;
      fVmin[83] = 0;
      fVmax[83] = 0;
      fVmin[84] = 0;
      fVmax[84] = 0;
      fVmin[85] = 0;
      fVmax[85] = 0;
      fVmin[86] = 0;
      fVmax[86] = 0;
      fVmin[87] = 0;
      fVmax[87] = 0;
      fVmin[88] = 0;
      fVmax[88] = 0;
      fVmin[89] = 0;
      fVmax[89] = 0;
      fVmin[90] = 0;
      fVmax[90] = 0;
      fVmin[91] = 0;
      fVmax[91] = 0;
      fVmin[92] = 0;
      fVmax[92] = 0;
      fVmin[93] = 0;
      fVmax[93] = 0;
      fVmin[94] = 0;
      fVmax[94] = 0;
      fVmin[95] = 0;
      fVmax[95] = 0;
      fVmin[96] = 0;
      fVmax[96] = 0;
      fVmin[97] = 0;
      fVmax[97] = 0;
      fVmin[98] = 0;
      fVmax[98] = 0;
      fVmin[99] = 0;
      fVmax[99] = 0;
      fVmin[100] = 0;
      fVmax[100] = 0;
      fVmin[101] = 0;
      fVmax[101] = 0;
      fVmin[102] = 0;
      fVmax[102] = 0;
      fVmin[103] = 0;
      fVmax[103] = 0;
      fVmin[104] = 0;
      fVmax[104] = 0;
      fVmin[105] = 0;
      fVmax[105] = 0;
      fVmin[106] = 0;
      fVmax[106] = 0;
      fVmin[107] = 0;
      fVmax[107] = 0;
      fVmin[108] = 0;
      fVmax[108] = 0;
      fVmin[109] = 0;
      fVmax[109] = 0;
      fVmin[110] = 0;
      fVmax[110] = 0;
      fVmin[111] = 0;
      fVmax[111] = 0;
      fVmin[112] = 0;
      fVmax[112] = 0;
      fVmin[113] = 0;
      fVmax[113] = 0;
      fVmin[114] = 0;
      fVmax[114] = 0;
      fVmin[115] = 0;
      fVmax[115] = 0;
      fVmin[116] = 0;
      fVmax[116] = 0;
      fVmin[117] = 0;
      fVmax[117] = 0;
      fVmin[118] = 0;
      fVmax[118] = 0;
      fVmin[119] = 0;
      fVmax[119] = 0;
      fVmin[120] = 0;
      fVmax[120] = 0;
      fVmin[121] = 0;
      fVmax[121] = 0;
      fVmin[122] = 0;
      fVmax[122] = 0;
      fVmin[123] = 0;
      fVmax[123] = 0;
      fVmin[124] = 0;
      fVmax[124] = 0;
      fVmin[125] = 0;
      fVmax[125] = 0;
      fVmin[126] = 0;
      fVmax[126] = 0;
      fVmin[127] = 0;
      fVmax[127] = 0;
      fVmin[128] = 0;
      fVmax[128] = 0;
      fVmin[129] = 0;
      fVmax[129] = 0;
      fVmin[130] = 0;
      fVmax[130] = 0;
      fVmin[131] = 0;
      fVmax[131] = 0;
      fVmin[132] = 0;
      fVmax[132] = 0;
      fVmin[133] = 0;
      fVmax[133] = 0;
      fVmin[134] = 0;
      fVmax[134] = 0;
      fVmin[135] = 0;
      fVmax[135] = 0;
      fVmin[136] = 0;
      fVmax[136] = 0;
      fVmin[137] = 0;
      fVmax[137] = 0;
      fVmin[138] = 0;
      fVmax[138] = 0;
      fVmin[139] = 0;
      fVmax[139] = 0;
      fVmin[140] = 0;
      fVmax[140] = 0;
      fVmin[141] = 0;
      fVmax[141] = 0;
      fVmin[142] = 0;
      fVmax[142] = 0;
      fVmin[143] = 0;
      fVmax[143] = 0;
      fVmin[144] = 0;
      fVmax[144] = 0;
      fVmin[145] = 0;
      fVmax[145] = 0;
      fVmin[146] = 0;
      fVmax[146] = 0;
      fVmin[147] = 0;
      fVmax[147] = 0;
      fVmin[148] = 0;
      fVmax[148] = 0;
      fVmin[149] = 0;
      fVmax[149] = 0;
      fVmin[150] = 0;
      fVmax[150] = 0;
      fVmin[151] = 0;
      fVmax[151] = 0;
      fVmin[152] = 0;
      fVmax[152] = 0;
      fVmin[153] = 0;
      fVmax[153] = 0;
      fVmin[154] = 0;
      fVmax[154] = 0;
      fVmin[155] = 0;
      fVmax[155] = 0;
      fVmin[156] = 0;
      fVmax[156] = 0;
      fVmin[157] = 0;
      fVmax[157] = 0;
      fVmin[158] = 0;
      fVmax[158] = 0;
      fVmin[159] = 0;
      fVmax[159] = 0;
      fVmin[160] = 0;
      fVmax[160] = 0;
      fVmin[161] = 0;
      fVmax[161] = 0;
      fVmin[162] = 0;
      fVmax[162] = 0;
      fVmin[163] = 0;
      fVmax[163] = 0;
      fVmin[164] = 0;
      fVmax[164] = 0;
      fVmin[165] = 0;
      fVmax[165] = 0;
      fVmin[166] = 0;
      fVmax[166] = 0;
      fVmin[167] = 0;
      fVmax[167] = 0;
      fVmin[168] = 0;
      fVmax[168] = 0;
      fVmin[169] = 0;
      fVmax[169] = 0;
      fVmin[170] = 0;
      fVmax[170] = 0;
      fVmin[171] = 0;
      fVmax[171] = 0;
      fVmin[172] = 0;
      fVmax[172] = 0;
      fVmin[173] = 0;
      fVmax[173] = 0;
      fVmin[174] = 0;
      fVmax[174] = 0;
      fVmin[175] = 0;
      fVmax[175] = 0;
      fVmin[176] = 0;
      fVmax[176] = 0;
      fVmin[177] = 0;
      fVmax[177] = 0;
      fVmin[178] = 0;
      fVmax[178] = 0;
      fVmin[179] = 0;
      fVmax[179] = 0;
      fVmin[180] = 0;
      fVmax[180] = 0;
      fVmin[181] = 0;
      fVmax[181] = 0;
      fVmin[182] = 0;
      fVmax[182] = 0;
      fVmin[183] = 0;
      fVmax[183] = 0;
      fVmin[184] = 0;
      fVmax[184] = 0;
      fVmin[185] = 0;
      fVmax[185] = 0;
      fVmin[186] = 0;
      fVmax[186] = 0;
      fVmin[187] = 0;
      fVmax[187] = 0;
      fVmin[188] = 0;
      fVmax[188] = 0;
      fVmin[189] = 0;
      fVmax[189] = 0;
      fVmin[190] = 0;
      fVmax[190] = 0;
      fVmin[191] = 0;
      fVmax[191] = 0;
      fVmin[192] = 0;
      fVmax[192] = 0;
      fVmin[193] = 0;
      fVmax[193] = 0;
      fVmin[194] = 0;
      fVmax[194] = 0;
      fVmin[195] = 0;
      fVmax[195] = 0;
      fVmin[196] = 0;
      fVmax[196] = 0;
      fVmin[197] = 0;
      fVmax[197] = 0;
      fVmin[198] = 0;
      fVmax[198] = 0;
      fVmin[199] = 0;
      fVmax[199] = 0;
      fVmin[200] = 0;
      fVmax[200] = 0;
      fVmin[201] = 0;
      fVmax[201] = 0;
      fVmin[202] = 0;
      fVmax[202] = 0;
      fVmin[203] = 0;
      fVmax[203] = 0;
      fVmin[204] = 0;
      fVmax[204] = 0;
      fVmin[205] = 0;
      fVmax[205] = 0;
      fVmin[206] = 0;
      fVmax[206] = 0;
      fVmin[207] = 0;
      fVmax[207] = 0;
      fVmin[208] = 0;
      fVmax[208] = 0;
      fVmin[209] = 0;
      fVmax[209] = 0;
      fVmin[210] = 0;
      fVmax[210] = 0;
      fVmin[211] = 0;
      fVmax[211] = 0;
      fVmin[212] = 0;
      fVmax[212] = 0;
      fVmin[213] = 0;
      fVmax[213] = 0;
      fVmin[214] = 0;
      fVmax[214] = 0;
      fVmin[215] = 0;
      fVmax[215] = 0;
      fVmin[216] = 0;
      fVmax[216] = 0;
      fVmin[217] = 0;
      fVmax[217] = 0;
      fVmin[218] = 0;
      fVmax[218] = 0;
      fVmin[219] = 0;
      fVmax[219] = 0;
      fVmin[220] = 0;
      fVmax[220] = 0;
      fVmin[221] = 0;
      fVmax[221] = 0;
      fVmin[222] = 0;
      fVmax[222] = 0;
      fVmin[223] = 0;
      fVmax[223] = 0;
      fVmin[224] = 0;
      fVmax[224] = 0;
      fVmin[225] = 0;
      fVmax[225] = 0;
      fVmin[226] = 0;
      fVmax[226] = 0;
      fVmin[227] = 0;
      fVmax[227] = 0;
      fVmin[228] = 0;
      fVmax[228] = 0;
      fVmin[229] = 0;
      fVmax[229] = 0;
      fVmin[230] = 0;
      fVmax[230] = 0;
      fVmin[231] = 0;
      fVmax[231] = 0;
      fVmin[232] = 0;
      fVmax[232] = 0;
      fVmin[233] = 0;
      fVmax[233] = 0;
      fVmin[234] = 0;
      fVmax[234] = 0;
      fVmin[235] = 0;
      fVmax[235] = 0;
      fVmin[236] = 0;
      fVmax[236] = 0;
      fVmin[237] = 0;
      fVmax[237] = 0;
      fVmin[238] = 0;
      fVmax[238] = 0;
      fVmin[239] = 0;
      fVmax[239] = 0;
      fVmin[240] = 0;
      fVmax[240] = 0;
      fVmin[241] = 0;
      fVmax[241] = 0;
      fVmin[242] = 0;
      fVmax[242] = 0;
      fVmin[243] = 0;
      fVmax[243] = 0;
      fVmin[244] = 0;
      fVmax[244] = 0;
      fVmin[245] = 0;
      fVmax[245] = 0;
      fVmin[246] = 0;
      fVmax[246] = 0;
      fVmin[247] = 0;
      fVmax[247] = 0;
      fVmin[248] = 0;
      fVmax[248] = 0;
      fVmin[249] = 0;
      fVmax[249] = 0;
      fVmin[250] = 0;
      fVmax[250] = 0;
      fVmin[251] = 0;
      fVmax[251] = 0;
      fVmin[252] = 0;
      fVmax[252] = 0;
      fVmin[253] = 0;
      fVmax[253] = 0;
      fVmin[254] = 0;
      fVmax[254] = 0;
      fVmin[255] = 0;
      fVmax[255] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';
      fType[4] = 'F';
      fType[5] = 'F';
      fType[6] = 'F';
      fType[7] = 'F';
      fType[8] = 'F';
      fType[9] = 'F';
      fType[10] = 'F';
      fType[11] = 'F';
      fType[12] = 'F';
      fType[13] = 'F';
      fType[14] = 'F';
      fType[15] = 'F';
      fType[16] = 'F';
      fType[17] = 'F';
      fType[18] = 'F';
      fType[19] = 'F';
      fType[20] = 'F';
      fType[21] = 'F';
      fType[22] = 'F';
      fType[23] = 'F';
      fType[24] = 'F';
      fType[25] = 'F';
      fType[26] = 'F';
      fType[27] = 'F';
      fType[28] = 'F';
      fType[29] = 'F';
      fType[30] = 'F';
      fType[31] = 'F';
      fType[32] = 'F';
      fType[33] = 'F';
      fType[34] = 'F';
      fType[35] = 'F';
      fType[36] = 'F';
      fType[37] = 'F';
      fType[38] = 'F';
      fType[39] = 'F';
      fType[40] = 'F';
      fType[41] = 'F';
      fType[42] = 'F';
      fType[43] = 'F';
      fType[44] = 'F';
      fType[45] = 'F';
      fType[46] = 'F';
      fType[47] = 'F';
      fType[48] = 'F';
      fType[49] = 'F';
      fType[50] = 'F';
      fType[51] = 'F';
      fType[52] = 'F';
      fType[53] = 'F';
      fType[54] = 'F';
      fType[55] = 'F';
      fType[56] = 'F';
      fType[57] = 'F';
      fType[58] = 'F';
      fType[59] = 'F';
      fType[60] = 'F';
      fType[61] = 'F';
      fType[62] = 'F';
      fType[63] = 'F';
      fType[64] = 'F';
      fType[65] = 'F';
      fType[66] = 'F';
      fType[67] = 'F';
      fType[68] = 'F';
      fType[69] = 'F';
      fType[70] = 'F';
      fType[71] = 'F';
      fType[72] = 'F';
      fType[73] = 'F';
      fType[74] = 'F';
      fType[75] = 'F';
      fType[76] = 'F';
      fType[77] = 'F';
      fType[78] = 'F';
      fType[79] = 'F';
      fType[80] = 'F';
      fType[81] = 'F';
      fType[82] = 'F';
      fType[83] = 'F';
      fType[84] = 'F';
      fType[85] = 'F';
      fType[86] = 'F';
      fType[87] = 'F';
      fType[88] = 'F';
      fType[89] = 'F';
      fType[90] = 'F';
      fType[91] = 'F';
      fType[92] = 'F';
      fType[93] = 'F';
      fType[94] = 'F';
      fType[95] = 'F';
      fType[96] = 'F';
      fType[97] = 'F';
      fType[98] = 'F';
      fType[99] = 'F';
      fType[100] = 'F';
      fType[101] = 'F';
      fType[102] = 'F';
      fType[103] = 'F';
      fType[104] = 'F';
      fType[105] = 'F';
      fType[106] = 'F';
      fType[107] = 'F';
      fType[108] = 'F';
      fType[109] = 'F';
      fType[110] = 'F';
      fType[111] = 'F';
      fType[112] = 'F';
      fType[113] = 'F';
      fType[114] = 'F';
      fType[115] = 'F';
      fType[116] = 'F';
      fType[117] = 'F';
      fType[118] = 'F';
      fType[119] = 'F';
      fType[120] = 'F';
      fType[121] = 'F';
      fType[122] = 'F';
      fType[123] = 'F';
      fType[124] = 'F';
      fType[125] = 'F';
      fType[126] = 'F';
      fType[127] = 'F';
      fType[128] = 'F';
      fType[129] = 'F';
      fType[130] = 'F';
      fType[131] = 'F';
      fType[132] = 'F';
      fType[133] = 'F';
      fType[134] = 'F';
      fType[135] = 'F';
      fType[136] = 'F';
      fType[137] = 'F';
      fType[138] = 'F';
      fType[139] = 'F';
      fType[140] = 'F';
      fType[141] = 'F';
      fType[142] = 'F';
      fType[143] = 'F';
      fType[144] = 'F';
      fType[145] = 'F';
      fType[146] = 'F';
      fType[147] = 'F';
      fType[148] = 'F';
      fType[149] = 'F';
      fType[150] = 'F';
      fType[151] = 'F';
      fType[152] = 'F';
      fType[153] = 'F';
      fType[154] = 'F';
      fType[155] = 'F';
      fType[156] = 'F';
      fType[157] = 'F';
      fType[158] = 'F';
      fType[159] = 'F';
      fType[160] = 'F';
      fType[161] = 'F';
      fType[162] = 'F';
      fType[163] = 'F';
      fType[164] = 'F';
      fType[165] = 'F';
      fType[166] = 'F';
      fType[167] = 'F';
      fType[168] = 'F';
      fType[169] = 'F';
      fType[170] = 'F';
      fType[171] = 'F';
      fType[172] = 'F';
      fType[173] = 'F';
      fType[174] = 'F';
      fType[175] = 'F';
      fType[176] = 'F';
      fType[177] = 'F';
      fType[178] = 'F';
      fType[179] = 'F';
      fType[180] = 'F';
      fType[181] = 'F';
      fType[182] = 'F';
      fType[183] = 'F';
      fType[184] = 'F';
      fType[185] = 'F';
      fType[186] = 'F';
      fType[187] = 'F';
      fType[188] = 'F';
      fType[189] = 'F';
      fType[190] = 'F';
      fType[191] = 'F';
      fType[192] = 'F';
      fType[193] = 'F';
      fType[194] = 'F';
      fType[195] = 'F';
      fType[196] = 'F';
      fType[197] = 'F';
      fType[198] = 'F';
      fType[199] = 'F';
      fType[200] = 'F';
      fType[201] = 'F';
      fType[202] = 'F';
      fType[203] = 'F';
      fType[204] = 'F';
      fType[205] = 'F';
      fType[206] = 'F';
      fType[207] = 'F';
      fType[208] = 'F';
      fType[209] = 'F';
      fType[210] = 'F';
      fType[211] = 'F';
      fType[212] = 'F';
      fType[213] = 'F';
      fType[214] = 'F';
      fType[215] = 'F';
      fType[216] = 'F';
      fType[217] = 'F';
      fType[218] = 'F';
      fType[219] = 'F';
      fType[220] = 'F';
      fType[221] = 'F';
      fType[222] = 'F';
      fType[223] = 'F';
      fType[224] = 'F';
      fType[225] = 'F';
      fType[226] = 'F';
      fType[227] = 'F';
      fType[228] = 'F';
      fType[229] = 'F';
      fType[230] = 'F';
      fType[231] = 'F';
      fType[232] = 'F';
      fType[233] = 'F';
      fType[234] = 'F';
      fType[235] = 'F';
      fType[236] = 'F';
      fType[237] = 'F';
      fType[238] = 'F';
      fType[239] = 'F';
      fType[240] = 'F';
      fType[241] = 'F';
      fType[242] = 'F';
      fType[243] = 'F';
      fType[244] = 'F';
      fType[245] = 'F';
      fType[246] = 'F';
      fType[247] = 'F';
      fType[248] = 'F';
      fType[249] = 'F';
      fType[250] = 'F';
      fType[251] = 'F';
      fType[252] = 'F';
      fType[253] = 'F';
      fType[254] = 'F';
      fType[255] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[256];
   double fVmax[256];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[256];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.282428819673512);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294118,-99) , 
215, 19.6672, 0, 0, 0.626168,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284916,-99) , 
192, 15.7063, 1, 0, 0.450397,-99) , 
206, 16.2518, 1, 0, 0.518788,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.279612);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43997,-99) , 
199, 47.115, 0, 0, 0.538374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340244,-99) , 
4, 24.1987, 0, 0, 0.381367,-99) , 
2, 11.6266, 0, 0, 0.471397,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.176913);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 22.5468, 1, 1, 0.546895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27975,-99) , 
88, 90.6447, 0, 0, 0.375965,-99) , 
246, 13.4643, 0, 0, 0.504442,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.219352);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 83.5789, 1, 1, 0.737485,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432648,-99) , 
208, -3.20776, 1, 0, 0.452574,-99) , 
142, 14.3657, 1, 0, 0.501081,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.208441);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.937015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422037,-99) , 
217, 45.2385, 0, 0, 0.496796,-99) , 
154, 37.429, 1, 0, 0.516621,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.230711);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 11.9444, 0, 1, 0.776182,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408961,-99) , 
127, 22.4764, 1, 0, 0.505198,-99) , 
146, 16.1419, 1, 0, 0.536458,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.17204);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 11.5036, 1, 1, 0.673636,-99) , 
NN(
0, 
0, 
-1, 52.5214, 1, -1, 0.436796,-99) , 
160, 9.9597, 1, 0, 0.483931,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.282714);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 8.61791, 0, 1, 0.635444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377455,-99) , 
115, 25.9381, 1, 0, 0.422632,-99) , 
56, 51.861, 0, 0, 0.536772,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.143359);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488714,-99) , 
162, 22.2703, 1, 0, 0.535976,-99) , 
NN(
0, 
0, 
-1, 11.0687, 1, -1, 0.249809,-99) , 
196, 18.1943, 0, 0, 0.51094,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.245314);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336596,-99) , 
158, 8.18663, 0, 0, 0.633968,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419461,-99) , 
135, 66.9127, 1, 0, 0.46801,-99) , 
222, 10.8128, 1, 0, 0.523961,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.128803);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.975311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308548,-99) , 
87, 51.7444, 0, 0, 0.492637,-99) , 
202, 89.027, 0, 0, 0.507777,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.200865);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 23.1698, 1, 1, 0.56631,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265498,-99) , 
161, 9.65742, 1, 0, 0.358934,-99) , 
95, 31.7507, 1, 0, 0.511886,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.218973);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361412,-99) , 
201, 28.8119, 0, 0, 0.550872,-99) , 
NN(
0, 
0, 
-1, 8.10016, 1, -1, 0.169503,-99) , 
95, 49.1306, 1, 0, 0.528601,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.156277);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 7.4629, 1, 1, 0.838119,-99) , 
NN(
0, 
0, 
-1, 85.1917, 1, -1, 0.439182,-99) , 
142, 8.45099, 1, 0, 0.463194,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.247129);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442342,-99) , 
5, 22.2218, 0, 0, 0.539048,-99) , 
NN(
0, 
0, 
-1, 61.5141, 0, -1, 0.27148,-99) , 
246, 10.2488, 0, 0, 0.498876,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.212513);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 17.4254, 0, 1, 0.663126,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426816,-99) , 
95, 5.30688, 1, 0, 0.456222,-99) , 
137, 83.9392, 0, 0, 0.505266,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.211041);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38049,-99) , 
217, 22.1655, 0, 0, 0.551072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, 5.84999, 1, 0, 0.211259,-99) , 
40, 17.6228, 0, 0, 0.529999,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.0883619);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 80.1347, 1, 1, 0.843767,-99) , 
NN(
0, 
0, 
-1, 53.8828, 1, -1, 0.476283,-99) , 
96, 3.21751, 1, 0, 0.499649,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.18577);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 18.0589, 1, 1, 0.561467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28482,-99) , 
155, 31.1955, 1, 0, 0.360744,-99) , 
112, 38.226, 1, 0, 0.513762,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.154616);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357556,-99) , 
125, 73.1458, 1, 0, 0.695296,-99) , 
NN(
0, 
0, 
-1, 15.1552, 0, -1, 0.449264,-99) , 
112, 7.41169, 1, 0, 0.478551,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.219635);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475527,-99) , 
206, 13.9034, 0, 0, 0.701004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397366,-99) , 
127, 20.6341, 1, 0, 0.478737,-99) , 
25, 57.6884, 0, 0, 0.510107,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.26212);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485658,-99) , 
144, 38.1475, 1, 0, 0.618895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314322,-99) , 
132, 52.5599, 1, 0, 0.459711,-99) , 
111, 19.15, 1, 0, 0.526944,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.161186);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 16.0947, 1, 1, 0.555612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205921,-99) , 
159, 11.7371, 1, 0, 0.381037,-99) , 
128, 38.3193, 1, 0, 0.510404,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.19005);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 33.5948, 0, 1, 0.579092,-99) , 
NN(
0, 
0, 
-1, 36.905, 0, -1, 0.377407,-99) , 
231, 24.0554, 0, 0, 0.510449,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.285432);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267788,-99) , 
63, 47.1063, 1, 0, 0.604654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36288,-99) , 
220, 14.0295, 1, 0, 0.413318,-99) , 
193, 14.8873, 1, 0, 0.480078,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.191533);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 32.3025, 1, 1, 0.78661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420665,-99) , 
89, 56.93, 1, 0, 0.475047,-99) , 
159, 4.96105, 1, 0, 0.493424,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.174675);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479527,-99) , 
54, 71.8429, 0, 0, 0.512934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206268,-99) , 
10, 54.5839, 0, 0, 0.30052,-99) , 
246, 10.6405, 0, 0, 0.478781,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.207367);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 31.6841, 0, 1, 0.576888,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358214,-99) , 
128, 6.26678, 1, 0, 0.403738,-99) , 
19, 14.0789, 0, 0, 0.525065,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.212338);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345725,-99) , 
232, 18.0518, 0, 0, 0.524614,-99) , 
NN(
0, 
0, 
-1, 11.2876, 0, -1, 0.19331,-99) , 
160, 50.9621, 1, 0, 0.496068,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.252273);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292491,-99) , 
122, 95.7756, 1, 0, 0.649838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401517,-99) , 
175, 8.79033, 1, 0, 0.443939,-99) , 
96, 8.15567, 1, 0, 0.474373,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.216811);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409941,-99) , 
55, 39.7034, 0, 0, 0.737416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429802,-99) , 
51, 22.5539, 1, 0, 0.488176,-99) , 
126, 12.2597, 1, 0, 0.511363,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.185031);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 69.5074, 1, 1, 0.795276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452716,-99) , 
161, 9.29855, 1, 0, 0.483321,-99) , 
143, 5.1319, 1, 0, 0.516793,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.147459);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 8.24208, 1, 1, 0.817677,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2703,-99) , 
196, 23.2403, 0, 0, 0.496007,-99) , 
74, 85.5627, 0, 0, 0.522248,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.209312);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496146,-99) , 
104, 76.4629, 0, 0, 0.566813,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372768,-99) , 
39, 68.8603, 0, 0, 0.43141,-99) , 
244, 20.023, 0, 0, 0.496649,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.220299);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.53734, 0, 1, 0.731663,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390211,-99) , 
108, 42.1007, 1, 0, 0.45302,-99) , 
25, 60.9409, 0, 0, 0.478034,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.179393);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 8.0582, 1, 1, 0.565757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239564,-99) , 
131, 22.1428, 1, 0, 0.35269,-99) , 
127, 47.2641, 1, 0, 0.540375,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.264095);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473436,-99) , 
197, 32.3032, 0, 0, 0.62505,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363649,-99) , 
126, 20.4924, 1, 0, 0.439499,-99) , 
162, 22.9407, 1, 0, 0.48096,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.287362);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297835,-99) , 
124, 84.2272, 1, 0, 0.599969,-99) , 
NN(
0, 
0, 
-1, 53.4869, 1, -1, 0.373631,-99) , 
131, 64.2326, 1, 0, 0.530462,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.214635);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.107413,-99) , 
97, 71.6261, 1, 0, 0.564184,-99) , 
NN(
0, 
0, 
-1, 16.1768, 1, -1, 0.161995,-99) , 
203, 14.5587, 0, 0, 0.538536,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.257985);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454045,-99) , 
241, 11.1756, 1, 0, 0.625354,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411103,-99) , 
209, 5.66022, 1, 0, 0.440359,-99) , 
49, 16.7682, 1, 0, 0.515692,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.202308);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348493,-99) , 
138, 39.5795, 0, 0, 0.717198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297777,-99) , 
112, 34.4706, 1, 0, 0.494723,-99) , 
126, 13.232, 1, 0, 0.523786,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.112184);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499521,-99) , 
24, 57.5356, 0, 0, 0.533299,-99) , 
NN(
0, 
0, 
-1, 7.23933, 0, -1, 0.240155,-99) , 
233, 11.7292, 0, 0, 0.505117,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.180189);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441843,-99) , 
99, 48.7323, 0, 0, 0.511804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.106719,-99) , 
116, 94.2527, 1, 0, 0.494356,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.102698);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 47.2138, 1, 1, 0.533379,-99) , 
NN(
0, 
0, 
-1, 3.07801, 0, -1, 0.235326,-99) , 
201, 23.6882, 0, 0, 0.510454,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.210212);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
151, 45.517, 0, 0, 0.521672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235717,-99) , 
232, 64.1191, 0, 0, 0.326902,-99) , 
40, 30.5935, 0, 0, 0.469704,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.206949);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.945582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476926,-99) , 
199, 54.9157, 0, 0, 0.752933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412062,-99) , 
112, 11.0731, 1, 0, 0.448522,-99) , 
143, 4.83416, 1, 0, 0.468734,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.222292);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383073,-99) , 
103, 62.346, 0, 0, 0.547182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132887,-99) , 
213, 10.1543, 0, 0, 0.530228,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.250969);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320806,-99) , 
41, 19.1813, 0, 0, 0.618511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355624,-99) , 
110, 18.5387, 1, 0, 0.412617,-99) , 
82, 20.7358, 1, 0, 0.454416,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.245771);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595627,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355975,-99) , 
196, 23.8961, 0, 0, 0.548894,-99) , 
NN(
0, 
0, 
-1, 58.3474, 0, -1, 0.27185,-99) , 
254, 1.68832, 0, 0, 0.51422,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.239633);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388386,-99) , 
223, 19.7744, 1, 0, 0.513379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189499,-99) , 
6, 57.0281, 0, 0, 0.284875,-99) , 
246, 10.4866, 0, 0, 0.475129,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.246972);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322964,-99) , 
237, 8.74911, 0, 0, 0.495121,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277828,-99) , 
196, 85.8411, 0, 0, 0.32698,-99) , 
192, 23.9517, 1, 0, 0.441521,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.217868);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.939012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452119,-99) , 
14, 6.44793, 1, 0, 0.701159,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412679,-99) , 
74, 85.3214, 0, 0, 0.435144,-99) , 
63, 2.13973, 1, 0, 0.454776,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.251501);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168775,-99) , 
160, 54.3898, 1, 0, 0.550503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24952,-99) , 
56, 79.0259, 0, 0, 0.342626,-99) , 
245, 12.8613, 0, 0, 0.495487,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.187528);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 33.3272, 0, 1, 0.569707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272569,-99) , 
32, 9.04854, 1, 0, 0.39298,-99) , 
5, 24.4748, 0, 0, 0.471289,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.147532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4669,-99) , 
45, 3.25286, 1, 0, 0.484711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131341,-99) , 
137, 85.8525, 0, 0, 0.249754,-99) , 
33, 3.63394, 0, 0, 0.458303,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.281383);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402239,-99) , 
55, 41.4283, 0, 0, 0.548243,-99) , 
NN(
0, 
0, 
-1, 61.7069, 0, -1, 0.353678,-99) , 
249, 17.211, 0, 0, 0.474454,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.292047);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403908,-99) , 
223, 9.87348, 1, 0, 0.673051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390965,-99) , 
171, 29.3365, 1, 0, 0.411852,-99) , 
222, 7.84728, 1, 0, 0.465817,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.180792);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 48.7958, 1, 1, 0.772601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291574,-99) , 
69, 42.2718, 0, 0, 0.462652,-99) , 
100, 31.3708, 1, 0, 0.48615,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.214055);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44908,-99) , 
62, 18.6642, 1, 0, 0.522493,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.118471,-99) , 
189, 13.8126, 1, 0, 0.256376,-99) , 
129, 60.9583, 1, 0, 0.497357,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.145522);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496872,-99) , 
130, 19.326, 1, 0, 0.539256,-99) , 
NN(
0, 
0, 
-1, 45.6741, 1, -1, 0.250018,-99) , 
50, 48.3754, 1, 0, 0.49995,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.185328);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 27.4912, 0, 1, 0.72541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344281,-99) , 
48, 22.981, 1, 0, 0.469566,-99) , 
215, 67.0265, 0, 0, 0.50406,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.155137);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.951511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459061,-99) , 
166, 64.3931, 1, 0, 0.738252,-99) , 
NN(
0, 
0, 
-1, 69.7462, 1, -1, 0.438374,-99) , 
171, 87.2565, 0, 0, 0.460045,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.180757);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 21.097, 1, 1, 0.5739,-99) , 
NN(
0, 
0, 
-1, 74.4944, 0, -1, 0.152466,-99) , 
96, 56.0493, 1, 0, 0.550018,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.202799);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 25.038, 1, 1, 0.810363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39074,-99) , 
5, 25.2682, 0, 0, 0.475308,-99) , 
249, 51.9447, 0, 0, 0.503268,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.215799);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 7.79041, 0, 1, 0.603064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402784,-99) , 
143, 4.55725, 1, 0, 0.425559,-99) , 
128, 14.313, 1, 0, 0.482239,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.126839);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485159,-99) , 
222, 7.47987, 1, 0, 0.522997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112427,-99) , 
185, 29.7153, 0, 0, 0.50403,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.242454);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440597,-99) , 
6, 27.9668, 0, 0, 0.532282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0611005,-99) , 
164, 55.269, 0, 0, 0.214973,-99) , 
67, 72.1937, 1, 0, 0.50492,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.177448);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 31.275, 1, 1, 0.804965,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45048,-99) , 
106, 47.7751, 1, 0, 0.491202,-99) , 
208, -1.1749, 1, 0, 0.511986,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.246656);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 26.4721, 0, 1, 0.653417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307336,-99) , 
53, 51.4972, 0, 0, 0.46424,-99) , 
234, 30.0524, 0, 0, 0.55797,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.223209);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480142,-99) , 
217, 61.5432, 0, 0, 0.544219,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222275,-99) , 
7, 44.8706, 0, 0, 0.297644,-99) , 
103, 83.3435, 1, 0, 0.472494,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.235523);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441429,-99) , 
154, 64.8264, 1, 0, 0.526049,-99) , 
NN(
0, 
0, 
-1, 19.1924, 1, -1, 0.328444,-99) , 
128, 39.3139, 1, 0, 0.479958,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.274529);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24584,-99) , 
136, 68.8805, 0, 0, 0.615419,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388043,-99) , 
6, 40.6593, 0, 0, 0.454437,-99) , 
235, 35.8758, 0, 0, 0.49969,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.264045);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407378,-99) , 
4, 9.96131, 0, 0, 0.548754,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200873,-99) , 
178, 37.5933, 0, 0, 0.253712,-99) , 
216, 26.2282, 0, 0, 0.489773,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.249835);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493496,-99) , 
196, 20.2861, 0, 0, 0.782854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29809,-99) , 
213, 22.319, 0, 0, 0.520048,-99) , 
112, 7.23904, 1, 0, 0.559486,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.252239);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 35.6838, 1, 1, 0.588627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337986,-99) , 
95, 9.28917, 1, 0, 0.401401,-99) , 
98, 32.3772, 1, 0, 0.479146,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.206593);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331366,-99) , 
19, 9.73066, 0, 0, 0.499713,-99) , 
NN(
0, 
0, 
-1, 62.4419, 1, -1, 0.310904,-99) , 
50, 42.8802, 1, 0, 0.461611,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.252576);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354778,-99) , 
3, 33.9129, 1, 0, 0.560081,-99) , 
NN(
0, 
0, 
-1, 19.6849, 0, -1, 0.29693,-99) , 
87, 51.5481, 0, 0, 0.515082,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.111746);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 25.4487, 1, 1, 0.801702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225758,-99) , 
67, 71.8051, 1, 0, 0.493686,-99) , 
26, 8.99517, 1, 0, 0.519065,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.226508);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345421,-99) , 
133, 92.9417, 1, 0, 0.668467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248133,-99) , 
96, 27.4133, 1, 0, 0.429884,-99) , 
125, 23.9332, 1, 0, 0.473219,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.264268);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.979178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491632,-99) , 
68, 47.8596, 0, 0, 0.780684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386055,-99) , 
147, 24.2995, 1, 0, 0.419059,-99) , 
164, 85.3446, 0, 0, 0.442619,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.242807);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4189,-99) , 
137, 79.5936, 1, 0, 0.665047,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372421,-99) , 
85, 69.2332, 0, 0, 0.426137,-99) , 
135, 88.4818, 0, 0, 0.463084,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.210911);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 12.1112, 0, 1, 0.70264,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415848,-99) , 
121, 86.4438, 0, 0, 0.459118,-99) , 
135, 91.1844, 0, 0, 0.487672,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.244794);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 75.9877, 1, 1, 0.848337,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344558,-99) , 
154, 70.305, 1, 0, 0.468677,-99) , 
232, 67.5661, 0, 0, 0.508419,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.205096);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435347,-99) , 
21, 33.325, 0, 0, 0.50667,-99) , 
NN(
0, 
0, 
-1, 4.89989, 0, -1, 0.198956,-99) , 
201, 24.1661, 0, 0, 0.48329,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.157524);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319145,-99) , 
213, 20.8042, 0, 0, 0.48425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0758433,-99) , 
98, 83.1011, 1, 0, 0.464328,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.268611);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278386,-99) , 
190, 52.9156, 1, 0, 0.559676,-99) , 
NN(
0, 
0, 
-1, 28.6941, 0, -1, 0.361049,-99) , 
231, 29.9913, 0, 0, 0.470421,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.11927);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491488,-99) , 
112, 7.23904, 1, 0, 0.530587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0371849,-99) , 
151, 47.1326, 0, 0, 0.514204,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.277486);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390224,-99) , 
188, 34.3875, 0, 0, 0.512237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142164,-99) , 
39, 33.5242, 1, 0, 0.28286,-99) , 
127, 43.2702, 1, 0, 0.472671,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.147361);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.90093,-99) , 
NN(
0, 
0, 
-1, 16.3601, 0, -1, 0.442217,-99) , 
248, 59.9729, 0, 0, 0.462761,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.227178);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 17.6737, 1, 1, 0.589993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.111337,-99) , 
120, 65.1876, 1, 0, 0.269299,-99) , 
199, 77.8979, 1, 0, 0.555713,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.21204);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0717069,-99) , 
63, 45.3006, 1, 0, 0.56404,-99) , 
NN(
0, 
0, 
-1, 4.22418, 0, -1, 0.15061,-99) , 
248, 5.73553, 0, 0, 0.539847,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.274356);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365238,-99) , 
249, 13.9292, 0, 0, 0.526443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275655,-99) , 
244, 48.5448, 0, 0, 0.345207,-99) , 
56, 37.2293, 0, 0, 0.485446,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.319095);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479042,-99) , 
211, 27.3016, 0, 0, 0.625966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315268,-99) , 
146, 21.3756, 1, 0, 0.392227,-99) , 
137, 66.0838, 1, 0, 0.458895,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.252382);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428153,-99) , 
232, 53.687, 0, 0, 0.473287,-99) , 
NN(
0, 
0, 
-1, 33.7185, 0, -1, 0.257941,-99) , 
23, 16.5021, 0, 0, 0.437133,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.184596);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.97502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358909,-99) , 
144, 42.716, 1, 0, 0.759737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472506,-99) , 
146, 14.7031, 1, 0, 0.504525,-99) , 
90, 36.8859, 1, 0, 0.535886,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.157035);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.943313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48858,-99) , 
151, 59.2862, 0, 0, 0.777317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462438,-99) , 
80, 4.02423, 1, 0, 0.487154,-99) , 
42, 69.7858, 0, 0, 0.513365,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.183127);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 45.1364, 1, 1, 0.643343,-99) , 
NN(
0, 
0, 
-1, 35.4855, 0, -1, 0.457417,-99) , 
143, 22.944, 1, 0, 0.545933,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.158527);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 48.0793, 0, 1, 0.567551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174245,-99) , 
131, 88.9898, 1, 0, 0.550712,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.228196);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440335,-99) , 
140, 66.0655, 1, 0, 0.700447,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445995,-99) , 
205, 62.1466, 0, 0, 0.474338,-99) , 
73, 75.429, 0, 0, 0.531456,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.262256);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420502,-99) , 
36, 26.5947, 0, 0, 0.536984,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146567,-99) , 
222, 10.5446, 1, 0, 0.323588,-99) , 
254, 2.67682, 0, 0, 0.501228,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.169139);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 11.7146, 0, 1, 0.768869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.940123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459568,-99) , 
250, 61.9861, 0, 0, 0.480331,-99) , 
6, 47.2306, 0, 0, 0.515954,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.152558);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 40.1614, 1, 1, 0.696806,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112824,-99) , 
5, 7.89299, 0, 0, 0.489271,-99) , 
153, 85.2975, 0, 0, 0.536416,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.143474);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 33.7296, 0, 1, 0.547908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.113271,-99) , 
75, 28.7556, 1, 0, 0.250446,-99) , 
113, 62.8157, 1, 0, 0.519928,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.089248);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495259,-99) , 
126, 11.2742, 1, 0, 0.520161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176066,-99) , 
146, 76.7371, 1, 0, 0.502015,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.133278);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 43.6675, 1, 1, 0.550341,-99) , 
NN(
0, 
0, 
-1, 64.1798, 1, -1, 0.167252,-99) , 
160, 53.5749, 1, 0, 0.528763,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.248061);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46162,-99) , 
112, 20.5876, 1, 0, 0.54278,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217308,-99) , 
146, 14.5743, 1, 0, 0.316827,-99) , 
94, 47.4633, 1, 0, 0.500184,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.255433);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 51.8819, 0, 1, 0.679215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36981,-99) , 
112, 19.7006, 1, 0, 0.492201,-99) , 
141, 27.924, 1, 0, 0.545704,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.280847);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332194,-99) , 
1, 11.6841, 0, 0, 0.639724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37662,-99) , 
215, 59.9408, 0, 0, 0.427949,-99) , 
119, 87.8068, 0, 0, 0.468589,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.220701);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 22.5378, 0, 1, 0.578273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253316,-99) , 
228, 50.7065, 0, 0, 0.393231,-99) , 
8, 12.8768, 0, 0, 0.539898,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.182249);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21369,-99) , 
149, 91.3579, 1, 0, 0.526372,-99) , 
NN(
0, 
0, 
-1, 22.4118, 1, -1, 0.239663,-99) , 
111, 47.9009, 1, 0, 0.500882,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.211216);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464294,-99) , 
192, 13.1286, 1, 0, 0.540251,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243473,-99) , 
67, 56.8324, 0, 0, 0.353497,-99) , 
152, 64.5786, 0, 0, 0.492564,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.255944);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423367,-99) , 
224, 2.70881, 0, 0, 0.660397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357477,-99) , 
126, 24.6429, 1, 0, 0.439968,-99) , 
131, 30.8538, 1, 0, 0.474358,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.225623);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271984,-99) , 
54, 23.8826, 0, 0, 0.633556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283456,-99) , 
224, 4.35453, 0, 0, 0.470854,-99) , 
81, 19.1842, 1, 0, 0.52073,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.150801);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 49.1779, 0, 1, 0.737749,-99) , 
NN(
0, 
0, 
-1, 42.2859, 1, -1, 0.43906,-99) , 
146, 15.5659, 1, 0, 0.462531,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.255526);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448925,-99) , 
246, 17.3182, 0, 0, 0.56608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0913754,-99) , 
110, 18.2049, 1, 0, 0.270656,-99) , 
25, 16.1447, 0, 0, 0.524034,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.221704);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436934,-99) , 
251, 18.7071, 0, 0, 0.514494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172157,-99) , 
39, 31.096, 0, 0, 0.247664,-99) , 
10, 8.36907, 0, 0, 0.477934,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.252248);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441125,-99) , 
142, 54.7831, 1, 0, 0.578303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237662,-99) , 
190, 19.1376, 1, 0, 0.395276,-99) , 
115, 46.4928, 1, 0, 0.479564,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.231167);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 54.7131, 0, 1, 0.764026,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411198,-99) , 
24, 57.5118, 0, 0, 0.448956,-99) , 
102, 48.5912, 1, 0, 0.474207,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.196615);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456919,-99) , 
236, 9.19304, 0, 0, 0.714084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316859,-99) , 
182, 54.3622, 0, 0, 0.444075,-99) , 
9, 45.4029, 0, 0, 0.493703,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.314786);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371698,-99) , 
203, 21.3887, 0, 0, 0.57772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317074,-99) , 
162, 14.7212, 1, 0, 0.363984,-99) , 
55, 42.7041, 0, 0, 0.510793,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.220576);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 29.3938, 0, 1, 0.768142,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38172,-99) , 
49, 18.7733, 1, 0, 0.47163,-99) , 
34, 52.8496, 0, 0, 0.494375,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.281792);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 27.597, 0, 1, 0.704065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411933,-99) , 
148, 38.1837, 1, 0, 0.452904,-99) , 
26, 38.6949, 0, 0, 0.528784,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.202343);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806643,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484392,-99) , 
23, 48.7064, 0, 0, 0.537418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241726,-99) , 
225, 15.882, 0, 0, 0.30598,-99) , 
216, 27.1242, 0, 0, 0.490172,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.309055);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341027,-99) , 
126, 18.4384, 1, 0, 0.738635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386888,-99) , 
97, 16.1505, 1, 0, 0.447836,-99) , 
125, 18.3567, 1, 0, 0.4824,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.226464);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463444,-99) , 
231, 33.0203, 0, 0, 0.548311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201874,-99) , 
23, 17.7988, 0, 0, 0.314502,-99) , 
5, 7.58001, 0, 0, 0.513393,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.194448);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481806,-99) , 
160, 16.8784, 1, 0, 0.554569,-99) , 
NN(
0, 
0, 
-1, 7.50725, 1, -1, 0.286846,-99) , 
31, 25.8648, 1, 0, 0.518107,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.30851);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443784,-99) , 
105, 58.6166, 0, 0, 0.602561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236286,-99) , 
98, 14.9495, 1, 0, 0.353794,-99) , 
142, 51.8592, 1, 0, 0.556833,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.302091);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392816,-99) , 
88, 74.111, 1, 0, 0.553635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292075,-99) , 
123, 49.0218, 1, 0, 0.333587,-99) , 
240, 4.56139, 0, 0, 0.478407,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.223529);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406885,-99) , 
186, 25.8358, 0, 0, 0.701644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456238,-99) , 
115, 25.9989, 1, 0, 0.496895,-99) , 
139, 44.3651, 1, 0, 0.545422,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.172457);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458638,-99) , 
231, 18.0759, 0, 0, 0.756335,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200358,-99) , 
151, 52.3882, 0, 0, 0.49354,-99) , 
238, 4.50332, 1, 0, 0.544909,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.195848);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 54.9714, 0, 1, 0.63659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279354,-99) , 
73, 48.7304, 0, 0, 0.432151,-99) , 
101, 69.8277, 0, 0, 0.515037,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.245586);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 57.5176, 0, 1, 0.591458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322836,-99) , 
246, 43.0463, 0, 0, 0.40084,-99) , 
27, 29.6274, 0, 0, 0.478632,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.153576);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21642,-99) , 
118, 94.9377, 1, 0, 0.502996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160562,-99) , 
248, 50.2772, 0, 0, 0.276792,-99) , 
8, 12.4015, 0, 0, 0.465046,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.22627);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490222,-99) , 
248, 18.4795, 0, 0, 0.581549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286267,-99) , 
112, 15.1397, 1, 0, 0.388015,-99) , 
21, 32.4058, 0, 0, 0.472544,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.247645);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423051,-99) , 
128, 37.8834, 1, 0, 0.546442,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228458,-99) , 
73, 64.9398, 0, 0, 0.324731,-99) , 
174, 43.9342, 1, 0, 0.497493,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.272957);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460423,-99) , 
214, 49.1592, 0, 0, 0.510602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208079,-99) , 
227, 51.7088, 0, 0, 0.322591,-99) , 
41, 26.2459, 0, 0, 0.454488,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.120376);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666423,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488747,-99) , 
174, 15.1826, 1, 0, 0.529327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136118,-99) , 
88, 40.5242, 0, 0, 0.512957,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.268654);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304032,-99) , 
103, 60.3976, 0, 0, 0.546107,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157801,-99) , 
17, 9.69516, 0, 0, 0.257734,-99) , 
152, 89.709, 1, 0, 0.502851,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.303303);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227735,-99) , 
115, 87.8613, 1, 0, 0.586624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346629,-99) , 
4, 43.8705, 0, 0, 0.383675,-99) , 
240, 6.67121, 0, 0, 0.491744,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.24528);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445805,-99) , 
33, 19.3214, 1, 0, 0.532242,-99) , 
NN(
0, 
0, 
-1, 11.4824, 1, -1, 0.361728,-99) , 
5, 23.1867, 0, 0, 0.449647,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.217751);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45267,-99) , 
111, 15.4658, 1, 0, 0.737425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441591,-99) , 
161, 11.2678, 1, 0, 0.478958,-99) , 
189, 15.4336, 1, 0, 0.51919,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.295124);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389986,-99) , 
89, 79.207, 1, 0, 0.54876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230848,-99) , 
206, 9.50976, 1, 0, 0.352668,-99) , 
105, 58.2436, 0, 0, 0.505791,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.263152);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 42.9645, 0, 1, 0.591123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297518,-99) , 
236, 8.00004, 1, 0, 0.374434,-99) , 
30, 8.56379, 0, 0, 0.525041,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.282063);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259861,-99) , 
138, 39.4627, 0, 0, 0.624962,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404977,-99) , 
178, 13.7139, 1, 0, 0.453816,-99) , 
174, 19.5748, 1, 0, 0.510375,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.292558);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.114714,-99) , 
94, 70.8209, 1, 0, 0.657272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403431,-99) , 
189, 18.8954, 1, 0, 0.476546,-99) , 
107, 69.7854, 0, 0, 0.532525,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.234719);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 48.5743, 0, 1, 0.728945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299865,-99) , 
111, 36.755, 1, 0, 0.484717,-99) , 
232, 52.1468, 0, 0, 0.535231,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.267567);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476603,-99) , 
2, 13.6831, 0, 0, 0.572585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346706,-99) , 
56, 88.2923, 0, 0, 0.385817,-99) , 
247, 20.6512, 0, 0, 0.490543,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.138321);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485778,-99) , 
7, 34.1524, 0, 0, 0.532179,-99) , 
NN(
0, 
0, 
-1, 28.607, 0, -1, 0.196605,-99) , 
200, 24.2241, 0, 0, 0.509984,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.235148);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251431,-99) , 
27, 6.67579, 0, 0, 0.576753,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154941,-99) , 
132, 53.711, 1, 0, 0.405845,-99) , 
141, 45.5321, 1, 0, 0.497314,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.236787);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410033,-99) , 
54, 48.4941, 0, 0, 0.501416,-99) , 
NN(
0, 
0, 
-1, 1.81762, 0, -1, 0.23695,-99) , 
246, 8.87373, 0, 0, 0.460751,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.223796);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.889696, 1, 1, 0.562379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27264,-99) , 
135, 69.3989, 1, 0, 0.343325,-99) , 
152, 69.5307, 0, 0, 0.476258,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.159326);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463547,-99) , 
148, 37.3775, 1, 0, 0.499313,-99) , 
NN(
0, 
0, 
-1, 88.3662, 1, -1, 0.17868,-99) , 
196, 15.1434, 0, 0, 0.479501,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.233992);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366555,-99) , 
232, 18.6633, 0, 0, 0.531748,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158111,-99) , 
231, 67.485, 0, 0, 0.265278,-99) , 
40, 22.6646, 0, 0, 0.498779,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.263676);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308106,-99) , 
54, 21.6967, 0, 0, 0.643775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252797,-99) , 
43, 35.8778, 0, 0, 0.46072,-99) , 
214, 39.9387, 0, 0, 0.550896,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.173549);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872191,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44238,-99) , 
126, 10.5836, 1, 0, 0.465221,-99) , 
78, 2.41722, 1, 0, 0.484478,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.239725);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 13.1926, 0, 1, 0.642562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393128,-99) , 
94, 10.3965, 1, 0, 0.423197,-99) , 
121, 85.9027, 0, 0, 0.466366,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.154873);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 19.2291, 1, 1, 0.899315,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463275,-99) , 
177, 4.76698, 1, 0, 0.485503,-99) , 
249, 54.627, 0, 0, 0.513202,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.267732);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462273,-99) , 
136, 74.6115, 0, 0, 0.6844,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348056,-99) , 
9, 28.6941, 0, 0, 0.466977,-99) , 
216, 58.882, 0, 0, 0.51941,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.173135);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 60.2803, 0, 1, 0.543786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190912,-99) , 
217, 27.8207, 0, 0, 0.299907,-99) , 
70, 74.7105, 1, 0, 0.486187,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.264762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265802,-99) , 
228, 12.2715, 0, 0, 0.571631,-99) , 
NN(
0, 
0, 
-1, 29.8311, 0, -1, 0.335037,-99) , 
227, 12.6823, 0, 0, 0.501125,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.136315);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477775,-99) , 
238, 4.87329, 1, 0, 0.512172,-99) , 
NN(
0, 
0, 
-1, 76.7855, 1, -1, 0.10553,-99) , 
248, 6.11015, 0, 0, 0.491255,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.202096);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366414,-99) , 
35, 15.3994, 1, 0, 0.734939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43882,-99) , 
112, 4.02913, 1, 0, 0.454614,-99) , 
84, 31.3159, 1, 0, 0.48856,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.316373);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307086,-99) , 
224, 32.6678, 1, 0, 0.625813,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349433,-99) , 
161, 11.5018, 1, 0, 0.429117,-99) , 
165, 56.1758, 0, 0, 0.539731,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.174105);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359426,-99) , 
190, 51.6332, 1, 0, 0.691821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271441,-99) , 
5, 16.3873, 0, 0, 0.444493,-99) , 
249, 47.3501, 0, 0, 0.470635,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.166624);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446374,-99) , 
4, 51.8209, 0, 0, 0.467446,-99) , 
146, 11.0229, 1, 0, 0.484328,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.209235);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 4.61605, 1, 1, 0.85728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418478,-99) , 
222, 14.1582, 1, 0, 0.492289,-99) , 
96, 3.93976, 1, 0, 0.519046,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.29645);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360681,-99) , 
142, 54.84, 1, 0, 0.548915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197923,-99) , 
111, 8.48524, 1, 0, 0.313485,-99) , 
254, 2.65657, 0, 0, 0.502555,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.267569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274706,-99) , 
98, 65.7463, 1, 0, 0.569762,-99) , 
NN(
0, 
0, 
-1, 78.2065, 1, -1, 0.319648,-99) , 
167, 52.3634, 0, 0, 0.52336,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.283633);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39256,-99) , 
94, 44.6199, 1, 0, 0.57054,-99) , 
NN(
0, 
0, 
-1, 86.7633, 1, -1, 0.341016,-99) , 
144, 38.7884, 1, 0, 0.522162,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.310042);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412451,-99) , 
201, 40.7703, 0, 0, 0.669779,-99) , 
NN(
0, 
0, 
-1, 59.9091, 1, -1, 0.368714,-99) , 
144, 10.6792, 1, 0, 0.429422,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.132259);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862502,-99) , 
NN(
0, 
0, 
-1, 14.8227, 0, -1, 0.44948,-99) , 
117, 38.0625, 1, 0, 0.469639,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.2128);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436586,-99) , 
86, 54.6488, 0, 0, 0.738594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409528,-99) , 
26, 36.5639, 0, 0, 0.478278,-99) , 
90, 40.482, 1, 0, 0.515321,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.200465);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472678,-99) , 
159, 8.81641, 1, 0, 0.653751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341025,-99) , 
192, 15.0884, 1, 0, 0.453665,-99) , 
126, 16.9659, 1, 0, 0.492143,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.223823);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286202,-99) , 
54, 23.8197, 0, 0, 0.601478,-99) , 
NN(
0, 
0, 
-1, 19.0007, 1, -1, 0.42404,-99) , 
245, 22.7566, 0, 0, 0.497202,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.263393);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 37.9056, 0, 1, 0.707432,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637696,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401543,-99) , 
241, 4.96497, 1, 0, 0.483072,-99) , 
242, 27.6318, 0, 0, 0.522404,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.202039);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 61.3193, 0, 1, 0.586699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257894,-99) , 
190, 22.9277, 1, 0, 0.420402,-99) , 
164, 52.0601, 1, 0, 0.506395,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.193835);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 63.4299, 0, 1, 0.745967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241991,-99) , 
216, 26.4365, 0, 0, 0.496528,-99) , 
40, 66.6031, 0, 0, 0.534592,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.181618);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463838,-99) , 
126, 16.9659, 1, 0, 0.509097,-99) , 
NN(
0, 
0, 
-1, 36.9842, 0, -1, 0.187128,-99) , 
152, 90.6623, 1, 0, 0.478131,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.277567);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303792,-99) , 
144, 49.6052, 1, 0, 0.63139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236747,-99) , 
160, 18.1797, 1, 0, 0.434702,-99) , 
108, 41.6946, 1, 0, 0.509026,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.173487);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 13.24, 1, 1, 0.55885,-99) , 
NN(
0, 
0, 
-1, 9.02024, 0, -1, 0.368819,-99) , 
58, 57.9295, 1, 0, 0.487826,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.266852);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430189,-99) , 
146, 28.0288, 1, 0, 0.491831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184572,-99) , 
120, 87.1715, 0, 0, 0.282684,-99) , 
95, 38.7946, 1, 0, 0.453309,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.245687);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166251,-99) , 
103, 56.182, 0, 0, 0.629139,-99) , 
NN(
0, 
0, 
-1, 22.1823, 1, -1, 0.420134,-99) , 
142, 26.8116, 1, 0, 0.508143,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.219023);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 20.293, 0, 1, 0.588971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390831,-99) , 
128, 6.65989, 1, 0, 0.414868,-99) , 
57, 52.7548, 0, 0, 0.486313,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.233457);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 71.6432, 1, 1, 0.690601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423907,-99) , 
103, 93.5829, 0, 0, 0.452612,-99) , 
181, 66.4502, 0, 0, 0.510058,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.230555);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 32.3643, 1, 1, 0.602838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391594,-99) , 
146, 11.2324, 1, 0, 0.419063,-99) , 
213, 40.4891, 0, 0, 0.497523,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.3353);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220881,-99) , 
137, 67.4472, 0, 0, 0.676132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354567,-99) , 
141, 32.9579, 1, 0, 0.486137,-99) , 
130, 26.4161, 1, 0, 0.540412,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.161774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495655,-99) , 
64, 8.7558, 1, 0, 0.535433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190846,-99) , 
221, 18.1261, 1, 0, 0.277803,-99) , 
118, 58.8856, 0, 0, 0.495944,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.312487);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416067,-99) , 
127, 42.2819, 1, 0, 0.582274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307878,-99) , 
206, 6.88652, 1, 0, 0.38859,-99) , 
96, 26.7168, 1, 0, 0.501008,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.266435);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.912737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453951,-99) , 
56, 31.9909, 0, 0, 0.776702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369769,-99) , 
52, 45.4988, 0, 0, 0.477776,-99) , 
154, 89.0913, 0, 0, 0.505201,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.216956);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273735,-99) , 
248, 7.33367, 0, 0, 0.564115,-99) , 
NN(
0, 
0, 
-1, 24.5669, 0, -1, 0.276023,-99) , 
175, 4.63315, 0, 0, 0.534491,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.18042);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 57.0402, 1, 1, 0.911731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339823,-99) , 
112, 36.8858, 1, 0, 0.483755,-99) , 
115, 22.1568, 1, 0, 0.51461,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.160517);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343943,-99) , 
54, 30.2531, 0, 0, 0.658847,-99) , 
NN(
0, 
0, 
-1, 95.8205, 1, -1, 0.467807,-99) , 
32, 5.38042, 1, 0, 0.511609,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.103696);
  fForest.push_back( 
NN(
0, 
0, 
-1, 3.41216, 1, 1, 0.551663,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.235766);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374877,-99) , 
197, 31.8417, 0, 0, 0.516963,-99) , 
NN(
0, 
0, 
-1, 14.532, 0, -1, 0.163921,-99) , 
71, 36.1732, 0, 0, 0.491141,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.241461);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 68.8518, 0, 1, 0.591281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294776,-99) , 
144, 12.1975, 1, 0, 0.414317,-99) , 
101, 63.1964, 0, 0, 0.514739,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.192958);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34682,-99) , 
159, 14.1809, 1, 0, 0.668002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303775,-99) , 
146, 45.5089, 1, 0, 0.443118,-99) , 
125, 19.9064, 1, 0, 0.470429,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.274121);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438868,-99) , 
73, 57.441, 0, 0, 0.535345,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31482,-99) , 
57, 83.8515, 0, 0, 0.364024,-99) , 
87, 78.3608, 1, 0, 0.478897,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.247375);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 56.5447, 1, 1, 0.594988,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303722,-99) , 
113, 19.4483, 1, 0, 0.385874,-99) , 
111, 15.9148, 1, 0, 0.457956,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.234441);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479774,-99) , 
204, 26.7386, 1, 0, 0.540612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294763,-99) , 
96, 10.3211, 1, 0, 0.343254,-99) , 
199, 41.1279, 0, 0, 0.472266,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.247934);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418991,-99) , 
95, 33.4572, 1, 0, 0.55042,-99) , 
NN(
0, 
0, 
-1, 11.9723, 1, -1, 0.35396,-99) , 
96, 30.4635, 1, 0, 0.483186,-99)    );
  // itree = 200
  fBoostWeights.push_back(0.301427);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263224,-99) , 
187, 26.3942, 0, 0, 0.540936,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260126,-99) , 
247, 49.0714, 0, 0, 0.343554,-99) , 
8, 19.2188, 0, 0, 0.477067,-99)    );
  // itree = 201
  fBoostWeights.push_back(0.352999);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368575,-99) , 
248, 17.6593, 0, 0, 0.531344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245542,-99) , 
82, 12.6472, 1, 0, 0.307342,-99) , 
4, 12.1376, 0, 0, 0.469568,-99)    );
  // itree = 202
  fBoostWeights.push_back(0.195453);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377317,-99) , 
163, 50.5936, 0, 0, 0.724072,-99) , 
NN(
0, 
0, 
-1, 57.7378, 0, -1, 0.431015,-99) , 
188, 18.6825, 1, 0, 0.464464,-99)    );
  // itree = 203
  fBoostWeights.push_back(0.179748);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260008,-99) , 
90, 31.5274, 0, 0, 0.704,-99) , 
NN(
0, 
0, 
-1, 32.4929, 1, -1, 0.451763,-99) , 
142, 15.1772, 1, 0, 0.496557,-99)    );
  // itree = 204
  fBoostWeights.push_back(0.146547);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398052,-99) , 
174, 28.3513, 0, 0, 0.726218,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.104018,-99) , 
143, 54.8145, 1, 0, 0.480137,-99) , 
180, 25.6363, 1, 0, 0.516691,-99)    );
  // itree = 205
  fBoostWeights.push_back(0.263549);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313427,-99) , 
206, 19.6454, 1, 0, 0.66789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389017,-99) , 
137, 83.724, 0, 0, 0.447734,-99) , 
62, 8.7245, 1, 0, 0.477421,-99)    );
  // itree = 206
  fBoostWeights.push_back(0.159605);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.921464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478162,-99) , 
157, 63.3406, 1, 0, 0.76173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311033,-99) , 
217, 27.3168, 0, 0, 0.465726,-99) , 
160, 5.63594, 1, 0, 0.494118,-99)    );
  // itree = 207
  fBoostWeights.push_back(0.147707);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 26.93, 1, 1, 0.549999,-99) , 
NN(
0, 
0, 
-1, 50.228, 1, -1, 0.331334,-99) , 
144, 39.6517, 1, 0, 0.507023,-99)    );
  // itree = 208
  fBoostWeights.push_back(0.0719085);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.949548,-99) , 
NN(
0, 
0, 
-1, 96.661, 1, -1, 0.481851,-99) , 
6, 60.6913, 0, 0, 0.501088,-99)    );
  // itree = 209
  fBoostWeights.push_back(0.178552);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 51.6512, 1, 1, 0.859986,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442756,-99) , 
6, 51.0193, 0, 0, 0.470245,-99) , 
241, -3.14635, 1, 0, 0.489067,-99)    );
  // itree = 210
  fBoostWeights.push_back(0.225859);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 19.3645, 1, 1, 0.673632,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245612,-99) , 
209, 20.2892, 1, 0, 0.441137,-99) , 
159, 13.2605, 1, 0, 0.504251,-99)    );
  // itree = 211
  fBoostWeights.push_back(0.26191);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411363,-99) , 
104, 60.032, 0, 0, 0.599088,-99) , 
NN(
0, 
0, 
-1, 12.7292, 1, -1, 0.401375,-99) , 
213, 24.9889, 0, 0, 0.538132,-99)    );
  // itree = 212
  fBoostWeights.push_back(0.255114);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 11.6534, 1, 1, 0.681494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3251,-99) , 
244, 17.7438, 0, 0, 0.452714,-99) , 
135, 67.1102, 1, 0, 0.504363,-99)    );
  // itree = 213
  fBoostWeights.push_back(0.253014);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 45.4881, 1, 1, 0.602402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37141,-99) , 
98, 11.3821, 1, 0, 0.405347,-99) , 
127, 24.6771, 1, 0, 0.502053,-99)    );
  // itree = 214
  fBoostWeights.push_back(0.192091);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 55.8277, 0, 1, 0.579844,-99) , 
NN(
0, 
0, 
-1, 17.7729, 0, -1, 0.382437,-99) , 
9, 21.1449, 0, 0, 0.501143,-99)    );
  // itree = 215
  fBoostWeights.push_back(0.198449);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495218,-99) , 
58, 58.1067, 0, 0, 0.551536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279334,-99) , 
135, 68.2312, 1, 0, 0.383924,-99) , 
246, 18.1866, 0, 0, 0.488101,-99)    );
  // itree = 216
  fBoostWeights.push_back(0.194611);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423482,-99) , 
87, 94.0866, 0, 0, 0.437669,-99) , 
35, 5.36731, 1, 0, 0.45445,-99)    );
  // itree = 217
  fBoostWeights.push_back(0.27316);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 30.084, 0, 1, 0.635458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364961,-99) , 
145, 15.4046, 1, 0, 0.408235,-99) , 
235, 33.7391, 0, 0, 0.477978,-99)    );
  // itree = 218
  fBoostWeights.push_back(0.341773);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328196,-99) , 
200, 29.4951, 0, 0, 0.599091,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360876,-99) , 
151, 72.8981, 1, 0, 0.438295,-99) , 
56, 45.1092, 0, 0, 0.53769,-99)    );
  // itree = 219
  fBoostWeights.push_back(0.178488);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 63.588, 0, 1, 0.831239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452236,-99) , 
205, 15.6429, 1, 0, 0.495857,-99) , 
215, 73.8718, 0, 0, 0.520177,-99)    );
  // itree = 220
  fBoostWeights.push_back(0.259963);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.935814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442215,-99) , 
102, 68.5618, 0, 0, 0.716686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43927,-99) , 
25, 50.8948, 0, 0, 0.505977,-99) , 
90, 41.8141, 1, 0, 0.545181,-99)    );
  // itree = 221
  fBoostWeights.push_back(0.13954);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 27.7294, 0, 1, 0.765713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
40, 16.5463, 0, 0, 0.488548,-99) , 
215, 67.0265, 0, 0, 0.539912,-99)    );
  // itree = 222
  fBoostWeights.push_back(0.116356);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 47.2377, 0, 1, 0.537902,-99) , 
NN(
0, 
0, 
-1, 16.1278, 1, -1, 0.182956,-99) , 
181, 24.3736, 0, 0, 0.512451,-99)    );
  // itree = 223
  fBoostWeights.push_back(0.155886);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467499,-99) , 
123, 43.7325, 1, 0, 0.511227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.137027,-99) , 
138, 37.5976, 0, 0, 0.495638,-99)    );
  // itree = 224
  fBoostWeights.push_back(0.243846);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282749,-99) , 
8, 8.08548, 0, 0, 0.566555,-99) , 
NN(
0, 
0, 
-1, 10.097, 0, -1, 0.150427,-99) , 
181, 26.0877, 0, 0, 0.539645,-99)    );
  // itree = 225
  fBoostWeights.push_back(0.327651);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323364,-99) , 
80, 51.5225, 1, 0, 0.732946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318191,-99) , 
130, 34.9998, 1, 0, 0.437743,-99) , 
125, 23.6866, 1, 0, 0.493241,-99)    );
  // itree = 226
  fBoostWeights.push_back(0.213557);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.977339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464699,-99) , 
76, 35.5728, 1, 0, 0.771511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355307,-99) , 
6, 27.8692, 0, 0, 0.445859,-99) , 
219, 64.1746, 0, 0, 0.466945,-99)    );
  // itree = 227
  fBoostWeights.push_back(0.159576);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 65.9788, 0, 1, 0.528735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210036,-99) , 
13, 40.3458, 0, 0, 0.322091,-99) , 
109, 60.1278, 1, 0, 0.486755,-99)    );
  // itree = 228
  fBoostWeights.push_back(0.278966);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 20.5984, 1, 1, 0.628385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374254,-99) , 
8, 59.4673, 0, 0, 0.405792,-99) , 
215, 54.2012, 0, 0, 0.478521,-99)    );
  // itree = 229
  fBoostWeights.push_back(0.178295);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469031,-99) , 
25, 16.6383, 0, 0, 0.6913,-99) , 
NN(
0, 
0, 
-1, 79.3349, 1, -1, 0.449856,-99) , 
232, 52.1468, 0, 0, 0.503673,-99)    );
  // itree = 230
  fBoostWeights.push_back(0.127566);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.905436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462727,-99) , 
71, 51.2245, 0, 0, 0.738836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478054,-99) , 
105, 94.9967, 0, 0, 0.497421,-99) , 
78, 9.05047, 1, 0, 0.523049,-99)    );
  // itree = 231
  fBoostWeights.push_back(0.202612);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475655,-99) , 
2, 14.4032, 0, 0, 0.556406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.116361,-99) , 
31, 5.04345, 1, 0, 0.271114,-99) , 
81, 58.9193, 1, 0, 0.532748,-99)    );
  // itree = 232
  fBoostWeights.push_back(0.175531);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 55.5316, 1, 1, 0.56792,-99) , 
NN(
0, 
0, 
-1, 9.06524, 1, -1, 0.359275,-99) , 
249, 15.1875, 0, 0, 0.513598,-99)    );
  // itree = 233
  fBoostWeights.push_back(0.196573);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.11226,-99) , 
151, 48.2605, 0, 0, 0.555354,-99) , 
NN(
0, 
0, 
-1, 66.6997, 1, -1, 0.22563,-99) , 
53, 21.5033, 0, 0, 0.531262,-99)    );
  // itree = 234
  fBoostWeights.push_back(0.221557);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 9.23406, 1, 1, 0.566475,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.147115,-99) , 
160, 21.0333, 1, 0, 0.386667,-99) , 
136, 83.402, 1, 0, 0.513061,-99)    );
  // itree = 235
  fBoostWeights.push_back(0.323071);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325932,-99) , 
113, 53.3742, 1, 0, 0.564807,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31177,-99) , 
147, 31.7732, 1, 0, 0.379576,-99) , 
120, 75.9571, 1, 0, 0.469433,-99)    );
  // itree = 236
  fBoostWeights.push_back(0.233931);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423018,-99) , 
208, -0.780528, 1, 0, 0.451466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.096741,-99) , 
94, 68.309, 1, 0, 0.427586,-99)    );
  // itree = 237
  fBoostWeights.push_back(0.28101);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40561,-99) , 
43, 23.7618, 0, 0, 0.529808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216129,-99) , 
11, 50.2589, 0, 0, 0.307694,-99) , 
30, 24.3607, 1, 0, 0.477685,-99)    );
  // itree = 238
  fBoostWeights.push_back(0.296916);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263862,-99) , 
57, 21.2652, 0, 0, 0.743002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410942,-99) , 
147, 24.3327, 1, 0, 0.45061,-99) , 
246, 45.5922, 0, 0, 0.50009,-99)    );
  // itree = 239
  fBoostWeights.push_back(0.180938);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378639,-99) , 
155, 41.1474, 1, 0, 0.693294,-99) , 
NN(
0, 
0, 
-1, 67.6362, 1, -1, 0.43726,-99) , 
173, 17.682, 1, 0, 0.472834,-99)    );
  // itree = 240
  fBoostWeights.push_back(0.243589);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468032,-99) , 
193, 23.8841, 1, 0, 0.571364,-99) , 
NN(
0, 
0, 
-1, 15.3277, 0, -1, 0.308208,-99) , 
246, 10.2488, 0, 0, 0.520676,-99)    );
  // itree = 241
  fBoostWeights.push_back(0.231952);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421495,-99) , 
15, 7.88889, 1, 0, 0.748709,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459086,-99) , 
146, 10.4868, 1, 0, 0.485303,-99) , 
45, 12.707, 1, 0, 0.549428,-99)    );
  // itree = 242
  fBoostWeights.push_back(0.226084);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.913104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314626,-99) , 
36, 60.6501, 1, 0, 0.554839,-99) , 
55, 90.4601, 0, 0, 0.572393,-99)    );
  // itree = 243
  fBoostWeights.push_back(0.188422);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.117935,-99) , 
248, 7.18062, 0, 0, 0.53341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.094812,-99) , 
87, 43.3017, 0, 0, 0.512901,-99)    );
  // itree = 244
  fBoostWeights.push_back(0.210619);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484001,-99) , 
245, 28.3905, 0, 0, 0.559955,-99) , 
NN(
0, 
0, 
-1, 48.325, 0, -1, 0.256306,-99) , 
5, 9.73209, 0, 0, 0.518551,-99)    );
  // itree = 245
  fBoostWeights.push_back(0.249831);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190558,-99) , 
170, 76.7716, 1, 0, 0.624055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27353,-99) , 
13, 12.517, 1, 0, 0.44098,-99) , 
57, 54.7886, 0, 0, 0.515904,-99)    );
  // itree = 246
  fBoostWeights.push_back(0.274048);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 57.9072, 0, 1, 0.60342,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319185,-99) , 
239, 3.3316, 1, 0, 0.388516,-99) , 
9, 19.0982, 0, 0, 0.530196,-99)    );
  // itree = 247
  fBoostWeights.push_back(0.076119);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498422,-99) , 
177, 5.21912, 1, 0, 0.520907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0141161,-99) , 
151, 46.7932, 0, 0, 0.505437,-99)    );
  // itree = 248
  fBoostWeights.push_back(0.268293);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466827,-99) , 
67, 49.7462, 0, 0, 0.741084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36843,-99) , 
203, 36.3689, 0, 0, 0.512959,-99) , 
222, 5.8354, 1, 0, 0.548484,-99)    );
  // itree = 249
  fBoostWeights.push_back(0.195999);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18724,-99) , 
237, 4.71638, 0, 0, 0.496737,-99) , 
NN(
0, 
0, 
-1, 49.7908, 1, -1, 0.281001,-99) , 
127, 41.8891, 1, 0, 0.452694,-99)    );
  // itree = 250
  fBoostWeights.push_back(0.281449);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 45.5423, 1, 1, 0.830789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387545,-99) , 
192, 5.05584, 1, 0, 0.432787,-99) , 
143, 4.92801, 1, 0, 0.456325,-99)    );
  // itree = 251
  fBoostWeights.push_back(0.205848);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490945,-99) , 
71, 66.8706, 0, 0, 0.551957,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241024,-99) , 
130, 21.8234, 1, 0, 0.330756,-99) , 
88, 85.445, 1, 0, 0.511082,-99)    );
  // itree = 252
  fBoostWeights.push_back(0.287117);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27006,-99) , 
67, 71.9583, 1, 0, 0.588607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.101838,-99) , 
135, 67.8236, 1, 0, 0.295754,-99) , 
110, 55.8036, 1, 0, 0.554602,-99)    );
  // itree = 253
  fBoostWeights.push_back(0.170742);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 48.8376, 0, 1, 0.567624,-99) , 
NN(
0, 
0, 
-1, 40.4437, 0, -1, 0.384581,-99) , 
157, 49.7523, 1, 0, 0.502798,-99)    );
  // itree = 254
  fBoostWeights.push_back(0.148944);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380392,-99) , 
53, 30.2944, 0, 0, 0.695339,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184001,-99) , 
25, 16.0028, 0, 0, 0.467723,-99) , 
229, 53.549, 0, 0, 0.499783,-99)    );
  // itree = 255
  fBoostWeights.push_back(0.245354);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83823,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404236,-99) , 
233, 60.1397, 0, 0, 0.435074,-99) , 
204, 9.30558, 1, 0, 0.45845,-99)    );
  // itree = 256
  fBoostWeights.push_back(0.284175);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424788,-99) , 
185, 60.1606, 0, 0, 0.528914,-99) , 
NN(
0, 
0, 
-1, 48.7659, 0, -1, 0.266472,-99) , 
56, 31.9533, 0, 0, 0.488386,-99)    );
  // itree = 257
  fBoostWeights.push_back(0.156836);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289615,-99) , 
103, 57.9027, 0, 0, 0.508472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.107769,-99) , 
63, 44.4734, 1, 0, 0.487978,-99)    );
  // itree = 258
  fBoostWeights.push_back(0.241405);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401369,-99) , 
231, 20.8777, 0, 0, 0.554288,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178873,-99) , 
166, 95.5251, 1, 0, 0.53313,-99)    );
  // itree = 259
  fBoostWeights.push_back(0.200995);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446109,-99) , 
149, 56.3833, 1, 0, 0.505586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132401,-99) , 
2, -1.79474, 0, 0, 0.483869,-99)    );
  // itree = 260
  fBoostWeights.push_back(0.145635);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325796,-99) , 
109, 14.8354, 0, 0, 0.702769,-99) , 
NN(
0, 
0, 
-1, 96.1698, 1, -1, 0.466406,-99) , 
143, 9.50626, 1, 0, 0.503657,-99)    );
  // itree = 261
  fBoostWeights.push_back(0.219024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367353,-99) , 
4, 9.25723, 0, 0, 0.520766,-99) , 
NN(
0, 
0, 
-1, 6.44589, 1, -1, 0.233016,-99) , 
102, 90.1646, 1, 0, 0.484645,-99)    );
  // itree = 262
  fBoostWeights.push_back(0.263092);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322928,-99) , 
255, 8.96538, 1, 0, 0.639714,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427833,-99) , 
218, 76.6081, 0, 0, 0.456789,-99) , 
83, 53.3316, 0, 0, 0.522631,-99)    );
  // itree = 263
  fBoostWeights.push_back(0.282975);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 7.60806, 0, 1, 0.615885,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357456,-99) , 
99, 21.9252, 1, 0, 0.395915,-99) , 
195, 37.2137, 0, 0, 0.490895,-99)    );
  // itree = 264
  fBoostWeights.push_back(0.255239);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446813,-99) , 
231, 30.3401, 0, 0, 0.533503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22683,-99) , 
12, 8.83232, 1, 0, 0.360096,-99) , 
56, 43.0832, 0, 0, 0.470293,-99)    );
  // itree = 265
  fBoostWeights.push_back(0.248688);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476166,-99) , 
152, 71.9668, 0, 0, 0.576648,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338821,-99) , 
10, 21.1358, 0, 0, 0.400507,-99) , 
59, 29.167, 0, 0, 0.520817,-99)    );
  // itree = 266
  fBoostWeights.push_back(0.182838);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 85.9829, 0, 1, 0.578447,-99) , 
NN(
0, 
0, 
-1, 29.2888, 1, -1, 0.235849,-99) , 
128, 54.3902, 1, 0, 0.55637,-99)    );
  // itree = 267
  fBoostWeights.push_back(0.207365);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.916976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494846,-99) , 
103, 82.7795, 1, 0, 0.732397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438036,-99) , 
64, 7.28938, 1, 0, 0.483507,-99) , 
6, 46.2312, 0, 0, 0.514399,-99)    );
  // itree = 268
  fBoostWeights.push_back(0.146871);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279474,-99) , 
196, 20.2445, 0, 0, 0.50033,-99) , 
89, 98.397, 0, 0, 0.518587,-99)    );
  // itree = 269
  fBoostWeights.push_back(0.320884);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374743,-99) , 
111, 42.0913, 1, 0, 0.605553,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356813,-99) , 
108, 28.5856, 1, 0, 0.416863,-99) , 
209, 13.362, 1, 0, 0.494062,-99)    );
  // itree = 270
  fBoostWeights.push_back(0.187448);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 23.3083, 1, 1, 0.546757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222913,-99) , 
115, 23.1957, 1, 0, 0.336233,-99) , 
175, 36.0691, 1, 0, 0.498397,-99)    );
  // itree = 271
  fBoostWeights.push_back(0.244991);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38337,-99) , 
216, 23.8365, 0, 0, 0.590656,-99) , 
NN(
0, 
0, 
-1, 20.152, 0, -1, 0.416412,-99) , 
6, 29.516, 0, 0, 0.488174,-99)    );
  // itree = 272
  fBoostWeights.push_back(0.227174);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 20.9079, 1, 1, 0.787214,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421446,-99) , 
252, 32.4914, 0, 0, 0.467932,-99) , 
88, 91.9034, 0, 0, 0.494067,-99)    );
  // itree = 273
  fBoostWeights.push_back(0.247838);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410961,-99) , 
183, 50.812, 0, 0, 0.607349,-99) , 
NN(
0, 
0, 
-1, 27.7836, 1, -1, 0.427897,-99) , 
96, 21.3815, 1, 0, 0.517375,-99)    );
  // itree = 274
  fBoostWeights.push_back(0.285671);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244771,-99) , 
167, 86.7556, 1, 0, 0.560373,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282576,-99) , 
214, 75.9479, 0, 0, 0.335998,-99) , 
2, 6.1119, 0, 0, 0.503208,-99)    );
  // itree = 275
  fBoostWeights.push_back(0.260288);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 20.6153, 0, 1, 0.652828,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36567,-99) , 
23, 42.3891, 0, 0, 0.464738,-99) , 
33, 11.6628, 1, 0, 0.527032,-99)    );
  // itree = 276
  fBoostWeights.push_back(0.155695);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479266,-99) , 
139, 50.3229, 1, 0, 0.533893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.077277,-99) , 
185, 29.7153, 0, 0, 0.514929,-99)    );
  // itree = 277
  fBoostWeights.push_back(0.0880697);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.903351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495635,-99) , 
159, 4.69505, 1, 0, 0.519827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0994317,-99) , 
131, 90.218, 1, 0, 0.501903,-99)    );
  // itree = 278
  fBoostWeights.push_back(0.143716);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48365,-99) , 
142, 15.2164, 1, 0, 0.519104,-99) , 
NN(
0, 
0, 
-1, 4.50331, 0, -1, 0.226516,-99) , 
69, 81.6473, 1, 0, 0.488098,-99)    );
  // itree = 279
  fBoostWeights.push_back(0.201152);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.933272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4998,-99) , 
13, 21.4416, 0, 0, 0.830985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215696,-99) , 
212, 13.3889, 0, 0, 0.524757,-99) , 
146, 14.9433, 1, 0, 0.558326,-99)    );
  // itree = 280
  fBoostWeights.push_back(0.211501);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 66.6776, 0, 1, 0.798823,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426752,-99) , 
245, 35.2048, 0, 0, 0.475393,-99) , 
146, 14.7031, 1, 0, 0.501308,-99)    );
  // itree = 281
  fBoostWeights.push_back(0.17367);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 67.0663, 1, 1, 0.758591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254061,-99) , 
129, 66.3185, 1, 0, 0.490487,-99) , 
162, 20.3026, 1, 0, 0.544863,-99)    );
  // itree = 282
  fBoostWeights.push_back(0.239706);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469462,-99) , 
22, 26.3826, 0, 0, 0.712584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438667,-99) , 
189, 16.5328, 1, 0, 0.479662,-99) , 
192, 6.23216, 1, 0, 0.532865,-99)    );
  // itree = 283
  fBoostWeights.push_back(0.353224);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412368,-99) , 
199, 37.1217, 0, 0, 0.610526,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287782,-99) , 
94, 17.8487, 1, 0, 0.410659,-99) , 
26, 28.6523, 0, 0, 0.514959,-99)    );
  // itree = 284
  fBoostWeights.push_back(0.297254);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31417,-99) , 
25, 16.3485, 0, 0, 0.602223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336155,-99) , 
101, 78.4266, 0, 0, 0.421467,-99) , 
49, 17.4222, 1, 0, 0.495588,-99)    );
  // itree = 285
  fBoostWeights.push_back(0.222601);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429204,-99) , 
55, 42.8532, 0, 0, 0.54716,-99) , 
NN(
0, 
0, 
-1, 20.5852, 0, -1, 0.141013,-99) , 
133, 94.399, 1, 0, 0.520334,-99)    );
  // itree = 286
  fBoostWeights.push_back(0.098513);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 68.5292, 0, 1, 0.530915,-99) , 
NN(
0, 
0, 
-1, 39.8182, 1, -1, 0.224466,-99) , 
4, 4.78732, 0, 0, 0.508137,-99)    );
  // itree = 287
  fBoostWeights.push_back(0.244703);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382397,-99) , 
228, 11.0171, 0, 0, 0.682769,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337873,-99) , 
250, 22.3331, 0, 0, 0.448721,-99) , 
71, 80.455, 0, 0, 0.481387,-99)    );
  // itree = 288
  fBoostWeights.push_back(0.207629);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 65.0877, 1, 1, 0.652775,-99) , 
NN(
0, 
0, 
-1, 32.348, 1, -1, 0.430496,-99) , 
160, 16.8784, 1, 0, 0.518169,-99)    );
  // itree = 289
  fBoostWeights.push_back(0.224172);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365942,-99) , 
240, 9.91085, 1, 0, 0.68929,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267095,-99) , 
143, 30.3841, 1, 0, 0.433774,-99) , 
135, 65.1584, 1, 0, 0.4772,-99)    );
  // itree = 290
  fBoostWeights.push_back(0.226866);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361489,-99) , 
180, 67.0049, 1, 0, 0.517159,-99) , 
NN(
0, 
0, 
-1, 29.6456, 1, -1, 0.192582,-99) , 
48, 37.4037, 1, 0, 0.479972,-99)    );
  // itree = 291
  fBoostWeights.push_back(0.17182);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353672,-99) , 
96, 48.1081, 1, 0, 0.654439,-99) , 
NN(
0, 
0, 
-1, 83.8974, 1, -1, 0.445809,-99) , 
95, 8.59425, 1, 0, 0.478724,-99)    );
  // itree = 292
  fBoostWeights.push_back(0.0933818);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865577,-99) , 
NN(
0, 
0, 
-1, 14.319, 0, -1, 0.474313,-99) , 
75, 19.2476, 1, 0, 0.498336,-99)    );
  // itree = 293
  fBoostWeights.push_back(0.308181);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39782,-99) , 
132, 70.6901, 1, 0, 0.55704,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251014,-99) , 
145, 14.7622, 1, 0, 0.330987,-99) , 
170, 76.5316, 1, 0, 0.507415,-99)    );
  // itree = 294
  fBoostWeights.push_back(0.187435);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489303,-99) , 
63, 11.6978, 1, 0, 0.588738,-99) , 
NN(
0, 
0, 
-1, 49.3582, 0, -1, 0.416738,-99) , 
252, 14.0578, 0, 0, 0.504853,-99)    );
  // itree = 295
  fBoostWeights.push_back(0.167905);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463347,-99) , 
146, 21.7927, 1, 0, 0.503317,-99) , 
NN(
0, 
0, 
-1, 22.3346, 1, -1, 0.0560555,-99) , 
247, 5.82075, 0, 0, 0.478604,-99)    );
  // itree = 296
  fBoostWeights.push_back(0.329413);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154729,-99) , 
246, 64.3709, 1, 0, 0.62756,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295312,-99) , 
71, 81.7338, 0, 0, 0.410544,-99) , 
249, 16.2187, 0, 0, 0.553974,-99)    );
  // itree = 297
  fBoostWeights.push_back(0.299078);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265346,-99) , 
56, 30.8822, 0, 0, 0.648806,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422475,-99) , 
97, 9.40079, 1, 0, 0.462945,-99) , 
94, 25.3018, 1, 0, 0.539533,-99)    );
  // itree = 298
  fBoostWeights.push_back(0.229404);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165472,-99) , 
83, 84.1636, 1, 0, 0.567183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.137976,-99) , 
143, 56.004, 1, 0, 0.546912,-99)    );
  // itree = 299
  fBoostWeights.push_back(0.298131);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483418,-99) , 
87, 53.3085, 0, 0, 0.667086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27961,-99) , 
4, 22.9781, 0, 0, 0.424375,-99) , 
215, 53.8447, 0, 0, 0.499229,-99)    );
  // itree = 300
  fBoostWeights.push_back(0.127364);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 88.7461, 0, 1, 0.532272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0976156,-99) , 
219, 16.0459, 1, 0, 0.22266,-99) , 
153, 52.4959, 0, 0, 0.498752,-99)    );
  // itree = 301
  fBoostWeights.push_back(0.262468);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386587,-99) , 
64, 4.41563, 1, 0, 0.415466,-99) , 
208, -1.58719, 1, 0, 0.437954,-99)    );
  // itree = 302
  fBoostWeights.push_back(0.164656);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0899844,-99) , 
66, 74.7448, 1, 0, 0.540249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0586486,-99) , 
105, 43.8967, 0, 0, 0.521188,-99)    );
  // itree = 303
  fBoostWeights.push_back(0.273503);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395188,-99) , 
102, 67.9458, 0, 0, 0.523093,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0949007,-99) , 
136, 71.3381, 0, 0, 0.227026,-99) , 
185, 36.4253, 0, 0, 0.489045,-99)    );
  // itree = 304
  fBoostWeights.push_back(0.253794);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280207,-99) , 
24, 23.416, 1, 0, 0.633874,-99) , 
NN(
0, 
0, 
-1, 43.5993, 0, -1, 0.396866,-99) , 
232, 50.0836, 0, 0, 0.440229,-99)    );
  // itree = 305
  fBoostWeights.push_back(0.297198);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448852,-99) , 
249, 14.0216, 0, 0, 0.594797,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329731,-99) , 
154, 83.9931, 0, 0, 0.404862,-99) , 
6, 24.2233, 0, 0, 0.509387,-99)    );
  // itree = 306
  fBoostWeights.push_back(0.149764);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 15.3424, 1, 1, 0.55296,-99) , 
NN(
0, 
0, 
-1, 5.32216, 0, -1, 0.350368,-99) , 
47, 5.88027, 0, 0, 0.508182,-99)    );
  // itree = 307
  fBoostWeights.push_back(0.306411);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353571,-99) , 
113, 70.6311, 1, 0, 0.709025,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398455,-99) , 
162, 19.3931, 1, 0, 0.459564,-99) , 
126, 16.9659, 1, 0, 0.509831,-99)    );
  // itree = 308
  fBoostWeights.push_back(0.351051);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360921,-99) , 
87, 50.1308, 0, 0, 0.633651,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366251,-99) , 
24, 56.5371, 0, 0, 0.436378,-99) , 
234, 32.2056, 0, 0, 0.516379,-99)    );
  // itree = 309
  fBoostWeights.push_back(0.29531);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434733,-99) , 
224, 1.58032, 0, 0, 0.769027,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371575,-99) , 
75, 47.8257, 1, 0, 0.504115,-99) , 
178, 13.7139, 1, 0, 0.541914,-99)    );
  // itree = 310
  fBoostWeights.push_back(0.187001);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.947897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483858,-99) , 
253, 10.2789, 1, 0, 0.77565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271625,-99) , 
11, 11.1646, 0, 0, 0.485256,-99) , 
148, 84.4072, 0, 0, 0.512017,-99)    );
  // itree = 311
  fBoostWeights.push_back(0.248134);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442983,-99) , 
236, 17.1205, 0, 0, 0.547666,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274665,-99) , 
215, 64.1757, 0, 0, 0.382027,-99) , 
19, 14.8567, 0, 0, 0.490948,-99)    );
  // itree = 312
  fBoostWeights.push_back(0.200817);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 29.4101, 0, 1, 0.821404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385614,-99) , 
226, 13.2747, 0, 0, 0.481067,-99) , 
163, 19.3564, 1, 0, 0.505981,-99)    );
  // itree = 313
  fBoostWeights.push_back(0.176774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44808,-99) , 
142, 18.9319, 1, 0, 0.489924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0737101,-99) , 
65, 64.5401, 1, 0, 0.473565,-99)    );
  // itree = 314
  fBoostWeights.push_back(0.305608);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386032,-99) , 
63, 26.4939, 1, 0, 0.59205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299582,-99) , 
253, 7.5012, 1, 0, 0.380791,-99) , 
137, 77.8335, 0, 0, 0.469163,-99)    );
  // itree = 315
  fBoostWeights.push_back(0.135375);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303864,-99) , 
186, 34.4843, 0, 0, 0.479974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0581121,-99) , 
42, 10.1658, 0, 0, 0.46408,-99)    );
  // itree = 316
  fBoostWeights.push_back(0.1562);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474097,-99) , 
94, 16.9323, 1, 0, 0.518927,-99) , 
NN(
0, 
0, 
-1, 25.6336, 1, -1, 0.18713,-99) , 
160, 52.1363, 1, 0, 0.49447,-99)    );
  // itree = 317
  fBoostWeights.push_back(0.16944);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436049,-99) , 
119, 82.4219, 1, 0, 0.682957,-99) , 
NN(
0, 
0, 
-1, 6.61488, 0, -1, 0.460376,-99) , 
137, 84.1221, 0, 0, 0.515084,-99)    );
  // itree = 318
  fBoostWeights.push_back(0.255479);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.175234,-99) , 
125, 82.1122, 1, 0, 0.632715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265514,-99) , 
136, 84.2067, 1, 0, 0.442322,-99) , 
132, 55.8853, 1, 0, 0.533782,-99)    );
  // itree = 319
  fBoostWeights.push_back(0.180994);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.950559,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43887,-99) , 
146, 15.1529, 1, 0, 0.463111,-99) , 
23, 73.7028, 0, 0, 0.479518,-99)    );
  // itree = 320
  fBoostWeights.push_back(0.21477);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459786,-99) , 
132, 53.9002, 1, 0, 0.535509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0675169,-99) , 
201, 21.942, 0, 0, 0.505576,-99)    );
  // itree = 321
  fBoostWeights.push_back(0.289994);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621082,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158136,-99) , 
105, 43.5496, 0, 0, 0.602064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0614452,-99) , 
145, 10.8322, 1, 0, 0.255035,-99) , 
140, 81.4982, 1, 0, 0.578075,-99)    );
  // itree = 322
  fBoostWeights.push_back(0.23202);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47364,-99) , 
163, 32.8177, 1, 0, 0.522015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280851,-99) , 
245, 12.3193, 0, 0, 0.333796,-99) , 
245, 13.8881, 0, 0, 0.46471,-99)    );
  // itree = 323
  fBoostWeights.push_back(0.258191);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352533,-99) , 
112, 37.9926, 1, 0, 0.532109,-99) , 
NN(
0, 
0, 
-1, 32.7469, 0, -1, 0.303305,-99) , 
19, 11.5867, 0, 0, 0.479582,-99)    );
  // itree = 324
  fBoostWeights.push_back(0.214099);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47076,-99) , 
115, 55.053, 0, 0, 0.544937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205786,-99) , 
114, 74.674, 0, 0, 0.288719,-99) , 
50, 48.9879, 1, 0, 0.51049,-99)    );
  // itree = 325
  fBoostWeights.push_back(0.243992);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238555,-99) , 
133, 94.399, 1, 0, 0.574433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153952,-99) , 
0, 2.10702, 0, 0, 0.29818,-99) , 
159, 47.1276, 1, 0, 0.547839,-99)    );
  // itree = 326
  fBoostWeights.push_back(0.224916);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386202,-99) , 
137, 59.3636, 0, 0, 0.63286,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26347,-99) , 
130, 44.3428, 1, 0, 0.446345,-99) , 
126, 21.6721, 1, 0, 0.497912,-99)    );
  // itree = 327
  fBoostWeights.push_back(0.199904);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451333,-99) , 
148, 83.5754, 0, 0, 0.482883,-99) , 
NN(
0, 
0, 
-1, 49.0449, 1, -1, 0.207553,-99) , 
201, 29.0662, 0, 0, 0.446042,-99)    );
  // itree = 328
  fBoostWeights.push_back(0.147793);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 8.85884, 1, 1, 0.531137,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152865,-99) , 
40, 51.0422, 1, 0, 0.261358,-99) , 
229, 13.8585, 0, 0, 0.48699,-99)    );
  // itree = 329
  fBoostWeights.push_back(0.239762);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 18.0941, 1, 1, 0.576358,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197137,-99) , 
58, 22.4486, 1, 0, 0.303601,-99) , 
39, 26.3938, 0, 0, 0.52155,-99)    );
  // itree = 330
  fBoostWeights.push_back(0.0972376);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488547,-99) , 
216, 15.0638, 1, 0, 0.508315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173631,-99) , 
136, 95.46, 1, 0, 0.487269,-99)    );
  // itree = 331
  fBoostWeights.push_back(0.187395);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458565,-99) , 
68, 55.2388, 0, 0, 0.517677,-99) , 
NN(
0, 
0, 
-1, 31.6165, 1, -1, 0.154921,-99) , 
218, 15.5517, 0, 0, 0.492685,-99)    );
  // itree = 332
  fBoostWeights.push_back(0.310912);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302552,-99) , 
54, 23.6222, 0, 0, 0.60843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343973,-99) , 
7, 38.2334, 0, 0, 0.451007,-99) , 
231, 38.8326, 0, 0, 0.510445,-99)    );
  // itree = 333
  fBoostWeights.push_back(0.257428);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 88.8726, 0, 1, 0.595671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354822,-99) , 
143, 8.44606, 1, 0, 0.409978,-99) , 
65, 17.7646, 1, 0, 0.47561,-99)    );
  // itree = 334
  fBoostWeights.push_back(0.216818);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489538,-99) , 
163, 34.9055, 1, 0, 0.546604,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303139,-99) , 
208, -1.57993, 1, 0, 0.358323,-99) , 
111, 32.1925, 1, 0, 0.490572,-99)    );
  // itree = 335
  fBoostWeights.push_back(0.182548);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0732208,-99) , 
176, 51.3813, 1, 0, 0.550355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0504841,-99) , 
214, 13.0308, 0, 0, 0.531137,-99)    );
  // itree = 336
  fBoostWeights.push_back(0.261599);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165395,-99) , 
2, -2.17103, 0, 0, 0.551397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184516,-99) , 
238, 2.29557, 1, 0, 0.270783,-99) , 
71, 82.5414, 1, 0, 0.507911,-99)    );
  // itree = 337
  fBoostWeights.push_back(0.173402);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.93449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440323,-99) , 
6, 56.8508, 0, 0, 0.461271,-99) , 
215, 80.7662, 0, 0, 0.476798,-99)    );
  // itree = 338
  fBoostWeights.push_back(0.29655);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410405,-99) , 
173, 36.309, 1, 0, 0.521948,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.150517,-99) , 
87, 85.1701, 0, 0, 0.232625,-99) , 
184, 39.5163, 0, 0, 0.478887,-99)    );
  // itree = 339
  fBoostWeights.push_back(0.141943);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471954,-99) , 
193, 43.5485, 0, 0, 0.501096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.140424,-99) , 
160, 54.4857, 1, 0, 0.479661,-99)    );
  // itree = 340
  fBoostWeights.push_back(0.213524);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490711,-99) , 
151, 72.6589, 1, 0, 0.569993,-99) , 
NN(
0, 
0, 
-1, 15.3115, 0, -1, 0.219521,-99) , 
216, 22.4069, 0, 0, 0.527549,-99)    );
  // itree = 341
  fBoostWeights.push_back(0.38013);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299272,-99) , 
104, 51.4529, 0, 0, 0.647669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275934,-99) , 
147, 31.2083, 1, 0, 0.415932,-99) , 
62, 19.9188, 1, 0, 0.529625,-99)    );
  // itree = 342
  fBoostWeights.push_back(0.200661);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171872,-99) , 
111, 56.3202, 1, 0, 0.553702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131838,-99) , 
42, 11.3855, 0, 0, 0.533673,-99)    );
  // itree = 343
  fBoostWeights.push_back(0.223053);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397375,-99) , 
85, 70.8043, 0, 0, 0.455634,-99) , 
112, 3.25208, 1, 0, 0.476505,-99)    );
  // itree = 344
  fBoostWeights.push_back(0.242657);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42107,-99) , 
159, 9.69883, 1, 0, 0.46205,-99) , 
NN(
0, 
0, 
-1, 7.59827, 1, -1, 0.161017,-99) , 
115, 78.4875, 1, 0, 0.4326,-99)    );
  // itree = 345
  fBoostWeights.push_back(0.28058);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 21.8933, 0, 1, 0.641192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375455,-99) , 
99, 36.9418, 1, 0, 0.440288,-99) , 
217, 44.6311, 0, 0, 0.529844,-99)    );
  // itree = 346
  fBoostWeights.push_back(0.246609);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379601,-99) , 
0, 6.19885, 1, 0, 0.641717,-99) , 
NN(
0, 
0, 
-1, 8.98527, 0, -1, 0.403207,-99) , 
50, 17.2216, 1, 0, 0.459575,-99)    );
  // itree = 347
  fBoostWeights.push_back(0.137482);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 17.1385, 0, 1, 0.715771,-99) , 
NN(
0, 
0, 
-1, 11.3148, 0, -1, 0.471199,-99) , 
39, 62.5814, 0, 0, 0.522882,-99)    );
  // itree = 348
  fBoostWeights.push_back(0.180763);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479734,-99) , 
112, 18.2862, 1, 0, 0.548521,-99) , 
NN(
0, 
0, 
-1, 30.1344, 0, -1, 0.201251,-99) , 
151, 49.9269, 0, 0, 0.525349,-99)    );
  // itree = 349
  fBoostWeights.push_back(0.240701);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359036,-99) , 
69, 30.4141, 0, 0, 0.601131,-99) , 
NN(
0, 
0, 
-1, 27.6205, 1, -1, 0.425309,-99) , 
252, 14.2053, 0, 0, 0.523097,-99)    );
  // itree = 350
  fBoostWeights.push_back(0.226767);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44843,-99) , 
39, 26.5645, 0, 0, 0.623486,-99) , 
NN(
0, 
0, 
-1, 32.2035, 0, -1, 0.44417,-99) , 
244, 18.0294, 0, 0, 0.544366,-99)    );
  // itree = 351
  fBoostWeights.push_back(0.204149);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.918512,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376033,-99) , 
22, 24.5943, 0, 0, 0.512125,-99) , 
222, 51.9368, 0, 0, 0.529472,-99)    );
  // itree = 352
  fBoostWeights.push_back(0.21212);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277332,-99) , 
245, 6.89593, 0, 0, 0.54249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.138915,-99) , 
28, 2.66547, 0, 0, 0.523683,-99)    );
  // itree = 353
  fBoostWeights.push_back(0.202999);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 77.1703, 0, 1, 0.698364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451121,-99) , 
215, 60.9106, 0, 0, 0.4965,-99) , 
137, 86.2476, 0, 0, 0.540749,-99)    );
  // itree = 354
  fBoostWeights.push_back(0.287602);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.123632,-99) , 
200, 22.0765, 0, 0, 0.583883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211532,-99) , 
59, 19.2554, 1, 0, 0.324746,-99) , 
8, 12.24, 0, 0, 0.539022,-99)    );
  // itree = 355
  fBoostWeights.push_back(0.260014);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278636,-99) , 
248, 29.8601, 0, 0, 0.678018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427658,-99) , 
71, 90.224, 0, 0, 0.461009,-99) , 
215, 58.3091, 0, 0, 0.507576,-99)    );
  // itree = 356
  fBoostWeights.push_back(0.208327);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.77476, 1, 1, 0.671735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439701,-99) , 
6, 47.7202, 0, 0, 0.468454,-99) , 
135, 67.6438, 1, 0, 0.52602,-99)    );
  // itree = 357
  fBoostWeights.push_back(0.184216);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491028,-99) , 
105, 49.8242, 0, 0, 0.788215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456112,-99) , 
202, 82.8503, 0, 0, 0.482689,-99) , 
110, 11.6645, 1, 0, 0.518199,-99)    );
  // itree = 358
  fBoostWeights.push_back(0.274331);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 7.24337, 0, 1, 0.820396,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328919,-99) , 
33, 26.5585, 1, 0, 0.529321,-99) , 
173, 17.682, 1, 0, 0.565117,-99)    );
  // itree = 359
  fBoostWeights.push_back(0.171418);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 62.3098, 0, 1, 0.546947,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239348,-99) , 
131, 33.169, 1, 0, 0.342456,-99) , 
232, 18.0518, 0, 0, 0.507242,-99)    );
  // itree = 360
  fBoostWeights.push_back(0.180286);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456753,-99) , 
5, 21.3197, 0, 0, 0.534109,-99) , 
NN(
0, 
0, 
-1, 89.5219, 1, -1, 0.176984,-99) , 
213, 15.1475, 0, 0, 0.5134,-99)    );
  // itree = 361
  fBoostWeights.push_back(0.18729);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478339,-99) , 
38, 18.0771, 0, 0, 0.723841,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310737,-99) , 
131, 66.8803, 1, 0, 0.486017,-99) , 
230, 57.1975, 0, 0, 0.518831,-99)    );
  // itree = 362
  fBoostWeights.push_back(0.193842);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477492,-99) , 
84, 32.968, 1, 0, 0.519368,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164653,-99) , 
246, 18.5552, 0, 0, 0.240613,-99) , 
228, 10.8526, 0, 0, 0.472113,-99)    );
  // itree = 363
  fBoostWeights.push_back(0.357074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306406,-99) , 
149, 85.5062, 1, 0, 0.608164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323896,-99) , 
100, 42.7952, 1, 0, 0.427195,-99) , 
127, 23.0442, 1, 0, 0.513903,-99)    );
  // itree = 364
  fBoostWeights.push_back(0.289814);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452749,-99) , 
170, 53.201, 0, 0, 0.565318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207545,-99) , 
27, 26.4895, 0, 0, 0.299814,-99) , 
21, 15.7864, 0, 0, 0.511426,-99)    );
  // itree = 365
  fBoostWeights.push_back(0.252367);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327892,-99) , 
23, 14.3883, 0, 0, 0.558183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201369,-99) , 
240, 5.83778, 0, 0, 0.314229,-99) , 
121, 88.0984, 1, 0, 0.518147,-99)    );
  // itree = 366
  fBoostWeights.push_back(0.231058);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409133,-99) , 
220, 24.2223, 1, 0, 0.493664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0521643,-99) , 
151, 48.2605, 0, 0, 0.473364,-99)    );
  // itree = 367
  fBoostWeights.push_back(0.128339);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.921584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296453,-99) , 
232, 19.0757, 0, 0, 0.460457,-99) , 
254, -2.97958, 1, 0, 0.47935,-99)    );
  // itree = 368
  fBoostWeights.push_back(0.195546);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487094,-99) , 
160, 17.8082, 1, 0, 0.555868,-99) , 
NN(
0, 
0, 
-1, 19.9658, 1, -1, 0.229542,-99) , 
127, 51.0578, 1, 0, 0.516273,-99)    );
  // itree = 369
  fBoostWeights.push_back(0.235576);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 70.3391, 1, 1, 0.74557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430358,-99) , 
107, 94.389, 0, 0, 0.449088,-99) , 
174, 15.1826, 1, 0, 0.509834,-99)    );
  // itree = 370
  fBoostWeights.push_back(0.229072);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492519,-99) , 
217, 42.3584, 0, 0, 0.557158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327881,-99) , 
214, 75.5869, 0, 0, 0.382619,-99) , 
54, 46.6014, 0, 0, 0.48679,-99)    );
  // itree = 371
  fBoostWeights.push_back(0.251469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393073,-99) , 
115, 68.1837, 1, 0, 0.555179,-99) , 
NN(
0, 
0, 
-1, 60.8618, 1, -1, 0.241986,-99) , 
159, 48.2222, 1, 0, 0.53332,-99)    );
  // itree = 372
  fBoostWeights.push_back(0.225168);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 58.8529, 1, 1, 0.793007,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398399,-99) , 
160, 20.0613, 1, 0, 0.500652,-99) , 
189, 12.0302, 1, 0, 0.530966,-99)    );
  // itree = 373
  fBoostWeights.push_back(0.284675);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224253,-99) , 
203, 16.0759, 0, 0, 0.654812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403166,-99) , 
39, 64.8848, 0, 0, 0.454786,-99) , 
123, 47.0998, 1, 0, 0.504672,-99)    );
  // itree = 374
  fBoostWeights.push_back(0.277425);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424214,-99) , 
42, 32.7097, 0, 0, 0.544657,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.126589,-99) , 
226, 2.45355, 1, 0, 0.237853,-99) , 
63, 35.6603, 1, 0, 0.506812,-99)    );
  // itree = 375
  fBoostWeights.push_back(0.231095);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 6.41075, 0, 1, 0.820225,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415949,-99) , 
80, 8.37821, 1, 0, 0.456255,-99) , 
229, 61.9869, 0, 0, 0.487035,-99)    );
  // itree = 376
  fBoostWeights.push_back(0.207524);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481857,-99) , 
7, 11.9284, 0, 0, 0.745152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466584,-99) , 
117, 81.8168, 0, 0, 0.522883,-99) , 
32, 3.75551, 1, 0, 0.558513,-99)    );
  // itree = 377
  fBoostWeights.push_back(0.379264);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252403,-99) , 
30, 0.159145, 0, 0, 0.631919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269339,-99) , 
67, 26.4873, 1, 0, 0.379751,-99) , 
195, 21.6722, 0, 0, 0.560782,-99)    );
  // itree = 378
  fBoostWeights.push_back(0.20842);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 9.86905, 1, 1, 0.802483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244045,-99) , 
191, 28.6842, 1, 0, 0.471995,-99) , 
252, 40.6422, 0, 0, 0.49955,-99)    );
  // itree = 379
  fBoostWeights.push_back(0.206769);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.952217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460468,-99) , 
124, 82.156, 1, 0, 0.788597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342746,-99) , 
143, 31.8622, 1, 0, 0.481789,-99) , 
163, 19.5715, 1, 0, 0.506172,-99)    );
  // itree = 380
  fBoostWeights.push_back(0.165084);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 28.275, 0, 1, 0.699213,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.97696,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468028,-99) , 
142, 5.47737, 1, 0, 0.487694,-99) , 
252, 26.4038, 0, 0, 0.533696,-99)    );
  // itree = 381
  fBoostWeights.push_back(0.262379);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414163,-99) , 
144, 26.5663, 1, 0, 0.543506,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220344,-99) , 
205, 11.9637, 1, 0, 0.318122,-99) , 
186, 38.8456, 0, 0, 0.48568,-99)    );
  // itree = 382
  fBoostWeights.push_back(0.170181);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 13.9987, 1, 1, 0.564892,-99) , 
NN(
0, 
0, 
-1, 1.82661, 0, -1, 0.306977,-99) , 
246, 10.9758, 0, 0, 0.525869,-99)    );
  // itree = 383
  fBoostWeights.push_back(0.207903);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426782,-99) , 
178, 52.7467, 1, 0, 0.60055,-99) , 
NN(
0, 
0, 
-1, 79.9235, 1, -1, 0.41992,-99) , 
150, 80.715, 0, 0, 0.467036,-99)    );
  // itree = 384
  fBoostWeights.push_back(0.191194);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329992,-99) , 
142, 55.8794, 1, 0, 0.524872,-99) , 
NN(
0, 
0, 
-1, 23.6612, 0, -1, 0.181028,-99) , 
219, 9.56722, 0, 0, 0.503896,-99)    );
  // itree = 385
  fBoostWeights.push_back(0.245393);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404848,-99) , 
137, 68.3717, 1, 0, 0.600385,-99) , 
NN(
0, 
0, 
-1, 45.6099, 1, -1, 0.410036,-99) , 
14, 6.02737, 1, 0, 0.470571,-99)    );
  // itree = 386
  fBoostWeights.push_back(0.284921);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437458,-99) , 
178, 64.3644, 1, 0, 0.651174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377061,-99) , 
144, 12.115, 1, 0, 0.455826,-99) , 
110, 18.5347, 1, 0, 0.502701,-99)    );
  // itree = 387
  fBoostWeights.push_back(0.139472);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488278,-99) , 
117, 38.0625, 1, 0, 0.508459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.127057,-99) , 
85, 79.9098, 0, 0, 0.247685,-99) , 
152, 58.8811, 0, 0, 0.469617,-99)    );
  // itree = 388
  fBoostWeights.push_back(0.304869);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326935,-99) , 
70, 79.9764, 1, 0, 0.604888,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112852,-99) , 
66, 39.0663, 0, 0, 0.35228,-99) , 
255, 0.79865, 0, 0, 0.55084,-99)    );
  // itree = 389
  fBoostWeights.push_back(0.164059);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298626,-99) , 
88, 50.5935, 0, 0, 0.506405,-99) , 
NN(
0, 
0, 
-1, 16.6414, 0, -1, 0.138885,-99) , 
152, 95.0923, 1, 0, 0.483008,-99)    );
  // itree = 390
  fBoostWeights.push_back(0.11628);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 14.6411, 1, 1, 0.546395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.129521,-99) , 
66, 77.0096, 1, 0, 0.531622,-99)    );
  // itree = 391
  fBoostWeights.push_back(0.258081);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29474,-99) , 
22, 10.2608, 0, 0, 0.696481,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286049,-99) , 
54, 48.5328, 0, 0, 0.447481,-99) , 
232, 46.5345, 0, 0, 0.51274,-99)    );
  // itree = 392
  fBoostWeights.push_back(0.189604);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 7.08718, 1, 1, 0.776582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345415,-99) , 
42, 34.1245, 0, 0, 0.451212,-99) , 
141, 18.4844, 1, 0, 0.477919,-99)    );
  // itree = 393
  fBoostWeights.push_back(0.158516);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475966,-99) , 
37, 67.282, 0, 0, 0.500052,-99) , 
NN(
0, 
0, 
-1, 12.1413, 1, -1, 0.169487,-99) , 
65, 54.1644, 1, 0, 0.461155,-99)    );
  // itree = 394
  fBoostWeights.push_back(0.220429);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433192,-99) , 
28, 16.251, 1, 0, 0.780085,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271454,-99) , 
216, 26.5512, 0, 0, 0.451331,-99) , 
230, 50.3986, 0, 0, 0.513512,-99)    );
  // itree = 395
  fBoostWeights.push_back(0.212785);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466441,-99) , 
44, 49.8032, 0, 0, 0.519353,-99) , 
NN(
0, 
0, 
-1, 29.2129, 1, -1, 0.352102,-99) , 
255, 4.9534, 0, 0, 0.450222,-99)    );
  // itree = 396
  fBoostWeights.push_back(0.223713);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464757,-99) , 
181, 59.1884, 0, 0, 0.731283,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447619,-99) , 
38, 66.199, 0, 0, 0.485774,-99) , 
134, 85.1013, 0, 0, 0.5339,-99)    );
  // itree = 397
  fBoostWeights.push_back(0.249562);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459501,-99) , 
5, 14.2334, 0, 0, 0.625779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280036,-99) , 
5, 27.1979, 0, 0, 0.423148,-99) , 
216, 52.8016, 0, 0, 0.485347,-99)    );
  // itree = 398
  fBoostWeights.push_back(0.20942);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383236,-99) , 
122, 73.0639, 1, 0, 0.488892,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13015,-99) , 
219, 11.6647, 1, 0, 0.23174,-99) , 
233, 11.7988, 0, 0, 0.460237,-99)    );
  // itree = 399
  fBoostWeights.push_back(0.25982);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48304,-99) , 
169, 66.6001, 1, 0, 0.572196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197501,-99) , 
223, 8.81113, 0, 0, 0.359903,-99) , 
217, 33.4977, 0, 0, 0.489854,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
