// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:09:20 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 14000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
NTrees: "200" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "3" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 7
m_jj                          m_jj                          m_jj                          m_jj                                                            'F'    [0.151058629155,16.1319084167]
m_jjj                         m_jjj                         m_jjj                         m_jjj                                                           'F'    [0.342466980219,8.94014835358]
m_lv                          m_lv                          m_lv                          m_lv                                                            'F'    [0.26678776741,3.68225979805]
m_jlv                         m_jlv                         m_jlv                         m_jlv                                                           'F'    [0.384410560131,6.58312129974]
m_bb                          m_bb                          m_bb                          m_bb                                                            'F'    [0.0809864625335,8.25508308411]
m_wbb                         m_wbb                         m_wbb                         m_wbb                                                           'F'    [0.385025799274,6.40131282806]
m_wwbb                        m_wwbb                        m_wwbb                        m_wwbb                                                          'F'    [0.432279825211,4.53500270844]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 7 )
   {
      // the training input variables
      const char* inputVars[] = { "m_jj", "m_jjj", "m_lv", "m_jlv", "m_bb", "m_wbb", "m_wwbb" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;
      fVmin[4] = 0;
      fVmax[4] = 0;
      fVmin[5] = 0;
      fVmax[5] = 0;
      fVmin[6] = 0;
      fVmax[6] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';
      fType[4] = 'F';
      fType[5] = 'F';
      fType[6] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[7];
   double fVmax[7];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[7];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.273943294645726);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396631,-99) , 
4, 0.580246, 0, 0, 0.566692,-99) , 
NN(
0, 
0, 
-1, 1.98014, 1, -1, 0.315483,-99) , 
4, 1.13023, 1, 0, 0.505527,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.197405);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465438,-99) , 
5, 0.873041, 0, 0, 0.546514,-99) , 
NN(
0, 
0, 
-1, 2.12164, 1, -1, 0.348869,-99) , 
4, 1.09527, 1, 0, 0.492859,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.197038);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441238,-99) , 
4, 0.621099, 0, 0, 0.547415,-99) , 
NN(
0, 
0, 
-1, 2.15445, 1, -1, 0.335681,-99) , 
4, 1.20288, 1, 0, 0.500697,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.198036);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469313,-99) , 
5, 0.869675, 0, 0, 0.55765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324758,-99) , 
1, 1.05614, 0, 0, 0.4045,-99) , 
6, 0.918482, 1, 0, 0.49227,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.210018);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417369,-99) , 
4, 0.993278, 1, 0, 0.548264,-99) , 
NN(
0, 
0, 
-1, 1.29762, 0, -1, 0.371504,-99) , 
6, 1.03973, 1, 0, 0.500713,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.163943);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440907,-99) , 
6, 0.969563, 1, 0, 0.531921,-99) , 
NN(
0, 
0, 
-1, 2.154, 1, -1, 0.358545,-99) , 
4, 1.20296, 1, 0, 0.494067,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.0985543);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398361,-99) , 
5, 0.743865, 0, 0, 0.502201,-99) , 
NN(
0, 
0, 
-1, 2.27892, 1, -1, 0.312438,-99) , 
4, 1.648, 1, 0, 0.485105,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.173991);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441563,-99) , 
5, 0.79801, 0, 0, 0.541232,-99) , 
NN(
0, 
0, 
-1, 1.12498, 0, -1, 0.410181,-99) , 
6, 0.922245, 1, 0, 0.485544,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.158381);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416887,-99) , 
4, 1.65804, 1, 0, 0.571713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367301,-99) , 
6, 0.864652, 1, 0, 0.456464,-99) , 
1, 1.01385, 0, 0, 0.497543,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.147946);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443503,-99) , 
5, 0.840715, 0, 0, 0.5116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34037,-99) , 
1, 1.29762, 0, 0, 0.402861,-99) , 
6, 1.04124, 1, 0, 0.482935,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.109658);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366842,-99) , 
4, 1.04409, 1, 0, 0.513432,-99) , 
NN(
0, 
0, 
-1, 1.00273, 0, -1, 0.410745,-99) , 
4, 1.20288, 1, 0, 0.491629,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.0802569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433429,-99) , 
4, 0.946534, 1, 0, 0.478912,-99) , 
NN(
0, 
0, 
-1, 1.19532, 0, -1, 0.338755,-99) , 
6, 1.37604, 1, 0, 0.467074,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.118926);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425184,-99) , 
6, 1.40099, 1, 0, 0.541611,-99) , 
NN(
0, 
0, 
-1, 0.913504, 1, -1, 0.444233,-99) , 
3, 1.02074, 0, 0, 0.479532,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.11927);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470409,-99) , 
5, 0.828243, 0, 0, 0.533908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39489,-99) , 
3, 1.06577, 0, 0, 0.449461,-99) , 
6, 0.848829, 1, 0, 0.486929,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.0914088);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46876,-99) , 
3, 0.724612, 1, 0, 0.488185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288293,-99) , 
4, 2.02059, 1, 0, 0.480623,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.161086);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464063,-99) , 
6, 1.23003, 1, 0, 0.576181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439455,-99) , 
1, 0.734923, 1, 0, 0.468856,-99) , 
1, 1.02931, 0, 0, 0.503978,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.0592058);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459957,-99) , 
4, 1.00864, 1, 0, 0.499651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330241,-99) , 
4, 2.0293, 1, 0, 0.493807,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.0884007);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482096,-99) , 
1, 1.01961, 0, 0, 0.510014,-99) , 
NN(
0, 
0, 
-1, 1.45068, 0, -1, 0.376191,-99) , 
6, 1.31115, 1, 0, 0.496289,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.0932459);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447488,-99) , 
4, 0.933265, 1, 0, 0.555326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371013,-99) , 
4, 0.65417, 0, 0, 0.47668,-99) , 
6, 0.823015, 1, 0, 0.506846,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.124585);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.840551, 0, 1, 0.559035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416095,-99) , 
3, 1.08808, 0, 0, 0.475698,-99) , 
6, 0.834484, 1, 0, 0.510497,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.117341);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.787471, 1, 1, 0.539886,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426676,-99) , 
1, 0.789863, 1, 0, 0.457898,-99) , 
1, 1.01385, 0, 0, 0.487323,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.0744506);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465962,-99) , 
6, 0.870545, 1, 0, 0.496885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279872,-99) , 
4, 2.03665, 1, 0, 0.488884,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.0659369);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290915,-99) , 
4, 2.2006, 1, 0, 0.504791,-99) , 
NN(
0, 
0, 
-1, 0.800956, 1, -1, 0.408247,-99) , 
5, 0.775717, 0, 0, 0.485844,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.0633599);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565936,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478318,-99) , 
3, 0.652955, 1, 0, 0.487231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310136,-99) , 
4, 2.04121, 1, 0, 0.48133,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.0988127);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493357,-99) , 
0, 0.899331, 1, 0, 0.535085,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448908,-99) , 
3, 1.25382, 0, 0, 0.469035,-99) , 
1, 1.01385, 0, 0, 0.492347,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.0769565);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470986,-99) , 
1, 1.01385, 0, 0, 0.495355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30347,-99) , 
4, 2.0272, 1, 0, 0.489123,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.0845454);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454956,-99) , 
4, 0.670677, 0, 0, 0.50835,-99) , 
NN(
0, 
0, 
-1, 1.06697, 1, -1, 0.410828,-99) , 
4, 1.45785, 1, 0, 0.496806,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.0698839);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480221,-99) , 
3, 0.790216, 1, 0, 0.501224,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373978,-99) , 
1, 1.19532, 0, 0, 0.437914,-99) , 
6, 1.18237, 1, 0, 0.491441,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.0892966);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.865387, 0, 1, 0.545987,-99) , 
NN(
0, 
0, 
-1, 0.98768, 0, -1, 0.457008,-99) , 
6, 0.881495, 1, 0, 0.502708,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.0781488);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46889,-99) , 
5, 0.873981, 0, 0, 0.509034,-99) , 
NN(
0, 
0, 
-1, 1.33079, 0, -1, 0.43691,-99) , 
6, 1.21375, 1, 0, 0.498654,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.0460143);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493063,-99) , 
4, 0.577404, 0, 0, 0.559313,-99) , 
NN(
0, 
0, 
-1, 1.27968, 1, -1, 0.48353,-99) , 
3, 0.679587, 1, 0, 0.493959,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.0807192);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.01385, 1, 1, 0.551179,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444151,-99) , 
6, 0.877649, 1, 0, 0.496045,-99) , 
3, 1.16085, 0, 0, 0.510127,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.0403642);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494528,-99) , 
3, 1.24922, 0, 0, 0.506524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365962,-99) , 
6, 1.60449, 1, 0, 0.500901,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.0591206);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423806,-99) , 
4, 0.46884, 0, 0, 0.507698,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342628,-99) , 
4, 2.04091, 1, 0, 0.501776,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.0812342);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47569,-99) , 
5, 0.842272, 0, 0, 0.515409,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420822,-99) , 
1, 1.08308, 0, 0, 0.460104,-99) , 
6, 0.959082, 1, 0, 0.495303,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.0681209);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462559,-99) , 
4, 0.927522, 1, 0, 0.501123,-99) , 
NN(
0, 
0, 
-1, 2.16357, 1, -1, 0.409066,-99) , 
4, 1.56266, 1, 0, 0.492309,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.0761762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448197,-99) , 
0, 0.753282, 0, 0, 0.571555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472025,-99) , 
3, 1.34671, 0, 0, 0.48092,-99) , 
1, 0.75188, 1, 0, 0.491082,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.0655463);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490166,-99) , 
4, 0.797561, 0, 0, 0.520267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330274,-99) , 
3, 1.01324, 0, 0, 0.432187,-99) , 
4, 1.57278, 1, 0, 0.512448,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.0691377);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449273,-99) , 
4, 0.969526, 1, 0, 0.542799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451903,-99) , 
3, 0.945513, 0, 0, 0.487655,-99) , 
3, 0.770664, 1, 0, 0.500904,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.0530233);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474358,-99) , 
1, 0.998144, 0, 0, 0.492341,-99) , 
1, 0.678158, 1, 0, 0.497103,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.0522119);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493181,-99) , 
0, 0.83514, 0, 0, 0.560903,-99) , 
NN(
0, 
0, 
-1, 1.10835, 1, -1, 0.485213,-99) , 
1, 0.825086, 1, 0, 0.501275,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.0310082);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.826171, 0, 1, 0.581063,-99) , 
NN(
0, 
0, 
-1, 2.04091, 1, -1, 0.495031,-99) , 
3, 0.684846, 1, 0, 0.506936,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.063749);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483571,-99) , 
5, 0.775654, 0, 0, 0.537043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435665,-99) , 
4, 0.683673, 0, 0, 0.49292,-99) , 
6, 0.842104, 1, 0, 0.511636,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.0370111);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497239,-99) , 
3, 0.733364, 1, 0, 0.510058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40967,-99) , 
3, 1.71178, 1, 0, 0.504639,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.0617474);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.766463, 0, 1, 0.534764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408065,-99) , 
5, 0.896675, 0, 0, 0.489384,-99) , 
4, 0.878633, 1, 0, 0.51314,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.0558944);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469971,-99) , 
4, 0.947134, 1, 0, 0.528821,-99) , 
NN(
0, 
0, 
-1, 0.90104, 0, -1, 0.482197,-99) , 
6, 0.828007, 1, 0, 0.501407,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.0500471);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486419,-99) , 
0, 0.714669, 0, 0, 0.582717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458791,-99) , 
5, 0.76071, 0, 0, 0.502189,-99) , 
1, 0.75188, 1, 0, 0.511297,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.0716521);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456974,-99) , 
0, 0.807431, 0, 0, 0.502129,-99) , 
NN(
0, 
0, 
-1, 1.18634, 0, -1, 0.426438,-99) , 
6, 1.16144, 1, 0, 0.489076,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.0675999);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371448,-99) , 
3, 1.96558, 1, 0, 0.533822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433964,-99) , 
6, 0.906491, 1, 0, 0.482971,-99) , 
3, 1.1923, 0, 0, 0.494888,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.0492358);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484539,-99) , 
1, 1.68523, 0, 0, 0.490891,-99) , 
6, 0.604259, 1, 0, 0.495957,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.0403725);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458227,-99) , 
5, 0.780977, 0, 0, 0.498991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373729,-99) , 
4, 1.96982, 1, 0, 0.49471,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.0913454);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.856721, 0, 1, 0.536522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441037,-99) , 
1, 1.16129, 0, 0, 0.468025,-99) , 
6, 0.848829, 1, 0, 0.498392,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.0873433);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398993,-99) , 
0, 0.577693, 0, 0, 0.546512,-99) , 
NN(
0, 
0, 
-1, 2.04121, 1, -1, 0.465885,-99) , 
1, 0.824237, 1, 0, 0.483971,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.0671691);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.686557, 0, 1, 0.59297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533687,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475588,-99) , 
1, 0.967761, 0, 0, 0.504345,-99) , 
1, 0.723444, 1, 0, 0.510623,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.0449276);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.991487, 0, 1, 0.52784,-99) , 
NN(
0, 
0, 
-1, 1.63215, 1, -1, 0.480918,-99) , 
3, 0.847872, 1, 0, 0.498953,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.045798);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484971,-99) , 
5, 0.832945, 0, 0, 0.511155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381369,-99) , 
0, 2.61717, 1, 0, 0.507484,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.0488696);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495126,-99) , 
1, 1.08496, 0, 0, 0.512713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424219,-99) , 
5, 1.08371, 0, 0, 0.463032,-99) , 
0, 1.12636, 1, 0, 0.502515,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.0516901);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485879,-99) , 
5, 0.921638, 0, 0, 0.504973,-99) , 
NN(
0, 
0, 
-1, 1.65478, 0, -1, 0.413345,-99) , 
6, 1.32696, 1, 0, 0.49596,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.0407677);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454571,-99) , 
0, 0.715245, 0, 0, 0.564426,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448072,-99) , 
0, 1.42482, 1, 0, 0.498169,-99) , 
1, 0.751032, 1, 0, 0.505281,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.0539678);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.740235, 1, 1, 0.54351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455833,-99) , 
3, 0.929498, 0, 0, 0.486015,-99) , 
3, 0.684846, 1, 0, 0.494075,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.0363469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492773,-99) , 
1, 0.751364, 1, 0, 0.500578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374056,-99) , 
3, 1.86029, 1, 0, 0.495358,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.0353514);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.30748, 0, 1, 0.513012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344182,-99) , 
4, 2.0272, 1, 0, 0.507508,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.0644894);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48678,-99) , 
6, 0.839286, 1, 0, 0.513946,-99) , 
NN(
0, 
0, 
-1, 1.07168, 0, -1, 0.455203,-99) , 
4, 1.03189, 1, 0, 0.495816,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.0582614);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.853778, 0, 1, 0.52785,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443967,-99) , 
3, 0.956778, 0, 0, 0.48812,-99) , 
6, 0.823015, 1, 0, 0.503103,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.0443232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434277,-99) , 
6, 1.09158, 1, 0, 0.493723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341057,-99) , 
3, 1.93729, 1, 0, 0.489167,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.041171);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455236,-99) , 
4, 0.961613, 1, 0, 0.485074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38262,-99) , 
6, 1.79985, 1, 0, 0.482462,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.0419318);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.753282, 0, 1, 0.564871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441247,-99) , 
5, 0.752025, 0, 0, 0.496335,-99) , 
1, 0.75188, 1, 0, 0.503388,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.0562344);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482324,-99) , 
0, 0.837918, 0, 0, 0.52149,-99) , 
NN(
0, 
0, 
-1, 0.776298, 0, -1, 0.475157,-99) , 
1, 0.825086, 1, 0, 0.484794,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.0366716);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487837,-99) , 
3, 0.814647, 1, 0, 0.49949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385642,-99) , 
4, 2.18722, 1, 0, 0.496599,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.0428554);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398868,-99) , 
3, 1.93729, 1, 0, 0.509706,-99) , 
NN(
0, 
0, 
-1, 0.843028, 1, -1, 0.440563,-99) , 
4, 0.470229, 0, 0, 0.501699,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.0176042);
  fForest.push_back( 
NN(
0, 
0, 
-1, 2.00859, 1, -1, 0.491199,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.0345222);
  fForest.push_back( 
NN(
0, 
0, 
-1, 1.72697, 1, -1, 0.482746,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.0405641);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.900973, 1, 1, 0.519246,-99) , 
NN(
0, 
0, 
-1, 0.986778, 1, -1, 0.478848,-99) , 
5, 0.958005, 0, 0, 0.497527,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.051491);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466502,-99) , 
4, 0.933315, 1, 0, 0.521833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388244,-99) , 
4, 0.618999, 0, 0, 0.485046,-99) , 
6, 0.823015, 1, 0, 0.499431,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.0460271);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47052,-99) , 
6, 1.04549, 1, 0, 0.548206,-99) , 
NN(
0, 
0, 
-1, 1.24405, 1, -1, 0.486319,-99) , 
2, 1.07434, 0, 0, 0.498362,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.0541313);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484793,-99) , 
1, 1.19513, 0, 0, 0.496583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302027,-99) , 
0, 0.956245, 1, 0, 0.404062,-99) , 
3, 1.71178, 1, 0, 0.491614,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.0475694);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489714,-99) , 
0, 2.46399, 1, 0, 0.581443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420041,-99) , 
0, 1.30696, 1, 0, 0.503946,-99) , 
1, 1.42953, 0, 0, 0.509351,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.0586161);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481189,-99) , 
3, 0.815677, 1, 0, 0.499408,-99) , 
1, 1.63629, 0, 0, 0.505579,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.0296454);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494859,-99) , 
5, 1.57288, 0, 0, 0.500952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36214,-99) , 
4, 2.0272, 1, 0, 0.496429,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.030308);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498767,-99) , 
3, 0.847872, 1, 0, 0.510346,-99) , 
NN(
0, 
0, 
-1, 0.694735, 1, -1, 0.462476,-99) , 
5, 0.716723, 0, 0, 0.50454,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.0618308);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47495, 1, 1, 0.592645,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473589,-99) , 
3, 0.974764, 0, 0, 0.493853,-99) , 
2, 1.24206, 0, 0, 0.501878,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.0572928);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.843625, 0, 1, 0.543969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449516,-99) , 
4, 0.821825, 0, 0, 0.485592,-99) , 
3, 0.733014, 1, 0, 0.497445,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.0561884);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459278,-99) , 
0, 1.2348, 1, 0, 0.512592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394723,-99) , 
4, 2.0272, 1, 0, 0.508566,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.052406);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.907796, 0, 1, 0.52017,-99) , 
NN(
0, 
0, 
-1, 1.06381, 0, -1, 0.469941,-99) , 
6, 0.823015, 1, 0, 0.489649,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.0773134);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476896,-99) , 
5, 0.912097, 0, 0, 0.50835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435632,-99) , 
1, 1.33079, 0, 0, 0.454745,-99) , 
4, 1.26414, 1, 0, 0.498761,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.0313849);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606668,-99) , 
NN(
0, 
0, 
-1, 1.29218, 1, -1, 0.488333,-99) , 
1, 1.71206, 0, 0, 0.493341,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.0679592);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476875,-99) , 
6, 1.14558, 1, 0, 0.522258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395762,-99) , 
4, 0.556324, 1, 0, 0.459508,-99) , 
5, 0.705472, 0, 0, 0.515129,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.0747448);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460131,-99) , 
4, 0.525171, 0, 0, 0.523614,-99) , 
NN(
0, 
0, 
-1, 0.83085, 0, -1, 0.470962,-99) , 
4, 0.917737, 1, 0, 0.500865,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.0596376);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478155,-99) , 
6, 1.07007, 1, 0, 0.507787,-99) , 
NN(
0, 
0, 
-1, 0.989031, 1, -1, 0.469586,-99) , 
5, 0.971062, 0, 0, 0.486671,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.0551087);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480329,-99) , 
3, 1.78969, 1, 0, 0.550245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478944,-99) , 
1, 0.858734, 1, 0, 0.491528,-99) , 
5, 1.24259, 0, 0, 0.501977,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.0571992);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496403,-99) , 
5, 0.90285, 0, 0, 0.515999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448608,-99) , 
5, 1.62565, 0, 0, 0.472249,-99) , 
6, 1.02925, 1, 0, 0.503941,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.0235944);
  fForest.push_back( 
NN(
0, 
0, 
-1, 0.661129, 1, 1, 0.511795,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.0464436);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460886,-99) , 
4, 0.936459, 1, 0, 0.530816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440712,-99) , 
5, 0.90652, 0, 0, 0.488187,-99) , 
6, 0.787707, 1, 0, 0.501342,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.035235);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496377,-99) , 
3, 0.660964, 1, 0, 0.529967,-99) , 
NN(
0, 
0, 
-1, 0.691518, 0, -1, 0.486811,-99) , 
3, 0.744383, 1, 0, 0.49628,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.0287181);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.888331, 1, 1, 0.590252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387386,-99) , 
6, 1.51618, 1, 0, 0.49798,-99) , 
2, 1.27591, 0, 0, 0.505154,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.0615728);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480956,-99) , 
5, 0.756096, 0, 0, 0.523528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466473,-99) , 
4, 1.19736, 0, 0, 0.480655,-99) , 
6, 0.860222, 1, 0, 0.500888,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.0215432);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.34063, 0, 1, 0.508286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420074,-99) , 
3, 1.89901, 1, 0, 0.505228,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.0610293);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.870545, 1, 1, 0.525915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439765,-99) , 
5, 0.999273, 0, 0, 0.489785,-99) , 
4, 0.917737, 1, 0, 0.509788,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.0264044);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414472,-99) , 
3, 1.89024, 1, 0, 0.505008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397089,-99) , 
4, 2.0293, 1, 0, 0.501437,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.0535283);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459713,-99) , 
4, 0.72146, 0, 0, 0.493876,-99) , 
NN(
0, 
0, 
-1, 1.47238, 1, -1, 0.409873,-99) , 
4, 1.74208, 1, 0, 0.488215,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.0423298);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.764152, 1, 1, 0.51854,-99) , 
NN(
0, 
0, 
-1, 0.822781, 0, -1, 0.476286,-99) , 
4, 0.859472, 1, 0, 0.497206,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.0498263);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487382,-99) , 
1, 0.936295, 0, 0, 0.512026,-99) , 
NN(
0, 
0, 
-1, 0.815427, 0, -1, 0.476455,-99) , 
6, 0.847142, 1, 0, 0.492672,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.0399772);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.822833, 1, 1, 0.553402,-99) , 
NN(
0, 
0, 
-1, 1.46737, 1, -1, 0.483143,-99) , 
2, 1.24264, 0, 0, 0.489143,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.0655581);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448767,-99) , 
3, 1.37622, 1, 0, 0.530198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480011,-99) , 
3, 0.601763, 1, 0, 0.485456,-99) , 
0, 0.932225, 0, 0, 0.504085,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.0328075);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.05665, 1, 1, 0.530479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444147,-99) , 
3, 1.09664, 1, 0, 0.489812,-99) , 
5, 1.17693, 0, 0, 0.498516,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.0275259);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497147,-99) , 
5, 1.36175, 0, 0, 0.505843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406729,-99) , 
4, 2.0272, 1, 0, 0.502497,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.042241);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452138,-99) , 
0, 1.27171, 1, 0, 0.506269,-99) , 
NN(
0, 
0, 
-1, 1.37015, 0, -1, 0.441187,-99) , 
6, 1.42944, 1, 0, 0.502016,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.0612775);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414253,-99) , 
3, 1.06471, 1, 0, 0.527091,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515627,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466736,-99) , 
5, 1.05877, 0, 0, 0.49208,-99) , 
6, 0.813661, 1, 0, 0.505439,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.0628986);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461344,-99) , 
5, 0.849121, 0, 0, 0.496861,-99) , 
NN(
0, 
0, 
-1, 1.08564, 1, -1, 0.453493,-99) , 
6, 1.11174, 1, 0, 0.488605,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.0642483);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.656119, 1, 1, 0.549277,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469279,-99) , 
3, 0.679587, 1, 0, 0.476022,-99) , 
1, 0.751032, 1, 0, 0.483781,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.0177568);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496831,-99) , 
0, 1.5113, 0, 0, 0.500407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396303,-99) , 
0, 2.53892, 1, 0, 0.497645,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.0543679);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490829,-99) , 
5, 0.910139, 0, 0, 0.506125,-99) , 
NN(
0, 
0, 
-1, 1.07807, 0, -1, 0.468237,-99) , 
6, 0.845548, 1, 0, 0.484824,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.0327539);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22935, 0, 1, 0.514485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426,-99) , 
4, 2.01686, 1, 0, 0.511682,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.0624817);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493724,-99) , 
1, 0.930292, 1, 0, 0.511907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454183,-99) , 
1, 0.982058, 0, 0, 0.475459,-99) , 
0, 0.933271, 0, 0, 0.490385,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.0298048);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477063,-99) , 
0, 0.9854, 1, 0, 0.561372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495667,-99) , 
3, 1.40614, 0, 0, 0.49977,-99) , 
3, 1.50989, 0, 0, 0.50558,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.0454796);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.951368, 1, 1, 0.546021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484638,-99) , 
0, 0.931373, 0, 0, 0.500265,-99) , 
5, 1.3749, 0, 0, 0.506091,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.0660543);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493933,-99) , 
3, 1.68328, 1, 0, 0.556491,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460108,-99) , 
4, 0.987258, 1, 0, 0.504629,-99) , 
5, 1.2445, 0, 0, 0.514111,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.0512706);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.922527, 1, 1, 0.530609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443155,-99) , 
6, 0.974836, 1, 0, 0.491906,-99) , 
0, 0.932225, 0, 0, 0.508158,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.058974);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.26994, 0, 1, 0.532971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478112,-99) , 
2, 1.261, 0, 0, 0.485556,-99) , 
4, 0.841698, 0, 0, 0.509875,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.0630054);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.912051, 1, 1, 0.532379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453142,-99) , 
3, 0.806087, 1, 0, 0.486652,-99) , 
3, 0.974764, 0, 0, 0.506319,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.0603155);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449939,-99) , 
4, 0.964267, 1, 0, 0.509941,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458938,-99) , 
5, 1.12705, 0, 0, 0.479927,-99) , 
6, 0.802193, 1, 0, 0.490163,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.0414502);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598473,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469547,-99) , 
4, 0.838109, 0, 0, 0.490629,-99) , 
6, 0.610447, 1, 0, 0.494215,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.0352614);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488021,-99) , 
3, 0.595261, 1, 0, 0.49157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356182,-99) , 
6, 1.81646, 1, 0, 0.488128,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.0352434);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441194,-99) , 
5, 0.672129, 0, 0, 0.504325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383367,-99) , 
6, 1.62487, 1, 0, 0.499703,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.025735);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496071,-99) , 
4, 1.13023, 0, 0, 0.503016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379705,-99) , 
3, 1.86029, 1, 0, 0.498646,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.0357307);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.70902, 0, 1, 0.514202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431068,-99) , 
3, 1.24114, 0, 0, 0.464421,-99) , 
4, 1.56266, 1, 0, 0.509444,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.0451058);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486304,-99) , 
3, 1.39171, 0, 0, 0.492814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360655,-99) , 
1, 0.977519, 1, 0, 0.427161,-99) , 
3, 1.6148, 1, 0, 0.488291,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.0392512);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472242,-99) , 
1, 1.13889, 1, 0, 0.549271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494406,-99) , 
1, 1.55933, 0, 0, 0.499199,-99) , 
3, 1.26994, 0, 0, 0.508376,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.0428011);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49469,-99) , 
0, 0.832837, 0, 0, 0.540966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491974,-99) , 
4, 0.373867, 1, 0, 0.496445,-99) , 
1, 0.866985, 1, 0, 0.509024,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.0522922);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.14835, 0, 1, 0.52541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423952,-99) , 
5, 1.49856, 0, 0, 0.47241,-99) , 
6, 1.22401, 1, 0, 0.518522,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.018767);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.380503, 1, 1, 0.505835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364353,-99) , 
4, 2.17948, 1, 0, 0.501969,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.0545868);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491554,-99) , 
4, 0.849943, 0, 0, 0.504955,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460747,-99) , 
4, 1.86846, 0, 0, 0.470334,-99) , 
4, 0.928361, 1, 0, 0.490353,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.0210803);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494739,-99) , 
6, 0.60682, 1, 0, 0.565209,-99) , 
NN(
0, 
0, 
-1, 0.776769, 0, -1, 0.493147,-99) , 
6, 0.653044, 1, 0, 0.497317,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.0287316);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498538,-99) , 
4, 0.541684, 1, 0, 0.507444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374453,-99) , 
3, 1.18281, 0, 0, 0.436838,-99) , 
4, 1.66378, 1, 0, 0.501887,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.0506425);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495741,-99) , 
3, 1.02075, 1, 0, 0.547189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463147,-99) , 
3, 1.96851, 1, 0, 0.51873,-99) , 
2, 1.13509, 0, 0, 0.522769,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.0511713);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47464,-99) , 
4, 0.92286, 1, 0, 0.501989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439817,-99) , 
5, 1.52145, 0, 0, 0.464228,-99) , 
1, 1.23084, 1, 0, 0.49651,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.0191264);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499871,-99) , 
5, 1.33755, 0, 0, 0.505935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427608,-99) , 
6, 1.06697, 1, 0, 0.460127,-99) , 
4, 1.56266, 1, 0, 0.501649,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.0441599);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.629655, 1, 1, 0.51864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353339,-99) , 
3, 1.94621, 1, 0, 0.514218,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.0541993);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487363,-99) , 
4, 0.934921, 1, 0, 0.507653,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438621,-99) , 
3, 0.752084, 1, 0, 0.481703,-99) , 
3, 0.874641, 0, 0, 0.496869,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.0344154);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49185,-99) , 
4, 1.1093, 0, 0, 0.502095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411591,-99) , 
4, 2.03665, 1, 0, 0.498909,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.03493);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493104,-99) , 
0, 0.963091, 0, 0, 0.501334,-99) , 
NN(
0, 
0, 
-1, 0.944874, 0, -1, 0.470201,-99) , 
0, 1.0487, 1, 0, 0.493615,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.0515345);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4186,-99) , 
0, 0.56998, 0, 0, 0.529748,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484797,-99) , 
5, 1.3388, 0, 0, 0.493332,-99) , 
1, 0.824755, 1, 0, 0.500863,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.0348912);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.23472, 0, 1, 0.51205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379321,-99) , 
1, 1.47871, 0, 0, 0.453793,-99) , 
6, 1.36672, 1, 0, 0.507075,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.0380982);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489266,-99) , 
4, 0.363069, 1, 0, 0.493749,-99) , 
NN(
0, 
0, 
-1, 1.01863, 0, -1, 0.429316,-99) , 
4, 1.56266, 1, 0, 0.487668,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.0401821);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476837,-99) , 
4, 0.88368, 1, 0, 0.492727,-99) , 
NN(
0, 
0, 
-1, 0.739308, 1, -1, 0.440183,-99) , 
3, 0.643385, 0, 0, 0.487843,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.0569453);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47643,-99) , 
0, 0.972118, 1, 0, 0.537731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480676,-99) , 
3, 1.1425, 0, 0, 0.487499,-99) , 
3, 1.26994, 0, 0, 0.496298,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.0531664);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.664071, 1, 1, 0.541716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457854,-99) , 
5, 0.922894, 0, 0, 0.497651,-99) , 
6, 0.776238, 1, 0, 0.509955,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.0354788);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477195,-99) , 
0, 0.824385, 0, 0, 0.500033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397554,-99) , 
0, 2.45313, 1, 0, 0.496661,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.0258619);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381576,-99) , 
3, 1.7363, 1, 0, 0.499677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382858,-99) , 
4, 2.0272, 1, 0, 0.495925,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.0579067);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427274,-99) , 
5, 0.65113, 0, 0, 0.512924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469648,-99) , 
5, 1.79064, 0, 0, 0.481983,-99) , 
6, 0.987149, 1, 0, 0.503108,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.0296948);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499886,-99) , 
2, 0.999102, 0, 0, 0.509427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435273,-99) , 
0, 0.819619, 1, 0, 0.457563,-99) , 
2, 1.16831, 1, 0, 0.503055,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.0518926);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494413,-99) , 
1, 0.956087, 0, 0, 0.516631,-99) , 
NN(
0, 
0, 
-1, 0.82435, 1, -1, 0.432807,-99) , 
4, 1.648, 1, 0, 0.510119,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.0396003);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55723,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480535,-99) , 
6, 0.860633, 1, 0, 0.498939,-99) , 
5, 1.84464, 0, 0, 0.501073,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.0495978);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02373, 0, 1, 0.516076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439359,-99) , 
3, 1.48456, 0, 0, 0.465605,-99) , 
4, 1.26962, 1, 0, 0.50671,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.0684303);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452177,-99) , 
4, 0.468546, 0, 0, 0.525848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393801,-99) , 
3, 0.686024, 0, 0, 0.46257,-99) , 
5, 0.784501, 0, 0, 0.512588,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.0352558);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489783,-99) , 
5, 1.3749, 0, 0, 0.496563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411708,-99) , 
4, 2.02059, 1, 0, 0.4935,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.0549662);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471546,-99) , 
5, 0.708054, 0, 0, 0.521002,-99) , 
NN(
0, 
0, 
-1, 0.919786, 0, -1, 0.478118,-99) , 
6, 0.824725, 1, 0, 0.495533,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.0404051);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496837,-99) , 
5, 1.11532, 0, 0, 0.50742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442333,-99) , 
0, 2.34056, 0, 0, 0.460507,-99) , 
6, 1.14461, 1, 0, 0.499497,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.0440931);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484781,-99) , 
6, 0.675018, 1, 0, 0.490717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388579,-99) , 
6, 1.60266, 1, 0, 0.486897,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.0595363);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.26733, 0, 1, 0.528011,-99) , 
NN(
0, 
0, 
-1, 1.80625, 1, -1, 0.439658,-99) , 
6, 1.54202, 1, 0, 0.523303,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.0605087);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473861,-99) , 
5, 0.824183, 0, 0, 0.515707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430165,-99) , 
5, 0.808967, 1, 0, 0.48135,-99) , 
4, 0.63173, 0, 0, 0.507756,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.020655);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4959,-99) , 
6, 0.651366, 1, 0, 0.498773,-99) , 
NN(
0, 
0, 
-1, 0.556089, 1, -1, 0.42716,-99) , 
3, 0.596697, 0, 0, 0.494772,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.0338927);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.887242, 1, 1, 0.586485,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491288,-99) , 
3, 1.02976, 0, 0, 0.499449,-99) , 
2, 1.24264, 0, 0, 0.506357,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.0611661);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483657,-99) , 
5, 0.966049, 0, 0, 0.515092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444405,-99) , 
6, 0.814063, 1, 0, 0.481974,-99) , 
4, 0.821825, 0, 0, 0.500071,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.0440826);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466789,-99) , 
4, 1.56266, 1, 0, 0.51268,-99) , 
NN(
0, 
0, 
-1, 1.05098, 0, -1, 0.428176,-99) , 
0, 2.00064, 1, 0, 0.50816,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.0383659);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493694,-99) , 
1, 1.18356, 0, 0, 0.500544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439772,-99) , 
4, 1.27796, 0, 0, 0.454953,-99) , 
0, 1.21464, 1, 0, 0.49295,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.0438322);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550288,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495539,-99) , 
0, 0.952876, 0, 0, 0.514443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405109,-99) , 
1, 1.1502, 1, 0, 0.477799,-99) , 
3, 1.13301, 1, 0, 0.50404,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.0242256);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.62518, 1, 1, 0.510115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434375,-99) , 
6, 1.62353, 1, 0, 0.507392,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.0450364);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481613,-99) , 
5, 1.41107, 0, 0, 0.486526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395424,-99) , 
4, 2.10955, 1, 0, 0.484062,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.0310824);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495001,-99) , 
6, 0.981722, 0, 0, 0.505091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415752,-99) , 
6, 1.55981, 1, 0, 0.500984,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.0230518);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499369,-99) , 
1, 0.640461, 1, 0, 0.504021,-99) , 
NN(
0, 
0, 
-1, 1.48943, 1, -1, 0.454893,-99) , 
1, 1.19483, 1, 0, 0.496283,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.0331972);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446276,-99) , 
4, 0.451406, 0, 0, 0.501766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363129,-99) , 
3, 1.97359, 1, 0, 0.497896,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.0281844);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467403,-99) , 
1, 0.789697, 0, 0, 0.568777,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496618,-99) , 
2, 1.14773, 0, 0, 0.502608,-99) , 
6, 0.651366, 1, 0, 0.506689,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.0563712);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483722,-99) , 
4, 1.06519, 1, 0, 0.516579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402904,-99) , 
3, 1.86116, 1, 0, 0.512093,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.0514385);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472554,-99) , 
5, 1.34604, 1, 0, 0.51077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417502,-99) , 
4, 0.704051, 1, 0, 0.48108,-99) , 
5, 0.813235, 0, 0, 0.502971,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.0231508);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.29262, 1, 1, 0.504624,-99) , 
NN(
0, 
0, 
-1, 0.950877, 0, -1, 0.419335,-99) , 
4, 1.56266, 1, 0, 0.496829,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.0245888);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494473,-99) , 
2, 1.34552, 0, 0, 0.49763,-99) , 
NN(
0, 
0, 
-1, 0.903805, 1, -1, 0.455416,-99) , 
4, 0.468546, 0, 0, 0.492792,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.0348191);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496514,-99) , 
3, 0.860621, 1, 0, 0.505456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405508,-99) , 
1, 0.905076, 0, 0, 0.467599,-99) , 
5, 0.716723, 0, 0, 0.501046,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.0435524);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.04717, 0, 1, 0.519605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479624,-99) , 
6, 1.19305, 0, 0, 0.489037,-99) , 
4, 0.768568, 0, 0, 0.508096,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.0256844);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492811,-99) , 
3, 1.57553, 0, 0, 0.49662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419374,-99) , 
3, 1.86029, 1, 0, 0.493841,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.040752);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.5015, 0, 1, 0.511056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464813,-99) , 
4, 0.524906, 1, 0, 0.479014,-99) , 
6, 1.0116, 1, 0, 0.501749,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.0230092);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596082,-99) , 
NN(
0, 
0, 
-1, 1.57952, 1, -1, 0.491204,-99) , 
3, 1.89024, 0, 0, 0.494456,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.055156);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477182,-99) , 
4, 1.21167, 1, 0, 0.507178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473312,-99) , 
4, 0.303353, 1, 0, 0.480368,-99) , 
4, 0.859472, 0, 0, 0.493512,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.0586369);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.65482, 1, 1, 0.524351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453118,-99) , 
4, 0.608584, 1, 0, 0.478131,-99) , 
2, 1.07434, 1, 0, 0.515623,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.0375135);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.637185, 0, 1, 0.570624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489303,-99) , 
5, 0.867227, 0, 0, 0.508469,-99) , 
1, 0.698517, 1, 0, 0.511928,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.0316976);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459053,-99) , 
5, 0.780977, 0, 0, 0.494483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3978,-99) , 
2, 1.40528, 1, 0, 0.490628,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.0587995);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429379,-99) , 
3, 1.14128, 1, 0, 0.553572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478045,-99) , 
6, 0.616331, 1, 0, 0.48159,-99) , 
2, 1.30627, 0, 0, 0.486161,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.0272642);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496858,-99) , 
3, 1.19443, 0, 0, 0.546376,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377351,-99) , 
3, 1.72864, 1, 0, 0.500703,-99) , 
4, 1.63796, 0, 0, 0.504355,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.0401381);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461101,-99) , 
6, 1.35331, 1, 0, 0.510385,-99) , 
NN(
0, 
0, 
-1, 0.878831, 1, -1, 0.485184,-99) , 
6, 1.01838, 0, 0, 0.492267,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.0605769);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.993517, 0, 1, 0.524918,-99) , 
NN(
0, 
0, 
-1, 1.08068, 0, -1, 0.446451,-99) , 
3, 1.28026, 1, 0, 0.5103,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.0504271);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480535,-99) , 
4, 0.770163, 0, 0, 0.533085,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484149,-99) , 
6, 0.761929, 1, 0, 0.492895,-99) , 
0, 0.788805, 1, 0, 0.503094,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.0236548);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49401,-99) , 
5, 1.75389, 0, 0, 0.496903,-99) , 
NN(
0, 
0, 
-1, 1.02462, 1, -1, 0.434754,-99) , 
0, 1.91664, 1, 0, 0.493259,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.0395575);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.557022, 1, 1, 0.519965,-99) , 
NN(
0, 
0, 
-1, 1.03526, 1, -1, 0.480403,-99) , 
3, 0.948013, 0, 0, 0.498845,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.04527);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491819,-99) , 
6, 0.902255, 1, 0, 0.508152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417808,-99) , 
0, 0.811386, 0, 0, 0.476336,-99) , 
1, 0.771949, 0, 0, 0.503693,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.0291135);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415243,-99) , 
6, 1.46415, 1, 0, 0.506156,-99) , 
1, 1.63659, 0, 0, 0.509471,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.0539745);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480978,-99) , 
5, 0.757005, 0, 0, 0.518509,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481947,-99) , 
4, 0.487738, 1, 0, 0.490494,-99) , 
6, 0.776238, 1, 0, 0.498173,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.0172987);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499197,-99) , 
1, 1.45213, 0, 0, 0.503448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381569,-99) , 
0, 2.61717, 1, 0, 0.499503,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.0505113);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.81178, 1, 1, 0.542713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476253,-99) , 
4, 0.838109, 1, 0, 0.497843,-99) , 
3, 1.26994, 0, 0, 0.506213,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.047826);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.909843, 1, 1, 0.542285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454009,-99) , 
3, 1.01678, 1, 0, 0.498164,-99) , 
3, 1.26994, 0, 0, 0.50649,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.0452978);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487947,-99) , 
0, 0.95644, 1, 0, 0.565918,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47227,-99) , 
3, 0.88355, 0, 0, 0.48913,-99) , 
3, 1.46935, 0, 0, 0.497497,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
