// Class: ReadFisher
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Fisher::Fisher
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:09:19 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 14000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "True" [Print method-specific help message]
CreateMVAPdfs: "True" [Create PDFs for classifier outputs (signal and background)]
Method: "Fisher" [Discrimination method]
# Default:
VerbosityLevel: "Default" [Verbosity level]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 7
m_jj                          m_jj                          m_jj                          m_jj                                                            'F'    [0.151058629155,16.1319084167]
m_jjj                         m_jjj                         m_jjj                         m_jjj                                                           'F'    [0.342466980219,8.94014835358]
m_lv                          m_lv                          m_lv                          m_lv                                                            'F'    [0.26678776741,3.68225979805]
m_jlv                         m_jlv                         m_jlv                         m_jlv                                                           'F'    [0.384410560131,6.58312129974]
m_bb                          m_bb                          m_bb                          m_bb                                                            'F'    [0.0809864625335,8.25508308411]
m_wbb                         m_wbb                         m_wbb                         m_wbb                                                           'F'    [0.385025799274,6.40131282806]
m_wwbb                        m_wwbb                        m_wwbb                        m_wwbb                                                          'F'    [0.432279825211,4.53500270844]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadFisher : public IClassifierReader {

 public:

   // constructor
   ReadFisher( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadFisher" ),
        fNvars( 7 )
   {
      // the training input variables
      const char* inputVars[] = { "m_jj", "m_jjj", "m_lv", "m_jlv", "m_bb", "m_wbb", "m_wwbb" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;
      fVmin[4] = 0;
      fVmax[4] = 0;
      fVmin[5] = 0;
      fVmax[5] = 0;
      fVmin[6] = 0;
      fVmax[6] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';
      fType[4] = 'F';
      fType[5] = 'F';
      fType[6] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadFisher() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[7];
   double fVmax[7];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[7];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double              fFisher0;
   std::vector<double> fFisherCoefficients;
};

inline void ReadFisher::Initialize() 
{
   fFisher0 = 0.135607666212;
   fFisherCoefficients.push_back( -0.0508861320116 );
   fFisherCoefficients.push_back( 0.192018909704 );
   fFisherCoefficients.push_back( 0.044941228536 );
   fFisherCoefficients.push_back( 0.0588335104315 );
   fFisherCoefficients.push_back( -0.211282892707 );
   fFisherCoefficients.push_back( 0.549204490328 );
   fFisherCoefficients.push_back( -0.777794818008 );

   // sanity check
   if (fFisherCoefficients.size() != fNvars) {
      std::cout << "Problem in class \"" << fClassName << "\"::Initialize: mismatch in number of input values"
                << fFisherCoefficients.size() << " != " << fNvars << std::endl;
      fStatusIsClean = false;
   }         
}

inline double ReadFisher::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double retval = fFisher0;
   for (size_t ivar = 0; ivar < fNvars; ivar++) {
      retval += fFisherCoefficients[ivar]*inputValues[ivar];
   }

   return retval;
}

// Clean up
inline void ReadFisher::Clear() 
{
   // clear coefficients
   fFisherCoefficients.clear(); 
}
inline double ReadFisher::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
