// Class: ReadLikelihood
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::Likelihood
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:09:19 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 14000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "True" [Print method-specific help message]
TransformOutput: "True" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 7
m_jj                          m_jj                          m_jj                          m_jj                                                            'F'    [0.151058629155,16.1319084167]
m_jjj                         m_jjj                         m_jjj                         m_jjj                                                           'F'    [0.342466980219,8.94014835358]
m_lv                          m_lv                          m_lv                          m_lv                                                            'F'    [0.26678776741,3.68225979805]
m_jlv                         m_jlv                         m_jlv                         m_jlv                                                           'F'    [0.384410560131,6.58312129974]
m_bb                          m_bb                          m_bb                          m_bb                                                            'F'    [0.0809864625335,8.25508308411]
m_wbb                         m_wbb                         m_wbb                         m_wbb                                                           'F'    [0.385025799274,6.40131282806]
m_wwbb                        m_wwbb                        m_wwbb                        m_wwbb                                                          'F'    [0.432279825211,4.53500270844]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <math.h>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihood : public IClassifierReader {

 public:

   // constructor
   ReadLikelihood( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihood" ),
        fNvars( 7 )
   {
      // the training input variables
      const char* inputVars[] = { "m_jj", "m_jjj", "m_lv", "m_jlv", "m_bb", "m_wbb", "m_wwbb" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;
      fVmin[4] = 0;
      fVmax[4] = 0;
      fVmin[5] = 0;
      fVmax[5] = 0;
      fVmin[6] = 0;
      fVmax[6] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';
      fType[4] = 'F';
      fType[5] = 'F';
      fType[6] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadLikelihood() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[7];
   double fVmax[7];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[7];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[7]; 
   int    fNbin[7]; // number of bins (discrete variables may have less bins)
   double    fHistMin[7]; 
   double    fHistMax[7]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihood::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = 0.151058629155159;
   fHistMax[0] = 16.131908416748;
   fNbin[1] = 10000;
   fHistMin[1] = 0.342466980218887;
   fHistMax[1] = 8.94014835357666;
   fNbin[2] = 10000;
   fHistMin[2] = 0.266787767410278;
   fHistMax[2] = 3.68225979804993;
   fNbin[3] = 10000;
   fHistMin[3] = 0.384410560131073;
   fHistMax[3] = 6.58312129974365;
   fNbin[4] = 10000;
   fHistMin[4] = 0.080986462533474;
   fHistMax[4] = 8.25508308410645;
   fNbin[5] = 10000;
   fHistMin[5] = 0.385025799274445;
   fHistMax[5] = 6.40131282806396;
   fNbin[6] = 10000;
   fHistMin[6] = 0.432279825210571;
   fHistMax[6] = 4.53500270843506;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
   fHasDiscretPDF[4] = false; 
   fHasDiscretPDF[5] = false; 
   fHasDiscretPDF[6] = false; 
}

inline double ReadLikelihood::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihood: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihood::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (true) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihood::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihood::fRefS[][10000] = 
{ 
   { 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 0.00206080474890769, 0.00469402596354485, 0.00733855459839106, 0.00999442022293806, 0.0126616088673472, 0.0153400721028447, 0.0180298741906881, 0.0207310132682323, 0.0234434269368649, 0.0261671803891659, 0.0289022363722324, 0.0316486321389675, 0.0344063378870487, 0.0371753461658955, 0.039955660700798, 0.0427472852170467, 0.045550275593996, 0.0483645126223564, 0.0511901192367077, 0.0540270283818245, 0.0568752475082874, 0.0597348026931286, 0.0626056343317032, 0.065487802028656, 0.068381279706955, 0.0712861195206642, 0.0742022097110748, 0.077129602432251, 0.080068364739418, 0.0830184072256088, 0.0859798118472099, 0.0889525040984154, 0.0919365212321281, 0.0949317812919617, 0.0979384481906891, 0.100956417620182, 0.103985704481602, 0.107026286423206, 0.110078178346157, 0.113141372799873, 0.116215907037258, 0.119301751255989, 0.122398935258389, 0.125507414340973, 0.128627210855484, 0.131758287549019, 0.134900718927383, 0.138054475188255, 0.141219541430473, 0.144395902752876, 0.147583603858948, 0.150782570242882, 0.153992891311646, 0.157214522361755, 0.160447508096695, 0.163691759109497, 0.166947364807129, 0.170214235782623, 0.173492446541786, 0.176781952381134, 0.180082842707634, 0.183394983410835, 0.186718478798866, 0.190053224563599, 0.193399339914322, 0.19675675034523, 0.200125530362129, 0.203505575656891, 0.206896960735321, 0.210299551486969, 0.213713556528091, 0.217173039913177, 0.220702335238457, 0.22424028813839, 0.227786928415298, 0.231342121958733, 0.234906047582626, 0.238478660583496, 0.242059931159019, 0.245649799704552, 0.249248385429382, 0.252855509519577, 0.256471425294876, 0.260095953941345, 0.263729125261307, 0.267370998859406, 0.271021485328674, 0.274680554866791, 0.278348445892334, 0.28202486038208, 0.285710036754608, 0.289403796195984, 0.293106257915497, 0.296817272901535, 0.300537079572678, 0.304265439510345, 0.308002591133118, 0.311748266220093, 0.315502673387527, 0.31926566362381, 0.323037356138229, 0.326817750930786, 0.330606758594513, 0.334404438734055, 0.338210791349411, 0.342025697231293, 0.345849364995956, 0.349681615829468, 0.353522598743439, 0.357372224330902, 0.36123052239418, 0.365097403526306, 0.368973016738892, 0.372857272624969, 0.376750141382217, 0.380651742219925, 0.384561896324158, 0.388480722904205, 0.39240825176239, 0.396344482898712, 0.400289356708527, 0.404242813587189, 0.40820500254631, 0.41217577457428, 0.416155278682709, 0.420143365859985, 0.424140155315399, 0.428145676851273, 0.432159751653671, 0.436182409524918, 0.440213888883591, 0.444253921508789, 0.448302686214447, 0.452360153198242, 0.456426173448563, 0.460500776767731, 0.464584112167358, 0.468676179647446, 0.472776800394058, 0.47688615322113, 0.481004178524017, 0.485130727291107, 0.489266067743301, 0.493583798408508, 0.497913807630539, 0.502241671085358, 0.506567537784576, 0.510891139507294, 0.515212833881378, 0.519532561302185, 0.523850083351135, 0.528165638446808, 0.532479166984558, 0.536790490150452, 0.541099965572357, 0.545407235622406, 0.549712538719177, 0.554015815258026, 0.558317005634308, 0.562616050243378, 0.566913068294525, 0.57120817899704, 0.575501143932343, 0.579792082309723, 0.584080934524536, 0.588367760181427, 0.592652440071106, 0.596935212612152, 0.601215839385986, 0.605494499206543, 0.609771013259888, 0.6140456199646, 0.618317902088165, 0.622588217258453, 0.626856565475464, 0.631123006343842, 0.635387241840363, 0.639649391174316, 0.643909454345703, 0.648167610168457, 0.652423620223999, 0.656677544116974, 0.660929501056671, 0.665179312229156, 0.669427275657654, 0.67367297410965, 0.677916824817657, 0.682158291339874, 0.686397850513458, 0.690635621547699, 0.694871008396149, 0.69910454750061, 0.703335881233215, 0.707565128803253, 0.711792469024658, 0.716017723083496, 0.720241010189056, 0.724462032318115, 0.728681147098541, 0.7328981757164, 0.737113177776337, 0.741326153278351, 0.745537102222443, 0.749745905399323, 0.75395268201828, 0.758157193660736, 0.762360036373138, 0.766560554504395, 0.770759165287018, 0.774955689907074, 0.779150247573853, 0.783342599868774, 0.787532866001129, 0.791721284389496, 0.79587984085083, 0.79999977350235, 0.804102599620819, 0.808188736438751, 0.812258064746857, 0.816310584545135, 0.820346593856812, 0.824366092681885, 0.828368246555328, 0.832353889942169, 0.836322724819183, 0.840274751186371, 0.844210386276245, 0.848128914833069, 0.852030575275421, 0.855915606021881, 0.859783947467804, 0.863635241985321, 0.867470264434814, 0.871288180351257, 0.875089645385742, 0.878873884677887, 0.882641553878784, 0.886392772197723, 0.890126824378967, 0.893844366073608, 0.897544980049133, 0.901228785514832, 0.904896080493927, 0.908546447753906, 0.912180066108704, 0.915797173976898, 0.919397115707397, 0.922980666160583, 0.926547110080719, 0.930096983909607, 0.933630168437958, 0.937146365642548, 0.940646231174469, 0.944128930568695, 0.947595119476318, 0.951044321060181, 0.954476833343506, 0.95789235830307, 0.961291790008545, 0.96467399597168, 0.968039333820343, 0.971388101577759, 0.974720120429993, 0.978035390377045, 0.98133385181427, 0.984615325927734, 0.987880408763885, 0.99112856388092, 0.994360148906708, 0.997574687004089, 1.00077247619629, 1.00395381450653, 1.00711786746979, 1.01026570796967, 1.01339662075043, 1.01651072502136, 1.01960790157318, 1.02268838882446, 1.0257523059845, 1.02879929542542, 1.03182971477509, 1.03484344482422, 1.03784036636353, 1.04082024097443, 1.04378354549408, 1.04672074317932, 1.04947316646576, 1.05220055580139, 1.05490219593048, 1.05757904052734, 1.06023073196411, 1.06285679340363, 1.06545794010162, 1.06803369522095, 1.0705840587616, 1.07310950756073, 1.07560956478119, 1.07808434963226, 1.08053374290466, 1.08295798301697, 1.08535730838776, 1.08773100376129, 1.09007954597473, 1.0924026966095, 1.09470081329346, 1.09697389602661, 1.09922158718109, 1.10144376754761, 1.10364067554474, 1.10581254959106, 1.10795927047729, 1.11008095741272, 1.1121768951416, 1.11424767971039, 1.11629343032837, 1.11831378936768, 1.12030899524689, 1.12227892875671, 1.12422358989716, 1.12614274024963, 1.1280369758606, 1.12990593910217, 1.13174962997437, 1.13356804847717, 1.13536107540131, 1.13712894916534, 1.13887190818787, 1.14058911800385, 1.14228129386902, 1.1439483165741, 1.1455899477005, 1.14720618724823, 1.14879775047302, 1.15036356449127, 1.15190446376801, 1.1534196138382, 1.15490996837616, 1.15637516975403, 1.15781474113464, 1.15922951698303, 1.16061866283417, 1.16198253631592, 1.16332161426544, 1.16463506221771, 1.1659232378006, 1.16718637943268, 1.16842412948608, 1.16963672637939, 1.17082393169403, 1.17198586463928, 1.17312252521515, 1.17423415184021, 1.17532074451447, 1.17638170719147, 1.17741739749908, 1.17842793464661, 1.17941331863403, 1.18030095100403, 1.18112087249756, 1.18191480636597, 1.18268287181854, 1.18342554569244, 1.18414223194122, 1.18483376502991, 1.18549871444702, 1.18613862991333, 1.18675243854523, 1.18734109401703, 1.187903881073, 1.18844079971313, 1.18895208835602, 1.18943762779236, 1.18989777565002, 1.19033181667328, 1.19074070453644, 1.19112360477448, 1.19148063659668, 1.19181203842163, 1.19211781024933, 1.19239807128906, 1.19265246391296, 1.19288122653961, 1.19308423995972, 1.19326162338257, 1.19341325759888, 1.19353938102722, 1.19363951683044, 1.19371402263641, 1.19376301765442, 1.1937860250473, 1.19378352165222, 1.19375538825989, 1.1937016248703, 1.19362187385559, 1.19351649284363, 1.19338572025299, 1.19322907924652, 1.1930468082428, 1.19283878803253, 1.19260489940643, 1.19234573841095, 1.19206047058105, 1.19174981117249, 1.19141316413879, 1.19105100631714, 1.19066333770752, 1.19024980068207, 1.18981039524078, 1.18934535980225, 1.18885481357574, 1.18833863735199, 1.1877965927124, 1.18722891807556, 1.18663537502289, 1.18601584434509, 1.18537139892578, 1.18470096588135, 1.18400478363037, 1.18328285217285, 1.18253517150879, 1.18176186084747, 1.18096339702606, 1.18013858795166, 1.17928826808929, 1.17841219902039, 1.17751049995422, 1.17658364772797, 1.17563033103943, 1.17463231086731, 1.17356097698212, 1.17246878147125, 1.17135620117188, 1.1702219247818, 1.16906726360321, 1.16789150238037, 1.16669464111328, 1.16547667980194, 1.16423773765564, 1.16297805309296, 1.16169714927673, 1.16039538383484, 1.15907275676727, 1.15772902965546, 1.15636444091797, 1.1549791097641, 1.15357267856598, 1.1521452665329, 1.15069675445557, 1.14922714233398, 1.14773690700531, 1.14622569084167, 1.14469337463379, 1.14313995838165, 1.14156568050385, 1.13997054100037, 1.13835430145264, 1.13671731948853, 1.13505911827087, 1.13338029384613, 1.13168001174927, 1.12995886802673, 1.12821686267853, 1.12645375728607, 1.12466979026794, 1.12286531925201, 1.12103927135468, 1.11919271945953, 1.11732470989227, 1.11543607711792, 1.11352622509003, 1.11159586906433, 1.10964381694794, 1.10767138004303, 1.10567772388458, 1.10366308689117, 1.10162770748138, 1.09957146644592, 1.09749400615692, 1.09539568424225, 1.09327614307404, 1.09113597869873, 1.0889744758606, 1.08679234981537, 1.08458912372589, 1.08236479759216, 1.08011960983276, 1.07785332202911, 1.07556617259979, 1.07325839996338, 1.07092952728271, 1.06857943534851, 1.06620812416077, 1.06381630897522, 1.06140351295471, 1.05896961688995, 1.05651462078094, 1.05403923988342, 1.0515421628952, 1.0490243434906, 1.04648554325104, 1.04388749599457, 1.04126691818237, 1.03863346576691, 1.03598737716675, 1.03332805633545, 1.03065609931946, 1.02797114849091, 1.02527332305908, 1.02256286144257, 1.01983892917633, 1.01710271835327, 1.01435351371765, 1.01159131526947, 1.00881636142731, 1.00602865219116, 1.00322759151459, 1.00041389465332, 0.997587502002716, 0.994748055934906, 0.991895914077759, 0.989030838012695, 0.986152827739716, 0.983261704444885, 0.980358362197876, 0.977441549301147, 0.974511981010437, 0.971569418907166, 0.96861457824707, 0.965645968914032, 0.962665140628815, 0.959671497344971, 0.956664681434631, 0.95364511013031, 0.950612425804138, 0.947567343711853, 0.944508910179138, 0.941437780857086, 0.938353955745697, 0.935257136821747, 0.932147204875946, 0.929024577140808, 0.925889134407043, 0.922740876674652, 0.919579684734344, 0.91640567779541, 0.913218855857849, 0.910018682479858, 0.906806349754333, 0.903580605983734, 0.900342106819153, 0.8970907330513, 0.893826544284821, 0.890549421310425, 0.887259483337402, 0.883956551551819, 0.880641102790833, 0.877312481403351, 0.873970806598663, 0.870616853237152, 0.867249488830566, 0.863869369029999, 0.860476791858673, 0.857070803642273, 0.853652119636536, 0.850220382213593, 0.846776306629181, 0.843318521976471, 0.839848697185516, 0.836365640163422, 0.8328697681427, 0.829360663890839, 0.825829744338989, 0.822246134281158, 0.818660855293274, 0.815073847770691, 0.811485171318054, 0.807894647121429, 0.804302394390106, 0.800708770751953, 0.797113120555878, 0.793515622615814, 0.789916515350342, 0.786315679550171, 0.782712936401367, 0.779108703136444, 0.775502622127533, 0.771894872188568, 0.76828521490097, 0.764674007892609, 0.761061251163483, 0.757446467876434, 0.753829777240753, 0.750211775302887, 0.746591925621033, 0.742970108985901, 0.739346563816071, 0.7357217669487, 0.732094883918762, 0.728466272354126, 0.724836051464081, 0.721204042434692, 0.717570185661316, 0.713934898376465, 0.710297584533691, 0.706658363342285, 0.703017711639404, 0.699375510215759, 0.695731163024902, 0.692085385322571, 0.688437879085541, 0.684788465499878, 0.681137204170227, 0.677484571933746, 0.673830032348633, 0.670173764228821, 0.666515648365021, 0.662856042385101, 0.659194529056549, 0.655531346797943, 0.651866316795349, 0.648199737071991, 0.644531309604645, 0.640861392021179, 0.637189447879791, 0.63351583480835, 0.629840433597565, 0.626163899898529, 0.622485101222992, 0.618804454803467, 0.615122139453888, 0.611438393592834, 0.607752680778503, 0.604065179824829, 0.600376129150391, 0.596685111522675, 0.59299248456955, 0.589298009872437, 0.585602283477783, 0.581904351711273, 0.578204572200775, 0.574503540992737, 0.570800423622131, 0.567095637321472, 0.563432276248932, 0.559786915779114, 0.556151330471039, 0.552525997161865, 0.548910140991211, 0.545303821563721, 0.541707694530487, 0.538120806217194, 0.534543693065643, 0.530977010726929, 0.527419209480286, 0.523871600627899, 0.520333170890808, 0.516805589199066, 0.513286948204041, 0.509778022766113, 0.506279230117798, 0.502790093421936, 0.499310314655304, 0.49584099650383, 0.492380738258362, 0.488930493593216, 0.485490351915359, 0.482059389352798, 0.478638231754303, 0.475227504968643, 0.471825659275055, 0.468433409929276, 0.465051740407944, 0.461679369211197, 0.458316683769226, 0.454964160919189, 0.451621174812317, 0.448287457227707, 0.444963932037354, 0.441650718450546, 0.438346415758133, 0.435051947832108, 0.431767642498016, 0.42849263548851, 0.42522731423378, 0.421971797943115, 0.418726772069931, 0.415490716695786, 0.412264198064804, 0.40904837846756, 0.405841559171677, 0.402644217014313, 0.399457424879074, 0.396280109882355, 0.393112272024155, 0.389954209327698, 0.386806339025497, 0.38366773724556, 0.380538910627365, 0.377420544624329, 0.374310940504074, 0.371211320161819, 0.368121683597565, 0.365041822195053, 0.361971706151962, 0.35891130566597, 0.355860650539398, 0.352819263935089, 0.34978836774826, 0.346766710281372, 0.343754768371582, 0.340752601623535, 0.33776068687439, 0.334777772426605, 0.331805109977722, 0.328909605741501, 0.326110601425171, 0.323328524827957, 0.32056125998497, 0.317809969186783, 0.315074622631073, 0.312355309724808, 0.309651523828506, 0.306963175535202, 0.30429083108902, 0.301634252071381, 0.298992872238159, 0.296367257833481, 0.293758124113083, 0.291164517402649, 0.288586378097534, 0.2860247194767, 0.283478051424026, 0.280946880578995, 0.278431981801987, 0.275932520627975, 0.273448824882507, 0.270981878042221, 0.268529653549194, 0.266092717647552, 0.26367250084877, 0.261267989873886, 0.258878767490387, 0.256504774093628, 0.254147529602051, 0.251805752515793, 0.249479725956917, 0.247169703245163, 0.244875147938728, 0.242595851421356, 0.240333050489426, 0.238085731863976, 0.235853657126427, 0.233637586236, 0.231437981128693, 0.22925341129303, 0.227084770798683, 0.224932417273521, 0.22279480099678, 0.220672652125359, 0.21856752038002, 0.216477617621422, 0.214402973651886, 0.21234504878521, 0.210301876068115, 0.208274722099304, 0.206263512372971, 0.20426881313324, 0.202288836240768, 0.200324892997742, 0.198375925421715, 0.196443438529968, 0.194526702165604, 0.19262570142746, 0.190740942955017, 0.188870936632156, 0.187017664313316, 0.185179114341736, 0.183357074856758, 0.181550279259682, 0.179758980870247, 0.177983924746513, 0.17622509598732, 0.174481511116028, 0.172753185033798, 0.171040579676628, 0.169358596205711, 0.167802914977074, 0.166261479258537, 0.164733529090881, 0.163220584392548, 0.161720618605614, 0.160236150026321, 0.15876467525959, 0.157307431101799, 0.155863955616951, 0.154434710741043, 0.153019458055496, 0.151618674397469, 0.150231420993805, 0.14885838329792, 0.147499114274979, 0.146154820919037, 0.144823268055916, 0.143506452441216, 0.142203643918037, 0.14091457426548, 0.139640241861343, 0.138379648327827, 0.137133061885834, 0.135900214314461, 0.134681865572929, 0.133476734161377, 0.132286861538887, 0.131110727787018, 0.129948347806931, 0.128799200057983, 0.127665296196938, 0.126545131206512, 0.12543897330761, 0.124346286058426, 0.123268112540245, 0.122204169631004, 0.121154218912125, 0.120118014514446, 0.11909580975771, 0.118087843060493, 0.117094866931438, 0.116114370524883, 0.11514887958765, 0.114197142422199, 0.113258622586727, 0.112335368990898, 0.111425347626209, 0.110530316829681, 0.109648033976555, 0.108781225979328, 0.107927933335304, 0.107088379561901, 0.106262564659119, 0.105451487004757, 0.104653663933277, 0.103870823979378, 0.103101477026939, 0.102346621453762, 0.101605266332626, 0.100878641009331, 0.100164778530598, 0.0994653850793839, 0.0987810045480728, 0.0981101021170616, 0.0974532067775726, 0.0968100428581238, 0.0961813703179359, 0.0955669432878494, 0.0949660092592239, 0.0943788215517998, 0.093805618584156, 0.0932723954319954, 0.0927619189023972, 0.0922586843371391, 0.0917639434337616, 0.0912759527564049, 0.0907959565520287, 0.0903240814805031, 0.0898591950535774, 0.089402437210083, 0.0889529213309288, 0.0885112807154655, 0.0880776345729828, 0.0876508578658104, 0.0872323215007782, 0.0868209227919579, 0.0864177569746971, 0.0860224664211273, 0.0856340453028679, 0.0852536261081696, 0.0848805606365204, 0.0845157578587532, 0.0841584503650665, 0.0838080048561096, 0.0834663137793541, 0.0831316113471985, 0.082804910838604, 0.0824858248233795, 0.0821737423539162, 0.0818701535463333, 0.0815735682845116, 0.0812852084636688, 0.0810046121478081, 0.0807310044765472, 0.0804656371474266, 0.0802072808146477, 0.0799569115042686, 0.0797146633267403, 0.0794792920351028, 0.0792520344257355, 0.0790318995714188, 0.0788200125098228, 0.0786156132817268, 0.0784188434481621, 0.0782298147678375, 0.0780482888221741, 0.0778745040297508, 0.0777083411812782, 0.0775499269366264, 0.0773990079760551, 0.0772558301687241, 0.0771204009652138, 0.076991967856884, 0.0768720358610153, 0.0767598450183868, 0.0766545236110687, 0.0765574499964714, 0.0764673724770546, 0.0763856694102287, 0.0763115733861923, 0.0762447416782379, 0.0761857703328133, 0.0761340409517288, 0.0760908201336861, 0.076054722070694, 0.0760263577103615, 0.0760056152939796, 0.0759923756122589, 0.0759870037436485, 0.0759888738393784, 0.075998991727829, 0.0760167390108109, 0.0760297253727913, 0.0759957432746887, 0.0759638026356697, 0.0759337767958641, 0.0759055390954018, 0.0758791044354439, 0.0758544504642487, 0.0758317112922668, 0.0758111327886581, 0.0757921040058136, 0.0757749974727631, 0.0757596641778946, 0.0757463946938515, 0.0757347717881203, 0.0757251977920532, 0.0757171586155891, 0.0757114291191101, 0.0757072195410728, 0.0757049322128296, 0.0757044479250908, 0.0757061094045639, 0.0757094547152519, 0.0757145956158638, 0.0757213681936264, 0.0757303386926651, 0.0757412165403366, 0.0757537633180618, 0.0757682248950005, 0.0757844671607018, 0.0758028924465179, 0.0758228376507759, 0.0758447125554085, 0.0758682489395142, 0.0758941024541855, 0.0759213343262672, 0.0759507566690445, 0.0759819522500038, 0.0760150849819183, 0.076049730181694, 0.0760866850614548, 0.0761250555515289, 0.0761655941605568, 0.0762077867984772, 0.0762521624565125, 0.0762981772422791, 0.0763460174202919, 0.0763957500457764, 0.0764475390315056, 0.0765009820461273, 0.0765560790896416, 0.0766132473945618, 0.0766724348068237, 0.0767332911491394, 0.0767959505319595, 0.0768605247139931, 0.0769269987940788, 0.0769955292344093, 0.0770654603838921, 0.0771374553442001, 0.0772113502025604, 0.0772872939705849, 0.0773647651076317, 0.0774443000555038, 0.0775254741311073, 0.0776088312268257, 0.0776938572525978, 0.0777806639671326, 0.0778692588210106, 0.0779600366950035, 0.0780525803565979, 0.0781468078494072, 0.0782429575920105, 0.0782924965023994, 0.0783292278647423, 0.0783654376864433, 0.078401155769825, 0.0784363150596619, 0.0784710198640823, 0.0785051733255386, 0.0785388126969337, 0.0785720124840736, 0.0786047056317329, 0.0786368697881699, 0.0786685273051262, 0.0786996856331825, 0.0787303522229195, 0.0787604749202728, 0.0787900686264038, 0.0788192376494408, 0.0788478255271912, 0.0788759961724281, 0.0789036378264427, 0.0789307579398155, 0.0789573565125465, 0.0789834707975388, 0.0790090039372444, 0.0790341719985008, 0.0790586918592453, 0.0790828168392181, 0.0791064202785492, 0.0791294798254967, 0.0791520625352859, 0.0791741460561752, 0.0791957005858421, 0.0792167708277702, 0.0792372599244118, 0.0792573541402817, 0.0792768448591232, 0.0792959406971931, 0.0793144702911377, 0.0793325081467628, 0.0793500319123268, 0.0793670490384102, 0.0793835669755936, 0.0793995782732964, 0.0794150233268738, 0.079430066049099, 0.0794445276260376, 0.0794585645198822, 0.0794720500707626, 0.0794850066304207, 0.0794975087046623, 0.0795094966888428, 0.0795209109783173, 0.0795319005846977, 0.0795423313975334, 0.0795522630214691, 0.0795617178082466, 0.0795706957578659, 0.0795791372656822, 0.0795870870351791, 0.0795945078134537, 0.0796014592051506, 0.0796077996492386, 0.0796137154102325, 0.0796191245317459, 0.0796240419149399, 0.0796284452080727, 0.0796323865652084, 0.0796357691287994, 0.0796386823058128, 0.0796410292387009, 0.0796428620815277, 0.0796382948756218, 0.0796291753649712, 0.0796191245317459, 0.0796081200242043, 0.0795963257551193, 0.0795835182070732, 0.0795698612928391, 0.0795551538467407, 0.0795397311449051, 0.0795232355594635, 0.0795058682560921, 0.0794876292347908, 0.0794684216380119, 0.079448401927948, 0.0794274359941483, 0.0794054493308067, 0.0793827101588249, 0.0793589130043983, 0.0793343335390091, 0.0793087258934975, 0.079282209277153, 0.0792548730969429, 0.0792265459895134, 0.0791973769664764, 0.0791672989726067, 0.0791362449526787, 0.0791042968630791, 0.0790713503956795, 0.0790376141667366, 0.0790029093623161, 0.0789673402905464, 0.0789308622479439, 0.0788933783769608, 0.0788550823926926, 0.0788158625364304, 0.0787756592035294, 0.0787346437573433, 0.0786926075816154, 0.0786497592926025, 0.078605905175209, 0.0785612389445305, 0.0785156115889549, 0.0784690752625465, 0.0784216001629829, 0.0783732458949089, 0.0783239603042603, 0.0782736986875534, 0.0782226696610451, 0.0781706050038338, 0.0781176313757896, 0.0780639052391052, 0.0780090689659119, 0.0779534354805946, 0.0778968334197998, 0.0778392776846886, 0.0777809917926788, 0.0777216255664825, 0.0776614025235176, 0.0776002183556557, 0.0775382146239281, 0.0774752497673035, 0.0774113461375237, 0.0773466005921364, 0.0772808492183685, 0.0772142335772514, 0.0771467313170433, 0.0770782455801964, 0.0770089328289032, 0.076938658952713, 0.0768674463033676, 0.0767953544855118, 0.0767223387956619, 0.0766410008072853, 0.0765575841069221, 0.0764733627438545, 0.076388344168663, 0.0763025283813477, 0.0762159004807472, 0.0761284977197647, 0.0760402008891106, 0.0759511664509773, 0.0758613795042038, 0.0757706835865974, 0.0756791681051254, 0.0755869373679161, 0.0754938423633575, 0.0754000246524811, 0.0753052830696106, 0.0752097740769386, 0.0751134976744652, 0.0750163942575455, 0.0749184414744377, 0.0748197808861732, 0.0747203305363655, 0.0746199488639832, 0.0745188146829605, 0.0744168981909752, 0.0743141993880272, 0.0742106288671494, 0.0741062760353088, 0.0740011781454086, 0.073895201086998, 0.0737884193658829, 0.0736808478832245, 0.0735724940896034, 0.0734632760286331, 0.0733533650636673, 0.073242574930191, 0.0731309875845909, 0.0730185732245445, 0.0729053542017937, 0.0727913528680801, 0.0726765692234039, 0.0725609362125397, 0.0724444985389709, 0.0723273456096649, 0.0722092837095261, 0.0720904394984245, 0.0719708427786827, 0.071850374341011, 0.0717290937900543, 0.0716070681810379, 0.0714841708540916, 0.0713605433702469, 0.0712360441684723, 0.071110762655735, 0.0709846764802933, 0.0708578377962112, 0.070730097591877, 0.0706015676259995, 0.0704723596572876, 0.0703422054648399, 0.0702112466096878, 0.0700795948505402, 0.0699471011757851, 0.0698137357831001, 0.0696795880794525, 0.0695445910096169, 0.0694089159369469, 0.0692723616957664, 0.0691350027918816, 0.0689968168735504, 0.0688579604029655, 0.0687166228890419, 0.0685693845152855, 0.0684219524264336, 0.0682742595672607, 0.0681262910366058, 0.0679781213402748, 0.0678296834230423, 0.0676809474825859, 0.0675319358706474, 0.0673827677965164, 0.0672332942485809, 0.0670835971832275, 0.0669336244463921, 0.0667833760380745, 0.066632904112339, 0.0664821639657021, 0.0663311928510666, 0.066179946064949, 0.0660285204648972, 0.0658767595887184, 0.0657247751951218, 0.0655725449323654, 0.0654200613498688, 0.0652672648429871, 0.0651142820715904, 0.0649610534310341, 0.0648075565695763, 0.0646538063883781, 0.0644998103380203, 0.0643455535173416, 0.0641910061240196, 0.0640362650156021, 0.0638812780380249, 0.0637260004878044, 0.0635704770684242, 0.0634147152304649, 0.0632587000727654, 0.0631024092435837, 0.0629459097981453, 0.0627891048789024, 0.0626320689916611, 0.06247478723526, 0.062317255884409, 0.0621594674885273, 0.0620014257729053, 0.0618431344628334, 0.0616845712065697, 0.0615257807075977, 0.0613667294383049, 0.0612074509263039, 0.0610478669404984, 0.0608881004154682, 0.0607280135154724, 0.0605677142739296, 0.0604071505367756, 0.0602463334798813, 0.0600852444767952, 0.059923954308033, 0.0597623996436596, 0.0596005469560623, 0.0594384931027889, 0.0592761524021626, 0.0591135695576668, 0.0589507482945919, 0.058787677437067, 0.0586243309080601, 0.058460783213377, 0.0582969039678574, 0.0581328049302101, 0.0579684861004353, 0.0578038841485977, 0.0576395466923714, 0.0574806146323681, 0.0573221035301685, 0.0571638308465481, 0.0570058785378933, 0.0568483844399452, 0.0566910952329636, 0.056534219533205, 0.0563777126371861, 0.056221466511488, 0.0560655444860458, 0.0559100173413754, 0.0557548627257347, 0.0555999726057053, 0.0554454177618027, 0.0552912950515747, 0.0551374219357967, 0.0549839250743389, 0.0548307113349438, 0.0546779148280621, 0.0545253828167915, 0.0543732158839703, 0.0542214550077915, 0.0540699362754822, 0.0539187826216221, 0.053767953068018, 0.0536175183951855, 0.0534673444926739, 0.0533175505697727, 0.053168173879385, 0.0530190169811249, 0.0528702214360237, 0.0527217537164688, 0.0525737106800079, 0.0524259395897388, 0.0522784702479839, 0.0521314553916454, 0.0519846864044666, 0.0518382675945759, 0.0516921356320381, 0.0515464618802071, 0.0514010526239872, 0.0512559749186039, 0.0511112995445728, 0.050966914743185, 0.0508228577673435, 0.0506791360676289, 0.0505357943475246, 0.0503927432000637, 0.0502500161528587, 0.0501077324151993, 0.0499656982719898, 0.0498239919543266, 0.0496826469898224, 0.0495416857302189, 0.0494009964168072, 0.0492606796324253, 0.0491207242012024, 0.0489810444414616, 0.0488417111337185, 0.0487027056515217, 0.0485641397535801, 0.048425804823637, 0.0482878461480141, 0.0481502637267113, 0.0480129569768906, 0.0478760004043579, 0.0477393828332424, 0.0476031564176083, 0.0474672019481659, 0.0473316125571728, 0.0471963882446289, 0.047065444290638, 0.0469403229653835, 0.0468156710267067, 0.0466915778815746, 0.0465679876506329, 0.0464448966085911, 0.0463223047554493, 0.0462002120912075, 0.0460786186158657, 0.0459574982523918, 0.0458369366824627, 0.0457168407738209, 0.0455972515046597, 0.0454782508313656, 0.0453596860170364, 0.0452416241168976, 0.0451240614056587, 0.0450070612132549, 0.0448905266821384, 0.0447744950652122, 0.0446590259671211, 0.0445439592003822, 0.0444294922053814, 0.0443154573440552, 0.0442019514739513, 0.0440889485180378, 0.0439764484763145, 0.0438645035028458, 0.0437530018389225, 0.043642058968544, 0.0435315556824207, 0.0434216484427452, 0.043312169611454, 0.0432031638920307, 0.0430947840213776, 0.0429868437349796, 0.0428793989121914, 0.0427724234759808, 0.0426661036908627, 0.0425601303577423, 0.042454682290554, 0.0423498339951038, 0.0422454215586185, 0.0421415083110332, 0.0420380905270576, 0.0419352389872074, 0.0418328568339348, 0.0417309701442719, 0.0416296496987343, 0.0415287353098392, 0.0414283536374569, 0.041328527033329, 0.0412292033433914, 0.041130319237709, 0.0410319976508617, 0.0409342013299465, 0.0408368483185768, 0.0407399944961071, 0.0406436361372471, 0.0405479073524475, 0.0404526107013226, 0.0403577573597431, 0.0402634963393211, 0.0401696972548962, 0.0400764048099518, 0.0399836078286171, 0.0398913472890854, 0.0397996120154858, 0.0397083163261414, 0.0396176166832447, 0.0395273193717003, 0.0394398607313633, 0.0393540970981121, 0.0392686724662781, 0.0391835272312164, 0.039098747074604, 0.0390142127871513, 0.0389300100505352, 0.0388461463153362, 0.0387625657021999, 0.0386792160570621, 0.0385962799191475, 0.0385136678814888, 0.0384313203394413, 0.0383493006229401, 0.0382675789296627, 0.038186214864254, 0.0381051301956177, 0.0380243621766567, 0.0379439033567905, 0.0378637611865997, 0.0377839244902134, 0.0377043895423412, 0.0376252010464668, 0.0375463031232357, 0.0374677181243896, 0.0373894311487675, 0.0373114868998528, 0.0372338071465492, 0.0371564440429211, 0.0370794087648392, 0.0370027609169483, 0.0369263179600239, 0.0368502289056778, 0.0367744117975235, 0.036698967218399, 0.0366238057613373, 0.0365489199757576, 0.0364744141697884, 0.0364001877605915, 0.0363262891769409, 0.0362526588141918, 0.0361793972551823, 0.036106389015913, 0.03603370860219, 0.0359613597393036, 0.0358893014490604, 0.035817589610815, 0.035746157169342, 0.0356750562787056, 0.0356042683124542, 0.0355337709188461, 0.0354635901749134, 0.0353937186300755, 0.0353241637349129, 0.0352549478411674, 0.0351860150694847, 0.0351173654198647, 0.0350490920245647, 0.0349811092019081, 0.0349133796989918, 0.0348460078239441, 0.034778967499733, 0.0347122214734554, 0.0346457548439503, 0.0345796495676041, 0.0345138683915138, 0.0344483442604542, 0.0343831293284893, 0.0343182533979416, 0.0342536941170692, 0.0341894179582596, 0.0341255143284798, 0.0340617559850216, 0.0339947938919067, 0.0339279621839523, 0.0338612161576748, 0.033794641494751, 0.0337281301617622, 0.0336617343127728, 0.0335954390466213, 0.0335292890667915, 0.0334632284939289, 0.0333972796797752, 0.033331423997879, 0.0332657247781754, 0.0332001112401485, 0.0331345908343792, 0.0330691859126091, 0.0330039225518703, 0.0329387374222279, 0.0328736528754234, 0.0328087285161018, 0.0327438749372959, 0.0326791256666183, 0.0326145105063915, 0.0325500071048737, 0.0324855968356133, 0.0324213095009327, 0.032357107847929, 0.0322930626571178, 0.032229095697403, 0.0321652553975582, 0.0321014784276485, 0.032037902623415, 0.0319743566215038, 0.0319109298288822, 0.0318476557731628, 0.0317844897508621, 0.0317213945090771, 0.0316584222018719, 0.0315956026315689, 0.0315328240394592, 0.0314701981842518, 0.0314076729118824, 0.0313452407717705, 0.0312829688191414, 0.0312207378447056, 0.0311586670577526, 0.0310967154800892, 0.0310348682105541, 0.0309731159359217, 0.0309114288538694, 0.030849939212203, 0.0307885035872459, 0.0307271778583527, 0.030665984377265, 0.0306049156934023, 0.0305439364165068, 0.0304830633103848, 0.0304222833365202, 0.030361657962203, 0.0303011275827885, 0.0302406828850508, 0.0301803704351187, 0.0301201995462179, 0.0300600826740265, 0.0300000999122858, 0.0299402549862862, 0.0298804715275764, 0.0298208184540272, 0.0297612547874451, 0.0297018624842167, 0.0296425297856331, 0.0295790415257215, 0.0295170731842518, 0.0294551979750395, 0.0293933749198914, 0.0293316766619682, 0.0292700305581093, 0.0292084868997335, 0.0291470009833574, 0.0290856212377548, 0.0290243085473776, 0.028963090851903, 0.0289019607007504, 0.0288409162312746, 0.0287799220532179, 0.0287190545350313, 0.0286582447588444, 0.0285975001752377, 0.0285368878394365, 0.0284763239324093, 0.028415871784091, 0.0283554811030626, 0.0282951518893242, 0.0282349288463593, 0.0281747933477163, 0.0281147472560406, 0.0280547644942999, 0.0279948823153973, 0.0279350616037846, 0.0278753582388163, 0.0278157088905573, 0.0277561377733946, 0.0276966877281666, 0.0276372954249382, 0.0275779757648706, 0.0275187492370605, 0.0274596083909273, 0.0274005439132452, 0.0273415762931108, 0.0272826887667179, 0.0272238813340664, 0.0271651390939951, 0.0271065048873425, 0.0270479526370764, 0.0269894637167454, 0.0269310586154461, 0.0268727615475655, 0.0268145352602005, 0.0267563872039318, 0.0266983099281788, 0.0266403630375862, 0.0265824608504772, 0.026524618268013, 0.0264669116586447, 0.0264092534780502, 0.0263517051935196, 0.0262942221015692, 0.0262368284165859, 0.0261795185506344, 0.0261222906410694, 0.0260651241987944, 0.0260080751031637, 0.0259510912001133, 0.0258941818028688, 0.0258373767137527, 0.0257806647568941, 0.02572400867939, 0.0256674401462078, 0.0256109572947025, 0.0255545321851969, 0.0254982504993677, 0.0254419986158609, 0.0253858473151922, 0.0253293607383966, 0.0252735782414675, 0.0252179186791182, 0.0251624193042517, 0.0251070261001587, 0.0250517576932907, 0.0249966625124216, 0.0249416437000036, 0.0248867981135845, 0.0248320624232292, 0.0247774496674538, 0.0247230101376772, 0.0246686954051256, 0.0246144738048315, 0.0245603770017624, 0.0245064534246922, 0.0244526360183954, 0.0243989918380976, 0.0243454277515411, 0.0242920182645321, 0.0242387503385544, 0.0241856221109629, 0.0241325553506613, 0.0240796934813261, 0.0240269396454096, 0.0239743106067181, 0.0239218547940254, 0.0238694753497839, 0.0238172523677349, 0.0237651728093624, 0.0237131975591183, 0.0236613340675831, 0.0236096605658531, 0.0235580932348967, 0.0235066693276167, 0.0234553813934326, 0.0234042070806026, 0.0233531706035137, 0.0233022440224886, 0.0232514422386885, 0.0232007969170809, 0.0231503080576658, 0.0230999290943146, 0.0230497065931559, 0.0229995585978031, 0.0229495856910944, 0.0228997226804495, 0.0228499826043844, 0.0228003989905119, 0.0227509420365095, 0.0227016229182482, 0.0226524155586958, 0.022603377699852, 0.0225544348359108, 0.0225056037306786, 0.0224569570273161, 0.0224084202200174, 0.0223600082099438, 0.0223117507994175, 0.0222636051476002, 0.022215599194169, 0.0221677180379629, 0.0221199616789818, 0.022072346881032, 0.0220248717814684, 0.0219775065779686, 0.0219302959740162, 0.0218832120299339, 0.0218362510204315, 0.0217894334346056, 0.021742707118392, 0.0216974392533302, 0.0216516815125942, 0.0216060802340508, 0.0215606037527323, 0.0215153302997351, 0.0214702133089304, 0.0214252527803183, 0.0213804487138987, 0.0213357694447041, 0.0212912764400244, 0.0212469566613436, 0.0212027933448553, 0.0211587995290756, 0.0211149174720049, 0.0210712030529976, 0.0210276823490858, 0.0209842976182699, 0.0209410861134529, 0.0208980292081833, 0.0208551306277514, 0.0208123736083508, 0.0207698009908199, 0.0207273550331593, 0.0206850953400135, 0.0206429623067379, 0.0206010304391384, 0.0205592401325703, 0.0205176062881947, 0.0204761419445276, 0.0204347893595695, 0.0203936230391264, 0.0203526299446821, 0.0203118082135916, 0.0202711261808872, 0.0202305689454079, 0.0201902315020561, 0.0201500337570906, 0.0201099757105112, 0.0200700759887695, 0.0200303308665752, 0.019990773871541, 0.019951356574893, 0.0199121125042439, 0.0198730230331421, 0.019834091886878, 0.0197953302413225, 0.0197566468268633, 0.0197181981056929, 0.019679905846715, 0.0196417849510908, 0.0196037888526917, 0.019565936177969, 0.0195282809436321, 0.0194907542318106, 0.0194534156471491, 0.0194162335246801, 0.019379174336791, 0.0193423181772232, 0.0193056035786867, 0.0192690435796976, 0.019232640042901, 0.0191963631659746, 0.0191603042185307, 0.0191243700683117, 0.0190886072814465, 0.0190530326217413, 0.0190175846219063, 0.0189822893589735, 0.0189471207559109, 0.0189121533185244, 0.0188773591071367, 0.0188423004001379, 0.0188089590519667, 0.0187757946550846, 0.0187427587807178, 0.0187098551541567, 0.0186770837754011, 0.0186444278806448, 0.0186119135469198, 0.0185795500874519, 0.0185473151504993, 0.0185152217745781, 0.0184832159429789, 0.0184513889253139, 0.0184197034686804, 0.0183881316334009, 0.0183566976338625, 0.0183253921568394, 0.0182942133396864, 0.0182631835341454, 0.0182322859764099, 0.0182015430182219, 0.0181709043681622, 0.0181403886526823, 0.0181100387126207, 0.0180798042565584, 0.0180497113615274, 0.0180197730660439, 0.0179899446666241, 0.0179602187126875, 0.0179306548088789, 0.0179012566804886, 0.0178719684481621, 0.0178428124636412, 0.0178137719631195, 0.0177848730236292, 0.0177561230957508, 0.0177275035530329, 0.0176990516483784, 0.0176706593483686, 0.0176424328237772, 0.0176143683493137, 0.0175864230841398, 0.0175586026161909, 0.0175309292972088, 0.0175033584237099, 0.0174759421497583, 0.0174486748874187, 0.0174215249717236, 0.0173945240676403, 0.0173676162958145, 0.017340887337923, 0.0173142701387405, 0.0172878056764603, 0.0172614697366953, 0.0172352250665426, 0.0172091536223888, 0.0171832218766212, 0.0171574391424656, 0.017131756991148, 0.0171061847358942, 0.0170807912945747, 0.0170555226504803, 0.0170303862541914, 0.0170054007321596, 0.0169805008918047, 0.016955778002739, 0.0169311817735434, 0.0169067196547985, 0.016882386058569, 0.0168581828474998, 0.0168341156095266, 0.0168101899325848, 0.0167883243411779, 0.0167656186968088, 0.0167429391294718, 0.0167203024029732, 0.0166977327316999, 0.0166751928627491, 0.0166527014225721, 0.0166302584111691, 0.0166078712791204, 0.0165855139493942, 0.0165632106363773, 0.0165409613400698, 0.0165187548846006, 0.0164965968579054, 0.0164744853973389, 0.0164524093270302, 0.016430389136076, 0.0164084024727345, 0.0163864865899086, 0.0163645967841148, 0.0163427665829659, 0.0163209810853004, 0.0162992384284735, 0.0162775348871946, 0.0162558984011412, 0.0162342861294746, 0.016212722286582, 0.0161912068724632, 0.0161697510629892, 0.0161483325064182, 0.0161269567906857, 0.0161056369543076, 0.0160843580961227, 0.016063129529357, 0.0160419568419456, 0.016020817682147, 0.0159997176378965, 0.0159786641597748, 0.0159576795995235, 0.0159367192536592, 0.0159158259630203, 0.0158949699252844, 0.0158741548657417, 0.0158533826470375, 0.015832681208849, 0.0158119983971119, 0.0157913714647293, 0.0157707799226046, 0.0157502572983503, 0.0157297700643539, 0.0157093219459057, 0.0156889371573925, 0.0156685896217823, 0.0156482979655266, 0.0156280528753996, 0.0156078422442079, 0.0155876791104674, 0.0155675588175654, 0.0155475018545985, 0.0155274774879217, 0.0155074950307608, 0.0154875926673412, 0.01546770054847, 0.0154478643089533, 0.0154280913993716, 0.0154083464294672, 0.0153886387124658, 0.0153689906001091, 0.0153493899852037, 0.0153298312798142, 0.0153103219345212, 0.01529102306813, 0.0152708766981959, 0.0152506679296494, 0.015230412594974, 0.0152100836858153, 0.0151897249743342, 0.0151693215593696, 0.0151488585397601, 0.0151283349841833, 0.0151077657938004, 0.015087153762579, 0.0150664784014225, 0.0150457676500082, 0.0150249823927879, 0.0150041645392776, 0.0149832963943481, 0.0149623723700643, 0.0149414008483291, 0.0149203576147556, 0.0148992836475372, 0.0148781575262547, 0.0148569820448756, 0.0148357357829809, 0.0148144597187638, 0.0147931259125471, 0.0147717352956533, 0.0147503111511469, 0.0147288087755442, 0.014707270078361, 0.0146856866776943, 0.0146640483289957, 0.0146423606202006, 0.0146205965429544, 0.0145988101139665, 0.014576961286366, 0.0145550686866045, 0.0145331220701337, 0.0145111177116632, 0.0144890695810318, 0.0144669665023685, 0.0144448094069958, 0.0144226085394621, 0.0144003471359611, 0.0143780410289764, 0.0143556892871857, 0.0143332788720727, 0.0143108144402504, 0.0142882987856865, 0.0142657347023487, 0.0142431277781725, 0.0142204603180289, 0.0141977509483695, 0.0141749689355493, 0.0141521515324712, 0.0141292791813612, 0.0141063658520579, 0.0140833798795938, 0.0140603603795171, 0.0140372887253761, 0.0140141695737839, 0.0139909889549017, 0.0139677515253425, 0.0139444740489125, 0.0139211444184184, 0.0138977691531181, 0.0138743380084634, 0.0138508407399058, 0.0138272996991873, 0.0138037241995335, 0.0137800863012671, 0.0137564018368721, 0.0137326512485743, 0.0137071218341589, 0.0136814694851637, 0.0136557491496205, 0.0136299580335617, 0.0136040505021811, 0.0135780964046717, 0.0135520398616791, 0.0135259265080094, 0.0134997228160501, 0.0134734082967043, 0.0134470546618104, 0.0134205995127559, 0.0133940745145082, 0.0133674629032612, 0.0133407674729824, 0.0133139854297042, 0.0132871316745877, 0.0132602080702782, 0.0132331755012274, 0.0132060805335641, 0.013178906403482, 0.0131516559049487, 0.013124318793416, 0.0130968801677227, 0.0130693931132555, 0.013041808269918, 0.0130141582340002, 0.012986415065825, 0.0129585852846503, 0.0129306707531214, 0.0129026854410768, 0.0128746293485165, 0.0128464726731181, 0.0128182452172041, 0.0127899395301938, 0.0127615565434098, 0.0127330794930458, 0.0127045307308435, 0.012675890699029, 0.0126471882686019, 0.0126183815300465, 0.0125895151868463, 0.0125605771318078, 0.0125315133482218, 0.0125024048611522, 0.0124732227995992, 0.0124439345672727, 0.0124145671725273, 0.0123851373791695, 0.0123556144535542, 0.0123260198161006, 0.0122963255271316, 0.0122665595263243, 0.0122367078438401, 0.0122067928314209, 0.0121768014505506, 0.012146707624197, 0.0121165364980698, 0.0120862871408463, 0.0120559595525265, 0.0120255602523685, 0.0119950696825981, 0.0119644990190864, 0.0119338436052203, 0.011903109960258, 0.0118722897022963, 0.011841400526464, 0.0118104238063097, 0.0117793772369623, 0.0117482459172606, 0.0117170205339789, 0.011686509475112, 0.0116539727896452, 0.0116214379668236, 0.0115888500586152, 0.0115562546998262, 0.0115236276760697, 0.0114909568801522, 0.0114582823589444, 0.0114255575463176, 0.0113928131759167, 0.0113600492477417, 0.0113272620365024, 0.0112944273278117, 0.0112615786492825, 0.0112286806106567, 0.0111957723274827, 0.0111628333106637, 0.0111298784613609, 0.0110968910157681, 0.0110638700425625, 0.0110308201983571, 0.010997736826539, 0.0109646255150437, 0.0109314946457744, 0.0108983358368278, 0.01086516212672, 0.0108319530263543, 0.0107986973598599, 0.0107654258608818, 0.010732127353549, 0.0106987925246358, 0.0106654549017549, 0.0106320818886161, 0.0105986576527357, 0.0105652306228876, 0.0105317439883947, 0.0104982620105147, 0.0104647325351834, 0.0104311918839812, 0.0103976279497147, 0.0103640286251903, 0.0103303818032146, 0.0102967275306582, 0.0102630313485861, 0.0102293184027076, 0.0101955775171518, 0.0101618142798543, 0.0101280156522989, 0.0100941713899374, 0.0100603243336082, 0.0100264484062791, 0.00999253708869219, 0.00995860155671835, 0.00992465484887362, 0.00989065319299698, 0.0098566235974431, 0.00982257258147001, 0.00978849548846483, 0.00975438486784697, 0.0097202630713582, 0.00968611240386963, 0.0096519123762846, 0.00961770303547382, 0.00958346389234066, 0.00954917725175619, 0.00951488688588142, 0.00948056951165199, 0.00944621581584215, 0.00941184349358082, 0.00937740877270699, 0.00934298522770405, 0.00930850673466921, 0.00927322078496218, 0.00923818070441484, 0.0092032253742218, 0.0091683454811573, 0.0091335279867053, 0.00909879617393017, 0.0090641500428319, 0.0090295597910881, 0.00899509247392416, 0.00896064285188913, 0.00892630126327276, 0.00889205373823643, 0.00885784532874823, 0.00882373843342066, 0.00878967065364122, 0.00875575002282858, 0.00872186943888664, 0.00868803635239601, 0.00865432620048523, 0.00862068869173527, 0.00858708843588829, 0.00855361856520176, 0.00852019432932138, 0.00848685298115015, 0.00845360103994608, 0.00842039566487074, 0.0083872964605689, 0.00835423450917006, 0.00832130294293165, 0.00828844960778952, 0.00825562700629234, 0.0082229133695364, 0.00819025095552206, 0.00815768539905548, 0.00812519248574972, 0.00809279084205627, 0.00806045159697533, 0.00802816078066826, 0.00799600966274738, 0.00796391349285841, 0.007931855507195, 0.00789991579949856, 0.00786806922405958, 0.00783625058829784, 0.00780453206971288, 0.00777288479730487, 0.00774132739752531, 0.00770983984693885, 0.00767840351909399, 0.00764710735529661, 0.00761583494022489, 0.00758464820683002, 0.00755357043817639, 0.0075225243344903, 0.00749158719554543, 0.00746072130277753, 0.00742993270978332, 0.00739922188222408, 0.00736856274306774, 0.0073380284011364, 0.00730754481628537, 0.0072771143168211, 0.00724678672850132, 0.00721653737127781, 0.00718637369573116, 0.00715627241879702, 0.00712625682353973, 0.00709631573408842, 0.00706645613536239, 0.00703666685149074, 0.00700696790590882, 0.00697693275287747, 0.00694863498210907, 0.00692049320787191, 0.00689252326264977, 0.00686474144458771, 0.00683708395808935, 0.00680959830060601, 0.00678225280717015, 0.00675512664020061, 0.00672815646976233, 0.00670137349516153, 0.00667471578344703, 0.00664830813184381, 0.00662199361249804, 0.00659589748829603, 0.00656994339078665, 0.00654414389282465, 0.00651853252202272, 0.0064930459484458, 0.00646782433614135, 0.00644272798672318, 0.00641774199903011, 0.0063929888419807, 0.00636836094781756, 0.0063439360819757, 0.00631965231150389, 0.00629560183733702, 0.00627166219055653, 0.00624790880829096, 0.00622429605573416, 0.00620090216398239, 0.00617761770263314, 0.0061545199714601, 0.00613161036744714, 0.00610891915857792, 0.00608635321259499, 0.00606391159817576, 0.00604170467704535, 0.00601960672065616, 0.00599769642576575, 0.0059759421274066, 0.00595434382557869, 0.00593298021703959, 0.00591175723820925, 0.00589067442342639, 0.0058697946369648, 0.00584908667951822, 0.0058285347186029, 0.00580818625167012, 0.00578796258196235, 0.00576792610809207, 0.00574806146323681, 0.00572832161560655, 0.00570880109444261, 0.00568945147097111, 0.00567022711038589, 0.00565125280991197, 0.00563235674053431, 0.00561366323381662, 0.00559515738859773, 0.00557680800557137, 0.00555862952023745, 0.00554059213027358, 0.00552275776863098, 0.00550506450235844, 0.00548754213377833, 0.00547022325918078, 0.00545307574793696, 0.00543606886640191, 0.00541923381388187, 0.00540253985673189, 0.00538585241883993, 0.00537192262709141, 0.00535813253372908, 0.00534453056752682, 0.00533105339854956, 0.00531777879223228, 0.0053046140819788, 0.00529173016548157, 0.00527890864759684, 0.00526625942438841, 0.00525375036522746, 0.00524144386872649, 0.00522924726828933, 0.00521723832935095, 0.00520538492128253, 0.00519370380789042, 0.0051822098903358, 0.00517087196931243, 0.0051596905104816, 0.00514863384887576, 0.00513779558241367, 0.00512705137953162, 0.00511652557179332, 0.0051061250269413, 0.00509594241157174, 0.00508585432544351, 0.00507598463445902, 0.00506620854139328, 0.00505666667595506, 0.0050472179427743, 0.00503798853605986, 0.00502886855974793, 0.00501996697857976, 0.00501119019463658, 0.00500258570536971, 0.00499408971518278, 0.00498582888394594, 0.00497769238427281, 0.00496969651430845, 0.00496196653693914, 0.00495431385934353, 0.0049468339420855, 0.00493952492251992, 0.00493235699832439, 0.0049252980388701, 0.0049184737727046, 0.00491178967058659, 0.00490526156499982, 0.00489895278587937, 0.00489275297150016, 0.00488672498613596, 0.00488085253164172, 0.00487516820430756, 0.00486962404102087, 0.00486420560628176, 0.00485900463536382, 0.00485392939299345, 0.00484904134646058, 0.00484432466328144, 0.00483976490795612, 0.00483536114916205, 0.00483108218759298, 0.00482699042186141, 0.0048230392858386, 0.00481929117813706, 0.00481566833332181, 0.00481223268434405, 0.00480893766507506, 0.0048058140091598, 0.00480287848040462, 0.00480009848251939, 0.00479742791503668, 0.00479523418471217, 0.00479257944971323, 0.00479002622887492, 0.00478755868971348, 0.00478521641343832, 0.00478294398635626, 0.00478080427274108, 0.00477869622409344, 0.00477672833949327, 0.00477483123540878, 0.00477303517982364, 0.00477133272215724, 0.00476970849558711, 0.00476820161566138, 0.00476675666868687, 0.00476544536650181, 0.00476421136409044, 0.00476307142525911, 0.00476200925186276, 0.0047610648907721, 0.00476022157818079, 0.00475942483171821, 0.00475876126438379, 0.00475817546248436, 0.00475767627358437, 0.00475728558376431, 0.00475696567445993, 0.00475677009671926, 0.00475668394938111, 0.00475665321573615, 0.00475670769810677, 0.00475688744336367, 0.00475716078653932, 0.00475751189514995, 0.00475795706734061, 0.00475848047062755, 0.00475912867113948, 0.00475985463708639, 0.00476070586591959, 0.00476158782839775, 0.00476261880248785, 0.00476373545825481, 0.00476492196321487, 0.00476621044799685, 0.0047675920650363, 0.00476906076073647, 0.00477063003927469, 0.0047723320312798, 0.00477404985576868, 0.00477592414245009, 0.0047778682783246, 0.00477992976084352, 0.00478203827515244, 0.00478427112102509, 0.00478658266365528, 0.00478900317102671, 0.00479152519255877, 0.00479410961270332, 0.0047967960126698, 0.00479961466044188, 0.00480250362306833, 0.00480546336621046, 0.0048085474409163, 0.00481170183047652, 0.00481495819985867, 0.0048182844184339, 0.00482173543423414, 0.0048252809792757, 0.00482895085588098, 0.00483265984803438, 0.0048364857211709, 0.00483995256945491, 0.00484339194372296, 0.00484689045697451, 0.00485042715445161, 0.00485401973128319, 0.00485764211043715, 0.00486133201047778, 0.00486506009474397, 0.00486883940175176, 0.00487266993150115, 0.00487653072923422, 0.00488045066595078, 0.00488442881032825, 0.00488843861967325, 0.00489251082763076, 0.00489661796018481, 0.00490077212452888, 0.00490498449653387, 0.00490923598408699, 0.00491353869438171, 0.00491789169609547, 0.00492228008806705, 0.00492672715336084, 0.00493121659383178, 0.00493576098233461, 0.00494035240262747, 0.00494497129693627, 0.00494965258985758, 0.00495439581573009, 0.00495917443186045, 0.00496399635449052, 0.00496886111795902, 0.00497378408908844, 0.00497875409200788, 0.00498375948518515, 0.00498883472755551, 0.00499394163489342, 0.00499909510836005, 0.00500430725514889, 0.00500955851748586, 0.00501486379653215, 0.00502020539715886, 0.00502559263259172, 0.00503104319795966, 0.00503654032945633, 0.00504208030179143, 0.00504767848178744, 0.00505329249426723, 0.00505898147821426, 0.00506470864638686, 0.00507048703730106, 0.00507631991058588, 0.00508218025788665, 0.00508811045438051, 0.00509407604113221, 0.00510008493438363, 0.00510615995153785, 0.00511225033551455, 0.00511841895058751, 0.00512462249025702, 0.00513087352737784, 0.00513718230649829, 0.00514352275058627, 0.00514992140233517, 0.00515635591000319, 0.00516285980120301, 0.00516940327361226, 0.00517598586156964, 0.00518260756507516, 0.00518928747624159, 0.00519602978602052, 0.00520281167700887, 0.00520941475406289, 0.00521690305322409, 0.00522435968741775, 0.00523181678727269, 0.0052392934449017, 0.00524675427004695, 0.00525422720238566, 0.00526168430224061, 0.00526914885267615, 0.00527659058570862, 0.00528403557837009, 0.00529149640351534, 0.0052989455871284, 0.00530638732016087, 0.00531382812187076, 0.00532127777114511, 0.00532871531322598, 0.00533614121377468, 0.00534357829019427, 0.00535101583227515, 0.00535844545811415, 0.00536587135866284, 0.00537330098450184, 0.00538071896880865, 0.00538813695311546, 0.00539557449519634, 0.00540298130363226, 0.00541040301322937, 0.00541780143976212, 0.00542520359158516, 0.00543263321742415, 0.00544002000242472, 0.00544744590297341, 0.00545484013855457, 0.00546224694699049, 0.00546962581574917, 0.00547701632604003, 0.00548442639410496, 0.00549179734662175, 0.00549919996410608, 0.00550657510757446, 0.00551396980881691, 0.005521344486624, 0.00552871590480208, 0.00553611014038324, 0.00554346991702914, 0.00555085251107812, 0.00555821182206273, 0.00556559488177299, 0.00557295000180602, 0.00558030977845192, 0.00558768073096871, 0.00559502886608243, 0.00560239609330893, 0.00560974376276135, 0.0056170909665525, 0.00562444655224681, 0.00563178677111864, 0.00563914235681295, 0.00564647791907191, 0.00565383350476623, 0.00566116161644459, 0.00566848600283265, 0.00567582994699478, 0.00568315805867314, 0.00569050200283527, 0.00569781428202987, 0.005705158226192, 0.00571246678009629, 0.00571978744119406, 0.00572710763663054, 0.00573453726246953, 0.00574128422886133, 0.00574792921543121, 0.00575454998761415, 0.00576112512499094, 0.00576762156561017, 0.0057741105556488, 0.0057805054821074, 0.00578685337677598, 0.00579310022294521, 0.00579934706911445, 0.0058055161498487, 0.00581163773313165, 0.00581772811710835, 0.00582373235374689, 0.00582969840615988, 0.00583555456250906, 0.00584139535203576, 0.00584720494225621, 0.0058529363013804, 0.00585862109437585, 0.00586423510685563, 0.00586981046944857, 0.00587529176846147, 0.00588074186816812, 0.00588615285232663, 0.00589148607105017, 0.00589678809046745, 0.00590201979503036, 0.00590720493346453, 0.00591229600831866, 0.00591734750196338, 0.00592236872762442, 0.0059273112565279, 0.00593223096802831, 0.00593705615028739, 0.00594185851514339, 0.00594655936583877, 0.00595122016966343, 0.00595584325492382, 0.00596040347591043, 0.0059649245813489, 0.0059693674556911, 0.00597378658130765, 0.00597808137536049, 0.00598236825317144, 0.00598660064861178, 0.00599077017977834, 0.00599490851163864, 0.00599896116182208, 0.0060029667802155, 0.00600688671693206, 0.00601078290492296, 0.00601464044302702, 0.00601841928437352, 0.00602215994149446, 0.00602582190185785, 0.00602942984551191, 0.0060329744592309, 0.00603647250682116, 0.00603993982076645, 0.00604333635419607, 0.00604668585583568, 0.00604995805770159, 0.00605317484587431, 0.00605632923543453, 0.00605945289134979, 0.00606252159923315, 0.00606551207602024, 0.0060684634372592, 0.00607135286554694, 0.00607419526204467, 0.00607738876715302, 0.00607952801510692, 0.00608158949762583, 0.00608358858153224, 0.00608549360185862, 0.00608732085675001, 0.00608906988054514, 0.00609070993959904, 0.00609228760004044, 0.00609380239620805, 0.00609525432810187, 0.00609658192843199, 0.00609786249697208, 0.00609908020123839, 0.00610014237463474, 0.00610120454803109, 0.00610217219218612, 0.00610303180292249, 0.00610384345054626, 0.00610459316521883, 0.00610524928197265, 0.00610576430335641, 0.00610626395791769, 0.00610668584704399, 0.00610698247328401, 0.00610724836587906, 0.00610743556171656, 0.00610751379281282, 0.00610751379281282, 0.00610745139420033, 0.00610727956518531, 0.00610709236934781, 0.00610681064426899, 0.00610643578693271, 0.00610596779733896, 0.00610542064532638, 0.0061047961935401, 0.00610407814383507, 0.0061033284291625, 0.00610250048339367, 0.00610154820606112, 0.00610054843127728, 0.0060994396917522, 0.00609825318679214, 0.00609701918438077, 0.00609570741653442, 0.00609431741759181, 0.00609283382073045, 0.00609128782525659, 0.00608963239938021, 0.00608788337558508, 0.00608610268682241, 0.00608424423262477, 0.00608227681368589, 0.00608024699613452, 0.00607815384864807, 0.00607590517029166, 0.00607365602627397, 0.00607131374999881, 0.00606887741014361, 0.00606639450415969, 0.00606383383274078, 0.00606113160029054, 0.00605838326737285, 0.00605558743700385, 0.00605269847437739, 0.0060497154481709, 0.0060466704890132, 0.00604354729875922, 0.00604026764631271, 0.00603698845952749, 0.00603240914642811, 0.00602866057306528, 0.00602489709854126, 0.00602107075974345, 0.0060170735232532, 0.00601312192156911, 0.00600903062149882, 0.0060048452578485, 0.0060005821287632, 0.00599627196788788, 0.00599185237661004, 0.00598735455423594, 0.0059828101657331, 0.0059781251475215, 0.00597339356318116, 0.00596859864890575, 0.00596371060237288, 0.00595872895792127, 0.00595370074734092, 0.00594856217503548, 0.00594340916723013, 0.00593809923157096, 0.00593272736296058, 0.00592730799689889, 0.00592173263430595, 0.00591615820303559, 0.00591048877686262, 0.00590469501912594, 0.00589888542890549, 0.00589296687394381, 0.00588692305609584, 0.00588087923824787, 0.00587474182248116, 0.00586844841018319, 0.00586213963106275, 0.005855783354491, 0.00584931811317801, 0.00584274344146252, 0.005836121737957, 0.00582940690219402, 0.00582259800285101, 0.00581574207171798, 0.0058087925426662, 0.00580174941569567, 0.00579467508941889, 0.00578746013343334, 0.00578018231317401, 0.00577285792678595, 0.00576542504131794, 0.00575791299343109, 0.0057503548450768, 0.0057426868006587, 0.00573494099080563, 0.00572708575055003, 0.00571921514347196, 0.00571125000715256, 0.00570316100493073, 0.00569502450525761, 0.00568684097379446, 0.00567848607897758, 0.00567013118416071, 0.00566169852390885, 0.00565312476828694, 0.00564453564584255, 0.00563585245981812, 0.00562705984339118, 0.00561820575967431, 0.00560928834602237, 0.00560026196762919, 0.00559115735813975, 0.00558202108368278, 0.00557288574054837, 0.0055629457347095, 0.00555296707898378, 0.00554288551211357, 0.00553279789164662, 0.00552263855934143, 0.00551240192726254, 0.00550214154645801, 0.00549183506518602, 0.00548141077160835, 0.00547099439427257, 0.00546047650277615, 0.00544992741197348, 0.00543934712186456, 0.00542866531759501, 0.00541794439777732, 0.00540718389675021, 0.00539634609594941, 0.005385453812778, 0.00537453731521964, 0.00536352023482323, 0.00535247102379799, 0.00534139107912779, 0.00533020915463567, 0.00531898066401482, 0.00530774472281337, 0.00529639096930623, 0.00528501393273473, 0.00527356751263142, 0.0052620810456574, 0.00525053264573216, 0.00523892138153315, 0.00522724026814103, 0.00521552795544267, 0.005203768145293, 0.00519193056970835, 0.00518006179481745, 0.00516812317073345, 0.00515612121671438, 0.00514408899471164, 0.00513197761029005, 0.00511981267482042, 0.00510760815814137, 0.00509529421105981, 0.00508298818022013, 0.00507063558325171, 0.00505816517397761, 0.00504567986354232, 0.00503314752131701, 0.00502052111551166, 0.00500787142664194, 0.0049951751716435, 0.00498236948624253, 0.00496956380084157, 0.0049567031674087, 0.00494375685229897, 0.00493075605481863, 0.00491772359237075, 0.00490461383014917, 0.00489144865423441, 0.00487825274467468, 0.0048649781383574, 0.00485165743157268, 0.00483826594427228, 0.00482481205835938, 0.00481132697314024, 0.00479779485613108, 0.00478418497368693, 0.00477052014321089, 0.00475682411342859, 0.00474303495138884, 0.00472920620813966, 0.00471745803952217, 0.00470341462641954, 0.00468934373930097, 0.00467528868466616, 0.00466121407225728, 0.00464713526889682, 0.00463303364813328, 0.00461893575266004, 0.00460480200126767, 0.00459069665521383, 0.00457656290382147, 0.00456242589280009, 0.00454827351495624, 0.00453410902991891, 0.00451994035393, 0.00450574466958642, 0.00449157645925879, 0.00447737658396363, 0.0044631534256041, 0.00444894656538963, 0.00443471968173981, 0.00442047696560621, 0.0044062421657145, 0.00439198827371001, 0.00437771435827017, 0.00436344090849161, 0.00434916699305177, 0.00433485768735409, 0.00432056421414018, 0.00430626701563597, 0.00429194280877709, 0.00427761068567634, 0.00426327437162399, 0.00424892641603947, 0.00423454726114869, 0.00422019511461258, 0.00420581642538309, 0.00419141724705696, 0.00417703064158559, 0.00416263192892075, 0.00414820993319154, 0.00413378374651074, 0.00411935383453965, 0.00410489644855261, 0.00409045116975904, 0.00407599005848169, 0.0040615051984787, 0.00404703663662076, 0.00403254432603717, 0.00401803571730852, 0.00400353595614433, 0.00398902781307697, 0.00397449638694525, 0.00395994121208787, 0.00394541397690773, 0.00393083179369569, 0.0039162733592093, 0.0039017025846988, 0.00388712412677705, 0.00387251889333129, 0.00385793251916766, 0.00384331517852843, 0.00382867408916354, 0.00381406070664525, 0.00379941193386912, 0.00378475221805274, 0.00377009971998632, 0.00375542719848454, 0.00374073628336191, 0.00372605258598924, 0.00371136469766498, 0.00369607587344944, 0.00368174375034869, 0.00366745819337666, 0.00365317286923528, 0.00363892666064203, 0.00362469558604062, 0.00361052737571299, 0.00359636289067566, 0.0035822531208396, 0.00356817082501948, 0.00355409644544125, 0.00354008423164487, 0.00352607178501785, 0.00351211428642273, 0.00349816516973078, 0.00348429707810283, 0.00347042549401522, 0.00345659302547574, 0.00344277964904904, 0.00342902960255742, 0.00341525138355792, 0.00340155558660626, 0.00338788726367056, 0.00337422639131546, 0.00336061627604067, 0.00334703759290278, 0.00333348219282925, 0.00331996567547321, 0.00330644589848816, 0.00329300761222839, 0.00327957724221051, 0.003266193671152, 0.00325282546691597, 0.00323949288576841, 0.00322619546204805, 0.00321289733983576, 0.00319966999813914, 0.00318647781386971, 0.00317329703830183, 0.00316015584394336, 0.00314703746698797, 0.00313396635465324, 0.00312089920043945, 0.00310789817012846, 0.0030949127394706, 0.00308196269907057, 0.00306903221644461, 0.00305615202523768, 0.00304328394122422, 0.00303042749874294, 0.00301764509640634, 0.00300489785149693, 0.00299215456470847, 0.00297946226783097, 0.0029667851049453, 0.00295414729043841, 0.00294153671711683, 0.00292896153405309, 0.00291642523370683, 0.00290389661677182, 0.00289141479879618, 0.00287896045483649, 0.00286655290983617, 0.00285415723919868, 0.00284180836752057, 0.00282946694642305, 0.00281718838959932, 0.00280492543242872, 0.00279270531609654, 0.00278051244094968, 0.00276833516545594, 0.00275620096363127, 0.00274256756529212, 0.00273085501976311, 0.00271918927319348, 0.00270757055841386, 0.00269602960906923, 0.00268452032469213, 0.00267307320609689, 0.00266170408576727, 0.00265033519826829, 0.00263905967585742, 0.00262784701772034, 0.00261668115854263, 0.00260553066618741, 0.00259445840492845, 0.00258343270979822, 0.00257245451211929, 0.00256155361421406, 0.00255070021376014, 0.00253990897908807, 0.00252914894372225, 0.00251845153979957, 0.00250781653448939, 0.00249721296131611, 0.00248667155392468, 0.00247620837762952, 0.00246576080098748, 0.00245539098978043, 0.00244506844319403, 0.00243479246273637, 0.00242456351406872, 0.00241439719684422, 0.0024043086450547, 0.00239423592574894, 0.00238424120470881, 0.00237429328262806, 0.0023644077591598, 0.00235455366782844, 0.00234476197510958, 0.00233503268100321, 0.00232533481903374, 0.00231569912284613, 0.00230614189058542, 0.00229658442549407, 0.0022871361579746, 0.00227773492224514, 0.00226838025264442, 0.00225904164835811, 0.00224979664199054, 0.00224062940105796, 0.00223144679330289, 0.00222235778346658, 0.00221331580542028, 0.00220433599315584, 0.00219538784585893, 0.00218651746399701, 0.00217770971357822, 0.0021689017303288, 0.00216018757782876, 0.00215150462463498, 0.00214291573502123, 0.00213434174656868, 0.00212584645487368, 0.00211739772930741, 0.00210898020304739, 0.00210064090788364, 0.00209236401133239, 0.00208413391374052, 0.00207591964863241, 0.0020677677821368, 0.00205972511321306, 0.00205166661180556, 0.00204400555230677, 0.00203644670546055, 0.00202893512323499, 0.00202151737175882, 0.00201414618641138, 0.00200683763250709, 0.00199952884577215, 0.00199234485626221, 0.0019851925317198, 0.00197808700613678, 0.00197101244702935, 0.00196406315080822, 0.00195714458823204, 0.00195022649131715, 0.00194341759197414, 0.0019366400083527, 0.00192992470692843, 0.00192328752018511, 0.00191668164916337, 0.00191012246068567, 0.00190364173613489, 0.00189720746129751, 0.00189086701720953, 0.0018844953738153, 0.00187824864406139, 0.00187203323002905, 0.00186586449854076, 0.00185975839849561, 0.00185373029671609, 0.00184776470996439, 0.0018417991232127, 0.00183594273403287, 0.00183011754415929, 0.00182433950249106, 0.00181865494232625, 0.00181297026574612, 0.0018073640530929, 0.00180183572228998, 0.00179635407403111, 0.00179095077328384, 0.0017855316400528, 0.00178023765329272, 0.0017749589169398, 0.00176974316127598, 0.00176460540387779, 0.00175949861295521, 0.0017544855363667, 0.00174944137688726, 0.00174455333035439, 0.00173969625029713, 0.00173483963590115, 0.00173009186983109, 0.00172537576872855, 0.0017207064665854, 0.00171614612918347, 0.00171158625744283, 0.00170711986720562, 0.00170265347696841, 0.00169829628430307, 0.00169398600701243, 0.00168969121295959, 0.00168552179820836, 0.00168135191779584, 0.00167727610096335, 0.00167319993488491, 0.00166923343203962, 0.00166531361173838, 0.00166140939109027, 0.00165761448442936, 0.00165385066065937, 0.0016501653008163, 0.0016464953077957, 0.0016437650192529, 0.00164051668252796, 0.00163726834580302, 0.00163409824017435, 0.00163095933385193, 0.00162785942666233, 0.00162480631843209, 0.00162178452592343, 0.00161880953237414, 0.00161584233865142, 0.00161294534336776, 0.0016100873472169, 0.00160725286696106, 0.00160445750225335, 0.00160168565344065, 0.0015989993698895, 0.00159632915165275, 0.00159366626758128, 0.00159109756350517, 0.00158851291052997, 0.00158601417206228, 0.00158352346625179, 0.00158107909373939, 0.00157869001850486, 0.0015763082774356, 0.00157400488387793, 0.00157174048945308, 0.00156946037895977, 0.00156727409921587, 0.00156508770305663, 0.00156297173816711, 0.00156088697258383, 0.00155881769023836, 0.00155681860633194, 0.00155481975525618, 0.00155290670227259, 0.00155097804963589, 0.0015491273952648, 0.00154733925592154, 0.00154552771709859, 0.00154380989260972, 0.00154209206812084, 0.00154042895883322, 0.00153881253208965, 0.00153721962124109, 0.00153568130917847, 0.00153415091335773, 0.00153271411545575, 0.00153126171790063, 0.00152987195178866, 0.00152853666804731, 0.00152719370089471, 0.00152594433166087, 0.00152467156294733, 0.00152348470874131, 0.00152235256973654, 0.00152120471466333, 0.0015201271744445, 0.00151908071711659, 0.00151808129157871, 0.00151712086517364, 0.00151619163807482, 0.00151530932635069, 0.00151444261427969, 0.00151363830082119, 0.0015128965023905, 0.00151211570482701, 0.00151145982090384, 0.0015107961371541, 0.00151017133612186, 0.00150959368329495, 0.00150863325688988, 0.00150802999269217, 0.00150745618157089, 0.00150688318535686, 0.00150632183067501, 0.0015058018034324, 0.00150526873767376, 0.00150477490387857, 0.00150427909102291, 0.00150379980914295, 0.00150334788486362, 0.00150290376041085, 0.0015024715103209, 0.00150206428952515, 0.00150166812818497, 0.00150127580855042, 0.00150092341937125, 0.00150056718848646, 0.00150023528840393, 0.001499920967035, 0.00149960955604911, 0.00149933446664363, 0.00149905914440751, 0.00149879464879632, 0.00149856437928975, 0.0014983369037509, 0.00149812025483698, 0.00149794446770102, 0.0014977561077103, 0.00149758625775576, 0.00149745459202677, 0.00149731303099543, 0.00149718904867768, 0.00149709929246455, 0.00149701919872314, 0.00149693328421563, 0.00149689626414329, 0.00149684946518391, 0.00149682501796633, 0.00149682885967195, 0.00149683468043804, 0.00149684748612344, 0.00149689812678844, 0.00149694993160665, 0.00149703770875931, 0.0014971176860854, 0.00149721640627831, 0.00149733934085816, 0.00149746728129685, 0.00149761256761849, 0.00149779231287539, 0.00149796495679766, 0.00149815727490932, 0.0014983827713877, 0.00149860430974513, 0.00149884249549359, 0.00149910792242736, 0.00149937439709902, 0.00149966811295599, 0.0014999775448814, 0.00150029198266566, 0.00150062376633286, 0.00150099070742726, 0.00150134891737252, 0.00150172761641443, 0.00150213181041181, 0.00150254648178816, 0.00150297302752733, 0.00150342402048409, 0.00150388572365046, 0.00150436395779252, 0.0015046950429678, 0.00150492950342596, 0.00150516792200506, 0.00150540575850755, 0.00150564615614712, 0.00150588771793991, 0.00150613416917622, 0.00150637933984399, 0.00150662905070931, 0.00150687771383673, 0.00150713138282299, 0.00150738516822457, 0.00150764244608581, 0.00150790135376155, 0.00150816107634455, 0.00150842347647995, 0.00150868645869195, 0.00150895258411765, 0.00150922231841832, 0.00150949147064239, 0.00150976167060435, 0.00151003617793322, 0.00151031208224595, 0.0015105918282643, 0.00151087041012943, 0.00151115364860743, 0.00151143700350076, 0.00151172222103924, 0.0015120095340535, 0.00151230033952743, 0.00151259219273925, 0.00151288649067283, 0.0015131802065298, 0.00151347822975367, 0.00151377764996141, 0.00151408067904413, 0.00151438277680427, 0.00151468976400793, 0.00151499698404223, 0.00151530595030636, 0.00151561666280031, 0.0015159307513386, 0.00151624507270753, 0.00151656405068934, 0.001516881166026, 0.0015172028215602, 0.00151752575766295, 0.00151785043999553, 0.0015181788476184, 0.00151850492693484, 0.00151883717626333, 0.00151917000766844, 0.0015195052837953, 0.00151984277181327, 0.00152018165681511, 0.00152052065823227, 0.0015208643162623, 0.00152120855636895, 0.00152155628893524, 0.00152190483640879, 0.00152225513011217, 0.00152260647155344, 0.00152296223677695, 0.0015233188169077, 0.00152367725968361, 0.00152403779793531, 0.0015244004316628, 0.00152476353105158, 0.0015251305885613, 0.00152549927588552, 0.00152586994227022, 0.0015262410743162, 0.00152677088044584, 0.00152710673864931, 0.00152743991930038, 0.00152776902541518, 0.00152809196151793, 0.00152841373346746, 0.00152873306069523, 0.00152904819697142, 0.00152936053927988, 0.0015296726487577, 0.00152997788973153, 0.00153027882333845, 0.00153057905845344, 0.00153087533544749, 0.00153117091394961, 0.00153145589865744, 0.00153174437582493, 0.00153202831279486, 0.00153230945579708, 0.00153258466161788, 0.00153285695705563, 0.00153312855400145, 0.00153339235112071, 0.00153365754522383, 0.00153391784988344, 0.00153417559340596, 0.00153442739974707, 0.00153468025382608, 0.00153492856770754, 0.00153517432045192, 0.00153541169129312, 0.00153565092477947, 0.00153588515240699, 0.00153611297719181, 0.00153634208254516, 0.00153656757902354, 0.00153678993228823, 0.00153700809460133, 0.00153722334653139, 0.00153743417467922, 0.00153764442075044, 0.00153784651774913, 0.00153804989531636, 0.00153824861627072, 0.00153844174928963, 0.00153863336890936, 0.00153882277663797, 0.00153901160228997, 0.00153919006697834, 0.00153937179129571, 0.00153954757843167, 0.00153971801046282, 0.00153988832607865, 0.00154005456715822, 0.00154021824710071, 0.00154037890024483, 0.00154053349979222, 0.00154068728443235, 0.00154083839152008, 0.00154098158236593, 0.00154112605378032, 0.00154126749839634, 0.00154140498489141, 0.00154153641778976, 0.0015416668029502, 0.00154179660603404, 0.00154191616456956, 0.00154203886631876, 0.00154215702787042, 0.00154227099847049, 0.00154238019604236, 0.001542599638924, 0.00154279870912433, 0.00154299777932465, 0.00154318136628717, 0.00154335319530219, 0.00154352094978094, 0.00154366355855018, 0.00154380989260972, 0.00154394656419754, 0.00154406565707177, 0.00154417881276459, 0.00154427252709866, 0.00154436810407788, 0.00154444039799273, 0.00154451269190758, 0.00154457311145961, 0.00154461804777384, 0.00154466310050339, 0.00154467858374119, 0.00154470396228135, 0.0015447020996362, 0.0015447020996362, 0.00154468836262822, 0.00154466298408806, 0.00154463178478181, 0.00154457706958055, 0.00154452642891556, 0.00154446379747242, 0.00154438195750117, 0.00154429406393319, 0.00154419452883303, 0.00154408509843051, 0.00154396228026599, 0.00154383725021034, 0.00154370057862252, 0.00154354830738157, 0.00154339021537453, 0.00154321256559342, 0.00154303107410669, 0.00154283782467246, 0.00154263479635119, 0.00154242978896946, 0.0015422033611685, 0.00154196913354099, 0.00154171930626035, 0.00154146749991924, 0.00154120393563062, 0.00154092279262841, 0.00154064758680761, 0.00154034106526524, 0.00154004048090428, 0.00153971835970879, 0.00153939239680767, 0.00153906049672514, 0.00153870519716293, 0.00153834989760071, 0.00153797515667975, 0.00153759645763785, 0.00153720600064844, 0.00153680180665106, 0.00153640180360526, 0.00153597223106772, 0.0015355427749455, 0.00153509376104921, 0.00153464684262872, 0.00153417431283742, 0.00153370585758239, 0.00153323146514595, 0.00153272587340325, 0.00153222621884197, 0.00153170304838568, 0.00153118185698986, 0.00153130572289228, 0.00153067719656974, 0.00153004855383188, 0.00152940442785621, 0.00152873294427991, 0.00152803398668766, 0.00152733514551073, 0.00152661290485412, 0.00152585154864937, 0.00152509810868651, 0.00152430555317551, 0.00152350123971701, 0.00152267748489976, 0.00152184197213501, 0.00152097526006401, 0.0015200967900455, 0.00151920272037387, 0.00151827745139599, 0.00151735218241811, 0.00151639559771866, 0.00151542737148702, 0.00151442782953382, 0.00151341280434281, 0.00151237426325679, 0.00151133572217077, 0.00151026202365756, 0.00150916504207999, 0.00150806794408709, 0.00150693964678794, 0.00150579959154129, 0.00150462833698839, 0.0015034336829558, 0.00150222727097571, 0.00150102097541094, 0.00149977148976177, 0.00149851047899574, 0.00149723386857659, 0.0014959336258471, 0.00149462977424264, 0.00149329053238034, 0.00149192789103836, 0.00149056152440608, 0.00148916768375784, 0.00148774264380336, 0.00148631364572793, 0.00148487300612032, 0.0014833933673799, 0.00148192537017167, 0.00148040277417749, 0.00147887622006238, 0.00147733406629413, 0.00147577235475183, 0.00147417560219765, 0.00147257093340158, 0.0014709624228999, 0.00146931491326541, 0.00146766332909465, 0.00146597682032734, 0.00146427832078189, 0.00146257621236145, 0.00146082323044538, 0.00145907420665026, 0.00145730166696012, 0.00145550176966935, 0.00145369023084641, 0.00145187089219689, 0.00145001243799925, 0.00144813838414848, 0.00144626048859209, 0.00144434743560851, 0.00144241494126618, 0.00143999373540282, 0.00143783073872328, 0.00143562874291092, 0.00143343466334045, 0.00143122090958059, 0.00142896827310324, 0.00142671156208962, 0.00142443156801164, 0.00142212025821209, 0.00141979730688035, 0.00141744699794799, 0.00141507724765688, 0.00141269946470857, 0.00141028279904276, 0.00140785437542945, 0.00140541815198958, 0.00140293897129595, 0.00140043639112264, 0.00139794556889683, 0.001395407714881, 0.00139284273609519, 0.00139028951525688, 0.00138768926262856, 0.00138506561052054, 0.00138244987465441, 0.00137978722341359, 0.00137709721457213, 0.00137441116385162, 0.00137169379740953, 0.00136894918978214, 0.00136620446573943, 0.00136341294273734, 0.00136062153615057, 0.00135780649725348, 0.00135496049188077, 0.00135208305437118, 0.00134921725839376, 0.0013463047798723, 0.00134339230135083, 0.00134045246522874, 0.00133747351355851, 0.00133448292035609, 0.00133149232715368, 0.00132846261840314, 0.00132540182676166, 0.00132234091870487, 0.00131925661116838, 0.00131615658756346, 0.00131301768124104, 0.00130986305885017, 0.00130669283680618, 0.00130350713152438, 0.0013002899941057, 0.00129704957362264, 0.00129380135331303, 0.00129052170086652, 0.00128724228125066, 0.00128391594626009, 0.00128058169502765, 0.00127722416073084, 0.00127384311053902, 0.00127043866086751, 0.00126701861154288, 0.00126359076239169, 0.00126013159751892, 0.00125664903316647, 0.00125315086916089, 0.00124962930567563, 0.00124608434271067, 0.00124251586385071, 0.00123892398551106, 0.00123531650751829, 0.00123102776706219, 0.00122722110245377, 0.00122340291272849, 0.00121958262752742, 0.00121573510114104, 0.001211873954162, 0.0012080145534128, 0.00120413571130484, 0.00120024126954377, 0.00119633518625051, 0.00119243492372334, 0.00118849950376898, 0.00118456210475415, 0.00118061492685229, 0.00117664830759168, 0.00117267179302871, 0.00116868573240936, 0.00116469757631421, 0.00116068019997329, 0.00115666480269283, 0.0011526218149811, 0.00114858115557581, 0.00114452466368675, 0.0011404505930841, 0.00113637850154191, 0.00113228312693536, 0.00112817785702646, 0.00112406082917005, 0.00111993413884193, 0.00111578009091318, 0.00111162208486348, 0.00110746605787426, 0.00110329047311097, 0.00109910138417035, 0.00109489646274596, 0.00109068979509175, 0.00108646345324814, 0.00108222546987236, 0.00107797770760953, 0.00107371236663312, 0.00106943922583014, 0.00106515048537403, 0.0010608637239784, 0.00105655728839338, 0.00105223152786493, 0.00104790378827602, 0.0010435584699735, 0.00103919359389693, 0.00103482673875988, 0.00103045010473579, 0.00102605391293764, 0.00102164805866778, 0.00101724034175277, 0.00101280515082181, 0.00100836995989084, 0.00100390752777457, 0.000999446958303452, 0.000994972651824355, 0.000990479020401835, 0.000985981430858374, 0.000981472083367407, 0.000976948998868465, 0.000972404552157968, 0.00096785620553419, 0.000963300000876188, 0.000958726217504591, 0.000954140850808471, 0.000949545472394675, 0.000944938568864018, 0.000940321828238666, 0.000935693562496454, 0.000931329559534788, 0.000926654262002558, 0.000921986880712211, 0.000917323224712163, 0.000912663526833057, 0.000908004003576934, 0.000903340405784547, 0.000898686586879194, 0.00089403276797384, 0.0008893848862499, 0.000884736946318299, 0.000880085048265755, 0.000875441008247435, 0.000870800868142396, 0.000866166548803449, 0.00086152832955122, 0.000856888189446181, 0.000852255849167705, 0.000847627408802509, 0.000843001005705446, 0.000838378386106342, 0.000833750003948808, 0.000829129363410175, 0.000824512622784823, 0.000819895882159472, 0.000815285078715533, 0.000810670200735331, 0.000806061376351863, 0.000801454356405884, 0.000796851352788508, 0.000792252190876752, 0.000787643366493285, 0.00078305194620043, 0.000778458663262427, 0.000773863459471613, 0.00076927593909204, 0.000764682656154037, 0.000760099152103066, 0.000755513610783964, 0.000750935985706747, 0.000746358302421868, 0.000741778698284179, 0.000737206893973053, 0.000732631131540984, 0.00072806520620361, 0.000723491422832012, 0.000718925439286977, 0.000714371155481786, 0.000709811109118164, 0.000705254904460162, 0.00070069869980216, 0.000696138595230877, 0.000691594090312719, 0.00068704376462847, 0.000682499317917973, 0.000677956675644964, 0.000673408329021186, 0.000668871682137251, 0.000664336897898465, 0.000659804092720151, 0.000655269424896687, 0.000650734640657902, 0.000646209693513811, 0.00064168474636972, 0.00063716561999172, 0.000632644514553249, 0.000628119567409158, 0.000623608299065381, 0.000619094993453473, 0.000614583725109696, 0.000610078277532011, 0.000605957407969981, 0.000601596431806684, 0.00059724721359089, 0.000592917436733842, 0.000588591617997736, 0.000584289198741317, 0.000579998479224741, 0.000575723359361291, 0.000571452255826443, 0.000567192735616118, 0.00056295667309314, 0.000558732368517667, 0.000554535363335162, 0.000550330500118434, 0.000546141352970153, 0.000541975605301559, 0.000537817657459527, 0.000533667509444058, 0.000529552460648119, 0.000525417912285775, 0.000521306821610779, 0.00051722297212109, 0.000513147038873285, 0.000509098405018449, 0.00050504581304267, 0.000500993337482214, 0.000496979802846909, 0.000492974068038166, 0.000488984049297869, 0.000485005672089756, 0.000481027265777811, 0.000477080175187439, 0.000473140855319798, 0.000469217135105282, 0.000465301214717329, 0.000461393094155937, 0.00045752408914268, 0.000453643297078088, 0.000449797662440687, 0.000445944227976725, 0.000442094751633704, 0.000438295945059508, 0.000434477638918906, 0.000430690590292215, 0.000426915241405368, 0.000423143792431802, 0.000419395772041753, 0.000415663351304829, 0.000411938759498298, 0.000408241496188566, 0.00040453253313899, 0.000400850840378553, 0.000397192663513124, 0.000393530499422923, 0.000389895722037181, 0.000386260915547609, 0.000382653437554836, 0.000379049888579175, 0.000375461939256638, 0.00037190128932707, 0.000368328968761489, 0.000364776147762313, 0.00036125848419033, 0.00035772129194811, 0.000354223127942532, 0.000350732792867348, 0.000347242457792163, 0.000343795021763071, 0.000340339873218909, 0.000336888537276536, 0.000333476287778467, 0.000330060109263286, 0.00032687428756617, 0.000323633837979287, 0.000320393330184743, 0.000317199708661065, 0.000313998258206993, 0.00031082026544027, 0.000307673501083627, 0.000304526736726984, 0.000301418971503153, 0.000298303435556591, 0.00029522692784667, 0.00029215044924058, 0.000289089541183785, 0.0002860598906409, 0.00028304586885497, 0.000280039646895602, 0.00027704905369319, 0.000274081859970465, 0.000271138065727428, 0.000268202129518613, 0.000265273993136361, 0.000262400513747707, 0.000259495805948973, 0.000256630126386881, 0.0002537957043387, 0.00025096905301325, 0.000248158030444756, 0.000245362636633217, 0.000242575042648241, 0.000239826491451822, 0.000237077954807319, 0.00023434501781594, 0.000231643309234641, 0.000228941629757173, 0.000226278963964432, 0.000223608512897044, 0.000220969261135906, 0.000218337867408991, 0.000215729858609848, 0.000213145278394222, 0.000210568512557074, 0.000208022989681922, 0.000205469652428292, 0.000202947543584742, 0.000200456663151272, 0.000197965797269717, 0.00019548274576664, 0.00019305432215333, 0.000190602484508418, 0.000188189704203978, 0.000185784723726101, 0.000183395357453264, 0.000181029419763945, 0.000178686910658143, 0.000176352201378904, 0.00017403312085662, 0.000171745254192501, 0.000169457402080297, 0.000167200792930089, 0.00016494415467605, 0.000162718773935921, 0.000160501207574271, 0.000158314855070785, 0.000156128502567299, 0.000153965593199246, 0.000151833883137442, 0.000149702202179469, 0.000147593949805014, 0.000145493497257121, 0.00014341645874083, 0.00014137067773845, 0.000138923191116191, 0.000136963280965574, 0.000135022884933278, 0.000133098117657937, 0.000131173350382596, 0.000129283711430617, 0.000127397986943834, 0.000125547405332327, 0.000123677280498669, 0.000121854012832046, 0.000120022952614818, 0.000118227027996909, 0.000116431081551127, 0.000114666378067341, 0.000112889967567753, 0.000111160406959243, 0.000109415239421651, 0.00010771300730994, 0.000106002968095709, 0.000104320257378276, 0.000102637546660844, 0.000100982157164253, 9.934238914866e-05, 9.77065355982631e-05, 9.61019104579464e-05, 9.45089923334308e-05, 9.29238885873929e-05, 9.13544063223526e-05, 8.98044308996759e-05, 8.82661770447157e-05, 8.67396374815144e-05, 8.52326120366342e-05, 8.37451152619906e-05, 8.22576184873469e-05, 8.08013501227833e-05, 7.9356788774021e-05, 7.7916141890455e-05, 7.65067234169692e-05, 7.51012121327221e-05, 7.37191221560352e-05, 7.23331395420246e-05, 7.09666637703776e-05, 6.96353308740072e-05, 6.82961908751167e-05, 6.69960863888264e-05, 6.56881820759736e-05, 6.44115134491585e-05, 6.31270304438658e-05, 6.18893973296508e-05, 6.06361500103958e-05, 5.94297489442397e-05, 5.82116372243036e-05, 5.70247611904051e-05, 5.58339779672679e-05, 5.46783412573859e-05, 5.35187900823075e-05, 5.23982816957869e-05, 5.12660626554862e-05, 5.01611721119843e-05, 4.90758066007402e-05, 4.7994344640756e-05, 4.69284968858119e-05, 4.58899776276667e-05, 4.48631726612803e-05, 4.38441747974139e-05, 4.28407947765663e-05, 4.18608433392365e-05, 4.08847954531666e-05, 3.99282653233968e-05, 3.89912565879058e-05, 3.80620549549349e-05, 3.71601854567416e-05, 3.63715371349826e-05, 3.55145675712265e-05, 3.46595443261322e-05, 3.38162390107755e-05, 3.29787872033194e-05, 3.21647603414021e-05, 3.13448799715843e-05, 3.05484209093265e-05, 2.97519618470687e-05, 2.8975029636058e-05, 2.81941884168191e-05, 2.74348221864784e-05, 2.66813076450489e-05, 2.59395128523465e-05, 2.52074732998153e-05, 2.44910552282818e-05, 2.37746335187694e-05, 2.30738296522759e-05, 2.23749775614124e-05, 2.17015040107071e-05, 2.10202197195031e-05, 2.03643121494679e-05, 1.97084063984221e-05, 1.90720220416551e-05, 1.84317341336282e-05, 1.78129157575313e-05, 1.72077670868021e-05, 1.6602614778094e-05, 1.60150339070242e-05, 1.5431354768225e-05, 1.48632934724446e-05, 1.42913277159096e-05, 1.37447395900381e-05, 1.32020559249213e-05, 1.26710847325739e-05, 1.21479215522413e-05, 1.16403753054328e-05, 1.1134781743749e-05, 1.064089974534e-05, 1.01606829048251e-05, 9.69608390732901e-06, 9.22562776395353e-06, 8.78054743225221e-06, 8.339373380295e-06, 7.90600734035252e-06, 7.4784970820474e-06, 7.07245999365114e-06, 6.66837513563223e-06, 6.28185989626218e-06, 5.90120043852949e-06, 5.53420477444888e-06, 5.16721047461033e-06, 4.81583219880122e-06, 4.47421462013153e-06, 4.14430951423128e-06, 3.81830886908574e-06, 3.51573316947906e-06, 3.20925323649135e-06, 2.92034246740513e-06, 2.641191940711e-06, 2.36789787777525e-06, 2.11022074836364e-06, 1.8564476249594e-06, 1.6221955547735e-06, 1.38794348458759e-06, 1.1732123539332e-06, 9.54577217271435e-07, 7.57415023144858e-07, 5.58300769171183e-07, 3.86515921491082e-07, 2.10826868851655e-07, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 3.12336077001873e-08, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.17126752741115e-08, 1.09317610963444e-07, 2.22539469518779e-07, 3.24048755828699e-07, 4.56791440228699e-07, 5.79773768549785e-07, 7.41798260150972e-07, 8.96014114459831e-07, 1.05803849237418e-06, 1.24153586966713e-06, 1.43088959703164e-06, 1.63586037160712e-06, 1.83887868843158e-06, 2.06337040253857e-06, 2.28981389227556e-06, 2.53187454291037e-06, 2.78564766631462e-06, 3.04137256534887e-06, 3.31661908603564e-06, 3.60748185812554e-06, 3.89639262721175e-06, 4.20482456320315e-06, 4.50740026280982e-06, 4.84120937471744e-06, 5.18282695338712e-06, 5.53810923520359e-06, 5.88558305025799e-06, 6.26038672635332e-06, 6.62738102619187e-06, 7.02365787219605e-06, 7.43164673622232e-06, 7.83573159424122e-06, 8.25543338578427e-06, 8.69660834723618e-06, 9.13778330868809e-06, 9.59066983341472e-06, 1.00591732916655e-05, 1.05179178717663e-05, 1.10157034214353e-05, 1.15134889711044e-05, 1.20112745207734e-05, 1.25305332403514e-05, 1.30654088934534e-05, 1.35885729832808e-05, 1.41429682116723e-05, 1.46954116644338e-05, 1.52654265548335e-05, 1.58510574692627e-05, 1.64347347890725e-05, 1.70398852787912e-05, 1.76606536115287e-05, 1.82775165740168e-05, 1.89099973795237e-05, 1.95561424334301e-05, 2.02022893063258e-05, 2.08679557545111e-05, 2.15492382267257e-05, 2.2224663553061e-05, 2.29235174629139e-05, 2.36418891290668e-05, 2.43446465901798e-05, 2.56192834058311e-05, 2.65094404312549e-05, 2.740740092122e-05, 2.83209828921827e-05, 2.92736040137243e-05, 3.02106109302258e-05, 3.11944640998263e-05, 3.2170515623875e-05, 3.31934134010226e-05, 3.42241182806902e-05, 3.52626339008566e-05, 3.63167600880843e-05, 3.74177434423473e-05, 3.85031089535914e-05, 3.96197065128945e-05, 4.07753468607552e-05, 4.19075659010559e-05, 4.30866275564767e-05, 4.42891177954152e-05, 4.54759901913349e-05, 4.6717523218831e-05, 4.79746704513673e-05, 4.92162071168423e-05, 5.04967792949174e-05, 5.17929693160113e-05, 5.31282021256629e-05, 5.44478170922957e-05, 5.58064748474862e-05, 5.71885575482156e-05, 5.85784509894438e-05, 5.99761442572344e-05, 6.14128875895403e-05, 6.28574416623451e-05, 6.43097955617122e-05, 6.58011995255947e-05, 6.73160247970372e-05, 6.88152358634397e-05, 7.03534824424423e-05, 7.19229719834402e-05, 7.34690183890052e-05, 7.50697436160408e-05, 7.66782686696388e-05, 7.82946008257568e-05, 7.99499757704325e-05, 8.16209649201483e-05, 8.32841542433016e-05, 8.49941934575327e-05, 8.67120324983262e-05, 8.84454930201173e-05, 9.02023748494685e-05, 9.19826852623373e-05, 9.37629956752062e-05, 9.55823416006751e-05, 9.73938876995817e-05, 9.92600980680436e-05, 0.00010111848678207, 0.000102992489701137, 0.000104905549960677, 0.000106826417322736, 0.000108747277408838, 0.00011070717300754, 0.000112690511741675, 0.000114666028821375, 0.000116680581413675, 0.000118702948384453, 0.000120748743938748, 0.000122817960800603, 0.000124910628073849, 0.000126987652038224, 0.000129111518617719, 0.000131243199575692, 0.000134226007503457, 0.000136513859615661, 0.000138840754516423, 0.000141152035212144, 0.000143486744491383, 0.000145844867802225, 0.00014824204845354, 0.000150623600347899, 0.000153044195030816, 0.000155488218297251, 0.000157924427185208, 0.0001604074932402, 0.00016291398787871, 0.000165420467965305, 0.000167950391187333, 0.000170503742992878, 0.000173080494278111, 0.000175649445736781, 0.000178265254362486, 0.00018090449157171, 0.000183520300197415, 0.000186206380021758, 0.000188884660019539, 0.000191578539670445, 0.000194295862456784, 0.000197044399101287, 0.000199785121367313, 0.000202572729904205, 0.000205375952646136, 0.00020818697521463, 0.000211005797609687, 0.000213871448067948, 0.000216752756386995, 0.000219634035602212, 0.000222554386709817, 0.000225474694161676, 0.000228418459300883, 0.00023137783864513, 0.000234376260777935, 0.000237366853980348, 0.000240396519075148, 0.000243426155066118, 0.000246510491706431, 0.000249563541729003, 0.000252671277849004, 0.000255794613622129, 0.000258925807429478, 0.000262080371612683, 0.000265258393483236, 0.000268444215180352, 0.000271653465460986, 0.000274901743978262, 0.000278142222668976, 0.000281413929769769, 0.000284709065454081, 0.000288019800791517, 0.000291322736302391, 0.000294680357910693, 0.000298045779345557, 0.000301434600260109, 0.000304815650451928, 0.000308251299429685, 0.000311694806441665, 0.000315146142384037, 0.000318636477459222, 0.000322111212881282, 0.000325617147609591, 0.000329169968608767, 0.000332730560330674, 0.000336283381329849, 0.000339890859322622, 0.000343490508385003, 0.000346306536812335, 0.000350058486219496, 0.000353841664036736, 0.000357632641680539, 0.000361447047907859, 0.000365257554221898, 0.000369083660189062, 0.0003729214949999, 0.000376790529116988, 0.000380667421268299, 0.000384540384402499, 0.000388440676033497, 0.000392340938560665, 0.000396264658775181, 0.000400196207920089, 0.000404147285735235, 0.000408102263463661, 0.000412088411394507, 0.000416058959672228, 0.000420072552515194, 0.000424074300099164, 0.000428115192335099, 0.000432132568676025, 0.000436192960478365, 0.000440249452367425, 0.000444333243649453, 0.000448432634584606, 0.000452524225693196, 0.000456647103419527, 0.000460773793747649, 0.000464920100057498, 0.000469078047899529, 0.000473247695481405, 0.000477429159218445, 0.000481622235383838, 0.000485823198687285, 0.000490047503262758, 0.000494267966132611, 0.00049853918608278, 0.000502798648085445, 0.000507062010001391, 0.000511341029778123, 0.000515647348947823, 0.000519953726325184, 0.000524283503182232, 0.000528636621311307, 0.00053298199782148, 0.000537339074071497, 0.00054171570809558, 0.000546104041859508, 0.000550504075363278, 0.000554923608433455, 0.000559350941330194, 0.000563805690035224, 0.000568244780879468, 0.000572730670683086, 0.00057720101904124, 0.000581702566705644, 0.00058621185598895, 0.000590725161600858, 0.000595277466345578, 0.00059980241348967, 0.000604378175921738, 0.00060893438057974, 0.000613525626249611, 0.000618120946455747, 0.000622739607933909, 0.000627358269412071, 0.000632008130196482, 0.000636650249361992, 0.000641323567833751, 0.000645284249912947, 0.000650035741273314, 0.000654787116218358, 0.00065953069133684, 0.000664285966195166, 0.00066903349943459, 0.000673792674206197, 0.000678547949064523, 0.00068330328213051, 0.000688066415023059, 0.000692829489707947, 0.000697596522513777, 0.000702351855579764, 0.000707130529917777, 0.000711889762897044, 0.000716660695616156, 0.000721435470040888, 0.00072620646096766, 0.000730985135305673, 0.000735763867851347, 0.000740542600397021, 0.000745325232855976, 0.000750107865314931, 0.000754898297600448, 0.000759684888180345, 0.000764463562518358, 0.000769254053011537, 0.000774048327002674, 0.000778838817495853, 0.000783640949521214, 0.000788435339927673, 0.000793241313658655, 0.000798035704065114, 0.000802841736003757, 0.000807643926236778, 0.000812450016383082, 0.000817263789940625, 0.000822065921965986, 0.000826887611765414, 0.000831693701911718, 0.000836507591884583, 0.000841325323563069, 0.000846147013362497, 0.000850968644954264, 0.000855790334753692, 0.000860615982674062, 0.000865445355884731, 0.000870266987476498, 0.000875096477102488, 0.000879929924849421, 0.000884767214301974, 0.000889596762135625, 0.000894430151674896, 0.00089927134104073, 0.000904112472198904, 0.000908953719772398, 0.000913802650757134, 0.000918643840122968, 0.000923500687349588, 0.000928345776628703, 0.000933198723942041, 0.000938039971515536, 0.000942908402066678, 0.000947761291172355, 0.000952614238485694, 0.000957474869210273, 0.000962339516263455, 0.000967200321611017, 0.000972064852248877, 0.000976937240920961, 0.000981809687800705, 0.00098667829297483, 0.000992163666523993, 0.000996981398202479, 0.00100181484594941, 0.00100662081968039, 0.0010114269098267, 0.00101620960049331, 0.00102098437491804, 0.00102575134951621, 0.00103051064070314, 0.001035250374116, 0.00103998999111354, 0.0010447179665789, 0.00104943418409675, 0.00105414667632431, 0.00105883157812059, 0.00106352439615875, 0.0010682016145438, 0.00107286323327571, 0.00107750145252794, 0.00108213955536485, 0.00108677765820175, 0.0010913924779743, 0.0010960033396259, 0.00110059860162437, 0.00110519782174379, 0.00110977736767381, 0.00111434527207166, 0.00111890153493732, 0.00112345372326672, 0.00112798262853175, 0.00113249977584928, 0.00113700912334025, 0.00114152231253684, 0.00114601210225374, 0.00115050980821252, 0.00115497224032879, 0.00115943094715476, 0.00116388546302915, 0.00116832449566573, 0.00117275968659669, 0.00117717927787453, 0.00118157546967268, 0.00118598318658769, 0.00119036377873272, 0.00119474809616804, 0.00119911693036556, 0.00120347400661558, 0.00120781932491809, 0.00121215695980936, 0.00121647492051125, 0.00122079299762845, 0.00122507195919752, 0.00122936652041972, 0.00123366119805723, 0.00123793235979974, 0.00124219583813101, 0.00124644348397851, 0.00125069124624133, 0.00125492340885103, 0.0012591399718076, 0.00126334477681667, 0.00126754946541041, 0.00127172691281885, 0.00127590447664261, 0.00128005852457136, 0.00128422828856856, 0.00128836662042886, 0.00129250506870449, 0.00129662407562137, 0.00130073516629636, 0.00130484229885042, 0.0013099453644827, 0.00131394329946488, 0.00131791771855205, 0.00132185313850641, 0.00132576515898108, 0.00132966937962919, 0.0013335500843823, 0.00133742322213948, 0.00134128821082413, 0.00134509091731161, 0.00134890142362565, 0.00135271204635501, 0.00135648343712091, 0.00136020022910088, 0.00136394833680242, 0.00136763392947614, 0.00137131940573454, 0.00137498159892857, 0.00137863587588072, 0.0013822668697685, 0.00138587423134595, 0.0013894661096856, 0.00139304238837212, 0.00139657955151051, 0.00140007771551609, 0.00140363059472293, 0.00140708964318037, 0.00141056440770626, 0.00141402357257903, 0.00141746702138335, 0.00142086367122829, 0.00142426032107323, 0.00142764137126505, 0.00143099122215062, 0.00143430195748806, 0.00143764400854707, 0.00144092354457825, 0.00144417176488787, 0.00144745130091906, 0.00145069183781743, 0.00145388545934111, 0.00145708688069135, 0.00146027281880379, 0.00146342732477933, 0.00146655854769051, 0.00146968185435981, 0.00147278176154941, 0.00147585046943277, 0.001478903577663, 0.00148194096982479, 0.0014849784784019, 0.00148795358836651, 0.00149092078208923, 0.00149391905870289, 0.00149683945346624, 0.00149978313129395, 0.00150267232675105, 0.00150556152220815, 0.00150843488518149, 0.00151126936543733, 0.00151407264638692, 0.00151689141057432, 0.00151966349221766, 0.00152242765761912, 0.00152516050729901, 0.00152790127322078, 0.00153061863966286, 0.00153327349107713, 0.00153595174197108, 0.00153858319390565, 0.00154120672959834, 0.0015440023271367, 0.00154654774814844, 0.00154899957124144, 0.00155143579468131, 0.00155388761777431, 0.00155627704225481, 0.00155865075066686, 0.00156102445907891, 0.00156333576887846, 0.00156564719509333, 0.00156789598986506, 0.00157020729966462, 0.0015724248951301, 0.00157461105845869, 0.00157679745461792, 0.0015789681347087, 0.00158112333156168, 0.00158324732910842, 0.00158534001093358, 0.0015873855445534, 0.00158943142741919, 0.00159144611097872, 0.00159346079453826, 0.00159544392954558, 0.00159734929911792, 0.00159930123481899, 0.00160119100473821, 0.00160308065824211, 0.0016049233963713, 0.00160678161773831, 0.00160857778973877, 0.00161035801284015, 0.00161212275270373, 0.00161387189291418, 0.00161557400133461, 0.00161727634258568, 0.00161890056915581, 0.00162054027896374, 0.0016221955884248, 0.00162375718355179, 0.0016253188950941, 0.00162686489056796, 0.0016283952863887, 0.00162991008255631, 0.00163136248011142, 0.00163283047731966, 0.0016342360759154, 0.00163561035878956, 0.00163706275634468, 0.00163840595632792, 0.00163967057596892, 0.00164099817629904, 0.00164227886125445, 0.00164354383014143, 0.0016447773668915, 0.00164601125288755, 0.00164718250744045, 0.0016483380459249, 0.0016495093004778, 0.0016506181564182, 0.00165168009698391, 0.00165275763720274, 0.00165381969418377, 0.0016548348357901, 0.00165581854525954, 0.00165680225472897, 0.001657739514485, 0.00165866082534194, 0.00165955093689263, 0.00166045664809644, 0.00166131556034088, 0.00166212779004127, 0.00166287738829851, 0.00166362698655576, 0.00166437635198236, 0.00166507915128022, 0.00166576635092497, 0.00166642223484814, 0.00166701583657414, 0.00166764052119106, 0.00166821840684861, 0.00166874914430082, 0.00166928023099899, 0.00166981131769717, 0.00167027954012156, 0.00167074822820723, 0.00167113856878132, 0.00167156022507697, 0.00167191948276013, 0.00167227862402797, 0.00167262216564268, 0.00167293462436646, 0.00167321553453803, 0.00167349691037089, 0.00167374662123621, 0.00167393393348902, 0.00167409004643559, 0.00167426210828125, 0.00167438702192158, 0.00167449621949345, 0.00167457433417439, 0.00167465233244002, 0.00167469913139939, 0.00167468353174627, 0.00167466793209314, 0.00167465233244002, 0.00167457433417439, 0.00167451181914657, 0.00167437130585313, 0.00167424650862813, 0.00167407456319779, 0.0016738559352234, 0.00167368422262371, 0.00167343427892774, 0.00167318433523178, 0.00167290342506021, 0.00167262216564268, 0.00167227862402797, 0.00167190388310701, 0.00167146662715822, 0.00167107617016882, 0.00167065451387316, 0.00167021714150906, 0.0016697176033631, 0.00166923343203962, 0.00166870234534144, 0.00166812457609922, 0.00166753120720387, 0.00166695332154632, 0.00166629743762314, 0.00166565703693777, 0.00166496983729303, 0.00166426715441048, 0.00166351755615324, 0.00166275224182755, 0.00166198704391718, 0.00166120624635369, 0.00166037864983082, 0.00165951973758638, 0.00165861402638257, 0.00165770819876343, 0.00165678665507585, 0.00165583414491266, 0.00165582890622318, 0.00165481376461685, 0.00165373622439802, 0.00165267440024763, 0.00165154982823879, 0.00165041000582278, 0.0016492698341608, 0.00164809869602323, 0.00164689612574875, 0.0016456936718896, 0.00164442881941795, 0.00164317933376878, 0.00164185196626931, 0.0016405088827014, 0.00163918151520193, 0.00163782283198088, 0.00163646403234452, 0.00163502735085785, 0.00163359055295587, 0.00163212267216295, 0.00163063907530159, 0.00162910867948085, 0.00162759388331324, 0.00162604765500873, 0.00162448594346642, 0.00162286194972694, 0.00162123783957213, 0.00161956669762731, 0.00161789578851312, 0.00161617784760892, 0.00161446013953537, 0.00161271099932492, 0.00161099305842072, 0.00160918175242841, 0.00160733889788389, 0.00160551175940782, 0.00160363770555705, 0.00160174805205315, 0.00159982719924301, 0.00159790646284819, 0.00159596977755427, 0.00159395532682538, 0.00159192516002804, 0.00158992607612163, 0.00158784922678024, 0.00158578786067665, 0.00158367946278304, 0.00158155558165163, 0.00157941598445177, 0.00157721398863941, 0.00157499662600458, 0.00157279463019222, 0.00157054583542049, 0.00156829704064876, 0.00156600133050233, 0.00156367453746498, 0.00156133179552853, 0.00155895808711648, 0.00155658449511975, 0.001554163871333, 0.00155171204824001, 0.00154927570838481, 0.00154679280240089, 0.00154426274821162, 0.00154174852650613, 0.00153917178977281, 0.00153662625234574, 0.00153401819989085, 0.00153136346489191, 0.0015287398127839, 0.00152606936171651, 0.00152335199527442, 0.00151872460264713, 0.00151585903950036, 0.00151302444282919, 0.00151012756396085, 0.00150721508543938, 0.0015043260063976, 0.00150139001198113, 0.00149843853432685, 0.001495455740951, 0.00149245734792203, 0.00148944335523993, 0.00148639804683626, 0.00148334493860602, 0.00148030754644424, 0.00147719192318618, 0.00147409981582314, 0.00147096090950072, 0.00146779860369861, 0.00146465946454555, 0.00146145815961063, 0.00145824113860726, 0.00145503971725702, 0.00145178358070552, 0.00144855096004903, 0.00144524802453816, 0.00144195277243853, 0.00143864995334297, 0.00143530021887273, 0.00143195816781372, 0.00142856931779534, 0.00142518826760352, 0.00142176821827888, 0.00141832476947457, 0.00141485792119056, 0.0014114222722128, 0.00140790059231222, 0.00140443374402821, 0.00140089658088982, 0.0013973203022033, 0.00139379093889147, 0.00139017566107213, 0.0013865603832528, 0.00138296082150191, 0.00137929082848132, 0.00137567555066198, 0.00137196655850857, 0.00136827328242362, 0.00136457988992333, 0.00136081629898399, 0.0013570839073509, 0.00135328120086342, 0.00134947849437594, 0.00134569930378348, 0.00134185759816319, 0.00133799249306321, 0.00133415090385824, 0.00133023876696825, 0.00132634246256202, 0.00132240704260767, 0.00131842470727861, 0.0013145050033927, 0.00131049926858395, 0.00130649353377521, 0.00130248791538179, 0.00129842746537179, 0.00129439053125679, 0.00129028339870274, 0.00128616846632212, 0.00128209253307432, 0.00127794628497213, 0.00127379223704338, 0.00126704480499029, 0.00126275990623981, 0.00125844439025968, 0.00125413469504565, 0.00124981219414622, 0.00124549330212176, 0.00124113564379513, 0.00123679370153695, 0.00123244209680706, 0.00122806697618216, 0.0012237059418112, 0.00121932209003717, 0.00121494405902922, 0.0012105347122997, 0.00120612548198551, 0.0012017214903608, 0.00119728688150644, 0.00119286589324474, 0.00118842348456383, 0.00118398584891111, 0.00117951561696827, 0.00117505458183587, 0.00117059168405831, 0.00116609747055918, 0.00116161641199142, 0.00115712219849229, 0.00115261727478355, 0.00114809582009912, 0.00114357529673725, 0.00113905279431492, 0.00113449746277183, 0.00112996622920036, 0.00112540472764522, 0.00112084799911827, 0.00111626740545034, 0.00111168634612113, 0.00110709655564278, 0.00110249884892255, 0.00109789939597249, 0.00109328504186124, 0.00108866835944355, 0.00108402769546956, 0.00107938807923347, 0.00107474648393691, 0.0010700800921768, 0.00106542196590453, 0.00106074719224125, 0.00105607917066664, 0.00105138006620109, 0.00104668771382421, 0.00104197824839503, 0.00103726063389331, 0.00103254185523838, 0.00102780864108354, 0.00102308066561818, 0.00101832870859653, 0.00101356999948621, 0.00100880837999284, 0.00100403127726167, 0.000999253359623253, 0.000994460540823638, 0.000989673542790115, 0.000984854414127767, 0.000980036100372672, 0.00097523006843403, 0.000970393186435103, 0.000965555489528924, 0.000960703124292195, 0.000955856521613896, 0.000950977322645485, 0.000946106389164925, 0.000941234407946467, 0.000939639110583812, 0.000934757001232356, 0.000929906498640776, 0.000925047264900059, 0.000920194725040346, 0.000915350159630179, 0.000910512404516339, 0.000905680004507303, 0.000900855753570795, 0.000896032666787505, 0.000891214294824749, 0.000886403955519199, 0.00088159303413704, 0.000876797130331397, 0.000871999422088265, 0.000867194787133485, 0.000862421409692615, 0.000857621140312403, 0.000852852710522711, 0.000848084106110036, 0.000843313697259873, 0.000838551088236272, 0.000833802623674273, 0.000829039083328098, 0.000824296905193478, 0.00081956252688542, 0.000814828148577362, 0.000810091441962868, 0.000805370742455125, 0.000800641311798245, 0.000795935280621052, 0.000791211670730263, 0.000786511052865535, 0.000781810958869755, 0.000777116511017084, 0.000772429106291384, 0.000767742574680597, 0.000763061456382275, 0.000758387614041567, 0.000753721629735082, 0.000749063387047499, 0.000744403223507106, 0.000739750452339649, 0.000735105888452381, 0.000730459403712302, 0.000725804129615426, 0.00072117178933695, 0.000716546783223748, 0.000711920787580311, 0.000707310391589999, 0.000702699064277112, 0.000698094547260553, 0.00069348857505247, 0.000688889878802001, 0.000684300030115992, 0.000679708260577172, 0.000675130519084632, 0.0006705621490255, 0.000665991799905896, 0.000661404861602932, 0.000656848133075982, 0.000652292394079268, 0.000647733337245882, 0.000643190229311585, 0.000638656027149409, 0.000634127645753324, 0.000629590009339154, 0.00062506744870916, 0.000620544946286827, 0.000616030243691057, 0.000611521361861378, 0.000605053501203656, 0.000600711908191442, 0.000596347032114863, 0.000592021155171096, 0.000587718735914677, 0.000583408458624035, 0.000579129380639642, 0.000574865960516036, 0.000570625998079777, 0.00056636257795617, 0.000562153814826161, 0.000557945051696151, 0.000553736288566142, 0.000549558782950044, 0.000545412476640195, 0.000541242829058319, 0.000537088664714247, 0.000532965816091746, 0.000528858625330031, 0.00052476697601378, 0.00052068306831643, 0.00051662273472175, 0.000512577942572534, 0.000508541008457541, 0.000504519673995674, 0.000500498281326145, 0.000496523804031312, 0.000492525869049132, 0.000488574733026326, 0.000484615913592279, 0.000480664835777134, 0.000476744957268238, 0.000472832936793566, 0.000468959944555536, 0.000465063552837819, 0.000461198360426351, 0.000457356596598402, 0.000453514803666621, 0.00044969649752602, 0.000445901590865105, 0.000442098884377629, 0.000438327406300232, 0.000434563757153228, 0.000430807849625126, 0.000427067629061639, 0.000423343008151278, 0.000419649615650997, 0.000415948423324153, 0.000412278430303559, 0.000408608437282965, 0.000404954073019326, 0.00040133876609616, 0.000397707859519869, 0.000394108123145998, 0.000390508474083617, 0.000386939995223656, 0.00038338711601682, 0.000379842094844207, 0.000376281444914639, 0.000372767623048276, 0.000369269459042698, 0.000365779094863683, 0.000362312130164355, 0.000358860794221982, 0.000355401658453047, 0.000351981550920755, 0.0003485536435619, 0.000345156964613125, 0.000341768085490912, 0.000338387035299093, 0.000335045013343915, 0.000330435927025974, 0.000327203248161823, 0.000324009597534314, 0.00032083157566376, 0.000317669211653993, 0.000314514589263126, 0.000311367824906483, 0.000308260059682652, 0.000305144494632259, 0.000302075786748901, 0.000299007107969373, 0.000295969628496096, 0.000292916549369693, 0.000289918127236888, 0.000286927504930645, 0.000283936882624403, 0.000280961889075115, 0.000278018123935908, 0.000275097787380219, 0.000272169621894136, 0.000269288313575089, 0.000266391405602917, 0.000263533554971218, 0.000260683475062251, 0.000257841224083677, 0.000255069229751825, 0.000252226978773251, 0.000249439384788275, 0.00024669078993611, 0.000243934453465044, 0.000241217130678706, 0.000238499807892367, 0.000235813713516109, 0.00023311200493481, 0.000230464967899024, 0.000227817887207493, 0.000225186464376748, 0.000222578455577604, 0.000220001704292372, 0.000217401509871706, 0.000214848143514246, 0.000212271377677098, 0.000209764883038588, 0.0002072505740216, 0.000204767493414693, 0.000202276627533138, 0.000199832604266703, 0.00019736512331292, 0.000194960142835043, 0.000192523933947086, 0.000190142367500812, 0.000187760801054537, 0.000185426091775298, 0.000183067953912541, 0.00018074105901178, 0.000178421949385665, 0.000176149711478502, 0.000173846230609342, 0.000171613020938821, 0.000169340797583573, 0.000167138816323131, 0.000164913421031088, 0.000162734868354164, 0.000160556330229156, 0.000158401220687665, 0.000156253910972737, 0.000154137829667889, 0.00015202174836304, 0.00014992909564171, 0.000147859871503897, 0.000145814075949602, 0.000143752651638351, 0.00014469659072347, 0.000142728866194375, 0.000140784599352628, 0.000138848117785528, 0.000136935079353862, 0.000135053269332275, 0.00013316364493221, 0.000131305263494141, 0.000129446867504157, 0.000127604100271128, 0.000125769147416577, 0.000123949779663235, 0.000122161683975719, 0.00012038137356285, 0.000118608877528459, 0.000116859810077585, 0.000115126356831752, 0.000113392896309961, 0.000111682871647645, 0.000109996253740974, 0.000108317472040653, 0.000106669904198498, 0.000105006729427259, 0.000103366968687624, 0.000101742836704943, 0.000100134318927303, 9.85492079053074e-05, 9.69719330896623e-05, 9.54258794081397e-05, 9.38564044190571e-05, 9.23337720450945e-05, 9.08033325686119e-05, 8.9280707470607e-05, 8.78127393661998e-05, 8.6329149780795e-05, 8.48767958814278e-05, 8.3408820501063e-05, 8.19877022877336e-05, 8.05743911769241e-05, 7.91610800661147e-05, 7.77868117438629e-05, 7.64125434216112e-05, 7.50538893043995e-05, 7.36952351871878e-05, 7.23756238585338e-05, 7.10560052539222e-05, 6.97520154062659e-05, 6.84714468661696e-05, 6.71830712235533e-05, 6.59493452985771e-05, 6.46843982394785e-05, 6.347410089802e-05, 6.22559964540415e-05, 6.1053506215103e-05, 5.9890062402701e-05, 5.8695390180219e-05, 5.75709818804171e-05, 5.64075417059939e-05, 5.52909477846697e-05, 5.41743502253667e-05, 5.30733741470613e-05, 5.20036337547936e-05, 5.09104611410294e-05, 4.98641384183429e-05, 4.88256264361553e-05, 4.78105430374853e-05, 4.67954560008366e-05, 4.57959868072066e-05, 4.48277532996144e-05, 4.38439019490033e-05, 4.291470759199e-05, 4.12632398365531e-05, 4.03730882680975e-05, 3.94907401641831e-05, 3.86240171792451e-05, 3.77494798158295e-05, 3.68983710359316e-05, 3.60550693585537e-05, 3.52234819729347e-05, 3.44075051543768e-05, 3.35993390763178e-05, 3.27989837387577e-05, 3.19947248499375e-05, 3.12138909066562e-05, 3.04369605146348e-05, 2.9683453249163e-05, 2.89338495349512e-05, 2.8199867301737e-05, 2.74658796115546e-05, 2.67279901891015e-05, 2.60291435552062e-05, 2.53107737080427e-05, 2.46236395469168e-05, 2.39443143073004e-05, 2.32571783271851e-05, 2.2616894057137e-05, 2.19453759200405e-05, 2.1305089831003e-05, 2.06765180337243e-05, 2.0055755157955e-05, 1.94427975657163e-05, 1.88298417924671e-05, 1.82520252565155e-05, 1.76546855072957e-05, 1.70807725226041e-05, 1.6522475561942e-05, 1.59719857037999e-05, 1.54254012159072e-05, 1.48788149090251e-05, 1.43556571856607e-05, 1.38442101160763e-05, 1.33405701490119e-05, 1.28486444737064e-05, 1.23684294521809e-05, 1.18999296319089e-05, 1.14236199806328e-05, 1.09629272628808e-05, 1.05256594906677e-05, 1.00961997304694e-05, 9.66673997027101e-06, 9.26070606510621e-06, 8.84295968717197e-06, 8.4486373452819e-06, 8.05821946414653e-06, 7.68341942603001e-06, 7.32033049644087e-06, 6.96895449436852e-06, 6.62538741380558e-06, 6.2818198784953e-06, 5.95386927670916e-06, 5.64153469895246e-06, 5.33700904270518e-06, 5.04419540447998e-06, 4.76309514851891e-06, 4.48589844381786e-06, 4.20870219386416e-06, 3.95883489545668e-06, 3.7011593576608e-06, 3.47081277141115e-06, 3.24827442454989e-06, 3.02573653243599e-06, 2.82662358586094e-06, 2.62360663327854e-06, 2.66069628196419e-06, 2.49769686888612e-06, 2.33079322242702e-06, 2.16828198063013e-06, 2.01748298422899e-06, 1.86326815310167e-06, 1.71295732798171e-06, 1.57094302721816e-06, 1.42892849908094e-06, 1.29521049530013e-06, 1.16149249151931e-06, 1.03265460893454e-06, 9.06744958228956e-07, 7.85715485562832e-07, 6.65662128085387e-07, 5.56345128188696e-07, 4.43612066192145e-07, 3.35759153813342e-07, 2.39130827139888e-07, 1.34694090547782e-07, 4.29459454664993e-08, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 2.5547572022333e-06, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 8.00356119157186e-08, 1.76175944943679e-07, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15, 1.55878679189821e-15   }, 
   { 0.00397094525396824, 0.00371781294234097, 0.00347301061265171, 0.00323623837903142, 0.00300772115588188, 0.00278753414750099, 0.00257545220665634, 0.00237147533334792, 0.00217597861774266, 0.00198836205527186, 0.00180907547473907, 0.00163811910897493, 0.00147519272286445, 0.00132052146364003, 0.00117410544771701, 0.0010357943829149, 0.000905813532881439, 0.000783937692176551, 0.000670242006890476, 0.000564876419957727, 0.000467615900561213, 0.000378460448700935, 0.000297710212180391, 0.000224989969865419, 0.000160524868988432, 0.000104389939224347, 5.62850145797711e-05, 1.63601780514e-05, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.70168075076072e-05, 6.91930472385138e-05, 0.000119624426588416, 0.00017823587404564, 0.000244952389039099, 0.000319999089697376, 0.000403150799684227, 0.00049448263598606, 0.000594219658523798, 0.000701986718922853, 0.000817933876533061, 0.000942211190704256, 0.00107451842632145, 0.0012153061106801, 0.00136404868680984, 0.00152097130194306, 0.00168629898689687, 0.00185965688433498, 0.00204119482077658, 0.00223113805986941, 0.00242911116220057, 0.00263526453636587, 0.00284982286393642, 0.00307241128757596, 0.00330325495451689, 0.00354227866046131, 0.00378948240540922, 0.00404501659795642, 0.00430858042091131, 0.0045803994871676, 0.00486047379672527, 0.00514865294098854, 0.005445237737149, 0.00574977742508054, 0.00606264686211944, 0.00638377154245973, 0.00671292608603835, 0.00705033633857965, 0.00739607634022832, 0.00774992164224386, 0.00811194721609354, 0.008482301607728, 0.00886068679392338, 0.00924740266054869, 0.00964229833334684, 0.0100452993065119, 0.0104567054659128, 0.0108760660514235, 0.0113036818802357, 0.0117397028952837, 0.0121836801990867, 0.0126359863206744, 0.0130965476855636, 0.0135652143508196, 0.0140419853851199, 0.0145271625369787, 0.0150204449892044, 0.0155219817534089, 0.0160316992551088, 0.0165495201945305, 0.0170757472515106, 0.0176099296659231, 0.0181525181978941, 0.0187032110989094, 0.019262008368969, 0.019829286262393, 0.0204045176506042, 0.0209879335016012, 0.0215798262506723, 0.0221796724945307, 0.0227877777069807, 0.0233740117400885, 0.0239156987518072, 0.0244681928306818, 0.0250311568379402, 0.0256047379225492, 0.0261890515685081, 0.0267836470156908, 0.0273889005184174, 0.0280046593397856, 0.0286312233656645, 0.0292682182043791, 0.0299157593399286, 0.0305740311741829, 0.0312426593154669, 0.0319220200181007, 0.0326118879020214, 0.0333122611045837, 0.0340234041213989, 0.0347448661923409, 0.0354771725833416, 0.0362199060618877, 0.0369731150567532, 0.0377370901405811, 0.03851168602705, 0.0392966344952583, 0.0400923192501068, 0.040898397564888, 0.0417152419686317, 0.0425426699221134, 0.0433804541826248, 0.044229082763195, 0.0450879894196987, 0.0459576360881329, 0.0468377433717251, 0.0477286241948605, 0.0486300848424435, 0.0495419390499592, 0.0504644848406315, 0.0513975098729134, 0.0523411817848682, 0.0532953999936581, 0.0542602725327015, 0.0552356578409672, 0.0562214739620686, 0.0572181306779385, 0.0582252182066441, 0.0592428557574749, 0.0602711066603661, 0.0613099001348019, 0.0623593591153622, 0.0634193196892738, 0.0644897818565369, 0.065571054816246, 0.0666626840829849, 0.0677648186683655, 0.0688778385519981, 0.070001132786274, 0.0711352452635765, 0.0722797811031342, 0.07343490421772, 0.0746005997061729, 0.0757768079638481, 0.0769636705517769, 0.0781612694263458, 0.0793691501021385, 0.0805877521634102, 0.0818168669939041, 0.0830566361546516, 0.0843068435788155, 0.0855677872896194, 0.0868392959237099, 0.088121309876442, 0.0894317477941513, 0.090756393969059, 0.0920960530638695, 0.0934504941105843, 0.0948197245597839, 0.0962039530277252, 0.0976028367877007, 0.0990167930722237, 0.100445754826069, 0.101889505982399, 0.103348106145859, 0.104821875691414, 0.106310196220875, 0.107813611626625, 0.109331734478474, 0.110864795744419, 0.112412847578526, 0.11397548019886, 0.115553624927998, 0.117146052420139, 0.118753626942635, 0.120376199483871, 0.122013427317142, 0.123665727674961, 0.125332817435265, 0.127014607191086, 0.12871165573597, 0.13042339682579, 0.132150292396545, 0.133891597390175, 0.135648295283318, 0.137419462203979, 0.139205724000931, 0.14100669324398, 0.142822608351707, 0.144653677940369, 0.146499291062355, 0.148359999060631, 0.150235652923584, 0.152125999331474, 0.154031291604042, 0.155951499938965, 0.157886728644371, 0.159836754202843, 0.161801397800446, 0.163781598210335, 0.165776088833809, 0.167785689234734, 0.169810026884079, 0.171849325299263, 0.173903495073318, 0.175972402095795, 0.17805689573288, 0.180155485868454, 0.182269409298897, 0.184398040175438, 0.18654166162014, 0.188700020313263, 0.190873503684998, 0.193061873316765, 0.195264801383018, 0.197482883930206, 0.199715822935104, 0.201963469386101, 0.204226270318031, 0.206503659486771, 0.208796620368958, 0.211103543639183, 0.213425815105438, 0.215763062238693, 0.218114718794823, 0.220505461096764, 0.222934886813164, 0.225382447242737, 0.227847129106522, 0.230329677462578, 0.232829332351685, 0.23534682393074, 0.237881302833557, 0.240434095263481, 0.243003845214844, 0.245591312646866, 0.248196199536324, 0.250818759202957, 0.253458440303802, 0.256115853786469, 0.258790791034698, 0.261482864618301, 0.264192968606949, 0.266920477151871, 0.269665062427521, 0.272427678108215, 0.275207549333572, 0.278005003929138, 0.28082001209259, 0.283652245998383, 0.286502212285995, 0.289369463920593, 0.292254686355591, 0.295156896114349, 0.29807710647583, 0.301014602184296, 0.303969949483871, 0.30694192647934, 0.309932231903076, 0.312939345836639, 0.315964192152023, 0.319006711244583, 0.322066843509674, 0.325144171714783, 0.328239262104034, 0.331351608037949, 0.334481656551361, 0.337628960609436, 0.340794116258621, 0.343976557254791, 0.347176522016525, 0.350394517183304, 0.353629350662231, 0.356881976127625, 0.360151946544647, 0.363439440727234, 0.366744339466095, 0.370066970586777, 0.373406976461411, 0.376764565706253, 0.38013955950737, 0.383531987667084, 0.386942237615585, 0.390369772911072, 0.393814861774445, 0.397277384996414, 0.40075758099556, 0.404254764318466, 0.407770097255707, 0.411302536725998, 0.414853125810623, 0.418420702219009, 0.42200568318367, 0.425608366727829, 0.42922830581665, 0.432866126298904, 0.436529457569122, 0.440337181091309, 0.44415944814682, 0.447997331619263, 0.451849460601807, 0.455717235803604, 0.459599733352661, 0.463497459888458, 0.467410087585449, 0.471337914466858, 0.475280702114105, 0.479238659143448, 0.483211934566498, 0.487199276685715, 0.491202414035797, 0.495219975709915, 0.499253153800964, 0.503300845623016, 0.50736403465271, 0.511442065238953, 0.515535235404968, 0.519643306732178, 0.523766398429871, 0.527904570102692, 0.532057642936707, 0.536225914955139, 0.54040914773941, 0.544607281684875, 0.548820793628693, 0.553049445152283, 0.557292699813843, 0.561551332473755, 0.565824627876282, 0.570112943649292, 0.574416995048523, 0.578735172748566, 0.58306884765625, 0.587417125701904, 0.591781258583069, 0.596159517765045, 0.600553333759308, 0.60496199131012, 0.609386026859283, 0.613824546337128, 0.618278861045837, 0.622747719287872, 0.627231776714325, 0.631730914115906, 0.636244833469391, 0.640773832798004, 0.645317435264587, 0.64987701177597, 0.654450595378876, 0.659039855003357, 0.663643956184387, 0.668263375759125, 0.672897458076477, 0.677546858787537, 0.6822110414505, 0.686890304088593, 0.691584646701813, 0.696294069290161, 0.701018571853638, 0.705758333206177, 0.710512816905975, 0.715282440185547, 0.720066905021667, 0.724866449832916, 0.729680955410004, 0.734511017799377, 0.739355385303497, 0.744215250015259, 0.749152183532715, 0.754119873046875, 0.759093582630157, 0.764073848724365, 0.769060790538788, 0.774053275585175, 0.779052495956421, 0.78405749797821, 0.78906911611557, 0.794087052345276, 0.799111247062683, 0.804141640663147, 0.809178650379181, 0.814221382141113, 0.819270849227905, 0.824326455593109, 0.82938826084137, 0.834456384181976, 0.839531064033508, 0.844611525535583, 0.849698722362518, 0.854791939258575, 0.859891831874847, 0.864997446537018, 0.870109856128693, 0.875228226184845, 0.880352854728699, 0.885483980178833, 0.890621483325958, 0.895764946937561, 0.900914907455444, 0.90607100725174, 0.91123366355896, 0.916402339935303, 0.921577334403992, 0.926758885383606, 0.931946516036987, 0.93714052438736, 0.942340910434723, 0.947547435760498, 0.952759921550751, 0.957979261875153, 0.963204562664032, 0.968436121940613, 0.97367388010025, 0.978918492794037, 0.984168589115143, 0.989425778388977, 0.994688630104065, 0.999958276748657, 1.00523340702057, 1.01051568984985, 1.01580393314362, 1.02109825611115, 1.0263991355896, 1.0317063331604, 1.03701961040497, 1.04233944416046, 1.04766523838043, 1.05299758911133, 1.05833566188812, 1.06368100643158, 1.06903183460236, 1.07438933849335, 1.07975292205811, 1.08512330055237, 1.09049916267395, 1.09588170051575, 1.10127103328705, 1.10666573047638, 1.1120673418045, 1.11745870113373, 1.1228266954422, 1.12818992137909, 1.13355016708374, 1.13890647888184, 1.14425909519196, 1.1496068239212, 1.15495228767395, 1.1602931022644, 1.16563045978546, 1.17096328735352, 1.17629289627075, 1.18161845207214, 1.18694078922272, 1.19225883483887, 1.19757282733917, 1.20288276672363, 1.20818972587585, 1.21349263191223, 1.21879100799561, 1.22408604621887, 1.22937774658203, 1.23466527462006, 1.23994839191437, 1.24522805213928, 1.25050485134125, 1.25577640533447, 1.26104485988617, 1.26630973815918, 1.27157008647919, 1.27682650089264, 1.28207993507385, 1.2873295545578, 1.29257464408875, 1.297816157341, 1.30305373668671, 1.30828809738159, 1.31351804733276, 1.31874430179596, 1.32396614551544, 1.32918524742126, 1.33440005779266, 1.33961093425751, 1.3448178768158, 1.35002171993256, 1.3552211523056, 1.36041724681854, 1.36560833454132, 1.37079679965973, 1.375981092453, 1.38116180896759, 1.3863377571106, 1.39151084423065, 1.39667952060699, 1.40184545516968, 1.40700578689575, 1.41216337680817, 1.41731739044189, 1.42246735095978, 1.42761301994324, 1.4327552318573, 1.43789398670197, 1.44302880764008, 1.44815921783447, 1.4532858133316, 1.45840930938721, 1.46352827548981, 1.46864378452301, 1.47375500202179, 1.4788635969162, 1.48396706581116, 1.48906683921814, 1.49432480335236, 1.49963390827179, 1.50492322444916, 1.51019275188446, 1.5154435634613, 1.52067470550537, 1.52588653564453, 1.5310777425766, 1.53625071048737, 1.54140400886536, 1.54653739929199, 1.55165183544159, 1.55674707889557, 1.56182360649109, 1.56687879562378, 1.5719153881073, 1.57693183422089, 1.58192944526672, 1.58690714836121, 1.59186697006226, 1.59680557250977, 1.6017245054245, 1.60662531852722, 1.61150574684143, 1.61636698246002, 1.62120807170868, 1.6260312795639, 1.63083386421204, 1.63561725616455, 1.640380859375, 1.64512550830841, 1.64985036849976, 1.65455555915833, 1.65924334526062, 1.66391003131866, 1.66855680942535, 1.67318451404572, 1.67779242992401, 1.68238162994385, 1.68695104122162, 1.69150078296661, 1.6960301399231, 1.70054197311401, 1.70503342151642, 1.70950531959534, 1.71395778656006, 1.71839082241058, 1.72280418872833, 1.72719836235046, 1.73157262802124, 1.73592865467072, 1.74026453495026, 1.74458026885986, 1.74887752532959, 1.7531555891037, 1.75741398334503, 1.76165199279785, 1.7658714056015, 1.77007079124451, 1.77425134181976, 1.77841138839722, 1.78255212306976, 1.78667378425598, 1.79077637195587, 1.79485893249512, 1.79892194271088, 1.80296552181244, 1.80699038505554, 1.81099581718445, 1.8149801492691, 1.81894683837891, 1.82286715507507, 1.8266806602478, 1.83045661449432, 1.8341920375824, 1.83789229393005, 1.84155023097992, 1.84517002105713, 1.84874927997589, 1.85228908061981, 1.85579228401184, 1.85925650596619, 1.86268162727356, 1.86606407165527, 1.86941242218018, 1.87271869182587, 1.87598586082458, 1.87921476364136, 1.88240683078766, 1.88555467128754, 1.88866817951202, 1.89174044132233, 1.89477276802063, 1.89776802062988, 1.900723695755, 1.9036420583725, 1.90651798248291, 1.90935826301575, 1.91215717792511, 1.91491651535034, 1.91763865947723, 1.92032098770142, 1.92296385765076, 1.9255678653717, 1.92813372612, 1.93066000938416, 1.93314564228058, 1.93559324741364, 1.93800508975983, 1.94037175178528, 1.94270479679108, 1.9449964761734, 1.94724786281586, 1.94946217536926, 1.95163786411285, 1.95377194881439, 1.95586967468262, 1.95792841911316, 1.95994746685028, 1.96192574501038, 1.96386611461639, 1.96576809883118, 1.96762931346893, 1.96945321559906, 1.97123825550079, 1.97298169136047, 1.97468793392181, 1.97635686397552, 1.97798454761505, 1.97957372665405, 1.98112392425537, 1.98263573646545, 1.98410403728485, 1.98553788661957, 1.98693251609802, 1.98828637599945, 1.9896023273468, 1.99087989330292, 1.99211978912354, 1.99331629276276, 1.99447679519653, 1.99559843540192, 1.99667716026306, 1.99726974964142, 1.99779915809631, 1.99828553199768, 1.99872875213623, 1.99913215637207, 1.99948883056641, 1.99980688095093, 2.00008177757263, 2.00031232833862, 2.00049734115601, 2.00064253807068, 2.00074362754822, 2.00080108642578, 2.00081777572632, 2.00079274177551, 2.00072312355042, 2.00060892105103, 2.00045537948608, 2.00025367736816, 2.00001454353333, 1.99973261356354, 1.99940347671509, 1.9990336894989, 1.9986230134964, 1.99816799163818, 1.99766719341278, 1.99712562561035, 1.99654221534729, 1.99591648578644, 1.99524772167206, 1.99453449249268, 1.99377679824829, 1.99297952651978, 1.99213886260986, 1.9912576675415, 1.99032711982727, 1.98935794830322, 1.98834931850433, 1.98729276657104, 1.98619401454926, 1.98505461215973, 1.98386716842651, 1.98263990879059, 1.98137414455414, 1.98005950450897, 1.97870373725891, 1.97730731964111, 1.97586524486542, 1.97437989711761, 1.97285485267639, 1.97128546237946, 1.96967303752899, 1.96801829338074, 1.96631801128387, 1.96457707881927, 1.96279382705688, 1.96096754074097, 1.95910036563873, 1.95718765258789, 1.95523035526276, 1.95323348045349, 1.95119106769562, 1.94910657405853, 1.94698011875153, 1.94481027126312, 1.94259977340698, 1.94034469127655, 1.93804633617401, 1.93570375442505, 1.93332159519196, 1.93089497089386, 1.92835760116577, 1.9257435798645, 1.92309653759003, 1.92042124271393, 1.91771733760834, 1.91498005390167, 1.91221189498901, 1.9094146490097, 1.90658748149872, 1.90373206138611, 1.90084373950958, 1.8979252576828, 1.89497578144073, 1.89199674129486, 1.88898694515228, 1.88594794273376, 1.88287687301636, 1.87977838516235, 1.87664699554443, 1.87348592281342, 1.87029314041138, 1.86707210540771, 1.86382102966309, 1.86053836345673, 1.85722601413727, 1.85388243198395, 1.85050666332245, 1.84710431098938, 1.8436690568924, 1.84020364284515, 1.83671128749847, 1.83318400382996, 1.82963156700134, 1.82604444026947, 1.82242774963379, 1.81878173351288, 1.81510317325592, 1.81139838695526, 1.80765986442566, 1.80389010906219, 1.80009377002716, 1.79626297950745, 1.79240608215332, 1.78851568698883, 1.78459513187408, 1.78064727783203, 1.77666485309601, 1.77265679836273, 1.76861381530762, 1.76454269886017, 1.76044154167175, 1.75630807876587, 1.75214636325836, 1.74795377254486, 1.74372911453247, 1.73947787284851, 1.73519289493561, 1.73087918758392, 1.72653484344482, 1.7221611738205, 1.71775674819946, 1.71331775188446, 1.70885503292084, 1.70435774326324, 1.6998302936554, 1.69527471065521, 1.69068598747253, 1.68606746196747, 1.68142223358154, 1.67674171924591, 1.67203426361084, 1.66733658313751, 1.66250741481781, 1.65766513347626, 1.65281212329865, 1.64794492721558, 1.64306569099426, 1.63817322254181, 1.63326871395111, 1.62835109233856, 1.62342166900635, 1.61847805976868, 1.61352205276489, 1.60855531692505, 1.60357403755188, 1.59858071804047, 1.59357440471649, 1.58855605125427, 1.58352422714233, 1.57848072052002, 1.57342374324799, 1.56835389137268, 1.56327247619629, 1.55817759037018, 1.55306959152222, 1.54795134067535, 1.5428169965744, 1.537672996521, 1.53251457214355, 1.52734375, 1.52216100692749, 1.51696455478668, 1.51175534725189, 1.5065336227417, 1.50130033493042, 1.49605321884155, 1.49079430103302, 1.48552334308624, 1.48023808002472, 1.47494149208069, 1.46963143348694, 1.46430826187134, 1.45897352695465, 1.45362484455109, 1.44826459884644, 1.4428915977478, 1.43750536441803, 1.43210697174072, 1.42669665813446, 1.42127275466919, 1.41583514213562, 1.41038691997528, 1.40492486953735, 1.39944922924042, 1.39396274089813, 1.38846337795258, 1.38295078277588, 1.37742590904236, 1.3718878030777, 1.36633694171906, 1.36077463626862, 1.35519778728485, 1.34960877895355, 1.34400987625122, 1.33839535713196, 1.33276784420013, 1.32713031768799, 1.32147800922394, 1.31581342220306, 1.31013631820679, 1.30444633960724, 1.29874384403229, 1.29303061962128, 1.28731191158295, 1.28160178661346, 1.27589726448059, 1.27019965648651, 1.26450777053833, 1.25882542133331, 1.25314879417419, 1.24747955799103, 1.24181520938873, 1.23615860939026, 1.23050975799561, 1.22486710548401, 1.21922981739044, 1.21360087394714, 1.20797669887543, 1.20236027240753, 1.19675230979919, 1.19114899635315, 1.18555402755737, 1.17996418476105, 1.17438173294067, 1.16880643367767, 1.16323924064636, 1.15767502784729, 1.15212190151215, 1.14657330513, 1.14103150367737, 1.13549649715424, 1.12996888160706, 1.12444698810577, 1.11893320083618, 1.11342477798462, 1.1079226732254, 1.10242879390717, 1.09694302082062, 1.09146022796631, 1.08598709106445, 1.08051991462708, 1.07505977153778, 1.06960475444794, 1.06415843963623, 1.0587203502655, 1.05328571796417, 1.04785883426666, 1.0424393415451, 1.03702557086945, 1.03162062168121, 1.02621960639954, 1.02082693576813, 1.01544237136841, 1.01006305217743, 1.00468993186951, 0.999325215816498, 0.993965744972229, 0.988612294197083, 0.9832683801651, 0.977930128574371, 0.972596704959869, 0.967271983623505, 0.961953580379486, 0.956642210483551, 0.95133775472641, 0.946038901805878, 0.940746963024139, 0.935463607311249, 0.930186033248901, 0.924914717674255, 0.919651091098785, 0.914394378662109, 0.909141957759857, 0.903899013996124, 0.898685812950134, 0.893729090690613, 0.888792872428894, 0.883875727653503, 0.878974378108978, 0.874092161655426, 0.869227886199951, 0.864385306835175, 0.859558284282684, 0.854751765727997, 0.849961996078491, 0.845190227031708, 0.840440034866333, 0.835705518722534, 0.830990195274353, 0.826296448707581, 0.821615934371948, 0.816957056522369, 0.812313795089722, 0.807695686817169, 0.803089678287506, 0.798505187034607, 0.793938755989075, 0.789389193058014, 0.784861147403717, 0.780351161956787, 0.775857925415039, 0.771382749080658, 0.766926765441895, 0.762492477893829, 0.75807249546051, 0.753671765327454, 0.749293863773346, 0.744929134845734, 0.740584850311279, 0.736259818077087, 0.731950283050537, 0.727662444114685, 0.723393857479095, 0.719140768051147, 0.714908123016357, 0.71069347858429, 0.706496894359589, 0.702319443225861, 0.698161363601685, 0.694019913673401, 0.689899027347565, 0.68579488992691, 0.681709945201874, 0.677643001079559, 0.673596501350403, 0.669569194316864, 0.665556371212006, 0.661565005779266, 0.657591700553894, 0.653636515140533, 0.64969927072525, 0.645783543586731, 0.641881227493286, 0.63800036907196, 0.634138822555542, 0.63029283285141, 0.626469612121582, 0.62266331911087, 0.618874847888947, 0.615103363990784, 0.61135345697403, 0.607619166374207, 0.603906452655792, 0.6002117395401, 0.596533834934235, 0.592875182628632, 0.589390277862549, 0.585905730724335, 0.582435548305511, 0.578990638256073, 0.575561285018921, 0.572152376174927, 0.568759083747864, 0.565388560295105, 0.562034904956818, 0.558702826499939, 0.555387496948242, 0.552093863487244, 0.548817038536072, 0.545561790466309, 0.542318642139435, 0.539101779460907, 0.535902976989746, 0.532721042633057, 0.52955949306488, 0.526419520378113, 0.523292720317841, 0.520190060138702, 0.517105281352997, 0.514038622379303, 0.510989904403687, 0.507961630821228, 0.504954993724823, 0.501961469650269, 0.498992055654526, 0.496041804552078, 0.493107229471207, 0.490194201469421, 0.487299174070358, 0.48442217707634, 0.481566816568375, 0.478730648756027, 0.475910067558289, 0.473111152648926, 0.470333844423294, 0.467569679021835, 0.464827209711075, 0.462105095386505, 0.45940101146698, 0.456714957952499, 0.454051673412323, 0.451405256986618, 0.448776811361313, 0.446168810129166, 0.443581163883209, 0.441006779670715, 0.438456386327744, 0.435925215482712, 0.433410853147507, 0.430918127298355, 0.428444534540176, 0.425986647605896, 0.423550337553024, 0.421130836009979, 0.418731719255447, 0.416353046894073, 0.413994789123535, 0.411650896072388, 0.409328669309616, 0.407026827335358, 0.404743015766144, 0.402474820613861, 0.400229394435883, 0.39800438284874, 0.395795047283173, 0.393607288599014, 0.391438752412796, 0.389345824718475, 0.38731837272644, 0.385302931070328, 0.383301287889481, 0.381312817335129, 0.379335194826126, 0.377373784780502, 0.375421941280365, 0.373485147953033, 0.371559739112854, 0.369648158550262, 0.367749184370041, 0.365860432386398, 0.363987267017365, 0.362125515937805, 0.360276937484741, 0.358441591262817, 0.356619477272034, 0.354808747768402, 0.353012442588806, 0.351225733757019, 0.349454611539841, 0.347694307565689, 0.345948398113251, 0.344216346740723, 0.342495054006577, 0.340787649154663, 0.339093387126923, 0.337408721446991, 0.33573967218399, 0.334083259105682, 0.332438826560974, 0.330808192491531, 0.329190790653229, 0.327583611011505, 0.32599201798439, 0.324410021305084, 0.322843044996262, 0.321288675069809, 0.319746345281601, 0.318218380212784, 0.316701859235764, 0.315197914838791, 0.313707143068314, 0.312230855226517, 0.310763508081436, 0.309310644865036, 0.307871550321579, 0.30644503235817, 0.305031806230545, 0.30362930893898, 0.302241861820221, 0.300866365432739, 0.299503564834595, 0.29815149307251, 0.296814471483231, 0.295488834381104, 0.294176995754242, 0.292878389358521, 0.291592389345169, 0.29031902551651, 0.289059430360794, 0.287809461355209, 0.286575078964233, 0.285352736711502, 0.284142374992371, 0.282945245504379, 0.281761288642883, 0.280590564012527, 0.279431849718094, 0.278288125991821, 0.277151644229889, 0.275914460420609, 0.274716109037399, 0.273523777723312, 0.272337436676025, 0.271156489849091, 0.269982159137726, 0.268812030553818, 0.267647922039032, 0.266489505767822, 0.265336185693741, 0.264189779758453, 0.263048470020294, 0.261913150548935, 0.260782957077026, 0.259658187627792, 0.258539646863937, 0.257425993680954, 0.256318300962448, 0.255216002464294, 0.254120022058487, 0.253030359745026, 0.251945167779922, 0.250865697860718, 0.249792248010635, 0.24872387945652, 0.247661232948303, 0.246604263782501, 0.245553597807884, 0.24450895190239, 0.243469104170799, 0.242434069514275, 0.241405934095383, 0.240382611751556, 0.239365577697754, 0.238353937864304, 0.237348303198814, 0.236348077654839, 0.235353872179985, 0.234364464879036, 0.233381360769272, 0.23240365087986, 0.231430441141129, 0.230464428663254, 0.229503244161606, 0.228548064827919, 0.227599769830704, 0.226655974984169, 0.225717589259148, 0.22478461265564, 0.223857939243317, 0.222936362028122, 0.222020208835602, 0.221110329031944, 0.220206469297409, 0.219308018684387, 0.218414664268494, 0.217527016997337, 0.216645672917366, 0.215769723057747, 0.214898571372032, 0.21403343975544, 0.213174611330032, 0.212321788072586, 0.211474046111107, 0.210631132125854, 0.209794819355011, 0.208963304758072, 0.208138078451157, 0.20731857419014, 0.206503868103027, 0.205697253346443, 0.204834222793579, 0.203925564885139, 0.203022018074989, 0.202120542526245, 0.20122329890728, 0.200329631567001, 0.199440181255341, 0.198554933071136, 0.197672680020332, 0.196794927120209, 0.195920795202255, 0.195050254464149, 0.194184213876724, 0.193320885300636, 0.192462056875229, 0.191607102751732, 0.190756067633629, 0.18990895152092, 0.189065128564835, 0.188224896788597, 0.187389776110649, 0.186557084321976, 0.185729444026947, 0.184905126690865, 0.184084132313728, 0.183267623186111, 0.182454109191895, 0.181645423173904, 0.180840313434601, 0.180038809776306, 0.179241225123405, 0.178448110818863, 0.17765773832798, 0.176871851086617, 0.176089257001877, 0.17531056702137, 0.174536675214767, 0.173765510320663, 0.172998532652855, 0.172235459089279, 0.171475991606712, 0.17072132229805, 0.169968754053116, 0.169221267104149, 0.168477118015289, 0.16773684322834, 0.167001098394394, 0.166268050670624, 0.165540084242821, 0.16481514275074, 0.164093777537346, 0.163376957178116, 0.162663698196411, 0.161953762173653, 0.16124801337719, 0.160545587539673, 0.159848555922508, 0.159154817461967, 0.158463478088379, 0.157776966691017, 0.157094344496727, 0.156415909528732, 0.15574049949646, 0.155068978667259, 0.1544019728899, 0.153738245368004, 0.153079032897949, 0.15242312848568, 0.151770517230034, 0.151122108101845, 0.150478512048721, 0.149855405092239, 0.149280250072479, 0.148707941174507, 0.148138329386711, 0.147573232650757, 0.147010684013367, 0.1464514285326, 0.145896539092064, 0.145344033837318, 0.144795134663582, 0.144250005483627, 0.143707856535912, 0.143169641494751, 0.142633646726608, 0.142102167010307, 0.141573831439018, 0.141048207879066, 0.140526786446571, 0.14000791311264, 0.13949279487133, 0.138981565833092, 0.13847304880619, 0.137967988848686, 0.137466832995415, 0.136968076229095, 0.136473819613457, 0.135981664061546, 0.135493844747543, 0.13500964641571, 0.134527698159218, 0.134049952030182, 0.133575648069382, 0.133103743195534, 0.132636204361916, 0.132171675562859, 0.131711050868034, 0.131253093481064, 0.130798473954201, 0.130347892642021, 0.129899546504021, 0.129455745220184, 0.129015058279037, 0.128577083349228, 0.128143161535263, 0.127712696790695, 0.127284780144691, 0.126861214637756, 0.126440048217773, 0.126023396849632, 0.125609293580055, 0.125198468565941, 0.124791875481606, 0.124388128519058, 0.12398736923933, 0.123590670526028, 0.123196370899677, 0.122806295752525, 0.122419640421867, 0.122036002576351, 0.121655508875847, 0.121279388666153, 0.120905645191669, 0.120535671710968, 0.120168834924698, 0.11980576813221, 0.119445696473122, 0.119088917970657, 0.118735894560814, 0.118385724723339, 0.118039466440678, 0.117696940898895, 0.117356538772583, 0.116994194686413, 0.116623155772686, 0.116254530847073, 0.115887701511383, 0.115523561835289, 0.115161545574665, 0.114801630377769, 0.114443801343441, 0.114088535308838, 0.113735362887383, 0.113384291529655, 0.113035626709461, 0.112689360976219, 0.112344600260258, 0.112002983689308, 0.111663021147251, 0.111325308680534, 0.110989846289158, 0.110657095909119, 0.110325843095779, 0.109997436404228, 0.109670981764793, 0.109347090125084, 0.109024681150913, 0.108705125749111, 0.108387537300587, 0.108072184026241, 0.107759095728397, 0.107448548078537, 0.107139505445957, 0.106833465397358, 0.106529228389263, 0.106227681040764, 0.105927646160126, 0.105630315840244, 0.105335079133511, 0.105042099952698, 0.104751214385033, 0.104462891817093, 0.104176208376884, 0.103892385959625, 0.10361035913229, 0.103331193327904, 0.103053368628025, 0.102778397500515, 0.102505519986153, 0.10223475843668, 0.101966090500355, 0.101700127124786, 0.101435653865337, 0.10117419809103, 0.100914537906647, 0.100657276809216, 0.100402116775513, 0.100149355828762, 0.0998987033963203, 0.0996502935886383, 0.0994038432836533, 0.0991603955626488, 0.0989182963967323, 0.0986789017915726, 0.0984415933489799, 0.0982065498828888, 0.0979736000299454, 0.0977433547377586, 0.0975147634744644, 0.097288578748703, 0.0970649346709251, 0.0968434065580368, 0.0966235175728798, 0.096406489610672, 0.0961905792355537, 0.0960037857294083, 0.0958181172609329, 0.0956342592835426, 0.0954514443874359, 0.0952702835202217, 0.0950901731848717, 0.0949115604162216, 0.0947344452142715, 0.0945585444569588, 0.0943842008709908, 0.0942109301686287, 0.0940394401550293, 0.0938689410686493, 0.0937000066041946, 0.0935323536396027, 0.0933661982417107, 0.0932012498378754, 0.0930377915501595, 0.0928755477070808, 0.0927147939801216, 0.0925553217530251, 0.0923974961042404, 0.0922406539320946, 0.0920856073498726, 0.0919315442442894, 0.0917792618274689, 0.0916278958320618, 0.0914781019091606, 0.0913295820355415, 0.091182641685009, 0.0910369828343391, 0.0908928140997887, 0.090749628841877, 0.0906082317233086, 0.0904680490493774, 0.0903293639421463, 0.0901917219161987, 0.0900557413697243, 0.08992088586092, 0.0897878333926201, 0.0896557494997978, 0.0895251557230949, 0.0893957763910294, 0.0892683565616608, 0.0891415253281593, 0.0890166535973549, 0.0888926759362221, 0.0887705087661743, 0.0886493697762489, 0.0885299742221832, 0.0884115472435951, 0.0882948487997055, 0.0881792828440666, 0.0880653634667397, 0.0879523381590843, 0.087841123342514, 0.0877309441566467, 0.0876224339008331, 0.0875149667263031, 0.0874092280864716, 0.0873046815395355, 0.0872017294168472, 0.0870996564626694, 0.0869994014501572, 0.0869003385305405, 0.0868028476834297, 0.0867064893245697, 0.0866117030382156, 0.086517907679081, 0.086425893008709, 0.0863349288702011, 0.0862400457262993, 0.0861451253294945, 0.0860500410199165, 0.085954874753952, 0.0858594179153442, 0.0857641771435738, 0.085668720304966, 0.0855731144547462, 0.0854773595929146, 0.0853817537426949, 0.0852858349680901, 0.0851899236440659, 0.0850940868258476, 0.0849979519844055, 0.084901750087738, 0.0848056152462959, 0.0847093313932419, 0.0846129655838013, 0.0845164582133293, 0.0844197943806648, 0.0843232199549675, 0.0842263996601105, 0.0841296687722206, 0.0840326398611069, 0.0839357376098633, 0.083838626742363, 0.0837414488196373, 0.0836441144347191, 0.0835467800498009, 0.0834494382143021, 0.0833519548177719, 0.0832542404532433, 0.0831565409898758, 0.0830585956573486, 0.0829608142375946, 0.082862876355648, 0.0827648639678955, 0.082666702568531, 0.0825685486197472, 0.0824703052639961, 0.0823719277977943, 0.0822734609246254, 0.0821749195456505, 0.0820763111114502, 0.0819775462150574, 0.0818787887692451, 0.0817798748612404, 0.0816809684038162, 0.0815819054841995, 0.0814826935529709, 0.0813834741711617, 0.0812841206789017, 0.0811846852302551, 0.081085167825222, 0.0809857472777367, 0.080885998904705, 0.0807861089706421, 0.0806862935423851, 0.0805864110589027, 0.0804865211248398, 0.0803863331675529, 0.0802861452102661, 0.0801858827471733, 0.0800855532288551, 0.0799850597977638, 0.0798846557736397, 0.0797840133309364, 0.0796832963824272, 0.0795825943350792, 0.079481728374958, 0.0793806314468384, 0.0792660415172577, 0.0791189521551132, 0.0789718627929688, 0.0788244679570198, 0.0786769986152649, 0.078529454767704, 0.0783817693591118, 0.0782341510057449, 0.0780862271785736, 0.0779381692409515, 0.0777900964021683, 0.0776420310139656, 0.0774935856461525, 0.07734514772892, 0.0771966204047203, 0.0770478770136833, 0.0768990591168404, 0.076750248670578, 0.0766012817621231, 0.0764521732926369, 0.0763028934597969, 0.0761535614728928, 0.0760040655732155, 0.0758543461561203, 0.0757046192884445, 0.0755550563335419, 0.0754050388932228, 0.0752549469470978, 0.0751046985387802, 0.0749543830752373, 0.0748041421175003, 0.0746535956859589, 0.0745029002428055, 0.0743522793054581, 0.0742014423012733, 0.0740504488348961, 0.0738992989063263, 0.0737482309341431, 0.0735969319939613, 0.0734454914927483, 0.0732939690351486, 0.0731423795223236, 0.0729905664920807, 0.0728386715054512, 0.0726867765188217, 0.0725345760583878, 0.0723822340369225, 0.0722298845648766, 0.0720775425434113, 0.07192512601614, 0.0717722550034523, 0.0716195330023766, 0.0714665874838829, 0.0713135004043579, 0.0711604729294777, 0.0710072293877602, 0.0708537548780441, 0.0707005113363266, 0.0705468133091927, 0.0703931227326393, 0.0702393501996994, 0.0700854286551476, 0.0699312835931778, 0.069777138531208, 0.0696229189634323, 0.0694684684276581, 0.0693140178918839, 0.0691594332456589, 0.0690046772360802, 0.0688497126102448, 0.0686948150396347, 0.0685396939516068, 0.0684214606881142, 0.068297304213047, 0.0681735500693321, 0.0680499523878098, 0.0679266825318336, 0.0678037405014038, 0.0676810592412949, 0.067558690905571, 0.0674366131424904, 0.0673147514462471, 0.0671932399272919, 0.0670719817280769, 0.0669509693980217, 0.0668302923440933, 0.0667099356651306, 0.0665897652506828, 0.0664700716733932, 0.066350482404232, 0.0662312135100365, 0.0661122053861618, 0.0659935250878334, 0.0658751726150513, 0.0657569989562035, 0.0656391531229019, 0.0655217990279198, 0.0654044672846794, 0.0652875229716301, 0.0651708617806435, 0.0650542750954628, 0.0649384036660194, 0.0648225471377373, 0.0647070333361626, 0.0645916908979416, 0.0644766986370087, 0.0643620118498802, 0.0642476007342339, 0.0641335844993591, 0.0640197396278381, 0.0639061629772186, 0.0637929663062096, 0.0636800229549408, 0.0635673627257347, 0.0634549409151077, 0.0633429139852524, 0.063231073319912, 0.0631195604801178, 0.0630083009600639, 0.0628973841667175, 0.0627865567803383, 0.0626762211322784, 0.0625660493969917, 0.0624563507735729, 0.0623467676341534, 0.0622375160455704, 0.0621285103261471, 0.0620199739933014, 0.0619114749133587, 0.0618033893406391, 0.0616955496370792, 0.0615879520773888, 0.0614808611571789, 0.0613738819956779, 0.0612671263515949, 0.0611607693135738, 0.0610546134412289, 0.0609487779438496, 0.0608432665467262, 0.0607380829751492, 0.0606330744922161, 0.0605284050107002, 0.0604240521788597, 0.0603118725121021, 0.0602076686918736, 0.0601032078266144, 0.0599985904991627, 0.059893786907196, 0.0597887970507145, 0.0596837140619755, 0.059578400105238, 0.0594729259610176, 0.0593672394752502, 0.0592613704502583, 0.0591554567217827, 0.0590492710471153, 0.0589429251849651, 0.0588364340364933, 0.0587297342717648, 0.0586229488253593, 0.0585158914327621, 0.0584087260067463, 0.0583012998104095, 0.0581937544047832, 0.0580861233174801, 0.0579782202839851, 0.0578701719641685, 0.0577619336545467, 0.0576535686850548, 0.0575450137257576, 0.0574362501502037, 0.0573273226618767, 0.0572182610630989, 0.0571090094745159, 0.056999608874321, 0.0568899884819984, 0.0567802302539349, 0.0566702522337437, 0.0565601736307144, 0.0564499162137508, 0.05633944272995, 0.0562288463115692, 0.0561180226504803, 0.0560071207582951, 0.055895958095789, 0.0557846277952194, 0.0556731633841991, 0.055561475455761, 0.0554497502744198, 0.0553377233445644, 0.0552255287766457, 0.0551131665706635, 0.0550006330013275, 0.0548879653215408, 0.0547751747071743, 0.0546621344983578, 0.054548941552639, 0.0544355474412441, 0.0543220788240433, 0.0542083270847797, 0.054094422608614, 0.053980391472578, 0.0538661330938339, 0.0537518188357353, 0.0536371991038322, 0.0535224750638008, 0.0534075386822224, 0.0532924570143223, 0.0531772784888744, 0.0530618168413639, 0.052946213632822, 0.0528304316103458, 0.0527145601809025, 0.0525984242558479, 0.0524849556386471, 0.0523369647562504, 0.0521894581615925, 0.0520419925451279, 0.051895048469305, 0.0517482571303844, 0.051601730287075, 0.0514552742242813, 0.051309235394001, 0.0511635355651379, 0.0510179772973061, 0.0508728362619877, 0.0507278107106686, 0.0505828931927681, 0.0504383929073811, 0.0502942278981209, 0.0501502119004726, 0.0500064231455326, 0.0498630106449127, 0.0497196689248085, 0.0495769307017326, 0.0494341515004635, 0.0492916032671928, 0.049149464815855, 0.0490076616406441, 0.0488658621907234, 0.0487244725227356, 0.048583347350359, 0.0484423711895943, 0.0483017340302467, 0.0481615103781223, 0.048021212220192, 0.0478813201189041, 0.047741737216711, 0.0476023741066456, 0.0474632382392883, 0.0473245158791542, 0.0471857115626335, 0.0470474772155285, 0.0469094291329384, 0.0467716827988625, 0.0466340817511082, 0.046496819704771, 0.0463597476482391, 0.0462230518460274, 0.0460863932967186, 0.0459500290453434, 0.0458140447735786, 0.0456783659756184, 0.0455427542328835, 0.0454075187444687, 0.0452726930379868, 0.0451378747820854, 0.0450034290552139, 0.0448693186044693, 0.044735174626112, 0.0446016229689121, 0.0444681197404861, 0.0443348363041878, 0.0442020036280155, 0.0440693944692612, 0.0439369343221188, 0.0438047088682652, 0.0436729229986668, 0.0435412153601646, 0.043409887701273, 0.0432786643505096, 0.0431478954851627, 0.0430172011256218, 0.0428868867456913, 0.0427569411695004, 0.0426269620656967, 0.042522918432951, 0.0424315109848976, 0.0423410385847092, 0.0422505363821983, 0.0421609506011009, 0.0420717000961304, 0.0419828668236732, 0.0418949313461781, 0.041807234287262, 0.0417198799550533, 0.041633203625679, 0.0415473282337189, 0.0414613448083401, 0.0413765050470829, 0.0412918329238892, 0.0412077270448208, 0.0411241799592972, 0.0410413816571236, 0.040958721190691, 0.0408766195178032, 0.0407951772212982, 0.0407140478491783, 0.0406339205801487, 0.0405538082122803, 0.0404743887484074, 0.0403953082859516, 0.0403172038495541, 0.0402391143143177, 0.0401617251336575, 0.0400848016142845, 0.0400082916021347, 0.0399325676262379, 0.0398574806749821, 0.0397826284170151, 0.0397081039845943, 0.039634745568037, 0.0395612195134163, 0.0394883677363396, 0.0394163653254509, 0.0393443927168846, 0.0392732247710228, 0.0392027013003826, 0.0391324199736118, 0.0390626303851604, 0.0389938093721867, 0.0389248766005039, 0.0388568826019764, 0.0387893058359623, 0.0387220270931721, 0.0386554636061192, 0.0385894924402237, 0.038523904979229, 0.038458839058876, 0.0383944064378738, 0.0383303761482239, 0.0382668115198612, 0.0382040925323963, 0.0381413884460926, 0.038079347461462, 0.0380181446671486, 0.0379571132361889, 0.0378966294229031, 0.0378370545804501, 0.0377773977816105, 0.0377185791730881, 0.0376603975892067, 0.0376024432480335, 0.037544958293438, 0.0374884828925133, 0.0374320112168789, 0.0373760648071766, 0.0373168177902699, 0.0372614301741123, 0.0372058413922787, 0.0371499694883823, 0.0370937958359718, 0.0370373576879501, 0.0369806066155434, 0.0369235724210739, 0.0368662364780903, 0.036808654665947, 0.0367507748305798, 0.0366926118731499, 0.0366340950131416, 0.0365752801299095, 0.0365163683891296, 0.0364570431411266, 0.0363974571228027, 0.0363375134766102, 0.0362773463129997, 0.0362168960273266, 0.036155991256237, 0.0360949411988258, 0.0360336303710938, 0.0359720885753632, 0.0359103120863438, 0.0358481332659721, 0.0357856191694736, 0.0357228815555573, 0.0356598235666752, 0.0355964079499245, 0.0355328060686588, 0.0354689434170723, 0.0354047752916813, 0.0353403873741627, 0.0352756567299366, 0.0352106690406799, 0.0351451896131039, 0.0350795798003674, 0.0350136160850525, 0.0349475368857384, 0.0348810255527496, 0.034814290702343, 0.0347473658621311, 0.0346800312399864, 0.0346123576164246, 0.0345444604754448, 0.0344762988388538, 0.0344077832996845, 0.034339040517807, 0.0342699587345123, 0.0342006534337997, 0.0341311022639275, 0.0340612158179283, 0.0339909717440605, 0.0339205414056778, 0.0338498279452324, 0.0337787754833698, 0.0337073914706707, 0.0336357764899731, 0.033563956618309, 0.0334917791187763, 0.0334193594753742, 0.0333465076982975, 0.0332735255360603, 0.0332001112401485, 0.0331265293061733, 0.0330526232719421, 0.0329785160720348, 0.0329040139913559, 0.0328292325139046, 0.0327542573213577, 0.0326789282262325, 0.0325734615325928, 0.0324577391147614, 0.032341942191124, 0.0322262942790985, 0.0321105718612671, 0.0319947749376297, 0.0318792797625065, 0.031763706356287, 0.0316484346985817, 0.0315327867865562, 0.031417440623045, 0.0313020199537277, 0.0311866719275713, 0.031071474775672, 0.0309562794864178, 0.0308411568403244, 0.0307259596884251, 0.0306108389049768, 0.0304954890161753, 0.0303808208554983, 0.030265849083662, 0.0301508754491806, 0.0300359055399895, 0.0299211572855711, 0.0298063363879919, 0.0296915173530579, 0.0295766163617373, 0.0294619482010603, 0.0293475016951561, 0.0292330551892519, 0.0291185323148966, 0.0290039349347353, 0.0288894902914762, 0.0287751164287329, 0.0286605972796679, 0.0285463761538267, 0.0284320041537285, 0.0283178593963385, 0.0282036364078522, 0.028089564293623, 0.0279752686619759, 0.0278612729161978, 0.0277471281588078, 0.0276330560445786, 0.0275192093104124, 0.0274053644388914, 0.0272914431989193, 0.0271776728332043, 0.0270639024674892, 0.0269501302391291, 0.0268362853676081, 0.0267228148877621, 0.0266091916710138, 0.0264955721795559, 0.0263820253312588, 0.0262686312198639, 0.0261551588773727, 0.0260419137775898, 0.0259283687919378, 0.0258152727037668, 0.0257017277181149, 0.0255887806415558, 0.0254755355417728, 0.025362515822053, 0.02524927072227, 0.0251364726573229, 0.0250231511890888, 0.0249104332178831, 0.0247974134981632, 0.0246845427900553, 0.0245715975761414, 0.0244606826454401, 0.0243725776672363, 0.0242852233350277, 0.0241987705230713, 0.024113217368722, 0.0240282639861107, 0.0239445120096207, 0.0238615106791258, 0.023778960108757, 0.0236977580934763, 0.0236171577125788, 0.0235373098403215, 0.0234582126140594, 0.0233804620802402, 0.0233027134090662, 0.0232264660298824, 0.0231506712734699, 0.0230759214609861, 0.0230017770081758, 0.0229289811104536, 0.0228563360869884, 0.0227848906069994, 0.0227140467613935, 0.0226445570588112, 0.0225750617682934, 0.0225072205066681, 0.0224396791309118, 0.0223731864243746, 0.0223074462264776, 0.0222427565604448, 0.0221783649176359, 0.0221154782921076, 0.0220530387014151, 0.0219913478940725, 0.0219304114580154, 0.0218709744513035, 0.0218113884329796, 0.0217533018440008, 0.0216959659010172, 0.0216393806040287, 0.0215833969414234, 0.0215289127081633, 0.0214742794632912, 0.0214212965220213, 0.0213687624782324, 0.0213171318173409, 0.0212662518024445, 0.021216569468379, 0.0211673378944397, 0.0211188588291407, 0.0210717301815748, 0.0210248995572329, 0.0209791194647551, 0.0209342446178198, 0.0208898149430752, 0.0208465903997421, 0.0208042617887259, 0.0207622367888689, 0.0207215622067451, 0.0206814855337143, 0.0206423122435808, 0.0206038877367973, 0.020566513761878, 0.0205294415354729, 0.0204937197268009, 0.0204587485641241, 0.0204245261847973, 0.0203910563141108, 0.0203587859869003, 0.020326666533947, 0.020295899361372, 0.0202658791095018, 0.0202515926212072, 0.020240094512701, 0.0202290508896112, 0.0202184692025185, 0.0202080551534891, 0.0201984085142612, 0.0201890729367733, 0.0201801992952824, 0.020171795040369, 0.0201640073210001, 0.0201562363654375, 0.0201493743807077, 0.020142825320363, 0.0201365891844034, 0.0201309751719236, 0.0201259683817625, 0.0201209764927626, 0.020116901025176, 0.0201129987835884, 0.0201095584779978, 0.0201067291200161, 0.0201043616980314, 0.0201021563261747, 0.0201007258147001, 0.0200997516512871, 0.0200989376753569, 0.0200987458229065, 0.0200993251055479, 0.0200997646898031, 0.0201011095196009, 0.0201027747243643, 0.0201047528535128, 0.0201073475182056, 0.0201105549931526, 0.0201137792319059, 0.0201179143041372, 0.0201223716139793, 0.0201271418482065, 0.0201325248926878, 0.0201383698731661, 0.0201443769037724, 0.0201513022184372, 0.0201583933085203, 0.0201659444719553, 0.0201739612966776, 0.0201827567070723, 0.0201914068311453, 0.0202009696513414, 0.0202109925448895, 0.0202211793512106, 0.0202319882810116, 0.0202434100210667, 0.0202548410743475, 0.0202672034502029, 0.0202798675745726, 0.0202928390353918, 0.0203064363449812, 0.0203206446021795, 0.0203351657837629, 0.0203498508781195, 0.0203653052449226, 0.0203810706734657, 0.0203973073512316, 0.0204143021255732, 0.0204314645379782, 0.0204490907490253, 0.0204671770334244, 0.0204858761280775, 0.0205047465860844, 0.0205243863165379, 0.0205443296581507, 0.0205642059445381, 0.0205752514302731, 0.0205861981958151, 0.0205969735980034, 0.0206076093018055, 0.020618187263608, 0.0206285137683153, 0.0206387396901846, 0.0206488762050867, 0.0206588078290224, 0.0206685923039913, 0.0206782408058643, 0.0206877179443836, 0.020697133615613, 0.0207063406705856, 0.0207154061645269, 0.0207243375480175, 0.0207331776618958, 0.0207418464124203, 0.0207503698766232, 0.0207587219774723, 0.0207669362425804, 0.0207750219851732, 0.0207829233258963, 0.0207907725125551, 0.020798409357667, 0.0208059549331665, 0.0208133198320866, 0.0208205468952656, 0.0208276379853487, 0.0208345577120781, 0.0208413433283567, 0.0208479911088943, 0.0208545010536909, 0.0208608377724886, 0.0208670552819967, 0.0208731926977634, 0.0208790861070156, 0.0208849553018808, 0.0208905749022961, 0.0208961050957441, 0.0209014508873224, 0.02090666256845, 0.0209117047488689, 0.0209166537970304, 0.0209214650094509, 0.0209261383861303, 0.0209305975586176, 0.0209350325167179, 0.0209392625838518, 0.0209433138370514, 0.0209472309798002, 0.0209510866552591, 0.0209547020494938, 0.0209582149982452, 0.0209615509957075, 0.0209647882729769, 0.0209679249674082, 0.0209708232432604, 0.0209736507385969, 0.0209763087332249, 0.0209787916392088, 0.0209811478853226, 0.0209833607077599, 0.0209854394197464, 0.0209874138236046, 0.0209892559796572, 0.0209908857941628, 0.0209923144429922, 0.020993746817112, 0.0209950152784586, 0.0209920294582844, 0.0209852736443281, 0.0209781844168901, 0.0209708288311958, 0.0209632478654385, 0.0209553670138121, 0.0209472253918648, 0.0209388583898544, 0.020930077880621, 0.0209211502224207, 0.020911917090416, 0.0209023859351873, 0.0208927039057016, 0.020882610231638, 0.0208722166717052, 0.0208616349846125, 0.0208508670330048, 0.0208396483212709, 0.0208282396197319, 0.020816532894969, 0.0208046734333038, 0.020792406052351, 0.02077991142869, 0.0207671895623207, 0.0207541324198246, 0.0207408480346203, 0.020727226510644, 0.0207134187221527, 0.0206992737948895, 0.0206848625093699, 0.0206702314317226, 0.020655294880271, 0.0206400211900473, 0.0206245258450508, 0.0206088423728943, 0.0205928571522236, 0.0205764565616846, 0.0205599498003721, 0.0205431375652552, 0.0205259881913662, 0.0205086525529623, 0.0204909425228834, 0.0204731188714504, 0.0204548463225365, 0.0204363446682692, 0.0204176977276802, 0.0203986745327711, 0.0203793868422508, 0.0203598365187645, 0.0203400626778603, 0.0203199498355389, 0.0202995743602514, 0.0202789362519979, 0.0202580355107784, 0.0202367976307869, 0.0202153343707323, 0.0201936848461628, 0.0201716590672731, 0.0201494060456753, 0.0201269295066595, 0.0201040413230658, 0.0200809240341187, 0.0200575869530439, 0.020033985376358, 0.0200100801885128, 0.0199859198182821, 0.0199614893645048, 0.0199367608875036, 0.0199118088930845, 0.0198865178972483, 0.019860964268446, 0.0198352262377739, 0.0198100097477436, 0.0197774022817612, 0.0197447538375854, 0.0197121109813452, 0.0196793898940086, 0.0196467060595751, 0.0196140985935926, 0.0195814166218042, 0.0195487719029188, 0.0195160526782274, 0.0194834433495998, 0.0194507967680693, 0.0194181147962809, 0.0193854682147503, 0.019352788105607, 0.0193201415240765, 0.0192874576896429, 0.0192548874765635, 0.0192221663892269, 0.0191894490271807, 0.0191568769514561, 0.0191242303699255, 0.0190915111452341, 0.0190588273108006, 0.0190262589603662, 0.0189935360103846, 0.0189608540385962, 0.0189281720668077, 0.0188956037163734, 0.0188628435134888, 0.0188302751630545, 0.0187975913286209, 0.0187649093568325, 0.0187323018908501, 0.0186995808035135, 0.0186669379472733, 0.0186342522501945, 0.0186016093939543, 0.0185688883066177, 0.0185363162308931, 0.0185036342591047, 0.0184709522873163, 0.0184383075684309, 0.0184056609869003, 0.0183729398995638, 0.0183402951806784, 0.0183077249675989, 0.0182750038802624, 0.018242321908474, 0.0182096399366856, 0.0181770697236061, 0.0181443486362696, 0.018111702054739, 0.0180790219455957, 0.0180463753640652, 0.0180137678980827, 0.0179810095578432, 0.0179484393447638, 0.0179156828671694, 0.0178830362856388, 0.0178504288196564, 0.0178178213536739, 0.0177850257605314, 0.017752381041646, 0.0177198108285666, 0.017687126994133, 0.0176545195281506, 0.0176217257976532, 0.0175891537219286, 0.0175564344972372, 0.0175238270312548, 0.0174984466284513, 0.0174791496247053, 0.0174598526209593, 0.0174407344311476, 0.0174217484891415, 0.0174026675522327, 0.0173838026821613, 0.0173649191856384, 0.0173462126404047, 0.0173276104032993, 0.0173090472817421, 0.0172905195504427, 0.0172721613198519, 0.017253877595067, 0.0172356404364109, 0.0172175448387861, 0.0171994771808386, 0.0171815417706966, 0.0171636696904898, 0.0171459130942822, 0.017128137871623, 0.0171105302870274, 0.0170930624008179, 0.0170755852013826, 0.0170582495629787, 0.0170409511774778, 0.0170237552374601, 0.0170066356658936, 0.0169896855950356, 0.0169726964086294, 0.0169558674097061, 0.0169391315430403, 0.0169224236160517, 0.0169058199971914, 0.0168893579393625, 0.0168729592114687, 0.0168565604835749, 0.0168403498828411, 0.0168242063373327, 0.0168081447482109, 0.0167921427637339, 0.0167762525379658, 0.0167603883892298, 0.0167447235435247, 0.0167291034013033, 0.0167134739458561, 0.0166980344802141, 0.016682593151927, 0.0166673976927996, 0.0166521053761244, 0.0166370011866093, 0.0166219174861908, 0.0166070032864809, 0.0165921896696091, 0.0165773313492537, 0.0165626388043165, 0.0165480077266693, 0.016533512622118, 0.0165190473198891, 0.0165047217160463, 0.0164903905242682, 0.0164761953055859, 0.0164621621370316, 0.0164481569081545, 0.0164342448115349, 0.0164203327149153, 0.0164066180586815, 0.0163928754627705, 0.0163793675601482, 0.0163658019155264, 0.0163524243980646, 0.0163390468806028, 0.0163195729255676, 0.0163050126284361, 0.0162903238087893, 0.0162755195051432, 0.0162604730576277, 0.0162452571094036, 0.0162299200892448, 0.0162143390625715, 0.0161986723542213, 0.0161827635020018, 0.0161666944622993, 0.0161505397409201, 0.0161341149359941, 0.0161175280809402, 0.0161007829010487, 0.0160838887095451, 0.0160668063908815, 0.0160495173186064, 0.0160321537405252, 0.0160145275294781, 0.0159967411309481, 0.0159788336604834, 0.0159606896340847, 0.0159424636512995, 0.015923984348774, 0.0159053541719913, 0.0158865824341774, 0.0158675480633974, 0.0158483926206827, 0.0158291347324848, 0.0158096700906754, 0.0157899782061577, 0.0157701671123505, 0.0157501865178347, 0.0157300271093845, 0.0157096404582262, 0.0156892091035843, 0.0156684685498476, 0.0156476702541113, 0.0156266111880541, 0.015605409629643, 0.0155840031802654, 0.0155624365434051, 0.0155407581478357, 0.0155188906937838, 0.0154967801645398, 0.0154746333137155, 0.0154521754011512, 0.0154296699911356, 0.0154069131240249, 0.0153839951381087, 0.0153609467670321, 0.0153376730158925, 0.0153142679482698, 0.0152905443683267, 0.0152668096125126, 0.0152428792789578, 0.0152187701314688, 0.0151944840326905, 0.0151700926944613, 0.0151453837752342, 0.0151206273585558, 0.0150956474244595, 0.0150705352425575, 0.0150452340021729, 0.0150197194889188, 0.0149940717965364, 0.0149682657793164, 0.0149422716349363, 0.0149160046130419, 0.0148897292092443, 0.0148598235100508, 0.014822956174612, 0.0147860525175929, 0.0147490175440907, 0.0147117935121059, 0.0146744959056377, 0.0146370846778154, 0.0145995616912842, 0.0145619260147214, 0.0145241776481271, 0.0144863529130816, 0.0144483614712954, 0.014410219155252, 0.0143719632178545, 0.0143336718901992, 0.0142952473834157, 0.0142566356807947, 0.0142180435359478, 0.0141792632639408, 0.0141402762383223, 0.0141013460233808, 0.0140621894970536, 0.0140229789540172, 0.0139835989102721, 0.0139440856873989, 0.0139045920222998, 0.0138648552820086, 0.013825005851686, 0.0137850809842348, 0.0137450620532036, 0.0137048931792378, 0.0136646302416921, 0.0136242937296629, 0.0135837122797966, 0.0135430553928018, 0.0135024366900325, 0.0134615544229746, 0.0134206172078848, 0.0133795663714409, 0.013338272459805, 0.0132969776168466, 0.0132557023316622, 0.0132141262292862, 0.0131724001839757, 0.0131306741386652, 0.0130887608975172, 0.0130467908456922, 0.0130046345293522, 0.01296241953969, 0.01292026322335, 0.0128777306526899, 0.0128351785242558, 0.0127925528213382, 0.012749738059938, 0.0127068106085062, 0.0126637360081077, 0.0126207340508699, 0.0125774312764406, 0.0125340912491083, 0.0124905640259385, 0.0124470386654139, 0.012403323315084, 0.0123594217002392, 0.0123154614120722, 0.0122716166079044, 0.012227414175868, 0.0121830981224775, 0.0121387457475066, 0.0120942443609238, 0.0120495716109872, 0.0120047694072127, 0.0119600612670183, 0.0119226099923253, 0.0118839042261243, 0.0118452543392777, 0.0118067003786564, 0.0117681249976158, 0.0117296818643808, 0.0116912415251136, 0.0116528915241361, 0.0116146169602871, 0.0115763628855348, 0.0115381823852658, 0.0115000586956739, 0.011461972258985, 0.0114239230751991, 0.0113860070705414, 0.0113481068983674, 0.0113102458417416, 0.0112724797800183, 0.0112347304821014, 0.0111970193684101, 0.0111594209447503, 0.0111218597739935, 0.0110843749716878, 0.0110469255596399, 0.0110095152631402, 0.010972217656672, 0.0109349377453327, 0.010897696018219, 0.0108605474233627, 0.0108234547078609, 0.0107864374294877, 0.0107494033873081, 0.0107124792411923, 0.0106756314635277, 0.010638820938766, 0.0106020485982299, 0.0105653498321772, 0.0105286706238985, 0.010492105036974, 0.0104555953294039, 0.0104191210120916, 0.010382704436779, 0.010346308350563, 0.0103100035339594, 0.0102737564593554, 0.0102375848218799, 0.0102014858275652, 0.0101654082536697, 0.0101294033229351, 0.0100934002548456, 0.0100574716925621, 0.0100216558203101, 0.00998587626963854, 0.00995015446096659, 0.00991450715810061, 0.00987885985523462, 0.0098432507365942, 0.00980775430798531, 0.0097723500803113, 0.00973696541041136, 0.00970163755118847, 0.00966634694486856, 0.00963111128658056, 0.00959597155451775, 0.00956084858626127, 0.00952582061290741, 0.00949086807668209, 0.00945589691400528, 0.00942099839448929, 0.00938619766384363, 0.00935145001858473, 0.00931032467633486, 0.00927267037332058, 0.00923518370836973, 0.00919777248054743, 0.00916058756411076, 0.00912358891218901, 0.00908674113452435, 0.00904993060976267, 0.00901330728083849, 0.0089768348261714, 0.00894040055572987, 0.00890430249273777, 0.00886824261397123, 0.0088323513045907, 0.00879664719104767, 0.00876092631369829, 0.00872542802244425, 0.00869011878967285, 0.00865495949983597, 0.00861985608935356, 0.00858509074896574, 0.00855015683919191, 0.0085155600681901, 0.00848100055009127, 0.00844677910208702, 0.00841259583830833, 0.00837858114391565, 0.00834460370242596, 0.00831083208322525, 0.0082772858440876, 0.00824383459985256, 0.00821041967719793, 0.00817724876105785, 0.00814419146627188, 0.00811133906245232, 0.00807848758995533, 0.00804587919265032, 0.00801338441669941, 0.007981076836586, 0.00794899463653564, 0.00791687425225973, 0.00788490474224091, 0.00785315874963999, 0.00782152730971575, 0.00779012031853199, 0.00775882508605719, 0.00772753125056624, 0.00769651820883155, 0.00766561739146709, 0.00763481110334396, 0.00760417291894555, 0.00757372239604592, 0.00754340412095189, 0.00751327257603407, 0.00748312240466475, 0.00745325395837426, 0.00742347864434123, 0.00739387329667807, 0.00736437924206257, 0.00733509240671992, 0.00730588100850582, 0.00727683771401644, 0.00724783213809133, 0.00721923960372806, 0.00719051482155919, 0.00716207176446915, 0.00713370507583022, 0.00710552511736751, 0.00707751279696822, 0.00704959547147155, 0.00702182808890939, 0.00699316104874015, 0.00696771964430809, 0.00694272900000215, 0.006917888764292, 0.00689327344298363, 0.00686888350173831, 0.00684479344636202, 0.00682100281119347, 0.00679743848741055, 0.00677409861236811, 0.00675098458305001, 0.00672802003100514, 0.00670573115348816, 0.00668336777016521, 0.00666137877851725, 0.00663954066112638, 0.0066180769354105, 0.00659676315262914, 0.00657590012997389, 0.00655503710731864, 0.00653469981625676, 0.00651443703100085, 0.006494399625808, 0.00647473754361272, 0.00645522540435195, 0.00643601315096021, 0.00641702627763152, 0.00639856467023492, 0.00638002809137106, 0.00636186730116606, 0.00634385598823428, 0.00632629450410604, 0.0063088838942349, 0.00629177363589406, 0.00627488829195499, 0.00625822739675641, 0.00624186685308814, 0.00622580666095018, 0.00620989687740803, 0.00619421293959022, 0.00617897836491466, 0.00616381876170635, 0.00614910945296288, 0.00613447558134794, 0.00611999118700624, 0.00610610749572515, 0.00609214883297682, 0.00607879087328911, 0.00606535701081157, 0.00605252431705594, 0.00603969115763903, 0.00602723332121968, 0.00601492589339614, 0.00600299332290888, 0.00599121069535613, 0.0059797284193337, 0.00596854696050286, 0.00595751497894526, 0.00594670791178942, 0.00593627663329244, 0.00592614524066448, 0.00591623922809958, 0.00590655812993646, 0.00589710241183639, 0.00588802108541131, 0.00587901566177607, 0.0058705355040729, 0.00586205581203103, 0.00585387460887432, 0.00584591971710324, 0.00583834107965231, 0.005830985493958, 0.00583155080676079, 0.00582975847646594, 0.00582807045429945, 0.00582661665976048, 0.0058251996524632, 0.00582419615238905, 0.0058231451548636, 0.00582241360098124, 0.00582163501530886, 0.00582112837582827, 0.00582094071432948, 0.00582068786025047, 0.00582086574286222, 0.00582097796723247, 0.00582143804058433, 0.00582190696150064, 0.00582272373139858, 0.00582354888319969, 0.00582455238327384, 0.00582584738731384, 0.00582728208974004, 0.00582889560610056, 0.00583054730668664, 0.00583262974396348, 0.00583462743088603, 0.00583696365356445, 0.00583933666348457, 0.00584203843027353, 0.0058447583578527, 0.00584766687825322, 0.00585081893950701, 0.00585408322513103, 0.00585759151726961, 0.00586121249943972, 0.00586507795378566, 0.00586905516684055, 0.00587329547852278, 0.00587755395099521, 0.00588205689564347, 0.00588667253032327, 0.00589164393022656, 0.00589659763500094, 0.00590166263282299, 0.0059070847928524, 0.00591258192434907, 0.00591836031526327, 0.00592413917183876, 0.00593027425929904, 0.00593640888109803, 0.00594288250431418, 0.00594941107556224, 0.00595622137188911, 0.00596301397308707, 0.00597012415528297, 0.00597736658528447, 0.00598468305543065, 0.00599231896921992, 0.00600001076236367, 0.0060080224648118, 0.00601605279371142, 0.00602443888783455, 0.00603275094181299, 0.00604149326682091, 0.00605023605749011, 0.00605916697531939, 0.00606834189966321, 0.00607757223770022, 0.00608712155371904, 0.00609669042751193, 0.00610657734796405, 0.00611650245264173, 0.0061252829618752, 0.00613344414159656, 0.00614158716052771, 0.00614978605881333, 0.00615794723853469, 0.00616612751036882, 0.00617430685088038, 0.00618246896192431, 0.0061905924230814, 0.00619877269491553, 0.00620693387463689, 0.00621509552001953, 0.00622325669974089, 0.00623145513236523, 0.00623963540419936, 0.00624779658392072, 0.00625590141862631, 0.00626408215612173, 0.00627226196229458, 0.00628042314201593, 0.00628860341385007, 0.00629676459357142, 0.00630492577329278, 0.00631308741867542, 0.00632124859839678, 0.00632940977811813, 0.00633759004995227, 0.00634573260322213, 0.00635393150150776, 0.00636207405477762, 0.00637027248740196, 0.00637843413278461, 0.0063865389674902, 0.00639471877366304, 0.00640289951115847, 0.00641109840944409, 0.00641924049705267, 0.00642740214243531, 0.00643558194860816, 0.0064437435939908, 0.00645188568159938, 0.00646006595343351, 0.0064681894145906, 0.00647636968642473, 0.00648456858471036, 0.00649274885654449, 0.00650089094415307, 0.00650905258953571, 0.00651721376925707, 0.00652535678818822, 0.00653353612869978, 0.00654171733185649, 0.00654989667236805, 0.0065580396912992, 0.00656621949747205, 0.0065743993036449, 0.00658252323046327, 0.00659068441018462, 0.00659886468201876, 0.00660702539607882, 0.00661518750712276, 0.0066233859397471, 0.00663154758512974, 0.00663968967273831, 0.00664786994457245, 0.0066560311242938, 0.00666415505111217, 0.00667233485728502, 0.00668053328990936, 0.00668871449306607, 0.00669687520712614, 0.00670501822605729, 0.00671136006712914, 0.00671738246455789, 0.00672336760908365, 0.00672933319583535, 0.00673520611599088, 0.00674104038625956, 0.00674681970849633, 0.00675252312794328, 0.00675818882882595, 0.0067637050524354, 0.00676923943683505, 0.00677475612610579, 0.00678019691258669, 0.00678556226193905, 0.00679087173193693, 0.00679612578824162, 0.00680132256820798, 0.00680644391104579, 0.0068115284666419, 0.00681651942431927, 0.00682149128988385, 0.00682640727609396, 0.00683126598596573, 0.00683606928214431, 0.00684079667553306, 0.00684544956311584, 0.00685008382424712, 0.00685464264824986, 0.00685914559289813, 0.00686361128464341, 0.00686800107359886, 0.00687235407531261, 0.00687663210555911, 0.00688081607222557, 0.00688499957323074, 0.00688912672922015, 0.00689317937940359, 0.00689713843166828, 0.00690107839182019, 0.00690496200695634, 0.00690878881141543, 0.00691252341493964, 0.00691627571359277, 0.00691991532221437, 0.00692351767793298, 0.00692704459652305, 0.00693053426221013, 0.00693394895642996, 0.00693732593208551, 0.00694057159125805, 0.00694385496899486, 0.00694704428315163, 0.0069501968100667, 0.00695329206064343, 0.0069563128054142, 0.00695927767083049, 0.00696220435202122, 0.00696498109027743, 0.00696777598932385, 0.00697053410112858, 0.00697319861501455, 0.00697586266323924, 0.00697841355577111, 0.00698092766106129, 0.00698336726054549, 0.00698573095723987, 0.00698807602748275, 0.00699036521837115, 0.00699257897213101, 0.00699473638087511, 0.00699687516316772, 0.00699863722547889, 0.00699963187798858, 0.00700060743838549, 0.00700152711942792, 0.00700244633480906, 0.00700330967083573, 0.00700417254120111, 0.00700499769300222, 0.00700580468401313, 0.00700657349079847, 0.0070073246024549, 0.00700803752988577, 0.00700873183086514, 0.00700936885550618, 0.00700996955856681, 0.00701057026162744, 0.00701113324612379, 0.00701167713850737, 0.00701220240443945, 0.00701268995180726, 0.00701314024627209, 0.00701357191428542, 0.0070139653980732, 0.00701434165239334, 0.00701464153826237, 0.00701496005058289, 0.00701524131000042, 0.00701550394296646, 0.00701572978869081, 0.0070159356109798, 0.00701610464602709, 0.00701623596251011, 0.00701634818688035, 0.0070164049975574, 0.00701646134257317, 0.00701647950336337, 0.00701647950336337, 0.00701646134257317, 0.0070164049975574, 0.00701631093397737, 0.00701619824394584, 0.00701602967455983, 0.00701586110517383, 0.00701565435156226, 0.007015410810709, 0.00701516680419445, 0.00701488554477692, 0.00701456610113382, 0.00701420987024903, 0.00701385317370296, 0.00701345922425389, 0.00701298983767629, 0.00701252184808254, 0.00701203336939216, 0.00701152719557285, 0.00701098330318928, 0.00701042031869292, 0.00700980052351952, 0.00700918212532997, 0.00700852461159229, 0.0070078494027257, 0.00700711784884334, 0.00700632994994521, 0.00700556067749858, 0.00700477231293917, 0.00700394716113806, 0.00700308382511139, 0.0070022027939558, 0.00700128264725208, 0.00700034480541945, 0.00699936924502254, 0.00699835596606135, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699824374169111, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00699916481971741, 0.00700011989101768, 0.00700409710407257, 0.0070079998113215, 0.00701175164431334, 0.00701550394296646, 0.00701895635575056, 0.00702255917713046, 0.00702586071565747, 0.00702901277691126, 0.00703216483816504, 0.00703509151935577, 0.00703801866620779, 0.00704071996733546, 0.00704334629699588, 0.00704589765518904, 0.00704829953610897, 0.00705077592283487, 0.00705287698656321, 0.00705490401014686, 0.00705692963674664, 0.00705873081460595, 0.007060457020998, 0.00706203281879425, 0.00706353411078453, 0.00706495996564627, 0.00706631084904075, 0.00706743681803346, 0.00706848688423634, 0.00706946244463325, 0.00707021309062839, 0.00707088829949498, 0.00707148900255561, 0.00707193929702044, 0.00707231462001801, 0.00707246456295252, 0.00707276491448283, 0.00707276491448283, 0.00707268947735429, 0.00707238912582397, 0.00707208923995495, 0.00707163941115141, 0.00707103870809078, 0.00707036349922419, 0.00706953788176179, 0.00706871272996068, 0.00706766126677394, 0.00706668570637703, 0.00706533528864384, 0.00706398393958807, 0.00706255855038762, 0.00706098228693008, 0.00705918110907078, 0.00705738039687276, 0.00705542927607894, 0.00705340271815658, 0.0070512262172997, 0.00704905018210411, 0.00704664876684546, 0.00704417238011956, 0.00704154558479786, 0.00703876884654164, 0.00703591713681817, 0.00703299045562744, 0.00702991336584091, 0.00702668633311987, 0.00702353473752737, 0.00702008232474327, 0.00701662991195917, 0.0070129525847733, 0.00700912531465292, 0.00700522307306528, 0.0070012453943491, 0.00699223997071385, 0.00698375981301069, 0.00697520421817899, 0.006966273766011, 0.00695741875097156, 0.00694803753867745, 0.00693835597485304, 0.00692852586507797, 0.00691854394972324, 0.00690818764269352, 0.00689760642126203, 0.00688694976270199, 0.00687599275261164, 0.00686488579958677, 0.0068536289036274, 0.00684199668467045, 0.00683013908565044, 0.00681798160076141, 0.00680559920147061, 0.00679306639358401, 0.00678030820563436, 0.00676725059747696, 0.00675411708652973, 0.00674075912684202, 0.00672710034996271, 0.00671306625008583, 0.00669895764440298, 0.00668454868718982, 0.00666991481557488, 0.00665505556389689, 0.00663997093215585, 0.00662481226027012, 0.00660927686840296, 0.00659359293058515, 0.00657753273844719, 0.00656147254630923, 0.00654496205970645, 0.0065282266587019, 0.00651134131476283, 0.006494231056422, 0.00647689495235682, 0.00645925896242261, 0.00644154800102115, 0.00642353715375066, 0.00640537589788437, 0.00638683931902051, 0.00636800285428762, 0.00634909048676491, 0.00632987869903445, 0.00631059147417545, 0.00629092939198017, 0.00627104239538312, 0.00625093001872301, 0.00623059272766113, 0.00621010456234217, 0.00618939148262143, 0.00616837898269296, 0.00614721514284611, 0.00612560147419572, 0.00610398827120662, 0.0060820747166872, 0.00605993624776602, 0.00603749742731452, 0.00601498316973448, 0.0059921694919467, 0.00596905453130603, 0.00594564015045762, 0.00592222576960921, 0.00589836062863469, 0.00587464589625597, 0.0058503313921392, 0.00582183012738824, 0.00578910997137427, 0.00575653975829482, 0.00572381867095828, 0.0056910989806056, 0.00565837789326906, 0.00562580861151218, 0.00559323746711016, 0.00556051731109619, 0.00552779715508223, 0.00549522694200277, 0.00546250632032752, 0.00542978569865227, 0.0053972159512341, 0.00536449486389756, 0.00533177517354488, 0.00529920449480414, 0.0052666338160634, 0.00523391366004944, 0.00520119303837419, 0.00516862282529473, 0.00513590220361948, 0.00510318204760551, 0.00507046189159155, 0.00503789074718952, 0.00500517105683684, 0.0049726003780961, 0.00494003063067794, 0.00490731000900269, 0.00487458938732743, 0.00484186923131347, 0.00480929901823401, 0.00477657839655876, 0.0047438582405448, 0.00471128802746534, 0.0046787173487246, 0.00464599719271064, 0.00461327657103539, 0.00458070635795593, 0.00454798620194197, 0.00451526558026671, 0.00448269536718726, 0.00444997474551201, 0.00441725412383676, 0.0043846839107573, 0.00435211369767785, 0.00431939354166389, 0.00428667338564992, 0.00425410270690918, 0.00422138208523393, 0.00418866146355867, 0.00415594130754471, 0.00412337109446526, 0.00409065093845129, 0.00405808072537184, 0.00402536010369658, 0.00399278989061713, 0.00396006926894188, 0.00392734911292791, 0.00389477866701782, 0.00386205827817321, 0.0038293378893286, 0.00379661750048399, 0.00376419723033905, 0.00373147684149444, 0.00369875621981919, 0.00366618600673974, 0.00363346561789513, 0.00360074522905052, 0.00356802507303655, 0.0035354548599571, 0.00350273423828185, 0.00347825884819031, 0.00345416902564466, 0.00343015417456627, 0.00340628926642239, 0.00338279944844544, 0.00335961021482944, 0.00333649595268071, 0.00331368180923164, 0.00329109258018434, 0.00326865375973284, 0.00324651505798101, 0.00322460127063096, 0.00320298806764185, 0.00318144960328937, 0.00316028669476509, 0.00313934870064259, 0.00311848567798734, 0.00309799797832966, 0.00307758501730859, 0.00305754761211574, 0.00303758541122079, 0.00301807327196002, 0.00299863610416651, 0.00297949928790331, 0.00296058785170317, 0.00294167594984174, 0.00292328931391239, 0.00290497811511159, 0.00288704177364707, 0.00286918086931109, 0.00285169505514205, 0.00283428421244025, 0.00281709851697087, 0.00280028814449906, 0.00278370291925967, 0.00276719243265688, 0.0027509075589478, 0.002734997542575, 0.00271931290626526, 0.00270370324142277, 0.00268854387104511, 0.00267345923930407, 0.00265867519192398, 0.00264396611601114, 0.00262955692596734, 0.00261552329175174, 0.00260148965753615, 0.00258790608495474, 0.00257447292096913, 0.00256118969991803, 0.00254820636473596, 0.00253559881821275, 0.00252299080602825, 0.00251053320243955, 0.00249867606908083, 0.00248666852712631, 0.00247496133670211, 0.00246347906067967, 0.00245259725488722, 0.00244156527332962, 0.00243075867183506, 0.00242017698474228, 0.00241004582494497, 0.00240006484091282, 0.00239015836268663, 0.00238070264458656, 0.00237124692648649, 0.00236216629855335, 0.00235338578931987, 0.00234468025155365, 0.00233612488955259, 0.00233147200196981, 0.00232749455608428, 0.00232351711019874, 0.00231968984007835, 0.00231616268865764, 0.00231263530440629, 0.00230918335728347, 0.00230595632456243, 0.00230272929184139, 0.0022996524348855, 0.00229665054939687, 0.00229387381114066, 0.00229109707288444, 0.00228847051039338, 0.00228606886230409, 0.00228366744704545, 0.0022813412360847, 0.00227923970669508, 0.002277213614434, 0.00227526226080954, 0.00227338611148298, 0.00227173510938883, 0.00227015907876194, 0.00226865848526359, 0.00226738234050572, 0.00226610666140914, 0.00226498092524707, 0.00226385542191565, 0.00226310477592051, 0.0022622044198215, 0.00226152874529362, 0.00226107868365943, 0.00226062838919461, 0.00226017809472978, 0.00226010289043188, 0.00226002791896462, 0.00225995271466672, 0.00226017809472978, 0.00226032803766429, 0.00226070336066186, 0.00226115365512669, 0.00226182909682393, 0.00226250453852117, 0.00226325495168567, 0.00226415554061532, 0.00226528127677739, 0.00226640678010881, 0.00226760772056878, 0.00226918351836503, 0.00227060960605741, 0.00227218540385365, 0.00227398658171296, 0.00227586273103952, 0.00227773888036609, 0.00227991538122296, 0.0022820164449513, 0.00228426791727543, 0.00228666933253407, 0.00228929612785578, 0.00229192245751619, 0.0022945492528379, 0.00229762634262443, 0.00230055302381516, 0.00230355490930378, 0.00230678170919418, 0.00231023388914764, 0.00231361109763384, 0.00231713824905455, 0.00232089054770768, 0.0023246428463608, 0.00232854532077909, 0.00233259797096252, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233305478468537, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233320472761989, 0.00233346759341657, 0.00233549391850829, 0.00233744503930211, 0.0023393586743623, 0.00234112236648798, 0.00234288582578301, 0.00234464928507805, 0.00234630052000284, 0.00234795152209699, 0.00234949006699026, 0.00235099066048861, 0.00235245423391461, 0.00235384283587337, 0.00235511851496994, 0.0023563567083329, 0.00235755741596222, 0.00235872063785791, 0.00235984660685062, 0.00236085965298116, 0.0023618726991117, 0.00236281077377498, 0.00236367387697101, 0.00236446177586913, 0.00236521218903363, 0.00236585037782788, 0.00236652581952512, 0.00236712605692446, 0.00236761383712292, 0.00236810161732137, 0.00236851419322193, 0.00236888974905014, 0.00236918986774981, 0.00236941478215158, 0.00236952770501375, 0.00236967764794827, 0.00236975261941552, 0.00236975261941552, 0.00236971513368189, 0.00236960244365036, 0.00236945250071585, 0.00236926483921707, 0.0023689647205174, 0.00236858939751983, 0.00236821407452226, 0.00236776401288807, 0.00236727623268962, 0.00236667576245964, 0.00236607529222965, 0.00236543733626604, 0.00236468692310154, 0.00236389879137278, 0.00236307340674102, 0.00236209784634411, 0.00236115977168083, 0.00236014649271965, 0.00235902075655758, 0.00235793273895979, 0.00235673203133047, 0.0023555310908705, 0.00235418067313731, 0.00235282955691218, 0.00235136621631682, 0.00234990287572145, 0.00234836433082819, 0.00234675081446767, 0.0023451370652765, 0.00234344881027937, 0.00234168535098433, 0.00233988394029438, 0.00233797030523419, 0.00233605643734336, 0.00233403034508228, 0.00233094673603773, 0.00232670665718615, 0.0023224288597703, 0.00231800111941993, 0.00231346092186868, 0.0023088080342859, 0.00230400497093797, 0.0022991644218564, 0.00229409872554243, 0.00228892057202756, 0.00228366744704545, 0.0022783016320318, 0.00227286061272025, 0.00226730736903846, 0.00226160371676087, 0.0022557876072824, 0.00224989652633667, 0.00224381755106151, 0.00223766383714974, 0.00223139743320644, 0.00222501833923161, 0.00221848930232227, 0.00221188552677631, 0.00220516882836819, 0.0021983019541949, 0.00219139759428799, 0.00218434329144657, 0.00217710132710636, 0.00216982187703252, 0.00216239225119352, 0.00215492490679026, 0.00214719516225159, 0.00213942769914865, 0.00213162298314273, 0.00212363060563803, 0.00211552553810179, 0.00210730801336467, 0.00209894008003175, 0.00209053489379585, 0.00208197976462543, 0.00207331171259284, 0.00206453143619001, 0.00205560098402202, 0.00204655760899186, 0.00203747698105872, 0.00202820869162679, 0.00201882794499397, 0.0020093722268939, 0.0019998038187623, 0.00199008523486555, 0.00198032916523516, 0.00197042291983962, 0.00196036673150957, 0.00195023545529693, 0.00193987903185189, 0.00192944752052426, 0.00191901600919664, 0.00190839706920087, 0.00189762783702463, 0.00188682100269943, 0.00187586410902441, 0.00186483247671276, 0.00185365055222064, 0.00184239342343062, 0.00183091138023883, 0.00181935424916446, 0.00180764694232494, 0.00179593963548541, 0.00178408226929605, 0.00177214981522411, 0.00176006753463298, 0.00174479535780847, 0.00172843527980149, 0.00171215017326176, 0.00169579009525478, 0.00167942990083247, 0.00166310730855912, 0.00164678448345512, 0.00163042452186346, 0.00161413941532373, 0.00159777910448611, 0.0015814941143617, 0.00156513380352408, 0.00154884869698435, 0.00153245101682842, 0.00151609093882143, 0.00149976811371744, 0.00148352060932666, 0.0014670854434371, 0.00145080033689737, 0.0014344776282087, 0.00141819252166897, 0.00140179495792836, 0.00138550985138863, 0.00136914965696633, 0.00135290215257555, 0.0013365043560043, 0.00132010667584836, 0.00130378408357501, 0.00128749897703528, 0.00127117626834661, 0.00125485367607325, 0.00123849348165095, 0.00122220837511122, 0.00120584818068892, 0.00118956307414919, 0.00117316539399326, 0.00115688028745353, 0.00114044512156397, 0.00112415989860892, 0.00110779982060194, 0.00109151471406221, 0.00107515463605523, 0.0010588695295155, 0.00104247184935957, 0.00102626183070242, 0.00100993912201375, 0.000993616529740393, 0.00097721884958446, 0.000960821169428527, 0.000944573548622429, 0.000928250898141414, 0.00091192836407572, 0.000895530683919787, 0.000879245577380061, 0.000862922985106707, 0.00084663787856698, 0.000830277684144676, 0.00081395503366366, 0.000797594897449017, 0.000781272305175662, 0.000764912110753357, 0.000748589576687664, 0.000732229382265359, 0.000715944275725633, 0.000699584081303328, 0.000683299032971263, 0.000666938896756619, 0.000650653732009232, 0.000634293654002249, 0.000617895973846316, 0.000601535779424012, 0.000585288275033236, 0.0005714813596569, 0.000559361244086176, 0.000547428848221898, 0.000535533938091248, 0.000523751601576805, 0.000512119324412197, 0.000500599679071456, 0.000489192549139261, 0.000477897992823273, 0.000466678466182202, 0.000455646601039916, 0.00044465227983892, 0.000433845561929047, 0.000423076300648972, 0.000412457215134054, 0.000401988159865141, 0.000391594192478806, 0.000381350284442306, 0.000371143949450925, 0.000361125188646838, 0.000351181486621499, 0.000341350329108536, 0.000331594288581982, 0.000322100822813809, 0.000312569900415838, 0.00030326412525028, 0.000293920777039602, 0.000284877663943917, 0.000275796977803111, 0.000266941438894719, 0.000258160987868905, 0.000249493081355467, 0.000240975263295695, 0.000232494974625297, 0.000224164774408564, 0.000215947147808038, 0.000207879638765007, 0.000199924659682438, 0.000192007239093073, 0.000184239892405458, 0.000176585104782134, 0.000169117949553765, 0.00016168832371477, 0.000154371271491982, 0.00014716676378157, 0.000140112373628654, 0.000133170542540029, 0.000126303755678236, 0.000119587071822025, 0.000112982947030105, 0.000106453873740975, 0.000100112425570842, 9.38084922381677e-05, 8.76171397976577e-05, 8.16133906482719e-05, 7.56846930016764e-05, 6.99060910847038e-05, 6.41650112811476e-05, 5.86115529586095e-05, 5.31331279489677e-05, 4.77297580800951e-05, 4.25140096922405e-05, 3.7410827644635e-05, 3.23076455970295e-05, 2.74671274382854e-05, 2.2589087166125e-05, 1.80487550096586e-05, 1.34333768073702e-05, 9.00561553862644e-06, 4.57785426988266e-06, 4.50280822406057e-07, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 1.19323722174158e-05, 1.60599211085355e-05, 2.03375639102887e-05, 2.48403448495083e-05, 2.9193035516073e-05, 3.39960024575703e-05, 3.8798971218057e-05, 4.35268884757534e-05, 4.85549971926957e-05, 5.35831059096381e-05, 5.85361631237902e-05, 6.39395002508536e-05, 6.92677931510843e-05, 7.48962702346034e-05, 8.05247473181225e-05, 8.63033201312646e-05, 9.23070256249048e-05, 9.82356868917122e-05, 0.000104389488114975, 0.000110618340841029, 0.000116922223242, 0.000123451260151342, 0.000130055341287516, 0.000136734481202438, 0.000143563695019111, 0.000150317864608951, 0.000157297166879289, 0.000164426586707123, 0.000171781124663539, 0.000179210706846789, 0.000186490200576372, 0.000194069885765202, 0.000201799659407698, 0.000209754580282606, 0.000217634456930682, 0.000225664407480508, 0.000233919505262747, 0.000242174617596902, 0.000250579789280891, 0.000259135093074292, 0.00026776542654261, 0.000276395730907097, 0.000285176181932911, 0.000294256809866056, 0.000303412409266457, 0.000312568095978349, 0.000321873842040077, 0.0003313297056593, 0.000340860598953441, 0.000350466521922499, 0.000360147503670305, 0.000370128662325442, 0.000380184879759327, 0.000390241068089381, 0.000400522432755679, 0.000410878797993064, 0.000421160191763192, 0.000431816763011739, 0.000442398304585367, 0.000453280023066327, 0.000464161741547287, 0.000475193548481911, 0.00048645053175278, 0.00049763242714107, 0.000508964469190687, 0.000520446512382478, 0.000532153761014342, 0.000543936039321125, 0.000555718317627907, 0.000567575625609607, 0.000579583051148802, 0.000591740536037832, 0.000594145385548472, 0.000610580667853355, 0.000627015950158238, 0.000643226085230708, 0.000659661367535591, 0.000676021620165557, 0.000692306726705283, 0.000708666921127588, 0.000724952144082636, 0.00074131233850494, 0.000757672532927245, 0.000774107873439789, 0.000790242978837341, 0.000806678202934563, 0.000823038455564529, 0.00083917350275442, 0.000855683872941881, 0.000871968921273947, 0.000888179056346416, 0.000904614338651299, 0.000920899503398687, 0.000937334727495909, 0.000953619950450957, 0.000969980144873261, 0.000986265251412988, 0.00100255047436804, 0.00101891066879034, 0.0010353458346799, 0.00105163117405027, 0.00106806633993983, 0.00108412629924715, 0.00110041152220219, 0.00111684680450708, 0.0011331319110468, 0.00114964228123426, 0.00116600247565657, 0.00118206243496388, 0.00119849771726876, 0.00121485791169107, 0.00123121810611337, 0.001247578416951, 0.00126401358284056, 0.00128022371791303, 0.00129650870803744, 0.00131294399034232, 0.00132930418476462, 0.00134551431983709, 0.0013618745142594, 0.00137808464933187, 0.00139444484375417, 0.00141080503817648, 0.0014270901447162, 0.00144360051490366, 0.00145988562144339, 0.00147602066863328, 0.00149245595093817, 0.00150881602894515, 0.00152525119483471, 0.00154153641778976, 0.00155789672862738, 0.00157418171875179, 0.00159031676594168, 0.00160682713612914, 0.00162311224266887, 0.00163939734920859, 0.00165583251509815, 0.00167219270952046, 0.00168840272817761, 0.00170476292259991, 0.00172104826197028, 0.0017375583993271, 0.00174213631544262, 0.00175444409251213, 0.00176630145870149, 0.0017780838534236, 0.00179001630749553, 0.00180172361433506, 0.00181335583329201, 0.00182468781713396, 0.0018360948888585, 0.00184742687270045, 0.00185838376637548, 0.00186934066005051, 0.0018803725251928, 0.00189117924310267, 0.00190183601807803, 0.00191234261728823, 0.00192277412861586, 0.00193320563994348, 0.00194326182827353, 0.00195339298807085, 0.00196329923346639, 0.00197313050739467, 0.00198303651995957, 0.00199264264665544, 0.00200224854052067, 0.00201170449145138, 0.00202063517645001, 0.00202986574731767, 0.00203902157954872, 0.0020479520317167, 0.00205695768818259, 0.00206566299311817, 0.00207414338365197, 0.00208269874565303, 0.00209087878465652, 0.00209920923225582, 0.00210746424272656, 0.0021155693102628, 0.00212337402626872, 0.00213117897510529, 0.00213898369111121, 0.00214641354978085, 0.00215384317561984, 0.00216127280145884, 0.0021683273371309, 0.00217560678720474, 0.00218258611857891, 0.00218956544995308, 0.00219631940126419, 0.00220292364247143, 0.00220937770791352, 0.00221590674482286, 0.00222221063449979, 0.0022284397855401, 0.00223466847091913, 0.00224059703759849, 0.00224630068987608, 0.00225192937068641, 0.00225770799443126, 0.00226318626664579, 0.00226866477169096, 0.00227399310097098, 0.00227909628301859, 0.00228419946506619, 0.00228915270417929, 0.00229395553469658, 0.00229868339374661, 0.00230333628132939, 0.0023076890502125, 0.00231204181909561, 0.00231646955944598, 0.00232059694826603, 0.00233934540301561, 0.00234339758753777, 0.00234715011902153, 0.00235090241767466, 0.00235450454056263, 0.00235795672051609, 0.00236140890046954, 0.00236471090465784, 0.00236756261438131, 0.00237056449986994, 0.00237341620959342, 0.00237641809508204, 0.00237896968610585, 0.00238152127712965, 0.00238407286815345, 0.00238617393188179, 0.00238842563703656, 0.00239052693359554, 0.00239247805438936, 0.00239442940801382, 0.00239623035304248, 0.00239788158796728, 0.00239953235723078, 0.00240058312192559, 0.00240193377248943, 0.0024031347129494, 0.00240418524481356, 0.00240523600950837, 0.00240613659843802, 0.00240673706866801, 0.00240748724900186, 0.00240778736770153, 0.002408237894997, 0.00240838783793151, 0.00240853801369667, 0.00240868818946183, 0.00240868818946183, 0.00240838783793151, 0.002408237894997, 0.00240748724900186, 0.00240718713030219, 0.00240643648430705, 0.0024056863039732, 0.00240493565797806, 0.00240388489328325, 0.00240283436141908, 0.00240133353509009, 0.00239998265169561, 0.00239863176830113, 0.00239713094197214, 0.00239547993987799, 0.00239382893778384, 0.00239187781699002, 0.00238992646336555, 0.00238752504810691, 0.00238527357578278, 0.00238302233628929, 0.00238047051243484, 0.00237791892141104, 0.00237536733038723, 0.00237251562066376, 0.00236966391094029, 0.00236621173098683, 0.00236306013539433, 0.00235990807414055, 0.00235645589418709, 0.00235300371423364, 0.00234955153428018, 0.00234579900279641, 0.00234204693697393, 0.00233769416809082, 0.00232960260473192, 0.00232562515884638, 0.00232127262279391, 0.00231676967814565, 0.00231226696632802, 0.00230761407874525, 0.00230281101539731, 0.00229785800911486, 0.00229290477000177, 0.00228787655942142, 0.0022826986387372, 0.00227714516222477, 0.00227181660011411, 0.00226618815213442, 0.00226055970415473, 0.00225478108040988, 0.00224877730943263, 0.00224277353845537, 0.00223661959171295, 0.00223046611063182, 0.00222416198812425, 0.0022174078039825, 0.00221095373854041, 0.00220419955439866, 0.002197370165959, 0.00219039083458483, 0.00218333653174341, 0.0021764321718365, 0.00216907751746476, 0.00216157292015851, 0.0021539181470871, 0.00214626337401569, 0.00213868380524218, 0.00213080388493836, 0.00212284876033664, 0.00211489386856556, 0.00210671382956207, 0.00209815846756101, 0.00208982825279236, 0.00208119791932404, 0.00207264255732298, 0.0020638620480895, 0.00205508153885603, 0.00204615108668804, 0.00203684507869184, 0.00202753930352628, 0.00201823352836072, 0.00200885278172791, 0.00199932185932994, 0.00198971573263407, 0.00197980948723853, 0.00196990347467363, 0.00195984728634357, 0.00194964080583304, 0.00193943444173783, 0.00192915298976004, 0.00191872147843242, 0.00190791487693787, 0.00189725810196251, 0.00188652647193521, 0.00187549460679293, 0.00186438765376806, 0.00185335578862578, 0.00184209865983576, 0.00183061661664397, 0.00181920954491943, 0.00180750223807991, 0.00179586978629231, 0.0017839374486357, 0.00177185505162925, 0.00175992248114198, 0.001751002157107, 0.00173464184626937, 0.00171828165184706, 0.00170207140035927, 0.00168571097310632, 0.00166935077868402, 0.00165299046784639, 0.00163663015700877, 0.00162026996258646, 0.00160405971109867, 0.00158769940026104, 0.00157133908942342, 0.00155497889500111, 0.00153861858416349, 0.00152225827332586, 0.00150604790542275, 0.00148968771100044, 0.00147347745951265, 0.00145711714867502, 0.00144060677848756, 0.00142439664341509, 0.00140803621616215, 0.00139167602173984, 0.00137546577025205, 0.00135910557582974, 0.0013427451485768, 0.00132638495415449, 0.00131002464331686, 0.00129366433247924, 0.00127745419740677, 0.00126109377015382, 0.00124473345931619, 0.00122852332424372, 0.00121201295405626, 0.00119580270256847, 0.00117944239173084, 0.00116308219730854, 0.00114687182940543, 0.00113051163498312, 0.00111400126479566, 0.00109779101330787, 0.00108143070247024, 0.00106507039163262, 0.00104886025656015, 0.0010324998293072, 0.00101613963488489, 0.000999779324047267, 0.000983419013209641, 0.000967058760579675, 0.000950848509091884, 0.000934488198254257, 0.000918278004974127, 0.0009019176941365, 0.000885407323949039, 0.000869197130668908, 0.000852836878038943, 0.000836476567201316, 0.000820266315713525, 0.000803906004875898, 0.000787395576480776, 0.000771185441408306, 0.00075482513057068, 0.000738464819733053, 0.000722254684660584, 0.000705894373822957, 0.00068953400477767, 0.000673173693940043, 0.000656813441310078, 0.000640603248029947, 0.000624242937192321, 0.000607882626354694, 0.000591672491282225, 0.000577109982259572, 0.000564952380955219, 0.000552944839000702, 0.000541012443136424, 0.000529230106621981, 0.00051767285913229, 0.000505965552292764, 0.000494708539918065, 0.000483451527543366, 0.000472044426715001, 0.000461087620351464, 0.000449980667326599, 0.000439173920312896, 0.000428667379310355, 0.000417860632296652, 0.000407204002840444, 0.000397147698095068, 0.000386641186196357, 0.000376434822101146, 0.000366303487680852, 0.000356472388375551, 0.000346641230862588, 0.000336810102453455, 0.000327354209730402, 0.000317748199449852, 0.000308442395180464, 0.000299286708468571, 0.000289905845420435, 0.000280975276837125, 0.000272119737928733, 0.000263189198449254, 0.000254558806773275, 0.000246003473876044, 0.000237598229432479, 0.000229192984988913, 0.000221012887777761, 0.000212982879020274, 0.000204877826035954, 0.000196997905732132, 0.000189343147212639, 0.000181463226908818, 0.000174033586517908, 0.000166603960678913, 0.000159174305736087, 0.000152119930135086, 0.000144990466651507, 0.00013793607649859, 0.000131106819026172, 0.000124352605780587, 0.000117748480988666, 0.000111069311969914, 0.000104840437415987, 9.84614525805227e-05, 9.24577107070945e-05, 8.6378917330876e-05, 8.03001312306151e-05, 7.45215293136425e-05, 6.88930158503354e-05, 6.31894581601955e-05, 5.77110404265113e-05, 5.23827184224501e-05, 4.71294442832004e-05, 4.19512143707834e-05, 3.69230838259682e-05, 3.18949460051954e-05, 2.71669960056897e-05, 2.26641859626397e-05, 1.79362396011129e-05, 1.35084783323691e-05, 9.30585702008102e-06, 4.95314361614874e-06, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15, 2.33292778948095e-15   }, 
   { 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 2.62851262959884e-05, 5.88354741921648e-05, 9.23219995456748e-05, 0.000126672690385021, 0.000161815536557697, 0.000197822577320039, 0.000234909792197868, 0.000272645149379969, 0.000311532727209851, 0.000350852380506694, 0.00039161232416518, 0.000432804401498288, 0.000475148641271517, 0.000518213026225567, 0.00056235765805468, 0.000607078312896192, 0.000653023307677358, 0.000699472439009696, 0.000747145677451044, 0.000795467116404325, 0.000844868656713516, 0.00089499051682651, 0.000946120475418866, 0.000998042640276253, 0.00105090090073645, 0.00110455136746168, 0.00115906598512083, 0.00121451681479812, 0.00127097580116242, 0.00132815493270755, 0.0013861982151866, 0.0014451778260991, 0.00150509353261441, 0.00156580132897943, 0.00162730133160949, 0.00168988155201077, 0.00175318180117756, 0.0018175623845309, 0.00188259116839617, 0.00194869993720204, 0.00201545702293515, 0.00208336627110839, 0.00215206760913134, 0.00222156103700399, 0.00229199090972543, 0.00236328481696546, 0.00243551493622363, 0.00250853691250086, 0.00258249556645751, 0.00265731802210212, 0.00273300497792661, 0.00280955596826971, 0.00288704293780029, 0.00296532223001122, 0.00304460967890918, 0.00312468921765685, 0.00320570496842265, 0.00328751304186881, 0.00337018491700292, 0.00345400953665376, 0.00353848189115524, 0.00362381851300597, 0.00371001940220594, 0.00379730039276183, 0.003885229350999, 0.00397423887625337, 0.00406382419168949, 0.00415463373064995, 0.00424616364762187, 0.00433848612010479, 0.00443181581795216, 0.00453673209995031, 0.00466239638626575, 0.00478827673941851, 0.00491386838257313, 0.00503967748954892, 0.00516527006402612, 0.00529122166335583, 0.0054169581271708, 0.00554269412532449, 0.00566835841163993, 0.00579416658729315, 0.00591990305110812, 0.00604571076110005, 0.00617130333557725, 0.00629711151123047, 0.00642277533188462, 0.00654865615069866, 0.00667446432635188, 0.00680005690082908, 0.00692600896582007, 0.00705152936279774, 0.0071774092502892, 0.00730314571410418, 0.00742888171225786, 0.00755461817607284, 0.00768035417422652, 0.00780609110370278, 0.00793197099119425, 0.00805763620883226, 0.0081834439188242, 0.00830903556197882, 0.00843491684645414, 0.00856043584644794, 0.00868638884276152, 0.0088121248409152, 0.00893786177039146, 0.00906374212354422, 0.00918933376669884, 0.00931514240801334, 0.00944087840616703, 0.00956654269248247, 0.0096923504024744, 0.00981808733195066, 0.0099438950419426, 0.0100696319714189, 0.0101953679695725, 0.0103212492540479, 0.0104468418285251, 0.0105725778266788, 0.0106983138248324, 0.0108241215348244, 0.0109499311074615, 0.0110755944624543, 0.0112012596800923, 0.0113270673900843, 0.0114528043195605, 0.0115786837413907, 0.0117042036727071, 0.0118300840258598, 0.0119557483121753, 0.012081628665328, 0.0122073655948043, 0.0123330298811197, 0.0124589828774333, 0.0125844292342663, 0.0127103831619024, 0.0128360474482179, 0.0129617834463716, 0.0130875920876861, 0.0132132563740015, 0.0133390640839934, 0.0134648727253079, 0.0135591868311167, 0.0136520843952894, 0.0137441186234355, 0.0138355745002627, 0.0139260245487094, 0.0140154659748077, 0.0141041874885559, 0.0141919003799558, 0.0142788914963603, 0.0143645890057087, 0.0144499968737364, 0.0145342536270618, 0.0146176451817155, 0.0147000290453434, 0.0147815486416221, 0.014862491749227, 0.0149421393871307, 0.0150210671126842, 0.0150994174182415, 0.0151764722540975, 0.0152528071776032, 0.0153282769024372, 0.0154027389362454, 0.0154766263440251, 0.0155493598431349, 0.015621230006218, 0.0156922340393066, 0.0157625209540129, 0.0158319398760796, 0.0159000661224127, 0.0159677602350712, 0.0160344429314137, 0.016100263223052, 0.0161650776863098, 0.0162290241569281, 0.0162922535091639, 0.0163543298840523, 0.0164156854152679, 0.0164763201028109, 0.0165358055382967, 0.016594709828496, 0.0166521780192852, 0.0167093575000763, 0.016765670850873, 0.016820689663291, 0.0168749894946814, 0.0169282779097557, 0.0169809926301241, 0.0170328430831432, 0.0170833971351385, 0.0171333737671375, 0.017182344570756, 0.017230736091733, 0.0172779783606529, 0.017324211075902, 0.0173698663711548, 0.0174143724143505, 0.0174581557512283, 0.0175009313970804, 0.0175429880619049, 0.0175843257457018, 0.017624219879508, 0.0176638271659613, 0.0177021399140358, 0.0177398733794689, 0.0177766010165215, 0.0178123209625483, 0.0178474616259336, 0.017881453037262, 0.017914580181241, 0.0179469846189022, 0.0179721191525459, 0.0179874580353498, 0.0180023647844791, 0.0180166233330965, 0.0180306658148766, 0.0180441327393055, 0.0180571675300598, 0.018069913610816, 0.0180820114910603, 0.0180938933044672, 0.0181050561368465, 0.0181160010397434, 0.0181265156716108, 0.018136452883482, 0.0181459616869688, 0.0181550327688456, 0.0181638207286596, 0.0181719567626715, 0.0181797351688147, 0.0181872230023146, 0.0181940644979477, 0.0182006172835827, 0.0182064510881901, 0.018212141469121, 0.018217395991087, 0.0182220786809921, 0.0182264000177383, 0.0182300712913275, 0.0182336010038853, 0.0182366240769625, 0.018239002674818, 0.0182410907000303, 0.0182426739484072, 0.0182439722120762, 0.0182446911931038, 0.0182449780404568, 0.018244905397296, 0.0182442590594292, 0.0182432513684034, 0.0182419549673796, 0.018239937722683, 0.0182377062737942, 0.0182347539812326, 0.0182316564023495, 0.0182281266897917, 0.018223948776722, 0.0182194858789444, 0.0182143729180098, 0.0182090438902378, 0.0182032845914364, 0.0181969460099936, 0.0181901752948761, 0.0181829743087292, 0.0181754864752293, 0.0181674920022488, 0.0181588511914015, 0.0181499905884266, 0.018140560016036, 0.0181307643651962, 0.0181205403059721, 0.0181098077446222, 0.0180987901985645, 0.0180870536714792, 0.0180750992149115, 0.0180627126246691, 0.0180498212575912, 0.0180365703999996, 0.0180225986987352, 0.0180084872990847, 0.0179939400404692, 0.0179787464439869, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179645903408527, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179651994258165, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179648771882057, 0.0179530344903469, 0.0179415121674538, 0.0179305672645569, 0.0179197657853365, 0.0179094672203064, 0.0178994573652744, 0.0178897343575954, 0.0178803727030754, 0.0178712997585535, 0.0178625844419003, 0.0178541615605354, 0.0178461670875549, 0.0178383160382509, 0.0178309716284275, 0.0178238414227962, 0.0178171452134848, 0.0178106632083654, 0.0178046859800816, 0.0177989974617958, 0.0177934523671865, 0.0177884120494127, 0.0177835859358311, 0.01777926646173, 0.0177750885486603, 0.0177713446319103, 0.0177678167819977, 0.0177647918462753, 0.0177619103342295, 0.0177595335990191, 0.0177575182169676, 0.0177556462585926, 0.0177542045712471, 0.0177530534565449, 0.0177523326128721, 0.017751757055521, 0.0177516844123602, 0.017751757055521, 0.0177524052560329, 0.0177531260997057, 0.0177543479949236, 0.0177557896822691, 0.0177577342838049, 0.0177597496658564, 0.0177623424679041, 0.0177652947604656, 0.017768319696188, 0.0177718494087458, 0.0177755933254957, 0.0177798420190811, 0.017784234136343, 0.0177891328930855, 0.0177941732108593, 0.0177997183054686, 0.0178054068237543, 0.0178116001188755, 0.017818009480834, 0.0178248509764671, 0.0178320519626141, 0.0178393982350826, 0.0178472474217415, 0.0178553126752377, 0.0178638100624084, 0.0178725235164165, 0.0178816709667444, 0.0178910307586193, 0.0179008971899748, 0.0179109070450068, 0.0179213490337133, 0.0179321505129337, 0.0179431699216366, 0.0179546922445297, 0.0179667193442583, 0.0179909132421017, 0.0180156864225864, 0.018041180446744, 0.0180672481656075, 0.0180940385907888, 0.0181215479969978, 0.0181496310979128, 0.0181784387677908, 0.0182078201323748, 0.0182379204779863, 0.0182686001062393, 0.0183001421391964, 0.0183321163058281, 0.0183649528771639, 0.0183982234448195, 0.0184323582798243, 0.0184670705348253, 0.0185022111982107, 0.018538361415267, 0.0185750909149647, 0.0186122488230467, 0.0186502728611231, 0.0186890158802271, 0.0187281910330057, 0.0187683738768101, 0.0188088472932577, 0.0188503265380859, 0.0188920963555574, 0.0189348701387644, 0.0189780779182911, 0.0190221518278122, 0.0190665107220411, 0.0191120263189077, 0.019157825037837, 0.0192044917494059, 0.0192518755793571, 0.0192996934056282, 0.0193483754992485, 0.0193973444402218, 0.0194474663585424, 0.0194978732615709, 0.0195491500198841, 0.0196008533239365, 0.0196535680443048, 0.0197065696120262, 0.0197605825960636, 0.0198148787021637, 0.0198701862245798, 0.0199262127280235, 0.0199825279414654, 0.020039850845933, 0.0200974605977535, 0.020156079903245, 0.0202151332050562, 0.0202750470489264, 0.0203352514654398, 0.0203966069966555, 0.0204581059515476, 0.0205207578837872, 0.0205836985260248, 0.0206476449966431, 0.0207120273262262, 0.0207769833505154, 0.0208426602184772, 0.0209090560674667, 0.020976172760129, 0.021043723449111, 0.0211122781038284, 0.0211811251938343, 0.0212509781122208, 0.0213212631642818, 0.0214009862393141, 0.0214800927788019, 0.0215598475188017, 0.0216398555785418, 0.0217204391956329, 0.0218013115227222, 0.021882900968194, 0.0219646375626326, 0.022047059610486, 0.022129837423563, 0.0222129430621862, 0.0222965870052576, 0.0223805904388428, 0.022465206682682, 0.0225500408560038, 0.0226355213671923, 0.0227212179452181, 0.0228075627237558, 0.0228942669928074, 0.0229814387857914, 0.0230688620358706, 0.0231570433825254, 0.0232454407960176, 0.0233343429863453, 0.0234236419200897, 0.0235135145485401, 0.0236037820577621, 0.0236943755298853, 0.0237855818122625, 0.0238770060241222, 0.0239690374583006, 0.0240613594651222, 0.0241543296724558, 0.0242475531995296, 0.0243413504213095, 0.0244354717433453, 0.0245301369577646, 0.0246251579374075, 0.0247206836938858, 0.0248165335506201, 0.0249130334705114, 0.025009747594595, 0.0251071099191904, 0.0252049397677183, 0.0253029875457287, 0.025401646271348, 0.0255005937069654, 0.0256001185625792, 0.0256999284029007, 0.0258002784103155, 0.0259010270237923, 0.0260023139417171, 0.026103962212801, 0.0262061152607203, 0.0263085886836052, 0.0264116767793894, 0.0265149809420109, 0.0266188625246286, 0.0267232824116945, 0.0268279910087585, 0.026933204382658, 0.027038810774684, 0.0271449591964483, 0.0272512156516314, 0.0273583009839058, 0.0274656023830175, 0.0275735501199961, 0.0276817493140697, 0.0277905277907848, 0.0278995558619499, 0.0280092693865299, 0.0281158294528723, 0.0282030384987593, 0.0282905362546444, 0.0283790770918131, 0.0284680500626564, 0.0285578519105911, 0.0286483373492956, 0.0287393629550934, 0.0288312155753374, 0.0289234668016434, 0.0290167238563299, 0.0291103795170784, 0.0292047876864672, 0.0292996317148209, 0.0293955188244581, 0.0294917300343513, 0.0295886229723692, 0.0296864211559296, 0.0297847185283899, 0.0298838093876839, 0.0299834422767162, 0.0300838276743889, 0.0301848649978638, 0.0302864424884319, 0.0303888432681561, 0.0304918251931667, 0.0305951274931431, 0.0306994784623384, 0.0308043286204338, 0.0309100113809109, 0.0310162678360939, 0.0311233159154654, 0.0312309395521879, 0.0313391052186489, 0.0314480625092983, 0.031557559967041, 0.0316679589450359, 0.0317787155508995, 0.0318902656435966, 0.0320023931562901, 0.0321152359247208, 0.032228697091341, 0.0323429107666016, 0.0324577353894711, 0.0325734615325928, 0.0326895490288734, 0.0328064635396004, 0.0329237729310989, 0.0330421291291714, 0.0331608094274998, 0.0332800261676311, 0.0334002561867237, 0.0335210263729095, 0.0336424373090267, 0.0337645746767521, 0.0338873937726021, 0.034010898321867, 0.0341349057853222, 0.0342597812414169, 0.034385085105896, 0.03451132401824, 0.0346379615366459, 0.0347654260694981, 0.0348931439220905, 0.0350218713283539, 0.0351513847708702, 0.0352813005447388, 0.035412110388279, 0.0355433933436871, 0.0356754660606384, 0.035808190703392, 0.0358194299042225, 0.0350465774536133, 0.0342924520373344, 0.0335846990346909, 0.0328874625265598, 0.0322175920009613, 0.0315949581563473, 0.0309818368405104, 0.0303970836102962, 0.0298494901508093, 0.0293211992830038, 0.0288117732852697, 0.028339795768261, 0.0278776120394468, 0.0274802390486002, 0.0270745139569044, 0.0267150215804577, 0.0263932663947344, 0.026072084903717, 0.0257882047444582, 0.0255511365830898, 0.0253235716372728, 0.0251153092831373, 0.0249535664916039, 0.0248014740645885, 0.0246869716793299, 0.0245911944657564, 0.0245420821011066, 0.024493832141161, 0.0244826003909111, 0.0245183166116476, 0.0245636869221926, 0.0246374290436506, 0.0247391127049923, 0.0248691719025373, 0.0250274576246738, 0.0252046100795269, 0.0254193563014269, 0.0256620440632105, 0.0259240306913853, 0.0262136701494455, 0.026550404727459, 0.0268875751644373, 0.0272621903568506, 0.0276742540299892, 0.0281053297221661, 0.0285646338015795, 0.0290521681308746, 0.0295676402747631, 0.0301024187356234, 0.0306651331484318, 0.0312559343874454, 0.0318938344717026, 0.032531876116991, 0.0332076549530029, 0.0339298099279404, 0.0346526838839054, 0.0354130007326603, 0.0362106300890446, 0.0370180457830429, 0.0378538407385349, 0.0387361533939838, 0.0396281182765961, 0.0405484512448311, 0.0414965860545635, 0.0424918197095394, 0.0434874780476093, 0.0445204451680183, 0.0455910041928291, 0.0466712117195129, 0.0477890074253082, 0.0489348918199539, 0.049278162419796, 0.0499602779746056, 0.0507253520190716, 0.0515641681849957, 0.052513599395752, 0.0535920783877373, 0.0546982102096081, 0.0559702590107918, 0.0572884008288383, 0.0587355867028236, 0.0603210441768169, 0.0618972890079021, 0.0636486560106277, 0.0655014291405678, 0.0673910677433014, 0.0694374144077301, 0.0715298429131508, 0.0737605467438698, 0.0761018544435501, 0.0784708261489868, 0.0809964910149574, 0.083595909178257, 0.0862967073917389, 0.0891173407435417, 0.0919932797551155, 0.0950074940919876, 0.0980862230062485, 0.101275570690632, 0.104575529694557, 0.107949234545231, 0.111433550715446, 0.115046918392181, 0.118678703904152, 0.122467219829559, 0.126338675618172, 0.130311533808708, 0.134385779500008, 0.138524562120438, 0.142792373895645, 0.147170811891556, 0.151595339179039, 0.156176567077637, 0.160785466432571, 0.165541812777519, 0.170408800244331, 0.175331085920334, 0.180373191833496, 0.185525938868523, 0.190752401947975, 0.196080252528191, 0.201481878757477, 0.207030966877937, 0.212672248482704, 0.218350395560265, 0.224176004528999, 0.230103045701981, 0.236094564199448, 0.242224395275116, 0.248381853103638, 0.254732877016068, 0.261148452758789, 0.267600893974304, 0.274219244718552, 0.280874490737915, 0.287686407566071, 0.294608950614929, 0.301549911499023, 0.308647602796555, 0.315828263759613, 0.323101073503494, 0.330493688583374, 0.338937163352966, 0.349150449037552, 0.359455913305283, 0.369798243045807, 0.380324929952621, 0.390943795442581, 0.401654839515686, 0.412550210952759, 0.423445641994476, 0.434525370597839, 0.445715725421906, 0.456998288631439, 0.468409895896912, 0.479895204305649, 0.491546481847763, 0.503271460533142, 0.515088677406311, 0.527071714401245, 0.539165437221527, 0.551332890987396, 0.56364780664444, 0.576018035411835, 0.58857262134552, 0.601182520389557, 0.613921463489532, 0.626789510250092, 0.639731228351593, 0.652820467948914, 0.666020274162292, 0.679312288761139, 0.692733407020569, 0.706283450126648, 0.719888865947723, 0.733660221099854, 0.7474684715271, 0.761479496955872, 0.775564193725586, 0.789741158485413, 0.804065525531769, 0.818482100963593, 0.833009302616119, 0.847665548324585, 0.862414002418518, 0.877291440963745, 0.89226108789444, 0.907341361045837, 0.922550678253174, 0.937870562076569, 0.953282713890076, 0.968823850154877, 0.984475553035736, 1.00025641918182, 1.01612937450409, 1.03209459781647, 1.04818880558014, 1.06443047523499, 1.0807089805603, 1.09715354442596, 1.11369025707245, 1.13033747673035, 1.14709532260895, 1.16400074958801, 1.18097984790802, 1.19808804988861, 1.2153068780899, 1.2326363325119, 1.25003933906555, 1.26760840415955, 1.28525125980377, 1.30304169654846, 1.3209056854248, 1.33889865875244, 1.36048913002014, 1.38067603111267, 1.40086305141449, 1.42106831073761, 1.44123685359955, 1.46144223213196, 1.4816107749939, 1.50177931785583, 1.52192938327789, 1.54209780693054, 1.5622478723526, 1.58239793777466, 1.60252964496613, 1.62267971038818, 1.64279282093048, 1.66292452812195, 1.68301916122437, 1.70313251018524, 1.72322726249695, 1.74334049224854, 1.76341676712036, 1.78349316120148, 1.80362474918365, 1.82364571094513, 1.84372210502625, 1.86379837989807, 1.88385629653931, 1.90389585494995, 1.92391681671143, 1.94395625591278, 1.96397733688354, 1.9840167760849, 2.00401926040649, 2.02404022216797, 2.04404282569885, 2.06402707099915, 2.08404803276062, 2.10399532318115, 2.12401628494263, 2.14394521713257, 2.16392946243286, 2.18387675285339, 2.20386099815369, 2.22377133369446, 2.24371838569641, 2.2637026309967, 2.28361296653748, 2.30350494384766, 2.32345223426819, 2.34338092803955, 2.36327314376831, 2.3831467628479, 2.40305685997009, 2.42293047904968, 2.44280385971069, 2.46271467208862, 2.48253273963928, 2.50240635871887, 2.52227973937988, 2.54211640357971, 2.56195330619812, 2.58180809020996, 2.60164499282837, 2.6214816570282, 2.6412627696991, 2.66109943389893, 2.68089938163757, 2.70068073272705, 2.72049880027771, 2.74028015136719, 2.76002478599548, 2.77858924865723, 2.79671144485474, 2.81472301483154, 2.83253169059753, 2.85030341148376, 2.86781740188599, 2.88527607917786, 2.9026050567627, 2.91975045204163, 2.9367663860321, 2.95367169380188, 2.97037434577942, 2.98696660995483, 3.00341081619263, 3.01965260505676, 3.03580212593079, 3.0518593788147, 3.06775116920471, 3.08347630500793, 3.09905457496643, 3.11452198028564, 3.12986040115356, 3.14501452445984, 3.160076379776, 3.17495393753052, 3.18961000442505, 3.20424795150757, 3.21871995925903, 3.23302555084229, 3.24716591835022, 3.26125073432922, 3.27516937255859, 3.28886723518372, 3.30254650115967, 3.31598591804504, 3.32929635047913, 3.34245920181274, 3.35551190376282, 3.36836123466492, 3.38115549087524, 3.39378380775452, 3.4062647819519, 3.41861653327942, 3.4307656288147, 3.44285917282104, 3.45473170280457, 3.46649384498596, 3.47810816764832, 3.48961186408997, 3.50096821784973, 3.51214027404785, 3.52322006225586, 3.53409695625305, 3.5449001789093, 3.5555374622345, 3.56599044799805, 3.57635116577148, 3.58658313751221, 3.59666728973389, 3.6065673828125, 3.61635637283325, 3.62596130371094, 3.63549256324768, 3.64482116699219, 3.65407562255859, 3.66310906410217, 3.67206859588623, 3.68086266517639, 3.68950891494751, 3.69802594184875, 3.70635867118835, 3.71459937095642, 3.71846437454224, 3.72318410873413, 3.72775602340698, 3.73221731185913, 3.73645758628845, 3.74062395095825, 3.744624376297, 3.74842214584351, 3.7521276473999, 3.75568580627441, 3.75907754898071, 3.76234078407288, 3.76547479629517, 3.76846146583557, 3.77128195762634, 3.7739737033844, 3.77651786804199, 3.77893304824829, 3.7811267375946, 3.78330206871033, 3.78525614738464, 3.78702592849731, 3.78870368003845, 3.79025197029114, 3.7916533946991, 3.79288840293884, 3.79399466514587, 3.79495334625244, 3.79576444625854, 3.79635429382324, 3.79685211181641, 3.79725766181946, 3.7974419593811, 3.79753398895264, 3.79749727249146, 3.79725766181946, 3.79694414138794, 3.79648375511169, 3.79583835601807, 3.79504537582397, 3.79406833648682, 3.79294395446777, 3.79172706604004, 3.7903995513916, 3.7888514995575, 3.78719186782837, 3.78547739982605, 3.7835419178009, 3.78142166137695, 3.77919101715088, 3.77679443359375, 3.7742133140564, 3.7715585231781, 3.76871967315674, 3.76576972007751, 3.76267290115356, 3.75948333740234, 3.7560727596283, 3.75253319740295, 3.74888300895691, 3.74506688117981, 3.74101114273071, 3.73686289787292, 3.73258590698242, 3.72819805145264, 3.72368192672729, 3.71898055076599, 3.7141318321228, 3.70917272567749, 3.7040479183197, 3.6987566947937, 3.69245147705078, 3.68628478050232, 3.68003511428833, 3.67374873161316, 3.66745281219482, 3.66109275817871, 3.65470004081726, 3.64829802513123, 3.64184093475342, 3.63531923294067, 3.62883496284485, 3.62224411964417, 3.61562132835388, 3.60900259017944, 3.60231041908264, 3.59561848640442, 3.58885717391968, 3.58206367492676, 3.57521939277649, 3.56837511062622, 3.5614709854126, 3.55452561378479, 3.54757070541382, 3.54053735733032, 3.53350901603699, 3.52641129493713, 3.51927661895752, 3.51215147972107, 3.50493359565735, 3.49768829345703, 3.49040627479553, 3.48313355445862, 3.4757776260376, 3.46838974952698, 3.46095538139343, 3.45348429679871, 3.44602274894714, 3.43848252296448, 3.43089175224304, 3.4233283996582, 3.41565942764282, 3.4079761505127, 3.40028834342957, 3.39253163337708, 3.38475179672241, 3.37691235542297, 3.36905407905579, 3.36113619804382, 3.35323214530945, 3.34524440765381, 3.33722043037415, 3.3291871547699, 3.32109379768372, 3.31300091743469, 3.30482459068298, 3.29662537574768, 3.28840780258179, 3.28012537956238, 3.27182483673096, 3.2634596824646, 3.25511288642883, 3.24666047096252, 3.23822617530823, 3.22971320152283, 3.22119617462158, 3.21266031265259, 3.20405554771423, 3.19540023803711, 3.18674945831299, 3.17802453041077, 3.16927719116211, 3.16068601608276, 3.15415072441101, 3.14765191078186, 3.14118576049805, 3.13473320007324, 3.1283175945282, 3.12193894386292, 3.11558771133423, 3.10925531387329, 3.10295486450195, 3.09667301177979, 3.0904278755188, 3.08421969413757, 3.0780348777771, 3.07187247276306, 3.06572890281677, 3.05963134765625, 3.05355668067932, 3.04750990867615, 3.04149508476257, 3.03550362586975, 3.0295352935791, 3.02360820770264, 3.01770401000977, 3.01181864738464, 3.00597453117371, 3.00015330314636, 2.99436473846436, 2.98859453201294, 2.98286986351013, 2.97715973854065, 2.97148132324219, 2.96583104133606, 2.96021747589111, 2.95462203025818, 2.94905471801758, 2.943523645401, 2.93799757957458, 2.9325270652771, 2.92706990242004, 2.92164993286133, 2.91625308990479, 2.91088819503784, 2.90555119514465, 2.90023708343506, 2.89495539665222, 2.8896918296814, 2.8844747543335, 2.8792712688446, 2.87410926818848, 2.86897039413452, 2.86385440826416, 2.85876631736755, 2.85370564460754, 2.84867739677429, 2.8436906337738, 2.83871293067932, 2.8337767124176, 2.82885932922363, 2.82396912574768, 2.81911587715149, 2.81428098678589, 2.80947852134705, 2.80468988418579, 2.79995656013489, 2.79526019096375, 2.7905547618866, 2.78589963912964, 2.78126287460327, 2.77665877342224, 2.77208685874939, 2.76752829551697, 2.76412177085876, 2.76011061668396, 2.75613188743591, 2.75215244293213, 2.74818515777588, 2.74425721168518, 2.74032807350159, 2.73643136024475, 2.73252534866333, 2.72865962982178, 2.72480201721191, 2.72096753120422, 2.71714091300964, 2.71331906318665, 2.70952463150024, 2.70576167106628, 2.70200896263123, 2.69824695587158, 2.69452524185181, 2.6908221244812, 2.68713045120239, 2.68343162536621, 2.67977118492126, 2.67612862586975, 2.67251110076904, 2.66891241073608, 2.66529440879822, 2.6617169380188, 2.65815877914429, 2.65461230278015, 2.65106582641602, 2.64755940437317, 2.64406251907349, 2.64058876037598, 2.637122631073, 2.63366031646729, 2.63023710250854, 2.62682294845581, 2.62343096733093, 2.62002825737, 2.6166672706604, 2.6133143901825, 2.60998439788818, 2.60667061805725, 2.60336351394653, 2.60007524490356, 2.59681344032288, 2.5935652256012, 2.59030938148499, 2.58710145950317, 2.58389234542847, 2.58070659637451, 2.57753801345825, 2.57437372207642, 2.57124662399292, 2.56812405586243, 2.56502938270569, 2.56192541122437, 2.55885243415833, 2.55580711364746, 2.5527651309967, 2.54974174499512, 2.54672312736511, 2.54373860359192, 2.54076957702637, 2.53781843185425, 2.5348596572876, 2.53193998336792, 2.52902007102966, 2.52614188194275, 2.52326369285583, 2.52000522613525, 2.51702332496643, 2.51403212547302, 2.51103639602661, 2.50804305076599, 2.50503778457642, 2.50201916694641, 2.49900841712952, 2.49598288536072, 2.49294638633728, 2.48990678787231, 2.48687195777893, 2.48382091522217, 2.4807653427124, 2.47771072387695, 2.47463774681091, 2.47156476974487, 2.46848964691162, 2.46540141105652, 2.46230673789978, 2.45920825004578, 2.45610785484314, 2.45299911499023, 2.44987416267395, 2.44676423072815, 2.44363141059875, 2.44049525260925, 2.43735194206238, 2.4342086315155, 2.43105602264404, 2.4278883934021, 2.4247350692749, 2.42155718803406, 2.41837930679321, 2.41520166397095, 2.41200661659241, 2.40880918502808, 2.40560364723206, 2.40240168571472, 2.3991847038269, 2.3959629535675, 2.39274024963379, 2.38950490951538, 2.38626503944397, 2.3830246925354, 2.37977433204651, 2.37650990486145, 2.37324476242065, 2.36998391151428, 2.36670231819153, 2.36341834068298, 2.36013674736023, 2.35683703422546, 2.35353469848633, 2.35022664070129, 2.34692215919495, 2.34359812736511, 2.34027051925659, 2.3369448184967, 2.33360576629639, 2.33026218414307, 2.32690238952637, 2.32355737686157, 2.32019519805908, 2.31682252883911, 2.3134548664093, 2.31007289886475, 2.30668425559998, 2.3032968044281, 2.29989433288574, 2.29648590087891, 2.29307317733765, 2.28913021087646, 2.28524947166443, 2.2813549041748, 2.27745366096497, 2.27353143692017, 2.26959562301636, 2.26565504074097, 2.2617027759552, 2.25772976875305, 2.25374555587769, 2.24975180625916, 2.2457492351532, 2.24172329902649, 2.23768830299377, 2.23364853858948, 2.2295880317688, 2.22551155090332, 2.22143745422363, 2.21733999252319, 2.21323108673096, 2.20911550521851, 2.2049720287323, 2.20082879066467, 2.19666218757629, 2.19249820709229, 2.18830871582031, 2.18410992622375, 2.17990207672119, 2.17568254470825, 2.17144012451172, 2.1671884059906, 2.16293215751648, 2.15866208076477, 2.15436863899231, 2.15008020401001, 2.14575934410095, 2.1414315700531, 2.13710188865662, 2.13275074958801, 2.12838172912598, 2.12400317192078, 2.11962485313416, 2.11522340774536, 2.1108033657074, 2.10638332366943, 2.10194039344788, 2.09749054908752, 2.09303379058838, 2.08855628967285, 2.08405590057373, 2.07955527305603, 2.07504534721375, 2.07051253318787, 2.0659658908844, 2.06142854690552, 2.05685424804688, 2.05227756500244, 2.04768013954163, 2.0430850982666, 2.0384624004364, 2.0338351726532, 2.02919387817383, 2.02453899383545, 2.01987457275391, 2.01520133018494, 2.01050019264221, 2.00579237937927, 2.00106811523438, 1.99634873867035, 1.99159705638885, 1.98683822154999, 1.9813357591629, 1.97596395015717, 1.97058761119843, 1.96521830558777, 1.95986497402191, 1.95452558994293, 1.94919776916504, 1.94387912750244, 1.93856036663055, 1.93326246738434, 1.92797374725342, 1.92269432544708, 1.91743779182434, 1.91217446327209, 1.90693175792694, 1.90169620513916, 1.8964672088623, 1.89125001430511, 1.8860627412796, 1.8808616399765, 1.87568807601929, 1.87050533294678, 1.86535036563873, 1.86020910739899, 1.85507011413574, 1.84994280338287, 1.84482228755951, 1.83971560001373, 1.83462274074554, 1.82953226566315, 1.82447624206543, 1.81940186023712, 1.81435739994049, 1.80931067466736, 1.80428242683411, 1.79926097393036, 1.79426276683807, 1.78926205635071, 1.78427743911743, 1.77929294109344, 1.77433145046234, 1.76938390731812, 1.7644454240799, 1.75950706005096, 1.75458455085754, 1.7496691942215, 1.74477458000183, 1.73988926410675, 1.73501300811768, 1.73014378547668, 1.7252836227417, 1.72043740749359, 1.71560490131378, 1.71077477931976, 1.70596551895142, 1.70116293430328, 1.69636738300323, 1.69158339500427, 1.68682932853699, 1.68206143379211, 1.67731201648712, 1.67257404327393, 1.66784536838531, 1.663130402565, 1.65842461585999, 1.65373051166534, 1.64904320240021, 1.64437437057495, 1.63971245288849, 1.63505744934082, 1.63042092323303, 1.62579834461212, 1.62235081195831, 1.6186728477478, 1.61501812934875, 1.61140918731689, 1.60781419277191, 1.60424244403839, 1.60069370269775, 1.59718155860901, 1.59368348121643, 1.59022676944733, 1.5867931842804, 1.58337795734406, 1.57998585700989, 1.5766259431839, 1.57328903675079, 1.56998455524445, 1.56671214103699, 1.56344902515411, 1.56023681163788, 1.55703353881836, 1.55383491516113, 1.55071473121643, 1.54759454727173, 1.54448342323303, 1.54141855239868, 1.53836750984192, 1.53536236286163, 1.53237128257751, 1.52940309047699, 1.52646267414093, 1.52354526519775, 1.52066004276276, 1.51780700683594, 1.51496338844299, 1.51216125488281, 1.50937283039093, 1.50660288333893, 1.50388836860657, 1.5011875629425, 1.49850976467133, 1.49586415290833, 1.49323260784149, 1.49062860012054, 1.48806118965149, 1.48551726341248, 1.48300528526306, 1.48050260543823, 1.47803235054016, 1.47558498382568, 1.47318375110626, 1.47079646587372, 1.46843194961548, 1.466099858284, 1.46378636360168, 1.46149563789368, 1.45925557613373, 1.45701575279236, 1.45480811595917, 1.45262813568115, 1.45048022270203, 1.44835102558136, 1.44626319408417, 1.44418454170227, 1.44214296340942, 1.44011497497559, 1.43811464309692, 1.43615114688873, 1.4342200756073, 1.43229830265045, 1.4304039478302, 1.42854654788971, 1.42696058750153, 1.42536580562592, 1.42377710342407, 1.42220818996429, 1.42063498497009, 1.4190788269043, 1.41753137111664, 1.41600108146667, 1.41447103023529, 1.41295301914215, 1.4114476442337, 1.40995097160339, 1.40845346450806, 1.40698778629303, 1.40551137924194, 1.40405261516571, 1.40259742736816, 1.40116059780121, 1.3997358083725, 1.39831531047821, 1.39689791202545, 1.39549911022186, 1.39410781860352, 1.39271998405457, 1.39135980606079, 1.39000308513641, 1.38864469528198, 1.38729584217072, 1.38597321510315, 1.38464510440826, 1.38332998752594, 1.38203263282776, 1.3807384967804, 1.37944805622101, 1.37817549705505, 1.3769063949585, 1.37566030025482, 1.37440776824951, 1.37317311763763, 1.37195110321045, 1.37073850631714, 1.3695240020752, 1.36833679676056, 1.367143034935, 1.36597228050232, 1.36480116844177, 1.36365175247192, 1.36249673366547, 1.36135876178741, 1.36023485660553, 1.3591091632843, 1.35800135135651, 1.35690605640411, 1.35581016540527, 1.35473656654358, 1.35366725921631, 1.35260093212128, 1.35155689716339, 1.35051250457764, 1.34948074817657, 1.34846603870392, 1.34745562076569, 1.34644854068756, 1.34545874595642, 1.34447824954987, 1.34350514411926, 1.34253668785095, 1.34159433841705, 1.34064710140228, 1.33971202373505, 1.33879029750824, 1.33841407299042, 1.33720195293427, 1.33598518371582, 1.33475804328918, 1.33353221416473, 1.33230090141296, 1.33106243610382, 1.32982206344604, 1.32857465744019, 1.32731878757477, 1.3260623216629, 1.3248051404953, 1.32354009151459, 1.32226526737213, 1.3209890127182, 1.3197101354599, 1.31842303276062, 1.31713306903839, 1.3158392906189, 1.31453442573547, 1.31323170661926, 1.3119238615036, 1.31060647964478, 1.30928778648376, 1.30796611309052, 1.30663466453552, 1.30529987812042, 1.30396151542664, 1.3026202917099, 1.3012683391571, 1.29991662502289, 1.2985588312149, 1.29719281196594, 1.29582619667053, 1.29445457458496, 1.29307472705841, 1.29169392585754, 1.29030537605286, 1.28891181945801, 1.28751420974731, 1.28611648082733, 1.28471088409424, 1.28329694271088, 1.28188037872314, 1.28046023845673, 1.27903270721436, 1.27760148048401, 1.27617001533508, 1.27472567558289, 1.27327859401703, 1.27183020114899, 1.27037143707275, 1.26891446113586, 1.26745235919952, 1.26597738265991, 1.26450371742249, 1.26302778720856, 1.26154541969299, 1.26005327701569, 1.25855994224548, 1.25706100463867, 1.25555503368378, 1.25404798984528, 1.25253736972809, 1.25101697444916, 1.24949538707733, 1.24796640872955, 1.24643111228943, 1.24489641189575, 1.24335479736328, 1.24181079864502, 1.24025642871857, 1.23884797096252, 1.23706650733948, 1.23527836799622, 1.23348879814148, 1.23169362545013, 1.22988879680634, 1.2280832529068, 1.22627425193787, 1.22445714473724, 1.22263789176941, 1.22081446647644, 1.21897900104523, 1.21714687347412, 1.21530985832214, 1.2134667634964, 1.2116140127182, 1.2097624540329, 1.20790088176727, 1.20603621006012, 1.2041677236557, 1.20229709148407, 1.20041561126709, 1.19853103160858, 1.19664597511292, 1.19474828243256, 1.19285356998444, 1.19095230102539, 1.18904316425323, 1.18712985515594, 1.18521428108215, 1.18329465389252, 1.1813657283783, 1.17943584918976, 1.17750024795532, 1.17555177211761, 1.1736079454422, 1.17166078090668, 1.16970014572144, 1.16774201393127, 1.16577792167664, 1.16380441188812, 1.16182994842529, 1.15985119342804, 1.15786743164062, 1.15587639808655, 1.15388441085815, 1.15188407897949, 1.14987635612488, 1.14786970615387, 1.14585793018341, 1.14383637905121, 1.14181077480316, 1.13978397846222, 1.13774859905243, 1.13571083545685, 1.13367140293121, 1.13162100315094, 1.12956726551056, 1.12751114368439, 1.12545156478882, 1.12338101863861, 1.12131035327911, 1.1192342042923, 1.11714684963226, 1.11506199836731, 1.11297416687012, 1.11087536811829, 1.10877656936646, 1.10667037963867, 1.1045548915863, 1.10244226455688, 1.09955477714539, 1.09736084938049, 1.09516477584839, 1.09297156333923, 1.09078454971313, 1.08860230445862, 1.08642053604126, 1.08424687385559, 1.08207261562347, 1.07989954948425, 1.07773220539093, 1.0755717754364, 1.07341253757477, 1.07125437259674, 1.06910264492035, 1.06695485115051, 1.06480765342712, 1.06266975402832, 1.06053006649017, 1.05839216709137, 1.05626046657562, 1.05413699150085, 1.0520122051239, 1.04988694190979, 1.04777264595032, 1.04565942287445, 1.04354798793793, 1.04144406318665, 1.03933894634247, 1.03723955154419, 1.0351425409317, 1.03305351734161, 1.03096222877502, 1.02887439727783, 1.02679526805878, 1.02471661567688, 1.02263975143433, 1.02057373523712, 1.01850152015686, 1.01643681526184, 1.01437890529633, 1.01232099533081, 1.01026594638824, 1.00821781158447, 1.00616919994354, 1.00412583351135, 1.00208866596222, 1.00005209445953, 0.998016715049744, 0.9959876537323, 0.99396550655365, 0.991941571235657, 0.989922285079956, 0.987906992435455, 0.985895335674286, 0.983886957168579, 0.981884956359863, 0.979881227016449, 0.977884471416473, 0.975888848304749, 0.973901271820068, 0.971913039684296, 0.969926655292511, 0.967950522899628, 0.965973854064941, 0.964000701904297, 0.962030410766602, 0.960064113140106, 0.958103060722351, 0.956141948699951, 0.954192340373993, 0.952238798141479, 0.950422942638397, 0.948768258094788, 0.947116017341614, 0.945468366146088, 0.943827569484711, 0.942199528217316, 0.940567910671234, 0.938951313495636, 0.937334775924683, 0.935726284980774, 0.934120059013367, 0.932525396347046, 0.930934190750122, 0.929347634315491, 0.927773594856262, 0.926198482513428, 0.924629211425781, 0.923073649406433, 0.921522796154022, 0.919973075389862, 0.918432593345642, 0.916895508766174, 0.915366530418396, 0.913843214511871, 0.912328004837036, 0.910815179347992, 0.909311532974243, 0.907814800739288, 0.906323790550232, 0.904831647872925, 0.903359174728394, 0.901884317398071, 0.900417566299438, 0.898955285549164, 0.897501230239868, 0.896050572395325, 0.894606828689575, 0.893174588680267, 0.891742408275604, 0.890314817428589, 0.888898730278015, 0.887486100196838, 0.886081457138062, 0.884682714939117, 0.883289694786072, 0.881901204586029, 0.880524337291718, 0.879148542881012, 0.877777457237244, 0.876415550708771, 0.875059366226196, 0.87370777130127, 0.872364282608032, 0.871028900146484, 0.869692325592041, 0.868366062641144, 0.867052495479584, 0.865736663341522, 0.864426612854004, 0.863130390644073, 0.861834168434143, 0.860545873641968, 0.859261214733124, 0.85798567533493, 0.856713652610779, 0.855448484420776, 0.854197204113007, 0.85294246673584, 0.851694583892822, 0.850458204746246, 0.849226474761963, 0.848180592060089, 0.84685093164444, 0.845527052879333, 0.844204246997833, 0.842887282371521, 0.841571509838104, 0.840263664722443, 0.838958203792572, 0.837656199932098, 0.836357653141022, 0.835062563419342, 0.83377206325531, 0.832488536834717, 0.831206083297729, 0.829926013946533, 0.828650414943695, 0.82738071680069, 0.826113283634186, 0.824848115444183, 0.823588728904724, 0.822332859039307, 0.821080327033997, 0.819833636283875, 0.818591594696045, 0.817349433898926, 0.816113173961639, 0.814882576465607, 0.813653171062469, 0.81242835521698, 0.811206996440887, 0.809986770153046, 0.808774590492249, 0.807567179203033, 0.80636078119278, 0.805156648159027, 0.803959488868713, 0.802768111228943, 0.801577866077423, 0.800391137599945, 0.799207806587219, 0.79802680015564, 0.796853721141815, 0.795683145523071, 0.794513642787933, 0.793349921703339, 0.792190730571747, 0.791035056114197, 0.78988516330719, 0.788736402988434, 0.787593364715576, 0.78645271062851, 0.785318911075592, 0.78418630361557, 0.78305596113205, 0.781931340694427, 0.780812561511993, 0.779691457748413, 0.778580784797668, 0.77747118473053, 0.776363909244537, 0.775261163711548, 0.774167716503143, 0.773073077201843, 0.771981954574585, 0.77089649438858, 0.769811153411865, 0.768732666969299, 0.767659962177277, 0.766587257385254, 0.76552027463913, 0.764456808567047, 0.763400256633759, 0.762817203998566, 0.76174795627594, 0.760686755180359, 0.759622097015381, 0.758571267127991, 0.757520437240601, 0.756478846073151, 0.755437254905701, 0.754408240318298, 0.753374755382538, 0.75235503911972, 0.751333057880402, 0.750320196151733, 0.749308586120605, 0.74830836057663, 0.747305929660797, 0.746315121650696, 0.745324194431305, 0.744343638420105, 0.743368864059448, 0.742392957210541, 0.741426169872284, 0.740459501743317, 0.73950207233429, 0.738547921180725, 0.73760199546814, 0.736657202243805, 0.735720455646515, 0.734787106513977, 0.733859598636627, 0.73293548822403, 0.732019484043121, 0.731105804443359, 0.730198979377747, 0.729295551776886, 0.728400349617004, 0.727508544921875, 0.726621389389038, 0.725742161273956, 0.724861919879913, 0.723991990089417, 0.723120868206024, 0.722262501716614, 0.721404075622559, 0.720554888248444, 0.719704568386078, 0.718863427639008, 0.718024611473083, 0.717197358608246, 0.716367721557617, 0.715549647808075, 0.714728116989136, 0.71392160654068, 0.713117361068726, 0.712314188480377, 0.711518049240112, 0.710724115371704, 0.709942936897278, 0.709157168865204, 0.708382785320282, 0.707610845565796, 0.706848084926605, 0.706084132194519, 0.705331742763519, 0.704579412937164, 0.703833818435669, 0.703089535236359, 0.702360212802887, 0.701627373695374, 0.7009037733078, 0.70018482208252, 0.699214518070221, 0.69863623380661, 0.698057770729065, 0.697488844394684, 0.696917712688446, 0.696353375911713, 0.695787310600281, 0.695230185985565, 0.694671154022217, 0.694118976593018, 0.693566739559174, 0.693019390106201, 0.692472398281097, 0.691934585571289, 0.691392064094543, 0.690858960151672, 0.690325975418091, 0.689797461032867, 0.689274072647095, 0.688748598098755, 0.688229918479919, 0.687711119651794, 0.687199771404266, 0.686685919761658, 0.686181306838989, 0.685674726963043, 0.685175120830536, 0.684673547744751, 0.684180974960327, 0.6836838722229, 0.683198571205139, 0.682708740234375, 0.682228267192841, 0.681747853755951, 0.681272387504578, 0.680801391601562, 0.68032568693161, 0.679861903190613, 0.679393529891968, 0.678934633731842, 0.678475677967072, 0.678021788597107, 0.677565276622772, 0.677120506763458, 0.67667144536972, 0.676231265068054, 0.675786793231964, 0.675354182720184, 0.674917042255402, 0.674489140510559, 0.67405891418457, 0.673635900020599, 0.673217356204987, 0.672796785831451, 0.672383189201355, 0.671969830989838, 0.671561181545258, 0.671154737472534, 0.670753180980682, 0.670349359512329, 0.669957160949707, 0.669560492038727, 0.669173061847687, 0.668781638145447, 0.668398797512054, 0.66801643371582, 0.667638719081879, 0.667261242866516, 0.666890680789948, 0.666524708271027, 0.666157186031342, 0.665826022624969, 0.665455996990204, 0.665079116821289, 0.664706587791443, 0.664329946041107, 0.663946509361267, 0.663563370704651, 0.6631800532341, 0.662792325019836, 0.66239994764328, 0.662007868289948, 0.66161572933197, 0.661214649677277, 0.660816013813019, 0.66041487455368, 0.660011887550354, 0.659601986408234, 0.659192025661469, 0.658782243728638, 0.658367931842804, 0.657949388027191, 0.657530784606934, 0.657109975814819, 0.656684696674347, 0.65625935792923, 0.655832171440125, 0.655400097370148, 0.654963850975037, 0.654527842998505, 0.654091775417328, 0.653650999069214, 0.653205633163452, 0.652760624885559, 0.65231329202652, 0.651859641075134, 0.651407957077026, 0.650953948497772, 0.65049797296524, 0.650032758712769, 0.649572432041168, 0.64910751581192, 0.648638129234314, 0.648168861865997, 0.647697329521179, 0.647223591804504, 0.646743178367615, 0.646265089511871, 0.645784795284271, 0.645302295684814, 0.644811034202576, 0.644324064254761, 0.643832623958588, 0.64333438873291, 0.642840981483459, 0.642340779304504, 0.64184045791626, 0.641334056854248, 0.640829384326935, 0.640322625637054, 0.639806747436523, 0.63929545879364, 0.638779819011688, 0.638264358043671, 0.637740075588226, 0.637217879295349, 0.636691153049469, 0.636160016059875, 0.635631263256073, 0.635100126266479, 0.634566843509674, 0.634024858474731, 0.633487403392792, 0.633096754550934, 0.632490694522858, 0.631882309913635, 0.631267011165619, 0.630644857883453, 0.630015671253204, 0.629375100135803, 0.628741323947906, 0.628089249134064, 0.627434730529785, 0.626775741577148, 0.626114308834076, 0.625434517860413, 0.624761581420898, 0.624077081680298, 0.623385787010193, 0.622687518596649, 0.621987044811249, 0.621277213096619, 0.620560526847839, 0.619839251041412, 0.619113385677338, 0.618380546569824, 0.617640852928162, 0.616891860961914, 0.616142928600311, 0.615380167961121, 0.614615142345428, 0.613847732543945, 0.613073408603668, 0.612282991409302, 0.611497163772583, 0.61070442199707, 0.609904825687408, 0.609093606472015, 0.608282446861267, 0.607462108135223, 0.606632471084595, 0.605802893638611, 0.604966342449188, 0.60412061214447, 0.603270292282104, 0.602408409118652, 0.601551175117493, 0.600682377815247, 0.599806666374207, 0.598921775817871, 0.598036885261536, 0.597140431404114, 0.59624171257019, 0.595336019992828, 0.594430387020111, 0.593499362468719, 0.592579901218414, 0.591651260852814, 0.590708792209625, 0.589768528938293, 0.588821411132812, 0.587865054607391, 0.586901783943176, 0.58593624830246, 0.584961414337158, 0.583981990814209, 0.582993447780609, 0.581997871398926, 0.581004679203033, 0.579997658729553, 0.578985929489136, 0.57796972990036, 0.576951146125793, 0.575914144515991, 0.574175357818604, 0.572969555854797, 0.57175886631012, 0.570545852184296, 0.569332718849182, 0.568108081817627, 0.566885590553284, 0.565658450126648, 0.564426422119141, 0.563192069530487, 0.561955332756042, 0.56071138381958, 0.55946296453476, 0.558214366436005, 0.556963205337524, 0.555700659751892, 0.554442465305328, 0.553177297115326, 0.551907420158386, 0.550635039806366, 0.549362599849701, 0.548076093196869, 0.546794295310974, 0.545507729053497, 0.544216513633728, 0.542920231819153, 0.541624248027802, 0.540318787097931, 0.539015650749207, 0.537705302238464, 0.536387741565704, 0.535074889659882, 0.533752858638763, 0.532423615455627, 0.531099021434784, 0.529764890670776, 0.528428614139557, 0.527087450027466, 0.525748729705811, 0.524395704269409, 0.523047029972076, 0.521694004535675, 0.520331561565399, 0.518973767757416, 0.517606377601624, 0.516232252120972, 0.514862537384033, 0.513485610485077, 0.512101769447327, 0.510720014572144, 0.509331285953522, 0.507937967777252, 0.506542205810547, 0.505144119262695, 0.503736555576324, 0.502328932285309, 0.500921249389648, 0.499501824378967, 0.498086899518967, 0.496667236089706, 0.495240479707718, 0.493809133768082, 0.492377787828445, 0.490943849086761, 0.489498406648636, 0.4880550801754, 0.486607164144516, 0.485152065753937, 0.483696669340134, 0.482241421937943, 0.480772197246552, 0.479309886693954, 0.47825762629509, 0.47676032781601, 0.475263148546219, 0.473761081695557, 0.472277462482452, 0.470788925886154, 0.469309478998184, 0.467834770679474, 0.466355204582214, 0.464894026517868, 0.46343269944191, 0.461966663599014, 0.460514426231384, 0.45906189084053, 0.457614153623581, 0.456175029277802, 0.454736173152924, 0.453306406736374, 0.45188096165657, 0.450451076030731, 0.449034690856934, 0.447613745927811, 0.446206301450729, 0.444803476333618, 0.443396061658859, 0.441997408866882, 0.440608233213425, 0.439218640327454, 0.437838435173035, 0.436448752880096, 0.435077428817749, 0.43371045589447, 0.432334423065186, 0.430976569652557, 0.429622977972031, 0.428264915943146, 0.426916092634201, 0.425567001104355, 0.424231737852097, 0.422900915145874, 0.421560764312744, 0.420238852500916, 0.418912380933762, 0.417594939470291, 0.416281670331955, 0.414968758821487, 0.413664728403091, 0.412365257740021, 0.411065727472305, 0.409779995679855, 0.408484637737274, 0.407203376293182, 0.405931025743484, 0.404649138450623, 0.403381168842316, 0.402117609977722, 0.400854021310806, 0.399599581956863, 0.398340463638306, 0.397099554538727, 0.395858585834503, 0.394613027572632, 0.393380701541901, 0.392153322696686, 0.390921205282211, 0.389702558517456, 0.388479501008987, 0.387269914150238, 0.386069595813751, 0.384855151176453, 0.383659303188324, 0.382938176393509, 0.381928831338882, 0.380933314561844, 0.379942387342453, 0.37896528840065, 0.377983629703522, 0.377020329236984, 0.376075565814972, 0.375126123428345, 0.374185919761658, 0.373254895210266, 0.372337728738785, 0.371429771184921, 0.370521813631058, 0.369623124599457, 0.368742793798447, 0.367857873439789, 0.366996049880981, 0.366138815879822, 0.3652723133564, 0.364438086748123, 0.363603919744492, 0.362774312496185, 0.361963152885437, 0.361151993274689, 0.360354661941528, 0.359557300806046, 0.358769178390503, 0.357999503612518, 0.357234418392181, 0.356473982334137, 0.355731934309006, 0.354985296726227, 0.354261696338654, 0.353533506393433, 0.352814525365829, 0.352113991975784, 0.351408809423447, 0.350726693868637, 0.35004460811615, 0.349385499954224, 0.348712623119354, 0.348058134317398, 0.347408294677734, 0.346776872873306, 0.34614086151123, 0.34552788734436, 0.34491029381752, 0.344315707683563, 0.343707382678986, 0.343135863542557, 0.342550545930862, 0.341983646154404, 0.341430574655533, 0.340872883796692, 0.340329051017761, 0.339785188436508, 0.339264422655106, 0.338752835988998, 0.338241249322891, 0.33774346113205, 0.337259560823441, 0.336775600910187, 0.336291670799255, 0.335826188325882, 0.335374534130096, 0.334927469491959, 0.334480375051498, 0.334051758050919, 0.333641588687897, 0.333208352327347, 0.33280736207962, 0.332104533910751, 0.331887930631638, 0.331674814224243, 0.331463932991028, 0.331248462200165, 0.331053733825684, 0.330844044685364, 0.330647021532059, 0.330447673797607, 0.330256432294846, 0.330063998699188, 0.329874992370605, 0.329676806926727, 0.329494774341583, 0.329310446977615, 0.329132974147797, 0.32896015048027, 0.328789621591568, 0.328617930412292, 0.328440517187119, 0.328275710344315, 0.328113287687302, 0.327954232692719, 0.327798694372177, 0.327640861272812, 0.327492237091064, 0.327345907688141, 0.32718688249588, 0.327041745185852, 0.326901108026505, 0.326762855052948, 0.326628029346466, 0.326495558023453, 0.326363027095795, 0.326232850551605, 0.32610610127449, 0.325982809066772, 0.325861841440201, 0.325744301080704, 0.325630247592926, 0.325509250164032, 0.325397491455078, 0.325292646884918, 0.325185477733612, 0.325081795454025, 0.324986129999161, 0.324890524148941, 0.324797183275223, 0.324698090553284, 0.324610531330109, 0.324522942304611, 0.324441134929657, 0.324354708194733, 0.324280977249146, 0.32420489192009, 0.324138104915619, 0.324058592319489, 0.323988288640976, 0.323922634124756, 0.323863834142685, 0.323801666498184, 0.323734819889069, 0.323688715696335, 0.32362762093544, 0.323585003614426, 0.323538959026337, 0.323492825031281, 0.323453664779663, 0.323416769504547, 0.323370724916458, 0.323336154222488, 0.323345363140106, 0.32317253947258, 0.322995066642761, 0.322817623615265, 0.322635561227798, 0.322448939085007, 0.322251886129379, 0.322054862976074, 0.321853250265121, 0.321650445461273, 0.321439564228058, 0.321219503879547, 0.32100173830986, 0.320777028799057, 0.320548892021179, 0.320313841104507, 0.320076465606689, 0.319829910993576, 0.319579899311066, 0.319326400756836, 0.319068312644958, 0.318806737661362, 0.31854173541069, 0.318270981311798, 0.317995578050613, 0.317715555429459, 0.317432135343552, 0.317136019468307, 0.31684336066246, 0.316543757915497, 0.316243052482605, 0.315934270620346, 0.315622001886368, 0.315298199653625, 0.314976722002029, 0.314651846885681, 0.314319968223572, 0.313990443944931, 0.313649356365204, 0.313299119472504, 0.312951117753983, 0.31259623169899, 0.312239050865173, 0.311873823404312, 0.311503946781158, 0.311131775379181, 0.310754954814911, 0.310374766588211, 0.309987604618073, 0.309596985578537, 0.309196025133133, 0.308796226978302, 0.308392941951752, 0.30798277258873, 0.307570219039917, 0.307147413492203, 0.306722193956375, 0.306294709444046, 0.305862665176392, 0.305429428815842, 0.304983526468277, 0.304535269737244, 0.304085910320282, 0.303631961345673, 0.30316761136055, 0.302703261375427, 0.302227377891541, 0.301754981279373, 0.301276803016663, 0.300791710615158, 0.300306618213654, 0.299834281206131, 0.299126833677292, 0.298418194055557, 0.297708421945572, 0.296994060277939, 0.296276211738586, 0.295552611351013, 0.294830143451691, 0.294108897447586, 0.29338413476944, 0.292654782533646, 0.291920840740204, 0.29118686914444, 0.290454030036926, 0.289721220731735, 0.288982659578323, 0.288238286972046, 0.287494003772736, 0.286747336387634, 0.285999536514282, 0.285248309373856, 0.28449934720993, 0.283738881349564, 0.28298419713974, 0.282222598791122, 0.281464397907257, 0.28070279955864, 0.279933124780655, 0.279168039560318, 0.278398334980011, 0.277624070644379, 0.276849776506424, 0.276075482368469, 0.275290817022324, 0.274509638547897, 0.273728400468826, 0.272944897413254, 0.272154480218887, 0.271361738443375, 0.270569026470184, 0.269780904054642, 0.268983572721481, 0.268187373876572, 0.267385423183441, 0.266578882932663, 0.265772312879562, 0.264965772628784, 0.26415690779686, 0.263346910476685, 0.262527674436569, 0.261713057756424, 0.260893821716309, 0.260076910257339, 0.259253054857254, 0.258429229259491, 0.257598459720612, 0.256767719984055, 0.255938112735748, 0.255103915929794, 0.25426971912384, 0.253426283597946, 0.252588629722595, 0.251741737127304, 0.250904053449631, 0.250056028366089, 0.249209150671959, 0.248350769281387, 0.247499272227287, 0.24664431810379, 0.245787054300308, 0.24492634832859, 0.244059890508652, 0.243280977010727, 0.242509007453918, 0.241735845804214, 0.240970775485039, 0.240210324525833, 0.239448711276054, 0.23869514465332, 0.237943887710571, 0.237198412418365, 0.236451774835587, 0.235710889101028, 0.234975785017014, 0.234244123101234, 0.233513608574867, 0.232788860797882, 0.232068717479706, 0.231349736452103, 0.230634197592735, 0.229929059743881, 0.229220435023308, 0.228517577052116, 0.227815881371498, 0.227125704288483, 0.22643207013607, 0.225744187831879, 0.225056320428848, 0.224379941821098, 0.223701283335686, 0.223029553890228, 0.22236356139183, 0.221696436405182, 0.221033915877342, 0.220373675227165, 0.219724982976913, 0.219072833657265, 0.218424126505852, 0.217781201004982, 0.217145174741745, 0.216509133577347, 0.215875416994095, 0.215252071619034, 0.214625239372253, 0.214005365967751, 0.213386610150337, 0.212777093052864, 0.212167575955391, 0.211559191346169, 0.210956588387489, 0.210359737277031, 0.209767505526543, 0.209175258874893, 0.208589926362038, 0.208006903529167, 0.207426190376282, 0.206851229071617, 0.206283181905746, 0.205713972449303, 0.205144792795181, 0.20458596944809, 0.204031735658646, 0.203478679060936, 0.202925607562065, 0.202384054660797, 0.201841369271278, 0.20130443572998, 0.200765207409859, 0.200239777565002, 0.19970977306366, 0.199186652898788, 0.198665857315063, 0.198155418038368, 0.19758103787899, 0.197215214371681, 0.196858584880829, 0.196501404047012, 0.196147680282593, 0.195795103907585, 0.19544942677021, 0.195106074213982, 0.194763273000717, 0.194424524903297, 0.194093853235245, 0.193759128451347, 0.193431317806244, 0.193108126521111, 0.192786663770676, 0.192467495799065, 0.192151203751564, 0.191841840744019, 0.191533014178276, 0.191224813461304, 0.190920621156693, 0.190625086426735, 0.190327808260918, 0.19003227353096, 0.189746513962746, 0.189459040760994, 0.189172714948654, 0.188893288373947, 0.188618496060371, 0.188344851136208, 0.188073486089706, 0.187802150845528, 0.187540575861931, 0.187280759215355, 0.187020346522331, 0.186770334839821, 0.186517417430878, 0.186267375946045, 0.18602080643177, 0.185782879590988, 0.185543790459633, 0.185305863618851, 0.18507194519043, 0.184848427772522, 0.184619128704071, 0.184396177530289, 0.184180706739426, 0.183960050344467, 0.183747485280037, 0.18353545665741, 0.183332681655884, 0.183128729462624, 0.182924211025238, 0.182728350162506, 0.182536497712135, 0.182342931628227, 0.182156845927238, 0.18197363615036, 0.181792736053467, 0.181612402200699, 0.181435540318489, 0.181267902255058, 0.181100815534592, 0.180930867791176, 0.180771872401237, 0.180612862110138, 0.180453270673752, 0.180302336812019, 0.180156573653221, 0.180006802082062, 0.179863348603249, 0.179724499583244, 0.179475143551826, 0.179287314414978, 0.179098337888718, 0.178909376263618, 0.178721576929092, 0.178532615303993, 0.178343072533607, 0.17815525829792, 0.177966296672821, 0.177778467535973, 0.177588924765587, 0.177401125431061, 0.177211582660675, 0.177023202180862, 0.17683482170105, 0.176646411418915, 0.176457449793816, 0.176269054412842, 0.176080092787743, 0.17589171230793, 0.175702750682831, 0.175514355301857, 0.175325974822044, 0.175136998295784, 0.174949765205383, 0.174759089946747, 0.174570664763451, 0.174382865428925, 0.174194484949112, 0.174004942178726, 0.173816561698914, 0.173629313707352, 0.173439756035805, 0.173250794410706, 0.173061832785606, 0.17287403345108, 0.172685071825981, 0.172496110200882, 0.172308295965195, 0.172119319438934, 0.171931505203247, 0.171741396188736, 0.171553581953049, 0.171365782618523, 0.17117565870285, 0.170987859368324, 0.170798867940903, 0.17061048746109, 0.170422092080116, 0.170232564210892, 0.170044749975204, 0.169856369495392, 0.169666811823845, 0.169479012489319, 0.169289469718933, 0.169101074337959, 0.168913260102272, 0.168724283576012, 0.168534740805626, 0.168347522616386, 0.168158560991287, 0.167970165610313, 0.167781203985214, 0.16759167611599, 0.167403265833855, 0.167214870452881, 0.167027071118355, 0.166838690638542, 0.16664856672287, 0.166460767388344, 0.166272357106209, 0.16603672504425, 0.165786102414131, 0.165533795952797, 0.165283188223839, 0.165031418204308, 0.164780229330063, 0.164527893066406, 0.164276704192162, 0.164025515317917, 0.16377317905426, 0.163522005081177, 0.163270816206932, 0.163019627332687, 0.162767291069031, 0.162516683340073, 0.162264928221703, 0.162013158202171, 0.161761969327927, 0.161510780453682, 0.161258459091187, 0.161007285118103, 0.160754933953285, 0.160505473613739, 0.160253137350082, 0.160001948475838, 0.159749045968056, 0.159498423337936, 0.159247264266014, 0.158994913101196, 0.158743157982826, 0.158492535352707, 0.158240780234337, 0.15798844397068, 0.157737836241722, 0.157486647367477, 0.157234877347946, 0.156983137130737, 0.156731933355331, 0.156480193138123, 0.156228423118591, 0.15597665309906, 0.155726045370102, 0.155474275350571, 0.155223086476326, 0.154971361160278, 0.154719591140747, 0.154468983411789, 0.154216051101685, 0.153964877128601, 0.153713688254356, 0.1534613519907, 0.153211325407028, 0.15295897424221, 0.152707785367966, 0.152456045150757, 0.152204290032387, 0.151953667402267, 0.151701331138611, 0.15144956111908, 0.151198953390121, 0.150946617126465, 0.150694280862808, 0.150444239377975, 0.150193080306053, 0.149941310286522, 0.149689540266991, 0.149438351392746, 0.149186596274376, 0.148934841156006, 0.148683071136475, 0.14843188226223, 0.148178994655609, 0.148034393787384, 0.147814899682999, 0.147597134113312, 0.147379964590073, 0.147164478898048, 0.146949023008347, 0.146734118461609, 0.146520391106606, 0.146306648850441, 0.146096378564835, 0.14588551223278, 0.145675823092461, 0.14546725153923, 0.145258694887161, 0.145050168037415, 0.144843891263008, 0.144638225436211, 0.144433721899986, 0.144229203462601, 0.144026398658752, 0.143825337290764, 0.143624857068062, 0.143424957990646, 0.14322504401207, 0.143025696277618, 0.142828091979027, 0.142631053924561, 0.142435193061829, 0.142239883542061, 0.142045170068741, 0.141852155327797, 0.141659751534462, 0.141470208764076, 0.141279518604279, 0.141089394688606, 0.140899851918221, 0.140711471438408, 0.140524804592133, 0.140338152647018, 0.140152648091316, 0.139968290925026, 0.139783933758736, 0.139603033661842, 0.139420986175537, 0.139240086078644, 0.139059752225876, 0.13887944817543, 0.138701424002647, 0.138523980975151, 0.138348266482353, 0.138172551989555, 0.137997403740883, 0.137823432683945, 0.137650594115257, 0.13747949898243, 0.137307241559029, 0.137137278914452, 0.136967912316322, 0.136797949671745, 0.136630311608315, 0.136463239789009, 0.136297881603241, 0.136132538318634, 0.135968342423439, 0.135805308818817, 0.135642275214195, 0.135482117533684, 0.13532081246376, 0.135160654783249, 0.135001644492149, 0.134843215346336, 0.134730860590935, 0.13457415997982, 0.134419769048691, 0.134265378117561, 0.134111553430557, 0.133957728743553, 0.133806198835373, 0.133656427264214, 0.13350547850132, 0.133356273174286, 0.133208781480789, 0.133060142397881, 0.132914394140244, 0.13276806473732, 0.132622882723808, 0.132478848099709, 0.132335975766182, 0.132193103432655, 0.132053107023239, 0.131913110613823, 0.131773114204407, 0.131633698940277, 0.131495431065559, 0.131359472870827, 0.131222367286682, 0.131087556481361, 0.130955040454865, 0.130820229649544, 0.130687728524208, 0.130556374788284, 0.130425006151199, 0.130295976996422, 0.130166351795197, 0.130037873983383, 0.129911124706268, 0.129786118865013, 0.129659935832024, 0.129534929990768, 0.129411652684212, 0.129288360476494, 0.129166215658188, 0.129044651985168, 0.128925412893295, 0.128806158900261, 0.128686904907227, 0.128569364547729, 0.128453001379967, 0.128337189555168, 0.128222554922104, 0.128107905387878, 0.127994984388351, 0.127883225679398, 0.127771466970444, 0.127661421895027, 0.127551376819611, 0.127441912889481, 0.127334773540497, 0.127227023243904, 0.127120450139046, 0.127016171813011, 0.126911908388138, 0.126807615160942, 0.126705065369606, 0.126603096723557, 0.126503437757492, 0.126403197646141, 0.126303523778915, 0.126205012202263, 0.126108229160309, 0.126012578606606, 0.125916957855225, 0.125736057758331, 0.125664904713631, 0.125594332814217, 0.125525206327438, 0.125454634428024, 0.125384628772736, 0.125316649675369, 0.125246077775955, 0.12517723441124, 0.125108376145363, 0.125040113925934, 0.124971278011799, 0.124902717769146, 0.124835886061192, 0.124768197536469, 0.124700218439102, 0.124632813036442, 0.124565407633781, 0.124498575925827, 0.124431744217873, 0.124364912509918, 0.124299809336662, 0.124233849346638, 0.124167889356613, 0.124102212488651, 0.124036818742752, 0.12397114187479, 0.123906336724758, 0.123840942978859, 0.123778142035007, 0.123713627457619, 0.123649097979069, 0.123585730791092, 0.123522065579891, 0.123458124697208, 0.123395033180714, 0.123331665992737, 0.123270303010941, 0.123207800090313, 0.123145006597042, 0.12308306992054, 0.123021140694618, 0.12295950204134, 0.122898422181606, 0.122837357223034, 0.122776292264462, 0.122715801000595, 0.122655309736729, 0.122594237327576, 0.122535198926926, 0.122475266456604, 0.122415065765381, 0.12235601246357, 0.122296683490276, 0.122238487005234, 0.122179724276066, 0.122120670974255, 0.122062496840954, 0.122004024684429, 0.121945537626743, 0.121888220310211, 0.121831178665161, 0.121773287653923, 0.121717691421509, 0.121660366654396, 0.121603325009346, 0.121547736227512, 0.121490992605686, 0.121435105800629, 0.121379226446152, 0.121323630213737, 0.121268041431904, 0.121277116239071, 0.121213465929031, 0.121149510145187, 0.121082969009876, 0.121017299592495, 0.120949029922485, 0.120881624519825, 0.12081190943718, 0.120741046965122, 0.120670191943645, 0.120598457753658, 0.12052645534277, 0.120452702045441, 0.12037867307663, 0.12030291557312, 0.120227448642254, 0.120149381458759, 0.120073050260544, 0.119993254542351, 0.119914330542088, 0.119833379983902, 0.119751289486885, 0.119668617844582, 0.119585081934929, 0.119501829147339, 0.119415991008282, 0.119331300258636, 0.119243741035461, 0.119156740605831, 0.11906860023737, 0.118978142738342, 0.118888854980469, 0.118796959519386, 0.118705354630947, 0.118613183498383, 0.118518121540546, 0.118423640727997, 0.118327714502811, 0.118231505155563, 0.118134714663029, 0.118035912513733, 0.11793740093708, 0.117836870253086, 0.117736905813217, 0.117634937167168, 0.117532387375832, 0.117428407073021, 0.117324985563755, 0.117220140993595, 0.117112398147583, 0.117005251348019, 0.116897225379944, 0.116788916289806, 0.11667887866497, 0.116569131612778, 0.116457082331181, 0.116345316171646, 0.116232395172119, 0.116117738187313, 0.116003677248955, 0.115887299180031, 0.115770921111107, 0.115651667118073, 0.115534730255604, 0.115414887666702, 0.115294776856899, 0.115173786878586, 0.115051075816154, 0.114929512143135, 0.114805355668068, 0.114681221544743, 0.114543236792088, 0.1143479347229, 0.114150322973728, 0.113956175744534, 0.113757990300655, 0.113561533391476, 0.113369688391685, 0.113170936703682, 0.112976789474487, 0.112783789634705, 0.112588480114937, 0.112394914031029, 0.112201914191246, 0.112009488046169, 0.111814767122269, 0.111621759831905, 0.111428186297417, 0.111235782504082, 0.111043356359005, 0.11084920167923, 0.110658504068851, 0.11046551913023, 0.110274821519852, 0.110084123909473, 0.109892286360264, 0.109701588749886, 0.109509751200676, 0.109320774674416, 0.109130650758743, 0.108940541744232, 0.108748115599155, 0.108558587729931, 0.108369037508965, 0.108180075883865, 0.107990525662899, 0.107802145183086, 0.107614912092686, 0.1074253693223, 0.107238136231899, 0.107050314545631, 0.106862500309944, 0.106673538684845, 0.106487452983856, 0.106299065053463, 0.106111250817776, 0.105925172567368, 0.105738513171673, 0.105554729700089, 0.105366341769695, 0.105182565748692, 0.104996480047703, 0.104812122881413, 0.104627773165703, 0.104442834854126, 0.104257330298424, 0.104071825742722, 0.103889189660549, 0.103701956570148, 0.103519901633263, 0.103336125612259, 0.103152923285961, 0.102970287203789, 0.102789387106895, 0.102605611085892, 0.102423563599586, 0.102241508662701, 0.102056570351124, 0.101876825094223, 0.101695343852043, 0.101513877511024, 0.101332403719425, 0.101150929927826, 0.100882664322853, 0.100758224725723, 0.100636079907417, 0.10051741451025, 0.100398726761341, 0.100281208753586, 0.100164830684662, 0.100053071975708, 0.0999424457550049, 0.099831834435463, 0.0997246876358986, 0.099618673324585, 0.099514976143837, 0.099414736032486, 0.0993133410811424, 0.0992142483592033, 0.0991197675466537, 0.0990195199847221, 0.0989261865615845, 0.0988351628184319, 0.0987441465258598, 0.0986565724015236, 0.0985701531171799, 0.0984860435128212, 0.0984030812978745, 0.0983224287629128, 0.098242923617363, 0.0981657281517982, 0.098090834915638, 0.0980159416794777, 0.0979433506727219, 0.097871907055378, 0.0978004708886147, 0.0977336391806602, 0.0976691246032715, 0.0976057499647141, 0.0975446775555611, 0.0974847674369812, 0.0974260047078133, 0.0973706915974617, 0.0973142310976982, 0.0972623825073242, 0.0972105339169502, 0.0971598401665688, 0.0971114486455917, 0.0970665067434311, 0.097021572291851, 0.0969789400696754, 0.0969374626874924, 0.0968994349241257, 0.096863716840744, 0.0968268513679504, 0.0967945829033852, 0.0967623218894005, 0.0967300534248352, 0.0967035517096519, 0.0966782122850418, 0.0966517105698586, 0.0966298207640648, 0.096605621278286, 0.0965871810913086, 0.0965699106454849, 0.0965526178479195, 0.0965399444103241, 0.0965284109115601, 0.0965145900845528, 0.0965088307857513, 0.0964973121881485, 0.096492700278759, 0.0964892506599426, 0.0964880958199501, 0.0965612530708313, 0.0966107994318008, 0.0966626554727554, 0.0967144966125488, 0.096766360104084, 0.0968193560838699, 0.0968717858195305, 0.0969259440898895, 0.0969795137643814, 0.0970330983400345, 0.0970878228545189, 0.0971437022089958, 0.0971984416246414, 0.0972514450550079, 0.0973096266388893, 0.0973660871386528, 0.0974208191037178, 0.0974766984581947, 0.0975337252020836, 0.0975919216871262, 0.0976501032710075, 0.0977077186107635, 0.0977664813399315, 0.097825825214386, 0.097883440554142, 0.0979427695274353, 0.0980026945471764, 0.0980620235204697, 0.0981207862496376, 0.098181277513504, 0.098242923617363, 0.0983045697212219, 0.0983667895197868, 0.0984278544783592, 0.0984912291169167, 0.0985534489154816, 0.098617397248745, 0.0986801907420158, 0.0987435653805733, 0.0988080874085426, 0.0988708883523941, 0.0989354103803635, 0.0989999398589134, 0.0990644618868828, 0.09913070499897, 0.099198117852211, 0.0992637872695923, 0.0993294715881348, 0.0993968769907951, 0.0994637012481689, 0.0995328426361084, 0.0996008142828941, 0.0996682196855545, 0.0997373536229134, 0.0998059064149857, 0.0998762026429176, 0.0999435931444168, 0.100012741982937, 0.100083597004414, 0.10015445202589, 0.100225321948528, 0.100297920405865, 0.100367620587349, 0.10044077783823, 0.100511647760868, 0.10058481246233, 0.100659132003784, 0.10073172301054, 0.100803151726723, 0.100877471268177, 0.100950069725513, 0.101026117801666, 0.101136729121208, 0.101160354912281, 0.101181089878082, 0.101200677454472, 0.101221412420273, 0.101238697767258, 0.101256556808949, 0.101272113621235, 0.101287096738815, 0.101300917565823, 0.101313017308712, 0.101325117051601, 0.101334907114506, 0.101344704627991, 0.101352766156197, 0.101360261440277, 0.101366020739079, 0.101370044052601, 0.101373508572578, 0.101375810801983, 0.101377539336681, 0.101377539336681, 0.101376965641975, 0.101374663412571, 0.101371198892593, 0.101367749273777, 0.101361982524395, 0.10135680437088, 0.101348161697388, 0.101338945329189, 0.101330302655697, 0.101319350302219, 0.101307258009911, 0.101294003427029, 0.101280175149441, 0.101265199482441, 0.101247914135456, 0.101230636239052, 0.101211629807949, 0.101192027330399, 0.101171299815178, 0.101148821413517, 0.101125203073025, 0.10110042989254, 0.10107509046793, 0.101048581302166, 0.101021505892277, 0.100992120802402, 0.100962735712528, 0.10093105584383, 0.100898794829845, 0.100865960121155, 0.100831389427185, 0.10079625248909, 0.100758798420429, 0.100722499191761, 0.100682750344276, 0.100642420351505, 0.100601516664028, 0.100558884441853, 0.100516259670258, 0.100471891462803, 0.100425809621811, 0.100379720330238, 0.100330173969269, 0.100281782448292, 0.100232236087322, 0.100181542336941, 0.100128531455994, 0.100074380636215, 0.100020803511143, 0.0999451205134392, 0.0998630225658417, 0.0997791960835457, 0.0996962487697601, 0.0996109843254089, 0.0995271578431129, 0.0994424670934677, 0.0993563309311867, 0.0992713570594788, 0.0991846546530724, 0.0990982353687286, 0.0990115404129028, 0.09892338514328, 0.0988363921642303, 0.0987470895051956, 0.0986601039767265, 0.0985702276229858, 0.0984806418418884, 0.098391056060791, 0.0983005985617638, 0.0982101634144783, 0.098119705915451, 0.0980289727449417, 0.0979359298944473, 0.0978443250060081, 0.0977515801787376, 0.0976585298776627, 0.0975657850503922, 0.0974710062146187, 0.0973773822188377, 0.0972826182842255, 0.0971869826316833, 0.0970922112464905, 0.0969960018992424, 0.0969009473919868, 0.0968035832047462, 0.0967070832848549, 0.0966091379523277, 0.0965109243988991, 0.0964129790663719, 0.0963141694664955, 0.0962159484624863, 0.0961157083511353, 0.0960151702165604, 0.095916360616684, 0.095814973115921, 0.0957138612866402, 0.0956121832132339, 0.0955107808113098, 0.0954079478979111, 0.0953062623739243, 0.0952025651931763, 0.0950985699892044, 0.0949951633810997, 0.0948908850550652, 0.0947866067290306, 0.0946811810135841, 0.0945748835802078, 0.0944697484374046, 0.0943625867366791, 0.0942571610212326, 0.0941497161984444, 0.0940425619482994, 0.0939348265528679, 0.0938256606459618, 0.0937173515558243, 0.093607597053051, 0.0934987142682076, 0.0933883860707283, 0.0932792127132416, 0.0931674540042877, 0.0930625945329666, 0.093016505241394, 0.0929701253771782, 0.0929220244288445, 0.0928742066025734, 0.092826671898365, 0.0927756875753403, 0.0927247032523155, 0.0926748663187027, 0.0926227271556854, 0.0925700142979622, 0.0925155803561211, 0.0924614146351814, 0.0924061164259911, 0.0923516675829887, 0.092294342815876, 0.0922367349267006, 0.0921785533428192, 0.0921206474304199, 0.0920601561665535, 0.0919990837574005, 0.0919383093714714, 0.0918752253055573, 0.0918130129575729, 0.0917490571737289, 0.0916836634278297, 0.0916188508272171, 0.0915534645318985, 0.0914863497018814, 0.0914186537265778, 0.0913495272397995, 0.0912792310118675, 0.0912106782197952, 0.0911401063203812, 0.0910680890083313, 0.0909946411848068, 0.0909217596054077, 0.0908485874533653, 0.0907731205224991, 0.0906964987516403, 0.0906201675534248, 0.0905455574393272, 0.0904669240117073, 0.0903877094388008, 0.0903070494532585, 0.0902269706130028, 0.0901471748948097, 0.0900647863745689, 0.0899806842207909, 0.0898962840437889, 0.0898124575614929, 0.0897289216518402, 0.0896430835127831, 0.0895560830831528, 0.0894682258367538, 0.0893803685903549, 0.0892904996871948, 0.0892009139060974, 0.0891101807355881, 0.0890185758471489, 0.0889284163713455, 0.0888359472155571, 0.0887411832809448, 0.0886466950178146, 0.0885510519146919, 0.0884548500180244, 0.0883574783802032, 0.0882601216435432, 0.0881607383489609, 0.0880636721849442, 0.0879639983177185, 0.0878626108169556, 0.0876286774873734, 0.0874869450926781, 0.087341770529747, 0.0871954336762428, 0.0870467945933342, 0.0868958607316017, 0.0867472216486931, 0.0865928307175636, 0.0864361301064491, 0.086277112364769, 0.0861169621348381, 0.0859545022249222, 0.0857908725738525, 0.0856249630451202, 0.0854567363858223, 0.0852896645665169, 0.0851168259978294, 0.0849428474903107, 0.0847688540816307, 0.084590271115303, 0.0844105258584023, 0.0842296183109283, 0.0840464234352112, 0.0838609114289284, 0.0836731046438217, 0.0834852829575539, 0.0832951739430428, 0.0831016004085541, 0.0829057171940804, 0.0827086865901947, 0.0825105085968971, 0.0823100209236145, 0.0821072310209274, 0.0819009840488434, 0.0816970393061638, 0.0814884826540947, 0.0812764763832092, 0.0810644701123238, 0.0808501616120338, 0.0806346908211708, 0.0804146230220795, 0.0801945477724075, 0.0799733176827431, 0.0797509327530861, 0.0795239582657814, 0.079295814037323, 0.0790665224194527, 0.0788337662816048, 0.0785998702049255, 0.0783625096082687, 0.0781251564621925, 0.0778854936361313, 0.0776481404900551, 0.0774027109146118, 0.0771572962403297, 0.076909564435482, 0.0766618400812149, 0.0764095038175583, 0.0761571601033211, 0.0759013742208481, 0.07564327865839, 0.0753851756453514, 0.0751259177923203, 0.0748632177710533, 0.0745982080698013, 0.0743297412991524, 0.0740612745285034, 0.0737904980778694, 0.0735185742378235, 0.0732432007789612, 0.0729655176401138, 0.0726060196757317, 0.072244219481945, 0.0718835815787315, 0.0715206265449524, 0.0711599811911583, 0.0707993358373642, 0.0704386904835701, 0.0700768977403641, 0.0697173997759819, 0.0693590641021729, 0.0690007209777832, 0.0686366260051727, 0.0682817399501801, 0.0679245442152023, 0.0675662085413933, 0.0672101750969887, 0.0668472200632095, 0.0664946436882019, 0.0661339983344078, 0.0657814219594002, 0.065425381064415, 0.0650693401694298, 0.0647144690155983, 0.0643549710512161, 0.0640023872256279, 0.0636498108506203, 0.0632972344756126, 0.06294234842062, 0.0625886172056198, 0.0622314289212227, 0.0618776977062225, 0.0615297220647335, 0.0611759945750237, 0.0608257167041302, 0.0604708343744278, 0.0601171031594276, 0.0597668252885342, 0.0594177059829235, 0.059070885181427, 0.0587194561958313, 0.0583703368902206, 0.0580177530646324, 0.0576674826443195, 0.0573218166828156, 0.0569738447666168, 0.0566224157810211, 0.0562779046595097, 0.0559253208339214, 0.0555785037577152, 0.0552328452467918, 0.0548871755599976, 0.0545449666678905, 0.0541935414075851, 0.0538501739501953, 0.0535045117139816, 0.0531565397977829, 0.0528154782950878, 0.0524709671735764, 0.0521287582814693, 0.0517807863652706, 0.0514374263584614, 0.0510952211916447, 0.0507530048489571, 0.0504131019115448, 0.0500697419047356, 0.0497286841273308, 0.0493830181658268, 0.0490431115031242, 0.0487020537257195, 0.0483598448336124, 0.0480187870562077, 0.0476777330040932, 0.047453049570322, 0.0472041666507721, 0.0469598993659019, 0.0467133186757565, 0.0464736633002758, 0.0462293885648251, 0.045994333922863, 0.0457592830061913, 0.0455288402736187, 0.0452983975410461, 0.045070257037878, 0.0448444187641144, 0.0446208864450455, 0.0444065779447556, 0.0441876575350761, 0.0439710356295109, 0.0437544174492359, 0.0435470193624496, 0.0433396212756634, 0.0431345291435719, 0.0429294295608997, 0.0427312478423119, 0.042533066123724, 0.0423325784504414, 0.0421436131000519, 0.0419523455202579, 0.0417633801698685, 0.0415790304541588, 0.0413900651037693, 0.041212622076273, 0.0410328730940819, 0.0408577397465706, 0.0406849049031734, 0.0405143760144711, 0.0403484553098679, 0.040175624191761, 0.0400166176259518, 0.0398576073348522, 0.0397009067237377, 0.039539597928524, 0.0393828935921192, 0.0392354130744934, 0.039087925106287, 0.0389381386339664, 0.0387929566204548, 0.0386569947004318, 0.0385141186416149, 0.0383758582174778, 0.038244504481554, 0.0381131507456303, 0.0379817932844162, 0.0378527455031872, 0.0377329178154469, 0.0376107841730118, 0.0374909453094006, 0.0373757258057594, 0.0372605063021183, 0.0371452867984772, 0.0370392836630344, 0.0369286648929119, 0.0368272699415684, 0.0367212668061256, 0.0366221778094769, 0.0365276895463467, 0.0364332087337971, 0.0363410301506519, 0.0362465493381023, 0.0361612886190414, 0.0360760278999805, 0.0359953679144382, 0.0359193198382854, 0.035882581025362, 0.0358434058725834, 0.03580192476511, 0.0357673615217209, 0.0357304885983467, 0.0356913134455681, 0.0356590487062931, 0.035624485462904, 0.0355945266783237, 0.0355599597096443, 0.0355323068797588, 0.0355046540498734, 0.0354746952652931, 0.0354493483901024, 0.0354216918349266, 0.0353986509144306, 0.0353779084980488, 0.0353548638522625, 0.0353364311158657, 0.0353133864700794, 0.0352972522377968, 0.0352811217308044, 0.0352626889944077, 0.0352488607168198, 0.0352350324392319, 0.0352235101163387, 0.0352073833346367, 0.0352004654705524, 0.0351935550570488, 0.0351820327341557, 0.0351797267794609, 0.0351705104112625, 0.0351659022271633, 0.0351635962724686, 0.0351612940430641, 0.0351612940430641, 0.0351589880883694, 0.0351635962724686, 0.0351659022271633, 0.0351659022271633, 0.0351751185953617, 0.0351774208247662, 0.0351866409182549, 0.0351958572864532, 0.0352027714252472, 0.0352165997028351, 0.0352235101163387, 0.0352396443486214, 0.0352511629462242, 0.0352672971785069, 0.0352857299149036, 0.0353018641471863, 0.0353202968835831, 0.0353364311158657, 0.0353617779910564, 0.0353848226368427, 0.0354055613279343, 0.0354332141578197, 0.035456258803606, 0.0354839116334915, 0.0355115681886673, 0.0355392210185528, 0.0355714820325375, 0.0355991348624229, 0.0356360077857971, 0.0356659628450871, 0.0357028357684612, 0.0357420109212399, 0.0357742719352245, 0.0358157530426979, 0.0358503200113773, 0.0358941033482552, 0.0359218902885914, 0.0359374433755875, 0.0359518453478813, 0.0359656699001789, 0.0359795019030571, 0.0359933264553547, 0.0360054261982441, 0.0360186770558357, 0.0360296219587326, 0.036041721701622, 0.0360520891845226, 0.0360636152327061, 0.0360734052956104, 0.0360837802290916, 0.0360924191772938, 0.0361016392707825, 0.0361097045242786, 0.0361183434724808, 0.0361258313059807, 0.0361327454447746, 0.0361396595835686, 0.0361459963023663, 0.036151185631752, 0.0361569449305534, 0.0361621268093586, 0.0361667349934578, 0.036170769482851, 0.036174226552248, 0.036177683621645, 0.0361805632710457, 0.0361828692257404, 0.0361845940351486, 0.0361863262951374, 0.0361868999898434, 0.0361880511045456, 0.0361886285245419, 0.0361880511045456, 0.0361868999898434, 0.0361851751804352, 0.0361840203404427, 0.0361817181110382, 0.0361799858510494, 0.0361765287816525, 0.0361730754375458, 0.0361684672534466, 0.0361650101840496, 0.0361598208546638, 0.0361552126705647, 0.036148302257061, 0.0361436940729618, 0.0361362025141716, 0.0361298657953739, 0.036122377961874, 0.0361148864030838, 0.0361062474548817, 0.0360976047813892, 0.0360878072679043, 0.0360791645944118, 0.0360687971115112, 0.0360584296286106, 0.0360474810004234, 0.0360359586775303, 0.0360250137746334, 0.036012340337038, 0.0360002405941486, 0.035986989736557, 0.0359731614589691, 0.0359593369066715, 0.0359449349343777, 0.0359299555420876, 0.0359149761497974, 0.0359608009457588, 0.0359291136264801, 0.0358962751924992, 0.0358617082238197, 0.0358271449804306, 0.0357914231717587, 0.035755705088377, 0.0357171073555946, 0.035678505897522, 0.0356381796300411, 0.0355990044772625, 0.0355586744844913, 0.0355160422623158, 0.0354722589254379, 0.035429622977972, 0.035384114831686, 0.0353391766548157, 0.0352925136685371, 0.0352458469569683, 0.035196878015995, 0.0351473316550255, 0.0350977852940559, 0.0350465141236782, 0.0349958166480064, 0.0349422357976437, 0.0348898097872734, 0.0348350815474987, 0.0347803495824337, 0.0347233153879642, 0.0346668586134911, 0.0346086695790291, 0.0345504842698574, 0.0344905667006969, 0.0344300754368305, 0.0343690067529678, 0.0343067869544029, 0.0342434160411358, 0.0341794677078724, 0.0341137908399105, 0.0340492650866508, 0.033983014523983, 0.0339150317013264, 0.0338464751839638, 0.0337773449718952, 0.0337070561945438, 0.0336367711424828, 0.0335641801357269, 0.0334915928542614, 0.0334166958928108, 0.0333429574966431, 0.0332669094204903, 0.03319201618433, 0.0331136658787727, 0.0330353118479252, 0.0329569615423679, 0.0328774601221085, 0.0327956490218639, 0.0327149964869022, 0.0326320342719555, 0.0325496532022953, 0.0324638113379478, 0.0323802754282951, 0.0322932824492455, 0.032206866890192, 0.0321192964911461, 0.0320311523973942, 0.0319407023489475, 0.0318508297204971, 0.031758651137352, 0.0316676273941994, 0.0315737202763557, 0.0315383486449718, 0.0314116030931473, 0.031284861266613, 0.0311604235321283, 0.0310336779803038, 0.0309092402458191, 0.0307824946939945, 0.0306569058448076, 0.0305313132703304, 0.0304057225584984, 0.0302801337093115, 0.0301545392721891, 0.0300277974456549, 0.0299022067338228, 0.0297766160219908, 0.0296510253101587, 0.0295254327356815, 0.0293998438864946, 0.0292742494493723, 0.0291486606001854, 0.029023066163063, 0.0288974773138762, 0.0287718884646893, 0.0286451429128647, 0.02852070517838, 0.0283951107412577, 0.0282683707773685, 0.0281427782028913, 0.0280171874910593, 0.0278915949165821, 0.0277660042047501, 0.0276404153555632, 0.0275148209184408, 0.0273880809545517, 0.0272624883800745, 0.0271368976682425, 0.0270113069564104, 0.0268845614045858, 0.0267589725553989, 0.0266333799809217, 0.0265077892690897, 0.0263821985572577, 0.0262566078454256, 0.0261310171335936, 0.0260054245591164, 0.0258798357099295, 0.0257542431354523, 0.0256286524236202, 0.0255019087344408, 0.0253763161599636, 0.0252507273107767, 0.0251251347362995, 0.0249995440244675, 0.0248739514499903, 0.0247483626008034, 0.0246227718889713, 0.0244971793144941, 0.0243715904653072, 0.02424599789083, 0.0241192542016506, 0.0239936634898186, 0.0238680709153414, 0.023741327226162, 0.0236157365143299, 0.023490147665143, 0.0233645550906658, 0.0232389643788338, 0.0231133736670017, 0.0229877810925245, 0.0228621922433376, 0.0227354466915131, 0.0226098578423262, 0.0224014688283205, 0.0223081391304731, 0.0222148094326258, 0.022123783826828, 0.0220339093357325, 0.0219434630125761, 0.021854167804122, 0.021767171099782, 0.0216796044260263, 0.0215931870043278, 0.0215084981173277, 0.0214238110929728, 0.0213391240686178, 0.0212555844336748, 0.0211749318987131, 0.02109370008111, 0.0210136193782091, 0.0209346916526556, 0.0208574943244457, 0.0207797195762396, 0.0207030959427357, 0.0206264723092318, 0.0205521546304226, 0.0204772613942623, 0.0204040966928005, 0.0203320812433958, 0.0202612206339836, 0.0201920866966248, 0.0201223772019148, 0.0200526677072048, 0.0199846886098385, 0.0199178587645292, 0.0198521818965673, 0.0197870805859566, 0.0197219792753458, 0.0196591857820749, 0.0195969641208649, 0.0195347461849451, 0.0194748323410749, 0.0194143392145634, 0.0193549990653992, 0.0192979648709297, 0.0192397776991129, 0.0191844701766968, 0.0191291626542807, 0.0190727040171623, 0.0190191268920898, 0.0189684294164181, 0.0189148504287004, 0.0188630018383265, 0.018814031034708, 0.0187650602310896, 0.0187172442674637, 0.0186694283038378, 0.0186227615922689, 0.0185760986059904, 0.0185305830091238, 0.0184868015348911, 0.0184453204274178, 0.0184026882052422, 0.0183600578457117, 0.0183208808302879, 0.0182811301201582, 0.0182413775473833, 0.0182045064866543, 0.018167058005929, 0.0181319173425436, 0.0180956237018108, 0.01806047745049, 0.0180287919938564, 0.0179953780025244, 0.0179258026182652, 0.0179096702486277, 0.0178946908563375, 0.0178802888840437, 0.0178664606064558, 0.0178526360541582, 0.0178399607539177, 0.0178267098963261, 0.0178140364587307, 0.0178036652505398, 0.0177915673702955, 0.0177800431847572, 0.0177696757018566, 0.0177593044936657, 0.0177500862628222, 0.0177414454519749, 0.0177322272211313, 0.0177230108529329, 0.0177149437367916, 0.0177080295979977, 0.0177011173218489, 0.0176942031830549, 0.0176884420216084, 0.017683258280158, 0.0176774971187115, 0.0176728870719671, 0.0176671259105206, 0.0176636688411236, 0.0176607891917229, 0.0176573321223259, 0.0176550280302763, 0.0176527239382267, 0.0176509954035282, 0.0176504198461771, 0.0176486913114786, 0.0176475383341312, 0.0176475383341312, 0.0176481138914824, 0.0176498424261808, 0.0176515709608793, 0.0176527239382267, 0.0176544524729252, 0.0176579095423222, 0.017661364749074, 0.0176636688411236, 0.0176677014678717, 0.017672311514616, 0.0176769215613604, 0.0176826808601618, 0.0176884420216084, 0.0176936276257038, 0.0177005417644978, 0.0177074540406466, 0.0177149437367916, 0.0177230108529329, 0.0177316516637802, 0.0177408680319786, 0.0177500862628222, 0.0177598800510168, 0.0177690982818604, 0.0177794676274061, 0.0177909918129444, 0.0178025141358376, 0.0178140364587307, 0.0178267098963261, 0.0178393851965666, 0.0178532116115093, 0.0178670380264521, 0.0178797133266926, 0.0178946908563375, 0.0179096702486277, 0.0179252251982689, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0179632492363453, 0.0180282182991505, 0.0180431958287954, 0.0180581752210855, 0.0180725771933794, 0.0180875565856695, 0.0181002300232649, 0.0181140564382076, 0.018126729875803, 0.0181376785039902, 0.0181503519415855, 0.0181618742644787, 0.0181722436100245, 0.0181831903755665, 0.0181935597211123, 0.0182027760893106, 0.0182119961827993, 0.0182212125509977, 0.018229853361845, 0.018236767500639, 0.018244257196784, 0.0182517450302839, 0.0182586591690779, 0.0182644221931696, 0.018270181491971, 0.0182742141187191, 0.0182799752801657, 0.0182840079069138, 0.018288042396307, 0.0182914976030588, 0.0182943791151047, 0.0182978343218565, 0.0182989872992039, 0.0183012913912535, 0.018303019925952, 0.0183024425059557, 0.0183035954833031, 0.0183035954833031, 0.0183024425059557, 0.0183018669486046, 0.0183007158339024, 0.0182984117418528, 0.0182966832071543, 0.0182938016951084, 0.0182903464883566, 0.0182868894189596, 0.0182834304869175, 0.0182793997228146, 0.0182730630040169, 0.0182678773999214, 0.0182632692158222, 0.0182569306343794, 0.0182500183582306, 0.0182431042194366, 0.0182344634085894, 0.0182269737124443, 0.0182189084589481, 0.0182096920907497, 0.018200471997261, 0.0181906800717115, 0.0181814599782228, 0.0181699395179749, 0.0181595701724291, 0.0181480459868908, 0.0181347969919443, 0.0181232746690512, 0.0181106012314558, 0.018097348511219, 0.0180835239589214, 0.0180696956813335, 0.0180547181516886, 0.0180397387593985, 0.0180241838097572, 0.0178621672093868, 0.017829904332757, 0.0177964903414249, 0.0177619252353907, 0.0177262052893639, 0.0176887586712837, 0.0176530405879021, 0.0176150165498257, 0.0175752658396959, 0.0175360906869173, 0.0174963399767876, 0.0174542833119631, 0.0174110755324364, 0.0173684433102608, 0.0173246599733829, 0.0172785706818104, 0.0172330588102341, 0.0171863939613104, 0.0171391535550356, 0.0170907620340586, 0.0170400645583868, 0.0169905181974173, 0.0169392451643944, 0.0168873947113752, 0.0168343931436539, 0.0167813915759325, 0.0167249348014593, 0.0166702028363943, 0.0166143216192722, 0.016554981470108, 0.0164973717182875, 0.0164397619664669, 0.0163798462599516, 0.0163170509040356, 0.0162565596401691, 0.0161943398416042, 0.0161298159509897, 0.0160658694803715, 0.0160007681697607, 0.0159356687217951, 0.0158671122044325, 0.015799131244421, 0.0157311502844095, 0.0156602896749973, 0.0155905811116099, 0.0155191440135241, 0.0154471304267645, 0.0153733883053064, 0.0152996480464935, 0.0152253294363618, 0.0151481311768293, 0.0150726614519954, 0.0149948867037892, 0.0149153843522072, 0.0148358820006251, 0.0147575316950679, 0.0146751487627625, 0.0145921893417835, 0.0145098064094782, 0.0144262704998255, 0.0143415834754705, 0.0142563190311193, 0.0141693269833922, 0.0140829114243388, 0.0139941908419132, 0.0139048947021365, 0.0138161741197109, 0.013724572956562, 0.0136335482820868, 0.0135407960042357, 0.0134474663063884, 0.0131595088168979, 0.0130333416163921, 0.0129100540652871, 0.0127821564674377, 0.0126582933589816, 0.0125315487384796, 0.0124059561640024, 0.0122803645208478, 0.0121536199003458, 0.0120291793718934, 0.0119035886600614, 0.0117762666195631, 0.0116512514650822, 0.0115256598219275, 0.0114000663161278, 0.0112721705809236, 0.0111500350758433, 0.0110227139666677, 0.0108965458348393, 0.0107715297490358, 0.0106465145945549, 0.0105186169967055, 0.0103930244222283, 0.0102668562904, 0.0101412646472454, 0.0100145200267434, 0.00988950487226248, 0.00976276025176048, 0.00963716860860586, 0.00951388012617826, 0.00938771292567253, 0.00926096830517054, 0.00913652870804071, 0.00901035964488983, 0.00888303946703672, 0.0087574478238821, 0.00863185618072748, 0.00850626360625029, 0.00837894342839718, 0.00825392734259367, 0.00813121628016233, 0.00800274312496185, 0.00787715148180723, 0.00775155937299132, 0.0076276957988739, 0.00750037515535951, 0.00737420748919249, 0.00724803935736418, 0.00712187169119716, 0.00699627911671996, 0.00687068747356534, 0.00674509536474943, 0.00662007974460721, 0.00649448717013001, 0.00636889599263668, 0.00624272786080837, 0.00611655972898006, 0.00599154410883784, 0.00586537551134825, 0.00573805626481771, 0.00561303971335292, 0.0054868720471859, 0.00536070391535759, 0.00523568829521537, 0.00511182472109795, 0.00498565705493093, 0.00485891290009022, 0.0047333212569356, 0.0046077286824584, 0.00448156148195267, 0.00435539335012436, 0.00441649323329329, 0.00432431511580944, 0.0042298324406147, 0.00413995841518044, 0.00405008438974619, 0.00396021082997322, 0.00387033703736961, 0.00378046301193535, 0.00369289354421198, 0.0036053245421499, 0.00351775507442653, 0.00343479448929429, 0.00334952934645116, 0.00326426466926932, 0.00318591319955885, 0.00310525693930686, 0.00302229658700526, 0.00294394488446414, 0.00286559318192303, 0.00278724171221256, 0.00271119456738234, 0.00263284309767187, 0.00255910051055253, 0.00248074880801141, 0.00240931054577231, 0.00233787251636386, 0.00226412969641387, 0.00219499599188566, 0.00212586228735745, 0.00205672858282924, 0.00198759487830102, 0.00191846117377281, 0.00185393623542041, 0.00178710708860308, 0.00172488670796156, 0.00166036188602448, 0.00159583706408739, 0.00153361668344587, 0.00147139630280435, 0.0014114803634584, 0.00135156454052776, 0.00129395304247737, 0.0012363416608423, 0.00117873016279191, 0.0011234232224524, 0.00107042072340846, 0.00101511366665363, 0.000962111167609692, 0.000909108610358089, 0.000856106111314148, 0.000805407995358109, 0.000754709937609732, 0.000708620762452483, 0.00066022714599967, 0.000611833471339196, 0.000568048853892833, 0.000521959678735584, 0.000475870532682166, 0.000432085857028142, 0.000390605593565851, 0.000346820917911828, 0.000305340654449537, 0.000266164861386642, 0.000224684641580097, 0.000190117774764076, 0.00015094198170118, 0.000116375114885159, 8.18082553450949e-05, 4.49369254056364e-05, 1.03700558611308e-05, 1.79640458460245e-14, 1.79640458460245e-14, 4.14802416344173e-05, 2.65012658928754e-05, 1.03700604086043e-05, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.15222892418387e-05, 2.53490361501463e-05, 4.03280100726988e-05, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.15222894692124e-06, 3.80235542252194e-05, 7.02859615557827e-05, 0.000107157291495241, 0.000141724158311263, 0.000178595480974764, 0.000215466803638265, 0.000259251508396119, 0.00029612283105962, 0.000337603065418079, 0.000376778829377145, 0.000418259121943265, 0.000462043768493459, 0.000510437414050102, 0.000554222089704126, 0.00059800676535815, 0.00064409599872306, 0.000692489556968212, 0.000738578732125461, 0.000793885788880289, 0.000842279347125441, 0.000892977463081479, 0.000943675462622195, 0.000996678019873798, 0.00104968051891774, 0.001102683134377, 0.00116259895730764, 0.00121790589764714, 0.00127551739569753, 0.0013331287773326, 0.001390740275383, 0.00145526509732008, 0.00151518092025071, 0.00157740141730756, 0.00163731724023819, 0.00169953762087971, 0.00176406244281679, 0.00182858726475388, 0.00190002541057765, 0.00196455023251474, 0.00203137961216271, 0.00210051331669092, 0.00216964702121913, 0.00223878072574735, 0.00231252354569733, 0.00238626589998603, 0.00245770416222513, 0.00253144698217511, 0.00260518956929445, 0.00267893192358315, 0.00275958818383515, 0.00283793965354562, 0.00291629158891737, 0.00299464305862784, 0.00307299452833831, 0.00315365078859031, 0.00323891546577215, 0.00332187581807375, 0.00340483640320599, 0.00349010154604912, 0.00357306189835072, 0.00365832657553256, 0.0037505051586777, 0.00383807462640107, 0.00392564386129379, 0.00401551788672805, 0.00410539144650102, 0.00419757002964616, 0.0042920527048409, 0.00438423082232475, 0.00460661156103015, 0.00473105255514383, 0.00485779717564583, 0.00498223723843694, 0.00510898325592279, 0.00523572834208608, 0.00536016887053847, 0.00548691395670176, 0.00561135495081544, 0.00573579594492912, 0.005864845123142, 0.00598928611725569, 0.00611603073775768, 0.00624047219753265, 0.00636491272598505, 0.00649165734648705, 0.00661609880626202, 0.0067451479844749, 0.00686958897858858, 0.00699402950704098, 0.00712077459320426, 0.00724521558731794, 0.00737196020781994, 0.00749870575964451, 0.0076231462880969, 0.00774989137426019, 0.00787433236837387, 0.00800107792019844, 0.00812551844865084, 0.00825456809252501, 0.0083790086209774, 0.0085034491494298, 0.00863019376993179, 0.00875463522970676, 0.00888137985020876, 0.00900812540203333, 0.00913256593048573, 0.0092593114823103, 0.00938375201076269, 0.00951049756258726, 0.00963493809103966, 0.00976168271154165, 0.0098884291946888, 0.0100128706544638, 0.0101396134123206, 0.0102640548720956, 0.0103884963318706, 0.0105175441130996, 0.0106419855728745, 0.0107687320560217, 0.0108931716531515, 0.0110199172049761, 0.0111443586647511, 0.0112711042165756, 0.0113978488370776, 0.01152228936553, 0.0116490349173546, 0.011773475445807, 0.0118979150429368, 0.0120269656181335, 0.0121514070779085, 0.0122781507670879, 0.0124025922268629, 0.0125270327553153, 0.0126537783071399, 0.0127805229276419, 0.0129072684794664, 0.0130317090079188, 0.0131561495363712, 0.0132828950881958, 0.0134073365479708, 0.0135097857564688, 0.0136054204776883, 0.0136952940374613, 0.0137897748500109, 0.0138796484097838, 0.013971826992929, 0.0140593955293298, 0.014146963134408, 0.014236836694181, 0.0143221011385322, 0.014409669674933, 0.0144937830045819, 0.0145767414942384, 0.0146620068699121, 0.014742661267519, 0.014826774597168, 0.0149051249027252, 0.0149846281856298, 0.0150641314685345, 0.0151413297280669, 0.0152208330109715, 0.0152945751324296, 0.0153694692999125, 0.0154455164447427, 0.0155169544741511, 0.0155930006876588, 0.0156621336936951, 0.0157358758151531, 0.0158027056604624, 0.0158718377351761, 0.0159432757645845, 0.0160077996551991, 0.0160769317299128, 0.0161414574831724, 0.0162036772817373, 0.0162705052644014, 0.0163304209709167, 0.016397250816226, 0.0164548605680466, 0.0165182333439589, 0.0165769960731268, 0.0166323035955429, 0.0166933704167604, 0.0167486779391766, 0.0168074406683445, 0.0168604422360659, 0.0169134456664324, 0.0169687531888485, 0.0170182976871729, 0.0170724522322416, 0.017121996730566, 0.0171703901141882, 0.0172222405672073, 0.0172671768814325, 0.0173178743571043, 0.0173616576939821, 0.0174077469855547, 0.017452685162425, 0.0174953173846006, 0.0175391025841236, 0.0175805818289518, 0.0176220610737801, 0.0176623892039061, 0.0176992584019899, 0.0177395865321159, 0.017776457592845, 0.017813328653574, 0.0178490485996008, 0.0178824625909328, 0.0179193336516619, 0.0179492924362421, 0.0179861634969711, 0.0178823303431273, 0.0179168973118067, 0.0179445501416922, 0.017969898879528, 0.0180021598935127, 0.018025204539299, 0.0180551614612341, 0.0180782061070204, 0.0181012507528067, 0.0181265994906425, 0.0181473400443792, 0.0181703828275204, 0.0181888192892075, 0.0182072538882494, 0.0182302985340357, 0.0182464309036732, 0.0182671695947647, 0.0182786919176579, 0.0182971283793449, 0.0183109529316425, 0.0183224752545357, 0.018338605761528, 0.0183478258550167, 0.0183616504073143, 0.0183708686381578, 0.0183777809143066, 0.0183893032371998, 0.0183939132839441, 0.0184031315147877, 0.0184077396988869, 0.0184146519750357, 0.0184169560670853, 0.01841926202178, 0.0184238702058792, 0.0184238702058792, 0.0184261742979288, 0.0184238702058792, 0.0184215661138296, 0.0184215661138296, 0.0184169560670853, 0.0184146519750357, 0.0184100437909365, 0.0184008274227381, 0.0183985214680433, 0.0183869991451502, 0.018382390961051, 0.0183708686381578, 0.0183639544993639, 0.0183501299470663, 0.018338605761528, 0.0183270834386349, 0.0183132570236921, 0.0182994324713945, 0.018283300101757, 0.0182648655027151, 0.0182510390877724, 0.0182302985340357, 0.0182141680270433, 0.0181934293359518, 0.0181703828275204, 0.0181496441364288, 0.0181265994906425, 0.0181058589369059, 0.01808051019907, 0.0180574655532837, 0.0180298127233982, 0.0180021598935127, 0.0179768111556768, 0.0179468542337418, 0.0179192014038563, 0.0178869403898716, 0.017813328653574, 0.0177810657769442, 0.0177465006709099, 0.0177153889089823, 0.0176785178482533, 0.0176451038569212, 0.0176070816814899, 0.0175679046660662, 0.0175321865826845, 0.0174918584525585, 0.0174538344144821, 0.0174123551696539, 0.0173685718327761, 0.0173282437026501, 0.0172833055257797, 0.0172406751662493, 0.0171934328973293, 0.0171461924910545, 0.0171012561768293, 0.0170517098158598, 0.0170056223869324, 0.0169537719339132, 0.0169019214808941, 0.0168535280972719, 0.016798222437501, 0.0167475249618292, 0.0166922174394131, 0.0166392140090466, 0.0165827572345734, 0.0165239926427603, 0.0164686869829893, 0.0164087731391191, 0.0163488555699587, 0.0162900928407907, 0.0162267200648785, 0.0161668043583632, 0.0161022804677486, 0.0160400606691837, 0.0159755349159241, 0.0159110128879547, 0.0158418789505959, 0.0157750509679317, 0.0157082211226225, 0.0156390871852636, 0.0155699541792274, 0.0154962120577693, 0.0154259270057082, 0.015353336930275, 0.0152795948088169, 0.0152058526873589, 0.0151298064738512, 0.015053759329021, 0.014976560138166, 0.0148993618786335, 0.0148210115730762, 0.014739204198122, 0.0146620040759444, 0.014579045586288, 0.0144960843026638, 0.0144131258130074, 0.0143278604373336, 0.0142460539937019, 0.0141584845259786, 0.0140720680356026, 0.0139844994992018, 0.0138946259394288, 0.0138082085177302, 0.0137160317972302, 0.0136261591687799, 0.0135339815169573, 0.0134394988417625, 0.01334732118994, 0.0133151570335031, 0.0131907174363732, 0.0130639709532261, 0.0129372263327241, 0.0128127858042717, 0.0126860402524471, 0.0125615987926722, 0.0124348541721702, 0.0123081095516682, 0.0121836680918932, 0.0120569225400686, 0.0119324820116162, 0.0118057373911142, 0.0116789918392897, 0.0115545513108373, 0.0114278066903353, 0.0113033652305603, 0.0111766206100583, 0.0110521791502833, 0.0109277386218309, 0.0108009930700064, 0.010674249380827, 0.010549807921052, 0.0104230623692274, 0.010298621840775, 0.010171877220273, 0.0100451316684484, 0.00992069113999605, 0.00979394651949406, 0.00966950505971909, 0.00954275950789452, 0.00941601488739252, 0.00929157435894012, 0.00916482880711555, 0.00904038827866316, 0.00891364272683859, 0.00878689810633659, 0.00866245664656162, 0.00853571202605963, 0.00841127149760723, 0.00828452594578266, 0.00815778039395809, 0.0080333398655057, 0.0079065952450037, 0.00778215378522873, 0.00765540869906545, 0.00752866361290216, 0.00740422261878848, 0.00727747799828649, 0.00715534202754498, 0.00702859601005912, 0.00690185092389584, 0.00677741039544344, 0.00665066530928016, 0.00652622431516647, 0.00639947922900319, 0.00627273414283991, 0.00614829314872622, 0.00602154852822423, 0.00589710753411055, 0.00577036244794726, 0.00564361689612269, 0.0055191763676703, 0.00539243128150702, 0.00526799028739333, 0.00514124566689134, 0.00501450058072805, 0.00489005958661437, 0.0047633140347898, 0.00463656894862652, 0.00451212842017412, 0.00443953787907958, 0.00434505520388484, 0.00425518117845058, 0.00416069850325584, 0.00407082447782159, 0.00398095091804862, 0.00389107689261436, 0.00380350765772164, 0.00371593842282891, 0.00363067304715514, 0.0035454083699733, 0.00346014322713017, 0.00337718287482858, 0.00329191819764674, 0.00321126193739474, 0.00313060590997338, 0.00304995011538267, 0.00296929385513067, 0.0028909423854202, 0.00281259091570973, 0.00273654377087951, 0.00266049639321864, 0.00258444924838841, 0.0025130114518106, 0.00243926863186061, 0.00236552604474127, 0.00229408778250217, 0.00222264952026308, 0.00215351581573486, 0.00208438211120665, 0.00201755296438932, 0.00195072358474135, 0.00188158976379782, 0.00181706505827606, 0.00175254023633897, 0.00168801529798657, 0.00162579503376037, 0.00156357465311885, 0.00150365871377289, 0.0014460472157225, 0.00138613127637655, 0.00132621556986123, 0.00126860407181084, 0.00121329713147134, 0.00115799007471651, 0.001102683134377, 0.00104737607762218, 0.000994373462162912, 0.000941371079534292, 0.000890672963578254, 0.000839974847622216, 0.000791581289377064, 0.00074318767292425, 0.000692489556968212, 0.000646400440018624, 0.000600311264861375, 0.00055652653099969, 0.000510437355842441, 0.000466652709292248, 0.000425172445829958, 0.000383692240575328, 0.000344516447512433, 0.000305340654449537, 0.000266164861386642, 0.000226989097427577, 0.000190117774764076, 0.000153246452100575, 0.000118679578008596, 8.41127039166167e-05, 5.18503002240323e-05, 1.95878910744796e-05, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14, 1.79640458460245e-14   }, 
   { 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.0032380479387939, 0.000368828332284465, 0.00102421431802213, 0.00169516506139189, 0.00238307029940188, 0.00308626214973629, 0.00380613072775304, 0.0045412858016789, 0.00529311783611774, 0.00606051413342357, 0.0068440311588347, 0.00764339044690132, 0.00845914892852306, 0.00929047167301178, 0.0101381931453943, 0.0110012022778392, 0.0118811642751098, 0.0127761354669929, 0.0136880623176694, 0.0146152758970857, 0.0155591638758779, 0.0165183413773775, 0.0174941923469305, 0.0184853319078684, 0.0194931477308273, 0.020516250282526, 0.021556306630373, 0.0226113740354776, 0.0236831158399582, 0.0247701443731785, 0.0258741267025471, 0.0269931219518185, 0.0281285122036934, 0.0292803030461073, 0.0304473787546158, 0.0316311307251453, 0.0328301675617695, 0.0340461619198322, 0.0352774448692799, 0.036525122821331, 0.0377883687615395, 0.0390680097043514, 0.0403632186353207, 0.0416751019656658, 0.0430019944906235, 0.0443458408117294, 0.0457049757242203, 0.047080785036087, 0.0484718829393387, 0.0498796552419662, 0.0513029918074608, 0.0527424551546574, 0.0541977547109127, 0.0556694567203522, 0.0571567192673683, 0.058660663664341, 0.0601796098053455, 0.061715517193079, 0.063266433775425, 0.0648342967033386, 0.0664171725511551, 0.0680170059204102, 0.0696324035525322, 0.0712633654475212, 0.0729112774133682, 0.074574202299118, 0.0762540772557259, 0.0779492408037186, 0.0796608105301857, 0.0813882127404213, 0.0831317454576492, 0.0848908349871635, 0.0866665989160538, 0.0884576514363289, 0.0902653858065605, 0.0920886769890785, 0.093928374350071, 0.0958411246538162, 0.0978753119707108, 0.0999206751585007, 0.101977370679379, 0.104045532643795, 0.106124870479107, 0.108215481042862, 0.110317841172218, 0.11243087798357, 0.114555887877941, 0.116692140698433, 0.118839517235756, 0.120998285710812, 0.123168312013149, 0.125349745154381, 0.12754213809967, 0.129746481776237, 0.131961688399315, 0.13418847322464, 0.136426463723183, 0.138675838708878, 0.140936553478241, 0.143208920955658, 0.145492017269135, 0.147786974906921, 0.150092780590057, 0.152410447597504, 0.15473884344101, 0.157079234719276, 0.159430354833603, 0.161793127655983, 0.164167016744614, 0.16655245423317, 0.168949142098427, 0.171357586979866, 0.173776626586914, 0.176207438111305, 0.178649291396141, 0.181102827191353, 0.183567404747009, 0.186043784022331, 0.188530877232552, 0.191029697656631, 0.193539321422577, 0.196060866117477, 0.198593258857727, 0.201137393712997, 0.203692927956581, 0.206259503960609, 0.208837479352951, 0.211426839232445, 0.214027613401413, 0.216639563441277, 0.219262838363647, 0.221897527575493, 0.224543511867523, 0.227200418710709, 0.229869306087494, 0.232549548149109, 0.23524072766304, 0.237943425774574, 0.240657314658165, 0.243382528424263, 0.246119424700737, 0.248867273330688, 0.251626700162888, 0.25439727306366, 0.257179200649261, 0.259972512722015, 0.262777149677277, 0.2655930519104, 0.268420308828354, 0.271065413951874, 0.273700654506683, 0.276343256235123, 0.27899381518364, 0.281652390956879, 0.284318685531616, 0.28699317574501, 0.289675384759903, 0.292365282773972, 0.295063406229019, 0.297769010066986, 0.300482839345932, 0.303204447031021, 0.305933713912964, 0.308671295642853, 0.311416298151016, 0.31416928768158, 0.316930443048477, 0.319699436426163, 0.322475999593735, 0.325260698795319, 0.328053176403046, 0.330853521823883, 0.333661764860153, 0.336477875709534, 0.339301854372025, 0.342134028673172, 0.344973415136337, 0.347821205854416, 0.350676774978638, 0.353540182113647, 0.356411397457123, 0.359290659427643, 0.362177848815918, 0.36507260799408, 0.367975473403931, 0.370886415243149, 0.373804688453674, 0.376731187105179, 0.379665642976761, 0.382608026266098, 0.385557919740677, 0.388515830039978, 0.391481846570969, 0.394455313682556, 0.397437125444412, 0.400426656007767, 0.403424054384232, 0.40642923116684, 0.409442454576492, 0.412463486194611, 0.41549214720726, 0.418529033660889, 0.421573996543884, 0.424626082181931, 0.427686601877213, 0.430755019187927, 0.433831304311752, 0.436915218830109, 0.440007388591766, 0.443107187747955, 0.446214526891708, 0.449330627918243, 0.452453881502151, 0.455585330724716, 0.458724290132523, 0.461871773004532, 0.465026617050171, 0.468189120292664, 0.471359938383102, 0.474538922309875, 0.477752178907394, 0.480990529060364, 0.484238266944885, 0.487494975328445, 0.490760803222656, 0.494036108255386, 0.497320234775543, 0.500613570213318, 0.503915786743164, 0.507227182388306, 0.510548174381256, 0.513877511024475, 0.517216384410858, 0.520564496517181, 0.523921608924866, 0.527287364006042, 0.530662655830383, 0.534047305583954, 0.537440538406372, 0.54084324836731, 0.544255018234253, 0.547675848007202, 0.551105678081512, 0.554544627666473, 0.55799275636673, 0.561449825763702, 0.56491631269455, 0.568391919136047, 0.571876227855682, 0.575370013713837, 0.578872978687286, 0.582385063171387, 0.585905730724335, 0.589435875415802, 0.592975318431854, 0.596523404121399, 0.600081086158752, 0.603647768497467, 0.607223451137543, 0.610807776451111, 0.614401817321777, 0.618005037307739, 0.621616780757904, 0.625238478183746, 0.628868579864502, 0.632508218288422, 0.636156499385834, 0.639814138412476, 0.643481075763702, 0.647156834602356, 0.650841951370239, 0.654536068439484, 0.658239424228668, 0.661951661109924, 0.665672898292542, 0.669403612613678, 0.673143088817596, 0.676891803741455, 0.680649757385254, 0.684417128562927, 0.688192665576935, 0.691978096961975, 0.695772588253021, 0.69957572221756, 0.703388094902039, 0.707210302352905, 0.711040556430817, 0.714880585670471, 0.718729496002197, 0.722587943077087, 0.726454794406891, 0.730361223220825, 0.734622538089752, 0.73888224363327, 0.743140161037445, 0.747397124767303, 0.751652002334595, 0.755905628204346, 0.760157287120819, 0.764407932758331, 0.768656313419342, 0.772903978824615, 0.777149498462677, 0.781394064426422, 0.785636305809021, 0.789877533912659, 0.794116973876953, 0.798355042934418, 0.80259120464325, 0.806826293468475, 0.811059355735779, 0.815291404724121, 0.819521248340607, 0.823750257492065, 0.827977061271667, 0.832202792167664, 0.836426675319672, 0.840648531913757, 0.844869434833527, 0.849088788032532, 0.853305816650391, 0.857522308826447, 0.861736655235291, 0.865950047969818, 0.870161294937134, 0.87437105178833, 0.878579199314117, 0.882786631584167, 0.886991381645203, 0.89119428396225, 0.895397126674652, 0.89959716796875, 0.903796017169952, 0.907993674278259, 0.912189960479736, 0.916383326053619, 0.920576572418213, 0.924767196178436, 0.928957045078278, 0.933145344257355, 0.93733161687851, 0.941517233848572, 0.945699691772461, 0.949881672859192, 0.954061925411224, 0.958239793777466, 0.962418019771576, 0.966593265533447, 0.970767319202423, 0.974938869476318, 0.979110956192017, 0.983279943466187, 0.987447381019592, 0.991613328456879, 0.99577796459198, 0.999941229820251, 1.00410294532776, 1.00826275348663, 1.01242125034332, 1.01657748222351, 1.02073276042938, 1.02488684654236, 1.02903985977173, 1.03301334381104, 1.03693342208862, 1.04083514213562, 1.04472029209137, 1.04858875274658, 1.05244040489197, 1.0562744140625, 1.06009268760681, 1.06389272212982, 1.06767654418945, 1.07144153118134, 1.07519161701202, 1.07892370223999, 1.0826381444931, 1.08633756637573, 1.09001910686493, 1.09368360042572, 1.09733068943024, 1.10096120834351, 1.1045755147934, 1.1081714630127, 1.11175036430359, 1.11531412601471, 1.11885952949524, 1.12238824367523, 1.12589859962463, 1.12939453125, 1.13286983966827, 1.1363320350647, 1.13977456092834, 1.14320158958435, 1.14661085605621, 1.15000402927399, 1.15337920188904, 1.15673792362213, 1.1600798368454, 1.16340470314026, 1.166712641716, 1.17000353336334, 1.17327654361725, 1.17653357982635, 1.17977321147919, 1.18299615383148, 1.18620193004608, 1.18939101696014, 1.19256067276001, 1.19571697711945, 1.19885385036469, 1.20197451114655, 1.20507860183716, 1.20816600322723, 1.21123504638672, 1.21428847312927, 1.21732413768768, 1.220343708992, 1.22334492206573, 1.22632992267609, 1.22929787635803, 1.23224854469299, 1.23518300056458, 1.23810029029846, 1.24099981784821, 1.24388158321381, 1.24674761295319, 1.24959707260132, 1.25242877006531, 1.25524425506592, 1.25804090499878, 1.2608231306076, 1.26358687877655, 1.26633358001709, 1.26899063587189, 1.27142155170441, 1.27383303642273, 1.27622604370117, 1.27859961986542, 1.28095662593842, 1.28329527378082, 1.28561270236969, 1.28791117668152, 1.29019486904144, 1.29245615005493, 1.29470145702362, 1.29692721366882, 1.29913568496704, 1.30132305622101, 1.30349326133728, 1.30564510822296, 1.30777740478516, 1.30989193916321, 1.31198704242706, 1.31406342983246, 1.31612288951874, 1.31816291809082, 1.32018256187439, 1.32218587398529, 1.32416927814484, 1.32613372802734, 1.32808041572571, 1.33000993728638, 1.3319183588028, 1.33380997180939, 1.33568215370178, 1.33753490447998, 1.33937108516693, 1.3411877155304, 1.34298491477966, 1.3447642326355, 1.34652578830719, 1.34826731681824, 1.34999120235443, 1.35169661045074, 1.3533821105957, 1.35505032539368, 1.35669851303101, 1.35832822322845, 1.35994100570679, 1.36153411865234, 1.36310839653015, 1.36466419696808, 1.36620247364044, 1.36772167682648, 1.36922025680542, 1.37070333957672, 1.37216639518738, 1.37361001968384, 1.3750364780426, 1.37644457817078, 1.37783205509186, 1.37920224666595, 1.3805547952652, 1.38188552856445, 1.38320016860962, 1.3844952583313, 1.38577163219452, 1.3870313167572, 1.3882714509964, 1.38949167728424, 1.3906946182251, 1.39187908172607, 1.39304375648499, 1.39419102668762, 1.39531898498535, 1.39646875858307, 1.39755666255951, 1.39863288402557, 1.39969599246979, 1.40074801445007, 1.40178859233856, 1.40281629562378, 1.40383088588715, 1.40483546257019, 1.40582764148712, 1.40680623054504, 1.40777468681335, 1.40873026847839, 1.40967381000519, 1.41060543060303, 1.41152489185333, 1.41243231296539, 1.41332900524139, 1.41421282291412, 1.41508340835571, 1.41594338417053, 1.41679155826569, 1.41762602329254, 1.41845011711121, 1.41926157474518, 1.42006075382233, 1.42084884643555, 1.42162442207336, 1.42238736152649, 1.42313981056213, 1.42387890815735, 1.42460596561432, 1.42532169818878, 1.42602598667145, 1.42671644687653, 1.42739629745483, 1.42806375026703, 1.42871928215027, 1.42936217784882, 1.42999470233917, 1.43061363697052, 1.43122088909149, 1.43181657791138, 1.43240058422089, 1.43297111988068, 1.43353128433228, 1.43407678604126, 1.43461334705353, 1.43513667583466, 1.43564736843109, 1.43614637851715, 1.43663465976715, 1.43711018562317, 1.43757331371307, 1.43802452087402, 1.43846440315247, 1.4388906955719, 1.43930649757385, 1.4397097826004, 1.44010126590729, 1.44048023223877, 1.44084811210632, 1.44120240211487, 1.44154596328735, 1.44187760353088, 1.44219636917114, 1.44250404834747, 1.44279968738556, 1.44308125972748, 1.4433536529541, 1.44361245632172, 1.44388365745544, 1.44416892528534, 1.4444488286972, 1.44472146034241, 1.44498789310455, 1.44524776935577, 1.44550228118896, 1.44574964046478, 1.44599115848541, 1.44622552394867, 1.44645404815674, 1.4466757774353, 1.44689154624939, 1.44710075855255, 1.44730365276337, 1.44750010967255, 1.44769048690796, 1.44787383079529, 1.4480516910553, 1.44822227954865, 1.44838738441467, 1.44854557514191, 1.44869768619537, 1.44884324073792, 1.44898271560669, 1.4491149187088, 1.44924199581146, 1.44936203956604, 1.44947588443756, 1.44958293437958, 1.44968414306641, 1.44977915287018, 1.44986701011658, 1.44994878768921, 1.45002460479736, 1.45009446144104, 1.45015704631805, 1.45021319389343, 1.4502637386322, 1.45030772686005, 1.45034468173981, 1.45037603378296, 1.45040035247803, 1.4504189491272, 1.45043039321899, 1.45043611526489, 1.45043516159058, 1.4504280090332, 1.45041418075562, 1.45039474964142, 1.45036840438843, 1.45033609867096, 1.45029664039612, 1.45025169849396, 1.45019960403442, 1.45014154911041, 1.45007681846619, 1.45000624656677, 1.44992876052856, 1.44984543323517, 1.44975543022156, 1.44965934753418, 1.44955611228943, 1.44944751262665, 1.44933199882507, 1.44921040534973, 1.44908201694489, 1.44894778728485, 1.44880676269531, 1.44865942001343, 1.4485057592392, 1.44834613800049, 1.44821548461914, 1.4480619430542, 1.44790601730347, 1.44774770736694, 1.44758701324463, 1.44742381572723, 1.44725835323334, 1.44709086418152, 1.44692063331604, 1.44674801826477, 1.446573138237, 1.44639563560486, 1.44621586799622, 1.44603383541107, 1.44584918022156, 1.44566237926483, 1.44547307491302, 1.44528162479401, 1.44508755207062, 1.44489109516144, 1.44469237327576, 1.44449138641357, 1.44428765773773, 1.44408190250397, 1.44387352466583, 1.44366276264191, 1.44344985485077, 1.44323444366455, 1.44301652908325, 1.44279634952545, 1.44257378578186, 1.44234871864319, 1.44212138652802, 1.44189178943634, 1.4416595697403, 1.44142520427704, 1.44118845462799, 1.44094932079315, 1.44070756435394, 1.44046366214752, 1.44021725654602, 1.43996858596802, 1.43971729278564, 1.43946385383606, 1.43920814990997, 1.43894970417023, 1.43868899345398, 1.43842601776123, 1.43816041946411, 1.43789267539978, 1.43762242794037, 1.43735015392303, 1.43707525730133, 1.43679797649384, 1.43651807308197, 1.43623614311218, 1.43595170974731, 1.43566477298737, 1.43537557125092, 1.43508410453796, 1.43479001522064, 1.43449366092682, 1.4341949224472, 1.4338937997818, 1.4335902929306, 1.43328440189362, 1.43297636508942, 1.43266582489014, 1.43235278129578, 1.43203735351562, 1.43171954154968, 1.43148326873779, 1.43135762214661, 1.43122756481171, 1.43109333515167, 1.43095541000366, 1.43081223964691, 1.43066489696503, 1.43051302433014, 1.43035757541656, 1.43019723892212, 1.43003249168396, 1.4298642873764, 1.42969071865082, 1.4295129776001, 1.42933094501495, 1.42914509773254, 1.42895424365997, 1.42875909805298, 1.42855989933014, 1.42835652828217, 1.42814815044403, 1.42793595790863, 1.42771935462952, 1.4274982213974, 1.42727267742157, 1.4270430803299, 1.42680943012238, 1.42657077312469, 1.42632782459259, 1.42608070373535, 1.42582941055298, 1.42557346820831, 1.42531359195709, 1.42504954338074, 1.42478036880493, 1.42450714111328, 1.42422938346863, 1.42394769191742, 1.42366135120392, 1.42337119579315, 1.42307591438293, 1.42277729511261, 1.42247343063354, 1.42216539382935, 1.42185366153717, 1.42153656482697, 1.42121601104736, 1.42089033126831, 1.42056107521057, 1.42022705078125, 1.4198887348175, 1.41954576969147, 1.41919898986816, 1.41884779930115, 1.41849207878113, 1.41813218593597, 1.41776764392853, 1.41739916801453, 1.41702592372894, 1.4166487455368, 1.41626691818237, 1.41588091850281, 1.41548991203308, 1.41509580612183, 1.41469669342041, 1.41429305076599, 1.41388511657715, 1.41347324848175, 1.41305649280548, 1.4126353263855, 1.41221082210541, 1.411745429039, 1.41123127937317, 1.41070687770844, 1.41017472743988, 1.40963184833527, 1.40907824039459, 1.40851676464081, 1.40794539451599, 1.40736246109009, 1.40677070617676, 1.40616953372955, 1.40555894374847, 1.40493822097778, 1.40430700778961, 1.40366744995117, 1.40301787853241, 1.40235733985901, 1.4016889333725, 1.40100908279419, 1.40031945705414, 1.39962208271027, 1.39891254901886, 1.39819514751434, 1.39746725559235, 1.39672899246216, 1.39598274230957, 1.39522469043732, 1.39445829391479, 1.3936824798584, 1.39289557933807, 1.39209985733032, 1.39129388332367, 1.39047884941101, 1.38965427875519, 1.38881874084473, 1.38797461986542, 1.38712108135223, 1.38625645637512, 1.38538312911987, 1.38450038433075, 1.38360619544983, 1.38270401954651, 1.38179075717926, 1.38086831569672, 1.37993609905243, 1.37899470329285, 1.37804269790649, 1.37708187103271, 1.37611019611359, 1.37512958049774, 1.37414038181305, 1.3731392621994, 1.37212944030762, 1.37111032009125, 1.37008023262024, 1.36904180049896, 1.3679918050766, 1.36693429946899, 1.36586630344391, 1.36478734016418, 1.36370038986206, 1.36260187625885, 1.36149573326111, 1.36037826538086, 1.35925137996674, 1.35811507701874, 1.35696947574615, 1.35581290721893, 1.35464715957642, 1.35347175598145, 1.35228729248047, 1.35109269618988, 1.34970200061798, 1.34826552867889, 1.34682238101959, 1.34537100791931, 1.34391498565674, 1.34245181083679, 1.34098100662231, 1.33950471878052, 1.33802211284637, 1.33653116226196, 1.33503544330597, 1.33353161811829, 1.33202111721039, 1.33050525188446, 1.32898163795471, 1.32745242118835, 1.32591652870178, 1.32437300682068, 1.3228235244751, 1.32126700878143, 1.31970453262329, 1.31813538074493, 1.31655883789062, 1.31497609615326, 1.31338655948639, 1.31179106235504, 1.31018900871277, 1.30857908725739, 1.30696332454681, 1.30534160137177, 1.30371165275574, 1.30207669734955, 1.30043435096741, 1.29878425598145, 1.29712951183319, 1.29546713829041, 1.29379832744598, 1.29212284088135, 1.29044032096863, 1.28875195980072, 1.28705704212189, 1.28535437583923, 1.28364646434784, 1.28193199634552, 1.28020942211151, 1.27848124504089, 1.27674567699432, 1.27500462532043, 1.27325642108917, 1.27150118350983, 1.26973986625671, 1.26797127723694, 1.26619648933411, 1.2644157409668, 1.26262676715851, 1.26083242893219, 1.25903117656708, 1.25722277164459, 1.25540840625763, 1.25358641147614, 1.2517591714859, 1.24992525577545, 1.24808359146118, 1.24623620510101, 1.24438297748566, 1.24252116680145, 1.24065411090851, 1.23878014087677, 1.23689889907837, 1.23501181602478, 1.23311829566956, 1.23124849796295, 1.22946786880493, 1.22768640518188, 1.2259042263031, 1.22412157058716, 1.22233831882477, 1.22055470943451, 1.21877026557922, 1.21698522567749, 1.21519923210144, 1.21341335773468, 1.21162641048431, 1.20983898639679, 1.20805108547211, 1.20626223087311, 1.20447301864624, 1.20268297195435, 1.20089256763458, 1.19910144805908, 1.19730973243713, 1.19551753997803, 1.1937243938446, 1.19193089008331, 1.19013690948486, 1.18834221363068, 1.18654680252075, 1.18475079536438, 1.18295431137085, 1.18115699291229, 1.17935955524445, 1.17756116390228, 1.17576217651367, 1.17396283149719, 1.17216265201569, 1.17036175727844, 1.16856038570404, 1.1667582988739, 1.1649557352066, 1.16315233707428, 1.16134870052338, 1.15954434871674, 1.15773928165436, 1.15593361854553, 1.15412724018097, 1.15232050418854, 1.15051305294037, 1.14870536327362, 1.14689660072327, 1.14508748054504, 1.14327752590179, 1.1414669752121, 1.13965582847595, 1.13784420490265, 1.13603222370148, 1.13421940803528, 1.13240575790405, 1.13059151172638, 1.12877690792084, 1.12696135044098, 1.12514531612396, 1.12332928180695, 1.12151205539703, 1.11969423294067, 1.11787605285645, 1.11605727672577, 1.11423778533936, 1.11241745948792, 1.1105968952179, 1.10877549648285, 1.10695362091064, 1.10513079166412, 1.10330772399902, 1.10156714916229, 1.09978723526001, 1.0980087518692, 1.09623062610626, 1.09445309638977, 1.09267675876617, 1.09090077877045, 1.08912575244904, 1.08735167980194, 1.08557879924774, 1.08380603790283, 1.08203434944153, 1.08026325702667, 1.07849287986755, 1.07672357559204, 1.07495498657227, 1.07318711280823, 1.0714203119278, 1.0696542263031, 1.06788873672485, 1.06612408161163, 1.06436014175415, 1.06259715557098, 1.06083500385284, 1.05907344818115, 1.05731248855591, 1.05555319786072, 1.05379402637482, 1.05203545093536, 1.05027842521667, 1.04852151870728, 1.04676556587219, 1.04501068592072, 1.04325616359711, 1.04150259494781, 1.03974997997284, 1.0379980802536, 1.0362468957901, 1.03449654579163, 1.03274691104889, 1.03099811077118, 1.0292501449585, 1.02750289440155, 1.02575659751892, 1.02401149272919, 1.02226650714874, 1.02052235603333, 1.0187793970108, 1.01703667640686, 1.01529490947723, 1.01355445384979, 1.01181423664093, 1.01007485389709, 1.00833642482758, 1.00659871101379, 1.00486183166504, 1.00312602519989, 1.00139081478119, 0.99965626001358, 0.997922718524933, 0.996189534664154, 0.994457602500916, 0.992726266384125, 0.990995824337006, 0.989266097545624, 0.987537503242493, 0.985809087753296, 0.984081745147705, 0.982355117797852, 0.98062938451767, 0.978904187679291, 0.977180540561676, 0.975421190261841, 0.973663449287415, 0.971908807754517, 0.970155596733093, 0.968404591083527, 0.966655492782593, 0.96490877866745, 0.963163375854492, 0.961420476436615, 0.959679663181305, 0.957940578460693, 0.956203877925873, 0.954468846321106, 0.952736496925354, 0.951005399227142, 0.949276864528656, 0.947549760341644, 0.945824801921844, 0.94410252571106, 0.942381203174591, 0.940663397312164, 0.938946425914764, 0.937231838703156, 0.935519158840179, 0.933808207511902, 0.932099759578705, 0.930393099784851, 0.928689301013947, 0.926986157894135, 0.925286173820496, 0.923587322235107, 0.92189085483551, 0.920196831226349, 0.918504655361176, 0.916813790798187, 0.915125787258148, 0.913439691066742, 0.911754965782166, 0.910072982311249, 0.908392369747162, 0.906714677810669, 0.905038118362427, 0.903363764286041, 0.901691973209381, 0.900021553039551, 0.898353695869446, 0.89668744802475, 0.895023941993713, 0.893361449241638, 0.89170116186142, 0.890043556690216, 0.888387322425842, 0.886733591556549, 0.885081350803375, 0.883432030677795, 0.881783843040466, 0.880138337612152, 0.878494203090668, 0.87685227394104, 0.875212550163269, 0.873574495315552, 0.871939241886139, 0.870305597782135, 0.868674099445343, 0.867043912410736, 0.865416288375854, 0.863790988922119, 0.862167000770569, 0.860545992851257, 0.858926177024841, 0.857308745384216, 0.855717599391937, 0.854127824306488, 0.852542996406555, 0.850960314273834, 0.849382519721985, 0.847808063030243, 0.846237659454346, 0.844670593738556, 0.843106925487518, 0.841547071933746, 0.839990794658661, 0.83843857049942, 0.836889326572418, 0.83534449338913, 0.833803057670593, 0.832265436649323, 0.83073103427887, 0.829199731349945, 0.827673614025116, 0.826150417327881, 0.824631214141846, 0.823115050792694, 0.821603655815125, 0.820094704627991, 0.818589329719543, 0.817088782787323, 0.815591514110565, 0.814097285270691, 0.812607228755951, 0.811120510101318, 0.809637665748596, 0.808159053325653, 0.806683778762817, 0.805211782455444, 0.803743958473206, 0.802278935909271, 0.800818920135498, 0.799361109733582, 0.797908544540405, 0.796458005905151, 0.795012652873993, 0.793569922447205, 0.792130649089813, 0.790695428848267, 0.789264559745789, 0.787837088108063, 0.786412298679352, 0.784992873668671, 0.783575654029846, 0.782162606716156, 0.780752956867218, 0.779347062110901, 0.777945160865784, 0.776547372341156, 0.775152981281281, 0.773761332035065, 0.772373795509338, 0.770989656448364, 0.769609987735748, 0.768233299255371, 0.766861081123352, 0.765492260456085, 0.764126420021057, 0.762765109539032, 0.761406779289246, 0.760052680969238, 0.758702158927917, 0.757355272769928, 0.756011366844177, 0.754671156406403, 0.753335893154144, 0.752023100852966, 0.750756740570068, 0.749493479728699, 0.74823272228241, 0.746974229812622, 0.745719611644745, 0.744467735290527, 0.743218123912811, 0.741971850395203, 0.740728855133057, 0.739488661289215, 0.738251864910126, 0.737017273902893, 0.735786259174347, 0.734556913375854, 0.733332276344299, 0.732109367847443, 0.730889976024628, 0.729673445224762, 0.728459656238556, 0.727248668670654, 0.726040720939636, 0.724836111068726, 0.723634004592896, 0.722435295581818, 0.721239030361176, 0.72004634141922, 0.718855738639832, 0.71766859292984, 0.716484010219574, 0.715303003787994, 0.714125394821167, 0.712948799133301, 0.711776733398438, 0.710607469081879, 0.709440946578979, 0.708277523517609, 0.707117080688477, 0.705958604812622, 0.704804301261902, 0.703651964664459, 0.7025026679039, 0.701356709003448, 0.70021378993988, 0.699074268341064, 0.69793713092804, 0.696802914142609, 0.695671379566193, 0.694542706012726, 0.693418145179749, 0.692295551300049, 0.691175699234009, 0.6900594830513, 0.688946306705475, 0.687835395336151, 0.686727523803711, 0.685622990131378, 0.684521198272705, 0.683422207832336, 0.682326018810272, 0.681233167648315, 0.680143296718597, 0.679056942462921, 0.67797178030014, 0.676891148090363, 0.675813257694244, 0.674737930297852, 0.673665344715118, 0.672595858573914, 0.671529650688171, 0.670466244220734, 0.669387578964233, 0.668254137039185, 0.667122364044189, 0.66599303483963, 0.664866864681244, 0.663743436336517, 0.662622809410095, 0.66150438785553, 0.660388708114624, 0.659275233745575, 0.65816456079483, 0.657056987285614, 0.655951321125031, 0.654848456382751, 0.653748393058777, 0.652651071548462, 0.651555418968201, 0.650463402271271, 0.649374127388, 0.648286879062653, 0.647201478481293, 0.646120011806488, 0.64504075050354, 0.643963694572449, 0.642889499664307, 0.641818046569824, 0.640749394893646, 0.639682352542877, 0.638619184494019, 0.637557446956635, 0.636499047279358, 0.635442852973938, 0.634389996528625, 0.633338332176208, 0.632290184497833, 0.631244599819183, 0.630201458930969, 0.629161655902863, 0.628123581409454, 0.627089023590088, 0.626055657863617, 0.62502533197403, 0.62399834394455, 0.622973322868347, 0.621951043605804, 0.62093186378479, 0.619914591312408, 0.61890035867691, 0.617888391017914, 0.616878867149353, 0.615872800350189, 0.61486828327179, 0.613867104053497, 0.612868189811707, 0.611871778964996, 0.610878169536591, 0.6098872423172, 0.608899176120758, 0.607913017272949, 0.60692971944809, 0.605948865413666, 0.604971051216125, 0.603995442390442, 0.603022396564484, 0.602052688598633, 0.601084887981415, 0.600119292736053, 0.599157333374023, 0.598197340965271, 0.597239851951599, 0.596285104751587, 0.595333158969879, 0.594377338886261, 0.593509495258331, 0.592644512653351, 0.591781258583069, 0.590920329093933, 0.590061485767365, 0.589205324649811, 0.588350057601929, 0.587497770786285, 0.586647689342499, 0.585799515247345, 0.584953904151917, 0.584109842777252, 0.583268582820892, 0.582428395748138, 0.581591129302979, 0.58075612783432, 0.579922914505005, 0.579091548919678, 0.578262865543365, 0.577435910701752, 0.576611518859863, 0.575788795948029, 0.574969172477722, 0.574151039123535, 0.573334991931915, 0.572521328926086, 0.571709215641022, 0.570899486541748, 0.570092260837555, 0.569287180900574, 0.568483650684357, 0.567683219909668, 0.566883862018585, 0.566087424755096, 0.565292596817017, 0.564500510692596, 0.563710331916809, 0.562921762466431, 0.56213641166687, 0.561351656913757, 0.560570597648621, 0.559790968894958, 0.559013426303864, 0.558237969875336, 0.557465016841888, 0.556693732738495, 0.555924952030182, 0.555158495903015, 0.554393827915192, 0.553631603717804, 0.55287116765976, 0.552112936973572, 0.551356971263885, 0.550602912902832, 0.549851536750793, 0.549101889133453, 0.548354148864746, 0.547608733177185, 0.546866059303284, 0.546124696731567, 0.545385658740997, 0.544649243354797, 0.543914556503296, 0.543181896209717, 0.542451322078705, 0.541723787784576, 0.540997564792633, 0.540273785591125, 0.539552271366119, 0.538832068443298, 0.538107335567474, 0.537349939346313, 0.536592900753021, 0.535836756229401, 0.535081148147583, 0.534325838088989, 0.533571243286133, 0.532817244529724, 0.532064080238342, 0.531311273574829, 0.530559122562408, 0.52980774641037, 0.52905684709549, 0.528306484222412, 0.527556538581848, 0.526807487010956, 0.526059031486511, 0.52531111240387, 0.524563670158386, 0.523816704750061, 0.523070394992828, 0.522325158119202, 0.52157998085022, 0.520835638046265, 0.520092010498047, 0.519348680973053, 0.518606066703796, 0.517864048480988, 0.517122507095337, 0.516381621360779, 0.515641212463379, 0.514901578426361, 0.514162540435791, 0.513424038887024, 0.512686312198639, 0.511948943138123, 0.511212229728699, 0.510476231575012, 0.509740769863129, 0.509006023406982, 0.50827157497406, 0.507537961006165, 0.506804764270782, 0.506072223186493, 0.505340397357941, 0.504609167575836, 0.503878474235535, 0.503148317337036, 0.502418696880341, 0.501689672470093, 0.500961303710938, 0.500233829021454, 0.499506711959839, 0.498779863119125, 0.498053997755051, 0.497328579425812, 0.496603757143021, 0.495879739522934, 0.49515637755394, 0.494433283805847, 0.493710935115814, 0.492989122867584, 0.492267966270447, 0.491547137498856, 0.490827143192291, 0.490107953548431, 0.489388912916183, 0.488670706748962, 0.487953186035156, 0.487236261367798, 0.486519604921341, 0.485803782939911, 0.485108345746994, 0.484374731779099, 0.483641654253006, 0.482909470796585, 0.482177704572678, 0.481447070837021, 0.480717152357101, 0.479987978935242, 0.479259341955185, 0.478531539440155, 0.477804601192474, 0.477077960968018, 0.476352334022522, 0.475627601146698, 0.474903583526611, 0.474180221557617, 0.473457485437393, 0.472735524177551, 0.472014546394348, 0.471293956041336, 0.470574378967285, 0.469855189323425, 0.469136983156204, 0.468419462442398, 0.467702955007553, 0.466986805200577, 0.466271668672562, 0.465557128190994, 0.464843183755875, 0.464130103588104, 0.463418036699295, 0.462706238031387, 0.461995393037796, 0.46128511428833, 0.460575938224792, 0.459867209196091, 0.459159404039383, 0.458452194929123, 0.457745671272278, 0.457040101289749, 0.456335097551346, 0.455630630254745, 0.45492747426033, 0.454224646091461, 0.453522592782974, 0.452821344137192, 0.452120691537857, 0.451420813798904, 0.450722068548203, 0.450023740530014, 0.449326068162918, 0.448629021644592, 0.447932958602905, 0.447237521409988, 0.446542918682098, 0.445849031209946, 0.445155888795853, 0.444463521242142, 0.443771749734879, 0.443081170320511, 0.442390769720078, 0.441701173782349, 0.441012561321259, 0.440324544906616, 0.439637184143066, 0.438950657844543, 0.43826499581337, 0.437579840421677, 0.436895430088043, 0.436211913824081, 0.435529083013535, 0.434964805841446, 0.434389591217041, 0.433812737464905, 0.433234751224518, 0.432654410600662, 0.43207311630249, 0.431489676237106, 0.430904924869537, 0.430319160223007, 0.429730892181396, 0.429140537977219, 0.428549617528915, 0.427957326173782, 0.427361845970154, 0.426766365766525, 0.426168829202652, 0.425568848848343, 0.424968868494034, 0.424365878105164, 0.423762500286102, 0.423155874013901, 0.422548145055771, 0.421939730644226, 0.421329379081726, 0.420716553926468, 0.420103698968887, 0.419487625360489, 0.418871462345123, 0.418251752853394, 0.417631298303604, 0.417010605335236, 0.416386485099792, 0.415760725736618, 0.415134906768799, 0.414505809545517, 0.413875848054886, 0.413245052099228, 0.412611365318298, 0.411975979804993, 0.411340177059174, 0.410702019929886, 0.410063177347183, 0.409420996904373, 0.408777832984924, 0.408134132623672, 0.40748804807663, 0.40684100985527, 0.406191289424896, 0.405540257692337, 0.404888033866882, 0.40423309803009, 0.403576999902725, 0.402920216321945, 0.402261078357697, 0.401600539684296, 0.400938779115677, 0.400274902582169, 0.39960965514183, 0.398942589759827, 0.39827361702919, 0.39760348200798, 0.396931558847427, 0.396257549524307, 0.395582854747772, 0.394906371831894, 0.394227176904678, 0.393548041582108, 0.392866134643555, 0.392183631658554, 0.391498237848282, 0.390811562538147, 0.390124499797821, 0.389152854681015, 0.388232320547104, 0.387311786413193, 0.386391252279282, 0.38547071814537, 0.384547382593155, 0.38362517952919, 0.382702946662903, 0.381779104471207, 0.380854099988937, 0.37992912530899, 0.379004687070847, 0.378078043460846, 0.377151936292648, 0.376224726438522, 0.375296384096146, 0.374369204044342, 0.37344029545784, 0.37251141667366, 0.371581465005875, 0.370651423931122, 0.369720339775085, 0.368789821863174, 0.367858171463013, 0.366924256086349, 0.365991503000259, 0.365058183670044, 0.364123165607452, 0.363188743591309, 0.362253725528717, 0.36131763458252, 0.360380977392197, 0.359444320201874, 0.358505457639694, 0.357568740844727, 0.356630444526672, 0.355691015720367, 0.35475155711174, 0.353811025619507, 0.352870464324951, 0.35192933678627, 0.350986003875732, 0.350043803453445, 0.349102139472961, 0.348157674074173, 0.347214370965958, 0.346268802881241, 0.345322698354721, 0.344378799200058, 0.34343159198761, 0.342485457658768, 0.341537714004517, 0.340589374303818, 0.339639365673065, 0.338691562414169, 0.337741017341614, 0.336791574954987, 0.335841029882431, 0.334889352321625, 0.333938807249069, 0.332985460758209, 0.332031548023224, 0.331079334020615, 0.330124884843826, 0.329170435667038, 0.328215450048447, 0.327258735895157, 0.326303213834763, 0.325345993041992, 0.324388176202774, 0.323432058095932, 0.322454333305359, 0.321543842554092, 0.320641070604324, 0.319742739200592, 0.318849474191666, 0.317963391542435, 0.317082315683365, 0.316204011440277, 0.315334588289261, 0.314470767974854, 0.31361249089241, 0.31276199221611, 0.311914831399918, 0.311074882745743, 0.310237735509872, 0.309407770633698, 0.308585077524185, 0.307766824960709, 0.306953549385071, 0.306148648262024, 0.305347621440887, 0.304551601409912, 0.303763329982758, 0.302979558706284, 0.302201330661774, 0.301430881023407, 0.300663769245148, 0.29990553855896, 0.299148410558701, 0.29839962720871, 0.297655880451202, 0.296919316053391, 0.296187222003937, 0.295462936162949, 0.294742494821548, 0.294026523828506, 0.293319433927536, 0.292616784572601, 0.291918575763702, 0.291228204965591, 0.290542811155319, 0.289862930774689, 0.289187550544739, 0.288519382476807, 0.287856757640839, 0.287201404571533, 0.286549896001816, 0.285905599594116, 0.2852663397789, 0.284630984067917, 0.284003376960754, 0.283380806446075, 0.282763212919235, 0.282155066728592, 0.281550288200378, 0.28094881772995, 0.280356794595718, 0.27976867556572, 0.279186099767685, 0.27861076593399, 0.27804097533226, 0.277477860450745, 0.276916444301605, 0.27636331319809, 0.275815218687057, 0.275275468826294, 0.274739027023315, 0.274209290742874, 0.273685097694397, 0.27316477894783, 0.272652804851532, 0.272278130054474, 0.272073566913605, 0.271870136260986, 0.271671116352081, 0.271472662687302, 0.271275877952576, 0.271082997322083, 0.270894557237625, 0.270707190036774, 0.270522654056549, 0.270339757204056, 0.270158022642136, 0.269981771707535, 0.269805580377579, 0.26963546872139, 0.269465893507004, 0.269298613071442, 0.269134610891342, 0.26897007226944, 0.268810540437698, 0.268654346466064, 0.268499791622162, 0.268347471952438, 0.268200159072876, 0.268052846193314, 0.267905563116074, 0.267765462398529, 0.267624825239182, 0.26748976111412, 0.267355233430862, 0.267223477363586, 0.267094522714615, 0.266967236995697, 0.266842693090439, 0.26672151684761, 0.266603112220764, 0.266485810279846, 0.266372948884964, 0.266259014606476, 0.26615172624588, 0.266045570373535, 0.265941053628922, 0.265841007232666, 0.265742599964142, 0.265645891427994, 0.265549719333649, 0.265459656715393, 0.265371263027191, 0.265286773443222, 0.265202850103378, 0.26512223482132, 0.265044420957565, 0.26496547460556, 0.264892071485519, 0.264822065830231, 0.264754235744476, 0.264689207077026, 0.264626950025558, 0.264565259218216, 0.264505207538605, 0.264450162649155, 0.264396816492081, 0.264347344636917, 0.264298975467682, 0.264254510402679, 0.26421058177948, 0.26417002081871, 0.264131635427475, 0.264096617698669, 0.264063835144043, 0.264033794403076, 0.264006584882736, 0.263830929994583, 0.263658612966537, 0.263484627008438, 0.263301730155945, 0.263116091489792, 0.262922644615173, 0.26272639632225, 0.262525171041489, 0.26231837272644, 0.262103796005249, 0.261887580156326, 0.261665225028992, 0.261437863111496, 0.26120662689209, 0.260967612266541, 0.260724127292633, 0.260475635528564, 0.260223805904388, 0.259966999292374, 0.259702384471893, 0.2594333589077, 0.259159296751022, 0.258880794048309, 0.25859671831131, 0.258309364318848, 0.258015275001526, 0.257714003324509, 0.257411062717438, 0.25710254907608, 0.256787896156311, 0.256467163562775, 0.256142556667328, 0.255812883377075, 0.255479365587234, 0.255139708518982, 0.254792839288712, 0.254443198442459, 0.254085749387741, 0.253728896379471, 0.253363102674484, 0.252991199493408, 0.25261601805687, 0.252234667539597, 0.251848340034485, 0.25145810842514, 0.251061767339706, 0.250659853219986, 0.250252932310104, 0.249841600656509, 0.249425783753395, 0.249005541205406, 0.248575285077095, 0.248144462704659, 0.247707545757294, 0.247266173362732, 0.246818706393242, 0.246365651488304, 0.245908722281456, 0.245444014668465, 0.244978189468384, 0.244505658745766, 0.24402704834938, 0.24354399740696, 0.243055373430252, 0.242562860250473, 0.242064237594604, 0.241560608148575, 0.241052538156509, 0.240537777543068, 0.240018025040627, 0.239494383335114, 0.238971367478371, 0.238214254379272, 0.237457171082497, 0.236694499850273, 0.235932365059853, 0.235166639089584, 0.23439759016037, 0.23362572491169, 0.232850298285484, 0.232077062129974, 0.231296867132187, 0.230515599250793, 0.229730695486069, 0.228942722082138, 0.228154212236404, 0.227363169193268, 0.226568534970284, 0.225771427154541, 0.224970385432243, 0.224168255925179, 0.223363041877747, 0.222557291388512, 0.221745997667313, 0.220932736992836, 0.220117539167404, 0.219299823045731, 0.21848101913929, 0.217657476663589, 0.216831162571907, 0.216002628207207, 0.215171873569489, 0.214340820908546, 0.213505044579506, 0.212665125727654, 0.211823493242264, 0.210980489850044, 0.210135012865067, 0.209286168217659, 0.208435118198395, 0.207580178976059, 0.206724122166634, 0.205864161252975, 0.205004215240479, 0.204138994216919, 0.203271821141243, 0.202402427792549, 0.201529413461685, 0.200657218694687, 0.199778646230698, 0.198899522423744, 0.198016777634621, 0.197131544351578, 0.196246027946472, 0.195354402065277, 0.194461643695831, 0.193565845489502, 0.192668363451958, 0.191769778728485, 0.19086591899395, 0.189960107207298, 0.189050689339638, 0.188140153884888, 0.187227115035057, 0.186312139034271, 0.185394376516342, 0.184471607208252, 0.183548852801323, 0.182621628046036, 0.18169441819191, 0.180762201547623, 0.179828599095345, 0.178891390562057, 0.178052365779877, 0.177240237593651, 0.176430851221085, 0.175624832510948, 0.174821019172668, 0.174019992351532, 0.17322202026844, 0.172426268458366, 0.171633869409561, 0.170844227075577, 0.170057103037834, 0.169272765517235, 0.168491184711456, 0.167711839079857, 0.166936635971069, 0.166163146495819, 0.16539241373539, 0.164624467492104, 0.163860127329826, 0.163098007440567, 0.162338405847549, 0.16158127784729, 0.160827219486237, 0.160076215863228, 0.159327998757362, 0.158582285046577, 0.1578399091959, 0.157099202275276, 0.156361818313599, 0.155628055334091, 0.154895678162575, 0.154166638851166, 0.153440654277802, 0.152717173099518, 0.151996180415154, 0.151278540492058, 0.150562569499016, 0.149849936366081, 0.149140626192093, 0.148434370756149, 0.147729784250259, 0.147028267383575, 0.146329507231712, 0.145633548498154, 0.144940361380577, 0.144250243902206, 0.143562883138657, 0.142877757549286, 0.14219568669796, 0.14151668548584, 0.140840172767639, 0.140165880322456, 0.139494657516479, 0.138826757669449, 0.138161659240723, 0.137498766183853, 0.136838912963867, 0.136181592941284, 0.135526776313782, 0.134875267744064, 0.134226828813553, 0.133580610156059, 0.132936626672745, 0.132295981049538, 0.131658375263214, 0.131023287773132, 0.130390956997871, 0.129761710762978, 0.129134386777878, 0.128510683774948, 0.127889767289162, 0.127188503742218, 0.126608714461327, 0.126032814383507, 0.12545970082283, 0.124889925122261, 0.124325141310692, 0.123763144016266, 0.123205035924911, 0.122651375830173, 0.122099936008453, 0.121552392840385, 0.121009849011898, 0.120470091700554, 0.119933664798737, 0.119401678442955, 0.118873588740826, 0.118348270654678, 0.1178263053298, 0.117310434579849, 0.116796247661114, 0.116285942494869, 0.115780644118786, 0.115277014672756, 0.114777840673923, 0.114283084869385, 0.113791696727276, 0.113303065299988, 0.112820006906986, 0.112338609993458, 0.111861668527126, 0.111388057470322, 0.110919997096062, 0.110453620553017, 0.109991669654846, 0.109533630311489, 0.109078355133533, 0.108627535402775, 0.108180597424507, 0.107737563550472, 0.107297293841839, 0.106860935688019, 0.106429010629654, 0.105999313294888, 0.105574607849121, 0.105153821408749, 0.104735784232616, 0.104321651160717, 0.10391141474247, 0.103505067527294, 0.103102043271065, 0.102704584598541, 0.102308236062527, 0.10191522538662, 0.101527780294418, 0.101144216954708, 0.100763440132141, 0.100385993719101, 0.100013546645641, 0.0996416658163071, 0.0992770045995712, 0.098915122449398, 0.098557136952877, 0.0982019305229187, 0.0978511646389961, 0.0975031778216362, 0.0971596390008926, 0.0968205481767654, 0.0964831337332726, 0.0961501598358154, 0.0958210751414299, 0.095495879650116, 0.0951745808124542, 0.0949075669050217, 0.0946101695299149, 0.0943133234977722, 0.0940203741192818, 0.0937313213944435, 0.0934444814920425, 0.0931598693132401, 0.0928819328546524, 0.0926056578755379, 0.0923316031694412, 0.092060886323452, 0.0917946249246597, 0.0915300250053406, 0.0912687554955482, 0.0910119414329529, 0.0907584503293037, 0.0905066356062889, 0.090259276330471, 0.0900135710835457, 0.0897728726267815, 0.0895355120301247, 0.0893003717064857, 0.0890674591064453, 0.0888406559824944, 0.0886149704456329, 0.0883920565247536, 0.0881735980510712, 0.0879584699869156, 0.0877455696463585, 0.0875359997153282, 0.0873314365744591, 0.0871285423636436, 0.0869284272193909, 0.0867333114147186, 0.0865398645401001, 0.0863497480750084, 0.0861635282635689, 0.0859806388616562, 0.0857994258403778, 0.0856220945715904, 0.0854486599564552, 0.0852785557508469, 0.0851106867194176, 0.0849472507834435, 0.0847860500216484, 0.0846287310123444, 0.0844747498631477, 0.0843224450945854, 0.0841756835579872, 0.0840317159891129, 0.0838894098997116, 0.083749882876873, 0.0836148038506508, 0.0834841728210449, 0.083354651927948, 0.0832295790314674, 0.0831083878874779, 0.0829883217811584, 0.0828715860843658, 0.0827604085206985, 0.0826509073376656, 0.082544170320034, 0.0824424475431442, 0.0823429375886917, 0.0822456628084183, 0.0821522697806358, 0.0820622220635414, 0.0819760635495186, 0.0818921253085136, 0.0818120762705803, 0.0817342475056648, 0.0816819742321968, 0.0816432163119316, 0.0816055461764336, 0.0815706551074982, 0.0815357118844986, 0.0815024152398109, 0.0814702063798904, 0.0814407616853714, 0.0814112797379494, 0.0813834294676781, 0.0813577771186829, 0.0813326835632324, 0.0813086405396461, 0.0812862515449524, 0.0812660604715347, 0.0812458544969559, 0.0812272801995277, 0.0812114402651787, 0.0811956003308296, 0.0811814069747925, 0.0811682716012001, 0.0811562314629555, 0.0811469405889511, 0.081137627363205, 0.0811299756169319, 0.0811250433325768, 0.0811200961470604, 0.0811162441968918, 0.0811140313744545, 0.0811145678162575, 0.0811145231127739, 0.0811166688799858, 0.0811210200190544, 0.0811253488063812, 0.0811313018202782, 0.0811383351683617, 0.081148162484169, 0.0811579376459122, 0.0811693370342255, 0.0811829566955566, 0.0811971053481102, 0.0812123194336891, 0.0812291949987411, 0.0812471434473991, 0.0812678411602974, 0.0812885388731956, 0.0813108533620834, 0.0813342481851578, 0.0813604146242142, 0.0813865661621094, 0.0814137756824493, 0.0814437419176102, 0.0814742371439934, 0.0815058350563049, 0.081539623439312, 0.0815750434994698, 0.0816104337573051, 0.0816474854946136, 0.0816867277026176, 0.0817259252071381, 0.0817673355340958, 0.0818103849887848, 0.0818550810217857, 0.0819002985954285, 0.0819465965032578, 0.0819956660270691, 0.0820452496409416, 0.0820953547954559, 0.0821476653218269, 0.0822010785341263, 0.0822566673159599, 0.082314059138298, 0.082367941737175, 0.0824201181530952, 0.0824706107378006, 0.0825194120407104, 0.0825676098465919, 0.0826130211353302, 0.0826584100723267, 0.0827015340328217, 0.0827446356415749, 0.082784928381443, 0.08282520622015, 0.0828626602888107, 0.0829001069068909, 0.0829341635107994, 0.0829687863588333, 0.0830005928874016, 0.0830317959189415, 0.0830624252557755, 0.0830913856625557, 0.0831175222992897, 0.0831441730260849, 0.0831669196486473, 0.0831907466053963, 0.0832123383879662, 0.0832316726446152, 0.0832509696483612, 0.0832680091261864, 0.0832845121622086, 0.0832987278699875, 0.0833118036389351, 0.0833237543702126, 0.0833351314067841, 0.083343118429184, 0.0833510980010033, 0.0833568200469017, 0.0833625271916389, 0.0833659768104553, 0.0833688378334045, 0.0833688974380493, 0.0833683907985687, 0.0833656117320061, 0.0833628177642822, 0.0833577662706375, 0.0833521336317062, 0.0833442658185959, 0.0833352506160736, 0.0833256393671036, 0.0833137854933739, 0.0833002552390099, 0.0832861214876175, 0.0832702964544296, 0.0832527726888657, 0.0832346901297569, 0.0832143425941467, 0.08319341391325, 0.0831707790493965, 0.0831464827060699, 0.083121582865715, 0.0830944180488586, 0.083065576851368, 0.0830367207527161, 0.0830050334334373, 0.0829727798700333, 0.0829393789172173, 0.0829037427902222, 0.0828675031661987, 0.082829587161541, 0.0827899649739265, 0.0827497690916061, 0.0827073305845261, 0.0826637297868729, 0.0825849175453186, 0.0824798569083214, 0.0823725759983063, 0.08226528018713, 0.0821524411439896, 0.0820395946502686, 0.081921748816967, 0.0818027928471565, 0.081681601703167, 0.0815581977367401, 0.0814314633607864, 0.0813024938106537, 0.0811713039875031, 0.0810384526848793, 0.0809016972780228, 0.0807627290487289, 0.0806226432323456, 0.0804775655269623, 0.0803324729204178, 0.0801851600408554, 0.0800334066152573, 0.079879991710186, 0.0797260105609894, 0.0795664712786674, 0.0794069245457649, 0.0792429372668266, 0.0790772885084152, 0.0789105221629143, 0.078739307820797, 0.0785664394497871, 0.0783913284540176, 0.0782140046358109, 0.0780338943004608, 0.077850453555584, 0.0776653438806534, 0.0774785652756691, 0.077287346124649, 0.0770966783165932, 0.0769021138548851, 0.0767031088471413, 0.0765046626329422, 0.0763017609715462, 0.076097197830677, 0.0758904069662094, 0.0756808370351791, 0.0754690393805504, 0.0752550289034843, 0.0750382393598557, 0.0748181045055389, 0.0745974257588387, 0.0743728429079056, 0.0741454809904099, 0.0739153474569321, 0.0736857727169991, 0.0734517499804497, 0.0732154920697212, 0.0729764625430107, 0.0727352127432823, 0.0724900662899017, 0.0722454711794853, 0.071995884180069, 0.0717457309365273, 0.0714922472834587, 0.0712354332208633, 0.0709769427776337, 0.0707173496484756, 0.0704533085227013, 0.0701870322227478, 0.0699191018939018, 0.0696489363908768, 0.0693748891353607, 0.0690490007400513, 0.0686993449926376, 0.0683502554893494, 0.0680011659860611, 0.067652627825737, 0.0673029720783234, 0.0669544339179993, 0.0666059032082558, 0.0662579163908958, 0.0659082606434822, 0.0655625090003014, 0.0652128532528877, 0.0648665428161621, 0.064518004655838, 0.0641694590449333, 0.063821479678154, 0.0634751692414284, 0.0631277412176132, 0.062781423330307, 0.0624334365129471, 0.062086571007967, 0.0617397017776966, 0.0613939389586449, 0.0610476210713387, 0.0607001967728138, 0.0603544414043427, 0.0600086823105812, 0.059662364423275, 0.0593160502612591, 0.058971956372261, 0.0586256459355354, 0.0582804381847382, 0.0579352341592312, 0.0575900338590145, 0.0572453886270523, 0.0569007396697998, 0.0565549768507481, 0.0562103316187859, 0.0558662451803684, 0.0555221512913704, 0.0551780536770821, 0.0548345223069191, 0.0544909909367561, 0.0541452281177044, 0.0538027994334698, 0.0534587129950523, 0.0531157292425632, 0.0527716428041458, 0.0524297691881657, 0.0520856827497482, 0.0517443679273129, 0.0514008328318596, 0.0510567389428616, 0.0507154278457165, 0.0503730028867722, 0.0500300228595734, 0.0496887117624283, 0.0493468455970287, 0.0490055307745934, 0.0486636608839035, 0.0483212396502495, 0.0479804798960686, 0.0476391725242138, 0.0472978577017784, 0.0469571053981781, 0.0466146767139435, 0.0462761484086514, 0.045934833586216, 0.0455935224890709, 0.0452544316649437, 0.0449136756360531, 0.0445723608136177, 0.0443221256136894, 0.0440742038190365, 0.0438301712274551, 0.0435861386358738, 0.0433448888361454, 0.0431069694459438, 0.0428707227110863, 0.0426361374557018, 0.0424043349921703, 0.0421742014586926, 0.0419473983347416, 0.0417233780026436, 0.0414988026022911, 0.0412792302668095, 0.0410602129995823, 0.0408445298671722, 0.0406316258013248, 0.0404192805290222, 0.0402097143232822, 0.0400034785270691, 0.0397983603179455, 0.0395949073135853, 0.0393959023058414, 0.0391968935728073, 0.0390028916299343, 0.0388083346188068, 0.038616556674242, 0.0384281128644943, 0.0382413379848003, 0.0380578935146332, 0.0378744527697563, 0.0376943461596966, 0.0375170223414898, 0.0373413637280464, 0.0371679253876209, 0.0369972698390484, 0.0368282869458199, 0.0366626307368279, 0.0364986434578896, 0.0363346636295319, 0.0361762344837189, 0.0360189229249954, 0.0358632728457451, 0.0357109643518925, 0.0355592034757137, 0.035410787910223, 0.0352651439607143, 0.0351211726665497, 0.0349810905754566, 0.0348398946225643, 0.0347037017345428, 0.0345686264336109, 0.0344352126121521, 0.0343040227890015, 0.0341772846877575, 0.0340510979294777, 0.0339282490313053, 0.0338065102696419, 0.0336864441633224, 0.0335708148777485, 0.0334557481110096, 0.0333434604108334, 0.0332333967089653, 0.0331249982118607, 0.0330199375748634, 0.0329171009361744, 0.0328148193657398, 0.0327169820666313, 0.0326202586293221, 0.0325263142585754, 0.0324334800243378, 0.0323855690658092, 0.0323248766362667, 0.0322654284536839, 0.0322076827287674, 0.0321500115096569, 0.0320928581058979, 0.032038040459156, 0.0319838747382164, 0.0319308899343014, 0.0318790189921856, 0.0318283624947071, 0.0317783020436764, 0.0317288972437382, 0.0316817164421082, 0.0316351279616356, 0.031589787453413, 0.0315461494028568, 0.0315031409263611, 0.0314601995050907, 0.0314189232885838, 0.0313793830573559, 0.0313405096530914, 0.0313028134405613, 0.0312661938369274, 0.0312308240681887, 0.0311960838735104, 0.0311618968844414, 0.0311295185238123, 0.0310987681150436, 0.0310692396014929, 0.0310403667390347, 0.0310126412659883, 0.0309843625873327, 0.03095892816782, 0.0309341587126255, 0.0309111252427101, 0.030888644978404, 0.0308673810213804, 0.0308461897075176, 0.0308267325162888, 0.0308089796453714, 0.0307917855679989, 0.0307763945311308, 0.0307615902274847, 0.0307480096817017, 0.0307355001568794, 0.0307231321930885, 0.0307124294340611, 0.0307035017758608, 0.0306951981037855, 0.0306880082935095, 0.0306820292025805, 0.0306761264801025, 0.0306719206273556, 0.0306693837046623, 0.0306681338697672, 0.0306674726307392, 0.0306679606437683, 0.0306696593761444, 0.0306713301688433, 0.0306752920150757, 0.0306799449026585, 0.0306863039731979, 0.0306932143867016, 0.0307013802230358, 0.030710693448782, 0.0307206306606531, 0.0307311210781336, 0.0307444632053375, 0.0307579096406698, 0.0307725351303816, 0.030788341537118, 0.0307458098977804, 0.0307330228388309, 0.0307202041149139, 0.0307073146104813, 0.0306942518800497, 0.030681325122714, 0.030668368563056, 0.0306553393602371, 0.0306422747671604, 0.0306290723383427, 0.0306159388273954, 0.0306027419865131, 0.0305895712226629, 0.0305762309581041, 0.0305628553032875, 0.0305494796484709, 0.0305361375212669, 0.0305227264761925, 0.030509177595377, 0.030495697632432, 0.0304821468889713, 0.0304685290902853, 0.0304548740386963, 0.0304411128163338, 0.0304274260997772, 0.0304137039929628, 0.0303999800235033, 0.0303860474377871, 0.0303722191601992, 0.0303582884371281, 0.0303442869335413, 0.0303302872925997, 0.0303162503987551, 0.0303022135049105, 0.0302881076931953, 0.0302739329636097, 0.0302596911787987, 0.030245516449213, 0.0302312336862087, 0.0302168503403664, 0.0302025005221367, 0.0301881525665522, 0.0301737003028393, 0.0301592499017715, 0.0301447939127684, 0.0301301665604115, 0.0301156118512154, 0.0301009491086006, 0.0300862547010183, 0.0300715230405331, 0.03005675598979, 0.0300420261919498, 0.0300272218883038, 0.0300123561173677, 0.0299974177032709, 0.0299825109541416, 0.0299674328416586, 0.0299524236470461, 0.0299373455345631, 0.0299222655594349, 0.0299071203917265, 0.0298919733613729, 0.0298766866326332, 0.029861468821764, 0.0298461467027664, 0.0298307556658983, 0.0298153646290302, 0.0297999028116465, 0.0297845117747784, 0.0297690499573946, 0.0297534856945276, 0.0297386888414621, 0.0297215934842825, 0.0297037679702044, 0.029685877263546, 0.0296676382422447, 0.0296490155160427, 0.0296300444751978, 0.0296110790222883, 0.0295913089066744, 0.0295717492699623, 0.0295513514429331, 0.0295307151973248, 0.0295101478695869, 0.029488779604435, 0.0294675882905722, 0.0294456332921982, 0.0294237080961466, 0.0294012632220984, 0.0293786805123091, 0.0293555799871683, 0.0293319877237082, 0.0293084308505058, 0.0292843878269196, 0.0292602088302374, 0.0292354021221399, 0.0292108058929443, 0.0291853733360767, 0.029159976169467, 0.0291338488459587, 0.0291078630834818, 0.0290812123566866, 0.0290541872382164, 0.0290272925049067, 0.0289996732026339, 0.0289720501750708, 0.0289439428597689, 0.02891556173563, 0.0288866199553013, 0.0288577508181334, 0.0288281477987766, 0.028798546642065, 0.0287685673683882, 0.0287380609661341, 0.0287076588720083, 0.0286765303462744, 0.0286454036831856, 0.028613680973649, 0.0285818912088871, 0.0285496860742569, 0.0285168178379536, 0.0284842997789383, 0.0284509472548962, 0.0284175239503384, 0.0283836144953966, 0.028349494561553, 0.0283149275928736, 0.0282803941518068, 0.0282451324164867, 0.0282099712640047, 0.0281740818172693, 0.0281378775835037, 0.0281018149107695, 0.0280649866908789, 0.0280281603336334, 0.0279906392097473, 0.0279531162232161, 0.0279151070863008, 0.0278770308941603, 0.0278382580727339, 0.0277992766350508, 0.0277601536363363, 0.0277436189353466, 0.0276883766055107, 0.0276327915489674, 0.0275774095207453, 0.0275214742869139, 0.0274660922586918, 0.0274100191891193, 0.0273540150374174, 0.027297867462039, 0.0272414460778236, 0.0271852351725101, 0.0271285995841026, 0.0270720403641462, 0.0270153395831585, 0.0269585717469454, 0.0269013848155737, 0.0268444754183292, 0.026787081733346, 0.0267297551035881, 0.0266724992543459, 0.0266146883368492, 0.0265572220087051, 0.0264992695301771, 0.0264414604753256, 0.0263833682984114, 0.0263251401484013, 0.0262669809162617, 0.0262087527662516, 0.0261500366032124, 0.0260912533849478, 0.026032468304038, 0.0259736161679029, 0.0259147584438324, 0.0258554182946682, 0.0257964953780174, 0.0257368069142103, 0.0256776753813028, 0.0256178472191095, 0.0255579520016909, 0.0254984013736248, 0.0254383683204651, 0.0253784004598856, 0.025318019092083, 0.0252577736973763, 0.0251974612474442, 0.0251369383186102, 0.025076000019908, 0.0250152703374624, 0.0249544009566307, 0.0248934626579285, 0.0248324535787106, 0.0247708894312382, 0.0247098822146654, 0.0246482472866774, 0.0245866123586893, 0.0245247725397348, 0.0244629979133606, 0.0244010873138905, 0.0243387594819069, 0.0242767762392759, 0.0242143105715513, 0.0241519119590521, 0.0240893755108118, 0.0240266993641853, 0.0239636767655611, 0.0239011384546757, 0.0238378383219242, 0.0237746760249138, 0.0237114448100328, 0.0236477944999933, 0.0235846322029829, 0.0235208459198475, 0.0234477464109659, 0.0233909077942371, 0.0233340691775084, 0.0232777148485184, 0.0232219193130732, 0.023166261613369, 0.0231108795851469, 0.0230561252683401, 0.0230013728141785, 0.0229469630867243, 0.0228931121528149, 0.0228395406156778, 0.0227862428873777, 0.0227332953363657, 0.022680627182126, 0.0226282346993685, 0.0225764662027359, 0.0225249789655209, 0.0224735587835312, 0.0224227663129568, 0.0223722495138645, 0.0223218724131584, 0.0222719833254814, 0.0222223699092865, 0.0221731029450893, 0.022124394774437, 0.0220755450427532, 0.022027462720871, 0.0219795163720846, 0.0219319202005863, 0.0218848772346973, 0.021837905049324, 0.0217916276305914, 0.0217451434582472, 0.0216994229704142, 0.0216539781540632, 0.021608604118228, 0.0215639248490334, 0.0215193144977093, 0.0214751213788986, 0.0214315541088581, 0.0213876403868198, 0.0213445592671633, 0.0213019624352455, 0.0212595090270042, 0.0212172605097294, 0.0211753621697426, 0.0211340170353651, 0.0210926737636328, 0.0210519544780254, 0.0210113748908043, 0.0209714230149984, 0.0209317449480295, 0.0208920687437057, 0.0208528097718954, 0.0208141766488552, 0.0207756813615561, 0.0207377411425114, 0.020699942484498, 0.020662559196353, 0.0206254534423351, 0.0205886960029602, 0.020552285015583, 0.0205160845071077, 0.0204805061221123, 0.0204448606818914, 0.0204099789261818, 0.0203753057867289, 0.0203406326472759, 0.0203067231923342, 0.0202730931341648, 0.0202288180589676, 0.0202131122350693, 0.0201978273689747, 0.0201824698597193, 0.0201672539114952, 0.0201523154973984, 0.0201373063027859, 0.0201225746423006, 0.0201081223785877, 0.0200932528823614, 0.0200789384543896, 0.0200646948069334, 0.0200503803789616, 0.0200364124029875, 0.0200225152075291, 0.020008759573102, 0.0199948605149984, 0.0199813116341829, 0.0199676901102066, 0.0199544224888086, 0.0199412889778614, 0.0199279468506575, 0.0199152994900942, 0.0199022367596626, 0.0198894515633583, 0.0198768060654402, 0.0198643673211336, 0.0198518596589565, 0.0198396295309067, 0.0198275409638882, 0.0198152400553226, 0.0198034290224314, 0.0197916850447655, 0.0197798032313585, 0.0197684094309807, 0.0197570826858282, 0.0197454784065485, 0.0197344291955233, 0.0197233129292727, 0.0197121240198612, 0.0197013542056084, 0.0196908637881279, 0.0196800231933594, 0.0196695309132338, 0.0196593161672354, 0.0196487549692392, 0.0196386780589819, 0.0196288824081421, 0.0196188744157553, 0.0196090079843998, 0.0195994209498167, 0.0195897612720728, 0.0195804499089718, 0.0195713490247726, 0.0195619687438011, 0.0195530038326979, 0.0195439718663692, 0.0195349380373955, 0.0195263214409351, 0.0195177067071199, 0.0195092987269163, 0.0195009596645832, 0.0194927603006363, 0.0194844212383032, 0.0194765012711287, 0.0194687191396952, 0.0194607973098755, 0.0194534324109554, 0.0194458588957787, 0.0194382146000862, 0.0194309893995523, 0.0194239020347595, 0.0194135382771492, 0.0193964466452599, 0.0193788651376963, 0.0193612854927778, 0.0193430110812187, 0.0193246677517891, 0.0193060450255871, 0.0192870050668716, 0.0192676894366741, 0.0192480254918337, 0.0192278046160936, 0.0192076563835144, 0.0191868077963591, 0.0191659647971392, 0.019144631922245, 0.0191230215132236, 0.0191009938716888, 0.019078690558672, 0.0190558303147554, 0.0190331786870956, 0.0190097615122795, 0.0189861357212067, 0.0189621634781361, 0.018937774002552, 0.0189133863896132, 0.018888371065259, 0.0188632868230343, 0.0188375785946846, 0.0188115891069174, 0.0187853928655386, 0.0187587812542915, 0.0187318902462721, 0.0187048595398664, 0.0186771359294653, 0.0186496209353209, 0.0186213403940201, 0.0185928512364626, 0.0185640156269073, 0.0185347609221935, 0.0185053702443838, 0.0184753518551588, 0.0184453353285789, 0.018414692953229, 0.0183838419616222, 0.0183528512716293, 0.018321443349123, 0.0182895492762327, 0.0182574484497309, 0.0182249285280704, 0.0181921329349279, 0.0181591268628836, 0.0181257743388414, 0.0180917959660292, 0.0180578883737326, 0.018023282289505, 0.0179886817932129, 0.0179535206407309, 0.017918361350894, 0.0178824365139008, 0.0178463757038116, 0.0178099647164345, 0.017773138359189, 0.0177363120019436, 0.0176988579332829, 0.0176612678915262, 0.0176231190562248, 0.0175848342478275, 0.017546059563756, 0.0175071507692337, 0.0174678899347782, 0.0174286309629679, 0.0173807572573423, 0.0173226669430733, 0.0172645784914494, 0.0172064881771803, 0.0171483978629112, 0.0170903075486422, 0.0170322190970182, 0.0169739909470081, 0.0169160403311253, 0.01685781031847, 0.0167998597025871, 0.0167414918541908, 0.0166836809366941, 0.0166253130882978, 0.016567500308156, 0.0165091324597597, 0.016451321542263, 0.0163929536938667, 0.01633514277637, 0.0162767749279737, 0.0162189640104771, 0.0161605961620808, 0.0161026436835527, 0.0160446930676699, 0.015986742451787, 0.0159285143017769, 0.0158705655485392, 0.0158123355358839, 0.0157542452216148, 0.0156961549073458, 0.0156380664557219, 0.0155798383057117, 0.0155218876898289, 0.0154636595398188, 0.0154059855267406, 0.0153477564454079, 0.015289805829525, 0.0152317164465785, 0.0151736279949546, 0.0151155386120081, 0.0150574473664165, 0.0149993570521474, 0.0149412676692009, 0.0148831782862544, 0.0148250898346305, 0.014767000451684, 0.0147087723016739, 0.0146506810560822, 0.0145925907418132, 0.0145343625918031, 0.0144764119759202, 0.0144181838259101, 0.0143602341413498, 0.0143020041286945, 0.0142440544441342, 0.014185824431479, 0.0141278738155961, 0.014069645665586, 0.0140116959810257, 0.0139534678310156, 0.0138955172151327, 0.0138371484354138, 0.0137793375179172, 0.0137209687381983, 0.0136631578207016, 0.0136052072048187, 0.0135471178218722, 0.0134890293702483, 0.0134307993575931, 0.013372709043324, 0.0133148971945047, 0.0132568078115582, 0.0132239265367389, 0.0131816789507866, 0.0131398485973477, 0.0130984345450997, 0.0130572989583015, 0.0130164427682757, 0.0129764201119542, 0.0129363955929875, 0.0128972055390477, 0.0128581542521715, 0.0128193823620677, 0.0127811646088958, 0.0127435028553009, 0.0127059817314148, 0.0126691535115242, 0.0126324659213424, 0.0125961937010288, 0.0125603405758739, 0.0125251794233918, 0.0124901598319411, 0.012455833144486, 0.0124215083196759, 0.0123875979334116, 0.0123542454093695, 0.012321587651968, 0.012288928963244, 0.0122569659724832, 0.0122252805158496, 0.0121938725933433, 0.0121631603688002, 0.0121327256783843, 0.0121025685220957, 0.0120731070637703, 0.0120437843725085, 0.0120150176808238, 0.0119862509891391, 0.0119583168998361, 0.0119306622073054, 0.0119035625830293, 0.0118766026571393, 0.0118500590324402, 0.0118239326402545, 0.0117986397817731, 0.0117733459919691, 0.0117487488314509, 0.0117244282737374, 0.0117001086473465, 0.0116763450205326, 0.0116535536944866, 0.011630623601377, 0.0116085270419717, 0.0115865701809525, 0.0115646123886108, 0.0115436287596822, 0.0115230605006218, 0.0115027707070112, 0.0114828972145915, 0.011463163420558, 0.0114441234618425, 0.0114253638312221, 0.0114071583375335, 0.0113893700763583, 0.0113718593493104, 0.0113550443202257, 0.0113385068252683, 0.0113219683989882, 0.0113062663003802, 0.0112907011061907, 0.0112759694457054, 0.0112612387165427, 0.0112467855215073, 0.0112345041707158, 0.0112281460314989, 0.0112220654264092, 0.0112159606069326, 0.0112101240083575, 0.0112045556306839, 0.0111986929550767, 0.011193516664207, 0.011188461445272, 0.011183406226337, 0.0111788809299469, 0.0111739216372371, 0.0111695090308785, 0.0111654959619045, 0.0111614754423499, 0.0111578619107604, 0.0111540919169784, 0.0111504439264536, 0.0111472131684422, 0.0111441034823656, 0.0111413849517703, 0.011138666421175, 0.0111360605806112, 0.0111335860565305, 0.0111313788220286, 0.0111294342204928, 0.011127756908536, 0.0111260721459985, 0.0111249256879091, 0.0111233443021774, 0.0111223021522164, 0.0111215300858021, 0.011120886541903, 0.0111205046996474, 0.0111201135441661, 0.0111199831590056, 0.0111198350787163, 0.0111201051622629, 0.0111204879358411, 0.0111212776973844, 0.0111220590770245, 0.0111229531466961, 0.0111241266131401, 0.0111254118382931, 0.0111271142959595, 0.0111287906765938, 0.0111307539045811, 0.0111328288912773, 0.0111348880454898, 0.0111374938860536, 0.0111400820314884, 0.0111429318785667, 0.011146049015224, 0.011149019934237, 0.0111525282263756, 0.0111561678349972, 0.0111597897484899, 0.0111639592796564, 0.011168111115694, 0.0111721055582166, 0.0111766317859292, 0.011181304231286, 0.0111863762140274, 0.0111914314329624, 0.0111966170370579, 0.011202210560441, 0.011207508854568, 0.0112134842202067, 0.0112194521352649, 0.0112255401909351, 0.0112320370972157, 0.0112325763329864, 0.0112301092594862, 0.0112276505678892, 0.0112252188846469, 0.0112228048965335, 0.0112203722819686, 0.0112179834395647, 0.0112156206741929, 0.0112132681533694, 0.0112109314650297, 0.0112086115404963, 0.0112063102424145, 0.01120400801301, 0.011201742105186, 0.0111994836479425, 0.011197242885828, 0.011195027269423, 0.0111928479745984, 0.0111906677484512, 0.0111884698271751, 0.0111863156780601, 0.0111841876059771, 0.0111820604652166, 0.0111799668520689, 0.0111778732389212, 0.0111757880076766, 0.0111737484112382, 0.0111716724932194, 0.0111696571111679, 0.0111676501110196, 0.011165670119226, 0.0111636808142066, 0.0111617352813482, 0.0111598251387477, 0.0111578796058893, 0.0111559769138694, 0.0111540919169784, 0.0111522162333131, 0.0111503563821316, 0.0111485067754984, 0.0111467093229294, 0.0111448764801025, 0.0111430697143078, 0.011141306720674, 0.0111395437270403, 0.0111377881839871, 0.0111360689625144, 0.0111343581229448, 0.0111326472833753, 0.0111309876665473, 0.0111293382942677, 0.0111276870593429, 0.0111260628327727, 0.0111244479194283, 0.0111228674650192, 0.0111212860792875, 0.0111197307705879, 0.0111181940883398, 0.0111166480928659, 0.0111151542514563, 0.0111136697232723, 0.0111121842637658, 0.0111107248812914, 0.011109265498817, 0.0111078321933746, 0.0111064165830612, 0.0111050177365541, 0.0111036552116275, 0.0111022908240557, 0.0111009441316128, 0.0110996244475245, 0.0110982861369848, 0.011103592813015, 0.0111092394217849, 0.0111146941781044, 0.0111199058592319, 0.0111252907663584, 0.0111305024474859, 0.0111356442794204, 0.0111405765637755, 0.0111455097794533, 0.0111503563821316, 0.0111550819128752, 0.0111597031354904, 0.0111642191186547, 0.0111687360331416, 0.0111730257049203, 0.0111772827804089, 0.0111815566197038, 0.0111854476854205, 0.0111895818263292, 0.011193472892046, 0.0111972596496344, 0.011200925335288, 0.0112045556306839, 0.0112081514671445, 0.0112116262316704, 0.0112147871404886, 0.0112181920558214, 0.0112213371321559, 0.0112243415787816, 0.0112272780388594, 0.0112302480265498, 0.011233028024435, 0.0112356329336762, 0.0112383430823684, 0.0112407924607396, 0.0112433284521103, 0.0112455002963543, 0.0112476889044046, 0.0112499296665192, 0.0112519795075059, 0.0112539082765579, 0.0112557495012879, 0.0112574687227607, 0.0112592233344913, 0.011260787025094, 0.0112623851746321, 0.0112636014819145, 0.0112649220973253, 0.0112661896273494, 0.0112673360854387, 0.0112683260813355, 0.0112692816182971, 0.011270116083324, 0.0112709142267704, 0.0112714525312185, 0.0112721128389239, 0.011272513307631, 0.0112729473039508, 0.0112732592970133, 0.0112733980640769, 0.0112735033035278, 0.0112735023722053, 0.0112735200673342, 0.0112732946872711, 0.0112728774547577, 0.0112726343795657, 0.0112721649929881, 0.011271714232862, 0.0112709319218993, 0.0112702548503876, 0.0112695433199406, 0.0112631153315306, 0.0112599181011319, 0.0112563744187355, 0.0112523436546326, 0.0112481061369181, 0.0112434504553676, 0.011238724924624, 0.0112334443256259, 0.0112279551103711, 0.011222118511796, 0.0112157948315144, 0.0112094022333622, 0.0112020364031196, 0.0111950887367129, 0.0111873056739569, 0.0111792450770736, 0.0111711164936423, 0.0111624300479889, 0.0111533971503377, 0.0111442254856229, 0.0111344270408154, 0.011124630458653, 0.0111139295622706, 0.0111031588166952, 0.0110923890024424, 0.0110808545723557, 0.0110693890601397, 0.0110573684796691, 0.0110449306666851, 0.0110322143882513, 0.0110188722610474, 0.0110055319964886, 0.0109917735680938, 0.0109777385368943, 0.010963493026793, 0.0109486924484372, 0.0109334066510201, 0.0109181189909577, 0.010902346111834, 0.0108863646164536, 0.01086968742311, 0.0108527326956391, 0.0108357099816203, 0.0108180604875088, 0.0108002023771405, 0.0107823442667723, 0.0107637224718928, 0.0107449619099498, 0.0107257142663002, 0.0107059106230736, 0.0106862457469106, 0.0106657482683659, 0.0106453895568848, 0.0106244739145041, 0.010603210888803, 0.0105818789452314, 0.0105599211528897, 0.0105374772101641, 0.0105148255825043, 0.0104917557910085, 0.0104687558487058, 0.0104449223726988, 0.0104209501296282, 0.010396839119494, 0.0103721022605896, 0.0103472266346216, 0.0103219337761402, 0.0102961547672749, 0.0102700982242823, 0.0102437622845173, 0.0102171497419477, 0.0101900491863489, 0.0101524526253343, 0.010112289339304, 0.010071606375277, 0.010030853562057, 0.00999016966670752, 0.00994879193603992, 0.00990776065737009, 0.00986631214618683, 0.00982472486793995, 0.00978310406208038, 0.00974113494157791, 0.00969913136214018, 0.00965695269405842, 0.00961428973823786, 0.0095717990770936, 0.00952899642288685, 0.0094860540702939, 0.00944300834089518, 0.00939961522817612, 0.00935636088252068, 0.00931268837302923, 0.00926887895911932, 0.00922492984682322, 0.0091807022690773, 0.00913630146533251, 0.00909196957945824, 0.00904725585132837, 0.00900250673294067, 0.00895748008042574, 0.0089122112840414, 0.00886697601526976, 0.00882160197943449, 0.0087754987180233, 0.00872970744967461, 0.00868370942771435, 0.00863760523498058, 0.00859118904918432, 0.00854459963738918, 0.00849807914346457, 0.00845114141702652, 0.00840427447110415, 0.00835664197802544, 0.00830914918333292, 0.00826182868331671, 0.00821391958743334, 0.00816590525209904, 0.00811795983463526, 0.00806970149278641, 0.00802141055464745, 0.007972770370543, 0.00792388804256916, 0.00787497032433748, 0.00782574061304331, 0.00777657888829708, 0.00772707117721438, 0.00767735345289111, 0.00762777682393789, 0.00757771171629429, 0.00752750970423222, 0.00747730582952499, 0.0074265468865633, 0.00737592671066523, 0.00732496008276939, 0.00727395806461573, 0.00722295511513948, 0.00717157078906894, 0.00712022138759494, 0.00706842029467225, 0.00701620196923614, 0.00696433056145906, 0.00691204331815243, 0.0068647307343781, 0.00681647378951311, 0.00676849484443665, 0.00672058388590813, 0.00667333416640759, 0.00662622414529324, 0.00657900841906667, 0.00653238454833627, 0.00648600282147527, 0.00643962202593684, 0.00639372691512108, 0.00634797103703022, 0.00630249315872788, 0.00625722389668226, 0.00621219770982862, 0.00616734521463513, 0.00612301332876086, 0.006078508682549, 0.00603462848812342, 0.00599054014310241, 0.00594721641391516, 0.00590403191745281, 0.00586102064698935, 0.00581800937652588, 0.0057755196467042, 0.00573306391015649, 0.00569106033071876, 0.00564940413460135, 0.00560774793848395, 0.00556630035862327, 0.00552520016208291, 0.00548427319154143, 0.00544390268623829, 0.00540335802361369, 0.00536326551809907, 0.00532355485484004, 0.00528370495885611, 0.00524430675432086, 0.00520539516583085, 0.00516630988568068, 0.00512774614617229, 0.00508921639993787, 0.00505103450268507, 0.00501333922147751, 0.00497557409107685, 0.00493808649480343, 0.00490119028836489, 0.00486394669860601, 0.00482736248522997, 0.00479102181270719, 0.00475457683205605, 0.00471882708370686, 0.00468290317803621, 0.00464746635407209, 0.00461248029023409, 0.00457711238414049, 0.00454264786094427, 0.0045082182623446, 0.00447368435561657, 0.00443991459906101, 0.00440597115084529, 0.00437241001054645, 0.00433943932875991, 0.00430605188012123, 0.00427346304059029, 0.00424091005697846, 0.00420842505991459, 0.00417663622647524, 0.00414463831111789, 0.00411312654614449, 0.00408192817121744, 0.0040506599470973, 0.00402833661064506, 0.00400749081745744, 0.00398664548993111, 0.00396663369610906, 0.00394648313522339, 0.00392688810825348, 0.00390722369775176, 0.00388783775269985, 0.00386921525932848, 0.0038506630808115, 0.00383211043663323, 0.00381425279192626, 0.00379639538004994, 0.00377881503663957, 0.00376165262423456, 0.00374448951333761, 0.00372802140191197, 0.00371176213957369, 0.00369515549391508, 0.00367945153266191, 0.00366395618766546, 0.00364873907528818, 0.00363373034633696, 0.00361893023364246, 0.00360440742224455, 0.00359030161052942, 0.00357619626447558, 0.00356278568506241, 0.00354951410554349, 0.00353624229319394, 0.00352352671325207, 0.0035107412841171, 0.0034987204708159, 0.00348676880821586, 0.00347530422732234, 0.00346356094814837, 0.0034524432849139, 0.00344160385429859, 0.00343104195781052, 0.00342082744464278, 0.00341054354794323, 0.00340095488354564, 0.0033913659863174, 0.00338233285583556, 0.00337343849241734, 0.00336489197798073, 0.00335627584718168, 0.00334842386655509, 0.00334043311886489, 0.00333299813792109, 0.00332597992382944, 0.00331882340833545, 0.00331201334483922, 0.00330555159598589, 0.00329943653196096, 0.00329380854964256, 0.00328811048530042, 0.00328269088640809, 0.00327789643779397, 0.0032730323728174, 0.00326851569116116, 0.00326448562555015, 0.00326045555993915, 0.00325684249401093, 0.00325329857878387, 0.00325031043030322, 0.00324767013080418, 0.00324495998211205, 0.0032427366822958, 0.00324086030013859, 0.00323898438364267, 0.0032387194223702, 0.00323594035580754, 0.00323329959064722, 0.00323058990761638, 0.00322815752588212, 0.00322565622627735, 0.00322336331009865, 0.00322113954462111, 0.00321891624480486, 0.00321669271215796, 0.00321467756293714, 0.00321273203007877, 0.00321092526428401, 0.0032091187313199, 0.00320745119825006, 0.0032056444324553, 0.00320411566644907, 0.00320265651680529, 0.00320126698352396, 0.0031999466009438, 0.00319862621836364, 0.0031975144520402, 0.00319640291854739, 0.00319543015211821, 0.00319452676922083, 0.0031936930026859, 0.00319278938695788, 0.00319216423667967, 0.00319153885357082, 0.00319105247035623, 0.00319063547067344, 0.00319014908745885, 0.00318987132050097, 0.0031896629370749, 0.00318959332071245, 0.00318952393718064, 0.00318959332071245, 0.00318952393718064, 0.00318980170413852, 0.00319007970392704, 0.00319042708724737, 0.00319084408693016, 0.00319139985367656, 0.00319188623689115, 0.00319251162, 0.00319327600300312, 0.00319410976953804, 0.00319508276879787, 0.0031959165353328, 0.00319695868529379, 0.00319813983514905, 0.0031993908341974, 0.00320071098394692, 0.00320210075005889, 0.00320342089980841, 0.00320501904934645, 0.00320661743171513, 0.00320835434831679, 0.0032101608812809, 0.00321203703060746, 0.00321384379640222, 0.0032158587127924, 0.00321794324554503, 0.00322016701102257, 0.00322239031083882, 0.00322461407631636, 0.00322704599238932, 0.00322954752482474, 0.00323211844079196, 0.00323482835665345, 0.00323753827251494, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323885842226446, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323830265551805, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323774665594101, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.00323828938417137, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.0032379983458668, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323801161721349, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323746888898313, 0.00323774665594101, 0.00323706935159862, 0.00323637458495796, 0.0032357145100832, 0.00323508912697434, 0.00323449843563139, 0.00323390774428844, 0.00323335197754204, 0.00323277851566672, 0.00323225744068623, 0.00323175359517336, 0.00323128467425704, 0.00323081575334072, 0.00323038129135966, 0.00322996452450752, 0.00322953029535711, 0.00322911329567432, 0.00322876591235399, 0.00322841829620302, 0.00322810560464859, 0.00322779291309416, 0.00322748045437038, 0.00322721991688013, 0.00322697637602687, 0.00322675053030252, 0.00322654214687645, 0.00322636845521629, 0.00322619476355612, 0.00322602107189596, 0.0032258820720017, 0.00322577799670398, 0.00322569091804326, 0.00322563899680972, 0.00322558684274554, 0.00322553468868136, 0.00322553468868136, 0.00322555215097964, 0.00322558684274554, 0.00322562153451145, 0.00322570838034153, 0.00322579522617161, 0.0032258820720017, 0.00322598638013005, 0.00322614260949194, 0.00322631630115211, 0.00322650745511055, 0.00322673330083489, 0.00322692422196269, 0.00322718475945294, 0.00322746299207211, 0.00322775822132826, 0.00322807091288269, 0.00322838360443711, 0.00322874868288636, 0.00322907860390842, 0.00322944344952703, 0.00322986021637917, 0.00323029444552958, 0.00323074613697827, 0.00323123252019286, 0.00323168421164155, 0.00323218782432377, 0.00323272636160254, 0.00323328236117959, 0.00323385559022427, 0.00323441135697067, 0.00323503697291017, 0.00323564489372075, 0.0032362702768296, 0.00323693035170436, 0.00323762511834502, 0.00324017903767526, 0.00324142957106233, 0.00324259349144995, 0.0032439308706671, 0.0032453031744808, 0.00324671063572168, 0.00324813486076891, 0.00324961147271097, 0.00325114047154784, 0.00325280800461769, 0.00325435376726091, 0.00325605645775795, 0.00325779360719025, 0.00325960014015436, 0.00326135475188494, 0.0032632309012115, 0.00326515850611031, 0.00326713942922652, 0.00326908496208489, 0.00327115156687796, 0.00327323679812253, 0.00327537301927805, 0.00327754463069141, 0.00327978585846722, 0.00328209577128291, 0.00328437145799398, 0.00328678637742996, 0.00328916567377746, 0.00329164997674525, 0.00329418620094657, 0.00329668819904327, 0.00329932849854231, 0.00330198626033962, 0.00330467848107219, 0.00330735393799841, 0.00331015046685934, 0.00331301707774401, 0.00331586576066911, 0.00331881898455322, 0.00332182412967086, 0.00332486419938505, 0.00332785188220441, 0.0033309964928776, 0.00333415786735713, 0.00333737162873149, 0.00334067200310528, 0.0033439036924392, 0.00334722106344998, 0.0033506432082504, 0.00335410027764738, 0.00335753965191543, 0.00336106610484421, 0.00336467917077243, 0.00336820585653186, 0.00337190600112081, 0.00337565806694329, 0.00337946251966059, 0.00338321435265243, 0.00338705372996628, 0.00339097972027957, 0.00339490571059287, 0.00339891877956688, 0.00340289645828307, 0.0034070136025548, 0.00341116497293115, 0.00341533427126706, 0.00341950356960297, 0.00342379440553486, 0.00342815439216793, 0.00343246245756745, 0.00343690975569189, 0.00344139151275158, 0.00344629003666341, 0.00345268310047686, 0.00345904054120183, 0.00346546829678118, 0.00347186089493334, 0.00347830564714968, 0.00348471570760012, 0.00349116045981646, 0.00349760521203279, 0.00350394565612078, 0.0035103908739984, 0.00351687031798065, 0.00352334976196289, 0.00352974212728441, 0.00353627395816147, 0.00354277086444199, 0.00354925030842423, 0.00355569506064057, 0.00356217473745346, 0.00356872356496751, 0.00357518577948213, 0.00358173460699618, 0.00358823197893798, 0.00359481573104858, 0.00360136455856264, 0.00360782630741596, 0.00361439306288958, 0.00362097681500018, 0.00362759525887668, 0.00363405770622194, 0.00364065845496953, 0.00364725990220904, 0.00365386065095663, 0.00366046209819615, 0.00366706307977438, 0.00367364683188498, 0.00368021312169731, 0.00368684926070273, 0.00369351962581277, 0.00370015576481819, 0.00370684359222651, 0.00371344434097409, 0.0037200627848506, 0.00372676854021847, 0.0037334393709898, 0.00374007481150329, 0.00374678056687117, 0.00375352008268237, 0.00376012176275253, 0.00376680959016085, 0.00377354957163334, 0.00378030701540411, 0.0037869606167078, 0.00379373505711555, 0.00380049250088632, 0.0038072329480201, 0.00381399015896022, 0.00382066075690091, 0.00382745289243758, 0.00383424549363554, 0.00384101993404329, 0.00384776038117707, 0.00385456951335073, 0.0038613963406533, 0.00386813678778708, 0.00387496361508965, 0.00388182536698878, 0.00388863519765437, 0.00389539264142513, 0.00390225416049361, 0.00390909845009446, 0.00391500489786267, 0.00392426364123821, 0.00393293146044016, 0.00394187867641449, 0.00395035557448864, 0.00395897170528769, 0.00396715383976698, 0.00397531827911735, 0.00398320471867919, 0.00399117823690176, 0.00399915175512433, 0.00400649942457676, 0.0040140044875443, 0.00402107462286949, 0.00402826629579067, 0.00403516227379441, 0.00404216349124908, 0.00404859054833651, 0.00405512237921357, 0.00406139343976974, 0.00406761234626174, 0.00407358817756176, 0.00407965062186122, 0.0040855398401618, 0.00409083813428879, 0.00409641396254301, 0.00410155579447746, 0.0041068191640079, 0.00411164900287986, 0.0041165822185576, 0.00412109866738319, 0.00412571988999844, 0.00413002772256732, 0.0041343355551362, 0.00413852231577039, 0.00414223968982697, 0.00414607860147953, 0.00414957012981176, 0.00415307935327291, 0.00415631057694554, 0.00415964564308524, 0.00416240794584155, 0.00416543055325747, 0.00416786223649979, 0.00417053746059537, 0.00417309114709496, 0.00417519314214587, 0.00417729513719678, 0.00417910190299153, 0.00418101251125336, 0.00418259343132377, 0.00418417388573289, 0.00418533803895116, 0.0041866060346365, 0.00418744003400207, 0.00418839557096362, 0.00418905541300774, 0.00418980279937387, 0.00419030617922544, 0.00419032387435436, 0.00419049756601453, 0.00419053249061108, 0.00419037556275725, 0.00418987218290567, 0.00418940279632807, 0.0041886386461556, 0.00418797833845019, 0.00418688403442502, 0.00418592896312475, 0.00418479926884174, 0.00418318435549736, 0.00418177712708712, 0.00417300499975681, 0.00416619563475251, 0.00415855227038264, 0.00415104767307639, 0.00414298707619309, 0.00413492694497108, 0.00412645004689693, 0.0041179726831615, 0.00410935655236244, 0.00410032365471125, 0.00409129029139876, 0.004081423394382, 0.00407211249694228, 0.00406182883307338, 0.00405168393626809, 0.00404098303988576, 0.00403069891035557, 0.00401985971257091, 0.00400888128206134, 0.00399748561903834, 0.00398567318916321, 0.00397399952635169, 0.00396176986396313, 0.00394967943429947, 0.00393703347072005, 0.00392438704147935, 0.00391146261245012, 0.00389826064929366, 0.00388478045351803, 0.0038711610250175, 0.00385726406238973, 0.0038430888671428, 0.00382863613776863, 0.00381404440850019, 0.00379959144629538, 0.00378430495038629, 0.00376929575577378, 0.003753453027457, 0.00373774953186512, 0.0037216292694211, 0.00370564730837941, 0.0036889708135277, 0.0036724335514009, 0.00365575728937984, 0.00363852456212044, 0.00362143153324723, 0.00360350427217782, 0.00358571601100266, 0.00356751075014472, 0.00354930548928678, 0.00353054446168244, 0.00351206143386662, 0.00349316140636802, 0.0034741226118058, 0.00345452781766653, 0.003434794023633, 0.00341492122970521, 0.00339463166892529, 0.00337448064237833, 0.00335391308180988, 0.00333320675417781, 0.00331194396130741, 0.00329082063399255, 0.00326914130710065, 0.00324746174737811, 0.00322522642090917, 0.00320313009433448, 0.00318061700090766, 0.00315782590769231, 0.00313545134849846, 0.00311196525581181, 0.00308082369156182, 0.00305136223323643, 0.00302148330956697, 0.00299202185124159, 0.0029624211601913, 0.00293295970186591, 0.0029037760104984, 0.00287417531944811, 0.00284485262818635, 0.00281553016975522, 0.00278579071164131, 0.00275632902048528, 0.00272700632922351, 0.00269782240502536, 0.00266836094669998, 0.00263889925554395, 0.00260943779721856, 0.00258011510595679, 0.00255051464773715, 0.00252119172364473, 0.00249186926521361, 0.00246240757405758, 0.00243308488279581, 0.00240390142425895, 0.00237443950027227, 0.00234511704184115, 0.00231565535068512, 0.00228619365952909, 0.0022567322012037, 0.0022275485098362, 0.00219822581857443, 0.00216904212720692, 0.00213958043605089, 0.00211039674468338, 0.00208107428625226, 0.00205175159499049, 0.00202256790362298, 0.00199324521236122, 0.00196392252109945, 0.001934599946253, 0.00190527737140656, 0.00187637156341225, 0.00184704887215048, 0.0018178652971983, 0.00178868160583079, 0.00175935891456902, 0.00173017533961684, 0.00170099153183401, 0.0016718078404665, 0.00164290226530284, 0.00161357945762575, 0.00158439576625824, 0.00155535107478499, 0.00152588950004429, 0.00149656680878252, 0.00146738311741501, 0.00143847742583603, 0.00140929373446852, 0.00138024904299527, 0.00135106535162777, 0.00132188166026026, 0.00129269796889275, 0.00126365327741951, 0.001234469586052, 0.00120542489457875, 0.00117638020310551, 0.0011474743951112, 0.00111842970363796, 0.00108924601227045, 0.00106020143721253, 0.0010310176294297, 0.00100572919473052, 0.000984327867627144, 0.000963065307587385, 0.000942358688917011, 0.000921513128560036, 0.000900667509995401, 0.000880099891219288, 0.000860227097291499, 0.000840354361571372, 0.000820620625745505, 0.000800747831817716, 0.000781708862632513, 0.00076266989344731, 0.000743769924156368, 0.000725008896552026, 0.000706386868841946, 0.00068832072429359, 0.000670254521537572, 0.000652327318675816, 0.000634539115708321, 0.00061730679590255, 0.000599935476202518, 0.000582842156291008, 0.000565887778066099, 0.000549489224795252, 0.000532951729837805, 0.000516831176355481, 0.000500432623084635, 0.000484451040392742, 0.000469164311653003, 0.000453599612228572, 0.000438312883488834, 0.000423165067331865, 0.000408434221753851, 0.000393981259549037, 0.000379389384761453, 0.0003650754224509, 0.000351456314092502, 0.000337698264047503, 0.000324079155689105, 0.000310599018121138, 0.000297396822134033, 0.00028461153851822, 0.000271826254902408, 0.000259318883763626, 0.000246811570832506, 0.000234721141168848, 0.00022276968229562, 0.000210957194212824, 0.000199283676920459, 0.000188304999028333, 0.000177187379449606, 0.00016620870155748, 0.000155230038217269, 0.00014452931645792, 0.000134662419441156, 0.000124378595501184, 0.000114511691208463, 0.00010478376498213, 9.54727365751751e-05, 8.6161722720135e-05, 7.68507015891373e-05, 6.79565855534747e-05, 5.96183635934722e-05, 5.10021855006926e-05, 4.28029306931421e-05, 3.46036758855917e-05, 2.68213279923657e-05, 1.94558924704324e-05, 1.18125162771321e-05, 4.72502233606065e-06, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15, 3.23804792691734e-15   }, 
   { 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.0225200280547142, 0.000161368690896779, 0.00105165084823966, 0.00194478989578784, 0.00284076808020473, 0.00373960309661925, 0.00464128330349922, 0.00554582057520747, 0.00645321421325207, 0.00736344698816538, 0.00827653612941504, 0.00919247698038816, 0.0101112695410848, 0.0110329007729888, 0.011957393027842, 0.0128847332671285, 0.0138149280101061, 0.0147479679435492, 0.0156838670372963, 0.0166226141154766, 0.0175641961395741, 0.0185086410492659, 0.0194559413939714, 0.020406087860465, 0.0213590916246176, 0.022314939647913, 0.0232736337929964, 0.0242351852357388, 0.0251995790749788, 0.0261668190360069, 0.0271369405090809, 0.0281098820269108, 0.0290856808423996, 0.0300643481314182, 0.031045850366354, 0.0320301949977875, 0.0330174006521702, 0.0340074598789215, 0.0350003652274609, 0.0359961241483688, 0.0369947329163551, 0.0379961952567101, 0.039000503718853, 0.040007658302784, 0.0410176813602448, 0.0420305244624615, 0.0430462472140789, 0.0440648049116135, 0.0450862087309361, 0.0461104772984982, 0.0471375957131386, 0.0481675714254379, 0.0492003746330738, 0.0502360500395298, 0.0512745566666126, 0.0523159131407738, 0.0533601492643356, 0.054407212883234, 0.0554571337997913, 0.0565099082887173, 0.0575655326247215, 0.0586239919066429, 0.0596853047609329, 0.060749489814043, 0.06181650608778, 0.0628863945603371, 0.0639590993523598, 0.0650346949696541, 0.0661130994558334, 0.0671943798661232, 0.0682785138487816, 0.0693654865026474, 0.070455327630043, 0.0715479925274849, 0.0726435482501984, 0.0737419128417969, 0.0748431608080864, 0.0759472250938416, 0.0770541504025459, 0.0781639367341995, 0.0792765766382217, 0.080392062664032, 0.0815103799104691, 0.0826315879821777, 0.0837556123733521, 0.0848824977874756, 0.0860122516751289, 0.0871448293328285, 0.0882802754640579, 0.0894185528159142, 0.0905596986413002, 0.0917036980390549, 0.0928505286574364, 0.0940002351999283, 0.095152772963047, 0.0963081642985344, 0.0974664092063904, 0.0986607596278191, 0.0999161303043365, 0.101171746850014, 0.102427594363689, 0.103683650493622, 0.104939959943295, 0.106196470558643, 0.107453241944313, 0.108710221946239, 0.109967410564423, 0.111224845051765, 0.112482503056526, 0.113740406930447, 0.114998511970043, 0.116256840527058, 0.117515414953232, 0.118774242699146, 0.120033241808414, 0.12129245698452, 0.12255197763443, 0.123811669647694, 0.125071614980698, 0.126331776380539, 0.127592161297798, 0.128852754831314, 0.13011360168457, 0.131374701857567, 0.132635995745659, 0.133897498250008, 0.135159254074097, 0.136421263217926, 0.13768345117569, 0.138945892453194, 0.140208542346954, 0.141471415758133, 0.142734557390213, 0.143997877836227, 0.145261466503143, 0.146525248885155, 0.147789299488068, 0.149053543806076, 0.150317996740341, 0.151582717895508, 0.152847647666931, 0.154112830758095, 0.155378207564354, 0.156643822789192, 0.157909661531448, 0.159175723791122, 0.160442039370537, 0.161708548665047, 0.162975296378136, 0.164242282509804, 0.165509507060051, 0.166776925325394, 0.168044596910477, 0.169312462210655, 0.170580565929413, 0.171848967671394, 0.173117518424988, 0.174386337399483, 0.175655364990234, 0.176924616098404, 0.178194090723991, 0.179463803768158, 0.180733740329742, 0.182003900408745, 0.183274298906326, 0.184544906020164, 0.185815766453743, 0.187086820602417, 0.18835811316967, 0.18965208530426, 0.190942704677582, 0.192227512598038, 0.193506553769112, 0.194779813289642, 0.196047246456146, 0.197308957576752, 0.198564812541008, 0.199814885854721, 0.201059222221375, 0.202297747135162, 0.203530460596085, 0.204757481813431, 0.205978631973267, 0.207194000482559, 0.208403587341309, 0.209607377648354, 0.210805356502533, 0.211997613310814, 0.213184058666229, 0.214364677667618, 0.215539515018463, 0.216708570718765, 0.217871874570847, 0.21902933716774, 0.220181047916412, 0.221326991915703, 0.222467198967934, 0.223601490259171, 0.224729984998703, 0.225852757692337, 0.226969733834267, 0.228080928325653, 0.229186370968819, 0.230285972356796, 0.231379747390747, 0.232467785477638, 0.233550012111664, 0.234626546502113, 0.235697135329247, 0.236762076616287, 0.237821131944656, 0.238874480128288, 0.239921972155571, 0.240963652729988, 0.241999626159668, 0.243029773235321, 0.244054168462753, 0.245072722434998, 0.246085494756699, 0.247092500329018, 0.248093709349632, 0.249089136719704, 0.250078737735748, 0.251062631607056, 0.25204062461853, 0.253012925386429, 0.253979444503784, 0.254940122365952, 0.255894988775253, 0.256844103336334, 0.257787466049194, 0.258725017309189, 0.259656727313995, 0.260582715272903, 0.261502921581268, 0.262417286634445, 0.263325870037079, 0.264228761196136, 0.265125691890717, 0.266016960144043, 0.266761511564255, 0.267359763383865, 0.267953306436539, 0.268542230129242, 0.269126534461975, 0.269706159830093, 0.270281106233597, 0.270851343870163, 0.271416991949081, 0.271977961063385, 0.272534251213074, 0.273085951805115, 0.273632884025574, 0.274175196886063, 0.274712890386581, 0.275245845317841, 0.275774121284485, 0.276297867298126, 0.276816874742508, 0.277331233024597, 0.277840942144394, 0.278345912694931, 0.278846263885498, 0.279341995716095, 0.279833018779755, 0.280319422483444, 0.280801057815552, 0.281278133392334, 0.281750559806824, 0.282218277454376, 0.282681316137314, 0.283139735460281, 0.283593475818634, 0.284042596817017, 0.28448697924614, 0.284926772117615, 0.285361886024475, 0.285792261362076, 0.286218047142029, 0.286639183759689, 0.287055611610413, 0.287467330694199, 0.287874519824982, 0.288276970386505, 0.288674741983414, 0.289067894220352, 0.289456427097321, 0.289840221405029, 0.290219336748123, 0.290593832731247, 0.290963709354401, 0.291328966617584, 0.291689306497574, 0.292045205831528, 0.292396396398544, 0.292742997407913, 0.293084889650345, 0.293422043323517, 0.293754518032074, 0.294082432985306, 0.294405698776245, 0.294724196195602, 0.295038133859634, 0.295347303152084, 0.295651942491531, 0.295951783657074, 0.296247035264969, 0.296537667512894, 0.296823531389236, 0.297104805707932, 0.297381401062012, 0.29765310883522, 0.297905653715134, 0.298163235187531, 0.298425674438477, 0.298693150281906, 0.29896554350853, 0.29924276471138, 0.299525082111359, 0.299812167882919, 0.300104379653931, 0.300401449203491, 0.300703406333923, 0.301010370254517, 0.301322281360626, 0.301639080047607, 0.30196088552475, 0.302287518978119, 0.302619218826294, 0.302955806255341, 0.303297311067581, 0.303643822669983, 0.303995132446289, 0.304351508617401, 0.304712861776352, 0.305079013109207, 0.305450201034546, 0.305826246738434, 0.306207358837128, 0.306593358516693, 0.30698424577713, 0.307380139827728, 0.307781010866165, 0.308186680078506, 0.308597415685654, 0.309012949466705, 0.309433579444885, 0.309859126806259, 0.310289531946182, 0.310724943876266, 0.311165302991867, 0.311610549688339, 0.312060743570328, 0.31251585483551, 0.312975972890854, 0.313441038131714, 0.313910961151123, 0.314385890960693, 0.314865678548813, 0.315350532531738, 0.315840303897858, 0.316334903240204, 0.316834539175034, 0.31733912229538, 0.317848563194275, 0.318363010883331, 0.318882316350937, 0.319406688213348, 0.319935977458954, 0.320470124483109, 0.321009278297424, 0.321553409099579, 0.322102338075638, 0.322656333446503, 0.323215156793594, 0.32377901673317, 0.324347853660583, 0.324921518564224, 0.325500190258026, 0.326083689928055, 0.326672285795212, 0.32726576924324, 0.327864140272141, 0.32862776517868, 0.32948911190033, 0.330358654260635, 0.33123642206192, 0.332122147083282, 0.333016067743301, 0.333918184041977, 0.33482825756073, 0.33574652671814, 0.336672872304916, 0.337607443332672, 0.338550060987473, 0.33950075507164, 0.340459734201431, 0.341426640748978, 0.342401742935181, 0.34338504076004, 0.344376385211945, 0.345375806093216, 0.346383482217789, 0.347399175167084, 0.348423033952713, 0.349454969167709, 0.350495040416718, 0.351543247699738, 0.352599561214447, 0.353663980960846, 0.354736626148224, 0.355817198753357, 0.356905996799469, 0.35800302028656, 0.359107971191406, 0.360221177339554, 0.361342400312424, 0.362471789121628, 0.363609284162521, 0.364755004644394, 0.365908771753311, 0.367070645093918, 0.368240684270859, 0.369418740272522, 0.370604962110519, 0.371799349784851, 0.37300169467926, 0.374212503433228, 0.375431150197983, 0.376657962799072, 0.377893000841141, 0.379136085510254, 0.380387187004089, 0.381646633148193, 0.382913947105408, 0.384189546108246, 0.385473191738129, 0.386765003204346, 0.388065069913864, 0.389372915029526, 0.390689224004745, 0.392013520002365, 0.393345803022385, 0.39468640089035, 0.396035045385361, 0.397391825914383, 0.398756802082062, 0.400129765272141, 0.401510834693909, 0.402900189161301, 0.404297471046448, 0.405703067779541, 0.407116562128067, 0.40853825211525, 0.409933805465698, 0.411203533411026, 0.412482172250748, 0.413769781589508, 0.415066540241241, 0.416372269392014, 0.417687267065048, 0.419011026620865, 0.420343846082687, 0.421686053276062, 0.423036903142929, 0.424396991729736, 0.425766259431839, 0.427144378423691, 0.428531438112259, 0.429927825927734, 0.431333065032959, 0.432747423648834, 0.434170842170715, 0.43560317158699, 0.43704479932785, 0.438495278358459, 0.439954817295074, 0.441423624753952, 0.442901253700256, 0.444387912750244, 0.445883721113205, 0.447388529777527, 0.44890233874321, 0.450425326824188, 0.451957434415817, 0.453498363494873, 0.455048352479935, 0.456607550382614, 0.458175659179688, 0.459752857685089, 0.461339175701141, 0.462934374809265, 0.464539021253586, 0.466152220964432, 0.467774599790573, 0.469406187534332, 0.471046715974808, 0.472696155309677, 0.474354892969131, 0.476022571325302, 0.477699190378189, 0.479385137557983, 0.481079876422882, 0.482783943414688, 0.484496772289276, 0.48621878027916, 0.487949579954147, 0.489689826965332, 0.491438984870911, 0.493197113275528, 0.494964331388474, 0.496740609407425, 0.498525738716125, 0.500320076942444, 0.502123713493347, 0.503935992717743, 0.505757510662079, 0.507588088512421, 0.509427785873413, 0.511276125907898, 0.513133943080902, 0.515000641345978, 0.516876459121704, 0.518761217594147, 0.52065521478653, 0.522558093070984, 0.524498581886292, 0.526458442211151, 0.528432428836823, 0.530420005321503, 0.53242164850235, 0.534436464309692, 0.536465585231781, 0.538508415222168, 0.540564894676208, 0.542635381221771, 0.544719338417053, 0.546817362308502, 0.54892897605896, 0.551054537296295, 0.55319344997406, 0.555346667766571, 0.557513475418091, 0.559694290161133, 0.561888754367828, 0.564096748828888, 0.566318869590759, 0.568554282188416, 0.570803940296173, 0.573067426681519, 0.575344383716583, 0.57763534784317, 0.579940021038055, 0.582258760929108, 0.58459061384201, 0.586936950683594, 0.589296519756317, 0.591670393943787, 0.59405791759491, 0.596458971500397, 0.598874151706696, 0.601302564144135, 0.60374516248703, 0.606201410293579, 0.60867178440094, 0.611155569553375, 0.613653182983398, 0.616164803504944, 0.618689775466919, 0.62122905254364, 0.62378191947937, 0.626348376274109, 0.628928899765015, 0.631523191928864, 0.634131133556366, 0.636752665042877, 0.6393883228302, 0.642037510871887, 0.64470100402832, 0.647377789020538, 0.650068581104279, 0.652772903442383, 0.655491232872009, 0.658223330974579, 0.660968899726868, 0.663728713989258, 0.666501879692078, 0.669289529323578, 0.672090411186218, 0.674905002117157, 0.677733600139618, 0.680575788021088, 0.683432042598724, 0.68630188703537, 0.689185619354248, 0.692083060741425, 0.694994628429413, 0.69802051782608, 0.701242685317993, 0.704474925994873, 0.707716166973114, 0.710967361927032, 0.714227855205536, 0.717498064041138, 0.72077751159668, 0.724066495895386, 0.727365672588348, 0.730674088001251, 0.733992159366608, 0.737319529056549, 0.740656852722168, 0.744003057479858, 0.74735951423645, 0.750725150108337, 0.754100263118744, 0.757485508918762, 0.760879933834076, 0.764284133911133, 0.767697215080261, 0.771120667457581, 0.774553298950195, 0.777995347976685, 0.781447529792786, 0.784908711910248, 0.788379788398743, 0.791859984397888, 0.795350253582001, 0.798849940299988, 0.802359223365784, 0.805878162384033, 0.809406340122223, 0.812944531440735, 0.816491663455963, 0.820048809051514, 0.823615252971649, 0.827191650867462, 0.83077746629715, 0.834372699260712, 0.837977588176727, 0.841591835021973, 0.845215618610382, 0.84884911775589, 0.85249263048172, 0.856145143508911, 0.859807312488556, 0.863479435443878, 0.867160201072693, 0.870851397514343, 0.874551713466644, 0.878261983394623, 0.881981611251831, 0.885711073875427, 0.889449596405029, 0.893197596073151, 0.896955549716949, 0.900722920894623, 0.904500246047974, 0.908286809921265, 0.912082970142365, 0.915888607501984, 0.919703423976898, 0.923528552055359, 0.92736279964447, 0.931206881999969, 0.935060381889343, 0.938923537731171, 0.942796289920807, 0.946678221225739, 0.950569927692413, 0.954120934009552, 0.957656860351562, 0.961200416088104, 0.964751660823822, 0.96831077337265, 0.971877038478851, 0.975451469421387, 0.979033708572388, 0.982623815536499, 0.986221373081207, 0.989826798439026, 0.993439972400665, 0.99706095457077, 1.00068914890289, 1.00432562828064, 1.00796949863434, 1.01162147521973, 1.01528084278107, 1.01894819736481, 1.02262318134308, 1.02630567550659, 1.02999603748322, 1.03369438648224, 1.03740000724792, 1.04111409187317, 1.0448352098465, 1.0485645532608, 1.05230069160461, 1.05604553222656, 1.05979776382446, 1.06355798244476, 1.06732571125031, 1.07110142707825, 1.07488453388214, 1.07867527008057, 1.0824738740921, 1.08628058433533, 1.09009432792664, 1.09391641616821, 1.09774601459503, 1.10158348083496, 1.10542833805084, 1.10928118228912, 1.11314165592194, 1.11701011657715, 1.1208860874176, 1.12476980686188, 1.12866139411926, 1.13256013393402, 1.13646709918976, 1.14038181304932, 1.14430415630341, 1.1482344865799, 1.15217232704163, 1.15611791610718, 1.16007089614868, 1.16403222084045, 1.16800105571747, 1.17197751998901, 1.17596161365509, 1.17995345592499, 1.18395328521729, 1.18796074390411, 1.19197583198547, 1.19599878787994, 1.20002949237823, 1.20406782627106, 1.2081139087677, 1.21216785907745, 1.21622920036316, 1.22029864788055, 1.22451996803284, 1.22890865802765, 1.23330521583557, 1.23770952224731, 1.24212181568146, 1.24654161930084, 1.25096929073334, 1.25540494918823, 1.25984871387482, 1.26429986953735, 1.26875913143158, 1.27322602272034, 1.27770066261292, 1.28218305110931, 1.28667366504669, 1.29117178916931, 1.29567790031433, 1.30019164085388, 1.30471348762512, 1.3092428445816, 1.3137800693512, 1.3183251619339, 1.32287812232971, 1.32743883132935, 1.33200764656067, 1.33658421039581, 1.34116804599762, 1.34576010704041, 1.35036015510559, 1.3549679517746, 1.35958349704742, 1.36420667171478, 1.36883807182312, 1.37347674369812, 1.37812376022339, 1.38277816772461, 1.3874409198761, 1.39211118221283, 1.39678907394409, 1.40147531032562, 1.40616881847382, 1.41087019443512, 1.41557955741882, 1.42029678821564, 1.42502224445343, 1.4297548532486, 1.43449568748474, 1.43924355506897, 1.44400012493134, 1.44876432418823, 1.45353639125824, 1.45831632614136, 1.46310389041901, 1.46789944171906, 1.47270250320435, 1.47751331329346, 1.48233234882355, 1.48715889453888, 1.4919935464859, 1.49683558940887, 1.50168645381927, 1.50654411315918, 1.51140975952148, 1.5162832736969, 1.52116501331329, 1.52605450153351, 1.53095149993896, 1.53585660457611, 1.5407692193985, 1.54568946361542, 1.5506180524826, 1.55559718608856, 1.5613317489624, 1.56704115867615, 1.57272863388062, 1.57839381694794, 1.58403503894806, 1.58965420722961, 1.59525001049042, 1.60082054138184, 1.60636878013611, 1.61189496517181, 1.61739575862885, 1.62287449836731, 1.62833106517792, 1.63376247882843, 1.63917171955109, 1.64455890655518, 1.64992070198059, 1.65526056289673, 1.66057634353638, 1.66587030887604, 1.67114043235779, 1.67638862133026, 1.68160843849182, 1.68680930137634, 1.69198787212372, 1.69714093208313, 1.70227229595184, 1.70737826824188, 1.71246194839478, 1.71752369403839, 1.72256016731262, 1.72757613658905, 1.73256647586823, 1.73753356933594, 1.74247848987579, 1.74740123748779, 1.75229871273041, 1.75717401504517, 1.76202714443207, 1.76685345172882, 1.77165925502777, 1.7764413356781, 1.7811998128891, 1.78593611717224, 1.79065012931824, 1.79533898830414, 1.80000567436218, 1.80464565753937, 1.8092668056488, 1.81386411190033, 1.81843602657318, 1.82298612594604, 1.82751393318176, 1.83201777935028, 1.83649957180023, 1.84095621109009, 1.8453893661499, 1.84980177879333, 1.85418891906738, 1.85855257511139, 1.8628922700882, 1.86720991134644, 1.87150537967682, 1.87577736377716, 1.8800253868103, 1.88424837589264, 1.88845098018646, 1.89262771606445, 1.89678275585175, 1.90091574192047, 1.90502488613129, 1.90882956981659, 1.91242802143097, 1.91595864295959, 1.91942369937897, 1.92282700538635, 1.92616152763367, 1.92943012714386, 1.93263578414917, 1.93577706813812, 1.93885231018066, 1.94186007976532, 1.94480788707733, 1.94768679141998, 1.95049977302551, 1.95324981212616, 1.95593690872192, 1.95855212211609, 1.96110415458679, 1.96359348297119, 1.96601676940918, 1.96837413311005, 1.97066712379456, 1.97289562225342, 1.97505819797516, 1.97715628147125, 1.97918999195099, 1.98115479946136, 1.98305642604828, 1.98489391803741, 1.98666536808014, 1.98837232589722, 1.99000895023346, 1.99158835411072, 1.99309766292572, 1.99454379081726, 1.99592387676239, 1.99723982810974, 1.99848818778992, 1.99967205524445, 2.00078868865967, 2.00184512138367, 2.00283598899841, 2.00375890731812, 2.00461769104004, 2.00541043281555, 2.00613880157471, 2.0068027973175, 2.00739765167236, 2.00792956352234, 2.00839710235596, 2.00880336761475, 2.00913906097412, 2.00941038131714, 2.00961565971375, 2.00975966453552, 2.00983595848083, 2.00984501838684, 2.00978946685791, 2.00966954231262, 2.00948667526245, 2.00923657417297, 2.00892043113708, 2.00853967666626, 2.00809597969055, 2.00758814811707, 2.00701093673706, 2.00636959075928, 2.00566530227661, 2.00489330291748, 2.00405716896057, 2.0031566619873, 2.00196957588196, 1.99980092048645, 1.99757397174835, 1.9952826499939, 1.99292683601379, 1.99050498008728, 1.98802173137665, 1.9854724407196, 1.98286175727844, 1.9801881313324, 1.97745013237, 1.97464466094971, 1.97178077697754, 1.96884787082672, 1.96585500240326, 1.96280086040497, 1.95967316627502, 1.95649003982544, 1.95324385166168, 1.9499317407608, 1.94655847549438, 1.94311892986298, 1.93961358070374, 1.93604826927185, 1.9324187040329, 1.92872726917267, 1.92496263980865, 1.92114269733429, 1.9172580242157, 1.91330623626709, 1.90929889678955, 1.90521943569183, 1.90107882022858, 1.8968780040741, 1.89261138439178, 1.88827872276306, 1.88388168811798, 1.87942326068878, 1.87490165233612, 1.87031292915344, 1.86566710472107, 1.86095082759857, 1.85617470741272, 1.85133397579193, 1.84643030166626, 1.84146070480347, 1.83642518520355, 1.83133435249329, 1.8261730670929, 1.82095015048981, 1.81566286087036, 1.81031119823456, 1.80489957332611, 1.79942190647125, 1.79387855529785, 1.78827500343323, 1.78260707855225, 1.77687168121338, 1.77107644081116, 1.76521217823029, 1.7592910528183, 1.75330555438995, 1.74725377559662, 1.74113631248474, 1.73496043682098, 1.72871851921082, 1.72241067886353, 1.71603989601135, 1.70960760116577, 1.70310640335083, 1.69654846191406, 1.68992578983307, 1.68284523487091, 1.67561268806458, 1.66836214065552, 1.66109979152679, 1.65381932258606, 1.64652693271637, 1.63921630382538, 1.63189101219177, 1.62455213069916, 1.61719810962677, 1.60982477664948, 1.60244083404541, 1.5950391292572, 1.58762300014496, 1.58019268512726, 1.5727436542511, 1.56528341770172, 1.55780816078186, 1.55031490325928, 1.5428067445755, 1.53528571128845, 1.52774584293365, 1.52019202709198, 1.51262450218201, 1.50504207611084, 1.49744236469269, 1.48982775211334, 1.48219954967499, 1.47455358505249, 1.46689534187317, 1.45922076702118, 1.45152831077576, 1.4438236951828, 1.43610322475433, 1.42836582660675, 1.4206155538559, 1.41285109519958, 1.40506780147552, 1.39726877212524, 1.38945853710175, 1.38162887096405, 1.37378644943237, 1.36593127250671, 1.35805594921112, 1.3501683473587, 1.34226524829865, 1.33434796333313, 1.32641243934631, 1.31846439838409, 1.31049609184265, 1.30251884460449, 1.29452502727509, 1.28651535511017, 1.27848792076111, 1.27044916152954, 1.26239395141602, 1.25432062149048, 1.24623537063599, 1.23813438415527, 1.2300169467926, 1.22188377380371, 1.21373867988586, 1.20557391643524, 1.19739878177643, 1.18920564651489, 1.18099761009216, 1.17277145385742, 1.16453635692596, 1.15627956390381, 1.14801228046417, 1.13972771167755, 1.13164782524109, 1.12396800518036, 1.11631655693054, 1.10869741439819, 1.10110831260681, 1.09355509281158, 1.0860288143158, 1.07853853702545, 1.07107675075531, 1.06364941596985, 1.05625510215759, 1.04889214038849, 1.04155850410461, 1.03425633907318, 1.02699089050293, 1.01975607872009, 1.01254987716675, 1.00537729263306, 0.998236238956451, 0.99112731218338, 0.984050631523132, 0.977004766464233, 0.969992578029633, 0.963011920452118, 0.9560626745224, 0.949144899845123, 0.942258477210999, 0.935406625270844, 0.928583979606628, 0.921792924404144, 0.915036201477051, 0.908312499523163, 0.901618778705597, 0.894957304000854, 0.888324975967407, 0.881726384162903, 0.875162303447723, 0.868626654148102, 0.862123966217041, 0.855651378631592, 0.849214732646942, 0.842808663845062, 0.836431860923767, 0.830088794231415, 0.823778033256531, 0.817497909069061, 0.811250805854797, 0.805037379264832, 0.798853933811188, 0.792704939842224, 0.786582946777344, 0.780493915081024, 0.774437069892883, 0.768417000770569, 0.7624232172966, 0.75646299123764, 0.750532150268555, 0.744639456272125, 0.738772928714752, 0.732940971851349, 0.727138876914978, 0.721371293067932, 0.715636730194092, 0.709930598735809, 0.704258978366852, 0.698617279529572, 0.693009376525879, 0.687430560588837, 0.681885600090027, 0.676371335983276, 0.670891463756561, 0.665440142154694, 0.660790026187897, 0.656240105628967, 0.651736676692963, 0.647264719009399, 0.642836153507233, 0.638446569442749, 0.63409298658371, 0.629784345626831, 0.625511705875397, 0.621277987957001, 0.617080271244049, 0.612932026386261, 0.60881519317627, 0.604738891124725, 0.600701451301575, 0.596706032752991, 0.592746615409851, 0.588829100131989, 0.584950625896454, 0.581109523773193, 0.5773104429245, 0.573548853397369, 0.569826185703278, 0.56614100933075, 0.562503755092621, 0.558898031711578, 0.555331170558929, 0.551806330680847, 0.548323512077332, 0.544873595237732, 0.541467130184174, 0.538098156452179, 0.534768104553223, 0.531483113765717, 0.528232514858246, 0.525017917156219, 0.521848201751709, 0.518719017505646, 0.515624284744263, 0.512571573257446, 0.509556233882904, 0.506581425666809, 0.503648579120636, 0.500750184059143, 0.497892200946808, 0.495076239109039, 0.49229770898819, 0.489558190107346, 0.486859142780304, 0.484199017286301, 0.48157787322998, 0.478998690843582, 0.476453959941864, 0.473948180675507, 0.471485912799835, 0.469064086675644, 0.466675251722336, 0.464329838752747, 0.462026417255402, 0.459757447242737, 0.457530468702316, 0.455342382192612, 0.453193336725235, 0.451083242893219, 0.449013590812683, 0.446979939937592, 0.44498673081398, 0.443038433790207, 0.441124647855759, 0.439246833324432, 0.437413990497589, 0.435702800750732, 0.434126764535904, 0.432569295167923, 0.431027352809906, 0.429503232240677, 0.4280004799366, 0.426511585712433, 0.425041556358337, 0.423593491315842, 0.422157973051071, 0.420740991830826, 0.419345945119858, 0.417968302965164, 0.416604340076447, 0.415262281894684, 0.413936167955399, 0.412627100944519, 0.411339372396469, 0.41006663441658, 0.408810615539551, 0.40757754445076, 0.406357496976852, 0.40515610575676, 0.403974980115891, 0.402812391519547, 0.401664435863495, 0.400536328554153, 0.399426579475403, 0.398332923650742, 0.397258192300797, 0.396201848983765, 0.395162731409073, 0.394141048192978, 0.393139332532883, 0.392153024673462, 0.391187727451324, 0.390240401029587, 0.389307469129562, 0.38839328289032, 0.387499541044235, 0.386621326208115, 0.385760009288788, 0.384920567274094, 0.384097427129745, 0.383289098739624, 0.382504343986511, 0.3817338347435, 0.380982100963593, 0.380248665809631, 0.37953308224678, 0.378832846879959, 0.378154158592224, 0.377491354942322, 0.376845836639404, 0.37621882557869, 0.375611871480942, 0.375020861625671, 0.374447375535965, 0.373896479606628, 0.373358637094498, 0.372837871313095, 0.372339010238647, 0.371855676174164, 0.371389597654343, 0.370945245027542, 0.370514750480652, 0.370101720094681, 0.36971053481102, 0.36933496594429, 0.368978083133698, 0.36863961815834, 0.368273347616196, 0.367555767297745, 0.366840749979019, 0.366128027439117, 0.365417510271072, 0.364709198474884, 0.364003300666809, 0.363299697637558, 0.362597912549973, 0.361898720264435, 0.361202210187912, 0.360507309436798, 0.359815001487732, 0.359124630689621, 0.358437180519104, 0.357751220464706, 0.357067972421646, 0.356387197971344, 0.355708122253418, 0.355031609535217, 0.35435751080513, 0.353685528039932, 0.353015512228012, 0.352348119020462, 0.351683229207993, 0.351020097732544, 0.350359380245209, 0.34970086812973, 0.349044978618622, 0.348391205072403, 0.347739368677139, 0.347090184688568, 0.346442967653275, 0.345798164606094, 0.345155656337738, 0.344515532255173, 0.34387743473053, 0.343241512775421, 0.342608451843262, 0.341976881027222, 0.341347992420197, 0.340721100568771, 0.340096920728683, 0.339474767446518, 0.338854759931564, 0.338237375020981, 0.337621957063675, 0.337008774280548, 0.336398065090179, 0.335789501667023, 0.33518323302269, 0.33457887172699, 0.333977580070496, 0.333377838134766, 0.332780539989471, 0.332185596227646, 0.331593126058578, 0.331002533435822, 0.330414265394211, 0.329828560352325, 0.32924473285675, 0.328663349151611, 0.328084588050842, 0.327507674694061, 0.326933026313782, 0.326360434293747, 0.325790762901306, 0.325222790241241, 0.324657320976257, 0.324093997478485, 0.323533266782761, 0.322974503040314, 0.322363436222076, 0.321697473526001, 0.321032106876373, 0.320367872714996, 0.319704800844193, 0.319042772054672, 0.318381875753403, 0.317721575498581, 0.31706291437149, 0.316404938697815, 0.315747767686844, 0.315092027187347, 0.314437061548233, 0.313783437013626, 0.313130468130112, 0.312478601932526, 0.311828255653381, 0.311178505420685, 0.31052964925766, 0.309881985187531, 0.309235483407974, 0.308589935302734, 0.307945221662521, 0.307301849126816, 0.30665922164917, 0.306017875671387, 0.305377274751663, 0.30473780632019, 0.304099649190903, 0.303462147712708, 0.302825897932053, 0.302190810441971, 0.301556497812271, 0.300923377275467, 0.300291001796722, 0.299659848213196, 0.299029886722565, 0.298400700092316, 0.29777267575264, 0.297145485877991, 0.296519815921783, 0.29589456319809, 0.295270919799805, 0.294647991657257, 0.294025957584381, 0.293405026197433, 0.292785227298737, 0.292166531085968, 0.29154896736145, 0.290932148694992, 0.290316522121429, 0.289701908826828, 0.289088129997253, 0.288475424051285, 0.287863940000534, 0.28725329041481, 0.286643773317337, 0.286035448312759, 0.285427957773209, 0.284821569919586, 0.284216284751892, 0.283611834049225, 0.283008426427841, 0.282406389713287, 0.281804770231247, 0.281204700469971, 0.280605494976044, 0.2800073325634, 0.279410004615784, 0.278813928365707, 0.278218954801559, 0.277650654315948, 0.277131825685501, 0.276614040136337, 0.276096701622009, 0.275580018758774, 0.275064647197723, 0.274549841880798, 0.274035632610321, 0.27352237701416, 0.273010462522507, 0.272498726844788, 0.27198800444603, 0.271477997303009, 0.270968973636627, 0.270460665225983, 0.269953012466431, 0.269446283578873, 0.268940687179565, 0.268435686826706, 0.267931431531906, 0.267427951097488, 0.266925454139709, 0.266423493623734, 0.265922516584396, 0.265422314405441, 0.26492303609848, 0.264424353837967, 0.263926655054092, 0.263429492712021, 0.262933701276779, 0.262438476085663, 0.261943817138672, 0.26145014166832, 0.260957390069962, 0.260465234518051, 0.259974032640457, 0.259483397006989, 0.258993715047836, 0.258505046367645, 0.258016914129257, 0.257529705762863, 0.257043689489365, 0.2565578520298, 0.256073147058487, 0.2555892765522, 0.255106300115585, 0.254623711109161, 0.254142343997955, 0.253661662340164, 0.253181934356689, 0.252702832221985, 0.25222447514534, 0.251747280359268, 0.251270622014999, 0.250794589519501, 0.25031965970993, 0.249845385551453, 0.249371975660324, 0.248899593949318, 0.248427957296371, 0.247956916689873, 0.247486785054207, 0.247017428278923, 0.246549054980278, 0.246081426739693, 0.245614364743233, 0.245148301124573, 0.244683161377907, 0.244218617677689, 0.243754833936691, 0.24329200387001, 0.242829963564873, 0.242307648062706, 0.241766557097435, 0.241226449608803, 0.240687116980553, 0.240148529410362, 0.239610716700554, 0.239073663949966, 0.238537386059761, 0.238001883029938, 0.237467125058174, 0.236933186650276, 0.236399933695793, 0.235867530107498, 0.235335677862167, 0.234804823994637, 0.234274700284004, 0.233745321631432, 0.23321670293808, 0.232688874006271, 0.232161656022072, 0.231635347008705, 0.231109634041786, 0.230584904551506, 0.230060860514641, 0.229537665843964, 0.229015201330185, 0.228493347764015, 0.227972447872162, 0.227452337741852, 0.226932778954506, 0.226414144039154, 0.22589610517025, 0.225379034876823, 0.224862739443779, 0.224347397685051, 0.223832443356514, 0.223318248987198, 0.222804993391037, 0.22229215502739, 0.22178065776825, 0.221269533038139, 0.220759376883507, 0.220249980688095, 0.219741210341454, 0.219233348965645, 0.218726053833961, 0.218219742178917, 0.217713996767998, 0.217209219932556, 0.216704979538918, 0.216201782226562, 0.215699106454849, 0.215197369456291, 0.214696243405342, 0.214196071028709, 0.213696479797363, 0.213197872042656, 0.212699830532074, 0.212202683091164, 0.211706191301346, 0.211210608482361, 0.210715621709824, 0.210221216082573, 0.209727957844734, 0.209235265851021, 0.208743512630463, 0.208252370357513, 0.207762196660042, 0.207272574305534, 0.20678374171257, 0.206295907497406, 0.205817773938179, 0.205406486988068, 0.204995885491371, 0.204586163163185, 0.204177349805832, 0.203769564628601, 0.203362479805946, 0.202956259250641, 0.202550932765007, 0.202146276831627, 0.201743066310883, 0.201340183615685, 0.200938329100609, 0.200537532567978, 0.200137481093407, 0.199738472700119, 0.199340105056763, 0.198942467570305, 0.198546081781387, 0.198150396347046, 0.197755545377731, 0.197361573576927, 0.196968495845795, 0.196576297283173, 0.1961849629879, 0.195794701576233, 0.19540511071682, 0.19501619040966, 0.194628402590752, 0.194241270422935, 0.193855360150337, 0.193470150232315, 0.193085849285126, 0.192702576518059, 0.192319825291634, 0.191938117146492, 0.1915572732687, 0.191177308559418, 0.190798416733742, 0.190420046448708, 0.190042704343796, 0.189666450023651, 0.189290881156921, 0.188916221261024, 0.188542172312737, 0.188169062137604, 0.187796980142593, 0.187425598502159, 0.187055259943008, 0.186685994267464, 0.186317428946495, 0.185949519276619, 0.185582742094994, 0.185216784477234, 0.18485152721405, 0.184487491846085, 0.184124201536179, 0.183761596679688, 0.183400198817253, 0.183039486408234, 0.182679712772369, 0.182320550084114, 0.181962490081787, 0.181604936718941, 0.181248411536217, 0.180893167853355, 0.180538401007652, 0.180184721946716, 0.179831892251968, 0.179479762911797, 0.179128915071487, 0.178778529167175, 0.178355023264885, 0.177948549389839, 0.17754253745079, 0.177136942744255, 0.176731735467911, 0.176327094435692, 0.175923019647598, 0.175519526004791, 0.175116330385208, 0.174713790416718, 0.174311622977257, 0.17391000688076, 0.173508763313293, 0.17310805618763, 0.172707974910736, 0.172308281064034, 0.171909168362617, 0.171510487794876, 0.171112224459648, 0.170714631676674, 0.170317336916924, 0.169920668005943, 0.169524192810059, 0.169128507375717, 0.168733239173889, 0.168338447809219, 0.167944297194481, 0.167550519108772, 0.167157247662544, 0.166764482855797, 0.166372090578079, 0.165980130434036, 0.165588781237602, 0.165198013186455, 0.16480764746666, 0.164417773485184, 0.164028435945511, 0.163639456033707, 0.163251206278801, 0.162863254547119, 0.162475690245628, 0.162088871002197, 0.161702394485474, 0.161316439509392, 0.160931006073952, 0.160546138882637, 0.160161584615707, 0.159777656197548, 0.159394219517708, 0.159011006355286, 0.158628553152084, 0.158246502280235, 0.157865047454834, 0.157483920454979, 0.157103478908539, 0.156723454594612, 0.156343832612038, 0.155964896082878, 0.155586093664169, 0.15520803630352, 0.154830425977707, 0.154453366994858, 0.1540766954422, 0.153700530529022, 0.153325021266937, 0.152949795126915, 0.152575194835663, 0.152200773358345, 0.15182714164257, 0.151454046368599, 0.15108135342598, 0.150745362043381, 0.150383725762367, 0.150023952126503, 0.149665504693985, 0.149308443069458, 0.148952528834343, 0.148598372936249, 0.148245617747307, 0.147894278168678, 0.14754481613636, 0.147196471691132, 0.146849438548088, 0.146504104137421, 0.146160066127777, 0.145817533135414, 0.145476385951042, 0.145136952400208, 0.144798904657364, 0.144462078809738, 0.144126951694489, 0.143792942166328, 0.143460988998413, 0.143130153417587, 0.142800554633141, 0.142472520470619, 0.142145916819572, 0.141820907592773, 0.141497477889061, 0.141175538301468, 0.140854835510254, 0.140535429120064, 0.140217617154121, 0.13990131020546, 0.139586493372917, 0.139273285865784, 0.138961181044579, 0.138650879263878, 0.138341680169106, 0.138034179806709, 0.137728169560432, 0.137423381209373, 0.137120276689529, 0.136818498373032, 0.136518195271492, 0.136219307780266, 0.135921910405159, 0.135625839233398, 0.135331630706787, 0.135038554668427, 0.134747162461281, 0.134456887841225, 0.134168013930321, 0.133881136775017, 0.133595451712608, 0.13331127166748, 0.133028477430344, 0.132746934890747, 0.132467240095139, 0.132188677787781, 0.131911709904671, 0.131636142730713, 0.131361976265907, 0.131089419126511, 0.130818068981171, 0.130548313260078, 0.130280435085297, 0.130013570189476, 0.129748210310936, 0.129484161734581, 0.129221633076668, 0.128960683941841, 0.128701746463776, 0.12849123775959, 0.128281235694885, 0.128072082996368, 0.127863600850105, 0.127656161785126, 0.1274493932724, 0.127243682742119, 0.127038836479187, 0.126834467053413, 0.126630961894989, 0.126428484916687, 0.126226916909218, 0.126025974750519, 0.125826090574265, 0.125626876950264, 0.125428542494774, 0.125230863690376, 0.125034049153328, 0.124838270246983, 0.124643176794052, 0.12444894015789, 0.124255381524563, 0.124062664806843, 0.123870827257633, 0.123680420219898, 0.123490296304226, 0.123300850391388, 0.123112268745899, 0.122924707829952, 0.122737847268581, 0.122551657259464, 0.12236687541008, 0.122182600200176, 0.121998965740204, 0.121816210448742, 0.121634297072887, 0.121453464031219, 0.121273472905159, 0.121093966066837, 0.12091551721096, 0.120737552642822, 0.120560817420483, 0.120384752750397, 0.120209351181984, 0.120035193860531, 0.119861714541912, 0.119688905775547, 0.11951694637537, 0.119345657527447, 0.119175620377064, 0.119006253778934, 0.11883756518364, 0.118669711053371, 0.118502929806709, 0.118336826562881, 0.118171364068985, 0.118007153272629, 0.117843441665173, 0.117680750787258, 0.117518559098244, 0.117357425391674, 0.117196954786777, 0.117037892341614, 0.116879150271416, 0.116721235215664, 0.116564027965069, 0.116407848894596, 0.116252548992634, 0.116097904741764, 0.115944519639015, 0.115791589021683, 0.115591004490852, 0.115390442311764, 0.115189991891384, 0.114989921450615, 0.114789977669716, 0.114590235054493, 0.114390790462494, 0.11419153958559, 0.113992519676685, 0.113793767988682, 0.113595247268677, 0.113396823406219, 0.113198786973953, 0.113000869750977, 0.112803339958191, 0.112605921924114, 0.112408697605133, 0.112211778759956, 0.112015053629875, 0.111818559467793, 0.111622363328934, 0.111426346004009, 0.111230440437794, 0.111034855246544, 0.110839746892452, 0.110644549131393, 0.1104496717453, 0.110255070030689, 0.110060594975948, 0.109866410493851, 0.109672524034977, 0.109478741884232, 0.109285272657871, 0.109092094004154, 0.108899012207985, 0.108706146478653, 0.108513586223125, 0.108321234583855, 0.108129180967808, 0.107937224209309, 0.107745565474033, 0.107554227113724, 0.10736296325922, 0.107172004878521, 0.106981262564659, 0.106790833175182, 0.106600493192673, 0.106410436332226, 0.106220625340939, 0.106031090021133, 0.105841659009457, 0.105652526021004, 0.105463705956936, 0.105275012552738, 0.105086587369442, 0.104898378252983, 0.104710347950459, 0.104522660374641, 0.104335136711597, 0.104147829115391, 0.103960826992989, 0.103773921728134, 0.103587336838245, 0.103400938212872, 0.103214845061302, 0.103028945624828, 0.102843172848225, 0.102657809853554, 0.102472513914108, 0.102287642657757, 0.102102868258953, 0.101930744946003, 0.101747266948223, 0.101564988493919, 0.101383939385414, 0.101203434169292, 0.101024255156517, 0.100845813751221, 0.100668415427208, 0.100492134690285, 0.100316889584064, 0.100142389535904, 0.0999691039323807, 0.0997967571020126, 0.0996253564953804, 0.0994548872113228, 0.0992852449417114, 0.0991168394684792, 0.0989494621753693, 0.0987825468182564, 0.0986171364784241, 0.0984527468681335, 0.0982890203595161, 0.0981263220310211, 0.0979647487401962, 0.0978041142225266, 0.0976445078849792, 0.0974858403205872, 0.0973281040787697, 0.0971714928746223, 0.0970155447721481, 0.0968608930706978, 0.0967070981860161, 0.0965541452169418, 0.0964025855064392, 0.0962515994906425, 0.0961018279194832, 0.0959528908133507, 0.0958050936460495, 0.0956581383943558, 0.095512293279171, 0.0953671187162399, 0.0952230542898178, 0.0950800254940987, 0.0949380248785019, 0.0947970598936081, 0.0946570336818695, 0.0945180356502533, 0.0943798795342445, 0.0942426547408104, 0.0941067487001419, 0.0939716845750809, 0.0938373655080795, 0.0937043577432632, 0.0935721024870872, 0.0934405848383904, 0.0933103933930397, 0.0931811258196831, 0.0930532813072205, 0.0929256156086922, 0.0927991643548012, 0.0926738381385803, 0.0925494432449341, 0.0924263745546341, 0.0923040434718132, 0.0921824648976326, 0.0920620188117027, 0.0919425040483475, 0.0918239131569862, 0.0917064547538757, 0.0915898457169533, 0.0914747267961502, 0.0913600921630859, 0.0912903547286987, 0.0912366807460785, 0.0911830067634583, 0.0911292508244514, 0.091076135635376, 0.0910225585103035, 0.0909688845276833, 0.0909156799316406, 0.0908621028065681, 0.0908089950680733, 0.0907554179430008, 0.0907019376754761, 0.0906492918729782, 0.0905958190560341, 0.0905426144599915, 0.0904894098639488, 0.0904362052679062, 0.0903831943869591, 0.0903302729129791, 0.0902770683169365, 0.0902241468429565, 0.0901709422469139, 0.090117834508419, 0.0900649130344391, 0.0900120958685875, 0.089958980679512, 0.0899064391851425, 0.0898536965250969, 0.0898006856441498, 0.0897480547428131, 0.0896954014897346, 0.0896424800157547, 0.0895901247859001, 0.0895375832915306, 0.0894848555326462, 0.0894322022795677, 0.0893796607851982, 0.0893271043896675, 0.0892746672034264, 0.0892222076654434, 0.0891701281070709, 0.0891176760196686, 0.0890650302171707, 0.0890128612518311, 0.0889604091644287, 0.088908426463604, 0.0888562574982643, 0.0888040885329247, 0.0887519121170044, 0.0886996388435364, 0.088647373020649, 0.0885953903198242, 0.0885434076189995, 0.0884918048977852, 0.0884396284818649, 0.0883876457810402, 0.0883356630802155, 0.088283859193325, 0.0882317796349525, 0.0881803631782532, 0.0881284773349762, 0.0880764946341515, 0.0880246013402939, 0.0879728943109512, 0.0879211872816086, 0.0878695771098137, 0.0878179669380188, 0.0877666398882866, 0.0877150297164917, 0.0876636058092117, 0.0876120030879974, 0.0875395908951759, 0.0874548256397247, 0.0873685628175735, 0.0872801393270493, 0.0871903151273727, 0.0870988965034485, 0.0870056077837944, 0.0869106352329254, 0.0868139639496803, 0.0867156162858009, 0.0866154059767723, 0.0865136682987213, 0.0864102691411972, 0.0863046124577522, 0.0861976444721222, 0.0860888138413429, 0.0859788432717323, 0.0858664438128471, 0.0857525542378426, 0.0856371521949768, 0.0855198800563812, 0.0854011178016663, 0.0852804630994797, 0.0851573869585991, 0.0850333720445633, 0.0849076807498932, 0.0847799181938171, 0.0846504792571068, 0.0845195278525352, 0.0843868926167488, 0.0842525735497475, 0.084116205573082, 0.083977960050106, 0.0838385820388794, 0.0836975201964378, 0.083554208278656, 0.0834095850586891, 0.083263099193573, 0.0831151083111763, 0.0829652398824692, 0.0828136876225471, 0.0826602578163147, 0.082504965364933, 0.0823481678962708, 0.0821898728609085, 0.0820295214653015, 0.0818678513169289, 0.0817041248083115, 0.0815387144684792, 0.0813716128468513, 0.0812031999230385, 0.0810325369238853, 0.080860011279583, 0.0806861594319344, 0.0805106312036514, 0.0803332254290581, 0.0801541358232498, 0.0799733623862267, 0.0797909051179886, 0.079606756567955, 0.0794207379221916, 0.0792328417301178, 0.079043447971344, 0.0788523703813553, 0.0786596089601517, 0.0784651562571526, 0.0782690197229385, 0.0780710130929947, 0.0778713151812553, 0.0776701271533966, 0.0774668678641319, 0.0772619247436523, 0.0769829228520393, 0.0766891837120056, 0.0763958171010017, 0.0761018991470337, 0.075808160007, 0.0755138695240021, 0.0752197504043579, 0.0749256461858749, 0.0746313408017159, 0.0743368566036224, 0.0740418136119843, 0.0737469494342804, 0.0734524577856064, 0.0731568560004234, 0.0728621855378151, 0.0725667551159859, 0.0722713321447372, 0.0719759166240692, 0.0716802999377251, 0.0713843181729317, 0.0710885226726532, 0.0707923471927643, 0.0704963654279709, 0.0702000111341476, 0.0699038356542587, 0.0696074813604355, 0.0693103671073914, 0.0690140128135681, 0.068716898560524, 0.0684199780225754, 0.068122498691082, 0.0678253918886185, 0.0675282776355743, 0.067230798304081, 0.066933311522007, 0.0666354596614838, 0.0663376003503799, 0.0660397410392761, 0.0657416954636574, 0.0654432773590088, 0.0651450455188751, 0.0648462474346161, 0.0645480155944824, 0.0642488449811935, 0.0639506131410599, 0.063651442527771, 0.0633522793650627, 0.0630531087517738, 0.0627535656094551, 0.0624543949961662, 0.0621546655893326, 0.0618549361824989, 0.061555203050375, 0.0612552873790264, 0.0609555579721928, 0.0606552585959435, 0.0603547804057598, 0.0600546784698963, 0.059753630310297, 0.0594529658555984, 0.0591521076858044, 0.0588512532413006, 0.0585503950715065, 0.0582493580877781, 0.0579481311142445, 0.0576465204358101, 0.0573451071977615, 0.0570435002446175, 0.0567413344979286, 0.0564395450055599, 0.0561375617980957, 0.0558815822005272, 0.0556537918746471, 0.0554274916648865, 0.055203627794981, 0.0549808889627457, 0.0547607764601707, 0.0545423477888107, 0.054325420409441, 0.0541114881634712, 0.053897924721241, 0.0536873675882816, 0.0534783080220222, 0.0532711148262024, 0.0530661754310131, 0.0528627298772335, 0.0526611655950546, 0.0524618476629257, 0.052264392375946, 0.0520688220858574, 0.0518747456371784, 0.0516832955181599, 0.0514929667115211, 0.0513048842549324, 0.0511190518736839, 0.0509343408048153, 0.0507522560656071, 0.0505716688930988, 0.0503933280706406, 0.0502164885401726, 0.0500415191054344, 0.0498687960207462, 0.0496977679431438, 0.049528606235981, 0.0493615083396435, 0.0491962805390358, 0.0490329265594482, 0.048871073871851, 0.0487118400633335, 0.0485542938113213, 0.0483986213803291, 0.048244446516037, 0.0480925254523754, 0.0479424707591534, 0.0477942898869514, 0.04764798656106, 0.0475037358701229, 0.0473609901964664, 0.04722049087286, 0.0470818653702736, 0.0469453036785126, 0.0468102395534515, 0.0466772317886353, 0.046546284109354, 0.0464172139763832, 0.0462900139391422, 0.046164695173502, 0.0460412390530109, 0.0459192879498005, 0.0457997694611549, 0.0456821247935295, 0.0455663576722145, 0.0454522669315338, 0.0453400574624538, 0.0452299043536186, 0.0451216287910938, 0.0450154095888138, 0.0449112541973591, 0.0448082201182842, 0.0447078160941601, 0.0446089021861553, 0.0445122420787811, 0.0444152913987637, 0.0443686544895172, 0.044322844594717, 0.0442767627537251, 0.0442318022251129, 0.0441875047981739, 0.0441436618566513, 0.0441006720066071, 0.044057872146368, 0.0440153405070305, 0.0439742244780064, 0.0439330078661442, 0.0438930131494999, 0.0438531152904034, 0.0438139624893665, 0.0437753684818745, 0.0437372513115406, 0.0437000617384911, 0.0436631552875042, 0.0436270087957382, 0.0435912236571312, 0.0435558184981346, 0.0435217246413231, 0.0434875339269638, 0.043454471975565, 0.0434216894209385, 0.0433891899883747, 0.0433578081429005, 0.0433267168700695, 0.0432966463267803, 0.0432663895189762, 0.0432370752096176, 0.0432085059583187, 0.0431805029511452, 0.0431529618799686, 0.04312589392066, 0.0430992916226387, 0.0430739112198353, 0.0430485308170319, 0.0430241711437702, 0.0429998189210892, 0.0429763086140156, 0.0429536402225494, 0.0429314486682415, 0.0429096184670925, 0.0428886376321316, 0.0428680293262005, 0.0428482703864574, 0.042828407138586, 0.0428100526332855, 0.0427916944026947, 0.0427741818130016, 0.0427572280168533, 0.0427404567599297, 0.0427248179912567, 0.0427092686295509, 0.0426949337124825, 0.0426806062459946, 0.0426669307053089, 0.0426540970802307, 0.0426415503025055, 0.0426300279796124, 0.0426188781857491, 0.0426081083714962, 0.0425979942083359, 0.0425884388387203, 0.0425799153745174, 0.0425712019205093, 0.0425638034939766, 0.0425564050674438, 0.0425500385463238, 0.0425442270934582, 0.0424944944679737, 0.0424410067498684, 0.0423867776989937, 0.0423318929970264, 0.0422764346003532, 0.042220052331686, 0.0421629138290882, 0.0421052165329456, 0.0420467667281628, 0.0419873856008053, 0.041927345097065, 0.0418667420744896, 0.0418051108717918, 0.041742917150259, 0.0416801609098911, 0.0416162796318531, 0.0415517464280128, 0.0414868332445621, 0.0414208956062794, 0.0413541086018085, 0.0412868596613407, 0.0412187650799751, 0.0411498248577118, 0.0410803258419037, 0.0410100780427456, 0.040938887745142, 0.0408671423792839, 0.0407948344945908, 0.0407213978469372, 0.0406472161412239, 0.0405726581811905, 0.0404971651732922, 0.0404211021959782, 0.0403441116213799, 0.0402661859989166, 0.040187880396843, 0.0401090122759342, 0.0400290191173553, 0.0399482809007168, 0.0398668833076954, 0.0397848337888718, 0.0397020317614079, 0.0396184846758842, 0.0395342782139778, 0.0394492298364639, 0.0393635258078575, 0.0392770729959011, 0.039189774543047, 0.0391018241643906, 0.0390132144093513, 0.0389237627387047, 0.0388334728777409, 0.0387425236403942, 0.0386509150266647, 0.0385584644973278, 0.0384655520319939, 0.0383715108036995, 0.0382770001888275, 0.0381815582513809, 0.0380853600800037, 0.0379888862371445, 0.0378913767635822, 0.0377929359674454, 0.0376939289271832, 0.0375942699611187, 0.0374937653541565, 0.0373926088213921, 0.0372906066477299, 0.0371880419552326, 0.0370846353471279, 0.0369804799556732, 0.036872424185276, 0.0367474779486656, 0.0366225242614746, 0.0364972949028015, 0.0363716892898083, 0.0362459905445576, 0.0361200086772442, 0.0359941236674786, 0.0358679555356503, 0.035741601139307, 0.0356147773563862, 0.035488236695528, 0.0353611297905445, 0.0352340266108513, 0.0351069234311581, 0.034979160875082, 0.0348514951765537, 0.0347236394882202, 0.0345956943929195, 0.0344673730432987, 0.0343390516936779, 0.034210167825222, 0.034081656485796, 0.0339524932205677, 0.0338233262300491, 0.0336941629648209, 0.0335646234452724, 0.0334348045289516, 0.0333048887550831, 0.0331747867166996, 0.0330444052815437, 0.0329140238463879, 0.0327834524214268, 0.0326526910066605, 0.0325215607881546, 0.0323905237019062, 0.0322590172290802, 0.0321276038885117, 0.0319959074258804, 0.0318639352917671, 0.031731866300106, 0.0315994247794151, 0.0314670763909817, 0.0313344448804855, 0.0312014371156693, 0.0310684330761433, 0.0309354290366173, 0.0308018606156111, 0.0306682009249926, 0.0305345393717289, 0.0304008778184652, 0.0302664656192064, 0.030132245272398, 0.0299975518137217, 0.0298629552125931, 0.0297281723469496, 0.0295931976288557, 0.0294580403715372, 0.029322411864996, 0.0291868764907122, 0.0290508754551411, 0.0289151519536972, 0.0287789646536112, 0.0286426786333323, 0.0285060200840235, 0.028369365260005, 0.0282323323190212, 0.0280953906476498, 0.0279581714421511, 0.0278207622468472, 0.0276831686496735, 0.0275452919304371, 0.0274258591234684, 0.02729950286448, 0.0271741785109043, 0.0270488541573286, 0.0269246511161327, 0.0268008261919022, 0.026677843183279, 0.0265552327036858, 0.0264334678649902, 0.0263118911534548, 0.026191433891654, 0.0260711684823036, 0.025951836258173, 0.0258328821510077, 0.0257149562239647, 0.0255972165614367, 0.0254799462854862, 0.0253638010472059, 0.0252476558089256, 0.0251330081373453, 0.02501798607409, 0.0249043703079224, 0.0247908476740122, 0.0246783550828695, 0.0245659574866295, 0.0244546793401241, 0.0243437811732292, 0.0242333486676216, 0.024123664945364, 0.024014825001359, 0.0239062681794167, 0.0237985495477915, 0.0236914902925491, 0.0235848035663366, 0.0234788712114096, 0.0233735889196396, 0.0232686810195446, 0.02316471375525, 0.0230611190199852, 0.0229578986763954, 0.0228559914976358, 0.0227538961917162, 0.0226531103253365, 0.0225525125861168, 0.0224528536200523, 0.0223535653203726, 0.0222551245242357, 0.0221568681299686, 0.0220596417784691, 0.0219628848135471, 0.0218668766319752, 0.0217710565775633, 0.0216762684285641, 0.0215817578136921, 0.0214882791042328, 0.021395081654191, 0.0213028192520142, 0.0212106555700302, 0.021119799464941, 0.0210287552326918, 0.0209386479109526, 0.0208493825048208, 0.0207605883479118, 0.0206723567098379, 0.0205845907330513, 0.0204980429261923, 0.0204113088548183, 0.0203258842229843, 0.0202404633164406, 0.0201563518494368, 0.0200720522552729, 0.0199969317764044, 0.0199301484972239, 0.0198642071336508, 0.0197986420243979, 0.0197338238358498, 0.0196697562932968, 0.0196065325289965, 0.0195434000343084, 0.0194814875721931, 0.0194197632372379, 0.0193591602146626, 0.0192988384515047, 0.0192390810698271, 0.0191805399954319, 0.0191219989210367, 0.0190648622810841, 0.0190077256411314, 0.0189516190439463, 0.0188957955688238, 0.0188412815332413, 0.0187867674976587, 0.0187334716320038, 0.0186802688986063, 0.0186282843351364, 0.0185764860361814, 0.0185257196426392, 0.018475329503417, 0.0184258725494146, 0.0183766987174749, 0.0183285549283028, 0.0182805974036455, 0.0182338580489159, 0.0181873999536037, 0.0181420650333166, 0.0180967301130295, 0.0180522389709949, 0.0180088728666306, 0.0179655030369759, 0.0179234482347965, 0.0178814865648746, 0.0178405549377203, 0.0178000889718533, 0.0177605636417866, 0.0177212227135897, 0.0176829155534506, 0.0176449790596962, 0.0176082625985146, 0.0175715461373329, 0.0175360459834337, 0.0175007339566946, 0.0174661707133055, 0.0174323562532663, 0.0173993874341249, 0.017366886138916, 0.0173351317644119, 0.0173038467764854, 0.0172731261700392, 0.0172434337437153, 0.0172139294445515, 0.0171858295798302, 0.0171575434505939, 0.0171306598931551, 0.0171039644628763, 0.0170782078057528, 0.0170527286827564, 0.0170284695923328, 0.0170043054968119, 0.0169812627136707, 0.0169584080576897, 0.0169367715716362, 0.0169151350855827, 0.0168948099017143, 0.0168717857450247, 0.016850758343935, 0.016829751431942, 0.0168093107640743, 0.0167891960591078, 0.0167691521346569, 0.0167495757341385, 0.0167303271591663, 0.0167111251503229, 0.0166924875229597, 0.0166741050779819, 0.016655957326293, 0.0166379734873772, 0.0166205279529095, 0.0166032705456018, 0.0165862217545509, 0.0165696199983358, 0.0165532976388931, 0.0165370479226112, 0.016521405428648, 0.0165059976279736, 0.0164908710867167, 0.0164758153259754, 0.0164612736552954, 0.0164470821619034, 0.0164329614490271, 0.0164192635565996, 0.016405962407589, 0.0163926854729652, 0.0163798537105322, 0.0163675844669342, 0.0163553599268198, 0.0163433011621237, 0.0163316633552313, 0.0163203999400139, 0.0163093004375696, 0.0162986218929291, 0.0162882003933191, 0.0162779223173857, 0.0162681341171265, 0.0162587445229292, 0.0162495411932468, 0.0162403862923384, 0.0162317678332329, 0.0162234082818031, 0.0162152126431465, 0.0162076242268085, 0.0162001326680183, 0.0161928031593561, 0.0161859877407551, 0.016179408878088, 0.0161732975393534, 0.0161671619862318, 0.016161447390914, 0.0161561090499163, 0.0161507949233055, 0.0161460638046265, 0.0161417555063963, 0.0161373075097799, 0.016133489087224, 0.0161298848688602, 0.0161265805363655, 0.0161234196275473, 0.0161208212375641, 0.0161183625459671, 0.016116114333272, 0.0161143578588963, 0.0161127671599388, 0.0161115024238825, 0.0161106362938881, 0.0161099806427956, 0.0161041971296072, 0.0160993505269289, 0.0160946436226368, 0.0160899963229895, 0.0160854533314705, 0.016081003472209, 0.016076659783721, 0.0160723980516195, 0.0160682760179043, 0.0160642135888338, 0.0160602554678917, 0.0160564053803682, 0.0160526223480701, 0.0160489697009325, 0.0160453990101814, 0.0160419456660748, 0.0160385388880968, 0.016035282984376, 0.0160320978611708, 0.0160290561616421, 0.0160260442644358, 0.0160231534391642, 0.01602035574615, 0.0160176623612642, 0.0160150732845068, 0.0160125680267811, 0.016010157763958, 0.0160078387707472, 0.0160056855529547, 0.0160035416483879, 0.0160015393048525, 0.0159996077418327, 0.0159978047013283, 0.0159960724413395, 0.015994431450963, 0.0159928984940052, 0.0159914586693048, 0.0159901473671198, 0.0159888956695795, 0.0159877482801676, 0.015986729413271, 0.0159857794642448, 0.0159849151968956, 0.0159841757267714, 0.0159835312515497, 0.0159829594194889, 0.0159824788570404, 0.0159821175038815, 0.0159818474203348, 0.0159817188978195, 0.0159816350787878, 0.0159816239029169, 0.0159817524254322, 0.015981987118721, 0.0159822795540094, 0.0159827135503292, 0.0159832052886486, 0.0159838255494833, 0.0159845501184464, 0.0159853231161833, 0.0159862264990807, 0.0159872323274612, 0.0159883089363575, 0.0159895047545433, 0.0159907788038254, 0.0159921385347843, 0.0159936491400003, 0.0159952063113451, 0.0159968920052052, 0.0159986577928066, 0.0160005427896976, 0.0160025581717491, 0.016012217849493, 0.0160218086093664, 0.0160310454666615, 0.0160403288900852, 0.0160493440926075, 0.0160580314695835, 0.0160667784512043, 0.0160749517381191, 0.0160832516849041, 0.0160911325365305, 0.0160990227013826, 0.0161064807325602, 0.0161139871925116, 0.0161213148385286, 0.0161281991750002, 0.0161352604627609, 0.0161416530609131, 0.0161482561379671, 0.0161543563008308, 0.0161605607718229, 0.0161662269383669, 0.0161720365285873, 0.0161773040890694, 0.0161826908588409, 0.0161879360675812, 0.0161926411092281, 0.0161975007504225, 0.0162017978727818, 0.0162063054740429, 0.0162102039903402, 0.0162142217159271, 0.0162178836762905, 0.0162215027958155, 0.0162249561399221, 0.0162278730422258, 0.0162310320883989, 0.0162335503846407, 0.0162362791597843, 0.0162384919822216, 0.0162408091127872, 0.0162426941096783, 0.0162445213645697, 0.0162461828440428, 0.0162474140524864, 0.0162487719208002, 0.0162496138364077, 0.0162505619227886, 0.016251077875495, 0.0162516161799431, 0.0162517093122005, 0.0162518508732319, 0.0162518266588449, 0.0162512641400099, 0.0162508431822062, 0.0162499658763409, 0.0162491463124752, 0.0162478815764189, 0.0162466298788786, 0.0162451304495335, 0.0162433963268995, 0.0162415821105242, 0.0162393338978291, 0.0162372160702944, 0.0162345562130213, 0.0162319466471672, 0.0162289962172508, 0.0162259638309479, 0.0162226967513561, 0.0162192564457655, 0.0162155665457249, 0.0162117276340723, 0.0161976031959057, 0.0161860827356577, 0.0161743741482496, 0.0161619186401367, 0.0161489918828011, 0.0161355044692755, 0.0161214526742697, 0.016107028350234, 0.0160919483751059, 0.0160767752677202, 0.0160605721175671, 0.0160441789776087, 0.0160270389169455, 0.0160096157342196, 0.0159914456307888, 0.0159729011356831, 0.0159536972641945, 0.0159341227263212, 0.0159141719341278, 0.0158934704959393, 0.0158723965287209, 0.0158506669104099, 0.0158283747732639, 0.0158057063817978, 0.0157824773341417, 0.0157585926353931, 0.0157343335449696, 0.015709700062871, 0.0156843140721321, 0.0156586524099112, 0.0156322382390499, 0.0156054496765137, 0.0155781926587224, 0.0155501877889037, 0.0155218057334423, 0.015492957085371, 0.0154634527862072, 0.0154335722327232, 0.0154032241553068, 0.015372128225863, 0.0153409373015165, 0.0153086232021451, 0.015276120044291, 0.0152430571615696, 0.015209523960948, 0.0151754301041365, 0.0151407737284899, 0.0151059301570058, 0.0150701496750116, 0.0150342751294374, 0.0149976527318358, 0.0149604678153992, 0.0149227203801274, 0.0148845985531807, 0.0148458210751414, 0.0148065751418471, 0.0147667676210403, 0.014726584777236, 0.0146858394145966, 0.0146446265280247, 0.0146027589216828, 0.0145603278651834, 0.0145176164805889, 0.0144742494449019, 0.0144303198903799, 0.0143861100077629, 0.0143410572782159, 0.0142958154901862, 0.0142498267814517, 0.014203461818397, 0.0141564402729273, 0.0141143342480063, 0.0140502201393247, 0.0139862466603518, 0.0139218047261238, 0.0138570806011558, 0.0137924049049616, 0.0137274470180273, 0.0136622553691268, 0.0135968774557114, 0.0135313114151359, 0.0134656047448516, 0.0133996633812785, 0.0133334407582879, 0.0132671259343624, 0.0132005764171481, 0.0131339328363538, 0.0130671029910445, 0.0129999425262213, 0.012932644225657, 0.0128651596605778, 0.012797343544662, 0.0127296699211001, 0.0126614356413484, 0.0125931054353714, 0.0125246830284595, 0.0124558843672276, 0.0123872272670269, 0.0123182889074087, 0.0122490236535668, 0.0121796168386936, 0.0121099762618542, 0.0120401019230485, 0.0119701335206628, 0.011899882927537, 0.0118294470012188, 0.0117590101435781, 0.0116881988942623, 0.0116170588880777, 0.011545967310667, 0.0114745004102588, 0.0114028919488192, 0.0113311437889934, 0.0112591618672013, 0.0111869927495718, 0.0111146355047822, 0.0110422326251864, 0.0109694059938192, 0.0108965802937746, 0.010823474265635, 0.0107501335442066, 0.010676653124392, 0.0106028914451599, 0.0105291297659278, 0.0104548996314406, 0.0103808101266623, 0.0103063452988863, 0.0102314604446292, 0.0101567143574357, 0.0100814532488585, 0.010006146505475, 0.00993079133331776, 0.00985510926693678, 0.00977933406829834, 0.00970327761024237, 0.00962712615728378, 0.00955069530755281, 0.00947412382811308, 0.00939731765538454, 0.00932023115456104, 0.00924309622496367, 0.00916563533246517, 0.00908807944506407, 0.00902588572353125, 0.00895886775106192, 0.00889222417026758, 0.00882595591247082, 0.00875987391918898, 0.00869407411664724, 0.00862864777445793, 0.00856355018913746, 0.00849864073097706, 0.00843391660600901, 0.00836966186761856, 0.00830568838864565, 0.00824185460805893, 0.00817825552076101, 0.00811512488871813, 0.0080522745847702, 0.00798970647156239, 0.00792741775512695, 0.00786541122943163, 0.0078037790954113, 0.00774238118901849, 0.0076812170445919, 0.0076204277575016, 0.00755982613191009, 0.00749955233186483, 0.00743965292349458, 0.00737984711304307, 0.00732046272605658, 0.00726140663027763, 0.00720263086259365, 0.00714413681998849, 0.00708592310547829, 0.00702799111604691, 0.00697052665054798, 0.00691315624862909, 0.00685611367225647, 0.00679930485785007, 0.00674291886389256, 0.00668676570057869, 0.00663066003471613, 0.00657506985589862, 0.0065198065713048, 0.00646482454612851, 0.00641012331470847, 0.00635570334270597, 0.00630156463012099, 0.00624770624563098, 0.00619417661800981, 0.00614097388461232, 0.00608795927837491, 0.00603522593155503, 0.00598291307687759, 0.00593083444982767, 0.00587880332022905, 0.00582733377814293, 0.00577614549547434, 0.00572519097477198, 0.00567456427961588, 0.00562431337311864, 0.00557429483160377, 0.00552451191470027, 0.00547510338947177, 0.00542588112875819, 0.00537694152444601, 0.00532842194661498, 0.00528018362820148, 0.00523189920932055, 0.00518422294408083, 0.00513678090646863, 0.00508966762572527, 0.00504274060949683, 0.00499031972140074, 0.00495013687759638, 0.00491023529320955, 0.00487066153436899, 0.0048314156010747, 0.00479245046153665, 0.00475381361320615, 0.00471559772267938, 0.00467733573168516, 0.00463968189433217, 0.00460240291431546, 0.00456535816192627, 0.00452850107103586, 0.00449215853586793, 0.00445600366219878, 0.00442012958228588, 0.00438467739149928, 0.00434959959238768, 0.00431470898911357, 0.00428019324317575, 0.0042460523545742, 0.00421191053465009, 0.00417842529714108, 0.00414517382159829, 0.00411215703934431, 0.00407960824668407, 0.00404734024778008, 0.00401530647650361, 0.00398369412869215, 0.00395231647416949, 0.00392117258161306, 0.00389054417610168, 0.00386014953255653, 0.0038299891166389, 0.00380010972730815, 0.00377060519531369, 0.00374147505499423, 0.00371267297305167, 0.00368415168486536, 0.00365600525401533, 0.00362818618305027, 0.00360060180537403, 0.00357334525324404, 0.00354651012457907, 0.0035198621917516, 0.00349363568238914, 0.00346764363348484, 0.00344193214550614, 0.00341650191694498, 0.0033914465457201, 0.00336667196825147, 0.00334231904707849, 0.00331834028474987, 0.00329445581883192, 0.00327103910967708, 0.00324804452247918, 0.00322523666545749, 0.00320270983502269, 0.00318060489371419, 0.00315868738107383, 0.00313714426010847, 0.00311583513393998, 0.0030948540661484, 0.00307429442182183, 0.00305410986766219, 0.00303401821292937, 0.00301444227807224, 0.00299509987235069, 0.0029760857578367, 0.00295739993453026, 0.00293908803723752, 0.00292101036757231, 0.00289830542169511, 0.0028768558986485, 0.00285568763501942, 0.00283479993231595, 0.00281424052082002, 0.00279386807233095, 0.00277368281967938, 0.00275401305407286, 0.00273453071713448, 0.00271542277187109, 0.00269640842452645, 0.00267786276526749, 0.00265931664034724, 0.00264142639935017, 0.00262358319014311, 0.00260616163723171, 0.00258902064524591, 0.00257220747880638, 0.00255539431236684, 0.002539096865803, 0.0025230327155441, 0.00250729685649276, 0.00249188905581832, 0.00247666821815073, 0.00246172840707004, 0.00244702282361686, 0.00243283249437809, 0.00241864216513932, 0.00240501365624368, 0.00239147897809744, 0.00237813172861934, 0.00236534606665373, 0.0023527480661869, 0.00234057148918509, 0.00232848874293268, 0.00231659295968711, 0.00230511906556785, 0.00229387893341482, 0.00228315428830683, 0.00227257004007697, 0.00226222001947463, 0.0022520103957504, 0.00224212859757245, 0.00223276205360889, 0.00222358270548284, 0.00221477821469307, 0.00220620771870017, 0.00219777785241604, 0.00218976940959692, 0.00218204176053405, 0.00217459537088871, 0.00216747680678964, 0.00216059247031808, 0.00215380173176527, 0.0021475728135556, 0.00214153132401407, 0.00213577109389007, 0.00213033822365105, 0.00212528044357896, 0.0021202692296356, 0.00211553904227912, 0.00211123051121831, 0.00210729660466313, 0.00210354989394546, 0.00210013100877404, 0.00209675915539265, 0.00209399592131376, 0.00209137331694365, 0.00208907853811979, 0.00208711158484221, 0.00208547245711088, 0.00208823545835912, 0.00209214608184993, 0.00209629093296826, 0.0021005526650697, 0.00210525933653116, 0.0021098256111145, 0.00211481330916286, 0.00212010531686246, 0.00212556147016585, 0.00213132170028985, 0.00213719927705824, 0.0021433811634779, 0.00214953999966383, 0.00215616682544351, 0.00216300436295569, 0.0021700996439904, 0.00217735860496759, 0.00218487530946732, 0.00219239201396704, 0.00220035365782678, 0.00220847921445966, 0.00221700267866254, 0.00222554965876043, 0.00223433086648583, 0.00224329950287938, 0.0022525021340698, 0.0022620796225965, 0.00227184407413006, 0.00228184298612177, 0.00229202909395099, 0.00230230903252959, 0.00231289328075945, 0.00232378207147121, 0.00233492814004421, 0.00234626163728535, 0.0023576186504215, 0.0023693738039583, 0.00238140975125134, 0.00239353952929378, 0.00240597384981811, 0.00241871224716306, 0.0024313572794199, 0.00244449404999614, 0.00245793489739299, 0.00247137597762048, 0.00248528551310301, 0.00249924161471426, 0.00251338514499366, 0.00252780993469059, 0.00254249176941812, 0.00255747837945819, 0.00257255882024765, 0.00258794333785772, 0.00260337488725781, 0.00261913402937353, 0.00263522146269679, 0.00265151890926063, 0.00266800448298454, 0.00268467678688467, 0.00270139612257481, 0.00271858414635062, 0.00273595890030265, 0.00275354483164847, 0.00277145835570991, 0.00278948899358511, 0.00280766026116908, 0.00282611255533993, 0.00284491595812142, 0.00286388350650668, 0.00288310809992254, 0.00290245027281344, 0.00291962898336351, 0.00294077419675887, 0.00296191894449294, 0.00298299384303391, 0.00300409225746989, 0.00302514364011586, 0.00304626510478556, 0.00306724640540779, 0.00308822747319937, 0.00310932542197406, 0.00313018937595189, 0.00315112387761474, 0.00317210494540632, 0.00319303921423852, 0.00321385636925697, 0.00323476688936353, 0.00325560779310763, 0.00327642471529543, 0.00329719530418515, 0.00331798894330859, 0.00333875929936767, 0.00335952965542674, 0.00338020641356707, 0.00340093020349741, 0.00342165376059711, 0.0034423538018018, 0.00346291344612837, 0.00348354317247868, 0.003504219930619, 0.00352470949292183, 0.00354526890441775, 0.00356585206463933, 0.00358636467717588, 0.00360690103843808, 0.00362729676999152, 0.0036477860994637, 0.00366822862997651, 0.00368862436152995, 0.00370899611152709, 0.00372946239076555, 0.00374985812231898, 0.00377011322416365, 0.00379041535779834, 0.00381078780628741, 0.0038310659583658, 0.003851204412058, 0.00387145974673331, 0.00389169133268297, 0.00391192315146327, 0.00393201457336545, 0.00395217584446073, 0.00397233758121729, 0.00399254588410258, 0.00401254370808601, 0.00403265841305256, 0.00405270280316472, 0.0040726768784225, 0.00409272126853466, 0.00411269580945373, 0.00413269316777587, 0.00415255036205053, 0.00417252443730831, 0.00419245194643736, 0.00421233242377639, 0.00423214258626103, 0.0042519997805357, 0.00427185697481036, 0.00429173745214939, 0.00431145448237658, 0.00433124089613557, 0.00435100449249148, 0.00437069777399302, 0.00438361335545778, 0.00439728843048215, 0.00441091693937778, 0.00442426465451717, 0.00443751830607653, 0.00445067789405584, 0.0044637443497777, 0.00447653001174331, 0.00448917504400015, 0.00450177304446697, 0.00451423041522503, 0.00452645402401686, 0.00453858356922865, 0.00455061951652169, 0.00456251529976726, 0.00457412982359529, 0.00458565074950457, 0.00459712464362383, 0.00460845837369561, 0.00461946381255984, 0.00463046971708536, 0.00464138202369213, 0.00465196603909135, 0.00466255052015185, 0.00467299437150359, 0.00468334415927529, 0.00469336658716202, 0.00470334198325872, 0.0047132708132267, 0.00472296494990587, 0.0047323782928288, 0.00474183866754174, 0.00475111184641719, 0.0047602909617126, 0.00476918928325176, 0.00477808713912964, 0.0047867982648313, 0.00479541579261422, 0.00480370502918959, 0.00481194769963622, 0.00482018990442157, 0.00482815178111196, 0.00483592599630356, 0.00484365364536643, 0.00485124066472054, 0.00485854642465711, 0.00486585218459368, 0.00487301778048277, 0.00487999618053436, 0.00488673988729715, 0.00489353109151125, 0.00490004057064652, 0.00490650348365307, 0.0049127321690321, 0.00491877365857363, 0.00492490921169519, 0.00493071600794792, 0.00493628950789571, 0.00494190910831094, 0.00494734197854996, 0.00495258718729019, 0.00495769223198295, 0.00496270321309566, 0.0049675265327096, 0.00497211655601859, 0.00497675314545631, 0.00498115504160523, 0.00498546380549669, 0.00498944474384189, 0.00499347224831581, 0.00499731255695224, 0.00500336941331625, 0.00500777177512646, 0.00501189287751913, 0.00501601491123438, 0.00501985475420952, 0.00502369506284595, 0.00502725411206484, 0.00503081316128373, 0.0050343731418252, 0.00503774499520659, 0.00504092965275049, 0.0050439266487956, 0.00504683051258326, 0.00504964077845216, 0.00505235698074102, 0.00505497958511114, 0.00505741452798247, 0.00505975633859634, 0.00506191048771143, 0.00506397150456905, 0.00506603252142668, 0.00506771821528673, 0.00506949797272682, 0.00507118366658688, 0.00507268216460943, 0.00507399346679449, 0.0050752111710608, 0.00507624167948961, 0.00507727218791842, 0.00507811550050974, 0.00507886474952102, 0.00507952040061355, 0.00507989479228854, 0.00508036324754357, 0.00508055044338107, 0.00508064404129982, 0.00508064404129982, 0.00508055044338107, 0.00508036324754357, 0.00507998885586858, 0.00507952040061355, 0.00507886474952102, 0.00507811550050974, 0.00507717812433839, 0.00507614808157086, 0.0050752111710608, 0.00507399346679449, 0.00507258856669068, 0.00507118366658688, 0.00506949797272682, 0.00506771821528673, 0.00506593845784664, 0.00506397150456905, 0.00506200501695275, 0.00505975633859634, 0.00505741452798247, 0.00505497958511114, 0.00505235698074102, 0.00504964077845216, 0.00504673738032579, 0.0050439266487956, 0.00504092965275049, 0.00503765139728785, 0.0050343731418252, 0.00503081316128373, 0.00502734770998359, 0.0050236014649272, 0.00501985475420952, 0.00501601491123438, 0.00501198647543788, 0.00500767817720771, 0.00500336941331625, 0.00500340107828379, 0.0049988585524261, 0.00499417539685965, 0.00498953880742192, 0.00498462095856667, 0.00497956341132522, 0.00497445836663246, 0.00496907252818346, 0.00496373372152448, 0.00495816022157669, 0.00495249358937144, 0.00494687398895621, 0.00494101969525218, 0.00493493117392063, 0.00492879655212164, 0.00492252036929131, 0.00491605745628476, 0.0049095950089395, 0.00490308506414294, 0.00489638792350888, 0.00488945608958602, 0.00488247815519571, 0.00487531302496791, 0.0048681003972888, 0.00486065400764346, 0.00485320761799812, 0.00484576122835279, 0.00483803357928991, 0.00483011873438954, 0.00482211029157043, 0.00481400825083256, 0.00480571901425719, 0.00479747680947185, 0.00478904647752643, 0.00478052301332355, 0.00477181188762188, 0.004762914031744, 0.0047539216466248, 0.00474492972716689, 0.00473556341603398, 0.00472629023715854, 0.00471701752394438, 0.00470736948773265, 0.00469772238284349, 0.00468788715079427, 0.00467791175469756, 0.00466784276068211, 0.00465763313695788, 0.00464747007936239, 0.00463707372546196, 0.00462653627619147, 0.0046158111654222, 0.00460499292239547, 0.00459412764757872, 0.00458302814513445, 0.00457183504477143, 0.00456068897619843, 0.00454921508207917, 0.00453774072229862, 0.00452603260055184, 0.00451427744701505, 0.00450233509764075, 0.00449034571647644, 0.0044783097691834, 0.00446603959426284, 0.00445358175784349, 0.00444112438708544, 0.00442843278869987, 0.00441569415852427, 0.00440276833251119, 0.00438988907262683, 0.00437465496361256, 0.00435713957995176, 0.00433962419629097, 0.00432201474905014, 0.00430449936538935, 0.00428698398172855, 0.00426946859806776, 0.00425204634666443, 0.00423453096300364, 0.00421701557934284, 0.00419950019568205, 0.00418189074844122, 0.00416437536478043, 0.00414685998111963, 0.00412943819537759, 0.00411192281171679, 0.004094407428056, 0.00407689204439521, 0.00405937666073442, 0.00404186081141233, 0.00402425182983279, 0.00400673598051071, 0.00398931466042995, 0.00397179927676916, 0.00395428342744708, 0.00393676804378629, 0.00391925266012549, 0.00390164344571531, 0.00388412806205451, 0.00386670604348183, 0.00384919065982103, 0.0038316750433296, 0.0038141596596688, 0.00379664404317737, 0.00377912865951657, 0.00376151944510639, 0.00374400382861495, 0.00372658204287291, 0.00370906665921211, 0.00369155104272068, 0.00367403565905988, 0.00365652004256845, 0.00363891129381955, 0.00362139567732811, 0.00360397389158607, 0.00358645850792527, 0.00356894289143384, 0.00355142774060369, 0.00353391212411225, 0.00351639627479017, 0.00349878729321063, 0.00348127190954983, 0.00346385012380779, 0.00344633474014699, 0.00342881912365556, 0.00341130373999476, 0.00339378812350333, 0.00337617890909314, 0.00335866352543235, 0.0033412417396903, 0.00332372612319887, 0.00330621073953807, 0.00328869512304664, 0.00327117973938584, 0.00325366412289441, 0.00323605490848422, 0.00321853952482343, 0.00320111773908138, 0.00318360212258995, 0.00316608673892915, 0.00314857112243772, 0.00313105597160757, 0.00311439274810255, 0.00310146692208946, 0.00308854109607637, 0.00307580246590078, 0.00306329829618335, 0.00305079366080463, 0.00303852348588407, 0.00302630010992289, 0.00301412353292108, 0.00300218095071614, 0.00299023883417249, 0.00297853071242571, 0.00296696275472641, 0.00295548839494586, 0.00294415536336601, 0.00293286796659231, 0.00292176869697869, 0.00291066942736506, 0.00289980415254831, 0.00288907927460968, 0.00287844822742045, 0.00286795780993998, 0.00285760732367635, 0.00284739816561341, 0.00283723557367921, 0.00282707251608372, 0.00281723774969578, 0.00280744954943657, 0.00279784901067615, 0.00278829480521381, 0.00277902209199965, 0.00276965531520545, 0.0027603826019913, 0.00275139044970274, 0.00274249212816358, 0.00273368763737381, 0.00272507034242153, 0.00271654687821865, 0.00270811677910388, 0.00269987434148788, 0.0026915380731225, 0.00268348283134401, 0.00267561478540301, 0.00266784057021141, 0.00266006588935852, 0.00265261996537447, 0.00264517357572913, 0.00263767992146313, 0.00263051432557404, 0.00262344256043434, 0.00261651165783405, 0.00260976748540998, 0.00260302354581654, 0.0025964668020606, 0.00258991029113531, 0.00258354120887816, 0.00257735908962786, 0.00257127080112696, 0.00256532290950418, 0.00255946861580014, 0.00255384901538491, 0.00254822918213904, 0.00254251551814377, 0.00253722327761352, 0.00253202486783266, 0.00252687325701118, 0.00252200243994594, 0.00251708505675197, 0.00251240166835487, 0.00250767171382904, 0.00250312872231007, 0.00250092777423561, 0.00249877362512052, 0.00249671284109354, 0.00249474588781595, 0.00249273190274835, 0.00249081198126078, 0.00248903222382069, 0.0024872524663806, 0.0024855665396899, 0.00248397421091795, 0.00248242891393602, 0.00248078955337405, 0.00247938465327024, 0.00247797952033579, 0.00247666821815073, 0.00247545074671507, 0.00247423304244876, 0.00247306213714182, 0.00247203186154366, 0.00247090775519609, 0.0024699242785573, 0.00246908119879663, 0.0024682383518666, 0.00246744230389595, 0.00246678665280342, 0.00246613100171089, 0.00246542831882834, 0.00246491306461394, 0.00246444484218955, 0.00246402341872454, 0.002463742159307, 0.00246346113272011, 0.00246327393688262, 0.00246308650821447, 0.00246289931237698, 0.0024628525134176, 0.00246289931237698, 0.00246294611133635, 0.00246318033896387, 0.00246336753480136, 0.00246360176242888, 0.00246388278901577, 0.00246425741352141, 0.00246472586877644, 0.0024652408901602, 0.002465849975124, 0.00246645882725716, 0.00246720807626843, 0.00246795732527971, 0.00246865977533162, 0.00246959645301104, 0.00247053313069046, 0.00247151660732925, 0.00247259368188679, 0.00247376482002437, 0.00247493549250066, 0.0024761063978076, 0.00247741746716201, 0.00247877556830645, 0.00248022750020027, 0.00248172623105347, 0.00248327176086605, 0.00248491088859737, 0.00248659681528807, 0.00248823594301939, 0.00249006249941885, 0.00249193585477769, 0.00249385600909591, 0.00249586976133287, 0.00249793054535985, 0.00250003789551556, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250218459405005, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250199716538191, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250181765295565, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250219227746129, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250274664722383, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250237947329879, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250200484879315, 0.00250204419717193, 0.00250424537807703, 0.00250630592927337, 0.00250831991434097, 0.00251028686761856, 0.00251220655627549, 0.00251398654654622, 0.00251581287011504, 0.0025175460614264, 0.00251913839019835, 0.00252082431688905, 0.0025223228149116, 0.00252377451397479, 0.00252522644586861, 0.00252649118192494, 0.00252780248411, 0.00252906652167439, 0.00253019039519131, 0.00253131473436952, 0.00253239180892706, 0.0025332816876471, 0.0025342651642859, 0.00253515527583659, 0.00253590452484787, 0.00253665377385914, 0.0025373559910804, 0.00253791781142354, 0.00253852712921798, 0.00253899535164237, 0.00253941654227674, 0.00253979139961302, 0.00254002562724054, 0.00254030665382743, 0.00254049384966493, 0.00254058768041432, 0.00254068127833307, 0.00254072807729244, 0.00254058768041432, 0.00254054088145494, 0.0025403534527868, 0.00254007242619991, 0.00253979139961302, 0.00253941654227674, 0.00253894831985235, 0.00253852712921798, 0.0025379650760442, 0.00253730942495167, 0.00253665377385914, 0.0025359510909766, 0.00253510801121593, 0.0025342651642859, 0.0025332816876471, 0.00253234500996768, 0.00253131473436952, 0.00253019039519131, 0.00252906652167439, 0.00252784881740808, 0.00252649118192494, 0.00252522644586861, 0.00252382131293416, 0.00252227601595223, 0.00252073048613966, 0.0025192319881171, 0.00251749879680574, 0.00251581287011504, 0.00251408014446497, 0.0025121602229774, 0.00251028686761856, 0.0025083664804697, 0.00250630592927337, 0.00250424537807703, 0.00250213779509068, 0.00249488628469408, 0.00249034352600574, 0.00248566013760865, 0.00248083635233343, 0.00247601256705821, 0.00247090775519609, 0.00246580294333398, 0.00246060453355312, 0.00245507806539536, 0.00244959886185825, 0.00244407239370048, 0.00243821833282709, 0.0024323642719537, 0.00242636958137155, 0.00242014089599252, 0.00241400580853224, 0.00240763649344444, 0.00240098615176976, 0.00239452323876321, 0.00238777906633914, 0.00238080113194883, 0.00237382296472788, 0.00236670440062881, 0.00235949223861098, 0.00235209264792502, 0.00234469282440841, 0.00233710603788495, 0.0023293315898627, 0.00232151057571173, 0.00231340830214322, 0.00230544689111412, 0.00229720422066748, 0.00228877435438335, 0.00228043808601797, 0.00227177399210632, 0.00226310989819467, 0.00225435197353363, 0.00224521965719759, 0.00223622773773968, 0.00222704862244427, 0.00221768184565008, 0.00220831530168653, 0.00219876132905483, 0.002189019927755, 0.00217927875928581, 0.0021693033631891, 0.00215923436917365, 0.00214911834336817, 0.00213867449201643, 0.00212832447141409, 0.00211788085289299, 0.00210706237703562, 0.00209633749909699, 0.00208551925607026, 0.00207437295466661, 0.00206327345222235, 0.00205189315602183, 0.00204051285982132, 0.00202908553183079, 0.00201733037829399, 0.00200562202371657, 0.00199377350509167, 0.00198159692808986, 0.00196956074796617, 0.00195738417096436, 0.00194483296945691, 0.00193246908020228, 0.00191977736540139, 0.0019069918198511, 0.00189420662354678, 0.0018811869667843, 0.00187163299415261, 0.00185416429303586, 0.00183660199400038, 0.00181908649392426, 0.00180166459176689, 0.00178400869481266, 0.00176653999369591, 0.00174897769466043, 0.00173150899354368, 0.00171404029242694, 0.00169647787697613, 0.00167891546152532, 0.00166158727370203, 0.00164393137674779, 0.00162636884488165, 0.00160894705913961, 0.0015913846436888, 0.00157386914361268, 0.00155640055891126, 0.00153883814346045, 0.00152136955875903, 0.00150380714330822, 0.00148629164323211, 0.00146868219599128, 0.00145130720920861, 0.00143379170913249, 0.00141618249472231, 0.00139876070898026, 0.00138124520890415, 0.00136363599449396, 0.00134621420875192, 0.00132865190971643, 0.00131108949426562, 0.00129366759210825, 0.00127605837769806, 0.00125854276120663, 0.00124112085904926, 0.00122355856001377, 0.00120608985889703, 0.00118848064448684, 0.00117096514441073, 0.00115354324225336, 0.00113598094321787, 0.00111846544314176, 0.00110104354098439, 0.00108338741119951, 0.00106591871008277, 0.00104849692434072, 0.00103084079455584, 0.00101332529447973, 0.000995903392322361, 0.000978294294327497, 0.000960778677836061, 0.000943356775678694, 0.000925794418435544, 0.000908325775526464, 0.000890810100827366, 0.000873247801791877, 0.000855638645589352, 0.000838263600599021, 0.000820654327981174, 0.000803138827905059, 0.000785670126788318, 0.000768201425671577, 0.00075068580918014, 0.000733170309104025, 0.000715654750820249, 0.000698139192536473, 0.000680623692460358, 0.000663014478050172, 0.000645592517685145, 0.00062807701760903, 0.000620064849499613, 0.000607139023486525, 0.000594260054640472, 0.000581521540880203, 0.000568970339372754, 0.000556466053240001, 0.000544102222193033, 0.000531925703398883, 0.000519749242812395, 0.000507853692397475, 0.000495958200190216, 0.000484203221276402, 0.000472588697448373, 0.000461161514976993, 0.000449781189672649, 0.000438588176621124, 0.000427441991632804, 0.000416389491874725, 0.000405571103328839, 0.000394752772990614, 0.000384121754905209, 0.000373678049072623, 0.000363187515176833, 0.000352977978764102, 0.000342908955644816, 0.000332746276399121, 0.000322958221659064, 0.000313170225126669, 0.000303429027553648, 0.000294015626423061, 0.000284602283500135, 0.000275235739536583, 0.000266150193056092, 0.000257111503742635, 0.000248166441451758, 0.000239361892454326, 0.000230744684813544, 0.000222174305235967, 0.0002136975817848, 0.000205455027753487, 0.000197306129848585, 0.000189250917173922, 0.000181195689947344, 0.000173515130882151, 0.000165834571816958, 0.000158154012751766, 0.000150848107296042, 0.000143448545713909, 0.000136236296384595, 0.000129211402963847, 0.000122233337606303, 0.000115442591777537, 0.000108698681287933, 0.000102095284091774, 9.57260344875976e-05, 8.93099422683008e-05, 8.30343633424491e-05, 7.70397891756147e-05, 7.09983651177026e-05, 6.51911104796454e-05, 5.95243545831181e-05, 5.38107706233859e-05, 4.83313451695722e-05, 4.3039250158472e-05, 3.77939904865343e-05, 3.2642394216964e-05, 2.76781302090967e-05, 2.28543613047805e-05, 1.80774277396267e-05, 1.34409901875188e-05, 8.94505319593009e-06, 9.36650963012653e-07, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.50222532343985e-15, 2.5