// Class: ReadBDTG_fold1
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG_fold1
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:09:50 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 1000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "100" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "False" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 2
x                             x                             x                             x                                                               'F'    [-4.10750675201,4.09692668915]
y                             y                             y                             y                                                               'F'    [-4.85200452805,4.07606744766]
NSpec 1
eventID                       eventID                       eventID                       I                                                               'F'    [1,1000]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTG_fold1Node

#ifndef BDTG_fold1Node__def
#define BDTG_fold1Node__def

class BDTG_fold1Node {

public:

   // constructor of an essentially "empty" node floating in space
   BDTG_fold1Node ( BDTG_fold1Node* left,BDTG_fold1Node* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTG_fold1Node();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTG_fold1Node* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTG_fold1Node* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTG_fold1Node*   fLeft;     // pointer to the left daughter node
   BDTG_fold1Node*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTG_fold1Node::~BDTG_fold1Node()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTG_fold1Node::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTG_fold1Node::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG_fold1 : public IClassifierReader {

 public:

   // constructor
   ReadBDTG_fold1( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG_fold1" ),
        fNvars( 2 )
   {
      // the training input variables
      const char* inputVars[] = { "x", "y" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG_fold1() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[2];
   double fVmax[2];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[2];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTG_fold1Node*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTG_fold1::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTG_fold1Node *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTG_fold1Node*)current->GetRight();
         else current=(BDTG_fold1Node*)current->GetLeft();
      }
      myMVA += current->GetResponse();
   }
   return 2.0/(1.0+exp(-2.0*myMVA))-1.0;
}

void ReadBDTG_fold1::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0978261,-0.0804348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730435,0.046087) , 
0, 0.450256, 1, 0, 0.224348,-0.275652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.937662,0.0875325) , 
0, -1.00961, 1, 0, 0.872941,0.372941) , 
1, 0.249751, 1, 0, 0.5,0)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0685279,-0.0787757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623529,0.0211932) , 
0, 0.342803, 1, 0, 0.167015,-0.303139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241379,-0.0478249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919355,0.0770026) , 
0, -0.669172, 1, 0, 0.806142,0.27871) , 
1, -0.175395, 1, 0, 0.5,4.15102e-06)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0978261,-0.0673839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730435,0.0378889) , 
0, 0.450256, 1, 0, 0.224348,-0.225852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.040635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.937662,0.0735357) , 
0, -1.00961, 1, 0, 0.872941,0.305558) , 
1, 0.249751, 1, 0, 0.5,-3.05149e-06)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0685279,-0.0673585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623529,0.0163134) , 
0, 0.342803, 1, 0, 0.167015,-0.248967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,-0.0266853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.938272,0.0697875) , 
0, -0.328736, 1, 0, 0.806142,0.228927) , 
1, -0.175395, 1, 0, 0.5,1.55565e-05)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14425,-0.0524618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.887097,0.0623636) , 
0, 1.10239, 1, 0, 0.224348,-0.185497) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.056578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924433,0.0627774) , 
0, -1.35004, 1, 0, 0.872941,0.251025) , 
1, 0.249751, 1, 0, 0.5,2.48029e-05)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111842,-0.0551594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753247,0.0392889) , 
1, 0.674897, 1, 0, 0.204503,-0.186206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295455,-0.0382475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.893617,0.0566993) , 
1, -0.880057, 1, 0, 0.837259,0.212712) , 
0, 0.137197, 1, 0, 0.5,8.86252e-05)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985222,-0.0548147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736842,0.0394875) , 
1, 0.979613, 1, 0, 0.153153,-0.202554) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,-0.0152843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.930693,0.0583551) , 
1, -0.291165, 1, 0, 0.776978,0.161896) , 
0, -0.222778, 1, 0, 0.5,8.04301e-05)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0685279,-0.0541395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623529,0.0140393) , 
0, 0.342803, 1, 0, 0.167015,-0.17185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164179,-0.0445668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.900881,0.051121) , 
0, -1.00961, 1, 0, 0.806142,0.158215) , 
1, -0.175395, 1, 0, 0.5,0.000113688)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.0584334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.0164916) , 
0, 0.635523, 1, 0, 0.107438,-0.20013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244898,-0.0275443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.867347,0.0459962) , 
0, -0.528649, 1, 0, 0.723705,0.114156) , 
1, -0.600542, 1, 0, 0.5,7.03176e-05)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199319,-0.0364281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931818,0.0561551) , 
0, 1.12615, 1, 0, 0.294815,-0.0962859) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,-0.00902938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.97651,0.0601868) , 
0, -0.948032, 1, 0, 0.926154,0.199989) , 
1, 0.674897, 1, 0, 0.5,3.52757e-06)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.0540015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.0140576) , 
0, 0.635523, 1, 0, 0.107438,-0.169063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171171,-0.0337675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.840304,0.038959) , 
0, -0.884462, 1, 0, 0.723705,0.0965907) , 
1, -0.600542, 1, 0, 0.5,0.000158482)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169982,-0.0354485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.860656,0.0372517) , 
0, 0.798387, 1, 0, 0.294815,-0.0817874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,-0.00486201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.97651,0.0565654) , 
0, -0.948032, 1, 0, 0.926154,0.17004) , 
1, 0.674897, 1, 0, 0.5,5.65767e-05)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.050079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.0107676) , 
0, 0.635523, 1, 0, 0.107438,-0.142954) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244898,-0.0211785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.867347,0.038089) , 
0, -0.528649, 1, 0, 0.723705,0.0817207) , 
1, -0.600542, 1, 0, 0.5,0.000163651)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199319,-0.0298057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931818,0.0479967) , 
0, 1.12615, 1, 0, 0.294815,-0.0696279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,-0.00229915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.97651,0.0536018) , 
0, -0.948032, 1, 0, 0.926154,0.144895) , 
1, 0.674897, 1, 0, 0.5,9.20132e-05)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.046686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.00905672) , 
0, 0.635523, 1, 0, 0.107438,-0.121296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171171,-0.0265263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.840304,0.0322084) , 
0, -0.884462, 1, 0, 0.723705,0.0694577) , 
1, -0.600542, 1, 0, 0.5,0.000214082)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199319,-0.026886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931818,0.0443063) , 
0, 1.12615, 1, 0, 0.294815,-0.0595544) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.859873,0.0277513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.988095,0.0603187) , 
1, 1.48642, 1, 0, 0.926154,0.124064) , 
1, 0.674897, 1, 0, 0.5,0.00012169)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164835,-0.0291933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906977,0.0472827) , 
1, 1.10004, 1, 0, 0.265823,-0.0606411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461538,-0.0148948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.935673,0.0414678) , 
1, -0.878737, 1, 0, 0.902174,0.10471) , 
0, 0.497173, 1, 0, 0.5,0.000208299)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985222,-0.0344854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736842,0.0287438) , 
1, 0.979613, 1, 0, 0.153153,-0.082246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174603,-0.0338626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853955,0.0307664) , 
1, -1.01904, 1, 0, 0.776978,0.0661226) , 
0, -0.222778, 1, 0, 0.5,0.000246934)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163842,-0.0256425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954545,0.0516974) , 
0, 1.42846, 1, 0, 0.224348,-0.0584503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0388126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924433,0.0372415) , 
0, -1.35004, 1, 0, 0.872941,0.0795464) , 
1, 0.249751, 1, 0, 0.5,0.00019829)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0511485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177419,-0.0158238) , 
1, -1.41424, 1, 0, 0.107438,-0.0846274) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0784314,-0.0427685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779863,0.0228476) , 
0, -1.59609, 1, 0, 0.723705,0.048587) , 
1, -0.600542, 1, 0, 0.5,0.00023017)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.0431502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0116247) , 
0, -1.06724, 1, 0, 0.0693431,-0.0976408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561798,-0.0474505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747253,0.0211081) , 
1, -1.41602, 1, 0, 0.662534,0.0370441) , 
0, -0.942729, 1, 0, 0.5,0.000140425)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22549,-0.020084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.968254,0.0508011) , 
0, 1.45392, 1, 0, 0.294815,-0.0399302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.859873,0.0200231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.988095,0.0566147) , 
1, 1.48642, 1, 0, 0.926154,0.0830671) , 
1, 0.674897, 1, 0, 0.5,4.39212e-05)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164835,-0.0230469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906977,0.0407065) , 
1, 1.10004, 1, 0, 0.265823,-0.040637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.000408882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0437567) , 
1, -0.207307, 1, 0, 0.902174,0.0701289) , 
0, 0.497173, 1, 0, 0.5,0.000124813)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0500027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00873626) , 
0, -1.4123, 1, 0, 0.040201,-0.101061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.0286303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778878,0.0212195) , 
1, -0.83435, 1, 0, 0.614232,0.0253276) , 
0, -1.3027, 1, 0, 0.5,0.00017626)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.0161527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.049951) , 
0, 1.45392, 1, 0, 0.354796,-0.0259402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0315419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0572132) , 
1, 1.67412, 1, 0, 0.962343,0.0829843) , 
1, 1.10004, 1, 0, 0.5,9.27379e-05)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0239521,-0.0483049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140187,-0.0116448) , 
0, -1.42654, 1, 0, 0.0693431,-0.0727097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561798,-0.0431458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747253,0.017787) , 
1, -1.41602, 1, 0, 0.662534,0.027674) , 
0, -0.942729, 1, 0, 0.5,0.000168871)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.0147147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0481955) , 
0, 1.45392, 1, 0, 0.354796,-0.022989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0298637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0565674) , 
1, 1.67412, 1, 0, 0.962343,0.0735577) , 
1, 1.10004, 1, 0, 0.5,8.56504e-05)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0469931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00579409) , 
0, -1.4123, 1, 0, 0.040201,-0.0793339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.0250244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778878,0.0179873) , 
1, -0.83435, 1, 0, 0.614232,0.0199011) , 
0, -1.3027, 1, 0, 0.5,0.000153337)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164835,-0.0178951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906977,0.0354206) , 
1, 1.10004, 1, 0, 0.265823,-0.0277426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00151632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0387399) , 
1, -0.207307, 1, 0, 0.902174,0.0478758) , 
0, 0.497173, 1, 0, 0.5,8.4959e-05)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0454598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00438435) , 
0, -1.4123, 1, 0, 0.040201,-0.0698464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0738255,-0.0303585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73773,0.0148552) , 
1, -1.21207, 1, 0, 0.614232,0.0175047) , 
0, -1.3027, 1, 0, 0.5,0.000121824)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.0127012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0462285) , 
0, 1.45392, 1, 0, 0.354796,-0.0183149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.934959,0.0290852) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.991379,0.056053) , 
1, 1.81541, 1, 0, 0.962343,0.05855) , 
1, 1.10004, 1, 0, 0.5,5.5852e-05)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.0336797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0151391) , 
0, -1.06724, 1, 0, 0.0693431,-0.0506908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561798,-0.0378577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747253,0.0138891) , 
1, -1.41602, 1, 0, 0.662534,0.019283) , 
0, -0.942729, 1, 0, 0.5,0.000110154)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.011574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0446281) , 
0, 1.45392, 1, 0, 0.354796,-0.0163287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0242407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0550884) , 
1, 1.67412, 1, 0, 0.962343,0.0522276) , 
1, 1.10004, 1, 0, 0.5,5.6267e-05)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0431302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-1.55168e-06) , 
0, -1.4123, 1, 0, 0.040201,-0.0561631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.0197122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778878,0.0138263) , 
1, -0.83435, 1, 0, 0.614232,0.0140851) , 
0, -1.3027, 1, 0, 0.5,0.000105671)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.0105566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0431077) , 
0, 1.45392, 1, 0, 0.354796,-0.0145634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.0142418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0459644) , 
1, 1.39154, 1, 0, 0.962343,0.0466131) , 
1, 1.10004, 1, 0, 0.5,5.78047e-05)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0418992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.000401883) , 
0, -1.4123, 1, 0, 0.040201,-0.0504772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016129,-0.0520678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664411,0.00956043) , 
1, -1.96752, 1, 0, 0.614232,0.0126617) , 
0, -1.3027, 1, 0, 0.5,9.70808e-05)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.00963305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0413228) , 
0, 1.45392, 1, 0, 0.354796,-0.0131391) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944444,0.0269717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.989474,0.0549041) , 
1, 1.9567, 1, 0, 0.962343,0.042003) , 
1, 1.10004, 1, 0, 0.5,3.98916e-05)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.040656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.000517135) , 
0, -1.4123, 1, 0, 0.040201,-0.0454924) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0738255,-0.0245791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73773,0.0107537) , 
1, -1.21207, 1, 0, 0.614232,0.0113965) , 
0, -1.3027, 1, 0, 0.5,7.56163e-05)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.00880659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0398056) , 
0, 1.45392, 1, 0, 0.354796,-0.0118197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.0105953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0440792) , 
1, 1.39154, 1, 0, 0.962343,0.0377787) , 
1, 1.10004, 1, 0, 0.5,3.43347e-05)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.02803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.014257) , 
0, -1.06724, 1, 0, 0.0693431,-0.0333892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561798,-0.0330448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747253,0.010236) , 
1, -1.41602, 1, 0, 0.662534,0.012692) , 
0, -0.942729, 1, 0, 0.5,6.57895e-05)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.00804189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0382777) , 
0, 1.45392, 1, 0, 0.354796,-0.0106377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0176735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0532935) , 
1, 1.67412, 1, 0, 0.962343,0.034009) , 
1, 1.10004, 1, 0, 0.5,3.28758e-05)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0386688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00380163) , 
0, -1.4123, 1, 0, 0.040201,-0.0374804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016129,-0.0494726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664411,0.00763191) , 
1, -1.96752, 1, 0, 0.614232,0.00939142) , 
0, -1.3027, 1, 0, 0.5,6.39397e-05)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0716612,-0.0227329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449231,0.00277867) , 
0, -0.823586, 1, 0, 0.265823,-0.0132249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00435257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0300005) , 
1, -0.207307, 1, 0, 0.902174,0.0227736) , 
0, 0.497173, 1, 0, 0.5,2.25486e-05)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0243924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531646,0.001907) , 
1, -0.884476, 1, 0, 0.354796,-0.00943895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00771651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0424304) , 
1, 1.39154, 1, 0, 0.962343,0.0301732) , 
1, 1.10004, 1, 0, 0.5,2.83486e-05)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0364571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0060984) , 
0, -1.4123, 1, 0, 0.040201,-0.0311773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.064817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00596292) , 
1, -2.34525, 1, 0, 0.614232,0.00778086) , 
0, -1.3027, 1, 0, 0.5,2.81805e-05)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273403,-0.00697862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0366685) , 
0, 1.45392, 1, 0, 0.354796,-0.00864056) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00708024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0413496) , 
1, 1.39154, 1, 0, 0.962343,0.0274966) , 
1, 1.10004, 1, 0, 0.5,-3.76702e-06)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0681496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0237664) , 
1, -2.74756, 1, 0, 0.035503,-0.032165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.056338,-0.0196238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70537,0.00653562) , 
0, -1.3027, 1, 0, 0.594464,0.00656593) , 
1, -1.45083, 1, 0, 0.5,2.04048e-05)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295977,-0.00609067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0430083) , 
0, 1.78168, 1, 0, 0.354796,-0.00780628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944444,0.0192071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.989474,0.0527202) , 
1, 1.9567, 1, 0, 0.962343,0.024855) , 
1, 1.10004, 1, 0, 0.5,-2.22141e-07)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0348689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0079153) , 
0, -1.4123, 1, 0, 0.040201,-0.0264808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0649432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00515037) , 
1, -2.34525, 1, 0, 0.614232,0.00660675) , 
0, -1.3027, 1, 0, 0.5,2.23244e-05)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134503,-0.00941572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831933,0.0143724) , 
1, 0.674897, 1, 0, 0.265823,-0.0098091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00378511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0259732) , 
1, -0.207307, 1, 0, 0.902174,0.0168347) , 
0, 0.497173, 1, 0, 0.5,-4.17505e-06)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0677705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0212226) , 
1, -2.74756, 1, 0, 0.035503,-0.0265592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.056338,-0.0170589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70537,0.00547577) , 
0, -1.3027, 1, 0, 0.594464,0.00541196) , 
1, -1.45083, 1, 0, 0.5,8.82995e-06)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295977,-0.00543972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0421442) , 
0, 1.78168, 1, 0, 0.354796,-0.00671153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00284067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0386321) , 
1, 1.39154, 1, 0, 0.962343,0.0213438) , 
1, 1.10004, 1, 0, 0.5,-6.30282e-06)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0329893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0095219) , 
0, -1.4123, 1, 0, 0.040201,-0.0222909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.064505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00441511) , 
1, -2.34525, 1, 0, 0.614232,0.00555368) , 
0, -1.3027, 1, 0, 0.5,1.26057e-05)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0482759,-0.0199226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593407,0.00223974) , 
0, -0.840437, 1, 0, 0.404306,-0.00490494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.945946,0.0387515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0510097) , 
0, 0.117368, 1, 0, 0.987805,0.0249509) , 
1, 1.52519, 1, 0, 0.5,-8.57457e-06)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0718954,-0.0164107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614414,0.00230377) , 
0, -0.824458, 1, 0, 0.421603,-0.00418725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.978022,0.0336341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0508992) , 
1, 1.47127, 1, 0, 0.985611,0.0259139) , 
0, 1.5771, 1, 0, 0.5,-3.1934e-06)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0188919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531646,0.0015997) , 
1, -0.884476, 1, 0, 0.354796,-0.00567452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.010061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0507498) , 
1, 1.67412, 1, 0, 0.962343,0.0180761) , 
1, 1.10004, 1, 0, 0.5,1.87399e-06)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0457654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483311,0.000310906) , 
0, -1.78377, 1, 0, 0.421603,-0.00374925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.978022,0.0323576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0507604) , 
1, 1.47127, 1, 0, 0.985611,0.0232664) , 
0, 1.5771, 1, 0, 0.5,5.91793e-06)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295977,-0.00429862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0386985) , 
0, 1.78168, 1, 0, 0.354796,-0.00511925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00191621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0356488) , 
1, 1.39154, 1, 0, 0.962343,0.0163091) , 
1, 1.10004, 1, 0, 0.5,2.12107e-06)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0707892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0174883) , 
1, -2.74756, 1, 0, 0.035503,-0.0201415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48855,6.14724e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.988636,0.0419103) , 
1, 1.44501, 1, 0, 0.594464,0.00411352) , 
1, -1.45083, 1, 0, 0.5,1.44294e-05)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0302369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0125523) , 
0, -1.4123, 1, 0, 0.040201,-0.0164721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0654403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00350099) , 
1, -2.34525, 1, 0, 0.614232,0.00410978) , 
0, -1.3027, 1, 0, 0.5,1.39865e-05)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0718954,-0.0141547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614414,0.00207398) , 
0, -0.824458, 1, 0, 0.421603,-0.00313012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.978022,0.0301641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0505844) , 
1, 1.47127, 1, 0, 0.985611,0.0193705) , 
0, 1.5771, 1, 0, 0.5,-2.54042e-06)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0393254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.00494987) , 
0, 0.0523864, 1, 0, 0.035503,-0.017169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106195,-0.0101107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671309,0.00363486) , 
1, -0.922934, 1, 0, 0.594464,0.00349276) , 
1, -1.45083, 1, 0, 0.5,9.22414e-07)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295977,-0.00367937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0370213) , 
0, 1.78168, 1, 0, 0.354796,-0.00424759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944099,0.0128773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0615946) , 
1, 2.09799, 1, 0, 0.962343,0.0134773) , 
1, 1.10004, 1, 0, 0.5,-1.13379e-05)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0720476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0141915) , 
1, -2.74756, 1, 0, 0.035503,-0.0155328) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48855,-0.000111601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.988636,0.0396017) , 
1, 1.44501, 1, 0, 0.594464,0.00316237) , 
1, -1.45083, 1, 0, 0.5,2.88036e-06)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0284821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.013381) , 
0, -1.4123, 1, 0, 0.040201,-0.0138663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0660258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00298588) , 
1, -2.34525, 1, 0, 0.614232,0.00344943) , 
0, -1.3027, 1, 0, 0.5,3.61307e-06)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0436853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483311,0.00043213) , 
0, -1.78377, 1, 0, 0.421603,-0.00261134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.972973,0.0112471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.990196,0.0387054) , 
0, 1.81761, 1, 0, 0.985611,0.0161095) , 
0, 1.5771, 1, 0, 0.5,-9.13538e-06)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0145766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531646,0.00122782) , 
1, -0.884476, 1, 0, 0.354796,-0.00364247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,-9.02354e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0316607) , 
1, 1.39154, 1, 0, 0.962343,0.0115508) , 
1, 1.10004, 1, 0, 0.5,-1.12771e-05)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338688,-0.00270652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.981481,0.0423015) , 
1, 1.95034, 1, 0, 0.382022,-0.0029348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.851852,-0.0149039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994186,0.0397181) , 
1, -0.207307, 1, 0, 0.974874,0.0117624) , 
0, 1.21712, 1, 0, 0.5,-1.00596e-05)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0264571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0121218) , 
0, -1.4123, 1, 0, 0.040201,-0.0116971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0657781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00259696) , 
1, -2.34525, 1, 0, 0.614232,0.00291218) , 
0, -1.3027, 1, 0, 0.5,4.92813e-06)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0420868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483311,0.000343764) , 
0, -1.78377, 1, 0, 0.421603,-0.00230172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.978022,0.0268128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0503723) , 
1, 1.47127, 1, 0, 0.985611,0.0142158) , 
0, 1.5771, 1, 0, 0.5,-5.79265e-06)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295977,-0.00289248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0352181) , 
0, 1.78168, 1, 0, 0.354796,-0.00318233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,-0.000631365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0301942) , 
1, 1.39154, 1, 0, 0.962343,0.0100995) , 
1, 1.10004, 1, 0, 0.5,-7.98342e-06)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0709101) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434731,-0.000895148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0370334) , 
0, 1.5771, 1, 0, 0.513875,0.000891095) , 
1, -2.72627, 1, 0, 0.5,-5.83197e-07)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0129007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531646,0.00122621) , 
1, -0.884476, 1, 0, 0.354796,-0.0028125) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,-0.000927353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0278672) , 
1, 1.39154, 1, 0, 0.962343,0.0089665) , 
1, 1.10004, 1, 0, 0.5,2.67842e-06)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0514593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,0.00423541) , 
1, -0.579652, 1, 0, 0.040201,-0.0100313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0651305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00224345) , 
1, -2.34525, 1, 0, 0.614232,0.00249471) , 
0, -1.3027, 1, 0, 0.5,2.03626e-06)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346053,-0.00228666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.986842,0.036324) , 
0, 1.78168, 1, 0, 0.404306,-0.00201705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.945946,0.0214372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0504549) , 
0, 0.117368, 1, 0, 0.987805,0.0101997) , 
1, 1.52519, 1, 0, 0.5,-1.35092e-05)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0244767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.013116) , 
0, -1.4123, 1, 0, 0.040201,-0.00917993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0653091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64146,0.00206101) , 
1, -2.34525, 1, 0, 0.614232,0.00227682) , 
0, -1.3027, 1, 0, 0.5,-3.07001e-06)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295977,-0.00225753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0335615) , 
0, 1.78168, 1, 0, 0.354796,-0.00239163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944099,0.00704784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0611677) , 
1, 2.09799, 1, 0, 0.962343,0.00757107) , 
1, 1.10004, 1, 0, 0.5,-1.05471e-05)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0513389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,0.00429456) , 
1, -0.579652, 1, 0, 0.040201,-0.00853494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191729,0.00585623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824299,-0.00120176) , 
1, -0.456626, 1, 0, 0.614232,0.00211802) , 
0, -1.3027, 1, 0, 0.5,-1.92049e-06)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0692511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434731,-0.000708208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0336534) , 
0, 1.5771, 1, 0, 0.513875,0.000677914) , 
1, -2.72627, 1, 0, 0.5,-1.24517e-05)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0342701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.0125184) , 
0, 0.0523864, 1, 0, 0.035503,-0.00863216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.0108734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637549,0.00177673) , 
1, -1.18604, 1, 0, 0.594464,0.00174463) , 
1, -1.45083, 1, 0, 0.5,-9.04869e-06)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346053,-0.00186944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.986842,0.0334336) , 
0, 1.78168, 1, 0, 0.404306,-0.00169026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.975,0.00594273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.991935,0.0390157) , 
1, 1.76941, 1, 0, 0.987805,0.00852332) , 
1, 1.52519, 1, 0, 0.5,-1.52302e-05)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0696969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0414508,-0.0114464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630769,0.00163657) , 
0, -1.3027, 1, 0, 0.513875,0.000632727) , 
1, -2.72627, 1, 0, 0.5,-7.98618e-06)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0102978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531646,0.000981099) , 
1, -0.884476, 1, 0, 0.354796,-0.00196303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,-0.00237402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0227546) , 
1, 1.39154, 1, 0, 0.962343,0.00620633) , 
1, 1.10004, 1, 0, 0.5,-1.05523e-05)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0230529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0153487) , 
0, -1.4123, 1, 0, 0.040201,-0.00724626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191729,0.00606174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824299,-0.00158794) , 
1, -0.456626, 1, 0, 0.614232,0.00178798) , 
0, -1.3027, 1, 0, 0.5,-9.83208e-06)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0678873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375839,-0.000882388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.964912,0.0170908) , 
1, 1.16271, 1, 0, 0.513875,0.000560708) , 
1, -2.72627, 1, 0, 0.5,-1.30707e-05)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.022061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0133873) , 
0, -1.4123, 1, 0, 0.040201,-0.00689536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191729,0.0056336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824299,-0.00145353) , 
1, -0.456626, 1, 0, 0.614232,0.00169734) , 
0, -1.3027, 1, 0, 0.5,-1.26098e-05)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.051242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,0.00282318) , 
0, -0.308761, 1, 0, 0.029703,-0.00969673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0784314,0.0181972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613551,-0.00047686) , 
1, -1.30835, 1, 0, 0.552836,0.00107271) , 
1, -1.87598, 1, 0, 0.5,-1.50062e-05)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346053,-0.00168341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.986842,0.0337586) , 
0, 1.78168, 1, 0, 0.404306,-0.00145473) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.975,0.00381616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.991935,0.0369406) , 
1, 1.76941, 1, 0, 0.987805,0.00728964) , 
1, 1.52519, 1, 0, 0.5,-2.06518e-05)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0321193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.0110483) , 
0, 0.0523864, 1, 0, 0.035503,-0.00710559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.010492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637549,0.00155175) , 
1, -1.18604, 1, 0, 0.594464,0.00142865) , 
1, -1.45083, 1, 0, 0.5,-1.36353e-05)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0686404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434731,-0.000528654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0296174) , 
0, 1.5771, 1, 0, 0.513875,0.000516951) , 
1, -2.72627, 1, 0, 0.5,-1.79373e-05)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0208218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0126959) , 
0, -1.4123, 1, 0, 0.040201,-0.00614426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191729,0.00522298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824299,-0.00139802) , 
1, -0.456626, 1, 0, 0.614232,0.00150789) , 
0, -1.3027, 1, 0, 0.5,-1.48883e-05)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.00996226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531646,0.00101963) , 
1, -0.884476, 1, 0, 0.354796,-0.00171773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,-0.00313598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0217646) , 
1, 1.39154, 1, 0, 0.962343,0.00540026) , 
1, 1.10004, 1, 0, 0.5,-1.65269e-05)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0200205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0113919) , 
0, -1.4123, 1, 0, 0.040201,-0.00583948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191729,0.00512603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824299,-0.0014163) , 
1, -0.456626, 1, 0, 0.614232,0.00143161) , 
0, -1.3027, 1, 0, 0.5,-1.53333e-05)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134855,0.00143596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734767,-0.00402738) , 
0, 0.142858, 1, 0, 0.354796,-0.00165727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944099,0.00451378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.060974) , 
1, 2.09799, 1, 0, 0.962343,0.00520751) , 
1, 1.10004, 1, 0, 0.5,-1.65884e-05)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0667543) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275862,-0.00124386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.912088,0.00412857) , 
0, 0.497173, 1, 0, 0.513875,0.000468897) , 
1, -2.72627, 1, 0, 0.5,-1.11466e-05)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0512464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,0.00512366) , 
1, -0.579652, 1, 0, 0.040201,-0.00550832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323204,0.00347346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854214,-0.0024769) , 
0, 0.240462, 1, 0, 0.614232,0.00135418) , 
0, -1.3027, 1, 0, 0.5,-1.14556e-05)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0839506,0.00352819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590308,-0.00617372) , 
1, -0.175395, 1, 0, 0.265823,-0.00203813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00714448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0146322) , 
1, -0.207307, 1, 0, 0.902174,0.00345145) , 
0, 0.497173, 1, 0, 0.5,-1.79654e-05)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346053,-0.00141745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.986842,0.033453) , 
0, 1.78168, 1, 0, 0.404306,-0.00116013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.975,0.00196906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.991935,0.0335732) , 
1, 1.76941, 1, 0, 0.987805,0.00583505) , 
1, 1.52519, 1, 0, 0.5,-1.2917e-05)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0659775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375839,-0.000657642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.964912,0.0140329) , 
1, 1.16271, 1, 0, 0.513875,0.000434925) , 
1, -2.72627, 1, 0, 0.5,-7.71734e-06)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.019522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0113214) , 
0, -1.4123, 1, 0, 0.040201,-0.00532212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191729,0.00486206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824299,-0.00140677) , 
1, -0.456626, 1, 0, 0.614232,0.00131246) , 
0, -1.3027, 1, 0, 0.5,-7.8223e-06)    );
   return;
};

// Clean up
inline void ReadBDTG_fold1::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTG_fold1::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
