// Class: ReadBDTG_fold2
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG_fold2
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:09:50 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 998
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "100" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "False" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 2
x                             x                             x                             x                                                               'F'    [-4.10750675201,4.09692668915]
y                             y                             y                             y                                                               'F'    [-4.85200452805,4.07606744766]
NSpec 1
eventID                       eventID                       eventID                       I                                                               'F'    [1,1000]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTG_fold2Node

#ifndef BDTG_fold2Node__def
#define BDTG_fold2Node__def

class BDTG_fold2Node {

public:

   // constructor of an essentially "empty" node floating in space
   BDTG_fold2Node ( BDTG_fold2Node* left,BDTG_fold2Node* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTG_fold2Node();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTG_fold2Node* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTG_fold2Node* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTG_fold2Node*   fLeft;     // pointer to the left daughter node
   BDTG_fold2Node*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTG_fold2Node::~BDTG_fold2Node()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTG_fold2Node::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTG_fold2Node::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG_fold2 : public IClassifierReader {

 public:

   // constructor
   ReadBDTG_fold2( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG_fold2" ),
        fNvars( 2 )
   {
      // the training input variables
      const char* inputVars[] = { "x", "y" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG_fold2() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[2];
   double fVmax[2];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[2];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTG_fold2Node*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTG_fold2::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTG_fold2Node *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTG_fold2Node*)current->GetRight();
         else current=(BDTG_fold2Node*)current->GetLeft();
      }
      myMVA += current->GetResponse();
   }
   return 2.0/(1.0+exp(-2.0*myMVA))-1.0;
}

void ReadBDTG_fold2::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0416667,-0.0916667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0) , 
1, 0.210646, 1, 0, 0.130252,-0.369748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0382979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.953271,0.0906542) , 
1, -0.491026, 1, 0, 0.837165,0.337165) , 
0, -0.130818, 1, 0, 0.5,0)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623501,-0.0797258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610169,0.0220339) , 
1, 0.520028, 1, 0, 0.130252,-0.332876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0345205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.953271,0.0822861) , 
1, -0.491026, 1, 0, 0.837165,0.303548) , 
0, -0.130818, 1, 0, 0.5,2.96793e-06)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0416667,-0.076909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0014446) , 
1, 0.210646, 1, 0, 0.130252,-0.299891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0311937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.953271,0.0757517) , 
1, -0.491026, 1, 0, 0.837165,0.273509) , 
0, -0.130818, 1, 0, 0.5,2.3519e-05)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691244,-0.0683501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623077,0.0185248) , 
1, 0.221947, 1, 0, 0.196809,-0.227535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423729,-0.00494347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.968,0.0736019) , 
1, -0.491026, 1, 0, 0.894009,0.295774) , 
0, 0.230699, 1, 0, 0.5,3.59012e-05)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0766401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,-0.0484152) , 
0, -1.18567, 1, 0, 0.0719794,-0.298278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0482981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902196,0.0614845) , 
1, -0.733781, 1, 0, 0.773399,0.190626) , 
0, -0.492335, 1, 0, 0.5,6.106e-05)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.034384,-0.0664252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0169402) , 
1, 0.464914, 1, 0, 0.0719794,-0.269013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0443831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902196,0.057265) , 
1, -0.733781, 1, 0, 0.773399,0.171885) , 
0, -0.492335, 1, 0, 0.5,3.20345e-05)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691244,-0.0584245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623077,0.015276) , 
1, 0.221947, 1, 0, 0.196809,-0.173237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423729,-0.000322377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.968,0.0629681) , 
1, -0.491026, 1, 0, 0.894009,0.225086) , 
0, 0.230699, 1, 0, 0.5,-1.83727e-05)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0678464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,-0.0379784) , 
0, -1.18567, 1, 0, 0.0719794,-0.223992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0384977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902196,0.0514872) , 
1, -0.733781, 1, 0, 0.773399,0.143096) , 
0, -0.492335, 1, 0, 0.5,1.27325e-05)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691244,-0.053445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623077,0.013849) , 
1, 0.221947, 1, 0, 0.196809,-0.144121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82963,0.0335801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0731539) , 
0, 1.47334, 1, 0, 0.894009,0.187244) , 
0, 0.230699, 1, 0, 0.5,-2.0439e-05)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623501,-0.0515901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610169,0.015986) , 
1, 0.520028, 1, 0, 0.130252,-0.156628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0184621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.953271,0.0532186) , 
1, -0.491026, 1, 0, 0.837165,0.14275) , 
0, -0.130818, 1, 0, 0.5,-3.9474e-05)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0626021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,-0.0303006) , 
0, -1.18567, 1, 0, 0.0719794,-0.171203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0332737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902196,0.045144) , 
1, -0.733781, 1, 0, 0.773399,0.109344) , 
0, -0.492335, 1, 0, 0.5,-7.61049e-06)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11349,-0.0454508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0988582) , 
0, 1.47472, 1, 0, 0.160243,-0.127557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191781,-0.0348548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.939815,0.0503756) , 
0, -0.624038, 1, 0, 0.831683,0.124444) , 
1, -0.0417414, 1, 0, 0.5,-4.15556e-05)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102725,-0.0411598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712644,0.0208435) , 
1, 0.560482, 1, 0, 0.196809,-0.100827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82963,0.0255901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0676387) , 
0, 1.47334, 1, 0, 0.894009,0.131062) , 
0, 0.230699, 1, 0, 0.5,1.42246e-05)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11349,-0.0414218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0874484) , 
0, 1.47472, 1, 0, 0.160243,-0.10763) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12,-0.0469968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90989,0.0438282) , 
0, -0.966404, 1, 0, 0.831683,0.105146) , 
1, -0.0417414, 1, 0, 0.5,3.73729e-05)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0573144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,-0.0226351) , 
0, -1.18567, 1, 0, 0.0719794,-0.122043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0274546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902196,0.0385274) , 
1, -0.733781, 1, 0, 0.773399,0.0780461) , 
0, -0.492335, 1, 0, 0.5,5.54409e-05)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165121,-0.0332984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0791714) , 
0, 1.47472, 1, 0, 0.216028,-0.0770525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.032405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963061,0.0488353) , 
0, -0.624038, 1, 0, 0.884434,0.104344) , 
1, 0.304278, 1, 0, 0.5,1.39145e-05)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623377,-0.0447345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.065326) , 
0, 1.12583, 1, 0, 0.112195,-0.0991275) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.0429574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874755,0.035677) , 
0, -0.966404, 1, 0, 0.770408,0.0693135) , 
1, -0.387761, 1, 0, 0.5,0.000114324)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0514139,-0.0416511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52,0.00392095) , 
1, -0.116588, 1, 0, 0.196809,-0.0671492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82963,0.0196769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0621364) , 
0, 1.47334, 1, 0, 0.894009,0.0873823) , 
0, 0.230699, 1, 0, 0.5,5.18367e-05)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0533348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,-0.0163989) , 
0, -1.18567, 1, 0, 0.0719794,-0.0877354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0229438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902196,0.0327585) , 
1, -0.733781, 1, 0, 0.773399,0.0561148) , 
0, -0.492335, 1, 0, 0.5,4.48946e-05)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165121,-0.0283281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0718359) , 
0, 1.47472, 1, 0, 0.216028,-0.0563793) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0261021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963061,0.0436612) , 
0, -0.624038, 1, 0, 0.884434,0.0763361) , 
1, 0.304278, 1, 0, 0.5,4.79505e-06)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623377,-0.0393426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0550203) , 
0, 1.12583, 1, 0, 0.112195,-0.0726989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.036236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874755,0.0302825) , 
0, -0.966404, 1, 0, 0.770408,0.0508387) , 
1, -0.387761, 1, 0, 0.5,8.67855e-05)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0977778,-0.0304501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692308,0.0317222) , 
1, 1.13879, 1, 0, 0.130252,-0.0585125) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207547,-0.0180479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.908316,0.030385) , 
1, -1.14572, 1, 0, 0.837165,0.053434) , 
0, -0.130818, 1, 0, 0.5,4.06911e-05)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623377,-0.03673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0504832) , 
0, 1.12583, 1, 0, 0.112195,-0.0621938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.0330927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874755,0.02757) , 
0, -0.966404, 1, 0, 0.770408,0.0434314) , 
1, -0.387761, 1, 0, 0.5,3.83091e-05)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21911,-0.020837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0639766) , 
0, 1.47472, 1, 0, 0.275229,-0.0352337) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.879227,0.0176565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0608959) , 
1, 1.69496, 1, 0, 0.927326,0.0669927) , 
1, 0.650298, 1, 0, 0.5,2.69923e-06)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0113208,-0.0484386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361204,-0.00157824) , 
1, -0.793658, 1, 0, 0.196809,-0.0397854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82963,0.0129923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0581719) , 
0, 1.47334, 1, 0, 0.894009,0.0518814) , 
0, 0.230699, 1, 0, 0.5,7.7744e-05)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0206186,-0.0431996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.00563135) , 
0, 0.428049, 1, 0, 0.0646154,-0.0602563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0306382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.829225,0.0213183) , 
0, -0.966404, 1, 0, 0.710253,0.029182) , 
1, -0.733781, 1, 0, 0.5,5.63061e-05)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256569,-0.0170165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.961538,0.0423171) , 
0, 1.31525, 1, 0, 0.332414,-0.0246479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.89313,0.0214887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992958,0.0555991) , 
1, 1.65988, 1, 0, 0.945055,0.0654258) , 
1, 0.996317, 1, 0, 0.5,-8.48795e-06)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0471876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,-0.00688694) , 
0, -1.18567, 1, 0, 0.0719794,-0.046088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0606061,-0.0443722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814236,0.0183095) , 
1, -1.77184, 1, 0, 0.773399,0.0295251) , 
0, -0.492335, 1, 0, 0.5,5.26881e-05)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280832,-0.0144194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0588392) , 
0, 1.67677, 1, 0, 0.332414,-0.0215704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902597,0.0216148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0588437) , 
1, 1.79142, 1, 0, 0.945055,0.0572737) , 
1, 0.996317, 1, 0, 0.5,-2.8555e-06)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0206186,-0.0402723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.004084) , 
0, 0.428049, 1, 0, 0.0646154,-0.0484224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207921,-0.00973403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.92569,0.0251143) , 
0, -0.281672, 1, 0, 0.710253,0.0234713) , 
1, -0.733781, 1, 0, 0.5,5.90272e-05)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165121,-0.0181194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0608511) , 
0, 1.47472, 1, 0, 0.216028,-0.0264045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0195612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963061,0.0330007) , 
0, -0.624038, 1, 0, 0.884434,0.035819) , 
1, 0.304278, 1, 0, 0.5,3.11167e-05)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0206186,-0.0382294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.00320672) , 
0, 0.428049, 1, 0, 0.0646154,-0.041889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.0349535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802365,0.0158244) , 
0, -1.30877, 1, 0, 0.710253,0.0203359) , 
1, -0.733781, 1, 0, 0.5,7.22492e-05)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0413249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0593305) , 
0, -1.35424, 1, 0, 0.0133929,-0.0501897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.017809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811966,0.0155203) , 
1, -0.733781, 1, 0, 0.640827,0.0145495) , 
0, -1.21537, 1, 0, 0.5,1.88693e-05)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280832,-0.0120341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0574247) , 
0, 1.67677, 1, 0, 0.332414,-0.0160015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902597,0.0164835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0584265) , 
1, 1.79142, 1, 0, 0.945055,0.0424234) , 
1, 0.996317, 1, 0, 0.5,-1.95615e-05)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0804598,-0.0228091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701342,0.00738447) , 
1, -0.116588, 1, 0, 0.332879,-0.0145495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.861111,0.0353246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.978166,0.0317423) , 
1, -0.19392, 1, 0, 0.962264,0.0403624) , 
0, 0.953734, 1, 0, 0.5,3.12922e-05)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.039435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0589346) , 
0, -1.35424, 1, 0, 0.0133929,-0.0432192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0425709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690909,0.0104865) , 
1, -1.77184, 1, 0, 0.640827,0.0125494) , 
0, -1.21537, 1, 0, 0.5,3.22106e-05)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10262,-0.0182704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75942,0.00679118) , 
0, -0.130818, 1, 0, 0.384807,-0.0108623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878788,0.0325175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.993827,0.0449281) , 
0, 0.231515, 1, 0, 0.974359,0.0446616) , 
1, 1.34234, 1, 0, 0.5,-1.34265e-05)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0375024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0578455) , 
0, -1.35424, 1, 0, 0.0133929,-0.0374042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0407925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690909,0.00933886) , 
1, -1.77184, 1, 0, 0.640827,0.0108303) , 
0, -1.21537, 1, 0, 0.5,4.09618e-06)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274218,-0.0105038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.967742,0.0453966) , 
1, 1.57609, 1, 0, 0.332879,-0.0118557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.861111,0.0321164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.978166,0.0283001) , 
1, -0.19392, 1, 0, 0.962264,0.0326701) , 
0, 0.953734, 1, 0, 0.5,-3.27029e-05)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623377,-0.0218396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0311163) , 
0, 1.12583, 1, 0, 0.112195,-0.022424) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.0166091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874755,0.0137285) , 
0, -0.966404, 1, 0, 0.770408,0.0156283) , 
1, -0.387761, 1, 0, 0.5,-4.42458e-06)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280832,-0.00915944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0553104) , 
0, 1.67677, 1, 0, 0.332414,-0.0108726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902597,0.0111955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0575462) , 
1, 1.79142, 1, 0, 0.945055,0.0288296) , 
1, 0.996317, 1, 0, 0.5,-1.21568e-05)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0555916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792453,-0.0152309) , 
1, -2.05366, 1, 0, 0.0646154,-0.0243649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.00442943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950119,0.0208164) , 
0, 0.0606942, 1, 0, 0.710253,0.0118033) , 
1, -0.733781, 1, 0, 0.5,2.50738e-05)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0343272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0569334) , 
0, -1.35424, 1, 0, 0.0133929,-0.0297833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544262,7.78682e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0554621) , 
0, 1.4735, 1, 0, 0.640827,0.0086445) , 
0, -1.21537, 1, 0, 0.5,1.94299e-05)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0551795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792453,-0.0141978) , 
1, -2.05366, 1, 0, 0.0646154,-0.0217551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.00339351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950119,0.0187393) , 
0, 0.0606942, 1, 0, 0.710253,0.0105442) , 
1, -0.733781, 1, 0, 0.5,2.58459e-05)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318182,-0.00741313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977444,0.0338793) , 
0, 1.31525, 1, 0, 0.420256,-0.00583915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0456163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0514554) , 
0, 0.28608, 1, 0, 0.992806,0.0362214) , 
1, 1.68836, 1, 0, 0.5,1.89779e-05)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0321406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0561917) , 
0, -1.35424, 1, 0, 0.0133929,-0.0255435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0360512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690909,0.00711925) , 
1, -1.77184, 1, 0, 0.640827,0.00745082) , 
0, -1.21537, 1, 0, 0.5,4.52797e-05)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322359,-0.00659711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0536294) , 
0, 1.67677, 1, 0, 0.384807,-0.00638232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878788,0.0241892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.993827,0.0398534) , 
0, 0.231515, 1, 0, 0.974359,0.026371) , 
1, 1.34234, 1, 0, 0.5,1.73759e-05)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0206186,-0.0273787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.00481847) , 
0, 0.428049, 1, 0, 0.0646154,-0.0180082) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654867,0.00223001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0576146) , 
1, 1.83911, 1, 0, 0.710253,0.00875745) , 
1, -0.733781, 1, 0, 0.5,4.11914e-05)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0174419,-0.0271366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0541693) , 
0, -1.4919, 1, 0, 0.0133929,-0.0220438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544262,-7.66383e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0551033) , 
0, 1.4735, 1, 0, 0.640827,0.00642965) , 
0, -1.21537, 1, 0, 0.5,3.88178e-05)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0547339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792453,-0.0112879) , 
1, -2.05366, 1, 0, 0.0646154,-0.0161674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.00233722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950119,0.0149971) , 
0, 0.0606942, 1, 0, 0.710253,0.0078697) , 
1, -0.733781, 1, 0, 0.5,4.19866e-05)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348168,-0.00522882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0526765) , 
0, 1.67677, 1, 0, 0.420256,-0.00423542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0397928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0510572) , 
0, 0.28608, 1, 0, 0.992806,0.0264086) , 
1, 1.68836, 1, 0, 0.5,3.26354e-05)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0512115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00256544) , 
1, 0.21655, 1, 0, 0.0133929,-0.0190472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0320939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690909,0.00564861) , 
1, -1.77184, 1, 0, 0.640827,0.00558286) , 
0, -1.21537, 1, 0, 0.5,5.46644e-05)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0623377,-0.0138508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0227251) , 
0, 1.12583, 1, 0, 0.112195,-0.011319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712153,0.00191822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0566867) , 
1, 1.78923, 1, 0, 0.770408,0.00793382) , 
1, -0.387761, 1, 0, 0.5,2.43407e-05)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0510796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00210114) , 
1, 0.21655, 1, 0, 0.0133929,-0.0169536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544262,-0.000165603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0548651) , 
0, 1.4735, 1, 0, 0.640827,0.00494841) , 
0, -1.21537, 1, 0, 0.5,3.25295e-05)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00858369,-0.0346025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206522,0.000373085) , 
0, -0.269729, 1, 0, 0.0646154,-0.012236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654867,0.00143736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0567819) , 
1, 1.83911, 1, 0, 0.710253,0.00595191) , 
1, -0.733781, 1, 0, 0.5,2.89937e-05)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.023988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0555253) , 
0, -1.35424, 1, 0, 0.0133929,-0.0147823) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0302662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690909,0.0046386) , 
1, -1.77184, 1, 0, 0.640827,0.00431065) , 
0, -1.21537, 1, 0, 0.5,2.52648e-05)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348168,-0.00404636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0520432) , 
0, 1.67677, 1, 0, 0.420256,-0.00304418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0329705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0508018) , 
0, 0.28608, 1, 0, 0.992806,0.0188879) , 
1, 1.68836, 1, 0, 0.5,1.04898e-05)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0541584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792453,-0.00743035) , 
1, -2.05366, 1, 0, 0.0646154,-0.0103848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.00211603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950119,0.011297) , 
0, 0.0606942, 1, 0, 0.710253,0.00505685) , 
1, -0.733781, 1, 0, 0.5,2.8267e-05)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0508917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.0055369) , 
1, 0.21655, 1, 0, 0.0133929,-0.0128269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544262,-0.000397035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0548587) , 
0, 1.4735, 1, 0, 0.640827,0.00373906) , 
0, -1.21537, 1, 0, 0.5,2.0861e-05)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348168,-0.00347115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0516996) , 
0, 1.67677, 1, 0, 0.420256,-0.00265898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0310762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0507054) , 
0, 0.28608, 1, 0, 0.992806,0.0165671) , 
1, 1.68836, 1, 0, 0.5,1.87974e-05)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00858369,-0.0315088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206522,0.00112244) , 
0, -0.269729, 1, 0, 0.0646154,-0.00910717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654867,0.00106642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0561451) , 
1, 1.83911, 1, 0, 0.710253,0.00444644) , 
1, -0.733781, 1, 0, 0.5,3.26903e-05)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.050788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00519768) , 
1, 0.21655, 1, 0, 0.0133929,-0.0110563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0266659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690909,0.00364859) , 
1, -1.77184, 1, 0, 0.640827,0.00323762) , 
0, -1.21537, 1, 0, 0.5,2.93573e-05)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348168,-0.00297677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0515253) , 
0, 1.67677, 1, 0, 0.420256,-0.00216128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0267725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0506001) , 
0, 0.28608, 1, 0, 0.992806,0.0134348) , 
1, 1.68836, 1, 0, 0.5,1.09271e-05)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0507079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00495817) , 
1, 0.21655, 1, 0, 0.0133929,-0.00987978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,-0.00301523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878205,0.00809284) , 
0, 0.132933, 1, 0, 0.640827,0.00288922) , 
0, -1.21537, 1, 0, 0.5,2.32345e-05)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.053896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792453,-0.00508172) , 
1, -2.05366, 1, 0, 0.0646154,-0.00733523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654867,0.00078202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0556397) , 
1, 1.83911, 1, 0, 0.710253,0.00355751) , 
1, -0.733781, 1, 0, 0.5,1.02753e-05)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0174419,-0.0122004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0543121) , 
0, -1.4919, 1, 0, 0.0133929,-0.00883318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544262,-0.000560935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0549759) , 
0, 1.4735, 1, 0, 0.640827,0.0025702) , 
0, -1.21537, 1, 0, 0.5,1.07242e-05)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0682493,-0.0126817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315068,0.00864753) , 
1, -0.69136, 1, 0, 0.112195,-0.00563546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547414,0.00594806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.91573,-0.00113071) , 
1, 0.604081, 1, 0, 0.770408,0.00395576) , 
1, -0.387761, 1, 0, 0.5,1.54798e-05)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015873,-0.0197134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0350588) , 
1, -2.02438, 1, 0, 0.0192308,-0.0128664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0528339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584706,0.00209281) , 
0, -2.14632, 1, 0, 0.555928,0.00150916) , 
1, -1.77184, 1, 0, 0.5,1.1109e-05)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348168,-0.00243976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0512691) , 
0, 1.67677, 1, 0, 0.420256,-0.00172716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0229048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.05051) , 
0, 0.28608, 1, 0, 0.992806,0.010695) , 
1, 1.68836, 1, 0, 0.5,2.9786e-06)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0502808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0543051) , 
0, -1.25421, 1, 0, 0,-0.0171618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415465,-0.00107979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994536,0.0372396) , 
0, 1.37285, 1, 0, 0.527484,0.000957442) , 
1, -2.11786, 1, 0, 0.5,1.3351e-05)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0505983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00761745) , 
1, 0.21655, 1, 0, 0.0133929,-0.00733458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139785,0.0120204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709251,-0.000141074) , 
0, -0.760779, 1, 0, 0.640827,0.00214108) , 
0, -1.21537, 1, 0, 0.5,1.42756e-05)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396825,-0.000409125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.023597) , 
1, 1.43312, 1, 0, 0.420256,-0.00152614) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,0.00194447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0555605) , 
1, 1.88734, 1, 0, 0.992806,0.00944509) , 
1, 1.68836, 1, 0, 0.5,1.91529e-06)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0682493,-0.0110382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315068,0.00803182) , 
1, -0.69136, 1, 0, 0.112195,-0.00442038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547414,0.00550101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.91573,-0.00211344) , 
1, 0.604081, 1, 0, 0.770408,0.00309656) , 
1, -0.387761, 1, 0, 0.5,8.43889e-06)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280832,-0.00236537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0514896) , 
0, 1.67677, 1, 0, 0.332414,-0.00218635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791045,-0.00605271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.995146,0.0362644) , 
0, 0.292796, 1, 0, 0.945055,0.00582668) , 
1, 0.996317, 1, 0, 0.5,5.58704e-06)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0502233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0538244) , 
0, -1.25421, 1, 0, 0,-0.0149359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415465,-0.000917073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994536,0.0353258) , 
0, 1.37285, 1, 0, 0.527484,0.000837763) , 
1, -2.11786, 1, 0, 0.5,1.58886e-05)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0505406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00738794) , 
1, 0.21655, 1, 0, 0.0133929,-0.00637149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139785,0.011022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709251,-0.00022413) , 
0, -0.760779, 1, 0, 0.640827,0.00186443) , 
0, -1.21537, 1, 0, 0.5,1.58838e-05)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396825,-0.000300163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0218924) , 
1, 1.43312, 1, 0, 0.420256,-0.00131731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,0.000574224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0552284) , 
1, 1.88734, 1, 0, 0.992806,0.00817402) , 
1, 1.68836, 1, 0, 0.5,4.62478e-06)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015873,-0.0118184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0335671) , 
1, -2.02438, 1, 0, 0.0192308,-0.00917782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0527892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584706,0.00161493) , 
0, -2.14632, 1, 0, 0.555928,0.00107889) , 
1, -1.77184, 1, 0, 0.5,1.00497e-05)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0501782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.053403) , 
0, -1.25421, 1, 0, 0,-0.0130523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0945946,-0.00393945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805556,0.00326553) , 
0, -0.386733, 1, 0, 0.527484,0.00072143) , 
1, -2.11786, 1, 0, 0.5,3.76048e-06)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132411,0.000659919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00524684) , 
0, 0.230699, 1, 0, 0.332414,-0.0018206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791045,-0.00568391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.995146,0.0345639) , 
0, 0.292796, 1, 0, 0.945055,0.00483556) , 
1, 0.996317, 1, 0, 0.5,1.73589e-07)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396825,-0.000222482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0202183) , 
1, 1.43312, 1, 0, 0.420256,-0.00114952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,-0.000343033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0550083) , 
1, 1.88734, 1, 0, 0.992806,0.00715428) , 
1, 1.68836, 1, 0, 0.5,7.01963e-06)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0504753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00823788) , 
1, 0.21655, 1, 0, 0.0133929,-0.00518336) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,-0.00278307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878205,0.00607336) , 
0, 0.132933, 1, 0, 0.640827,0.00151493) , 
0, -1.21537, 1, 0, 0.5,1.15094e-05)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0501458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0531065) , 
0, -1.25421, 1, 0, 0,-0.011646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415465,-0.000870267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994536,0.0333325) , 
0, 1.37285, 1, 0, 0.527484,0.000643597) , 
1, -2.11786, 1, 0, 0.5,3.25728e-06)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396825,-0.000184015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0183538) , 
1, 1.43312, 1, 0, 0.420256,-0.0010284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,-0.000713491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0546674) , 
1, 1.88734, 1, 0, 0.992806,0.00638645) , 
1, 1.68836, 1, 0, 0.5,4.32714e-06)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0682493,-0.00919932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315068,0.00766375) , 
1, -0.69136, 1, 0, 0.112195,-0.0030532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547414,0.0053144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.91573,-0.00374979) , 
1, 0.604081, 1, 0, 0.770408,0.0021434) , 
1, -0.387761, 1, 0, 0.5,8.52523e-06)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132411,0.000983039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00544761) , 
0, 0.230699, 1, 0, 0.332414,-0.0016181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791045,-0.00465061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.995146,0.032859) , 
0, 0.292796, 1, 0, 0.945055,0.00432093) , 
1, 0.996317, 1, 0, 0.5,6.50522e-06)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102273,-0.005688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757009,0.00311931) , 
0, -0.252917, 1, 0, 0.425115,-0.000964871) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0515093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0502696) , 
1, 0.232057, 1, 0, 1,0.0065312) , 
0, 1.67677, 1, 0, 0.5,1.1571e-05)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309353,0.00062076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87037,-0.0123317) , 
1, 0.877037, 1, 0, 0.384807,-0.00118048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92,0.0140665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.993103,0.00559358) , 
0, 0.473204, 1, 0, 0.974359,0.00493285) , 
1, 1.34234, 1, 0, 0.5,1.40067e-05)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0501284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0527705) , 
0, -1.25421, 1, 0, 0,-0.0103172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.05245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556299,0.0011362) , 
0, -2.14632, 1, 0, 0.527484,0.00058204) , 
1, -2.11786, 1, 0, 0.5,1.41451e-05)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132411,0.001135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00538471) , 
0, 0.230699, 1, 0, 0.332414,-0.00146235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864865,-0.0028944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.051191) , 
0, 0.808974, 1, 0, 0.945055,0.00390948) , 
1, 0.996317, 1, 0, 0.5,7.10161e-06)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102273,-0.00517492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757009,0.00287661) , 
0, -0.252917, 1, 0, 0.425115,-0.000839583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0513728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0502269) , 
1, 0.232057, 1, 0, 1,0.00571157) , 
0, 1.67677, 1, 0, 0.5,1.37727e-05)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0501152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0525064) , 
0, -1.25421, 1, 0, 0,-0.009297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121813,-0.00346724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768971,0.00231176) , 
1, -0.431239, 1, 0, 0.527484,0.000527468) , 
1, -2.11786, 1, 0, 0.5,1.55715e-05)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0504205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00961403) , 
1, 0.21655, 1, 0, 0.0133929,-0.00391565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139785,0.011298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709251,-0.000878207) , 
0, -0.760779, 1, 0, 0.640827,0.00114822) , 
0, -1.21537, 1, 0, 0.5,1.16425e-05)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396825,1.28395e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0196754) , 
1, 1.43312, 1, 0, 0.420256,-0.000822149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,-0.00375727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0544221) , 
1, 1.88734, 1, 0, 0.992806,0.0051011) , 
1, 1.68836, 1, 0, 0.5,2.83196e-06)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132411,0.00125171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00507695) , 
0, 0.230699, 1, 0, 0.332414,-0.00122532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902439,0.0143528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.952586,0.00131475) , 
1, 1.13373, 1, 0, 0.945055,0.00327836) , 
1, 0.996317, 1, 0, 0.5,6.6463e-06)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102273,-0.00505618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757009,0.00286756) , 
0, -0.252917, 1, 0, 0.425115,-0.000771343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0512643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0502076) , 
1, 0.232057, 1, 0, 1,0.00520186) , 
0, 1.67677, 1, 0, 0.5,6.72975e-06)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0500935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0522584) , 
0, -1.25421, 1, 0, 0,-0.00829846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0523631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556299,0.0009584) , 
0, -2.14632, 1, 0, 0.527484,0.000465592) , 
1, -2.11786, 1, 0, 0.5,8.94811e-06)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309353,0.000882343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87037,-0.0125942) , 
1, 0.877037, 1, 0, 0.384807,-0.000912817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92,0.012967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.993103,-0.000937459) , 
0, 0.473204, 1, 0, 0.974359,0.00377592) , 
1, 1.34234, 1, 0, 0.5,3.31926e-06)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132411,0.00131237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00501717) , 
0, 0.230699, 1, 0, 0.332414,-0.00114881) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902439,0.0144157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.952586,0.00086382) , 
1, 1.13373, 1, 0, 0.945055,0.00306687) , 
1, 0.996317, 1, 0, 0.5,4.37881e-06)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102273,-0.00476513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757009,0.00271865) , 
0, -0.252917, 1, 0, 0.425115,-0.000703731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0511492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.050189) , 
1, 0.232057, 1, 0, 1,0.00473464) , 
0, 1.67677, 1, 0, 0.5,4.67415e-06)    );
   return;
};

// Clean up
inline void ReadBDTG_fold2::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTG_fold2::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
