// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.34/01       [401921]
Creator        : sftnight
Date           : Fri Dec 13 04:09:00 2024
Host           : Linux root-ubuntu-2004-3 5.4.0-156-generic #173-Ubuntu SMP Tue Jul 11 07:25:22 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /home/sftnight/build/workspace/root-makedoc-v634/rootspi/rdoc/v634_TMP/notebooks
Training events: 6000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "300" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
MinNodeSize: "5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "False" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-5.89911937714,4.76391029358]
var2                          var2                          var2                          var2                                                            'F'    [-5.24535989761,4.65081644058]
var3                          var3                          var3                          var3                                                            'F'    [-5.3562874794,4.64297914505]
var4                          var4                          var4                          var4                                                            'F'    [-6.9675450325,4.96000480652]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.636239061809955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142857,-99) , 
0, 1.96162, 1, 0, 0.62313,-99) , 
NN(
0, 
0, 
-1, -2.10031, 0, -1, 0.0642965,-99) , 
3, -1.28776, 0, 0, 0.5,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.375717);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318726,-99) , 
0, 1.14795, 1, 0, 0.51657,-99) , 
NN(
0, 
0, 
-1, -2.831, 0, -1, 0.0342652,-99) , 
3, -1.85574, 0, 0, 0.442366,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.322003);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22467,-99) , 
1, 1.9093, 1, 0, 0.514353,-99) , 
NN(
0, 
0, 
-1, -2.2074, 0, -1, 0.16033,-99) , 
3, -0.719781, 0, 0, 0.420866,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.21527);
  fForest.push_back( 
NN(
0, 
0, 
-1, -1.85574, 0, -1, 0.393997,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.135499);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198394,-99) , 
0, 2.44582, 1, 0, 0.487166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0211628,-99) , 
3, -2.42372, 0, 0, 0.446389,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.157406);
  fForest.push_back( 
NN(
0, 
0, 
-1, -1.85574, 0, -1, 0.42194,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.190304);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400374,-99) , 
3, 0.0380077, 0, 0, 0.496999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.028162,-99) , 
3, -2.42372, 0, 0, 0.460729,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.103532);
  fForest.push_back( 
NN(
0, 
0, 
-1, -2.42372, 0, -1, 0.448418,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.140263);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233218,-99) , 
0, 2.44582, 1, 0, 0.506317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0374212,-99) , 
3, -2.42372, 0, 0, 0.47414,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.193842);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432942,-99) , 
0, -0.258627, 1, 0, 0.475686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0428147,-99) , 
3, -2.42372, 0, 0, 0.447631,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.133201);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319202,-99) , 
2, 2.21188, 1, 0, 0.502511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12296,-99) , 
3, -1.85574, 0, 0, 0.469007,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.114856);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368248,-99) , 
3, -0.313563, 0, 0, 0.470316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0584106,-99) , 
3, -2.42372, 0, 0, 0.446792,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.17164);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438541,-99) , 
0, -1.03133, 1, 0, 0.455301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0650573,-99) , 
3, -2.42372, 0, 0, 0.434003,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.134267);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423867,-99) , 
3, 0.0929057, 0, 0, 0.494229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155256,-99) , 
3, -1.85574, 0, 0, 0.467489,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.1717);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420846,-99) , 
0, 0.424758, 1, 0, 0.482047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17369,-99) , 
3, -1.85574, 0, 0, 0.458637,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.14174);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430551,-99) , 
3, 0.741852, 0, 0, 0.484028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199728,-99) , 
3, -1.85574, 0, 0, 0.46335,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.155981);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561643,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437339,-99) , 
1, 0.0690471, 1, 0, 0.48334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223349,-99) , 
3, -1.85574, 0, 0, 0.465051,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.123503);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482411,-99) , 
0, -0.432714, 1, 0, 0.508657,-99) , 
NN(
0, 
0, 
-1, -1.90989, 0, -1, 0.350037,-99) , 
3, -0.719781, 0, 0, 0.476912,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.115987);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0447361, 1, 1, 0.542218,-99) , 
NN(
0, 
0, 
-1, -2.10021, 0, -1, 0.406032,-99) , 
3, -0.151802, 0, 0, 0.501385,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.0720715);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488216,-99) , 
0, -1.02163, 1, 0, 0.503017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299268,-99) , 
3, -1.85574, 0, 0, 0.489721,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.0964357);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35874,-99) , 
1, 2.18371, 1, 0, 0.517827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314597,-99) , 
3, -1.85574, 0, 0, 0.504722,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.1446);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441425,-99) , 
1, 1.20097, 1, 0, 0.540297,-99) , 
NN(
0, 
0, 
-1, 0.337066, 1, -1, 0.448049,-99) , 
3, 0.984155, 0, 0, 0.486993,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.101415);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473392,-99) , 
0, 0.424758, 1, 0, 0.517276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368728,-99) , 
3, -1.85574, 0, 0, 0.507953,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.109173);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.499129, 1, 1, 0.55068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3579,-99) , 
0, -0.271127, 1, 0, 0.459844,-99) , 
3, 0.416176, 0, 0, 0.510707,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.0870836);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488851,-99) , 
1, -0.489528, 1, 0, 0.512139,-99) , 
NN(
0, 
0, 
-1, -1.2016, 1, -1, 0.408487,-99) , 
3, -0.719781, 0, 0, 0.49177,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.0736247);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.146839, 1, 1, 0.528578,-99) , 
NN(
0, 
0, 
-1, -1.2016, 1, -1, 0.429684,-99) , 
3, -0.719781, 0, 0, 0.509226,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.135893);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453523,-99) , 
0, 1.36207, 1, 0, 0.536587,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390166,-99) , 
1, 0.000484569, 1, 0, 0.46967,-99) , 
3, 0.984155, 0, 0, 0.498023,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.0987456);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495947,-99) , 
0, 0.499129, 1, 0, 0.530389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385942,-99) , 
0, -0.646327, 1, 0, 0.448054,-99) , 
3, 0.416176, 0, 0, 0.49415,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.0933665);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0447361, 1, 1, 0.534752,-99) , 
NN(
0, 
0, 
-1, -1.12675, 0, -1, 0.425912,-99) , 
3, -0.151802, 0, 0, 0.502114,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.0957239);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471232,-99) , 
2, 1.6032, 1, 0, 0.553587,-99) , 
NN(
0, 
0, 
-1, 0.945862, 1, -1, 0.468118,-99) , 
3, 1.55213, 0, 0, 0.492747,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.0483922);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.635841, 1, 1, 0.518732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396106,-99) , 
3, -1.85574, 0, 0, 0.51089,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.06767);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482071,-99) , 
1, 1.24878, 1, 0, 0.54582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35576,-99) , 
2, 0.945862, 1, 0, 0.482071,-99) , 
3, 1.55213, 0, 0, 0.500342,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.0856334);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490542,-99) , 
2, 1.06972, 1, 0, 0.535423,-99) , 
NN(
0, 
0, 
-1, 0.337066, 1, -1, 0.461436,-99) , 
3, 0.984155, 0, 0, 0.492614,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.104818);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49139,-99) , 
2, 1.85651, 1, 0, 0.564705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428277,-99) , 
0, 0.147658, 1, 0, 0.485766,-99) , 
3, 1.55213, 0, 0, 0.508386,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.095335);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393662,-99) , 
0, 2.46038, 1, 0, 0.588428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404218,-99) , 
3, -0.909157, 0, 0, 0.484833,-99) , 
3, 2.12011, 0, 0, 0.504103,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.0936887);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416633,-99) , 
0, 2.46038, 1, 0, 0.578772,-99) , 
NN(
0, 
0, 
-1, 0.751418, 1, -1, 0.470899,-99) , 
3, 2.12011, 0, 0, 0.490774,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.0896986);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439566,-99) , 
0, 2.46038, 1, 0, 0.569056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419688,-99) , 
1, 0.751418, 1, 0, 0.494289,-99) , 
3, 2.12011, 0, 0, 0.507963,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.0818845);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.499129, 1, 1, 0.527235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402385,-99) , 
0, -0.646327, 1, 0, 0.45788,-99) , 
3, 0.416176, 0, 0, 0.496359,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.126444);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435885,-99) , 
3, -0.989242, 0, 0, 0.531915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417987,-99) , 
3, 1.09293, 0, 0, 0.47003,-99) , 
1, -0.532895, 1, 0, 0.485175,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.10133);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465169,-99) , 
3, 0.254568, 0, 0, 0.505168,-99) , 
NN(
0, 
0, 
-1, 1.85761, 0, -1, 0.431227,-99) , 
0, 1.20957, 1, 0, 0.485211,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.0957497);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.562221, 0, 1, 0.557261,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449591,-99) , 
3, 1.86635, 0, 0, 0.473519,-99) , 
1, -0.532895, 1, 0, 0.493994,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.0903501);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479729,-99) , 
3, -0.221659, 0, 0, 0.521242,-99) , 
NN(
0, 
0, 
-1, 2.29193, 0, -1, 0.440329,-99) , 
1, 0.880844, 1, 0, 0.495552,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.111301);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361709,-99) , 
3, -2.01501, 0, 0, 0.560439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438496,-99) , 
3, 1.19329, 0, 0, 0.473694,-99) , 
0, -0.313723, 1, 0, 0.500241,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.109122);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474951,-99) , 
3, -0.45455, 0, 0, 0.530393,-99) , 
NN(
0, 
0, 
-1, 1.96112, 0, -1, 0.440268,-99) , 
0, 0.701804, 1, 0, 0.493706,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.108445);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495918,-99) , 
3, -0.414767, 0, 0, 0.544807,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42715,-99) , 
3, 2.18523, 0, 0, 0.461179,-99) , 
2, 0.357579, 1, 0, 0.501717,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.105417);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440511,-99) , 
3, -2.01501, 0, 0, 0.571152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515811,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448981,-99) , 
1, 0.538541, 1, 0, 0.478417,-99) , 
0, -0.313723, 1, 0, 0.506735,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.0769645);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.62463,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478464,-99) , 
1, -1.06177, 1, 0, 0.488913,-99) , 
0, -1.32925, 1, 0, 0.503601,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.0842219);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.606418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456222,-99) , 
3, 0.274342, 0, 0, 0.504543,-99) , 
0, -1.32925, 1, 0, 0.515496,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.089324);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430883,-99) , 
3, -2.01501, 0, 0, 0.556923,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439068,-99) , 
3, 0.850866, 0, 0, 0.485587,-99) , 
0, -0.313723, 1, 0, 0.507224,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.0733302);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.950041, 0, 1, 0.528098,-99) , 
NN(
0, 
0, 
-1, 1.77178, 0, -1, 0.449512,-99) , 
2, 0.833735, 1, 0, 0.498258,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.0727301);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496086,-99) , 
3, -0.989242, 0, 0, 0.54683,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453016,-99) , 
0, 0.514071, 1, 0, 0.476834,-99) , 
1, -0.532895, 1, 0, 0.493833,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.0505905);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49678,-99) , 
3, -1.59212, 0, 0, 0.573233,-99) , 
NN(
0, 
0, 
-1, -0.393079, 0, -1, 0.483434,-99) , 
2, -1.07089, 1, 0, 0.496465,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.0744271);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.75997, 0, 1, 0.574528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446502,-99) , 
3, 0.340622, 0, 0, 0.495552,-99) , 
1, -1.00414, 1, 0, 0.50735,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.0782725);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.989242, 0, 1, 0.550232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462301,-99) , 
3, 1.86635, 0, 0, 0.482785,-99) , 
1, -0.532895, 1, 0, 0.499108,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.0541322);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.21752, 0, 1, 0.518813,-99) , 
NN(
0, 
0, 
-1, 2.3349, 0, -1, 0.451165,-99) , 
0, 1.20957, 1, 0, 0.500275,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.0583188);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482146,-99) , 
3, 1.31691, 0, 0, 0.499904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400457,-99) , 
1, 2.29458, 1, 0, 0.494152,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.0679142);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486015,-99) , 
0, 0.0581004, 1, 0, 0.51419,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379546,-99) , 
3, 2.32354, 0, 0, 0.448088,-99) , 
1, 1.35209, 1, 0, 0.500415,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.0763873);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47606,-99) , 
3, 0.0581948, 0, 0, 0.512108,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353982,-99) , 
3, 2.84281, 0, 0, 0.433022,-99) , 
2, 1.78605, 1, 0, 0.500338,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.0604586);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495066,-99) , 
0, -0.438335, 1, 0, 0.514277,-99) , 
NN(
0, 
0, 
-1, 2.32354, 0, -1, 0.434186,-99) , 
1, 1.35209, 1, 0, 0.497588,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.0801343);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450918,-99) , 
3, -1.0828, 0, 0, 0.519217,-99) , 
NN(
0, 
0, 
-1, 2.32354, 0, -1, 0.449094,-99) , 
1, 1.35209, 1, 0, 0.504637,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.038362);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.572655,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415956,-99) , 
3, -0.577596, 0, 0, 0.489873,-99) , 
0, -1.32925, 1, 0, 0.498719,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.0564188);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480546,-99) , 
3, -1.59212, 0, 0, 0.557361,-99) , 
NN(
0, 
0, 
-1, -0.393079, 0, -1, 0.480246,-99) , 
2, -1.07089, 1, 0, 0.491457,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.0340176);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.574218,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398012,-99) , 
3, -1.00357, 0, 0, 0.495167,-99) , 
0, -1.32925, 1, 0, 0.503609,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.06431);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473464,-99) , 
3, -1.67235, 0, 0, 0.548451,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455262,-99) , 
3, 0.829749, 0, 0, 0.484728,-99) , 
0, -0.821486, 1, 0, 0.49622,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.0783024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484519,-99) , 
3, -0.414767, 0, 0, 0.526545,-99) , 
NN(
0, 
0, 
-1, 1.3528, 0, -1, 0.463978,-99) , 
2, 0.357579, 1, 0, 0.493987,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.0471156);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495801,-99) , 
2, -1.88907, 0, 0, 0.58109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418257,-99) , 
3, -0.393079, 0, 0, 0.491326,-99) , 
2, -1.07089, 1, 0, 0.504397,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.0717505);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59212, 0, 1, 0.578532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475321,-99) , 
0, -1.03133, 1, 0, 0.482689,-99) , 
2, -1.07089, 1, 0, 0.496605,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.0806993);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451058,-99) , 
3, -2.03804, 0, 0, 0.540401,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458165,-99) , 
3, 1.47964, 0, 0, 0.48783,-99) , 
1, -0.0616485, 1, 0, 0.507179,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.0660054);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495832,-99) , 
3, 0.254568, 0, 0, 0.522292,-99) , 
NN(
0, 
0, 
-1, 2.3349, 0, -1, 0.451213,-99) , 
0, 1.20957, 1, 0, 0.502622,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.073147);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.593987,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472092,-99) , 
0, 0.411733, 1, 0, 0.498217,-99) , 
0, -1.32925, 1, 0, 0.508457,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.0420772);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.576232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404594,-99) , 
3, -1.00357, 0, 0, 0.500511,-99) , 
0, -1.32925, 1, 0, 0.508573,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.0523627);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.565926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466345,-99) , 
3, 0.700312, 0, 0, 0.491525,-99) , 
0, -1.32925, 1, 0, 0.499428,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.0583373);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491725,-99) , 
3, -0.419239, 0, 0, 0.531165,-99) , 
NN(
0, 
0, 
-1, 0.102889, 0, -1, 0.477852,-99) , 
2, -0.118576, 1, 0, 0.49673,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.0595363);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.35938, 0, 1, 0.567599,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481464,-99) , 
0, -0.0153896, 1, 0, 0.497178,-99) , 
1, -1.00414, 1, 0, 0.507685,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.0564409);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.35938, 0, 1, 0.552933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451952,-99) , 
3, -0.0793224, 0, 0, 0.503106,-99) , 
1, -1.00414, 1, 0, 0.510523,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.078338);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475542,-99) , 
3, -0.89982, 0, 0, 0.519601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455597,-99) , 
3, 2.33349, 0, 0, 0.481998,-99) , 
1, 0.409598, 1, 0, 0.501606,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.0364567);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59212, 0, 1, 0.559303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426451,-99) , 
3, -0.393079, 0, 0, 0.491697,-99) , 
2, -1.07089, 1, 0, 0.501513,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.055612);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48788,-99) , 
3, -1.67235, 0, 0, 0.549103,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45548,-99) , 
3, 0.829749, 0, 0, 0.482528,-99) , 
0, -0.821486, 1, 0, 0.494466,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.0500126);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497391,-99) , 
2, -1.28724, 1, 0, 0.509929,-99) , 
NN(
0, 
0, 
-1, 1.85761, 0, -1, 0.447351,-99) , 
0, 1.20957, 1, 0, 0.492454,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.0411032);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.06555, 0, 1, 0.513239,-99) , 
NN(
0, 
0, 
-1, 2.84281, 0, -1, 0.438621,-99) , 
2, 1.78605, 1, 0, 0.501922,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.0429537);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49704,-99) , 
3, 1.21752, 0, 0, 0.508779,-99) , 
NN(
0, 
0, 
-1, 1.85761, 0, -1, 0.458506,-99) , 
0, 1.20957, 1, 0, 0.49476,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.051503);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.950041, 0, 1, 0.520678,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422671,-99) , 
3, 1.77178, 0, 0, 0.474504,-99) , 
2, 0.833735, 1, 0, 0.502937,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.0561365);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460491,-99) , 
0, 1.05097, 1, 0, 0.502064,-99) , 
NN(
0, 
0, 
-1, 2.26652, 1, -1, 0.431657,-99) , 
1, 1.82334, 1, 0, 0.49385,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.0585875);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476594,-99) , 
3, 1.31691, 0, 0, 0.493764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422231,-99) , 
1, 2.29458, 1, 0, 0.489555,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.0458286);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495671,-99) , 
3, 1.90459, 0, 0, 0.504806,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387996,-99) , 
3, 2.97956, 0, 0, 0.449508,-99) , 
0, 1.71733, 1, 0, 0.495742,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.0488621);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.23504, 0, 1, 0.51799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398495,-99) , 
3, 2.26711, 0, 0, 0.460892,-99) , 
2, 1.30989, 1, 0, 0.503608,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.0444024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559755,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494041,-99) , 
0, -1.18445, 1, 0, 0.504145,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392111,-99) , 
3, 2.97956, 0, 0, 0.44153,-99) , 
0, 1.71733, 1, 0, 0.493891,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.0603807);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447662,-99) , 
0, 1.45424, 1, 0, 0.508462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417568,-99) , 
2, 2.2622, 1, 0, 0.500544,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.0502946);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485391,-99) , 
3, 1.31691, 0, 0, 0.499205,-99) , 
NN(
0, 
0, 
-1, 2.26652, 1, -1, 0.441022,-99) , 
1, 1.82334, 1, 0, 0.492466,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.0302567);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.06555, 0, 1, 0.507781,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386168,-99) , 
3, 2.84281, 0, 0, 0.450605,-99) , 
2, 1.78605, 1, 0, 0.499153,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.051521);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473625,-99) , 
0, 0.473793, 1, 0, 0.498487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431144,-99) , 
2, 2.2622, 1, 0, 0.492647,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.0455259);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487104,-99) , 
3, 2.1098, 0, 0, 0.496913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443822,-99) , 
2, 2.2622, 1, 0, 0.492319,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.0350656);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499125,-99) , 
3, 1.90459, 0, 0, 0.508364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417441,-99) , 
3, 2.97956, 0, 0, 0.464319,-99) , 
0, 1.71733, 1, 0, 0.501183,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.0502718);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495693,-99) , 
3, 0.522134, 0, 0, 0.517319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422822,-99) , 
3, 2.32354, 0, 0, 0.468938,-99) , 
1, 1.35209, 1, 0, 0.507216,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.0535181);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495864,-99) , 
1, 0.321836, 1, 0, 0.519063,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416279,-99) , 
3, 2.97956, 0, 0, 0.454264,-99) , 
0, 1.71733, 1, 0, 0.508498,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.0434364);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.90459, 0, 1, 0.517309,-99) , 
NN(
0, 
0, 
-1, 2.44336, 1, -1, 0.455702,-99) , 
0, 1.71733, 1, 0, 0.507276,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.0363855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494535,-99) , 
3, 1.57584, 0, 0, 0.505657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439834,-99) , 
2, 2.2622, 1, 0, 0.499955,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.0553239);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472481,-99) , 
3, -0.945482, 0, 0, 0.513773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4052,-99) , 
3, 2.84281, 0, 0, 0.458174,-99) , 
2, 1.78605, 1, 0, 0.505431,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.0418859);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498814,-99) , 
3, -0.855793, 0, 0, 0.532331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431188,-99) , 
3, 0.214585, 0, 0, 0.487198,-99) , 
2, -0.594732, 1, 0, 0.498101,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.0790647);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448647,-99) , 
0, -0.580886, 1, 0, 0.53175,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468906,-99) , 
2, -0.414397, 1, 0, 0.478307,-99) , 
0, -0.313723, 1, 0, 0.494411,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.0263108);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.90459, 0, 1, 0.508827,-99) , 
NN(
0, 
0, 
-1, 2.44336, 1, -1, 0.464653,-99) , 
0, 1.71733, 1, 0, 0.501623,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.0519466);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47854,-99) , 
3, 0.212315, 0, 0, 0.502398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40847,-99) , 
3, 3.0401, 0, 0, 0.45715,-99) , 
1, 1.82334, 1, 0, 0.49719,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.0452146);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470043,-99) , 
2, -1.82569, 0, 0, 0.531234,-99) , 
NN(
0, 
0, 
-1, 2.44582, 1, -1, 0.484797,-99) , 
1, -0.532895, 1, 0, 0.496084,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.0539075);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466592,-99) , 
3, -1.6023, 0, 0, 0.528245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448315,-99) , 
3, 0.508438, 0, 0, 0.49243,-99) , 
0, -0.313723, 1, 0, 0.503213,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.0396921);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.18464, 1, 1, 0.51411,-99) , 
NN(
0, 
0, 
-1, 1.14325, 0, -1, 0.472017,-99) , 
0, 0.701804, 1, 0, 0.496738,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.0329532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490206,-99) , 
3, -1.59212, 0, 0, 0.534001,-99) , 
NN(
0, 
0, 
-1, -0.393079, 0, -1, 0.48832,-99) , 
2, -1.07089, 1, 0, 0.495002,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.0319765);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499645,-99) , 
2, -1.59318, 0, 0, 0.547462,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442449,-99) , 
3, -0.577596, 0, 0, 0.496648,-99) , 
0, -1.32925, 1, 0, 0.502114,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.0459371);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.35938, 0, 1, 0.541288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483626,-99) , 
0, -1.21021, 1, 0, 0.48913,-99) , 
1, -1.00414, 1, 0, 0.496935,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.0218867);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499402,-99) , 
3, 2.1098, 0, 0, 0.507491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463764,-99) , 
2, 2.2622, 1, 0, 0.503702,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.0280411);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.10836, 0, 1, 0.512063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465919,-99) , 
0, 2.22509, 1, 0, 0.507967,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.0428977);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491657,-99) , 
3, -1.59212, 0, 0, 0.530977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42178,-99) , 
3, -0.393079, 0, 0, 0.497284,-99) , 
2, -1.07089, 1, 0, 0.502203,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.0470885);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.543006,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474827,-99) , 
1, 0.162358, 1, 0, 0.489906,-99) , 
0, -1.32925, 1, 0, 0.495605,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.03444);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488612,-99) , 
1, 1.24878, 1, 0, 0.51697,-99) , 
NN(
0, 
0, 
-1, 0.953895, 1, -1, 0.488614,-99) , 
3, 1.55213, 0, 0, 0.496887,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.0322595);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.539866,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447822,-99) , 
3, -0.577596, 0, 0, 0.49929,-99) , 
0, -1.32925, 1, 0, 0.503648,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.0217902);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537407,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428165,-99) , 
3, -0.840604, 0, 0, 0.493418,-99) , 
2, -1.54704, 1, 0, 0.497511,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.0603254);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452054,-99) , 
0, -0.580886, 1, 0, 0.513751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467259,-99) , 
3, 1.87815, 0, 0, 0.484242,-99) , 
0, -0.313723, 1, 0, 0.493077,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.0520087);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482422,-99) , 
3, 0.254568, 0, 0, 0.504201,-99) , 
NN(
0, 
0, 
-1, 2.56365, 1, -1, 0.468088,-99) , 
0, 1.20957, 1, 0, 0.49415,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.0560624);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485375,-99) , 
3, -0.414767, 0, 0, 0.516658,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443931,-99) , 
3, 1.3528, 0, 0, 0.482481,-99) , 
2, 0.357579, 1, 0, 0.498788,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.0546002);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441031,-99) , 
2, 0.992331, 1, 0, 0.50928,-99) , 
NN(
0, 
0, 
-1, 2.26711, 0, -1, 0.461203,-99) , 
2, 1.30989, 1, 0, 0.497169,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.048423);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49375,-99) , 
3, -1.35938, 0, 0, 0.528936,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469675,-99) , 
0, 0.382885, 1, 0, 0.486471,-99) , 
1, -1.00414, 1, 0, 0.49283,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.0492343);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497117,-99) , 
3, -1.75997, 0, 0, 0.53041,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460135,-99) , 
3, 0.760565, 0, 0, 0.488586,-99) , 
1, -1.00414, 1, 0, 0.494846,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.0358486);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491287,-99) , 
2, -1.88907, 0, 0, 0.534301,-99) , 
NN(
0, 
0, 
-1, -0.0107157, 0, -1, 0.486053,-99) , 
2, -1.07089, 1, 0, 0.493114,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.0251685);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435058,-99) , 
3, -0.840604, 0, 0, 0.49565,-99) , 
2, -1.54704, 1, 0, 0.500471,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.0272318);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59318, 0, 1, 0.54167,-99) , 
NN(
0, 
0, 
-1, 2.56606, 1, -1, 0.489769,-99) , 
0, -1.32925, 1, 0, 0.495351,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.0229401);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442075,-99) , 
3, -0.840604, 0, 0, 0.496727,-99) , 
2, -1.54704, 1, 0, 0.500695,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.0425679);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45779,-99) , 
3, -2.01501, 0, 0, 0.516487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457956,-99) , 
3, 0.850866, 0, 0, 0.487284,-99) , 
0, -0.313723, 1, 0, 0.496025,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.0439217);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466896,-99) , 
0, 0.981287, 1, 0, 0.50318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445226,-99) , 
2, 1.36421, 1, 0, 0.467765,-99) , 
1, 0.880844, 1, 0, 0.491762,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.0502083);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488358,-99) , 
2, -1.11957, 1, 0, 0.510263,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467467,-99) , 
3, 1.86635, 0, 0, 0.48088,-99) , 
1, -0.532895, 1, 0, 0.487975,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.0367778);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495001,-99) , 
3, 1.33508, 0, 0, 0.503104,-99) , 
NN(
0, 
0, 
-1, 1.36421, 1, -1, 0.467682,-99) , 
1, 0.880844, 1, 0, 0.491686,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.0380339);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496483,-99) , 
3, 0.297255, 0, 0, 0.509817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456382,-99) , 
2, 1.36421, 1, 0, 0.476848,-99) , 
1, 0.880844, 1, 0, 0.499195,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.0370828);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494935,-99) , 
3, -0.419239, 0, 0, 0.524167,-99) , 
NN(
0, 
0, 
-1, 0.102889, 0, -1, 0.488201,-99) , 
2, -0.118576, 1, 0, 0.500982,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.0314945);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.989242, 0, 1, 0.533933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437711,-99) , 
0, 2.44582, 1, 0, 0.499657,-99) , 
1, -0.532895, 1, 0, 0.50795,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.0409092);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.989242, 0, 1, 0.526088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483691,-99) , 
3, 2.25305, 0, 0, 0.493081,-99) , 
1, -0.532895, 1, 0, 0.501062,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.0306836);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.54712, 1, 1, 0.509125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432163,-99) , 
3, 2.97956, 0, 0, 0.471854,-99) , 
0, 1.71733, 1, 0, 0.502991,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.0226607);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49958,-99) , 
3, 1.33508, 0, 0, 0.505566,-99) , 
NN(
0, 
0, 
-1, 1.22471, 0, -1, 0.47806,-99) , 
1, 0.880844, 1, 0, 0.496715,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.038917);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491905,-99) , 
3, 0.0106643, 0, 0, 0.512219,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423929,-99) , 
3, 1.14325, 0, 0, 0.485903,-99) , 
0, 0.701804, 1, 0, 0.501345,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.0500573);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.458937, 0, 1, 0.51908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466275,-99) , 
0, 0.606611, 1, 0, 0.482235,-99) , 
2, 0.357579, 1, 0, 0.49981,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.0322482);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482873,-99) , 
1, 0.296571, 1, 0, 0.504358,-99) , 
NN(
0, 
0, 
-1, 1.22471, 0, -1, 0.480386,-99) , 
1, 0.880844, 1, 0, 0.496642,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.0464325);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426795,-99) , 
0, 2.46038, 1, 0, 0.518088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44354,-99) , 
2, 0.986136, 1, 0, 0.492015,-99) , 
3, 2.12011, 0, 0, 0.496993,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.0452076);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487232,-99) , 
2, 1.06972, 1, 0, 0.506246,-99) , 
NN(
0, 
0, 
-1, 0.337066, 1, -1, 0.47845,-99) , 
3, 0.984155, 0, 0, 0.490374,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.0483396);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448882,-99) , 
0, 2.46038, 1, 0, 0.523634,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467094,-99) , 
0, 0.462167, 1, 0, 0.492831,-99) , 
3, 2.12011, 0, 0, 0.498707,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.0379641);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494801,-99) , 
0, 1.07858, 1, 0, 0.513004,-99) , 
NN(
0, 
0, 
-1, 0.69993, 1, -1, 0.481855,-99) , 
3, 0.984155, 0, 0, 0.495207,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.0361325);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461336,-99) , 
2, 2.61646, 1, 0, 0.523567,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466392,-99) , 
3, -0.88321, 0, 0, 0.493243,-99) , 
3, 1.55213, 0, 0, 0.502096,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.0226532);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538674,-99) , 
NN(
0, 
0, 
-1, 1.48532, 1, -1, 0.492068,-99) , 
3, 2.68809, 0, 0, 0.497211,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.0245875);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442509,-99) , 
1, 1.69521, 1, 0, 0.498842,-99) , 
3, 3.25607, 0, 0, 0.501624,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.0405681);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.01304, 0, 1, 0.516316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479022,-99) , 
0, -1.0617, 1, 0, 0.48851,-99) , 
3, 1.55213, 0, 0, 0.496617,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.0227667);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494896,-99) , 
3, 2.4215, 0, 0, 0.500355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458714,-99) , 
1, 2.29458, 1, 0, 0.49791,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.02971);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49511,-99) , 
3, 0.297255, 0, 0, 0.509311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432742,-99) , 
3, 1.22471, 0, 0, 0.48807,-99) , 
1, 0.880844, 1, 0, 0.502503,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.0420142);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483218,-99) , 
0, 0.981287, 1, 0, 0.510655,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467504,-99) , 
3, 2.82555, 0, 0, 0.483539,-99) , 
1, 0.880844, 1, 0, 0.501964,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.0385403);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491614,-99) , 
3, 1.06187, 0, 0, 0.503973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424205,-99) , 
3, 2.84281, 0, 0, 0.470735,-99) , 
2, 1.78605, 1, 0, 0.498952,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.041503);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472047,-99) , 
3, -1.0828, 0, 0, 0.509235,-99) , 
NN(
0, 
0, 
-1, 2.13801, 1, -1, 0.474812,-99) , 
1, 1.35209, 1, 0, 0.502014,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.0253406);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460456,-99) , 
1, -1.26368, 0, 0, 0.535641,-99) , 
NN(
0, 
0, 
-1, 2.56606, 1, -1, 0.494567,-99) , 
0, -1.32925, 1, 0, 0.499019,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.0349213);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.35938, 0, 1, 0.532901,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489184,-99) , 
0, -0.0153896, 1, 0, 0.499615,-99) , 
1, -1.00414, 1, 0, 0.504617,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.032251);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456309,-99) , 
0, 1.94447, 1, 0, 0.508873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47904,-99) , 
2, 2.2622, 1, 0, 0.506252,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.0357815);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497721,-99) , 
1, 0.293309, 1, 0, 0.509292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47895,-99) , 
3, 0.0643102, 0, 0, 0.489862,-99) , 
3, 0.416176, 0, 0, 0.500748,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.0342404);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.46191, 1, 1, 0.523606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490712,-99) , 
2, -1.27843, 1, 0, 0.499119,-99) , 
3, 1.55213, 0, 0, 0.506262,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.0338695);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54047,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467302,-99) , 
0, 1.56669, 1, 0, 0.505858,-99) , 
3, 3.25607, 0, 0, 0.507708,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.0213577);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498948,-99) , 
2, 0.515052, 1, 0, 0.510146,-99) , 
NN(
0, 
0, 
-1, -2.04525, 0, -1, 0.490779,-99) , 
3, 0.416176, 0, 0, 0.50163,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.0319124);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457348,-99) , 
0, 2.46038, 1, 0, 0.524819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496354,-99) , 
3, 1.6873, 0, 0, 0.501272,-99) , 
3, 2.12011, 0, 0, 0.505748,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.0268269);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.4215, 0, 1, 0.512664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474583,-99) , 
1, 2.29458, 1, 0, 0.510437,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.0232738);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46123,-99) , 
1, 1.69521, 1, 0, 0.502529,-99) , 
3, 3.25607, 0, 0, 0.504516,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.0250591);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468613,-99) , 
2, 1.08975, 1, 0, 0.496878,-99) , 
3, 2.68809, 0, 0, 0.499766,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.0307269);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439348,-99) , 
2, 2.57902, 1, 0, 0.504423,-99) , 
NN(
0, 
0, 
-1, -2.04525, 0, -1, 0.485405,-99) , 
3, 0.416176, 0, 0, 0.496048,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.0452601);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485886,-99) , 
3, -0.855793, 0, 0, 0.5113,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483532,-99) , 
3, 2.92625, 0, 0, 0.491001,-99) , 
2, -0.594732, 1, 0, 0.495948,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.0338334);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495537,-99) , 
3, -1.26503, 0, 0, 0.523301,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482435,-99) , 
3, 0.829749, 0, 0, 0.499075,-99) , 
0, -0.821486, 1, 0, 0.503483,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.0327608);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496933,-99) , 
3, -0.419239, 0, 0, 0.519269,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409108,-99) , 
3, 0.102889, 0, 0, 0.493698,-99) , 
2, -0.118576, 1, 0, 0.502845,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.052674);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473114,-99) , 
0, -0.580886, 1, 0, 0.526611,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481154,-99) , 
2, -0.414397, 1, 0, 0.487888,-99) , 
0, -0.313723, 1, 0, 0.49956,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.0362183);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490639,-99) , 
0, -1.61174, 0, 0, 0.528906,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487207,-99) , 
0, 0.382885, 1, 0, 0.500014,-99) , 
1, -1.00414, 1, 0, 0.504364,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.0293697);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540892,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443409,-99) , 
3, -1.10646, 0, 0, 0.50284,-99) , 
0, -1.83701, 1, 0, 0.505292,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.0281569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49711,-99) , 
2, -1.67906, 0, 0, 0.524354,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460797,-99) , 
3, -0.0793224, 0, 0, 0.494708,-99) , 
1, -1.00414, 1, 0, 0.499168,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.0214552);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533816,-99) , 
NN(
0, 
0, 
-1, 2.58007, 1, -1, 0.491668,-99) , 
2, -1.54704, 1, 0, 0.495626,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.0213903);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462397,-99) , 
1, -1.26368, 0, 0, 0.529498,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435053,-99) , 
2, 2.56606, 1, 0, 0.496401,-99) , 
0, -1.32925, 1, 0, 0.499982,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.042889);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467718,-99) , 
1, -1.26368, 0, 0, 0.529153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483064,-99) , 
1, -0.245683, 1, 0, 0.491693,-99) , 
0, -1.32925, 1, 0, 0.495742,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.0199966);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441511,-99) , 
3, -1.10646, 0, 0, 0.497579,-99) , 
0, -1.83701, 1, 0, 0.500308,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.0390381);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475381,-99) , 
1, -1.26368, 0, 0, 0.526253,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473626,-99) , 
3, 0.700312, 0, 0, 0.492499,-99) , 
0, -1.32925, 1, 0, 0.496137,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.0435166);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484476,-99) , 
0, -1.42785, 1, 0, 0.491307,-99) , 
1, -1.47539, 1, 0, 0.495087,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.0405494);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454506,-99) , 
3, -2.01501, 0, 0, 0.51492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488368,-99) , 
3, 2.22058, 0, 0, 0.497735,-99) , 
0, -0.313723, 1, 0, 0.502891,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.0404174);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482989,-99) , 
3, -0.443644, 0, 0, 0.509097,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447337,-99) , 
3, 2.84281, 0, 0, 0.479633,-99) , 
2, 1.78605, 1, 0, 0.504646,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.0193703);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.54712, 1, 1, 0.506164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451493,-99) , 
3, 2.97956, 0, 0, 0.474054,-99) , 
0, 1.71733, 1, 0, 0.500884,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.023309);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489271,-99) , 
1, -1.40936, 1, 0, 0.524408,-99) , 
NN(
0, 
0, 
-1, -0.91921, 0, -1, 0.492084,-99) , 
1, -1.00414, 1, 0, 0.49692,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.0320763);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469362,-99) , 
0, 1.45424, 1, 0, 0.504834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469096,-99) , 
2, 2.2622, 1, 0, 0.501693,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.0159826);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522629,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443443,-99) , 
3, -0.840604, 0, 0, 0.49482,-99) , 
2, -1.54704, 1, 0, 0.497414,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.0231446);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485829,-99) , 
1, -1.40936, 1, 0, 0.513584,-99) , 
NN(
0, 
0, 
-1, -0.0793224, 0, -1, 0.490754,-99) , 
1, -1.00414, 1, 0, 0.494165,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.030505);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490372,-99) , 
3, 1.31691, 0, 0, 0.500828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468005,-99) , 
1, 2.29458, 1, 0, 0.498906,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.0294034);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.458937, 0, 1, 0.510846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47499,-99) , 
3, 1.63028, 0, 0, 0.494218,-99) , 
2, 0.357579, 1, 0, 0.502149,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.0334522);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490883,-99) , 
3, 0.254568, 0, 0, 0.504026,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392214,-99) , 
0, 2.56365, 1, 0, 0.484181,-99) , 
0, 1.20957, 1, 0, 0.498486,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.0196635);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499733,-99) , 
0, -1.49853, 1, 0, 0.504978,-99) , 
NN(
0, 
0, 
-1, 2.56365, 1, -1, 0.478836,-99) , 
0, 1.20957, 1, 0, 0.497681,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.0316592);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472269,-99) , 
0, 0.871022, 1, 0, 0.508621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404946,-99) , 
0, 2.56365, 1, 0, 0.483745,-99) , 
0, 1.20957, 1, 0, 0.50168,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.0259758);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47268,-99) , 
2, 1.15418, 1, 0, 0.502515,-99) , 
NN(
0, 
0, 
-1, 2.56365, 1, -1, 0.478677,-99) , 
0, 1.20957, 1, 0, 0.495864,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.0159963);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520823,-99) , 
NN(
0, 
0, 
-1, 2.0333, 1, -1, 0.492728,-99) , 
3, 3.25607, 0, 0, 0.494233,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.0216726);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453223,-99) , 
3, -1.99687, 0, 0, 0.500112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440446,-99) , 
3, 3.0401, 0, 0, 0.480119,-99) , 
1, 1.82334, 1, 0, 0.497803,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.0182242);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515059,-99) , 
NN(
0, 
0, 
-1, -0.840604, 0, -1, 0.491502,-99) , 
2, -1.54704, 1, 0, 0.493701,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.0246252);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475526,-99) , 
3, -0.560004, 0, 0, 0.49928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477965,-99) , 
2, 2.2622, 1, 0, 0.497406,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.021369);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48737,-99) , 
2, -1.67906, 0, 0, 0.51408,-99) , 
NN(
0, 
0, 
-1, -0.91921, 0, -1, 0.491771,-99) , 
1, -1.00414, 1, 0, 0.495105,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.0141813);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526784,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42448,-99) , 
0, 2.56524, 1, 0, 0.49765,-99) , 
0, -1.83701, 1, 0, 0.499519,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.0356631);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462362,-99) , 
0, 2.46038, 1, 0, 0.510979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471408,-99) , 
0, 0.462167, 1, 0, 0.492901,-99) , 
3, 2.12011, 0, 0, 0.496329,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.0184494);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528157,-99) , 
NN(
0, 
0, 
-1, -1.12616, 0, -1, 0.491847,-99) , 
3, 3.25607, 0, 0, 0.49379,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.0404643);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491022,-99) , 
0, 1.07858, 1, 0, 0.505961,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482379,-99) , 
3, 0.605229, 0, 0, 0.49185,-99) , 
3, 0.984155, 0, 0, 0.497908,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.0245172);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492789,-99) , 
1, -0.15561, 1, 0, 0.501795,-99) , 
3, 3.25607, 0, 0, 0.503501,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.0256676);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484845,-99) , 
2, 2.36314, 1, 0, 0.520915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496052,-99) , 
3, 1.6873, 0, 0, 0.50105,-99) , 
3, 2.12011, 0, 0, 0.504815,-99)    );
  // itree = 200
  fBoostWeights.push_back(0.0344789);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512927,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448745,-99) , 
3, -1.10646, 0, 0, 0.507278,-99) , 
0, -1.83701, 1, 0, 0.508791,-99)    );
  // itree = 201
  fBoostWeights.push_back(0.0178301);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522442,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460706,-99) , 
3, -0.840604, 0, 0, 0.49944,-99) , 
2, -1.54704, 1, 0, 0.501593,-99)    );
  // itree = 202
  fBoostWeights.push_back(0.0389535);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453003,-99) , 
3, -2.01501, 0, 0, 0.509322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486653,-99) , 
3, 2.90544, 0, 0, 0.493092,-99) , 
0, -0.313723, 1, 0, 0.497965,-99)    );
  // itree = 203
  fBoostWeights.push_back(0.0241536);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494362,-99) , 
3, 1.31691, 0, 0, 0.503125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47004,-99) , 
1, 2.29458, 1, 0, 0.501192,-99)    );
  // itree = 204
  fBoostWeights.push_back(0.0286524);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.33508, 0, 1, 0.510298,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461768,-99) , 
0, 1.59497, 1, 0, 0.489853,-99) , 
1, 0.880844, 1, 0, 0.503766,-99)    );
  // itree = 205
  fBoostWeights.push_back(0.015361);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498309,-99) , 
3, 1.33508, 0, 0, 0.503136,-99) , 
NN(
0, 
0, 
-1, 1.22471, 0, -1, 0.488873,-99) , 
1, 0.880844, 1, 0, 0.498581,-99)    );
  // itree = 206
  fBoostWeights.push_back(0.0182081);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522515,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460361,-99) , 
3, -0.840604, 0, 0, 0.499573,-99) , 
2, -1.54704, 1, 0, 0.501717,-99)    );
  // itree = 207
  fBoostWeights.push_back(0.0323034);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488214,-99) , 
3, -0.419239, 0, 0, 0.507334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404762,-99) , 
3, 0.102889, 0, 0, 0.49284,-99) , 
2, -0.118576, 1, 0, 0.498013,-99)    );
  // itree = 208
  fBoostWeights.push_back(0.0301698);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493979,-99) , 
0, -1.18456, 1, 0, 0.509772,-99) , 
NN(
0, 
0, 
-1, 0.102889, 0, -1, 0.486429,-99) , 
2, -0.118576, 1, 0, 0.494758,-99)    );
  // itree = 209
  fBoostWeights.push_back(0.0383154);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493012,-99) , 
2, -0.731518, 1, 0, 0.510141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478655,-99) , 
3, 2.18523, 0, 0, 0.491724,-99) , 
2, 0.357579, 1, 0, 0.500507,-99)    );
  // itree = 210
  fBoostWeights.push_back(0.030062);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473038,-99) , 
3, -1.44732, 0, 0, 0.50717,-99) , 
NN(
0, 
0, 
-1, 2.60292, 1, -1, 0.478074,-99) , 
2, 1.78605, 1, 0, 0.502787,-99)    );
  // itree = 211
  fBoostWeights.push_back(0.030717);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485137,-99) , 
1, 0.296571, 1, 0, 0.504866,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462916,-99) , 
0, 1.59497, 1, 0, 0.486846,-99) , 
1, 0.880844, 1, 0, 0.499106,-99)    );
  // itree = 212
  fBoostWeights.push_back(0.0173238);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497505,-99) , 
3, 1.33508, 0, 0, 0.501741,-99) , 
NN(
0, 
0, 
-1, 1.22471, 0, -1, 0.4858,-99) , 
1, 0.880844, 1, 0, 0.496646,-99)    );
  // itree = 213
  fBoostWeights.push_back(0.0214928);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486152,-99) , 
0, 0.981287, 1, 0, 0.504906,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444639,-99) , 
3, 1.22471, 0, 0, 0.490129,-99) , 
1, 0.880844, 1, 0, 0.500183,-99)    );
  // itree = 214
  fBoostWeights.push_back(0.0214786);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497482,-99) , 
3, 1.33508, 0, 0, 0.501635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469277,-99) , 
3, 2.29193, 0, 0, 0.48684,-99) , 
1, 0.880844, 1, 0, 0.496907,-99)    );
  // itree = 215
  fBoostWeights.push_back(0.0267191);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458182,-99) , 
0, 2.04384, 1, 0, 0.502834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43681,-99) , 
3, 3.0401, 0, 0, 0.476145,-99) , 
1, 1.82334, 1, 0, 0.49976,-99)    );
  // itree = 216
  fBoostWeights.push_back(0.0221753);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488002,-99) , 
3, -0.221659, 0, 0, 0.499301,-99) , 
NN(
0, 
0, 
-1, 2.13756, 1, -1, 0.485235,-99) , 
1, 0.880844, 1, 0, 0.494809,-99)    );
  // itree = 217
  fBoostWeights.push_back(0.0133727);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520605,-99) , 
NN(
0, 
0, 
-1, 2.56524, 1, -1, 0.494272,-99) , 
0, -1.83701, 1, 0, 0.495969,-99)    );
  // itree = 218
  fBoostWeights.push_back(0.0131283);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48642,-99) , 
2, -1.67906, 0, 0, 0.512496,-99) , 
NN(
0, 
0, 
-1, -0.91921, 0, -1, 0.496487,-99) , 
1, -1.00414, 1, 0, 0.498881,-99)    );
  // itree = 219
  fBoostWeights.push_back(0.0324734);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481614,-99) , 
3, -1.67235, 0, 0, 0.512245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486825,-99) , 
2, 0.60747, 1, 0, 0.499249,-99) , 
0, -0.821486, 1, 0, 0.501594,-99)    );
  // itree = 220
  fBoostWeights.push_back(0.0380841);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488649,-99) , 
3, 1.7417, 0, 0, 0.510919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48656,-99) , 
3, 0.605229, 0, 0, 0.495287,-99) , 
3, 0.984155, 0, 0, 0.502,-99)    );
  // itree = 221
  fBoostWeights.push_back(0.0238379);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533888,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432016,-99) , 
0, 2.56524, 1, 0, 0.503087,-99) , 
0, -1.83701, 1, 0, 0.505072,-99)    );
  // itree = 222
  fBoostWeights.push_back(0.0119189);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437874,-99) , 
0, 2.56524, 1, 0, 0.497768,-99) , 
0, -1.83701, 1, 0, 0.499713,-99)    );
  // itree = 223
  fBoostWeights.push_back(0.012372);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52498,-99) , 
NN(
0, 
0, 
-1, 2.56524, 1, -1, 0.495108,-99) , 
0, -1.83701, 1, 0, 0.497032,-99)    );
  // itree = 224
  fBoostWeights.push_back(0.0193023);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494005,-99) , 
0, -1.03133, 1, 0, 0.497747,-99) , 
2, -1.54704, 1, 0, 0.499727,-99)    );
  // itree = 225
  fBoostWeights.push_back(0.0244511);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496486,-99) , 
0, 1.07858, 1, 0, 0.510323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444744,-99) , 
1, 0.69993, 1, 0, 0.497295,-99) , 
3, 0.984155, 0, 0, 0.502889,-99)    );
  // itree = 226
  fBoostWeights.push_back(0.0304039);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.06972, 1, 1, 0.512535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476787,-99) , 
0, -0.442457, 1, 0, 0.492592,-99) , 
3, 0.984155, 0, 0, 0.501155,-99)    );
  // itree = 227
  fBoostWeights.push_back(0.0353482);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492973,-99) , 
0, 0.0447361, 1, 0, 0.503315,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467493,-99) , 
2, -1.22121, 1, 0, 0.486195,-99) , 
3, -0.151802, 0, 0, 0.498151,-99)    );
  // itree = 228
  fBoostWeights.push_back(0.0416244);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443145,-99) , 
3, 0.092145, 0, 0, 0.509114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460312,-99) , 
3, -1.12675, 0, 0, 0.487612,-99) , 
3, -0.151802, 0, 0, 0.50263,-99)    );
  // itree = 229
  fBoostWeights.push_back(0.0127063);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525839,-99) , 
NN(
0, 
0, 
-1, 1.69521, 1, -1, 0.494755,-99) , 
3, 3.25607, 0, 0, 0.496427,-99)    );
  // itree = 230
  fBoostWeights.push_back(0.0305633);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494741,-99) , 
0, 0.0447361, 1, 0, 0.503246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476033,-99) , 
1, -1.33339, 1, 0, 0.490032,-99) , 
3, -0.151802, 0, 0, 0.499262,-99)    );
  // itree = 231
  fBoostWeights.push_back(0.028292);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465695,-99) , 
2, 2.60112, 1, 0, 0.512245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436071,-99) , 
3, -2.04524, 0, 0, 0.497126,-99) , 
3, 0.984155, 0, 0, 0.503631,-99)    );
  // itree = 232
  fBoostWeights.push_back(0.0120618);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471526,-99) , 
3, -1.12616, 0, 0, 0.496143,-99) , 
3, 3.25607, 0, 0, 0.498066,-99)    );
  // itree = 233
  fBoostWeights.push_back(0.0144247);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528842,-99) , 
NN(
0, 
0, 
-1, 1.69521, 1, -1, 0.494019,-99) , 
3, 3.25607, 0, 0, 0.495894,-99)    );
  // itree = 234
  fBoostWeights.push_back(0.0161754);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497839,-99) , 
3, 2.87757, 0, 0, 0.5066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442669,-99) , 
1, 0.69993, 1, 0, 0.493458,-99) , 
3, 0.984155, 0, 0, 0.499111,-99)    );
  // itree = 235
  fBoostWeights.push_back(0.0333628);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497043,-99) , 
2, 1.06972, 1, 0, 0.508898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482851,-99) , 
3, 0.605229, 0, 0, 0.490344,-99) , 
3, 0.984155, 0, 0, 0.498325,-99)    );
  // itree = 236
  fBoostWeights.push_back(0.0327462);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491014,-99) , 
3, 1.7417, 0, 0, 0.512117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4622,-99) , 
1, 0.350208, 1, 0, 0.496159,-99) , 
3, 0.984155, 0, 0, 0.503024,-99)    );
  // itree = 237
  fBoostWeights.push_back(0.0195736);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499092,-99) , 
0, 1.07858, 1, 0, 0.510688,-99) , 
NN(
0, 
0, 
-1, -2.04524, 0, -1, 0.491829,-99) , 
3, 0.984155, 0, 0, 0.499941,-99)    );
  // itree = 238
  fBoostWeights.push_back(0.0238263);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470588,-99) , 
2, 2.60112, 1, 0, 0.512461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450579,-99) , 
3, -2.04524, 0, 0, 0.496722,-99) , 
3, 0.984155, 0, 0, 0.503492,-99)    );
  // itree = 239
  fBoostWeights.push_back(0.0275383);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499398,-99) , 
3, 2.87757, 0, 0, 0.507968,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483603,-99) , 
0, -1.22198, 1, 0, 0.491889,-99) , 
3, 0.984155, 0, 0, 0.498804,-99)    );
  // itree = 240
  fBoostWeights.push_back(0.0331282);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479883,-99) , 
1, 2.06343, 1, 0, 0.511879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489299,-99) , 
3, 0.605229, 0, 0, 0.495726,-99) , 
3, 0.984155, 0, 0, 0.502673,-99)    );
  // itree = 241
  fBoostWeights.push_back(0.0272522);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468698,-99) , 
3, -0.556041, 0, 0, 0.502454,-99) , 
3, -1.85574, 1, 0, 0.50386,-99)    );
  // itree = 242
  fBoostWeights.push_back(0.0346761);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491002,-99) , 
3, -0.414767, 0, 0, 0.506621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480323,-99) , 
3, 2.18523, 0, 0, 0.492394,-99) , 
2, 0.357579, 1, 0, 0.499172,-99)    );
  // itree = 243
  fBoostWeights.push_back(0.0207028);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491908,-99) , 
0, -1.54745, 1, 0, 0.51872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46011,-99) , 
0, 2.10496, 1, 0, 0.496892,-99) , 
0, -0.821486, 1, 0, 0.50083,-99)    );
  // itree = 244
  fBoostWeights.push_back(0.0299122);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490693,-99) , 
3, -1.67235, 0, 0, 0.518842,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489539,-99) , 
0, -0.553986, 1, 0, 0.492987,-99) , 
0, -0.821486, 1, 0, 0.497649,-99)    );
  // itree = 245
  fBoostWeights.push_back(0.0226916);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490668,-99) , 
0, -1.61174, 0, 0, 0.51986,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494297,-99) , 
1, -0.195901, 1, 0, 0.499652,-99) , 
1, -1.00414, 1, 0, 0.502668,-99)    );
  // itree = 246
  fBoostWeights.push_back(0.0254442);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5301,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492842,-99) , 
3, 1.06633, 0, 0, 0.503392,-99) , 
3, -1.85574, 1, 0, 0.505246,-99)    );
  // itree = 247
  fBoostWeights.push_back(0.0237051);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.49853, 1, 1, 0.509906,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437543,-99) , 
0, 2.56365, 1, 0, 0.494247,-99) , 
0, 1.20957, 1, 0, 0.505529,-99)    );
  // itree = 248
  fBoostWeights.push_back(0.0282619);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48952,-99) , 
0, -1.54745, 1, 0, 0.514002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4814,-99) , 
0, 1.04138, 1, 0, 0.49717,-99) , 
0, -0.821486, 1, 0, 0.500202,-99)    );
  // itree = 249
  fBoostWeights.push_back(0.032456);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484317,-99) , 
3, -1.67235, 0, 0, 0.51417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488937,-99) , 
3, 2.33166, 0, 0, 0.495661,-99) , 
0, -0.821486, 1, 0, 0.498994,-99)    );
  // itree = 250
  fBoostWeights.push_back(0.0275734);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494446,-99) , 
3, 0.212315, 0, 0, 0.505352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450018,-99) , 
3, 3.0401, 0, 0, 0.484863,-99) , 
1, 1.82334, 1, 0, 0.502993,-99)    );
  // itree = 251
  fBoostWeights.push_back(0.0298094);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497482,-99) , 
0, -1.54745, 1, 0, 0.519757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48656,-99) , 
2, 0.60747, 1, 0, 0.498574,-99) , 
0, -0.821486, 1, 0, 0.50239,-99)    );
  // itree = 252
  fBoostWeights.push_back(0.0278651);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493109,-99) , 
1, -1.20898, 0, 0, 0.519931,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486028,-99) , 
3, 0.829749, 0, 0, 0.49927,-99) , 
0, -0.821486, 1, 0, 0.50299,-99)    );
  // itree = 253
  fBoostWeights.push_back(0.0289379);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4903,-99) , 
0, -1.61174, 0, 0, 0.522536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488558,-99) , 
0, 0.382885, 1, 0, 0.498395,-99) , 
1, -1.00414, 1, 0, 0.501999,-99)    );
  // itree = 254
  fBoostWeights.push_back(0.0188769);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493637,-99) , 
1, -1.40936, 1, 0, 0.520429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451255,-99) , 
3, -0.91921, 0, 0, 0.499665,-99) , 
1, -1.00414, 1, 0, 0.502764,-99)    );
  // itree = 255
  fBoostWeights.push_back(0.013663);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498448,-99) , 
1, -1.61126, 0, 0, 0.519448,-99) , 
NN(
0, 
0, 
-1, -0.91921, 0, -1, 0.495619,-99) , 
1, -1.00414, 1, 0, 0.499175,-99)    );
  // itree = 256
  fBoostWeights.push_back(0.0146839);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497044,-99) , 
2, -1.37262, 1, 0, 0.519021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459325,-99) , 
3, -0.91921, 0, 0, 0.499035,-99) , 
1, -1.00414, 1, 0, 0.502016,-99)    );
  // itree = 257
  fBoostWeights.push_back(0.0243286);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495438,-99) , 
2, -1.67906, 0, 0, 0.518593,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486975,-99) , 
3, 1.18051, 0, 0, 0.495887,-99) , 
1, -1.00414, 1, 0, 0.499274,-99)    );
  // itree = 258
  fBoostWeights.push_back(0.0252074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498613,-99) , 
0, -1.54745, 1, 0, 0.519697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480411,-99) , 
0, 1.04138, 1, 0, 0.495323,-99) , 
0, -0.821486, 1, 0, 0.499705,-99)    );
  // itree = 259
  fBoostWeights.push_back(0.027682);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496176,-99) , 
3, -1.67235, 0, 0, 0.519855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489079,-99) , 
3, 2.33166, 0, 0, 0.493977,-99) , 
0, -0.821486, 1, 0, 0.498629,-99)    );
  // itree = 260
  fBoostWeights.push_back(0.0216221);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498268,-99) , 
0, -0.438335, 1, 0, 0.506487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454426,-99) , 
1, 2.13801, 1, 0, 0.485331,-99) , 
1, 1.35209, 1, 0, 0.502038,-99)    );
  // itree = 261
  fBoostWeights.push_back(0.0307562);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485392,-99) , 
3, -1.0828, 0, 0, 0.508271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456016,-99) , 
3, 2.32354, 0, 0, 0.48384,-99) , 
1, 1.35209, 1, 0, 0.503134,-99)    );
  // itree = 262
  fBoostWeights.push_back(0.0123321);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528021,-99) , 
NN(
0, 
0, 
-1, 2.58007, 1, -1, 0.496088,-99) , 
2, -1.54704, 1, 0, 0.499073,-99)    );
  // itree = 263
  fBoostWeights.push_back(0.016485);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.27572, 1, 1, 0.505279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459476,-99) , 
1, 1.91267, 0, 0, 0.480828,-99) , 
2, 1.78605, 1, 0, 0.50158,-99)    );
  // itree = 264
  fBoostWeights.push_back(0.0130569);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47303,-99) , 
3, -0.556041, 0, 0, 0.495997,-99) , 
3, -1.85574, 1, 0, 0.498136,-99)    );
  // itree = 265
  fBoostWeights.push_back(0.0259499);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490717,-99) , 
1, -0.218857, 1, 0, 0.50009,-99) , 
NN(
0, 
0, 
-1, 2.13801, 1, -1, 0.4801,-99) , 
1, 1.35209, 1, 0, 0.495887,-99)    );
  // itree = 266
  fBoostWeights.push_back(0.024003);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489192,-99) , 
3, -0.0128434, 0, 0, 0.501317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457699,-99) , 
1, 2.13801, 1, 0, 0.48658,-99) , 
1, 1.35209, 1, 0, 0.498218,-99)    );
  // itree = 267
  fBoostWeights.push_back(0.0177862);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496203,-99) , 
0, -1.54745, 1, 0, 0.515033,-99) , 
NN(
0, 
0, 
-1, 2.10496, 1, -1, 0.4933,-99) , 
0, -0.821486, 1, 0, 0.497201,-99)    );
  // itree = 268
  fBoostWeights.push_back(0.0171396);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492756,-99) , 
1, -1.20898, 0, 0, 0.515136,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467085,-99) , 
0, 2.10496, 1, 0, 0.497746,-99) , 
0, -0.821486, 1, 0, 0.500867,-99)    );
  // itree = 269
  fBoostWeights.push_back(0.023582);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498657,-99) , 
0, -1.54745, 1, 0, 0.514375,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490263,-99) , 
2, -0.493124, 1, 0, 0.494513,-99) , 
0, -0.821486, 1, 0, 0.498077,-99)    );
  // itree = 270
  fBoostWeights.push_back(0.0254225);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492056,-99) , 
3, -1.67235, 0, 0, 0.514516,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485827,-99) , 
3, 0.829749, 0, 0, 0.498553,-99) , 
0, -0.821486, 1, 0, 0.501417,-99)    );
  // itree = 271
  fBoostWeights.push_back(0.0242146);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471263,-99) , 
0, 1.54741, 1, 0, 0.503932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463505,-99) , 
3, 2.32354, 0, 0, 0.487868,-99) , 
1, 1.35209, 1, 0, 0.500554,-99)    );
  // itree = 272
  fBoostWeights.push_back(0.0118091);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518351,-99) , 
NN(
0, 
0, 
-1, -0.556041, 0, -1, 0.495021,-99) , 
3, -1.85574, 1, 0, 0.496636,-99)    );
  // itree = 273
  fBoostWeights.push_back(0.0214832);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495151,-99) , 
3, 1.06187, 0, 0, 0.501551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464359,-99) , 
1, 1.91267, 0, 0, 0.485888,-99) , 
2, 1.78605, 1, 0, 0.499179,-99)    );
  // itree = 274
  fBoostWeights.push_back(0.0250825);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490389,-99) , 
2, 0.460042, 1, 0, 0.504624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461279,-99) , 
1, 2.13801, 1, 0, 0.487422,-99) , 
1, 1.35209, 1, 0, 0.501009,-99)    );
  // itree = 275
  fBoostWeights.push_back(0.0250747);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481662,-99) , 
3, -1.0828, 0, 0, 0.502994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473861,-99) , 
3, 3.11448, 0, 0, 0.485702,-99) , 
1, 1.35209, 1, 0, 0.499361,-99)    );
  // itree = 276
  fBoostWeights.push_back(0.0131695);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518056,-99) , 
NN(
0, 
0, 
-1, 2.58007, 1, -1, 0.494599,-99) , 
2, -1.54704, 1, 0, 0.496793,-99)    );
  // itree = 277
  fBoostWeights.push_back(0.0200653);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480781,-99) , 
0, -1.61174, 0, 0, 0.512045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477017,-99) , 
3, -0.0793224, 0, 0, 0.497266,-99) , 
1, -1.00414, 1, 0, 0.499469,-99)    );
  // itree = 278
  fBoostWeights.push_back(0.016272);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49887,-99) , 
0, -1.54745, 1, 0, 0.513303,-99) , 
NN(
0, 
0, 
-1, 2.10496, 1, -1, 0.493247,-99) , 
0, -0.821486, 1, 0, 0.496844,-99)    );
  // itree = 279
  fBoostWeights.push_back(0.0143213);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493849,-99) , 
3, -1.67235, 0, 0, 0.513397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470127,-99) , 
0, 2.10496, 1, 0, 0.497314,-99) , 
0, -0.821486, 1, 0, 0.500199,-99)    );
  // itree = 280
  fBoostWeights.push_back(0.0209035);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49601,-99) , 
1, -1.20898, 0, 0, 0.512888,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492114,-99) , 
0, -0.553986, 1, 0, 0.494612,-99) , 
0, -0.821486, 1, 0, 0.49789,-99)    );
  // itree = 281
  fBoostWeights.push_back(0.0181103);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524523,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475264,-99) , 
3, -0.556041, 0, 0, 0.499646,-99) , 
3, -1.85574, 1, 0, 0.501369,-99)    );
  // itree = 282
  fBoostWeights.push_back(0.0256714);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491516,-99) , 
0, -1.42785, 1, 0, 0.496306,-99) , 
1, -1.47539, 1, 0, 0.498248,-99)    );
  // itree = 283
  fBoostWeights.push_back(0.0190522);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519955,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48174,-99) , 
1, 1.2325, 1, 0, 0.501881,-99) , 
3, 3.25607, 0, 0, 0.502864,-99)    );
  // itree = 284
  fBoostWeights.push_back(0.0169646);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494302,-99) , 
3, 1.79453, 0, 0, 0.498955,-99) , 
3, 3.25607, 0, 0, 0.499839,-99)    );
  // itree = 285
  fBoostWeights.push_back(0.019978);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460136,-99) , 
0, 1.94447, 1, 0, 0.503529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486676,-99) , 
2, 2.2622, 1, 0, 0.502031,-99)    );
  // itree = 286
  fBoostWeights.push_back(0.00621856);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515926,-99) , 
NN(
0, 
0, 
-1, 2.0333, 1, -1, 0.497628,-99) , 
3, 3.25607, 0, 0, 0.498624,-99)    );
  // itree = 287
  fBoostWeights.push_back(0.00803783);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514373,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469609,-99) , 
0, 2.0333, 1, 0, 0.499183,-99) , 
3, 3.25607, 0, 0, 0.50001,-99)    );
  // itree = 288
  fBoostWeights.push_back(0.0170514);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493238,-99) , 
3, 1.79453, 0, 0, 0.497454,-99) , 
3, 3.25607, 0, 0, 0.498265,-99)    );
  // itree = 289
  fBoostWeights.push_back(0.0170759);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467791,-99) , 
3, -1.94916, 0, 0, 0.502439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460227,-99) , 
2, 2.60292, 1, 0, 0.489423,-99) , 
2, 1.78605, 1, 0, 0.50047,-99)    );
  // itree = 290
  fBoostWeights.push_back(0.00988644);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515235,-99) , 
NN(
0, 
0, 
-1, -0.556041, 0, -1, 0.495821,-99) , 
3, -1.85574, 1, 0, 0.497163,-99)    );
  // itree = 291
  fBoostWeights.push_back(0.014844);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495097,-99) , 
0, -1.03133, 1, 0, 0.498037,-99) , 
2, -1.54704, 1, 0, 0.499293,-99)    );
  // itree = 292
  fBoostWeights.push_back(0.0144503);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480444,-99) , 
0, 1.56669, 1, 0, 0.500958,-99) , 
3, 3.25607, 0, 0, 0.501734,-99)    );
  // itree = 293
  fBoostWeights.push_back(0.0210575);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485994,-99) , 
3, 1.7417, 0, 0, 0.502692,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440384,-99) , 
3, -2.04524, 0, 0, 0.496449,-99) , 
3, 0.984155, 0, 0, 0.499135,-99)    );
  // itree = 294
  fBoostWeights.push_back(0.0185294);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462012,-99) , 
2, 2.60112, 1, 0, 0.501778,-99) , 
NN(
0, 
0, 
-1, -2.04524, 0, -1, 0.492177,-99) , 
3, 0.984155, 0, 0, 0.496308,-99)    );
  // itree = 295
  fBoostWeights.push_back(0.0118393);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47275,-99) , 
3, -0.556041, 0, 0, 0.49629,-99) , 
3, -1.85574, 1, 0, 0.497447,-99)    );
  // itree = 296
  fBoostWeights.push_back(0.0181);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475983,-99) , 
0, -1.61174, 0, 0, 0.506464,-99) , 
NN(
0, 
0, 
-1, -0.91921, 0, -1, 0.493475,-99) , 
1, -1.00414, 1, 0, 0.495407,-99)    );
  // itree = 297
  fBoostWeights.push_back(0.0158771);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497343,-99) , 
2, -1.27572, 1, 0, 0.500853,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469378,-99) , 
1, 1.91267, 0, 0, 0.489015,-99) , 
2, 1.78605, 1, 0, 0.499063,-99)    );
  // itree = 298
  fBoostWeights.push_back(0.019533);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467385,-99) , 
3, -1.94916, 0, 0, 0.503661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473334,-99) , 
1, 1.91267, 0, 0, 0.489348,-99) , 
2, 1.78605, 1, 0, 0.501497,-99)    );
  // itree = 299
  fBoostWeights.push_back(0.0140214);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465028,-99) , 
3, -1.99687, 0, 0, 0.499752,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460581,-99) , 
3, 3.0401, 0, 0, 0.484466,-99) , 
1, 1.82334, 1, 0, 0.497998,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
