
#include <TSQLiteServer.h>
#include <TSQLiteResult.h>
#include <TSQLRow.h>
#include <TString.h>
#include <TH2F.h>

void SQLiteIPLocation() {

   TSQLServer *db = TSQLServer::Connect("sqlite://root_download_stats.sqlite", "", "");

   TFile *F = TFile::Open("http://root.cern/files/WM.root");
   TH2Poly *WM;
   WM = (TH2Poly*) F->Get("WM");
   const char *location = "SELECT IPLatitude, IPLongitude FROM accesslog;";
   TSQLResult *locationRes = db->Query(location);

   while (TSQLRow *row = locationRes->Next()) {
      if (!row->GetField(0)[0])
         continue;
      std::string sLatitude(row->GetField(0));
      std::string sLongitude(row->GetField(1));
      float latitude = std::stof(sLatitude);
      float longitude = std::stof(sLongitude);
      WM->Fill(longitude, latitude);

     delete row;
   }

   TCanvas *locationHistogram = new TCanvas();

   locationHistogram->SetLogz(1);
   locationHistogram->ToggleEventStatus();
   WM->Draw("colz");
}
