
#include <TSQLiteServer.h>
#include <TSQLiteResult.h>
#include <TSQLRow.h>
#include <TString.h>

void SQLiteTimeVersionOfRoot(){

   TSQLServer *db = TSQLServer::Connect("sqlite://root_download_stats.sqlite", "", "");

   const char *minTime = "SELECT min(Time) FROM accesslog;";
   TSQLResult *minTimeRes = db->Query(minTime);

   std::string strMinTimeField = minTimeRes->Next()->GetField(0);
   TDatime minTimeFormat(strMinTimeField.c_str());

   TDatime now;
   TH1F *hTime = new TH1F("hTime", "Duration of ROOT dependency over version 6.14", 10, minTimeFormat.Convert(), now.Convert());

   const char *time = "SELECT Time, Version FROM accesslog;";
   TSQLResult *timeRes = db->Query(time);

   while (TSQLRow *row = timeRes->Next()) {
      TDatime rowTime(row->GetField(0));
      TString rowVersion(row->GetField(1));
      TString shortVersion(rowVersion(0,4));
      if ( shortVersion == "6.14" ) {
         hTime->Fill(rowTime.Convert());
      }
      delete row;
   }

   TCanvas *timeHistogram = new TCanvas();

   gStyle->SetTimeOffset(0);
   hTime->GetXaxis()->SetTimeDisplay(1);
   hTime->GetXaxis()->SetLabelSize(0.02);
   hTime->GetXaxis()->SetNdivisions(512, kFALSE);
   hTime->GetXaxis()->SetTimeFormat("%Y-%m-%d");

   hTime->Draw();
}
