
#include <TSQLiteServer.h>
#include <TSQLiteResult.h>
#include <TSQLRow.h>
#include <TString.h>

void SQLiteVersionsOfRoot(){

   TSQLServer *db = TSQLServer::Connect("sqlite://root_download_stats.sqlite", "", "");

   const char *rootSourceVersion = "SELECT Version FROM accesslog;";

   TSQLResult *rootSourceVersionRes = db->Query(rootSourceVersion);

   TH1F *hVersionOfRoot= new TH1F("hVersionOfRoot", "Development Versions of ROOT", 7, 0, -1);

   while (TSQLRow *row = rootSourceVersionRes->Next()) {
      TString rowVersion(row->GetField(0));
      TString shortVersion(rowVersion(0,4));
      hVersionOfRoot->Fill(shortVersion,1);
      delete row;
   }

   TCanvas *VersionOfRootHistogram = new TCanvas();

   hVersionOfRoot->GetXaxis()->LabelsOption("a");
   hVersionOfRoot->LabelsDeflate("X");
   hVersionOfRoot->Draw();
}
