{
   //canvas only needed for the documentation
   TCanvas* c1 = new TCanvas("c1","",600,400);
   c1->SetFillStyle(1001);
   c1->SetFillColor(kWhite);

   //create different beta distributions
   TF1* f1 = new TF1("f1","TMath::BetaDist(x,1,1)",0,1);
   f1->SetLineColor(kBlue);
   TF1* f2 = new TF1("f2","TMath::BetaDist(x,0.5,0.5)",0,1);
   f2->SetLineColor(kRed);
   TF1* f3 = new TF1("f3","TMath::BetaDist(x,1,5)",0,1);
   f3->SetLineColor(kGreen+3);
   f3->SetTitle("Beta distributions as priors;#epsilon;P(#epsilon)");
   TF1* f4 = new TF1("f4","TMath::BetaDist(x,4,3)",0,1);
   f4->SetLineColor(kViolet);

   //add legend
   TLegend* leg = new TLegend(0.25,0.5,0.85,0.89);
   leg->SetFillColor(kWhite);
   leg->SetFillStyle(1001);
   leg->AddEntry(f1,"a=1, b=1","L");
   leg->AddEntry(f2,"a=0.5, b=0.5","L");
   leg->AddEntry(f3,"a=1, b=5","L");
   leg->AddEntry(f4,"a=4, b=3","L");

   f3->Draw();
   f1->Draw("same");
   f2->Draw("Same");
   f4->Draw("same");
   leg->Draw("same");
}
