{
   //canvas only needed for this documentation
   TCanvas* c1 = new TCanvas("example","",600,400);
   c1->SetFillStyle(1001);
   c1->SetFillColor(kWhite);
   c1->Divide(2,1);

   //create one-dimensional TEfficiency object with fixed bin size
   TEfficiency* pEff = new TEfficiency("eff","my efficiency;x;#epsilon",20,0,10);
   TRandom3 rand3;

   bool bPassed;
   double x;
   for(int i=0; i<10000; ++i)
   {
      //simulate events with variable under investigation
      x = rand3.Uniform(10);
      //check selection: bPassed = DoesEventPassSelection(x)
      bPassed = rand3.Rndm() < TMath::Gaus(x,5,4);
      pEff->Fill(bPassed,x);
   }
   c1->cd(1);
   pEff->Draw("AP");
   c1->cd(2);
   pEff->Draw("AP");
   gPad->Update();
   pEff->GetPaintedGraph()->GetXaxis()->SetTitleSize(0.05);
   pEff->GetPaintedGraph()->GetXaxis()->SetLabelFont(42);
   pEff->GetPaintedGraph()->GetXaxis()->SetLabelSize(0.05);
   pEff->GetPaintedGraph()->GetYaxis()->SetTitleOffset(0.85);
   pEff->GetPaintedGraph()->GetYaxis()->SetTitleSize(0.05);
   pEff->GetPaintedGraph()->GetYaxis()->SetLabelFont(42);
   pEff->GetPaintedGraph()->GetYaxis()->SetLabelSize(0.05);
   pEff->GetPaintedGraph()->GetXaxis()->SetRangeUser(3,7);
}
