{
     TCanvas* c1 = new TCanvas("c1","",600,800);
     c1->Divide(1,2);
     c1->SetFillStyle(1001);
     c1->SetFillColor(kWhite);

     TF1* p1 = new TF1("p1","TMath::BetaDist(x,19,9)",0,1);
     TF1* p2 = new TF1("p2","TMath::BetaDist(x,4,8)",0,1);
     TF1* comb = new TF1("comb2","TMath::BetaDist(x,[0],[1])",0,1);
     double nrm = 1./(0.6*0.6+0.4*0.4); // weight normalization
     double a = 0.6*18.0 + 0.4*3.0 + 1.0;  // new alpha parameter of combined beta dist.
     double b = 0.6*10+0.4*7+1.0;  // new beta parameter of combined beta dist.
     comb->SetParameters(nrm*a ,nrm *b );
     TF1* const1 = new TF1("const1","0.05",0,1);
     TF1* const2 = new TF1("const2","0.95",0,1);

     p1->SetLineColor(kRed);
     p1->SetTitle("combined posteriors;#epsilon;P(#epsilon|k,N)");
     p2->SetLineColor(kBlue);
     comb->SetLineColor(kGreen+2);

     TLegend* leg1 = new TLegend(0.12,0.65,0.5,0.85);
     leg1->AddEntry(p1,"k1 = 18, N1 = 26","l");
     leg1->AddEntry(p2,"k2 = 3, N2 = 10","l");
     leg1->AddEntry(comb,"combined: p1 = 0.6, p2=0.4","l");

     c1->cd(1);
     comb->Draw();
     p1->Draw("same");
     p2->Draw("same");
     leg1->Draw("same");
     c1->cd(2);
     const1->SetLineWidth(1);
     const2->SetLineWidth(1);
     TGraph* gr = (TGraph*)comb->DrawIntegral();
     gr->SetTitle("cumulative function of combined posterior with boundaries for cl = 95%;#epsilon;CDF");
     const1->Draw("same");
     const2->Draw("same");

     c1->cd(0);
     return c1;
}
