{
   auto c = new TCanvas("c","TGraph2DAsymmErrors example",0,0,600,600);

   Double_t P = 6.;
   const Int_t np   = 200;
   std::vector<Double_t> rx(np), ry(np), rz(np), exl(np), exh(np), eyl(np), eyh(np), ezl(np), ezh(np);
   TRandom r;

   for (Int_t N=0; N<np;N++) {
      rx[N] = 2*P*(r.Rndm(N))-P;
      ry[N] = 2*P*(r.Rndm(N))-P;
      rz[N] = rx[N]*rx[N]-ry[N]*ry[N];
      rx[N] += 10.;
      ry[N] += 10.;
      rz[N] += 40.;
      exl[N] = r.Rndm(N);
      exh[N] = r.Rndm(N);
      eyl[N] = r.Rndm(N);
      eyh[N] = r.Rndm(N);
      ezl[N] = 10*r.Rndm(N);
      ezh[N] = 10*r.Rndm(N);
   }

   auto g = new TGraph2DAsymmErrors(np, rx.data(), ry.data(), rz.data(), exl.data(), exh.data(), eyl.data(), eyh.data(), ezl.data(), ezh.data());

   g->SetTitle("TGraph2D with asymmetric error bars: option \"ERR\"");
   g->SetFillColor(29);
   g->SetMarkerSize(0.8);
   g->SetMarkerStyle(20);
   g->SetMarkerColor(kRed);
   g->SetLineColor(kBlue-3);
   g->SetLineWidth(2);
   gPad->SetLogy(1);
   g->Draw("err p0");
}
