{
   // A graph with 3 points
   Double_t xmin = 750.;
   Double_t xmax = 1000;
   auto g = new TGraph(3);
   g->SetPoint(0,xmin,0.1);
   g->SetPoint(1,845,0.06504);
   g->SetPoint(2,xmax,0.008);

   // The same graph with n points
   Int_t n = 10000;
   Double_t dx = (xmax-xmin)/n;
   Double_t x = xmin;
   auto g2 = new TGraph();
   for (Int_t i=0; i<n; i++) {
      g2->SetPoint(i, x, g->Eval(x));
      x = x + dx;
   }

   auto cv = new TCanvas("cv","cv",800,600);
   cv->SetLogy();
   cv->SetGridx();
   cv->SetGridy();
   g->Draw("AL*");

   g2->SetMarkerColor(kRed);
   g2->SetMarkerStyle(1);
   g2->Draw("P");
}

