
using namespace TMVA::Experimental;

void TMVA_SOFIE_ONNX(std::string inputFile = ""){
   if (inputFile.empty() )
      inputFile = std::string(gROOT->GetTutorialsDir()) + "/machine_learning/Linear_16.onnx";

    //Creating parser object to parse ONNX files
    SOFIE::RModelParser_ONNX parser;
    SOFIE::RModel model = parser.Parse(inputFile, true);

    //Generating inference code
    model.Generate();
    // write the code in a file (by default Linear_16.hxx and Linear_16.dat
    model.OutputGenerated();

    //Printing required input tensors
    model.PrintRequiredInputTensors();

    //Printing initialized tensors (weights)
    std::cout<<"\n\n";
    model.PrintInitializedTensors();

    //Printing intermediate tensors
    std::cout<<"\n\n";
    model.PrintIntermediateTensors();

    //Checking if tensor already exist in model
    std::cout<<"\n\nTensor \"16weight\" already exist: "<<std::boolalpha<<model.CheckIfTensorAlreadyExist("16weight")<<"\n\n";
    std::vector<size_t> tensorShape = model.GetTensorShape("16weight");
    std::cout<<"Shape of tensor \"16weight\": ";
    for(auto& it:tensorShape){
        std::cout<<it<<",";
    }
    std::cout<<"\n\nData type of tensor \"16weight\": ";
    SOFIE::ETensorType tensorType = model.GetTensorType("16weight");
    std::cout<<SOFIE::ConvertTypeToString(tensorType);

    //Printing generated inference code
    std::cout<<"\n\n";
    model.PrintGenerated();
}
