
void alice_esd()
{
   const char *esd_file_name = "http://root.cern/files/alice_ESDs.root";
   TFile::SetCacheFileDir(".");
   TString lib(Form("aliesd/aliesd.%s", gSystem->GetSoExt()));

   if (gSystem->AccessPathName(lib, kReadPermission)) {
      TFile *f = TFile::Open(esd_file_name, "CACHEREAD");
      if (!f)
         return;
      TTree *tree = (TTree *)f->Get("esdTree");
      tree->SetBranchStatus("ESDfriend*", 1);
      f->MakeProject("aliesd", "*", "++");
      f->Close();
      delete f;
   }
   gSystem->Load(lib.Data());
   gROOT->ProcessLine(".x run_alice_esd.C");
}
