
#include "TPSocket.h"

void authclient(const char *host = "up://localhost:3000", int sz = 0)
{
   Int_t par = (sz > 1) ? 1 : 0;

   // Parse protocol, if any
   TString proto(TUrl(host).GetProtocol());
   TString protosave = proto;

   // Get rid of authentication suffix
   TString asfx = proto;
   if (proto.EndsWith("up") || proto.EndsWith("ug")) {
      asfx.Remove(0,proto.Length()-2);
      proto.Resize(proto.Length()-2);
   } else if (proto.EndsWith("s") || proto.EndsWith("k") ||
              proto.EndsWith("g") || proto.EndsWith("h")) {
      asfx.Remove(0,proto.Length()-1);
      proto.Resize(proto.Length()-1);
   }

   // Force parallel (even of size 1)
   TString newurl = "p" + asfx;
   newurl += "://";
   if (strlen(TUrl(host).GetUser())) {
      newurl += TUrl(host).GetUser();
      newurl += "@";
   }
   newurl += TUrl(host).GetHost();
   newurl += ":";
   newurl += TUrl(host).GetPort();

   cout << "authclient: starting a (parallel) authenticated socket at "
        << newurl.Data() << " (size: " << sz << ")" << endl;

   TSocket *s = TSocket::CreateAuthSocket(newurl.Data(),sz);

   // Print out;
   if (s)
      if (s->IsAuthenticated())
         cout << "authclient: auth socket: OK" << endl;
      else
         cout << "authclient: auth socket: failed" << endl;

   // Cleanup
   if (s) {
      // Remove this authentication from the token list to avoid
      // later warnings
      s->GetSecContext()->DeActivate("R");
      delete s;
   }
}
