
int df010_trivialDataSource()
{
   auto nEvents = 128U;
   auto d_s = ROOT::RDF::MakeTrivialDataFrame(nEvents);

   /// Now we have a regular RDataFrame: the ingestion of data is delegated to
   /// the RDataSource. At this point everything works as before.
   auto h_s = d_s.Define("x", "1./(1. + col0)").Histo1D({"h_s", "h_s", 128, 0, .6}, "x");

   /// Now we redo the same with a RDF from scratch and we draw the two histograms
   ROOT::RDataFrame d(nEvents);

   /// This lambda redoes what the RTrivialDS provides
   auto g = []() {
      static ULong64_t i = 0;
      return i++;
   };
   auto h = d.Define("col0", g).Define("x", "1./(1. + col0)").Histo1D({"h", "h", 128, 0, .6}, "x");

   auto c_s = new TCanvas();
   c_s->SetLogy();
   h_s->DrawClone();

   auto c = new TCanvas();
   c->SetLogy();
   h->DrawClone();

   return 0;
}
