
void df019_Cache()
{
   // We create a data frame on top of the hsimple example.
   auto hsimplePath = gROOT->GetTutorialDir();
   hsimplePath += "/hsimple.root";
   ROOT::RDataFrame df("ntuple", hsimplePath.Data());

   // We apply a simple cut and define a new column.
   auto df_cut = df.Filter([](float py) { return py > 0.f; }, {"py"})
                    .Define("px_plus_py", [](float px, float py) { return px + py; }, {"px", "py"});

   // We cache the content of the dataset. Nothing has happened yet: the work to accomplish
   // has been described. As for `Snapshot`, the types and columns can be written out explicitly
   // or left for the jitting to handle (`df_cached` is intentionally unused - it shows how
   // to create a *cached* dataframe specifying column types explicitly):
   auto df_cached = df_cut.Cache<float, float>({"px_plus_py", "py"});
   auto df_cached_implicit = df_cut.Cache();
   auto h = df_cached_implicit.Histo1D<float>("px_plus_py");

   // Now the event loop on the cached dataset is triggered. This event triggers the loop
   // on the `df` data frame lazily.
   h->DrawCopy();
}
