
void df028_SQliteIPLocation() {

   auto rdf = ROOT::RDF::FromSqlite("http://root.cern/files/root_download_stats.sqlite", "SELECT * FROM accesslog;");

   auto f = TFile::Open("http://root.cern/files/WM.root");
   auto worldMap = f->Get<TH2Poly>("WMUSA");

   auto fillIPLocation = [&worldMap] ( const std::string &sLongitude, const std::string &sLatitude ) {
      if (!( sLongitude == "" ) && !( sLatitude == "" )) {
         auto latitude = std::stof(sLatitude);
         auto longitude = std::stof(sLongitude);
         worldMap->Fill(longitude, latitude);
      }
   };

   rdf.Foreach( fillIPLocation, { "IPLongitude", "IPLatitude" } );

   auto worldMapCanvas = new TCanvas();
   worldMapCanvas->SetLogz();
   worldMap->SetTitle("ROOT Downloads per Location (GitHub excluded);Longitude;Latitude");
   worldMap->DrawClone("colz");
}
