
void df030_SQliteVersionsOfROOT() {

   auto rdf =
      ROOT::RDF::FromSqlite("http://root.cern/files/root_download_stats.sqlite", "SELECT Version FROM accesslog;");

   TH1F hVersionOfRoot("hVersionOfRoot", "Development Versions of ROOT", 8, 0, -1);

   auto fillVersionHisto = [&hVersionOfRoot] (const std::string &version) {
      TString copyVersion = version;
      TString shortVersion(copyVersion(0,4));
      hVersionOfRoot.Fill(shortVersion, 1);
   };

   rdf.Foreach( fillVersionHisto, { "Version" } );

   auto VersionOfRootHistogram = new TCanvas();

   gStyle->SetOptStat(0);
   hVersionOfRoot.GetXaxis()->LabelsOption("a");
   hVersionOfRoot.LabelsDeflate("X");
   hVersionOfRoot.DrawClone("");
}
