
void glparametric()
{
   gStyle->SetCanvasPreferGL(kTRUE);
   TCanvas *c = new TCanvas("canvas", "Parametric surfaces with gl", 100, 10, 700, 700);
   c->SetFillColor(42);
   gStyle->SetFrameFillColor(42);

   c->Divide(2, 2);
   c->cd(1);
   TGLParametricEquation *p1 =
      new TGLParametricEquation("Conchoid", "1.2 ^ u * (1 + cos(v)) * cos(u)", "1.2 ^ u * (1 + cos(v)) * sin(u)",
                                "1.2 ^ u * sin(v) - 1.5 * 1.2 ^ u", 0., 6 * TMath::Pi(), 0., TMath::TwoPi());
   p1->Draw();

   c->cd(2);
   TGLParametricEquation *p2 =
      new TGLParametricEquation("Apple", "cos(u) * (4 + 3.8 * cos(v)) ", "sin(u) * (4 + 3.8 * cos(v))",
                                "(cos(v) + sin(v) - 1) * (1 + sin(v)) * log(1 - pi * v / 10) + 7.5 * sin(v)", 0,
                                TMath::TwoPi(), -TMath::Pi(), TMath::Pi());
   p2->Draw();

   c->cd(3);
   TGLParametricEquation *p3 = new TGLParametricEquation("Toupie", "(abs(u) - 1) ^ 2 * cos(v)",
                                                         "(abs(u) - 1) ^ 2 * sin(v)", "u", -1., 1., 0, TMath::TwoPi());
   p3->Draw();

   c->cd(4);
   TGLParametricEquation *p4 =
      new TGLParametricEquation("Trangluoid trefoil", "2 * sin(3 * u) / (2 + cos(v))",
                                "2 * (sin(u) + 2 * sin(2 * u)) / (2 + cos(v + 2 * pi / 3))",
                                "(cos(u) - 2 * cos(2 * u)) * (2 + cos(v)) * (2 + cos(v + 2 * pi / 3)) / 4",
                                -TMath::Pi(), TMath::Pi(), -TMath::Pi(), TMath::Pi());
   p4->Draw();
}
