
void klein_bottle(TGLVertex3 &dst, Double_t u, Double_t v)
{
   using namespace TMath;

   const Double_t r = 4. * (1. - Cos(u) / 2.);
   if (u < Pi()) {
      dst.X() = 6 * Cos(u) * (1. + Sin(u)) + r * Cos(u) * Cos(v);
      dst.Y() = 16 * Sin(u) + r * Sin(u) * Cos(v);
   } else {
      dst.X() = 6 * Cos(u) * (1. + Sin(u)) + r * Cos(v + Pi());
      dst.Y() = 16 * Sin(u);
   }
   dst.Z() = r * Sin(v);
}

void glparametrics2()
{
   gStyle->SetCanvasPreferGL(kTRUE);
   TCanvas *c = new TCanvas("canvas", "Parametric surfaces with gl", 100, 10, 700, 700);

   c->Divide(2, 2);
   c->cd(1);
   TGLParametricEquation *p1 =
      new TGLParametricEquation("Shell", "1.2 ^ v * sin(u) ^ 2 * sin(v)", "1.2 ^ v * sin(u) * cos(u)",
                                "1.2 ^ v * sin(u) ^ 2 * cos(v)", 0., TMath::Pi(), // 0 <= u <= pi
                                -TMath::Pi() / 4., 5 * TMath::Pi() / 2.);         // -pi/4 <= v <= 5*pi/2
   p1->Draw("");

   c->cd(2);
   TGLParametricEquation *p2 =
      new TGLParametricEquation("Limpet torus", "cos(u) / (sqrt(2) + sin(v))", "sin(u) / (sqrt(2) + sin(v))",
                                "1. / (sqrt(2) + cos(v))", -TMath::Pi(), TMath::Pi(), -TMath::Pi(), TMath::Pi());
   p2->Draw();

   c->cd(3);
   TGLParametricEquation *p3 =
      new TGLParametricEquation("Klein bottle", klein_bottle, 0., TMath::TwoPi(), 0., TMath::TwoPi());
   p3->Draw();

   c->cd(4);
   TGLParametricEquation *p4 = new TGLParametricEquation("Helicoid", "v * cos(u)", "v * sin(u)", "u", -3., 3., -3., 3.);
   p4->Draw();
}
