
void hist057_TExec_th1()
{
   if (!gPad) {
      Error("hist057_TExec_th1", "gPad is null, you are not supposed to run this macro");
      return;
   }

   Int_t event = gPad->GetEvent();
   int px = gPad->GetEventX();
   TObject *select = gPad->GetSelected();

   if (select && select->InheritsFrom(TH1::Class())) {
      TH1 *h = (TH1 *)select;
      Float_t xx = gPad->AbsPixeltoX(px);
      Float_t x = gPad->PadtoX(xx);
      Int_t binx = h->GetXaxis()->FindBin(x);
      printf("event=%d, hist:%s, bin=%d, content=%f\n", event, h->GetName(), binx, h->GetBinContent(binx));
   }
}
