
#include <ROOT/RCanvas.hxx>
#include <ROOT/RColor.hxx>
#include <ROOT/RLine.hxx>
#include <ROOT/RPadPos.hxx>
#include "TMath.h"

void rline()
{
   using namespace ROOT::Experimental;

   // Create a canvas to be displayed.
   auto canvas = RCanvas::Create("RLine example");

   for (double i = 0; i < 360; i += 1) {
      double angle = i * TMath::Pi() / 180;
      RColor col(50 + (int)i / 360 * 200, 0, 0);
      auto draw = canvas->Draw<RLine>();
      draw->SetP1({0.5_normal, 0.5_normal});
      draw->SetP2({0.5_normal + 0.3_normal * TMath::Cos(angle), 0.5_normal + 0.3_normal * TMath::Sin(angle)});
      draw->line.color = col;
   }

   canvas->Draw<RLine>()->SetP1({0.0_normal, 0.0_normal}).SetP2({1.0_normal, 1.0_normal});
   canvas->Draw<RLine>()->SetP1({0.1_normal, 0.1_normal}).SetP2({0.9_normal, 0.1_normal});
   canvas->Draw<RLine>()->SetP1({0.9_normal, 0.1_normal}).SetP2({0.9_normal, 0.9_normal});
   canvas->Draw<RLine>()->SetP1({0.9_normal, 0.9_normal}).SetP2({0.1_normal, 0.9_normal});
   canvas->Draw<RLine>()->SetP1({0.1_normal, 0.1_normal}).SetP2({0.1_normal, 0.9_normal});
   canvas->Draw<RLine>()->SetP1({0.0_normal, 1.0_normal}).SetP2({1.0_normal, 0.0_normal});

   canvas->SetSize(900, 700);

   if (canvas->SaveAs("line.png"))
      printf("Store RCanvas in line.png\n");

   canvas->Show();
}
