
void save_batch()
{
   // 37 canvases will be collected together for conversion
   TWebCanvas::BatchImageMode(37);

   auto c = new TCanvas("canvas", "Canvas with histogram");

   auto h1 = new TH1I("hist", "Histogram with random data", 100, -5., 5);
   h1->SetDirectory(nullptr);
   h1->FillRandom("gaus", 10000);
   h1->Draw();

   for (int n = 0; n < 100; ++n) {
      h1->FillRandom("gaus", 10000);
      c->SaveAs(TString::Format("batch_image_%03d.png", n));
   }

   // Important - disabling batch mode also flush remaining images
   TWebCanvas::BatchImageMode(0);
}
