
#include <iostream>
#include <TApplication.h>
#include <TGClient.h>
#include <TGButton.h>
#include <TGFrame.h>
#include <TGWindow.h>
#include <TString.h>
#include <TGTable.h>
#include <TTreeTableInterface.h>
#include <TFile.h>
#include <TNtuple.h>
#include <TSelectorDraw.h>

// A little class to automatically handle the generation of unique
// widget ids.
class IDList {
private:
   Int_t nID; // Generates unique widget IDs.
public:
   IDList() : nID(0) {}
   ~IDList() {}
   Int_t GetUnID(void) { return ++nID; }
};

class TableTest : public TGMainFrame {

private:
   IDList fIDs; // Generator for unique widget IDs.
   UInt_t fNTableRows;
   UInt_t fNTableColumns;
   TGTable *fTable;
   TFile *fFile;

   TTreeTableInterface *fInterface;

public:
   TableTest(const TGWindow *p, UInt_t ntrows, UInt_t ntcols, UInt_t w = 100, UInt_t h = 100);
   ~TableTest() override;

   void DoExit();

   TGTable *GetTable() { return fTable; }
   TTreeTableInterface *GetInterface() { return fInterface; }

   ClassDefOverride(TableTest, 0)
};

TableTest::TableTest(const TGWindow *p, UInt_t ntrows, UInt_t ntcols, UInt_t w, UInt_t h)
   : TGMainFrame(p, w, h), fNTableRows(ntrows), fNTableColumns(ntcols), fTable(nullptr)
{
   SetCleanup(kDeepCleanup);
   Connect("CloseWindow()", "TableTest", this, "DoExit()");
   DontCallClose();

   // Open root file for the tree
   fFile = new TFile("cernstaff.root");

   if (!fFile || fFile->IsZombie()) {
      printf("Please run <ROOT location>/tutorials/io/tree/tree500_cernbuild.C first.");
      return;
   }

   // Get the tree from the file.
   TTree *tree = (TTree *)fFile->Get("T");

   // Setup the expressions for the column and selection of the interface.
   TString varexp = "*";
   TString select = "";
   TString options = "";
   fInterface = new TTreeTableInterface(tree, varexp.Data(), select.Data(), options.Data());

   // Create a table using the interface and add it to the TableTest
   // that is a TGMainFrame.
   fTable = new TGTable(this, fIDs.GetUnID(), fInterface, fNTableRows, fNTableColumns);
   AddFrame(fTable, new TGLayoutHints(kLHintsExpandX | kLHintsExpandY));

   // Calls to layout and draw the TableTest that is a TGMainFrame.
   SetWindowName("Tree Table Test");
   MapSubwindows();
   Layout();
   Resize(GetDefaultWidth() + 20, 600);
   MapWindow();
};

TableTest::~TableTest()
{
   // Destructor
   delete fInterface;
   fFile->Close();
   Cleanup();
}

void TableTest::DoExit()
{
   // Exit this application via the Exit button or Window Manager.
   // Use one of the both lines according to your needs.
   // Please note to re-run this macro in the same ROOT session,
   // you have to compile it to get signals/slots 'on place'.

   DeleteWindow(); // to stay in the ROOT session
   //   gApplication->Terminate();   // to exit and close the ROOT session
}

TGTable *staffTableTest(UInt_t ntrows = 50, UInt_t ntcols = 10)
{
   TableTest *test = new TableTest(nullptr, ntrows, ntcols, 500, 200);
   return test->GetTable();
}
