
void tree() {
   TCanvas* c1 = new TCanvas("c1","Tree Data Structure",200,10,750,940);
   c1->Range(0,-0.1,1,1.15);

   gBenchmark->Start("tree");

   Int_t branchcolor = 26;
   Int_t leafcolor   = 30;
   Int_t basketcolor = 42;
   Int_t offsetcolor = 43;
   TPaveLabel* title = new TPaveLabel(.3,1.05,.8,1.13,c1->GetTitle());
   title->SetFillColor(16);
   title->Draw();
   TPaveText* treePave = new TPaveText(.01,.75,.15,1.00);
   treePave->SetFillColor(18);
   treePave->SetTextAlign(12);
   TText *tnt = treePave->AddText("Tree");
   tnt->SetTextAlign(22);
   tnt->SetTextSize(0.030);
   treePave->AddText("fScanField");
   treePave->AddText("fMaxEventLoop");
   treePave->AddText("fMaxVirtualSize");
   treePave->AddText("fEntries");
   treePave->AddText("fDimension");
   treePave->AddText("fSelectedRows");
   treePave->Draw();
   TPavesText* farm = new TPavesText(.01,1.02,.15,1.1,9,"tr");
   TText *tfarm = farm->AddText("CHAIN");
   tfarm->SetTextSize(0.024);
   farm->AddText("Collection");
   farm->AddText("of Trees");
   farm->Draw();
   TLine* llink = new TLine(.15,.92,.80,.92);
   llink->SetLineWidth(2);
   llink->SetLineColor(1);
   llink->Draw();
   llink->DrawLine(.21,.87,.21,.275);
   llink->DrawLine(.23,.87,.23,.375);
   llink->DrawLine(.25,.87,.25,.805);
   llink->DrawLine(.41,.25,.41,-.025);
   llink->DrawLine(.43,.25,.43,.075);
   llink->DrawLine(.45,.25,.45,.175);
   TPaveLabel* branch0 = new TPaveLabel(.20,.87,.35,.97,"Branch 0");
   branch0->SetTextSize(0.35);
   branch0->SetFillColor(branchcolor);
   branch0->Draw();
   TPaveLabel* branch1 = new TPaveLabel(.40,.87,.55,.97,"Branch 1");
   branch1->SetTextSize(0.35);
   branch1->SetFillColor(branchcolor);
   branch1->Draw();
   TPaveLabel* branch2 = new TPaveLabel(.60,.87,.75,.97,"Branch 2");
   branch2->SetTextSize(0.35);
   branch2->SetFillColor(branchcolor);
   branch2->Draw();
   TPaveLabel* branch3 = new TPaveLabel(.80,.87,.95,.97,"Branch 3");
   branch3->SetTextSize(0.35);
   branch3->SetFillColor(branchcolor);
   branch3->Draw();
   TPaveLabel* leaf0 = new TPaveLabel(.4,.78,.5,.83,"Leaf 0");
   leaf0->SetFillColor(leafcolor);
   leaf0->Draw();
   TPaveLabel* leaf1 = new TPaveLabel(.6,.78,.7,.83,"Leaf 1");
   leaf1->SetFillColor(leafcolor);
   leaf1->Draw();
   TPaveLabel* leaf2 = new TPaveLabel(.8,.78,.9,.83,"Leaf 2");
   leaf2->SetFillColor(leafcolor);
   leaf2->Draw();
   TPaveText* firstevent = new TPaveText(.4,.35,.9,.4);
   firstevent->AddText("First event of each basket");
   firstevent->AddText("Array of fMaxBaskets Integers");
   firstevent->SetFillColor(basketcolor);
   firstevent->Draw();
   TPaveLabel* basket0 = new TPaveLabel(.4,.25,.5,.3,"Basket 0");
   basket0->SetFillColor(basketcolor);
   basket0->Draw();
   TPaveLabel* basket1 = new TPaveLabel(.6,.25,.7,.3,"Basket 1");
   basket1->SetFillColor(basketcolor);
   basket1->Draw();
   TPaveLabel* basket2 = new TPaveLabel(.8,.25,.9,.3,"Basket 2");
   basket2->SetFillColor(basketcolor);
   basket2->Draw();

   TPaveText* offset = new TPaveText(.55,.15,.9,.2);
   offset->AddText("Offset of events in fBuffer");
   offset->AddText("Array of fEventOffsetLen Integers");
   offset->AddText("(if variable length structure)");
   offset->SetFillColor(offsetcolor);
   offset->Draw();
   TPaveText* buffer = new TPaveText(.55,.05,.9,.1);
   buffer->AddText("Basket buffer");
   buffer->AddText("Array of fBasketSize chars");
   buffer->SetFillColor(offsetcolor);
   buffer->Draw();
   TPaveText* zipbuffer = new TPaveText(.55,-.05,.75,.0);
   zipbuffer->AddText("Basket compressed buffer");
   zipbuffer->AddText("(if compression)");
   zipbuffer->SetFillColor(offsetcolor);
   zipbuffer->Draw();
   TArrow ar1;
   ar1.SetLineWidth(2);
   ar1.SetLineColor(1);
   ar1.SetFillStyle(1001);
   ar1.SetFillColor(1);
   ar1.DrawArrow(.21,.275,.39,.275,0.015,"|>");
   ar1.DrawArrow(.23,.375,.39,.375,0.015,"|>");
   ar1.DrawArrow(.25,.805,.39,.805,0.015,"|>");
   ar1.DrawArrow(.50,.805,.59,.805,0.015,"|>");
   ar1.DrawArrow(.70,.805,.79,.805,0.015,"|>");
   ar1.DrawArrow(.50,.275,.59,.275,0.015,"|>");
   ar1.DrawArrow(.70,.275,.79,.275,0.015,"|>");
   ar1.DrawArrow(.45,.175,.54,.175,0.015,"|>");
   ar1.DrawArrow(.43,.075,.54,.075,0.015,"|>");
   ar1.DrawArrow(.41,-.025,.54,-.025,0.015,"|>");
   TLine* ldot = new TLine(.95,.92,.99,.92);
   ldot->SetLineStyle(kDotted);
   ldot->Draw();
   ldot->DrawLine(.9,.805,.99,.805);
   ldot->DrawLine(.9,.275,.99,.275);
   ldot->DrawLine(.55,.05,.55,0);
   ldot->DrawLine(.9,.05,.75,0);
   TText* pname = new TText(.46,.21,"fEventOffset");
   pname->SetTextFont(72);
   pname->SetTextSize(0.018);
   pname->Draw();
   pname->DrawText(.44,.11,"fBuffer");
   pname->DrawText(.42,.01,"fZipBuffer");
   pname->DrawText(.26,.84,"fLeaves = TObjArray of TLeaf");
   pname->DrawText(.24,.40,"fBasketEvent");
   pname->DrawText(.22,.31,"fBaskets = TObjArray of TBasket");
   pname->DrawText(.20,1.0,"fBranches = TObjArray of TBranch");
   TPaveText* ntleaf = new TPaveText(0.30,.42,.62,.73);
   ntleaf->SetTextSize(0.014);
   ntleaf->SetFillColor(leafcolor);
   ntleaf->SetTextAlign(12);
   ntleaf->AddText("fLen: number of fixed elements");
   ntleaf->AddText("fLenType: number of bytes of data type");
   ntleaf->AddText("fOffset: relative to Leaf0-fAddress");
   ntleaf->AddText("fNbytesIO: number of bytes used for I/O");
   ntleaf->AddText("fIsPointer: True if pointer");
   ntleaf->AddText("fIsRange: True if leaf has a range");
   ntleaf->AddText("fIsUnsigned: True if unsigned");
   ntleaf->AddText("*fLeafCount: points to Leaf counter");
   ntleaf->AddText(" ");
   ntleaf->AddLine(0,0,0,0);
   ntleaf->AddText("fName = Leaf name");
   ntleaf->AddText("fTitle = Leaf type (see Type codes)");
   ntleaf->Draw();
   TPaveText* type = new TPaveText(.65,.42,.95,.73);
   type->SetTextAlign(12);
   type->SetFillColor(leafcolor);
   type->AddText(" ");
   type->AddText("C : a character string");
   type->AddText("B : an 8 bit signed integer");
   type->AddText("b : an 8 bit unsigned integer");
   type->AddText("S : a 16 bit signed short integer");
   type->AddText("s : a 16 bit unsigned short integer");
   type->AddText("I : a 32 bit signed integer");
   type->AddText("i : a 32 bit unsigned integer");
   type->AddText("F : a 32 bit floating point");
   type->AddText("f : a 24 bit truncated float");
   type->AddText("D : a 64 bit floating point");
   type->AddText("d : a 24 bit truncated double");
   type->AddText("TXXXX : a class name TXXXX");
   type->Draw();
   TPaveLabel* typecode = new TPaveLabel(.7,.71,.9,.75,"fType codes");
   typecode->SetFillColor(leafcolor);
   typecode->Draw();
   ldot->DrawLine(.4,.78,.30,.73);
   ldot->DrawLine(.5,.78,.62,.73);
   TPaveText* ntbasket = new TPaveText(0.02,-0.07,0.35,.25);
   ntbasket->SetFillColor(basketcolor);
   ntbasket->SetTextSize(0.014);
   ntbasket->SetTextAlign(12);
   ntbasket->AddText("fNbytes: Size of compressed Basket");
   ntbasket->AddText("fObjLen: Size of uncompressed Basket");
   ntbasket->AddText("fDatime: Date/Time when written to store");
   ntbasket->AddText("fKeylen: Number of bytes for the key");
   ntbasket->AddText("fCycle : Cycle number");
   ntbasket->AddText("fSeekKey: Pointer to Basket on file");
   ntbasket->AddText("fSeekPdir: Pointer to directory on file");
   ntbasket->AddText("fClassName: 'TBasket'");
   ntbasket->AddText("fName: Branch name");
   ntbasket->AddText("fTitle: TreePave name");
   ntbasket->AddText(" ");
   ntbasket->AddLine(0,0,0,0);
   ntbasket->AddText("fNevBuf: Number of events in Basket");
   ntbasket->AddText("fLast: pointer to last used byte in Basket");
   ntbasket->Draw();
   ldot->DrawLine(.4,.3,0.02,0.25);
   ldot->DrawLine(.5,.25,0.35,-.07);
   ldot->DrawLine(.5,.3,0.35,0.25);
   TPaveText* ntbranch = new TPaveText(0.02,0.40,0.18,0.68);
   ntbranch->SetFillColor(branchcolor);
   ntbranch->SetTextSize(0.015);
   ntbranch->SetTextAlign(12);
   ntbranch->AddText("fBasketSize");
   ntbranch->AddText("fEventOffsetLen");
   ntbranch->AddText("fMaxBaskets");
   ntbranch->AddText("fEntries");
   ntbranch->AddText("fAddress of Leaf0");
   ntbranch->AddText(" ");
   ntbranch->AddLine(0,0,0,0);
   ntbranch->AddText("fName: Branchname");
   ntbranch->AddText("fTitle: leaflist");
   ntbranch->Draw();
   ldot->DrawLine(.2,.97,.02,.68);
   ldot->DrawLine(.35,.97,.18,.68);
   ldot->DrawLine(.35,.87,.18,.40);
   TPavesText* basketstore = new TPavesText(.8,-0.088,0.952,-0.0035,7,"tr");
   basketstore->SetFillColor(28);
   basketstore->AddText("Baskets");
   basketstore->AddText("Stores");
   basketstore->Draw();
   c1->Update();

   gBenchmark->Show("treePave");
}
