
#ifdef ACTUAL_RUN  // -------- Second pass: dictionary already built --------

#include "./Event.h"  // now safe to include Event, its dictionary is loaded

void run()
{
   TFile oldfile("tree108.root");
   TTree *oldtree;
   oldfile.GetObject("t4", oldtree);

   // Activate only four of them
   for (auto activeBranchName : {"event_split", "fNtrack", "fNseg", "fH"}) {
      oldtree->SetBranchStatus(activeBranchName, 1);
   }

   // Create a new file + a clone of old tree header. Do not copy events
   TFile newfile("tree111.root", "recreate");
   auto newtree = oldtree->CloneTree(0);

   // Divert branch fH to a separate file and copy all events
   newtree->GetBranch("fH")->SetFile("small_fH.root");
   newtree->CopyEntries(oldtree);

   newtree->Print();
   newfile.Write();
}

#else  // -------- First pass: build dictionary + rerun macro --------

void tree111_copy()
{
   TString tutdir = gROOT->GetTutorialDir();
   gROOT->ProcessLine(".L " + tutdir + "/io/tree/Event.cxx+");
   gROOT->ProcessLine("#define ACTUAL_RUN yes");
   gROOT->ProcessLine("#include \"" __FILE__ "\"");
   gROOT->ProcessLine("run()");
}

#endif
