
#include "TFile.h"
#include "TClonesArray.h"
#include "TH2.h"
#include "TLine.h"
#include "TTree.h"
#include "TBenchmark.h"
#include "TRandom.h"

void write_clonesarray(Int_t split)
{
   // Generate a Tree with a TClonesArray
   // The array can be split or not
   TFile f("clonesarray.root", "recreate");
   f.SetCompressionLevel(1); //try level 2 also
   TTree T("T", "test clonesarray");
   TClonesArray *arr = new TClonesArray("TLine");
   TClonesArray &ar = *arr;
   T.Branch("tcl", &arr, 256000, split);
   // By default a TClonesArray is created with its BypassStreamer bit set.
   // However, because TLine has a custom Streamer, this bit was reset
   // by TTree::Branch above. We set again this bit because the current
   // version of TLine uses the automatic Streamer.
   // BypassingStreamer saves space and time.
   arr->BypassStreamer();
   for (Int_t ev=0; ev<10000; ev++) {
      ar.Clear();
      Int_t nlines = Int_t(gRandom->Gaus(50,10));
      if(nlines < 0)
         nlines = 1;
      for (Int_t i=0;i<nlines;i++) {
         Float_t x1 = gRandom->Rndm();
         Float_t y1 = gRandom->Rndm();
         Float_t x2 = gRandom->Rndm();
         Float_t y2 = gRandom->Rndm();
         new(ar[i]) TLine(x1, y1, x2, y2);
      }
      T.Fill();
   }
   T.Print();
   T.Write();
}

void read_clonesarray()
{
   // read file generated by write_clonesarray
   // loop on all entries.
   // histogram center of lines
   auto f = new TFile("clonesarray.root");
   auto T = f->Get<TTree>("T");
   auto h2 = new TH2F("h2", "center of lines", 40, 0, 1, 40, 0, 1);

   auto arr = new TClonesArray("TLine");
   T->GetBranch("tcl")->SetAutoDelete(kFALSE);
   T->SetBranchAddress("tcl", &arr);
   Long64_t nentries = T->GetEntries();
   for (Long64_t ev=0; ev<nentries; ev++) {
      arr->Clear();
      T->GetEntry(ev);
      Int_t nlines = arr->GetEntriesFast();
      for (Int_t i=0; i<nlines; i++) {
         TLine *line = (TLine*)arr->At(i);
         h2->Fill(0.5 * (line->GetX1() + line->GetX2()), 0.5 * (line->GetY1() + line->GetY2()));
      }
   }
   h2->Draw("lego");
}

void tree123_clonesarray(Int_t split = 0)
{
   gBenchmark->Start("clonesarray");
   write_clonesarray(split);
   read_clonesarray();
   gBenchmark->Show("clonesarray");
}
