/*****************************************************************************
 * Project: RooFit                                                           *
 *                                                                           *
 * This code was autogenerated by RooClassFactory                            *
 *****************************************************************************/

// Your description goes here...

#include "MyPdfV3.h"

#include <RooAbsReal.h>
#include <RooAbsCategory.h>

#include <Riostream.h>
#include <TMath.h>

#include <cmath>


MyPdfV3::MyPdfV3(const char *name, const char *title,
                        RooAbsReal& _x,
                        RooAbsReal& _A,
                        RooAbsReal& _B)
   : RooAbsPdf(name,title),
   x("x","x",this,_x),
   A("A","A",this,_A),
   B("B","B",this,_B)
{
}

MyPdfV3::MyPdfV3(MyPdfV3 const &other, const char *name)
   : RooAbsPdf(other,name),
   x("x",this,other.x),
   A("A",this,other.A),
   B("B",this,other.B)
{
}


double MyPdfV3::evaluate() const 
{
   return MyPdfV3_evaluate(x, A, B);
}

void MyPdfV3::doEval(RooFit::EvalContext &ctx) const
{
   std::span<const double> xSpan = ctx.at(x);
   std::span<const double> ASpan = ctx.at(A);
   std::span<const double> BSpan = ctx.at(B);

   std::size_t n = ctx.output().size();
   for (std::size_t i = 0; i < n; ++i) {
      ctx.output()[i] = MyPdfV3_evaluate(xSpan.size() > 1 ? xSpan[i] : xSpan[0],
                               ASpan.size() > 1 ? ASpan[i] : ASpan[0],
                               BSpan.size() > 1 ? BSpan[i] : BSpan[0]);
   }
}
void RooFit::Experimental::codegenImpl(MyPdfV3 &arg, RooFit::Experimental::CodegenContext &ctx)
{
   ctx.addResult(&arg, ctx.buildCall("MyPdfV3_evaluate", arg.x, arg.A, arg.B));
}

int MyPdfV3::getAnalyticalIntegral(RooArgSet& allVars, RooArgSet& analVars, const char */*rangeName*/) const
{
   // Support also using the imaginary unit
   using namespace std::complex_literals;
   // To be able to also comile C code, we define a variable that behaves like the "I" macro from C.
   constexpr auto I = 1i;

   // LIST HERE OVER WHICH VARIABLES ANALYTICAL INTEGRATION IS SUPPORTED,
   // ASSIGN A NUMERIC CODE FOR EACH SUPPORTED (SET OF) PARAMETERS. THE EXAMPLE
   // BELOW ASSIGNS CODE 1 TO INTEGRATION OVER VARIABLE X YOU CAN ALSO
   // IMPLEMENT MORE THAN ONE ANALYTICAL INTEGRAL BY REPEATING THE matchArgs
   // EXPRESSION MULTIPLE TIMES.
   if (matchArgs(allVars,analVars,x)) return 1 ; 
   return 0 ; 
} 


double MyPdfV3::analyticalIntegral(int code, const char *rangeName) const
{
  // RETURN ANALYTICAL INTEGRAL DEFINED BY RETURN CODE ASSIGNED BY
  // getAnalyticalIntegral(). THE MEMBER FUNCTION x.min(rangeName) AND
  // x.max(rangeName) WILL RETURN THE INTEGRATION BOUNDARIES FOR EACH
  // OBSERVABLE x.
   if (code==1) { return ((A/2)*(pow(x.max(rangeName),2)+pow(x.min(rangeName),2))+(1./3)*(pow(x.max(rangeName)-B,3)-pow(x.min(rangeName)-B,3))) ; } 
   return 0 ; 
} 
