/*****************************************************************************
 * Project: RooFit                                                           *
 *                                                                           *
 * This code was autogenerated by RooClassFactory                            *
 *****************************************************************************/

// Your description goes here...

#include "RooGenPdfPdf.h"

#include <RooAbsReal.h>
#include <RooAbsCategory.h>

#include <Riostream.h>
#include <TMath.h>

#include <cmath>


RooGenPdfPdf::RooGenPdfPdf(const char *name, const char *title,
                        RooAbsReal& _x,
                        RooAbsReal& _alpha)
   : RooAbsPdf(name,title),
   x("x","x",this,_x),
   alpha("alpha","alpha",this,_alpha)
{
}

RooGenPdfPdf::RooGenPdfPdf(RooGenPdfPdf const &other, const char *name)
   : RooAbsPdf(other,name),
   x("x",this,other.x),
   alpha("alpha",this,other.alpha)
{
}


double RooGenPdfPdf::evaluate() const 
{
   return RooGenPdfPdf_evaluate(x, alpha);
}

void RooGenPdfPdf::doEval(RooFit::EvalContext &ctx) const
{
   std::span<const double> xSpan = ctx.at(x);
   std::span<const double> alphaSpan = ctx.at(alpha);

   std::size_t n = ctx.output().size();
   for (std::size_t i = 0; i < n; ++i) {
      ctx.output()[i] = RooGenPdfPdf_evaluate(xSpan.size() > 1 ? xSpan[i] : xSpan[0],
                               alphaSpan.size() > 1 ? alphaSpan[i] : alphaSpan[0]);
   }
}
void RooFit::Experimental::codegenImpl(RooGenPdfPdf &arg, RooFit::Experimental::CodegenContext &ctx)
{
   ctx.addResult(&arg, ctx.buildCall("RooGenPdfPdf_evaluate", arg.x, arg.alpha));
}
