// Class: ReadBDTB
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTB
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:56:04 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "2000" [Number of trees in the forest]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Bagging" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
MaxDepth: "3" [Max depth of the decision tree allowed]
MinNodeSize: "5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTBNode

#ifndef BDTBNode__def
#define BDTBNode__def

class BDTBNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTBNode ( BDTBNode* left,BDTBNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTBNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTBNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTBNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTBNode*   fLeft;     // pointer to the left daughter node
   BDTBNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTBNode::~BDTBNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTBNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTBNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTB : public IClassifierReader {

 public:

   // constructor
   ReadBDTB( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTB" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTB() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTBNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTB::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTBNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTBNode*)current->GetRight();
         else current=(BDTBNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDTB::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84961, 0, 1, 0.826059,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296495,-99) , 
0, 0.245926, 1, 0, 0.540271,-99) , 
3, 0.829532, 0, 0, 0.674886,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203261,-99) , 
0, -1.19072, 1, 0, 0.364423,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.104296,-99) , 
3, -1.01782, 0, 0, 0.227476,-99) , 
3, -0.28269, 0, 0, 0.493127,-99)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.880272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.906869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438251,-99) , 
0, 1.11302, 1, 0, 0.712381,-99) , 
3, 1.3355, 0, 0, 0.802315,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296541,-99) , 
0, -0.128842, 1, 0, 0.498363,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.169377,-99) , 
3, -0.49939, 0, 0, 0.335907,-99) , 
3, 0.638168, 0, 0, 0.506192,-99)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.875273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454832,-99) , 
0, 0.630164, 1, 0, 0.679517,-99) , 
3, 0.982911, 0, 0, 0.78902,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309912,-99) , 
1, 0.00293303, 1, 0, 0.434306,-99) , 
NN(
0, 
0, 
-1, -1.32334, 0, -1, 0.148364,-99) , 
3, -0.629118, 0, 0, 0.259001,-99) , 
3, 0.178444, 0, 0, 0.506397,-99)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55271, 1, 1, 0.8535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475347,-99) , 
0, 1.10293, 1, 0, 0.706272,-99) , 
3, 1.27254, 0, 0, 0.769716,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327508,-99) , 
0, -1.19434, 1, 0, 0.391834,-99) , 
NN(
0, 
0, 
-1, 0.140063, 1, -1, 0.110679,-99) , 
3, -0.959342, 0, 0, 0.279662,-99) , 
3, 0.301115, 0, 0, 0.493844,-99)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58646, 0, 1, 0.857204,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367361,-99) , 
0, 0.871083, 1, 0, 0.582156,-99) , 
3, 1.10862, 0, 0, 0.677964,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.203106,-99) , 
3, -0.202496, 0, 0, 0.48908,-99)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37651, 0, 1, 0.85033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376122,-99) , 
2, 0.422836, 1, 0, 0.56448,-99) , 
3, 0.845703, 0, 0, 0.69162,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.200885,-99) , 
3, -0.304384, 0, 0, 0.497992,-99)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21713, 1, 1, 0.823153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468391,-99) , 
0, 0.2857, 1, 0, 0.646256,-99) , 
3, 0.794773, 0, 0, 0.757404,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324637,-99) , 
0, -0.813057, 1, 0, 0.473652,-99) , 
NN(
0, 
0, 
-1, -0.981869, 0, -1, 0.190307,-99) , 
3, -0.40511, 0, 0, 0.305793,-99) , 
3, 0.218994, 0, 0, 0.506129,-99)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.866317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380041,-99) , 
0, 0.492106, 1, 0, 0.608384,-99) , 
3, 1.06561, 0, 0, 0.718143,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231742,-99) , 
0, -1.43519, 1, 0, 0.34415,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.119847,-99) , 
3, -1.0333, 0, 0, 0.250883,-99) , 
3, 0.0509667, 0, 0, 0.493149,-99)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51859, 1, 1, 0.799124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312654,-99) , 
0, 0.245926, 1, 0, 0.552096,-99) , 
3, 0.66689, 0, 0, 0.68755,-99) , 
NN(
0, 
0, 
-1, -0.802175, 0, -1, 0.196238,-99) , 
3, -0.207894, 0, 0, 0.477115,-99)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.618662, 1, 1, 0.875566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331284,-99) , 
3, 1.16665, 0, 0, 0.666671,-99) , 
0, 1.05086, 1, 0, 0.75126,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347196,-99) , 
0, -0.831231, 1, 0, 0.454686,-99) , 
NN(
0, 
0, 
-1, -1.48549, 0, -1, 0.186307,-99) , 
3, -0.556192, 0, 0, 0.308854,-99) , 
3, 0.262941, 0, 0, 0.517839,-99)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.558, 1, 1, 0.834758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400723,-99) , 
0, -0.0708108, 1, 0, 0.576113,-99) , 
3, 0.779005, 0, 0, 0.71163,-99) , 
NN(
0, 
0, 
-1, -0.841941, 0, -1, 0.204902,-99) , 
3, -0.10679, 0, 0, 0.479498,-99)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.85558,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286465,-99) , 
0, 0.781704, 1, 0, 0.57853,-99) , 
3, 0.985321, 0, 0, 0.708164,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.221953,-99) , 
3, -0.123397, 0, 0, 0.500631,-99)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66617, 0, 1, 0.828484,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294191,-99) , 
0, 0.26745, 1, 0, 0.506218,-99) , 
NN(
0, 
0, 
-1, -1.11701, 0, -1, 0.170703,-99) , 
3, -0.543589, 0, 0, 0.351169,-99) , 
3, 0.816421, 0, 0, 0.509106,-99)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.699768, 0, 1, 0.770935,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165974,-99) , 
0, -0.115966, 1, 0, 0.416317,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0772585,-99) , 
3, -0.957285, 0, 0, 0.291506,-99) , 
3, 0.306962, 0, 0, 0.498806,-99)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.79293, 0, 1, 0.846933,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250737,-99) , 
0, 0.738333, 1, 0, 0.56285,-99) , 
3, 0.983057, 0, 0, 0.67122,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.147779,-99) , 
3, -0.376892, 0, 0, 0.488692,-99)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.884411, 1, 1, 0.837654,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368716,-99) , 
0, 0.259256, 1, 0, 0.570012,-99) , 
3, 0.842139, 0, 0, 0.681858,-99) , 
NN(
0, 
0, 
-1, -2.20591, 1, -1, 0.166925,-99) , 
3, -0.639447, 0, 0, 0.550763,-99)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.612721, 1, 1, 0.918724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378776,-99) , 
3, 1.2268, 0, 0, 0.693397,-99) , 
0, 1.30206, 1, 0, 0.785169,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320564,-99) , 
1, -0.279191, 1, 0, 0.472962,-99) , 
NN(
0, 
0, 
-1, -1.11701, 0, -1, 0.179876,-99) , 
3, -0.568884, 0, 0, 0.311931,-99) , 
3, 0.392653, 0, 0, 0.515552,-99)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.868746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386368,-99) , 
0, 0.82791, 1, 0, 0.6504,-99) , 
3, 1.12671, 0, 0, 0.750062,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292227,-99) , 
0, -1.00281, 1, 0, 0.427625,-99) , 
NN(
0, 
0, 
-1, -0.767649, 1, -1, 0.168365,-99) , 
3, -0.726681, 0, 0, 0.284909,-99) , 
3, 0.0990605, 0, 0, 0.526189,-99)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50515, 1, 1, 0.865695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357737,-99) , 
0, 0.84413, 1, 0, 0.652216,-99) , 
3, 1.21404, 0, 0, 0.731973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628575,-99) , 
NN(
0, 
0, 
-1, -1.4274, 0, -1, 0.238701,-99) , 
3, -0.11055, 0, 0, 0.295776,-99) , 
3, 0.17816, 0, 0, 0.510024,-99)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32521, 0, 1, 0.848282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308982,-99) , 
0, 0.708301, 1, 0, 0.571221,-99) , 
3, 0.98804, 0, 0, 0.689347,-99) , 
NN(
0, 
0, 
-1, -0.837685, 1, -1, 0.252887,-99) , 
3, -0.123397, 0, 0, 0.502673,-99)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.892785,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315289,-99) , 
0, 0.848875, 1, 0, 0.611677,-99) , 
3, 1.31981, 0, 0, 0.694291,-99) , 
NN(
0, 
0, 
-1, -0.259045, 1, -1, 0.175228,-99) , 
3, -0.304384, 0, 0, 0.493739,-99)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74111, 1, 1, 0.85579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350651,-99) , 
0, 0.931718, 1, 0, 0.564395,-99) , 
3, 1.20559, 0, 0, 0.649636,-99) , 
NN(
0, 
0, 
-1, -1.77981, 1, -1, 0.157386,-99) , 
3, -0.38184, 0, 0, 0.471989,-99)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74389, 1, 1, 0.801183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298857,-99) , 
0, -0.0391583, 1, 0, 0.491427,-99) , 
3, 0.526823, 0, 0, 0.681198,-99) , 
NN(
0, 
0, 
-1, -1.16324, 0, -1, 0.178982,-99) , 
3, -0.38184, 0, 0, 0.495848,-99)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.867535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495251,-99) , 
0, 0.2203, 1, 0, 0.621476,-99) , 
3, 1.07833, 0, 0, 0.748544,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280977,-99) , 
0, -1.22675, 1, 0, 0.380782,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.121277,-99) , 
3, -1.08906, 0, 0, 0.284621,-99) , 
3, 0.262941, 0, 0, 0.491165,-99)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.974395, 0, 1, 0.880045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413703,-99) , 
3, 1.29764, 0, 0, 0.727172,-99) , 
0, 1.17756, 1, 0, 0.794127,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2873,-99) , 
0, -0.765399, 1, 0, 0.39288,-99) , 
NN(
0, 
0, 
-1, -1.66445, 0, -1, 0.139939,-99) , 
3, -0.887574, 0, 0, 0.290759,-99) , 
3, 0.392653, 0, 0, 0.500009,-99)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12199, 1, 1, 0.852795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433728,-99) , 
0, 0.733197, 1, 0, 0.657203,-99) , 
3, 1.20395, 0, 0, 0.725944,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.215655,-99) , 
3, -0.123397, 0, 0, 0.506541,-99)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40187, 1, 1, 0.864307,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271257,-99) , 
0, 0.957246, 1, 0, 0.580523,-99) , 
3, 1.07541, 0, 0, 0.682871,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.181785,-99) , 
3, -0.304384, 0, 0, 0.492953,-99)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.876947,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34182,-99) , 
0, 1.02702, 1, 0, 0.637674,-99) , 
3, 1.36979, 0, 0, 0.71452,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186016,-99) , 
0, -1.30493, 1, 0, 0.3218,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.0918851,-99) , 
3, -0.955363, 0, 0, 0.212387,-99) , 
3, -0.210183, 0, 0, 0.513731,-99)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.250902, 1, 1, 0.901802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367046,-99) , 
3, 1.20439, 0, 0, 0.670044,-99) , 
0, 0.811023, 1, 0, 0.749085,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297272,-99) , 
1, -0.252733, 1, 0, 0.419344,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.168551,-99) , 
3, -0.386214, 0, 0, 0.259081,-99) , 
3, 0.238103, 0, 0, 0.472464,-99)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.851573,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479211,-99) , 
0, -0.0920449, 1, 0, 0.580047,-99) , 
3, 1.10955, 0, 0, 0.676487,-99) , 
NN(
0, 
0, 
-1, -0.502825, 0, -1, 0.184021,-99) , 
3, -0.207894, 0, 0, 0.474207,-99)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90497, 1, 1, 0.869772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479189,-99) , 
0, 0.502045, 1, 0, 0.649082,-99) , 
3, 1.06907, 0, 0, 0.745319,-99) , 
NN(
0, 
0, 
-1, -0.505712, 0, -1, 0.237006,-99) , 
3, 0.0509667, 0, 0, 0.486882,-99)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48309, 0, 1, 0.790109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265272,-99) , 
0, 0.281825, 1, 0, 0.529454,-99) , 
3, 0.761669, 0, 0, 0.674541,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.205895,-99) , 
3, -0.123397, 0, 0, 0.49068,-99)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.235551, 0, 1, 0.727792,-99) , 
NN(
0, 
0, 
-1, -1.07872, 0, -1, 0.215747,-99) , 
3, -0.202496, 0, 0, 0.518787,-99)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.83843, 1, 1, 0.91104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474014,-99) , 
0, 0.191795, 1, 0, 0.603175,-99) , 
3, 1.43185, 0, 0, 0.686458,-99) , 
NN(
0, 
0, 
-1, -1.1339, 0, -1, 0.206316,-99) , 
3, -0.38184, 0, 0, 0.533152,-99)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.881057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345433,-99) , 
0, 0.957246, 1, 0, 0.641634,-99) , 
3, 1.42509, 0, 0, 0.712657,-99) , 
NN(
0, 
0, 
-1, -0.419849, 0, -1, 0.231728,-99) , 
3, -0.123397, 0, 0, 0.486829,-99)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.881768,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399633,-99) , 
0, 0.859775, 1, 0, 0.680249,-99) , 
3, 1.31846, 0, 0, 0.754921,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291323,-99) , 
0, -1.37656, 1, 0, 0.360829,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.116888,-99) , 
3, -0.997451, 0, 0, 0.269723,-99) , 
3, 0.093663, 0, 0, 0.517662,-99)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.887323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440565,-99) , 
0, 0.373872, 1, 0, 0.59822,-99) , 
3, 1.3205, 0, 0, 0.694422,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136636,-99) , 
0, -1.20513, 1, 0, 0.283083,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0902083,-99) , 
3, -1.08414, 0, 0, 0.190385,-99) , 
3, -0.207894, 0, 0, 0.482549,-99)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0184334, 1, 1, 0.910537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453643,-99) , 
3, 1.12425, 0, 0, 0.713961,-99) , 
0, 0.715889, 1, 0, 0.776637,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346313,-99) , 
1, -0.481363, 1, 0, 0.418704,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.137478,-99) , 
3, -0.997806, 0, 0, 0.317456,-99) , 
3, 0.254861, 0, 0, 0.537853,-99)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.843124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350009,-99) , 
0, 1.06604, 1, 0, 0.67446,-99) , 
3, 1.21404, 0, 0, 0.745351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526822,-99) , 
NN(
0, 
0, 
-1, -1.15615, 0, -1, 0.195316,-99) , 
3, -0.100777, 0, 0, 0.250343,-99) , 
3, 0.17816, 0, 0, 0.50158,-99)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.89653, 1, 1, 0.868827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338776,-99) , 
0, 0.807964, 1, 0, 0.607869,-99) , 
3, 1.21436, 0, 0, 0.72277,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306346,-99) , 
2, -0.212465, 1, 0, 0.431456,-99) , 
NN(
0, 
0, 
-1, -1.17601, 1, -1, 0.140676,-99) , 
3, -0.382101, 0, 0, 0.235157,-99) , 
3, 0.17816, 0, 0, 0.469597,-99)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.374433, 1, 1, 0.921668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372892,-99) , 
3, 1.11054, 0, 0, 0.669035,-99) , 
0, 0.702317, 1, 0, 0.740208,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309447,-99) , 
1, -0.481363, 1, 0, 0.412865,-99) , 
NN(
0, 
0, 
-1, -1.88904, 1, -1, 0.120633,-99) , 
3, -0.768214, 0, 0, 0.270145,-99) , 
3, 0.307824, 0, 0, 0.470299,-99)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20395, 0, 1, 0.711434,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.194791,-99) , 
3, -0.123397, 0, 0, 0.480371,-99)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.58992, 1, 1, 0.840798,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201213,-99) , 
0, 0.872991, 1, 0, 0.482549,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.195772,-99) , 
3, -0.541364, 0, 0, 0.374852,-99) , 
3, 1.05097, 0, 0, 0.485544,-99)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.901491,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385793,-99) , 
0, 1.24593, 1, 0, 0.6433,-99) , 
3, 1.42967, 0, 0, 0.71921,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.183149,-99) , 
3, -0.123397, 0, 0, 0.481309,-99)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27591, 0, 1, 0.806416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283552,-99) , 
0, 0.256929, 1, 0, 0.521891,-99) , 
3, 0.734957, 0, 0, 0.667736,-99) , 
NN(
0, 
0, 
-1, -0.653734, 0, -1, 0.199665,-99) , 
3, -0.160313, 0, 0, 0.481034,-99)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78166, 1, 1, 0.845309,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336137,-99) , 
0, 0.245926, 1, 0, 0.562944,-99) , 
3, 0.830168, 0, 0, 0.697432,-99) , 
NN(
0, 
0, 
-1, -0.9742, 0, -1, 0.205417,-99) , 
3, -0.257563, 0, 0, 0.502251,-99)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.60464, 1, 1, 0.874624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281244,-99) , 
0, 0.893448, 1, 0, 0.638381,-99) , 
3, 1.21404, 0, 0, 0.736251,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324305,-99) , 
0, -0.991976, 1, 0, 0.422439,-99) , 
NN(
0, 
0, 
-1, -2.4918, 1, -1, 0.173812,-99) , 
3, -0.927516, 0, 0, 0.309749,-99) , 
3, 0.17816, 0, 0, 0.531416,-99)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.319388, 0, 1, 0.733947,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176813,-99) , 
0, -1.17998, 1, 0, 0.315745,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0820173,-99) , 
3, -1.01267, 0, 0, 0.206424,-99) , 
3, -0.123397, 0, 0, 0.504512,-99)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.702317, 1, 1, 0.776477,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427605,-99) , 
0, -0.381382, 1, 0, 0.567829,-99) , 
3, 0.325599, 0, 0, 0.723914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199972,-99) , 
0, -1.62009, 1, 0, 0.306383,-99) , 
NN(
0, 
0, 
-1, 0.319595, 0, -1, 0.0681462,-99) , 
3, -1.3073, 0, 0, 0.225934,-99) , 
3, -0.123397, 0, 0, 0.520474,-99)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90389, 1, 1, 0.856508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307498,-99) , 
0, 0.738333, 1, 0, 0.559605,-99) , 
3, 1.10862, 0, 0, 0.680742,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177667,-99) , 
0, -1.56093, 1, 0, 0.298672,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.104842,-99) , 
3, -1.36791, 0, 0, 0.230602,-99) , 
3, -0.202496, 0, 0, 0.492108,-99)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.52466, 0, 1, 0.717534,-99) , 
NN(
0, 
0, 
-1, -0.963382, 0, -1, 0.182412,-99) , 
3, -0.237768, 0, 0, 0.504876,-99)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.808679, 0, 1, 0.909881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423472,-99) , 
3, 1.13907, 0, 0, 0.727489,-99) , 
0, 1.09855, 1, 0, 0.799619,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575953,-99) , 
NN(
0, 
0, 
-1, -1.2191, 0, -1, 0.219008,-99) , 
3, -0.0146681, 0, 0, 0.287461,-99) , 
3, 0.306962, 0, 0, 0.499825,-99)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15389, 1, 1, 0.807659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441644,-99) , 
3, -0.00760681, 0, 0, 0.576079,-99) , 
3, 0.403284, 0, 0, 0.732347,-99) , 
NN(
0, 
0, 
-1, -1.23505, 0, -1, 0.195898,-99) , 
3, -0.260696, 0, 0, 0.532422,-99)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.00713825, 1, 1, 0.751478,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263958,-99) , 
1, -0.250541, 1, 0, 0.402198,-99) , 
NN(
0, 
0, 
-1, -2.29442, 1, -1, 0.119256,-99) , 
3, -0.93003, 0, 0, 0.281499,-99) , 
3, 0.17816, 0, 0, 0.506784,-99)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.864137,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268815,-99) , 
0, 0.708301, 1, 0, 0.622377,-99) , 
3, 0.98804, 0, 0, 0.733925,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.207127,-99) , 
3, -0.123397, 0, 0, 0.513391,-99)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.889513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297526,-99) , 
0, 1.36756, 1, 0, 0.633227,-99) , 
3, 1.37777, 0, 0, 0.740466,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21999,-99) , 
0, -0.143679, 1, 0, 0.449199,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.163125,-99) , 
3, -0.568264, 0, 0, 0.30244,-99) , 
3, 0.392653, 0, 0, 0.489522,-99)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.872999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384245,-99) , 
0, 0.782483, 1, 0, 0.651164,-99) , 
3, 1.18404, 0, 0, 0.743433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634944,-99) , 
NN(
0, 
0, 
-1, -0.573736, 0, -1, 0.261857,-99) , 
1, -0.97244, 1, 0, 0.312148,-99) , 
3, 0.183842, 0, 0, 0.525082,-99)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51354, 1, 1, 0.838553,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441217,-99) , 
0, 0.189126, 1, 0, 0.592364,-99) , 
3, 1.00736, 0, 0, 0.720778,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258058,-99) , 
0, -0.644302, 1, 0, 0.397219,-99) , 
NN(
0, 
0, 
-1, -0.362378, 1, -1, 0.15572,-99) , 
3, -0.927516, 0, 0, 0.285324,-99) , 
3, 0.17816, 0, 0, 0.509875,-99)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.23356, 1, 1, 0.866606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318465,-99) , 
0, 0.852865, 1, 0, 0.587099,-99) , 
3, 1.30112, 0, 0, 0.703561,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290067,-99) , 
0, -1.60702, 1, 0, 0.352392,-99) , 
NN(
0, 
0, 
-1, -0.309018, 1, -1, 0.0561183,-99) , 
3, -1.23491, 0, 0, 0.282484,-99) , 
3, 0.318747, 0, 0, 0.468384,-99)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.796949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300044,-99) , 
0, -0.2316, 1, 0, 0.500739,-99) , 
3, 0.312308, 0, 0, 0.699577,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.162097,-99) , 
3, -0.376892, 0, 0, 0.506964,-99)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53543, 0, 1, 0.8555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271521,-99) , 
0, 1.0116, 1, 0, 0.572369,-99) , 
3, 1.05334, 0, 0, 0.677435,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.194922,-99) , 
3, -0.28269, 0, 0, 0.486613,-99)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43224, 1, 1, 0.858026,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398687,-99) , 
0, 0.210411, 1, 0, 0.598318,-99) , 
3, 0.98804, 0, 0, 0.714245,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.211743,-99) , 
3, -0.123397, 0, 0, 0.498192,-99)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.465869, 1, 1, 0.864014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44565,-99) , 
3, 1.03374, 0, 0, 0.687091,-99) , 
0, 0.561948, 1, 0, 0.747988,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216253,-99) , 
0, -1.36233, 1, 0, 0.349603,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.122661,-99) , 
3, -1.01154, 0, 0, 0.239626,-99) , 
3, -0.123397, 0, 0, 0.52071,-99)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96169, 1, 1, 0.871947,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276942,-99) , 
0, 0.830896, 1, 0, 0.619575,-99) , 
3, 1.00096, 0, 0, 0.740063,-99) , 
NN(
0, 
0, 
-1, -0.538025, 0, -1, 0.2178,-99) , 
3, -0.00187935, 0, 0, 0.487375,-99)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.876787,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367036,-99) , 
3, 0.55361, 0, 0, 0.643082,-99) , 
0, -0.177282, 1, 0, 0.687807,-99) , 
NN(
0, 
0, 
-1, -1.30427, 0, -1, 0.226297,-99) , 
3, -0.123397, 0, 0, 0.502982,-99)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36545, 1, 1, 0.784707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379757,-99) , 
0, 0.0136911, 1, 0, 0.545365,-99) , 
3, 0.573562, 0, 0, 0.691265,-99) , 
NN(
0, 
0, 
-1, -1.15994, 0, -1, 0.166827,-99) , 
3, -0.293955, 0, 0, 0.47574,-99)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.852355,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371745,-99) , 
0, 0.964063, 1, 0, 0.662647,-99) , 
3, 1.20664, 0, 0, 0.749377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555791,-99) , 
NN(
0, 
0, 
-1, -1.07447, 0, -1, 0.207001,-99) , 
3, -0.0622252, 0, 0, 0.257499,-99) , 
3, 0.202693, 0, 0, 0.473188,-99)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.22876, 1, 1, 0.849551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359962,-99) , 
0, 0.774542, 1, 0, 0.633305,-99) , 
3, 1.00736, 0, 0, 0.740823,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533605,-99) , 
NN(
0, 
0, 
-1, -1.42991, 0, -1, 0.194083,-99) , 
3, -0.103735, 0, 0, 0.248543,-99) , 
3, 0.17816, 0, 0, 0.496291,-99)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12461, 0, 1, 0.815214,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356653,-99) , 
0, -0.0834363, 1, 0, 0.539909,-99) , 
3, 0.599118, 0, 0, 0.710546,-99) , 
NN(
0, 
0, 
-1, -1.1305, 0, -1, 0.212683,-99) , 
3, -0.266059, 0, 0, 0.517293,-99)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.850401,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401891,-99) , 
0, 0.372449, 1, 0, 0.619833,-99) , 
3, 0.884402, 0, 0, 0.725111,-99) , 
NN(
0, 
0, 
-1, -0.798162, 0, -1, 0.210406,-99) , 
3, -0.207894, 0, 0, 0.506047,-99)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.10303, 1, 1, 0.859718,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426327,-99) , 
0, 0.569025, 1, 0, 0.655666,-99) , 
3, 0.98413, 0, 0, 0.758839,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2737,-99) , 
0, -0.807713, 1, 0, 0.444418,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.0964669,-99) , 
3, -1.15126, 0, 0, 0.314167,-99) , 
3, 0.183842, 0, 0, 0.532387,-99)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65662, 1, 1, 0.864208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430514,-99) , 
0, 0.905235, 1, 0, 0.6498,-99) , 
3, 1.21404, 0, 0, 0.735778,-99) , 
NN(
0, 
0, 
-1, -0.382101, 0, -1, 0.246964,-99) , 
3, 0.17816, 0, 0, 0.480603,-99)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27925, 1, 1, 0.878579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299708,-99) , 
0, 0.730643, 1, 0, 0.618738,-99) , 
3, 1.10692, 0, 0, 0.76165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334212,-99) , 
0, -0.765399, 1, 0, 0.449952,-99) , 
NN(
0, 
0, 
-1, -0.988581, 0, -1, 0.161573,-99) , 
3, -0.52447, 0, 0, 0.28374,-99) , 
3, 0.28719, 0, 0, 0.497615,-99)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45879, 1, 1, 0.810111,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327361,-99) , 
0, 0.0490839, 1, 0, 0.573821,-99) , 
3, 0.539295, 0, 0, 0.724621,-99) , 
NN(
0, 
0, 
-1, -0.642871, 0, -1, 0.204557,-99) , 
3, -0.140969, 0, 0, 0.515148,-99)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.924403, 1, 1, 0.809847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402758,-99) , 
0, -0.14342, 1, 0, 0.573241,-99) , 
3, 0.591727, 0, 0, 0.727655,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204634,-99) , 
0, -1.21605, 1, 0, 0.35224,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.0940323,-99) , 
3, -1.03626, 0, 0, 0.225482,-99) , 
3, -0.0698586, 0, 0, 0.497914,-99)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54644, 1, 1, 0.775781,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359592,-99) , 
0, -0.0316589, 1, 0, 0.560516,-99) , 
3, 0.543354, 0, 0, 0.694068,-99) , 
NN(
0, 
0, 
-1, -1.3037, 0, -1, 0.215258,-99) , 
3, -0.123397, 0, 0, 0.491035,-99)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.039, 1, 1, 0.795408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302538,-99) , 
0, -0.146236, 1, 0, 0.514666,-99) , 
3, 0.536638, 0, 0, 0.671513,-99) , 
NN(
0, 
0, 
-1, -1.60668, 1, -1, 0.188924,-99) , 
3, -0.38184, 0, 0, 0.515667,-99)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.319388, 0, 1, 0.728183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220574,-99) , 
0, -1.31319, 1, 0, 0.360898,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.142957,-99) , 
3, -1.00886, 0, 0, 0.253765,-99) , 
3, -0.123397, 0, 0, 0.51974,-99)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.884413,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33148,-99) , 
0, 1.312, 1, 0, 0.651239,-99) , 
3, 1.4607, 0, 0, 0.722452,-99) , 
NN(
0, 
0, 
-1, -0.505712, 0, -1, 0.252912,-99) , 
3, 0.0354976, 0, 0, 0.498285,-99)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.974437, 0, 1, 0.92594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489755,-99) , 
3, 1.39872, 0, 0, 0.736122,-99) , 
0, 1.16242, 1, 0, 0.818412,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289183,-99) , 
1, -0.471534, 1, 0, 0.39882,-99) , 
NN(
0, 
0, 
-1, -1.12048, 0, -1, 0.134892,-99) , 
3, -0.572672, 0, 0, 0.27492,-99) , 
3, 0.392653, 0, 0, 0.515229,-99)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.516645, 1, 1, 0.914127,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401488,-99) , 
3, 1.20293, 0, 0, 0.70505,-99) , 
0, 1.05711, 1, 0, 0.788849,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288175,-99) , 
0, -0.41571, 1, 0, 0.443506,-99) , 
NN(
0, 
0, 
-1, -1.23983, 0, -1, 0.167635,-99) , 
3, -0.391132, 0, 0, 0.262977,-99) , 
3, 0.234307, 0, 0, 0.497329,-99)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.868721,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833927,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431368,-99) , 
0, 0.852865, 1, 0, 0.686404,-99) , 
3, 1.08361, 0, 0, 0.786282,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340719,-99) , 
1, -0.47001, 1, 0, 0.426055,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0702988,-99) , 
3, -1.27151, 0, 0, 0.334009,-99) , 
3, 0.306962, 0, 0, 0.545587,-99)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.831123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267185,-99) , 
0, 0.738333, 1, 0, 0.565233,-99) , 
3, 1.07702, 0, 0, 0.66231,-99) , 
NN(
0, 
0, 
-1, -1.07301, 0, -1, 0.199357,-99) , 
3, -0.304384, 0, 0, 0.485382,-99)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21129, 1, 1, 0.845556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263026,-99) , 
0, 0.479736, 1, 0, 0.560061,-99) , 
3, 0.845703, 0, 0, 0.694974,-99) , 
NN(
0, 
0, 
-1, -1.59136, 1, -1, 0.192566,-99) , 
3, -0.304384, 0, 0, 0.506518,-99)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35927, 1, 1, 0.824456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393081,-99) , 
2, 0.366304, 1, 0, 0.583716,-99) , 
3, 0.837674, 0, 0, 0.745423,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273201,-99) , 
0, -0.833115, 1, 0, 0.408233,-99) , 
NN(
0, 
0, 
-1, -2.0971, 1, -1, 0.16851,-99) , 
3, -0.684971, 0, 0, 0.299163,-99) , 
3, 0.254861, 0, 0, 0.504865,-99)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16468, 0, 1, 0.757289,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288488,-99) , 
1, -0.252733, 1, 0, 0.437651,-99) , 
3, 0.157059, 0, 0, 0.670032,-99) , 
NN(
0, 
0, 
-1, -1.2116, 0, -1, 0.169814,-99) , 
3, -0.564929, 0, 0, 0.520124,-99)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05335, 1, 1, 0.821506,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261637,-99) , 
0, 0.465064, 1, 0, 0.574382,-99) , 
3, 0.809493, 0, 0, 0.697993,-99) , 
NN(
0, 
0, 
-1, -1.02308, 0, -1, 0.20771,-99) , 
3, -0.299834, 0, 0, 0.511004,-99)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.77627, 1, 1, 0.870494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447285,-99) , 
0, 1.37765, 1, 0, 0.698661,-99) , 
3, 1.40056, 0, 0, 0.782819,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276408,-99) , 
0, 0.248521, 1, 0, 0.537968,-99) , 
NN(
0, 
0, 
-1, -1.02282, 0, -1, 0.25851,-99) , 
3, 0.0596446, 0, 0, 0.340646,-99) , 
3, 0.660704, 0, 0, 0.484593,-99)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73223, 1, 1, 0.861202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425817,-99) , 
0, 0.781704, 1, 0, 0.665468,-99) , 
3, 1.25391, 0, 0, 0.741434,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189586,-99) , 
0, -0.991976, 1, 0, 0.302611,-99) , 
NN(
0, 
0, 
-1, -2.489, 1, -1, 0.147302,-99) , 
3, -0.787076, 0, 0, 0.220613,-99) , 
3, 0.0354976, 0, 0, 0.47234,-99)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.07307, 0, 1, 0.877573,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316663,-99) , 
0, 1.15791, 1, 0, 0.706991,-99) , 
3, 1.30532, 0, 0, 0.785491,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232757,-99) , 
0, -0.312245, 1, 0, 0.416055,-99) , 
NN(
0, 
0, 
-1, -2.85873, 1, -1, 0.158934,-99) , 
3, -1.06453, 0, 0, 0.323768,-99) , 
3, 0.28719, 0, 0, 0.523673,-99)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.785004, 1, 1, 0.851996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488911,-99) , 
3, 1.18885, 0, 0, 0.662493,-99) , 
1, 0.455078, 1, 0, 0.791415,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339539,-99) , 
3, -0.0785792, 0, 0, 0.410599,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0931125,-99) , 
3, -1.15599, 0, 0, 0.304106,-99) , 
3, 0.178444, 0, 0, 0.532872,-99)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51354, 1, 1, 0.817985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275447,-99) , 
0, 0.809818, 1, 0, 0.568801,-99) , 
3, 0.994438, 0, 0, 0.677814,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232571,-99) , 
0, -1.21605, 1, 0, 0.350521,-99) , 
NN(
0, 
0, 
-1, -0.0154624, 1, -1, 0.100956,-99) , 
3, -1.00886, 0, 0, 0.233248,-99) , 
3, -0.123397, 0, 0, 0.493235,-99)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.836045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472112,-99) , 
0, 0.696072, 1, 0, 0.688995,-99) , 
3, 1.08361, 0, 0, 0.767314,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276599,-99) , 
0, -1.07324, 1, 0, 0.37343,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.0571374,-99) , 
3, -0.95623, 0, 0, 0.24886,-99) , 
3, 0.306962, 0, 0, 0.456099,-99)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.798699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309678,-99) , 
0, -0.30574, 1, 0, 0.511475,-99) , 
3, 0.387506, 0, 0, 0.694755,-99) , 
NN(
0, 
0, 
-1, -1.06797, 0, -1, 0.2372,-99) , 
3, -0.304384, 0, 0, 0.540666,-99)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43094, 0, 1, 0.759819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488063,-99) , 
3, 0.250256, 0, 0, 0.698896,-99) , 
NN(
0, 
0, 
-1, -1.20105, 1, -1, 0.215434,-99) , 
3, -0.202496, 0, 0, 0.505522,-99)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.27084, 0, 1, 0.937467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412896,-99) , 
3, 0.774024, 0, 0, 0.682796,-99) , 
0, 0.137052, 1, 0, 0.739376,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.149604,-99) , 
3, -1.04319, 0, 0, 0.28439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.110242,-99) , 
0, -0.924663, 1, 0, 0.222523,-99) , 
3, -0.123397, 0, 0, 0.504081,-99)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.877773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433841,-99) , 
0, 0.25863, 1, 0, 0.629127,-99) , 
3, 1.07643, 0, 0, 0.724204,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.212704,-99) , 
3, -0.304384, 0, 0, 0.526783,-99)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.23356, 1, 1, 0.875545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480974,-99) , 
0, 0.424748, 1, 0, 0.639755,-99) , 
3, 1.42729, 0, 0, 0.705893,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181595,-99) , 
0, -1.08285, 1, 0, 0.319377,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0923084,-99) , 
3, -1.0146, 0, 0, 0.212764,-99) , 
3, -0.123397, 0, 0, 0.506082,-99)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.858435,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309012,-99) , 
0, 0.465064, 1, 0, 0.566322,-99) , 
3, 0.979517, 0, 0, 0.686206,-99) , 
NN(
0, 
0, 
-1, -1.06642, 0, -1, 0.169028,-99) , 
3, -0.340957, 0, 0, 0.497288,-99)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.768154, 0, 1, 0.867389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21949,-99) , 
3, 1.14028, 0, 0, 0.641355,-99) , 
0, 1.06599, 1, 0, 0.735507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402423,-99) , 
3, -0.019637, 0, 0, 0.47214,-99) , 
NN(
0, 
0, 
-1, -1.05005, 0, -1, 0.192414,-99) , 
3, -0.322974, 0, 0, 0.281202,-99) , 
3, 0.20809, 0, 0, 0.498081,-99)    );
  // itree = 100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.869, 1, 1, 0.836959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310594,-99) , 
0, 0.8372, 1, 0, 0.563732,-99) , 
3, 1.06022, 0, 0, 0.661721,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.19088,-99) , 
3, -0.28269, 0, 0, 0.471302,-99)    );
  // itree = 101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.956191, 1, 1, 0.833635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208817,-99) , 
0, 0.346231, 1, 0, 0.467569,-99) , 
NN(
0, 
0, 
-1, -1.09661, 0, -1, 0.155385,-99) , 
3, -0.544466, 0, 0, 0.320615,-99) , 
3, 0.816421, 0, 0, 0.47705,-99)    );
  // itree = 102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.311629, 1, 1, 0.905457,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365222,-99) , 
3, 1.01403, 0, 0, 0.715353,-99) , 
0, 0.778492, 1, 0, 0.783048,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324297,-99) , 
0, -0.46933, 1, 0, 0.466871,-99) , 
NN(
0, 
0, 
-1, -1.25019, 0, -1, 0.159932,-99) , 
3, -0.569838, 0, 0, 0.296284,-99) , 
3, 0.223327, 0, 0, 0.542267,-99)    );
  // itree = 103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72318, 0, 1, 0.83693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390141,-99) , 
0, 0.573049, 1, 0, 0.602901,-99) , 
3, 1.08912, 0, 0, 0.688512,-99) , 
NN(
0, 
0, 
-1, -0.721913, 0, -1, 0.209139,-99) , 
3, -0.232821, 0, 0, 0.501282,-99)    );
  // itree = 104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38863, 0, 1, 0.801955,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381479,-99) , 
0, -0.773268, 1, 0, 0.479164,-99) , 
NN(
0, 
0, 
-1, -0.279363, 1, -1, 0.213267,-99) , 
3, -0.391132, 0, 0, 0.315454,-99) , 
3, 0.234307, 0, 0, 0.53445,-99)    );
  // itree = 105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.30659, 1, 1, 0.864228,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350418,-99) , 
0, 1.20619, 1, 0, 0.644077,-99) , 
3, 1.20395, 0, 0, 0.716675,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.222014,-99) , 
3, -0.123397, 0, 0, 0.522149,-99)    );
  // itree = 106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.862356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36747,-99) , 
0, 1.38684, 1, 0, 0.644771,-99) , 
3, 1.32758, 0, 0, 0.72375,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32073,-99) , 
2, -0.184482, 1, 0, 0.418261,-99) , 
NN(
0, 
0, 
-1, -1.1903, 0, -1, 0.166829,-99) , 
3, -0.448661, 0, 0, 0.254121,-99) , 
3, 0.0990605, 0, 0, 0.483289,-99)    );
  // itree = 107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2819, 0, 1, 0.70397,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.124278,-99) , 
3, -1.4116, 0, 0, 0.294299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.128369,-99) , 
0, -1.44076, 1, 0, 0.213805,-99) , 
3, -0.25059, 0, 0, 0.501281,-99)    );
  // itree = 108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47483, 1, 1, 0.837936,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320681,-99) , 
0, 0.442526, 1, 0, 0.533763,-99) , 
3, 0.8224, 0, 0, 0.727215,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246693,-99) , 
0, -0.773268, 1, 0, 0.350823,-99) , 
NN(
0, 
0, 
-1, -1.02465, 0, -1, 0.146876,-99) , 
3, -0.565983, 0, 0, 0.234434,-99) , 
3, 0.228725, 0, 0, 0.438664,-99)    );
  // itree = 109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61268, 0, 1, 0.840331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266377,-99) , 
0, 1.0116, 1, 0, 0.582687,-99) , 
3, 1.3205, 0, 0, 0.663637,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.194904,-99) , 
3, -0.207894, 0, 0, 0.463229,-99)    );
  // itree = 110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.834213,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396814,-99) , 
1, -0.0783329, 1, 0, 0.555749,-99) , 
3, 0.990695, 0, 0, 0.665046,-99) , 
NN(
0, 
0, 
-1, -0.877994, 0, -1, 0.156188,-99) , 
3, -0.376892, 0, 0, 0.468736,-99)    );
  // itree = 111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43422, 0, 1, 0.680617,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.238844,-99) , 
3, -0.123397, 0, 0, 0.49726,-99)    );
  // itree = 112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.87209,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490449,-99) , 
0, -0.207958, 1, 0, 0.604584,-99) , 
3, 1.10862, 0, 0, 0.708482,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.201882,-99) , 
3, -0.202496, 0, 0, 0.506306,-99)    );
  // itree = 113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.851703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275797,-99) , 
0, 0.897575, 1, 0, 0.633827,-99) , 
3, 1.15444, 0, 0, 0.703139,-99) , 
NN(
0, 
0, 
-1, -1.39569, 1, -1, 0.166946,-99) , 
3, -0.420978, 0, 0, 0.503377,-99)    );
  // itree = 114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54195, 1, 1, 0.855629,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324094,-99) , 
0, 0.733197, 1, 0, 0.638818,-99) , 
3, 1.09048, 0, 0, 0.726271,-99) , 
NN(
0, 
0, 
-1, -0.963382, 0, -1, 0.200689,-99) , 
3, -0.232821, 0, 0, 0.514857,-99)    );
  // itree = 115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15389, 1, 1, 0.835195,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379154,-99) , 
0, -0.107401, 1, 0, 0.603075,-99) , 
3, 0.540529, 0, 0, 0.749348,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203791,-99) , 
0, -0.890785, 1, 0, 0.398056,-99) , 
NN(
0, 
0, 
-1, -1.78935, 0, -1, 0.13048,-99) , 
3, -1.00886, 0, 0, 0.277566,-99) , 
3, -0.123397, 0, 0, 0.540839,-99)    );
  // itree = 116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.854837,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32844,-99) , 
0, 0.877072, 1, 0, 0.596335,-99) , 
3, 1.2063, 0, 0, 0.686048,-99) , 
NN(
0, 
0, 
-1, -1.0146, 0, -1, 0.204189,-99) , 
3, -0.123397, 0, 0, 0.477757,-99)    );
  // itree = 117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.672338, 1, 1, 0.7917,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358179,-99) , 
1, -0.24859, 1, 0, 0.49429,-99) , 
NN(
0, 
0, 
-1, -1.19708, 0, -1, 0.194158,-99) , 
3, -0.325669, 0, 0, 0.292065,-99) , 
3, 0.306962, 0, 0, 0.512227,-99)    );
  // itree = 118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.425145, 1, 1, 0.724839,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.218368,-99) , 
3, -0.202496, 0, 0, 0.499903,-99)    );
  // itree = 119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44381, 0, 1, 0.759442,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355951,-99) , 
0, -0.841692, 1, 0, 0.440875,-99) , 
3, 0.263096, 0, 0, 0.6519,-99) , 
NN(
0, 
0, 
-1, -1.65122, 1, -1, 0.127276,-99) , 
3, -0.711955, 0, 0, 0.495377,-99)    );
  // itree = 120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.861356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29697,-99) , 
0, 0.848875, 1, 0, 0.557851,-99) , 
3, 1.15257, 0, 0, 0.652743,-99) , 
NN(
0, 
0, 
-1, -0.940738, 0, -1, 0.158926,-99) , 
3, -0.420978, 0, 0, 0.476131,-99)    );
  // itree = 121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.35991, 0, 1, 0.758992,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285454,-99) , 
0, -0.773268, 1, 0, 0.433578,-99) , 
NN(
0, 
0, 
-1, -0.362378, 1, -1, 0.178469,-99) , 
3, -0.611377, 0, 0, 0.280221,-99) , 
3, 0.180631, 0, 0, 0.510974,-99)    );
  // itree = 122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.864276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180113,-99) , 
0, 1.20619, 1, 0, 0.604858,-99) , 
3, 1.36979, 0, 0, 0.684443,-99) , 
NN(
0, 
0, 
-1, -0.716322, 0, -1, 0.21856,-99) , 
3, -0.210183, 0, 0, 0.470882,-99)    );
  // itree = 123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42729, 0, 1, 0.740274,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.212416,-99) , 
3, -0.123397, 0, 0, 0.533279,-99)    );
  // itree = 124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.869328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327917,-99) , 
0, 0.887495, 1, 0, 0.606096,-99) , 
3, 1.12146, 0, 0, 0.715441,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.225315,-99) , 
3, -0.202496, 0, 0, 0.528879,-99)    );
  // itree = 125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31481, 0, 1, 0.838835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.913362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397778,-99) , 
0, -0.106156, 1, 0, 0.578575,-99) , 
3, 0.779005, 0, 0, 0.725345,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.205011,-99) , 
3, -0.123397, 0, 0, 0.486315,-99)    );
  // itree = 126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60246, 0, 1, 0.759393,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254802,-99) , 
0, -0.763493, 1, 0, 0.356754,-99) , 
NN(
0, 
0, 
-1, -1.7862, 1, -1, 0.138655,-99) , 
3, -0.591878, 0, 0, 0.234555,-99) , 
3, 0.202693, 0, 0, 0.476882,-99)    );
  // itree = 127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.28284, 0, 1, 0.807897,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351846,-99) , 
0, -0.831231, 1, 0, 0.476713,-99) , 
NN(
0, 
0, 
-1, -1.94189, 0, -1, 0.171089,-99) , 
3, -0.548378, 0, 0, 0.300605,-99) , 
3, 0.262941, 0, 0, 0.534305,-99)    );
  // itree = 128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.700115, 0, 1, 0.928864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412914,-99) , 
3, 1.16544, 0, 0, 0.689323,-99) , 
0, 0.803912, 1, 0, 0.7677,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275207,-99) , 
0, -0.2316, 1, 0, 0.5067,-99) , 
NN(
0, 
0, 
-1, -1.13391, 0, -1, 0.187917,-99) , 
3, -0.441317, 0, 0, 0.316527,-99) , 
3, 0.355994, 0, 0, 0.497258,-99)    );
  // itree = 129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.875022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388086,-99) , 
0, 1.06604, 1, 0, 0.637584,-99) , 
3, 1.27844, 0, 0, 0.743632,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193626,-99) , 
0, -0.153185, 1, 0, 0.429342,-99) , 
NN(
0, 
0, 
-1, -1.97799, 0, -1, 0.124776,-99) , 
3, -0.95623, 0, 0, 0.327525,-99) , 
3, 0.306962, 0, 0, 0.519179,-99)    );
  // itree = 130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22502, 0, 1, 0.817914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380973,-99) , 
1, -0.560109, 1, 0, 0.47649,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.164699,-99) , 
3, -0.541636, 0, 0, 0.332627,-99) , 
3, 0.660704, 0, 0, 0.497555,-99)    );
  // itree = 131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.822106,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257096,-99) , 
0, 0.495409, 1, 0, 0.556275,-99) , 
3, 0.80918, 0, 0, 0.707733,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222542,-99) , 
0, -1.21855, 1, 0, 0.343421,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.0726293,-99) , 
3, -1.0662, 0, 0, 0.233073,-99) , 
3, 0.00531135, 0, 0, 0.497687,-99)    );
  // itree = 132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.956191, 1, 1, 0.865636,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261285,-99) , 
0, 0.710396, 1, 0, 0.585287,-99) , 
3, 0.90304, 0, 0, 0.710408,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161449,-99) , 
0, -1.17488, 1, 0, 0.32546,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.10247,-99) , 
3, -1.07684, 0, 0, 0.228,-99) , 
3, -0.202496, 0, 0, 0.512579,-99)    );
  // itree = 133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.868455,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437115,-99) , 
0, 0.46948, 1, 0, 0.644804,-99) , 
3, 1.06561, 0, 0, 0.74823,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250243,-99) , 
0, -1.18308, 1, 0, 0.372254,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.103259,-99) , 
3, -1.03104, 0, 0, 0.260687,-99) , 
3, 0.0509667, 0, 0, 0.517973,-99)    );
  // itree = 134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01137, 0, 1, 0.785013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366068,-99) , 
0, -0.599285, 1, 0, 0.492167,-99) , 
3, 0.242405, 0, 0, 0.696557,-99) , 
NN(
0, 
0, 
-1, -1.18661, 0, -1, 0.20487,-99) , 
3, -0.435158, 0, 0, 0.547976,-99)    );
  // itree = 135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.504758, 0, 1, 0.871928,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408817,-99) , 
3, 1.36283, 0, 0, 0.681578,-99) , 
0, 1.16242, 1, 0, 0.770856,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232327,-99) , 
0, -0.538822, 1, 0, 0.388747,-99) , 
NN(
0, 
0, 
-1, -1.59924, 0, -1, 0.110236,-99) , 
3, -0.927516, 0, 0, 0.267887,-99) , 
3, 0.17816, 0, 0, 0.503491,-99)    );
  // itree = 136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.876849,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346883,-99) , 
0, 1.39416, 1, 0, 0.663589,-99) , 
3, 1.39607, 0, 0, 0.749881,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334562,-99) , 
1, -0.250541, 1, 0, 0.498576,-99) , 
NN(
0, 
0, 
-1, -0.957819, 0, -1, 0.198454,-99) , 
3, -0.391477, 0, 0, 0.30251,-99) , 
3, 0.238103, 0, 0, 0.501998,-99)    );
  // itree = 137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.828615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284462,-99) , 
0, 0.430037, 1, 0, 0.541407,-99) , 
3, 0.805715, 0, 0, 0.674731,-99) , 
NN(
0, 
0, 
-1, -0.557753, 1, -1, 0.136547,-99) , 
3, -0.636613, 0, 0, 0.494056,-99)    );
  // itree = 138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.75017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459009,-99) , 
3, 0.235551, 0, 0, 0.675974,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.194312,-99) , 
3, -0.202496, 0, 0, 0.480001,-99)    );
  // itree = 139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2063, 0, 1, 0.743974,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219468,-99) , 
0, -1.17488, 1, 0, 0.38556,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.132445,-99) , 
3, -1.0136, 0, 0, 0.258959,-99) , 
3, -0.123397, 0, 0, 0.534622,-99)    );
  // itree = 140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.76645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460023,-99) , 
3, 0.235551, 0, 0, 0.695012,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.194224,-99) , 
3, -0.202496, 0, 0, 0.487092,-99)    );
  // itree = 141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66012, 0, 1, 0.749981,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286486,-99) , 
0, -1.27242, 1, 0, 0.379281,-99) , 
NN(
0, 
0, 
-1, -1.99322, 1, -1, 0.110753,-99) , 
3, -0.959342, 0, 0, 0.276624,-99) , 
3, 0.301115, 0, 0, 0.479041,-99)    );
  // itree = 142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.74751, 1, 1, 0.773922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209346,-99) , 
0, -0.153185, 1, 0, 0.503855,-99) , 
3, 0.261984, 0, 0, 0.671798,-99) , 
NN(
0, 
0, 
-1, -1.51305, 0, -1, 0.152856,-99) , 
3, -0.711955, 0, 0, 0.537817,-99)    );
  // itree = 143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.568794, 0, 1, 0.90011,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481677,-99) , 
3, 1.13907, 0, 0, 0.7097,-99) , 
0, 0.768458, 1, 0, 0.767881,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301603,-99) , 
1, -0.558737, 1, 0, 0.392956,-99) , 
NN(
0, 
0, 
-1, 0.301203, 1, -1, 0.115757,-99) , 
3, -0.95623, 0, 0, 0.29447,-99) , 
3, 0.306962, 0, 0, 0.517562,-99)    );
  // itree = 144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62875, 1, 1, 0.881009,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383311,-99) , 
0, 0.80635, 1, 0, 0.589773,-99) , 
3, 1.48354, 0, 0, 0.667093,-99) , 
NN(
0, 
0, 
-1, -1.18841, 0, -1, 0.194157,-99) , 
3, -0.237706, 0, 0, 0.472588,-99)    );
  // itree = 145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.486363, 1, 1, 0.90251,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471074,-99) , 
0, 0.221558, 1, 0, 0.619689,-99) , 
3, 1.20395, 0, 0, 0.715678,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.198488,-99) , 
3, -0.123397, 0, 0, 0.49403,-99)    );
  // itree = 146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53383, 1, 1, 0.836388,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365946,-99) , 
0, 0.465064, 1, 0, 0.542729,-99) , 
3, 1.14354, 0, 0, 0.638494,-99) , 
NN(
0, 
0, 
-1, -1.17871, 0, -1, 0.196684,-99) , 
3, -0.435158, 0, 0, 0.496672,-99)    );
  // itree = 147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.830219, 0, 1, 0.942044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443031,-99) , 
3, 1.08418, 0, 0, 0.733888,-99) , 
0, 0.7846, 1, 0, 0.802604,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320519,-99) , 
0, -0.991976, 1, 0, 0.403578,-99) , 
NN(
0, 
0, 
-1, -1.73194, 0, -1, 0.109805,-99) , 
3, -0.957285, 0, 0, 0.273004,-99) , 
3, 0.306962, 0, 0, 0.511457,-99)    );
  // itree = 148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.771683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469511,-99) , 
3, 0.322371, 0, 0, 0.700407,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.204857,-99) , 
3, -0.123397, 0, 0, 0.485291,-99)    );
  // itree = 149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.616454, 1, 1, 0.761126,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231945,-99) , 
0, -0.308465, 1, 0, 0.420537,-99) , 
NN(
0, 
0, 
-1, -0.0446866, 1, -1, 0.0939957,-99) , 
3, -0.973059, 0, 0, 0.295481,-99) , 
3, 0.358757, 0, 0, 0.494567,-99)    );
  // itree = 150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22003, 1, 1, 0.880034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395289,-99) , 
0, 0.893448, 1, 0, 0.698702,-99) , 
3, 1.07833, 0, 0, 0.787579,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306457,-99) , 
1, -0.472421, 1, 0, 0.418662,-99) , 
NN(
0, 
0, 
-1, -0.572275, 1, -1, 0.14506,-99) , 
3, -0.557277, 0, 0, 0.25934,-99) , 
3, 0.262941, 0, 0, 0.501831,-99)    );
  // itree = 151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.26929, 1, 1, 0.870124,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440347,-99) , 
0, 1.14581, 1, 0, 0.713673,-99) , 
3, 1.38863, 0, 0, 0.768389,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39187,-99) , 
0, -0.773268, 1, 0, 0.509701,-99) , 
NN(
0, 
0, 
-1, -0.586434, 1, -1, 0.186175,-99) , 
3, -0.391132, 0, 0, 0.288512,-99) , 
3, 0.234307, 0, 0, 0.493166,-99)    );
  // itree = 152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6221, 1, 1, 0.894795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392606,-99) , 
0, 0.900482, 1, 0, 0.643421,-99) , 
3, 1.4052, 0, 0, 0.722337,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377184,-99) , 
0, -0.523819, 1, 0, 0.49198,-99) , 
NN(
0, 
0, 
-1, -1.52662, 1, -1, 0.181921,-99) , 
3, -0.587974, 0, 0, 0.300575,-99) , 
3, 0.20809, 0, 0, 0.505665,-99)    );
  // itree = 153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.87868, 1, 1, 0.889604,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413673,-99) , 
0, 0.53819, 1, 0, 0.591568,-99) , 
3, 1.31846, 0, 0, 0.700645,-99) , 
NN(
0, 
0, 
-1, -0.450619, 0, -1, 0.25369,-99) , 
3, 0.093663, 0, 0, 0.485142,-99)    );
  // itree = 154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.872198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364792,-99) , 
0, 0.852865, 1, 0, 0.657636,-99) , 
3, 1.1829, 0, 0, 0.765126,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25693,-99) , 
0, -0.431695, 1, 0, 0.432793,-99) , 
NN(
0, 
0, 
-1, -0.835334, 1, -1, 0.130397,-99) , 
3, -0.887574, 0, 0, 0.318222,-99) , 
3, 0.392653, 0, 0, 0.513327,-99)    );
  // itree = 155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.85356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30426,-99) , 
0, 0.897575, 1, 0, 0.571963,-99) , 
3, 1.07839, 0, 0, 0.665372,-99) , 
NN(
0, 
0, 
-1, -1.33457, 0, -1, 0.185638,-99) , 
3, -0.65367, 0, 0, 0.542803,-99)    );
  // itree = 156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5443, 1, 1, 0.890105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482911,-99) , 
0, 1.0089, 1, 0, 0.70763,-99) , 
3, 1.47245, 0, 0, 0.773792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329314,-99) , 
0, -0.670524, 1, 0, 0.480834,-99) , 
NN(
0, 
0, 
-1, -0.74374, 1, -1, 0.177108,-99) , 
3, -0.325669, 0, 0, 0.294238,-99) , 
3, 0.306962, 0, 0, 0.505621,-99)    );
  // itree = 157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.30114, 1, 1, 0.762666,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328025,-99) , 
0, -0.991976, 1, 0, 0.443577,-99) , 
NN(
0, 
0, 
-1, -1.80384, 1, -1, 0.156505,-99) , 
3, -0.626338, 0, 0, 0.282667,-99) , 
3, 0.178444, 0, 0, 0.506438,-99)    );
  // itree = 158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.171593, 1, 1, 0.755453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414916,-99) , 
3, -0.0280511, 0, 0, 0.705861,-99) , 
NN(
0, 
0, 
-1, -1.11972, 0, -1, 0.18699,-99) , 
3, -0.25059, 0, 0, 0.498006,-99)    );
  // itree = 159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.806203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294398,-99) , 
0, 0.168185, 1, 0, 0.583143,-99) , 
3, 0.540529, 0, 0, 0.724766,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.218962,-99) , 
3, -0.123397, 0, 0, 0.49784,-99)    );
  // itree = 160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43703, 1, 1, 0.874836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390752,-99) , 
0, 0.790645, 1, 0, 0.666407,-99) , 
3, 1.2067, 0, 0, 0.747473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641811,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26321,-99) , 
0, -0.745016, 1, 0, 0.418319,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.113328,-99) , 
3, -0.593301, 0, 0, 0.258054,-99) , 
3, 0.20809, 0, 0, 0.473045,-99)    );
  // itree = 161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.786079, 0, 1, 0.754278,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316593,-99) , 
1, -0.210965, 1, 0, 0.44402,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.123874,-99) , 
3, -1.20576, 0, 0, 0.331951,-99) , 
3, 0.392653, 0, 0, 0.508966,-99)    );
  // itree = 162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.714887, 1, 1, 0.798546,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34476,-99) , 
0, -0.14342, 1, 0, 0.518251,-99) , 
3, 0.543354, 0, 0, 0.693387,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.248127,-99) , 
3, -0.123397, 0, 0, 0.506101,-99)    );
  // itree = 163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75625, 0, 1, 0.843707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245863,-99) , 
0, 0.824212, 1, 0, 0.541673,-99) , 
3, 1.1543, 0, 0, 0.64094,-99) , 
NN(
0, 
0, 
-1, -1.70606, 1, -1, 0.137743,-99) , 
3, -0.420978, 0, 0, 0.453905,-99)    );
  // itree = 164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32619, 0, 1, 0.846068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248163,-99) , 
0, 0.56721, 1, 0, 0.553313,-99) , 
3, 0.985321, 0, 0, 0.676064,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196164,-99) , 
0, -1.20764, 1, 0, 0.314582,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.13358,-99) , 
3, -1.00886, 0, 0, 0.235872,-99) , 
3, -0.123397, 0, 0, 0.476945,-99)    );
  // itree = 165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.51004, 1, 1, 0.859897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267175,-99) , 
0, 0.8372, 1, 0, 0.602044,-99) , 
3, 1.2063, 0, 0, 0.691254,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.229313,-99) , 
3, -0.123397, 0, 0, 0.503163,-99)    );
  // itree = 166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.845178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383726,-99) , 
0, 0.854666, 1, 0, 0.646953,-99) , 
3, 1.20395, 0, 0, 0.717402,-99) , 
NN(
0, 
0, 
-1, -0.419849, 0, -1, 0.221863,-99) , 
3, -0.123397, 0, 0, 0.506221,-99)    );
  // itree = 167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02628, 0, 1, 0.76479,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309471,-99) , 
1, -0.508399, 1, 0, 0.391399,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.125645,-99) , 
3, -0.997833, 0, 0, 0.276358,-99) , 
3, 0.254861, 0, 0, 0.484392,-99)    );
  // itree = 168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.861389,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3422,-99) , 
0, 0.893448, 1, 0, 0.637654,-99) , 
3, 1.05933, 0, 0, 0.760371,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287389,-99) , 
1, -0.118589, 1, 0, 0.380876,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.115698,-99) , 
3, -1.02822, 0, 0, 0.28262,-99) , 
3, 0.276895, 0, 0, 0.503558,-99)    );
  // itree = 169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.882846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353485,-99) , 
0, 1.09506, 1, 0, 0.640753,-99) , 
3, 1.32689, 0, 0, 0.716467,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.203012,-99) , 
3, -0.202496, 0, 0, 0.510549,-99)    );
  // itree = 170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.15461, 1, 1, 0.879719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43443,-99) , 
0, 1.04633, 1, 0, 0.65482,-99) , 
3, 1.47087, 0, 0, 0.717614,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278448,-99) , 
0, -1.24579, 1, 0, 0.368194,-99) , 
NN(
0, 
0, 
-1, -0.212095, 1, -1, 0.127959,-99) , 
3, -1.03104, 0, 0, 0.277012,-99) , 
3, 0.0509667, 0, 0, 0.509828,-99)    );
  // itree = 171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32661, 0, 1, 0.848239,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273694,-99) , 
0, 0.43111, 1, 0, 0.513454,-99) , 
NN(
0, 
0, 
-1, -2.20545, 1, -1, 0.196858,-99) , 
3, -0.543589, 0, 0, 0.379265,-99) , 
3, 0.816421, 0, 0, 0.529419,-99)    );
  // itree = 172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82145, 1, 1, 0.866786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.930193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34771,-99) , 
0, 0.861702, 1, 0, 0.631019,-99) , 
3, 1.17923, 0, 0, 0.748521,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273108,-99) , 
0, -0.632405, 1, 0, 0.41823,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.16601,-99) , 
3, -0.568255, 0, 0, 0.28255,-99) , 
3, 0.392653, 0, 0, 0.480011,-99)    );
  // itree = 173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.72917, 1, 1, 0.859005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29909,-99) , 
0, 1.00996, 1, 0, 0.631405,-99) , 
3, 1.06532, 0, 0, 0.723494,-99) , 
NN(
0, 
0, 
-1, -0.992522, 0, -1, 0.210999,-99) , 
3, -0.260696, 0, 0, 0.538522,-99)    );
  // itree = 174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.836982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403616,-99) , 
0, 0.424748, 1, 0, 0.618094,-99) , 
3, 0.985321, 0, 0, 0.719701,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.186226,-99) , 
3, -0.123397, 0, 0, 0.492987,-99)    );
  // itree = 175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.825083, 0, 1, 0.793846,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186045,-99) , 
0, -0.393233, 1, 0, 0.393517,-99) , 
NN(
0, 
0, 
-1, -1.71449, 0, -1, 0.167941,-99) , 
3, -0.565983, 0, 0, 0.267201,-99) , 
3, 0.228725, 0, 0, 0.499592,-99)    );
  // itree = 176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54681, 1, 1, 0.860545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381285,-99) , 
0, 0.891, 1, 0, 0.657219,-99) , 
3, 1.20395, 0, 0, 0.730137,-99) , 
NN(
0, 
0, 
-1, -1.30427, 0, -1, 0.20493,-99) , 
3, -0.123397, 0, 0, 0.501432,-99)    );
  // itree = 177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34883, 0, 1, 0.854018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783516,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305299,-99) , 
0, 0.790707, 1, 0, 0.593483,-99) , 
3, 1.00736, 0, 0, 0.7195,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288355,-99) , 
0, -0.661533, 1, 0, 0.437686,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.165896,-99) , 
3, -0.379167, 0, 0, 0.258931,-99) , 
3, 0.17816, 0, 0, 0.484747,-99)    );
  // itree = 178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.78155,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275615,-99) , 
0, 0.0283988, 1, 0, 0.510861,-99) , 
3, 0.688611, 0, 0, 0.650471,-99) , 
NN(
0, 
0, 
-1, -1.19084, 0, -1, 0.188714,-99) , 
3, -0.43837, 0, 0, 0.496745,-99)    );
  // itree = 179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65662, 0, 1, 0.845701,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366064,-99) , 
0, 0.586354, 1, 0, 0.581548,-99) , 
3, 1.00821, 0, 0, 0.725206,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306278,-99) , 
0, -0.661533, 1, 0, 0.476932,-99) , 
NN(
0, 
0, 
-1, -1.52871, 0, -1, 0.153062,-99) , 
3, -0.327012, 0, 0, 0.252756,-99) , 
3, 0.20809, 0, 0, 0.47372,-99)    );
  // itree = 180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.926503, 1, 1, 0.784596,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436608,-99) , 
0, -0.701595, 1, 0, 0.552523,-99) , 
3, 0.397655, 0, 0, 0.707709,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.219282,-99) , 
3, -0.28269, 0, 0, 0.518743,-99)    );
  // itree = 181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.27254, 0, 1, 0.783968,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277216,-99) , 
0, -1.27311, 1, 0, 0.361104,-99) , 
NN(
0, 
0, 
-1, -0.0797752, 1, -1, 0.0980146,-99) , 
3, -1.27444, 0, 0, 0.301582,-99) , 
3, 0.301115, 0, 0, 0.509876,-99)    );
  // itree = 182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.863022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431382,-99) , 
0, 0.893448, 1, 0, 0.670961,-99) , 
3, 1.22356, 0, 0, 0.753573,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34148,-99) , 
0, -0.676329, 1, 0, 0.461931,-99) , 
NN(
0, 
0, 
-1, -1.22523, 0, -1, 0.192597,-99) , 
3, -0.373281, 0, 0, 0.289421,-99) , 
3, 0.254861, 0, 0, 0.502962,-99)    );
  // itree = 183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.848785,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455162,-99) , 
0, 0.210411, 1, 0, 0.645289,-99) , 
3, 0.890353, 0, 0, 0.744107,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.203337,-99) , 
3, -0.202496, 0, 0, 0.508224,-99)    );
  // itree = 184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.31381, 0, 1, 0.799573,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248664,-99) , 
0, -0.0349451, 1, 0, 0.422525,-99) , 
NN(
0, 
0, 
-1, -1.86171, 1, -1, 0.136366,-99) , 
3, -0.608675, 0, 0, 0.28796,-99) , 
3, 0.569166, 0, 0, 0.468054,-99)    );
  // itree = 185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62101, 1, 1, 0.860641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335322,-99) , 
0, 0.785143, 1, 0, 0.618112,-99) , 
3, 1.10862, 0, 0, 0.716463,-99) , 
NN(
0, 
0, 
-1, -0.513047, 0, -1, 0.210172,-99) , 
3, -0.202496, 0, 0, 0.50072,-99)    );
  // itree = 186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.800351, 1, 1, 0.86876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306683,-99) , 
0, 0.927565, 1, 0, 0.55402,-99) , 
3, 1.17325, 0, 0, 0.649082,-99) , 
NN(
0, 
0, 
-1, -0.586434, 1, -1, 0.119044,-99) , 
3, -0.747335, 0, 0, 0.496018,-99)    );
  // itree = 187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.777489, 1, 1, 0.810907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274142,-99) , 
0, -0.0844621, 1, 0, 0.535727,-99) , 
3, 0.543354, 0, 0, 0.70902,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196753,-99) , 
0, -1.30478, 1, 0, 0.338695,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.133075,-99) , 
3, -1.00886, 0, 0, 0.246905,-99) , 
3, -0.123397, 0, 0, 0.5098,-99)    );
  // itree = 188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37449, 0, 1, 0.776618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339428,-99) , 
1, -0.214834, 1, 0, 0.496284,-99) , 
3, 0.388209, 0, 0, 0.676623,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.196995,-99) , 
3, -0.304384, 0, 0, 0.499453,-99)    );
  // itree = 189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.956191, 1, 1, 0.827378,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329602,-99) , 
0, 0.46484, 1, 0, 0.5551,-99) , 
3, 0.775589, 0, 0, 0.705414,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.138216,-99) , 
0, -1.41105, 1, 0, 0.28415,-99) , 
NN(
0, 
0, 
-1, 0.171487, 1, -1, 0.0810738,-99) , 
3, -1.32588, 0, 0, 0.215525,-99) , 
3, -0.10679, 0, 0, 0.49709,-99)    );
  // itree = 190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.896711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397342,-99) , 
0, 1.49606, 1, 0, 0.672348,-99) , 
3, 1.43422, 0, 0, 0.739388,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.190689,-99) , 
3, -0.123397, 0, 0, 0.513698,-99)    );
  // itree = 191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.800351, 1, 1, 0.857768,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340938,-99) , 
0, 0.891, 1, 0, 0.612982,-99) , 
3, 1.13355, 0, 0, 0.711521,-99) , 
NN(
0, 
0, 
-1, -0.899567, 0, -1, 0.253069,-99) , 
3, -0.176229, 0, 0, 0.531962,-99)    );
  // itree = 192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.824605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446979,-99) , 
0, 0.373872, 1, 0, 0.618872,-99) , 
3, 1.20395, 0, 0, 0.68732,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.233566,-99) , 
3, -0.123397, 0, 0, 0.504648,-99)    );
  // itree = 193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.877286,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315109,-99) , 
0, 1.06604, 1, 0, 0.644009,-99) , 
3, 1.30526, 0, 0, 0.741911,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572549,-99) , 
NN(
0, 
0, 
-1, -1.35625, 1, -1, 0.267219,-99) , 
3, 0.00883236, 0, 0, 0.309007,-99) , 
3, 0.28719, 0, 0, 0.501292,-99)    );
  // itree = 194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.860272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462307,-99) , 
0, 0.900473, 1, 0, 0.640097,-99) , 
3, 1.37125, 0, 0, 0.708004,-99) , 
NN(
0, 
0, 
-1, -0.963597, 0, -1, 0.183902,-99) , 
3, -0.210183, 0, 0, 0.496646,-99)    );
  // itree = 195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.53646, 0, 1, 0.866504,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374333,-99) , 
3, 1.22862, 0, 0, 0.678012,-99) , 
0, 1.09855, 1, 0, 0.762139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503696,-99) , 
NN(
0, 
0, 
-1, -1.05677, 0, -1, 0.193651,-99) , 
3, -0.0556818, 0, 0, 0.246045,-99) , 
3, 0.223327, 0, 0, 0.478869,-99)    );
  // itree = 196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.121389, 0, 1, 0.918742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358537,-99) , 
3, 1.00843, 0, 0, 0.689961,-99) , 
0, 0.768458, 1, 0, 0.759077,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273377,-99) , 
0, -0.890178, 1, 0, 0.395223,-99) , 
NN(
0, 
0, 
-1, -1.68074, 0, -1, 0.138152,-99) , 
3, -0.891745, 0, 0, 0.306197,-99) , 
3, 0.392653, 0, 0, 0.484619,-99)    );
  // itree = 197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.715094, 0, 1, 0.860347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326846,-99) , 
3, 1.16544, 0, 0, 0.656552,-99) , 
0, 1.09855, 1, 0, 0.736706,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27871,-99) , 
0, -0.991976, 1, 0, 0.379557,-99) , 
NN(
0, 
0, 
-1, -2.47814, 1, -1, 0.154065,-99) , 
3, -0.796022, 0, 0, 0.278738,-99) , 
3, 0.28719, 0, 0, 0.486241,-99)    );
  // itree = 198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38748, 0, 1, 0.710082,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195284,-99) , 
0, -1.29706, 1, 0, 0.32754,-99) , 
NN(
0, 
0, 
-1, -0.0809365, 1, -1, 0.122054,-99) , 
3, -1.16979, 0, 0, 0.233692,-99) , 
3, -0.18324, 0, 0, 0.522069,-99)    );
  // itree = 199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.867997,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261557,-99) , 
0, 0.852865, 1, 0, 0.64321,-99) , 
3, 1.08418, 0, 0, 0.760199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548449,-99) , 
NN(
0, 
0, 
-1, -1.21931, 0, -1, 0.238873,-99) , 
3, -0.0116291, 0, 0, 0.301648,-99) , 
3, 0.306962, 0, 0, 0.500477,-99)    );
  // itree = 200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.841966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42205,-99) , 
0, 0.819377, 1, 0, 0.650393,-99) , 
3, 1.13026, 0, 0, 0.753221,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306782,-99) , 
0, -1.20938, 1, 0, 0.37584,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.128661,-99) , 
3, -1.00762, 0, 0, 0.285399,-99) , 
3, 0.325234, 0, 0, 0.480102,-99)    );
  // itree = 201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.82866,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346637,-99) , 
0, 0.738515, 1, 0, 0.582788,-99) , 
3, 1.09284, 0, 0, 0.664326,-99) , 
NN(
0, 
0, 
-1, -0.546181, 1, -1, 0.146444,-99) , 
3, -0.639447, 0, 0, 0.51069,-99)    );
  // itree = 202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.848572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287034,-99) , 
0, 0.708301, 1, 0, 0.568845,-99) , 
3, 1.00286, 0, 0, 0.680851,-99) , 
NN(
0, 
0, 
-1, -1.15954, 0, -1, 0.202342,-99) , 
3, -0.293955, 0, 0, 0.497409,-99)    );
  // itree = 203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15389, 1, 1, 0.773732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279213,-99) , 
0, -0.0750528, 1, 0, 0.530049,-99) , 
3, 0.525662, 0, 0, 0.666249,-99) , 
NN(
0, 
0, 
-1, -1.6623, 1, -1, 0.199201,-99) , 
3, -0.38184, 0, 0, 0.518623,-99)    );
  // itree = 204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84341, 0, 1, 0.851827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399946,-99) , 
0, 0.877072, 1, 0, 0.621418,-99) , 
3, 1.20885, 0, 0, 0.707669,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.222328,-99) , 
3, -0.123397, 0, 0, 0.489327,-99)    );
  // itree = 205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.319388, 0, 1, 0.7104,-99) , 
NN(
0, 
0, 
-1, -1.3073, 0, -1, 0.204491,-99) , 
3, -0.123397, 0, 0, 0.489859,-99)    );
  // itree = 206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80194, 1, 1, 0.867213,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295346,-99) , 
0, 0.917975, 1, 0, 0.552367,-99) , 
3, 0.983057, 0, 0, 0.675134,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.139594,-99) , 
3, -0.376892, 0, 0, 0.481136,-99)    );
  // itree = 207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74309, 0, 1, 0.837029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461711,-99) , 
0, 0.210411, 1, 0, 0.604304,-99) , 
3, 0.902737, 0, 0, 0.708974,-99) , 
NN(
0, 
0, 
-1, -1.36791, 0, -1, 0.231167,-99) , 
3, -0.202496, 0, 0, 0.51699,-99)    );
  // itree = 208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.871624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334147,-99) , 
0, 0.915639, 1, 0, 0.604036,-99) , 
3, 1.32689, 0, 0, 0.686692,-99) , 
NN(
0, 
0, 
-1, -0.787163, 0, -1, 0.208992,-99) , 
3, -0.202496, 0, 0, 0.506606,-99)    );
  // itree = 209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.774205, 0, 1, 0.867004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42462,-99) , 
3, 1.34572, 0, 0, 0.713013,-99) , 
0, 1.10708, 1, 0, 0.783036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345211,-99) , 
0, -0.741881, 1, 0, 0.494238,-99) , 
NN(
0, 
0, 
-1, -1.82808, 1, -1, 0.138023,-99) , 
3, -0.391477, 0, 0, 0.255347,-99) , 
3, 0.254861, 0, 0, 0.502115,-99)    );
  // itree = 210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.98364, 1, 1, 0.819858,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.930499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411004,-99) , 
0, -0.0850049, 1, 0, 0.573808,-99) , 
3, 0.800667, 0, 0, 0.728469,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311753,-99) , 
1, -0.472421, 1, 0, 0.402332,-99) , 
NN(
0, 
0, 
-1, -2.16542, 1, -1, 0.155381,-99) , 
3, -0.662387, 0, 0, 0.272793,-99) , 
3, 0.17816, 0, 0, 0.495049,-99)    );
  // itree = 211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50815, 1, 1, 0.860679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300602,-99) , 
0, 0.979653, 1, 0, 0.604998,-99) , 
3, 1.20395, 0, 0, 0.697857,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181426,-99) , 
0, -1.08285, 1, 0, 0.310958,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0878071,-99) , 
3, -1.00946, 0, 0, 0.205502,-99) , 
3, -0.123397, 0, 0, 0.489154,-99)    );
  // itree = 212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.976195,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480503,-99) , 
3, 1.06575, 0, 0, 0.736767,-99) , 
0, 0.311772, 1, 0, 0.780861,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332246,-99) , 
0, -0.773268, 1, 0, 0.449115,-99) , 
NN(
0, 
0, 
-1, -0.973291, 0, -1, 0.191777,-99) , 
3, -0.509866, 0, 0, 0.301012,-99) , 
3, 0.271497, 0, 0, 0.512689,-99)    );
  // itree = 213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.853755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368242,-99) , 
0, 0.943047, 1, 0, 0.629411,-99) , 
3, 1.12392, 0, 0, 0.724872,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213732,-99) , 
0, -1.2877, 1, 0, 0.332134,-99) , 
NN(
0, 
0, 
-1, -0.925129, 1, -1, 0.100496,-99) , 
3, -0.990852, 0, 0, 0.233143,-99) , 
3, 0.0990605, 0, 0, 0.467121,-99)    );
  // itree = 214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.84165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318632,-99) , 
0, 0.708301, 1, 0, 0.610229,-99) , 
3, 0.985321, 0, 0, 0.716033,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.209398,-99) , 
3, -0.123397, 0, 0, 0.522276,-99)    );
  // itree = 215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2574, 1, 1, 0.858273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24426,-99) , 
0, 1.06604, 1, 0, 0.621325,-99) , 
3, 1.07875, 0, 0, 0.737971,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340172,-99) , 
1, -0.801586, 1, 0, 0.412345,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.102416,-99) , 
3, -0.959342, 0, 0, 0.280366,-99) , 
3, 0.301115, 0, 0, 0.485806,-99)    );
  // itree = 216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.681536, 0, 1, 0.748177,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234845,-99) , 
0, -0.390046, 1, 0, 0.397281,-99) , 
NN(
0, 
0, 
-1, -1.49567, 0, -1, 0.172555,-99) , 
3, -0.553771, 0, 0, 0.264788,-99) , 
3, 0.262941, 0, 0, 0.467884,-99)    );
  // itree = 217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.818562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341345,-99) , 
0, -0.158894, 1, 0, 0.534421,-99) , 
3, 0.734957, 0, 0, 0.696214,-99) , 
NN(
0, 
0, 
-1, -0.654099, 0, -1, 0.203268,-99) , 
3, -0.160313, 0, 0, 0.480397,-99)    );
  // itree = 218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.804025,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257856,-99) , 
0, -0.795567, 1, 0, 0.36692,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.109717,-99) , 
3, -1.03006, 0, 0, 0.277917,-99) , 
3, 0.307824, 0, 0, 0.506262,-99)    );
  // itree = 219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.850106,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341646,-99) , 
0, 0.802635, 1, 0, 0.641955,-99) , 
3, 1.12392, 0, 0, 0.737451,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273372,-99) , 
0, -0.85877, 1, 0, 0.424995,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.116895,-99) , 
3, -0.990852, 0, 0, 0.278933,-99) , 
3, 0.0990605, 0, 0, 0.517498,-99)    );
  // itree = 220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.868897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309414,-99) , 
0, 0.957246, 1, 0, 0.586343,-99) , 
3, 1.24562, 0, 0, 0.679336,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.121791,-99) , 
0, -1.43523, 1, 0, 0.283137,-99) , 
NN(
0, 
0, 
-1, -0.213943, 1, -1, 0.0688981,-99) , 
3, -1.51206, 0, 0, 0.211028,-99) , 
3, -0.299834, 0, 0, 0.511613,-99)    );
  // itree = 221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53268, 1, 1, 0.883871,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348726,-99) , 
0, 0.852865, 1, 0, 0.627781,-99) , 
3, 1.21755, 0, 0, 0.731128,-99) , 
NN(
0, 
0, 
-1, -0.376357, 0, -1, 0.268568,-99) , 
3, 0.17816, 0, 0, 0.481774,-99)    );
  // itree = 222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.6682, 0, 1, 0.779373,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373076,-99) , 
0, -0.781662, 1, 0, 0.489163,-99) , 
NN(
0, 
0, 
-1, -1.80475, 1, -1, 0.158506,-99) , 
3, -0.46735, 0, 0, 0.28853,-99) , 
3, 0.310134, 0, 0, 0.504354,-99)    );
  // itree = 223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.877101,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345278,-99) , 
0, 1.14512, 1, 0, 0.630123,-99) , 
3, 1.37777, 0, 0, 0.739401,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301354,-99) , 
0, -0.606721, 1, 0, 0.462605,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.165588,-99) , 
3, -0.566981, 0, 0, 0.308503,-99) , 
3, 0.392653, 0, 0, 0.476224,-99)    );
  // itree = 224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.409305, 0, 1, 0.91976,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407311,-99) , 
3, 1.12644, 0, 0, 0.720419,-99) , 
0, 0.873608, 1, 0, 0.788541,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314588,-99) , 
0, -1.2877, 1, 0, 0.399305,-99) , 
NN(
0, 
0, 
-1, -0.0154624, 1, -1, 0.0898128,-99) , 
3, -0.997833, 0, 0, 0.28391,-99) , 
3, 0.254861, 0, 0, 0.506955,-99)    );
  // itree = 225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.855005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357854,-99) , 
0, 0.0020298, 1, 0, 0.58342,-99) , 
3, 0.713004, 0, 0, 0.729433,-99) , 
NN(
0, 
0, 
-1, -0.955363, 0, -1, 0.212636,-99) , 
3, -0.210183, 0, 0, 0.530112,-99)    );
  // itree = 226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.416851, 1, 1, 0.883793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44098,-99) , 
3, 1.32762, 0, 0, 0.706308,-99) , 
0, 1.16902, 1, 0, 0.783538,-99) , 
NN(
0, 
0, 
-1, -0.959342, 0, -1, 0.290395,-99) , 
3, 0.301115, 0, 0, 0.496289,-99)    );
  // itree = 227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.871979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440273,-99) , 
0, 0.904545, 1, 0, 0.717645,-99) , 
3, 1.2248, 0, 0, 0.789231,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255793,-99) , 
0, -1.41697, 1, 0, 0.345247,-99) , 
NN(
0, 
0, 
-1, -3.0191, 1, -1, 0.115662,-99) , 
3, -1.35734, 0, 0, 0.281479,-99) , 
3, 0.228725, 0, 0, 0.51548,-99)    );
  // itree = 228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6139, 1, 1, 0.869985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36221,-99) , 
0, 0.852865, 1, 0, 0.630881,-99) , 
3, 1.08418, 0, 0, 0.750975,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19647,-99) , 
0, -0.301216, 1, 0, 0.434858,-99) , 
NN(
0, 
0, 
-1, -1.20105, 1, -1, 0.182972,-99) , 
3, -0.325669, 0, 0, 0.269537,-99) , 
3, 0.306962, 0, 0, 0.468672,-99)    );
  // itree = 229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90389, 1, 1, 0.871595,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453531,-99) , 
0, 1.0116, 1, 0, 0.654335,-99) , 
3, 1.31288, 0, 0, 0.724966,-99) , 
NN(
0, 
0, 
-1, -1.84385, 0, -1, 0.189702,-99) , 
3, -0.200632, 0, 0, 0.500359,-99)    );
  // itree = 230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53058, 0, 1, 0.859852,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484673,-99) , 
0, 0.416198, 1, 0, 0.645289,-99) , 
3, 1.21436, 0, 0, 0.739944,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323087,-99) , 
0, -0.765399, 1, 0, 0.415953,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.160117,-99) , 
3, -0.659699, 0, 0, 0.257877,-99) , 
3, 0.17816, 0, 0, 0.493169,-99)    );
  // itree = 231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.770105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325219,-99) , 
0, -0.231503, 1, 0, 0.499198,-99) , 
3, 0.546413, 0, 0, 0.67198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157083,-99) , 
0, -1.21605, 1, 0, 0.313936,-99) , 
NN(
0, 
0, 
-1, -0.301872, 1, -1, 0.0951345,-99) , 
3, -1.00886, 0, 0, 0.218151,-99) , 
3, -0.123397, 0, 0, 0.488224,-99)    );
  // itree = 232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.861282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337468,-99) , 
0, 0.789761, 1, 0, 0.653298,-99) , 
3, 1.11353, 0, 0, 0.750724,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622936,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252458,-99) , 
0, -0.773268, 1, 0, 0.375461,-99) , 
NN(
0, 
0, 
-1, -2.29656, 1, -1, 0.141329,-99) , 
3, -0.725985, 0, 0, 0.252652,-99) , 
3, 0.093663, 0, 0, 0.487015,-99)    );
  // itree = 233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32168, 0, 1, 0.867165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.885085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421264,-99) , 
0, 0.782483, 1, 0, 0.6922,-99) , 
3, 1.00508, 0, 0, 0.793943,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275704,-99) , 
0, -0.602719, 1, 0, 0.433225,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.17469,-99) , 
3, -0.398285, 0, 0, 0.262057,-99) , 
3, 0.234307, 0, 0, 0.501493,-99)    );
  // itree = 234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.13153, 1, 1, 0.938865,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491864,-99) , 
3, 1.11058, 0, 0, 0.749897,-99) , 
0, 0.709428, 1, 0, 0.812885,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277431,-99) , 
0, -0.670524, 1, 0, 0.461234,-99) , 
NN(
0, 
0, 
-1, -2.20845, 1, -1, 0.154467,-99) , 
3, -0.703294, 0, 0, 0.298418,-99) , 
3, 0.234307, 0, 0, 0.532224,-99)    );
  // itree = 235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.75932, 1, 1, 0.908686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43612,-99) , 
0, 0.920728, 1, 0, 0.6597,-99) , 
3, 1.48623, 0, 0, 0.731691,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22175,-99) , 
0, -1.18308, 1, 0, 0.345498,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.09096,-99) , 
3, -1.11972, 0, 0, 0.219206,-99) , 
3, -0.25059, 0, 0, 0.518767,-99)    );
  // itree = 236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.853583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333929,-99) , 
0, 0.789761, 1, 0, 0.612085,-99) , 
3, 1.10856, 0, 0, 0.727115,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215551,-99) , 
0, -0.991976, 1, 0, 0.368874,-99) , 
NN(
0, 
0, 
-1, 0.186278, 1, -1, 0.126403,-99) , 
3, -0.921731, 0, 0, 0.253319,-99) , 
3, 0.126889, 0, 0, 0.479777,-99)    );
  // itree = 237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16801, 1, 1, 0.827453,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312334,-99) , 
0, 0.591363, 1, 0, 0.598676,-99) , 
3, 0.98281, 0, 0, 0.708064,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165572,-99) , 
3, -1.10712, 0, 0, 0.300586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.147268,-99) , 
0, -1.36539, 1, 0, 0.221131,-99) , 
3, -0.123397, 0, 0, 0.50001,-99)    );
  // itree = 238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.867555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363023,-99) , 
0, 0.852865, 1, 0, 0.67268,-99) , 
3, 1.18459, 0, 0, 0.761271,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289268,-99) , 
0, -1.2877, 1, 0, 0.411235,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0879926,-99) , 
3, -1.14976, 0, 0, 0.287647,-99) , 
3, 0.183842, 0, 0, 0.514207,-99)    );
  // itree = 239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38501, 1, 1, 0.802821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303162,-99) , 
0, 0.327519, 1, 0, 0.565416,-99) , 
3, 0.784219, 0, 0, 0.721659,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289037,-99) , 
0, -0.991976, 1, 0, 0.397171,-99) , 
NN(
0, 
0, 
-1, -2.40917, 1, -1, 0.107214,-99) , 
3, -1.15126, 0, 0, 0.288721,-99) , 
3, 0.183842, 0, 0, 0.490301,-99)    );
  // itree = 240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34586, 1, 1, 0.807832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287152,-99) , 
0, 0.248521, 1, 0, 0.555437,-99) , 
3, 0.644104, 0, 0, 0.709519,-99) , 
NN(
0, 
0, 
-1, -0.505712, 0, -1, 0.213455,-99) , 
3, 0.0354976, 0, 0, 0.465408,-99)    );
  // itree = 241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.830718, 0, 1, 0.877125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432034,-99) , 
3, 1.32987, 0, 0, 0.695457,-99) , 
0, 1.06258, 1, 0, 0.774469,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284468,-99) , 
3, -0.118634, 0, 0, 0.366165,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.123989,-99) , 
3, -0.959342, 0, 0, 0.271268,-99) , 
3, 0.306962, 0, 0, 0.479165,-99)    );
  // itree = 242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.88361, 0, 1, 0.72644,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.204113,-99) , 
3, -0.38184, 0, 0, 0.533393,-99)    );
  // itree = 243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.718049, 1, 1, 0.770281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305818,-99) , 
0, -0.348921, 1, 0, 0.474997,-99) , 
3, 0.333196, 0, 0, 0.686111,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.203972,-99) , 
3, -0.123397, 0, 0, 0.47101,-99)    );
  // itree = 244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.821626,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287098,-99) , 
0, 0.224393, 1, 0, 0.567847,-99) , 
3, 0.698452, 0, 0, 0.71259,-99) , 
NN(
0, 
0, 
-1, -0.707631, 0, -1, 0.241234,-99) , 
3, -0.210183, 0, 0, 0.524157,-99)    );
  // itree = 245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.869926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37662,-99) , 
0, 0.191795, 1, 0, 0.551922,-99) , 
3, 1.08642, 0, 0, 0.669881,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.121653,-99) , 
0, -1.43399, 1, 0, 0.287687,-99) , 
NN(
0, 
0, 
-1, -2.94594, 1, -1, 0.0775066,-99) , 
3, -1.20485, 0, 0, 0.202419,-99) , 
3, -0.237768, 0, 0, 0.478563,-99)    );
  // itree = 246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49342, 0, 1, 0.806359,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345643,-99) , 
0, -0.0316589, 1, 0, 0.55973,-99) , 
3, 0.543354, 0, 0, 0.725466,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.189938,-99) , 
3, -0.123397, 0, 0, 0.497622,-99)    );
  // itree = 247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59996, 1, 1, 0.86864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368532,-99) , 
0, 1.0581, 1, 0, 0.682675,-99) , 
3, 1.21586, 0, 0, 0.764943,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308999,-99) , 
1, -0.279191, 1, 0, 0.444989,-99) , 
NN(
0, 
0, 
-1, -1.13675, 0, -1, 0.153538,-99) , 
3, -0.38455, 0, 0, 0.248468,-99) , 
3, 0.17816, 0, 0, 0.490637,-99)    );
  // itree = 248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.189145, 1, 1, 0.781402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426044,-99) , 
0, -0.886697, 1, 0, 0.521077,-99) , 
3, 0.111472, 0, 0, 0.721743,-99) , 
NN(
0, 
0, 
-1, -1.45163, 0, -1, 0.182402,-99) , 
3, -0.639447, 0, 0, 0.570838,-99)    );
  // itree = 249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.8579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282305,-99) , 
0, 1.0116, 1, 0, 0.542788,-99) , 
3, 1.2097, 0, 0, 0.638307,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.182401,-99) , 
3, -0.376892, 0, 0, 0.479973,-99)    );
  // itree = 250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6221, 1, 1, 0.879028,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41087,-99) , 
0, 0.459356, 1, 0, 0.648199,-99) , 
3, 1.20395, 0, 0, 0.736096,-99) , 
NN(
0, 
0, 
-1, -0.610343, 1, -1, 0.208837,-99) , 
3, -0.123397, 0, 0, 0.518846,-99)    );
  // itree = 251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.87392, 1, 1, 0.880541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34445,-99) , 
0, 1.15791, 1, 0, 0.675175,-99) , 
3, 1.29551, 0, 0, 0.769089,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185344,-99) , 
0, -0.211824, 1, 0, 0.385664,-99) , 
NN(
0, 
0, 
-1, -2.47814, 1, -1, 0.131161,-99) , 
3, -0.796022, 0, 0, 0.265604,-99) , 
3, 0.28719, 0, 0, 0.487934,-99)    );
  // itree = 252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.709428, 1, 1, 0.759193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466254,-99) , 
3, 0.235551, 0, 0, 0.69246,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.220023,-99) , 
3, -0.202496, 0, 0, 0.491572,-99)    );
  // itree = 253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.867145,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43661,-99) , 
0, 0.486742, 1, 0, 0.581909,-99) , 
3, 1.20395, 0, 0, 0.691777,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.213194,-99) , 
3, -0.123397, 0, 0, 0.491266,-99)    );
  // itree = 254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.440382, 1, 1, 0.901913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419077,-99) , 
3, 1.36758, 0, 0, 0.708584,-99) , 
0, 1.15389, 1, 0, 0.793645,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364676,-99) , 
0, -0.665699, 1, 0, 0.475246,-99) , 
NN(
0, 
0, 
-1, -1.22769, 0, -1, 0.19678,-99) , 
3, -0.375091, 0, 0, 0.304959,-99) , 
3, 0.254861, 0, 0, 0.54636,-99)    );
  // itree = 255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81512, 1, 1, 0.883307,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459629,-99) , 
0, 0.240286, 1, 0, 0.64448,-99) , 
3, 1.20395, 0, 0, 0.731887,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172375,-99) , 
3, -1.00946, 0, 0, 0.303736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.081187,-99) , 
0, -0.924663, 1, 0, 0.224644,-99) , 
3, -0.123397, 0, 0, 0.507036,-99)    );
  // itree = 256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15406, 1, 1, 0.83058,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370545,-99) , 
0, -0.0834363, 1, 0, 0.54979,-99) , 
3, 0.772923, 0, 0, 0.67973,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.215642,-99) , 
3, -0.376892, 0, 0, 0.51616,-99)    );
  // itree = 257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.890647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399656,-99) , 
0, 0.210411, 1, 0, 0.585198,-99) , 
3, 1.2063, 0, 0, 0.692019,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.209535,-99) , 
3, -0.123397, 0, 0, 0.510887,-99)    );
  // itree = 258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09773, 0, 1, 0.904423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464329,-99) , 
3, 1.63732, 0, 0, 0.731655,-99) , 
0, 1.50474, 1, 0, 0.828918,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310366,-99) , 
0, -1.19528, 1, 0, 0.395093,-99) , 
NN(
0, 
0, 
-1, -2.4918, 1, -1, 0.104808,-99) , 
3, -1.09626, 0, 0, 0.295251,-99) , 
3, 0.228725, 0, 0, 0.539329,-99)    );
  // itree = 259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3403, 1, 1, 0.857964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.906885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469179,-99) , 
0, -0.117292, 1, 0, 0.616823,-99) , 
3, 0.999126, 0, 0, 0.723836,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192102,-99) , 
0, -1.17488, 1, 0, 0.357312,-99) , 
NN(
0, 
0, 
-1, -0.279363, 1, -1, 0.131195,-99) , 
3, -1.00886, 0, 0, 0.25276,-99) , 
3, -0.123397, 0, 0, 0.531549,-99)    );
  // itree = 260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418735,-99) , 
3, 0.982331, 0, 0, 0.674461,-99) , 
0, 0.298272, 1, 0, 0.729257,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327701,-99) , 
0, -0.665699, 1, 0, 0.49855,-99) , 
NN(
0, 
0, 
-1, -1.59136, 1, -1, 0.190606,-99) , 
3, -0.36571, 0, 0, 0.286,-99) , 
3, 0.178444, 0, 0, 0.472083,-99)    );
  // itree = 261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.887669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362417,-99) , 
0, 0.852865, 1, 0, 0.634935,-99) , 
3, 1.09392, 0, 0, 0.767305,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293553,-99) , 
0, -1.24216, 1, 0, 0.372072,-99) , 
NN(
0, 
0, 
-1, -0.546181, 1, -1, 0.129187,-99) , 
3, -1.06961, 0, 0, 0.294236,-99) , 
3, 0.28719, 0, 0, 0.501886,-99)    );
  // itree = 262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50161, 1, 1, 0.855528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.914165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437401,-99) , 
0, 0.199449, 1, 0, 0.592837,-99) , 
3, 1.0077, 0, 0, 0.722651,-99) , 
NN(
0, 
0, 
-1, -0.376357, 0, -1, 0.250159,-99) , 
3, 0.17816, 0, 0, 0.477228,-99)    );
  // itree = 263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89693, 0, 1, 0.844891,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41197,-99) , 
0, -0.0450448, 1, 0, 0.559674,-99) , 
3, 1.07541, 0, 0, 0.662768,-99) , 
NN(
0, 
0, 
-1, -1.06797, 0, -1, 0.167623,-99) , 
3, -0.304384, 0, 0, 0.468901,-99)    );
  // itree = 264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.878176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191038,-99) , 
0, 0.979653, 1, 0, 0.574248,-99) , 
3, 1.10245, 0, 0, 0.700299,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18431,-99) , 
3, -1.08857, 0, 0, 0.316545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.125651,-99) , 
0, -1.36539, 1, 0, 0.233851,-99) , 
3, -0.207894, 0, 0, 0.502788,-99)    );
  // itree = 265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.171593, 1, 1, 0.723338,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236816,-99) , 
0, -1.23103, 1, 0, 0.368381,-99) , 
NN(
0, 
0, 
-1, -1.80314, 1, -1, 0.120859,-99) , 
3, -1.00886, 0, 0, 0.261337,-99) , 
3, -0.123397, 0, 0, 0.522525,-99)    );
  // itree = 266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62101, 1, 1, 0.805698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233462,-99) , 
0, 0.8372, 1, 0, 0.562286,-99) , 
3, 1.07541, 0, 0, 0.649804,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.195378,-99) , 
3, -0.304384, 0, 0, 0.480872,-99)    );
  // itree = 267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.846982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308146,-99) , 
0, 0.682701, 1, 0, 0.630976,-99) , 
3, 0.994438, 0, 0, 0.733511,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.247719,-99) , 
3, -0.123397, 0, 0, 0.526371,-99)    );
  // itree = 268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.835687,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438448,-99) , 
0, 0.767537, 1, 0, 0.678116,-99) , 
3, 1.08361, 0, 0, 0.758887,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339795,-99) , 
0, -0.824413, 1, 0, 0.44875,-99) , 
NN(
0, 
0, 
-1, -0.0310174, 1, -1, 0.13271,-99) , 
3, -0.95623, 0, 0, 0.333299,-99) , 
3, 0.306962, 0, 0, 0.525111,-99)    );
  // itree = 269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55749, 1, 1, 0.847189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354174,-99) , 
0, 0.893448, 1, 0, 0.633034,-99) , 
3, 1.07833, 0, 0, 0.742524,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341182,-99) , 
0, -0.818848, 1, 0, 0.470989,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.175173,-99) , 
3, -0.55622, 0, 0, 0.300315,-99) , 
3, 0.262941, 0, 0, 0.49269,-99)    );
  // itree = 270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.801529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414874,-99) , 
0, -0.0412356, 1, 0, 0.547616,-99) , 
3, 0.713004, 0, 0, 0.678866,-99) , 
NN(
0, 
0, 
-1, -0.96519, 0, -1, 0.182548,-99) , 
3, -0.210183, 0, 0, 0.47357,-99)    );
  // itree = 271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.811023, 1, 1, 0.761613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380553,-99) , 
1, -0.654311, 1, 0, 0.475693,-99) , 
3, 0.23261, 0, 0, 0.658433,-99) , 
NN(
0, 
0, 
-1, -1.79745, 1, -1, 0.140321,-99) , 
3, -0.711707, 0, 0, 0.512041,-99)    );
  // itree = 272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.72973, 1, 1, 0.811143,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238479,-99) , 
0, 0.26745, 1, 0, 0.479689,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.178173,-99) , 
3, -0.458043, 0, 0, 0.345579,-99) , 
3, 0.684423, 0, 0, 0.504959,-99)    );
  // itree = 273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.25391, 0, 1, 0.752116,-99) , 
NN(
0, 
0, 
-1, -1.04325, 0, -1, 0.264867,-99) , 
3, 0.0354976, 0, 0, 0.504586,-99)    );
  // itree = 274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.354904, 1, 1, 0.921858,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368735,-99) , 
3, 1.20293, 0, 0, 0.662578,-99) , 
0, 0.709428, 1, 0, 0.746087,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307205,-99) , 
0, -0.646644, 1, 0, 0.443378,-99) , 
NN(
0, 
0, 
-1, -1.23913, 0, -1, 0.1284,-99) , 
3, -0.702968, 0, 0, 0.269042,-99) , 
3, 0.234307, 0, 0, 0.493553,-99)    );
  // itree = 275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.862397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299642,-99) , 
0, 1.10079, 1, 0, 0.651638,-99) , 
3, 1.16365, 0, 0, 0.733036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171523,-99) , 
0, -1.1996, 1, 0, 0.299306,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.0986485,-99) , 
3, -1.16979, 0, 0, 0.216473,-99) , 
3, -0.18324, 0, 0, 0.526888,-99)    );
  // itree = 276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42509, 0, 1, 0.695783,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.202553,-99) , 
3, -0.123397, 0, 0, 0.492665,-99)    );
  // itree = 277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43703, 1, 1, 0.855467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48751,-99) , 
0, 0.459356, 1, 0, 0.647006,-99) , 
3, 1.20395, 0, 0, 0.723051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565372,-99) , 
NN(
0, 
0, 
-1, -0.981869, 0, -1, 0.1917,-99) , 
3, -0.419849, 0, 0, 0.26234,-99) , 
3, -0.123397, 0, 0, 0.530675,-99)    );
  // itree = 278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.67635, 0, 1, 0.809169,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246173,-99) , 
0, 0.358499, 1, 0, 0.461472,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.137226,-99) , 
3, -0.488708, 0, 0, 0.304225,-99) , 
3, 0.636885, 0, 0, 0.467709,-99)    );
  // itree = 279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06258, 1, 1, 0.788197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487264,-99) , 
3, 0.246321, 0, 0, 0.723271,-99) , 
NN(
0, 
0, 
-1, -0.707631, 0, -1, 0.243158,-99) , 
3, -0.210183, 0, 0, 0.528903,-99)    );
  // itree = 280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20144, 1, 1, 0.869864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366919,-99) , 
0, 1.1735, 1, 0, 0.663715,-99) , 
3, 1.42967, 0, 0, 0.719336,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.199864,-99) , 
3, -0.123397, 0, 0, 0.484736,-99)    );
  // itree = 281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90389, 1, 1, 0.869019,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35363,-99) , 
0, 0.848875, 1, 0, 0.615062,-99) , 
3, 1.22765, 0, 0, 0.699429,-99) , 
NN(
0, 
0, 
-1, -1.02979, 0, -1, 0.172198,-99) , 
3, -0.294298, 0, 0, 0.49667,-99)    );
  // itree = 282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.385953, 1, 1, 0.752924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462475,-99) , 
3, 0.235551, 0, 0, 0.682572,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185981,-99) , 
0, -1.36423, 1, 0, 0.32522,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.101892,-99) , 
3, -1.07684, 0, 0, 0.213699,-99) , 
3, -0.202496, 0, 0, 0.484119,-99)    );
  // itree = 283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4124, 1, 1, 0.793789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254638,-99) , 
0, 0.0477724, 1, 0, 0.53838,-99) , 
3, 0.52978, 0, 0, 0.691687,-99) , 
NN(
0, 
0, 
-1, -1.62443, 0, -1, 0.178584,-99) , 
3, -0.376892, 0, 0, 0.504146,-99)    );
  // itree = 284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.94061, 1, 1, 0.882158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400488,-99) , 
0, 1.09344, 1, 0, 0.674026,-99) , 
3, 1.42554, 0, 0, 0.74672,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337846,-99) , 
0, -0.616482, 1, 0, 0.481582,-99) , 
NN(
0, 
0, 
-1, -1.7862, 1, -1, 0.194603,-99) , 
3, -0.376357, 0, 0, 0.283667,-99) , 
3, 0.17816, 0, 0, 0.495261,-99)    );
  // itree = 285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.65169, 0, 1, 0.713137,-99) , 
NN(
0, 
0, 
-1, -0.505712, 0, -1, 0.265987,-99) , 
3, 0.0354976, 0, 0, 0.511244,-99)    );
  // itree = 286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.40059, 0, 1, 0.800557,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391553,-99) , 
0, -0.836171, 1, 0, 0.513652,-99) , 
NN(
0, 
0, 
-1, -1.25613, 0, -1, 0.190695,-99) , 
3, -0.386214, 0, 0, 0.317431,-99) , 
3, 0.238103, 0, 0, 0.543339,-99)    );
  // itree = 287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.871125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38418,-99) , 
0, 0.696072, 1, 0, 0.631472,-99) , 
3, 1.21436, 0, 0, 0.731612,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232132,-99) , 
0, -1.43519, 1, 0, 0.315404,-99) , 
NN(
0, 
0, 
-1, -2.58105, 1, -1, 0.0920088,-99) , 
3, -1.20546, 0, 0, 0.243009,-99) , 
3, 0.17816, 0, 0, 0.464226,-99)    );
  // itree = 288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.839062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39222,-99) , 
0, 0.708301, 1, 0, 0.60952,-99) , 
3, 1.20885, 0, 0, 0.688166,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.2019,-99) , 
3, -0.123397, 0, 0, 0.48054,-99)    );
  // itree = 289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.22876, 1, 1, 0.837523,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342981,-99) , 
0, 0.530902, 1, 0, 0.623066,-99) , 
3, 0.98281, 0, 0, 0.722407,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2043,-99) , 
0, -1.37863, 1, 0, 0.385799,-99) , 
NN(
0, 
0, 
-1, -0.572275, 1, -1, 0.127313,-99) , 
3, -1.00886, 0, 0, 0.250789,-99) , 
3, -0.123397, 0, 0, 0.515391,-99)    );
  // itree = 290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.305756, 1, 1, 0.861339,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43808,-99) , 
0, 0.373872, 1, 0, 0.629291,-99) , 
3, 1.21373, 0, 0, 0.71606,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.194051,-99) , 
3, -0.123397, 0, 0, 0.478721,-99)    );
  // itree = 291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.830554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379501,-99) , 
0, 0.569025, 1, 0, 0.620085,-99) , 
3, 1.0083, 0, 0, 0.738966,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297633,-99) , 
0, -1.04254, 1, 0, 0.425673,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.134259,-99) , 
3, -1.01511, 0, 0, 0.307929,-99) , 
3, 0.238103, 0, 0, 0.512659,-99)    );
  // itree = 292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.792722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496253,-99) , 
3, 0.305972, 0, 0, 0.717505,-99) , 
NN(
0, 
0, 
-1, -1.13611, 0, -1, 0.186492,-99) , 
3, -0.140969, 0, 0, 0.48197,-99)    );
  // itree = 293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48336, 1, 1, 0.817587,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.919801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385716,-99) , 
0, 0.213349, 1, 0, 0.599516,-99) , 
3, 0.819605, 0, 0, 0.734977,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235677,-99) , 
0, -0.393233, 1, 0, 0.404877,-99) , 
NN(
0, 
0, 
-1, -1.8135, 0, -1, 0.0810802,-99) , 
3, -1.01511, 0, 0, 0.278494,-99) , 
3, 0.238103, 0, 0, 0.492792,-99)    );
  // itree = 294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72801, 0, 1, 0.815704,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406575,-99) , 
0, -0.162683, 1, 0, 0.551106,-99) , 
3, 0.66689, 0, 0, 0.705211,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.179022,-99) , 
3, -0.207894, 0, 0, 0.501545,-99)    );
  // itree = 295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.81353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398911,-99) , 
0, -0.0316589, 1, 0, 0.622784,-99) , 
3, 0.540529, 0, 0, 0.74142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192834,-99) , 
0, -1.19072, 1, 0, 0.315417,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0947995,-99) , 
3, -1.00886, 0, 0, 0.20724,-99) , 
3, -0.123397, 0, 0, 0.51161,-99)    );
  // itree = 296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.803063,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263211,-99) , 
0, 0.478161, 1, 0, 0.567034,-99) , 
3, 0.651529, 0, 0, 0.696103,-99) , 
NN(
0, 
0, 
-1, -0.969945, 0, -1, 0.174832,-99) , 
3, -0.232821, 0, 0, 0.475972,-99)    );
  // itree = 297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.86458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283643,-99) , 
0, 0.64261, 1, 0, 0.544287,-99) , 
3, 0.979677, 0, 0, 0.674775,-99) , 
NN(
0, 
0, 
-1, -1.06642, 0, -1, 0.236569,-99) , 
3, -0.340957, 0, 0, 0.51259,-99)    );
  // itree = 298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82535, 1, 1, 0.889296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367348,-99) , 
0, 0.852865, 1, 0, 0.675099,-99) , 
3, 1.07833, 0, 0, 0.786694,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310296,-99) , 
0, -0.448783, 1, 0, 0.470015,-99) , 
NN(
0, 
0, 
-1, -1.49884, 0, -1, 0.17489,-99) , 
3, -0.556192, 0, 0, 0.29025,-99) , 
3, 0.262941, 0, 0, 0.513382,-99)    );
  // itree = 299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.848404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489886,-99) , 
0, -0.14278, 1, 0, 0.591559,-99) , 
3, 1.21485, 0, 0, 0.688358,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181704,-99) , 
0, -0.894226, 1, 0, 0.295779,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0891077,-99) , 
3, -1.00886, 0, 0, 0.201439,-99) , 
3, -0.123397, 0, 0, 0.484389,-99)    );
  // itree = 300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.870206,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2475,-99) , 
0, 1.02331, 1, 0, 0.60242,-99) , 
3, 1.12671, 0, 0, 0.72142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270588,-99) , 
0, -1.23094, 1, 0, 0.373896,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.128569,-99) , 
3, -1.00022, 0, 0, 0.271116,-99) , 
3, 0.0990605, 0, 0, 0.507502,-99)    );
  // itree = 301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.71585, 1, 1, 0.875665,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.902331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334021,-99) , 
0, 0.9386, 1, 0, 0.678458,-99) , 
3, 1.17923, 0, 0, 0.782948,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340379,-99) , 
1, -0.558737, 1, 0, 0.436048,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.138026,-99) , 
3, -0.566981, 0, 0, 0.298116,-99) , 
3, 0.392653, 0, 0, 0.495798,-99)    );
  // itree = 302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.886508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254776,-99) , 
0, 1.3749, 1, 0, 0.66579,-99) , 
3, 1.42244, 0, 0, 0.737251,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310643,-99) , 
0, -1.44513, 1, 0, 0.379831,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.0720402,-99) , 
3, -1.21, 0, 0, 0.286706,-99) , 
3, 0.17816, 0, 0, 0.49934,-99)    );
  // itree = 303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.897674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469018,-99) , 
0, 1.37897, 1, 0, 0.70148,-99) , 
3, 1.51586, 0, 0, 0.761301,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251506,-99) , 
0, -0.802449, 1, 0, 0.382755,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.0919515,-99) , 
3, -1.17075, 0, 0, 0.278065,-99) , 
3, 0.141024, 0, 0, 0.508711,-99)    );
  // itree = 304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.847593,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498724,-99) , 
0, 0.426927, 1, 0, 0.64597,-99) , 
3, 1.42509, 0, 0, 0.70212,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155497,-99) , 
0, -1.34583, 1, 0, 0.320058,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.134774,-99) , 
3, -1.00886, 0, 0, 0.228009,-99) , 
3, -0.123397, 0, 0, 0.486968,-99)    );
  // itree = 305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42999, 1, 1, 0.82824,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401354,-99) , 
0, 0.175118, 1, 0, 0.641405,-99) , 
3, 0.700335, 0, 0, 0.740729,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219874,-99) , 
0, -1.21605, 1, 0, 0.330484,-99) , 
NN(
0, 
0, 
-1, -2.5847, 1, -1, 0.0813434,-99) , 
3, -1.13691, 0, 0, 0.227156,-99) , 
3, -0.176229, 0, 0, 0.528062,-99)    );
  // itree = 306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.810382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318381,-99) , 
0, 0.00230313, 1, 0, 0.521422,-99) , 
3, 0.540529, 0, 0, 0.707653,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.207495,-99) , 
3, -0.123397, 0, 0, 0.477727,-99)    );
  // itree = 307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61769, 1, 1, 0.869386,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807696,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270226,-99) , 
0, 1.12953, 1, 0, 0.638752,-99) , 
3, 1.27767, 0, 0, 0.744588,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323193,-99) , 
0, -0.616482, 1, 0, 0.421989,-99) , 
NN(
0, 
0, 
-1, -1.18692, 0, -1, 0.128593,-99) , 
3, -0.325669, 0, 0, 0.245173,-99) , 
3, 0.306962, 0, 0, 0.461859,-99)    );
  // itree = 308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.88009,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237679,-99) , 
0, 1.42991, 1, 0, 0.578826,-99) , 
3, 1.30512, 0, 0, 0.669183,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.163899,-99) , 
3, -0.304384, 0, 0, 0.474499,-99)    );
  // itree = 309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56056, 1, 1, 0.764625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243336,-99) , 
0, -0.00427319, 1, 0, 0.509369,-99) , 
3, 0.540529, 0, 0, 0.674088,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.176897,-99) , 
3, -0.123397, 0, 0, 0.44695,-99)    );
  // itree = 310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52065, 1, 1, 0.848668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.92105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363737,-99) , 
0, 0.569025, 1, 0, 0.652225,-99) , 
3, 1.02272, 0, 0, 0.754973,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35106,-99) , 
0, -1.20325, 1, 0, 0.420838,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.100109,-99) , 
3, -1.09308, 0, 0, 0.288703,-99) , 
3, 0.228725, 0, 0, 0.510448,-99)    );
  // itree = 311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.871495,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.95563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485068,-99) , 
0, 0.176028, 1, 0, 0.605569,-99) , 
3, 1.07875, 0, 0, 0.748182,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308155,-99) , 
0, -0.661533, 1, 0, 0.424522,-99) , 
NN(
0, 
0, 
-1, -1.36539, 1, -1, 0.157589,-99) , 
3, -0.329808, 0, 0, 0.243911,-99) , 
3, 0.301115, 0, 0, 0.450322,-99)    );
  // itree = 312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.883109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392691,-99) , 
0, 0.682701, 1, 0, 0.600636,-99) , 
3, 1.17431, 0, 0, 0.710249,-99) , 
NN(
0, 
0, 
-1, -0.941861, 0, -1, 0.234646,-99) , 
3, -0.18324, 0, 0, 0.529604,-99)    );
  // itree = 313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42216, 0, 1, 0.760335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489344,-99) , 
3, 0.235551, 0, 0, 0.695519,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.18404,-99) , 
3, -0.202496, 0, 0, 0.49392,-99)    );
  // itree = 314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.250256, 0, 1, 0.74307,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.191858,-99) , 
3, -0.202496, 0, 0, 0.504353,-99)    );
  // itree = 315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.925629, 1, 1, 0.834327,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323176,-99) , 
0, 0.587889, 1, 0, 0.574038,-99) , 
3, 0.829532, 0, 0, 0.694389,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.202525,-99) , 
3, -0.28269, 0, 0, 0.515527,-99)    );
  // itree = 316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.808577,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392457,-99) , 
0, 0.202232, 1, 0, 0.606471,-99) , 
3, 0.801028, 0, 0, 0.729983,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537806,-99) , 
NN(
0, 
0, 
-1, -1.12094, 1, -1, 0.195652,-99) , 
3, -0.106823, 0, 0, 0.254978,-99) , 
3, 0.17816, 0, 0, 0.46289,-99)    );
  // itree = 317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41846, 0, 1, 0.857615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377055,-99) , 
0, 0.465064, 1, 0, 0.565346,-99) , 
3, 1.10293, 0, 0, 0.669559,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.212499,-99) , 
3, -0.207894, 0, 0, 0.482047,-99)    );
  // itree = 318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56776, 1, 1, 0.876204,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3832,-99) , 
0, 0.920728, 1, 0, 0.673984,-99) , 
3, 1.26767, 0, 0, 0.753395,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201199,-99) , 
0, -1.21605, 1, 0, 0.335394,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.119356,-99) , 
3, -1.037, 0, 0, 0.233821,-99) , 
3, 0.0509667, 0, 0, 0.48775,-99)    );
  // itree = 319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.869468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450657,-99) , 
1, 0.463922, 1, 0, 0.594513,-99) , 
3, 1.2097, 0, 0, 0.688666,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.220381,-99) , 
3, -0.376892, 0, 0, 0.531502,-99)    );
  // itree = 320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.10019, 1, 1, 0.81882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40041,-99) , 
0, 0.0468255, 1, 0, 0.584261,-99) , 
3, 0.750295, 0, 0, 0.711613,-99) , 
NN(
0, 
0, 
-1, -0.906435, 0, -1, 0.219587,-99) , 
3, -0.140969, 0, 0, 0.493714,-99)    );
  // itree = 321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.819193, 0, 1, 0.848421,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318162,-99) , 
3, 1.23087, 0, 0, 0.634261,-99) , 
0, 1.15782, 1, 0, 0.737714,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254316,-99) , 
0, -0.806035, 1, 0, 0.361898,-99) , 
NN(
0, 
0, 
-1, -0.552932, 1, -1, 0.112614,-99) , 
3, -1.09308, 0, 0, 0.266515,-99) , 
3, 0.228725, 0, 0, 0.48656,-99)    );
  // itree = 322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.596138, 0, 1, 0.735343,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29665,-99) , 
1, -0.602569, 1, 0, 0.384477,-99) , 
NN(
0, 
0, 
-1, -0.259045, 1, -1, 0.0461854,-99) , 
3, -1.20546, 0, 0, 0.260353,-99) , 
3, 0.17816, 0, 0, 0.480403,-99)    );
  // itree = 323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.878723, 1, 1, 0.837431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329655,-99) , 
0, 0.224393, 1, 0, 0.584489,-99) , 
3, 0.734957, 0, 0, 0.725577,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220136,-99) , 
0, -1.30478, 1, 0, 0.33483,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0951373,-99) , 
3, -1.14447, 0, 0, 0.244718,-99) , 
3, -0.160313, 0, 0, 0.507895,-99)    );
  // itree = 324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17157, 0, 1, 0.899996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448743,-99) , 
3, 1.42058, 0, 0, 0.720927,-99) , 
0, 1.45281, 1, 0, 0.808479,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271507,-99) , 
0, -0.132637, 1, 0, 0.500742,-99) , 
NN(
0, 
0, 
-1, -0.572275, 1, -1, 0.166916,-99) , 
3, -0.566981, 0, 0, 0.320919,-99) , 
3, 0.392653, 0, 0, 0.514238,-99)    );
  // itree = 325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66162, 0, 1, 0.829148,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361292,-99) , 
0, 0.424748, 1, 0, 0.605812,-99) , 
3, 0.98281, 0, 0, 0.703364,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132085,-99) , 
0, -1.21605, 1, 0, 0.282514,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.108059,-99) , 
3, -1.00886, 0, 0, 0.20179,-99) , 
3, -0.123397, 0, 0, 0.483091,-99)    );
  // itree = 326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17835, 1, 1, 0.898589,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880699,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477529,-99) , 
0, 0.834701, 1, 0, 0.691122,-99) , 
3, 1.42244, 0, 0, 0.766542,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26012,-99) , 
0, -0.781662, 1, 0, 0.407278,-99) , 
NN(
0, 
0, 
-1, 0.171487, 1, -1, 0.14282,-99) , 
3, -0.927516, 0, 0, 0.286967,-99) , 
3, 0.17816, 0, 0, 0.5234,-99)    );
  // itree = 327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72724, 0, 1, 0.852273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347155,-99) , 
0, 0.676493, 1, 0, 0.617407,-99) , 
3, 1.10245, 0, 0, 0.718152,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.248985,-99) , 
3, -0.207894, 0, 0, 0.539208,-99)    );
  // itree = 328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.88373, 1, 1, 0.839297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367477,-99) , 
0, 0.782483, 1, 0, 0.642003,-99) , 
3, 1.00821, 0, 0, 0.739918,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646097,-99) , 
NN(
0, 
0, 
-1, -0.31741, 1, -1, 0.253235,-99) , 
3, -0.0622252, 0, 0, 0.314518,-99) , 
3, 0.20809, 0, 0, 0.526009,-99)    );
  // itree = 329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55707, 1, 1, 0.885373,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408791,-99) , 
0, 0.733197, 1, 0, 0.627847,-99) , 
3, 1.20885, 0, 0, 0.721951,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.200751,-99) , 
3, -0.123397, 0, 0, 0.488189,-99)    );
  // itree = 330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06258, 1, 1, 0.76338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494088,-99) , 
3, 0.244337, 0, 0, 0.697507,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152367,-99) , 
0, -1.39929, 1, 0, 0.282333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0376762,-99) , 
3, -1.69856, 0, 0, 0.2284,-99) , 
3, -0.210183, 0, 0, 0.504133,-99)    );
  // itree = 331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.871177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348515,-99) , 
0, 1.27921, 1, 0, 0.644538,-99) , 
3, 1.28284, 0, 0, 0.731368,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307761,-99) , 
0, -1.43519, 1, 0, 0.387203,-99) , 
NN(
0, 
0, 
-1, -1.7106, 0, -1, 0.109585,-99) , 
3, -1.09042, 0, 0, 0.285588,-99) , 
3, 0.262941, 0, 0, 0.494212,-99)    );
  // itree = 332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.853578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271628,-99) , 
0, 0.738333, 1, 0, 0.581733,-99) , 
3, 1.07643, 0, 0, 0.682798,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.20469,-99) , 
3, -0.304384, 0, 0, 0.521673,-99)    );
  // itree = 333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.988815, 1, 1, 0.852525,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873699,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448698,-99) , 
0, 0.474483, 1, 0, 0.631645,-99) , 
3, 0.909925, 0, 0, 0.768684,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30163,-99) , 
0, -0.649803, 1, 0, 0.420325,-99) , 
NN(
0, 
0, 
-1, -0.259045, 1, -1, 0.146771,-99) , 
3, -0.495085, 0, 0, 0.254946,-99) , 
3, 0.307824, 0, 0, 0.463404,-99)    );
  // itree = 334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19067, 1, 1, 0.854918,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478591,-99) , 
0, 0.163351, 1, 0, 0.62996,-99) , 
3, 1.20395, 0, 0, 0.713936,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.200686,-99) , 
3, -0.123397, 0, 0, 0.502748,-99)    );
  // itree = 335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.57878, 1, 1, 0.848663,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358728,-99) , 
0, 0.708301, 1, 0, 0.609659,-99) , 
3, 0.99222, 0, 0, 0.693087,-99) , 
NN(
0, 
0, 
-1, -1.37635, 0, -1, 0.20684,-99) , 
3, -0.376892, 0, 0, 0.51309,-99)    );
  // itree = 336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.796075,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364365,-99) , 
0, -0.101718, 1, 0, 0.582814,-99) , 
3, 0.761669, 0, 0, 0.705962,-99) , 
NN(
0, 
0, 
-1, -1.0136, 0, -1, 0.245131,-99) , 
3, -0.123397, 0, 0, 0.521119,-99)    );
  // itree = 337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.784128,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357746,-99) , 
0, -0.14342, 1, 0, 0.505075,-99) , 
3, 0.540529, 0, 0, 0.681193,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160249,-99) , 
0, -1.21605, 1, 0, 0.331355,-99) , 
NN(
0, 
0, 
-1, 0.00332265, 1, -1, 0.11493,-99) , 
3, -1.00886, 0, 0, 0.226565,-99) , 
3, -0.123397, 0, 0, 0.488995,-99)    );
  // itree = 338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.789956,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276791,-99) , 
0, 0.226562, 1, 0, 0.508527,-99) , 
3, 0.641484, 0, 0, 0.691903,-99) , 
NN(
0, 
0, 
-1, -0.5207, 0, -1, 0.24466,-99) , 
3, 0.0354976, 0, 0, 0.484115,-99)    );
  // itree = 339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54195, 1, 1, 0.845538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363704,-99) , 
0, 0.82791, 1, 0, 0.638888,-99) , 
3, 1.12392, 0, 0, 0.730642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26429,-99) , 
0, -0.985532, 1, 0, 0.417325,-99) , 
NN(
0, 
0, 
-1, -1.66047, 0, -1, 0.149402,-99) , 
3, -0.725985, 0, 0, 0.278352,-99) , 
3, 0.0990605, 0, 0, 0.497435,-99)    );
  // itree = 340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.809583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396535,-99) , 
0, -0.431695, 1, 0, 0.544105,-99) , 
3, 0.255967, 0, 0, 0.730322,-99) , 
NN(
0, 
0, 
-1, -1.17803, 0, -1, 0.171288,-99) , 
3, -0.420978, 0, 0, 0.543341,-99)    );
  // itree = 341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24789, 0, 1, 0.783669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314555,-99) , 
0, -0.312245, 1, 0, 0.512555,-99) , 
3, 0.264294, 0, 0, 0.683307,-99) , 
NN(
0, 
0, 
-1, -2.0971, 1, -1, 0.145869,-99) , 
3, -0.711955, 0, 0, 0.542793,-99)    );
  // itree = 342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.8182,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459039,-99) , 
0, -0.0814742, 1, 0, 0.570797,-99) , 
3, 0.824069, 0, 0, 0.688585,-99) , 
NN(
0, 
0, 
-1, -1.02307, 0, -1, 0.217329,-99) , 
3, -0.287638, 0, 0, 0.51122,-99)    );
  // itree = 343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48336, 1, 1, 0.836354,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449172,-99) , 
1, -0.654311, 1, 0, 0.544942,-99) , 
3, 0.740359, 0, 0, 0.676448,-99) , 
NN(
0, 
0, 
-1, -1.53084, 0, -1, 0.170707,-99) , 
3, -0.716903, 0, 0, 0.559204,-99)    );
  // itree = 344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.875853,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481807,-99) , 
0, 0.781704, 1, 0, 0.709447,-99) , 
3, 1.32896, 0, 0, 0.773975,-99) , 
NN(
0, 
0, 
-1, -0.395788, 0, -1, 0.255008,-99) , 
3, 0.135748, 0, 0, 0.522342,-99)    );
  // itree = 345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.672338, 1, 1, 0.806329,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533243,-99) , 
NN(
0, 
0, 
-1, -1.53362, 0, -1, 0.248297,-99) , 
3, 0.0125853, 0, 0, 0.301074,-99) , 
3, 0.28719, 0, 0, 0.523164,-99)    );
  // itree = 346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11386, 0, 1, 0.791708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.175398,-99) , 
0, 0.193081, 1, 0, 0.455404,-99) , 
3, 0.540529, 0, 0, 0.65185,-99) , 
NN(
0, 
0, 
-1, -0.422153, 0, -1, 0.222093,-99) , 
3, -0.123397, 0, 0, 0.460865,-99)    );
  // itree = 347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.851743,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411738,-99) , 
0, 0.56721, 1, 0, 0.585114,-99) , 
3, 1.33028, 0, 0, 0.65607,-99) , 
NN(
0, 
0, 
-1, -0.787163, 0, -1, 0.233955,-99) , 
3, -0.202496, 0, 0, 0.478215,-99)    );
  // itree = 348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73419, 0, 1, 0.817661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316244,-99) , 
0, 0.43111, 1, 0, 0.506606,-99) , 
3, 0.929263, 0, 0, 0.61663,-99) , 
NN(
0, 
0, 
-1, -2.0971, 1, -1, 0.105446,-99) , 
3, -0.756041, 0, 0, 0.472332,-99)    );
  // itree = 349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.923783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423714,-99) , 
3, 0.824059, 0, 0, 0.711392,-99) , 
0, 0.311772, 1, 0, 0.755384,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279927,-99) , 
0, -1.39151, 1, 0, 0.364339,-99) , 
NN(
0, 
0, 
-1, -2.86122, 1, -1, 0.109243,-99) , 
3, -1.12144, 0, 0, 0.282738,-99) , 
3, 0.202693, 0, 0, 0.51358,-99)    );
  // itree = 350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0321906, 1, 1, 0.912488,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493349,-99) , 
3, 1.08238, 0, 0, 0.761553,-99) , 
0, 0.702317, 1, 0, 0.805546,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234855,-99) , 
1, -0.31541, 1, 0, 0.37057,-99) , 
NN(
0, 
0, 
-1, 0.233864, 1, -1, 0.146269,-99) , 
3, -0.644871, 0, 0, 0.256606,-99) , 
3, 0.301115, 0, 0, 0.488759,-99)    );
  // itree = 351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8559, 1, 1, 0.890499,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434116,-99) , 
0, 1.00308, 1, 0, 0.731528,-99) , 
3, 1.31116, 0, 0, 0.798925,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372861,-99) , 
0, -1.21855, 1, 0, 0.439127,-99) , 
NN(
0, 
0, 
-1, -2.21779, 1, -1, 0.114025,-99) , 
3, -1.03006, 0, 0, 0.303127,-99) , 
3, 0.307824, 0, 0, 0.524547,-99)    );
  // itree = 352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.87215, 1, 1, 0.887732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444374,-99) , 
0, 0.488413, 1, 0, 0.658844,-99) , 
3, 1.08443, 0, 0, 0.77829,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250675,-99) , 
0, -0.301216, 1, 0, 0.458001,-99) , 
NN(
0, 
0, 
-1, -1.20224, 0, -1, 0.188499,-99) , 
3, -0.326848, 0, 0, 0.281844,-99) , 
3, 0.306962, 0, 0, 0.507174,-99)    );
  // itree = 353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.806652,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369375,-99) , 
0, -0.927345, 1, 0, 0.453756,-99) , 
NN(
0, 
0, 
-1, -1.2708, 0, -1, 0.173094,-99) , 
3, -0.537445, 0, 0, 0.324337,-99) , 
3, 0.660704, 0, 0, 0.481587,-99)    );
  // itree = 354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.48777, 0, 1, 0.802986,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339306,-99) , 
0, -0.765399, 1, 0, 0.482169,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.13004,-99) , 
3, -0.55622, 0, 0, 0.282565,-99) , 
3, 0.262941, 0, 0, 0.516207,-99)    );
  // itree = 355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39379, 1, 1, 0.845245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246514,-99) , 
0, 0.809818, 1, 0, 0.597026,-99) , 
3, 0.972105, 0, 0, 0.711577,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225614,-99) , 
0, -1.36233, 1, 0, 0.345148,-99) , 
NN(
0, 
0, 
-1, -2.5847, 1, -1, 0.0780796,-99) , 
3, -1.15655, 0, 0, 0.233198,-99) , 
3, -0.160313, 0, 0, 0.50736,-99)    );
  // itree = 356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.842845,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361811,-99) , 
0, 1.10293, 1, 0, 0.640234,-99) , 
3, 1.21918, 0, 0, 0.728395,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369067,-99) , 
3, -0.056089, 0, 0, 0.456325,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.169238,-99) , 
3, -0.376357, 0, 0, 0.263591,-99) , 
3, 0.17816, 0, 0, 0.482755,-99)    );
  // itree = 357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63669, 1, 1, 0.879542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395428,-99) , 
0, 0.9386, 1, 0, 0.650802,-99) , 
3, 1.41447, 0, 0, 0.733009,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312876,-99) , 
0, -0.878275, 1, 0, 0.408745,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0818671,-99) , 
3, -0.997806, 0, 0, 0.257638,-99) , 
3, 0.254861, 0, 0, 0.476314,-99)    );
  // itree = 358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.855059,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355881,-99) , 
0, 1.0116, 1, 0, 0.626701,-99) , 
3, 1.33028, 0, 0, 0.688675,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.21628,-99) , 
3, -0.202496, 0, 0, 0.486592,-99)    );
  // itree = 359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.822279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334612,-99) , 
0, 0.13874, 1, 0, 0.583526,-99) , 
3, 0.540529, 0, 0, 0.73159,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243634,-99) , 
0, -1.17488, 1, 0, 0.37736,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.13185,-99) , 
3, -1.00886, 0, 0, 0.253861,-99) , 
3, -0.123397, 0, 0, 0.546329,-99)    );
  // itree = 360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.846531,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388724,-99) , 
0, 0.639693, 1, 0, 0.629322,-99) , 
3, 0.982657, 0, 0, 0.748858,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159077,-99) , 
0, -0.153185, 1, 0, 0.428738,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.22847,-99) , 
3, -0.566981, 0, 0, 0.326225,-99) , 
3, 0.392653, 0, 0, 0.513976,-99)    );
  // itree = 361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75779, 0, 1, 0.835361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268195,-99) , 
0, 1.02331, 1, 0, 0.652958,-99) , 
3, 1.12846, 0, 0, 0.731194,-99) , 
NN(
0, 
0, 
-1, -0.466111, 0, -1, 0.256322,-99) , 
3, 0.0990605, 0, 0, 0.496109,-99)    );
  // itree = 362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.884664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330106,-99) , 
0, 1.47069, 1, 0, 0.680049,-99) , 
3, 1.3949, 0, 0, 0.759563,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297697,-99) , 
1, -0.384038, 1, 0, 0.382849,-99) , 
NN(
0, 
0, 
-1, -1.24622, 0, -1, 0.155971,-99) , 
3, -0.702968, 0, 0, 0.275624,-99) , 
3, 0.238103, 0, 0, 0.503552,-99)    );
  // itree = 363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72947, 1, 1, 0.864395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225852,-99) , 
0, 0.852865, 1, 0, 0.592526,-99) , 
3, 1.07833, 0, 0, 0.720199,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241664,-99) , 
3, -0.548378, 0, 0, 0.433722,-99) , 
NN(
0, 
0, 
-1, -1.05581, 0, -1, 0.188975,-99) , 
1, -0.300802, 1, 0, 0.287662,-99) , 
3, 0.262941, 0, 0, 0.503773,-99)    );
  // itree = 364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62927, 0, 1, 0.866427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43563,-99) , 
0, 0.451967, 1, 0, 0.619446,-99) , 
3, 0.982331, 0, 0, 0.74895,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363277,-99) , 
0, -0.661533, 1, 0, 0.470771,-99) , 
NN(
0, 
0, 
-1, -1.09646, 0, -1, 0.168849,-99) , 
3, -0.36326, 0, 0, 0.269634,-99) , 
3, 0.178444, 0, 0, 0.509884,-99)    );
  // itree = 365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.78433, 0, 1, 0.904596,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428468,-99) , 
3, 0.961548, 0, 0, 0.732877,-99) , 
0, 0.702317, 1, 0, 0.785384,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286937,-99) , 
0, -0.54089, 1, 0, 0.428422,-99) , 
NN(
0, 
0, 
-1, -1.03116, 0, -1, 0.14622,-99) , 
3, -0.553771, 0, 0, 0.275285,-99) , 
3, 0.262941, 0, 0, 0.502318,-99)    );
  // itree = 366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.87385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409677,-99) , 
0, 1.01899, 1, 0, 0.705835,-99) , 
3, 1.28127, 0, 0, 0.781468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565418,-99) , 
NN(
0, 
0, 
-1, -1.21931, 0, -1, 0.22786,-99) , 
3, -0.0116291, 0, 0, 0.28447,-99) , 
3, 0.306962, 0, 0, 0.504445,-99)    );
  // itree = 367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.88594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44021,-99) , 
0, 0.923572, 1, 0, 0.67537,-99) , 
3, 1.43473, 0, 0, 0.744678,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247782,-99) , 
0, -1.21855, 1, 0, 0.361102,-99) , 
NN(
0, 
0, 
-1, -0.0154624, 1, -1, 0.081185,-99) , 
3, -1.05817, 0, 0, 0.233191,-99) , 
3, 0.017859, 0, 0, 0.504186,-99)    );
  // itree = 368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.837072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41906,-99) , 
0, 0.569025, 1, 0, 0.59628,-99) , 
3, 1.0083, 0, 0, 0.718888,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242657,-99) , 
0, -0.336763, 1, 0, 0.457392,-99) , 
NN(
0, 
0, 
-1, -1.24172, 0, -1, 0.153815,-99) , 
3, -0.705976, 0, 0, 0.302197,-99) , 
3, 0.238103, 0, 0, 0.485444,-99)    );
  // itree = 369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90389, 1, 1, 0.871538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394219,-99) , 
0, 1.32273, 1, 0, 0.688956,-99) , 
3, 1.38599, 0, 0, 0.760363,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.233768,-99) , 
3, 0.183842, 0, 0, 0.480237,-99)    );
  // itree = 370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.502524, 1, 1, 0.929908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342215,-99) , 
3, 1.06182, 0, 0, 0.66195,-99) , 
0, 0.709428, 1, 0, 0.735713,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238497,-99) , 
0, -0.642486, 1, 0, 0.430542,-99) , 
NN(
0, 
0, 
-1, -1.65122, 1, -1, 0.13912,-99) , 
3, -0.702968, 0, 0, 0.274568,-99) , 
3, 0.234307, 0, 0, 0.48207,-99)    );
  // itree = 371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.107402, 1, 1, 0.807843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250224,-99) , 
0, 0.205075, 1, 0, 0.508954,-99) , 
3, 0.596878, 0, 0, 0.661337,-99) , 
NN(
0, 
0, 
-1, -1.1819, 0, -1, 0.153391,-99) , 
3, -0.639447, 0, 0, 0.516489,-99)    );
  // itree = 372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.23356, 1, 1, 0.885488,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343892,-99) , 
0, 0.848875, 1, 0, 0.563906,-99) , 
3, 1.43185, 0, 0, 0.652411,-99) , 
NN(
0, 
0, 
-1, -1.1339, 0, -1, 0.205618,-99) , 
3, -0.38184, 0, 0, 0.4963,-99)    );
  // itree = 373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.859415,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278402,-99) , 
0, 0.738333, 1, 0, 0.58227,-99) , 
3, 1.07098, 0, 0, 0.695554,-99) , 
NN(
0, 
0, 
-1, -0.985546, 0, -1, 0.217765,-99) , 
3, -0.255748, 0, 0, 0.501491,-99)    );
  // itree = 374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58467, 0, 1, 0.846693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278949,-99) , 
0, 0.887495, 1, 0, 0.580378,-99) , 
3, 1.10245, 0, 0, 0.689737,-99) , 
NN(
0, 
0, 
-1, -0.507749, 0, -1, 0.150282,-99) , 
3, -0.207894, 0, 0, 0.455394,-99)    );
  // itree = 375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.382781, 1, 1, 0.904354,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412212,-99) , 
3, 1.12425, 0, 0, 0.718329,-99) , 
0, 0.768458, 1, 0, 0.777568,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251991,-99) , 
0, -0.616482, 1, 0, 0.393666,-99) , 
NN(
0, 
0, 
-1, -0.942414, 0, -1, 0.143586,-99) , 
3, -0.372136, 0, 0, 0.227047,-99) , 
3, 0.254861, 0, 0, 0.455375,-99)    );
  // itree = 376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.797238,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306191,-99) , 
0, -0.164113, 1, 0, 0.550231,-99) , 
3, 0.525662, 0, 0, 0.697692,-99) , 
NN(
0, 
0, 
-1, -1.13161, 0, -1, 0.159039,-99) , 
3, -0.38184, 0, 0, 0.502213,-99)    );
  // itree = 377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19763, 0, 1, 0.771483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48317,-99) , 
3, 0.157865, 0, 0, 0.705139,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.184892,-99) , 
3, -0.304384, 0, 0, 0.498912,-99)    );
  // itree = 378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32054, 0, 1, 0.841576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377878,-99) , 
0, 0.459356, 1, 0, 0.56252,-99) , 
3, 0.98281, 0, 0, 0.674318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188037,-99) , 
0, -1.05379, 1, 0, 0.332501,-99) , 
NN(
0, 
0, 
-1, -1.78935, 0, -1, 0.109867,-99) , 
3, -1.00886, 0, 0, 0.222054,-99) , 
3, -0.123397, 0, 0, 0.494047,-99)    );
  // itree = 379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.382781, 1, 1, 0.902508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430526,-99) , 
3, 1.21388, 0, 0, 0.68356,-99) , 
0, 0.696722, 1, 0, 0.750851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536278,-99) , 
NN(
0, 
0, 
-1, -1.57713, 0, -1, 0.20413,-99) , 
3, -0.0623126, 0, 0, 0.256492,-99) , 
3, 0.20809, 0, 0, 0.477885,-99)    );
  // itree = 380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50679, 0, 1, 0.844557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300447,-99) , 
0, 0.573049, 1, 0, 0.570144,-99) , 
3, 0.994438, 0, 0, 0.691264,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.192979,-99) , 
3, -0.123397, 0, 0, 0.485555,-99)    );
  // itree = 381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.857428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23522,-99) , 
0, 1.0116, 1, 0, 0.579477,-99) , 
3, 1.13334, 0, 0, 0.689668,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.214242,-99) , 
3, -0.202496, 0, 0, 0.496923,-99)    );
  // itree = 382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0194754, 1, 1, 0.755552,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356134,-99) , 
0, -0.701064, 1, 0, 0.47399,-99) , 
NN(
0, 
0, 
-1, -0.942414, 0, -1, 0.176765,-99) , 
3, -0.372166, 0, 0, 0.278594,-99) , 
3, 0.254861, 0, 0, 0.494657,-99)    );
  // itree = 383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.79139, 0, 1, 0.876537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342126,-99) , 
0, 0.911613, 1, 0, 0.62692,-99) , 
3, 1.2161, 0, 0, 0.728695,-99) , 
NN(
0, 
0, 
-1, -0.528204, 0, -1, 0.247144,-99) , 
3, 0.00760208, 0, 0, 0.502926,-99)    );
  // itree = 384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.863441,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294528,-99) , 
0, 1.22611, 1, 0, 0.562818,-99) , 
3, 1.27052, 0, 0, 0.656442,-99) , 
NN(
0, 
0, 
-1, -0.787642, 0, -1, 0.217909,-99) , 
3, -0.287638, 0, 0, 0.481228,-99)    );
  // itree = 385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68265, 0, 1, 0.807081,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28202,-99) , 
0, 0.0787312, 1, 0, 0.5272,-99) , 
3, 0.540529, 0, 0, 0.704538,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208381,-99) , 
0, -1.21605, 1, 0, 0.336945,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.129412,-99) , 
3, -1.0136, 0, 0, 0.249944,-99) , 
3, -0.123397, 0, 0, 0.514673,-99)    );
  // itree = 386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.848068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337033,-99) , 
0, 0.454384, 1, 0, 0.586056,-99) , 
3, 0.843146, 0, 0, 0.726922,-99) , 
NN(
0, 
0, 
-1, -1.05809, 0, -1, 0.251653,-99) , 
3, 0.0354976, 0, 0, 0.49728,-99)    );
  // itree = 387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.889808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486152,-99) , 
0, 0.912588, 1, 0, 0.703066,-99) , 
3, 1.41307, 0, 0, 0.772048,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332469,-99) , 
0, -0.742411, 1, 0, 0.490465,-99) , 
NN(
0, 
0, 
-1, -1.70231, 0, -1, 0.173839,-99) , 
3, -0.574923, 0, 0, 0.305182,-99) , 
3, 0.223327, 0, 0, 0.513618,-99)    );
  // itree = 388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.98281, 0, 1, 0.737602,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187375,-99) , 
0, -1.31319, 1, 0, 0.335332,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0985216,-99) , 
3, -1.00946, 0, 0, 0.212791,-99) , 
3, -0.123397, 0, 0, 0.52688,-99)    );
  // itree = 389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51407, 1, 1, 0.847364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287911,-99) , 
0, 0.931718, 1, 0, 0.573023,-99) , 
3, 1.20464, 0, 0, 0.672972,-99) , 
NN(
0, 
0, 
-1, -1.13161, 0, -1, 0.192841,-99) , 
3, -0.38184, 0, 0, 0.512424,-99)    );
  // itree = 390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31096, 0, 1, 0.836975,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397385,-99) , 
0, 0.446311, 1, 0, 0.632478,-99) , 
3, 0.971511, 0, 0, 0.729416,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198962,-99) , 
0, -1.37863, 1, 0, 0.309119,-99) , 
NN(
0, 
0, 
-1, -2.94254, 1, -1, 0.0762734,-99) , 
3, -1.12925, 0, 0, 0.205593,-99) , 
3, -0.140969, 0, 0, 0.510147,-99)    );
  // itree = 391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.85842,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478717,-99) , 
1, -0.679665, 1, 0, 0.552101,-99) , 
3, 1.20464, 0, 0, 0.646724,-99) , 
NN(
0, 
0, 
-1, -1.62848, 0, -1, 0.171187,-99) , 
3, -0.38184, 0, 0, 0.502673,-99)    );
  // itree = 392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0200223, 1, 1, 0.843529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266283,-99) , 
0, 0.897575, 1, 0, 0.588731,-99) , 
3, 1.08672, 0, 0, 0.671014,-99) , 
NN(
0, 
0, 
-1, -1.45163, 0, -1, 0.160824,-99) , 
3, -0.639447, 0, 0, 0.528267,-99)    );
  // itree = 393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30438, 0, 1, 0.837571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270548,-99) , 
0, 0.224393, 1, 0, 0.54932,-99) , 
3, 0.764338, 0, 0, 0.697605,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.235194,-99) , 
3, -0.123397, 0, 0, 0.488049,-99)    );
  // itree = 394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.832554,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269011,-99) , 
0, 0.0136911, 1, 0, 0.442647,-99) , 
NN(
0, 
0, 
-1, -1.02102, 0, -1, 0.165694,-99) , 
3, -0.537409, 0, 0, 0.319895,-99) , 
3, 0.660704, 0, 0, 0.4983,-99)    );
  // itree = 395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81803, 1, 1, 0.890875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434405,-99) , 
0, 0.782483, 1, 0, 0.657084,-99) , 
3, 1.21404, 0, 0, 0.761435,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408288,-99) , 
0, -0.765399, 1, 0, 0.506167,-99) , 
NN(
0, 
0, 
-1, -1.63146, 0, -1, 0.188984,-99) , 
3, -0.651936, 0, 0, 0.332748,-99) , 
3, 0.17816, 0, 0, 0.550778,-99)    );
  // itree = 396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21129, 1, 1, 0.831268,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331585,-99) , 
0, 0.609608, 1, 0, 0.571559,-99) , 
3, 0.982657, 0, 0, 0.72861,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333853,-99) , 
0, -0.833115, 1, 0, 0.443102,-99) , 
NN(
0, 
0, 
-1, -1.12403, 0, -1, 0.167897,-99) , 
3, -0.566981, 0, 0, 0.30833,-99) , 
3, 0.392653, 0, 0, 0.492479,-99)    );
  // itree = 397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42623, 1, 1, 0.783211,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385362,-99) , 
0, -0.135613, 1, 0, 0.558133,-99) , 
3, 0.540529, 0, 0, 0.713012,-99) , 
NN(
0, 
0, 
-1, -1.59854, 0, -1, 0.220851,-99) , 
3, -0.123397, 0, 0, 0.495111,-99)    );
  // itree = 398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.487576, 0, 1, 0.921241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410905,-99) , 
3, 0.805619, 0, 0, 0.681412,-99) , 
0, 0.2821, 1, 0, 0.733614,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59747,-99) , 
NN(
0, 
0, 
-1, -1.16584, 0, -1, 0.200878,-99) , 
3, -0.100777, 0, 0, 0.265906,-99) , 
3, 0.17816, 0, 0, 0.494236,-99)    );
  // itree = 399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.70427, 1, 1, 0.828725,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355827,-99) , 
0, 0.424748, 1, 0, 0.601198,-99) , 
3, 0.98804, 0, 0, 0.702311,-99) , 
NN(
0, 
0, 
-1, -1.59854, 0, -1, 0.209953,-99) , 
3, -0.123397, 0, 0, 0.500688,-99)    );
  // itree = 400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.16263, 1, 1, 0.859794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334167,-99) , 
0, 0.683966, 1, 0, 0.615133,-99) , 
3, 0.982711, 0, 0, 0.763853,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217158,-99) , 
0, -0.0856679, 1, 0, 0.459132,-99) , 
NN(
0, 
0, 
-1, -1.12173, 0, -1, 0.149993,-99) , 
3, -0.568255, 0, 0, 0.300035,-99) , 
3, 0.392653, 0, 0, 0.494905,-99)    );
  // itree = 401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.15223, 1, 1, 0.907288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3731,-99) , 
0, 1.04788, 1, 0, 0.629818,-99) , 
3, 1.42509, 0, 0, 0.714466,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.197088,-99) , 
3, -0.123397, 0, 0, 0.486341,-99)    );
  // itree = 402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.459874, 1, 1, 0.910872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406492,-99) , 
3, 1.21163, 0, 0, 0.681742,-99) , 
0, 0.792115, 1, 0, 0.765481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3107,-99) , 
0, -0.62859, 1, 0, 0.418317,-99) , 
NN(
0, 
0, 
-1, -1.50177, 0, -1, 0.16305,-99) , 
3, -0.591799, 0, 0, 0.267236,-99) , 
3, 0.202693, 0, 0, 0.500258,-99)    );
  // itree = 403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54771, 0, 1, 0.823522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264747,-99) , 
0, 0.259657, 1, 0, 0.534295,-99) , 
3, 0.615993, 0, 0, 0.692645,-99) , 
NN(
0, 
0, 
-1, -0.815455, 0, -1, 0.220366,-99) , 
3, -0.304384, 0, 0, 0.531906,-99)    );
  // itree = 404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.322371, 0, 1, 0.729772,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.169272,-99) , 
3, -0.123397, 0, 0, 0.472077,-99)    );
  // itree = 405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.761347, 1, 1, 0.77851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276886,-99) , 
0, 0.134912, 1, 0, 0.525495,-99) , 
3, 0.538437, 0, 0, 0.665749,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.149323,-99) , 
3, -0.376892, 0, 0, 0.477686,-99)    );
  // itree = 406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.862066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446056,-99) , 
0, 0.586354, 1, 0, 0.622106,-99) , 
3, 1.21586, 0, 0, 0.720879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564286,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.197595,-99) , 
3, -0.100777, 0, 0, 0.269144,-99) , 
3, 0.17816, 0, 0, 0.505089,-99)    );
  // itree = 407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17916, 0, 1, 0.75718,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312808,-99) , 
0, -1.19434, 1, 0, 0.39009,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.0974127,-99) , 
3, -0.889835, 0, 0, 0.27055,-99) , 
3, 0.178444, 0, 0, 0.503251,-99)    );
  // itree = 408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.584955, 0, 1, 0.748592,-99) , 
NN(
0, 
0, 
-1, -0.35011, 0, -1, 0.261371,-99) , 
3, 0.183842, 0, 0, 0.486723,-99)    );
  // itree = 409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.374491, 1, 1, 0.809467,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154438,-99) , 
0, -0.153185, 1, 0, 0.432009,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.124631,-99) , 
3, -0.887574, 0, 0, 0.29992,-99) , 
3, 0.392653, 0, 0, 0.517748,-99)    );
  // itree = 410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04198, 1, 1, 0.781057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412642,-99) , 
1, -0.591117, 1, 0, 0.513349,-99) , 
3, 0.52978, 0, 0, 0.665201,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.202596,-99) , 
3, -0.376892, 0, 0, 0.505724,-99)    );
  // itree = 411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5813, 1, 1, 0.917735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488521,-99) , 
0, 1.13402, 1, 0, 0.687024,-99) , 
3, 1.58622, 0, 0, 0.749359,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292557,-99) , 
0, -0.988002, 1, 0, 0.406851,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.132144,-99) , 
3, -1.022, 0, 0, 0.301726,-99) , 
3, 0.234307, 0, 0, 0.516764,-99)    );
  // itree = 412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47282, 1, 1, 0.864165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254641,-99) , 
0, 1.0581, 1, 0, 0.64186,-99) , 
3, 1.21122, 0, 0, 0.734479,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242867,-99) , 
0, -0.43878, 1, 0, 0.487317,-99) , 
NN(
0, 
0, 
-1, -1.80475, 1, -1, 0.14413,-99) , 
3, -0.587974, 0, 0, 0.278268,-99) , 
3, 0.20809, 0, 0, 0.484721,-99)    );
  // itree = 413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62642, 0, 1, 0.838666,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730433,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431748,-99) , 
0, 0.15284, 1, 0, 0.588048,-99) , 
3, 0.979337, 0, 0, 0.687564,-99) , 
NN(
0, 
0, 
-1, -1.13931, 0, -1, 0.152148,-99) , 
3, -0.38184, 0, 0, 0.505327,-99)    );
  // itree = 414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.877429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419609,-99) , 
0, 0.819377, 1, 0, 0.682642,-99) , 
3, 1.07981, 0, 0, 0.791982,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270455,-99) , 
0, -0.991976, 1, 0, 0.391974,-99) , 
NN(
0, 
0, 
-1, -2.93551, 1, -1, 0.10219,-99) , 
3, -0.959934, 0, 0, 0.275,-99) , 
3, 0.301115, 0, 0, 0.500804,-99)    );
  // itree = 415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.250389, 0, 1, 0.872062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406435,-99) , 
3, 1.08665, 0, 0, 0.691211,-99) , 
0, 0.570481, 1, 0, 0.753027,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.259772,-99) , 
3, -0.123397, 0, 0, 0.544769,-99)    );
  // itree = 416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.785265,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322563,-99) , 
0, 0.12976, 1, 0, 0.508182,-99) , 
3, 0.755082, 0, 0, 0.659933,-99) , 
NN(
0, 
0, 
-1, -1.12925, 0, -1, 0.206917,-99) , 
3, -0.140969, 0, 0, 0.460228,-99)    );
  // itree = 417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.898308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470268,-99) , 
0, 0.51501, 1, 0, 0.626332,-99) , 
3, 1.46997, 0, 0, 0.699823,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313922,-99) , 
0, -1.20938, 1, 0, 0.419011,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.145359,-99) , 
3, -1.03104, 0, 0, 0.286739,-99) , 
3, 0.0509667, 0, 0, 0.512464,-99)    );
  // itree = 418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.656502, 0, 1, 0.919792,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349543,-99) , 
3, 1.17721, 0, 0, 0.677566,-99) , 
0, 1.10708, 1, 0, 0.774547,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314772,-99) , 
0, -0.616482, 1, 0, 0.482481,-99) , 
NN(
0, 
0, 
-1, -1.19115, 0, -1, 0.171663,-99) , 
3, -0.325669, 0, 0, 0.284006,-99) , 
3, 0.306962, 0, 0, 0.506469,-99)    );
  // itree = 419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.778492, 1, 1, 0.781434,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274268,-99) , 
0, -0.833115, 1, 0, 0.412648,-99) , 
NN(
0, 
0, 
-1, -0.958653, 0, -1, 0.124063,-99) , 
3, -0.495085, 0, 0, 0.253584,-99) , 
3, 0.307824, 0, 0, 0.471611,-99)    );
  // itree = 420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.88616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422899,-99) , 
0, 0.893448, 1, 0, 0.678155,-99) , 
3, 1.31116, 0, 0, 0.768825,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248343,-99) , 
1, 0.418887, 1, 0, 0.440553,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.167013,-99) , 
3, -1.03006, 0, 0, 0.351886,-99) , 
3, 0.307824, 0, 0, 0.537943,-99)    );
  // itree = 421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89693, 0, 1, 0.86861,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36108,-99) , 
0, 0.539544, 1, 0, 0.615506,-99) , 
3, 1.07643, 0, 0, 0.711289,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.210011,-99) , 
3, -0.304384, 0, 0, 0.521052,-99)    );
  // itree = 422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.845604,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294131,-99) , 
0, 0.852865, 1, 0, 0.606926,-99) , 
3, 1.00508, 0, 0, 0.730922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602547,-99) , 
NN(
0, 
0, 
-1, -0.980354, 0, -1, 0.234343,-99) , 
3, -0.086826, 0, 0, 0.298283,-99) , 
3, 0.234307, 0, 0, 0.495204,-99)    );
  // itree = 423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96169, 1, 1, 0.853311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398747,-99) , 
0, 0.753813, 1, 0, 0.625322,-99) , 
3, 1.08361, 0, 0, 0.738691,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330372,-99) , 
0, -1.00782, 1, 0, 0.420164,-99) , 
NN(
0, 
0, 
-1, -1.73375, 0, -1, 0.107652,-99) , 
3, -0.95623, 0, 0, 0.304203,-99) , 
3, 0.306962, 0, 0, 0.49685,-99)    );
  // itree = 424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.817296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405552,-99) , 
0, -0.799767, 1, 0, 0.521989,-99) , 
3, 0.52978, 0, 0, 0.696465,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.125806,-99) , 
0, -1.57389, 1, 0, 0.258147,-99) , 
NN(
0, 
0, 
-1, -0.236536, 1, -1, 0.0850581,-99) , 
3, -1.37519, 0, 0, 0.197419,-99) , 
3, -0.376892, 0, 0, 0.513692,-99)    );
  // itree = 425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.853733,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383092,-99) , 
0, 0.957246, 1, 0, 0.64758,-99) , 
3, 1.19391, 0, 0, 0.725045,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.135152,-99) , 
0, -1.20764, 1, 0, 0.278053,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.104468,-99) , 
3, -1.14447, 0, 0, 0.206359,-99) , 
3, -0.160313, 0, 0, 0.499926,-99)    );
  // itree = 426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.595975, 0, 1, 0.735776,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313961,-99) , 
0, -1.21855, 1, 0, 0.386335,-99) , 
NN(
0, 
0, 
-1, -0.236536, 1, -1, 0.0833955,-99) , 
3, -1.03546, 0, 0, 0.279018,-99) , 
3, 0.207882, 0, 0, 0.497762,-99)    );
  // itree = 427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.786588, 0, 1, 0.888714,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41944,-99) , 
3, 1.42058, 0, 0, 0.716769,-99) , 
0, 1.48367, 1, 0, 0.812106,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275018,-99) , 
0, -0.830269, 1, 0, 0.406984,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.103503,-99) , 
3, -0.927516, 0, 0, 0.267122,-99) , 
3, 0.17816, 0, 0, 0.529157,-99)    );
  // itree = 428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.925629, 1, 1, 0.815452,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342483,-99) , 
0, 0.465064, 1, 0, 0.56141,-99) , 
3, 0.829532, 0, 0, 0.688343,-99) , 
NN(
0, 
0, 
-1, -1.03076, 0, -1, 0.200522,-99) , 
3, -0.28269, 0, 0, 0.504777,-99)    );
  // itree = 429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.46099, 1, 1, 0.868159,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48515,-99) , 
0, 0.544585, 1, 0, 0.634233,-99) , 
3, 1.42509, 0, 0, 0.704157,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.205879,-99) , 
3, -0.123397, 0, 0, 0.475556,-99)    );
  // itree = 430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.884609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376455,-99) , 
0, 0.84413, 1, 0, 0.638146,-99) , 
3, 1.18459, 0, 0, 0.750822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252554,-99) , 
0, -0.830649, 1, 0, 0.383472,-99) , 
NN(
0, 
0, 
-1, -2.65144, 1, -1, 0.130964,-99) , 
3, -1.15599, 0, 0, 0.293573,-99) , 
3, 0.183842, 0, 0, 0.523562,-99)    );
  // itree = 431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42098, 1, 1, 0.803141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433419,-99) , 
0, 0.442526, 1, 0, 0.628243,-99) , 
3, 0.803993, 0, 0, 0.735089,-99) , 
NN(
0, 
0, 
-1, -0.376357, 0, -1, 0.25337,-99) , 
3, 0.17816, 0, 0, 0.47951,-99)    );
  // itree = 432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.913214, 0, 1, 0.864227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383409,-99) , 
3, 1.39358, 0, 0, 0.68648,-99) , 
0, 1.57052, 1, 0, 0.768999,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253154,-99) , 
0, 0.205075, 1, 0, 0.511728,-99) , 
NN(
0, 
0, 
-1, -1.23403, 0, -1, 0.182895,-99) , 
3, -0.511418, 0, 0, 0.365048,-99) , 
3, 0.650374, 0, 0, 0.519701,-99)    );
  // itree = 433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.850835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416237,-99) , 
0, 1.0847, 1, 0, 0.659551,-99) , 
3, 1.38395, 0, 0, 0.727646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278308,-99) , 
0, -1.44513, 1, 0, 0.371597,-99) , 
NN(
0, 
0, 
-1, -1.97441, 0, -1, 0.130387,-99) , 
3, -1.15126, 0, 0, 0.297412,-99) , 
3, 0.183842, 0, 0, 0.50499,-99)    );
  // itree = 434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.980358, 0, 1, 0.692813,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.162841,-99) , 
3, -0.38184, 0, 0, 0.503374,-99)    );
  // itree = 435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.865132, 0, 1, 0.878831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405466,-99) , 
3, 1.34572, 0, 0, 0.719561,-99) , 
0, 1.07877, 1, 0, 0.789036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693643,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352711,-99) , 
0, -0.808923, 1, 0, 0.468856,-99) , 
NN(
0, 
0, 
-1, -1.6745, 0, -1, 0.179093,-99) , 
3, -0.553506, 0, 0, 0.311176,-99) , 
3, 0.228801, 0, 0, 0.53999,-99)    );
  // itree = 436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.883326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328374,-99) , 
0, 1.17393, 1, 0, 0.628966,-99) , 
3, 1.29901, 0, 0, 0.730476,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278004,-99) , 
0, -0.765399, 1, 0, 0.377577,-99) , 
NN(
0, 
0, 
-1, 0.122417, 1, -1, 0.156084,-99) , 
3, -0.527848, 0, 0, 0.250116,-99) , 
3, 0.28719, 0, 0, 0.457617,-99)    );
  // itree = 437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.846341,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302139,-99) , 
0, 1.02331, 1, 0, 0.579117,-99) , 
3, 1.07702, 0, 0, 0.675987,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.166627,-99) , 
3, -0.304384, 0, 0, 0.495228,-99)    );
  // itree = 438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.410539, 0, 1, 0.90499,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34366,-99) , 
3, 1.13907, 0, 0, 0.69454,-99) , 
0, 1.10708, 1, 0, 0.778402,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215854,-99) , 
0, -0.429835, 1, 0, 0.401885,-99) , 
NN(
0, 
0, 
-1, -0.0873648, 1, -1, 0.126898,-99) , 
3, -0.959868, 0, 0, 0.295645,-99) , 
3, 0.306962, 0, 0, 0.503154,-99)    );
  // itree = 439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.945982, 1, 1, 0.840835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348852,-99) , 
0, 0.614664, 1, 0, 0.589772,-99) , 
3, 0.837674, 0, 0, 0.74837,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264202,-99) , 
0, -0.841692, 1, 0, 0.398581,-99) , 
NN(
0, 
0, 
-1, -2.03196, 0, -1, 0.146427,-99) , 
3, -0.691476, 0, 0, 0.271699,-99) , 
3, 0.254861, 0, 0, 0.489447,-99)    );
  // itree = 440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.1803, 1, 1, 0.877365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458961,-99) , 
3, 1.14011, 0, 0, 0.677961,-99) , 
0, 0.505535, 1, 0, 0.735806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257134,-99) , 
0, -1.36562, 1, 0, 0.373535,-99) , 
NN(
0, 
0, 
-1, -2.90465, 1, -1, 0.113676,-99) , 
3, -0.990852, 0, 0, 0.269617,-99) , 
3, 0.0990605, 0, 0, 0.498052,-99)    );
  // itree = 441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32462, 0, 1, 0.83503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272478,-99) , 
0, 0.45101, 1, 0, 0.51709,-99) , 
3, 0.985321, 0, 0, 0.640555,-99) , 
NN(
0, 
0, 
-1, -1.30427, 0, -1, 0.210057,-99) , 
3, -0.123397, 0, 0, 0.466772,-99)    );
  // itree = 442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.798782,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301528,-99) , 
0, 0.17724, 1, 0, 0.577817,-99) , 
3, 0.62943, 0, 0, 0.701575,-99) , 
NN(
0, 
0, 
-1, -0.742633, 0, -1, 0.216392,-99) , 
3, -0.255748, 0, 0, 0.511443,-99)    );
  // itree = 443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52228, 1, 1, 0.85729,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42599,-99) , 
0, 0.540099, 1, 0, 0.631434,-99) , 
3, 1.13472, 0, 0, 0.730885,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229663,-99) , 
0, -1.2877, 1, 0, 0.318158,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.0904172,-99) , 
3, -1.18822, 0, 0, 0.234845,-99) , 
3, 0.135748, 0, 0, 0.486478,-99)    );
  // itree = 444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.345751, 1, 1, 0.795312,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358398,-99) , 
0, -0.988002, 1, 0, 0.49469,-99) , 
3, 0.266961, 0, 0, 0.678744,-99) , 
NN(
0, 
0, 
-1, -1.19907, 0, -1, 0.162199,-99) , 
3, -0.749223, 0, 0, 0.53069,-99)    );
  // itree = 445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.59468, 1, 1, 0.879456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872927,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407824,-99) , 
0, 0.819061, 1, 0, 0.661863,-99) , 
3, 1.36152, 0, 0, 0.756798,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253258,-99) , 
0, -0.403406, 1, 0, 0.433697,-99) , 
NN(
0, 
0, 
-1, -0.979332, 0, -1, 0.161273,-99) , 
3, -0.414216, 0, 0, 0.261749,-99) , 
3, 0.207882, 0, 0, 0.49812,-99)    );
  // itree = 446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.988815, 1, 1, 0.847702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384037,-99) , 
0, 0.191795, 1, 0, 0.583136,-99) , 
3, 0.84679, 0, 0, 0.707887,-99) , 
NN(
0, 
0, 
-1, -1.32289, 0, -1, 0.210717,-99) , 
3, -0.304384, 0, 0, 0.526341,-99)    );
  // itree = 447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.903108, 0, 1, 0.763912,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184186,-99) , 
0, -0.169453, 1, 0, 0.42816,-99) , 
NN(
0, 
0, 
-1, -1.75233, 1, -1, 0.181191,-99) , 
3, -0.52447, 0, 0, 0.300694,-99) , 
3, 0.28719, 0, 0, 0.496852,-99)    );
  // itree = 448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0194754, 1, 1, 0.787389,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295567,-99) , 
0, -0.616482, 1, 0, 0.457387,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.15429,-99) , 
3, -0.283728, 0, 0, 0.244366,-99) , 
3, 0.262941, 0, 0, 0.477893,-99)    );
  // itree = 449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.869052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388329,-99) , 
0, 0.84413, 1, 0, 0.658788,-99) , 
3, 1.1409, 0, 0, 0.756641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524339,-99) , 
NN(
0, 
0, 
-1, -1.09696, 0, -1, 0.192002,-99) , 
3, -0.103997, 0, 0, 0.244669,-99) , 
3, 0.161658, 0, 0, 0.489033,-99)    );
  // itree = 450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.761991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479984,-99) , 
3, 0.264998, 0, 0, 0.694889,-99) , 
NN(
0, 
0, 
-1, -1.91998, 0, -1, 0.19674,-99) , 
3, -0.18324, 0, 0, 0.49985,-99)    );
  // itree = 451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.82976, 1, 1, 0.876093,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235769,-99) , 
0, 1.06604, 1, 0, 0.636626,-99) , 
3, 1.09764, 0, 0, 0.764427,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376589,-99) , 
0, -0.781662, 1, 0, 0.497421,-99) , 
NN(
0, 
0, 
-1, -1.79212, 1, -1, 0.152334,-99) , 
3, -0.530172, 0, 0, 0.305539,-99) , 
3, 0.28719, 0, 0, 0.511627,-99)    );
  // itree = 452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.882126,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448138,-99) , 
0, 0.985676, 1, 0, 0.632176,-99) , 
3, 1.41801, 0, 0, 0.714765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551533,-99) , 
NN(
0, 
0, 
-1, -1.05083, 0, -1, 0.216105,-99) , 
3, -0.03889, 0, 0, 0.276429,-99) , 
3, 0.228725, 0, 0, 0.481093,-99)    );
  // itree = 453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0349137, 1, 1, 0.882811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417337,-99) , 
3, 1.12392, 0, 0, 0.689006,-99) , 
0, 0.672052, 1, 0, 0.75258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634501,-99) , 
NN(
0, 
0, 
-1, -0.956887, 0, -1, 0.214855,-99) , 
3, -0.178948, 0, 0, 0.277125,-99) , 
3, 0.0990605, 0, 0, 0.517723,-99)    );
  // itree = 454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.874573,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382399,-99) , 
0, 1.0847, 1, 0, 0.672273,-99) , 
3, 1.42244, 0, 0, 0.743417,-99) , 
NN(
0, 
0, 
-1, -0.376357, 0, -1, 0.247492,-99) , 
3, 0.17816, 0, 0, 0.483291,-99)    );
  // itree = 455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.267433, 1, 1, 0.894834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437865,-99) , 
0, 0.813622, 1, 0, 0.645818,-99) , 
3, 1.43937, 0, 0, 0.71419,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.221654,-99) , 
3, -0.123397, 0, 0, 0.489344,-99)    );
  // itree = 456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.892966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406229,-99) , 
0, 0.944567, 1, 0, 0.60364,-99) , 
3, 1.41195, 0, 0, 0.678744,-99) , 
NN(
0, 
0, 
-1, -3.13676, 1, -1, 0.153613,-99) , 
3, -0.344168, 0, 0, 0.476718,-99)    );
  // itree = 457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.793832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274122,-99) , 
0, 0.256929, 1, 0, 0.534662,-99) , 
3, 0.66689, 0, 0, 0.679814,-99) , 
NN(
0, 
0, 
-1, -0.798162, 0, -1, 0.201012,-99) , 
3, -0.207894, 0, 0, 0.487783,-99)    );
  // itree = 458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.854984,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423743,-99) , 
0, 0.647916, 1, 0, 0.63501,-99) , 
3, 1.2063, 0, 0, 0.718178,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277053,-99) , 
0, -1.21605, 1, 0, 0.409292,-99) , 
NN(
0, 
0, 
-1, -0.259045, 1, -1, 0.101036,-99) , 
3, -1.00946, 0, 0, 0.254873,-99) , 
3, -0.123397, 0, 0, 0.510959,-99)    );
  // itree = 459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.856613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401415,-99) , 
0, 0.829465, 1, 0, 0.626754,-99) , 
3, 1.08361, 0, 0, 0.743861,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271893,-99) , 
0, -0.866905, 1, 0, 0.37743,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.113835,-99) , 
3, -0.959342, 0, 0, 0.275397,-99) , 
3, 0.306962, 0, 0, 0.480579,-99)    );
  // itree = 460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7717, 1, 1, 0.841943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357978,-99) , 
0, 0.478161, 1, 0, 0.586432,-99) , 
3, 0.847775, 0, 0, 0.701535,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.21254,-99) , 
3, -0.304384, 0, 0, 0.509096,-99)    );
  // itree = 461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.844912,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316298,-99) , 
0, 0.782483, 1, 0, 0.593157,-99) , 
3, 1.08443, 0, 0, 0.72091,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259617,-99) , 
0, -0.72203, 1, 0, 0.384962,-99) , 
NN(
0, 
0, 
-1, -1.72353, 0, -1, 0.132907,-99) , 
3, -0.642066, 0, 0, 0.255666,-99) , 
3, 0.306962, 0, 0, 0.454857,-99)    );
  // itree = 462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.884508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370347,-99) , 
0, 0.725116, 1, 0, 0.620623,-99) , 
3, 1.12222, 0, 0, 0.730793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506812,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.214723,-99) , 
3, -0.372375, 0, 0, 0.291688,-99) , 
3, 0.147523, 0, 0, 0.524882,-99)    );
  // itree = 463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74111, 1, 1, 0.863821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364789,-99) , 
0, 0.304336, 1, 0, 0.571567,-99) , 
3, 0.983057, 0, 0, 0.682701,-99) , 
NN(
0, 
0, 
-1, -1.37635, 0, -1, 0.142019,-99) , 
3, -0.376892, 0, 0, 0.494237,-99)    );
  // itree = 464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.46194, 1, 1, 0.896627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493548,-99) , 
0, 1.02702, 1, 0, 0.660968,-99) , 
3, 1.53622, 0, 0, 0.714462,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.221107,-99) , 
3, -0.304384, 0, 0, 0.520558,-99)    );
  // itree = 465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53058, 0, 1, 0.869621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283745,-99) , 
0, 0.920728, 1, 0, 0.552938,-99) , 
3, 1.20395, 0, 0, 0.666622,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.211461,-99) , 
3, -0.123397, 0, 0, 0.484993,-99)    );
  // itree = 466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.867993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355035,-99) , 
0, 0.877072, 1, 0, 0.641342,-99) , 
3, 1.20395, 0, 0, 0.718007,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237754,-99) , 
0, -1.21605, 1, 0, 0.367852,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.112585,-99) , 
3, -1.00886, 0, 0, 0.244607,-99) , 
3, -0.123397, 0, 0, 0.50729,-99)    );
  // itree = 467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58845, 1, 1, 0.882384,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344583,-99) , 
0, 1.38125, 1, 0, 0.688256,-99) , 
3, 1.34566, 0, 0, 0.76231,-99) , 
NN(
0, 
0, 
-1, -0.366367, 0, -1, 0.281709,-99) , 
3, 0.159996, 0, 0, 0.525386,-99)    );
  // itree = 468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.16101, 0, 1, 0.721392,-99) , 
NN(
0, 
0, 
-1, -1.06833, 1, -1, 0.203319,-99) , 
3, -0.18324, 0, 0, 0.503633,-99)    );
  // itree = 469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.362526, 0, 1, 0.871108,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460994,-99) , 
3, 1.42516, 0, 0, 0.687196,-99) , 
0, 0.971748, 1, 0, 0.769748,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395412,-99) , 
1, -0.109688, 1, 0, 0.476158,-99) , 
NN(
0, 
0, 
-1, -1.29338, 0, -1, 0.187228,-99) , 
3, -0.332748, 0, 0, 0.281929,-99) , 
3, 0.202693, 0, 0, 0.520489,-99)    );
  // itree = 470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.698745, 1, 1, 0.792174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230036,-99) , 
0, -0.110993, 1, 0, 0.445072,-99) , 
NN(
0, 
0, 
-1, -1.76075, 0, -1, 0.175642,-99) , 
3, -0.329146, 0, 0, 0.277849,-99) , 
3, 0.306962, 0, 0, 0.48319,-99)    );
  // itree = 471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.824436,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252582,-99) , 
0, 0.708301, 1, 0, 0.626025,-99) , 
3, 0.98281, 0, 0, 0.710666,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.228122,-99) , 
3, -0.123397, 0, 0, 0.521739,-99)    );
  // itree = 472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56234, 0, 1, 0.847602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340991,-99) , 
0, 0.708301, 1, 0, 0.632174,-99) , 
3, 1.09048, 0, 0, 0.711392,-99) , 
NN(
0, 
0, 
-1, -0.968012, 0, -1, 0.276521,-99) , 
3, -0.232821, 0, 0, 0.53643,-99)    );
  // itree = 473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81533, 1, 1, 0.819523,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442484,-99) , 
0, 0.199449, 1, 0, 0.611711,-99) , 
3, 0.979531, 0, 0, 0.713181,-99) , 
NN(
0, 
0, 
-1, -0.889835, 0, -1, 0.232316,-99) , 
3, 0.178444, 0, 0, 0.466234,-99)    );
  // itree = 474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.735369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464919,-99) , 
3, 0.244337, 0, 0, 0.669244,-99) , 
NN(
0, 
0, 
-1, -1.21087, 0, -1, 0.197044,-99) , 
3, -0.210183, 0, 0, 0.476079,-99)    );
  // itree = 475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56224, 1, 1, 0.877617,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41947,-99) , 
0, 0.931454, 1, 0, 0.69342,-99) , 
3, 1.18404, 0, 0, 0.780653,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673656,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321847,-99) , 
0, -0.988002, 1, 0, 0.424778,-99) , 
NN(
0, 
0, 
-1, -1.07669, 0, -1, 0.155997,-99) , 
3, -0.618704, 0, 0, 0.270342,-99) , 
3, 0.183842, 0, 0, 0.497149,-99)    );
  // itree = 476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49285, 0, 1, 0.856618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317817,-99) , 
0, 0.565787, 1, 0, 0.570593,-99) , 
3, 0.98281, 0, 0, 0.701776,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188199,-99) , 
0, -1.17488, 1, 0, 0.31554,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.0988697,-99) , 
3, -1.00886, 0, 0, 0.20837,-99) , 
3, -0.123397, 0, 0, 0.503913,-99)    );
  // itree = 477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42967, 0, 1, 0.708844,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.23709,-99) , 
3, -0.123397, 0, 0, 0.507498,-99)    );
  // itree = 478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.71139, 1, 1, 0.843598,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268217,-99) , 
0, 0.802635, 1, 0, 0.581342,-99) , 
3, 1.11481, 0, 0, 0.699007,-99) , 
NN(
0, 
0, 
-1, -0.454519, 0, -1, 0.223291,-99) , 
3, 0.093663, 0, 0, 0.465195,-99)    );
  // itree = 479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58435, 0, 1, 0.855561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349835,-99) , 
0, 0.657426, 1, 0, 0.605064,-99) , 
3, 0.918446, 0, 0, 0.747513,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195509,-99) , 
0, -0.759582, 1, 0, 0.333533,-99) , 
NN(
0, 
0, 
-1, -0.0109455, 1, -1, 0.120669,-99) , 
3, -0.997451, 0, 0, 0.249649,-99) , 
3, 0.093663, 0, 0, 0.505146,-99)    );
  // itree = 480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.23458, 1, 1, 0.903194,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325975,-99) , 
0, 0.708301, 1, 0, 0.543593,-99) , 
3, 1.20885, 0, 0, 0.66329,-99) , 
NN(
0, 
0, 
-1, -1.41328, 1, -1, 0.203366,-99) , 
3, -0.123397, 0, 0, 0.463359,-99)    );
  // itree = 481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5443, 1, 1, 0.883135,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435738,-99) , 
0, 1.37765, 1, 0, 0.695959,-99) , 
3, 1.58387, 0, 0, 0.750114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527375,-99) , 
NN(
0, 
0, 
-1, -1.17601, 1, -1, 0.18311,-99) , 
3, -0.351888, 0, 0, 0.284205,-99) , 
3, 0.183842, 0, 0, 0.509018,-99)    );
  // itree = 482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.694882, 0, 1, 0.754847,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382323,-99) , 
0, -0.661533, 1, 0, 0.496656,-99) , 
NN(
0, 
0, 
-1, -1.79283, 1, -1, 0.182682,-99) , 
3, -0.52447, 0, 0, 0.315759,-99) , 
3, 0.28719, 0, 0, 0.511147,-99)    );
  // itree = 483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.849555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268099,-99) , 
0, 1.22611, 1, 0, 0.630344,-99) , 
3, 1.20395, 0, 0, 0.707624,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215462,-99) , 
0, -1.20764, 1, 0, 0.346089,-99) , 
NN(
0, 
0, 
-1, 0.185214, 1, -1, 0.0923104,-99) , 
3, -1.00886, 0, 0, 0.22473,-99) , 
3, -0.123397, 0, 0, 0.497031,-99)    );
  // itree = 484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.786079, 0, 1, 0.772781,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200544,-99) , 
0, -0.312245, 1, 0, 0.434866,-99) , 
NN(
0, 
0, 
-1, -1.12048, 0, -1, 0.163426,-99) , 
3, -0.568264, 0, 0, 0.29538,-99) , 
3, 0.392653, 0, 0, 0.495744,-99)    );
  // itree = 485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.248734, 0, 1, 0.757308,-99) , 
NN(
0, 
0, 
-1, -0.96519, 0, -1, 0.251705,-99) , 
3, -0.210183, 0, 0, 0.555493,-99)    );
  // itree = 486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1598, 1, 1, 0.837281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233274,-99) , 
0, 1.01216, 1, 0, 0.572342,-99) , 
3, 1.07833, 0, 0, 0.706742,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319073,-99) , 
0, -0.765399, 1, 0, 0.440332,-99) , 
NN(
0, 
0, 
-1, -1.86171, 1, -1, 0.164044,-99) , 
3, -0.549899, 0, 0, 0.280946,-99) , 
3, 0.262941, 0, 0, 0.476513,-99)    );
  // itree = 487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21129, 1, 1, 0.848549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410808,-99) , 
0, 0.696072, 1, 0, 0.678825,-99) , 
3, 1.00821, 0, 0, 0.77401,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374363,-99) , 
1, -0.0993461, 1, 0, 0.516509,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.18578,-99) , 
3, -0.322974, 0, 0, 0.286934,-99) , 
3, 0.20809, 0, 0, 0.513618,-99)    );
  // itree = 488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.240147, 0, 1, 0.713696,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.225978,-99) , 
3, -0.202496, 0, 0, 0.511619,-99)    );
  // itree = 489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.69147, 1, 1, 0.866142,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416703,-99) , 
0, 0.420974, 1, 0, 0.625509,-99) , 
3, 0.99324, 0, 0, 0.736783,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181723,-99) , 
0, -1.18308, 1, 0, 0.364494,-99) , 
NN(
0, 
0, 
-1, 0.0922523, 1, -1, 0.15758,-99) , 
3, -1.00946, 0, 0, 0.270697,-99) , 
3, -0.123397, 0, 0, 0.530353,-99)    );
  // itree = 490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.376103, 1, 1, 0.839177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396251,-99) , 
3, 1.39872, 0, 0, 0.669188,-99) , 
0, 1.17756, 1, 0, 0.745724,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257484,-99) , 
0, -1.43519, 1, 0, 0.323011,-99) , 
NN(
0, 
0, 
-1, -1.3665, 1, -1, 0.0808203,-99) , 
3, -1.09042, 0, 0, 0.245208,-99) , 
3, 0.262941, 0, 0, 0.455626,-99)    );
  // itree = 491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82145, 1, 1, 0.846982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357896,-99) , 
0, 0.695998, 1, 0, 0.579789,-99) , 
3, 1.14319, 0, 0, 0.66289,-99) , 
NN(
0, 
0, 
-1, -0.932739, 0, -1, 0.160406,-99) , 
3, -0.351517, 0, 0, 0.471195,-99)    );
  // itree = 492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.819334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384371,-99) , 
0, 0.210433, 1, 0, 0.582548,-99) , 
3, 0.672086, 0, 0, 0.718813,-99) , 
NN(
0, 
0, 
-1, -0.787163, 0, -1, 0.2319,-99) , 
3, -0.202496, 0, 0, 0.526927,-99)    );
  // itree = 493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.76301,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208334,-99) , 
0, 0.149115, 1, 0, 0.52546,-99) , 
3, 0.558208, 0, 0, 0.660851,-99) , 
NN(
0, 
0, 
-1, -1.0683, 0, -1, 0.202548,-99) , 
3, -0.326776, 0, 0, 0.500461,-99)    );
  // itree = 494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50079, 1, 1, 0.848281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294275,-99) , 
0, 0.906178, 1, 0, 0.604566,-99) , 
3, 1.0105, 0, 0, 0.725522,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198724,-99) , 
0, -0.85877, 1, 0, 0.371392,-99) , 
NN(
0, 
0, 
-1, -2.18226, 1, -1, 0.141267,-99) , 
3, -0.927516, 0, 0, 0.268595,-99) , 
3, 0.17816, 0, 0, 0.493857,-99)    );
  // itree = 495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31308, 0, 1, 0.809788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322392,-99) , 
0, 0.193081, 1, 0, 0.55684,-99) , 
3, 0.552263, 0, 0, 0.71735,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.22435,-99) , 
3, -0.123397, 0, 0, 0.490143,-99)    );
  // itree = 496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.88479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38557,-99) , 
0, 0.856209, 1, 0, 0.634684,-99) , 
3, 1.37878, 0, 0, 0.732096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543827,-99) , 
NN(
0, 
0, 
-1, -1.10929, 0, -1, 0.19628,-99) , 
3, -0.0913569, 0, 0, 0.249411,-99) , 
3, 0.178444, 0, 0, 0.482481,-99)    );
  // itree = 497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20885, 0, 1, 0.717884,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.265526,-99) , 
3, -0.123397, 0, 0, 0.531077,-99)    );
  // itree = 498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.987005, 1, 1, 0.807723,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348037,-99) , 
0, -0.135613, 1, 0, 0.556322,-99) , 
3, 0.543354, 0, 0, 0.725135,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.219255,-99) , 
3, -0.123397, 0, 0, 0.498227,-99)    );
  // itree = 499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.91994, 1, 1, 0.816405,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300013,-99) , 
0, 0.465064, 1, 0, 0.547432,-99) , 
3, 0.847414, 0, 0, 0.67359,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.173812,-99) , 
3, -0.304384, 0, 0, 0.489793,-99)    );
  // itree = 500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58046, 0, 1, 0.855537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38407,-99) , 
0, 0.459356, 1, 0, 0.592248,-99) , 
3, 1.11225, 0, 0, 0.698648,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192305,-99) , 
0, -1.25617, 1, 0, 0.340081,-99) , 
NN(
0, 
0, 
-1, -1.84207, 0, -1, 0.138075,-99) , 
3, -1.08857, 0, 0, 0.249006,-99) , 
3, -0.202496, 0, 0, 0.518525,-99)    );
  // itree = 501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.87868, 1, 1, 0.858952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312362,-99) , 
0, 0.957246, 1, 0, 0.623908,-99) , 
3, 1.29796, 0, 0, 0.699713,-99) , 
NN(
0, 
0, 
-1, -0.742633, 0, -1, 0.227159,-99) , 
3, -0.255748, 0, 0, 0.537843,-99)    );
  // itree = 502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.863948,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255721,-99) , 
0, 1.09601, 1, 0, 0.61211,-99) , 
3, 1.08418, 0, 0, 0.736203,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350832,-99) , 
0, -0.862786, 1, 0, 0.461092,-99) , 
NN(
0, 
0, 
-1, -2.54298, 1, -1, 0.163459,-99) , 
3, -0.64095, 0, 0, 0.304592,-99) , 
3, 0.306962, 0, 0, 0.492653,-99)    );
  // itree = 503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.50291, 1, 1, 0.88649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338126,-99) , 
3, 0.94008, 0, 0, 0.671435,-99) , 
0, 0.680585, 1, 0, 0.74679,-99) , 
NN(
0, 
0, 
-1, -0.450619, 0, -1, 0.232938,-99) , 
3, 0.093663, 0, 0, 0.490514,-99)    );
  // itree = 504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0349399, 0, 1, 0.890189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226807,-99) , 
3, 1.14028, 0, 0, 0.63244,-99) , 
0, 0.986637, 1, 0, 0.736754,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671213,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324127,-99) , 
0, -1.08314, 1, 0, 0.443959,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.125248,-99) , 
3, -0.960097, 0, 0, 0.31699,-99) , 
3, 0.306962, 0, 0, 0.50544,-99)    );
  // itree = 505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.256001, 1, 1, 0.752006,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366276,-99) , 
1, -0.213158, 1, 0, 0.471867,-99) , 
3, 0.264294, 0, 0, 0.655792,-99) , 
NN(
0, 
0, 
-1, -2.54298, 1, -1, 0.146583,-99) , 
3, -0.711955, 0, 0, 0.494686,-99)    );
  // itree = 506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.852946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367353,-99) , 
0, 1.00867, 1, 0, 0.634771,-99) , 
3, 1.26767, 0, 0, 0.713624,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195063,-99) , 
0, -1.2877, 1, 0, 0.322631,-99) , 
NN(
0, 
0, 
-1, -2.29692, 1, -1, 0.10646,-99) , 
3, -1.03948, 0, 0, 0.236516,-99) , 
3, 0.0509667, 0, 0, 0.469918,-99)    );
  // itree = 507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43501, 1, 1, 0.830139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368131,-99) , 
0, 0.242068, 1, 0, 0.576343,-99) , 
3, 0.972983, 0, 0, 0.679326,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.216956,-99) , 
3, -0.344168, 0, 0, 0.511147,-99)    );
  // itree = 508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.844499,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360045,-99) , 
0, 0.486742, 1, 0, 0.622885,-99) , 
3, 0.98281, 0, 0, 0.718075,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.205109,-99) , 
3, -0.123397, 0, 0, 0.499326,-99)    );
  // itree = 509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02371, 1, 1, 0.839158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377264,-99) , 
0, 0.782483, 1, 0, 0.636234,-99) , 
3, 0.982657, 0, 0, 0.755929,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520811,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228081,-99) , 
0, -0.132637, 1, 0, 0.405234,-99) , 
NN(
0, 
0, 
-1, -1.13657, 0, -1, 0.120737,-99) , 
3, -0.568255, 0, 0, 0.248992,-99) , 
3, 0.392653, 0, 0, 0.449326,-99)    );
  // itree = 510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.845272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298753,-99) , 
0, 0.930442, 1, 0, 0.622603,-99) , 
3, 1.25891, 0, 0, 0.706128,-99) , 
NN(
0, 
0, 
-1, -0.533447, 0, -1, 0.214423,-99) , 
3, -0.0502295, 0, 0, 0.478162,-99)    );
  // itree = 511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.102691, 1, 1, 0.778798,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199009,-99) , 
0, -0.991976, 1, 0, 0.331072,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.0885564,-99) , 
3, -0.993962, 0, 0, 0.23389,-99) , 
3, 0.093663, 0, 0, 0.495545,-99)    );
  // itree = 512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.712152, 0, 1, 0.939427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466235,-99) , 
3, 1.13293, 0, 0, 0.714798,-99) , 
0, 0.702317, 1, 0, 0.779031,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290937,-99) , 
0, -0.831231, 1, 0, 0.407468,-99) , 
NN(
0, 
0, 
-1, -1.65122, 1, -1, 0.122699,-99) , 
3, -0.644244, 0, 0, 0.251825,-99) , 
3, 0.306962, 0, 0, 0.451853,-99)    );
  // itree = 513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.850623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349076,-99) , 
0, 0.639693, 1, 0, 0.582525,-99) , 
3, 0.960005, 0, 0, 0.740891,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155909,-99) , 
0, -0.0856679, 1, 0, 0.394003,-99) , 
NN(
0, 
0, 
-1, -1.80297, 1, -1, 0.118063,-99) , 
3, -0.705545, 0, 0, 0.275068,-99) , 
3, 0.355994, 0, 0, 0.466552,-99)    );
  // itree = 514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.694098, 1, 1, 0.895131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290501,-99) , 
3, 1.13907, 0, 0, 0.661668,-99) , 
0, 1.02343, 1, 0, 0.745443,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251557,-99) , 
0, -0.831231, 1, 0, 0.384018,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.120662,-99) , 
3, -0.957285, 0, 0, 0.280798,-99) , 
3, 0.306962, 0, 0, 0.477104,-99)    );
  // itree = 515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.26929, 1, 1, 0.920065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469065,-99) , 
0, 1.11302, 1, 0, 0.731432,-99) , 
3, 1.37581, 0, 0, 0.814547,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166186,-99) , 
0, -0.0856679, 1, 0, 0.3967,-99) , 
NN(
0, 
0, 
-1, 0.338353, 1, -1, 0.111264,-99) , 
3, -0.886371, 0, 0, 0.291407,-99) , 
3, 0.392653, 0, 0, 0.51197,-99)    );
  // itree = 516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90498, 1, 1, 0.875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486038,-99) , 
0, 0.240286, 1, 0, 0.614405,-99) , 
3, 1.20395, 0, 0, 0.704369,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.231463,-99) , 
3, -0.123397, 0, 0, 0.532421,-99)    );
  // itree = 517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.160285, 1, 1, 0.88063,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468104,-99) , 
0, 0.438273, 1, 0, 0.618002,-99) , 
3, 1.14265, 0, 0, 0.711617,-99) , 
NN(
0, 
0, 
-1, -1.17871, 0, -1, 0.179044,-99) , 
3, -0.435158, 0, 0, 0.523219,-99)    );
  // itree = 518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29497, 0, 1, 0.817184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392119,-99) , 
0, -0.218242, 1, 0, 0.577093,-99) , 
3, 0.527818, 0, 0, 0.7231,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242835,-99) , 
3, -0.525786, 0, 0, 0.341685,-99) , 
NN(
0, 
0, 
-1, 0.0509554, 1, -1, 0.0989772,-99) , 
3, -1.12985, 0, 0, 0.231273,-99) , 
3, -0.140969, 0, 0, 0.523669,-99)    );
  // itree = 519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27825, 0, 1, 0.756778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430924,-99) , 
3, 0.0172834, 0, 0, 0.710087,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.239411,-99) , 
3, -0.202496, 0, 0, 0.528532,-99)    );
  // itree = 520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.155637, 1, 1, 0.877896,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299511,-99) , 
3, 1.38537, 0, 0, 0.684811,-99) , 
0, 1.16902, 1, 0, 0.767232,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25726,-99) , 
0, -0.774779, 1, 0, 0.38318,-99) , 
NN(
0, 
0, 
-1, -2.85873, 1, -1, 0.109677,-99) , 
3, -1.10651, 0, 0, 0.281675,-99) , 
3, 0.223327, 0, 0, 0.501248,-99)    );
  // itree = 521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45879, 1, 1, 0.801513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336579,-99) , 
0, -0.118038, 1, 0, 0.547872,-99) , 
3, 0.540529, 0, 0, 0.720993,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.201428,-99) , 
3, -0.123397, 0, 0, 0.485025,-99)    );
  // itree = 522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.822407,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294216,-99) , 
2, 0.430975, 1, 0, 0.560703,-99) , 
3, 0.756418, 0, 0, 0.680938,-99) , 
NN(
0, 
0, 
-1, -1.63151, 0, -1, 0.173481,-99) , 
3, -0.376892, 0, 0, 0.487831,-99)    );
  // itree = 523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.52757, 0, 1, 0.868026,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366074,-99) , 
3, 1.2268, 0, 0, 0.66774,-99) , 
0, 1.16242, 1, 0, 0.76154,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312955,-99) , 
0, -0.991976, 1, 0, 0.407853,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.110996,-99) , 
3, -1.08906, 0, 0, 0.30455,-99) , 
3, 0.262941, 0, 0, 0.508728,-99)    );
  // itree = 524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42623, 1, 1, 0.806059,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380869,-99) , 
0, -0.0316589, 1, 0, 0.609358,-99) , 
3, 0.540529, 0, 0, 0.732797,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193492,-99) , 
0, -1.21605, 1, 0, 0.351966,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.109048,-99) , 
3, -1.01154, 0, 0, 0.240738,-99) , 
3, -0.123397, 0, 0, 0.509351,-99)    );
  // itree = 525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.881821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384401,-99) , 
0, 0.498151, 1, 0, 0.606515,-99) , 
3, 1.06693, 0, 0, 0.732343,-99) , 
NN(
0, 
0, 
-1, -0.49459, 0, -1, 0.229347,-99) , 
3, 0.0509667, 0, 0, 0.481734,-99)    );
  // itree = 526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52065, 1, 1, 0.857795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443272,-99) , 
0, 0.459356, 1, 0, 0.630227,-99) , 
3, 0.985321, 0, 0, 0.72392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524596,-99) , 
NN(
0, 
0, 
-1, -0.983078, 0, -1, 0.188976,-99) , 
3, -0.419174, 0, 0, 0.252957,-99) , 
3, -0.123397, 0, 0, 0.522492,-99)    );
  // itree = 527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.877449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354758,-99) , 
0, 0.92467, 1, 0, 0.643328,-99) , 
3, 1.27529, 0, 0, 0.71375,-99) , 
NN(
0, 
0, 
-1, -0.779095, 0, -1, 0.24352,-99) , 
3, -0.28269, 0, 0, 0.531098,-99)    );
  // itree = 528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66579, 0, 1, 0.756666,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300095,-99) , 
0, -0.781662, 1, 0, 0.410317,-99) , 
NN(
0, 
0, 
-1, -1.65122, 1, -1, 0.153735,-99) , 
3, -0.644244, 0, 0, 0.263644,-99) , 
3, 0.306962, 0, 0, 0.482045,-99)    );
  // itree = 529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.869, 1, 1, 0.851986,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359557,-99) , 
0, 0.738333, 1, 0, 0.595254,-99) , 
3, 1.10402, 0, 0, 0.698614,-99) , 
NN(
0, 
0, 
-1, -0.803911, 0, -1, 0.194426,-99) , 
3, -0.207894, 0, 0, 0.497702,-99)    );
  // itree = 530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21129, 1, 1, 0.83985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327968,-99) , 
0, 0.84413, 1, 0, 0.649614,-99) , 
3, 1.01301, 0, 0, 0.746463,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334872,-99) , 
0, -0.426132, 1, 0, 0.469306,-99) , 
NN(
0, 
0, 
-1, -1.50118, 0, -1, 0.160084,-99) , 
3, -0.587974, 0, 0, 0.26689,-99) , 
3, 0.20809, 0, 0, 0.496565,-99)    );
  // itree = 531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32462, 0, 1, 0.843921,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296276,-99) , 
0, 0.708301, 1, 0, 0.61125,-99) , 
3, 0.98281, 0, 0, 0.715425,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.192636,-99) , 
3, -0.123397, 0, 0, 0.495115,-99)    );
  // itree = 532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8725, 1, 1, 0.911858,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723839,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302415,-99) , 
0, 1.14512, 1, 0, 0.593444,-99) , 
3, 1.42073, 0, 0, 0.698369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586822,-99) , 
NN(
0, 
0, 
-1, -1.15459, 0, -1, 0.220146,-99) , 
3, -0.100777, 0, 0, 0.290383,-99) , 
3, 0.17816, 0, 0, 0.488674,-99)    );
  // itree = 533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.84196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376022,-99) , 
0, 0.778252, 1, 0, 0.634708,-99) , 
3, 1.08013, 0, 0, 0.736394,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285739,-99) , 
0, -0.538822, 1, 0, 0.465816,-99) , 
NN(
0, 
0, 
-1, -1.02325, 0, -1, 0.157478,-99) , 
3, -0.549899, 0, 0, 0.292127,-99) , 
3, 0.262941, 0, 0, 0.496451,-99)    );
  // itree = 534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.806139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432761,-99) , 
0, -0.0834363, 1, 0, 0.602145,-99) , 
3, 0.753497, 0, 0, 0.701483,-99) , 
NN(
0, 
0, 
-1, -1.06934, 0, -1, 0.178757,-99) , 
3, -0.344168, 0, 0, 0.500164,-99)    );
  // itree = 535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.665836, 1, 1, 0.847728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323957,-99) , 
0, 0.891, 1, 0, 0.591075,-99) , 
3, 1.20395, 0, 0, 0.683816,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.191957,-99) , 
3, -0.123397, 0, 0, 0.459534,-99)    );
  // itree = 536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25225, 1, 1, 0.84532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217005,-99) , 
0, 0.872991, 1, 0, 0.534616,-99) , 
3, 0.993256, 0, 0, 0.643146,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.147628,-99) , 
3, -0.711955, 0, 0, 0.510807,-99)    );
  // itree = 537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.90833, 1, 1, 0.880737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381033,-99) , 
0, 0.854666, 1, 0, 0.613442,-99) , 
3, 1.42967, 0, 0, 0.690062,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.228772,-99) , 
3, -0.123397, 0, 0, 0.507329,-99)    );
  // itree = 538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.870317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245829,-99) , 
0, 1.32273, 1, 0, 0.663309,-99) , 
3, 1.36371, 0, 0, 0.746799,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35375,-99) , 
1, -0.505987, 1, 0, 0.468762,-99) , 
NN(
0, 
0, 
-1, -0.981869, 0, -1, 0.201129,-99) , 
3, -0.418254, 0, 0, 0.30275,-99) , 
3, 0.207882, 0, 0, 0.516584,-99)    );
  // itree = 539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.794112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243218,-99) , 
0, 0.577088, 1, 0, 0.540148,-99) , 
3, 0.761669, 0, 0, 0.676955,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.223182,-99) , 
3, -0.123397, 0, 0, 0.478911,-99)    );
  // itree = 540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.51004, 1, 1, 0.898327,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415373,-99) , 
0, 0.733197, 1, 0, 0.640716,-99) , 
3, 1.42509, 0, 0, 0.714019,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206648,-99) , 
0, -1.16724, 1, 0, 0.323339,-99) , 
NN(
0, 
0, 
-1, -0.0154624, 1, -1, 0.116581,-99) , 
3, -1.00886, 0, 0, 0.227102,-99) , 
3, -0.123397, 0, 0, 0.511756,-99)    );
  // itree = 541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49191, 1, 1, 0.824107,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402709,-99) , 
0, 0.304336, 1, 0, 0.614626,-99) , 
3, 0.99261, 0, 0, 0.695512,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.170297,-99) , 
3, -0.317226, 0, 0, 0.475526,-99)    );
  // itree = 542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.22503, 1, 1, 0.833975,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429169,-99) , 
0, -0.0814742, 1, 0, 0.570365,-99) , 
3, 1.05334, 0, 0, 0.675161,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.214235,-99) , 
3, -0.28269, 0, 0, 0.505466,-99)    );
  // itree = 543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62719, 1, 1, 0.82412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315699,-99) , 
0, 0.587889, 1, 0, 0.616891,-99) , 
3, 0.847414, 0, 0, 0.712958,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.211694,-99) , 
3, -0.304384, 0, 0, 0.52956,-99)    );
  // itree = 544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73223, 1, 1, 0.886691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309581,-99) , 
0, 1.42891, 1, 0, 0.658979,-99) , 
3, 1.42729, 0, 0, 0.725493,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.178505,-99) , 
3, -0.123397, 0, 0, 0.485254,-99)    );
  // itree = 545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.129695, 1, 1, 0.735412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35768,-99) , 
3, -0.0665555, 0, 0, 0.679967,-99) , 
NN(
0, 
0, 
-1, -1.16064, 0, -1, 0.189054,-99) , 
3, -0.296246, 0, 0, 0.514592,-99)    );
  // itree = 546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0194754, 1, 1, 0.709574,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31868,-99) , 
0, -0.616482, 1, 0, 0.492069,-99) , 
NN(
0, 
0, 
-1, -1.08386, 0, -1, 0.186912,-99) , 
3, -0.351888, 0, 0, 0.295893,-99) , 
3, 0.183842, 0, 0, 0.48785,-99)    );
  // itree = 547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.18165, 1, 1, 0.854281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320391,-99) , 
0, 0.829735, 1, 0, 0.649425,-99) , 
3, 1.20395, 0, 0, 0.733086,-99) , 
NN(
0, 
0, 
-1, -0.719025, 0, -1, 0.233042,-99) , 
3, -0.123397, 0, 0, 0.529185,-99)    );
  // itree = 548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.06493, 0, 1, 0.769039,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32247,-99) , 
0, -0.107474, 1, 0, 0.513784,-99) , 
NN(
0, 
0, 
-1, -1.12215, 0, -1, 0.223967,-99) , 
3, -0.0648505, 0, 0, 0.304602,-99) , 
3, 0.522911, 0, 0, 0.47896,-99)    );
  // itree = 549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.845921, 0, 1, 0.784092,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322334,-99) , 
0, -0.541221, 1, 0, 0.485608,-99) , 
NN(
0, 
0, 
-1, -1.22523, 0, -1, 0.168972,-99) , 
3, -0.373281, 0, 0, 0.268631,-99) , 
3, 0.254861, 0, 0, 0.49637,-99)    );
  // itree = 550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0124576, 1, 1, 0.906239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396751,-99) , 
3, 1.20293, 0, 0, 0.695737,-99) , 
0, 1.07877, 1, 0, 0.781699,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291521,-99) , 
0, -1.21855, 1, 0, 0.389338,-99) , 
NN(
0, 
0, 
-1, -0.234174, 1, -1, 0.121671,-99) , 
3, -1.01611, 0, 0, 0.293933,-99) , 
3, 0.234307, 0, 0, 0.518137,-99)    );
  // itree = 551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.82022, 1, 1, 0.871824,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386658,-99) , 
0, 0.702832, 1, 0, 0.62968,-99) , 
3, 1.18459, 0, 0, 0.738452,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28797,-99) , 
0, -1.44513, 1, 0, 0.370368,-99) , 
NN(
0, 
0, 
-1, -1.6331, 1, -1, 0.152367,-99) , 
3, -1.15126, 0, 0, 0.302519,-99) , 
3, 0.183842, 0, 0, 0.518884,-99)    );
  // itree = 552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.835207,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306201,-99) , 
0, 0.871083, 1, 0, 0.588016,-99) , 
3, 1.10862, 0, 0, 0.691185,-99) , 
NN(
0, 
0, 
-1, -0.787163, 0, -1, 0.211527,-99) , 
3, -0.202496, 0, 0, 0.499638,-99)    );
  // itree = 553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.672338, 1, 1, 0.776212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275701,-99) , 
0, -0.268178, 1, 0, 0.510534,-99) , 
3, 0.385395, 0, 0, 0.692232,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.216327,-99) , 
3, -0.28269, 0, 0, 0.50399,-99)    );
  // itree = 554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.874758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412543,-99) , 
0, 1.07629, 1, 0, 0.702073,-99) , 
3, 1.42509, 0, 0, 0.754338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507184,-99) , 
NN(
0, 
0, 
-1, -1.55041, 0, -1, 0.188686,-99) , 
3, -0.422153, 0, 0, 0.254167,-99) , 
3, -0.123397, 0, 0, 0.551734,-99)    );
  // itree = 555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.253656, 0, 1, 0.701515,-99) , 
NN(
0, 
0, 
-1, -0.507749, 0, -1, 0.227211,-99) , 
3, -0.202496, 0, 0, 0.503034,-99)    );
  // itree = 556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.785602, 1, 1, 0.787109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319306,-99) , 
0, -0.303416, 1, 0, 0.559729,-99) , 
3, 0.387506, 0, 0, 0.715246,-99) , 
NN(
0, 
0, 
-1, -0.825712, 0, -1, 0.199222,-99) , 
3, -0.304384, 0, 0, 0.517822,-99)    );
  // itree = 557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56785, 1, 1, 0.877179,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403817,-99) , 
0, 0.588545, 1, 0, 0.611144,-99) , 
3, 1.00929, 0, 0, 0.747334,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297931,-99) , 
0, -1.40068, 1, 0, 0.37978,-99) , 
NN(
0, 
0, 
-1, -2.77341, 1, -1, 0.10665,-99) , 
3, -1.2031, 0, 0, 0.283974,-99) , 
3, 0.17816, 0, 0, 0.521187,-99)    );
  // itree = 558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73223, 1, 1, 0.876847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426162,-99) , 
0, 0.856209, 1, 0, 0.66298,-99) , 
3, 1.38863, 0, 0, 0.745305,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284553,-99) , 
0, -0.808923, 1, 0, 0.458529,-99) , 
NN(
0, 
0, 
-1, -0.923648, 0, -1, 0.184964,-99) , 
3, -0.391477, 0, 0, 0.284732,-99) , 
3, 0.234307, 0, 0, 0.500226,-99)    );
  // itree = 559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45903, 0, 1, 0.819562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27078,-99) , 
0, 0.0243696, 1, 0, 0.544947,-99) , 
3, 0.541675, 0, 0, 0.702973,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.146675,-99) , 
3, -0.376892, 0, 0, 0.496693,-99)    );
  // itree = 560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.82817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465804,-99) , 
0, 0.0136911, 1, 0, 0.594448,-99) , 
3, 0.653704, 0, 0, 0.732889,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133444,-99) , 
0, -1.18308, 1, 0, 0.304911,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.0851604,-99) , 
3, -1.21431, 0, 0, 0.216643,-99) , 
3, -0.232821, 0, 0, 0.507838,-99)    );
  // itree = 561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43228, 1, 1, 0.871993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33855,-99) , 
0, 0.815395, 1, 0, 0.610317,-99) , 
3, 1.2097, 0, 0, 0.694094,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.180214,-99) , 
3, -0.376892, 0, 0, 0.509333,-99)    );
  // itree = 562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.87392, 1, 1, 0.868146,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382405,-99) , 
0, 0.895922, 1, 0, 0.645206,-99) , 
3, 1.18091, 0, 0, 0.733654,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151521,-99) , 
3, -1.14447, 0, 0, 0.296268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0860194,-99) , 
0, -1.11364, 1, 0, 0.208024,-99) , 
3, -0.160313, 0, 0, 0.497725,-99)    );
  // itree = 563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55567, 0, 1, 0.839723,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432008,-99) , 
0, 0.487598, 1, 0, 0.603909,-99) , 
3, 1.08418, 0, 0, 0.732233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313277,-99) , 
3, -0.0535685, 0, 0, 0.411301,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.116332,-99) , 
3, -0.95623, 0, 0, 0.295077,-99) , 
3, 0.306962, 0, 0, 0.486714,-99)    );
  // itree = 564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51859, 1, 1, 0.802007,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295625,-99) , 
0, 0.256929, 1, 0, 0.55827,-99) , 
3, 0.66689, 0, 0, 0.701961,-99) , 
NN(
0, 
0, 
-1, -1.95612, 0, -1, 0.209481,-99) , 
3, -0.207894, 0, 0, 0.489048,-99)    );
  // itree = 565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.444424, 1, 1, 0.887741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450253,-99) , 
0, 0.852865, 1, 0, 0.709484,-99) , 
3, 1.27542, 0, 0, 0.783747,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353064,-99) , 
1, -0.214834, 1, 0, 0.510803,-99) , 
NN(
0, 
0, 
-1, -1.44076, 1, -1, 0.198282,-99) , 
3, -0.329146, 0, 0, 0.309357,-99) , 
3, 0.301115, 0, 0, 0.513889,-99)    );
  // itree = 566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.844347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327835,-99) , 
0, 0.705896, 1, 0, 0.609606,-99) , 
3, 1.07541, 0, 0, 0.691762,-99) , 
NN(
0, 
0, 
-1, -1.06792, 0, -1, 0.213019,-99) , 
3, -0.304384, 0, 0, 0.540855,-99)    );
  // itree = 567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60422, 1, 1, 0.849414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365258,-99) , 
0, 0.465064, 1, 0, 0.574334,-99) , 
3, 0.815218, 0, 0, 0.696581,-99) , 
NN(
0, 
0, 
-1, -1.1305, 0, -1, 0.19678,-99) , 
3, -0.266059, 0, 0, 0.496181,-99)    );
  // itree = 568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.23271, 1, 1, 0.715091,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196888,-99) , 
0, -1.19072, 1, 0, 0.335449,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.120299,-99) , 
3, -1.03626, 0, 0, 0.23637,-99) , 
3, -0.0698586, 0, 0, 0.497059,-99)    );
  // itree = 569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.37581, 0, 1, 0.792406,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.162774,-99) , 
0, -0.00622424, 1, 0, 0.393811,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.133241,-99) , 
3, -1.20576, 0, 0, 0.322513,-99) , 
3, 0.392653, 0, 0, 0.516981,-99)    );
  // itree = 570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.799527,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351602,-99) , 
0, 0.433791, 1, 0, 0.540155,-99) , 
3, 0.786714, 0, 0, 0.699135,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529391,-99) , 
NN(
0, 
0, 
-1, -1.10867, 0, -1, 0.217413,-99) , 
3, -0.0835608, 0, 0, 0.268977,-99) , 
3, 0.183842, 0, 0, 0.480645,-99)    );
  // itree = 571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.863315,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37326,-99) , 
0, 0.891637, 1, 0, 0.640539,-99) , 
3, 1.30607, 0, 0, 0.70683,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.177145,-99) , 
3, -0.304384, 0, 0, 0.48197,-99)    );
  // itree = 572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.870419,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314872,-99) , 
0, 0.926242, 1, 0, 0.602555,-99) , 
3, 1.2793, 0, 0, 0.679848,-99) , 
NN(
0, 
0, 
-1, -1.79745, 1, -1, 0.127838,-99) , 
3, -0.635491, 0, 0, 0.499949,-99)    );
  // itree = 573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.827805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.919967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457102,-99) , 
1, -0.473945, 1, 0, 0.578999,-99) , 
3, 0.540529, 0, 0, 0.739747,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.218237,-99) , 
3, -0.123397, 0, 0, 0.54029,-99)    );
  // itree = 574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42951, 1, 1, 0.827099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317527,-99) , 
0, 0.46484, 1, 0, 0.59897,-99) , 
3, 0.694518, 0, 0, 0.723365,-99) , 
NN(
0, 
0, 
-1, -0.707631, 0, -1, 0.258785,-99) , 
3, -0.210183, 0, 0, 0.529108,-99)    );
  // itree = 575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2574, 1, 1, 0.87192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376844,-99) , 
0, 0.81731, 1, 0, 0.688456,-99) , 
3, 1.08418, 0, 0, 0.784246,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320015,-99) , 
1, -0.313886, 1, 0, 0.434394,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.130135,-99) , 
3, -0.95623, 0, 0, 0.303941,-99) , 
3, 0.306962, 0, 0, 0.512523,-99)    );
  // itree = 576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.867334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244697,-99) , 
0, 1.05181, 1, 0, 0.618835,-99) , 
3, 1.18368, 0, 0, 0.745047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367305,-99) , 
0, -0.991976, 1, 0, 0.457242,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.181222,-99) , 
3, -0.566981, 0, 0, 0.320355,-99) , 
3, 0.392653, 0, 0, 0.503311,-99)    );
  // itree = 577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.1447, 0, 1, 0.699607,-99) , 
NN(
0, 
0, 
-1, -0.959795, 0, -1, 0.22763,-99) , 
3, -0.210183, 0, 0, 0.521678,-99)    );
  // itree = 578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.721066, 1, 1, 0.898902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358196,-99) , 
3, 1.17808, 0, 0, 0.701858,-99) , 
0, 1.10708, 1, 0, 0.781352,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291495,-99) , 
0, -0.538822, 1, 0, 0.446177,-99) , 
NN(
0, 
0, 
-1, -0.301872, 1, -1, 0.153533,-99) , 
3, -0.704354, 0, 0, 0.306134,-99) , 
3, 0.234307, 0, 0, 0.527728,-99)    );
  // itree = 579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.875549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21308,-99) , 
0, 0.973473, 1, 0, 0.564146,-99) , 
3, 1.0516, 0, 0, 0.685348,-99) , 
NN(
0, 
0, 
-1, -1.02307, 0, -1, 0.232832,-99) , 
3, -0.28269, 0, 0, 0.523844,-99)    );
  // itree = 580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.845763,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388035,-99) , 
0, 0.587889, 1, 0, 0.585609,-99) , 
3, 1.30512, 0, 0, 0.660258,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225922,-99) , 
0, -1.57389, 1, 0, 0.351481,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.0579073,-99) , 
3, -1.32015, 0, 0, 0.240595,-99) , 
3, -0.304384, 0, 0, 0.509977,-99)    );
  // itree = 581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.264998, 0, 1, 0.697728,-99) , 
NN(
0, 
0, 
-1, -1.16979, 0, -1, 0.209331,-99) , 
3, -0.18324, 0, 0, 0.493722,-99)    );
  // itree = 582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.59635, 1, 1, 0.774573,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271703,-99) , 
3, -0.392482, 0, 0, 0.420853,-99) , 
NN(
0, 
0, 
-1, 0.0242633, 1, -1, 0.112339,-99) , 
3, -0.927516, 0, 0, 0.274511,-99) , 
3, 0.17816, 0, 0, 0.503129,-99)    );
  // itree = 583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.819208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243317,-99) , 
0, 1.0116, 1, 0, 0.566096,-99) , 
3, 1.15761, 0, 0, 0.641616,-99) , 
NN(
0, 
0, 
-1, -1.1795, 0, -1, 0.165826,-99) , 
3, -0.420978, 0, 0, 0.473767,-99)    );
  // itree = 584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.879123, 0, 1, 0.913117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400705,-99) , 
3, 1.30899, 0, 0, 0.725895,-99) , 
0, 1.17756, 1, 0, 0.801578,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209212,-99) , 
0, -0.0302755, 1, 0, 0.423055,-99) , 
NN(
0, 
0, 
-1, -1.11701, 0, -1, 0.166773,-99) , 
3, -0.568255, 0, 0, 0.293755,-99) , 
3, 0.392653, 0, 0, 0.498555,-99)    );
  // itree = 585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56224, 1, 1, 0.890715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487621,-99) , 
0, -0.0814742, 1, 0, 0.597649,-99) , 
3, 1.32196, 0, 0, 0.68877,-99) , 
NN(
0, 
0, 
-1, -0.793484, 0, -1, 0.223591,-99) , 
3, -0.207894, 0, 0, 0.513736,-99)    );
  // itree = 586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.879589,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313139,-99) , 
0, 0.9386, 1, 0, 0.650514,-99) , 
3, 1.07875, 0, 0, 0.772186,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648942,-99) , 
NN(
0, 
0, 
-1, -0.919278, 0, -1, 0.189102,-99) , 
3, -0.0140488, 0, 0, 0.258955,-99) , 
3, 0.301115, 0, 0, 0.492431,-99)    );
  // itree = 587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.97029, 1, 1, 0.856638,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819214,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316051,-99) , 
0, 1.10293, 1, 0, 0.641382,-99) , 
3, 1.28127, 0, 0, 0.73838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571058,-99) , 
NN(
0, 
0, 
-1, -1.22009, 0, -1, 0.211564,-99) , 
3, -0.0146681, 0, 0, 0.272197,-99) , 
3, 0.306962, 0, 0, 0.464981,-99)    );
  // itree = 588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04624, 1, 1, 0.824568,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3661,-99) , 
0, 0.0350087, 1, 0, 0.521262,-99) , 
3, 0.817442, 0, 0, 0.636643,-99) , 
NN(
0, 
0, 
-1, -1.59456, 0, -1, 0.125525,-99) , 
3, -0.683307, 0, 0, 0.498547,-99)    );
  // itree = 589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.424689, 0, 1, 0.886109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429546,-99) , 
3, 1.26383, 0, 0, 0.71338,-99) , 
0, 1.10708, 1, 0, 0.796401,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3718,-99) , 
3, -0.0991697, 0, 0, 0.434638,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.189809,-99) , 
3, -0.654599, 0, 0, 0.31353,-99) , 
3, 0.17816, 0, 0, 0.551092,-99)    );
  // itree = 590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58467, 0, 1, 0.856423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397908,-99) , 
0, 0.191795, 1, 0, 0.575308,-99) , 
3, 1.10245, 0, 0, 0.687999,-99) , 
NN(
0, 
0, 
-1, -0.502825, 0, -1, 0.231907,-99) , 
3, -0.207894, 0, 0, 0.497145,-99)    );
  // itree = 591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38009, 0, 1, 0.786938,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320087,-99) , 
0, -0.623262, 1, 0, 0.474738,-99) , 
NN(
0, 
0, 
-1, -1.45281, 0, -1, 0.214481,-99) , 
3, -0.566981, 0, 0, 0.348482,-99) , 
3, 0.392653, 0, 0, 0.543867,-99)    );
  // itree = 592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32521, 0, 1, 0.84831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322913,-99) , 
0, 0.540099, 1, 0, 0.59739,-99) , 
3, 0.985321, 0, 0, 0.716456,-99) , 
NN(
0, 
0, 
-1, -0.71804, 0, -1, 0.190167,-99) , 
3, -0.123397, 0, 0, 0.492207,-99)    );
  // itree = 593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55878, 1, 1, 0.847584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43092,-99) , 
0, 0.240286, 1, 0, 0.595813,-99) , 
3, 1.21373, 0, 0, 0.687842,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201822,-99) , 
0, -1.11109, 1, 0, 0.319337,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.10718,-99) , 
3, -1.01154, 0, 0, 0.220012,-99) , 
3, -0.123397, 0, 0, 0.489441,-99)    );
  // itree = 594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02343, 1, 1, 0.749861,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319118,-99) , 
0, -0.226494, 1, 0, 0.483559,-99) , 
3, 0.248727, 0, 0, 0.666727,-99) , 
NN(
0, 
0, 
-1, -1.19084, 0, -1, 0.161244,-99) , 
3, -0.435158, 0, 0, 0.498389,-99)    );
  // itree = 595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.290205, 0, 1, 0.706054,-99) , 
NN(
0, 
0, 
-1, -0.654428, 0, -1, 0.207131,-99) , 
3, -0.160313, 0, 0, 0.521022,-99)    );
  // itree = 596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.863399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381826,-99) , 
0, 1.0581, 1, 0, 0.682053,-99) , 
3, 1.17884, 0, 0, 0.764464,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265551,-99) , 
0, -0.830649, 1, 0, 0.408369,-99) , 
NN(
0, 
0, 
-1, -1.86037, 1, -1, 0.165645,-99) , 
3, -0.623676, 0, 0, 0.275752,-99) , 
3, 0.178444, 0, 0, 0.487992,-99)    );
  // itree = 597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.76927, 1, 1, 0.893814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378219,-99) , 
0, 1.42471, 1, 0, 0.73366,-99) , 
3, 1.53125, 0, 0, 0.779089,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26556,-99) , 
0, -1.23517, 1, 0, 0.34431,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.111206,-99) , 
3, -0.993962, 0, 0, 0.25474,-99) , 
3, 0.0990605, 0, 0, 0.514106,-99)    );
  // itree = 598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.852447,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451949,-99) , 
0, 0.420974, 1, 0, 0.600497,-99) , 
3, 1.18038, 0, 0, 0.688703,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16413,-99) , 
0, -1.14856, 1, 0, 0.286728,-99) , 
NN(
0, 
0, 
-1, -2.94005, 1, -1, 0.0675749,-99) , 
3, -1.14385, 0, 0, 0.183899,-99) , 
3, -0.160313, 0, 0, 0.476703,-99)    );
  // itree = 599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51579, 0, 1, 0.82624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3298,-99) , 
0, 0.715889, 1, 0, 0.618062,-99) , 
3, 1.0077, 0, 0, 0.720436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330647,-99) , 
0, -1.2877, 1, 0, 0.421088,-99) , 
NN(
0, 
0, 
-1, -2.66817, 1, -1, 0.136785,-99) , 
3, -0.927516, 0, 0, 0.291332,-99) , 
3, 0.17816, 0, 0, 0.498979,-99)    );
  // itree = 600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.71585, 1, 1, 0.881496,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348115,-99) , 
0, 0.9386, 1, 0, 0.66062,-99) , 
3, 1.10578, 0, 0, 0.761776,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319795,-99) , 
1, -0.507862, 1, 0, 0.401119,-99) , 
NN(
0, 
0, 
-1, -2.65144, 1, -1, 0.102145,-99) , 
3, -0.942916, 0, 0, 0.245009,-99) , 
3, 0.116775, 0, 0, 0.496709,-99)    );
  // itree = 601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.806917,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355223,-99) , 
0, 0.238142, 1, 0, 0.576985,-99) , 
3, 0.751987, 0, 0, 0.693415,-99) , 
NN(
0, 
0, 
-1, -1.13931, 0, -1, 0.199174,-99) , 
3, -0.38184, 0, 0, 0.526953,-99)    );
  // itree = 602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72431, 0, 1, 0.868533,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403765,-99) , 
0, 0.957246, 1, 0, 0.625778,-99) , 
3, 1.42729, 0, 0, 0.69791,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.174902,-99) , 
3, -0.123397, 0, 0, 0.471801,-99)    );
  // itree = 603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39044, 0, 1, 0.787482,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207627,-99) , 
0, -0.359879, 1, 0, 0.452718,-99) , 
NN(
0, 
0, 
-1, -1.23983, 0, -1, 0.169978,-99) , 
3, -0.391477, 0, 0, 0.275148,-99) , 
3, 0.234307, 0, 0, 0.508765,-99)    );
  // itree = 604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.861627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443087,-99) , 
0, 0.493857, 1, 0, 0.597603,-99) , 
3, 1.23872, 0, 0, 0.684365,-99) , 
NN(
0, 
0, 
-1, -0.572275, 1, -1, 0.213432,-99) , 
3, -0.299834, 0, 0, 0.515467,-99)    );
  // itree = 605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.855644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3097,-99) , 
0, 0.738333, 1, 0, 0.625054,-99) , 
3, 1.12023, 0, 0, 0.714764,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243782,-99) , 
0, -1.37705, 1, 0, 0.390291,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.0767863,-99) , 
3, -1.07872, 0, 0, 0.248903,-99) , 
3, -0.202496, 0, 0, 0.528564,-99)    );
  // itree = 606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.820305, 0, 1, 0.811668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398653,-99) , 
0, -0.616608, 1, 0, 0.536523,-99) , 
3, 0.244317, 0, 0, 0.741019,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.18437,-99) , 
3, -0.451327, 0, 0, 0.537983,-99)    );
  // itree = 607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0681742, 1, 1, 0.902805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468699,-99) , 
0, 1.33067, 1, 0, 0.692472,-99) , 
3, 1.61356, 0, 0, 0.746457,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37095,-99) , 
1, -0.507862, 1, 0, 0.457687,-99) , 
NN(
0, 
0, 
-1, -0.299856, 1, -1, 0.158175,-99) , 
3, -0.565983, 0, 0, 0.293968,-99) , 
3, 0.228725, 0, 0, 0.506883,-99)    );
  // itree = 608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.877266,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301402,-99) , 
0, 0.857117, 1, 0, 0.579122,-99) , 
3, 1.14627, 0, 0, 0.682276,-99) , 
NN(
0, 
0, 
-1, -0.707631, 0, -1, 0.186528,-99) , 
3, -0.210183, 0, 0, 0.478937,-99)    );
  // itree = 609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.867659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311184,-99) , 
0, 0.84413, 1, 0, 0.64304,-99) , 
3, 1.00058, 0, 0, 0.762022,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26843,-99) , 
0, -1.22538, 1, 0, 0.353996,-99) , 
NN(
0, 
0, 
-1, 0.168813, 1, -1, 0.0991275,-99) , 
3, -1.12137, 0, 0, 0.263408,-99) , 
3, 0.202693, 0, 0, 0.510447,-99)    );
  // itree = 610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.233663, 1, 1, 0.932516,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442352,-99) , 
3, 1.23099, 0, 0, 0.711112,-99) , 
0, 0.709428, 1, 0, 0.775763,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254616,-99) , 
0, -0.831231, 1, 0, 0.371399,-99) , 
NN(
0, 
0, 
-1, -2.93187, 1, -1, 0.0922471,-99) , 
3, -1.21082, 0, 0, 0.295413,-99) , 
3, 0.392653, 0, 0, 0.501902,-99)    );
  // itree = 611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.859305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33494,-99) , 
0, 0.80635, 1, 0, 0.621186,-99) , 
3, 1.2063, 0, 0, 0.706035,-99) , 
NN(
0, 
0, 
-1, -1.0146, 0, -1, 0.244486,-99) , 
3, -0.123397, 0, 0, 0.510411,-99)    );
  // itree = 612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22572, 1, 1, 0.858996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44134,-99) , 
0, 0.778252, 1, 0, 0.700363,-99) , 
3, 1.08085, 0, 0, 0.785517,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253925,-99) , 
0, -0.99941, 1, 0, 0.381582,-99) , 
NN(
0, 
0, 
-1, -0.256745, 1, -1, 0.0949079,-99) , 
3, -1.08906, 0, 0, 0.279209,-99) , 
3, 0.262941, 0, 0, 0.502824,-99)    );
  // itree = 613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.841409,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317164,-99) , 
0, 0.647916, 1, 0, 0.56571,-99) , 
3, 0.919609, 0, 0, 0.685723,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182807,-99) , 
0, -1.17202, 1, 0, 0.327019,-99) , 
NN(
0, 
0, 
-1, -1.59465, 0, -1, 0.120072,-99) , 
3, -0.955363, 0, 0, 0.21943,-99) , 
3, -0.210183, 0, 0, 0.489289,-99)    );
  // itree = 614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.851344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335826,-99) , 
0, 0.906178, 1, 0, 0.63231,-99) , 
3, 1.00821, 0, 0, 0.742216,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629627,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274425,-99) , 
0, -1.2877, 1, 0, 0.364137,-99) , 
NN(
0, 
0, 
-1, -2.5659, 1, -1, 0.0884533,-99) , 
3, -1.11797, 0, 0, 0.26664,-99) , 
3, 0.20809, 0, 0, 0.492326,-99)    );
  // itree = 615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.768458, 1, 1, 0.750844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441203,-99) , 
3, 0.240147, 0, 0, 0.675513,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195789,-99) , 
0, -1.36423, 1, 0, 0.336161,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.0801416,-99) , 
3, -1.07684, 0, 0, 0.20357,-99) , 
3, -0.202496, 0, 0, 0.477299,-99)    );
  // itree = 616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0858844, 1, 1, 0.777752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472355,-99) , 
3, 0.230255, 0, 0, 0.702515,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.127539,-99) , 
0, -1.29706, 1, 0, 0.263248,-99) , 
NN(
0, 
0, 
-1, 0.186452, 1, -1, 0.10253,-99) , 
3, -1.08414, 0, 0, 0.190828,-99) , 
3, -0.207894, 0, 0, 0.489153,-99)    );
  // itree = 617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66577, 0, 1, 0.789614,-99) , 
NN(
0, 
0, 
-1, -0.90301, 0, -1, 0.296647,-99) , 
3, 0.575013, 0, 0, 0.46571,-99)    );
  // itree = 618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.988815, 1, 1, 0.820193,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210413,-99) , 
0, 0.738333, 1, 0, 0.542394,-99) , 
3, 0.84679, 0, 0, 0.670814,-99) , 
NN(
0, 
0, 
-1, -1.82325, 0, -1, 0.233225,-99) , 
3, -0.304384, 0, 0, 0.51426,-99)    );
  // itree = 619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0237419, 1, 1, 0.78983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455978,-99) , 
3, 0.250915, 0, 0, 0.710369,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.159207,-99) , 
3, -0.207894, 0, 0, 0.483536,-99)    );
  // itree = 620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.97633, 1, 1, 0.854847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444896,-99) , 
0, 0.774542, 1, 0, 0.668347,-99) , 
3, 1.01053, 0, 0, 0.768041,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317041,-99) , 
0, -0.551076, 1, 0, 0.492372,-99) , 
NN(
0, 
0, 
-1, -1.0447, 0, -1, 0.159241,-99) , 
3, -0.322974, 0, 0, 0.256502,-99) , 
3, 0.20809, 0, 0, 0.484152,-99)    );
  // itree = 621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.244337, 0, 1, 0.722349,-99) , 
NN(
0, 
0, 
-1, -1.70623, 0, -1, 0.191544,-99) , 
3, -0.210183, 0, 0, 0.50915,-99)    );
  // itree = 622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.856024,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394289,-99) , 
0, 0.789761, 1, 0, 0.661227,-99) , 
3, 1.33185, 0, 0, 0.733208,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225093,-99) , 
0, -1.26677, 1, 0, 0.336229,-99) , 
NN(
0, 
0, 
-1, -2.29692, 1, -1, 0.12594,-99) , 
3, -0.990852, 0, 0, 0.246046,-99) , 
3, 0.0990605, 0, 0, 0.48012,-99)    );
  // itree = 623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08361, 0, 1, 0.793165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293081,-99) , 
0, -0.979963, 1, 0, 0.38427,-99) , 
NN(
0, 
0, 
-1, -1.18817, 0, -1, 0.141834,-99) , 
3, -0.64095, 0, 0, 0.26209,-99) , 
3, 0.306962, 0, 0, 0.493083,-99)    );
  // itree = 624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56785, 1, 1, 0.858643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.903166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487236,-99) , 
0, 0.426521, 1, 0, 0.700655,-99) , 
3, 0.863667, 0, 0, 0.806946,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274419,-99) , 
0, -0.390046, 1, 0, 0.432152,-99) , 
NN(
0, 
0, 
-1, -1.18884, 0, -1, 0.151442,-99) , 
3, -0.508864, 0, 0, 0.275601,-99) , 
3, 0.276895, 0, 0, 0.515125,-99)    );
  // itree = 625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.869, 1, 1, 0.868708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258723,-99) , 
0, 0.9386, 1, 0, 0.584618,-99) , 
3, 1.08443, 0, 0, 0.727332,-99) , 
NN(
0, 
0, 
-1, -1.27151, 0, -1, 0.290043,-99) , 
3, 0.306962, 0, 0, 0.478744,-99)    );
  // itree = 626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1487, 1, 1, 0.875053,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428265,-99) , 
0, 0.815359, 1, 0, 0.673259,-99) , 
3, 1.28085, 0, 0, 0.761741,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337521,-99) , 
1, -0.449907, 1, 0, 0.422277,-99) , 
NN(
0, 
0, 
-1, -0.811425, 1, -1, 0.15439,-99) , 
3, -0.549899, 0, 0, 0.275823,-99) , 
3, 0.262941, 0, 0, 0.49199,-99)    );
  // itree = 627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60683, 0, 1, 0.793369,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294838,-99) , 
0, -0.363896, 1, 0, 0.435609,-99) , 
NN(
0, 
0, 
-1, -1.37929, 1, -1, 0.159663,-99) , 
3, -0.311873, 0, 0, 0.248226,-99) , 
3, 0.223327, 0, 0, 0.488715,-99)    );
  // itree = 628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.099103, 1, 1, 0.928057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497953,-99) , 
3, 1.21268, 0, 0, 0.705379,-99) , 
0, 0.709428, 1, 0, 0.763072,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327588,-99) , 
0, -0.808923, 1, 0, 0.408669,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.14512,-99) , 
3, -0.886371, 0, 0, 0.318855,-99) , 
3, 0.392653, 0, 0, 0.494651,-99)    );
  // itree = 629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30438, 0, 1, 0.796212,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353539,-99) , 
0, 0.224393, 1, 0, 0.564516,-99) , 
3, 0.767226, 0, 0, 0.695405,-99) , 
NN(
0, 
0, 
-1, -0.422153, 0, -1, 0.228369,-99) , 
3, -0.123397, 0, 0, 0.491122,-99)    );
  // itree = 630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50419, 1, 1, 0.874623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360923,-99) , 
0, 0.809818, 1, 0, 0.634661,-99) , 
3, 1.14517, 0, 0, 0.719541,-99) , 
NN(
0, 
0, 
-1, -1.70225, 0, -1, 0.247045,-99) , 
3, -0.210183, 0, 0, 0.52735,-99)    );
  // itree = 631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.371143, 1, 1, 0.883136,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318738,-99) , 
0, 0.919735, 1, 0, 0.604818,-99) , 
3, 1.30662, 0, 0, 0.690133,-99) , 
NN(
0, 
0, 
-1, -1.28655, 0, -1, 0.211035,-99) , 
3, -0.304384, 0, 0, 0.514614,-99)    );
  // itree = 632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89241, 1, 1, 0.89625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474022,-99) , 
0, 0.856209, 1, 0, 0.674486,-99) , 
3, 1.37848, 0, 0, 0.757559,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549081,-99) , 
NN(
0, 
0, 
-1, -1.45902, 1, -1, 0.215954,-99) , 
3, -0.0974033, 0, 0, 0.263881,-99) , 
3, 0.178444, 0, 0, 0.507749,-99)    );
  // itree = 633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.64623, 0, 1, 0.725109,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.179586,-99) , 
3, -0.123397, 0, 0, 0.470047,-99)    );
  // itree = 634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.15461, 1, 1, 0.875864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352656,-99) , 
0, 0.781704, 1, 0, 0.61734,-99) , 
3, 1.31726, 0, 0, 0.708587,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284127,-99) , 
1, -0.384038, 1, 0, 0.37916,-99) , 
NN(
0, 
0, 
-1, -2.57892, 1, -1, 0.106691,-99) , 
3, -0.993962, 0, 0, 0.255489,-99) , 
3, 0.093663, 0, 0, 0.477591,-99)    );
  // itree = 635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21456, 1, 1, 0.86285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36406,-99) , 
0, 0.424748, 1, 0, 0.622141,-99) , 
3, 0.985321, 0, 0, 0.732906,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.216503,-99) , 
3, -0.123397, 0, 0, 0.52564,-99)    );
  // itree = 636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.872492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838908,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353444,-99) , 
0, 1.0581, 1, 0, 0.705911,-99) , 
3, 1.21436, 0, 0, 0.775214,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365356,-99) , 
3, -0.0523031, 0, 0, 0.466383,-99) , 
NN(
0, 
0, 
-1, -1.37929, 1, -1, 0.15463,-99) , 
3, -0.376357, 0, 0, 0.254831,-99) , 
3, 0.17816, 0, 0, 0.489573,-99)    );
  // itree = 637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.874594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378002,-99) , 
0, 0.943047, 1, 0, 0.668655,-99) , 
3, 1.12671, 0, 0, 0.763433,-99) , 
NN(
0, 
0, 
-1, -0.447144, 0, -1, 0.221137,-99) , 
3, 0.0990605, 0, 0, 0.492239,-99)    );
  // itree = 638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.851141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199942,-99) , 
0, 0.857117, 1, 0, 0.638982,-99) , 
3, 0.98281, 0, 0, 0.737574,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.200716,-99) , 
3, -0.123397, 0, 0, 0.506203,-99)    );
  // itree = 639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.24745, 1, 1, 0.839717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355014,-99) , 
0, 0.676493, 1, 0, 0.611103,-99) , 
3, 1.05197, 0, 0, 0.697163,-99) , 
NN(
0, 
0, 
-1, -0.545342, 0, -1, 0.215368,-99) , 
3, -0.25059, 0, 0, 0.490581,-99)    );
  // itree = 640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.182913, 1, 1, 0.924158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425378,-99) , 
3, 0.817168, 0, 0, 0.752982,-99) , 
0, 0.256001, 1, 0, 0.7942,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312391,-99) , 
0, -0.991976, 1, 0, 0.456395,-99) , 
NN(
0, 
0, 
-1, -1.76953, 1, -1, 0.157801,-99) , 
3, -0.730163, 0, 0, 0.297331,-99) , 
3, 0.205401, 0, 0, 0.519911,-99)    );
  // itree = 641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.870064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431427,-99) , 
0, 0.611127, 1, 0, 0.677365,-99) , 
3, 1.08473, 0, 0, 0.781671,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328248,-99) , 
0, -1.2877, 1, 0, 0.425564,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.0960825,-99) , 
3, -0.966565, 0, 0, 0.295695,-99) , 
3, 0.301115, 0, 0, 0.503237,-99)    );
  // itree = 642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.62742, 0, 1, 0.722504,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267816,-99) , 
0, -1.40068, 1, 0, 0.376838,-99) , 
NN(
0, 
0, 
-1, -2.57892, 1, -1, 0.125571,-99) , 
3, -0.954755, 0, 0, 0.268664,-99) , 
3, 0.17816, 0, 0, 0.486476,-99)    );
  // itree = 643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.751659,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303741,-99) , 
0, -0.538822, 1, 0, 0.426256,-99) , 
NN(
0, 
0, 
-1, -0.835334, 1, -1, 0.14535,-99) , 
3, -0.549899, 0, 0, 0.270607,-99) , 
3, 0.262941, 0, 0, 0.496463,-99)    );
  // itree = 644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38459, 0, 1, 0.836381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242441,-99) , 
0, 0.897575, 1, 0, 0.555519,-99) , 
3, 1.06691, 0, 0, 0.650231,-99) , 
NN(
0, 
0, 
-1, -1.74145, 1, -1, 0.173849,-99) , 
3, -0.5926, 0, 0, 0.507532,-99)    );
  // itree = 645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.819869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354237,-99) , 
0, 0.281825, 1, 0, 0.568801,-99) , 
3, 0.772751, 0, 0, 0.707919,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.219066,-99) , 
3, -0.123397, 0, 0, 0.502429,-99)    );
  // itree = 646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2995, 0, 1, 0.798915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300415,-99) , 
0, -0.113844, 1, 0, 0.516564,-99) , 
3, 0.540529, 0, 0, 0.702347,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.215137,-99) , 
3, -0.123397, 0, 0, 0.497254,-99)    );
  // itree = 647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54616, 1, 1, 0.859855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323799,-99) , 
0, 1.2021, 1, 0, 0.670583,-99) , 
3, 1.17884, 0, 0, 0.752858,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371076,-99) , 
0, -0.699241, 1, 0, 0.501399,-99) , 
NN(
0, 
0, 
-1, -1.09768, 0, -1, 0.185447,-99) , 
3, -0.36326, 0, 0, 0.283511,-99) , 
3, 0.178444, 0, 0, 0.501846,-99)    );
  // itree = 648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0500582, 1, 1, 0.88072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425796,-99) , 
0, 0.900482, 1, 0, 0.624549,-99) , 
3, 1.42073, 0, 0, 0.704545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540291,-99) , 
NN(
0, 
0, 
-1, -1.15615, 0, -1, 0.220872,-99) , 
3, -0.100777, 0, 0, 0.269725,-99) , 
3, 0.17816, 0, 0, 0.477882,-99)    );
  // itree = 649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.812183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353531,-99) , 
0, 0.224393, 1, 0, 0.573704,-99) , 
3, 0.761669, 0, 0, 0.705487,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173593,-99) , 
0, -1.26906, 1, 0, 0.305926,-99) , 
NN(
0, 
0, 
-1, -0.449808, 0, -1, 0.112632,-99) , 
3, -1.00886, 0, 0, 0.234075,-99) , 
3, -0.123397, 0, 0, 0.497618,-99)    );
  // itree = 650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.319582, 0, 1, 0.886642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3881,-99) , 
3, 1.04128, 0, 0, 0.6939,-99) , 
0, 0.709428, 1, 0, 0.748109,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205726,-99) , 
0, -0.143589, 1, 0, 0.432839,-99) , 
NN(
0, 
0, 
-1, -2.64737, 1, -1, 0.161594,-99) , 
3, -0.887583, 0, 0, 0.309958,-99) , 
3, 0.392653, 0, 0, 0.502921,-99)    );
  // itree = 651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.877477,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343845,-99) , 
0, 1.20983, 1, 0, 0.675158,-99) , 
3, 1.28085, 0, 0, 0.754585,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164615,-99) , 
0, -0.153185, 1, 0, 0.400571,-99) , 
NN(
0, 
0, 
-1, -1.49162, 0, -1, 0.116547,-99) , 
3, -0.818721, 0, 0, 0.281334,-99) , 
3, 0.262941, 0, 0, 0.483485,-99)    );
  // itree = 652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59159, 1, 1, 0.873761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36071,-99) , 
0, 0.980885, 1, 0, 0.660308,-99) , 
3, 1.19685, 0, 0, 0.758485,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268966,-99) , 
1, -0.0239577, 1, 0, 0.437635,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.169623,-99) , 
3, -0.392596, 0, 0, 0.267845,-99) , 
3, 0.234307, 0, 0, 0.493282,-99)    );
  // itree = 653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0939, 1, 1, 0.803147,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466089,-99) , 
1, -0.473945, 1, 0, 0.578334,-99) , 
3, 0.713004, 0, 0, 0.701083,-99) , 
NN(
0, 
0, 
-1, -0.923764, 0, -1, 0.199129,-99) , 
3, -0.18324, 0, 0, 0.493677,-99)    );
  // itree = 654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.235551, 0, 1, 0.755782,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195993,-99) , 
0, -1.44209, 1, 0, 0.353649,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.0974018,-99) , 
3, -1.07815, 0, 0, 0.233098,-99) , 
3, -0.202496, 0, 0, 0.53258,-99)    );
  // itree = 655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81296, 0, 1, 0.801973,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28755,-99) , 
0, -0.0356935, 1, 0, 0.540504,-99) , 
3, 0.526823, 0, 0, 0.683981,-99) , 
NN(
0, 
0, 
-1, -1.67181, 0, -1, 0.1637,-99) , 
3, -0.38184, 0, 0, 0.50592,-99)    );
  // itree = 656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52676, 0, 1, 0.849455,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323895,-99) , 
0, 0.8372, 1, 0, 0.606337,-99) , 
3, 1.20395, 0, 0, 0.697921,-99) , 
NN(
0, 
0, 
-1, -0.71804, 0, -1, 0.213455,-99) , 
3, -0.123397, 0, 0, 0.494515,-99)    );
  // itree = 657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44669, 0, 1, 0.816872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486818,-99) , 
3, 0.55921, 0, 0, 0.734674,-99) , 
NN(
0, 
0, 
-1, -0.367314, 0, -1, 0.243171,-99) , 
3, 0.165162, 0, 0, 0.459455,-99)    );
  // itree = 658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.817174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316335,-99) , 
0, 0.12976, 1, 0, 0.511801,-99) , 
3, 0.662988, 0, 0, 0.700948,-99) , 
NN(
0, 
0, 
-1, -0.505739, 0, -1, 0.20707,-99) , 
3, 0.0509667, 0, 0, 0.465498,-99)    );
  // itree = 659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.880038,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457841,-99) , 
0, 0.56721, 1, 0, 0.678039,-99) , 
3, 1.20395, 0, 0, 0.749451,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.222553,-99) , 
3, -0.123397, 0, 0, 0.535541,-99)    );
  // itree = 660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.853413,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35571,-99) , 
0, 1.16519, 1, 0, 0.622809,-99) , 
3, 1.26771, 0, 0, 0.698114,-99) , 
NN(
0, 
0, 
-1, -1.02307, 0, -1, 0.230376,-99) , 
3, -0.287638, 0, 0, 0.522931,-99)    );
  // itree = 661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.273914, 1, 1, 0.89817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472961,-99) , 
3, 1.37805, 0, 0, 0.691153,-99) , 
0, 0.768458, 1, 0, 0.75315,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32586,-99) , 
1, -0.214834, 1, 0, 0.433453,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.1745,-99) , 
3, -0.329808, 0, 0, 0.261614,-99) , 
3, 0.301115, 0, 0, 0.462459,-99)    );
  // itree = 662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0194754, 1, 1, 0.745902,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466594,-99) , 
3, -0.0434957, 1, 0, 0.48768,-99) , 
NN(
0, 
0, 
-1, -1.53574, 1, -1, 0.191898,-99) , 
3, -0.38455, 0, 0, 0.282989,-99) , 
3, 0.17816, 0, 0, 0.503715,-99)    );
  // itree = 663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.884411, 1, 1, 0.787576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271642,-99) , 
0, 0.465064, 1, 0, 0.515892,-99) , 
3, 0.845703, 0, 0, 0.639458,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219143,-99) , 
0, -1.19072, 1, 0, 0.362503,-99) , 
NN(
0, 
0, 
-1, -2.58105, 1, -1, 0.123982,-99) , 
3, -1.06543, 0, 0, 0.245434,-99) , 
3, -0.304384, 0, 0, 0.483651,-99)    );
  // itree = 664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63751, 1, 1, 0.836989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388732,-99) , 
0, 0.465064, 1, 0, 0.568343,-99) , 
3, 0.979337, 0, 0, 0.667627,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.200019,-99) , 
3, -0.38184, 0, 0, 0.494784,-99)    );
  // itree = 665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.838233,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392879,-99) , 
0, 0.781704, 1, 0, 0.627779,-99) , 
3, 1.22296, 0, 0, 0.69466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526952,-99) , 
NN(
0, 
0, 
-1, -1.55041, 0, -1, 0.192496,-99) , 
3, -0.422153, 0, 0, 0.257996,-99) , 
3, -0.123397, 0, 0, 0.508724,-99)    );
  // itree = 666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.931802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411601,-99) , 
3, 0.748034, 0, 0, 0.700124,-99) , 
0, 0.237393, 1, 0, 0.749577,-99) , 
NN(
0, 
0, 
-1, -0.394698, 0, -1, 0.291092,-99) , 
3, 0.135748, 0, 0, 0.521691,-99)    );
  // itree = 667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.860109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356163,-99) , 
0, 0.905235, 1, 0, 0.654445,-99) , 
3, 1.21586, 0, 0, 0.747685,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306931,-99) , 
0, -0.646644, 1, 0, 0.443133,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.195945,-99) , 
3, -0.651936, 0, 0, 0.306186,-99) , 
3, 0.17816, 0, 0, 0.499383,-99)    );
  // itree = 668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15389, 1, 1, 0.825305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261143,-99) , 
0, -0.0316589, 1, 0, 0.527431,-99) , 
3, 0.528486, 0, 0, 0.71728,-99) , 
NN(
0, 
0, 
-1, -1.61631, 0, -1, 0.204938,-99) , 
3, -0.140969, 0, 0, 0.50271,-99)    );
  // itree = 669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85326, 1, 1, 0.878824,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359269,-99) , 
0, 1.11302, 1, 0, 0.614331,-99) , 
3, 1.17923, 0, 0, 0.752905,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263638,-99) , 
0, -0.312245, 1, 0, 0.449481,-99) , 
NN(
0, 
0, 
-1, -0.234174, 1, -1, 0.158461,-99) , 
3, -0.887583, 0, 0, 0.339463,-99) , 
3, 0.392653, 0, 0, 0.520281,-99)    );
  // itree = 670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.850462,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48382,-99) , 
0, -0.065981, 1, 0, 0.589998,-99) , 
3, 1.2263, 0, 0, 0.670903,-99) , 
NN(
0, 
0, 
-1, -1.15954, 0, -1, 0.194636,-99) , 
3, -0.283698, 0, 0, 0.481428,-99)    );
  // itree = 671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.851639,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409357,-99) , 
0, -0.0341262, 1, 0, 0.584123,-99) , 
3, 0.985393, 0, 0, 0.692959,-99) , 
NN(
0, 
0, 
-1, -1.45017, 1, -1, 0.222387,-99) , 
3, -0.303436, 0, 0, 0.527677,-99)    );
  // itree = 672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27925, 1, 1, 0.85084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377092,-99) , 
0, 0.262307, 1, 0, 0.57268,-99) , 
3, 1.12051, 0, 0, 0.668811,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142632,-99) , 
0, -1.24543, 1, 0, 0.279352,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.108631,-99) , 
3, -1.07815, 0, 0, 0.200008,-99) , 
3, -0.202496, 0, 0, 0.46908,-99)    );
  // itree = 673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1219, 1, 1, 0.8513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329613,-99) , 
0, 0.430037, 1, 0, 0.57404,-99) , 
3, 0.688605, 0, 0, 0.71031,-99) , 
NN(
0, 
0, 
-1, -2.57958, 1, -1, 0.164042,-99) , 
3, -0.759664, 0, 0, 0.566926,-99)    );
  // itree = 674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.816926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209704,-99) , 
0, 0.325684, 1, 0, 0.564103,-99) , 
3, 0.690071, 0, 0, 0.680959,-99) , 
NN(
0, 
0, 
-1, -1.46184, 1, -1, 0.180265,-99) , 
3, -0.435158, 0, 0, 0.502015,-99)    );
  // itree = 675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02346, 1, 1, 0.823327,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256612,-99) , 
0, 0.465064, 1, 0, 0.521203,-99) , 
3, 0.845703, 0, 0, 0.659066,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.207778,-99) , 
3, -0.304384, 0, 0, 0.495635,-99)    );
  // itree = 676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78381, 0, 1, 0.874253,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347676,-99) , 
0, 0.429002, 1, 0, 0.572478,-99) , 
3, 0.995403, 0, 0, 0.692488,-99) , 
NN(
0, 
0, 
-1, -1.05814, 0, -1, 0.20223,-99) , 
3, -0.326776, 0, 0, 0.515295,-99)    );
  // itree = 677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.71585, 1, 1, 0.854478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384938,-99) , 
0, 0.696072, 1, 0, 0.589444,-99) , 
3, 1.0102, 0, 0, 0.728646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305272,-99) , 
1, -0.47001, 1, 0, 0.40219,-99) , 
NN(
0, 
0, 
-1, -1.76953, 1, -1, 0.134457,-99) , 
3, -0.702968, 0, 0, 0.259392,-99) , 
3, 0.234307, 0, 0, 0.48091,-99)    );
  // itree = 678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.871495,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331552,-99) , 
0, 1.20619, 1, 0, 0.638331,-99) , 
3, 1.42509, 0, 0, 0.704029,-99) , 
NN(
0, 
0, 
-1, -0.725424, 0, -1, 0.201852,-99) , 
3, -0.123397, 0, 0, 0.499151,-99)    );
  // itree = 679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.882187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415936,-99) , 
0, 0.540099, 1, 0, 0.625941,-99) , 
3, 1.21925, 0, 0, 0.718451,-99) , 
NN(
0, 
0, 
-1, -0.592373, 0, -1, 0.203011,-99) , 
3, -0.10679, 0, 0, 0.482165,-99)    );
  // itree = 680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.861176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409821,-99) , 
0, 0.298494, 1, 0, 0.601424,-99) , 
3, 1.02381, 0, 0, 0.712005,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254626,-99) , 
0, -1.30478, 1, 0, 0.396465,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.10409,-99) , 
3, -1.03626, 0, 0, 0.265894,-99) , 
3, -0.0698586, 0, 0, 0.519183,-99)    );
  // itree = 681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40435, 1, 1, 0.843742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319551,-99) , 
0, 0.696072, 1, 0, 0.596777,-99) , 
3, 1.02272, 0, 0, 0.721693,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244421,-99) , 
0, -0.745016, 1, 0, 0.412428,-99) , 
NN(
0, 
0, 
-1, -0.78998, 1, -1, 0.151741,-99) , 
3, -0.565983, 0, 0, 0.259454,-99) , 
3, 0.228725, 0, 0, 0.476465,-99)    );
  // itree = 682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89821, 0, 1, 0.849818,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456514,-99) , 
0, 0.00828801, 1, 0, 0.618083,-99) , 
3, 1.07736, 0, 0, 0.7176,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.206786,-99) , 
3, -0.304384, 0, 0, 0.513101,-99)    );
  // itree = 683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0462137, 1, 1, 0.85571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451153,-99) , 
0, -0.0920449, 1, 0, 0.593644,-99) , 
3, 1.07643, 0, 0, 0.699285,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.219675,-99) , 
3, -0.304384, 0, 0, 0.519661,-99)    );
  // itree = 684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54644, 1, 1, 0.790998,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215524,-99) , 
0, 0.12455, 1, 0, 0.53068,-99) , 
3, 0.525662, 0, 0, 0.685606,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.172043,-99) , 
3, -0.38184, 0, 0, 0.490536,-99)    );
  // itree = 685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.874077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821433,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392306,-99) , 
0, 0.852865, 1, 0, 0.645578,-99) , 
3, 1.38531, 0, 0, 0.724049,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31344,-99) , 
0, -1.4496, 1, 0, 0.40998,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0967819,-99) , 
3, -1.14976, 0, 0, 0.304427,-99) , 
3, 0.183842, 0, 0, 0.507941,-99)    );
  // itree = 686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.957274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451649,-99) , 
3, 1.0105, 0, 0, 0.689129,-99) , 
0, 0.256001, 1, 0, 0.742634,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275688,-99) , 
0, -0.765399, 1, 0, 0.382838,-99) , 
NN(
0, 
0, 
-1, -1.80475, 1, -1, 0.188642,-99) , 
3, -0.651936, 0, 0, 0.278241,-99) , 
3, 0.17816, 0, 0, 0.495041,-99)    );
  // itree = 687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.839024,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250062,-99) , 
0, 1.0116, 1, 0, 0.612268,-99) , 
3, 1.17289, 0, 0, 0.692954,-99) , 
NN(
0, 
0, 
-1, -0.941292, 0, -1, 0.215674,-99) , 
3, -0.18324, 0, 0, 0.498797,-99)    );
  // itree = 688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84726, 0, 1, 0.852432,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31944,-99) , 
0, 0.970218, 1, 0, 0.591567,-99) , 
3, 1.21485, 0, 0, 0.686951,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.207795,-99) , 
3, -0.123397, 0, 0, 0.474216,-99)    );
  // itree = 689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19067, 1, 1, 0.874082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360563,-99) , 
0, 1.16852, 1, 0, 0.627053,-99) , 
3, 1.334, 0, 0, 0.71478,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288719,-99) , 
0, -1.24008, 1, 0, 0.356308,-99) , 
NN(
0, 
0, 
-1, -2.58105, 1, -1, 0.127486,-99) , 
3, -0.993962, 0, 0, 0.257988,-99) , 
3, 0.093663, 0, 0, 0.492294,-99)    );
  // itree = 690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.744, 0, 1, 0.831928,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376352,-99) , 
0, 0.247725, 1, 0, 0.60486,-99) , 
3, 0.69117, 0, 0, 0.761934,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223474,-99) , 
0, -0.85877, 1, 0, 0.38709,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.138763,-99) , 
3, -0.959342, 0, 0, 0.293959,-99) , 
3, 0.301115, 0, 0, 0.499695,-99)    );
  // itree = 691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.848308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46932,-99) , 
0, 0.767381, 1, 0, 0.660987,-99) , 
3, 1.27353, 0, 0, 0.730444,-99) , 
NN(
0, 
0, 
-1, -0.960097, 0, -1, 0.297825,-99) , 
3, 0.301115, 0, 0, 0.499041,-99)    );
  // itree = 692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.848099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371301,-99) , 
0, 0.224393, 1, 0, 0.564748,-99) , 
3, 0.764338, 0, 0, 0.723949,-99) , 
NN(
0, 
0, 
-1, -0.767649, 1, -1, 0.246442,-99) , 
3, -0.123397, 0, 0, 0.529241,-99)    );
  // itree = 693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82081, 1, 1, 0.883117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264157,-99) , 
0, 1.01899, 1, 0, 0.622225,-99) , 
3, 1.27767, 0, 0, 0.745402,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321958,-99) , 
1, -0.473945, 1, 0, 0.452494,-99) , 
NN(
0, 
0, 
-1, -0.0128219, 1, -1, 0.180219,-99) , 
3, -0.325669, 0, 0, 0.27286,-99) , 
3, 0.306962, 0, 0, 0.47919,-99)    );
  // itree = 694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11481, 0, 1, 0.767652,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266562,-99) , 
0, -1.07324, 1, 0, 0.390409,-99) , 
NN(
0, 
0, 
-1, -2.57892, 1, -1, 0.101111,-99) , 
3, -0.997451, 0, 0, 0.268428,-99) , 
3, 0.093663, 0, 0, 0.508397,-99)    );
  // itree = 695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.30237, 1, 1, 0.830161,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2791,-99) , 
0, 0.871083, 1, 0, 0.597638,-99) , 
3, 1.08912, 0, 0, 0.672152,-99) , 
NN(
0, 
0, 
-1, -0.975983, 0, -1, 0.226163,-99) , 
3, -0.232821, 0, 0, 0.500503,-99)    );
  // itree = 696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08742, 1, 1, 0.832195,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357516,-99) , 
0, 0.557297, 1, 0, 0.609478,-99) , 
3, 0.93027, 0, 0, 0.740472,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224224,-99) , 
0, -0.838335, 1, 0, 0.360802,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.0748629,-99) , 
3, -1.18731, 0, 0, 0.275235,-99) , 
3, 0.135748, 0, 0, 0.494642,-99)    );
  // itree = 697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6859, 0, 1, 0.859878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408741,-99) , 
0, 0.871083, 1, 0, 0.617358,-99) , 
3, 1.20885, 0, 0, 0.710865,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192665,-99) , 
0, -1.17488, 1, 0, 0.345984,-99) , 
NN(
0, 
0, 
-1, -0.198454, 1, -1, 0.110073,-99) , 
3, -1.00886, 0, 0, 0.245833,-99) , 
3, -0.123397, 0, 0, 0.513853,-99)    );
  // itree = 698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4999, 1, 1, 0.896362,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.943745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480353,-99) , 
0, 0.265001, 1, 0, 0.644725,-99) , 
3, 1.07833, 0, 0, 0.777945,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335653,-99) , 
0, -0.949142, 1, 0, 0.47971,-99) , 
NN(
0, 
0, 
-1, 0.568694, 1, -1, 0.155854,-99) , 
3, -0.548378, 0, 0, 0.301844,-99) , 
3, 0.262941, 0, 0, 0.509287,-99)    );
  // itree = 699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35927, 1, 1, 0.800862,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345865,-99) , 
0, -0.0188443, 1, 0, 0.500568,-99) , 
3, 0.766193, 0, 0, 0.64987,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.192221,-99) , 
3, -0.376892, 0, 0, 0.482788,-99)    );
  // itree = 700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.845541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217517,-99) , 
0, 0.704883, 1, 0, 0.629036,-99) , 
3, 0.999126, 0, 0, 0.72292,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.222234,-99) , 
3, -0.123397, 0, 0, 0.50328,-99)    );
  // itree = 701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22962, 0, 1, 0.75463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427421,-99) , 
3, 0.240147, 0, 0, 0.674761,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.192878,-99) , 
3, -0.202496, 0, 0, 0.47828,-99)    );
  // itree = 702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.849956,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454461,-99) , 
0, 0.609608, 1, 0, 0.689236,-99) , 
3, 0.989907, 0, 0, 0.777513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506954,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.166582,-99) , 
3, -0.351888, 0, 0, 0.25678,-99) , 
3, 0.183842, 0, 0, 0.517369,-99)    );
  // itree = 703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04108, 1, 1, 0.809761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204237,-99) , 
0, 0.429347, 1, 0, 0.544658,-99) , 
3, 0.668127, 0, 0, 0.690247,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.170988,-99) , 
3, -0.207894, 0, 0, 0.486415,-99)    );
  // itree = 704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37749, 0, 1, 0.870681,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413585,-99) , 
0, 0.459356, 1, 0, 0.61745,-99) , 
3, 1.05462, 0, 0, 0.711764,-99) , 
NN(
0, 
0, 
-1, -1.03971, 0, -1, 0.2178,-99) , 
3, -0.287638, 0, 0, 0.539339,-99)    );
  // itree = 705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.815158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283502,-99) , 
0, 0.245926, 1, 0, 0.564373,-99) , 
3, 0.672086, 0, 0, 0.704583,-99) , 
NN(
0, 
0, 
-1, -1.3022, 1, -1, 0.178497,-99) , 
3, -0.202496, 0, 0, 0.482879,-99)    );
  // itree = 706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.502524, 1, 1, 0.926338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356267,-99) , 
3, 1.007, 0, 0, 0.701846,-99) , 
0, 0.74751, 1, 0, 0.769581,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194014,-99) , 
0, -0.188624, 1, 0, 0.419005,-99) , 
NN(
0, 
0, 
-1, -1.21634, 0, -1, 0.149742,-99) , 
3, -0.549926, 0, 0, 0.26698,-99) , 
3, 0.228801, 0, 0, 0.48639,-99)    );
  // itree = 707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43501, 1, 1, 0.848661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435872,-99) , 
0, 0.25863, 1, 0, 0.622126,-99) , 
3, 1.05334, 0, 0, 0.710794,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.221274,-99) , 
3, -0.28269, 0, 0, 0.513654,-99)    );
  // itree = 708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56224, 1, 1, 0.870343,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46595,-99) , 
0, 1.01899, 1, 0, 0.692979,-99) , 
3, 1.22432, 0, 0, 0.795823,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263386,-99) , 
0, 0.373731, 1, 0, 0.487558,-99) , 
NN(
0, 
0, 
-1, -2.3633, 1, -1, 0.17961,-99) , 
3, -0.837919, 0, 0, 0.385069,-99) , 
3, 0.660704, 0, 0, 0.534687,-99)    );
  // itree = 709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66041, 1, 1, 0.785869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284822,-99) , 
0, -0.2316, 1, 0, 0.472117,-99) , 
3, 0.303142, 0, 0, 0.678617,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.169761,-99) , 
3, -0.376892, 0, 0, 0.490922,-99)    );
  // itree = 710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.778718,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300189,-99) , 
0, -0.538822, 1, 0, 0.439623,-99) , 
NN(
0, 
0, 
-1, -1.46184, 1, -1, 0.202096,-99) , 
3, -0.556192, 0, 0, 0.300092,-99) , 
3, 0.262941, 0, 0, 0.5251,-99)    );
  // itree = 711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69107, 0, 1, 0.854153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39727,-99) , 
0, 0.84413, 1, 0, 0.65683,-99) , 
3, 1.21404, 0, 0, 0.737089,-99) , 
NN(
0, 
0, 
-1, -0.379167, 0, -1, 0.257441,-99) , 
3, 0.17816, 0, 0, 0.505955,-99)    );
  // itree = 712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.823402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414152,-99) , 
0, 0.0136911, 1, 0, 0.56677,-99) , 
3, 0.666353, 0, 0, 0.716153,-99) , 
NN(
0, 
0, 
-1, -0.546181, 1, -1, 0.199776,-99) , 
3, -0.207894, 0, 0, 0.514327,-99)    );
  // itree = 713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.868125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455448,-99) , 
0, 0.459356, 1, 0, 0.626588,-99) , 
3, 1.20395, 0, 0, 0.716649,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.192756,-99) , 
3, -0.123397, 0, 0, 0.486311,-99)    );
  // itree = 714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47292, 1, 1, 0.83256,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377156,-99) , 
0, -0.231503, 1, 0, 0.546773,-99) , 
3, 0.540529, 0, 0, 0.723454,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177601,-99) , 
0, -1.13933, 1, 0, 0.34115,-99) , 
NN(
0, 
0, 
-1, -2.64589, 1, -1, 0.109194,-99) , 
3, -1.00886, 0, 0, 0.230466,-99) , 
3, -0.123397, 0, 0, 0.518186,-99)    );
  // itree = 715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.819449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220842,-99) , 
0, 0.781704, 1, 0, 0.574429,-99) , 
3, 0.90304, 0, 0, 0.677855,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.21345,-99) , 
3, -0.202496, 0, 0, 0.485715,-99)    );
  // itree = 716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.3922, 0, 1, 0.814266,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303712,-99) , 
0, -0.616482, 1, 0, 0.458947,-99) , 
NN(
0, 
0, 
-1, -0.975023, 0, -1, 0.176486,-99) , 
3, -0.386214, 0, 0, 0.283587,-99) , 
3, 0.238103, 0, 0, 0.528163,-99)    );
  // itree = 717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.32892, 1, 1, 0.880069,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271518,-99) , 
0, 0.774753, 1, 0, 0.628882,-99) , 
3, 0.99222, 0, 0, 0.731572,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.190948,-99) , 
3, -0.376892, 0, 0, 0.504847,-99)    );
  // itree = 718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72431, 0, 1, 0.853444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422631,-99) , 
0, 0.854666, 1, 0, 0.648919,-99) , 
3, 1.42967, 0, 0, 0.708964,-99) , 
NN(
0, 
0, 
-1, -0.726129, 0, -1, 0.202282,-99) , 
3, -0.123397, 0, 0, 0.509833,-99)    );
  // itree = 719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.303389, 1, 1, 0.846288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282567,-99) , 
3, 1.06589, 0, 0, 0.606829,-99) , 
0, 0.838945, 1, 0, 0.700369,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20502,-99) , 
0, -1.01188, 1, 0, 0.340572,-99) , 
NN(
0, 
0, 
-1, -0.291975, 1, -1, 0.0971787,-99) , 
3, -1.037, 0, 0, 0.244387,-99) , 
3, 0.0509667, 0, 0, 0.475125,-99)    );
  // itree = 720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22572, 1, 1, 0.840985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343676,-99) , 
0, 0.852865, 1, 0, 0.645552,-99) , 
3, 1.02628, 0, 0, 0.754865,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270478,-99) , 
0, -0.655593, 1, 0, 0.433689,-99) , 
NN(
0, 
0, 
-1, -1.231, 0, -1, 0.137559,-99) , 
3, -0.685, 0, 0, 0.275111,-99) , 
3, 0.254861, 0, 0, 0.489596,-99)    );
  // itree = 721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54195, 1, 1, 0.871893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335949,-99) , 
0, 0.957246, 1, 0, 0.651802,-99) , 
3, 1.10862, 0, 0, 0.736897,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.186792,-99) , 
3, -0.202496, 0, 0, 0.514502,-99)    );
  // itree = 722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74269, 0, 1, 0.835346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192812,-99) , 
0, 0.973473, 1, 0, 0.544957,-99) , 
3, 1.07643, 0, 0, 0.650091,-99) , 
NN(
0, 
0, 
-1, -0.750729, 0, -1, 0.166244,-99) , 
3, -0.304384, 0, 0, 0.441691,-99)    );
  // itree = 723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.875615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386538,-99) , 
0, 1.10293, 1, 0, 0.688117,-99) , 
3, 1.07981, 0, 0, 0.791231,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265631,-99) , 
0, -1.24008, 1, 0, 0.366817,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.106691,-99) , 
3, -0.959342, 0, 0, 0.270162,-99) , 
3, 0.301115, 0, 0, 0.504962,-99)    );
  // itree = 724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32226, 0, 1, 0.85543,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.905288,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359578,-99) , 
0, 0.609608, 1, 0, 0.615565,-99) , 
3, 1.0083, 0, 0, 0.746065,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266364,-99) , 
0, -1.21855, 1, 0, 0.361956,-99) , 
NN(
0, 
0, 
-1, -2.93551, 1, -1, 0.123289,-99) , 
3, -1.01511, 0, 0, 0.288054,-99) , 
3, 0.238103, 0, 0, 0.514381,-99)    );
  // itree = 725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0858844, 1, 1, 0.750398,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326735,-99) , 
1, -0.121558, 1, 0, 0.445304,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.212921,-99) , 
3, -0.394308, 0, 0, 0.286031,-99) , 
3, 0.238103, 0, 0, 0.492872,-99)    );
  // itree = 726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.809248,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267803,-99) , 
0, 0.653897, 1, 0, 0.498068,-99) , 
3, 1.00703, 0, 0, 0.595741,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.0997072,-99) , 
3, -1.15643, 0, 0, 0.491517,-99)    );
  // itree = 727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.774977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305588,-99) , 
1, -0.214834, 1, 0, 0.502464,-99) , 
3, 0.299337, 0, 0, 0.695945,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.201143,-99) , 
3, -0.38184, 0, 0, 0.5179,-99)    );
  // itree = 728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06599, 1, 1, 0.795579,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215229,-99) , 
0, 0.259256, 1, 0, 0.525894,-99) , 
3, 0.596878, 0, 0, 0.672124,-99) , 
NN(
0, 
0, 
-1, -0.692783, 1, -1, 0.164353,-99) , 
3, -0.639447, 0, 0, 0.53451,-99)    );
  // itree = 729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.266839, 0, 1, 0.742662,-99) , 
NN(
0, 
0, 
-1, -1.17011, 0, -1, 0.163906,-99) , 
3, -0.18324, 0, 0, 0.511398,-99)    );
  // itree = 730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.852226,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437919,-99) , 
0, 0.639693, 1, 0, 0.603338,-99) , 
3, 1.08657, 0, 0, 0.725794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300359,-99) , 
0, -0.991976, 1, 0, 0.408161,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0926274,-99) , 
3, -0.95623, 0, 0, 0.290099,-99) , 
3, 0.306962, 0, 0, 0.466864,-99)    );
  // itree = 731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49191, 1, 1, 0.836096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396679,-99) , 
0, 0.819377, 1, 0, 0.682478,-99) , 
3, 1.00929, 0, 0, 0.762744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293146,-99) , 
0, -0.701064, 1, 0, 0.466212,-99) , 
NN(
0, 
0, 
-1, -1.13161, 0, -1, 0.17124,-99) , 
3, -0.379167, 0, 0, 0.264577,-99) , 
3, 0.17816, 0, 0, 0.501962,-99)    );
  // itree = 732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63103, 0, 1, 0.781352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296853,-99) , 
0, -0.348921, 1, 0, 0.509957,-99) , 
3, 0.341274, 0, 0, 0.694288,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.175747,-99) , 
0, -1.19072, 1, 0, 0.311943,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.0746391,-99) , 
3, -1.16595, 0, 0, 0.202496,-99) , 
3, -0.303436, 0, 0, 0.499323,-99)    );
  // itree = 733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.875037,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332292,-99) , 
0, 0.900473, 1, 0, 0.59272,-99) , 
3, 1.30607, 0, 0, 0.680644,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.179884,-99) , 
3, -0.304384, 0, 0, 0.489734,-99)    );
  // itree = 734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.884551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4611,-99) , 
0, -0.0385343, 1, 0, 0.58439,-99) , 
3, 1.33887, 0, 0, 0.679558,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.199104,-99) , 
3, -0.202496, 0, 0, 0.487898,-99)    );
  // itree = 735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.886959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411154,-99) , 
0, 0.424748, 1, 0, 0.591843,-99) , 
3, 1.20395, 0, 0, 0.703102,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.231966,-99) , 
3, -0.123397, 0, 0, 0.504741,-99)    );
  // itree = 736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34586, 1, 1, 0.781724,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353821,-99) , 
0, -0.0316589, 1, 0, 0.572547,-99) , 
3, 0.540529, 0, 0, 0.70693,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.216791,-99) , 
3, -0.123397, 0, 0, 0.506216,-99)    );
  // itree = 737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6221, 1, 1, 0.871397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834004,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376674,-99) , 
0, 0.670322, 1, 0, 0.625948,-99) , 
3, 1.20395, 0, 0, 0.719373,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.216289,-99) , 
3, -0.123397, 0, 0, 0.497247,-99)    );
  // itree = 738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90612, 0, 1, 0.812449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313687,-99) , 
0, 0.927565, 1, 0, 0.541545,-99) , 
3, 1.0874, 0, 0, 0.623002,-99) , 
NN(
0, 
0, 
-1, -2.82896, 1, -1, 0.154068,-99) , 
3, -0.639447, 0, 0, 0.49218,-99)    );
  // itree = 739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.123785, 1, 1, 0.83403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367547,-99) , 
0, 0.459356, 1, 0, 0.608444,-99) , 
3, 0.98281, 0, 0, 0.705132,-99) , 
NN(
0, 
0, 
-1, -1.03591, 0, -1, 0.242274,-99) , 
3, -0.123397, 0, 0, 0.521167,-99)    );
  // itree = 740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.00999, 0, 1, 0.851038,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310909,-99) , 
0, 1.02827, 1, 0, 0.633324,-99) , 
3, 1.22296, 0, 0, 0.718957,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.226092,-99) , 
3, -0.123397, 0, 0, 0.514641,-99)    );
  // itree = 741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.830939, 0, 1, 0.875637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408649,-99) , 
3, 1.32987, 0, 0, 0.681683,-99) , 
0, 1.04198, 1, 0, 0.763063,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344005,-99) , 
0, -0.833115, 1, 0, 0.428244,-99) , 
NN(
0, 
0, 
-1, -2.64499, 1, -1, 0.158533,-99) , 
3, -0.64095, 0, 0, 0.303707,-99) , 
3, 0.306962, 0, 0, 0.511587,-99)    );
  // itree = 742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.82976, 1, 1, 0.875886,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326431,-99) , 
0, 1.27921, 1, 0, 0.658214,-99) , 
3, 1.28253, 0, 0, 0.75539,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714174,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291331,-99) , 
0, -0.715395, 1, 0, 0.423382,-99) , 
NN(
0, 
0, 
-1, -1.86171, 1, -1, 0.15465,-99) , 
3, -0.553771, 0, 0, 0.262528,-99) , 
3, 0.262941, 0, 0, 0.489522,-99)    );
  // itree = 743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.695491, 0, 1, 0.767756,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210104,-99) , 
0, -0.468678, 1, 0, 0.380974,-99) , 
NN(
0, 
0, 
-1, 0.179185, 1, -1, 0.10585,-99) , 
3, -0.95623, 0, 0, 0.262259,-99) , 
3, 0.306962, 0, 0, 0.491091,-99)    );
  // itree = 744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84238, 1, 1, 0.847998,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450453,-99) , 
0, 0.459356, 1, 0, 0.625489,-99) , 
3, 1.20885, 0, 0, 0.70295,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.203913,-99) , 
3, -0.123397, 0, 0, 0.509941,-99)    );
  // itree = 745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.849878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400514,-99) , 
0, 0.429002, 1, 0, 0.587192,-99) , 
3, 1.12023, 0, 0, 0.688076,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170639,-99) , 
0, -1.17488, 1, 0, 0.306118,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.121707,-99) , 
3, -1.07684, 0, 0, 0.220914,-99) , 
3, -0.202496, 0, 0, 0.490625,-99)    );
  // itree = 746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15389, 1, 1, 0.76285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416215,-99) , 
0, -0.387725, 1, 0, 0.54095,-99) , 
3, 0.408653, 0, 0, 0.693624,-99) , 
NN(
0, 
0, 
-1, -0.985546, 0, -1, 0.174956,-99) , 
3, -0.255748, 0, 0, 0.482471,-99)    );
  // itree = 747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22003, 1, 1, 0.839895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332611,-99) , 
0, 0.733763, 1, 0, 0.625207,-99) , 
3, 0.995911, 0, 0, 0.719695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614784,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.163814,-99) , 
0, -1.20513, 1, 0, 0.29259,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0968813,-99) , 
3, -1.00886, 0, 0, 0.206727,-99) , 
3, -0.123397, 0, 0, 0.49476,-99)    );
  // itree = 748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.839385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242694,-99) , 
0, 1.0581, 1, 0, 0.590097,-99) , 
3, 1.1284, 0, 0, 0.693004,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269931,-99) , 
0, -1.41627, 1, 0, 0.349751,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0764647,-99) , 
3, -1.18731, 0, 0, 0.26156,-99) , 
3, 0.135748, 0, 0, 0.474357,-99)    );
  // itree = 749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82393, 1, 1, 0.867414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334415,-99) , 
0, 1.02331, 1, 0, 0.647577,-99) , 
3, 1.26767, 0, 0, 0.722768,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188803,-99) , 
0, -1.00424, 1, 0, 0.306362,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.126856,-99) , 
3, -1.0333, 0, 0, 0.229156,-99) , 
3, 0.0509667, 0, 0, 0.493444,-99)    );
  // itree = 750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.852701,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372586,-99) , 
0, 1.0116, 1, 0, 0.677162,-99) , 
3, 1.16365, 0, 0, 0.744166,-99) , 
NN(
0, 
0, 
-1, -1.41615, 0, -1, 0.206284,-99) , 
3, -0.18324, 0, 0, 0.505759,-99)    );
  // itree = 751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.95036, 1, 1, 0.792056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362568,-99) , 
0, -0.123773, 1, 0, 0.4976,-99) , 
3, 0.525662, 0, 0, 0.668733,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.203605,-99) , 
3, -0.38184, 0, 0, 0.501076,-99)    );
  // itree = 752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.115771, 1, 1, 0.866859,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445422,-99) , 
3, 1.0604, 0, 0, 0.654522,-99) , 
0, 0.254496, 1, 0, 0.71582,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.208377,-99) , 
3, -0.123397, 0, 0, 0.486597,-99)    );
  // itree = 753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48356, 1, 1, 0.846205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435437,-99) , 
0, -0.00616939, 1, 0, 0.571848,-99) , 
3, 0.99222, 0, 0, 0.666552,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.209038,-99) , 
3, -0.376892, 0, 0, 0.504617,-99)    );
  // itree = 754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.869246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409977,-99) , 
0, 0.449644, 1, 0, 0.603556,-99) , 
3, 1.07098, 0, 0, 0.701547,-99) , 
NN(
0, 
0, 
-1, -0.986033, 0, -1, 0.24629,-99) , 
3, -0.255748, 0, 0, 0.515404,-99)    );
  // itree = 755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.857813,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381143,-99) , 
0, 0.819061, 1, 0, 0.619177,-99) , 
3, 1.21404, 0, 0, 0.72005,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264564,-99) , 
0, -1.28626, 1, 0, 0.36909,-99) , 
NN(
0, 
0, 
-1, -2.93909, 1, -1, 0.128611,-99) , 
3, -1.2031, 0, 0, 0.292663,-99) , 
3, 0.17816, 0, 0, 0.501035,-99)    );
  // itree = 756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.225443, 1, 1, 0.948809,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497256,-99) , 
3, 1.0411, 0, 0, 0.712048,-99) , 
0, 0.311772, 1, 0, 0.765379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51607,-99) , 
NN(
0, 
0, 
-1, -0.95783, 0, -1, 0.199939,-99) , 
3, -0.0605065, 0, 0, 0.257444,-99) , 
3, 0.254861, 0, 0, 0.479805,-99)    );
  // itree = 757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.376103, 1, 1, 0.892028,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356032,-99) , 
3, 1.2268, 0, 0, 0.690703,-99) , 
0, 1.10708, 1, 0, 0.78575,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264467,-99) , 
1, -0.505987, 1, 0, 0.378718,-99) , 
NN(
0, 
0, 
-1, -2.36049, 1, -1, 0.165067,-99) , 
3, -0.549899, 0, 0, 0.266316,-99) , 
3, 0.262941, 0, 0, 0.496196,-99)    );
  // itree = 758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15389, 1, 1, 0.80341,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233814,-99) , 
0, 0.245926, 1, 0, 0.508439,-99) , 
3, 0.555401, 0, 0, 0.678135,-99) , 
NN(
0, 
0, 
-1, -1.25138, 1, -1, 0.177821,-99) , 
3, -0.326776, 0, 0, 0.504369,-99)    );
  // itree = 759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.837685,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497902,-99) , 
0, -0.763998, 1, 0, 0.595811,-99) , 
3, 0.916712, 0, 0, 0.704902,-99) , 
NN(
0, 
0, 
-1, -1.1903, 0, -1, 0.179234,-99) , 
3, -0.451327, 0, 0, 0.52645,-99)    );
  // itree = 760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.10303, 1, 1, 0.876192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428017,-99) , 
0, 1.11365, 1, 0, 0.683584,-99) , 
3, 1.22954, 0, 0, 0.762917,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274351,-99) , 
0, -0.380122, 1, 0, 0.444366,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.170242,-99) , 
3, -0.372136, 0, 0, 0.254374,-99) , 
3, 0.254861, 0, 0, 0.483421,-99)    );
  // itree = 761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90497, 1, 1, 0.845891,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423689,-99) , 
0, 0.540099, 1, 0, 0.62628,-99) , 
3, 1.12392, 0, 0, 0.727353,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217829,-99) , 
0, -0.628391, 1, 0, 0.350935,-99) , 
NN(
0, 
0, 
-1, -0.610343, 1, -1, 0.110601,-99) , 
3, -0.725985, 0, 0, 0.216208,-99) , 
3, 0.0990605, 0, 0, 0.470793,-99)    );
  // itree = 762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.351797, 1, 1, 0.90499,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3593,-99) , 
3, 1.0127, 0, 0, 0.705733,-99) , 
0, 0.785602, 1, 0, 0.773802,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306701,-99) , 
0, -1.00706, 1, 0, 0.414483,-99) , 
NN(
0, 
0, 
-1, -0.511518, 1, -1, 0.0817013,-99) , 
3, -1.01611, 0, 0, 0.284872,-99) , 
3, 0.238103, 0, 0, 0.507807,-99)    );
  // itree = 763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.382781, 1, 1, 0.959817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455761,-99) , 
3, 1.12995, 0, 0, 0.699217,-99) , 
0, 0.616454, 1, 0, 0.770956,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266752,-99) , 
0, -0.765399, 1, 0, 0.374947,-99) , 
NN(
0, 
0, 
-1, -1.22659, 0, -1, 0.168406,-99) , 
3, -0.541933, 0, 0, 0.265758,-99) , 
3, 0.246134, 0, 0, 0.479647,-99)    );
  // itree = 764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09855, 1, 1, 0.776598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490843,-99) , 
3, 0.411366, 0, 0, 0.707208,-99) , 
NN(
0, 
0, 
-1, -0.74869, 0, -1, 0.180726,-99) , 
3, -0.0258416, 0, 0, 0.443642,-99)    );
  // itree = 765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.310349, 0, 1, 0.87361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42039,-99) , 
3, 1.42786, 0, 0, 0.666151,-99) , 
0, 1.05067, 1, 0, 0.750557,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319234,-99) , 
0, -0.683741, 1, 0, 0.467203,-99) , 
NN(
0, 
0, 
-1, -1.05834, 0, -1, 0.193585,-99) , 
3, -0.327012, 0, 0, 0.289844,-99) , 
3, 0.20809, 0, 0, 0.517822,-99)    );
  // itree = 766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37532, 0, 1, 0.824492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196762,-99) , 
0, 0.373282, 1, 0, 0.539429,-99) , 
3, 0.66689, 0, 0, 0.699568,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.179374,-99) , 
3, -1.38408, 0, 0, 0.314016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142569,-99) , 
0, -1.3022, 1, 0, 0.22654,-99) , 
3, -0.207894, 0, 0, 0.511275,-99)    );
  // itree = 767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81543, 0, 1, 0.856955,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455964,-99) , 
0, 0.84668, 1, 0, 0.659151,-99) , 
3, 1.38447, 0, 0, 0.725733,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596193,-99) , 
NN(
0, 
0, 
-1, -0.851575, 0, -1, 0.216778,-99) , 
3, -0.0835608, 0, 0, 0.269145,-99) , 
3, 0.183842, 0, 0, 0.489533,-99)    );
  // itree = 768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89241, 1, 1, 0.880898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448529,-99) , 
0, 0.0296729, 1, 0, 0.581392,-99) , 
3, 1.33636, 0, 0, 0.665662,-99) , 
NN(
0, 
0, 
-1, -1.65122, 1, -1, 0.147604,-99) , 
3, -0.639447, 0, 0, 0.513517,-99)    );
  // itree = 769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.51004, 1, 1, 0.851977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338743,-99) , 
0, 0.647916, 1, 0, 0.604639,-99) , 
3, 1.07541, 0, 0, 0.694311,-99) , 
NN(
0, 
0, 
-1, -1.57263, 0, -1, 0.242473,-99) , 
3, -0.304384, 0, 0, 0.5364,-99)    );
  // itree = 770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.855115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345043,-99) , 
0, 0.786802, 1, 0, 0.637656,-99) , 
3, 1.05916, 0, 0, 0.751205,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353686,-99) , 
0, -0.517038, 1, 0, 0.466227,-99) , 
NN(
0, 
0, 
-1, -1.1929, 0, -1, 0.200429,-99) , 
3, -0.246493, 0, 0, 0.277253,-99) , 
3, 0.276895, 0, 0, 0.489101,-99)    );
  // itree = 771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.838336,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322698,-99) , 
0, 0.360286, 1, 0, 0.591964,-99) , 
3, 0.774024, 0, 0, 0.722316,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.239397,-99) , 
3, -0.123397, 0, 0, 0.519714,-99)    );
  // itree = 772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54712, 1, 1, 0.852999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316846,-99) , 
0, 0.868874, 1, 0, 0.543871,-99) , 
3, 1.18523, 0, 0, 0.643172,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.15123,-99) , 
3, -0.756041, 0, 0, 0.515975,-99)    );
  // itree = 773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0681742, 1, 1, 0.911607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491898,-99) , 
0, 0.980227, 1, 0, 0.696542,-99) , 
3, 1.58667, 0, 0, 0.752846,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295384,-99) , 
0, -0.773268, 1, 0, 0.429749,-99) , 
NN(
0, 
0, 
-1, -1.36539, 1, -1, 0.153686,-99) , 
3, -0.391132, 0, 0, 0.257295,-99) , 
3, 0.238103, 0, 0, 0.454272,-99)    );
  // itree = 774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15782, 1, 1, 0.76685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492797,-99) , 
3, 0.264998, 0, 0, 0.705155,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183481,-99) , 
0, -1.19072, 1, 0, 0.350621,-99) , 
NN(
0, 
0, 
-1, -1.79073, 0, -1, 0.07028,-99) , 
3, -1.16979, 0, 0, 0.230627,-99) , 
3, -0.18324, 0, 0, 0.500583,-99)    );
  // itree = 775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.385953, 1, 1, 0.781294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461437,-99) , 
3, 0.235551, 0, 0, 0.706197,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.195289,-99) , 
3, -0.202496, 0, 0, 0.49852,-99)    );
  // itree = 776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76459, 1, 1, 0.855896,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370852,-99) , 
0, 0.615228, 1, 0, 0.612374,-99) , 
3, 0.937007, 0, 0, 0.727957,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567853,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221346,-99) , 
0, -1.37863, 1, 0, 0.33299,-99) , 
NN(
0, 
0, 
-1, -1.98891, 0, -1, 0.0978154,-99) , 
3, -1.16979, 0, 0, 0.235282,-99) , 
3, -0.18324, 0, 0, 0.526263,-99)    );
  // itree = 777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2574, 1, 1, 0.845481,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237276,-99) , 
0, 1.00867, 1, 0, 0.626539,-99) , 
3, 1.12392, 0, 0, 0.71776,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273572,-99) , 
0, -1.21855, 1, 0, 0.38826,-99) , 
NN(
0, 
0, 
-1, -2.85101, 1, -1, 0.0799302,-99) , 
3, -0.990852, 0, 0, 0.250893,-99) , 
3, 0.0990605, 0, 0, 0.481818,-99)    );
  // itree = 778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.879931,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438913,-99) , 
0, 1.43856, 1, 0, 0.704239,-99) , 
3, 1.37586, 0, 0, 0.777687,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712433,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350156,-99) , 
0, -0.684004, 1, 0, 0.466537,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.135891,-99) , 
3, -0.568255, 0, 0, 0.290082,-99) , 
3, 0.392653, 0, 0, 0.48821,-99)    );
  // itree = 779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2995, 0, 1, 0.829527,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349969,-99) , 
0, 0.0757057, 1, 0, 0.587054,-99) , 
3, 0.540529, 0, 0, 0.748614,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.234364,-99) , 
3, -0.123397, 0, 0, 0.527838,-99)    );
  // itree = 780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.76767, 0, 1, 0.780207,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309385,-99) , 
0, -0.158108, 1, 0, 0.472797,-99) , 
NN(
0, 
0, 
-1, -1.79745, 1, -1, 0.170291,-99) , 
3, -0.552992, 0, 0, 0.324961,-99) , 
3, 0.660704, 0, 0, 0.485907,-99)    );
  // itree = 781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.854292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307406,-99) , 
0, 0.877072, 1, 0, 0.593847,-99) , 
3, 1.21373, 0, 0, 0.684525,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146502,-99) , 
0, -1.15993, 1, 0, 0.339355,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.11238,-99) , 
3, -1.01267, 0, 0, 0.226123,-99) , 
3, -0.123397, 0, 0, 0.486353,-99)    );
  // itree = 782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1487, 1, 1, 0.861319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.907482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36961,-99) , 
0, 0.852865, 1, 0, 0.646247,-99) , 
3, 1.17923, 0, 0, 0.753555,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321828,-99) , 
0, -0.991976, 1, 0, 0.43078,-99) , 
NN(
0, 
0, 
-1, -0.257029, 1, -1, 0.158833,-99) , 
3, -0.888168, 0, 0, 0.317132,-99) , 
3, 0.392653, 0, 0, 0.502442,-99)    );
  // itree = 783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.748513, 1, 1, 0.784829,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388661,-99) , 
1, -0.58428, 1, 0, 0.498527,-99) , 
3, 0.312308, 0, 0, 0.697018,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.174126,-99) , 
3, -0.376892, 0, 0, 0.505595,-99)    );
  // itree = 784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12586, 0, 1, 0.824132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399801,-99) , 
0, -0.129019, 1, 0, 0.546437,-99) , 
3, 0.761669, 0, 0, 0.691203,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199102,-99) , 
0, -1.21605, 1, 0, 0.33992,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.118535,-99) , 
3, -1.00886, 0, 0, 0.238513,-99) , 
3, -0.123397, 0, 0, 0.50497,-99)    );
  // itree = 785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.805661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36929,-99) , 
0, -0.135613, 1, 0, 0.588124,-99) , 
3, 0.543354, 0, 0, 0.720533,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199282,-99) , 
0, -1.13507, 1, 0, 0.336828,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.106841,-99) , 
3, -1.00946, 0, 0, 0.222555,-99) , 
3, -0.123397, 0, 0, 0.509288,-99)    );
  // itree = 786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.832789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311568,-99) , 
0, 0.848875, 1, 0, 0.621403,-99) , 
3, 0.996318, 0, 0, 0.705545,-99) , 
NN(
0, 
0, 
-1, -1.03667, 0, -1, 0.221188,-99) , 
3, -0.314014, 0, 0, 0.543769,-99)    );
  // itree = 787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.873246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42729,-99) , 
0, 0.84668, 1, 0, 0.65147,-99) , 
3, 1.35744, 0, 0, 0.732202,-99) , 
NN(
0, 
0, 
-1, -1.12664, 0, -1, 0.283981,-99) , 
3, 0.180631, 0, 0, 0.498008,-99)    );
  // itree = 788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.10303, 1, 1, 0.906752,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495286,-99) , 
0, 0.540099, 1, 0, 0.650324,-99) , 
3, 1.3302, 0, 0, 0.74691,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269469,-99) , 
0, -0.868842, 1, 0, 0.389567,-99) , 
NN(
0, 
0, 
-1, -1.78595, 1, -1, 0.157223,-99) , 
3, -0.718998, 0, 0, 0.260999,-99) , 
3, 0.0990605, 0, 0, 0.514444,-99)    );
  // itree = 789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.909925, 0, 1, 0.762554,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.137483,-99) , 
0, -0.169453, 1, 0, 0.346873,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.15877,-99) , 
3, -0.497209, 0, 0, 0.241003,-99) , 
3, 0.307824, 0, 0, 0.45664,-99)    );
  // itree = 790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.875774,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317543,-99) , 
0, 1.02331, 1, 0, 0.623419,-99) , 
3, 1.20885, 0, 0, 0.71514,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.20835,-99) , 
3, -0.123397, 0, 0, 0.484598,-99)    );
  // itree = 791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.78547,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305464,-99) , 
0, -1.41583, 1, 0, 0.373094,-99) , 
NN(
0, 
0, 
-1, -2.61108, 1, -1, 0.108969,-99) , 
3, -1.0104, 0, 0, 0.274815,-99) , 
3, 0.238103, 0, 0, 0.506386,-99)    );
  // itree = 792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.977311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489562,-99) , 
3, 0.83755, 0, 0, 0.721322,-99) , 
0, -0.00445448, 1, 0, 0.757392,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228571,-99) , 
0, -1.20938, 1, 0, 0.321196,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.083662,-99) , 
3, -1.06718, 0, 0, 0.243842,-99) , 
3, 0.246134, 0, 0, 0.467513,-99)    );
  // itree = 793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1598, 1, 1, 0.816065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267081,-99) , 
0, 0.848875, 1, 0, 0.57848,-99) , 
3, 1.07643, 0, 0, 0.669285,-99) , 
NN(
0, 
0, 
-1, -0.719355, 1, -1, 0.157355,-99) , 
3, -0.304384, 0, 0, 0.465613,-99)    );
  // itree = 794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.715889, 1, 1, 0.758145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489543,-99) , 
3, 0.244938, 0, 0, 0.696159,-99) , 
NN(
0, 
0, 
-1, -0.955363, 0, -1, 0.219763,-99) , 
3, -0.210183, 0, 0, 0.483572,-99)    );
  // itree = 795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5896, 1, 1, 0.85068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382816,-99) , 
0, 0.923985, 1, 0, 0.667539,-99) , 
3, 1.2097, 0, 0, 0.730441,-99) , 
NN(
0, 
0, 
-1, -1.37508, 0, -1, 0.166714,-99) , 
3, -0.376892, 0, 0, 0.525773,-99)    );
  // itree = 796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56224, 1, 1, 0.865597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327876,-99) , 
0, 0.854666, 1, 0, 0.626696,-99) , 
3, 1.2063, 0, 0, 0.708709,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.232498,-99) , 
3, -0.123397, 0, 0, 0.50598,-99)    );
  // itree = 797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.768458, 1, 1, 0.796776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270977,-99) , 
0, 0.168185, 1, 0, 0.521993,-99) , 
3, 0.546413, 0, 0, 0.693718,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172018,-99) , 
0, -1.11109, 1, 0, 0.32984,-99) , 
NN(
0, 
0, 
-1, -0.0109455, 1, -1, 0.0904036,-99) , 
3, -1.00946, 0, 0, 0.217387,-99) , 
3, -0.123397, 0, 0, 0.476924,-99)    );
  // itree = 798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.885809,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39145,-99) , 
0, 1.09387, 1, 0, 0.663582,-99) , 
3, 1.40724, 0, 0, 0.751179,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285136,-99) , 
0, -0.566574, 1, 0, 0.429492,-99) , 
NN(
0, 
0, 
-1, -2.66417, 1, -1, 0.188781,-99) , 
3, -0.587974, 0, 0, 0.28901,-99) , 
3, 0.20809, 0, 0, 0.500817,-99)    );
  // itree = 799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.369294, 0, 1, 0.848097,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387293,-99) , 
3, 1.12833, 0, 0, 0.633805,-99) , 
0, 0.512645, 1, 0, 0.707433,-99) , 
NN(
0, 
0, 
-1, -0.450619, 0, -1, 0.268731,-99) , 
3, 0.093663, 0, 0, 0.486407,-99)    );
  // itree = 800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.859076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394545,-99) , 
0, 0.8372, 1, 0, 0.653601,-99) , 
3, 1.20395, 0, 0, 0.725197,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.168798,-99) , 
3, -0.123397, 0, 0, 0.466594,-99)    );
  // itree = 801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37766, 0, 1, 0.79285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2687,-99) , 
0, 0.210433, 1, 0, 0.50398,-99) , 
3, 0.670287, 0, 0, 0.666308,-99) , 
NN(
0, 
0, 
-1, -0.798162, 0, -1, 0.189938,-99) , 
3, -0.207894, 0, 0, 0.491215,-99)    );
  // itree = 802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.88457,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437037,-99) , 
0, 1.18679, 1, 0, 0.714214,-99) , 
3, 1.42668, 0, 0, 0.773976,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232106,-99) , 
0, -0.481374, 1, 0, 0.384311,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.165876,-99) , 
3, -0.56685, 0, 0, 0.258272,-99) , 
3, 0.228725, 0, 0, 0.49402,-99)    );
  // itree = 803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.883839,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348282,-99) , 
0, 0.708301, 1, 0, 0.61604,-99) , 
3, 1.0587, 0, 0, 0.730609,-99) , 
NN(
0, 
0, 
-1, -1.18221, 0, -1, 0.2464,-99) , 
3, -0.234495, 0, 0, 0.557466,-99)    );
  // itree = 804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41447, 0, 1, 0.755494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299514,-99) , 
0, -0.566574, 1, 0, 0.468295,-99) , 
3, 0.255967, 0, 0, 0.665532,-99) , 
NN(
0, 
0, 
-1, -1.17803, 0, -1, 0.164006,-99) , 
3, -0.420978, 0, 0, 0.486559,-99)    );
  // itree = 805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.854823,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.914917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47206,-99) , 
0, 0.566777, 1, 0, 0.685306,-99) , 
3, 1.08443, 0, 0, 0.780832,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367985,-99) , 
0, -0.676329, 1, 0, 0.511288,-99) , 
NN(
0, 
0, 
-1, -1.18692, 0, -1, 0.221979,-99) , 
3, -0.329146, 0, 0, 0.339456,-99) , 
3, 0.306962, 0, 0, 0.532895,-99)    );
  // itree = 806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42103, 0, 1, 0.779284,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259303,-99) , 
0, -1.27096, 1, 0, 0.366954,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.111941,-99) , 
3, -0.935822, 0, 0, 0.261581,-99) , 
3, 0.17816, 0, 0, 0.509217,-99)    );
  // itree = 807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.87392, 1, 1, 0.876245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28821,-99) , 
0, 1.20619, 1, 0, 0.640832,-99) , 
3, 1.20395, 0, 0, 0.730489,-99) , 
NN(
0, 
0, 
-1, -0.719025, 0, -1, 0.218898,-99) , 
3, -0.123397, 0, 0, 0.502972,-99)    );
  // itree = 808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.894862,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360008,-99) , 
0, 1.33067, 1, 0, 0.701399,-99) , 
3, 1.37586, 0, 0, 0.785171,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2391,-99) , 
0, -0.0718625, 1, 0, 0.467783,-99) , 
NN(
0, 
0, 
-1, -1.39393, 0, -1, 0.186945,-99) , 
3, -0.566981, 0, 0, 0.329461,-99) , 
3, 0.392653, 0, 0, 0.517963,-99)    );
  // itree = 809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.29551, 0, 1, 0.786894,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288506,-99) , 
0, -0.983565, 1, 0, 0.394823,-99) , 
NN(
0, 
0, 
-1, -2.48517, 1, -1, 0.126309,-99) , 
3, -1.06644, 0, 0, 0.291893,-99) , 
3, 0.28719, 0, 0, 0.494758,-99)    );
  // itree = 810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.44428, 0, 1, 0.710762,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.201108,-99) , 
3, -0.376892, 0, 0, 0.530088,-99)    );
  // itree = 811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53268, 1, 1, 0.853321,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28519,-99) , 
0, 1.20619, 1, 0, 0.600971,-99) , 
3, 1.2063, 0, 0, 0.692071,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.20661,-99) , 
3, -0.123397, 0, 0, 0.493113,-99)    );
  // itree = 812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49626, 0, 1, 0.855949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285971,-99) , 
0, 0.745872, 1, 0, 0.613274,-99) , 
3, 1.01053, 0, 0, 0.735988,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314145,-99) , 
1, -0.380107, 1, 0, 0.436464,-99) , 
NN(
0, 
0, 
-1, -2.29374, 1, -1, 0.138089,-99) , 
3, -0.587974, 0, 0, 0.263575,-99) , 
3, 0.20809, 0, 0, 0.486734,-99)    );
  // itree = 813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.805447,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33637,-99) , 
0, -0.0316589, 1, 0, 0.569915,-99) , 
3, 0.535482, 0, 0, 0.722651,-99) , 
NN(
0, 
0, 
-1, -0.654428, 0, -1, 0.228352,-99) , 
3, -0.160313, 0, 0, 0.510488,-99)    );
  // itree = 814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.68121, 1, 1, 0.877576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28881,-99) , 
0, 1.0581, 1, 0, 0.617409,-99) , 
3, 1.21404, 0, 0, 0.725722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557658,-99) , 
NN(
0, 
0, 
-1, -1.40162, 1, -1, 0.197225,-99) , 
3, -0.106823, 0, 0, 0.259088,-99) , 
3, 0.17816, 0, 0, 0.491669,-99)    );
  // itree = 815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.04624, 1, 1, 0.838237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456148,-99) , 
0, 0.254158, 1, 0, 0.62548,-99) , 
3, 0.805108, 0, 0, 0.771333,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300282,-99) , 
0, -1.21855, 1, 0, 0.406748,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.142173,-99) , 
3, -1.02731, 0, 0, 0.30274,-99) , 
3, 0.218994, 0, 0, 0.51174,-99)    );
  // itree = 816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13686, 0, 1, 0.84209,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329082,-99) , 
3, 1.41335, 0, 0, 0.649496,-99) , 
0, 1.54644, 1, 0, 0.752,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287991,-99) , 
0, -0.302235, 1, 0, 0.412718,-99) , 
NN(
0, 
0, 
-1, -1.19134, 0, -1, 0.162996,-99) , 
3, -0.326848, 0, 0, 0.252355,-99) , 
3, 0.306962, 0, 0, 0.451992,-99)    );
  // itree = 817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.984859, 0, 1, 0.771963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322367,-99) , 
0, -0.303416, 1, 0, 0.478942,-99) , 
3, 0.387506, 0, 0, 0.687376,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.194416,-99) , 
3, -0.304384, 0, 0, 0.51381,-99)    );
  // itree = 818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.872416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309464,-99) , 
0, 0.793469, 1, 0, 0.592757,-99) , 
3, 1.18038, 0, 0, 0.69344,-99) , 
NN(
0, 
0, 
-1, -0.622078, 0, -1, 0.196635,-99) , 
3, -0.160313, 0, 0, 0.498998,-99)    );
  // itree = 819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42623, 1, 1, 0.837946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367825,-99) , 
0, -0.0316589, 1, 0, 0.568038,-99) , 
3, 0.55361, 0, 0, 0.749487,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.235923,-99) , 
3, -0.123397, 0, 0, 0.520808,-99)    );
  // itree = 820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.58992, 1, 1, 0.853689,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376114,-99) , 
0, 0.696824, 1, 0, 0.613851,-99) , 
3, 1.11054, 0, 0, 0.736098,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24063,-99) , 
0, -0.293168, 1, 0, 0.41583,-99) , 
NN(
0, 
0, 
-1, -2.4918, 1, -1, 0.0997763,-99) , 
3, -1.03194, 0, 0, 0.296602,-99) , 
3, 0.307824, 0, 0, 0.495991,-99)    );
  // itree = 821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.948275,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456727,-99) , 
3, 0.995911, 0, 0, 0.622259,-99) , 
0, -0.177282, 1, 0, 0.672411,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218432,-99) , 
0, -1.11874, 1, 0, 0.376272,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.115991,-99) , 
3, -1.00886, 0, 0, 0.254092,-99) , 
3, -0.123397, 0, 0, 0.501776,-99)    );
  // itree = 822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.97356, 1, 1, 0.78523,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428865,-99) , 
1, -0.0473604, 1, 0, 0.51936,-99) , 
3, 0.325599, 0, 0, 0.709914,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.215044,-99) , 
3, -0.123397, 0, 0, 0.493506,-99)    );
  // itree = 823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48899, 0, 1, 0.826274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377151,-99) , 
0, 0.397804, 1, 0, 0.563565,-99) , 
3, 0.98281, 0, 0, 0.681566,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.23045,-99) , 
3, -0.123397, 0, 0, 0.49762,-99)    );
  // itree = 824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.830718, 0, 1, 0.906357,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315398,-99) , 
3, 1.17721, 0, 0, 0.673827,-99) , 
0, 1.05086, 1, 0, 0.758985,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17311,-99) , 
0, -0.153185, 1, 0, 0.422246,-99) , 
NN(
0, 
0, 
-1, -1.76683, 1, -1, 0.137918,-99) , 
3, -0.64095, 0, 0, 0.273547,-99) , 
3, 0.306962, 0, 0, 0.468722,-99)    );
  // itree = 825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32521, 0, 1, 0.844243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389796,-99) , 
0, 0.154453, 1, 0, 0.594066,-99) , 
3, 0.98281, 0, 0, 0.706032,-99) , 
NN(
0, 
0, 
-1, -1.56871, 1, -1, 0.207281,-99) , 
3, -0.123397, 0, 0, 0.510417,-99)    );
  // itree = 826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89241, 1, 1, 0.858502,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42597,-99) , 
0, 0.282323, 1, 0, 0.637249,-99) , 
3, 1.11481, 0, 0, 0.737962,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24928,-99) , 
0, -1.2877, 1, 0, 0.33717,-99) , 
NN(
0, 
0, 
-1, -2.66817, 1, -1, 0.0551218,-99) , 
3, -0.993962, 0, 0, 0.221513,-99) , 
3, 0.093663, 0, 0, 0.465927,-99)    );
  // itree = 827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09855, 1, 1, 0.747643,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471543,-99) , 
3, 0.112007, 0, 0, 0.683866,-99) , 
NN(
0, 
0, 
-1, -1.06642, 0, -1, 0.170665,-99) , 
3, -0.340957, 0, 0, 0.488636,-99)    );
  // itree = 828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.806732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422849,-99) , 
1, -0.471534, 1, 0, 0.516993,-99) , 
3, 0.536638, 0, 0, 0.68734,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.164967,-99) , 
3, -0.38184, 0, 0, 0.498,-99)    );
  // itree = 829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.857537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375322,-99) , 
0, 0.852865, 1, 0, 0.661931,-99) , 
3, 1.12846, 0, 0, 0.747364,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199679,-99) , 
0, -1.19741, 1, 0, 0.302393,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.0809274,-99) , 
3, -0.990852, 0, 0, 0.213031,-99) , 
3, 0.0990605, 0, 0, 0.467495,-99)    );
  // itree = 830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33704, 0, 1, 0.776751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46876,-99) , 
3, 0.163069, 0, 0, 0.714075,-99) , 
NN(
0, 
0, 
-1, -1.71166, 0, -1, 0.193953,-99) , 
3, -0.269563, 0, 0, 0.512586,-99)    );
  // itree = 831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.86945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353761,-99) , 
0, 0.713978, 1, 0, 0.609115,-99) , 
3, 1.11353, 0, 0, 0.725606,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288552,-99) , 
0, -1.02927, 1, 0, 0.376918,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.100758,-99) , 
3, -0.997451, 0, 0, 0.260854,-99) , 
3, 0.093663, 0, 0, 0.503997,-99)    );
  // itree = 832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.559867, 1, 1, 0.849156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360797,-99) , 
0, 0.714566, 1, 0, 0.595333,-99) , 
3, 1.30554, 0, 0, 0.673838,-99) , 
NN(
0, 
0, 
-1, -0.721913, 0, -1, 0.23188,-99) , 
3, -0.237768, 0, 0, 0.50998,-99)    );
  // itree = 833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41175, 1, 1, 0.870139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314149,-99) , 
0, 0.848875, 1, 0, 0.624284,-99) , 
3, 1.07541, 0, 0, 0.727686,-99) , 
NN(
0, 
0, 
-1, -1.31804, 0, -1, 0.195886,-99) , 
3, -0.304384, 0, 0, 0.519763,-99)    );
  // itree = 834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.790482, 0, 1, 0.9232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43945,-99) , 
3, 1.11054, 0, 0, 0.719837,-99) , 
0, 0.761347, 1, 0, 0.782647,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301361,-99) , 
3, -0.0468665, 0, 0, 0.388032,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.144086,-99) , 
3, -0.76257, 0, 0, 0.274709,-99) , 
3, 0.307824, 0, 0, 0.485456,-99)    );
  // itree = 835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.878636,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333184,-99) , 
0, 1.31241, 1, 0, 0.652075,-99) , 
3, 1.4025, 0, 0, 0.73233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357183,-99) , 
1, -0.562613, 1, 0, 0.437803,-99) , 
NN(
0, 
0, 
-1, -2.22345, 1, -1, 0.143954,-99) , 
3, -0.863128, 0, 0, 0.301729,-99) , 
3, 0.202693, 0, 0, 0.522688,-99)    );
  // itree = 836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.46194, 1, 1, 0.899208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31491,-99) , 
0, 1.02331, 1, 0, 0.604568,-99) , 
3, 1.3302, 0, 0, 0.714353,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199465,-99) , 
0, -1.27491, 1, 0, 0.289635,-99) , 
NN(
0, 
0, 
-1, -2.31144, 1, -1, 0.0898764,-99) , 
3, -0.990852, 0, 0, 0.216969,-99) , 
3, 0.0990605, 0, 0, 0.458011,-99)    );
  // itree = 837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15677, 1, 1, 0.86309,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388567,-99) , 
0, 0.543606, 1, 0, 0.58111,-99) , 
3, 1.06589, 0, 0, 0.71058,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219319,-99) , 
0, -1.02927, 1, 0, 0.34905,-99) , 
NN(
0, 
0, 
-1, -2.86122, 1, -1, 0.0952261,-99) , 
3, -1.03104, 0, 0, 0.242706,-99) , 
3, 0.0509667, 0, 0, 0.487236,-99)    );
  // itree = 838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.832229,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290188,-99) , 
0, 0.127238, 1, 0, 0.574605,-99) , 
3, 0.540529, 0, 0, 0.7335,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165882,-99) , 
0, -1.21605, 1, 0, 0.291485,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.128997,-99) , 
3, -1.01267, 0, 0, 0.215286,-99) , 
3, -0.123397, 0, 0, 0.492171,-99)    );
  // itree = 839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.793477,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232926,-99) , 
0, -0.0750528, 1, 0, 0.508341,-99) , 
3, 0.489001, 0, 0, 0.690933,-99) , 
NN(
0, 
0, 
-1, -1.17011, 0, -1, 0.205279,-99) , 
3, -0.18324, 0, 0, 0.510847,-99)    );
  // itree = 840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.84591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362757,-99) , 
0, 0.459356, 1, 0, 0.576701,-99) , 
3, 1.07702, 0, 0, 0.673805,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.236462,-99) , 
3, -0.304384, 0, 0, 0.507612,-99)    );
  // itree = 841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.884582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395753,-99) , 
0, 0.904545, 1, 0, 0.63787,-99) , 
3, 1.28046, 0, 0, 0.753024,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288274,-99) , 
0, -0.878316, 1, 0, 0.378971,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.102152,-99) , 
3, -0.95623, 0, 0, 0.266593,-99) , 
3, 0.306962, 0, 0, 0.475586,-99)    );
  // itree = 842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44035, 1, 1, 0.828939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408003,-99) , 
0, -0.0219203, 1, 0, 0.625043,-99) , 
3, 0.540529, 0, 0, 0.761297,-99) , 
NN(
0, 
0, 
-1, -0.546181, 1, -1, 0.225477,-99) , 
3, -0.123397, 0, 0, 0.528447,-99)    );
  // itree = 843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.07643, 0, 1, 0.719004,-99) , 
NN(
0, 
0, 
-1, -0.8155, 0, -1, 0.202944,-99) , 
3, -0.304384, 0, 0, 0.51926,-99)    );
  // itree = 844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.82612,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338076,-99) , 
0, 0.478161, 1, 0, 0.582881,-99) , 
3, 0.84679, 0, 0, 0.696312,-99) , 
NN(
0, 
0, 
-1, -1.07057, 0, -1, 0.214363,-99) , 
3, -0.304384, 0, 0, 0.526014,-99)    );
  // itree = 845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35927, 1, 1, 0.81549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358141,-99) , 
0, 0.256929, 1, 0, 0.612118,-99) , 
3, 0.772751, 0, 0, 0.72391,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.214373,-99) , 
3, -0.123397, 0, 0, 0.513863,-99)    );
  // itree = 846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55026, 0, 1, 0.747585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27623,-99) , 
0, -0.193107, 1, 0, 0.499423,-99) , 
3, 0.351617, 0, 0, 0.646592,-99) , 
NN(
0, 
0, 
-1, -1.1819, 0, -1, 0.14259,-99) , 
3, -0.639447, 0, 0, 0.494855,-99)    );
  // itree = 847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.18184, 1, 1, 0.828399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400574,-99) , 
0, 0.267221, 1, 0, 0.559897,-99) , 
3, 0.829532, 0, 0, 0.693546,-99) , 
NN(
0, 
0, 
-1, -1.03076, 0, -1, 0.224093,-99) , 
3, -0.28269, 0, 0, 0.522513,-99)    );
  // itree = 848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.254496, 1, 1, 0.757656,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226124,-99) , 
0, -1.21855, 1, 0, 0.344894,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.123585,-99) , 
3, -1.04325, 0, 0, 0.247172,-99) , 
3, 0.0319938, 0, 0, 0.489324,-99)    );
  // itree = 849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.864572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368667,-99) , 
0, 1.11365, 1, 0, 0.684218,-99) , 
3, 1.28042, 0, 0, 0.760531,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356819,-99) , 
0, -0.892984, 1, 0, 0.450547,-99) , 
NN(
0, 
0, 
-1, -2.20591, 1, -1, 0.13202,-99) , 
3, -0.64095, 0, 0, 0.285606,-99) , 
3, 0.306962, 0, 0, 0.495065,-99)    );
  // itree = 850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08238, 0, 1, 0.800698,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374186,-99) , 
0, -1.2114, 1, 0, 0.452584,-99) , 
NN(
0, 
0, 
-1, -1.72922, 0, -1, 0.136017,-99) , 
3, -0.959934, 0, 0, 0.323885,-99) , 
3, 0.301115, 0, 0, 0.546546,-99)    );
  // itree = 851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.917826, 0, 1, 0.837624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26329,-99) , 
3, 1.13907, 0, 0, 0.640581,-99) , 
0, 1.16242, 1, 0, 0.731413,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595163,-99) , 
NN(
0, 
0, 
-1, -0.620572, 0, -1, 0.212335,-99) , 
3, -0.0140488, 0, 0, 0.267493,-99) , 
3, 0.306962, 0, 0, 0.456814,-99)    );
  // itree = 852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32094, 0, 1, 0.727786,-99) , 
NN(
0, 
0, 
-1, -0.793484, 0, -1, 0.230273,-99) , 
3, -0.207894, 0, 0, 0.516485,-99)    );
  // itree = 853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.143069, 1, 1, 0.874486,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372173,-99) , 
0, 0.957246, 1, 0, 0.657898,-99) , 
3, 1.42509, 0, 0, 0.717353,-99) , 
NN(
0, 
0, 
-1, -0.424447, 0, -1, 0.23148,-99) , 
3, -0.123397, 0, 0, 0.516703,-99)    );
  // itree = 854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10368, 1, 1, 0.816284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32643,-99) , 
0, -0.0750528, 1, 0, 0.55651,-99) , 
3, 0.630415, 0, 0, 0.707299,-99) , 
NN(
0, 
0, 
-1, -1.06792, 0, -1, 0.16949,-99) , 
3, -0.304384, 0, 0, 0.505698,-99)    );
  // itree = 855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42163, 0, 1, 0.746765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234783,-99) , 
0, -0.431695, 1, 0, 0.461705,-99) , 
3, 0.25374, 0, 0, 0.662154,-99) , 
NN(
0, 
0, 
-1, -1.16324, 0, -1, 0.222398,-99) , 
3, -0.420978, 0, 0, 0.517635,-99)    );
  // itree = 856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.58992, 1, 1, 0.860318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358962,-99) , 
0, 0.465064, 1, 0, 0.582668,-99) , 
3, 1.06835, 0, 0, 0.689677,-99) , 
NN(
0, 
0, 
-1, -0.82831, 0, -1, 0.225828,-99) , 
3, -0.25059, 0, 0, 0.509651,-99)    );
  // itree = 857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.807137,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257402,-99) , 
0, 0.304059, 1, 0, 0.540557,-99) , 
3, 0.649983, 0, 0, 0.692177,-99) , 
NN(
0, 
0, 
-1, -0.963382, 0, -1, 0.24299,-99) , 
3, -0.232821, 0, 0, 0.509001,-99)    );
  // itree = 858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.902137,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442674,-99) , 
0, 1.3749, 1, 0, 0.742942,-99) , 
3, 1.42073, 0, 0, 0.796354,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289243,-99) , 
0, -1.21605, 1, 0, 0.379061,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.0975374,-99) , 
3, -1.2031, 0, 0, 0.281255,-99) , 
3, 0.17816, 0, 0, 0.54469,-99)    );
  // itree = 859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.848181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391233,-99) , 
0, 0.630164, 1, 0, 0.659878,-99) , 
3, 1.00058, 0, 0, 0.761663,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310567,-99) , 
1, -0.654311, 1, 0, 0.390843,-99) , 
NN(
0, 
0, 
-1, -2.56954, 1, -1, 0.114805,-99) , 
3, -1.12464, 0, 0, 0.292467,-99) , 
3, 0.202693, 0, 0, 0.50382,-99)    );
  // itree = 860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.69117, 0, 1, 0.776645,-99) , 
NN(
0, 
0, 
-1, -1.27444, 0, -1, 0.325868,-99) , 
3, 0.301115, 0, 0, 0.523895,-99)    );
  // itree = 861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.46194, 1, 1, 0.876265,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392442,-99) , 
0, 0.854666, 1, 0, 0.628559,-99) , 
3, 1.42729, 0, 0, 0.698138,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.222976,-99) , 
3, -0.123397, 0, 0, 0.485568,-99)    );
  // itree = 862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.08282, 0, 1, 0.770836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327851,-99) , 
0, -0.146188, 1, 0, 0.532295,-99) , 
3, 0.52978, 0, 0, 0.673561,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.172915,-99) , 
3, -0.376892, 0, 0, 0.499587,-99)    );
  // itree = 863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08013, 0, 1, 0.74215,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26284,-99) , 
0, -0.390046, 1, 0, 0.428687,-99) , 
NN(
0, 
0, 
-1, -1.03116, 0, -1, 0.169312,-99) , 
3, -0.548378, 0, 0, 0.280358,-99) , 
3, 0.262941, 0, 0, 0.479682,-99)    );
  // itree = 864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15677, 1, 1, 0.83946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29879,-99) , 
0, 0.411358, 1, 0, 0.524399,-99) , 
3, 0.983057, 0, 0, 0.655473,-99) , 
NN(
0, 
0, 
-1, -0.876581, 0, -1, 0.160151,-99) , 
3, -0.376892, 0, 0, 0.475727,-99)    );
  // itree = 865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.319388, 0, 1, 0.744891,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.232091,-99) , 
3, -0.123397, 0, 0, 0.513913,-99)    );
  // itree = 866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.884836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492209,-99) , 
0, 0.481726, 1, 0, 0.663562,-99) , 
3, 1.20395, 0, 0, 0.743216,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.210008,-99) , 
3, -0.123397, 0, 0, 0.521,-99)    );
  // itree = 867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.584307, 0, 1, 0.760543,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309694,-99) , 
1, -0.252142, 1, 0, 0.430012,-99) , 
NN(
0, 
0, 
-1, -1.7832, 0, -1, 0.139687,-99) , 
3, -0.616659, 0, 0, 0.257012,-99) , 
3, 0.183842, 0, 0, 0.49851,-99)    );
  // itree = 868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.673309, 0, 1, 0.756727,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302852,-99) , 
0, -1.20938, 1, 0, 0.386497,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.131453,-99) , 
3, -1.08906, 0, 0, 0.304583,-99) , 
3, 0.262941, 0, 0, 0.508696,-99)    );
  // itree = 869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.14749, 1, 1, 0.879208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455682,-99) , 
0, 0.50797, 1, 0, 0.616099,-99) , 
3, 1.42509, 0, 0, 0.69385,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.240121,-99) , 
3, -0.123397, 0, 0, 0.501139,-99)    );
  // itree = 870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.60464, 1, 1, 0.868623,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383841,-99) , 
0, 0.92467, 1, 0, 0.643678,-99) , 
3, 1.32689, 0, 0, 0.718483,-99) , 
NN(
0, 
0, 
-1, -0.496803, 0, -1, 0.206752,-99) , 
3, -0.202496, 0, 0, 0.498877,-99)    );
  // itree = 871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.875483,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459288,-99) , 
0, -0.065981, 1, 0, 0.5924,-99) , 
3, 1.07643, 0, 0, 0.703747,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201688,-99) , 
0, -1.53471, 1, 0, 0.324886,-99) , 
NN(
0, 
0, 
-1, -0.234174, 1, -1, 0.0909819,-99) , 
3, -1.32015, 0, 0, 0.238263,-99) , 
3, -0.304384, 0, 0, 0.535167,-99)    );
  // itree = 872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56785, 1, 1, 0.867554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377531,-99) , 
0, 0.210411, 1, 0, 0.559207,-99) , 
3, 0.98281, 0, 0, 0.694144,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.203983,-99) , 
3, -0.123397, 0, 0, 0.480774,-99)    );
  // itree = 873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.702317, 1, 1, 0.754556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380253,-99) , 
0, -0.424041, 1, 0, 0.494921,-99) , 
3, 0.303142, 0, 0, 0.667358,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.174005,-99) , 
3, -0.376892, 0, 0, 0.489615,-99)    );
  // itree = 874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17751, 1, 1, 0.845556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364918,-99) , 
0, 0.123252, 1, 0, 0.552835,-99) , 
3, 0.929865, 0, 0, 0.670444,-99) , 
NN(
0, 
0, 
-1, -1.16956, 0, -1, 0.191743,-99) , 
3, -0.420978, 0, 0, 0.523496,-99)    );
  // itree = 875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30438, 0, 1, 0.845166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260607,-99) , 
0, 0.319904, 1, 0, 0.524308,-99) , 
3, 0.764338, 0, 0, 0.6974,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.207086,-99) , 
3, -0.123397, 0, 0, 0.490991,-99)    );
  // itree = 876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39222, 1, 1, 0.843217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467373,-99) , 
0, 0.454384, 1, 0, 0.632856,-99) , 
3, 1.20395, 0, 0, 0.705804,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.235027,-99) , 
3, -0.123397, 0, 0, 0.48924,-99)    );
  // itree = 877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43633, 0, 1, 0.732757,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.172601,-99) , 
3, -0.376892, 0, 0, 0.51682,-99)    );
  // itree = 878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.361931, 1, 1, 0.850791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345076,-99) , 
3, 1.16913, 0, 0, 0.625867,-99) , 
0, 0.768458, 1, 0, 0.709132,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344428,-99) , 
1, -0.50545, 1, 0, 0.44403,-99) , 
NN(
0, 
0, 
-1, -2.25891, 1, -1, 0.16619,-99) , 
3, -0.548378, 0, 0, 0.289542,-99) , 
3, 0.262941, 0, 0, 0.475645,-99)    );
  // itree = 879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11335, 0, 1, 0.803266,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280903,-99) , 
0, 0.0776309, 1, 0, 0.558367,-99) , 
3, 0.540529, 0, 0, 0.717762,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.204426,-99) , 
3, -0.123397, 0, 0, 0.480455,-99)    );
  // itree = 880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.672338, 1, 1, 0.795461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373997,-99) , 
2, -0.0844714, 1, 0, 0.504659,-99) , 
3, 0.314138, 0, 0, 0.708889,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.205063,-99) , 
3, -0.376892, 0, 0, 0.508297,-99)    );
  // itree = 881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58845, 1, 1, 0.867605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298974,-99) , 
0, 0.957246, 1, 0, 0.5945,-99) , 
3, 1.17457, 0, 0, 0.693715,-99) , 
NN(
0, 
0, 
-1, -0.933341, 0, -1, 0.221318,-99) , 
3, -0.18324, 0, 0, 0.486172,-99)    );
  // itree = 882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47863, 1, 1, 0.862851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387409,-99) , 
0, 0.298494, 1, 0, 0.590994,-99) , 
3, 0.98281, 0, 0, 0.715185,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139311,-99) , 
0, -1.20764, 1, 0, 0.272698,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.101043,-99) , 
3, -1.0146, 0, 0, 0.194273,-99) , 
3, -0.123397, 0, 0, 0.487541,-99)    );
  // itree = 883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.64827, 0, 1, 0.697827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577326,-99) , 
NN(
0, 
0, 
-1, -0.236536, 1, -1, 0.177198,-99) , 
3, -0.419849, 0, 0, 0.245522,-99) , 
3, -0.123397, 0, 0, 0.499628,-99)    );
  // itree = 884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0270664, 1, 1, 0.833802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340113,-99) , 
0, 0.676493, 1, 0, 0.613921,-99) , 
3, 1.11753, 0, 0, 0.700257,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.227839,-99) , 
3, -0.207894, 0, 0, 0.501685,-99)    );
  // itree = 885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28006, 1, 1, 0.83403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.939177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466486,-99) , 
0, 0.243676, 1, 0, 0.642131,-99) , 
3, 0.889551, 0, 0, 0.760572,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31847,-99) , 
0, -0.802449, 1, 0, 0.41709,-99) , 
NN(
0, 
0, 
-1, -1.18817, 0, -1, 0.126112,-99) , 
3, -0.644801, 0, 0, 0.267961,-99) , 
3, 0.306962, 0, 0, 0.480037,-99)    );
  // itree = 886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.858705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311721,-99) , 
0, 1.02331, 1, 0, 0.653018,-99) , 
3, 1.09287, 0, 0, 0.747081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524379,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240794,-99) , 
0, -1.03291, 1, 0, 0.369665,-99) , 
NN(
0, 
0, 
-1, -0.299856, 1, -1, 0.0843476,-99) , 
3, -0.95977, 0, 0, 0.249806,-99) , 
3, 0.10264, 0, 0, 0.511389,-99)    );
  // itree = 887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.95934, 1, 1, 0.903671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325799,-99) , 
0, 1.21212, 1, 0, 0.657839,-99) , 
3, 1.37581, 0, 0, 0.75502,-99) , 
NN(
0, 
0, 
-1, -1.20576, 0, -1, 0.309629,-99) , 
3, 0.392653, 0, 0, 0.495928,-99)    );
  // itree = 888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.8673, 1, 1, 0.86375,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481765,-99) , 
0, 0.852865, 1, 0, 0.70483,-99) , 
3, 1.2782, 0, 0, 0.775597,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269634,-99) , 
0, -0.541221, 1, 0, 0.436698,-99) , 
NN(
0, 
0, 
-1, 0.484742, 1, -1, 0.139594,-99) , 
3, -0.325669, 0, 0, 0.238935,-99) , 
3, 0.306962, 0, 0, 0.459523,-99)    );
  // itree = 889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.996069, 1, 1, 0.791697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347399,-99) , 
0, 0.256929, 1, 0, 0.583419,-99) , 
3, 0.761669, 0, 0, 0.693048,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.186758,-99) , 
3, -0.123397, 0, 0, 0.473201,-99)    );
  // itree = 890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593979, 0, 1, 0.732794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247815,-99) , 
0, -0.481374, 1, 0, 0.381798,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.135319,-99) , 
3, -0.376357, 0, 0, 0.220035,-99) , 
3, 0.17816, 0, 0, 0.458334,-99)    );
  // itree = 891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.872458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426017,-99) , 
0, 0.781704, 1, 0, 0.635742,-99) , 
3, 1.26793, 0, 0, 0.724182,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275733,-99) , 
0, -1.23094, 1, 0, 0.374791,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.1114,-99) , 
3, -1.03104, 0, 0, 0.259474,-99) , 
3, 0.0509667, 0, 0, 0.51438,-99)    );
  // itree = 892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56224, 1, 1, 0.902916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416455,-99) , 
0, 1.10293, 1, 0, 0.724522,-99) , 
3, 1.32972, 0, 0, 0.807124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329204,-99) , 
0, -1.26324, 1, 0, 0.405146,-99) , 
NN(
0, 
0, 
-1, -1.83626, 0, -1, 0.103649,-99) , 
3, -1.01678, 0, 0, 0.300453,-99) , 
3, 0.325234, 0, 0, 0.52696,-99)    );
  // itree = 893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.65988, 1, 1, 0.906814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432496,-99) , 
0, 0.91334, 1, 0, 0.636798,-99) , 
3, 1.53712, 0, 0, 0.727766,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305396,-99) , 
1, -0.213158, 1, 0, 0.401914,-99) , 
NN(
0, 
0, 
-1, -1.15404, 1, -1, 0.147496,-99) , 
3, -0.741929, 0, 0, 0.283953,-99) , 
3, 0.325234, 0, 0, 0.476171,-99)    );
  // itree = 894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78166, 1, 1, 0.829881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263306,-99) , 
0, 0.43971, 1, 0, 0.522172,-99) , 
3, 0.845703, 0, 0, 0.663031,-99) , 
NN(
0, 
0, 
-1, -0.81518, 0, -1, 0.200939,-99) , 
3, -0.304384, 0, 0, 0.485634,-99)    );
  // itree = 895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05335, 1, 1, 0.818503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409635,-99) , 
0, 0.487598, 1, 0, 0.605159,-99) , 
3, 0.812167, 0, 0, 0.736137,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252118,-99) , 
1, -0.602569, 1, 0, 0.314644,-99) , 
NN(
0, 
0, 
-1, -0.301872, 1, -1, 0.100068,-99) , 
3, -1.12137, 0, 0, 0.23898,-99) , 
3, 0.20809, 0, 0, 0.469563,-99)    );
  // itree = 896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0500582, 1, 1, 0.902993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499349,-99) , 
0, 0.985676, 1, 0, 0.735389,-99) , 
3, 1.46726, 0, 0, 0.799055,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340886,-99) , 
1, -0.384038, 1, 0, 0.436432,-99) , 
NN(
0, 
0, 
-1, 0.0305986, 1, -1, 0.0986829,-99) , 
3, -0.959342, 0, 0, 0.307828,-99) , 
3, 0.301115, 0, 0, 0.516991,-99)    );
  // itree = 897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58434, 0, 1, 0.769951,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159817,-99) , 
0, -0.429835, 1, 0, 0.387824,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.109335,-99) , 
3, -1.14976, 0, 0, 0.295908,-99) , 
3, 0.183842, 0, 0, 0.53189,-99)    );
  // itree = 898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.803726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368202,-99) , 
0, 0.465064, 1, 0, 0.608014,-99) , 
3, 0.835534, 0, 0, 0.701348,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178329,-99) , 
0, -1.19072, 1, 0, 0.315069,-99) , 
NN(
0, 
0, 
-1, 0.248005, 1, -1, 0.0920518,-99) , 
3, -1.1213, 0, 0, 0.215222,-99) , 
3, -0.25059, 0, 0, 0.520263,-99)    );
  // itree = 899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.836649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288901,-99) , 
0, 0.61377, 1, 0, 0.57564,-99) , 
3, 0.90335, 0, 0, 0.698751,-99) , 
NN(
0, 
0, 
-1, -1.13691, 0, -1, 0.208123,-99) , 
3, -0.181176, 0, 0, 0.494567,-99)    );
  // itree = 900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.838678,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321171,-99) , 
0, -0.0188443, 1, 0, 0.51829,-99) , 
3, 0.842139, 0, 0, 0.64584,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.160731,-99) , 
3, -0.639447, 0, 0, 0.504927,-99)    );
  // itree = 901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11792, 1, 1, 0.789133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265952,-99) , 
0, 0.0533187, 1, 0, 0.51485,-99) , 
3, 0.536638, 0, 0, 0.671695,-99) , 
NN(
0, 
0, 
-1, -0.890807, 0, -1, 0.157665,-99) , 
3, -0.38184, 0, 0, 0.485598,-99)    );
  // itree = 902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22572, 1, 1, 0.836686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392252,-99) , 
0, 0.587889, 1, 0, 0.593568,-99) , 
3, 0.985916, 0, 0, 0.695968,-99) , 
NN(
0, 
0, 
-1, -1.06934, 0, -1, 0.199311,-99) , 
3, -0.344168, 0, 0, 0.518735,-99)    );
  // itree = 903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26792, 0, 1, 0.795799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321354,-99) , 
0, -0.0750528, 1, 0, 0.515051,-99) , 
3, 0.526823, 0, 0, 0.69222,-99) , 
NN(
0, 
0, 
-1, -1.59136, 1, -1, 0.1865,-99) , 
3, -0.38184, 0, 0, 0.503214,-99)    );
  // itree = 904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47566, 1, 1, 0.91838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445835,-99) , 
0, 1.74488, 1, 0, 0.727789,-99) , 
3, 1.66579, 0, 0, 0.787236,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310772,-99) , 
1, -0.530717, 1, 0, 0.421947,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.105355,-99) , 
3, -0.959934, 0, 0, 0.295216,-99) , 
3, 0.306962, 0, 0, 0.510784,-99)    );
  // itree = 905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.539088, 1, 1, 0.92409,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358897,-99) , 
3, 1.33307, 0, 0, 0.674486,-99) , 
0, 0.910697, 1, 0, 0.760066,-99) , 
NN(
0, 
0, 
-1, -0.95623, 0, -1, 0.281737,-99) , 
3, 0.306962, 0, 0, 0.502408,-99)    );
  // itree = 906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0500582, 1, 1, 0.854456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36064,-99) , 
0, 1.10293, 1, 0, 0.686414,-99) , 
3, 1.20314, 0, 0, 0.760292,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410677,-99) , 
1, 0.00293303, 1, 0, 0.526171,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.162792,-99) , 
3, -0.398285, 0, 0, 0.292248,-99) , 
3, 0.238103, 0, 0, 0.503294,-99)    );
  // itree = 907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61034, 0, 1, 0.873363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437553,-99) , 
0, 0.807964, 1, 0, 0.65788,-99) , 
3, 1.28253, 0, 0, 0.753283,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351991,-99) , 
0, -0.949142, 1, 0, 0.478952,-99) , 
NN(
0, 
0, 
-1, -1.03116, 0, -1, 0.170977,-99) , 
3, -0.553771, 0, 0, 0.317198,-99) , 
3, 0.262941, 0, 0, 0.510218,-99)    );
  // itree = 908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.819328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366834,-99) , 
0, 0.620706, 1, 0, 0.628739,-99) , 
3, 1.08013, 0, 0, 0.7277,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314544,-99) , 
0, -0.804863, 1, 0, 0.440835,-99) , 
NN(
0, 
0, 
-1, -1.05072, 0, -1, 0.164601,-99) , 
3, -0.548378, 0, 0, 0.287609,-99) , 
3, 0.262941, 0, 0, 0.485299,-99)    );
  // itree = 909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05335, 1, 1, 0.789822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395948,-99) , 
1, -0.473945, 1, 0, 0.53065,-99) , 
3, 0.562559, 0, 0, 0.685387,-99) , 
NN(
0, 
0, 
-1, -0.784007, 0, -1, 0.181478,-99) , 
3, -0.307255, 0, 0, 0.487312,-99)    );
  // itree = 910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27214, 0, 1, 0.784254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389037,-99) , 
0, -0.831231, 1, 0, 0.513692,-99) , 
3, 0.295223, 0, 0, 0.690446,-99) , 
NN(
0, 
0, 
-1, -1.34547, 0, -1, 0.150841,-99) , 
3, -0.673088, 0, 0, 0.536633,-99)    );
  // itree = 911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.23356, 1, 1, 0.845517,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305073,-99) , 
0, 0.82791, 1, 0, 0.599964,-99) , 
3, 1.12392, 0, 0, 0.697796,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252565,-99) , 
0, -1.27658, 1, 0, 0.355003,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.106838,-99) , 
3, -0.99221, 0, 0, 0.249343,-99) , 
3, 0.0990605, 0, 0, 0.471332,-99)    );
  // itree = 912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.17323, 1, 1, 0.897967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331719,-99) , 
3, 1.16884, 0, 0, 0.692398,-99) , 
0, 0.731369, 1, 0, 0.755875,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289955,-99) , 
1, -0.212641, 1, 0, 0.427235,-99) , 
NN(
0, 
0, 
-1, -1.7862, 1, -1, 0.146435,-99) , 
3, -0.52447, 0, 0, 0.254241,-99) , 
3, 0.28719, 0, 0, 0.464181,-99)    );
  // itree = 913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.534012, 0, 1, 0.748657,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254891,-99) , 
0, -1.01188, 1, 0, 0.376319,-99) , 
NN(
0, 
0, 
-1, -1.78173, 0, -1, 0.152358,-99) , 
3, -0.923103, 0, 0, 0.276592,-99) , 
3, 0.135748, 0, 0, 0.521246,-99)    );
  // itree = 914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.892199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347596,-99) , 
0, 0.84413, 1, 0, 0.637859,-99) , 
3, 1.21404, 0, 0, 0.759532,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303844,-99) , 
0, -0.693462, 1, 0, 0.442695,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.110455,-99) , 
3, -0.93003, 0, 0, 0.29798,-99) , 
3, 0.17816, 0, 0, 0.519589,-99)    );
  // itree = 915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.818317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347861,-99) , 
0, -0.0316589, 1, 0, 0.579226,-99) , 
3, 0.540529, 0, 0, 0.736877,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259959,-99) , 
0, -1.11109, 1, 0, 0.388598,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.120696,-99) , 
3, -1.00886, 0, 0, 0.243239,-99) , 
3, -0.123397, 0, 0, 0.51766,-99)    );
  // itree = 916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.6037, 0, 1, 0.749605,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294633,-99) , 
0, -0.789177, 1, 0, 0.434395,-99) , 
NN(
0, 
0, 
-1, -1.80475, 1, -1, 0.139502,-99) , 
3, -0.587974, 0, 0, 0.27143,-99) , 
3, 0.20809, 0, 0, 0.498202,-99)    );
  // itree = 917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.861789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375531,-99) , 
0, 0.905235, 1, 0, 0.665081,-99) , 
3, 1.1686, 0, 0, 0.759965,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293094,-99) , 
0, -0.616482, 1, 0, 0.46843,-99) , 
NN(
0, 
0, 
-1, -1.44076, 1, -1, 0.147623,-99) , 
3, -0.414216, 0, 0, 0.258324,-99) , 
3, 0.207882, 0, 0, 0.485084,-99)    );
  // itree = 918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19067, 1, 1, 0.866372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312179,-99) , 
0, 0.708301, 1, 0, 0.568241,-99) , 
3, 1.2063, 0, 0, 0.672877,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.130501,-99) , 
0, -1.21605, 1, 0, 0.268137,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0827848,-99) , 
3, -1.00886, 0, 0, 0.186974,-99) , 
3, -0.123397, 0, 0, 0.458582,-99)    );
  // itree = 919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15677, 1, 1, 0.876312,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361726,-99) , 
0, 0.647916, 1, 0, 0.629401,-99) , 
3, 0.985321, 0, 0, 0.743013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.141639,-99) , 
0, -1.21605, 1, 0, 0.337702,-99) , 
NN(
0, 
0, 
-1, -0.0310174, 1, -1, 0.111944,-99) , 
3, -1.0136, 0, 0, 0.231566,-99) , 
3, -0.123397, 0, 0, 0.529372,-99)    );
  // itree = 920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.06751, 1, 1, 0.855479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493601,-99) , 
0, 1.02702, 1, 0, 0.697467,-99) , 
3, 1.28253, 0, 0, 0.762495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620811,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295201,-99) , 
0, -0.765399, 1, 0, 0.395449,-99) , 
NN(
0, 
0, 
-1, -1.26187, 0, -1, 0.142863,-99) , 
3, -0.548378, 0, 0, 0.25651,-99) , 
3, 0.262941, 0, 0, 0.483381,-99)    );
  // itree = 921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.885557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414814,-99) , 
0, 1.19549, 1, 0, 0.670044,-99) , 
3, 1.29603, 0, 0, 0.780851,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259824,-99) , 
0, -0.0750528, 1, 0, 0.47072,-99) , 
NN(
0, 
0, 
-1, -1.08061, 0, -1, 0.187193,-99) , 
3, -0.320912, 0, 0, 0.308193,-99) , 
3, 0.569166, 0, 0, 0.479269,-99)    );
  // itree = 922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.939287, 0, 1, 0.861521,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391589,-99) , 
3, 1.39432, 0, 0, 0.66472,-99) , 
0, 1.06599, 1, 0, 0.752068,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38707,-99) , 
3, -0.0378983, 0, 0, 0.483953,-99) , 
NN(
0, 
0, 
-1, -1.54109, 0, -1, 0.154459,-99) , 
3, -0.394308, 0, 0, 0.265296,-99) , 
3, 0.234307, 0, 0, 0.486331,-99)    );
  // itree = 923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.409401, 1, 1, 0.877014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409606,-99) , 
3, 1.30192, 0, 0, 0.694633,-99) , 
0, 1.09855, 1, 0, 0.772794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348222,-99) , 
1, -0.35632, 1, 0, 0.467257,-99) , 
NN(
0, 
0, 
-1, -2.0971, 1, -1, 0.136131,-99) , 
3, -0.702968, 0, 0, 0.289938,-99) , 
3, 0.234307, 0, 0, 0.51375,-99)    );
  // itree = 924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.616454, 1, 1, 0.818217,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282143,-99) , 
0, -0.765399, 1, 0, 0.429681,-99) , 
NN(
0, 
0, 
-1, -1.75934, 1, -1, 0.140245,-99) , 
3, -0.651936, 0, 0, 0.26063,-99) , 
3, 0.17816, 0, 0, 0.507026,-99)    );
  // itree = 925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.698745, 1, 1, 0.764735,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276429,-99) , 
0, -0.676329, 1, 0, 0.410442,-99) , 
NN(
0, 
0, 
-1, -1.44076, 1, -1, 0.176591,-99) , 
3, -0.326848, 0, 0, 0.260424,-99) , 
3, 0.306962, 0, 0, 0.467752,-99)    );
  // itree = 926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09855, 1, 1, 0.753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482992,-99) , 
3, 0.234651, 0, 0, 0.695535,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.216455,-99) , 
3, -0.207894, 0, 0, 0.509423,-99)    );
  // itree = 927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58391, 1, 1, 0.835266,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356195,-99) , 
0, 0.708301, 1, 0, 0.608261,-99) , 
3, 1.15111, 0, 0, 0.692834,-99) , 
NN(
0, 
0, 
-1, -0.864394, 0, -1, 0.195346,-99) , 
3, -0.147314, 0, 0, 0.472266,-99)    );
  // itree = 928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.795848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335125,-99) , 
0, 0.326902, 1, 0, 0.531715,-99) , 
3, 0.84679, 0, 0, 0.651542,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.220509,-99) , 
3, -0.304384, 0, 0, 0.48538,-99)    );
  // itree = 929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.870701,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495927,-99) , 
0, -0.15841, 1, 0, 0.607231,-99) , 
3, 1.2819, 0, 0, 0.694718,-99) , 
NN(
0, 
0, 
-1, -1.12289, 0, -1, 0.208649,-99) , 
3, -0.25059, 0, 0, 0.505571,-99)    );
  // itree = 930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.45341, 1, 1, 0.889656,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.893466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470772,-99) , 
0, 0.900482, 1, 0, 0.67668,-99) , 
3, 1.47173, 0, 0, 0.756241,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343204,-99) , 
0, -1.44513, 1, 0, 0.419696,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.0883657,-99) , 
3, -0.959868, 0, 0, 0.29075,-99) , 
3, 0.306962, 0, 0, 0.495531,-99)    );
  // itree = 931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.250256, 0, 1, 0.731525,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189112,-99) , 
0, -1.19072, 1, 0, 0.323225,-99) , 
NN(
0, 
0, 
-1, -0.0381096, 1, -1, 0.104849,-99) , 
3, -1.07815, 0, 0, 0.225167,-99) , 
3, -0.202496, 0, 0, 0.518477,-99)    );
  // itree = 932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.130673, 1, 1, 0.898581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455737,-99) , 
3, 1.30983, 0, 0, 0.701919,-99) , 
0, 0.785602, 1, 0, 0.772205,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395007,-99) , 
1, -0.373917, 1, 0, 0.502129,-99) , 
NN(
0, 
0, 
-1, -1.22523, 0, -1, 0.192463,-99) , 
3, -0.372166, 0, 0, 0.304021,-99) , 
3, 0.254861, 0, 0, 0.518106,-99)    );
  // itree = 933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.143069, 1, 1, 0.905458,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349951,-99) , 
0, 0.854666, 1, 0, 0.635805,-99) , 
3, 1.36591, 0, 0, 0.722575,-99) , 
NN(
0, 
0, 
-1, -1.33619, 0, -1, 0.240461,-99) , 
3, -0.145253, 0, 0, 0.528724,-99)    );
  // itree = 934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.858873,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384123,-99) , 
0, 0.544687, 1, 0, 0.588486,-99) , 
3, 1.30512, 0, 0, 0.674662,-99) , 
NN(
0, 
0, 
-1, -1.07057, 0, -1, 0.230317,-99) , 
3, -0.304384, 0, 0, 0.50592,-99)    );
  // itree = 935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.868667,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282492,-99) , 
0, 1.16519, 1, 0, 0.573759,-99) , 
3, 1.30662, 0, 0, 0.664881,-99) , 
NN(
0, 
0, 
-1, -1.06792, 0, -1, 0.207185,-99) , 
3, -0.304384, 0, 0, 0.499541,-99)    );
  // itree = 936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91719, 1, 1, 0.835217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344798,-99) , 
0, 0.738333, 1, 0, 0.606807,-99) , 
3, 1.07541, 0, 0, 0.697533,-99) , 
NN(
0, 
0, 
-1, -0.818251, 0, -1, 0.221338,-99) , 
3, -0.304384, 0, 0, 0.516211,-99)    );
  // itree = 937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.322371, 0, 1, 0.703038,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.201712,-99) , 
3, -0.123397, 0, 0, 0.485488,-99)    );
  // itree = 938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57159, 0, 1, 0.871304,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347115,-99) , 
0, 0.449644, 1, 0, 0.567628,-99) , 
3, 1.10245, 0, 0, 0.679838,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158658,-99) , 
0, -1.18308, 1, 0, 0.284844,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.106564,-99) , 
3, -1.09397, 0, 0, 0.20306,-99) , 
3, -0.207894, 0, 0, 0.473275,-99)    );
  // itree = 939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.854855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440191,-99) , 
0, 0.614664, 1, 0, 0.669042,-99) , 
3, 1.07833, 0, 0, 0.766344,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233004,-99) , 
0, -0.538822, 1, 0, 0.409887,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.15318,-99) , 
3, -0.549899, 0, 0, 0.264617,-99) , 
3, 0.262941, 0, 0, 0.491506,-99)    );
  // itree = 940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12586, 0, 1, 0.826564,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312392,-99) , 
0, 0.281825, 1, 0, 0.588241,-99) , 
3, 0.761669, 0, 0, 0.726521,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.243991,-99) , 
3, -0.123397, 0, 0, 0.520837,-99)    );
  // itree = 941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.87868, 1, 1, 0.869103,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3766,-99) , 
0, 0.84413, 1, 0, 0.652429,-99) , 
3, 1.21436, 0, 0, 0.741002,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214872,-99) , 
0, -0.460067, 1, 0, 0.445315,-99) , 
NN(
0, 
0, 
-1, -0.562049, 1, -1, 0.139677,-99) , 
3, -0.93003, 0, 0, 0.317861,-99) , 
3, 0.17816, 0, 0, 0.527692,-99)    );
  // itree = 942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.484788, 0, 1, 0.848153,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488682,-99) , 
3, 1.67687, 0, 0, 0.694321,-99) , 
0, 1.49362, 1, 0, 0.784707,-99) , 
NN(
0, 
0, 
-1, -0.376357, 0, -1, 0.262729,-99) , 
3, 0.17816, 0, 0, 0.510805,-99)    );
  // itree = 943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.882426,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465782,-99) , 
0, 0.789761, 1, 0, 0.668278,-99) , 
3, 1.32489, 0, 0, 0.738566,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247216,-99) , 
1, 0.151245, 1, 0, 0.382676,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.113293,-99) , 
3, -0.997451, 0, 0, 0.269752,-99) , 
3, 0.093663, 0, 0, 0.523573,-99)    );
  // itree = 944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.443758, 1, 1, 0.945515,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452873,-99) , 
3, 1.13907, 0, 0, 0.702394,-99) , 
0, 0.709428, 1, 0, 0.773246,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406169,-99) , 
1, -0.763581, 1, 0, 0.48836,-99) , 
NN(
0, 
0, 
-1, -1.72234, 0, -1, 0.176852,-99) , 
3, -0.64095, 0, 0, 0.345846,-99) , 
3, 0.306962, 0, 0, 0.527996,-99)    );
  // itree = 945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.856678,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304048,-99) , 
0, 0.824212, 1, 0, 0.566939,-99) , 
3, 1.09138, 0, 0, 0.663182,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.154941,-99) , 
3, -0.639447, 0, 0, 0.518777,-99)    );
  // itree = 946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90389, 1, 1, 0.871993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307829,-99) , 
0, 1.1005, 1, 0, 0.628051,-99) , 
3, 1.26767, 0, 0, 0.710397,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382893,-99) , 
1, 0.0480792, 1, 0, 0.461746,-99) , 
NN(
0, 
0, 
-1, -0.0510862, 1, -1, 0.171306,-99) , 
3, -0.76155, 0, 0, 0.297003,-99) , 
3, 0.0509667, 0, 0, 0.514928,-99)    );
  // itree = 947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.864377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289589,-99) , 
0, 1.22611, 1, 0, 0.633802,-99) , 
3, 1.20395, 0, 0, 0.718723,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190314,-99) , 
0, -1.21605, 1, 0, 0.350695,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.107141,-99) , 
3, -1.00946, 0, 0, 0.235379,-99) , 
3, -0.123397, 0, 0, 0.522211,-99)    );
  // itree = 948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.963341, 1, 1, 0.827507,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250411,-99) , 
0, 0.553084, 1, 0, 0.542572,-99) , 
3, 0.831383, 0, 0, 0.680416,-99) , 
NN(
0, 
0, 
-1, -1.02307, 0, -1, 0.220315,-99) , 
3, -0.28269, 0, 0, 0.506491,-99)    );
  // itree = 949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.453832, 1, 1, 0.845119,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413876,-99) , 
0, 0.154453, 1, 0, 0.55912,-99) , 
3, 1.0198, 0, 0, 0.665315,-99) , 
NN(
0, 
0, 
-1, -1.0169, 0, -1, 0.184685,-99) , 
3, -0.294298, 0, 0, 0.48823,-99)    );
  // itree = 950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.289114, 1, 1, 0.933217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439253,-99) , 
3, 1.08238, 0, 0, 0.754031,-99) , 
0, 0.768458, 1, 0, 0.803017,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258934,-99) , 
0, -0.307105, 1, 0, 0.463516,-99) , 
NN(
0, 
0, 
-1, -1.36539, 1, -1, 0.205977,-99) , 
3, -0.336159, 0, 0, 0.300591,-99) , 
3, 0.301115, 0, 0, 0.508872,-99)    );
  // itree = 951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.68935, 1, 1, 0.889467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333699,-99) , 
0, 0.964063, 1, 0, 0.663026,-99) , 
3, 1.21918, 0, 0, 0.76726,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27293,-99) , 
0, -1.21855, 1, 0, 0.36286,-99) , 
NN(
0, 
0, 
-1, -2.07473, 0, -1, 0.117625,-99) , 
3, -1.21239, 0, 0, 0.278374,-99) , 
3, 0.17816, 0, 0, 0.525734,-99)    );
  // itree = 952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50474, 1, 1, 0.772539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485151,-99) , 
3, 0.250915, 0, 0, 0.701234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169453,-99) , 
0, -1.38537, 1, 0, 0.276725,-99) , 
NN(
0, 
0, 
-1, -2.93551, 1, -1, 0.086909,-99) , 
3, -1.3748, 0, 0, 0.19974,-99) , 
3, -0.207894, 0, 0, 0.492198,-99)    );
  // itree = 953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.786392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277461,-99) , 
0, 0.168185, 1, 0, 0.52456,-99) , 
3, 0.540529, 0, 0, 0.690158,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.205462,-99) , 
3, -0.123397, 0, 0, 0.468431,-99)    );
  // itree = 954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2161, 0, 1, 0.725526,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230376,-99) , 
0, -1.20764, 1, 0, 0.321325,-99) , 
NN(
0, 
0, 
-1, -0.239497, 1, -1, 0.104016,-99) , 
3, -1.06338, 0, 0, 0.228569,-99) , 
3, 0.00760208, 0, 0, 0.482226,-99)    );
  // itree = 955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.886675,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459629,-99) , 
0, 0.856209, 1, 0, 0.693867,-99) , 
3, 1.3922, 0, 0, 0.768519,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392082,-99) , 
0, -0.495227, 1, 0, 0.476532,-99) , 
NN(
0, 
0, 
-1, -1.51673, 0, -1, 0.175598,-99) , 
3, -0.386214, 0, 0, 0.286038,-99) , 
3, 0.238103, 0, 0, 0.507782,-99)    );
  // itree = 956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.18906, 1, 1, 0.845232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48671,-99) , 
0, 0.240286, 1, 0, 0.616225,-99) , 
3, 1.18038, 0, 0, 0.706143,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192953,-99) , 
0, -1.21605, 1, 0, 0.311679,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.118069,-99) , 
3, -1.14385, 0, 0, 0.232315,-99) , 
3, -0.160313, 0, 0, 0.502275,-99)    );
  // itree = 957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66904, 0, 1, 0.821381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263795,-99) , 
0, 0.733197, 1, 0, 0.590611,-99) , 
3, 0.985321, 0, 0, 0.69585,-99) , 
NN(
0, 
0, 
-1, -0.71804, 0, -1, 0.239688,-99) , 
3, -0.123397, 0, 0, 0.511341,-99)    );
  // itree = 958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.864106,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299672,-99) , 
0, 0.81106, 1, 0, 0.609895,-99) , 
3, 1.07875, 0, 0, 0.750013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253681,-99) , 
0, -0.312245, 1, 0, 0.416596,-99) , 
NN(
0, 
0, 
-1, -2.61108, 1, -1, 0.124983,-99) , 
3, -0.959342, 0, 0, 0.311676,-99) , 
3, 0.301115, 0, 0, 0.513039,-99)    );
  // itree = 959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.9521, 1, 1, 0.81416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254336,-99) , 
0, 0.43971, 1, 0, 0.524495,-99) , 
3, 0.764566, 0, 0, 0.660135,-99) , 
NN(
0, 
0, 
-1, -1.37929, 1, -1, 0.190963,-99) , 
3, -0.376892, 0, 0, 0.503233,-99)    );
  // itree = 960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31116, 0, 1, 0.764966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391098,-99) , 
1, -0.31541, 1, 0, 0.510407,-99) , 
3, 0.305972, 0, 0, 0.694091,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230263,-99) , 
0, -1.35582, 1, 0, 0.33604,-99) , 
NN(
0, 
0, 
-1, -2.6259, 1, -1, 0.105317,-99) , 
3, -1.12925, 0, 0, 0.233661,-99) , 
3, -0.140969, 0, 0, 0.498851,-99)    );
  // itree = 961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90389, 1, 1, 0.849563,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365974,-99) , 
0, 0.428155, 1, 0, 0.591022,-99) , 
3, 1.1649, 0, 0, 0.673027,-99) , 
NN(
0, 
0, 
-1, -1.57724, 0, -1, 0.192338,-99) , 
3, -0.366527, 0, 0, 0.507985,-99)    );
  // itree = 962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.830813,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414093,-99) , 
0, 0.0125345, 1, 0, 0.64207,-99) , 
3, 0.543354, 0, 0, 0.764008,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.216041,-99) , 
3, -0.123397, 0, 0, 0.524737,-99)    );
  // itree = 963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.14991, 1, 1, 0.853795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279026,-99) , 
0, 0.891, 1, 0, 0.619322,-99) , 
3, 1.10862, 0, 0, 0.710303,-99) , 
NN(
0, 
0, 
-1, -0.502825, 0, -1, 0.235405,-99) , 
3, -0.202496, 0, 0, 0.511806,-99)    );
  // itree = 964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1487, 1, 1, 0.867684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400634,-99) , 
0, 1.15378, 1, 0, 0.676083,-99) , 
3, 1.42967, 0, 0, 0.728779,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.207072,-99) , 
3, -0.123397, 0, 0, 0.503648,-99)    );
  // itree = 965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31464, 0, 1, 0.838489,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270184,-99) , 
0, 0.708301, 1, 0, 0.575326,-99) , 
3, 0.971511, 0, 0, 0.692901,-99) , 
NN(
0, 
0, 
-1, -1.37278, 0, -1, 0.18735,-99) , 
3, -0.140969, 0, 0, 0.478452,-99)    );
  // itree = 966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.874496,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432014,-99) , 
0, 0.245926, 1, 0, 0.607111,-99) , 
3, 1.0489, 0, 0, 0.711726,-99) , 
NN(
0, 
0, 
-1, -1.03187, 0, -1, 0.1618,-99) , 
3, -0.287638, 0, 0, 0.500951,-99)    );
  // itree = 967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.855679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413112,-99) , 
0, 0.745872, 1, 0, 0.658463,-99) , 
3, 0.979531, 0, 0, 0.760887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512631,-99) , 
NN(
0, 
0, 
-1, -1.10867, 0, -1, 0.17445,-99) , 
3, -0.0943153, 0, 0, 0.234868,-99) , 
3, 0.178444, 0, 0, 0.48415,-99)    );
  // itree = 968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.845582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308241,-99) , 
0, 0.893448, 1, 0, 0.624911,-99) , 
3, 1.08418, 0, 0, 0.747054,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329533,-99) , 
0, -1.2877, 1, 0, 0.409279,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.10542,-99) , 
3, -0.95623, 0, 0, 0.297889,-99) , 
3, 0.306962, 0, 0, 0.509965,-99)    );
  // itree = 969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11792, 1, 1, 0.783116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474104,-99) , 
3, 0.387115, 0, 0, 0.733237,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316464,-99) , 
0, -0.661533, 1, 0, 0.487087,-99) , 
NN(
0, 
0, 
-1, -1.46184, 1, -1, 0.190073,-99) , 
3, -0.35011, 0, 0, 0.301638,-99) , 
3, 0.183842, 0, 0, 0.509165,-99)    );
  // itree = 970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.886242,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442554,-99) , 
0, 0.614269, 1, 0, 0.628158,-99) , 
3, 1.32511, 0, 0, 0.714478,-99) , 
NN(
0, 
0, 
-1, -0.703499, 0, -1, 0.202093,-99) , 
3, -0.213477, 0, 0, 0.502489,-99)    );
  // itree = 971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.836259,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329966,-99) , 
0, 0.713978, 1, 0, 0.572145,-99) , 
3, 1.03115, 0, 0, 0.687578,-99) , 
NN(
0, 
0, 
-1, -0.842422, 0, -1, 0.249865,-99) , 
3, -0.266059, 0, 0, 0.507258,-99)    );
  // itree = 972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49244, 0, 1, 0.80664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281207,-99) , 
0, 0.00972073, 1, 0, 0.514099,-99) , 
3, 0.543354, 0, 0, 0.694978,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.163414,-99) , 
0, -1.42757, 1, 0, 0.261829,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.0830376,-99) , 
3, -1.30623, 0, 0, 0.198508,-99) , 
3, -0.123397, 0, 0, 0.483608,-99)    );
  // itree = 973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11335, 0, 1, 0.790066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.958653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32757,-99) , 
0, -0.201627, 1, 0, 0.514547,-99) , 
3, 0.543354, 0, 0, 0.68971,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.173009,-99) , 
3, -0.123397, 0, 0, 0.453726,-99)    );
  // itree = 974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.869624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43388,-99) , 
0, 1.06604, 1, 0, 0.655184,-99) , 
3, 1.45298, 0, 0, 0.730599,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325757,-99) , 
0, -1.21855, 1, 0, 0.413566,-99) , 
NN(
0, 
0, 
-1, -1.62863, 0, -1, 0.103469,-99) , 
3, -1.02461, 0, 0, 0.306535,-99) , 
3, 0.279658, 0, 0, 0.493455,-99)    );
  // itree = 975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.843298,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428885,-99) , 
0, 0.713767, 1, 0, 0.659422,-99) , 
3, 1.17653, 0, 0, 0.748801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292812,-99) , 
3, 0.138023, 0, 0, 0.345482,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.0791412,-99) , 
3, -0.926025, 0, 0, 0.249515,-99) , 
3, 0.389233, 0, 0, 0.433896,-99)    );
  // itree = 976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.12438, 0, 1, 0.824913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23177,-99) , 
0, -0.102501, 1, 0, 0.500714,-99) , 
3, 0.555268, 0, 0, 0.710428,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201065,-99) , 
0, -1.515, 1, 0, 0.282974,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.0744693,-99) , 
3, -1.31949, 0, 0, 0.2063,-99) , 
3, -0.10679, 0, 0, 0.476647,-99)    );
  // itree = 977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29221, 1, 1, 0.845546,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313129,-99) , 
0, 0.193081, 1, 0, 0.587197,-99) , 
3, 0.772751, 0, 0, 0.73002,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.225853,-99) , 
3, -0.123397, 0, 0, 0.503226,-99)    );
  // itree = 978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.79865, 0, 1, 0.846196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225575,-99) , 
0, 0.957246, 1, 0, 0.571218,-99) , 
3, 1.1518, 0, 0, 0.675864,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151733,-99) , 
0, -1.29706, 1, 0, 0.298584,-99) , 
NN(
0, 
0, 
-1, -2.65144, 1, -1, 0.0622762,-99) , 
3, -1.2031, 0, 0, 0.195822,-99) , 
3, -0.210183, 0, 0, 0.489221,-99)    );
  // itree = 979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.709428, 1, 1, 0.783304,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30708,-99) , 
0, -1.05182, 1, 0, 0.399203,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0788317,-99) , 
3, -0.95623, 0, 0, 0.26573,-99) , 
3, 0.306962, 0, 0, 0.489619,-99)    );
  // itree = 980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53429, 0, 1, 0.865279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416428,-99) , 
0, 0.540099, 1, 0, 0.617854,-99) , 
3, 1.21925, 0, 0, 0.713705,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.220927,-99) , 
3, -0.123397, 0, 0, 0.508366,-99)    );
  // itree = 981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.84932,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.942919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30694,-99) , 
0, 0.614664, 1, 0, 0.651,-99) , 
3, 0.982711, 0, 0, 0.770848,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321857,-99) , 
0, -0.773268, 1, 0, 0.453451,-99) , 
NN(
0, 
0, 
-1, -1.76953, 1, -1, 0.170798,-99) , 
3, -0.566981, 0, 0, 0.298975,-99) , 
3, 0.392653, 0, 0, 0.493887,-99)    );
  // itree = 982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.874041,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827643,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477641,-99) , 
0, -0.125685, 1, 0, 0.590725,-99) , 
3, 1.10862, 0, 0, 0.712234,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.243204,-99) , 
3, -0.202496, 0, 0, 0.530307,-99)    );
  // itree = 983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.777489, 1, 1, 0.808001,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263442,-99) , 
0, 0.210433, 1, 0, 0.524529,-99) , 
3, 0.672086, 0, 0, 0.675997,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.186504,-99) , 
3, -0.202496, 0, 0, 0.484211,-99)    );
  // itree = 984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.834757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416103,-99) , 
0, 0.426521, 1, 0, 0.611955,-99) , 
3, 0.8224, 0, 0, 0.764164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280051,-99) , 
0, -0.765399, 1, 0, 0.406942,-99) , 
NN(
0, 
0, 
-1, -1.75375, 1, -1, 0.165187,-99) , 
3, -0.565983, 0, 0, 0.265305,-99) , 
3, 0.228725, 0, 0, 0.498501,-99)    );
  // itree = 985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2375, 1, 1, 0.884369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342099,-99) , 
0, 0.9386, 1, 0, 0.673753,-99) , 
3, 1.17923, 0, 0, 0.78557,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242063,-99) , 
0, -0.128636, 1, 0, 0.488027,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.166166,-99) , 
3, -0.566981, 0, 0, 0.32157,-99) , 
3, 0.392653, 0, 0, 0.521739,-99)    );
  // itree = 986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.18906, 1, 1, 0.894731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461966,-99) , 
0, 0.163351, 1, 0, 0.595986,-99) , 
3, 1.33028, 0, 0, 0.68828,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.183675,-99) , 
3, -0.202496, 0, 0, 0.469164,-99)    );
  // itree = 987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05335, 1, 1, 0.822249,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243854,-99) , 
0, 0.418274, 1, 0, 0.523977,-99) , 
3, 0.767614, 0, 0, 0.669749,-99) , 
NN(
0, 
0, 
-1, -1.37508, 0, -1, 0.145312,-99) , 
3, -0.376892, 0, 0, 0.473254,-99)    );
  // itree = 988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.997852, 1, 1, 0.828821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241774,-99) , 
0, 0.459356, 1, 0, 0.493828,-99) , 
3, 0.847414, 0, 0, 0.638218,-99) , 
NN(
0, 
0, 
-1, -1.32015, 0, -1, 0.173896,-99) , 
3, -0.304384, 0, 0, 0.459945,-99)    );
  // itree = 989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1737, 1, 1, 0.843674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432861,-99) , 
0, 0.262307, 1, 0, 0.618751,-99) , 
3, 0.995911, 0, 0, 0.725137,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.24063,-99) , 
3, -0.123397, 0, 0, 0.514781,-99)    );
  // itree = 990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66905, 0, 1, 0.888852,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386131,-99) , 
0, 0.865705, 1, 0, 0.647244,-99) , 
3, 1.3949, 0, 0, 0.739113,-99) , 
NN(
0, 
0, 
-1, -1.3225, 0, -1, 0.263108,-99) , 
3, 0.238103, 0, 0, 0.488767,-99)    );
  // itree = 991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.72917, 1, 1, 0.859342,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279812,-99) , 
0, 1.28487, 1, 0, 0.608723,-99) , 
3, 1.33772, 0, 0, 0.679699,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.208878,-99) , 
3, -0.202496, 0, 0, 0.467513,-99)    );
  // itree = 992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40491, 0, 1, 0.847843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332281,-99) , 
0, 0.478161, 1, 0, 0.576311,-99) , 
3, 1.07541, 0, 0, 0.678234,-99) , 
NN(
0, 
0, 
-1, -1.06797, 0, -1, 0.195807,-99) , 
3, -0.304384, 0, 0, 0.518949,-99)    );
  // itree = 993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49435, 1, 1, 0.84272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324431,-99) , 
0, 0.852865, 1, 0, 0.63718,-99) , 
3, 1.08657, 0, 0, 0.74739,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302198,-99) , 
1, -0.704456, 1, 0, 0.397052,-99) , 
NN(
0, 
0, 
-1, 0.246493, 1, -1, 0.114788,-99) , 
3, -0.957285, 0, 0, 0.28163,-99) , 
3, 0.306962, 0, 0, 0.487792,-99)    );
  // itree = 994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7717, 1, 1, 0.858447,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315993,-99) , 
0, 0.570853, 1, 0, 0.593079,-99) , 
3, 0.936871, 0, 0, 0.735783,-99) , 
NN(
0, 
0, 
-1, -1.17383, 0, -1, 0.254492,-99) , 
3, 0.144527, 0, 0, 0.498557,-99)    );
  // itree = 995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.847422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256772,-99) , 
0, 1.0116, 1, 0, 0.622739,-99) , 
3, 1.07702, 0, 0, 0.70736,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.199128,-99) , 
3, -0.304384, 0, 0, 0.520339,-99)    );
  // itree = 996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.62742, 0, 1, 0.749774,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28517,-99) , 
1, -0.472421, 1, 0, 0.363382,-99) , 
NN(
0, 
0, 
-1, -3.02041, 1, -1, 0.0658616,-99) , 
3, -1.20546, 0, 0, 0.265273,-99) , 
3, 0.17816, 0, 0, 0.496158,-99)    );
  // itree = 997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.861072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311965,-99) , 
0, 0.789761, 1, 0, 0.621862,-99) , 
3, 1.11481, 0, 0, 0.728688,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228863,-99) , 
0, -0.538822, 1, 0, 0.377191,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.131308,-99) , 
3, -0.993962, 0, 0, 0.282246,-99) , 
3, 0.093663, 0, 0, 0.501206,-99)    );
  // itree = 998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.413161, 1, 1, 0.916104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356414,-99) , 
3, 0.816626, 0, 0, 0.68806,-99) , 
0, 0.29393, 1, 0, 0.748009,-99) , 
NN(
0, 
0, 
-1, -0.555838, 0, -1, 0.237589,-99) , 
3, -0.0698586, 0, 0, 0.518199,-99)    );
  // itree = 999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57971, 1, 1, 0.871944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284091,-99) , 
0, 0.969877, 1, 0, 0.657416,-99) , 
3, 1.08263, 0, 0, 0.766272,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258998,-99) , 
0, -0.192873, 1, 0, 0.471262,-99) , 
NN(
0, 
0, 
-1, -2.14578, 1, -1, 0.183777,-99) , 
3, -0.329735, 0, 0, 0.296838,-99) , 
3, 0.301115, 0, 0, 0.505522,-99)    );
  // itree = 1000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.871969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375992,-99) , 
0, 1.39416, 1, 0, 0.680589,-99) , 
3, 1.41125, 0, 0, 0.749194,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287407,-99) , 
0, -1.27242, 1, 0, 0.389335,-99) , 
NN(
0, 
0, 
-1, -0.0126254, 1, -1, 0.128517,-99) , 
3, -0.998831, 0, 0, 0.302492,-99) , 
3, 0.254861, 0, 0, 0.513119,-99)    );
  // itree = 1001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.165166, 1, 1, 0.944178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488827,-99) , 
3, 1.20293, 0, 0, 0.739103,-99) , 
0, 0.616454, 1, 0, 0.798911,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297496,-99) , 
0, -0.43878, 1, 0, 0.42361,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.185258,-99) , 
3, -0.391132, 0, 0, 0.278614,-99) , 
3, 0.234307, 0, 0, 0.519785,-99)    );
  // itree = 1002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.857725,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264099,-99) , 
0, 0.829735, 1, 0, 0.567564,-99) , 
3, 1.12023, 0, 0, 0.682181,-99) , 
NN(
0, 
0, 
-1, -0.502825, 0, -1, 0.219412,-99) , 
3, -0.202496, 0, 0, 0.478029,-99)    );
  // itree = 1003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.136039, 0, 1, 0.923872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305213,-99) , 
3, 1.08238, 0, 0, 0.661579,-99) , 
0, 0.7846, 1, 0, 0.743395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617741,-99) , 
NN(
0, 
0, 
-1, -1.22192, 0, -1, 0.230203,-99) , 
3, -0.0214303, 0, 0, 0.28545,-99) , 
3, 0.301115, 0, 0, 0.492767,-99)    );
  // itree = 1004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1598, 1, 1, 0.863122,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354731,-99) , 
0, 0.777626, 1, 0, 0.631403,-99) , 
3, 1.07875, 0, 0, 0.764004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640867,-99) , 
NN(
0, 
0, 
-1, -0.619696, 0, -1, 0.223821,-99) , 
3, -0.0140488, 0, 0, 0.286631,-99) , 
3, 0.301115, 0, 0, 0.497395,-99)    );
  // itree = 1005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.26929, 1, 1, 0.872171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302354,-99) , 
0, 1.10293, 1, 0, 0.646922,-99) , 
3, 1.28411, 0, 0, 0.736456,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244098,-99) , 
0, -0.230985, 1, 0, 0.436183,-99) , 
NN(
0, 
0, 
-1, -1.48323, 0, -1, 0.145782,-99) , 
3, -0.818721, 0, 0, 0.293295,-99) , 
3, 0.262941, 0, 0, 0.496989,-99)    );
  // itree = 1006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.833034,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405723,-99) , 
0, 0.210433, 1, 0, 0.596778,-99) , 
3, 0.685243, 0, 0, 0.736604,-99) , 
NN(
0, 
0, 
-1, -0.787763, 0, -1, 0.164421,-99) , 
3, -0.202496, 0, 0, 0.501775,-99)    );
  // itree = 1007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40844, 0, 1, 0.778032,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242235,-99) , 
0, 0.149115, 1, 0, 0.500452,-99) , 
3, 0.520249, 0, 0, 0.661159,-99) , 
NN(
0, 
0, 
-1, -1.09646, 0, -1, 0.171312,-99) , 
3, -0.357125, 0, 0, 0.483889,-99)    );
  // itree = 1008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56785, 1, 1, 0.844125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298484,-99) , 
0, 0.781704, 1, 0, 0.613499,-99) , 
3, 0.995911, 0, 0, 0.714288,-99) , 
NN(
0, 
0, 
-1, -0.71804, 0, -1, 0.207146,-99) , 
3, -0.123397, 0, 0, 0.487513,-99)    );
  // itree = 1009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.85449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365966,-99) , 
0, 0.877072, 1, 0, 0.633224,-99) , 
3, 1.31943, 0, 0, 0.710217,-99) , 
NN(
0, 
0, 
-1, -0.939031, 0, -1, 0.206118,-99) , 
3, -0.213477, 0, 0, 0.511729,-99)    );
  // itree = 1010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5578, 1, 1, 0.873115,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382011,-99) , 
0, 0.793469, 1, 0, 0.652553,-99) , 
3, 1.20395, 0, 0, 0.734475,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.22887,-99) , 
3, -0.123397, 0, 0, 0.510417,-99)    );
  // itree = 1011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.494317, 0, 1, 0.842466,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323422,-99) , 
3, 1.29603, 0, 0, 0.641111,-99) , 
0, 1.06258, 1, 0, 0.729916,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351198,-99) , 
3, -0.0132253, 0, 0, 0.459198,-99) , 
NN(
0, 
0, 
-1, -1.20105, 1, -1, 0.179667,-99) , 
3, -0.40511, 0, 0, 0.276702,-99) , 
3, 0.218994, 0, 0, 0.477755,-99)    );
  // itree = 1012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35927, 1, 1, 0.813449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288759,-99) , 
0, 0.465064, 1, 0, 0.5543,-99) , 
3, 0.795698, 0, 0, 0.679828,-99) , 
NN(
0, 
0, 
-1, -0.873066, 0, -1, 0.20066,-99) , 
3, -0.283698, 0, 0, 0.494774,-99)    );
  // itree = 1013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.888783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45879,-99) , 
0, 0.69993, 1, 0, 0.664016,-99) , 
3, 1.38501, 0, 0, 0.734301,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223692,-99) , 
0, -1.17596, 1, 0, 0.356703,-99) , 
NN(
0, 
0, 
-1, -2.86122, 1, -1, 0.101413,-99) , 
3, -1.16979, 0, 0, 0.241294,-99) , 
3, -0.18324, 0, 0, 0.548231,-99)    );
  // itree = 1014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32462, 0, 1, 0.842121,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362031,-99) , 
0, 0.29347, 1, 0, 0.584967,-99) , 
3, 0.98281, 0, 0, 0.697071,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.192478,-99) , 
3, -0.123397, 0, 0, 0.486164,-99)    );
  // itree = 1015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17867, 1, 1, 0.86761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289136,-99) , 
0, 0.696824, 1, 0, 0.611245,-99) , 
3, 1.0127, 0, 0, 0.753373,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320198,-99) , 
0, -0.431771, 1, 0, 0.474358,-99) , 
NN(
0, 
0, 
-1, -1.20105, 1, -1, 0.157022,-99) , 
3, -0.386214, 0, 0, 0.260691,-99) , 
3, 0.238103, 0, 0, 0.471798,-99)    );
  // itree = 1016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.866361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451159,-99) , 
0, 0.182049, 1, 0, 0.617771,-99) , 
3, 1.30662, 0, 0, 0.698304,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.198299,-99) , 
3, -0.304384, 0, 0, 0.511596,-99)    );
  // itree = 1017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.899217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338805,-99) , 
0, 0.84413, 1, 0, 0.640188,-99) , 
3, 1.217, 0, 0, 0.74334,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261855,-99) , 
0, -0.602719, 1, 0, 0.423448,-99) , 
NN(
0, 
0, 
-1, -1.80475, 1, -1, 0.135491,-99) , 
3, -0.651936, 0, 0, 0.264297,-99) , 
3, 0.17816, 0, 0, 0.486506,-99)    );
  // itree = 1018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37572, 0, 1, 0.836649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374324,-99) , 
2, 0.318535, 1, 0, 0.538937,-99) , 
3, 1.0516, 0, 0, 0.649238,-99) , 
NN(
0, 
0, 
-1, -0.787213, 0, -1, 0.169836,-99) , 
3, -0.28269, 0, 0, 0.468792,-99)    );
  // itree = 1019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09855, 1, 1, 0.789064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459159,-99) , 
1, -0.471534, 1, 0, 0.566941,-99) , 
3, 0.385395, 0, 0, 0.722195,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.182215,-99) , 
3, -0.28269, 0, 0, 0.501928,-99)    );
  // itree = 1020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.862033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368286,-99) , 
0, 0.708301, 1, 0, 0.671761,-99) , 
3, 0.985321, 0, 0, 0.755998,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.205881,-99) , 
3, -0.123397, 0, 0, 0.52024,-99)    );
  // itree = 1021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51354, 1, 1, 0.848555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282738,-99) , 
0, 0.685034, 1, 0, 0.528084,-99) , 
3, 0.989158, 0, 0, 0.634833,-99) , 
NN(
0, 
0, 
-1, -1.52853, 0, -1, 0.16674,-99) , 
3, -0.711955, 0, 0, 0.512084,-99)    );
  // itree = 1022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90497, 1, 1, 0.822804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331228,-99) , 
0, 0.670322, 1, 0, 0.624614,-99) , 
3, 0.98281, 0, 0, 0.715425,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227839,-99) , 
0, -1.52167, 1, 0, 0.346424,-99) , 
NN(
0, 
0, 
-1, 0.0242633, 1, -1, 0.0627791,-99) , 
3, -1.59854, 0, 0, 0.27014,-99) , 
3, -0.123397, 0, 0, 0.531566,-99)    );
  // itree = 1023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30327, 0, 1, 0.852323,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319106,-99) , 
0, 0.819377, 1, 0, 0.591352,-99) , 
3, 0.979531, 0, 0, 0.72469,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324063,-99) , 
0, -0.646644, 1, 0, 0.445984,-99) , 
NN(
0, 
0, 
-1, -1.6623, 1, -1, 0.200845,-99) , 
3, -0.357516, 0, 0, 0.28406,-99) , 
3, 0.178444, 0, 0, 0.497446,-99)    );
  // itree = 1024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.83674, 0, 1, 0.819675,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.927814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438326,-99) , 
0, -0.232441, 1, 0, 0.580858,-99) , 
3, 0.761669, 0, 0, 0.717753,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185698,-99) , 
0, -1.31319, 1, 0, 0.362244,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.1012,-99) , 
3, -1.00886, 0, 0, 0.231366,-99) , 
3, -0.123397, 0, 0, 0.515777,-99)    );
  // itree = 1025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.72917, 1, 1, 0.904047,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445171,-99) , 
0, 0.807964, 1, 0, 0.660325,-99) , 
3, 1.42073, 0, 0, 0.740821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650927,-99) , 
NN(
0, 
0, 
-1, -1.16584, 0, -1, 0.219528,-99) , 
3, -0.109402, 0, 0, 0.280806,-99) , 
3, 0.17816, 0, 0, 0.517607,-99)    );
  // itree = 1026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.5662, 0, 1, 0.780379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282824,-99) , 
1, -0.250541, 1, 0, 0.434496,-99) , 
NN(
0, 
0, 
-1, -1.82808, 1, -1, 0.169766,-99) , 
3, -0.414216, 0, 0, 0.259468,-99) , 
3, 0.218994, 0, 0, 0.492691,-99)    );
  // itree = 1027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.266067, 1, 1, 0.940556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431686,-99) , 
3, 1.07083, 0, 0, 0.629201,-99) , 
0, 0.247385, 1, 0, 0.700693,-99) , 
NN(
0, 
0, 
-1, -0.519004, 0, -1, 0.208233,-99) , 
3, 0.017859, 0, 0, 0.45274,-99)    );
  // itree = 1028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67119, 1, 1, 0.864173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285069,-99) , 
0, 0.895922, 1, 0, 0.592329,-99) , 
3, 1.11353, 0, 0, 0.704436,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224292,-99) , 
0, -1.32055, 1, 0, 0.334709,-99) , 
NN(
0, 
0, 
-1, -2.21779, 1, -1, 0.0814282,-99) , 
3, -0.998108, 0, 0, 0.22429,-99) , 
3, 0.093663, 0, 0, 0.460575,-99)    );
  // itree = 1029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45879, 1, 1, 0.814296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331129,-99) , 
0, -0.135613, 1, 0, 0.565926,-99) , 
3, 0.543354, 0, 0, 0.732089,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.22869,-99) , 
3, -0.123397, 0, 0, 0.511253,-99)    );
  // itree = 1030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.597397, 1, 1, 0.868975,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374501,-99) , 
3, 1.20358, 0, 0, 0.687359,-99) , 
0, 1.06258, 1, 0, 0.755731,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293895,-99) , 
0, -0.694947, 1, 0, 0.398047,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.151259,-99) , 
3, -0.568264, 0, 0, 0.280641,-99) , 
3, 0.392653, 0, 0, 0.475457,-99)    );
  // itree = 1031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.771029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224519,-99) , 
0, -0.146236, 1, 0, 0.504957,-99) , 
3, 0.527981, 0, 0, 0.665267,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.221676,-99) , 
3, -0.38184, 0, 0, 0.519441,-99)    );
  // itree = 1032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.843952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35547,-99) , 
0, 0.397725, 1, 0, 0.575414,-99) , 
3, 0.983057, 0, 0, 0.680426,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.200579,-99) , 
3, -0.376892, 0, 0, 0.523161,-99)    );
  // itree = 1033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.883662,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488967,-99) , 
0, -0.150211, 1, 0, 0.596144,-99) , 
3, 1.10862, 0, 0, 0.710897,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.20296,-99) , 
3, -0.202496, 0, 0, 0.496709,-99)    );
  // itree = 1034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15677, 1, 1, 0.87429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367942,-99) , 
0, 0.906178, 1, 0, 0.669538,-99) , 
3, 0.982331, 0, 0, 0.775767,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635619,-99) , 
NN(
0, 
0, 
-1, -1.10929, 0, -1, 0.200801,-99) , 
3, -0.0913569, 0, 0, 0.266019,-99) , 
3, 0.178444, 0, 0, 0.515607,-99)    );
  // itree = 1035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.892769,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46304,-99) , 
0, 1.04633, 1, 0, 0.681829,-99) , 
3, 1.45321, 0, 0, 0.739815,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242645,-99) , 
0, -0.92428, 1, 0, 0.390739,-99) , 
NN(
0, 
0, 
-1, -2.47601, 1, -1, 0.143422,-99) , 
3, -0.774483, 0, 0, 0.246124,-99) , 
3, 0.0354976, 0, 0, 0.496036,-99)    );
  // itree = 1036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.44428, 0, 1, 0.683321,-99) , 
NN(
0, 
0, 
-1, -2.00647, 1, -1, 0.15658,-99) , 
3, -0.376892, 0, 0, 0.47876,-99)    );
  // itree = 1037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49435, 1, 1, 0.837982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264501,-99) , 
0, 0.8372, 1, 0, 0.592,-99) , 
3, 0.98281, 0, 0, 0.693834,-99) , 
NN(
0, 
0, 
-1, -0.419849, 0, -1, 0.216094,-99) , 
3, -0.123397, 0, 0, 0.488426,-99)    );
  // itree = 1038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.412701, 1, 1, 0.869557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493635,-99) , 
3, 1.42058, 0, 0, 0.709657,-99) , 
0, 1.10708, 1, 0, 0.78171,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213193,-99) , 
0, -0.312245, 1, 0, 0.443513,-99) , 
NN(
0, 
0, 
-1, -1.96872, 1, -1, 0.160091,-99) , 
3, -0.548378, 0, 0, 0.285992,-99) , 
3, 0.262941, 0, 0, 0.507981,-99)    );
  // itree = 1039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.743213, 1, 1, 0.881652,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367096,-99) , 
0, 0.685034, 1, 0, 0.584199,-99) , 
3, 1.06267, 0, 0, 0.690447,-99) , 
NN(
0, 
0, 
-1, -1.14514, 0, -1, 0.17593,-99) , 
3, -0.683307, 0, 0, 0.538573,-99)    );
  // itree = 1040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.762435,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299214,-99) , 
0, -0.349084, 1, 0, 0.502479,-99) , 
3, 0.255982, 0, 0, 0.672774,-99) , 
NN(
0, 
0, 
-1, -0.420046, 1, -1, 0.170599,-99) , 
3, -0.716903, 0, 0, 0.541828,-99)    );
  // itree = 1041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.844851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26844,-99) , 
0, 0.814508, 1, 0, 0.570152,-99) , 
3, 0.979517, 0, 0, 0.684029,-99) , 
NN(
0, 
0, 
-1, -0.824857, 0, -1, 0.185133,-99) , 
3, -0.340957, 0, 0, 0.507758,-99)    );
  // itree = 1042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73223, 1, 1, 0.854555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278755,-99) , 
0, 0.811659, 1, 0, 0.582135,-99) , 
3, 1.09297, 0, 0, 0.684047,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152535,-99) , 
0, -1.19072, 1, 0, 0.306881,-99) , 
NN(
0, 
0, 
-1, 0.0305986, 1, -1, 0.121577,-99) , 
3, -1.20922, 0, 0, 0.22739,-99) , 
3, -0.232821, 0, 0, 0.500971,-99)    );
  // itree = 1043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49362, 1, 1, 0.75321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423727,-99) , 
3, 0.202832, 0, 0, 0.673038,-99) , 
NN(
0, 
0, 
-1, -1.11714, 0, -1, 0.168215,-99) , 
3, -0.25059, 0, 0, 0.456828,-99)    );
  // itree = 1044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.802299, 0, 1, 0.854773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497521,-99) , 
3, 1.36283, 0, 0, 0.706504,-99) , 
0, 1.16242, 1, 0, 0.772229,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783927,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335121,-99) , 
0, -0.979963, 1, 0, 0.45255,-99) , 
NN(
0, 
0, 
-1, -1.46184, 1, -1, 0.163255,-99) , 
3, -0.548378, 0, 0, 0.289239,-99) , 
3, 0.262941, 0, 0, 0.486185,-99)    );
  // itree = 1045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.331774, 0, 1, 0.711253,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.226293,-99) , 
3, -0.123397, 0, 0, 0.513888,-99)    );
  // itree = 1046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38451, 1, 1, 0.900794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454214,-99) , 
0, 1.37435, 1, 0, 0.668327,-99) , 
3, 1.64623, 0, 0, 0.718437,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205974,-99) , 
0, -1.01188, 1, 0, 0.322604,-99) , 
NN(
0, 
0, 
-1, -2.61108, 1, -1, 0.109528,-99) , 
3, -1.00886, 0, 0, 0.225535,-99) , 
3, -0.123397, 0, 0, 0.507458,-99)    );
  // itree = 1047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.898185,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37213,-99) , 
0, 1.53885, 1, 0, 0.702683,-99) , 
3, 1.43422, 0, 0, 0.760539,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.20375,-99) , 
3, -0.123397, 0, 0, 0.515809,-99)    );
  // itree = 1048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.861274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309081,-99) , 
0, 1.0116, 1, 0, 0.616049,-99) , 
3, 1.30512, 0, 0, 0.690051,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.220089,-99) , 
3, -0.304384, 0, 0, 0.513399,-99)    );
  // itree = 1049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49362, 1, 1, 0.750789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273884,-99) , 
1, 0.136178, 1, 0, 0.465235,-99) , 
3, 0.199517, 0, 0, 0.654853,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.180087,-99) , 
3, -0.52895, 0, 0, 0.490142,-99)    );
  // itree = 1050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74139, 0, 1, 0.842625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340481,-99) , 
0, 0.891, 1, 0, 0.598081,-99) , 
3, 1.10862, 0, 0, 0.690689,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.231098,-99) , 
3, -0.202496, 0, 0, 0.509378,-99)    );
  // itree = 1051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.593979, 0, 1, 0.737743,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315745,-99) , 
0, -0.547699, 1, 0, 0.483469,-99) , 
NN(
0, 
0, 
-1, -1.37377, 1, -1, 0.20465,-99) , 
3, -0.376357, 0, 0, 0.296603,-99) , 
3, 0.17816, 0, 0, 0.510763,-99)    );
  // itree = 1052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2032, 0, 1, 0.828349,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368649,-99) , 
0, -0.218544, 1, 0, 0.51795,-99) , 
3, 0.668127, 0, 0, 0.69067,-99) , 
NN(
0, 
0, 
-1, -1.09585, 0, -1, 0.194501,-99) , 
3, -0.207894, 0, 0, 0.47721,-99)    );
  // itree = 1053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05086, 1, 1, 0.783885,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288271,-99) , 
0, -0.188555, 1, 0, 0.50389,-99) , 
3, 0.387506, 0, 0, 0.683916,-99) , 
NN(
0, 
0, 
-1, -1.06792, 0, -1, 0.163295,-99) , 
3, -0.304384, 0, 0, 0.48879,-99)    );
  // itree = 1054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.309776, 1, 1, 0.942998,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308882,-99) , 
3, 1.08418, 0, 0, 0.696722,-99) , 
0, 0.87494, 1, 0, 0.785856,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593406,-99) , 
NN(
0, 
0, 
-1, -1.22192, 0, -1, 0.181588,-99) , 
3, -0.0116291, 0, 0, 0.237407,-99) , 
3, 0.306962, 0, 0, 0.470876,-99)    );
  // itree = 1055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62716, 1, 1, 0.903915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443021,-99) , 
0, 1.22914, 1, 0, 0.638647,-99) , 
3, 1.64827, 0, 0, 0.70124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215141,-99) , 
0, -1.20764, 1, 0, 0.382118,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.131835,-99) , 
3, -1.01154, 0, 0, 0.267077,-99) , 
3, -0.123397, 0, 0, 0.52494,-99)    );
  // itree = 1056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.732531, 1, 1, 0.837919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455223,-99) , 
0, -0.00616939, 1, 0, 0.621316,-99) , 
3, 0.812678, 0, 0, 0.737575,-99) , 
NN(
0, 
0, 
-1, -0.848344, 0, -1, 0.212286,-99) , 
3, -0.269563, 0, 0, 0.541993,-99)    );
  // itree = 1057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47483, 1, 1, 0.792295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375277,-99) , 
0, 0.279125, 1, 0, 0.578469,-99) , 
3, 0.802191, 0, 0, 0.713147,-99) , 
NN(
0, 
0, 
-1, -0.336914, 0, -1, 0.254586,-99) , 
3, 0.202693, 0, 0, 0.466125,-99)    );
  // itree = 1058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51343, 1, 1, 0.902367,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460748,-99) , 
0, 1.11772, 1, 0, 0.712488,-99) , 
3, 1.37848, 0, 0, 0.78604,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342924,-99) , 
3, -0.0841812, 0, 0, 0.424348,-99) , 
NN(
0, 
0, 
-1, -1.09757, 0, -1, 0.159354,-99) , 
3, -0.36326, 0, 0, 0.247768,-99) , 
3, 0.178444, 0, 0, 0.500475,-99)    );
  // itree = 1059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.0257, 0, 1, 0.737422,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184342,-99) , 
0, -1.42022, 1, 0, 0.278676,-99) , 
NN(
0, 
0, 
-1, -2.85873, 1, -1, 0.103068,-99) , 
3, -1.27772, 0, 0, 0.217043,-99) , 
3, -0.067798, 0, 0, 0.502392,-99)    );
  // itree = 1060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10389, 0, 1, 0.814199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294101,-99) , 
0, -0.646644, 1, 0, 0.464884,-99) , 
3, 0.312308, 0, 0, 0.703592,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0809192,-99) , 
3, -1.3854, 0, 0, 0.253196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.086532,-99) , 
0, -1.6623, 1, 0, 0.17234,-99) , 
3, -0.376892, 0, 0, 0.502062,-99)    );
  // itree = 1061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43703, 1, 1, 0.865997,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463653,-99) , 
0, -0.00616939, 1, 0, 0.621781,-99) , 
3, 1.07643, 0, 0, 0.709606,-99) , 
NN(
0, 
0, 
-1, -1.07057, 0, -1, 0.216264,-99) , 
3, -0.304384, 0, 0, 0.518696,-99)    );
  // itree = 1062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34909, 0, 1, 0.842252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386805,-99) , 
0, 0.639693, 1, 0, 0.645148,-99) , 
3, 1.00736, 0, 0, 0.745624,-99) , 
NN(
0, 
0, 
-1, -0.379167, 0, -1, 0.269444,-99) , 
3, 0.17816, 0, 0, 0.498094,-99)    );
  // itree = 1063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85593, 1, 1, 0.820282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.961931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357996,-99) , 
0, 0.18825, 1, 0, 0.566674,-99) , 
3, 0.794497, 0, 0, 0.734204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250062,-99) , 
0, -0.444483, 1, 0, 0.409017,-99) , 
NN(
0, 
0, 
-1, -0.983078, 0, -1, 0.159335,-99) , 
3, -0.418337, 0, 0, 0.251423,-99) , 
3, 0.218994, 0, 0, 0.465948,-99)    );
  // itree = 1064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.81933, 1, 1, 0.884564,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40177,-99) , 
0, 1.17663, 1, 0, 0.654767,-99) , 
3, 1.48336, 0, 0, 0.730181,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278021,-99) , 
1, 0.133289, 1, 0, 0.414472,-99) , 
NN(
0, 
0, 
-1, -1.48549, 0, -1, 0.146684,-99) , 
3, -0.549899, 0, 0, 0.262813,-99) , 
3, 0.262941, 0, 0, 0.477291,-99)    );
  // itree = 1065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.840269,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33245,-99) , 
0, 0.92467, 1, 0, 0.661809,-99) , 
3, 1.3205, 0, 0, 0.722352,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155432,-99) , 
0, -1.19072, 1, 0, 0.29945,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.115323,-99) , 
3, -1.08414, 0, 0, 0.213474,-99) , 
3, -0.207894, 0, 0, 0.499998,-99)    );
  // itree = 1066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.866174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390114,-99) , 
0, 1.24593, 1, 0, 0.656623,-99) , 
3, 1.36979, 0, 0, 0.719552,-99) , 
NN(
0, 
0, 
-1, -0.712309, 0, -1, 0.221082,-99) , 
3, -0.210183, 0, 0, 0.521617,-99)    );
  // itree = 1067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44035, 1, 1, 0.820847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39263,-99) , 
0, -0.231503, 1, 0, 0.570798,-99) , 
3, 0.540529, 0, 0, 0.73939,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223647,-99) , 
0, -1.04254, 1, 0, 0.367491,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.0988846,-99) , 
3, -1.01267, 0, 0, 0.244368,-99) , 
3, -0.123397, 0, 0, 0.528382,-99)    );
  // itree = 1068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.821827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392031,-99) , 
0, 0.540099, 1, 0, 0.630877,-99) , 
3, 1.11353, 0, 0, 0.715705,-99) , 
NN(
0, 
0, 
-1, -0.450619, 0, -1, 0.261484,-99) , 
3, 0.093663, 0, 0, 0.488302,-99)    );
  // itree = 1069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.856316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271382,-99) , 
0, 1.24591, 1, 0, 0.603221,-99) , 
3, 1.32556, 0, 0, 0.668862,-99) , 
NN(
0, 
0, 
-1, -1.14133, 0, -1, 0.154332,-99) , 
3, -0.683307, 0, 0, 0.512242,-99)    );
  // itree = 1070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34883, 0, 1, 0.826384,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223092,-99) , 
0, 0.895484, 1, 0, 0.581626,-99) , 
3, 0.99324, 0, 0, 0.683702,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231218,-99) , 
0, -1.17998, 1, 0, 0.380381,-99) , 
NN(
0, 
0, 
-1, -0.0446866, 1, -1, 0.0995834,-99) , 
3, -1.00886, 0, 0, 0.233448,-99) , 
3, -0.123397, 0, 0, 0.503155,-99)    );
  // itree = 1071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.872489,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357072,-99) , 
0, 1.32206, 1, 0, 0.674309,-99) , 
3, 1.31116, 0, 0, 0.758238,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308936,-99) , 
1, -0.214834, 1, 0, 0.451519,-99) , 
NN(
0, 
0, 
-1, -1.41734, 1, -1, 0.168026,-99) , 
3, -0.500504, 0, 0, 0.294397,-99) , 
3, 0.307824, 0, 0, 0.497725,-99)    );
  // itree = 1072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.804301,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215508,-99) , 
0, 0.738333, 1, 0, 0.500482,-99) , 
3, 0.99106, 0, 0, 0.601514,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.138416,-99) , 
3, -0.711955, 0, 0, 0.474764,-99)    );
  // itree = 1073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.596138, 0, 1, 0.763192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580462,-99) , 
NN(
0, 
0, 
-1, -1.16295, 0, -1, 0.214249,-99) , 
3, -0.109402, 0, 0, 0.266787,-99) , 
3, 0.17816, 0, 0, 0.499569,-99)    );
  // itree = 1074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.873815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806978,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428864,-99) , 
0, 0.696824, 1, 0, 0.657044,-99) , 
3, 1.09016, 0, 0, 0.766829,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585181,-99) , 
NN(
0, 
0, 
-1, -0.913459, 0, -1, 0.209024,-99) , 
3, -0.0116291, 0, 0, 0.265143,-99) , 
3, 0.306962, 0, 0, 0.495287,-99)    );
  // itree = 1075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72686, 1, 1, 0.817258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173186,-99) , 
0, 1.04592, 1, 0, 0.54068,-99) , 
3, 1.13847, 0, 0, 0.624398,-99) , 
NN(
0, 
0, 
-1, -1.23085, 0, -1, 0.144048,-99) , 
3, -0.569575, 0, 0, 0.455593,-99)    );
  // itree = 1076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42509, 0, 1, 0.727103,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50767,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178667,-99) , 
0, -1.50834, 1, 0, 0.273991,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.067294,-99) , 
3, -1.30427, 0, 0, 0.200034,-99) , 
3, -0.123397, 0, 0, 0.491325,-99)    );
  // itree = 1077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43273, 1, 1, 0.886166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423764,-99) , 
0, 1.48504, 1, 0, 0.694653,-99) , 
3, 1.57239, 0, 0, 0.755498,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356018,-99) , 
1, -0.479173, 1, 0, 0.466098,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.181239,-99) , 
3, -0.566981, 0, 0, 0.305856,-99) , 
3, 0.392653, 0, 0, 0.500404,-99)    );
  // itree = 1078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.856326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339957,-99) , 
0, 1.0581, 1, 0, 0.645066,-99) , 
3, 1.21755, 0, 0, 0.730036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337639,-99) , 
3, -0.0639208, 0, 0, 0.450389,-99) , 
NN(
0, 
0, 
-1, 0.338353, 1, -1, 0.200459,-99) , 
3, -0.379167, 0, 0, 0.280346,-99) , 
3, 0.17816, 0, 0, 0.495769,-99)    );
  // itree = 1079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.883027,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320454,-99) , 
0, 0.957246, 1, 0, 0.622797,-99) , 
3, 1.2063, 0, 0, 0.719218,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189728,-99) , 
0, -1.35582, 1, 0, 0.330042,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.110681,-99) , 
3, -1.01154, 0, 0, 0.241432,-99) , 
3, -0.123397, 0, 0, 0.505996,-99)    );
  // itree = 1080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2574, 1, 1, 0.854945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397006,-99) , 
0, 0.782483, 1, 0, 0.642163,-99) , 
3, 1.08443, 0, 0, 0.754353,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20475,-99) , 
2, 0.0801308, 1, 0, 0.43228,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.130013,-99) , 
3, -0.957285, 0, 0, 0.311153,-99) , 
3, 0.306962, 0, 0, 0.506282,-99)    );
  // itree = 1081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.291812, 1, 1, 0.936072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36909,-99) , 
3, 1.06299, 0, 0, 0.6672,-99) , 
0, 0.668086, 1, 0, 0.747163,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257295,-99) , 
0, -0.5694, 1, 0, 0.473609,-99) , 
NN(
0, 
0, 
-1, -1.65122, 1, -1, 0.1892,-99) , 
3, -0.391132, 0, 0, 0.283138,-99) , 
3, 0.238103, 0, 0, 0.499149,-99)    );
  // itree = 1082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.910182,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418059,-99) , 
0, 1.10293, 1, 0, 0.68713,-99) , 
3, 1.35947, 0, 0, 0.769566,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207018,-99) , 
0, -0.774779, 1, 0, 0.356764,-99) , 
NN(
0, 
0, 
-1, -2.93551, 1, -1, 0.0643544,-99) , 
3, -1.03914, 0, 0, 0.254664,-99) , 
3, 0.207882, 0, 0, 0.504712,-99)    );
  // itree = 1083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21871, 1, 1, 0.808325,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346604,-99) , 
0, 0.279125, 1, 0, 0.543043,-99) , 
3, 0.800667, 0, 0, 0.714452,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237718,-99) , 
0, -0.866905, 1, 0, 0.368321,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.128661,-99) , 
3, -0.927516, 0, 0, 0.269252,-99) , 
3, 0.17816, 0, 0, 0.493174,-99)    );
  // itree = 1084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.866446,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405315,-99) , 
0, 0.854666, 1, 0, 0.623439,-99) , 
3, 1.38637, 0, 0, 0.694202,-99) , 
NN(
0, 
0, 
-1, -1.16979, 0, -1, 0.200838,-99) , 
3, -0.18324, 0, 0, 0.480765,-99)    );
  // itree = 1085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41366, 0, 1, 0.864896,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223271,-99) , 
0, 0.610053, 1, 0, 0.519513,-99) , 
3, 0.929717, 0, 0, 0.658454,-99) , 
NN(
0, 
0, 
-1, -1.17803, 0, -1, 0.159155,-99) , 
3, -0.420978, 0, 0, 0.498784,-99)    );
  // itree = 1086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.48953, 0, 1, 0.70954,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.198476,-99) , 
3, -0.287638, 0, 0, 0.50776,-99)    );
  // itree = 1087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.842497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374591,-99) , 
0, 0.854666, 1, 0, 0.605136,-99) , 
3, 1.32689, 0, 0, 0.682896,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225048,-99) , 
0, -1.28936, 1, 0, 0.342386,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.128872,-99) , 
3, -1.07872, 0, 0, 0.253429,-99) , 
3, -0.202496, 0, 0, 0.511766,-99)    );
  // itree = 1088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.11962, 0, 1, 0.793193,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204202,-99) , 
0, 0.245926, 1, 0, 0.489482,-99) , 
NN(
0, 
0, 
-1, -1.07066, 0, -1, 0.19253,-99) , 
3, -0.311483, 0, 0, 0.327204,-99) , 
3, 0.575013, 0, 0, 0.481011,-99)    );
  // itree = 1089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.800253,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342481,-99) , 
0, -0.0316589, 1, 0, 0.526275,-99) , 
3, 0.489001, 0, 0, 0.705622,-99) , 
NN(
0, 
0, 
-1, -1.17915, 0, -1, 0.181675,-99) , 
3, -0.18324, 0, 0, 0.482698,-99)    );
  // itree = 1090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0045, 0, 1, 0.90272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283388,-99) , 
3, 1.13907, 0, 0, 0.625311,-99) , 
0, 1.17756, 1, 0, 0.755899,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358796,-99) , 
0, -0.616482, 1, 0, 0.479504,-99) , 
NN(
0, 
0, 
-1, -1.21424, 0, -1, 0.166876,-99) , 
3, -0.356431, 0, 0, 0.275789,-99) , 
3, 0.306962, 0, 0, 0.489874,-99)    );
  // itree = 1091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.65393, 0, 1, 0.902078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464627,-99) , 
3, 1.19085, 0, 0, 0.74667,-99) , 
0, 1.02343, 1, 0, 0.810278,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294234,-99) , 
0, -0.603543, 1, 0, 0.405746,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.145587,-99) , 
3, -0.959868, 0, 0, 0.31025,-99) , 
3, 0.301115, 0, 0, 0.523532,-99)    );
  // itree = 1092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55749, 1, 1, 0.828224,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302162,-99) , 
0, 0.887495, 1, 0, 0.636587,-99) , 
3, 1.16101, 0, 0, 0.708638,-99) , 
NN(
0, 
0, 
-1, -0.67742, 0, -1, 0.198689,-99) , 
3, -0.18324, 0, 0, 0.490588,-99)    );
  // itree = 1093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.6258, 0, 1, 0.684252,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189171,-99) , 
0, -1.32805, 1, 0, 0.308876,-99) , 
NN(
0, 
0, 
-1, 0.00332265, 1, -1, 0.0897752,-99) , 
3, -1.14418, 0, 0, 0.210856,-99) , 
3, -0.160313, 0, 0, 0.489143,-99)    );
  // itree = 1094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.672338, 1, 1, 0.762196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.944429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371319,-99) , 
1, -0.532452, 1, 0, 0.515775,-99) , 
3, 0.388209, 0, 0, 0.67872,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.198449,-99) , 
3, -0.304384, 0, 0, 0.503255,-99)    );
  // itree = 1095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.563377, 1, 1, 0.88584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405021,-99) , 
3, 1.44631, 0, 0, 0.679257,-99) , 
0, 1.49478, 1, 0, 0.789221,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203663,-99) , 
0, -0.0856679, 1, 0, 0.433482,-99) , 
NN(
0, 
0, 
-1, -1.12403, 0, -1, 0.151452,-99) , 
3, -0.576196, 0, 0, 0.279981,-99) , 
3, 0.392653, 0, 0, 0.491649,-99)    );
  // itree = 1096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42098, 1, 1, 0.808679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401214,-99) , 
0, 0.0962769, 1, 0, 0.608731,-99) , 
3, 0.682702, 0, 0, 0.742095,-99) , 
NN(
0, 
0, 
-1, -0.435679, 0, -1, 0.246536,-99) , 
3, 0.0923834, 0, 0, 0.492437,-99)    );
  // itree = 1097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.8698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44672,-99) , 
0, 0.240286, 1, 0, 0.584269,-99) , 
3, 1.10862, 0, 0, 0.691692,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.208521,-99) , 
3, -0.202496, 0, 0, 0.50762,-99)    );
  // itree = 1098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.713736, 1, 1, 0.807438,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35543,-99) , 
1, -0.654311, 1, 0, 0.430876,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.138918,-99) , 
3, -1.14821, 0, 0, 0.361759,-99) , 
3, 0.660704, 0, 0, 0.517335,-99)    );
  // itree = 1099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.881252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383155,-99) , 
0, 1.15092, 1, 0, 0.625183,-99) , 
3, 1.38447, 0, 0, 0.715746,-99) , 
NN(
0, 
0, 
-1, -0.35011, 0, -1, 0.262637,-99) , 
3, 0.183842, 0, 0, 0.486319,-99)    );
  // itree = 1100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.868836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271398,-99) , 
0, 0.8404, 1, 0, 0.591315,-99) , 
3, 1.30512, 0, 0, 0.673804,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153026,-99) , 
0, -1.50823, 1, 0, 0.306719,-99) , 
NN(
0, 
0, 
-1, -2.86122, 1, -1, 0.106072,-99) , 
3, -1.06543, 0, 0, 0.219361,-99) , 
3, -0.304384, 0, 0, 0.489659,-99)    );
  // itree = 1101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78166, 1, 1, 0.854102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279177,-99) , 
0, 0.738333, 1, 0, 0.569277,-99) , 
3, 0.90304, 0, 0, 0.694566,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.209974,-99) , 
3, -0.202496, 0, 0, 0.498411,-99)    );
  // itree = 1102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1598, 1, 1, 0.885,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336628,-99) , 
0, 0.852865, 1, 0, 0.627305,-99) , 
3, 1.14538, 0, 0, 0.754525,-99) , 
NN(
0, 
0, 
-1, -0.3766, 0, -1, 0.277033,-99) , 
3, 0.159996, 0, 0, 0.522915,-99)    );
  // itree = 1103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.865834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455704,-99) , 
0, 1.14581, 1, 0, 0.680538,-99) , 
3, 1.37205, 0, 0, 0.745699,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275921,-99) , 
1, 0.151245, 1, 0, 0.403884,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.112011,-99) , 
3, -1.02963, 0, 0, 0.291727,-99) , 
3, 0.218994, 0, 0, 0.503497,-99)    );
  // itree = 1104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.89649, 0, 1, 0.804423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285097,-99) , 
0, -0.116959, 1, 0, 0.517566,-99) , 
3, 0.312308, 0, 0, 0.698208,-99) , 
NN(
0, 
0, 
-1, -0.400447, 1, -1, 0.163935,-99) , 
3, -0.376892, 0, 0, 0.500256,-99)    );
  // itree = 1105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60258, 1, 1, 0.843055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394076,-99) , 
0, 0.676493, 1, 0, 0.620754,-99) , 
3, 1.1447, 0, 0, 0.703261,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198476,-99) , 
0, -1.48391, 1, 0, 0.336755,-99) , 
NN(
0, 
0, 
-1, -0.0310174, 1, -1, 0.0715585,-99) , 
3, -1.20728, 0, 0, 0.220183,-99) , 
3, -0.210183, 0, 0, 0.500336,-99)    );
  // itree = 1106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.877544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369457,-99) , 
0, 0.920728, 1, 0, 0.674508,-99) , 
3, 1.31846, 0, 0, 0.748237,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282351,-99) , 
0, -0.822087, 1, 0, 0.407267,-99) , 
NN(
0, 
0, 
-1, -2.47601, 1, -1, 0.13924,-99) , 
3, -0.728921, 0, 0, 0.244976,-99) , 
3, 0.093663, 0, 0, 0.498895,-99)    );
  // itree = 1107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.897447,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413615,-99) , 
0, 0.893448, 1, 0, 0.657862,-99) , 
3, 1.21798, 0, 0, 0.763452,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31626,-99) , 
0, -1.24008, 1, 0, 0.400031,-99) , 
NN(
0, 
0, 
-1, -2.57594, 1, -1, 0.158,-99) , 
3, -1.09309, 0, 0, 0.324674,-99) , 
3, 0.228725, 0, 0, 0.531461,-99)    );
  // itree = 1108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.06892, 0, 1, 0.744818,-99) , 
NN(
0, 
0, 
-1, -1.37929, 1, -1, 0.17746,-99) , 
3, -0.223384, 0, 0, 0.489341,-99)    );
  // itree = 1109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00908, 1, 1, 0.742905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38761,-99) , 
3, 0.0502403, 0, 0, 0.687386,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.209816,-99) , 
3, -0.202496, 0, 0, 0.484522,-99)    );
  // itree = 1110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.88993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391275,-99) , 
0, 0.498151, 1, 0, 0.625006,-99) , 
3, 1.12846, 0, 0, 0.751189,-99) , 
NN(
0, 
0, 
-1, -0.447144, 0, -1, 0.259774,-99) , 
3, 0.0990605, 0, 0, 0.517437,-99)    );
  // itree = 1111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.361931, 1, 1, 0.878246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353102,-99) , 
3, 1.03389, 0, 0, 0.670636,-99) , 
0, 0.7846, 1, 0, 0.743284,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285454,-99) , 
0, -1.44513, 1, 0, 0.370494,-99) , 
NN(
0, 
0, 
-1, -2.5847, 1, -1, 0.119992,-99) , 
3, -1.09626, 0, 0, 0.289169,-99) , 
3, 0.228725, 0, 0, 0.496288,-99)    );
  // itree = 1112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48242, 1, 1, 0.825848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222557,-99) , 
0, 1.38125, 1, 0, 0.605669,-99) , 
3, 1.21404, 0, 0, 0.690072,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354978,-99) , 
2, -0.184482, 0, 0, 0.443389,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.148102,-99) , 
3, -0.376357, 0, 0, 0.23525,-99) , 
3, 0.17816, 0, 0, 0.441086,-99)    );
  // itree = 1113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.782844,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306711,-99) , 
0, -0.0628603, 1, 0, 0.535434,-99) , 
3, 0.526823, 0, 0, 0.676185,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.160064,-99) , 
3, -0.38184, 0, 0, 0.477143,-99)    );
  // itree = 1114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.858874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36958,-99) , 
0, 0.859187, 1, 0, 0.643601,-99) , 
3, 1.12392, 0, 0, 0.739201,-99) , 
NN(
0, 
0, 
-1, -0.720436, 0, -1, 0.252998,-99) , 
3, 0.0990605, 0, 0, 0.495218,-99)    );
  // itree = 1115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.887178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382078,-99) , 
0, 1.02331, 1, 0, 0.696878,-99) , 
3, 1.3275, 0, 0, 0.769472,-99) , 
NN(
0, 
0, 
-1, -0.450619, 0, -1, 0.258649,-99) , 
3, 0.093663, 0, 0, 0.509661,-99)    );
  // itree = 1116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.499387, 1, 1, 0.902461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354061,-99) , 
3, 1.17721, 0, 0, 0.707975,-99) , 
0, 1.1785, 1, 0, 0.794558,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292027,-99) , 
0, -0.991976, 1, 0, 0.431592,-99) , 
NN(
0, 
0, 
-1, -2.47814, 1, -1, 0.103201,-99) , 
3, -0.804558, 0, 0, 0.28573,-99) , 
3, 0.246134, 0, 0, 0.519799,-99)    );
  // itree = 1117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.864537,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31275,-99) , 
0, 1.0116, 1, 0, 0.631009,-99) , 
3, 1.10293, 0, 0, 0.718733,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.216674,-99) , 
3, -0.207894, 0, 0, 0.521878,-99)    );
  // itree = 1118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92746, 0, 1, 0.842713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407708,-99) , 
0, 0.191795, 1, 0, 0.586375,-99) , 
3, 0.987668, 0, 0, 0.685951,-99) , 
NN(
0, 
0, 
-1, -1.0683, 0, -1, 0.187511,-99) , 
3, -0.340957, 0, 0, 0.514056,-99)    );
  // itree = 1119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60258, 1, 1, 0.829593,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318601,-99) , 
0, 1.0116, 1, 0, 0.595393,-99) , 
3, 1.14354, 0, 0, 0.666678,-99) , 
NN(
0, 
0, 
-1, -1.18661, 0, -1, 0.151685,-99) , 
3, -0.435158, 0, 0, 0.472005,-99)    );
  // itree = 1120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.98281, 0, 1, 0.71888,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155337,-99) , 
0, -1.00424, 1, 0, 0.30456,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0806749,-99) , 
3, -1.00886, 0, 0, 0.197235,-99) , 
3, -0.123397, 0, 0, 0.490395,-99)    );
  // itree = 1121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.802306, 0, 1, 0.880528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365913,-99) , 
3, 1.36283, 0, 0, 0.690692,-99) , 
0, 1.16902, 1, 0, 0.774809,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272034,-99) , 
0, -0.831231, 1, 0, 0.410263,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.163868,-99) , 
3, -0.556192, 0, 0, 0.282264,-99) , 
3, 0.262941, 0, 0, 0.502908,-99)    );
  // itree = 1122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.709428, 1, 1, 0.778868,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356692,-99) , 
0, -0.424041, 1, 0, 0.485615,-99) , 
3, 0.303142, 0, 0, 0.691802,-99) , 
NN(
0, 
0, 
-1, -1.13161, 0, -1, 0.18585,-99) , 
3, -0.376892, 0, 0, 0.526982,-99)    );
  // itree = 1123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.867044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324823,-99) , 
0, 0.893448, 1, 0, 0.656498,-99) , 
3, 1.08653, 0, 0, 0.762709,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251916,-99) , 
0, -0.0693291, 1, 0, 0.464695,-99) , 
NN(
0, 
0, 
-1, -1.97532, 1, -1, 0.149307,-99) , 
3, -0.64095, 0, 0, 0.302542,-99) , 
3, 0.306962, 0, 0, 0.511636,-99)    );
  // itree = 1124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.27634, 0, 1, 0.697225,-99) , 
NN(
0, 
0, 
-1, -1.03309, 0, -1, 0.215892,-99) , 
3, -0.28269, 0, 0, 0.514065,-99)    );
  // itree = 1125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.842497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.885355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438372,-99) , 
0, 0.595089, 1, 0, 0.662619,-99) , 
3, 1.09392, 0, 0, 0.752673,-99) , 
NN(
0, 
0, 
-1, -1.06659, 0, -1, 0.256131,-99) , 
3, 0.28719, 0, 0, 0.463167,-99)    );
  // itree = 1126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.841993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211904,-99) , 
0, 0.84413, 1, 0, 0.568594,-99) , 
3, 1.01301, 0, 0, 0.700194,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254564,-99) , 
0, -0.787373, 1, 0, 0.409738,-99) , 
NN(
0, 
0, 
-1, -1.79212, 1, -1, 0.12824,-99) , 
3, -0.591799, 0, 0, 0.232263,-99) , 
3, 0.20809, 0, 0, 0.458013,-99)    );
  // itree = 1127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19605, 1, 1, 0.873527,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313745,-99) , 
0, 0.64261, 1, 0, 0.573439,-99) , 
3, 0.979337, 0, 0, 0.701041,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.168969,-99) , 
3, -0.38184, 0, 0, 0.521293,-99)    );
  // itree = 1128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.825132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378289,-99) , 
0, 0.426521, 1, 0, 0.561187,-99) , 
3, 0.810818, 0, 0, 0.723102,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386255,-99) , 
2, 0.0236056, 0, 0, 0.455757,-99) , 
NN(
0, 
0, 
-1, -1.05005, 0, -1, 0.196035,-99) , 
3, -0.327012, 0, 0, 0.278301,-99) , 
3, 0.202693, 0, 0, 0.492175,-99)    );
  // itree = 1129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.841471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304601,-99) , 
0, 0.573049, 1, 0, 0.579245,-99) , 
3, 1.00308, 0, 0, 0.697963,-99) , 
NN(
0, 
0, 
-1, -1.0868, 0, -1, 0.204364,-99) , 
3, -0.10679, 0, 0, 0.483426,-99)    );
  // itree = 1130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.87645,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49776,-99) , 
0, 1.17663, 1, 0, 0.699752,-99) , 
3, 1.41125, 0, 0, 0.76785,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248707,-99) , 
0, -0.824413, 1, 0, 0.392073,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.095024,-99) , 
3, -0.998831, 0, 0, 0.266751,-99) , 
3, 0.254861, 0, 0, 0.487148,-99)    );
  // itree = 1131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.8673, 1, 1, 0.884877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481735,-99) , 
0, 0.998699, 1, 0, 0.68615,-99) , 
3, 1.47173, 0, 0, 0.754517,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3332,-99) , 
0, -0.380122, 1, 0, 0.472342,-99) , 
NN(
0, 
0, 
-1, -1.20105, 1, -1, 0.157222,-99) , 
3, -0.325669, 0, 0, 0.263382,-99) , 
3, 0.306962, 0, 0, 0.471362,-99)    );
  // itree = 1132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02343, 1, 1, 0.766085,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291221,-99) , 
0, -0.2316, 1, 0, 0.523434,-99) , 
3, 0.384045, 0, 0, 0.683655,-99) , 
NN(
0, 
0, 
-1, -1.03187, 0, -1, 0.212794,-99) , 
3, -0.287638, 0, 0, 0.491157,-99)    );
  // itree = 1133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55993, 1, 1, 0.806043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813214,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385849,-99) , 
0, 0.819377, 1, 0, 0.630035,-99) , 
3, 1.08418, 0, 0, 0.715904,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319946,-99) , 
1, -0.272969, 1, 0, 0.460449,-99) , 
NN(
0, 
0, 
-1, -0.58425, 1, -1, 0.192719,-99) , 
3, -0.325669, 0, 0, 0.283138,-99) , 
3, 0.306962, 0, 0, 0.465384,-99)    );
  // itree = 1134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78166, 1, 1, 0.794746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363838,-99) , 
0, -0.0219203, 1, 0, 0.569818,-99) , 
3, 0.543354, 0, 0, 0.711807,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.221227,-99) , 
3, -0.123397, 0, 0, 0.505848,-99)    );
  // itree = 1135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09527, 0, 1, 0.813321,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264923,-99) , 
0, 0.514897, 1, 0, 0.5165,-99) , 
3, 0.743058, 0, 0, 0.649619,-99) , 
NN(
0, 
0, 
-1, -1.39398, 0, -1, 0.108508,-99) , 
3, -0.719586, 0, 0, 0.499432,-99)    );
  // itree = 1136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74349, 0, 1, 0.848481,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236235,-99) , 
0, 0.911613, 1, 0, 0.596385,-99) , 
3, 1.12051, 0, 0, 0.7007,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.204566,-99) , 
3, -0.202496, 0, 0, 0.490602,-99)    );
  // itree = 1137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.857528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706082,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298295,-99) , 
0, 0.854666, 1, 0, 0.566075,-99) , 
3, 1.30512, 0, 0, 0.656756,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.207245,-99) , 
3, -0.304384, 0, 0, 0.490313,-99)    );
  // itree = 1138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.815985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280746,-99) , 
0, 0.210433, 1, 0, 0.549624,-99) , 
3, 0.666353, 0, 0, 0.690039,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.167982,-99) , 
0, -1.59703, 1, 0, 0.317142,-99) , 
NN(
0, 
0, 
-1, -0.476825, 1, -1, 0.0952667,-99) , 
3, -1.08414, 0, 0, 0.218202,-99) , 
3, -0.207894, 0, 0, 0.484253,-99)    );
  // itree = 1139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.832465,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410378,-99) , 
0, 0.739838, 1, 0, 0.679697,-99) , 
3, 1.02172, 0, 0, 0.763435,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287966,-99) , 
0, -0.765399, 1, 0, 0.438036,-99) , 
NN(
0, 
0, 
-1, -1.47262, 0, -1, 0.173351,-99) , 
3, -0.566003, 0, 0, 0.291782,-99) , 
3, 0.228725, 0, 0, 0.507056,-99)    );
  // itree = 1140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.03123, 0, 1, 0.730839,-99) , 
NN(
0, 
0, 
-1, -1.73248, 0, -1, 0.205671,-99) , 
3, -0.266059, 0, 0, 0.541728,-99)    );
  // itree = 1141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.848639,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444451,-99) , 
0, 0.228966, 1, 0, 0.608602,-99) , 
3, 0.99324, 0, 0, 0.709099,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145517,-99) , 
0, -1.01188, 1, 0, 0.290612,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.11247,-99) , 
3, -1.00886, 0, 0, 0.209677,-99) , 
3, -0.123397, 0, 0, 0.478989,-99)    );
  // itree = 1142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.883503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790228,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295749,-99) , 
0, 0.782483, 1, 0, 0.595959,-99) , 
3, 1.11054, 0, 0, 0.747596,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309441,-99) , 
0, -1.44513, 1, 0, 0.369788,-99) , 
NN(
0, 
0, 
-1, -0.301872, 1, -1, 0.10896,-99) , 
3, -1.03006, 0, 0, 0.289941,-99) , 
3, 0.307824, 0, 0, 0.482163,-99)    );
  // itree = 1143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.884411, 1, 1, 0.866284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317799,-99) , 
0, 0.717577, 1, 0, 0.608075,-99) , 
3, 0.902259, 0, 0, 0.755336,-99) , 
NN(
0, 
0, 
-1, -1.21561, 0, -1, 0.217261,-99) , 
3, 0.10264, 0, 0, 0.488475,-99)    );
  // itree = 1144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4999, 1, 1, 0.853977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278439,-99) , 
0, 0.80635, 1, 0, 0.589828,-99) , 
3, 0.995911, 0, 0, 0.694959,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187536,-99) , 
0, -1.19073, 1, 0, 0.327113,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.102849,-99) , 
3, -1.01154, 0, 0, 0.222942,-99) , 
3, -0.123397, 0, 0, 0.501568,-99)    );
  // itree = 1145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2067, 0, 1, 0.773316,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276271,-99) , 
0, -1.19434, 1, 0, 0.350137,-99) , 
NN(
0, 
0, 
-1, -0.572275, 1, -1, 0.100913,-99) , 
3, -1.11797, 0, 0, 0.260011,-99) , 
3, 0.20809, 0, 0, 0.500694,-99)    );
  // itree = 1146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.559643, 1, 1, 0.904253,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398944,-99) , 
0, 1.10293, 1, 0, 0.705562,-99) , 
3, 1.20314, 0, 0, 0.791451,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290426,-99) , 
0, -0.646644, 1, 0, 0.419826,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.135458,-99) , 
3, -0.402042, 0, 0, 0.229455,-99) , 
3, 0.238103, 0, 0, 0.462806,-99)    );
  // itree = 1147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82982, 0, 1, 0.847842,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323826,-99) , 
0, 0.540099, 1, 0, 0.596614,-99) , 
3, 0.98281, 0, 0, 0.699362,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22081,-99) , 
0, -1.19072, 1, 0, 0.348592,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.106246,-99) , 
3, -1.00886, 0, 0, 0.232361,-99) , 
3, -0.123397, 0, 0, 0.504218,-99)    );
  // itree = 1148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54712, 1, 1, 0.867653,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243294,-99) , 
0, 0.893448, 1, 0, 0.59402,-99) , 
3, 1.12392, 0, 0, 0.720138,-99) , 
NN(
0, 
0, 
-1, -0.447144, 0, -1, 0.249202,-99) , 
3, 0.0990605, 0, 0, 0.488822,-99)    );
  // itree = 1149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.863442,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297761,-99) , 
0, 1.10831, 1, 0, 0.642935,-99) , 
3, 1.28284, 0, 0, 0.743316,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30389,-99) , 
0, -0.765399, 1, 0, 0.395983,-99) , 
NN(
0, 
0, 
-1, -1.72327, 0, -1, 0.124622,-99) , 
3, -0.548378, 0, 0, 0.236105,-99) , 
3, 0.262941, 0, 0, 0.451793,-99)    );
  // itree = 1150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.3782, 1, 1, 0.835434,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414828,-99) , 
0, 0.774542, 1, 0, 0.603327,-99) , 
3, 1.21436, 0, 0, 0.691846,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257354,-99) , 
1, 0.0480792, 1, 0, 0.433384,-99) , 
NN(
0, 
0, 
-1, 0.551813, 1, -1, 0.164958,-99) , 
3, -0.651936, 0, 0, 0.279255,-99) , 
3, 0.17816, 0, 0, 0.474346,-99)    );
  // itree = 1151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.64019, 1, 1, 0.843935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367402,-99) , 
0, -0.0188443, 1, 0, 0.576092,-99) , 
3, 0.845703, 0, 0, 0.710401,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.238828,-99) , 
3, -0.304384, 0, 0, 0.53711,-99)    );
  // itree = 1152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.79641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290286,-99) , 
0, 0.478161, 1, 0, 0.550413,-99) , 
3, 0.714651, 0, 0, 0.688545,-99) , 
NN(
0, 
0, 
-1, -0.572275, 1, -1, 0.242365,-99) , 
3, -0.18324, 0, 0, 0.507106,-99)    );
  // itree = 1153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4999, 1, 1, 0.846551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.879535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402081,-99) , 
0, 0.602894, 1, 0, 0.622102,-99) , 
3, 0.982657, 0, 0, 0.754635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314949,-99) , 
0, -0.745016, 1, 0, 0.408314,-99) , 
NN(
0, 
0, 
-1, -1.76683, 1, -1, 0.171593,-99) , 
3, -0.566981, 0, 0, 0.285313,-99) , 
3, 0.392653, 0, 0, 0.480293,-99)    );
  // itree = 1154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.23569, 0, 1, 0.775158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490726,-99) , 
3, 0.250256, 0, 0, 0.707906,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.236358,-99) , 
3, -0.202496, 0, 0, 0.531869,-99)    );
  // itree = 1155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54644, 1, 1, 0.804889,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264272,-99) , 
0, 0.100195, 1, 0, 0.537118,-99) , 
3, 0.509059, 0, 0, 0.684318,-99) , 
NN(
0, 
0, 
-1, -1.26499, 0, -1, 0.153464,-99) , 
3, -0.711955, 0, 0, 0.528902,-99)    );
  // itree = 1156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62101, 1, 1, 0.843169,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328675,-99) , 
0, 0.781704, 1, 0, 0.588838,-99) , 
3, 1.05197, 0, 0, 0.692661,-99) , 
NN(
0, 
0, 
-1, -0.82831, 0, -1, 0.223588,-99) , 
3, -0.25059, 0, 0, 0.499555,-99)    );
  // itree = 1157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.87811, 1, 1, 0.868147,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805696,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312783,-99) , 
0, 1.06604, 1, 0, 0.622182,-99) , 
3, 1.2248, 0, 0, 0.73715,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430683,-99) , 
3, -0.0254654, 0, 0, 0.504072,-99) , 
NN(
0, 
0, 
-1, -0.870995, 1, -1, 0.207368,-99) , 
3, -0.302436, 0, 0, 0.29571,-99) , 
3, 0.228725, 0, 0, 0.497053,-99)    );
  // itree = 1158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.889344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392819,-99) , 
0, 0.848875, 1, 0, 0.616974,-99) , 
3, 1.27367, 0, 0, 0.695443,-99) , 
NN(
0, 
0, 
-1, -1.03187, 0, -1, 0.192763,-99) , 
3, -0.28269, 0, 0, 0.517218,-99)    );
  // itree = 1159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00736, 0, 1, 0.753846,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291918,-99) , 
0, -1.07324, 1, 0, 0.395632,-99) , 
NN(
0, 
0, 
-1, -2.85101, 1, -1, 0.0937977,-99) , 
3, -0.927516, 0, 0, 0.259227,-99) , 
3, 0.17816, 0, 0, 0.496987,-99)    );
  // itree = 1160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.859287,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273177,-99) , 
0, 0.857117, 1, 0, 0.552671,-99) , 
3, 1.10862, 0, 0, 0.665636,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.213842,-99) , 
3, -0.202496, 0, 0, 0.49715,-99)    );
  // itree = 1161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.83837, 0, 1, 0.861255,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.972939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477564,-99) , 
0, -0.197094, 1, 0, 0.602335,-99) , 
3, 1.20395, 0, 0, 0.697075,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207686,-99) , 
0, -1.21605, 1, 0, 0.362369,-99) , 
NN(
0, 
0, 
-1, 0.0452821, 1, -1, 0.117364,-99) , 
3, -1.00886, 0, 0, 0.246277,-99) , 
3, -0.123397, 0, 0, 0.506673,-99)    );
  // itree = 1162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.197206, 1, 1, 0.866336,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365454,-99) , 
3, 1.03374, 0, 0, 0.656141,-99) , 
0, 0.561948, 1, 0, 0.726434,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15228,-99) , 
0, -1.1431, 1, 0, 0.286057,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.112757,-99) , 
3, -1.07432, 0, 0, 0.211633,-99) , 
3, -0.103721, 0, 0, 0.49831,-99)    );
  // itree = 1163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.850606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373077,-99) , 
0, 0.696072, 1, 0, 0.663947,-99) , 
3, 1.0818, 0, 0, 0.763244,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250207,-99) , 
0, -0.424041, 1, 0, 0.442988,-99) , 
NN(
0, 
0, 
-1, -1.46184, 1, -1, 0.189402,-99) , 
3, -0.548378, 0, 0, 0.292515,-99) , 
3, 0.262941, 0, 0, 0.508409,-99)    );
  // itree = 1164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.215512, 1, 1, 0.909419,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324933,-99) , 
3, 1.01583, 0, 0, 0.664053,-99) , 
0, 0.689612, 1, 0, 0.745337,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331783,-99) , 
0, -0.765399, 1, 0, 0.458844,-99) , 
NN(
0, 
0, 
-1, -0.257029, 1, -1, 0.171738,-99) , 
3, -0.591878, 0, 0, 0.297981,-99) , 
3, 0.20809, 0, 0, 0.508792,-99)    );
  // itree = 1165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.99434, 0, 1, 0.842351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30412,-99) , 
0, 0.309434, 1, 0, 0.569554,-99) , 
3, 0.98281, 0, 0, 0.696266,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209788,-99) , 
0, -1.21605, 1, 0, 0.362005,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.103021,-99) , 
3, -1.01267, 0, 0, 0.230642,-99) , 
3, -0.123397, 0, 0, 0.481668,-99)    );
  // itree = 1166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.309776, 1, 1, 0.88476,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365737,-99) , 
3, 1.25816, 0, 0, 0.65082,-99) , 
0, 0.910697, 1, 0, 0.736993,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332778,-99) , 
0, -0.831231, 1, 0, 0.426311,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.10471,-99) , 
3, -0.997806, 0, 0, 0.305528,-99) , 
3, 0.254861, 0, 0, 0.499508,-99)    );
  // itree = 1167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.834994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465903,-99) , 
2, 0.363209, 1, 0, 0.638237,-99) , 
3, 1.217, 0, 0, 0.726417,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262807,-99) , 
0, -1.44513, 1, 0, 0.347634,-99) , 
NN(
0, 
0, 
-1, -0.259045, 1, -1, 0.106695,-99) , 
3, -1.2031, 0, 0, 0.272502,-99) , 
3, 0.17816, 0, 0, 0.491914,-99)    );
  // itree = 1168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.74751, 1, 1, 0.836102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340579,-99) , 
0, 0.248521, 1, 0, 0.626282,-99) , 
3, 0.661507, 0, 0, 0.761526,-99) , 
NN(
0, 
0, 
-1, -0.49459, 0, -1, 0.259013,-99) , 
3, 0.0509667, 0, 0, 0.526477,-99)    );
  // itree = 1169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.805619, 0, 1, 0.767881,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263106,-99) , 
0, -1.06114, 1, 0, 0.388628,-99) , 
NN(
0, 
0, 
-1, -0.301872, 1, -1, 0.0918307,-99) , 
3, -1.20793, 0, 0, 0.29242,-99) , 
3, 0.17816, 0, 0, 0.530277,-99)    );
  // itree = 1170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.861592,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396006,-99) , 
0, 0.932405, 1, 0, 0.612162,-99) , 
3, 1.3922, 0, 0, 0.710541,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3213,-99) , 
1, -0.418348, 1, 0, 0.433175,-99) , 
NN(
0, 
0, 
-1, -2.54298, 1, -1, 0.141095,-99) , 
3, -0.702968, 0, 0, 0.296944,-99) , 
3, 0.238103, 0, 0, 0.490924,-99)    );
  // itree = 1171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.864641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476347,-99) , 
0, -0.00616939, 1, 0, 0.573668,-99) , 
3, 1.33799, 0, 0, 0.654202,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226441,-99) , 
0, -1.17488, 1, 0, 0.361952,-99) , 
NN(
0, 
0, 
-1, 0.0408162, 1, -1, 0.130283,-99) , 
3, -1.07684, 0, 0, 0.257426,-99) , 
3, -0.202496, 0, 0, 0.49912,-99)    );
  // itree = 1172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0510236, 1, 1, 0.872772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271963,-99) , 
3, 1.06589, 0, 0, 0.623748,-99) , 
0, 0.709428, 1, 0, 0.708478,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222597,-99) , 
0, -1.20764, 1, 0, 0.352533,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.111898,-99) , 
3, -1.03104, 0, 0, 0.248662,-99) , 
3, 0.0509667, 0, 0, 0.498206,-99)    );
  // itree = 1173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.862456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477748,-99) , 
0, 0.972004, 1, 0, 0.744668,-99) , 
3, 1.29901, 0, 0, 0.79683,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325492,-99) , 
0, -0.802449, 1, 0, 0.438005,-99) , 
NN(
0, 
0, 
-1, -0.988581, 0, -1, 0.170126,-99) , 
3, -0.52447, 0, 0, 0.293145,-99) , 
3, 0.28719, 0, 0, 0.517667,-99)    );
  // itree = 1174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39569, 0, 1, 0.819486,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324552,-99) , 
0, 0.46484, 1, 0, 0.55498,-99) , 
3, 0.894224, 0, 0, 0.673618,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.207666,-99) , 
3, -0.202496, 0, 0, 0.480925,-99)    );
  // itree = 1175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.868023,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307321,-99) , 
0, 0.923985, 1, 0, 0.640143,-99) , 
3, 1.14517, 0, 0, 0.727078,-99) , 
NN(
0, 
0, 
-1, -0.963597, 0, -1, 0.234586,-99) , 
3, -0.210183, 0, 0, 0.531858,-99)    );
  // itree = 1176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.85412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363314,-99) , 
0, 0.958348, 1, 0, 0.655742,-99) , 
3, 1.21436, 0, 0, 0.733737,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3796,-99) , 
0, -0.808923, 1, 0, 0.502828,-99) , 
NN(
0, 
0, 
-1, -1.37635, 0, -1, 0.179367,-99) , 
3, -0.379167, 0, 0, 0.28785,-99) , 
3, 0.17816, 0, 0, 0.494765,-99)    );
  // itree = 1177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.864894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452946,-99) , 
0, 0.553404, 1, 0, 0.609629,-99) , 
3, 1.3205, 0, 0, 0.689615,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198166,-99) , 
0, -1.20513, 1, 0, 0.347489,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.0965437,-99) , 
3, -1.09402, 0, 0, 0.227917,-99) , 
3, -0.207894, 0, 0, 0.514955,-99)    );
  // itree = 1178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22221, 0, 1, 0.743868,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294799,-99) , 
0, -1.05182, 1, 0, 0.408396,-99) , 
NN(
0, 
0, 
-1, -1.2287, 0, -1, 0.120719,-99) , 
3, -0.691476, 0, 0, 0.257055,-99) , 
3, 0.254861, 0, 0, 0.48097,-99)    );
  // itree = 1179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.830775,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355718,-99) , 
0, 0.117647, 1, 0, 0.544806,-99) , 
NN(
0, 
0, 
-1, -1.21985, 0, -1, 0.212269,-99) , 
3, -0.513078, 0, 0, 0.386416,-99) , 
3, 0.644527, 0, 0, 0.558747,-99)    );
  // itree = 1180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.26929, 1, 1, 0.878062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248096,-99) , 
0, 0.733197, 1, 0, 0.602565,-99) , 
3, 1.06835, 0, 0, 0.697978,-99) , 
NN(
0, 
0, 
-1, -1.11972, 0, -1, 0.189297,-99) , 
3, -0.25059, 0, 0, 0.500429,-99)    );
  // itree = 1181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00493, 0, 1, 0.887705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484568,-99) , 
3, 1.3803, 0, 0, 0.719496,-99) , 
0, 1.09484, 1, 0, 0.795006,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297995,-99) , 
0, -1.27242, 1, 0, 0.395488,-99) , 
NN(
0, 
0, 
-1, 0.0509554, 1, -1, 0.0924618,-99) , 
3, -0.957285, 0, 0, 0.259681,-99) , 
3, 0.306962, 0, 0, 0.4795,-99)    );
  // itree = 1182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.868608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292476,-99) , 
0, 0.647916, 1, 0, 0.536312,-99) , 
3, 1.07541, 0, 0, 0.649704,-99) , 
NN(
0, 
0, 
-1, -1.07301, 0, -1, 0.210455,-99) , 
3, -0.304384, 0, 0, 0.49324,-99)    );
  // itree = 1183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32054, 0, 1, 0.819384,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259431,-99) , 
0, 0.781704, 1, 0, 0.593544,-99) , 
3, 0.98281, 0, 0, 0.701785,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170153,-99) , 
0, -0.994913, 1, 0, 0.360114,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.0714113,-99) , 
3, -1.01154, 0, 0, 0.214293,-99) , 
3, -0.123397, 0, 0, 0.506518,-99)    );
  // itree = 1184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0237419, 1, 1, 0.787031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443522,-99) , 
3, 0.230855, 0, 0, 0.716698,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188923,-99) , 
0, -1.20513, 1, 0, 0.329894,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0952144,-99) , 
3, -1.09238, 0, 0, 0.211297,-99) , 
3, -0.207894, 0, 0, 0.514332,-99)    );
  // itree = 1185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55316, 0, 1, 0.764362,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381629,-99) , 
0, -0.118109, 1, 0, 0.540443,-99) , 
3, 0.615993, 0, 0, 0.662308,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.175844,-99) , 
3, -0.304384, 0, 0, 0.484541,-99)    );
  // itree = 1186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.458562, 1, 1, 0.884703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368234,-99) , 
3, 1.14028, 0, 0, 0.675995,-99) , 
0, 1.01152, 1, 0, 0.759822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33777,-99) , 
0, -0.773268, 1, 0, 0.428425,-99) , 
NN(
0, 
0, 
-1, -1.305, 0, -1, 0.137227,-99) , 
3, -0.616659, 0, 0, 0.269316,-99) , 
3, 0.183842, 0, 0, 0.488763,-99)    );
  // itree = 1187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.50291, 1, 1, 0.912978,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476003,-99) , 
3, 1.32762, 0, 0, 0.714027,-99) , 
0, 0.709428, 1, 0, 0.774901,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199816,-99) , 
0, -0.16264, 1, 0, 0.437517,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.154186,-99) , 
3, -0.644871, 0, 0, 0.308539,-99) , 
3, 0.301115, 0, 0, 0.510561,-99)    );
  // itree = 1188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60088, 1, 1, 0.834673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494961,-99) , 
0, 0.265001, 1, 0, 0.625284,-99) , 
3, 0.889066, 0, 0, 0.762393,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2905,-99) , 
0, -1.27096, 1, 0, 0.37869,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.0766658,-99) , 
3, -0.959342, 0, 0, 0.251807,-99) , 
3, 0.301115, 0, 0, 0.468835,-99)    );
  // itree = 1189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55767, 0, 1, 0.821288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417347,-99) , 
0, -0.0681195, 1, 0, 0.591324,-99) , 
3, 0.672086, 0, 0, 0.723846,-99) , 
NN(
0, 
0, 
-1, -0.643735, 1, -1, 0.172967,-99) , 
3, -0.202496, 0, 0, 0.483743,-99)    );
  // itree = 1190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06258, 1, 1, 0.768056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250768,-99) , 
0, -0.424041, 1, 0, 0.480166,-99) , 
3, 0.242405, 0, 0, 0.664879,-99) , 
NN(
0, 
0, 
-1, -1.17803, 0, -1, 0.202302,-99) , 
3, -0.435158, 0, 0, 0.508828,-99)    );
  // itree = 1191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.829357,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27912,-99) , 
0, 0.96273, 1, 0, 0.614191,-99) , 
3, 1.00736, 0, 0, 0.716739,-99) , 
NN(
0, 
0, 
-1, -0.38455, 0, -1, 0.231442,-99) , 
3, 0.17816, 0, 0, 0.463494,-99)    );
  // itree = 1192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51354, 1, 1, 0.832015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2775,-99) , 
0, 0.893448, 1, 0, 0.624929,-99) , 
3, 1.03256, 0, 0, 0.734035,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316269,-99) , 
0, -1.39026, 1, 0, 0.40262,-99) , 
NN(
0, 
0, 
-1, -1.65002, 1, -1, 0.099994,-99) , 
3, -1.09308, 0, 0, 0.304562,-99) , 
3, 0.228725, 0, 0, 0.512929,-99)    );
  // itree = 1193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19768, 1, 1, 0.856802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392975,-99) , 
0, 0.465064, 1, 0, 0.596722,-99) , 
3, 1.10862, 0, 0, 0.699943,-99) , 
NN(
0, 
0, 
-1, -0.572275, 1, -1, 0.21749,-99) , 
3, -0.202496, 0, 0, 0.516323,-99)    );
  // itree = 1194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75547, 1, 1, 0.891884,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452022,-99) , 
0, 0.465064, 1, 0, 0.627208,-99) , 
3, 1.27634, 0, 0, 0.713204,-99) , 
NN(
0, 
0, 
-1, -1.02307, 0, -1, 0.184534,-99) , 
3, -0.28269, 0, 0, 0.50386,-99)    );
  // itree = 1195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.778543,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306426,-99) , 
0, -0.991976, 1, 0, 0.42166,-99) , 
NN(
0, 
0, 
-1, -0.548365, 1, -1, 0.176969,-99) , 
3, -0.644244, 0, 0, 0.303847,-99) , 
3, 0.301115, 0, 0, 0.515603,-99)    );
  // itree = 1196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.836299,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329327,-99) , 
0, 0.819377, 1, 0, 0.668458,-99) , 
3, 1.00736, 0, 0, 0.760916,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403949,-99) , 
3, -0.107398, 0, 0, 0.459646,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.158701,-99) , 
3, -0.376357, 0, 0, 0.256767,-99) , 
3, 0.17816, 0, 0, 0.493576,-99)    );
  // itree = 1197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19067, 1, 1, 0.846831,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363092,-99) , 
0, 1.23394, 1, 0, 0.652721,-99) , 
3, 1.28284, 0, 0, 0.731387,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293692,-99) , 
0, -0.566574, 1, 0, 0.457665,-99) , 
NN(
0, 
0, 
-1, -1.01585, 0, -1, 0.161439,-99) , 
3, -0.548378, 0, 0, 0.282191,-99) , 
3, 0.262941, 0, 0, 0.486722,-99)    );
  // itree = 1198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27925, 1, 1, 0.867004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312228,-99) , 
0, 0.708301, 1, 0, 0.584216,-99) , 
3, 1.10245, 0, 0, 0.678994,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.198879,-99) , 
3, -0.207894, 0, 0, 0.467759,-99)    );
  // itree = 1199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42479, 0, 1, 0.850168,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375498,-99) , 
0, 0.552036, 1, 0, 0.585104,-99) , 
3, 1.10862, 0, 0, 0.692563,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.220036,-99) , 
3, -0.202496, 0, 0, 0.472034,-99)    );
  // itree = 1200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50447, 1, 1, 0.801441,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413109,-99) , 
0, -0.108227, 1, 0, 0.610198,-99) , 
3, 0.543354, 0, 0, 0.733826,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.229031,-99) , 
3, -0.123397, 0, 0, 0.513111,-99)    );
  // itree = 1201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89241, 1, 1, 0.867855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399794,-99) , 
0, 0.780672, 1, 0, 0.59857,-99) , 
3, 1.36906, 0, 0, 0.684232,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180152,-99) , 
0, -1.31319, 1, 0, 0.323573,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.134179,-99) , 
3, -1.10799, 0, 0, 0.24178,-99) , 
3, -0.142366, 0, 0, 0.508148,-99)    );
  // itree = 1202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66646, 0, 1, 0.774744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276688,-99) , 
0, -0.2316, 1, 0, 0.414425,-99) , 
NN(
0, 
0, 
-1, -1.36539, 1, -1, 0.19615,-99) , 
3, -0.325669, 0, 0, 0.280155,-99) , 
3, 0.306962, 0, 0, 0.485929,-99)    );
  // itree = 1203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21129, 1, 1, 0.834105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.939138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479264,-99) , 
0, 0.213349, 1, 0, 0.636226,-99) , 
3, 0.90335, 0, 0, 0.758034,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351981,-99) , 
0, -0.857739, 1, 0, 0.44863,-99) , 
NN(
0, 
0, 
-1, -1.85224, 1, -1, 0.0932038,-99) , 
3, -0.796022, 0, 0, 0.270321,-99) , 
3, 0.28719, 0, 0, 0.484439,-99)    );
  // itree = 1204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.834847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341143,-99) , 
0, -0.18246, 1, 0, 0.554791,-99) , 
3, 0.540529, 0, 0, 0.734128,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.226055,-99) , 
3, -0.123397, 0, 0, 0.50491,-99)    );
  // itree = 1205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12447, 1, 1, 0.885352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316616,-99) , 
0, 1.04549, 1, 0, 0.633084,-99) , 
3, 1.2063, 0, 0, 0.725271,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.232225,-99) , 
3, -0.123397, 0, 0, 0.516743,-99)    );
  // itree = 1206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.851043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447489,-99) , 
0, -0.0814742, 1, 0, 0.56395,-99) , 
3, 1.14517, 0, 0, 0.674641,-99) , 
NN(
0, 
0, 
-1, -1.45901, 0, -1, 0.191914,-99) , 
3, -0.210183, 0, 0, 0.474626,-99)    );
  // itree = 1207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.863427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447254,-99) , 
0, 0.912588, 1, 0, 0.631075,-99) , 
3, 1.37581, 0, 0, 0.730117,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171727,-99) , 
0, -0.0856679, 1, 0, 0.389509,-99) , 
NN(
0, 
0, 
-1, 0.0509554, 1, -1, 0.170238,-99) , 
3, -0.566981, 0, 0, 0.283621,-99) , 
3, 0.392653, 0, 0, 0.465718,-99)    );
  // itree = 1208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.448346, 0, 1, 0.829846,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81059,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343106,-99) , 
3, 1.38762, 0, 0, 0.631734,-99) , 
0, 1.50474, 1, 0, 0.735834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602628,-99) , 
NN(
0, 
0, 
-1, -1.81388, 0, -1, 0.198575,-99) , 
3, -0.0116291, 0, 0, 0.257712,-99) , 
3, 0.306962, 0, 0, 0.455896,-99)    );
  // itree = 1209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.2821, 1, 1, 0.818449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332333,-99) , 
0, -0.623506, 1, 0, 0.507278,-99) , 
3, 0.25374, 0, 0, 0.719956,-99) , 
NN(
0, 
0, 
-1, -1.17803, 0, -1, 0.145294,-99) , 
3, -0.420978, 0, 0, 0.53325,-99)    );
  // itree = 1210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.85693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335211,-99) , 
0, 0.424748, 1, 0, 0.556946,-99) , 
3, 0.994438, 0, 0, 0.692056,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196669,-99) , 
0, -1.21605, 1, 0, 0.345028,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.0947658,-99) , 
3, -1.00946, 0, 0, 0.223391,-99) , 
3, -0.123397, 0, 0, 0.508797,-99)    );
  // itree = 1211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80194, 1, 1, 0.851997,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306528,-99) , 
0, 1.0116, 1, 0, 0.636392,-99) , 
3, 1.10862, 0, 0, 0.719335,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132596,-99) , 
3, -1.08857, 0, 0, 0.314528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.125975,-99) , 
0, -1.17657, 1, 0, 0.23378,-99) , 
3, -0.202496, 0, 0, 0.515127,-99)    );
  // itree = 1212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11792, 1, 1, 0.767556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253099,-99) , 
0, 0.241587, 1, 0, 0.538994,-99) , 
3, 0.540529, 0, 0, 0.67867,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211909,-99) , 
0, -1.36423, 1, 0, 0.364308,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.120091,-99) , 
3, -1.00886, 0, 0, 0.238255,-99) , 
3, -0.123397, 0, 0, 0.488957,-99)    );
  // itree = 1213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.887176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415967,-99) , 
0, 0.943047, 1, 0, 0.624139,-99) , 
3, 1.42509, 0, 0, 0.703094,-99) , 
NN(
0, 
0, 
-1, -1.30427, 0, -1, 0.18981,-99) , 
3, -0.123397, 0, 0, 0.478262,-99)    );
  // itree = 1214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.873425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420967,-99) , 
0, 0.148161, 1, 0, 0.585129,-99) , 
3, 1.07541, 0, 0, 0.698234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502966,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145828,-99) , 
0, -1.3525, 1, 0, 0.280462,-99) , 
NN(
0, 
0, 
-1, -1.94735, 0, -1, 0.0651699,-99) , 
3, -1.31804, 0, 0, 0.189806,-99) , 
3, -0.304384, 0, 0, 0.502308,-99)    );
  // itree = 1215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.58992, 1, 1, 0.855659,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224069,-99) , 
0, 1.0116, 1, 0, 0.579897,-99) , 
3, 1.14627, 0, 0, 0.673497,-99) , 
NN(
0, 
0, 
-1, -0.712309, 0, -1, 0.209176,-99) , 
3, -0.210183, 0, 0, 0.490186,-99)    );
  // itree = 1216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.179125, 1, 1, 0.851747,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440447,-99) , 
0, 0.488413, 1, 0, 0.668799,-99) , 
3, 0.835551, 0, 0, 0.788698,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319971,-99) , 
0, -0.637481, 1, 0, 0.450532,-99) , 
NN(
0, 
0, 
-1, -1.01732, 0, -1, 0.149834,-99) , 
3, -0.553424, 0, 0, 0.27596,-99) , 
3, 0.240737, 0, 0, 0.508956,-99)    );
  // itree = 1217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08013, 0, 1, 0.818031,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380151,-99) , 
1, -0.65168, 1, 0, 0.480963,-99) , 
NN(
0, 
0, 
-1, -1.97172, 1, -1, 0.129829,-99) , 
3, -0.818721, 0, 0, 0.29345,-99) , 
3, 0.262941, 0, 0, 0.53798,-99)    );
  // itree = 1218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15134, 1, 1, 0.869451,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360986,-99) , 
0, 0.819377, 1, 0, 0.616646,-99) , 
3, 1.02994, 0, 0, 0.744221,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317901,-99) , 
1, -0.210965, 1, 0, 0.444601,-99) , 
NN(
0, 
0, 
-1, -1.76953, 1, -1, 0.141116,-99) , 
3, -0.690826, 0, 0, 0.283376,-99) , 
3, 0.254861, 0, 0, 0.489595,-99)    );
  // itree = 1219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2574, 1, 1, 0.853365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358173,-99) , 
0, 0.56721, 1, 0, 0.619292,-99) , 
3, 1.10245, 0, 0, 0.716365,-99) , 
NN(
0, 
0, 
-1, -0.502825, 0, -1, 0.233945,-99) , 
3, -0.207894, 0, 0, 0.514458,-99)    );
  // itree = 1220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.696123, 0, 1, 0.776572,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294253,-99) , 
3, -0.497209, 0, 0, 0.469809,-99) , 
NN(
0, 
0, 
-1, -0.329146, 0, -1, 0.173614,-99) , 
1, -0.43947, 1, 0, 0.263592,-99) , 
3, 0.306962, 0, 0, 0.481565,-99)    );
  // itree = 1221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.854381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434535,-99) , 
0, -0.00616939, 1, 0, 0.563052,-99) , 
3, 1.05358, 0, 0, 0.680893,-99) , 
NN(
0, 
0, 
-1, -1.1213, 0, -1, 0.193418,-99) , 
3, -0.25059, 0, 0, 0.471542,-99)    );
  // itree = 1222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39222, 1, 1, 0.886074,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451283,-99) , 
0, 0.900482, 1, 0, 0.68325,-99) , 
3, 1.3949, 0, 0, 0.758501,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312632,-99) , 
0, -0.50049, 1, 0, 0.493897,-99) , 
NN(
0, 
0, 
-1, -1.23983, 0, -1, 0.142185,-99) , 
3, -0.391132, 0, 0, 0.260758,-99) , 
3, 0.238103, 0, 0, 0.480926,-99)    );
  // itree = 1223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.00653, 0, 1, 0.83337,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311808,-99) , 
0, 0.679905, 1, 0, 0.620159,-99) , 
3, 0.985321, 0, 0, 0.713958,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503615,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.182052,-99) , 
3, -0.419174, 0, 0, 0.245765,-99) , 
3, -0.123397, 0, 0, 0.505401,-99)    );
  // itree = 1224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.74751, 1, 1, 0.793661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48982,-99) , 
3, 0.325599, 0, 0, 0.717425,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.230908,-99) , 
3, -0.123397, 0, 0, 0.512917,-99)    );
  // itree = 1225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.603749, 1, 1, 0.80487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501497,-99) , 
NN(
0, 
0, 
-1, -1.37377, 1, -1, 0.198978,-99) , 
3, -0.376357, 0, 0, 0.291236,-99) , 
3, 0.17816, 0, 0, 0.532443,-99)    );
  // itree = 1226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.845157,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491049,-99) , 
2, 0.172519, 1, 0, 0.600216,-99) , 
3, 0.694882, 0, 0, 0.77177,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319016,-99) , 
0, -0.745016, 1, 0, 0.458908,-99) , 
NN(
0, 
0, 
-1, -1.2306, 0, -1, 0.150224,-99) , 
3, -0.52447, 0, 0, 0.279105,-99) , 
3, 0.28719, 0, 0, 0.498884,-99)    );
  // itree = 1227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84727, 1, 1, 0.881158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46956,-99) , 
0, 0.487565, 1, 0, 0.632862,-99) , 
3, 1.36979, 0, 0, 0.709144,-99) , 
NN(
0, 
0, 
-1, -0.707631, 0, -1, 0.225131,-99) , 
3, -0.210183, 0, 0, 0.507795,-99)    );
  // itree = 1228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.829265,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46631,-99) , 
0, -0.185514, 1, 0, 0.597678,-99) , 
3, 0.761669, 0, 0, 0.730233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211886,-99) , 
0, -1.41105, 1, 0, 0.363109,-99) , 
NN(
0, 
0, 
-1, -1.76902, 0, -1, 0.133263,-99) , 
3, -1.00886, 0, 0, 0.255475,-99) , 
3, -0.123397, 0, 0, 0.531484,-99)    );
  // itree = 1229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.851791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266442,-99) , 
0, 1.1468, 1, 0, 0.608092,-99) , 
3, 1.09392, 0, 0, 0.726751,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300084,-99) , 
0, -0.745016, 1, 0, 0.417431,-99) , 
NN(
0, 
0, 
-1, -2.46938, 1, -1, 0.134481,-99) , 
3, -0.792997, 0, 0, 0.287872,-99) , 
3, 0.28719, 0, 0, 0.484164,-99)    );
  // itree = 1230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.768458, 1, 1, 0.770596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427734,-99) , 
3, 0.298615, 0, 0, 0.709563,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277015,-99) , 
0, -1.36592, 1, 0, 0.384852,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.102606,-99) , 
3, -0.993962, 0, 0, 0.265392,-99) , 
3, 0.093663, 0, 0, 0.486682,-99)    );
  // itree = 1231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.236115, 1, 1, 0.862409,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496307,-99) , 
0, 0.639693, 1, 0, 0.70875,-99) , 
3, 0.968099, 0, 0, 0.789885,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31376,-99) , 
0, -1.21855, 1, 0, 0.396912,-99) , 
NN(
0, 
0, 
-1, 0.0452821, 1, -1, 0.132516,-99) , 
3, -1.13343, 0, 0, 0.300866,-99) , 
3, 0.180631, 0, 0, 0.543109,-99)    );
  // itree = 1232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35927, 1, 1, 0.816938,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261988,-99) , 
0, 0.354977, 1, 0, 0.553671,-99) , 
3, 0.774024, 0, 0, 0.7017,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161805,-99) , 
0, -1.31319, 1, 0, 0.314903,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.0992937,-99) , 
3, -1.0136, 0, 0, 0.21568,-99) , 
3, -0.123397, 0, 0, 0.490129,-99)    );
  // itree = 1233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.298272, 1, 1, 0.739352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328165,-99) , 
0, -0.781662, 1, 0, 0.48984,-99) , 
3, 0.214123, 0, 0, 0.663844,-99) , 
NN(
0, 
0, 
-1, -1.21118, 0, -1, 0.173262,-99) , 
3, -0.462829, 0, 0, 0.507286,-99)    );
  // itree = 1234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.839095,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351885,-99) , 
0, 0.56721, 1, 0, 0.58188,-99) , 
3, 1.00282, 0, 0, 0.69064,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242146,-99) , 
0, -1.55428, 1, 0, 0.363346,-99) , 
NN(
0, 
0, 
-1, -2.99143, 1, -1, 0.100585,-99) , 
3, -1.31648, 0, 0, 0.269754,-99) , 
3, -0.103721, 0, 0, 0.52599,-99)    );
  // itree = 1235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42951, 1, 1, 0.770478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296304,-99) , 
0, -0.0253559, 1, 0, 0.486221,-99) , 
3, 0.670287, 0, 0, 0.635857,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186704,-99) , 
0, -1.19072, 1, 0, 0.34976,-99) , 
NN(
0, 
0, 
-1, -0.0109455, 1, -1, 0.128108,-99) , 
3, -1.08414, 0, 0, 0.25594,-99) , 
3, -0.207894, 0, 0, 0.492913,-99)    );
  // itree = 1236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.58992, 1, 1, 0.865383,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351494,-99) , 
0, 0.852865, 1, 0, 0.683301,-99) , 
3, 1.08653, 0, 0, 0.783891,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286558,-99) , 
0, -0.85877, 1, 0, 0.440664,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.123419,-99) , 
3, -0.95623, 0, 0, 0.310459,-99) , 
3, 0.306962, 0, 0, 0.527179,-99)    );
  // itree = 1237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.702317, 1, 1, 0.778584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322749,-99) , 
0, -0.363896, 1, 0, 0.476131,-99) , 
3, 0.300567, 0, 0, 0.67987,-99) , 
NN(
0, 
0, 
-1, -1.43172, 1, -1, 0.194043,-99) , 
3, -0.38184, 0, 0, 0.509911,-99)    );
  // itree = 1238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.143069, 1, 1, 0.87762,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268993,-99) , 
0, 1.15378, 1, 0, 0.593492,-99) , 
3, 1.3205, 0, 0, 0.685949,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.209096,-99) , 
3, -0.207894, 0, 0, 0.495225,-99)    );
  // itree = 1239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82244, 1, 1, 0.845602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36302,-99) , 
0, 0.540099, 1, 0, 0.57617,-99) , 
3, 1.10592, 0, 0, 0.67826,-99) , 
NN(
0, 
0, 
-1, -0.793484, 0, -1, 0.212977,-99) , 
3, -0.207894, 0, 0, 0.468545,-99)    );
  // itree = 1240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.858266,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489737,-99) , 
0, 0.459356, 1, 0, 0.629421,-99) , 
3, 1.20395, 0, 0, 0.713377,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210202,-99) , 
0, -1.31837, 1, 0, 0.308589,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0807618,-99) , 
3, -1.01267, 0, 0, 0.211637,-99) , 
3, -0.123397, 0, 0, 0.474794,-99)    );
  // itree = 1241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.210848, 0, 1, 0.710635,-99) , 
NN(
0, 
0, 
-1, -1.37929, 1, -1, 0.229803,-99) , 
3, -0.232821, 0, 0, 0.520105,-99)    );
  // itree = 1242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.777489, 1, 1, 0.788247,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344756,-99) , 
0, 0.0136911, 1, 0, 0.575024,-99) , 
3, 0.666353, 0, 0, 0.700451,-99) , 
NN(
0, 
0, 
-1, -0.502825, 0, -1, 0.181282,-99) , 
3, -0.207894, 0, 0, 0.482595,-99)    );
  // itree = 1243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.836322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32737,-99) , 
0, 0.281825, 1, 0, 0.588823,-99) , 
3, 0.761669, 0, 0, 0.728705,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.235325,-99) , 
3, -0.123397, 0, 0, 0.531907,-99)    );
  // itree = 1244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.537341, 1, 1, 0.878071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45838,-99) , 
3, 1.42398, 0, 0, 0.707931,-99) , 
0, 1.10708, 1, 0, 0.783022,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290578,-99) , 
0, -0.646644, 1, 0, 0.440816,-99) , 
NN(
0, 
0, 
-1, -1.36539, 1, -1, 0.192493,-99) , 
3, -0.325669, 0, 0, 0.27224,-99) , 
3, 0.306962, 0, 0, 0.479875,-99)    );
  // itree = 1245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.88185,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388875,-99) , 
0, 1.16948, 1, 0, 0.633987,-99) , 
3, 1.42073, 0, 0, 0.719512,-99) , 
NN(
0, 
0, 
-1, -0.382101, 0, -1, 0.240783,-99) , 
3, 0.17816, 0, 0, 0.469169,-99)    );
  // itree = 1246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.278064, 1, 1, 0.864412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409182,-99) , 
3, 1.12304, 0, 0, 0.675134,-99) , 
0, 0.778492, 1, 0, 0.744525,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260183,-99) , 
0, -0.234363, 1, 0, 0.492204,-99) , 
NN(
0, 
0, 
-1, -1.76953, 1, -1, 0.175664,-99) , 
3, -0.684971, 0, 0, 0.328354,-99) , 
3, 0.254861, 0, 0, 0.523398,-99)    );
  // itree = 1247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.862382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343012,-99) , 
0, 0.893448, 1, 0, 0.65818,-99) , 
3, 1.17763, 0, 0, 0.747828,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539094,-99) , 
NN(
0, 
0, 
-1, -1.28861, 0, -1, 0.247129,-99) , 
3, -0.0967366, 0, 0, 0.303661,-99) , 
3, 0.218994, 0, 0, 0.506935,-99)    );
  // itree = 1248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.870054,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334681,-99) , 
0, 1.01899, 1, 0, 0.65281,-99) , 
3, 1.21436, 0, 0, 0.750635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374439,-99) , 
0, -0.669293, 1, 0, 0.502183,-99) , 
NN(
0, 
0, 
-1, -2.45689, 1, -1, 0.165994,-99) , 
3, -0.382101, 0, 0, 0.271045,-99) , 
3, 0.17816, 0, 0, 0.50011,-99)    );
  // itree = 1249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.543489, 1, 1, 0.765711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314692,-99) , 
0, -0.566574, 1, 0, 0.492849,-99) , 
3, 0.242405, 0, 0, 0.676315,-99) , 
NN(
0, 
0, 
-1, -0.93168, 0, -1, 0.16533,-99) , 
3, -0.435158, 0, 0, 0.478353,-99)    );
  // itree = 1250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.715432, 0, 1, 0.86872,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336135,-99) , 
3, 1.16544, 0, 0, 0.667121,-99) , 
0, 1.06258, 1, 0, 0.743672,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305005,-99) , 
0, -0.745016, 1, 0, 0.463561,-99) , 
NN(
0, 
0, 
-1, -1.79745, 1, -1, 0.169028,-99) , 
3, -0.52447, 0, 0, 0.278985,-99) , 
3, 0.28719, 0, 0, 0.480294,-99)    );
  // itree = 1251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.830393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338203,-99) , 
0, 0.722702, 1, 0, 0.573259,-99) , 
3, 1.0105, 0, 0, 0.705411,-99) , 
NN(
0, 
0, 
-1, -0.379167, 0, -1, 0.230499,-99) , 
3, 0.17816, 0, 0, 0.450846,-99)    );
  // itree = 1252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.837761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269588,-99) , 
0, 1.20619, 1, 0, 0.639191,-99) , 
3, 1.24236, 0, 0, 0.713371,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154666,-99) , 
0, -0.997344, 1, 0, 0.304915,-99) , 
NN(
0, 
0, 
-1, -2.489, 1, -1, 0.152701,-99) , 
3, -0.80035, 0, 0, 0.220879,-99) , 
3, -0.0698586, 0, 0, 0.478745,-99)    );
  // itree = 1253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42509, 0, 1, 0.736903,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.212509,-99) , 
3, -0.123397, 0, 0, 0.513527,-99)    );
  // itree = 1254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.866979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355088,-99) , 
0, 0.923985, 1, 0, 0.58412,-99) , 
3, 1.33772, 0, 0, 0.678263,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.204126,-99) , 
3, -0.202496, 0, 0, 0.454508,-99)    );
  // itree = 1255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.856963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31236,-99) , 
0, 1.01065, 1, 0, 0.607361,-99) , 
3, 1.25366, 0, 0, 0.684725,-99) , 
NN(
0, 
0, 
-1, -0.99716, 0, -1, 0.183727,-99) , 
3, -0.276907, 0, 0, 0.500576,-99)    );
  // itree = 1256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.45254, 1, 1, 0.857417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358885,-99) , 
0, 0.793469, 1, 0, 0.609675,-99) , 
3, 1.1447, 0, 0, 0.706115,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156968,-99) , 
0, -1.34583, 1, 0, 0.327797,-99) , 
NN(
0, 
0, 
-1, -3.10718, 1, -1, 0.110129,-99) , 
3, -0.964563, 0, 0, 0.224243,-99) , 
3, -0.210183, 0, 0, 0.506397,-99)    );
  // itree = 1257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.858305,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280515,-99) , 
0, 0.900473, 1, 0, 0.583694,-99) , 
3, 1.20683, 0, 0, 0.679465,-99) , 
NN(
0, 
0, 
-1, -1.31074, 0, -1, 0.177006,-99) , 
3, -0.340957, 0, 0, 0.482728,-99)    );
  // itree = 1258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12724, 1, 1, 0.853735,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358112,-99) , 
0, 0.829465, 1, 0, 0.605172,-99) , 
3, 1.08418, 0, 0, 0.727607,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288837,-99) , 
1, -0.276999, 1, 0, 0.412946,-99) , 
NN(
0, 
0, 
-1, -1.76683, 1, -1, 0.146126,-99) , 
3, -0.64095, 0, 0, 0.280335,-99) , 
3, 0.306962, 0, 0, 0.47094,-99)    );
  // itree = 1259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.871794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468655,-99) , 
0, -0.131172, 1, 0, 0.582298,-99) , 
3, 1.30512, 0, 0, 0.667596,-99) , 
NN(
0, 
0, 
-1, -0.8155, 0, -1, 0.201551,-99) , 
3, -0.304384, 0, 0, 0.497308,-99)    );
  // itree = 1260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.814417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495844,-99) , 
1, -0.446265, 1, 0, 0.597082,-99) , 
3, 0.920115, 0, 0, 0.703695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210121,-99) , 
0, -1.18308, 1, 0, 0.360433,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.108524,-99) , 
3, -1.21243, 0, 0, 0.252837,-99) , 
3, -0.210183, 0, 0, 0.523572,-99)    );
  // itree = 1261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36979, 0, 1, 0.718339,-99) , 
NN(
0, 
0, 
-1, -0.707631, 0, -1, 0.226342,-99) , 
3, -0.210183, 0, 0, 0.513834,-99)    );
  // itree = 1262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.870626,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363223,-99) , 
0, 0.781704, 1, 0, 0.630028,-99) , 
3, 1.26767, 0, 0, 0.718353,-99) , 
NN(
0, 
0, 
-1, -0.498724, 0, -1, 0.245344,-99) , 
3, 0.0509667, 0, 0, 0.492094,-99)    );
  // itree = 1263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90497, 1, 1, 0.862388,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474126,-99) , 
0, -0.138143, 1, 0, 0.595707,-99) , 
3, 1.1447, 0, 0, 0.693404,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176714,-99) , 
0, -1.38339, 1, 0, 0.309197,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0768223,-99) , 
3, -1.20728, 0, 0, 0.212693,-99) , 
3, -0.210183, 0, 0, 0.50527,-99)    );
  // itree = 1264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14782, 0, 1, 0.761116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490592,-99) , 
3, 0.167085, 0, 0, 0.702326,-99) , 
NN(
0, 
0, 
-1, -1.1305, 0, -1, 0.197664,-99) , 
3, -0.266059, 0, 0, 0.499096,-99)    );
  // itree = 1265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.894967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434749,-99) , 
0, 1.11302, 1, 0, 0.703013,-99) , 
3, 1.35947, 0, 0, 0.778029,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328013,-99) , 
0, -1.19434, 1, 0, 0.393172,-99) , 
NN(
0, 
0, 
-1, 0.0526353, 1, -1, 0.122584,-99) , 
3, -1.0442, 0, 0, 0.30575,-99) , 
3, 0.207882, 0, 0, 0.52785,-99)    );
  // itree = 1266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90389, 1, 1, 0.88856,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442848,-99) , 
0, 1.15727, 1, 0, 0.744038,-99) , 
3, 1.29551, 0, 0, 0.808126,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326268,-99) , 
0, -1.46346, 1, 0, 0.399494,-99) , 
NN(
0, 
0, 
-1, -2.86122, 1, -1, 0.0776708,-99) , 
3, -1.06437, 0, 0, 0.290984,-99) , 
3, 0.28719, 0, 0, 0.520435,-99)    );
  // itree = 1267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.969685,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45528,-99) , 
3, 1.33152, 0, 0, 0.729081,-99) , 
0, 0.956191, 1, 0, 0.790533,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219983,-99) , 
0, 0.205075, 1, 0, 0.431623,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.136741,-99) , 
3, -1.20789, 0, 0, 0.35808,-99) , 
3, 0.575013, 0, 0, 0.514734,-99)    );
  // itree = 1268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.846825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31312,-99) , 
0, 0.829465, 1, 0, 0.643184,-99) , 
3, 1.02272, 0, 0, 0.749983,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296474,-99) , 
1, -0.654311, 1, 0, 0.373558,-99) , 
NN(
0, 
0, 
-1, -1.90701, 0, -1, 0.134439,-99) , 
3, -0.829529, 0, 0, 0.276764,-99) , 
3, 0.228725, 0, 0, 0.500889,-99)    );
  // itree = 1269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.01027, 1, 1, 0.847381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44354,-99) , 
0, 0.486742, 1, 0, 0.658564,-99) , 
3, 0.84679, 0, 0, 0.74968,-99) , 
NN(
0, 
0, 
-1, -0.8155, 0, -1, 0.199563,-99) , 
3, -0.304384, 0, 0, 0.530809,-99)    );
  // itree = 1270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4113, 0, 1, 0.816422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352066,-99) , 
2, 0.276377, 1, 0, 0.528617,-99) , 
3, 0.929717, 0, 0, 0.648896,-99) , 
NN(
0, 
0, 
-1, -0.916066, 0, -1, 0.156471,-99) , 
3, -0.420978, 0, 0, 0.481416,-99)    );
  // itree = 1271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.95584, 0, 1, 0.868669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419836,-99) , 
0, 0.540099, 1, 0, 0.626525,-99) , 
3, 1.1447, 0, 0, 0.717156,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192636,-99) , 
0, -1.28941, 1, 0, 0.340584,-99) , 
NN(
0, 
0, 
-1, -0.259045, 1, -1, 0.057946,-99) , 
3, -1.20728, 0, 0, 0.231588,-99) , 
3, -0.210183, 0, 0, 0.506576,-99)    );
  // itree = 1272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73223, 1, 1, 0.868056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378836,-99) , 
0, 0.759821, 1, 0, 0.661863,-99) , 
3, 1.26767, 0, 0, 0.740032,-99) , 
NN(
0, 
0, 
-1, -0.76155, 0, -1, 0.216867,-99) , 
3, 0.0509667, 0, 0, 0.474041,-99)    );
  // itree = 1273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0227584, 0, 1, 0.769105,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31799,-99) , 
0, -0.991976, 1, 0, 0.413858,-99) , 
NN(
0, 
0, 
-1, -1.28316, 0, -1, 0.128932,-99) , 
3, -0.595477, 0, 0, 0.242904,-99) , 
3, 0.202693, 0, 0, 0.485738,-99)    );
  // itree = 1274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25225, 1, 1, 0.84546,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285166,-99) , 
0, 0.887495, 1, 0, 0.580742,-99) , 
3, 1.07541, 0, 0, 0.685656,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.241221,-99) , 
3, -0.304384, 0, 0, 0.530035,-99)    );
  // itree = 1275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.049934, 1, 1, 0.868355,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378183,-99) , 
3, 0.983866, 0, 0, 0.694518,-99) , 
0, 0.709428, 1, 0, 0.754219,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258991,-99) , 
0, -1.20938, 1, 0, 0.352342,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0757538,-99) , 
3, -1.16083, 0, 0, 0.254933,-99) , 
3, 0.178444, 0, 0, 0.48504,-99)    );
  // itree = 1276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.784128,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413177,-99) , 
0, -1.21605, 1, 0, 0.505277,-99) , 
3, 0.226422, 0, 0, 0.686554,-99) , 
NN(
0, 
0, 
-1, -2.29656, 1, -1, 0.163138,-99) , 
3, -0.786928, 0, 0, 0.554389,-99)    );
  // itree = 1277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.853939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27526,-99) , 
0, 1.20619, 1, 0, 0.600916,-99) , 
3, 1.33028, 0, 0, 0.67798,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164309,-99) , 
0, -1.17488, 1, 0, 0.310831,-99) , 
NN(
0, 
0, 
-1, -0.30776, 1, -1, 0.116417,-99) , 
3, -1.07684, 0, 0, 0.219281,-99) , 
3, -0.202496, 0, 0, 0.486021,-99)    );
  // itree = 1278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.824899,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303812,-99) , 
0, 0.245926, 1, 0, 0.594819,-99) , 
3, 0.700099, 0, 0, 0.725326,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.232417,-99) , 
3, -0.202496, 0, 0, 0.511086,-99)    );
  // itree = 1279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52487, 1, 1, 0.878963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297616,-99) , 
0, 1.11365, 1, 0, 0.640822,-99) , 
3, 1.19879, 0, 0, 0.746757,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301648,-99) , 
0, -0.773268, 1, 0, 0.471263,-99) , 
NN(
0, 
0, 
-1, -0.957819, 0, -1, 0.192937,-99) , 
3, -0.392596, 0, 0, 0.299128,-99) , 
3, 0.234307, 0, 0, 0.520002,-99)    );
  // itree = 1280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1598, 1, 1, 0.857427,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407527,-99) , 
0, 0.738333, 1, 0, 0.621489,-99) , 
3, 1.10862, 0, 0, 0.710717,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.195509,-99) , 
3, -0.202496, 0, 0, 0.482501,-99)    );
  // itree = 1281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.872095,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275048,-99) , 
0, 0.923985, 1, 0, 0.597816,-99) , 
3, 1.10245, 0, 0, 0.702389,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145059,-99) , 
0, -1.37863, 1, 0, 0.287458,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.105349,-99) , 
3, -1.08857, 0, 0, 0.208258,-99) , 
3, -0.207894, 0, 0, 0.509338,-99)    );
  // itree = 1282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.846075,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362515,-99) , 
0, 0.491924, 1, 0, 0.577138,-99) , 
3, 1.07541, 0, 0, 0.671736,-99) , 
NN(
0, 
0, 
-1, -1.07057, 0, -1, 0.20418,-99) , 
3, -0.304384, 0, 0, 0.505192,-99)    );
  // itree = 1283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.878995,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411307,-99) , 
0, 0.80635, 1, 0, 0.614176,-99) , 
3, 1.3205, 0, 0, 0.70009,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.193745,-99) , 
3, -0.207894, 0, 0, 0.484197,-99)    );
  // itree = 1284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.860108,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377689,-99) , 
0, 0.733197, 1, 0, 0.607879,-99) , 
3, 1.12051, 0, 0, 0.705893,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.242143,-99) , 
3, -0.202496, 0, 0, 0.535706,-99)    );
  // itree = 1285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5287, 1, 1, 0.864076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356267,-99) , 
0, 0.470957, 1, 0, 0.62318,-99) , 
3, 0.985321, 0, 0, 0.731235,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.228155,-99) , 
3, -0.123397, 0, 0, 0.509059,-99)    );
  // itree = 1286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.848547,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312584,-99) , 
0, 1.15092, 1, 0, 0.631471,-99) , 
3, 1.19897, 0, 0, 0.723045,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227911,-99) , 
0, -1.15081, 1, 0, 0.341092,-99) , 
NN(
0, 
0, 
-1, -1.49996, 0, -1, 0.126792,-99) , 
3, -0.856661, 0, 0, 0.24393,-99) , 
3, 0.202693, 0, 0, 0.467165,-99)    );
  // itree = 1287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.883253, 1, 1, 0.844828,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422467,-99) , 
0, 0.0889289, 1, 0, 0.603417,-99) , 
3, 0.957669, 0, 0, 0.7166,-99) , 
NN(
0, 
0, 
-1, -0.654099, 0, -1, 0.19635,-99) , 
3, -0.160313, 0, 0, 0.506545,-99)    );
  // itree = 1288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.635047, 1, 1, 0.86606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366945,-99) , 
3, 1.22777, 0, 0, 0.675127,-99) , 
0, 1.10708, 1, 0, 0.756843,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297402,-99) , 
0, -0.988002, 1, 0, 0.43322,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.0846124,-99) , 
3, -1.02981, 0, 0, 0.293631,-99) , 
3, 0.276895, 0, 0, 0.503909,-99)    );
  // itree = 1289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30419, 0, 1, 0.800618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304013,-99) , 
0, -0.0316589, 1, 0, 0.558086,-99) , 
3, 0.543354, 0, 0, 0.721875,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192041,-99) , 
0, -1.25617, 1, 0, 0.321533,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0913787,-99) , 
3, -1.01154, 0, 0, 0.220238,-99) , 
3, -0.123397, 0, 0, 0.505762,-99)    );
  // itree = 1290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80924, 1, 1, 0.870761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381165,-99) , 
0, 0.887495, 1, 0, 0.599223,-99) , 
3, 1.14517, 0, 0, 0.697228,-99) , 
NN(
0, 
0, 
-1, -0.964563, 0, -1, 0.252146,-99) , 
3, -0.210183, 0, 0, 0.531758,-99)    );
  // itree = 1291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.788713, 0, 1, 0.88398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329307,-99) , 
3, 1.01627, 0, 0, 0.671475,-99) , 
0, 0.696722, 1, 0, 0.744693,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281477,-99) , 
0, -0.991976, 1, 0, 0.411811,-99) , 
NN(
0, 
0, 
-1, -1.86037, 1, -1, 0.1689,-99) , 
3, -0.651936, 0, 0, 0.280864,-99) , 
3, 0.17816, 0, 0, 0.503387,-99)    );
  // itree = 1292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.843823,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388615,-99) , 
0, 0.158049, 1, 0, 0.59101,-99) , 
3, 0.983057, 0, 0, 0.68936,-99) , 
NN(
0, 
0, 
-1, -0.876581, 0, -1, 0.173785,-99) , 
3, -0.376892, 0, 0, 0.509093,-99)    );
  // itree = 1293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39222, 1, 1, 0.883302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472135,-99) , 
0, 0.562757, 1, 0, 0.645433,-99) , 
3, 1.21436, 0, 0, 0.7439,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24164,-99) , 
0, -0.781662, 1, 0, 0.379003,-99) , 
NN(
0, 
0, 
-1, -1.60567, 1, -1, 0.0982904,-99) , 
3, -1.2031, 0, 0, 0.286592,-99) , 
3, 0.17816, 0, 0, 0.497431,-99)    );
  // itree = 1294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0200223, 1, 1, 0.856332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305639,-99) , 
0, 0.980654, 1, 0, 0.576175,-99) , 
3, 1.05197, 0, 0, 0.683884,-99) , 
NN(
0, 
0, 
-1, -1.11714, 0, -1, 0.196084,-99) , 
3, -0.25059, 0, 0, 0.488152,-99)    );
  // itree = 1295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51859, 1, 1, 0.789566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35704,-99) , 
0, -0.102554, 1, 0, 0.5698,-99) , 
3, 0.543354, 0, 0, 0.716759,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229811,-99) , 
0, -1.21605, 1, 0, 0.368605,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.110775,-99) , 
3, -1.01154, 0, 0, 0.247055,-99) , 
3, -0.123397, 0, 0, 0.522278,-99)    );
  // itree = 1296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.858425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430674,-99) , 
0, 0.210411, 1, 0, 0.586931,-99) , 
3, 1.20885, 0, 0, 0.682452,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192695,-99) , 
0, -0.99593, 1, 0, 0.327876,-99) , 
NN(
0, 
0, 
-1, -2.61685, 1, -1, 0.10538,-99) , 
3, -1.00886, 0, 0, 0.218056,-99) , 
3, -0.123397, 0, 0, 0.487142,-99)    );
  // itree = 1297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24656, 1, 1, 0.879679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301988,-99) , 
0, 0.852865, 1, 0, 0.636558,-99) , 
3, 1.1129, 0, 0, 0.762482,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294815,-99) , 
1, -0.438288, 1, 0, 0.390722,-99) , 
NN(
0, 
0, 
-1, -2.27885, 1, -1, 0.103937,-99) , 
3, -1.03194, 0, 0, 0.290521,-99) , 
3, 0.307824, 0, 0, 0.492951,-99)    );
  // itree = 1298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.844981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437809,-99) , 
0, 0.240286, 1, 0, 0.600731,-99) , 
3, 1.20395, 0, 0, 0.685881,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.21845,-99) , 
3, -0.123397, 0, 0, 0.491619,-99)    );
  // itree = 1299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56224, 1, 1, 0.881949,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321204,-99) , 
0, 1.01065, 1, 0, 0.589509,-99) , 
3, 1.33203, 0, 0, 0.666951,-99) , 
NN(
0, 
0, 
-1, -1.45212, 0, -1, 0.14453,-99) , 
3, -0.639447, 0, 0, 0.506953,-99)    );
  // itree = 1300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.4842, 1, 1, 0.901572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464637,-99) , 
0, 1.24677, 1, 0, 0.675948,-99) , 
3, 1.62742, 0, 0, 0.730717,-99) , 
NN(
0, 
0, 
-1, -0.376357, 0, -1, 0.254506,-99) , 
3, 0.17816, 0, 0, 0.479584,-99)    );
  // itree = 1301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.65883, 0, 1, 0.832454,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278721,-99) , 
0, 1.16288, 1, 0, 0.579403,-99) , 
3, 1.18038, 0, 0, 0.670744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159511,-99) , 
0, -1.35582, 1, 0, 0.276716,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.0974407,-99) , 
3, -1.14385, 0, 0, 0.201806,-99) , 
3, -0.160313, 0, 0, 0.461683,-99)    );
  // itree = 1302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.850764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294741,-99) , 
0, 0.848875, 1, 0, 0.590137,-99) , 
3, 1.07541, 0, 0, 0.687535,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.190048,-99) , 
3, -0.304384, 0, 0, 0.491874,-99)    );
  // itree = 1303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19067, 1, 1, 0.864116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468112,-99) , 
0, -0.0640016, 1, 0, 0.587637,-99) , 
3, 1.20395, 0, 0, 0.675949,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21943,-99) , 
0, -0.997344, 1, 0, 0.335081,-99) , 
NN(
0, 
0, 
-1, -0.213943, 1, -1, 0.118594,-99) , 
3, -1.00886, 0, 0, 0.230698,-99) , 
3, -0.123397, 0, 0, 0.490443,-99)    );
  // itree = 1304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.89092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334857,-99) , 
0, 0.811659, 1, 0, 0.709167,-99) , 
3, 0.985321, 0, 0, 0.798205,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.232299,-99) , 
3, -0.123397, 0, 0, 0.548783,-99)    );
  // itree = 1305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58392, 1, 1, 0.853393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467816,-99) , 
0, 0.645232, 1, 0, 0.693818,-99) , 
3, 1.08443, 0, 0, 0.775217,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354335,-99) , 
0, -0.897781, 1, 0, 0.469777,-99) , 
NN(
0, 
0, 
-1, -1.65122, 1, -1, 0.17627,-99) , 
3, -0.64095, 0, 0, 0.314399,-99) , 
3, 0.306962, 0, 0, 0.507647,-99)    );
  // itree = 1306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.988815, 1, 1, 0.82454,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388197,-99) , 
2, 0.34309, 1, 0, 0.562698,-99) , 
3, 0.800667, 0, 0, 0.725529,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29331,-99) , 
0, -0.551076, 1, 0, 0.455222,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.19123,-99) , 
3, -0.376357, 0, 0, 0.279958,-99) , 
3, 0.17816, 0, 0, 0.495052,-99)    );
  // itree = 1307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.875635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308252,-99) , 
0, 1.41077, 1, 0, 0.682492,-99) , 
3, 1.36042, 0, 0, 0.753802,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280513,-99) , 
0, -0.628391, 1, 0, 0.390159,-99) , 
NN(
0, 
0, 
-1, -1.7862, 1, -1, 0.152059,-99) , 
3, -0.603744, 0, 0, 0.252657,-99) , 
3, 0.180631, 0, 0, 0.494678,-99)    );
  // itree = 1308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.08045, 0, 1, 0.801133,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303264,-99) , 
0, -0.831231, 1, 0, 0.425068,-99) , 
NN(
0, 
0, 
-1, -1.57696, 1, -1, 0.129228,-99) , 
3, -0.548378, 0, 0, 0.24481,-99) , 
3, 0.262941, 0, 0, 0.4949,-99)    );
  // itree = 1309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.255486, 1, 1, 0.941812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491086,-99) , 
3, 1.35705, 0, 0, 0.700756,-99) , 
0, 0.709428, 1, 0, 0.771448,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287264,-99) , 
0, -0.390046, 1, 0, 0.491276,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.179058,-99) , 
3, -0.497209, 0, 0, 0.307271,-99) , 
3, 0.307824, 0, 0, 0.515663,-99)    );
  // itree = 1310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.871708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297246,-99) , 
0, 1.10293, 1, 0, 0.622234,-99) , 
3, 1.07875, 0, 0, 0.756271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600072,-99) , 
NN(
0, 
0, 
-1, -1.51891, 0, -1, 0.217266,-99) , 
3, -0.0146681, 0, 0, 0.285042,-99) , 
3, 0.301115, 0, 0, 0.474941,-99)    );
  // itree = 1311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.956191, 1, 1, 0.810856,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381214,-99) , 
0, 0.260859, 1, 0, 0.58672,-99) , 
3, 0.785844, 0, 0, 0.723777,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272111,-99) , 
0, -0.701151, 1, 0, 0.396227,-99) , 
NN(
0, 
0, 
-1, -0.536791, 1, -1, 0.216584,-99) , 
3, -0.351888, 0, 0, 0.284218,-99) , 
3, 0.183842, 0, 0, 0.497637,-99)    );
  // itree = 1312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.886637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386536,-99) , 
0, 0.887419, 1, 0, 0.647532,-99) , 
3, 1.26793, 0, 0, 0.739511,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298284,-99) , 
0, -1.20938, 1, 0, 0.409865,-99) , 
NN(
0, 
0, 
-1, -2.86122, 1, -1, 0.0770618,-99) , 
3, -1.03104, 0, 0, 0.266175,-99) , 
3, 0.0509667, 0, 0, 0.517239,-99)    );
  // itree = 1313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.46194, 1, 1, 0.864827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314835,-99) , 
0, 1.0116, 1, 0, 0.63493,-99) , 
3, 1.33028, 0, 0, 0.703979,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.228827,-99) , 
3, -0.202496, 0, 0, 0.49963,-99)    );
  // itree = 1314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.880001,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396596,-99) , 
0, 0.429002, 1, 0, 0.60402,-99) , 
3, 1.12022, 0, 0, 0.703048,-99) , 
NN(
0, 
0, 
-1, 0.490898, 1, -1, 0.211533,-99) , 
3, -0.207894, 0, 0, 0.516366,-99)    );
  // itree = 1315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.27767, 0, 1, 0.749686,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300865,-99) , 
0, -0.849324, 1, 0, 0.406537,-99) , 
NN(
0, 
0, 
-1, -0.0674616, 1, -1, 0.134353,-99) , 
3, -0.957285, 0, 0, 0.285591,-99) , 
3, 0.306962, 0, 0, 0.496189,-99)    );
  // itree = 1316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.29551, 0, 1, 0.786469,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574301,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187024,-99) , 
0, -0.260196, 1, 0, 0.406988,-99) , 
NN(
0, 
0, 
-1, -1.79283, 1, -1, 0.153909,-99) , 
3, -0.52447, 0, 0, 0.267655,-99) , 
3, 0.28719, 0, 0, 0.488093,-99)    );
  // itree = 1317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.78335,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243174,-99) , 
0, -0.312245, 1, 0, 0.422009,-99) , 
NN(
0, 
0, 
-1, -1.70164, 0, -1, 0.13064,-99) , 
3, -0.820157, 0, 0, 0.302526,-99) , 
3, 0.262941, 0, 0, 0.529629,-99)    );
  // itree = 1318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.71411, 1, 1, 0.88829,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237887,-99) , 
0, 1.52189, 1, 0, 0.658653,-99) , 
3, 1.3922, 0, 0, 0.740338,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386869,-99) , 
2, -0.0447422, 1, 0, 0.491795,-99) , 
NN(
0, 
0, 
-1, -0.979519, 0, -1, 0.221751,-99) , 
3, -0.391477, 0, 0, 0.309536,-99) , 
3, 0.238103, 0, 0, 0.516637,-99)    );
  // itree = 1319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.85479, 0, 1, 0.89503,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361285,-99) , 
3, 1.2268, 0, 0, 0.681129,-99) , 
0, 1.17756, 1, 0, 0.765246,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212616,-99) , 
0, -0.153185, 1, 0, 0.420865,-99) , 
NN(
0, 
0, 
-1, -0.610343, 1, -1, 0.176111,-99) , 
3, -0.568264, 0, 0, 0.301809,-99) , 
3, 0.392653, 0, 0, 0.487158,-99)    );
  // itree = 1320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.207966, 0, 1, 0.931444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470372,-99) , 
3, 0.774024, 0, 0, 0.655434,-99) , 
0, -0.135384, 1, 0, 0.711034,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.210189,-99) , 
3, -0.123397, 0, 0, 0.499427,-99)    );
  // itree = 1321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.173347, 0, 1, 0.718423,-99) , 
NN(
0, 
0, 
-1, -1.03076, 0, -1, 0.179516,-99) , 
3, -0.287638, 0, 0, 0.508297,-99)    );
  // itree = 1322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.00547, 0, 1, 0.841822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493835,-99) , 
0, -0.0215873, 1, 0, 0.600073,-99) , 
3, 1.21925, 0, 0, 0.68575,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.186084,-99) , 
3, -0.123397, 0, 0, 0.472949,-99)    );
  // itree = 1323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43128, 0, 1, 0.832392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297344,-99) , 
0, 0.478161, 1, 0, 0.563623,-99) , 
3, 0.76023, 0, 0, 0.701757,-99) , 
NN(
0, 
0, 
-1, -1.0683, 0, -1, 0.193776,-99) , 
3, -0.340957, 0, 0, 0.521779,-99)    );
  // itree = 1324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.777489, 1, 1, 0.844055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.909619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33165,-99) , 
0, 0.409864, 1, 0, 0.637425,-99) , 
3, 0.724073, 0, 0, 0.765501,-99) , 
NN(
0, 
0, 
-1, -0.447144, 0, -1, 0.245324,-99) , 
3, 0.0990605, 0, 0, 0.510501,-99)    );
  // itree = 1325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.981295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49043,-99) , 
3, 1.11054, 0, 0, 0.738938,-99) , 
0, 0.237393, 1, 0, 0.781481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342893,-99) , 
0, -1.18666, 1, 0, 0.455087,-99) , 
NN(
0, 
0, 
-1, -1.01046, 0, -1, 0.144114,-99) , 
3, -0.527848, 0, 0, 0.284433,-99) , 
3, 0.28719, 0, 0, 0.499902,-99)    );
  // itree = 1326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29251, 0, 1, 0.818393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306313,-99) , 
0, 0.0490839, 1, 0, 0.529763,-99) , 
3, 0.527818, 0, 0, 0.702989,-99) , 
NN(
0, 
0, 
-1, -0.649866, 0, -1, 0.207917,-99) , 
3, -0.140969, 0, 0, 0.49273,-99)    );
  // itree = 1327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.889201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336145,-99) , 
0, 0.807964, 1, 0, 0.644693,-99) , 
3, 1.21436, 0, 0, 0.758939,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214018,-99) , 
0, -0.85877, 1, 0, 0.378691,-99) , 
NN(
0, 
0, 
-1, -2.3633, 1, -1, 0.109769,-99) , 
3, -0.927516, 0, 0, 0.250437,-99) , 
3, 0.17816, 0, 0, 0.471036,-99)    );
  // itree = 1328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.70427, 0, 1, 0.837995,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333895,-99) , 
0, 0.887495, 1, 0, 0.609469,-99) , 
3, 1.07098, 0, 0, 0.702345,-99) , 
NN(
0, 
0, 
-1, -0.985546, 0, -1, 0.242142,-99) , 
3, -0.255748, 0, 0, 0.525537,-99)    );
  // itree = 1329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.869046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406817,-99) , 
0, 0.893448, 1, 0, 0.659513,-99) , 
3, 1.07875, 0, 0, 0.769898,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272785,-99) , 
1, -0.384038, 1, 0, 0.344773,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.116008,-99) , 
3, -0.959934, 0, 0, 0.254215,-99) , 
3, 0.301115, 0, 0, 0.495259,-99)    );
  // itree = 1330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57139, 0, 1, 0.743086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325304,-99) , 
0, -0.985532, 1, 0, 0.472315,-99) , 
3, 0.0947715, 0, 0, 0.660264,-99) , 
NN(
0, 
0, 
-1, -1.10873, 0, -1, 0.149839,-99) , 
3, -0.65367, 0, 0, 0.518602,-99)    );
  // itree = 1331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.870364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325473,-99) , 
0, 1.11302, 1, 0, 0.639096,-99) , 
3, 1.21586, 0, 0, 0.732797,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288254,-99) , 
0, -1.21855, 1, 0, 0.350025,-99) , 
NN(
0, 
0, 
-1, -1.41251, 1, -1, 0.0652914,-99) , 
3, -1.2031, 0, 0, 0.255572,-99) , 
3, 0.17816, 0, 0, 0.47335,-99)    );
  // itree = 1332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.210848, 0, 1, 0.713723,-99) , 
NN(
0, 
0, 
-1, -0.968012, 0, -1, 0.224291,-99) , 
3, -0.232821, 0, 0, 0.522039,-99)    );
  // itree = 1333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.74112, 1, 1, 0.828166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274128,-99) , 
0, 0.84413, 1, 0, 0.605064,-99) , 
3, 1.00736, 0, 0, 0.712849,-99) , 
NN(
0, 
0, 
-1, -1.48514, 0, -1, 0.277084,-99) , 
3, 0.17816, 0, 0, 0.488042,-99)    );
  // itree = 1334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51859, 1, 1, 0.844239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357141,-99) , 
0, 0.245926, 1, 0, 0.585161,-99) , 
3, 0.66689, 0, 0, 0.732173,-99) , 
NN(
0, 
0, 
-1, -0.793484, 0, -1, 0.202283,-99) , 
3, -0.207894, 0, 0, 0.508905,-99)    );
  // itree = 1335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.777489, 1, 1, 0.805587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455682,-99) , 
3, 0.298615, 0, 0, 0.750635,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198473,-99) , 
0, -0.868569, 1, 0, 0.34624,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.109225,-99) , 
3, -1.00401, 0, 0, 0.237102,-99) , 
3, 0.093663, 0, 0, 0.50948,-99)    );
  // itree = 1336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.52262, 0, 1, 0.862237,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459146,-99) , 
3, 1.36351, 0, 0, 0.682795,-99) , 
0, 1.07877, 1, 0, 0.762752,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38179,-99) , 
0, -0.802449, 1, 0, 0.51382,-99) , 
NN(
0, 
0, 
-1, -1.7862, 1, -1, 0.197637,-99) , 
3, -0.548764, 0, 0, 0.331199,-99) , 
3, 0.240737, 0, 0, 0.529943,-99)    );
  // itree = 1337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.782139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252526,-99) , 
0, 0.429347, 1, 0, 0.55921,-99) , 
3, 0.767226, 0, 0, 0.677027,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.240143,-99) , 
3, -0.123397, 0, 0, 0.509272,-99)    );
  // itree = 1338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43703, 1, 1, 0.859815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770966,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329674,-99) , 
0, 1.125, 1, 0, 0.635236,-99) , 
3, 1.27233, 0, 0, 0.724164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334426,-99) , 
0, -0.773268, 1, 0, 0.436079,-99) , 
NN(
0, 
0, 
-1, -1.6656, 1, -1, 0.201626,-99) , 
3, -0.480551, 0, 0, 0.293985,-99) , 
3, 0.137424, 0, 0, 0.507243,-99)    );
  // itree = 1339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.273124, 1, 1, 0.882759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346662,-99) , 
3, 0.657351, 0, 0, 0.669509,-99) , 
0, 0.247385, 1, 0, 0.725105,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205419,-99) , 
0, -1.35582, 1, 0, 0.298251,-99) , 
NN(
0, 
0, 
-1, -2.4918, 1, -1, 0.138166,-99) , 
3, -1.01189, 0, 0, 0.233988,-99) , 
3, -0.0502295, 0, 0, 0.49119,-99)    );
  // itree = 1340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.305972, 0, 1, 0.721968,-99) , 
NN(
0, 
0, 
-1, -1.12925, 0, -1, 0.251518,-99) , 
3, -0.140969, 0, 0, 0.516539,-99)    );
  // itree = 1341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.847257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329553,-99) , 
0, 0.929805, 1, 0, 0.602215,-99) , 
3, 1.07541, 0, 0, 0.696848,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.208614,-99) , 
3, -0.304384, 0, 0, 0.508142,-99)    );
  // itree = 1342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43425, 0, 1, 0.849772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465932,-99) , 
0, -0.0358254, 1, 0, 0.582524,-99) , 
3, 0.745167, 0, 0, 0.757617,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30677,-99) , 
0, -1.44513, 1, 0, 0.368416,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0749525,-99) , 
3, -1.18731, 0, 0, 0.264755,-99) , 
3, 0.135748, 0, 0, 0.50928,-99)    );
  // itree = 1343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.217941, 1, 1, 0.903437,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46171,-99) , 
3, 1.2782, 0, 0, 0.695428,-99) , 
0, 0.778492, 1, 0, 0.759934,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341903,-99) , 
0, -1.00706, 1, 0, 0.462844,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.134237,-99) , 
3, -0.957285, 0, 0, 0.326604,-99) , 
3, 0.306962, 0, 0, 0.51917,-99)    );
  // itree = 1344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45879, 1, 1, 0.813837,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347122,-99) , 
0, 0.0761946, 1, 0, 0.636044,-99) , 
3, 0.539295, 0, 0, 0.751308,-99) , 
NN(
0, 
0, 
-1, -0.895353, 0, -1, 0.254306,-99) , 
3, -0.140969, 0, 0, 0.53893,-99)    );
  // itree = 1345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.877296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4137,-99) , 
0, 0.202902, 1, 0, 0.583091,-99) , 
3, 1.0924, 0, 0, 0.693381,-99) , 
NN(
0, 
0, 
-1, -0.978667, 0, -1, 0.202183,-99) , 
3, -0.232821, 0, 0, 0.497337,-99)    );
  // itree = 1346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56776, 1, 1, 0.871026,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423119,-99) , 
0, 0.498151, 1, 0, 0.656851,-99) , 
3, 1.12392, 0, 0, 0.747343,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272986,-99) , 
0, -0.868842, 1, 0, 0.41655,-99) , 
NN(
0, 
0, 
-1, -1.97172, 1, -1, 0.134605,-99) , 
3, -0.720436, 0, 0, 0.265478,-99) , 
3, 0.0990605, 0, 0, 0.500321,-99)    );
  // itree = 1347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.863891,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328738,-99) , 
0, 1.28286, 1, 0, 0.654205,-99) , 
3, 1.33185, 0, 0, 0.727081,-99) , 
NN(
0, 
0, 
-1, -0.457618, 0, -1, 0.253125,-99) , 
3, 0.0990605, 0, 0, 0.497924,-99)    );
  // itree = 1348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.99802, 0, 1, 0.829118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344466,-99) , 
0, 0.459356, 1, 0, 0.60305,-99) , 
3, 0.98281, 0, 0, 0.699165,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.186672,-99) , 
3, -0.123397, 0, 0, 0.477852,-99)    );
  // itree = 1349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.868395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242497,-99) , 
0, 0.96273, 1, 0, 0.593844,-99) , 
3, 1.21404, 0, 0, 0.702113,-99) , 
NN(
0, 
0, 
-1, -0.109402, 0, -1, 0.272248,-99) , 
3, 0.17816, 0, 0, 0.474525,-99)    );
  // itree = 1350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.890653,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412843,-99) , 
0, 0.920728, 1, 0, 0.628091,-99) , 
3, 1.31726, 0, 0, 0.710437,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291964,-99) , 
0, -1.44588, 1, 0, 0.356406,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.0641614,-99) , 
3, -1.26563, 0, 0, 0.271817,-99) , 
3, 0.093663, 0, 0, 0.496019,-99)    );
  // itree = 1351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4121, 1, 1, 0.862821,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250921,-99) , 
0, 1.20619, 1, 0, 0.643322,-99) , 
3, 1.3205, 0, 0, 0.710956,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.214703,-99) , 
3, -0.207894, 0, 0, 0.499194,-99)    );
  // itree = 1352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.925629, 1, 1, 0.801064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379935,-99) , 
0, -0.1837, 1, 0, 0.528114,-99) , 
3, 0.860286, 0, 0, 0.640292,-99) , 
NN(
0, 
0, 
-1, -1.27382, 0, -1, 0.195241,-99) , 
3, -0.607171, 0, 0, 0.509685,-99)    );
  // itree = 1353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21129, 1, 1, 0.838609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324382,-99) , 
0, 0.459356, 1, 0, 0.560372,-99) , 
3, 0.985321, 0, 0, 0.684458,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212235,-99) , 
0, -1.23094, 1, 0, 0.341403,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0959576,-99) , 
3, -1.00886, 0, 0, 0.222843,-99) , 
3, -0.123397, 0, 0, 0.47788,-99)    );
  // itree = 1354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0858844, 1, 1, 0.746618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266632,-99) , 
0, -0.808232, 1, 0, 0.407934,-99) , 
3, 0.227697, 0, 0, 0.621326,-99) , 
NN(
0, 
0, 
-1, -1.48218, 0, -1, 0.108489,-99) , 
3, -0.786928, 0, 0, 0.480013,-99)    );
  // itree = 1355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.250617, 0, 1, 0.72902,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.226048,-99) , 
3, -0.202496, 0, 0, 0.509749,-99)    );
  // itree = 1356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.857126,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30658,-99) , 
0, 1.0116, 1, 0, 0.62828,-99) , 
3, 1.2097, 0, 0, 0.700905,-99) , 
NN(
0, 
0, 
-1, -0.386774, 1, -1, 0.209063,-99) , 
3, -0.376892, 0, 0, 0.539118,-99)    );
  // itree = 1357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80594, 0, 1, 0.851703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318565,-99) , 
0, 0.852865, 1, 0, 0.659648,-99) , 
3, 0.989907, 0, 0, 0.760127,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283305,-99) , 
0, -0.789177, 1, 0, 0.440406,-99) , 
NN(
0, 
0, 
-1, -1.76874, 0, -1, 0.136399,-99) , 
3, -0.616659, 0, 0, 0.276382,-99) , 
3, 0.183842, 0, 0, 0.501923,-99)    );
  // itree = 1358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.826275,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35884,-99) , 
0, 0.733197, 1, 0, 0.609243,-99) , 
3, 1.12051, 0, 0, 0.691557,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.205439,-99) , 
3, -0.202496, 0, 0, 0.477816,-99)    );
  // itree = 1359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.945202,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483823,-99) , 
3, 1.26659, 0, 0, 0.728304,-99) , 
0, 0.768458, 1, 0, 0.785439,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264708,-99) , 
0, 0.0533187, 1, 0, 0.490219,-99) , 
NN(
0, 
0, 
-1, -0.546181, 1, -1, 0.201447,-99) , 
3, -0.356825, 0, 0, 0.314159,-99) , 
3, 0.522911, 0, 0, 0.485483,-99)    );
  // itree = 1360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21199, 0, 1, 0.831719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287299,-99) , 
0, 0.245926, 1, 0, 0.56437,-99) , 
3, 0.672086, 0, 0, 0.709741,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568214,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18738,-99) , 
0, -1.36487, 1, 0, 0.321955,-99) , 
NN(
0, 
0, 
-1, -0.213943, 1, -1, 0.0704402,-99) , 
3, -1.36791, 0, 0, 0.223905,-99) , 
3, -0.202496, 0, 0, 0.524028,-99)    );
  // itree = 1361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.69117, 0, 1, 0.792645,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215986,-99) , 
0, -0.215367, 1, 0, 0.466582,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.128857,-99) , 
3, -0.959342, 0, 0, 0.3426,-99) , 
3, 0.301115, 0, 0, 0.539475,-99)    );
  // itree = 1362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.868669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280653,-99) , 
0, 0.957246, 1, 0, 0.647214,-99) , 
3, 1.14627, 0, 0, 0.727176,-99) , 
NN(
0, 
0, 
-1, -0.963597, 0, -1, 0.233543,-99) , 
3, -0.210183, 0, 0, 0.529397,-99)    );
  // itree = 1363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.841291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492843,-99) , 
0, 0.189126, 1, 0, 0.627746,-99) , 
3, 1.0105, 0, 0, 0.733072,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323502,-99) , 
0, -1.21855, 1, 0, 0.408344,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0844388,-99) , 
3, -0.927516, 0, 0, 0.268284,-99) , 
3, 0.17816, 0, 0, 0.490766,-99)    );
  // itree = 1364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55542, 0, 1, 0.818051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786044,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445134,-99) , 
0, -0.0750528, 1, 0, 0.597102,-99) , 
3, 0.66689, 0, 0, 0.729331,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.167313,-99) , 
0, -1.30493, 1, 0, 0.298107,-99) , 
NN(
0, 
0, 
-1, 0.0697126, 1, -1, 0.0682201,-99) , 
3, -1.08857, 0, 0, 0.193292,-99) , 
3, -0.207894, 0, 0, 0.518914,-99)    );
  // itree = 1365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.875287,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308436,-99) , 
0, 1.20308, 1, 0, 0.667368,-99) , 
3, 1.31846, 0, 0, 0.741423,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257481,-99) , 
0, -1.44588, 1, 0, 0.357571,-99) , 
NN(
0, 
0, 
-1, -2.86122, 1, -1, 0.115254,-99) , 
3, -1.27153, 0, 0, 0.281183,-99) , 
3, 0.093663, 0, 0, 0.508737,-99)    );
  // itree = 1366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7717, 1, 1, 0.858628,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.939302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401269,-99) , 
0, 0.159327, 1, 0, 0.606755,-99) , 
3, 0.818729, 0, 0, 0.76133,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36328,-99) , 
0, -0.70545, 1, 0, 0.505074,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.185766,-99) , 
3, -0.394308, 0, 0, 0.296615,-99) , 
3, 0.234307, 0, 0, 0.510682,-99)    );
  // itree = 1367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.4842, 1, 1, 0.902691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436628,-99) , 
0, 1.5679, 1, 0, 0.708573,-99) , 
3, 1.68795, 0, 0, 0.760868,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317277,-99) , 
1, -0.279191, 1, 0, 0.441923,-99) , 
NN(
0, 
0, 
-1, -1.03116, 0, -1, 0.138828,-99) , 
3, -0.55622, 0, 0, 0.261047,-99) , 
3, 0.262941, 0, 0, 0.490473,-99)    );
  // itree = 1368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19067, 1, 1, 0.850066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.913986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354017,-99) , 
0, 0.498151, 1, 0, 0.615311,-99) , 
3, 1.04916, 0, 0, 0.72023,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256313,-99) , 
0, -0.814901, 1, 0, 0.464344,-99) , 
NN(
0, 
0, 
-1, -2.09717, 1, -1, 0.163974,-99) , 
3, -0.774483, 0, 0, 0.291116,-99) , 
3, 0.0319938, 0, 0, 0.508824,-99)    );
  // itree = 1369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92608, 0, 1, 0.847276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292815,-99) , 
0, 0.562467, 1, 0, 0.521542,-99) , 
3, 1.03583, 0, 0, 0.642543,-99) , 
NN(
0, 
0, 
-1, -1.49697, 0, -1, 0.171133,-99) , 
3, -0.520348, 0, 0, 0.50233,-99)    );
  // itree = 1370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32521, 0, 1, 0.835999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283508,-99) , 
0, 0.573049, 1, 0, 0.605184,-99) , 
3, 0.985321, 0, 0, 0.715246,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.198835,-99) , 
3, -0.123397, 0, 0, 0.503533,-99)    );
  // itree = 1371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.864925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343003,-99) , 
0, 1.31742, 1, 0, 0.594311,-99) , 
3, 1.20559, 0, 0, 0.685877,-99) , 
NN(
0, 
0, 
-1, -1.38107, 1, -1, 0.191275,-99) , 
3, -0.38184, 0, 0, 0.505723,-99)    );
  // itree = 1372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.806974,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337518,-99) , 
0, -0.126177, 1, 0, 0.568496,-99) , 
3, 0.543354, 0, 0, 0.724857,-99) , 
NN(
0, 
0, 
-1, -0.719025, 0, -1, 0.20468,-99) , 
3, -0.123397, 0, 0, 0.50943,-99)    );
  // itree = 1373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0442775, 1, 1, 0.875715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393661,-99) , 
3, 0.994438, 0, 0, 0.648087,-99) , 
0, 0.525974, 1, 0, 0.725868,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.200211,-99) , 
3, -0.123397, 0, 0, 0.50362,-99)    );
  // itree = 1374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.14816, 1, 1, 0.821244,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352754,-99) , 
0, 0.191795, 1, 0, 0.594887,-99) , 
3, 0.937007, 0, 0, 0.698318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200885,-99) , 
0, -1.35582, 1, 0, 0.342433,-99) , 
NN(
0, 
0, 
-1, 0.032123, 1, -1, 0.0846466,-99) , 
3, -1.18543, 0, 0, 0.225708,-99) , 
3, -0.18324, 0, 0, 0.509979,-99)    );
  // itree = 1375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48336, 1, 1, 0.809382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397077,-99) , 
0, 0.52592, 1, 0, 0.627588,-99) , 
3, 0.779904, 0, 0, 0.73617,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668425,-99) , 
NN(
0, 
0, 
-1, -0.896744, 1, -1, 0.191327,-99) , 
3, -0.0913569, 0, 0, 0.261255,-99) , 
3, 0.178444, 0, 0, 0.488404,-99)    );
  // itree = 1376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74111, 1, 1, 0.877944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.866955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495499,-99) , 
0, 0.767381, 1, 0, 0.679662,-99) , 
3, 1.38531, 0, 0, 0.755172,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248103,-99) , 
0, -0.991976, 1, 0, 0.36291,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.106193,-99) , 
3, -1.14976, 0, 0, 0.266475,-99) , 
3, 0.183842, 0, 0, 0.505746,-99)    );
  // itree = 1377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.842099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424134,-99) , 
0, 0.782483, 1, 0, 0.670834,-99) , 
3, 1.07981, 0, 0, 0.762364,-99) , 
NN(
0, 
0, 
-1, -0.965616, 0, -1, 0.26712,-99) , 
3, 0.301115, 0, 0, 0.47087,-99)    );
  // itree = 1378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96645, 1, 1, 0.883154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427066,-99) , 
0, 0.51501, 1, 0, 0.645232,-99) , 
3, 1.3759, 0, 0, 0.718859,-99) , 
NN(
0, 
0, 
-1, -1.08224, 0, -1, 0.183564,-99) , 
3, -0.132796, 0, 0, 0.481936,-99)    );
  // itree = 1379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43094, 0, 1, 0.781874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499248,-99) , 
3, 0.250256, 0, 0, 0.724126,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.211947,-99) , 
3, -0.202496, 0, 0, 0.499758,-99)    );
  // itree = 1380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.108138, 1, 1, 0.788116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527751,-99) , 
NN(
0, 
0, 
-1, -0.572783, 0, -1, 0.20705,-99) , 
3, -0.066311, 0, 0, 0.257908,-99) , 
3, 0.202693, 0, 0, 0.518802,-99)    );
  // itree = 1381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.882154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374277,-99) , 
0, 0.852865, 1, 0, 0.620436,-99) , 
3, 1.28253, 0, 0, 0.733233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34921,-99) , 
0, -0.773268, 1, 0, 0.452142,-99) , 
NN(
0, 
0, 
-1, -1.49257, 0, -1, 0.158045,-99) , 
3, -0.548378, 0, 0, 0.293419,-99) , 
3, 0.262941, 0, 0, 0.513884,-99)    );
  // itree = 1382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40435, 1, 1, 0.853114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430649,-99) , 
0, 0.820006, 1, 0, 0.662829,-99) , 
3, 1.02994, 0, 0, 0.757709,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268115,-99) , 
0, -0.302235, 1, 0, 0.444319,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.184174,-99) , 
3, -0.378316, 0, 0, 0.282635,-99) , 
3, 0.254861, 0, 0, 0.485329,-99)    );
  // itree = 1383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27925, 1, 1, 0.850664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468527,-99) , 
0, 0.372908, 1, 0, 0.641562,-99) , 
3, 0.994438, 0, 0, 0.733535,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.213453,-99) , 
3, -0.123397, 0, 0, 0.513312,-99)    );
  // itree = 1384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49285, 0, 1, 0.84365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333711,-99) , 
0, 0.670322, 1, 0, 0.591201,-99) , 
3, 0.985321, 0, 0, 0.697514,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.22721,-99) , 
3, -0.123397, 0, 0, 0.495477,-99)    );
  // itree = 1385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74441, 0, 1, 0.819855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332685,-99) , 
0, 0.738333, 1, 0, 0.615161,-99) , 
3, 0.961615, 0, 0, 0.70014,-99) , 
NN(
0, 
0, 
-1, -0.843267, 0, -1, 0.19518,-99) , 
3, -0.357125, 0, 0, 0.526559,-99)    );
  // itree = 1386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.783077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386196,-99) , 
0, -0.661533, 1, 0, 0.497043,-99) , 
3, 0.387506, 0, 0, 0.683086,-99) , 
NN(
0, 
0, 
-1, -0.81518, 0, -1, 0.178284,-99) , 
3, -0.304384, 0, 0, 0.500755,-99)    );
  // itree = 1387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63911, 1, 1, 0.891048,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309147,-99) , 
0, 1.62167, 1, 0, 0.627455,-99) , 
3, 1.53622, 0, 0, 0.691065,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.159692,-99) , 
3, -0.304384, 0, 0, 0.479689,-99)    );
  // itree = 1388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.861783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298662,-99) , 
0, 0.738333, 1, 0, 0.607035,-99) , 
3, 1.07643, 0, 0, 0.705608,-99) , 
NN(
0, 
0, 
-1, -0.300802, 1, -1, 0.195581,-99) , 
3, -0.304384, 0, 0, 0.503808,-99)    );
  // itree = 1389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.254496, 1, 1, 0.758217,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280911,-99) , 
0, -1.2877, 1, 0, 0.360692,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.106355,-99) , 
3, -0.993962, 0, 0, 0.25549,-99) , 
3, 0.093663, 0, 0, 0.521357,-99)    );
  // itree = 1390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.869196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343662,-99) , 
0, 0.801422, 1, 0, 0.664,-99) , 
3, 1.08361, 0, 0, 0.76762,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298534,-99) , 
0, -0.831231, 1, 0, 0.406188,-99) , 
NN(
0, 
0, 
-1, -2.27811, 1, -1, 0.105692,-99) , 
3, -0.959342, 0, 0, 0.297169,-99) , 
3, 0.306962, 0, 0, 0.488135,-99)    );
  // itree = 1391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.51859, 1, 1, 0.818803,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234024,-99) , 
0, 0.0309722, 1, 0, 0.449144,-99) , 
NN(
0, 
0, 
-1, 0.301001, 1, -1, 0.121303,-99) , 
3, -0.765274, 0, 0, 0.30896,-99) , 
3, 0.671928, 0, 0, 0.471551,-99)    );
  // itree = 1392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5287, 1, 1, 0.823718,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398523,-99) , 
0, 0.573049, 1, 0, 0.658355,-99) , 
3, 0.98281, 0, 0, 0.737075,-99) , 
NN(
0, 
0, 
-1, -0.431183, 0, -1, 0.266468,-99) , 
3, -0.123397, 0, 0, 0.540207,-99)    );
  // itree = 1393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.872449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319575,-99) , 
0, 0.900473, 1, 0, 0.581105,-99) , 
3, 1.20559, 0, 0, 0.675236,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.147094,-99) , 
3, -0.38184, 0, 0, 0.49595,-99)    );
  // itree = 1394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.823974,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463809,-99) , 
1, -0.212641, 1, 0, 0.587475,-99) , 
3, 0.978312, 0, 0, 0.677453,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.186179,-99) , 
3, -0.38184, 0, 0, 0.493357,-99)    );
  // itree = 1395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15677, 1, 1, 0.859207,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306992,-99) , 
0, 0.821752, 1, 0, 0.590695,-99) , 
3, 0.985666, 0, 0, 0.733816,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314509,-99) , 
0, -0.773268, 1, 0, 0.431579,-99) , 
NN(
0, 
0, 
-1, -1.53331, 0, -1, 0.145414,-99) , 
3, -0.616659, 0, 0, 0.273742,-99) , 
3, 0.183842, 0, 0, 0.502164,-99)    );
  // itree = 1396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47748, 0, 1, 0.845136,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301535,-99) , 
0, 0.904545, 1, 0, 0.610628,-99) , 
3, 1.01137, 0, 0, 0.734385,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279631,-99) , 
0, -0.602719, 1, 0, 0.468345,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.189745,-99) , 
3, -0.391477, 0, 0, 0.279999,-99) , 
3, 0.238103, 0, 0, 0.477678,-99)    );
  // itree = 1397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0432962, 0, 1, 0.889916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449346,-99) , 
3, 1.22244, 0, 0, 0.697188,-99) , 
0, 0.696722, 1, 0, 0.762822,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328604,-99) , 
0, -0.701151, 1, 0, 0.495081,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.140368,-99) , 
3, -0.376357, 0, 0, 0.256745,-99) , 
3, 0.17816, 0, 0, 0.51158,-99)    );
  // itree = 1398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.252128, 1, 1, 0.686573,-99) , 
NN(
0, 
0, 
-1, -1.17011, 0, -1, 0.190349,-99) , 
3, -0.18324, 0, 0, 0.47738,-99)    );
  // itree = 1399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56785, 1, 1, 0.812992,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202378,-99) , 
0, 0.887495, 1, 0, 0.537458,-99) , 
3, 0.993552, 0, 0, 0.641487,-99) , 
NN(
0, 
0, 
-1, -1.62947, 0, -1, 0.170763,-99) , 
3, -0.376892, 0, 0, 0.49218,-99)    );
  // itree = 1400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.920492, 0, 1, 0.835471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309533,-99) , 
0, -0.14342, 1, 0, 0.547908,-99) , 
3, 0.540529, 0, 0, 0.731701,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.21678,-99) , 
3, -0.123397, 0, 0, 0.514024,-99)    );
  // itree = 1401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55129, 1, 1, 0.823246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33994,-99) , 
0, 0.459356, 1, 0, 0.577133,-99) , 
3, 1.11225, 0, 0, 0.666225,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.226767,-99) , 
3, -0.202496, 0, 0, 0.487983,-99)    );
  // itree = 1402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.882377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446372,-99) , 
0, 0.429002, 1, 0, 0.613055,-99) , 
3, 1.16101, 0, 0, 0.717288,-99) , 
NN(
0, 
0, 
-1, -0.67706, 0, -1, 0.186189,-99) , 
3, -0.18324, 0, 0, 0.484095,-99)    );
  // itree = 1403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42951, 1, 1, 0.81718,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317412,-99) , 
0, 0.304059, 1, 0, 0.604927,-99) , 
3, 0.666353, 0, 0, 0.727413,-99) , 
NN(
0, 
0, 
-1, -0.802175, 0, -1, 0.202643,-99) , 
3, -0.207894, 0, 0, 0.508353,-99)    );
  // itree = 1404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0765547, 1, 1, 0.880684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422703,-99) , 
3, 1.12304, 0, 0, 0.687212,-99) , 
0, 0.768458, 1, 0, 0.75386,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310761,-99) , 
0, -1.4072, 1, 0, 0.390617,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.12694,-99) , 
3, -0.998831, 0, 0, 0.290164,-99) , 
3, 0.254861, 0, 0, 0.492414,-99)    );
  // itree = 1405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.857318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316785,-99) , 
0, 1.20619, 1, 0, 0.594039,-99) , 
3, 1.27052, 0, 0, 0.670458,-99) , 
NN(
0, 
0, 
-1, -1.02307, 0, -1, 0.19506,-99) , 
3, -0.287638, 0, 0, 0.495626,-99)    );
  // itree = 1406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.886913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404535,-99) , 
0, 0.852865, 1, 0, 0.683061,-99) , 
3, 1.27254, 0, 0, 0.773732,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299496,-99) , 
3, -0.119068, 0, 0, 0.377342,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.101689,-99) , 
3, -0.959868, 0, 0, 0.269338,-99) , 
3, 0.301115, 0, 0, 0.499048,-99)    );
  // itree = 1407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.86424,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889516,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431712,-99) , 
0, 0.432477, 1, 0, 0.649922,-99) , 
3, 1.12392, 0, 0, 0.737959,-99) , 
NN(
0, 
0, 
-1, -0.448661, 0, -1, 0.262972,-99) , 
3, 0.0990605, 0, 0, 0.516299,-99)    );
  // itree = 1408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.861979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404905,-99) , 
0, 1.17663, 1, 0, 0.690762,-99) , 
3, 1.2782, 0, 0, 0.761257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568897,-99) , 
NN(
0, 
0, 
-1, -1.21931, 0, -1, 0.211546,-99) , 
3, -0.0103882, 0, 0, 0.26951,-99) , 
3, 0.306962, 0, 0, 0.491871,-99)    );
  // itree = 1409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.830208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482838,-99) , 
0, -0.0814742, 1, 0, 0.594299,-99) , 
3, 1.10245, 0, 0, 0.68371,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.215706,-99) , 
3, -0.207894, 0, 0, 0.483167,-99)    );
  // itree = 1410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.56698, 1, 1, 0.752147,-99) , 
NN(
0, 
0, 
-1, -1.19893, 0, -1, 0.241731,-99) , 
3, 0.120279, 0, 0, 0.494487,-99)    );
  // itree = 1411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.77784, 1, 1, 0.862044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318201,-99) , 
0, 0.738333, 1, 0, 0.564245,-99) , 
3, 1.07541, 0, 0, 0.675062,-99) , 
NN(
0, 
0, 
-1, -0.820825, 0, -1, 0.199368,-99) , 
3, -0.304384, 0, 0, 0.498918,-99)    );
  // itree = 1412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49244, 0, 1, 0.78633,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345016,-99) , 
0, -0.0316589, 1, 0, 0.528736,-99) , 
3, 0.540529, 0, 0, 0.692216,-99) , 
NN(
0, 
0, 
-1, -0.375211, 1, -1, 0.241041,-99) , 
3, -0.123397, 0, 0, 0.505771,-99)    );
  // itree = 1413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.69214, 0, 1, 0.840672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272127,-99) , 
3, 1.12157, 0, 0, 0.621305,-99) , 
0, 1.02343, 1, 0, 0.716088,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302794,-99) , 
0, -1.21855, 1, 0, 0.421578,-99) , 
NN(
0, 
0, 
-1, -0.316144, 1, -1, 0.131639,-99) , 
3, -1.0104, 0, 0, 0.324955,-99) , 
3, 0.238103, 0, 0, 0.514405,-99)    );
  // itree = 1414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.868655,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352966,-99) , 
0, 0.904545, 1, 0, 0.651524,-99) , 
3, 1.08361, 0, 0, 0.766376,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312707,-99) , 
1, -0.65168, 1, 0, 0.382076,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.125888,-99) , 
3, -0.957285, 0, 0, 0.294217,-99) , 
3, 0.306962, 0, 0, 0.519402,-99)    );
  // itree = 1415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.817876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400081,-99) , 
0, -0.0708108, 1, 0, 0.568547,-99) , 
3, 0.672086, 0, 0, 0.709953,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201408,-99) , 
0, -1.35582, 1, 0, 0.360672,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.10892,-99) , 
3, -1.07684, 0, 0, 0.237921,-99) , 
3, -0.202496, 0, 0, 0.515242,-99)    );
  // itree = 1416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.269693, 1, 1, 0.82811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450309,-99) , 
0, 0.465064, 1, 0, 0.618462,-99) , 
3, 1.05197, 0, 0, 0.708299,-99) , 
NN(
0, 
0, 
-1, -1.11972, 0, -1, 0.176155,-99) , 
3, -0.25059, 0, 0, 0.483692,-99)    );
  // itree = 1417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.439822, 0, 1, 0.747347,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295023,-99) , 
0, -0.745337, 1, 0, 0.467707,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.175137,-99) , 
3, -0.519004, 0, 0, 0.279681,-99) , 
3, 0.0354976, 0, 0, 0.518672,-99)    );
  // itree = 1418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.95036, 1, 1, 0.830187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340506,-99) , 
0, -0.135613, 1, 0, 0.560279,-99) , 
3, 0.540529, 0, 0, 0.72649,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.206708,-99) , 
3, -0.123397, 0, 0, 0.501789,-99)    );
  // itree = 1419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.856657,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270612,-99) , 
0, 1.0116, 1, 0, 0.616457,-99) , 
3, 1.13334, 0, 0, 0.707607,-99) , 
NN(
0, 
0, 
-1, -1.3741, 0, -1, 0.226145,-99) , 
3, -0.179298, 0, 0, 0.510569,-99)    );
  // itree = 1420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.872411,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397489,-99) , 
0, 0.696072, 1, 0, 0.638745,-99) , 
3, 1.07981, 0, 0, 0.758686,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346213,-99) , 
0, -1.05182, 1, 0, 0.453998,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.14611,-99) , 
3, -0.959342, 0, 0, 0.327313,-99) , 
3, 0.301115, 0, 0, 0.531942,-99)    );
  // itree = 1421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40643, 0, 1, 0.843199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290459,-99) , 
0, 0.775051, 1, 0, 0.569172,-99) , 
3, 1.07702, 0, 0, 0.666139,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.214538,-99) , 
3, -0.304384, 0, 0, 0.497652,-99)    );
  // itree = 1422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73293, 0, 1, 0.819448,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276318,-99) , 
0, 0.738333, 1, 0, 0.5705,-99) , 
3, 1.07643, 0, 0, 0.663129,-99) , 
NN(
0, 
0, 
-1, -1.07066, 0, -1, 0.181732,-99) , 
3, -0.304384, 0, 0, 0.475355,-99)    );
  // itree = 1423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.806257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714211,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341797,-99) , 
0, -0.201627, 1, 0, 0.498671,-99) , 
3, 0.546413, 0, 0, 0.697959,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230973,-99) , 
0, -1.36423, 1, 0, 0.367301,-99) , 
NN(
0, 
0, 
-1, 0.0272174, 1, -1, 0.12351,-99) , 
3, -1.01154, 0, 0, 0.230241,-99) , 
3, -0.123397, 0, 0, 0.49094,-99)    );
  // itree = 1424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.90226,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438679,-99) , 
0, 0.856209, 1, 0, 0.683084,-99) , 
3, 1.41125, 0, 0, 0.767783,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587444,-99) , 
NN(
0, 
0, 
-1, -0.958523, 0, -1, 0.20683,-99) , 
3, -0.0593009, 0, 0, 0.273863,-99) , 
3, 0.254861, 0, 0, 0.502803,-99)    );
  // itree = 1425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.497815, 1, 1, 0.883859,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.857477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352119,-99) , 
3, 1.39607, 0, 0, 0.648255,-99) , 
0, 1.15389, 1, 0, 0.746552,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343145,-99) , 
0, -0.773268, 1, 0, 0.483911,-99) , 
NN(
0, 
0, 
-1, -0.979519, 0, -1, 0.17634,-99) , 
3, -0.391132, 0, 0, 0.287098,-99) , 
3, 0.238103, 0, 0, 0.489899,-99)    );
  // itree = 1426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11079, 1, 1, 0.835904,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.930029,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438458,-99) , 
0, 0.265001, 1, 0, 0.650106,-99) , 
3, 0.809713, 0, 0, 0.766269,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39339,-99) , 
1, -0.111661, 1, 0, 0.516192,-99) , 
NN(
0, 
0, 
-1, -1.05005, 0, -1, 0.196274,-99) , 
3, -0.322974, 0, 0, 0.290689,-99) , 
3, 0.20809, 0, 0, 0.513359,-99)    );
  // itree = 1427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69543, 0, 1, 0.880317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380341,-99) , 
0, 0.738333, 1, 0, 0.607629,-99) , 
3, 1.23011, 0, 0, 0.693371,-99) , 
NN(
0, 
0, 
-1, -1.76249, 1, -1, 0.147032,-99) , 
3, -0.376892, 0, 0, 0.481442,-99)    );
  // itree = 1428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.262793, 1, 1, 0.893459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376668,-99) , 
3, 0.994438, 0, 0, 0.646692,-99) , 
0, 0.484401, 1, 0, 0.734484,-99) , 
NN(
0, 
0, 
-1, -0.422153, 0, -1, 0.28293,-99) , 
3, -0.123397, 0, 0, 0.539776,-99)    );
  // itree = 1429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90497, 1, 1, 0.864159,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350813,-99) , 
0, 0.465064, 1, 0, 0.589377,-99) , 
3, 0.978312, 0, 0, 0.707389,-99) , 
NN(
0, 
0, 
-1, -1.53396, 1, -1, 0.172325,-99) , 
3, -0.38184, 0, 0, 0.505233,-99)    );
  // itree = 1430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48056, 1, 1, 0.900117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300093,-99) , 
0, 1.52189, 1, 0, 0.6862,-99) , 
3, 1.48336, 0, 0, 0.758284,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275594,-99) , 
0, -1.43742, 1, 0, 0.348156,-99) , 
NN(
0, 
0, 
-1, -0.179697, 1, -1, 0.0963972,-99) , 
3, -1.08906, 0, 0, 0.269511,-99) , 
3, 0.262941, 0, 0, 0.49177,-99)    );
  // itree = 1431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.845502,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237687,-99) , 
0, 1.0116, 1, 0, 0.55035,-99) , 
3, 1.12022, 0, 0, 0.658703,-99) , 
NN(
0, 
0, 
-1, -0.671625, 0, -1, 0.196985,-99) , 
3, -0.181176, 0, 0, 0.457838,-99)    );
  // itree = 1432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58845, 1, 1, 0.864641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496186,-99) , 
0, 0.492106, 1, 0, 0.708534,-99) , 
3, 1.11353, 0, 0, 0.779162,-99) , 
NN(
0, 
0, 
-1, -0.455254, 0, -1, 0.24331,-99) , 
3, 0.093663, 0, 0, 0.524384,-99)    );
  // itree = 1433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00736, 0, 1, 0.751753,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355271,-99) , 
0, -1.23517, 1, 0, 0.445951,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.122785,-99) , 
3, -0.93003, 0, 0, 0.286513,-99) , 
3, 0.17816, 0, 0, 0.514965,-99)    );
  // itree = 1434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42073, 0, 1, 0.754754,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310307,-99) , 
2, -0.126429, 1, 0, 0.424077,-99) , 
NN(
0, 
0, 
-1, -0.610343, 1, -1, 0.164991,-99) , 
3, -0.379167, 0, 0, 0.25746,-99) , 
3, 0.17816, 0, 0, 0.502534,-99)    );
  // itree = 1435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44992, 0, 1, 0.782669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369183,-99) , 
0, -0.250399, 1, 0, 0.533291,-99) , 
3, 0.489001, 0, 0, 0.696407,-99) , 
NN(
0, 
0, 
-1, -0.937696, 0, -1, 0.20746,-99) , 
3, -0.18324, 0, 0, 0.506667,-99)    );
  // itree = 1436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.516222, 0, 1, 0.760352,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298231,-99) , 
0, -0.991976, 1, 0, 0.38372,-99) , 
NN(
0, 
0, 
-1, -0.239497, 1, -1, 0.0909096,-99) , 
3, -0.990852, 0, 0, 0.259088,-99) , 
3, 0.0990605, 0, 0, 0.520608,-99)    );
  // itree = 1437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.879994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348649,-99) , 
0, 1.10293, 1, 0, 0.648396,-99) , 
3, 1.36907, 0, 0, 0.747398,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236794,-99) , 
0, -0.802449, 1, 0, 0.340482,-99) , 
NN(
0, 
0, 
-1, 0.0242633, 1, -1, 0.0885441,-99) , 
3, -1.03907, 0, 0, 0.245631,-99) , 
3, 0.218994, 0, 0, 0.504224,-99)    );
  // itree = 1438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.22605, 1, 1, 0.844098,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320273,-99) , 
0, 0.957246, 1, 0, 0.619543,-99) , 
3, 1.20395, 0, 0, 0.701841,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.21981,-99) , 
3, -0.123397, 0, 0, 0.504296,-99)    );
  // itree = 1439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.450707, 1, 1, 0.858258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484827,-99) , 
3, 1.4111, 0, 0, 0.717231,-99) , 
0, 1.4124, 1, 0, 0.789602,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313722,-99) , 
0, -0.202361, 1, 0, 0.488482,-99) , 
NN(
0, 
0, 
-1, -1.19115, 0, -1, 0.170289,-99) , 
3, -0.329735, 0, 0, 0.293984,-99) , 
3, 0.301115, 0, 0, 0.499599,-99)    );
  // itree = 1440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0922746, 0, 1, 0.910183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439886,-99) , 
3, 1.41325, 0, 0, 0.715657,-99) , 
0, 0.986637, 1, 0, 0.791861,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289137,-99) , 
1, -0.508399, 1, 0, 0.371856,-99) , 
NN(
0, 
0, 
-1, -0.257029, 1, -1, 0.13856,-99) , 
3, -0.886371, 0, 0, 0.277853,-99) , 
3, 0.392653, 0, 0, 0.469307,-99)    );
  // itree = 1441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.725244, 0, 1, 0.917334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371973,-99) , 
3, 1.20358, 0, 0, 0.716462,-99) , 
0, 1.06599, 1, 0, 0.789809,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270279,-99) , 
0, -1.26324, 1, 0, 0.357317,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.0828313,-99) , 
3, -1.20576, 0, 0, 0.276907,-99) , 
3, 0.392653, 0, 0, 0.496722,-99)    );
  // itree = 1442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47192, 0, 1, 0.783376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452664,-99) , 
3, 0.244337, 0, 0, 0.711888,-99) , 
NN(
0, 
0, 
-1, -1.17601, 1, -1, 0.183226,-99) , 
3, -0.210183, 0, 0, 0.493417,-99)    );
  // itree = 1443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27925, 1, 1, 0.897989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344815,-99) , 
0, 1.06066, 1, 0, 0.622438,-99) , 
3, 1.3922, 0, 0, 0.713327,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358955,-99) , 
0, -1.20938, 1, 0, 0.440043,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.112762,-99) , 
3, -1.0104, 0, 0, 0.314242,-99) , 
3, 0.238103, 0, 0, 0.501411,-99)    );
  // itree = 1444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.385287, 0, 1, 0.905046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441657,-99) , 
3, 1.36283, 0, 0, 0.748312,-99) , 
0, 1.16902, 1, 0, 0.82049,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33363,-99) , 
1, -0.252733, 1, 0, 0.43098,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.139152,-99) , 
3, -0.495085, 0, 0, 0.269225,-99) , 
3, 0.307824, 0, 0, 0.510553,-99)    );
  // itree = 1445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14801, 1, 1, 0.843194,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332767,-99) , 
0, 0.676493, 1, 0, 0.593839,-99) , 
3, 0.983057, 0, 0, 0.694792,-99) , 
NN(
0, 
0, 
-1, -1.62443, 0, -1, 0.197187,-99) , 
3, -0.376892, 0, 0, 0.51136,-99)    );
  // itree = 1446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.891666,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372086,-99) , 
0, 0.854666, 1, 0, 0.633643,-99) , 
3, 1.20395, 0, 0, 0.738612,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191818,-99) , 
0, -1.20513, 1, 0, 0.336173,-99) , 
NN(
0, 
0, 
-1, -0.610343, 1, -1, 0.0942272,-99) , 
3, -1.00886, 0, 0, 0.216616,-99) , 
3, -0.123397, 0, 0, 0.52017,-99)    );
  // itree = 1447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60382, 1, 1, 0.850232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326323,-99) , 
0, 0.683966, 1, 0, 0.605782,-99) , 
3, 1.00736, 0, 0, 0.729533,-99) , 
NN(
0, 
0, 
-1, -0.379167, 0, -1, 0.284512,-99) , 
3, 0.17816, 0, 0, 0.493616,-99)    );
  // itree = 1448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.852338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398981,-99) , 
0, 0.84413, 1, 0, 0.640659,-99) , 
3, 1.21586, 0, 0, 0.734265,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24847,-99) , 
0, -1.39151, 1, 0, 0.355509,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.121007,-99) , 
3, -1.21239, 0, 0, 0.290249,-99) , 
3, 0.17816, 0, 0, 0.500814,-99)    );
  // itree = 1449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.77048, 0, 1, 0.829291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358497,-99) , 
0, 0.708301, 1, 0, 0.597237,-99) , 
3, 1.15167, 0, 0, 0.681968,-99) , 
NN(
0, 
0, 
-1, -1.09998, 0, -1, 0.22884,-99) , 
3, -0.145253, 0, 0, 0.510316,-99)    );
  // itree = 1450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.298272, 1, 1, 0.738326,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221267,-99) , 
0, -1.07324, 1, 0, 0.350115,-99) , 
NN(
0, 
0, 
-1, -0.259045, 1, -1, 0.0677937,-99) , 
3, -0.932655, 0, 0, 0.229011,-99) , 
3, 0.17816, 0, 0, 0.492964,-99)    );
  // itree = 1451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56776, 1, 1, 0.901368,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397877,-99) , 
0, 0.774542, 1, 0, 0.619457,-99) , 
3, 1.17916, 0, 0, 0.725445,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295032,-99) , 
0, -0.765399, 1, 0, 0.390974,-99) , 
NN(
0, 
0, 
-1, -1.57745, 1, -1, 0.119787,-99) , 
3, -0.629118, 0, 0, 0.225499,-99) , 
3, 0.178444, 0, 0, 0.464135,-99)    );
  // itree = 1452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43501, 1, 1, 0.875073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315346,-99) , 
0, 0.738333, 1, 0, 0.613198,-99) , 
3, 1.10862, 0, 0, 0.711172,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177111,-99) , 
0, -1.30318, 1, 0, 0.309229,-99) , 
NN(
0, 
0, 
-1, -0.579992, 0, -1, 0.155541,-99) , 
3, -1.36915, 0, 0, 0.248756,-99) , 
3, -0.202496, 0, 0, 0.521286,-99)    );
  // itree = 1453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40589, 0, 1, 0.837555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459139,-99) , 
0, -0.827558, 1, 0, 0.521774,-99) , 
3, 0.913904, 0, 0, 0.653899,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.162436,-99) , 
3, -0.435158, 0, 0, 0.476912,-99)    );
  // itree = 1454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.86864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382417,-99) , 
0, 0.972004, 1, 0, 0.673956,-99) , 
3, 1.22221, 0, 0, 0.758084,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293939,-99) , 
0, -1.21855, 1, 0, 0.403239,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.122318,-99) , 
3, -1.00045, 0, 0, 0.293968,-99) , 
3, 0.254861, 0, 0, 0.516796,-99)    );
  // itree = 1455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.87535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49443,-99) , 
0, 0.530902, 1, 0, 0.651331,-99) , 
3, 1.11353, 0, 0, 0.757353,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281416,-99) , 
1, -0.507862, 1, 0, 0.347389,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0802181,-99) , 
3, -0.997451, 0, 0, 0.236994,-99) , 
3, 0.093663, 0, 0, 0.500274,-99)    );
  // itree = 1456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.844585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265514,-99) , 
0, 0.591363, 1, 0, 0.53829,-99) , 
3, 1.10862, 0, 0, 0.654089,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.214422,-99) , 
3, -0.202496, 0, 0, 0.477832,-99)    );
  // itree = 1457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.858315,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383293,-99) , 
0, 0.848875, 1, 0, 0.63449,-99) , 
3, 1.20464, 0, 0, 0.703819,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.178188,-99) , 
3, -0.38184, 0, 0, 0.5226,-99)    );
  // itree = 1458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.839836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332467,-99) , 
0, 0.424748, 1, 0, 0.604538,-99) , 
3, 0.999126, 0, 0, 0.716405,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156786,-99) , 
0, -1.21605, 1, 0, 0.335294,-99) , 
NN(
0, 
0, 
-1, -2.23431, 1, -1, 0.111529,-99) , 
3, -1.0146, 0, 0, 0.218604,-99) , 
3, -0.123397, 0, 0, 0.492227,-99)    );
  // itree = 1459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.800745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454046,-99) , 
0, 0.0136911, 1, 0, 0.609428,-99) , 
3, 0.676198, 0, 0, 0.721208,-99) , 
NN(
0, 
0, 
-1, -1.07872, 0, -1, 0.222175,-99) , 
3, -0.202496, 0, 0, 0.521469,-99)    );
  // itree = 1460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55993, 1, 1, 0.850387,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316514,-99) , 
0, 0.926242, 1, 0, 0.55378,-99) , 
3, 1.21562, 0, 0, 0.637346,-99) , 
NN(
0, 
0, 
-1, -0.251111, 1, -1, 0.160408,-99) , 
3, -0.749223, 0, 0, 0.504947,-99)    );
  // itree = 1461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.833542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283592,-99) , 
0, 0.539544, 1, 0, 0.603544,-99) , 
3, 0.990695, 0, 0, 0.692612,-99) , 
NN(
0, 
0, 
-1, -1.37508, 0, -1, 0.186855,-99) , 
3, -0.376892, 0, 0, 0.515846,-99)    );
  // itree = 1462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.867679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376935,-99) , 
0, 0.859775, 1, 0, 0.647994,-99) , 
3, 1.334, 0, 0, 0.730251,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294502,-99) , 
0, -1.01188, 1, 0, 0.408303,-99) , 
NN(
0, 
0, 
-1, -1.43032, 0, -1, 0.116243,-99) , 
3, -0.725985, 0, 0, 0.240617,-99) , 
3, 0.093663, 0, 0, 0.505494,-99)    );
  // itree = 1463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66547, 0, 1, 0.798814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300387,-99) , 
0, 0.312923, 1, 0, 0.582053,-99) , 
3, 0.633048, 0, 0, 0.72581,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210875,-99) , 
0, -0.773268, 1, 0, 0.400938,-99) , 
NN(
0, 
0, 
-1, -1.73303, 0, -1, 0.171672,-99) , 
3, -0.519004, 0, 0, 0.26303,-99) , 
3, 0.017859, 0, 0, 0.515705,-99)    );
  // itree = 1464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.07702, 0, 1, 0.677673,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.239659,-99) , 
3, -0.304384, 0, 0, 0.520637,-99)    );
  // itree = 1465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.842187, 0, 1, 0.871411,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406626,-99) , 
3, 1.13727, 0, 0, 0.701378,-99) , 
0, 1.09855, 1, 0, 0.771538,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335669,-99) , 
0, -0.598381, 1, 0, 0.460882,-99) , 
NN(
0, 
0, 
-1, -1.18692, 0, -1, 0.183396,-99) , 
3, -0.329146, 0, 0, 0.288218,-99) , 
3, 0.301115, 0, 0, 0.504467,-99)    );
  // itree = 1466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25991, 0, 1, 0.854362,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382769,-99) , 
3, 1.53259, 0, 0, 0.649135,-99) , 
0, 1.65578, 1, 0, 0.767935,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339008,-99) , 
1, -0.472421, 1, 0, 0.422653,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.120856,-99) , 
3, -1.00762, 0, 0, 0.308623,-99) , 
3, 0.325234, 0, 0, 0.506154,-99)    );
  // itree = 1467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.86288,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382575,-99) , 
0, 0.396078, 1, 0, 0.584534,-99) , 
3, 1.1447, 0, 0, 0.684779,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177934,-99) , 
0, -1.37863, 1, 0, 0.331978,-99) , 
NN(
0, 
0, 
-1, -1.81027, 0, -1, 0.0720928,-99) , 
3, -1.20728, 0, 0, 0.216961,-99) , 
3, -0.210183, 0, 0, 0.501097,-99)    );
  // itree = 1468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60089, 0, 1, 0.806066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363475,-99) , 
0, -0.0834363, 1, 0, 0.552835,-99) , 
3, 0.753497, 0, 0, 0.688501,-99) , 
NN(
0, 
0, 
-1, -0.827936, 0, -1, 0.204844,-99) , 
3, -0.344168, 0, 0, 0.518172,-99)    );
  // itree = 1469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54712, 1, 1, 0.842645,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390914,-99) , 
0, 0.906178, 1, 0, 0.637191,-99) , 
3, 1.17884, 0, 0, 0.722122,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366779,-99) , 
1, -0.203221, 1, 0, 0.49202,-99) , 
NN(
0, 
0, 
-1, -1.35886, 1, -1, 0.185006,-99) , 
3, -0.357516, 0, 0, 0.277381,-99) , 
3, 0.178444, 0, 0, 0.497474,-99)    );
  // itree = 1470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14535, 0, 1, 0.841954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445791,-99) , 
0, -0.102501, 1, 0, 0.605312,-99) , 
3, 0.78321, 0, 0, 0.732841,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191038,-99) , 
0, -1.23094, 1, 0, 0.347402,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.13466,-99) , 
3, -1.01154, 0, 0, 0.242987,-99) , 
3, -0.123397, 0, 0, 0.514808,-99)    );
  // itree = 1471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.338764, 0, 1, 0.725649,-99) , 
NN(
0, 
0, 
-1, -0.422214, 1, -1, 0.253414,-99) , 
3, -0.10679, 0, 0, 0.522816,-99)    );
  // itree = 1472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43501, 1, 1, 0.857999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379252,-99) , 
0, 0.819377, 1, 0, 0.624058,-99) , 
3, 1.07833, 0, 0, 0.739482,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568459,-99) , 
NN(
0, 
0, 
-1, -1.2961, 0, -1, 0.272026,-99) , 
3, -0.00769274, 0, 0, 0.322668,-99) , 
3, 0.262941, 0, 0, 0.517409,-99)    );
  // itree = 1473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.811957,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380797,-99) , 
0, 0.256929, 1, 0, 0.601201,-99) , 
3, 0.779005, 0, 0, 0.716571,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184864,-99) , 
0, -1.27491, 1, 0, 0.324705,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.129966,-99) , 
3, -1.07711, 0, 0, 0.24531,-99) , 
3, -0.10679, 0, 0, 0.51836,-99)    );
  // itree = 1474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.843539,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381177,-99) , 
0, 0.904545, 1, 0, 0.66349,-99) , 
3, 1.217, 0, 0, 0.741894,-99) , 
NN(
0, 
0, 
-1, -0.379167, 0, -1, 0.277241,-99) , 
3, 0.17816, 0, 0, 0.497503,-99)    );
  // itree = 1475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.877102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445094,-99) , 
0, 0.465064, 1, 0, 0.603083,-99) , 
3, 1.10245, 0, 0, 0.710789,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227131,-99) , 
0, -1.37022, 1, 0, 0.346759,-99) , 
NN(
0, 
0, 
-1, -2.82334, 1, -1, 0.100257,-99) , 
3, -1.1841, 0, 0, 0.240964,-99) , 
3, -0.218424, 0, 0, 0.524088,-99)    );
  // itree = 1476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.810546,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229053,-99) , 
0, 0.168185, 1, 0, 0.484269,-99) , 
3, 0.543354, 0, 0, 0.683862,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.182892,-99) , 
3, -0.123397, 0, 0, 0.47229,-99)    );
  // itree = 1477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96637, 1, 1, 0.840979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3644,-99) , 
0, 0.790645, 1, 0, 0.637562,-99) , 
3, 0.986442, 0, 0, 0.742096,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287738,-99) , 
0, -0.947382, 1, 0, 0.405047,-99) , 
NN(
0, 
0, 
-1, -2.25891, 1, -1, 0.152045,-99) , 
3, -0.616659, 0, 0, 0.26533,-99) , 
3, 0.183842, 0, 0, 0.500734,-99)    );
  // itree = 1478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61227, 0, 1, 0.873054,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348234,-99) , 
0, 1.0116, 1, 0, 0.583054,-99) , 
3, 1.30607, 0, 0, 0.667919,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.2023,-99) , 
3, -0.304384, 0, 0, 0.502066,-99)    );
  // itree = 1479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.495183, 1, 1, 0.808139,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279961,-99) , 
1, -0.473945, 1, 0, 0.362878,-99) , 
NN(
0, 
0, 
-1, -1.72922, 0, -1, 0.134234,-99) , 
3, -0.959342, 0, 0, 0.285241,-99) , 
3, 0.306962, 0, 0, 0.507393,-99)    );
  // itree = 1480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.96469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481477,-99) , 
3, 1.08045, 0, 0, 0.705548,-99) , 
0, 0.311772, 1, 0, 0.759721,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307154,-99) , 
0, -0.564821, 1, 0, 0.44088,-99) , 
NN(
0, 
0, 
-1, -1.25437, 0, -1, 0.204891,-99) , 
3, -0.549899, 0, 0, 0.31288,-99) , 
3, 0.262941, 0, 0, 0.534436,-99)    );
  // itree = 1481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50419, 1, 1, 0.900716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457288,-99) , 
0, 1.02702, 1, 0, 0.626658,-99) , 
3, 1.46318, 0, 0, 0.697388,-99) , 
NN(
0, 
0, 
-1, -0.842422, 0, -1, 0.230642,-99) , 
3, -0.266059, 0, 0, 0.507783,-99)    );
  // itree = 1482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.880708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401257,-99) , 
0, 0.830092, 1, 0, 0.64337,-99) , 
3, 1.217, 0, 0, 0.75028,-99) , 
NN(
0, 
0, 
-1, -0.927516, 0, -1, 0.262306,-99) , 
3, 0.17816, 0, 0, 0.511838,-99)    );
  // itree = 1483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.88907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412913,-99) , 
0, 0.89375, 1, 0, 0.674567,-99) , 
3, 1.31726, 0, 0, 0.748151,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257727,-99) , 
0, -1.21855, 1, 0, 0.33791,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.148925,-99) , 
3, -0.997451, 0, 0, 0.263958,-99) , 
3, 0.093663, 0, 0, 0.508119,-99)    );
  // itree = 1484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51354, 1, 1, 0.84945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400006,-99) , 
0, 0.20158, 1, 0, 0.588491,-99) , 
3, 0.98281, 0, 0, 0.697975,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159433,-99) , 
0, -1.01188, 1, 0, 0.337943,-99) , 
NN(
0, 
0, 
-1, 0.0190603, 1, -1, 0.100954,-99) , 
3, -1.00886, 0, 0, 0.226821,-99) , 
3, -0.123397, 0, 0, 0.496091,-99)    );
  // itree = 1485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.33266, 0, 1, 0.642198,-99) , 
NN(
0, 
0, 
-1, -1.72234, 0, -1, 0.145754,-99) , 
3, -0.639447, 0, 0, 0.516195,-99)    );
  // itree = 1486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48899, 0, 1, 0.849173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369501,-99) , 
0, 0.397804, 1, 0, 0.590455,-99) , 
3, 0.98281, 0, 0, 0.709391,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.232198,-99) , 
3, -0.123397, 0, 0, 0.511087,-99)    );
  // itree = 1487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.294724, 0, 1, 0.892656,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294709,-99) , 
3, 0.84411, 0, 0, 0.635603,-99) , 
0, 0.29393, 1, 0, 0.703915,-99) , 
NN(
0, 
0, 
-1, -1.03626, 0, -1, 0.220836,-99) , 
3, -0.0698586, 0, 0, 0.488113,-99)    );
  // itree = 1488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58602, 0, 1, 0.832894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733922,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229029,-99) , 
0, 1.0116, 1, 0, 0.620353,-99) , 
3, 1.10862, 0, 0, 0.70282,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204716,-99) , 
0, -1.54046, 1, 0, 0.309491,-99) , 
NN(
0, 
0, 
-1, 0.317366, 1, -1, 0.112236,-99) , 
2, -1.49552, 0, 0, 0.240313,-99) , 
3, -0.202496, 0, 0, 0.523344,-99)    );
  // itree = 1489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.858163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265878,-99) , 
0, 0.979653, 1, 0, 0.614788,-99) , 
3, 1.16365, 0, 0, 0.708194,-99) , 
NN(
0, 
0, 
-1, -0.933341, 0, -1, 0.209495,-99) , 
3, -0.18324, 0, 0, 0.506076,-99)    );
  // itree = 1490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42951, 1, 1, 0.794053,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322691,-99) , 
0, -0.0316589, 1, 0, 0.541682,-99) , 
3, 0.558884, 0, 0, 0.703871,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.212074,-99) , 
3, -0.123397, 0, 0, 0.490316,-99)    );
  // itree = 1491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.87354,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423582,-99) , 
0, 0.639693, 1, 0, 0.635679,-99) , 
3, 1.07833, 0, 0, 0.758533,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345126,-99) , 
0, -0.632405, 1, 0, 0.506239,-99) , 
NN(
0, 
0, 
-1, -1.26634, 0, -1, 0.181561,-99) , 
3, -0.556192, 0, 0, 0.314892,-99) , 
3, 0.262941, 0, 0, 0.508714,-99)    );
  // itree = 1492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72973, 1, 1, 0.844999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385441,-99) , 
0, -0.158894, 1, 0, 0.534942,-99) , 
3, 0.764338, 0, 0, 0.706674,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215268,-99) , 
0, -1.01188, 1, 0, 0.388103,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.123766,-99) , 
3, -1.00886, 0, 0, 0.254871,-99) , 
3, -0.123397, 0, 0, 0.513949,-99)    );
  // itree = 1493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.223166, 1, 1, 0.922795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390086,-99) , 
3, 1.14028, 0, 0, 0.704989,-99) , 
0, 0.785602, 1, 0, 0.769309,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28858,-99) , 
0, -1.27242, 1, 0, 0.368895,-99) , 
NN(
0, 
0, 
-1, -2.46146, 1, -1, 0.121785,-99) , 
3, -0.98406, 0, 0, 0.28079,-99) , 
3, 0.310134, 0, 0, 0.480325,-99)    );
  // itree = 1494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43501, 1, 1, 0.837828,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433161,-99) , 
0, 0.266635, 1, 0, 0.588295,-99) , 
3, 1.12392, 0, 0, 0.692892,-99) , 
NN(
0, 
0, 
-1, -0.448661, 0, -1, 0.234925,-99) , 
3, 0.0990605, 0, 0, 0.469035,-99)    );
  // itree = 1495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47561, 1, 1, 0.801254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326895,-99) , 
0, 0.327751, 1, 0, 0.556587,-99) , 
3, 0.767226, 0, 0, 0.690826,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.18727,-99) , 
3, -0.123397, 0, 0, 0.47607,-99)    );
  // itree = 1496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.855601,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377903,-99) , 
0, 0.708301, 1, 0, 0.623362,-99) , 
3, 1.2063, 0, 0, 0.706098,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201993,-99) , 
0, -1.20764, 1, 0, 0.303032,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.0853114,-99) , 
3, -1.01154, 0, 0, 0.205891,-99) , 
3, -0.123397, 0, 0, 0.482533,-99)    );
  // itree = 1497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.843112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466475,-99) , 
0, -0.0385343, 1, 0, 0.591988,-99) , 
3, 1.2063, 0, 0, 0.683846,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.222938,-99) , 
3, -0.123397, 0, 0, 0.49273,-99)    );
  // itree = 1498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.832774,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353056,-99) , 
0, 0.281825, 1, 0, 0.574196,-99) , 
3, 0.672086, 0, 0, 0.7155,-99) , 
NN(
0, 
0, 
-1, 0.490898, 1, -1, 0.240773,-99) , 
3, -0.202496, 0, 0, 0.524251,-99)    );
  // itree = 1499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.809118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31184,-99) , 
0, 0.540099, 1, 0, 0.60768,-99) , 
3, 0.849319, 0, 0, 0.720834,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225532,-99) , 
0, -1.44513, 1, 0, 0.309289,-99) , 
NN(
0, 
0, 
-1, 0.505611, 0, -1, 0.0917479,-99) , 
3, -1.32607, 0, 0, 0.250327,-99) , 
3, 0.0354976, 0, 0, 0.49014,-99)    );
  // itree = 1500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28384, 0, 1, 0.772352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390771,-99) , 
1, -0.304726, 1, 0, 0.507044,-99) , 
3, 0.312308, 0, 0, 0.681461,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.191269,-99) , 
3, -0.376892, 0, 0, 0.5136,-99)    );
  // itree = 1501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.728565, 1, 1, 0.821502,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411825,-99) , 
0, 0.486742, 1, 0, 0.561979,-99) , 
3, 1.1447, 0, 0, 0.646303,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.11454,-99) , 
3, -1.2248, 0, 0, 0.316188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136996,-99) , 
0, -1.43669, 1, 0, 0.225158,-99) , 
3, -0.210183, 0, 0, 0.478562,-99)    );
  // itree = 1502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57052, 1, 1, 0.81093,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399533,-99) , 
0, -0.102501, 1, 0, 0.586953,-99) , 
3, 0.668127, 0, 0, 0.711655,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.204782,-99) , 
3, -0.207894, 0, 0, 0.496189,-99)    );
  // itree = 1503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.797183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288329,-99) , 
0, 0.0283988, 1, 0, 0.470084,-99) , 
NN(
0, 
0, 
-1, -0.99397, 0, -1, 0.155051,-99) , 
3, -0.511418, 0, 0, 0.307387,-99) , 
3, 0.644527, 0, 0, 0.471139,-99)    );
  // itree = 1504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.391642, 1, 1, 0.799285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498511,-99) , 
3, 0.235551, 0, 0, 0.730101,-99) , 
NN(
0, 
0, 
-1, -0.500912, 1, -1, 0.203316,-99) , 
3, -0.202496, 0, 0, 0.50318,-99)    );
  // itree = 1505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.861373,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363374,-99) , 
0, 0.717577, 1, 0, 0.607742,-99) , 
3, 1.29097, 0, 0, 0.70134,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219404,-99) , 
0, -1.23094, 1, 0, 0.323715,-99) , 
NN(
0, 
0, 
-1, -0.546181, 1, -1, 0.110448,-99) , 
3, -0.932139, 0, 0, 0.229127,-99) , 
3, 0.116632, 0, 0, 0.457873,-99)    );
  // itree = 1506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.866116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350945,-99) , 
0, 0.807964, 1, 0, 0.625063,-99) , 
3, 1.21436, 0, 0, 0.736435,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306081,-99) , 
0, -1.44513, 1, 0, 0.365157,-99) , 
NN(
0, 
0, 
-1, -2.93909, 1, -1, 0.0936083,-99) , 
3, -1.2031, 0, 0, 0.283749,-99) , 
3, 0.17816, 0, 0, 0.501549,-99)    );
  // itree = 1507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.894216,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444636,-99) , 
0, 0.210411, 1, 0, 0.611845,-99) , 
3, 0.99324, 0, 0, 0.746713,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230096,-99) , 
0, -1.20764, 1, 0, 0.339309,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.135376,-99) , 
3, -1.00886, 0, 0, 0.248678,-99) , 
3, -0.123397, 0, 0, 0.539134,-99)    );
  // itree = 1508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.78166, 1, 1, 0.841287,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.919652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433303,-99) , 
0, -0.0850049, 1, 0, 0.599002,-99) , 
3, 0.800667, 0, 0, 0.750559,-99) , 
NN(
0, 
0, 
-1, -0.379167, 0, -1, 0.255507,-99) , 
3, 0.17816, 0, 0, 0.503103,-99)    );
  // itree = 1509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.86059,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32863,-99) , 
0, 0.964063, 1, 0, 0.606994,-99) , 
3, 1.21404, 0, 0, 0.710678,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229007,-99) , 
0, -0.919502, 1, 0, 0.332388,-99) , 
NN(
0, 
0, 
-1, -1.59924, 0, -1, 0.106445,-99) , 
3, -0.927516, 0, 0, 0.234316,-99) , 
3, 0.17816, 0, 0, 0.466054,-99)    );
  // itree = 1510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.847395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752687,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262828,-99) , 
0, 1.05776, 1, 0, 0.643984,-99) , 
3, 1.15111, 0, 0, 0.716938,-99) , 
NN(
0, 
0, 
-1, -1.10081, 0, -1, 0.203629,-99) , 
3, -0.147314, 0, 0, 0.503491,-99)    );
  // itree = 1511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.934758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494833,-99) , 
3, 1.01203, 0, 0, 0.689633,-99) , 
0, 0.292584, 1, 0, 0.736252,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40818,-99) , 
2, -0.228761, 1, 0, 0.466988,-99) , 
NN(
0, 
0, 
-1, -1.12472, 0, -1, 0.164629,-99) , 
3, -0.376357, 0, 0, 0.258408,-99) , 
3, 0.17816, 0, 0, 0.486929,-99)    );
  // itree = 1512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.932931, 1, 1, 0.858515,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411037,-99) , 
0, 0.0236733, 1, 0, 0.594235,-99) , 
3, 0.715226, 0, 0, 0.76074,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207995,-99) , 
0, -1.21605, 1, 0, 0.311254,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.125558,-99) , 
3, -0.993962, 0, 0, 0.236979,-99) , 
3, 0.093663, 0, 0, 0.484999,-99)    );
  // itree = 1513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.904249,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421274,-99) , 
0, 0.852865, 1, 0, 0.668894,-99) , 
3, 1.28085, 0, 0, 0.768966,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394046,-99) , 
0, -0.773268, 1, 0, 0.496755,-99) , 
NN(
0, 
0, 
-1, -1.03116, 0, -1, 0.200537,-99) , 
3, -0.548378, 0, 0, 0.327761,-99) , 
3, 0.262941, 0, 0, 0.521111,-99)    );
  // itree = 1514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.883184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482275,-99) , 
0, 0.459356, 1, 0, 0.618187,-99) , 
3, 1.20885, 0, 0, 0.71865,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244566,-99) , 
0, -1.25617, 1, 0, 0.373136,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.112818,-99) , 
3, -1.00886, 0, 0, 0.238632,-99) , 
3, -0.123397, 0, 0, 0.513371,-99)    );
  // itree = 1515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.862756,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353777,-99) , 
0, 0.852865, 1, 0, 0.612422,-99) , 
3, 1.07981, 0, 0, 0.747758,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192147,-99) , 
0, -0.153185, 1, 0, 0.395161,-99) , 
NN(
0, 
0, 
-1, -2.0971, 1, -1, 0.108854,-99) , 
3, -0.644871, 0, 0, 0.250361,-99) , 
3, 0.301115, 0, 0, 0.456575,-99)    );
  // itree = 1516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.828979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360625,-99) , 
0, 0.487598, 1, 0, 0.541726,-99) , 
3, 0.805619, 0, 0, 0.7124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269355,-99) , 
0, -0.5694, 1, 0, 0.427111,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.142183,-99) , 
3, -0.379167, 0, 0, 0.232232,-99) , 
3, 0.17816, 0, 0, 0.453079,-99)    );
  // itree = 1517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.09414, 0, 1, 0.795676,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247767,-99) , 
0, 0.576421, 1, 0, 0.522624,-99) , 
3, 0.746767, 0, 0, 0.643683,-99) , 
NN(
0, 
0, 
-1, -1.24622, 0, -1, 0.174107,-99) , 
3, -0.711955, 0, 0, 0.512387,-99)    );
  // itree = 1518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49285, 0, 1, 0.855828,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267465,-99) , 
0, 0.871083, 1, 0, 0.590762,-99) , 
3, 0.985321, 0, 0, 0.699277,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195924,-99) , 
0, -1.63235, 1, 0, 0.278591,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.0407792,-99) , 
3, -1.3037, 0, 0, 0.202173,-99) , 
3, -0.123397, 0, 0, 0.481978,-99)    );
  // itree = 1519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85326, 1, 1, 0.886071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447311,-99) , 
0, 0.856209, 1, 0, 0.68141,-99) , 
3, 1.42244, 0, 0, 0.759619,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280869,-99) , 
0, -0.866905, 1, 0, 0.410022,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.128695,-99) , 
3, -0.927516, 0, 0, 0.292312,-99) , 
3, 0.17816, 0, 0, 0.508209,-99)    );
  // itree = 1520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.822826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287944,-99) , 
0, 1.02827, 1, 0, 0.617795,-99) , 
3, 1.05744, 0, 0, 0.695757,-99) , 
NN(
0, 
0, 
-1, -0.83271, 0, -1, 0.17071,-99) , 
3, -0.25059, 0, 0, 0.479019,-99)    );
  // itree = 1521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55387, 0, 1, 0.81473,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372761,-99) , 
0, 0.0194397, 1, 0, 0.600264,-99) , 
3, 0.66689, 0, 0, 0.726542,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219418,-99) , 
0, -0.966214, 1, 0, 0.353401,-99) , 
NN(
0, 
0, 
-1, 0.592363, 1, -1, 0.11893,-99) , 
3, -1.09238, 0, 0, 0.241758,-99) , 
3, -0.207894, 0, 0, 0.537309,-99)    );
  // itree = 1522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.437666, 0, 1, 0.884608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431982,-99) , 
3, 1.01203, 0, 0, 0.700921,-99) , 
0, 0.672338, 1, 0, 0.760505,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260021,-99) , 
0, -0.599285, 1, 0, 0.40892,-99) , 
NN(
0, 
0, 
-1, 0.832776, 1, -1, 0.159129,-99) , 
3, -0.38455, 0, 0, 0.248655,-99) , 
3, 0.17816, 0, 0, 0.496039,-99)    );
  // itree = 1523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7717, 1, 1, 0.859334,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351539,-99) , 
0, 0.686514, 1, 0, 0.610858,-99) , 
3, 0.957669, 0, 0, 0.726806,-99) , 
NN(
0, 
0, 
-1, -0.653734, 0, -1, 0.192729,-99) , 
3, -0.160313, 0, 0, 0.488679,-99)    );
  // itree = 1524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.860088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320603,-99) , 
0, 0.789761, 1, 0, 0.578862,-99) , 
3, 1.11353, 0, 0, 0.703764,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212104,-99) , 
0, -0.991976, 1, 0, 0.341031,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.105128,-99) , 
3, -0.993962, 0, 0, 0.244941,-99) , 
3, 0.093663, 0, 0, 0.47383,-99)    );
  // itree = 1525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.878856,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37759,-99) , 
0, 0.64261, 1, 0, 0.673456,-99) , 
3, 1.16101, 0, 0, 0.748965,-99) , 
NN(
0, 
0, 
-1, -0.670644, 1, -1, 0.232438,-99) , 
3, -0.18324, 0, 0, 0.528352,-99)    );
  // itree = 1526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0194754, 1, 1, 0.802052,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400541,-99) , 
2, -0.269495, 1, 0, 0.516288,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.23628,-99) , 
3, -0.376357, 0, 0, 0.321277,-99) , 
3, 0.17816, 0, 0, 0.546756,-99)    );
  // itree = 1527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.87583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356392,-99) , 
0, 0.540099, 1, 0, 0.566888,-99) , 
3, 1.10862, 0, 0, 0.681152,-99) , 
NN(
0, 
0, 
-1, -0.787163, 0, -1, 0.203033,-99) , 
3, -0.202496, 0, 0, 0.49178,-99)    );
  // itree = 1528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.709587, 0, 1, 0.779025,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29957,-99) , 
0, -1.27242, 1, 0, 0.381016,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.100149,-99) , 
3, -1.03006, 0, 0, 0.266172,-99) , 
3, 0.307824, 0, 0, 0.482948,-99)    );
  // itree = 1529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20395, 0, 1, 0.75951,-99) , 
NN(
0, 
0, 
-1, -0.71804, 0, -1, 0.237901,-99) , 
3, -0.123397, 0, 0, 0.525752,-99)    );
  // itree = 1530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66179, 0, 1, 0.8311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29389,-99) , 
0, 0.375592, 1, 0, 0.572836,-99) , 
3, 0.764338, 0, 0, 0.720668,-99) , 
NN(
0, 
0, 
-1, -1.59854, 0, -1, 0.218239,-99) , 
3, -0.123397, 0, 0, 0.50923,-99)    );
  // itree = 1531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.141668, 1, 1, 0.748704,-99) , 
NN(
0, 
0, 
-1, -0.93003, 0, -1, 0.268552,-99) , 
3, 0.17816, 0, 0, 0.498547,-99)    );
  // itree = 1532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02343, 1, 1, 0.77269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482557,-99) , 
3, 0.319388, 0, 0, 0.704914,-99) , 
NN(
0, 
0, 
-1, -0.719025, 0, -1, 0.204002,-99) , 
3, -0.123397, 0, 0, 0.482952,-99)    );
  // itree = 1533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.244337, 0, 1, 0.714357,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199369,-99) , 
0, -1.37022, 1, 0, 0.329321,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.0833411,-99) , 
3, -1.2031, 0, 0, 0.229418,-99) , 
3, -0.210183, 0, 0, 0.512114,-99)    );
  // itree = 1534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.838004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32706,-99) , 
0, 0.824228, 1, 0, 0.601279,-99) , 
3, 1.21845, 0, 0, 0.704301,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269071,-99) , 
0, -0.765399, 1, 0, 0.41967,-99) , 
NN(
0, 
0, 
-1, -1.79825, 1, -1, 0.156919,-99) , 
3, -0.654599, 0, 0, 0.26225,-99) , 
3, 0.17816, 0, 0, 0.481708,-99)    );
  // itree = 1535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.62701, 1, 1, 0.788609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502454,-99) , 
NN(
0, 
0, 
-1, -1.13009, 1, -1, 0.186373,-99) , 
3, -0.327095, 0, 0, 0.270467,-99) , 
3, 0.20809, 0, 0, 0.505139,-99)    );
  // itree = 1536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14801, 1, 1, 0.856271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31232,-99) , 
0, 0.80635, 1, 0, 0.648475,-99) , 
3, 0.999126, 0, 0, 0.748212,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.190315,-99) , 
3, -0.123397, 0, 0, 0.505992,-99)    );
  // itree = 1537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1737, 1, 1, 0.829983,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901696,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466032,-99) , 
0, -0.0385343, 1, 0, 0.618158,-99) , 
3, 0.958234, 0, 0, 0.720384,-99) , 
NN(
0, 
0, 
-1, -0.656231, 0, -1, 0.231132,-99) , 
3, -0.160313, 0, 0, 0.503641,-99)    );
  // itree = 1538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.88373, 1, 1, 0.87478,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355897,-99) , 
0, 0.829465, 1, 0, 0.595784,-99) , 
3, 1.09392, 0, 0, 0.747276,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.898459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303935,-99) , 
0, -0.765399, 1, 0, 0.4617,-99) , 
NN(
0, 
0, 
-1, -1.22594, 0, -1, 0.191426,-99) , 
3, -0.527848, 0, 0, 0.304802,-99) , 
3, 0.28719, 0, 0, 0.50129,-99)    );
  // itree = 1539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.894755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.94638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380523,-99) , 
0, 0.852865, 1, 0, 0.637872,-99) , 
3, 1.37581, 0, 0, 0.738799,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335935,-99) , 
0, -1.44513, 1, 0, 0.403616,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.073094,-99) , 
3, -1.20689, 0, 0, 0.306477,-99) , 
3, 0.392653, 0, 0, 0.493415,-99)    );
  // itree = 1540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.893324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415149,-99) , 
0, 0.972004, 1, 0, 0.696462,-99) , 
3, 1.41976, 0, 0, 0.774862,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364419,-99) , 
0, -0.439969, 1, 0, 0.501499,-99) , 
NN(
0, 
0, 
-1, -0.942414, 0, -1, 0.153738,-99) , 
3, -0.372136, 0, 0, 0.283325,-99) , 
3, 0.254861, 0, 0, 0.503157,-99)    );
  // itree = 1541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.725244, 0, 1, 0.919049,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825749,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373899,-99) , 
3, 1.20358, 0, 0, 0.657803,-99) , 
0, 0.7846, 1, 0, 0.748403,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295928,-99) , 
1, -0.532088, 1, 0, 0.414994,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.138787,-99) , 
3, -0.568264, 0, 0, 0.278433,-99) , 
3, 0.392653, 0, 0, 0.464287,-99)    );
  // itree = 1542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51053, 0, 1, 0.818794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385117,-99) , 
0, 0.426521, 1, 0, 0.558763,-99) , 
3, 0.801028, 0, 0, 0.730403,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295143,-99) , 
0, -1.44513, 1, 0, 0.379383,-99) , 
NN(
0, 
0, 
-1, -2.05558, 0, -1, 0.0975085,-99) , 
3, -1.21, 0, 0, 0.28905,-99) , 
3, 0.17816, 0, 0, 0.498704,-99)    );
  // itree = 1543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.877809,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253621,-99) , 
0, 1.17663, 1, 0, 0.647512,-99) , 
3, 1.27254, 0, 0, 0.744054,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347044,-99) , 
0, -0.616482, 1, 0, 0.48752,-99) , 
NN(
0, 
0, 
-1, -1.44076, 1, -1, 0.212119,-99) , 
3, -0.336159, 0, 0, 0.318183,-99) , 
3, 0.301115, 0, 0, 0.494842,-99)    );
  // itree = 1544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.870048,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437651,-99) , 
0, 0.906178, 1, 0, 0.700387,-99) , 
3, 1.16137, 0, 0, 0.783505,-99) , 
NN(
0, 
0, 
-1, -0.347542, 0, -1, 0.255011,-99) , 
3, 0.180631, 0, 0, 0.508015,-99)    );
  // itree = 1545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.872128,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395617,-99) , 
0, 0.786802, 1, 0, 0.658703,-99) , 
3, 1.07875, 0, 0, 0.771835,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248614,-99) , 
0, -0.275, 1, 0, 0.427597,-99) , 
NN(
0, 
0, 
-1, -1.20667, 0, -1, 0.164105,-99) , 
3, -0.337219, 0, 0, 0.257412,-99) , 
3, 0.301115, 0, 0, 0.466512,-99)    );
  // itree = 1546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.319388, 0, 1, 0.708555,-99) , 
NN(
0, 
0, 
-1, -0.419849, 0, -1, 0.193142,-99) , 
3, -0.123397, 0, 0, 0.483297,-99)    );
  // itree = 1547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55618, 0, 1, 0.857754,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364039,-99) , 
0, 0.745236, 1, 0, 0.630467,-99) , 
3, 1.10452, 0, 0, 0.73189,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190444,-99) , 
0, -0.765399, 1, 0, 0.371782,-99) , 
NN(
0, 
0, 
-1, -2.3633, 1, -1, 0.106688,-99) , 
3, -0.938803, 0, 0, 0.255113,-99) , 
3, 0.116775, 0, 0, 0.490762,-99)    );
  // itree = 1548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.822311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363569,-99) , 
0, -0.0681195, 1, 0, 0.57999,-99) , 
3, 0.668152, 0, 0, 0.725336,-99) , 
NN(
0, 
0, 
-1, -0.702479, 0, -1, 0.241344,-99) , 
3, -0.213477, 0, 0, 0.544774,-99)    );
  // itree = 1549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0194754, 1, 1, 0.78226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468757,-99) , 
3, 0.249717, 0, 0, 0.710426,-99) , 
NN(
0, 
0, 
-1, -0.513047, 0, -1, 0.184734,-99) , 
3, -0.207894, 0, 0, 0.475866,-99)    );
  // itree = 1550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.23569, 0, 1, 0.804873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484441,-99) , 
3, 0.251814, 0, 0, 0.733427,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.226686,-99) , 
3, -0.202496, 0, 0, 0.527891,-99)    );
  // itree = 1551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.871984,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400921,-99) , 
0, 0.493857, 1, 0, 0.605945,-99) , 
3, 1.26771, 0, 0, 0.689242,-99) , 
NN(
0, 
0, 
-1, -1.03309, 0, -1, 0.222976,-99) , 
3, -0.287638, 0, 0, 0.497857,-99)    );
  // itree = 1552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.984959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353445,-99) , 
3, 1.00843, 0, 0, 0.72662,-99) , 
0, 0.709428, 1, 0, 0.784458,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209619,-99) , 
0, -0.128636, 1, 0, 0.402894,-99) , 
NN(
0, 
0, 
-1, -1.76634, 1, -1, 0.156683,-99) , 
3, -0.566981, 0, 0, 0.268978,-99) , 
3, 0.392653, 0, 0, 0.487641,-99)    );
  // itree = 1553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.836338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342417,-99) , 
0, 0.738333, 1, 0, 0.61322,-99) , 
3, 1.07541, 0, 0, 0.69712,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.185568,-99) , 
3, -0.304384, 0, 0, 0.503839,-99)    );
  // itree = 1554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.832096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332114,-99) , 
0, 0.300722, 1, 0, 0.555799,-99) , 
3, 0.929717, 0, 0, 0.664864,-99) , 
NN(
0, 
0, 
-1, -1.16324, 0, -1, 0.179248,-99) , 
3, -0.420978, 0, 0, 0.496231,-99)    );
  // itree = 1555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.039, 1, 1, 0.799086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334944,-99) , 
0, -0.0433662, 1, 0, 0.56131,-99) , 
3, 0.540529, 0, 0, 0.716738,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201864,-99) , 
0, -1.17998, 1, 0, 0.351425,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.128122,-99) , 
3, -1.01154, 0, 0, 0.253314,-99) , 
3, -0.123397, 0, 0, 0.519938,-99)    );
  // itree = 1556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.861296,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494615,-99) , 
0, 0.486742, 1, 0, 0.651658,-99) , 
3, 1.21373, 0, 0, 0.729726,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.210218,-99) , 
3, -0.123397, 0, 0, 0.506591,-99)    );
  // itree = 1557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.880239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361047,-99) , 
0, 0.979653, 1, 0, 0.663874,-99) , 
3, 1.19814, 0, 0, 0.74094,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.226235,-99) , 
3, -0.160313, 0, 0, 0.524251,-99)    );
  // itree = 1558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.62626, 0, 1, 0.727229,-99) , 
NN(
0, 
0, 
-1, -0.898791, 0, -1, 0.224084,-99) , 
3, -0.160313, 0, 0, 0.520608,-99)    );
  // itree = 1559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.878769,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315757,-99) , 
0, 1.17663, 1, 0, 0.612357,-99) , 
3, 1.21877, 0, 0, 0.735681,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280868,-99) , 
0, -0.616482, 1, 0, 0.38307,-99) , 
NN(
0, 
0, 
-1, -1.22523, 0, -1, 0.162445,-99) , 
3, -0.372136, 0, 0, 0.242481,-99) , 
3, 0.254861, 0, 0, 0.46457,-99)    );
  // itree = 1560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.15953, 1, 1, 0.844133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293172,-99) , 
0, 0.330331, 1, 0, 0.581354,-99) , 
3, 0.670287, 0, 0, 0.74,-99) , 
NN(
0, 
0, 
-1, -1.08414, 0, -1, 0.218028,-99) , 
3, -0.207894, 0, 0, 0.531336,-99)    );
  // itree = 1561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.554178, 0, 1, 0.726508,-99) , 
NN(
0, 
0, 
-1, -0.368873, 0, -1, 0.269757,-99) , 
3, 0.159996, 0, 0, 0.501989,-99)    );
  // itree = 1562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.93027, 0, 1, 0.725349,-99) , 
NN(
0, 
0, 
-1, -0.395788, 0, -1, 0.241437,-99) , 
3, 0.135748, 0, 0, 0.467509,-99)    );
  // itree = 1563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.870385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340631,-99) , 
0, 0.848875, 1, 0, 0.574826,-99) , 
3, 1.20464, 0, 0, 0.671188,-99) , 
NN(
0, 
0, 
-1, -1.13161, 0, -1, 0.208078,-99) , 
3, -0.38184, 0, 0, 0.498803,-99)    );
  // itree = 1564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82589, 0, 1, 0.831004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300043,-99) , 
0, 0.540099, 1, 0, 0.554521,-99) , 
3, 0.98281, 0, 0, 0.673953,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243738,-99) , 
0, -1.30478, 1, 0, 0.356832,-99) , 
NN(
0, 
0, 
-1, -2.61685, 1, -1, 0.146619,-99) , 
3, -1.00886, 0, 0, 0.251249,-99) , 
3, -0.123397, 0, 0, 0.506648,-99)    );
  // itree = 1565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63009, 0, 1, 0.778065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229799,-99) , 
0, 0.151579, 1, 0, 0.511388,-99) , 
3, 0.526823, 0, 0, 0.665084,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.219859,-99) , 
3, -0.38184, 0, 0, 0.513614,-99)    );
  // itree = 1566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.71735, 1, 1, 0.879548,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.907979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412821,-99) , 
0, 0.912588, 1, 0, 0.663213,-99) , 
3, 1.37581, 0, 0, 0.7585,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297885,-99) , 
3, -0.946089, 0, 0, 0.553815,-99) , 
NN(
0, 
0, 
-1, -0.568264, 0, -1, 0.238123,-99) , 
1, -0.711563, 1, 0, 0.303521,-99) , 
3, 0.392653, 0, 0, 0.49278,-99)    );
  // itree = 1567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.873691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387655,-99) , 
0, 0.0101547, 1, 0, 0.527024,-99) , 
3, 1.07643, 0, 0, 0.656804,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.163157,-99) , 
3, -0.304384, 0, 0, 0.473144,-99)    );
  // itree = 1568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06599, 1, 1, 0.78093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468062,-99) , 
3, 0.322371, 0, 0, 0.702081,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.180984,-99) , 
3, -0.123397, 0, 0, 0.472871,-99)    );
  // itree = 1569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.865067,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363241,-99) , 
0, 0.972702, 1, 0, 0.662112,-99) , 
3, 1.18131, 0, 0, 0.765361,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201513,-99) , 
0, -0.143589, 1, 0, 0.392446,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.137258,-99) , 
3, -0.886371, 0, 0, 0.289241,-99) , 
3, 0.392653, 0, 0, 0.495369,-99)    );
  // itree = 1570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.893096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303079,-99) , 
0, 1.0116, 1, 0, 0.592205,-99) , 
3, 1.33028, 0, 0, 0.685379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176392,-99) , 
0, -1.16724, 1, 0, 0.303046,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0830807,-99) , 
3, -1.07684, 0, 0, 0.206544,-99) , 
3, -0.202496, 0, 0, 0.495036,-99)    );
  // itree = 1571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43096, 0, 1, 0.691119,-99) , 
NN(
0, 
0, 
-1, -0.8815, 0, -1, 0.177711,-99) , 
3, -0.38184, 0, 0, 0.500718,-99)    );
  // itree = 1572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60765, 0, 1, 0.722089,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379065,-99) , 
0, -0.616482, 1, 0, 0.494876,-99) , 
NN(
0, 
0, 
-1, -1.05448, 0, -1, 0.16106,-99) , 
3, -0.328597, 0, 0, 0.261184,-99) , 
3, 0.20809, 0, 0, 0.462684,-99)    );
  // itree = 1573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5443, 1, 1, 0.884554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446503,-99) , 
0, 1.74488, 1, 0, 0.711752,-99) , 
3, 1.60792, 0, 0, 0.758449,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288639,-99) , 
1, 0.132644, 1, 0, 0.44943,-99) , 
NN(
0, 
0, 
-1, -1.22769, 0, -1, 0.201608,-99) , 
3, -0.378316, 0, 0, 0.282375,-99) , 
3, 0.254861, 0, 0, 0.499738,-99)    );
  // itree = 1574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31998, 0, 1, 0.75821,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360744,-99) , 
3, 0.0213349, 0, 0, 0.693627,-99) , 
NN(
0, 
0, 
-1, -0.707631, 0, -1, 0.17556,-99) , 
3, -0.210183, 0, 0, 0.468069,-99)    );
  // itree = 1575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28718, 1, 1, 0.820338,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34193,-99) , 
0, 0.314661, 1, 0, 0.580442,-99) , 
3, 0.781588, 0, 0, 0.729164,-99) , 
NN(
0, 
0, 
-1, -0.360327, 0, -1, 0.25126,-99) , 
3, 0.178444, 0, 0, 0.479654,-99)    );
  // itree = 1576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42098, 1, 1, 0.813234,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416141,-99) , 
0, 0.265001, 1, 0, 0.597751,-99) , 
3, 0.800667, 0, 0, 0.728444,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316886,-99) , 
0, -1.51282, 1, 0, 0.387931,-99) , 
NN(
0, 
0, 
-1, -2.74077, 1, -1, 0.100564,-99) , 
3, -1.20546, 0, 0, 0.298417,-99) , 
3, 0.17816, 0, 0, 0.506699,-99)    );
  // itree = 1577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.501506, 0, 1, 0.917777,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419721,-99) , 
3, 1.01203, 0, 0, 0.701589,-99) , 
0, 0.709428, 1, 0, 0.766488,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281672,-99) , 
0, -0.616482, 1, 0, 0.397313,-99) , 
NN(
0, 
0, 
-1, -1.43669, 1, -1, 0.17277,-99) , 
3, -0.385641, 0, 0, 0.258152,-99) , 
3, 0.17816, 0, 0, 0.488786,-99)    );
  // itree = 1578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63168, 1, 1, 0.875139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299528,-99) , 
0, 1.00308, 1, 0, 0.657493,-99) , 
3, 1.11294, 0, 0, 0.762186,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185138,-99) , 
0, -0.431695, 1, 0, 0.371052,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0626019,-99) , 
3, -1.03294, 0, 0, 0.262189,-99) , 
3, 0.307824, 0, 0, 0.483525,-99)    );
  // itree = 1579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42967, 0, 1, 0.721746,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.237424,-99) , 
3, -0.123397, 0, 0, 0.520432,-99)    );
  // itree = 1580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25225, 1, 1, 0.87081,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358285,-99) , 
0, 0.786802, 1, 0, 0.643744,-99) , 
3, 1.07833, 0, 0, 0.758853,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303219,-99) , 
1, -0.323641, 1, 0, 0.45645,-99) , 
NN(
0, 
0, 
-1, -1.25437, 0, -1, 0.196333,-99) , 
3, -0.553771, 0, 0, 0.304787,-99) , 
3, 0.262941, 0, 0, 0.504392,-99)    );
  // itree = 1581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5625, 1, 1, 0.856091,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287786,-99) , 
0, 0.923985, 1, 0, 0.565837,-99) , 
3, 1.10245, 0, 0, 0.671273,-99) , 
NN(
0, 
0, 
-1, -0.805843, 0, -1, 0.210629,-99) , 
3, -0.207894, 0, 0, 0.485407,-99)    );
  // itree = 1582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00058, 0, 1, 0.76718,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666853,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306225,-99) , 
0, -1.39151, 1, 0, 0.378366,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.0790563,-99) , 
3, -1.12137, 0, 0, 0.268144,-99) , 
3, 0.202693, 0, 0, 0.500715,-99)    );
  // itree = 1583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.254496, 1, 1, 0.76292,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.225056,-99) , 
3, -0.123397, 0, 0, 0.542374,-99)    );
  // itree = 1584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38501, 1, 1, 0.79549,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250329,-99) , 
0, 0.338851, 1, 0, 0.506239,-99) , 
3, 0.526823, 0, 0, 0.668671,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.178473,-99) , 
3, -0.38184, 0, 0, 0.488243,-99)    );
  // itree = 1585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30899, 0, 1, 0.788289,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314562,-99) , 
0, 0.00230313, 1, 0, 0.526695,-99) , 
3, 0.552263, 0, 0, 0.691763,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.227219,-99) , 
3, -0.123397, 0, 0, 0.50051,-99)    );
  // itree = 1586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.828673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329641,-99) , 
0, 0.540099, 1, 0, 0.564349,-99) , 
3, 0.843146, 0, 0, 0.71496,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247565,-99) , 
1, -0.505987, 1, 0, 0.351056,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0892237,-99) , 
3, -1.0546, 0, 0, 0.222569,-99) , 
3, 0.0354976, 0, 0, 0.479317,-99)    );
  // itree = 1587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.63751, 1, 1, 0.856819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316805,-99) , 
0, 0.774542, 1, 0, 0.578487,-99) , 
3, 1.00736, 0, 0, 0.726201,-99) , 
NN(
0, 
0, 
-1, -0.93003, 0, -1, 0.227352,-99) , 
3, 0.17816, 0, 0, 0.47401,-99)    );
  // itree = 1588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.23432, 0, 1, 0.755686,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197861,-99) , 
1, -0.373917, 1, 0, 0.31894,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.072,-99) , 
3, -1.05666, 0, 0, 0.209749,-99) , 
3, 0.017859, 0, 0, 0.508308,-99)    );
  // itree = 1589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.861171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491976,-99) , 
0, -0.0215873, 1, 0, 0.626595,-99) , 
3, 1.16406, 0, 0, 0.710625,-99) , 
NN(
0, 
0, 
-1, -1.06498, 0, -1, 0.205336,-99) , 
3, -0.120098, 0, 0, 0.496106,-99)    );
  // itree = 1590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40435, 1, 1, 0.864156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420576,-99) , 
0, 0.767537, 1, 0, 0.675961,-99) , 
3, 1.1349, 0, 0, 0.777268,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318891,-99) , 
0, -1.21855, 1, 0, 0.416376,-99) , 
NN(
0, 
0, 
-1, -2.4918, 1, -1, 0.10615,-99) , 
3, -1.00762, 0, 0, 0.295543,-99) , 
3, 0.325234, 0, 0, 0.506661,-99)    );
  // itree = 1591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.987005, 1, 1, 0.797742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384046,-99) , 
0, 0.0982501, 1, 0, 0.548341,-99) , 
3, 0.593979, 0, 0, 0.723683,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312896,-99) , 
0, -1.43519, 1, 0, 0.402419,-99) , 
NN(
0, 
0, 
-1, -2.92486, 1, -1, 0.099347,-99) , 
3, -1.20793, 0, 0, 0.301936,-99) , 
3, 0.17816, 0, 0, 0.524048,-99)    );
  // itree = 1592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.879713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216431,-99) , 
0, 1.06604, 1, 0, 0.644934,-99) , 
3, 1.17884, 0, 0, 0.747536,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280451,-99) , 
0, -0.701151, 1, 0, 0.443644,-99) , 
NN(
0, 
0, 
-1, -0.477538, 1, -1, 0.153309,-99) , 
3, -0.357516, 0, 0, 0.241568,-99) , 
3, 0.178444, 0, 0, 0.471452,-99)    );
  // itree = 1593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.856504,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461884,-99) , 
0, 0.298494, 1, 0, 0.613065,-99) , 
3, 1.04481, 0, 0, 0.71435,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257179,-99) , 
0, -1.31319, 1, 0, 0.345274,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.0975668,-99) , 
3, -1.04328, 0, 0, 0.250205,-99) , 
3, 0.0354976, 0, 0, 0.486433,-99)    );
  // itree = 1594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.879762, 0, 1, 0.912284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344032,-99) , 
3, 1.36576, 0, 0, 0.666478,-99) , 
0, 1.09855, 1, 0, 0.768168,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569602,-99) , 
NN(
0, 
0, 
-1, -1.2136, 0, -1, 0.255055,-99) , 
3, -0.0116291, 0, 0, 0.305794,-99) , 
3, 0.306962, 0, 0, 0.504434,-99)    );
  // itree = 1595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46924, 1, 1, 0.870985,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34035,-99) , 
0, 0.587889, 1, 0, 0.565238,-99) , 
3, 1.09115, 0, 0, 0.684468,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.190895,-99) , 
3, -0.304384, 0, 0, 0.493856,-99)    );
  // itree = 1596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.143069, 1, 1, 0.863669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30712,-99) , 
0, 0.923985, 1, 0, 0.638903,-99) , 
3, 1.16101, 0, 0, 0.72398,-99) , 
NN(
0, 
0, 
-1, -1.17915, 0, -1, 0.183609,-99) , 
3, -0.18324, 0, 0, 0.492752,-99)    );
  // itree = 1597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.800667, 0, 1, 0.782255,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287783,-99) , 
0, -0.75153, 1, 0, 0.436481,-99) , 
NN(
0, 
0, 
-1, -1.84219, 0, -1, 0.177588,-99) , 
3, -0.654599, 0, 0, 0.296073,-99) , 
3, 0.17816, 0, 0, 0.540105,-99)    );
  // itree = 1598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.21483, 1, 1, 0.857587,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316437,-99) , 
0, 1.27206, 1, 0, 0.642119,-99) , 
3, 1.4235, 0, 0, 0.716216,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292468,-99) , 
0, -1.51282, 1, 0, 0.381286,-99) , 
NN(
0, 
0, 
-1, 0.00613183, 1, -1, 0.0776689,-99) , 
3, -1.20793, 0, 0, 0.296712,-99) , 
3, 0.17816, 0, 0, 0.488677,-99)    );
  // itree = 1599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.85102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336221,-99) , 
0, 0.854666, 1, 0, 0.584534,-99) , 
3, 1.2063, 0, 0, 0.671368,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168376,-99) , 
0, -1.19072, 1, 0, 0.289934,-99) , 
NN(
0, 
0, 
-1, -0.0174477, 1, -1, 0.0934592,-99) , 
3, -1.00886, 0, 0, 0.20305,-99) , 
3, -0.123397, 0, 0, 0.461472,-99)    );
  // itree = 1600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.235551, 0, 1, 0.727564,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.222139,-99) , 
3, -0.202496, 0, 0, 0.511628,-99)    );
  // itree = 1601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.44615, 0, 1, 0.70194,-99) , 
NN(
0, 
0, 
-1, -1.8784, 0, -1, 0.183419,-99) , 
3, -0.38184, 0, 0, 0.533547,-99)    );
  // itree = 1602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.89653, 1, 1, 0.851038,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430663,-99) , 
0, 0.433737, 1, 0, 0.627971,-99) , 
3, 1.12392, 0, 0, 0.732203,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255898,-99) , 
0, -1.21855, 1, 0, 0.360682,-99) , 
NN(
0, 
0, 
-1, -1.50598, 1, -1, 0.127645,-99) , 
3, -0.990852, 0, 0, 0.276538,-99) , 
3, 0.0990605, 0, 0, 0.513317,-99)    );
  // itree = 1603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.807486,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3688,-99) , 
0, 0.0136911, 1, 0, 0.551267,-99) , 
3, 0.694518, 0, 0, 0.686881,-99) , 
NN(
0, 
0, 
-1, -0.955363, 0, -1, 0.221451,-99) , 
3, -0.210183, 0, 0, 0.501121,-99)    );
  // itree = 1604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58845, 1, 1, 0.857587,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445714,-99) , 
0, 0.767381, 1, 0, 0.670411,-99) , 
3, 1.21845, 0, 0, 0.746204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301279,-99) , 
0, -0.661533, 1, 0, 0.471775,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.209816,-99) , 
3, -0.376357, 0, 0, 0.302929,-99) , 
3, 0.17816, 0, 0, 0.536756,-99)    );
  // itree = 1605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0194754, 1, 1, 0.772268,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30907,-99) , 
0, -0.416261, 1, 0, 0.44215,-99) , 
NN(
0, 
0, 
-1, -0.989752, 0, -1, 0.174756,-99) , 
3, -0.427286, 0, 0, 0.279181,-99) , 
3, 0.197611, 0, 0, 0.509367,-99)    );
  // itree = 1606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.879516,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43094,-99) , 
0, 0.854666, 1, 0, 0.67906,-99) , 
3, 1.33028, 0, 0, 0.740359,-99) , 
NN(
0, 
0, 
-1, -0.494716, 0, -1, 0.200427,-99) , 
3, -0.202496, 0, 0, 0.511214,-99)    );
  // itree = 1607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.873606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495088,-99) , 
0, 0.454615, 1, 0, 0.64263,-99) , 
3, 1.2469, 0, 0, 0.733218,-99) , 
NN(
0, 
0, 
-1, -0.518397, 0, -1, 0.211127,-99) , 
3, 0.0319938, 0, 0, 0.476742,-99)    );
  // itree = 1608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47132, 0, 1, 0.709913,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325835,-99) , 
3, -0.178554, 0, 0, 0.418997,-99) , 
NN(
0, 
0, 
-1, -1.03032, 0, -1, 0.156598,-99) , 
3, -0.473813, 0, 0, 0.253214,-99) , 
3, 0.145523, 0, 0, 0.484138,-99)    );
  // itree = 1609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.442779, 1, 1, 0.903452,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854926,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373464,-99) , 
3, 1.21388, 0, 0, 0.65869,-99) , 
0, 0.715889, 1, 0, 0.746613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654091,-99) , 
NN(
0, 
0, 
-1, -1.10297, 0, -1, 0.229676,-99) , 
3, -0.0835608, 0, 0, 0.292668,-99) , 
3, 0.183842, 0, 0, 0.495123,-99)    );
  // itree = 1610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.795446,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305176,-99) , 
0, 0.429347, 1, 0, 0.62122,-99) , 
3, 0.761669, 0, 0, 0.723159,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211885,-99) , 
0, -1.21605, 1, 0, 0.344871,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.0910158,-99) , 
3, -1.01154, 0, 0, 0.227052,-99) , 
3, -0.123397, 0, 0, 0.497146,-99)    );
  // itree = 1611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.412701, 1, 1, 0.889771,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4179,-99) , 
3, 1.4111, 0, 0, 0.702487,-99) , 
0, 1.1785, 1, 0, 0.784887,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439764,-99) , 
0, -0.676329, 1, 0, 0.524302,-99) , 
NN(
0, 
0, 
-1, -1.19134, 0, -1, 0.174669,-99) , 
3, -0.329146, 0, 0, 0.279698,-99) , 
3, 0.301115, 0, 0, 0.488425,-99)    );
  // itree = 1612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.6221, 1, 1, 0.849777,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385325,-99) , 
0, 0.84413, 1, 0, 0.630476,-99) , 
3, 1.18404, 0, 0, 0.725787,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585151,-99) , 
NN(
0, 
0, 
-1, -1.10929, 0, -1, 0.225981,-99) , 
3, -0.0835608, 0, 0, 0.273536,-99) , 
3, 0.183842, 0, 0, 0.482708,-99)    );
  // itree = 1613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.853176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464581,-99) , 
0, 0.492106, 1, 0, 0.617424,-99) , 
3, 1.12671, 0, 0, 0.71694,-99) , 
NN(
0, 
0, 
-1, -0.447144, 0, -1, 0.250793,-99) , 
3, 0.0990605, 0, 0, 0.495915,-99)    );
  // itree = 1614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.877964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332803,-99) , 
0, 0.697897, 1, 0, 0.66762,-99) , 
3, 1.12833, 0, 0, 0.769798,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246521,-99) , 
0, -1.24008, 1, 0, 0.345081,-99) , 
NN(
0, 
0, 
-1, -2.56954, 1, -1, 0.097645,-99) , 
3, -0.993962, 0, 0, 0.233255,-99) , 
3, 0.093663, 0, 0, 0.486003,-99)    );
  // itree = 1615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.871892,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421687,-99) , 
0, 0.811659, 1, 0, 0.588835,-99) , 
3, 1.30662, 0, 0, 0.680281,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.209284,-99) , 
3, -0.304384, 0, 0, 0.500775,-99)    );
  // itree = 1616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.817607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388382,-99) , 
0, 0.446311, 1, 0, 0.600796,-99) , 
3, 0.879362, 0, 0, 0.727257,-99) , 
NN(
0, 
0, 
-1, -0.960427, 0, -1, 0.226083,-99) , 
3, 0.0923834, 0, 0, 0.481227,-99)    );
  // itree = 1617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5287, 1, 1, 0.859843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326145,-99) , 
0, 0.931454, 1, 0, 0.648652,-99) , 
3, 1.00736, 0, 0, 0.755023,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303022,-99) , 
0, -0.808923, 1, 0, 0.469957,-99) , 
NN(
0, 
0, 
-1, -1.12717, 0, -1, 0.18627,-99) , 
3, -0.379167, 0, 0, 0.289277,-99) , 
3, 0.17816, 0, 0, 0.5215,-99)    );
  // itree = 1618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.101, 1, 1, 0.836553,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346055,-99) , 
0, 0.887495, 1, 0, 0.601603,-99) , 
3, 1.05358, 0, 0, 0.696058,-99) , 
NN(
0, 
0, 
-1, -1.12289, 0, -1, 0.210244,-99) , 
3, -0.25059, 0, 0, 0.518322,-99)    );
  // itree = 1619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.83233, 1, 1, 0.842731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262522,-99) , 
0, 0.679936, 1, 0, 0.594396,-99) , 
3, 0.99222, 0, 0, 0.692267,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.158439,-99) , 
3, -0.376892, 0, 0, 0.489072,-99)    );
  // itree = 1620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0924542, 1, 1, 0.842545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374189,-99) , 
0, 0.288041, 1, 0, 0.581501,-99) , 
3, 0.800667, 0, 0, 0.753566,-99) , 
NN(
0, 
0, 
-1, -0.932655, 0, -1, 0.255087,-99) , 
3, 0.17816, 0, 0, 0.481444,-99)    );
  // itree = 1621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.784758,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273976,-99) , 
0, 0.0764031, 1, 0, 0.500975,-99) , 
3, 0.615993, 0, 0, 0.664021,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.17958,-99) , 
3, -0.304384, 0, 0, 0.475133,-99)    );
  // itree = 1622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.682, 1, 1, 0.854189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371492,-99) , 
0, 0.280002, 1, 0, 0.6121,-99) , 
3, 0.816356, 0, 0, 0.764991,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57184,-99) , 
NN(
0, 
0, 
-1, -1.41328, 1, -1, 0.233037,-99) , 
3, -0.0808381, 0, 0, 0.290011,-99) , 
3, 0.238103, 0, 0, 0.507689,-99)    );
  // itree = 1623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.956492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487761,-99) , 
3, 1.20439, 0, 0, 0.694509,-99) , 
0, 0.392707, 1, 0, 0.749691,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314973,-99) , 
0, -1.18593, 1, 0, 0.407282,-99) , 
NN(
0, 
0, 
-1, -0.0154624, 1, -1, 0.0987278,-99) , 
3, -1.0148, 0, 0, 0.294254,-99) , 
3, 0.238103, 0, 0, 0.503321,-99)    );
  // itree = 1624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.700038, 0, 1, 0.830836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406429,-99) , 
3, 1.61436, 0, 0, 0.655955,-99) , 
0, 1.83273, 1, 0, 0.77589,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29491,-99) , 
0, -0.781662, 1, 0, 0.457549,-99) , 
NN(
0, 
0, 
-1, -1.13528, 0, -1, 0.13794,-99) , 
3, -0.659699, 0, 0, 0.263276,-99) , 
3, 0.17816, 0, 0, 0.515449,-99)    );
  // itree = 1625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.818005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269622,-99) , 
0, 0.579058, 1, 0, 0.549873,-99) , 
3, 0.851387, 0, 0, 0.680304,-99) , 
NN(
0, 
0, 
-1, -0.544115, 0, -1, 0.193281,-99) , 
3, -0.25059, 0, 0, 0.467692,-99)    );
  // itree = 1626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.76461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350987,-99) , 
0, 0.0139227, 1, 0, 0.536039,-99) , 
3, 0.504376, 0, 0, 0.666016,-99) , 
NN(
0, 
0, 
-1, -1.24634, 0, -1, 0.16886,-99) , 
3, -0.711955, 0, 0, 0.539229,-99)    );
  // itree = 1627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.902004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266723,-99) , 
0, 0.887495, 1, 0, 0.567177,-99) , 
3, 1.13334, 0, 0, 0.691641,-99) , 
NN(
0, 
0, 
-1, -1.13649, 0, -1, 0.220684,-99) , 
3, -0.179298, 0, 0, 0.504197,-99)    );
  // itree = 1628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.814634,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317009,-99) , 
1, 0.564035, 1, 0, 0.512437,-99) , 
3, 0.52978, 0, 0, 0.676114,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.230951,-99) , 
3, -0.376892, 0, 0, 0.52441,-99)    );
  // itree = 1629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.00131617, 1, 1, 0.78183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390331,-99) , 
0, -0.424041, 1, 0, 0.519042,-99) , 
NN(
0, 
0, 
-1, -1.18692, 0, -1, 0.186348,-99) , 
3, -0.329808, 0, 0, 0.307503,-99) , 
3, 0.301115, 0, 0, 0.5089,-99)    );
  // itree = 1630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.865732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273682,-99) , 
0, 0.887495, 1, 0, 0.578173,-99) , 
3, 1.08642, 0, 0, 0.692198,-99) , 
NN(
0, 
0, 
-1, -0.975983, 0, -1, 0.206258,-99) , 
3, -0.237768, 0, 0, 0.506087,-99)    );
  // itree = 1631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.81372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301888,-99) , 
0, 0.733197, 1, 0, 0.60757,-99) , 
3, 0.98281, 0, 0, 0.699391,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.204795,-99) , 
3, -0.123397, 0, 0, 0.496038,-99)    );
  // itree = 1632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62447, 0, 1, 0.86643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405309,-99) , 
0, 0.964063, 1, 0, 0.651953,-99) , 
3, 1.32758, 0, 0, 0.726818,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237705,-99) , 
0, -1.21605, 1, 0, 0.359534,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.101024,-99) , 
3, -0.990852, 0, 0, 0.248941,-99) , 
3, 0.0990605, 0, 0, 0.495199,-99)    );
  // itree = 1633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01395, 0, 1, 0.874138,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469771,-99) , 
3, 1.42058, 0, 0, 0.732592,-99) , 
0, 1.50474, 1, 0, 0.806163,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238209,-99) , 
0, -0.0856679, 1, 0, 0.463219,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.149828,-99) , 
3, -0.568255, 0, 0, 0.291005,-99) , 
3, 0.392653, 0, 0, 0.504213,-99)    );
  // itree = 1634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66626, 0, 1, 0.777227,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357376,-99) , 
0, -0.85877, 1, 0, 0.47023,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.113512,-99) , 
3, -0.957285, 0, 0, 0.327147,-99) , 
3, 0.306962, 0, 0, 0.529949,-99)    );
  // itree = 1635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.890923,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41291,-99) , 
0, 0.809818, 1, 0, 0.626371,-99) , 
3, 1.19336, 0, 0, 0.732431,-99) , 
NN(
0, 
0, 
-1, -1.14418, 0, -1, 0.199091,-99) , 
3, -0.160313, 0, 0, 0.498775,-99)    );
  // itree = 1636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48521, 0, 1, 0.713249,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241758,-99) , 
0, -1.01188, 1, 0, 0.384717,-99) , 
3, 0.0248623, 0, 0, 0.616544,-99) , 
NN(
0, 
0, 
-1, -1.78005, 0, -1, 0.129042,-99) , 
3, -0.711955, 0, 0, 0.482007,-99)    );
  // itree = 1637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.51583, 1, 1, 0.860712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456521,-99) , 
0, 0.210411, 1, 0, 0.643594,-99) , 
3, 1.12023, 0, 0, 0.736484,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173812,-99) , 
0, -1.18308, 1, 0, 0.312783,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.13104,-99) , 
3, -1.07815, 0, 0, 0.232766,-99) , 
3, -0.202496, 0, 0, 0.521701,-99)    );
  // itree = 1638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.468566, 0, 1, 0.861707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432924,-99) , 
3, 1.2923, 0, 0, 0.680935,-99) , 
0, 0.980206, 1, 0, 0.770631,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609265,-99) , 
NN(
0, 
0, 
-1, -1.16572, 0, -1, 0.187547,-99) , 
3, -0.176751, 0, 0, 0.252263,-99) , 
3, 0.10715, 0, 0, 0.517007,-99)    );
  // itree = 1639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.42073, 0, 1, 0.752956,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202891,-99) , 
0, -0.866905, 1, 0, 0.374602,-99) , 
NN(
0, 
0, 
-1, -1.60534, 0, -1, 0.118827,-99) , 
3, -0.937386, 0, 0, 0.263866,-99) , 
3, 0.17816, 0, 0, 0.507406,-99)    );
  // itree = 1640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.26929, 1, 1, 0.896467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344687,-99) , 
0, 0.919886, 1, 0, 0.618368,-99) , 
3, 1.2063, 0, 0, 0.716969,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.181898,-99) , 
3, -0.123397, 0, 0, 0.479508,-99)    );
  // itree = 1641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.778234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353873,-99) , 
1, -0.654311, 1, 0, 0.456245,-99) , 
NN(
0, 
0, 
-1, -0.257029, 1, -1, 0.127058,-99) , 
3, -0.811011, 0, 0, 0.297384,-99) , 
3, 0.246134, 0, 0, 0.506592,-99)    );
  // itree = 1642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93898, 1, 1, 0.820688,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341987,-99) , 
0, 0.168185, 1, 0, 0.607951,-99) , 
3, 0.543354, 0, 0, 0.740657,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.17559,-99) , 
3, -0.123397, 0, 0, 0.486157,-99)    );
  // itree = 1643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.876815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290688,-99) , 
0, 1.0116, 1, 0, 0.565743,-99) , 
3, 1.33266, 0, 0, 0.655291,-99) , 
NN(
0, 
0, 
-1, -1.45163, 0, -1, 0.136471,-99) , 
3, -0.639447, 0, 0, 0.502372,-99)    );
  // itree = 1644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.850873,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478775,-99) , 
2, 0.318282, 1, 0, 0.609782,-99) , 
3, 1.30512, 0, 0, 0.68636,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.185262,-99) , 
3, -0.304384, 0, 0, 0.493005,-99)    );
  // itree = 1645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13026, 0, 1, 0.783314,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327762,-99) , 
0, -0.268178, 1, 0, 0.517711,-99) , 
3, 0.325599, 0, 0, 0.709893,-99) , 
NN(
0, 
0, 
-1, -0.720075, 0, -1, 0.194776,-99) , 
3, -0.123397, 0, 0, 0.491715,-99)    );
  // itree = 1646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.39136, 1, 1, 0.734928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178074,-99) , 
0, -1.3018, 1, 0, 0.320981,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.0892438,-99) , 
3, -1.00886, 0, 0, 0.211817,-99) , 
3, -0.123397, 0, 0, 0.481047,-99)    );
  // itree = 1647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.821879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369419,-99) , 
0, 0.0490839, 1, 0, 0.614944,-99) , 
3, 0.543354, 0, 0, 0.74873,-99) , 
NN(
0, 
0, 
-1, -0.419174, 0, -1, 0.21776,-99) , 
3, -0.123397, 0, 0, 0.52806,-99)    );
  // itree = 1648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41961, 1, 1, 0.894474,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360713,-99) , 
0, 0.997828, 1, 0, 0.670138,-99) , 
3, 1.43422, 0, 0, 0.735602,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.217387,-99) , 
3, -0.123397, 0, 0, 0.516937,-99)    );
  // itree = 1649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84616, 1, 1, 0.864642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258049,-99) , 
0, 0.738333, 1, 0, 0.610886,-99) , 
3, 0.993552, 0, 0, 0.711863,-99) , 
NN(
0, 
0, 
-1, -1.35886, 1, -1, 0.172377,-99) , 
3, -0.376892, 0, 0, 0.516894,-99)    );
  // itree = 1650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.879691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316761,-99) , 
0, 1.36219, 1, 0, 0.671375,-99) , 
3, 1.31846, 0, 0, 0.743887,-99) , 
NN(
0, 
0, 
-1, -1.55072, 0, -1, 0.279753,-99) , 
3, 0.093663, 0, 0, 0.519746,-99)    );
  // itree = 1651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.862718,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282434,-99) , 
0, 0.753813, 1, 0, 0.5718,-99) , 
3, 1.01137, 0, 0, 0.729963,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252169,-99) , 
0, -0.683741, 1, 0, 0.414431,-99) , 
NN(
0, 
0, 
-1, -2.54298, 1, -1, 0.117087,-99) , 
3, -0.702968, 0, 0, 0.2557,-99) , 
3, 0.238103, 0, 0, 0.478685,-99)    );
  // itree = 1652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42623, 1, 1, 0.819102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331132,-99) , 
0, -0.00427319, 1, 0, 0.578583,-99) , 
3, 0.543354, 0, 0, 0.734816,-99) , 
NN(
0, 
0, 
-1, -1.01967, 0, -1, 0.240261,-99) , 
3, -0.123397, 0, 0, 0.550387,-99)    );
  // itree = 1653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.70427, 1, 1, 0.832943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28543,-99) , 
0, 0.852865, 1, 0, 0.582048,-99) , 
3, 1.00736, 0, 0, 0.708836,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300137,-99) , 
1, -0.302531, 1, 0, 0.425656,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.159591,-99) , 
3, -0.379167, 0, 0, 0.24566,-99) , 
3, 0.17816, 0, 0, 0.468765,-99)    );
  // itree = 1654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.34883, 0, 1, 0.846104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394777,-99) , 
0, 0.722702, 1, 0, 0.665407,-99) , 
3, 1.00736, 0, 0, 0.758928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304819,-99) , 
0, -1.25537, 1, 0, 0.388933,-99) , 
NN(
0, 
0, 
-1, -2.75488, 1, -1, 0.106893,-99) , 
3, -0.927516, 0, 0, 0.264162,-99) , 
3, 0.17816, 0, 0, 0.503187,-99)    );
  // itree = 1655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.854576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383758,-99) , 
0, 0.210411, 1, 0, 0.566011,-99) , 
3, 0.985321, 0, 0, 0.689685,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.194065,-99) , 
3, -0.123397, 0, 0, 0.488219,-99)    );
  // itree = 1656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.840841,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386213,-99) , 
0, 0.579835, 1, 0, 0.638608,-99) , 
3, 1.00736, 0, 0, 0.745213,-99) , 
NN(
0, 
0, 
-1, -0.93003, 0, -1, 0.267107,-99) , 
3, 0.17816, 0, 0, 0.499446,-99)    );
  // itree = 1657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.871315,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312575,-99) , 
0, 0.858007, 1, 0, 0.628182,-99) , 
3, 1.14627, 0, 0, 0.721679,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178881,-99) , 
0, -1.30493, 1, 0, 0.353263,-99) , 
NN(
0, 
0, 
-1, -1.80628, 0, -1, 0.126527,-99) , 
3, -0.955363, 0, 0, 0.243967,-99) , 
3, -0.210183, 0, 0, 0.524263,-99)    );
  // itree = 1658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.306083, 1, 1, 0.78304,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312543,-99) , 
0, -0.831231, 1, 0, 0.486805,-99) , 
NN(
0, 
0, 
-1, -1.9058, 1, -1, 0.208326,-99) , 
3, -0.541933, 0, 0, 0.322854,-99) , 
3, 0.246134, 0, 0, 0.550499,-99)    );
  // itree = 1659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.824715, 0, 1, 0.755468,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296185,-99) , 
0, -0.975634, 1, 0, 0.439084,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.143205,-99) , 
3, -0.698308, 0, 0, 0.28324,-99) , 
3, 0.238103, 0, 0, 0.491139,-99)    );
  // itree = 1660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.518306, 0, 1, 0.735208,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243989,-99) , 
0, -0.773268, 1, 0, 0.380591,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.146786,-99) , 
3, -0.720436, 0, 0, 0.250733,-99) , 
3, 0.0990605, 0, 0, 0.482127,-99)    );
  // itree = 1661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.409305, 0, 1, 0.86465,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41467,-99) , 
3, 1.32987, 0, 0, 0.683353,-99) , 
0, 1.10708, 1, 0, 0.763837,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240841,-99) , 
3, -0.41104, 0, 0, 0.399392,-99) , 
NN(
0, 
0, 
-1, 0.0437702, 1, -1, 0.10458,-99) , 
3, -0.95623, 0, 0, 0.277265,-99) , 
3, 0.306962, 0, 0, 0.485583,-99)    );
  // itree = 1662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.580534, 0, 1, 0.866313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.852253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475689,-99) , 
3, 1.42786, 0, 0, 0.697267,-99) , 
0, 1.15389, 1, 0, 0.775057,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307884,-99) , 
0, -1.39151, 1, 0, 0.379906,-99) , 
NN(
0, 
0, 
-1, -2.57892, 1, -1, 0.103031,-99) , 
3, -1.11797, 0, 0, 0.272674,-99) , 
3, 0.20809, 0, 0, 0.510183,-99)    );
  // itree = 1663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.52507, 1, 1, 0.895514,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472822,-99) , 
0, 1.09344, 1, 0, 0.709751,-99) , 
3, 1.43094, 0, 0, 0.776451,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308745,-99) , 
0, -0.804863, 1, 0, 0.468397,-99) , 
NN(
0, 
0, 
-1, -1.23361, 0, -1, 0.17805,-99) , 
3, -0.541933, 0, 0, 0.304556,-99) , 
3, 0.246134, 0, 0, 0.522648,-99)    );
  // itree = 1664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48356, 1, 1, 0.840418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.908187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479658,-99) , 
0, -0.0215873, 1, 0, 0.625278,-99) , 
3, 0.985321, 0, 0, 0.723278,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170491,-99) , 
3, -1.01967, 0, 0, 0.329638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132649,-99) , 
0, -1.0898, 1, 0, 0.250393,-99) , 
3, -0.123397, 0, 0, 0.526622,-99)    );
  // itree = 1665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.702317, 1, 1, 0.828921,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658093,-99) , 
NN(
0, 
0, 
-1, -1.21206, 0, -1, 0.252511,-99) , 
3, -0.0103882, 0, 0, 0.318589,-99) , 
3, 0.306962, 0, 0, 0.545709,-99)    );
  // itree = 1666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.30601, 1, 1, 0.82535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239385,-99) , 
0, 0.84413, 1, 0, 0.629404,-99) , 
3, 1.00736, 0, 0, 0.72965,-99) , 
NN(
0, 
0, 
-1, -0.103735, 0, -1, 0.2257,-99) , 
3, 0.17816, 0, 0, 0.462297,-99)    );
  // itree = 1667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.95167, 1, 1, 0.801241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449971,-99) , 
0, -0.155638, 1, 0, 0.599857,-99) , 
3, 0.829532, 0, 0, 0.698703,-99) , 
NN(
0, 
0, 
-1, -1.03116, 0, -1, 0.193184,-99) , 
3, -0.28269, 0, 0, 0.506079,-99)    );
  // itree = 1668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.858416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378383,-99) , 
0, 0.84413, 1, 0, 0.632263,-99) , 
3, 1.00736, 0, 0, 0.74815,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251108,-99) , 
3, -0.67512, 0, 0, 0.389965,-99) , 
NN(
0, 
0, 
-1, -2.03197, 1, -1, 0.174272,-99) , 
1, -0.281116, 1, 0, 0.258946,-99) , 
3, 0.17816, 0, 0, 0.491132,-99)    );
  // itree = 1669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5372, 1, 1, 0.864337,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485894,-99) , 
0, 0.199449, 1, 0, 0.606299,-99) , 
3, 1.18459, 0, 0, 0.724287,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307113,-99) , 
0, -1.21167, 1, 0, 0.390291,-99) , 
NN(
0, 
0, 
-1, -3.02381, 1, -1, 0.104171,-99) , 
3, -1.14976, 0, 0, 0.287046,-99) , 
3, 0.183842, 0, 0, 0.506462,-99)    );
  // itree = 1670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.59315, 1, 1, 0.885485,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372719,-99) , 
0, 0.997828, 1, 0, 0.617911,-99) , 
3, 1.40309, 0, 0, 0.697258,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152031,-99) , 
0, -1.21605, 1, 0, 0.297236,-99) , 
NN(
0, 
0, 
-1, -1.94576, 0, -1, 0.0951389,-99) , 
3, -1.14608, 0, 0, 0.205081,-99) , 
3, -0.160313, 0, 0, 0.485953,-99)    );
  // itree = 1671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.93301,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494449,-99) , 
3, 1.33152, 0, 0, 0.7252,-99) , 
0, 0.994116, 1, 0, 0.779786,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345225,-99) , 
1, -0.741844, 1, 0, 0.419355,-99) , 
NN(
0, 
0, 
-1, -1.80037, 0, -1, 0.133189,-99) , 
3, -0.608675, 0, 0, 0.297847,-99) , 
3, 0.575013, 0, 0, 0.471655,-99)    );
  // itree = 1672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.891268,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373587,-99) , 
0, 0.972004, 1, 0, 0.639766,-99) , 
3, 1.39044, 0, 0, 0.733132,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30499,-99) , 
2, -0.0628483, 1, 0, 0.43062,-99) , 
NN(
0, 
0, 
-1, -0.957819, 0, -1, 0.158643,-99) , 
3, -0.391132, 0, 0, 0.242882,-99) , 
3, 0.234307, 0, 0, 0.461707,-99)    );
  // itree = 1673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66612, 0, 1, 0.839913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465526,-99) , 
0, 0.508268, 1, 0, 0.640746,-99) , 
3, 1.2097, 0, 0, 0.703962,-99) , 
NN(
0, 
0, 
-1, -0.546181, 1, -1, 0.185115,-99) , 
3, -0.376892, 0, 0, 0.520385,-99)    );
  // itree = 1674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.23356, 1, 1, 0.871125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447601,-99) , 
0, 0.69993, 1, 0, 0.656372,-99) , 
3, 1.42729, 0, 0, 0.71866,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.205734,-99) , 
3, -0.123397, 0, 0, 0.488136,-99)    );
  // itree = 1675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.855083,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317645,-99) , 
0, 1.06604, 1, 0, 0.64439,-99) , 
3, 1.21798, 0, 0, 0.737499,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312937,-99) , 
0, -0.781662, 1, 0, 0.419021,-99) , 
NN(
0, 
0, 
-1, 0.0526353, 1, -1, 0.158528,-99) , 
3, -0.565983, 0, 0, 0.277387,-99) , 
3, 0.228725, 0, 0, 0.489925,-99)    );
  // itree = 1676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11593, 0, 1, 0.859322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356986,-99) , 
3, 1.50533, 0, 0, 0.650108,-99) , 
0, 1.50474, 1, 0, 0.763503,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29604,-99) , 
0, -0.335342, 1, 0, 0.451804,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.234571,-99) , 
3, -0.372166, 0, 0, 0.316916,-99) , 
3, 0.254861, 0, 0, 0.508689,-99)    );
  // itree = 1677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.863241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352057,-99) , 
0, 0.852865, 1, 0, 0.633446,-99) , 
3, 1.21436, 0, 0, 0.739109,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335812,-99) , 
0, -0.733206, 1, 0, 0.47576,-99) , 
NN(
0, 
0, 
-1, -1.59136, 1, -1, 0.164501,-99) , 
3, -0.376357, 0, 0, 0.267148,-99) , 
3, 0.17816, 0, 0, 0.480665,-99)    );
  // itree = 1678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.677193, 1, 1, 0.82868,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372385,-99) , 
0, 0.459139, 1, 0, 0.577542,-99) , 
3, 0.716575, 0, 0, 0.736754,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328702,-99) , 
0, -1.21605, 1, 0, 0.39852,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0858612,-99) , 
3, -0.99221, 0, 0, 0.269646,-99) , 
3, 0.0990605, 0, 0, 0.510905,-99)    );
  // itree = 1679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.38501, 1, 1, 0.830632,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29439,-99) , 
0, 0.465064, 1, 0, 0.554498,-99) , 
3, 0.837253, 0, 0, 0.688713,-99) , 
NN(
0, 
0, 
-1, -0.82831, 0, -1, 0.179138,-99) , 
3, -0.25059, 0, 0, 0.477196,-99)    );
  // itree = 1680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.925944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44385,-99) , 
3, 1.0105, 0, 0, 0.673993,-99) , 
0, 0.311772, 1, 0, 0.726725,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326326,-99) , 
0, -0.765399, 1, 0, 0.435269,-99) , 
NN(
0, 
0, 
-1, -2.65744, 1, -1, 0.164648,-99) , 
3, -0.654599, 0, 0, 0.286909,-99) , 
3, 0.17816, 0, 0, 0.502879,-99)    );
  // itree = 1681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.07046, 1, 1, 0.901669,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439983,-99) , 
0, 0.905235, 1, 0, 0.700942,-99) , 
3, 1.42073, 0, 0, 0.773926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601916,-99) , 
NN(
0, 
0, 
-1, -1.16967, 0, -1, 0.1965,-99) , 
3, -0.109402, 0, 0, 0.258309,-99) , 
3, 0.17816, 0, 0, 0.509317,-99)    );
  // itree = 1682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.310749, 1, 1, 0.907462,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449204,-99) , 
3, 1.11054, 0, 0, 0.721241,-99) , 
0, 0.777489, 1, 0, 0.782724,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304102,-99) , 
0, -1.21855, 1, 0, 0.381989,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.104096,-99) , 
3, -1.08906, 0, 0, 0.280564,-99) , 
3, 0.262941, 0, 0, 0.500669,-99)    );
  // itree = 1683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.20062, 1, 1, 0.883913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300853,-99) , 
0, 1.02827, 1, 0, 0.61945,-99) , 
3, 1.15859, 0, 0, 0.714512,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153803,-99) , 
0, -1.37022, 1, 0, 0.299116,-99) , 
NN(
0, 
0, 
-1, -2.88669, 1, -1, 0.0905717,-99) , 
3, -1.10829, 0, 0, 0.220612,-99) , 
3, -0.142366, 0, 0, 0.503849,-99)    );
  // itree = 1684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.857375,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372641,-99) , 
0, 0.713978, 1, 0, 0.571494,-99) , 
3, 1.13099, 0, 0, 0.693379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2241,-99) , 
0, -0.773268, 1, 0, 0.43057,-99) , 
NN(
0, 
0, 
-1, -0.528846, 1, -1, 0.152122,-99) , 
3, -0.39598, 0, 0, 0.242905,-99) , 
3, 0.135748, 0, 0, 0.463809,-99)    );
  // itree = 1685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.83792, 0, 1, 0.86789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344772,-99) , 
0, 0.540099, 1, 0, 0.613346,-99) , 
3, 1.06589, 0, 0, 0.725929,-99) , 
NN(
0, 
0, 
-1, -0.498724, 0, -1, 0.236074,-99) , 
3, 0.0509667, 0, 0, 0.487192,-99)    );
  // itree = 1686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.4052, 0, 1, 0.726844,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298023,-99) , 
0, -0.991976, 1, 0, 0.422441,-99) , 
NN(
0, 
0, 
-1, -1.79283, 1, -1, 0.156062,-99) , 
3, -0.591799, 0, 0, 0.266441,-99) , 
3, 0.20809, 0, 0, 0.491831,-99)    );
  // itree = 1687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0756, 0, 1, 0.799224,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326158,-99) , 
0, -0.0131043, 1, 0, 0.533298,-99) , 
3, 0.525662, 0, 0, 0.695334,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.16255,-99) , 
3, -0.38184, 0, 0, 0.492787,-99)    );
  // itree = 1688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48325, 0, 1, 0.828479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316088,-99) , 
0, 0.360286, 1, 0, 0.564452,-99) , 
3, 0.767226, 0, 0, 0.714495,-99) , 
NN(
0, 
0, 
-1, -0.720075, 0, -1, 0.19418,-99) , 
3, -0.123397, 0, 0, 0.48866,-99)    );
  // itree = 1689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20559, 0, 1, 0.711993,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.206572,-99) , 
3, -0.38184, 0, 0, 0.544811,-99)    );
  // itree = 1690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55798, 0, 1, 0.855479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394801,-99) , 
0, 0.777626, 1, 0, 0.658735,-99) , 
3, 1.08361, 0, 0, 0.761128,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204085,-99) , 
0, -0.192873, 1, 0, 0.404879,-99) , 
NN(
0, 
0, 
-1, -1.18692, 0, -1, 0.163478,-99) , 
3, -0.329146, 0, 0, 0.261785,-99) , 
3, 0.306962, 0, 0, 0.481055,-99)    );
  // itree = 1691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.856078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315558,-99) , 
0, 0.799619, 1, 0, 0.614597,-99) , 
3, 1.12023, 0, 0, 0.713049,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.201483,-99) , 
3, -0.202496, 0, 0, 0.514163,-99)    );
  // itree = 1692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53379, 0, 1, 0.893608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388809,-99) , 
0, 0.871083, 1, 0, 0.629755,-99) , 
3, 1.20395, 0, 0, 0.726636,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.197553,-99) , 
3, -0.123397, 0, 0, 0.509041,-99)    );
  // itree = 1693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.709428, 1, 1, 0.771737,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304532,-99) , 
3, -0.178718, 0, 0, 0.401234,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.114843,-99) , 
3, -0.959868, 0, 0, 0.287208,-99) , 
3, 0.306962, 0, 0, 0.501421,-99)    );
  // itree = 1694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.661651, 0, 1, 0.910606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47659,-99) , 
3, 1.0422, 0, 0, 0.740824,-99) , 
0, 0.696722, 1, 0, 0.795446,-99) , 
NN(
0, 
0, 
-1, -1.20546, 0, -1, 0.266366,-99) , 
3, 0.17816, 0, 0, 0.504885,-99)    );
  // itree = 1695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.60464, 1, 1, 0.886231,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35377,-99) , 
0, 0.738333, 1, 0, 0.571895,-99) , 
3, 1.32952, 0, 0, 0.660229,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.200116,-99) , 
3, -0.304384, 0, 0, 0.503112,-99)    );
  // itree = 1696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4121, 1, 1, 0.873544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450828,-99) , 
0, 0.639693, 1, 0, 0.647526,-99) , 
3, 0.982657, 0, 0, 0.780281,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290087,-99) , 
0, -0.431695, 1, 0, 0.451896,-99) , 
NN(
0, 
0, 
-1, -1.12639, 0, -1, 0.183312,-99) , 
3, -0.568264, 0, 0, 0.309879,-99) , 
3, 0.392653, 0, 0, 0.512781,-99)    );
  // itree = 1697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54195, 1, 1, 0.828013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301126,-99) , 
0, 0.830896, 1, 0, 0.632869,-99) , 
3, 1.04714, 0, 0, 0.715108,-99) , 
NN(
0, 
0, 
-1, -0.534619, 0, -1, 0.215944,-99) , 
3, 0.0354976, 0, 0, 0.480887,-99)    );
  // itree = 1698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.52544, 1, 1, 0.879621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41544,-99) , 
3, 1.11054, 0, 0, 0.700715,-99) , 
0, 0.768458, 1, 0, 0.761762,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285902,-99) , 
0, -0.99941, 1, 0, 0.39641,-99) , 
NN(
0, 
0, 
-1, -1.91637, 0, -1, 0.110065,-99) , 
3, -1.08906, 0, 0, 0.302506,-99) , 
3, 0.262941, 0, 0, 0.520656,-99)    );
  // itree = 1699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.814828,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356182,-99) , 
3, -0.0316807, 0, 0, 0.529694,-99) , 
3, 0.38043, 0, 0, 0.72257,-99) , 
NN(
0, 
0, 
-1, -1.03076, 0, -1, 0.204388,-99) , 
3, -0.287638, 0, 0, 0.53022,-99)    );
  // itree = 1700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32353, 0, 1, 0.821715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698004,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335536,-99) , 
0, 0.356469, 1, 0, 0.562352,-99) , 
3, 0.812547, 0, 0, 0.693732,-99) , 
NN(
0, 
0, 
-1, -0.999241, 0, -1, 0.195447,-99) , 
3, -0.276907, 0, 0, 0.501672,-99)    );
  // itree = 1701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40435, 1, 1, 0.861018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424956,-99) , 
0, 0.777626, 1, 0, 0.652742,-99) , 
3, 1.07833, 0, 0, 0.754551,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258815,-99) , 
0, -0.431695, 1, 0, 0.446859,-99) , 
NN(
0, 
0, 
-1, -1.02325, 0, -1, 0.148965,-99) , 
3, -0.548378, 0, 0, 0.276014,-99) , 
3, 0.262941, 0, 0, 0.498183,-99)    );
  // itree = 1702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.74751, 1, 1, 0.781131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420808,-99) , 
0, -0.303416, 1, 0, 0.523613,-99) , 
3, 0.402667, 0, 0, 0.698986,-99) , 
NN(
0, 
0, 
-1, -0.841139, 0, -1, 0.209238,-99) , 
3, -0.25059, 0, 0, 0.508363,-99)    );
  // itree = 1703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.833749,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259268,-99) , 
0, 0.46484, 1, 0, 0.563011,-99) , 
3, 0.666353, 0, 0, 0.709656,-99) , 
NN(
0, 
0, 
-1, -0.507749, 0, -1, 0.191631,-99) , 
3, -0.207894, 0, 0, 0.47399,-99)    );
  // itree = 1704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.616454, 1, 1, 0.775463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46727,-99) , 
3, 0.230255, 0, 0, 0.695556,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152582,-99) , 
0, -1.26463, 1, 0, 0.289218,-99) , 
NN(
0, 
0, 
-1, 0.0272174, 1, -1, 0.094799,-99) , 
3, -1.09238, 0, 0, 0.202292,-99) , 
3, -0.207894, 0, 0, 0.485807,-99)    );
  // itree = 1705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.8452,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210718,-99) , 
0, 0.683966, 1, 0, 0.571382,-99) , 
3, 0.920245, 0, 0, 0.713128,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237227,-99) , 
0, -0.991976, 1, 0, 0.351144,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.0858397,-99) , 
3, -0.990852, 0, 0, 0.248438,-99) , 
3, 0.0990605, 0, 0, 0.48266,-99)    );
  // itree = 1706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76902, 1, 1, 0.829999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273566,-99) , 
0, 0.857117, 1, 0, 0.558346,-99) , 
3, 1.20395, 0, 0, 0.651762,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338758,-99) , 
1, -0.444501, 1, 0, 0.419489,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.132241,-99) , 
3, -1.0146, 0, 0, 0.267233,-99) , 
3, -0.123397, 0, 0, 0.497261,-99)    );
  // itree = 1707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39222, 1, 1, 0.888775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818381,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400912,-99) , 
0, 1.14512, 1, 0, 0.676801,-99) , 
3, 1.46903, 0, 0, 0.752381,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301892,-99) , 
0, -1.27242, 1, 0, 0.398898,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.110523,-99) , 
3, -0.959934, 0, 0, 0.28792,-99) , 
3, 0.301115, 0, 0, 0.500156,-99)    );
  // itree = 1708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.60674, 0, 1, 0.744465,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318885,-99) , 
1, -0.0259307, 1, 0, 0.482226,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.181406,-99) , 
3, -0.372166, 0, 0, 0.294865,-99) , 
3, 0.254861, 0, 0, 0.479646,-99)    );
  // itree = 1709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.659242, 0, 1, 0.868189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445563,-99) , 
3, 1.23087, 0, 0, 0.708221,-99) , 
0, 1.09517, 1, 0, 0.776662,-99) , 
NN(
0, 
0, 
-1, -0.327012, 0, -1, 0.277328,-99) , 
3, 0.20809, 0, 0, 0.506468,-99)    );
  // itree = 1710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84341, 0, 1, 0.869114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446573,-99) , 
0, 0.401258, 1, 0, 0.608955,-99) , 
3, 1.20395, 0, 0, 0.705112,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.217241,-99) , 
3, -0.123397, 0, 0, 0.517315,-99)    );
  // itree = 1711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.858657,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35172,-99) , 
0, 1.0116, 1, 0, 0.621177,-99) , 
3, 1.1447, 0, 0, 0.714733,-99) , 
NN(
0, 
0, 
-1, -0.717342, 0, -1, 0.228016,-99) , 
3, -0.210183, 0, 0, 0.521569,-99)    );
  // itree = 1712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39525, 1, 1, 0.822038,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312816,-99) , 
0, 0.43111, 1, 0, 0.518625,-99) , 
NN(
0, 
0, 
-1, -1.12173, 0, -1, 0.191418,-99) , 
3, -0.554845, 0, 0, 0.377275,-99) , 
3, 0.810124, 0, 0, 0.519144,-99)    );
  // itree = 1713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.808776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427511,-99) , 
0, -0.209042, 1, 0, 0.58387,-99) , 
3, 0.527818, 0, 0, 0.73937,-99) , 
NN(
0, 
0, 
-1, -1.12985, 0, -1, 0.192061,-99) , 
3, -0.140969, 0, 0, 0.49465,-99)    );
  // itree = 1714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.86059, 0, 1, 0.850801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375543,-99) , 
0, 0.848875, 1, 0, 0.613838,-99) , 
3, 1.43936, 0, 0, 0.674714,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.205762,-99) , 
3, -0.38184, 0, 0, 0.512703,-99)    );
  // itree = 1715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12724, 1, 1, 0.84066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351809,-99) , 
0, 0.446311, 1, 0, 0.621358,-99) , 
3, 0.98281, 0, 0, 0.719807,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.156921,-99) , 
3, -0.123397, 0, 0, 0.465113,-99)    );
  // itree = 1716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.437515, 1, 1, 0.885696,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424448,-99) , 
3, 1.08418, 0, 0, 0.700008,-99) , 
0, 0.702317, 1, 0, 0.755868,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193504,-99) , 
0, -0.16264, 1, 0, 0.442392,-99) , 
NN(
0, 
0, 
-1, -1.18817, 0, -1, 0.1704,-99) , 
3, -0.644244, 0, 0, 0.312963,-99) , 
3, 0.306962, 0, 0, 0.503185,-99)    );
  // itree = 1717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.866824,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4541,-99) , 
0, 0.635752, 1, 0, 0.647668,-99) , 
3, 1.38387, 0, 0, 0.716308,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191313,-99) , 
0, -1.24543, 1, 0, 0.336498,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0765419,-99) , 
3, -1.20728, 0, 0, 0.204321,-99) , 
3, -0.210183, 0, 0, 0.490629,-99)    );
  // itree = 1718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39916, 0, 1, 0.764044,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341132,-99) , 
0, -0.495227, 1, 0, 0.45994,-99) , 
3, 0.249873, 0, 0, 0.674966,-99) , 
NN(
0, 
0, 
-1, -0.933229, 0, -1, 0.180487,-99) , 
3, -0.435158, 0, 0, 0.489798,-99)    );
  // itree = 1719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93673, 0, 1, 0.85192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409009,-99) , 
0, 0.679936, 1, 0, 0.614789,-99) , 
3, 1.20658, 0, 0, 0.69206,-99) , 
NN(
0, 
0, 
-1, -1.30798, 0, -1, 0.178745,-99) , 
3, -0.340957, 0, 0, 0.507489,-99)    );
  // itree = 1720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66603, 1, 1, 0.86728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280864,-99) , 
0, 0.891, 1, 0, 0.599999,-99) , 
3, 1.11225, 0, 0, 0.705718,-99) , 
NN(
0, 
0, 
-1, -0.496803, 0, -1, 0.224136,-99) , 
3, -0.202496, 0, 0, 0.50823,-99)    );
  // itree = 1721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.760905,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26889,-99) , 
0, -0.0845019, 1, 0, 0.465975,-99) , 
3, 0.376807, 0, 0, 0.659776,-99) , 
NN(
0, 
0, 
-1, -1.23675, 0, -1, 0.197783,-99) , 
3, -0.276907, 0, 0, 0.484228,-99)    );
  // itree = 1722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.00508, 0, 1, 0.763969,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317223,-99) , 
0, -0.841773, 1, 0, 0.450521,-99) , 
NN(
0, 
0, 
-1, -0.975023, 0, -1, 0.139353,-99) , 
3, -0.398263, 0, 0, 0.25527,-99) , 
3, 0.234307, 0, 0, 0.480965,-99)    );
  // itree = 1723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.845104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275766,-99) , 
0, 0.70966, 1, 0, 0.596643,-99) , 
3, 0.985321, 0, 0, 0.708347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525699,-99) , 
NN(
0, 
0, 
-1, -0.552932, 1, -1, 0.150218,-99) , 
3, -0.419174, 0, 0, 0.215345,-99) , 
3, -0.123397, 0, 0, 0.495606,-99)    );
  // itree = 1724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.850349,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352197,-99) , 
0, 0.449644, 1, 0, 0.585431,-99) , 
3, 0.98281, 0, 0, 0.694262,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245605,-99) , 
0, -1.24852, 1, 0, 0.372601,-99) , 
NN(
0, 
0, 
-1, -0.0375415, 1, -1, 0.0942869,-99) , 
3, -1.0146, 0, 0, 0.257314,-99) , 
3, -0.123397, 0, 0, 0.523929,-99)    );
  // itree = 1725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2063, 0, 1, 0.73698,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.162477,-99) , 
0, -1.11109, 1, 0, 0.313276,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.11201,-99) , 
3, -1.01267, 0, 0, 0.215,-99) , 
3, -0.123397, 0, 0, 0.510032,-99)    );
  // itree = 1726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55993, 1, 1, 0.842898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260571,-99) , 
0, 0.84413, 1, 0, 0.582427,-99) , 
3, 1.13058, 0, 0, 0.695646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273302,-99) , 
3, -0.990852, 0, 0, 0.441053,-99) , 
NN(
0, 
0, 
-1, -0.683459, 0, -1, 0.186815,-99) , 
1, -0.670644, 1, 0, 0.25433,-99) , 
3, 0.0990605, 0, 0, 0.478962,-99)    );
  // itree = 1727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.19067, 1, 1, 0.891456,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427991,-99) , 
0, 0.807964, 1, 0, 0.668733,-99) , 
3, 1.2782, 0, 0, 0.759943,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298403,-99) , 
1, -0.473945, 1, 0, 0.392793,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.0846874,-99) , 
3, -0.95623, 0, 0, 0.270004,-99) , 
3, 0.306962, 0, 0, 0.480776,-99)    );
  // itree = 1728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.890748,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405256,-99) , 
0, 1.31241, 1, 0, 0.723594,-99) , 
3, 1.27767, 0, 0, 0.800295,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286965,-99) , 
0, -0.396862, 1, 0, 0.451963,-99) , 
NN(
0, 
0, 
-1, 0.0242633, 1, -1, 0.11602,-99) , 
3, -0.95623, 0, 0, 0.337121,-99) , 
3, 0.306962, 0, 0, 0.555001,-99)    );
  // itree = 1729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58046, 0, 1, 0.857367,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808062,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331682,-99) , 
0, 0.486742, 1, 0, 0.592272,-99) , 
3, 1.11225, 0, 0, 0.696719,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301829,-99) , 
1, -0.50545, 1, 0, 0.41476,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.112063,-99) , 
3, -1.07684, 0, 0, 0.258751,-99) , 
3, -0.202496, 0, 0, 0.537506,-99)    );
  // itree = 1730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.824302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37139,-99) , 
0, 0.900473, 1, 0, 0.581615,-99) , 
3, 1.30662, 0, 0, 0.661238,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168979,-99) , 
0, -1.57389, 1, 0, 0.284794,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.103983,-99) , 
3, -1.31804, 0, 0, 0.225139,-99) , 
3, -0.304384, 0, 0, 0.492578,-99)    );
  // itree = 1731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.8794,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491289,-99) , 
0, 1.14512, 1, 0, 0.699523,-99) , 
3, 1.47173, 0, 0, 0.759905,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313444,-99) , 
1, -0.654311, 1, 0, 0.379702,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.0864277,-99) , 
3, -0.960097, 0, 0, 0.274583,-99) , 
3, 0.306962, 0, 0, 0.48088,-99)    );
  // itree = 1732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11543, 0, 1, 0.817106,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256655,-99) , 
0, 0.356469, 1, 0, 0.522339,-99) , 
3, 0.770675, 0, 0, 0.669483,-99) , 
NN(
0, 
0, 
-1, -1.13161, 0, -1, 0.189341,-99) , 
3, -0.38184, 0, 0, 0.504429,-99)    );
  // itree = 1733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.04749, 0, 1, 0.859556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352866,-99) , 
0, 0.923985, 1, 0, 0.62676,-99) , 
3, 1.10862, 0, 0, 0.720797,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225121,-99) , 
0, -1.35074, 1, 0, 0.376058,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.10185,-99) , 
3, -1.07684, 0, 0, 0.239252,-99) , 
3, -0.202496, 0, 0, 0.523862,-99)    );
  // itree = 1734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.858316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369824,-99) , 
0, 0.859187, 1, 0, 0.653658,-99) , 
3, 1.13323, 0, 0, 0.753414,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294252,-99) , 
0, -1.2877, 1, 0, 0.398595,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.102094,-99) , 
3, -0.990852, 0, 0, 0.271445,-99) , 
3, 0.0990605, 0, 0, 0.510961,-99)    );
  // itree = 1735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56776, 1, 1, 0.846262,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316162,-99) , 
0, 0.893448, 1, 0, 0.63588,-99) , 
3, 1.12392, 0, 0, 0.721068,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210285,-99) , 
0, -1.19072, 1, 0, 0.325939,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0609959,-99) , 
3, -0.99221, 0, 0, 0.201709,-99) , 
3, 0.0990605, 0, 0, 0.451536,-99)    );
  // itree = 1736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.867647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371177,-99) , 
0, 0.811659, 1, 0, 0.643416,-99) , 
3, 1.27351, 0, 0, 0.712664,-99) , 
NN(
0, 
0, 
-1, -1.1213, 0, -1, 0.197576,-99) , 
3, -0.25059, 0, 0, 0.510482,-99)    );
  // itree = 1737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.825363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440316,-99) , 
0, 0.582128, 1, 0, 0.649085,-99) , 
3, 0.804607, 0, 0, 0.762433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545178,-99) , 
NN(
0, 
0, 
-1, -1.43523, 0, -1, 0.198939,-99) , 
3, -0.103735, 0, 0, 0.268582,-99) , 
3, 0.17816, 0, 0, 0.495552,-99)    );
  // itree = 1738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16119, 0, 1, 0.799451,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234273,-99) , 
0, 0.140762, 1, 0, 0.519721,-99) , 
3, 0.596101, 0, 0, 0.661228,-99) , 
NN(
0, 
0, 
-1, 0.462662, 1, -1, 0.103169,-99) , 
3, -0.639447, 0, 0, 0.499767,-99)    );
  // itree = 1739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16235, 1, 1, 0.851793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434262,-99) , 
0, 0.210411, 1, 0, 0.627356,-99) , 
3, 0.985321, 0, 0, 0.724587,-99) , 
NN(
0, 
0, 
-1, -1.41328, 1, -1, 0.213967,-99) , 
3, -0.123397, 0, 0, 0.505069,-99)    );
  // itree = 1740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0410644, 1, 1, 0.908745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41254,-99) , 
3, 1.36351, 0, 0, 0.715967,-99) , 
0, 1.09855, 1, 0, 0.800002,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260224,-99) , 
0, -0.421248, 1, 0, 0.426487,-99) , 
NN(
0, 
0, 
-1, -1.45806, 0, -1, 0.118652,-99) , 
3, -0.644801, 0, 0, 0.27822,-99) , 
3, 0.301115, 0, 0, 0.50658,-99)    );
  // itree = 1741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.05391, 0, 1, 0.758165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20042,-99) , 
0, -0.211824, 1, 0, 0.421168,-99) , 
NN(
0, 
0, 
-1, -1.72794, 0, -1, 0.155326,-99) , 
3, -0.644801, 0, 0, 0.280798,-99) , 
3, 0.306962, 0, 0, 0.478931,-99)    );
  // itree = 1742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.87048,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265979,-99) , 
0, 0.86854, 1, 0, 0.580274,-99) , 
3, 1.10293, 0, 0, 0.685065,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195531,-99) , 
0, -1.20513, 1, 0, 0.345907,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.118573,-99) , 
3, -1.09397, 0, 0, 0.230466,-99) , 
3, -0.207894, 0, 0, 0.506489,-99)    );
  // itree = 1743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.858497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344789,-99) , 
0, 0.931454, 1, 0, 0.681014,-99) , 
3, 1.20446, 0, 0, 0.759731,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209752,-99) , 
0, -0.368981, 1, 0, 0.395717,-99) , 
NN(
0, 
0, 
-1, -2.21957, 1, -1, 0.154739,-99) , 
3, -0.856661, 0, 0, 0.285258,-99) , 
3, 0.202693, 0, 0, 0.504991,-99)    );
  // itree = 1744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.761347, 1, 1, 0.787763,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155511,-99) , 
0, -0.0856679, 1, 0, 0.388926,-99) , 
NN(
0, 
0, 
-1, -1.72281, 0, -1, 0.177261,-99) , 
3, -0.95623, 0, 0, 0.31568,-99) , 
3, 0.306962, 0, 0, 0.516853,-99)    );
  // itree = 1745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0462137, 1, 1, 0.875887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381317,-99) , 
0, 0.893448, 1, 0, 0.686758,-99) , 
3, 1.07875, 0, 0, 0.78471,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336286,-99) , 
0, -0.991976, 1, 0, 0.427018,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.135033,-99) , 
3, -0.959342, 0, 0, 0.307512,-99) , 
3, 0.301115, 0, 0, 0.515825,-99)    );
  // itree = 1746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58391, 1, 1, 0.874617,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498474,-99) , 
0, 0.401258, 1, 0, 0.639021,-99) , 
3, 1.20395, 0, 0, 0.727939,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.197269,-99) , 
3, -0.123397, 0, 0, 0.503889,-99)    );
  // itree = 1747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11, 0, 1, 0.802815,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34648,-99) , 
0, -0.0316589, 1, 0, 0.55266,-99) , 
3, 0.540529, 0, 0, 0.718564,-99) , 
NN(
0, 
0, 
-1, -0.716845, 0, -1, 0.214391,-99) , 
3, -0.123397, 0, 0, 0.509804,-99)    );
  // itree = 1748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.47566, 1, 1, 0.893079,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473467,-99) , 
0, 0.854524, 1, 0, 0.653778,-99) , 
3, 1.64623, 0, 0, 0.701366,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198701,-99) , 
0, -1.17488, 1, 0, 0.325555,-99) , 
NN(
0, 
0, 
-1, -2.02163, 0, -1, 0.107642,-99) , 
3, -1.00886, 0, 0, 0.231119,-99) , 
3, -0.123397, 0, 0, 0.506146,-99)    );
  // itree = 1749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.857778,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400183,-99) , 
0, 0.889484, 1, 0, 0.672505,-99) , 
3, 1.17923, 0, 0, 0.763985,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204913,-99) , 
0, -0.0856679, 1, 0, 0.456349,-99) , 
NN(
0, 
0, 
-1, -1.93791, 0, -1, 0.183358,-99) , 
3, -0.568264, 0, 0, 0.31411,-99) , 
3, 0.392653, 0, 0, 0.50156,-99)    );
  // itree = 1750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47292, 1, 1, 0.806511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379519,-99) , 
0, -0.218544, 1, 0, 0.566134,-99) , 
3, 0.653753, 0, 0, 0.698073,-99) , 
NN(
0, 
0, 
-1, -0.7268, 0, -1, 0.247716,-99) , 
3, -0.232821, 0, 0, 0.518295,-99)    );
  // itree = 1751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60258, 1, 1, 0.883776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239012,-99) , 
0, 1.17393, 1, 0, 0.662309,-99) , 
3, 1.12567, 0, 0, 0.767665,-99) , 
NN(
0, 
0, 
-1, -0.372375, 0, -1, 0.283249,-99) , 
3, 0.147523, 0, 0, 0.529458,-99)    );
  // itree = 1752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.21231, 0, 1, 0.806331,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337544,-99) , 
0, -0.594038, 1, 0, 0.431706,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.183566,-99) , 
3, -0.466718, 0, 0, 0.316989,-99) , 
3, 0.684423, 0, 0, 0.47737,-99)    );
  // itree = 1753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.20395, 0, 1, 0.758829,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219549,-99) , 
0, -1.30478, 1, 0, 0.335264,-99) , 
NN(
0, 
0, 
-1, -0.420046, 1, -1, 0.103566,-99) , 
3, -1.00946, 0, 0, 0.213616,-99) , 
3, -0.123397, 0, 0, 0.519387,-99)    );
  // itree = 1754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.860878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447195,-99) , 
0, 0.268574, 1, 0, 0.59331,-99) , 
3, 1.2063, 0, 0, 0.688869,-99) , 
NN(
0, 
0, 
-1, -1.41328, 1, -1, 0.177431,-99) , 
3, -0.123397, 0, 0, 0.45885,-99)    );
  // itree = 1755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.867084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445911,-99) , 
0, 0.972004, 1, 0, 0.688797,-99) , 
3, 1.27353, 0, 0, 0.768757,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25341,-99) , 
0, -0.301216, 1, 0, 0.474792,-99) , 
NN(
0, 
0, 
-1, -1.1952, 0, -1, 0.157293,-99) , 
3, -0.329146, 0, 0, 0.266156,-99) , 
3, 0.301115, 0, 0, 0.476146,-99)    );
  // itree = 1756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.391669, 0, 1, 0.753956,-99) , 
NN(
NN(
0, 
0, 
-1, -1.18149, 0, 1, 0.568294,-99) , 
NN(
0, 
0, 
-1, -1.1043, 0, -1, 0.191961,-99) , 
1, -0.591714, 1, 0, 0.274905,-99) , 
3, 0.17816, 0, 0, 0.509553,-99)    );
  // itree = 1757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16902, 1, 1, 0.772982,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347099,-99) , 
0, -0.18246, 1, 0, 0.570224,-99) , 
3, 0.540529, 0, 0, 0.701554,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.27448,-99) , 
3, -0.123397, 0, 0, 0.525091,-99)    );
  // itree = 1758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19605, 1, 1, 0.848295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366834,-99) , 
0, 0.569025, 1, 0, 0.630027,-99) , 
3, 1.00929, 0, 0, 0.74197,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360604,-99) , 
0, -0.701151, 1, 0, 0.464218,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.156877,-99) , 
3, -0.382101, 0, 0, 0.266074,-99) , 
3, 0.17816, 0, 0, 0.494459,-99)    );
  // itree = 1759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89821, 0, 1, 0.840056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404942,-99) , 
0, 0.64261, 1, 0, 0.657808,-99) , 
3, 1.07541, 0, 0, 0.730509,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.181185,-99) , 
3, -0.304384, 0, 0, 0.518849,-99)    );
  // itree = 1760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.857098,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376588,-99) , 
0, 0.260859, 1, 0, 0.590702,-99) , 
3, 0.784833, 0, 0, 0.773557,-99) , 
NN(
0, 
0, 
-1, -1.15126, 0, -1, 0.264554,-99) , 
3, 0.183842, 0, 0, 0.495979,-99)    );
  // itree = 1761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.40944, 0, 1, 0.785903,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266009,-99) , 
0, -1.44718, 1, 0, 0.348347,-99) , 
NN(
0, 
0, 
-1, -2.5847, 1, -1, 0.135517,-99) , 
3, -1.11797, 0, 0, 0.273932,-99) , 
3, 0.20809, 0, 0, 0.500397,-99)    );
  // itree = 1762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75022, 1, 1, 0.856963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236458,-99) , 
0, 0.931718, 1, 0, 0.522545,-99) , 
3, 1.19247, 0, 0, 0.624219,-99) , 
NN(
0, 
0, 
-1, -1.17601, 1, -1, 0.182122,-99) , 
3, -0.344168, 0, 0, 0.447942,-99)    );
  // itree = 1763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.9521, 1, 1, 0.831728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268135,-99) , 
0, 0.530902, 1, 0, 0.579269,-99) , 
3, 0.706072, 0, 0, 0.730031,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240835,-99) , 
0, -0.765399, 1, 0, 0.398025,-99) , 
NN(
0, 
0, 
-1, -1.80384, 1, -1, 0.146906,-99) , 
3, -0.722291, 0, 0, 0.265075,-99) , 
3, 0.093663, 0, 0, 0.491876,-99)    );
  // itree = 1764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.820128,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411981,-99) , 
0, -0.0834363, 1, 0, 0.590741,-99) , 
3, 0.845703, 0, 0, 0.6926,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.188489,-99) , 
3, -0.304384, 0, 0, 0.50136,-99)    );
  // itree = 1765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.876349,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217288,-99) , 
0, 0.895922, 1, 0, 0.547638,-99) , 
3, 1.06561, 0, 0, 0.684256,-99) , 
NN(
0, 
0, 
-1, -1.03948, 0, -1, 0.242122,-99) , 
3, 0.0509667, 0, 0, 0.471025,-99)    );
  // itree = 1766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.854723,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28311,-99) , 
0, 0.738333, 1, 0, 0.577236,-99) , 
3, 1.07541, 0, 0, 0.670311,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.203422,-99) , 
3, -0.304384, 0, 0, 0.503281,-99)    );
  // itree = 1767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.786849, 0, 1, 0.787245,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293707,-99) , 
0, -0.406665, 1, 0, 0.476156,-99) , 
NN(
0, 
0, 
-1, -2.20845, 1, -1, 0.179323,-99) , 
3, -0.724836, 0, 0, 0.316717,-99) , 
3, 0.207882, 0, 0, 0.540409,-99)    );
  // itree = 1768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.643161, 0, 1, 0.906372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357145,-99) , 
3, 0.995965, 0, 0, 0.701765,-99) , 
0, 0.768458, 1, 0, 0.769275,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79288,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32699,-99) , 
1, -0.252733, 1, 0, 0.517333,-99) , 
NN(
0, 
0, 
-1, -1.00024, 0, -1, 0.156276,-99) , 
3, -0.4077, 0, 0, 0.276189,-99) , 
3, 0.218994, 0, 0, 0.503278,-99)    );
  // itree = 1769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.553891, 1, 1, 0.780029,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383319,-99) , 
1, -0.654311, 1, 0, 0.463791,-99) , 
3, 0.246693, 0, 0, 0.661253,-99) , 
NN(
0, 
0, 
-1, -1.48397, 0, -1, 0.145659,-99) , 
3, -0.786928, 0, 0, 0.526437,-99)    );
  // itree = 1770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.67567, 0, 1, 0.74837,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317122,-99) , 
0, -0.46933, 1, 0, 0.475263,-99) , 
NN(
0, 
0, 
-1, -1.26187, 0, -1, 0.17108,-99) , 
3, -0.548378, 0, 0, 0.296024,-99) , 
3, 0.262941, 0, 0, 0.500263,-99)    );
  // itree = 1771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19648, 1, 1, 0.870395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492271,-99) , 
0, 0.639693, 1, 0, 0.714682,-99) , 
3, 1.08361, 0, 0, 0.802342,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365107,-99) , 
0, -1.2877, 1, 0, 0.442408,-99) , 
NN(
0, 
0, 
-1, -1.73035, 0, -1, 0.129004,-99) , 
3, -0.95623, 0, 0, 0.328425,-99) , 
3, 0.306962, 0, 0, 0.539219,-99)    );
  // itree = 1772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51859, 1, 1, 0.848156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408157,-99) , 
0, 0.0136911, 1, 0, 0.605368,-99) , 
3, 0.713004, 0, 0, 0.739854,-99) , 
NN(
0, 
0, 
-1, -0.67742, 0, -1, 0.217486,-99) , 
3, -0.18324, 0, 0, 0.532388,-99)    );
  // itree = 1773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.839003,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418902,-99) , 
0, 0.411358, 1, 0, 0.574819,-99) , 
3, 0.927861, 0, 0, 0.69165,-99) , 
NN(
0, 
0, 
-1, -1.16956, 0, -1, 0.187561,-99) , 
3, -0.420978, 0, 0, 0.518361,-99)    );
  // itree = 1774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.89653, 1, 1, 0.903627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482193,-99) , 
0, 0.374565, 1, 0, 0.590837,-99) , 
3, 1.43274, 0, 0, 0.670865,-99) , 
NN(
0, 
0, 
-1, -1.13049, 0, -1, 0.159224,-99) , 
3, -0.38184, 0, 0, 0.486708,-99)    );
  // itree = 1775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.851609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30842,-99) , 
0, 0.405663, 1, 0, 0.53628,-99) , 
3, 0.777892, 0, 0, 0.684123,-99) , 
NN(
0, 
0, 
-1, -1.75375, 1, -1, 0.126671,-99) , 
3, -0.673088, 0, 0, 0.521349,-99)    );
  // itree = 1776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.256001, 1, 1, 0.764843,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328449,-99) , 
0, -0.773268, 1, 0, 0.514853,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.16631,-99) , 
3, -0.391477, 0, 0, 0.288287,-99) , 
3, 0.234307, 0, 0, 0.51064,-99)    );
  // itree = 1777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55612, 1, 1, 0.910613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369124,-99) , 
0, 1.0116, 1, 0, 0.655633,-99) , 
3, 1.30869, 0, 0, 0.734205,-99) , 
NN(
0, 
0, 
-1, -0.963382, 0, -1, 0.201994,-99) , 
3, -0.232821, 0, 0, 0.522435,-99)    );
  // itree = 1778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.847683,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399231,-99) , 
0, 0.893448, 1, 0, 0.640431,-99) , 
3, 1.21404, 0, 0, 0.727676,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302157,-99) , 
0, -0.616482, 1, 0, 0.464016,-99) , 
NN(
0, 
0, 
-1, -1.12717, 0, -1, 0.155387,-99) , 
3, -0.376357, 0, 0, 0.261016,-99) , 
3, 0.17816, 0, 0, 0.481924,-99)    );
  // itree = 1779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.826578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310001,-99) , 
0, 0.539544, 1, 0, 0.544738,-99) , 
3, 0.983057, 0, 0, 0.643496,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.155226,-99) , 
3, -0.376892, 0, 0, 0.460331,-99)    );
  // itree = 1780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6013, 1, 1, 0.859737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196062,-99) , 
0, 1.0116, 1, 0, 0.594507,-99) , 
3, 0.983057, 0, 0, 0.694877,-99) , 
NN(
0, 
0, 
-1, -1.12717, 0, -1, 0.160643,-99) , 
3, -0.376892, 0, 0, 0.499821,-99)    );
  // itree = 1781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.40813, 0, 1, 0.848002,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41245,-99) , 
1, -0.512195, 1, 0, 0.508048,-99) , 
NN(
0, 
0, 
-1, -1.02102, 0, -1, 0.21114,-99) , 
3, -0.537409, 0, 0, 0.369155,-99) , 
3, 0.660704, 0, 0, 0.524557,-99)    );
  // itree = 1782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.454466, 1, 1, 0.950513,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41796,-99) , 
3, 1.40608, 0, 0, 0.723347,-99) , 
0, 1.17756, 1, 0, 0.807576,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.946905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34626,-99) , 
0, -1.38822, 1, 0, 0.433971,-99) , 
NN(
0, 
0, 
-1, -2.27519, 1, -1, 0.0942346,-99) , 
3, -0.951132, 0, 0, 0.321234,-99) , 
3, 0.506153, 0, 0, 0.522463,-99)    );
  // itree = 1783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.48923, 1, 1, 0.866058,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435859,-99) , 
0, -0.0215873, 1, 0, 0.576263,-99) , 
3, 1.06835, 0, 0, 0.683183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199337,-99) , 
0, -1.19072, 1, 0, 0.332255,-99) , 
NN(
0, 
0, 
-1, -2.53364, 1, -1, 0.139181,-99) , 
3, -1.11972, 0, 0, 0.240506,-99) , 
3, -0.25059, 0, 0, 0.506048,-99)    );
  // itree = 1784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.426, 0, 1, 0.834081,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.90145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391439,-99) , 
0, -0.0708108, 1, 0, 0.589677,-99) , 
3, 0.719718, 0, 0, 0.74444,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284254,-99) , 
0, -1.06166, 1, 0, 0.420614,-99) , 
NN(
0, 
0, 
-1, -2.58256, 1, -1, 0.137881,-99) , 
3, -0.99221, 0, 0, 0.302603,-99) , 
3, 0.0990605, 0, 0, 0.542184,-99)    );
  // itree = 1785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.235551, 0, 1, 0.720157,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13549,-99) , 
3, -1.38408, 0, 0, 0.305439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.107982,-99) , 
0, -1.17657, 1, 0, 0.220691,-99) , 
3, -0.202496, 0, 0, 0.528707,-99)    );
  // itree = 1786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.37726, 0, 1, 0.866925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408177,-99) , 
0, 0.573049, 1, 0, 0.600964,-99) , 
3, 1.0516, 0, 0, 0.698912,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.208067,-99) , 
3, -0.28269, 0, 0, 0.514921,-99)    );
  // itree = 1787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38395, 0, 1, 0.768551,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333822,-99) , 
2, -0.161756, 1, 0, 0.438692,-99) , 
NN(
0, 
0, 
-1, -1.08546, 0, -1, 0.155556,-99) , 
3, -0.35011, 0, 0, 0.251836,-99) , 
3, 0.183842, 0, 0, 0.498607,-99)    );
  // itree = 1788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.796548,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295505,-99) , 
0, 0.017816, 1, 0, 0.54957,-99) , 
3, 0.559728, 0, 0, 0.692217,-99) , 
NN(
0, 
0, 
-1, -1.03667, 0, -1, 0.172114,-99) , 
3, -0.314014, 0, 0, 0.47822,-99)    );
  // itree = 1789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.10402, 0, 1, 0.692776,-99) , 
NN(
0, 
0, 
-1, -1.09402, 0, -1, 0.240651,-99) , 
3, -0.207894, 0, 0, 0.530132,-99)    );
  // itree = 1790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.67851, 0, 1, 0.821843,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26411,-99) , 
0, -0.00427319, 1, 0, 0.522095,-99) , 
3, 0.540529, 0, 0, 0.718864,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.205536,-99) , 
3, -0.123397, 0, 0, 0.518375,-99)    );
  // itree = 1791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51859, 1, 1, 0.798271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297077,-99) , 
0, -0.0708108, 1, 0, 0.535984,-99) , 
3, 0.563337, 0, 0, 0.694362,-99) , 
NN(
0, 
0, 
-1, -1.0868, 0, -1, 0.239271,-99) , 
3, -0.10679, 0, 0, 0.496263,-99)    );
  // itree = 1792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.879607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410164,-99) , 
0, 0.969877, 1, 0, 0.664516,-99) , 
3, 1.15416, 0, 0, 0.776362,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311707,-99) , 
0, -0.5694, 1, 0, 0.492971,-99) , 
NN(
0, 
0, 
-1, -1.35345, 0, -1, 0.171968,-99) , 
3, -0.44674, 0, 0, 0.303887,-99) , 
3, 0.355994, 0, 0, 0.510453,-99)    );
  // itree = 1793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.90497, 1, 1, 0.860431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36568,-99) , 
0, 0.429002, 1, 0, 0.590448,-99) , 
3, 1.14627, 0, 0, 0.682889,-99) , 
NN(
0, 
0, 
-1, -0.963597, 0, -1, 0.187949,-99) , 
3, -0.210183, 0, 0, 0.487893,-99)    );
  // itree = 1794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.7846, 1, 1, 0.805229,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2818,-99) , 
0, -0.128842, 1, 0, 0.45931,-99) , 
3, 0.669614, 0, 0, 0.629155,-99) , 
NN(
0, 
0, 
-1, -0.951672, 0, -1, 0.150823,-99) , 
3, -0.460729, 0, 0, 0.463965,-99)    );
  // itree = 1795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27925, 1, 1, 0.895258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495073,-99) , 
0, 0.248173, 1, 0, 0.636103,-99) , 
3, 1.21128, 0, 0, 0.73576,-99) , 
NN(
0, 
0, 
-1, -0.538446, 0, -1, 0.225828,-99) , 
3, -0.00187935, 0, 0, 0.502486,-99)    );
  // itree = 1796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.31524, 1, 1, 0.922554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405344,-99) , 
3, 1.21268, 0, 0, 0.679768,-99) , 
0, 0.7846, 1, 0, 0.755149,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294429,-99) , 
1, -0.252142, 1, 0, 0.389337,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.111874,-99) , 
3, -1.08906, 0, 0, 0.2998,-99) , 
3, 0.262941, 0, 0, 0.508201,-99)    );
  // itree = 1797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.715053, 0, 1, 0.895352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.816129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375859,-99) , 
3, 1.08418, 0, 0, 0.67558,-99) , 
0, 0.675485, 1, 0, 0.736286,-99) , 
NN(
0, 
0, 
-1, -0.95623, 0, -1, 0.274315,-99) , 
3, 0.306962, 0, 0, 0.48003,-99)    );
  // itree = 1798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.825972,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398261,-99) , 
0, 0.191795, 1, 0, 0.56959,-99) , 
3, 0.844384, 0, 0, 0.691727,-99) , 
NN(
0, 
0, 
-1, -1.53574, 1, -1, 0.234442,-99) , 
3, -0.260696, 0, 0, 0.523384,-99)    );
  // itree = 1799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15677, 1, 1, 0.863414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265359,-99) , 
0, 1.09601, 1, 0, 0.584316,-99) , 
3, 1.08045, 0, 0, 0.733999,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352965,-99) , 
0, -1.28795, 1, 0, 0.412158,-99) , 
NN(
0, 
0, 
-1, -0.257029, 1, -1, 0.109708,-99) , 
3, -1.08906, 0, 0, 0.293085,-99) , 
3, 0.262941, 0, 0, 0.506654,-99)    );
  // itree = 1800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.306083, 1, 1, 0.781192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334958,-99) , 
0, -0.303416, 1, 0, 0.486555,-99) , 
3, 0.315736, 0, 0, 0.684282,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.156192,-99) , 
3, -0.376892, 0, 0, 0.468865,-99)    );
  // itree = 1801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.580277, 0, 1, 0.753089,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642113,-99) , 
NN(
0, 
0, 
-1, -1.17656, 1, -1, 0.208514,-99) , 
3, -0.0913569, 0, 0, 0.265766,-99) , 
3, 0.178444, 0, 0, 0.499293,-99)    );
  // itree = 1802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.807603,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291039,-99) , 
0, 0.0591018, 1, 0, 0.496816,-99) , 
3, 0.527981, 0, 0, 0.675499,-99) , 
NN(
0, 
0, 
-1, -1.63151, 0, -1, 0.202753,-99) , 
3, -0.38184, 0, 0, 0.495611,-99)    );
  // itree = 1803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.3205, 0, 1, 0.696739,-99) , 
NN(
0, 
0, 
-1, -0.502825, 0, -1, 0.209163,-99) , 
3, -0.207894, 0, 0, 0.501788,-99)    );
  // itree = 1804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.862306,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376233,-99) , 
0, 0.738515, 1, 0, 0.613483,-99) , 
3, 1.0874, 0, 0, 0.69752,-99) , 
NN(
0, 
0, 
-1, -1.72234, 0, -1, 0.226729,-99) , 
3, -0.639447, 0, 0, 0.578511,-99)    );
  // itree = 1805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.868173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282241,-99) , 
0, 0.759821, 1, 0, 0.604038,-99) , 
3, 1.12392, 0, 0, 0.722425,-99) , 
NN(
0, 
0, 
-1, -0.176887, 0, -1, 0.25168,-99) , 
3, 0.0990605, 0, 0, 0.495406,-99)    );
  // itree = 1806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.75053, 0, 1, 0.833497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274328,-99) , 
0, 0.708301, 1, 0, 0.595058,-99) , 
3, 1.12051, 0, 0, 0.68721,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.147303,-99) , 
0, -1.29706, 1, 0, 0.323918,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.102147,-99) , 
3, -1.08414, 0, 0, 0.214066,-99) , 
3, -0.202496, 0, 0, 0.486663,-99)    );
  // itree = 1807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5287, 1, 1, 0.832107,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376865,-99) , 
0, 0.100183, 1, 0, 0.611803,-99) , 
3, 0.70751, 0, 0, 0.745048,-99) , 
NN(
0, 
0, 
-1, -0.993962, 0, -1, 0.240676,-99) , 
3, 0.093663, 0, 0, 0.494889,-99)    );
  // itree = 1808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.6102, 1, 1, 0.88021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337673,-99) , 
0, 0.671745, 1, 0, 0.578977,-99) , 
3, 1.3205, 0, 0, 0.663955,-99) , 
NN(
0, 
0, 
-1, -1.08857, 0, -1, 0.221215,-99) , 
3, -0.207894, 0, 0, 0.485199,-99)    );
  // itree = 1809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.857056,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319129,-99) , 
0, 0.830092, 1, 0, 0.621631,-99) , 
3, 1.17884, 0, 0, 0.725744,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227578,-99) , 
0, -0.603543, 1, 0, 0.360069,-99) , 
NN(
0, 
0, 
-1, -0.300802, 1, -1, 0.129271,-99) , 
3, -0.623676, 0, 0, 0.227427,-99) , 
3, 0.178444, 0, 0, 0.462372,-99)    );
  // itree = 1810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.46764, 1, 1, 0.867887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4048,-99) , 
0, 0.904545, 1, 0, 0.635064,-99) , 
3, 1.21436, 0, 0, 0.736934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512505,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.190353,-99) , 
3, -0.376357, 0, 0, 0.286452,-99) , 
3, 0.17816, 0, 0, 0.503293,-99)    );
  // itree = 1811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.85474, 1, 1, 0.834377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303341,-99) , 
0, 0.465064, 1, 0, 0.544023,-99) , 
3, 0.937007, 0, 0, 0.676469,-99) , 
NN(
0, 
0, 
-1, -1.16979, 0, -1, 0.206817,-99) , 
3, -0.18324, 0, 0, 0.477335,-99)    );
  // itree = 1812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.689612, 1, 1, 0.77387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452426,-99) , 
3, 0.105482, 0, 0, 0.696649,-99) , 
NN(
0, 
0, 
-1, -1.18323, 0, -1, 0.140816,-99) , 
3, -0.639447, 0, 0, 0.527598,-99)    );
  // itree = 1813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60258, 1, 1, 0.855181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455877,-99) , 
0, 0.829465, 1, 0, 0.681971,-99) , 
3, 1.21877, 0, 0, 0.756641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636218,-99) , 
NN(
0, 
0, 
-1, -1.25551, 0, -1, 0.178922,-99) , 
3, -0.0593009, 0, 0, 0.257659,-99) , 
3, 0.254861, 0, 0, 0.491063,-99)    );
  // itree = 1814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.876076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347365,-99) , 
0, 0.92467, 1, 0, 0.58546,-99) , 
3, 1.31981, 0, 0, 0.674827,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.195188,-99) , 
3, -0.304384, 0, 0, 0.502342,-99)    );
  // itree = 1815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.881541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453666,-99) , 
0, 0.900482, 1, 0, 0.702901,-99) , 
3, 1.38261, 0, 0, 0.768695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776966,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314114,-99) , 
0, -1.44513, 1, 0, 0.399795,-99) , 
NN(
0, 
0, 
-1, -2.93909, 1, -1, 0.0740102,-99) , 
3, -1.15836, 0, 0, 0.292061,-99) , 
3, 0.178444, 0, 0, 0.521696,-99)    );
  // itree = 1816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.32758, 0, 1, 0.745183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268921,-99) , 
0, -1.2877, 1, 0, 0.365608,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0912716,-99) , 
3, -1.00022, 0, 0, 0.236411,-99) , 
3, 0.0990605, 0, 0, 0.492828,-99)    );
  // itree = 1817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36906, 0, 1, 0.702574,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253639,-99) , 
0, -1.21605, 1, 0, 0.391631,-99) , 
NN(
0, 
0, 
-1, -2.85873, 1, -1, 0.0971959,-99) , 
3, -1.09998, 0, 0, 0.249273,-99) , 
3, -0.140306, 0, 0, 0.515647,-99)    );
  // itree = 1818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.66249, 0, 1, 0.73169,-99) , 
NN(
0, 
0, 
-1, -0.59001, 0, -1, 0.213792,-99) , 
3, -0.103721, 0, 0, 0.511535,-99)    );
  // itree = 1819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49342, 0, 1, 0.762247,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367096,-99) , 
1, -0.307423, 1, 0, 0.500068,-99) , 
3, 0.540529, 0, 0, 0.66276,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.205957,-99) , 
3, -0.123397, 0, 0, 0.470788,-99)    );
  // itree = 1820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4815, 0, 1, 0.844733,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24581,-99) , 
0, 0.848875, 1, 0, 0.568553,-99) , 
3, 0.990695, 0, 0, 0.67312,-99) , 
NN(
0, 
0, 
-1, -1.12717, 0, -1, 0.203217,-99) , 
3, -0.376892, 0, 0, 0.49346,-99)    );
  // itree = 1821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.994116, 1, 1, 0.80819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.951885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41936,-99) , 
0, -0.596335, 1, 0, 0.55906,-99) , 
3, 0.543354, 0, 0, 0.712886,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215309,-99) , 
0, -1.23094, 1, 0, 0.358304,-99) , 
NN(
0, 
0, 
-1, -0.0752484, 1, -1, 0.0714416,-99) , 
3, -1.04288, 0, 0, 0.224111,-99) , 
3, -0.123397, 0, 0, 0.507417,-99)    );
  // itree = 1822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.850773,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422856,-99) , 
0, 0.256929, 1, 0, 0.634785,-99) , 
3, 0.869177, 0, 0, 0.737512,-99) , 
NN(
0, 
0, 
-1, -0.721913, 0, -1, 0.25035,-99) , 
3, -0.237768, 0, 0, 0.533632,-99)    );
  // itree = 1823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.829853,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220405,-99) , 
0, 0.489422, 1, 0, 0.551434,-99) , 
3, 0.845703, 0, 0, 0.689657,-99) , 
NN(
0, 
0, 
-1, -1.06543, 0, -1, 0.159844,-99) , 
3, -0.304384, 0, 0, 0.475455,-99)    );
  // itree = 1824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0241435, 1, 1, 0.799442,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657168,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295239,-99) , 
3, -0.0727752, 0, 0, 0.379839,-99) , 
NN(
0, 
0, 
-1, -1.79364, 0, -1, 0.0882572,-99) , 
3, -1.02456, 0, 0, 0.257012,-99) , 
3, 0.238103, 0, 0, 0.503524,-99)    );
  // itree = 1825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.43473, 0, 1, 0.778433,-99) , 
NN(
0, 
0, 
-1, -0.518397, 0, -1, 0.271892,-99) , 
3, 0.017859, 0, 0, 0.53108,-99)    );
  // itree = 1826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.872565, 0, 1, 0.883879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39341,-99) , 
3, 1.13907, 0, 0, 0.673759,-99) , 
0, 0.840984, 1, 0, 0.748974,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309658,-99) , 
0, -0.991976, 1, 0, 0.42076,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.121553,-99) , 
3, -0.95623, 0, 0, 0.309188,-99) , 
3, 0.306962, 0, 0, 0.518188,-99)    );
  // itree = 1827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.06104, 0, 1, 0.813909,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70181,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327507,-99) , 
0, 0.245926, 1, 0, 0.536188,-99) , 
3, 0.694518, 0, 0, 0.678936,-99) , 
NN(
0, 
0, 
-1, -0.955363, 0, -1, 0.205893,-99) , 
3, -0.210183, 0, 0, 0.475811,-99)    );
  // itree = 1828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81172, 1, 1, 0.880873,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397879,-99) , 
0, 0.877072, 1, 0, 0.642035,-99) , 
3, 1.21373, 0, 0, 0.728331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529424,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.188181,-99) , 
3, -0.425552, 0, 0, 0.254835,-99) , 
3, -0.123397, 0, 0, 0.517648,-99)    );
  // itree = 1829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80012, 1, 1, 0.87145,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294971,-99) , 
0, 1.36146, 1, 0, 0.645185,-99) , 
3, 1.34147, 0, 0, 0.716938,-99) , 
NN(
0, 
0, 
-1, -0.584278, 0, -1, 0.190487,-99) , 
3, -0.0499603, 0, 0, 0.46947,-99)    );
  // itree = 1830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.33157, 0, 1, 0.834368,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32402,-99) , 
0, 0.43111, 1, 0, 0.535803,-99) , 
3, 0.815248, 0, 0, 0.665744,-99) , 
NN(
0, 
0, 
-1, -1.2914, 0, -1, 0.121895,-99) , 
3, -0.636613, 0, 0, 0.507004,-99)    );
  // itree = 1831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.36197, 1, 1, 0.771865,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423022,-99) , 
2, 0.0512045, 1, 0, 0.553668,-99) , 
3, 0.331774, 0, 0, 0.712732,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.222086,-99) , 
3, -0.123397, 0, 0, 0.508241,-99)    );
  // itree = 1832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2248, 0, 1, 0.77232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468212,-99) , 
3, 0.235551, 0, 0, 0.698013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520966,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.134003,-99) , 
3, -0.494716, 0, 0, 0.204391,-99) , 
3, -0.202496, 0, 0, 0.481804,-99)    );
  // itree = 1833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82535, 1, 1, 0.896173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348247,-99) , 
0, 0.957246, 1, 0, 0.603891,-99) , 
3, 1.36979, 0, 0, 0.689927,-99) , 
NN(
0, 
0, 
-1, -0.959795, 0, -1, 0.182106,-99) , 
3, -0.210183, 0, 0, 0.469972,-99)    );
  // itree = 1834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.876187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316691,-99) , 
0, 1.12335, 1, 0, 0.669942,-99) , 
3, 1.21436, 0, 0, 0.762848,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363149,-99) , 
3, -0.0817436, 0, 0, 0.480281,-99) , 
NN(
0, 
0, 
-1, -1.12583, 0, -1, 0.179227,-99) , 
3, -0.376357, 0, 0, 0.281407,-99) , 
3, 0.17816, 0, 0, 0.526231,-99)    );
  // itree = 1835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5443, 1, 1, 0.873184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415383,-99) , 
0, 1.36884, 1, 0, 0.723289,-99) , 
3, 1.45117, 0, 0, 0.769991,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218531,-99) , 
0, -1.27491, 1, 0, 0.315692,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.134778,-99) , 
3, -1.04325, 0, 0, 0.24173,-99) , 
3, 0.0319938, 0, 0, 0.515776,-99)    );
  // itree = 1836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8676, 1, 1, 0.854544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280269,-99) , 
0, 0.871083, 1, 0, 0.577977,-99) , 
3, 0.98281, 0, 0, 0.69673,-99) , 
NN(
0, 
0, 
-1, -1.59908, 0, -1, 0.23393,-99) , 
3, -0.123397, 0, 0, 0.497363,-99)    );
  // itree = 1837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82244, 1, 1, 0.849764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367201,-99) , 
0, 0.852865, 1, 0, 0.654995,-99) , 
3, 1.07833, 0, 0, 0.75561,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272026,-99) , 
0, -0.807713, 1, 0, 0.405129,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.178406,-99) , 
3, -0.549899, 0, 0, 0.276716,-99) , 
3, 0.262941, 0, 0, 0.498706,-99)    );
  // itree = 1838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.860702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37869,-99) , 
0, 1.09344, 1, 0, 0.658487,-99) , 
3, 1.42103, 0, 0, 0.724451,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294033,-99) , 
1, -0.472421, 1, 0, 0.3641,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.112404,-99) , 
3, -0.935822, 0, 0, 0.257838,-99) , 
3, 0.17816, 0, 0, 0.480496,-99)    );
  // itree = 1839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.882919,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369582,-99) , 
0, 0.598678, 1, 0, 0.612622,-99) , 
3, 1.16246, 0, 0, 0.706099,-99) , 
NN(
0, 
0, 
-1, -1.17011, 0, -1, 0.188974,-99) , 
3, -0.18324, 0, 0, 0.49066,-99)    );
  // itree = 1840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.834818,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298948,-99) , 
0, 0.539544, 1, 0, 0.523422,-99) , 
3, 0.990695, 0, 0, 0.644602,-99) , 
NN(
0, 
0, 
-1, -1.37635, 0, -1, 0.153123,-99) , 
3, -0.376892, 0, 0, 0.46612,-99)    );
  // itree = 1841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.35931, 1, 1, 0.86811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350611,-99) , 
0, 0.830092, 1, 0, 0.674223,-99) , 
3, 1.09392, 0, 0, 0.769027,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858207,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303044,-99) , 
0, -1.39151, 1, 0, 0.391477,-99) , 
NN(
0, 
0, 
-1, -0.301872, 1, -1, 0.0723677,-99) , 
3, -1.06644, 0, 0, 0.295626,-99) , 
3, 0.28719, 0, 0, 0.508335,-99)    );
  // itree = 1842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55167, 0, 1, 0.813446,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259209,-99) , 
0, 0.249289, 1, 0, 0.580014,-99) , 
3, 0.666353, 0, 0, 0.705331,-99) , 
NN(
0, 
0, 
-1, -1.66546, 0, -1, 0.22381,-99) , 
3, -0.207894, 0, 0, 0.523076,-99)    );
  // itree = 1843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.82244, 1, 1, 0.831009,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335475,-99) , 
0, 0.738333, 1, 0, 0.61567,-99) , 
3, 1.07541, 0, 0, 0.697473,-99) , 
NN(
0, 
0, 
-1, -1.07066, 0, -1, 0.256919,-99) , 
3, -0.304384, 0, 0, 0.538045,-99)    );
  // itree = 1844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.902808, 1, 1, 0.850496,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22467,-99) , 
0, 0.848875, 1, 0, 0.548819,-99) , 
3, 1.04589, 0, 0, 0.665119,-99) , 
NN(
0, 
0, 
-1, -1.03187, 0, -1, 0.191899,-99) , 
3, -0.287638, 0, 0, 0.480168,-99)    );
  // itree = 1845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.77104, 1, 1, 0.865895,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338932,-99) , 
0, 0.84413, 1, 0, 0.640318,-99) , 
3, 1.17451, 0, 0, 0.735399,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299992,-99) , 
1, -0.654311, 1, 0, 0.38006,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.0838062,-99) , 
3, -1.10507, 0, 0, 0.272427,-99) , 
3, 0.19804, 0, 0, 0.48947,-99)    );
  // itree = 1846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.88229, 1, 1, 0.831291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328778,-99) , 
0, 0.84413, 1, 0, 0.616326,-99) , 
3, 1.00736, 0, 0, 0.72432,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266128,-99) , 
0, -0.76712, 1, 0, 0.46463,-99) , 
NN(
0, 
0, 
-1, -1.1339, 0, -1, 0.189424,-99) , 
3, -0.385641, 0, 0, 0.283892,-99) , 
3, 0.17816, 0, 0, 0.501618,-99)    );
  // itree = 1847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.01879, 1, 1, 0.848757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493063,-99) , 
0, -0.0814742, 1, 0, 0.612139,-99) , 
3, 0.890353, 0, 0, 0.726106,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.206686,-99) , 
3, -0.202496, 0, 0, 0.488586,-99)    );
  // itree = 1848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.15677, 1, 1, 0.849918,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394895,-99) , 
0, 0.449644, 1, 0, 0.635382,-99) , 
3, 0.99324, 0, 0, 0.725078,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.230013,-99) , 
3, -0.123397, 0, 0, 0.509818,-99)    );
  // itree = 1849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.5578, 1, 1, 0.860812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296618,-99) , 
0, 1.22611, 1, 0, 0.595688,-99) , 
3, 1.21373, 0, 0, 0.682981,-99) , 
NN(
0, 
0, 
-1, -1.59854, 0, -1, 0.231318,-99) , 
3, -0.123397, 0, 0, 0.498051,-99)    );
  // itree = 1850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.43703, 1, 1, 0.876977,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375237,-99) , 
0, 0.997828, 1, 0, 0.651515,-99) , 
3, 1.37125, 0, 0, 0.717642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.140588,-99) , 
0, -1.37022, 1, 0, 0.340784,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.0842816,-99) , 
3, -1.21087, 0, 0, 0.218593,-99) , 
3, -0.210183, 0, 0, 0.52343,-99)    );
  // itree = 1851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.882939, 0, 1, 0.808523,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237797,-99) , 
0, -0.0750528, 1, 0, 0.479,-99) , 
NN(
0, 
0, 
-1, -1.12472, 0, -1, 0.15391,-99) , 
3, -0.367075, 0, 0, 0.288094,-99) , 
3, 0.522911, 0, 0, 0.482718,-99)    );
  // itree = 1852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50161, 1, 1, 0.878344,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479718,-99) , 
0, 0.175516, 1, 0, 0.621404,-99) , 
3, 1.20395, 0, 0, 0.717079,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.194232,-99) , 
3, -0.123397, 0, 0, 0.470385,-99)    );
  // itree = 1853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32012, 1, 1, 0.849501,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448041,-99) , 
0, 0.266635, 1, 0, 0.625825,-99) , 
3, 0.920245, 0, 0, 0.746876,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24579,-99) , 
0, -1.23523, 1, 0, 0.394348,-99) , 
NN(
0, 
0, 
-1, -3.02041, 1, -1, 0.0774769,-99) , 
3, -0.998108, 0, 0, 0.246921,-99) , 
3, 0.0990605, 0, 0, 0.510747,-99)    );
  // itree = 1854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.840878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364647,-99) , 
0, 0.0490839, 1, 0, 0.553117,-99) , 
3, 0.563337, 0, 0, 0.736829,-99) , 
NN(
0, 
0, 
-1, -1.07432, 0, -1, 0.24069,-99) , 
3, -0.103721, 0, 0, 0.532583,-99)    );
  // itree = 1855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22572, 1, 1, 0.844571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302995,-99) , 
0, 0.708301, 1, 0, 0.606528,-99) , 
3, 1.00308, 0, 0, 0.701967,-99) , 
NN(
0, 
0, 
-1, -1.07711, 0, -1, 0.22454,-99) , 
3, -0.10679, 0, 0, 0.501625,-99)    );
  // itree = 1856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.869616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431764,-99) , 
0, 0.965494, 1, 0, 0.694318,-99) , 
3, 1.28253, 0, 0, 0.769042,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282984,-99) , 
0, -0.831231, 1, 0, 0.417293,-99) , 
NN(
0, 
0, 
-1, -1.70164, 0, -1, 0.105772,-99) , 
3, -0.826127, 0, 0, 0.264864,-99) , 
3, 0.262941, 0, 0, 0.49284,-99)    );
  // itree = 1857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.66864, 0, 1, 0.897534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33262,-99) , 
3, 1.13907, 0, 0, 0.681998,-99) , 
0, 0.995516, 1, 0, 0.768735,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318039,-99) , 
0, -0.833115, 1, 0, 0.450847,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.166128,-99) , 
3, -0.458139, 0, 0, 0.289824,-99) , 
3, 0.318747, 0, 0, 0.50624,-99)    );
  // itree = 1858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.157808, 1, 1, 0.914132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856013,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486452,-99) , 
3, 1.13727, 0, 0, 0.7424,-99) , 
0, 0.811023, 1, 0, 0.793499,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316835,-99) , 
0, -0.685156, 1, 0, 0.439684,-99) , 
NN(
0, 
0, 
-1, -1.82808, 1, -1, 0.186964,-99) , 
3, -0.329735, 0, 0, 0.279582,-99) , 
3, 0.301115, 0, 0, 0.497155,-99)    );
  // itree = 1859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.522017, 0, 1, 0.881519,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424513,-99) , 
3, 1.32987, 0, 0, 0.692906,-99) , 
0, 1.0939, 1, 0, 0.775013,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327063,-99) , 
1, -0.473945, 1, 0, 0.449001,-99) , 
NN(
0, 
0, 
-1, -1.18156, 0, -1, 0.180957,-99) , 
3, -0.325669, 0, 0, 0.27964,-99) , 
3, 0.306962, 0, 0, 0.489051,-99)    );
  // itree = 1860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.850681,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398169,-99) , 
0, 0.745872, 1, 0, 0.666457,-99) , 
3, 1.00821, 0, 0, 0.766481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276731,-99) , 
0, -0.991976, 1, 0, 0.403344,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.101586,-99) , 
3, -1.12137, 0, 0, 0.299965,-99) , 
3, 0.20809, 0, 0, 0.53335,-99)    );
  // itree = 1861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48893, 1, 1, 0.876306,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396028,-99) , 
0, 0.913325, 1, 0, 0.641755,-99) , 
3, 1.0114, 0, 0, 0.763065,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325961,-99) , 
0, -1.27491, 1, 0, 0.400224,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.127088,-99) , 
3, -1.06001, 0, 0, 0.300576,-99) , 
3, 0.231564, 0, 0, 0.528311,-99)    );
  // itree = 1862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.62901, 0, 1, 0.715241,-99) , 
NN(
0, 
0, 
-1, -0.376357, 0, -1, 0.219778,-99) , 
3, 0.17816, 0, 0, 0.450998,-99)    );
  // itree = 1863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49342, 0, 1, 0.801816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327649,-99) , 
0, -0.0316589, 1, 0, 0.585159,-99) , 
3, 0.543354, 0, 0, 0.726195,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.189285,-99) , 
3, -0.123397, 0, 0, 0.503019,-99)    );
  // itree = 1864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.05335, 1, 1, 0.806849,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394935,-99) , 
0, 0.193081, 1, 0, 0.620485,-99) , 
3, 0.640315, 0, 0, 0.722503,-99) , 
NN(
0, 
0, 
-1, -1.31804, 0, -1, 0.23338,-99) , 
3, -0.304384, 0, 0, 0.551532,-99)    );
  // itree = 1865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.73336, 1, 1, 0.8522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245667,-99) , 
0, 0.587889, 1, 0, 0.553197,-99) , 
3, 0.847775, 0, 0, 0.695505,-99) , 
NN(
0, 
0, 
-1, -1.32847, 0, -1, 0.197903,-99) , 
3, -0.304384, 0, 0, 0.501392,-99)    );
  // itree = 1866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.311772, 1, 1, 0.764868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473949,-99) , 
3, 0.251814, 0, 0, 0.706745,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160504,-99) , 
0, -1.54441, 1, 0, 0.27957,-99) , 
NN(
0, 
0, 
-1, 0.0526353, 1, -1, 0.0938535,-99) , 
3, -1.36791, 0, 0, 0.21953,-99) , 
3, -0.202496, 0, 0, 0.494965,-99)    );
  // itree = 1867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.856603,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362872,-99) , 
0, 0.965494, 1, 0, 0.621517,-99) , 
3, 1.21404, 0, 0, 0.71842,-99) , 
NN(
0, 
0, 
-1, -0.379167, 0, -1, 0.234928,-99) , 
3, 0.17816, 0, 0, 0.46422,-99)    );
  // itree = 1868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49761, 1, 1, 0.840805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385155,-99) , 
0, 0.397804, 1, 0, 0.580136,-99) , 
3, 0.99324, 0, 0, 0.693659,-99) , 
NN(
0, 
0, 
-1, -0.714015, 0, -1, 0.229327,-99) , 
3, -0.123397, 0, 0, 0.49881,-99)    );
  // itree = 1869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80817, 1, 1, 0.862047,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34176,-99) , 
0, 0.958348, 1, 0, 0.663277,-99) , 
3, 1.21404, 0, 0, 0.748156,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339076,-99) , 
0, -0.646644, 1, 0, 0.489291,-99) , 
NN(
0, 
0, 
-1, -1.12594, 0, -1, 0.178091,-99) , 
3, -0.376357, 0, 0, 0.278867,-99) , 
3, 0.17816, 0, 0, 0.504967,-99)    );
  // itree = 1870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.828415, 0, 1, 0.856707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372394,-99) , 
3, 1.39432, 0, 0, 0.643876,-99) , 
0, 1.11792, 1, 0, 0.738437,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665615,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359638,-99) , 
0, -0.773268, 1, 0, 0.469664,-99) , 
NN(
0, 
0, 
-1, -1.25613, 0, -1, 0.177767,-99) , 
3, -0.399179, 0, 0, 0.280944,-99) , 
3, 0.234307, 0, 0, 0.489629,-99)    );
  // itree = 1871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.70177, 0, 1, 0.785929,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344616,-99) , 
1, -0.471534, 1, 0, 0.496453,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.150675,-99) , 
3, -0.52447, 0, 0, 0.302065,-99) , 
3, 0.28719, 0, 0, 0.522064,-99)    );
  // itree = 1872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40187, 1, 1, 0.845572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.774856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435098,-99) , 
0, 0.0253361, 1, 0, 0.57253,-99) , 
3, 1.07643, 0, 0, 0.67628,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174128,-99) , 
0, -1.6609, 1, 0, 0.281717,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.0997969,-99) , 
3, -1.31804, 0, 0, 0.216071,-99) , 
3, -0.304384, 0, 0, 0.495398,-99)    );
  // itree = 1873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53605, 0, 1, 0.804951,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353553,-99) , 
0, -0.0349451, 1, 0, 0.582228,-99) , 
3, 0.603091, 0, 0, 0.703322,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.147157,-99) , 
3, -0.639447, 0, 0, 0.54818,-99)    );
  // itree = 1874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58511, 0, 1, 0.839925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435834,-99) , 
0, 0.298494, 1, 0, 0.630539,-99) , 
3, 1.11353, 0, 0, 0.72201,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249371,-99) , 
0, -0.85877, 1, 0, 0.421146,-99) , 
NN(
0, 
0, 
-1, -0.19331, 1, -1, 0.133452,-99) , 
3, -0.993962, 0, 0, 0.293746,-99) , 
3, 0.093663, 0, 0, 0.510829,-99)    );
  // itree = 1875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.884411, 1, 1, 0.839462,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360163,-99) , 
0, 0.451753, 1, 0, 0.616973,-99) , 
3, 0.845703, 0, 0, 0.728038,-99) , 
NN(
0, 
0, 
-1, -1.06766, 0, -1, 0.156148,-99) , 
3, -0.304384, 0, 0, 0.488279,-99)    );
  // itree = 1876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.528419, 0, 1, 0.931139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366692,-99) , 
3, 1.16913, 0, 0, 0.679055,-99) , 
0, 0.731369, 1, 0, 0.75315,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187536,-99) , 
0, -0.538822, 1, 0, 0.377742,-99) , 
NN(
0, 
0, 
-1, -1.49162, 0, -1, 0.128049,-99) , 
3, -0.820157, 0, 0, 0.251881,-99) , 
3, 0.262941, 0, 0, 0.472801,-99)    );
  // itree = 1877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.2801, 0, 1, 0.813854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237814,-99) , 
0, 0.471446, 1, 0, 0.50372,-99) , 
3, 0.746767, 0, 0, 0.648412,-99) , 
NN(
0, 
0, 
-1, -1.37572, 0, -1, 0.131041,-99) , 
3, -0.711955, 0, 0, 0.50746,-99)    );
  // itree = 1878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.714887, 1, 1, 0.788804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331674,-99) , 
0, 0.0950841, 1, 0, 0.575349,-99) , 
3, 0.540529, 0, 0, 0.709309,-99) , 
NN(
0, 
0, 
-1, -1.0136, 0, -1, 0.224189,-99) , 
3, -0.123397, 0, 0, 0.515424,-99)    );
  // itree = 1879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5972, 0, 1, 0.852457,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309649,-99) , 
0, 0.587889, 1, 0, 0.604364,-99) , 
3, 0.979269, 0, 0, 0.709699,-99) , 
NN(
0, 
0, 
-1, -1.0375, 0, -1, 0.212465,-99) , 
3, -0.318757, 0, 0, 0.519712,-99)    );
  // itree = 1880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92838, 1, 1, 0.86775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315171,-99) , 
0, 1.0116, 1, 0, 0.630725,-99) , 
3, 1.32689, 0, 0, 0.71253,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.217517,-99) , 
3, -0.202496, 0, 0, 0.512406,-99)    );
  // itree = 1881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.434082, 1, 1, 0.944066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.854722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477545,-99) , 
3, 1.21902, 0, 0, 0.715685,-99) , 
0, 0.702317, 1, 0, 0.782049,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675795,-99) , 
NN(
0, 
0, 
-1, -1.14756, 0, -1, 0.260948,-99) , 
3, 0.0703839, 0, 0, 0.31892,-99) , 
3, 0.392653, 0, 0, 0.51834,-99)    );
  // itree = 1882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0924789, 0, 1, 0.950698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458017,-99) , 
3, 1.32409, 0, 0, 0.685922,-99) , 
0, 0.702317, 1, 0, 0.757906,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248384,-99) , 
1, -0.289724, 1, 0, 0.360467,-99) , 
NN(
0, 
0, 
-1, -2.13371, 1, -1, 0.100954,-99) , 
3, -0.957285, 0, 0, 0.254007,-99) , 
3, 0.306962, 0, 0, 0.46329,-99)    );
  // itree = 1883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42098, 1, 1, 0.833143,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.909006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358492,-99) , 
0, 0.453531, 1, 0, 0.608764,-99) , 
3, 0.802712, 0, 0, 0.749087,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34978,-99) , 
3, -0.0377893, 0, 0, 0.468501,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.238035,-99) , 
3, -0.379167, 0, 0, 0.327429,-99) , 
3, 0.17816, 0, 0, 0.536502,-99)    );
  // itree = 1884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39222, 1, 1, 0.873944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353595,-99) , 
0, 1.89144, 1, 0, 0.710617,-99) , 
3, 1.66579, 0, 0, 0.75361,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317068,-99) , 
0, -1.18666, 1, 0, 0.392966,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.118043,-99) , 
3, -0.957285, 0, 0, 0.272443,-99) , 
3, 0.306962, 0, 0, 0.481375,-99)    );
  // itree = 1885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.48336, 1, 1, 0.841259,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425308,-99) , 
0, 0.279125, 1, 0, 0.607174,-99) , 
3, 0.806489, 0, 0, 0.756577,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288389,-99) , 
0, -1.32055, 1, 0, 0.38888,-99) , 
NN(
0, 
0, 
-1, -2.12664, 1, -1, 0.0973097,-99) , 
3, -0.945752, 0, 0, 0.25727,-99) , 
3, 0.17816, 0, 0, 0.493766,-99)    );
  // itree = 1886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.36118, 1, 1, 0.877766,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498233,-99) , 
0, 0.900482, 1, 0, 0.664526,-99) , 
3, 1.41574, 0, 0, 0.741754,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319769,-99) , 
0, -1.25537, 1, 0, 0.39136,-99) , 
NN(
0, 
0, 
-1, -2.51191, 1, -1, 0.155677,-99) , 
3, -0.997806, 0, 0, 0.301413,-99) , 
3, 0.254861, 0, 0, 0.488461,-99)    );
  // itree = 1887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.973636,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458759,-99) , 
3, 1.0454, 0, 0, 0.695743,-99) , 
0, 0.214248, 1, 0, 0.748599,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338987,-99) , 
0, -0.979963, 1, 0, 0.446717,-99) , 
NN(
0, 
0, 
-1, -1.86037, 1, -1, 0.15823,-99) , 
3, -0.518397, 0, 0, 0.26041,-99) , 
3, 0.017859, 0, 0, 0.510481,-99)    );
  // itree = 1888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.854939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441611,-99) , 
0, 0.92467, 1, 0, 0.626065,-99) , 
3, 1.28172, 0, 0, 0.700408,-99) , 
NN(
0, 
0, 
-1, -1.02307, 0, -1, 0.19362,-99) , 
3, -0.28269, 0, 0, 0.495591,-99)    );
  // itree = 1889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.32462, 0, 1, 0.82215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320741,-99) , 
0, 0.449644, 1, 0, 0.559665,-99) , 
3, 0.98281, 0, 0, 0.670478,-99) , 
NN(
0, 
0, 
-1, -0.71804, 0, -1, 0.259146,-99) , 
3, -0.123397, 0, 0, 0.512436,-99)    );
  // itree = 1890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.03326, 0, 1, 0.891274,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446783,-99) , 
3, 1.48725, 0, 0, 0.675443,-99) , 
0, 1.55639, 1, 0, 0.800977,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325189,-99) , 
0, -0.62041, 1, 0, 0.46436,-99) , 
NN(
0, 
0, 
-1, -1.42167, 0, -1, 0.111924,-99) , 
3, -0.768214, 0, 0, 0.297228,-99) , 
3, 0.307824, 0, 0, 0.517676,-99)    );
  // itree = 1891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.702317, 1, 1, 0.768555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462169,-99) , 
1, -0.471534, 1, 0, 0.53832,-99) , 
3, 0.320265, 0, 0, 0.699665,-99) , 
NN(
0, 
0, 
-1, -0.827936, 0, -1, 0.176788,-99) , 
3, -0.344168, 0, 0, 0.516104,-99)    );
  // itree = 1892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.778492, 1, 1, 0.773876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290415,-99) , 
0, -0.367047, 1, 0, 0.484223,-99) , 
3, 0.248997, 0, 0, 0.686458,-99) , 
NN(
0, 
0, 
-1, -1.17871, 0, -1, 0.198243,-99) , 
3, -0.43837, 0, 0, 0.510933,-99)    );
  // itree = 1893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50704, 1, 1, 0.88927,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266195,-99) , 
0, 1.45058, 1, 0, 0.674633,-99) , 
3, 1.37777, 0, 0, 0.766946,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.125835,-99) , 
0, -0.0803151, 1, 0, 0.382939,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.125078,-99) , 
3, -1.20576, 0, 0, 0.310138,-99) , 
3, 0.392653, 0, 0, 0.507796,-99)    );
  // itree = 1894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.764647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321669,-99) , 
1, -0.250541, 1, 0, 0.458193,-99) , 
3, 0.272348, 0, 0, 0.647549,-99) , 
NN(
0, 
0, 
-1, -2.5512, 1, -1, 0.120997,-99) , 
3, -0.711955, 0, 0, 0.503497,-99)    );
  // itree = 1895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50848, 1, 1, 0.878177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417825,-99) , 
0, 0.957246, 1, 0, 0.637609,-99) , 
3, 1.3205, 0, 0, 0.71373,-99) , 
NN(
0, 
0, 
-1, -0.802175, 0, -1, 0.177353,-99) , 
3, -0.207894, 0, 0, 0.476116,-99)    );
  // itree = 1896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58511, 0, 1, 0.867648,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434862,-99) , 
0, 0.539227, 1, 0, 0.645257,-99) , 
3, 1.11353, 0, 0, 0.746215,-99) , 
NN(
0, 
0, 
-1, -0.726681, 0, -1, 0.272544,-99) , 
3, 0.093663, 0, 0, 0.5264,-99)    );
  // itree = 1897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.804906,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324431,-99) , 
0, 0.16271, 1, 0, 0.503161,-99) , 
3, 0.770686, 0, 0, 0.656446,-99) , 
NN(
0, 
0, 
-1, -1.16595, 0, -1, 0.147759,-99) , 
3, -0.303436, 0, 0, 0.457925,-99)    );
  // itree = 1898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.568794, 0, 1, 0.89382,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392849,-99) , 
3, 1.36576, 0, 0, 0.655847,-99) , 
0, 1.06258, 1, 0, 0.75626,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29559,-99) , 
0, -0.760074, 1, 0, 0.430804,-99) , 
NN(
0, 
0, 
-1, -0.279363, 1, -1, 0.103675,-99) , 
3, -0.959868, 0, 0, 0.296478,-99) , 
3, 0.306962, 0, 0, 0.497083,-99)    );
  // itree = 1899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.86406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386981,-99) , 
0, 0.420974, 1, 0, 0.597203,-99) , 
3, 1.11225, 0, 0, 0.706752,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509369,-99) , 
NN(
0, 
0, 
-1, -1.05846, 0, -1, 0.195745,-99) , 
3, -0.496803, 0, 0, 0.264251,-99) , 
3, -0.202496, 0, 0, 0.529038,-99)    );
  // itree = 1900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.57239, 0, 1, 0.772341,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262132,-99) , 
0, -0.226041, 1, 0, 0.430845,-99) , 
NN(
0, 
0, 
-1, -1.11701, 0, -1, 0.127575,-99) , 
3, -0.568264, 0, 0, 0.271833,-99) , 
3, 0.392653, 0, 0, 0.486635,-99)    );
  // itree = 1901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.843583,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431038,-99) , 
0, 0.429002, 1, 0, 0.608292,-99) , 
3, 1.16246, 0, 0, 0.698799,-99) , 
NN(
0, 
0, 
-1, -0.67706, 0, -1, 0.200791,-99) , 
3, -0.18324, 0, 0, 0.493441,-99)    );
  // itree = 1902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.752012,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310437,-99) , 
0, -0.676329, 1, 0, 0.445562,-99) , 
3, 0.299337, 0, 0, 0.64517,-99) , 
NN(
0, 
0, 
-1, -0.885095, 0, -1, 0.174766,-99) , 
3, -0.38184, 0, 0, 0.473729,-99)    );
  // itree = 1903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.675485, 1, 1, 0.815722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251914,-99) , 
0, 0.0538351, 1, 0, 0.518773,-99) , 
3, 0.543354, 0, 0, 0.703135,-99) , 
NN(
0, 
0, 
-1, -1.00946, 0, -1, 0.219634,-99) , 
3, -0.123397, 0, 0, 0.495209,-99)    );
  // itree = 1904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.879855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389852,-99) , 
0, 1.14512, 1, 0, 0.670105,-99) , 
3, 1.39736, 0, 0, 0.747137,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317374,-99) , 
0, -1.44513, 1, 0, 0.42841,-99) , 
NN(
0, 
0, 
-1, -2.4918, 1, -1, 0.117625,-99) , 
3, -1.1262, 0, 0, 0.303936,-99) , 
3, 0.202693, 0, 0, 0.512498,-99)    );
  // itree = 1905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.61235, 1, 1, 0.82969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315889,-99) , 
0, 0.657426, 1, 0, 0.601217,-99) , 
3, 0.909801, 0, 0, 0.726469,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238988,-99) , 
0, -1.39335, 1, 0, 0.369464,-99) , 
NN(
0, 
0, 
-1, -2.49393, 1, -1, 0.0851651,-99) , 
3, -0.997451, 0, 0, 0.249106,-99) , 
3, 0.093663, 0, 0, 0.490112,-99)    );
  // itree = 1906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0717702, 1, 1, 0.846618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264648,-99) , 
3, 1.12392, 0, 0, 0.626206,-99) , 
0, 0.971673, 1, 0, 0.723185,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253954,-99) , 
0, -0.765399, 1, 0, 0.390737,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.167202,-99) , 
3, -0.718998, 0, 0, 0.26978,-99) , 
3, 0.0990605, 0, 0, 0.502597,-99)    );
  // itree = 1907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52012, 1, 1, 0.806534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769703,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288744,-99) , 
0, 0.30413, 1, 0, 0.549111,-99) , 
3, 0.78321, 0, 0, 0.684495,-99) , 
NN(
0, 
0, 
-1, -0.414745, 1, -1, 0.192337,-99) , 
3, -0.103721, 0, 0, 0.463935,-99)    );
  // itree = 1908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.77104, 1, 1, 0.865022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412193,-99) , 
0, 0.922711, 1, 0, 0.65516,-99) , 
3, 1.2782, 0, 0, 0.755029,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248237,-99) , 
0, -0.698726, 1, 0, 0.406589,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.134664,-99) , 
3, -0.95623, 0, 0, 0.307576,-99) , 
3, 0.306962, 0, 0, 0.494626,-99)    );
  // itree = 1909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.26711, 1, 1, 0.83695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373051,-99) , 
0, 0.609608, 1, 0, 0.621436,-99) , 
3, 0.985666, 0, 0, 0.739013,-99) , 
NN(
0, 
0, 
-1, -0.35011, 0, -1, 0.26207,-99) , 
3, 0.183842, 0, 0, 0.487834,-99)    );
  // itree = 1910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.77784, 1, 1, 0.894769,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387083,-99) , 
0, 0.790707, 1, 0, 0.674709,-99) , 
3, 1.07875, 0, 0, 0.798874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59131,-99) , 
NN(
0, 
0, 
-1, -1.22192, 0, -1, 0.2413,-99) , 
3, -0.014745, 0, 0, 0.304117,-99) , 
3, 0.301115, 0, 0, 0.52686,-99)    );
  // itree = 1911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.58371, 1, 1, 0.828555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351447,-99) , 
0, 0.857117, 1, 0, 0.607964,-99) , 
3, 1.10862, 0, 0, 0.691864,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.1899,-99) , 
3, -0.202496, 0, 0, 0.48104,-99)    );
  // itree = 1912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49244, 0, 1, 0.829755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268201,-99) , 
0, -0.0219203, 1, 0, 0.511633,-99) , 
3, 0.543354, 0, 0, 0.713077,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.231297,-99) , 
3, -0.123397, 0, 0, 0.510763,-99)    );
  // itree = 1913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.932931, 1, 1, 0.824841,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354609,-99) , 
0, 0.494896, 1, 0, 0.573702,-99) , 
3, 0.809713, 0, 0, 0.735966,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362687,-99) , 
0, -0.765399, 1, 0, 0.490848,-99) , 
NN(
0, 
0, 
-1, -1.27196, 0, -1, 0.164325,-99) , 
3, -0.587974, 0, 0, 0.307317,-99) , 
3, 0.20809, 0, 0, 0.513455,-99)    );
  // itree = 1914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.92431, 1, 1, 0.85523,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466864,-99) , 
0, -0.0151694, 1, 0, 0.581441,-99) , 
3, 1.09424, 0, 0, 0.685373,-99) , 
NN(
0, 
0, 
-1, -0.702479, 0, -1, 0.164226,-99) , 
3, -0.218424, 0, 0, 0.483242,-99)    );
  // itree = 1915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.50419, 1, 1, 0.853966,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448111,-99) , 
0, 0.753813, 1, 0, 0.662695,-99) , 
3, 1.07833, 0, 0, 0.759481,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591682,-99) , 
NN(
0, 
0, 
-1, -1.0476, 0, -1, 0.234356,-99) , 
3, -0.0136847, 0, 0, 0.287173,-99) , 
3, 0.262941, 0, 0, 0.481292,-99)    );
  // itree = 1916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.82259,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390675,-99) , 
0, 0.082034, 1, 0, 0.570162,-99) , 
3, 0.540529, 0, 0, 0.733451,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.22875,-99) , 
3, -0.123397, 0, 0, 0.52167,-99)    );
  // itree = 1917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58747, 1, 1, 0.863106,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304915,-99) , 
0, 0.94291, 1, 0, 0.593832,-99) , 
3, 1.20395, 0, 0, 0.6863,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224618,-99) , 
0, -1.08285, 1, 0, 0.339497,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.147818,-99) , 
3, -1.00886, 0, 0, 0.251441,-99) , 
3, -0.123397, 0, 0, 0.495205,-99)    );
  // itree = 1918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.848554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.869487,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451921,-99) , 
0, 0.451967, 1, 0, 0.630539,-99) , 
3, 1.10452, 0, 0, 0.727751,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24637,-99) , 
0, -1.18666, 1, 0, 0.357845,-99) , 
NN(
0, 
0, 
-1, -1.80049, 0, -1, 0.138105,-99) , 
3, -0.941052, 0, 0, 0.265062,-99) , 
3, 0.116775, 0, 0, 0.507162,-99)    );
  // itree = 1919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.857332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334039,-99) , 
0, 1.38235, 1, 0, 0.673638,-99) , 
3, 1.3922, 0, 0, 0.746324,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349151,-99) , 
0, -0.76712, 1, 0, 0.494784,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.148071,-99) , 
3, -0.391132, 0, 0, 0.271353,-99) , 
3, 0.238103, 0, 0, 0.48114,-99)    );
  // itree = 1920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10708, 1, 1, 0.795092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363951,-99) , 
0, -0.408768, 1, 0, 0.541378,-99) , 
3, 0.322371, 0, 0, 0.725472,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170306,-99) , 
0, -1.42757, 1, 0, 0.27652,-99) , 
NN(
0, 
0, 
-1, -0.478841, 0, -1, 0.0659201,-99) , 
3, -1.3037, 0, 0, 0.199888,-99) , 
3, -0.123397, 0, 0, 0.505185,-99)    );
  // itree = 1921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.327235, 1, 1, 0.910198,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426532,-99) , 
3, 1.20768, 0, 0, 0.687532,-99) , 
0, 0.698745, 1, 0, 0.755637,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309162,-99) , 
0, -0.566574, 1, 0, 0.458278,-99) , 
NN(
0, 
0, 
-1, -1.26021, 0, -1, 0.156045,-99) , 
3, -0.394308, 0, 0, 0.253472,-99) , 
3, 0.238103, 0, 0, 0.479891,-99)    );
  // itree = 1922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89241, 1, 1, 0.887615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39262,-99) , 
0, 0.911613, 1, 0, 0.644883,-99) , 
3, 1.42729, 0, 0, 0.722386,-99) , 
NN(
0, 
0, 
-1, -0.42341, 0, -1, 0.203959,-99) , 
3, -0.123397, 0, 0, 0.488317,-99)    );
  // itree = 1923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.41582, 0, 1, 0.844694,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277878,-99) , 
0, 0.852865, 1, 0, 0.609825,-99) , 
3, 1.0818, 0, 0, 0.731456,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295805,-99) , 
0, -0.802449, 1, 0, 0.439464,-99) , 
NN(
0, 
0, 
-1, -1.96872, 1, -1, 0.132878,-99) , 
3, -0.549899, 0, 0, 0.257334,-99) , 
3, 0.262941, 0, 0, 0.479345,-99)    );
  // itree = 1924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.88373, 1, 1, 0.880143,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44659,-99) , 
0, 0.45101, 1, 0, 0.609901,-99) , 
3, 1.36979, 0, 0, 0.694387,-99) , 
NN(
0, 
0, 
-1, -1.21087, 0, -1, 0.190466,-99) , 
3, -0.210183, 0, 0, 0.486293,-99)    );
  // itree = 1925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.49573, 0, 1, 0.814703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211877,-99) , 
0, 0.917975, 1, 0, 0.567191,-99) , 
3, 0.979427, 0, 0, 0.668781,-99) , 
NN(
0, 
0, 
-1, -2.20885, 1, -1, 0.170889,-99) , 
3, -0.38184, 0, 0, 0.484301,-99)    );
  // itree = 1926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62101, 1, 1, 0.867302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451398,-99) , 
0, 0.738333, 1, 0, 0.67472,-99) , 
3, 1.09741, 0, 0, 0.755964,-99) , 
NN(
0, 
0, 
-1, -0.66444, 0, -1, 0.230939,-99) , 
3, -0.184392, 0, 0, 0.528238,-99)    );
  // itree = 1927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.60464, 1, 1, 0.870689,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407879,-99) , 
0, 0.966661, 1, 0, 0.591537,-99) , 
3, 1.33203, 0, 0, 0.675326,-99) , 
NN(
0, 
0, 
-1, -1.7385, 0, -1, 0.196306,-99) , 
3, -0.639447, 0, 0, 0.544177,-99)    );
  // itree = 1928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.872112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.89028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343215,-99) , 
0, 0.819377, 1, 0, 0.661177,-99) , 
3, 1.08013, 0, 0, 0.772868,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26495,-99) , 
0, -0.301216, 1, 0, 0.470777,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.153549,-99) , 
3, -0.548378, 0, 0, 0.291431,-99) , 
3, 0.262941, 0, 0, 0.505743,-99)    );
  // itree = 1929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.842234,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339406,-99) , 
0, 0.326902, 1, 0, 0.537686,-99) , 
3, 0.809493, 0, 0, 0.686065,-99) , 
NN(
0, 
0, 
-1, -1.02267, 0, -1, 0.181385,-99) , 
3, -0.299834, 0, 0, 0.488688,-99)    );
  // itree = 1930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.69147, 1, 1, 0.870994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335784,-99) , 
0, 0.501202, 1, 0, 0.563344,-99) , 
3, 0.985696, 0, 0, 0.672634,-99) , 
NN(
0, 
0, 
-1, 0.53526, 1, -1, 0.137895,-99) , 
3, -0.749223, 0, 0, 0.520097,-99)    );
  // itree = 1931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40435, 1, 1, 0.858408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295614,-99) , 
0, 0.943047, 1, 0, 0.637737,-99) , 
3, 1.12392, 0, 0, 0.740968,-99) , 
NN(
0, 
0, 
-1, -0.998108, 0, -1, 0.237518,-99) , 
3, 0.0990605, 0, 0, 0.483469,-99)    );
  // itree = 1932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.770647, 0, 1, 0.90684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345122,-99) , 
3, 1.42058, 0, 0, 0.67862,-99) , 
0, 1.17756, 1, 0, 0.765712,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267973,-99) , 
0, -0.439969, 1, 0, 0.460405,-99) , 
NN(
0, 
0, 
-1, -1.16911, 0, -1, 0.149916,-99) , 
3, -0.47492, 0, 0, 0.286696,-99) , 
3, 0.325234, 0, 0, 0.494585,-99)    );
  // itree = 1933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.300694, 1, 1, 0.929793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343184,-99) , 
3, 0.969328, 0, 0, 0.678225,-99) , 
0, 0.698745, 1, 0, 0.751833,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30592,-99) , 
1, -0.212641, 1, 0, 0.419746,-99) , 
NN(
0, 
0, 
-1, -1.18766, 0, -1, 0.15123,-99) , 
3, -0.495085, 0, 0, 0.277513,-99) , 
3, 0.307824, 0, 0, 0.485089,-99)    );
  // itree = 1934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.911, 1, 1, 0.867936,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268152,-99) , 
0, 1.02331, 1, 0, 0.621718,-99) , 
3, 1.24647, 0, 0, 0.71417,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200061,-99) , 
0, -0.992612, 1, 0, 0.345879,-99) , 
NN(
0, 
0, 
-1, 0.248859, 1, -1, 0.0968536,-99) , 
3, -1.31205, 0, 0, 0.274066,-99) , 
3, 0.0354976, 0, 0, 0.506523,-99)    );
  // itree = 1935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0259, 1, 1, 0.797133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375524,-99) , 
0, -0.0188443, 1, 0, 0.562059,-99) , 
3, 0.829532, 0, 0, 0.669499,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.212867,-99) , 
3, -0.28269, 0, 0, 0.498266,-99)    );
  // itree = 1936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.256001, 1, 1, 0.784664,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249511,-99) , 
0, -0.765399, 1, 0, 0.397438,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.133421,-99) , 
3, -1.12137, 0, 0, 0.297528,-99) , 
3, 0.20809, 0, 0, 0.538794,-99)    );
  // itree = 1937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.52081, 1, 1, 0.830128,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412526,-99) , 
0, -0.0750528, 1, 0, 0.567214,-99) , 
3, 0.845703, 0, 0, 0.689012,-99) , 
NN(
0, 
0, 
-1, -1.07764, 0, -1, 0.178375,-99) , 
3, -0.304384, 0, 0, 0.481248,-99)    );
  // itree = 1938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.58411, 0, 1, 0.822455,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215303,-99) , 
0, 0.358499, 1, 0, 0.42364,-99) , 
NN(
0, 
0, 
-1, -1.41293, 0, -1, 0.144297,-99) , 
3, -0.541636, 0, 0, 0.298594,-99) , 
3, 0.660704, 0, 0, 0.470986,-99)    );
  // itree = 1939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50161, 1, 1, 0.863043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414787,-99) , 
0, 0.369523, 1, 0, 0.550581,-99) , 
3, 1.19627, 0, 0, 0.648031,-99) , 
NN(
0, 
0, 
-1, -2.47601, 1, -1, 0.131745,-99) , 
3, -0.759664, 0, 0, 0.511216,-99)    );
  // itree = 1940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.69147, 1, 1, 0.86531,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292862,-99) , 
0, 0.979653, 1, 0, 0.612861,-99) , 
3, 0.985321, 0, 0, 0.718929,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.226167,-99) , 
3, -0.123397, 0, 0, 0.53216,-99)    );
  // itree = 1941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.70427, 1, 1, 0.878863,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410448,-99) , 
0, 0.511464, 1, 0, 0.617383,-99) , 
3, 1.0077, 0, 0, 0.753696,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326619,-99) , 
0, -0.765399, 1, 0, 0.417016,-99) , 
NN(
0, 
0, 
-1, -1.60447, 0, -1, 0.127133,-99) , 
3, -0.651936, 0, 0, 0.257122,-99) , 
3, 0.17816, 0, 0, 0.491114,-99)    );
  // itree = 1942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.859203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354442,-99) , 
0, 0.738333, 1, 0, 0.612381,-99) , 
3, 1.14817, 0, 0, 0.70234,-99) , 
NN(
0, 
0, 
-1, -0.955363, 0, -1, 0.20444,-99) , 
3, -0.210183, 0, 0, 0.517087,-99)    );
  // itree = 1943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.69149, 0, 1, 0.856441,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749216,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317034,-99) , 
0, 0.920728, 1, 0, 0.603499,-99) , 
3, 1.21925, 0, 0, 0.690321,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181741,-99) , 
0, -1.15081, 1, 0, 0.333287,-99) , 
NN(
0, 
0, 
-1, -2.5158, 1, -1, 0.123219,-99) , 
3, -1.00886, 0, 0, 0.228274,-99) , 
3, -0.123397, 0, 0, 0.483933,-99)    );
  // itree = 1944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.53252, 1, 1, 0.831033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262077,-99) , 
0, 1.0116, 1, 0, 0.589783,-99) , 
3, 1.07643, 0, 0, 0.676494,-99) , 
NN(
0, 
0, 
-1, -0.81518, 0, -1, 0.196688,-99) , 
3, -0.304384, 0, 0, 0.502567,-99)    );
  // itree = 1945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.54858, 1, 1, 0.889329,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351425,-99) , 
0, 0.991237, 1, 0, 0.660599,-99) , 
3, 1.25035, 0, 0, 0.756195,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284366,-99) , 
0, -0.878316, 1, 0, 0.42123,-99) , 
NN(
0, 
0, 
-1, -2.56895, 1, -1, 0.0871416,-99) , 
3, -1.02828, 0, 0, 0.283753,-99) , 
3, 0.27426, 0, 0, 0.501028,-99)    );
  // itree = 1946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.636138, 1, 1, 0.728743,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72232,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193797,-99) , 
0, -1.20764, 1, 0, 0.351718,-99) , 
NN(
0, 
0, 
-1, -2.61685, 1, -1, 0.108743,-99) , 
3, -1.01154, 0, 0, 0.235368,-99) , 
3, -0.123397, 0, 0, 0.511852,-99)    );
  // itree = 1947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.7461, 0, 1, 0.853498,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345174,-99) , 
0, 0.53819, 1, 0, 0.586911,-99) , 
3, 1.12392, 0, 0, 0.707554,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309766,-99) , 
1, -0.38645, 1, 0, 0.406023,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.117858,-99) , 
3, -0.998108, 0, 0, 0.279272,-99) , 
3, 0.0990605, 0, 0, 0.491084,-99)    );
  // itree = 1948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.29221, 1, 1, 0.769422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498117,-99) , 
3, 0.593979, 0, 0, 0.704087,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261336,-99) , 
0, -1.24008, 1, 0, 0.351075,-99) , 
NN(
0, 
0, 
-1, -3.02381, 1, -1, 0.118461,-99) , 
3, -0.932655, 0, 0, 0.25729,-99) , 
3, 0.17816, 0, 0, 0.467211,-99)    );
  // itree = 1949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80567, 1, 1, 0.817852,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397901,-99) , 
0, 0.226562, 1, 0, 0.6059,-99) , 
3, 0.640608, 0, 0, 0.747062,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173015,-99) , 
0, -1.17488, 1, 0, 0.296876,-99) , 
NN(
0, 
0, 
-1, -2.6478, 1, -1, 0.0812568,-99) , 
3, -1.05809, 0, 0, 0.210566,-99) , 
3, 0.0319938, 0, 0, 0.48083,-99)    );
  // itree = 1950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.71585, 1, 1, 0.884874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497494,-99) , 
0, 0.852865, 1, 0, 0.680318,-99) , 
3, 1.38395, 0, 0, 0.751258,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569031,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280715,-99) , 
0, -1.21855, 1, 0, 0.347167,-99) , 
NN(
0, 
0, 
-1, -0.257029, 1, -1, 0.115614,-99) , 
3, -1.15126, 0, 0, 0.266577,-99) , 
3, 0.183842, 0, 0, 0.508894,-99)    );
  // itree = 1951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72318, 0, 1, 0.845307,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317685,-99) , 
0, 0.893448, 1, 0, 0.623645,-99) , 
3, 1.08418, 0, 0, 0.739841,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187651,-99) , 
0, -0.0856679, 1, 0, 0.392805,-99) , 
NN(
0, 
0, 
-1, 0.0302751, 1, -1, 0.0835536,-99) , 
3, -0.95623, 0, 0, 0.263702,-99) , 
3, 0.306962, 0, 0, 0.460632,-99)    );
  // itree = 1952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21129, 1, 1, 0.838243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260023,-99) , 
0, 0.708301, 1, 0, 0.583634,-99) , 
3, 0.98281, 0, 0, 0.697669,-99) , 
NN(
0, 
0, 
-1, -1.01154, 0, -1, 0.218172,-99) , 
3, -0.123397, 0, 0, 0.499624,-99)    );
  // itree = 1953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.56961, 1, 1, 0.86006,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370597,-99) , 
0, 0.852865, 1, 0, 0.66469,-99) , 
3, 1.09392, 0, 0, 0.763498,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299443,-99) , 
0, -0.395713, 1, 0, 0.500852,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.174261,-99) , 
3, -0.527848, 0, 0, 0.292744,-99) , 
3, 0.28719, 0, 0, 0.499879,-99)    );
  // itree = 1954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.768458, 1, 1, 0.770024,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274597,-99) , 
0, -0.2316, 1, 0, 0.460087,-99) , 
NN(
0, 
0, 
-1, -1.19134, 0, -1, 0.18656,-99) , 
3, -0.336159, 0, 0, 0.286496,-99) , 
3, 0.306962, 0, 0, 0.490663,-99)    );
  // itree = 1955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.975716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451342,-99) , 
3, 0.669526, 0, 0, 0.740607,-99) , 
0, 0.368803, 1, 0, 0.784584,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298722,-99) , 
0, -0.321535, 1, 0, 0.472134,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.197011,-99) , 
3, -0.372166, 0, 0, 0.30205,-99) , 
3, 0.254861, 0, 0, 0.525589,-99)    );
  // itree = 1956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42951, 1, 1, 0.837699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407131,-99) , 
0, 0.279125, 1, 0, 0.597803,-99) , 
3, 0.801028, 0, 0, 0.741476,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.888901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295481,-99) , 
0, -0.841692, 1, 0, 0.480778,-99) , 
NN(
0, 
0, 
-1, -1.79496, 1, -1, 0.177682,-99) , 
3, -0.379167, 0, 0, 0.277504,-99) , 
3, 0.17816, 0, 0, 0.495339,-99)    );
  // itree = 1957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.858857,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390018,-99) , 
0, 1.00367, 1, 0, 0.663052,-99) , 
3, 1.27254, 0, 0, 0.75233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303868,-99) , 
2, -0.169124, 1, 0, 0.462642,-99) , 
NN(
0, 
0, 
-1, -0.281116, 1, -1, 0.174034,-99) , 
3, -0.329146, 0, 0, 0.282589,-99) , 
3, 0.301115, 0, 0, 0.48709,-99)    );
  // itree = 1958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.873414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31102,-99) , 
0, 0.858007, 1, 0, 0.631832,-99) , 
3, 1.11225, 0, 0, 0.724008,-99) , 
NN(
0, 
0, 
-1, -0.78578, 0, -1, 0.191015,-99) , 
3, -0.202496, 0, 0, 0.506206,-99)    );
  // itree = 1959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.66427, 0, 1, 0.885316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41193,-99) , 
0, 0.852865, 1, 0, 0.671749,-99) , 
3, 1.38863, 0, 0, 0.754787,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328512,-99) , 
0, -0.50049, 1, 0, 0.469656,-99) , 
NN(
0, 
0, 
-1, -1.67341, 1, -1, 0.132803,-99) , 
3, -0.402042, 0, 0, 0.246989,-99) , 
3, 0.234307, 0, 0, 0.477287,-99)    );
  // itree = 1960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.58391, 1, 1, 0.863913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429018,-99) , 
0, 0.854666, 1, 0, 0.686762,-99) , 
3, 1.21373, 0, 0, 0.751887,-99) , 
NN(
0, 
0, 
-1, -1.01267, 0, -1, 0.183034,-99) , 
3, -0.123397, 0, 0, 0.525348,-99)    );
  // itree = 1961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.869748,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318275,-99) , 
0, 0.9386, 1, 0, 0.628786,-99) , 
3, 1.08361, 0, 0, 0.754646,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263591,-99) , 
0, -0.209168, 1, 0, 0.441809,-99) , 
NN(
0, 
0, 
-1, -0.719355, 1, -1, 0.187961,-99) , 
3, -0.329146, 0, 0, 0.280958,-99) , 
3, 0.306962, 0, 0, 0.493431,-99)    );
  // itree = 1962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.64872, 1, 1, 0.844018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401229,-99) , 
0, 0.630164, 1, 0, 0.666997,-99) , 
3, 0.952932, 0, 0, 0.761394,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264963,-99) , 
0, -0.808923, 1, 0, 0.390631,-99) , 
NN(
0, 
0, 
-1, -1.79745, 1, -1, 0.126662,-99) , 
3, -0.629083, 0, 0, 0.234427,-99) , 
3, 0.159996, 0, 0, 0.483523,-99)    );
  // itree = 1963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.62158, 1, 1, 0.886429,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462218,-99) , 
0, 1.06604, 1, 0, 0.698534,-99) , 
3, 1.31338, 0, 0, 0.781999,-99) , 
NN(
0, 
0, 
-1, -1.03294, 0, -1, 0.274165,-99) , 
3, 0.307824, 0, 0, 0.495417,-99)    );
  // itree = 1964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55749, 1, 1, 0.864734,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371711,-99) , 
3, 0.0260772, 0, 0, 0.567659,-99) , 
3, 1.07643, 0, 0, 0.676586,-99) , 
NN(
0, 
0, 
-1, -1.06792, 0, -1, 0.195094,-99) , 
3, -0.304384, 0, 0, 0.502874,-99)    );
  // itree = 1965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.27925, 1, 1, 0.861969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442405,-99) , 
0, 0.922711, 1, 0, 0.670173,-99) , 
3, 1.30526, 0, 0, 0.753138,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228719,-99) , 
0, -0.143589, 1, 0, 0.412302,-99) , 
NN(
0, 
0, 
-1, 0.267251, 1, -1, 0.12063,-99) , 
3, -0.796187, 0, 0, 0.291075,-99) , 
3, 0.28719, 0, 0, 0.489219,-99)    );
  // itree = 1966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11792, 1, 1, 0.798743,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356317,-99) , 
1, -0.272969, 1, 0, 0.500304,-99) , 
3, 0.319388, 0, 0, 0.71591,-99) , 
NN(
0, 
0, 
-1, -1.00886, 0, -1, 0.2267,-99) , 
3, -0.123397, 0, 0, 0.498016,-99)    );
  // itree = 1967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.93691, 1, 1, 0.867331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280317,-99) , 
0, 0.979653, 1, 0, 0.612289,-99) , 
3, 1.20395, 0, 0, 0.717071,-99) , 
NN(
0, 
0, 
-1, -0.714656, 0, -1, 0.231087,-99) , 
3, -0.123397, 0, 0, 0.513077,-99)    );
  // itree = 1968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.73245, 0, 1, 0.75942,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180272,-99) , 
0, -0.0856679, 1, 0, 0.39996,-99) , 
NN(
0, 
0, 
-1, -2.58105, 1, -1, 0.0781645,-99) , 
3, -1.01077, 0, 0, 0.299984,-99) , 
3, 0.325234, 0, 0, 0.490017,-99)    );
  // itree = 1969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.834877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330494,-99) , 
0, 0.459356, 1, 0, 0.542864,-99) , 
3, 1.03315, 0, 0, 0.649427,-99) , 
NN(
0, 
0, 
-1, -1.1305, 0, -1, 0.185945,-99) , 
3, -0.266059, 0, 0, 0.476262,-99)    );
  // itree = 1970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.308924, 1, 1, 0.939104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477921,-99) , 
3, 1.0781, 0, 0, 0.70476,-99) , 
0, 0.298272, 1, 0, 0.764547,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289072,-99) , 
0, -1.20938, 1, 0, 0.434841,-99) , 
NN(
0, 
0, 
-1, -2.4918, 1, -1, 0.0736968,-99) , 
3, -1.04325, 0, 0, 0.275511,-99) , 
3, 0.0354976, 0, 0, 0.534018,-99)    );
  // itree = 1971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45879, 1, 1, 0.786238,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304664,-99) , 
0, -0.00427319, 1, 0, 0.547021,-99) , 
3, 0.543354, 0, 0, 0.699579,-99) , 
NN(
0, 
0, 
-1, -0.419849, 0, -1, 0.22083,-99) , 
3, -0.123397, 0, 0, 0.48449,-99)    );
  // itree = 1972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59458, 1, 1, 0.875703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39852,-99) , 
0, 0.508268, 1, 0, 0.610987,-99) , 
3, 1.07541, 0, 0, 0.715636,-99) , 
NN(
0, 
0, 
-1, -1.06797, 0, -1, 0.219304,-99) , 
3, -0.304384, 0, 0, 0.521456,-99)    );
  // itree = 1973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02615, 0, 1, 0.823233,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322472,-99) , 
0, -0.0188443, 1, 0, 0.544114,-99) , 
3, 0.672086, 0, 0, 0.694499,-99) , 
NN(
0, 
0, 
-1, -1.07684, 0, -1, 0.227557,-99) , 
3, -0.202496, 0, 0, 0.502411,-99)    );
  // itree = 1974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.481623, 0, 1, 0.878026,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381686,-99) , 
3, 1.01403, 0, 0, 0.683843,-99) , 
0, 0.714887, 1, 0, 0.748098,-99) , 
NN(
0, 
0, 
-1, -0.357516, 0, -1, 0.247747,-99) , 
3, 0.178444, 0, 0, 0.484147,-99)    );
  // itree = 1975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.1797, 1, 1, 0.839636,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447727,-99) , 
0, -0.0858726, 1, 0, 0.584551,-99) , 
3, 0.937416, 0, 0, 0.725371,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236346,-99) , 
1, -0.252142, 1, 0, 0.371089,-99) , 
NN(
0, 
0, 
-1, -1.80475, 1, -1, 0.133267,-99) , 
3, -0.644435, 0, 0, 0.248413,-99) , 
3, 0.144527, 0, 0, 0.482102,-99)    );
  // itree = 1976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.240147, 0, 1, 0.721223,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2315,-99) , 
0, -1.23103, 1, 0, 0.360274,-99) , 
NN(
0, 
0, 
-1, -0.236536, 1, -1, 0.104848,-99) , 
3, -1.07684, 0, 0, 0.24158,-99) , 
3, -0.202496, 0, 0, 0.511696,-99)    );
  // itree = 1977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.91351, 1, 1, 0.858181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376216,-99) , 
0, 0.465064, 1, 0, 0.568357,-99) , 
3, 1.0516, 0, 0, 0.674144,-99) , 
NN(
0, 
0, 
-1, -1.01782, 0, -1, 0.198278,-99) , 
3, -0.28269, 0, 0, 0.486241,-99)    );
  // itree = 1978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.42951, 1, 1, 0.834379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416192,-99) , 
0, -0.129019, 1, 0, 0.582593,-99) , 
3, 0.66689, 0, 0, 0.731315,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173063,-99) , 
0, -1.38643, 1, 0, 0.308371,-99) , 
NN(
0, 
0, 
-1, -2.41898, 1, -1, 0.126908,-99) , 
3, -1.08414, 0, 0, 0.223247,-99) , 
3, -0.207894, 0, 0, 0.525711,-99)    );
  // itree = 1979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.192982, 1, 1, 0.904571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390386,-99) , 
3, 1.23099, 0, 0, 0.661965,-99) , 
0, 0.768458, 1, 0, 0.737015,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33401,-99) , 
0, -0.694947, 1, 0, 0.464724,-99) , 
NN(
0, 
0, 
-1, -2.54298, 1, -1, 0.169377,-99) , 
3, -0.568255, 0, 0, 0.307077,-99) , 
3, 0.392653, 0, 0, 0.49696,-99)    );
  // itree = 1980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.85268, 1, 1, 0.886131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314737,-99) , 
0, 0.852865, 1, 0, 0.657104,-99) , 
3, 1.18005, 0, 0, 0.757044,-99) , 
NN(
0, 
0, 
-1, -0.414216, 0, -1, 0.248171,-99) , 
3, 0.218994, 0, 0, 0.490732,-99)    );
  // itree = 1981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.22572, 1, 1, 0.845891,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.935606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366809,-99) , 
0, 0.586354, 1, 0, 0.649488,-99) , 
3, 1.0105, 0, 0, 0.751554,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311753,-99) , 
0, -0.991976, 1, 0, 0.417837,-99) , 
NN(
0, 
0, 
-1, -0.0369483, 1, -1, 0.12667,-99) , 
3, -0.945206, 0, 0, 0.26594,-99) , 
3, 0.17816, 0, 0, 0.497212,-99)    );
  // itree = 1982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.55639, 1, 1, 0.794726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362082,-99) , 
0, 0.0490839, 1, 0, 0.583184,-99) , 
3, 0.546413, 0, 0, 0.720652,-99) , 
NN(
0, 
0, 
-1, -1.3037, 0, -1, 0.207649,-99) , 
3, -0.123397, 0, 0, 0.494079,-99)    );
  // itree = 1983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.28417, 1, 1, 0.847536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495329,-99) , 
0, -0.0814742, 1, 0, 0.59728,-99) , 
3, 1.07541, 0, 0, 0.6884,-99) , 
NN(
0, 
0, 
-1, -0.812821, 0, -1, 0.232856,-99) , 
3, -0.304384, 0, 0, 0.525806,-99)    );
  // itree = 1984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.811713, 0, 1, 0.902332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416765,-99) , 
3, 1.41325, 0, 0, 0.689737,-99) , 
0, 1.09855, 1, 0, 0.773437,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274653,-99) , 
3, -0.362453, 0, 0, 0.406666,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.0718582,-99) , 
3, -1.20576, 0, 0, 0.323889,-99) , 
3, 0.392653, 0, 0, 0.504762,-99)    );
  // itree = 1985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24838, 1, 1, 0.8857,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202575,-99) , 
0, 0.738333, 1, 0, 0.517625,-99) , 
3, 0.995403, 0, 0, 0.656743,-99) , 
NN(
0, 
0, 
-1, -1.30016, 0, -1, 0.179906,-99) , 
3, -0.326776, 0, 0, 0.496899,-99)    );
  // itree = 1986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.368355, 1, 1, 0.966765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495656,-99) , 
3, 1.32129, 0, 0, 0.70584,-99) , 
0, 0.602516, 1, 0, 0.770113,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27955,-99) , 
1, -0.214834, 1, 0, 0.389239,-99) , 
NN(
0, 
0, 
-1, -0.301872, 1, -1, 0.125152,-99) , 
3, -0.64095, 0, 0, 0.261153,-99) , 
3, 0.306962, 0, 0, 0.476772,-99)    );
  // itree = 1987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45604, 0, 1, 0.786937,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34101,-99) , 
0, -0.0131043, 1, 0, 0.579469,-99) , 
3, 0.538437, 0, 0, 0.698102,-99) , 
NN(
0, 
0, 
-1, -1.37635, 0, -1, 0.205461,-99) , 
3, -0.376892, 0, 0, 0.517272,-99)    );
  // itree = 1988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.07875, 0, 1, 0.788458,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244193,-99) , 
0, -0.246635, 1, 0, 0.442883,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.180726,-99) , 
3, -0.329808, 0, 0, 0.26942,-99) , 
3, 0.301115, 0, 0, 0.487643,-99)    );
  // itree = 1989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39222, 1, 1, 0.8802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375693,-99) , 
0, 0.92467, 1, 0, 0.602102,-99) , 
3, 1.32196, 0, 0, 0.691911,-99) , 
NN(
0, 
0, 
-1, -0.798162, 0, -1, 0.220279,-99) , 
3, -0.207894, 0, 0, 0.496895,-99)    );
  // itree = 1990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0833831, 1, 1, 0.900241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451073,-99) , 
3, 1.12392, 0, 0, 0.687527,-99) , 
0, 0.512645, 1, 0, 0.744633,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258425,-99) , 
0, -0.773268, 1, 0, 0.412307,-99) , 
NN(
0, 
0, 
-1, -1.66047, 0, -1, 0.154691,-99) , 
3, -0.720436, 0, 0, 0.272226,-99) , 
3, 0.0990605, 0, 0, 0.50069,-99)    );
  // itree = 1991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.16242, 1, 1, 0.772817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319402,-99) , 
0, -0.0291509, 1, 0, 0.531602,-99) , 
3, 0.543354, 0, 0, 0.695552,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208088,-99) , 
3, -0.458781, 0, 0, 0.316277,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.113996,-99) , 
3, -1.00946, 0, 0, 0.223669,-99) , 
3, -0.123397, 0, 0, 0.489637,-99)    );
  // itree = 1992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.73059, 1, 1, 0.881167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407283,-99) , 
0, 0.934618, 1, 0, 0.641347,-99) , 
3, 1.42103, 0, 0, 0.726322,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3244,-99) , 
3, -0.0587791, 0, 0, 0.418524,-99) , 
NN(
0, 
0, 
-1, -1.12717, 0, -1, 0.165893,-99) , 
3, -0.379167, 0, 0, 0.249448,-99) , 
3, 0.17816, 0, 0, 0.472322,-99)    );
  // itree = 1993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.24127, 1, 1, 0.825742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367492,-99) , 
0, 0.234239, 1, 0, 0.576657,-99) , 
3, 0.804607, 0, 0, 0.736169,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33293,-99) , 
1, -0.388143, 1, 0, 0.479002,-99) , 
NN(
0, 
0, 
-1, -1.6049, 1, -1, 0.177392,-99) , 
3, -0.382101, 0, 0, 0.271373,-99) , 
3, 0.17816, 0, 0, 0.487936,-99)    );
  // itree = 1994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.82976, 1, 1, 0.869861,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357943,-99) , 
0, 1.0116, 1, 0, 0.628824,-99) , 
3, 1.36979, 0, 0, 0.695443,-99) , 
NN(
0, 
0, 
-1, -0.959795, 0, -1, 0.209855,-99) , 
3, -0.210183, 0, 0, 0.509349,-99)    );
  // itree = 1995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84129, 1, 1, 0.887321,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.871183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460631,-99) , 
0, 0.852865, 1, 0, 0.72401,-99) , 
3, 1.21404, 0, 0, 0.794838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625035,-99) , 
NN(
0, 
0, 
-1, -1.15117, 0, -1, 0.232475,-99) , 
3, -0.100777, 0, 0, 0.289155,-99) , 
3, 0.17816, 0, 0, 0.545016,-99)    );
  // itree = 1996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51354, 1, 1, 0.855836,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247484,-99) , 
0, 0.811659, 1, 0, 0.583473,-99) , 
3, 0.98281, 0, 0, 0.701366,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220179,-99) , 
0, -0.98415, 1, 0, 0.373529,-99) , 
NN(
0, 
0, 
-1, -0.257029, 1, -1, 0.07246,-99) , 
3, -1.00946, 0, 0, 0.215792,-99) , 
3, -0.123397, 0, 0, 0.496014,-99)    );
  // itree = 1997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.80194, 1, 1, 0.874593,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355685,-99) , 
0, 0.738333, 1, 0, 0.62269,-99) , 
3, 1.10862, 0, 0, 0.71994,-99) , 
NN(
0, 
0, 
-1, -1.07815, 0, -1, 0.217995,-99) , 
3, -0.202496, 0, 0, 0.514787,-99)    );
  // itree = 1998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.361931, 1, 1, 0.9428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399668,-99) , 
3, 1.11054, 0, 0, 0.696152,-99) , 
0, 0.785602, 1, 0, 0.772426,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329937,-99) , 
0, -1.40561, 1, 0, 0.41366,-99) , 
NN(
0, 
0, 
-1, -0.0310174, 1, -1, 0.109927,-99) , 
3, -1.06437, 0, 0, 0.296589,-99) , 
3, 0.28719, 0, 0, 0.507968,-99)    );
  // itree = 1999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40378, 1, 1, 0.833517,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445062,-99) , 
0, 0.298494, 1, 0, 0.613104,-99) , 
3, 0.936989, 0, 0, 0.732473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729682,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303203,-99) , 
0, -1.44513, 1, 0, 0.392704,-99) , 
NN(
0, 
0, 
-1, -1.79446, 0, -1, 0.123725,-99) , 
3, -1.18822, 0, 0, 0.298502,-99) , 
3, 0.135748, 0, 0, 0.509022,-99)    );
   return;
};

// Clean up
inline void ReadBDTB::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTB::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
