// Class: ReadBDTG
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:56:04 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "2000" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTGNode

#ifndef BDTGNode__def
#define BDTGNode__def

class BDTGNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTGNode ( BDTGNode* left,BDTGNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTGNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTGNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTGNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTGNode*   fLeft;     // pointer to the left daughter node
   BDTGNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTGNode::~BDTGNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTGNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTGNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG : public IClassifierReader {

 public:

   // constructor
   ReadBDTG( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTGNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTG::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTGNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTGNode*)current->GetRight();
         else current=(BDTGNode*)current->GetLeft();
      }
      myMVA += current->GetResponse();
   }
   return 2.0/(1.0+exp(-2.0*myMVA))-1.0;
}

void ReadBDTG::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107634,-0.0784733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436816,-0.0126368) , 
3, -0.997806, 1, 0, 0.306162,-0.193838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.687384,0.0374768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.873515,0.0747031) , 
3, 1.03138, 1, 0, 0.789641,0.289641) , 
3, 0.254861, 1, 0, 0.523411,0.0234114)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0543865,-0.0817931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20104,-0.0576976) , 
3, -1.13161, 1, 0, 0.137897,-0.339122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.855327,0.0675417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613948,0.0194913) , 
1, -0.577244, 1, 0, 0.687756,0.170503) , 
3, -0.38184, 1, 0, 0.477211,-0.0246365)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144537,-0.0593486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421197,-0.0159476) , 
3, -0.546586, 1, 0, 0.252942,-0.208412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.663506,0.0254117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.870426,0.0639468) , 
3, 1.22737, 1, 0, 0.759574,0.214242) , 
3, 0.240737, 1, 0, 0.485403,-0.014484)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24159,-0.0366602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132915,-0.0595162) , 
1, -0.212095, 1, 0, 0.179326,-0.241534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.802323,0.05465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596838,0.00688677) , 
0, 0.611453, 1, 0, 0.675913,0.125202) , 
3, -0.28269, 1, 0, 0.475022,-0.023159)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333507,-0.0228812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485847,-0.0954928) , 
0, 0.508341, 1, 0, 0.295978,-0.158262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.882487,0.0635044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733562,0.03101) , 
0, 1.42951, 1, 0, 0.793042,0.214476) , 
3, 0.569166, 1, 0, 0.471254,-0.0268262)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310703,-0.0108295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176811,-0.0450944) , 
0, -2.71174, 1, 0, 0.201275,-0.183863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864248,0.0656037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702489,0.0253301) , 
0, -0.259239, 1, 0, 0.728321,0.154765) , 
3, -0.28269, 1, 0, 0.521785,0.0220654)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344051,-0.00739201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174012,-0.0554024) , 
0, -1.17656, 1, 0, 0.25852,-0.150724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.866185,0.0574325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689116,0.0168745) , 
0, 1.10667, 1, 0, 0.771159,0.170813) , 
3, 0.10264, 1, 0, 0.510771,0.0074928)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177213,-0.0377616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0543679,-0.0655989) , 
0, -1.35401, 1, 0, 0.130355,-0.220217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525656,-0.00409354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812646,0.0392258) , 
3, 0.751987, 1, 0, 0.660261,0.0749995) , 
3, -0.38184, 1, 0, 0.482099,-0.0242565)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383319,-0.0158665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130888,-0.0977692) , 
0, 1.56422, 1, 0, 0.366864,-0.0991879) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.687699,0.00887069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.873967,0.0493511) , 
3, 1.21908, 1, 0, 0.848433,0.199171) , 
3, 1.05097, 1, 0, 0.477244,-0.0308017)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18361,-0.0311271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0648806,-0.0584447) , 
0, -1.73561, 1, 0, 0.129094,-0.189237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.758723,0.0623075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671851,0.0168357) , 
0, -0.835391, 1, 0, 0.681897,0.103356) , 
3, -0.673088, 1, 0, 0.506428,0.0104817)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0976863,-0.0476791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317366,-0.00993843) , 
3, -1.07872, 1, 0, 0.212025,-0.118455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.884155,0.0626549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634959,0.00338742) , 
0, -0.252128, 1, 0, 0.682452,0.0701142) , 
3, -0.202496, 1, 0, 0.491461,-0.00644384)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434176,-0.00251272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324546,-0.0560642) , 
0, 1.26832, 1, 0, 0.422854,-0.0376523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.979295,0.0682389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824772,0.0343261) , 
0, 1.85268, 1, 0, 0.885399,0.206975) , 
3, 1.32588, 1, 0, 0.509808,0.00833528)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338775,-0.00958902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311623,-0.0473397) , 
0, 0.140386, 1, 0, 0.332812,-0.0830126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.946344,0.0618744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701867,0.00834895) , 
0, 1.01626, 1, 0, 0.762868,0.0947774) , 
3, 0.775961, 1, 0, 0.464901,-0.0284055)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264452,-0.0182536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145146,-0.0617344) , 
0, -0.254933, 1, 0, 0.243645,-0.117033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.865739,0.0531568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702616,0.00992505) , 
2, 0.423007, 1, 0, 0.75349,0.106451) , 
3, 0.183842, 1, 0, 0.463128,-0.0208255)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42064,-0.00242751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235155,-0.0600131) , 
0, 0.830336, 1, 0, 0.400745,-0.0410534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.988984,0.0672903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768325,0.0197998) , 
0, 1.35927, 1, 0, 0.848273,0.152303) , 
3, 0.908704, 1, 0, 0.524734,0.0125163)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196262,-0.0217189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0830081,-0.0513393) , 
0, -1.52311, 1, 0, 0.136518,-0.152761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633443,0.00512793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.930409,0.0535255) , 
3, 1.76536, 1, 0, 0.680188,0.0542708) , 
3, -0.304384, 1, 0, 0.469702,-0.0258832)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332322,-0.00281621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198731,-0.0353732) , 
1, -0.236536, 1, 0, 0.254704,-0.0924982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.852188,0.0405101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724288,0.010596) , 
0, 0.844961, 1, 0, 0.766369,0.0872962) , 
3, 0.279658, 1, 0, 0.47005,-0.0168273)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303519,-0.00217467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188634,-0.0454879) , 
0, -0.749787, 1, 0, 0.2625,-0.0791816) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.8593,0.0417343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687781,0.0012186) , 
0, 0.709428, 1, 0, 0.738394,0.0560286) , 
3, 0.20809, 1, 0, 0.481339,-0.0170055)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450925,0.00199207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333568,-0.0571469) , 
0, 1.50438, 1, 0, 0.438353,-0.021066) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.957862,0.0568854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.801148,0.018259) , 
0, 2.81824, 1, 0, 0.904767,0.169236) , 
3, 1.4668, 1, 0, 0.515272,0.0103176)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117629,-0.0367808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823456,0.0535497) , 
3, -1.18969, 1, 0, 0.728435,0.17513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247026,-0.0245213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747745,0.0159305) , 
3, 0.234307, 1, 0, 0.455914,-0.0335108) , 
1, -0.700332, 1, 0, 0.521825,0.0169501)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303296,-0.00777531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16141,-0.0548802) , 
0, -0.0327079, 1, 0, 0.271204,-0.0823513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964773,0.0611577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735304,0.00899924) , 
0, 0.256001, 1, 0, 0.768539,0.0663373) , 
3, 0.392653, 1, 0, 0.479659,-0.0200293)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175169,-0.0193319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0448793,-0.0521107) , 
0, -2.74077, 1, 0, 0.107989,-0.129252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615919,0.0825951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572305,0.00209752) , 
0, -1.79057, 1, 0, 0.574982,0.0283718) , 
3, -1.37647, 1, 0, 0.516135,0.00850913)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100145,-0.0370694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745218,0.0369922) , 
3, -1.1241, 1, 0, 0.612583,0.095386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309077,-0.022235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825168,0.0184075) , 
3, 1.23533, 1, 0, 0.413134,-0.0595074) , 
1, -0.269474, 1, 0, 0.497047,0.00565992)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446977,0.00108032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320865,-0.0490352) , 
0, 1.42219, 1, 0, 0.43724,-0.0135799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.952079,0.0513072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775838,0.00291359) , 
0, 2.54858, 1, 0, 0.90171,0.13047) , 
3, 1.32588, 1, 0, 0.530544,0.0153572)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41903,0.00113812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200199,-0.0677188) , 
0, 1.01971, 1, 0, 0.396108,-0.0294334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.980895,0.0642727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.863102,0.0250318) , 
2, 0.713058, 1, 0, 0.895569,0.128219) , 
3, 1.11691, 1, 0, 0.504076,0.00464621)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320174,0.0182598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0945669,-0.0453252) , 
0, -1.6623, 1, 0, 0.204808,-0.056412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.808751,0.0588156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670099,0.0023254) , 
2, -0.498318, 1, 0, 0.682266,0.0325502) , 
3, -0.326776, 1, 0, 0.5095,0.000359564)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12204,-0.029421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.012574,-0.060999) , 
1, 0.050908, 1, 0, 0.0707282,-0.152568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.805534,0.100218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625075,0.00852992) , 
0, -1.8423, 1, 0, 0.632985,0.0526535) , 
3, -1.09659, 1, 0, 0.533898,0.016487)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0681001,-0.0430328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551564,0.00382467) , 
3, -1.67155, 1, 0, 0.513137,0.00251248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176445,-0.0546299) , 
1, 2.00118, 1, 0, 0.499272,-0.00644998)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4357,0.0147963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182235,-0.0332025) , 
1, -0.594345, 1, 0, 0.248603,-0.0802798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.876515,0.0392567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676621,-0.00892359) , 
0, 1.16242, 1, 0, 0.767553,0.05022) , 
3, 0.28719, 1, 0, 0.459256,-0.0273073)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189635,-0.0227889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583679,0.02215) , 
3, -0.103735, 1, 0, 0.258393,-0.0514003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.829683,0.0389734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.806149,0.01438) , 
2, 0.325054, 1, 0, 0.813005,0.0818439) , 
3, 0.17816, 1, 0, 0.514563,0.0101439)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347377,0.0285107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394775,-0.01831) , 
0, -1.5547, 1, 0, 0.383655,-0.03342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.924378,0.0379272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759433,-0.00334744) , 
0, 2.58992, 1, 0, 0.875482,0.0781998) , 
3, 1.14325, 1, 0, 0.497369,-0.00761269)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575813,0.0439639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623802,-0.0128387) , 
0, 0.161986, 1, 0, 0.598432,0.0685162) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164058,-0.0306433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731078,0.00340886) , 
3, 0.213332, 1, 0, 0.400465,-0.0609451) , 
1, -0.411712, 1, 0, 0.476466,-0.0112439)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128522,-0.0192975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609194,0.0278455) , 
3, -1.15748, 1, 0, 0.473516,0.0670216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287984,-0.0421279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.80524,0.0129266) , 
3, 0.854714, 1, 0, 0.638248,-0.030752) , 
0, 0.510979, 1, 0, 0.544642,0.024806)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.599605,0.0709321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679168,0.012164) , 
0, -1.40456, 1, 0, 0.666751,0.0821145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355935,0.00699148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59393,-0.0163787) , 
2, 0.120313, 1, 0, 0.464391,-0.0155396) , 
1, -0.700332, 1, 0, 0.518539,0.010591)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223117,-0.00902152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0839161,-0.0520339) , 
0, -0.610895, 1, 0, 0.190676,-0.0718586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.873682,0.0500041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668467,-0.00483194) , 
0, -0.296378, 1, 0, 0.703264,0.0203124) , 
3, -0.123397, 1, 0, 0.492808,-0.0175309)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206143,-0.00489489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.073078,-0.0419737) , 
0, -2.11959, 1, 0, 0.132953,-0.0811726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.731411,0.0613247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625648,-0.00193519) , 
0, -1.34596, 1, 0, 0.632742,0.0119519) , 
3, -0.786928, 1, 0, 0.488208,-0.0149787)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195487,-0.00710432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83102,0.065036) , 
3, -0.597821, 1, 0, 0.350602,0.0506254) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426858,-0.0228943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878917,0.0230707) , 
3, 1.43912, 1, 0, 0.518772,-0.0575024) , 
0, -0.838864, 1, 0, 0.465767,-0.0234219)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493192,0.0316095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238771,-0.0145225) , 
1, 0.524261, 1, 0, 0.386065,0.0462498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313086,-0.0283938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764108,0.00657999) , 
3, 0.575084, 1, 0, 0.602764,-0.0297482) , 
0, -0.0921771, 1, 0, 0.493729,0.00849126)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0350231,-0.0515418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129151,-0.025269) , 
3, -1.99034, 1, 0, 0.108351,-0.0992706) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.822039,0.0661265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610647,0.00424204) , 
0, -1.39202, 1, 0, 0.621707,0.030691) , 
3, -0.852844, 1, 0, 0.492365,-0.00205334)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452355,-0.00131623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530275,-0.0445897) , 
0, 1.76716, 1, 0, 0.461831,-0.0243832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.893004,0.0264994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963204,0.0522668) , 
3, 2.57114, 1, 0, 0.926777,0.124569) , 
3, 2.10834, 1, 0, 0.49299,-0.014401)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451556,0.0199638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623869,-0.0105856) , 
2, 0.291111, 1, 0, 0.52842,0.0233938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403877,-0.0115769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490489,-0.0635837) , 
0, 1.94272, 1, 0, 0.4138,-0.0636325) , 
1, 0.24729, 1, 0, 0.48333,-0.0108415)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514369,0.0181597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652254,-0.00552952) , 
0, 0.861216, 1, 0, 0.560089,0.0383854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257944,-0.0465047) , 
1, 2.03233, 1, 0, 0.546443,0.028333)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390158,0.00589239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269574,-0.0447266) , 
0, 0.238482, 1, 0, 0.362625,-0.0272915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.881706,0.0319229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722498,-0.0164468) , 
0, 2.77586, 1, 0, 0.850727,0.0738159) , 
3, 0.908704, 1, 0, 0.49476,7.95476e-05)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281107,0.00344934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132747,-0.02986) , 
0, -1.79283, 1, 0, 0.197066,-0.0518564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763287,0.0259006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617854,-0.0254312) , 
0, 1.53276, 1, 0, 0.719713,0.043063) , 
3, -0.304384, 1, 0, 0.51055,0.00507638)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415295,-0.00562595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310884,-0.0473585) , 
0, 1.42869, 1, 0, 0.406804,-0.0369485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.94072,0.0425907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773791,0.00345134) , 
0, 3.0766, 1, 0, 0.912945,0.108166) , 
3, 1.42542, 1, 0, 0.489879,-0.0131302)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413399,0.00206304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414149,-0.0341832) , 
2, 0.391425, 1, 0, 0.413574,-0.0282046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.899276,0.0302894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719802,-0.0191407) , 
1, 0.976475, 1, 0, 0.87066,0.0669281) , 
3, 1.13577, 1, 0, 0.525833,-0.00484018)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0232153,-0.0554003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.083148,-0.0328718) , 
3, -2.19226, 1, 0, 0.0673432,-0.11523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.782664,0.0799541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609083,0.00218415) , 
0, -1.80433, 1, 0, 0.618315,0.0266032) , 
3, -1.22141, 1, 0, 0.526489,0.00296486)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40085,0.000616511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.44013,-0.0324123) , 
0, 0.623399, 1, 0, 0.409675,-0.028284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.888937,0.0227258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.958821,0.050882) , 
3, 2.60749, 1, 0, 0.902176,0.0840053) , 
3, 1.42475, 1, 0, 0.489844,-0.0100058)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0987769,-0.0283446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606529,0.0839947) , 
3, -1.98171, 1, 0, 0.382072,0.134432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120897,-0.0316883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661763,0.00640171) , 
3, -0.564839, 1, 0, 0.514682,-0.0104243) , 
0, -2.46434, 1, 0, 0.502206,0.00320375)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255374,0.000400689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207389,-0.027025) , 
0, -1.57929, 1, 0, 0.226372,-0.0608206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.852208,0.0358151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688174,-0.00235815) , 
0, 0.878093, 1, 0, 0.758162,0.0519011) , 
3, 0.0990605, 1, 0, 0.487847,-0.00539655)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318333,-0.00590251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256668,-0.0337867) , 
0, -0.181337, 1, 0, 0.301534,-0.0535128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.839548,0.0314892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734498,-0.0140431) , 
2, 0.98444, 1, 0, 0.786316,0.0317448) , 
3, 0.575013, 1, 0, 0.474713,-0.0230563)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285055,-0.00468954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104255,-0.0446598) , 
0, 0.478319, 1, 0, 0.264226,-0.0333883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.808642,0.0295357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747121,-0.0118164) , 
2, 0.904064, 1, 0, 0.783296,0.0468113) , 
3, 0.306962, 1, 0, 0.486165,0.000902627)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100269,-0.0460909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142114,-0.0154199) , 
1, -1.00559, 1, 0, 0.133328,-0.0713919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.7263,0.0517196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633516,0.000694792) , 
0, -0.798302, 1, 0, 0.646764,0.032334) , 
3, -0.711955, 1, 0, 0.503001,0.00329057)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0345106,-0.0488932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333026,-0.0167021) , 
3, -1.37668, 1, 0, 0.274056,-0.0790691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.942328,0.0451858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727662,-0.00575762) , 
0, 0.992939, 1, 0, 0.79276,0.0272549) , 
3, 0.644527, 1, 0, 0.43348,-0.0463903)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.784016,0.0698562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435847,-0.00999583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.908406,0.0298335) , 
3, 1.83534, 1, 0, 0.489228,-0.0212856) , 
1, -2.04766, 1, 0, 0.497559,-0.0134239)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417552,0.016842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611669,-0.00756691) , 
0, -0.0824338, 1, 0, 0.518085,0.0129671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195712,-0.0584498) , 
1, 2.14068, 1, 0, 0.507944,0.00518457)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217743,0.00376596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0725489,-0.0378791) , 
0, -1.60668, 1, 0, 0.149279,-0.0440717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.848907,0.0350489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677972,0.003063) , 
1, -0.6917, 1, 0, 0.728487,0.0431477) , 
3, -0.376892, 1, 0, 0.531067,0.0134195)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0975672,-0.0237178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589436,0.0177946) , 
3, -1.28764, 1, 0, 0.494091,0.0396675) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390939,-0.0440864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.850579,0.010787) , 
3, 1.54303, 1, 0, 0.63225,-0.0701204) , 
0, 1.5337, 1, 0, 0.523236,0.0165076)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.945588,0.104004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468325,-0.0174562) , 
1, -2.04121, 1, 0, 0.630939,0.104343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288371,-0.0076096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794855,0.0132043) , 
3, 0.301115, 1, 0, 0.496108,0.00190665) , 
1, -1.71379, 1, 0, 0.506237,0.00960179)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35458,0.00146922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396966,-0.0335573) , 
2, 0.340528, 1, 0, 0.364414,-0.0283617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.921039,0.047124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833868,0.00737126) , 
2, 0.618795, 1, 0, 0.856245,0.053961) , 
3, 0.908704, 1, 0, 0.509348,-0.00410265)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456545,0.0389407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653181,0.00887272) , 
0, -0.947009, 1, 0, 0.595879,0.0596849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192065,-0.0226565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768171,0.0104576) , 
3, 0.287233, 1, 0, 0.457327,-0.0229768) , 
1, 0.0100439, 1, 0, 0.532966,0.02215)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57049,0.0312063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643105,-0.0094106) , 
0, 0.510979, 1, 0, 0.597616,0.0570727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456271,-0.00655168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228524,-0.0520728) , 
1, 2.10077, 1, 0, 0.440521,-0.034007) , 
1, -0.0220652, 1, 0, 0.51887,0.0114178)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102702,-0.0190485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644042,0.0394623) , 
3, -1.05133, 1, 0, 0.305775,0.0293153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241507,-0.0312431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739007,-0.00352284) , 
3, 0.436362, 1, 0, 0.500478,-0.0597455) , 
0, -1.15272, 1, 0, 0.450987,-0.0371076)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286136,-0.0556128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511954,0.00565934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18813,-0.0483732) , 
1, 2.09074, 1, 0, 0.495785,0.0093832) , 
1, -1.84449, 1, 0, 0.482867,-0.00471225)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303113,-0.00324076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712189,0.0299982) , 
2, -0.216777, 1, 0, 0.408447,0.0194129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585149,-0.0239682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.932145,0.0377877) , 
3, 2.12233, 1, 0, 0.646004,-0.0504589) , 
2, 0.275336, 1, 0, 0.500466,-0.0076523)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434892,0.00130822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.913747,0.0543198) , 
2, 0.215418, 1, 0, 0.702722,0.100236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385516,-0.00223247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647092,-0.0220137) , 
2, 0.595414, 1, 0, 0.460191,-0.0256356) , 
1, -1.40021, 1, 0, 0.482772,-0.0139164)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320457,-0.00736094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463731,-0.0505038) , 
3, 0.466944, 1, 0, 0.342308,-0.0507921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.836345,0.0171065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72011,-0.025675) , 
0, 2.77586, 1, 0, 0.818859,0.0322815) , 
3, 0.816421, 1, 0, 0.488824,-0.025251)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179882,-0.0105731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691576,0.0179881) , 
3, -0.397127, 1, 0, 0.438388,0.0176818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438475,-0.0324269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.896405,0.0207074) , 
3, 1.49298, 1, 0, 0.66392,-0.0400789) , 
0, 1.07968, 1, 0, 0.495632,0.00302113)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0784361,-0.0283755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0584667) , 
0, -2.5847, 1, 0, 0.0432516,-0.0968224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527746,0.0366977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512243,-0.00388773) , 
0, -1.7931, 1, 0, 0.513814,0.00255848) , 
3, -1.59453, 1, 0, 0.469843,-0.00672818)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239105,-0.0563461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766414,0.00267504) , 
3, 0.17816, 1, 0, 0.475267,-0.13176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.748813,0.0488235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504887,0.00516636) , 
1, -1.11441, 1, 0, 0.523052,0.0294399) , 
1, -1.6752, 1, 0, 0.51933,0.0168831)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174573,-0.062746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259182,-0.00846802) , 
1, -1.75595, 1, 0, 0.252148,-0.0470799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.888073,0.0481165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777065,0.00663902) , 
2, 0.423007, 1, 0, 0.807474,0.0610376) , 
3, 0.28719, 1, 0, 0.480988,-0.0025266)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115463,-0.0177512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591852,0.0223093) , 
3, -1.01826, 1, 0, 0.450298,0.0426046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431025,-0.0408315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.887332,0.0184463) , 
3, 1.3426, 1, 0, 0.698589,-0.0394739) , 
2, 0.650515, 1, 0, 0.520333,0.0194529)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331531,-0.00192297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529201,-0.0305963) , 
0, -0.650539, 1, 0, 0.463718,-0.0721713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0697978,-0.0280353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632444,0.00625981) , 
3, -0.770221, 1, 0, 0.473879,-0.0020293) , 
1, -0.249118, 1, 0, 0.469125,-0.0348464)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448239,-0.00611692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464354,-0.0891969) , 
0, 2.39564, 1, 0, 0.448804,-0.0296429) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.908523,0.0230818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.961668,0.048649) , 
3, 2.73265, 1, 0, 0.927562,0.0883726) , 
3, 2.06344, 1, 0, 0.482952,-0.0212255)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458746,0.00654314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697248,-0.0240307) , 
2, 1.0287, 1, 0, 0.492658,0.00778228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243238,-0.0465767) , 
1, 2.04552, 1, 0, 0.480802,-0.000787903)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686388,-0.0270659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595794,0.00904222) , 
3, -1.22141, 1, 0, 0.51707,0.0178913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335088,-0.0415702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436521,-0.00223424) , 
1, 1.47638, 1, 0, 0.400417,-0.0623781) , 
1, 1.29295, 1, 0, 0.503314,0.00842593)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128174,0.00325473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551755,0.071214) , 
3, -1.16872, 1, 0, 0.232126,0.0646907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133849,-0.0248147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661372,0.0048788) , 
3, -0.685211, 1, 0, 0.563163,0.000514677) , 
2, -1.1665, 1, 0, 0.509555,0.0109073)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207516,-0.00141889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147776,-0.0460448) , 
2, -0.0872687, 1, 0, 0.197848,-0.0301418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.841179,0.0381654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673093,-0.00424812) , 
0, 0.205625, 1, 0, 0.724393,0.03465) , 
3, -0.202496, 1, 0, 0.498369,0.00683753)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228268,0.00301862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886915,0.0480918) , 
3, -0.222179, 1, 0, 0.404457,0.0511319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26413,-0.0328505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763883,0.00531709) , 
3, 0.590253, 1, 0, 0.605354,-0.031087) , 
0, -0.106773, 1, 0, 0.508709,0.00846567)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279169,-0.00319763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122801,-0.0486701) , 
0, -0.140432, 1, 0, 0.249461,-0.0425009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.833301,0.022556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67879,-0.0135892) , 
0, 1.51947, 1, 0, 0.757917,0.0136238) , 
3, 0.306962, 1, 0, 0.476607,-0.0174279)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413012,-0.000546261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598849,-0.0294272) , 
2, 0.837548, 1, 0, 0.447661,-0.0199746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.98377,0.0525519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.850175,0.00970212) , 
0, 3.14798, 1, 0, 0.920488,0.0770039) , 
3, 2.05625, 1, 0, 0.479645,-0.0134145)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3517,0.00124489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22123,-0.0437257) , 
0, 0.366636, 1, 0, 0.329889,-0.027829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.850254,0.0265739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697079,-0.0162321) , 
1, 0.164749, 1, 0, 0.786709,0.0244399) , 
3, 0.680986, 1, 0, 0.477156,-0.0109789)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129244,-0.00557962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538657,0.0316443) , 
3, -1.14983, 1, 0, 0.330903,0.0510606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551475,-0.00907801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.939959,0.0571867) , 
1, 1.59481, 1, 0, 0.56812,-0.0200202) , 
0, -0.947009, 1, 0, 0.490918,0.00311288)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172474,-0.00577826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697533,0.0177255) , 
3, -0.361096, 1, 0, 0.445446,0.0240218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469606,-0.0402546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.895132,0.020281) , 
3, 1.64845, 1, 0, 0.672482,-0.0531918) , 
0, 1.14771, 1, 0, 0.501931,0.00481141)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114335,-0.00352594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656777,0.0636071) , 
3, -1.49828, 1, 0, 0.31545,0.0788394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198564,-0.0210258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708305,0.00433658) , 
3, -0.071404, 1, 0, 0.534817,-0.0135817) , 
0, -1.676, 1, 0, 0.496664,0.00249242)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494916,0.0140008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258845,-0.016926) , 
1, -0.586434, 1, 0, 0.319876,-0.0268283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.764313,0.0053346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9302,0.0309378) , 
3, 1.71482, 1, 0, 0.823707,0.0379018) , 
3, 0.644527, 1, 0, 0.493267,-0.00455172)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.716864,0.067284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385922,0.0079653) , 
1, -1.44575, 1, 0, 0.407289,0.0393292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189534,-0.0534151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756628,0.00614891) , 
3, 0.18885, 1, 0, 0.617245,-0.0371586) , 
2, -0.002981, 1, 0, 0.521472,-0.00226815)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.827752,0.0577399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108383,-0.0258614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666165,0.00486283) , 
3, -0.62845, 1, 0, 0.487105,-0.0112399) , 
1, -1.82258, 1, 0, 0.501222,-0.00203362)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335152,-0.00595546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.784506,0.0138237) , 
3, 0.523557, 1, 0, 0.474905,-0.000223708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564287,-0.0647115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841419,-0.00937693) , 
3, 1.85567, 1, 0, 0.730961,-0.0971365) , 
2, 1.49137, 1, 0, 0.493319,-0.00719315)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369784,0.0154079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563392,-0.00610034) , 
0, -0.96123, 1, 0, 0.509801,-0.00121039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300798,-0.0468535) , 
1, 2.18725, 1, 0, 0.501831,-0.00730756)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103461,-0.0179462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580129,0.0135212) , 
3, -1.01813, 1, 0, 0.432112,0.0201977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164942,-0.0394093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775373,0.00527191) , 
3, 0.665929, 1, 0, 0.647229,-0.0198561) , 
0, 0.642739, 1, 0, 0.513041,0.00512907)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401942,0.0526419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195454,0.00887003) , 
1, -0.281116, 1, 0, 0.257771,0.0628896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397061,-0.0211162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86054,0.017078) , 
3, 0.941748, 1, 0, 0.539858,-0.034812) , 
2, -1.09958, 1, 0, 0.485746,-0.0160702)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154251,-0.00745005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774027,0.0378772) , 
3, -0.559066, 1, 0, 0.40977,0.039994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301095,-0.043573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697084,-0.000607428) , 
2, 0.175256, 1, 0, 0.603833,-0.0382413) , 
0, 0.264129, 1, 0, 0.495582,0.00539933)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316906,-0.00749017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285115,-0.0461036) , 
2, 0.43797, 1, 0, 0.312991,-0.0425952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.873296,0.0297265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674771,-0.0364821) , 
0, 2.61768, 1, 0, 0.837385,0.0479527) , 
3, 0.638168, 1, 0, 0.496397,-0.0109262)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947493,-0.0106328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591928,0.0857153) , 
3, -1.87934, 1, 0, 0.321775,0.125523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141756,-0.0227297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658449,0.00508166) , 
3, -0.537893, 1, 0, 0.543784,-0.0011845) , 
0, -2.405, 1, 0, 0.525961,0.00898791)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397449,0.0621904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173512,0.0389785) , 
1, 0.050908, 1, 0, 0.292564,0.134202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0669818,-0.033371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613104,0.00813531) , 
3, -0.971048, 1, 0, 0.515382,0.00790185) , 
0, -2.96777, 1, 0, 0.502482,0.0152138)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264174,-0.00524743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257961,-0.0395592) , 
2, 0.111886, 1, 0, 0.262951,-0.0427155) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.890851,0.0373958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666455,-0.0154926) , 
0, 1.17756, 1, 0, 0.767845,0.0173965) , 
3, 0.262941, 1, 0, 0.491792,-0.01547)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813185,-0.0194066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434805,0.0547667) , 
3, -1.60276, 1, 0, 0.235636,0.0482923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5231,-0.00336667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460059,-0.027081) , 
1, 0.307447, 1, 0, 0.501067,-0.0367747) , 
2, -1.16796, 1, 0, 0.464753,-0.0251368)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463136,-0.0066106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601369,-0.0422821) , 
2, 1.12247, 1, 0, 0.481365,-0.0350286) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47464,0.00379327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645793,0.0367711) , 
1, 1.13768, 1, 0, 0.512789,0.0320546) , 
1, -0.0229864, 1, 0, 0.495523,-0.00480362)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0379325,-0.0394851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176748,-0.00387587) , 
3, -1.36489, 1, 0, 0.094451,-0.0501342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627239,0.0185762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751893,-0.0109316) , 
2, 1.04231, 1, 0, 0.655669,0.040439) , 
3, -0.908733, 1, 0, 0.519489,0.0184613)    );
  // itree = 100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791326,0.0498681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376109,-0.0098517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763926,0.00915605) , 
2, 0.560086, 1, 0, 0.481692,-0.0141384) , 
1, -2.00084, 1, 0, 0.489902,-0.00942679)    );
  // itree = 101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519259,0.0220505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755448,-0.00935082) , 
2, 0.744165, 1, 0, 0.590798,0.0389731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14004,-0.0296599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593968,0.00237624) , 
2, -0.733164, 1, 0, 0.437851,-0.0218107) , 
1, 0.107402, 1, 0, 0.520226,0.0109267)    );
  // itree = 102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0282063,-0.0481936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0537708) , 
1, 0.032123, 1, 0, 0.013686,-0.0930969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34753,0.0286388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554745,0.000719672) , 
2, -1.02503, 1, 0, 0.529562,0.0124573) , 
3, -1.73087, 1, 0, 0.491735,0.00471748)    );
  // itree = 103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406082,0.0201167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673289,-0.0021225) , 
2, 0.123767, 1, 0, 0.537604,0.0258138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256196,-0.0408529) , 
1, 2.00353, 1, 0, 0.524388,0.0194985)    );
  // itree = 104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161328,-0.00504724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694465,0.0312067) , 
3, -0.571471, 1, 0, 0.382844,0.0363579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124463,-0.0404962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77384,0.00223797) , 
3, 0.337198, 1, 0, 0.657879,-0.0190498) , 
0, -0.0815128, 1, 0, 0.509094,0.010924)    );
  // itree = 105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326964,-0.0129145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338611,-0.0406137) , 
2, 0.43797, 1, 0, 0.328824,-0.0591297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.893793,0.0223084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699973,-0.0186383) , 
0, 1.72973, 1, 0, 0.805951,0.0027339) , 
3, 0.775961, 1, 0, 0.487457,-0.0385616)    );
  // itree = 106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969601,-0.0157557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527466,0.031425) , 
3, -1.04414, 1, 0, 0.325689,0.0406765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681093,-0.0049874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542141,-0.0357904) , 
1, 0.107402, 1, 0, 0.625933,-0.0556506) , 
2, -0.281514, 1, 0, 0.507577,-0.0176784)    );
  // itree = 107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446664,0.0661427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627325,0.014921) , 
2, -1.3293, 1, 0, 0.609845,0.0597207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44545,0.00725886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641152,-0.0156287) , 
0, 1.46313, 1, 0, 0.494375,0.00186053) , 
1, -0.164574, 1, 0, 0.545849,0.0276532)    );
  // itree = 108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173641,-0.0435012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722363,-0.000905093) , 
3, -0.463457, 1, 0, 0.547576,-0.0564293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342524,0.040659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547899,-0.00312097) , 
0, -1.74276, 1, 0, 0.517603,0.00674864) , 
1, -1.12811, 1, 0, 0.523064,-0.00476319)    );
  // itree = 109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939372,-0.0176691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57589,0.015743) , 
3, -1.04414, 1, 0, 0.377333,0.0169728) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314994,-0.0663339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685772,0.00100338) , 
0, -0.55332, 1, 0, 0.633081,-0.0338811) , 
2, 0.161708, 1, 0, 0.499026,-0.00722523)    );
  // itree = 110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416156,0.067231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621724,0.0154209) , 
2, -1.35487, 1, 0, 0.60455,0.0591182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368974,-0.00358811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557964,-0.0199867) , 
0, 1.21408, 1, 0, 0.412974,-0.0229372) , 
1, -0.0270664, 1, 0, 0.508945,0.0181687)    );
  // itree = 111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6138,0.0505517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645487,-0.00213008) , 
0, -0.683893, 1, 0, 0.636443,0.0439243) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233433,-0.0150306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760495,0.00899336) , 
3, 0.240737, 1, 0, 0.438045,-0.0168193) , 
1, -0.636138, 1, 0, 0.493097,3.60243e-05)    );
  // itree = 112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202386,0.0113825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0842603) , 
3, -0.949735, 1, 0, 0.36254,0.0859542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222549,-0.0211239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723918,0.00750477) , 
3, 0.000980735, 1, 0, 0.543421,-0.00933102) , 
0, -1.60501, 1, 0, 0.512253,0.00708774)    );
  // itree = 113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.790935,0.047055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735081,0.0062057) , 
0, 0.932024, 1, 0, 0.772469,0.110033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395676,-0.00667619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.89941,0.0248353) , 
3, 1.41774, 1, 0, 0.477259,-0.00647678) , 
1, -1.12811, 1, 0, 0.512702,0.00751174)    );
  // itree = 114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504553,0.0141456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677631,-0.0163235) , 
2, 0.827757, 1, 0, 0.547833,0.0192484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390044,-0.0221941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545016,0.0123939) , 
1, 1.49038, 1, 0, 0.424126,-0.0389741) , 
1, 0.463922, 1, 0, 0.504702,-0.00105125)    );
  // itree = 115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56625,0.00653319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435209,-0.0561898) , 
1, -1.93965, 1, 0, 0.48637,-0.109934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31362,0.0260291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577044,0.000606198) , 
0, -1.48202, 1, 0, 0.513502,0.017804) , 
1, -1.55627, 1, 0, 0.510953,0.0058029)    );
  // itree = 116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670464,0.00166645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213664,-0.072712) , 
1, -2.01875, 1, 0, 0.440675,-0.141676) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575046,0.0106819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431142,-0.0137665) , 
1, -0.0709919, 1, 0, 0.494977,-0.00767084) , 
1, -1.72972, 1, 0, 0.489996,-0.0199629)    );
  // itree = 117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0739354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0890377,-0.0125708) , 
1, -1.18314, 1, 0, 0.0772791,-0.0601611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712016,0.0495151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550075,-0.0056993) , 
0, -1.29019, 1, 0, 0.567811,0.00296296) , 
3, -1.1555, 1, 0, 0.473987,-0.00911087)    );
  // itree = 118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282939,-0.00429003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251,-0.0411766) , 
2, -0.219497, 1, 0, 0.273449,-0.0481891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818485,0.0246827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741378,-0.0100137) , 
0, 2.07877, 1, 0, 0.800021,0.0443562) , 
3, 0.234307, 1, 0, 0.512184,-0.00623142)    );
  // itree = 119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224794,-0.00311996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768661,0.0230138) , 
3, -0.164868, 1, 0, 0.482712,0.0264215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465578,-0.0305665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878321,0.0141889) , 
3, 1.59516, 1, 0, 0.676769,-0.0405772) , 
0, 1.5337, 1, 0, 0.519676,0.0136595)    );
  // itree = 120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445299,-0.012062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520321,-0.0481054) , 
0, 0.68939, 1, 0, 0.472324,-0.0788448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479087,0.00871969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409934,-0.0292484) , 
1, 1.25751, 1, 0, 0.469676,0.00913514) , 
1, -0.78404, 1, 0, 0.470357,-0.0134864)    );
  // itree = 121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.656456,0.0299364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455444,-0.00552822) , 
1, -1.57033, 1, 0, 0.470631,-0.00745405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.94357,0.0447795) , 
3, 2.50532, 1, 0, 0.485091,-0.00312198)    );
  // itree = 122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347358,-0.0499986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516226,-0.0145319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476735,0.00430226) , 
1, -0.348809, 1, 0, 0.491801,-0.00973653) , 
1, -1.84922, 1, 0, 0.484498,-0.0187507)    );
  // itree = 123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539731,0.0330311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744031,-0.00709328) , 
2, 0.731099, 1, 0, 0.601908,0.0675658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38447,0.000836256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539616,-0.0356857) , 
0, 1.23253, 1, 0, 0.419313,-0.0264482) , 
1, 0.0804066, 1, 0, 0.520839,0.0258252)    );
  // itree = 124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272837,0.0530798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45061,-0.0345846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490792,-0.00518934) , 
1, -1.81119, 1, 0, 0.487705,-0.0228016) , 
0, -3.03185, 1, 0, 0.477763,-0.0162275)    );
  // itree = 125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114378,-0.0288081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473101,0.001003) , 
2, -1.42595, 1, 0, 0.411325,-0.00924129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.901821,0.0240735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.962053,0.0472542) , 
3, 2.64064, 1, 0, 0.909777,0.0686409) , 
3, 1.32588, 1, 0, 0.503861,0.00521729)    );
  // itree = 126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488906,-0.012172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535439,0.0170721) , 
1, 0.26246, 1, 0, 0.506198,-0.00611507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169302,-0.0673508) , 
1, 2.14068, 1, 0, 0.496243,-0.0128802)    );
  // itree = 127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161249,-0.0430954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186702,-0.0109917) , 
1, -0.868643, 1, 0, 0.18045,-0.0566259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.875369,0.0668949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73285,0.00441839) , 
2, -0.523981, 1, 0, 0.739849,0.0223614) , 
3, -0.123397, 1, 0, 0.48882,-0.0130839)    );
  // itree = 128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279849,0.0129303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436504,0.202998) , 
1, 0.580752, 1, 0, 0.326756,0.119579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.690591,0.012377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459236,-0.0136279) , 
1, -0.636138, 1, 0, 0.525888,-0.0190284) , 
0, -2.46434, 1, 0, 0.507993,-0.00657251)    );
  // itree = 129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223309,0.0110947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764388,-0.0407543) , 
0, -2.48686, 1, 0, 0.117079,-0.0605806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.762583,0.0749791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699415,0.010102) , 
2, -0.651845, 1, 0, 0.703604,0.0444773) , 
3, -0.632115, 1, 0, 0.523191,0.0121619)    );
  // itree = 130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32365,-0.0152021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431944,-0.0511059) , 
2, -0.0788337, 1, 0, 0.340828,-0.0645788) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.660082,0.056142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777002,-0.00908451) , 
3, 0.57486, 1, 0, 0.753328,0.0158708) , 
2, 0.171595, 1, 0, 0.513914,-0.030822)    );
  // itree = 131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54045,-0.00315167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369298,-0.0347715) , 
1, 0.388561, 1, 0, 0.496898,-0.0319674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439574,0.0673576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635379,-0.0056492) , 
2, -0.327583, 1, 0, 0.542022,0.0668286) , 
1, 1.08213, 1, 0, 0.50372,-0.0170301)    );
  // itree = 132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458731,-0.018498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502385,0.00543087) , 
1, -0.969585, 1, 0, 0.490786,-0.00410716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271134,-0.000264971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42274,-0.0522558) , 
0, -0.837232, 1, 0, 0.372127,-0.116697) , 
1, 1.29295, 1, 0, 0.479293,-0.0150127)    );
  // itree = 133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454808,-0.0529704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570282,0.00575045) , 
2, -1.63878, 1, 0, 0.531315,0.0071118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245653,-0.0777867) , 
1, 2.24652, 1, 0, 0.522436,-0.00292546)    );
  // itree = 134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132373,-0.0271792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757264,0.0245137) , 
3, -1.02868, 1, 0, 0.620929,0.0411887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293723,0.01536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534794,-0.00866654) , 
0, -1.80149, 1, 0, 0.495274,-0.0145752) , 
1, -1.24078, 1, 0, 0.512492,-0.00693388)    );
  // itree = 135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437716,-0.0238662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76657,0.00675251) , 
0, 1.56262, 1, 0, 0.497553,-0.0583454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453359,0.0123033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530486,-0.0314491) , 
0, 2.02942, 1, 0, 0.462339,0.0171546) , 
1, -0.281324, 1, 0, 0.478494,-0.0174827)    );
  // itree = 136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30296,-0.0274477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353585,0.0081174) , 
1, -0.371918, 1, 0, 0.335177,-0.0174534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.701092,0.0192664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77071,-0.00888251) , 
2, 1.56156, 1, 0, 0.711659,0.0460694) , 
2, -0.0385962, 1, 0, 0.540698,0.0172236)    );
  // itree = 137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72908,0.0532868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775912,0.0206602) , 
2, 0.693934, 1, 0, 0.747213,0.126411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397707,0.0166336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573956,-0.0135873) , 
2, 0.21299, 1, 0, 0.473333,0.00824744) , 
1, -1.12811, 1, 0, 0.510283,0.0241894)    );
  // itree = 138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407976,-0.00693267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.865058,0.0150572) , 
3, 1.24205, 1, 0, 0.503836,-0.0079166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0463661,-0.070041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650347,-0.00363176) , 
2, -0.926583, 1, 0, 0.372828,-0.116053) , 
1, 1.41092, 1, 0, 0.492217,-0.0175073)    );
  // itree = 139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383281,-0.0610386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539893,0.0159842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403986,-0.00917189) , 
1, -0.0418264, 1, 0, 0.463665,0.00578584) , 
1, -1.81119, 1, 0, 0.460293,-0.00391377)    );
  // itree = 140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417163,0.0791429) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418344,-0.0120288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884905,0.0173169) , 
3, 1.45471, 1, 0, 0.495269,-0.0223991) , 
0, -3.02048, 1, 0, 0.491721,-0.0124604)    );
  // itree = 141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604975,0.02331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394911,-0.0125513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874826,0.0104749) , 
3, 1.52692, 1, 0, 0.461642,-0.029161) , 
1, -2.00084, 1, 0, 0.467314,-0.0249931)    );
  // itree = 142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419078,-0.00636956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243757,-0.0724582) , 
2, 0.997723, 1, 0, 0.407108,-0.0343154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.896413,0.0379152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884417,0.0127839) , 
3, 1.61037, 1, 0, 0.888763,0.0599409) , 
3, 1.31913, 1, 0, 0.495481,-0.0170213)    );
  // itree = 143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664519,0.0240903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426105,-0.011655) , 
1, -0.529801, 1, 0, 0.497692,-0.00368901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271127,-0.0555605) , 
1, 1.68624, 1, 0, 0.482656,-0.0162813)    );
  // itree = 144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139071,-0.000678923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0248663,-0.0520642) , 
2, -1.51479, 1, 0, 0.0862527,-0.050943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.858826,0.0624734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58449,0.00438025) , 
0, -1.57439, 1, 0, 0.601225,0.0261089) , 
3, -1.15996, 1, 0, 0.509428,0.0123739)    );
  // itree = 145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148881,-0.0115756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680248,0.0498579) , 
2, -0.650508, 1, 0, 0.318752,0.0336426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163791,-0.0281843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736184,0.00353073) , 
3, 0.00748859, 1, 0, 0.585868,-0.0129716) , 
0, -0.82073, 1, 0, 0.49708,0.00252265)    );
  // itree = 146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453203,0.000419012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711614,-0.024832) , 
0, 2.02693, 1, 0, 0.485527,-0.0077632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135371,-0.00858593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832101,0.045791) , 
3, -0.0533099, 1, 0, 0.509845,0.0725066) , 
1, 1.17696, 1, 0, 0.48831,0.00142364)    );
  // itree = 147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424238,0.0471384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197722,0.040657) , 
1, 0.0576976, 1, 0, 0.302091,0.121627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23231,-0.0171455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733687,0.00442331) , 
3, 0.00598839, 1, 0, 0.487862,-0.0171096) , 
0, -2.90248, 1, 0, 0.47789,-0.0096624)    );
  // itree = 148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478737,-0.0372678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426754,0.0136841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674208,-0.00952223) , 
2, 0.370993, 1, 0, 0.520792,0.0128236) , 
1, -1.96641, 1, 0, 0.519286,0.00786911)    );
  // itree = 149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430838,-0.0218167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583757,0.01559) , 
1, -1.63747, 1, 0, 0.550573,0.0175129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251111,0.0392695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455739,-0.0156688) , 
0, -2.30075, 1, 0, 0.439158,-0.0348059) , 
1, -0.36158, 1, 0, 0.483167,-0.01414)    );
  // itree = 150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226056,-0.0231899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193391,0.00328324) , 
1, -0.257029, 1, 0, 0.209328,-0.0318364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.959219,0.0575339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67891,0.00173434) , 
0, -0.259743, 1, 0, 0.713756,0.0231983) , 
3, -0.123397, 1, 0, 0.496454,-0.000510093)    );
  // itree = 151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167735,0.0127394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824573,0.0667368) , 
3, -1.22401, 1, 0, 0.360733,0.0866738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293117,-0.0120842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818111,0.0160612) , 
3, 0.369572, 1, 0, 0.550374,0.00447364) , 
0, -1.5122, 1, 0, 0.517418,0.0187586)    );
  // itree = 152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301287,0.0118684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16299,-0.0488118) , 
1, 0.321275, 1, 0, 0.228562,-0.047702) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595686,0.0299616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701669,0.000970403) , 
2, 0.260009, 1, 0, 0.657652,0.0353307) , 
2, -0.662058, 1, 0, 0.515913,0.00790301)    );
  // itree = 153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0758186,-0.0293002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0575485) , 
0, -3.47585, 1, 0, 0.0312846,-0.08592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550677,0.0144846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696358,-0.00398657) , 
0, 1.53954, 1, 0, 0.588187,0.0280574) , 
3, -1.80475, 1, 0, 0.551806,0.0206116)    );
  // itree = 154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498726,0.0138114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553593,-0.0336572) , 
0, -0.683893, 1, 0, 0.536517,-0.0515308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514951,0.00604418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252476,-0.0439269) , 
1, 1.777, 1, 0, 0.496014,0.00606863) , 
1, -0.700332, 1, 0, 0.507898,-0.0108315)    );
  // itree = 155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514643,-0.0105463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519732,0.0150411) , 
1, 0.336009, 1, 0, 0.516204,-0.00873299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290766,-0.0503911) , 
1, 1.95384, 1, 0, 0.50942,-0.0130884)    );
  // itree = 156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726794,0.0463117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525586,-0.00356705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406014,-0.0209347) , 
1, 0.274557, 1, 0, 0.474745,-0.0315318) , 
1, -2.0516, 1, 0, 0.482914,-0.025833)    );
  // itree = 157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474502,0.00353439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660778,-0.0168061) , 
0, 1.76579, 1, 0, 0.508895,-0.00160758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56486,0.0321172) , 
1, 1.81888, 1, 0, 0.511392,0.00319821)    );
  // itree = 158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183942,-0.00752313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939004,-0.0402612) , 
0, -3.24694, 1, 0, 0.121702,-0.0748651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.729949,0.0276039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534887,0.00287447) , 
1, -1.03061, 1, 0, 0.567652,0.0198308) , 
0, -2.24414, 1, 0, 0.512911,0.00820671)    );
  // itree = 159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554765,-0.00376627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482705,-0.0418913) , 
1, -0.708729, 1, 0, 0.536289,-0.0391554) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50697,0.0078411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612819,-0.019518) , 
0, 2.04933, 1, 0, 0.519533,0.0102874) , 
1, -0.39136, 1, 0, 0.526007,-0.00881662)    );
  // itree = 160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297586,0.00198953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120549,-0.0369049) , 
1, 0.522288, 1, 0, 0.235925,-0.0265052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.736467,0.0456991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.772661,0.00760795) , 
3, 0.309236, 1, 0, 0.768281,0.0378905) , 
3, 0.0990605, 1, 0, 0.494162,0.00473213)    );
  // itree = 161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0365511,-0.0441726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497991,0.0146652) , 
3, -2.14429, 1, 0, 0.480061,0.0340517) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384723,-0.0251715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874853,0.0109123) , 
3, 1.44684, 1, 0, 0.612157,-0.0384305) , 
0, 0.861216, 1, 0, 0.520476,0.0118754)    );
  // itree = 162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475858,0.00200345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649536,-0.0336569) , 
2, 1.29234, 1, 0, 0.489802,-0.00197692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.951024,0.0456486) , 
3, 2.45686, 1, 0, 0.507449,0.00279776)    );
  // itree = 163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178751,0.00701351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157436,-0.0514325) , 
2, -1.71609, 1, 0, 0.166101,-0.0940231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197916,-0.00797614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724891,0.0119256) , 
3, -0.220527, 1, 0, 0.547959,0.0162476) , 
0, -2.3673, 1, 0, 0.513726,0.00636203)    );
  // itree = 164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16334,0.0157171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477846,-0.0158181) , 
2, -1.26476, 1, 0, 0.439229,-0.0361984) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278351,0.00319517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82134,0.0401232) , 
0, -0.661143, 1, 0, 0.546316,0.0685125) , 
1, 1.56529, 1, 0, 0.444994,-0.0305609)    );
  // itree = 165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44919,0.0375388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781228,0.00471409) , 
3, 0.28719, 1, 0, 0.613421,0.0618026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307087,-0.016778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.887041,0.0249017) , 
3, 1.26576, 1, 0, 0.417598,-0.0245511) , 
1, -0.164574, 1, 0, 0.497287,0.0105897)    );
  // itree = 166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.039787,-0.0366357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487121,0.0127351) , 
3, -1.52013, 1, 0, 0.375448,0.0110001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34837,-0.0543371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708996,-0.000742656) , 
0, -0.549894, 1, 0, 0.637794,-0.0422807) , 
2, 0.0110462, 1, 0, 0.50347,-0.0150003)    );
  // itree = 167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.699153,0.0797831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732243,0.00575953) , 
0, -0.5338, 1, 0, 0.72329,0.0792958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457666,-0.0153938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46365,0.0112539) , 
1, 1.09411, 1, 0, 0.458584,-0.0324157) , 
1, -1.51196, 1, 0, 0.483309,-0.0219812)    );
  // itree = 168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0853827,-0.0125487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59088,0.0949694) , 
3, -2.06539, 1, 0, 0.366448,0.146868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247007,0.0136516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60101,-0.0165106) , 
3, -0.288441, 1, 0, 0.499768,-0.0262609) , 
0, -2.46434, 1, 0, 0.4895,-0.0129275)    );
  // itree = 169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0850192,-0.0182136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4404,0.04073) , 
3, -1.09998, 1, 0, 0.251312,0.0385539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528266,-0.0710358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68214,-0.00279393) , 
0, -0.785132, 1, 0, 0.666904,-0.0310592) , 
3, -0.140306, 1, 0, 0.503123,-0.00362529)    );
  // itree = 170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350241,-0.00457155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289928,-0.0437844) , 
0, 0.489643, 1, 0, 0.339834,-0.0340676) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763203,0.0151021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513837,-0.0313739) , 
1, 1.02346, 1, 0, 0.732344,0.0257711) , 
2, 0.161708, 1, 0, 0.512665,-0.00771933)    );
  // itree = 171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193096,-0.0257108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185884,0.0309913) , 
1, 0.684304, 1, 0, 0.191504,-0.0428159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326182,-0.0282877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719781,0.00750677) , 
3, -0.0504686, 1, 0, 0.676894,0.00908897) , 
3, -0.269563, 1, 0, 0.475588,-0.0124375)    );
  // itree = 172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985169,-0.0300737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360345,0.0230545) , 
2, -1.75463, 1, 0, 0.311627,0.0359747) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398404,-0.0218655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811261,0.00662427) , 
3, 0.714214, 1, 0, 0.587111,-0.0269296) , 
2, -0.597208, 1, 0, 0.50821,-0.00891344)    );
  // itree = 173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177352,-0.0533232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273104,-0.00314019) , 
1, -1.12701, 1, 0, 0.262113,-0.0280752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456702,0.0537274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720354,0.00185614) , 
3, -0.284289, 1, 0, 0.692738,0.0208487) , 
2, -0.281514, 1, 0, 0.515987,0.000767795)    );
  // itree = 174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.626554,0.0428238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511936,-6.81242e-05) , 
1, -1.95233, 1, 0, 0.516794,0.00461692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683752,0.0495082) , 
1, 1.81136, 1, 0, 0.52234,0.00935017)    );
  // itree = 175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240541,-0.0328152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208387,0.00414207) , 
1, -0.969371, 1, 0, 0.215674,-0.0148126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.820127,0.0562104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739487,0.00590062) , 
3, 0.114624, 1, 0, 0.74488,0.0288724) , 
3, -0.10679, 1, 0, 0.518678,0.0101998)    );
  // itree = 176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0358185,-0.0485291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0362574,-0.0526201) , 
1, 0.893488, 1, 0, 0.0360366,-0.119073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540762,-0.0057016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612095,0.0233134) , 
1, 0.736789, 1, 0, 0.557086,0.003468) , 
2, -1.68013, 1, 0, 0.527897,-0.00339663)    );
  // itree = 177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340175,0.0601188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561278,0.0102954) , 
0, -2.25694, 1, 0, 0.541116,0.0378422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155146,-0.082376) , 
1, 2.1742, 1, 0, 0.527336,0.0259121)    );
  // itree = 178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404552,0.00281079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513291,-0.0212271) , 
2, 0.45616, 1, 0, 0.42423,-0.00745503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.913679,0.0326128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808577,-0.00848138) , 
2, 1.5876, 1, 0, 0.881994,0.0486379) , 
3, 1.14325, 1, 0, 0.533301,0.00591021)    );
  // itree = 179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735179,0.0530253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260188,-0.015283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643114,0.00178933) , 
2, -0.281514, 1, 0, 0.478087,-0.0131781) , 
1, -2.00084, 1, 0, 0.485362,-0.00767944)    );
  // itree = 180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390249,0.0605759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181574,0.00429966) , 
1, 0.375253, 1, 0, 0.291421,0.0858348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437808,-0.0162157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711913,0.00527152) , 
2, 0.569021, 1, 0, 0.54158,-0.0243511) , 
2, -0.864765, 1, 0, 0.489002,-0.00119232)    );
  // itree = 181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190601,-0.0808718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745096,0.00633357) , 
3, -0.428975, 1, 0, 0.496206,-0.111833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455386,0.00460375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664975,-0.0153966) , 
2, 0.999858, 1, 0, 0.489199,0.00313725) , 
1, -1.65967, 1, 0, 0.489612,-0.00364588)    );
  // itree = 182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368542,0.0199407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609067,-0.00358042) , 
0, -0.707105, 1, 0, 0.522748,0.0110769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555266,-0.0352152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290546,-0.0458789) , 
1, 2.12809, 1, 0, 0.422132,-0.110551) , 
1, 1.59425, 1, 0, 0.516638,0.00369077)    );
  // itree = 183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740856,-0.0379897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566002,0.00569096) , 
2, -1.63858, 1, 0, 0.529387,0.00758229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198253,0.058242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409531,-0.0270996) , 
2, -1.78207, 1, 0, 0.381189,-0.0542097) , 
1, 0.345387, 1, 0, 0.472553,-0.0161148)    );
  // itree = 184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.723927,0.0473158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392813,-0.0105511) , 
1, -2.03172, 1, 0, 0.403368,-0.0245507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.965444,0.0428904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831627,0.00673798) , 
0, 3.16717, 1, 0, 0.930507,0.0682656) , 
3, 1.62579, 1, 0, 0.463765,-0.0139163)    );
  // itree = 185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28333,-0.0240465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242565,0.00584024) , 
1, 0.301203, 1, 0, 0.267094,-0.0356178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612533,0.00482067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808219,0.0454052) , 
1, 1.6455, 1, 0, 0.621009,0.0193745) , 
0, -0.824643, 1, 0, 0.497556,0.000192072)    );
  // itree = 186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0295673,-0.0605856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278542,-0.00561271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669298,0.0152236) , 
2, -0.594485, 1, 0, 0.551501,0.0244785) , 
2, -2.07855, 1, 0, 0.533821,0.0171924)    );
  // itree = 187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326062,0.0041634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820886,0.0222574) , 
3, 0.17816, 1, 0, 0.553128,0.0334176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480304,-0.0221792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143692,-0.0569615) , 
1, 2.06992, 1, 0, 0.365989,-0.0999792) , 
1, 1.45051, 1, 0, 0.537876,0.0225462)    );
  // itree = 188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556143,-0.00719928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805223,0.0672669) , 
1, -1.6674, 1, 0, 0.660998,0.0635106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42786,-0.011776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.910754,0.0190354) , 
3, 1.77121, 1, 0, 0.478613,-0.0235916) , 
1, -1.31849, 1, 0, 0.500232,-0.0132672)    );
  // itree = 189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272461,0.0384533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329894,-0.00428484) , 
2, -0.989346, 1, 0, 0.304437,0.0331558) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543016,0.0231694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620426,-0.0164073) , 
2, -0.0685952, 1, 0, 0.612158,-0.0354494) , 
2, -0.281514, 1, 0, 0.49204,-0.00866954)    );
  // itree = 190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465167,-0.00199114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265693,-0.023258) , 
1, 0.11003, 1, 0, 0.375744,-0.032848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.652467,-0.0217928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.896407,0.0185663) , 
3, 1.21746, 1, 0, 0.866811,0.0275568) , 
3, 1.05097, 1, 0, 0.492018,-0.0185455)    );
  // itree = 191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417858,0.0144729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261713,-0.040333) , 
1, 1.66883, 1, 0, 0.404803,0.0230908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211854,-0.0504326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769181,-0.00626783) , 
3, 0.846568, 1, 0, 0.617182,-0.060705) , 
0, 0.493913, 1, 0, 0.484038,-0.00817218)    );
  // itree = 192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254794,-0.0220106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663739,-0.000975013) , 
0, -0.218015, 1, 0, 0.472222,-0.0286587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345845,0.0502785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619244,9.9489e-06) , 
0, -0.563745, 1, 0, 0.514028,0.0414305) , 
1, 0.823393, 1, 0, 0.48128,-0.013473)    );
  // itree = 193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197187,-0.0220404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184799,0.00754015) , 
1, -0.201353, 1, 0, 0.190259,-0.0191978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.685001,0.0229126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724681,-0.00641521) , 
2, 0.694561, 1, 0, 0.700171,0.0350073) , 
3, -0.304384, 1, 0, 0.487611,0.0124116)    );
  // itree = 194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593485,0.0413569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325014,-0.00874198) , 
1, -1.59062, 1, 0, 0.343148,-0.0128626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0591123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800049,0.0103656) , 
0, 0.355891, 1, 0, 0.820347,0.0351411) , 
3, 0.575013, 1, 0, 0.519169,0.00484417)    );
  // itree = 195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221693,-0.0860886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608023,-0.0232556) , 
0, -0.942735, 1, 0, 0.45414,-0.146337) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548839,0.0090425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39865,-0.0162323) , 
1, 0.498679, 1, 0, 0.496145,0.000355462) , 
1, -1.6752, 1, 0, 0.493218,-0.00986795)    );
  // itree = 196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38687,0.0530927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115834,-0.0280917) , 
1, 0.53526, 1, 0, 0.281487,0.0620667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576247,-0.00835269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76414,0.0433939) , 
1, 1.32658, 1, 0, 0.593254,-0.00866436) , 
2, -0.696554, 1, 0, 0.511673,0.00984402)    );
  // itree = 197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375978,0.00127814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446187,-0.0299644) , 
0, 0.854033, 1, 0, 0.383458,-0.0079756) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340649,-0.0354282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.843662,0.00112123) , 
3, 1.19718, 1, 0, 0.597522,-0.0541683) , 
2, 0.425012, 1, 0, 0.46521,-0.0256169)    );
  // itree = 198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651818,0.0524138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285692,-0.0143847) , 
1, -1.57033, 1, 0, 0.311488,-0.0281295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.79384,-0.003916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788376,0.0223278) , 
1, -0.249118, 1, 0, 0.790806,0.0300871) , 
3, 0.392653, 1, 0, 0.528259,-0.00180113)    );
  // itree = 199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210346,0.00645807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791939,0.062439) , 
2, -0.672927, 1, 0, 0.363525,0.0493783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380397,-0.0134907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.881341,0.0178182) , 
3, 1.1248, 1, 0, 0.507608,-0.0176102) , 
0, -1.82248, 1, 0, 0.484239,-0.00674553)    );
  // itree = 200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320087,0.0435864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187927,-0.0278302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726897,0.000452103) , 
3, -0.0982965, 1, 0, 0.499643,-0.0319138) , 
0, -3.07982, 1, 0, 0.491397,-0.025018)    );
  // itree = 201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298314,-0.0170293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630839,0.00237632) , 
2, -0.120384, 1, 0, 0.493089,-0.0164497) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458003,0.0486745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394142,0.000208458) , 
1, 1.32746, 1, 0, 0.425807,0.0527369) , 
1, 0.823393, 1, 0, 0.479264,-0.00223364)    );
  // itree = 202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240834,-0.0696986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.934031,0.0405102) , 
3, 0.275807, 1, 0, 0.573154,-0.0864982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509644,0.00960243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739348,-0.0274042) , 
0, 2.74551, 1, 0, 0.525385,0.0180309) , 
1, -1.71548, 1, 0, 0.528152,0.0119753)    );
  // itree = 203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.956835,0.0779215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531371,-0.0167634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468742,0.00349425) , 
1, -0.7457, 1, 0, 0.483952,-0.0044172) , 
1, -2.03415, 1, 0, 0.495839,0.000907482)    );
  // itree = 204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309016,-0.0116998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707408,0.0148991) , 
0, -0.904537, 1, 0, 0.588873,0.0166458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362285,-0.00900978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538189,-0.0316985) , 
0, 1.32897, 1, 0, 0.405194,-0.0376864) , 
1, -0.237385, 1, 0, 0.483333,-0.0145728)    );
  // itree = 205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294569,0.050964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535041,-0.00195674) , 
2, -1.72478, 1, 0, 0.5233,0.000757217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137949,-0.053899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649433,-0.00364912) , 
0, -0.379452, 1, 0, 0.337027,-0.0877242) , 
1, 1.45051, 1, 0, 0.505593,-0.00765377)    );
  // itree = 206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192432,-0.00326662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688647,0.0182887) , 
3, -0.449579, 1, 0, 0.485407,0.0279698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629632,-0.0166953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.974782,0.0516553) , 
3, 2.84498, 1, 0, 0.673282,-0.0235484) , 
0, 1.63755, 1, 0, 0.52463,0.0172143)    );
  // itree = 207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494764,-0.0092192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.955443,0.0345451) , 
3, 2.33715, 1, 0, 0.513484,-0.0214252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209237,-0.0466649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669728,-0.00617481) , 
3, 0.425897, 1, 0, 0.409979,-0.0824034) , 
1, 1.07215, 1, 0, 0.496117,-0.0316565)    );
  // itree = 208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.848968,0.05031) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497542,-0.00495476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472928,0.0162399) , 
1, 0.602491, 1, 0, 0.491535,-0.000694766) , 
1, -2.00084, 1, 0, 0.50171,0.00357268)    );
  // itree = 209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0222199,-0.0467428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545148,0.0137647) , 
3, -2.02422, 1, 0, 0.519205,0.0298142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706154,-0.0301785) , 
0, 2.76684, 1, 0, 0.52889,0.0237521)    );
  // itree = 210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.060581,-0.0604128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138846,-0.0031517) , 
1, -1.0491, 1, 0, 0.122961,-0.0428526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469893,0.0666268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670388,-0.000646337) , 
3, -0.331758, 1, 0, 0.651618,0.0152498) , 
3, -0.852844, 1, 0, 0.518839,0.000656626)    );
  // itree = 211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25243,-0.0313109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35529,0.0270192) , 
1, -0.863434, 1, 0, 0.337773,0.0389883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384097,-0.0299118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733083,0.00764362) , 
0, 0.373337, 1, 0, 0.552938,-0.0329319) , 
0, -1.668, 1, 0, 0.516999,-0.020919)    );
  // itree = 212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178613,-0.00263274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702122,0.025107) , 
3, -0.547621, 1, 0, 0.37544,0.0246306) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670541,0.0362647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604473,-0.020546) , 
0, 0.265663, 1, 0, 0.611409,-0.0389705) , 
0, -0.0815128, 1, 0, 0.491765,-0.00672259)    );
  // itree = 213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115726,-0.00199298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537224,0.0838474) , 
3, -1.08562, 1, 0, 0.210686,0.0469386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4796,-0.0169197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675408,0.00414516) , 
2, 0.248514, 1, 0, 0.585731,-0.0170939) , 
3, -0.857342, 1, 0, 0.498636,-0.00222391)    );
  // itree = 214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110749,-0.0233805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629896,0.00860855) , 
3, -0.756041, 1, 0, 0.490317,0.0046153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155837,-0.0608012) , 
1, 2.02743, 1, 0, 0.478005,-0.00102676)    );
  // itree = 215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122558,-0.0224024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690509,0.0125863) , 
3, -0.586691, 1, 0, 0.500675,0.00965575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687505,-0.0451993) , 
0, 2.92437, 1, 0, 0.508098,0.00420232)    );
  // itree = 216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311486,0.0971479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252869,-0.0129599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753346,0.00838039) , 
3, 0.131599, 1, 0, 0.51652,-0.00378576) , 
0, -3.69079, 1, 0, 0.5114,0.00117686)    );
  // itree = 217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104293,-0.0375155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364027,-0.00732958) , 
2, -1.36538, 1, 0, 0.300735,-0.0366217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712486,0.0121273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741713,-0.0177185) , 
2, 1.55786, 1, 0, 0.716761,0.0207972) , 
2, -0.0385962, 1, 0, 0.518015,-0.00663319)    );
  // itree = 218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392174,0.0110309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708692,-0.0371327) , 
3, 0.0910055, 1, 0, 0.583863,-0.0415958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426352,0.0229514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691189,-0.00577794) , 
2, 0.307097, 1, 0, 0.528759,0.0288911) , 
1, -0.696094, 1, 0, 0.543748,0.00971855)    );
  // itree = 219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503797,-0.000533152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528236,0.0330297) , 
1, 0.990731, 1, 0, 0.507594,0.0122578) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380542,-0.0712452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861219,0.00851198) , 
3, 2.04489, 1, 0, 0.678792,-0.0883086) , 
0, 2.41389, 1, 0, 0.520446,0.00470774)    );
  // itree = 220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524364,-0.0154542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50239,0.00582687) , 
1, -0.870929, 1, 0, 0.507999,0.000323019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506936,0.0824262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65757,-0.00605384) , 
3, 0.7024, 1, 0, 0.568425,0.111082) , 
1, 1.48204, 1, 0, 0.51178,0.00725344)    );
  // itree = 221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593184,-0.00855756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160903,-0.0644741) , 
1, -2.20559, 1, 0, 0.344211,-0.140454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133723,-0.0386293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56412,0.00320219) , 
0, -2.25694, 1, 0, 0.512073,-0.00449941) , 
1, -1.81119, 1, 0, 0.499434,-0.0147367)    );
  // itree = 222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116306,-0.00194023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704849,0.0730029) , 
3, -1.04001, 1, 0, 0.277082,0.0616903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428949,-0.0132971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687658,0.00802268) , 
2, -0.0133435, 1, 0, 0.587686,-0.000179058) , 
2, -0.724736, 1, 0, 0.517544,0.0137925)    );
  // itree = 223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172706,0.00295934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0389443,-0.0607052) , 
0, -3.23734, 1, 0, 0.115858,-0.0826072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415925,0.0184705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611409,-0.00390504) , 
0, -0.56597, 1, 0, 0.549,0.00752711) , 
0, -2.96777, 1, 0, 0.521642,0.00183421)    );
  // itree = 224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179989,-0.0147853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227249,-0.0291467) , 
2, -0.83668, 1, 0, 0.202291,-0.0598746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.940648,0.0537465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675673,-0.00593939) , 
0, -0.135384, 1, 0, 0.723243,0.00976541) , 
3, -0.123397, 1, 0, 0.508756,-0.0189069)    );
  // itree = 225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4789,0.0046806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727705,-0.0244175) , 
2, 0.979295, 1, 0, 0.526059,-0.00225374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0999829,0.0314953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448781,-0.0339064) , 
3, -1.26149, 1, 0, 0.401465,-0.0795316) , 
1, 0.342797, 1, 0, 0.479764,-0.0309675)    );
  // itree = 226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317003,-0.0108144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824313,0.0164231) , 
3, 0.724595, 1, 0, 0.465797,-0.00839565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539991,-0.0526762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885956,0.00767813) , 
3, 2.27813, 1, 0, 0.682036,-0.0937895) , 
2, 1.52556, 1, 0, 0.480541,-0.0142181)    );
  // itree = 227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424322,0.00447758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547034,-0.023862) , 
0, 0.879236, 1, 0, 0.451649,-0.00690979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.822628,0.0400208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813976,0.00755838) , 
0, 2.84027, 1, 0, 0.820013,0.0777448) , 
2, 1.18379, 1, 0, 0.500852,0.00439762)    );
  // itree = 228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139935,-0.044043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715682,0.00939241) , 
2, -0.354768, 1, 0, 0.495351,-0.0436345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575394,0.0182502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453251,-0.00342719) , 
1, -0.225453, 1, 0, 0.494535,0.00930801) , 
1, -1.22772, 1, 0, 0.494651,0.00177004)    );
  // itree = 229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25537,0.0167315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525711,-0.0119611) , 
0, -1.95871, 1, 0, 0.488662,-0.02404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0831075,-0.0126169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679628,0.0217133) , 
3, -0.441465, 1, 0, 0.51339,0.0387764) , 
1, 0.564685, 1, 0, 0.494878,-0.00824917)    );
  // itree = 230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478706,-0.0687885) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229781,0.00492247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657897,-0.0113357) , 
3, -0.210183, 1, 0, 0.478736,-0.0136753) , 
1, -2.23323, 1, 0, 0.478735,-0.0204422)    );
  // itree = 231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586355,0.0488974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813431,0.00883655) , 
2, 0.546798, 1, 0, 0.652284,0.108769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117847,-0.0100105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569869,0.0111234) , 
2, -1.44705, 1, 0, 0.495919,0.0219181) , 
1, -1.49648, 1, 0, 0.509516,0.0294705)    );
  // itree = 232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169677,-0.028084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654326,-0.0079886) , 
3, -0.717364, 1, 0, 0.48464,-0.0394564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584372,0.0235384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476259,-0.000400775) , 
1, -0.131975, 1, 0, 0.500848,0.0132352) , 
1, -0.570613, 1, 0, 0.495838,-0.0030531)    );
  // itree = 233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228982,-0.0041116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100171,-0.0622027) , 
1, 0.751855, 1, 0, 0.182139,-0.0574017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430079,0.0608602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554998,-0.000745828) , 
0, -1.80711, 1, 0, 0.545262,0.00881079) , 
0, -2.25694, 1, 0, 0.505579,0.00157491)    );
  // itree = 234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621709,-0.0200491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53,0.0153154) , 
3, -1.51229, 1, 0, 0.459265,0.0303428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312816,-0.0473078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868594,0.00921832) , 
3, 1.3426, 1, 0, 0.658123,-0.0464937) , 
2, 0.854699, 1, 0, 0.505866,0.0123366)    );
  // itree = 235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239855,-0.00951501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802874,0.0477205) , 
3, 0.0543972, 1, 0, 0.38148,0.0133788) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578266,-0.0199047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.855159,0.0114035) , 
2, 1.17438, 1, 0, 0.656829,-0.0327405) , 
2, 0.160383, 1, 0, 0.500647,-0.00658096)    );
  // itree = 236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.771495,0.046432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519523,0.00144302) , 
1, -1.89449, 1, 0, 0.530576,0.00968095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224384,-0.0399339) , 
1, 2.02743, 1, 0, 0.515021,0.00253356)    );
  // itree = 237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31234,-0.00589308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.870545,0.0435535) , 
2, -0.543709, 1, 0, 0.723844,0.0863068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509571,0.00831008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686593,-0.0393815) , 
2, 1.51538, 1, 0, 0.523728,0.0116658) , 
1, -1.07071, 1, 0, 0.55549,0.0235128)    );
  // itree = 238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55929,0.0339689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243346,-0.00922075) , 
1, -1.41463, 1, 0, 0.26807,-0.0135652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.801916,0.0257253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739855,-0.0149526) , 
2, 1.27514, 1, 0, 0.78469,0.0360836) , 
3, 0.228725, 1, 0, 0.504467,0.00915335)    );
  // itree = 239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233388,-0.0673114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75065,0.0137123) , 
0, 0.0469258, 1, 0, 0.465838,-0.114777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452093,-0.00385457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800813,0.0252039) , 
2, 1.04815, 1, 0, 0.507737,0.00309132) , 
1, -1.36512, 1, 0, 0.502566,-0.0114558)    );
  // itree = 240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462597,0.00177184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720234,-0.0153995) , 
2, 1.04815, 1, 0, 0.50586,-0.00300499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189444,-0.0522603) , 
1, 2.09327, 1, 0, 0.494024,-0.00767627)    );
  // itree = 241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130565,-0.0757678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824324,0.00693458) , 
3, -0.0334724, 1, 0, 0.368031,-0.177975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.740673,0.0293535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492205,-0.00236029) , 
1, -1.21016, 1, 0, 0.510935,0.000706651) , 
1, -1.69964, 1, 0, 0.499634,-0.013424)    );
  // itree = 242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433704,-0.00159759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593128,-0.0472454) , 
0, 0.68939, 1, 0, 0.483347,-0.0468629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564461,0.0110851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509376,0.0432018) , 
1, 1.97804, 1, 0, 0.56195,0.0323624) , 
1, -0.759733, 1, 0, 0.539736,0.00997237)    );
  // itree = 243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412076,-0.0193478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692352,0.0211868) , 
1, -1.88978, 1, 0, 0.644229,0.034515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394791,-0.0124808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78734,0.0157319) , 
2, 1.04815, 1, 0, 0.447651,-0.0216483) , 
1, -0.53217, 1, 0, 0.503357,-0.00573292)    );
  // itree = 244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32093,-0.00965565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452082,-0.0590911) , 
2, 0.264935, 1, 0, 0.338682,-0.0419356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597108,-0.0249306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.803736,0.0196193) , 
1, -1.36371, 1, 0, 0.7809,0.0370012) , 
2, 0.524348, 1, 0, 0.462333,-0.0198635)    );
  // itree = 245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273227,-0.0181114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315612,0.0173052) , 
1, 0.879159, 1, 0, 0.279563,-0.035863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.801092,0.0178291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73804,-0.0159747) , 
2, 0.996678, 1, 0, 0.779348,0.0153321) , 
3, 0.306962, 1, 0, 0.497893,-0.0134985)    );
  // itree = 246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479788,0.0124922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705745,-0.0130895) , 
2, 0.799265, 1, 0, 0.542811,0.0133399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292237,-0.056858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697376,-0.00917426) , 
2, 0.736751, 1, 0, 0.42204,-0.119824) , 
1, 1.41092, 1, 0, 0.532222,0.00166383)    );
  // itree = 247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30158,0.0071861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86775,0.0387834) , 
3, -0.210183, 1, 0, 0.629794,0.0620799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432513,-0.0251518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478996,0.0078217) , 
1, -0.0730397, 1, 0, 0.463723,-0.00961537) , 
1, -0.759733, 1, 0, 0.509248,0.0100384)    );
  // itree = 248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543148,0.00351377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594144,0.0300089) , 
1, 0.725282, 1, 0, 0.549802,0.0174183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353031,-0.0526651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405773,-0.000119088) , 
1, 1.84638, 1, 0, 0.372668,-0.0898328) , 
1, 1.33813, 1, 0, 0.531048,0.0060633)    );
  // itree = 249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.772062,0.0698944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540842,0.00528207) , 
1, -1.91427, 1, 0, 0.638135,0.0846907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229545,0.0100929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67768,-0.010365) , 
3, -0.202496, 1, 0, 0.484603,-0.00648914) , 
1, -1.54527, 1, 0, 0.497886,0.00139941)    );
  // itree = 250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104203,-0.00236822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402256,0.0406533) , 
3, -1.88269, 1, 0, 0.285569,0.0775437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515175,-0.0137466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480851,0.029406) , 
1, 1.66593, 1, 0, 0.51284,-0.0265916) , 
0, -2.24141, 1, 0, 0.484375,-0.0135491)    );
  // itree = 251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11963,0.0112588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802847,0.0561147) , 
3, -1.10726, 1, 0, 0.270673,0.0527161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575318,-0.00189768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516544,-0.0281132) , 
1, 0.66436, 1, 0, 0.562626,-0.0206164) , 
0, -1.4678, 1, 0, 0.499433,-0.00474355)    );
  // itree = 252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361879,0.0280196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160658,-0.0232725) , 
1, 0.821661, 1, 0, 0.314181,0.0412672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22463,-0.0818032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545631,-0.00646413) , 
2, -1.0331, 1, 0, 0.523031,-0.034091) , 
0, -1.5122, 1, 0, 0.482975,-0.0196378)    );
  // itree = 253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160407,-0.0155001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742683,0.0188123) , 
3, -0.399893, 1, 0, 0.452694,0.0109945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452447,-0.034058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.860133,0.00332958) , 
3, 1.60241, 1, 0, 0.641438,-0.0581429) , 
0, 1.23997, 1, 0, 0.495417,-0.00465496)    );
  // itree = 254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.73666,0.0303865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493436,-0.0111594) , 
1, -1.42264, 1, 0, 0.516016,-0.0192631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542432,0.0392381) , 
1, 1.6455, 1, 0, 0.51722,-0.0139018)    );
  // itree = 255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184409,0.00757571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648803,0.0396296) , 
3, -0.75291, 1, 0, 0.350013,0.054909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366991,-0.0371071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737768,0.0131775) , 
2, 0.0871878, 1, 0, 0.605896,-0.00958268) , 
0, -0.707105, 1, 0, 0.51582,0.0131198)    );
  // itree = 256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578255,-0.0856312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358956,-0.0597533) , 
1, -2.26319, 1, 0, 0.453211,-0.177733) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395079,0.0119469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.783355,-0.0113771) , 
3, 0.816421, 1, 0, 0.504929,0.0139101) , 
1, -1.88482, 1, 0, 0.501478,0.00112093)    );
  // itree = 257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239455,-0.0676838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761012,0.00491093) , 
0, 0.0738153, 1, 0, 0.448014,-0.120565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388128,0.015212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668384,-0.00778068) , 
2, 0.0724854, 1, 0, 0.514686,0.0107494) , 
1, -1.37597, 1, 0, 0.506847,-0.00468905)    );
  // itree = 258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178636,-0.00229585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621637,-0.0513243) , 
0, -2.19733, 1, 0, 0.113311,-0.0579518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65302,0.0143172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.665139,-0.00430355) , 
0, 0.665989, 1, 0, 0.659119,0.0146342) , 
3, -0.639447, 1, 0, 0.520672,-0.0037776)    );
  // itree = 259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422938,-0.034949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593268,0.0147344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468094,-0.00769344) , 
1, -0.296487, 1, 0, 0.51591,0.00114674) , 
1, -1.73654, 1, 0, 0.511119,-0.00495273)    );
  // itree = 260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379557,-0.007436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.852362,0.0122293) , 
3, 1.14552, 1, 0, 0.480772,-0.00812639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239763,-0.0584153) , 
1, 1.98002, 1, 0, 0.47089,-0.016695)    );
  // itree = 261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161184,0.00914986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0259861,-0.0402934) , 
1, 0.248859, 1, 0, 0.0942895,-0.0187934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593312,0.0103391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6826,-0.0154504) , 
0, 2.6649, 1, 0, 0.600235,0.0207908) , 
3, -0.920512, 1, 0, 0.483125,0.0116283)    );
  // itree = 262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5673,0.0378528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457066,0.00196813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617161,-0.0160102) , 
0, 1.75885, 1, 0, 0.481631,-0.00289817) , 
1, -1.86485, 1, 0, 0.485591,0.00236004)    );
  // itree = 263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170342,-0.0759002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880695,0.018099) , 
3, 0.793527, 1, 0, 0.408035,-0.143986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277795,0.0368073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490415,-0.000998163) , 
0, -3.12225, 1, 0, 0.47946,0.00223982) , 
1, -1.6752, 1, 0, 0.473551,-0.00985795)    );
  // itree = 264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104887,-0.00876308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763887,0.0883422) , 
3, -1.34621, 1, 0, 0.334709,0.0725051) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0734437,-0.0327793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656921,0.00673002) , 
3, -0.547376, 1, 0, 0.541017,0.00205559) , 
0, -1.6888, 1, 0, 0.509845,0.0126999)    );
  // itree = 265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21794,0.0297857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439528,-0.0162358) , 
2, -1.83768, 1, 0, 0.42294,-0.0351216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.707488,-0.0254336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.84144,0.0241503) , 
1, -0.977314, 1, 0, 0.803662,0.0269076) , 
2, 0.940976, 1, 0, 0.493232,-0.0236693)    );
  // itree = 266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181726,-0.00361383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560079,0.0425082) , 
3, -0.447144, 1, 0, 0.293972,0.0333736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.710349,-0.00993964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.91275,0.0502347) , 
1, 1.46075, 1, 0, 0.723067,-0.0156284) , 
3, 0.0990605, 1, 0, 0.512723,0.00839249)    );
  // itree = 267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.620237,0.0581206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370509,0.0131613) , 
1, -1.41616, 1, 0, 0.393121,0.0408999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617031,-0.025164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625727,0.00300208) , 
1, 0.0666043, 1, 0, 0.620794,-0.0351997) , 
0, -0.371383, 1, 0, 0.52051,-0.00167972)    );
  // itree = 268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.661889,0.0228908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466753,-0.0198422) , 
1, -1.13533, 1, 0, 0.520206,-0.0219867) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476017,0.0263701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581011,-0.0126264) , 
0, 1.31048, 1, 0, 0.503684,0.0331372) , 
1, 0.0363237, 1, 0, 0.513052,0.00188197)    );
  // itree = 269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564728,0.0159792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43281,-0.00191509) , 
1, -0.0246959, 1, 0, 0.495715,0.0158191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.925485,0.0511044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.903541,0.017919) , 
2, 1.86937, 1, 0, 0.917684,0.120014) , 
2, 1.50355, 1, 0, 0.532613,0.0249299)    );
  // itree = 270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477901,0.00286317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617538,-0.0225763) , 
0, 1.94906, 1, 0, 0.495125,-0.00213065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53783,0.0494965) , 
1, 1.90487, 1, 0, 0.496317,0.00154746)    );
  // itree = 271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539289,-0.00240826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311458,-0.0429133) , 
1, 0.696991, 1, 0, 0.51995,-0.0163817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476973,0.0497885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633692,0.00166535) , 
0, 0.583574, 1, 0, 0.533935,0.0715635) , 
1, 0.886404, 1, 0, 0.522661,0.000668789)    );
  // itree = 272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567798,0.0189527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710784,-0.0221485) , 
0, 0.68939, 1, 0, 0.623424,0.00715234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418298,-0.0216279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575027,0.00478686) , 
1, 0.940454, 1, 0, 0.449536,-0.042733) , 
1, -0.962158, 1, 0, 0.48468,-0.032651)    );
  // itree = 273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226861,0.0955497) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483832,-0.0293047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529426,0.00590985) , 
1, -1.71379, 1, 0, 0.527047,0.0100797) , 
2, -2.10645, 1, 0, 0.517609,0.0141216)    );
  // itree = 274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.752628,0.0676521) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.808382,0.0323353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456627,-0.00808888) , 
1, -1.31319, 1, 0, 0.479713,-0.0134724) , 
1, -1.87835, 1, 0, 0.489005,-0.0070765)    );
  // itree = 275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.744101,0.0540259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526738,0.00763592) , 
1, -2.0402, 1, 0, 0.537143,0.0255592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447161,-0.00525701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243891,-0.0512052) , 
1, 2.06123, 1, 0, 0.427521,-0.0221428) , 
1, 0.522288, 1, 0, 0.504543,0.0113735)    );
  // itree = 276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0277796,-0.0598471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580293,0.0097424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394055,-0.0287249) , 
1, 1.41092, 1, 0, 0.560871,0.0150022) , 
0, -3.26415, 1, 0, 0.540377,0.00793649)    );
  // itree = 277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219387,0.0391984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199768,-0.0161315) , 
2, -1.68904, 1, 0, 0.20307,-0.0160757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.770919,-0.0068314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705214,0.0230561) , 
1, -0.249118, 1, 0, 0.73452,0.0285028) , 
3, -0.123397, 1, 0, 0.515767,0.0101536)    );
  // itree = 278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551499,0.0513732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438745,-0.0135005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741325,0.0109037) , 
0, 1.23538, 1, 0, 0.510914,-0.0184261) , 
1, -1.86485, 1, 0, 0.51296,-0.0124009)    );
  // itree = 279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0261555,-0.0446348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322271,0.0296692) , 
3, -2.13056, 1, 0, 0.27318,0.0421561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285367,-0.0258245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780823,0.00904409) , 
3, 0.320126, 1, 0, 0.537354,-0.0260472) , 
2, -0.907503, 1, 0, 0.480903,-0.011473)    );
  // itree = 280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29841,-0.0361531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359648,-0.013546) , 
1, -0.870788, 1, 0, 0.343555,-0.0510639) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.874919,-0.0013099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.923476,0.0353511) , 
1, 0.0462137, 1, 0, 0.897689,0.0390456) , 
3, 1.14325, 1, 0, 0.463394,-0.0315765)    );
  // itree = 281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139456,-0.0607004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745611,-0.0103199) , 
3, -0.136251, 1, 0, 0.508126,-0.0896045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512757,0.0172989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433932,-0.0132474) , 
1, 0.156866, 1, 0, 0.473339,0.00351549) , 
1, -1.07071, 1, 0, 0.47957,-0.0131651)    );
  // itree = 282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.906744,0.0824481) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0374561,-0.0521989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544248,0.00719951) , 
2, -2.0043, 1, 0, 0.529653,0.0139943) , 
1, -2.00084, 1, 0, 0.54012,0.0186785)    );
  // itree = 283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180102,0.00293605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637447,0.0300958) , 
3, -0.317458, 1, 0, 0.295308,0.0277458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480005,-0.0481958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.79751,0.00234735) , 
3, 0.60004, 1, 0, 0.713834,-0.0364578) , 
3, 0.209828, 1, 0, 0.483501,-0.00112372)    );
  // itree = 284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258274,-0.00317294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884339,0.0552284) , 
0, -1.06914, 1, 0, 0.711797,0.0902938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27621,0.0488362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521527,-0.00796624) , 
2, -1.66446, 1, 0, 0.506301,-0.0126501) , 
1, -1.38631, 1, 0, 0.527064,-0.00224878)    );
  // itree = 285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309982,0.0114679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165721,-0.0351672) , 
1, -0.546181, 1, 0, 0.19668,-0.058825) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.624913,0.00348381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809546,0.045048) , 
1, 1.40086, 1, 0, 0.635095,0.0154432) , 
2, -0.585857, 1, 0, 0.489365,-0.00924372)    );
  // itree = 286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434812,0.0409641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652721,0.00213315) , 
0, -0.547391, 1, 0, 0.574592,0.0390021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211603,-0.0235273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.762534,0.00241644) , 
3, 0.271497, 1, 0, 0.431525,-0.0341188) , 
1, -0.921358, 1, 0, 0.462334,-0.0183724)    );
  // itree = 287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508122,-0.0637439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620475,-0.032553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539953,0.00623005) , 
3, -1.67155, 1, 0, 0.499927,0.00946078) , 
1, -2.16822, 1, 0, 0.500264,0.00166547)    );
  // itree = 288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148102,0.022349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705381,0.0726565) , 
3, -1.6187, 1, 0, 0.390508,0.109186) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493462,0.0120528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766225,-0.0176312) , 
2, 0.803242, 1, 0, 0.567475,0.00946685) , 
0, -1.676, 1, 0, 0.541069,0.0243463)    );
  // itree = 289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160565,-0.041606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245629,0.000200466) , 
1, 0.610427, 1, 0, 0.190393,-0.0655788) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357312,0.0193471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626015,-0.000665206) , 
2, -0.506127, 1, 0, 0.563952,0.0102434) , 
0, -1.54251, 1, 0, 0.488558,-0.00505939)    );
  // itree = 290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445052,-0.00126963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605022,-0.0362109) , 
2, 1.06913, 1, 0, 0.465803,-0.0148639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.969466,0.0487356) , 
3, 2.59088, 1, 0, 0.482197,-0.0106398)    );
  // itree = 291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434008,-0.032344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.947618,0.0263791) , 
3, 1.74619, 1, 0, 0.497563,-0.0701074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340247,-0.0135991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669685,0.0127915) , 
0, 0.391162, 1, 0, 0.466964,-0.00663114) , 
1, -0.673494, 1, 0, 0.475713,-0.02478)    );
  // itree = 292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481651,0.0148278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552814,-0.00847132) , 
0, 0.13769, 1, 0, 0.517288,0.00668819) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18519,0.107779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424037,-0.0260743) , 
3, -1.57994, 1, 0, 0.404705,-0.0563618) , 
1, 0.315534, 1, 0, 0.473638,-0.0177573)    );
  // itree = 293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151032,-0.00311611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135928,-0.0598039) , 
3, -0.698955, 1, 0, 0.147256,-0.0496251) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692769,0.0074115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609602,-0.0266129) , 
1, 1.06974, 1, 0, 0.680392,0.00656) , 
3, -0.451327, 1, 0, 0.50255,-0.0121821)    );
  // itree = 294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132348,-0.0146983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659775,0.00929797) , 
3, -0.683307, 1, 0, 0.493808,0.00755339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494051,0.0127478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324993,-0.045593) , 
1, 1.05419, 1, 0, 0.354071,-0.0806729) , 
1, 0.935819, 1, 0, 0.465678,-0.0102072)    );
  // itree = 295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282355,0.0412011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234696,-0.0132659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619599,0.00561287) , 
0, -1.19048, 1, 0, 0.530347,0.00451676) , 
0, -3.07585, 1, 0, 0.516206,0.00993909)    );
  // itree = 296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0772168,-0.053899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.090288,-0.0364427) , 
1, -0.463372, 1, 0, 0.0845621,-0.12841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510937,-0.00303289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.953562,0.0446781) , 
3, 2.41616, 1, 0, 0.529225,-0.00287018) , 
0, -2.90248, 1, 0, 0.502887,-0.0103062)    );
  // itree = 297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476124,-0.054199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595586,-0.022877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492046,0.0120904) , 
1, -0.854664, 1, 0, 0.510654,0.0133581) , 
1, -1.6752, 1, 0, 0.509109,0.00528768)    );
  // itree = 298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369964,0.03972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246864,-0.00518912) , 
1, 1.09951, 1, 0, 0.343812,0.0683952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301167,-0.0531386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669524,0.00209156) , 
0, -1.03083, 1, 0, 0.637919,-0.00878705) , 
2, -0.281514, 1, 0, 0.533036,0.0187373)    );
  // itree = 299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56088,0.00520938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37957,-0.0143557) , 
1, 0.581795, 1, 0, 0.520312,0.00193816) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155222,0.0255634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776102,0.0444915) , 
3, -0.250976, 1, 0, 0.569143,0.0932917) , 
1, 1.4007, 1, 0, 0.524059,0.00894792)    );
  // itree = 300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111933,0.000421348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0821711,-0.0508799) , 
3, -1.46311, 1, 0, 0.098548,-0.0502496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395298,0.042429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564112,-0.00361253) , 
2, -0.805506, 1, 0, 0.546207,0.000797032) , 
2, -1.3293, 1, 0, 0.475022,-0.00732026)    );
  // itree = 301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159671,-0.0469676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101139,-0.0079323) , 
1, -0.863434, 1, 0, 0.115218,-0.0406022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.643279,0.0133339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645375,-0.00405516) , 
0, 0.0878785, 1, 0, 0.644617,0.00617616) , 
3, -0.716903, 1, 0, 0.493695,-0.00715954)    );
  // itree = 302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273697,-0.00743947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116472,-0.0432735) , 
1, 0.821661, 1, 0, 0.232936,-0.035841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184786,-0.0265993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748092,0.0137334) , 
3, -0.284289, 1, 0, 0.684022,0.0221888) , 
2, -0.155261, 1, 0, 0.472128,-0.00507028)    );
  // itree = 303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509209,0.0133242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390356,-0.0258523) , 
1, 1.32658, 1, 0, 0.496075,0.0217729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401585,-0.0608626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.892824,0.00997463) , 
3, 1.90615, 1, 0, 0.662655,-0.0778202) , 
0, 1.94299, 1, 0, 0.51844,0.00840127)    );
  // itree = 304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441082,0.00487767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624104,-0.0116282) , 
0, 0.510979, 1, 0, 0.512331,-0.00477815) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554677,0.0842589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498295,0.00886353) , 
1, 2.15197, 1, 0, 0.52583,0.0965009) , 
1, 1.81888, 1, 0, 0.513171,0.00151865)    );
  // itree = 305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196234,-0.0326213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555305,-0.00337747) , 
0, -1.60927, 1, 0, 0.477455,-0.0235396) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116187,0.00178572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77282,0.0555219) , 
2, -0.919303, 1, 0, 0.510525,0.0935188) , 
1, 1.28363, 1, 0, 0.48119,-0.010319)    );
  // itree = 306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471292,-0.0312343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496413,-0.00200189) , 
1, -1.62087, 1, 0, 0.494371,-0.0133769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627663,0.0787724) , 
1, 2.00221, 1, 0, 0.497935,-0.00786681)    );
  // itree = 307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468892,0.0885968) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256505,-0.00236576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641289,0.0150574) , 
2, -0.64321, 1, 0, 0.536518,0.0263323) , 
0, -3.02048, 1, 0, 0.534161,0.0329791)    );
  // itree = 308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374552,-0.0312144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507459,0.0013394) , 
1, -1.77556, 1, 0, 0.498825,-0.0027333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225774,-0.0500269) , 
1, 2.09327, 1, 0, 0.489772,-0.00797797)    );
  // itree = 309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0407506,-0.0277997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240409,0.0423324) , 
3, -2.00776, 1, 0, 0.198933,0.0484936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735489,0.00826165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573468,-0.0183311) , 
1, -0.562283, 1, 0, 0.624671,-0.0281523) , 
3, -0.639447, 1, 0, 0.515886,-0.00856772)    );
  // itree = 310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0576419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567917,0.0185867) , 
3, -2.10268, 1, 0, 0.546952,0.0401597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205923,-0.0422802) , 
1, 2.10224, 1, 0, 0.533337,0.0346274)    );
  // itree = 311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659877,0.0387457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387929,-0.0069466) , 
1, -0.591326, 1, 0, 0.466766,0.0167961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510788,-0.0408544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811863,0.0205641) , 
0, 2.04553, 1, 0, 0.624189,-0.0492866) , 
0, 0.861216, 1, 0, 0.518213,-0.00480012)    );
  // itree = 312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.073224,-0.0180238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560566,0.0453751) , 
3, -1.167, 1, 0, 0.218459,0.0245606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348382,-0.0424686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575693,-0.0119456) , 
0, -1.31986, 1, 0, 0.548963,-0.0396555) , 
2, -0.955452, 1, 0, 0.498033,-0.0297599)    );
  // itree = 313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126934,-0.0272555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321616,0.0277743) , 
0, -2.89472, 1, 0, 0.276025,0.0271998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433483,-0.0251499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661557,0.00280494) , 
0, 0.627964, 1, 0, 0.533152,-0.0339068) , 
2, -0.724736, 1, 0, 0.474622,-0.019997)    );
  // itree = 314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525974,0.000754628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570436,-0.0704675) , 
0, 1.3945, 1, 0, 0.535983,-0.039748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124686,-0.0100708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664973,0.0167382) , 
3, -0.734444, 1, 0, 0.530409,0.0281845) , 
1, -1.03061, 1, 0, 0.531424,0.0158212)    );
  // itree = 315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284528,-0.000287003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106294,-0.0413016) , 
1, 0.301203, 1, 0, 0.206016,-0.029464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159791,-0.00945945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735345,0.0156165) , 
3, -0.381412, 1, 0, 0.632692,0.0305094) , 
2, -0.620353, 1, 0, 0.49896,0.0117121)    );
  // itree = 316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295652,0.00960657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531574,-0.0152778) , 
0, -1.4678, 1, 0, 0.4818,-0.0261074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629931,0.0487042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724555,-0.00893082) , 
2, 0.514435, 1, 0, 0.667578,0.0736969) , 
1, 1.45051, 1, 0, 0.494096,-0.0195013)    );
  // itree = 317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465537,-0.022186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529508,0.00564623) , 
1, -1.65583, 1, 0, 0.524373,0.00780187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279385,0.00743159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449201,-0.0365122) , 
0, -0.907478, 1, 0, 0.395747,-0.0619977) , 
1, 1.08213, 1, 0, 0.508867,-0.000612294)    );
  // itree = 318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187439,0.0115308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612215,-0.0136001) , 
3, -0.639447, 1, 0, 0.503749,-0.023317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505543,0.0395875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490697,-0.00126579) , 
1, 1.1326, 1, 0, 0.49693,0.0370647) , 
1, 0.820442, 1, 0, 0.502469,-0.01198)    );
  // itree = 319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0929748,-0.0154012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50273,0.0442441) , 
3, -1.60276, 1, 0, 0.291863,0.0394083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.631465,0.0150343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534955,-0.00945185) , 
1, -0.887646, 1, 0, 0.559275,-0.0095018) , 
0, -1.65375, 1, 0, 0.506731,0.000108538)    );
  // itree = 320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.677169,0.0335244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514986,-0.0027648) , 
1, -1.57543, 1, 0, 0.525939,-0.00123041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243966,-0.0373881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140211,-0.0524578) , 
1, 2.09281, 1, 0, 0.189914,-0.11417) , 
1, 1.652, 1, 0, 0.503619,-0.00873224)    );
  // itree = 321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101698,-0.0143857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366386,-0.0488057) , 
3, -0.74884, 1, 0, 0.175347,-0.0591701) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58242,0.0034992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835223,0.059913) , 
1, 1.6455, 1, 0, 0.594965,0.0179248) , 
2, -0.876457, 1, 0, 0.491355,-0.001111)    );
  // itree = 322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242919,-0.0122131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588499,-0.0295249) , 
3, 0.176665, 1, 0, 0.363359,-0.0464558) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.891774,0.0327335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.857846,0.000393379) , 
3, 1.4825, 1, 0, 0.866945,0.0242681) , 
3, 1.14325, 1, 0, 0.465395,-0.0321259)    );
  // itree = 323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421875,0.0319343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284332,-0.00252511) , 
1, 0.479422, 1, 0, 0.368524,0.0467733) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401077,-0.0341091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684144,0.00150409) , 
0, 0.0543639, 1, 0, 0.612502,-0.0158708) , 
0, -0.691462, 1, 0, 0.517327,0.00856646)    );
  // itree = 324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144372,-0.0536654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25426,-0.0175078) , 
1, -1.15304, 1, 0, 0.233586,-0.0558284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647434,0.0114103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495237,-0.00609528) , 
1, -0.421024, 1, 0, 0.545931,-0.000403106) , 
0, -1.6888, 1, 0, 0.49195,-0.00998207)    );
  // itree = 325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0774617,-0.0194258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514783,0.0168166) , 
3, -1.48495, 1, 0, 0.430355,0.028079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285243,-0.0184086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815261,-0.000800822) , 
3, 0.854714, 1, 0, 0.618502,-0.0201939) , 
0, 0.287843, 1, 0, 0.507201,0.00836264)    );
  // itree = 326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109841,0.00519912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412502,-0.0384591) , 
3, -1.23062, 1, 0, 0.234091,-0.0448919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530896,0.0164877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625671,-0.01457) , 
0, 0.940422, 1, 0, 0.565094,0.0100059) , 
0, -1.525, 1, 0, 0.494431,-0.00171386)    );
  // itree = 327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175802,-0.0435776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31251,0.0195118) , 
1, -1.44575, 1, 0, 0.295741,0.0258559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449141,-0.0220049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664051,0.00505547) , 
0, 0.524005, 1, 0, 0.5666,-0.0179357) , 
0, -0.948013, 1, 0, 0.48598,-0.00490126)    );
  // itree = 328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115598,-0.0184017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575928,0.00933826) , 
2, -1.3293, 1, 0, 0.498677,0.0129107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162004,-0.0548826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739136,0.00991284) , 
0, -0.296719, 1, 0, 0.386714,-0.0634904) , 
1, 1.17696, 1, 0, 0.48607,0.00430794)    );
  // itree = 329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265463,-0.0115377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159875,-0.0507059) , 
2, 0.111886, 1, 0, 0.241535,-0.0595043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.764532,0.0314638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742405,-0.00847228) , 
2, 0.75917, 1, 0, 0.753241,0.0259085) , 
3, 0.195693, 1, 0, 0.465564,-0.0221099)    );
  // itree = 330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498168,-0.0668486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370028,0.00208873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592718,-0.0192096) , 
0, -0.00413718, 1, 0, 0.474642,-0.0211654) , 
1, -2.03415, 1, 0, 0.475323,-0.0262411)    );
  // itree = 331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519888,0.0517701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699288,0.0136149) , 
0, -1.22038, 1, 0, 0.664035,0.0502368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329851,-0.0585937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470579,0.00564513) , 
1, -0.437826, 1, 0, 0.458282,-0.00177554) , 
1, -0.633389, 1, 0, 0.516541,0.0129517)    );
  // itree = 332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0745487,-0.0206554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0978653,-0.0591874) , 
2, -1.79183, 1, 0, 0.0869831,-0.128531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612127,0.0141444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437088,-0.00885532) , 
1, -0.249118, 1, 0, 0.516119,0.00304086) , 
0, -3.02048, 1, 0, 0.491761,-0.00442746)    );
  // itree = 333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262286,0.00534869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645912,0.0498727) , 
0, -1.10682, 1, 0, 0.329698,0.0312491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238869,-0.0358212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745394,0.00292144) , 
3, 0.404339, 1, 0, 0.548439,-0.0343708) , 
0, -0.691462, 1, 0, 0.471228,-0.0112084)    );
  // itree = 334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350463,-0.0233053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782307,0.0103023) , 
2, 0.72515, 1, 0, 0.436047,-0.0443973) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112659,-0.012005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645057,0.0262232) , 
2, -0.824351, 1, 0, 0.482267,0.0364391) , 
1, 0.65094, 1, 0, 0.447157,-0.0249654)    );
  // itree = 335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36654,0.0622589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14239,0.0326314) , 
1, 0.0325634, 1, 0, 0.246933,0.102494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446334,-0.0085691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.783606,0.0184738) , 
2, 0.955676, 1, 0, 0.513312,-0.00644801) , 
0, -3.03185, 1, 0, 0.498973,-0.000583671)    );
  // itree = 336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207378,-0.0590038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279324,-0.0146656) , 
1, -1.8346, 1, 0, 0.274594,-0.0405626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684671,0.0178669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579994,-0.0140878) , 
1, 0.265679, 1, 0, 0.647568,0.0163517) , 
0, -0.156017, 1, 0, 0.456036,-0.0128753)    );
  // itree = 337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210545,0.0300657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316567,-0.0387646) , 
3, -0.660832, 1, 0, 0.250351,-0.0141089) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.669956,0.0331637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678142,-0.00195373) , 
0, 0.557865, 1, 0, 0.674542,0.0305246) , 
2, -0.437416, 1, 0, 0.509538,0.0131629)    );
  // itree = 338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215369,0.00933197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235313,-0.0398499) , 
3, -0.419849, 1, 0, 0.2209,-0.0224138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0738122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703478,0.00770104) , 
2, -0.521614, 1, 0, 0.718327,0.0271987) , 
3, -0.123397, 1, 0, 0.515604,0.00697951)    );
  // itree = 339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18021,0.00760744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587082,0.0652297) , 
3, -0.535124, 1, 0, 0.246374,0.0436026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.68152,-0.0131756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653874,0.00933402) , 
1, 0.0462137, 1, 0, 0.668567,-0.00706383) , 
3, -0.287638, 1, 0, 0.524478,0.010228)    );
  // itree = 340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294597,0.0494003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497961,-0.00118442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714228,-0.048427) , 
2, 1.54365, 1, 0, 0.51351,-0.0110251) , 
0, -3.14395, 1, 0, 0.503441,-0.00535511)    );
  // itree = 341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0989828,-0.00217798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478881,0.0459897) , 
3, -1.57973, 1, 0, 0.255095,0.0441769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207483,-0.0162528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723828,0.00158873) , 
3, 0.0491022, 1, 0, 0.505693,-0.0147097) , 
0, -1.84335, 1, 0, 0.472216,-0.00684318)    );
  // itree = 342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104399,-0.0282751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16673,-0.0648139) , 
1, 0.899579, 1, 0, 0.124316,-0.0908196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0134002,-0.0422426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608084,0.0133049) , 
3, -1.22144, 1, 0, 0.558145,0.0258404) , 
0, -2.25694, 1, 0, 0.509351,0.0127193)    );
  // itree = 343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.76502,0.0510603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456774,-0.0132479) , 
1, -1.59109, 1, 0, 0.486455,-0.0181025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0938671,-0.0158409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576548,0.02104) , 
3, -0.566422, 1, 0, 0.449809,0.0335566) , 
1, 0.463922, 1, 0, 0.475062,-0.00204267)    );
  // itree = 344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533612,-0.00144531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384921,-0.0520448) , 
1, -1.12093, 1, 0, 0.467987,-0.0578107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316856,-0.00014903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694342,0.0169218) , 
0, -0.103216, 1, 0, 0.496982,0.019883) , 
1, -0.793951, 1, 0, 0.487714,-0.00495195)    );
  // itree = 345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485048,-0.0150868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63559,0.031494) , 
1, -1.6572, 1, 0, 0.606624,0.0513499) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213194,-0.0170832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774103,0.00819423) , 
3, 0.179068, 1, 0, 0.495229,-0.00918472) , 
1, -0.39136, 1, 0, 0.538411,0.0142813)    );
  // itree = 346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427244,-0.0200126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75023,0.0178514) , 
0, 1.32897, 1, 0, 0.502251,-0.0283999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528428,0.0567464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440558,-0.0482118) , 
0, 1.3122, 1, 0, 0.50375,0.0444387) , 
1, 1.08213, 1, 0, 0.502431,-0.0196821)    );
  // itree = 347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112628,-0.0352015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108919,0.0210297) , 
1, 0.753547, 1, 0, 0.110866,-0.0229984) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418281,-0.0196302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595951,0.010909) , 
1, -1.81119, 1, 0, 0.585485,0.0215873) , 
2, -1.48096, 1, 0, 0.520462,0.0154791)    );
  // itree = 348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0529875,-0.0110369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716652,0.0985419) , 
3, -1.98171, 1, 0, 0.335099,0.117118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529745,0.00105067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4444,-0.018972) , 
1, 0.71376, 1, 0, 0.509127,-0.00956092) , 
0, -2.41635, 1, 0, 0.492023,0.00288949)    );
  // itree = 349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101487,0.00577188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215546,-0.033951) , 
3, -1.8206, 1, 0, 0.185727,-0.0651141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447416,0.0174695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659097,-0.00987749) , 
2, 0.128013, 1, 0, 0.569641,0.00271524) , 
2, -0.833719, 1, 0, 0.46737,-0.0153538)    );
  // itree = 350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12934,-0.0177017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614483,0.0805061) , 
3, -0.889825, 1, 0, 0.275078,0.0274144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406619,-0.0179866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812961,0.00471388) , 
3, 0.754259, 1, 0, 0.587924,-0.0209979) , 
2, -0.662058, 1, 0, 0.503007,-0.00785724)    );
  // itree = 351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197371,-0.0406361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570773,-0.0100081) , 
0, -1.80149, 1, 0, 0.502824,-0.0407378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562566,0.0274944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375428,-0.00739664) , 
1, 1.04139, 1, 0, 0.509474,0.0382873) , 
1, -0.36158, 1, 0, 0.506755,0.00596846)    );
  // itree = 352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338741,-0.0200323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723641,0.00746578) , 
0, -0.106773, 1, 0, 0.534479,-0.0123719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331209,-0.041725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516042,0.0282715) , 
1, 0.594073, 1, 0, 0.493558,0.0416936) , 
1, 0.475876, 1, 0, 0.522075,0.00401565)    );
  // itree = 353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121013,-0.013408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661591,0.00832278) , 
3, -0.719586, 1, 0, 0.510247,0.00848682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570241,0.045894) , 
1, 1.89, 1, 0, 0.512432,0.0119665)    );
  // itree = 354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.819472,0.0833757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82339,-0.0065386) , 
3, 0.757296, 1, 0, 0.821071,0.12095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461555,-0.00466926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534311,-0.0661288) , 
0, 2.89272, 1, 0, 0.464853,-0.0195722) , 
1, -1.40021, 1, 0, 0.495079,-0.00764852)    );
  // itree = 355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507092,0.000558496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555294,0.0213593) , 
1, 0.0769229, 1, 0, 0.521458,0.0173422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343978,-0.0312115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760573,0.0129657) , 
2, 0.82425, 1, 0, 0.430941,-0.0485572) , 
1, 0.70811, 1, 0, 0.501134,0.00254514)    );
  // itree = 356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308032,0.0104006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600476,-0.0156113) , 
2, -0.281514, 1, 0, 0.48509,-0.0154082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673148,0.105402) , 
1, 2.00353, 1, 0, 0.489979,-0.00865465)    );
  // itree = 357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271089,0.0511893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12373,0.00826456) , 
1, 0.032123, 1, 0, 0.196427,0.0546522) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392999,-0.0421132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670257,-0.00443474) , 
2, -0.448068, 1, 0, 0.614599,-0.0348728) , 
3, -0.852844, 1, 0, 0.516996,-0.0139773)    );
  // itree = 358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185906,-0.0202976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0628441) , 
1, 0.268081, 1, 0, 0.0761958,-0.0950267) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494336,0.00391986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657119,-0.0164591) , 
2, 0.558658, 1, 0, 0.546866,-0.00756388) , 
2, -1.66446, 1, 0, 0.508843,-0.0146294)    );
  // itree = 359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125678,-0.0457557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528908,0.0432894) , 
0, -0.755659, 1, 0, 0.174205,-0.0793928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548397,-0.0319381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634435,0.00106064) , 
1, -1.49648, 1, 0, 0.623564,-0.00955893) , 
2, -0.662058, 1, 0, 0.482072,-0.0315479)    );
  // itree = 360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425325,0.000344428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468319,0.0294755) , 
1, 0.113317, 1, 0, 0.443334,0.0244365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385382,-0.0367353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744018,-0.00473432) , 
2, 0.743371, 1, 0, 0.593683,-0.0482167) , 
0, 1.31332, 1, 0, 0.48011,0.00666509)    );
  // itree = 361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251949,-0.0250018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652938,0.00700934) , 
0, -0.947009, 1, 0, 0.523051,-0.00534878) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244793,-0.0111451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551041,-0.0498189) , 
3, 0.274969, 1, 0, 0.400665,-0.082898) , 
1, 0.990731, 1, 0, 0.503929,-0.0174651)    );
  // itree = 362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.808286,0.0593352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511687,-0.00946828) , 
1, -2.03426, 1, 0, 0.522827,-0.015544) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515157,0.0754731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736461,0.0185615) , 
3, 0.274969, 1, 0, 0.655951,0.101186) , 
1, 1.31099, 1, 0, 0.534486,-0.00532058)    );
  // itree = 363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345204,0.078575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108316,0.00860808) , 
1, 0.032123, 1, 0, 0.203081,0.0756642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476727,0.00647747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659419,-0.00575394) , 
0, 0.455224, 1, 0, 0.561129,0.00132185) , 
2, -1.40713, 1, 0, 0.517744,0.01033)    );
  // itree = 364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.090148,-0.0143884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606481,0.0451271) , 
3, -1.05789, 1, 0, 0.323077,0.0408809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469411,-0.0130014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.890549,0.0171801) , 
3, 1.10492, 1, 0, 0.638204,-0.00586326) , 
2, -0.30891, 1, 0, 0.52442,0.0110148)    );
  // itree = 365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266425,0.0219349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374753,-0.0188251) , 
0, -2.02582, 1, 0, 0.350969,-0.022038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497996,0.0358716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809956,0.00757063) , 
3, 0.725173, 1, 0, 0.729597,0.04124) , 
0, 0.370203, 1, 0, 0.49413,0.00188769)    );
  // itree = 366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192069,0.00563642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406204,-0.0331831) , 
2, -0.873348, 1, 0, 0.320996,-0.0458569) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.700296,0.0237749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729173,-0.00778514) , 
0, 0.919461, 1, 0, 0.716616,0.0143599) , 
2, 0.109572, 1, 0, 0.501209,-0.0184269)    );
  // itree = 367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107774,0.00656179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244526,0.159054) , 
1, 0.608915, 1, 0, 0.149609,0.0618093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222178,-0.0275749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622368,-0.00139916) , 
2, -0.550738, 1, 0, 0.497219,-0.0232797) , 
3, -1.62955, 1, 0, 0.469374,-0.0164638)    );
  // itree = 368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491543,-0.0260351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919513,0.0364237) , 
2, 1.50785, 1, 0, 0.530725,-0.0519928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302871,0.0627345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56912,0.0136647) , 
0, -2.26714, 1, 0, 0.54175,0.0399093) , 
1, -0.700332, 1, 0, 0.53846,0.0124853)    );
  // itree = 369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38591,-0.0181048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88883,0.0142053) , 
3, 1.11691, 1, 0, 0.498803,-0.0285837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336993,0.0416322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602173,-0.0131337) , 
0, -0.446287, 1, 0, 0.479402,0.0180996) , 
1, 0.345387, 1, 0, 0.492125,-0.0125146)    );
  // itree = 370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478305,-0.0163887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57645,0.0140289) , 
1, -1.62087, 1, 0, 0.566815,0.026232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319961,-0.0593812) , 
1, 2.00221, 1, 0, 0.555303,0.0188278)    );
  // itree = 371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333167,0.0583437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556984,0.000413717) , 
2, -1.106, 1, 0, 0.53127,0.0155776) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0763092,-0.0513721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677708,-0.00542545) , 
2, -0.847933, 1, 0, 0.452166,-0.046448) , 
1, 0.38739, 1, 0, 0.5037,-0.00604014)    );
  // itree = 372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343061,0.0921956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359542,0.0350052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514261,4.07748e-05) , 
0, -1.80422, 1, 0, 0.495798,0.00829281) , 
2, -2.08407, 1, 0, 0.491667,0.0127228)    );
  // itree = 373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.587525,0.0278966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735841,-0.0088294) , 
2, 1.10012, 1, 0, 0.615754,0.0512934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220312,-0.0344043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628441,0.00246994) , 
0, -0.822809, 1, 0, 0.457625,-0.0302388) , 
1, -0.294962, 1, 0, 0.523126,0.003534)    );
  // itree = 374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444172,-0.00973965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472436,-0.0410786) , 
0, 2.14861, 1, 0, 0.445531,-0.0294164) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964171,0.0357869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831136,-0.00999654) , 
0, 3.55069, 1, 0, 0.919214,0.0311268) , 
3, 2.04277, 1, 0, 0.48252,-0.0246887)    );
  // itree = 375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131532,-0.0161398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520131,0.0079486) , 
2, -1.31942, 1, 0, 0.446426,0.00901569) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122812,-0.0394681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770793,-0.00785815) , 
3, 0.927182, 1, 0, 0.607308,-0.0435637) , 
0, 0.861216, 1, 0, 0.49431,-0.00663368)    );
  // itree = 376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132035,-0.0134769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625829,0.0434178) , 
3, -0.791529, 1, 0, 0.394868,0.0468947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.798295,0.0318129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644752,-0.00820149) , 
2, 0.280228, 1, 0, 0.666664,-0.00829567) , 
2, 0.0821085, 1, 0, 0.522632,0.0209512)    );
  // itree = 377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155436,-0.0198794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735532,0.0263568) , 
3, -0.542446, 1, 0, 0.439476,0.00774451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697702,0.0246812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587338,-0.0248094) , 
0, 0.920284, 1, 0, 0.60839,-0.043042) , 
0, 0.607167, 1, 0, 0.501762,-0.0109828)    );
  // itree = 378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923903,-0.0383776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420945,0.0286837) , 
2, -1.8153, 1, 0, 0.370638,0.0395635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323155,-0.0253456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775878,0.0041877) , 
3, 0.632646, 1, 0, 0.582618,-0.0242377) , 
0, -0.691462, 1, 0, 0.510218,-0.00244695)    );
  // itree = 379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416545,0.0124957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555566,-0.0102585) , 
0, -0.84483, 1, 0, 0.516596,-0.0106861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216273,0.0280247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478254,-0.0436307) , 
2, -1.14903, 1, 0, 0.410783,-0.0725006) , 
1, 1.08213, 1, 0, 0.501268,-0.0196406)    );
  // itree = 380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181517,-0.0138239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389217,-0.0380005) , 
3, -0.255942, 1, 0, 0.245096,-0.0552031) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.827362,0.0161416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695699,-0.0164495) , 
1, -0.0270664, 1, 0, 0.759294,-0.00366781) , 
3, 0.28719, 1, 0, 0.468234,-0.0328392)    );
  // itree = 381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.782599,0.109369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588726,0.000178297) , 
0, -0.510205, 1, 0, 0.640815,0.0843811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326638,-0.0272576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677966,0.00592268) , 
0, 0.343668, 1, 0, 0.471149,-0.0313295) , 
1, -1.4993, 1, 0, 0.48828,-0.0196468)    );
  // itree = 382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168784,0.00653099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313779,-0.0298413) , 
3, -0.782995, 1, 0, 0.216249,-0.0198906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.707121,0.011066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.693401,-0.0400334) , 
0, 2.95215, 1, 0, 0.706339,0.018718) , 
3, -0.299834, 1, 0, 0.520823,0.00410325)    );
  // itree = 383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964641,-0.0159502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423465,-0.0379393) , 
3, -1.35246, 1, 0, 0.229214,-0.0612052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.721971,0.0419534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543114,-0.000488538) , 
1, -1.7353, 1, 0, 0.554777,0.00619432) , 
0, -1.70986, 1, 0, 0.495621,-0.00605239)    );
  // itree = 384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48831,-0.00256179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543095,0.0290786) , 
1, 0.396427, 1, 0, 0.505966,0.0183431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267099,-0.0454555) , 
1, 2.04893, 1, 0, 0.495638,0.0122001)    );
  // itree = 385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393187,0.0195624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623206,-0.00163111) , 
2, -0.499911, 1, 0, 0.557306,0.0113848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614939,0.0364098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470739,0.00433374) , 
1, 0.611127, 1, 0, 0.534389,0.0421132) , 
1, -0.0270664, 1, 0, 0.546251,0.0262077)    );
  // itree = 386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301018,-0.00317122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581843,-0.0391094) , 
3, 0.218324, 1, 0, 0.379773,-0.0316887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.840777,0.00707497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825368,0.0403172) , 
1, 1.06751, 1, 0, 0.838001,0.0328377) , 
3, 0.908704, 1, 0, 0.516965,-0.0123697)    );
  // itree = 387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230092,0.00197055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364013,-0.0268963) , 
3, -0.255942, 1, 0, 0.278269,-0.0268132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.780236,0.0437917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787727,-0.00159468) , 
3, 0.690725, 1, 0, 0.786231,0.0201624) , 
3, 0.28719, 1, 0, 0.499298,-0.0063728)    );
  // itree = 388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515756,0.0135411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705253,-0.0128981) , 
2, 1.04815, 1, 0, 0.548704,0.0202252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349278,-0.0645516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352063,-0.020977) , 
1, 2.00376, 1, 0, 0.350918,-0.0938127) , 
1, 1.66439, 1, 0, 0.534452,0.012008)    );
  // itree = 389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424477,-0.0131845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538739,-0.0531085) , 
2, 1.43729, 1, 0, 0.42988,-0.0389993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.953842,0.0300669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841957,-0.00808684) , 
1, 0.40566, 1, 0, 0.919159,0.0292183) , 
3, 1.96522, 1, 0, 0.471731,-0.0331642)    );
  // itree = 390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391901,0.000389179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767672,0.0267806) , 
2, -0.00969475, 1, 0, 0.590086,0.0356023) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402309,-0.0252192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511112,0.000161543) , 
1, 0.557083, 1, 0, 0.461409,-0.0276885) , 
1, -0.0229864, 1, 0, 0.522639,0.00242822)    );
  // itree = 391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557798,-0.0297901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506216,0.00483718) , 
1, -1.65583, 1, 0, 0.509667,0.00486156) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227199,-0.0681998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683327,0.00160209) , 
0, -0.771506, 1, 0, 0.480318,-0.062888) , 
1, 1.08213, 1, 0, 0.505431,-0.00491853)    );
  // itree = 392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147397,4.54518e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170212,-0.0541757) , 
2, -1.15459, 1, 0, 0.154773,-0.038726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580397,0.023484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695684,-0.0044168) , 
2, 0.453754, 1, 0, 0.637383,0.0228488) , 
2, -0.724736, 1, 0, 0.49504,0.00468779)    );
  // itree = 393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342323,0.0143711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199308,-0.0282465) , 
1, 1.48945, 1, 0, 0.333086,0.0269477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.781513,-0.0147322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792786,0.0140774) , 
1, 0.483982, 1, 0, 0.784992,-0.0118515) , 
3, 0.506153, 1, 0, 0.507979,0.011932)    );
  // itree = 394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212276,0.00291785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568616,-0.069634) , 
3, -0.300339, 1, 0, 0.286103,-0.0369045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368998,0.0189689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767537,0.000568145) , 
3, 0.362166, 1, 0, 0.644307,0.0169809) , 
0, -0.691462, 1, 0, 0.497073,-0.00516779)    );
  // itree = 395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0784763,-0.0125083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0723833,-0.0492061) , 
2, -1.97789, 1, 0, 0.0753068,-0.0726453) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370547,0.080205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54013,0.00066883) , 
2, -1.36127, 1, 0, 0.533638,0.00789414) , 
2, -1.63878, 1, 0, 0.496975,0.00145163)    );
  // itree = 396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52581,-0.000530374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437907,-0.0199056) , 
1, -0.763719, 1, 0, 0.469599,-0.0318237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476005,0.0309349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758005,-0.00843402) , 
2, 0.930301, 1, 0, 0.518175,0.0507498) , 
1, 0.70811, 1, 0, 0.480983,-0.0124731)    );
  // itree = 397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481854,-0.0385277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539193,0.00485988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424161,-0.012843) , 
1, 0.46655, 1, 0, 0.497425,-0.00285882) , 
1, -1.81119, 1, 0, 0.496719,-0.00783105)    );
  // itree = 398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12365,-0.0555931) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536703,-0.0106971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495261,0.0117447) , 
1, -0.607352, 1, 0, 0.50837,0.00940736) , 
0, -3.18592, 1, 0, 0.491443,0.00260511)    );
  // itree = 399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370967,0.00833756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634946,-0.0195115) , 
2, 0.0243524, 1, 0, 0.48724,-0.0105234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.955492,0.0572545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886314,0.00807696) , 
2, 2.01575, 1, 0, 0.928941,0.107057) , 
2, 1.61025, 1, 0, 0.521279,-0.00146215)    );
  // itree = 400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34367,-0.000578128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331499,-0.0325175) , 
0, 0.0100771, 1, 0, 0.341052,-0.0221307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.852821,0.0295036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752217,-0.00201536) , 
2, 0.666691, 1, 0, 0.787243,0.0182074) , 
3, 0.660704, 1, 0, 0.502881,-0.00750045)    );
  // itree = 401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151126,-0.0389692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518468,0.00499922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472173,-0.00944485) , 
1, 0.201478, 1, 0, 0.499584,-0.00179223) , 
0, -3.13399, 1, 0, 0.484488,-0.00656364)    );
  // itree = 402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164931,-0.0506441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620046,-0.0121808) , 
3, -0.304384, 1, 0, 0.441063,-0.0820897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542468,0.00908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400246,-0.023605) , 
1, 1.08413, 1, 0, 0.518841,0.0101297) , 
1, -1.7353, 1, 0, 0.512813,0.00298159)    );
  // itree = 403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454965,0.0876579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117723,0.0240687) , 
1, -0.19331, 1, 0, 0.227182,0.0914491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526873,0.000550323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476294,-0.0201762) , 
1, 0.823393, 1, 0, 0.516308,-0.0103991) , 
2, -1.57101, 1, 0, 0.491901,-0.00180164)    );
  // itree = 404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830181,0.0694003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612349,0.014996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464824,-0.00392211) , 
1, -0.58973, 1, 0, 0.507313,0.00321303) , 
1, -2.0516, 1, 0, 0.517164,0.00950638)    );
  // itree = 405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527279,-0.021822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606853,0.0267413) , 
1, -0.784849, 1, 0, 0.540515,-0.0352933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397973,-0.0199263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459554,0.00389238) , 
1, -0.43375, 1, 0, 0.453482,0.00354857) , 
1, -0.636138, 1, 0, 0.480342,-0.00843878)    );
  // itree = 406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124624,-0.02848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533497,0.018589) , 
0, -2.83959, 1, 0, 0.49807,0.0336384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50435,-0.0280309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81647,0.0130715) , 
2, 1.1382, 1, 0, 0.630531,-0.0306679) , 
0, 1.23997, 1, 0, 0.530103,0.0180872)    );
  // itree = 407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354822,-0.0172193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.855285,0.011604) , 
3, 1.13576, 1, 0, 0.428967,-0.0299709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72542,0.0774809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.806788,0.00568049) , 
2, 1.34365, 1, 0, 0.788935,0.0501158) , 
2, 1.19483, 1, 0, 0.480739,-0.0184527)    );
  // itree = 408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0240807,-0.0329221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519793,0.0581374) , 
3, -2.13134, 1, 0, 0.308267,0.0783784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491695,-0.0322858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499463,-0.00490583) , 
1, -1.52183, 1, 0, 0.498619,-0.0197504) , 
0, -2.26038, 1, 0, 0.480016,-0.0101604)    );
  // itree = 409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379525,0.0166056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861579,-0.0102057) , 
3, 0.41255, 1, 0, 0.470127,0.0293536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387141,-0.020484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.870446,0.0104971) , 
3, 1.40976, 1, 0, 0.658157,-0.0140511) , 
0, 0.861216, 1, 0, 0.537076,0.0138992)    );
  // itree = 410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206068,0.00804792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485009,-0.049607) , 
3, -0.318006, 1, 0, 0.293841,-0.0299449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.770708,0.0271307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667828,0.00355968) , 
1, -0.962158, 1, 0, 0.689738,0.0214815) , 
2, -0.155261, 1, 0, 0.506941,-0.00226356)    );
  // itree = 411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0724411,0.0121435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0528165,-0.0598373) , 
3, -2.17729, 1, 0, 0.0592353,-0.092179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.720918,0.0294938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522632,-0.00253978) , 
1, -1.49648, 1, 0, 0.540648,0.00149769) , 
2, -1.60605, 1, 0, 0.499401,-0.00652842)    );
  // itree = 412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.08569,-0.00416322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604696,0.0519866) , 
3, -1.18863, 1, 0, 0.280222,0.0446466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56803,-0.00975772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755972,0.0316589) , 
1, 1.15272, 1, 0, 0.584396,-0.0145259) , 
2, -0.871865, 1, 0, 0.509613,2.19748e-05)    );
  // itree = 413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158972,-0.0724744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259158,-0.011631) , 
1, -1.3358, 1, 0, 0.245115,-0.0540236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612034,0.0112382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6087,-0.0239923) , 
1, 1.22182, 1, 0, 0.61173,0.0187623) , 
0, -1.65048, 1, 0, 0.544048,0.00532505)    );
  // itree = 414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134707,-0.0236954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231055,0.0740013) , 
1, 1.10806, 1, 0, 0.145032,-0.0308072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674916,0.014416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436861,-0.0384984) , 
1, 1.40086, 1, 0, 0.652384,0.0245254) , 
3, -0.5926, 1, 0, 0.4991,0.00780793)    );
  // itree = 415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10788,-0.00958315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406325,0.0587898) , 
2, -1.8979, 1, 0, 0.281655,0.0746075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0461674,-0.073518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556396,0.00348048) , 
2, -1.44784, 1, 0, 0.520165,0.000999785) , 
0, -2.35295, 1, 0, 0.499075,0.00750819)    );
  // itree = 416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818845,0.0623933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344129,-0.0115213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838488,0.00939945) , 
3, 0.908704, 1, 0, 0.470041,-0.0146098) , 
1, -2.23323, 1, 0, 0.480004,-0.00920436)    );
  // itree = 417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427766,-0.0164274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787766,0.0141806) , 
0, 1.21408, 1, 0, 0.503447,-0.025024) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381225,0.116513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563932,0.0201818) , 
0, -1.69235, 1, 0, 0.526972,0.0685252) , 
1, 0.653132, 1, 0, 0.509003,-0.00292822)    );
  // itree = 418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176913,0.0263834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304212,-0.0333441) , 
2, -1.40005, 1, 0, 0.258793,-0.0378632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559927,0.0134345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604695,-0.00963434) , 
0, 0.918137, 1, 0, 0.580295,0.00522308) , 
0, -0.896003, 1, 0, 0.476562,-0.00867881)    );
  // itree = 419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260669,-0.0194781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645634,-0.0767255) , 
3, 0.565738, 1, 0, 0.393688,-0.0943181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0922757,-0.0180703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640649,0.00463866) , 
3, -0.716903, 1, 0, 0.490882,0.000670643) , 
1, -1.69021, 1, 0, 0.483392,-0.00664938)    );
  // itree = 420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186245,-0.0491654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204863,-0.0117761) , 
1, -0.699421, 1, 0, 0.199868,-0.061527) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370994,0.0511989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53338,0.00022675) , 
0, -1.48883, 1, 0, 0.514827,0.00973534) , 
0, -2.36962, 1, 0, 0.4853,0.00305457)    );
  // itree = 421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397499,0.00578932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700991,0.0368169) , 
2, 0.472108, 1, 0, 0.433673,0.023693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.855003,0.0392861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699742,-0.0239958) , 
0, 0.548385, 1, 0, 0.727467,-0.0264344) , 
2, 0.731099, 1, 0, 0.500658,0.012264)    );
  // itree = 422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190098,0.0136891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183224,-0.0610541) , 
2, -1.39632, 1, 0, 0.187287,-0.0455282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207022,-0.00656026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731767,0.00871144) , 
3, -0.0267674, 1, 0, 0.52847,0.00772739) , 
0, -2.25694, 1, 0, 0.492644,0.0021352)    );
  // itree = 423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.607301,-0.00198039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723533,0.0539735) , 
1, -0.81405, 1, 0, 0.63453,0.0279886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374592,-0.0348842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462846,-0.0028517) , 
1, 0.0697643, 1, 0, 0.431608,-0.0343185) , 
1, -0.591326, 1, 0, 0.481329,-0.0190519)    );
  // itree = 424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398859,-0.0560838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524242,0.0051306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624141,-0.0403211) , 
0, 2.89272, 1, 0, 0.52796,0.00705869) , 
1, -1.9769, 1, 0, 0.521161,-0.000929418)    );
  // itree = 425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34377,0.00810696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756223,0.0516103) , 
2, 0.33788, 1, 0, 0.39013,0.0332681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.796748,0.0430295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610847,-0.012041) , 
1, -1.48186, 1, 0, 0.627484,-0.0165715) , 
0, -0.122417, 1, 0, 0.51281,0.00750787)    );
  // itree = 426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369959,0.0203751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5945,0.000381286) , 
0, -0.707105, 1, 0, 0.518534,0.0155582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302268,-0.0453537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447342,0.0270218) , 
1, 1.49049, 1, 0, 0.363277,-0.0450057) , 
1, 1.05945, 1, 0, 0.494434,0.00615681)    );
  // itree = 427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18786,-0.00117919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.444708,-0.0206992) , 
3, -0.476202, 1, 0, 0.341372,-0.0370421) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.877699,0.0037615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846145,0.0297518) , 
1, 0.371143, 1, 0, 0.866272,0.0305574) , 
3, 0.908704, 1, 0, 0.472497,-0.0201551)    );
  // itree = 428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256327,-0.00513415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246427,-0.0418049) , 
2, -0.105747, 1, 0, 0.254117,-0.0391036) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.809839,0.0551539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735924,-0.00945007) , 
3, 0.387692, 1, 0, 0.745287,0.00357489) , 
3, 0.17816, 1, 0, 0.48757,-0.0188185)    );
  // itree = 429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271834,0.0141356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535826,-0.0344815) , 
3, -0.233084, 1, 0, 0.378726,-0.0198926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.649642,-0.0163327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756618,0.0267576) , 
1, -1.36512, 1, 0, 0.745185,0.0492043) , 
2, 0.161708, 1, 0, 0.544095,0.0112882)    );
  // itree = 430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568207,0.0662365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557053,0.0113125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509163,-0.0206664) , 
1, 1.049, 1, 0, 0.549462,0.0148532) , 
1, -1.86956, 1, 0, 0.550431,0.0231651)    );
  // itree = 431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0167912,-0.0449646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623775,0.0143129) , 
3, -1.62955, 1, 0, 0.572777,0.0277736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379211,0.0239632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564943,-0.038243) , 
2, -0.325785, 1, 0, 0.48179,-0.0357507) , 
1, 0.71376, 1, 0, 0.551381,0.0128353)    );
  // itree = 432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.752022,0.0709449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483652,-0.00363643) , 
1, -1.80654, 1, 0, 0.49642,-1.39514e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169031,0.00661709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.828908,0.0544255) , 
2, -0.706578, 1, 0, 0.564472,0.0941065) , 
1, 1.32833, 1, 0, 0.502553,0.00846743)    );
  // itree = 433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588979,0.0104472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422973,-0.0180876) , 
1, 0.10725, 1, 0, 0.514794,-0.00458715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521341,0.0605573) , 
1, 1.89, 1, 0, 0.515062,0.00115873)    );
  // itree = 434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181165,-0.0571674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722767,-0.00774952) , 
3, -0.305149, 1, 0, 0.51345,-0.0831427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53153,0.00679806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501017,-0.00925743) , 
1, 0.621342, 1, 0, 0.522858,0.00459973) , 
1, -1.50845, 1, 0, 0.522039,-0.00303694)    );
  // itree = 435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.665473,-0.0012634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323972,-0.0582265) , 
1, -1.33235, 1, 0, 0.531962,-0.0581348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173185,-0.0114747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690717,0.00514149) , 
3, -0.237768, 1, 0, 0.467486,-0.003184) , 
1, -1.03815, 1, 0, 0.479874,-0.0137415)    );
  // itree = 436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423924,-0.00826385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.91842,0.020389) , 
3, 1.42475, 1, 0, 0.506416,-0.0104775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519637,0.0286307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297592,-0.0268824) , 
1, 2.14713, 1, 0, 0.482402,0.0419618) , 
1, 0.988758, 1, 0, 0.502233,-0.00134332)    );
  // itree = 437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431175,-0.0271823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464737,-0.00233083) , 
1, -1.61067, 1, 0, 0.462497,-0.0102293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555895,0.0509843) , 
1, 1.81888, 1, 0, 0.466487,-0.00516882)    );
  // itree = 438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309889,0.0171044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514723,-0.022782) , 
0, -1.15272, 1, 0, 0.464867,-0.0329856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435429,0.0128708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572649,-0.0469078) , 
0, 2.11278, 1, 0, 0.447477,0.0131781) , 
1, 0.24729, 1, 0, 0.458263,-0.0154539)    );
  // itree = 439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138707,0.0440364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58051,0.0916162) , 
3, -2.09864, 1, 0, 0.348954,0.162459) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411321,0.0283548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590138,-0.00715053) , 
0, -1.00116, 1, 0, 0.550267,5.78943e-05) , 
0, -2.90248, 1, 0, 0.536049,0.011528)    );
  // itree = 440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463719,0.000797112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446426,0.0265305) , 
1, -0.259045, 1, 0, 0.454483,0.0351456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.710233,-0.00587748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550731,-0.0580007) , 
1, 0.893255, 1, 0, 0.68627,-0.0360571) , 
2, 0.380334, 1, 0, 0.546436,0.0068985)    );
  // itree = 441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.583685,0.00623745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406891,-0.0179178) , 
1, -0.34329, 1, 0, 0.490681,-0.0145061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.677367,0.0419041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508695,0.00443657) , 
1, 1.03038, 1, 0, 0.572613,0.0459571) , 
1, 0.70811, 1, 0, 0.507255,-0.00227541)    );
  // itree = 442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359131,0.00324612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589722,-0.0202165) , 
0, -0.218015, 1, 0, 0.4783,-0.0210157) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201212,-0.0698882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503026,-0.0132731) , 
2, -0.26898, 1, 0, 0.335353,-0.124282) , 
1, 1.69592, 1, 0, 0.469209,-0.0275832)    );
  // itree = 443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165208,-0.00468981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235246,-0.0617354) , 
2, -1.51771, 1, 0, 0.191064,-0.0660858) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423088,0.0148487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781287,-0.00545978) , 
3, 0.775071, 1, 0, 0.563588,0.0164512) , 
0, -2.25576, 1, 0, 0.519222,0.00662148)    );
  // itree = 444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56316,0.03082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358298,-0.0146955) , 
1, -1.58142, 1, 0, 0.370024,-0.028148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.779401,0.025836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732123,-0.0164768) , 
2, 1.56649, 1, 0, 0.768763,0.0378437) , 
2, 0.560086, 1, 0, 0.485648,-0.0090122)    );
  // itree = 445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0873194,-0.0816541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142947,-0.0280213) , 
1, -1.3411, 1, 0, 0.137215,-0.0830542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.819915,0.0162298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687439,-0.00626042) , 
0, -0.129695, 1, 0, 0.713931,-0.00413245) , 
3, -0.25059, 1, 0, 0.465026,-0.0381943)    );
  // itree = 446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11989,-0.0110053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662655,0.0100786) , 
3, -0.773433, 1, 0, 0.498767,0.0112693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469809,0.050071) , 
1, 2.01789, 1, 0, 0.497635,0.0150735)    );
  // itree = 447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520731,-0.0193864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491574,0.000612448) , 
1, -0.753391, 1, 0, 0.502203,-0.0162754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431868,0.0052996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.864047,0.0473628) , 
2, 1.21939, 1, 0, 0.477345,0.0252915) , 
1, 0.728565, 1, 0, 0.495685,-0.0053763)    );
  // itree = 448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174353,0.00583038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805414,0.0522428) , 
3, -0.51182, 1, 0, 0.450912,0.0615455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556015,-0.0105705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.925419,0.0261447) , 
3, 1.99217, 1, 0, 0.637386,-0.00949427) , 
0, 0.510979, 1, 0, 0.523935,0.0337264)    );
  // itree = 449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357175,0.0467835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56748,0.000207567) , 
0, -1.80149, 1, 0, 0.536488,0.016992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289962,-0.0338606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549898,-0.00901313) , 
0, -0.773058, 1, 0, 0.442927,-0.0464193) , 
1, -0.0246959, 1, 0, 0.489684,-0.0147292)    );
  // itree = 450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393978,0.0238867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18708,-0.0178401) , 
1, 0.566038, 1, 0, 0.320989,0.0209172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423136,-0.0259204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774429,0.0063726) , 
2, 0.693311, 1, 0, 0.549765,-0.0387853) , 
0, -0.912281, 1, 0, 0.476116,-0.0195654)    );
  // itree = 451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474472,-0.00309713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613016,-0.0573544) , 
2, 1.41018, 1, 0, 0.484595,-0.017083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954583,0.0453575) , 
3, 2.52881, 1, 0, 0.498695,-0.013482)    );
  // itree = 452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294802,-0.0542261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290147,-0.00528298) , 
1, -1.12701, 1, 0, 0.290492,-0.0252401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545652,0.031283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633548,0.00298488) , 
0, 0.206147, 1, 0, 0.605322,0.026994) , 
0, -0.947009, 1, 0, 0.498992,0.00935251)    );
  // itree = 453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170314,-0.0183925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534732,0.0269655) , 
2, -1.16881, 1, 0, 0.393298,0.0242946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573272,-0.00829004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.826624,0.0173463) , 
0, 2.42484, 1, 0, 0.60602,-0.0109059) , 
0, -0.84483, 1, 0, 0.536783,0.000551159)    );
  // itree = 454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188269,0.00140041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601544,0.0489441) , 
3, -0.430696, 1, 0, 0.25137,0.0214559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.687705,-0.00257937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559362,-0.0260328) , 
1, 0.433814, 1, 0, 0.645914,-0.0266185) , 
3, -0.18324, 1, 0, 0.483763,-0.00686074)    );
  // itree = 455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.813994,0.059971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453581,-0.00360952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728837,0.0134942) , 
0, 1.96897, 1, 0, 0.486872,-0.00242471) , 
1, -1.99305, 1, 0, 0.49569,0.000309756)    );
  // itree = 456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202382,-0.000332136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399561,-0.0212975) , 
0, -1.86235, 1, 0, 0.355063,-0.0405321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697017,0.0118957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504529,-0.0329395) , 
1, 0.976475, 1, 0, 0.669851,0.0114927) , 
0, 0.597232, 1, 0, 0.46789,-0.0218853)    );
  // itree = 457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248629,-0.00566075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108327,-0.0290005) , 
0, -1.17601, 1, 0, 0.190265,-0.0369096) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.800783,0.0305572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67455,-0.000563238) , 
1, -0.937348, 1, 0, 0.700565,0.0141255) , 
3, -0.28269, 1, 0, 0.500238,-0.00590919)    );
  // itree = 458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265357,-0.0183397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315428,0.00410128) , 
0, -1.50977, 1, 0, 0.296444,-0.00827877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.953297,0.0784156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78675,0.0171762) , 
2, 0.0818948, 1, 0, 0.808238,0.0540232) , 
3, 0.228801, 1, 0, 0.526727,0.0197542)    );
  // itree = 459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340084,-0.00265948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781696,0.0166961) , 
3, 0.660153, 1, 0, 0.424986,0.00264719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357118,-0.0512353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.867684,0.000817333) , 
3, 1.3426, 1, 0, 0.675682,-0.0539524) , 
2, 0.827757, 1, 0, 0.481873,-0.0101962)    );
  // itree = 460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169019,-0.023047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0646679) , 
3, -0.0715217, 1, 0, 0.239508,-0.0367877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598789,-0.0224433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65912,0.0202535) , 
1, -0.696094, 1, 0, 0.642358,0.0215668) , 
0, -0.773058, 1, 0, 0.488575,-0.000709357)    );
  // itree = 461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369595,0.00139869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.864327,0.0335337) , 
3, 0.516873, 1, 0, 0.527118,0.0237088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46166,-0.0377575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885259,0.000521621) , 
3, 2.06477, 1, 0, 0.694176,-0.0557677) , 
0, 2.30263, 1, 0, 0.541121,0.0170472)    );
  // itree = 462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374759,0.0604238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265491,-0.0187742) , 
1, -1.38631, 1, 0, 0.273807,-0.0304604) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526197,-0.0161514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720835,0.012707) , 
0, -0.427166, 1, 0, 0.676665,0.0133869) , 
2, -0.224534, 1, 0, 0.480239,-0.00799219)    );
  // itree = 463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0688319,-0.0139738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502633,0.0335588) , 
3, -1.45918, 1, 0, 0.351564,0.0387595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.630743,-0.0224554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579188,0.00253036) , 
1, -0.269474, 1, 0, 0.60339,-0.019236) , 
0, -0.691462, 1, 0, 0.508864,0.00253341)    );
  // itree = 464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0308712,-0.0309176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302022,0.036524) , 
3, -2.23255, 1, 0, 0.253599,0.0562555) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642699,0.0136222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503707,-0.0127478) , 
1, -0.700332, 1, 0, 0.543409,-0.0132184) , 
2, -1.15149, 1, 0, 0.490759,-0.000597121)    );
  // itree = 465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102063,0.0219653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569062,0.0594805) , 
3, -1.69932, 1, 0, 0.355647,0.0894091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565349,-0.00584612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78564,0.0449181) , 
1, 1.81136, 1, 0, 0.574617,-0.00964729) , 
0, -1.4678, 1, 0, 0.535419,0.00808518)    );
  // itree = 466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617094,0.014511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483129,-0.0478363) , 
1, -0.921928, 1, 0, 0.555759,-0.0314707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378439,0.0303939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629567,0.00384534) , 
2, -0.281514, 1, 0, 0.521155,0.0317247) , 
1, -0.414745, 1, 0, 0.534007,0.00825333)    );
  // itree = 467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278892,-0.00363665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533178,-0.0332433) , 
2, -0.0690322, 1, 0, 0.414328,-0.0562291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250324,0.0330827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66392,-0.00789531) , 
3, -0.276907, 1, 0, 0.516839,0.00936345) , 
1, -0.962158, 1, 0, 0.494079,-0.00520013)    );
  // itree = 468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105353,-0.00819339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434361,0.04504) , 
3, -1.03116, 1, 0, 0.243924,0.0335932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616331,-0.0390393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670813,-0.00354715) , 
0, -0.501079, 1, 0, 0.662407,-0.0225983) , 
3, -0.28269, 1, 0, 0.522512,-0.00381389)    );
  // itree = 469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253398,-0.0181329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0927213,-0.0594237) , 
1, 1.12094, 1, 0, 0.227156,-0.0604667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92218,0.0654688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53978,0.00359764) , 
1, -2.00084, 1, 0, 0.553743,0.0133986) , 
2, -0.759232, 1, 0, 0.472817,-0.00490477)    );
  // itree = 470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644266,0.0591805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.847468,0.0064858) , 
2, 0.172994, 1, 0, 0.739397,0.0928757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23232,-0.0181263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.79053,0.00358531) , 
3, 0.178444, 1, 0, 0.506919,-0.0184758) , 
1, -1.71379, 1, 0, 0.519755,-0.0123279)    );
  // itree = 471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515479,-0.0251467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631033,0.0209449) , 
1, -1.66125, 1, 0, 0.604927,0.0222419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29283,0.0300383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472089,-0.01389) , 
0, -2.24414, 1, 0, 0.454951,-0.0244035) , 
1, -0.565578, 1, 0, 0.500248,-0.010315)    );
  // itree = 472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234188,0.0136108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442659,-0.0141036) , 
2, -1.04236, 1, 0, 0.393697,-0.0204908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.907271,0.0623784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75307,0.00596086) , 
2, 0.781049, 1, 0, 0.774239,0.0349202) , 
2, 0.604931, 1, 0, 0.508122,-0.00382935)    );
  // itree = 473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0759438,-0.00850864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227774,0.0480317) , 
2, -1.67287, 1, 0, 0.144967,0.0355462) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291677,-0.0286431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574429,-0.00209105) , 
0, -1.0273, 1, 0, 0.497262,-0.0236223) , 
3, -1.63702, 1, 0, 0.465282,-0.0182512)    );
  // itree = 474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547303,0.00441946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411556,-0.031822) , 
1, 0.41053, 1, 0, 0.525165,-0.0051764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181355,-0.00528804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816907,0.0523137) , 
2, -0.550227, 1, 0, 0.537275,0.0675366) , 
1, 0.820442, 1, 0, 0.52736,0.00800182)    );
  // itree = 475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27483,-0.0167354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66455,0.00766595) , 
2, -0.15663, 1, 0, 0.482415,-0.00772262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780451,0.0713987) , 
1, 1.89, 1, 0, 0.490676,-0.00238511)    );
  // itree = 476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157178,-0.0111268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311097,-0.0296059) , 
3, -0.654599, 1, 0, 0.238036,-0.0550489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.770946,0.0182759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773873,-0.00671138) , 
2, 0.345751, 1, 0, 0.77289,0.00188696) , 
3, 0.17816, 1, 0, 0.481671,-0.0291136)    );
  // itree = 477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431003,-0.0333364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500882,0.00911631) , 
1, -1.27016, 1, 0, 0.491984,0.00687091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251658,-0.0630531) , 
1, 1.98002, 1, 0, 0.482976,0.00133682)    );
  // itree = 478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480548,-0.00125814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478661,0.0258751) , 
1, 1.20679, 1, 0, 0.480301,0.00541623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487114,-0.0475245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.876326,-0.00509922) , 
3, 2.19563, 1, 0, 0.695674,-0.081551) , 
0, 2.58669, 1, 0, 0.492499,0.000490784)    );
  // itree = 479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176761,-0.0140795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721392,0.0216452) , 
3, -0.319266, 1, 0, 0.465731,0.0135838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378826,-0.0576705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813568,-0.00428847) , 
3, 0.938558, 1, 0, 0.714594,-0.0450299) , 
2, 0.705933, 1, 0, 0.526896,-0.0008222)    );
  // itree = 480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286204,0.0826272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323162,0.0149613) , 
2, -1.67474, 1, 0, 0.304649,0.100028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476767,-0.0249668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529317,0.00197411) , 
1, -1.71379, 1, 0, 0.525501,5.97384e-05) , 
0, -3.13399, 1, 0, 0.513625,0.00543535)    );
  // itree = 481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314817,-0.0292142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52061,0.00965332) , 
1, -1.65757, 1, 0, 0.499589,0.0123297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4122,-0.0397481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598018,0.00549254) , 
1, 1.5092, 1, 0, 0.503698,-0.0413102) , 
1, 1.08213, 1, 0, 0.500119,0.00540603)    );
  // itree = 482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139174,-0.0391448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598833,0.00710057) , 
2, -1.5647, 1, 0, 0.568347,0.0102224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266252,-0.039808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808537,0.0176558) , 
2, 0.64748, 1, 0, 0.396507,-0.0590128) , 
1, 0.732462, 1, 0, 0.526107,-0.00679607)    );
  // itree = 483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541376,-0.00928321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535578,0.0193743) , 
1, -0.786737, 1, 0, 0.537916,0.0172583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300106,-0.0502583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410589,-0.00905496) , 
1, 0.547373, 1, 0, 0.390709,-0.0369581) , 
1, 0.38739, 1, 0, 0.488489,-0.000945867)    );
  // itree = 484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41733,-0.00760508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432225,-0.0338665) , 
0, 1.47319, 1, 0, 0.418742,-0.0273036) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.941672,0.0320871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808793,-0.0181437) , 
0, 3.28247, 1, 0, 0.919024,0.037674) , 
3, 1.5996, 1, 0, 0.49265,-0.0177043)    );
  // itree = 485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541041,0.00429775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681602,-0.0412764) , 
0, 2.18127, 1, 0, 0.557036,-0.0020685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136291,0.012883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421508,-0.0203707) , 
2, -1.82295, 1, 0, 0.394582,-0.0387178) , 
1, 0.183541, 1, 0, 0.483744,-0.018603)    );
  // itree = 486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121308,-0.0182897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457623,0.0273211) , 
2, -1.61412, 1, 0, 0.402131,0.0441628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497562,-0.0146629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724855,0.00853654) , 
2, 0.544727, 1, 0, 0.646389,0.00248258) , 
2, 0.161708, 1, 0, 0.511073,0.0255729)    );
  // itree = 487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398034,-0.0138516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431956,0.00723328) , 
1, 0.921998, 1, 0, 0.403572,-0.0225685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.933682,0.019617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853963,0.0252595) , 
1, 0.63573, 1, 0, 0.911294,0.0413317) , 
3, 1.71339, 1, 0, 0.455159,-0.016076)    );
  // itree = 488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187365,-0.00176076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427147,0.0552564) , 
2, -0.491209, 1, 0, 0.229224,0.0238278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430626,0.00998119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725616,-0.00956751) , 
3, 0.167085, 1, 0, 0.656225,-0.0100191) , 
3, -0.266059, 1, 0, 0.508023,0.00172836)    );
  // itree = 489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216573,0.0167984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0887948) , 
3, -0.884179, 1, 0, 0.327885,0.0548771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.646959,0.00994288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487228,-0.0187765) , 
1, -0.962158, 1, 0, 0.523138,-0.0301882) , 
0, -1.66373, 1, 0, 0.488635,-0.0151562)    );
  // itree = 490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131333,-0.0191751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561182,-0.0823512) , 
3, -0.913459, 1, 0, 0.212853,-0.0723166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485654,0.0117578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686995,-0.0118086) , 
2, 0.735696, 1, 0, 0.548421,0.0109471) , 
0, -1.4678, 1, 0, 0.477593,-0.00662745)    );
  // itree = 491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256969,-0.020264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673191,0.00263701) , 
2, -0.224534, 1, 0, 0.487622,-0.015552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451529,-0.0574246) , 
1, 1.59425, 1, 0, 0.485892,-0.0196898)    );
  // itree = 492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246537,0.0211278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74637,0.06359) , 
2, -0.701417, 1, 0, 0.34281,0.0544921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120604,-0.02539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700757,0.0054909) , 
3, -0.377568, 1, 0, 0.54219,-0.0045306) , 
0, -1.77887, 1, 0, 0.508192,0.005534)    );
  // itree = 493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226307,-0.0110033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790892,0.0132099) , 
3, -0.0522943, 1, 0, 0.47424,-0.00214868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619459,-0.0703509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780654,-0.00416926) , 
0, 2.48627, 1, 0, 0.692473,-0.106005) , 
2, 1.43963, 1, 0, 0.49009,-0.00969155)    );
  // itree = 494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172329,0.0894753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636929,0.0241876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471839,-0.00449321) , 
1, -1.31868, 1, 0, 0.489907,-0.00199316) , 
3, -2.079, 1, 0, 0.47789,0.00208794)    );
  // itree = 495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553428,-0.00488927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414693,-0.0305) , 
1, 0.00948879, 1, 0, 0.515496,-0.0286276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0837665,-0.011605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646606,0.0263628) , 
3, -0.405683, 1, 0, 0.484002,0.0412634) , 
1, 0.641961, 1, 0, 0.507738,-0.01141)    );
  // itree = 496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129874,-0.0362687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4967,0.00279453) , 
0, -3.02048, 1, 0, 0.479307,0.00199009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421338,0.052148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576848,0.0174423) , 
0, -0.70126, 1, 0, 0.514804,0.0703758) , 
1, 1.30691, 1, 0, 0.482466,0.00807614)    );
  // itree = 497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12102,-0.00912878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115387,-0.0723912) , 
2, -1.87959, 1, 0, 0.117669,-0.111951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572383,-0.0474215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538366,0.00844683) , 
1, -1.86485, 1, 0, 0.540073,0.0129568) , 
0, -2.41637, 1, 0, 0.497312,0.000312265)    );
  // itree = 498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408575,0.00241465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628773,-0.0118138) , 
2, 0.110847, 1, 0, 0.518232,-0.0112977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334643,0.0501195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710704,0.000945927) , 
2, 0.00247071, 1, 0, 0.465792,0.055551) , 
1, 0.71376, 1, 0, 0.506633,0.00348853)    );
  // itree = 499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121992,-0.00226806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294554,-0.0592853) , 
3, -0.626585, 1, 0, 0.159329,-0.0382548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623684,0.0197469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654191,-0.0063792) , 
2, 0.388231, 1, 0, 0.640194,0.010881) , 
2, -0.767121, 1, 0, 0.508817,-0.00254333)    );
  // itree = 500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233624,-0.0505581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383084,0.0195048) , 
1, -1.27354, 1, 0, 0.36005,0.0122766) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411145,-0.0247836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706586,0.00227338) , 
2, 0.412586, 1, 0, 0.552401,-0.0294927) , 
0, -0.691462, 1, 0, 0.487672,-0.0154369)    );
  // itree = 501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545731,0.00829369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378764,-0.0191451) , 
1, -0.374549, 1, 0, 0.438659,-0.019514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595063,-0.00819117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851876,0.0327261) , 
2, 1.29791, 1, 0, 0.777586,0.0546975) , 
2, 0.999858, 1, 0, 0.495988,-0.00696125)    );
  // itree = 502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274267,0.0211457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287092,-0.0470471) , 
2, -1.23715, 1, 0, 0.281077,-0.0385517) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562536,0.0115696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668195,-0.0206732) , 
0, 2.56101, 1, 0, 0.572476,0.0182288) , 
0, -1.5378, 1, 0, 0.508597,0.00578166)    );
  // itree = 503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35218,0.0714464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257147,0.0169937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607298,-0.00686908) , 
2, -0.696347, 1, 0, 0.526414,-0.00529311) , 
0, -3.02048, 1, 0, 0.519598,0.000574901)    );
  // itree = 504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448543,0.0267037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284702,-0.0175871) , 
1, 0.592363, 1, 0, 0.397685,0.0243803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378583,-0.0200696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816475,0.00298997) , 
3, 0.8736, 1, 0, 0.603615,-0.0232419) , 
0, -0.107821, 1, 0, 0.505151,-0.000471553)    );
  // itree = 505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162677,-0.0151235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63181,0.0255791) , 
3, -0.338126, 1, 0, 0.238608,-0.0147423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522553,0.026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815253,0.00410729) , 
3, 0.724076, 1, 0, 0.660388,0.0352083) , 
2, -0.492023, 1, 0, 0.509643,0.0173559)    );
  // itree = 506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438924,-0.0166679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842369,0.0267847) , 
0, 1.96897, 1, 0, 0.490758,-0.0259398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534323,0.0221393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226484,-0.0589196) , 
1, 2.10021, 1, 0, 0.513273,0.0350985) , 
1, -0.0246959, 1, 0, 0.50106,0.00198735)    );
  // itree = 507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339115,-0.0061167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748344,-0.140515) , 
3, 0.473052, 1, 0, 0.385264,-0.03278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641888,0.0270154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759136,-0.00327233) , 
2, 0.920653, 1, 0, 0.691091,0.0329852) , 
0, 0.391162, 1, 0, 0.512672,-0.0053821)    );
  // itree = 508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158754,0.0113951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0826387) , 
3, -1.06842, 1, 0, 0.292472,0.042364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450539,-0.0188142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736474,0.00273872) , 
2, 1.00821, 1, 0, 0.514991,-0.0329225) , 
0, -1.676, 1, 0, 0.479372,-0.0208709)    );
  // itree = 509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255988,0.00546516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664593,0.0311101) , 
3, 0.00185095, 1, 0, 0.380977,0.0337597) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627449,-0.0640433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.810445,0.00187651) , 
3, 0.769069, 1, 0, 0.790329,-0.0119325) , 
3, 0.581514, 1, 0, 0.527417,0.017414)    );
  // itree = 510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0228912,-0.0371344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326771,0.0972816) , 
3, -1.98873, 1, 0, 0.178594,0.0723518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320133,-0.0127035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780138,0.0113951) , 
3, 0.42896, 1, 0, 0.520379,-0.00570913) , 
2, -1.61118, 1, 0, 0.491122,0.000972972)    );
  // itree = 511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0249548,-0.041547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350441,0.0183408) , 
3, -1.69951, 1, 0, 0.252235,0.015698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40837,-0.0260457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592964,-0.00279719) , 
0, -1.09421, 1, 0, 0.559788,-0.0173202) , 
2, -0.759232, 1, 0, 0.483403,-0.00911967)    );
  // itree = 512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287703,-0.00350446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687368,0.0174897) , 
2, -0.437416, 1, 0, 0.546675,0.0239197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30904,-0.011965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581597,-0.046473) , 
2, -0.37637, 1, 0, 0.445969,-0.0592966) , 
1, 1.56348, 1, 0, 0.539663,0.0181254)    );
  // itree = 513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149102,-0.0290092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563353,0.00562415) , 
2, -0.553733, 1, 0, 0.26195,-0.0379412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.594191,0.0103215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512206,-0.0207831) , 
1, 1.03257, 1, 0, 0.584563,0.0145259) , 
0, -0.773058, 1, 0, 0.465759,-0.00479542)    );
  // itree = 514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.718113,0.0564182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520967,0.00058009) , 
1, -1.88173, 1, 0, 0.528928,0.00620891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24669,0.00470863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478613,-0.0794006) , 
2, -0.327583, 1, 0, 0.36945,-0.0816121) , 
1, 1.38887, 1, 0, 0.513139,-0.00248597)    );
  // itree = 515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212974,0.00215171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417471,0.0470552) , 
2, -1.17851, 1, 0, 0.285039,0.0403419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546454,-0.0041951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820405,0.022699) , 
2, 1.3268, 1, 0, 0.581489,-0.00157752) , 
2, -0.759232, 1, 0, 0.517556,0.00746292)    );
  // itree = 516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137401,-0.00602013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333585,-0.0320642) , 
3, -0.789705, 1, 0, 0.198223,-0.0330124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414853,0.0292772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756943,-0.000680478) , 
3, 0.15405, 1, 0, 0.651347,0.0200023) , 
2, -0.585857, 1, 0, 0.490503,0.00118374)    );
  // itree = 517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0795356,-0.0212599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470604,0.0941959) , 
2, -1.9388, 1, 0, 0.298141,0.10926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515027,-0.00141005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541606,0.0267903) , 
1, 1.53348, 1, 0, 0.516497,0.000709205) , 
0, -3.02048, 1, 0, 0.503948,0.00694766)    );
  // itree = 518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355618,-0.00224774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82458,0.0289776) , 
3, 0.822051, 1, 0, 0.399446,0.0020659) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.721935,-0.0458855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.890238,0.00559699) , 
3, 1.60374, 1, 0, 0.811108,-0.0386903) , 
3, 1.13577, 1, 0, 0.492328,-0.00712975)    );
  // itree = 519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382792,0.0146226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65087,-0.0253571) , 
3, 0.00766277, 1, 0, 0.527195,-0.0160797) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524277,0.0244449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415182,-0.0256057) , 
1, 1.71444, 1, 0, 0.5143,0.045508) , 
1, -0.39136, 1, 0, 0.519448,0.02092)    );
  // itree = 520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259451,-0.0572845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290406,-0.0164682) , 
1, -1.70565, 1, 0, 0.288631,-0.0476955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.691568,0.0421618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.845357,0.0117005) , 
3, 0.7597, 1, 0, 0.829193,0.0337276) , 
3, 0.569166, 1, 0, 0.481034,-0.0187144)    );
  // itree = 521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.587128,-0.0809874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909903,-0.0212838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657872,0.00498897) , 
3, -0.719586, 1, 0, 0.50516,-0.0011454) , 
1, -2.12925, 1, 0, 0.507753,-0.00566559)    );
  // itree = 522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230405,-0.0284031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651961,0.0184196) , 
0, -2.05718, 1, 0, 0.605263,0.0282592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392976,-0.0336662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387714,-0.00128157) , 
1, 0.120747, 1, 0, 0.389905,-0.035203) , 
1, -0.633389, 1, 0, 0.45036,-0.017388)    );
  // itree = 523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593225,0.00390549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.959378,0.0931931) , 
1, -1.61209, 1, 0, 0.691012,0.0722112) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459641,-0.0129123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564061,0.0414303) , 
1, 1.61341, 1, 0, 0.465398,-0.0228391) , 
1, -1.38738, 1, 0, 0.493635,-0.0109431)    );
  // itree = 524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165012,0.01369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388833,-0.0238737) , 
2, -1.36827, 1, 0, 0.332725,-0.037224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.833027,0.072627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684122,0.00519518) , 
0, 0.265663, 1, 0, 0.703313,0.0314502) , 
0, -0.0815128, 1, 0, 0.49979,-0.00626499)    );
  // itree = 525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413386,0.0484141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228098,0.00191046) , 
1, 0.315854, 1, 0, 0.331311,0.0537165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108832,-0.0397514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713376,-0.0016842) , 
3, -0.101373, 1, 0, 0.618699,-0.0192764) , 
2, -0.201884, 1, 0, 0.497878,0.0114107)    );
  // itree = 526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1714,-0.00505097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400758,-0.0471591) , 
3, -0.693394, 1, 0, 0.228453,-0.0451915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455327,0.0260792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758279,0.00370209) , 
3, 0.128546, 1, 0, 0.653707,0.029085) , 
2, -0.793305, 1, 0, 0.547031,0.0104526)    );
  // itree = 527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0883314,-0.0642134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678606,-0.0145734) , 
2, -0.543709, 1, 0, 0.489781,-0.0772876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171987,0.019268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603623,-0.0080563) , 
3, -0.787254, 1, 0, 0.504443,-0.00731464) , 
1, -1.37597, 1, 0, 0.502833,-0.015001)    );
  // itree = 528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357965,-0.00354706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538493,0.06429) , 
0, -0.704038, 1, 0, 0.396003,0.0227782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573925,0.00436688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688398,-0.0230317) , 
2, 0.472546, 1, 0, 0.639942,-0.0279135) , 
0, -0.299611, 1, 0, 0.525221,-0.00407398)    );
  // itree = 529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325162,0.0583787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530631,0.00658974) , 
0, -3.02048, 1, 0, 0.522747,0.0184583) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280777,-0.0236267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.839778,0.00660688) , 
3, 1.06087, 1, 0, 0.443417,-0.0345297) , 
1, 0.822987, 1, 0, 0.505601,0.0070056)    );
  // itree = 530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121343,-0.0229111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205306,0.0255628) , 
1, 1.12094, 1, 0, 0.131594,-0.0322321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.84402,0.059068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643749,0.0066216) , 
0, -0.00817408, 1, 0, 0.706625,0.0589798) , 
3, -0.716903, 1, 0, 0.516338,0.0287963)    );
  // itree = 531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.882641,0.0717983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455922,-0.021513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480208,0.0116308) , 
1, 0.350707, 1, 0, 0.464348,-0.023404) , 
1, -2.00084, 1, 0, 0.477472,-0.0178035)    );
  // itree = 532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221963,0.0738632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487479,-0.00389855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666602,-0.0404368) , 
0, 2.82587, 1, 0, 0.495997,-0.013656) , 
2, -2.0544, 1, 0, 0.488626,-0.0099633)    );
  // itree = 533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534924,-0.0118193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525087,0.0086701) , 
1, -0.870929, 1, 0, 0.527779,0.00642044) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233347,-0.0925428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794515,0.00813783) , 
3, 0.498875, 1, 0, 0.492262,-0.128903) , 
1, 1.48204, 1, 0, 0.524379,-0.00653395)    );
  // itree = 534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.690738,0.0113045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833318,0.0496283) , 
1, -1.81229, 1, 0, 0.78268,0.0687746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558586,0.0141583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452056,-0.00571595) , 
1, -0.234246, 1, 0, 0.492682,0.00501091) , 
1, -1.36512, 1, 0, 0.517482,0.0104638)    );
  // itree = 535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56465,0.00191138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652608,0.0485701) , 
1, -0.599375, 1, 0, 0.582802,0.0307838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46964,-0.00962173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362661,-0.0575787) , 
1, 2.10789, 1, 0, 0.464489,-0.0287328) , 
1, -0.271757, 1, 0, 0.513738,-0.00395828)    );
  // itree = 536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664897,0.0154952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474611,-0.0201559) , 
1, -1.40564, 1, 0, 0.505619,-0.0340989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422439,0.00428663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445226,0.0341071) , 
1, 0.984669, 1, 0, 0.432965,0.0343792) , 
1, 0.463922, 1, 0, 0.480332,-0.0102653)    );
  // itree = 537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163546,-0.0130293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0391648,-0.0779335) , 
1, 0.898236, 1, 0, 0.126907,-0.0697908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369626,0.0171441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636375,-0.00605504) , 
2, -0.304298, 1, 0, 0.549922,0.00185303) , 
0, -2.41637, 1, 0, 0.511853,-0.00459439)    );
  // itree = 538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15818,0.0151503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500618,-0.020676) , 
3, -0.801121, 1, 0, 0.380828,-0.0236638) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430221,-0.00395466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823059,0.0279264) , 
2, 0.520512, 1, 0, 0.753369,0.0508709) , 
2, 0.338939, 1, 0, 0.529087,0.00599857)    );
  // itree = 539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.741823,0.045795) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536854,-0.00277294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482434,0.0302059) , 
1, 1.10364, 1, 0, 0.529389,0.00346517) , 
1, -1.84922, 1, 0, 0.539539,0.0079437)    );
  // itree = 540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189946,-0.00057394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436832,0.0568913) , 
2, -0.824835, 1, 0, 0.244491,0.0255515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328498,0.0122838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618473,-0.0193975) , 
3, -0.262481, 1, 0, 0.58069,-0.0360086) , 
2, -0.620353, 1, 0, 0.477395,-0.0170947)    );
  // itree = 541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295339,-0.0383877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376065,-0.000256669) , 
1, -1.20696, 1, 0, 0.365674,-0.0132892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.739397,0.0240671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625799,0.00217747) , 
1, -0.36158, 1, 0, 0.675217,0.026926) , 
2, 0.233941, 1, 0, 0.491073,0.00300232)    );
  // itree = 542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672426,0.0477247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446804,-0.0240866) , 
1, -1.98268, 1, 0, 0.477002,-0.0404688) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633299,0.0315323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441637,0.00334774) , 
1, -0.0174726, 1, 0, 0.508898,0.0282879) , 
1, -1.00268, 1, 0, 0.501909,0.0132216)    );
  // itree = 543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292888,0.0590338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403002,-0.0150782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.749282,0.0137775) , 
2, 0.71803, 1, 0, 0.492847,-0.0171682) , 
0, -3.02048, 1, 0, 0.483936,-0.01109)    );
  // itree = 544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32363,-0.0505446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14086,-0.0377953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513331,0.00553186) , 
0, -2.97825, 1, 0, 0.494572,0.00712754) , 
1, -1.84459, 1, 0, 0.484497,-0.00090833)    );
  // itree = 545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408931,-0.0168676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572377,0.0268774) , 
1, 1.12018, 1, 0, 0.425698,-0.0298169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616778,0.0400244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742879,0.00841065) , 
2, 0.28906, 1, 0, 0.723508,0.0345116) , 
0, 1.23997, 1, 0, 0.491577,-0.0155867)    );
  // itree = 546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337211,-0.0132763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649253,0.00461474) , 
0, 0.0678113, 1, 0, 0.470394,-0.012845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353014,-0.0382081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453365,-0.111267) , 
0, 0.583574, 1, 0, 0.394979,-0.169353) , 
1, 1.6455, 1, 0, 0.465964,-0.02204)    );
  // itree = 547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151249,-0.0146754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165672,-0.036978) , 
2, -0.482818, 1, 0, 0.153984,-0.0420576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.715406,0.0195464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614048,-0.00799846) , 
1, 0.414129, 1, 0, 0.680865,0.0226077) , 
3, -0.451327, 1, 0, 0.505959,0.00114104)    );
  // itree = 548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.69298,0.0541151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689486,0.00582605) , 
2, 0.728245, 1, 0, 0.691396,0.0735816) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178849,-0.0264333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514583,0.00594618) , 
0, -2.51654, 1, 0, 0.484641,0.00611201) , 
1, -1.27893, 1, 0, 0.508353,0.0138499)    );
  // itree = 549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498851,-0.0106151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621659,0.0244638) , 
1, -1.30581, 1, 0, 0.592681,0.0339771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454928,-0.00893114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468873,0.0220323) , 
1, 1.70168, 1, 0, 0.456752,-0.0120789) , 
1, 0.0363237, 1, 0, 0.525521,0.0112218)    );
  // itree = 550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463405,0.0234914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83255,0.0499147) , 
2, 0.546798, 1, 0, 0.625354,0.0740272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468805,-0.0172949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39185,-0.00255202) , 
1, 0.294128, 1, 0, 0.42991,-0.0206842) , 
1, -0.977314, 1, 0, 0.464919,-0.00371893)    );
  // itree = 551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144231,0.0457133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261547,0.0974524) , 
1, 0.626428, 1, 0, 0.174706,0.0824161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445319,0.00927621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65502,-0.0141734) , 
2, 0.364165, 1, 0, 0.539377,-0.00340387) , 
2, -1.53711, 1, 0, 0.501608,0.00548441)    );
  // itree = 552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459568,0.0494393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646482,-0.00302249) , 
0, -0.904537, 1, 0, 0.598474,0.023631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199874,-0.0241933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808595,0.0165611) , 
3, 0.760312, 1, 0, 0.397912,-0.0244206) , 
1, 0.0411464, 1, 0, 0.501466,0.000389558)    );
  // itree = 553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0234262,-0.0564343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233112,-0.0057933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781984,0.0100611) , 
3, -0.00604446, 1, 0, 0.530553,0.00614075) , 
2, -2.0043, 1, 0, 0.507334,0.00011819)    );
  // itree = 554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616432,0.0388872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667113,-0.0088037) , 
2, 0.312451, 1, 0, 0.640505,0.0317627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221327,-0.0052935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610973,-0.0283866) , 
3, -0.147314, 1, 0, 0.445838,-0.0432444) , 
1, -1.19805, 1, 0, 0.474373,-0.0322498)    );
  // itree = 555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401472,-0.0121295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178847,-0.0659586) , 
0, 1.85522, 1, 0, 0.390081,-0.0358777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.911552,0.0452852) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.877319,0.00366013) , 
3, 1.57528, 1, 0, 0.884183,0.0266484) , 
3, 1.42475, 1, 0, 0.482991,-0.0241204)    );
  // itree = 556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0172839,-0.0490362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591858,0.0109673) , 
3, -1.80475, 1, 0, 0.556101,0.0194413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570525,0.0965078) , 
1, 2.00221, 1, 0, 0.556675,0.0255477)    );
  // itree = 557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166354,-0.0352965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816382,-0.00235632) , 
3, -0.18324, 1, 0, 0.503752,-0.0439196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483225,0.00720594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278458,-0.0430255) , 
1, 1.92829, 1, 0, 0.471663,0.00886755) , 
1, -0.577244, 1, 0, 0.482105,-0.00830883)    );
  // itree = 558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362451,-0.00755602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68368,-0.0407256) , 
3, 0.357883, 1, 0, 0.491459,-0.0473124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48297,0.0127478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400713,-0.0558736) , 
1, 1.5714, 1, 0, 0.474572,0.0108507) , 
1, -0.36158, 1, 0, 0.481579,-0.0132839)    );
  // itree = 559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420374,-0.0233724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507155,0.00679283) , 
1, -1.37597, 1, 0, 0.499156,0.00859051) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390313,-0.0484242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.866393,0.000326886) , 
3, 1.80814, 1, 0, 0.638091,-0.0673022) , 
0, 2.04933, 1, 0, 0.515568,-0.000374422)    );
  // itree = 560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273997,-0.0153585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515187,0.00391051) , 
0, -0.739302, 1, 0, 0.404448,-0.0103371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.981763,0.0691917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.905785,0.0157569) , 
3, 1.47931, 1, 0, 0.922532,0.0522542) , 
3, 1.32588, 1, 0, 0.493107,0.00037414)    );
  // itree = 561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300347,0.0148661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426241,-0.0335219) , 
2, -0.503658, 1, 0, 0.354386,-0.015852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.694881,0.00448711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832321,0.0415122) , 
1, 0.487593, 1, 0, 0.730598,0.0336271) , 
2, 0.233941, 1, 0, 0.50744,0.0042776)    );
  // itree = 562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.769045,0.0608237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538549,0.00265383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539519,0.0642137) , 
1, 1.78543, 1, 0, 0.538586,0.010383) , 
1, -1.86485, 1, 0, 0.549586,0.0158946)    );
  // itree = 563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181184,0.00907957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316768,0.0696732) , 
0, -1.92987, 1, 0, 0.236654,0.0553541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104294,-0.026562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63499,0.00279318) , 
3, -0.720418, 1, 0, 0.541175,-0.00324709) , 
2, -1.13773, 1, 0, 0.492023,0.00621159)    );
  // itree = 564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.79943,0.0470357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381962,-0.0510367) , 
1, -1.94094, 1, 0, 0.474975,-0.0857503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370471,0.00356462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64793,-0.0170399) , 
2, 0.423345, 1, 0, 0.463586,-0.00950256) , 
1, -1.37246, 1, 0, 0.464897,-0.0182825)    );
  // itree = 565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180417,0.0128117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635579,0.0570857) , 
3, -0.419174, 1, 0, 0.246353,0.0429408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.778065,0.00937657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625629,-0.0138788) , 
1, -0.110184, 1, 0, 0.68861,-0.00982093) , 
3, -0.123397, 1, 0, 0.509614,0.0115335)    );
  // itree = 566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312734,0.00488773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318374,-0.0254966) , 
0, -0.181337, 1, 0, 0.314333,-0.01297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.824177,0.0491882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83963,-0.0119374) , 
3, 1.22432, 1, 0, 0.833493,0.0287918) , 
3, 0.660704, 1, 0, 0.474385,-9.52046e-05)    );
  // itree = 567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14076,-0.0523388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75238,-0.0137432) , 
3, -0.432479, 1, 0, 0.502049,-0.0841622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236078,0.0121283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633136,-0.0121801) , 
3, -0.266059, 1, 0, 0.478623,-0.00844259) , 
1, -1.25139, 1, 0, 0.48146,-0.0176134)    );
  // itree = 568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381432,-0.0378475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309541,-0.00887179) , 
1, -0.257029, 1, 0, 0.340297,-0.0528712) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.640611,0.00581041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643557,-0.0341659) , 
0, 2.91171, 1, 0, 0.640824,0.00453875) , 
0, -0.218015, 1, 0, 0.489381,-0.0243915)    );
  // itree = 569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564174,-0.0528993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410437,-0.011586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.798973,0.010599) , 
2, 1.04815, 1, 0, 0.464339,-0.0173388) , 
1, -2.04766, 1, 0, 0.467255,-0.0212969)    );
  // itree = 570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166647,-0.0406265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171891,-0.010157) , 
1, 0.032123, 1, 0, 0.16952,-0.0761037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415404,0.00991611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800422,-0.0103691) , 
3, 0.67519, 1, 0, 0.565321,0.00529285) , 
0, -3.11877, 1, 0, 0.54278,0.000657318)    );
  // itree = 571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28884,0.0303433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585962,0.0061956) , 
2, -1.16796, 1, 0, 0.537353,0.0228895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335647,-0.0117108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528773,-0.0393063) , 
2, 0.514435, 1, 0, 0.385209,-0.0469306) , 
1, 0.71376, 1, 0, 0.501488,0.00643093)    );
  // itree = 572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173303,0.100499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518888,0.00101052) , 
3, -2.31778, 1, 0, 0.508109,0.00572158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270657,-0.0922413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351092,0.00780866) , 
1, 1.82502, 1, 0, 0.318344,-0.0789721) , 
1, 1.45051, 1, 0, 0.492713,-0.00114975)    );
  // itree = 573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413847,-0.00132794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605271,-0.0286557) , 
0, 1.31398, 1, 0, 0.444401,-0.0128477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.800585,0.0613261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792388,0.00828143) , 
2, 1.43157, 1, 0, 0.795102,0.0616331) , 
2, 1.13653, 1, 0, 0.491603,-0.00282304)    );
  // itree = 574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185191,-0.0240488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603146,0.00705865) , 
2, -0.75711, 1, 0, 0.474765,-0.00421974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.756577,-0.0494597) , 
2, 1.63713, 1, 0, 0.489076,-0.00906567)    );
  // itree = 575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529764,0.0657579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185866,-0.012872) , 
1, -1.88458, 1, 0, 0.206606,-0.0158268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610977,0.0380482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770451,0.00510239) , 
3, 0.101387, 1, 0, 0.747598,0.025807) , 
3, -0.123397, 1, 0, 0.508748,0.0074255)    );
  // itree = 576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268943,-0.000102965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692869,0.0542943) , 
2, -0.342068, 1, 0, 0.3493,0.0247127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132303,-0.0372943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696659,-0.00403731) , 
3, -0.0214892, 1, 0, 0.583519,-0.0267582) , 
0, -0.733992, 1, 0, 0.499601,-0.00831671)    );
  // itree = 577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764173,0.0140625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172955,-0.0341058) , 
3, -2.41599, 1, 0, 0.150576,-0.0561352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433811,0.0573686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598992,0.00307498) , 
2, -0.813295, 1, 0, 0.579522,0.0205302) , 
0, -2.2014, 1, 0, 0.527687,0.0112657)    );
  // itree = 578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192287,-0.0319773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748773,0.00258076) , 
3, -0.18324, 1, 0, 0.486967,-0.029657) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455224,0.00246141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523284,0.0218573) , 
1, 0.817445, 1, 0, 0.481753,0.0209178) , 
1, -0.111368, 1, 0, 0.484372,-0.00448584)    );
  // itree = 579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167927,0.00615366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354715,-0.0488843) , 
3, -0.789705, 1, 0, 0.226862,-0.0334872) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.74591,0.0398069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612399,0.000641289) , 
0, -0.81521, 1, 0, 0.633023,0.0140773) , 
2, -0.585857, 1, 0, 0.500887,-0.0013968)    );
  // itree = 580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441955,-0.02456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.827479,0.00953054) , 
2, 0.438521, 1, 0, 0.58772,-0.0287914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611363,0.0284858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458333,-0.00160887) , 
1, 0.40267, 1, 0, 0.530282,0.0308223) , 
1, -0.512935, 1, 0, 0.551018,0.00930107)    );
  // itree = 581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262724,-0.0441138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702397,0.0203698) , 
0, -1.51593, 1, 0, 0.626007,0.0289721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289675,0.0157763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464166,-0.0140558) , 
0, -1.525, 1, 0, 0.433709,-0.0219806) , 
1, -1.12811, 1, 0, 0.461973,-0.0144915)    );
  // itree = 582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380179,0.0107908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435853,0.0487648) , 
1, 0.990731, 1, 0, 0.390389,0.0349416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514289,-0.0639526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658184,-0.00956122) , 
1, -1.81119, 1, 0, 0.646448,-0.0363822) , 
2, 0.161708, 1, 0, 0.500416,0.00429436)    );
  // itree = 583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603905,0.0423648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709066,0.0578301) , 
1, -1.93535, 1, 0, 0.658604,0.114581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391085,-0.00846206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.898364,0.0170835) , 
3, 1.31913, 1, 0, 0.489987,-0.00990752) , 
1, -1.49648, 1, 0, 0.502704,-0.000518163)    );
  // itree = 584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55207,-0.00720784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537063,0.02074) , 
1, -0.719609, 1, 0, 0.543919,0.0157918) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12294,0.0700602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458786,-0.0155758) , 
3, -1.29954, 1, 0, 0.418565,-0.0237361) , 
1, 0.143069, 1, 0, 0.487602,-0.00196684)    );
  // itree = 585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145662,-0.0591241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731818,-0.00710048) , 
3, 0.124445, 1, 0, 0.412557,-0.0807509) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103893,-0.02389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581056,0.00788574) , 
2, -1.23085, 1, 0, 0.508127,0.00884525) , 
1, -1.6752, 1, 0, 0.502149,0.00324173)    );
  // itree = 586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254748,0.0158167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571266,-0.0127959) , 
2, -0.662058, 1, 0, 0.491774,-0.0133719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181445,-0.0578096) , 
1, 2.00221, 1, 0, 0.47774,-0.0191347)    );
  // itree = 587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28035,0.000719502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325944,0.0465703) , 
0, -1.20105, 1, 0, 0.293426,0.0328876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647592,-0.0519306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686101,-0.00147087) , 
0, -1.02377, 1, 0, 0.683692,-0.0114539) , 
3, -0.207894, 1, 0, 0.53375,0.00558232)    );
  // itree = 588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356292,0.00042371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125989,-0.0371479) , 
1, 0.0325634, 1, 0, 0.230105,-0.0334014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445215,0.0572976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588366,0.00394968) , 
0, -1.06704, 1, 0, 0.575271,0.0173253) , 
0, -1.48202, 1, 0, 0.500494,0.00633585)    );
  // itree = 589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.074414,-0.0254139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729643,0.0255008) , 
3, -1.06618, 1, 0, 0.638906,0.0412488) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604538,-0.0348367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479524,0.00268335) , 
1, -0.769787, 1, 0, 0.489232,-2.95847e-05) , 
1, -0.97244, 1, 0, 0.518179,0.00795374)    );
  // itree = 590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230864,-0.000175921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551101,-0.0293002) , 
3, -0.26731, 1, 0, 0.376411,-0.0360875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539191,0.0547057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700547,0.00343648) , 
2, 0.0609282, 1, 0, 0.676026,0.0243342) , 
0, 0.619485, 1, 0, 0.473329,-0.0165425)    );
  // itree = 591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430605,-0.000598421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.89684,0.0289042) , 
3, 1.31313, 1, 0, 0.479404,0.00519356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.87409,0.00658312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595137,-0.0590095) , 
1, -0.509237, 1, 0, 0.721837,-0.0918278) , 
2, 1.51538, 1, 0, 0.493541,-0.000464124)    );
  // itree = 592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411172,-8.33841e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56183,-0.0289862) , 
0, 0.446341, 1, 0, 0.4658,-0.0245495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618701,0.0498595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830735,0.00828587) , 
3, 1.67954, 1, 0, 0.766107,0.0674082) , 
0, 2.46359, 1, 0, 0.492379,-0.0164105)    );
  // itree = 593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126414,-0.0195727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43117,0.0445133) , 
2, -1.2356, 1, 0, 0.267754,0.0287606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.81197,0.0242124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559087,-0.0133857) , 
1, -1.31849, 1, 0, 0.589847,-0.0232386) , 
2, -0.620353, 1, 0, 0.497046,-0.00825669)    );
  // itree = 594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144584,-0.0273291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136606,0.0409441) , 
1, 1.17468, 1, 0, 0.142828,-0.0280988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585657,0.0164287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533839,-0.0150518) , 
1, 1.31099, 1, 0, 0.581062,0.0290213) , 
2, -1.24552, 1, 0, 0.521456,0.0212521)    );
  // itree = 595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109188,0.00323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230268,-0.0310576) , 
3, -1.14447, 1, 0, 0.18619,-0.0467996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.668507,0.0286883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781815,-0.0099646) , 
3, 0.750295, 1, 0, 0.736953,0.0182284) , 
3, -0.160313, 1, 0, 0.487661,-0.0112053)    );
  // itree = 596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508797,0.0135437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320685,-0.0212603) , 
1, -0.605638, 1, 0, 0.377858,-0.0275352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.886251,0.0302639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717424,-0.0143636) , 
0, 2.78434, 1, 0, 0.852416,0.0395345) , 
3, 0.908704, 1, 0, 0.511693,-0.00862009)    );
  // itree = 597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344263,-0.0356741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767084,0.0115419) , 
2, 0.438521, 1, 0, 0.500056,-0.0435662) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432784,0.0192615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713537,-0.0135106) , 
2, 0.604931, 1, 0, 0.516458,0.0202828) , 
1, -0.371918, 1, 0, 0.510174,-0.00417832)    );
  // itree = 598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377328,-0.00351427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717517,0.0486684) , 
0, 0.489643, 1, 0, 0.417055,0.00417319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62752,-0.0310674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743236,0.00844549) , 
1, 0.201478, 1, 0, 0.669195,-0.0360662) , 
2, 0.161708, 1, 0, 0.529971,-0.0138472)    );
  // itree = 599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221075,0.137557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5114,-0.00795097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524088,0.0194648) , 
1, 0.97732, 1, 0, 0.513292,-0.0094181) , 
2, -2.07855, 1, 0, 0.505356,-0.00488588)    );
  // itree = 600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0393958,-0.0423879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673317,0.041489) , 
2, -1.65713, 1, 0, 0.62409,0.0800057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293127,-0.0198846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660365,0.0164526) , 
2, 0.0110462, 1, 0, 0.45368,-0.00625102) , 
1, -0.39136, 1, 0, 0.511869,0.0232026)    );
  // itree = 601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450105,-0.0107759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.803779,0.0143858) , 
0, 2.41389, 1, 0, 0.477331,-0.0206653) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616709,0.0532387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382898,0.00906367) , 
1, 1.4969, 1, 0, 0.453186,0.0538486) , 
1, 1.1919, 1, 0, 0.474992,-0.013446)    );
  // itree = 602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163895,0.0112509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446999,-0.0341415) , 
3, -0.786855, 1, 0, 0.316848,-0.0449103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.66973,0.00590333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742948,-0.0295242) , 
0, 2.75786, 1, 0, 0.676634,0.00616582) , 
0, -0.260141, 1, 0, 0.500948,-0.018775)    );
  // itree = 603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343156,0.0250541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572838,-0.00166298) , 
0, -0.997601, 1, 0, 0.514323,0.00918567) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131986,-0.0562828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.783792,-0.00534663) , 
3, 0.287233, 1, 0, 0.390365,-0.0882054) , 
1, 1.32658, 1, 0, 0.498861,-0.00296277)    );
  // itree = 604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331774,0.0546284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496144,-0.0195911) , 
0, -2.37192, 1, 0, 0.48222,-0.0302775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196203,-0.0146265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699521,0.0582439) , 
0, -1.1063, 1, 0, 0.503118,0.0650224) , 
1, 0.345387, 1, 0, 0.489556,0.00317846)    );
  // itree = 605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37879,0.00174454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286158,-0.0243551) , 
1, 0.194022, 1, 0, 0.339919,-0.0212836) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71235,-0.0167581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690966,0.0131253) , 
1, -1.02512, 1, 0, 0.69545,0.0165963) , 
2, 0.0724854, 1, 0, 0.497008,-0.00454668)    );
  // itree = 606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104988,-0.00540932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281271,-0.0490193) , 
3, -1.167, 1, 0, 0.170471,-0.0597285) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574828,0.0422205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633591,-0.00975208) , 
0, -0.417981, 1, 0, 0.617669,0.00826486) , 
2, -0.98872, 1, 0, 0.530512,-0.00498676)    );
  // itree = 607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168717,-0.0292133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548174,0.0041453) , 
2, -0.533067, 1, 0, 0.275753,-0.0403215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.694011,-0.0165358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661789,0.0233136) , 
1, -1.03815, 1, 0, 0.667716,0.0341279) , 
0, -0.691462, 1, 0, 0.515481,0.00521247)    );
  // itree = 608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261906,-0.0482846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.828958,-0.00707303) , 
3, 0.895956, 1, 0, 0.392535,-0.0988615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213103,0.0111176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655106,-0.0139638) , 
3, -0.25059, 1, 0, 0.47894,-0.0119754) , 
1, -1.23427, 1, 0, 0.46322,-0.0277824)    );
  // itree = 609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504029,0.049812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316361,0.00908967) , 
1, -1.30112, 1, 0, 0.329105,0.0277008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334463,-0.0377691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631842,-0.00585583) , 
0, -0.526271, 1, 0, 0.574752,-0.0291309) , 
2, -0.319459, 1, 0, 0.483133,-0.00793423)    );
  // itree = 610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322457,0.0299439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816371,-0.0558819) , 
1, 0.0325634, 1, 0, 0.173933,-0.0351866) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557624,-0.0126492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615253,0.0118863) , 
1, -0.39136, 1, 0, 0.589571,0.00184533) , 
2, -0.94526, 1, 0, 0.499412,-0.0061875)    );
  // itree = 611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165529,0.00903859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0591353) , 
0, -2.51191, 1, 0, 0.0840164,-0.0207752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.820126,0.0556955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608869,0.00566109) , 
0, -1.8423, 1, 0, 0.617351,0.0182013) , 
3, -1.22591, 1, 0, 0.535249,0.0122012)    );
  // itree = 612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183075,-0.0401091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0373886,-0.0366406) , 
1, 0.0100439, 1, 0, 0.117608,-0.102862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473777,-0.0624548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546159,0.00226355) , 
1, -1.86485, 1, 0, 0.543166,-0.000533722) , 
0, -3.02048, 1, 0, 0.517272,-0.00675992)    );
  // itree = 613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122566,-0.0490623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22762,-0.00721366) , 
1, -0.478841, 1, 0, 0.196769,-0.0465879) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.737328,0.0257329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628128,-0.00311875) , 
1, -0.63333, 1, 0, 0.66627,0.0153505) , 
2, -0.457527, 1, 0, 0.474184,-0.00999016)    );
  // itree = 614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622921,0.0133523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429211,-0.00946605) , 
1, -0.562267, 1, 0, 0.487193,-0.00575215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645774,0.0627454) , 
1, 1.81888, 1, 0, 0.494025,0.000614489)    );
  // itree = 615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308069,0.0144709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481087,-0.0279796) , 
2, -0.478414, 1, 0, 0.391206,-0.0174934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291774,-0.0237644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751105,0.0224572) , 
2, -0.0850349, 1, 0, 0.68723,0.0343149) , 
0, 0.493913, 1, 0, 0.506448,0.00267557)    );
  // itree = 616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264499,-0.00662501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148326,-0.038505) , 
1, 1.34775, 1, 0, 0.250579,-0.0253493) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.94329,0.0532904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.771797,-0.00460829) , 
3, 0.450158, 1, 0, 0.78891,0.00408308) , 
3, 0.246134, 1, 0, 0.48866,-0.0123326)    );
  // itree = 617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.898755,0.095998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508917,0.000243785) , 
1, -1.98799, 1, 0, 0.522687,0.00686672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0791208,-0.0879887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7456,0.0103764) , 
0, -0.243535, 1, 0, 0.43298,-0.0811748) , 
1, 1.45051, 1, 0, 0.515156,-0.000524984)    );
  // itree = 618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0646418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0546534,-0.00729684) , 
0, -3.30284, 1, 0, 0.0310651,-0.0600107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353302,0.0253001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662637,0.0030363) , 
2, -0.526824, 1, 0, 0.586178,0.018018) , 
3, -1.67155, 1, 0, 0.549728,0.0128945)    );
  // itree = 619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399592,0.000795317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62973,0.0322978) , 
2, 0.65609, 1, 0, 0.422615,0.00941237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.790648,-0.033527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.848119,0.0128986) , 
2, 1.47879, 1, 0, 0.808632,-0.0335756) , 
3, 1.03866, 1, 0, 0.515417,-0.000922368)    );
  // itree = 620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306139,0.00538715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717983,0.0306972) , 
2, -0.0923611, 1, 0, 0.403301,0.0262591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559728,-0.0146994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.97514,0.0457586) , 
3, 2.5937, 1, 0, 0.582882,-0.0278298) , 
0, -0.173774, 1, 0, 0.496375,-0.00177436)    );
  // itree = 621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0577035,-0.0231864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690827,0.0774752) , 
3, -1.51374, 1, 0, 0.332254,0.055839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522381,-0.0359826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519253,-0.00462223) , 
1, -1.65967, 1, 0, 0.519425,-0.0160796) , 
0, -1.48202, 1, 0, 0.48577,-0.00314805)    );
  // itree = 622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578407,-0.00447978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392686,-0.0722753) , 
1, -0.949932, 1, 0, 0.546343,-0.039322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385852,0.00497659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671833,-0.0151387) , 
2, 0.479954, 1, 0, 0.477005,-0.00479611) , 
1, -0.823218, 1, 0, 0.493875,-0.0131965)    );
  // itree = 623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192012,0.0505235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10006,-0.016942) , 
2, -2.09149, 1, 0, 0.111502,-0.0142187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565023,0.0176588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741445,-0.00959424) , 
2, 0.805971, 1, 0, 0.616539,0.0223842) , 
3, -0.852844, 1, 0, 0.482838,0.0126941)    );
  // itree = 624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44921,-0.0246995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.938024,0.0211746) , 
3, 1.62579, 1, 0, 0.522519,-0.0467528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460164,0.0186724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709036,-0.0271659) , 
0, 1.61764, 1, 0, 0.49528,0.0235421) , 
1, -0.89377, 1, 0, 0.500655,0.00967132)    );
  // itree = 625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508565,0.00625489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715575,-0.0522576) , 
2, 1.65345, 1, 0, 0.517146,0.00846443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463228,-0.0229349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492147,0.0204816) , 
1, 2.13602, 1, 0, 0.466195,-0.0373449) , 
1, 0.71376, 1, 0, 0.504448,-0.0029524)    );
  // itree = 626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681811,0.0727379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357339,0.0158947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535558,-0.0149526) , 
0, -0.982803, 1, 0, 0.483252,-0.0158268) , 
1, -2.03415, 1, 0, 0.490466,-0.00922402)    );
  // itree = 627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341506,0.0645716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612853,0.013326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443695,-0.0145815) , 
1, -0.580095, 1, 0, 0.493331,-0.0134341) , 
0, -3.07585, 1, 0, 0.487178,-0.00674597)    );
  // itree = 628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481478,-0.0726064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110845,-0.0186485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629871,0.00642555) , 
3, -0.892923, 1, 0, 0.49431,0.00198885) , 
1, -2.1332, 1, 0, 0.493922,-0.00488261)    );
  // itree = 629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273633,-0.0094207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375656,-0.035666) , 
2, 0.108815, 1, 0, 0.291864,-0.03574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523342,-0.000476333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.892218,0.0211879) , 
3, 1.2906, 1, 0, 0.64079,0.0129586) , 
0, -0.82073, 1, 0, 0.516539,-0.00438276)    );
  // itree = 630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388982,0.0121481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445966,-0.0256777) , 
0, 1.30135, 1, 0, 0.392289,0.0183656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403522,-0.0267651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834751,0.00571029) , 
3, 1.14493, 1, 0, 0.627653,-0.0329915) , 
2, 0.486203, 1, 0, 0.467642,0.0019233)    );
  // itree = 631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456569,0.024319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290034,-0.0231836) , 
1, -0.797042, 1, 0, 0.325366,-0.0321321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520418,0.0689234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637875,0.0022953) , 
2, -0.652612, 1, 0, 0.628323,0.0147419) , 
0, -0.560197, 1, 0, 0.508379,-0.00381603)    );
  // itree = 632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380341,0.0107456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227813,-0.0252987) , 
1, -0.259045, 1, 0, 0.28434,-0.0231154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.72611,-0.0104253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675526,0.0228259) , 
1, -0.823218, 1, 0, 0.688561,0.03349) , 
2, -0.155261, 1, 0, 0.512725,0.00886658)    );
  // itree = 633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219854,0.00158805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572744,-0.0266805) , 
3, -0.443192, 1, 0, 0.283111,-0.0106804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.668624,0.0196448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718756,-0.0251128) , 
0, 2.7619, 1, 0, 0.671821,0.0344066) , 
0, -1.02119, 1, 0, 0.540859,0.0192161)    );
  // itree = 634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0884412,0.0169498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485191,0.0675464) , 
3, -2.13134, 1, 0, 0.295693,0.0974187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470792,-0.0143859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71061,0.0142164) , 
0, 1.63825, 1, 0, 0.519956,-0.0194515) , 
0, -2.41637, 1, 0, 0.503424,-0.0108361)    );
  // itree = 635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857425,-0.0427103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203612,0.030584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613988,-0.0072504) , 
3, -0.675576, 1, 0, 0.51609,-0.000992902) , 
0, -3.02048, 1, 0, 0.49669,-0.00552693)    );
  // itree = 636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242635,0.0499847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507849,-0.0406849) , 
2, -0.877478, 1, 0, 0.468057,-0.0701538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363521,-0.0060097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742939,0.0109586) , 
2, 0.54983, 1, 0, 0.463885,-0.00240407) , 
1, -1.03815, 1, 0, 0.464636,-0.0146075)    );
  // itree = 637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0770178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544136,-0.0230099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548097,0.00886925) , 
1, -1.49648, 1, 0, 0.547661,0.0107667) , 
2, -2.07775, 1, 0, 0.529759,0.00415694)    );
  // itree = 638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588232,0.0361949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612569,-0.0274466) , 
2, 1.09754, 1, 0, 0.594133,0.0487052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473729,-0.0185835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478628,0.0069713) , 
1, -0.0394949, 1, 0, 0.476353,-0.0116655) , 
1, -1.31868, 1, 0, 0.488831,-0.00526926)    );
  // itree = 639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175285,-0.0126062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192842,-0.0385599) , 
0, -1.36564, 1, 0, 0.18197,-0.0463691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433967,0.0275192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686373,0.000697679) , 
3, -0.0106535, 1, 0, 0.625331,0.0168213) , 
2, -0.623444, 1, 0, 0.486353,-0.00298673)    );
  // itree = 640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56237,-0.0192911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590044,0.00804843) , 
1, -1.47535, 1, 0, 0.585196,0.00593148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362151,-0.00672772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564552,-0.0404719) , 
2, 0.459016, 1, 0, 0.42278,-0.0425036) , 
1, 0.201478, 1, 0, 0.515819,-0.0147579)    );
  // itree = 641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242952,0.108254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294168,0.024737) , 
0, -3.32373, 1, 0, 0.285394,0.0634677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580615,0.0024417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483392,-0.0255033) , 
1, 0.38739, 1, 0, 0.545311,-0.0191568) , 
2, -1.16796, 1, 0, 0.502569,-0.00556938)    );
  // itree = 642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414265,0.00626798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539562,-0.031745) , 
0, 1.30135, 1, 0, 0.429778,0.00174994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610196,0.050883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.876642,0.0171979) , 
3, 1.19838, 1, 0, 0.826239,0.0588768) , 
2, 1.0287, 1, 0, 0.491184,0.010598)    );
  // itree = 643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300578,-0.0292257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61509,-0.000401055) , 
0, -0.736877, 1, 0, 0.513183,-0.024631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45986,0.0166802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559063,-0.0210244) , 
0, 1.86362, 1, 0, 0.473385,0.0241665) , 
1, -0.0246959, 1, 0, 0.493966,-0.0010685)    );
  // itree = 644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391295,0.0740461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529454,0.00223693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628389,-0.0367119) , 
0, 3.02872, 1, 0, 0.532419,0.00123476) , 
0, -3.07087, 1, 0, 0.52594,0.00852735)    );
  // itree = 645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158779,0.00386285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587885,0.0425996) , 
3, -0.973093, 1, 0, 0.34135,0.0487134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598739,-0.00627224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.665949,-0.0364148) , 
2, 1.25018, 1, 0, 0.612292,-0.0300529) , 
2, -0.492023, 1, 0, 0.516913,-0.00232512)    );
  // itree = 646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332525,-0.0299192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618095,0.000317766) , 
0, 0.544817, 1, 0, 0.432417,-0.0454437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447352,-0.0164412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627626,0.0407241) , 
1, 1.2307, 1, 0, 0.593841,0.0631173) , 
1, 1.08213, 1, 0, 0.453589,-0.0312047)    );
  // itree = 647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558449,0.00850277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437782,-0.00685769) , 
1, -0.673494, 1, 0, 0.472763,-0.00464359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635532,-0.0429261) , 
0, 2.76684, 1, 0, 0.479587,-0.00961406)    );
  // itree = 648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0281416,-0.0563066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1518,-0.0322358) , 
2, -2.01553, 1, 0, 0.0932586,-0.0890021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272997,-0.0146698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634743,0.0077387) , 
2, -0.626495, 1, 0, 0.543476,0.00609104) , 
2, -1.73847, 1, 0, 0.509826,-0.00101635)    );
  // itree = 649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331681,0.0329769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567841,0.00200369) , 
0, -2.36962, 1, 0, 0.550482,0.00945988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375643,-0.0314401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692233,0.0169164) , 
0, 1.07968, 1, 0, 0.467576,-0.0339452) , 
1, 0.728565, 1, 0, 0.531664,-0.000392571)    );
  // itree = 650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440088,-0.0446676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523949,-0.0151279) , 
1, -1.98251, 1, 0, 0.516995,-0.0419629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437351,0.00539457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820626,0.0390178) , 
2, 1.65345, 1, 0, 0.455826,0.0160525) , 
1, -0.0822111, 1, 0, 0.485285,-0.0118882)    );
  // itree = 651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278849,-0.0166645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800188,0.0260945) , 
2, -0.504532, 1, 0, 0.623421,0.024736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375598,-0.0293546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410012,-0.00969481) , 
1, -0.184269, 1, 0, 0.402488,-0.0321497) , 
1, -0.553853, 1, 0, 0.47164,-0.0143446)    );
  // itree = 652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184072,0.000448446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635648,0.020444) , 
2, -0.873951, 1, 0, 0.514274,0.0359113) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71204,-0.0224769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.914608,0.0316233) , 
3, 2.47998, 1, 0, 0.756872,-0.0269845) , 
2, 1.13653, 1, 0, 0.545538,0.0278058)    );
  // itree = 653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270359,-0.0182408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704954,0.0168896) , 
2, -0.417088, 1, 0, 0.525701,0.0050972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178153,0.101701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36084,-0.0300341) , 
3, -1.48273, 1, 0, 0.343241,-0.0501098) , 
1, 0.37474, 1, 0, 0.453839,-0.0166461)    );
  // itree = 654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205382,0.00582983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580911,-0.0636167) , 
3, -0.760534, 1, 0, 0.301114,-0.0375668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497723,0.0560737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594014,0.00137601) , 
0, -1.09993, 1, 0, 0.585437,0.0142174) , 
0, -1.55531, 1, 0, 0.526029,0.00339717)    );
  // itree = 655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0323335,-0.0307559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454322,0.0592557) , 
3, -2.20061, 1, 0, 0.313317,0.0797644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387167,0.0218197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572145,-0.000623802) , 
0, -0.910448, 1, 0, 0.529694,0.00776664) , 
0, -2.23892, 1, 0, 0.509056,0.0146337)    );
  // itree = 656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614564,0.0531753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37688,0.00549117) , 
1, -1.41633, 1, 0, 0.395223,0.0197144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692223,-0.00205845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476277,-0.0396129) , 
1, 0.641961, 1, 0, 0.644045,-0.0308015) , 
2, 0.161708, 1, 0, 0.506576,-0.00289255)    );
  // itree = 657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433348,-0.0245969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418628,0.0274188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777077,0.0040075) , 
3, 0.721686, 1, 0, 0.541151,0.0410884) , 
1, -1.86485, 1, 0, 0.536432,0.0367962)    );
  // itree = 658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290626,-0.049366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0801889,-0.0354715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551516,0.000917869) , 
3, -1.59453, 1, 0, 0.499755,-0.00591146) , 
1, -1.86485, 1, 0, 0.487104,-0.0154586)    );
  // itree = 659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386131,-0.00699693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718965,0.0168788) , 
0, 0.0678113, 1, 0, 0.526022,0.00872057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.819404,0.052647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506207,0.026117) , 
1, 1.83356, 1, 0, 0.675108,0.0993444) , 
1, 1.17853, 1, 0, 0.53848,0.0162931)    );
  // itree = 660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4677,-0.00819591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782081,0.017169) , 
0, 2.79718, 1, 0, 0.486421,-0.0135765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203716,-0.0511015) , 
1, 1.89479, 1, 0, 0.476713,-0.0169393)    );
  // itree = 661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20249,0.00774339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446142,-0.0188695) , 
2, -0.747712, 1, 0, 0.367776,-0.0280542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.836838,-0.037101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.89526,0.0240995) , 
3, 1.2915, 1, 0, 0.888476,0.0334385) , 
3, 1.13577, 1, 0, 0.480391,-0.0147548)    );
  // itree = 662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14793,-0.0164075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639372,0.00285888) , 
3, -0.530513, 1, 0, 0.454733,-0.00720179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.806686,0.0562272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780637,-0.00442052) , 
0, 2.83545, 1, 0, 0.790158,0.054581) , 
0, 2.39256, 1, 0, 0.481206,-0.00232573)    );
  // itree = 663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576887,0.0522652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456049,-0.035908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484818,-0.00466024) , 
1, -1.28913, 1, 0, 0.482271,-0.0173323) , 
1, -1.86485, 1, 0, 0.486333,-0.013415)    );
  // itree = 664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262544,-0.0104405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436561,-0.0454877) , 
2, -0.0986248, 1, 0, 0.286964,-0.0409011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36023,0.011583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608315,-0.00749973) , 
0, -0.24393, 1, 0, 0.545396,-0.00726251) , 
0, -1.02119, 1, 0, 0.467772,-0.0173664)    );
  // itree = 665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0579394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511706,0.00624685) , 
0, -3.53869, 1, 0, 0.495503,0.0100002) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309947,-0.0353645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.856345,-0.00168551) , 
3, 1.57211, 1, 0, 0.590544,-0.054226) , 
0, 1.63755, 1, 0, 0.510743,-0.000298481)    );
  // itree = 666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325588,-0.01488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644202,0.00741214) , 
0, -0.438834, 1, 0, 0.499931,-0.00556072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399532,0.0679233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696033,0.0403525) , 
2, -0.434083, 1, 0, 0.525908,0.106989) , 
1, 1.46291, 1, 0, 0.501904,0.00298848)    );
  // itree = 667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50495,-0.0498429) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0398491,-0.0445724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527538,0.000147027) , 
2, -1.64885, 1, 0, 0.480322,-0.00695737) , 
1, -1.92217, 1, 0, 0.481228,-0.011819)    );
  // itree = 668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140692,0.0268462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439619,-0.0165036) , 
3, -1.39571, 1, 0, 0.37093,-0.0234137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.809632,0.0299434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645924,-0.0051727) , 
1, -0.294962, 1, 0, 0.719728,0.0236353) , 
2, 0.323165, 1, 0, 0.509856,-0.00467419)    );
  // itree = 669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18995,0.00243257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197107,-0.0349441) , 
0, -1.33468, 1, 0, 0.192868,-0.0236776) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.631097,-0.00261504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631559,0.0241879) , 
1, 0.107402, 1, 0, 0.631303,0.0225616) , 
2, -0.696554, 1, 0, 0.499116,0.00862054)    );
  // itree = 670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294839,-0.0154143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.888822,0.0410172) , 
3, -0.124552, 1, 0, 0.614738,0.0272836) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552495,-0.0185191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482637,9.13179e-05) , 
1, -0.340484, 1, 0, 0.502097,-0.0121531) , 
1, -0.977314, 1, 0, 0.524652,-0.00425652)    );
  // itree = 671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286878,0.00276752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71402,0.0320648) , 
2, -0.407303, 1, 0, 0.466143,0.0350472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.571899,-0.0211145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788561,0.0202618) , 
2, 1.07984, 1, 0, 0.660326,-0.0120674) , 
0, 0.607167, 1, 0, 0.541314,0.0168086)    );
  // itree = 672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324965,0.0103814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479272,-0.0267938) , 
0, -0.316179, 1, 0, 0.367233,-0.001977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.740548,0.0190131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687519,-0.0194913) , 
0, 2.82387, 1, 0, 0.734731,0.0327883) , 
2, 0.162129, 1, 0, 0.522206,0.0126835)    );
  // itree = 673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326727,0.023985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276597,-0.00895259) , 
2, -0.0495301, 1, 0, 0.315679,0.0349836) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579555,-0.0267372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809747,-0.00704523) , 
3, 0.72619, 1, 0, 0.737876,-0.0305245) , 
3, 0.0990605, 1, 0, 0.535173,0.000926973)    );
  // itree = 674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11746,0.0352865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298842,-0.0233718) , 
3, -1.92752, 1, 0, 0.265474,-0.0376154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545166,0.0168996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610513,-0.00580351) , 
0, 0.047221, 1, 0, 0.58989,0.00133341) , 
0, -1.03364, 1, 0, 0.486411,-0.0110901)    );
  // itree = 675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.600516,0.0441715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731025,-0.006808) , 
0, 0.798591, 1, 0, 0.638953,0.0508027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215389,-0.0166099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74366,0.00757872) , 
3, 0.165162, 1, 0, 0.465206,-0.0118348) , 
1, -0.673494, 1, 0, 0.514733,0.00602026)    );
  // itree = 676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188393,0.109281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333844,-0.0143154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789154,0.00290998) , 
3, 0.647332, 1, 0, 0.49396,-0.0203895) , 
3, -2.15197, 1, 0, 0.482261,-0.0148579)    );
  // itree = 677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133763,-0.0406121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498619,-0.00282904) , 
0, -3.02048, 1, 0, 0.47939,-0.0120196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634383,0.0689619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488364,-0.000779637) , 
1, 1.25415, 1, 0, 0.528449,0.0466577) , 
1, 0.9765, 1, 0, 0.487418,-0.00241745)    );
  // itree = 678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258548,-0.0111885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611816,0.0029108) , 
0, -0.947742, 1, 0, 0.472378,-0.00512512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651008,-0.0355783) , 
0, 2.69796, 1, 0, 0.480638,-0.00926268)    );
  // itree = 679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341794,-0.0295394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753365,0.00282602) , 
2, 0.291111, 1, 0, 0.51804,-0.0401864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492293,0.00714004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419032,-0.0213685) , 
1, 1.06581, 1, 0, 0.476652,0.0017227) , 
1, -0.548365, 1, 0, 0.489938,-0.0117309)    );
  // itree = 680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323181,0.00882573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434158,0.0498831) , 
1, 1.36625, 1, 0, 0.337449,0.0319239) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449613,-0.0382221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6561,-0.00719068) , 
2, -0.0322495, 1, 0, 0.628671,-0.0295437) , 
2, -0.237048, 1, 0, 0.517277,-0.00603197)    );
  // itree = 681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248814,-0.0488041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851189,0.0263955) , 
3, 0.372371, 1, 0, 0.440768,-0.0803216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593738,0.0151087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450172,-0.0121362) , 
1, -0.289009, 1, 0, 0.500762,-0.00546743) , 
1, -1.40021, 1, 0, 0.493631,-0.0143639)    );
  // itree = 682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261478,0.00466899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241748,0.058252) , 
1, 0.582096, 1, 0, 0.252791,0.0536887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461438,-0.0281321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4672,-0.0105959) , 
1, -0.38293, 1, 0, 0.464787,-0.0414403) , 
2, -1.61118, 1, 0, 0.449733,-0.0346849)    );
  // itree = 683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0349815,-0.0587447) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434381,0.0138968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661361,-0.0030482) , 
0, 0.988075, 1, 0, 0.504136,0.0164769) , 
2, -2.02668, 1, 0, 0.491144,0.0123079)    );
  // itree = 684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.903016,0.0797782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494865,0.00270456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40913,-0.0275459) , 
1, 1.38111, 1, 0, 0.488061,0.000499523) , 
1, -2.00084, 1, 0, 0.503358,0.00634995)    );
  // itree = 685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291814,-0.0485652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527986,0.00555068) , 
2, -2.0544, 1, 0, 0.509831,0.00783668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168313,0.0300103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427534,-0.0340767) , 
3, -0.694489, 1, 0, 0.340208,-0.0463368) , 
1, 1.4007, 1, 0, 0.492693,0.0023631)    );
  // itree = 686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147185,-0.0611556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296266,-0.00779909) , 
1, -1.44575, 1, 0, 0.276651,-0.0348532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45708,0.0574311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64077,0.0071939) , 
0, -0.455847, 1, 0, 0.619314,0.027805) , 
0, -0.838864, 1, 0, 0.497527,0.00553545)    );
  // itree = 687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108799,-0.0296018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51026,0.00517589) , 
2, -1.31667, 1, 0, 0.430783,-0.00133223) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.676078,-0.0135874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508078,-0.0597164) , 
1, 1.05945, 1, 0, 0.655852,-0.0449572) , 
2, 0.604931, 1, 0, 0.494645,-0.0137106)    );
  // itree = 688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416875,0.0818769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199335,-0.0290302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556906,0.000221878) , 
0, -1.62345, 1, 0, 0.499654,-0.00790962) , 
0, -3.00687, 1, 0, 0.495502,0.00140067)    );
  // itree = 689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258098,0.0125741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.074188) , 
3, -0.418437, 1, 0, 0.380512,0.04994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485392,-0.0260703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679404,0.0159559) , 
0, 0.326914, 1, 0, 0.607422,-9.00781e-05) , 
0, -0.773058, 1, 0, 0.536654,0.0155131)    );
  // itree = 690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111848,-0.0637107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591113,-0.0115002) , 
3, -0.786928, 1, 0, 0.466247,-0.0697717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467818,-0.00526485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555512,0.0235341) , 
1, 1.10612, 1, 0, 0.480574,-0.00330392) , 
1, -1.48186, 1, 0, 0.479161,-0.00986156)    );
  // itree = 691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353336,-0.0135156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48765,-0.0365771) , 
2, 0.768406, 1, 0, 0.372635,-0.0398098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.949477,0.0388619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.870258,-0.0025639) , 
1, -0.585035, 1, 0, 0.894188,0.0191188) , 
3, 1.62579, 1, 0, 0.430935,-0.0332227)    );
  // itree = 692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524466,0.0207042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361812,-0.00734909) , 
1, -0.261294, 1, 0, 0.424868,0.00825936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62828,-0.0265912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915835,0.0265149) , 
3, 2.0237, 1, 0, 0.698457,-0.0360444) , 
2, 0.593896, 1, 0, 0.503248,-0.00443307)    );
  // itree = 693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143006,-0.0259156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586882,0.00313403) , 
0, -2.25576, 1, 0, 0.536076,0.00140598) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12629,-0.00858689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582352,0.0338192) , 
2, -0.951767, 1, 0, 0.445129,0.0512938) , 
1, 0.989266, 1, 0, 0.517812,0.0114244)    );
  // itree = 694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0883907,-0.00548521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393862,0.0681177) , 
3, -1.70025, 1, 0, 0.249914,0.0782298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236737,-0.0587177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610736,0.00460171) , 
0, -2.25653, 1, 0, 0.593548,0.00364889) , 
2, -1.30053, 1, 0, 0.550002,0.0131)    );
  // itree = 695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0695893,-0.0187271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378782,0.0193191) , 
3, -1.09402, 1, 0, 0.251874,0.0174931) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337989,-0.0353215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721801,0.000718253) , 
3, 0.0168336, 1, 0, 0.661889,-0.0153164) , 
3, -0.207894, 1, 0, 0.505642,-0.00281347)    );
  // itree = 696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0734904,0.00257812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368643,0.0683213) , 
3, -2.04267, 1, 0, 0.259104,0.0951656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287572,-0.0324843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579009,0.000489002) , 
0, -1.54137, 1, 0, 0.536739,-0.00959941) , 
2, -1.57101, 1, 0, 0.516057,-0.00179518)    );
  // itree = 697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151066,0.00672152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515541,0.0227109) , 
3, -0.55622, 1, 0, 0.30481,0.031666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.684677,-0.0386425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738315,0.00581043) , 
1, -0.36158, 1, 0, 0.713707,-0.0285042) , 
3, 0.262941, 1, 0, 0.482918,0.00545686)    );
  // itree = 698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119338,-0.0462172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191867,-0.00374968) , 
0, -3.14922, 1, 0, 0.162771,-0.0554794) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342236,0.0385121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612558,-0.00445638) , 
2, -0.483177, 1, 0, 0.546796,0.00973104) , 
0, -2.33878, 1, 0, 0.506415,0.00287412)    );
  // itree = 699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166189,-0.0394186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407099,-0.00968929) , 
2, -1.11105, 1, 0, 0.29954,-0.0560652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642842,0.0626586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614208,0.00161679) , 
2, -0.715316, 1, 0, 0.616028,0.0141369) , 
0, -0.691462, 1, 0, 0.500887,-0.0114033)    );
  // itree = 700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428709,-0.00042344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739322,0.0288795) , 
0, 1.11952, 1, 0, 0.458122,0.00521199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365114,-0.0362858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868792,0.00888776) , 
3, 1.61436, 1, 0, 0.615539,-0.0360173) , 
0, 1.63755, 1, 0, 0.487293,-0.00242841)    );
  // itree = 701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402617,-0.0318365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523545,0.0130706) , 
1, -1.62483, 1, 0, 0.509726,0.0172988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43544,-0.0311464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423208,0.0140377) , 
1, 1.89066, 1, 0, 0.433102,-0.0530575) , 
1, 0.820442, 1, 0, 0.494186,0.00303041)    );
  // itree = 702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195866,0.0684897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254917,0.0106549) , 
2, -1.65717, 1, 0, 0.242721,0.0377732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532994,-0.0586778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70031,-0.000331421) , 
0, -0.501079, 1, 0, 0.670945,-0.0286575) , 
3, -0.307255, 1, 0, 0.517546,-0.00486067)    );
  // itree = 703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182595,-0.008985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538707,-0.034326) , 
3, -0.472623, 1, 0, 0.313353,-0.0438451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596969,0.0714168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679645,-0.0104525) , 
2, -0.00120796, 1, 0, 0.662177,0.0124295) , 
0, -0.106773, 1, 0, 0.481593,-0.0167035)    );
  // itree = 704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636934,0.0395751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67267,-0.0284533) , 
2, 1.21777, 1, 0, 0.642356,0.0567744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438055,-0.0145267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498169,0.00707602) , 
1, 0.292592, 1, 0, 0.466427,-0.0101636) , 
1, -0.977314, 1, 0, 0.497164,0.00153146)    );
  // itree = 705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192647,0.039797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430162,-0.0178929) , 
2, -1.41902, 1, 0, 0.408223,-0.0316772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.683244,0.014839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.806281,0.0549113) , 
1, 0.835568, 1, 0, 0.71721,0.0741504) , 
0, 2.11278, 1, 0, 0.443036,-0.019754)    );
  // itree = 706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.703548,0.129017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340055,0.0102343) , 
1, -1.18742, 1, 0, 0.365955,0.0395102) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.594547,-0.0117418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753009,0.0188065) , 
0, 1.75721, 1, 0, 0.638298,-0.00857373) , 
0, -0.572125, 1, 0, 0.523599,0.0116771)    );
  // itree = 707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487233,0.0187549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291966,-0.0173657) , 
1, -0.279363, 1, 0, 0.36038,-0.0102167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57977,0.0430805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789935,0.00725404) , 
3, 0.615461, 1, 0, 0.729585,0.0427795) , 
2, 0.161708, 1, 0, 0.512953,0.0116838)    );
  // itree = 708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16249,-0.0133144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683229,0.0141285) , 
3, -0.456992, 1, 0, 0.48596,0.0111717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.679799,-0.0550913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560655,-0.00605871) , 
1, -0.0970254, 1, 0, 0.621529,-0.0756963) , 
0, 2.67663, 1, 0, 0.493522,0.00632619)    );
  // itree = 709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327982,0.0117495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577949,-0.00656681) , 
0, -1.02119, 1, 0, 0.511694,-0.00568575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589159,0.0458998) , 
1, 2.01701, 1, 0, 0.514349,-0.00135506)    );
  // itree = 710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376092,-0.0152742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.84599,0.00710534) , 
3, 0.908704, 1, 0, 0.505537,-0.0208825) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341588,0.0422432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560155,-0.00357553) , 
0, -1.53638, 1, 0, 0.491753,0.0248092) , 
1, 0.893255, 1, 0, 0.503018,-0.0125331)    );
  // itree = 711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273186,0.0253307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14159,-0.0145243) , 
1, 1.02385, 1, 0, 0.239906,0.0281989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197082,-0.0305085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727744,0.00655451) , 
3, -0.113285, 1, 0, 0.592438,-0.00727445) , 
2, -0.759232, 1, 0, 0.497357,0.00229302)    );
  // itree = 712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500933,-0.00597885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623969,0.0300962) , 
1, -0.878373, 1, 0, 0.550629,0.0150861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335399,-0.0239766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823803,0.0226682) , 
2, 1.18439, 1, 0, 0.388638,-0.0429451) , 
1, -0.362514, 1, 0, 0.44526,-0.0226608)    );
  // itree = 713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351606,-0.0207873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.848872,0.0219694) , 
3, 0.660704, 1, 0, 0.525727,-0.0206592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339138,0.0178976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751715,-0.0102842) , 
3, 0.810124, 1, 0, 0.466684,0.0181834) , 
1, -0.0246959, 1, 0, 0.495325,-0.000658309)    );
  // itree = 714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970014,-0.0523142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620019,-0.0275082) , 
3, -0.316848, 1, 0, 0.424044,-0.0976289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476918,0.00408522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670211,-0.03146) , 
2, 1.47382, 1, 0, 0.491696,0.00245058) , 
1, -1.69171, 1, 0, 0.486111,-0.00581173)    );
  // itree = 715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286249,-0.0130372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374823,-0.0598462) , 
0, 0.520733, 1, 0, 0.29507,-0.0431826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.67934,0.0185176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714449,-0.0128241) , 
2, 1.05217, 1, 0, 0.690982,0.0198348) , 
2, 0.110847, 1, 0, 0.472285,-0.0149751)    );
  // itree = 716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112484,0.000972347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0152826,-0.0618833) , 
0, -3.20827, 1, 0, 0.0434291,-0.0742855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574118,0.000593482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59059,0.0241654) , 
1, 0.0462137, 1, 0, 0.58101,0.0233072) , 
2, -1.66446, 1, 0, 0.531024,0.0142326)    );
  // itree = 717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470807,-0.0199769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469067,0.0136898) , 
1, -0.414745, 1, 0, 0.469645,0.0044158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266048,-0.0433454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.837609,-0.00399411) , 
3, 1.57211, 1, 0, 0.589187,-0.0602251) , 
0, 1.61764, 1, 0, 0.491653,-0.00748442)    );
  // itree = 718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474917,-0.00177758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.910732,0.0364882) , 
2, 1.5256, 1, 0, 0.512019,0.00232348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49677,0.036349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635104,-0.00496108) , 
0, 0.401097, 1, 0, 0.555956,0.0417113) , 
1, 0.313122, 1, 0, 0.526034,0.0148873)    );
  // itree = 719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547966,-0.0014301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47026,-0.0356639) , 
1, -0.54645, 1, 0, 0.530586,-0.0215456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467739,0.00472663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.850395,0.0398059) , 
0, 2.80946, 1, 0, 0.487842,0.0159499) , 
1, -0.269474, 1, 0, 0.506361,-0.000295897)    );
  // itree = 720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577353,0.0332326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697295,-0.0142819) , 
3, 0.882716, 1, 0, 0.609329,0.0588905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317974,-0.0215077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74784,0.00325059) , 
2, 0.553856, 1, 0, 0.4475,-0.0311844) , 
1, -1.49648, 1, 0, 0.462536,-0.0228149)    );
  // itree = 721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464342,0.0116104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.951805,0.094241) , 
1, -1.63613, 1, 0, 0.670324,0.111006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53375,0.0053513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423213,-0.0187037) , 
1, 0.614432, 1, 0, 0.499889,-0.00535272) , 
1, -1.42069, 1, 0, 0.516298,0.00585002)    );
  // itree = 722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.643058,0.0504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590809,0.0101368) , 
1, -1.77903, 1, 0, 0.59822,0.034832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388942,-0.000224706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659772,-0.0292365) , 
2, 0.895828, 1, 0, 0.434715,-0.011705) , 
1, -0.362514, 1, 0, 0.496183,0.00579022)    );
  // itree = 723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249215,-0.0153444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61124,0.0178874) , 
0, -1.676, 1, 0, 0.538441,0.0258565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31719,-0.00380063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476136,-0.0375325) , 
0, -0.204013, 1, 0, 0.396634,-0.0443543) , 
1, 1.08213, 1, 0, 0.517187,0.0153334)    );
  // itree = 724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447155,2.58547e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628942,-0.0279759) , 
2, 1.01921, 1, 0, 0.478275,-0.0107021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973165,0.0504948) , 
3, 2.62856, 1, 0, 0.497125,-0.00609278)    );
  // itree = 725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120075,0.00406345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472937,0.0272507) , 
3, -0.927516, 1, 0, 0.305157,0.0419704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550782,-0.0196115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820702,0.0107954) , 
3, 0.802712, 1, 0, 0.709281,-0.00577503) , 
3, 0.17816, 1, 0, 0.508537,0.0179419)    );
  // itree = 726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190855,-0.0231348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.828644,0.00904244) , 
3, -0.0923998, 1, 0, 0.290363,-0.0414829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632632,0.00624513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.870142,0.0552637) , 
1, 1.70477, 1, 0, 0.644805,0.0193112) , 
0, -0.371383, 1, 0, 0.479222,-0.00908971)    );
  // itree = 727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398104,-0.0366063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823348,0.0241248) , 
0, 0.955926, 1, 0, 0.497141,-0.0624134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134909,-0.0327773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594663,0.0127796) , 
2, -1.25845, 1, 0, 0.531522,0.0157214) , 
1, -1.21928, 1, 0, 0.526702,0.00476739)    );
  // itree = 728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528479,0.0899643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.870394,0.0208889) , 
3, 0.384775, 1, 0, 0.673324,0.0889599) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287219,0.0218087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5645,-0.00377753) , 
2, -1.13773, 1, 0, 0.518674,0.000263326) , 
1, -1.71006, 1, 0, 0.529091,0.00623733)    );
  // itree = 729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432279,-0.00118327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242419,-0.0534955) , 
1, 1.39446, 1, 0, 0.411767,-0.0147636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704834,0.04531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.849547,0.00321458) , 
3, 1.0392, 1, 0, 0.811238,0.0383293) , 
2, 0.604931, 1, 0, 0.517231,-0.000746577)    );
  // itree = 730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0439084,-0.0606189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562514,0.00715537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432518,-0.0179031) , 
1, -0.0229864, 1, 0, 0.502798,-0.0101682) , 
0, -3.03185, 1, 0, 0.482544,-0.0174287)    );
  // itree = 731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490337,-0.0119569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.879561,0.0333439) , 
0, 2.81258, 1, 0, 0.5138,-0.0180775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473687,0.0434274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628391,-0.00131945) , 
2, 0.419641, 1, 0, 0.531885,0.0549457) , 
1, 0.839672, 1, 0, 0.51749,-0.00317834)    );
  // itree = 732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21113,0.0293468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401512,-0.0195136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885574,-0.00148628) , 
3, 1.28386, 1, 0, 0.505662,-0.0374268) , 
2, -2.10645, 1, 0, 0.495782,-0.0340354)    );
  // itree = 733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345815,0.00991154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427915,-0.0161287) , 
0, -0.725461, 1, 0, 0.379966,-0.00309319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.754991,0.019099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614282,-0.0637514) , 
0, 2.95673, 1, 0, 0.745914,0.0297578) , 
2, 0.161708, 1, 0, 0.534904,0.0108155)    );
  // itree = 734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424499,0.00425657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.860066,-0.020424) , 
3, 1.14325, 1, 0, 0.511912,0.00190631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0632309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56368,0.0290479) , 
2, -1.92844, 1, 0, 0.520991,0.0470364) , 
1, 0.353971, 1, 0, 0.514954,0.0170303)    );
  // itree = 735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0615529,-0.0220074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54494,0.0376853) , 
3, -1.21343, 1, 0, 0.343344,0.0352837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298068,-0.0301976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652147,0.00901359) , 
2, -0.175279, 1, 0, 0.570534,-0.00193692) , 
0, -0.707105, 1, 0, 0.498375,0.00988492)    );
  // itree = 736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321472,-0.0125012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472159,-0.0323692) , 
2, 0.64551, 1, 0, 0.340961,-0.0353456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.891223,0.0444904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.883698,-0.00853697) , 
3, 1.47887, 1, 0, 0.886328,0.0258888) , 
3, 1.14325, 1, 0, 0.463548,-0.0215815)    );
  // itree = 737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207669,0.0262476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640654,0.0463281) , 
3, -0.567805, 1, 0, 0.352942,0.0653443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.663826,-0.000119389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564592,-0.0306725) , 
1, 0.935819, 1, 0, 0.647448,-0.0120556) , 
2, -0.281514, 1, 0, 0.536389,0.0171323)    );
  // itree = 738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225132,-0.0427387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539939,-0.0214101) , 
0, -1.89337, 1, 0, 0.49436,-0.0636415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.663863,0.0317078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499067,-0.00334453) , 
1, -0.551509, 1, 0, 0.525872,0.00458895) , 
1, -0.977314, 1, 0, 0.519406,-0.00941006)    );
  // itree = 739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233829,-0.00592212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468373,0.0662873) , 
1, -0.440638, 1, 0, 0.371709,0.0653991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500788,0.00910716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612336,-0.00528157) , 
0, 0.268428, 1, 0, 0.562721,0.00191537) , 
0, -1.72765, 1, 0, 0.534924,0.0111539)    );
  // itree = 740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284744,0.118984) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468192,-0.011758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.872631,0.0241897) , 
2, 1.47366, 1, 0, 0.495545,-0.0205568) , 
2, -2.13325, 1, 0, 0.490401,-0.0155837)    );
  // itree = 741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435916,-0.0676176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492408,0.00864432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704992,-0.0198603) , 
2, 1.24313, 1, 0, 0.518631,0.0106691) , 
1, -2.05922, 1, 0, 0.516312,0.00548767)    );
  // itree = 742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61387,0.0481301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681499,-0.0141383) , 
2, 1.1122, 1, 0, 0.629587,0.0578258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260443,-0.0217871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540265,0.00202643) , 
0, -1.5378, 1, 0, 0.480906,-0.00496682) , 
1, -0.823218, 1, 0, 0.516703,0.0101511)    );
  // itree = 743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361123,0.000224163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155561,-0.0457258) , 
1, 0.684304, 1, 0, 0.274827,-0.0406615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593388,0.00305393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745511,0.0227677) , 
0, 1.34188, 1, 0, 0.650547,0.0243101) , 
0, -0.898821, 1, 0, 0.515282,0.000919323)    );
  // itree = 744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188942,0.00991155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322089,-0.0283826) , 
3, -0.774483, 1, 0, 0.258535,-0.0329862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.819894,0.021772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683128,-0.000555482) , 
1, -0.218242, 1, 0, 0.742148,0.0183097) , 
3, 0.0354976, 1, 0, 0.491436,-0.00828283)    );
  // itree = 745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0651175,0.0062094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557947,0.0554198) , 
3, -1.98171, 1, 0, 0.297847,0.0855705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413437,-0.0213334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677903,-0.000911818) , 
0, 0.761885, 1, 0, 0.507502,-0.0313874) , 
0, -2.405, 1, 0, 0.489854,-0.0215425)    );
  // itree = 746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865529,-0.00689377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541678,0.0154008) , 
3, -1.14811, 1, 0, 0.432928,0.0237179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.640778,-0.0329009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779837,0.023609) , 
1, 0.641961, 1, 0, 0.675902,-0.0419866) , 
2, 0.60567, 1, 0, 0.496847,0.00643317)    );
  // itree = 747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436342,-0.0490378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262078,-0.010404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623028,0.0128586) , 
0, -0.838864, 1, 0, 0.494153,0.0112111) , 
1, -1.71006, 1, 0, 0.491117,0.00422859)    );
  // itree = 748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287008,-0.00350189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605372,0.0376473) , 
2, -0.0732169, 1, 0, 0.373414,0.020126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617286,-0.0273116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851535,0.00149308) , 
3, 1.18759, 1, 0, 0.759287,-0.0218437) , 
3, 0.644527, 1, 0, 0.501643,0.00617909)    );
  // itree = 749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172819,-0.0117449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263519,-0.0277078) , 
2, -0.862028, 1, 0, 0.227996,-0.0557079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712141,-0.0285408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788513,0.0172534) , 
1, -0.673257, 1, 0, 0.766649,0.00718716) , 
3, 0.207882, 1, 0, 0.473702,-0.0270184)    );
  // itree = 750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408132,0.0738344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497435,0.00149788) , 
1, -1.94587, 1, 0, 0.494423,0.00672349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442207,-0.0528731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87609,-0.00326738) , 
3, 2.32655, 1, 0, 0.65592,-0.0863207) , 
0, 2.74551, 1, 0, 0.503756,0.00134636)    );
  // itree = 751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116297,-0.00445528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452949,0.0294215) , 
3, -0.755896, 1, 0, 0.191745,0.0118668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240813,-0.0392988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711994,-0.00493914) , 
3, -0.0504686, 1, 0, 0.643589,-0.0279577) , 
3, -0.274954, 1, 0, 0.48073,-0.0136036)    );
  // itree = 752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349618,-0.00665515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456131,-0.0323221) , 
2, 0.286978, 1, 0, 0.365299,-0.0246926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650613,0.0526848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794465,0.00557219) , 
3, 0.603216, 1, 0, 0.777798,0.0262329) , 
2, 0.560086, 1, 0, 0.481453,-0.0103526)    );
  // itree = 753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443311,-0.0106672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709499,0.0246395) , 
0, 1.22149, 1, 0, 0.504485,-0.00561145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618661,0.05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697687,-0.00244973) , 
3, 0.680986, 1, 0, 0.650498,0.0746461) , 
1, 1.08213, 1, 0, 0.521996,0.00401337)    );
  // itree = 754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650737,-0.00261176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779119,0.0447981) , 
1, -2.00197, 1, 0, 0.742976,0.0724788) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124427,0.00986905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513064,-0.0136045) , 
3, -1.42096, 1, 0, 0.462443,-0.0240632) , 
1, -1.31849, 1, 0, 0.489366,-0.0147978)    );
  // itree = 755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.609699,-0.0143647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250307,-0.0553428) , 
1, -1.42118, 1, 0, 0.478386,-0.074367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508412,0.00280619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397301,-0.038831) , 
1, 1.5976, 1, 0, 0.500471,-0.000261976) , 
1, -1.19917, 1, 0, 0.497292,-0.0109306)    );
  // itree = 756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311744,0.00526672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538195,-0.0199028) , 
0, -0.874725, 1, 0, 0.463093,-0.0276282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.856311,-0.000498549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.804536,0.0268361) , 
1, -0.309855, 1, 0, 0.826183,0.0455135) , 
2, 1.50355, 1, 0, 0.489431,-0.0223226)    );
  // itree = 757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484217,-0.00536235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412248,-0.0286921) , 
1, 0.0868331, 1, 0, 0.468716,-0.0248888) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292377,-0.0181974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723157,0.0393847) , 
0, -0.417356, 1, 0, 0.539943,0.0342004) , 
1, 0.463922, 1, 0, 0.490645,-0.00669674)    );
  // itree = 758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131585,-0.0482348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156379,-0.0166282) , 
1, -1.46955, 1, 0, 0.154586,-0.042104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.698015,0.0429367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741774,0.00724636) , 
3, 0.158606, 1, 0, 0.734553,0.0343382) , 
3, -0.304384, 1, 0, 0.49535,0.00281018)    );
  // itree = 759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28988,0.00291697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666248,-0.0431174) , 
1, 0.301203, 1, 0, 0.188706,-0.0269522) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487343,0.0401648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698955,0.000279206) , 
2, 0.0743838, 1, 0, 0.623639,0.0277315) , 
2, -0.871865, 1, 0, 0.51068,0.0135293)    );
  // itree = 760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433464,-0.00507746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447566,0.0170789) , 
1, 0.0687374, 1, 0, 0.439806,0.00824107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.90457,0.0289706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578892,-0.0421715) , 
1, -1.39701, 1, 0, 0.618275,-0.0755114) , 
0, 1.37723, 1, 0, 0.479915,-0.0105814)    );
  // itree = 761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0950957,-0.0106168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247309,-0.0376954) , 
3, -0.724203, 1, 0, 0.134383,-0.0402642) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.784038,0.0544159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595942,0.00569414) , 
0, -1.67537, 1, 0, 0.604207,0.0185755) , 
2, -0.724736, 1, 0, 0.471319,0.00193292)    );
  // itree = 762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.8676,0.0620975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521226,0.00580464) , 
1, -1.61991, 1, 0, 0.555335,0.022134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361212,-0.0348231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389756,-0.0080104) , 
1, 0.67633, 1, 0, 0.381712,-0.0399889) , 
1, 0.313122, 1, 0, 0.484819,-0.00309671)    );
  // itree = 763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212053,0.0026259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631121,0.0321435) , 
3, -0.325669, 1, 0, 0.33299,0.0273299) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389376,-0.0550275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759194,-0.00559056) , 
2, -0.175375, 1, 0, 0.726529,-0.0242507) , 
3, 0.306962, 1, 0, 0.51448,0.00354231)    );
  // itree = 764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0831679,0.00898489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178821,-0.057806) , 
3, -1.81, 1, 0, 0.122476,-0.0855743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517895,-0.00395054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68703,-0.0264963) , 
0, 2.87714, 1, 0, 0.527326,-0.0124142) , 
0, -2.33908, 1, 0, 0.478233,-0.0212859)    );
  // itree = 765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138652,0.0216761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405294,-0.0188411) , 
3, -1.09293, 1, 0, 0.307799,-0.0178264) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.648581,-0.0161464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675383,0.0190604) , 
1, -0.876513, 1, 0, 0.669415,0.0283279) , 
2, 0.161708, 1, 0, 0.46737,0.00254021)    );
  // itree = 766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285847,0.0118162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432392,0.0491977) , 
1, 1.31643, 1, 0, 0.299103,0.0320812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494951,-0.0284474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668001,0.00523185) , 
0, -0.5401, 1, 0, 0.644564,-0.000499769) , 
2, -0.281514, 1, 0, 0.496841,0.0134322)    );
  // itree = 767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356526,0.00812858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567651,-0.0173234) , 
2, 0.00811223, 1, 0, 0.428222,-0.00309714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.73249,-0.0159159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747552,0.0277432) , 
1, -0.493896, 1, 0, 0.742342,0.0307518) , 
2, 0.772657, 1, 0, 0.502511,0.00490811)    );
  // itree = 768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440904,0.014631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655029,-0.00325138) , 
0, 0.0848771, 1, 0, 0.546303,0.0112643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316652,-0.0635384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31089,-0.0227646) , 
1, 2.06794, 1, 0, 0.313744,-0.108626) , 
1, 1.73295, 1, 0, 0.532839,0.00432297)    );
  // itree = 769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237887,0.0265354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468917,-0.010908) , 
2, -1.27563, 1, 0, 0.433118,-0.013967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.775564,0.0306435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723034,0.00158411) , 
1, -0.225865, 1, 0, 0.747963,0.0341084) , 
2, 0.799265, 1, 0, 0.511709,-0.00196656)    );
  // itree = 770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481862,0.0068381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658685,-0.0581776) , 
0, 2.65922, 1, 0, 0.489527,0.00819652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405565,-0.00794573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.363852,-0.0538468) , 
1, 1.46388, 1, 0, 0.394845,-0.0426198) , 
1, 0.662387, 1, 0, 0.462834,-0.00612963)    );
  // itree = 771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.05336,-0.0587641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315883,0.0426707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559546,0.000189971) , 
0, -2.22179, 1, 0, 0.544063,0.00548205) , 
0, -3.16923, 1, 0, 0.525373,-0.000561667)    );
  // itree = 772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36613,-0.00213739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590752,-0.0491365) , 
3, 0.941099, 1, 0, 0.39107,-0.017883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.898873,0.010863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875735,0.0411489) , 
1, 0.845729, 1, 0, 0.894516,0.0326284) , 
3, 1.31913, 1, 0, 0.491,-0.00785691)    );
  // itree = 773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52176,-0.00988323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529339,0.0150271) , 
1, 0.284468, 1, 0, 0.523127,-0.0105485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403525,0.0516703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643134,0.00124199) , 
0, -0.296719, 1, 0, 0.510998,0.0543058) , 
1, 0.71376, 1, 0, 0.520143,0.00540831)    );
  // itree = 774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0246414,-0.0643645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526931,0.00109114) , 
0, -3.13399, 1, 0, 0.504432,-0.00573986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504732,-0.0205822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269456,-0.0551472) , 
1, 1.95826, 1, 0, 0.38583,-0.104655) , 
1, 1.48204, 1, 0, 0.493918,-0.0145082)    );
  // itree = 775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294529,-0.0144354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403601,0.0290957) , 
1, -0.863434, 1, 0, 0.378671,0.0392046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374996,-0.0458834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677396,0.00471221) , 
0, -0.314981, 1, 0, 0.633795,-0.00768905) , 
0, -0.691462, 1, 0, 0.544828,0.0086637)    );
  // itree = 776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0677187,-0.0510078) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564523,-0.020277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517154,0.0130649) , 
1, -1.6752, 1, 0, 0.520238,0.0210781) , 
0, -3.14395, 1, 0, 0.49833,0.013893)    );
  // itree = 777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141906,0.0053487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36809,-0.0355327) , 
3, -0.968746, 1, 0, 0.250607,-0.0430965) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617871,0.00605039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48952,-0.0248657) , 
1, 0.728565, 1, 0, 0.587007,-0.00423472) , 
0, -0.707105, 1, 0, 0.455877,-0.0193832)    );
  // itree = 778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0348261,-0.0490102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421643,0.0132945) , 
2, -2.18656, 1, 0, 0.40737,0.0239078) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.816586,-0.0286482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838988,0.0391895) , 
1, 1.3388, 1, 0, 0.819844,-0.0257556) , 
3, 1.18513, 1, 0, 0.493348,0.0135557)    );
  // itree = 779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184708,0.00397074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.807508,0.0497713) , 
3, -0.765353, 1, 0, 0.384261,0.044192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488785,-0.0263953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.894859,0.0128984) , 
3, 1.60342, 1, 0, 0.57028,-0.0503074) , 
0, -0.691462, 1, 0, 0.499446,-0.0143231)    );
  // itree = 780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513399,0.0402135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304589,-0.0150512) , 
1, -1.53843, 1, 0, 0.321436,-0.0233958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.717294,0.0242638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824635,-0.00623208) , 
3, 1.22165, 1, 0, 0.769813,0.0245931) , 
3, 0.502357, 1, 0, 0.501223,-0.00415355)    );
  // itree = 781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16398,0.10194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503833,-0.00352233) , 
3, -2.24393, 1, 0, 0.491048,-0.00337776) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166541,0.00691862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495356,-0.0455839) , 
2, -1.29204, 1, 0, 0.432153,-0.0841115) , 
1, 0.935819, 1, 0, 0.479986,-0.0185411)    );
  // itree = 782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617106,0.0379527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643183,0.00656921) , 
1, -0.932188, 1, 0, 0.625317,0.0513564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41517,-0.00954236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549795,0.0177508) , 
1, 1.12449, 1, 0, 0.440063,-0.0102296) , 
1, -0.636138, 1, 0, 0.492228,0.00711227)    );
  // itree = 783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0723878,0.0176567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138106,-0.0390764) , 
3, -1.98873, 1, 0, 0.108543,-0.0626822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450391,0.0129535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677374,-0.0115845) , 
2, 0.267791, 1, 0, 0.554334,0.00156693) , 
2, -1.64509, 1, 0, 0.510642,-0.00473015)    );
  // itree = 784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250806,-0.0653953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.847643,0.0247191) , 
3, 0.660704, 1, 0, 0.397362,-0.165069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0565683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488474,0.00500792) , 
3, -2.14882, 1, 0, 0.471977,0.00865995) , 
1, -1.36512, 1, 0, 0.464561,-0.0086084)    );
  // itree = 785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305121,-0.00421622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.444195,-0.0237929) , 
0, -0.808508, 1, 0, 0.35496,-0.0263635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.782504,0.0313013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595978,0.00223483) , 
1, -0.408908, 1, 0, 0.66667,0.0270836) , 
0, 0.0848771, 1, 0, 0.490683,-0.00309185)    );
  // itree = 786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463188,0.0134792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846135,0.0399028) , 
0, 1.23997, 1, 0, 0.558507,0.0443209) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240654,-0.0275525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671731,0.00615603) , 
2, 0.174832, 1, 0, 0.380404,-0.0379674) , 
1, 0.476476, 1, 0, 0.494139,0.014581)    );
  // itree = 787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443023,-0.0184374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.969138,0.0577606) , 
3, 1.5996, 1, 0, 0.511824,-0.027526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354785,0.013016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7571,-0.0138722) , 
3, 0.699898, 1, 0, 0.49005,0.00914106) , 
1, -0.359664, 1, 0, 0.499094,-0.0060893)    );
  // itree = 788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970571,-0.0196478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0622924,-0.0527011) , 
2, -1.80314, 1, 0, 0.0793445,-0.0925093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26926,-0.0147097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694077,0.00167263) , 
2, -0.177637, 1, 0, 0.514439,-0.010708) , 
0, -3.03185, 1, 0, 0.487796,-0.0157169)    );
  // itree = 789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468902,-0.0376839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72993,0.00455212) , 
0, 1.58834, 1, 0, 0.512616,-0.0688196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498428,-0.00466773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519856,0.0144118) , 
1, 0.703158, 1, 0, 0.504843,0.0023355) , 
1, -0.84272, 1, 0, 0.506779,-0.015387)    );
  // itree = 790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349289,0.00886979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649869,-0.0116353) , 
2, 0.0724854, 1, 0, 0.501291,-0.00602228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228888,-0.052702) , 
1, 2.09327, 1, 0, 0.490095,-0.0112349)    );
  // itree = 791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466679,0.0310333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307109,-0.00243601) , 
1, -0.106686, 1, 0, 0.37958,0.0256199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.549854,0.0308656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670003,-0.0190893) , 
2, 0.0182404, 1, 0, 0.650209,-0.0240117) , 
0, 0.0848771, 1, 0, 0.511933,0.00134722)    );
  // itree = 792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209225,0.0357146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266503,-0.0173705) , 
2, -1.74051, 1, 0, 0.258107,-0.0213413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585556,0.0204854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687833,-0.00474603) , 
2, 0.472825, 1, 0, 0.637735,0.0178148) , 
2, -0.363302, 1, 0, 0.491435,0.00272493)    );
  // itree = 793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191246,0.00804481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229499,-0.0372573) , 
3, -0.793484, 1, 0, 0.207846,-0.0325927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.813917,0.0201175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652733,-0.0081189) , 
0, 0.0989588, 1, 0, 0.69707,-0.00228877) , 
3, -0.202496, 1, 0, 0.49008,-0.0151104)    );
  // itree = 794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.685385,0.0652678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464171,-0.0228138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481757,0.00525058) , 
1, -1.19794, 1, 0, 0.479097,0.00304305) , 
1, -1.99305, 1, 0, 0.484543,0.00664234)    );
  // itree = 795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127827,0.0258379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218582,-0.0511158) , 
3, -1.80158, 1, 0, 0.166153,-0.0549864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565551,0.000508784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776847,0.0714646) , 
1, 1.81888, 1, 0, 0.572391,0.00562485) , 
0, -2.3109, 1, 0, 0.525742,-0.00133514)    );
  // itree = 796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376681,0.00199923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.910628,0.056102) , 
2, 0.146852, 1, 0, 0.426723,0.0145467) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345308,-0.0401352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.807886,0.00845618) , 
3, 0.866606, 1, 0, 0.652789,-0.0320375) , 
2, 0.383617, 1, 0, 0.519252,-0.00452036)    );
  // itree = 797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266616,0.000817568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313774,-0.0375552) , 
0, -1.33185, 1, 0, 0.278099,-0.0186157) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542652,0.040406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6295,0.0027367) , 
0, 0.184092, 1, 0, 0.59927,0.0297299) , 
0, -0.96123, 1, 0, 0.500415,0.0148494)    );
  // itree = 798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384447,0.0429383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564851,0.00282766) , 
2, -0.833719, 1, 0, 0.530228,0.0232473) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290679,-0.0350279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789824,0.0323588) , 
2, 0.700668, 1, 0, 0.374308,-0.0469799) , 
1, 0.809128, 1, 0, 0.491475,0.00579267)    );
  // itree = 799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273187,-0.0188351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316065,0.0130841) , 
0, -0.543734, 1, 0, 0.285605,-0.022524) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627939,-0.0104603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.837739,0.0149676) , 
2, 0.0748393, 1, 0, 0.805017,0.0212464) , 
3, 0.301115, 1, 0, 0.510969,-0.00353273)    );
  // itree = 800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285548,-0.00811898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264592,-0.0426934) , 
2, 0.464112, 1, 0, 0.283072,-0.032432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.786461,0.001738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.888801,0.027843) , 
2, 0.793078, 1, 0, 0.839812,0.0305023) , 
3, 0.392653, 1, 0, 0.516056,-0.00609537)    );
  // itree = 801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424505,0.00526683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513941,-0.0165577) , 
0, -0.0243632, 1, 0, 0.474811,-0.0176953) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210925,-0.00693981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640417,0.0266535) , 
2, -0.540322, 1, 0, 0.461258,0.0326958) , 
1, 0.342797, 1, 0, 0.469936,0.000430543)    );
  // itree = 802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266123,-0.0278883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632747,0.0176366) , 
0, -1.63768, 1, 0, 0.560372,0.0181858) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214272,-0.0288771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769705,0.00182072) , 
3, 0.301115, 1, 0, 0.442549,-0.0421581) , 
1, -0.359664, 1, 0, 0.489188,-0.0182715)    );
  // itree = 803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436762,-0.0198691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40632,0.00206577) , 
1, 0.321275, 1, 0, 0.425602,-0.0275435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554086,0.023606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.889391,-0.0104439) , 
3, 1.65654, 1, 0, 0.71198,0.02638) , 
0, 1.32897, 1, 0, 0.488645,-0.0156728)    );
  // itree = 804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308371,-0.0069533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145441,-0.0424606) , 
1, 1.34775, 1, 0, 0.287538,-0.0267919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.801504,0.0445289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811104,0.000251977) , 
3, 1.02595, 1, 0, 0.80759,0.0383166) , 
3, 0.487045, 1, 0, 0.467999,-0.0041988)    );
  // itree = 805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537235,-0.00286206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473789,0.0254935) , 
1, -0.596007, 1, 0, 0.51119,0.0180658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179201,0.0116427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610892,-0.0162683) , 
3, -0.285822, 1, 0, 0.45613,-0.0184476) , 
1, 0.126794, 1, 0, 0.486656,0.00179551)    );
  // itree = 806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296503,0.0571462) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282617,-0.0207679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799363,0.00870131) , 
3, 0.495659, 1, 0, 0.502996,-0.0186601) , 
0, -3.18107, 1, 0, 0.494612,-0.0128163)    );
  // itree = 807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382404,-0.0373054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556107,-0.0319751) , 
0, -0.707387, 1, 0, 0.488821,-0.0857683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520817,-0.00285094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46946,0.0145157) , 
1, 0.779309, 1, 0, 0.508719,0.0024318) , 
1, -1.65895, 1, 0, 0.507336,-0.00369568)    );
  // itree = 808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410907,-0.0296939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.785436,0.00343736) , 
2, 0.461295, 1, 0, 0.556983,-0.0368581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409322,0.0237148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769224,-0.00277536) , 
3, 0.810124, 1, 0, 0.530552,0.032767) , 
1, -0.580095, 1, 0, 0.539344,0.00960743)    );
  // itree = 809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414627,0.00263685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719292,0.0363243) , 
2, 0.34778, 1, 0, 0.48779,0.0237149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.599888,-0.0318232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.892516,0.00718815) , 
3, 1.61671, 1, 0, 0.757634,-0.030203) , 
2, 0.927498, 1, 0, 0.536444,0.0139934)    );
  // itree = 810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540445,0.050809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0581296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549221,0.00215973) , 
3, -1.73087, 1, 0, 0.507894,-0.000371819) , 
1, -1.81119, 1, 0, 0.509294,0.00421841)    );
  // itree = 811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468679,0.00878464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353143,-0.0140458) , 
1, -0.38645, 1, 0, 0.398075,-0.0124014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298166,-0.0434034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835434,-0.0108782) , 
3, 1.14627, 1, 0, 0.59617,-0.0596987) , 
0, 0.614298, 1, 0, 0.467377,-0.028948)    );
  // itree = 812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219018,0.014243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48307,-0.0139785) , 
0, -2.25576, 1, 0, 0.455357,-0.0260769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474603,0.0420978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601256,-0.0395129) , 
2, 0.845202, 1, 0, 0.505585,0.0340703) , 
1, 1.17696, 1, 0, 0.460701,-0.0196768)    );
  // itree = 813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383232,0.0450054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452966,0.0122719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683567,-0.0069908) , 
2, 0.577358, 1, 0, 0.529583,0.0115497) , 
0, -3.14395, 1, 0, 0.522635,0.0168564)    );
  // itree = 814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244674,0.0219279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289539,-0.0294382) , 
0, -1.92526, 1, 0, 0.274352,-0.0298526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.600381,0.0232079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711966,-0.00472518) , 
0, 0.771241, 1, 0, 0.655216,0.021325) , 
0, -0.707105, 1, 0, 0.510262,0.00184713)    );
  // itree = 815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503142,0.00464082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573795,0.0412144) , 
1, 1.23216, 1, 0, 0.506828,0.0145884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141987,-0.0475643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764464,-0.00196325) , 
2, -0.559818, 1, 0, 0.435377,-0.0469497) , 
1, 1.48916, 1, 0, 0.502078,0.0104969)    );
  // itree = 816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233092,0.000803313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497315,-0.028615) , 
2, -0.3863, 1, 0, 0.36481,-0.0308302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.77239,0.0239626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741824,-0.0208973) , 
2, 1.40513, 1, 0, 0.76203,0.0198888) , 
2, 0.617679, 1, 0, 0.463834,-0.0181863)    );
  // itree = 817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442225,-0.0636676) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0631172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520787,0.00683061) , 
2, -2.07855, 1, 0, 0.50488,0.0114727) , 
1, -2.16716, 1, 0, 0.502978,0.00586063)    );
  // itree = 818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130861,0.00790918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432946,0.0469551) , 
3, -1.17173, 1, 0, 0.254558,0.0567613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41918,-0.0168937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674729,0.0010069) , 
2, -0.021642, 1, 0, 0.585137,-0.0130637) , 
2, -0.704443, 1, 0, 0.509517,0.00290888)    );
  // itree = 819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38363,0.077334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227994,0.0033526) , 
1, -0.281116, 1, 0, 0.291305,0.0783853) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.737606,-0.0651934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504248,-0.00420044) , 
1, -2.12925, 1, 0, 0.511703,-0.0126703) , 
0, -2.31973, 1, 0, 0.490245,-0.00380515)    );
  // itree = 820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369974,0.00434954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315935,0.0397188) , 
0, 0.830336, 1, 0, 0.365134,0.0176174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.841221,0.00339601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764024,-0.0337741) , 
2, 1.18511, 1, 0, 0.811746,-0.0216661) , 
3, 0.810124, 1, 0, 0.498316,0.0059029)    );
  // itree = 821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620349,-0.026879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533316,0.0151734) , 
3, -1.42593, 1, 0, 0.442693,0.0195763) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405094,-0.0530968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774924,-0.00811936) , 
3, 0.823722, 1, 0, 0.705653,-0.0415715) , 
2, 0.705933, 1, 0, 0.510776,0.00374456)    );
  // itree = 822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452003,-0.0257003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447224,-0.000446288) , 
1, -0.868869, 1, 0, 0.448354,-0.0141898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.834151,0.0355562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723258,-0.00875752) , 
0, 2.15746, 1, 0, 0.774001,0.0251499) , 
0, 1.63755, 1, 0, 0.506387,-0.00717909)    );
  // itree = 823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267125,-0.0335305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357049,-0.00426159) , 
1, -0.767649, 1, 0, 0.333732,-0.0250217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.871287,0.0754059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674571,0.00100647) , 
2, 0.354938, 1, 0, 0.690646,0.0180288) , 
2, 0.161708, 1, 0, 0.476062,-0.00785403)    );
  // itree = 824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511908,0.000733988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3906,-0.0329627) , 
1, 1.0424, 1, 0, 0.501587,-0.00488522) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305232,0.0470214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52833,0.0230007) , 
2, -0.317298, 1, 0, 0.415776,0.0644507) , 
1, 1.56529, 1, 0, 0.496166,-0.000504761)    );
  // itree = 825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236496,0.0167491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0604575,-0.0447184) , 
1, -0.552932, 1, 0, 0.106855,-0.0562674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439931,0.0487605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602625,0.00381008) , 
2, -0.994134, 1, 0, 0.58599,0.0193232) , 
2, -1.53711, 1, 0, 0.528432,0.0102425)    );
  // itree = 826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104248,-0.00263082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187059,-0.0550054) , 
3, -1.476, 1, 0, 0.13955,-0.0518321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504764,0.0479862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57085,0.000872974) , 
2, -0.911904, 1, 0, 0.567378,0.00816786) , 
2, -1.16796, 1, 0, 0.504112,-0.00070471)    );
  // itree = 827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399595,0.0252842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787843,-0.00748367) , 
3, 0.124445, 1, 0, 0.61838,0.017353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402595,-0.0337911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467403,-0.00172745) , 
1, -0.347486, 1, 0, 0.452739,-0.01988) , 
1, -0.75596, 1, 0, 0.495042,-0.0103711)    );
  // itree = 828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40139,0.0141934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185409,-0.0392134) , 
1, 1.40651, 1, 0, 0.376992,0.0164921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361306,-0.0310543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81465,-0.0021574) , 
3, 0.75308, 1, 0, 0.628719,-0.039973) , 
2, 0.110847, 1, 0, 0.496192,-0.0102456)    );
  // itree = 829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402693,0.00842982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854383,0.0397959) , 
2, 0.20956, 1, 0, 0.600715,0.044826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316838,-0.0894027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437846,-0.00273007) , 
1, -0.43375, 1, 0, 0.428017,-0.024265) , 
1, -0.636138, 1, 0, 0.475871,-0.00512003)    );
  // itree = 830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113891,-0.00360005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614363,0.0340227) , 
3, -0.912285, 1, 0, 0.336834,0.0312518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489767,-0.0475085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687454,0.00120039) , 
0, -0.0785381, 1, 0, 0.662496,-0.0105688) , 
0, -0.422556, 1, 0, 0.522369,0.007426)    );
  // itree = 831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.665184,0.081211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288523,0.0122791) , 
1, -1.59062, 1, 0, 0.309557,0.0355038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0679991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698449,-0.00531457) , 
0, -0.278551, 1, 0, 0.723604,-0.00280139) , 
3, 0.135748, 1, 0, 0.52298,0.0157592)    );
  // itree = 832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294526,-0.0449934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138286,-0.0124553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652146,0.00916886) , 
3, -0.759664, 1, 0, 0.507422,0.00876541) , 
1, -1.6752, 1, 0, 0.493163,0.001633)    );
  // itree = 833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366889,-0.0436016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574644,-0.00868584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516841,0.00617063) , 
1, -0.876727, 1, 0, 0.530424,0.00492004) , 
2, -2.13325, 1, 0, 0.516302,0.00264323)    );
  // itree = 834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.773526,0.0526547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667517,-0.034505) , 
0, 1.07404, 1, 0, 0.739486,0.0651889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389022,-0.0114763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.740664,0.016051) , 
2, 0.809855, 1, 0, 0.469518,-0.0108469) , 
1, -1.4993, 1, 0, 0.494375,-0.00384596)    );
  // itree = 835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252998,-0.0187361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397391,0.0463854) , 
1, 1.09951, 1, 0, 0.266849,-0.0264038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.796782,0.025613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.881025,0.00025249) , 
3, 1.51178, 1, 0, 0.826328,0.0382032) , 
3, 0.307824, 1, 0, 0.504831,0.00107768)    );
  // itree = 836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228491,0.0341847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309776,0.00556638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647236,-0.0128333) , 
2, -0.226165, 1, 0, 0.515237,-0.0131729) , 
0, -3.14395, 1, 0, 0.503811,-0.0100086)    );
  // itree = 837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186794,0.0312083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499314,-0.00617159) , 
2, -1.40108, 1, 0, 0.454025,-0.00284882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307745,-0.0566652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74828,-0.0138902) , 
2, 0.66926, 1, 0, 0.636793,-0.0626375) , 
0, 1.23997, 1, 0, 0.49272,-0.015507)    );
  // itree = 838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276563,-0.007645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392354,0.0431331) , 
1, 0.84565, 1, 0, 0.294681,0.00062423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.880207,0.0653822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675951,0.00958133) , 
2, -0.0730422, 1, 0, 0.697562,0.0367403) , 
2, -0.304616, 1, 0, 0.525741,0.0213375)    );
  // itree = 839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121071,-0.0137501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474457,0.0233944) , 
2, -1.42482, 1, 0, 0.379237,0.0273177) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627507,-0.0135543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799477,0.041175) , 
1, 1.41092, 1, 0, 0.6401,-0.0236389) , 
2, 0.0724854, 1, 0, 0.512525,0.00128145)    );
  // itree = 840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316511,-0.00540399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704115,-0.0238392) , 
3, 0.362714, 1, 0, 0.460381,-0.0265098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82933,0.0281606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757724,-8.67294e-05) , 
1, 0.0462137, 1, 0, 0.792964,0.0323913) , 
0, 2.41389, 1, 0, 0.486774,-0.0218354)    );
  // itree = 841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.062456,-0.0306204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659526,0.0182791) , 
3, -1.39829, 1, 0, 0.567226,0.0228951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403198,-0.0285817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395307,-0.00422353) , 
1, 0.170366, 1, 0, 0.39735,-0.0247061) , 
1, -0.237385, 1, 0, 0.467155,-0.00514613)    );
  // itree = 842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27152,0.0491156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219033,-0.0398424) , 
0, -3.05308, 1, 0, 0.226769,-0.0570957) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.662545,0.00150394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646927,0.0282397) , 
1, -0.553853, 1, 0, 0.653142,0.0388345) , 
0, -0.96123, 1, 0, 0.499821,0.00433858)    );
  // itree = 843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370021,-0.0117643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181317,-0.0514236) , 
1, 1.73295, 1, 0, 0.360157,-0.0305177) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.77423,0.0044464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.843633,0.0391217) , 
1, 1.15272, 1, 0, 0.783116,0.0187413) , 
2, 0.560086, 1, 0, 0.481243,-0.0164157)    );
  // itree = 844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470033,-0.0142496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547439,-0.0565032) , 
2, 0.784957, 1, 0, 0.489409,-0.0549123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.663368,0.0259521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471043,-0.00287891) , 
1, -0.636138, 1, 0, 0.509339,0.00533464) , 
1, -1.26758, 1, 0, 0.506421,-0.00348721)    );
  // itree = 845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150141,-0.0196222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611629,0.0169522) , 
0, -2.86288, 1, 0, 0.577699,0.0293576) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325776,0.00965496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483584,-0.0283904) , 
0, -1.12712, 1, 0, 0.436372,-0.0414559) , 
1, 0.107402, 1, 0, 0.513575,-0.00277226)    );
  // itree = 846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162918,-0.00827678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4516,0.0782094) , 
0, -3.04979, 1, 0, 0.27266,0.0573509) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299702,-0.015765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760527,0.00523891) , 
3, 0.390744, 1, 0, 0.512621,-0.0136622) , 
0, -2.36962, 1, 0, 0.490343,-0.00706924)    );
  // itree = 847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310531,-0.00828931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545649,-0.0282544) , 
2, 0.157326, 1, 0, 0.383639,-0.0324199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.842008,-0.00424006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836402,0.0249794) , 
1, -0.708136, 1, 0, 0.838278,0.0308903) , 
2, 1.04815, 1, 0, 0.442783,-0.024184)    );
  // itree = 848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335406,-0.0457204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23105,-0.0158683) , 
1, -1.41633, 1, 0, 0.240973,-0.0437847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.827199,0.0302549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777048,0.00144385) , 
3, 0.412272, 1, 0, 0.783766,0.0107546) , 
3, 0.202693, 1, 0, 0.492504,-0.0185112)    );
  // itree = 849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450845,0.0105894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217831,-0.0305369) , 
1, 0.17319, 1, 0, 0.33472,-0.0183715) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.951202,0.0923024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733022,0.0110142) , 
2, 0.419849, 1, 0, 0.760405,0.0449893) , 
2, 0.224475, 1, 0, 0.509583,0.00765591)    );
  // itree = 850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46422,-0.0722769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433475,-0.0187469) , 
1, -2.10738, 1, 0, 0.445858,-0.117092) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134303,-0.0365046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544895,-0.00156982) , 
0, -2.87651, 1, 0, 0.513432,-0.00948005) , 
1, -1.71006, 1, 0, 0.508455,-0.0174057)    );
  // itree = 851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492678,0.0130669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250614,-0.0355627) , 
1, 1.41912, 1, 0, 0.463697,0.0147757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613931,0.0359793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6463,-0.0287531) , 
2, 0.253483, 1, 0, 0.642142,-0.0478267) , 
0, 1.05872, 1, 0, 0.511239,-0.00190285)    );
  // itree = 852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496454,0.0822801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818845,0.0149444) , 
3, 0.17816, 1, 0, 0.653748,0.10379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33961,-0.0127524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722662,0.00902752) , 
2, 0.21299, 1, 0, 0.481439,-0.00984162) , 
1, -1.65967, 1, 0, 0.490082,-0.00414158)    );
  // itree = 853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48233,-0.0179093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356971,-0.0356974) , 
1, -1.93312, 1, 0, 0.425233,-0.0743909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.945932,0.0632794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472058,-0.00775894) , 
1, -1.40233, 1, 0, 0.490367,-0.0111623) , 
1, -1.6752, 1, 0, 0.485477,-0.0159095)    );
  // itree = 854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.973313,0.0808078) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209839,-0.0156453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617047,0.00477743) , 
2, -0.585857, 1, 0, 0.473434,-0.00498372) , 
1, -2.00084, 1, 0, 0.48858,-0.000725769)    );
  // itree = 855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34945,0.0177486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825889,-0.0225853) , 
3, 0.166015, 1, 0, 0.444706,0.0222503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.587065,-0.0208736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82536,0.0186743) , 
2, 1.13807, 1, 0, 0.661355,-0.0190992) , 
0, 0.227996, 1, 0, 0.546261,0.00286754)    );
  // itree = 856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423339,-0.00318504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.532466,-0.0402902) , 
0, 1.09987, 1, 0, 0.434651,-0.0160744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.751889,0.0264036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628119,-0.00734033) , 
1, 0.559867, 1, 0, 0.717295,0.0360042) , 
0, 1.61764, 1, 0, 0.48736,-0.00636236)    );
  // itree = 857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301524,0.0090484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482691,-0.0217583) , 
0, -1.676, 1, 0, 0.455189,-0.0416041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138978,-0.00878357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770424,0.0161015) , 
3, -0.0773368, 1, 0, 0.450561,0.00906605) , 
1, 0.71376, 1, 0, 0.453961,-0.0281582)    );
  // itree = 858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313586,0.00984019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108219,-0.0344654) , 
1, -0.0173103, 1, 0, 0.196431,-0.0240855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.802066,0.0488744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574007,0.0156049) , 
1, -1.31849, 1, 0, 0.600185,0.0421712) , 
0, -1.94824, 1, 0, 0.530761,0.0307785)    );
  // itree = 859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451027,-0.0132989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378182,0.0185469) , 
1, -0.562049, 1, 0, 0.39912,0.0168566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.686254,-0.0127457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586062,-0.0580417) , 
1, 0.877195, 1, 0, 0.669069,-0.0456897) , 
2, 0.553856, 1, 0, 0.484644,-0.00295882)    );
  // itree = 860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182586,-0.00876293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345487,-0.055322) , 
2, -0.590471, 1, 0, 0.22037,-0.0476125) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154708,-0.00708028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717568,0.0097697) , 
3, -0.0946902, 1, 0, 0.540155,0.0106961) , 
0, -1.4678, 1, 0, 0.47627,-0.000952589)    );
  // itree = 861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417522,0.0255594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602085,0.00294316) , 
0, -0.691462, 1, 0, 0.544627,0.0209874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355117,-0.0165443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842361,0.0232168) , 
2, 1.08824, 1, 0, 0.414457,-0.0242371) , 
1, 0.662387, 1, 0, 0.513313,0.0101083)    );
  // itree = 862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417658,-0.0113954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.810371,0.0172044) , 
2, 0.646171, 1, 0, 0.518895,-0.00898388) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.653674,0.0574566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451958,0.00688674) , 
1, 0.503601, 1, 0, 0.485233,0.0315088) , 
1, 0.215291, 1, 0, 0.505558,0.00705975)    );
  // itree = 863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573449,-0.0039254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592821,0.0227989) , 
1, -0.767831, 1, 0, 0.586499,0.0285907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381153,-0.0720585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428332,-0.00375621) , 
1, 0.815265, 1, 0, 0.421919,-0.0325343) , 
1, 0.653132, 1, 0, 0.53963,0.0111838)    );
  // itree = 864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411876,8.21346e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590005,-0.0173711) , 
0, 0.522083, 1, 0, 0.482606,-0.0149771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882608,-0.0287346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656655,0.0221302) , 
2, -0.949462, 1, 0, 0.501838,0.0211459) , 
1, 0.345387, 1, 0, 0.489183,-0.00262329)    );
  // itree = 865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.066606,-0.0130871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270644,-0.0676861) , 
3, -1.20546, 1, 0, 0.144325,-0.0813277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420576,0.0299086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655637,-0.00400386) , 
2, -0.343997, 1, 0, 0.602296,0.00775119) , 
2, -1.09958, 1, 0, 0.529933,-0.00632402)    );
  // itree = 866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182863,0.000812019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619648,-0.0221436) , 
3, -0.431676, 1, 0, 0.437968,-0.0293307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641287,0.0571754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705147,0.000511939) , 
2, 0.225903, 1, 0, 0.696279,0.0202199) , 
0, 1.37226, 1, 0, 0.498044,-0.0178066)    );
  // itree = 867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225302,0.0074674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.844521,0.0468191) , 
3, -0.53309, 1, 0, 0.421295,0.0419842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125864,-0.035375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763947,0.006051) , 
3, 0.0334873, 1, 0, 0.630462,-0.0060376) , 
0, -0.691462, 1, 0, 0.560419,0.0100433)    );
  // itree = 868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.743442,0.0568362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.939035,0.0173419) , 
3, 1.08885, 1, 0, 0.796211,0.0980875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223036,0.0330592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500032,-0.0153941) , 
2, -1.09958, 1, 0, 0.448623,-0.0179075) , 
1, -1.40332, 1, 0, 0.486872,-0.00514307)    );
  // itree = 869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735919,0.0378992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497135,-0.0193142) , 
1, -1.74452, 1, 0, 0.525186,-0.0261588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.058411,-0.0302013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536388,0.0209386) , 
2, -1.7876, 1, 0, 0.494123,0.0336956) , 
1, -0.24206, 1, 0, 0.507896,0.00715636)    );
  // itree = 870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118887,-0.0103219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633369,0.0152888) , 
3, -0.712858, 1, 0, 0.435149,0.0132535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673519,0.032003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60006,-0.020501) , 
0, 1.15852, 1, 0, 0.613001,-0.0262492) , 
0, 0.861216, 1, 0, 0.491457,0.000746803)    );
  // itree = 871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275592,0.00216556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42334,0.042052) , 
0, -1.326, 1, 0, 0.313123,0.0234776) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27664,-0.0439943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57838,-0.0179528) , 
0, -0.556174, 1, 0, 0.536788,-0.0539922) , 
0, -0.91774, 1, 0, 0.46593,-0.0294496)    );
  // itree = 872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153741,-0.063595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704566,0.0217979) , 
3, -0.0147916, 1, 0, 0.362647,-0.0966066) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519106,4.89238e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188553,-0.0589959) , 
1, 2.12987, 1, 0, 0.507906,-0.00557431) , 
1, -1.6752, 1, 0, 0.493325,-0.0147117)    );
  // itree = 873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.620134,-0.0568067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366629,-0.00736354) , 
1, -1.98118, 1, 0, 0.472969,-0.0667691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.876822,0.0545786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51531,0.00257991) , 
1, -1.43963, 1, 0, 0.527965,0.00955175) , 
1, -1.71379, 1, 0, 0.523585,0.00347343)    );
  // itree = 874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422671,-0.0378749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248147,-0.0220885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647007,-0.0025144) , 
2, -0.281514, 1, 0, 0.470839,-0.0225014) , 
1, -1.6752, 1, 0, 0.468189,-0.0274256)    );
  // itree = 875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267103,0.064069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203743,0.0259493) , 
1, 0.0325634, 1, 0, 0.232901,0.0678902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303049,-0.0129309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733228,0.00821076) , 
3, -0.0344276, 1, 0, 0.607443,0.0034578) , 
2, -1.18181, 1, 0, 0.545408,0.0141296)    );
  // itree = 876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58856,0.0460288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763648,0.027577) , 
2, 0.175824, 1, 0, 0.686497,0.0796297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0431319,-0.0567522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523876,-0.00277366) , 
0, -3.02048, 1, 0, 0.501431,-0.0119023) , 
1, -1.71379, 1, 0, 0.512889,-0.00623506)    );
  // itree = 877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428641,0.00399159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972433,0.0626317) , 
2, 1.04822, 1, 0, 0.458263,0.0147834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92655,0.023397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571656,-0.0205667) , 
1, -1.41121, 1, 0, 0.614955,-0.0368381) , 
0, 1.33181, 1, 0, 0.491812,0.00373088)    );
  // itree = 878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.587344,-0.0317803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388047,0.0110674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818936,-0.00512394) , 
3, 0.908704, 1, 0, 0.50382,0.0143931) , 
1, -2.03172, 1, 0, 0.506234,0.011668)    );
  // itree = 879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278403,0.0802863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407263,-0.0698668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521525,0.000592489) , 
1, -2.03172, 1, 0, 0.517507,-0.00493448) , 
0, -3.27799, 1, 0, 0.508221,0.00112561)    );
  // itree = 880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465277,-0.026222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419383,0.0614115) , 
3, -1.70385, 1, 0, 0.285025,0.0804484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520481,-0.0333743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558272,0.0061677) , 
1, -1.31849, 1, 0, 0.553315,0.00247432) , 
2, -1.1665, 1, 0, 0.520277,0.0120761)    );
  // itree = 881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439882,-0.0258801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319839,0.0431409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535024,0.0053127) , 
0, -3.08798, 1, 0, 0.522572,0.0156052) , 
1, -1.86485, 1, 0, 0.517754,0.01048)    );
  // itree = 882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306059,0.0335943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675242,-0.0018587) , 
3, -0.304384, 1, 0, 0.561776,0.0203535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414402,-0.0108926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800451,0.0222539) , 
2, 1.3046, 1, 0, 0.448799,-0.0151821) , 
1, -0.294962, 1, 0, 0.493952,-0.000979687)    );
  // itree = 883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485689,0.0132262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303411,-0.0202409) , 
1, -0.375211, 1, 0, 0.367833,-0.0199421) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.69337,0.0287496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711175,-0.0107645) , 
0, 2.27792, 1, 0, 0.69847,0.0356177) , 
0, 0.421965, 1, 0, 0.500966,0.00242949)    );
  // itree = 884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.630415,0.0457242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408765,0.00485718) , 
1, -1.14537, 1, 0, 0.439224,0.0195451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195555,-0.0615119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712307,-0.00513385) , 
2, 0.196571, 1, 0, 0.613744,-0.0359175) , 
0, 0.861216, 1, 0, 0.493236,0.00237992)    );
  // itree = 885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168626,-0.0368657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124841,0.0106454) , 
1, -0.610343, 1, 0, 0.138917,-0.0211927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465818,0.0311007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74371,0.00401026) , 
3, 0.0916973, 1, 0, 0.669749,0.0294067) , 
3, -0.632115, 1, 0, 0.5187,0.0150085)    );
  // itree = 886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574099,0.0108671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429698,-0.00261746) , 
1, -0.300643, 1, 0, 0.489787,0.00591009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40259,-0.0404452) , 
1, 1.82989, 1, 0, 0.484883,0.00140366)    );
  // itree = 887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537138,0.00433856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330365,-0.0382378) , 
1, 0.533583, 1, 0, 0.517411,-0.000222746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358501,0.0540826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755404,0.00451773) , 
3, 0.287233, 1, 0, 0.560165,0.0584499) , 
1, 0.736789, 1, 0, 0.526049,0.0116313)    );
  // itree = 888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216134,-0.00115967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49889,0.0365519) , 
2, -0.951364, 1, 0, 0.365311,0.0366988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463513,-0.0385503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717394,-0.00386354) , 
0, -0.51727, 1, 0, 0.682027,-0.0201596) , 
2, -0.0765418, 1, 0, 0.532948,0.00660382)    );
  // itree = 889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797424,-0.0215711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25899,0.0391536) , 
3, -1.59917, 1, 0, 0.183851,0.0268882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434658,-0.0120804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793699,0.00395548) , 
3, 0.570534, 1, 0, 0.612577,-0.0106679) , 
3, -0.683307, 1, 0, 0.506693,-0.00139256)    );
  // itree = 890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519949,-0.0186392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515497,-0.0876477) , 
2, 0.818259, 1, 0, 0.518754,-0.0850292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503519,0.000512231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422175,-0.0293057) , 
1, 0.945888, 1, 0, 0.491115,-0.00882784) , 
1, -1.37246, 1, 0, 0.494079,-0.0169978)    );
  // itree = 891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230299,0.0818239) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.499049,-0.00592419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62658,-0.0439195) , 
0, 2.82256, 1, 0, 0.505232,-0.0169376) , 
2, -1.90732, 1, 0, 0.492425,-0.0108251)    );
  // itree = 892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619335,0.0213336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443131,-0.011566) , 
1, -0.928803, 1, 0, 0.479663,-0.0112312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846015,0.0647361) , 
1, 1.41152, 1, 0, 0.499237,-0.00454245)    );
  // itree = 893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235781,0.00978663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336458,0.0601064) , 
1, 0.822987, 1, 0, 0.253788,0.0344646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526831,-0.0371429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721404,0.00781605) , 
2, 0.0211528, 1, 0, 0.668795,-0.0152396) , 
3, -0.140969, 1, 0, 0.503199,0.00459333)    );
  // itree = 894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348334,-0.00174541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256014,-0.0281942) , 
0, -0.118418, 1, 0, 0.322432,-0.0246015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.900583,0.0670851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823227,0.00182121) , 
3, 0.774366, 1, 0, 0.832713,0.0186526) , 
3, 0.575013, 1, 0, 0.50024,-0.00952954)    );
  // itree = 895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214281,-0.00485077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418917,-0.0349204) , 
3, -0.22257, 1, 0, 0.249404,-0.0262442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0841955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730343,0.00711065) , 
0, -0.597683, 1, 0, 0.747903,0.0235961) , 
3, 0.0509667, 1, 0, 0.514808,0.000291037)    );
  // itree = 896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112213,-0.0102839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221293,-0.0599579) , 
2, -1.50599, 1, 0, 0.15074,-0.06791) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548604,0.0158733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73476,-0.0123279) , 
0, 1.73965, 1, 0, 0.581832,0.0210627) , 
2, -1.14903, 1, 0, 0.505971,0.00540565)    );
  // itree = 897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.809591,0.0793751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103876,-0.0254143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66487,0.00632054) , 
3, -0.756041, 1, 0, 0.518463,-0.000531271) , 
1, -1.99305, 1, 0, 0.527896,0.00482543)    );
  // itree = 898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165912,-0.0625201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774618,-0.00694909) , 
3, -0.067798, 1, 0, 0.433672,-0.122586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348442,-0.00778099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68864,0.0102312) , 
0, -0.122417, 1, 0, 0.501208,0.00037634) , 
1, -1.72757, 1, 0, 0.496967,-0.00734466)    );
  // itree = 899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541217,-0.00757402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455017,0.030747) , 
1, 0.273477, 1, 0, 0.526469,-0.00237355) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19332,0.00803108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407931,-0.038856) , 
0, -0.904221, 1, 0, 0.325271,-0.0531075) , 
1, 0.671618, 1, 0, 0.47579,-0.0151526)    );
  // itree = 900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923975,-0.066312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724296,0.00363552) , 
3, -0.566199, 1, 0, 0.41156,-0.101996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351465,0.0235807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535032,-0.0110668) , 
0, -1.48202, 1, 0, 0.501693,-0.011042) , 
1, -1.71379, 1, 0, 0.495525,-0.0172667)    );
  // itree = 901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.591928,0.0128965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472545,-0.00981384) , 
1, -0.493335, 1, 0, 0.515203,-0.00416059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631077,0.0494726) , 
1, 1.7189, 1, 0, 0.519053,-0.000421671)    );
  // itree = 902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296151,-0.00320139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545135,-0.0183506) , 
0, -0.827504, 1, 0, 0.453608,-0.0268868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864295,0.0203111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.765488,0.0307334) , 
1, -0.212287, 1, 0, 0.81316,0.0746324) , 
0, 2.76471, 1, 0, 0.471117,-0.0219431)    );
  // itree = 903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152504,-0.0386647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19388,0.0115534) , 
1, 1.07327, 1, 0, 0.162044,-0.0545849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458878,0.016351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601688,-0.00743371) , 
0, -0.420506, 1, 0, 0.554304,0.000612006) , 
2, -1.16796, 1, 0, 0.485457,-0.00907579)    );
  // itree = 904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451835,0.00656836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423237,-0.024045) , 
1, -0.837685, 1, 0, 0.430735,-0.0336026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.909032,0.0633007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670185,0.00649971) , 
1, -1.31849, 1, 0, 0.700195,0.0322396) , 
0, 1.33069, 1, 0, 0.488198,-0.0195616)    );
  // itree = 905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391052,0.0167226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216429,-0.0234698) , 
1, 1.32833, 1, 0, 0.368999,0.0224269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559031,-0.0353578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731013,0.0109276) , 
0, 0.496124, 1, 0, 0.679601,-0.00726903) , 
2, 0.171595, 1, 0, 0.50379,0.00953983)    );
  // itree = 906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438332,-0.00659342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.612652,-0.0242272) , 
0, 0.611097, 1, 0, 0.499481,-0.0278889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246825,0.0256502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676138,-0.00987501) , 
3, 0.0857632, 1, 0, 0.473941,0.0122749) , 
1, 0.371143, 1, 0, 0.490999,-0.0145504)    );
  // itree = 907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273617,-0.0397914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67883,0.000966153) , 
0, -1.03691, 1, 0, 0.559589,-0.0312964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.720392,0.0585414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420683,0.00390529) , 
1, -0.553795, 1, 0, 0.438277,0.0142789) , 
1, -0.760996, 1, 0, 0.467569,0.00327426)    );
  // itree = 908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116021,0.0153749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398068,0.05655) , 
3, -1.20779, 1, 0, 0.202982,0.0554063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613565,-0.00627159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.820479,0.0336153) , 
0, 2.65655, 1, 0, 0.628518,-0.00690027) , 
3, -0.759664, 1, 0, 0.535658,0.00669627)    );
  // itree = 909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29454,-0.00253065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440208,-0.0240987) , 
0, -1.79147, 1, 0, 0.410512,-0.0445826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681326,0.0215452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744434,-0.0200953) , 
0, 2.4094, 1, 0, 0.70028,0.0124882) , 
0, 1.31332, 1, 0, 0.475737,-0.0317363)    );
  // itree = 910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169695,-0.0440657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833069,0.00199025) , 
3, -0.210183, 1, 0, 0.57783,-0.0405719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432689,0.000941845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402133,0.0645689) , 
1, 2.11395, 1, 0, 0.431403,0.00608641) , 
1, -0.577244, 1, 0, 0.475566,-0.0079859)    );
  // itree = 911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242344,0.00191035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599026,0.0427195) , 
3, -0.0136847, 1, 0, 0.297747,0.0188431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525889,-0.0272901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811422,0.00775177) , 
3, 0.676124, 1, 0, 0.728305,-0.00900652) , 
3, 0.262941, 1, 0, 0.489413,0.00644566)    );
  // itree = 912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191687,-0.024304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543197,0.0268879) , 
3, -0.0428675, 1, 0, 0.246099,-0.0341912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.865062,0.0349969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719629,-0.0073023) , 
2, 0.205492, 1, 0, 0.754626,0.00288051) , 
3, 0.228725, 1, 0, 0.493273,-0.0161722)    );
  // itree = 913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.761444,0.0510587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493939,-0.000448929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269709,-0.051701) , 
1, 1.95722, 1, 0, 0.484939,-0.0056674) , 
1, -1.75827, 1, 0, 0.499816,0.0002836)    );
  // itree = 914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119371,-0.0641824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174773,-0.0094981) , 
1, -1.15459, 1, 0, 0.168749,-0.0365121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429897,0.0258807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734732,-0.00113946) , 
3, 0.192991, 1, 0, 0.626475,0.0176741) , 
2, -0.696554, 1, 0, 0.494402,0.00203912)    );
  // itree = 915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27183,0.00236074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563668,0.0268622) , 
2, -0.678397, 1, 0, 0.387664,0.0234026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.750399,0.0179753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589697,-0.0150118) , 
1, -1.19117, 1, 0, 0.614528,-0.020303) , 
2, 0.0724854, 1, 0, 0.500984,0.00157131)    );
  // itree = 916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58764,-0.0127601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384356,-0.05157) , 
1, -2.10157, 1, 0, 0.483709,-0.0926527) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151633,-0.0371873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535283,-0.00109374) , 
2, -1.2061, 1, 0, 0.478091,-0.0129867) , 
1, -1.86956, 1, 0, 0.478481,-0.018529)    );
  // itree = 917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101182,0.0311633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205746,-0.0504105) , 
3, -2.12528, 1, 0, 0.158845,-0.07534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508072,-0.00533926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589545,0.0217297) , 
1, -0.0229864, 1, 0, 0.546296,0.0157955) , 
0, -2.36962, 1, 0, 0.510704,0.00742378)    );
  // itree = 918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410713,-0.0554782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483722,-0.0111623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522979,0.013283) , 
1, -0.458268, 1, 0, 0.510211,0.0120033) , 
1, -1.86485, 1, 0, 0.505665,0.00493864)    );
  // itree = 919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0283291,-0.0286446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485107,0.0320343) , 
3, -1.73463, 1, 0, 0.377404,0.0461037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251636,-0.0220231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768102,0.00609168) , 
3, 0.32343, 1, 0, 0.57754,-0.0109673) , 
0, -0.773058, 1, 0, 0.513441,0.00731107)    );
  // itree = 920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321166,-0.0126889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589818,0.0114845) , 
0, -0.271019, 1, 0, 0.43581,-0.00541258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.512305,-0.109406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670583,-0.0129558) , 
1, -1.15254, 1, 0, 0.633728,-0.0729225) , 
2, 1.1453, 1, 0, 0.462562,-0.0145378)    );
  // itree = 921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352236,0.00313389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192697,-0.0545893) , 
1, 1.24619, 1, 0, 0.330993,-0.0109272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417501,0.0229162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764766,0.00455308) , 
3, 0.436362, 1, 0, 0.646469,0.0252257) , 
0, -0.707105, 1, 0, 0.524551,0.0112541)    );
  // itree = 922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148383,0.0106597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434371,0.106167) , 
3, -1.57746, 1, 0, 0.264465,0.0856988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.683387,0.0156387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51695,-0.01069) , 
1, -0.636138, 1, 0, 0.568548,-0.00679586) , 
2, -1.27668, 1, 0, 0.535435,0.00327613)    );
  // itree = 923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226554,0.0757391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0383693,-0.0436875) , 
2, -1.28476, 1, 0, 0.149415,0.0433106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450469,-0.020402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712907,0.0020671) , 
0, 0.669405, 1, 0, 0.549484,-0.0291472) , 
3, -1.46348, 1, 0, 0.498274,-0.0198723)    );
  // itree = 924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332773,0.00444302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55134,0.0381054) , 
0, -0.725461, 1, 0, 0.417004,0.0355266) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59741,-0.0120027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816783,0.0183071) , 
2, 1.18039, 1, 0, 0.659711,-0.00889473) , 
2, 0.0582897, 1, 0, 0.534158,0.0140846)    );
  // itree = 925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297791,0.0889235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473223,9.88387e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70334,0.0579282) , 
1, 1.81136, 1, 0, 0.480728,0.0046402) , 
0, -3.79682, 1, 0, 0.476149,0.00891753)    );
  // itree = 926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366233,-0.00710934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545956,-0.0477568) , 
2, 0.0544374, 1, 0, 0.39036,-0.0284563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681973,0.0351603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722625,-0.00181869) , 
2, 0.821118, 1, 0, 0.703809,0.0367053) , 
2, 0.291111, 1, 0, 0.517389,-0.00204872)    );
  // itree = 927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542199,-0.00432066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596375,0.032518) , 
1, 0.287018, 1, 0, 0.555147,0.0103486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172659,-0.0541105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708425,-0.0116964) , 
3, 0.195173, 1, 0, 0.448788,-0.078489) , 
1, 1.17696, 1, 0, 0.540132,-0.00219261)    );
  // itree = 928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149869,-0.0366962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211372,0.0136581) , 
1, -0.0375415, 1, 0, 0.180157,-0.0319428) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.893866,0.0549198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599471,0.0062866) , 
1, -1.42694, 1, 0, 0.627143,0.0220509) , 
2, -0.724736, 1, 0, 0.505294,0.00733225)    );
  // itree = 929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260116,-0.0197643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453244,0.0770015) , 
1, 1.18756, 1, 0, 0.281195,-0.0192288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574377,0.0746125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632194,0.00677268) , 
0, -0.362987, 1, 0, 0.624795,0.031777) , 
0, -0.736877, 1, 0, 0.494118,0.0123786)    );
  // itree = 930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0919124,-0.0132213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631789,0.0324618) , 
3, -0.997459, 1, 0, 0.43277,0.0387681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.67315,-0.00151126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725202,-0.0268609) , 
1, 0.236115, 1, 0, 0.688984,-0.019826) , 
2, 0.553856, 1, 0, 0.512743,0.0204789)    );
  // itree = 931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0607421,-0.0407596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224192,0.0224923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512635,-0.00338199) , 
0, -2.53879, 1, 0, 0.494873,-0.00386122) , 
2, -2.0544, 1, 0, 0.480206,-0.0068871)    );
  // itree = 932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2013,-0.0157178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.075005,-0.0635593) , 
1, 0.315854, 1, 0, 0.159021,-0.0775843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.57832,-0.00655627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516427,0.00645199) , 
1, -0.38293, 1, 0, 0.539143,0.0034507) , 
0, -2.26714, 1, 0, 0.493749,-0.0062265)    );
  // itree = 933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452332,-0.00986748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776178,0.0192281) , 
2, 0.799599, 1, 0, 0.522626,-0.00650991) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400416,-0.0463346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440457,-0.00775556) , 
1, 1.59615, 1, 0, 0.42071,-0.0699135) , 
1, 1.15272, 1, 0, 0.510624,-0.0139767)    );
  // itree = 934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310421,-0.0463766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437771,0.00196885) , 
1, -1.71379, 1, 0, 0.430353,-0.0035412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.881387,0.0438511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809596,0.0144655) , 
2, 1.23719, 1, 0, 0.83379,0.0538137) , 
2, 0.944059, 1, 0, 0.506145,0.00723381)    );
  // itree = 935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376956,0.00322813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713379,0.0317423) , 
2, 0.27069, 1, 0, 0.437169,0.0184615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.706127,-0.0170796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83563,0.0246084) , 
1, 0.893255, 1, 0, 0.729132,-0.0181304) , 
2, 0.799265, 1, 0, 0.507591,0.00963556)    );
  // itree = 936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119155,-0.0240079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453984,0.0160368) , 
2, -1.31066, 1, 0, 0.393072,0.0194427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64821,-0.0183688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.943015,0.0414686) , 
3, 2.34216, 1, 0, 0.681367,-0.0276373) , 
2, 0.553856, 1, 0, 0.482492,0.0048399)    );
  // itree = 937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510689,0.0066615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375013,-0.0358865) , 
1, 1.40358, 1, 0, 0.495777,0.00467401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606422,-0.0669519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.970153,0.0457597) , 
3, 2.62754, 1, 0, 0.729499,-0.0692015) , 
2, 1.49137, 1, 0, 0.515892,-0.00168426)    );
  // itree = 938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429038,0.0536003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675385,0.0161706) , 
2, -0.822461, 1, 0, 0.643597,0.0452573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246623,0.00961333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609688,-0.0241971) , 
3, -0.200632, 1, 0, 0.461668,-0.0273835) , 
1, -0.548365, 1, 0, 0.514502,-0.00628765)    );
  // itree = 939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303129,0.0281576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606468,0.000879277) , 
2, -0.914603, 1, 0, 0.538488,0.013563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348349,-0.0683639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443882,-0.00425259) , 
1, 0.515894, 1, 0, 0.426083,-0.0361783) , 
1, 0.37474, 1, 0, 0.496904,-0.004839)    );
  // itree = 940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361261,0.00272273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512036,0.0549121) , 
0, -0.543734, 1, 0, 0.404214,0.039746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.662808,-0.0192779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.871872,0.0103527) , 
3, 1.37586, 1, 0, 0.749966,-0.0166141) , 
3, 0.392653, 1, 0, 0.553955,0.0153371)    );
  // itree = 941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.806773,0.0671994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809665,0.0078256) , 
3, 0.706203, 1, 0, 0.808462,0.0886161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488875,-0.0293904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460355,-0.00681624) , 
1, -0.435847, 1, 0, 0.468676,-0.0288892) , 
1, -1.49648, 1, 0, 0.489951,-0.021532)    );
  // itree = 942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105192,0.0213314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208512,0.120276) , 
2, -1.48539, 1, 0, 0.144153,0.0683117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523449,-0.0218571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512758,-0.000512742) , 
1, -0.465869, 1, 0, 0.516668,-0.016862) , 
3, -1.67155, 1, 0, 0.488119,-0.0103343)    );
  // itree = 943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21465,-0.0249161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631313,-0.00120323) , 
2, -0.43761, 1, 0, 0.519308,-0.0186053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419583,0.0256132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644533,-0.00656393) , 
2, 0.21299, 1, 0, 0.516001,0.0216139) , 
1, -0.636138, 1, 0, 0.517136,0.00780603)    );
  // itree = 944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0743517,-0.00234381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603679,0.0362405) , 
3, -1.09489, 1, 0, 0.254815,0.0323903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432061,-0.024521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869899,0.005841) , 
3, 1.14118, 1, 0, 0.559442,-0.0417492) , 
2, -0.855032, 1, 0, 0.494336,-0.0259037)    );
  // itree = 945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235507,-0.0326911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290028,0.00728485) , 
1, 0.512763, 1, 0, 0.250976,-0.0510784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574199,0.0321112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778195,-0.00241467) , 
3, 0.342784, 1, 0, 0.732994,0.0156472) , 
2, -0.193206, 1, 0, 0.501625,-0.0163812)    );
  // itree = 946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321288,-0.0174803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165282,-0.0415988) , 
0, 0.408955, 1, 0, 0.297315,-0.0494155) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.836988,0.0139974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707741,-0.0153787) , 
1, 0.606027, 1, 0, 0.808448,0.0155017) , 
3, 0.660704, 1, 0, 0.467038,-0.0278596)    );
  // itree = 947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414419,0.0537602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683316,-9.88178e-05) , 
2, -0.499911, 1, 0, 0.612363,0.0280813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204732,-0.0214022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74319,0.0055699) , 
3, 0.301115, 1, 0, 0.433973,-0.0199384) , 
1, -0.237925, 1, 0, 0.508133,2.43617e-05)    );
  // itree = 948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315532,0.0410315) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108816,-0.0248889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634212,0.00383932) , 
3, -0.631772, 1, 0, 0.498157,-0.00470272) , 
0, -3.13202, 1, 0, 0.490351,-0.000454012)    );
  // itree = 949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198167,0.0258075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61589,-0.00189636) , 
3, -0.618856, 1, 0, 0.485996,0.00966408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538758,-0.0597413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906058,0.00932077) , 
3, 1.98407, 1, 0, 0.743197,-0.0729831) , 
2, 1.39629, 1, 0, 0.506714,0.0030068)    );
  // itree = 950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343716,0.0261778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493722,-0.0161799) , 
2, -0.482594, 1, 0, 0.428179,-9.39174e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.796788,0.0274329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808733,0.00449218) , 
2, 1.40764, 1, 0, 0.801153,0.0423734) , 
2, 0.499334, 1, 0, 0.550261,0.0138065)    );
  // itree = 951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527507,0.0411629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786302,0.00685448) , 
3, 0.23693, 1, 0, 0.658733,0.0504249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328152,-0.016721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786307,-0.00175072) , 
3, 0.705745, 1, 0, 0.471409,-0.0265926) , 
1, -1.69964, 1, 0, 0.481779,-0.0223287)    );
  // itree = 952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969852,-0.00791455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503803,0.0409023) , 
3, -1.14811, 1, 0, 0.286479,0.0389798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439083,-0.0257483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605828,-0.00302627) , 
1, -1.69964, 1, 0, 0.590276,-0.0122166) , 
2, -0.531879, 1, 0, 0.494082,0.00399418)    );
  // itree = 953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3669,0.043906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516806,-0.0129683) , 
0, -3.02048, 1, 0, 0.510196,-0.0236753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519078,0.0295732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788042,-0.0322458) , 
3, 1.6006, 1, 0, 0.561289,0.0409131) , 
1, 0.728565, 1, 0, 0.520791,-0.0102823)    );
  // itree = 954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322311,0.0320743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745944,0.0135985) , 
2, -0.543709, 1, 0, 0.645017,0.0367235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293274,-0.0193842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70772,0.00829694) , 
2, 0.161708, 1, 0, 0.445622,-0.0188054) , 
1, -0.962158, 1, 0, 0.484622,-0.0079442)    );
  // itree = 955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485823,0.00648371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372791,-0.0162116) , 
1, -0.922171, 1, 0, 0.39542,-0.0255282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.690733,0.0121629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543351,-0.0359458) , 
1, 1.4007, 1, 0, 0.673881,0.0151195) , 
0, 0.510979, 1, 0, 0.50686,-0.00926093)    );
  // itree = 956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566042,-0.0249772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517106,-0.002442) , 
1, -1.49759, 1, 0, 0.522906,-0.0116386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211232,-5.26546e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.877682,0.0806618) , 
3, -0.495786, 1, 0, 0.58062,0.116876) , 
1, 1.45051, 1, 0, 0.526574,-0.00347111)    );
  // itree = 957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113676,-0.00505593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308864,-0.0429869) , 
3, -0.970276, 1, 0, 0.180937,-0.047777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522342,0.0514008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654012,0.00276798) , 
2, -0.424982, 1, 0, 0.63963,0.0164963) , 
2, -0.662058, 1, 0, 0.503231,-0.00261638)    );
  // itree = 958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49034,-0.026429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.933021,0.0395024) , 
3, 1.52692, 1, 0, 0.554313,-0.0521218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335027,0.0227671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604867,-0.0042847) , 
2, -0.262479, 1, 0, 0.499736,0.0116924) , 
1, -1.07071, 1, 0, 0.510614,-0.00102682)    );
  // itree = 959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533311,-0.0374016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541898,0.012542) , 
1, -1.62737, 1, 0, 0.541134,0.0139997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230935,-0.0449516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680841,-0.00380973) , 
2, -0.123382, 1, 0, 0.439089,-0.0608589) , 
1, 0.823393, 1, 0, 0.518553,-0.00256519)    );
  // itree = 960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.7906,0.0584094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50711,0.00197192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424892,-0.0115798) , 
1, 0.00542919, 1, 0, 0.467958,-0.00916766) , 
1, -2.03415, 1, 0, 0.476612,-0.00613032)    );
  // itree = 961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0491478,-0.0273631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45004,0.0701012) , 
3, -2.18227, 1, 0, 0.304119,0.0999917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51462,-0.00493915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660385,0.0514363) , 
1, 1.81888, 1, 0, 0.520545,-0.00541116) , 
0, -2.25278, 1, 0, 0.495565,0.00675482)    );
  // itree = 962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157703,0.00852458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461849,-0.0168475) , 
3, -0.858119, 1, 0, 0.375518,-0.0281237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818694,0.0249165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878983,0.00366315) , 
3, 1.52867, 1, 0, 0.853527,0.0283318) , 
3, 1.05097, 1, 0, 0.483369,-0.0153859)    );
  // itree = 963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25328,0.0185246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42982,-0.0126404) , 
2, -1.08619, 1, 0, 0.388888,-0.013644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.750357,0.0315826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698098,-0.000430419) , 
0, 0.709021, 1, 0, 0.711337,0.0202505) , 
2, 0.527744, 1, 0, 0.485155,-0.00352481)    );
  // itree = 964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44727,-0.0341734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447504,-0.00571954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.835859,0.0314648) , 
0, 2.41389, 1, 0, 0.476581,-0.00618294) , 
1, -1.84922, 1, 0, 0.474971,-0.0113951)    );
  // itree = 965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0814295,0.00715125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288308,0.0719335) , 
2, -1.59991, 1, 0, 0.161815,0.0618115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373044,-0.0187408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708164,0.00568783) , 
2, 0.193138, 1, 0, 0.536362,-0.0148746) , 
3, -1.67932, 1, 0, 0.505973,-0.00865253)    );
  // itree = 966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129364,-0.0155387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673191,0.00875635) , 
3, -0.68846, 1, 0, 0.522123,0.00636162) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280556,-0.0806007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392573,-0.0165203) , 
1, 1.70786, 1, 0, 0.35886,-0.0646579) , 
1, 1.46055, 1, 0, 0.507262,-0.000102807)    );
  // itree = 967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423021,0.0300804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586465,-0.0136224) , 
0, -1.40168, 1, 0, 0.556369,-0.0111489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516967,0.0268217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459311,0.00314401) , 
1, 0.104784, 1, 0, 0.476543,0.0212718) , 
1, -0.454965, 1, 0, 0.505995,0.00931023)    );
  // itree = 968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355183,0.0243939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288653,-0.0205134) , 
0, -3.22882, 1, 0, 0.295429,-0.0296605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.581062,0.0300494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620817,-0.0070544) , 
0, -0.0809518, 1, 0, 0.6112,0.00414378) , 
0, -0.834952, 1, 0, 0.502642,-0.00747769)    );
  // itree = 969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358723,-0.044988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447233,-0.00179225) , 
1, -1.67376, 1, 0, 0.442222,-0.0108405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.819882,0.0691725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86768,-0.00172968) , 
3, 1.61028, 1, 0, 0.849061,0.0711087) , 
2, 0.983945, 1, 0, 0.493689,-0.00047365)    );
  // itree = 970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270705,-0.0194098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73462,-0.000454594) , 
3, 0.0923834, 1, 0, 0.502995,-0.0253356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469643,0.0208344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559521,-0.0305326) , 
0, 1.78651, 1, 0, 0.482755,0.0257773) , 
1, 0.107402, 1, 0, 0.49443,-0.00370634)    );
  // itree = 971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221889,-0.0300553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265485,0.0191633) , 
1, 0.53526, 1, 0, 0.231389,-0.0508184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59217,0.010604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646028,-0.00652411) , 
0, 0.205752, 1, 0, 0.627018,-0.00147266) , 
2, -0.499911, 1, 0, 0.476276,-0.0202744)    );
  // itree = 972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102197,-0.0485992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430644,0.0386008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525784,-0.00392643) , 
0, -1.71004, 1, 0, 0.513908,0.00186298) , 
0, -3.11877, 1, 0, 0.493334,-0.00383277)    );
  // itree = 973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11881,-0.021913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585752,0.0117185) , 
2, -1.30857, 1, 0, 0.522035,0.0170844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467901,-0.0504451) , 
1, 1.98002, 1, 0, 0.519989,0.0115404)    );
  // itree = 974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174982,-0.0482098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178636,-0.00393584) , 
1, 0.515345, 1, 0, 0.176183,-0.0828425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354218,0.0337196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608015,-0.00696307) , 
2, -0.506127, 1, 0, 0.534227,0.00683292) , 
0, -2.75342, 1, 0, 0.504263,-0.0006719)    );
  // itree = 975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56679,-0.0117382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504507,0.0108873) , 
1, -0.40121, 1, 0, 0.532186,0.00190974) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315734,-0.0269866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842143,0.0233418) , 
3, 1.16338, 1, 0, 0.442051,-0.0380707) , 
1, 0.823393, 1, 0, 0.511024,-0.00747701)    );
  // itree = 976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142069,0.00882089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383751,0.0686926) , 
2, -1.28809, 1, 0, 0.194591,0.0392222) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426336,-0.0345368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550918,-0.00390421) , 
1, -2.00084, 1, 0, 0.544459,-0.012927) , 
2, -1.09958, 1, 0, 0.483917,-0.00390303)    );
  // itree = 977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213118,-0.00206731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493395,-0.0369529) , 
3, -0.233084, 1, 0, 0.299678,-0.0319898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598833,0.0259259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805297,-0.0133089) , 
3, 0.9738, 1, 0, 0.7059,0.0167332) , 
2, 0.0724854, 1, 0, 0.480057,-0.0103547)    );
  // itree = 978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254305,0.0992381) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136829,-0.0445071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529991,-0.00143237) , 
0, -3.11663, 1, 0, 0.514589,-0.00714865) , 
2, -1.99878, 1, 0, 0.507128,-0.00280772)    );
  // itree = 979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126876,0.0105951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188339,-0.0318731) , 
3, -1.64043, 1, 0, 0.160371,-0.0363959) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569427,0.033598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628466,0.0050132) , 
0, -0.13078, 1, 0, 0.607043,0.032653) , 
2, -1.16796, 1, 0, 0.532577,0.0211417)    );
  // itree = 980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461582,0.0236195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379417,-0.00215764) , 
1, 0.821661, 1, 0, 0.437254,0.0309777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.829368,0.0529015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600092,-0.0134937) , 
1, -1.36371, 1, 0, 0.624385,-0.0169707) , 
2, 0.291111, 1, 0, 0.517291,0.0104699)    );
  // itree = 981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335659,0.0567343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0463018,-0.0308265) , 
1, 0.0325634, 1, 0, 0.183095,0.0322064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128769,-0.0290004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689193,0.000103177) , 
3, -0.38936, 1, 0, 0.509427,-0.0168948) , 
2, -1.61118, 1, 0, 0.483373,-0.0129746)    );
  // itree = 982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171,-0.0151741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419702,-0.0290321) , 
3, -0.626585, 1, 0, 0.222065,-0.0455869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458498,0.011317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748875,-0.0110459) , 
3, 0.608044, 1, 0, 0.596839,0.00300617) , 
2, -0.724736, 1, 0, 0.489729,-0.0108817)    );
  // itree = 983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504006,0.0104319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223485,-0.0251502) , 
1, -0.359182, 1, 0, 0.320361,-0.0294072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506566,0.0250707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777612,-0.0052373) , 
3, 0.752996, 1, 0, 0.670611,0.0177137) , 
0, -0.422556, 1, 0, 0.52842,-0.00141599)    );
  // itree = 984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115874,-0.0345382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151052,-0.0024988) , 
0, -2.84131, 1, 0, 0.128327,-0.0540586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341026,0.0182804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744399,-0.00654451) , 
3, 0.340923, 1, 0, 0.533564,0.0119282) , 
0, -2.27176, 1, 0, 0.493278,0.00536833)    );
  // itree = 985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10444,-0.0713723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556914,-0.010146) , 
0, -1.42762, 1, 0, 0.415671,-0.095003) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287234,0.0113515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576332,-0.0079174) , 
0, -0.808587, 1, 0, 0.483863,-0.00530715) , 
1, -1.49648, 1, 0, 0.476273,-0.0152908)    );
  // itree = 986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266039,0.0175456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155287,-0.043699) , 
0, -1.3161, 1, 0, 0.213526,-0.0310769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.564586,0.0230793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77328,0.00203346) , 
3, 0.758831, 1, 0, 0.673673,0.029964) , 
2, -0.435163, 1, 0, 0.495652,0.00634857)    );
  // itree = 987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208685,-0.0484581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607227,-0.00851686) , 
2, -0.0748332, 1, 0, 0.426305,-0.0737713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53037,0.00585809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430967,-0.0148043) , 
1, 0.498679, 1, 0, 0.497238,-0.00199146) , 
1, -1.6752, 1, 0, 0.492599,-0.00668629)    );
  // itree = 988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352045,-0.000173994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539171,-0.0296867) , 
2, 0.11187, 1, 0, 0.417797,-0.0239251) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.679638,0.0687533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.859251,0.00899477) , 
3, 1.16246, 1, 0, 0.825453,0.0498726) , 
2, 0.983945, 1, 0, 0.490163,-0.0108246)    );
  // itree = 989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578036,0.0121885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450471,-0.00568311) , 
1, -0.758551, 1, 0, 0.492976,0.000335278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334233,-0.0447759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668061,0.01487) , 
1, 1.45459, 1, 0, 0.436738,-0.0730767) , 
1, 0.973008, 1, 0, 0.484672,-0.0105054)    );
  // itree = 990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0966589,-0.0401046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1633,0.0240669) , 
1, 0.592363, 1, 0, 0.121438,-0.0396995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464873,0.0245748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620101,0.00117828) , 
0, -0.081912, 1, 0, 0.552039,0.0228883) , 
0, -2.95782, 1, 0, 0.520169,0.0182561)    );
  // itree = 991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150143,0.0265202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570635,-0.00200233) , 
3, -1.48116, 1, 0, 0.526811,6.89073e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.55757,-0.0465168) , 
0, 3.19023, 1, 0, 0.527759,-0.00338022)    );
  // itree = 992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323621,-0.0137097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596095,0.0068116) , 
0, -0.365377, 1, 0, 0.463432,-0.00575199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82755,0.0440434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.921202,0.0186542) , 
3, 2.10319, 1, 0, 0.877565,0.0723665) , 
2, 1.50355, 1, 0, 0.496625,0.000509254)    );
  // itree = 993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335435,-0.00419952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211217,-0.0310578) , 
1, 0.22994, 1, 0, 0.272772,-0.0351585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.639251,-0.0172012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650121,0.0151152) , 
1, -1.12811, 1, 0, 0.648636,0.0243868) , 
0, -0.516993, 1, 0, 0.473539,-0.00335251)    );
  // itree = 994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264264,-0.0486915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365176,0.0231176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59367,-0.0104997) , 
0, -0.947009, 1, 0, 0.518174,-0.000182893) , 
1, -1.86485, 1, 0, 0.503543,-0.00881359)    );
  // itree = 995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.894413,0.0672684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569998,-0.0145184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479118,0.010322) , 
1, -0.759027, 1, 0, 0.499536,0.00920444) , 
1, -2.03415, 1, 0, 0.51044,0.0137986)    );
  // itree = 996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238889,0.0130783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0753694,-0.0317438) , 
0, -2.20845, 1, 0, 0.127098,-0.0242641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44465,0.0340474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684621,0.00103106) , 
3, -0.274025, 1, 0, 0.643624,0.0153316) , 
3, -0.756041, 1, 0, 0.495499,0.00397667)    );
  // itree = 997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436153,0.00520338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239534,-0.0378313) , 
1, 0.0302751, 1, 0, 0.338522,-0.0299366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555961,0.0281988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627065,-5.54111e-05) , 
0, -0.037685, 1, 0, 0.608998,0.0123076) , 
0, -0.773058, 1, 0, 0.517094,-0.00204635)    );
  // itree = 998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315623,0.0057567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456408,-0.0259718) , 
0, -1.06204, 1, 0, 0.397331,-0.0307335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55853,0.0393235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868312,0.0012887) , 
3, 1.41879, 1, 0, 0.727077,0.0468394) , 
0, 0.861216, 1, 0, 0.49719,-0.00724178)    );
  // itree = 999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235256,-0.00394515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343684,-0.0506932) , 
2, -0.630664, 1, 0, 0.254492,-0.0262875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456291,-0.0133796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691967,0.0142682) , 
0, -0.392121, 1, 0, 0.63326,0.0180037) , 
2, -0.4092, 1, 0, 0.489385,0.00117969)    );
  // itree = 1000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117175,-0.0524811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594771,-0.017518) , 
0, -1.03691, 1, 0, 0.407945,-0.0711173) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179419,0.0184021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58316,-0.00643408) , 
3, -0.78639, 1, 0, 0.496757,-0.0046562) , 
1, -1.03815, 1, 0, 0.478331,-0.0184447)    );
  // itree = 1001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155942,-0.00570367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234577,-0.0612599) , 
2, -1.23184, 1, 0, 0.173738,-0.0462573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540445,0.00779967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682277,-0.0157586) , 
0, 1.65283, 1, 0, 0.569275,0.00600955) , 
2, -1.0475, 1, 0, 0.484283,-0.00522141)    );
  // itree = 1002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419235,0.0669302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181895,-0.0147453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.70821,0.00411989) , 
3, -0.31239, 1, 0, 0.528218,-0.00476313) , 
0, -3.13399, 1, 0, 0.524002,0.0012486)    );
  // itree = 1003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285943,0.0517313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503217,-0.0209851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485285,0.000618832) , 
1, -0.00567017, 1, 0, 0.494473,-0.0216763) , 
0, -3.07982, 1, 0, 0.485308,-0.0160422)    );
  // itree = 1004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.06281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577298,0.0140961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466503,-0.00647826) , 
1, 0.65094, 1, 0, 0.547136,0.0176987) , 
3, -2.17687, 1, 0, 0.53035,0.0142348)    );
  // itree = 1005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188973,-0.0018071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833913,0.0581607) , 
3, -1.088, 1, 0, 0.664923,0.0920022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486452,-0.00263701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515909,0.0419997) , 
1, 1.49476, 1, 0, 0.488847,0.00186085) , 
1, -1.15254, 1, 0, 0.512608,0.0140253)    );
  // itree = 1006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0506585,-0.0496545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857538,-0.012247) , 
2, -1.87544, 1, 0, 0.0761606,-0.0411918) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576017,0.0388235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646148,-0.00249996) , 
0, -0.315598, 1, 0, 0.623171,0.022312) , 
3, -1.36487, 1, 0, 0.538577,0.0124913)    );
  // itree = 1007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113564,-0.00977205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459743,-0.0420365) , 
3, -0.830012, 1, 0, 0.286332,-0.0606095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.679968,0.0196131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647231,-0.01662) , 
0, 1.52497, 1, 0, 0.667751,0.00942632) , 
0, -0.218015, 1, 0, 0.470562,-0.0267815)    );
  // itree = 1008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0346501,-0.0608625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164831,-0.0281838) , 
1, -1.27102, 1, 0, 0.136368,-0.0918877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307249,-0.0141789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632961,0.0134068) , 
0, -0.909392, 1, 0, 0.545819,0.0128066) , 
0, -2.23892, 1, 0, 0.49407,-0.000425297)    );
  // itree = 1009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554845,-0.000827095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515929,-0.0330203) , 
1, -0.857375, 1, 0, 0.545009,-0.0210458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621099,0.0371737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480749,0.00432924) , 
1, -0.387772, 1, 0, 0.490032,0.0153568) , 
1, -0.55327, 1, 0, 0.506799,0.00425496)    );
  // itree = 1010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.079329,-0.0113197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580828,0.033737) , 
3, -1.14868, 1, 0, 0.326977,0.0251593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491532,-0.0206667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747129,0.0127331) , 
0, 1.24285, 1, 0, 0.577196,-0.0232063) , 
0, -0.91774, 1, 0, 0.494546,-0.00723058)    );
  // itree = 1011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158081,-0.00371691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535471,0.0520478) , 
3, -0.800254, 1, 0, 0.25198,0.0303395) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573001,-0.0318082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726376,-0.00326178) , 
0, -0.501079, 1, 0, 0.696328,-0.0232317) , 
3, -0.317226, 1, 0, 0.536504,-0.00396304)    );
  // itree = 1012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619346,0.0105223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458546,-0.00852551) , 
1, -0.613532, 1, 0, 0.50975,-0.00529628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671858,0.0971396) , 
1, 2.10224, 1, 0, 0.514544,0.00209036)    );
  // itree = 1013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356173,0.0288976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165773,0.00121865) , 
1, -0.0173103, 1, 0, 0.250488,0.0306052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320319,-0.0314604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750361,-0.00527655) , 
3, -0.0127275, 1, 0, 0.689293,-0.0216464) , 
3, -0.25059, 1, 0, 0.51099,-0.000414645)    );
  // itree = 1014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427136,-0.00304225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662276,-0.030276) , 
0, 1.14771, 1, 0, 0.486501,-0.0217681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763899,0.0733069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333505,-0.00158312) , 
1, 2.09954, 1, 0, 0.537893,0.0799571) , 
1, 1.41092, 1, 0, 0.490581,-0.0136923)    );
  // itree = 1015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455886,-0.0141493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443202,0.0107896) , 
1, 0.65094, 1, 0, 0.452322,-0.0164477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.842732,0.0291496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67053,-0.00586657) , 
1, 0.173286, 1, 0, 0.781468,0.0388032) , 
0, 2.03714, 1, 0, 0.493457,-0.00954274)    );
  // itree = 1016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449906,0.00146312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793996,0.0214838) , 
0, 2.08472, 1, 0, 0.488613,0.00852562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206891,-0.0518002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.84459,0.0363002) , 
3, 0.267493, 1, 0, 0.491953,-0.0688728) , 
1, 1.41092, 1, 0, 0.488894,0.00201492)    );
  // itree = 1017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.70129,0.0780715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726617,0.0196058) , 
0, 0.0483964, 1, 0, 0.715204,0.11163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303695,-0.0192042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674041,0.00756739) , 
0, -0.188369, 1, 0, 0.498566,-0.0104484) , 
1, -1.65895, 1, 0, 0.511006,-0.0034379)    );
  // itree = 1018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202317,-0.00463949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725784,0.01211) , 
3, -0.260696, 1, 0, 0.525418,0.0126496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430572,-0.0410247) , 
1, 1.75209, 1, 0, 0.521091,0.00852793)    );
  // itree = 1019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171185,0.0069172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.807602,0.0458702) , 
3, -0.319266, 1, 0, 0.295519,0.0294171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525997,-0.0198554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773436,0.0112879) , 
0, 1.58938, 1, 0, 0.599272,-0.0230628) , 
2, -0.319334, 1, 0, 0.482282,-0.00285024)    );
  // itree = 1020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365463,0.00371581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574182,-0.0218526) , 
0, -0.936282, 1, 0, 0.515845,-0.0314141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145403,-0.0236196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524279,0.0073105) , 
0, -1.55531, 1, 0, 0.436443,0.00396106) , 
1, -0.3195, 1, 0, 0.468993,-0.0105407)    );
  // itree = 1021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476743,-0.0361041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515455,0.00741817) , 
1, -1.61487, 1, 0, 0.511257,0.00650551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363781,-0.0437044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434207,-0.0157705) , 
1, 0.553299, 1, 0, 0.418455,-0.0547568) , 
1, 0.414129, 1, 0, 0.480563,-0.0137567)    );
  // itree = 1022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210558,-0.0434571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725267,0.0123788) , 
2, -0.224522, 1, 0, 0.50318,-0.0345288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373533,0.0153867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605826,-0.00782244) , 
0, 0.0848771, 1, 0, 0.484298,0.00675277) , 
1, -0.786741, 1, 0, 0.489744,-0.0051522)    );
  // itree = 1023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377358,0.0619777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476735,-0.0253785) , 
2, -1.51468, 1, 0, 0.470807,-0.0465371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497574,0.0217184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682863,-0.00564551) , 
0, 1.63755, 1, 0, 0.532188,0.0326122) , 
1, -0.11939, 1, 0, 0.500566,-0.00816421)    );
  // itree = 1024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313368,-0.0185717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393028,0.0215924) , 
1, -1.00268, 1, 0, 0.377211,0.0233935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553007,-0.0277014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732445,0.00316609) , 
0, 0.876496, 1, 0, 0.650514,-0.0293775) , 
2, 0.171595, 1, 0, 0.507323,-0.00172928)    );
  // itree = 1025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0678689,-0.0122583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619052,0.0129995) , 
3, -1.33284, 1, 0, 0.54431,0.0245577) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151717,-0.0297591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77907,0.0131595) , 
3, 0.209828, 1, 0, 0.369333,-0.0294012) , 
1, 0.906291, 1, 0, 0.504774,0.0123657)    );
  // itree = 1026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289929,0.010651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338416,0.06491) , 
1, 1.02486, 1, 0, 0.298173,0.0355106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37377,-0.0316259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624719,-0.00591379) , 
2, 0.0808768, 1, 0, 0.531097,-0.0371008) , 
0, -1.525, 1, 0, 0.487266,-0.023437)    );
  // itree = 1027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336218,-0.00872734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177553,-0.0405749) , 
1, 1.36625, 1, 0, 0.317012,-0.0250247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453102,-0.0245111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688589,0.0047079) , 
0, -0.410736, 1, 0, 0.658623,0.00138546) , 
2, 0.161708, 1, 0, 0.469642,-0.0132248)    );
  // itree = 1028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122246,-0.0386247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445776,0.0123906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699173,-0.00831369) , 
2, 0.752494, 1, 0, 0.509309,0.0142919) , 
0, -3.02048, 1, 0, 0.493556,0.00940232)    );
  // itree = 1029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331164,0.00286831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26748,-0.0257785) , 
0, -0.917206, 1, 0, 0.3014,-0.0273488) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.928333,0.0280264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728561,-0.00499701) , 
0, 0.761347, 1, 0, 0.793646,0.00901559) , 
3, 0.392653, 1, 0, 0.512854,-0.0117278)    );
  // itree = 1030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279891,0.053958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555508,0.0062518) , 
0, -2.84106, 1, 0, 0.536839,0.0183775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288324,-0.048661) , 
1, 2.01701, 1, 0, 0.528526,0.01357)    );
  // itree = 1031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224973,-0.0361551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122824,-0.0153582) , 
1, -0.80077, 1, 0, 0.146742,-0.0426532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.905728,0.0753631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659204,0.00592209) , 
0, -1.29019, 1, 0, 0.672247,0.0218643) , 
3, -0.711955, 1, 0, 0.532043,0.00465117)    );
  // itree = 1032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365851,-0.00440968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.93015,0.0471844) , 
3, 1.12137, 1, 0, 0.421542,-0.00172999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562714,-0.0433871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.908034,0.00628935) , 
3, 2.1654, 1, 0, 0.654401,-0.0699931) , 
2, 0.999858, 1, 0, 0.456281,-0.0119139)    );
  // itree = 1033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414691,0.103136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31048,0.00428454) , 
1, -1.58142, 1, 0, 0.316482,0.0162001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323505,-0.0256245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83516,0.00119878) , 
3, 0.793647, 1, 0, 0.597039,-0.028408) , 
2, -0.0837542, 1, 0, 0.466559,-0.00766191)    );
  // itree = 1034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106453,-0.0336172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566804,0.0109272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464637,-0.00930317) , 
1, 0.662387, 1, 0, 0.54183,0.0112199) , 
0, -3.18592, 1, 0, 0.525426,0.00768719)    );
  // itree = 1035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230703,-0.00989109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232833,-0.0914197) , 
0, -2.01807, 1, 0, 0.231322,-0.08515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.687031,0.0176279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5231,-0.0163705) , 
1, -0.39136, 1, 0, 0.584072,-0.00932608) , 
0, -1.6888, 1, 0, 0.515882,-0.0239836)    );
  // itree = 1036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40947,-0.000430467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651009,-0.0226127) , 
0, 1.14354, 1, 0, 0.474621,-0.0134476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383845,0.0495942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673972,0.00841899) , 
0, -0.243535, 1, 0, 0.539235,0.0476278) , 
1, 0.728565, 1, 0, 0.488972,0.000117757)    );
  // itree = 1037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507263,0.00331381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417356,-0.0558141) , 
1, -1.73773, 1, 0, 0.453926,-0.0750531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453596,0.000243694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396832,-0.0746935) , 
1, 1.6877, 1, 0, 0.450756,-0.00730392) , 
1, -1.20134, 1, 0, 0.451216,-0.0171374)    );
  // itree = 1038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.592641,-0.0176499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562731,0.0197651) , 
1, -1.27385, 1, 0, 0.571646,0.0162962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386482,-0.0249943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449284,0.00505655) , 
1, 0.600671, 1, 0, 0.410705,-0.0293812) , 
1, -0.294962, 1, 0, 0.477326,-0.0104731)    );
  // itree = 1039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181343,0.0144838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540488,-0.0151399) , 
3, -0.86861, 1, 0, 0.442381,-0.0181672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.60895,0.0377471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880339,0.0094849) , 
3, 1.59623, 1, 0, 0.775194,0.0535733) , 
0, 1.61764, 1, 0, 0.49902,-0.00595819)    );
  // itree = 1040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391979,0.0461211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124789,0.0252037) , 
1, -0.259045, 1, 0, 0.228731,0.0684202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36242,-0.0148373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645548,0.0111481) , 
0, -0.742382, 1, 0, 0.558765,0.00685632) , 
2, -1.61118, 1, 0, 0.532233,0.0118055)    );
  // itree = 1041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458626,0.0827071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745062,0.0304112) , 
2, 0.172994, 1, 0, 0.613658,0.0960379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0694713,-0.0475288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51373,0.000910894) , 
2, -1.97463, 1, 0, 0.493624,-0.00277329) , 
1, -1.6752, 1, 0, 0.500394,0.00279997)    );
  // itree = 1042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28991,0.0545386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176302,-0.0449179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53228,0.00581832) , 
0, -2.08403, 1, 0, 0.499039,0.00453712) , 
0, -3.04301, 1, 0, 0.490495,0.00901521)    );
  // itree = 1043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388651,0.0624824) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181509,-0.0169222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736057,0.00468811) , 
3, -0.227594, 1, 0, 0.503958,-0.00858676) , 
0, -3.02048, 1, 0, 0.498226,-0.000597209)    );
  // itree = 1044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165873,-0.00856628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184934,-0.0383279) , 
0, -3.61558, 1, 0, 0.176807,-0.0594743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433546,0.0143918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68294,0.000679785) , 
2, 0.293409, 1, 0, 0.539897,0.0174536) , 
0, -3.02048, 1, 0, 0.518265,0.0128704)    );
  // itree = 1045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204215,-0.00120897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915868,0.060192) , 
3, -0.161607, 1, 0, 0.315269,0.015126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234297,-0.0302285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.772012,-0.00169175) , 
3, 0.494478, 1, 0, 0.64102,-0.0250075) , 
0, -0.106773, 1, 0, 0.474601,-0.00450423)    );
  // itree = 1046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436124,0.0622671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676173,0.0174795) , 
2, -0.598432, 1, 0, 0.626184,0.0532622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235644,-0.00944183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748684,0.0102106) , 
3, 0.180631, 1, 0, 0.476164,-0.000527675) , 
1, -0.921358, 1, 0, 0.508055,0.0109066)    );
  // itree = 1047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.814052,0.0852416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301792,0.0148707) , 
1, -1.29665, 1, 0, 0.351777,0.0458517) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735145,-0.00686558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520703,-0.0625458) , 
1, 1.45301, 1, 0, 0.718701,-0.0235443) , 
3, 0.17816, 1, 0, 0.525581,0.0129803)    );
  // itree = 1048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272667,0.0360781) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.602865,0.0108942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436891,-0.00988759) , 
1, -0.49856, 1, 0, 0.491431,-0.00698143) , 
0, -3.61701, 1, 0, 0.485452,-0.00431803)    );
  // itree = 1049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281664,-0.00793885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253044,-0.0416499) , 
2, 0.397686, 1, 0, 0.278315,-0.0264586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.882753,0.03427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737066,-0.0016817) , 
2, 0.301504, 1, 0, 0.775209,0.0136184) , 
3, 0.306962, 1, 0, 0.502174,-0.0084033)    );
  // itree = 1050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0663349,-0.0240356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513531,0.0157101) , 
3, -1.54234, 1, 0, 0.412427,0.0173839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316108,-0.0315572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778584,0.000728192) , 
3, 0.457762, 1, 0, 0.642492,-0.0221611) , 
2, 0.161708, 1, 0, 0.519237,-0.000975423)    );
  // itree = 1051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.793714,0.0607869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745927,0.027421) , 
1, -1.94548, 1, 0, 0.769079,0.0821502) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351014,-0.0405884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.499606,-0.00416568) , 
1, -1.0212, 1, 0, 0.479706,-0.0189192) , 
1, -1.55627, 1, 0, 0.495659,-0.0133473)    );
  // itree = 1052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536487,0.0353924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338377,-0.0092392) , 
1, -1.18696, 1, 0, 0.3621,-0.00728158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.713813,0.0279156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68243,0.00246747) , 
0, 1.08454, 1, 0, 0.69528,0.0271266) , 
0, 0.0848771, 1, 0, 0.517981,0.00881656)    );
  // itree = 1053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136054,0.0206398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558,-0.0401864) , 
3, -1.1241, 1, 0, 0.495302,-0.0812265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.863995,0.0518816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471195,-0.000146262) , 
1, -0.665868, 1, 0, 0.494489,0.00486453) , 
1, -0.876513, 1, 0, 0.494644,-0.0115599)    );
  // itree = 1054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245988,-0.0413445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.532247,-0.0141542) , 
0, -1.55104, 1, 0, 0.478515,-0.0430489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468612,0.00819877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171077,-0.0527134) , 
1, 2.10335, 1, 0, 0.43992,0.00220208) , 
1, 0.345387, 1, 0, 0.465499,-0.0277877)    );
  // itree = 1055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0284577,-0.0469291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23888,0.0345678) , 
3, -1.71332, 1, 0, 0.178789,0.0210651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526986,-0.020175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732742,0.0157893) , 
0, 1.86563, 1, 0, 0.568886,-0.0295914) , 
3, -0.786928, 1, 0, 0.472564,-0.0170834)    );
  // itree = 1056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298176,0.058675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226652,-0.0256141) , 
0, -3.38812, 1, 0, 0.233734,-0.0341153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553764,0.0161861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650883,-0.020999) , 
0, 1.73188, 1, 0, 0.573049,0.0180975) , 
0, -0.947009, 1, 0, 0.441531,-0.00214005)    );
  // itree = 1057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273979,-0.0621457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574513,-0.0152196) , 
2, 0.228442, 1, 0, 0.424356,-0.125298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524005,0.00286914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348916,-0.0313147) , 
1, 1.31591, 1, 0, 0.50163,-0.00507128) , 
1, -1.6752, 1, 0, 0.495811,-0.0141245)    );
  // itree = 1058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248868,0.000444815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487661,-0.0444133) , 
3, -0.0253377, 1, 0, 0.295459,-0.0220212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.609752,0.0293532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649873,0.00474086) , 
0, -0.315598, 1, 0, 0.642464,0.019492) , 
2, -0.271157, 1, 0, 0.504334,0.00296705)    );
  // itree = 1059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389045,-0.0404997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445083,-0.0055313) , 
1, -1.71379, 1, 0, 0.441719,-0.0170734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.821802,-0.00848554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834999,0.05027) , 
0, 2.45702, 1, 0, 0.828165,0.0620527) , 
2, 1.43963, 1, 0, 0.473067,-0.0106547)    );
  // itree = 1060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0348294,-0.0385379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302846,0.0359949) , 
3, -2.19231, 1, 0, 0.262454,0.0508038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34483,-0.0655046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582667,-0.00670196) , 
1, -1.82258, 1, 0, 0.569039,-0.0235863) , 
2, -0.914603, 1, 0, 0.507537,-0.0086634)    );
  // itree = 1061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355521,-0.0266317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383869,0.0215506) , 
1, 1.12171, 1, 0, 0.359652,-0.0408411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.739937,0.0283476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66562,-0.0182317) , 
0, 1.48583, 1, 0, 0.704635,0.0124255) , 
2, 0.380334, 1, 0, 0.479277,-0.0223705)    );
  // itree = 1062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0434463,-0.0272424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123215,-0.0430341) , 
3, -2.04009, 1, 0, 0.0989837,-0.07297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242353,0.00523824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641657,-0.00897704) , 
3, -0.200857, 1, 0, 0.510334,-0.0100631) , 
2, -1.2517, 1, 0, 0.45124,-0.0191002)    );
  // itree = 1063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0795735,-0.0399469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186413,0.0420123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620896,-0.000667877) , 
3, -0.749772, 1, 0, 0.51838,0.0119475) , 
0, -3.23159, 1, 0, 0.501714,0.00802862)    );
  // itree = 1064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179136,-0.0216485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759175,0.011968) , 
3, -0.566199, 1, 0, 0.572475,0.00279755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280309,-0.0021691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562351,-0.0208667) , 
2, -0.452846, 1, 0, 0.455359,-0.0299033) , 
1, -0.863434, 1, 0, 0.482645,-0.0222847)    );
  // itree = 1065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119137,0.00301136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728972,0.0849007) , 
3, -0.952939, 1, 0, 0.269365,0.0504378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350597,-0.0284385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670576,0.00395692) , 
2, -0.120947, 1, 0, 0.576496,-0.0126318) , 
2, -0.833719, 1, 0, 0.511335,0.000749221)    );
  // itree = 1066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139273,0.023788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385513,-0.0202662) , 
3, -1.14811, 1, 0, 0.297769,-0.0219944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.728186,0.0886906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658726,0.00538392) , 
2, 0.0160044, 1, 0, 0.665709,0.0257123) , 
2, -0.193206, 1, 0, 0.515984,0.00629908)    );
  // itree = 1067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674219,0.0535712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483139,-0.0216379) , 
1, -2.04411, 1, 0, 0.501275,-0.0305364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56239,0.0283165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464491,-0.00661552) , 
1, 0.00772097, 1, 0, 0.498777,0.0117397) , 
1, -0.776333, 1, 0, 0.499489,-0.000308387)    );
  // itree = 1068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143481,-0.00395251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523641,-0.0205383) , 
3, -0.760104, 1, 0, 0.33933,-0.0282612) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579261,0.0167018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71946,-0.00717622) , 
0, 0.987476, 1, 0, 0.654475,0.00675208) , 
0, -0.00413718, 1, 0, 0.480249,-0.0126048)    );
  // itree = 1069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299018,0.0448027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142706,-0.0277958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557694,0.00271278) , 
2, -1.29464, 1, 0, 0.519452,0.000751409) , 
0, -3.00974, 1, 0, 0.510166,0.0051191)    );
  // itree = 1070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193278,-0.0142013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568292,0.0113702) , 
2, -1.29367, 1, 0, 0.519264,0.017955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20674,0.0493883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447312,-0.0225924) , 
2, -1.32408, 1, 0, 0.417278,-0.0365209) , 
1, 0.886404, 1, 0, 0.496111,0.00558792)    );
  // itree = 1071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476888,-0.0232035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533225,0.00994177) , 
1, -1.799, 1, 0, 0.529451,0.0152406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373333,-0.0391249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59977,-0.0106708) , 
1, 1.50496, 1, 0, 0.515148,-0.0537411) , 
1, 1.31099, 1, 0, 0.528076,0.00861122)    );
  // itree = 1072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522109,-0.00599853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470706,0.0199454) , 
1, -0.371918, 1, 0, 0.491051,0.0194676) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424677,-0.0512722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.894423,3.0655e-05) , 
3, 1.80814, 1, 0, 0.730723,-0.0514812) , 
0, 2.11278, 1, 0, 0.516751,0.0118597)    );
  // itree = 1073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697144,0.0543758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500874,-0.00649664) , 
1, -2.0297, 1, 0, 0.510791,-0.00599854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0840857,-0.0163926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684261,0.0293767) , 
3, -0.650755, 1, 0, 0.510169,0.0410532) , 
1, 0.0764505, 1, 0, 0.510502,0.0158456)    );
  // itree = 1074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0733559,-0.0440055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516109,-0.00251718) , 
0, -3.13399, 1, 0, 0.499365,-0.00931339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374379,0.00474452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811201,0.0461504) , 
0, 0.287897, 1, 0, 0.53642,0.0438135) , 
1, 0.71376, 1, 0, 0.508307,0.00350677)    );
  // itree = 1075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435672,-0.00505372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625654,-0.0208594) , 
0, 0.861216, 1, 0, 0.498692,-0.0232915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547881,0.0317111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493417,-0.0209557) , 
1, 1.47546, 1, 0, 0.532302,0.029772) , 
1, 0.599253, 1, 0, 0.507774,-0.00895322)    );
  // itree = 1076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119764,0.0230836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396545,-0.0211733) , 
3, -1.85214, 1, 0, 0.369835,-0.038839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621307,-0.0103335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681858,0.0171217) , 
1, -0.759733, 1, 0, 0.66487,0.0203088) , 
0, 0.510979, 1, 0, 0.487462,-0.0152574)    );
  // itree = 1077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0725404,-0.033318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426249,0.00816643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639511,-0.00850306) , 
0, 0.139157, 1, 0, 0.526344,0.000388894) , 
2, -1.97463, 1, 0, 0.501016,-0.00381023)    );
  // itree = 1078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248125,0.0174818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28497,-0.0201149) , 
0, -1.72473, 1, 0, 0.271202,-0.0170422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402954,0.0441547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724635,-0.000875081) , 
3, -0.11952, 1, 0, 0.670826,0.0114736) , 
2, -0.306322, 1, 0, 0.507337,-0.000192379)    );
  // itree = 1079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0937068,-0.0142876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523403,0.0327445) , 
3, -1.45918, 1, 0, 0.347815,0.0305869) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377045,-0.0228868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672291,-0.00149278) , 
2, 0.243157, 1, 0, 0.551787,-0.0209188) , 
0, -0.84483, 1, 0, 0.490008,-0.00531867)    );
  // itree = 1080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349521,-0.0142243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305829,0.00938158) , 
1, -0.375211, 1, 0, 0.324274,-0.00421423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647306,0.0215936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688469,-0.00152769) , 
2, 1.01866, 1, 0, 0.662028,0.0303253) , 
0, -0.188369, 1, 0, 0.479464,0.0116559)    );
  // itree = 1081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.653211,0.0282959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453523,-0.00855771) , 
1, -1.42795, 1, 0, 0.474957,-0.0089389) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482806,0.0392952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.722709,-0.00948485) , 
2, 0.707836, 1, 0, 0.558063,0.0508003) , 
1, 1.08213, 1, 0, 0.484497,-0.00208083)    );
  // itree = 1082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522802,0.00599873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423599,-0.0228548) , 
1, 0.395062, 1, 0, 0.500082,-0.000546046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496047,0.0477835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631535,-0.00216182) , 
2, 0.931674, 1, 0, 0.522908,0.0694461) , 
1, 1.08213, 1, 0, 0.503177,0.00894191)    );
  // itree = 1083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544793,0.00427916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611668,0.043849) , 
1, -0.255178, 1, 0, 0.555562,0.0221575) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341164,-0.058231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486419,-0.00152252) , 
1, 0.216375, 1, 0, 0.461199,-0.023314) , 
1, 0.0411464, 1, 0, 0.510061,0.000231484)    );
  // itree = 1084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156662,-0.0140991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.665065,0.0165797) , 
3, -1.56472, 1, 0, 0.593706,0.0224095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339842,-0.0441885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451435,0.000751988) , 
1, -0.239164, 1, 0, 0.429787,-0.019244) , 
1, -0.636138, 1, 0, 0.471918,-0.00853806)    );
  // itree = 1085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0629316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485653,0.00519165) , 
3, -2.20685, 1, 0, 0.461673,0.00631765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92745,0.054988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813235,0.0233015) , 
2, 1.12844, 1, 0, 0.842718,0.0813798) , 
0, 2.39256, 1, 0, 0.502935,0.0144458)    );
  // itree = 1086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103784,0.00547393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237509,-0.0211392) , 
3, -1.65126, 1, 0, 0.212088,-0.0378821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670474,0.0182107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690645,-0.00482647) , 
0, 1.19261, 1, 0, 0.678725,0.0191838) , 
2, -0.281514, 1, 0, 0.496616,-0.00308668)    );
  // itree = 1087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354612,0.0114394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247112,-0.0264388) , 
1, 0.0302751, 1, 0, 0.293841,-0.0222992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.698286,0.0196826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659842,-0.0145774) , 
0, 2.63941, 1, 0, 0.694514,0.0324722) , 
2, -0.281514, 1, 0, 0.514651,0.00788518)    );
  // itree = 1088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156468,0.0106626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596344,-0.0211345) , 
3, -0.786928, 1, 0, 0.482409,-0.0303264) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0252364,-0.0620548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605154,0.0248721) , 
0, -2.12659, 1, 0, 0.515425,0.0221695) , 
1, 0.71376, 1, 0, 0.490691,-0.0171589)    );
  // itree = 1089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152344,-0.0219459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368563,-0.039448) , 
2, -0.388128, 1, 0, 0.196398,-0.0525026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62019,0.0173186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624144,0.000853205) , 
1, -0.39136, 1, 0, 0.622503,0.0163551) , 
0, -0.960156, 1, 0, 0.480892,-0.00652899)    );
  // itree = 1090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108704,0.00336605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585414,0.0366936) , 
3, -1.0442, 1, 0, 0.327163,0.0420005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362477,-0.0268459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62019,0.00539146) , 
0, -0.0957886, 1, 0, 0.556609,-0.00720566) , 
0, -0.84483, 1, 0, 0.483113,0.00855606)    );
  // itree = 1091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241963,-0.0118147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292946,0.0276748) , 
1, -0.97244, 1, 0, 0.283231,0.0396997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511033,-0.0259675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.837407,0.0103473) , 
3, 0.802712, 1, 0, 0.711295,-0.013397) , 
3, 0.17816, 1, 0, 0.500847,0.0127068)    );
  // itree = 1092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.754783,0.0314839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59386,0.00302709) , 
1, -1.10819, 1, 0, 0.648043,0.0286503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385452,-0.00705483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567559,-0.0477081) , 
0, 1.63755, 1, 0, 0.409021,-0.0267327) , 
1, -0.294962, 1, 0, 0.503787,-0.00477489)    );
  // itree = 1093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0367554,-0.0546866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531558,0.0101474) , 
2, -1.97463, 1, 0, 0.514375,0.0175372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36758,-0.0296038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545764,0.0285198) , 
1, 1.43465, 1, 0, 0.4464,-0.0132366) , 
1, 0.883253, 1, 0, 0.499497,0.0108016)    );
  // itree = 1094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243639,0.0410501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330391,-0.0191386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.822715,0.00290793) , 
3, 0.900366, 1, 0, 0.461259,-0.029885) , 
0, -3.52378, 1, 0, 0.454643,-0.0262988)    );
  // itree = 1095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527963,0.0032068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413107,-0.0137198) , 
1, -0.235441, 1, 0, 0.477551,-0.00934386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496368,0.0960096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522313,0.0140869) , 
0, -2.27778, 1, 0, 0.518866,0.054745) , 
1, 0.65094, 1, 0, 0.486849,0.00507857)    );
  // itree = 1096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289095,-0.00147939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677979,0.0358373) , 
2, -0.18534, 1, 0, 0.38893,0.0180364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430636,-0.0257785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.893574,0.00888041) , 
3, 1.33534, 1, 0, 0.59142,-0.0380923) , 
0, -0.122417, 1, 0, 0.495036,-0.0113755)    );
  // itree = 1097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412186,0.0108952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620549,-0.0119922) , 
0, 0.236511, 1, 0, 0.505425,-0.000848296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694716,-0.0407271) , 
0, 3.50103, 1, 0, 0.510716,-0.00376906)    );
  // itree = 1098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319189,0.00825402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441892,0.0515488) , 
1, 0.950828, 1, 0, 0.338884,0.0331475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414028,-0.0475692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681231,0.000261829) , 
2, -0.0641594, 1, 0, 0.643963,-0.0156889) , 
2, -0.281514, 1, 0, 0.521992,0.00383602)    );
  // itree = 1099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267658,-0.0716783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220715,-0.0345988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541124,-0.00181871) , 
0, -1.48202, 1, 0, 0.476774,-0.0175488) , 
1, -1.87422, 1, 0, 0.465834,-0.0270966)    );
  // itree = 1100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517825,-0.0175977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51518,0.0150567) , 
1, -1.25091, 1, 0, 0.515513,0.023129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217932,-0.0560545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71575,0.0290626) , 
0, -0.200376, 1, 0, 0.38811,-0.0683714) , 
1, 1.17696, 1, 0, 0.500745,0.0125225)    );
  // itree = 1101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.499017,-0.00511961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563375,0.0578522) , 
1, 0.287353, 1, 0, 0.508137,0.0070608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323885,-0.0279889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796924,0.0123063) , 
2, 0.30786, 1, 0, 0.469847,-0.033043) , 
1, 0.71376, 1, 0, 0.499562,-0.00192047)    );
  // itree = 1102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0752635,-0.0422925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246951,0.0092351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648269,-0.0148436) , 
3, 0.00747524, 1, 0, 0.472496,-0.0111389) , 
0, -3.16923, 1, 0, 0.458021,-0.0148012)    );
  // itree = 1103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464271,0.00435891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416286,-0.0254269) , 
1, 0.963407, 1, 0, 0.456244,-0.00287997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.896762,0.0424988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823827,-0.00793827) , 
2, 1.94337, 1, 0, 0.87568,0.0639625) , 
2, 1.25294, 1, 0, 0.512942,0.00615555)    );
  // itree = 1104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273236,0.00237696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64597,0.0752317) , 
0, -1.50964, 1, 0, 0.398987,0.0510062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416287,-0.0312424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574242,-0.00757241) , 
0, 0.0548615, 1, 0, 0.531648,-0.0325187) , 
0, -0.691462, 1, 0, 0.48954,-0.00600718)    );
  // itree = 1105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860151,-0.00595898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58593,0.0268852) , 
3, -1.14811, 1, 0, 0.4558,0.0426398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64193,-0.0292568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780227,0.0147903) , 
1, 0.695492, 1, 0, 0.671386,-0.0403817) , 
2, 0.60567, 1, 0, 0.525836,0.0156692)    );
  // itree = 1106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27083,-0.0231243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.059554) , 
3, -0.0715217, 1, 0, 0.337087,-0.0396282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519214,-0.0038317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81191,0.0216498) , 
2, 0.693311, 1, 0, 0.635025,0.0117968) , 
0, -0.773058, 1, 0, 0.53443,-0.00556629)    );
  // itree = 1107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180887,0.0277862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588878,-0.00306762) , 
3, -0.88562, 1, 0, 0.494309,0.00438381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641824,-0.0463659) , 
0, 2.76471, 1, 0, 0.501544,-0.0017264)    );
  // itree = 1108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280101,0.00328639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664124,0.0332796) , 
2, -0.642226, 1, 0, 0.426769,0.0309334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486127,-0.0367575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734269,-0.000271907) , 
0, 0.592552, 1, 0, 0.649749,-0.0301636) , 
2, 0.110847, 1, 0, 0.536009,0.00100124)    );
  // itree = 1109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313233,0.0340753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558749,-0.00294078) , 
2, -0.831082, 1, 0, 0.505115,0.00907801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214081,-0.0378767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760978,0.0130889) , 
0, 0.0896581, 1, 0, 0.442618,-0.0356264) , 
1, 0.820442, 1, 0, 0.491083,-0.000958797)    );
  // itree = 1110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.877765,0.0536281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460722,-0.0115039) , 
1, -2.05413, 1, 0, 0.484389,-0.0191278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0749784,-0.02392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552256,0.0130367) , 
2, -1.5647, 1, 0, 0.479572,0.0164447) , 
1, 0.0687374, 1, 0, 0.482321,-0.00385736)    );
  // itree = 1111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454317,0.00237878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32486,-0.0289244) , 
1, -0.563226, 1, 0, 0.365269,-0.0399454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.896156,0.062332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.721939,0.0020025) , 
0, 0.717554, 1, 0, 0.756688,0.0263178) , 
2, 0.508272, 1, 0, 0.492363,-0.0184296)    );
  // itree = 1112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132098,-0.0270526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0802874,-0.0470811) , 
1, 0.319595, 1, 0, 0.113747,-0.0684291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346434,0.0341595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639376,0.00320698) , 
2, -0.528172, 1, 0, 0.570197,0.0200981) , 
0, -2.24414, 1, 0, 0.517411,0.0098602)    );
  // itree = 1113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527914,0.00575336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293232,-0.018109) , 
1, -0.670644, 1, 0, 0.35783,-0.0266755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.710558,0.0272999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622223,-0.0113874) , 
1, 0.313122, 1, 0, 0.683634,0.0318804) , 
0, 0.0848771, 1, 0, 0.50498,-0.00022856)    );
  // itree = 1114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582288,0.000602474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426311,-0.0254178) , 
1, -0.51576, 1, 0, 0.483962,-0.0329627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488205,0.0690073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779156,-0.0168166) , 
3, 0.623588, 1, 0, 0.614388,0.0676638) , 
1, 1.45051, 1, 0, 0.492964,-0.0260174)    );
  // itree = 1115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33104,0.00420134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75133,-0.0152832) , 
3, 0.428484, 1, 0, 0.482407,-0.00507535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.875632,0.0472915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752386,-0.016018) , 
2, 1.81544, 1, 0, 0.830296,0.0624015) , 
2, 1.4278, 1, 0, 0.512927,0.00084438)    );
  // itree = 1116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215684,0.0318883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794139,-0.0278168) , 
3, -0.864466, 1, 0, 0.318935,0.0302684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199176,-0.0158452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745321,0.0022887) , 
3, 0.0491022, 1, 0, 0.528909,-0.0100562) , 
0, -1.54198, 1, 0, 0.489274,-0.00244436)    );
  // itree = 1117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0987958,-0.0636807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608774,-0.0352672) , 
3, -0.305149, 1, 0, 0.428297,-0.103423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34617,-0.0094782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711886,0.0157237) , 
2, 0.425012, 1, 0, 0.462209,-0.000495076) , 
1, -1.42694, 1, 0, 0.458585,-0.0114933)    );
  // itree = 1118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113222,0.00820811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308947,-0.0291324) , 
3, -1.15658, 1, 0, 0.200818,-0.0308623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586275,0.0387329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625742,0.00363592) , 
2, -0.254888, 1, 0, 0.618665,0.0209271) , 
2, -0.73641, 1, 0, 0.497285,0.00588287)    );
  // itree = 1119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533168,0.0011472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548477,0.0349514) , 
1, 0.162859, 1, 0, 0.538071,0.0218486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24627,-0.0139811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633615,-0.059109) , 
3, 0.680986, 1, 0, 0.388927,-0.0683891) , 
1, 1.13159, 1, 0, 0.517608,0.00946773)    );
  // itree = 1120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22863,-0.0176635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683737,0.0132017) , 
2, -0.543709, 1, 0, 0.518336,0.00704759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164362,0.0132224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558369,-0.016742) , 
2, -0.696554, 1, 0, 0.442255,-0.0223036) , 
1, -0.0229864, 1, 0, 0.481484,-0.00716952)    );
  // itree = 1121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382415,0.0651527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166438,0.00843523) , 
0, -2.83144, 1, 0, 0.241775,0.0550158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546722,-0.00593974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647891,0.0125941) , 
1, 0.988758, 1, 0, 0.562981,-0.00587278) , 
2, -1.16796, 1, 0, 0.52225,0.00184823)    );
  // itree = 1122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440996,0.00826153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580068,-0.0141765) , 
0, 0.871014, 1, 0, 0.473041,0.00556035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763836,0.0395923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886276,0.00887441) , 
3, 1.77143, 1, 0, 0.821664,0.0572794) , 
2, 1.1699, 1, 0, 0.518498,0.0123039)    );
  // itree = 1123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258164,0.00995709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654492,-0.0463946) , 
1, 0.246493, 1, 0, 0.144005,-0.0306951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361051,0.032474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626945,0.00151394) , 
2, -0.593703, 1, 0, 0.587529,0.0113445) , 
2, -1.09958, 1, 0, 0.507661,0.00377425)    );
  // itree = 1124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562761,0.0186817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596058,-0.0363423) , 
2, 0.120802, 1, 0, 0.583241,-0.0396789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489865,0.00833762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463885,-0.0164422) , 
1, 1.41415, 1, 0, 0.48782,0.0127242) , 
1, -1.31849, 1, 0, 0.499004,0.00658248)    );
  // itree = 1125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361972,-0.0136234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.790938,0.00868036) , 
2, 0.524348, 1, 0, 0.485365,-0.0145107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433706,0.0509359) , 
1, 2.05996, 1, 0, 0.483305,-0.00980585)    );
  // itree = 1126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308211,-0.00339279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310809,-0.0438122) , 
0, -1.13706, 1, 0, 0.308919,-0.0369258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503592,0.0114838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760116,-0.0181005) , 
2, 0.687462, 1, 0, 0.604526,0.00297463) , 
0, -0.707105, 1, 0, 0.489324,-0.0125751)    );
  // itree = 1127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248896,-0.00936113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702888,0.0226799) , 
2, -0.376314, 1, 0, 0.533795,0.0234997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309609,0.00307374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545385,-0.0325292) , 
0, -0.446287, 1, 0, 0.43632,-0.0350624) , 
1, 0.522288, 1, 0, 0.503594,0.00535522)    );
  // itree = 1128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312012,-0.00509033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601933,0.0469508) , 
2, -0.306004, 1, 0, 0.34722,0.00344418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44038,-0.0330607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685521,-0.00639509) , 
0, -0.24524, 1, 0, 0.626866,-0.0314811) , 
2, -0.0852194, 1, 0, 0.496004,-0.0151376)    );
  // itree = 1129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0911316,-0.047248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233844,-0.0120429) , 
1, -1.15459, 1, 0, 0.213759,-0.0373172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465579,0.011536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686769,-0.00981367) , 
2, 0.358323, 1, 0, 0.568984,0.00258331) , 
0, -1.48202, 1, 0, 0.489137,-0.00638551)    );
  // itree = 1130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204706,-0.0225766) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537449,-0.00983285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548051,0.0152029) , 
1, -1.71379, 1, 0, 0.54722,0.026124) , 
0, -3.13399, 1, 0, 0.530473,0.0219648)    );
  // itree = 1131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528883,0.0875749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163836,-0.00456323) , 
1, 0.0272174, 1, 0, 0.35042,0.100574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567359,0.0074652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520343,-0.020374) , 
1, 1.3388, 1, 0, 0.563315,0.0109956) , 
0, -2.24141, 1, 0, 0.542383,0.0198028)    );
  // itree = 1132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266816,-0.0331333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74814,0.00549737) , 
2, 0.291111, 1, 0, 0.481587,-0.0373592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467482,-0.0154656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485329,0.0133316) , 
1, -0.300346, 1, 0, 0.48259,0.0148291) , 
1, -0.493896, 1, 0, 0.482216,-0.00465637)    );
  // itree = 1133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0368169,-0.0423388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291088,0.0261542) , 
0, -3.25934, 1, 0, 0.257529,0.0361094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399455,-0.0415697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586508,-0.00218271) , 
0, -1.40582, 1, 0, 0.568949,-0.0121747) , 
2, -0.876457, 1, 0, 0.503494,-0.0020262)    );
  // itree = 1134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352048,0.000861978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523066,-0.0149449) , 
2, 0.0549918, 1, 0, 0.403221,-0.00887442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554409,0.0472632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.839208,-0.00177902) , 
3, 0.823722, 1, 0, 0.784962,0.0163544) , 
2, 0.604931, 1, 0, 0.507697,-0.00196968)    );
  // itree = 1135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.633935,0.0472604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716666,0.00329306) , 
0, 1.00599, 1, 0, 0.668456,0.0582347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173348,-0.0170131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616219,0.00270999) , 
2, -0.724736, 1, 0, 0.486697,-0.00474819) , 
1, -1.29429, 1, 0, 0.507335,0.00240326)    );
  // itree = 1136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299169,0.0180569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521077,-0.0145238) , 
0, -3.01055, 1, 0, 0.509212,-0.0245085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188665,-0.0210896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666834,0.0236881) , 
2, -0.562364, 1, 0, 0.458335,0.012193) , 
1, 0.728801, 1, 0, 0.496295,-0.0151904)    );
  // itree = 1137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110354,0.00959585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0372179,-0.0462689) , 
2, -1.94756, 1, 0, 0.0666782,-0.0327535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351157,0.0586547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547806,0.00569302) , 
0, -2.53879, 1, 0, 0.540935,0.0152176) , 
2, -1.66897, 1, 0, 0.500973,0.0111755)    );
  // itree = 1138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610465,-0.0429944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2196,0.0657646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493721,-0.00501698) , 
2, -1.99878, 1, 0, 0.486025,-0.00743329) , 
1, -2.26777, 1, 0, 0.490468,-0.0111951)    );
  // itree = 1139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354188,-0.0283545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338075,0.0331545) , 
1, 0.592363, 1, 0, 0.349481,-0.0317015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501861,0.0443432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813467,0.00876631) , 
3, 0.613068, 1, 0, 0.722071,0.0417091) , 
0, -0.173774, 1, 0, 0.531473,0.00415592)    );
  // itree = 1140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360914,-0.0319366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474694,-0.00614998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515706,0.00914937) , 
1, 0.245632, 1, 0, 0.490498,-0.000713395) , 
1, -1.99497, 1, 0, 0.485045,-0.00483656)    );
  // itree = 1141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198125,-0.0439394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600637,0.00477847) , 
2, 0.400473, 1, 0, 0.358118,-0.0537842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.589947,0.0106242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502189,-0.00881242) , 
1, 0.227106, 1, 0, 0.551916,0.00332555) , 
1, -1.6752, 1, 0, 0.535269,-0.00158021)    );
  // itree = 1142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401168,0.0308185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585356,-0.00399447) , 
2, -0.954021, 1, 0, 0.557733,0.00331404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435034,-0.0116798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610773,-0.0741218) , 
2, 1.27042, 1, 0, 0.449333,-0.0338717) , 
1, 0.164749, 1, 0, 0.510052,-0.0130426)    );
  // itree = 1143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359997,0.00160908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552395,-0.0214735) , 
0, -0.462729, 1, 0, 0.45941,-0.0216318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629889,0.0388592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862039,0.0111249) , 
3, 1.49794, 1, 0, 0.797978,0.0500825) , 
0, 1.96897, 1, 0, 0.502008,-0.0126087)    );
  // itree = 1144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252332,-0.00929654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644393,0.0146267) , 
2, -0.219387, 1, 0, 0.444162,0.00571626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488819,-0.0495027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.800038,-0.00586873) , 
3, 1.05933, 1, 0, 0.744467,-0.0335147) , 
2, 0.944059, 1, 0, 0.503004,-0.00197067)    );
  // itree = 1145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252395,0.0414114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431018,-0.00571912) , 
2, -1.83518, 1, 0, 0.42014,-0.00696418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536282,0.0586814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815091,-0.00518985) , 
3, 1.24638, 1, 0, 0.748692,0.0362502) , 
0, 1.32897, 1, 0, 0.494168,0.00277269)    );
  // itree = 1146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548253,-0.00331587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494165,0.0246021) , 
1, -0.427637, 1, 0, 0.524282,0.0185138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200162,-0.0234599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770106,0.00374663) , 
3, 0.228801, 1, 0, 0.417984,-0.0274945) , 
1, 0.345387, 1, 0, 0.481605,4.18955e-05)    );
  // itree = 1147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50535,-0.00345463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234828,-0.0560005) , 
1, 1.38416, 1, 0, 0.491599,-0.0132638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661585,0.0328608) , 
1, 1.64303, 1, 0, 0.499824,-0.00916268)    );
  // itree = 1148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282167,0.00184017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272702,-0.0426851) , 
0, -1.8657, 1, 0, 0.279779,-0.0242626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.769776,0.0527667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599066,0.00329242) , 
1, -1.58591, 1, 0, 0.611022,0.0135794) , 
0, -1.54251, 1, 0, 0.538588,0.00530434)    );
  // itree = 1149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327316,-0.0104163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197776,-0.0284639) , 
1, 0.225534, 1, 0, 0.272274,-0.0367074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.95832,0.0486078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696138,-0.00167548) , 
0, 0.731369, 1, 0, 0.757272,0.0170785) , 
3, 0.392653, 1, 0, 0.468053,-0.0149956)    );
  // itree = 1150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0645321,-0.0107458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368399,0.0284517) , 
3, -1.96707, 1, 0, 0.302629,0.0465716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494305,-0.00902932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861786,0.0133462) , 
3, 0.959809, 1, 0, 0.618916,-0.0055014) , 
2, -0.759232, 1, 0, 0.546665,0.00639386)    );
  // itree = 1151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135974,0.00403108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202406,-0.0593784) , 
3, -0.712018, 1, 0, 0.16123,-0.0711539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562144,0.0179817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608182,-0.0269961) , 
0, 0.575766, 1, 0, 0.584622,-0.0126964) , 
2, -0.816886, 1, 0, 0.472141,-0.0282266)    );
  // itree = 1152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491575,0.0719563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332275,0.00419665) , 
1, -1.15459, 1, 0, 0.348404,0.0230037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.858717,0.0512666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566736,-0.0203601) , 
1, -1.84922, 1, 0, 0.58383,-0.0379109) , 
2, -0.281514, 1, 0, 0.493811,-0.0146191)    );
  // itree = 1153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511598,0.00595387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673011,-0.0335365) , 
3, 0.467982, 1, 0, 0.583778,-0.0280483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478948,0.0063524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319548,-0.0314311) , 
1, 1.79058, 1, 0, 0.465411,0.00777722) , 
1, -0.696094, 1, 0, 0.497644,-0.0019785)    );
  // itree = 1154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321798,-0.00856126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386642,-0.0556124) , 
0, -0.618991, 1, 0, 0.336521,-0.0386655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357359,0.0627727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739739,-0.00248012) , 
3, 0.135981, 1, 0, 0.696479,0.00940291) , 
0, -0.218015, 1, 0, 0.52807,-0.0130862)    );
  // itree = 1155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151329,-0.0279304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367831,-0.000233101) , 
2, -0.862028, 1, 0, 0.261928,-0.0262213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.7838,0.0336993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.824521,0.00297651) , 
3, 1.02628, 1, 0, 0.807565,0.0323677) , 
3, 0.254861, 1, 0, 0.521475,0.00164809)    );
  // itree = 1156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161236,-0.00796385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685341,0.0169928) , 
3, -0.711955, 1, 0, 0.523456,0.0222432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183641,0.0143418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482903,-0.065362) , 
2, -1.08557, 1, 0, 0.372527,-0.111282) , 
1, 1.48204, 1, 0, 0.510504,0.0107852)    );
  // itree = 1157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464043,-0.0026937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.947491,0.0401637) , 
2, 1.81563, 1, 0, 0.484277,-0.00204757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0506102,-0.0209658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635268,0.0339513) , 
3, -1.05225, 1, 0, 0.486164,0.0530879) , 
1, 0.736789, 1, 0, 0.484689,0.00999003)    );
  // itree = 1158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255941,0.00531953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640012,0.0327641) , 
3, -0.0792972, 1, 0, 0.333682,0.0229308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692074,-0.015131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.910316,0.0138995) , 
3, 1.58463, 1, 0, 0.753794,-0.016486) , 
3, 0.234307, 1, 0, 0.538688,0.00369625)    );
  // itree = 1159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560187,-0.00285299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511715,-0.059392) , 
1, -0.938176, 1, 0, 0.546748,-0.0486679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494934,0.00363825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450935,0.0707902) , 
1, 2.0038, 1, 0, 0.49305,0.0120863) , 
1, -0.697263, 1, 0, 0.509175,-0.00615761)    );
  // itree = 1160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.034803,-0.0552283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0179909,-0.0313792) , 
1, -0.259045, 1, 0, 0.02372,-0.0460025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511484,0.0106799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743089,-0.010223) , 
2, 1.04615, 1, 0, 0.55667,0.012495) , 
3, -1.73087, 1, 0, 0.511184,0.0075023)    );
  // itree = 1161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556348,-0.00886413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440427,-0.0801404) , 
1, -0.701954, 1, 0, 0.541395,-0.0391107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638653,0.0415956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458017,-0.000804919) , 
1, -0.382097, 1, 0, 0.473208,0.00690041) , 
1, -0.577244, 1, 0, 0.493856,-0.00703256)    );
  // itree = 1162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64063,-0.0373799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294845,-0.0259591) , 
1, -2.04121, 1, 0, 0.460579,-0.0722531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0698277,-0.0412308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555572,0.00951626) , 
0, -3.18107, 1, 0, 0.532743,0.0153153) , 
1, -1.71379, 1, 0, 0.528394,0.0100381)    );
  // itree = 1163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136382,0.0512409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24685,-0.0471992) , 
3, -2.06539, 1, 0, 0.196268,-0.0559748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500572,0.0144085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687912,-0.00174204) , 
0, 1.2126, 1, 0, 0.550987,0.0184639) , 
0, -2.405, 1, 0, 0.512195,0.0103234)    );
  // itree = 1164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304326,0.0388517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248833,-0.0277163) , 
0, -3.04481, 1, 0, 0.254846,-0.039923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612204,0.00840858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500163,-0.0191167) , 
1, 0.990731, 1, 0, 0.594325,0.00656557) , 
0, -0.947009, 1, 0, 0.484944,-0.00841315)    );
  // itree = 1165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573475,0.00184881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453845,-0.0198191) , 
1, -0.779428, 1, 0, 0.512342,-0.021238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154395,-0.0073461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615879,0.01987) , 
2, -0.696554, 1, 0, 0.459539,0.0233983) , 
1, -0.0822111, 1, 0, 0.484344,0.00242923)    );
  // itree = 1166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224594,0.0167197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564077,-0.00952934) , 
3, -0.280709, 1, 0, 0.293623,0.0207098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316865,-0.0323907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786956,0.00804963) , 
3, 0.177952, 1, 0, 0.646014,-0.0144887) , 
2, -0.328137, 1, 0, 0.494645,0.000630678)    );
  // itree = 1167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300778,-0.0419598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735249,-0.00131405) , 
2, -0.224522, 1, 0, 0.566843,-0.0368639) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534845,0.0228709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469615,-0.00431646) , 
1, -0.399394, 1, 0, 0.47972,-0.000262547) , 
1, -0.775571, 1, 0, 0.501454,-0.00939347)    );
  // itree = 1168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537035,0.00242046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54237,0.0277693) , 
1, 0.353863, 1, 0, 0.538581,0.018027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496421,-0.0551089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327653,-0.0132101) , 
1, 2.05686, 1, 0, 0.40559,-0.0509289) , 
1, 1.6455, 1, 0, 0.530401,0.0137856)    );
  // itree = 1169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192745,-0.00387756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461325,0.0336749) , 
2, -1.24309, 1, 0, 0.344837,0.0373413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502048,-0.0183089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.921058,0.023282) , 
3, 1.85012, 1, 0, 0.558259,-0.0322792) , 
2, -0.452846, 1, 0, 0.494356,-0.0114334)    );
  // itree = 1170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174596,-0.0358502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225359,0.0325967) , 
1, 1.18756, 1, 0, 0.182664,-0.0560927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566662,0.0364087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654422,-0.0065148) , 
2, -0.200769, 1, 0, 0.638451,0.00339766) , 
2, -0.662058, 1, 0, 0.502871,-0.0142985)    );
  // itree = 1171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150737,-0.0157894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735917,0.0180202) , 
3, -0.62845, 1, 0, 0.557828,0.0172153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367165,0.00627726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553568,-0.0394902) , 
0, -0.122417, 1, 0, 0.455149,-0.0317284) , 
1, 0.0100439, 1, 0, 0.510034,-0.00556675)    );
  // itree = 1172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0289756,-0.0480442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15999,0.00113842) , 
3, -1.6022, 1, 0, 0.102217,-0.0332858) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575643,0.0128864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704772,-0.0153346) , 
0, 2.27012, 1, 0, 0.591208,0.0191188) , 
2, -1.2061, 1, 0, 0.516724,0.0111365)    );
  // itree = 1173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302152,0.0760322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153326,0.00884886) , 
0, -2.56068, 1, 0, 0.22152,0.0711089) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24689,-0.0434514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58574,0.0036185) , 
0, -1.93146, 1, 0, 0.556548,0.000116914) , 
2, -1.47465, 1, 0, 0.518525,0.00817389)    );
  // itree = 1174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326575,-0.00838092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47851,-0.0298906) , 
0, 0.0603933, 1, 0, 0.3709,-0.031026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.80801,0.0253488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735835,-0.00573263) , 
0, 0.903586, 1, 0, 0.757139,0.00670471) , 
2, 0.650833, 1, 0, 0.473459,-0.0210073)    );
  // itree = 1175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277521,0.0573292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281728,0.222859) , 
1, 0.301203, 1, 0, 0.279346,0.143366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347857,-0.000624348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627362,-0.0173167) , 
0, -0.13078, 1, 0, 0.492747,-0.0213653) , 
2, -1.9018, 1, 0, 0.480153,-0.0116435)    );
  // itree = 1176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547787,0.00468471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60595,0.0269756) , 
1, -0.84569, 1, 0, 0.572103,0.0294191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439365,-0.0180454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797636,0.0360144) , 
0, 2.76471, 1, 0, 0.457707,-0.0306247) , 
1, -0.213927, 1, 0, 0.508761,-0.00382791)    );
  // itree = 1177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122526,-0.0134333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703676,0.0310971) , 
3, -0.772509, 1, 0, 0.398844,0.0225084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422467,-0.0167729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875177,0.00936519) , 
3, 1.15568, 1, 0, 0.598349,-0.0188301) , 
0, -0.00413718, 1, 0, 0.498353,0.00188966)    );
  // itree = 1178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670761,-0.0051639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410895,0.0494095) , 
3, -1.62186, 1, 0, 0.274654,0.0578024) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398786,0.00654162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714465,-0.0158988) , 
3, 0.327581, 1, 0, 0.584336,-0.0141262) , 
2, -0.882582, 1, 0, 0.510722,0.00297195)    );
  // itree = 1179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342251,-0.010596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754912,-0.152777) , 
3, 0.772769, 1, 0, 0.360546,-0.0280925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419859,0.0278341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830194,0.00605824) , 
3, 0.861837, 1, 0, 0.709587,0.0296276) , 
0, 0.421965, 1, 0, 0.490302,-0.00663516)    );
  // itree = 1180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375426,0.00267382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524418,-0.0547864) , 
2, 0.567082, 1, 0, 0.400243,-0.0143967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.780373,0.0188679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770197,0.0474727) , 
1, 0.965187, 1, 0, 0.778328,0.0572377) , 
0, 1.24421, 1, 0, 0.486326,0.00191324)    );
  // itree = 1181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469106,-0.0255993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638272,0.019828) , 
1, -1.51781, 1, 0, 0.590326,0.0127538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324192,-0.00437159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545765,-0.027201) , 
0, -0.0921771, 1, 0, 0.426006,-0.034555) , 
1, -0.359664, 1, 0, 0.487917,-0.0167304)    );
  // itree = 1182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.671872,0.033837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528593,-0.0235391) , 
1, -1.94019, 1, 0, 0.547326,-0.0372637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319604,0.0262522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610474,-0.00308769) , 
2, -0.41835, 1, 0, 0.505741,0.01171) , 
1, -0.700332, 1, 0, 0.518611,-0.00344625)    );
  // itree = 1183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20499,0.0214191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53601,-0.00914672) , 
2, -1.30857, 1, 0, 0.500252,-0.0132347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492832,0.0357037) , 
1, 1.6455, 1, 0, 0.499905,-0.00908937)    );
  // itree = 1184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440591,0.00238854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298249,-0.028218) , 
1, 0.191326, 1, 0, 0.374669,-0.0260554) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791858,0.029769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686015,-0.000487399) , 
1, -1.31849, 1, 0, 0.700442,0.00759057) , 
2, 0.233941, 1, 0, 0.51448,-0.0116157)    );
  // itree = 1185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584963,-0.00695599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.532981,0.0174164) , 
1, -0.37085, 1, 0, 0.554146,0.0139906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146338,-0.0588897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684775,0.00158592) , 
2, -0.163755, 1, 0, 0.356681,-0.0884442) , 
1, 1.17696, 1, 0, 0.528742,0.000812342)    );
  // itree = 1186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190454,-0.0296181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522661,-0.00595285) , 
2, -0.634836, 1, 0, 0.330499,-0.0383886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63186,0.0411691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65041,-0.00429246) , 
0, 0.18384, 1, 0, 0.646454,0.0110204) , 
2, 0.120313, 1, 0, 0.47261,-0.0161653)    );
  // itree = 1187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359664,-0.00475976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221728,-0.0348124) , 
1, 0.248859, 1, 0, 0.294122,-0.0412406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.689976,0.0555868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67397,-0.00304971) , 
0, -0.0280977, 1, 0, 0.676093,0.00739527) , 
0, -0.371383, 1, 0, 0.490229,-0.0162705)    );
  // itree = 1188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448539,0.00132622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619173,-0.0382857) , 
2, 0.87446, 1, 0, 0.480279,-0.0134688) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659933,-0.017963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869842,0.050328) , 
2, 1.39222, 1, 0, 0.779956,0.0690576) , 
0, 2.41389, 1, 0, 0.50799,-0.00583761)    );
  // itree = 1189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569093,-0.0125344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328994,-0.0387255) , 
1, -0.735222, 1, 0, 0.50561,-0.0432187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362029,-0.00243075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742133,0.0199074) , 
0, 0.619485, 1, 0, 0.498295,0.0123856) , 
1, -0.421024, 1, 0, 0.500862,-0.00712922)    );
  // itree = 1190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323226,0.0154942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538243,-0.0051583) , 
0, -1.59157, 1, 0, 0.498156,-0.0034624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624958,-0.0435946) , 
0, 3.16748, 1, 0, 0.501335,-0.00608414)    );
  // itree = 1191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245859,0.0341269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472278,0.00652468) , 
2, -0.968858, 1, 0, 0.353059,0.0353704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144007,-0.0348994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736962,0.00727193) , 
3, 0.0306728, 1, 0, 0.590079,-0.00950089) , 
0, -0.84483, 1, 0, 0.510528,0.00555932)    );
  // itree = 1192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634442,0.0150905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.899931,0.0592937) , 
1, -0.784311, 1, 0, 0.669162,0.0423695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164657,0.0566826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502106,-0.0109846) , 
2, -1.63878, 1, 0, 0.471393,-0.0149598) , 
1, -0.636138, 1, 0, 0.528417,0.00157041)    );
  // itree = 1193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.657617,0.0165722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483861,-0.00389674) , 
1, -1.03136, 1, 0, 0.51439,1.0421e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672359,0.0795912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431166,0.0046728) , 
1, 1.70874, 1, 0, 0.528907,0.0887968) , 
1, 1.41092, 1, 0, 0.515331,0.00576595)    );
  // itree = 1194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540677,-0.0193882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816921,0.0283911) , 
1, -0.784311, 1, 0, 0.564384,-0.0273592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404884,0.000382842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.747442,0.020603) , 
0, 1.08724, 1, 0, 0.495933,0.0129646) , 
1, -0.636138, 1, 0, 0.515963,0.00116516)    );
  // itree = 1195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565666,0.0183371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729513,-0.0233582) , 
2, 1.2182, 1, 0, 0.588902,0.0275403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347606,-0.0173962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702417,0.0222053) , 
0, 1.09891, 1, 0, 0.416394,-0.0159435) , 
1, 0.345387, 1, 0, 0.523691,0.0111026)    );
  // itree = 1196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267227,0.0415897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504718,0.00208605) , 
0, -3.48298, 1, 0, 0.492631,0.00933751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295854,-0.0531596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702405,-0.00896485) , 
2, 0.0609282, 1, 0, 0.631559,-0.0359202) , 
0, 0.846748, 1, 0, 0.536984,-0.00511108)    );
  // itree = 1197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115304,-0.00999887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254023,-0.0386602) , 
3, -1.70009, 1, 0, 0.189043,-0.0688949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51725,0.0105448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674815,-0.029799) , 
0, 2.17309, 1, 0, 0.538098,0.00803386) , 
0, -2.25694, 1, 0, 0.497328,-0.000951398)    );
  // itree = 1198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418433,-0.00574625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751339,0.0208208) , 
2, 0.412388, 1, 0, 0.53431,0.00908369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414837,-0.0352742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519763,0.0309486) , 
1, 1.89272, 1, 0, 0.43325,-0.0533983) , 
1, 0.820442, 1, 0, 0.512551,-0.00436893)    );
  // itree = 1199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314472,-0.028371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350203,0.0162261) , 
1, -0.0220652, 1, 0, 0.32958,-0.0226316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570435,0.0251155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.809781,-0.00326118) , 
3, 0.730376, 1, 0, 0.725774,0.0147284) , 
2, -0.120384, 1, 0, 0.548946,-0.00194594)    );
  // itree = 1200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299791,-0.00581631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533165,-0.0233046) , 
0, -0.782086, 1, 0, 0.415537,-0.0292406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.69847,0.0369149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.749193,0.00455139) , 
0, 1.51451, 1, 0, 0.737014,0.0274138) , 
0, 0.972553, 1, 0, 0.49292,-0.0156032)    );
  // itree = 1201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427677,0.00124694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775802,0.0427129) , 
0, 0.604818, 1, 0, 0.476436,0.013526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621238,-0.0449463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743236,-0.00919939) , 
0, 1.61735, 1, 0, 0.698353,-0.0473973) , 
0, 1.05872, 1, 0, 0.531391,-0.00156083)    );
  // itree = 1202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0341437,-0.0660896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508677,-0.017091) , 
2, -2.08407, 1, 0, 0.493727,-0.0414356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174029,-0.0197771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.804578,0.0502515) , 
2, -0.0667511, 1, 0, 0.466518,0.0324531) , 
1, 1.17696, 1, 0, 0.490914,-0.0337978)    );
  // itree = 1203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518164,-0.0183282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.444506,0.00183758) , 
1, -0.0778168, 1, 0, 0.483806,-0.0177106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218139,-0.0478168) , 
1, 2.04816, 1, 0, 0.475293,-0.020303)    );
  // itree = 1204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.042923,-0.0447328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274094,0.0238518) , 
2, -1.86349, 1, 0, 0.233892,0.0228698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.786038,0.0231069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652237,-0.00744464) , 
1, -1.48186, 1, 0, 0.665186,-0.0107749) , 
3, -0.25059, 1, 0, 0.495211,0.00248465)    );
  // itree = 1205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456145,0.00261811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624757,0.034435) , 
0, 1.46331, 1, 0, 0.471661,0.0111663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610854,-0.0456604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.829182,0.0070486) , 
2, 1.12844, 1, 0, 0.724387,-0.0360663) , 
0, 1.94906, 1, 0, 0.501928,0.00550967)    );
  // itree = 1206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275775,0.0278917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509533,0.00484179) , 
0, -2.02583, 1, 0, 0.478606,0.0162758) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.851177,0.070383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.904079,0.0179225) , 
3, 2.00093, 1, 0, 0.884152,0.118885) , 
0, 2.41389, 1, 0, 0.518943,0.0264816)    );
  // itree = 1207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304973,0.0151284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577711,-0.018042) , 
2, -0.595228, 1, 0, 0.513583,-0.0238335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27146,0.05665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520814,0.0108311) , 
0, -1.70986, 1, 0, 0.484253,0.0292026) , 
1, 0.164749, 1, 0, 0.499883,0.000938784)    );
  // itree = 1208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229947,-0.00408375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131361,-0.0408831) , 
1, -0.400135, 1, 0, 0.159523,-0.0686636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382222,0.0156765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635589,-0.00746345) , 
2, -0.256057, 1, 0, 0.550515,-0.0015663) , 
0, -2.38814, 1, 0, 0.508631,-0.0087539)    );
  // itree = 1209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304827,0.0214823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283538,-0.0144499) , 
0, -1.41114, 1, 0, 0.294171,0.00190538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.669433,0.036522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720268,0.00341254) , 
0, 1.16191, 1, 0, 0.690869,0.0442041) , 
2, -0.386571, 1, 0, 0.535076,0.0275924)    );
  // itree = 1210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462119,0.0056696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677927,-0.0111552) , 
2, 0.560086, 1, 0, 0.527194,7.12995e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.626044,0.07007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556265,0.00821778) , 
2, -0.295052, 1, 0, 0.58194,0.0752822) , 
1, 1.45051, 1, 0, 0.532107,0.00682178)    );
  // itree = 1211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27222,-0.0218851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225996,0.0358075) , 
0, 0.142699, 1, 0, 0.267447,-0.0364098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63189,-0.0167483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792937,0.0139068) , 
3, 0.412722, 1, 0, 0.773113,0.0197575) , 
3, 0.20809, 1, 0, 0.486051,-0.0121282)    );
  // itree = 1212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610869,-8.20461e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672079,0.0527055) , 
1, -1.15073, 1, 0, 0.642347,0.0475293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452979,-0.0110526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540937,0.0218418) , 
1, 0.726051, 1, 0, 0.478938,-0.00389471) , 
1, -0.605638, 1, 0, 0.533379,0.0132376)    );
  // itree = 1213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.675185,0.015445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780154,0.0906064) , 
1, -0.658597, 1, 0, 0.686665,0.0531916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411301,-0.0138112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683076,0.00628486) , 
0, 1.44236, 1, 0, 0.468477,-0.0191933) , 
1, -0.548365, 1, 0, 0.525484,-0.000281054)    );
  // itree = 1214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258665,0.0136256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485579,0.0476695) , 
0, -0.788424, 1, 0, 0.325038,0.0466547) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429533,-0.0589486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626437,-0.00314818) , 
1, -1.79218, 1, 0, 0.614902,-0.0149717) , 
2, -0.363302, 1, 0, 0.50899,0.00754568)    );
  // itree = 1215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0762762,0.00101275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826747,-0.0514639) , 
3, -1.77182, 1, 0, 0.0799907,-0.0782354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572917,0.00694382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399703,-0.0444775) , 
1, 1.79938, 1, 0, 0.564974,0.00984396) , 
2, -1.63878, 1, 0, 0.507368,-0.000618071)    );
  // itree = 1216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2825,0.00954234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393977,-0.0350445) , 
0, -1.05765, 1, 0, 0.342546,-0.0335306) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.700737,0.0521698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698411,0.00370675) , 
2, 0.410274, 1, 0, 0.698712,0.0200558) , 
2, 0.224475, 1, 0, 0.493615,-0.0108017)    );
  // itree = 1217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162669,-0.0125534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228681,-0.0595238) , 
2, -1.37749, 1, 0, 0.186954,-0.0825843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41004,0.01652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769402,-0.00670891) , 
3, 0.610502, 1, 0, 0.563414,0.0132446) , 
0, -2.41637, 1, 0, 0.522988,0.00295393)    );
  // itree = 1218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125771,-0.0475182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156688,0.00345796) , 
1, 0.506955, 1, 0, 0.138738,-0.0532333) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4951,0.0312312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759987,-0.00622361) , 
3, 0.479071, 1, 0, 0.626811,0.0257021) , 
2, -1.32298, 1, 0, 0.553545,0.0138528)    );
  // itree = 1219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152378,-0.00238629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32922,-0.0177665) , 
3, -0.805096, 1, 0, 0.238534,-0.0250024) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712726,0.029536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.810627,-0.0028193) , 
3, 0.600335, 1, 0, 0.779946,0.0144048) , 
3, -0.00187935, 1, 0, 0.527139,-0.00399598)    );
  // itree = 1220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453867,-0.0357036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434942,-0.00830756) , 
1, -1.00575, 1, 0, 0.438273,-0.0283377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.730026,0.0473555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868127,0.00371079) , 
3, 1.78416, 1, 0, 0.813889,0.0637478) , 
0, 1.96897, 1, 0, 0.480614,-0.0179576)    );
  // itree = 1221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307112,0.0351661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16833,-0.0279284) , 
1, 1.02385, 1, 0, 0.279957,0.0346047) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196593,-0.0389127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591239,-0.00484593) , 
0, -0.804831, 1, 0, 0.50391,-0.0261051) , 
0, -1.60723, 1, 0, 0.463504,-0.0151518)    );
  // itree = 1222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136262,-0.0334753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31437,-0.0101159) , 
0, -2.87298, 1, 0, 0.295284,-0.0257434) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.856362,0.0441544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818171,0.00360979) , 
1, -1.36512, 1, 0, 0.821802,0.0169674) , 
3, 0.392653, 1, 0, 0.5003,-0.00911261)    );
  // itree = 1223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134879,-0.0086828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719541,0.0303294) , 
3, -0.765353, 1, 0, 0.340926,0.0149624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27809,-0.0298636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636656,-0.00445733) , 
2, -0.195671, 1, 0, 0.544724,-0.0261399) , 
0, -0.773058, 1, 0, 0.476241,-0.0123281)    );
  // itree = 1224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361666,-0.00459585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646578,-0.0182486) , 
2, 0.161708, 1, 0, 0.487812,-0.0221978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5478,0.0332493) , 
1, 1.66439, 1, 0, 0.491129,-0.017234)    );
  // itree = 1225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157806,-0.00912542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176089,-0.0414109) , 
0, -1.73336, 1, 0, 0.167594,-0.0513056) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550054,-0.00262732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792101,0.0163159) , 
2, 0.634202, 1, 0, 0.641886,0.00993672) , 
2, -0.767121, 1, 0, 0.502116,-0.00811086)    );
  // itree = 1226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622239,0.0173435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452286,-0.0104735) , 
1, -0.704038, 1, 0, 0.503898,-0.00450071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593753,0.0608457) , 
1, 1.90487, 1, 0, 0.507017,0.000314721)    );
  // itree = 1227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.085285,-0.00169995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322231,0.0444861) , 
3, -1.76121, 1, 0, 0.242347,0.0495727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303888,0.0204285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577412,-0.0123609) , 
2, -0.667923, 1, 0, 0.557474,-0.0222854) , 
2, -0.907503, 1, 0, 0.484827,-0.00571979)    );
  // itree = 1228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436025,-0.00111665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611925,-0.0399569) , 
0, 0.508335, 1, 0, 0.504306,-0.0365972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21856,-0.00395331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.720457,0.0176129) , 
3, -0.283698, 1, 0, 0.550428,0.0237767) , 
1, -0.781709, 1, 0, 0.537672,0.00707964)    );
  // itree = 1229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287724,0.0232531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609852,-0.00365221) , 
2, -0.767121, 1, 0, 0.549602,0.000621073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418563,0.0167018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478999,-0.0455345) , 
0, -0.837232, 1, 0, 0.459111,-0.0600739) , 
1, 1.41092, 1, 0, 0.541394,-0.00488453)    );
  // itree = 1230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301374,0.0643369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180756,-0.0219596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705743,0.00246065) , 
3, -0.280327, 1, 0, 0.490682,-0.0137782) , 
0, -3.69612, 1, 0, 0.485848,-0.00974695)    );
  // itree = 1231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478375,0.00415045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362815,-0.0273957) , 
1, 1.07539, 1, 0, 0.458276,-0.00313283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139577,-0.0734524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.893885,-0.00484221) , 
3, 1.74983, 1, 0, 0.654195,-0.0814246) , 
0, 2.30263, 1, 0, 0.474995,-0.0098139)    );
  // itree = 1232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417504,0.00386222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359632,-0.0418766) , 
0, 0.136645, 1, 0, 0.407348,-0.0108441) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.675193,0.0311821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758683,0.0067543) , 
2, 0.908258, 1, 0, 0.714018,0.0444922) , 
0, 0.619485, 1, 0, 0.511227,0.00790004)    );
  // itree = 1233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116929,0.0181446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312225,-0.0150282) , 
3, -1.12137, 1, 0, 0.250459,-0.0174285) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.759722,0.0270101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832899,-0.00390173) , 
3, 1.19897, 1, 0, 0.792001,0.0325635) , 
3, 0.202693, 1, 0, 0.485015,0.00422428)    );
  // itree = 1234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0726412,0.00320612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256448,0.0594103) , 
3, -1.93179, 1, 0, 0.148842,0.0452531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450706,-0.0130932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664172,0.00183975) , 
0, 0.610062, 1, 0, 0.538206,-0.0152766) , 
3, -1.54749, 1, 0, 0.503296,-0.00984959)    );
  // itree = 1235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341144,-0.00965576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190496,-0.0424834) , 
0, 0.23959, 1, 0, 0.313589,-0.0345259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673509,-0.0158164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.846206,0.0139529) , 
3, 0.856084, 1, 0, 0.821049,0.0159858) , 
3, 0.660704, 1, 0, 0.486983,-0.0172665)    );
  // itree = 1236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.051849,-0.03472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272721,0.0503647) , 
2, -1.99751, 1, 0, 0.210793,0.0404096) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.039534,-0.0461043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568421,0.00162023) , 
3, -1.38315, 1, 0, 0.537368,-0.000584039) , 
2, -1.20531, 1, 0, 0.492402,0.0050603)    );
  // itree = 1237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46424,-0.00422623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731037,0.0148997) , 
0, 1.3667, 1, 0, 0.514713,-0.000474042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430918,-0.0271674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485038,0.0201845) , 
1, 1.98151, 1, 0, 0.437515,-0.0398082) , 
1, 0.71376, 1, 0, 0.496666,-0.00966955)    );
  // itree = 1238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187645,-0.00283954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649679,0.0605908) , 
2, -0.701417, 1, 0, 0.280512,0.0283364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532566,-0.0080514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680449,0.0247396) , 
1, 1.45051, 1, 0, 0.54265,-0.0125637) , 
0, -1.60723, 1, 0, 0.487489,-0.00395712)    );
  // itree = 1239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227565,-0.0332267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355482,0.00855509) , 
1, -1.86555, 1, 0, 0.346903,0.0091287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.682963,-0.0250714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886354,0.00903406) , 
3, 1.37946, 1, 0, 0.784323,-0.0172058) , 
3, 0.671928, 1, 0, 0.490765,0.000467606)    );
  // itree = 1240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343659,0.0036677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293346,0.0496088) , 
1, 1.12171, 1, 0, 0.339007,0.0139264) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.80882,-0.0884289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705534,0.000566352) , 
0, -0.142006, 1, 0, 0.719792,-0.0140136) , 
3, 0.17816, 1, 0, 0.541312,-0.000917648)    );
  // itree = 1241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584802,0.0161672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430075,-0.0272321) , 
1, -1.08186, 1, 0, 0.474735,-0.0369446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497736,0.0258147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376637,-0.0348665) , 
1, 1.97849, 1, 0, 0.488058,0.0370358) , 
1, 0.107402, 1, 0, 0.480729,-0.00366214)    );
  // itree = 1242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495478,0.00745602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661526,-0.0155927) , 
0, 1.23997, 1, 0, 0.539731,0.0016295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726449,0.077629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462891,0.0118728) , 
1, 0.467915, 1, 0, 0.483279,0.0306937) , 
1, 0.354135, 1, 0, 0.51969,0.0119475)    );
  // itree = 1243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270657,0.0473631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11142,-0.0273244) , 
1, -1.00559, 1, 0, 0.133186,-0.0286187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558004,0.031467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658431,-0.000241313) , 
2, -0.506529, 1, 0, 0.643607,0.00967279) , 
3, -0.749223, 1, 0, 0.503763,-0.000818172)    );
  // itree = 1244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0373744,-0.0387872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373994,0.00999694) , 
3, -1.97449, 1, 0, 0.341293,0.0151172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.797967,0.026962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715893,-0.0220637) , 
1, -1.31868, 1, 0, 0.724463,-0.0337946) , 
3, 0.389233, 1, 0, 0.509721,-0.00638271)    );
  // itree = 1245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391945,-0.0289823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514524,0.00501003) , 
1, -1.88371, 1, 0, 0.505796,0.00534995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281718,-0.0137002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433783,-0.0562742) , 
2, -0.237993, 1, 0, 0.340174,-0.0731342) , 
1, 1.08213, 1, 0, 0.48121,-0.0063007)    );
  // itree = 1246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130624,-0.008528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380086,-0.0455034) , 
3, -0.933612, 1, 0, 0.257259,-0.070535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673016,0.026393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728358,-0.0127137) , 
2, 1.56684, 1, 0, 0.679657,0.0444956) , 
2, -0.319459, 1, 0, 0.502675,-0.00370156)    );
  // itree = 1247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267588,0.00186443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924341,0.0589834) , 
3, 0.212856, 1, 0, 0.37963,0.0193263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604073,-0.00461081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724853,-0.0316859) , 
2, 1.68346, 1, 0, 0.618283,-0.0153608) , 
2, 0.161708, 1, 0, 0.493539,0.00277021)    );
  // itree = 1248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186934,-0.000958215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367485,0.0418476) , 
2, -0.244074, 1, 0, 0.227333,0.0189307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465775,-0.034822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754278,-0.00429432) , 
3, 0.546413, 1, 0, 0.642982,-0.0392969) , 
3, -0.123397, 1, 0, 0.467815,-0.014758)    );
  // itree = 1249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241977,0.00657703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.941014,0.0589875) , 
3, -0.278397, 1, 0, 0.4075,0.0357745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622325,-0.00314757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597227,-0.0307874) , 
0, 2.56151, 1, 0, 0.61948,-0.0152368) , 
0, -0.218015, 1, 0, 0.512344,0.0105445)    );
  // itree = 1250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286298,0.015351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133846,-0.0121014) , 
0, -2.97724, 1, 0, 0.158702,-0.0104553) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.733397,0.0526252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694038,0.00558409) , 
2, -0.231381, 1, 0, 0.699188,0.0266106) , 
3, -0.420978, 1, 0, 0.521561,0.0144292)    );
  // itree = 1251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235428,-0.00334703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655977,-0.0247238) , 
3, 0.122344, 1, 0, 0.390605,-0.0240951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.772102,0.00284987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854681,0.0477288) , 
1, 0.81581, 1, 0, 0.785984,0.0243947) , 
2, 0.809855, 1, 0, 0.482562,-0.0128174)    );
  // itree = 1252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519486,0.00266586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83884,0.0417758) , 
2, 1.5256, 1, 0, 0.549093,0.0139832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282491,-0.0395706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748321,0.00187248) , 
0, 0.237931, 1, 0, 0.4262,-0.0621198) , 
1, 0.973008, 1, 0, 0.528691,0.00134917)    );
  // itree = 1253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.682002,0.0540937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461883,-0.00868858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836497,0.0187827) , 
2, 1.46199, 1, 0, 0.493092,-0.0116805) , 
1, -1.71006, 1, 0, 0.500941,-0.0060946)    );
  // itree = 1254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217546,-0.0104132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636202,0.019605) , 
2, -0.871865, 1, 0, 0.544046,0.0245827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229629,-0.0308435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.817232,0.0143861) , 
3, 0.660432, 1, 0, 0.381032,-0.0418872) , 
1, 0.886404, 1, 0, 0.509865,0.010645)    );
  // itree = 1255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327319,0.0107236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563121,-0.0448215) , 
2, 0.198706, 1, 0, 0.377273,-0.00671903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521918,-0.00581184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.821954,0.0285959) , 
2, 0.179323, 1, 0, 0.755051,0.0402053) , 
0, 0.510979, 1, 0, 0.507383,0.00944214)    );
  // itree = 1256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316328,0.024245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549192,-0.00667873) , 
2, -0.18534, 1, 0, 0.376994,0.0262769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582703,-0.04158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63895,-0.00271594) , 
1, -0.39136, 1, 0, 0.616339,-0.0390393) , 
0, -0.327592, 1, 0, 0.506688,-0.0091162)    );
  // itree = 1257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343392,-0.00886738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67316,0.0135569) , 
2, 0.0472197, 1, 0, 0.468035,0.000814106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339363,-0.0679743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.883778,0.0137046) , 
3, 1.61028, 1, 0, 0.688257,-0.0506802) , 
2, 1.15886, 1, 0, 0.496099,-0.00574808)    );
  // itree = 1258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164688,0.00412951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536984,0.0246006) , 
3, -0.52447, 1, 0, 0.333612,0.0276817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.813738,0.0442574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74294,-0.0137278) , 
1, -1.6752, 1, 0, 0.747858,-0.0192792) , 
3, 0.28719, 1, 0, 0.525397,0.00593998)    );
  // itree = 1259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366919,0.00382223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861529,0.0506246) , 
3, 0.931602, 1, 0, 0.401689,0.0156296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.591318,-0.0489922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86577,-0.010495) , 
3, 1.4042, 1, 0, 0.814996,-0.0366028) , 
3, 1.2441, 1, 0, 0.477867,0.00600243)    );
  // itree = 1260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420959,-0.0031259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651003,-0.0204268) , 
2, 0.650515, 1, 0, 0.483709,-0.0164956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568317,0.0514028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484336,-0.00309819) , 
1, 1.76336, 1, 0, 0.533326,0.0545884) , 
1, 1.41912, 1, 0, 0.487196,-0.0115005)    );
  // itree = 1261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379644,0.0370093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194191,-0.00746048) , 
1, 0.0272174, 1, 0, 0.295912,0.0487901) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28766,-0.0224892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76529,0.000319607) , 
3, 0.398854, 1, 0, 0.49119,-0.0269073) , 
0, -2.41637, 1, 0, 0.474671,-0.020504)    );
  // itree = 1262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520417,-0.000382164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571192,0.0348877) , 
1, 0.0212326, 1, 0, 0.52534,0.00706259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393016,-0.045471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435078,-0.0111294) , 
1, 0.322854, 1, 0, 0.429425,-0.0397714) , 
1, 0.181348, 1, 0, 0.484839,-0.0127136)    );
  // itree = 1263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282977,0.0406831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694083,0.000866574) , 
3, -0.825438, 1, 0, 0.578615,0.0213307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282605,-0.0201688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727347,0.0151258) , 
0, 0.619485, 1, 0, 0.40963,-0.0160432) , 
1, 0.38739, 1, 0, 0.519127,0.00817392)    );
  // itree = 1264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195839,-0.0614351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318388,-0.0128829) , 
1, -1.44575, 1, 0, 0.305753,-0.0442992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.715413,0.0364945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611667,0.00197636) , 
1, -0.815743, 1, 0, 0.640386,0.0215363) , 
0, -0.773058, 1, 0, 0.52867,-0.000442678)    );
  // itree = 1265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49281,0.00933446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874428,0.0470861) , 
0, 3.19023, 1, 0, 0.506169,0.0229102) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0383107,-0.0696211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68043,-0.0153783) , 
3, 0.187697, 1, 0, 0.332314,-0.0998614) , 
1, 1.41092, 1, 0, 0.48961,0.0112167)    );
  // itree = 1266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500241,0.0106174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732173,-0.0181121) , 
2, 1.23634, 1, 0, 0.534791,0.0132251) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248374,-0.00338136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537363,-0.0374225) , 
2, -0.262479, 1, 0, 0.400677,-0.0461748) , 
1, 0.0914683, 1, 0, 0.473621,-0.0138675)    );
  // itree = 1267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568125,0.0116984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453885,-0.0137377) , 
1, 0.217597, 1, 0, 0.524764,0.00417413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550253,0.0798174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586768,-0.0245431) , 
0, 0.714791, 1, 0, 0.565905,0.0787059) , 
1, 1.45051, 1, 0, 0.527531,0.00918655)    );
  // itree = 1268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147418,-0.00047228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219821,-0.0379285) , 
3, -1.41176, 1, 0, 0.176482,-0.0429492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41617,0.0318523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589275,-0.00676813) , 
2, -0.310949, 1, 0, 0.536296,0.00558748) , 
2, -1.29367, 1, 0, 0.482117,-0.00172081)    );
  // itree = 1269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156791,-0.0487389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0609849,-0.0427107) , 
1, -0.234174, 1, 0, 0.0837215,-0.080061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378813,-0.0108575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687334,0.00995827) , 
2, -0.175197, 1, 0, 0.570282,0.00406893) , 
2, -1.40727, 1, 0, 0.516759,-0.00518556)    );
  // itree = 1270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542049,-0.00963197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497684,-0.0666135) , 
2, 0.276916, 1, 0, 0.521992,-0.0883811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101574,-0.052362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559334,0.00300291) , 
2, -1.23085, 1, 0, 0.50438,-0.0051513) , 
1, -1.31868, 1, 0, 0.506312,-0.0142786)    );
  // itree = 1271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188092,0.0256925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308612,0.0586186) , 
0, -2.84474, 1, 0, 0.256101,0.0774763) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47945,-0.0190063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719787,0.0265283) , 
1, 1.00994, 1, 0, 0.506219,-0.0308076) , 
2, -1.23488, 1, 0, 0.481067,-0.0199188)    );
  // itree = 1272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133716,0.00522596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0929548,-0.0614703) , 
2, -1.81146, 1, 0, 0.11561,-0.0468672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.749903,0.0563306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598606,0.0102383) , 
1, -1.82258, 1, 0, 0.606175,0.0249452) , 
2, -1.47465, 1, 0, 0.545183,0.0160167)    );
  // itree = 1273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0645937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458985,0.0179121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683008,-0.0026551) , 
0, 0.250133, 1, 0, 0.555132,0.0171993) , 
3, -2.28271, 1, 0, 0.537414,0.0137335)    );
  // itree = 1274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.77926,0.052187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515993,-0.00916234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475191,0.00991116) , 
1, 0.485532, 1, 0, 0.503209,-0.00755662) , 
1, -2.00144, 1, 0, 0.510401,-0.00477694)    );
  // itree = 1275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101103,0.00748108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335116,-0.0420665) , 
3, -1.28946, 1, 0, 0.238508,-0.0593853) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536977,0.0756669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659456,0.00877081) , 
2, -0.581808, 1, 0, 0.650126,0.0276012) , 
0, -0.947009, 1, 0, 0.514755,-0.00100638)    );
  // itree = 1276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227177,-0.0224504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0611491) , 
3, -0.0715217, 1, 0, 0.282168,-0.0387962) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.590123,-0.00220878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758729,0.0495201) , 
1, 1.72925, 1, 0, 0.598413,0.000271577) , 
0, -0.707105, 1, 0, 0.47577,-0.0148793)    );
  // itree = 1277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179068,-0.0593604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462515,-0.0340987) , 
3, 0.17816, 1, 0, 0.342158,-0.132324) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314639,-0.0183363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725785,0.00787673) , 
2, 0.224475, 1, 0, 0.475429,-0.0166349) , 
1, -1.6752, 1, 0, 0.465558,-0.0252037)    );
  // itree = 1278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364796,-0.0215748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284651,0.00438446) , 
1, 0.65094, 1, 0, 0.343704,-0.032052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.897854,0.0266226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757391,-0.016218) , 
1, -0.0924542, 1, 0, 0.821118,0.00410361) , 
3, 0.816421, 1, 0, 0.493659,-0.0206956)    );
  // itree = 1279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569039,0.0116121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326669,-0.027408) , 
1, 0.497567, 1, 0, 0.539737,0.0132876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352237,0.0254506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750941,0.0504566) , 
2, 0.209219, 1, 0, 0.486574,0.0711794) , 
1, 0.71376, 1, 0, 0.528417,0.0256151)    );
  // itree = 1280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281709,0.0469377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122664,-0.00337875) , 
1, 1.04114, 1, 0, 0.241555,0.0483513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530662,-0.0155172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643174,0.0147162) , 
1, 0.71376, 1, 0, 0.553873,-0.0194511) , 
2, -1.1665, 1, 0, 0.502573,-0.00831411)    );
  // itree = 1281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447804,0.0160001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285524,-0.0360452) , 
1, 1.71807, 1, 0, 0.43829,0.0229259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.609788,-0.0271574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.784784,0.0224677) , 
1, 0.736789, 1, 0, 0.645788,-0.0348678) , 
0, 0.611097, 1, 0, 0.508283,0.00343111)    );
  // itree = 1282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260204,-0.0172069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763692,0.0217024) , 
2, -0.224522, 1, 0, 0.559279,0.0136908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222543,-0.00592519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684798,-0.0209962) , 
3, 0.258794, 1, 0, 0.428776,-0.0277835) , 
1, -0.696094, 1, 0, 0.467506,-0.0154751)    );
  // itree = 1283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431094,0.0110194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626114,-0.0198095) , 
2, 0.732871, 1, 0, 0.453239,0.01526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401103,-0.0284072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.839086,-0.00113435) , 
3, 1.30946, 1, 0, 0.667055,-0.0342831) , 
0, 0.861216, 1, 0, 0.518764,7.71438e-05)    );
  // itree = 1284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278656,-0.0412809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277677,-0.00733702) , 
1, -0.610343, 1, 0, 0.278028,-0.0453669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65085,0.0105729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655236,-0.0250024) , 
0, 2.93412, 1, 0, 0.65115,0.0170037) , 
0, -0.811078, 1, 0, 0.512084,-0.00624251)    );
  // itree = 1285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357993,-0.00626065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68553,0.00747309) , 
0, 0.191798, 1, 0, 0.479559,-0.00184198) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.698674,0.0652962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880927,0.00198389) , 
3, 1.79354, 1, 0, 0.82914,0.0634281) , 
0, 2.41389, 1, 0, 0.511455,0.00411343)    );
  // itree = 1286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243063,-0.0145753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685025,0.00837466) , 
2, -0.224534, 1, 0, 0.498433,-0.00243832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247096,-0.0529294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650344,-0.0221782) , 
0, -0.582204, 1, 0, 0.468359,-0.0810593) , 
1, 1.17696, 1, 0, 0.494189,-0.0135345)    );
  // itree = 1287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494369,0.00506952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39682,-0.0161248) , 
1, 0.522288, 1, 0, 0.464142,-0.0025909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408584,-0.0477628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880553,0.0015285) , 
3, 2.26969, 1, 0, 0.63202,-0.0719117) , 
0, 2.58669, 1, 0, 0.476919,-0.00786671)    );
  // itree = 1288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500966,0.0269508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617902,-0.0115631) , 
0, -1.13804, 1, 0, 0.592746,-0.00611741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388589,0.00719856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74961,0.028817) , 
0, 0.387961, 1, 0, 0.537024,0.0337034) , 
1, -0.0254719, 1, 0, 0.566543,0.0126078)    );
  // itree = 1289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271191,-0.0150566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440571,0.0241157) , 
0, -0.729179, 1, 0, 0.351042,0.00870843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674256,-0.0382731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.852352,-0.00370112) , 
3, 1.28806, 1, 0, 0.779231,-0.0394595) , 
3, 0.736065, 1, 0, 0.479373,-0.00572783)    );
  // itree = 1290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579415,-0.0135185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604016,0.0115398) , 
1, -1.88956, 1, 0, 0.602399,0.0196667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355499,-0.0499639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435527,-0.0113055) , 
1, 0.237214, 1, 0, 0.427468,-0.0326376) , 
1, 0.0764505, 1, 0, 0.521433,-0.00454213)    );
  // itree = 1291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299769,0.0101827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387587,-0.0456672) , 
2, -0.162732, 1, 0, 0.329107,-0.0199847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674725,0.0296292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676403,0.000676807) , 
2, 0.345751, 1, 0, 0.675888,0.0207169) , 
0, 0.0848771, 1, 0, 0.492021,-0.000863501)    );
  // itree = 1292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290321,-0.0258558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618954,-0.0282554) , 
0, 0.167958, 1, 0, 0.449389,-0.06865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477884,0.00213856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528376,0.0198067) , 
1, 0.540316, 1, 0, 0.493448,0.0137388) , 
1, -1.65967, 1, 0, 0.491023,0.00920414)    );
  // itree = 1293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273647,0.120846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318762,0.0202142) , 
2, -1.9417, 1, 0, 0.299556,0.105185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295758,-0.016604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.713091,0.00654056) , 
2, -0.143729, 1, 0, 0.53739,-0.00758264) , 
0, -2.98821, 1, 0, 0.522742,-0.000637249)    );
  // itree = 1294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0646468,-0.0117923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48445,0.0314887) , 
3, -1.04414, 1, 0, 0.282493,0.0281247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196544,-0.0316507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73373,-0.00366784) , 
3, -0.036829, 1, 0, 0.633717,-0.0180929) , 
2, -0.281514, 1, 0, 0.496421,-2.61336e-05)    );
  // itree = 1295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274353,-0.0226959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584057,-0.00203603) , 
2, -1.19751, 1, 0, 0.540597,-0.0105677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468798,0.0346632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540832,-0.0350147) , 
0, 1.29297, 1, 0, 0.484945,0.0305859) , 
1, 0.345387, 1, 0, 0.520119,0.00457537)    );
  // itree = 1296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137023,-0.0186346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628572,0.0824641) , 
2, -1.76876, 1, 0, 0.353158,0.07135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530988,-0.00217488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424637,-0.033477) , 
1, 1.45051, 1, 0, 0.522991,-0.00894654) , 
0, -2.91712, 1, 0, 0.511628,-0.00357399)    );
  // itree = 1297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517012,-0.00290298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.904462,0.0448313) , 
0, 0.275712, 1, 0, 0.689613,0.0436159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166793,-0.0178607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68444,0.000416758) , 
3, -0.269563, 1, 0, 0.470788,-0.0123099) , 
1, -1.1775, 1, 0, 0.498215,-0.00530026)    );
  // itree = 1298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266509,0.0399977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262896,-0.0188121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662045,0.00416454) , 
2, -0.346484, 1, 0, 0.515502,-0.00752398) , 
0, -3.02048, 1, 0, 0.502857,-0.00305924)    );
  // itree = 1299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522367,0.0523375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73302,0.0131653) , 
2, -0.0690322, 1, 0, 0.662319,0.0533893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187281,0.0153648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577401,-0.00899025) , 
3, -0.639989, 1, 0, 0.458781,-0.00793511) , 
1, -1.44575, 1, 0, 0.479003,-0.00184244)    );
  // itree = 1300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0153401,-0.0590963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58505,0.00861012) , 
3, -1.67155, 1, 0, 0.530339,0.0105837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308134,0.00768016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567465,-0.0358007) , 
0, -0.183023, 1, 0, 0.44095,-0.0331134) , 
1, 0.524261, 1, 0, 0.502982,-0.00278915)    );
  // itree = 1301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0534879,-0.0498969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952219,0.00762757) , 
1, -0.440679, 1, 0, 0.0788217,-0.032199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52662,0.0250388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57747,0.00379641) , 
0, -1.37049, 1, 0, 0.570461,0.0142278) , 
3, -1.22591, 1, 0, 0.483188,0.00598644)    );
  // itree = 1302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459027,-0.00715464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487266,0.0196556) , 
1, 0.415193, 1, 0, 0.468734,0.0018939) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.816265,0.0300487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589425,-0.00879302) , 
1, 0.728565, 1, 0, 0.759027,0.0475486) , 
0, 1.63755, 1, 0, 0.522399,0.0103339)    );
  // itree = 1303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314209,-0.00390006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526305,-0.0221897) , 
0, -0.5917, 1, 0, 0.433994,-0.0295967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.725162,0.0475278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760571,-0.00150573) , 
0, 0.879177, 1, 0, 0.753278,0.0200002) , 
2, 1.04815, 1, 0, 0.481326,-0.0222444)    );
  // itree = 1304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206995,-0.0174948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423366,0.0394033) , 
0, -1.94056, 1, 0, 0.335105,0.0305469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485197,-0.0239412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.865421,0.00657467) , 
3, 0.987428, 1, 0, 0.661013,-0.0277208) , 
2, -0.281514, 1, 0, 0.53703,-0.00555438)    );
  // itree = 1305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.889342,0.0996613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523944,-0.000137404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445476,-0.0151487) , 
1, -0.0142557, 1, 0, 0.4852,-0.0153499) , 
1, -2.04766, 1, 0, 0.49801,-0.00908386)    );
  // itree = 1306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0574596,-0.0171009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541578,0.027512) , 
3, -1.21708, 1, 0, 0.31818,0.0236079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385095,-0.0196575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796618,0.0108884) , 
3, 0.775204, 1, 0, 0.579395,-0.0136362) , 
0, -0.882766, 1, 0, 0.502496,-0.00267187)    );
  // itree = 1307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508959,0.016554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623677,-0.0162222) , 
0, 1.15056, 1, 0, 0.540756,0.0143228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370667,-0.0323185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570435,0.0209498) , 
1, 1.41969, 1, 0, 0.4175,-0.0404349) , 
1, 0.522288, 1, 0, 0.50233,-0.00274832)    );
  // itree = 1308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.646877,0.000927045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446396,-0.0574279) , 
1, -1.74177, 1, 0, 0.554158,-0.0712627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342674,0.087241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494306,0.00946143) , 
2, -1.99878, 1, 0, 0.489846,0.0222392) , 
1, -1.50845, 1, 0, 0.495305,0.0143022)    );
  // itree = 1309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411414,-0.0357803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544988,0.0115464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235132,-0.0298243) , 
1, 1.95304, 1, 0, 0.530715,0.0186578) , 
1, -1.81119, 1, 0, 0.523348,0.0113373)    );
  // itree = 1310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157812,-0.0107447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405494,0.0688474) , 
2, -1.59049, 1, 0, 0.261367,0.0384492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588785,-0.00322276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508268,-0.025108) , 
1, 0.641961, 1, 0, 0.570147,-0.016786) , 
2, -1.2061, 1, 0, 0.527524,-0.00916147)    );
  // itree = 1311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285412,0.0971867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148941,0.00189859) , 
1, -0.863434, 1, 0, 0.171276,0.0237574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263164,-0.0263579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624941,-0.00151436) , 
2, -0.61861, 1, 0, 0.565175,-0.0122081) , 
2, -1.13063, 1, 0, 0.490824,-0.00541934)    );
  // itree = 1312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159476,-0.00451049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380861,-0.0405274) , 
3, -0.648409, 1, 0, 0.248292,-0.0456722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672913,0.00969778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647156,-0.0190963) , 
1, 1.31099, 1, 0, 0.67083,0.0148492) , 
2, -0.319459, 1, 0, 0.515512,-0.00739739)    );
  // itree = 1313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209241,0.0020003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163553,-0.0219459) , 
2, -0.941011, 1, 0, 0.186205,-0.0195765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711268,-0.00140519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699078,0.0285089) , 
1, 0.345387, 1, 0, 0.706916,0.0186323) , 
3, -0.210183, 1, 0, 0.50571,0.00386821)    );
  // itree = 1314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382963,-0.0275118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802837,0.00559971) , 
2, 0.832716, 1, 0, 0.470317,-0.0438605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541211,0.0126553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.444702,-0.0244517) , 
1, 1.32452, 1, 0, 0.521883,0.00822952) , 
1, -0.3195, 1, 0, 0.4988,-0.0150887)    );
  // itree = 1315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0788624,0.0131818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198812,0.0521523) , 
3, -1.53799, 1, 0, 0.131926,0.0360095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284659,-0.0194575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738007,3.64351e-05) , 
3, -0.0480398, 1, 0, 0.573424,-0.0169125) , 
3, -1.1241, 1, 0, 0.499654,-0.00806977)    );
  // itree = 1316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198124,-0.0476339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214708,-0.00471942) , 
1, -0.281116, 1, 0, 0.208547,-0.0689193) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560365,5.12985e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624307,0.0272112) , 
1, 0.71376, 1, 0, 0.573574,0.0111766) , 
0, -2.834, 1, 0, 0.542754,0.00441383)    );
  // itree = 1317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200661,-0.0110236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516352,-0.0486265) , 
3, -0.0320456, 1, 0, 0.251515,-0.0339281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666347,-0.0248503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715447,0.0191334) , 
1, -1.86956, 1, 0, 0.712623,0.0308533) , 
2, -0.155261, 1, 0, 0.496813,0.000534066)    );
  // itree = 1318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63168,0.014636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493629,-0.011108) , 
1, -1.38535, 1, 0, 0.522622,-0.01046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0278566,-0.0392338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65281,0.0206129) , 
3, -1.09573, 1, 0, 0.54815,0.0288715) , 
1, 0.0462137, 1, 0, 0.534438,0.00774545)    );
  // itree = 1319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0967015,-0.0441785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0924659,-0.0150217) , 
1, 0.0325634, 1, 0, 0.0945363,-0.0609291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350862,0.0535567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533195,-0.000252518) , 
0, -2.53168, 1, 0, 0.524422,0.00426824) , 
2, -1.64509, 1, 0, 0.489183,-0.00107618)    );
  // itree = 1320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532134,0.0245516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708082,-0.0273185) , 
2, 0.82457, 1, 0, 0.573003,0.0270943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389432,-0.0166214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442613,0.00311521) , 
1, 0.867116, 1, 0, 0.405617,-0.0200027) , 
1, -0.36158, 1, 0, 0.466423,-0.0028937)    );
  // itree = 1321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135462,-0.00862715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474549,-0.061365) , 
3, -1.10726, 1, 0, 0.23973,-0.0653608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.571434,-0.0121964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544007,0.00476406) , 
1, -0.805159, 1, 0, 0.552307,-0.000264931) , 
0, -1.4678, 1, 0, 0.49027,-0.0131844)    );
  // itree = 1322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0911094,-0.0463101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175181,-0.00241988) , 
0, -2.16246, 1, 0, 0.136442,-0.049196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.594031,0.0717101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570947,0.000566108) , 
0, -1.85348, 1, 0, 0.572042,0.00776885) , 
2, -1.0546, 1, 0, 0.486641,-0.00339928)    );
  // itree = 1323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213393,0.0463033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228259,0.0117206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65268,-0.00366435) , 
3, -0.260798, 1, 0, 0.512034,0.00112979) , 
2, -1.99878, 1, 0, 0.504107,0.00313495)    );
  // itree = 1324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253326,-0.0296103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218747,-0.00781104) , 
1, -1.59412, 1, 0, 0.222116,-0.021607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.802946,0.0179145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743305,-0.0179579) , 
2, 1.02031, 1, 0, 0.785432,0.0100542) , 
3, 0.093663, 1, 0, 0.511344,-0.00535085)    );
  // itree = 1325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1689,-0.0280594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578722,0.0173181) , 
2, -0.65494, 1, 0, 0.302105,-0.0291349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485698,-0.000682245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73285,0.015642) , 
0, 0.670837, 1, 0, 0.610364,0.0158675) , 
0, -0.838864, 1, 0, 0.507239,0.000812357)    );
  // itree = 1326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.69653,0.0986645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54291,-0.0166946) , 
2, -0.0794182, 1, 0, 0.608162,0.101458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48465,-0.014331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319811,-0.0482499) , 
1, 1.45809, 1, 0, 0.469986,-0.0349434) , 
1, -1.81119, 1, 0, 0.478933,-0.0261113)    );
  // itree = 1327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310649,0.00817546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736102,-0.0136185) , 
3, 0.17816, 1, 0, 0.521317,-0.00514064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376174,0.078407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65027,0.0216304) , 
0, -0.771506, 1, 0, 0.546699,0.0759063) , 
1, 1.31099, 1, 0, 0.523601,0.00215473)    );
  // itree = 1328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346953,0.00288081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369603,0.0488198) , 
1, 0.999571, 1, 0, 0.350804,0.0206079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403737,-0.0343698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678848,0.00367654) , 
0, 0.0506064, 1, 0, 0.595901,-0.017774) , 
0, -0.691462, 1, 0, 0.509889,-0.00430458)    );
  // itree = 1329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159872,-0.0121683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477877,0.0248779) , 
2, -0.90178, 1, 0, 0.316468,0.0111976) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475361,-0.0483264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716334,-0.00129438) , 
2, 0.554149, 1, 0, 0.615805,-0.0375912) , 
2, -0.035577, 1, 0, 0.463997,-0.0128482)    );
  // itree = 1330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536282,-0.00287639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520568,0.018884) , 
1, -0.588845, 1, 0, 0.52598,0.02084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458259,-0.0361133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541846,0.0140386) , 
1, 1.61485, 1, 0, 0.499676,-0.0290141) , 
1, 1.17696, 1, 0, 0.522529,0.0142988)    );
  // itree = 1331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105341,-0.0529207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116101,-0.0134427) , 
1, 0.317366, 1, 0, 0.11046,-0.0811211) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405975,0.0182005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664732,-0.00761947) , 
0, 0.372634, 1, 0, 0.521133,0.0103693) , 
0, -2.98821, 1, 0, 0.498919,0.00542033)    );
  // itree = 1332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230919,0.0796817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177523,0.0164195) , 
2, -2.22254, 1, 0, 0.189189,0.0444595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375801,-0.0110433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8,0.0063823) , 
3, 0.534955, 1, 0, 0.561092,-0.00824732) , 
2, -1.29367, 1, 0, 0.505756,-0.000404995)    );
  // itree = 1333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102681,-0.0454775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570398,0.00548531) , 
2, -1.23141, 1, 0, 0.498535,-0.00587133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340205,0.0593517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692343,-0.0095529) , 
3, 0.228801, 1, 0, 0.510999,0.0438439) , 
1, 0.313122, 1, 0, 0.502907,0.0115674)    );
  // itree = 1334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422473,-0.02041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431181,0.0128223) , 
1, 0.988758, 1, 0, 0.424105,-0.029132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578789,-0.00338442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841332,0.0276168) , 
2, 0.910375, 1, 0, 0.704939,0.0255297) , 
0, 0.861216, 1, 0, 0.507801,-0.0128414)    );
  // itree = 1335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0824983,-0.0125713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227651,0.036376) , 
2, -1.71739, 1, 0, 0.181924,0.0316764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608702,0.000984544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634525,-0.0205576) , 
0, 1.94849, 1, 0, 0.612792,-0.00612491) , 
3, -0.716903, 1, 0, 0.506684,0.00318423)    );
  // itree = 1336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252131,0.00523192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718872,0.0327376) , 
3, 0.135518, 1, 0, 0.358057,0.0246048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.888944,-0.0047116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732976,-0.0413653) , 
1, -0.646321, 1, 0, 0.775338,-0.0588223) , 
3, 0.816421, 1, 0, 0.48242,-0.000259093)    );
  // itree = 1337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224117,0.0249606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441895,-0.0167667) , 
2, -1.67492, 1, 0, 0.423439,-0.0296387) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.812984,0.0436603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8372,-0.0108045) , 
3, 1.7789, 1, 0, 0.828333,0.0346279) , 
2, 1.49137, 1, 0, 0.455614,-0.0245318)    );
  // itree = 1338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0299352,-0.051747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538794,0.00301544) , 
2, -2.0544, 1, 0, 0.520764,0.00260759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387529,-0.0426631) , 
1, 1.59425, 1, 0, 0.513523,-0.00292327)    );
  // itree = 1339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126139,-0.047582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561922,-0.0265257) , 
0, -1.22757, 1, 0, 0.376234,-0.0853896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539492,0.0166713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457855,-0.0139979) , 
1, 0.770251, 1, 0, 0.517496,0.0144238) , 
1, -1.6752, 1, 0, 0.507299,0.00721854)    );
  // itree = 1340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49518,0.0302085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214682,-0.024964) , 
1, -0.643735, 1, 0, 0.28743,-0.0204736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347583,-0.0175077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752458,0.0206095) , 
2, -0.162794, 1, 0, 0.667855,0.028045) , 
0, -0.301425, 1, 0, 0.490972,0.0054858)    );
  // itree = 1341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283117,0.0174932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525783,-0.0161628) , 
0, -1.4678, 1, 0, 0.472626,-0.0211094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.731618,0.0945207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453443,0.00337738) , 
1, 1.82502, 1, 0, 0.566886,0.0865132) , 
1, 1.45051, 1, 0, 0.47893,-0.0139112)    );
  // itree = 1342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187624,0.0136041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504677,-0.0211903) , 
3, -0.633742, 1, 0, 0.363388,-0.0178158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642354,-0.0213573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726415,0.0210917) , 
1, -0.890715, 1, 0, 0.705283,0.0213368) , 
2, 0.224475, 1, 0, 0.501423,-0.00200857)    );
  // itree = 1343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473036,0.00517341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81978,0.0569291) , 
0, 0.00274808, 1, 0, 0.652761,0.0577351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196604,0.00394417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627711,-0.0194113) , 
3, -0.147314, 1, 0, 0.44837,-0.024537) , 
1, -0.493896, 1, 0, 0.514128,0.00193205)    );
  // itree = 1344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48602,0.0288593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.749355,-0.00234172) , 
2, 0.329473, 1, 0, 0.608265,0.0262216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443631,-0.00624065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525027,-0.0555663) , 
0, 2.31098, 1, 0, 0.448746,-0.0209542) , 
1, 0.107402, 1, 0, 0.532542,0.00382753)    );
  // itree = 1345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283207,-0.00632569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289834,0.0363102) , 
1, 0.620065, 1, 0, 0.285329,0.0119533) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292478,-0.0328426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636756,-0.00669602) , 
2, -0.146093, 1, 0, 0.562014,-0.0255696) , 
2, -0.620353, 1, 0, 0.483955,-0.0149836)    );
  // itree = 1346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139917,-0.0484753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585218,-0.0165783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540958,0.0173527) , 
1, -1.37246, 1, 0, 0.545748,0.0270755) , 
0, -3.14395, 1, 0, 0.525391,0.0208317)    );
  // itree = 1347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222713,-0.0170483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617292,0.0328761) , 
0, -0.394048, 1, 0, 0.273392,-0.0213454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.665344,0.0162735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710315,-0.0147813) , 
0, 1.60455, 1, 0, 0.679556,0.00911168) , 
2, -0.41835, 1, 0, 0.533992,-0.00180375)    );
  // itree = 1348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466673,0.0339943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842021,0.00558288) , 
3, 0.269552, 1, 0, 0.669475,0.0315171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481742,-0.0187422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49124,0.00622046) , 
1, -0.35579, 1, 0, 0.489725,0.00397415) , 
1, -0.741213, 1, 0, 0.536537,0.0111471)    );
  // itree = 1349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258799,-0.00268593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787114,0.0250718) , 
3, -0.127685, 1, 0, 0.583145,0.0278733) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460348,-0.00203098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659094,-0.0473448) , 
0, 2.30263, 1, 0, 0.472842,-0.010852) , 
1, 0.126794, 1, 0, 0.53604,0.0113357)    );
  // itree = 1350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339171,0.00824399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353312,0.0492337) , 
1, 1.40492, 1, 0, 0.340348,0.0210366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508306,-0.020296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.895779,0.0112816) , 
3, 1.65708, 1, 0, 0.591756,-0.0332621) , 
2, -0.0765418, 1, 0, 0.473865,-0.00780017)    );
  // itree = 1351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241536,-0.0451158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719318,0.000716036) , 
0, 0.132542, 1, 0, 0.425045,-0.0695883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174907,-0.024341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549008,0.00135729) , 
0, -2.3109, 1, 0, 0.512308,-0.0028101) , 
1, -1.29429, 1, 0, 0.499438,-0.0126594)    );
  // itree = 1352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33725,-0.00138202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373969,-0.0215721) , 
0, -0.189637, 1, 0, 0.346665,-0.0160994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.773926,0.0402055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.795104,-0.00541412) , 
3, 0.853329, 1, 0, 0.791495,0.00881302) , 
3, 0.660704, 1, 0, 0.493359,-0.00788389)    );
  // itree = 1353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154434,-0.00979068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346176,-0.0346138) , 
3, -0.724203, 1, 0, 0.205165,-0.0391492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572739,-0.00243819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663509,0.018422) , 
1, 0.236115, 1, 0, 0.603806,0.0100047) , 
2, -0.767121, 1, 0, 0.497291,-0.00312907)    );
  // itree = 1354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305761,0.042434) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525715,-0.00833799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355185,-0.0405987) , 
1, 1.39807, 1, 0, 0.509243,-0.0262394) , 
0, -3.18592, 1, 0, 0.501687,-0.0214858)    );
  // itree = 1355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.071464,-0.0615209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.062893,-0.0481784) , 
1, 0.338353, 1, 0, 0.0669051,-0.116495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257914,0.0121329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581651,-0.0150353) , 
2, -0.706322, 1, 0, 0.500029,-0.0193052) , 
0, -3.03185, 1, 0, 0.472821,-0.0254105)    );
  // itree = 1356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27191,0.0435807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478863,-0.00439967) , 
2, -1.86939, 1, 0, 0.466742,-0.00338889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.706313,0.0722669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723675,0.00898547) , 
2, 0.372188, 1, 0, 0.721111,0.0419105) , 
0, 1.31048, 1, 0, 0.520838,0.00624489)    );
  // itree = 1357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.734121,0.0698146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537287,-0.0224596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538183,0.0114332) , 
1, -1.55676, 1, 0, 0.538139,0.0197844) , 
1, -1.86485, 1, 0, 0.544892,0.0230478)    );
  // itree = 1358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357011,-0.0350492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101219,-0.0330849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546972,0.0033117) , 
0, -3.02048, 1, 0, 0.518657,0.00164854) , 
1, -1.88482, 1, 0, 0.509936,-0.00302692)    );
  // itree = 1359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468358,-0.00234116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438025,0.018354) , 
1, 0.465185, 1, 0, 0.459203,0.00566357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516821,-0.0793595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769894,0.000851156) , 
0, 1.20931, 1, 0, 0.703892,-0.0380456) , 
2, 1.0954, 1, 0, 0.492014,-0.000197492)    );
  // itree = 1360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619328,0.00125018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52243,-0.0480325) , 
1, -1.05687, 1, 0, 0.572287,-0.0424711) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466312,-0.0039117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556208,0.0234223) , 
1, 0.577791, 1, 0, 0.501794,0.0143536) , 
1, -0.577244, 1, 0, 0.523279,-0.00296589)    );
  // itree = 1361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470475,0.0103434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687141,-0.0184069) , 
2, 0.799265, 1, 0, 0.525254,0.00536632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144513,-0.0494765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595878,-0.00621243) , 
0, -1.15184, 1, 0, 0.420685,-0.0458565) , 
1, 0.463922, 1, 0, 0.496069,-0.00892989)    );
  // itree = 1362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502967,-0.0057857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481238,0.0111208) , 
1, 0.0113807, 1, 0, 0.495736,-0.00106018) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295102,-0.0110053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607952,-0.0388238) , 
3, 0.728524, 1, 0, 0.411119,-0.0524352) , 
1, 0.974762, 1, 0, 0.482976,-0.00880756)    );
  // itree = 1363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.605486,-0.00563868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620436,0.0347953) , 
1, -1.25268, 1, 0, 0.616125,0.0463628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18609,-0.0382221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607806,0.00422258) , 
2, -0.476547, 1, 0, 0.415663,-0.0306828) , 
1, 0.107402, 1, 0, 0.51624,0.00797294)    );
  // itree = 1364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.624629,0.027159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517706,0.00104079) , 
1, -0.974485, 1, 0, 0.538528,0.0111169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120276,0.0254001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383433,-0.0348294) , 
3, -0.615385, 1, 0, 0.294071,-0.0393703) , 
1, 1.32658, 1, 0, 0.50765,0.00473972)    );
  // itree = 1365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147396,-0.0278091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50358,0.00799851) , 
2, -1.0578, 1, 0, 0.398522,-0.00398414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507551,-0.0247709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924316,0.0149612) , 
3, 1.87118, 1, 0, 0.611353,-0.0377662) , 
2, 0.380334, 1, 0, 0.475492,-0.0162013)    );
  // itree = 1366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544801,0.0066805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423559,-0.0180043) , 
1, 0.42625, 1, 0, 0.504277,-0.00529683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447715,0.0655268) , 
1, 2.09327, 1, 0, 0.502507,-0.00112729)    );
  // itree = 1367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264326,0.114609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186355,-0.0207539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605987,0.00590135) , 
2, -0.778377, 1, 0, 0.507634,-0.000613103) , 
2, -1.97463, 1, 0, 0.50069,0.004087)    );
  // itree = 1368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290006,0.0727446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124441,-0.0157762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716845,0.0103827) , 
3, -0.371768, 1, 0, 0.534085,0.00706686) , 
2, -1.97542, 1, 0, 0.527609,0.0103558)    );
  // itree = 1369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325804,-0.00882729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252184,-0.025426) , 
0, 0.366636, 1, 0, 0.31404,-0.0267184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.801063,-0.0314507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831515,0.0142238) , 
1, -0.876513, 1, 0, 0.824524,0.0107602) , 
3, 0.684423, 1, 0, 0.473276,-0.0150277)    );
  // itree = 1370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265904,0.00407268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442437,-0.0333387) , 
3, 0.0838734, 1, 0, 0.314587,-0.0191892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.846489,0.022448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7298,-0.0279584) , 
2, 1.64143, 1, 0, 0.826342,0.0280022) , 
3, 0.666081, 1, 0, 0.485551,-0.00342376)    );
  // itree = 1371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038004,-0.0292947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56944,0.00716651) , 
3, -1.67155, 1, 0, 0.527081,0.0108081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645809,0.0557928) , 
1, 2.05781, 1, 0, 0.530681,0.0152924)    );
  // itree = 1372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222741,-0.00398078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.088746,-0.0562405) , 
1, 1.12211, 1, 0, 0.200581,-0.0250172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586903,0.0154423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673784,-0.0222096) , 
0, 2.69361, 1, 0, 0.594106,0.022411) , 
0, -1.66855, 1, 0, 0.51303,0.0126396)    );
  // itree = 1373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200435,0.0231614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184549,0.121034) , 
2, -1.83371, 1, 0, 0.192888,0.0781933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170073,-0.0149128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.686483,0.0121477) , 
3, -0.551675, 1, 0, 0.529352,0.00866881) , 
3, -1.75202, 1, 0, 0.509863,0.0126958)    );
  // itree = 1374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442468,-0.0175442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511923,0.0143396) , 
1, 1.24487, 1, 0, 0.450316,-0.0275306) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.727036,-0.0227776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788614,0.0237646) , 
1, -0.924068, 1, 0, 0.773931,0.0267997) , 
2, 1.13903, 1, 0, 0.500424,-0.0191183)    );
  // itree = 1375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510857,-0.00112931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399992,-0.0198341) , 
1, 0.369255, 1, 0, 0.478983,-0.0126725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.697191,0.0651197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531012,0.0262274) , 
1, 1.65523, 1, 0, 0.606966,0.0854898) , 
1, 1.4007, 1, 0, 0.487754,-0.00594477)    );
  // itree = 1376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387922,0.0245174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189989,-0.00388326) , 
1, -0.523981, 1, 0, 0.249134,0.00994949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.672357,-0.0256189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761947,0.0067184) , 
2, 0.50513, 1, 0, 0.721379,-0.0168632) , 
3, 0.135748, 1, 0, 0.471802,-0.00269289)    );
  // itree = 1377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326914,-0.00465389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118907,-0.0547794) , 
1, 1.39446, 1, 0, 0.293897,-0.0251821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634221,0.0202722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663549,-0.0115188) , 
0, 1.08655, 1, 0, 0.646039,0.0139768) , 
0, -0.796857, 1, 0, 0.511815,-0.000949257)    );
  // itree = 1378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243908,-0.00208944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468285,-0.0339771) , 
3, 0.06156, 1, 0, 0.277842,-0.0168322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.752607,-0.000420889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808427,0.0377876) , 
1, 0.621989, 1, 0, 0.765629,0.0182567) , 
3, 0.392653, 1, 0, 0.469128,-0.00307206)    );
  // itree = 1379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48758,-0.00984756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538206,0.0103794) , 
1, 0.871189, 1, 0, 0.49533,-0.0137606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719443,0.0495801) , 
1, 1.89, 1, 0, 0.501279,-0.0109775)    );
  // itree = 1380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567818,-0.00103972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390318,-0.0223749) , 
1, -0.492511, 1, 0, 0.495836,-0.0217895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269697,-0.00597858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692334,0.0275697) , 
0, -0.896003, 1, 0, 0.536901,0.0321912) , 
1, 0.0462137, 1, 0, 0.515109,0.00354577)    );
  // itree = 1381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324258,0.0483122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50676,0.00288591) , 
0, -2.405, 1, 0, 0.489065,0.0143859) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395659,-0.0312466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457023,0.00274779) , 
1, 0.536119, 1, 0, 0.437578,-0.0187474) , 
1, 0.24729, 1, 0, 0.467678,0.000622998)    );
  // itree = 1382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382423,-0.00155826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666816,0.027812) , 
2, 0.118114, 1, 0, 0.485089,0.0188815) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.797946,0.00962063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631436,-0.0423692) , 
1, 0.163133, 1, 0, 0.732388,-0.0327936) , 
2, 0.999858, 1, 0, 0.522979,0.010964)    );
  // itree = 1383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126745,-0.022467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659926,0.0166231) , 
3, -0.683307, 1, 0, 0.54339,0.0148483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249889,0.0274228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503472,-0.0222582) , 
2, -0.695418, 1, 0, 0.428653,-0.0226925) , 
1, -0.164574, 1, 0, 0.479811,-0.00595424)    );
  // itree = 1384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497051,0.0567715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561859,0.0122084) , 
0, -2.94289, 1, 0, 0.558168,0.030574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390744,-0.0176925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.896805,0.0325026) , 
3, 1.54397, 1, 0, 0.473295,-0.0211219) , 
1, 0.0411464, 1, 0, 0.517043,0.00552495)    );
  // itree = 1385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330217,-0.0472538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37974,-0.00986399) , 
1, -1.85772, 1, 0, 0.376679,-0.0270684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.685813,0.03926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697039,-0.00333982) , 
0, 1.4142, 1, 0, 0.691755,0.0280562) , 
0, 0.0678113, 1, 0, 0.513189,-0.00318504)    );
  // itree = 1386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0395903,-0.0389052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463829,0.041632) , 
3, -1.71157, 1, 0, 0.325954,0.0416921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445376,-0.0474215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580783,-0.00984759) , 
1, -1.81119, 1, 0, 0.568897,-0.02949) , 
2, -0.73641, 1, 0, 0.510797,-0.0124666)    );
  // itree = 1387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488978,-6.29062e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688668,-0.0930285) , 
2, 1.81563, 1, 0, 0.496187,-0.00523751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32767,-0.0206496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640096,-0.0961825) , 
0, 0.294561, 1, 0, 0.457262,-0.0978109) , 
1, 1.54842, 1, 0, 0.493529,-0.0115587)    );
  // itree = 1388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545613,-0.0357751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257392,0.0100856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629337,-0.00866232) , 
3, -0.207894, 1, 0, 0.470467,-0.00276745) , 
1, -1.88482, 1, 0, 0.473854,-0.00628564)    );
  // itree = 1389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183675,-0.0129788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708949,0.000699028) , 
3, -0.234495, 1, 0, 0.492676,-0.00864647) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480105,0.032217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59752,-0.0158041) , 
0, 0.733539, 1, 0, 0.515498,0.0291826) , 
1, 0.976475, 1, 0, 0.496142,-0.00290137)    );
  // itree = 1390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191405,0.00752872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473159,-0.0385025) , 
3, -0.374527, 1, 0, 0.291499,-0.0235217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704444,0.0535045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72955,0.00652749) , 
0, 0.107181, 1, 0, 0.722882,0.0332278) , 
2, -0.0989813, 1, 0, 0.507271,0.00486374)    );
  // itree = 1391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0780836,-0.0210163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468218,0.0202471) , 
3, -1.46022, 1, 0, 0.325224,0.0151525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408443,-0.0325313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.633383,-0.0117767) , 
2, 0.14237, 1, 0, 0.577094,-0.0349904) , 
2, -0.281514, 1, 0, 0.482213,-0.0161013)    );
  // itree = 1392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113926,-3.2114e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381699,0.0238413) , 
3, -0.802175, 1, 0, 0.220707,0.0226938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477207,-0.0278169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832509,0.00312009) , 
3, 0.452469, 1, 0, 0.709536,-0.0186474) , 
3, -0.207894, 1, 0, 0.514413,-0.00214543)    );
  // itree = 1393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419137,0.0330893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588367,-0.0227737) , 
2, -1.0677, 1, 0, 0.56807,-0.0336556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310959,-0.0134289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782837,0.0235635) , 
0, 0.108678, 1, 0, 0.51987,0.00853653) , 
1, -0.362514, 1, 0, 0.539895,-0.00899246)    );
  // itree = 1394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.092927,-0.000415204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56161,0.0247357) , 
3, -1.08398, 1, 0, 0.447653,0.03958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791458,-0.0441027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.843954,-0.00082995) , 
2, 0.691662, 1, 0, 0.828336,-0.0206537) , 
3, 1.05752, 1, 0, 0.543361,0.0244366)    );
  // itree = 1395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399938,0.00526473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288859,-0.0234474) , 
1, 0.219347, 1, 0, 0.352144,-0.0143986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.702393,0.0418993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723537,-0.00254836) , 
2, 0.27652, 1, 0, 0.717879,0.0181091) , 
0, 0.0678113, 1, 0, 0.518193,0.000360327)    );
  // itree = 1396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299495,0.00878085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671427,-0.0111161) , 
3, 0.093663, 1, 0, 0.498304,-0.00458334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265986,-0.05077) , 
1, 1.98002, 1, 0, 0.490783,-0.00937461)    );
  // itree = 1397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0697994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172366,0.0324803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527997,-0.0140876) , 
3, -1.37705, 1, 0, 0.494087,-0.0217537) , 
2, -2.0043, 1, 0, 0.479715,-0.0253436)    );
  // itree = 1398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561414,0.00224488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485156,-0.042436) , 
1, -1.32827, 1, 0, 0.534246,-0.0281045) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550875,0.0176835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47256,-0.011705) , 
1, 0.904167, 1, 0, 0.531873,0.018459) , 
1, -1.03486, 1, 0, 0.532368,0.00874075)    );
  // itree = 1399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189947,-0.0221552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508368,0.034307) , 
0, -1.71829, 1, 0, 0.39197,0.0273541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505157,-0.0136802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.900803,0.014119) , 
3, 1.39467, 1, 0, 0.625739,-0.0125849) , 
0, -0.245546, 1, 0, 0.522137,0.0051154)    );
  // itree = 1400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321499,0.013586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418398,0.0583129) , 
1, 0.520617, 1, 0, 0.351731,0.0487669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559576,-0.00852306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.498537,-0.0310514) , 
1, 0.662387, 1, 0, 0.544899,-0.0302688) , 
0, -1.02119, 1, 0, 0.492147,-0.00868529)    );
  // itree = 1401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19397,-0.017722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542599,0.0125451) , 
0, -1.62592, 1, 0, 0.441917,0.0104817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580845,-0.0160239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.904137,0.0113359) , 
3, 1.74448, 1, 0, 0.690442,-0.0183558) , 
0, 0.764784, 1, 0, 0.522779,0.00109891)    );
  // itree = 1402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674273,0.013329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488624,-0.0187047) , 
1, -0.906961, 1, 0, 0.561667,-0.0158439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46526,0.0262402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524305,-0.00913123) , 
0, 1.23253, 1, 0, 0.480728,0.0312275) , 
1, -0.0229864, 1, 0, 0.52128,0.00764361)    );
  // itree = 1403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137283,-0.0505719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117741,0.00567186) , 
1, 0.301203, 1, 0, 0.126763,-0.0492909) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437984,0.0102619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758931,0.00034352) , 
3, 0.544988, 1, 0, 0.590505,0.0123019) , 
2, -1.16796, 1, 0, 0.503339,0.000724736)    );
  // itree = 1404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0845214,0.0324011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403726,-0.0169916) , 
3, -1.83098, 1, 0, 0.381029,-0.0313493) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674835,0.043317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728601,0.009684) , 
2, 0.207846, 1, 0, 0.720702,0.0328232) , 
0, 1.32897, 1, 0, 0.462437,-0.0159693)    );
  // itree = 1405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264504,-0.0281384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667231,-0.0105199) , 
2, 0.68785, 1, 0, 0.434006,-0.0461667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448504,0.0153471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620501,0.000972918) , 
0, 0.594031, 1, 0, 0.51635,0.0179811) , 
1, -1.6752, 1, 0, 0.509721,0.0128167)    );
  // itree = 1406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543234,0.077628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679588,0.0203734) , 
2, -0.757474, 1, 0, 0.663042,0.0479721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0959025,0.0336063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511905,-0.0203346) , 
2, -1.5647, 1, 0, 0.463985,-0.0352316) , 
1, -0.633389, 1, 0, 0.521567,-0.0111628)    );
  // itree = 1407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386905,-0.0462037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353749,0.0208012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503018,-0.00247664) , 
0, -1.74276, 1, 0, 0.481649,0.00061432) , 
1, -1.81885, 1, 0, 0.476179,-0.00479677)    );
  // itree = 1408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0893736,-0.0307664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395991,0.0446212) , 
2, -1.9849, 1, 0, 0.337173,0.0423795) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53671,-0.00956807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607867,0.0103321) , 
1, -0.0246959, 1, 0, 0.567265,-0.0025918) , 
0, -1.60723, 1, 0, 0.524833,0.00570148)    );
  // itree = 1409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496039,0.0336908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.698823,0.0140086) , 
0, -1.22038, 1, 0, 0.652166,0.0383819) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328049,0.00652122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718187,-0.0204837) , 
3, 0.699898, 1, 0, 0.456207,-0.00489718) , 
1, -0.759733, 1, 0, 0.506869,0.00629179)    );
  // itree = 1410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164963,-0.0642869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195085,-0.0185645) , 
1, -0.787796, 1, 0, 0.188356,-0.0611437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577752,-0.0074784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614928,0.0185879) , 
1, 0.345387, 1, 0, 0.589869,0.00197819) , 
2, -0.724736, 1, 0, 0.494901,-0.0129517)    );
  // itree = 1411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0299526,-0.0392502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573964,0.0201045) , 
3, -2.1876, 1, 0, 0.549843,0.0335083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420104,-0.0221165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645966,0.0415404) , 
1, 1.95703, 1, 0, 0.449253,-0.031217) , 
1, 0.823393, 1, 0, 0.527426,0.019084)    );
  // itree = 1412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.705022,0.0398704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46819,-0.0283598) , 
1, -1.92433, 1, 0, 0.500001,-0.04461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294126,0.0317317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554594,0.00276394) , 
2, -1.09958, 1, 0, 0.504166,0.0167181) , 
1, -0.887646, 1, 0, 0.503049,0.000264228)    );
  // itree = 1413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501828,-0.00413403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563976,0.0185422) , 
1, 0.350368, 1, 0, 0.514862,0.000943602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247246,-0.0420898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779418,0.0113725) , 
3, 1.15648, 1, 0, 0.359079,-0.0717443) , 
1, 0.989266, 1, 0, 0.490644,-0.0103563)    );
  // itree = 1414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269318,-0.0478617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459729,0.00387098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853966,-0.0226905) , 
3, 1.5996, 1, 0, 0.509051,0.00270817) , 
1, -1.87359, 1, 0, 0.497514,-0.00256254)    );
  // itree = 1415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435585,0.0233748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.798394,0.0533906) , 
0, 0.108585, 1, 0, 0.580161,0.068373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500129,-0.00997996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462484,0.022545) , 
1, 0.959972, 1, 0, 0.493788,-0.00965202) , 
1, -1.31849, 1, 0, 0.503209,-0.00114105)    );
  // itree = 1416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155596,-0.0414553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282704,-0.000299615) , 
1, -1.0491, 1, 0, 0.264142,-0.0174608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476331,0.0228717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779754,-0.00266182) , 
3, 0.661481, 1, 0, 0.640049,0.0198292) , 
2, -0.531879, 1, 0, 0.510591,0.006987)    );
  // itree = 1417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.067829,-0.0187239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.066281,-0.0601256) , 
3, -1.4305, 1, 0, 0.0671165,-0.0773311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524547,0.000173455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728549,-0.0360785) , 
2, 1.2361, 1, 0, 0.550513,-0.00917761) , 
2, -1.44705, 1, 0, 0.472521,-0.0201735)    );
  // itree = 1418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416247,0.0178712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278821,-0.0149007) , 
1, 1.28218, 1, 0, 0.398742,0.0283745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637724,-0.0252266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.829705,0.00616276) , 
3, 1.20247, 1, 0, 0.730465,-0.0243341) , 
3, 0.475933, 1, 0, 0.533091,0.00702728)    );
  // itree = 1419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38112,0.0548137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366652,-0.0215387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610138,0.00855325) , 
0, -0.62767, 1, 0, 0.523684,-0.00429908) , 
0, -3.03185, 1, 0, 0.516719,0.00260099)    );
  // itree = 1420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308383,-0.0203576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364289,0.0235087) , 
1, -0.572275, 1, 0, 0.350367,0.0209119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27618,-0.0208788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782681,0.00727646) , 
3, 0.331339, 1, 0, 0.547695,-0.01532) , 
0, -1.4678, 1, 0, 0.506762,-0.00780419)    );
  // itree = 1421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436587,-0.000878845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8045,0.0350309) , 
0, 1.22149, 1, 0, 0.525306,0.017146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222934,0.025292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515295,-0.0293501) , 
2, -1.22828, 1, 0, 0.463358,-0.049867) , 
1, 0.71376, 1, 0, 0.510356,0.000974138)    );
  // itree = 1422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712346,0.051654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519588,-0.00130181) , 
1, -1.75827, 1, 0, 0.528885,0.00374872) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244054,-0.0247375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537818,-0.136668) , 
2, 0.430408, 1, 0, 0.32397,-0.105815) , 
1, 1.41092, 1, 0, 0.51032,-0.00617734)    );
  // itree = 1423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373662,-0.0361659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366748,-0.0102242) , 
1, -1.51827, 1, 0, 0.367459,-0.0289074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.778057,0.0179952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641052,-0.0341901) , 
1, 0.745778, 1, 0, 0.755343,0.0169214) , 
2, 0.604931, 1, 0, 0.465296,-0.0173479)    );
  // itree = 1424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22322,-0.044853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178814,-0.0213204) , 
1, -1.27354, 1, 0, 0.184742,-0.0537101) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491562,-0.018261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781183,0.0112723) , 
3, 0.597823, 1, 0, 0.678376,-0.00128321) , 
3, -0.067798, 1, 0, 0.445053,-0.0260635)    );
  // itree = 1425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137812,0.0187912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35306,-0.0197648) , 
3, -1.43472, 1, 0, 0.316377,-0.0343168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.843242,0.0371839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786915,-0.00280651) , 
3, 0.856084, 1, 0, 0.79493,0.00849763) , 
3, 0.660704, 1, 0, 0.467279,-0.0208161)    );
  // itree = 1426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452958,0.0376622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614465,0.00397613) , 
2, -1.00217, 1, 0, 0.588469,0.0201863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320254,-0.0142557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.746127,0.00894762) , 
2, 0.552297, 1, 0, 0.428986,-0.0173727) , 
1, -0.39136, 1, 0, 0.486137,-0.00391345)    );
  // itree = 1427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208418,0.0459346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256817,-0.0130291) , 
2, -1.90786, 1, 0, 0.251208,-0.012133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666113,0.0303485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757327,0.000365328) , 
2, 0.569869, 1, 0, 0.712506,0.0291315) , 
2, -0.281514, 1, 0, 0.515007,0.0114646)    );
  // itree = 1428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0906313,0.0230283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0820072,-0.0410145) , 
3, -1.78005, 1, 0, 0.0841921,-0.0414571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644558,0.0252912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677831,0.000382887) , 
2, -0.469353, 1, 0, 0.671859,0.0110513) , 
3, -0.711955, 1, 0, 0.50772,-0.00361465)    );
  // itree = 1429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535528,-0.0180308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397599,0.00114553) , 
1, -0.591326, 1, 0, 0.433838,-0.0069832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.786929,-0.000235293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.857014,0.0668043) , 
1, 0.350657, 1, 0, 0.808385,0.0578447) , 
2, 1.2182, 1, 0, 0.486983,0.0022153)    );
  // itree = 1430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132068,0.0546714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100262,-0.0302299) , 
2, -2.13571, 1, 0, 0.106685,-0.0313001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525046,0.0145696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869474,-0.0148138) , 
3, 1.46373, 1, 0, 0.575952,0.0213774) , 
2, -1.47465, 1, 0, 0.505991,0.0135238)    );
  // itree = 1431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239957,-0.0320932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225619,-0.00276579) , 
1, -0.257029, 1, 0, 0.231549,-0.0379975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598573,-0.0116204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587223,0.0121989) , 
1, -0.876513, 1, 0, 0.589515,0.0174153) , 
0, -1.48202, 1, 0, 0.514807,0.00585054)    );
  // itree = 1432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360168,0.0166633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683483,-0.0201491) , 
2, -0.0847687, 1, 0, 0.544963,-0.010339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138342,-0.0174547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.749284,0.0189876) , 
3, -0.269563, 1, 0, 0.536612,0.018564) , 
1, -0.0229864, 1, 0, 0.541122,0.00295561)    );
  // itree = 1433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0523838,-0.0458941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437349,0.00834022) , 
2, -2.1681, 1, 0, 0.416252,0.00994416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61065,-0.0315818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.93304,0.0221606) , 
3, 1.8412, 1, 0, 0.700124,-0.0503243) , 
2, 0.54983, 1, 0, 0.504213,-0.00873062)    );
  // itree = 1434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427686,0.00164687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7463,-0.0165456) , 
2, 0.650515, 1, 0, 0.504915,-0.00610285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552782,0.0512793) , 
1, 1.89, 1, 0, 0.506172,-0.00325941)    );
  // itree = 1435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299246,-0.00940903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719655,-0.0268126) , 
3, 0.392653, 1, 0, 0.465165,-0.0337059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390927,0.0319353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657021,0.00381723) , 
2, -0.492092, 1, 0, 0.547742,0.0356293) , 
1, 1.17696, 1, 0, 0.473907,-0.0263654)    );
  // itree = 1436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0508104,-0.0677189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510162,-0.0058769) , 
0, -2.97825, 1, 0, 0.486873,-0.0181622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629199,0.0378367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465001,0.00155696) , 
1, 1.0317, 1, 0, 0.523738,0.0264898) , 
1, 0.71376, 1, 0, 0.495328,-0.00792211)    );
  // itree = 1437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131209,0.0107833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534987,0.0993323) , 
2, -1.73625, 1, 0, 0.322391,0.103338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570514,-0.00958959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556817,0.00968383) , 
1, -0.605638, 1, 0, 0.561439,0.00704162) , 
0, -2.25694, 1, 0, 0.539683,0.0158059)    );
  // itree = 1438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395132,0.0072625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623745,-0.00667745) , 
2, 0.120313, 1, 0, 0.510894,2.00287e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364673,-0.0503537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49254,-0.0172741) , 
1, 1.86074, 1, 0, 0.427574,-0.0848304) , 
1, 1.54842, 1, 0, 0.505482,-0.00549156)    );
  // itree = 1439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358163,-0.00413342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718066,0.0121738) , 
0, -0.107821, 1, 0, 0.532725,0.00753068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277897,-0.0497516) , 
1, 2.04893, 1, 0, 0.524496,0.00343022)    );
  // itree = 1440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484859,-0.0168448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453614,-0.00258523) , 
1, -0.760321, 1, 0, 0.463007,-0.0139247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226941,-0.0476459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74419,-0.0180832) , 
3, 0.495741, 1, 0, 0.453489,-0.110008) , 
1, 1.45051, 1, 0, 0.462338,-0.0206804)    );
  // itree = 1441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0638176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369655,-0.0127733) , 
0, -3.4683, 1, 0, 0.347311,-0.0300955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.843288,0.0353847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664108,0.00614704) , 
1, -1.39701, 1, 0, 0.685421,0.0206883) , 
0, 0.0848771, 1, 0, 0.509161,-0.00578586)    );
  // itree = 1442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0835012,-0.0301223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569319,0.0083177) , 
3, -1.54389, 1, 0, 0.506437,0.00704678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294218,0.00334871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486849,-0.0326522) , 
2, -0.245515, 1, 0, 0.396363,-0.0372136) , 
1, 0.278487, 1, 0, 0.4655,-0.00941378)    );
  // itree = 1443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0579209,-0.0026917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264292,-0.0361451) , 
3, -2.17691, 1, 0, 0.175144,-0.0599254) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50687,0.00295822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654985,-0.0328957) , 
0, 2.98723, 1, 0, 0.513108,0.0026943) , 
0, -2.64698, 1, 0, 0.485715,-0.00238132)    );
  // itree = 1444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603061,0.0224305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419876,-0.00626876) , 
1, -1.27139, 1, 0, 0.444942,-0.00413249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611552,0.00973716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851598,0.0443791) , 
2, 0.72343, 1, 0, 0.791575,0.0889026) , 
0, 2.04684, 1, 0, 0.483175,0.00612906)    );
  // itree = 1445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0624479,-0.00607194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0126134,-0.0541556) , 
3, -2.43089, 1, 0, 0.0269524,-0.0453945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.701321,0.0655705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605756,0.0109425) , 
0, -1.96207, 1, 0, 0.60965,0.0269186) , 
3, -1.53958, 1, 0, 0.541459,0.0184561)    );
  // itree = 1446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226645,0.100028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577685,0.00601741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346884,-0.0193392) , 
1, 0.852845, 1, 0, 0.526278,0.00166446) , 
2, -2.07855, 1, 0, 0.516262,0.00612419)    );
  // itree = 1447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482676,0.0904808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630794,-0.00028682) , 
2, -0.960012, 1, 0, 0.609122,0.0276655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215336,0.00693289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613193,-0.0111001) , 
3, -0.207894, 1, 0, 0.454556,-0.00974793) , 
1, -0.844204, 1, 0, 0.488937,-0.00142597)    );
  // itree = 1448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29722,-0.00987992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699031,0.0164095) , 
2, -0.435163, 1, 0, 0.553565,0.0138435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327025,0.00249026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473207,-0.0387862) , 
0, -0.093966, 1, 0, 0.390158,-0.0299479) , 
1, 0.71376, 1, 0, 0.5113,0.00251685)    );
  // itree = 1449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19212,0.00726453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301209,-0.025054) , 
3, -0.698308, 1, 0, 0.249224,-0.0290864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.753681,0.0161982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.869252,-0.0131587) , 
3, 1.77844, 1, 0, 0.776332,0.0232391) , 
3, 0.238103, 1, 0, 0.481231,-0.00605532)    );
  // itree = 1450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0406387,-0.0348765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253298,0.0798063) , 
3, -2.36501, 1, 0, 0.1986,0.0788279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371847,0.021779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571735,-0.00962803) , 
0, -1.13618, 1, 0, 0.539987,-0.00977556) , 
2, -1.47465, 1, 0, 0.50469,-0.000614787)    );
  // itree = 1451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420159,0.0647205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122866,0.00887625) , 
1, 0.0565502, 1, 0, 0.251272,0.0632658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496916,-0.0141914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794828,0.0243453) , 
0, 2.33798, 1, 0, 0.527587,-0.0186785) , 
2, -1.59659, 1, 0, 0.507801,-0.0128107)    );
  // itree = 1452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553492,0.00277414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424682,-0.0138374) , 
1, 0.160719, 1, 0, 0.502671,-0.00663621) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.626017,0.0650569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488033,0.0208883) , 
1, 1.77683, 1, 0, 0.54848,0.0880133) , 
1, 1.4007, 1, 0, 0.506368,0.00100379)    );
  // itree = 1453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237654,0.0381039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119384,-0.0170214) , 
1, -0.844735, 1, 0, 0.143127,-0.00810948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.66973,0.00373721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725402,0.034021) , 
1, -0.294962, 1, 0, 0.700415,0.0427309) , 
3, -0.639447, 1, 0, 0.53502,0.0276422)    );
  // itree = 1454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0323842,-0.06494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355772,-0.0136978) , 
2, -2.06755, 1, 0, 0.338096,-0.0362189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520517,-0.00983574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.739584,0.015562) , 
0, 0.0247541, 1, 0, 0.693548,0.021478) , 
2, 0.162129, 1, 0, 0.491653,-0.0112935)    );
  // itree = 1455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191541,-0.0113285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36622,-0.0455747) , 
2, -0.219977, 1, 0, 0.22836,-0.040287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.581312,0.0164165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626217,-0.00781664) , 
0, 0.876038, 1, 0, 0.600918,0.012492) , 
0, -0.951058, 1, 0, 0.484487,-0.00400233)    );
  // itree = 1456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369009,0.00121779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311436,0.0336358) , 
1, -0.0756034, 1, 0, 0.341527,0.0300452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.706261,-0.0149756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768833,0.0104217) , 
2, 1.03126, 1, 0, 0.724161,-0.0140604) , 
3, 0.306962, 1, 0, 0.529753,0.00834869)    );
  // itree = 1457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0387593,-0.0266489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675237,0.0273881) , 
3, -1.75202, 1, 0, 0.616853,0.0465674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367139,-0.0379126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471782,0.00168284) , 
1, 0.355585, 1, 0, 0.455322,-0.00844209) , 
1, 0.199682, 1, 0, 0.545044,0.0221126)    );
  // itree = 1458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299167,-0.0460798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237103,-0.0238326) , 
1, -1.50619, 1, 0, 0.244621,-0.0592199) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.738761,-0.00180468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.916977,0.0560307) , 
1, 1.4007, 1, 0, 0.752511,0.00576791) , 
3, 0.306962, 1, 0, 0.47726,-0.0294522)    );
  // itree = 1459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.837004,0.0756434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352508,0.000800105) , 
1, -1.99497, 1, 0, 0.376102,0.00839382) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404277,-0.0852922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634157,-0.000909607) , 
0, 0.419271, 1, 0, 0.601891,-0.0272735) , 
0, 0.0848771, 1, 0, 0.483937,-0.0086406)    );
  // itree = 1460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434847,0.00573784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455664,0.0424476) , 
1, 0.990731, 1, 0, 0.438091,0.0222694) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.587496,-0.0334167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690897,0.0153117) , 
1, 0.0914683, 1, 0, 0.634794,-0.0213573) , 
0, 0.659805, 1, 0, 0.508255,0.0067078)    );
  // itree = 1461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0560906,-0.0467063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144943,-0.0296123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561691,-0.00269438) , 
0, -2.3584, 1, 0, 0.522838,-0.0109216) , 
2, -2.0544, 1, 0, 0.506157,-0.0143487)    );
  // itree = 1462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341881,-0.00392926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407158,-0.0181122) , 
0, -0.810726, 1, 0, 0.373148,-0.0244089) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.889101,0.0262531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69253,-0.0362262) , 
0, 2.53741, 1, 0, 0.843924,0.0148331) , 
3, 0.908704, 1, 0, 0.495527,-0.0142079)    );
  // itree = 1463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0309634,-0.0723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655336,-0.0119204) , 
3, -1.02868, 1, 0, 0.519333,-0.0560027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466674,0.00908216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629224,-0.0328098) , 
0, 3.19023, 1, 0, 0.471622,0.01459) , 
1, -1.12811, 1, 0, 0.478813,0.0039498)    );
  // itree = 1464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572342,-0.00198293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738071,0.0837899) , 
1, -1.88838, 1, 0, 0.646395,0.0707301) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349457,0.028554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48005,-0.010522) , 
0, -3.02048, 1, 0, 0.474878,-0.017698) , 
1, -1.51196, 1, 0, 0.487687,-0.0110937)    );
  // itree = 1465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325148,0.0201403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555474,-0.00667478) , 
0, -1.54251, 1, 0, 0.510465,-0.00468273) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0911582,-0.0608825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76732,-0.0145565) , 
3, 0.267493, 1, 0, 0.409753,-0.0957899) , 
1, 1.41092, 1, 0, 0.502203,-0.0121563)    );
  // itree = 1466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50261,0.0338332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325905,0.00118991) , 
1, -0.261294, 1, 0, 0.390555,0.0228439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505759,-0.0273562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793682,0.00775521) , 
2, 1.02922, 1, 0, 0.621478,-0.0304706) , 
0, 0.600248, 1, 0, 0.476405,0.0030232)    );
  // itree = 1467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.814507,0.105337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68526,-0.0221852) , 
2, 0.312451, 1, 0, 0.751314,0.0667895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491453,-0.00397369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558781,0.0298389) , 
1, 1.31414, 1, 0, 0.498057,-0.000517505) , 
1, -1.36512, 1, 0, 0.524657,0.00655187)    );
  // itree = 1468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340949,-0.0178878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542829,0.0237614) , 
0, 1.33691, 1, 0, 0.354047,-0.0282406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.708383,0.009416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750292,0.0584431) , 
1, 1.41092, 1, 0, 0.711221,0.0274335) , 
2, 0.125193, 1, 0, 0.509,-0.00408755)    );
  // itree = 1469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158149,-0.0630046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697851,-0.0106823) , 
3, -0.786928, 1, 0, 0.537075,-0.0722083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445382,-0.00576542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469677,0.0125561) , 
1, -0.0521281, 1, 0, 0.458878,0.00725412) , 
1, -1.48186, 1, 0, 0.466484,-0.000474831)    );
  // itree = 1470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149015,-0.0387597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715465,0.0228797) , 
3, -0.831334, 1, 0, 0.563538,0.0134952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214016,-0.0250594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74731,-0.00496512) , 
3, 0.301115, 1, 0, 0.449384,-0.0333795) , 
1, -0.781709, 1, 0, 0.478592,-0.0213858)    );
  // itree = 1471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145435,-0.0517092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573164,-0.0222031) , 
0, -1.56119, 1, 0, 0.492667,-0.0510773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453992,-0.00874364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483361,0.00921523) , 
1, 0.607722, 1, 0, 0.463983,-0.00531758) , 
1, -0.947159, 1, 0, 0.470247,-0.0153116)    );
  // itree = 1472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175721,0.000102414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58127,-0.0353188) , 
3, -0.523057, 1, 0, 0.289033,-0.0233312) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608602,0.00488918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701747,0.0341929) , 
1, 0.463922, 1, 0, 0.630459,0.0246803) , 
0, -0.779333, 1, 0, 0.506539,0.00725457)    );
  // itree = 1473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296977,0.0248614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470455,-0.00844856) , 
0, -1.84025, 1, 0, 0.44216,-0.00718422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.776434,0.0217387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.860512,-0.00777696) , 
2, 1.87284, 1, 0, 0.791228,0.0346191) , 
2, 0.988814, 1, 0, 0.51293,0.00129103)    );
  // itree = 1474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779534,-0.00303171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241668,-0.0363378) , 
3, -1.64276, 1, 0, 0.185895,-0.0511057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516336,0.0129723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610105,-0.00909397) , 
0, -0.099755, 1, 0, 0.578042,-0.00322642) , 
2, -0.704443, 1, 0, 0.488601,-0.0141468)    );
  // itree = 1475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353062,-0.000366124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192166,-0.0364407) , 
1, 1.38887, 1, 0, 0.332131,-0.0105714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.671746,0.0203125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714778,-0.00473257) , 
0, 1.67911, 1, 0, 0.685233,0.0251201) , 
2, 0.171595, 1, 0, 0.490476,0.00543411)    );
  // itree = 1476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166042,0.0109851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240134,-0.0437297) , 
2, -1.34593, 1, 0, 0.209041,-0.0432667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116093,0.0483669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618401,-0.000811085) , 
3, -0.67926, 1, 0, 0.560187,0.00373838) , 
0, -1.74276, 1, 0, 0.494946,-0.00499494)    );
  // itree = 1477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622312,0.0518856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493927,-0.000512426) , 
1, -1.91478, 1, 0, 0.498306,0.00255494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141855,-0.0349695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733444,0.00557959) , 
3, 0.287233, 1, 0, 0.435945,-0.0285704) , 
1, 1.17696, 1, 0, 0.490602,-0.00129041)    );
  // itree = 1478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20594,6.04086e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616799,0.043377) , 
2, -0.644015, 1, 0, 0.393196,0.0349025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619415,-0.0153387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755628,0.0221962) , 
1, 1.05945, 1, 0, 0.636496,-0.0212498) , 
0, 0.0848771, 1, 0, 0.507901,0.00842922)    );
  // itree = 1479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547603,0.00478572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.801769,0.0895045) , 
1, -0.325285, 1, 0, 0.568167,0.023139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412894,0.00471521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583196,-0.0186619) , 
0, 1.5337, 1, 0, 0.445863,-0.00289561) , 
1, -0.164574, 1, 0, 0.502251,0.00910769)    );
  // itree = 1480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420945,-0.0240399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808122,0.0164053) , 
0, 1.21364, 1, 0, 0.518173,-0.0301985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471808,0.0178518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734494,-0.0155343) , 
2, 0.82425, 1, 0, 0.515804,0.0197344) , 
1, -0.0229864, 1, 0, 0.517042,-0.00636862)    );
  // itree = 1481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274623,0.0841962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0244257,0.00451417) , 
0, -3.38683, 1, 0, 0.120428,0.0619095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438993,0.00818519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605476,-0.0106451) , 
0, -0.0248499, 1, 0, 0.52737,-0.00577205) , 
3, -1.73087, 1, 0, 0.501068,-0.00139759)    );
  // itree = 1482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433155,0.00174642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241251,-0.0294096) , 
1, 0.822987, 1, 0, 0.387029,-0.00982958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375987,0.063424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.773185,5.11223e-05) , 
3, 0.801713, 1, 0, 0.70484,0.0252614) , 
0, 0.861216, 1, 0, 0.477189,0.000125363)    );
  // itree = 1483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0439751,-0.0286066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281622,-0.0463527) , 
3, -1.91577, 1, 0, 0.172164,-0.103634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37084,0.0817733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560643,-0.00374016) , 
2, -1.14399, 1, 0, 0.543515,0.00348898) , 
0, -2.46434, 1, 0, 0.50553,-0.00746861)    );
  // itree = 1484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405301,-0.0556933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576262,0.0129731) , 
2, -1.99878, 1, 0, 0.555962,0.0197897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298499,0.00332107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656369,-0.0415779) , 
3, 0.680986, 1, 0, 0.416148,-0.0259749) , 
1, 0.736789, 1, 0, 0.516116,0.00674739)    );
  // itree = 1485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258995,0.0370721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46122,-0.0155376) , 
2, -1.66095, 1, 0, 0.445873,-0.023372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66495,0.0869209) , 
1, 1.81888, 1, 0, 0.454075,-0.0159412)    );
  // itree = 1486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269995,-0.0150006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825372,0.0375098) , 
2, -0.401887, 1, 0, 0.609835,0.0285592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322729,0.0164246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554706,-0.0239611) , 
2, -0.317298, 1, 0, 0.460195,-0.0201247) , 
1, -0.124205, 1, 0, 0.53546,0.00436193)    );
  // itree = 1487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273007,0.00390769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583607,0.050268) , 
0, -0.818624, 1, 0, 0.344134,0.0343607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545794,-0.0196896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.787013,0.0170908) , 
2, 1.08362, 1, 0, 0.596328,-0.0219231) , 
2, -0.457527, 1, 0, 0.516728,-0.00415832)    );
  // itree = 1488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296656,0.0458537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740314,-0.00458205) , 
1, 0.0100439, 1, 0, 0.187959,0.0473895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232017,-0.0163662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717814,0.000854551) , 
3, -0.163075, 1, 0, 0.546929,-0.0121996) , 
3, -1.26947, 1, 0, 0.501027,-0.00457985)    );
  // itree = 1489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471727,-0.000678888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717707,-0.0407216) , 
2, 1.3358, 1, 0, 0.488508,-0.00646629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.703333,0.0579944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.845767,-0.000327529) , 
3, 2.03391, 1, 0, 0.783438,0.0815002) , 
0, 2.5577, 1, 0, 0.510239,1.51049e-05)    );
  // itree = 1490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513458,-0.0277853) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0361946,-0.0483588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.523028,0.00887637) , 
2, -2.18124, 1, 0, 0.509273,0.0151711) , 
1, -1.873, 1, 0, 0.509479,0.011494)    );
  // itree = 1491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314786,-0.0650643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47846,-0.028012) , 
1, -2.17246, 1, 0, 0.405717,-0.112295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355381,0.0107528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569301,-0.0107495) , 
0, -0.691462, 1, 0, 0.494553,-0.00771752) , 
1, -1.71379, 1, 0, 0.488188,-0.0152108)    );
  // itree = 1492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444487,-0.00463071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571849,-0.0229139) , 
0, 1.30038, 1, 0, 0.46747,-0.0154355) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.695424,0.0415895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.877629,0.000697611) , 
3, 2.03473, 1, 0, 0.805981,0.0533144) , 
0, 2.41389, 1, 0, 0.490118,-0.0108359)    );
  // itree = 1493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263151,0.00606291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12556,-0.0432966) , 
1, 0.319595, 1, 0, 0.200405,-0.0302339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56572,-0.00222552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541492,0.0146337) , 
1, -0.269474, 1, 0, 0.5525,0.0143406) , 
0, -2.31973, 1, 0, 0.513139,0.00935761)    );
  // itree = 1494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259955,0.0250445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279586,-0.0198354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578975,-0.00400335) , 
0, -1.09271, 1, 0, 0.493234,-0.0176247) , 
0, -3.02048, 1, 0, 0.48141,-0.0140208)    );
  // itree = 1495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.898012,0.0652664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425949,-0.00796966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.79314,0.015048) , 
2, 0.988814, 1, 0, 0.483195,-0.0091913) , 
1, -1.86485, 1, 0, 0.493478,-0.00565695)    );
  // itree = 1496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230563,0.0531523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315734,0.00993784) , 
2, -1.80314, 1, 0, 0.277318,0.0578803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52973,-0.0234917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482322,-0.00221901) , 
1, -0.78404, 1, 0, 0.494321,-0.0156418) , 
0, -3.03185, 1, 0, 0.482222,-0.0115426)    );
  // itree = 1497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556737,0.0108033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553122,0.0469331) , 
1, -1.96868, 1, 0, 0.554923,0.0703525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13863,-0.019937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.566324,0.00228123) , 
2, -1.2329, 1, 0, 0.485947,-0.00330908) , 
1, -1.65967, 1, 0, 0.489927,0.000941499)    );
  // itree = 1498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194761,-0.0169848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114059,-0.0500985) , 
1, 0.858781, 1, 0, 0.168299,-0.0649764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538669,-0.00258537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536379,0.016328) , 
1, -0.231192, 1, 0, 0.537451,0.0148966) , 
0, -2.46434, 1, 0, 0.502521,0.00733882)    );
  // itree = 1499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13336,-0.0290243) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311681,0.0246269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610144,0.00295891) , 
2, -0.464819, 1, 0, 0.519892,0.0175594) , 
2, -1.9018, 1, 0, 0.503036,0.0141749)    );
  // itree = 1500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50411,0.0313574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732396,-0.0110936) , 
3, 0.262941, 1, 0, 0.626722,0.0171446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213396,0.00426096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579073,-0.0165995) , 
3, -0.226203, 1, 0, 0.437211,-0.020332) , 
1, -0.700332, 1, 0, 0.490189,-0.00985537)    );
  // itree = 1501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24813,0.0027593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434124,-0.0195814) , 
2, -0.852947, 1, 0, 0.353164,-0.020661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65913,-0.00248849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742709,0.020349) , 
0, 0.717554, 1, 0, 0.711772,0.0260613) , 
2, 0.161708, 1, 0, 0.508703,-0.000396164)    );
  // itree = 1502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181011,-0.00693695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549145,0.0128098) , 
2, -0.747582, 1, 0, 0.431116,0.0151341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878577,-0.00782137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664076,-0.0432196) , 
2, 1.81403, 1, 0, 0.838736,-0.0291807) , 
3, 1.42475, 1, 0, 0.496786,0.00799468)    );
  // itree = 1503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336324,0.0169403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.085804,-0.0255183) , 
0, -1.79212, 1, 0, 0.178445,-0.0142228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.679572,0.00375243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836423,0.0555849) , 
1, 1.82989, 1, 0, 0.685639,0.0117579) , 
3, -0.43837, 1, 0, 0.501525,0.00232679)    );
  // itree = 1504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144449,-0.0442046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539076,-0.000817149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543843,0.0263857) , 
1, 1.22182, 1, 0, 0.53955,0.00340389) , 
0, -3.13202, 1, 0, 0.520246,-0.00207027)    );
  // itree = 1505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129829,-0.0193555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652404,0.0309542) , 
3, -0.776089, 1, 0, 0.396646,0.0143217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437482,-0.0295676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.829078,-0.00250997) , 
3, 0.885258, 1, 0, 0.665399,-0.0359657) , 
2, 0.21299, 1, 0, 0.512538,-0.00736323)    );
  // itree = 1506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277847,-0.00177386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620966,0.0243735) , 
2, -0.531675, 1, 0, 0.446042,0.0237817) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.67086,-0.0220014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.801461,0.0322728) , 
1, 0.527161, 1, 0, 0.699221,-0.0214927) , 
2, 0.560086, 1, 0, 0.529702,0.00882121)    );
  // itree = 1507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32588,-0.0448066) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340285,0.0279902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56683,-0.000555093) , 
0, -1.525, 1, 0, 0.519654,0.00808369) , 
1, -1.88482, 1, 0, 0.50995,0.00253391)    );
  // itree = 1508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474092,-0.00607826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796445,0.0425472) , 
1, 1.18964, 1, 0, 0.485709,-0.00752707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474274,0.0434379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540116,0.00844565) , 
1, 1.70061, 1, 0, 0.51852,0.0368326) , 
1, 1.45051, 1, 0, 0.488283,-0.00404599)    );
  // itree = 1509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339157,-0.0142235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453303,-0.0374908) , 
2, 0.190937, 1, 0, 0.357221,-0.0372441) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.707558,-0.00197228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.791791,0.0234532) , 
1, 1.25522, 1, 0, 0.718433,0.00237539) , 
2, 0.459016, 1, 0, 0.480097,-0.0237664)    );
  // itree = 1510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17754,-0.0379162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313429,0.0516951) , 
1, -0.913723, 1, 0, 0.288863,0.054004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382446,-0.0130279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726872,0.00371995) , 
2, 0.17391, 1, 0, 0.545829,-0.010826) , 
2, -1.09958, 1, 0, 0.503322,-0.000101785)    );
  // itree = 1511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331175,-0.0144859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661489,0.0160627) , 
0, 0.149307, 1, 0, 0.379608,-0.0183924) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360973,0.0327877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805043,-0.00668799) , 
3, 0.854714, 1, 0, 0.692963,0.0116822) , 
0, 0.619485, 1, 0, 0.497814,-0.00704744)    );
  // itree = 1512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103574,-0.0270578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366333,0.0122681) , 
2, -1.66036, 1, 0, 0.325323,0.0131489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.676727,-0.0268979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.854707,0.0261446) , 
2, 1.30964, 1, 0, 0.718075,-0.0341733) , 
3, 0.262941, 1, 0, 0.508623,-0.00893673)    );
  // itree = 1513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208673,-0.00142935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492194,-0.0230106) , 
2, -0.842084, 1, 0, 0.404926,-0.0339462) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.715654,0.0250273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74468,-0.0157433) , 
2, 1.15934, 1, 0, 0.730368,0.00773966) , 
2, 0.687228, 1, 0, 0.487555,-0.0233623)    );
  // itree = 1514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310867,-0.0153264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409795,0.0187453) , 
1, -0.912259, 1, 0, 0.386279,0.0206561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422031,-0.0338522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675975,-0.00389683) , 
2, 0.354938, 1, 0, 0.627591,-0.0213625) , 
2, 0.161708, 1, 0, 0.497597,0.00127267)    );
  // itree = 1515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134229,-0.0191692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398665,0.00253551) , 
0, -3.13814, 1, 0, 0.379292,0.00136104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.706413,-0.0290652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.877266,0.00287435) , 
3, 1.67106, 1, 0, 0.773042,-0.037795) , 
3, 0.775961, 1, 0, 0.497123,-0.0103565)    );
  // itree = 1516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.680075,0.0462204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743349,-0.000373818) , 
0, 1.32256, 1, 0, 0.696001,0.0700156) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0727727,-0.0333397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543652,0.000203185) , 
2, -1.23488, 1, 0, 0.463234,-0.00938883) , 
1, -1.15459, 1, 0, 0.493766,0.00102645)    );
  // itree = 1517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393972,0.0673595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157764,0.0183718) , 
1, 0.321275, 1, 0, 0.275933,0.101005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187584,0.120709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522617,-0.00269836) , 
2, -1.79544, 1, 0, 0.511651,-0.00244886) , 
0, -3.03018, 1, 0, 0.500017,0.00265727)    );
  // itree = 1518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160935,0.00452375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585682,-0.0260305) , 
3, -0.700161, 1, 0, 0.285791,-0.0143016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608317,0.000934572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611453,0.0216682) , 
1, -0.899165, 1, 0, 0.610798,0.0351658) , 
0, -1.02119, 1, 0, 0.513966,0.0204276)    );
  // itree = 1519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206059,-0.0238467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198318,0.00192199) , 
1, -1.18314, 1, 0, 0.199672,-0.00758336) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618294,0.0403359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775243,0.00434559) , 
3, 0.0729744, 1, 0, 0.74695,0.0246838) , 
3, -0.375219, 1, 0, 0.541748,0.0125852)    );
  // itree = 1520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193741,-0.0477522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67881,0.0166304) , 
2, -1.12172, 1, 0, 0.618581,0.0129032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189919,0.00142848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54701,-0.022309) , 
3, -0.191062, 1, 0, 0.408346,-0.0321243) , 
1, -0.591326, 1, 0, 0.468135,-0.019319)    );
  // itree = 1521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0345542,-0.0432786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384887,0.0141288) , 
2, -1.84538, 1, 0, 0.324981,0.0107173) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536129,-0.00908457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448494,-0.0466151) , 
1, 1.15272, 1, 0, 0.527495,-0.0261247) , 
0, -0.947009, 1, 0, 0.462989,-0.0143896)    );
  // itree = 1522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292066,-0.00695988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526226,-0.0319348) , 
3, 0.399293, 1, 0, 0.325028,-0.0234936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.762657,-0.015584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.795073,0.0204569) , 
1, -0.231192, 1, 0, 0.781701,0.0128214) , 
3, 0.760312, 1, 0, 0.472249,-0.0117865)    );
  // itree = 1523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479831,-0.0195439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660652,-0.0632401) , 
2, 1.02583, 1, 0, 0.51777,-0.0588409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284189,0.0175715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562203,-0.00307562) , 
0, -0.84483, 1, 0, 0.460446,0.00550454) , 
1, -0.823218, 1, 0, 0.474997,-0.0108283)    );
  // itree = 1524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396361,0.00527264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632884,0.0383868) , 
2, 0.34193, 1, 0, 0.424875,0.0198966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.694231,-0.0243309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853909,0.0221623) , 
1, 0.351767, 1, 0, 0.7435,-0.0196358) , 
2, 0.609275, 1, 0, 0.518244,0.00831209)    );
  // itree = 1525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280328,-0.00719419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258012,-0.0568912) , 
2, -0.461889, 1, 0, 0.276209,-0.0385649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726705,0.0258481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61654,-0.0032144) , 
1, 0.313122, 1, 0, 0.685758,0.0308589) , 
2, -0.224534, 1, 0, 0.51382,0.00171307)    );
  // itree = 1526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120431,-0.0142155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343882,0.00488144) , 
3, -1.0136, 1, 0, 0.234222,-0.00539747) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.801937,0.0477202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752213,0.0100975) , 
3, 0.104785, 1, 0, 0.75666,0.0314047) , 
3, -0.123397, 1, 0, 0.521415,0.0148333)    );
  // itree = 1527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139825,-0.00542621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133642,-0.0858882) , 
3, -0.811906, 1, 0, 0.137701,-0.0948904) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473298,-0.0044969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729027,0.0114616) , 
0, 0.695571, 1, 0, 0.579236,0.00512712) , 
2, -1.02858, 1, 0, 0.475158,-0.0184488)    );
  // itree = 1528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314367,-0.00756587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113193,-0.0456674) , 
0, 0.23112, 1, 0, 0.292201,-0.0289398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0623859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.759861,0.00445035) , 
0, 0.306083, 1, 0, 0.798591,0.0213333) , 
3, 0.392653, 1, 0, 0.498052,-0.00850342)    );
  // itree = 1529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522469,-0.00748808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.547422,0.0124244) , 
1, -0.481454, 1, 0, 0.536254,0.00635238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347732,-0.0220247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.909381,0.0270677) , 
3, 1.63022, 1, 0, 0.426127,-0.0348345) , 
1, 0.810881, 1, 0, 0.512836,-0.00240579)    );
  // itree = 1530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299567,0.0457633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465026,-0.00253887) , 
0, -3.11701, 1, 0, 0.457954,-0.000272876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.865169,0.0387682) , 
2, 1.77423, 1, 0, 0.475689,0.00370671)    );
  // itree = 1531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232615,8.15024e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647805,0.0312223) , 
2, -0.631366, 1, 0, 0.42696,0.0282295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119518,-0.0410519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727506,-0.00710213) , 
3, 0.520845, 1, 0, 0.638669,-0.0300163) , 
0, 0.456819, 1, 0, 0.514026,0.00427558)    );
  // itree = 1532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540082,0.0118345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238301,-0.0324066) , 
1, -1.09887, 1, 0, 0.278454,-0.0505113) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489602,0.0195822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697266,-0.00740302) , 
2, 0.122955, 1, 0, 0.631618,0.00180945) , 
0, -0.691462, 1, 0, 0.510469,-0.0161386)    );
  // itree = 1533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569128,0.0200621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.833404,0.0585052) , 
0, 0.234883, 1, 0, 0.700043,0.0865679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156139,-0.0202556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5685,0.0112251) , 
2, -1.06526, 1, 0, 0.482477,0.0111692) , 
1, -1.31849, 1, 0, 0.504638,0.0188495)    );
  // itree = 1534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0164429,-0.0524559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0727666,-0.00984249) , 
2, -1.74706, 1, 0, 0.0554877,-0.0337714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533275,0.051309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637239,0.00617975) , 
2, -0.574637, 1, 0, 0.620637,0.0300199) , 
3, -1.15591, 1, 0, 0.505521,0.0170262)    );
  // itree = 1535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213758,-0.0479367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218249,-0.00857793) , 
1, 0.580752, 1, 0, 0.215615,-0.0621835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522514,0.0317231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638468,0.00112315) , 
0, -0.72404, 1, 0, 0.617072,0.0130331) , 
0, -1.55531, 1, 0, 0.53515,-0.00231579)    );
  // itree = 1536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41698,-0.00321041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741576,0.0576608) , 
2, 1.18394, 1, 0, 0.435119,0.000238891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.628007,-0.00795106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680666,-0.0430037) , 
0, 2.62832, 1, 0, 0.646017,-0.0441285) , 
0, 1.68098, 1, 0, 0.469944,-0.00708733)    );
  // itree = 1537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2275,0.0437714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503119,-0.0120525) , 
0, -2.42928, 1, 0, 0.4811,-0.0170978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311397,-0.0338247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5388,-0.0573989) , 
2, 0.602828, 1, 0, 0.384882,-0.0838275) , 
1, 1.17696, 1, 0, 0.471048,-0.0240695)    );
  // itree = 1538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506241,0.00244716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.6044,0.0307403) , 
1, -0.638537, 1, 0, 0.538169,0.0257317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272903,-0.0172987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788588,0.00363874) , 
3, 0.760312, 1, 0, 0.432511,-0.0203161) , 
1, -0.164574, 1, 0, 0.477105,-0.000880799)    );
  // itree = 1539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353214,0.0425341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626788,0.0121541) , 
2, -0.786105, 1, 0, 0.571008,0.0349399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.678724,0.0346037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475612,-0.00540824) , 
1, 0.388898, 1, 0, 0.499281,-0.000414337) , 
1, 0.24729, 1, 0, 0.541629,0.020459)    );
  // itree = 1540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64198,0.0475253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433563,-0.00621812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623272,-0.0389156) , 
0, 2.24424, 1, 0, 0.449516,-0.0185005) , 
1, -2.0783, 1, 0, 0.454519,-0.015413)    );
  // itree = 1541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375049,-0.016838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338709,0.0510886) , 
1, 1.44187, 1, 0, 0.372364,-0.0284943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61685,0.047112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72544,0.00500049) , 
2, 0.0920873, 1, 0, 0.708011,0.0226519) , 
0, 0.685266, 1, 0, 0.482834,-0.0116608)    );
  // itree = 1542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740949,0.0036245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715302,0.079789) , 
3, -2.00675, 1, 0, 0.364663,0.110086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428304,-0.000291033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781146,0.0164122) , 
2, 0.596015, 1, 0, 0.540046,0.00997839) , 
0, -2.41637, 1, 0, 0.526789,0.0175454)    );
  // itree = 1543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338228,0.00644844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586557,0.0482385) , 
0, 0.00632581, 1, 0, 0.388427,0.0298499) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244122,-0.0323016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753195,2.07764e-05) , 
3, 0.136356, 1, 0, 0.662329,-0.0114305) , 
2, 0.0724854, 1, 0, 0.521021,0.00986639)    );
  // itree = 1544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329572,-0.00715856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252003,-0.029113) , 
0, 0.171927, 1, 0, 0.311237,-0.0282189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.909675,-0.0429966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782748,0.0112757) , 
0, 0.431902, 1, 0, 0.797668,0.0146763) , 
3, 0.638168, 1, 0, 0.476648,-0.0136324)    );
  // itree = 1545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377423,-0.0339488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38064,-0.00363247) , 
1, -1.29665, 1, 0, 0.380296,-0.015366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.719948,0.0289946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777468,-0.0222666) , 
2, 1.51091, 1, 0, 0.730125,0.0393974) , 
2, 0.276916, 1, 0, 0.512725,0.00536481)    );
  // itree = 1546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233004,0.0112125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525101,-0.0165624) , 
2, -1.16796, 1, 0, 0.482397,-0.0260454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647208,0.0501747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495667,-0.000104682) , 
1, 1.60168, 1, 0, 0.540319,0.0400778) , 
1, 1.28363, 1, 0, 0.48784,-0.0198316)    );
  // itree = 1547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19218,0.00574246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495326,0.0448107) , 
3, -0.562696, 1, 0, 0.232077,0.0239516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635552,-0.0431234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658968,-0.00191051) , 
0, -0.321841, 1, 0, 0.6548,-0.0200744) , 
3, -0.304384, 1, 0, 0.494479,-0.00337713)    );
  // itree = 1548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355997,0.0564349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.842213,0.0194049) , 
3, -0.453353, 1, 0, 0.703439,0.0537319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144143,-0.0374378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501433,-0.00123177) , 
0, -2.36962, 1, 0, 0.473107,-0.00848315) , 
1, -1.12811, 1, 0, 0.502488,-0.00054706)    );
  // itree = 1549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383038,-0.0127812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.874685,0.0140109) , 
3, 1.07766, 1, 0, 0.502032,-0.0113202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262977,0.0276218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.728839,0.00404868) , 
3, 0.145523, 1, 0, 0.530858,0.0262805) , 
1, 0.345387, 1, 0, 0.511474,0.000995803)    );
  // itree = 1550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25466,-0.00530527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685875,0.0152277) , 
3, 0.177214, 1, 0, 0.382169,0.00217397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513484,-0.0345398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906146,0.0120075) , 
3, 1.56963, 1, 0, 0.687645,-0.0409699) , 
2, 0.604931, 1, 0, 0.47542,-0.0109963)    );
  // itree = 1551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1657,0.0757587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267264,0.00552142) , 
2, -1.97803, 1, 0, 0.258541,0.0170799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.601363,-0.0409131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688341,-0.00771422) , 
2, -0.175375, 1, 0, 0.673847,-0.0318576) , 
3, -0.123397, 1, 0, 0.498819,-0.0112332)    );
  // itree = 1552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483736,-0.00581462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600288,0.0248989) , 
1, -1.49733, 1, 0, 0.569661,0.0344421) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405808,0.00570205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.516314,-0.0156659) , 
0, -0.00413718, 1, 0, 0.465525,-0.0128982) , 
1, -0.39136, 1, 0, 0.506324,0.00564936)    );
  // itree = 1553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537735,-0.0179277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445109,-0.0662309) , 
1, -1.54111, 1, 0, 0.513798,-0.069647) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165823,-0.0103984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731817,0.0139342) , 
3, -0.266059, 1, 0, 0.504809,0.0112786) , 
1, -1.37246, 1, 0, 0.505928,0.0012051)    );
  // itree = 1554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495346,-0.0169664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50386,0.00357307) , 
1, -1.00575, 1, 0, 0.501929,-0.00251511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624451,-0.0288967) , 
0, 3.16316, 1, 0, 0.506108,-0.00506956)    );
  // itree = 1555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240732,0.0130646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375049,-0.0263186) , 
0, -2.67121, 1, 0, 0.360558,-0.047536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526328,0.0224332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673255,-0.00269794) , 
2, 0.308875, 1, 0, 0.650011,0.00353241) , 
0, 0.611097, 1, 0, 0.465505,-0.0290202)    );
  // itree = 1556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305584,-0.00402881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531088,-0.0409213) , 
3, 0.358172, 1, 0, 0.337267,-0.0204707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.752188,0.0268648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.830584,-0.00256763) , 
3, 1.03344, 1, 0, 0.805991,0.0142695) , 
3, 0.660704, 1, 0, 0.506078,-0.00795893)    );
  // itree = 1557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726873,0.039757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705409,0.0105444) , 
1, -1.75034, 1, 0, 0.713392,0.049019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278275,0.0218069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507849,-0.00747857) , 
0, -1.676, 1, 0, 0.470221,-0.00673476) , 
1, -1.12811, 1, 0, 0.500944,0.000309332)    );
  // itree = 1558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.849017,0.0683605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232824,-0.0087336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736356,0.0160551) , 
3, 0.0509667, 1, 0, 0.493416,0.010843) , 
1, -2.03415, 1, 0, 0.504079,0.0149096)    );
  // itree = 1559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503456,-0.00214277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.762168,0.0537199) , 
1, 1.16441, 1, 0, 0.513505,0.00086471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284369,-0.0699826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504612,-0.00417919) , 
1, 1.70651, 1, 0, 0.424617,-0.0721746) , 
1, 1.41092, 1, 0, 0.505482,-0.00572774)    );
  // itree = 1560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0859716,-0.038102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104941,0.00387035) , 
1, 0.632011, 1, 0, 0.0923954,-0.0356124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42058,0.0137509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637166,-0.000429269) , 
2, -0.282008, 1, 0, 0.569898,0.00756212) , 
2, -1.30857, 1, 0, 0.503098,0.00152231)    );
  // itree = 1561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.653004,0.0274557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543271,-0.0153278) , 
1, -0.845869, 1, 0, 0.637637,0.038605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510742,-0.0482864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469062,-0.0056097) , 
1, -0.499115, 1, 0, 0.471757,-0.0199492) , 
1, -0.696094, 1, 0, 0.521964,-0.00222645)    );
  // itree = 1562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246704,0.0147258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231527,-0.0220004) , 
2, -0.83668, 1, 0, 0.239321,-0.00724633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.740053,0.0170831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.858142,0.0436699) , 
1, 1.17853, 1, 0, 0.753438,0.0415091) , 
3, -0.123397, 1, 0, 0.541269,0.0213884)    );
  // itree = 1563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324191,0.00248533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658786,0.0706214) , 
0, 0.232904, 1, 0, 0.358976,0.0172169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323644,-0.0527506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65323,-0.0043526) , 
2, -0.0904905, 1, 0, 0.607724,-0.0240193) , 
2, -0.306322, 1, 0, 0.511516,-0.00807048)    );
  // itree = 1564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289586,-0.00690676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710573,-0.0632942) , 
3, 0.711998, 1, 0, 0.321911,-0.0211631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358485,0.0405768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678289,-0.00318673) , 
3, -0.00015177, 1, 0, 0.64199,0.00442429) , 
2, 0.171595, 1, 0, 0.464617,-0.00975507)    );
  // itree = 1565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164155,-0.0738365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106564,-0.0208877) , 
1, -0.597108, 1, 0, 0.126782,-0.109357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505326,-0.00537009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466704,0.0280145) , 
1, 0.893255, 1, 0, 0.499056,-0.000465728) , 
0, -2.7067, 1, 0, 0.469055,-0.00924102)    );
  // itree = 1566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424767,-0.0137305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691246,-0.0546916) , 
2, 1.2182, 1, 0, 0.456191,-0.035946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324926,0.0176815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.595431,-0.0164452) , 
0, -0.138259, 1, 0, 0.437366,0.00187031) , 
1, 0.463922, 1, 0, 0.450606,-0.0247273)    );
  // itree = 1567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.530419,0.00154917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42718,-0.0175217) , 
1, 0.315534, 1, 0, 0.492442,-0.0103725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.923525,0.045364) , 
2, 1.86678, 1, 0, 0.50498,-0.00700458)    );
  // itree = 1568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186409,-0.0230187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560003,0.0146399) , 
0, -2.95284, 1, 0, 0.536667,0.0238893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376373,-0.0493827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234428,-0.0340891) , 
1, 1.88162, 1, 0, 0.296565,-0.0726113) , 
1, 1.56529, 1, 0, 0.522172,0.0180637)    );
  // itree = 1569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459765,-0.00509126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.935914,0.0325933) , 
3, 2.33715, 1, 0, 0.475433,-0.00699068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635607,0.0550193) , 
1, 1.75209, 1, 0, 0.48105,-0.00334784)    );
  // itree = 1570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306078,-0.0298221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725295,0.000917653) , 
2, 0.291111, 1, 0, 0.495974,-0.0316534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47804,0.0121216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361206,-0.0333121) , 
1, 1.3842, 1, 0, 0.461153,0.0103072) , 
1, -0.607352, 1, 0, 0.472109,-0.00289452)    );
  // itree = 1571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353212,0.00173849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692057,0.0411912) , 
0, 1.09719, 1, 0, 0.37158,0.00954745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541454,-0.0276797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714613,-0.00899172) , 
2, 0.686074, 1, 0, 0.641314,-0.0357434) , 
2, 0.120313, 1, 0, 0.49234,-0.0107292)    );
  // itree = 1572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25722,-0.0248735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758901,0.0233468) , 
2, -0.543709, 1, 0, 0.591082,0.00740047) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339403,-0.0602194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470852,-0.00447882) , 
1, -0.465256, 1, 0, 0.456583,-0.0207185) , 
1, -0.697263, 1, 0, 0.49158,-0.0134019)    );
  // itree = 1573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34156,-0.00146282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672288,-0.0411379) , 
3, 0.264658, 1, 0, 0.4903,-0.0385183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.052492,-0.0407135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514833,0.0149016) , 
0, -3.03185, 1, 0, 0.487235,0.0233291) , 
1, -0.605638, 1, 0, 0.488354,0.000745895)    );
  // itree = 1574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.60469,-0.00722606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297268,-0.0876521) , 
1, -1.5304, 1, 0, 0.530325,-0.0605497) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515343,0.0137084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435058,-0.0365995) , 
1, 1.74052, 1, 0, 0.509865,0.0194469) , 
1, -1.31868, 1, 0, 0.512024,0.0110082)    );
  // itree = 1575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109294,-0.00780324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278868,0.0353003) , 
3, -0.977207, 1, 0, 0.15384,0.00933074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403604,-0.0248023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648327,-0.00461357) , 
2, -0.465228, 1, 0, 0.597163,-0.0221168) , 
3, -0.749223, 1, 0, 0.481157,-0.0138878)    );
  // itree = 1576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595164,0.0239122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449276,0.00420817) , 
1, -0.0680149, 1, 0, 0.518734,0.0254647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581668,-0.0360004) , 
0, 2.76471, 1, 0, 0.521904,0.019721)    );
  // itree = 1577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222187,-0.0536045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349779,0.00522238) , 
1, -1.82713, 1, 0, 0.344503,0.004608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615706,-0.0530219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782332,-0.014647) , 
3, 0.853329, 1, 0, 0.756538,-0.0412111) , 
3, 0.660704, 1, 0, 0.484399,-0.0109487)    );
  // itree = 1578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151675,-0.00622621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691101,0.0268212) , 
3, -0.621462, 1, 0, 0.38602,0.0191601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351271,-0.0297396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.682984,-0.00193306) , 
2, -0.039941, 1, 0, 0.621232,-0.0169329) , 
0, 0.0848771, 1, 0, 0.497071,0.00211947)    );
  // itree = 1579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352719,-0.0309777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902733,0.0387097) , 
0, 0.234883, 1, 0, 0.546558,-0.0216377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627981,0.0364367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502155,0.000334026) , 
1, -0.917588, 1, 0, 0.517703,0.00880986) , 
1, -1.36512, 1, 0, 0.521155,0.00516721)    );
  // itree = 1580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568339,0.0382129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334673,0.000208701) , 
1, -0.219087, 1, 0, 0.426288,0.0257478) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394329,-0.0219196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.897642,0.0148323) , 
3, 1.34356, 1, 0, 0.62416,-0.0201079) , 
0, 0.436669, 1, 0, 0.507306,0.00697232)    );
  // itree = 1581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422771,-0.00197681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678412,0.0203148) , 
0, 0.264129, 1, 0, 0.543301,0.0182774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308198,-0.0333666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719486,0.0149801) , 
2, 0.60567, 1, 0, 0.426308,-0.0472616) , 
1, 0.345387, 1, 0, 0.500113,-0.00591631)    );
  // itree = 1582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432718,-0.0159888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690536,0.0171573) , 
0, 1.96897, 1, 0, 0.462659,-0.0237275) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246609,0.0807394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507786,0.0155713) , 
0, -2.402, 1, 0, 0.477159,0.0395632) , 
1, 0.494071, 1, 0, 0.466996,-0.00480062)    );
  // itree = 1583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729381,-0.0364958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0809633,-0.0155544) , 
0, -3.04254, 1, 0, 0.0783762,-0.0370754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42077,0.0410105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573891,0.00168329) , 
2, -1.02888, 1, 0, 0.560193,0.00999499) , 
2, -1.57101, 1, 0, 0.500558,0.00416902)    );
  // itree = 1584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537087,-0.00264685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691222,0.058169) , 
1, 1.39829, 1, 0, 0.543558,-0.00039342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246031,-0.0460191) , 
1, 1.95327, 1, 0, 0.530646,-0.00440459)    );
  // itree = 1585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171972,-0.00326339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303564,-0.0376673) , 
3, -0.724203, 1, 0, 0.210595,-0.0395537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48697,0.0215377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617095,-0.00533497) , 
0, -0.40342, 1, 0, 0.582573,0.00336163) , 
2, -0.759232, 1, 0, 0.496526,-0.00656571)    );
  // itree = 1586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289385,0.00510915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138447,-0.037715) , 
1, 0.315854, 1, 0, 0.221816,-0.0223827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.649945,0.0179127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684653,-0.0212462) , 
0, 1.78598, 1, 0, 0.658328,0.0156282) , 
2, -0.585857, 1, 0, 0.515273,0.00317117)    );
  // itree = 1587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666722,0.0248546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480556,-0.0047141) , 
1, -1.14319, 1, 0, 0.508476,-0.000517439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768064,0.095968) , 
1, 1.7189, 1, 0, 0.517499,0.00665487)    );
  // itree = 1588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391188,0.0205965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688457,-0.0398139) , 
3, 0.777364, 1, 0, 0.415932,0.0299464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302519,-0.0250397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775667,0.00025781) , 
3, 0.241537, 1, 0, 0.697262,-0.0109806) , 
2, 0.21299, 1, 0, 0.54194,0.0116151)    );
  // itree = 1589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358405,0.0604667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12493,-0.0140303) , 
1, 0.739497, 1, 0, 0.286141,0.0540806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332782,-0.0249458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585202,0.000803579) , 
0, -1.40013, 1, 0, 0.548956,-0.0055436) , 
2, -1.199, 1, 0, 0.514535,0.00226541)    );
  // itree = 1590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26952,0.0122898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454021,0.072956) , 
0, -1.84196, 1, 0, 0.320107,0.0494731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356871,-0.0195333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597877,0.00032337) , 
0, -0.651545, 1, 0, 0.542922,-0.00896885) , 
0, -1.4678, 1, 0, 0.493371,0.00402789)    );
  // itree = 1591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588151,-0.00067315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674409,-0.0349628) , 
0, 2.01164, 1, 0, 0.60104,-0.0114202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547524,0.0214039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477498,-0.0156284) , 
1, 1.16699, 1, 0, 0.534726,0.0288567) , 
1, -0.605638, 1, 0, 0.555017,0.0165329)    );
  // itree = 1592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556017,-0.0143669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667551,0.0423498) , 
1, -1.12826, 1, 0, 0.605124,0.0169203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447457,-0.0197056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477402,0.000802596) , 
1, -0.20929, 1, 0, 0.470905,-0.00834196) , 
1, -0.572275, 1, 0, 0.510539,-0.000882213)    );
  // itree = 1593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172843,0.00732928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587669,-0.0126482) , 
3, -0.858535, 1, 0, 0.480121,-0.0173755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86832,0.030802) , 
0, 3.48258, 1, 0, 0.490339,-0.0145929)    );
  // itree = 1594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533949,0.00553551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.665735,-0.0311376) , 
2, 1.18379, 1, 0, 0.550309,0.00205278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337534,-0.0192379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.877536,0.0166388) , 
3, 1.52829, 1, 0, 0.403253,-0.0300223) , 
1, -0.0849153, 1, 0, 0.473455,-0.0147101)    );
  // itree = 1595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348521,-0.00740989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652337,0.0158026) , 
0, -0.106773, 1, 0, 0.500561,0.0100258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355139,-0.049616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460577,0.000699573) , 
1, 1.1144, 1, 0, 0.430793,-0.0355046) , 
1, 0.893255, 1, 0, 0.48922,0.00262482)    );
  // itree = 1596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424277,-0.00616713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39158,0.0231635) , 
1, 0.568694, 1, 0, 0.414474,0.00528747) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368656,-0.0540952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886256,0.0100884) , 
3, 1.28337, 1, 0, 0.680759,-0.043438) , 
2, 0.60567, 1, 0, 0.49265,-0.0090174)    );
  // itree = 1597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462376,0.00359855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620572,-0.0155556) , 
0, 1.32216, 1, 0, 0.498425,-0.00227275) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.472338,-0.0434031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348426,-0.0293374) , 
1, 1.83265, 1, 0, 0.397499,-0.0652729) , 
1, 1.45051, 1, 0, 0.489322,-0.00795554)    );
  // itree = 1598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186518,-0.0234807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135915,0.00865114) , 
1, 0.315854, 1, 0, 0.167954,-0.0278925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.937248,0.0603353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677407,0.00687506) , 
0, -0.71557, 1, 0, 0.701316,0.023299) , 
3, -0.326776, 1, 0, 0.49718,0.0037062)    );
  // itree = 1599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31462,0.000917102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233823,-0.0327369) , 
0, -0.401821, 1, 0, 0.29472,-0.0172475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71388,0.0307032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82361,-0.0101496) , 
3, 0.982711, 1, 0, 0.78204,0.011551) , 
3, 0.392653, 1, 0, 0.503819,-0.00489066)    );
  // itree = 1600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129662,-0.0055567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690427,0.0128799) , 
3, -0.749223, 1, 0, 0.524637,0.015229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210408,-0.0254076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48771,-0.0882977) , 
2, -0.0885786, 1, 0, 0.311671,-0.106898) , 
1, 1.68086, 1, 0, 0.510001,0.00683558)    );
  // itree = 1601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417501,-0.000609698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668283,0.0195092) , 
0, 0.937451, 1, 0, 0.46764,0.00770376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.696499,-0.0415039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815655,0.0175816) , 
2, 1.71405, 1, 0, 0.746133,-0.030195) , 
2, 1.13653, 1, 0, 0.509306,0.00203373)    );
  // itree = 1602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212476,0.106064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.631449,0.0176289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472242,-0.00877036) , 
1, -0.696094, 1, 0, 0.513036,-0.00521141) , 
2, -1.9018, 1, 0, 0.500541,0.000414684)    );
  // itree = 1603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354117,-0.035262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438692,-0.00727372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.909537,0.0330835) , 
2, 1.9346, 1, 0, 0.454862,-0.0105387) , 
1, -1.75262, 1, 0, 0.449349,-0.0150314)    );
  // itree = 1604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408253,-0.00234927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354367,0.0192546) , 
1, -0.106686, 1, 0, 0.37742,0.0163965) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490609,-0.0269202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.762221,0.0118527) , 
2, 0.618391, 1, 0, 0.626906,-0.0173851) , 
0, -0.307758, 1, 0, 0.506728,-0.0011125)    );
  // itree = 1605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139912,-0.00678667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305784,-0.0315246) , 
3, -0.816131, 1, 0, 0.202763,-0.0377774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.58147,0.0189755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.639616,-0.0111325) , 
2, 0.319968, 1, 0, 0.614923,0.00196426) , 
2, -0.585857, 1, 0, 0.477266,-0.011309)    );
  // itree = 1606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588389,-0.0532138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483684,-0.00182822) , 
2, -2.07983, 1, 0, 0.468212,-0.00686162) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574427,0.019249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613609,0.0656407) , 
1, 2.09994, 1, 0, 0.585782,0.0624002) , 
1, 1.32658, 1, 0, 0.479135,-0.0004265)    );
  // itree = 1607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328027,-0.000956397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100368,-0.0464124) , 
1, 0.462662, 1, 0, 0.230146,-0.0397134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509786,0.0136616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751844,-0.0165981) , 
3, 0.685665, 1, 0, 0.622246,0.00113163) , 
2, -0.620353, 1, 0, 0.511571,-0.0103973)    );
  // itree = 1608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3666,0.00657383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424553,0.0480451) , 
1, 0.299301, 1, 0, 0.386983,0.0357146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525675,-0.0256343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742844,0.0152937) , 
2, 0.678426, 1, 0, 0.648446,-0.00999695) , 
2, 0.123767, 1, 0, 0.519116,0.0126138)    );
  // itree = 1609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184462,-0.0289273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328525,-0.00497607) , 
0, -2.58784, 1, 0, 0.308658,-0.0172365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.799213,0.0174942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659095,-0.0411786) , 
1, 1.48204, 1, 0, 0.788368,0.0251598) , 
3, 0.306962, 1, 0, 0.511303,0.000673077)    );
  // itree = 1610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332409,0.0337071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597712,0.00612219) , 
2, -0.871865, 1, 0, 0.549024,0.020538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423805,-0.00877321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902812,0.0330036) , 
2, 1.04815, 1, 0, 0.47817,-0.00814149) , 
1, -0.0246959, 1, 0, 0.511996,0.00555008)    );
  // itree = 1611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612193,0.00483059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641324,0.0552406) , 
1, -0.627134, 1, 0, 0.618422,0.0314778) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218065,-0.0189182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727676,0.00313628) , 
3, 0.19804, 1, 0, 0.473112,-0.0182828) , 
1, -0.362514, 1, 0, 0.527867,0.000467815)    );
  // itree = 1612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.625056,0.0193866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75735,-0.0436099) , 
0, 2.67663, 1, 0, 0.633868,0.0294035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409608,-0.015308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506136,0.0168156) , 
1, 1.17522, 1, 0, 0.433214,-0.0149689) , 
1, 0.10104, 1, 0, 0.532167,0.00691345)    );
  // itree = 1613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151516,-0.0267329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594121,-0.00058082) , 
2, -1.13773, 1, 0, 0.513247,-0.00961521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21511,-0.051243) , 
1, 2.09327, 1, 0, 0.503262,-0.0138414)    );
  // itree = 1614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0709477,-0.0411016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553357,0.000676955) , 
2, -1.66897, 1, 0, 0.52051,-0.00310403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308883,0.0208731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484795,-0.0369151) , 
0, -0.994534, 1, 0, 0.41839,-0.0354525) , 
1, 1.06974, 1, 0, 0.505221,-0.00794708)    );
  // itree = 1615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107598,-0.0326532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127195,-0.00662201) , 
0, -3.52521, 1, 0, 0.125522,-0.0146785) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503673,-0.00755211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729799,0.0171711) , 
2, -0.130667, 1, 0, 0.657565,0.0177976) , 
3, -0.711955, 1, 0, 0.490689,0.00761138)    );
  // itree = 1616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152338,0.00791732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435695,0.0439308) , 
2, -1.73625, 1, 0, 0.309688,0.0659714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406452,-0.021111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745417,0.00249558) , 
2, 0.949667, 1, 0, 0.472395,-0.0315567) , 
0, -2.24414, 1, 0, 0.455807,-0.0216142)    );
  // itree = 1617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479743,0.00228678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654987,0.0355587) , 
1, 1.66593, 1, 0, 0.488086,0.00764829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.566175,-0.0237832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.944684,0.028286) , 
3, 2.48529, 1, 0, 0.615846,-0.0405254) , 
0, 1.05872, 1, 0, 0.520434,-0.00454894)    );
  // itree = 1618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176481,-0.0301511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0615348) , 
3, -0.0314163, 1, 0, 0.235645,-0.0490805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18468,0.0856171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640628,-0.0133917) , 
3, -0.481328, 1, 0, 0.597041,-0.0154274) , 
0, -0.838864, 1, 0, 0.467533,-0.0274871)    );
  // itree = 1619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241052,0.0121366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224514,0.0382292) , 
0, -0.702772, 1, 0, 0.237653,0.0277715) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575794,-0.0274329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731848,0.0130967) , 
2, 0.251089, 1, 0, 0.674306,-0.0053) , 
3, -0.202496, 1, 0, 0.489161,0.00872262)    );
  // itree = 1620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174911,0.0269977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311046,0.0676252) , 
2, -1.67234, 1, 0, 0.228482,0.0712257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545377,0.00781087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734975,-0.0444629) , 
2, 1.41587, 1, 0, 0.563301,0.00585794) , 
2, -1.30053, 1, 0, 0.51911,0.0144854)    );
  // itree = 1621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445524,0.028514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679789,0.00605884) , 
2, 0.233343, 1, 0, 0.495812,0.0412724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.586973,-0.0135033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90607,0.0276035) , 
2, 1.64143, 1, 0, 0.632056,-0.0173298) , 
0, 0.607167, 1, 0, 0.548047,0.0188046)    );
  // itree = 1622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447524,0.00024119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704854,-0.0216621) , 
2, 0.763417, 1, 0, 0.507234,-0.0093398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.88325,0.0397532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673145,-0.00727688) , 
1, 0.30816, 1, 0, 0.821831,0.0528467) , 
0, 2.41389, 1, 0, 0.534652,-0.0039202)    );
  // itree = 1623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17412,-0.00324587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340334,-0.0268705) , 
3, -0.548764, 1, 0, 0.248055,-0.0322103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.73324,-0.0144138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781733,0.0178893) , 
1, -0.584815, 1, 0, 0.764825,0.0130353) , 
3, 0.240737, 1, 0, 0.48425,-0.0115303)    );
  // itree = 1624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173252,-0.00639492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315179,-0.030037) , 
3, -0.423051, 1, 0, 0.201847,-0.0247571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.828312,0.0290476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655599,-0.00403431) , 
0, -0.252128, 1, 0, 0.682009,0.000886776) , 
3, -0.184246, 1, 0, 0.481663,-0.00981303)    );
  // itree = 1625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279775,0.0304181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341092,-0.00772041) , 
0, -1.15832, 1, 0, 0.303496,0.0233591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297674,-0.0848435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600995,-0.00928778) , 
2, -0.0906476, 1, 0, 0.568016,-0.0410633) , 
2, -0.281173, 1, 0, 0.467469,-0.0165756)    );
  // itree = 1626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155109,-0.038946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120347,-0.0142392) , 
1, 0.032123, 1, 0, 0.137577,-0.0542835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570718,-0.00793081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620179,0.0142988) , 
1, 0.38739, 1, 0, 0.586951,-0.00109575) , 
2, -0.876457, 1, 0, 0.471796,-0.0147255)    );
  // itree = 1627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433302,-0.0217671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814165,0.0289413) , 
0, 1.19101, 1, 0, 0.517661,-0.0170666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340328,0.0111482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832501,0.0306461) , 
3, 0.810124, 1, 0, 0.500459,0.0349423) , 
1, -0.249118, 1, 0, 0.50834,0.011115)    );
  // itree = 1628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.064998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490705,9.51387e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711404,-0.0303677) , 
2, 1.48238, 1, 0, 0.508374,-0.00456464) , 
2, -2.07983, 1, 0, 0.49434,-0.00729929)    );
  // itree = 1629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124787,-0.0103585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514769,0.0289001) , 
3, -0.951251, 1, 0, 0.32337,0.0209224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51548,-0.0219172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885193,0.0144991) , 
3, 1.31406, 1, 0, 0.634287,-0.0250852) , 
2, -0.281514, 1, 0, 0.504008,-0.00580727)    );
  // itree = 1630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471427,-0.0157596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.631001,0.033947) , 
1, -1.79488, 1, 0, 0.593575,0.0364178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424555,-0.0166856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541866,0.00941035) , 
1, 0.940268, 1, 0, 0.446013,-0.0233417) , 
1, -0.962158, 1, 0, 0.471391,-0.0130641)    );
  // itree = 1631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503022,0.0222703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41704,-0.013523) , 
1, 0.753858, 1, 0, 0.482728,0.0244432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.79959,0.000520891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575737,-0.0286766) , 
1, -0.294962, 1, 0, 0.673663,-0.0317993) , 
0, 1.23253, 1, 0, 0.528161,0.0110603)    );
  // itree = 1632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278517,-0.00399098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241811,-0.0349105) , 
0, -1.642, 1, 0, 0.262384,-0.0369809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34659,0.0154523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780451,-0.00835252) , 
3, 0.604772, 1, 0, 0.553927,0.00876118) , 
0, -0.947009, 1, 0, 0.468289,-0.0046751)    );
  // itree = 1633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291452,-0.0252297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814832,0.0186428) , 
2, -0.0977814, 1, 0, 0.572103,-0.00855082) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.075566,-0.0468577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574881,0.0286012) , 
0, -2.96804, 1, 0, 0.544719,0.0496504) , 
1, -0.411712, 1, 0, 0.553651,0.0306671)    );
  // itree = 1634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377952,0.0199774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61736,0.000801165) , 
0, -0.773058, 1, 0, 0.535142,0.0133135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626022,0.0570991) , 
1, 1.9438, 1, 0, 0.537548,0.0159916)    );
  // itree = 1635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288481,-0.0084334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506171,-0.0326384) , 
2, -0.286246, 1, 0, 0.358917,-0.0345109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567412,0.0427953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643871,-0.00401189) , 
2, -0.0397122, 1, 0, 0.633058,0.00550243) , 
0, 0.0848771, 1, 0, 0.479187,-0.0169564)    );
  // itree = 1636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1748,0.114094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688147,0.0124408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483996,-0.0144866) , 
1, -0.759733, 1, 0, 0.533233,-0.017825) , 
3, -2.28271, 1, 0, 0.520527,-0.0131492)    );
  // itree = 1637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191114,0.0379611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277203,0.103845) , 
1, 0.930079, 1, 0, 0.211064,0.0763016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405362,-0.0167264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703977,0.0145378) , 
2, 0.224671, 1, 0, 0.553452,-0.00109138) , 
2, -1.32298, 1, 0, 0.514805,0.00764441)    );
  // itree = 1638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283166,0.000190364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797351,-0.0198166) , 
3, 0.13833, 1, 0, 0.399426,-0.00828434) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.665704,0.0181093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436361,-0.036178) , 
1, 0.97732, 1, 0, 0.631031,0.0183397) , 
0, 0.510979, 1, 0, 0.480818,0.00107205)    );
  // itree = 1639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557613,-0.00404724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494429,0.0220125) , 
1, 0.0402461, 1, 0, 0.530776,0.0121358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229459,-0.0377624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.795809,0.00778167) , 
3, 0.2961, 1, 0, 0.496346,-0.0524136) , 
1, 1.44833, 1, 0, 0.527516,0.00602268)    );
  // itree = 1640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.760797,0.0536527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52357,0.000962574) , 
1, -2.01258, 1, 0, 0.532977,0.00572291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145983,-0.0230967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.662632,-0.0559365) , 
3, -0.148607, 1, 0, 0.40319,-0.0856343) , 
1, 1.63891, 1, 0, 0.525519,0.000473111)    );
  // itree = 1641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38191,-0.00414956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629641,0.0145067) , 
0, 0.00728782, 1, 0, 0.483776,0.00786121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.65085,-0.0302112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.934846,0.0299778) , 
3, 2.42775, 1, 0, 0.703849,-0.0405413) , 
2, 1.08804, 1, 0, 0.520768,-0.000274801)    );
  // itree = 1642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450373,-0.0768485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55743,-0.0217243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462235,-0.000288965) , 
1, -0.695454, 1, 0, 0.487325,-0.0110552) , 
1, -2.00084, 1, 0, 0.486095,-0.0165321)    );
  // itree = 1643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542432,-0.00527938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.530721,-0.0657786) , 
1, -0.744634, 1, 0, 0.541122,-0.021796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547911,0.0438104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504606,0.00877037) , 
1, -0.374329, 1, 0, 0.509064,0.026954) , 
1, -0.605638, 1, 0, 0.518498,0.012608)    );
  // itree = 1644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.731212,0.0545708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130036,-0.0243793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571418,-0.00112589) , 
2, -1.23085, 1, 0, 0.498176,-0.00899676) , 
1, -1.86485, 1, 0, 0.50709,-0.00464619)    );
  // itree = 1645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436901,0.0245719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280832,-0.0101177) , 
1, 0.524261, 1, 0, 0.393871,0.028937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.920203,0.0388161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766168,-0.0253624) , 
1, -1.31849, 1, 0, 0.782035,-0.0324168) , 
3, 0.575013, 1, 0, 0.534516,0.0067064)    );
  // itree = 1646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295669,-0.014225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365664,-0.0526219) , 
2, -0.258131, 1, 0, 0.307089,-0.0434737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49929,-0.0332392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667801,0.0182292) , 
1, -1.58517, 1, 0, 0.650452,0.0232538) , 
2, -0.0385962, 1, 0, 0.468546,-0.012097)    );
  // itree = 1647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.757239,0.0341008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461351,-0.00235907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726383,-0.0346537) , 
0, 3.19023, 1, 0, 0.469148,-0.00669425) , 
1, -2.00084, 1, 0, 0.477404,-0.00454176)    );
  // itree = 1648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462814,0.00302847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637,-0.0238072) , 
0, 0.543532, 1, 0, 0.531278,-0.0136102) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611721,0.042493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445244,-0.000636191) , 
1, 0.650855, 1, 0, 0.49789,0.0281963) , 
1, 0.353959, 1, 0, 0.520428,-2.462e-05)    );
  // itree = 1649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385297,-0.0163523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651267,0.00447972) , 
0, 0.456819, 1, 0, 0.489136,-0.0158554) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343046,0.0236841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.911022,0.0754133) , 
2, 0.0985686, 1, 0, 0.562054,0.0997909) , 
1, 1.41092, 1, 0, 0.494328,-0.00761964)    );
  // itree = 1650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343871,0.0660274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301236,0.00146939) , 
2, -1.99943, 1, 0, 0.304577,0.0126932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405657,-0.0228951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812119,0.00489178) , 
3, 0.636867, 1, 0, 0.603886,-0.0222728) , 
2, -0.455656, 1, 0, 0.4966,-0.00973934)    );
  // itree = 1651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506869,0.00270086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345183,-0.029133) , 
1, 0.407131, 1, 0, 0.467745,-0.00961069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495042,0.043694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613464,-0.00692745) , 
2, 0.602828, 1, 0, 0.528143,0.0682883) , 
1, 0.990731, 1, 0, 0.476182,0.00127077)    );
  // itree = 1652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0607382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361813,0.00346965) , 
0, -3.66617, 1, 0, 0.341952,0.000690228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488118,-0.0264087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664188,-0.00299783) , 
0, 1.16801, 1, 0, 0.566116,-0.031865) , 
0, -0.233659, 1, 0, 0.460703,-0.016556)    );
  // itree = 1653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405153,-0.00206849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.819125,0.0549074) , 
2, 0.134681, 1, 0, 0.448768,0.0067852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42033,-0.041062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.731026,0.00184362) , 
2, 0.725521, 1, 0, 0.625674,-0.025568) , 
2, 0.370993, 1, 0, 0.522492,-0.00669762)    );
  // itree = 1654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54588,0.0318569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282825,-0.0149983) , 
1, -1.03439, 1, 0, 0.324924,-0.0156544) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.818976,0.0213633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.79437,-0.0156018) , 
2, 1.52129, 1, 0, 0.814731,0.0276527) , 
3, 0.569166, 1, 0, 0.509338,0.000650893)    );
  // itree = 1655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165628,-0.0235851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297825,0.0080877) , 
2, -0.556969, 1, 0, 0.197197,-0.0270151) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514611,0.031553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737128,-0.00280437) , 
3, 0.334789, 1, 0, 0.672653,0.0160473) , 
3, -0.326776, 1, 0, 0.511548,0.00145586)    );
  // itree = 1656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27969,-0.0340384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.765606,-0.0125569) , 
2, 0.412884, 1, 0, 0.497414,-0.0567989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333539,-0.00367514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.742716,0.0136814) , 
2, 0.162129, 1, 0, 0.496242,0.00625341) , 
1, -1.71686, 1, 0, 0.496312,0.00246034)    );
  // itree = 1657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189807,-0.0493065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0796022,-0.0277211) , 
1, -0.212095, 1, 0, 0.124942,-0.0911155) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446818,0.00342575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619761,-0.0125542) , 
0, 0.382589, 1, 0, 0.5198,-0.00700849) , 
0, -2.97825, 1, 0, 0.493945,-0.0125159)    );
  // itree = 1658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139099,0.00101385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440565,-0.0227762) , 
3, -0.638611, 1, 0, 0.261715,-0.0225386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632265,0.0105367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778,-0.024623) , 
2, 1.61913, 1, 0, 0.646636,0.0135705) , 
2, -0.281514, 1, 0, 0.478605,-0.00219238)    );
  // itree = 1659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273691,0.0110413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48579,-0.0123451) , 
0, -1.65426, 1, 0, 0.4464,-0.0164852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.745642,0.0306828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.89836,0.0105786) , 
3, 2.11747, 1, 0, 0.8232,0.0508774) , 
0, 2.13497, 1, 0, 0.484171,-0.00973271)    );
  // itree = 1660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508219,-0.0162059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.532469,0.0164964) , 
1, -1.37195, 1, 0, 0.529434,0.0239916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325118,-0.0471679) , 
1, 1.75209, 1, 0, 0.518529,0.0180831)    );
  // itree = 1661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112358,-0.00304246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597954,0.0199144) , 
3, -1.05975, 1, 0, 0.486389,0.0310114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.899408,0.02583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544153,-0.0225709) , 
1, -0.421024, 1, 0, 0.66237,-0.0175469) , 
0, 1.54549, 1, 0, 0.524552,0.0204812)    );
  // itree = 1662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193256,-0.00773137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158817,-0.0562847) , 
2, -1.41037, 1, 0, 0.177087,-0.071348) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541785,-0.00594791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558083,0.0408402) , 
1, 1.09458, 1, 0, 0.543595,-0.00279088) , 
0, -2.26038, 1, 0, 0.504682,-0.0100698)    );
  // itree = 1663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947411,-0.0171842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42132,0.057984) , 
3, -1.58546, 1, 0, 0.277721,0.056543) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531993,-0.00363071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386267,-0.0459292) , 
1, 1.41092, 1, 0, 0.518858,-0.0152748) , 
2, -1.13773, 1, 0, 0.485284,-0.00527535)    );
  // itree = 1664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508531,0.0019558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508676,0.0233759) , 
1, 0.926167, 1, 0, 0.50855,0.0101959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418749,-0.0548452) , 
1, 1.59556, 1, 0, 0.503947,0.0050924)    );
  // itree = 1665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314395,-0.00737435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364559,0.0176085) , 
1, 0.0687374, 1, 0, 0.337244,0.00462042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596474,-0.027033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.903521,0.00921407) , 
3, 1.62155, 1, 0, 0.681038,-0.0406185) , 
2, 0.161708, 1, 0, 0.488357,-0.0152641)    );
  // itree = 1666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474812,0.00585517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700567,0.0421567) , 
1, -1.62789, 1, 0, 0.574282,0.0360719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391555,0.000110945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613776,-0.0142875) , 
0, 0.624233, 1, 0, 0.47203,-0.00975701) , 
1, -1.12811, 1, 0, 0.486622,-0.00321663)    );
  // itree = 1667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178081,-0.0254907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.693327,0.00181836) , 
2, -0.492702, 1, 0, 0.507204,-0.0193079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506161,0.011049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518518,0.0377112) , 
1, 1.31322, 1, 0, 0.508193,0.0287579) , 
1, -0.362514, 1, 0, 0.507785,0.00890925)    );
  // itree = 1668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386222,0.0610402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336716,-0.0350549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528212,-0.00314375) , 
1, -1.71006, 1, 0, 0.511838,-0.0126132) , 
0, -2.98821, 1, 0, 0.505891,-0.0060831)    );
  // itree = 1669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632807,0.043029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.635858,-0.0196564) , 
0, 1.05567, 1, 0, 0.633848,0.0266961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291804,-0.0146665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637134,0.00266562) , 
0, -0.138259, 1, 0, 0.454392,-0.0119849) , 
1, -0.962158, 1, 0, 0.486952,-0.00496671)    );
  // itree = 1670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390161,-0.0492449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559681,0.00978521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416755,-0.0192404) , 
1, 1.38646, 1, 0, 0.544416,0.0130613) , 
1, -2.00084, 1, 0, 0.538347,0.00805642)    );
  // itree = 1671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421395,0.0815773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67611,0.0114729) , 
0, -1.65737, 1, 0, 0.630385,0.0426662) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460663,-0.00959229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501371,0.0181718) , 
1, 0.839801, 1, 0, 0.46985,-0.00618615) , 
1, -1.12811, 1, 0, 0.493287,0.000945904)    );
  // itree = 1672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563148,0.0266581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73926,-0.0123284) , 
2, 0.799265, 1, 0, 0.604991,0.0311854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407803,-0.00433138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37875,-0.0277892) , 
1, 0.697656, 1, 0, 0.39274,-0.03307) , 
1, 0.0462137, 1, 0, 0.50081,-0.000353646)    );
  // itree = 1673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246431,0.0445148) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249626,-0.0146705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61276,0.000505256) , 
2, -0.582949, 1, 0, 0.495056,-0.00860246) , 
2, -2.07855, 1, 0, 0.488774,-0.00651156)    );
  // itree = 1674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238703,-0.0216147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667456,0.0352705) , 
0, -2.33061, 1, 0, 0.593889,0.0327565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494734,-0.0448213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500972,0.00212734) , 
1, -0.685314, 1, 0, 0.500449,-0.0057964) , 
1, -0.921358, 1, 0, 0.520316,0.0024005)    );
  // itree = 1675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200732,0.0538904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51938,-0.0129614) , 
3, -1.62955, 1, 0, 0.493203,-0.0179669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109103,-0.00556044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66937,0.0238982) , 
3, -0.759675, 1, 0, 0.509259,0.0328557) , 
1, 0.463922, 1, 0, 0.498052,-0.00261707)    );
  // itree = 1676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501165,0.0425503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610371,-0.00680415) , 
0, -0.439502, 1, 0, 0.569145,0.0208475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206855,-0.0391323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751896,0.00539085) , 
3, 0.521632, 1, 0, 0.395441,-0.0427886) , 
1, 0.476476, 1, 0, 0.515174,0.0010754)    );
  // itree = 1677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233578,0.0526394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140391,-0.0319251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579008,0.00752048) , 
2, -1.45094, 1, 0, 0.537867,0.00807211) , 
2, -2.04101, 1, 0, 0.526437,0.0110869)    );
  // itree = 1678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0506884,-0.0508185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41102,0.00452585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638421,-0.0128354) , 
2, 0.316895, 1, 0, 0.507115,-0.00676094) , 
2, -1.99878, 1, 0, 0.489553,-0.0110838)    );
  // itree = 1679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153418,-0.00429344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354467,-0.0393186) , 
3, -0.776089, 1, 0, 0.206711,-0.0326459) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542681,0.0392626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666718,-0.00252083) , 
2, -0.133932, 1, 0, 0.639236,0.0117151) , 
2, -0.585857, 1, 0, 0.497787,-0.00279226)    );
  // itree = 1680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214856,0.00658018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622747,0.0453222) , 
3, -0.542359, 1, 0, 0.269436,0.0286494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.661785,-0.0106081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818648,0.0559716) , 
1, 1.41092, 1, 0, 0.673298,-0.0144673) , 
3, -0.25059, 1, 0, 0.516264,0.0022978)    );
  // itree = 1681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197825,-0.00290942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204628,-0.0433254) , 
0, -1.38041, 1, 0, 0.200089,-0.038957) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.549046,-0.00255684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750981,0.0435548) , 
1, 0.659513, 1, 0, 0.591483,0.0159376) , 
2, -0.883803, 1, 0, 0.496071,0.00255562)    );
  // itree = 1682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353813,0.0241858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553364,-0.0128205) , 
2, -1.15149, 1, 0, 0.530355,-0.0160703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148485,-0.00793019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725726,0.0185656) , 
3, -0.203844, 1, 0, 0.481775,0.0177979) , 
1, 0.0411464, 1, 0, 0.507129,0.000122094)    );
  // itree = 1683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125359,-0.0495742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146999,-0.0122104) , 
1, -1.41633, 1, 0, 0.145109,-0.0310746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.850743,0.0578193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723638,0.00635888) , 
2, -0.372833, 1, 0, 0.737862,0.0247561) , 
3, -0.38184, 1, 0, 0.510788,0.00336823)    );
  // itree = 1684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118503,0.0602273) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190537,-0.0243504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559229,-0.00211278) , 
2, -1.04335, 1, 0, 0.486,-0.0133429) , 
3, -2.24033, 1, 0, 0.474048,-0.0109322)    );
  // itree = 1685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615593,0.0253233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379056,-0.000509416) , 
1, -0.97244, 1, 0, 0.419498,0.0060649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231544,-0.0335826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83168,-0.00428881) , 
3, 1.11225, 1, 0, 0.606162,-0.0380745) , 
0, 0.842728, 1, 0, 0.483229,-0.00900522)    );
  // itree = 1686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455004,0.000294097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808587,0.0249755) , 
2, 0.431503, 1, 0, 0.606573,0.0226679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443314,-0.017306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491302,-0.000308507) , 
1, 0.515096, 1, 0, 0.467488,-0.018453) , 
1, -0.36158, 1, 0, 0.520507,-0.00277777)    );
  // itree = 1687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206902,-0.0186219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655012,0.0111172) , 
2, -0.437416, 1, 0, 0.477464,0.000877895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477934,0.0232526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.8978,0.079923) , 
0, 1.5988, 1, 0, 0.593161,0.0890782) , 
1, 1.15272, 1, 0, 0.489989,0.010426)    );
  // itree = 1688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165784,0.00229007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652904,0.0364254) , 
3, -0.776089, 1, 0, 0.345996,0.0340861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.755896,0.0338006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582948,-0.0187158) , 
2, -0.263803, 1, 0, 0.594533,-0.0320953) , 
2, -0.492023, 1, 0, 0.511644,-0.0100233)    );
  // itree = 1689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364172,-0.01022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701305,0.0142516) , 
2, 0.212717, 1, 0, 0.509884,0.0027554) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165791,0.00162593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453691,-0.0435356) , 
3, -0.759041, 1, 0, 0.39417,-0.0735489) , 
1, 1.32833, 1, 0, 0.495932,-0.00644493)    );
  // itree = 1690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791394,0.0297628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507409,-0.0356454) , 
1, -2.03212, 1, 0, 0.548874,-0.0508213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252717,-0.0148272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780047,0.00795179) , 
3, 0.301115, 1, 0, 0.463541,-0.0115803) , 
1, -0.962158, 1, 0, 0.480718,-0.0194795)    );
  // itree = 1691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287917,0.0215084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266105,-0.036024) , 
0, -2.05822, 1, 0, 0.274517,-0.033005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615625,0.0167384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559554,-0.0118167) , 
1, 0.806267, 1, 0, 0.605091,0.0211502) , 
0, -1.02119, 1, 0, 0.508035,0.00525036)    );
  // itree = 1692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573783,0.00090685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65151,0.0369109) , 
1, -0.790389, 1, 0, 0.591044,0.0184593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482452,-0.0440048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428847,-0.00986883) , 
1, -0.305124, 1, 0, 0.435274,-0.0277775) , 
1, -0.493896, 1, 0, 0.485061,-0.0129994)    );
  // itree = 1693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.761461,0.0467777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538945,-0.0125416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484824,0.00782118) , 
1, -0.734818, 1, 0, 0.499176,0.00378108) , 
1, -1.86485, 1, 0, 0.510768,0.00808443)    );
  // itree = 1694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533324,-0.0628833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517599,-0.0122498) , 
2, -1.63878, 1, 0, 0.480953,-0.0296661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518573,0.0746729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700977,0.0103399) , 
0, -0.0301059, 1, 0, 0.639935,0.0531359) , 
1, 1.30691, 1, 0, 0.495015,-0.0223425)    );
  // itree = 1695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153143,-0.00752437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556188,0.0138041) , 
2, -1.17452, 1, 0, 0.471241,0.0172721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561522,-0.0202269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.930119,0.0157771) , 
3, 2.24446, 1, 0, 0.651599,-0.0294862) , 
0, 1.63755, 1, 0, 0.507956,0.00775364)    );
  // itree = 1696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442501,-0.000208455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.918128,0.06268) , 
2, 1.32482, 1, 0, 0.465031,0.00414467) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.765136,0.00393711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514244,-0.0531317) , 
1, -0.218242, 1, 0, 0.640969,-0.0645271) , 
0, 2.04684, 1, 0, 0.483644,-0.00312031)    );
  // itree = 1697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257151,0.0387263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114992,-0.018614) , 
1, 0.846826, 1, 0, 0.222732,0.0329298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341164,-0.0244617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.67285,0.00288586) , 
2, 0.0606258, 1, 0, 0.523781,-0.0173482) , 
2, -1.199, 1, 0, 0.48208,-0.0103836)    );
  // itree = 1698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.62385,0.0788435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754582,0.00890065) , 
3, -0.0502295, 1, 0, 0.713788,0.0756696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511255,0.00198535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395954,-0.0186252) , 
1, 0.771146, 1, 0, 0.483054,-0.00660669) , 
1, -1.54527, 1, 0, 0.502087,0.000180257)    );
  // itree = 1699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404046,-0.000709488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617228,-0.0243689) , 
2, 0.424409, 1, 0, 0.465285,-0.0140995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.859242,0.000498112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.86123,0.0355001) , 
1, -0.386007, 1, 0, 0.86045,0.0574237) , 
2, 1.3621, 1, 0, 0.500267,-0.00776781)    );
  // itree = 1700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409084,-0.025978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.783623,0.0088868) , 
0, 1.41046, 1, 0, 0.488659,-0.0394731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597068,0.0442812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456355,-0.00320985) , 
1, 0.159036, 1, 0, 0.487256,0.0135717) , 
1, -0.249118, 1, 0, 0.487888,-0.0103189)    );
  // itree = 1701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218238,-0.0188668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525155,0.00578969) , 
0, -2.1981, 1, 0, 0.483956,0.00308405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763668,-0.0147294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606989,-0.0665108) , 
1, 0.114884, 1, 0, 0.707744,-0.069788) , 
2, 1.49137, 1, 0, 0.500749,-0.00238433)    );
  // itree = 1702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226284,0.0166056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237593,0.067061) , 
1, 0.53526, 1, 0, 0.230138,0.0526595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379535,-0.0315894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674287,-0.00240947) , 
2, -0.787848, 1, 0, 0.648085,-0.0125397) , 
3, -0.639447, 1, 0, 0.544415,0.00363255)    );
  // itree = 1703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519285,0.00555806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546894,0.0398766) , 
1, 0.285162, 1, 0, 0.526019,0.0255487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253781,-0.0436704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570453,-0.0117172) , 
2, -0.172323, 1, 0, 0.437786,-0.0566525) , 
1, 1.0353, 1, 0, 0.512979,0.0134002)    );
  // itree = 1704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417467,-0.00588325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777353,0.0125492) , 
2, 0.604931, 1, 0, 0.5209,-0.00155548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151497,-0.0405008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789693,0.00198757) , 
3, 0.195173, 1, 0, 0.367489,-0.0584566) , 
1, 0.990731, 1, 0, 0.493435,-0.0117425)    );
  // itree = 1705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32749,0.020028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560869,-0.0116853) , 
2, -0.876457, 1, 0, 0.518826,-0.0122268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479191,0.0223273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644695,-0.0176562) , 
0, 1.79673, 1, 0, 0.502395,0.0234323) , 
1, 0.0411464, 1, 0, 0.511396,0.00389813)    );
  // itree = 1706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196415,-0.00380373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190375,-0.0258523) , 
2, -0.504577, 1, 0, 0.194999,-0.0175462) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.774441,-0.00828359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69823,0.0176268) , 
1, -0.605638, 1, 0, 0.720735,0.0211923) , 
3, -0.103721, 1, 0, 0.497591,0.00475009)    );
  // itree = 1707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353374,-0.00969879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391914,0.0200879) , 
1, 1.40358, 1, 0, 0.357206,-0.0124172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.829573,0.0770496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695022,0.00786314) , 
0, -0.016707, 1, 0, 0.721009,0.0384875) , 
2, 0.0582897, 1, 0, 0.531409,0.0119579)    );
  // itree = 1708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311154,0.0929368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224481,0.0247264) , 
2, -2.04368, 1, 0, 0.25113,0.0815786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439367,-0.0124087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658125,0.00298136) , 
0, 0.562753, 1, 0, 0.528458,-0.0116012) , 
2, -1.68013, 1, 0, 0.505387,-0.00384943)    );
  // itree = 1709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917256,-0.0304984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429655,0.0186142) , 
2, -2.10443, 1, 0, 0.403713,0.0259734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531859,-0.0125714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726206,0.0113014) , 
2, 0.694561, 1, 0, 0.608048,-0.00692493) , 
0, -0.439502, 1, 0, 0.520562,0.00716055)    );
  // itree = 1710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516965,-0.0183833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543159,0.0155492) , 
1, -1.29737, 1, 0, 0.538836,0.0182582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274975,-0.0559517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405058,-0.00613708) , 
1, 0.81228, 1, 0, 0.386919,-0.0278786) , 
1, 0.65094, 1, 0, 0.4932,0.00439851)    );
  // itree = 1711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318603,0.0247923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415543,-0.0109226) , 
0, -3.31264, 1, 0, 0.411265,-0.0181283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878492,-0.0104637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.872557,0.0274673) , 
1, -0.421024, 1, 0, 0.874828,0.0294056) , 
3, 1.20869, 1, 0, 0.5053,-0.00848588)    );
  // itree = 1712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352191,0.000170866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585864,0.0240139) , 
2, -0.312972, 1, 0, 0.384475,0.00740607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444801,-0.0167301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.852545,0.00730774) , 
3, 1.00882, 1, 0, 0.627175,-0.0157277) , 
2, -0.0977814, 1, 0, 0.52365,-0.00585982)    );
  // itree = 1713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220526,-0.00559503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62006,0.0142277) , 
3, -0.0286683, 1, 0, 0.382591,0.00644463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.835001,-0.044475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.852341,-0.00298994) , 
1, 0.723506, 1, 0, 0.840778,-0.0435686) , 
3, 1.22805, 1, 0, 0.462759,-0.00230605)    );
  // itree = 1714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255117,0.0250099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337725,-0.00454484) , 
0, -2.78053, 1, 0, 0.33077,-0.00417277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.852706,0.00944575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.840157,0.0353071) , 
0, 2.89947, 1, 0, 0.8508,0.0271343) , 
3, 0.660704, 1, 0, 0.505243,0.00633093)    );
  // itree = 1715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0856813,-0.0509853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18731,-0.0150594) , 
2, -1.91655, 1, 0, 0.15279,-0.0639685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32335,0.0223863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696824,-0.00570969) , 
3, -0.189791, 1, 0, 0.595309,0.00335441) , 
2, -1.27668, 1, 0, 0.533922,-0.00598477)    );
  // itree = 1716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217151,-0.0208124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263718,0.0201224) , 
1, 0.761126, 1, 0, 0.228566,-0.0234777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.73634,0.0126029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63047,-0.0144635) , 
1, 0.38739, 1, 0, 0.704603,0.00978427) , 
3, -0.123397, 1, 0, 0.505639,-0.00411784)    );
  // itree = 1717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477963,-0.0552257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512754,-0.054287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549855,0.00568625) , 
0, -3.16923, 1, 0, 0.52923,0.00551255) , 
1, -2.14051, 1, 0, 0.527685,0.000370642)    );
  // itree = 1718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299654,0.0135049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385177,-0.00694607) , 
0, -0.945227, 1, 0, 0.333869,0.00795752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567309,-0.0105289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619803,-0.0414412) , 
2, 0.829213, 1, 0, 0.590549,-0.0528895) , 
2, 0.0724854, 1, 0, 0.457041,-0.0212409)    );
  // itree = 1719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387135,-0.024496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335507,-0.00110939) , 
1, -0.89377, 1, 0, 0.346161,-0.0116956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.693344,0.0609897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.740355,-0.00169038) , 
2, 0.560818, 1, 0, 0.731696,0.0208287) , 
2, 0.380334, 1, 0, 0.489021,0.000356334)    );
  // itree = 1720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14078,-0.027467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590684,0.00742575) , 
2, -1.23141, 1, 0, 0.531922,0.00672485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368809,-0.00549041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673243,-0.0296231) , 
2, 0.30786, 1, 0, 0.462643,-0.0286268) , 
1, 0.527161, 1, 0, 0.512624,-0.00312218)    );
  // itree = 1721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364242,-0.0246226) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642678,0.0231848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425647,-0.00351966) , 
1, -0.609385, 1, 0, 0.484819,0.00504269) , 
1, -1.84449, 1, 0, 0.477468,0.00110481)    );
  // itree = 1722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0417815,-0.047947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502842,-0.00298217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544073,0.0223069) , 
1, 1.16441, 1, 0, 0.507641,2.26144e-05) , 
2, -1.98076, 1, 0, 0.486254,-0.0043975)    );
  // itree = 1723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340177,0.00873218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325384,-0.0137855) , 
0, -0.41806, 1, 0, 0.334507,-0.00210933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.842964,0.0234113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768128,-0.00486518) , 
0, 2.54864, 1, 0, 0.824073,0.0289874) , 
3, 0.742264, 1, 0, 0.487368,0.00760022)    );
  // itree = 1724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.69116,0.0605483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.7415,-0.0138827) , 
0, 1.5407, 1, 0, 0.704832,0.0676929) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196195,0.0425209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.486947,-0.00369107) , 
2, -2.07855, 1, 0, 0.478736,-0.00536413) , 
1, -1.31868, 1, 0, 0.501152,0.00187924)    );
  // itree = 1725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0999169,-0.0724873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175527,-0.0297371) , 
1, -0.546181, 1, 0, 0.152454,-0.0970958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469148,0.0104515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669904,-0.0239263) , 
2, 0.650346, 1, 0, 0.523964,0.00150767) , 
0, -2.46434, 1, 0, 0.485315,-0.00875019)    );
  // itree = 1726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241434,0.0401699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393238,-0.0124311) , 
0, -3.13335, 1, 0, 0.383086,-0.0180986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.693093,0.00343131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763407,0.0421968) , 
1, -0.0924542, 1, 0, 0.725996,0.0412725) , 
0, 0.619485, 1, 0, 0.498824,0.00194023)    );
  // itree = 1727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514518,-0.0113922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59327,0.0202379) , 
1, -0.986376, 1, 0, 0.551642,0.00863624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45487,-0.030377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531302,0.00133124) , 
1, 0.368249, 1, 0, 0.498103,-0.0237567) , 
1, -0.329431, 1, 0, 0.519137,-0.0110303)    );
  // itree = 1728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245,-0.0179448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.917997,0.0122748) , 
3, 0.205934, 1, 0, 0.360789,-0.0265835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.676178,0.018176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673659,-0.0183541) , 
0, 2.39213, 1, 0, 0.675653,0.0194877) , 
0, 0.510979, 1, 0, 0.476926,-0.00959023)    );
  // itree = 1729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167072,-0.00352769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510308,0.0185854) , 
3, -0.556192, 1, 0, 0.309393,0.0148765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.756354,-0.00698608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.597781,-0.0450938) , 
1, 0.564685, 1, 0, 0.717136,-0.0325704) , 
3, 0.262941, 1, 0, 0.491344,-0.00629609)    );
  // itree = 1730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192458,-0.0277288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200874,-0.00243424) , 
1, 0.503708, 1, 0, 0.194585,-0.0464833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420099,0.066029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565763,0.00676084) , 
2, -1.16582, 1, 0, 0.553221,0.0218273) , 
0, -2.24937, 1, 0, 0.513159,0.0141967)    );
  // itree = 1731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356118,-0.0037471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617552,-0.0259317) , 
2, 0.0761576, 1, 0, 0.47104,-0.0251581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.82272,0.0423539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.879492,0.00607507) , 
2, 1.57971, 1, 0, 0.843805,0.0701267) , 
0, 2.41389, 1, 0, 0.498281,-0.0181949)    );
  // itree = 1732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257368,-0.028061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574322,0.0154834) , 
0, -0.56124, 1, 0, 0.299857,-0.0430975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454654,0.0213323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776171,-0.0103278) , 
3, 0.74767, 1, 0, 0.657871,0.00370445) , 
0, -0.184813, 1, 0, 0.485575,-0.0188192)    );
  // itree = 1733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455682,-0.0350609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347552,-0.00142671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705424,0.0123633) , 
0, 0.0848771, 1, 0, 0.500602,0.0103494) , 
1, -2.23323, 1, 0, 0.499127,0.00645697)    );
  // itree = 1734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456036,0.000146143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415695,-0.0170146) , 
1, -0.0246959, 1, 0, 0.437812,-0.0140805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.832525,0.0891796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689848,-0.0130321) , 
0, 2.27478, 1, 0, 0.730537,0.0500344) , 
0, 2.02942, 1, 0, 0.469073,-0.00723351)    );
  // itree = 1735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616835,-0.00828504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.622353,0.0249737) , 
1, -1.49005, 1, 0, 0.620388,0.0227633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363881,-0.0323555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421961,-0.00349251) , 
1, -0.186502, 1, 0, 0.411102,-0.0183615) , 
1, -0.501212, 1, 0, 0.479706,-0.00488072)    );
  // itree = 1736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.683984,0.067388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.863465,0.00921076) , 
3, 0.471031, 1, 0, 0.764681,0.0654792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48383,-0.0417946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415397,-0.0139732) , 
1, -0.443224, 1, 0, 0.433245,-0.0413798) , 
1, -1.41819, 1, 0, 0.46044,-0.0326118)    );
  // itree = 1737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514648,0.0283875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338041,-0.00886324) , 
1, -0.765596, 1, 0, 0.380979,-0.00125299) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169264,-0.0346198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748425,-0.0080298) , 
3, 0.651905, 1, 0, 0.600434,-0.0316026) , 
0, 0.510979, 1, 0, 0.473877,-0.0141003)    );
  // itree = 1738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353121,0.00302845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602445,0.0344919) , 
0, -0.196978, 1, 0, 0.417505,0.0196381) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597117,-0.0216112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88011,0.0126453) , 
2, 1.65015, 1, 0, 0.648819,-0.0331504) , 
0, 0.633831, 1, 0, 0.500801,0.000629008)    );
  // itree = 1739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383968,0.0136657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793723,-0.00513632) , 
3, 0.721686, 1, 0, 0.526454,0.0122706) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35142,-0.0176972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741925,0.0187632) , 
2, 0.683531, 1, 0, 0.428266,-0.0206754) , 
1, 0.988758, 1, 0, 0.506035,0.00541916)    );
  // itree = 1740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0767312,0.019968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418549,0.0508369) , 
3, -1.98858, 1, 0, 0.245717,0.0626235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428121,-0.00115066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625557,-0.0160553) , 
0, 0.455942, 1, 0, 0.520398,-0.0173754) , 
0, -2.24414, 1, 0, 0.498347,-0.010953)    );
  // itree = 1741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322538,0.101994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442529,-0.000479329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.74332,0.0184159) , 
0, 1.09919, 1, 0, 0.523324,0.00995014) , 
2, -2.02668, 1, 0, 0.517605,0.0146945)    );
  // itree = 1742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.608604,-0.0197424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276448,-0.0691563) , 
1, -1.54155, 1, 0, 0.487434,-0.10211) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534138,0.0139707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397462,-0.0147353) , 
1, 0.432016, 1, 0, 0.48035,0.0067382) , 
1, -1.37597, 1, 0, 0.481176,-0.00595461)    );
  // itree = 1743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187999,0.000696996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442906,-0.0202819) , 
2, -0.783045, 1, 0, 0.329398,-0.0223184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763062,0.0386156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690282,0.00770997) , 
1, -1.28092, 1, 0, 0.699983,0.0244182) , 
0, -0.106773, 1, 0, 0.506219,-1.84683e-05)    );
  // itree = 1744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40064,-0.0206223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.776134,0.0103785) , 
2, 0.445699, 1, 0, 0.551173,-0.0160937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475302,0.010538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36065,-0.00999781) , 
1, 1.2908, 1, 0, 0.454849,0.0128581) , 
1, -0.553853, 1, 0, 0.487167,0.00314447)    );
  // itree = 1745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145753,0.0183798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0887157,-0.0269506) , 
0, -3.30092, 1, 0, 0.0998834,-0.0285183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543616,0.0155337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691438,-0.0137798) , 
2, 0.987675, 1, 0, 0.570503,0.0189047) , 
2, -1.3293, 1, 0, 0.505503,0.0123548)    );
  // itree = 1746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457433,0.0116575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528323,-0.0413111) , 
0, -0.837093, 1, 0, 0.506899,-0.0556833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302152,0.0191968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724587,-0.00503671) , 
3, 0.165162, 1, 0, 0.513752,0.0118536) , 
1, -1.03815, 1, 0, 0.512383,-0.0016364)    );
  // itree = 1747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505672,-0.014468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515199,0.0181996) , 
1, -0.870929, 1, 0, 0.51273,0.0186658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177484,-0.00452509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531055,-0.052089) , 
3, -0.0180115, 1, 0, 0.35074,-0.0661303) , 
1, 1.48204, 1, 0, 0.499194,0.01158)    );
  // itree = 1748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460377,-0.0172088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47778,0.00636985) , 
1, -1.25139, 1, 0, 0.475273,0.00297438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.731183,-0.00153813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769404,0.0316704) , 
0, 1.86383, 1, 0, 0.754984,0.0431567) , 
0, 1.35651, 1, 0, 0.537391,0.011898)    );
  // itree = 1749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249807,-0.0061717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629258,0.0189299) , 
0, -1.676, 1, 0, 0.569854,0.032122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389315,-0.0362847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427297,-0.00673498) , 
1, 0.535152, 1, 0, 0.417939,-0.0275441) , 
1, 0.24729, 1, 0, 0.50162,0.0053222)    );
  // itree = 1750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181209,0.00269421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297185,0.0491065) , 
2, -1.2204, 1, 0, 0.224151,0.0276532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325616,-0.0278342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705914,0.00130598) , 
2, -0.114144, 1, 0, 0.586679,-0.016069) , 
2, -0.799088, 1, 0, 0.495912,-0.00512208)    );
  // itree = 1751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40625,-0.00687492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760384,0.0285876) , 
0, 1.84678, 1, 0, 0.423993,-0.00946133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.68832,-0.0356886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.83012,0.0273175) , 
1, -1.2919, 1, 0, 0.807928,0.0310505) , 
2, 0.892485, 1, 0, 0.495321,-0.00193502)    );
  // itree = 1752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36411,-0.00700066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836681,0.0529571) , 
2, 0.76672, 1, 0, 0.407542,-0.00378135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270201,-0.03432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832613,-0.00767892) , 
3, 1.39215, 1, 0, 0.616105,-0.0432711) , 
0, 1.21408, 1, 0, 0.458143,-0.0133623)    );
  // itree = 1753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0890309,-0.0154693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282692,-0.0450106) , 
2, -1.41484, 1, 0, 0.159546,-0.0543083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.590664,0.0205797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653289,-0.00678616) , 
0, 0.848852, 1, 0, 0.617851,0.0145812) , 
2, -1.0475, 1, 0, 0.527366,0.000980135)    );
  // itree = 1754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.594016,0.0335278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471735,-0.0104443) , 
2, 0.613593, 1, 0, 0.551937,0.0462257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443289,-0.00823281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723971,-0.0469989) , 
2, 1.65849, 1, 0, 0.457723,-0.0183228) , 
1, -1.52183, 1, 0, 0.46638,-0.0123918)    );
  // itree = 1755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.499613,0.00771988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.905732,0.0394285) , 
0, 0.277182, 1, 0, 0.692438,0.0432662) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315222,0.00851915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605401,-0.0129037) , 
2, -0.435163, 1, 0, 0.499002,-0.0118545) , 
1, -1.20134, 1, 0, 0.524594,-0.00456194)    );
  // itree = 1756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364207,0.00789291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41591,-0.0395852) , 
0, 0.830336, 1, 0, 0.369387,0.00512287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434909,-0.0267844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.859997,0.00652516) , 
3, 1.01994, 1, 0, 0.632909,-0.02689) , 
2, 0.0724854, 1, 0, 0.497477,-0.0104376)    );
  // itree = 1757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409202,0.00565636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663697,0.0354376) , 
0, 0.734962, 1, 0, 0.447319,0.0207438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546652,-0.0665849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.719092,0.00244105) , 
0, 0.748964, 1, 0, 0.683753,-0.0276015) , 
2, 0.744165, 1, 0, 0.50957,0.0080148)    );
  // itree = 1758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0642621,-0.00686726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0728729,-0.0520229) , 
3, -1.97311, 1, 0, 0.0697572,-0.0685189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419164,-0.00886539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674917,0.00671923) , 
0, 1.02725, 1, 0, 0.484612,-0.00912096) , 
2, -1.71432, 1, 0, 0.451273,-0.0138943)    );
  // itree = 1759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247396,0.0417804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441769,0.00601595) , 
2, -2.13959, 1, 0, 0.43371,0.0142911) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320502,-0.0394104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794483,-0.00460177) , 
3, 0.855573, 1, 0, 0.662154,-0.0332258) , 
2, 0.604931, 1, 0, 0.500065,0.000489108)    );
  // itree = 1760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0607191,-0.0612894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729526,-0.00798146) , 
3, -0.566199, 1, 0, 0.552977,-0.0541256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449948,-0.0294936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492424,0.00404096) , 
1, -0.847827, 1, 0, 0.486921,-0.000153745) , 
1, -1.37246, 1, 0, 0.495167,-0.00689057)    );
  // itree = 1761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474975,-0.0177127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452494,-0.000125422) , 
1, 0.356987, 1, 0, 0.46717,-0.0231766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.850707,0.0734723) , 
1, 1.89, 1, 0, 0.478914,-0.0167821)    );
  // itree = 1762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31961,-0.00602301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278763,-0.0277048) , 
1, 1.32842, 1, 0, 0.316152,-0.0147731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480815,-0.0528749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761736,0.0236552) , 
1, -1.66506, 1, 0, 0.737558,0.0348824) , 
2, 0.171595, 1, 0, 0.481567,0.0047181)    );
  // itree = 1763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534509,0.00253171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45278,-0.0320285) , 
1, -1.80985, 1, 0, 0.475793,-0.0416972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395532,0.00411609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725876,-0.0179123) , 
2, 0.890024, 1, 0, 0.464404,-0.000941958) , 
1, -1.03486, 1, 0, 0.466593,-0.00877552)    );
  // itree = 1764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218192,0.0094174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279782,0.0831367) , 
1, 0.498227, 1, 0, 0.240921,0.0672441) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242007,-0.0174239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.638709,0.00194089) , 
2, -0.544954, 1, 0, 0.513095,-0.00794913) , 
0, -2.37192, 1, 0, 0.489072,-0.00131248)    );
  // itree = 1765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301628,-0.00674152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43196,-0.045874) , 
2, -0.0169813, 1, 0, 0.33947,-0.0368514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64672,0.0128894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.652238,-0.0157731) , 
0, 1.8979, 1, 0, 0.648549,0.00371786) , 
0, 0.387961, 1, 0, 0.467156,-0.0200915)    );
  // itree = 1766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397356,0.0275468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792098,0.0525902) , 
3, 0.272838, 1, 0, 0.572399,0.0830086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437789,0.0121288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645407,-0.0112928) , 
0, 0.998242, 1, 0, 0.494438,0.00961224) , 
1, -1.71006, 1, 0, 0.500663,0.0154726)    );
  // itree = 1767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295261,0.000210497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636335,-0.033277) , 
3, 0.558173, 1, 0, 0.337069,-0.00897468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.926418,0.0590079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823431,0.00251863) , 
1, -0.977314, 1, 0, 0.845207,0.0316247) , 
3, 0.908704, 1, 0, 0.478047,0.00228924)    );
  // itree = 1768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297488,0.00516484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614193,0.040102) , 
0, -1.01798, 1, 0, 0.401657,0.0290896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469399,-0.0126075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880319,0.0139228) , 
3, 1.07839, 1, 0, 0.658677,-0.00345762) , 
0, -0.218015, 1, 0, 0.541932,0.0113262)    );
  // itree = 1769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0781042,-0.0367177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16958,0.02075) , 
2, -1.86644, 1, 0, 0.146936,0.00610371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377455,-0.0303226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651994,-0.00616439) , 
2, -0.448274, 1, 0, 0.598828,-0.0248673) , 
3, -0.749223, 1, 0, 0.478348,-0.01661)    );
  // itree = 1770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226479,0.0140215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520331,-0.0201063) , 
2, -0.631806, 1, 0, 0.407764,-0.0163264) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673443,0.0415202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.871671,0.00933793) , 
3, 1.40694, 1, 0, 0.790033,0.0417671) , 
2, 0.705933, 1, 0, 0.505626,-0.00145434)    );
  // itree = 1771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306567,0.00221713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308384,0.0301218) , 
1, 0.5625, 1, 0, 0.307096,0.0203538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.640395,-0.0598815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.758625,-0.00346799) , 
1, -0.409305, 1, 0, 0.717324,-0.0461201) , 
3, 0.392653, 1, 0, 0.477356,-0.00723542)    );
  // itree = 1772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.807792,0.0554316) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507009,-0.0180949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491182,0.00207506) , 
1, -0.851528, 1, 0, 0.494281,-0.00458642) , 
1, -1.84922, 1, 0, 0.507725,0.000210059)    );
  // itree = 1773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245741,0.0232537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814964,0.0577115) , 
3, -0.68669, 1, 0, 0.395934,0.0586873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322877,-0.028752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681858,0.00121335) , 
2, -0.202985, 1, 0, 0.603236,-0.00940124) , 
0, -0.964069, 1, 0, 0.541633,0.0108324)    );
  // itree = 1774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269355,0.010244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308125,-0.0270067) , 
0, -0.394048, 1, 0, 0.278533,-0.00167927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735322,0.0290577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692051,-0.0168914) , 
1, 1.41092, 1, 0, 0.731811,0.0485712) , 
2, -0.224534, 1, 0, 0.52399,0.0255321)    );
  // itree = 1775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293947,0.00796598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492211,-0.0149485) , 
0, -1.07798, 1, 0, 0.409706,-0.0103479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.615693,0.0289358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.901191,0.00905033) , 
3, 1.56048, 1, 0, 0.750631,0.0477106) , 
0, 0.842728, 1, 0, 0.510901,0.0068854)    );
  // itree = 1776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540368,0.0145665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796793,0.0380573) , 
0, 1.00599, 1, 0, 0.628918,0.0421141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515664,-0.0149924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496066,0.00235666) , 
1, -0.285588, 1, 0, 0.502371,-0.00573423) , 
1, -1.31868, 1, 0, 0.515818,-0.000650038)    );
  // itree = 1777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347952,-0.0263241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467015,0.000811687) , 
1, -1.6376, 1, 0, 0.456653,-0.00446179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521701,0.056755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.828823,0.0104197) , 
3, 1.12022, 1, 0, 0.765363,0.0422567) , 
2, 0.983945, 1, 0, 0.5133,0.00411082)    );
  // itree = 1778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465398,0.0176119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71737,-0.00906254) , 
3, 0.483368, 1, 0, 0.570194,0.0144809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203113,0.0129729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502721,-0.0286931) , 
3, -0.675569, 1, 0, 0.430605,-0.0491553) , 
1, -0.164574, 1, 0, 0.494774,-0.0199017)    );
  // itree = 1779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.078424,-0.0404748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195152,-0.00319513) , 
2, -0.973979, 1, 0, 0.118189,-0.0487197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569731,0.0432214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709121,0.00186184) , 
3, -0.139828, 1, 0, 0.687266,0.0213496) , 
3, -0.639447, 1, 0, 0.527567,0.00168615)    );
  // itree = 1780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497839,-0.0718852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250802,-0.0130217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.775986,0.0137211) , 
3, 0.262941, 1, 0, 0.478576,-0.00339764) , 
1, -1.99305, 1, 0, 0.479192,-0.00906511)    );
  // itree = 1781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259606,-0.0203701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.804178,0.00721669) , 
3, 0.392653, 1, 0, 0.479956,-0.0184313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490773,0.0773735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620515,-0.0152375) , 
2, -0.295052, 1, 0, 0.56188,0.0733244) , 
1, 1.49432, 1, 0, 0.485227,-0.0125273)    );
  // itree = 1782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0625558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521728,0.00462915) , 
2, -2.07983, 1, 0, 0.506163,0.00585843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221199,-0.0421995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441739,-0.0100692) , 
0, -2.31926, 1, 0, 0.402868,-0.0345566) , 
1, 1.06974, 1, 0, 0.490834,-0.000139316)    );
  // itree = 1783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313315,-0.00342559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675789,0.0377802) , 
0, -0.449012, 1, 0, 0.370815,0.00393633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233885,-0.0303105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808761,-0.00733414) , 
3, 0.70812, 1, 0, 0.605735,-0.0318099) , 
0, -0.00413718, 1, 0, 0.481675,-0.0129325)    );
  // itree = 1784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225838,-0.0408505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317694,-0.00203571) , 
1, -1.44575, 1, 0, 0.309246,-0.0124201) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.660475,0.0161829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717592,-0.0177671) , 
2, 1.54049, 1, 0, 0.664944,0.0296271) , 
0, -0.438834, 1, 0, 0.51132,0.0114672)    );
  // itree = 1785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346666,-0.00302349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514508,0.0173158) , 
0, 0.118385, 1, 0, 0.394046,0.0071058) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610623,-0.0672208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.876473,6.60231e-05) , 
3, 1.46714, 1, 0, 0.806268,-0.0375618) , 
3, 1.14552, 1, 0, 0.486664,-0.00293014)    );
  // itree = 1786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0937674,0.000424893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397007,0.042756) , 
3, -1.09389, 1, 0, 0.236988,0.0383329) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538097,-0.0124651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811533,0.0114103) , 
3, 0.800104, 1, 0, 0.699686,-0.000660087) , 
3, -0.103721, 1, 0, 0.511239,0.0152209)    );
  // itree = 1787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205251,0.0536455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307596,-0.0174797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649228,-0.00204659) , 
0, -0.281401, 1, 0, 0.496567,-0.0183532) , 
2, -1.72903, 1, 0, 0.485976,-0.0150719)    );
  // itree = 1788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31492,0.00548667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556521,-0.0253488) , 
3, 0.127797, 1, 0, 0.392893,-0.0124863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.952537,0.0570617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796314,0.00169158) , 
2, 0.89054, 1, 0, 0.858586,0.0367931) , 
3, 0.810124, 1, 0, 0.528357,0.00184841)    );
  // itree = 1789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367725,0.0129328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736814,-0.0120152) , 
3, 0.569166, 1, 0, 0.509171,0.00679913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581148,0.0533893) , 
1, 1.72925, 1, 0, 0.512391,0.0118136)    );
  // itree = 1790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259352,0.00408412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.899003,0.0468569) , 
3, 0.00525746, 1, 0, 0.445609,0.0316264) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299783,-0.0578406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718355,0.00480073) , 
2, 0.179323, 1, 0, 0.666155,-0.0066766) , 
0, 0.861216, 1, 0, 0.512218,0.0200581)    );
  // itree = 1791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402002,0.00447279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.816057,-0.0242342) , 
3, 0.842521, 1, 0, 0.502512,-0.00134375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.814677,0.0148527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.886206,0.0443998) , 
0, 2.37753, 1, 0, 0.857007,0.0720053) , 
2, 1.4278, 1, 0, 0.531034,0.00455769)    );
  // itree = 1792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917315,-0.044159) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253946,0.0205337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575488,-0.0150202) , 
2, -0.903257, 1, 0, 0.521734,-0.0187323) , 
2, -2.07855, 1, 0, 0.506576,-0.0218167)    );
  // itree = 1793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220409,-0.0224243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648966,0.0187558) , 
0, -1.80149, 1, 0, 0.578154,0.0243996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397972,-0.0175535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.480927,0.00541711) , 
1, 0.36979, 1, 0, 0.450826,-0.00554592) , 
1, -0.24206, 1, 0, 0.506367,0.00751629)    );
  // itree = 1794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248701,-0.0247302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571552,0.00104605) , 
0, -1.4678, 1, 0, 0.503142,-0.00842944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379594,0.0266456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663541,-0.0121465) , 
3, 1.0067, 1, 0, 0.454198,0.0354892) , 
1, 0.823393, 1, 0, 0.492631,0.00100227)    );
  // itree = 1795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169363,-0.012213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0503581,-0.0607244) , 
1, 0.301203, 1, 0, 0.115007,-0.0791049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485683,-0.00896827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.754732,-0.0570453) , 
2, 1.81911, 1, 0, 0.494401,-0.0200341) , 
0, -2.56956, 1, 0, 0.462294,-0.025033)    );
  // itree = 1796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327141,0.0050042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.883843,0.0681834) , 
3, 0.496338, 1, 0, 0.368973,0.0205981) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500187,-0.0285877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671566,0.00150034) , 
0, 0.144559, 1, 0, 0.626879,-0.0122079) , 
2, -0.035577, 1, 0, 0.507991,0.00291473)    );
  // itree = 1797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216557,-0.00743695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577545,0.0250951) , 
2, -0.382338, 1, 0, 0.360438,0.0133489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.759979,-0.0575334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789778,0.00469844) , 
2, 0.661169, 1, 0, 0.779991,-0.0222454) , 
3, 0.650374, 1, 0, 0.497541,0.00171727)    );
  // itree = 1798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295055,-0.00401296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266573,-0.0297411) , 
1, 0.520617, 1, 0, 0.28601,-0.0258047) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313243,0.0280767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.691892,-0.00408145) , 
3, -0.10173, 1, 0, 0.632079,0.00181743) , 
2, -0.306322, 1, 0, 0.489868,-0.00953338)    );
  // itree = 1799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113203,-0.0427039) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407505,0.0816442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535858,-0.000843062) , 
0, -2.5451, 1, 0, 0.531042,0.00328764) , 
0, -3.03185, 1, 0, 0.509626,-0.00226235)    );
  // itree = 1800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356833,-0.0327858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.866124,0.0320132) , 
0, 1.37603, 1, 0, 0.466573,-0.0341008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636047,0.0510985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463745,0.00252967) , 
1, -0.530104, 1, 0, 0.474249,0.0106084) , 
1, -0.759733, 1, 0, 0.471935,-0.00286864)    );
  // itree = 1801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247104,0.0424294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482087,-0.00721888) , 
2, -2.12531, 1, 0, 0.474057,-0.0104983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254723,-0.0593142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885161,0.00189747) , 
3, 1.93604, 1, 0, 0.650854,-0.0741203) , 
0, 2.30263, 1, 0, 0.490412,-0.0163836)    );
  // itree = 1802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295848,-0.0165522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232489,0.0306505) , 
1, -0.863434, 1, 0, 0.24199,0.0319646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.620318,0.0157962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545991,-0.0138446) , 
1, -1.03061, 1, 0, 0.56022,-0.0167336) , 
2, -0.767121, 1, 0, 0.483064,-0.0049265)    );
  // itree = 1803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285339,-0.00571415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3105,-0.0329991) , 
0, -1.1379, 1, 0, 0.291827,-0.025387) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.639621,0.053525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664071,0.0128814) , 
2, -0.43334, 1, 0, 0.661102,0.037397) , 
0, -0.691462, 1, 0, 0.513164,0.0122448)    );
  // itree = 1804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480343,0.000250415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361581,-0.0238554) , 
1, 1.09168, 1, 0, 0.4651,-0.00584813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594393,0.0502836) , 
1, 1.89479, 1, 0, 0.470062,-0.00192771)    );
  // itree = 1805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405595,0.0194503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.797993,0.00282472) , 
3, 0.487045, 1, 0, 0.571061,0.0256878) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247304,-0.0291525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702512,0.00624571) , 
3, 0.209828, 1, 0, 0.478864,-0.0264502) , 
1, 1.08213, 1, 0, 0.557542,0.0180427)    );
  // itree = 1806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396985,-0.000156102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68893,0.023769) , 
0, 0.368993, 1, 0, 0.483562,0.0149276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403102,-0.0417966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838277,-0.00147293) , 
3, 1.12022, 1, 0, 0.74729,-0.0205154) , 
2, 0.999858, 1, 0, 0.530258,0.00865204)    );
  // itree = 1807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199928,0.0785264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118203,0.0226239) , 
2, -1.67287, 1, 0, 0.16821,0.0764065) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318805,-0.0200566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544715,0.00138203) , 
0, -2.01358, 1, 0, 0.524083,-0.00192319) , 
3, -1.75202, 1, 0, 0.501424,0.00306411)    );
  // itree = 1808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225016,-0.00401071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462154,-0.0562331) , 
2, -0.638291, 1, 0, 0.274273,-0.0253325) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389353,-0.00927188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.684883,0.0133481) , 
2, -0.533073, 1, 0, 0.627487,0.0173923) , 
0, -1.5378, 1, 0, 0.548038,0.00778213)    );
  // itree = 1809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281677,0.0294741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572506,-0.00362769) , 
2, -0.73641, 1, 0, 0.50649,0.007284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654209,0.0181649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390472,-0.0246187) , 
1, 0.974172, 1, 0, 0.436274,-0.0371578) , 
1, 0.820442, 1, 0, 0.491308,-0.00232521)    );
  // itree = 1810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274937,0.0133909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687885,-0.0057455) , 
3, -0.213477, 1, 0, 0.527456,0.00281494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25358,-0.0299971) , 
1, 1.9512, 1, 0, 0.512821,-0.000521298)    );
  // itree = 1811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0608775,-0.0523955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714205,0.0219607) , 
0, -1.924, 1, 0, 0.630191,0.0191399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400264,-0.0406052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474052,-0.00963454) , 
1, -0.478641, 1, 0, 0.468455,-0.025847) , 
1, -0.673494, 1, 0, 0.512082,-0.0137121)    );
  // itree = 1812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165244,-0.0122285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545715,-0.0397381) , 
3, -0.367863, 1, 0, 0.247221,-0.0372265) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61197,0.0158859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627192,-0.0112119) , 
2, 0.347838, 1, 0, 0.620518,0.000608648) , 
2, -0.504532, 1, 0, 0.495144,-0.0120984)    );
  // itree = 1813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0552641,-0.00655074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.740609,0.061711) , 
3, -1.92341, 1, 0, 0.353643,0.0772575) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315734,-0.00894302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685436,0.0105631) , 
2, -0.293448, 1, 0, 0.549546,0.00678756) , 
0, -2.3109, 1, 0, 0.53023,0.0137361)    );
  // itree = 1814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364095,0.0284365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202119,0.0552112) , 
1, 0.032123, 1, 0, 0.275714,0.0765741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0706973,-0.0447599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543079,-0.00193837) , 
2, -1.3276, 1, 0, 0.493735,-0.0104822) , 
0, -2.98821, 1, 0, 0.481901,-0.00575679)    );
  // itree = 1815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259852,0.0137849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591069,-0.00650235) , 
2, -0.724736, 1, 0, 0.517743,-0.00469345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155376,0.000108796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767526,0.036015) , 
2, -0.733164, 1, 0, 0.535217,0.0477908) , 
1, 0.65094, 1, 0, 0.521723,0.007261)    );
  // itree = 1816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365213,-0.00100758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.61433,0.020398) , 
0, 0.360435, 1, 0, 0.435921,0.0115983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623161,-0.0548639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.741684,-0.00515521) , 
1, -1.17935, 1, 0, 0.723388,-0.0290948) , 
2, 0.650515, 1, 0, 0.511962,0.000834223)    );
  // itree = 1817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349628,0.0176783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551449,-0.00505326) , 
0, -0.611589, 1, 0, 0.481298,0.00297561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432827,-0.0237611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234831,-0.0413771) , 
1, 2.04563, 1, 0, 0.393999,-0.0558829) , 
1, 0.888158, 1, 0, 0.464678,-0.00823007)    );
  // itree = 1818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0793879,-0.018244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377944,0.0375818) , 
3, -1.06543, 1, 0, 0.201887,0.017511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292223,-0.0312701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703431,-0.00122341) , 
3, -0.0620004, 1, 0, 0.646441,-0.0137846) , 
3, -0.304384, 1, 0, 0.491994,-0.00291189)    );
  // itree = 1819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541318,0.0266873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326321,-0.0198005) , 
1, -1.41364, 1, 0, 0.34447,-0.03168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.726961,0.0349003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657235,-0.000314586) , 
0, 0.755143, 1, 0, 0.675599,0.018192) , 
0, 0.0848771, 1, 0, 0.491498,-0.00953574)    );
  // itree = 1820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230333,0.031703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184227,-0.0106039) , 
0, -3.15264, 1, 0, 0.18867,-0.0104371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363781,-0.0106987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744249,0.0106278) , 
3, -0.0717769, 1, 0, 0.702015,0.0136767) , 
3, -0.304384, 1, 0, 0.517785,0.00502267)    );
  // itree = 1821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464526,0.0312142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258,-0.0185283) , 
1, 0.586371, 1, 0, 0.39386,0.0278321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614587,-0.0228322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553745,-0.00037874) , 
1, -0.39136, 1, 0, 0.578658,-0.0176282) , 
0, -0.84483, 1, 0, 0.524115,-0.00421065)    );
  // itree = 1822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363956,0.00359335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461614,0.0428854) , 
1, 0.568694, 1, 0, 0.394103,0.0287579) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473925,-0.0286856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.749333,0.0199612) , 
2, 0.596523, 1, 0, 0.624108,-0.0105159) , 
2, -0.002981, 1, 0, 0.514334,0.00822828)    );
  // itree = 1823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453038,-0.00464221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778396,0.0356794) , 
2, 1.11322, 1, 0, 0.470973,-0.00521586) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575048,-0.0576078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.848951,-0.01426) , 
3, 1.98722, 1, 0, 0.713089,-0.0778399) , 
2, 1.43963, 1, 0, 0.485315,-0.00951798)    );
  // itree = 1824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573623,0.0573368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805564,0.0252984) , 
0, -0.503923, 1, 0, 0.734305,0.0630436) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399037,0.00226431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69312,-0.020553) , 
2, 0.161708, 1, 0, 0.517093,-0.0135359) , 
1, -1.31849, 1, 0, 0.541356,-0.00498179)    );
  // itree = 1825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382248,-0.0647837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603785,0.0166478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456149,-0.00842901) , 
1, -0.799034, 1, 0, 0.488273,-0.00693499) , 
1, -2.1332, 1, 0, 0.484938,-0.0125215)    );
  // itree = 1826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433958,-0.011359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657312,0.0161646) , 
2, 1.48412, 1, 0, 0.443684,-0.0184641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.915065,0.0138959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.955523,0.0388912) , 
3, 2.57114, 1, 0, 0.931195,0.0358119) , 
3, 2.10834, 1, 0, 0.478972,-0.0145354)    );
  // itree = 1827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384117,0.00803721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521318,-0.0155732) , 
0, -0.0293343, 1, 0, 0.440226,-0.00461504) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.809964,0.0350212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715399,0.0089544) , 
1, -0.158286, 1, 0, 0.760175,0.0474981) , 
2, 1.04815, 1, 0, 0.486311,0.00289123)    );
  // itree = 1828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36383,0.000693126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288562,-0.0259749) , 
0, 0.0824785, 1, 0, 0.345004,-0.0145012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.795758,0.0247108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.885399,-0.0153001) , 
3, 1.61034, 1, 0, 0.830781,0.023535) , 
3, 0.760312, 1, 0, 0.51327,-0.00132599)    );
  // itree = 1829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189595,-0.0158296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405886,0.0122878) , 
0, -2.09192, 1, 0, 0.366417,0.0136585) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49012,-0.070856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.815059,-0.00636867) , 
3, 0.868529, 1, 0, 0.768379,-0.0333643) , 
3, 0.693774, 1, 0, 0.502832,-0.00229969)    );
  // itree = 1830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458118,-0.0124329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430019,0.00893909) , 
1, 0.175368, 1, 0, 0.446686,-0.00712922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.779183,0.00135658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764613,0.0289614) , 
1, -0.294962, 1, 0, 0.770529,0.0411482) , 
0, 1.63755, 1, 0, 0.506933,0.00185213)    );
  // itree = 1831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102901,-0.00967371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392794,0.0389504) , 
3, -1.18139, 1, 0, 0.204368,0.015902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278281,-0.032297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694576,-0.00614457) , 
3, -0.139828, 1, 0, 0.604737,-0.0267872) , 
3, -0.639447, 1, 0, 0.495363,-0.0151253)    );
  // itree = 1832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34634,-0.0156724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681336,0.00435446) , 
0, -0.218015, 1, 0, 0.530177,-0.00890694) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350634,0.00639537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.750812,0.0265729) , 
2, -0.0150594, 1, 0, 0.548115,0.0373122) , 
1, 0.419001, 1, 0, 0.53597,0.00601909)    );
  // itree = 1833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235333,0.100908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0362002,0.00632186) , 
3, -2.42729, 1, 0, 0.139447,0.0778182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177241,-0.0238949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707498,-0.000665642) , 
3, -0.243249, 1, 0, 0.499622,-0.0177634) , 
3, -2.1111, 1, 0, 0.478189,-0.0120755)    );
  // itree = 1834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17573,0.00381411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450566,-0.0272327) , 
3, -0.873297, 1, 0, 0.327325,-0.0303677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.670395,0.0145906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709633,-0.0223374) , 
0, 2.02966, 1, 0, 0.678937,0.0114578) , 
0, -0.307758, 1, 0, 0.508206,-0.00885118)    );
  // itree = 1835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557448,0.0258789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424616,-0.0240185) , 
1, -1.6746, 1, 0, 0.467348,-0.0137068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.449646,0.0212226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678813,-0.00602481) , 
2, 0.650515, 1, 0, 0.517734,0.0240689) , 
1, -1.03061, 1, 0, 0.508436,0.0170979)    );
  // itree = 1836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423213,0.00187147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.621186,-0.0197833) , 
0, 0.575679, 1, 0, 0.494979,-0.0115464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744616,0.0254308) , 
0, 2.89272, 1, 0, 0.507495,-0.00793774)    );
  // itree = 1837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362919,-0.00692763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282672,-0.0356356) , 
1, 1.36625, 1, 0, 0.353634,-0.0232663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63704,0.0365304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680202,0.0019705) , 
2, 0.0920873, 1, 0, 0.670671,0.0199844) , 
0, -0.218015, 1, 0, 0.512371,-0.0016112)    );
  // itree = 1838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502156,0.0731244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378725,0.00928231) , 
1, -1.59062, 1, 0, 0.386065,0.0248177) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267431,-0.0304043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.649892,0.0010217) , 
2, -0.189996, 1, 0, 0.607631,-0.00667365) , 
0, -0.156017, 1, 0, 0.50481,0.00794031)    );
  // itree = 1839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27721,-0.0125636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.783443,0.0269919) , 
2, -0.543709, 1, 0, 0.608325,0.0235997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205341,0.0322304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471874,-0.0100385) , 
2, -1.63878, 1, 0, 0.452694,-0.0134679) , 
1, -0.700332, 1, 0, 0.500865,-0.00199474)    );
  // itree = 1840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421498,-0.0130481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.363079,0.014775) , 
1, 1.05411, 1, 0, 0.411768,-0.01904) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.698548,0.000177923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745286,0.024823) , 
1, -1.31849, 1, 0, 0.737207,0.0424494) , 
2, 0.560086, 1, 0, 0.513244,0.000133129)    );
  // itree = 1841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.499166,-0.0217483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421405,-0.00027985) , 
1, -0.610343, 1, 0, 0.442705,-0.0112135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.805314,0.0534301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789404,0.00902643) , 
0, 1.24656, 1, 0, 0.792734,0.0343178) , 
2, 1.08804, 1, 0, 0.495987,-0.00428264)    );
  // itree = 1842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115441,-0.0174264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320977,0.0357264) , 
2, -1.93356, 1, 0, 0.276262,0.0357665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0878672,-0.0269494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.663026,0.0013201) , 
3, -0.406168, 1, 0, 0.530394,-0.00904677) , 
0, -1.60723, 1, 0, 0.481656,-0.000452379)    );
  // itree = 1843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414652,-0.0254561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393043,0.0137698) , 
1, -1.08103, 1, 0, 0.396681,0.0107942) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.750987,0.00495836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646457,-0.0223182) , 
1, -0.687931, 1, 0, 0.684274,-0.0279391) , 
2, 0.338939, 1, 0, 0.512755,-0.0048388)    );
  // itree = 1844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543242,0.00424001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.717215,0.0824787) , 
1, 1.13494, 1, 0, 0.548336,0.0122378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311809,-0.0280753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415281,-0.0047579) , 
1, 1.60223, 1, 0, 0.36437,-0.0478035) , 
1, 1.34775, 1, 0, 0.52838,0.00572486)    );
  // itree = 1845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0406583,-0.0411547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537218,-0.00450859) , 
3, -1.39911, 1, 0, 0.471747,-0.0147414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570756,0.0360455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590714,-0.00432664) , 
1, 1.44086, 1, 0, 0.577199,0.0516448) , 
1, 0.820442, 1, 0, 0.49351,-0.00104047)    );
  // itree = 1846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5147,0.0175079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760592,-0.0428011) , 
2, 1.55303, 1, 0, 0.533054,0.0267006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253036,-0.0236138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650482,0.00675379) , 
2, -0.154462, 1, 0, 0.447711,-0.0175783) , 
1, 0.392765, 1, 0, 0.501926,0.01055)    );
  // itree = 1847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341625,0.0125694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167491,-0.0450568) , 
1, 0.0100439, 1, 0, 0.238864,-0.0336376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54061,0.0109048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868797,-0.00867899) , 
3, 1.71069, 1, 0, 0.588753,0.017819) , 
0, -1.54251, 1, 0, 0.500684,0.00486708)    );
  // itree = 1848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0330797,-0.040817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272082,0.0304316) , 
3, -2.20962, 1, 0, 0.231319,0.0313409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496882,0.00495576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606962,-0.0119355) , 
0, 0.469446, 1, 0, 0.547816,-0.00762486) , 
2, -1.09958, 1, 0, 0.494006,-0.000999941)    );
  // itree = 1849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12806,-0.0461412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557432,-0.0116255) , 
2, -1.29539, 1, 0, 0.508186,-0.0322774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415578,0.0222655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651499,-0.0266725) , 
2, 0.459016, 1, 0, 0.491201,0.0037505) , 
1, 0.345387, 1, 0, 0.502529,-0.0202785)    );
  // itree = 1850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345066,0.0106049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640242,-0.0112176) , 
2, -0.002981, 1, 0, 0.490097,-0.00299318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.761699,0.0763849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296018,-0.0241513) , 
1, 1.71538, 1, 0, 0.506648,0.0597277) , 
1, 1.32833, 1, 0, 0.49177,0.00334839)    );
  // itree = 1851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43391,0.0223021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320631,-0.0150014) , 
1, -0.384038, 1, 0, 0.361025,-0.00151849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.720538,-0.0122178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73034,0.0276529) , 
1, -1.22319, 1, 0, 0.728758,0.0419373) , 
2, 0.171595, 1, 0, 0.524993,0.017858)    );
  // itree = 1852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236054,-0.037943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192325,-0.00787939) , 
1, -1.43743, 1, 0, 0.197428,-0.0249256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704874,0.00642001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.751687,0.0347559) , 
1, 1.08213, 1, 0, 0.711421,0.020337) , 
3, -0.202496, 1, 0, 0.488925,0.000743777)    );
  // itree = 1853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189014,-0.0132207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75538,0.0163484) , 
3, -0.178006, 1, 0, 0.442751,0.000474761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627838,-0.044004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675508,-0.010465) , 
0, 1.35651, 1, 0, 0.669527,-0.0320063) , 
0, 1.05872, 1, 0, 0.500245,-0.0077601)    );
  // itree = 1854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33127,-0.022607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304392,-0.00451709) , 
1, -0.130192, 1, 0, 0.317485,-0.0263752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.716535,0.00894425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596928,-0.0319829) , 
1, 0.641961, 1, 0, 0.690882,-0.000344576) , 
2, 0.110847, 1, 0, 0.47456,-0.015425)    );
  // itree = 1855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11369,-0.0367775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552916,-0.0249414) , 
2, -0.363541, 1, 0, 0.404197,-0.0698279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310701,-0.0122519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699231,0.0157098) , 
0, -0.218015, 1, 0, 0.517152,0.00558244) , 
1, -1.37597, 1, 0, 0.504119,-0.00311846)    );
  // itree = 1856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386161,-0.0351433) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.71692,0.021134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.470909,-0.0027358) , 
1, -0.648426, 1, 0, 0.53173,0.00408479) , 
1, -1.87422, 1, 0, 0.524945,0.000161471)    );
  // itree = 1857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18142,-0.00427032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685678,0.013528) , 
3, -0.569575, 1, 0, 0.549948,0.0175268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266552,0.0205502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.92458,0.0673661) , 
3, 0.186306, 1, 0, 0.606817,0.0814773) , 
1, 1.45051, 1, 0, 0.55333,0.0213299)    );
  // itree = 1858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483861,-0.000750859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71048,-0.0248462) , 
2, 1.1141, 1, 0, 0.516272,-0.00793359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620591,0.0630516) , 
1, 1.89, 1, 0, 0.520255,-0.00312025)    );
  // itree = 1859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109492,5.10113e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120517,-0.0466186) , 
3, -1.42437, 1, 0, 0.116604,-0.0643206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.548769,-0.00287891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581178,0.0186861) , 
1, 0.107402, 1, 0, 0.563128,0.0124186) , 
2, -1.0546, 1, 0, 0.465827,-0.00430345)    );
  // itree = 1860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252048,-0.0064414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200835,-0.0304581) , 
0, -0.722523, 1, 0, 0.235137,-0.0291758) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.700798,0.0214023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793539,-0.00534522) , 
3, 0.817283, 1, 0, 0.761583,0.00814112) , 
3, 0.223327, 1, 0, 0.494858,-0.0107656)    );
  // itree = 1861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487324,0.0385631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324763,-0.00939767) , 
1, -0.414745, 1, 0, 0.369524,0.0080815) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365479,-0.0457665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681025,-0.00551901) , 
0, -0.368908, 1, 0, 0.633329,-0.0252878) , 
2, 0.120313, 1, 0, 0.504412,-0.00898086)    );
  // itree = 1862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171915,0.00422963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.529837,-0.0184575) , 
3, -0.848388, 1, 0, 0.423008,-0.0257634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.694374,0.011566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.500694,-0.0351694) , 
1, 1.09943, 1, 0, 0.673179,0.00922595) , 
0, 1.24421, 1, 0, 0.483622,-0.0172858)    );
  // itree = 1863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309433,0.044213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39048,0.00220152) , 
0, -1.24176, 1, 0, 0.345881,0.0376587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531314,-0.0280147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.789487,0.0219988) , 
0, 0.669405, 1, 0, 0.664831,-0.00515494) , 
2, -0.271157, 1, 0, 0.535843,0.0121595)    );
  // itree = 1864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334639,-0.018115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51648,0.0366418) , 
1, 1.12094, 1, 0, 0.350926,-0.0260818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.74517,0.0207752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683887,-0.0380685) , 
0, 2.82387, 1, 0, 0.737456,0.0217047) , 
2, 0.425012, 1, 0, 0.489026,-0.0090086)    );
  // itree = 1865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461251,0.00801301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.670687,-0.0127336) , 
0, 1.37641, 1, 0, 0.506488,0.00551247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522815,-0.00914766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502655,-0.0507351) , 
2, 0.430408, 1, 0, 0.5118,-0.071401) , 
1, 1.53348, 1, 0, 0.506908,-0.000575849)    );
  // itree = 1866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115416,-0.0414391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130246,-0.0263338) , 
1, -0.0607416, 1, 0, 0.124259,-0.0685269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502797,-0.00252428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.772621,0.014582) , 
0, 2.7661, 1, 0, 0.520005,-0.00173456) , 
0, -2.97825, 1, 0, 0.494982,-0.00595783)    );
  // itree = 1867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157599,-0.00499257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.732636,0.0255462) , 
3, -0.49304, 1, 0, 0.371332,0.0154118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429005,-0.0428267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613311,-0.00641828) , 
0, 0.328735, 1, 0, 0.584783,-0.0266319) , 
0, -0.00413718, 1, 0, 0.471785,-0.00437463)    );
  // itree = 1868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334517,0.0576813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184757,0.0107731) , 
1, -0.767649, 1, 0, 0.22455,0.0406523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298419,-0.0292416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632526,0.00214773) , 
2, -0.775002, 1, 0, 0.600256,-0.00345362) , 
3, -0.857342, 1, 0, 0.520878,0.00586499)    );
  // itree = 1869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179576,0.0130456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533008,-0.00999026) , 
3, -0.844038, 1, 0, 0.442591,-0.0105951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.780927,0.016536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851289,0.0375876) , 
2, 1.97123, 1, 0, 0.79582,0.0443834) , 
2, 1.08804, 1, 0, 0.488463,-0.00345542)    );
  // itree = 1870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479342,0.0217905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647553,-0.0171988) , 
2, 0.731099, 1, 0, 0.523273,0.0206975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.099909,-0.0514581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48432,-0.00887633) , 
0, -2.27176, 1, 0, 0.433747,-0.0305228) , 
1, -0.0229864, 1, 0, 0.480663,-0.00368116)    );
  // itree = 1871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714787,-0.0175863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319481,0.0289742) , 
3, -1.37899, 1, 0, 0.2253,0.0226487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.661956,-0.0137262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.78496,0.0148565) , 
0, 2.38494, 1, 0, 0.680067,-0.0180606) , 
3, -0.202496, 1, 0, 0.506527,-0.00252586)    );
  // itree = 1872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144675,-0.0378772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571861,0.00663381) , 
2, -0.521059, 1, 0, 0.235775,-0.0503943) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55142,-0.00139845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.667281,-0.0329729) , 
0, 3.21413, 1, 0, 0.556413,-0.0067031) , 
0, -0.882766, 1, 0, 0.44527,-0.0218478)    );
  // itree = 1873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0326389,-0.0524967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0685216,-0.0159596) , 
1, 0.116181, 1, 0, 0.0537489,-0.056333) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610893,0.0228214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490034,0.00206498) , 
1, -0.266843, 1, 0, 0.538016,0.0204162) , 
2, -1.63878, 1, 0, 0.502636,0.014809)    );
  // itree = 1874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229559,0.0125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234913,-0.0133112) , 
2, -1.11105, 1, 0, 0.232706,-0.00649875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.767675,0.0313034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697369,0.00139227) , 
2, 0.369201, 1, 0, 0.724719,0.0244949) , 
3, -0.123397, 1, 0, 0.520086,0.0116043)    );
  // itree = 1875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266626,-0.00267227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246844,0.0410479) , 
1, 0.0100439, 1, 0, 0.256354,0.0285697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423267,-0.0219846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.642622,-0.00166288) , 
0, -0.561012, 1, 0, 0.591626,-0.0131111) , 
2, -0.724736, 1, 0, 0.504579,-0.00228946)    );
  // itree = 1876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54315,0.0472716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340033,0.00415529) , 
1, -0.259045, 1, 0, 0.411343,0.0344671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595662,-0.00385004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461386,-0.0385328) , 
1, 0.728565, 1, 0, 0.569354,-0.0217792) , 
0, -0.691462, 1, 0, 0.511212,-0.0010827)    );
  // itree = 1877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.784196,0.0513649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.559479,0.0109363) , 
1, -1.93704, 1, 0, 0.624297,0.048344) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404744,0.00115126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.80602,-0.0197225) , 
3, 1.07966, 1, 0, 0.500156,-0.006519) , 
1, -1.36512, 1, 0, 0.514356,-0.000243559)    );
  // itree = 1878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442496,0.00253606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.673996,-0.0196611) , 
0, 1.27278, 1, 0, 0.493028,-0.00469008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.76525,0.0427915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.786863,0.00586265) , 
0, 3.4412, 1, 0, 0.775906,0.0805114) , 
0, 2.79282, 1, 0, 0.510687,0.000628663)    );
  // itree = 1879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0871644,-0.0575757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696919,-0.0330206) , 
3, 0.0210279, 1, 0, 0.335667,-0.112852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370407,-0.00187593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760997,-0.020141) , 
3, 0.760312, 1, 0, 0.496858,-0.0143902) , 
1, -1.71006, 1, 0, 0.484939,-0.0216706)    );
  // itree = 1880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104061,-0.00541493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613754,0.0549061) , 
3, -0.970276, 1, 0, 0.25272,0.0293068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321236,-0.0327522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694979,0.00485824) , 
2, -0.200769, 1, 0, 0.603532,-0.0104297) , 
2, -0.662058, 1, 0, 0.503322,0.000921082)    );
  // itree = 1881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425338,0.00480055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561056,-0.0253824) , 
0, 1.11651, 1, 0, 0.437218,0.00342209) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.649396,0.0530841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.838907,-0.00433607) , 
3, 1.45264, 1, 0, 0.776584,0.0390912) , 
0, 1.63755, 1, 0, 0.490222,0.00899313)    );
  // itree = 1882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538709,-0.0151285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490317,0.00363722) , 
1, -0.589143, 1, 0, 0.510037,-0.00801964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335038,0.0037642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761183,0.0295246) , 
2, 0.0752461, 1, 0, 0.527246,0.0306656) , 
1, 0.65094, 1, 0, 0.514225,0.00139458)    );
  // itree = 1883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455106,-0.0232239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709031,0.0310268) , 
2, 0.693934, 1, 0, 0.514013,-0.0241813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431118,0.0111057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.845239,-0.00963825) , 
3, 1.12947, 1, 0, 0.525153,0.0128265) , 
1, -1.31849, 1, 0, 0.523519,0.00740058)    );
  // itree = 1884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0902828,-0.0354106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152994,0.0147597) , 
1, -0.0109455, 1, 0, 0.112555,-0.0322853) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545595,0.0155378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.793947,0.000746082) , 
3, 0.644567, 1, 0, 0.660062,0.0195491) , 
3, -0.816891, 1, 0, 0.516385,0.00594668)    );
  // itree = 1885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481982,-0.00791533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407549,-0.0287866) , 
1, 1.32658, 1, 0, 0.474311,-0.0208841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.810296,0.0357265) , 
0, 3.19023, 1, 0, 0.489713,-0.0151824)    );
  // itree = 1886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406308,-0.00737162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219595,-0.0368456) , 
1, 1.40492, 1, 0, 0.386833,-0.0222503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864385,0.00952896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.912579,0.0409639) , 
1, 0.665836, 1, 0, 0.876802,0.0328842) , 
3, 1.22438, 1, 0, 0.487869,-0.0108811)    );
  // itree = 1887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308094,0.0367794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256888,-0.0114174) , 
0, -2.85092, 1, 0, 0.263092,-0.00944709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.702445,-0.0311296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.799432,0.0206027) , 
1, -1.23636, 1, 0, 0.783845,0.0271242) , 
3, 0.205401, 1, 0, 0.49999,0.0071897)    );
  // itree = 1888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519598,0.0301162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.826091,-0.00626492) , 
3, 0.736065, 1, 0, 0.617645,0.0327661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0804297,-0.0326753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.458599,-0.00769973) , 
2, -1.47465, 1, 0, 0.412848,-0.0194004) , 
1, -0.580095, 1, 0, 0.476636,-0.00315219)    );
  // itree = 1889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262711,-0.0378063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402398,0.00169968) , 
1, -1.15459, 1, 0, 0.379625,-0.0084532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397097,0.0199443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.807456,-0.000412724) , 
3, 0.70812, 1, 0, 0.660812,0.0161029) , 
0, 0.0848771, 1, 0, 0.514298,0.00330776)    );
  // itree = 1890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192959,-0.015333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396796,0.0479685) , 
0, -2.77556, 1, 0, 0.346115,0.0429106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370227,-0.0186453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.696349,0.00699334) , 
2, 0.0871878, 1, 0, 0.575234,-0.00550689) , 
0, -1.14265, 1, 0, 0.508678,0.00855766)    );
  // itree = 1891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40517,-0.0400025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570884,0.0266434) , 
1, -1.69858, 1, 0, 0.553512,0.0377956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401925,-0.00694256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457902,-0.0351193) , 
1, 1.42276, 1, 0, 0.4142,-0.028477) , 
1, 0.522288, 1, 0, 0.512099,0.018095)    );
  // itree = 1892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0623304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517341,-0.0139242) , 
3, -1.34805, 1, 0, 0.442722,-0.0371219) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517731,0.00858705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418537,-0.0140205) , 
1, 0.827212, 1, 0, 0.489867,0.00221716) , 
1, -1.15254, 1, 0, 0.481678,-0.00461653)    );
  // itree = 1893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272038,0.00357093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0764644) , 
3, -0.18275, 1, 0, 0.365947,0.0218075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487235,-0.0213801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814643,0.00587992) , 
2, 0.534242, 1, 0, 0.650306,-0.0153839) , 
0, -0.455644, 1, 0, 0.532851,-2.18856e-05)    );
  // itree = 1894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378702,-0.0287971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774976,-0.00135644) , 
2, 0.608026, 1, 0, 0.482242,-0.0473493) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249787,-0.0103418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60178,0.00999662) , 
2, -0.40292, 1, 0, 0.463724,0.00474699) , 
1, -0.39136, 1, 0, 0.47076,-0.0150485)    );
  // itree = 1895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419149,0.0565019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169602,-0.000211644) , 
1, -0.234174, 1, 0, 0.261374,0.0425945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195007,-0.046391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.543273,-0.0072251) , 
2, -0.928886, 1, 0, 0.518007,-0.0217434) , 
2, -1.199, 1, 0, 0.482156,-0.0127557)    );
  // itree = 1896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205577,-0.00522254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776075,-0.0383633) , 
1, -0.896744, 1, 0, 0.103338,-0.0441212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.784382,0.0228637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605422,-0.00339272) , 
1, -0.636138, 1, 0, 0.651469,0.00516907) , 
3, -0.711955, 1, 0, 0.486428,-0.00967209)    );
  // itree = 1897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0618398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.560624,0.0150765) , 
3, -2.16872, 1, 0, 0.541462,0.0251066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661715,-0.0476302) , 
0, 2.74337, 1, 0, 0.547006,0.0198107)    );
  // itree = 1898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531666,0.0190432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737987,0.0559712) , 
1, -1.93959, 1, 0, 0.673699,0.086054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475153,-0.00283799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489213,0.0174987) , 
1, 0.804787, 1, 0, 0.478222,0.00227685) , 
1, -1.39097, 1, 0, 0.496452,0.0100899)    );
  // itree = 1899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471698,0.073623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660369,0.00117259) , 
2, -1.14104, 1, 0, 0.639664,0.0183182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354142,-0.0163279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703929,0.00473911) , 
0, 0.717696, 1, 0, 0.474785,-0.0181862) , 
1, -0.696094, 1, 0, 0.518856,-0.00842898)    );
  // itree = 1900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650749,0.0913933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.763413,0.0167131) , 
0, -0.416393, 1, 0, 0.72244,0.0829406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546417,-0.0189952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515414,0.00645254) , 
1, -0.614961, 1, 0, 0.522946,-0.00030034) , 
1, -1.54176, 1, 0, 0.539867,0.00676006)    );
  // itree = 1901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433934,0.00671087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.672579,-0.0107844) , 
2, 0.338939, 1, 0, 0.526332,-0.00139961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352894,0.00308286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.937418,0.0565237) , 
0, -0.243535, 1, 0, 0.6294,0.0591592) , 
1, 1.38211, 1, 0, 0.533713,0.00293724)    );
  // itree = 1902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209088,-0.00651153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0935221,-0.0386342) , 
1, 1.4055, 1, 0, 0.188395,-0.0255454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629483,0.00962817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.850202,0.0445172) , 
1, 1.17696, 1, 0, 0.653007,0.025549) , 
2, -0.799088, 1, 0, 0.534201,0.0124836)    );
  // itree = 1903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234047,-0.0288429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349572,0.0173591) , 
1, -1.12449, 1, 0, 0.333679,0.0157931) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184522,-0.0348032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.704726,-0.014304) , 
3, -0.099481, 1, 0, 0.59323,-0.0381238) , 
2, -0.281514, 1, 0, 0.49974,-0.018703)    );
  // itree = 1904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134071,-0.0137684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730673,0.0137494) , 
3, -0.683307, 1, 0, 0.537075,0.0121031) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399906,-0.0100896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442683,-0.0498699) , 
0, 1.86362, 1, 0, 0.404043,-0.0285084) , 
1, 0.313122, 1, 0, 0.489284,-0.00248644)    );
  // itree = 1905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550127,0.0979136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582286,0.0032243) , 
2, -0.286726, 1, 0, 0.571156,0.0782792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199915,0.0393437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.527897,-0.00405528) , 
2, -1.61118, 1, 0, 0.50081,-0.00181711) , 
1, -1.40021, 1, 0, 0.506766,0.00496458)    );
  // itree = 1906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339395,-0.0438729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.63341,0.0102337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436857,-0.0105064) , 
1, -0.74258, 1, 0, 0.478282,-0.0130177) , 
1, -1.87532, 1, 0, 0.473354,-0.0171274)    );
  // itree = 1907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455325,-0.0117612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147937,-0.0399366) , 
1, 2.05619, 1, 0, 0.43787,-0.0236529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.654142,-0.00392404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875756,0.0344922) , 
2, 1.54775, 1, 0, 0.773807,0.0398648) , 
0, 2.69796, 1, 0, 0.460806,-0.0193163)    );
  // itree = 1908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479119,-0.0188494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755532,0.0260017) , 
2, 1.21219, 1, 0, 0.512756,-0.023479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474503,0.00730346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734459,-0.0295994) , 
2, 1.3046, 1, 0, 0.498822,0.00696773) , 
1, -0.823218, 1, 0, 0.502721,-0.0015527)    );
  // itree = 1909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282197,-0.0228864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664145,0.0052313) , 
0, -0.733992, 1, 0, 0.541119,-0.00639807) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.721895,0.108512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435709,0.0100421) , 
1, 0.704202, 1, 0, 0.466534,0.033598) , 
1, 0.576791, 1, 0, 0.521162,0.00430356)    );
  // itree = 1910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500034,-0.0122417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647365,0.0484514) , 
1, -0.55045, 1, 0, 0.517892,-0.00812814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348032,-0.0156809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568515,-0.0379845) , 
0, 0.724143, 1, 0, 0.423969,-0.0460596) , 
1, -0.39136, 1, 0, 0.459867,-0.0315619)    );
  // itree = 1911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588055,0.00612667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466809,-0.018729) , 
1, -0.725004, 1, 0, 0.520853,-0.0178704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440245,0.0481555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64353,0.0108089) , 
0, -0.424906, 1, 0, 0.557691,0.0480964) , 
1, 0.213099, 1, 0, 0.534803,0.00711026)    );
  // itree = 1912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359584,0.00418602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924263,0.0274207) , 
3, 0.611942, 1, 0, 0.468567,0.0136882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537879,-0.0241315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.872223,0.0108468) , 
3, 2.00192, 1, 0, 0.635287,-0.0379307) , 
0, 1.33181, 1, 0, 0.500541,0.00378872)    );
  // itree = 1913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526892,0.00472725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339661,-0.0449566) , 
1, 0.232449, 1, 0, 0.49319,-0.0129709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363248,-0.0337839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504328,0.0186461) , 
1, 0.715237, 1, 0, 0.482291,0.0202582) , 
1, 0.582445, 1, 0, 0.490454,-0.00462821)    );
  // itree = 1914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243896,0.000811856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.603572,-0.0261068) , 
3, -0.184188, 1, 0, 0.420725,-0.0237594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.737923,-0.0150551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.681645,0.0240183) , 
1, -0.55327, 1, 0, 0.700533,0.0267068) , 
0, 1.23253, 1, 0, 0.499775,-0.00950198)    );
  // itree = 1915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385678,-0.0067456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.755074,-0.0419499) , 
3, 0.918161, 1, 0, 0.445059,-0.0213807) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.804157,0.0258212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738227,-0.0124546) , 
0, 2.47109, 1, 0, 0.777111,0.0163148) , 
2, 0.988814, 1, 0, 0.502292,-0.0148834)    );
  // itree = 1916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.767518,0.0384629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380086,0.0155025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591743,-0.00195513) , 
0, -0.838864, 1, 0, 0.524852,0.00508611) , 
1, -1.94485, 1, 0, 0.533433,0.00763344)    );
  // itree = 1917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318771,0.0095859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400885,0.043753) , 
0, -0.735168, 1, 0, 0.343687,0.0399701) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637486,-0.0167036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768504,0.0139043) , 
2, 0.772338, 1, 0, 0.697885,-0.00684769) , 
3, 0.182571, 1, 0, 0.511926,0.0177324)    );
  // itree = 1918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175559,-0.0195111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298751,0.0148662) , 
2, -0.394042, 1, 0, 0.203168,-0.0191852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.698117,0.00508559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.828094,0.0464853) , 
1, 0.494071, 1, 0, 0.731647,0.0280956) , 
3, -0.210183, 1, 0, 0.501565,0.00751117)    );
  // itree = 1919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.775304,0.0452388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.654183,0.0233852) , 
1, -2.14416, 1, 0, 0.713832,0.0656565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493435,-0.00623301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5366,0.0305619) , 
1, 1.50882, 1, 0, 0.497249,-0.00571974) , 
1, -1.75262, 1, 0, 0.510737,-0.00127449)    );
  // itree = 1920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17679,0.0473656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347591,-0.0144591) , 
2, -2.11883, 1, 0, 0.336805,-0.0207212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.628995,0.0274533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710557,0.000572657) , 
2, 0.748818, 1, 0, 0.673472,0.0273473) , 
2, 0.161708, 1, 0, 0.487138,0.000743014)    );
  // itree = 1921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124718,-0.0346117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568473,0.00156562) , 
2, -1.29539, 1, 0, 0.514015,-0.0033696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307414,-0.0225427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508663,-0.0416303) , 
2, 0.465034, 1, 0, 0.35987,-0.0581358) , 
1, 1.05945, 1, 0, 0.488108,-0.0125741)    );
  // itree = 1922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0597178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423258,0.0213888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.676581,0.00151043) , 
2, -0.134775, 1, 0, 0.577461,0.0159501) , 
3, -2.24033, 1, 0, 0.557109,0.0132259)    );
  // itree = 1923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194046,2.93268e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107967,-0.0404065) , 
1, 1.1218, 1, 0, 0.175239,-0.0203737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.619984,-0.00524468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624776,0.0144401) , 
1, -0.807628, 1, 0, 0.623625,0.0183728) , 
2, -0.724736, 1, 0, 0.490876,0.00690155)    );
  // itree = 1924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405606,0.0258217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.618744,-0.0127368) , 
2, 0.0683626, 1, 0, 0.511277,0.0109413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13017,-0.0331224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591226,-0.00956195) , 
2, -0.618345, 1, 0, 0.417669,-0.0345854) , 
1, 0.215291, 1, 0, 0.472875,-0.00773566)    );
  // itree = 1925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509296,-0.00594113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45869,0.0267272) , 
1, -0.377471, 1, 0, 0.49597,0.00588519) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438499,-0.00907201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440711,-0.0492583) , 
1, 1.71443, 1, 0, 0.438715,-0.0225312) , 
1, -0.0229864, 1, 0, 0.469646,-0.00717937)    );
  // itree = 1926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350793,0.012197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511539,-0.01287) , 
0, -1.39981, 1, 0, 0.466482,-0.0143532) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.787242,0.0681278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880504,-0.00646928) , 
3, 1.47522, 1, 0, 0.852614,0.0406006) , 
2, 0.967384, 1, 0, 0.525298,-0.00598264)    );
  // itree = 1927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197298,-0.0352557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615523,-0.00200142) , 
2, -0.558031, 1, 0, 0.485329,-0.0257278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.643473,0.0727795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576027,0.0111637) , 
1, 1.1657, 1, 0, 0.598259,0.0619674) , 
1, 0.821233, 1, 0, 0.505802,-0.00982983)    );
  // itree = 1928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584104,0.00415518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574945,0.0288237) , 
1, -0.708263, 1, 0, 0.581775,0.0199471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31541,-0.039701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436747,-0.0105843) , 
1, -0.177536, 1, 0, 0.421017,-0.0289146) , 
1, -0.39136, 1, 0, 0.475144,-0.0124628)    );
  // itree = 1929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30923,0.009961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541176,-0.0236569) , 
2, -0.272824, 1, 0, 0.419143,-0.0123521) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562521,0.0280181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87997,0.00695654) , 
3, 1.51624, 1, 0, 0.702768,0.0430643) , 
0, 0.842728, 1, 0, 0.508644,0.00513502)    );
  // itree = 1930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172994,0.0128656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256707,-0.0323269) , 
2, -1.68904, 1, 0, 0.241309,-0.0423339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314597,-0.0162442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702954,0.00821387) , 
2, -0.183987, 1, 0, 0.607888,0.00565424) , 
0, -0.707105, 1, 0, 0.467886,-0.0126731)    );
  // itree = 1931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399222,-0.0478054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544827,0.0129229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467732,-0.0150131) , 
1, -0.854314, 1, 0, 0.484047,-0.019926) , 
1, -1.84449, 1, 0, 0.479851,-0.0245066)    );
  // itree = 1932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483098,0.0160165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328377,-0.0145706) , 
1, 0.17319, 1, 0, 0.409263,0.00217439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552247,-0.0346398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.91262,0.0092628) , 
3, 1.67583, 1, 0, 0.691197,-0.0480352) , 
2, 0.54983, 1, 0, 0.501247,-0.014207)    );
  // itree = 1933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43106,-0.000810784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705168,-0.0355668) , 
2, 0.673133, 1, 0, 0.472233,-0.0122821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.738107,0.0379258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705878,-0.0153703) , 
2, 1.6221, 1, 0, 0.729968,0.0510866) , 
0, 2.04933, 1, 0, 0.501882,-0.00499244)    );
  // itree = 1934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0609657,-0.0521568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.532741,-0.0105469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505812,0.0119415) , 
1, -0.962158, 1, 0, 0.511289,0.0138585) , 
2, -2.07241, 1, 0, 0.497191,0.00944613)    );
  // itree = 1935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436678,0.00415626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625395,-0.0676149) , 
2, 1.1498, 1, 0, 0.446908,0.000905756) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.793588,0.0520887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.925469,0.0231306) , 
3, 2.10634, 1, 0, 0.870177,0.0758126) , 
2, 1.46199, 1, 0, 0.478365,0.00647267)    );
  // itree = 1936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221285,-0.00962093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644067,0.0104107) , 
2, -0.724736, 1, 0, 0.534886,0.0119902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0647953,-0.00157587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.526614,-0.0370254) , 
2, -1.34577, 1, 0, 0.395503,-0.050448) , 
1, 1.25522, 1, 0, 0.51948,0.00508916)    );
  // itree = 1937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378463,0.0343611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.539066,-0.0132017) , 
0, -2.51654, 1, 0, 0.528297,-0.021661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574046,0.0299074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42011,0.00329217) , 
1, 0.106896, 1, 0, 0.450162,0.0178237) , 
1, -0.231192, 1, 0, 0.485444,-5.77585e-06)    );
  // itree = 1938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395777,0.00810885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596951,-0.0108881) , 
0, 0.426087, 1, 0, 0.478133,-0.000965314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.83863,0.0014204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.900237,0.0512306) , 
0, 2.6389, 1, 0, 0.869764,0.0678091) , 
2, 1.5256, 1, 0, 0.506943,0.00409399)    );
  // itree = 1939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458851,0.0032811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651615,-0.0244959) , 
0, 1.79844, 1, 0, 0.480474,-0.00101775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.832032,0.0271519) , 
0, 2.96715, 1, 0, 0.495077,0.00185147)    );
  // itree = 1940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133752,0.0195201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683493,0.0646913) , 
3, -0.991953, 1, 0, 0.335573,0.0643204) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200711,-0.0304761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725982,-0.00254419) , 
3, -0.10173, 1, 0, 0.610404,-0.0165022) , 
2, -0.478321, 1, 0, 0.516177,0.0112079)    );
  // itree = 1941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552699,0.000410238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484727,-0.0347027) , 
1, -0.918677, 1, 0, 0.522473,-0.0338695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230017,0.0432339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504654,0.0030074) , 
2, -1.30053, 1, 0, 0.463774,0.0152422) , 
1, -0.3195, 1, 0, 0.487203,-0.00435968)    );
  // itree = 1942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205748,-0.023941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13501,-0.0338445) , 
0, -1.12094, 1, 0, 0.179461,-0.0519076) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.908878,0.030437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730565,0.000327559) , 
0, 0.46235, 1, 0, 0.776957,0.0128603) , 
3, -0.00187935, 1, 0, 0.482367,-0.0190729)    );
  // itree = 1943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174324,0.00239999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383287,-0.028146) , 
3, -0.544901, 1, 0, 0.201834,-0.00562368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.778786,0.0315614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678627,-0.00228519) , 
0, 0.663378, 1, 0, 0.726036,0.0243872) , 
3, -0.28269, 1, 0, 0.535351,0.0134703)    );
  // itree = 1944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22361,-7.02644e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46675,-0.0336242) , 
3, -0.233084, 1, 0, 0.265671,-0.012957) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596306,0.0106396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.873971,-0.0109365) , 
3, 1.65382, 1, 0, 0.649895,0.0147321) , 
2, -0.443551, 1, 0, 0.500685,0.00397928)    );
  // itree = 1945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383111,0.00918278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593666,-0.022249) , 
2, 0.0233698, 1, 0, 0.466241,-0.00707476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.695411,0.0492218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.85919,-0.00380551) , 
3, 1.49805, 1, 0, 0.814605,0.0384305) , 
0, 1.61764, 1, 0, 0.52926,0.00115718)    );
  // itree = 1946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30996,-0.00778985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.56108,0.0125188) , 
2, -0.138862, 1, 0, 0.380718,-0.00383709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535823,-0.0236566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.92074,0.00970707) , 
3, 2.00432, 1, 0, 0.601675,-0.0421449) , 
0, 0.343668, 1, 0, 0.465678,-0.0185668)    );
  // itree = 1947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0625916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0369949,-0.0500477) , 
2, -2.00862, 1, 0, 0.0226237,-0.074954) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352308,-0.0125517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643792,0.00473239) , 
2, -0.0507688, 1, 0, 0.513746,-0.00569976) , 
2, -1.67066, 1, 0, 0.471852,-0.0116073)    );
  // itree = 1948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644839,-0.00155809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75458,0.0628608) , 
1, -2.00385, 1, 0, 0.719009,0.06888) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465709,-0.0440493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466137,0.00243127) , 
1, -0.632469, 1, 0, 0.466051,-0.0138136) , 
1, -1.31849, 1, 0, 0.496992,-0.00369905)    );
  // itree = 1949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118483,0.0075137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198326,-0.0320779) , 
3, -1.46496, 1, 0, 0.164974,-0.0339471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547266,-0.000337335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.882326,0.0299184) , 
2, 1.83921, 1, 0, 0.565078,0.00266606) , 
2, -1.13773, 1, 0, 0.497541,-0.00351418)    );
  // itree = 1950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426522,0.0306232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314128,-0.0222666) , 
1, 1.18756, 1, 0, 0.412966,0.0388725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.520315,-0.0205911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702492,0.00953392) , 
0, 0.426411, 1, 0, 0.646133,0.00131247) , 
2, 0.161708, 1, 0, 0.519106,0.0217748)    );
  // itree = 1951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422789,0.00928283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.895413,0.0531747) , 
3, 0.0210279, 1, 0, 0.699833,0.0671283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437362,-0.000799644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712703,-0.0260457) , 
2, 1.03974, 1, 0, 0.485497,-0.00985991) , 
1, -1.73691, 1, 0, 0.500204,-0.0045773)    );
  // itree = 1952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55809,0.00104079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416286,-0.0119236) , 
1, -0.637467, 1, 0, 0.465282,-0.0139699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507858,-0.00957157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506732,-0.0693891) , 
0, 0.715781, 1, 0, 0.507428,-0.0742255) , 
1, 0.906291, 1, 0, 0.471902,-0.0234339)    );
  // itree = 1953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400557,-0.000285009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.834808,0.0269679) , 
2, 0.323165, 1, 0, 0.577162,0.0206698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407869,-0.0122585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802995,0.0136425) , 
2, 1.08804, 1, 0, 0.457347,-0.0180753) , 
1, -0.362514, 1, 0, 0.503248,-0.00323216)    );
  // itree = 1954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487405,-0.0176539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490195,0.00774808) , 
1, -1.38259, 1, 0, 0.489853,0.00797004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452603,0.0804706) , 
1, 2.02743, 1, 0, 0.488336,0.012389)    );
  // itree = 1955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150643,0.0167181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360718,0.0733323) , 
2, -1.98566, 1, 0, 0.2558,0.0941841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425694,-0.024284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57047,0.00228144) , 
1, -1.7353, 1, 0, 0.557359,-0.000812956) , 
2, -1.63878, 1, 0, 0.536789,0.00566682)    );
  // itree = 1956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.067076,-0.0350894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303886,0.033346) , 
2, -1.94448, 1, 0, 0.271889,0.0405574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357163,-0.0222588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814219,0.00773216) , 
3, 0.661481, 1, 0, 0.572508,-0.0163972) , 
2, -0.704443, 1, 0, 0.499094,-0.00248825)    );
  // itree = 1957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503425,-0.0213681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483035,0.00234869) , 
1, -1.35892, 1, 0, 0.484858,0.000148742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.845024,0.00741146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.871573,0.0404778) , 
0, 2.4232, 1, 0, 0.85741,0.0464245) , 
2, 1.3621, 1, 0, 0.526919,0.00537326)    );
  // itree = 1958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392459,0.00691737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788978,-0.0128216) , 
3, 0.908704, 1, 0, 0.506121,0.00258367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430118,-0.0496826) , 
1, 1.70477, 1, 0, 0.503079,-0.00158326)    );
  // itree = 1959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161487,-0.00460819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767928,0.042708) , 
3, -0.353173, 1, 0, 0.310235,0.0159987) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.800751,0.00956204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636271,-0.0143918) , 
1, -0.759733, 1, 0, 0.681987,-0.016882) , 
2, -0.155261, 1, 0, 0.503711,-0.00111384)    );
  // itree = 1960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287271,0.0040831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701295,-0.0158253) , 
3, 0.194323, 1, 0, 0.470056,-0.0101025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.764848,0.0335169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64424,-0.0401554) , 
0, 2.90136, 1, 0, 0.741229,0.0306463) , 
2, 1.08804, 1, 0, 0.50725,-0.00451348)    );
  // itree = 1961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0658641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200308,-0.0175778) , 
2, -2.19055, 1, 0, 0.156056,-0.0550634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404768,0.0220853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.625519,-0.00296781) , 
2, -0.544954, 1, 0, 0.58514,0.0025786) , 
0, -2.22754, 1, 0, 0.533193,-0.00439976)    );
  // itree = 1962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49042,-0.0211313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.535666,0.016983) , 
1, -1.58672, 1, 0, 0.527273,0.0190982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364642,-0.0167576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861632,0.0197387) , 
3, 1.71339, 1, 0, 0.420632,-0.024535) , 
1, 0.0411464, 1, 0, 0.47623,-0.00178661)    );
  // itree = 1963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211087,-0.0252371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556914,-0.00538141) , 
2, -0.943374, 1, 0, 0.4807,-0.0195881) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323052,0.00160348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.718454,0.0247554) , 
2, 0.0362226, 1, 0, 0.481872,0.0244202) , 
1, 0.307447, 1, 0, 0.4811,-0.0045746)    );
  // itree = 1964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261139,0.062345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0461275,-0.0186611) , 
1, 0.032123, 1, 0, 0.135148,0.0282397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249725,-0.0365092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611996,-0.000473875) , 
2, -0.809832, 1, 0, 0.563332,-0.0119923) , 
3, -1.1241, 1, 0, 0.48786,-0.00490096)    );
  // itree = 1965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492815,0.0476311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234298,-0.018858) , 
1, -1.18314, 1, 0, 0.254094,-0.0244463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.704955,-0.0196085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592231,0.00752431) , 
1, -1.15254, 1, 0, 0.613089,0.00590512) , 
2, -0.457527, 1, 0, 0.481866,-0.00518922)    );
  // itree = 1966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228324,0.113387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0773551,-0.00407648) , 
2, -1.97789, 1, 0, 0.138332,0.0539725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251198,-0.0135103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734117,0.00617584) , 
3, 0.0592592, 1, 0, 0.521648,-0.00571424) , 
2, -1.63878, 1, 0, 0.495935,-0.00171041)    );
  // itree = 1967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105024,-0.0259412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683572,0.00413051) , 
3, -0.716903, 1, 0, 0.519402,-0.00395035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584676,0.0540378) , 
1, 1.53348, 1, 0, 0.522888,0.000771092)    );
  // itree = 1968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252451,-0.029173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140957,-0.00582449) , 
1, -0.0114188, 1, 0, 0.190198,-0.032251) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372242,-0.000129491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707662,0.0148587) , 
2, -0.142037, 1, 0, 0.58746,0.0181244) , 
2, -1.16796, 1, 0, 0.522476,0.00988403)    );
  // itree = 1969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406599,0.000237964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.774509,0.0315049) , 
2, 0.696078, 1, 0, 0.446231,0.00807654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546998,-0.0530143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.923858,0.0150539) , 
3, 1.86799, 1, 0, 0.730553,-0.0398864) , 
2, 0.988814, 1, 0, 0.501037,-0.00116876)    );
  // itree = 1970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.682591,0.0471563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624329,0.0147144) , 
1, -2.02599, 1, 0, 0.641491,0.0495921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54397,-0.0200726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503323,0.00493534) , 
1, -0.436702, 1, 0, 0.514018,-0.00294873) , 
1, -1.49648, 1, 0, 0.526559,0.00222039)    );
  // itree = 1971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427985,-0.0196096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.777376,0.0120261) , 
2, 0.854228, 1, 0, 0.503083,-0.0247327) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413889,0.00295451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.796378,0.0292817) , 
0, 0.597232, 1, 0, 0.553404,0.0247609) , 
1, -0.0270664, 1, 0, 0.526299,-0.00189787)    );
  // itree = 1972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0908646,-0.00337378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0696129,-0.0365754) , 
3, -1.69253, 1, 0, 0.0782223,-0.0353863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0715837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640878,0.000672195) , 
0, -1.81014, 1, 0, 0.654795,0.00595616) , 
3, -1.07337, 1, 0, 0.525032,-0.00334833)    );
  // itree = 1973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154119,-0.00172555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332644,-0.0487747) , 
3, -0.531189, 1, 0, 0.186075,-0.0258481) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579052,-0.0033778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702924,0.0227943) , 
1, 0.65094, 1, 0, 0.608031,0.00563284) , 
2, -0.696554, 1, 0, 0.493774,-0.00289152)    );
  // itree = 1974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514158,0.00148086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420265,-0.0165285) , 
1, 0.184102, 1, 0, 0.475563,-0.0113973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.729355,-0.0788429) , 
2, 1.9346, 1, 0, 0.481961,-0.0143113)    );
  // itree = 1975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391816,-0.0306466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764167,0.0173085) , 
0, 0.110345, 1, 0, 0.550248,-0.0174959) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357106,0.00393602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71492,0.0210511) , 
2, 0.0724854, 1, 0, 0.508513,0.0209162) , 
1, -0.741213, 1, 0, 0.520505,0.00987926)    );
  // itree = 1976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276807,0.00967429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.659696,0.0361526) , 
2, -0.353132, 1, 0, 0.403735,0.0308058) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.573262,0.0174303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679905,-0.0204755) , 
2, 0.324372, 1, 0, 0.648786,-0.0191963) , 
0, -0.00413718, 1, 0, 0.52183,0.00670885)    );
  // itree = 1977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359581,0.0387114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598363,0.00248796) , 
2, -0.876457, 1, 0, 0.554091,0.0167346) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228597,-0.0374708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463772,-0.00385493) , 
0, -1.57768, 1, 0, 0.408778,-0.0208106) , 
1, 0.522288, 1, 0, 0.507553,0.00471025)    );
  // itree = 1978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461019,0.000257036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.716981,0.0406143) , 
0, 0.884617, 1, 0, 0.484201,0.00833007) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.667005,-0.0210056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.969622,0.0393375) , 
3, 2.57444, 1, 0, 0.704282,-0.0281619) , 
0, 1.33181, 1, 0, 0.54038,-0.000984925)    );
  // itree = 1979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.625577,0.00879584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.541315,-0.0314689) , 
1, -0.9262, 1, 0, 0.586335,-0.0220949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498624,0.00806395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402323,-0.0189725) , 
1, 1.24396, 1, 0, 0.483337,0.00737988) , 
1, -0.459297, 1, 0, 0.518234,-0.00260647)    );
  // itree = 1980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253453,0.0328544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466114,-0.00751921) , 
0, -2.66949, 1, 0, 0.446353,-0.0082477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.789534,-0.00385138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.939564,0.0279654) , 
3, 1.71281, 1, 0, 0.897972,0.0246838) , 
3, 1.44308, 1, 0, 0.521568,-0.00276309)    );
  // itree = 1981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.660535,0.0546277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454445,-0.00884025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518445,0.0322914) , 
1, 1.2268, 1, 0, 0.462226,-0.0074989) , 
1, -1.86485, 1, 0, 0.472811,-0.00183588)    );
  // itree = 1982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256973,0.0229265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.580344,-0.00202332) , 
2, -0.662058, 1, 0, 0.498886,0.00737019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294317,-0.0150041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562269,-0.0323815) , 
2, 0.563675, 1, 0, 0.371844,-0.0413623) , 
1, 1.08213, 1, 0, 0.478414,-0.000482544)    );
  // itree = 1983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247471,0.00083987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579871,-0.0317378) , 
3, -0.024306, 1, 0, 0.309173,-0.00950241) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485179,0.0502499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.727603,0.00357356) , 
3, -0.168181, 1, 0, 0.705912,0.0160612) , 
2, -0.193206, 1, 0, 0.526664,0.00451151)    );
  // itree = 1984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579631,0.00489183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438481,-0.0412853) , 
1, -1.73949, 1, 0, 0.529291,-0.0235317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.600968,0.0214409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494448,0.00434042) , 
1, -0.319256, 1, 0, 0.532261,0.0202742) , 
1, -1.51196, 1, 0, 0.532017,0.0166731)    );
  // itree = 1985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263993,-0.00184195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318876,0.0547323) , 
1, 1.18756, 1, 0, 0.275561,0.0217566) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51345,-0.0104774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.608989,-0.03082) , 
0, 1.87908, 1, 0, 0.527826,-0.0269607) , 
0, -1.80149, 1, 0, 0.489021,-0.0194666)    );
  // itree = 1986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298039,0.00117209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.578164,-0.0136746) , 
2, -0.495857, 1, 0, 0.478971,-0.0165729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.966937,0.03612) , 
3, 2.62856, 1, 0, 0.491447,-0.0148801)    );
  // itree = 1987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0551457,-0.0121739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18731,-0.0264207) , 
3, -2.02926, 1, 0, 0.156128,-0.0397526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534472,0.00391632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.749125,-0.0296062) , 
0, 2.88999, 1, 0, 0.543696,0.00369326) , 
2, -1.16796, 1, 0, 0.483665,-0.00303622)    );
  // itree = 1988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173481,-0.0271718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472276,-7.77141e-05) , 
0, -2.47646, 1, 0, 0.442793,-0.00622508) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.840984,0.0764859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.896276,-0.00394442) , 
3, 2.26859, 1, 0, 0.869879,0.110606) , 
0, 2.55557, 1, 0, 0.470068,0.00123618)    );
  // itree = 1989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191436,-0.0147211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.558348,0.0250531) , 
2, -0.63928, 1, 0, 0.357469,0.00278672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259679,-0.0303673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72175,-0.0115516) , 
3, 0.467915, 1, 0, 0.599229,-0.0387182) , 
0, -0.106773, 1, 0, 0.478693,-0.0180247)    );
  // itree = 1990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233558,-0.023542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213633,0.0341166) , 
1, -1.44575, 1, 0, 0.215865,0.0326478) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45521,-0.0258041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.697057,-0.000329279) , 
2, 0.220276, 1, 0, 0.595599,-0.0250382) , 
3, -0.639447, 1, 0, 0.485505,-0.00831362)    );
  // itree = 1991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225508,0.0527472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344835,-0.013004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629503,0.00554907) , 
0, -0.281401, 1, 0, 0.498328,-0.00357358) , 
2, -2.15868, 1, 0, 0.490591,-0.000969307)    );
  // itree = 1992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231086,0.0321202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446969,7.93436e-05) , 
3, -0.645357, 1, 0, 0.29719,0.0363051) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576844,-0.00932616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.66921,0.0068423) , 
1, 0.351767, 1, 0, 0.605384,-0.00818664) , 
2, -0.67204, 1, 0, 0.525838,0.00329683)    );
  // itree = 1993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371565,0.00618806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.583948,-0.0133655) , 
2, 0.178688, 1, 0, 0.462054,-0.00560775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884027,0.0386266) , 
2, 1.86678, 1, 0, 0.476111,-0.00236453)    );
  // itree = 1994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448765,-0.000113178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725159,0.0345234) , 
0, 1.11881, 1, 0, 0.470061,0.00524339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.610019,0.0281737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.892345,-0.000561775) , 
3, 1.63848, 1, 0, 0.769606,0.0374301) , 
0, 1.63755, 1, 0, 0.52678,0.011338)    );
  // itree = 1995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0667331,-0.0496486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.685144,-0.00228385) , 
3, -0.852844, 1, 0, 0.552224,-0.0247978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.637898,0.0409754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445495,-0.00479475) , 
1, -0.302142, 1, 0, 0.48878,0.00981507) , 
1, -0.759733, 1, 0, 0.506785,-7.78662e-06)    );
  // itree = 1996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287134,-0.00127707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439645,-0.0255417) , 
0, -1.2522, 1, 0, 0.355582,-0.0233594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.701325,0.015587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.680579,-0.0282258) , 
1, 1.32658, 1, 0, 0.699393,0.0221672) , 
0, -0.11886, 1, 0, 0.527923,-0.000538461)    );
  // itree = 1997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.580296,-0.00345781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.522151,0.0155678) , 
1, -0.420852, 1, 0, 0.553136,0.0106664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180884,-0.0388535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617131,0.00046454) , 
0, -0.507012, 1, 0, 0.421596,-0.0315623) , 
1, 0.507094, 1, 0, 0.512459,-0.00239209)    );
  // itree = 1998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281468,-0.00158104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302149,-0.0441346) , 
0, -0.316179, 1, 0, 0.286145,-0.0247498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534213,0.0407872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757537,-0.00449613) , 
3, 0.382333, 1, 0, 0.692981,0.0159597) , 
2, -0.224534, 1, 0, 0.499825,-0.00336822)    );
  // itree = 1999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149008,0.0511913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502186,-0.0051351) , 
3, -1.77855, 1, 0, 0.48283,-0.00537054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695894,0.0519765) , 
1, 1.79828, 1, 0, 0.489784,-0.00221136)    );
   return;
};

// Clean up
inline void ReadBDTG::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTG::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
